/* 
 * Copyright 2000-2002 by Compaq Computer Corporation
 *
 * UCD SNMP agent extension for Compaq Management Agents (cma)
 *
 */

#ifndef CMAUCDH
#define CMAUCDH

#include <sys/types.h>
static unsigned long return_socket_number();

/* t/f */
#define TRUE			1
#define FALSE			0

/* SNMP Operations supported */
#define SNMP_GET		1
#define SNMP_GETNEXT	2
#define SNMP_SET		3

/* These are the SNMP_SET types, you will see them instead of SNMP_SET */
#define SNMP_RESERVE1	10
#define SNMP_RESERVE2	11
#define SNMP_ACTION		12
#define SNMP_COMMIT		13
/* Failure re-calls */
#define SNMP_UNDO		14
#define SNMP_FREEUP		15

/* Limits */
#define MAX_NAME		80
#define MAX_OID			30
#define MAX_STRING		255
#define MAX_CPQ_MIBS	20
#define MAX_INDICIES	10
#define MAX_MIB_ITEMS	200
#define MAX_DAEMONS		8
#define MAX_MIB_ENUM	20
#define MAX_MIB_BRANCH	18

/* asn variable types */
#define CPQ_ASN_INTEGER		1
#define CPQ_ASN_STRING		2
#define CPQ_ASN_OBJECT_ID	3
#define CPQ_ASN_BOOLEAN		4
#define CPQ_ASN_OCTET		5
#define CPQ_ASN_COUNTER		6
#define CPQ_ASN_IPADDRESS	7
#define CPQ_ASN_GAUGE		8

/* Access defines */
#define ACCESS_READONLY		1
#define ACCESS_READWRITE	2

/* Set results */
#define SET_FAILED		0
#define SET_SUCCESS		1

/* Socket number to use */
#define SOCKET_NUMBER	return_socket_number()

/* Buffer input for socket */
#define PACKET_SIZE 1500

/* Maximum number of mib items that can be registered, increase as needed */
#define CPQ_MAX_MIB_ITEMS 2048

/* Stack commands (used in two way communication */
#define COMMAND_DOWNSTACK			0x80
#define COMMAND_NO_COMMAND			0x00
#define COMMAND_CONNECT				0x01					/* <-- */
#define COMMAND_DISCONNECT			0x02					/* <-- */
#define COMMAND_REGISTER_OBJECT		0x03					/* <-- */
#define COMMAND_DONE_REGISTRATION 	0x04					/* <-- */
#define COMMAND_ACK					COMMAND_DOWNSTACK|0x05	/* --> */
#define COMMAND_NAK					COMMAND_DOWNSTACK|0x06	/* --> */
#define COMMAND_REQUEST_OBJECT		COMMAND_DOWNSTACK|0x07	/* --> */
#define COMMAND_REQUEST_RESPONSE	0x08					/* <-- */
#define COMMAND_SEND_TRAP			0x09					/* <-- */
#define COMMAND_COLD_START		COMMAND_DOWNSTACK|0x0A	/* --> */

/* List of MIB objects to register */
#define MASTER_CONF_FILE "/opt/compaq/cmaobjects.conf"

/* Timeout for sub-agents to get their data back to the master */
#define SUBAGENT_TIMEOUT_PERIOD 2

/* Command status values */

/* Keeps track of running daemons */
typedef struct SubAgentType
{
	unsigned int PortNumber;				/* UDP port daemon is communicating to */
	char Description[MAX_NAME];				/* Self portrait from the daemon */
	int State;								/* One of the STATE_* defines above */
	int MibTreeNumber;						/* Item in MIB tree that this subagent will accept request for */
	pid_t PID;								/* PID of the peer item				*/
	struct SubAgentType *Next;
}	SubAgentType;

/* Register a subagent with master agent */
typedef struct ConnectType
{
	char Description[MAX_NAME];
	unsigned int Handle;				/* On ACK, this will have the assigned handle to use */
	unsigned int PortNumber;			/* The port number that the subagent is talking/listening on */
	unsigned int MibTreeNumber;			/* Item in MIB tree that this subagent will accept request for */
	pid_t PID;							/* PID of the connecting peer						*/
}	ConnectType;

typedef struct DisConnectType
{
	unsigned int MibTreeNumber;
}	DisConnectType;

typedef struct AgentRequestType
{
	unsigned int Request;			/* SNMP_GET, SNMP_GETNEXT, or SNMP_SET */
	unsigned int Oid[MAX_OID];
	unsigned int OidLength;
	unsigned long IntRet;
	char DataRet[MAX_STRING];
	unsigned int DataLength;
	int VarClass;
}	AgentRequestType;

typedef struct TrapType
{
	unsigned int Oid[MAX_OID];
	unsigned int OidLength;
}	TrapType;

typedef struct RequestType
{
	unsigned char Command;					/* One of COMMAND_* defines */
	unsigned int Port;						/* Port to send command on */
	union
	{
		ConnectType			Connect;
		DisConnectType		DisConnect;
		AgentRequestType	AgentRequest;
		TrapType			Trap;
	}	Data;
}	RequestType;

static unsigned long return_socket_number()
{
  static unsigned long retsocket=-1;
  FILE *fp;
  char buffer[256];

  if (retsocket != -1) {
    //fprintf(stderr, "return_socket_number: return saved retsocket = %lu\n",  retsocket);
    return retsocket;
  }

  if ((fp=fopen("/opt/compaq/cma.conf", "r")) != NULL) {
    while (fgets(buffer, 256, fp) != NULL) {
      char *socketptr=buffer;
      while (*socketptr && isspace(*socketptr)) socketptr++;
      if (strncasecmp("cmaXSocketBase", socketptr, 14) == 0) {
        socketptr += 14;
        retsocket = strtoul(socketptr, NULL, 10);
        break;
      }
    }
    fclose(fp);
  }
  
  if (retsocket == -1) {
    retsocket = 25375L;  // default
    //fprintf(stderr, "return_socket_number: return default retsocket = %lu\n",  retsocket);
  }
  //else
  //  fprintf(stderr, "return_socket_number: return new retsocket = %lu\n",  retsocket);

  return retsocket;
}
#endif
