#/bin/ksh
optlist=""
plist=""
VERSION=1.2.0
RELEASE=1


# check whether the user is running as root.
# if yes then allow him to proceed
# if not then exit

User=`id -n -u`
if [ "$User" != "root" ]
then
	echo ""
        echo "ERROR! Please run this script after logging in as root "
	echo ""
        exit
fi

echo ""
echo "Welcome to the Compaq Interconnect Switch Management Utilities and Documentation Installation"
echo ""

echo "Please Select the Features that you want to install"
echo "Please Enter comma separated or space separated menu numbers"
echo ""
echo "1. Switch Configuration Tools"
echo "2. Switch Configuration Template Scripts"
echo "3. Switch Configuration User Guides"
echo "4. Switch Configuration Help"
echo "5. Switch Configuration SNMP Mibs"
echo "6. All the Features"
echo ""
read var
echo $var | egrep -w "1" > /dev/null
if [ $? = 0 ]
then
	optlist=" $optlist Tools"
	plist=" $plist Compaq_Switch_Config_Tools-${VERSION}-${RELEASE}.i386.rpm"
fi
echo $var | egrep -w "2" > /dev/null
if [ $? = 0 ]
then
	optlist=" $optlist Templates"
	plist=" $plist Compaq_Switch_Config_Templates-${VERSION}-${RELEASE}.i386.rpm"
	echo ""
	echo "----------------------------------------------------------------------"
	echo "NOTE: The Switch Template Scripts Feature Depends on the Tools Feature"
	echo "For proper functioning of the Switch Template scripts, Please ensure"
	echo "that the tools feature is installed"
	echo "----------------------------------------------------------------------"
fi
echo $var | egrep -w "3" > /dev/null
if [ $? = 0 ]
then
	optlist=" $optlist Documentation"
	plist=" $plist Compaq_Switch_Documentation-${VERSION}-${RELEASE}.i386.rpm"
fi
echo $var | egrep -w "4" > /dev/null
if [ $? = 0 ]
then
	optlist=" $optlist Help"
	plist=" $plist Compaq_Switch_Config_Help-${VERSION}-${RELEASE}.i386.rpm"
fi
echo $var | egrep -w "5" > /dev/null
if [ $? = 0 ]
then
	optlist=" $optlist Mibs"
	plist=" $plist Compaq_Switch_Mibs-${VERSION}-${RELEASE}.i386.rpm"
fi

# If Selection is 6, overwrite option list
echo $var | egrep -w "6" > /dev/null
if [ $? = 0 ]
then
	optlist="All"
        plist=" Compaq_Switch_Config_Tools-${VERSION}-${RELEASE}.i386.rpm Compaq_Switch_Config_Templates-${VERSION}-${RELEASE}.i386.rpm Compaq_Switch_Documentation-${VERSION}-${RELEASE}.i386.rpm Compaq_Switch_Config_Help-${VERSION}-${RELEASE}.i386.rpm Compaq_Switch_Mibs-${VERSION}-${RELEASE}.i386.rpm "
fi

if [ "$optlist" = "" ]
then
	echo ""
	echo "ERROR! Please run the script again and choose the right options"
	echo ""
	exit
fi

echo ""
echo "You have selected the following Features for installation/Upgrade"
echo ""
for i in `echo $optlist`
do
	echo "	$i"
done
echo ""

echo ""
echo "Please Press N, n, no or No to abort installation"
echo "Please Press Any other key to continue"
echo ""
read choice
echo $choice | egrep "N|n|no|No" > /dev/null
if [ $? = 0 ]
then
echo "Installation aborted"
exit 1
fi

pinstalled=""
pnotinstalled=""
echo ""
echo "Checking for Previous installations..Pl. Wait .."
echo ""
rpm -q -a | grep -i Compaq_Switch > /dev/null 2>&1

if [ $? = 0 ]
then
  echo "The following packages are already installed on the system"
  echo ""
  echo ""
  echo "-------------------------------------------------------"
    for i in `rpm -a -q | egrep -i Compaq_Switch`
    do
          echo "$i"
    done
  echo "-------------------------------------------------------"
  echo ""
  echo "The System will be upgraded with the Following Packages"
  echo ""
  echo "-------------------------------------------------------"
    for i in `echo $plist`
    do
          echo "$i"
    done
  echo "-------------------------------------------------------"
  echo ""
  echo "Please Press N, n, no or No to abort installation"
  echo "Please Press Any other key to continue"
  echo ""
  read choice
  echo $choice | egrep "N|n|no|No" > /dev/null
  if [ $? = 0 ]
  then
    echo "Installation aborted"
    exit 1
  fi
else
# we are in the first installation where no packages
# are present in the system
  echo "The Following packages will be installed on the system"
  echo ""
  echo "-------------------------------------------------------"
    for i in `echo $plist`
    do
          echo "$i"
    done
  echo "-------------------------------------------------------"
  echo ""
  echo "Please Press N, n, no or No to abort installation"
  echo "Please Press Any other key to continue"
  echo ""
  read choice
  echo $choice | egrep "N|n|no|No" > /dev/null
  if [ $? = 0 ]
  then
    echo "Installation aborted"
    exit 1
  fi
fi

# this will happen regardless of the response
pkgerror=""
for i in $plist
do
                echo -n "Installing $i.."
                rpm -U --force $i
                rpm -q -a | egrep "`basename $i .i386.rpm`" > /dev/null 2>&1
                if [ $? = 0 ]
                then
                        echo "Done"
		else
			pkgerror=" $pkgerror $i"
                fi
done

#
# Copy uninstall script on to the target system
#
if [ ! -d /usr/local/bin ]
then
   mkdir -p /usr/local/bin
fi
cp uninstall.sh /usr/local/bin/cpquninstall.sh
echo ""
if [ "$pkgerror" != "" ]
then
  echo "ERROR: The following packages could not be installed succesfully"
  echo ""
  for i in `echo $pkgerror`
  do
	echo $i
  done
fi
echo ""
echo "Compaq Interconnect Switch Management Utilties and Documentation Installation Completed"
echo ""

