#/bin/ksh
optlist=""
plist=""
pinstalled=""
index=1

# check whether the user is running as root.
# if yes then allow him to proceed
# if not then exit

User=`id -n -u`
if [ "$User" != "root" ]
then
	echo ""
        echo "ERROR! Please run this script after logging in as root "
	echo ""
        exit
fi

echo ""
echo "Welcome to the Compaq Interconnect Switch Management Utilities and Documentation Uninstallation"
echo ""

echo -n "Please wait while the script checks for installed packages.."
        pinstalled=`rpm -q -a | egrep -i "Compaq_Switch" 2> /dev/null`
echo "..Done"

if [ "$pinstalled" != "" ]
then
        echo "The following Component packages are installed on the system"
        echo ""
        echo ""
        echo "-------------------------------------------------------"
        for i in `echo $pinstalled`
        do
                echo "$index. $i"
		index=`expr $index + 1`
        done
        echo "-------------------------------------------------------"
        echo ""
else
        echo ""
	echo "Error: There are no packages to uninstall from the system"
	exit 1
fi

echo "All the listed component packages will be uninstalled from the system"
echo ""
echo "--------------------------------------------------------------------"
echo "NOTE: If you want to selectively uninstall, please run the following"
echo "command from the Shell prompt after aborting from this script"
echo "rpm -e <package name from the above list>"
echo "--------------------------------------------------------------------"
echo ""
echo "Please Press N, n, no or No to abort installation"
echo "Please Press Any other key to continue"
echo ""
read choice
echo $choice | egrep "N|n|no|No" > /dev/null
if [ $? = 0 ]
then
echo "Installation aborted"
exit 1
fi

errors=0
pkgerror=""
for i in $pinstalled
do
 echo -n "Uninstalling $i.."
 rpm -e $i
 if [ $? = 1 ]
 then
   errors=`expr $errors + 1`
   pkgerror=" $pkgerror $i"
 fi
 echo "Done"
done
echo ""
if [ "$pkgerror" != "" ]
then
  echo "The following packages could not be Uninstalled succesfully"
  echo ""
  for i in `echo $pkgerror`
  do
        echo $i
  done
fi
echo""
#Remove this uninstall script if all features have been
#Removed and all install directories have been cleaned up
if [ ! -d /usr/local/Compaq ]
then
	/bin/rm -f /usr/local/bin/cpquninstall.sh
fi
echo "Compaq Switch Uninstallation Completed With $errors Errors"
