Name:  aic79xx
Vendor:  Adaptec, Inc.
Version: 1.3.10
Release: 4
Summary: Updated Adaptec 79xx Drivers
URL:  http://opensource.adaptec.com
Group: System Environment/Kernel
Packager: HP Linux Workstations Group
License: GPL
Exclusivearch: i386
Exclusiveos: linux
Requires: kernel = 2.4.18-26.7.x
Requires: mkinitrd
Requires: modutils
Requires: grep
Requires: gawk
Requires: textutils
Requires: fileutils
Prefix: /lib/modules
Source: aic79xx-linux-2.4-20030603-tar.gz

%files
%attr(644,root,root) /lib/modules/2.4.18-26.7.x/kernel/drivers/scsi/aic7xxx/aic79xx_1_3_10.o
%attr(644,root,root) /lib/modules/2.4.18-26.7.xbigmem/kernel/drivers/scsi/aic7xxx/aic79xx_1_3_10.o
%attr(644,root,root) /lib/modules/2.4.18-26.7.xsmp/kernel/drivers/scsi/aic7xxx/aic79xx_1_3_10.o
%attr(644,root,root) /lib/modules/2.4.18-26.7.xdebug/kernel/drivers/scsi/aic7xxx/aic79xx_1_3_10.o

%description
A repackaging of the Adaptec 1.3.10 drivers for Red Hat 7.3 rpm
to include only the 2.4.18-26.7.x drivers, renamed with a suffix.
At the point Red Hat's kernel has newer drivers than 1.3.10,
this rpm can be removed and the traditional aic79xx drivers should
be used.

%prep
echo "Normally /usr/src/redhat/SOURCES/aic79xx-linux-2.4-20030603-tar.gz"
echo "should be unpacked into /usr/src/linux-2.4.18-26.7.x,"
echo "overwriting the files there."
echo "Then the normal steps to rebuild a kernel and its modules"
echo "would be executed, including rebuilding the initrd images in /boot".
echo "This RPM will not make a lame attempt to do this for you."

%post
# Change the modules.conf to use the new name
mypid=$$
/bin/sed 's/^alias *\(.*\)aic79xx *$/alias \1aic79xx_1_3_10/' \
    /etc/modules.conf >/tmp/m.$mypid
/bin/mv -f /tmp/m.$mypid /etc/modules.conf
# Rebuild initrd's
for kernel in $(ls /boot/initrd* 2>/dev/null | \
        sed 's#/boot/initrd-\(.*\)\.img.*#\1#'); do
    /sbin/mkinitrd --ifneeded -f /boot/initrd-${kernel}.img $kernel
    if [ -r /boot/System.map-$kernel ]; then
        /sbin/depmod -aq -F /boot/System.map-$kernel $kernel 2>/dev/null \
    || true
    fi
done

%postun
# Clean up the lines we inserted into /etc/modules.conf
mypid=$$
/bin/sed 's/^alias *\(.*\)aic79xx_1_3_10 *$/alias \1aic79xx/' \
    /etc/modules.conf >/tmp/m.$mypid
/bin/mv -f /tmp/m.$mypid /etc/modules.conf
# Rebuild initrd's
for kernel in $(ls /boot/initrd* 2>/dev/null | \
        sed 's#/boot/initrd-\(.*\)\.img.*#\1#'); do
    /sbin/mkinitrd --ifneeded -f /boot/initrd-${kernel}.img $kernel
    if [ -r /boot/System.map-$kernel ]; then
        /sbin/depmod -aq -F /boot/System.map-$kernel $kernel 2>/dev/null \
    || true
    fi
done
