<jsp:useBean id="XEUtil" class="com.hp.mx.portal.applet.utilities.XeJspUtil" scope="session"/>
<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session"/>
<%@ page import="com.hp.mx.portal.ui.MxBean"%>
<%@ page import="com.hp.mx.portal.ui.MxOptions"%>
<%@ page import="java.util.ResourceBundle"%>
<%@ page import="com.hp.mx.database.GlobalSettings"%>

<%
   MxBean.jspInit(request, response);
   loginBean.setLocale(request);

   ResourceBundle authRB = ResourceBundle.getBundle("mxglobal", loginBean.getLocale());

   if ( ! request.isSecure() )
   {
      String secureURL= "https://" + request.getServerName() +
                 ":" + GlobalSettings.getProperty("Login.secure-port", "50000") + "/";
      out.println("<script>document.location.replace('" + secureURL + "')</script>");
      return;
   }

   String logonButtonText = authRB.getString("login.logon-secure");
   String username = authRB.getString("login.username");
   String password = authRB.getString("login.password");
   String domain = authRB.getString("login.domain");
%>

<html>
    <head>
        <title>HP Systems Insight Manager</title>
        <link type='text/css' rel='stylesheet' href='/mxportal/css/MxPortalEx.css'>
        <link type='text/css' rel='stylesheet' href='/mxportal/css/MxPortal.css'>
        <link type='text/css' rel='stylesheet' href='/mxtaglibs/css/MxLink.css'>
        <script src="<%=MxOptions.URL_BASE%>/js/MxAppletHelper.txt" language="JavaScript" type="text/javascript"></script>

        <script language="JavaScript" type="text/javascript">
            var LOGIN_PAGE_REFRESH_TIMEOUT = 600000;
            var LOGIN_PAGE_TIMER_INTERVAL  = 5000;
            var refreshTimer               = LOGIN_PAGE_REFRESH_TIMEOUT;
            // value to hold what browser we're in
            var WINDOWS                    = 1;
            var LINUX                      = 2;
            var HPUX                       = 3;
            var id                         = null;
            var mozilla                    = true;
            var installed                  = false;
            var os                         = HPUX;
            var MOUSE_CURSOR_HOURGLASS     = "wait";
            var MOUSE_CURSOR_POINTER       = "default";
            ///////////////////////////////////////
            function resetPageRefreshTimer()
            {
                refreshTimer = LOGIN_PAGE_REFRESH_TIMEOUT;
            }
            ///////////////////////////////////////
            function doRefreshTimer()
            {
                refreshTimer -= LOGIN_PAGE_TIMER_INTERVAL;

                if (refreshTimer <= 0)
                    refreshToLoginPage();
                else
                    setTimeout("doRefreshTimer()", LOGIN_PAGE_TIMER_INTERVAL);
            }
            ///////////////////////////////////////
            function refreshToLoginPage()
            {
                document.location.replace("<%=request.getContextPath()%>");
            }
            ///////////////////////////////////////
            function reloadLoginPage()
            {
                document.location.replace("https://<%=request.getServerName()%>:<%=GlobalSettings.getProperty("Login.secure-port", "50000")%>");
            }
            ///////////////////////////////////////
            function p_MxPortalGetWindow()
            {
                var w = window;
                while (true)
                {
                    if (typeof w.MX_PORTAL_MAIN_DOCUMENT == "string")
                        return w;

                    if (w == top) break;
                    w = w.parent;
                }

                return null;
            }
            ///////////////////////////////////////
            function MxPortalCheckIfNested()
            {
                var w = p_MxPortalGetWindow();
                return (w != null);
            }
            ///////////////////////////////////////
            function MxPortalSetTopLocation(szUrl)
            {
                var w = p_MxPortalGetWindow();
                if (w != null)
                    w.p_MxPortalSetTopLocation(szUrl);
                else
                    top.document.location.replace(szUrl);
            }
            ///////////////////////////////////////
            function appendUsernameToDomain()
            {
                var szUsername = document.getElementById("usernameInput").value;

                if (document.getElementById("domainInput") != null)
                {
                    var szDomain = document.getElementById("domainInput").value;
                    if (szDomain != "")
                    {
                        document.getElementById("j_username").value = szDomain + "\\" + szUsername;
                    }
                    else
                        document.getElementById("j_username").value = szUsername;
                }
                else
                    document.getElementById("j_username").value = szUsername;
            }
            ///////////////////////////////////////
            function appendPasswordToIpAddress()
            {
                var szPassword = document.getElementById("passwordInput").value;
                var szRemoteAddr = "<%=request.getRemoteAddr()%>";

                if (null != szRemoteAddr)
                    document.getElementById("j_password").value = szRemoteAddr + ";" + szPassword;
                else
                    document.getElementById("j_password").value = szPassword;
            }
            ///////////////////////////////////////
            function myOnSubmit()
            {
                appendUsernameToDomain();
                appendPasswordToIpAddress();

                document.getElementById("ID_LOGON").disabled = true;
                document.getElementById("ID_LOGON").className = "mx-button-disabled";
                return true;
            }
            ///////////////////////////////////////
            function showMsg(szId)
            {
                var s = document.getElementById(szId).style;
                s.display = "block";
            }
            ///////////////////////////////////////
            function hideMsg(szId)
            {
                var s = document.getElementById(szId).style;
                s.display = "none";
            }
            ///////////////////////////////////////
            function checkVersionIe()
            {
                var agt = navigator.userAgent.toLowerCase();

                var is_ie     = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
                var is_ie4    = (is_ie && (agt.indexOf("msie 4") != -1) );
                var is_ie5up  = (is_ie && (agt.indexOf("msie 5.") != -1) );
                var is_ie6up  = (is_ie && !is_ie4 && !is_ie5up);

                if (is_ie && !is_ie6up)
                    showMsg("ID_IE_WARNING");
            }
            ///////////////////////////////////////
            function checkVersionMozilla()
            {
                var ver = 1.21;
                var agt = navigator.userAgent.toLowerCase();
                var i = agt.indexOf("rv:");

                if (i >= 0)
                    ver = parseFloat(agt.substring(i + 3));

                if (ver == 1.2 && agt.indexOf("rv:1.2.1") != -1)
                    ver = 1.21;

                if (ver < 1.21)
                    showMsg("ID_MOZILLA_WARNING");
            }
            ///////////////////////////////////////
            function checkCookies()
            {
                if (!navigator.cookieEnabled)
                    showMsg("ID_COOKIE_WARNING");
            }
            ///////////////////////////////////////
            function checkScreen()
            {
                if (screen.width < 1024 || screen.height < 768 || screen.colorDepth < 8)
                    showMsg("ID_SCREEN_WARNING");
            }
            ///////////////////////////////////////
            function logon_onLoad()
            {
                if (MxPortalCheckIfNested())
                    MxPortalSetTopLocation("/mxportal/home/MxPortalFrames.jsp");

                checkJRE();
                checkVersionIe();
                checkVersionMozilla();
                checkCookies();
                checkScreen();
                doRefreshTimer();
            }
            ///////////////////////////////////////
            function closeWindow()
            {
                if (id != null)
                {
                    id.close();
                }
            }
            ///////////////////////////////////////
            function showLogonScreen()
            {
                hideMsg("ID_JRE_DETECT");
                displayLogonScreen(true);
                setMouseCursor(MOUSE_CURSOR_POINTER);
                setTimeout('document.myform.usernameInput.focus()', 250);
            }
            /////////////////////////////////////////////////
            function setMouseCursor(style)
            {
                document.body.style.cursor = style;
            }
            ///////////////////////////////////////
            function displayLogonScreen(display)
            {
                var e = document.getElementById("ID_LOGON_SCREEN");

                if (e == null)
                {
                    return;
                }

                if (display == true)
                {
                    e.style.display = 'block';
                    showLoginHelp();
                }
                else
                {
                    e.style.display = 'none';
                    hideLoginHelp();
                }
            }
            /////////////
            function checkMoz()
            {
                // Mozilla - look through list of installed plugins
                for (var i = 0; i < navigator.plugins.length; i++)
                {
                    var description = navigator.plugins.item(i).description;

                    if (description.indexOf("Java") == -1)
                    {
                        continue;
                    }

                    var j   = description.indexOf("1.4");
                    var ver = "1.3";

                    if (j >= 0)
                    {
                        ver = description.substr(j, 3);

                        if (ver < "1.4")
                        {
                            continue;
                        }
                    }

                    // if we are on LINUX, we must have 1.4.2, otherwise, 1.4.1 is fine
                    if (os == LINUX)
                    {
                        ver = description.substr(j, 5);

                        if (ver >= "1.4.2")
                        {
                            installed = true;
                        }
                    }
                    else if (os == HPUX)
                    {
                        if (ver >= "1.4")
                        {
                            installed = true;
                        }
                    }
                    else // windows
                    {
                        ver = description.substr(j, 5);

                        if (ver >= "1.4.1")
                        {
                            installed = true;
                        }
                    }
                }

                return installed;
            }
            ///////////////////////////////////////
            function checkJRE()
            {
                setMouseCursor(MOUSE_CURSOR_HOURGLASS);
                showMsg("ID_JRE_DETECT");

                if (mozilla == false)
                {
                    // call this method in the testApplet.  If we get true, then we're ok, else
                    // a suitable JRE is not installed
                    try
                    {
                        installed = document.testApplet.isInit();
                    }
                    catch (e)
                    {
                    }

                    if (installed == false)
                    {
                        hideMsg("ID_JRE_DETECT");
                        showMsg("ID_NO_JRE_ERROR");
                        setMouseCursor(MOUSE_CURSOR_POINTER);
                    }
                }
                else
                {
                    if (installed == false)
                    {
                        hideMsg("ID_JRE_DETECT");
                        showMsg("ID_NO_JRE_ERROR");
                        setMouseCursor(MOUSE_CURSOR_POINTER);
                    }
                }

                if (installed == true)
                    showLogonScreen();
            }
            ///////////////////////////////////////
            function installWindowsJRE()
            {
                id = window.open('http://<%=request.getServerName()%>:280<%=authRB.getString("dl.win-jre")%>',
                                 '<%=authRB.getString("dl.jre")%>',
                                 "top=1,left=1,width=1,height=1", true);
            }
            ///////////////////////////////////////
            function getHPUXJRE()
            {
                id = window.open('<%=authRB.getString("dl.hpux-jre")%>',
                                 '<%=authRB.getString("dl.jre")%>',
                                 "top=10,left=10,width=800,height=600,resizable=1,scrollbars=1", true);
            }
            ///////////////////////////////////////
            function getLinuxJRE()
            {
                id = window.open('<%=authRB.getString("dl.linux-jre")%>',
                                 '<%=authRB.getString("dl.jre")%>',
                                 "top=10,left=10,width=800,height=600,resizable=1,scrollbars=1", true);
            }
        </script>
    </head>

<body class="body-flush-fit-scrolling-nobackground" onLoad='logon_onLoad()' onUnload='closeWindow()' style='width:100%; height:100%'>

<% loginBean.dumpNoLinksBanner(out); %>

<br><br>
<center>

<!-- Support to add custom prompt to login page -->
<jsp:include page="prompt" />

<div id="ID_LOGON_SCREEN" style='display:none'>
<form name=myform method="POST" action='<%= response.encodeURL("j_security_check") %>' onSubmit="return myOnSubmit()" >
   <input type="hidden" name="j_username" id="j_username">
   <input type="hidden" name="j_password" id="j_password">
   <table border="0" cellspacing="2" cellpadding="0">
      <tr>
         <td><%= username %></td>
         <td><input type="text" name="usernameInput" id="usernameInput" onKeyup="resetPageRefreshTimer()" style="width:200"></td>
      </tr>
      <tr>
         <td><%= password %></td>
         <td><input type="password" name="passwordInput" id="passwordInput" onKeyup="resetPageRefreshTimer()" style="width:200"></td>
      </tr>
<% if (loginBean.showDomainName())
   { %>
      <tr>
         <td><%= domain %></td>
         <td><input type="text" name="domainInput" id="domainInput" onKeyup="resetPageRefreshTimer()" style="width:200"></td>
      </tr>
<% } %>
      <tr>
         <td></td>
         <td align="left"><input id="ID_LOGON" type="submit" class="mx-button" value="<%= logonButtonText %>" ></td>
      </tr>
   </table>
</form>
</div>
</center>

    <script language='javascript' type='text/javascript'>
        // runs when the page loads - get's the browser type and loads the
        // testApplet appropriatly
        var agent     = navigator.userAgent.toLowerCase();
        var objectTag = "";

        if (agent.indexOf("msie") > 0)
        {
            mozilla = false;
        }

        if (agent.indexOf("linux") > 0)
        {
            os = LINUX;
        }
        else if (agent.indexOf("win") > 0)
        {
            os = WINDOWS;
        }

        if (mozilla == true)
        {
            if (checkMoz() == true)
            {
                // don't load this if the plugin doesn't exist - else Mozilla will
                // display a popup outside of our control
                objectTag = '<EMBED type="application/x-java-applet;version=1.4" '
                          + 'id="testApplet" name="testApplet" height="1" width="1" '
                          + 'java_code="com.hp.mx.portal.applet.baseapplet.testApplet" '
                          + 'java_codebase="<%=XEUtil.getAppletBasePathString()%>" '
                          + 'java_archive="classes/mxtest.jar" '
                          + 'scriptable="true" '
                          + 'MAYSCRIPT="true" '
                          + 'LocalJarsVersion=200> '
                          + '</EMBED>';
            }
        }
        else
        {
            objectTag = "<object classid='<%=GlobalSettings.getProperty("java_plugin_classid","")%>' "
                      + "id='testApplet' name='testApplet' height='1' width='1'> "
                      + "<param name='code' value='com.hp.mx.portal.applet.baseapplet.testApplet'> "
                      + "<param name='codebase' value='<%=XEUtil.getAppletBasePathString()%>'> "
                      + "<param name='archive' value='classes/mxtest.jar'> "
                      + "<param name='scriptable' value='true'> "
                      + "<param name='mayscript' value='true'> "
                      + "<param name='type' value='application/x-java-applet;jpi-version=1.4'> "
                      + "<param name='LocalJarsVersion' value='200'> "
                      + "</object>";
        }

        MxAppletHelper(objectTag);
     </script>

<!--  conditional browser version warning  -->
<div id="ID_IE_WARNING" class="logon-warning">
<br>
<%=authRB.getString("login.ie-warning")%>
</div>

<!--  conditional browser version warning  -->
<div id="ID_MOZILLA_WARNING" class="logon-warning">
<br>
<%=authRB.getString("login.mozilla-warning")%>
</div>

<!--  conditional browser cookie warning  -->
<div id="ID_COOKIE_WARNING" class="logon-warning">
<br>
<%=authRB.getString("login.cookie-warning")%>
</div>

<!--  conditional screen resolution warning  -->
<div id="ID_SCREEN_WARNING" class="logon-warning">
<br>
<%=authRB.getString("login.screen-warning")%>
</div>

<!-- message displayed while JRE is being detected -->
<div id="ID_JRE_DETECT" class="logon-warning">
<br>
<%=authRB.getString("msg.detecting")%>
</div>

<!-- error message if there is no JRE installed -->
<div id="ID_NO_JRE_ERROR" class="logon-warning">
<br>
<script language='javascript' type='text/javascript'>
// base message
document.write('<%=authRB.getString("error.no-jre-1")%><br>');
if (os == WINDOWS)
{
    document.write('<%=authRB.getString("error.windows-jre-ver")%> ');
}
else if (os == HPUX)
{
    document.write('<%=authRB.getString("error.hpux-jre-ver")%> ');
}
else
{
    document.write('<%=authRB.getString("error.linux-jre-ver")%> ');
}
document.write('<%=authRB.getString("error.no-jre-2")%><br>');
// if we are on WINDOWS, then prompt to install JRE
// else, we need to provide instructions
if (os == WINDOWS)
{
    document.write("<br><br>");
    document.write('<%=authRB.getString("msg.install-win-jre-1")%><br>');
    document.write('<%=authRB.getString("msg.install-win-jre-2")%><br>');
    document.write('<%=authRB.getString("msg.install-win-jre-3")%><br>');
    document.write("<input type='button' style='width:120' value='<%=authRB.getString("msg.install-jre")%>' onClick='installWindowsJRE()'>");
    document.write("<br><br>");

    if (mozilla == false)
    {
        document.write('<%=authRB.getString("msg.post-install-1")%><br>');
        document.write('<%=authRB.getString("msg.post-install-2")%><br>');
        document.write("<input type='button' style='width:120' value='<%=authRB.getString("msg.refresh-login")%>' onClick='reloadLoginPage()'>");
    }
    else
    {
        // even on Windows, Mozilla must be closed and restarted to reread the plugins available
        document.write('<%=authRB.getString("msg.post-install-3")%><br>');
        document.write('<%=authRB.getString("msg.post-install-4")%><br>');
    }
}
else if (os == LINUX)
{
    document.write("<br><br>");
    document.write('<%=authRB.getString("msg.install-linux-jre-1")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-2")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-3")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-4")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-5")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-6")%><br>');
    document.write('<%=authRB.getString("msg.install-linux-jre-7")%><br>');
    document.write("<input type='button' style='width:120' value='<%=authRB.getString("msg.get-jre")%>' onClick='getLinuxJRE()'>");
    document.write("<br><br>");
    document.write('<%=authRB.getString("msg.post-install-3")%><br>');
    document.write('<%=authRB.getString("msg.post-install-4")%><br>');
}
else
{
    document.write("<br><br>");
    document.write('<%=authRB.getString("msg.install-hpux-jre-1")%><br>');
    document.write('<%=authRB.getString("msg.install-hpux-jre-2")%><br>');
    document.write('<%=authRB.getString("msg.install-hpux-jre-3")%><br>');
    document.write('<%=authRB.getString("msg.install-hpux-jre-4")%><br>');
    document.write('<%=authRB.getString("msg.install-hpux-jre-5")%><br>');
    document.write("<input type='button' style='width:120' value='<%=authRB.getString("msg.get-jre")%>' onClick='getHPUXJRE()'>");
    document.write("<br><br>");
    document.write('<%=authRB.getString("msg.post-install-3")%><br>');
    document.write('<%=authRB.getString("msg.post-install-4")%><br>');
}
</script>
</div>

<jsp:include page="loginhelp.jsp" />

</body>
</html>
