#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BCU ROM)  - Linux-Based"
BIOS_VERSION="F.0B"
FILENAME="sp28009.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  iP00  jP0 L   ROMPAQ  EXE  jP00  Pr7/ I  HIMEM   EXE  &lP00  SV' D  8P4M   BIN  mP00  I0   8P4F   BIN  @x00  ڎ0   8BCU   BIN  (}00  {0   8BDD   BIN  RĂ00  ł0      8BDD   BIN  E00  E0   68BCU   BIN  U00  {0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
device=a:\himem.exe 
shell = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                    MZIU  @  b
   0X        M             E
      P  
  	  	  	  n	  Q	  h  B  
     E
  
    w  Q  ;        0            y                    y  s   	 	 	         z   W   '   
    E
																	|	x	t	p	l	h	d	`	\	X	T	P	L	H	D	@	<	8	4	0	,	(	$	 								 																																	|	x	t	p	l	h	d	`	\	X	T	P	L	H	D	@	<	8	4	0	,	(	$	 								 	 	 	 	 	 	;  ;  %;  ;  ;  9  9  9  9  h9  <  <  <  				p	X	:							h	P	2			 E
G  TG  CG  ;G  )G   E
U  T  T  T  T  >X  Y  2Y    ~				z  &                                                                                    3Ðj<ː
  F  F~ F F^:9 uvfv}fvfv~hh jFRPOVtj
fvvPl
hh jGRP"Vtj
fvvP?
 Ð3f>V  tf6V Ѐf>h  tf6h 轀>Z  t
6Z T*|Ð  Vh j%h jh jh  h 豆h Ȅ~F ^v&v& =d t -!  - tHHt-3 t_ H  F^v&v&8 (^v&v& ct^v&v&   P  P  L  P  J  >P  uP  |F  s-f t- t- t- tf6B jRP_jRP}jRP~}jRPn}jRP^}jRPN}j	RP>}j
RP.}jpRP}jWFF9F}-^v&&?-t^F&&?/uF S:=sjqRP|jVStjrRP|jVTSfh  j ]~V X V ujsRPf|j]VQuhh K|jBVQFF*PFPhh> ^fh   QZ uhhR |jU>N  tC<  Svt(l ! | 9 ~ =  A  E  I jJj1fj}h j h ujsRP{jU		t(\  t h   j ؎f&fbjqRPC{j:U>L  t>N  tT  R  H  >T t>T u& & & >T u=>P  u	>H  >H   >T u3P Ht	HtHt8j uwjJ
ulj?j.>T u?P Ht
HtHtHtIjj !Ȑju+jRP]zjP HtHH>P  tD>J  t=,?h,h,jv
>8 t jYRPzjIRPy>F  t7
j S;$  F >$ >L  t>N  tT  R  H  >T t>T u& & & >T u<~ tfj fj 'F  G=HtjH-
 -!- - - 
tEfE]
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >F  tG5L$ C= M- K- (-M- 0- )fj
>F  tj Q^ÐU	^&*&,Ð  F fh fF h   j ;Fu;Vt^& FFԡ h  j ؊F&Ð,".
Z hTh,h,jy>8T  Vfh  P FPw|f,K  F4ZhTh,h,j|y>8 t3^ÐFPrBFVhhx FPyRPhfhrhhx fvyRPh^ Lrfvh^ q ^Ð  FF	,".F4FZhTh,h,jx-*ÐU~uhhz  Ð~ hh h^ /U&(&u3f     8f6&fh  f6V V= s&&G
 t	SSf    f "f9b~"fh   RP6Z f6V LLut뉐f6&SO~ uhhz Adp h   j ءX +V  &&Wr h  j ؋F&  &Gt h  j ؎f&   v h  j ؎& 6l h	hz h  j RPy
Mfh   f6V vj 6Z KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h^ ?S&(&tj fbf-   fPf6&q
f6&jFP=q
f6&Bt~ uF.~uF6` 8Fua 8Fub 8Ftf6&QkFPh@Rf6&Q ^_Ð~ hh h^ R&(&f     	 "f f9b~f6&fh  f6V YR= j&&G
 ]fh   f6V f6 6Z I=t5fh   vj 6Z f6V Ip h   j ءX +V  &&Wr h  j ؋F&  &Gt h  j ؎f&   v h  j ؎& 6l h	hz h  j RPw
x>v tjJj1j f6h >wjhh n h   j RPv
6l h	hz h   j RPv
p h   j ءX +V  &&Wr h  j f&    t h  j ؎f&   v h  j ؎&  &  FF܌VF R   N   T   f,
S h,h,jBm
>8 u_>/@R Rf,N  f0    FޣTFܣ6hTh,h,j	s>8 t>-uN   hGNu~ tT   Ft
F$p*T Ð&  VFF܌Vf,D 6QCZ4hTh,h,jr>8 t3^F  FvڊB^& Fڃ~ | ^Ð,ZhTh,h,jAr>8 tjdRPo  fh  ! h	htjRPQF  @l +FHuF F^	&x&*hj*aRFl 9F}j vĈf<t<uhh EQÐ  = t= u%F  F~}
F_u~|3Ð Ð>R  u#jDRPnjERPn3ø x&hjQhzt
{u{Ð  DJ;fh  h@hf3t"jFQRPmjGARPmjt/RPmfh  uuj@RPm>F   2F hj
PjRPOΐFfbf   ffffN*+;B|;s<F*PjRPOj F*Pux&
h@h^ jaRPkOjTQRPjSGRPhh KOÐ  jF "hj
Pj
	RPOFfbf   ffffN*+;@|;s:F*PjRPNF*PGux&
x&
hj
}OjusRP!lju,j>WRPlj?GRPk>F  tlhfh^ j#RP-NÐ  D;fh Sh@hft"jFRPkjGRP}kjtRPkkfh  uj@RPKk>F   F hj
wNjmRPwMΐFfbf   ffffN*+;B|;s<F*Pj-RP7MjF*Pqux&
h@h^ jRPLjTRPjSRPhh LÐ  F >T ut~ thh hh FP"fhh FPyIFVu3vPfh  f6V pI= s^&G
 tF  fvDHO>T u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6V FP.F~rhh hh HFVtvPfh  f6V J= s^&G
 tF  fvgG~ uj[RPeKhh jCRPMKF*  F 6u3s+tt~ thh FPdjhh FPtdjRPFP_dhh FPGFVtvPfh  f6V G= s^&G
 tF  fvF~ tj yRPJ#.F~  F ohj
SKF  hj ?KFj ;F~x& ܊F*PjRPJf6V FP-FF~s#~ t~ uw&
tFPFPj!RPI~ u~ tjjRPIF  F f6V FPW,~uPhh hh KFFVu3vPfh  f6V G= s^&G
 tF  fvEFÐUf6V FP,Ð  F u3F F~s7F*PjRPHf6V FP:uhh Hhh hh EFVtvPfh   f6V F= s^&G
 tF  fvXDx&

hj
;IF hj )IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j\RPFP`hh FP0DFVtvPfh   f6V +D= s^&G
 tF  fvB~  j RPF8EF phj
GF  hj GFj R;F~x& ܊F*PjRPFf6V FP<8FF~s#~ t~ uw&
t~ tFPFPj!)RP3F~ u~ tjj	RPFF  F f6V FP7u3À~uLhh hh BFVtvPfh   f6V $D= s^&G
 tF  fvAFÐUf6V FPA7ÐU  
2

` UvV>
Ð  >
vVF*^&F^&  >`% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젪
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2(>( 	(  ThÐ(Ih  ~ t	h7FNuÐ  FjfvFP_\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fva`Ð  FPNQVRhh fv`vvvhh FP$`FPNQVRhh fvk`vvvhh FP_FPFP%[ÐUvSRP<[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvzZfvZF
^v&  FF9F|^v&  ^UVfvfv7ZFN^v&8 t&@ ^fj <fh  vfh   !jgRPf6B DZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0fFVRPHXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 9RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRP{V *+ȃQ *P%jj fvvvvv9ÐUj=fvh 8V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7zRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wjRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0#݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0~ڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0U׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;&}&F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F&Pv~ 7
F&F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6`FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>` tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>T uFPÐFP	>T u^ÐU>T uFP+ÐFPU>T uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHF`F`  F
FFFF  F9F~FF^v&8 uvvE~ u
F`F^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  l HPhFP
FPj hUF=
tK-
t
-.t-	 NF l HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàl Ȣh7ht\th7hِ A= t= ut փ>R  t fj hN3  F, ~ ujQFÐF Df>b   FF Ffbf   ffffN*+;<|;s6F*@N*, Sh8h*F*PЃuFu j h8h jЃ]FUtKjxЃh	h^ j hlfj hNG=th8hEtÐh	h@h	hf~&CIÐC&IÐU~ u h	hfjhVHh	h@jhV7F  F~ ujFÐF Df>b   F&t j h:h,fh  Lуu&, F Ffbf   ffffN*+;|;sF*@N*, &Sh:h,j F*PЃufj hl F; j fh  Ѓh	h^ fh  Ѓt"h	h@h	hfăt"fj hE
fj h0=uSh9hVt!h:h,ttfj htPU~ u h	hfjhVh	h@jhVF  F~ uj-FÐF Df>b   Ft j h;hBfh σu, F Ffbf   ffffN*+;|;sF*@N*, Sh;hjF*P,σu됐  fh σh	h^ cfh ΃t"h	h@h	hfUÃt"}fj hEqfj h0=uh;hVt!h;ht6fj htÃ>F  tj ht$ $   , ~ ujFÐF Dj ؃u] j hL=hhtF F~s3\ F*, j hL=hvFP^uF< j hL=hNhe>T utTetMFtFj t:h;hVfj h0=thL=htÐ  , ~ ujFÐF DF F~s-F*, j h`>hFP\uF< j h`>hlh또>T ut>kt7j hIfj hN=th`>htÐ  , ~ uj߃FÐj5փuÐF D] j h,?htF F~s3c F*, j h,?hFP|uF< j h,?hlhc>T utTtMdtFjt:h;hV3fj h0=th,?htÐUfvh4  \*F.fh. U Lfh.   Lj/iLFfh. ! hLj/RL~ufh.  NL~u
\N*OÐU*FP\P(L**PLÐU*FP\P
LF*P*PKÐ  >F u7-  FV;Vrw;Fv	F ÐFP
uh h UF  >F u
FPh iÐUF  >F u
FPh IÐUFPh 9FPh -j>F th UFPh FPh FPh j|MÐ  >H tRFPh FPh FPh FPh j0 h l<uH  >H u&v*N"FF FF
FPvB\*Ðb=tw$-t-| u)^  >^t% Ð^ -t-t t-0 t^ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U^FPgÐFPtHtÐ^	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  P h FF )fF~}j v`tFP  F~s#>P tFPh F  f+fF볐>P  F  `>P t(^&;^&?tP  FfF~|F~s>P tFPh ;f+fFҐ>P uKF~}Afh   j FV^& ^& h.P F 닐FPh j FV^&^&PÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h Rfh   FRPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uRPh Zj FF  	&f FPȃtFPh	hf؃~ thh:
hhF
FP4hh FPFVu3vPfh0  FPfvFPh	h@=ظ U؊FPfh  fh@x h\h<RPhGÐfh@x h0hRPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hyhXLNfh\  hZj 6LhKfhL8 h<hD  fh@ hh
RPhfh\  h
f6Lh
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB?
hxBPhxB0
F~|hxeB$PhxgBh   fhx OBF  F~
}Yhx'B$Phx)Bj2ԃhx
BPhxBhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx _?fhx P?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRvg1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&f FPRtFPh	hf3˃~ thhR
hh^
FP
'hh FPa
FVu3fj hvP(
fvfh  FPH
fv0	FPh	h@ʸ   F CFPPj/W'
~ u3FCFPNQQj/B-FN

 JÐU>J u3ø  
ÐU>J u3Ð 
Ԋ*  f   fFffffFFtF>J u3ËV 	
tVF  FU>J u3ËV 

  VF
^>J u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR $ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûN LËNaËLaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁ~sh3P1L!66ƱH6TV66gP6g
P6g6g6&P6 +۴J!6
+3	O3X 666661P.2Yظ RYP.2YۚD^  y>	uXP	 PR	 5!~ %X!	)&6, 		3	sx		 	&, >3&= t4
 pt3u!,Ar
,Ar
ª  D!r
t@Ky羼		 		 		 U3U UVW UVW.Q
u'
t z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	~ %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;puQVWp _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ LQP,[LYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVHFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*ct/ppPvvPvvF^&*cu^&?%t2XdVZ\T`3jfh~` uoF^*&ctfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt ct)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPctou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\cu̓.uMhhtAĞrr&.hht'jĞrr&pvv
cu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvncupVvvj u
T t nĞr& \~P|z\PZ
 P|z\PP^*&;tpVvv RT uInC-c = w..piBl
n
n
nokoooomBl4looioBlookooiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^ct$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvcu^] qqqrDrLrurrUwVW3FFv&vF
t~ }F, <Xw$ FF.\qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uu=CWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
XF
NFFt~ u	WTguF u	WR&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>J tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uGuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&L=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV(3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;lvJ;jvj ;s33󫖹 +v*39d	tvvvd	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6f	% uN&6f	&h	HȰ"Cu׍D&f	&h	% uDȰ"Ctd&f	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋj	tj	F3] UFu		u { rFGFF3҃vvډWNu(t$>\ uS#5!\^[#%!usʻ 	FV]UW .8tK
Il	]PPR.2Y؃> ul	n	w1uRUVV EE< u^F \F]ZXXˣ		UWVQS3l	n	 P	X[Y^_]ZXX˃PU츪	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ)$%!3]UWVRQSP.2Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH̋6		VW_^s+_;uX6	&t	;u~zt~z^̋t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;lv;jvj3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    	              4.52  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /!       = do not allow exit to DOS  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                          68xxx.BIN                $ ( , 0 # $ :  & ' X9  ) * <  U V (= Z [ = ^ _ > a b ? "  	 Y  	  D10/17/2001  O                                                                          *2>|:fDj4Fl|  <HPd|
$.:FTbr (LbT 		<	P	d	t						
H4
P
r
|



,Jd~Lx

*
                                  @    A    = e $	      >    ?    = e B	      B    C    = e `	      F    G    = e ~	      J    K e 	      I    H g 	      D    E    K e 	      (     ,    & h 	      O     L g 	      %    ,    # h  	      M    N     P   
Q   
L f >	      S    T    R e h	      +     ,    ) h 	      X    W f 	      \     ,    Z h 	      `     ,    ^ h 	      c     ,    a h 	      j    k    l    m     n     i e 	                 Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ZZZZZZZ               (((((                  H                                                                                                                                        
                                                     XXX                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                        MZ #           ?:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         #XMSXXXX0Copyright Compaq Computer Corporation 1989,1991                                                 T                             

Error HM21: Windows 3.0 does not support memory above 16 Megabytes.

            Add the /ISAONLY parameter to HIMEM.EXE in CONFIG.SYS.

$                                                                                                                                
. . S. G vO[Ct7=uC u=. u5.>  u.>  t%RP 	!X
u<u@.. %)Kr
AtHVWP
tcĀtrv
rw
.:&M rX3J.>  uH .} .>_  t.I .Q . . u	X33XP% X. .} _^RQSPV.Y .+k .Q =@ s.Y   .>_  t.Y  .b  .)Q w	.Q   U.>h  t-.Y  .Q .h +w3.Q .h .Q .b =  t 33.b .Q .>Y  t@-@ ..>W u.` .D 2.F .I 3..6y &. &D. ^X[YZ._  3&f 3&> VDu4&> ISu+&> Ku#._ &- &, t@.b - .     u.b - πuM..& `.a. .> t
` .A a.P.%.	X.6 .. =u.   .>  t.b - .. .>h  t.>Y  t   <@u.;t%.>Z t.>Y  t.;o r
 .Z 23.>Y u.Z 
t.Z   23.>] t8 t
.]   2ó3.>]  tX t
.]    2ó3Q.>X u+. .>O  tz u .A . u.O  2Yó3Q.>X  t;.>O  t:. 8 .>O ut3u .A . u.O  2Yó3Q.>U  t
 .A '..%x |3H@ t@2Y  3ø 2.>  u.[ .Y O s"ڀtGW_

и ó3 sڀ t	O 2ó3`.;d r!.;f w.+d 3ҹ
 u?uaaĀu:QVW33.d .K ?uwG;s2҃
Ǌڋ._^Y?ĀuQVW3.d .K u?u	;Wwu?u t u
u+t9u1D  DED+Euָ 2_^Yó3QRVWsX| uT| t-\D.>d .K =uU;tU;t
 2_^ZYÇTUT뼳3ĀuBQVs3| u+3.d .K ?t@
T|
t^Yظ ^Y3ó3ĀuQRVWU>ӳs5| u-;Tw`r 2]_^ZYRZtD+T>F>)F3.>d .K =t	
DED+EE TReZt"+D>;Fwt
>)F>F>F TwtEDt>F;v tt>FD>F EDtEDED&w&w
&G  &G  X+Dȁ% &G&OXȁ% &&OVWR.6Z_^MLD+TtTUE3VRIZ^tED&w&
3&O&O&O&ODȁ% &&OVW.6_^DEDDEDLM]_^YY\DT3.d .K V?uw;uuw;uu
^ÐUSQR3FFF&F&LN?\r r_FV^\
a rZFV^n^rG*= u@|,= u4^tO^tOZY[ ~ tH^]Àt^V&w&&t+tLG +rB+FVr2GG^ËǺ ƃ v~wr߃vڳΐ                                                                                                                                         |        3                               FVNv*,6<0HtPQR6.7.w.w.4.t.t&. . ~ w9NsNU ˺3 3ÿ|&؋3ۋ.F EEӋʋ
  
  ])Nt^ 6*, > l^ u>H t20.G.G.<.G.G.Z[X*,6H.G.O..W..GËЋ3d K ?uu=9?u4GG;r*;Gr!GG;wvw;s+u
t
E uUÌȣ
@H  Ā3 VWfPfQfR( f=  vf  vfZfYfXƋ_^fVfWf3f3f3d K ?t&fffOf;sf?ufff;sfǃ
fγft2f_f^Ā VfRf fZ^QVW3d K u?u
f;Wwu?u t u
u:tHfu?fD    %fPfDffEffDf+fEufXָ 2_^Yó3VWQfRfPfSsf| udf| t2f\ffD>d K =ufUf;tfUf;t
f[fX 2fZY_^ÇfTfUfTf[f[fX3ĀG QVs63d K ?t@
| tT|
t^Yظ ^Y3QVs(3d K ?t@
fT|^Yȸ 2^Y3Ā VWfPfSf f[fX_^UfRVW֋fӳs?| u7f;Ts r 2_^fZ]fRfZtfDf+fT>fF>f)F3_^fZ]Q>d K =t

YYffDfEfDf+fEE fTfRbfZt(ff+D>f;Fwt>f)F>fF>F fT\tfEfDt>fFf;v ftt>fFfD>F fEfDftfEfDED&w&w
&fG    fXf+Df
&fGfXf
&fVWfR6fZ_^MLfDf+fTtfTfUfE3_^fZ]VRZ^tED&w&
f3&fG&fGfDf
&fVW6_^fDfEfDfDfEfDLM_^XX]fDfTf3d K fV?ufwf;uufwf;uu
f^                                                                    UfPfQfVfWS3FFF&ffNfn  \  f^]
  ^[VW*_^=  3Ɏf
f6&gf4   ffNfgfgfggfXf&gf4   ,= u:^tO^tO[f_f^fYfX ~ tH^]ót^&f&t(sDfGf
f+r;f;r.GfGf
ffffffff= v೧UP    uB9Fu;~Ut~^u- . "W
 Î$"e
  3؎X]X]..fvf~f   f;NvfNfQ6>fFf&e>fFf&efYrf)NffNfN2.
 .;d r%.;f wSR.+d 3һ
 Z[u.?ufPfRfVff3.d .K ?uuKG?uBfGfGf;r5fff;Gr)fGfGff;wvfwf;sff+u
tE fufUf^fZfX= s.#þj
C.6.0.2R.4 .<.>	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t)R uMdI uD`@ u;>V  u0d0 u+%) u$d  u` u>V  ud  33d$= tr$ 
t$ 
u    3= t
r䒨t,&䒨u$3䒨t$3䒨u 3ËR?Z% ;u ÜuR ?Zu	 }  `@ 6 6  .A `  .q  ?퐐.q   2 ?at4 u/d+ u&d" u ud u
d	 u 33d$tR)Z ôr &&?PTu&Lu&Gt 33S &>P OLu&&> uf$<um  [ôr!&Gu&	t&u	3v 3Î&& =HPu& $u 3Ë9t	""S.[u.OU .w.O+ >A "   /"8!!  b" 8! "!!  ,"!"  ("`    t4>$ u?O   V 3A 1t.t'?1tt-9>V  tX  
À>9 tV  >V  t3>#W>#_     PSQRWVU.> &]
t~430.9.&9B ȎЋ3 .9.9Ћ.>  &E.} ]^_ZY[X. p00!0<rP C/2<tD 3= t9=@ sP.I u?.9 u2.9 . . u2H3B3.#.> &E
[i4+.[ rHYdrt .>C  t	.94r( .><u	.9(.> .#&E&M33 &. &D. Ü3PX% = t# PX% tt 
                                             3S.w &&Btk&Wtc&G+SP.D .F  .I .6s Ȏ G  DT .G 
tX[3.D .F .I .W  "X[&G  &G.6s .G  [03COMPAQVWSR+ u"&&Bt&Wt.I .W Z[_^VWQ.>u 4& Y_^ZDS CORP &.& u	sEE>E  E E  .I .W &D  &|
&D  &D  &D &D & &D  VW.6_^&|&D
  &DO,&L&D  &D  W.6.& O, ui>3R   .ZO, 3&D  _W&|
&D  &D  &DO,&L& &D   VQ.6Y^&D s&D_R.><u7.>W u.` 2.D .F .I 3..W  r.<Z0s3.+k .Q RQSV3rCs37ú@ .S .>9u$   @..6y w&. &D. ^[YZÌ.c
 .}.s ..-.6.>W u"VWQW%0 .>s % .>` Y_^.><t	!Q
 3YtRZ0!.Q . .  .S  .I  .+  .+h  } RP53Ҹ  ! N9v    |K9d.>h  t.>Y tg=NG.>[  t?i5>3Ҹ@  EH9-@5'.o =u@ Q
Y3 H9.>< t5. 3 H95XZy '=  tPRZX H953.K K K9K9ù  ts-=s( # ='s =s =d s =
 s PSQR+ك ~3Ҵ tu.!ZY[XPSQR=  tʸ;sP0!X
 3= wZY[X.# t@.d 
 .K .#.d 3.K GGGGG
.f .   .    rPSQRVW3Q Ys        | m  cQ؍6O,rIq,? q,5 6,e ! V3=   B  >9 ^DuY __^ZY[XS û&?EIu&SAt[Ê$y<tRL\ًDtH 2PS  :r;r[X[X2   @ 2Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C   `Ȏ3.- ar< r=.>.t3 3ҹ &<tr r
Q B$&[1.- Ȏ؎  ?   . .Q .a.-ÉEUu
%-`Ȏ3ҹ -  -3   --PXs4$ sBKua`3ێ..CCt;&$<t..3ێ..CCt&$<t< t.. 1aaPQR..Ȏ3ҹ .  -.3 - -ZYXð%pq
tt.d .K ?t
        
HIMEM: XMS Memory Manager  Version 3.06   
Copyright Compaq Computer Corporation 1989,1992.

$
Error HM1: Unrecognized A20 hardware.$
Error HM2: HIMEM requires MS-DOS 3.00 or higher.$
Error HM3: Invalid command line parameter.$
Error HM4: Cannot unmap the Shadow ROM.$
Warning HM5: Cannot disable A20
$
Error HM6: Cannot enable A20!$
Error HM7: Unable to unmap Shadow ROM - memory area is in use.$
Error HM8: HMAMIN parameter value out of range.$
Error HM9: LEAVE parameter value out of range.$Warning HM10: LEAVE parameter value out of range.

$
Error HM11: Available extended memory was not found.$
Error HM12: An XMS manager is already installed.$
Error HM13: NUMHANDLE parameter value out of range.$
Error HM14: SHADOW parameter not valid on this system.$
Error HM15: SHADOW parameter only valid on COMPAQ systems.$
Error HM16: HIMEM requires an 80x86-based machine.$
       XMS Driver not installed.

$
Error HM17: Move Block failure clearing memory - unmapping Shadow ROM incomplete.$
Warning HM18: The High Memory Area is unavailable.

$
Warning HM19: The A20 Line was already enabled.
$
Warning HM20: ISA memory above 16 Megabytes does not exist

$  COMPAQ Shadow ROM area recovered. . . $  Minimum HMA residual size . . . . . . $  High Memory Area available  . . . . . $  Total XMS extended memory found . . . $  Maximum extended memory blocks  . . . $  XMS specification version . . . . . . $ HIMEM.EXE is an installable device driver that allows MS-DOS 
 programs to access extended memory using eXtended Memory 
 Specifications (XMS).

 To install the extended memory manager (HIMEM), include the
 following in CONFIG.SYS file.

        DEVICE = HIMEM.EXE [Option]
 Option:
        /HMAMIN=nn      Sets the minimum amount of the HMA in Kbytes.
        /NUMHANDLES=nn  Sets the maximum number of EMB handles.
        /ISAONLY        Manage only 16 megabytes of memory.
        /LEAVE=nn       Do not manage this amount of extended memory (Kbytes).
        /SHADOWROM      Free extended RAM used for ROM BIOS. (386 or 486)
        /ABOVE16        Manage memory above 16 megabytes on an ISA system.

 If HIMEM is executed from the command line, the current extended 
 memory information is displayed.
$ KB
$.$/INT15 /HMAMIN /NUMHANDLES /SHADOWROM /SHADOWRAM /LEAVE /!SHOW /ISAONLY HELP help ? /WINNOISAONLY /ABOVE16                    ptlcascade att6300plus ps2 hpvectra acer1100 at                    .:Ȏ؎иB p0: u   L! C/=<umøC/<< E n ~<Jú>C 3  <S<*>$ 3X<ô <= tg=ú<=3Ҹ@ H9ô< t>tt	=Ãu
s; s8PRB>XP3EH9X_=  t m>3%H9}fPfSfRfQ<fY   fZf[fXfPfRB>LfXfPff4 H95fXf[f tm>%fff H9fZf[fXfQf
   f3ffYftfRfZ0!s=r<ô< t	=tú<u<fQ<fY f; ff	<3ô<R3=u}sXQX;|ȃ} Q 3R].!X
 ؁ 	
؃	 3R0X,Y        A20 line currently enabled.
$  A20 line currently disabled.
$
$  (Additional free XMS memory could be available for this system.)
$  High Memory Area available  . . . . . . $  High Memory Area not available.
$  Unable to report available memory size.
$  XMS driver not installed.
$  VDISK loaded, unable to report on A20 status.
$  VDISK loaded, unable to report extended memory status.
$  Total XMS Extended memory free  . . . . $  Largest block of XMS memory free  . . . $  XMS resident driver major version . . . $  XMS resident driver minor version . . . $  S.:33Ɋ  u Ȏ & >BB^ [.1Bގ6 &t
 >BB< t#<
t<
tg rF&BP3JÊ< tG<
tC<
t?< t8<	t4</t
<-t<?t)F& rF&B<<&:FWSQRS3Ҁ<?uF<
t!< t&?hs.1&B[	[&NZY[_<=uFt"r=? wt
u.o ú
2&B.h   <=uF~t-Sr(.;Q w=@ sm2;.h .[   ú<2&Bt<=uFk3trk= w
t.K ú
3&BO?<=uF6 r<oft<onu!/)Ȏfr
tr
.<ú|3C3&B  Ȏ7r
Er
.<ú|3C3&B .C   .<  .  Mr.9 =  t.<4&VQ  u<A|	<Z FY^SQRV
 33Ɋ0 |	wF^ZY[V3< t$<	t< t<
t<
t<0|	<9wF@3= w^P< t<	tNXP< t< t<=t<
t<
uXVP3ɬ< t<$tAX^WVQ3ɀ< t<
t< t<=t
&= tAt|Y^_P$p  q<1t<3uXXȎ؃:
6Ð999BBBW9_9k9v99P99999@@*A@Q@Q@YAdAoAzA                                                                                                                                                                                                                                                                                              	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]e&Hj 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'Ś1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,eT !"P.0S1t	C11(ppc1@%#9	,vInr÷ypD	Shut2l/down` P~ %0Ѳڡe K۷PIN: [5]Nxoq left0
ERROR
wY`ha߰A}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  fffft$ ISvݓV Q'  A  p  j~        > uk    T oj  gG W e M AY 9|@. 0D  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .h%v PS $<t4r w[X ȱ ЍRhf`? ^   	)F 9hh'hgfa ؾ  D 30"0r< tF1""!ؿz: @ WhJ#@߿EOV!1^ ?'Rp(!#!lfߢf&+U= r&j+=,=r,W>&_<uc.&z
&x&v
, fgh  0 pqr  <ABCDE xyz{|}  w *fs+PfSfQfR*R ,&7B r
& 7 7D0B77fZfYf[fXvSQV3
Ê^Y[&. t".FuN.PW#! _XUWfVUSW! &fv߿ h @޿RFA~2p@=,ك!IN@3d;^
u
t_@N_[]f^_SV ha2^[þo   RZF10=ROM Based Setup OKEnteringJ. `.> tj   KaRMPM 2NwtM+ 3P@1  p 艂OBQ	Q`NON2O^Kú !t
0N`Pt.ThǲPXhȳF12=NetworkJrvice BootWake On LANAttemptLto"Z 5Y\D]`3Phf޲t6Q r	QaM8
!tU AOJ4SE bb}rb6 a_ RT)dջdbb6bV3<^hkWrgs fuQVuNs	2Ps?SQWVRVtVuy3 NF 3؁?	uCFG~NootpGf`hqq"!v&hssfaZ^_Y[kkNotebook hard driveH]wMultiBayJ]DockLbJCzbz(top){|bottom)}|left@}wFlop}pz  USBρCD-QJH΁xDis\!SuperyNICHυj11ϋ23oߕ ?_ߞ ?_ߧ?4	Rppp	p
mppp

$B`~ҠJlect[DeY̹Ϳ߳͹U@| and [moxthe highlt[your choY.  PresscL[ose.Seconds until au atic defa`z start:   &<(d$'?;!ZipxC`t= Dr= k`d h S0ô0."!&t2
 1
I 23؊' tA<v<st1& 22
2Aʍ4	QYAr  A.
*РV `T+jjj(Pjf # b
z  Џ  AO  72g¸
   t02
32Ɋ  F8tF3 $ ZuqАq MURVQ0h.,.L.T^Y^Z]S.*[݁QSVW/ s&Q.<.-00?00.AAOY_^[Ys?}QBo
 qu hP⾲ t0t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}@o`2bXʱd ۸

r
;w2Ҁ`TJAA1ogFYô.*<W2W0? h' hf h( hS?i9,9 &i@ 6ff.fff63cP i<iif1B JCPQGysrPR#1 ZX .>?oh	ʲwfPS@  uǀuh3<tkB `:.> t.Ñ6Wf`+2f? dff_:
Qf @gf&=TDSSu  ff3gf_uf.>f^f_YPGQRW5Hr_Z@<PIVW TGI$tu!t쪃u ܺ&_^I6W_ e$ f3_=f@<`6(A[,  f$?#/#%aSWQR uʀePpq4,XZY_!1( hv&'у<.@3ɹ2 uhZ#-¼ P% = @uXu)-@haR4       P`  dЯ `7P7h7UT !X?  5	4   @@         ;  ? A0  =1=:,90 64  68 ?( 6*< .> 6bB_ `9,> :A8cBh@d@ fy95 !@FFF UFF!GqGGC 6 @4I. UaJ ;/J. pKGW. rKaJ0KJF. `KRJaKbLKNhOG6 NڑJN>O!LN IS0GNp9SaS%
SGaSLOp< SU$SaS(SCaSLO aS3S@taS`GOTN 4SFNaR`]heu<GDwBt Qt &&_@  _@_fYf8t*^ê^C_@_sl\&> tRc ~rE^(&~f3C hJg&}  G 1e < t&r cBcc3d&Idffgah@v\f3n2c*f& uf
ffKf&H&@&PfCh0AqYo?pPq]qUqe@r#q& r,\h`ր@!x !x&&#vSQn3r*`&&+&+@z zAr{AY[$bfPf fRfVWf93ffCf[fKfSF0rw!0cа K I+rn_0f@SQVW: u3_^03t3!Ŝf} @XM r;g7u'P fu"&hWXhMPRA U~fW Qt% s	 fU fff>Qfh%33o hqfpG g&; 9u}7)f)@f g&~/u!/u/u/u	g& x
ttx3OrwnfQǂ 񈀓@қEPf~/u/t ߀}	;^QGf &?ϥ/O oϮ/O oϷ/O o/O oƏǯ/O oϏЯ/O o؏ٯ/OoPAfUf.LPu hPS05rWrRrMPtffű@| pV t#Br"px#   / ' y> ?f]  fUr*6Б  R Z ?rGq9?Kuf] 
a~ rCF+ @g3cg&8E t@]fEGx #R~m r>U t04~Qh 9PPf&xW{ r^ r
  GC_>>?t$Aߊ?$wW밠w  _Wl  sq_  Q q0 ߰@B ?  3 S Sp' " 	P	j 퀳cAQ/A
?QWE
uptPGX_Yù
 d h/S&xs@
P <<uAbuĀ ~PR? ?50 < uZ0AD t	A50 60e\0#gf$fÀ<t <t,<t8 o\ffP〃$
"D
D$
#DDff#Df&f&
뿌T !t#a#!+P%
D%`&D&2'''뾒Sn h 2%l Z߇ }% ?H Eek I b% 0A h	 I
 g I `q
 /g 8f % g e   ,o pQ*i  *s H l e UA C B Н< j! 0M" ;k# ( )H$ q M% <N&P-j e* (d _ ; %' 0) ,u+ X, V- / 0 1  2 B3 Ok= > Pk? u@ kS A Zpp Qk5 %m %6 k7 7H9 eG NBH p: 4 egC Y%D IE hF %IPJ @D. K hL EHM sN j0XMP kQ R hV ӿeW hXP<Y AZ t%[ Yebc WJe fg P%\j" f"$ @ ؠ   !  f   3"t$" .D
PX% hX@ .X=X@u
_^r%YPvL
ظO!
N9OIPW;f&E1_XhUҡh/TTh,U%UT h+[vXv[ _HYZW X PQqR0> 3_YX%1hc{N[VZ2hZQX# _hЃw> &=tGO P$h}s_s	Q'W   ! $!f` T 'ew@uf *GhLҡ uϺOphh(?fa}vP&F XXfp	 ff3uf ` ? ppGX}޿Pf`! afv߿ hҡpt<Pt<pu2fa`3 zؾL &>v&DE{&&D0u>u dxzYy6z x~Yy6zj@ tBb}
Ȁ}	Ҁ>b33S[tS[
 }oאb2[sM3q ttohCߊcs
JhcawhҡD
Ͽ< DuL
p
E$<uЋD
@gsd
{#r& ufp}` uL
 J6 6ju9  Xb6d &uh`s	\
buEcG~ p eD&}?u  t&Eb t Ћ&E^DЋ&Efw>t6j t.&  t	&  t&xu	\	PSq P ?ЛR>_3& ?W>	_[Xt+t#  xt  t w\D@PV!$!"桾t#h1x6zqG&  ^Xŉhrr!L	pvTt
v߲`WŉV'Q$<v @u{<蹠a	3 v
p]
u$@!"<ul@!P>ȷX\PRt\:!1thG4!ă 쑹=oZX0
`2ҿRǿ& {t5ǖ=tOuŉ08 u	t!sŉ  ur
psa׿]3`Phs?b  V @u @}P^ 3f`G@f_Ebְb}`ʨAUAߖ  b ٛ&egWʃO&MuO OfGRtPQt$OQt,"t"OǋGErǾp}MoOg&ƴ誋P
"2haG_kרt<uLD8 =_7D D	 d
/zQbtSRPrG&}	r??23ืt`ha&Ew$	&M&]`.'	 %f rgt܀ϠUڀ ShF 
~|h}ЃQs܃]tR]Q]ZW&߃= uAPë)
hë6
 m}_P
t  U!w#w !#` #6h /.-.M!N0tI rJ/.58vu@L@B 0ghv'haW
$
{1gD hS
hYkh@[X_Ë
`PS@[X Sϲ1gHʥ0LR
`gZ,<u(fPfRfүffP	kf,ZJ vGu
pχ PS1g у[a$ @	 SQWf3< uf
<u	fpv@_``֎f翕tr73۹ F
t):u%RD	& h & 	 hy}%sx3'a]3 
3 b`* @ Sgt : Oiu jt`&`e [9 r6Q- r*܃0 &' t&f!l4+ \'q4q40
vAr'+ ^QQs0 0RkZt4?t hH% 4A1YQ?h[r=u(>% = t9@,YWV<
=p3+S6 
`HH1zE;&EEQ,E[Зr5 -0uS[_ u Ih-xf?D^!1Bq4 @߀u$PuR>uZDq4P9ObNNZKLP9ZKRWV 0  PhӂX@ @SaS)
AT'`W+2ƀBƐb?XC@h?r@DYaga+Ðbu,{uUPL
@q^

+&C32o3&Ut [aaT
t&
0  ⫰VccRd5  tTraaa-gc(0c,?
u7cdRd: >d8ep:rhdRd? fTw ^aPRW!*&weSAxp&]wp&U
t ˀA9r{]t_ZXRR3һ -w2C.To/TN  Vhӂw_ eS^{ v!~/Oo>u  '*~a ' $7m*fc$*f3fu 3? Q>@#:yuBE&8Uu8@]
R +B&U
ZKؾ70Z1VfYBegiqr{ړyTRjgtbUnʐĀR虜`Ãh}nXi
<t
tZ*ێûߋPpVPT^fX5D/
Y0t\ȑ/ޠ;==Uf`؎ Fw1:. ڎfafSfQf.+:ffff#fYf[VftGf   ~ :Ig f;t&fШ ژS	Fwf^ç`2r#ۈfaf`' &?faPޠ3_X.> :  .б/TACOF Q&ϴѳ	& .: Өj%BSnF5: fFf.+:`#:F./:f.>+:E./: t@!:ttY@":tNp о@SIVfB.qp;f;VrT%LƜܠi PQf{Rfff?fg{r.  :f@㼀.?ffH⼐#щfXfq4df3us?7Is*Vf+f;wfff33RmU':ߨ+^'R￪S=$.pQPɠ`333Ҹ  QW>FpP_F
3}5upJE#ȩ t0 t~0
 Ao `t
t} tWM_ }   F EF^V  SV^P0Q+&tY&_  
`< tr&\]&\U@
&mNd 
S؂[u8	F& 4F^[_Y3!F Fx*Ц}1)0
VW*ϋذp;' Fr_^Y[XWfQSg p-f^t
!p[fY_` t =$PGnPu2Mߋء#taË6Es } tp( ` j D&&E%oSRURQj@6^]ZpoV` x@`EE^X~p*F
 ' t#EpEyPEF EFE螻 d3duhZ6Ku`<Uuùd `6hj"4d&&;Xqtû   h9Ⱦn& hS/9PhC%`X!$!   °sukП'ё 
eh8n   t,t 4 a%h}Bx`# tKu#& &  
 eY `h~CsP<t<uV+u0$u?1R*`Ph0Xh4-10 % P2 v'@St[Z.s#3_ P柀X7/#@e)e+ t?8n8P:`} + `?G  Юs 3 gD1۹YpDÀ   ; Z x     0NP`^~$bhXn1fF3.mD$ rׁ 
0ވBFuр~2wFds-00
<2wd8F w(N8F wIP N@F ;t
 u@mF^KہsD.S~r@V»  aPTû< fPTyWpWfWf @ffRfPbf!Nv
 ffFf3fv1JZfFsfBPf{fП1 r9@`f3\pǿ:f a`faÒGfPV\3v޸rF3PX

S,0<	v	,$]F.[W D`

Lhfhi^ifП\
T
T k#l	#l
#lf_Cbf Ўfv@S D Po:FP
uf^fNfV_f^d5nPrRn0JfrPrVoVpLF Dohor`]Чbd
àff  fffffX_z4 o6f>f>f   f!!gfg`pC0G 9 @I% a<P*h	#P,SVW}0fQhûYÆ2u%q$th~ </_^[PRh>?? _(*U4:@D0 foQ   P h0/>ZXoRPSS3@0 ` ػ 7    Aӟpq$s q p3qð &q Āu̀t(% $t$ןu$`% 3ɰ<Ku{P;EhfC_0sC-$$dq - t+==vPP ZtP¯a XPہ?UuC33Ɋoђu uN~ P%8$ 3@!` Pf^ Xed&& &߃0t h,򿣶30 h
t[$ Ȱ t
$ŀv#t̰7蹰5؟PXav[B8v&> ߸ h`t`_ P3 $u $h)ĂDB
#ѲV艸sssn0L uf2h̑SZ!YuPźuK 
wAL2 Q ߻ hPu= Dt= tY	
輹Y.ƿL^! r@Bh)PfAB]s,Hu0<  QhU7He `vDBAB `01GrB	r<.߈M )(.M.Me.M;a `6MPrAV(< 
u^V d P ^(P*^` ȿ2v4ASP( 22X[úB $PQR  ZY /Oo/Oo8f~Nt`ρM00~ xripprakfL+  كpٻr$gwr/ f+D`f+\ r@ .Mh@fa`πM PR)3PR
`&Fa`ǀ uhC1PXh4 r.>M.Mpu觭xQR.Mxh f3f%  fwXURQSWF^
D=@H F\ ^0F\މ^t
;v F;F
 < uW <Rȭ22 IF ɿt%P%~%{빠% #8t
` @uPj Ѓ;}
+V 
N JZ=`uAN35_[YZ]`P &X&}`PQ^ kPYUkPk~`]]] +,-/?0_1234568?9uBރ6.u;v;0 >Rh *YRpQwLQRppf&YCCp&K??݀  R 3Yap$SRP!~?[pp$&%<GPs  	  o ѣt@  <BMtf3`z..&u<t{`ډJK K`F<LP20MIXxr
:IsRU3ȉMt.M!RfGenu fineIRnteluxCy=sn=r'=vp}%f2ft P tK  fG  p> =  pW	tŀuvrIr fZ@3t]5uZfDY $<@tK<tG`GF\H$u6fa_5 Zۊf Bf#\Ct] Bt	]wwf
!kff*` , 6 gf.ff0zh(a0A	SQRW3eP'Pt_Z"SQj9xxhe鳇Y`Ѱ؎V .BB <t BB2Jp&ݾV o  8uQp@`23Ұ
Sh9Ssit0`́ y autui at]U u[aSR  4
VZW[`1y-1V~0  hK	 hG|ah
 "B0ĜPaԀa$8uXRPMZ0QrtwvYu0ѹ }R ߺwZPhG U2<U@Juo䇿uJu󓈧tSfgff@ m h	Pu u
3Ҹ w%vv ؞
 sC)֞ uPoف>tD߹ A0@t߻07i hciܙPh$hpQk 0KBOП

e0  0:` PD&i &&g & & & & p0:tp @ѽVWێû0 ۾ Z 
 _^1&>r 4u=fSҰ`G  fÐ8f[P     f      o[ŭ@"`[j	r>@sХ  W ` ` 
  "# 
 Uuo 끵A t&r .s t kv; tհuָ0:`" a@3ЬffXfO  f>  <  vf6f) ' Iwf fнQf.Sc @!aA˖`;f݃t@ &|J}з~û{fr S# XP
8t"*eߩ t.xзy{ 0G5.з n21_ >  s  m@
AӁ.pG u	t Rϊ.O#52ޠ&  hqh_ ًP߸ hqh sSڱ Ф t>ar^h  ӳ f%Ћ"^ j j h^ XXX¡1uA nТSh{nh3[¡" tE2s \1|1x{0y t um1}/  tE䊿. ^0 
Ն0 {  t!E-@ y6&z6ct1@ tat atkS09pv%հ` D ^ sO(tӰ!RBж[SW&L 2U37ۀ>u
 ʟ0:Bu
>@upG>Pu>L rpL wf@rH0SVWU ]_^[s.L S&O  WQSL O З33ۃ pGt[Y_uݨ@u$BSd3` M-!f[U :tu
9 wpG"R t uL 2p_[WSPR`ZXL P5З6 &23 G&C2  &Ef d r&u&Ӂ54X<& GFO 6n	
@X$OO&2uG&2%& !Xߣ אpG[_Qh@B PAdı 0$+ `$= u_0$%t2jSRUfVЌňL f&7f u&Z&?Zu `* G&~!, &0:tL *>6  80t L "-2fs^]z0~VWf z@o  !XfA/3f0 OOf;  1oc3r_^j/WV p0H
^j`ࡎ31o8 `ePd DTDo   8Z|9 0  h`<w 8?l  Q >a (  >W @` >L H` >A P` >6T W X2=``` ><ؾZq0A顨a9|\D 9PiwS } H}H SdpHGKq[jg
u`$XVhd䰥!!4viO#! PPQWh53 3_YjR 00PQ= `t7 ѹ @fYX "T@SPnS
& X ff& X[t@ah  @/ pr  ÒnQhPA `A h`jfRf Jh	OF_f1hQ   h^X.&/ ^B <t. bi~? tq.$ri."D.|u.:DtSIfSfwD:fSfr5+zfSfs&fSfv
fuqfPfQdj
c4	m<ͼmm-pPQRau!&$`Ȱ hyczVSQW@a$a  hv hOvgw>xEw_52揺 TCwA6{ @|Q|C@p}4}@;uYð!桟$|ߴh|Üf`߻p3%xf`\ 3嚿]0Pu5faÚ3.mhppwF`
tIɽh#+
j1_;/Pf`  f Z6a_.FrA@=>:*&}t#Mth9~tb⿀ uu F_3!vd 嚺
  % 1~gV_WU_D-s s"h)rR(@ #U5sr& Ufr h򆥁Fw 6gf.fffh(rR@?fv3hcafFfP0K$aq3` Pqg-fX0 @ԥɆ faúv00] ]:
 K014%  0rU_ й`C]`a5x]u,ц' e!v(PDK`0XpP\W 3 .k3`"V Tp(ðѿd`Pdöt` E`a@QBZ]& <`s$3	 +0!,`, `&XY"Bw เx ]F``ؿ@VE&؁x uM9NwNVuӃ~ t"F= wt% @]+'Ã@@/hrǡ%r [s
0" Kz8Ѱ\ ]W@]5Ҵ`5h#sq@   !	 @dm a ð],ct5 t2D۰]U t tfЌ2f
 0㌁Genuu#fineIuntelu ~S`3Ҋst/.;t0E5_'aцXPÀf`fabW6f1Vg~f^` Cg߻ _k lsPx@|`p'2D h<f<``0 ƒTaPfPfQ^ރ0fZfYSRŌ  %=u`?2	[ñE `F_0 ( vf`x7r60z1rE2s1~*2s ri#بfaq7	tLxf   2n2<  C"%'~  B< WA(焛 3@ @urf uipA;3@.eW;on<#Ջ	/ s~@!D:P5uW%؀uޡChPrROtM	#$˒T%PjF_rX?`r  P5X@ATSQ 32PE%*lf`6	fJ,g a`RfWhw}3``
f6X  `"	  "	@P>% P3fP66XJ#8Aq6h8l6v7 g9:
<f<
8797f>f>8:8d@	:2ϻ U;sQSfAre@07@:2fƃ<tE0fXffA
 8[ffEY+vBq_L2_& uZ=PrUf%   uCf*Lf=M t0M t( f㺠qL@f
0"P`hDu)d l|԰ZQ%_VZ w$#8#t1V

36x @ h~CRF F h@RPwXt [[#] hn~
sళE"3؋

>at. h3@uKhc`І;.=9_ؤc׎V% < t<ut
u8ùXtq{䈰 ep2u  w & PPXt'v
t
t@o h9#% r/k hRPn>u` ohRs?q-Y&>! rtrwxRzsplZuthZ'uuh	r~`~	 `{'Zjj 6u`S`` FF ph ru
Vu@ uVv  sπ>t !$!$< uwC` _
N<̣2<ģW	$ܣ"3`{Aʄ7ru1łxd[@@TYP=`ht u
uP2Ɋ، aȎ؊dt<u
uȵsϊE$<u&w _$ėF"L  N L N  ǻؠu û  t  P؄[ErÐu
xj OjɄgIh(!!2(<!`[Z6 P_suu$e0|t|$+|~=|.#KU .t4&^ t<r&.w 3.\  Uv.\Er.d b  0 W	x .|_@DuQ&~% PXPXӹ
 z.:t
Q ._
vXP%8Xr6%ȸRƴ {Er    PJNL p      QKOMp @{t  t P(.DG H hC؝csuUhu huŒ AE^  ~f  Pp m o 
v %&.|t&ư
߲&r"܀o͹$.:Dt1|Ku
؄ Er(A@+" s	ErXò&P 3C  H rr`2sph!
dڰvېEaVRQSh~cuTh,5JZ.@68u,2
t&6@@t2 s `[YZ^SoûP*C,<?tFhJErjjjj Pf &hߴq\ {hzcr$&bt = ;t= Dt
hG'[1WVSpɀD1
M[ Qu"1*׿Oطh<C_t`>J=Ot1 k0ЖT;( rhP0=sr7^3Rm0YΠ!lYZs:^ ]Q%[ SZ^t-$p<pu ʄ7rZ _4 u1G ohR
 0V÷h:Zt<÷~Euhe1RZ? ?m  Z 3aaav8af'  u@"t@"3P&&W
Xfu33ff&3 uFȋUm'0hxL  5[Q?  :NQ2  ?AQ%R 	
1rOF D@0ǋVW 2_2F#t"d2p
u
2 
 @2E#2&&&E"&e?
td&Ep"&&Er$"E%&E<r&}	r###VW^2^2*#
&?}v'h}ƾPRQ3[7,
p%,_t.1QY3mRPSQY[XZhk$um
g@hv2ľ > EUQ TUX/Yp[ev}-7r: tO6VTr8
*6rh5&&  t8V\t' ou u⧐,6rnBuw6}$ $ r`& && pBA`d|d=e`P`  XσmU @p
ڹ  .u BdIB把8uGKwAK;Kw5K/K)K#CIBKINNu66rP濄XH G@ApSBpSCpSSSTÜV\twv2v2Ȱv2蝊`<;weċSYX؊H<wM3ɆQ#"XR< r[YƊȊĴ3Їуڕ^.8h@W`_WIhhu@tJ__	]_2_&2bPwk 2F	wf&. B"A  &k !< hPiu$f&PkBlÊ$
òۿ 3u%qpbuhsߡ$档"&=@Pf  f#f#f#f#f#f#f#0GfPfSfQfRVW"hfF&	Lx2Uff
fhzf3f3ɹ of0~Q f+f ! KFu*Fآ{$b3ہbsV4C\`ѕ a^p_^fZfYf[f03hPF
  !)`=3htKÆߊ?q1tu*Sٛg twt	t<ЌuG⻹ D
  u| u
qt	 Da=`	2= 揀 >`s< |&	3yt`u΄<uq  -&=t
ci?4KBC Kernel: xx.xx
 /x`pj z?hc) t? p.`83۸ 2ҹJ%mPaÍ6r'!
>z[VWQء
  _^t h3n;r Or	. f3hh.. 	hftdv t
=h ?gS=ChVS =  t]bwX,s.>
Gpطfѓ= t% u?? n > Xsc Fdef Fc~cll7~e uQC9  hp|
0 %ƿh BFe:Ff`{r, h Fd@;  ṧ 	:  <g! htm%mh"Caf`WgpKh u>ofB  mSCA[t$  h4N rpuΑ@0f`޾   F^/PG XSĻ  y ,  o   h[t(t@tW,a 2,q ' îh9
=úߋw2."э**q/.urr+Ë؀q/U2NfQdYF :uE10]ñ1t
t
u
t#u
tNt?"FF!u3! :5tFFdz ulmF: uYTeb +΀u?6F1setnFff`$<up  jjj(j	Rf 	ſaURdh2    G hSZ]xRKZr@  t0@C˿RQ QKYsY2{=$
a _!u$2q5sZpf`L.t)@3*s! ƀu.> fa0`ǬRt9k m ltn QPigP sE" Q>Hh	óкHrhSo 1p +%mQ#B Z5.uQt$<u:ߺ1pĝr"&  t2 t2 t`  QθIYQޘpat@SQ #u,S.[r5	z1[C <ff<F`00xx00`6xavx||&>>[Pr$.{ R)tR)H~_ r|48c'KG 7<7uw &T2h| d@C  E !rBo uNa DO /@0r03=mvA 3F o7Vψ` aUfVR3vCDPDQD ?72=f^]>ӰBռմ`՚!PduXfLc@ ?m 'o#$%&'VT  ".. ~Yf%pYɕЫxxFACS@\\O`4xDBGP4^COMPAQCPQ0058 !_xbRc^  8R  APICZ?bn[c"__[!_x x i		x
 _]Pheaicx	 xxtn nn(unpdPi^
 2R` RSDT(e  %cf`ht3{hB4vvf  fyDf l  gfFgf s yFPTR ffPggFxfu.y^$~..蕀f.偿tgFmwDayNy~$f+(h%3lbqqc4|3ffgf&f.>f0ff(.{t}2p x ~( N g&F	 y   rg#fffff+f+.앢} u4f.>fn$$ѓ$0P Xff-Q|ñMV3g&fFgf^fY[!ff=TDSDt+St#PtSBStf=CIPAtf=PGBDtBQQr$< urLbMRUfQъ̓2 twS`rDr vgw;Aptg&P.XJfY8]QeMfWfVv f&߀fw.v@Їl@f fPq)VȀ$ 4 
{ O@-O@ff	h΃$ pf tૺ=ƬhSfPW %fX ԄpF gfnf. _ z԰sg&Ph5w`n@(Ɛ_Q5uMV 	 urzf  f(u@|Dbi ^QPSQRW D hS'Q {h_ZY[EPSWtSPP3h f&L sfu@p L fX`Ċxشh4v" 03f(0&?  0 6u_  ` 0OGfa3ۦ[ɾ P@ʭ1U1  Pʈ >ٛ&geE E uMM0GfEBtXAt$OAt32 O$fMo?rþ0mMe&a\Qа   ø 芯 bW f
(hc ^ttտ ϥƿ Υ ܰ_h ێË̌ҎӼRQ_YZҋhCf`FF  h)v4v ]up} h(c w$w(w,w0w4w8w 㿋Ã9FtFfNF> hvɀ55(fa`Cx@VEp13ɊMhGQt

hsQj;rVuaMWF ^@f fN`Ѹ %Nf.95qu 9qt_( rfQPH_rf;^uf;Nt7~fAit
tF~YL_Q f0V8% t> &g.<t1!vտh\,,׃ ^_pP	E00 u,h]QF..D+hZCVWSR
, ff.߭faZ[_6M!_fntAﰑ"p  u
3A  t'gf@GhGCG$<lDPe PC Card SmartReaderGEMPLUS GPR400PSCR b !LB REFLEX 20!241 PCMCIA!ƢReflex $ Wv.2T%c!r$&HP%  a@g&O ,?Gd uBq,`, ȳ rLfK s\r>q,G	 .Da
q,P1O@.d.D~~4fƱ._ PQWϡ 0`
G.g&:uG`/␷Y.56_Y{XÁ8t F`/⑗fWr,0@gTH00
000e00w#?G f_\C` S [ u#x _ p@@u- .u  Ў~ro&ti`Ft^& rS  r&= us5=
qHr.r3.؋VpH< t ^oJs 
t u v "'  hǓhCw 蹻N-Z%h}Oa1@EqH6rP~HtI	Oy 
|OpH
HtQ&0OOGYgR V
NOz? P+6[E؍vf fDb] +A xfLs-<_t(<T#0O{ hOL?^032t
t
u
hVStrt
<0r<9w*tM> wXSQ WY[,0>E*SQgYX;| !ctdu$f`3pH& thYX֎fv𲿊Khsgf9t aR20o  o tGhY\n0^ogfuVff3E "yRzwf@of!
Z޾?e3۹: 8tCbbP #trvAhcsf wu    00 ? 0    0     ' '  
 ɀ/ %bFk07ɀ kws~ɨO_.PBVW pz׎Ǎ~Qr&} uBr	:_^Rr52r!;r8E@&=u	ЌD؎iHr&E$_us5öɩpB@@ӆΎޓ|rƠrapbR@DTtr?&etos`
T#
D/YnSыr# t itct t$ybffL  +]POG2uA3!]
Ϫ  @@+ჿW}z r8uAK_QY_þ*aL[ r&Unþ`N$L3®
P|$X` $2LpnB}Qp<t{HP88u6
uB & DBlTt
oPa0 3 r/) r%BB J
rP;  5 aù<t
&BȠJ ޢ@u8` BŵI2?2<u+B9tl&2]ȁ8uC\m ri@e raPv rYm0 tAa> f r2a r-&~$vQQ> Yr	{2QimGY P߬B ѰApBr0ӡ          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$%f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t
2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2cpPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{< fR fZG z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSS RLOfMUPKOSOLYZXV>YPsZSP[SfTRXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` ~( p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tϰk f_TCM!p߀MQfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c ~`b a >r i  f}0 c j !f`hktphG6'`  0 `%;`0MWff `_p
t_nfnf
f`aV'WH#gSik}WԒ ;_t[lPmF?[_^qWp!f` f8u cfffGofY2haܘPC
XPS fS[~s$fR$ f_fX$[ؒfӟRq1%D Ð[џBS22EޠHr'} Yuf H8s֊Ҋ
XQ iRP
t0kr?r#bEE  uf }úM % UPfPBTZ+]fa_f]rffr%m?&nѨ@..%f [,SfE.80@%D.%Ч!,=dr!stR
"誱_ 	f^ i
w tv;|苒*f`dk 	w1BcAv *)u6	B+	gf;N`f f{| 	Bg✯>?b>?fUf3Ա]qUfŽ`&С證` 
q\N˘qJN~ov"xof@Tq3pvbM*Rff> fPDWB< tG+Pf _te3ʱ
rI $PPP%tt0f薱vwV1Dةq|us%ɬష^ r?	gBc`Pr&U 
0  +؋ذ!LP Pc` 5
'|Vt^Ô0f.RfJZRUQf fuffVfKr=XfuNVFYQku F{MuY ^Y]gs><afPRg'QSVfNVFf߸Lx^[YrfXftA/3PX1MMNAO5P>hUWVa spP  ֡ Qa_]`phWU*2vq! ]BpXRV 	^Vmc  	o	 /
Oo
 /Oo/OQ%`S[PS3+[
uXa .hW_`p&
 	u
 tw"觷hsɄ3ɺ蓷rñapi%u3t q(=30K)KfPAMS 1hVW  ЎH }  $u
  P~0,  t`%ʆ rr vo F0 & O1
 30&O՝a0˱071FUWn6_]v
 @2`G_^`p$%%gcap+Wp_7fppw h؃-n; MB RW -!f D  1V&FGv.uv p cP$u#' F? x&lB
;uβBf3 CfuB& 3?_ B?GF< uG u2D %|p*<ð I$-w4"r.-@Ku4 $
 -ְKr؊B*fQifSpqyf8hq  fP @fHnQ PQpygl ff@rMf[$5f 0pZ%U;tf@Eϰf  fTnfX2P*_@{@xp _ú![	Z[1Z[XжP`d fw@u+
f<P~@SQ0rQe
 |@$bp2`BsP_z`3aajcdy92w`ff۹" QB@Y`ffhfaRWf`3fftf лOuӰYð'@$}W9ry-_tpP.?g /cK/rQa0L G Pⷣ= 8 3 . P·$    ۷ᷕ G _Q&GY2@ rr 0 P da & { .' U f|w@ 0}p| }/}@ Up~jp~	 K L  & <0R
 _t " " a    	=Hewlett-Packard 68BCU Ver. F.0B 05/2P004 0*L    򄏉̉ 1 MbKBCsion XX.XX  
 
  # 2 @  A  q U10 Intel(R)/K dЛ rnal L1 Cach  I2	
 `PC CARD-Slot U
 en|US|iso8859-1  	 p
 p 	0DIMM #q12
 
⛄PSST49F008A  	 ?Aap~ ~Ɔ\
W~ ~3
@8 QPrimaryoÌ~MultiBaom0ca2  k ǆr !KEND	

 m	
ddTˇ"ŤýN_o baty"OoOKѯQ09U/tfܐG.]å]*y'rf%VfٺUCESN uIfuf#s"fVQ<t2f3r6U+f u g> tXt xr `Y ( u!yYqf^N%aE`@vQQ-Pndstt
Qr2fp_ mA q8蔕-<t(r!f _ t@uEu- @+TN $}l `lf#`lA(  tu
@(u$uDt@tot tjPQXr`ffgRO#GfZ3tt@o$
pMt˰,_$t pMn˴yZifVQ! fP1`?Yf^&2#2˷  `)$22
f
bʷ@ 
f
$}2nea
SfPՃfXۂ	ش  [#+S OV~_W  2_0W
t<5t^ufr ۀf^_7rQRV3}Ҁû rma?Kt
 8u`B!y^p$WH# _T*u	 E 
yjtF)Ӏub0$&  5& a)߀u&auu#(!!
Q"au! À8!|"! "_ &E#x&8''(RtY+vM%uG	%+u<+u3+uO+tbu+ tW.C/Q"0> +++:u@*8*6R:EF!u' E &`"} 踢&tTtt߀EtH P17wQ1P1F )t%> t:& tSuEoru3T +#++*s @5 'E>IP!!?u	PX!uP3 t)X,=/t3-3'P.yE* wu+t+]*t0-)=u#!2'qT=;>3s)0x3;r.Dv+WXu4-323-*Gu!.ð--s#Q-	c.2I<Gr<oSv`A ,Ge.-/]e3-JLBL u.
<.r2Lu2#!0P'述(2KSS2'e??rK.<.t<+u
0 uθN<-X" uJ,0r& 
%6 ;6 ++Ü   f <` ~<` u<` l<`c<`%Z<	`?Q<
~`YH<`?<`6<
`-P= uX<~`<`/<p`|]WfPCI e4觌u_ÁVWfSt$fѻRr f;ttNp9" f[_^hffir ju0k
Nlnl
04 j saf֠2SRP:X3R%3Zp3ȝOXZ[s5t3ZM34usf1tt2PfXZ3fPwfRuus:2R2Z2Cu[s{ |2ZEՔ|Fw: |e2fP`ypz2cz s" s t s %QVW&= & s &E֎fXQ !* _^YSWPwQ;t
X2 *W 
_ߺ πo#t_)X _[ÃN@s sARQ1уuffPf@茶`zr8s2fYZWV
.@GF< u^_QR׺s藠rD.\@RǊ=s`u Ȋ̡\AQRȰ>W?PP?誵8ۚ밇PǐbS؀u?
蜴ӟ0ӟ[PZ{ P2?X P2 q X( 1>?Rp1RQPaQ򰥲t_wZwU
uQrEt> r2
tC r^" r`0x!  Ǵ#2
uC菖r>2ĚAP,rtrG ɰ/Ar*r 
ֳrЎ 蓶r
3r誳<  
 Ӛ 1   t3\N届\5\$@r:WQ $נ_u!O"GRP
PXZE~'L~3иN&A  ultgj't<ste}ur}0<ta'}JFPFY` RX߈F$3tĀuC2F <r0" t 0{V}<}o} cd}u0͉Gv <t] <'wV|u߬|~$<s?!<w<'s*Qa߃f ^YNuE 8u| w&|u tf tBߠPi tEa^ t=/ t. gњ|-{u{rp:| g|G F 2v X'u/ P[FF P$q/utzU
|@ 2Wf&p 
@$,0O3ۊ^0͎jMN{jBGs$ ݠ*A*
BȊJ @t210V3̂3X0PREffZVW  w#ȟp`A =@a+蛑 PtAtPSP1t [X#Qf@  tPOK`^    %$ y8_aUWV`   A t@$6s.1ޠ;uujq<SFKՃtA( ,ы΀ #иQT^_]#^qVW3x_@ _ 	uA  AWV!t$qr1  SA?X#"Дtp%|  uQRW H%$tu{0ư_5W'(%$%'"(38 `n2,`$tø@ ؎i &g pa ]
u
^@ ^]ϰ26u.a1,p=2S\8&&G`4&G&oG5 5 [ !666001P77\&\@9~]F0 ],..23 и( и.    C@0=X_WP .3t u*>O $ B>@+! & `+_脷@P芷X2Bq׷$Bw1C    SfQR .>4>?ffQnufQɭfYgsFP@q[ø <Ȏ3]Ou Ks%fPS=Au@u;" u39 u+ f?wufP@uO.Xu
_fA[fX%[{A4{N{S{RSS3{o{SmR2{R8TSSR5{W{_{XXXX{{R
(<Pd6<66667>77@Pp<&p<@CW<r- .5_Sw 
' t r/
  [e _u0^r!<u	rr&pjose<_s" r2.52& rps rh 9ib80rd&& rr	<ôSs+&' @>'  sڱon?VisQ>[b W r%d$sm r~d rѫ	Yn 0@5ii" $ Ӏ`<QppPm3X uht sz@et}qmd`Pm|pt t?
@uaqfYÜP`
 2Xr_`Q{P }@(XdНP{q Ot	`rmAtd$!<!t_`@tPGXÃ3ɍ6.LH.:Ls&31.Dp).L*s` r2b2gǖǆu KͿ렀/^J@3t  t
u! ǲ\3ұ0u P t>ٛ. . u}8P J}3}uLm  u3puvpbW~E_tURQ2UА"YZ6	u>^
 .D @+£t#V胺L^ 
n.Lo ]U Q3K | Ys. u&	 t	&Uu" Ǎ>F |  Êö.f.|{f ,@ t ߹.|߿F\öS˯PQW 3ۍߚ_Y (*׿OзI`a 2 7զ03 (iwRWQ\ԴQs`@ Y\Qj3Ow`3a RQWSP $pX QBYPlq -MysX JqP}	u٥X( V_ m ׾AP[_YZÃU2<UuXupDYJBB̊`TÝxwr9ˮ0!uqPPدbXа
u	 Կ ت * VW Dt!WQ ׊:t
Tu8v
Y_ԠkY_XY_^Ç1P.  Xtjlu3pqt$t<u;73ls.lt;>lpa>6?ߊ߀ jtO>tG߾>B@ߴt9t5F  F  F0!
  MPlu<IMlrˌN.TV
ku
lr.2^.lnސLNPlpŞ? uX>lV@	'O	O"O<$OI?V	ukuLkrx0<u.;Ttqt 0RZQ^H?@e3R3[RZuPue9
< t(4 .`C 3N2e	PH XA''tOTV^O"2/QIpLcߡL Ojk/ j"'j`$F``<u
 @&   >q@tAAuAPH@u  ,:Q& XV1  0`O  r
 P<Fu@ us	
 uA;c
1u	 X tGT`u6FtE`uUrPRtKxGbt& 0R] ZӧtDuh& h&
XuhX&  U au@ ϲ`rr
r>r
 d P dXP $& 8t`  QX uS^ `{p*0`*S : x | P @`@Xy֟Yj@ t PS'[Xu	[ֈ&A 
t}aÊF 9*@ N
F&? 
ĺࠋ? $0 -r#}&\
~t008sQ uB@YÊE *F&d_ؠF45G4à-.t`-
&>  $> 0神8諫L fF q<؊恋<=Ê~
~Sg~Mgp >A  t!@	pY
ullug>4>π>
B>fCFF .$t#`*f~ f	u B tΝGםf!*f+ @>ь  `3$4 &?t+aÍ>p}
t"	
t> .:UtpMfVV tVRBh+ZN|PNpNpu-AO$<t"O}`@Ou^^ppQpJڨ3kRP0ks2t*dR",.uвێZ
tAџ"uuq 
 < GuXP
9Ps}_u^~^1_PXs4XPt)Z&[do[\Pr]`:]
[u"_c!uX Ui$PnP!  F F F  SikUifPffQfXtfUfmfSfPfQfRfVfW&Ntg]`rfw qp?rdaf_f^fZfYfXf[f]ge333rVd4Ad^;sgu0v
30tvs M pptAt<Vr0udDgį}
^PzyVWd_^gEdTg}@v{
fw}gEm Pxtr0u0vt}d8tPxW<yt13@Dڦr}0u|{fU@|f]3
t Q~ 0u Ó' a.;Gt}q._pqfg6$+' +kÑv#1vd0rvP0vfd(frv?d&vvߋ+ wdMd5zvpq
Vd0d<d;]tcdd]^UP~vЎFP^HrQT 0~vFUnA ]~ 
 X? ИҘ3
' '` F`pF/I3@.;v+GuBG
pF/ǐ{p Ë% 	`XvNQ
 љ0NY%'`0123456789ABCDEFSۻyJ׆[KKKK  A " * Gxx  x y 1 "Ϡ *
Hxx 0~e 	3 خ ̱$+8y y `b é u{TEdذE
Uк`
 [r  t
HrpPxf`i2tW &  q{&E3ҀtB&U
&]&Ep t0ûKu0 &EP0!1fa*578F'()+7`+ À v5uqA `
x_t^t]t\7uqtFȖ523< v
<ar5<{s1$'PɎ~LFX`
AôrհѾer9_2.?ek߅G$u@t Γ<zw, ˫tA	4뽑t
w
yeb2]eS0!J, E O֤@|֦2)P!
 LT tr0r 	p`qvPQ&Ks	} w	E% @ @@B C NOOOONNg]耦F ÿtFQz3F`dw]!
CN uRN7gFv) vSQ>Fu5M眆ôu^% Yr<{3ɸ p\ 3Y[nSRVͥ&FΥXzmz'{ t	t#>zyF^UnzƝ< tq3^ZsXoVJyzv (Pu _z`r- ZBz` 4uFFoF@i
` u # $0$?aÐ)h@ & r  3u莤.P菤3})ô'.?< u0LذI<u	.P u<  t$\  atuu V $
4 w S +@ Y 7@<@
<u[SUNNNOQޝOPSR 	0t$Z PRtM4ZX2۴ۜP|1ߴ$ #viIR    $kqk` a b c Pib a Ui i  f0 c 7j hktphGQi`   "0  `3. W Ԁp
]_ϊJ
`&aVWQS;PRt[ 
 z[_^PQRW3$` LQu t &GY-Lh0+g+,ϋ_ZV.Q p\6Q.Q^U uP0Xd]<tt r
t!ud8D^u1RWubbs725T^u@/ `|v&
yt,ـᇠ-t&M0
1&G&a`A::LAAAҠa+Íu 2ఀȃt
ABqA܈$FKuðWQ :u	ۍY;Y_D׮uEFS؀upu)4  IP,  [Ã.t6
pK2hv& hLw`Zgts@W1qKKL΍LyLs@AtQqs
2Q "  |  UDd.D
 ``U&&D aø0 м *j D&&E W 03Լ{h  LqKOQPSTTQ\qUXY}`.\.T@TώǍ>F.LP_`Ҟa.D`ОaQPƌlXX 6aGiocdesVVVVVW/ƐVVw2 *0 Ãu<s/h+UUu 
X<nXu~ s߀}p: hy;LkpJhv Gh?L`JfpCo`hǒp= v O hȒp pO$@<@PfQfVfWfRf   W.JbWf!Wg&`Jbf3fZf_f^f@ 2p n l zՉ{{@{ #  ӓ̓Ȱœ输2Ҩð
@B,P}誓~$zt~øo
!x_аX}	Q~2J~s s	2 G  81*U	`#a{2Ё~ tN :``Ё䒰
ϒ$
$桰~o !﬒$WWWXYXXXY%ZYYY  M= G00" *Up0	0ѓq恔蒭<p^PAbtcfU]º" Uu"/kCJRQ:d%̺ &a»YSU  !VZpp"+Sf3[ffÊ$Rf
`!fX$xfؓff߻ƩRS%  ЧfffPRWS22f`J 諄rB ?̀u 18s܊[_ZQWRfP
t)r Mff  u 8ufXZ_fY˿4 #v 
t$PtWQ3˃rY_ \\<\p\s\|\\\\\\\\\\VS30A.:[u.o[ (K[^* UF.\2SF 0TS.[F[C#N[QF(?tB[sF2~ t_Yp°j7mŮ"_ø8qm@d9ǜd 貅 A`ɔ߅ `$ $SWoQ v`tуY_3p2ρ	^f]]]]]@6r *~A/]薢_P@HdX$#G;`dvd<nlq+$e 3WlrUXg".lX(r4l Dl ElZQRa]P9A* MPu6 4aԀa$8uP& LGXR/=0
4PQ <Yua<u
3 uuu@vLƏukufШu@F躏u5t/oLQ_z__q/_S  "S֘ # DPaRU[D2ET~1!Dן|+$ eݢu  `T`b`K`>   "@ * G yo cTUuFCT@
M#۳hן{򶠀3Wƣ$ 1  &Ei%
 g}
3gE
 t02"6MD
j

[gu0?5sU I1  
$X&E
9EFW
pK4
>Q]>`
UG  `G `N N 5S  5Saa !U	 Y
 5S 5S@aAaBaC  HP HQ 5SR  IS 5ST@wIU IV IW!!XaYaZa[a\a]a^a_  `` `a %ab ac adef GlikJ_6Y
`pgf`ʡPtOr͊u (J$
( +-,4+ô%´+faVWМ-t*z.0+$t,$}<2ȋPjf`%̀+$ %݈5+.$xWfVSQfVF! \Us^(2۹  <F  +^D!8u3cf^ HW7VQCuK7! }ذ9!`:`w 9$I^:u:\!uT8 Tr7Uq;f^Y[_SpJ;dӆ.
tذÀu@u[zʌ2*E*'$+xD,&Fb- X nN/R/ Uz0FH͎2&:3Z244)4/uˀFFG	  @I$Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZ`Sط$0<:rd u[X߆ `ouH au=Pa Rbϱa& V N: fgfF`zXRyZÜSt	tv
 gvt[ÌȎ؎ ЍRhfcifVzބu11t u3N@f6 V1u^luw1uP1RmplN\k Shcg1tEp/2u911u&lE1t!}1n
xqu
]]f^TVTWTZT  	     v 0w G$ $  GN N  GP P  Gh h At ty   G   
G   G@|xйy0w `@~` ~ Qy Xtp Tuw Vjۃx 拔 tcPtpp>ppKXSB$x$PXr$yuﱃo!$
BByJJ4HX^ &!fRfW.l`umf3gf&ff=SCAFtVG t"ffff Wuf(tfPf`fXf_f@*uTf`0D Dfft;  Qf3褾Ypk,攑 1ѓ| S/fuBf=pz s:`L
LtffףFfPfB谰\rn`>L t {SWfSf 3f9Buf[j @м  .>Kp+G_(`+u+j؋r  t4t ߰pK+2撰fPS^ۋ^&t$uUG&uFwtt] ( ]2PQd rwQQ3ɀtow@q\)rr
`r`P2䠄t"
 ̠  uT!в!t  &k X`PB
Xu!P7<Xu @P*t,a`
  PwA@!waeuu;	v" Q{p
 p
R3҄ D  tZ&COMPAQ( /Ooȏɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo / O!o"#$% &(/)O*o+,-. /1/2O3o4567 8:/;O<o=>?@ AC/DOEoFGHI JL/MONoOPQR SU/VOWoXYZ[ \^/_O`oabcd eg/hOiojklm np/qOrostuv wy/zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo<fV@VDH       <Q]7h *1Ձ*݂1DT`ur(D
@ JvArHvA.=sNfj@&t FN aR3V.vZr# Mju 6ur 0t 2rYP u v tpr&4W&E0r"(r$2mRs ÆUu
FUF ôo	!}	O	r@e"g!5	pW	^F&?s $s& % &G&w&G %OD
 &	G'fPfR.Mf.u)E	fuf&)E%*WE+b+++VfQS/fD[[+fP'fY^f& u#f&G}0Wf1Q1 /WfZfXP'F~r .>x؀t7P4y4/r?P t8P4w t]R4 tP4z62frߊV7ʿs~	@819v~t$P:tP:u/~ǉ~ %3NVp<3su;^<Í6.|uLYR..z`> .:Uta?~aOWQS.ن? t0.}u.:Mw#.;]	w.:uw`Cw.;w	 Dw[Y_P t>ـ?Br.u|
ՊGc)Ѐ ʿ.Ev p$fV|fv= )dD!M IF؊fH
@NPPK.eXfPȋHBs$
2H
=JfX!MYKdDM!OfPUv]f^PR-BUYYYYZXRPXuUW:>_]sr  ZP$<pZ- r!PZ@XuP[>~\ ݪ\@<@pZPY 1sX切Xt^y_>PDt_ \b> Bb[~\   PRσ`ZWdP@ ءf  X?rarTrOt :DvL*DQlP umfmP:
u
rP
l
u2 P5k&:Ev&;MAl&*ElmomoP:nZrFonr;Z@uu gBvu< r
to@r&tpu
gZr roR^Xt2K uu@uu~ u2\S ذA[XPQc6Pǀ @8<tPp<[YD
>X` ID<7Ƌ%a`t>;P	 C@@p$Q+r++YsaXt!$!"条Zgf`ZPQȎP:Jr#P:Mw>lt #A @2:Tt
 аuOugYQ P~ <s& ? E\3pp >ٛ}uИ  
 VWf<u^<
uuw MzE<49<t5$SAB
[|u |
7|P5u5 t\_^FS}
uӜ}	q. @)򠴡܀} "a`Lj0uDaj@QV 3۬`+^YD0!)Gc+fQ1ff?/bffJfT1N
O2Xpf F PX`ZfP~t$=wr0&Иw)0Efun1fuP:Cu~EpSVM|ttt
^[%_\E20%`URfQvV ufufYf/Q=fA<x1 uQ !qn r.V sfYZ]Tf;PfRf¿f;fZPWf!rfrf+ʞf_fZ菤r
pfSȀ' r#Ɋ|?s
7
<f[Gkζ_9r rmBQwPhXPQɴr Px@Sr["zەܜT6EzzҏжQzջoQPfS
ff[fufXE t ft/+f #fSff3ۀfX2Z[fY磎eeUt?$73tp؁vfl-r@WľWV` fSP~WB Q ߪY_Wx^ eNst/V! <5u G	F^;^es.
<5x pokݐe Xf[2P@fX^YɣWfVf  t
P E(r&< u 03 _(PŲ f}^rYô P93x3Xs ݌e/Ov{PZ
 $ t_`t {Zð) t`SYBHu
 %QQ$
ǊQ*Q O P$P$ Pd)R>N Q3""YQ
t
t
da$a&%3ð&(e)) F!tt	*tEPXQXS&X"
ǆX[X-X <t<!t
<_<*3R )`@"ZQRsu	00 Z) ð  VP֎ލvS<û	 X2p^ð,RP4&4P4!RP4
VfW u t{r
D,1^ p5t|ਐ>|>  $><a?<a?7^P.pW ".mW|W`DNb1% QN 6D؋~0FJNZNJE]u XðRQoVWP>uX_^%VWK PL2LPQj	؀7""dS  [t۰bN2JPR4XC1t0q&[ߠ%02p4a2%ʁCq 
P'b7f31m4(Wbx_f  @ %T|4ɰe/Shr 4} 撠4JqUtq$DU&] >?0|`ɚL|0I <
䀴SQRs귄3ɺ3ZY.o
X `s^.ot^af{V`tao	r ^"r" hs  h@	pqh+"af^`po*ǿ2$ԉNT@׎ǯ~WlF$
&FGBp&U_`g{	 q!a8 !sSR,غ*3% Z[QcW  	t2__eQ[G0wt Zt
pxpv PQRVpo6f `Tq}쨀t||u}T~^Z`g Di &  Ҹ
Sd0wݚa 1`iuWt;676 6 g?3
t,=
u
"=

u5w<t<u? F`<qS $s
Ê& 
 [<ua,w\wWQou& u` AI_`'?Qa6ᎿY6_ FF';Іt@2vPF X ꏙ dtPpqD3]q]	F
t	u%  "]g ,2Ot м  Brᝰ8p)tlFpoypOIEMAG  IZ P  A   	

 [ СHDA-L  HDB3A-ES"C@USB-FLCDHcLS Intnl  PCI-AѮC  % eO_Viyyx	uP 	/е<M ;c!H3ֵU	b ` @ ! ?.CD001EL TORITO SPECIFICATIONҡϼ/IͲȨbc*_dd˦Ei@i9tP 2XPUv F t	F !Ff ]XbX
HP <SIMPLO9MO0OLA75us1  ~ЎHvr  
 &s4nu|ɶp5^ VSrɊupɠc˻ʆ, >6z>-~$ֿ	zSRa&
 3-&Z[>y>yW@Pٱ;
@ t=p+؋ò3ڿ﷧~uy؎&3&M<S Mto6u6H
6cG^V0tO<rO+*x>k!`#֭%'ط)خx)_ٍ>+ڍ-@ۄV2y2 -/b3/ZG4>k6058,:P#Mx6MM+%%
ʍ>&~X^   $PMM 7:  _32_   ͓SM?_ PDMI_ 52  #f` tEu 'ʰ$
訰 &蒰ô#舰螰~fa1пty$otl A	ȋº If` u1A)\@ 6 #1&$f{a!	*P+'@dTOYu0$	!sL D)C0ffPffP3P]0sUSP Pr߀X[%#<ucrh .p]iGuESx @
߸y @55I.ISzZ@L{ @ ~ @ @[ߐr
}@`'$$
Ȱ5P.PI$
ȷPMSQD@\rF@P)i'Xy#@;r@'%@(I'Ȼ")?r, '?('fPؾ*ff\P+d+#o0/0p/R	1)os=oSP	 7XP rX[[f1< |?7` $$iu  `uph?
'3^?n?21h r'7x?tu	iQ?<Xs:><;~@= V;fSq˸'% ?[ ?eݤ@kx A2AZ]BSRWP<u͋2.)  .E hu4`   
E E kE pE3z YPH PH =E PH G鯏 PHL 3|y rt&roMjrey r` [rVj rQrL rG rB =t r8 r3 .r)= r$[ rqP I r
 rlZsg_t1U	P<t<
uu5(Fu
#X3X: =9b2wX%W	u/><t,`0t-<v<u`X/<r<
w`#9tX	Y4wV
__PXE˨Z W/
Ot	``Z` W| w<XYS%UE"
ǰ \Evt2M<eoܠfO<v`u.A
o#EE2iEE&aRts@ ڊZ[slZ[T蠭uH`jD؊Ȁt, sl
uIlrq7mZh1uWA=ۀ 2hf[eTDذf`iXD۰eiQDC`j"jf8Pv3DBDO;3k VkUkx1llFmK 蹬1n?{f:tC2uCt%زoDpxpdr^PsOu=u8Aoho
ً@:Š:2~w:03kURqu<u7wG	|)p7:0:otooۊʀo0Z]aGbXUps1lUq ]`Ks:ЅqKxq1l{׌Q3pYA`tM M>rQp4wYs  mEm 3ɶzZ[xtHB=Puy{sUݸH 9ٸG 9{U葚L W8 K H86 N {aM 㝸slS	mAjA@2'A83kpNR9 Zð@1AV
u$
t<`Z'ð` AË tt	@u Êf
t ڬ 3|eR $t
& Zgt
7u 7&àBt'`W!&C 0ttĀtr û@ `:/j >N w r
?u ѱ^< u'' t	3rݨ0u  (siq
u` )뱳2 B<BDtkUEK`:?t
T} <`s /Vi 2ttD?@R 5H I+. u$Ȱt~tȰ<tP~ S`:8't
'  #lucs8tKTu<tB<t> 3>$
n3>q u) x>  
 3%>$Y>P3Ҏ¿x ȫX&W0 hS'v 
h_ )o،_[a{{߲ݯA*{qAAݰJs@PUFF
]X `j j v
)Mf.N. JྶTFP~rp3@o^)tuw t&Du.⭋^^t<a.@t&ڃã.^2Ȏڀ3616^2}. @ PSF@g0'.:t	tX._}gepgÁUUuf   p5 f   E2ÿf<Фr-s(@QКrr
 rR1VvF\r:Gs5&DC H Prfڋy赋Q_ AFÉF(t S^$:u [r
F&F$%&=vHH&
D&d̠u ~rc_wu
 !πϠ!&DB êĪǪ` T>Vc  HUSapW1s!
 -s fqt
 E PF  &G )
V N8tr>u rG o!F) r\ A{or= r8r{WsTsV#@Rr
 ;@÷MSa|`km 1F("r#謂Qlr@rI2<}> rF( &dKV& %f)&t`.f`g`t/}@t 0(lJô$@V6faRVМp*?t
`)2$tº^ZAfRf` u'B}`)$ߝ $ٝ~$`+ZgP3@%2P   树 X& @F$$<r$:u s
jút좌 
   @o^38  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&L E _6F (P<$<'E<&f$`
ĢF%ѐ$mp`BG ˢB<(0ø fF" PXQۋN8N`NГ o2N---i!`GsH-ßGHmIn-@
 r
sHfQmr77u&-dfY_"&&%'ü3bR&u 0֤5t36rCE VQB A9O9 BYy^N 4s
3
3u3`Y?,dS@Q%uè0àt  !'&V&T tu^
* &u^ôp    QPXuN?%&:Lr0PQO* r$C`J 0@uN<upZt+Q.@  h; E 77p+$<@tgA9Qj9" !$!${wQj  BoU0+0Vùg
+K<P[bз߸#*E.øJfUQEufVKrKfXfugfۉPwNPwVPwFYfu&gfFffffMuY2f^Yf]Ë: 3R)QSfVffLfTfDfLf^[YrxXA3PXføM߸NOfSQfVfRfUfWfP0t3 0 fRfZv__f]fZq{[PfW t0tQ uU=P@XYQR   PQ `YXPt
 t$0t tZ`|tnXRfVFtf^fZF*TVfw#t   r0{{ Ԑr	0{ `f^ߤQWVKǑ}^_wYÐ.VW2! u[ك!N[P] R Vv 6^N  (; VI>R ;^1{_f^ZYpV3۬
Ê[^qۻ (e -r $p0Sf0fV1fffa[.6zfff`;w	rf;wkaf`fXS. " Eu Цf%s4L?^oAR0e$''ذ1000= <r <3ߜfȐf
ffʝff   f-   cDfpۑ.W>f43&G;r_1SQ <m o `2}S5 Q	t[c )exfsC3    )4e f       PSVз-//߻߻/пǻ.u/܃&&^2Q pfhs@ ŀ @hfYX4Z4f4fZÀu< uEuPPuDuZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .P.P;c;KR.PPBZ@QR Pj<rt2[U$ !Ȁ
  -h?۸" ZYSUל$!$ o[}BuR xuߢi
 S5D.4V 1	 &n `.En&W Uϖl _Z/ u
BJSuU@֮@SR t<rP
 j ?G_ 
t<t  ).>  35. 
$P$`R3qAB$ԡ3ɠ4+3ð4+h ?_`iSQu{P`s"$@AX߀u"Y"@1`"_p"XU`<"$SC"S8`tu
`߂9$`
_,RVVtf   3	ɸc)	uQ <VeV <WeU  
  #T `3af>f F6!X`s >up?J}_>Ffah`wBB~tf  Fd|vfBFR.J>J u R1uڧKR
3_^Z2e
QԆ~V_ؾ}ÌȎ1 Sr. uo ˀa! ''u	!3r
`[Uf<tz r	~P]íU p rВ$&&ĉf!))#*N#*Oeč}#*qp+i+k.7x)]e.!Yʔ,OĶYctwZ,P0:̑8{P+ĠP+c.ofWsA!<ufl,`u#B1lC1@9f3gf&ff=SCAF9f_U< 
 	<! F ]W  <w&з'V3ɿȈCF>з1?^	  0RVV<v^.>
tݬзb@ ؋}BX`#$($&],5U0XZs.V OuC]		AJ1'  'J=O]KL	T;;cc;1'M 'M1'6=	L(L-Qm7dSvn*+CJQf:r2"S"U&*PnYUb\l["2ɵ"?YùUgaZXJ} ?jSY8Y)0f0RV;fг f0^gBQ^>6׸@Yr`_ X0hj C8BBaaa$at@0c߀3FfFɷ͋N
~fiF Nu3 f'Ggțrfnpgf ]
 CeRQP~ǯXp0HFFYNZ2ޑmm$@kQȴY`Њpn  aÇً @"ԃ M & Gar` .&-ƒ'@'sQR0s Zsp<@q| Z>`r ju l` XYZð
U 
PQR@ES{r{ = ufh   XX؋7w[	r6    ; GA0{
0p 	`:fa@ ؀ `
hUЋ؎`]FaAWD3C
A°DF E`P= *#[Pkx$nu90Б{` $<uu 3 0   fϥaÎ3QSo _} QVQm3CAY^` 
aÐ3RQ3f tf
f3fRAр;v+R@qTYX0GY |ÜPUfWf uиjfW!+]*f_ff_]XÜfUfPP!$XZ틠f]$fŝf]rPm ~`nѥfR% ,".c8c0@D3a!0!t"Ĩ@t  
 ް  XPJXSPb +. s#. sXP &   &X[ó5P϶.4EGO6Oa1pσD
 uj@t%v 0Iv t ArMv .sN-f-&A F'N- ύ6 `
tr r	
F (|r
	u^'Ât %?	xA*!trP/ޕ5rr[Qo
u< r<0s<"N@P \!
'P$nvP߈f<0 
~sP<js>u.u.
I.
M.}u tj@&u |t
` ^!N%V#~F`2rp; SsCs6< s
	OtE""Lt*$Ot"#Ot%>" 2䒸)1ˀ ׌ .EǉFr]RsHs1I9 <$u2d*<#"0<<v<%2;0 Uu
F!UǟF% ;pF~&=r&}vCfP&M@:E&}C@X§sʝӀC^Ë^63܋F'3&rfg	DEĺ~(LuTMs!sfPfڋ}3r1>ٛ.  .GTώǿF%:./%3V#:Ttt<~'t90%EE&DDp%p5s%C~ _6ٛu0]Sf.f&]f0k [A!A'Q;  'r}迵rxtNrlFrd|tZl+r@ u~ (um-VƎދo^YtVffmruFr Y螵r)nr$]葵r)rrd谵~pq rw
u fSfRW ـ?f.Effff±
USffs̊MF F

tSuNf@ @Vٛf.W*f8f'w*f'F'*2t*܊f
VvfVvF`PFsQU n E]YRPXtUW:>蹶_]sUro  !AZâPRᶃ2_BPPZXAюً PopE@B A	 c۳ m 0s གྷ # M #
t #P Z^Nz # t謳r{`xrv=%>= ˫1SW>Kߊ, c5<s-ٛߊO8L`
t" >G<#<$܀0 o"|QRPaX  kO $ཏPrz[ruri8PNزrWu
P2ع (`r(r.Ǵt%ttt t	tS% surY	 2Pސ!Re`{F sH<t<)t<(u;>A u/WU>Խ >]_ӓ=r0>ʞ`0-?P^a@1 PSR 2Z[RFtN+P(X!	F
+#F
t
K
PK(0S~ t=~^f~^^~^~eF
!FFF  f[OfQ
tW8vN؈^~nNnNUfˈNnNnĢU~*Ŀ^
^amSfYTSQ@v @j 8rC~5sfZR aP`{FfFQVv~%跱EfXr+t}3 tf~Zf   f+} YÀLu$PΎq2t
.x<^@ fF! PX  t<"u<"tV3޾x 4|gQ&?s0< ls& m &GnnGn  @&O &OQ~f&GT
q1rqWQsQҵ qqWIq> QVW:W }tNuu .6 u/ ?.	
zy t,6p/o{OGA&&d&D&t&DE_^Y7XVMﰟ}}"`uxPy
 ф^ uuچ~قٗ٩ٯz,U~gO0ۡEݾܿW.}
u.:wtLu% xt>JrS.[t.[u yt	Ӌzt_M_7EfU"RҵRеMwpgŐ.V PXF
Xf]h@ øϑ񭻴 n ǰn\V20ǰ=Vأ6{س}س.tL!΀s^|b^SVD.d.$ʋд^[Ay觞ójrcB֠@Dut
tt盾{10
}1zu	$.<&h ԕ@R:ÁU?u	UFPTRG rТfL\pg Zfa1D`0GfP`|wfDu
`@uf!VWUuP &?BrBnXu>{ؽй0.>}ؽйu ؜`[Bra$_3mBnݾ&G $nn$PC&In(US*B>F &g0G1&O2C$ 2&G@AX]V@[òl1<am|n p
 دq>rfBtGn 0`?WP!޲ raYxQ߶eRE<s[fQg0Mt5pZr/ g( Qq[Ü_`@QWV.>xuG<tFb=ˁ.1y>%5~QَɎv^_YSRtW5۰`cSg&/_po&_ @Y2E[fUfSf]Ê>?">?U3 ]PU  ]XRd rQ r?Zq]@藣 r1Z  @>  B< tkY P5L g rr91B+$f r߅X rtL rn Z`?or5bరɬఆ r/ a@RAr 5rPذ{0`@PS [XQSWfu0v t!ufPs sGfXt_[Y1T<t;f3fS t	fVGu
utǳ?f3fL[`
 3+ a@[ q^(C)Copyright Compaquterrporation 1982-2000-All s reserved.j/w*VR@ ރ|   t.Z^!VP  .1BBBX$JJJ¿B@P0ܰ t
tJ Xua0b1@V tA&q JZ  C@2u* uP= ]Xruŀ̀2	`1  F (8SQ2<

2ۆ.
$v2pv`1<w0
u  ` 0      Q
! YQ#?8  #$#PRS%@&+@&;w[HR/Muaa@uXXZXp! / PXǻ  = srs:+
3,,]{ _ ߸^ P1wt褀.`蹾! /0諰2]AL{q.j.b;a/PQN 3۸ K `T'  A G#y 8P8 y ÿ" Ëuŀ}
$corp`tW   d_oa?/@OAoBCTVTWTZT~18 p9@ @  "`:FD-18 yF҆GH    *P9	G%18	p9``" 8d dc"F18  #Ga acF Fp p  Gr r"Ls sL
OrEcN H"  M
 "p9 +O6bSM  #	K҆
tXtX҆#Oci0,}`d$!<!uy
ء\`&`"&& x<&  V<tr^@}K^D]8t( 27]']v233.f>"  t."   a0b2ۊ( Ҋe) ǊȊ&) "f* 븊*g>+CfgPhf>},3gPh.- gi) 3rAji..jijPgRm=}DK   F   Q Q"FPkXnfPS \@ ff.<O[r.<ft`uhL& hPrw 蜿uhTrwaú  + y$2ң.<QR3Ɇt ސw  Jt$
tAJ_BqB~  SQ q t$Nx.1u
<v<s<3v 3^mtQfRfV SPo  wX[u f^fZf#u 艫Y<u,fCISGu%f» f f fw À2  2Ê$uGuﴀ\PS3ێۻr?43' u f>$SMMu>X P dPu
@uXVr 4y˰˘s\2&D
V &DtH  
y r!`rsuEF.`26쑛$D%rOsJWڙK$?rr
jryϞZ @FFtN fF"߀ pvpB@F(	r22ۀw~ `p]{  t3ҸK3  ;wu;sb߉FVFF"F
 F)t ߃@r4F$
Ft+ F p!VPXVP}"aW% u{@ZX_'Atp'p䈂$q,pⰻ.3۹ 3Ҵ@./@32 3ƀnuo`n C/pÌBBD= /,_->UWVRQSP36x \@ fFfsEYc ,Xu 
<t<0$< uB"<w<vr,2Ѿb? 袽&\@ N [[YZ^_]?u9<u` taa?s@rP`ƝtNð
2~
 8uVÀ>A`cA	}'V
u'q &L HYVsƨu	VuQ2^ ˋ
貽PV~~製@كu B nUtG蒽&A J
k ?y2aeaMA'u$<s'
U2f 	.c u-QطM`
~Wq`t
`Td TtPǼ u pN> u@G t$p<pupukT@'FO 8tWGui`@`迏 u33 	t<uS@[u8st,H@>C0\> pd X޻ PɻB st2 ߹	=3u
KuS&> C%T5xr{3~ua \PWR5SH~C>95Z_SYSID_  1Y _UU! fl f@f="uf3p fl H = sf`ffP 26Y[$
ȡ7	fFf 
 N8tSFt f% fzaFf t0"t"Y
 ta
 t	x fXfaRVY sZ Zjh50ҿ$	4 Nff`4eA fu4faf'FD fY2fo tfFP ^D
 s fu
fWzff_p#QrfF$F(F,QZ0 f3ңrB
rf~G fv,!v0hfN,-#a#(#XD$(p#$PN$fFfV fNuf2N t
ffFDlf3fڱrfqN xf)u ,)P(fYf#f#ffÀ$0fHfVPf#+f;FLvLfFPf)FqLep()ff v駎!(fI! @.Pp f"! 0wf*fP@6p5ff
fY$.Xf0G̠"C5'fAV;!;d/;Vt
fA33ĳv` ' f%" 'f%`8  @"	 "F@r @0b1AF.A @@  @ 2 tGCv	fPQRWSӶt1u	LՀY 2
2[_ZYXSe[@M  MQWAK` P2߿@2_Y[HN3 O{2Oû 
  u
 @R@p8@px Pq@aAt	+`8Y0q@@ʠAUVHA%QCfVfWfSQAf[^YRP0f;t@Zf`Ȁt@ss @GP tr @^pP faUQYU0F bE] < t<t
<t {[Y]PGUHYfv u
ˀ D ^~e)ZMɒgYhi0rgf4!]Z`0dO pt   _	p Td&op6#q@O+ "gYYh d mmNff3u
$_ ZnPY@b5!g?fF[ZAXtxc[su`dd0degfkf4`}^uZzkfPQ2{y|qmQvZY1Ր`*U75.:f@3d<5uX<.V.f] u(<sW ._.P2P$<Xs2Q...&+.	  @ t^T.&u @ u42..
tw5Ő*
t*İ&u XYP3 QP0 A3.G
XY0c3 *.Pb Wȿ7%1O  | ?Ooϟߤ ~~~~l|8 8|nr8|8a|çP<< p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>0><~~<Ыff f { >c8ll8x~~®q @ 0``0  $ff  %0xx00 0 lll"llPl 0|x0f 8l8vv ``"0```0  @!<<f!0p䵑{ 0  || 0p0` x8`̣<l 8w` Ppx|	p`aRp Q|x0 ff|fcf@೐lЫl bhxhb3`2f3>  ``x pflxlf bf  ΐ8ll8`xƁxpcʀ3x0 `̀@`x ƌ2x``x  x1x'0ġ wx|``-1p:A8l`ˑvQ`lvf0 Qx`QRځ  a̠ A  ͐bvfҷ 0|004A! cᶀԀP0d 00001qP v!ס  uy'!gf SvN .Y2[]/
Rrx>Pt&? ZukukTojukWukeMAY9Y.DnSS*  y(B03fP2X`3Ҵ Āu NPdDglQYRBVlr8rBlr
2:6 v3lZ aQf PCI01 ISA C BU03COMPAQ 05/25/04   
  r     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
h[U샿VW ƿF F   `1f& FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3Pf S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 hr*F)'2(~ t
)F_^{Qd!
hRs .&4/udu   hr$?wط2hhRhWJC4Ch%3
 qrf   f  f   gf&Q6..  1  Y`WVe1E0&E.&WV .^_UUna<Qc< 	`@.e1E0eE'E.U s Cm2a h
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK__Y[X MMMc1@  @  @MpM dB FfO MMxsMURMMd* &  <!TXMC  3Q[MQVWh,5:u% p u㾐K1__)  | = <ta;P09A9_^Y~!JRW`   e
Crr3ɺ {Qe܋
AB rN /_ZMSqe Y
ujiȞzjU zj%1 DE<@1p;<<1p<3Vu """ka#t
#m[VfPfSfQ f3f3PXfffDDG(	Dh f?Yf[fX^u̔ 0gO Gx{QR@<3ۊED 	 C!~ҋG4Bi3u fDf3ۋfOË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.he+[+V.`.^̋] dF. P!.hrnXhC QR  16W  0"XYZ#[  
\av_bA]cdb'^b` Џefgh qp10GpppQW> t		 u		.	_c   ?O idJһ -ww~C.e
/e
@m_noG`L3۸ E _F߸^FiQRrPS86[X%hzCqQDЍRh
            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй Xs hPv XZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0Vf[f}X:g&8u-g&
@gf&fB!??BfZ+g&>B9g&@T=SWVfW=&2>X>*>f B]CtfGg&D= $"F<vwD"FCG D| u:tRg菂ACDB'B_^c=QRfU۾ ?} 5tR>0tKLCt!?E$fu
ZpNANtN0OqOt	dI,  }f]ZYp=PSRi 9uKCRVrKC&ZCTG tuVb0< `M'f5 ?*bX.bX2Z`8P A; u
@:R[3 t
\=SQV3ҠYCSCRC  :YCtzffKfSC?As8_Y8ta9fF*0I8$ЊBb*PX1TBr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>ou	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
BDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VB [Cffq FFt
hZS7gvu ?>t!?6fӢB qBf0KNf^fQ8SV  ^lQ  A;\LA;t% BA1 04B7>	uRCRCY;MV$
:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 	 o o7`ʵ8`U:`#;o0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъ Muթ5eLpyvؠ@?Lu TѓLC$?U^fpSa=}00111SAA~P0G^lD	%߉D	f@OoAfpC<v PfUP?f{Pfff!	$f41f<1 f	<1f@1fff]X߀ t rP/1f!1r _@8p=R@qӃfw3Z1C X;>/0 t! X `<Uǐ
 X0<7{RVLJf;0tf0f`0 9_y";/$i#cjy!Xf ugf ?EM> fù fgf;t?)gf[+C0k@̧x`hie?1o~ )Ra=I[IPV`^0`; ^=X0;0u0;r	bf.0X50. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ?_Z*8۝6T7 5T4M	# !
  q5 5# #S4!	 Xp 4$44"p  "p"0#a"3  .>`%%

5'))BB),?-_./012{3  S@ hB&Bc1!Hru
>Bj @O>7> S7tBBB>BBu9ߛBlpWC|l7r19B,H+9$:*ZBBBBc87P5?G 7l3ۊ`dB&ECBhBFCZg3QA`BP8VS@t	T0,B[^KVB"APBFFUuqEhS¾0LBL	u5&]Cu]CEAvkJDBj_XLC[gS>@YCS>MC>YCUп&ICpt(
wBp3B0$B[PPlVt>BB r1A!Ww%W"WrA&BST40YSB`9 = 9 [D4EFhG3FF(BؠGAG~OHpQZrJ ]A [&KCYErKC&ZCB.0MC1OO0RVAKq3f))``{iC k BB $1<Bg&1G@v@pHsk80lBBlQ> p$3@̰ p%u0br'qiurRuvt&sueqRu^\fruMbr&su:.w,8&sPu)vwtvtv5,= I_Z^QXp8!u	g&|tV}@s SAN[p@AW9^]_»A`r PXBA BBBB BV.bptt0B0W>@BSRI<v
hRCo,SC0Bʀ 7\BG@nr)RFAFRAGSdpFBBB:Bw!A+ۻ
 t
dѐ   1TBrg&qit!BrUB西rQ!Ar
 JteninUt pLQ2>,uuFPg$SXSZI,`UUB_0|??QpI A 2SQ Bf3faBff3񬉇Cf3^$C!F E *   <FuJC3t	Dt<Hut2KtKn P$ u tP%X!GC 8DC uB<Ft<Tt<et<t<t<Rw*<Ir&JC
2PRtK>IR KA"߹uBYVW`p5tAQ Bft(PǴ:HCu@r gXfCYGЭ9 2'ĢHCks>ŷGCB"t&FC8r !r>t7w{$_0BJC C2 Bf?t<Cp;<tSQAذoY[pu
'Ŀl,g,  ]0
  N0">q22)֑q
02 
 e & .R,#ےq `mOk۲ޠ/Xޟܽݔ0`T0  Є -} %RA!ۡ "a߱!  R' 0u#(֨ۮ0T-%Dtۘ0D/\s !R _,L
 2m%pU11T&!T^0ERchB4cA14q$4  mWDHS6S'1/)!mUPFC6'C1.t
1!~!
lqؘ:)++q
a݇&
&n`RrDH\!!% a#Pt@,VXp'&$PhB#7 8S.CRD
쌭<
0j R!S
&`' w(#p
 4|g 	(#@y
ֈ'	P `i	۠ҟw 8J8) @ ,OcQ/?!c *2
`Td'%9' b(2	)b)/X56647
7(9/9*"*T++W,-&xi	AP6w
 R7 @q'#@'
 `"	  r  [LA '+	 hK  ۸A(RB(qb-" Pߘ:: ,@'aE'aI'I$4J!J4Kq:K8aL
E&aI&/NOOoPEU$aI$I"4JJa4K7TE(`(L-!$.1;.L'M!['$$- |\]Q![#_KaI^$![SS-TQ@q:.8e+^(5(0"P\Dh1@11#eFM'?k_lzm&0a\Qo\om$$0Q`Qo@KsIQ(3a"9lm"Q'3ayp Q3oao"5w$Q_Era\w2!$(t$t@Qv CS(M!$'t$o$}ߊbV!$$ t$oQ1LgӑЛD0W  hv'h_¶R P4 ZXðǴEϘabLcc
dbdCopyright (c) 2001 Intel CorporationfY0  d h;uh>u& Yf12f   t;fqߢft*6tt fp
 0L}+%!}pfY߰hj) u"  sfYpfȸ &fpuF%0룥 ӣf?Yf  fiMgfWf;ugFYaffgfNfB ffpFYffYMfwf1g_`?gWfgGStlSE[t' uIfgV8~`N^fˡf$థ0{t!Y u߃0f[fPfSfWf{V՞f&ff 3gf&_ffGf;qg&<uGf=_PR_ub	f=CPU0uPǉ>  2T0nuTf=NPSSufOff{pY/8f!ᰵ	faSf;sg&fFQrf?f QRЋpϢf$@g&ԬPψ 	f6DpF ӀHƉG	⢾qր )cfRr cڵ r
 !G
 #! !fItg@@OTǯ%˞!1S͡~jOo?_ؙ ژۭ##f僕݂#
ut3dubsnmfp`Ұ/+؋1of+1Np2F	h3f^f_f[fX;WYwepuA@	8t3g{Fg^%??3fѣ0 	 .YRҝup֝tef3YJhƂK Jڐ	&	uqfat5f6Yҝuҝҝp t  ZRfd< t f&Y?	uЮph3#<u	GЧ!%ҝR$< `<0u$0`H1`<t<t'<t<<t$<t,[2f B>=!O12) 2f=ISGuf I sg]Y  aҝt f6Y~>f	 ;j` qf t
"t6IVt:xA*2  v
0% p&(úp>W#f`	uP`u#(ۊf!@>g6(讄@ёs`a("@`((Eujw
_#@/?(P<u(6I0$13<w
1#"6(4)pϋKFurX @0LAԁ"@Ȑ((qR@gf'dбrFG"(f{0JkJ!uxto @ n2?ڨ hzSp}ё - > i a>VV ZfVw:XjttUYvZ  _xZ` _x[cyZcy[3y\3gX ^8a 8Zbe[ \b )]d)^b8_d8`e:b g3fWQfv!X!D=ґ!Yf_kD=f.oD=.oe.D
$.>o.%
.D

pFr.% .>o?tqk!Yl2m뾘gopsheprL!ud
pr93qsƁ|= USBSu`|u=0ztq r`wp~wu}plγu oarF?r 8|Oup#qw0{`eksoSp0q`sqot Ppr? It5QfPkO.F!` m{wr
~kCfݻ!ZfЉ^yqб@|8fH.\
؀o.\p@yK`~-r{~  `Hfo"pps$~ΒsW3ms zCs  g&ƿD=V 1mW /D3s@8㚦oSoZ$(ZP(QD7$3=%dĥ
OD$$#$rV `m.kgϪS@RP2{  ğh >}؁u `T=
X,(f1T=&~`Gğ:.6o.o . fPQ f.>~o ){+)f!Z^VuP6o +.k6km! YfXIqro MfaúW߰SBϴ赕*QfPf!ZgfFa:gfXYrvt" a^SGJ/js`ODb2cl=3ȋ out߿t߇toD$
WDιpР!! r
rҹK q%t-ΐt=T= t:tto hP"-Ǒram(uVrLmB@u=@t=t=`	to=`uSȉ6SfaPSVp8dtd upPξp8DtD$ ae p^[XSQheO	8t`g	G	Y[CV@ 1mG	`G@ yajooS!WS!NrV !W'`j @ |}Y~{Krwrxx
k_l\mmarr1UWRQSPV rwj `ur(ffWR@h.l	fZf_ u%p[CaPS5	p޲u@o@ooo/ b oWb od[XF f csk't 	 ^X[YZ_]c Èoo  ĠBB h fdaju
!o!ddfdpdp/d6Itd@d0)ddQ/o!oBfU}	f]q,>@u%ttt t	tfN tF Gru@>"#^:$s
@1"36{uoF$& ğD'
(SfQVU't*ßt؊ـ?fPfD@Sf /T30fffXs@A#"yuptLuY/f3f<f.oٛfW1.*&o8fw*fF*2t*܊.&ofX^fY[YCNCo Ӡn"pf<"=uD{pfvoHy lx SQVWU&LC tLC wؿر]_^PLS-120ZIP 250PSQRVs
q`<U<I=|5@oߊw]s
hG>rgnb<tV< uWQTtfk :suFfG(ZUMMNȀXX  g@҂ZYf`LCu oA;OCooowo Jo?\ARWAFBAߊ'ￆ} tEe_Z[M-Sys   DiskOnKey [[S9BTPC uy @  f<x fP pЀ uM"N{ s2rp0{0w>|=1s 1s	p mc f@fPuLssuct6p r)g&a_ug&QOg&敽`OК߸ ؐ.' rLTf<VTUbUUPUVFBA߆We}X)Ưye0BpB th;"t@  u auu aZpS3ɀ/Awf?5f`:/5!y
~qefXuײ?SU  TBTQTUbUUAFB 	 zؿgر`_CPR)r3WX>#>;X>
<_ytvh"fu;v 4  h}K ݆Z ABu+`fs!$?
u$D[p@=@ -r iBd8區t 5v` T5d8t|vh!mf!d֖dЖ5x0@xp@y@y@y`Og 88e ))88⢸: : 5fWQf!ہ&Y ! D5 o6oo膽sRPotԀSzD
$&o
ĈD
𮱬Ss f!g&|5@er`耿r a`xyeMyα %@`zH\
؀~Юo
܉\cseo zѸz0ځO #Pr`4߰'!&Qp"W3*#sriD=1WtPŲ9Y0|~ô(/rkȲPu6Eo 6>PrEQfPf!.|f.6|dgffff.PfXYer"gYͭ09*_?UՋoXYӤ
״%0ٰW%¹D/osF` s6ɡatd hPsKg:u`(uI!r?u=@t=t=`	t=&uWP'YfapQV0L	;t	ž@׿$pرzv`蠾CQxO	8tg	G	C-0 0  r      Q  > 00W 3 0 *Qqu0 3 *q@rr %3@
	 <B	1	t	
  @P
 s
30d
 @UUu	q3S(U	? 
? B	C	A
 FA
1q	?F!#f!   #s3! 
 H"; AU q% (qU
3!7)Ĕ.3150 !q031	
 	q6
Q2_ }1
0 # 	UQ;< 1p5  s
;S<

6 
P
$BUC1s 2('	U	'#&>.#<<-Г5@s0 !<(0O3@u O0O	 ?B@CU.U.h1
V @ W8x`Q%Yr<f.;t4Uuf.# Zf  Pef 3zgf =  v	  +v> f3f́ Q`   !b!b6Ã ;tQ^@ bՉbbb cǐaǋ;``t.g Qc.fRfWzf_fZkrg]ffQ]\QAkfffROMIfMAGE ;unWtg f3TPQ`iJ 2ҀfGZYXuуwGώ0G Rt} Rp2hƂ|t"tAww߀ t	pV  _SQhÄtuY[
Y[pW  { 霃uBsu'f t!w] ` @ RnG9} GGfԓf쓀fӸ ]3; փ!>@͈W ^
]ȎkkAk] `Akp>t uaG ]  gfA8  N hv}'zh0l3k  o ``
PQfWfVBkUU* UahZCf  'Ga .;kt3f^f_YXhB  RW0 3ɥ	鯝/!zr`0\.YC萜2Xf36 f30f\0fy]f`@c@¨S2f;TufͰ>>?.򊰅e󊰆eeP.y&P?`@`Яr@c< uA؊б?1ctXr״uUc`r/Ȱci$8t,﹋PSr$u簄n㰆g`rL2_r^G@3}9%38r `ˑ./mp@nAk o	0 fPSfQfW
bf%UgȀoȂɋ0y suf3_ɊfpkgftrfY[f@QP@g<t,@Ⱥ[f$UР r18tfG⻻ιr$@U1@8t@q9UvPF X P..}AXP..}Xq/ Oo/ Oo/ Oo/Oo ?_
 ?_
 ?_ ?_ !"#% ?&_'()*+,. ?/_0123457 ?8_9:;<=>@ ?A_BCDEFGI ?J_KLMNOPR ?S_TUVWXY[ ?\_]^_`abd ?e_fghijkm ?n_opqrstv ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_! ?"_#$%&'(* ?+_,-./013 ?4_56789:< ?=_>?@ABCE ?F_GHIJKLN ?O_PQRSTUW ?X_YZ[\]^` ?a_bcdefgi ?j_klmnopr ?s_tuvwxy{ ?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ ?K_LMNOPQS ?T_UVWXYZ\ ?]_^_`abce ?f_ghijkln ?o_pqrstuw ?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs ?t_uvwxyz| ?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$%' ?(_)*+,-.0 ?1_2345679 ?:_;<=>?@B ?C_DEFGHIK ?L_MNOPQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ !# ?$_%&'()*, ?-_./01235 ?6_789:;<> ??_@ABCDEG ?H_IJKLMNP ?Q_RSTUVWY ?Z_[\]^_`b ?c_defghik ?l_mnopqrt ?u_vwxyz{} ?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ ? _!"#$%&( ?)_*+,-./1 ?2_345678: ?;_<=>?@AC ?D_EFGHIJL ?M_NOPQRSU ?V_WXYZ[\^ ?__`abcdeg ?h_ijklmnp ?q_rstuvwy ?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_?_ aL8lLaLc=,lLۯ/Oo <RwS2.  [Kø K Kа"KKfQhv fY&SfQfVfWf3ɋP&G    &Wf&t ffBf;g&GfPwwUtNtGfh%3
3؎QgfY tgh, Af_f^fY[fPQf!Uf&fgfdf=CTOI A Cf=NFOR J 3fSgdfCf[ u|ܿ<!!{    *f@   t6f!f! f3"DgE 
tfEF!t{ f!}	"C< u"C u-# u rPmgdC uZr++Lr+]+>r++׃0r++"(r++(gdK&.f]fYf[2OXfRaQh
h 44rX.)]~0VfA ]fA } ،A M 簎p+E + .92:+l;-h41C2[fZ_344 57(7A u8 9G9hm>r0fR;hn>Zr9;/<O=o>?3PS 7>[ 3S (hB!
rh
2f[èu<w'>, uߗBU$<w	T_Bf#*ۂp
S>+ t7 u1 u+
$<t tuFrӾr	2 [3PSQp8tZgf&gtKaFr3оg&G 蔾su0^ <u$
}3` ^!q]O   2 Yq\P\A8tg~@"r^ \\#8tFtT^3`!X	
VȿT 8t"8@7r^SQheii^t,&
uҽ>ut
$BsE t>  nZu. nRqt$co	&
sDp
 P
tP YpPZ	>X2
XhD@U#t4 8@ Yy+"utCu+vZ  Y< tp
$ on aouo@k/i>0|Pj؀
	Ѐ>t@*t_ÀP Y	u Y[ ZYt׀>%PUru
~jv ~  "0Z$tӁR YoViQtZ~ѿr KƷ5tFx]^Cat"Q_rY1|aaY\q5tax]tR XrDCaQ_Js_u%
u"2`(b25c*tzu Bطc'b ; sW;"sQ؁Bu	8uPu"!
u蔼"
2ÚyBT	 
 
	蓽t 芻 Yy 	*!{qPaot XSfWPvt
(4t@d_8؊f_[À%/Oo ϭ/Oo϶/Oo` }@0 hS'

ɀ$ t
h#eY 
a`eA(@ u B
O aïSR`İ!t@B*$|Z[WP h#Xgg_r`ܡfgfafQRfWPSf3
f0<  ̓P tf^; X Dt`좂
[Xf_ZfYù@ fPffffX,fV?3ɎҀVfơ$E 9f^@&9f^*BV?T:ϒР
 ^dѭfVW`_R$g&'0gf p%p] \WV .- t;ъA'>"؞>h5!,Q->Y,^Sc[>0uło,,Sc,.02@8b:t"FE!+;$Bo#uUDl+nG,VF͏^y<6>GB+$`q 
a`&膃aPRdu" 0n  
桂 ZqPQW,%G_)Pc\8!{9!{:  .t9aPRp tPfffXfff$p, Qʁ<YPu`36P~KR ?!` 
@6`XP̿ f`
  h(
 33 #PK   *04pTs`QW܂	
0  Y*  m*bI]*b9M*`p\4QR	"

fϋA:t
x	ZefPRQa% = u`= uo= *^= *oA
 
ZY3`  y) L)a)aҦP@3f\ 9t aP3
9\
@#p˺@#(@#`*b@#.@#A
:@#}8@#PQ@&@@#D@#H@#_f ''U'','0'4%'bP\+`#^(+pgt/ N*a3SVC[C vS3ۓX说tBt:Bt0C`0 [`,t<w>to8Pu |@ŢnAUPu
 @)軣4 Na }rtVt3#U,7C.CyCr`,/ {r#U۳7̳|<@fP7 2&8VWCr5 #U
7	 fX`,3Uc98"7ע5$!{`<t1 2-xA2=T9CD=.fr8RA:Qt08=Y 
:HPuH V%C@>5utvGV/C|aÉL MH6

 N6I6OJ6 N6؃NP6P62Lm
s3y@s0UUY^0UqTTF0UӦ:u;Xu;v0YtXЦP >ID0*0\ 2\1x K!_H:r:Ȉ^&11GrܠuΠ0 	&ðE^ ww
2Lpr _dyY)
À
v(`j{>P/Ԁ124j2jF10 :x
PP@ ؠu `w0`ῦ؎ Rf쨀u!sZlf)aq rrsntߦ/x q}Ѐr( ؾ kf&Efcz_ @{  Dp{ &Et^p{"D}B~$D(Pts `pzC|DtȀ >@" po
7&Ŀt
_ `tyL &}u??u8&= r1z`o&
IW$op{򄟑 `t` 肠mpm 
 m'Ð@ !s* $p2mOደ pP1PQfs   $<@thZ?KuKfP]{Ku냘`.>>sKt& Xr	NRrn2kk蚌k(aT` Xrr SXn#!t Xrk@ X!=ΨAo`op$?a+fRQS[YfZt cz;G t]GtGu蛏a2[%p6_##ep69t SRfA^2qE`  b.JhJ נ 2 4 tR ft<Q Y A f7A p  u 蟭A@gA"A"h8? H    qNCYChEpaO@P£2QĂZfA  hvʃѰrPrȼPR 0轻00Z`SW t& ZDEB D3m^P<PR3O0YC h4=ǑI;boԊ'OׁՄȀ f`.&t.fvt<DZ6LmC(>D2t*
lDst-D0WD%蒨K !!b!tӑp]:!4*!!
qC47D!"+"_5t4
CC4bն1֧PX3}pbhՕbzfP"4 u3A1P˹
Ѷ+Pz 0!Sz33 @f ..s^$٨9$  ` } o  p`ы ` Ķry`z輶rqh%3&@.f   Qff   輸fR}r<fݹ @sr( fr ^r Vr Np6C # @   s讵Qis-]#J3.;'tH\q㵜qrA#!
䡢ru_!P* 2+aÜRёllJ쪊$JlJlBBJZRW(O/A6@=PV_ZR Z6KQVW  _^Yq+t	3y aøo ˶Ҁ#sq)q #G#h	P`8P%}Q+Ⱥ:#%8  t
ف  P@`j t(  u8Xt
 %P* Pé 0)3%@*tOsHf3 f0yff3u濸  hfff#f  
fηh(0t#P ha2ʩ ]  e2_X*P&%q4X$vPSQR.%14#؁'2&41'uS0/ /ff*  [%8%%Q#`Y3#044;ff% 9f︠5$
4p3j@bMP> <`>9>gP>!'QN
@A''f~5W"t6%D pπ<
q9f_Pk%m !I$t հ"X$f~%f#!+$% 5 4J0q1FaC@+
 q"qQRfq9RH)ظH3:)3Q(]u
Yq*QHf7ZY3AMSUNG
bRLTN150XG-L01
Q0P3SLGPhilipsLCD
LPRE06-A2RNUX08-A3M1AUOcRzaRBR02V1`RޞS41XB@S2
?IDTeCMX[7@S6Y[CBSTMDISPLAYzRD[EA0VRVX5?]RQ[3
XG01VV
 &&&&&&&&&&&&' "$&17DSc "&*0DVlvg$(,2DVjrh*0Lbz~Ag*06L`t~"$*:J\hghFZrj`k:H\hj&,0BXri(,4J^v~gBjRm?.4J`~~l h>Pl~ .'àPpPpXÀ&5P68pC7 uL =TqA~̀>?X+] tPSR%%3%  Z =	`M` 5jvPw԰wvZ 33Sfv] fI_fzfQA933 fXr{3=*&(P(z*¯f~f1.UCESu'ffRVf~rfbNffff^fZU׃@MW"! `Fᇍ~ PfXˀu   t ` rWf   O~!+C@ t>0't t.atS
 S@  [r~!fn  !._QҘV#ؾ   t
ff;tw70
 '0'pE{Qhhr|{	 u2p?!Ӑ2
fffL0h=h.T{3ҹ  &hY/GVU01><$F10u tS }]^[5V ^rVS 6yD2[^ԨPQ :D~0 +Y dꬱ{ᄩdwDQkP>rd "r]rPP 2X0XP<s螕X1Vͳ+[<u `F:<ܷ}%P>6r跳r#PGMȳ讳P> r0xP>`лi>:?,m,s,`~s	,r Rq
Qa覱r(s
*rzeD}r |r`Pí,,,-V~r .,^ i VWQ>` gK Y_^Cʊ3.:st
$ .h.tbDqm2h;鲖t0ޜ{h-rs f4f`ζ _Ҧ` u
tor <K@OfaBf`1.XRf7VfW M3~< t`NXf_fֿ/#"~ڹ" hf`ր3赗] a2V큡&?_ޟaà> u( wteg (au!>tSes au;
auu> rS !89:7 > tTPeO Od2Ou$Cl$?< uBB qQW<u
%7uggw@P_YTG	7
vv
x1S OS$d OX	aYtS
  W@r v	yp
^ {Z#zp
G|a6}P6ð3UJh/ru" 0 qL2  խppp3  gff=HIBMPw u` Ffۃt.ft%"t =kt#1!f[gf&pQV А=q!tgfF àgF(P+  a'SL)@ N u;gf~fgfVf@  @fBfff3gf1@qsfY*+F$ V s	7f!(1+  fVܡ0%N  ~(,Ffg!fo+s
	!Gf;s{1,Ff-f@4ffQt	d.fYf^`'N //Vf fAg=uQ4$fIg8A4v4@3,,Q-7fƹ015f/ .4 ztB2ւxG.>`CuC%,譂 <t=> \}4 o*>GuG{mbpEqFkG_ t@5}4đڒtÑG-ƒtssN NC蜐 LFP&ݢ&X?>&  pREduE)MEQlQOREDST`3 /<t+
t&u
$&6.EaqfWۑt"跮tquCst	g&G ^!f_r譏u跎ZKu\>Рq&tbcr0WV&8OufreSՍ6W p 2:> u6 jHt4Bjo hfk3Ҭ؋hfB^:0&df}S>bj2ummQnm0k>n2PoΓoPuoplq^h:por.BKBp
..`~9>6 @u:XT qq~<]ٜ@ug\s  uuo!uks "u7ߟ1t =?
u4|Q\%~Y"PņSr%s|,}PB>:9 u09 >;9y/3 Qсq99(; uar6j?p O?_ߣ ?_a)Q69r[>1 ouC:L c 61%3Ҁ7BBM 8u!u
{ 8uѭt	3ҋPW
 
t	_ ك
_XhS]'qhv(f33ɭFp4f
,f ffup2fdQRtp$fǝPZpлtH󹫡QVWJh .# ~@ 蠀_^Y^螜r"VM#脡<TPSQWh[qr6hl,tQW _Yu  t
t@u_YdG;	 bĳPNX dPS_4OdSA^0u2C_ [Q2P}CщXx2[b.P2
Pˀ$
ÀuE;Xo[X})!Ω؀  {
Ύ2` P(<KrKXF
 薢@ !P/*a f 7@3f{  @%@/& .fq.r
s' f@@_Ph %>l_ft|p\f%%@_ PfWf>&G
ѠX<t< ^<lGlPS$<w
.>d o>pS31hBf  ء%f[U? &U?U?
+ LK 
8s 50Pz 0V$<
v
ط   tǀ>M?  $
2ho$@G
-d t㋷j&؊ C^h~e
}
-dS!
 BEBu M?&N?(! M?N? >N? u
8wP"f.7s3Ph@fA@ 4A@/ApA? g` rA vdAg
A|u``
hA.
	 uk #oj# WoY/SPR.AZ>.Ap/BZb""
ZP̺1AAΰJJ/B  `Ǡ1PB#X3pSR0ċذ4ZdQSW _[/'pك(QJya*a*?g?a*	C%, 	
L-EE/;K3EGO?BK7EHV?r1`L1CCMCaCWCkCbK`Lݿ-H?S 3oHg3&531C5610.&5, ˰D5R}0eW	  X f033ſ\ 褡:3~;_fYPԴ9$:: `7f.CQ;u&=CV<:[a=o f.>fA;7f.>ZD<9` ?@, pJBC	ÔDxDDD&E,EDD  cFuFFDF' EU_UEHUIAIH]TQTL7KD\PUUJU UUT 4MM J    T T ANUOЫLPU &tH{u
h9qul/qr*VS>,ư,~
j2qEQRR?^@ucW?u
 됋WΐvâYV kPΣUVMX PX`Iq U@:q0 
03!4+t
3NO+t3GNO`UNEEE!bN FJ쪺K"ca`bab`abPc FO Fcfcca%ϐFhFs2.F/rR"psf&Y}%h;S>uhM\lzhalzth=`lzhdq2u"toN4*EsuQ}u%3#qYBs3PvDr"v& 8>u
Ds {o@4o@ZzP&34[oX@ZH8p`HH2Z^ _ 2dqvOUV<202 Pظ`)g$`([.0>' ^]y2 	?UQ FډFw  hB35@kВ`&&+&+ !AAFF FԀހËqiw
upiu vj`qkrYk"k@Z7`kڢ8w&9:y)xϖI,Sk rIPir<Mw&?ѝt u'fr6^iu#  h4!ؐn3hӷ2q$>!x
_ > )xGqpwߤ 9J8ټZZ{  :Tv ׼H8 s@^e49vPKF X P.J.J.J1XP.J.J.JXAK&AKAK$qvd@͝S8rdd}rS<dr
d2ut
w_ t }0d1R^!Y0YK0YhcAhchdv%p8LvhvpStsP
µRm@Z jVx˵õÀ`7?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ ! "#$%'?(_)* +,-.0?1_23 45679?:_;< =>?@B?C_DE FGHIK?L_MN OPQRT?U_VW XYZ[]?^__` abcdf?g_hi jklmo?p_qr stuvx?y_z{ |}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ Ŀ?_ Ϳ?_ ֿ?_ ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_%& '()*,?-_./ 01235?6_78 9:;<>??_@A BCDEG?H_IJ KLMNP?Q_RS TUVWY?Z_[\ ]^_`b?c_de fghik?l_mn opqrt?u_vw xyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ɿ?_ ҿ?_ ۿ?_ ?_ ?_ ?_y!$SMM MODULE -- COMPAQVERSION: 1.0 t胓?ǀ> uS4uuu&g߸ !瀯 Xs_m[ðDX$ htvߙ r
8 	t .pD
y?<v A
-  !:4:!ӑƅo#Bl8ې[Ӳ">G]4D  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffh0	t$hp$Ūr> .<t
../!N!!NfafPSwRV 411fpr  >؀tU.a!/tS%B%
%N&N-h/	^Z[fX11#1rP.4XPSWRh	 > u&E *Ou&} u.C.he	t.,Z_[X`-[h	$&]r
%[h2^2%^4aðÀ>7 uCe t$<w:9h%	R>t"9t9t`9 u 
ZSfQRW9&C::%;d ;<_ZfY[ 7 t|T蟖Ts贂jgP<W6_p@XB..C.?.ø  PR?BZCEBF3%0u$bH` um >89&:-  %AJt0 	 	qL
  3  ti  MV ".  f@@u.2hD	P)P0Qt
R<0R@TU;<x/GFEPFXTX.$'7NNO$1O"FYZq.GfP3f&T fOf1w,S-V0L	-xs.stH0_.S.>>sR2 hP	v r?vd r,wdr rtB=u
po.H0][,k b6H,@ ۋ^SF ^ShB	[^ l   R6PQRp߀thGct
.ZY`)E؎ffR. n d 6f30Uff,W.s8ss> ?Qu>?v2U :\h	ʲ	f0p  ff.4 QsffffOO}o~ ρ/Oo ϊ/Oo ϓ/OoЏϜ 20ؾ 1pP-Շ*   Ȏ؍6; ўPp6Kd yv`X1Q
 {\	`fhjS9f`PX8  G ^ PO  SOt% r  P"#QO﫺(*:43=s!tg@U끰2)fE0t퀳,.ZP)`p&  !012  0m"[ N%@F`KZP    NuiZaÊa$v$
aޡvCBPBB#"w2B;raP;'謻!
 QR"R3ۓ	uρ  s5#ô3U{fwB7R7*h >K u&I&O5%L.H;tCs2QuP&??,ȁ%81@Ë؃3é t"q@ﾙ ha2	  Pєr@DL
 <%I IW_E$<r' ddS蚵H	l4L`fQ T h'R9`t.
h(#y2f   ܿB  hcڿH hSncڀefY!m|!`U詽Ff`h_ "PmVUh	D
  t{| uu| up QfFFF 
F쨈u~o2Y<u UF ]!YnIu]^o`  mߔ@qɾj af hS` pr^Gɀ f  2f3f% y
 ?0f ` tofIAyf  0pp!P!1 fb
 `0XX!"f`p]fgff%PgffPe e``BldaPDCX  D ; Z x     0NmP
|0	s<Pw2 rCfWfV0\sS2NGf<5؋6f6f;f^f1fSQfRWf3ہ> w;0ptp>K 2G%GGfflf _fZYf[SQRVW6Ȭo33	%	裺*//h0RmZ0
U 2.T
p@07 2e2#a+= v cp_^Z@$
W0
>	
u``_S aa +Qt$t" u`!!P.yt>*袹$,$+~$E$>@ t:@s@$qÊ&P$rsh'%r^A($rTp$E$:.''<)G-#^`4r%)Fu'- (ðD$&J ]gl߫%`0؀w5SVR_S.
[.t^X 2@2^vX\+xÃ&%&D@$ &06*u&d dtKs	2s@xw-?< W-@tٸ 街$09	p!;q9p.Q.H5D4 ðd. CQ-
`.-.y/YPQŀu	Qt2-̫X-tCAx, ø "$<G" P<H6,ð33`B%, 
  KJ&@BM	 ~3MHȃIⶊذJ۶2ȉ  uqQ Rg
R@u]<tuQ0u?IPTqS gU0@tUwtXTWr= tS tD3ۊ:t
u
> u'㉇| 蝶A\ߜ@&
" [fA\u$t2M	a_f^]ky畦r^fb w	a"1&簢de-xÊ'È%}q%9%0;qO h#n$t
\pi#nh#n.ѻ @2hh֧hrdVnݧoðh}*hᯜhۆ`pprfZrhrrsqf>QPH_u(lr#  f&fbz {_!`òy-+Wr(6z1{zcAr{fRfVh ftYz uN(t ;(wTf6*tQ r?fqgbgBqgrf
fA s[f сWf> f ? tHǀ tf f? /#fBfPfQfp$fftgf&
tg&ofYPǡsւ09Ü͟ fbbˊ 2<w.y
Ql`uFx 虲?t@$\5$ѝ2MeRA
!pa	?&㛁C b ^! t/ tW wptutj s tQ#
t~  s`E]2<nBq %t"; !P

	Fs 3M^ u4Y>`;>t,au-  A\7$\6a #۰Ȱe[P<^  a1_첢  d >uT>u%  [~uAtfseQ1赓u&> Bѻ) 	*Xc
d@aun<
u!* 
)?tB Ԯ
GPS55ooC01DU$W˯$Cʱ$X[t9{ !
r$̰^TGS0bpWqA[]`[&uCvZ\5_>`t'a_uu{`_A\ 'ϒuq
ԡv[Z7Dtu$@
퀟2퉱_ӴzwUmEFu!^`u
yYOe=<Ǡ30b1!{
 3M;rA}У
\y ǭS#
!SB!<uu}4{Asd!P\a&&5踬$8 ܐRD?TĠd E^и[ ŬP424[ u)1&^ s`[Àp! = pu s
aa퐸pǳp>t+&1ՠ&_
_6 r)p0ߡGH;Sp<;w?<w2q)
<w< t 
<w>r2Y[MbQ3
a$u ru[  ,PTX\`dt , ,<  <@DPp  DLh @, ,0@h
,<Hq <`hlpܠ@< <pw
p  ~ $(<!Y!  ,@DHTc#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_CDEFGbx?z07HPXYhijklmno@I	

  OPQRSU?V_W XYZ[\^?__`:a" # $	` a>0bbcprcbh0
D
p0eðNNO0fOhZckû  єw0hhS't߀hi虿 򐢺mi j3ksk脔SfpVW f !p p!ppap!p!pf%  f.2fffou_Yf|6of"uСvءvfwrGs
wvf0tBoff ofY@`}fa}0z{}QJfQJ~P3XPSVWfQs:ي t
@u ufufpv @uf  fY_^[X

RP.XZ

P ^'f6,X  
@WSQ0sHB	
  	 h/jp
Y[_ PJ4d{Ǫ
:j۫BӮf`f.1.r..16 ."v
0q.f.r.rfaõrr P1X
eu`Pf߹ hGhg XE0u쨀t
F񡛃<u <u õIr$rp ..p.C72ar]rӤrx4zp7a4R4j;3` P;"" QY;]Ĭ]ao r&.OMҤy7$' r 33F.&UҤR1Ѐ,ZQRr3Ht2ZY`ңٵPtM"@ZZYa1~r#3EYŰa`ٸ 3x f3& &EZ2 Q&&,r豂#r8t迸2`.&EO hhУSAahhh[&M.2tL $Q #h  5W hsRhj2h zѪќhۆfZrh  @σvAw35 &E
},1#11	1	21ahj%00` 0P% @  Da`6(  _  aV魆ī^W  3 _r-@1˸ fDf@D@@Հ tB.BO䒱
rNr@p nRпW2&*G_YS߷ 蛀&*@u&}Zu&E_F Ҥ1ڏn rg rb2ۃ<Ot	B<gtMBÎؐTr; 0rg r 3h=ɉÀSQP
pt~$<PtEKu #BŠY[Q @1uu2Yо	V o^WmPJ%Q YPSg9[XPfPQ>Z uι c red`ZY tCZGr-t`w 0 r uҊ r
6u`d YPrdItf s`QRx!

`SRNr&r!ww3҆r r	[Z[ oRS..srQ.  .ї2.AZ
g{YAsj
#[r	ra5PPo   dtgfYKuGv>? fFSeT2 Ca^[߰ 
 " @$2g, JQ)2E>>?@SV-C 1޾> f<$F10tuP"X4 g-$Sذ* W r[g PPS. 1 U Ȱ>pg?00Ǻ0?PX1à1(!1b3ء0b3!2(P>t
!2?1#S5 t33>|21/4
t8  ttÈ?aJQRWVسس+3> ? ^_Z2>>31?G<u
tp??Vҳ^ûW C_B'bC@DC!>(P^@ϋ7??jFBB?q( B
g>2//\r`LB
"2PR9q?Z!@V7 tU..FPQ/F{.^ 2uϐbSqSRVа7rNPUNrC2r<,r32trr;wWҀPsڋ^ZW
@T  е0u
˾   Su  fAT u2_f2_ J3322^t__ `Zrnc
$	"
upSƋ߱d;sRZ3bFcF252tf	uPz
S_ø
_.P.2.la.rys,@4Pn~PÐ< <qߗf <`T2<q
 h =u?v _wxyz{|~? _߄? _ߍ? _ߖ? _ߟ? _ߨ?_߱UPRPRVFZX} RR3Z_ ߻?_ ?_ʟ ?_ӟ%ՌȎ؎JЍRwhvS=`LSiqJS0ff%|h f
  fȺ4ًf#puOt\f   t(,#%9=t!a1 ًȱ tf.<fuff[fYb	-CcۿSW   | u  ߻ fXX	m^f=Rf=ø  <Zu!瀠X?r+ nX/<p;@X h|a_ f r=`  t	f01Pڥhú:t-t
cfXúA $t"t
D% t
H"W2螌fd￩ u"P!
 {t 0F @+ d|@% &[.QtC t࢔&.Q u'u! F~0Q t pt
Au
S% [Q t!A	uo2PRu+1F
P  3%>`7
ҡ%b< St
b0b 7RsA:s u
A!St``t	t}
Z2RP*PXZ+c.Q..@ۺ8aPfSR. 03.$$,!fp?fZf
1ڲ@% PݒX"#8#s#9P  r,ہ2fSJ@>ر#t7  h'v fȿ ff33u^_fZfYf-R3һX3t@saG `0"`#hr.
7 10!%pP&W T <xff   Fx_fY[S1hSc($_`3%0
CxP
t%-؃2Y!"`a f 	!=(
	
	
=fWfV3  gwt܎f g&ff^05p.** End SetActiveDisplays: \ R$Yt5q )㋗ød_R;taF _uq Zb	Qg`G ^GiuuuRH`RSQ2teFS
كA5  }@t@P  2H?OKPb3RR aFL3`*zJS$S?D HUu
_ XPŐnOOtBX	g9@ {P`{P$O{{ċ؀̿ {X[{X{Z^+ZV[]\p]I{R/ xZ\R\ t[|{PbÀtp]p[ap]P`QRPSaF[X3 Ae XHDCeSS
RUr[j`i/`ƸPPOu" arW2s_*Ae3tr "$& `qE"&]B* _f'faP`P:???j:b	VS&fWU]f@+wW_p&ð c	y  At rH r`Pt *ء&W>{sftuo Us?@3 XtfWf> f_`t5 tfetnIfgflg g_<_u	҃2gaup>tQ SP܀AeX[` f"6&dAt/O  I (v ؍൨Q(aHyx1t]Qȏ`SkO_ Oa'<`* OpGQ_pS6dWP{ 
<xp& :` & #}wV2&Ƀ: }cfX$
u'f( ffCTNIgf <oPgf AXt-t5tLtWt_ p zf:]f!&uA:D1"$&ɀa\t f3f& ffȐ<u<찯
΀<ff9ݱ鱄<u]ff@ f=  &f=f=	f=fu  u%^<J0
*@uм
ммpsuqD؊Đ$
npu#q   A qu
qSмp	p
ur`q% tx,tuLp3f!tf02  t,  t#`ɀt  t
r5#;u'Gf5 1$ .  f^S+p&Rf P+pQѾf ȿ  

 fw`тffZs.px+<: 2A;0; 
 R=	:wf91` ?&{Qfpf!
P;f?f=!f+UFT  pR Fp u
5y &0㾠@ ᠁fFPEfN@O*@`X : 8u	@f@f	^fvfX&$fӃ,!(f}?fsXbfXfXqõ4®C7DԹèbwĨUD=5uӓ
n#;[gېyFu
ӍcAHԒ"Hӧ>GQb٦D
cUUD5`5>PXeϹsϴ}[h	hՕR4AlиP	 sϹ}01	#h	S rϹ}ϹաP
	{  s i?}  0lu 0Mٺ  33 @f  ..Ws נ!
{ 
PKh%3R4& ۋf``DS a[XfR0Ca {PSK Z Qfff`Yf &XP ⛹  @:p2?P  $pЫpPr rwro
u\s
Hr	#rrXΒ`l`q  ?CҐ
Dr'1rr=% LܻM hR4u؝`,eyu$ӐaQ3((d BB)YÜRp*nBnBB2JJnB$-nnZRV!(//@/6`1v^ZáfQVW  _^Y`%xG߿052䬊5aà
!  js-Wp这3.; tt[=rAhpp'+t3Њ5 <w<=a&Køл
ûHF&os;OF&PF&3;t<u m,J.^   PEAEAE8PE9F:F7 øtðqKwq$~`IÀ&j7`Cl` aÔKؾ#L]LkS`333 &&P4[wÜ`#  0-nnt QnJFn aS [TPU3ێ7!C}&?!C{u3ۏ&>CPQCu
>W^ _bXXuYR .'ZP}h%@fh< S .[Q3@ P= 󥝱QÀ>QG~1IuqIu`&o&OPr7^ߴaPQR
cf_&f=XDZYXð@guA`uȰBYu5^frqf޶fS2c&W0cg&u&87u&8Wu	&*gAP_`
  YP#l2r(ں 2!l t!lS'sz#l
y#pSq!l@
 qBrWX`XfCu vevt	 r _bc@fdnr2ostqduQ%nYP_ XSQ# I аOsL迼s;vU&J &t uK H
QPִ薫 V谳XŴ5s{?1J_|>89&:}h7d%.հ~3Ɏ٣gi
r. u	ujPQfVfW@hq]gf&@Uf_f^YXQWV~ ^_YﮁD̨+t1QWPPhX@.X=X@uX_`QYPۊДP!.$>u
P r@XuSWh , s h%>&M&E&MƝ_[`>av$PnPt3Ơt"3&MaE<tað6C @TA E6FAE0E/0  h'%1fPf{KR@`PX߅48@?+ø@  ЩЩ.&Ciۓ'\f>PAMS> A K>f Q@Ef&E 	 ѳ/%ĳgc`ׁff+m@MW \?f  PL23!M hBÒR )VqQ  <X@8ȐBf­dfRh A˪@rY:0N E6fP < u  4h,hr?RmЇfhۭ pr"h;M%t.ʳ˜җr@ `E<u df@q2ؠӀ ~X`-Ofo  t3;R@:Pk"aU`Z"Ў*QIPr|=t&} t$V" &GF^P` XV|P^"Y⿃"a0XY  ha2%u0. ~#&;MR*:þ 	 hw
!
w"]
ZP v& P~̀>?prX XSR@S[prRغ0 t߃@ZpJĒВے𒾔жq,&tImD>*lL.GYXCItIIlLJ
Jlᢒ=D'8lL䛂{
ߖsڟ>\TݳlL	lLn#lL`lL1lL\L~4\Lww%iL~x7ȫȐFPx:'f.u!߀u <uw2.kf&
b_Or.`9­Sp]ذsjrj[૗[fS@Vf ;xV4t`X?upf_ [ff[`n_ g_MѱK;`t] tw u_` jA­ff؟ՠs
ѳR.hpZf ͉`!?#q"vf̖ uL#sܲd /­ֺ`/0w/2 j%hn4F sr dk)1Q&hg*+fQfWs`­pft,f^YRѬ_Z ^@@ѱ(Z@B?%oBBsCEAeàa)Mjfీsg]  rC
vG,-./01289AHIiL,014589LOPQS?T	U`a 3 OЕ!WtWa`$a,PSr 	V`CWGWS\Y[2t0aÜ`h0>@ l> l`GA lBlh_a@_6`$?CP`! GAc@cA ccB  `b$0sFf@_d_ o abbÀd  BnnnJF$l%JFúOkflj V ovha<	 tq̢
`ròp̮ṕqq@rbPޢcu
   llB cwؿ `lBB`wM_ l z zՂ z z z l`Savhv-wx=xTxZDa@Y@
_@  1wFFnTyn@znznzUn {n@{n{n|nn}Py_`a0rt1w
a@ww̰pu
Ra1xynntA^	 n!P nbYcYa R%> tVb"$Гb&b
wb$ȡ
ဖpbГbb$bbb
 3}=QptЙUߛ? _ߤ? _߭? _߶? _߿? _şƿ? _ΟϿ?0_ןؿ`L ۯ$߫("d ܟ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_C DEFGHJ?K_LMU  p   
5MxMQRT?U_V WXYZ[]?^__ `abcdf?g_h ijklmo?p_q rstuvx?y_z {|}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ ßĿ?_ ̟Ϳ?_ ՟ֿ?_ ޟ߿?_ ?_ ?_   &  u    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  @f[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 jea*
`e eueۚe	e7aP 33Ƀ t	APuhe&>ReaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY2 s1r `ABCDE @fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 &@
VfPhPf0  f.e ..edfX^=Bo>f?'Q@g Aoo1 .;dt*0t .G ATftvGnf  4 t 虿j u3  FEA#FSHt< 	[SAN> [[ÿ t$vNrqo !PSQ3۹)Y[Xf
	.`As.QI..Df.|qUfVfWQSo3rWt| uX!\t[Y``C`03k;B tS
tw*
t& 	6Noo#x#` p te"eCfTf6~
ߋ^ Ra[]
 UPSfVW2{ +t {f f t]fAhmP[AQ J rg>Ut2gFYPAXs\Pf3Xsf	][X]Sf0WfP f f;r[r}Wik mAюAog_Pp?mSn Wo._ p&5 rsgNY	g/Prs F@\ZSWP7gfFfgf;PCIRu-g{ u	gf;K`\gCufQgK1`	ffYfX_UAND^AhN s" ZЅ  QЅ `fn
@ zG봲i <7PhNV vy@AN"Q3ALYaE=5X_^Z0Q 0  t8Y=Qh8
Qf>!?f}?ffYq@~f
6ufWS[a^fWV߃3Y !P1폖h] fP.j "  ؎fVPf%!0 ԟ 2gVF
uNF3p	F8ȋ^Vuf
Fr;Vwr;FvN3Җ^i gҤ3E_ufA+FV
+FV؃ ⨂P"  m ' 8/y
5G
m> uA ౩*eF 81	j jFPFPN!' Gj F P 8V
ѷ iѷ iq~ ugzаm  òi{Jߘ	h0౉  WVߋF = %  k:؋.@0@Ftlf@P8FtF% { +t1Ht	HtHHt&-9Vu~r"Af~  r~r	F wsVFsF^_
  ĴNf*΀ǉVfF`л 
3Ft	p(pH _F@8ҫ!ҺP_؀tԢfҋ q< ~ut/tr!q~$wҋVjfF~ 7	V@V@^je(FFݘN*;~^ uݙ
)RPWVޮ@uFfHufFV;tL+=tݙFVF͐}!Vfn!J0W
q!a3;Vwr;Fw)FVFVFًFV
 eƁ	A>fG@G3VQF | j*΀#@p@f`N+TRP^$9Fs$#FVhDfפ*P^@RvЊY~ t	\Ë!ARnr:~t@#f+1f t_FPP` tc";vf9GrL+sGvfGf+@ fvv#?AΡ20;Gs@{~!F Q2Qf;OFv8Vҕ5
@f;Dv3יF͋VP2WV3vF k`sP֠FRPߤu@0j&PRꀼje uĴNF"FP2,ƉV=(ut'*$<u؋ƺ /RPeA,뼀~ [u0Rke+ұ8!a^*䊇	7> u ;7Cb5F96hew٨APSQ	u@A~+9D
r
w9|v&vvD ҋ^10v 
Ơ p)PH+;Wrw
3p) O;w`ەĴ a ~15NF Fa3ϥm`8$<uP3 FߋVP3SVbԑqCFv8Hw`t2Nf% 7F l~ t@f@f6V{;FVR5b&!(T
<!89Dv`P5A8RJA$3BS
wBEFsK5./0"a15 πtӊFtʐ$@M4B46HM3
6@/7U8Gr S9a9;0fq: I lgf;<!=>°3PhPZ3  j
RZ^  YPV+k:F%- ұwŐ0@]^_5``aFt߸!F 5?  %0`Њ%ypt
0 1gQТ1TATr`,Fkv1â	PbsF t'5  P^ȂtAP^%5~$sppr% afR		P^+F̸(3QoPPOWV*t 4
֡^$\;u;U)u A	e{+uV0Murs3 FP^(Ц=b ǃpBuNpPQÃTmF0(/k:@2fut@up$/;| V@3D D:B |/  :ꢢe	 <h^# FmFAw@1WVLؐĺ@F$<w"4k:@wG )p) uGW*@B= qяG!t
< \E	E	 1! E*= t0pjPEue$ + 2Epqy =A $R>WV}@ ~ D4W@
f+@@֐]@VPZBBɠDhN$fР#^``kN/:ىŉ!k밫f@ Q1_<u%F r2`Ǉ@PPBy9v^~wk:r.`Ǆ@$~@0 Ċ@2
8 $Vk:@/Ј ۋ
k:9@tC9;P^_áP3q~6@tu N>tFˁ@$!pt71uh_ϊeՄqpEp~XDK `}#@96'tbw@N';ta>'t>ԋdՒ$ S|~ofaЋ^0^9F!	FEz	Avv^f$4G2"M jC FLfq
P@g3W2
6
p
@9 ;WZw;Rp-Pf~ ]WЗ^	 *ph jqaS٬٪ VْpWu40^tp .3R>q%uk %u~W^KFO`[D]@`O@WOґ26B4-^:pu qu ?wF  
0KƉ~ :vgRd  vp`!{:P}ty1LhAQ0OS025mDQ9v7GOpfEwopO\PPHpVFf*cj@gv8hd2 txq!6
 t;5`OpvP2FP)a$ ^VOp c
t21gUU  UUv6[6 uWA hPԾA"OP+
*FN*+@tY>het-|	khe0!c"u鉅eeheVPSVu73>;Pr;7|  ^[XelYq%k_A`luN#p.fb߇@*&Ft>v9vv3Ѝ~@&`@ qCb`Ak^׀u 3҃ r} @3k!S*䊁ukuRv3;Ft7t- t#a++u
uGrvF߃r1B;yIk0SR0NN lFt׉vQФ蜖A{NPyyPy3ҋ{A!?3fe4̱yvhojP"px^` 87𓠢݈݀ W~_$}>'0a0ᒓ݋ǈ_@}B,.fIFު@B@Bs@B<@Bb" F,F҈FvFKaK KnAQu߄S3;V0 ϿvDLSPO*徠U ttR~yRv΀7Vx+;Viw;F`pDp8VF~U =BBACDVDVEPF?VBp+IDVJVFL8VF~;8Fnƺ  ۋ^p" 襜UpUܾp& ے[ߺ( 莕W, @BtfN F  f@BtFYJYAZZPYIs7F=v)]8j#Y]+8@fp 8\V_F +pnڠƺ ڿF֋Vpnþ5b dX0 @Bt,f% 0 F
 `e`'a,p `oھp> ڱiZ6Aڲ     U     U0H@  00IBM VGA Compatible BIOS. [ k y PCIR5   g u  d"	"	0"	dC	
	wP
@
P


p		qP
C		0$$C		 `"N @88  1X (V P 0X  d @A &06  A  0`u$ `A (000* Q *@0pu40@u= @uH?@0bo2@@uOYh[rߠ<P7tq##&'072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E` a.b .c d/e /f gp0h p0io j`1k `1l mP2n P2o p@3q @3|i}i
~ i   A	 5 5    6  j5B07   9For Evaluon Use Only.
 ( 	 c-'(+ P	    = <=>?P@@__OPUzA(_BCDEF?@@pAB  K	`7(_LMNOqH@ ITzkQ(PR V 7
QH v`7IM](
cJZ3[ C
 J	

? J89:;<=>?{] *  j**?`?? (-2 $8? *?`*p` ? *?* cb*``%( (,%*26', 49$,0	
!&.3+0$8=abah $(-2a/?'/7?-16:?  
 ]'mnq@ 	TQR Jz]sTpUqAVr L_xyz{}/~O*qXtU@Z'cv@A7]bX5_^](X@AYbZ? ߊGXH]Y_ ߒ?Z@gAO
A4[BHXgIIJ+f(bJZ[P tU>(  `x]oTptUAU@iJ\A?@Gx$VBT MONTARA-GM ѱd O0 
(_ _DATA_BLOCK r  V
 	`63104Intel(r)852GM/E5¶E  Accelerated S
Build Number: ѵ  Devѱ10/06/20037:07:36
DECOMPILATION OR DISASSEMBLY PROHIBITED@< Copyright o(C) 0-0rp. All Rs Re?served0<w9 `]  `6$	

 ! "LFPIO ϲȿ? W 02468:<@BDFHJLPRTVXZ\? D_ж  ! %  8 I 0  @@QeX<KU $8  ?W%X$3o@$q1__W/@'&M `      ߋD HLπ AA! A	    2   2  2΂ؠP:|큲 UT0@	 "? _ 5`= @	W 2	$ $$ ($
  ?_  !  	 CH-7009-!b  B#Ƴ%SIpj4p`FO-;45l
 <X x 
	P S( |  foŃF|X 9 [ ?! 9FÃyW1  
4O&  A(_()/,+,-/ (@73 ) ~(
(\	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*X@ X<}<' 0<h 		 `"76W  </=C>  1X_ (V?@AC>d @A &06γ6XD AE<EF0* Q 0@0pqV?I2xIJLx Q@
MR$?N_O=/xQ&@XQ"	@S?T4>H?@0b_2@@'M DX?GWH?"?\_]^_	[ab@cS_efgdi jkmnonopq ps?t_u^_I@/y%>@pQX 8'Mw}zd
 +1  /,%" UfPfVfWfVtSRu.VtfFkF	F]a ь }`젻
 `@wЌF`FF=@B\~@fI w'  NnVQRffZYf;F 0rufVWR᠖fFffffFffff^܀Zff_f^f 1;F}Nn߈^f~f~.sf~ t/:V^:nQ:ND~t0 (NfFtF-f~ v2À 
2:~s vv^*ߊffV2fX]  p 
Ь
 ` ,t/؃..	 
 
f.aP߰1VWQ t6 t a3_^@v t&]etemU tPSRV<v
W8_2q!fWb  <<t<t<u&Dufn  
<uC^Z[Xf.9uf.\f.|.\PL	;ufVPf(.% `= `Xf^PfSfQtfY@ fYf.; ro![X1	u cqq t Rf-襦ot+t{f.5+rf3fL0pufߋf%)0fո0ѐ2ʐr00ZfXfq+t/Rǁ̀3"t
 @#Rw8ZsӋttu
 `fw@f@CBpufx/f a/ w{ ЛYf[`  ,<tt uu1upuuPz||($ŀi&{_կ 'ۖm+?4^M&U^(6)-6U a'd eqfg!hy PS蟜.[XDՀfWU.64jހs u.w.0p=Ou
 ŋMa=_ | W(6I=OuFt=Ot=_t
=OtPIXOuAM
0 tV( F+P -X-]«ZϾ.<t.:u.T1_F`4013 W&;&F^@^
' Ëf -nf +u
+FЦt f# ߲w-}0*ftBWM-0HU0 !DuӀ-2rf ,++m#=*ti܏,R  nt)d*,R8 Sf[ u	uN}ý!Vp    #!W!!! Ǿ #&u$* x+Arˠt.9u,?
^1	|2ۄt_@ ^2=f{fr@w(
3)`P;+
lsrrwKst&
[t t f!)+ rf"!e(tZ(P$8X$@
؉PSQQq0o2;YtoQ
p srYWZpQDtM0t
@t@uY-Y0"u"t1r.D$tt	Æf^ZYS3pw1u0
+@r u%??>.s
@ {,f$ ??)(f`4% uW	a!рtASRk4Z[6p7t$]&4ʑ G?&u [&B$@ρwZ)чfa0 1/_`^z!&k:z&9$tb:0Wο.@S.Lw2.@
QP=fY
8Xt+fYI +.7A tB#t
2tPS#[;Xu$u9uѶ,
uPSߋEt"tSQOY[r[_/T9(=QRvu6ك`.tSD[r&  ~15a((f`P t	; PI > P1%BfS :'%PQS%<vYX%"t2%P `h%
 #AvXK%	d#X6#G.&U
b(a`MQNQO 5"4Y 9Ǌò
&(" ߀t#t^]![t
/81g!86&Y!1#!t4oVо ppi`DΑQXw

SX$w
؊ˣw#3Ҩt \W
( '''o((((()
&4!uQ |,Yrs u?= tio# uRu"au@%#Pב#Vt~VtXp#xk"$u Q.O2 ;Y   Pz"fP%< t! f ff3g&fG!P0!Pf.xf-  Ё K$k$ X5o$X1 -$C|͒$f^ f!7w$QB tm$Ye$pZ"8P$2 Eja:0P# r	 PPw@u 0 RS[Ȋ耻S=á$*Àu
SD$[fPhh Xfj s:`!P\0  u
ttP!D[
g#XA 7fW#87ep= )rfV.4.tf^@
f^&?E$JSQlX
s_u0TkI $ 4Y[Sp@f+Qff[k t2vfPWݐa&D˖"fPYՠ΂v"D u'~ df%2e8ubu@ՁRt*r_*srWosR2Cd
"Z(fXwѻf^a(x)k$$PDu@u7t3av+wt5*r!2pI( ;fYv]tZ@n++
{+f$ r
0Q2Srs[Y`turL rQYRPPa<v'/rs	 (a(W_rZ.\㿏 ..M m`}"SQ@"2NY8[r2QA÷sYf_XSWg__[`tFs{r?qPt+8t$PՊ+ Xw8uDA1h(Ѐ`ʰ8 \R
a< P-
ͺ po#T{PUuA2
2i*u".04f~dA[~tu$
Ѡe-PW`UYXAE[{ذ3 \P
>J_1U^ FVv
nB]PW s5&!G18uBJ0<ft~wZ @08j t0:jG{tav06j32۰>tt@P
<X,ˀ{UXM&2VS2.6j3_8r *[Y220F]WP>j1 >Àt&}&tBJ,(-)*.)`04jÿ1<v<t
1<v1ÜȫP@"3bN<w<?t0f>'/eu%
2&J&&L&ģ` 9	K LaÀ0 0000z0
00z00001uxf@Ou Zad b  @B? <w
2tн6
tH/8
 p3۱ u tF@rpt#u3WV ^_ 	6
? HS
7@"W _uGG
zs
d a 	 QI hGڃ. >(.[jRxXuπ0؁ uYz% @@%t	Ð5FFGuـ	Y÷XrÃQS&G&w&ߋ_OB JKu[ B&OP&
tuȋcPQV2 $̊FY^Y(&tJA# &&+	
$q`ug$Q$Qc$<0t&`'t2-2*u*"(~A' `AJX2; u= 3&w &߀?2SMw[

V A1Ѿ93O.8u3`uDt3b­}zyh`!  &$@F `D|M[9d``8JI~   1f   > L$ Xp>1yF@p6S4SK7
S`c@q@U? 9O {09F@0н u Ǻp] ! 9t<v<tP&Xp925s 09}p9CVWS ct#
F[_^÷sG(s軟-G
P/&W.  /PtXtgHH@-AGG/_/.> ` ߋëA#fP#IiZhu(R1*u
LlG!a:=!-  0SSv rffVГ2~Ê߹0=r8<w4t*uf2Q`+Sf[fSQWj~fP ؈X2A_YARVͥs.
Q=s0c.#*QE.LYt0
R"8}u^Z`lr1S[uQ Yrߊ̀wv}R Sf03MrcQpsO<tCQYr?I r:Pf;Xr-uYf.;v{uс	 0c rn_7fYf0!RVSӆIat|.<t.9uk.|t.9\u^.|a}8LuQ}a}ttD.DPjQ
.lYt(t/.>`gr' tPQr.DYXuP
~[0.t֧"`і
 
ifp|  0
 .0DP[S+C.].E
.eqÈ+à	/Z+`BUqʈ艵q $
a
@eV
.D^$0Pf
@f&ffȞ &e &}ﰕ]r` <tfur`+t' w7RZt	 $</t uHKdQPr 3pff+V@^3Pȃ 	b+^[P_^JmGâ
s34G7^HaK&C
tHKdf	f^ޓz R  IZvG婢0vPVPV1н	Z rL^1s<w >PkX?ffsfBѳf
4
f3f;w2뎰azhq .8P.<u- pQ2<v#<t<vнRt CtOqph:lpyٸfw
Q!X.`<
.&NȱzPQgPX`<f|0  wP7Y2Vr:
 xfXuwfa;t9a;
I$f^ VWuB 9d4@|&\Cr`wPO
Xu0	 Zro
 u^rc
f td  	


Jr;.t3׾=u
==2.@S6&[<|rw<~w<`qRZPư M r<#w3n
uFS[2ۀwvEShRffZnfU
@?[ܑD 
s@f^|qŲ1Vf$f6	ňqf0087HsSuNUX^z5p 2ɸ,"ypg!F&Asau\Ue÷ zMي3
x@!2 o@ڮXtr=jrpY=>uUӊetǋz% 2?VP3L^>:
wN  {WPPSȿ ^Z@[JHF Y.r6~VWR
PHԊr;~s8 p~JuZ_^N tpS0 [{_P
p8e>':!:e@Vzz  :2RQ;USz & X6 "2&J tuTA2RZΰa2拄PGð` 
؆pJa 1Pcr͢?	5
`KaPfQuBr
~ rf # P@芀D?66yD3VA 4ff.Vff~u
$'tGf%b14?`55E%Z	Et
^]#C	ѭrfwrif
U@'u]1 TÒ@s
ic&
 `7u,.>X t!fa;03 B 
$GtfXf^0nWUPiRN?W%M/6?%52u0q5yB΀@  Bf>?	ʩP	3PQ3&߉LL uGG  @ tO3YX.	XfŲr,,<#:5	ZXf]f^`h`d ^؁8tJu2À_uPN<XQVW_^YS. 	sK;[VS3
t
<a|<zw$Co^ᓑ   Bq&b~0 pґ@4@Zz.9Vs3aڴP2ݳn!t.:u.T1GV .qA=^f.<Inteu   	  
 	 nRaPa CPOPBPOBO PB;rXaSRtp8Z[ÿP.}.8tS|Tuf v .E3u .Ert+  R ZP40A3 f;q1z	P ܰr3?O .x
s+o؀þ."PXfu	fSffh00#3pbf? 1 ssFpsFV @8`gsF0csRf6 0.dfi
00.D`zhPR.ff@QFC'VQbr[apZ 0` G .FFMȋF 
tJHa  Dp rFpqFq R ݰ= #.$<,ڹ<eX}(GtBy ^.ϥG<vV)f.xww1yGu
PD$.GX"}	BLQv=.+w vBRۀt
u
r=
A|f`.ȃ v(.жuc.<s.tF_Pf u.t-.3uat. P
q@f̀  򢍢 Ŀ2P v00df'eP(&0_
fpn$F&Rm!telbUr hBڼC@q !VBRR
RZR @ $ bPBBCZ°Q
Q QQ0iPl|fƊȯ$fl~PlfffXt{
tfZYQ Q 	Qg@耥S&
Ӧ t P?첺`ơ.w᱀ e'$ `` 迱 S 0S2_ eqNQ$q$u@   `tf   gft
ѲQRR3AStgZYpNշ3ɒ|yvspӹfQR3og?Z 𸟿E؁PaPS@""
o[XȺBCfQ"fQ́]͂ `!fSf9Pŀn&Ptu bۑ25ffĥf#ff#OfѠkf1M `RpPu fPÇfXӋ#ك#[uX  g-/Oo /Oo.д 1-l	 -`  1X (d @A _&064QC)t|XwrwKQdHYm %\ DV ;v7v蔿Z+a"+RfZf+m@΃AfRqQRVP|t
@ylt|<uT@LP Use the force lukeS@?D
D
  p |D
u:RЋU"} 3t
Q, Y+" O   Z;t?[ì؀  U`FFF.8\uE.T;u2	u	Ff$f"uPqfV.  ^0j!)
uCa
<uD` fV.4.9y^IFa]~>-Qu(q`
0 ƒ:f^@=wQ@_$WV@{WtfCr_.|tW&
uMu@.Et0.@yu .\*r.M
 @%a^_kY%RWUЎ s" D&;uEu&]1_Z-Pf lZ <5.u^ $< ˎÀvt Nt.b'N#@Ҝp$$Cȋ;u/ b t"~$ (tN uĿtO"FYb]`Q tGZrw?&R2'u;Zr+;r'&
  [p
uBaq,. rB.E#U~QSR />sGBZ[Y.6пM.8t
 .;6Mrs>SRVWr;u+6f
f^&M;<0_^Z|qN 9r;ef<T==3c7| t;E8u2
4@&rD019(u#0WPݠ 
XY[sCP@@ `I!JI IQT .8uftހ$ADDfdIN30`M  
! "  O	C 
C pN pO 
	Q 
Q 	R  RPV3!.d.D T.;tpL.LP@fQ0f0*<t<0u"9r>&E  `a=0VMr`|6ZUor0*v 6Vv3@If`Ȏ؎F@3@ t .v+urg\ uZ`p   W GGd E
VcEe\E@f[E	^_.f^Pg tc2)
s7V! ۤ^ t@<M _^^Ps
L+ "-K.Mq
M)
bfaK`a
BAgf^$rܰ00}-SQWDfAIM3PMS߿0WwGwPu-owGPu[t+΋L(*nt!gw	@t.u_?p;_ uXPt	r}xR&P&X ZuAp
tPtKLums?@@$

^u߃t${2_#,  ~Z\QSWV6 W&=	r!s_߃~rS_[/PQq^7_mYX]f``F(8^M2Ƀta]FoF.
.D?;t|;F$Ft.
~9r.|^TN%<ʁ _0fPWo@9Q1AB_ t{P/f^X ;FCC=R@;˗u뙴CP@VVr3!u
xu
< u	of3ඛ[0t#M@f|@pXQWRYZS"[Z rQaYs
t sRfPYR.DZtr$uæ t@@u
 @swr2`uP"X@ 쀞/X0ħf`s%*uHfP `3ٜ1$0پ0yquuK= w4 w.HKPO󲵅Z;vdSp]f3ۃ~ u%P6.&Y
Xsۀ   3 Pu]QYrPSQ0n t	"@[
0sY[XfRVVf.Tf{fPC b35 u3oRfQqŚҽ ;fpVL  ;ް^fYZC2`I]NUK33`IqQf 9fFDFɀtfVrAϰ*ῐUA A aV`6fZ {_t+}Q,YrqSa.|PXt	Ztπto fТ% v¦ %Z|`
%u"ufZ[Cf^ΐQTY #[2   QtN Y n^^t^^twǾH^8 r÷ @  wf~ nPJupS`v[QR s9a0U.:u Q uA>85QYpP^kt tQR3ɀ sMZYw t1$P NêNuu<
uf_@t ZYsK`1QwCa#gvPQ@P+(  APfW`0t%,tfR tpfZQSNu&BtGNumYf_b P^A>5M[lyJ	W.>M!.:]u0 SF[y  	
PSfVˀrf@uJa .sf^=PPPPPPPP P!P$P%PSwf3ara0Y1Q2੷Y͠  PQRR/ t&P% ֊u2ZpS![ZYొtB @2'2ۨA2/ಱ ϊb0N5p 같~09
퀮{$v  ߐDS2 ' =S 2q't >S'i =`,utta`SR b'7 t#JunkPt
PӰ1fS`i% =]UfWF  5u
 50F 5
  5fX- S4^4865b7^
f[fX]fWf`s~ u^	ߊv9qŦpG.t< tPS\@=pk<@/P<<UGfWS[ FԀU$<u'f~tfA?@tB5rRW<uHt%Q3ɁB
AQCA~
R1B5Asf6<<_@Xf[
ffZ2rd
e*eAeJe^edeuSþdNðFo53p7۴ @.?B:|aO"##QR[ ZO0#Q  O2^pO  ee@f^fdfffMe2<v!S	[t{!f@!0:À{t,ҽ
 ?豽PA\,2sp2Pu xТs  þo. c ȉNaSOX/fSf  cXf ހOf  f t7fU<Ahh)`Ahff f4Ahof%k; 	F  dːQ-00
@  g:gggqX g`@ Wf_fVBE/fFP gPppWr0f« f ff+ uf
fpu\	l \f#$5l8u2uA]tb Nhoh rpMcSES
܃_Zu?
 uV\cgNpX!t u3ۊP uua r1Q$gYczS HNu}1OF b1R )` ZRVuO	r?^Z`V!3S[ t-R!o 0JuZvZoR`Xa``}tpa YLiTiiFT
s<_}s\ w S.i[`y{O.Ptr5P r.f0[؄HV
lrS
.\
XfuQdv ǈ^O_$ؑ$`08t\ t\t	twAf "`m㡯< #tas @CaaKPMID;t     9Intel(r)852WGM/bE5PE Graphics Chip Accelerated VGA BIOS  Corpo@ion#?_pontrol  Hardware Vers 0.0 `abcdefghijklmnopq|}~<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq|||}}}~~~  5  0  2   
llannnnnnosp	p i
gegk.<t.:u tOFûE2&+]=ppu`rWpESAPq H@jfj 
kfPfXfQv4kt/3s@wktk st$k*kfYf t_uVH f&E- ߃qÐEt6t@Ύ޾jP  @jP\uRSK$Hp  uڵ%wt@ @tv ts߫#a1˫Puտ͊@wfƫՁ`rf߸
`rt  uf
  f2GtkQRfpua3ZY%͊"uq<?]ܿf
Gvγr;蕯$:Iu.{` @%%Zab]^zd>\uQSr[Y \ͰLr`tVÀ>IvmwdtYw@t$`;wR$;v f$1#~ֺ p7`t@pwoooop&pHpr @0` `o.$fPt*RaZPXfv pߓ ~25F wf f t21¿fI@ yBPgtPg1!" D6*_tEs>e^Ptw1w@QQaِfQtrwta)vGwAºBff 
C
0BBhRVIfˋW uo"@lv`8 t3
 AUP@<ʀs Z e2,uPsX2As00fQfr\Pf1ċsfYRIR/:TtPuZP؊̃XVD u.fD
f=!w"f3f0# fqR fZcv^￨k`.E.eA##A#*$##	^ $Ȱ#
C&+$`&Ek .4j(Ϳ"(Ȋ	:׀8uf$?
g32IRרu	Ht
.
  \@$
CB.!רQV.|^arԥf^÷P@5 2Ot"ѽ+".DQCp6`YV^{r
+
2^û< <#t2 <"t
+ <!t  `u7
ۀȊȀpfPJ};@s @ՋиO O OY}pu3fB * u pdvˉ`uu t kBudu^<uY8s
tQG8s8s8t3ސFt-v&8swˊ
r*ˋc
ߊA㉗P8bu J NذJPKÆ2ۅ@LBP~1BtB0O0~P2$b&LN<v`Y	xorJUN狕PqPF ^at{rtw%qvk&JpR֋&ȋsBuՃUt'W WwPYPZuZ$0<0 t**F Ɗ
t*H2Po ؊šXAM>M0ULP~tSr<wBtte$XZ;Ju؊˰ f'
tQVǐh^YuhQW_Y`ju(pSeef+fZbdb2?@b1c2@oPP *ڀ n`d  toʋXZQ2Qg`i/V++s+Dj؋Xst+tvrkmd݁ǽr\tG?r:ssNOFGt|xu;vsOGGwTxڲmw X2cR@FKX@!+0``ȋPcXd"qqudQr e"g4h0Ԏ`g`ͽP h2{PK31mLR=ЍػP
`ȮAjJuk^}A3JuQŏOXi@Y_wPGAd eSrg&	ōhFm(OaZkӓ䢞Pm KY?tv
t-r ^q]sw r
&"PtЭàQX0YP20ct{yQg tO FƮS ƯPЎ،Ȏ1 0u.r&>| t
~]`OZȡXQEcC&0PD+{2tpY!6t
@F?uXCP_X!2&<uN뿷߸Ъ12ۭykËUƋt
 Ju]+
]Q +NL㋟;PL OߋYC]tЧv1u　?600Q_KHsfuzηCȤBPq&,G$CËA(r
y$6| 62䠼@u>
xĪk?í&0  &0%UÊPY)"wj>ٯMuX#`OLXu%K02Āu9VWѤ ts
ʃ_^GMu۸ Q3@ø&Dҋ餍n@YWR $FԊrǪ8JuZ_+PMu3s
{Ë &1  >ctG3PBÀ9[t3>f߷10 2
T Gf@@
pF$
 tu 0@ PW.>ju>&}.ҪǪ_Xwptp㾀r#ts-" &"%
Ī 
r0sي
u7豄P0
x !NLuP w(VwKؽAФsX ` f3aڱ <,P2ɸ,"y_N6@πʸ _(ݨ nr$$}İ<
tG<pP<u(  2 y yb2QU<
vR vZ: uP2:6vFR
tX8rSbƇP [Պ?׻t- ʊP3ɸ1PЃ
OuMMtNPSQRaPaDXaZY[X@Sv
LFЃF0݂ۂ	!Q^qx<s<txrttJ
A 2ۋ&<FA)w t3&ee<
E1(.~=( )@-Ê;&߭శ Ou'ËÐ 0
01ǀ  fnNËƊĊNuú52Fó π} 2  Q4 KNuf&Kl0nDSRP$?.&_RPŒ;;;[[Ӄ=  XʊZ[#PƊXPpX0]A~~~~l|8 8|C<<<C8PApD  0C <fBBf< Ù}x<fff<~

x rT88T  >>EZZE Hff f { "8DD8-p2B~~J~J N !N1K ~E 0``0QAPA$BB$PADAPCVAEPN l$P  llSl ||Qf6j 8L8xοz 0 #R0```0 0VU`T<<fQO00OQOUWA0 U || 8x N~ |pZ<| <l [|o[ƐY"W|0]1]]~[@Yv^ Y0ABr`!`Vx̐Y@Y|߂R^ ff|ff\[b H bhxhbcd`]~ bbR N< G flxlf Vbf }bb]bc|`CeW|b\|[~ZN<eiil|CjƂ  mO88laKR<`]׌2@hxV``wx !` ZxC@nWA0 Qx|v `` c^\[ؠrrqs[60x00xPAv|x`lv1k 8f sugvv PA܂Kqs1]x|@e  t|@\ v1jpsk| W4AOGBtm|֗l|lqG|X0d VaN{00] vTApB[cp̄|]t|8r̅rr0urq{@|QtQitfvpfvrb88`x`AP|~~ ~?ayhSiӆ2^||r~^i||pvl``V@H~ Rph1]fyfi 8<4`8ll8 ^0`y RAP`F=a\Rf>E6ll6PA l  "U=swfRt162QAB1Ş`QAPAPrTA3 uqš1NqEd770?RA?%0"ĥ񦱧66 51qĞ1RARĞ155(tqpt  tv`a@bo`z~llHp`ddPBL|PB 8||DbR^l( <s" tQufAW|||Atdi`Q`N~@N~ a`wpRPMau8RaEPA gl<pSPA'0Q{PA<_AAB#B C"ClC4 QQEZZBxPTBE&RqqFįFG¯2xGH⣾qH
xLIbQ`|ll|-QJ`J@pd֐QrKKAW K!L|`l8 CrCQ3 Q&0OQOQ0PP48|#QcՇ||8QQRff""qSSp!Q`llҒQ`Sv3t`Nݒ]0` aWE̸XuU`ݵWtY|Z 4dZZ#ԂY@[[ ^[zQQ\qc ]]#^ ^CYpBr`p"a6B@ CqX H c@c0cc5fd@h 73{0isÁi7sf 3xpggg2 o1hthdh#q@si jjl1k2`~~NƀDsl3} m l|8P#qqKqfCƆYbD<200Co0Qxp9qѠr r3ssUdt %u3uuu·r v$@NwC0s@rgw
x &qy6焎""j~{$qsp W3||
c}}0  nqi~~r$ ap N TDN--kLs0xd2'`0HH020WBi a6K'9'a6&A!D!n>3fpxxc>jE<h#Eix:4(a6(h3,xCyG ᠏`1s0!#qp 3'3'33 ("QP#<0<0%ÖSհdx0`ܶ=>uWlܬ>1瘳D[usw]y ՛Ğ5ոa` VDD [סhۢW. jZlmĞ$p$ ÞuppE fBuu4 ŢzddqŤoqzd 4tn+lhmu`WGs
̃@r7&trP0`´W(Ђ4 11 n ||@<` `D5V# deM d 脽Jq[#/0`h|rd EĭČ]?9Ԃ Fcxʈ%U42, GؤӇ _LW8 ٬|M/ޣ.dߍt8b0B0u W	J 9d1V "VF#0Y 4E {=
W (r $D  d!%f5
 bvR5W %U	w
# !u#D)	0W!`1 $}f/ GR8
 FR! = !!!t" CU"$N%G& ''sJ4** a1M,-$.. 7mu//N04112 2$5Ov475$5f6$50U7b2B wCvdDw;< f=8>" ?" ?hh@rUAA BB*CfD$I&F HG۷HII JJKFLL'MM #IOۦPQ XR# <STUwhVWޠWlWLXcY Y]Z9[[\]^_ y`aabcdef =ghijjkl]m ?n;oopqrst =uvvwxyz_{ [|}~~ـ}]= t UƇӈ$4֋S fݍƎD&|| zX씽 |NF ȯ ФEBP<ð؜a p@k`|3OtǪ ֪!"%#4$C0^v?12Ë5þ1&)ð{	{  æ{ @   .rÜ&6| &>~ 
*K@r
t	2. Ϲ 4 4 1111a߀w<
u&| ς2.R^FFF3ҹ `Pܠʠ Ġ X  * : aQYS s2t  [øqk _Y
>ctIc  ^^4Ĉ>I`@"uu
^ƀt 36ȢJ2 Lc&P̀>Iu	B$P
	JX̀v`
p0ʁ uHÍ8LaztA@@rw
2F.Ê.̀N$FP$FF. 4 ÿϭ(#<w$u$
u Àpǀ&&߀ڈ+	*<w9ΰ`Q% tS[QR2`& 쮞1<w`٧{@tbu5BcȫFtW!yC`
 艝#`pð8 u{ 3Ҵugtb(u]̊.ŴQYR  
 8 t$8u
(
28u2Zb aR23Z%t<vÊ>bSu
㋗PRФNVQ~ċюF&<
vu^Ft&FVRU t]Z:Jr92:6v/RSbƇP [
mZVm^ރ^Yu{ZQ[<t<t<
t<
tx (` t
t$0<0tu	߆͉NPu6,~s%&2FtBu*ш
Q}s&:s2& `hk  qp? ty2P] IͪgīI<vN.!.ItI<tE2<t?<r<v7<	r
<v/<v) @Ǉu0ۀt	t2ۊêSP@X[$Ŀt0! !ъ$ڠ
4
?Ī3P@$2.>juZ&G&Gt& '
A'& 'A'&_t%&
 'A'&;GA' & 'A'
 2à   _ 0-0-0-0-fPQVಹ fVf.D!/4f^^YfX< !!b. /4f3/FFr0fPfSL1f#fff f 0f%5;u2p0[0PSQRQଊ+YZY[ 8Q8_@Y"3 /j0/f`3~:f. ;.7/CCRRt:Q<̀YA=Z t
3ݔ	t&<t&wG Bx  ABC BCB
f ,ؕq轖Q3&&Ϭ&If It!J|!JfY08rVFF3 ^tJUP9QF	 DY`3RfW.PNP3f   VW _^qLP  qL~Q,NrQP@R fX f3Q  NQP1U BQCU6UV0V*p VUOv'RX @qS Y qS#Zf$ Z0Vĸ ̸>T:TQ!Sy2A\TeT^f{[XPNf_Z7 p}QVV-^⽿BQ\*&5"&&&^G&T@RVP\&$F@&F|A  P`iX@F2emN h0k^ZRD  ZPN$uY8VĊNu^>T9ڒ!C:R"f16Z=QfV<f^Yb>>@@A ԏA?dB7$C\ 脏CcD0E
åQ	 HSIIJaJJKPKRVKB3۾L^Z#N쪓NYØ    8 4 0 < !! !!!!0!!!!  !!!# $($0$8$@$$$$ $ ```@`D``H`L``a bb @``            !!!!!!!!     #qrOV5PP<tQ4Ip4R(R:S6T4U/fU쀒VtWX#XYĀZIZ[\q]诊f]k^mF_aA`Vc`paSQ  2Št$珀Ȑ$}  P\$  pj Ǐ?ĪAdSc?褏P cBd萏P@苰 @胰P\d"iXN 
1Cy +E	P=X^ödr.亽@2  SPsuf(Zڑr1ߏ t[f`Ȏ؎U
 T.>vpp f; lf3ArO|$t(uVtD rnF! ȋD4Vw rlr&u .S6vѷu?fR&VwQ rLTf .v+u/QW&D
&M"&}  rD(;v_Yfa  
 ftVp^tu_YQVWLDFot!gw
= uRtrfa_^@ /Qf&EA@MAy A̒$fPf@u(f40 r} t tA˸l A܆w<Wf;EEϖl r&kf&HIBuMAfHAyC4fӽC ru&} sPQS蘏[ Ōp%<`Mp:,_?`VB ^ ƣ&Eǣ\@¿E;P++\og;6s;>rڿta ʾ
Ǿօñu66xPt'`Fak t	@2_Px N ð  t%u7zҾYf܍YӍ S>[6[ $ADDIN30̿!BY%Jx}AIM34bSA  @ X@@ U  Intel Corp. LVDS 04Tp`QfЌfPZ...WS..ff[fX 2`;ZY߀2 /p-4uP.;w.;v
 ЌWvTtOYf.G u"02`>ufE!R00poZ)R0qZr
ᙻv_ b< PovEsfr#*0@3 AKf=QufXU
"SQW !U0<t_NӑwfV<{1@2S &@t 3 WR &tU
Z_WP+蝃.$.%GX..]_PW*~Jo_!3SRP$<u8."  P0}XfTA߽
f`A Z7`.5@ typ MO Q@[Ou_.3.cW6v..\= vf.L<&]fff.	\w.3"@ %@.&[
U/
u.3.3. .G$0<0u. a}fVf.t25.:f@uP02d H`Zf^Ɛ~:lЌ
	d2ͫ11fZܰ!2;Total time for VGA POST:   Seconds 0.000 
7 initializationЀ10 Milli~9 
 !豆.|Ã.~ø@>.ÿ诂.p!Nw o4B 6Btx%pr 1P*O
~X X$-P_% t\k
.8tFF+L^X	
>
a`fQ}ԓ5P*Q
_u2 t
^2"ot2`rp	r>Ău
 u4P*Z
~u N+UfV$m#a YaUtNsLF.>lu82 6Tpt$.Up0V[ha##Tp~f.f.+f%b t̀~~~!.M&@I FQWf] `	fb._Y!f`
NX}Nt
"d af  zcuf[!bfg]eaN=TaRpۋpXtT`!  f.xf[QfX~`
f+ffYf
Xo3@څfX% foIQёdf轅ffǠl YQ~01+fӁs1rrwrP.MvXú#c&π ǿ`	P^ 2@BtĊRvZ$`
s$.P
tA	tA.P
t*. 	23@$  . úU:UuP&w^#Uw.r e* ˿@   `Y 1 | 1P߫X@v<t<3@$ t u# af^.&$_<u!QWt	
 uuE_Ys	6?2` ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  0  3!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du 7fs30f\0fyffÀ32 ;Tuff_f^fYf[  (   / b AO
 IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,EVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<2+vAt|3o;n6}70+=iG,N@g!CVO(:5o ]]`c:=cވ{>Oyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :D/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH])X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=BMﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~de&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEP  "=Ptm4gf~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTD7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo菈͊	ҋ	ўP!}όg
eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏ /Ooя /Ooڏ /Oo /Oo /Oo /Oo  /Oot	
PGg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwykK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]h9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=?;kIJ KLN/OOPoQRS TUW/XOYoZ[\ ]^`/aObocde fgi/jOkolmn opr/sOtouvw xy{/|O}o~ ρ/Oo͊Eҋ	PBo">ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[M^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*G3
U^`juB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg.&Eۆys/Gȵ}C 7n5?:XR
	=Mg+Eح@̱C`sJjUɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
}@ P/&l o
2e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnC3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo Ɋc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &%&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hQBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzuk  2oj  A ~$@b@@"Ԅ&Ԅ* @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7h9v t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	  ` hS'v ῟ hɣȆg
Ȏ؎`ЍRߋh i
  W R00 o  kf  R8     DSDTUb  HP nx5000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12A

 A y 

  	

A1	2
i
\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 714ph`p
 gpid#d
 {`
ap2a bsbgcpcgz`
`vdgD15phg	gi
 A6gA7phpi1p
 fp
`'fg`f bc7f cufbc```~A8A9E
Microsoft Windows ME: Millennium Edition s NT C~@AF
p\_OS_`p1g`a.ag%q`r9 
bra
~ua%
 6%
} +%[1&I`,
%$2^ p
pA8_INI 1AH@B
fpig
f
 SpiP02gp2hPrgfata
apa`'ahha ߈`a u3
 bbiibd5ub`z\[K
@C_HIDAJ	_CRSD)
&	p 
 :@ @ 1;:A:
 C0k10<P=1tS12>W=P=3<P=4pyV>5
]+14t>4?D> .16P"C7C8CP=9 r1DiAEAdE  E[P=B   
,[GP=C 0P=D[ A=8 GEAA [
5JoFG20A9@[J8"L21@=22.23)AM4 L5֠)26!O7H00!O8!O9!OA$2BA=5@2CQDQEQF@30 C@=31@3V133S4S5S_6 @"R7S8S9SA  @n83B E3CbEC GEG3D+3C
[$XESF@40ZS4143M.44
0!`
p2Ba}aoiapa] 	]ib{ab][Z58
_ADR
 [Z6bGG47
ZqY$4]7+480P14/48E8Z9?& @fhAK4A [#~ZBK%4C*`p`qjp`b.48ee` ap G dpyTAcCߒdcqj
{a
;bp2d4DqjP.bbtd
oEpubk062dcrdq49` dza
a0Qp *rfuf1lf a)dou`['i
0aiZFL
_
 
B GwA  G&y
Axlry;9 ){ x({ Bx?y '&fDKZE䀣j[)4B B@51pibpkdrd
ed!lwd hb ub rb

bWhbЂ2`3`4#DjV+52#E3 B53crc)5}4"bNЂu5iwBnar&/4Fab 4bb4"64w$Q5Єbu~6atb
bc`6abkт`bac`х6p
 m56uCAܢ9<4F
052C54CPk53]12]Baas)_S3D
4D
[Ђ7b pW

[HNЂ8brc59
`?
[I	ћ!jv5CDI5AZ5Z6Z61U2 @} 63 H$64    .65AS66@a7 68 )69A H6Bk E6Q6D!E!F)70K71

L$71+723 
<[=ޱ  @4>75 aO77R8 } N79 A@7BC`
[+tbD@7E;a7FG)80o  $81K8282V3ү411P185V0C86V.87288qY!b9U8v888DGqE[#\_GL_*bp
`{s`Pb!
dv`J`8B8C{hsp2jp
p
H񵂸;w|62a|Q.8Db!t[0Bya
c}cbaa6F
/@ hdvdwd
`y
`ayik62c{ca A`@90 (8P 
!1}x 92"hi;0`y`jB.936``wh
+c94Pk66PayjabyPc67c d{}dЅ67M$95Eik3r5
bMbC{bswc
eufey res 
 dd)idnh
 y
ceрe+65cAaϠh\`z> buc/@࿘02u`ij}q`=Jq6
*705*6F&3Dԑ!
 i
 A97\2ip2k6BrGQ1ߡBGE08CD'%[pj
[IF09 @
9Zќ9ѫ9BC2S9!E qF CKA0
܁`AB`Cߠ
z0	;z{`J a0 
bw
t
	ra0/ Cz`U1@C2(P{@
!ry"@A1
pI6'wBP1A2
յrRipH9D`Fa{`s ` 
p{z wiA ;!){a` `bqA1ob AC3	_B`p!Dw
h РNn }QQ`c Q1
ccF~EA4
l
H3A5.A6Pe _{ky
P}A5  }`4emj
Q6{`Q
xQ7pp #6b}e
e/D t !6	^e@6e}`P4@dAy4{k
h`}aC
 Ѕ9C; y0̿Cp?d`0*Ad Pk9ABSBe@?A8 pfbcdyce@
!t.AAhif"f
j
rQ9p
EbRdB	! J '3!P.
D έp"M" 6*3!!C$H  I3!$Bb+(d' p3! !Ab	C@bDP}yacZD@cE ,Ub,`,EF dbrbAB*bAZA8crcAD

W[@AYAQAF-_PSWq\\AE4F Q1513F[?(C0B0bB1:72b0B313?4_567
84bZ:L_;<P=>?@CBPacQ:A eGIP9qLb
SL#qL;bL9bH\BA	9B	
#  y !RB lh``ـ `BDu!R@BE	Sp	aא`	`lBFV`yX vC0	PY1AZ	|AZ٤`[OC8a_UID
`_STA UE^^.њ!_DISQBFh^i^_SRS1C0hi^@Uy`\9\a]^B_fyfOafbA\@B\be^C /gnn_inj\$J\cm^D?ov voqvr\pN\	hu^EOw~y@zQ\ \i}^F_\\j^60o"Ɏ#H\Q\k!1@2ٖ3/B7YoAu^79 &22
[1ZBCC
rDz<YE [#1"Z0&67u[YBJbFơvX	6ӤB,C046D0MPD1
,;pD1PD2 3
Lu34 __S3D
4 mD52+(0!_D6
 h!!!33`02*X7#B4pYK8
`35 {i1`=h {`h`+`35i12$S q\._SB_9t
A._DOS1
 ao[^Ab/ha[DC0P
_DCcD5
aG aSS0Zhsc1 jRReD2⿆⿪eEjJehqFB D6	5@p
0{\/S4֑86
DFѼFD  жaa KqAh[ip.7A hO  t a\\/W3CA}QE QF,FGpJ58 E0
96hj
7hi0`~8Fl`CpE1#5pFhVB810CFDp#G7SDX 5E2
^/ E}0klG63 o86`q #a&5 [E4 0ľ$aaC0A_B[O	 6c+287P` 
p5_ON_ 87q3_OFF }_PR00ZE60Z58[H ׄ	_GPE
	3
 ]P
Gb b@Gof f@y E8E9ҠEA@ BC

@ED`EE F`
/_REG(pi1pP0A
a	iUEB:F0@[L @@F1  0ZF2 #3 45 6 7 8U9 A1 B FC" DF1FF C100^1 23 456789^A Bs]CsD@E C110
1U
21314151`1171819111B1Cp11D_INI T11EC
>NC1
F0w20q1
q2#3
q4
uq5Ѡ126s]78

q912AB
Unknown 
NiMH 
LiIon NCС0>-{ 3Ф!ѡE800`ѤE8д@
d1XDED
731TeAC c
@K A+}ha{a
V%#}i!3 
QS!*2q*2&Y12D	ZZE -Ѣ'6"E	-7p
{`QI1)F
[)h`p4`
csc
  dziWr`a[)}a2bsdba3U/3Tz4X56ccCC130	 UhgS0+Eg
#ʕ!11 {`gPPW919CAApFC!0
01>Y@=02w@ w 8axra
c 
dcbpbw@Ѣba"C9C@BE`?FaD A2`a*DM.11gA/1&@[I94
9:+;p
  'N4>;	ip
Q!2<>9Z[?3G4c?5cI4A6T C pھA
{ `z@[{``P6Jpq:7dd@1U  9X2c cpT e_e\eQ\xcpe'cpc\)J2J,@6 p}
28p
a !S113Ю(_Q0!3YTQPPʐe4eR!b
dp
aߡp
AC
b"a:e5\0TZ_ L7]l8['llTZ3_gK!h6|` 
;R0oa139
oPR_CPU0rRo1_
o2s2l7lmnsN!h8Sp0#@7#g
]
qA
zBp#e9Sp:|geA gqCdBDdE _Q10 8-(`z3ax1xYy(}_A#}1}z|{F
{ .BiAi[4
3PNp>a40[pα p 52 431l 546q7 L
849A1]414DEF50p 5q5354@
[P `'15a56ђ5 561515aL5BJ5Pp
UVaC aaв15DBrR.`)ҡ0`ҡpҡ1B a^Q
 y@7a`JE5F1/s1EPc b1Fb1DcGNR1Eb?Cc3!51bqaa0a53c0>5F[ya
A
 d
b
 0:bdpdAQc
 c
0:c&C/5FO
C160B3`kaa
a
vj albbжb
vbkb.P6zp 4FpbgD 49}ERC9P6і51#!!Bzj
j12b0Q53=p1ѓ6" b b/	a/bbbG62@05Bס12j4J5 P`A63`p*412v t56p4
{C0P`{24 ia``aDh
!KA5	Ѡ`aE2Xa 9c7.abcq.K0)66 p^}^7cIuqo68L
069

Gy 9נ16BAĆ?5EP\@/6&6BQjBQԠ`9[E6D _DDN
COM16E6F6w
30%" a8y 0S 6F@06EvϡQ4
 !+_DIS ;23#.6E=
KF_SRS 2h
@0707`ag1/70R0"/6E@
0D

 xqS3xy큡c/HQ'[0@1   
r_ON_`#

_OFF``r0 71[H:@2 [4@3_ADR_FDI"
O
_

%


e


 ބ) 
GG?"@ * y4r 
`zscbr 75 .Qq77Q7j77Q7CDB	=`7E A 7FJ,1A1uq80:	@,780+
G_w#0c84#AQ+"I	r0/@"/84DFxB~r" 0)0#c#r%$+[4 	@0+41\RMV73a cU/0E3gcg`g	MpE!85O
:32b#6p^3q`y8685[L$z7M޽C
_G 0" *
9Co;b9mF4
<x
K/O	Fг@^,0K՝0FA]9 A: *;@#/$
	o%U#Q'()88	@(,,88[C89P䰏MAp`2] 2B
8#Ac^Q1a^'C6B6Q8CH
1 Gxx<xx":bx2;xxc@<Fec@<c "g dhehc oh1e lLjlo8PGTP%c6C6CENB/CP?r,_.ysQCG]lg *KD~'8DLM4MDqQr4Q/RaS 1x12Dqp1Lv& -UVpMF,E.& Gsܱ[F)90 p\/ Ӡ0C58Q(g>`{Fsi /PNV80[#\_GL_{16
a;['$hGP91b}ab
}[%lRSC  " C ypq,@ @ "m`~[7Fĥ 
9G "   *""@ĥ׿a a -갖5ĥ
Gp p Gr rЮ" ڶ6` }`Gd d]"J[I 9p7a
" yQ98
99E98 1ӵ3199&O.k!   0_[+Ap   Үs QqF	729B  "9C
@[QaD  INI4D#EFa,`A0p!1 C0AC_S3D
аS4!B@@jC9[B0x03 +E_GTM 1p2p`0Y4ЀDA506p@ǰA+{UA5
PAWA5 F5MhhdhѠFi 10/
w07a:`@!` bwb
bwc@ib ac qrbUrcqu`AabA8"cAo8bca͠:߹9/!{PJEsD9I
C[07]F A͆QK0Ń0C ?RO,A#֠I
=E3
`M
?_ڟ۽ܠ)_qCXOQB-3D.
G_PS /3# o +@A1`i!^.C0C2q	
# i q3C4C5OC6C76	C8C9L0D +\_PICu h`\/VM pT MqE
sZ
sGC5F
 Q\AA
Y +Bp5\
?sF!"`#h`#A
sds ;!
"(a#Y A$Y!%&Y&	b33@	F
@//d
d
Primary 
102 
LIon 
Hewlett-Pack?ard E/0?Travel13.2~@8r.19L30	E7!<h`/`p?%
 O4t}
@
 
g33hr A<U4a<\1Aa\AD<=4ha`3A2hAp3
_UID S/E@F2B
_BI!< KSTRK [CL\1[GP3C(H6R)Fs(EtJ	KTJLLIM9B_
ACPIp63LFRPcJC`3O0-`; prZ`B631`3DƢ[:.p
_*_LIDsOB86@
	/15?@SXr̀N^QD8jbFcfpB0c@vB1c`d2@kk`!h`piaF?B`z a?{`
 go }ahgiap`ۈkpak àg yk ˠg1Эm 7 AFck MB3

[ f@[mBqq `rBqq`rrp}
yj 0re >11@h)h`PB3`xibbasabcpcau`a9`d4rwr i`zC03F
`#aq|43|b`a
}b

AB5d?!`d6sH0WDGD
PRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC CWQAAg*u1UCES
 %{|AQl&q߇ rBy5 zs
K? B
FfghiGWSAB풰
FbB57ipi%1F@ 3`恐O C
COMPAQ|PC C֠3 S1tReader|GEMPLUS|GPR400|PSCR|B %W	QtBQRNWSBC$!Pig7`7a;31na$`|2Z034a046
a}[Q8 Jq[#!l[#\_GL_wy037 vpj|8pk|lq|B\AhB`	l['¢['!\@B9?

[``dA!BC C1C6CphQCq9˩B/zAǩ{h
DBAp{zh
i C	8L7 PGDCG倀FAD0D1+q2D3R>D4 5 5rD PR1D6DD5
[PD7@(AnD89 sҧD1DABO oDAUyA
	`rh`k`vQRFMDCao[D7М cdJac
`rdn b}yvbaya
a0alr  eraye
	 evepeD0c ucdcMdD0_ { bpbgC	bdp@ apbe)ee ffg
fape`pfzfgvdueA`bD0` g0`r<b pg$8aggagubdM:E04B0!ZD3p@`cpb1TB2fy@5ш0CD0Cо"EhD0h H
bh`ձPc `rVEcP)adAB
ecCD30-adOft`fuad´uc2ftdg:ݔI`Ĕbp@FDF D4P30CADEaD4`{
_INIFB51pibhbC1E0p0E0t1ZdjDE1x2c522rbPW3 w
aru ZDbAb@`babuaa@wbua`R+_CRS0D`ܒaoE3``2Ot0R}`'`Мњ~!
	   yZQE4AE5=
:GG   @   r  ySE5[wDB1E7067F
bGP G$ $ GN N P P Gh h Gt tr   G@p`s #y n^^0
E4{6T0_!@@
3Bp4RB`
5BP H\_PTSphO2CWCC
 ˒ uJ nufbEB"?\_WAKDgrBEA00EA/C@C0F1060vTZE8c"TZ1_
#2l#zp@O0A
#r3NWXbO'
?'Da*Xcbcc,Fa
/cg&9#B9 AB
 ˟AC1B 2L25ز1-
720N\"9G,<

09n6

?9:;<b5Q?>Q?P=kAҳEB Tr C D
GE
@obFK"aD1CDlaD3WpD=4
F5BGaD6 37b38
A F7m
ƠCjF6 
o61F3K0i0KaD8
0 p3
MLp
(N>"KyKuQi`TN0PKHH0F9
"KhF6p
~`Hp/i`9@z~OPgQ9rZ3S=iIdOTfQ`^2SB0pFAJfa;hF5i0h qc9pDBi w` aJ6f8
pi?`b(pKD6E8370p8PBb
  IjmY37t
axa

`b R08E

bt9m/n
 po'

?r!o	s
!
J^QwSaLpDC	WF0"cd ,udJp{v3J{b
 t bbwb

araoMpLa12,LC)aPb3#h PAb4 b ԇ2Viy
ްbI	`38ob  QEpdh  a`%ތ  !P F2<bXe1l1"ׁzpDD`h#3_
b38sl M0FD
|ckh `t`o`x`fff
p{tf}f tocbbSp~b&|fPbbFi'

ep
d
N& d{ od/roe@i#ȓ#=AzB	"}qDaca[56`E	R@J
_OcN_YfFFY9F

q9e
w200

9\e
1

9e
~[32Bg" _PR0E["3(FwDЯ51[H^q#_AL2!91@AL2pAL35_WAC0A"C "12"2Ġ1"q3 B PSVĽESLPR_CPU0G60qD]i` qI("}lEBpAECp
n!Cp
C$EΰQ D_TSP
d`C1ATC2CRyTl TMP2 [GA$70B208b,2Ӳ
+30Ӕ LC\_GPEI9E2092kH_Lo{|pЛE{` ?,{`
@6(#,"o
Ga$/q
 3J142BI5`C4D/5N_L11|`}6`O^36.@Z͝{}1
A~146
@Z9_6u7J
o2Pc+IW @ca Ace"1`j@c ;0t"ia` a#8a$ʀ7 {64_?`}p@446C0D6X$8B.&KCP	P01/7MaDs64!4_p
fe9
g&CHa
 @+ve39 &e&p ["SSDT`%COMPAQCPQGysr   MSFT`A?BP<_
%(y '  (QC'(([+Q_PDC{h-PCT 
-q*0B	_PPC @/SS/N1P0S1A2O A34434o66 _8/9<o;O>=@? ABOCDEoHGJ K2O3oM/JMO /PQoROUTWVY /YOZo[\O^^aa cad          U|˅;   @ ` .UNDIL   ?OPCIR C      |P    $PnP   i\!ZAsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3Copyright (C) 2000-3 Corporation
19970 IntelAll "s reserved.
  , PXE-2.1 (build 082)E
MBA  
t2ôu3CUf`F  fa] j j
j
PS^< t	2PC[X] a$0<9vP EPb їFP"fPf!fsP #f~I#j:6$ݫ$SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlV ,Vv-,#-^ ,^~P.˗.]0Uf^]2 tw@Q2?Ĉ  t^@:^QS0 [Y 5.> th  Ph2T6 M6 F6?SQfRWV`55	hJ$Af.>I t.;@  >  U  r rD: h'@ ۹H l 8tY[i
EC1: Base-code ROM ID structure was n	found.T@0: ASF is? enabl canBl .   YJ0;?	8Sfj j '>  t;sf=$BC$uErPj W1II떌WێE::0J f&J=  .W6O!P!P!P~j Ph9&u
˃Z t9hlRgo>?C_L er() ==  ްrI?hC%M0F: ExitingWAEAT6
?^_fZY[ M, ~\. f"]0]Q]S^pf
 T&6 +&`fRSfP& f1+3ffJtuہ 3fX[fZА+Pb.\ T6&aԋ`@#SfWfUj j  I IRV T&a.~6E.i.i.i.i
"] ]0,ЉVe^l_l6Usmp]IoWopRf6U_fVq@rRR{ t t`tȠ:ɐ=P`4@2DBIOS extended memory c
 errorgC6: driver imageqDinvaliXC8: !AEAC@{y2Asegm
gC9:NV+|}: u P:O u5hw_d5@3@iCA){feI\M^f^f.O sDhP:JEw/x  AHrVMTMԊzrvf&D F&D@+ Bђ H PeJR&DKV@I&(Dv"	xijkWj &\R
Qs;b5uBpءL ` N b f3҃Whf[ fR@#XfZR&  oYju*U R$8vuj@aH F FRqvXtuPWfG HF +F )F[fSVWFa  6_ QgfTN Э  f _^f[^Rf]f_f[fX1,q8S`aYfr PcpcJt ucS``tfp  OffP= t.. oﾭށ.s	N]&}t	At+{f&} us@#.N9wf&+f&;EyskfXRCw@=  
 s@ȼr@#&_f.+qꠓuf@Aqf]33pfP: mPXätA+ȓ+C'8^G3pŋ. G30󫧄Q1v=`` _ՐAԊs}
b  P:0  u	b [DbAtECԊ\sCO  `ʾ_&<|t.;60 rb %Xr< u`ɉw_G&DP?  &L5l W&  e" G(e*10 8e2:.06 >a Xƪht޼ ^◃W,r*!rدG  *s.r`Tۭ &$јp`Ƀ?I Q\f[]#<fZö@#h
!,t
fX  W`gQhf3 Rf8f` f u0Hu 065/fpfuff#°H`дuo fðl;(fu31 6	Itff )@Ha41t'0g#d1,+	AegfZL f f  f͘` aD0 f9 ȀdqRf qw _|`4 tfZZY N RYq5u 2
  @tf<A
 	fSp OA f\
a`
_fY
Oa
 
@T8
`SȀd@R@+a}`f
úfffZ2P8fXQf A
I=f;tfIu=@Zr`5pu$T?3.G.P #.1.`Pa	P I@I.( SXf% 	QdI]1,qp  f?_SM_ts OvQj S1I/֐IA# A$ЀwrgrafGtWO Q踠l Yuf wXf,g8 tIt#gfXfg)f@lg@tgeNPnPuW32&C&:]u
uB~,}
 t7pQ RSj`&]
[uh/e%03tBSW ߀;$u> PuAMu	>P5Gu݃f2P\3p 11I0f>tf  fWf   t;h6Y4@07:  PCI#callBsupport E~	:uQ.;D>7?8Dtttnh>+%<1yn><Device!OqpY%<4Xx read!Y<configuration space`p3ffbj  wPRXu
pü |U.~ QP>`PafR. .M2<tR?h%SU%<yOpRH1requires DDIM>lp$ h b"% ?CS6Q'jcfjсdfhfQAPeu0?h
b6x
Ic{ PMM funcRHnumbe yZ u&h[E\=ocCHxg`Pf1frgfgfff_.=P>I cI.@0tt	 t5` `fd>phpgfg &u zSeh`bi STk%t p>=q(r$.   2_qrstu vx?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_  !#?$_%&'() *,?-_./012 35?6_789:; <>??_@ABCD EG?H_IJKLM NP?Q_RSTUV WY?Z_[\]^_ `b?c_defgh ik?l_mnopq rt?u_vwxyz {}?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$% &(?)_*+,-. /1?2_34567 8:?;_<=>?@ AC?D_EFGHI JL?M_NOPQR SU?V_WXYZ[ \^?__`abcd eg?h_ijklm np?q_rstuv wy?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ ! "$?%_&'()* +-?._/0123 46?7_89:;< =??@_ABCDE FH?I_JKLMN OQ?R_STUVWDXYZZZ%\(\&\&\;^T&_4^A2``3^UB2bb1^Y e-^
g`athbtcuj N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hiZeeee@eeX d  	e0 
~ eP e` 
epcB} 6ee ~Id7PƄi["#\$$x'))))Z*<*J*t))+0//$$Z/^1'|ZDIX+802.3  tttttWS ˌt&  .V!POXEXe erE}Ɓe?6+@:e^S0NV+,9
e@p@
efUfSfQfRfWfVfPFwO. ~
,2&22ێӼ46h@ WP追
0 fXf^f_fZfYf[f].?>  u
o` @ Ѣfv
Phm.6 j }ːfUfBg]g}wer`áf&.2؎РfUӢS@f]f!& tPu`1Ϥfڃ>*2 tj ÐSf. ff"2&2. -  2f3"Q. 3h f&P f&*2 []`ñj "9h uf. ?fh `P eV@ g&5 e+g&B^r t0g S̸[Se5P?PfX&Ʋ=PVu NVf.ߋ f ]ϝp p Z 2.   ~F~`~ uː u^&鿐Fѧ5FsB҇sӗ{sӓsss%ssQs'sӷ{ssߕ{C	q1	g-	])	S%	I_	{?	5
+o!π== w. *4>HR\fpzF1щ~@aσ>
9 ta h@62X9^&G99&G	
9@6o
9Bu43Ȁg>6_u3$8fj@!븈 d
"4uPZ8K6p230F6^G#FG%F 6FF~sE>6 u>^`*F)^V@` ){ tGKTRt 	`
9 (:`  0jKdr^A^V":1"+/BCAt"G0H`0r~Gtp uG t>G ޡ7
$! W
 )
$ I
F- VF^	#	
+t*u!
 	m 

	3	C& 9 P0 P 6F9GwaÐii"9pwذBPV&  VF  	F0}@6pFrpT^ `ڿ^V usF~'}p6 !ta  2#u?B!!#" o->uL!F ^`OfNF?^F  ^+t2)@*^v&)F& #~|--./qvg@j.*Ht
H|p
H~H@2` FF^)Q-ftv;Qp{45pWF7"4 #Fv:6f&p:&?@
44.:Ʋ7@
p8#<<ݻP<s0<1
AFGGU?&G(7?*G,2?fGAGfG." G#BA}^ো_#!_%2!(3 r)LC 	Dr	t2PF
cpcM"PpCaVcr)F v@.ވ"p`/GDH3t@IB2"E 1
<
?3_1QC_%*1"\83TUu"뀵-pG ~6*Gff`Df
hAp\!W@bjjWաD C4m0G퐟$ZP^$&G	r
rc!QGvcgrxcgajGGubjZGbjՁdx	bjdx
]Gr{cg
r}cgF 6 /fl`G3@WgtrF--3- @v<
  FFuf f1#}Ǡ  't
riϐ>pKt, 
 kD@Ƌ^F^VpK" .
pf1ܠpC
  -"ZgB  @^7v3
*&o@D @+{u++u$+u3	 KFFg4PQs?&tbs4-  @
LA~ԝ7>h > %'`$fF$aaM?\F}k
zPu2aPSV ppN9u2Gv_@x|?GrЩGÐz]wO W@@ @Pj P3۸YFiV԰@pRS$1$ÜX	S[	[PA}Sf3یfff[F @]qQN$     YrfSQVߋNfP¸$" з[!ff``B@0ρ v0*f+fX" " +$^Yf[sVWv^~F
N~ tIfȃt_^PQWfaBğ~NWqªQYê_YfX]a0..v= c"yɠ
S2P%trIFyrr̢ȀϢ.ǋFҀ}F++ ɂ"2$2`N`&(	@pP P0 ;FtN 鰭aBG@pVQȋsLY^<  ^]1}WfP2ff
`BúffP~fX ŝ_]}ހ}f$ +ڜ2C@@bPQRѹ`;ssZY1ffRPFr2^*/NpF!=Dw=Ds-t01-Gr	- vHHt!!HP L 跊P&VjWpt	3cVF@
  ~ 33(L$p2	ೡub% $P`ntZuVAE
v P`dpKPS'  0]V @K Q%0F 6((0A  @RPV^c }I+ұWL9Pu(
!Q9@u9Pgu
pP
?ﾺޢ ?P%0f+}f9Fu0P*~u0P% @!LN_!t ?,0H? McM"~}+vu9P
uދG
:$
𰫀%@$̰cM%0P`NN pF+v&FPC9F|,㮬M]$pI j#0P!t_PC8h60#`À*PÃİVrx!G
r,
r"Ph v*@y 뷐2QǇY&0H./[t1QG0@!(,*,,,.,0,2,40S 7Ox32y|3HGBV t; u`0Wd|䞁Q`9 (SA:}w6/L8`?@S7`ӻOq@*T@C,K"$CmCp6+ҦQ>Z`R©fFڋFbA[Q:NA#;G  {*VA1	F J9FuN\!P@K+F{HP~p0P  V_v Pp!V7`Ӌw2@PK"*@u#(KH#؋v`UtRc `SwA5bZ9FD HUG+9(I#+3؁:TnZ_hGI@III0t0Bp;F"bp'F+FNFOaO.9FPcPb;FUf`CQQ.*VZ^V"SSjThUKVFbHcr)mrL fc  '"t"oJ P2Cq0;0e@u&jCXXYjYaZ0x[\<0\	^0^dx_;-%P2;j0?9?u⮥?2*K|V 9?@Jv "@Є  ~ ~8,)Fy}^3D`U@2;i0J@ьAD+p6;FsG+05[FVuxrG 0GGR3 lq? `Щ?Ѹ?A05F +*#{.]0I骀^ejQWQJ_fcwM `@Єa4+@oP~nVp0CvS@wTBhUr LVO^fMb?F\qVP2F  GPdxM0UԈ ?^9@ts@^
`@KT!'u9z^͸`\ 	+;u
;uܤ!
qa93vUءx t5䦃x t:VCB7t32v@?3Qe=Q^9f4u{"y#@Nt$L(X)=uGtDtDtu"Hje*+Pj+0c,؀^[؋>`ܱ20FډGj12ؑGq_G,2} _p߉G'v0؃'$@ ưɋV'820[氇`dpbPPfh  fh  j@RPFPvp_72B9߃ u-^ jp'3 P p T؃
G3
G4
G5
G6
G7
G8tjG-PG3+ӑ/?EfG7?tG{A7_q#GH8C"S`ؑv0s
P@+`jE_.GOBA8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<_GC3?,-`9GtĀ8P"m p
rA1Ãn
@u .cDPf܀ t ݿ MGP9( o&Tu>$ o  A{c8 Z" Q" H" ?tP
 0C 0
Āt$0
37
ApB]Gor/)
!
`WI+`9F
  
0k t `-O!_ w-*+d-fv(f
ffff 
ס1- t 	
ZPՋV  t	Ր0/ 9 =   w t	a		8 4艁/
t2=~` t	dn !~ @^Q1/UA	1%	A,`B^_:RSf`=prP-X 	``@d&C`لP2ÙA&*&!9fg
 8:Q`bá>gG)Z.QG`
 ;q0Vff}!f~ ùQGV7R	G
	WP
WQGG/WpH Q;!Jq`gF"(U 9:::U: :!: :U@:%::):PRP(3A$A%
r#
1B u0U*PЊOԊ OъOa
 +ҕF*p
$AC8DhD1B\"A|
A%'0N)0O+AN-0O/N10O3N50O7aZS90O;SQ=0O0SA0OCSE0OGSI0OKjASM0OO䵆SQ0OSuZSU0OWadSY0O[SS]V0O_!BSa0Oc1Se0Og Si0OkjASm0Ooq0Osb0Okb0Ob0O!Zb0Ob0ObV0OAb0ON0Oeb0OjaTb0OCb0O!2Zb0O!b0Obٶ0OANV0Or0Or0Oau0Ou0O0ҋEG֋UI yKDyQ ySDyUa ycDye ygBy}p:;W }| })|+*lm yDy yӪDy yDy y۪Dy yDy yDy yD|
| }!|# }%|' }-|/~	~ڸ0T&Aet񱤈u	  0)ڀA薠PN
`{:u4tA*eH`0)0AEFсʫPQɎme>#PS$p	Fq3[rØ!<L2`)PS=P$h p6#}%^1pͽ@ h8 ϒ Gh"N Hppf!G
N   !
 *	HtHtHt@V0AAyS8Ģ  @ƁfyP	FuEuSfp͔pJ@.JsT?F t⑯`	ڬEfU៽38ျ7 ͋G#FG%F^F^VFVF~%3F tP+Ff%߀  f *_#Gb3_%FtSRf *$%3w2`>	O V%@8^P4Qf.S.ˑ#SƇ 3Gf Ghq	7=h=UరVЮ<;`4GѴVGW @u̐T'FFV FF+Ґ9Wdrw9GbvΫDܣq 2rrзvkt!o̅B ڼ@8W`FEP4y9~3ã36䧵R 82*p"bka4AÐజ6S+ fմF  7u	Q	"0t0QԪ	@NF~@8FB}  1
N~?? p 2~st.GGMF~
uFޠQ*PP'Ň uPYFt]  T@.S>stf" ?ۑ 
@χ f2sLP1bA@ut@XPǇ 5Ft!d [t뻱
 ?q(@	*bץ(C!퇰2f3ҿffu9	òރ"a HǇ@KJݣQGi@#A,sQ&Ǹ w0q~T wzaKƇ123PG
>

g Gw% qR0U"wqqДqiēq9 
 fPA##aݧ@Bк6$$v"4 E&k('.2E1J 1B #M ``  3PS΁GȃG`q0PAPSNN9u2Ѵv?@0>G{V99G쁇}2O|04@0[x ɬp  s Նnn< 1Q@FGz@@p@w;GQ@GvTC`CDx@,%7@AC{CG`1}CHCұH`f+f\ rIC
LpLC DWԠ4H#1h tPfj ܃
!ÊFr<t<uAÈGpQ@GjA׈Gq3RkAňGr3RlAĈGs3RmAǈGtz3RnAƈGu3RwoF`%ʩ)Q@ b X䐲bYSYzAuB@ff0Rpj|I?3pHG%C% u\R\%]#pDDwRqap$̕$% 'b'T vcq(WdpR)A)賸euQԞ_nF|t1JIrE,6b| Mא=#3 /@0@1234
FV
fq`t@ t^F&^F&
u; SWV~ANV^_|B}}~ŠߦA~y~ќFN
ȋNu	] }S!f{
2[N`SF PN3a_3E^yupfr;Vwr;Fv+FV
+FV؃ 2P#   P blksize tҌU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg`h i : ? a y w <v bt x j  s |1 
CLIENT MAC ADDR:!XENV+     GUID:
DHCP.Client:Arch:}0q:UNDIci0 dIP SKǝPROXYǢ
GATEWA£ ?MD  BD
Auto-select:
 0BOOT ?SERVERգ)ѝϦϫ/Ӫ-->  MTFTP0-T  Abortedroxy¢service did not reply toquest on p 4011.   coulClocate acureer Mi?ssing  address BIS bad ry structqchecksum get signaRinforma{tifail!free mecmoл)bopobj@ authorizþ flag!shutdow!i?nitial9mage/creYd  v0dϾintegrity54Netwo{rkcanc d by key ok`ARP timeoutopenError - F@ }NpfoundAcc Viol receivfrom unknopcoderep
Paconn@ө2Ը NoS poffers wep?Z Фހۢf@namw In џ API fun numbŠICr multicast4whathrb PHYfigurDataaћEEMsettarrupdtoo many /packs̒PisP M?edia tq!p,4cable NBPQbioӿbas Bp4discolip = nu and/fmp憾 C-آstrePnџ-mຠ de.  /-\
SM/D?MI BIOs ne d_U_	d
|!u
 zo uQPːz u{& 鐃>.3 u3\.3h[0N0-  r- vHHt
- r뾐:: 1LP3  P=?6 H10A)~!aoP='y$30-q6`k
hx9 -i[#3utyI[놢[3m{o33A뽼33=S#?	3=1 tw5= }.f   0))$=q 0w-2 tHt-= +7-s +HH -!
q` i  q9  >9 tQP JL`df99f22hP99@t{<I`kty3^h
J`kShRF~@g }R84RF9*9Fr䡸93M`k蹱3n>uY!" 1J7NMqIHp tptE|jOhR HFP)9Fu9R 9빮Q}/>0u>t/II7ؕL0N!//9P{0C  VPY+ҊԊ*ґE@zVF=+$ fVu3Aw>0t3E(3*3(h2OvqO E_/0N	1(37f(3Ifp7sEy WN뜐T3Ih96:6O636H3 |3O8tְE2u}dL% KҀĀfVQL0zGM|f+KfPI&VFVP7Puf6(RPK	0M" 9UabWFS?V^f`PVr$=NVu^F^f&{G(0zX^Pw؁yaCu-Е- v/&iGN@z^& u*&GaCz =pa u6s&GibCG#&br<a0]OfQ1N@]U .Dy/9u/@g0/0G|Fo9`[Gf9  fP2 ~UU2kHkm3l@k\3lPkKUajS*&`fPaj&(GbpG0FF5FF~bp9G6TNfNfQhsHT7U04t:T^*&O;~S*\Pp|S3`uc#w#wE#w#w@{Aw!wGG$ac`u޴o
P!w(G	TbeG7(3@#AP!V;.3fpBb  t&}?#AoghiE04|0І RP0+Ԅ
ԄЄ`e3& 2),04恒BA3*E3:}aORTfqe|1aCa V-tHHu9#A5#AdfEqOoiCbe GPQЕ Еїї І P3cC_S& f`[`K<2i?B_vJELS3 Kn*2CŐA;uQLc|bed=3 =2 } Yc!0-6 tPK?u@OhiB.044@L@y|fgB@mӈBP3DЎo2!05N~O tItEdefQ@]W9 cfƐv2AϱCb
Q!_
s܀wŷGP1@]&W2604PcfkFlPDQk+0TU0T0T0T0T$mIfjF=vG*F $KI~ t
0M! FËF_Ft0M#ސ0f@ÐBjfIQ #ƑF	U80;?2#ɰF$ fBŚH2ƭ=F8jx0;VE/F%!0 . Ҫ0e W)VmGR_&(ѼPD$GfUE
8ǘ-VDn'@NwF=|E@0L S+;Vr
w;FvFF3Wh3HE^K U!<"00@T0Q0ŋF<pﾭ`ð5[F2=D8ǰF~ tfRu@0f WV2a 1}2^_2&s;( ӳC0ɐo7Hv⸀22f kftrHuVHu0HuraRPK00N`ЋV!GHt.;ԻRSRPV tDt@u2^+v
rD7D0`eN&]@rNF( U04r`z@ F`4@aht3k Kt3R3u3 7v
 Kf2fx{3@0L|a[cSc>v`zt!wGHtP-I tJ-
 tE~3 n
 5FFb1-q t c\|K0]f3뷐S~+u!2$ bR 7Fv&$$$$$$
$$$$$+$6$<$C$$$$$$$$F*FN`u^9 V r -
 tT`Fu{>4P+h"(CcG			th&CpX	Ch. Cf>	 kt.aL FTƁU.
AIu(5 eha]GFJ"w^Lqp_o	au&S8!w9L  0h6H0kǺ
 _ /=1>{F> ???= ׄF&GF>^t'X;F6F9"-WEf% !I6QMX_39"7Fq!^33H6&PF39F|ך"4O
.@f`2V@WQfjp88Vh: C$,h:G PV3`e!{ ?BF젵;BG<@  o>W@sqzWD^ZwH^ZL^Z({uXSXXҌWwT^ZX^Zw\^Z`^Zh?___hEu! KQX2cMWd=)= wA.JNlߔ=ako-& 51nD- t-;^- tTV@Р9vO00V=4~C HtzNR - 頟F2WWRZWgG 7WpdÌ²W!&ǉWg4&xx;yy1x&wty{Gy{u$g$n	r"G$"hX	 苏DP hs F*Ci 鱮y`iW
 Sw"8~xyjvT:,,@Cg,&_*|&_~-5{ -1k	mt- t:p ` t$ u&?  u
Әbq ᣀ?tB&9Guf& u  t؍G =
 
*!ĩ`DW V DvvvBi7Vj
 &fXfYffff88A 9ߠ 7:QFQjPe+ hB ix pqUVBIRPE T
ix &nPF>_ ep`h0L FA=zӂP5@7u~ t	F
3
UtltppR32S'Ȏ  ǆr D0577 虍880[** ӒѸȍӆt𰓞 t^ uf~39Glu䁔pu-$F%@qSRQfP
R
21T7Tx&B𬏭6贐 777"+۰ϰ) ̋0- Dt-gut)ó uQpu7h)%?Ȍq}sPi0P)'
I`^+ y
FPR`0$10TsT% x`DP ivt u-FF9F"iPu3P9`RI
bv0տ¥i񤦵ruP}.ivQU tFs1 =P"b԰h\V2-.>_cu1MtiԒی&j&hy){CyX5?c۳tt(uwH!kl> zHjil`=iFoPqU<fXST㋀`@2	 9{RtPs: _j\^@HtHtoi  3h5&bĘ 3F0h92 ;; t	ՍYl P~3iF01P81+20! dם+1&$: g 2
o
K23dEX1;~ t3Ǫ@9)T cq0(ӡF٫2LP;3tq* u
1C D+~ r,rPL2FPL^ V@Cu~3*=*.FT2   oSRPW|*/P7=00oP!!k :1\!Opo8*:5:0̣iv@:ĘTydh2 F=9G@?@&=O#N; ~ ta=+RAP
@:#PG&WI9FVQLPNstգL9Mu9PMuNt[~ tH3LPNFAG-Lvi~@:ᢋ؎F"pP~;\usJt
F":`s	-!`V6hOb0Sn21f>&f`f9thxфѦhoS0@R9 t@3 Kf1V1ƹ +uhc0 R09oP藡X@0`rh?0^(
A") f|
f`:+h: o[6 P)dF 5 9F~_ ! `ux_ aak_ aa^`
_ pL_ !d?  p }/^ۋ }cFпPps_P dg.eB +.1Q à_`ujRjS  F9v[~!uꈤ@l[U lu1b$+"ɮl tuntI1"4#:%t\ jfjvÐ fv  軵4rƃ3P x"𾑺a t&Gtz,@ 8{!e|tzl (| u}Rl taԐÄ|0~rƋGulp upxJxXyЗhPC4*t--ePEz k*3cpJrƉf&)f\pFFtR~ t^eE{{ P99Ŵ t
^aEu4y:Ÿpq^B\4:FFu	+63 >;`#	*a+4*6FuHa^3PHa* u9,35B3@3ń t^>u
B33`pJVBC YApPe PEe> w$x׋V;xP^ÑׁӉtOf6 a1\aP)տq"T"&
Iz)_R!1u[&x3肱 7" 
 hTR f+F^!K
&Fpa^OCNFc	9FsA곋^	&9uG×p|C@\	 1aIu$GR&_GPt`|P|tw To'qxP tt>~ tz_Tm/h;)2g
*(xGpJ&F h(Rð=# /Ӽhf 3{.-4)/$&	#u^S!JrJsIb ˴_(F YGV`=(Dvf&0O3űa(Pw2f`~^NvVFn
fa
P[2݁ǿ  h&$6h^V6  u	rwPd t^`¾tfX u	   0[VADuyTT u
vxkP2   v wr@TX`|X>s$t̆uCwDQȥhR6=GXEZFp"	 Kຉ	@Xv&@*!Y F;Fw~T\ `tH`> t\n>rR
Q_N\E^UR


B!×OR
4`&8g@p%3u;v
軺% ZFrZ l0Zs
Vṵ@?Ht'&+h%)%[VNExEV3o+ǝW;%X*%Yo!qrZ%Z
%*3P$Is=R $eHAѵuUZ$ ǆp6fǆl @ Ɔh$2	& @}n$  hO%= Btw3--,uIA `t#)"3R6- [t- 
tؑאĞ&8t&pP
u!pa@)h#ǆqG vȾq# ȠڂZ#WP`G%
h C @f*!"W'2" @"M9! `Z*#eR
9FrF
 $*+`vЎf^f喇^*hXfhp p7VV73 Qc/@\
P_fh  pV1b)v6O+p0- Py33 `J #=.t = t -t߶)p tN&fh1V}1q'2;Q447>^6U鿐O-=KF{ i=Bk)B'p,H S-	t-
-= K-w- 9t-
t- 0Mt- tpHts![pV>Pu1$ >TJ9 QK$9>
 tFu&"L^Y ^^ f!24r0P9t3 2 ވv3@fQv&8 u@ffǀSoctegF@fTt `UF9EuES>? ~4pVv3` $&X%@ UXYV~ t?f(`<auX   ]]Y^ƀS0e$^e4[bK
'@'`9N`J`63ףL3_z`v'kRKt	t(>	!ht3h9 29 h8_ LRM.bL3 {zRK VijPǄ ff92uvf`ku:P`9u1h&_&;w!nm``pn ߄f9l&{:lt_i}ju|jJcbdu93ba0bL3١pua=Ë2 2 f2m>J3P VFVN3 &FtoHHt	HZf([u"hdFhl}}+h; \Lu< Owu	= > 6S[Y4[Q  x ep
 !$dN3 	>bKE%+ RHct
sa#wtkl9Q%- `9,~L~~`? k?Tc>2 upo9:?h2 >#TK nc#uBW_WKSRWYWmOQXX*<X)"YZ=Vt9느Ff=E~ v[Y`ה ]M]!zY(3O*3y|~>Nكq ,}ziˠ#; -c ah?v9Pۣv@u9|Y$#R&sv90CWl#PQv9_!>	>ewڰ aa>4d4Qb v$ h|ahcQq%
rtf'k[:klkEp:p/0ܭi	S0krk9 3t\jiu0ᭃ v\v5 i9f > isQ!c-k"l#>rwpؓaqRÐJP3`-E0 1Q'*N t:upVErɭA,:,v*+1B2@`fj
 fXfYffffF~*FwF0^)FX9Fv	FˋF _;Fs"Э́~#v#Fg"JKpKf+fPӣ63أH3OtRP`? tH#O9M}b   Rᎋ;F
c:t `aK8C0 Ek9f"z@\fpfFF432N`3-6 5|p~cN˙baݐߍFPж"}$SK9R݃t9"*ȍh1_x? @'W fKf 5Hj5͋*ڙډN^bwFV;r
w;vG:Rݏ@@+؋FVw RݽsP}tt11~`:aPtJFV43?`Ff\f`9FKOaBްndFu
/E
3aUVVvpZ$0=  t)ArZw <Ar<Zw FC:t^`  VfC*N-0S^RPTt@T0r@T9v Qb  WVׂ00N!2ےwߒӁV3{^_tV 
2C`=ʙ~ -utF0C_PVY
p\"Fɽb\@bh8hV3# ,V3X3Y!Z3@03\3`3ta3barP  PJ@ol3n3 Ipa$k9pZ#O99p391%9%9(Q9v0)2rp!'d3'h3( Z$""#^PX3
 b0#!'u	W3 &߀?r"1wh83P~ f Q O Ru!ap͉V`6FV
22##rZ&w#2#62;ȿu5;u1N72o894A\4aS2s%jNQ1 Z3ъ]R$E0"0?-f@B. @-ff-%/o
/ A2V =	- @`F ^%2DDE FtG@F0+F;FwwHIM-DE+V`L"F"LL9'qG4 ƣpH@FFf>6 tKa;8rBw;6v:>d'F
?+6 68= X 
 pV܀~t	F~drጒkú> ur[r]u`۞/a/;Fu$<u&pt
f>  @usM% Ht `&pS69FXc8wNX$0d0V~ t*f^&G&tpj&9&9WxFm%  F"\p3u9Fou ot䑬!\/ `aj!U~@xP'q (9g(Pz9) t99~ u-b`!* =tu s1G*]
a'0 t7_F^(l{t#U0q9Fq9FW`ۉc4	PtĨwG@ur BruF9FnaQwnЍF;Foz
 F09FO99v<w7a*[	^x? Áavma҂Qi) k5}0y	yQ01]0A6:3k^9u9ukFPa=0 s
! uhph? .Ӕp!Ƈy`h9!  9֠9  
9h9Q
 fP3S3&R39099ր't'Gr耤9жG
P G`\F:zS"akFS3rPOs!sWkLP<'9+	rж̝$f0= u 2Җz 
=z@Ā]
u^
 uf^49u$ч@ w_mĖ"".@@d`Ңbq"@5๖ -{aah:3Mp99[h.:  t!@b m  f W`Z3$FPj9&_@]3Ð ÇE;#$P

׍F:u6~Ku+~Tu%~ {ua :~Bu~Pu
 ɰtް-E Rxʑˆz   ǆ~ԍx~ǀ谖 _Fÿ_aSQ @@݆;؋s_Y[\pF̿0Fآ0)ֻR%ԣ0)w9҇Ftېч$`$FFV6PFF~nF0@ FFF FFFϢF}P	F&uFP

@FF`>F/ST$PnVF̢5oFP%

@[.&NXf* PWQRU>@[@ > j>]ȃ us>@ ul>L |ibw[>* L &D F +ȋ  ( B`V6H ^;s/# !sԡ( ]ZY_3 ~WW_f`.P>9tJw.0 q.A!0t9а r   fa.>*N t&.(N! 9r & ӄt"QfP(N u8Pwh3ظ O&.(N&G.*N[i Y@Y!ĜSQ3ۿËȋdtFAÑhf
Qt`Y[`f.(N}I f.@[PQRvo 
A	˃ӈ@
  .,N X tZYXÿ.",N
 V3YӋû^]
 @PuYБc Yt24W  _^]Q  2sYÀ>[
 u[
Z
XР3aP; CX
n&5T
ωV
&AX
`  @"ɀ>@*u1UV?+T
)0VfT
!|sPf!-f/  j.)*+9Vw-rowq) '/|"*댐>
 tZF0 04hl * %^9s6߷P m@506NohUPV37$
F 8Ft)F ~ t$:$* ^P +Ҁ>F`Ƃ9R$Th ?	-t-w,tPWV$pݚ;N ^~&&Q#2#222##;u;u3Fsf9 uETFbI?99EbI;`Ku;Ku?o^_03V}PF!URO;Fti"puP9BTHL24bI961M9Kt4Z7SSuIbI%`KKQRQ fSfQfR?f Šf;sf;wf;orZv[s@fZfYf[]`SQ?r`Y[ PS? [Ft%&?	u
h*~ FATށ(wp;@   a `: .c'QddQdqd*`@+!`(Th0>ɱAT`pd&Gfk\kR 
kwCk9l#k*k lnk	ln
nnn
n{nu@2\Ru	s2?2Z]vxuxPRwZXPRZX]!3P
pc FNp;3032AgG6,؂av 0^aȁF+2à @tHH @\Р^
t\
fw`
Оf!d
-P kepd
 @hРtd
37d
+ǰ_2f
9u+?f>`0&_4`ϡh
f`
fj
+j
l
f6j
2+>>`Ƌd
o)R@@p@@ɟÃ> `,8a  ;u!+V+ɉNFu3 >^f&3wsО WI&O
NHp0FF&9wvhV a9GtS
=u V>!3Y,thn
V	n
P ɊAP◐rÌ AXVfWtXˋf`V0 +N uf3lf3@fƉFfFfF / ߍlV ?Vv^ ˿^~0w3204\f_f^]PNrX OfCORPfEDOMf`༿q ]'fqufѳuf=23AIt
f=46AIu!a\P^_ | PtFncapp(BN0+V
OFtcOF&0i0+Pλ*#~ ~N?BR帾C F0N V#N'WV~Ťӻ!NS@WVBt5x5Dǳ9~F&%G<ar<zw, arzw :wr p18PSYp(G0iGWwGg
oF GFGWFGOG2Cuԉ[3a[[2ҹ G;tTwGg
0ogwww_ߒs|F,Vn*&'*@û@ &l &n f%Pf#f#f#f#f#f#f#fXS & [ÌرWVS3`(}Gڃ@V@(
VN3tii8 V Auif
r;Vwr;FvN3ҖOu؃ [^_\^N
Ȁuu	A\S#wf
2Ӓ\($0:<9vFbSW ۋSR3.:uJGuZRƀt%@}uw0йt
 t L`$Pr< u	ZXCu33_[΀Z^_SM_h^v_DMI_`0}^a$PnPR@^M_SYSID_PxP2P tP'+܀Ntatn$aOa /+t  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6   .     @	 _BM. "v }( B  @      #?_! H <*z5(5&5	$r
"pp
p
p0

̷́P
q
 p
 |pp ߊ p&q



  `܁"e ߁a     
 @@d`
Q34 0 $!A &!q
@dR  "2 d	cta#`!2#+  a#$r*4# a
$DA)A d*&a#@+@-%π% 0p'/> %$ :CZA/!%*& 	 7H y,t7 70$#9g
!(;Q#" ?"c#"`A%a #>:2@9/D#'bA'6,UC=p-#9@1073+9,"+*UCEIH 1=C0KQ5,r gMJCN@9`rKpUP5 /:aNdV4/SD:PAG u`( BeJjX($F" u*D\19ITC^b-0,KQr_
_%#!4a#LaYt*!((W+'!&$49^M@< \7q&6,!"D9 R4(Hdl+WTnȁB0(/R
 edcrVClcV"|Y '%@\/DPuRcJ Mvkx:@\ D_u\9Dv@a
CI^̤:#@+rklf9dh2' a#A>'!#Fr @uYFh\2) DՍv,Cxv ^!}l1@C0a#  P#iCeF}Zc# Hq~T K8I !IQlWė|ŋ:
5WE$ g	mė3T?`3 9#!=cEWFV9ėbWc9a3$'@A;#eY
S 
K q.iL c%5譶kaV+ca0 q΀i A6YcKc%5DEʚ5 B}ud=n'm9X"űiUܣ']d96CN(FnUB gCxf5w9dqHJmdC,)ѡu2bYA>@Cc.́IQ yu T7Qo@$a$LCPhJlޱa?G@X#Ρ`RVt.1GU@ *e@
:撉 U~Qz7@
Da
A;$P,4"aAHf$`A+RZ`!(2;),!=*@́)$*Q Qq1\O!fpU a3;`3a!=~@RAH& RR$(A;!4a` *; I`3A $a!  !@Q@`R#[AOag ހ% 3:)
E:!2H$qI!a?@7r
2}p4J|qt  H\     
   `	 _BM "v ( n s    "#       { b< I 3  y["   f0  f#b32b2b"#1B#fU" b	2	#
 /Oo
$3
2,""?"EfwveB/2(EgUCBkd "%O &$R`"@0  !b 
SeD "$@$EV{#t "zx 3?'u$@'b H '@#1%x '_ )qCb"?&[]-/i, Y-QG.@#9/+02o@* I"4r"@t.BK.?4P-2@64. 2`# X-/2O1-Q9(/`2T`9@*&2?;/j2n<!@+E_$#B*#2B5X9;<>/
< DU I Dd!4w/K2B`D#BjDDqEgD&2oF/Z DP<;2HY Df29/N2;K D\NqLIj DGo D8&<u2@6?bQ#NIJPzQqE 9u 62B?3@6*GoND3T1EOobNVID0#@62OG<5PT>ZQ_Td\IP`4ZA/@6]p9]qQb2^b_AcS`qEaq<PO]?(OAcfB@9fA-GQqQf2Q]<PY/PZGfHEIq>A<`/ D]9]D:d+hon>qQi?F1pnP_qYp/4fYJCn nP
i'bio ^qRDWn<pba':YqQdQsuqy1sdAOb>Q_qkfn{(AcWD"\i@z+B!O1Auo#dQEbid_n{)_@6`B@3qTV`R0a;EhCJibQl{Bsp_@3S|N@3/U%WၢMEU_dnvf|Zf&Ď' qWqLESK govWj@@(9?fdX DA"&^PNOk u9G6#3qdw0H>ѓ<ϝ8QrgabR?h`1wOak"4KaB`<P_ADbEz@V< 	? 71j1Q_7+H<Yuw37$_k2EDASMq_Gn#d_SdFiUqE "usL16i9u_U__N9PC!@(V/Qo qq9](6 Dog- CQsPںvQWKu<@DB/ uwc 9tqTQ]eNYPº@pqE<|9'_KBt@C1[tׁJKqQn(OpBp Z2OJUW2@uA#`Ds_b4OZ 'uK_#vӺaDTچP]]sϛ2npq;H܀XNKC_uJ2y0@ SudD3`qQ*`.D|bE_@CplM?[AFwOB#5Q_W1R/ tun"K⇰N&9;-1iad>^B*+29;3@ p#| 'РxQMS 59?51# -Т?`rs:	]`51W2GNS^$Az2/N`5?b>z(baPI.[Odb@q-pLP.].y>@(W?1 'J`rS-)rĺa $39cpE(QF/Q2Tt9WB&-.9+Udz@0x
r	;#F )9W]UUy =Db-P<4 JEz s"w AsD*PN"1B+T?{ rUEq JV"@:?H s! 0(z=":V"q+q//RB@3Q5% A uA  52B%\sQ!Ry`BB1g'@!8s0R"E@ipqX	*[*! \Tb pa	**h-@)B1REypDh- \vfҸ"/SV" ii*2	*"h(J5$.$r	*M&"a	*(4a{	*,F0-@.W B/P14*WEfU@iU58p p3AV"f[\]^`?a_b"# c2b"2b1d#be f  fg       J   	 _BM "v ( _ }    f# uf ) 3  \ G? T>B   2   " Z   \ X"  A"T3A"V3O2"	Xp	B
/
Ohp	OcF3V#wScAn@
qpf,Jg@`x3G}v9;Ҁ1D_ ~!30`P"NN"J$'#J%X&7"Q	#r(b("'&f`N #2f`bw5`2 ,,V*`0 +4 .U&Oq+^@0} ,3`9@0>]9@01ISC$21c/_ 4b 6(媂3: 42767'4434@073.397/3s84_9:q83 6a%.<F8B_?"K#E'A6`BCDEFJG@H/IOJfK/b ,P7(QR<./NBLOSS6PQ0i@01nB<6f!"4RT5րYWSQ3 #6+Y54Y1D77;u] _rQ<U #9QAW #4`1 # 8cAX _rA 8q<Cb:b 85U3Q&q<61gf#nbRg(37Hq8jbi@XSHj Q<4`ielnoпpqrt#&tXAlݿ< wJ6wZ9y/zE{2<G6{,9Uzi% ~6{*1U#3%]6{(6S ##UTC`%6{&6Q,% c|q| #%6{$0S`	Q P 9e&6{"53!U	
 ]iB@#6{ 52Z _ ,ڀ f-%  ,-j@0ꀂ`	
'RZ&7
3) }Q= 4E2 @#!B71^En! fjʖZʗ5Bѕ -ʖSȚ 4D/) !!$z"$.B1.I 4PwBj!bUbނ<T]]cN>U.hbIYj. 3f12p ^ѡcJbƩ^aaD#a`1ꄫ"ʀEb_5U _`gᤫ:@$Y*^N@7 c10M 3@0UaLѵ૩_A`2ME%	 _/ _3`gYa @"0.1}DQYY*@03I૿T0^"KD%Y5E9e0Pݿ0LőC_7E@$1`	101Jf6C84[%³M0]b2)9ssāa6 _5QQNǤ0 >Tб5]9@$UTECtQ<	A1M 0Ⴎ➐Aa !`	SQ7AEBᩀNDbrCb c褲> $ QQ	^R@kЈ @0頡UTj #
9CDq2R B
 Q	7Q	b Y@"R ю3% QR` SꂀR}~;aR)." UA
'0(7'`|6T
+") 6S ~`g0'>"]"{{o`X0bp`	ݘz`vzxRxG!     	   	 _BM "v ( k }    ># PPP  u 8    {] V0 3  ! `
 1df}hd   j	@ !
J@  
u
q:@
 `W@
@NbS
5,"
1b
B @݀
1 Jb@

QW13 AH@L@`#
̀:Ѩ"#bqѢ)lq'#T&)

 QI'1-
Q!@,-4+	
R
<,@

B`/ 
q2A/(C+1*
"'ߒ(4@$6#4+Πb%596ޢ`;#99%+#DUDC/&W8Q?9 4KU@$qD65Y<  $U2%BQ
U23/"-SI1+  ?UBC  K%US/>KE2L<  
{ 2L:M%"UT/8̲	M5$0LOE&0L6	0K*pK4UQ,G2UQ./U?0UQSPO.UQ%00LT52pK,U4S*UQE_6U/(WSgXU8pK&W:S$9ZzPO"W<UR\=>S &]PO/W@\^WBSMW@T34QD3E@OEaT@CjdbTab
@E2O)U@/ bMRaO%eO?fSfT`epKBecS`dpG!VabfDej$f_eEBf3fgza/`@/S9TaS@eJ@Sg_ feoBk@l0j@mSmH1pTn@#geSfqoSo_"p/@gicBSiQb0j2fqwjSjjee?auEc/96R@?$ig?`f/bfswx|	5 eUlDanc{P(!n@ffm@feсxPn"fOwg4`@5 d?Ob"glG@f$3h1t?@}fqwqmT`@4cFb M/abaDpKuO MBE@m O/	K QP ORfph PD Q?	GL0O D/#EJpK
?Pk"/# Hp@FpK#}0K"#paD`V?C+6Q"/	0$
 fgwgxoC+D P<C+xH#@@hJÒ DhLoÒG l K1o:&yMy4cMa@gow`@i00ƌ	2 
o` y.Pƌypࠉ*CQ@V&࣯	1 }&f{&q$0vQ ` oJvi ģSi=y Pmy Q!oh`p\2j`Ufࣗfdpp `zࠖ H`sQqv1w"Up`	`oi`2+p	B@y P^7pDGb@x q  ]7TDÏ  	i2ŏೕƀ*`` o\qp@⬀ w` f  [qUÙ@*Q`ࣇ`PJϘ࠙  !р`*&Zo h©ʑhbՀfXB⡐ 0 WSТ1``PWi`0bPR ТV	`:טv@QܕT p"g S`PSJb`ՈEoSp@ Afä#RM3`!ACQMQ׈q1pO"PN" pMpL- p@y PyBQDCVH?gwFoL		 IϤ3ܡ_^Ѡ   $      >[؎pc ЋDZpc+3f  Um L!$F10fPfSfQfRVWfUCES>b^ ukfB  N_  L^   tL^ ÿ tPo 3  t
z!	@@	 !	N_Fa 
f3u 6`< tf3
pY_>` pz_pb>z_N_;Fat{f   3ب tHPtPSQȁ u3Y[XtQ3{ɩ  XܠAf3ۂ  _^fZfYf[fX[fV 3
>a t
	r&afXf^PVW 3W Z_t
r
>T__^P  f&T f.\ 1f`f&T f .\ft'"$Ot..\<xu<\ܰ޻μ̯۾ݷاЮDD(|*8?)/,O-o./0n2!3AA$$~"m!d3A@65[0@?88$y$$$:$A5 s9WIr<90`6`>6<;;?5'Ya@25 @4A7	I!!\562A6>>>d9(F)))**LLH4B$H~B'8y8TF  >""ZFD=d05JL#m<L` =6E8hxL"J'yI><L=2
_
	A"SDx48 A8 0 p[4W	

>;Q$$D4@X>4N6((DD@=d9E ?A< 5
)HPRs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜cInIڍ׌߃OsJ\gpjځBȉymFGłrݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEьԐUiTivǗ؊qlӔC~t`N֖ؑ{pKWoYgȏlϏ[Ďx=b ͇  @  p0 ` 8 	iQ 1 @GP ?TDR2
 Pa Ǌ1!!#"& pԇ~|Շ  Pvщepg?   7 ! ^ )f@aÜp z0 `)i`T   `00p &7yBF?LXp0>z劈 27<2f03Z^`?08Ԥ刈S4T|   UP W F >"6>O9a' p9?~!Bc""!B'  /!B#b&2 CA`   tLwXC>p1_@@@ad00`Bft,0<`F爠00` އYpC !M2F q0 XD 
	p0 P $&# A8_ o Q| D~D D<Q B f<,$$0$l=C  1ƀ@ڀ?3``?"#!! @@ `â 	4 80	  6 aP1pp<Ű2P!3pDr`@PA`@\D2"##57A RPq[2Q8A|q %rm?  20`aa A 1$Q$$PyH {HHKxď d $p@@ 0!c $2&f# 0;xxMƠqxpMAGTbE@@@`)X0$x|pTT T8ZS0
 !_x1q0 b$3@$484(d(lD&1< ?! ?&!<? !!# f4cč!k,c?Ї|q0 X2ٶp!ü,4 T$9`0p6 " @t$Bc' a}"""A pp dQIi&0oP@st
`֚@^@  X#2Bb"6T$-`0`|Ppx3@@`0 p@ 0D)d90|s12m|%o38"5U QHU' &Pa! 3?!   =!4!3#CաO2b2c?1`		
	21"`na9$i$	$	55"33ac.FP?h8CI0#P;!"*220Hi)""?"!==0!'  <p$P$%)*$ $ ' @,!## (ށ$ `\7 ga×#16 < ~ < E  <$$$= ??d)),?4+fIa'0@p6( g}Kq6 )*Tp`(r'@0`R  <ƀ <!S=$T<0b64~
w*VhHWg=  ~  < {D=<$Z@-05'p'֔D]@
wp@aѸsD 
8h: 8pa2Њч 2oDRD2ht ""z}"ci""s2A0 "`@m
D
lb<,d,0%}IHTt(ь@(DPp 0
 .:23Vj& x S6^]y2/ x; `3NDAg pi2"Ri` @"4m0p`4ࢿ :I7>
|sp^D ƃX̏ HЊ0R{D 6bpS `o$$/A1 FD @@1#f1~(3H2~RHH~HH   9 "} 8F :8R)C)E+D:<`~""6L@6q"c  2"&	$  c2q}pf"bʇ
pv;? e $o@֕pĳՁ
rP?BF0L :Bm?$&""k  0p	  x q֤	#`4 cpu}PӶPpP? Cс
r(@p?@@DDD D0!ca0@7P u!DL|(0<
Á=tȱ>s=@4 20i#!e0 ` @5?!#3"$$00!?0!#! ! ?;y@PwL7@ }H4`xb2C"cy@Ch]ՠ8x	< }ia@g( (@@9/f56:Ҡ?錐z2wj8l
>b њ&:3
2b2  1#n }@@~#$a`F$?Z%Dh|  1    ` $0K {  p "r1~&#0 א` wLp1 ?c ݟ0

P`8Ǡ߀`X `g9cngIňa0S%b8Ga a  pRR2R2RRBb.I4dᴰ8e Â=R)Da2
 PekbPG?Da,=%$>ÇWHP06iS|D2D"DvDTDD6 #W aBu`bXxS G   ĀPZBz(_=_4Q`8	  6 P>;5 ЊL D`[Bf$,892k&	ap I" 1pxPX?	 qX3"&,0xP:#q_D
v_<x  pCjiA~k8|	(9H ;)*;*$*%+8TT5Vd7Rp3a6؂6~5uk{s pQO`0`: `v`0Ca$Äu @I i~p*H!K6cPdтC 8x ?~!B>c% #"@&%&b0(0oA(a8]u0"***" /"$'$&*"$" @? Z?0` R?~$BdB//B
BB~1"&D$(-pyZ22,!qG#ihh:bA )*S~S [P=I H<H$H$I$=" ǉ?;80O>@"@">#"D"l>("8""8>(l6c0`` @J@?4R$zea~pUS R PR `py?0 ;6~"~PE-.b҇aaPz! 3 ?$$$$5d$Dd < ~ `K [T $D$=0JC7WO0Y`/$y,(80d(lqD?  /"?(/(/(hOX CrX-`sycYRz!fR`l	 i?F#g@Z@caOtaQ{Qc0#y`(00 a?$`U?			?R" NE-5|!?Rcqc 1D= D~ = @Lk< %L8= @|D< !!"!"="0""?;@vBF\p8@h1@ApCb>HHHd,$|$$$TdTDT8l- &2`&f!Bb62~Z*\*jI0 56`x apv H0	  y 	w 	@| 	
lcé$#~''-D(((pCzsxB0  \ B F>lxPXHL0F`C2j0`aǠ0  0b64~
**hHAۉ\$lH UIHUH~HHQHU~{HA6ЌCE!wN8 2,b)) ?()()~?H!!!aGE]'40g zcs" F70G#`x-(p= 9P ♐<$'~l" ">A&>>" "&"cb@	"00P G@`` x7. PJR]?"#
 1px2H|  8p0 S#Q8#e4GH8<
%SG?  > "~&%,?(l)$`2:-?Qp2!;VRw!q# A] ߇=ab>?rZ $ '$!$34, g A>w??$`1bp "**~*Bb~?B$fáaBFD0@ @`@@}>""p>bB oa5?~w
(L(L.I.gCOwgи$}8@Tll$5?b5dk>^qcCYrZaxA	(	)	) ( )H	p@{c 5P|Pax1RW<?~""2&4?60baÀ`#&&~Phdqbࠆ084c 0q$@&bBO6  |@<  #<B<;/.s `
x@V;RF-h8; 	 `p1`|3"f- |Aobo@Acp>bp@$	,	(	88(2l"Faf3sgPgbgŖ`'$@t~ c3
D(z

0
@u}~}Pc<4 7  p }#"4&0PPc`?@   R\! uUpc_u0PU0P0PU0	P0PP../S./DZ /  [<u./ `uVʊ8r
8s8t>8t: t3-v(8r*<rw./` a2 PO e RV^Ztu`R\ts 2ǡp	G
aO sENjPW1 wts2q1	q 
<
t<
tD<tY<tw P@?  VP L t	| tL^ft PDΐXMct	f¹/ rus 2 󥪪
.>/u .R  `.ߎ/& u2CQ2P Y*2Ȱ&߃P! aqRDr
././PSR  && Z[X  ǇO
"΀#%.6@/F&eF&
P(.#~(WtOt)_%r-**+g#QR.6/ʊƳP ZY[XR1  12c23OsP2`5sP
Xs6<r<<r  /  /.&p#b'4u' /3ūQ9*a01B/;.>@/P2@<Xw2P <1<$CFa0PQRW &j_ZYX. 2.98t./ur=;cߊDP9<u<@û<F<@<F<F<F<F<ޠF<F}<@<F<F.>/ t`83ػ@ ./G./?F/Op0CMM././@N L "O0..B/.D/Q"L;P"  XLzkTTXd  WV>~	@X
> tj6h-_t!j^Z^؃&  hEqYjFqZ^;[T"\\[9"\>\["\I\^1\o\[RcbqZ^%  = h[Rc?^\@[Rc#e/f|Rc$\\_RcJqZf\fff[5RcNrZ^^p[~Rc\%1j% Q[Yf>T_!XNj_mdn$sVqtj`m
v2wUK\\2wmK^ non[X2wAx{?|[.2wa{xs
2wDZ{	?1\E{OrCx{u[rHpĊ[qZ[{rSpb"sWrUpvypۇ_.r[tZ[jrgvZ[1\iLp[a^ uZ% = u	^1  ^t9jU9\^bZdeab^VjQN_$跁Eafh  L[6a`t,>tjh_fjhIR>.~t%j h.W1qt2>Ha tQHafhᡝ3Nb tm+Nbsʥk1f3f
 ~f PFPhghb"ЬXh|3FPHY= t#h_蕴h V`_ѯPc V#௰a&"h~aBƀ)"ѯFyuXҰ>c>cѯJhAԴ=!]^ٶK^ѯPRQh\7Fp@Ьjh!!q~ahac Pc)I~bh^Yӱ^!VOY0+u%hٖ0aíO V1!E0pR*h>W[h4Ɂ!A?0șJэd)ҍjA^_   Va^F FPL <tPvVFF~r~ڌы F FIuPێF&L,^ڀF*+҉FVb+;u;ub% ;Fu	;VábVG2 A9Q9b% A
Ð**	K
ÁWV~FF&8uًǌ@8t
rￋƋ*
0ψFEDNuaِo W'Y߈Ffj hp)~{ fpwfb!n &\߃&^jLfPc  tjPۘPQYj FPqO
@GdF, AWV!P[YV=ut_ wVߊ`#@aGF| ֋ 
0u2|u|qht h & q F? GP qFNuFG		^'S 	/7Y
	Ot'S<At	Yq[+W^ !F[1;2e 1 ![1v>[1JvI3Uvo[f3vb[I1Aj_ v?[%3@v#[v$Y2&^% 9[$ u`/^@![$ (^^'`[k$
2&\% +1\1\jRcK$0<wup3rh-_".,3/h-K".rAa-^1pj".a3"!3@	4A".35`3j	4a".a3304't%/+,_,_jD".d~a3	2&%U4E".D<c=4C".$35#3	4H".a31%=54N".E3	4g".Ds351P4jitD+34rE jS".vFc=@4U".VFc=4\".6FP=-_% 1<![[DRGIG3p+V:,_^ &,_^ jT ;!,_Z&X@큠UWq mVPPW ڠ
\@f\ttk!EJ",[Vpr ?0y;V1\0>a1_qPPpkû  Z^ČF&&gۃ&`&v` &pf_&_rHaB N[bRh6`hV4i_h.4jh.hhcjmL]Q¦!D$t_@oO uI t
v` _` pAqq use t rPf@`Ppo0tQ V*ooK2pEppoW`@qAqqU@rXstat=tb{t^4e}O_ud&o ~po"ZgY__$ZahhJ&ҁ0i(ҁz0j&N_b^cQVjIA9s1Vg~CWj#S/	
*ŀ vf&b &bu-&C#&C&CWgb̀ahJ `3(MZ^3!$ [`&`3vb,Q.Z	_ ~a 0B>l2B^>[؃	s$2`&^~^^r3mtDqupo` :R`qJ5@B:SFBC BVgpуBCٱ`$ < u.!@<@k3<1 Q	\S02b4nAſac6ZջjrӐazV@O cF^Nr'~#tP u^  1 %  	p\d",MVAF  jRǪI1дF	   =v3+QOY0ÐǠPcvB^th h ۋټ٠R6彋v/Og9F j ~@hhpM5aAډ1^	  ~u+}ҠFV vƂ F~ r~wttuFpfv
V,ӽPIuuSI  [t
Ӂ0@	 ^BzA~ f AۤFB F~P|Pv^ KF NqٍFFV~  tH QA
cFFV`m
cP ĉvFWĳ~
j
A㊠`m
^F&? uA^v葱?A_S|
ķ^R\SVAx^vͿamxN	N!F5,avampFAbFFPj"b^&/GFPv4amFbF>[/@P A_oP1_qZP8Z&@p6AΊFp~2|FtFʒW^
~	¸' _P@}w ՋF".tQC ?~ t;]FҔԓ~ z u WV~~ŋN^bs! ^_s"j(ѹl`
"

[ , Ԕ(|WVvԋNУ?ԠV ҃~(|W~B:_~@u"¸{}HъBF&W-} ^' J.o0P!u
  PD%˖&t
	z&_#$~%F*@
%}&
/(O)d*.*</UWVv<~p5F
&GF!5w5&p
V~ߋʋv5^5F}GIu4^&^&8t e^^}q0GF>N }-A@ ~ߋs ANFN9`;u0B770>D<3ɋFpAFC&!5 BffF ~Ћs ^BFp ~?ѥBHb7ЬeDCVVlEGV~^9&F%I6&{XaYW\F"]Q2^%W^\"]_URSS>"]̱TWRSSI"]UsVRSSo"]UsVRSSb"]uT= ]pS S?RQTsVCS@S#R4[URSS$RT2&^% %Y9RT*CUSRcRZ\Z+10f1\j_R!Vc31ff`Rgg
2&_\% fKRgxc2Sf^1^jRg[ek@YlARg;eXlYlaRgcRZl0Xl;3T,_RU,_jDRgg	2&bhlERgSu*uhlCRgQu`*lYlHRg~Quqb*uhlNRg_SyVlYlSRg?Suu@hlURgSujuhl[Rg0^3AU+s1ljgQ!VA@n'i҄A1dlvl-_t j^Rg3@p&&,_^ ?_ߖDQҚ
ٝszX$
)>ʢ#ye	/G" ޠ>j6h0^j^^؃ c1jF^bèէb>èէgbIè릪Nzboèէ5b?è@էb#^,` է0^ݱjbѱ\è էj$z9y{f\ffflV`
h1Kf^ ocqAR!Va~U$҄UD	/ǍUE?lC©!VGH^lĊl&=N$ءlUQϋۿۇڊ5qS$ B_"ǹbխ[ lbg*lbi8laaըcFMP+
AQjh!#i" WVv!ދ~ &F<t<
br$F*;?\}7ޑE⿀~tQF&8tF|<r[2d4VD^Eu	A(|Ð@7 ~pNPfh#  F0^OF;rFf?*FH F*N*ȁ vFܨߊP`0^5Qv0
u+a^F @9 FOuH
r7яfa&a&>aW tPGaP`[ 5`dt
72LU A6 &bDR2 % Nu"b$<!2b%fb1bNuFQ= ~P :ZSP+ɉN3b33 еP u*b$<rPePARZb% ~	u$& ?u|t!pf2p
% WN	 p
`uUtIpw 0
u6c
V!u*#1ҰFO"aaa aa	aaa
aaa
aaaaWOcvFf^ ^ ,o_` Z E&gHf~ t3 f&^Ft~u}uO6! t t  tиu^t?!Q"p u"	P `$uS$$fh6h0^à7Xa,=G f*/ a+f+FF9DZujzRP0- DZF  vB F~2|<1~rƿF  p11uF_F>[
2{~a2jxY1.0EV@DZFRv菰.F@/b*J* -NzQϋ'45V#1FF@0|Fطf=-PI7h 0889i"2
2G3F܊f`-he1<<9 AbF֊f -t@ t؉Fh SAvv`h 1ލD~S s}u߶P"MGmuFh=h{( @?`߿h DFފfPAƊFf -jy@<_K9ŔAƢ: 10F1F2F3F4F5F6F7p18F9FAFBFCFDFEFF~Ƌvƹq;؊GFơUދNB }s@XFNG&F;u Y& 2N46h`sa[Pjo2m*@C
- i-`[0C NVT\`V|<a劆2N_$0Tdd*e*e!eˡ qd$6!ej)Qad_v
3iie_b1j߾bPf\im% ;]01]1u^- t*-} t9_00Z_R1r3_2rf]_ArZp/[&c\_ku!5LÈ1xFo ^io^_3wrZAoio ]c]~`GE31xbP 3|
/}VFV+PR ԈddWN_hyyqd$$2P%^bHln2ι\\10mjLFPQt Hj9)iSiCBjj&j/a_]pBsvWV3 WT^&@RFG|3]ő bҐR& FWr֒I Rbr]BPW>T_߸ _\\6 6 &= P_ Ft l0]a㜅]o+
]
0u	2 =6Ĵ &&TAV0S~ t'j@F cI t/ ?u#'jQJ\t=7 tA]às`u`ul &l X^2tIIRbrbj PZR0`a -_tV2tC^]`^3pу+1^1p %3 A0`p	bX_bm`Pc`1a0aab_{\@\Q\R_UQ͡AU¿1ùp_qİıŲcŃ>u[h h:wDhpJ{C˚˯p*˵pZpjpzzpˊsˁBtzp˺g˽pZ^pMp˯@zWl
 Y)%PN۴ۻR\<ZF&? t5` (u%&|Ru)u&DPƋV@p.ɽJFFb 3"^^fjfh 
  	{   |G~ u &^  KH>"^ 葿tfj j .@j3= H/=
td-
t]-! - ; - @ o= M -  -  -  NڀS  5 ۋ  &9w&E!U 6  VV"0` 6?IG#  9~ߡ H bA;^ 
f06>0~v``pv&@u? @{-^ 1; P 14vĴ І3wwuk 
 裏nZtP	JZP nb SvV>ͽRv  vVL*F^ pʰ
% 
PpB h
}h  !NaF
+F@NF !vvo0`	FJZNVF@֢j q4#FPNQ= '*PaJPVW  А 3_^ P	SJZ%q p
܃qF`h
FJZQvPfF
n_;F|aP	F@P]p!qVv0?! N ~%Ft&@&H&'A12u9F@P@CFPFPP@G @C̴{t,F"!FC PgFA0ru
@C
fB#Pĝ`5 P"3 	* ^@]B~9v5'VɁ&@C722F77Ɗ*䱯 u8U  P$ߋVn]Za>  tur3NFQ | N`&8tG vNߋًC؉^GF
&Ft^CGD@]>tp@#A
A뎐V^% = @ʃ@A3t ? Cߋߊ@aKA~aws> u~s3ı@&!P*;tAmrLR*_`?0
0ND]R t=>@]?F
t"Ut"B`fob
VuO"&BӀB>?Vu	C(USVhW$XWS!! 5(YrVC\u%`(lQU3'p^a5&dD%RP3>>!bXZ4>[@DtNE@D@2@D !d	qd20=FZPHf> tOADuI`gp3+Ȁh; ~
 ~IFZi~Tjj~Tn`jMBguBDiu~ SLZɽi}#rj}Doo}.Pl>FZ }q "`j}wFZrm_~&Hjjsaks~1.%H`l*Rs oso@vQpvpv`qHqx brHZ}HZf9Fuf9Ft46HZ6FZ{qLZLrFZsH@~M4 lqO 0LZ0zPZNZ·r-» 1ûFvs  @	r ·2 ~ tOQEBTA1aF u <&Fy;1;ud39> ~D  >Z`(*HF\&79F 49F|04~
G;Њ|Ƌv`8E>#  ^W>T`q
bFf&GW&GPujUF&U*+щV;&E|&}1n17tM2&V,F>&:t~P}
AFF@Aua@6u9N>} D? 9`T&M*탿;}- ;u Ɛ3&8MtF КNu\4tك`*G;0B^|,Dt3696tVu9o9> 90>
P@0 3c
^&?9 ~rV&&ј^F䀼AFtIu,9Nu'^*&ϊ P` cT@4|ХAGPv?	 u    iF+F-   `F.3Sйd0	 b2^ PpFP |3Fp亊FRӻ`.R .R,Q0=kFP+ɐN+ف H&wwfFf  GV`ȁU &|"ʫ~38tC8 uP&N3V~^
AF ){G
uPSN3~(~o`u0ҊR~ F;|Q~`Rf@V?NV%v<%tFu DDF
0N$@ِوF
EB싋
Q琇Vp1tQЂ&;v~ .^F&uF8	WW֡"q?}  P~+΋э8sՖXv"P~N&8 uN&= t@S&{fh  \fhe !p9ۿqf6 ˊ+IQpސXqCc/N`"߰a j }Ocv~PWV@Z
 3v~Bv
&ğ0<f;~ХNuǋv@&Faஈ K{`P\VҐ1aPSG* ~p~h3ҋ W1Obt4bPv"$>_Pܑ"GWa** PcP9Fu
0*`_dU0 vv01	ea90,@p2Fz}+FP@;1@J02ApA0{FVQA0A2\!FPEPD/!Րj"21ofh=QRj PP!9u	fOj@
A,Q1@I uƎ~B P4 #=7T F+P+6jsyPXJojT)z]B 礘RP^(QT)+"@"WVsh`蚡+QS epF@E+FFF'P肱33
)pQ33)
WP82/	 PDPXo_QQ }181352+F+DP37)T6@:zO6@P<58"G"9+:33<M*A;}Rv3)Vb?QA63DGDAg'B@F?;v6OP?QoARf@2/WA%BRA;Q3HP=Pp+64HP蝑OV輰-<S2&&:4h;tY;} ^23DBjDВT3AFF~
`h𰣰:;&Fި@u[]AFtF; Va]9Z \[& t%];v}v`1AGF;FBr+F-	F`ϊF&Ev;v~ a~ \;F
`F#]2p13} t~Z;VGZ~P[|0p[tOC`\ΰG\вp
t/*b\F9Fo}\]"wС~aa~~ 'y+FB;ȳbq&L
rDFF s^rs W)) , V5 W	Pb@PF0 EZqǊv%x2g|xlhF抁44!@5i&jv@cvvF?v!cZТ]2~˫i Sl`\t~v+FB;FH/fh x^/ t$ؤ4m
kq\9~ Z{$naF ,a+Fqixya]@5,!p&ONb+σQ.،틝+ǰ
 @1?tj[!،]DFࢀj[1j]j _0~x10w =(Ro1^n~!1&@`f
b>
bbj Ww 
Ht8-t-9t- 	t "f2o b	QYF~ tf
bF  F
Pj Qq ΋v
 `?0j qPpHPV=
腝p
&wR0^tPs5Ӱ-1息 9}~ h	VV,sա1F
tF
t% "Qu0^a$V6z t׼Duې3!ҋǀ!_؋^G ~b 蓃^D  W*SHqv)`9>u	 ]OROGZrRm1@Ou(+Huau@uatj	jfh'1ZbrP odPf~
 t

\152 ݂;ۋE@XU-xW5IvFzg DVVkvvT^ ~ hω6 ؍]Mә3Ŝ*@HL ]ꍮōFP͔ɍDGťa
*IGv&yaޠH8O]D ~Q}ǀ怬+Kqtd`0M`+%Һ*AFFPKF'`d
 Y; V;NdNNQPuC_ APz 3= K = ; --߄-- {0cW݈Fa @p >nb { al`{;v1`;vFPVW@F ~FkG;~~pdpa - D- *- {#-  "3e= Pk/'-53. G3@6-;j F3?tU@tPpPll~_9Fu
VVHIVFH9vu@X`aNkfXNNdF ~9~ Z;PV 9vu4.< uN D빋v 	 3 @"|  `	v AVN; Zu` 	xA^F;~m4Oa X S	~Du6nbR	;+|TN;v}O; d\!Y6VRޑ#~ u DFADP!߰l9v|G:mZpZ9F_| ~^&+^& B_F FB2@ѺhT@
"Vt ;tt D$3ff4Whg0
nrẸ0((h7')()V*WV .c ` tN@/@q/V/q/^v/`'f/Uq/>/q/F/nP(@u(};F~±4oᎠZp)parջN@uO6]P+.f455s5'5U6n6.
z7P;>_ u)>~a tV>>c t^>>^ tf-{_薹Wh(%mhA+Aujh\hRZ
j(hahdZ%DDZ"DpC`hZ"Dh^hZ%GGZsz%GGZc%G=GZS!DCC[RZC%DdKay%DKaRFK`Y%GK^Iz%GK^9%GK^)%GK^#K(zt+记mT),^_գ= Ht.- t'0ctF-4tcHt- t4a/Q#Hjh@tNtߐY/ZD[@U\*׊` uPq^*}HWvzPV`\tw 'P'&Cp!/Uq/d1q/d12d12ed1r3n/hnRT@5fj j PV)ЦWVhàkV3j h.	diD XHtHt}#1mh !]o o o t^ lP	
mF*HtH?tHHt$rQo"otTptpt/ $qPr&&G< yjhr	G+Pr0
G>aCby@0zXqz ^0GPՋv&ƀ 0_~Rrjp(6 0fPqz3}>} F~~|@B Bx]~}v7@b	&8 tB\|9GPu=  >`5챃9`uӾf   ^f~ t  ~|֊Fm	KA-~	@C m	1$	"^ 	ƐGta"^03&~/t3&  v&o8 u慕*C;^|ӓ-
aF;`pnb1p^ ? tvN~@"vPa֡*׃~ u	nbDFG&9 uԉ~p.~F=/5 X=a 9-
 -"0 -0NR ;uP< tIh@ts0t[1WV-
tL=XJ-&C- 	tI- - PX- tNaIj*q p""~D@_F	P.0pt"  `uNj @hiêЕ Үղ u
$N3~* ^
}ފ}&8u	F;|@- 	6 P(
@7ߋj@.07
-
N_$! *	8fuY_b؋tP3Z&GF |F@FP
t- f3 fU _f0@_h 7c`j h4[?h[0DB
þ ѐ3y[F&*Ht&= t	N_@ &N_|Hɀ   D
4 O@tL^u	 h0h0
h HuO_tA.	 &	h !"w	Ɛ
5Ώ :PP`1.	 	@
@ Dt5	@5ΉӀ&	f2&?O_aca-"  Z/F@z0D>0
#1Dī[PWe4.W6FZ^0[^p4 DV&V1W,W3FW
zQXa4!
p\o4h?z_j  j X^
P
PP[fsVbbcW|S¿Z [R4N_ t&
d w
%p\U\!)Z
若|7 E70 a:B
豓`xQq`j 螬PED\B )H:H GZ%  PɐRܔ
/
 $*b`T
0`^bzB&ZRT
X@%`iVHv*=	O{Ч0Fp_|- 9t7-
j= Mt%
- KtѩV-Mt8|P1@apsHt,HtEHtXHtc* ,20&Z
?1r $ !r!rՐ0,2A0##g hpu-߿ hhAh  )S,#)~2Փ!yt҄% pb=p,# l
-cZN_xc Vfh?h p\pat&r
@)dr+
@a2zS2o2z332S22332S2233 2S22
@N_Zp
 {`c
rt%p\0g#V0-+tPt#'WKt
- tЩuA!#`@'c/05
Ӻ$%٣ %+F&Ð93Pf0 ]0
CBpzÓ + k!Gb   gL̫  Ht飭 #!@#њ&"@#S0((2ɔh
h/ 2pcDu US T;t&ZSC,!
S.X6/18=
;;"T[ߠ[v[ǁT[5=[:qz^/ b'] `ME` @bd[T0 `E`bbQC[ `E`bb"[ `bz^U bb[_QE`@bbêC_0E`bbk_B`Uj^k_UV`k	_сpV[t&88pfpPMk  `pu2P\dUiMlXtLFX&0=	 &. (6Dp~^Q^1!`!!b!"d$U[P$ &T[鱯C`#f!^r  !r@ !rv׃umtfQ_T[ 2O 1C<&U[5ѐpp1r"AuGU0/fT[f^/Wfhq  0p0Ѻӑ2f^fT[&/^s0s
@t T02ՔaՔa Õ  atR@31 (t(@at% = $ 
qu
0@-8nu5u,Tu#uuuD2 0^>rh_CvVh WV]p"0Z[HtHt$Ht-LX^+`!brd
rf=Z
7߷aa^ l5f܀*~G0n*ݯG*`ݍGpְ> 0$f+fFpFF}FFF ^~hD>== 0I ߄ -` -tRv   - -*t:-` ߐ=p>+- HvM PM-KLPMt}LxHt/Ht:H?61(ɰ!ɀ"Fr`#21@3-p蓩WvFtm)
hOVN@a{h\j! (F*HF=~4 fP0 fF\^vfvvFPvҮF +u63F΃~%v\ :uFsG;F Pa^`~ t
&H&(WH@-(~ ѯ& 080p 08 t&@PX׃@PX@,"Ht)3Ãr`br颬rfQWVS&0=R p3v Q~P1`X[0d^[~ޔ9FhA1\QSR
X[`a^3ph T",-9t- 	t _& 
`ӻfjF00P1S7IA1u.(uh TƐ>[ tu}a^fh  @W$F2-ӹ 8 >~Ӡq2 h=h>RH. ThzՍFQ
3[,\& ~(1F |X0HQ >[ ubu>>`t(QЧ?6Z[賹 T 5 ?c;SQ te3.\"
>^bu	>@ qjڢ<tb got'{^6"s
P1@^q2 $Su$*UtLfh d$ia^*~ Ȓ((^)RZ(\_*\,\}.p-.\`^Pv.р& ,_hϿ3Z!-H
a-Nb%.`.r2b/,4-6`-Vp4C.b.5)[c/,-1-1.9%6-7c%.f.c<r/dъrjXw Dt,-
t%-.t,-	 tE-
tYptL- t/LC D`NZ[:~ 轍tC}ВTD  oEa[QV`t`uD&0A}``tHwu
S&0⺐sQJ`J3KRKSL@J3KRzKzSL J3K Rr~Kr@r@uty w;>}@T@T`Ԛr/thRG` (tXҋ6PR&HtHtPE'0Qp^҉0XZVocWusR^p֍FV^tF T&u	Q*=>?@ACCВDEE>uh h>[hh2kkjh.
LG_@tbO`op3҉65 w@;R}F.
r݋Ffh:mj:[kJLke]p*<6Pf
~B apv3ɉNv~FV
tut9v~O 
|܉~*䠾f0\^^3
GF&F	{1|u^*ۍF؊F% Fn|vBĉFVy	NJ𬐅;33V~"ЂІ9tG;|	FCċFrBF 0~ы3$7uG}4t%i67%̍|x yf<\fffpa&*`t
$7@<\ t&^
L^
$ sP#T@J
|Й m@ п`^3n
~n
tF^&ߊFu	Ԗl0c$p[FPЙVEP"pnGUrq^yy=0=	-tX-  - 9@V = M -ڐAt!1e_|-Aŭ cC= Y.HbreϰA<\<\+1p1>\0- 2&=\% aಳ   3Őj& jho@
at麆߳ ꣯Peü?0a uj{ї3n
^'G0b`؎x#"\ѧxcF_0\b<\\$@aV
&f
cV
^f
@yS@϶D
bTz sb\ς!|bL
l fh
hl`UrήUh
>hauP
5  O hE蠍&F<tFТ
h~"0
 wF ۤˍFC|gFmy٠0GzVNF $:Fvm
 pu($
F&N
Ճ{Q*@\ /I0@\'B\q$ mR#Й$ꤰ0
 @a"$ꀚ𖒯 ЙU$+${DĊЙ$Uj	h!Й۪U+h&ЙձWB jЙ5	˝ Q[
QBQ=TRm
*L+		
QxbA,L,"-
0
- Kt 1e@ }W<L\l²{`,2r!@pB\!r z!r !r !^r0 !r@ @- 2&A띐"^ ( "d"@T#ĀD#q-  3+-@%s&u%s&Ω%]s& 븩%s&@jh"PPp,s;R w  !%(0:Nޢ$1'ď06b B^IGcFf^f@!,_0K0@jtj 868`J,_t&H6JH8!9`t9`8-9t93;!9t98J!9ht9h3;>t9U3;!9t93;t& ɽ6
7?@^Z36@t&pfhjAkh-nLp8@]xt9x@;E.N>vfhӆhE
FIAEV!tfh$"#h!0M΀MM^Iθ N&IAN6I)'(h&蜦MfIΊN~RxNRfNzI,A+TNRBNh0^ >
o &ң6ұ8 9 o&2FS[p7Cƀ&t9@v@ut裷`Ƿ;>0raarhLh1Y? prpvF\BZ& *F\Pea u$ v1 j hrh>0Yag3  t~@ &` .27  ` rj 6F\z@fu.&@B_jRl`l&&am.Rl`jg0wÀhF lrc qcv G Dt,-
t%-.t,-	 tE-
tY- Ht- t/`C D|`e:>`~SZtw}<`Zx  byPcb04AVf0lvfhI
 20ru 4h `؋F&?:tF&<:uFF
*0N&$0
ugLghA F ~ uF	 F
  
p
<  |v`}0jj ^߉P 1RPִ0|p0~p &~ tgh0vAf~ tD?py=踩=u5|  ^3? FPPp
F9Fr| փ1F-
 ؋`dv v spd ƨu= w!ɐ $0~ Pp kaÉѳQ-z~ tp@gF a  Rp Fe :e {.e "e e 
e!`
~dz0t| 躂ёrۋCS3^~ Vq .t}CAu^GCQuK  KP.wMI Nr ~uh( W ï I߸ (Pk~ޡFVAF^ =uσF fN²' cЂw]ÐWV`$ < uPFH@@<@uPj_Hf`a6bXrR h hRrct1x60sH fI x%Asurs4t-t6AuUuW6xivuv94DwH\6Ex qw69 .py"w<z$ǁpxa4HYF PgcPg&7 F*pyHt
x$ugh$v j蟕 d@uf4赯l_;F~1ѧЀ*rջN@uOPhth$E@WV3Ԁ0W2Ճ
G~Ѐr }+phqېpO&ٿ    : MHzKB SIMPLO  MOTOROLA  HP  1.11!drivelock Computer Setup  <F1=Help> File  System Information  Display ssiSave to floppyDconfigur2 diskette Restore fromH'defaults  IgnBhanges and exit E s withou>avingT Securit0Administ or password9 Pe aPower-Onw'pR`Device $'d<eD'$2D1Lvs martCard_pBIOSv supports Embedded$&		e]
etac p s Tools Ba>Calib% thqlectz	b HDDlf-T opAs Activ@ OStatu d sAdvancueLuag1v l5Dem Q of gray	fie?ld Boob$!Presy keyue F10=, ESC=Cl R% %&Accep%=wYes#)No !&, A0$orQ$=M  *e&  UsarrowQ$po highlp/
he approprimenu i1p#<ENTER> begCin!.-?follow!.е 0`: -> PSPACE? = Nexz@-A8BACK8#vioV9TAB8cSHIFT+<;= `%8(V< &8c&A( E.r Thiscannbd An e1E oc rF	whF .E~de 0x0-T ,e En21entEpCQKrequi@HIa 3d6!ba.muFmovٰFe>@ k/MEUNiD@QG1 lqGHI2KDiDcple!su(ssfulVManyu1r  NR:Qd&Pro\Ptyp0_spe`tepp9Cacize (?L1/L2)0c ROM R0sRdfamiVdboa;Be^{se0l nu0	P^Video'g 'Keyf$rp5verBeDP\h
lId@1Lh2oR3p4LhH0 Xkh^_um_wxlefFy@^
lr //|{v
a9^wownkhip
(<($dcngp3?st7w XxO{}ߏm`XddaNUBSN)<$ I1J2J3&IMEJCJVKKK4XTVJ:D;;/:S迳;tFWar
n : E`0\`ll0 o$0 13;$Lsq6mT$rea ai/@,`le!QinPht0w@ab!" A: VW waqKt0t a^@@rrRBInv0	}愷PiteAyouTwaLto  #һt?-  i_qI  P q r1 (Quickcr2 (arehens@3 (S.M.A.R.T.) Esti 	exCimPc): 30 3`0g#.F&<0%\\ep	pp1y hao@Vup"4"E:QC'tTݲf-QߦUnknL il6WrȞServRceaNdo F&!rib: 8JIexe1  b Al.  OYl`^ewV`hfy n@E}nOff OPT2* @* PE=WroPl6L K\SQPNhdAd W6EN2_ L3cp als03L
SmartCj51  3if12;ly =$]1dS# 3loss `YhouQLn`!3!Qo7f aaSgo ˰05` "evLsEDois9h$ed?! power-'D#LPBlank P aBP
 `$f1m0 tv SAl
ѸvPis cN4POn1
 s. FT
 W34&)
 ndPk asfunu.ЕrhaPfraW.Para0k.%Qs }S@lot MiP.&2 Fn+F2 WNl!net P3 0t@TCD-eR06 b ؑjJ8Y8384b_t&]  pUPhi=Q@/ aGbouеph8 u*Bq)* botUSE=R MASTD&)ct,ѻ@pPUa!nP`-dcq,E`5 keep ia#{oc>TphysiS`sep/,R  !\r. I brCqDJ,»E0Xn be  !unMG A
EDpA 0meh,@P D&0pibty. I
frdoTЄAq,ѻESC! . 4s[A typC"'A'  +MѻF10aAde`"rmp=T@
XYH&jQEngl6"2nn Oer,:oay@
p ({0r|sR~) USBvvc6#w8rvSu`HxZ`#AFirX㕠hi@F,th@if |Si9x|bh E0|N@ha}Num st6 SwapP3/Ct;rl! s KD A#nU.Sp"2`p@Adrvlegac0NC肰pYlsro 0rIn.0<Ж V`%o ? oNTSC <AL2-J-M/19t ҁBid4&al EPP ECP [1size 32 MB 64A3-  Q%oPn Alway>n whi`ݓACc'_p2yAg Hag Znpp9ϔts q)sCtom
qE +rP4{`923{TokR u5p95u50;Unique7 IdPifM<eBe@?   tu/ QSC-ϯ0CbN(pﴷNPs<HoPD sϼOobmo/OÂBʊ@&(H  `|oOȧ/zL@t MEU/ڀOاځR !v^/ߧ[pK1 : CVgP% ]4m/C0Ple8$!2py0B y f$3I<g*yV /$ޏy1<`s*~0[l  SppB `@hnology Au @McwvLFreSƇu5adap1=7oPXE RPL ExcfoPopup De( P0 _10  2p
3p
U4p
5p
6p
7p
g F12j5 15
3"BCgouchpaPSPNon8<F1=Hilfe> i4in&cZ0fo'gzei@$`ufx*jpeic1 [ KZguarV &wie,(0  0nv.einu1$ J-Ck>,#ignorieDp,-dT,J'nwt 0[neh𗀲(h'(,5-Set@-Sheitsfunk4;AdistN5enn0jt213 u%b(}nlt-K354 GerteM09-8C-IDбG<-8AX6>N;tCQxb6rwчstt}z # fr BBIOSW6Bi<8gQ(N0/H1vorrA* #I:E"!#zurckWzAEx2бAkkuk`(KKQtsgewhlt`aQDD-Selbsqs04PQtivc( ! T1pQqZPSsdSSpZPrw01RSpra\aSS1n9`3BZgran Feldsrt-OUk`/8A9UKc=0PYili{nejlieb!_Ti, ~ Cfah5 =A], ESC=AbbhAAiW2\jBikzeUq(jPiJamN" m, yJP-g=MehPm Ve\1)f=z~MarkwVs`j1SMenU dfPfei#ltgm(d8faw 7gabew"hm IVVaO(:.sfol #pqn tc(fE|:-> 
r LeHx = NchA7"t<-R1Pchritt-qpVo&!_/Tabul2vs_ H-olls+ogeBvo!= h'*2EscLvh'lb>i=rR[ kan*Qt we OeiVRDp2f_^rgetrn.Zc
 0PAV@'(fi0)tM ^ kљCTFPDawϘfWsel2omvorg&Der  !lRQ]VDeskpU-2\s""Mmu P\@wasSbz{w.byMobi ڴ_gtz.0wRD0K ti) IOo2hRѤX1lgrq ab`chlos֥0C%-lulQztyp@NrbJRwig$0ISaҷKC\- -Gre (L1/L2
kapazit OM-RpsArFamEi@q ŽV%ppf@a@ 3umm G% GrafikȷsdsXr-Con@<ߣ@h?W1 2_ 3 	4-CT1ooȏblink /OԻvG}#%0!@PsiP2ܸ(F@aP #1 :a?͟ /_
@?_۟ٿogj~a4k(r䕈P`P*:P  stBzn bis3G n  6 Y@hE0Ѥ-/aWJDle!#atb@f2* eAiCCPJf  Lk A:VnfdB7l$*gep1A)KfPCglHe 3 L   
mN1M!fwirkby$D]&?/.Sf9, daf(qie1#oay&-T  TW 1 (@npOb$2 (UmfadGArifh¤dau G(Min.): 30UQdcS't .0%-!b$xD$wu< O m Ho`pUp5$-uqCbrpjB: H)hH*<ė1UnbeaG311rvo-5Lp>)Q.ೖ0CI3hafъAttribupID4m5Cuj Y.M.A.R.T.&>l1^j .#C A[ysFE NeuCD+s@ Dea4V^wG Yy JaDo@F-}t Fal1E2gebUE EFuVd|x	 dmin	{oMI Dur GGRu>S )  a@byd|'Ho]A'P_fG.X#@<f0SmaCErxoYZ> , sofQt0 fG wam.s Zu1fAv&`]*te}nlust.qb s!n?@Llbsviceas 0,csCtF`д hyd SgaB]g g PtfaE-c|pc^s k QuickoLock1jSundap `rre!MQ3t! ,` G񡱿_`bit qn|!chutzf] Fr]2 ^0?WPE.lsbE!:6n, l ӝ]<2mehr!nl$S  wInfйot-܊ParjeNDrahtNPxe "k" m CD-gFA&1stQ10	2ߘ03?0 srqQr^:nޓ!mBriveRwb` 1@dnl@vs -sls mS0unbrYbar. DeIPGJ,!bewrms a :Sb,Kt nnR𪠈Ae[ Fm, 2v4,  00b隣zuPqyn
Qz0h[&-P0GeiraPlw`+de0BtQantAEٰ'$3WVdda1  Esc-BfG& +²MviW
QF'&'Q@1_C F10[ERx:ݝOf.gg4dO7c#QD `1r iP1,MuBayܘfԏ (bs (`USB
ra-;rrSuarZip 1[2[3[4[5[6[7[8[9[QNum-FunpGons-et z?Bq4n/Strgs!nt3B1x|UEngli`%SAq@fP-{Zeger}Biebss2unabhngܚ\wGrafik-ContrQ0:I<!? Prim2:!aVideo-p'o7@nDxBidireal GrÔ0 0s =g  L=!jm? ,Rb e2\`Sg -ss@ Eg Rparks0G_ڕf(on)_ 0<hEt!@0?/tp,	8To1R`zO o
	_Jص OԙaHZAIti`aR0q]ovGku+O *!  "#%%ea( Kalibv0='+!M!Ok)Ϗ*/!	NB<bheQB1/pmDual3/)aE 27,-6_;1+2 f?45>C89 B_G=d:O@(:J>KOD9M>KHTra@riff- ?)UYOO-X]S#2L0EobiORK)`aUKO[c.d/eUKHR ܏hi)l/mg@fϏopT[Qr  1 : La!.x "% ]aүwab  8z20xEntlqx xw	}xy~{8z3} sSx}x/
*`W {{ aE.:\?htxsProzor- utom  Legacy-ffRadapaAABootmPz`AExpq-A-Popup (.w) Wadau@RF12 (
aZ`u P󰫠ސ"Compropstn <F1=Hjlp>  Fѓ.oplysQVisxc(ne G'til q/konfr"rʨGpfraMZի r4@gnorndr =o`fslu`,Q u2t0ȠȷrϳtneWjkhed AdministoradskoТ K$P aAg fo(g`XE" d
e{ć.-iLcyP
=Sm`CB`- 0w lsf  BIOSY	W[a`r ?ԁ2
5idlsfa *ksl BPڢrЀ)d valgpbSP2HDD-selv4Ј5t@r oߋD܂R"2? Avanc Sprog Vlr!sPmon@ނnedt t fel5OJˀPT/^Tryk p  tas P@t ap=, ESC=AnnulāFcGoudd?=JaNej , A1w=M Brug pГ"e~  rele羰menup,Qt<ENTE'R> e!qet.f  0wA~: -> e! MELLEMRUM = N`!z<-TILOBAGErQ\	j^TABB!KIFT+
u{!q= Acce l^>sfejl&!kr scodQen. F01no!@pla@2krvvek0i da0峪sr fly s0zèn<c/MEU2 b@ uvez tbrud5+2T&vpmf\B8'2`duc'Qctyp0higA0@tr cache (L1/L2<P*4huko  ROM-fam/iliek`!fڡF i#%Vo8ќs!Qpr-contruo"DS"-ba |	s:=d&z:@2?A3B4j
:H wlet> FF"=H/?>'p1/I>hjMzGat-taPFFejR^(Rat)@7RBU3 V0E7R/F7RH)[J Z?L\M/]Oa>8Rå sdwvar: DwA s0У  alti 2	hold!0!o  Q/P#Sb-R#dd4Q,r =k1besk#  "r'A:䗣՗Tss'f*(A'(s֗qpUgyldignRᛑtm  w`nGgiv@u2 ,oviha?? iSK?궍 TA(Hurr2)3Omf:)Psl@ ( ): 30@R 1 .~60% fr {$ud.2U'PRR0ǉT(ȓa: KlBrU!cS2rerv";TLsXribut: ID/)C=BS.M.A.R.T.@
`(y.kYѻNyڣ Be@fwt nDeasU Fra0l  hkev@@0(iѫC#sh Ŧ&ﾤ Z	&i0٭ɱs d5gs@#rp.*Lp@vа> hvPh EtUiÁmectablata. D/u bP*u$4!x@$fl0m/vicehDmЁ nİoV YѪÌ΂%  QuickLP""pau07Lsv<m`v`uSNdԵhb1ut ЌΡ8Ҡ . EHuGm Р
n07),diо28p(ges.pg Ql p`|frard#tdl k@-nappOC?d-rom- %G c34$oH nS 1@U2314r!7Ho`8%:eysuqyaը rhT,Ar3r DArQ bBRUGER- HOVEDADGANGSKODEN,pr alQgC n dQ  opbeAQ/ƾed oT#;8s l4[P GOu4V@uPa peb!(n.A EG,B# tryPR @+mE eC#n2r orv 'VS' pe0	rF10V8	0
4#ӫ0-D 6sr4#T0-ѐDk Osrflg9=MultiBay (4M) 5!O) USB-floppynA$c@$2$supqe`A$zipF`n0eKdjp|FSF Ț 8j#oSy!O NQT-Num Q-PB\iЯ 7 Fn/CtrlѡcEZl(aGi sk5F= eg'eenP LU&uPnPe31m=e|6 Primqg9Video Out Para. TjStr0@v:huk9o Bl0`0!d t snr compubkL=ekhf`MmR!2-{ Ud>pBsty_c!topP3OFq!bg&"FEth1pGJOKP	HTo R iKOLONKpSLSPEnt$gt id-nu rH cZI[	S\^/_
`fO[cKalibϐzOaecind!,d?jj!8 i.P `!"i f8dm?roKh/qvokl!bu?{cy ~|Kho}wlS"ion?op?tߊlHagsώߓd OKh?/lV!Vi mobuD Q(MEU)dϠKh /Og#ߦ 0ߪLO#m[in 1 : Opla .C\% ]. nempt2Afҷx5_3Geno÷3 *9  O}qΕ_W̶ProcessorX Autompa'iBba@  Legacy-free.!=mA8ۡ|HurtiArtpopupsink(sek.Q3x`@P2au-30*b!gge P3p p  Konfiguqd datamas  <F1=Hjelp>6iliin`@jon:7 om s2iL#ag6xkT	He0fra 6*/PE. diA *Bk@1r_avsluA"h,s
lsprogra/$t Ad ratorpaQIaLOpVAtP/,UyrsdI sfunkĲu 6tif2GWp-UTG/n Sm`C@=& BIOS6/Ipby @EO!4|idTilbakuelfab2!Prkty &d !Evaclg
AlA8`p0
 Bvt Akp5@Qus
/Qv3eSprkPlg  $ Dem 
%fPdtel 9vz(u (5|MTrykk 11

 =A$, ESC?=Avbryd0(R0O1ABp@82{Ja4Nei c1Ʋ, /er=Mpi1  8kvY-nepil7ne t.<ENTER> hv^du v J-t. Bruk10;<వ'>:  -> e r MELLOMR?OM = NE <-BTILBAKECrsig^DTABC|'[HIFT+HFI[= Go P8G`1cF{Gsfe!=FQ unQkG$Pnop!p p? MRm kjresfTvemWEdRBWp`#baVfly"sC B@3 ]Z
R;a1apB]vfullR1. bk?ode 02P6b^Q dut No`blok7k-mdllN`typ hh/igRh-ga0vTbuff~@(L1/L2pMengdP;B-0gUe.deofoT/`!r troCuoS:p,kobZb	u,os1 _wi 2xҚ3T/zҚ4{h2k
tng{t
t0Z}y)uf` did E Ѱ
G("0 phxzo{ϐ }h~oI//J__ootEkAd b:c DCUhsl?r tidlFhol:UHhG@! /hoe-  D, b02!u1/D sklbkPCn1n`ؒA:ҢQ׫ b0re!g#6i5ثUgyldigTESBaIƧ(^E!h'TAtbƶ,?/ 8¨ T& ignosAtee? + H^}T 1 (RP)slp bj (): 303Tgr .VL0%8bFbs	tpAvWa˞b: Kautb@Ukj(QSeQ :`soxLestт R
SrXTrib`: IDC01RRsV S.M.A.R.T.-VAq1 m.  GpUN[kreft[ nAv go06PcAfa@b`
kVv0likt ݡDuVp@/!
)>$a¨O ds s0!rm0p;f
s1!o
   #@wSD ʘeo27p&in 0@\Zk. bakuP/  Xm A
BX#vice.@qS
R lq@
&0?-*>)llsDllcanKrXpa`g>phus L[tr!m!X)#- gir b=eQ7besk[Al &E-"/0Ue[. ĥ  rBgle!qD?wr p`: a0E\ptp00frard-ParaPllKAqTrOdl @'tPk KnapptS1*   CD-C2RN HoXT:>eBhbvalgt/1/P$ :hxB  bdBRUKERRHOVED-Twl@Rumu$bQ] d%`d[*A;@beb Uj ;$0D +A`#2P   0 mו-va&)f,R ike lÜ/R[ e @8-0!}7.vԫ spl< a&flZ b.ť0AE?, 1DPO-A
H6 D0EA㑽2 4'D>ALock'=ELeF.iJb3e::"F@gORNor0&lF4]OUreB MultiBaAyZוC\ÏVnU()ϝmYZ0USBԫ^ex!^%^ ZipkA Aa oum JqatBЩFn/CtrldFegREl><(USA)SPekeen`0!#Fel! ^gs	roseQ>jsqP[	RpTP";isrrA!HCj0f Cj@iPN  V¤QQ0mU2c~XAg ss/sst	y[1OX&tx<y\ (v\Ub/|A}@/} Eth`Əzx5Haz53ooR
[_[?bsj/O?]ni0X -tifipbB`dc į(Ϛ@y@2m$ libRݠABADܣIE0pl aal PV-Oޞo) //[0~O)oOo ksp.!}ޞ️)pBnd@ ?¿Ͽq3Z mob.  ps޾8o/ \ч9Ŀ++?[ Tz
n: La39.
И% ]!R
ޏfullR2 vAmݩ
e3v@ igjenon?Qx*fͱ
  ZO׫ProsvAuu1( z^/uAYUfwtCi Cnd .T2 irk T	FRinkoM&E (se3gKaF1#2-M6."#gSwepute PhppConfiguracim3 l@omadora <F1=Ayuda>~ 
rchivoworml SmapmrksT	Gu .1%`^co flexib >c%	| R=a` s@o@m'
$o pr-finidoPo/"Ȱpad`  Ign
ambios y s͠qL
 ' gu
 W
bePidad	seSadp7r 
y#AJ$J#icio%'"`^OposiQ(s+
3,IcE) f/G# G	vJ{0qs%33 Sm0	Cpong0n5 BIOS8)O:|u8+incorn 0qU./>?,^A" 
cP
+fbrP/ HerramiaPoC8͉`er`0G H@-D(!TK+Autoprueba HDD!cQ%KLE  2IP	O?J!BAvanz\ dioSJ 
tTDem	C")Vnamp@co gr@oM(b5o_YM+GZ\Oprim90quiPtec9in =T, ESC=Cancelb!3bd=Acsep e=SsgqN(1d, CFa9o!Qa=MId
 B Uq5a86chbhaEal   aQlemo apro[piOl  p pL`<INTRO> 9 pz%XE1.q[n.ls@aGPdm9< 9[:PEspo o -> = Prx`!Retro7ces!y<-yai$TABySuWAИMa/ys+S~CX} 0yg0d8dErrWH oQ Q.DHS`9rjo u`AE>G. Cd@01Bhay n unGRubT/" p{iCAs9kVbplpH+acopRGniIebook/MEU/`"Gq
qmat`"߉12plOGsple~@Qxitosa!pe FaFᢰ	 O!9til Ti3Xpp{$Vc*-lG@'uȥ_TamaOm0Vr0`/h (LO1/L2pϩiRDvisROM mil0fd+DrqEN0Ƥ@ri9l Iv`1(V r"l
a TO/EAF"n')R1R2R3R4<Canij2(I )RM//OizraB˿QruEtiqqupurs\Ԓpe-zȁ
(bap _3 P_? /˯OJS/g/On (TP
sn !h @FAdten :xQ9T{dQuirPQ  %e&3!. P9re%=/&, in xьscri2u-A:;OU@-np@aaQl53 Qteg%3vlusa	np<I<	X̭gvaXre@OC-o(a) 0 ea`owlEa?@Tgn?g i!l քq@oir g/$A%MLPL1 (Rpz-)U)2 (Cf*3 (S.M.A.R.T.) Clcu#tiMe$XejF( ~Ns): 30J(t pg oo .ց0%F)b`GF)9 ?@?ipalU)iArum!*?5R6: C
puc.aN`OS9Fal P pE;D9ServofA< tapoya8L!=atri=bN: IDya
apQx@GaU'uBs g,M4.CG1^PWsea!^TGnuevTif``ID0oSM`l$LApagTEdn
dS`l74
ѢJGepavoAc4
IpQa0s/JP LcbHCad 0Pe^r!#bPoet }i1inhabppoVW, tnZ0b"Ҧ Ai0F]^oPvGs  	SmartC, aKsso_1`,w  Qlty A`Y#[C&Ѧ0;!PciCRΰ /BfB 8pR^prM2sin2 S"Sflq3a  olQ`Jdrv5kvi y.1o_n{o  K3ې? OZonaXU6|&asYy[Zau  QuickLockSuspe=n Blo0P!$$ratp D}Sn_eZ	[ef`6n Rmej0! a '7c}yo\. Zrsrtc(c,po5d0u izQ1FuP`a orojoXlp@S|mRedZoalmmBocΰI}CD-򭧖mE<	$@6d0/P@P/P0PvjRP6:G0Usio:AXuDkPT  mediAbDrive~̇`DkUSUARIOdPRINCIPAL`h0?P I9Xc1hp   7. An[ y guᠠp3@lugpP!c"   0Tjh|mp:WW. E`tlr Pӯ|,x:9X bcЀvGfiocdeĲgi3pJ1pons[@.qZLj, PAgR? ESC. K ,ala5b@h'' PmF100Fb ,b:U6SYf PW!4 Vh0̓Svh041Espaol O"}Mu`gBaaPꯟ|ۿPk(V) ()~ܖUSB`RR#3"!i i	 1Suk"$@Zip#搢me_ Terc!C@~SexSppgo OvfNotDjذl o Numm@g CO%s Fn/ĂRTcPIngls (EE.UU,posAi0L !H1lmQg$3XSdbQeQM" d
pH?7r'QAc%|Coreo Mo:Z  Bidi0yp6Tammemix Hd1jti#s-rmuN cu1~CA0FA@BrNbook 2pNEWe0g7os04Bo,
 (	si)
owEthet,&
 
a/JOpJpoTokp3Ringo/HO1?!V"2".V"3 I tRJ.?Exclus@L!>$AH!!PY*1 )%8*C0PH 4O,
*NQXQ[cs.(x/.0o`hy)i2sh2u D-5@6/1K29O4h5s
b`ۭ*7?9;B35$o@HI C;KLG<AJ /@JoRCNUFK5MEU S.[ /VOWO^YZUp2 R]?e_`gcR5[0r1 :frg. oS+% ]@np2`n px`vnm\roosCleteo3 `n@rmwou\yBGq* }fFq }?E;6W_aajha NA i	utomcbl " Lcy LPAe Arranq1p~pҷy DEDD@gL(UEx`(`0PF12%6Ambos TouchMP P@!N qu ðaƀv÷  <F1=Ajuda>	r0Info҇m0so  o@iaBɁmPwUrҲdRrt` Ozpadr Ign  le sairPTҵsНss FD
AnaPne0|a vre %d( %!qDrr Ʊġǳ?@ &hJe S
tndRBIOSgĊňgظaYA7embuti0􏺘8fb0kFePmas0"BAgѝiS $Ӡle"OpuTPϠ(ֆAHoDD Ar ~ Statua0(SQAvSLionxr)Acamp`cinz0س'lizbho?cع\ess0e q6Ʈtinp @=`SC=CancelAceXiimN, Qou<=Mai@q[ Uiz %sڑ ҃dQ@t o ip3 apr#opÌu0я<ENTER> meJ~Po.rgut` r u3::o ->PAO =xi3<-B7ACK CEPjaʐQ6+TABVoTSHIFT+#C ZAa=("캬
+SCR칬ErG``6naЧoSC
Ri. CϢdigҌo 50N`hp<oi@ Lisi=`CA ALOevnsf qR+o notebook/a
HeP~Џm`ڳe
2'ګ
H m gxi`)elҌ=Nt  Ti0 (@µV#c@QЧ% {@{& TaXhcache (L1/L20F)a ma ROM{visFamlԀ~ ,!ψ, Pcⴕgsǂri&f$-o vde0Ver1Aror!!s/Qai56 4ڐq8:0 ::3<94o>Ol _@'ԩ0BC78Ce!bF6OHCir!J6Et)i1bXe@bpG0OCe&f$Y1(E)OP'poV W0 XWP>/[W0@ ]W~A_`KDb cONoOfIJOif Mhm?p6g4Advertn: f%1Pp3 Ae ʡbc`ӑ@c/f,sium դ gravvun&A:4
U~Ss}Aw: n foiЄ PqBzs}psH13~Oؠq%'teg 3a}8U}{vl!͟DGuI|{ k~9TНtezrp}!eja T,?AĐ i?C0. ^fCÚ1 (Rpx ͱ*Қ2 (Ang163 (S.M.A.R.T.2xecuБК3(P.)/: 30akndP.0%ߴb!uced2Ú0E&#hostrom񜘨2
: Iss!~4'FalRh
ermec @u~сs!͚u'tri/fq`DPaB
`exa0! 4s Wb.c igqBovb2if0rP罀aהblTp0LC  1u02Ɓseif@rrqig08'qcis
g t  ve3Ad0/@t3amodBQsD׿4a&}tAtambAw0Ф0cemPCGardP,,p
 vi0A6#sfbrо)us Бpkform.P,  A܃Bv0 ios. 	I(v яܠ8bF? O"c1 RAӒQuickLockP Suspen?so Blop}24PPoupsaS҃Ѡau pb@`v"&  Ϡ3.vC2k%sss 'impu($/. Pp@<}erme1l@	FReQ"KBotCrrIJ!#CD--Gćkr%12?934 PA횡mwe:Լ`usu: VocC  5%І`umw~diutin3rive4G  txxtUSURIO#f  MESTREз!#J  RA`)1C^apazd . An0d}de-@`&isɕkpr0. NPkvGȆ' Z4,
poPB0a.Pz0sbKF f@R.Q2F  Lembre-sIe%vQ a8@
sabS@pPQȴ(,?ssioner? ESC. CzE Qո2̑y\lavA'F'e3#4F10.0e 9Pr:M2C*(ǥؑ!u?gus O@  : MultibaydEBE?sP(uk0oHtIo)7USBbRRNhzipCNPrimeirrcCQQbtT`PmOvPmN:cp y F @aXpvs Fn/CtrlCIngls (E.UV4a i@0si񹈁
 PStPNah `YRo@bɡdeo+^ ^PaAcunddaa`MoHyv\P`ioYc:Taphjmemro^^O_R fuPv:  quR oCAtt%K2aGFG#er0#xgr3@1rnerg0K1 
nmIrKJ`"yJt%vEt\netnfyqOw
Wym{|3}|Token RingO{ o}e|߁y0y_t|Idh p/| Ba`gSta'tus6`S<AC aϒ<Pǜ
ԔgemoΓSD&l1+CQ/r`roDupŔtedߛu SE._H_a@wAI ߝߩӯ_Al>__br$U ?_/'DAM}oɯxﾃ[ Etp 1:rregr.Б% ]CâleP2: Ӈm|F3: Reץl|G*6 E}sC Nme` 
7 Nflexvec P@`scH\ Bapb[_!*gcVRrcPowpup^D Exb3uSegpv;F12݃(`MZ|r^ѣs Var&[a N
uTietokkP tukp <F1=Ohje>d{osRJrj0elmtt Nyt j^ TallenUlevykkee Afkonp/objP 9 gt626o֣Eun	s OhpM muup jPopLBW
tpft7
po
l
pou  urvisu9 nvojan @asa>SMri Kynny6k La<tEli {tuusnuA!t?!6-'#~%t lykli(ti-BIOS7&uki6#b(-g[aetsu`!.B 6#s.u.IEtehdvTyokalu-Ak14 o `i  K5 i1ap5 sKi `vyt>)X-Opt57b5h N :
7!LisgKieliH07wkr?ae@? harmafGrki1hpB ggX-X-oJatkAdin Ajot0I nWpp `q=?, ESC=PerpTJHK=HyvksyM=KyllNEi K, Jok	u5J=>P	KA|@]?nuoliCJmi P7kh, 5 siSsB1I <ENTER>[ mR#tpNeVb`2.en XyYs seuraav`gT: ->i VLINPPIN =[s  <-R]ASKELPALAUT62^Edin50|ARKA;^BPԑVAIHTO+ca4dbё=  DN?gNP^K8i6ްvirhAkkua e6oiǵ5da.g6m: 2m di 01m Ikam74myla0=rtP p+@ytkeUBko0mtaaYmtsi vus.3lakcss1Бsqa]kanPt^laajv us [ikk0:ylBskeyty[i  enqi Y(@6oop2wln)r<B}o1+a.?m!jqIi0/1B? tyyppP6n@/ǆa~ll~!Vlimui (L1/L2PMҊ5  ROM-P m|Êq$otepeRmcEm(usiPsarp"R@:NUstohja+yː?us0nkohLܢv1:<v2ϘҠQ3/Q4Kahv0-q5[	_]./yoiCkeߤ`VTt@+|oci(jHoa)Wƙ_ S߯蝌n} _O_{_?_Je q7kҡr!So@7s:_ TmsaYlP	:at0=nh . JbVt Gluo rz|pR3us-  un,RirjR/!on0yA: Lr3m@m	h^Xu9qar cfуʁ(Xd n paAh#
HkosyiIa1@vQ*nA?9
#! p/   eݸ?7P1 (N2 |3 .M.A.R.{T.PArviQq (min): 307Us7 .fb0%#@IroS"P6IsBtys9i38
$d~7VÀmݥunty spK%Serv?omoott0Luku5mymtu!@:k0-totribti |P^0q BPP[a Ve@Kzs~eXn ..8Tŧ UuAYV   P"9C9'YCO P /mrA݈ 6+L C#a O	-3dPk p$o\n@ڎokkʐa;adan onĐfEmys0= 15/,q$~,Is t`q.aiT30سEO3-0=i\D unn!5(q{y{ve5apahtuam oa0id AaeI-D	+<n QuickLock y h`wlu0B@WER[ @r21|9Y,`YIra E-aW 3ta.pQs#dr{@>2nt, 7pe~u.Pp@Infr/apun?Rpr?HGLan1guBtou&in@  CD-- -l,$р_Fa"ߑ6 17J2J3J423P\jWNAiotEn DeC/(1) -6ell9  _:pPek KYTTJN$ PS``SAN'AN,W= q6a>V(.a)X Ê|@7sily X5tur@lsԧqri@{rzzt	9;V-$,!np؄PpQGXLLA17+QėV'uudaavrRBqrMcuP$ ed R>0@@o9"1s,|^PESC-nP9Ǜqnp<ʡJP'Q'17rs?en F108sJ
vkaa 	j:N p ,g Q RSC}tB順miq6t7ysNiMultiBay7 (qno2) USBEDrEp#rZip?EnsimmsPxyTPx Kolހ/elj0Vi (0Ki@eit@dek 9YBAKym'wNumr~p@1Vai0U Fn_/Ctrl4sm+8/MЁEng. o(USAUs:	sPinlR"md@+ęn $ja/aG Si@]A n2siA s'V (olh0|@t8`Apkio	soSN25\_<\ e`uur2DC@`sռ2-l(1AÜVla_P6Ÿ˃1Ei , Po	V- (ylos!cϲEt'her0`St0n uŽŽY3׈To @g?2ůA<Ȉ0`workqSC 'Od̰/΂̀όyliv'p1 @kkuHWTAi &joUlib ?C}d^^`xPI^Dualp-o	 +"b_ O_O'O_ O+n܏'+ v *? P	'
%``aa0mIk@0 _t
/Oe/ F/O"#/'J$ [ ep:$Pqa@U4.=0% ] P./ C	12R2elP9 pureig.46'0M1/7{313_2iIA .<>%0M1O?h@|3*@E$ AEMrx x@umer0In  SpeedStep  tech@Togy AutoPr0I*yÊ!jgacy FreeS x@]bkkavu`TcYP _ys ^iL @z (@Ver@pS x: XgF12:@vSiP^tapp}igkoskep@ti mmapK<XW  Ei m!n Configurati;ordrteur  <F1=A> FichierPHforpY ]Nv`QmAff^age /_A`Sa{uvPMrder0er disqu=ezbla cz\Kcs RiP8r w P`c'unewc.fdgc(ieal]sj dfaup/i\m du_Ignolmodi`_qu!x]SP`ce lG'in {Pea_89d=rПreg{q
swxst SKcuPGYpejss-d0z]e\lP{~~pt e sousIP}pH7*on.`} priph8c:a s50LPIDpI'+q~sWDrT1;A{Sm kCbPp9 BIOS ?@gre DsPfatf֙Rtabl8@tmjamz`w'usФ Ou`to`qta{ bJerieՠ~ slec\Kn@p_0noP!sphp]ArloإEtaB ɡ`tp]P0 AKcMang~P ChoisC­Ind{`?mps grPO,ptdr`E' Appuyc1htoupoPce0Pu^@U=SVer, ECHAP=Al ӺM2AccepsO0=OuiN} Q|, N'iEmqe`sCԹ=`JqrA^  UQrPOzls fSheamhrtkcle pGuecer@hpO@cbriPP1sWz1c <ENTREE>C2octC8DlsuiKFt  1hC :A-> ou BARRE ESPACE = PAe]-ӄ0IEPprecede>TABCA:MAJ+_ط@Ue{!Ӽߠ[rr] h Il <1ssib-2cch Ua3{s'prod|pendPѐt. Co'01``ucFn`OÅ1 emplaceGYL'D!e Q䁥re psͩ䐭7s"d'accueil dpF  hitxbiQ )tep$spYuOo2 Sa ru +FacMP Typcep]Vr )D3bTaca(L1/L?2) VolGmoiVer.bROMPmB	ARevPi k~`Numrox)F
vid0H	ramatcGlav^`o@!D]A@0
p 
3\4/\amov 1_ z%&Mga()#8DAbinv8Bpri 
1tr(te)0 57?:?< _!t">#oA-' ODoE+#,GHoB/D/LBV`QeedOe tp! : CR0e0mtrum@ie `bc`Pb gXb /atg, trƋknpr5orʂc ~U3tAa$`efLvX` !^t;ro v Pa'Z@_`cZvXT^ QOZo[0!^vƇn!a!2tg.0\Ri 
ke:f  3@lfes-vA02ulp  [@^t ? Igno7IizP~y EnregA{e?~|} T1 (rap)2 (c]oet)@iu 0lim^(@)T30c`s .v0% 6	vr" tl'h a"Н0$:Æ!'Ƨc nuΑd'hvmriLg supSppdAibxyQ: ID4!$ex@ӯPs S.M.A.R.TAbanW .c AV2`s`,da,i Vfrn?1isasAA MarA,  nSY Pam!}AeXݰђcQ/rmme, avKJad@QPpbobligatr#ө%S!dμ; մ'	s@_N@ϵiVŘS@MtCjXu   si0pʃf pӤesr20ETAamptala p TSOfor\Q{. Nuz4Ѥ0 u avPoou0vq:pAsdrST 4UƳYǐ
Azu@}O2ɡCdx#`W qsv4 QuickLock1sus! d@	M`t1}Swri`3Sq/РUhQreQc^Ҁ)<;. L'A̐Pg `dra˔ Ñ°P"-@rap dll$bd Rss~qrfil Bop EMCD-
X]E6_aci p 0 J2Vpal`J Bұ:@t2ѣgY`Z 0Dr 1. Sɣʂdez Vdeux(UTILISATEUR1}PRINCIPAL),  #g0alorsc   Nz@d1}PS`1qrp豭sṟ fe`rceluR c$
ordinCu1. AuPv(
Aq鐀 `ӲMetӲ 9+"Ԅ1PpfQP{: t S@as4[p`{abn  updӷbf, appuyPo    ECHAP. "Y&p&pv1z'~f', puic'r'T(F10TapPox,Rxrm`"3+@e1& !Franaa-O0idfmMultiBay@jC|C9:L(JO=o>?N) U9nAߪdUSB
bDDZipDPremТ DiRRTNsBIQuaQRCinp}QRSwixi  Se0K H}CLNeuevCIDKQRModA num`"8ermS(s F_n/Ctr0C#= 7Angl7SA) PphH஀noQm:Ѕs AlncechnATDfcadL elԧtrt0?f@h)UԿX`۲n`rGimaKd\:ivid0bNTBidAX<P/ mme^RQ`Is^Vq lñ jPlrPP!R 4 Yruf:2Abloc-nGa1qYAaVeo@:1hkoh/n:(И!u{r)Accue!pqOrgsBh EthQ\t]sx xyozyp-|Tok Ring /z~{~}`0uupIdq Ajb6uVeve0a7ߋe  oFU鏓\El XnQۃreK?Abs1`5A!FtDu:/ʕ?_ߘߢr:b ?_ 
/ϳoTgn /?ÌO_e ?CexD$ _?_g ACү׏/[pe _1 : Cg.p7% ]A7pP5g2DsgG
*3R@VK)N* ۴  _} ]Ư_xNumro"roceP Auto`D;D4_r;^libLegacy Amor19c #p#Ӈ%\^  Retard"? exp#@SP!) DS.Fs12;posWfTiE+ux
 Pa0etd"` !|TAcun I "@VzX_l!aP <F1=Aip>@nfoW!Vemal:puwVSalva%l ?floppy@U2D!0D @ttoVRipftina ddOq4ifa:|iCSUIOgnor3d(ed escis E@ al'izPp89Oi$ Pftupv ]ic2zzaP	sswoe aym0Vrato]Z3()g(pecc*5,-'!Dvo;.s0sV1<pKr IDs8*pyT4W(DriveLock*.@_6f(S`?tC ]upo*: BIOS7=:0!\g)a
vPi2@1A) \i8]tr]uei Cebb3aH1HPfleQa@OpSFQ-`
wt"o rig[id^Atea(L$tMSeQlJ^) lob
PJ WAva"t^LuJTDim2QRVA-ca 5mo\ e@c"bXg!M^KvvZG*o^ZK3j=\3Premi qwsia`etas;erA u"  =U, ESC=Annu@Rc@*bc!cA-te.c=SiSgNPTd: ,aalt@a=Aj2iUd
 U}s%chiav/? freccJ!bYib@vA-u ap@K "`<INVIO> #b n  X"'\e.lpAeguaF3bEs  uns:p -> o SPAZIoO = su-{ssM  <-woBACK xCExc`rxTABҀxC"Xyo|MAIUSC+}(|x= f"|dcdErr)WGHO  QuLhRn 7pu  se  D~BSi  v`QuXN8H. Cpo'/01 Nu@RaXa ogwgiao L0O0m`@0HwWre|@4PsWa'ggarQvp&@  n`LbGookw1bA-espa-!b싘 *9Hroq!qatQG߉:q2O,*Hriu@ p@JVProdu *p NT  TiB)VeloiStesppTiMis*caQ&(L1/L2me PR Y#ROM FamiglJd2t eAt(Yor#abroll0b#Pruer?pNORI1/R2oR3/R4ￆRhand㇤nóRųR)oȗd L3[0,0OЩl*cpep|
|(eb)1ȻՒ)234 Tևo) )ʷ /Hl$1FfOondaAIFtA\so:u1~Ggger W pb pu5|@	1bcre"R"/rN, in  !bfavхPp91i A:YURA:Q]a1ono@ uB# IBat t+ N
v0Hd xI Oay ESetABAvo"a _u?q# ґCK i"pqre?_%*_" AOLOTL1 (RappO)32 (Complet~tio (>+): 30Xc o .|0%1r1TBT$ar@3`'h0W 3(49#:Es tQ+%Ta O  i%pA)P 
v`1Ӧ) L4!sS;I'Mribl i"gol g:4xanade  Rr1i S.M.?A.R.T."EuH.6`;vm@mh7nuoz BqC29&>VsRyM0H;@TMATSi`TH:Xbp>d0MAK@k:p`ш2: 4[P_cD"oF>Am`r磧SqaA!:8C3I
,  J@PfunWm:3ezzaMHSmartCa7NMOM	|R K! &{dqqopozHerdQKddati  Eff.iWso~Pin  caR @QaGvipaeZK L[갴@rDO"w^sQwKm@ickLock@~@~spen0;B@:]mous'iMOJK/OT4@  ]gra^tXiBe _LJ_(@HR!
  Wu,]$-/ari liPQ7B0
9a~infQ&@}qaRawPl Pulsԓ'o C#D-rcSv tAOψ пO@th7T Pp~:h7ut!!Ӛ1aL uDej. D_$@[  `0bB>'UTENTEPRINCIP?ALE  rk a/a 0manWVfuo. AnPšPV 
Qe:'@,PWPpP
qyaeqa0 f0 @V1	ҝ0d.0l@PqAuA[dK,Hpu& 
?0 sbk?vCreX>.RgqǓp r[C@@!:fP]]@n10Q"pDK.qJV;\֓,Ym`slo ESC#. aFe3';6dovaAr02 '֓'po e7F10. p<AZ1Aq%> C4&@wt֓<p8Q Itp0y fP[baq:ţ{ M
iBayN () ʷ˃!i USB0q<aДSu0<kRУZipRPrimo
Qa!rAz!԰
;O qvp> p>Decro k NumD'Rl`l Fn/Ctrl TlVIngpe (USA)dq< 
i<puPsn1so mpl= 10o :"corqpl`&/ C$CԐp>V e(k)Mo0	/30g BidPa~Capa" mem Eq9`QpD@v l_bT\2 N%RPDarmp*eneCrg`1Lx BDpatv(pal!zs Eth0Set f1Ҙ2_3?e Token Ring?/+b %%3 I AV96 2chatp$
hbP*{?C`bRB8?  D@AJ/ "IpDu Q oo"
!& Oo*Oo O*/#$.3O(
o 4,67<?1:;45aqnig poAE9CI_=>HMA6`#;mo}wFPQR KTURoOY/Za ΏFO]o^_Wab̭_K\[ ap ::`ro .k % ]/jcompƃl2jS ji
otkkpmel3j`ji)uukqvm*@z`	m Az21?%Q&Ki/afZeOg`uఽb !AutomaДFloppy2Ule?gacy AadRFˢRa@(sewc.)C veqeF12 ` 3@Pޠ*N0uup <F1=Hjlp>rkiv SyAinfot	Pps S pkek`igu 	0stll frn/lo nard Annua nd och@sluA*s b n䡚to
S Sker d0trsli  KAa8`rt-OA6-En ss֮-IDڰS@fROްt mdټtd fr  BIOSߺbyggCd Gii>ȝabrikP̚Verktyg 9K`@r v?6" Svt0Հ1HDD Akb˖us f|0@@t VljrD`s nedt`tl q1G۸ڸTryД ʯfri pgi nu1 sӄt0=, ESC=AvbrIypaFA@p0aނ, }V*=Mer zХv pil۰!۰a 0yHΡt<RET?UR> om6"ttq$. eljeuer!  : -> ? BLANKSTEG = N`i  <-o FregqeQLNTABffKIFT+scLN=  w sfelt gr p kɀ?t h!E uppstod	d7en. Felk01@innsg0Мplat ?m krv   han0@hQМm  fly s t -dr/b ex 4ů(МQ tidigY2-klT*`kQeNĉ,P?  P, typhastigh gbCa-rlek (L1/L2) MxP ROM2familjԗk,}snummndeo QӲbyrB @!? 1.$&V'2'23)2	4*a0ʋ&--2'%&/(%& 6?24&hgP4t(o!	/,viXjV(ON ()(14)=*>,4Sek`rV;arQ! D   Peneh0^cskapA /-4P1iPkPbJA:C KLahi WMILM2Lskyddad Pa0gIJWIJ Peo"BD  գY?ߥigO?t_`raW˖Te1nabbH<e`f n <Ukad sk"Dpd (): 30d0p1aw0%bp$e0l`slsppQmvrlaPޔtnP:ĀDM!qOkrNqSALtervo-7tLsо Sttribut: ID`P`d gr@
S.M.A.R.T.-y GammʧN0`ifi`n~`4@D LT0!cbnp4y Pp~vlika m`͓?W6  r G!ORin  s  : fun0͓ @6X/ O@wּ| om  dFFh4ts,Da F\sQmClo. gǀLaQ@ܑglm{tjz3h celse<Pq0resuiҞue(pH @pdł[,Quickztelge Lp$m{ Hƚˑ mjliggF0rbݱ-"S
-   Œ@Oko'ihg8 bliR2 1arLtui&P pfP"Pp^RQBOTrd}t`nappoCD-`RlNtxᙁDUHrd1U &0&34|@S Huvup~M`}: D G[#SQIh4d DPLeѫe / FANV->HUVUDLBSPO4Āpe``t ǹ.t  "Ρ@eb1qAHild frP
VQ VȔkaPuh8 aļ lЙ
 onG\`v'. -bePmfseШm ֘ ``.LP  p- ݗH˲H`ˤZ''^ sedtaqqӉԊ a:{Ǥsߓ :Ph %Z:xMPiBay7% (3<B6gSB&U!  Zip-%FEq Fjn!j6!jatKto N@TNum R౬xVx\Fn-/CGtrll$ EPlskt (USAg ֐kd !w
dskrmsp]trUoI-n	ak
k9YPbbelPX  {eo ne Flk aRQi#`{`a!S20Q-"pŗAgg s0@mhr-`=3ט>vF[, exp`{@#&Hed/O Eth Щ3Q=& > & `@"ToaR{ %"%$ oN o&G+(i-*!oUnik `nt{<0<?4^5tus 68/99 SBC_5Y<Kalib`t:/?<wk=?>/CkyFFDual oB?=oEIo@AH MODV/MG=PT KAoS_XND`iҽsWRHZ[U5L^?_YHandtagbfx=Oei O`Ahm/dV#mmo	-0Z=o q%rokOsot$rd wxgz{|v}|D[eP& : Lar .Cp% ]PMklar2u 0$:2E3a$zȍvA*@f=0bD A >W@L}lwT3ρ<AutoUbr0#׀egacy Free@"ᶀ>sadaplЬdrj|2snabb2? (sek.F1 .d'BdStyIr!Pcpg3%e0n Ae `Je?  @/O`t opslaan ConfiguPPo  Vanaf v_tndaardp sSc9ɶWiojzigneqrogramma 0@/Setup& z1r w8î)_rsڼveilbheerswachtwo_aЭ Aa'atbgD ID'sK`A/Sm C-Oѽu2v` BIOS<֯ՏabouwdeW	saTFabrieksugzQxtAccucv ex0 elecp a p s>zelftЪ-schijkfeA)i0	Ac0 6 D 6r_ wgn Geacpalaa1lem`Rrgrijsgemaa ve	l0	oB2T|
ukp bq v g=Se5, ES?C=AnnubD`1o0=eOJaNWee "fi@, A1ab=Mx  Hulp?pijltjЪ rui)dpjuiPnukeuz`
ark<ENTER> indP	Rbe¡vol0	R   :  -> of SPATIEBALK =<-BACK CEVoriglnTABB46HIFT+uskn= I`ܔfouDekPniuwf3gedv! F"쐮retijzsVven. a%co01ҭ"`a0iscu weP`/etv3oe1re
0@6 dbas
$ v(t n not~ok-pc/!R =i!+s+!a& be 
igd_%&'2 !E3Ю51#t NU0m'ypprocessSnels2s= pp/m> Om`e (L1W/L2Gu0_capaciROM-Revis0C v!D Herzienb1ga)vS$brS@m mmuE0EU?videokVDFtro \G-@pN$MG1P2R	3S4UHl <VWHXWJNMG [\n reo^NIn`isGHItific(jSe /cn (PIdz6)bQ ojkpS/lkTmk pVokWoqrJNsp^u:c`b+cOsbSecui0bL.op:  t=$t a֐s egew
 P(bef0ǂ 
 dq A:g-  /4 	5gDe6#\16off!G@-֊A)d  Daa·P))o0gуt0@Oe.ua`
⪱^wilt(?)aU? ?pnh-Z]Tq1 (=)32 (UE	P) PB@b1*r26 (.): 30P p?&.0%tooB:- hqo3½bro	D:#Ee15nba"cp"c@Gvo-	lees"Á# ½r԰(5-	Gk:0(5bijȱLe S.M.A.R.T.1-価!ǫaf1	.àudxҠ*ieuwxa+d!Blop
!ܣ! APC @P)#p+AX!%`KkQ 㣵nƂ.@Hܜipls x V.2?iKs AHbpBs+`u2H@ǀ~kelt, Á0eߊR`q$  h2+StC A-š!A?^,  d@SSЁۜѶ1;eksڗugze   Mgx|@erloR'AZ.(ڗ!U Єbba+06ѐfBhoudHi2$p$  P D= d$ gC0:Ԙ TKaAm
fb!S_㐐ʐp`OgA),RВP$br. 	ғe0Kk`traakP)AHtFQQbAGP1p4P|fraroo=dc Par!LTۊD	dloo`etw Kn Cd-r7Nf֒GVdQjpSjT|jpVHoofd1G@+ U#p!via@BPL-1i" fzow`HOOFD-GEBRUIKERSفiF  permana	 eS C"  ƄRwf#s .s/ fyKk:AJ?ƆHcomp@'"G s߀QAHB"Ѩ@t Ć$pEѣԀ/) . AC,canDlijk1X1XtG(2, u  faжESC-K. O`OAш!AHAF rD"'F'ty06bBkF10ApTHG@:l c桒eٰ3A2!Ne0l@X!iQ MultiBay'ZjYlT_ (ws)VWzpX USB-gZcZ%ZPЛp-2 EbwePRSVqЅV\_ZespZpA1ZNp@tus Num SOFn/Ctr9lBsseɌgRen2%bMxSݲ`sapp
OKBuжZhbe,rmlPP|znlmL0Bij0V,o-QP3 iFPp)dol 
*!vpgu
pnti0З 
pq0@PTpN- T2+0ࣰie"|pqz (b )}~O>Et`!00d TbR A俄݉݉= Og2X3 UkPPtcp `ccu歌חb oњ ScxaGekaCli"K 5O"`P@iѫualQT|zO oS֏hT{zSϬOdWB Ww߱ӧ H@sgpvormq+sz?s\L@Xer-MUE-yzO/8Ϸ  R!ZozǯÃO  [hp 1 : IB!rDo+Q.% ]QpStoo@2knt2еοNlџk3ls8Ц?X lџ޹߶* *  !l︣,zZModbz<R{`gacysEafAH2nadap. 0?qg	P}(8sec.)~  pop-ups00$ aI`6F12 	)bbw cursorb01urEa/syPoPH-G04  Rs[^̃ZbgA`viSETUPj <F1=wv> t@C@VXeɊւ\܂@t`sfB Nɕۑ  ݒ# 畜|/HĂ ԡf`H gɡ   H?o׎ wy ɖύXɏI  0
AȌwԂ܃5eA
T
 ea'@Lc#	Ǘ҃p h#	d?)o4oX v@\L/IDIDz  h5u"N (#u A͍폜Sm@SCs߽ܰ s( BIO}S4) ߰(,  ,	b`R@co`e̒  IA3D!4n`e g Iv O6o78M3 !/4S2; ڍ0@B'߂&@47Ӄu8ODtB!3oC!;su
8G{ hH̂"L[ 1=4AEsc=9dOsPO&Q0=͂CS`Gς  aS
A 0NRQUiPz@J\ #Ngpjڂ8Q%g O'[En])Nu=kȉVYA:Z@I]->' yo[ =   <-'[Back?Space]c!<%dۗ[Tabec'Ef[Shift]+g!ohg@e^mFk[`S~l  !4G[  ӂ 3͢5łͫ5rP 01 ݡp	@2p OqG7rAɂACO 	ڑKWv&#b?O x!cp5Tw_mH%0$ 'MEUuu?Ȃyrsors2o󋽵`iуɰ   ۾ xï  ށiL1/L2p`OM`rW8̧ *޼'رٔԍ  ޵3۰ׂ޽ޯ` ްt  ޯQ@ҧ#23}4 #E
3ǒE/E? p6Űf(ÂC)ǢE3~4yϢ7O "F`c3ʑJ_<%xw:t"GƁAAtS v͠ׂĎ v]A /pύ쐬|%A:`
݋ B}N!^ $p HFq ^/ĲUyCp|֎~ q^pR2 Òy [XOo	  Bz˂H p @89|71iN0$p72iS3 .M.A.R.Tp \zsԁij: 30: .֤0% AA OK z7;7熎~@醒f@2p:9Yqem@QXGT{ǂ4%b쏃T|HvvsڑFIDctv.
2paoF .s?Qt)V!oicm1   ` 88TpTUᶠDWvrq<!^4W̈́TNamp8v;Cƒp߼!$|,yˊ2 | ?Sd0
ȆyX}|Xh	& ƏO1e2
dpQa'Y v)u'0Z@"iCy;_Ƃ B]T!^x;?x8!xY"`;TDN(u (	Tbh"<($@20N{}EL(/.!Ad;
$ 
ی삪#ݑIZ= c蕴  y
YqN"΀A!Y ԊO<qӃ;u?ȯܰ?~  CD-Gi Ah>U1D2D3D4P (}^: (QUkIp@'i`(A@YDA@5ŀpqݽ_]J-\;I 1bĀp'AT :VT8(vD (0Oi:Uqvq..R͎00բ_Rs`^痣Stˊ`ygPTr|/RMWP2
q 1;1cq-gJS@9|Naxϐ$|؊ԓOłGfbo͗WL "Zy; sLEX0M|ql ӔC
]MuM8:p[Esc],0Љp6ȍ~KK"e{1⽉DriveLock t<[F10}`~o1;!`tn  J/dd'u"511	)=}@`AN: mu+ x`XkzNbO 5xkX(ipɗUSB(aRXkpQ Zip?1ԯ 2345678910!Numф Fn/Ctrl}̐ؑ , ,{  p (USA) ڟ|@{BcfPCXRKVĔMSv=C b]gk Ŭ&1}bܶ (=r@Io
l= W"o *!T@{Yb;9܅
O2͏o̧	
_s2
g?ȓdo1oe̯8Etherne=E EƀFƀGz?gkN w@?[˟_3lQiNOȸʠja WID Pbُ  Oo 4pD?@Pᴇsf ;/5_ |5 ,H_5,n*;/߿ 5MEUet/	 %
O
_
_t>9bv1 : [?d .% ]R늮k2poOv3pģ	# $$!* (! !(OpC*
@jz2iT i oIntel  SpeedStepP technology 
t>tB ;_PIAް Ӱ B <&;0x(b) p~`F12:ԁibBö*_r AS^``kb}=QB a1j?B_CDEF GHJ?K_LMNO PQS?T_UVWX YZ\?]_^_`a bce?f_ghij kln?o_pqrs tuw?x_yz{| }~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$%&' ()+?,_-./0 124?5_6789:; ` a b c d e f g<, =         :  	 
      
  0A      t            B    &   X  ) *   - . p / 0 d  $ %   & ' ~    >[; NG;! uG;( G; 8>[`>[>[">[(>[ />[(5>[P;>[xA>[G>[M>[SSK<?@GP@0@;<BB<;>P;ب﨨;0`?8l S;v x|kvFS|S|;p0p;|PV  PW;0>YY = ~  P=`O$$$<   DDD u0\;O;aƄe  i  o u  y ;nD;A  { E;  I;O A  U ;Y;N; ~ `' ^  C  B;y z ~{ [ ] } \ @ ~ 2 V2U1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>;sf( ) +1f)g#gi'?
j({[)|+}]-k[{]}'@ (#:mn4o^j()\|+-ky~ z# {{ |[ }| ~ \ ^ @ ] } `W1g&12"3'4(5-67	_8
90)aAi$qQ'mM(%) +*,wW2,?3;.4:/5!v@ z {zeV"mmn+*'(uNv~$~ze|  cڹ+ai'()+'* /O1f3UOoFCj2쟍
\u()|o-kcgRh'h -=
^~+]}@`)  ';+(:*[{s\_}\|      E_>[>P>[ `ФФT>[Х
`ξ >[>ФRФХArХڔ\
<  9;:;A;O< [CP<?;U@;A;B;C;8 1 Шcy _>[ğ^>[R\@L,a>[bIP|г
c>[гP;Q;R;S;T;U;V;  W;X;Z<h;O 6 >[	ԲPꐳQPP~P>Pu#m  ]<^;_<`;a;bػ(>[ּRZ>[dĎĸʐԐސ| irI( 
tk;Plmn 4 Ï; 0U;ˋˌ; ˎˉ 3 	>[ּQEƔ@ּF10 Setup Image_SETUP  ;r_AaAO 5 1Ҷ̛˚բ:BU˝:ּIUϲP6!%̲cƳtސC
Iּoު#B:;Vb 4;;̐l0G;*ʦ0ּ;J;0g;U;;;;U;<;;nԹo 0D4 U0ּUU=3 LcX ;	N϶pּ!p;<" " c" 2 W>[	ּԹԹ4ԹԹԹ 2 lGr\C-	
/
M)0ּ;{(C<r"<   l    6	789:;<=>?@-@
>[ּԹԹ
ԹԹԹԹU Թ%ԹiԹ2ԹUAԹhԹmԹ*Թe/Թ0&");$0'g_ 'G;b ԯb` tCt. 7@Hru43T  w0B00g$ܚг2P ` гdjPN8p040404J0404xd;z\;3U  };;U;U~%QϤ00ּ  H =Xp@bp@hp@|p@p@p@p@p@۫= BFB^BBBBBBB=$0E40EN0EZ0Ep0E0E0E0E֚0E0EBG<GVG\GpGGGGGGBJJ,JNJ\JtJJJJLL=M0M<MBMfMMM԰MM @E0PB0Pd0P0P0P0P0P=@0R`0R0R0R0RS=S!A<SJSUZSjSzSSUSSSȰSްSS	=U"pW>pWPpWhpWUpWpWpWpW}pW
=:YUdYxYYYUYYYY_=.p\Np\Urp\p\p\p\Ip\p\۫=2^R^r^^^^^
 _`R`r```"^``
@K0cL0cf0c0c0c0c0c>0c=*pecUHpeVpeppe4fUpe4fpepe}pe=hU.hRh~hhUhhhhSWpk6pkXpkUtpkpkpkpkUpkpkpkpkUpkpkpkpkS Kpo6po^poU~popotppoS
 _p@4qfqUqqqqSEs>sJsU`sssưsMs$ CuRuU`unu|uuUuuuuUuuuuS
Sy&y2yUDyTyzyy5Ȱyy@H0|Ud0|0|0|0|M0|W}l}U}}}}S@HHRU\hzUʰְ5M0U0 0(0.0U40<0D0J0UP0h0z00U0000500@k0U00 0(0U.0B0L0Z0U^0b0t0z0000q0000eJ\tؚ
W0:0^000ئ0\VjepRpppКpp& E0|0000"!zbxΰU"]0BTUdvmİ԰榰#B0006080<0@0D0H0L0P0Tl4ntrv0z00000qa@0000Rq$@pVppժppp$%T C0n000վ000&T z020L0`0U0000M0"' fpUxİ5갪"(\U6HPhUxM)\NU`Mذ*@HZz谱+E00a00&, XԦ-@xTа5ް
. 0U:0H0T0p0U0000S/S,@UTnM$0@HVUp.1TPppppao^_`aa!p2@EX|ŦŶڰV3HjUǬаǣ4WaNl*ɘɨɺ!i5ΰ*5@HpUZp|p̬pp5pp6@pUXpΊpΜpάpUppppUppppS7 zDx՚Ѿ"8TzӂӦS9H0~0Ֆ0թ0s00: zpZpהpΦp; K6NT)wbvؒUİڰS<020@0UR0d0܎0ܲ0500= fUrޜȰS>0h00M0
?p<pdpp%pᨪpppp*@@RpTpdprpppp䐪pppp䠪ppppΪpppp
ABpLphpJppp魈ppep)2ppqBk0J%X00!0M0CepTpU~ppppS D F000S
EE000SFN0z00M02G ppMp.H UppMp"I FppMpJ p@pUlppppK.0@0P*0`000!000L zpe0p/K!ZtȠpp塩pqppppppp ME0\0n00000 Ne0	D0	j0	0	0	0	j0	0	0	OWVjذP z
:
X
x


Ұ
ܰ
4
!K
QWUH\U԰SR 0.0T0U|0000SS\0N0p0U0000S$T0z00500$UR!fTpjVW0>0Z0l000000W zR|jܰXB0!>0!`0!0!
0!0!0!/a0!YT $0(Z0(|0(0(ծ0(0(0(Z,0*D0*X0*h0*0*4+0*ښ4+0*[@ep-&Tp-!i:p-Vp-~p-Up-p-p-p-p-\ Kp0k.p0Dp0p0p0p0p0p0p0Rp0p0!p0p0Mp0]@H4r4Ֆ44t5^@Hp6atp6p6ܦp6_e7<7ZT7s777M7` $p:dp:%p:p:vp:)wUp:p:p:p:Mp:aW0>.0>U:0>F0>R0>d0>Ux??°??Sbe@J@l@U@@@@S
c $B\BBղBBBdH rD%>DRDUdDDDDUΰDܰDDDMDe7HHUH"H*H2H:HBH`H~HHHHjHHHf$0M0M.0Me60M-T0M~0MR0M0M%0M0MJ!qMg>SFSU`SzSSSSְSS0h 0V0V0V:i@l0W0W0W8j w0X0X0X@k40Y0Yl@tY5YYm ZՌZZZnT z0\H0\f0\|0\0\0\"0\0\oy^F^r^2^^J^ư^^^LKpm>0d)P0dV0d`0daUf0d~0d0d0dU0d0d0d0dSq@>i8ifiՄiii rTBk kBkTkUjk|kkk5kk$s0pnUXpnvpnpnpnpnpn
pnt@8phpppppppjpppu*sPsnssssȰssssv XpvRpvrpvpvpvpv w@>0xH0xpT0x0x0x0xM0x0x@FpzpzRpzhpzpz5pzpzyI|@|%N|b|z||||֚||z0060R0r00ʚ00{@0B0X0n000000&|@$"naqo#$%&aq!i|jఄ}IJp6p\p)~10dpppp~@\080R0rt001-00T p&p<p\pUnpppp5pp
0,0:02P0T0!X0!4\0v00000"@1pvpp!pp,T0x000000T@n060l00000 Z0)< 020N
0`0r0/>0U0000S c000500 _UXlMްIpLpUhppppUppppS @10X0d0%r0!HpH(Pp%JppUpppp# ^L0MI:aRZJt|!5 0U@0d000ռ000T>0`0005004!Ր$T@0000SpppMp@1t5ذUh5$ Z]jzq_@pBp/bKclHtįdepáfpépegppjppp Xd˄˲Ҧ00J0b0͌0͖0ʹ0ܚ00*pPpjpϔpϮpؚpp pbpшpѪpppp0pZpppӞpӨpӰpppp
*FnՔղI000^0؎0ش000@80^0~0ڠ000R1ڛ@0܊0ܾ0M0.pppݪ!˔pݠpݶpjppp" XFVvߖߪ>0Z0z0j000*  _0l00帚00@\Ӡ/&:T|ܚ0pdppppp
*0P0r000j000
04b* XURdT@!p,p4p<pUFp0JpVpUnpppp
@8lҰ@100000U8F^ՖȰ&T@bt)<ޚ*0D0\0t00j000@Ȫpppppp.!j>pXpppp2pp%E 
U*
N
~

ʰ
ְ

 T  (U08>FUNV^U5EHTMdz屒%PTPްR<f
>0R0v0*000pS&  pppMp   ~5 ~T@0x000S@p bp p Up p p p  Cp"Rp"dp"~p"p"p"p"!¡p"p"Fp"*%ea@%&/GȈ%*%%%%b%%%% X-L-l----->/T/~//////
>02H02n02020202ڦ0204804V04z040404Z0404p6"p64p6Bp6dp6|p6p6p6Vp6 p98p9Jp9!np9tp9jp9p9p90<P0<x0<0<0<0<À=>=l====Ā}?h?~?-aޞ??j???@npB0pB@pB\pBxpBpBpBpBpB &DJDhDDDD" FFFȚFFȀ}0H`0H0H0H1H  Ia6oGa6IIIʀO6OVOhOOOO
I QNQ!/\QUQQQQ5tSQ@\TU8TNTdTTTTTT@l0W\0Wt0W0Wժ0W0W0WT0Y>0YJ0Y`0YUj0Yr0Y|0Y0YU0Y0Y0Y0YM0Y \J\Un\\\\M\(Ѐ^^^^^^)0aJ0ap0a0a0a0aF0aҀ0c),0cU:0cP0cj0c0cU0c0c0c0cS@ff.fU\ffffSŰhrhhMаhi<iUviiiiS  (khkk%
kkаkFk 0n!L0nJ^0nr0na
|0n0n%0n0n*0n0n0n0n!n0n  ps8psVpstps~psTps-pspspsR1t8pspsS &xPxtxUxxxxSڀzRztzUzzzz@|f|j|||  ƪ~~~ް~ (p֦@0h0j000&߀аꦰ0H0l0000Ԛ00 p4Pp!!Z!%Jpdp%vppøp/'bt)G+"4a<R\fxښMLvؚL^xj  ت0B0V0n0000000$ JX^lr֚ B\n𛞪MZjְ  0<0X0x000bJ!US
9,:URd|Uİ谤S @XUvİS
B>VUn5ذ,0x00JL/Mᘡ00Κ00 6*Rv! 8Rf~𵞪B@\~ؚ@pXphpvppppppʪpppp
@jZtLUzذ
9pe`Dp\ppppp,UZjRĀ)ĞպT0 0.0<0UD0R0f0Ȋ0500  UPxʠMVU̓*pxpΥlpΘpήppp
 Y(d@sFRZbjrzЄЎИТ 0J*0`0n0|0-u0֞0֤0eT0%000֦@bێjۺް &0R0x0ݞ0ƚ007nޚ  MDn߮2Mrppp6Mzppp>M~pp׫MB000MF0000M@phppppp00B0T0d0v0SM(p顼HpVpvpppe&p鯉̊/*WM4p>pNp^ph0000000	h
׫MH000000$׫M:dr@Hh

0H0tj0|000000M0Vv  :jT@X5&p5pp
pjpppppp
׫M 4L^jvjp	Bp	dp	p	jp	p	p	0 ppppp"@jj *ppppa@oǰa!pSnղİWM8pnppոppp@0\0t0000OM,T`xj0H0d00000000@"Fd) p"tp"p"Mp"@#####e`  @%l%~%%%$! p'ZJp'jp'zp')Ɛp'Up'p'p'p'Mp' "@**S&@*D*d*Ո***$#T p-p-p-p-S0$...}.$%MP/U|////S&@l&p1<p1U^p1vp1p1p1Mp1
' n3U*323<3F3UP3Z3b3l3Uv3333U3333S(48L8l8v88-u8Bpڨ8v8wʰ8ְ8ܰ8)T@20>`0>0>0>M0>* ?H?Ud????5ڰ??+ATAAA,T ,0C|0C0C0C_.-MfpDpDMpD.'pEpEMpE/ ,pF|pFpFpF.0MUpGGʰGGMG1@20IR0It0I0I!0IҚ0I0I2pKb(pK!!xpKKpK%pKpKpK/bˊtN3@D*R8RFRZRU`RzRbRURRRRS4@pV\pVpVժpVpVpV5T0XF0Xn0X0XU0X0X0X0XS6pZBpZVpZUxpZpZpZpZMpZ7\:\UZ\|\\\\\\8WM0_F0_X0_Ut0_0_0_0_M0_
9@pa6paU\pahpanpapa5papa:@cUFcpccc5ذcc;@eՄeee&<TDffffS = :0h"0h40hUD0hX0hl0h0hU0h0h0h0h0h1h>kNkjkkkk0m ?4m`mmmҰmm@@poRporpopopopo*)A 60q0q0q]/G]0q0q0qB@pwfpwtpwpwpw&pwC40y@0ywUp0y0y0y0y0y0yD{ *{@{V{f{Ux{{{Ȱ{5{{$E~U\~|~~~M~F ,U<Xbj5v@ưՌ̰GT@D0J0t00HI0j000I@1TpJp`pp5ppJU)ΰ谉K :.F^vj L pXppppM@tjN ppppVpO1 hpU.LrU04 @PT 2UHR\jՎ>$-:a;KQ;0%ڮEp6000U0000SR40H0f0U0000M0S@pbp0hpp(TԀ<U4
V@5ذW5谨.X5BY氪Uʰ찪Z0F0qf0|000ܦ0[L&p2*pFpVpzpepNK/Q5pp@Lp \ppRp qpJp\pU~ppppS ]HhU԰M䰹 ^&U0FZzU_&PTXtp1t`T JxͨQ԰u=aT@p^pņpŖp5pp
b 0UZ0Ǆ0ǔ00M0c@p5$UPȦd ,<Rf|ʊʘʤʸZe0U00H0`0x0U0δ000S"fTpРиЯX=porstua!g@Bbقَ٨°4١h@DpUJpfp܊ܞpUpppܫi$pFplp|pߘp߲pjpppj j020N0
@}00000P0T06ۿ=\=0Κ00k@#pXptpppQlZ5m@0e%Zr锪颰ʰnT@pZphpxp쪩(pppªpppppo pp*p8p\ppjpppp Pnjq j1rTp*pHpdpְ1p1@=~jpppep0pppppppps@.8VyAp0=-:Ira;;%0<៲b#Mt4BUj°5uU^|Mv'5°.wi5x	Ղ			,y@
000zT@0000S{p
Dp
dp
Up
p
p
p
!p
|@1(Rro0L!Uze/K }OQ .4J@HHUXNVhUаM~ inUS.BbUv5ذ i0 Uh0 0 0 0 0 0 0 Tp"p"p"p"Up"p"p"p"S$:$J$Uf$$$İ$5$$0'U(0'L0't0'0'50'0'?0)UN0)l0)0)0)50)0)( l0+Ur0+0+0+0+. ,!T,^,n,~,,,Ȱ,ܰ,,,h/X/v////ܚ//?02N02t020202023d3333455h55 5"/u"զ555T<<<P<t<<<!<<0?L0?t4?0?4?0?F0? ʰA!}8AU^AAAAMذA C*CU<CLCCCCCCT pF.pF8pF<pF!@pFDpFLpFjpFpFpFpF %IjIIКII0K0K0K0K0K ٰL4LDL`LLLаLhN`NnN~RNN)NNʰNܰNN 0R(0R80R!H0RX0Rn0R0R0R0R@TdTTTTpVZpVpVʦpV
WHWlJWWW4ҰW5WW@2pZULpZZpZfpZ0UxpZpZpZpZUpZpZpZpZUpZpZ:pZMpZ@0_0_U,0_F0_b0_0_0_0_0_-J0_0_0_ 0_&%pdUDdfdpddJ@԰ddgRgtggggg@ibiiiii$@ްknkkkk@0mV0m0m0m0m0mnhnjnnnpp^ppppppLpp60r 0r6rFK=UF0rX0rl0r0r"erZu/Ǵ0rL=F0
0{(0{UL0{X0{b0{p0{U0{0{0{0{S( %0~j0~0~50~0~U0H^zU°ڰM,pZpUrpppppppTfzUS @0P0d0U0000500ٰU.TzծȰ갉T@\~լT z5@U$0<UL`jxṴⰏT *<RUj5@ⰖU&8J`Ux԰갖ao789:a!}@p`pppp&p0b0}00!~00~ٰ!Flа氢$@pPphppppppٰDRdvް vpPphpJpppS0 J5$@pUFpdpppMpD0j0x00)P00000000,020F0Z0J0q00 CFpjppp(xΰذI@XfUxUU5@߰U">XUv*<аְ ް{JZtǎǴڰ +0D0h0ʌ0ʰ0000V0̄j0̰00
 vb͐ͼ覰 0n0Ϝj000"@+zШ԰ ĀRpцѪQŀF!8LUdvӊӞө!Fp4pD/vKwTtدxGppUpטpצpp~a$PnP>[>[      Ck      [a! Vb   QxLGB=   0{+&!	!$08/14/03 Copyright 20`by Hewlett-Packardmpany p
!`t`{p
Tp
  'p~}P >"q"'DTutp
0
p
tp
tVatp
p
"p
#tDt=tp
@t0`#~ 1TD#>0ȥtv@D@wt(trD	Tp
'T?DDD T0
%!tq
tp
tp
Du1ү%D"!"#$$"#!P%d%%Ô
@$$p#"2` $ Ѓ0&e'u uаS(2Txu. B/+>$4 `Op" ({ *{*!
"  "2/)z|m}~ }䓣𣮂~)D`s )Cpb`t   +,-.0
..-$-2,,+$+8 Ѐ)t" ~}|}R 5"{ z}7!:tu0:=tq;q<} |<t=9>$9% B'%($('&"!B&cC&PDB&%ӔP&`ӔP%/3d߀@D$d	p?C7%u( %B&u*I)**)p)N`.(('$'82C;i~@<%&$ 5|DqP!B!
D @%((sOaWlz"RR"EP P!B0DTA"1UqTt~ 33U']pPLI"EV=!B#"U.YU#߭""E!21\?j"U
T	"uPu4"%$B42tʎ"0"
pHLp"0"_d    55ta)t`0
5"+ d+/ÞP.%Rd@B Sp`ad`%߀͹adm^{ +u.I-s`..8-N`Ipb,g {
ad,g}hBie,`Ced`"s`7tp
80d" stuvx/yOzo{|} 	G ;4w   01/09P303/25/04 kCrystalȏ	.00"x#T*T0?	T@t/{3"@xDx_v$ÔdPx>0P25"2"`'~"Yx x *} ;uu u_	`J22@)aT$3TD ȃ@VF @~`T?0	T2`T%`@2dłŃx!T.xT?T/TDx!TDtxD@p`p
0d/dp^01zd11$010 H@ޠ K(
T`
0 T%%0TO~7.aOT"¯()ŝ) K()(@` 	JKXdxtTOa "w23C>g T033$2P2 P	dt0$7}d4;" K07xD  'I³+ˀP2
2~14+"x 0p"0}2`W b"ÔP;Q"xD¯./uE-ү 6\./"xt}
~豨1xWvvu/uˀ0wDJEuu!;ү0``Sk_}𑛐``
$`$pˀNp xп~c
[xx txDESxxxx`D@O3/oW}v0h0a0|?I}d`1&xKpFJ0*x%tx}Do @`0xtxtyuu !.w}_O}ft]}mO+{*-2qxdD0mȗ2 пx^D$pTxcD%xfTp_@p# ) ,Aa2Y;1*0wpѪs	 ȎT} Ԉ" x	O0.7.Ȑ}0Џ)b`B `e@
u`ƾ !3s#l02 6\
;¯Њ)u)$O4CU_QL)}+ʯ)Y(_z`QÔ@_*x)( #! '0%_sovp"x)(*_w0.}++,-԰@"x^}5}8=" }:ྴ5'x%~x=0Td~`` 	D#`00x)xb`xc pK0S(;~TB(x¯0)Z09ZP4" .?(0Fa(`xR	(dxx !q	! #
p(>T" KPF< y([P>! 
@0Tdp(
!(PI(= !T"4 x^Ô2@Y`0¯xЯx8x00`4)04 T`}`	pXl"Cה@#H]^534๢0ۉ`ᛴ{x,xt;xx,q00ނ"x*-t+ZС`KY#^ݚb`}<TT?)nT01p <0W*T߽`!+d`
u)?T(d``poUp(D-TR*T?Ӕ @
-T?M<T?`d`}*}W)pK0/-@p6Y*1.z. 0@4~2~W)(ѡ33T(?O)`8 5   ):5 )$0`$pX~"F@̆" E<`abux`_>N>0A@B:@`A@BЂЃ2>x^p` 	@?^!BK"?*1@Lx-?+_MLNx*MMx+IL aeK`
LMU>?1@J@J0pN\MpNpNpNAKB~>GQxZ?Y1@RNSRAA~KQ`ǋ#RBd?GS?u^1@TTTX@0KSN!UTUVU?c1@VTV{T~V"Y,]!PKU!UVIZS2A}4 A}:`2 !, uuҌВ"ab$Db;5!bx'@pqf$5d`!5&88sg`5`'`2`=`HpQxWkg6uu?uu@Bmuu0dnuumUeˏO$bƨpN`0T`
0#D0ԓ !!"1"| }(9xWp"(E(p
 wyp(Ц ()(x)(0U(|)))((xY))"*+f?T0B!7/t
!"t&&pd `.gs..tcv(v響,-mp,l`
,-d@ݶdt v/O+0Յ+*,-"uߘPu4q" %cx]kbxt؀x70x8N7t=0"$%&'cd"xe'%0%x," -DtF)AG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7jU?4c~;V~Pno|ZQ}_%]	`
e(i[&b'g>d\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 ` I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p w t z q { y m Zc v v       
  	 x   ~   W Y0J  |0 ww ~~   @"x4"AD`aADx2t?x1tIP%%c0% %xivv 4%xif=0Ixk"# $ $ !2x1 	  ¯0 #!K 3w"0!Mx3=
rb"xjF` sDpP"" %	qx30#Z0$<pT{``"P"xkkfp
0!#̱tJ.4}xkQ$3z 
Hpx?sp``$Iyk̰O xgv"xw0	D0x$&Ӕ@TxwyvD?"02Ր4'xOexvDPTp0
910×0}lR"xm!xnxu"xmxvxnxxxu"xpxo6q`byoxpf`Ӏaxp0qqrkbvPP" .0&u)P:)@&A)@&"*g` "x*{pgt %*o- -+tU-,-b,R--o++,U-`RU,`  +u%*$U,00u,,u,0,*+P, 0 d0`0Ô@"0  	0
0 	 	"_0   UHb  `bU  $b U <b  Tb "   _R@)1  1ϔP2P0/0`0T%110 ~0//!1Ӕ@t -T1?aKnqZ.¯0 x.xgo`x[T`+T xfgv"/*r38TOp0 0@0 
0 @]"@0p/^GP!900"EP@ "%"672 "2T1u$407S20 |09}> ~ } | 1 ONML:T_^]\8>srTq8 7`86086061$92"16狼$D23s#E#23Ӕ@
3_33pq22
0
1#6@0
*1$`$`$p(&B * ('g66*$ID)$[@)e1--.@&F/1%K"487  8"4xg Ԡ1xhq4d|p%07-8a){zyD$3v32v10/2?_`)07#31?4R5a87
P)7C5 - 
n6O9 Y#@5
p<19:9497Q4>=567:567`-:t%77566 ::0}1rPrD70r0+07&:yM4417pi6 "7G4 IJ~4r@4H 2 
 o
 *!
02
 73IJLh?GRH>8p2o`10110u0-07(OF^7
@HI;O?P=M75OYoZ[Q:UxVc8070 ?1+`*N747OdD1HBaSrddBaVee4pc;d?eP5700 \E7CDBao4T+qlBaZGBacm#mjm0#mlm=Ba_4Dhfp_67ufrPNk;a
cDR0nql#mrtq#m{rur >4xfpJ`
`F0}D~
)$) )`4 4 "|~xfy}[ #xzMNOpxD Fe1``}HAX0
T1d`(0"1# ap{z}y[1zxyd[@00
0 (?0~`0`/0$`+$`W$`6$`$`}&[$pY?TQPޫQF>0Txv)ۀ!PـDxpـ0c0!@^P/` 	0C*n¯8`ү"w 氘NTG`xd  R`.3/x~v
xD}Ep*l0{^`
}_T?Dt_qUfɞtɞymǞPE[@TC̚p343$``$p"t1e4`tg4䀓'񂼤 0+0)QTd`x0dp# xF TTÔP
._xFtf-7xBUABt-7xNAN꒯m-7xJAJR789t/QC:(x ү7%$&t:t:82(0 (:$ x`vT"` 9x"үӼ78 0(p870 p0 xυv5Ï3xV53}+Pʏ4  %4@&,M4˫""55Ô@̀԰p@, RPSΠSΎd`
*~5,T
O- 2P2"Ӡ1412s0``/`@$pNtӿ21ԀI:dԩ&TթDڥP)?P!
 [xӭ03oppG{*@6[>p1 '?PP"T~ +إ?T;үd`pxH p@@i@d;"-.ױ0"m`0P-x00 <mp@
80
DT01 0 	 0>@_g  }Dt
au/`/"t߀l@E-ˀ  r. l dpe`0-DxF@b bxu0000u0"//ڣt9//0t ..}0 =$40/s0ͧ-? }~<
.E	 	@g"	k 2/)x0)!:)P4+,cߐ2). q707/HphRa)
20QO1` 5 
1x(0	(`ד*R((Љ@Z@v@P|	@ `P0 T``_`ĪG/Bdp3*ڿDp?vڣ% 50rop;߯20T0ۅ0: 'p	S0_5B0'`@%%O-2Ī-.qN- H+,(4l62p0
*37<
5-``˭-(c*`	c01+.5,u6?-1).|pPP3	u.
	Eu.M.@[T1*I
*+	@҅IJPѠ+ 90&Tΐ +	ࢀ>f@N205o0upo6);*+pF}}?~0
?/+*t%)&07 "S"S;"ΰ(p5B૓p^BT| 0=$w#`$ <P)T0?OQɿSw45pYW}x`T1JPugrhsg["g0P>ʅ54R-GdeR8kQLnBWVSiV	PUʀkpAqhqj"`{o0i}
qE9tȇiQ`rdq(vPP6$$P3]zɶi}KpkVkSy+k6!l}{a X pR@!pLxpGNp?E&1¯E&#E&bE& TU`#|Tx{}B{xz`Hxy`Fxx`Gxw`Cxv`=xuxextx[xs`xr`~xqxxp{x0x|Bx{HxzFxyGxxrxw=xvxexu@jxtxs~xrxxqxxp"Syxdv0gTx`G " -8Qd0{-Tx``g`egG S-^3~!** **a2 *YؗC")u,l. -T*/.^0`"V2QM'a27)'p# ,(;)+O*+pGR3^+u+@Rj;D-pV-y70hRP5 
I7? P\gpW}E@G)BtC4rN:``"00׀V36`"حpgP
7 "u*Ւ09b"߲O  _})NGV=	) :pӲ ᑾ'+0 "z +pM O0D@1_T:P!O"J^@;DP`S)3/)u+B+ +2PI` "u+"TG6l+3%RTOP`p`@0 ```=>nRI$>`iӔ@6` P x?0!  x:"p#gA7ҰR?xvhGemq`h('?emqـ#f LO`>;P"1ۓzp\opT++Lp]!M@d30. QT`N}@t}S? p333oTBD0D pxdw3"=t}xVgxF0pNNsNT Rm!P
Pi+M޵"G3"x)"Os[jO0!O!A R733t\`
PO )J'' 'BB`q@U` ځP `	@UqD"HߋI鎟0T(I{EHBa3'n ADnA6RA6a{A`Ypo0:R@U P50]`$ e:cV1",F;6ŀbcD0B5"/0O1@"BC\aAU!Cdp9pW1 tǣtqpPI"CFaD`DCxgvBC@Q"xF?xG@xEAxFt@0( @T.`x@@0xA Ft"("@C0 00!AAe"xBCA!B4Bj X!P&3"NOM!NT#N%y&$"UJKI!J(*J%y&#"1DEFG\`N`JCT&` 20ouEFE@ 6
GFtW#7A:BED!}_}f}t}mEAMI ++G^[:Ô@"NxDPT@Q| NEh=DR $0*R=?zB}@T}DpOEVEPEDE.E"EDDDDDDDDDD}Di  EbF`Dt  "Pp:g&\FgЁ?t"x\ُG¢HIHFK"GgD	MGHL:M3LQHR D7F!FL*QHKRKQv;сPPDP$`RF,WF$qF[OӔ@UOЗgOO 0	xgZÀӒ}}CLO`#`5`2$pCEgFgGDOCL^ _Ux[OOT  xfcG3LJUA]Yf
xc@ GÔ@π<gT0xcGlfӔ@f`gf fgWM"`TM @[tcxh@P1P[v+xfv2:t@4}t pt}> r	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTAT%<²<-=HA?RU&Al1I$	J0O`Od`}YguOAHHHHHHHIII$I7IBIQI`IhI E{I;KDupDHQpFB^F`  w¡`@HEE 1vTfJ0PABx=QaFhBea0[AP YPbOpDa=$d
`#`(`<`ЙdP`d`O`ŀ咚0;QDA n ~t=Ptd"PxtxjxXx\t x]txat"xbt(xJxFxBxtx(tb}Dxxtxtxxtxx`#x> x=tPx@t0xTВ%>"xt4&xѨAx!TTT!D	:xTTx=?Tx"RT=D0"D3xdv0}=t GVCVHVFVB}E?I"x0xM"xaP"ҸS? /?@>"$2tp> $-"TaÔ
P~0~7%O{O ^NN@7%NN{ z yN<LJ LQ+LY3La4Li6Lq7Ly8L9L:L;L<  L<ONYQж!I!AP!9!1~5K̏N&p8p;uNuNK įN"$`($`*`u-V/\p4
pT<BP0>=QCGFHBN$`@$`!`0`?$apA_:32*}0U 7ҧ.Ѐɍ,p3`G`[]Np_~"N@wdpF_$`D}QTإG.a N5Or"K}$pL`PPKd`0KxaKÔ PKKLC@P
0Pxav"@ޠNNNNNȤNOO	O$O?OGOXO`OgOtOOOOOOOOOOPP,P=PBPGPLPWP  P0
@v"xzMNO`uL6LLCxe}[^rxyar")qaL
L?$еmle~"} Kp}UCCg"uM|SMM]TM0CMA>0 0@x[]avU0>dxTxdD0Px=orwxxH`}KW}I&	
`0"30;KxN| } ~ Mѐ4K`pRPLL RP((sPPRRRR&R,R7QQQ-Q5QQQR@RTR_RojR0C0>Ô`PP୰"T?3} 0xt}n"KMKg~Jh0V	<m50Tϰi?0uoKS`Ign0<`*a M"0G2$p?^0Kp."xydPpa"{z7}y[0zGL#2M[c cÑ^0M}PA>0>* 0> ѡ0>t#`8 2>ToK0T0DdPeePlvFS	0k0#<0xD }/Tfxbu!**xp7vlIdn0kT*0k6 Q0"1p<r1^0kx/.u0/}+  $0.T400//@"SR0  "44,M8"7  4b8}4",.S-7,Ô,pC-S--S86-04"
1Lxp0 "%x?~ B/012*o@t?0t /x0x?DQ+?0/2R1U2B75[wxcxDpqxDpbI pHI@34x Wt`?vpWtKQ	WnT	UUTUqUNV~VWW>WEWR4x
,-~Bx
tPM,P
-,лx
CRRx
Q:P`D{To8x
Q #AM4S0"t "T $Qxl	}J~qSBxkpWxkßP2T	0 PQ%X$JpqSpW$ߞPxk߀PMKn\S_._)*u~+pQc;EүK$`&p<TE}ebHuc ^Fx+*)?+4\S$xxl`j@v`DWR@xkvyk?xlP[`Y  `DXvZ0 	Y4
PPTxv 4v4]x\`r¬ga
PmSQmP0Pg`Dxx
xSPPx	04Wu)`P$SVӀ.TqTU04PaP"rW WWWWWX'Xx	X
o  Xa"D_yD@_;"xD R&g$P``3g 0{TO&&  +D"`>fN{T{#||`/ԃ}!~u~@ *@uR~f_O t0m҇3/3TOx}"⤕ "34"PQȃ`p}T0`- ,*)) J9>S) @jS) x_vS)@)"(),0,ZрYx	`א}BNKYu- u.aBSS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-^_122 ,Nxq 0\F4-3u--Ӕ@l00ѡ` ZZZZZ[6[Q[l[|[[[[[[$\%\&\+\&,\3-  \8s,qC\8xu,xhs3P*+PP
+*`Sy
xs2  8t?e+pt e*`
@D	D1RE߆`qx `@1}}{tx2-cض@&t`A,^1_vиeѸ0o}Upѻtѻuuѻvѻ0#}/}3q '`ۀt8_ђp<@!)("`pL]?\\\\\\\\	\\\\]]
]]!]>]]3]  ]`p] Av
tt)SU	
Ȗ]*FΰDdTet'KPP}T0BKRc
/":#y\g@#'% #&TT&PP|`iP֢sZPP`!юk0YG t(@&D4sYq0xSэK`ADA`
`#D `$~x"lqPD013~""0'
  `""0.`F" 0[2o%$Ak`Re1p<30 3d	`3

3 xgv"Ô
@"2}821.(1$`$`$App7^"_u߃	%	;7! }
 Dxg1#Rf_"
"HATH$>p_~ w ¬_"``0w"$``#`$`%$p#F0 8 x
=#"x%[ty%xD@d5@pE"\\}td0	
ı` 1@@x00Dx!TT`&o/J I^`+TJ
 D!D`Q+!T3A
"Ё
"  :	;
Z
123B=>C	D


~x`!ÔPp^`_c"
%{;KF`7A0x(`(cxA}b((qP`C0.+xT 4J} 2H. DT_` ׌`1p00	40 1 b0PSP0cx@($```9`B$`bxv @zq DxTҎxStTT!Ha(xS(<x)@4)$``$p#(0xSx(	x04pa7!0a6p!"*+*Ô@*ӔP*@
A*P;*$$!}$cp!0.-C+(}+-PS+*d
0*C+e+)3*pLc*0M#1@+@o0,~`J`N`R$dpT++|Ӹ"+4<ĺ@5dp0@50Ӏû.+18+."*+i"!"x"q݀:	1}i`$3mp`1}~ ?,/vdȃd߄ee$e-e6e?e?eaeaeeeeee͗e͘efofoffffgLgLgngngggggԫgԬggh8h8hxhxhhhhhhhhhhiii%i%i%i%iLiL  i~)@i0iC/KaKT3/LC/00u6$Z 0` wR/MKu/L}/PUQSQ,}!QN˕ZcڏR"SǿSPRS"S}S_XRSZL P ွPqM^NeNLשNeNӝi 1QL]~ !Q`| }~ d@^_1*QLRSş\RSÿfQ_a`/Ӕ bf<a`ÔdkaK| `z {Pd0n@\]L`3a_-.3aU𔎁p`.R.-xTShRRStRSvJRSxRSzQpk@#m?U9-E(rrAR~!~_r{d+z xTS}RQ?RSOJRSϋRS`,$/0SdN/`N5N/9M0^!RS!PÔ@πu/,/py`y@% SP>9@@R@:;~%`jjm$pj} `T}^$;`!!xlpӡpJpڢpKzpڣpLxi<<xlP<њ , ,0#70" К";ᐢ "µ$;tOPr0ppKpUpLppMpar<xl+r ,rq"678x>T936Tۤaaڷd@l09p P6iЯ}ŰЯ_& 6Ч| $ >678`!dp S`7"} ~'#}"o)Ѹk~r<`rp2/}`}&TTmx`Kt
Rګpڮ~(%p((` ж~'q`2qb󿤷ak@s\@&ȶ~QprC~r|}moC 
2/n llG"/o2P&Ȁ"/s |0 aK }p
QT?T`2"2"?u0<}.bK.`~O~^`OTyNTO$dN../p3dM~*W-аK?.=1@̐PC1ҿ6 _1&P@HOB1MeNp0k63ӓ,A`&BO@ـ`Г0d1"x_0pT_pO"q.5¶_ 0o(0000@e.`C.3#?ȖbKe. eo(.o0`K/n/0}}  #_~$#Ѹ&P	D#(@"Tg3`P30w"22``P@2P.`~Bpu.!<1/u.aK}O}]p<aӝb/Wu.6 /K.3ajҮ'3av`3a6ڴu01on ߠX.PpT~TT%%AѴp 0`]0p
@O	.Wd`  R/ӟ@ s"	>!nqO"3a[o4v'
Ytк4@h'
f'
U 
4@SeZ!

4 E
ՍX5 
tx4޾5'
UN%t}5}{z~y^ es$?}0s02$t&u ($%E~ ̠d`-$5tP~@_a邸qarF"3"¯03wQ3`
t~	ÔP6ҕ P}䑺n`m|O|\`23t&Ơbzr)%zK151bzNt((stDtttuu%uv7vXvw6wwx1xyy8yYyzy?yyqCv!{	jA:ޗ:skPa4q<1ȴDCeDHu2`u3 { z y2Jr9K2T`pd` ezJHCJ&CCyfD01G:U`e3pe2`(k 0.1@Q 32&C3Hnj9C
oDjT2l`&U0.AWQqHCJbK45]e42+9~np455544&Cu4Y5#Z
 defgiUjZ9T[C?]=T__~`W<ZqdLp#\CJ¡5<Zr{C|iZpWpN#\Ct;?&P#\C߄l(?NBRCoPQCJQC<QC)=QC>ϗQЅC?ޙZM#\C Y!
]]D\ g09lw0b6TIW&CK` 5`$DC1~ y"05C}w'1G+ЯA *Qu1(#1$`=`l{c$p|ށeu1*!ux&PRo)5`d dEBtu0`.Ô(`'&ȷ3TT Np\  *` @M*aÔ`@o)xq=u1 9tpu0҃5 :4(?1'5R}d}`02gs/` /ppnnz3/$%"F2H0'6P-~0|/p/0}p/~"_#~:.36P"\%p}٣? X}ɮϾ 90p0 ///.APɌ$3/ptP @א}k6
`7?"""2t _DP
0efQ	D"LION x1x2`TTxDxD"0À"x0ބ 0p$ x"0~ ~ o`Ӏ"2w2~0mn opn`dx"p&@"`1++ 0npx&3%T~TہO&"x!To`		~0xDT"d:"	F	a >߃	p 2VC x p1OdR X LҀԀi3ꀚڀ3䓣łŃ
P "3ߟD	 ̈$ Pc
##EN``#es"P"wR
"@"  )"/33@0" 3@"Ø"ſ(p8@
~0		t1?):=	%
!"*f`1B5	Q	" """BBE"`%3 '"""ЃЂ +*ts*,s_Ń
-w"%5`ᾒ*pp
sp+h`_1 p H2&2~2vq2n2b2VTu2J6e1Y1?9p(	p	:fp6

q#s @B?C_D EFGHIK?L_M NOPQRT?U_V WXYZ[]?^__ `abcdf?g_h ijklmo?p_q rstuvx?y_z {|}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ ßĿ?_ ̟Ϳ?_ ՟ֿ?_ ޟ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_% &'()*,?-_. /01235?6_7 89:;<>??_@ ABCDEG?H_I JKLMNP?Q_R STUVWY?Z_[ \]^_`b?c_d efghik?l_m nopqrt?u_v wxyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ȟɿ?_ џҿ?_ ڟۿ?_ ?_ ?_ ?_  ?_ 	

?_ ?_ ? _! "#$%&(?)_* +,-./1?2_3 45678:?;_< =>?@AC?D_E FGHIJL?M_N OPQRSU?V_W XYZ[\^?__` abcdeg?h_i jklmnp?q_r stuvwy?z_{ |}~?_ ߈?_ ߑ?_ ߚ?_ ߣ?_ ߬?_ ߵ?_ ߾?_ ğſ?_ ͟ο?_ ֟׿?_ ߟ?_ ?_ ?_  ?_ 	?
_ 
?_ ?_  !"$?%_& '()*+-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ ɟʿ?_ ҟӿ?_ ۟ܿ?_ ?_ ?_ ?_  ?_ 	
?_ ?_  ?!_" #$%&')?*_+ ,-./02?3_4 56789;?<_= >?@ABD?E_F GHIJKM?N_O PQRSTV?W_X YZ[\]_?`_a bcdefh?i_j klmnoq?r_s tuvwxz?{_| }~߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ şƿ?_ ΟϿ?_ ןؿ?_ ?_ ?_ ?_ ?_ 
?_ 
?_ ?_  !"#%?&_' ()*+,.?/_0 123457?8_9 :;<=>@?A_B CDEFGI?J_K LMNOPR?S_T UVWXY[?\_] ^_`abd?e_f ghijkm?n_o pqrstv?w_x yz{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ʟ˿?_ ӟԿ?_ ܟݿ?_ ?_ ?_ ?_  ?_ 	

?_ ?_ !?"_# $%&'(*?+_, -./013?4_5 6789:<?=_> ?@ABCE?F_G HIJKLN?O_P QRSTUW?X_Y Z[\]^`?a_b cdefgi?j_k lmnopr?s_t uvwxy{?|_} ~߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ Ɵǿ?_ ϟп?_ ؟ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_C DEFGHJ?K_L MNOPQS?T_U VWXYZ\?]_^ _`abce?f_g hijkln?o_p qrstuw?x_y z{|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ ԟտ?_ ݟ޿?_ ?_ ?_ ư&P       VBT             $VBT MONTARA-GM     d 0 
 0                   BIOS_DATA_BLOCK r  V
  d3104Intel(r)852MG/852MGE/855MG/855MGE PCI Accelerated SVGA BIOS
Build Number: 3072 PC Dev    09/01/2003  17:06:58
DECOMPILATION OR DISASSEMBLY PROHIBITED
  Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        		
	
		 	   ! "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ D                             ! %  8 I 0    Qe    X<KU $  ??W%X$3 oWX$q __/W'X&M `   `   `    @`   D`   `    H`   L`   `                           !                                         0  UT                                                            =                       $    (     
 
     X`                                                                                                                           !  	 CH-7009-A                  CH-7009-B                 SI-164      p             	 FO-450                                                                                   
 J   <   
    	 P S( | 
                                                                                                                                                                                                               <                    
                                     <                        <                        <                        <                        <                        <                  (  s ) ~(
(	
	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@1      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 	         @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +1                 ,          PY @      $AIM@             1	 CH-7009-B           C              $ADDIN30 [    $ADD_OUT               AIM3     I            \ i n     Chrontel Inc 7009 B CH7009-FP 05/02/03 #&0` ޱ #0`  -&0 	 # #&0` ޱ # #0`  - -&0 QW=  3ɳ
 Àrttc8 u.Mu
    .G.Gu5WгP$r, uu2< = 
_Y8 2óu t = 2f vf fa  s
fa   
3Sh<.$? 8 .U
u#ff3f  s
  0  &u!ff3f  s
 	  	  t.G.Gfʸ2 j j fXh fPfVW * ._Ѓ

u[ S$WM
 Ȱ@;ff  s%$@ u'Ȱ f  s$+j j fXh fPfVW * ._Ѓ

u[ S2
[S2<t<u
t	<tC
u*8 .U u	ha$?Nt
[SQRW8 .ǀt
 ֹ  ֹ .؇ u2
_ZY[SQRW8 .ǀt
 ֹ  ֹ .؇& ulGw <r\Ȱ  b <u
 V $ L @  ? u"Ȱ } * <u
o  $g 2
_ZY[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[ C@@QȰC@$<u++rYPa @      $AIM@             1	 CH-7009-A           o              $ADDIN30 Zwy#Baf    $ADD_OUT               AIM3   	  A   X   \ j o     Chrontel Inc. 7009 A CH7009-TV 05/02/03   :cȞ Y.ς~E: "^Ȟ 
*Ă~EZ m g!H
z=

 
_R 1X @      0X!@     QW=  8 .} 4 %+ ˰n  $< < .} ɰ ; ǀt+uwurt.
h  fVW * ._Ѓ
ut.t6.= u.<r
, uu2< = 
_Y8 2óKu+P  4Xz? u=2< = 
fRW8 .;Ew.;]v2Y .
ut" tRu f.f
   ff;tfȴ2_fZ`
ut
  *   t<Ru
    .G.GuT3Ɋ<u
  (<!u
  <Ru
  <bu   t.G.GJu2aW8 .;Ew.;]v $#2$
u<u<uR<uSh  fVW * ._Ѓ
ut
[!w$P!l$_ 2Z$< u WfXh! fPfVW * ._Ѓ

( #haHZU K 
_S2
t<t<t
<t 
up $<t<u   P      X ߀
u "u<u2u0[ $߳ u2
[SW2? uÀ"r22_[SW2&k uGÀ"r2_[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[:  rX%  tZ:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  i9  \:   撰68BCU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ g  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  N  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ Z  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 4  X  f=$ J  f$ f$ f
    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 9  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t<  $ =$ u	=$  w$ $       f$ $         f=$    f$ $ u     f=$    f$ $ wf$ r  ;  bf=$ uXf$ $ $ Cf=$ u9f$ $  
  $ f$         f$ f=$ 	r	f$       s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz/ZXfPfRfz$<fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytCsZ[Xfz/fyu$sZ[XSR=$ tO$ @
 fyf@t	s/fxfz-fyB@u	sfz/Z[                                 P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X    SVa    .: ^[VL  .: ^V=  .: ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  Or<u   f f  fZfY[SQR   Sr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f    PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZX`8 8 8 WUU*UUU{  'G_PQW3   f.;
: t3_YXfP >>?<u>>?<t>>?tĀ fXð              2ff fff戰䈽!   戰O     戰   戰䈻              u׾%   %   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                            `   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_vaÐ            f  f  f  f f f f TلDf f  /f f  f f  f     fHt쨎t<w.$f ffH$tt
                                    `      D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  4             D                D               E  @             E                D                F             D  i         @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <fQf%f  $f$
tppqtfff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аf/ff. f"  ؎ f%" 3؎f f  gfnf̼gn!fgf  $f$
Ћfgf  $f$
Њfgff  fffff̼ԥ$f̹ gf.f̼$ff f  gf  P$fP$
Ћfgff  @fffff   tfff%f
   ff  p$fp$
%gff  `ffffgff  p$fp$
$
f  t$ft$
$gf  $f$
Њff  r$fr$
f  xfff
  ff  t$ft$
`f̼V%ff̼b (fgff  pfffff   tfff%fgf&    f  $f$

 f  ~$f~$

%gf  h$fh$
Њfgf   `$f`$
Ћff   `$f`$
$@fPf   fkff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0f]ff  @$f@$
= u$<]2f(ff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и 4ff% = uf©f fשnf % ugfTfU../0./.f,f d< uf4fd< t<t
u掰f\f䎊fnfff掺<uff  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f̼r2f̺ t
^+;w 瀸	ذf%   f
   fʺfffʋfʃЃf3f   f̼fsf̼ fsf   uff̼,f̰Df%   f
   fʺfffʋfʃЃ$<@t< t<`t] f̼yff   u fuf̼fs ufɋf5f̀  f̼߭^fsf̼fsf̼fsf̼$fsf̼9fsf̼N?fsf̼cyfsf    t  f%   f
  fʺfffʋfʃЃ瀃vCt>t9t4t/v*f f 
 
 %%]f f%?ft  f	 ƹ )f f
   f   `"f"rf    f   tf̼v*ff̼Tff̼ff̼>ff   f̼t/ff̼/ff̼įGfU f̼֯{ff   u fuf̼
ofs ufɋf̀  f̼9fsf̼Q*fsf̼iCfsf̼~_fsf̼fsf̼fsf̼fsf    t;Df%   f
   fʺfffʋfʃЃ $<u> 9Df%   f
   fʺfffʋfʃЃ  $<@u f%   f
  fʺfffʋfʃЃt@tEv
tt ; f f 
 
 %%tv  
tt f f%?ft  f	 ƹ )f f
   f   `"f"rf   @f   tf̼Nff̼Zff̼f.ff̼rfff   f̼,ff̼,ff̼of} f̼ff   u uf̼ݲfs uf̀  f̼2fsf̼#Xfsf̼;qfsf̼Pfsf̼efsf̼zfsf̼Mfsf    tDf%   f
   fʺfffʋfʃЃ $<u f%   f
  fʺfffʋfʃЃt,; f f 
 
 %%ev f f%?ft  f	 ƹ )f f
   f   `"f"rf   `f   t?f̼ɴff̼մff̼9ff̼ff   f̼!*ff̼q*ff̼f̸f̼(
f̰tf%   f
   ffff%f
   fpf%   f
  ffff%ff̼f̸瀰`f%   f
  ffff%f
   *ff  f  uf
   f  uf
   f
   f   tf f    tff   f   uffff   f   uffff   `f    uf
   @ff   f̼jfff   t&pf%   f
  fffffftf%   f
  fʺfffʋfʃЃf    f32ɰ@f%   f
  ffff%  8tff̼_ffǊf3ffff uf32ɰAf%   f
  fʺfffʋfʃЃȰ@f%   f
  ffffff8tff̼ffǊf3ffff uf̼ȷ9$f̰f%   f
  fffɰtff̼$ff̼7%ff̼@ff̼df̰pf%   f
  ffff%ff  8 f  8 tf
   f
   $p
 
 @
 
 f
    ff%   f
   fff< wf%   f
  ffftf%   f
   ffff%ff%   f
  fʺfffʋfʃЃ
 Ћڰf%   f
  fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ< t?gf&    ~f%   f
  fʺfffʋfʃЃ
 %
 f   uf̼Ĺ4ff̼йD$ff̼ܹff̼f̰f%   f
  fʺfffʋfʃЃf f t't"ttttt	t(f   t	fX3瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼ӺM$f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  ffffgf&pf%   f
  fff$0fذpf%   f
  fffff   t	fP  f     fP  f   tff   gf&f   pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	fP  f    t	fP  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼~!f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  fffffư  gf&ffpf%   f
  fff$0fذpf%   f
  fffff   t	f   f     f  f   tff   gf&ffpf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	f   f    t	f  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   丫f3f3f3f3fffr;@  f%   f
  fʺfffʋfʃЃ@ffrAf s:@ f%   f
  fʺfffʋfʃЃ@f̼6f̨t$$Ӱf̼f̨t$$
؊f3g.  8tfg.  g.  @ۊf%   f
  fʺfffʋfʃЃ2f slPf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃi
Pf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃffAff@2ۊf%   f
  fʺfffʋfʃЃ؊ۊf%   f
  fʺfffʋfʃЃDt2ɰf̼)fr<tr2ɰf̼frtrff   % = uaf%   f
  fʺfffʋfʃЃ<w+<t'f,   2f%   f   uf    3ɰf̼^hfr
2u#r f̼@f 2+tt9 taf̼f.:vf̼f.:Gv]f̼f.:vf̼f.:Gv0	f̼f.:v
f̼%f.:GvA2ɰf̼J|fr".:vf.:Gvf.:Gvr2ɰf̼>fr.:vf.:Gvr2ɰf̼
fr.:vf.:Gvr2f  8 f̼fr$< t<sf<tr2ɰf̼$frufr3ff̼Rtfr,<t(<t u	f   tf   r3f?
f̼%fr,<t(<t u	f  @ tf   rff%   f   fffffff%   f   ffffffff   fffff3.<uff%  @ f  @ fffffff%   f   ffffffff   ffff؋.s<u uvfff   ff   `f   @f    sf䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf&  fX  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
<䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$tf%   f
  fʺfffʋfʃЃ両f  Hf%   f
   ffffPf%   f
   fʺfffʋfʃЃ%
   f     ff%   f
 ؋ǲ$2ظ.fʳǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  ItG ff%   f
 ؋ǲ$2ظff.fʳ@ǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  It?fʸf3
f  f$f   gff$f  fh  ?瀰Yf%   f
  fʺfffʋfʃЃXf%   f
  fʺfffʋfʃЃ$fd   f̼uf̰Xf%   f
  fʺfffʋfʃЃf  f̼3f̰Xf%   f
  fʺfffʋfʃЃ$Yf%   f
  fʺfffʋfʃЃ$%f%   f
  ffff% ٰf%   f
  fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$0@f%   f
  fʺfffʋfʃЃ$  f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$ff%   f
   fʺfffʋfʃЃ$f   f
   f
   f
  
 f
   0ffٰf%   f
  fffff%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃ$f%   f
   fʺfffʋfʃЃ< hf%   f
  ffff
   f
   fﰀf%   f
   ffff%f
   `f
   ff%   f
   fʺfffʋfʃЃ<r}f̼9
ff̼Ef̄taf%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ
 f   % = tAwf%   f
   fʺfffʋfʃЃuf  Gf  ?wf%   f
   fʺfffʋfʃЃuf  f  f3ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf   % = tAwf%   f
   fʺfffʋfʃЃuf(  Gf8  ?wf%   f
   fʺfffʋfʃЃufH  fX  f   ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf3fh  ٰzf%   f
  fʺfffʋfʃЃg.Ћڰxf%   f
  fʺfffʋfʃЃAfr丬瀰Df%   f
   fʺfffʋfʃЃ$<df   2ɰf̼ 
fr<Htfrf   -rf%   f
  fʺfffʋfʃЃȀπ ٰrf%   f
  fʺfffʋfʃЃhf%   f
  fʺfffʋfʃЃȁ ٰhf%   f
  fʺfffʋfʃЃjf%   f
  fʺfffʋfʃЃȀٰjf%   f
  fʺfffʋfʃЃf    ٰRf%   f
   fʺfffʋfʃЃJٰ`f%   f
   fʺfffʋfʃЃ"ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃȁ ٰf%   f
   fʺfffʋfʃЃdf%   f
   fʺfffʋfʃЃȀٰdf%   f
   fʺfffʋfʃЃ	 f
   `"f   f   f    0f  f  f   0fP  ff0fX  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0fn  0fo  0f  f   f    0 f%"	Cf%   f
  fʺfffʋfʃЃffff3f3gf	 f
   `"f   f    f    0f  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0f  0fP  ff0fX  0fn  ff0fo  0 f%"	ٰ`f%   f
   fʺfffʋfʃЃ ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃ0ٰRf%   f
   fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃذf%   f
  fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃt  ذf%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃ瀻 tDpf%   f
  ffff
   fذpf%   f
  ffffxf%   f
  ffff%?ff   f   f   f   f  ff   fpffذxf%   f
  ffff瀰f%   f
   fʺfffʋfʃЃ< tzhf%   f
  fʺfffʋfʃЃfx  ff   ff.
Њڰhf%   f
  fʺfffʋfʃЃff3ۊكrt, .H $ttfffʻ
t@fغ  ff% f؀f   ttf   ff% f;rfn䠢uu`p2<F&-4$*Px<Z0HPx<Z0H       a a a a a a a a a a a a a a a a a a a a a a a a   i i i i i i i i i i i i i i i i i i i i i i i i   1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1   9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9   A A A A A A A A A A A A A A A A A A A A A A A A   I I I I I I I I I I I I I I I I I I I I I I I I                                                                            
                   

       
    
   
	   

   	 

	 

	











	
	


		

		

		

		

		

     "!d!Bǅ 8080,( (   ,( (                                        '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽k񾰱fNf^f
8f{f#"f-f9fC
2fSf] fiܾfs<y]ff f骾f 騾f钾ff|fоfif f"f  f.f. f"  ؎ f%" 3؎ Q -pqtO  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        05/25/04BUC  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  <:   撰68BDD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  N  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ Z  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 4  X  f=$ J  f$ f$ f
    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 9  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t<  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ e  ;  bf=$ uXf$ $ $ Cf=$ u9f$ $    $ f$ 
        f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz/ZXfPfRfz$<fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytCsZ[Xfz/fyu$sZ[XSR=$ tO$ @
 fyf@t	s/fxfz-fyB@u	sfz/Z[                                 P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fX2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               06/08/xxBDD  