#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BCU ROM)  - Linux-Based"
BIOS_VERSION="F.0C"
FILENAME="sp28651.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`	                                                                                                                                 @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P  QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVe                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`	                                                                                                                                 @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P  QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVe                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  -q11  .q1 L   OMPAQ  EXE  /q11  Pr7/ I  HIMEM   EXE  e0q11  SV' D  8DTD   BIN  S1q11  {B1   68BCU   BIN  vT11  E0   INH       T11  T1   AR o m p a  ?q . e x e     ROMPAQ  EXE  /q11  Q1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
device=a:\himem.exe 
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                    MZIU  @  b
   0X        M             E
      P  
  	  	  	  n	  Q	  h  B  
     E
  
    w  Q  ;        0            y                    y  s   	 	 	         z   W   '   
    E
																	|	x	t	p	l	h	d	`	\	X	T	P	L	H	D	@	<	8	4	0	,	(	$	 								 																																	|	x	t	p	l	h	d	`	\	X	T	P	L	H	D	@	<	8	4	0	,	(	$	 								 	 	 	 	 	 	;  ;  %;  ;  ;  9  9  9  9  h9  <  <  <  				p	X	:							h	P	2			 E
G  TG  CG  ;G  )G   E
U  T  T  T  T  >X  Y  2Y    ~				z  &                                                                                    3Ðj<ː
  F  F~ F F^:9 uvfv}fvfv~hh jFRPOVtj
fvvPl
hh jGRP"Vtj
fvvP?
 Ð3f>V  tf6V Ѐf>h  tf6h 轀>Z  t
6Z T*|Ð  Vh j%h jh jh  h 豆h Ȅ~F ^v&v& =d t -!  - tHHt-3 t_ H  F^v&v&8 (^v&v& ct^v&v&   P  P  L  P  J  >P  uP  |F  s-f t- t- t- tf6B jRP_jRP}jRP~}jRPn}jRP^}jRPN}j	RP>}j
RP.}jpRP}jWFF9F}-^v&&?-t^F&&?/uF S:=sjqRP|jVStjrRP|jVTSfh  j ]~V X V ujsRPf|j]VQuhh K|jBVQFF*PFPhh> ^fh   QZ uhhR |jU>N  tC<  Svt(l ! | 9 ~ =  A  E  I jJj1fj}h j h ujsRP{jU		t(\  t h   j ؎f&fbjqRPC{j:U>L  t>N  tT  R  H  >T t>T u& & & >T u=>P  u	>H  >H   >T u3P Ht	HtHt8j uwjJ
ulj?j.>T u?P Ht
HtHtHtIjj !Ȑju+jRP]zjP HtHH>P  tD>J  t=,?h,h,jv
>8 t jYRPzjIRPy>F  t7
j S;$  F >$ >L  t>N  tT  R  H  >T t>T u& & & >T u<~ tfj fj 'F  G=HtjH-
 -!- - - 
tEfE]
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >F  tG5L$ C= M- K- (-M- 0- )fj
>F  tj Q^ÐU	^&*&,Ð  F fh fF h   j ;Fu;Vt^& FFԡ h  j ؊F&Ð,".
Z hTh,h,jy>8T  Vfh  P FPw|f,K  F4ZhTh,h,j|y>8 t3^ÐFPrBFVhhx FPyRPhfhrhhx fvyRPh^ Lrfvh^ q ^Ð  FF	,".F4FZhTh,h,jx-*ÐU~uhhz  Ð~ hh h^ /U&(&u3f     8f6&fh  f6V V= s&&G
 t	SSf    f "f9b~"fh   RP6Z f6V LLut뉐f6&SO~ uhhz Adp h   j ءX +V  &&Wr h  j ؋F&  &Gt h  j ؎f&   v h  j ؎& 6l h	hz h  j RPy
Mfh   f6V vj 6Z KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h^ ?S&(&tj fbf-   fPf6&q
f6&jFP=q
f6&Bt~ uF.~uF6` 8Fua 8Fub 8Ftf6&QkFPh@Rf6&Q ^_Ð~ hh h^ R&(&f     	 "f f9b~f6&fh  f6V YR= j&&G
 ]fh   f6V f6 6Z I=t5fh   vj 6Z f6V Ip h   j ءX +V  &&Wr h  j ؋F&  &Gt h  j ؎f&   v h  j ؎& 6l h	hz h  j RPw
x>v tjJj1j f6h >wjhh n h   j RPv
6l h	hz h   j RPv
p h   j ءX +V  &&Wr h  j f&    t h  j ؎f&   v h  j ؎&  &  FF܌VF R   N   T   f,
S h,h,jBm
>8 u_>/@R Rf,N  f0    FޣTFܣ6hTh,h,j	s>8 t>-uN   hGNu~ tT   Ft
F$p*T Ð&  VFF܌Vf,D 6QCZ4hTh,h,jr>8 t3^F  FvڊB^& Fڃ~ | ^Ð,ZhTh,h,jAr>8 tjdRPo  fh  ! h	htjRPQF  @l +FHuF F^	&x&*hj*aRFl 9F}j vĈf<t<uhh EQÐ  = t= u%F  F~}
F_u~|3Ð Ð>R  u#jDRPnjERPn3ø x&hjQhzt
{u{Ð  DJ;fh  h@hf3t"jFQRPmjGARPmjt/RPmfh  uuj@RPm>F   2F hj
PjRPOΐFfbf   ffffN*+;B|;s<F*PjRPOj F*Pux&
h@h^ jaRPkOjTQRPjSGRPhh KOÐ  jF "hj
Pj
	RPOFfbf   ffffN*+;@|;s:F*PjRPNF*PGux&
x&
hj
}OjusRP!lju,j>WRPlj?GRPk>F  tlhfh^ j#RP-NÐ  D;fh Sh@hft"jFRPkjGRP}kjtRPkkfh  uj@RPKk>F   F hj
wNjmRPwMΐFfbf   ffffN*+;B|;s<F*Pj-RP7MjF*Pqux&
h@h^ jRPLjTRPjSRPhh LÐ  F >T ut~ thh hh FP"fhh FPyIFVu3vPfh  f6V pI= s^&G
 tF  fvDHO>T u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6V FP.F~rhh hh HFVtvPfh  f6V J= s^&G
 tF  fvgG~ uj[RPeKhh jCRPMKF*  F 6u3s+tt~ thh FPdjhh FPtdjRPFP_dhh FPGFVtvPfh  f6V G= s^&G
 tF  fvF~ tj yRPJ#.F~  F ohj
SKF  hj ?KFj ;F~x& ܊F*PjRPJf6V FP-FF~s#~ t~ uw&
tFPFPj!RPI~ u~ tjjRPIF  F f6V FPW,~uPhh hh KFFVu3vPfh  f6V G= s^&G
 tF  fvEFÐUf6V FP,Ð  F u3F F~s7F*PjRPHf6V FP:uhh Hhh hh EFVtvPfh   f6V F= s^&G
 tF  fvXDx&

hj
;IF hj )IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j\RPFP`hh FP0DFVtvPfh   f6V +D= s^&G
 tF  fvB~  j RPF8EF phj
GF  hj GFj R;F~x& ܊F*PjRPFf6V FP<8FF~s#~ t~ uw&
t~ tFPFPj!)RP3F~ u~ tjj	RPFF  F f6V FP7u3À~uLhh hh BFVtvPfh   f6V $D= s^&G
 tF  fvAFÐUf6V FPA7ÐU  
2

` UvV>
Ð  >
vVF*^&F^&  >`% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젪
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2(>( 	(  ThÐ(Ih  ~ t	h7FNuÐ  FjfvFP_\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fva`Ð  FPNQVRhh fv`vvvhh FP$`FPNQVRhh fvk`vvvhh FP_FPFP%[ÐUvSRP<[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvzZfvZF
^v&  FF9F|^v&  ^UVfvfv7ZFN^v&8 t&@ ^fj <fh  vfh   !jgRPf6B DZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0fFVRPHXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 9RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRP{V *+ȃQ *P%jj fvvvvv9ÐUj=fvh 8V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7zRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wjRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0#݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0~ڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0U׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;&}&F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F&Pv~ 7
F&F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6`FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>` tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>T uFPÐFP	>T u^ÐU>T uFP+ÐFPU>T uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHF`F`  F
FFFF  F9F~FF^v&8 uvvE~ u
F`F^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  l HPhFP
FPj hUF=
tK-
t
-.t-	 NF l HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàl Ȣh7ht\th7hِ A= t= ut փ>R  t fj hN3  F, ~ ujQFÐF Df>b   FF Ffbf   ffffN*+;<|;s6F*@N*, Sh8h*F*PЃuFu j h8h jЃ]FUtKjxЃh	h^ j hlfj hNG=th8hEtÐh	h@h	hf~&CIÐC&IÐU~ u h	hfjhVHh	h@jhV7F  F~ ujFÐF Df>b   F&t j h:h,fh  Lуu&, F Ffbf   ffffN*+;|;sF*@N*, &Sh:h,j F*PЃufj hl F; j fh  Ѓh	h^ fh  Ѓt"h	h@h	hfăt"fj hE
fj h0=uSh9hVt!h:h,ttfj htPU~ u h	hfjhVh	h@jhVF  F~ uj-FÐF Df>b   Ft j h;hBfh σu, F Ffbf   ffffN*+;|;sF*@N*, Sh;hjF*P,σu됐  fh σh	h^ cfh ΃t"h	h@h	hfUÃt"}fj hEqfj h0=uh;hVt!h;ht6fj htÃ>F  tj ht$ $   , ~ ujFÐF Dj ؃u] j hL=hhtF F~s3\ F*, j hL=hvFP^uF< j hL=hNhe>T utTetMFtFj t:h;hVfj h0=thL=htÐ  , ~ ujFÐF DF F~s-F*, j h`>hFP\uF< j h`>hlh또>T ut>kt7j hIfj hN=th`>htÐ  , ~ uj߃FÐj5փuÐF D] j h,?htF F~s3c F*, j h,?hFP|uF< j h,?hlhc>T utTtMdtFjt:h;hV3fj h0=th,?htÐUfvh4  \*F.fh. U Lfh.   Lj/iLFfh. ! hLj/RL~ufh.  NL~u
\N*OÐU*FP\P(L**PLÐU*FP\P
LF*P*PKÐ  >F u7-  FV;Vrw;Fv	F ÐFP
uh h UF  >F u
FPh iÐUF  >F u
FPh IÐUFPh 9FPh -j>F th UFPh FPh FPh j|MÐ  >H tRFPh FPh FPh FPh j0 h l<uH  >H u&v*N"FF FF
FPvB\*Ðb=tw$-t-| u)^  >^t% Ð^ -t-t t-0 t^ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U^FPgÐFPtHtÐ^	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  P h FF )fF~}j v`tFP  F~s#>P tFPh F  f+fF볐>P  F  `>P t(^&;^&?tP  FfF~|F~s>P tFPh ;f+fFҐ>P uKF~}Afh   j FV^& ^& h.P F 닐FPh j FV^&^&PÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h Rfh   FRPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uRPh Zj FF  	&f FPȃtFPh	hf؃~ thh:
hhF
FP4hh FPFVu3vPfh0  FPfvFPh	h@=ظ U؊FPfh  fh@x h\h<RPhGÐfh@x h0hRPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hyhXLNfh\  hZj 6LhKfhL8 h<hD  fh@ hh
RPhfh\  h
f6Lh
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB?
hxBPhxB0
F~|hxeB$PhxgBh   fhx OBF  F~
}Yhx'B$Phx)Bj2ԃhx
BPhxBhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx _?fhx P?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRvg1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&f FPRtFPh	hf3˃~ thhR
hh^
FP
'hh FPa
FVu3fj hvP(
fvfh  FPH
fv0	FPh	h@ʸ   F CFPPj/W'
~ u3FCFPNQQj/B-FN

 JÐU>J u3ø  
ÐU>J u3Ð 
Ԋ*  f   fFffffFFtF>J u3ËV 	
tVF  FU>J u3ËV 

  VF
^>J u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR $ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûN LËNaËLaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁ~sh3P1L!66ƱH6TV66gP6g
P6g6g6&P6 +۴J!6
+3	O3X 666661P.2Yظ RYP.2YۚD^  y>	uXP	 PR	 5!~ %X!	)&6, 		3	sx		 	&, >3&= t4
 pt3u!,Ar
,Ar
ª  D!r
t@Ky羼		 		 		 U3U UVW UVW.Q
u'
t z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	~ %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;puQVWp _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ LQP,[LYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVHFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*ct/ppPvvPvvF^&*cu^&?%t2XdVZ\T`3jfh~` uoF^*&ctfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt ct)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPctou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\cu̓.uMhhtAĞrr&.hht'jĞrr&pvv
cu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvncupVvvj u
T t nĞr& \~P|z\PZ
 P|z\PP^*&;tpVvv RT uInC-c = w..piBl
n
n
nokoooomBl4looioBlookooiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^ct$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvcu^] qqqrDrLrurrUwVW3FFv&vF
t~ }F, <Xw$ FF.\qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uu=CWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
XF
NFFt~ u	WTguF u	WR&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>J tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uGuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&L=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV(3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;lvJ;jvj ;s33󫖹 +v*39d	tvvvd	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6f	% uN&6f	&h	HȰ"Cu׍D&f	&h	% uDȰ"Ctd&f	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋj	tj	F3] UFu		u { rFGFF3҃vvډWNu(t$>\ uS#5!\^[#%!usʻ 	FV]UW .8tK
Il	]PPR.2Y؃> ul	n	w1uRUVV EE< u^F \F]ZXXˣ		UWVQS3l	n	 P	X[Y^_]ZXX˃PU츪	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ)$%!3]UWVRQSP.2Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH̋6		VW_^s+_;uX6	&t	;u~zt~z^̋t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;lv;jvj3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    	              4.52  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /!       = do not allow exit to DOS  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                          68xxx.BIN                $ ( , 0 # $ :  & ' X9  ) * <  U V (= Z [ = ^ _ > a b ? "  	 Y  	  D10/17/2001  O                                                                          *2>|:fDj4Fl|  <HPd|
$.:FTbr (LbT 		<	P	d	t						
H4
P
r
|



,Jd~Lx

*
                                  @    A    = e $	      >    ?    = e B	      B    C    = e `	      F    G    = e ~	      J    K e 	      I    H g 	      D    E    K e 	      (     ,    & h 	      O     L g 	      %    ,    # h  	      M    N     P   
Q   
L f >	      S    T    R e h	      +     ,    ) h 	      X    W f 	      \     ,    Z h 	      `     ,    ^ h 	      c     ,    a h 	      j    k    l    m     n     i e 	                 Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ZZZZZZZ               (((((                  H                                                                                                                                        
                                                     XXX                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                        MZ #           ?:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         #XMSXXXX0Copyright Compaq Computer Corporation 1989,1991                                                 T                             

Error HM21: Windows 3.0 does not support memory above 16 Megabytes.

            Add the /ISAONLY parameter to HIMEM.EXE in CONFIG.SYS.

$                                                                                                                                
. . S. G vO[Ct7=uC u=. u5.>  u.>  t%RP 	!X
u<u@.. %)Kr
AtHVWP
tcĀtrv
rw
.:&M rX3J.>  uH .} .>_  t.I .Q . . u	X33XP% X. .} _^RQSPV.Y .+k .Q =@ s.Y   .>_  t.Y  .b  .)Q w	.Q   U.>h  t-.Y  .Q .h +w3.Q .h .Q .b =  t 33.b .Q .>Y  t@-@ ..>W u.` .D 2.F .I 3..6y &. &D. ^X[YZ._  3&f 3&> VDu4&> ISu+&> Ku#._ &- &, t@.b - .     u.b - πuM..& `.a. .> t
` .A a.P.%.	X.6 .. =u.   .>  t.b - .. .>h  t.>Y  t   <@u.;t%.>Z t.>Y  t.;o r
 .Z 23.>Y u.Z 
t.Z   23.>] t8 t
.]   2ó3.>]  tX t
.]    2ó3Q.>X u+. .>O  tz u .A . u.O  2Yó3Q.>X  t;.>O  t:. 8 .>O ut3u .A . u.O  2Yó3Q.>U  t
 .A '..%x |3H@ t@2Y  3ø 2.>  u.[ .Y O s"ڀtGW_

и ó3 sڀ t	O 2ó3`.;d r!.;f w.+d 3ҹ
 u?uaaĀu:QVW33.d .K ?uwG;s2҃
Ǌڋ._^Y?ĀuQVW3.d .K u?u	;Wwu?u t u
u+t9u1D  DED+Euָ 2_^Yó3QRVWsX| uT| t-\D.>d .K =uU;tU;t
 2_^ZYÇTUT뼳3ĀuBQVs3| u+3.d .K ?t@
T|
t^Yظ ^Y3ó3ĀuQRVWU>ӳs5| u-;Tw`r 2]_^ZYRZtD+T>F>)F3.>d .K =t	
DED+EE TReZt"+D>;Fwt
>)F>F>F TwtEDt>F;v tt>FD>F EDtEDED&w&w
&G  &G  X+Dȁ% &G&OXȁ% &&OVWR.6Z_^MLD+TtTUE3VRIZ^tED&w&
3&O&O&O&ODȁ% &&OVW.6_^DEDDEDLM]_^YY\DT3.d .K V?uw;uuw;uu
^ÐUSQR3FFF&F&LN?\r r_FV^\
a rZFV^n^rG*= u@|,= u4^tO^tOZY[ ~ tH^]Àt^V&w&&t+tLG +rB+FVr2GG^ËǺ ƃ v~wr߃vڳΐ                                                                                                                                         |        3                               FVNv*,6<0HtPQR6.7.w.w.4.t.t&. . ~ w9NsNU ˺3 3ÿ|&؋3ۋ.F EEӋʋ
  
  ])Nt^ 6*, > l^ u>H t20.G.G.<.G.G.Z[X*,6H.G.O..W..GËЋ3d K ?uu=9?u4GG;r*;Gr!GG;wvw;s+u
t
E uUÌȣ
@H  Ā3 VWfPfQfR( f=  vf  vfZfYfXƋ_^fVfWf3f3f3d K ?t&fffOf;sf?ufff;sfǃ
fγft2f_f^Ā VfRf fZ^QVW3d K u?u
f;Wwu?u t u
u:tHfu?fD    %fPfDffEffDf+fEufXָ 2_^Yó3VWQfRfPfSsf| udf| t2f\ffD>d K =ufUf;tfUf;t
f[fX 2fZY_^ÇfTfUfTf[f[fX3ĀG QVs63d K ?t@
| tT|
t^Yظ ^Y3QVs(3d K ?t@
fT|^Yȸ 2^Y3Ā VWfPfSf f[fX_^UfRVW֋fӳs?| u7f;Ts r 2_^fZ]fRfZtfDf+fT>fF>f)F3_^fZ]Q>d K =t

YYffDfEfDf+fEE fTfRbfZt(ff+D>f;Fwt>f)F>fF>F fT\tfEfDt>fFf;v ftt>fFfD>F fEfDftfEfDED&w&w
&fG    fXf+Df
&fGfXf
&fVWfR6fZ_^MLfDf+fTtfTfUfE3_^fZ]VRZ^tED&w&
f3&fG&fGfDf
&fVW6_^fDfEfDfDfEfDLM_^XX]fDfTf3d K fV?ufwf;uufwf;uu
f^                                                                    UfPfQfVfWS3FFF&ffNfn  \  f^]
  ^[VW*_^=  3Ɏf
f6&gf4   ffNfgfgfggfXf&gf4   ,= u:^tO^tO[f_f^fYfX ~ tH^]ót^&f&t(sDfGf
f+r;f;r.GfGf
ffffffff= v೧UP    uB9Fu;~Ut~^u- . "W
 Î$"e
  3؎X]X]..fvf~f   f;NvfNfQ6>fFf&e>fFf&efYrf)NffNfN2.
 .;d r%.;f wSR.+d 3һ
 Z[u.?ufPfRfVff3.d .K ?uuKG?uBfGfGf;r5fff;Gr)fGfGff;wvfwf;sff+u
tE fufUf^fZfX= s.#þj
C.6.0.2R.4 .<.>	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t)R uMdI uD`@ u;>V  u0d0 u+%) u$d  u` u>V  ud  33d$= tr$ 
t$ 
u    3= t
r䒨t,&䒨u$3䒨t$3䒨u 3ËR?Z% ;u ÜuR ?Zu	 }  `@ 6 6  .A `  .q  ?퐐.q   2 ?at4 u/d+ u&d" u ud u
d	 u 33d$tR)Z ôr &&?PTu&Lu&Gt 33S &>P OLu&&> uf$<um  [ôr!&Gu&	t&u	3v 3Î&& =HPu& $u 3Ë9t	""S.[u.OU .w.O+ >A "   /"8!!  b" 8! "!!  ,"!"  ("`    t4>$ u?O   V 3A 1t.t'?1tt-9>V  tX  
À>9 tV  >V  t3>#W>#_     PSQRWVU.> &]
t~430.9.&9B ȎЋ3 .9.9Ћ.>  &E.} ]^_ZY[X. p00!0<rP C/2<tD 3= t9=@ sP.I u?.9 u2.9 . . u2H3B3.#.> &E
[i4+.[ rHYdrt .>C  t	.94r( .><u	.9(.> .#&E&M33 &. &D. Ü3PX% = t# PX% tt 
                                             3S.w &&Btk&Wtc&G+SP.D .F  .I .6s Ȏ G  DT .G 
tX[3.D .F .I .W  "X[&G  &G.6s .G  [03COMPAQVWSR+ u"&&Bt&Wt.I .W Z[_^VWQ.>u 4& Y_^ZDS CORP &.& u	sEE>E  E E  .I .W &D  &|
&D  &D  &D &D & &D  VW.6_^&|&D
  &DO,&L&D  &D  W.6.& O, ui>3R   .ZO, 3&D  _W&|
&D  &D  &DO,&L& &D   VQ.6Y^&D s&D_R.><u7.>W u.` 2.D .F .I 3..W  r.<Z0s3.+k .Q RQSV3rCs37ú@ .S .>9u$   @..6y w&. &D. ^[YZÌ.c
 .}.s ..-.6.>W u"VWQW%0 .>s % .>` Y_^.><t	!Q
 3YtRZ0!.Q . .  .S  .I  .+  .+h  } RP53Ҹ  ! N9v    |K9d.>h  t.>Y tg=NG.>[  t?i5>3Ҹ@  EH9-@5'.o =u@ Q
Y3 H9.>< t5. 3 H95XZy '=  tPRZX H953.K K K9K9ù  ts-=s( # ='s =s =d s =
 s PSQR+ك ~3Ҵ tu.!ZY[XPSQR=  tʸ;sP0!X
 3= wZY[X.# t@.d 
 .K .#.d 3.K GGGGG
.f .   .    rPSQRVW3Q Ys        | m  cQ؍6O,rIq,? q,5 6,e ! V3=   B  >9 ^DuY __^ZY[XS û&?EIu&SAt[Ê$y<tRL\ًDtH 2PS  :r;r[X[X2   @ 2Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C   `Ȏ3.- ar< r=.>.t3 3ҹ &<tr r
Q B$&[1.- Ȏ؎  ?   . .Q .a.-ÉEUu
%-`Ȏ3ҹ -  -3   --PXs4$ sBKua`3ێ..CCt;&$<t..3ێ..CCt&$<t< t.. 1aaPQR..Ȏ3ҹ .  -.3 - -ZYXð%pq
tt.d .K ?t
        
HIMEM: XMS Memory Manager  Version 3.06   
Copyright Compaq Computer Corporation 1989,1992.

$
Error HM1: Unrecognized A20 hardware.$
Error HM2: HIMEM requires MS-DOS 3.00 or higher.$
Error HM3: Invalid command line parameter.$
Error HM4: Cannot unmap the Shadow ROM.$
Warning HM5: Cannot disable A20
$
Error HM6: Cannot enable A20!$
Error HM7: Unable to unmap Shadow ROM - memory area is in use.$
Error HM8: HMAMIN parameter value out of range.$
Error HM9: LEAVE parameter value out of range.$Warning HM10: LEAVE parameter value out of range.

$
Error HM11: Available extended memory was not found.$
Error HM12: An XMS manager is already installed.$
Error HM13: NUMHANDLE parameter value out of range.$
Error HM14: SHADOW parameter not valid on this system.$
Error HM15: SHADOW parameter only valid on COMPAQ systems.$
Error HM16: HIMEM requires an 80x86-based machine.$
       XMS Driver not installed.

$
Error HM17: Move Block failure clearing memory - unmapping Shadow ROM incomplete.$
Warning HM18: The High Memory Area is unavailable.

$
Warning HM19: The A20 Line was already enabled.
$
Warning HM20: ISA memory above 16 Megabytes does not exist

$  COMPAQ Shadow ROM area recovered. . . $  Minimum HMA residual size . . . . . . $  High Memory Area available  . . . . . $  Total XMS extended memory found . . . $  Maximum extended memory blocks  . . . $  XMS specification version . . . . . . $ HIMEM.EXE is an installable device driver that allows MS-DOS 
 programs to access extended memory using eXtended Memory 
 Specifications (XMS).

 To install the extended memory manager (HIMEM), include the
 following in CONFIG.SYS file.

        DEVICE = HIMEM.EXE [Option]
 Option:
        /HMAMIN=nn      Sets the minimum amount of the HMA in Kbytes.
        /NUMHANDLES=nn  Sets the maximum number of EMB handles.
        /ISAONLY        Manage only 16 megabytes of memory.
        /LEAVE=nn       Do not manage this amount of extended memory (Kbytes).
        /SHADOWROM      Free extended RAM used for ROM BIOS. (386 or 486)
        /ABOVE16        Manage memory above 16 megabytes on an ISA system.

 If HIMEM is executed from the command line, the current extended 
 memory information is displayed.
$ KB
$.$/INT15 /HMAMIN /NUMHANDLES /SHADOWROM /SHADOWRAM /LEAVE /!SHOW /ISAONLY HELP help ? /WINNOISAONLY /ABOVE16                    ptlcascade att6300plus ps2 hpvectra acer1100 at                    .:Ȏ؎иB p0: u   L! C/=<umøC/<< E n ~<Jú>C 3  <S<*>$ 3X<ô <= tg=ú<=3Ҹ@ H9ô< t>tt	=Ãu
s; s8PRB>XP3EH9X_=  t m>3%H9}fPfSfRfQ<fY   fZf[fXfPfRB>LfXfPff4 H95fXf[f tm>%fff H9fZf[fXfQf
   f3ffYftfRfZ0!s=r<ô< t	=tú<u<fQ<fY f; ff	<3ô<R3=u}sXQX;|ȃ} Q 3R].!X
 ؁ 	
؃	 3R0X,Y        A20 line currently enabled.
$  A20 line currently disabled.
$
$  (Additional free XMS memory could be available for this system.)
$  High Memory Area available  . . . . . . $  High Memory Area not available.
$  Unable to report available memory size.
$  XMS driver not installed.
$  VDISK loaded, unable to report on A20 status.
$  VDISK loaded, unable to report extended memory status.
$  Total XMS Extended memory free  . . . . $  Largest block of XMS memory free  . . . $  XMS resident driver major version . . . $  XMS resident driver minor version . . . $  S.:33Ɋ  u Ȏ & >BB^ [.1Bގ6 &t
 >BB< t#<
t<
tg rF&BP3JÊ< tG<
tC<
t?< t8<	t4</t
<-t<?t)F& rF&B<<&:FWSQRS3Ҁ<?uF<
t!< t&?hs.1&B[	[&NZY[_<=uFt"r=? wt
u.o ú
2&B.h   <=uF~t-Sr(.;Q w=@ sm2;.h .[   ú<2&Bt<=uFk3trk= w
t.K ú
3&BO?<=uF6 r<oft<onu!/)Ȏfr
tr
.<ú|3C3&B  Ȏ7r
Er
.<ú|3C3&B .C   .<  .  Mr.9 =  t.<4&VQ  u<A|	<Z FY^SQRV
 33Ɋ0 |	wF^ZY[V3< t$<	t< t<
t<
t<0|	<9wF@3= w^P< t<	tNXP< t< t<=t<
t<
uXVP3ɬ< t<$tAX^WVQ3ɀ< t<
t< t<=t
&= tAt|Y^_P$p  q<1t<3uXXȎ؃:
6Ð999BBBW9_9k9v99P99999@@*A@Q@Q@YAdAoAzA                                                                                                                                                                                                                                                                                              	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]e&Hj 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'Ś1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,eT !"P.0S1t	C11(ppc1@%#9	,vInr÷ypD	Shut2l/down` P~ %0Ѳڡe K۷PIN: [5]Nxoq left0
ERROR
wY`ha߰A}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  fffft$ ISvݓV Q'  A    ~        > ok    T ij  gG W e M AY 9|@. 0MF  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .hp%v PS $<t4r w[X ȱ ЍRhf`? ^   	)F 9h)h*'h"fa ؾ  D 30"0r< tF1s""!ؿ,: @ Wh)L#@߿EOFVz!!^ ?'!#!ff&+U= r&+=,=r,W>&_<uc.&+
&)&'
, fgh  0 pqr  <ABCDE xyz{|}   *fs+PfSfQfR*R ,}&7B r
& 7 7D0B77fZfYf[fXvSQV3
Ê^Y[&. t".FuN.PW#!M _XUWfVUSW! &fv߿ h @޿RFA~2p@=,ك!IN@3d;^
u
t_@N_[]f^_SV h^[þ   RZF10=ROM Based Setup OKEnteringJ. `.> tj   _KaRMPM 2NtM+ 3P@1  p OBQ	Q`NON2OKú !t
0N~`Pt.Th'PXh/(F12=NetworkJrvice BootWake On LANAttemp-tLto"Z 5Y\D]`3Phft6Q迍 r	QaM8
!tU AOJ4SE_ bbb6 a WR)ddbbvbV3<^hkWr$hs fuQVuNs	2Ps?SQWVRVtVuy3 NF 3؁Æ?	uCFG?~NootpGf`h9qq"!v&hAssfaZ^_Y[kkNotebook hard driveH]wMultiBayJ]DockLbJCzbz(top){|bottom)}|left|@}wFloppz  USBρCD-QJHxDis\!Supe9ryNICυj11ϋ23 oߕ? _ߞ? _ߧ?4	Rpmpp	p
ppp

$B`~Jlectv[DeYͿ߳͹U@| aond [moxthe highlt[your choY.  PresscL[ose.Seconds until au atic defa`z start:   &<(d$';!ZipxC`t= Dr= k`d h S0ô0."!&t2
_ 1
I 23؊' tA<v<st1& 22
2Aʍ4	QYAr ö 
B.
*}РV `T+jjj(Pj% # ߻ 
z  Џ  AO  72g¸
   t02
32Ɋ  F8tF3 $ ZuqАq MURVQ0h.,.L.T^Y^Z]S.*[݁QSVW/ s&Q.<.-00?00.AAOY_^[Ys?}QBo
 qu hP⾲ t0t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}@o`2bXʱd ۸

r
;w2Ҁ`TJAA1ogFYô.*<W2W0? h. hf h
/ hN?i9,9 &i@ 64gf.fff63cP i<iif1B JCPQGysrPR#1 ZX .>ohrSHfPS@  uǀuh3<tkB `:.> t.Ñ6Wf`+2f?@df_f_:
Qf @gf&=TDSSu  ff3gf_uf.>f^f_YPGQRW5Hr_Z@<PIVW TGI$tu!t쿪u ܺ&_^I6W e$ f3_f@<`6<(A,-  f$?#/#%aSWQR uePpq4,XZY_!1( hq&'у<.@3ɹ2 uh}Z#-¼ P% = @uXu)-@haR4       P`  d `7P7h7UT !X?  5	4   @@         ;  ? A0  1=:,90{ 64  68 ?( 6*< .> 6bB `9,> :A8cBh@d@ f<95 !@FFF FF!GqG~GC 6 @4I. UaJ /J. pKG.+ rKaJ0KJNF. `KRJaKQbLKNhOG~6 NJN>O!LN S0GNp9SaS
SGaSLOp< S$*SaS(SCaSLWO aS3S@aS:`GOTN 4SFNaR`]heu<GD;Bt FQt &>&:@  _<@_fYf8_t*^~^UzC_|@_sl\&>> tRc ~rE^(&Gf3C h)Lg&}U  G_ 1e < t&S^r c~Bcc3d&$dffgah@vv\f3n2c*f&> uf
ffKf&&&fCh0Aqo~?pPqqq @r#q r\h`ր@!x !x&&vSQn3r*`&&&@z zr{Y[$bfPf fRfVWf93ffCf[fKfSF0rw!0cа K I+rEn_0f@SQVW: u3_^03t3!Ŝf} @XM r;g7u'P u" hh
Xh7PRA U~fW Qt% s	 fU fff>Qfh7j3-fpG g&; 9u}7)f)@f g&~/u!/u/u/u	g& x
ttx3OrwnfQǂ 񈀓@қEPf~/u/t ߀}	;^QGf &?ϥ/O oϮ/O oϷ/O o/O oƏǯ/O oϏЯ/O o؏ٯ/OoPAfUf.LPu hPS05rWrRrMPtffű@| pV t#Br"px#   / ' y> ?f]  fUr*6Б  R Z ?rGq9?Kuf] 
a~ rCF+ @g3cg&8E t@]fEGx #R~m r>U t04~Qh 9PPf&xW{ r^ r
  GC_>>?t$Aߊ?$wW밠w  _Wl  sq_  Q q0 ߰@B ?  3 S Sp' " 	P	j 퀳cAQ/A
?QWE
uptPGX_Yù
 d h%S&xs@
P <<uAbuĀ ~PR? ?50 < uZ0AD t	A50 60e\0#gf$fÀ<t <t,<t8 o\ffP〃$
"D
D$
#DDff#Df&f&
뿌T !t#a#!+P%
D%`&D&2'''뾒Sn h 2%l  }% @H EJ ;fk I b% pA Gh	 I
 h q
 og xf % $h e ڕ  ,o pQ*i ̈́ js H -m  f A C B  < 7k! pM" {k# Y( iH$ q M% |N&P-j e* hd _ ; %' p) lu+  Y, .W- / 0 N1 `2 AB3 k= > k? @ 
lS &A pp k5 %m %6 k7 wH9 fG BH : K4 gC Y%D =JE NhF %IPJ D. K UhL HM N NjO TMP lQ 5R V fW 8iXP<Y AZ t%[ ebc Je ^fg P%\j" f"$ @ ؠ   !  f   3"t$" .D
PX% hX@ .X=X@u
_^r%YPL]
ظO!
N9OIPW;f&E1_Xh{UҡhcTsThUf%UT h+[vXv[ HYZW X PQqR0> 3_YXeqhc[^VZ2hBX# _hЃw> &=tGDO P)%h}s_s	Q'W   ! $!f` T 'ew@uf *GhLҡ uOphh
/fa}vP&F XXfp	 ff3uf `  ppGX}Pf`! afv߿ hҡpt<Pt<pu2fa`3 zؾL &>v&DE{&&D0u>u dxzvYy6z x~Yy6zj@ tBb}{
Ȁ}	Ҁ>b33S[tS[
@b2[sM3 tthCߊcs
ߴJhcawhҡD
ϰ< +DuL
p
E$ߠ<uЋD
@sd
{#r& ufp}` uL
 J6 6ju9  Xb6d &uh`^s	\
b_uc~ p D&}?u  t&Eb t Ћ&E^DЋ&Ef߀w>t6j t.&  t	&  t&xu	o\	PSq P ?ЛR؍>_3& ?W>	_[Xt+t#  xt  t w\迸D@PV!$!"桾tXh{1x6zqG&  g^Xŉhr㉿r!L	pvTt
v*`Wŉ^V'Q豰$<v @u<a	3  v
p
u$@!"<u@!P>ȷX\PRt\:!1twhG4!ă }쑹=ZX0
`22}Rǿ& {t5ǖ=ǆtOuŉ0: u	t!sŉ  u5rHps
t!]&)ǰa׃/]3`Phsb  V @u @0^ 3f`G@f_%ޱbb}@ͬ!U!  b ٛ&egWʃO&MuO OfG2tM1t$O1t,t"wOʋG%r Ǿp}MoOg&/ @ɴ誋P
"2haG_kרt<uLD8 =_7D D	 d
zMQQbtSR0rG&}	r??23ืt`ha&E$	&M&]`.'	p%f rgtﴱS߀Ϡ6Uڀ ShF 
~|h}ЃQs܃]R]Q]ZW&= uA6Pë)
hë
 m_P
}t  U!w#w !#` #hS5 0.-.M!NPtI rJ0.58vuo@L@B 0gh{q.haW$
1gD {hN
hYkh@[X_Ë
`PS@5[X SϲW1gHʥ0LR
`gZ,<u(fPfRfffP
kfZfX,Z AvGu
pχW PS1g у[a$
 @vSQWf3< uf
<u	fpv#@_``֎f?tr73۹ F
t):u%RD	& hȖ & 	 ϰh})sx3+a]3 
3 b`. 󪽍 Sgt : Oiu jtVZ& [9 r6Q- r*0$&' t&f!l8+ \'q8q80
vAr_'+ ^QQ}1s4 0RZt8t hH)  8A5YQ7 ?][r=u(B% = t=@0YWV@[rp3+S6 
`HH1zE&EIQ,I[Зr50p-PuS[ u Mh-xfD^%1Fq8 @쨀ou$PuRuZDq8P=۰uObRRZOPP=ZORWV 0  PhӂX@ @WaW-o
AXrxz`W/2ƀB@?\C@h?r@D]a㳰a/@u,uYPP
@qb

+&C323&Yt _eeX
t&
0  VggRh5  Xreeekg(0g0
u7gh^Rh: >h8ip>rlhRh? jXw ^PRW!.&eWAxt&]wt&U
t ˀA9v]x_ZXRV3һ -w62C.X7/XN  Zhӂ{_ eW߸^ z`"/Oo">u _ '. + (&8.fc(.f3fu 3 Q>@s:yuBE&8Uu8@]
R +B&U
ZKؾ&80Z1ZfYB\igmqr}XRntfUrʔހRdÃ?h}rXm
<tZ.ێPpsVPX^f0  X5D
]0t`/"ޤ8<
>>Uf`؎ Fwq:.  ڎfafSfQf.k:ffff#fYf[VftGf    ^:Igf;t&fЬ \6S	FPݐwf^ë`2r'ۈfaf`+`f *faPᠳ3_X.>`}:  .еTACOF) Q&ϸѷ	& .\: Ӭ%BSF5^: fFf.k:`c:F.o:f.>k:E.o:ũ t@a:ttY@b:tNpǺ @SIVfB.qƾp?f;VrT%1ʝܠi PQfRffffg찊r.m  \:f@.ffH¡cՉfXfq8df33us?Is*Vf+f;wfff}33R·Ug:߬^'RS$.xpQPɠ`333Ҹ  QW>PHp_F
3}5upJE#ȩ t0 t0 A `t
Ήt} tWM_ }   ؉F EF^V  SV^P4Q@a&tY&  
`< tr&\]&\U@
&mNd 
S؂[u<	F&ߊ 4F^[_Y3%F F.Ъ}1-0VW}.ًذp?' Or_^Y[XWfQSg p1f{t
!p[fY_` t =$PKnPu2Mء'taË6Is } tp( ` j MF&&E)oSRUVQj@6^]ZpsV` ``II^X~p*F
 ' t#IpIyPIF IFI袻 d3duhZ:Ku`<Uuùd `:hj&4d&&;Xqtû   h'r& h39PhC%` X!$!   °sokП+ѕ 
eh;r   t0t 4 a)h>F|`' tKu'& &  
 e] "`h~CsP<t<uV/u0(u?1R*`Ph
%5X7h(C-50 % P56 z'@Wt[2s#7_ P?X73#e-1 t?<<P>`Z } / `G  в# 3 'D1pHÀ   ; Z x     0NP`^~(bhXr1fF3.D( r 
0ވBFuр~2wFd#-00
<2wd8F w(R8F wIT N@F ;t
 u@mF^KہóD.W~r@V»/  aPXû< fPXy[p[fﻀ[f @ffRfP"f!Nz
 ffFf3fv1NZfFsfBPff 1 r9@`f3ɐ`pǿ:f edfaÒKfPV`3v޸ͿrF3PX

S,0<	v	,$F.[W Dd

[Llflmmf `
T
ST o#p	#p}
#pf_Cff  fv@kS H Ps_:FP
uf^fNf?V_f^h5rPRr0Nf:vPvVsVtF Hshsv`aЫbh
àff  fffffX󢽿~4 s6f>f>f $ f{!%gfg`pG0H 9 󤾀I% a<P*hr#P,SVW0fQhÿYÆ2۰u%q(th~ </_^[øPRhI>?? (*4:@D~0W fsQ   P hfChr}ZXoRPSgS@0` ػ 7 ?   A #pq$ q p3qð &qȡ Ā?u̀>t(% (tܥ(ףu[(`%û 3ɰ<KuP;EhAC_0sG-~($dq - t+==vP P ZtP_a XP 
ہ?UuC33Ɋoђ	u u P)<$ 3@%`# Pf^ Xe d&& &0t h,~򿣶30 h
t[( Ȱ t
(ŀv#t_̰7轰5أPXav[B8v&> 㿟 h`t`_P3 (u $h0ĆDF
#ѶVIss衺sn0L uf2h̑SZ!YuP腺uK 
wAL2 Q  hPu= Dt= tY	|Y.L^!r@Fh韷PfAF]s,Luݔ0<  ?QhU;L `vDFAF `01GrB	r<.M )(.M.Me.M;a `6,NPrAV(< 
u^V h P ^(P*^` 2z4A SP( 22X[úB $PQR  ?ZY /Oo/Oo8ft`M00~ xriptrakfL+ كpݻr$kwr/f+D`f+\ r@ .Mh@fa`M PR)3YPR
`&Fa`ˀ uht=Xh/T6 r.>M.Mpu觭
|QR.M|h f3f%  f{XURQSWF^
D=@L F\ ^0F\މ^t
;v F;F
 < uW <Vȭ22 IF ɿt%P%~%{빠% #8t
` @uPj Ѓ;}
+V 
N JZ=`uAN35_[YZ]`P &X&}`PQ^ kPYUkPk~`]]] /013?4_56789:<?=uFރ6.u;v?0 >Rh *YRpQwLQVptf&YCCp*KCC݀  R 3Yap(SRP!?[pt$&%<GPw  	  s ct@  <BMtf3`~..&u?<t{`IN O`<PȯP20QMX|r
:MwRU3Mt.M!VfGenu fineIVnteluxC}=sn=r'=vp%f2ft P tK  fK  pB =  p[	tŀuvrMr f^@3ta5uZfDY $<@tK<tG`KF`H$u6fac5 ^ۊf Ff#`Cta Bt	]{{f
!off.` , 6@gf.ff0~h
/a0A
SQRW3io hN.Ttw_Z"SQn=xxohe鳋Y`Ѵ?؎ W .BB <t BB2Jt&ݾ(W s  8u}Qt@`23Ұ
Sh9Ssmt0`́ y autyi at]U y[aSR  4
^VZ[`1}-1V0  h=%	 hal
 "B0ȜPaԀa$8uXRPQZ0QrtwvYu0ѹ }R wZPhG U2<U@Ju䋧uJutWfgff屜@{ q whȢy u
3WҸ w%v۸v آ
 sC)֢ uPs~>tD A谁0@t07mo hcmܝPl$hXʢo 0KBOУ

e0  0>?` PH&i &&g & & & & ǻp0>tp @սVWێû0 ۾@Z 
 _^1&>r 4u=fSҴ`K  WfÐ8f[P     f     @[ű@"`R[j	r>@sЩ _  ` ` 
  "# 
 Uuo 끹A t&r .s t v; tմּq0>d" e@3аffXfO  f>  <  vff) ' Mwf fQf.Sû @!aA-`?wfAt@ +&|}л~ÿfyr S׉# XP
8t"*e t.xлy{ 0G5.л n21_ >  s  @
Aׁ.pK u{	t R.ӊ.O#5z2&  h~qh }P̸ hqh Wޱ Ш t>ar{Sh  } f%Џ"S^ j j h^ XXyX¥1uE rЦSh#uh
}[¥" tE2s s1|1x{0y t #um1}/  tE. z0 
U0   t!E@ }66ct1@ tat axS09pv%մ` Dz  s=(tӴU!RQк[SW&L 2Y3ۀ>u
 0>Bu
>@u}pK>Pu>L rpL wf@rH0SVWU ]_^[s.L W&O  WQSL O Л33ۃ pKt[Y_{uᯨ@u$BSd.3` Q-!f[U :tu
9 wpK"RtuL 2}p_[WSPR`ZXL PЛ6	 &23 G&C2  &Ef d r&u&54X& yGF 6n

@X$OO&2uG&2%& !Xţ wpK[_Ql@B PAhȱ 0(+ `(= uZ0()t2nSRUfVЌňL f&7f u&Z&?Zu `. G&!0 &0>tL *B6  80t L "12f^]~0VWf ~@s  !XfA33f0 OOf?  1sc7̀r_^n3WV p0L
^n`ॎ31s8 ׫`
iPh DTDo   <^Z|= 0 ȳ h`
@w <l  Q Ba ( { BW @`
 BL H`
^ BA P`
 B6T W X2A```
 B@߾^Zq4A顬a=|\D Pi{S閥 וᣋ 반LL SsdpLGOq[ng
u`$XVh[&C!!4viS#! TPQWh9 3 3_YnV 04PQ= `t; չ @fY?X "X@؟SPrW
& \ ff?& X[x@ah  @3 pr  rQlPE `E h` nfRf _JhrOFcf1lQ   hbX.f3  <t. fi~ tq.ri."D.|u.:DtSIj^SjwD:jSjr5+jSjs&jSjv;
juqjPjQhj
?c8	q<qq-tPQRau!&U$`Ȱ hyc~ZSQW@a$a  hq hOzg{>|E{_92揺 TCA6 @QC@p4@;uYð!$h|àf`p3}%|f`}\ 3垻]0Tu5fa3.nhpp{F`
׬xtI艽h#+
*1;/Pf`  f  ^6a褩_.FvA~@A>:*&}t#Mth9tb {uu Fco3!zd 
  % 1~gVcWUc-w w"hy0rV(@ #U5sr& U/f h򊥅F{ 6Dgf.fffȷh
/rV@Cfv7h~cefFfP0O$aq~3d Pqg1_fX0@إɆ 𦪃faúv00a a>
 O054%  0rU `Ga`+a|5|]u,ъ' i!z(PDO`
_0XpP`W 3 .l3|d"Z Xp,ðd[`PdFvmt` I`a@QBZa& <`s$3	 +0!,`0 `?&XY&B{ เ| aFd`ؿ@VE}&؁| uM9NwNVuӃ~ t"F= wt% @a+y'Ã@@hrˡ%r [w
0" K8հ\ ]W@]5ִ`5h#wq@   !	 @hn a ða,ct5 t2D߰aU t tfА2f
 0㐁Genuu#fineIu~ntelu W`3Ҋwt/.;t3H5'aUъXP ÀfdfafW:f1VHg~f^` GHg 5k pP|@|`p'@2D h<Ȱf``4 ӿƒTePfPfQb0fZfYSRŐ  %_=u`??2
^[ñ `F0 e(f`x7r60z1rE2s1	
*2s' i#ܨfaq7
tLx	f   2n2<  C"%'  B<7 [xA( 3@ @urf uipA3@s.e;oUn?#	 wLVx>P5u[%؀޺ChPrVt'M9'(˒)PjFcrX?~dr  P5X@AXSQ 32Pu)|"/pf`68;,g edwRfWh3dd
f:X  `"	  "	@P% P3ҧfP::X#<Aq:h<l:vj; g=>@f@
<;=f
BfB<><dD	:6ϻ Y;sQSfAr@0;@>2?fƃȠ@tI0fXffA
 <[ffIY+vFq_L2_& uZ=PrUf%   uCfy*Pf=Q t0Q t( fuPDf
0"P`huu-d pn԰B#*_F&Z $K'h't1Z

36x @ hRF F hCRPwXkt __'a hn
wళE&3؋

>et. h3@uKhg`Ԇu;.9cܤgێF&% < t<ut
u8ùXtq>䈰 et2u  w & PPXt'v
t
t@ h#% r/k hRPr>u` hRs?u-]&>! rxr{|RzsppZuthZ,uuh	r`	߹ `'Zjjw 6u`S`` FF ph ru
Vy@ yVz  sӀ>t !$!~$< u{C` 
WN<̣2<ģ	$ܣ"桻3`Aʈ.7vu1ņ|wd[@@TYP=`lt w
uP2Ɋ،؎} eȎ؊ht<u
ȵsӊE$<u&w $ěF-"L  N L ߮N  u û  t  P؈[EvÐu
|j jӻɈgIl(!!2(<!`V^6 Pcsyu$i0G|tY|$k|~}|.#KY .t4&^ t<r&.w 3.\{  .\Ev.d nb  0 W	x .|_@DuQ&~% P\PMXӹ
 z.:t
Q ._
v%XP%8Xr6%/ȸƸ{Ev    PJNL p      QKOMp @{t  t P(.DG H hCܝ hvsyYhuɞ huɒ AE^  f  Pp m o 
v %&.|t&ư
7&r"s$.:Dt1րKu
؈ Ev(Ap/" s	EvX&P 3C n H r{r`2wth!dڰvߐEaVRQSh}~guTh,J^.@68u,2
t&6@@t2 s `ޝ[YZ^S.(cvX<?tFh)LEvjjjj P% &h/(\ hcv$&bt = ;t= Dt
hG,[5WVSp̀H1
B[W Qu"1*Oؿhw@Ct`>J=Ot1 0К?#-_ rhqP0AAsv^7Rq0]!l]^s:^ a}Q%_ S^bt-$p<pu} ʈ7v^ c4 u1G hR 0Z÷h#*<o÷	E
uhe5R^? q  ^ 3'aaav?~8af+  u@"t@"3P&&WXfu33ff&3 uFȋUq+0h|L $5[Q?  :NQ2 _ ?AQ%V 	
1r짋F H@0VW 2_2v't"h 2t
u
2Ձ ߁
 @2u'2&&ߋ&E&&e?
td&Ep&&&Er(&E)&E<r&}	r'''VW^2 ^2*'
&}v+0߶h}PRQ3 70
t%0t21UY3qRPSQY[XZhj$!uSm
g@lv6 _> EYQ TYXYp_Ŕ->7v: tO:Tv<
*6vh9&&  t8V`t'[ su yq,6vrBy{6$ $ `& && pFE`dՀdAe`P`  XσqU @p
  .y BdMB把䇿8uGOAO;O5O/O)O#CMBOMRRy66vPXL ~K@ApWuBpWCpW֐WWXÜV`t𻰀v6v6v6蝊`<;weĿS]X؊H<wM3ɆQ#"XR< r_YыƊȊĴ3Їу?ڕb8 l@[dɄcWIlhu@tJcc	c2c&6fPk; 2J
{_f&. F"E  憀&k !< hP!mu?$f&PoBpÊ$
ò߀ 7?u%qtfuhs$档"&A@Pf  f#f#f#f#f#f#f#4GfPfSfQfRVW"hޓfgH&
Lx6Uff
fh~f3f3ɹ f0Q f+f ! KPHu*XHآX$a3ہasV4C\`ѕ a^p_^fZfYf[f43hG
  !)`A3h┿tKÆ?q1tu*Sٛg twt	t@АuG⻹ D
  !u|} u
qt	 Da`
2A 揀 B`s< |&	3gyt` u@uu  -&At
cmC4KBC Kernel: ?xx.xx
 /|`pn ~ؾh^0 t? p.`<3۸ 2ҹJ%qTaÍ6r'!
>z[VWQء $_^t h=3n;r Or	. f3hh.. 	hftdv t
Ah+ CgSAChD=  t]bwX,s.>߄
Gpf[ї<A t% u?? n > \c Fdef Fc~clp7~e uQC9  hp
e%hBFe:Ff`r, h Fd@~;   	:  <g! ht%qh=ChXíaf`Wkp!Kh u>fB SCA[t$ ! h=
ĭN rpu@4f`   F^ö/ðPG XSĻ  y ,  o   hZí[t(t@tU,e 6,uؿ ' h9
Aÿߋw6."*ܿ*u/.uvv+؀u/U2NfQdYF :uE14]ñ1t
t
u
t#u
tNt"FF!u3! :5tFFdz ulmF:_ uYTeb +u6FO1setrFff`$<up  jjj(j	R% 	aURdhj2   $ wh`&RZ]|RKZr@  t0DCRQ QKYsY2製A$
a !/u$6u5wZpf`L.t)@3*s! u.>⊴ ۳fa0`ǰRt9k m ltn QPig	P sE" QޠHhr÷оH}rh
:o 1p +%qmQ#B Z	45.uQx$<u:5pr"&  t2 t⊀2 t`  QθIYQޘp˰ax@SQ #u,S#[r5	1ހ[C <ff<J`00xx00`6|az|||*>>[Pr$. R-tR-H~ r|48g'KG 7z<7uw &T2hRí d@C  E !rB ۣuNa D 蓅/@0ĩ0\7=m}vA 7F 7V̰ӈ` aUfVR3vCDPDQD C76A?f^]B~װݵBټ5`ٚ!PduXfL @ ?q 'o'()*+VX  "..֕ ]f%p]	ЯЕ||F/ACS@``Od4|DBGP4bCOMPAQCPQ0058 !cfRgb  8V  APICZ?f[g"ccV!c| | m		|
 3caPliamg|	 \SЃ|tr rur(urphzPmb
 2Vd RSDT(i  (gf`ht3hB4zvf  f}fk  gfF_gf w }FPTR ffPggF|f }y. }^$.+.(f.$tgFm{`gfN}~$f;+,h7qqc43ffgf&f.>$fpff(.)t(2p녉 | ~( N g&F	0   rg#fffff+f+., u4f0݈.> fr$$ї$0P Xff-QñQV3g&fFgf^fY[!ff=TDSwDt+St#PtSBStf=CIPAtf=PGBDtBUQr}$< urPbQRUfQ̓2 tS`rDr v'w;Aptg&P.XJfY8]UeQfWfVz f&f{.@]Ћk@f fPq)VȀ$ 4 
Ȱ ^S@-S@ff	hΪ$ pf }t௺ưhSfPW %fX pF gfrf.  z԰sg&Ph5{`r@(_U5yQV() 	)+ ,Јtr+,f  f,u@Dbi ^UPSQRW D hN. h_ZY[EPSWtSPŐP3h f&L sfu@p L fX`Ȋxشh4z" 037f,0&?  0 6u  ` 0OG웷fa3[;i P@}1U1  PΈ >ٛ&geE E uMM0GfEBtXAt$OAt32 O$fMorρþ0mMe&a`Qа   ø  kaW {f
,hc}^ttտ ϥƿ ΥĿ >Ċ_h9R[X Ë̌ҎRQcYZҋhARGf`FF  h04z ]up_ h
/c wU$w(w,w0wu4w8w ËÃ9FtFfNÔF> ɀ55(fa`C|@VEp13ɊMh"Ut

hn;rVuazQWF ^f/ fN`ф %N#f.9ߗuqu yqt_( rfߺQPH_rf;^uf;Nt7fAmt

tF~YP_U f0V8% t> fg.<t1!h\,,5 ^_P
E00 u,h]F..D+hZCyVWSR, 0gf.faȅZ[_6Q!_frtA"p  u
3A  t'gfy@GhGC~G$<lDPi PC Card Smart#ReaderGEMPLUS GPR400PSCRq b##$%LB REFLEX 20%241 PCMCIA%Reflex ( v.2T)c!#r$*HP")  a @g&O 0Gd uFq0`0 ȳ rLfK s\r>q0G	 .Da 
q0P5O@.d.D4fƱ2_ PQW8 0`
G.g&:uG`3␻Y.5:_YX^8t ?F`3;⑛fWr04=@gH44U
44444{# G f_`G` S [ u#x ׹ pDDu1 .u  ~ro&ti`Jt^& rS  r&= us5=
qLr.r3.ኌ؋VpL< t ^oJs 
t u v "'  h`&h/(~Cw Rn1Z%h=Sa1DIqL6rPLtI	Sy ?
SpL߳
LtQ&0ǀ'sSGYgV V
RSz P+6_I؍vf fDba +A |fLs-<t(<X#0S{ h([Lό^032t
t
u
hStrt
<0r<9w*tM> w\SQ [Y[,0>E*SQkY\;߅| !gthu$f`3pL& thY\֎fwv𶿊Ohsgf9t "aV20s  s thZ=]`r0bsgfyVff3 Q"}R~{fzsf!o
^޾f3: 8tCbfP #trAh]cwf {u "   00  ? 0    0     ' ' } 
 Ʉo/ bFIk0 7Ʉ k{s	ߩE_?.PBVW p~N׎Ǎ~Qr&} uKBr	P:!_^Vr5rr!{r<E@&=ߐu	АؒHr&ߊE$cu5ÿ	C@DӆΎޓrvatbV@DTtr&ϊeto`
T#
ÄSя/r# t itct t$?fZffLo  ]PG2A3!]
*E  @D+Wz êr8uAO_QY?_þjaL[ r&U߀þN$Lq3²
P$X` $2LpnBQp<{t HP<8u6
uB & DBlTt
P!a0 3 r/) r%BB J
rP;  5 a<t
&BȠJ ¨@u8` ĊBŵI2۬2؇āu+B9tl&2]ȁ8uC\m ri@e raPv rYqñ0 tAa> f r2a r-&́$vQQ> Yr	2/QŀqGY PѬB հApBr0 ס          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$%f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t
2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2cpPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{< fR fZG z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSS RLOfMUPKOSOLYZXV>YPsZSP[SfTRXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` ~( p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tϰk f_TCM!p߀MQfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c ~`b a >r i  f}0 c j !f`hktphG6'`  0 `%;`0MWff `_p
t_nfnf
f`aV'WH#gSik}WԒ ;_t[lPmF?[_^qWp!f` f8u cfffGofY2haܘPC
XPS fS[~s$fR$ f_fX$[ؒfӟRq1%D Ð[џBS22EޠHr'} Yuf H8s֊Ҋ
XQ iRP
t0kr?r#bEE  uf }úM % UPfPBTZ+]fa_f]rffr%m?&nѨ@..%f [,SfE.80@%D.%Ч!,=dr!stR
"誱_ 	f^ i
w tv;|苒*f`dk 	w1BcAv *)u6	B+	gf;N`f f{| 	Bg✯>?b>?fUf3Ա]qUfŽ`&С證` 
q\N˘qJN~ov"xof@Tq3pvbM*Rff> fPDWB< tG+Pf _te3ʱ
rI $PPP%tt0f薱vwV1Dةq|us%ɬష^ r?	gBc`Pr&U 
0  +؋ذ!LP Pc` 5
'|Vt^Ô0f.RfJZRUQf fuffVfKr=XfuNVFYQku F{MuY ^Y]gs><afPRg'QSVfNVFf߸Lx^[YrfXftA/3PX1MMNAO5P>hUWVa spP  ֡ Qa_]`phWU*2vq! ]BpXRV 	^Vmc  	o	 /
Oo
 /Oo/OQ%`Sp
[PS3}
[
u

Xl
a .hW_`p&
 *	u
 tw"hsɄ3ɺrñapi%ތ3t q(=30K)贌fPAMS 1hVW  ЎH }  $u
  P~0,  t`%ʆ \rr vo F0 & O1
 30&O՝a0˱071FUWnD8_]v
 @2`G_^`p$%%Ћcap+Wp_7fppw h؃-n; MB RW -! D n 1&FGv.u=v Mp cP$u#' EF? )&B
;uBf3 Cfu>B~& 3?_ B?GF< uG u2D %|p*ð I$-w4"r.-@Ku4 $
 -ְKr؊B*fQifSpqyf8hq  fP @fHnQ PQpygl ff@rMf[$5f 0pZ%U;tf@Eϰf  fTnfX2P*_@{@xp _ú![	Z[1Z[XжP`d fw@u+
f<P~@SQ0rQe
 |@$bp2`BsP_z`3aajcdy92w`ff۹" QB@Y`ffhfaRWf`3fftf лOuӰYð'@$}W9ry-_tpP.?g /cK/rQa0L G Pⷣ= 8 3 . P·$    ۷ᷕ G _Q&GYhz =o sj]fP SQ2gY[$
Ƞ	fFf 
tN8tSFOt@PV @0{ tU0 `"y  t t	Áx]aRVY sZ v0Z1{{|P}_$~4-tN`4eAu4fa2tFD 2 a tfߋFP G^DƎ s u
fWzf䠜  #q{fF$F(F,d 0!҄rBrf-!fv,v0hfN,s-10nv(՘Xd($иPN$fFfV fNu`2N t
ffFDlDU fbj N xf:@P#f#ffà0fHfVPf#f@f+¿f;FLvLfFPf)FL0IfvAfQI PV bB@wf*sͱfS faNXfեG̠BcМfAv4!;Vt
fAШĳj М f%pd"+М@dS@"	 "+F@d@0F `l'3@ v tGCv}~f!SӶ=t1?u	cY -
[`"XãS@9#QWa` ߀@f _Y[hý ĿL  
 ׀;
 }@0@Ü [8   0Pp2ai~%SE 0u˹h%qUG.]3Wz\o rf% ҺUCESN uIfquf#wsfVQ<t2f3r6S+f!u g> tXt r `Ya u!yYqf^w.%Ab؍@p`WOQ1-۸PnD;Dtt
Q!r2fp_
Tm! ֶ8-<t(r!f٠ _ tڑUݨ`-w  蜌%N $9N~lFf#`lA(  tu
@(u$uDt@tot tj}P1Xr`gRO#`GfZ3 @$
pM˰,$t pMʹyZifVQ! fxP1@@Yf^&ހ˷  ѽo$v2UPBWf˻@618G赭1S |cfXԂ	  [#+pfV~W2_ W
t<5t^PfCrȴf^r/QRVpû rm
a?KY V {8u`B!y^p$W" _T*u	 E 
yjt&)ӀuB0$&  5& A)u&Au#
1Au! _À8q %X  s RtY#}vMguG	$u<`$u3#uO#tBu# t'#(10> a$#$:u@,8*6R:EFu  "E@} tTt̀t߀EtH0*71*0*F )t%> t:& tSuR"Eru-Ɵ3#a$# /A .  "_E>I08u	PXuP3 t,gX랃6(t& 0`'y!E# u#t##t0&)6 qT=n!E0+x3;r.Dv+}WXu4&32&*?u!.Û-&1&	C'2(B<Gr<Sv@: ,Ggf{.&]tf&JE"E u'
<.r`+Lu2)0 *2K3L f@rD'<.t<+u
0 uθN<-Q" uJ,0r& 
6 ;6 #$Ü    C8BBaa輼a$at@0XFfFɷ͋N
~fE F N3׺ ['G\7ȷr[np\[ ]
 CZRQP~XÊܹ@HFFYNZ2bb$@`Q09Y`Њpc  aÇً@t&"ԃpm& & ߀Gag&Ď.&}%ߐ'@'hQRpm Zh
 @f| Z@t jj a` XYZð
U 
P `R|°S{r{ = ufh   XX؋7[}	 ؍6 @p  Pû #Q bp
0eP 	u`CDa@ ؀ `
hUп؎`u]FaQpWD3< t
AF !q`P y*|#z[zP{`m$j9SRБpZ[` $<u 3 0ؾ   ?faÃ3QS tY1u..VQm3q|AY`` 
a3RQ3ɋfkဨa
ԖRAf;v+R@fTYX0GY qÜPUfWp jи_fW#] f_ff_]XHP SIMPLOMOTOROLAs4Í~ЎHr"s u
 &Cs7ллWܙњ)ߎVPb`VӃS53øs˻ʆ`lu3 >:>1Х(~ХХХ
SR!&3-&Z[>>챨+ذ a
@ t+؋r覰﷗蝰蔰苰ysa&3&M<St<Mto6k)a6}
6Y^Vr4OO02~s*פ}ځ>Uրޡ̀1UĀQK뱨 aUR}3诬í@ªSKQB9q0j'ĳS+ôɰѵ@P>&~X^f <@ ~<@ u<@ l<@c<@%Z<	~@?Q<
@YH<@?<@6<
@-PqX<@<@/<p@|]WfPCI j-謅u_aVWfSt$ ѻRr f;ttNP2"f[_^q6ff`r 腠pu
N- 	 sֳ r 2P3],R*,Zu,ȝXK:0,ZR,U8f0+PfXZ$,f fu93+R+_Z+[9a°+ZDF3j+fPf + s"`s t sp  QVW&= & s &ߋEfXQ &# _^YQpVWPwQ`;t
X2 *W 
_ 0#td"X _`[ÃN s*уuf fPf 葯f@p8s2fYZWV߿. GF< u^_PQR׺orD.\ q	RǊQn{0ȊQn!q l>? 
@
 
?诮p	@蓯
u @ga
S؀u
衭	 [PZ P
?Xb
 
b1!~
X( 
?>?a
RP,
`bt_wZwU
uQrEt> r2
tC r r_  !Q ߴ 2
uC蛬r>
1t
@
 1rt"rG y /Fr*!篬r#
$?r`e% 蘯x%"诬=5U` 
  --  t3\!\b
/
\e$Er:W  2S03_@OGORP5ð/
$@@?XZJwt'Qw3쨀(N&A #:u2ltg't$<stjvuwv<t<ta'vFPF^B WXF;󴀱<q<3tĀuC2F <rq<0"<tt<t}@[vAvPAtv0;ivumGv <t]A<'wVuuu~ uP$<s?A<w؀<'s*Ca߃f ^YNuE 8u| w&|u@# tfrO tBrOt tP~rOi tEarO^ t=)Q t.q< wgPAu<-tu} jLr ??u PAluG F 2ovPYX'u0J/ PX[FF Ppv(ut zZϴ
u^E^2f`[E  
Fu$,A3ۊ^Ð<{MNtBL$PP*@*
BJ @t2qO123q<!q78 j hbxi &g +Ppa З
u
\0@Ϳ1]ϰ2N:um!pTkqS\8&&G s&G&ƷG@t @t [ W!uuuW ovPv\&_\ xЗF0 ]Pk..63 и( Pl  0 C@{XWPlߠM3t u*}O $ }! & @: _蘳@P@螳X򀅳$    SfQRk|ۃ}4Ƒ}u~fufQݩfYg󝡅@[ø <Ȏ3]Ou ffPS=Au@u;p u39 u+ f?wuf_P@ulXu
_ f[fX%[{A8{N{S{Ȁaa7{{aY6{[$`aa9{؀{{aaaa{{̀
(<Pd9(:p::::*;; 0{&0{ W<rlq .9_Swh 
' t r
a[e \u0^r!<u	rrߴ& 3Ps" r2.92& or5 s 2  q8 @rТ&& rr	a{Ss+&' @>' sq~@sQ>[q W r%Т$3 r~` rȁ	 ~" $ Ӏa{Q0Pm 3/X߀ ust sA@@tw1d:o` !@pt t
@u!PYÜP`
0.Xr_`QP<Xd
P+1: Ot	`2qq4d$!<!t_`a@tPGXfVfqP1f[f_f0Rpn0f;t !0Ef`Ȁt s  uf t?rau
 A)faUQƃU ]PE] < tF
}0G@ߥ{pY]}G@nPQRfvA
ˀt2 n{ ^~S{RZYX%sb08{rgf4%f`@~:P`  _	 ޿ T &	p޼6@+fEasƐb`_z PPNff3u
!tRP1ƹ  f3g.}fFpX gfff6^1zS!.fPQySYSRW*׿OзI  2 53_RWQlԴas5 SYla`o3Op3RQWSP $PX Q;]5Y!`lӰ0lusX J	uX( V_ m yP	[_YZÃU2<UuX贡DYJBB	 	p	dtrx @!uP`\دrXSp
u	 п ت * )VWP Dt!WQ0:t
Tu8v
Y_5Y_XY_^Çl  XtjrLhu3pqt$t<u;73hs.ht;B;i:aBp?ߊ߀tOBtG߾BBPt9t5F_  F@1
  ]PPhu<IhrˌN.TV
38hu
Ehr.2^.ln#LN ]{Dh?߇X &ChVi@i	'O	O"O<$OICV	uguLgrxF0<u.;Ttq*t0G*b+Z,Q,HC@0Ge{3b+3[R &RZuP,uu09
(04% .pS""0i3Fiu5%	PH XQ''''tOTV' (WO"B9/a((I8LcL;Og@gi Hf\PA+g`䄖`<u
 @&   >>w@tA>Au?Q?P@u  ,yaB& X?V?A@  0`O  r
?? P<Fu@ ut߷s	F ?uQ?sIu	 X GtGTtuG6FtELpJuUorPRtKxGMrOt& 0R] Z`Duh& h&R
XuhRX&  U au_@ ϡ?NtJL?rr
rr d Z dXP `f$& 8tpZ  ~YQX uS[^ `xKGi@7`*c\:q Y[]6][YY @p[@XPYÃ.06 m`3M$VUu0Ё&?t+aÍ>.}
t"h	
t> .:Utg >dT	 V tVR迚fZh|h m@i mu-i$<t".i} 3ju^^0Qd |p׸Y3䆊Ѐ u gbO@#ks2t*cR@ .u 3ێێZ
tQ "uuq 0
 賯uIst`
N0spuy֣0y zPPss4XPt)Qu&obujpw`w|qx
[uyRz!uX $PnP!  vH H ~H   BfPff  @ fXtfUf PLtg]`rfw? @q?rd`Q~ۋfX ]ge333s
rVd4Ad^;sgu~0
30&
s M ptAt<V)
0dDg_}
^PVWd_^gEdTg_}

	}goE Ptr00t}d8 W<ytu@Drx	0fU@f]3
t Q tu Ó' `.;Gt}._pfg6$+' +kÑ#1drP0fd(fr?d&񐠐ߋ+ dMd5p
Vfd@<d;]td|d]^sP~vЎߎFpk^rn @~vFUn ]~ 
 X вҲ3
' '` F`pF/=K3P.;v+GuBG
pF/ǐ{p Ë% 	`XvNQ
 ѳ0ʕNY%_'`0123456789ABCDEFSۻL׆[ÙMEMSM<M  A " * Gxx  x y 1 " *
Hxx 0eż 3 @ķ $+8y y `b é uTEذE
U`
 rp  t
rp~Pxf`Ji2tW &  q&E3tB&U
&{]&EP00M^u0 &EP0!*578F'()+7
t À v5u>JQU `
x_t^t]t\7u>tF5BU3< v
<ar5<{s1$PN XpIQUôr5հѾfr9_2.fMkOG$MuM@t <zw, tAړ	4둠t
w
?fb2]Of?S@]J, E OPL|2)P!
 %Npo t߀r0r 	pp6qvPQIs	} 	Ea @ A  B C iP$Q3QaQhQMP[Pg]2̊vH ttHQ3wH`]!
O uOsHY SQ>tHu5MGôu辮% 蹮r<N3ɸ v 3Y[ЈSRVˈ&}H˸XNmNNK 蚨tit#cV>{N}H}.ndNƝ02}3^ZX+VꦑdBN Puo 
(N`r- ZNSQ 4 XuʉwHtHvH$PIR    φ$q` a b c    b a  i  f0 c j hktphGA`   "0  `3. W p
X_ϊ͐d
`&aVWQS;PRt[ 
 [{_^[RW3$`  gQu t &GY gh0+b+,_ZaSQV.Q v6Q.Q^Y[XU uP0Xd]<t r
t!d8D^u/RWuaas725T^u5@/ 2`|&
yt,ـᇠ-t&M1&G&aMO`BȇǯA::LAAA$a+Íu 2చȃtm
AȁBqA܈$FKuðWQ :u	ۍY;wY_DuEFS؀upu)4  IP,  [ct6<upK2ohvsShsSwtOuts@0q1qKKL퍖LyRs@AtQs
2Q1e"  |  iD.D
 ``U&&D aø0 м *j MF&&E W 03Լ{h  BMqKQPSTTQ\qUXY}`.\.T@TώǍ>PH.LP_`$a.D`"aQPƌІXX 6a8cdeVVVVVW/ƐVVwŝ *0 u<s/h+UUu< 0|X<nXu~ s}p: hA;BMkpP,hv h?BM`JfpYCo`h'p= v O h/(paPpO$@<@p/@fRf   W.JbWf!Wg{&`Jbf~?fZ`/2p n l zՉ{{@{ #  ӓ̓Ȱœ输2Ҩtð
诓@B,P}誓裓蜓~$zt~ø߀o
!x_аX}w	Q~2J~s s	2 G | 81*	`#a{2Ёð~ tN :`{`뒰Ё䒰
ϒ$
֒$桰~ !$þWWWXYXXXY%ZYYY  M G00" *p0	0ѓqȁ蜒<p^PA~btcӿfU]}u" ՋU"/ע}kCJRQd%ڊٺ &aYSU  !Zpp"+	Sf3[ffÊ$Rf
"fX$	fؓffߋƩRS%  ЧfffPRWS22f`J rB :Ӏu ,8s܊[_ZQWRfP
t)r Hff  u 8ufXZ_fY}ҿ4 #v 
t$PtWQ3҃rҀY_ \\<\p\s\|\\\\\\\\\\VS30A.:[u.[ (K[^* UF.\2?SF 0TS.[F[C#wN[QF(?tB[sF2~ tYp°j7Bs"_ø8B:d3d 蝾A`ɔ `膅$ $SWQ q`tу5Y_[ T25	^f]]]]]@6r *A/]薢_P@HdX$#G; dvd<Aq+$e 3ArUXVg"ؗAX(r4A DzA EqAZQR㴆a]P9A* MPu6 4aԀa$8uP& LXR/= u4p/Q <Yua<u
 u3 uuu@vLƏuku=fृШu@F躏u5t/oL$Q_z__q_S  "S֘ # DPaRUD2ET"!Dן|+^$ ݢu  `T`b`K`>   "@ * G yo cTU_FCT@
M#hן򶠀3?W$ 1갥  &E%
H  $I I  P ,P 5S_  5S11PU	 Y
 5S W5S@1A1B1CPJP JQ 5SR  JS 5ST  JU JV JWUX1Y1Z1[1\1]1^1_  a` aa bb rbc bdef GlikBL_6Y
`pg g}
3gE
 t02"6DSj$[gu0\4sU I2a  
$X&E
9E###F-B  3  1>]g>f`PtO:u (2g$
g +-,+Pô%f´+ffffaVWМ-ft*.ְ0+f$t,߹f$<2ȋPjf`%m9~+f$vw%p+j.f$`fWfVSQfVF! \Us^(2۹  <F  +^D!8u3cf^ HW7VQCuK7! ذ9!`:w 9$I^:u:\!uT8 Tr7Uq;f^Y[_SpJ;dӆ.
tÀu@u[)2*Ee8*'肷e$+`eD,&lFJe- @e Ve6e/R/ =e0F0e<2&"e3Z244)47Fd$dGdd  d@Id$dPRZ`Sط$0<:rd u[XÆSuH au=T kUQU& V N: fgfF`zXRyZÜSt	tv
Zvt[ÌȎ؎ ЍRߋhe]Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfV|u11t u3N@f6 V1u^lu1un1RmplN\k Shcg1tEp/2u911߀u&lE1t!}1n
xqu
]]f^TVTWTZT  	     v 0w G$ $  GN N  GP P  Ghw h At ty   G   
G   Gy@|xy.0w `@~.@  Qy q!fRfWo.kuomf3gf&ff=SCAFtVG t"ffff Wuf(tfPf6fXf_}ftp ,Tu Vjۃx 拔 tcPtpp>ppKXSB$x$PXr$byu! $
BB-yJJ4HX^fuBf=pz s:]6L
Ltf_fFf fB谰l\r=6>L t SWfSf 3f9Buf[߽i p"м  .>K+G55:,+j؋r  t4t p0掊+2撰ðuTf`0D vfft;  Qf3Y^p,vЗСaĿ Đ/fPS^ۋ^&t$uG&uF{tt] ( ڼҩPQd xwQQ3ɀtuw7@qb$)rr
`r`Pқ䠄t"
 ̠  u!p!t  &k X`PH
Xu!P=<Xu @P0Qt2a`
  oP#w@0'waeu	v" QetCOMPAQ
 
R3 D  tZo/ Ooɏʯ/ Ooҏӯ/ Ooۏܯ/ Oo/ Oo/ Oo/ Oo / Oo	
/ Oo/ Oo /! O"o#$%&')/* O+o,-./02/3 O4o56789;/< O=o>?@ABD/E OFoGHIJKM/N OOoPQRSTV/W OXoYZ[\]_/` Oaobcdefh/i Ojoklmnoq/r Osotuvwxz/{ O|o}~π/ Ooω/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯ/ OoΏϯ/ Oo׏د/ Oo/ Oo/ Oo/Oo<V@VDoH       ؀<Q7hˁ *1Ձ*1DT`ur(D
@ JvArHvA.=sNfj@&t FN aR3V.vZr# Mju 6ur 0t 2rYP u v tpr&4&E0r"(r$2mRs ÆUu
FUF ô	!}	ԕO	r@e"g!5	pW	^F&?s $s& % &G&w&G %OD
 &	G'fPfR.Mf.u)E	ff&)E%*E+b+++VfQS/fD[+fP'fY^f& u#f&G0Wf1Q1 /WfZsfXP'F~r .>x؀t7P4y4/r?P t8P4w tR4 tP4z62frV7ʀs~	@819v~wt$P:tP:u/~߉~ %3NVp<v3su;^<Í6ٛ.|uLYR..z`> .:Uta?~aOWQS.ن? t0.}u.:Mw#.;]	w.:uw`Cw.;w	 Dw[Y_P t>ـ?Br.u|
ՊGc) ʋ.Ev p$fV|fv )dǋD!M IF؊fH
@NPPK.eXfPȋ¾HBs$
2H
ў=JfX!MYKdwDM!OfPUv]f^PR-BYYYYZXRPXuUW:>_]sr  ZP$<pZ- r!PZ@XuP[>~\ \@{<@pZPY 1sXXt^y>PDt_ \b~> Bbށ[\   PR`ZWdP@ ءf  X?rarTrOt :DvL*DQlP umfmP:
u
rP
l
u2 P5k&:Ev&MAlG&*ElmomoP:nZrFonr;Z@uu gBvu< r
to@r&tpu
gZr roR^Xt2K uu@uu~ u2\S ذA[XPQc6Pǀ @8<tPp<[YD
>X{` ID<7Ƌ%a`t>;P	 C@@_p$Q+r++YsaXt!$!"桡Zgf`ZPQȻP:Jr#P:Mw>lt #A @2:Tt
 аu_OugYQ P~ <s& ?O E\3pp >ٛ}uИ  
 VWf<u^<
uuw MzE<49<t5$SAB
[|u |]
7|P5u5 t\_^FS}
;uӜ}	q. @)򠴡܀} "a=`螑~0uD?ad@QV 3۬`+^YD0!)Gc+fQ1ff?/bffJf6T1N
O2Xpf F PX`ZfP~t$=r0&Иw)0Efݩu1fuP:Cuo~EpSVM|ttt
^[%\E20%`URfQvV ufufYf׹/Q=fA<x1 uQ !qn r.V sfYZ]Tf;PfRff;fZPWf!rfhrf+f_fZrq
pfS~' r#|s

<f[Gkζ8_r ΧrBQwʜP诧XPQɴ?r Px@}Sr[R"ەϜTڙEzzҏQzջoQPfS蛎ff[fufXE t ft/+f #fSwff3ۀwfnwX2ZfYU1VUVt?$73tpv{ð-r@WĽWV` fSP~WB Q Y_Wx^ eܐst/V! <5u G	F^;^Ǭs.
<5x {pok­X= Xf[2PXo^YɣWfVf  t
P E(r&< u 03 _(PŲ f^rYô P93x3Xs ke/Ov.{P߰Z
 $ t`t {Z) [t`S?YBHu
 %QQ$
ǊQ*Q O P$=P$ SPd)R>|N Q3""YQ
t
t
da$a&%3ð&()) F!tt	*tEPXQXS&X"
ǆX[X-X <t<!t
<<*3R )`@"ZQRs	00 Z) ð  VP֎ލvS<û	 X2p^_ð,RP4U&4P4!RP4u
VfW u؃ tvr
ǙD1^ p5tr|ਐ>|> ; $><a?<a?7^P.pW ".mW|W`DNb1% QN 6D؋0FJNZNJE]u XðRQVWP>uoX_^%VWKs PL2LPQj	w؀7ð""dS } [tbN2JPR?
XC1t0q&[ߠ%02p4a2|%ʁCq 
P'b7f31	(Wbd%f  @ 谘 T	ɰeShǿr 4 撠q	ٱJqUtq$DU&] >?0|`ɚL|0I <
䀴SQRs3ɺ	ZY.o
X `Ņ.oafV`tao	r ^"r" hsW  h@	pqh+"af{^`po*2$ԉNT@׎Ǎ~WlF$
&FGBp&U_u`g	 q!a8 !sSR,غ*3% Z[QcW  t2_eQ[G0wt Zt
߻p褲xpv ?PQRVpo6f `Tq}쨀t|u}T~^Z`g Di &  Ҹ
Sd0wɞa 1ÿ`iut;676 6 (͌3
t,=
u
"=

u5w<t<u gF`<qS $s
Ê& 
 [<ua,w\wWTu& 6` AI `'aᎿY6 FF';Іt@2vPF X  dtPpqD3]q]	F
t	u%  "]g ,2Ot м  /rᝰ8p)tlFpoypOIEMAG  IZ P  A   	
?
 [ СHDA-L  H;DB3A-ES"C@USB-FLCDHcLS Intnl ? PCI-AѮC  % eOj_iyyx	uP 	/е<M ;;c!H3ֵU	b ` @ ! ?.CD001EL TORITO SPECIFICATIONҡϼ/IͲȨbc*_dd˦j	j9tP 2XPUv F t	F !Ff ]XbX
P3e0PRuffZBcVW߸aZ ϑ#>Lv`aZ 蕑@aɃ AtAtPS ' [X<t#<tQ f1; !PK<u   0$ ߽_aRcUWV    aZ`u̐$6s.a;u uj@3QuSF!KՃtAX؋  ы o#и@ ސQu?rګ߬^_]dSG# ɶ[Á3oxupPjuAaZ o  Zq*tVQ@TPAa@ SaZҗX"PpUf ԏC@QRW`|{x}H2~$tu@}_3!Q}g$9/Dy3fUfPPfXZf]fff]rQm  enX
R% ,a.8%@@D@t`X_3_2_   r_SM_ PDMI_ >  #f`Eu ')$
)u&z)ô#p))f)fa1Мn)ta)$t7T) A	ȋº If` u1!)())( #(@)$(f{a!	*P+'@dTOYu0$	!sL D)C0fȞfšP]0sUSP PrX[%#<ucrh .p]iGuESx @
߸y @55I.ISz @L{ @ ~ @ @[r
}@`'$$
Ȱ5P.PI$
ȷPM D@\rF@P)?Xy#@;r@'%@(ȋȻ")?r, '?(fP}*ffP+d+#o0/0zp/R	1)os=oSP	 7XP rX[1< |?7` $$iu@֨`uph
'3^?n?21h r'7x?tu	iQ?<Xs:><;~@= V;fSq˸'_ ?[ ?e@kx A2AZ]BSRWP<u̋2.)  .E hu4`  ӧ 
E`E kE pZE3 YPH PH =E PH~@ PHL|y rt&roMjrey r` [rVj rQrL rG rB =t r8 r3 .r)= r$[ rqP I r
 rlZs_t1p	p<t<
uu5(Fu
#XX: =9b2X%W	u/><t,`0t-<v<u`X/<r<
w`#9tX	Y4wV
__PXEZp/
t	``Z`q| w<XYS~%UE"
ǰ \Evt2M<eۊܠfO<wu.!
o#EE2iEEaRts@ ڊZ[slZ[T蠭 uH`jD؊Ȁt, sl
{uIlrq7mZh1uW!= 2hf[eTDذf`iXDeiQDC۳`j"jf8Pv3DBDO;3k Vkkx1llFmK߰ 蹬1n?f:tC2uCtW%زoDpxp_dr^PsOu=_u8!oho
ً@:Š:2}~w:03kURqu<u7G	|)p7:0:tooʀo0Z]aGbUps1lUq ]`K:Ѕ.qKx1l{׌Q3pY!`tM M>rQp4Ys. zEm 3ɶzZ[xtHBPuy{sUH 9?G 9{U葚L 8 K H86{ N aMCqS	mAjA@2'A83k$PMM w: pNR9 Zð@1AV
u$<`薋'ð` AË tt	@u f
t ڬ 3R $t
& ZgKt
7Ku 7&ۋwàBt'`W!&C 0ttĀtr û@ `:/j >N w r
?u ѱ^<  u'' t	3rwu o (siq
u` )뱳2 _B<該BDtkW艸EK`:?t
T} <`s /Vi 2ttD?@R 5H I+. uo$ȰttȰ<tP~ S`:8't
'  #lucs8tKTu<tB<t> 3>$
n3>q u) x>   (z
 <z3%>$Y>P3Ҏx ȫ0 hN.v 
hoɀ،_[a{{ݯA*qAAݰJs@PUFF
]X `j j 쿀v
)Mf.N. JྶT}FP~rp3@o^)tuw t&Du.⭋^^t<a.@t&ڃã.^2Ȏߊڀ3616^2. @ PSFݻ@g0'.:t	tX.3_0gepgUUuf   p5 f   E2f<r-s(Ӱ@QКrr
 rR1VvF\r:Gs5&DC H PrfڋykQ_ AFF(t S^$:u [r
F&F$%&=vHH&
D&d̠u rcwu
 !πϠ!&DB êĪǪ׭` T>Vsc  HUSap评1s!
 -s fqt
 E PF  &G )
V N8tr>u rG mo!F) r\ A{r= r8rWsTsP#@Rr
 ;@oMSa|`k 1F("r#謂Qlro@rI2<> rF( &dKV& %f)&t`.ÿf`g`t/7@t 0(T2ô$(>faRVМp*'t
`)$t^ZAfRf` u'B`)$ $$faZgP3@%2P    X& @F$$<r$:u s
jút좌 
   @^38  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF%lѐ$`B[G B<(0ø fF" PXQۋN8N`NГ o2N--O-!`GsH-ßGHmIn-@
 r
sHfQmr77u&-dfY/_"&&%'Á3bR&u 05t36rCE VQB A9O9 BY^N 4s
3
3u3`Y,dS@Q%uè0àt  !'&V&T tu^
* &u^ôp po  fqQPXuN%&:Lyr0PQ* r$C`J 0@uN<upZt+Q.϶@ Òh; E 77p+$<@tgA9Qj9" !$!$wQj  BoU0+0Vùg
+K<P[bз#*E.øJfUQEufVKrKfXfugfPwNPwVPwFYfu&gfFffffMuY2f^Yf]Ë: 3R)QSfVffLfTfDfLtf^[YrޠxXA3PXføMPøNIOBfSQfVfRfUfWfPj0t3 0 fRfZYv_f]fZq{[PfW/ t0tQ uUP@XYQR   kPQ `YXPt
 t$0t t`|tXRfVFtf^fZF*TVfw#t   r0{ Ԑr	0{ `f^QWVKǑ}^_YÐw.VW2! u[!N[P] R Vv 6^N nb VI>M󤀚R Ub^1{_f^ZYpV3۬
Êo^qۻ (e -rg $p0Sf0fV1fffa[.6+fff`;w	rf;ïwaf`fXS. " Eu߸ Цf%41?^oAR0ze$''ذ1000= <r <3fȐf
ffʝff   f-   cDfp.W>Q\3&G;r_1SQ <m  `2S\ Q	t[c )exfsC3    )4e f       PSVз-//߻׻^/пǻ.u/&&^2Q pf@is@ ŀ ʇ@@ifYX4Z4f4fZÀu< uEuPPu,uZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .ȷ.ȝ;c;3R.ȃPBZ@QR Pj<rt2[U$ԁ !Ȁ
  -h?۸" ZYSUלo$!$ [vBuR״ xuߺQ
 S5,.4V 1	~ &n `.
n&UW ٷl _Z/ u
BJSU@@SR 	S<rP
 j ?G 
t<t  ).>  \. 
+vPv`R3qAB$ԡ3ɠ4+3ð4+h ?_@iSQuP`s"$@AX鄿u"Y"@1`"p"XU`ޤ<"$SC"S8`tu
q`9$`
,RVސVtf   ށcރuQ <V~eV <WeU  
  #T `![af>f F6!_s >up\J}>Ffah`wBBtݳf  Fd݁fwBFR.J>J u R1utKR
iZ_^Z2\QԆV_ޑؾÌȎ1 Sr. uo ؀ˀa! ''u	!3r
`[Uf<tz r	P]íU Wp rВ$&&?ĉf!))~#*N#*Oeč#*qpҒ++k.7x)]e.!Yʔ,OĶYctwZĿ,P0:̑8{P+ĠϕP+c.fWsA!<ufk,`u#XkX@9f3gf&ff=SCAF9f_U< 
 	<! F ]W  <w&з'V3ɊȈCF>з1?^	  ?0RVV<v^.>
tзb@ ؋}B`#$($&],5紉UP XZs.V OuC]ÿrrAJw1'  '?AO]KLr?F?ccq?1'M^ 'M1'6	L(L-Q7dSvn12CJQf:r2"S"U&s*PYUb\l["2ɵ"YùU١ݜٝXT SYYӒ0f0RVfг f90^BQ^>6׸@YYr`_ X0hj3ɍ6.L.:Ls&@U.D@U.LUs?` "b@cr2a0f!b2b߶ǖPb߶ǆhq KͿB^h$b[3@
tiA	
u! $R3ұPA	u ^ú tq>ٛ.| .ߛu}rs s Jr}uL !w`3}p!wuvrbWv_tUcRQ"jrUKjYZ6	u>^
 .D +b}t#V;T"bL7T^&T.L'T %b]e Qa |0Ys  uP:	 t	&Uu" Ǎ>PH |  Êö.f.|f0 S.|SPH\VxykPQW 3ۍSi_`  
` u #з $t$?aqh@ & r 3uR.R3A' $p#L
tI<u	.7 8t$\ ptmqpuqV $
4 0@ /u7<<uذUNNNOѝOfPSRtt$!ZQRt2M4ZXóA2۴
|~q$茰kAD#v+!0!t"Ĩ@t  
 ް  XPJXSP@ ߎ +. s#. sXP &   &X[ó5P϶.4EG6Oa1pσD
 uj@ t%v 0Iv0 t ArMv .sN-f-&A F'N- aύ6 _`
tr r	
F (|r
	u뿋^'Ât %轚?	xA*ڕ!trP/5rr[Qo
u< r<0s<"N@@tN \!
'P$nvPf<0 
ݠsP<js>uP{`.
I.
{M.}u tj@&u |t
` ^!N%V#~F`}2rp; sCs6< s
	OtE""Lt*$Ot"#Ot%" 2䒸)1ˀ  .EFr]RsHs1I9 <$uw2d*<#u"0<<v<%{2;0 
F!UF%z ËF~&=r&0wvCfP&M@:E&}CfX§sʝӀC^Ë^63܋F'Mrfg	DEĺ~(LuTMs fPfڋ}3r1r.  .GT  M:./M3V#:T }<~'t90LrEE&DDp%p5ߺLC~ 6כu0]Sf.f&]f0 [A!A'Q;  'r}迵rxtNrlFrd|tZ+r@ u~ (um-VƎދo^YtVffmruFr Y螵r)2r$]葵r)rrd谵_~pq rw
u fSfRW ـ?f.Efff׷f±
USffs@r̊MF F

tSuNff3f@ fVٛpW*f8f'w*f'F'*2t*܊f
VvfVvF`PFsQU n E]YRPXtUW:>蹶_]sUr  !AZâᶃ2_BPP0Aюً PopE?B0A1p c mo Ϳ གྷ # M #
t #P Z^Nz # t͆謳r{| rv=%>= ˫1SW>K1ߊ, c5<s-ٛߊO8L`
t" >G!#}$0N oEAPaX ٲ kӇ $ཏPrz[ru꿲ri8PNrWu
`ҋع ((诲r.Ǵm%۴ mtt @t	?tSE% surY	 2PPReZAF sH<t<)t<(u;>A u/WU>Խ >]_ӓ=ʞQ1`0-?P^ća1! 2¢RFtN+P(X!	F
+9#F
t
K
PK(XfS~ t=~^f~^^~^~FF
!FFF  f[OfQ
tW 8vN؈^~nNfnNUfNnfNnĢU~*Ċ^
^aSfYTSQfPv j 8rC 5sfZR aR߈FfFQVv%{跱EfXr+tk``1 tfZf   f+YÀLu$PΎq2st
.x<^ fF! PX0 t<"u<"tV3޾x 4 sgQ&߃?s0< ls& m &_GnnwGnt&O &O@Rf&GG
q1r5qWQs]Q qqWIqX> QVWy:W 0ztNu~u .w6 u/ ?.	
zy t,6p/o{OGA&&d&D&t&ƟDk_^VMޡ}}"]`uxPy
 ф^ uuچ~قّٗ٩ٯz,U~g0ۡEݾܿW.}
u.:wtLu% xt>JrS.[t.[u {yt	Ӌzt_M_7EfUw"RҵgRеMwpgŐ.V PXF
Xf]h@ øϑ? n ܰ\V20ǰ=Vأ6{}س.tL}!΀sϽ|bހ^SVD.d.$ʋд×^[AyOój?rcB֠@qDut
ttρ{10
}1zu	vA.<xAh ԕ@R:ÁUu	UFPTRG rТfL?\pg Zfa1D`0GfP`|wfDum
`@u}f!VWUuP &BrBnXu?>{ؽй0.>}ؽйu ؜`[Bra$3mBnݾ&G $n$PC&In(US*B>F &g0G1&O2C$ 2&G@AX]@[òl1<amn p
 |qrfBtGn 0`?WPs?޲ raYxؾQ붬eRE<sfQg0MjtpZr/0 g(? ѥq[Ü?_`@QWV.>xuG<tFb=>.1}}>U%5>َόɎv^_YSRӯt5۰`cSRg&/_p&_ @Y2E[fUfS@f]Ê>?">?U3 ]PU  ]XRd ߊrQ rZq@藣 r迂1Z  @>  B< tkY P5L g rr]91B+$f rX rtL rn Z`?r56bరɬఆ r/ a@RAr 5rPذ0`@PS [XQSWfu0v t!ufPs NfXt_[Y1T<t;f3fS t	fQNu
utǳf3fL[`
 3& a@[o q^(C)Copyright Compaquterrporation 1982-2000-All s reserved.j/w*VR@ ރ| 拴  t.Z^!VP  .1BBBX$JJJ_B1P0ܰ t
tJ Xu|a0b1@V tA&q JZ  C@2u*݄ uP= ]Xruŀ2	`1  F (8SQ2<

2ۆ.
$v2gp`1<ww0
u  ` 0      Q
! YQ#8  #$#PRS%@&+}@&;w[HRҹuaa@uXXZXp! / DPXǻ  Ü= srs+
3,,]{ _ ߸^ P1wt褀.{`蹀_! /0{諰2]ALq.j.b;a/PQN 3۸ K `T'  A G#y 8P8 y " Ëuŀ}
$corp`tW   d_oa?/@OAoBCTVTWTZT18 p9@ @  "`:FD-18 <F҆GH    *tP9	G%18	p9``" 8d dc"F18  #Ga a|cF Fp p  Gwr r"Ls sL
OrEcN H"  M
 "p9 +O6bS  #	K҆
tXtX҆#Oci0,}`d$!<!uy
ء\`&`"&& x<&  V<tr^@K^D]8t( 2]']v233.f>"  t."   a0b2ۊ( ҊȰe) Ǌ&) "f* 뿸*g>+CfgPhf>,3gPh.- gi) rAji..jij~PgRm=x}DK   Fw   Q Q"FPk?XnfPS \@ ff.<O[r.<ft`uhL& hPrw uhTrwaú  +߹ y$ң.<QR3Ɇt ސw  Jt$
tAJBqB~  SQ q t$߰Nx.1u
<v<s<3v 3^mtQfRfV SPo .X[u f^fZf#u Y<u,fCISGu%f» f f f À2  2Ê$uGuwﴀ\PS3ێr?43' u f>$SMMu>X P dPu
@uXgZr 4˰˘s\2&D
V &DtH  
y ǿr!`rsuEF.`26$D%rOsJɊڙK$?rr
jryϞZ @FFtN fF" ۋppB@F(	~r22ۀ~ `p]{  t3ҸK3  ;wu;sbFVFF"F
 F)t @r4F$
Ft?+ F p!VPXVP"aW% uz{@ZX_'Atp'_p$q,pⰻ.3۹ 3Ҵ@./@32 3ƀnu{o`n ݤC/p(]A63Z4BUWVRQSP36x \@ fFfsEYc ,Xu 
<t<0$< uI"<w<vr,ߊ2b? 袽&\@ N [[YZ^_]Fu9<u` taaFsGroP`tNð
2~
 8u	À>A`cA	}	
u'q &L H	sƨu	VuQ2^ ˋ
貽	~詽~製@u B 
	tG&A J
Emy2aeaHH'u$<s'
C	2f 	.c u-QطM`
~q`t
тd _P u pN> uGG t$p<pupukG'FO 8tWG߷ui[G` u33 	t<uSG[u8st_,H@>C0\> pd XϷ޻ PB st2 	=3u
Kuh&> C%Txr{3~ua k\PWR5SHC>95Z_SYSID_  1Y _UU! fl f@f="uf3p fl @ $q 0 P a v&  
 '  !2@ }rP'   %	:	 CK L   P

 t " P    	=ZHewlett-Packard 68BCU Ver. F.0C 07/28/2004 L[P
Cm   Q KBCsion XX.XX@X
 
 p#oC @088pZU10 Intel(R)?$[ PZ0NQ"rnal L1 Cache!& &Y'2%(	
   PC CARD-Slot 0 Y  8  
	Cen|US|iso8859-1H
 AZ ) vHYȃP-P
@ICDIMM #1&#/#PpG
?2!32/4ZK5K&`& 	TZ SST49F008`YXZ ?Z@KH~eCYH~rC
Y =PZH  ~S
@8 !"Y!rimary~OC-MultiBaE?FZ  c   M2  k]M U5r !KEND@?3 R	

 ORS	v1=ddW"-QTONo baut'y"WY_[;Q~Pj@Q t PS	@'[Xu	 C?~ðԵcư
F&? 
ĺࠋ ? $8t{0f`r#} 
@t@u8p|Q z쨀ulB@YÊE *F&dؠF`n}nG`n`ghttf
! `
	
"x2âF01v؊恋Pv@wⷳ~豳=< _< LYulug胀xπktxn{hxbhFFg$t#@u*{Fx @mڳ2;ܼDdՐ`*U#9.:f tP@9uD@.V.f] l(<sW ._.  2P$<wXs2Qg#...&+.	 P# @ t^T.&u @ u42..߶
tw5Ő*
t*İ&u XYP3 QP0 A3.G
XY0"3 *."b WȎ"%"_\|PW\Ooϟߤ?~~~l|8&8|r8|8a|çP<<M  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll78x?~~® `LM 0``,  >PW$ff$PW"%0xx00 0 lll"llPl 0|x,0f 8l8vv ``"0```0    f<7<f!0p 0  || 0p0` x8`<l 8` Ppx|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3`2gf>  ``x pflxlf bf  ΐ8ll8`xƁxpcʀ3x;0 `̀@ͱ`x ƌ2x``x}  xcx'0 x|``Z1ptA8l`vQ`lv-f0 Qx@?`QRځ  aPWA  ͐bvyfҷ 0|A!0ᶀԀP0d 00001qP v!ס  ut.Uf SvN .Y2[]
fPQRx>@z]agfZYfXokokTij?okWokeMAY9Y.MFnSS " (B03P2X`3Ҵ Āu(N(<tDlQYRBnlr8rZlr
2:6 vKlZaaQf PCI01 IS z C BU03COMPAQ c04   
  q     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
h[U샿VW ƿF F   `qf& FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3P% S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 h(r*F)'2(~ t
)F_^{Qd!
hRs .&4/udu/   hr$?ط2h8iRhJC4^Ch7
 qrf   f  f  ? gf&Q6..  1  Y`WVe1E0&E.&WV .^_UUna<Qc< 	`@.e1E0eE'E.U s Cm2a h
$ex Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&._/JNK_Y[X MMMc1@  @  @MpM dB FO MMxsMURMMd* &  <!TXMC  3Q[MQVWh5:u% p uxK1__)  | = <tam;P09A9_^Y!JRW`  Ê e
Crr3ɺ Qe܋
AB rN _ZMSqe =Y
ujizjU zj%1 DE<@1p;<<1p<3uU """ka#t
#m[VfPfSfQ f3fk3PXfffDDG(	Dh fYf[fX^u 0gO G߉xQR@<3ۊED} 	 C!~ҋG4Bi3u fDf3ۋfË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.h+[+V.`.^̋] dF. P!.φh/+Xh'r QR  16W  0"mXYZ#[  
\a_bA]cvdb'^;b` Џmefgh qp10GpppQWĀ> t		 u		.	_c   O idJ -ww~C.{e
/e
@m_noG`L3۸ E {_F߸^FiQRrPS8[X%hqQDЍRߋh
     j       ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй JZs hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0Xf[f}X:g&8u-g&
@gf&fP!??PfL'+g&>Q9g&@T=SWVfW=&2>X>*>f PQtfGg&D= $"F<vwD"FCG D| u:tg菂ACDB'B_^c=QRfU۾ ?} 5t$R>0tK߸Qt!?E$fu
pNANtN0OqOt	dI  }f]ZYp=PSRi 9uQXrQ&QTG tuVb0< `Mc!'f5 ?*bX.bX28#Z`8P A; u
@:R[3 t
\=SQV3ҠQQQ  :QtzffKfۿQ?As8_Y8ta9fF*0I8$ЊBb*PE X1Pr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>-ru	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
QDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VQ Qffq FFt
hZS7gvu ?>t!?6fӢQ qBf0KNf^fQ8SV  ^lQ  A;\LA;t% QA1 0P7>	uQQYMV:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 
~ o 9`:`<`a=r0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъ>Ouթ5e{ay脆vؠ@Nu TѓQ$U^fpSa=}001?11S*P(PP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<۳7{RVLLf;0tf0f`0 9y";$i#cj!Xf ugf ?EM> fù fgf;t?)gf+C0kΌ@̻&{`g4?1o? )Ra=KKPV`^0`; ^=X0;0u}0;r	wbf.0XÐ  , ,  ]0
  N0W >q22)q



 e &   .R4
,#
q
 `mOk/X0   Є -} %RA! "a!   R!' 0u#"("#0T-%Dt 0D/\s !)R! _,L
 2m %#p-U1.1T.&.!T//^06!."mRc"hB"4c#D0A!145q%5$4663$8W%DHS&6&'0$1</<)=!=>(U(P a)6)Q'C*11B.tC1!D~D+!C+q:,)D++Hq@a)JZJЀ&
X&@7Rr"DH2D. !N!N N%aO#t@j,=,#+XP &N}$hB "8S&.C*SRTDQC"<V@0jVRTW`/"SRS3S
\@  (#p#
 4!3	^#0@ySu
]	PP }^ ҟP 8JQ8)) `@bOTcUJQGJeh?Wc" *h
`d]s%] b^h	_b_eXEkll4mA
m^oeo`E`Ta5aWbZ&xiO	.Zր)):JbQRO"QRW:"/*@]a0  W Lw(x(Tx$x!TyyqpzPn{:{'x'TxE#x }~{&x&Tx"yme,@||#x0cAy9y4zQ
O{''1}c}@9AƄ&(ϐ{$$Bc/{`(Lc!$Rd13;.')'$Q$c ܜQ#LAz$1}N}cQR@qpdnᥑ:(.5(f"\Dqg@131Y#V.'ڭ&.fA?$.$f@AzL/"|A!(iUこX/o̭A!'iRaO_-A!iqaOX53߷$ A!1aOAo:!Z(tZ2t@6nJ8!Z'tZǀZu1?!Z$tZ13!(B(5O#Da`k8'ҁUˀ12EǓDo$U  rxl
 Rm $A #q
 `"	o  r#{Alߑ]߀Pmz]T
 "q/	 !P{K ]az{	 hAu  `SRs`
pt9a!w    $PSQW  hq.v h_Y[XPR P4 ZXð!0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ?*8۝6T  2 	!	
w##ƒ!	1 
  " 	!	r  .> `b
_OolQQo?_Po   S5O[P'Q&.Q u!;ru
>'Q t .> St.Q*Q*Q>*Q'Qu}ǀ QmS< tC!r,Q;, , ,P'QQ)Q#z`&;!3ۊ؀`P&Q(wPr%3( )QVSQ@t	T0P[^fPQVQQg&" v\PPF- uu1,hS¾0P7gf&0 	u5&Qg& vuQA,XP
kq1P_Q[^Yf!VfU>'QS>Q>Q@&QQt(
ߠQۢ- Q0P_[P77f]^!Vt>/Q/Q r1@P=w%@>=rHP&Q:a;40@|P@Q=SQ  # [+4vb,,hGA--`.D`.L./-0 A21C@P[Q+9rQ&QQQQ5S6fSQRV 2ǅQ2RMM 0P]) Gb OqN	uQQ    P $1Pg&-@v@ -a/sRRPS>Q  U 3f3۰  U% vu0"Y'1Pu29uvtYue19u^\&YuM"Y& vZu:  8YwPu)]t]t]h = IZ^ZYfg&8! vu	?g&  vfctd@sPVSN00P[^ARVf PW^D_»8P-qYAhZPdPlPtP|PPP6."Wtt0pP藀Q=S= MW>PPSR/<v
hQ,ƿKPʀ 7PG U{ vrr])N-sۢqisl8pr$WFPPP:?Pwul`P
 hPDq t
Ƶydywuw l1Pkrg&1PtlxPRrP9rblhP r
 Jth%~intlVLpQ2y>xC~5u@-ts${:X:Z/,M <Pn_bfPfU63f000 mr<f]p6f  PQf3fY[fR!  f`0Qfwf3pp`Гa̰fpp6F E * <FuQ3t	ADt<Hut2YAt}Yn o$u tP%X!?Q PQ uB<Ft<Tt<et<t<t<Rw*<Ir&Q
29tY>`9Y!_euaVW !0ptAQ ft(PǴ:?Qu 2Ɛ gXfC?Y⯖*Q9 ǩ2JQku3բ ? t&{Q@8r m2>tw$_^D PQlQ2 Pf?зt<C0"<?tSQ(pذ`Y[߀ u
l?O3dde fHffCopyright (c) 2001 Intel Corporationf[ {;uh~u& [f2f^ t;ff[t*ĩtt f󹠠p
   0L+%Pf[Űhjy)`u" Rsf[Pfȸ &WfPa&ŷ%  Ęǋf?[f  ̸}@!gfBWf;ugF[AffgfNfP fofPF[ff[Mmffԧg_@?gWfgGSBOtlS% 1tY9 uIfۋpًՃgV8~}@N^wfˁf0!!9 uǃ0af[SfWfV޵rf&fߎf3 2_ffGf;q.<uGf=_PR_uB	f=CPU0u0>i  40u4f=NPSSufOffvP[-/8f۸!p	fA3f;s@e:fF1rff׀12Pf$@ Ta0աa 	f6q$PFH] 2G	Q\ T )C_fRʱ C`V R
 =G
M q !fItg  O4!G	dSo~j/O?_yNfub
utdֆubSnmfP@+؋f+NP2F	hsÂ!qοf^f_fA;_[wePMguA ӑ8t3gFg^%?? @X0Pbh 	 ΡesRupte[JhƂK ךJp-&`-uQf3fAt5f6[Yu  Z2#F+d` f&[r-uPh3<u	!%2/$<H<0u$`@H˓`<t<t'<t<<t$<t,!fp4 2B>=2O1) f=ISGufpsg][  "aòqt f6	\~>f	pe;Bj@ }Q@fzFt6I6+:X6!**<< V1I<y #A&_&P>7+#f@&#	7u0@pU6GL۟f7E >gL qsl@2&`F b CL%BujW1}_G@SLn0<P(Y)T$TiW<W11GZKMPK&buR ͑TE,eaF pL-طL`Q@C|2cgfdBRFjLft0mnurX3/45/t  ) b:(2? gh+wAp   - cyi |Ab6z @Fz|@tTy}V~   X~`*XY~	YpYpG| }ņE 		pfWQf| Dy=BEYf_p:sD=f.!rD=. rg.D
$.>r.%
.D
Krr.% .> rtAQ}GsgSrrLd
r9㖰|= USBSu@"|= tctƕ q`Cr@7b[r.Γ arFr2 8/dҼA`gЏS3@/rt 0r It5Qf0.FA`r
ٜЏ#f~fݰ^Q@𝢠vhH.\
؀㧓.ˉ\@rr~ `hP7srSW3hf Cs $g&D=V W $Խҽ| \þO3oZ(Zҽ0/(þQ$7q_=/%d
/$/$̢$Rz @.Em)3@RP2  h >}؁u `<@`T=
X(fT=q&@GȤ.6-r.-r . fPQeѫ f.>+Т+r M+ϰMf~^Vu06,,r +.Imf.6E!mÑ@E렱 YfXIqrr pfaÚWy3BsЏׯu*QfPf~gfjAfXYrϴ簘 a3G*/js~A`/^$ҽuC P"l=^quttt rD$
ƈD
򹠾PbEE r
rϿK %st-pt=pT= t:tt hP-QqA
(uV_rL"@u=@t=t=`	t=@uw6wfaPSVSr8dtd߶ P0̾[r8Dt_D$ Ag|Pv^[XSQgO	8t`g	G	Y[#Ӱy@ '	`'  F{}Arr3Կ {3!Rz )!z!Pt#  5;~tt%{%{Kmnoott&UWRQSPV rw2j @(ur(ffWRdߌh.L-fZf_ 摫uc QaPSsb-pu% r rrr/U /'B// 0r)B// 0rd[XF f spJ,t q- ^X[YZ_]c È/r2r 7Q17Q h fdAu
!0r!ddfdP;؟dP;Sdg6mT9d =mdMd@d;ŉ1<<S90r!1rQfUO
f]Q,> 8u%ttt t	tfN 7tF GrCu 4qFGHs
 41qF6{uFHhJ $KKSfQV5KtNtـ?fPf׶DdvofSTTff/fXs 4!GqFyuptLuY`Sf3f_f.+rٛfWpU.*&+r8fw*fF*2t*܊.&,rfX^fY[aQ_Qq7ٱ_q *n"P`aĀuoDPvr{ l&{$0	SQVWU&Q tQ wؿر]_^0LS-120ZIP 250PSQRVS.Q//7X7@ p``w!ka|drs
hGrgB<tV< uWQߒvf :uFfG(5qqrrXX  b-6ZYf`Qu %r!_Qrrrr nrc`eWRWe&f} tEE_Z[M-Sys   DiskOnKey~sw9'"xQ uy @  f<x fP P wq"rr 2rP0wb|=1s 1s
P 󂹲C f@fPuLsUt6P r)g&Aug&1sg&o
Ȱ pR rLTf<6xxByyP5z&f솻{e}|)yEfPf th;rt@  u Au A~Pw3`SAf?Yf@^`S`Y
Qf_Xuײ?dw wU)"xxxByye&f 	 zؿر@gPR	3W`|>#>;|>
<_hrF; 4  hK*_ pZ !fu+@s!$?
u$b$[p a 5 - i"#D8űT :YV` YD8Ųt\Vh8MF5DDYX0 "Xp "$Y "Y "Y 8GE	 	 YfWQfaY 
D5 q6r;rHsR05qt`w|D
$&q
ĈD
ґs fg&|5 Eљr`r ֤a_`{tmزӸEѷM{ع rӃ `F|H\
؀_q
܉\Cٲ[se V|aޟ۱V|`	CSsr |0r r`K5&1p81	W3
#S r4D=Wct0rY!
/@/(SrkȒt偛u6-i-r60rEQfPЊ5.3f.6/`gffff.0fXYer8gp
o9*?a5OXYHU`Dj/Os&`諿 s6큅t߻d hPSoGB:uќ@Ͽ(uIr?u=@t=t=`	t=uɛ{tK}fapQV߶؋L	;t	臼聼$PؑF|h@bg`Q&{O	8tg	G	g.
!0 0  R       1} a 00 U3`$
A%1Q&&$' U0 D$
 )a "\R'R `#3" (&q.- <"-+/--q.] 0 `0 "*01/S.03D./"%/ (545A,s,5,U,7, Q&q2*+3:,/5
-? .?256"4 -#4?-!1/r/>&@2!1+BQ-@?&4>r?&rEGFED##b?GS0)3AE .(FA AD!45$?QIuLQ>@51)&EMAfR3Tq!T5EQT 3,s0%q.,;s-Q2Zs.1V?+* $])17 7GAq@ u-5A21_6`Cu3 PY $S5*6p._q?3&<11Za.01 Hf5g TS?*Ku-54r-B;b <%`PsYctSTa<b!,Ts3 2U(r"rc-"p,b@c"dqg5R5R"1z  ${\`Q%Yr<f.;t4Uuf.7a#~f  0f 3gf0=  v	  +v> f3݇f́ 1 n ݇ 6Ã tQN@ⅉBu pǋ;@t.㊤ 1.fRfWz֫f_fZkrraff11ϋ!fffROMIfMA{GE ;uђWt`g f3TPQ@J 2`fGpZYXuGGc 2p2 22hƂ\t"t!q t	V  ЃSQhtuY[ǿ
Y[W  c c"u'fo t!w ׹ @ 2~ђG9 GGfsfsfoӸ 3ඒ; !$O r7@ꀌȎ`!l0`!*q>t caG r  gf!8  N hq.Bhp   Ʋ`m`HPQfWfV"UUЮ*nUAhZ#f  m'`GA .;t3f^f_YXhBc  RW0 mƳ3ɅA@kǃ0o<.Qp2Xf36 f}}30f\0fy̌>f C ͢32f;Tuf>>?.ߢ0E1{E2E3P.&0Ҋ?@Հ@԰3R {C< u!؊ð?ưCҨtXruUC҃``r/wȰC$8tZŋPSr$u簄n㰆g`rL_rGW`@9%8r @q.aP !譋b	0 fPSfQfW
BfUGOb y suf3Ɋf`gftfY[f QP@pg<t, tfU r8tafGn$@5@8t߆ p}UvPЏF X P..!XP..XQ /O o	/O
 o/O o/O o !"#$&/'O( o)*+,-//0O1 o234568/9O: o;<=>?A/BOC oDEFGHJ/KOL oMNOPQS/TOU oVWXYZ\/]O^ o_`abce/fOg ohijkln/oOp oqrstuw/xOy oz{|}~/O oφ/O oϏ/O oϘ/O oϡ/O oϪ/O oϳ/O oϼ/O oï/O oˏ̯/O oԏկ/O oݏޯ/O o/O o/O o/O  o/O	 o

/O o/O o "/#O$ o%&'()+/,O- o./0124/5O6 o789:;=/>O? o@ABCDF/GOH oIJKLMO/POQ oRSTUVX/YOZ o[\]^_a/bOc odefghj/kOl omnopqs/tOu ovwxyz|/}O~ oς/O oϋ/O oϔ/O oϝ/O oϦ/O oϯ/O oϸ/O o/O oǏȯ/O oЏѯ/O oُگ/O o/O o/O o/O o /O o	
/
O o/O o/O  o!"#$%'/(O) o*+,-.0/1O2 o345679/:O; o<=>?@B/COD oEFGHIK/LOM oNOPQRT/UOV oWXYZ[]/^O_ o`abcdf/gOh oijklmo/pOq orstuvx/yOz o{|}~/O oχ/O oϐ/O oϙ/O oϢ/O oϫ/O oϴ/O oϽ/O oÏį/O ȍͯ/O oՏ֯/O oޏ߯/O o/O o/O o/ O o/	O
 o
/O o/O o !#/$O% o&'()*,/-O. o/01235/6O7 o89:;<>/?O@ oABCDEG/HOI oJKLMNP/QOR oSTUVWY/ZO[ o\]^_`b/cOd oefghik/lOm onopqrt/uOv owxyz{}/~O oσ/O oό/O oϕ/O oϞ/O oϧ/O oϰ/O oϹ/O o/O oȏɯ/O oяү/O oڏۯ/O o/O o/O o/O o /O o	

/O o/O o/ O! o"#$%&(/)O* o+,-./1/2O3 o45678:/;O< o=>?@AC/DOE oFGHIJL/MON oOPQRSU/VOW oXYZ[\^/_O` oabcdeg/hOi ojklmnp/qOr ostuvwy/zO{ o|}~/O oψ/O oϑ/O oϚ/O oϣ/O oϬ/O oϵ/O oϾ/O oďů/O o͏ί/O o֏ׯ/O oߏ/O o/O o/O o /O o	/
O o
/O o/O o !"$/%O& o'()*+-/.O/ o012346/7O8 o9:;<=?/@OA oBCDEFH/IOJ oKLMNOQ/ROS oTUVWXZ/[O\ o]^_`ac/dOe ofghijl/mOn oopqrsu/vOw oxyz{|~/O oτ/O oύ/O oϖ/O oϟ/O oϨ/O oϱ/O oϺ/O o/O oɏʯ/O oҏӯ/O oۏܯ/O o/O o/O o/O o /O o	
/O o/O o /!O" o#$%&')/*O+ o,-./02/3O4 o56789;/<O= o>?@ABD/EOF oGHIJKM/NOO oPQRSTV/WOX oYZ[\]_/`Oa obcdefh/iOj oklmnoq/rOs otuvwxz/{O| o}~π/O oω/O oϒ/O oϛ/O oϤ/O oϭ/O o϶/O oϿ/O oŏƯ/O oΏϯ/O o׏د/O o/O o/O o/Ooڿ aL8lLagLc,lLۯ/Oo <RwS2.  [Kø K Kа"KKfQhv fY&SfQfVfWf3ɋP&G    &Wf&t ffBf;g&GfPwwUtNtGf}h7
3؎QgfY tgh Af_f^fY[fPQf!Uf&fgfdf=CTOI A Cf=NFOR J 3fSgdfCf[ u|<!!{    *f@   t6f!f! f3"DgE 
tfEF!t{ f!	"C< u"C u-# u rPmgdCw Zr+]+Lr++׆>r++u0r++"(r++(gdK&.f]fYf[2XfRaQh
hӏ 44rX.)]0VfA ]fA } ،A M p+E + .92:+sl;-h4:1C2[fZ_3<44 57(7A u8 9G9h40fRhmGfZr9;/<pO=o>?3PS 7>[ 3S (h 
rhX=
2f[èu<w'>, uBU$<w	TBf#*p
S>+ t7 u1 u+
$<t tuFrr	2߾ [3PSQp8tZgf&gtKaFr3оg&G 蔾su0^ <u$
߾3` ^!q]O   2_ Yq\}P\A8tg@?"r^ \\#8tFtT^3`!X	
VȾߏT 8t"8@7r^[SQheii^t,&
uҽ>ut
$BsE t>  nZu. n}Rqt$co	&
sDp
 P
tPl YpPZ	>X2
XhD@U#t4 8@ Yy+"u?tCu+vZ  Y< tp
$ on aouow@k/i>0|Pj؀
	Ѐ>t@*tzP Y	u Y[ ZYtk>%PUru
~{jv   "0Z_$tӁR{ YoViQtZ~ѿr K5tFx]^Cat"Q_rŬ1|aaY\q5tax]tR XrDwCa膳{Q_Js_u%
߀u"2`(b25c*tzu Bطc'b ; sW;"sQ؁Bu	8uPu"!
u蔼"
2ÚyBT	 
 à
	蓽to 芻 Yבּy 	*!{qPaot XSfWPvt
(4t@d_8؊f_[ %/Ooϭ /Oo϶/Oo` }@0 hN.

ɀ$ t
h#eY 
a`⣾eA(@ u B
O aSR`İ!t@B*$|Z[WP h#Xggo_r`fgfafQRfWPSf3
f0<  ̓P tfͯ; X Dt`좂
[Xf_ZfYù@ fPffffX,fV3ɎҀVwfơ$E 9sf^@&9f^B̕V?Tξ:ϒР
r ^dѭfҫW`_R$g&'0f3 p%p] \WV .- t;{A'>"ؒ>h5!,{Q-Y,^Scိ>0ułڷ,,Sc,.02@8b:t"FE!+;$Bo#uUDl+nG,VF͏^y<6>GB+$`q 
a`&膃aPRdu" 0n  
 ZqPQW,%G_)Pc\8!{9!{:  .t9aPR~p tPfffXffߣf$p, Qʁ<YPu`}3P~KR ?!` 
@6`XP߿ f߁`
  h
/
 33 #PK   *04pT`QW܂	
0  Y*  m*zbI]*b
9M*`p\4QR	"

߃fA:t
x	zZefPRQa% = u`= uo= *^= *7A
 
ZY3`  y) L)a)aҦP@3f\ 9t aP3
\
@#pe@#(@#`*@#.@#A
:@#8@#PQ@&@@#D@#H@#f '''','0'4a%'bP\+`#^(+pgt/ N*a3SVC[C vS3ۓX说tBt:߇Bt0{C`0 [`,t<w>t8Pu |@ŢnAUݴPu
 @)軣4 Na rtVt3#U,7C.CyCr`,/ r#U۳7|<@fP7 2&8VCr5 #U
7	 fX`,3Uc98"75$!{^`<t1 2-A2=T9CD=.fr8RA:Qt08=Y 
:HPuH V%C@>5utvGV/C|aÉL MH6

 N6I6OJ6 N6؃?NP6P62?Lm
s3y@s0U{UY0UqTTF0UӦ:wu;Xu;0YtXЦPc >ID0*0\ 2\1x K!_H:r:Ȉ^y&11Grܠu{0 	&ðE^ ww
2Lpr _dyY)
À
v(`j>P/Ԁ124j2jF10 _:x
PP@ _ؠu `w0`ῦ؎ Rf쨀u!sZlfaq rrsntߦ/x qоr( ؾ kf&Efcz @{  Dp{ &Etp{"D}B~$D(Pts `pzC|DtȀ >@" po
7&t
 `tyL &}u??u8&=O r1z`o&
I$op{ `t` w肠mpm 
 mԀ'Ð@] !s簍* $p2Oደ pgP1PQfs   $<@thZKuKfP]Ku냘`.>>sKt& Xr	NRrn2kk蚌k(aT` Xrr Xn#!t Xr_k@z X!=AoO`op$a+fRQS[YfZt cz};G t]GtGu蛏a2%p6_##p6t SRfA^2zqE`  b.JhXӏ 뚿 2߻ 4 ߃tR ft<Q Y A fA p  u A@3A"A"߉h8? H    qQQh[raJ@£ĂZfA  hqʃѰrPrPޟR 000Z`SW t& DEB D3^P<PR3O͉0Q h4=Ǒ;$boԊ'OׁՄȀ f`.&t.vt<DZ6L6C(>԰D2t*~
඀Dst-D0D%蒨K !!b!tӑp]:!4*!!
qC47D!"+"_5t4
CC4b1֧PX3pbhՕbzиfP"4 u3A1P˹
Ѷ+Pz 0!Sz33_ @f ..s^$٨9$  ` }   p` ` ry`z輶rqh7&@.f   Qff   輸fRr<fݹ @sr( fr ^r Vr Np6C # @   so讵Qis-]#J3.;'tH\q㵜qrA#!
䡢ru!P* 2+aÜRёllJ쪊$JlJlBBJZRW(O/A6@=PV_ZR Z6KQVW  _^Yq+t	3켱 aøo ˶Ҁ{#sq)q #G#hrP`8틿P%}Q+Ⱥ:#%8  t
ف  P@`j t(  u8Xt
 %P* Pé 0)3%@*tOsHf3 f0yff3u濸  hfff#f  
fh
/0t#P hC$ ]߾  e2X*P&%q4X$vPSQR.%14#؁'2&41'uS0/ /ff*  [%8%%Q#~`Y3#044;f;f% 9fծ5$
4p3j@bMoP> <`>9>gP>!'QN
@Aȿ''f5W"t6%D pGπ<
q9f_Pk%{m !I$t հ"X$f%f_#!+$% 5 4nJ0q1+FaC@+
 q"qQRf1q9RH)H3:)3Q(o]u
Yq*QHf7ZY3AMSUNG
bRLTN150XG-L01
Q0P3SLGPhilipsLCD
LPRE06-A2RNUX08-A3M1AUOcRaRBR02V1`RS41XB@S2
IDOTeCMX[7@S6Y[CBSTMDISPLAYRD[EA0VRVX5?]RQ[3
XG01VV
 &&&&&&&&&&&&' "$&17DSc "&*0DVlvg$(,2DVjrh*0Lbz~Ag*06L`t~"$*:J\9hghFZrj`k:H\hj&,0BXri(,4J^v~gBjRm.4J`~~l h>Pl~ .'àPpPpXÀ&5P68pC uL =TqA~̀>_?X+ tPSR%%3%  Z =	`M` 5vPw԰wvZ 33?Sfv] fI_f|zfQA933 fXr{3=*&(P(z*¯f~f1.UCESu'fÿfRVfrfbNffff^fZU5@MW"}! `Fᇍ~ PfXߊˀu   t ` rWf   O!+C@ t>0't t.atS
 S@  [r~!fn  !._QҘV#ؾ   t
ff;t7]0
 '0'p഑E{Qhnhr|{	 u2p!Ӑ2
fffL0h刮=h.T{3ҹ  &hYn/GVU01><$F10u t}S _]^[5V ^rVS 6yD_2[^ԨP{Q :D~~0 +Y dꬱބd1wDQkP>rd "r]rPP 2X0XP<s螕X1Vͳ+[<u `F:<ܷ}%P>6r跳r#PGMȳ讳P> rm0xP>`лi>:?,m,s,`~s	,r Rq
Qa覱r(s
*rzeD}r |{r`Pí,,,-V~r .,^ i VWQ>` gK Y_^{Cʊ3.:st
$ }.h/.tbDqm2h;沖t0ޜh݉=rs f4f` _Ҧ` u
t۶r <O@OfaBf`1.XRf7VfW M3~< t`NXf_fֿ/#"~ڹ" hf`ր3赗] a2V큡&?_ޟaà> u( wteg (au!>tSes au;
auu> rS !89:7 > tTPeO Od2Ou$Cl$?< uBB qQW<u
%7uggw@P_YTG	7
vv
x1S OS$d OX	aYtS
  W@r v	yp
^ {Z#zp
G|a6}P6ð3UJhrru" 0 qL2  խppp3  gff=HIBMPw u` Ffۃt.ft%"t =kt#1!f[gf&pQV А=q!tgfF àgF(P+  a'SL)@ N u;gf~fgfVf@  @fBfff3gf1@qsfY*+F$ V s	7f!(1+  fVܡ0%N  ~(,Ffg!fo+s
	!Gf;s{1,Ff-f@4ffQt	d.fYf^`'N //Vf fAg=uQ4$fIg8A4v4@3,,Q-7fƹ015f/ .4 ztB2ւxG.>`CuC%,譂 <t=> \}4 o*>GuG{mbpEqFkG_ t@5}4đڒtÑG-ƒtssN NC蜐 LFP&ݢ&X?>&  pREduE)MEQlQOREDST`3 /<t+
t&u
$&6.EaqfWۑt"跮tquCst	g&G ^!f_r譏u跎ZKu\>Рq&tbcr0WV&8OufreSՍ6W p 2:> u6 jHt4Bjo hfk3Ҭ؋hfB^:0&df}S>bj2ummQnm0k>n2PoΓoPuoplq^h:por.BKBp
..`~9>6 @u:XT qq~<]ٜ@ug\s  uuo!uks "u7ߟ1t =?
u4|Q\%~Y"PņSr%s|,}PB>:9 u09 >;9y/3 Qсq99(; uar6j?p O?_ߣ ?_a)Q69r[>1 ouC:L c 61%3Ҁ7BBM 8u!u
{ 8uѭt	3ҋPW
 
t	_ ك
_XhN].qhq
/f33ɭFp4f
,f ffup2fdQRtp$fǝPZpлtH󹫡QVWJh .# ~@ 蠀_^Y^螜r"VM#脡<TPSQWh[qr6hl,tQW _Yu  t
t@u_YdG;	 bĳPNX dPS_4OdSA^0u2C_ [Q2P}CщXx2[b.P2
Pˀ$
ÀuE;Xo[X})!Ω؀  {
Ύ2` P(<KrKXF
 薢@ !P/*a f 7@3f{  @%@/& .fq.r
s' f@@_Ph %>k_ft|p\f%%@_ PfWf>&G
ѠX<t< ^<lGlPS$<w
.>d o>pS31hBf  ء%f[U? &U?U?
+ LK 
8s 50Pz 0V$<
v
ط   tǀ>M?  $
2ho$@G
-d t㋷j&؊ C^h~e
}
-dS!
 BEBu M?&N?(! M?N? >N? u
8wP"f.7s3Ph@fA@ 4A@/ApA? g` rA vdAg
A|u``
hA.
	 ok #ij# WoY/SPR.AZ>.Ap/BZb""
ZP̺1AAΰJJ/B  `Ǡ1PB#X3pSR0ċذ4ZdQSW _[/'pك(QJya*a*?g?a*	C%, 	
L-EE/;K3EGO?BK7EHV?r1`L1CCMCaCWCkCbK`Lݿ-H?S 3oHg3&531C5610.&5, ˰D5R}0eW	  X f033ſ\ 褡:3~;_fYPԴ9$:: `7f.CQ;u&=CV<:[a=o f.>fA;7f.>ZD<9` ?@, pJBC	ÔDxDDD&E,EDD  cFuFFDF' EU_UEHUIAIH]TQTL7KD\PUUJU UUT 4MM J    T T ANUOЫLPU &tH{u
h9qul/qr*VS>,ư,~
j2qEQRR?^@ucW?u
 됋WΐvâYV kPΣUVMX PX`Iq U@:q0 
03!4+t
3NO+t3GNO`UNEEE!bN FJ쪺K"ca`bab`abPc FO Fcfcca%ϐFhFs2.F/rR"psf&[}%h;S>uh^|rhFc|rth=bxh%gq2u"toN4*EsuQ}u%3#qYBs3PvDr"v& 8>u
Ds {o@4o@ZzP&34[oX@ZH8p`HH2Z^ _ 2dqvOUV<202 Pظ`)g$`([.0>' ^]y2 	?UQ FډFw  hҷ35@kВ`&&& !􅋋FF FԀހËqiw
upiu vj`qkrYk"k@Z7`kڢ8w&9:y)xϖI,Sk rIPir<Mw&?ѝt u'fr6^iu#  h4!ؐn3hӷ2q$>!x
_ > )xGqpwߤ 9J8ټZZ{  :Tv ׼H8 s@^e49vPKF X P.J.J.J1XP.J.J.JXAK&AKAK$qvd@͝S8rdd}rS<dr
d2ut
w_ t }0d1R^!Y0YK0YhcAhchdv%p8LvhvpStsP
µRm@Z jVx˵õÀ`7?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ ! "#$%'?(_)* +,-.0?1_23 45679?:_;< =>?@B?C_DE FGHIK?L_MN OPQRT?U_VW XYZ[]?^__` abcdf?g_hi jklmo?p_qr stuvx?y_z{ |}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ Ŀ?_ Ϳ?_ ֿ?_ ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_%& '()*,?-_./ 01235?6_78 9:;<>??_@A BCDEG?H_IJ KLMNP?Q_RS TUVWY?Z_[\ ]^_`b?c_de fghik?l_mn opqrt?u_vw xyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ɿ?_ ҿ?_ ۿ?_ ?_ ?_ ?_y!$SMM MODULE -- COMPAQVERSION: 1.0 t胓?ǀ> uS4uuu&g߸ !瀯 Xs_m[ðDX$ htvߙ r
8 	t .pD
y?<v A
-  !:4:!ӑƅo#Bl8ې[Ӳ">G]4D  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffh	t$hp$Ūr> .<t
../!N!!NfafPSwRV 411fpr  >؀tU.a!/tS%B%
%N&N-hr^Z[fX11#1rP.4XPSWRh	 > u&E *Ou&} u.wC.he	t.,Z_[X`-[h	$&]r
%[hm2^2%^4aÀ>7 uCeȨ t$<w:9h%	R>t"9t9t`9 u 
ZSfQRW9&C::%;d ;<_ZfY[ 7 t|T蟖Ts贂jgP<W6_p@XB..C.?.ø  PRBZCEBF3%0u$bH` um >89&:-  %AJt0 	 	qL
  3  ti  MV ".  f@@u.?2h	P)P0Qt
R<0R@TU;?<x/GE#PFXTX.$'7NNO$O"FYZq.GfP3f&T f'f1w,S-0L	-xs.tH0_.S.>>sR2 hP	v r?ߠvd r,wdr rtB=u
p踷.H0[,k b6H,@ ۋ^SF ^Sh(	[^ l   R6PQRp쨀thGct
{.ZY`)E؎ffR.ߚ n d 6f30Uff,﫺.s8ss> ?Qu>?v2U :\hr	f0p  ff.4 QsffffOO}o~ ρ/Oo ϊ/Oo ϓ/Oo诛Ϝ 20 1pP-Շ*   Ȏ6 ўPp6Kd y`X1Q
O {\	`fhjS9f`PX8  G ^ {PO  SOt% r  P"#QOU(*:43s!t3@U끰2)}fE0t{퀳,.ZP)`p&  !012  0m"[ N˸%@F`KZP    NuiZaÿa$v$
avﰶCBPBB#"w2B;raP;'謻!
 QR"R3	ug  s5#ãZ3U{fwB7R7*h >K u&I&O5%L.H;tC2QuP&??,ȁ%81@Ë߃3?é t"q@ﾙ h>y  єΔr@DL
 <%I IW_E$<r' d}dSH	l4L`fQ T h.Rz9`t.
h
/#y2f   ܿB  hľcڿH hNcڀefY!m!`U߿詽Ff`ȟӏ W"PmVUh	D
  t{| uu| up QfFFF 
F쨈uo2ׁY<u UF ]!YnIu]^o` = m߱@qɾj a hS` prG׀ f  2f3f% y
 O0f ` tfIAyf  0pp!P!1 fb
 `0XX!"f`p]fgff%PgffPe e``BldaPDCX  D ; Z x     0NmP
|0	s<Pw2 rCfWfV0\sS2NGf<5؋6f6f;f^f1fSQfRWf3> w;z0ptp>K 2G%GGfflf _fZYf[SQRVW6謊33	%	*//h0RmZ0
U 2.T
p@07 2e2#a+= v߸ cp_^Z@$
W0
w>	
``_S a}a +Qt$t" 9u`!!P.yt>*袹$,$+$E$>@ t:@s@$qÊ&P$rh'%r^A($rTp$E$:.''<)G-#߀^`4r%)Fu'- (ðD$&J ]gl%`0؀w5SVR_S.
[.t^X 2@2^vX\+x&%&D@$ &06*u&d dtKs	2sw@xw-?< W-@tٸ 衸$09	'p!;q9p.Q.H5D4 ߰d. CQ-?
`.-.y/YPQŀu	Qt2-̫X-tCAx, ø 4"$<G" P<ēH6,ð33`B%, 
  KJ&@BM	 ~3MHȃIⶊذJ۶2ȉ  uqQw Rg
R@u]<tuQ0uIOPTS gU0@tUtXTWr= tS tD3ۊ:t
u
> u'| ߶A\w@&
" [fA\u$t2M	a_f^]kyyr^fb w}	a"1&_簢de-xߊ'È%}q%9%0;qO h#n$t
\pi#nh#n. @2hh֧hrwdVnowðh*hh+`ppfZrh-ursqf>QPH_u(lr#  f&?fbzݖ {_!`òy-+r(6z1{zcAr{fRfVh fotY uN(t ;(wTfϋ6*tQ r?fqgbgBqgrf
fA s[f сWf> f ? tHǀ tf f? /#fBfPfQfp$fftgf&
tg&fYPǡs09Ü͟ fybbˊ 2<w.y
Ql`uFx 虲t@$\5$pѝ2MeA
!pa	&㛁C b ^! t/ tW wptutj s tQ#
t~  s`E]2<n]Bq %t"; !P

w	Fs 3M^ uk4Y>`;>t,au-  A\7$\6a #۰{Ȱe[P^  a1_v  d >uT>u%  ~uAtfseQ1赓&:> Bѻ) 	*WXc
d@aun<
u!* 
)tB Ԯ
GPS55C01DU$zW˯$Cmʱ$X[t9 !
r$f̰T/GS0pWqA[]`[&wuCлZ\_>`t'a_uu{`_A\X 'ϒuq
zv[ô7Dtu$@
2퉱_醪zwm*EFu!^`u
Y<Oe=Ǟ30b1!{
 3M;rߋAо
\y ǭS#
!B!<u}4{Aysd!P\a&&5踬$}8 sܐRo?TĠd E^и -ŬP424[ u)1&^ s`[Àp! = p s
aa퐸pp>t+ߊ&1ՠ&
6 r)p0H;Sp<;w?<w2}q)
<w< t 
<w>r2Y[MbQր3
ao$u] ru[  ,PTX\`dt , ,<  <@DPp  DLh W@, ,0@h
,<Hq <`hlpܠ@< <p;
p   $(<!Y!  ,@DHTc#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CDEFGbxz07HPXYhijklmno@I	

 ?O PQRSU?V_WX YZ[\^?__`:a" # $	` a>0bbcprcbh0
D
p0eNNO0fOhZck  є0hhN.thi處߻ 򐢺[mi j3ksk脔SfpVW f Z!p p!ppap!p!pf%  f.2fff7u_Yf|6of":vءvfwr_Gs
wvf0tBoff fY@`}f
a}0z{}QJfQJ~P3XPSVWfQ߀s:ؾي t
@u ufufpv @uf  fY_^[XÁ

RP.XZ

P ^'f6,X  
@WSQ0sHB	
  	 hrjp
Y[_ PJ4d{Ǫ
:j۫BӮf`f.1.r..16 ."v
0q.f.r.rfaõrr P1X
eu`Pf hGh3 XE0u쨀t
F񡛃<u <u õIr$rp ..p.C72aõr]rӤr{x4p7a4R4j;~3` P;"" QY;]Ĭ]ao r&.wO[MҤy7$' rW 33F.&ҤR1Ѐ,ZQRr3Ht2ZY`ңٵPt"@ZZYa1~r#3EYŰa`ٸ 3x f3& &EZ2 Q&&,r豂#r8t2`.&EO hhУSjAahhh[&M.2tL $Q #h s 5W߳ hsRhj2hӏ ѽќhѝfZrh  @_vAw35 &E
,1#11	1	2v1ahj%00` }0P% @  Da`6(    aVī^W  3 _r-@1˸ fDf@D@@Հ tBBO䒱
rNr@p nRпW2&*G_YS߷ 蛀&*@u&}Zu&E_FPҤ1ڏn rg rb2ۃ<Ot	B<tM찱BÎؐTr; 0rg r 3hAAɉۊÀSQP
pt$<PtEKu{ #BŠY[[Q @1uu_2䡛Y~о	V o^WmPJ%Q͹ YPSg9[XPfPQ>Z uι c red`ZY tCZGr-t`w 0 r uҊ r
6u`d YPrdItf s`QRx!

`SRNr&r!ww3҆r r	kZ[ oRS..rQ. o .ї2ׇ.AZ
}g{Y|Aj
#[r	?ra5PPo   dtgfYKuGv>? fFSeT2 Ca^[ 
 " @$2g, JQ)2E>>?@SV-C 1޾> f<$F10tuP"X4 g-$Sذ* W r[g PPS. 1 U Ȱw>pg?0U007?PXà1&(!1b3ء0b3!2(P>t
!2?1#S5 t33|21/4
t8  ttÈ?aJQRWVسس+3> ? 쪟^_Z2>>31?G<u
tp??V{ҳ^W C_BͳbC@DC!>(P@ϋK7??jFBB9?q( B
g2/\r`LB
"2PR9q?Z!@V7 tU.ߊ.FPQ/F.^ 2uϼbSqSRVа7rNPUNrC2r<,r32trr;wWҀPsڋƿ^ZW
@T  е0u
˾   Su ~ fAT u2_f2_ J3322^t__ ?`Zrnc
$	"
upSƋ߱d;sRZ3bFcF252tf	uPz
S_ø
_.P.2.a.-rs,@4PnߊPÐ< <qe <`T2<q
 h =u?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_߱UPRPRVFZX RR3Z_߻ ?_¿ ?_ʟ˿?_ӟ%Ռߎ؎JЍRhvnS=`LSiqJS0ff%|h f
  f4ًf#puOt\f   t(,#%9=tu!a1 ȱ tf.<fuff[fYb	-CcۿSW   | u   fXX	?m^f=Rf=ø  <Zu!X?r+ X/<p;@X hcӏ kf r=`  t	f1Phú:t-t
cfXúA $t"t
D% t
H"W2螌fd 7u"P!
} t 0F> @+ܟ d@% &뗽.QtC t࢔&.Q u'u! F۠0Q t} pt
Au
S% [Q t!A	uo2PRu1F
P  3%W>`7
%zb< t
b0b 7RsA:s u
A!St``t	to
Z2RP߻*PXZ+c.Q..{@8aPfSR.w? 03.$$,!fpًfGZf1ڲ@%O PݐX2"#8#s#P g r,2fSJ@>ر#t7  h.v fȿ fڿf33u^_fZfYf-R3һX3t@sa `0"`#hr.
 &10!%pP&W T <xff   Fx_fY[S1hNc($_x`3%0
CxP
t%-؃?2没!"`a f] 	!=(
	
	
=fWfV3  gwt܎f g&ff^05p.** End SetActiveDisplays: \ R$Yt5q )㋗ød_R;taF _uq Zb	7Qg`G ^GiuuuRH`RSQ2teFS
͋كA5  }@t@P ސ 2HOKPb3RR aFL3W`*JS$SDg HUu
_ XPעŐOOtBX	g9@ {P`{P$O{{ċ؀ {X[{X߾{Z+ثZV[]5\p]{R/ xZ\R\ t[|{PbÀWtp]p[ap]P`QRPSaF[X3 Ae HDCeSS
>RUr[j`i/`߿ƸPPOu" arW2s_*Ae3tr "$& `qE"&]B* _f'faP`P:??A?j:b	VS&fWU]f@+wW_p&ð 	̓y  At rH r`Pwt *&W>{sftu Us?@3 XtfWf> f_`t5 tfetnIfgflg g_ԟ<_u	҃2gau=p>tQ SP܀AeX[` fo"6o&dAt/O  I (v ؍6Q(aHx1t]Qȏ`SkO_ Owa'<`*߳ OpG軵Q_pS6dW{P 
xp& :柙`? & #}wV2&Ƀ: }cfX$
u'f( ffCTNIgf <Pgf AXt-t5tLtWt_ p zf:]f!&ėuA:D1"$&wɀa\t f3f&~ ffȐ<u<]
΀<ff7ݱ鱄<u]ff@ f=  &f=f=	wf=fu  u%^<J0
{*@uUм
мuмpuqD؊Đ$
pu#q   ¼A qu}
qмp	Áp
ur`q% tx,tuLp3fv!tf02  t,  t#`ɀt  st
r5#~u'Ggf5 1{$ . } f^S+p&Rf P+pQѾf   

 fw`тfofZ.px+<:W 2A;0; 
 R=	:w=f1`g ?&Qfpof!ܹ
P;f?f!f+UwFT  pR Fp u
<5 &0@ ᠁fFPEfNR@O@`X : 8u	@f@f	^fvfX&ú$fӃ,!(fy}?fXnbfXfXqõ4®C7DԹèbwĨUD=5uӓ
n#;[gېyFu
ӍcAHԒ"Hӧ儅>GQb٦D
cԶUUD5`5>PXeϹsϴ[ho	hՕR4AlиP	 sϹ}01	#hrS rϹ}ϹP
	{_  s i}  0l. 0M  33 @f  ..Ws !
{} 
PKh7R4&] ۋf``D?S a=[XfR0CUa {PSK Z Qfݾf`Yf &XP   @u:p2?P  u$ppPr rwro
u\s
Hr	#rrXy`l`q  ?CҐ
Dr'1rr=% LܻM h')R4u؝`,eyu$ӐaQ3((d BB)YÜRp*nBnBB2JJnB$-nnZRV!(//ۮ@/6`1v^ZfQVW  _^Y`%xG0525a桠
!  js-Wp3w.; tt[=rAhpp'+t3Њ5 <<=a&Køл
ûHF&s;OF&PF&3;t<u m,J.^   PEZAEAE8PE9F:F7 øtðqKwq$`IÀ&j`Cl` aöKؾ#LLkkS`333 &&P4[Ü`#  0-nnt QnJFn aS [TPU3ێ7!C}&?!Cu3ۏ&>CPQCu
>W_^ _bXXuYR .'ZP}h%@fh< S .[Q3@ P= 󥝱QÀ>ӥQG1IuqIu`&o&OPr7^aPQR
cf&f=XDZYXð@guA`uȰBYu^frqf޶fS2c&W0cg&u&87u&8Wu	&*gAP_`
  YP#l2r(ں 2!l t!lS'sz#l
y_#pSq!l@
 qwBrWX\`XfCu vevt	 r _bc@fdnr2ostqduQ%nYP_ XSQ# I аOsLs;vU&J &t }uK H
QPִ薫 V谳XŴ5s{1J_|>89&:迅h7d%.հ~3Ɏ٣gi
r. {u	ujPQfVfW@hq]gf&@Uf_f^YXQWV߁ ^_YݤD̨+t1QWPPhX@.X=X@uX_`QYPДP!.$>u
P r@XuSWh , s h%>&M&E&MƝ_[`>av$PnPt3Ơt"3&MaE<ta6C @TA E6FAE0E/0 ߱ h.%1~fPfKR@`PX48@+縼@  ǻЩЩ.&Ciۓ'\f>PAMS> A K>f Q@Ef&E 	 uѳ/%ĳgc`ׁff+@MW \f  P23!M h#BÒR )VqQ  <X@84ȐBf­dfRhӏ 5A@rY:0N E6fP < u  4h,hrƧRЇfh,˰ |pr"h;%t.ʳ˜ҝr@ `E_<u d~f@q2ؠӀ X`-Of  t3;R@:Pk"aU`Z"Ў*QIPr|=t&} t$V" &GF^P` XV|P^"Y߿"a0XY  hu0. #&o;MR*:þ 	 h<
!
"
ZP v& P~̀>?prX ]XS*@S[prR0 t@ZpJĒےжq,&tImD>*ߌlL.GYXCItIIlLJ
Jl=D'8loL䛂
φߖsڟ>\TݳlL	lLn#lL`lL1lL\L~4\Lww%iL~شx7ȫȿFPx:'f.u!u <uw2.kf&
Zb_O󥳭.`9­Sp]ذsjrjw[[fS}@Vf ;xV4t`X?upf_ [ff[`wn_ g_؂MѱK;`t] t u̡k` jA­ffw؟ՠs
R.h:Rp𫉁+f ͉`?#q"vf̖ #sܲd/ ­ֺ`/0w/c2 j%hn4F sr dk)81Q&h*+fQfWs`­pft,f^YR]Ѭ_Z ^\@@ѱ(@Bk?%oBBCEAeàa)Mjfీsg]  rC
vG,-./01289AHIiL,014589LOPQS?T	U`a 3 Е!WtWa`$a,PSr 	V`CW?GWS\Y[2t0aÜ`h>@ l> l`GA lBlh_a@_6`$?CP`! GAc@^cA ccB  `b$0sFf@_d_  abbÀd  BnnnJF$l%JFOkxflj V ovha<	 t~q̢
`ròpṕqq@rbPޢcu
   llB cwؿ `lBB`wM庇 l z z z z z l`Тavhv-wx=}xTxZDa@Y@
@  1wFFn֗yn@znznzn {nj@{n{n|nn}Py_`a0rt81w
@ww̰pu"
RaxƀynnaA	 n!P nbYcYa R%> tVb"$Гb&~b
wb$
ဖ{pbГbb$b{bb
 &}=QptЙ Uߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ןئ`Lc ۯ$("dܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ !" #$&?'_()*+ ,-/?0_1234 568?9_:;<= >?A?B_CDEFGHJ?K_LMU  p   
_5MxM QRT?U_VWXY Z[]?^__`ab cdf?g_hijk lmo?p_qrst uvx?y_z{|} ~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_   &  u    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  @f[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 jea*
`e eueۚe	e7aP 33Ƀ t	APuhe&>ReaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY2 s1r `ABCDE @fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 &@
VfPhPf0  f.e ..edfX^=Bo>f?'Q@g Aoo1 .;dt*0t .G ATftvGnf  4 t 虿j u3  FEA#FSHt< 	[SAN> [[ÿ t$vNrqo !PSQ3۹)Y[Xf
	.`As.QI..Df.|qUfVfWQSo3rWt| uX!\t[Y``C`03k;B tS
tw*
t& 	6Noo#x#` p te"eCfTf6~
ߋ^ Ra[]
 UPSfVW2{ +t {f f t]fAhmP[AQ J rg>Ut2gFYPAXs\Pf3Xsf	][X]Sf0WfP f f;r[r}Wik mAюAog_Pp?mSn Wo._ p&5 rsgNY	g/Prs F@\ZSWP7gfFfgf;PCIRu-g{ u	gf;K`\gCufQgK1`	ffYfX_UAND^AhN s" ZЅ  QЅ `fn
@ zG봲i <7PhNV vy@AN"Q3ALYaE=5X_^Z0Q 0  t8Y=Qh8
Qf>!?f}?ffYq@~f
6ufWS[a^fWV߃3Y !P1폖h] fP.j "  ؎fVPf%!0 ԟ 2gVF
uNF3p	F8ȋ^Vuf
Fr;Vwr;FvN3Җ^i gҤ3E_ufA+FV
+FV؃ ⨂P"  m ' 8/y
5G
m> uA ౩*eF 81	j jFPFPN!' Gj F P 8V
ѷ iѷ iq~ ugzаm  òi{Jߘ	h0౉  WVߋF = %  k:؋.@0@Ftlf@P8FtF% { +t1Ht	HtHHt&-9Vu~r"Af~  r~r	F wsVFsF^_
  ĴNf*΀ǉVfF`л 
3Ft	p(pH _F@8ҫ!ҺP_؀tԢfҋ q< ~ut/tr!q~$wҋVjfF~ 7	V@V@^je(FFݘN*;~^ uݙ
)RPWVޮ@uFfHufFV;tL+=tݙFVF͐}!Vfn!J0W
q!a3;Vwr;Fw)FVFVFًFV
 eƁ	A>fG@G3VQF | j*΀#@p@f`N+TRP^$9Fs$#FVhDfפ*P^@RvЊY~ t	\Ë!ARnr:~t@#f+1f t_FPP` tc";vf9GrL+sGvfGf+@ fvv#?AΡ20;Gs@{~!F Q2Qf;OFv8Vҕ5
@f;Dv3יF͋VP2WV3vF k`sP֠FRPߤu@0j&PRꀼje uĴNF"FP2,ƉV=(ut'*$<u؋ƺ /RPeA,뼀~ [u0Rke+ұ8!a^*䊇	7> u ;7Cb5F96hew٨APSQ	u@A~+9D
r
w9|v&vvD ҋ^10v 
Ơ p)PH+;Wrw
3p) O;w`ەĴ a ~15NF Fa3ϥm`8$<uP3 FߋVP3SVbԑqCFv8Hw`t2Nf% 7F l~ t@f@f6V{;FVR5b&!(T
<!89Dv`P5A8RJA$3BS
wBEFsK5./0"a15 πtӊFtʐ$@M4B46HM3
6@/7U8Gr S9a9;0fq: I lgf;<!=>°3PhPZ3  j
RZ^  YPV+k:F%- ұwŐ0@]^_5``aFt߸!F 5?  %0`Њ%ypt
0 1gQТ1TATr`,Fkv1â	PbsF t'5  P^ȂtAP^%5~$sppr% afR		P^+F̸(3QoPPOWV*t 4
֡^$\;u;U)u A	e{+uV0Murs3 FP^(Ц=b ǃpBuNpPQÃTmF0(/k:@2fut@up$/;| V@3D D:B |/  :ꢢe	 <h^# FmFAw@1WVLؐĺ@F$<w"4k:@wG )p) uGW*@B= qяG!t
< \E	E	 1! E*= t0pjPEue$ + 2Epqy =A $R>WV}@ ~ D4W@
f+@@֐]@VPZBBɠDhN$fР#^``kN/:ىŉ!k밫f@ Q1_<u%F r2`Ǉ@PPBy9v^~wk:r.`Ǆ@$~@0 Ċ@2
8 $Vk:@/Ј ۋ
k:9@tC9;P^_áP3q~6@tu N>tFˁ@$!pt71uh_ϊeՄqpEp~XDK `}#@96'tbw@N';ta>'t>ԋdՒ$ S|~ofaЋ^0^9F!	FEz	Avv^f$4G2"M jC FLfq
P@g3W2
6
p
@9 ;WZw;Rp-Pf~ ]WЗ^	 *ph jqaS٬٪ VْpWu40^tp .3R>q%uk %u~W^KFO`[D]@`O@WOґ26B4-^:pu qu ?wF  
0KƉ~ :vgRd  vp`!{:P}ty1LhAQ0OS025mDQ9v7GOpfEwopO\PPHpVFf*cj@gv8hd2 txq!6
 t;5`OpvP2FP)a$ ^VOp c
t21gUU  UUv6[6 uWA hPԾA"OP+
*FN*+@tY>het-|	khe0!c"u鉅eeheVPSVu73>;Pr;7|  ^[XelYq%k_A`luN#p.fb߇@*&Ft>v9vv3Ѝ~@&`@ qCb`Ak^׀u 3҃ r} @3k!S*䊁ukuRv3;Ft7t- t#a++u
uGrvF߃r1B;yIk0SR0NN lFt׉vQФ蜖A{NPyyPy3ҋ{A!?3fe4̱yvhojP"px^` 87𓠢݈݀ W~_$}>'0a0ᒓ݋ǈ_@}B,.fIFު@B@Bs@B<@Bb" F,F҈FvFKaK KnAQu߄S3;V0 ϿvDLSPO*徠U ttR~yRv΀7Vx+;Viw;F`pDp8VF~U =BBACDVDVEPF?VBp+IDVJVFL8VF~;8Fnƺ  ۋ^p" 襜UpUܾp& ے[ߺ( 莕W, @BtfN F  f@BtFYJYAZZPYIs7F=v)]8j#Y]+8@fp 8\V_F +pnڠƺ ڿF֋Vpnþ5b dX0 @Bt,f% 0 F
 `e`'a,p `oھp> ڱiZ6Aڲ     U     U0H@  00IBM VGA Compatible BIOS. [ k y PCIR5   g u  d"	"	0"	dC	
	wP
@
P


p		qP
C		0$$C		 `"N @88  1X (V P 0X  d @A &06  A  0`u$ `A (000* Q *@0pu40@u= @uH?@0bo2@@uOYh[rߠ<P7tq##&'072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E` a.b .c d/e /f gp0h p0io j`1k `1l mP2n P2o p@3q @3|i}i
~ i   A	 5 5    6  j5B07   9For Evaluon Use Only.
 ( 	 c-'(+ P	    = <=>?P@@__OPUzA(_BCDEF?@@pAB  K	`7(_LMNOqH@ ITzkQ(PR V 7
QH v`7IM](
cJZ3[ C
 J	

? J89:;<=>?{] *  j**?`?? (-2 $8? *?`*p` ? *?* cb*``%( (,%*26', 49$,0	
!&.3+0$8=abah $(-2a/?'/7?-16:?  
 ]'mnq@ 	TQR Jz]sTpUqAVr L_xyz{}/~O*qXtU@Z'cv@A7]bX5_^](X@AYbZ? ߊGXH]Y_ ߒ?Z@gAO
A4[BHXgIIJ+f(bJZ[P tU>(  `x]oTptUAU@iJ\A?@Gx$VBT MONTARA-GM ѱd O0 
(_ _DATA_BLOCK r  V
 	`63104Intel(r)852GM/E5¶E  Accelerated S
Build Number: ѵ  Devѱ10/06/20037:07:36
DECOMPILATION OR DISASSEMBLY PROHIBITED@< Copyright o(C) 0-0rp. All Rs Re?served0<w9 `]  `6$	

 ! "LFPIO ϲȿ? W 02468:<@BDFHJLPRTVXZ\? D_ж  ! %  8 I 0  @@QeX<KU $8  ?W%X$3o@$q1__W/@'&M `      ߋD HLπ AA! A	    2   2  2΂ؠP:|큲 UT0@	 "? _ 5`= @	W 2	$ $$ ($
  ?_  !  	 CH-7009-!b  B#Ƴ%SIpj4p`FO-;45l
 <X x 
	P S( |  foŃF|X 9 [ ?! 9FÃyW1  
4O&  A(_()/,+,-/ (@73 ) ~(
(\	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*X@ X<}<' 0<h 		 `"76W  </=C>  1X_ (V?@AC>d @A &06γ6XD AE<EF0* Q 0@0pqV?I2xIJLx Q@
MR$?N_O=/xQ&@XQ"	@S?T4>H?@0b_2@@'M DX?GWH?"?\_]^_	[ab@cS_efgdi jkmnonopq ps?t_u^_I@/y%>@pQX 8'Mw}zd
 +1  /,%" UfPfVfWfVtSRu.VtfFkF	F]a ь }`젻
 `@wЌF`FF=@B\~@fI w'  NnVQRffZYf;F 0rufVWR᠖fFffffFffff^܀Zff_f^f 1;F}Nn߈^f~f~.sf~ t/:V^:nQ:ND~t0 (NfFtF-f~ v2À 
2:~s vv^*ߊffV2fX]  p 
Ь
 ` ,t/؃..	 
 
f.aP߰1VWQ t6 t a3_^@v t&]etemU tPSRV<v
W8_2q!fWb  <<t<t<u&Dufn  
<uC^Z[Xf.9uf.\f.|.\PL	;ufVPf(.% `= `Xf^PfSfQtfY@ fYf.; ro![X1	u cqq t Rf-襦ot+t{f.5+rf3fL0pufߋf%)0fո0ѐ2ʐr00ZfXfq+t/Rǁ̀3"t
 @#Rw8ZsӋttu
 `fw@f@CBpufx/f a/ w{ ЛYf[`  ,<tt uu1upuuPz||($ŀi&{_կ 'ۖm+?4^M&U^(6)-6U a'd eqfg!hy PS蟜.[XDՀfWU.64jހs u.w.0p=Ou
 ŋMa=_ | W(6I=OuFt=Ot=_t
=OtPIXOuAM
0 tV( F+P -X-]«ZϾ.<t.:u.T1_F`4013 W&;&F^@^
' Ëf -nf +u
+FЦt f# ߲w-}0*ftBWM-0HU0 !DuӀ-2rf ,++m#=*ti܏,R  nt)d*,R8 Sf[ u	uN}ý!Vp    #!W!!! Ǿ #&u$* x+Arˠt.9u,?
^1	|2ۄt_@ ^2=f{fr@w(
3)`P;+
lsrrwKst&
[t t f!)+ rf"!e(tZ(P$8X$@
؉PSQQq0o2;YtoQ
p srYWZpQDtM0t
@t@uY-Y0"u"t1r.D$tt	Æf^ZYS3pw1u0
+@r u%??>.s
@ {,f$ ??)(f`4% uW	a!рtASRk4Z[6p7t$]&4ʑ G?&u [&B$@ρwZ)чfa0 1/_`^z!&k:z&9$tb:0Wο.@S.Lw2.@
QP=fY
8Xt+fYI +.7A tB#t
2tPS#[;Xu$u9uѶ,
uPSߋEt"tSQOY[r[_/T9(=QRvu6ك`.tSD[r&  ~15a((f`P t	; PI > P1%BfS :'%PQS%<vYX%"t2%P `h%
 #AvXK%	d#X6#G.&U
b(a`MQNQO 5"4Y 9Ǌò
&(" ߀t#t^]![t
/81g!86&Y!1#!t4oVо ppi`DΑQXw

SX$w
؊ˣw#3Ҩt \W
( '''o((((()
&4!uQ |,Yrs u?= tio# uRu"au@%#Pב#Vt~VtXp#xk"$u Q.O2 ;Y   Pz"fP%< t! f ff3g&fG!P0!Pf.xf-  Ё K$k$ X5o$X1 -$C|͒$f^ f!7w$QB tm$Ye$pZ"8P$2 Eja:0P# r	 PPw@u 0 RS[Ȋ耻S=á$*Àu
SD$[fPhh Xfj s:`!P\0  u
ttP!D[
g#XA 7fW#87ep= )rfV.4.tf^@
f^&?E$JSQlX
s_u0TkI $ 4Y[Sp@f+Qff[k t2vfPWݐa&D˖"fPYՠ΂v"D u'~ df%2e8ubu@ՁRt*r_*srWosR2Cd
"Z(fXwѻf^a(x)k$$PDu@u7t3av+wt5*r!2pI( ;fYv]tZ@n++
{+f$ r
0Q2Srs[Y`turL rQYRPPa<v'/rs	 (a(W_rZ.\㿏 ..M m`}"SQ@"2NY8[r2QA÷sYf_XSWg__[`tFs{r?qPt+8t$PՊ+ Xw8uDA1h(Ѐ`ʰ8 \R
a< P-
ͺ po#T{PUuA2
2i*u".04f~dA[~tu$
Ѡe-PW`UYXAE[{ذ3 \P
>J_1U^ FVv
nB]PW s5&!G18uBJ0<ft~wZ @08j t0:jG{tav06j32۰>tt@P
<X,ˀ{UXM&2VS2.6j3_8r *[Y220F]WP>j1 >Àt&}&tBJ,(-)*.)`04jÿ1<v<t
1<v1ÜȫP@"3bN<w<?t0f>'/eu%
2&J&&L&ģ` 9	K LaÀ0 0000z0
00z00001uxf@Ou Zad b  @B? <w
2tн6
tH/8
 p3۱ u tF@rpt#u3WV ^_ 	6
? HS
7@"W _uGG
zs
d a 	 QI hGڃ. >(.[jRxXuπ0؁ uYz% @@%t	Ð5FFGuـ	Y÷XrÃQS&G&w&ߋ_OB JKu[ B&OP&
tuȋcPQV2 $̊FY^Y(&tJA# &&+	
$q`ug$Q$Qc$<0t&`'t2-2*u*"(~A' `AJX2; u= 3&w &߀?2SMw[

V A1Ѿ93O.8u3`uDt3b­}zyh`!  &$@F `D|M[9d``8JI~   1f   > L$ Xp>1yF@p6S4SK7
S`c@q@U? 9O {09F@0н u Ǻp] ! 9t<v<tP&Xp925s 09}p9CVWS ct#
F[_^÷sG(s軟-G
P/&W.  /PtXtgHH@-AGG/_/.> ` ߋëA#fP#IiZhu(R1*u
LlG!a:=!-  0SSv rffVГ2~Ê߹0=r8<w4t*uf2Q`+Sf[fSQWj~fP ؈X2A_YARVͥs.
Q=s0c.#*QE.LYt0
R"8}u^Z`lr1S[uQ Yrߊ̀wv}R Sf03MrcQpsO<tCQYr?I r:Pf;Xr-uYf.;v{uс	 0c rn_7fYf0!RVSӆIat|.<t.9uk.|t.9\u^.|a}8LuQ}a}ttD.DPjQ
.lYt(t/.>`gr' tPQr.DYXuP
~[0.t֧"`і
 
ifp|  0
 .0DP[S+C.].E
.eqÈ+à	/Z+`BUqʈ艵q $
a
@eV
.D^$0Pf
@f&ffȞ &e &}ﰕ]r` <tfur`+t' w7RZt	 $</t uHKdQPr 3pff+V@^3Pȃ 	b+^[P_^JmGâ
s34G7^HaK&C
tHKdf	f^ޓz R  IZvG婢0vPVPV1н	Z rL^1s<w >PkX?ffsfBѳf
4
f3f;w2뎰azhq .8P.<u- pQ2<v#<t<vнRt CtOqph:lpyٸfw
Q!X.`<
.&NȱzPQgPX`<f|0  wP7Y2Vr:
 xfXuwfa;t9a;
I$f^ VWuB 9d4@|&\Cr`wPO
Xu0	 Zro
 u^rc
f td  	


Jr;.t3׾=u
==2.@S6&[<|rw<~w<`qRZPư M r<#w3n
uFS[2ۀwvEShRffZnfU
@?[ܑD 
s@f^|qŲ1Vf$f6	ňqf0087HsSuNUX^z5p 2ɸ,"ypg!F&Asau\Ue÷ zMي3
x@!2 o@ڮXtr=jrpY=>uUӊetǋz% 2?VP3L^>:
wN  {WPPSȿ ^Z@[JHF Y.r6~VWR
PHԊr;~s8 p~JuZ_^N tpS0 [{_P
p8e>':!:e@Vzz  :2RQ;USz & X6 "2&J tuTA2RZΰa2拄PGð` 
؆pJa 1Pcr͢?	5
`KaPfQuBr
~ rf # P@芀D?66yD3VA 4ff.Vff~u
$'tGf%b14?`55E%Z	Et
^]#C	ѭrfwrif
U@'u]1 TÒ@s
ic&
 `7u,.>X t!fa;03 B 
$GtfXf^0nWUPiRN?W%M/6?%52u0q5yB΀@  Bf>?	ʩP	3PQ3&߉LL uGG  @ tO3YX.	XfŲr,,<#:5	ZXf]f^`h`d ^؁8tJu2À_uPN<XQVW_^YS. 	sK;[VS3
t
<a|<zw$Co^ᓑ   Bq&b~0 pґ@4@Zz.9Vs3aڴP2ݳn!t.:u.T1GV .qA=^f.<Inteu   	  
 	 nRaPa CPOPBPOBO PB;rXaSRtp8Z[ÿP.}.8tS|Tuf v .E3u .Ert+  R ZP40A3 f;q1z	P ܰr3?O .x
s+o؀þ."PXfu	fSffh00#3pbf? 1 ssFpsFV @8`gsF0csRf6 0.dfi
00.D`zhPR.ff@QFC'VQbr[apZ 0` G .FFMȋF 
tJHa  Dp rFpqFq R ݰ= #.$<,ڹ<eX}(GtBy ^.ϥG<vV)f.xww1yGu
PD$.GX"}	BLQv=.+w vBRۀt
u
r=
A|f`.ȃ v(.жuc.<s.tF_Pf u.t-.3uat. P
q@f̀  򢍢 Ŀ2P v00df'eP(&0_
fpn$F&Rm!telbUr hBڼC@q !VBRR
RZR @ $ bPBBCZ°Q
Q QQ0iPl|fƊȯ$fl~PlfffXt{
tfZYQ Q 	Qg@耥S&
Ӧ t P?첺`ơ.w᱀ e'$ `` 迱 S 0S2_ eqNQ$q$u@   `tf   gft
ѲQRR3AStgZYpNշ3ɒ|yvspӹfQR3og?Z 𸟿E؁PaPS@""
o[XȺBCfQ"fQ́]͂ `!fSf9Pŀn&Ptu bۑ25ffĥf#ff#OfѠkf1M `RpPu fPÇfXӋ#ك#[uX  g-/Oo /Oo.д 1-l	 -`  1X (d @A _&064QC)t|XwrwKQdHYm %\ DV ;v7v蔿Z+a"+RfZf+m@΃AfRqQRVP|t
@ylt|<uT@LP Use the force lukeS@?D
D
  p |D
u:RЋU"} 3t
Q, Y+" O   Z;t?[ì؀  U`FFF.8\uE.T;u2	u	Ff$f"uPqfV.  ^0j!)
uCa
<uD` fV.4.9y^IFa]~>-Qu(q`
0 ƒ:f^@=wQ@_$WV@{WtfCr_.|tW&
uMu@.Et0.@yu .\*r.M
 @%a^_kY%RWUЎ s" D&;uEu&]1_Z-Pf lZ <5.u^ $< ˎÀvt Nt.b'N#@Ҝp$$Cȋ;u/ b t"~$ (tN uĿtO"FYb]`Q tGZrw?&R2'u;Zr+;r'&
  [p
uBaq,. rB.E#U~QSR />sGBZ[Y.6пM.8t
 .;6Mrs>SRVWr;u+6f
f^&M;<0_^Z|qN 9r;ef<T==3c7| t;E8u2
4@&rD019(u#0WPݠ 
XY[sCP@@ `I!JI IQT .8uftހ$ADDfdIN30`M  
! "  O	C 
C pN pO 
	Q 
Q 	R  RPV3!.d.D T.;tpL.LP@fQ0f0*<t<0u"9r>&E  `a=0VMr`|6ZUor0*v 6Vv3@If`Ȏ؎F@3@ t .v+urg\ uZ`p   W GGd E
VcEe\E@f[E	^_.f^Pg tc2)
s7V! ۤ^ t@<M _^^Ps
L+ "-K.Mq
M)
bfaK`a
BAgf^$rܰ00}-SQWDfAIM3PMS߿0WwGwPu-owGPu[t+΋L(*nt!gw	@t.u_?p;_ uXPt	r}xR&P&X ZuAp
tPtKLums?@@$

^u߃t${2_#,  ~Z\QSWV6 W&=	r!s_߃~rS_[/PQq^7_mYX]f``F(8^M2Ƀta]FoF.
.D?;t|;F$Ft.
~9r.|^TN%<ʁ _0fPWo@9Q1AB_ t{P/f^X ;FCC=R@;˗u뙴CP@VVr3!u
xu
< u	of3ඛ[0t#M@f|@pXQWRYZS"[Z rQaYs
t sRfPYR.DZtr$uæ t@@u
 @swr2`uP"X@ 쀞/X0ħf`s%*uHfP `3ٜ1$0پ0yquuK= w4 w.HKPO󲵅Z;vdSp]f3ۃ~ u%P6.&Y
Xsۀ   3 Pu]QYrPSQ0n t	"@[
0sY[XfRVVf.Tf{fPC b35 u3oRfQqŚҽ ;fpVL  ;ް^fYZC2`I]NUK33`IqQf 9fFDFɀtfVrAϰ*ῐUA A aV`6fZ {_t+}Q,YrqSa.|PXt	Ztπto fТ% v¦ %Z|`
%u"ufZ[Cf^ΐQTY #[2   QtN Y n^^t^^twǾH^8 r÷ @  wf~ nPJupS`v[QR s9a0U.:u Q uA>85QYpP^kt tQR3ɀ sMZYw t1$P NêNuu<
uf_@t ZYsK`1QwCa#gvPQ@P+(  APfW`0t%,tfR tpfZQSNu&BtGNumYf_b P^A>5M[lyJ	W.>M!.:]u0 SF[y  	
PSfVˀrf@uJa .sf^=PPPPPPPP P!P$P%PSwf3ara0Y1Q2੷Y͠  PQRR/ t&P% ֊u2ZpS![ZYొtB @2'2ۨA2/ಱ ϊb0N5p 같~09
퀮{$v  ߐDS2 ' =S 2q't >S'i =`,utta`SR b'7 t#JunkPt
PӰ1fS`i% =]UfWF  5u
 50F 5
  5fX- S4^4865b7^
f[fX]fWf`s~ u^	ߊv9qŦpG.t< tPS\@=pk<@/P<<UGfWS[ FԀU$<u'f~tfA?@tB5rRW<uHt%Q3ɁB
AQCA~
R1B5Asf6<<_@Xf[
ffZ2rd
e*eAeJe^edeuSþdNðFo53p7۴ @.?B:|aO"##QR[ ZO0#Q  O2^pO  ee@f^fdfffMe2<v!S	[t{!f@!0:À{t,ҽ
 ?豽PA\,2sp2Pu xТs  þo. c ȉNaSOX/fSf  cXf ހOf  f t7fU<Ahh)`Ahff f4Ahof%k; 	F  dːQ-00
@  g:gggqX g`@ Wf_fVBE/fFP gPppWr0f« f ff+ uf
fpu\	l \f#$5l8u2uA]tb Nhoh rpMcSES
܃_Zu?
 uV\cgNpX!t u3ۊP uua r1Q$gYczS HNu}1OF b1R )` ZRVuO	r?^Z`V!3S[ t-R!o 0JuZvZoR`Xa``}tpa YLiTiiFT
s<_}s\ w S.i[`y{O.Ptr5P r.f0[؄HV
lrS
.\
XfuQdv ǈ^O_$ؑ$`08t\ t\t	twAf "`m㡯< #tas @CaaKPMID;t     9Intel(r)852WGM/bE5PE Graphics Chip Accelerated VGA BIOS  Corpo@ion#?_pontrol  Hardware Vers 0.0 `abcdefghijklmnopq|}~<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq|||}}}~~~  5  0  2   
llannnnnnosp	p i
gegk.<t.:u tOFûE2&+]=ppu`rWpESAPq H@jfj 
kfPfXfQv4kt/3s@wktk st$k*kfYf t_uVH f&E- ߃qÐEt6t@Ύ޾jP  @jP\uRSK$Hp  uڵ%wt@ @tv ts߫#a1˫Puտ͊@wfƫՁ`rf߸
`rt  uf
  f2GtkQRfpua3ZY%͊"uq<?]ܿf
Gvγr;蕯$:Iu.{` @%%Zab]^zd>\uQSr[Y \ͰLr`tVÀ>IvmwdtYw@t$`;wR$;v f$1#~ֺ p7`t@pwoooop&pHpr @0` `o.$fPt*RaZPXfv pߓ ~25F wf f t21¿fI@ yBPgtPg1!" D6*_tEs>e^Ptw1w@QQaِfQtrwta)vGwAºBff 
C
0BBhRVIfˋW uo"@lv`8 t3
 AUP@<ʀs Z e2,uPsX2As00fQfr\Pf1ċsfYRIR/:TtPuZP؊̃XVD u.fD
f=!w"f3f0# fqR fZcv^￨k`.E.eA##A#*$##	^ $Ȱ#
C&+$`&Ek .4j(Ϳ"(Ȋ	:׀8uf$?
g32IRרu	Ht
.
  \@$
CB.!רQV.|^arԥf^÷P@5 2Ot"ѽ+".DQCp6`YV^{r
+
2^û< <#t2 <"t
+ <!t  `u7
ۀȊȀpfPJ};@s @ՋиO O OY}pu3fB * u pdvˉ`uu t kBudu^<uY8s
tQG8s8s8t3ސFt-v&8swˊ
r*ˋc
ߊA㉗P8bu J NذJPKÆ2ۅ@LBP~1BtB0O0~P2$b&LN<v`Y	xorJUN狕PqPF ^at{rtw%qvk&JpR֋&ȋsBuՃUt'W WwPYPZuZ$0<0 t**F Ɗ
t*H2Po ؊šXAM>M0ULP~tSr<wBtte$XZ;Ju؊˰ f'
tQVǐh^YuhQW_Y`ju(pSeef+fZbdb2?@b1c2@oPP *ڀ n`d  toʋXZQ2Qg`i/V++s+Dj؋Xst+tvrkmd݁ǽr\tG?r:ssNOFGt|xu;vsOGGwTxڲmw X2cR@FKX@!+0``ȋPcXd"qqudQr e"g4h0Ԏ`g`ͽP h2{PK31mLR=ЍػP
`ȮAjJuk^}A3JuQŏOXi@Y_wPGAd eSrg&	ōhFm(OaZkӓ䢞Pm KY?tv
t-r ^q]sw r
&"PtЭàQX0YP20ct{yQg tO FƮS ƯPЎ،Ȏ1 0u.r&>| t
~]`OZȡXQEcC&0PD+{2tpY!6t
@F?uXCP_X!2&<uN뿷߸Ъ12ۭykËUƋt
 Ju]+
]Q +NL㋟;PL OߋYC]tЧv1u　?600Q_KHsfuzηCȤBPq&,G$CËA(r
y$6| 62䠼@u>
xĪk?í&0  &0%UÊPY)"wj>ٯMuX#`OLXu%K02Āu9VWѤ ts
ʃ_^GMu۸ Q3@ø&Dҋ餍n@YWR $FԊrǪ8JuZ_+PMu3s
{Ë &1  >ctG3PBÀ9[t3>f߷10 2
T Gf@@
pF$
 tu 0@ PW.>ju>&}.ҪǪ_Xwptp㾀r#ts-" &"%
Ī 
r0sي
u7豄P0
x !NLuP w(VwKؽAФsX ` f3aڱ <,P2ɸ,"y_N6@πʸ _(ݨ nr$$}İ<
tG<pP<u(  2 y yb2QU<
vR vZ: uP2:6vFR
tX8rSbƇP [Պ?׻t- ʊP3ɸ1PЃ
OuMMtNPSQRaPaDXaZY[X@Sv
LFЃF0݂ۂ	!Q^qx<s<txrttJ
A 2ۋ&<FA)w t3&ee<
E1(.~=( )@-Ê;&߭శ Ou'ËÐ 0
01ǀ  fnNËƊĊNuú52Fó π} 2  Q4 KNuf&Kl0nDSRP$?.&_RPŒ;;;[[Ӄ=  XʊZ[#PƊXPpX0]A~~~~l|8 8|C<<<C8PApD  0C <fBBf< Ù}x<fff<~

x rT88T  >>EZZE Hff f { "8DD8-p2B~~J~J N !N1K ~E 0``0QAPA$BB$PADAPCVAEPN l$P  llSl ||Qf6j 8L8xοz 0 #R0```0 0VU`T<<fQO00OQOUWA0 U || 8x N~ |pZ<| <l [|o[ƐY"W|0]1]]~[@Yv^ Y0ABr`!`Vx̐Y@Y|߂R^ ff|ff\[b H bhxhbcd`]~ bbR N< G flxlf Vbf }bb]bc|`CeW|b\|[~ZN<eiil|CjƂ  mO88laKR<`]׌2@hxV``wx !` ZxC@nWA0 Qx|v `` c^\[ؠrrqs[60x00xPAv|x`lv1k 8f sugvv PA܂Kqs1]x|@e  t|@\ v1jpsk| W4AOGBtm|֗l|lqG|X0d VaN{00] vTApB[cp̄|]t|8r̅rr0urq{@|QtQitfvpfvrb88`x`AP|~~ ~?ayhSiӆ2^||r~^i||pvl``V@H~ Rph1]fyfi 8<4`8ll8 ^0`y RAP`F=a\Rf>E6ll6PA l  "U=swfRt162QAB1Ş`QAPAPrTA3 uqš1NqEd770?RA?%0"ĥ񦱧66 51qĞ1RARĞ155(tqpt  tv`a@bo`z~llHp`ddPBL|PB 8||DbR^l( <s" tQufAW|||Atdi`Q`N~@N~ a`wpRPMau8RaEPA gl<pSPA'0Q{PA<_AAB#B C"ClC4 QQEZZBxPTBE&RqqFįFG¯2xGH⣾qH
xLIbQ`|ll|-QJ`J@pd֐QrKKAW K!L|`l8 CrCQ3 Q&0OQOQ0PP48|#QcՇ||8QQRff""qSSp!Q`llҒQ`Sv3t`Nݒ]0` aWE̸XuU`ݵWtY|Z 4dZZ#ԂY@[[ ^[zQQ\qc ]]#^ ^CYpBr`p"a6B@ CqX H c@c0cc5fd@h 73{0isÁi7sf 3xpggg2 o1hthdh#q@si jjl1k2`~~NƀDsl3} m l|8P#qqKqfCƆYbD<200Co0Qxp9qѠr r3ssUdt %u3uuu·r v$@NwC0s@rgw
x &qy6焎""j~{$qsp W3||
c}}0  nqi~~r$ ap N TDN--kLs0xd2'`0HH020WBi a6K'9'a6&A!D!n>3fpxxc>jE<h#Eix:4(a6(h3,xCyG ᠏`1s0!#qp 3'3'33 ("QP#<0<0%ÖSհdx0`ܶ=>uWlܬ>1瘳D[usw]y ՛Ğ5ոa` VDD [סhۢW. jZlmĞ$p$ ÞuppE fBuu4 ŢzddqŤoqzd 4tn+lhmu`WGs
̃@r7&trP0`´W(Ђ4 11 n ||@<` `D5V# deM d 脽Jq[#/0`h|rd EĭČ]?9Ԃ Fcxʈ%U42, GؤӇ _LW8 ٬|M/ޣ.dߍt8b0B0u W	J 9d1V "VF#0Y 4E {=
W (r $D  d!%f5
 bvR5W %U	w
# !u#D)	0W!`1 $}f/ GR8
 FR! = !!!t" CU"$N%G& ''sJ4** a1M,-$.. 7mu//N04112 2$5Ov475$5f6$50U7b2B wCvdDw;< f=8>" ?" ?hh@rUAA BB*CfD$I&F HG۷HII JJKFLL'MM #IOۦPQ XR# <STUwhVWޠWlWLXcY Y]Z9[[\]^_ y`aabcdef =ghijjkl]m ?n;oopqrst =uvvwxyz_{ [|}~~ـ}]= t UƇӈ$4֋S fݍƎD&|| zX씽 |NF ȯ ФEBP<ð؜a p@k`|3OtǪ ֪!"%#4$C0^v?12Ë5þ1&)ð{	{  æ{ @   .rÜ&6| &>~ 
*K@r
t	2. Ϲ 4 4 1111a߀w<
u&| ς2.R^FFF3ҹ `Pܠʠ Ġ X  * : aQYS s2t  [øqk _Y
>ctIc  ^^4Ĉ>I`@"uu
^ƀt 36ȢJ2 Lc&P̀>Iu	B$P
	JX̀v`
p0ʁ uHÍ8LaztA@@rw
2F.Ê.̀N$FP$FF. 4 ÿϭ(#<w$u$
u Àpǀ&&߀ڈ+	*<w9ΰ`Q% tS[QR2`& 쮞1<w`٧{@tbu5BcȫFtW!yC`
 艝#`pð8 u{ 3Ҵugtb(u]̊.ŴQYR  
 8 t$8u
(
28u2Zb aR23Z%t<vÊ>bSu
㋗PRФNVQ~ċюF&<
vu^Ft&FVRU t]Z:Jr92:6v/RSbƇP [
mZVm^ރ^Yu{ZQ[<t<t<
t<
tx (` t
t$0<0tu	߆͉NPu6,~s%&2FtBu*ш
Q}s&:s2& `hk  qp? ty2P] IͪgīI<vN.!.ItI<tE2<t?<r<v7<	r
<v/<v) @Ǉu0ۀt	t2ۊêSP@X[$Ŀt0! !ъ$ڠ
4
?Ī3P@$2.>juZ&G&Gt& '
A'& 'A'&_t%&
 'A'&;GA' & 'A'
 2à   _ 0-0-0-0-fPQVಹ fVf.D!/4f^^YfX< !!b. /4f3/FFr0fPfSL1f#fff f 0f%5;u2p0[0PSQRQଊ+YZY[ 8Q8_@Y"3 /j0/f`3~:f. ;.7/CCRRt:Q<̀YA=Z t
3ݔ	t&<t&wG Bx  ABC BCB
f ,ؕq轖Q3&&Ϭ&If It!J|!JfY08rVFF3 ^tJUP9QF	 DY`3RfW.PNP3f   VW _^qLP  qL~Q,NrQP@R fX f3Q  NQP1U BQCU6UV0V*p VUOv'RX @qS Y qS#Zf$ Z0Vĸ ̸>T:TQ!Sy2A\TeT^f{[XPNf_Z7 p}QVV-^⽿BQ\*&5"&&&^G&T@RVP\&$F@&F|A  P`iX@F2emN h0k^ZRD  ZPN$uY8VĊNu^>T9ڒ!C:R"f16Z=QfV<f^Yb>>@@A ԏA?dB7$C\ 脏CcD0E
åQ	 HSIIJaJJKPKRVKB3۾L^Z#N쪓NYØ    8 4 0 < !! !!!!0!!!!  !!!# $($0$8$@$$$$ $ ```@`D``H`L``a bb @``            !!!!!!!!     #qrOV5PP<tQ4Ip4R(R:S6T4U/fU쀒VtWX#XYĀZIZ[\q]诊f]k^mF_aA`Vc`paSQ  2Št$珀Ȑ$}  P\$  pj Ǐ?ĪAdSc?褏P cBd萏P@苰 @胰P\d"iXN 
1Cy +E	P=X^ödr.亽@2  SPsuf(Zڑr1ߏ t[f`Ȏ؎U
 T.>vpp f; lf3ArO|$t(uVtD rnF! ȋD4Vw rlr&u .S6vѷu?fR&VwQ rLTf .v+u/QW&D
&M"&}  rD(;v_Yfa  
 ftVp^tu_YQVWLDFot!gw
= uRtrfa_^@ /Qf&EA@MAy A̒$fPf@u(f40 r} t tA˸l A܆w<Wf;EEϖl r&kf&HIBuMAfHAyC4fӽC ru&} sPQS蘏[ Ōp%<`Mp:,_?`VB ^ ƣ&Eǣ\@¿E;P++\og;6s;>rڿta ʾ
Ǿօñu66xPt'`Fak t	@2_Px N ð  t%u7zҾYf܍YӍ S>[6[ $ADDIN30̿!BY%Jx}AIM34bSA  @ X@@ U  Intel Corp. LVDS 04Tp`QfЌfPZ...WS..ff[fX 2`;ZY߀2 /p-4uP.;w.;v
 ЌWvTtOYf.G u"02`>ufE!R00poZ)R0qZr
ᙻv_ b< PovEsfr#*0@3 AKf=QufXU
"SQW !U0<t_NӑwfV<{1@2S &@t 3 WR &tU
Z_WP+蝃.$.%GX..]_PW*~Jo_!3SRP$<u8."  P0}XfTA߽
f`A Z7`.5@ typ MO Q@[Ou_.3.cW6v..\= vf.L<&]fff.	\w.3"@ %@.&[
U/
u.3.3. .G$0<0u. a}fVf.t25.:f@uP02d H`Zf^Ɛ~:lЌ
	d2ͫ11fZܰ!2;Total time for VGA POST:   Seconds 0.000 
7 initializationЀ10 Milli~9 
 !豆.|Ã.~ø@>.ÿ诂.p!Nw o4B 6Btx%pr 1P*O
~X X$-P_% t\k
.8tFF+L^X	
>
a`fQ}ԓ5P*Q
_u2 t
^2"ot2`rp	r>Ău
 u4P*Z
~u N+UfV$m#a YaUtNsLF.>lu82 6Tpt$.Up0V[ha##Tp~f.f.+f%b t̀~~~!.M&@I FQWf] `	fb._Y!f`
NX}Nt
"d af  zcuf[!bfg]eaN=TaRpۋpXtT`!  f.xf[QfX~`
f+ffYf
Xo3@څfX% foIQёdf轅ffǠl YQ~01+fӁs1rrwrP.MvXú#c&π ǿ`	P^ 2@BtĊRvZ$`
s$.P
tA	tA.P
t*. 	23@$  . úU:UuP&w^#Uw.r e* ˿@   `Y 1 | 1P߫X@v<t<3@$ t u# af^.&$_<u!QWt	
 uuE_Ys	6?2` ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  0  3!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du 7fs30f\0fyffÀ32 ;Tuff_f^fYf[  (   / b AO
 IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,EVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<2+vAt|3o;n6}70+=iG,N@g!CVO(:5o ]]`c:=cވ{>Oyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :D/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH])X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=BMﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~de&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEP  "=Ptm4gf~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTD7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo菈͊	ҋ	ўP!}όg
eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏ /Ooя /Ooڏ /Oo /Oo /Oo /Oo  /Oot	
PGg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwykK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]h9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=?;kIJ KLN/OOPoQRS TUW/XOYoZ[\ ]^`/aObocde fgi/jOkolmn opr/sOtouvw xy{/|O}o~ ρ/Oo͊Eҋ	PBo">ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[M^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*G3
U^`juB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg.&Eۆys/Gȵ}C 7n5?:XR
	=Mg+Eح@̱C`sJjUɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
}@ P/&l o
2e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnC3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo Ɋc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &,&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhkÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzok  2ij  A ~$@b@@"Ԅ&Ԅ* @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7h9v t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	  ` hN.v ῟ hģȆg
Ȏ؎`ЍRߋh i
  W R00 o  Pf  K8     DSDT:b  HP nx5000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12A

 A y 

  	

A1	2
i
\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 714ph`p
 gpid#d
 {`
ap2a bsbgcpcgz`
`vdgD15phg	gi
 A6gA7phpi1p
 fp
`'fg`f bc7f cufbc```~A8A9E
Microsoft Windows ME: Millennium Edition s NT C~@AF
p\_OS_`p1g`a.ag%q`r9 
bra
~ua%
 6%
} +%[1&I`,
%$2^ p
pA8_INI 1AH@B
fpig
f
 SpiP02gp2hPrgfata
apa`'ahha ߈`a u3
 bbiibd5ub`z\[K
@C_HIDAJ	_CRSD)
&	p 
 :@ @ 1;:A:
 C0k10<P=1tS12>W=P=3<P=4pyV>5
]+14t>4?D> .16P"C7C8CP=9 r1DiAEAdE  E[P=B   
,[GP=C 0P=D[ A=8 GEAA [
5JoFG20A9@[J8"L21@=22.23)AM4 L5֠)26!O7H00!O8!O9!OA$2BA=5@2CQDQEQF@30 C@=31@3V133S4S5S_6 @"R7S8S9SA  @n83B E3CbEC GEG3D+3C
[$XESF@40ZS4143M.44
0!`
p2Ba}aoiapa] 	]ib{ab][Z58
_ADR
 [Z6bGG47
ZqY$4]7+480P14/48E8Z9?& @fhAK4A [#~ZBK%4C*`p`qjp`b.48ee` ap G dpyTAcCߒdcqj
{a
;bp2d4DqjP.bbtd
oEpubk062dcrdq49` dza
a0Qp *rfuf1lf a)dou`['i
0aiZFL
_
 
B GwA  G&y
Axlry;9 ){ x({ Bx?y '&fDKZE䀣j[)4B B@51pibpkdrd
ed!lwd hb ub rb

bWhbЂ2`3`4#DjV+52#E3 B53crc)5}4"bNЂu5iwBnar&/4Fab 4bb4"64w$Q5Єbu~6atb
bc`6abkт`bac`х6p
 m56uCAܢ9<4F
052C54CPk53]12]Baas)_S3D
4D
[Ђ7b pW

[HNЂ8brc59
`?
[I	ћ!jv5CDI5AZ5Z6Z61U2 @} 63 H$64    .65AS66@a7 68 )69A H6Bk E6Q6D!E!F)70K71

L$71+723 
<[=ޱ  @4>75 aO77R8 } N79 A@7BC`
[+tbD@7E;a7FG)80o  $81K8282V3ү411P185V0C86V.87288qY!b9U8v888DGqE[#\_GL_*bp
`{s`Pb!
dv`J`8B8C{hsp2jp
p
H񵂸;w|62a|Q.8Db!t[0Bya
c}cbaa6F
/@ hdvdwd
`y
`ayik62c{ca A`@90 (8P 
!1}x 92"hi;0`y`jB.936``wh
+c94Pk66PayjabyPc67c d{}dЅ67M$95Eik3r5
bMbC{bswc
eufey res 
 dd)idnh
 y
ceрe+65cAaϠh\`z> buc/@࿘02u`ij}q`=Jq6
*705*6F&3Dԑ!
 i
 A97\2ip2k6BrGQ1ߡBGE08CD'%[pj
[IF09 @
9Zќ9ѫ9BC2S9!E qF CKA0
܁`AB`Cߠ
z0	;z{`J a0 
bw
t
	ra0/ Cz`U1@C2(P{@
!ry"@A1
pI6'wBP1A2
յrRipH9D`Fa{`s ` 
p{z wiA ;!){a` `bqA1ob AC3	_B`p!Dw
h РNn }QQ`c Q1
ccF~EA4
l
H3A5.A6Pe _{ky
P}A5  }`4emj
Q6{`Q
xQ7pp #6b}e
e/D t !6	^e@6e}`P4@dAy4{k
h`}aC
 Ѕ9C; y0̿Cp?d`0*Ad Pk9ABSBe@?A8 pfbcdyce@
!t.AAhif"f
j
rQ9p
EbRdB	! J '3!P.
D έp"M" 6*3!!C$H  I3!$Bb+(d' p3! !Ab	C@bDP}yacZD@cE ,Ub,`,EF dbrbAB*bAZA8crcAD

W[@AYAQAF-_PSWq\\AE4F Q1513F[?(C0B0bB1:72b0B313?4_567
84bZ:L_;<P=>?@CBPacQ:A eGIP9qLb
SL#qL;bL9bH\BA	9B	
#  y !RB lh``ـ `BDu!R@BE	Sp	aא`	`lBFV`yX vC0	PY1AZ	|AZ٤`[OC8a_UID
`_STA UE^^.њ!_DISQBFh^i^_SRS1C0hi^@Uy`\9\a]^B_fyfOafbA\@B\be^C /gnn_inj\$J\cm^D?ov voqvr\pN\	hu^EOw~y@zQ\ \i}^F_\\j^60o"Ɏ#H\Q\k!1@2ٖ3/B7YoAu^79 &22
[1ZBCC
rDz<YE [#1"Z0&67u[YBJbFơvX	6ӤB,C046D0MPD1
,;pD1PD2 3
Lu34 __S3D
4 mD52+(0!_D6
 h!!!33`02*X7#B4pYK8
`35 {i1`=h {`h`+`35i12$S q\._SB_9t
A._DOS1
 ao[^Ab/ha[DC0P
_DCcD5
aG aSS0Zhsc1 jRReD2⿆⿪eEjJehqFB D6	5@p
0{\/S4֑86
DFѼFD  жaa KqAh[ip.7A hO  t a\\/W3CA}QE QF,FGpJ58 E0
96hj
7hi0`~8Fl`CpE1#5pFhVB810CFDp#G7SDX 5E2
^/ E}0klG63 o86`q #a&5 [E4 0ľ$aaC0A_B[O	 6c+287P` 
p5_ON_ 87q3_OFF }_PR00ZE60Z58[H ׄ	_GPE
	3
 ]P
Gb b@Gof f@y E8E9ҠEA@ BC

@ED`EE F`
/_REG(pi1pP0A
a	iUEB:F0@[L @@F1  0ZF2 #3 45 6 7 8U9 A1 B FC" DF1FF C100^1 23 456789^A Bs]CsD@E C110
1U
21314151`1171819111B1Cp11D_INI T11EC
>NC1
F0w20q1
q2#3
q4
uq5Ѡ126s]78

q912AB
Unknown 
NiMH 
LiIon NCС0>-{ 3Ф!ѡE800`ѤE8д@
d1XDED
731TeAC c
@K A+}ha{a
V%#}i!3 
QS!*2q*2&Y12D	ZZE -Ѣ'6"E	-7p
{`QI1)F
[)h`p4`
csc
  dziWr`a[)}a2bsdba3U/3Tz4X56ccCC130	 UhgS0+Eg
#ʕ!11 {`gPPW919CAApFC!0
01>Y@=02w@ w 8axra
c 
dcbpbw@Ѣba"C9C@BE`?FaD A2`a*DM.11gA/1&@[I94
9:+;p
  'N4>;	ip
Q!2<>9Z[?3G4c?5cI4A6T C pھA
{ `z@[{``P6Jpq:7dd@1U  9X2c cpT e_e\eQ\xcpe'cpc\)J2J,@6 p}
28p
a !S113Ю(_Q0!3YTQPPʐe4eR!b
dp
aߡp
AC
b"a:e5\0TZ_ L7]l8['llTZ3_gK!h6|` 
;R0oa139
oPR_CPU0rRo1_
o2s2l7lmnsN!h8Sp0#@7#g
]
qA
zBp#e9Sp:|geA gqCdBDdE _Q10 8-(`z3ax1xYy(}_A#}1}z|{F
{ .BiAi[4
3PNp>a40[pα p 52 431l 546q7 L
849A1]414DEF50p 5q5354@
[P `'15a56ђ5 561515aL5BJ5Pp
UVaC aaв15DBrR.`)ҡ0`ҡpҡ1B a^Q
 y@7a`JE5F1/s1EPc b1Fb1DcGNR1Eb?Cc3!51bqaa0a53c0>5F[ya
A
 d
b
 0:bdpdAQc
 c
0:c&C/5FO
C160B3`kaa
a
vj albbжb
vbkb.P6zp 4FpbgD 49}ERC9P6і51#!!Bzj
j12b0Q53=p1ѓ6" b b/	a/ .bbG62@05Bס12j4J5 P`A63`p*412v t56p4
{C0P`{24 ia``aDh
!KA5	Ѡ`aE2Xa 9c7.abcq.K0)66 p^}^7cIuqo68L
069

Gy 9נ16BAĆ?5EP\@/6&6BQjBQԠ`9[E6D _DDN
COM16E6F6w
30%" a8y 0S 6F@06EvϡQ4
 !+_DIS ;23#.6E=
KF_SRS 2h
@0707`ag1/70R0"/6E@
0D

 xqS3xy큡c/HQ'[0@1   
r_ON_`#

_OFF``r0 71[H:@2 [4@3_ADR_FDI"
O
_

%


e


 ބ) 
GG?"@ * y4r 
`zscbr 75 .Qq77Q7j77Q7CDB	=`7E A 7FJ,1A1uq80:	@,780+
G_w#0c84#AQ+"I	r0/@"/84DFxB~r" 0)0#c#r%$+[4 	@0+41\RMV73a cU/0E3gcg`g	MpE!85O
:32b#6p^3q`y8685[L$z7M޽C
_G 0" *
9Co;b9mF4
<x
K/O	Fг@^,0K՝0FA]9 A: *;@#/$
	o%U#Q'()88	@(,,88[C89P䰏MAp`2] 2B
8#Ac^Q1a^'C6B6Q8CH
1 Gxx<xx":bx2;xxc@<Fec@<c "g dhehc oh1e lLjlo8PGTP%c6C6CENB/CP?r,_.ysQCG]lg *KD~'8DLM4MDqQr4Q/RaS 1x12Dqp1Lv& -UVpMF,E.& Gsܱ[F)90 p\/ Ӡ0C58Q(g>`{Fsi /PNV80[#\_GL_{16
a;['$hGP91b}ab
}[%lRSC  " C ypq,@ @ "m`~[7Fĥ 
9G "   *""@ĥ׿a a -갖5ĥ
Gp p Gr rЮ" ڶ6` }`Gd d]"J[I 9p7a
" yQ98
99E98 1ӵ3199&O.k!   0_[+Ap   Үs QqF	729B  "9C
@[QaD  INI4D#EFa,`A0p!1 C0AC_S3D
аS4!B@@jC9[B0x03 +E_GTM 1p2p`0Y4ЀDA506p@ǰA+{UA5
PAWA5 F5MhhdhѠFi 10/
w07a:`@!` bwb
bwc@ib ac qrbUrcqu`AabA8"cAo8bca͠:߹9/!{PJEsD9I
C[07]F A͆QK0Ń0C ?RO,A#֠I
=E3
`M
?_ڟ۽ܠ)_qCXOQB-3D.
G_PS /3# o +@A1`i!^.C0C2q	
# i q3C4C5OC6C76	C8C9L0D +\_PICu h`\/VM pT MqE
sZ
sGC5F
 Q\AA
Y +Bp5\
?sF!"`#h`#A
sds ;!
"(a#Y A$Y!%&Y&	b33@	F
@//d
d
Primary 
102 
LIon 
Hewlett-Pack?ard E/0?Travel13.2~@8r.19L30	E7!<h`/`p?%
 O4t}
@
 
g33hr A<U4a<\1Aa\AD<=4ha`3A2hAp3
_UID S/E@F2B
_BI!< KSTRK [CL\1[GP3C(H6R)Fs(EtJ	KTJLLIM9B_
ACPIp63LFRPcJC`3O0-`; prZ`B631`3DƢ[:.p
_*_LIDsOB86@
	/15?@SXr̀N^QD8jbFcfpB0c@vB1c`d2@kk`!h`piaF?B`z a?{`
 go }ahgiap`ۈkpak àg yk ˠg1Эm 7 AFck MB3

[ f@[mBqq `rBqq`rrp}
yj 0re >11@h)h`PB3`xibbasabcpcau`a9`d4rwr i`zC03F
`#aq|43|b`a
}b

AB5d?!`d6sH0WDGD
PRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC CWQAAg*u1UCES
 %{|AQl&q߇ rBy5 zs
K? B
FfghiGWSAB풰
FbB57ipi%1F@ 3`恐O C
COMPAQ|PC C֠3 S1tReader|GEMPLUS|GPR400|PSCR|B %W	QtBQRNWSBC$!Pig7`7a;31na$`|2Z034a046
a}[Q8 Jq[#!l[#\_GL_wy037 vpj|8pk|lq|B\AhB`	l['¢['!\@B9?

[``dA!BC C1C6CphQCq9˩B/zAǩ{h
DBAp{zh
i C	8L7 PGDCG倀FAD0D1+q2D3R>D4 5 5rD PR1D6DD5
[PD7@(AnD89 sҧD1DABO oDAUyA
	`rh`k`vQRFMDCao[D7М cdJac
`rdn b}yvbaya
a0alr  eraye
	 evepeD0c ucdcMdD0_ { bpbgC	bdp@ apbe)ee ffg
fape`pfzfgvdueA`bD0` g0`r<b pg$8aggagubdM:E04B0!ZD3p@`cpb1TB2fy@5ш0CD0Cо"EhD0h H
bh`ձPc `rVEcP)adAB
ecCD30-adOft`fuad´uc2ftdg:ݔI`Ĕbp@FDF D4P30CADEaD4`{
_INIFB51pibhbC1E0p0E0t1ZdjDE1x2c522rbPW3 w
aru ZDbAb@`babuaa@wbua`R+_CRS0D`ܒaoE3``2Ot0R}`'`Мњ~!
	   yZQE4AE5=
:GG   @   r  ySE5[wDB1E7067F
bGP G$ $ GN N P P Gh h Gt tr   G@p`s #y n^^0
E4{6T0_!@@
3Bp4RB`
5BP M\_PTSphO2HSp ˒ uWJ nufbEB"\_WAKQDg)B7CEA00EAC@C0F10o!k60TZE8 TZ1_
V!2!p@0A
DQ!r3NWXb%>C

%Da(Xcbcco*Fa
Kc$9"B9 oAB
 ˟AC
0!B L1LL150M,
720N\ 9G,<

08n6

78:o;b=;==;AҳEB T C D
E
@obFKB1HBlB3WB4ZD5BGFB6 37b38
wA F7
۠CjF6 
41FLJ0i0KB8
0 p
K2Kp
'L>!rIyIOiRL0IAGH0F9
rIhF6p
~`2Gpi`K9@z~NOrYQ=iaGRO`\QB0pFAHfahF5i0h qAbQ7BBi ` a I6f8
+piP^&pKDE
8370pPB2akhmRW37t
axa

`bPP08E

bt_kls
 nbm

pqm	1?r
!
H\Oou_L~BC	F eadP*sdIp{v3 I{b
 t bbwb

aranMpLa!1_*"KC?)a~;"a3h ~~1a4 "a@ $21gy
bI	`38b  ֡Cpibh  a`%.  dqN F2<Q#aBW1Sj1"я!yBD`h{V!3_
Rb38j M0FD
>b jh w`t`n`x`}fdf
p{tf{fϔ At<QBncbbn }b&8A{dbbFi`%

ep
dk
0MPdyRpmdpame@i)"ف!xB	sr{Baa_a[6BE	R@H
?_ON_QW`dVcFFQW9@F]
ԫw
200]
T
u1]
Բ
~[32B  _PR0E["3
mxF3w 35m1[H!_AL42q1CAsL2CpAL3C5_AC0ArA r11r2/r3P@pPSVERSLPR_CP_U0G60`BgҎG(r{aj юEBpECp
qAp
A$:E ͡pD_TSP
dC1TC2ѻCRT0kPTMP1 [[G"7@208jȲ,mѲ{f3  ǀL? LC\_GPEH9bC209>iH_L0yz E{` ,{`
4x!rm
2""p
p304?1SB<5C_2SD3N_L11{6`O36.X{{1
A+046
X45J
`maA*OIP^aaPa `a ~ ga   aI!p"07 {64?`}@/446C0D6?_t8$KrC"б./5KMDdr644
 ec9$C`H @c3r9'RR$$ ["SSDT%COMPAQCPQGysr   MSwFTA?(B:
e#б&y &O  &C%&
')a_PDC{h`Ў+PCT k
+(Q.B	_PPC YƐ-SS-N/.S/0O/ 22 124?567_:9 <;>?>_?AAC CFFHpI11 KH?L_MN?PPS RU?UXWXYZ \]___?bb          U|˅;   @ ` .UNDIL   ?OPCIR C      |P    $PnP   i\!ZAsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3Copyright (C) 2000-3 Corporation
19970 IntelAll "s reserved.
  , PXE-2.1 (build 082)E
MBA  
t2ôu3CUf`F  fa] j j
j
PS^< t	2PC[X] a$0<9vP EPb їFP"fPf!fsP #f~I#j:6$ݫ$SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlV ,Vv-,#-^ ,^~P.˗.]0Uf^]2 tw@Q2?Ĉ  t^@:^QS0 [Y 5.> th  Ph2T6 M6 F6?SQfRWV`55	hJ$Af.>I t.;@  >  U  r rD: h'@ ۹H l 8tY[i
EC1: Base-code ROM ID structure was n	found.T@0: ASF is? enabl canBl .   YJ0;?	8Sfj j '>  t;sf=$BC$uErPj W1II떌WێE::0J f&J=  .W6O!P!P!P~j Ph9&u
˃Z t9hlRgo>?C_L er() ==  ްrI?hC%M0F: ExitingWAEAT6
?^_fZY[ M, ~\. f"]0]Q]S^pf
 T&6 +&`fRSfP& f1+3ffJtuہ 3fX[fZА+Pb.\ T6&aԋ`@#SfWfUj j  I IRV T&a.~6E.i.i.i.i
"] ]0,ЉVe^l_l6Usmp]IoWopRf6U_fVq@rRR{ t t`tȠ:ɐ=P`4@2DBIOS extended memory c
 errorgC6: driver imageqDinvaliXC8: !AEAC@{y2Asegm
gC9:NV+|}: u P:O u5hw_d5@3@iCA){feI\M^f^f.O sDhP:JEw/x  AHrVMTMԊzrvf&D F&D@+ Bђ H PeJR&DKV@I&(Dv"	xijkWj &\R
Qs;b5uBpءL ` N b f3҃Whf[ fR@#XfZR&  oYju*U R$8vuj@aH F FRqvXtuPWfG HF +F )F[fSVWFa  6_ QgfTN Э  f _^f[^Rf]f_f[fX1,q8S`aYfr PcpcJt ucS``tfp  OffP= t.. oﾭށ.s	N]&}t	At+{f&} us@#.N9wf&+f&;EyskfXRCw@=  
 s@ȼr@#&_f.+qꠓuf@Aqf]33pfP: mPXätA+ȓ+C'8^G3pŋ. G30󫧄Q1v=`` _ՐAԊs}
b  P:0  u	b [DbAtECԊ\sCO  `ʾ_&<|t.;60 rb %Xr< u`ɉw_G&DP?  &L5l W&  e" G(e*10 8e2:.06 >a Xƪht޼ ^◃W,r*!rدG  *s.r`Tۭ &$јp`Ƀ?I Q\f[]#<fZö@#h
!,t
fX  W`gQhf3 Rf8f` f u0Hu 065/fpfuff#°H`дuo fðl;(fu31 6	Itff )@Ha41t'0g#d1,+	AegfZL f f  f͘` aD0 f9 ȀdqRf qw _|`4 tfZZY N RYq5u 2
  @tf<A
 	fSp OA f\
a`
_fY
Oa
 
@T8
`SȀd@R@+a}`f
úfffZ2P8fXQf A
I=f;tfIu=@Zr`5pu$T?3.G.P #.1.`Pa	P I@I.( SXf% 	QdI]1,qp  f?_SM_ts OvQj S1I/֐IA# A$ЀwrgrafGtWO Q踠l Yuf wXf,g8 tIt#gfXfg)f@lg@tgeNPnPuW32&C&:]u
uB~,}
 t7pQ RSj`&]
[uh/e%03tBSW ߀;$u> PuAMu	>P5Gu݃f2P\3p 11I0f>tf  fWf   t;h6Y4@07:  PCI#callBsupport E~	:uQ.;D>7?8Dtttnh>+%<1yn><Device!OqpY%<4Xx read!Y<configuration space`p3ffbj  wPRXu
pü |U.~ QP>`PafR. .M2<tR?h%SU%<yOpRH1requires DDIM>lp$ h b"% ?CS6Q'jcfjсdfhfQAPeu0?h
b6x
Ic{ PMM funcRHnumbe yZ u&h[E\=ocCHxg`Pf1frgfgfff_.=P>I cI.@0tt	 t5` `fd>phpgfg &u zSeh`bi STk%t p>=q(r$.   2_qrstu vx?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_  !#?$_%&'() *,?-_./012 35?6_789:; <>??_@ABCD EG?H_IJKLM NP?Q_RSTUV WY?Z_[\]^_ `b?c_defgh ik?l_mnopq rt?u_vwxyz {}?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$% &(?)_*+,-. /1?2_34567 8:?;_<=>?@ AC?D_EFGHI JL?M_NOPQR SU?V_WXYZ[ \^?__`abcd eg?h_ijklm np?q_rstuv wy?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ ! "$?%_&'()* +-?._/0123 46?7_89:;< =??@_ABCDE FH?I_JKLMN OQ?R_STUVWDXYZZZ%\(\&\&\;^T&_4^A2``3^UB2bb1^Y e-^
g`athbtcuj N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hiZeeee@eeX d  	e0 
~ eP e` 
epcB} 6ee ~Id7PƄi["#\$$x'))))Z*<*J*t))+0//$$Z/^1'|ZDIX+802.3  tttttWS ˌt&  .V!POXEXe erE}Ɓe?6+@:e^S0NV+,9
e@p@
efUfSfQfRfWfVfPFwO. ~
,2&22ێӼ46h@ WP追
0 fXf^f_fZfYf[f].?>  u
o` @ Ѣfv
Phm.6 j }ːfUfBg]g}wer`áf&.2؎РfUӢS@f]f!& tPu`1Ϥfڃ>*2 tj ÐSf. ff"2&2. -  2f3"Q. 3h f&P f&*2 []`ñj "9h uf. ?fh `P eV@ g&5 e+g&B^r t0g S̸[Se5P?PfX&Ʋ=PVu NVf.ߋ f ]ϝp p Z 2.   ~F~`~ uː u^&鿐Fѧ5FsB҇sӗ{sӓsss%ssQs'sӷ{ssߕ{C	q1	g-	])	S%	I_	{?	5
+o!π== w. *4>HR\fpzF1щ~@aσ>
9 ta h@62X9^&G99&G	
9@6o
9Bu43Ȁg>6_u3$8fj@!븈 d
"4uPZ8K6p230F6^G#FG%F 6FF~sE>6 u>^`*F)^V@` ){ tGKTRt 	`
9 (:`  0jKdr^A^V":1"+/BCAt"G0H`0r~Gtp uG t>G ޡ7
$! W
 )
$ I
F- VF^	#	
+t*u!
 	m 

	3	C& 9 P0 P 6F9GwaÐii"9pwذBPV&  VF  	F0}@6pFrpT^ `ڿ^V usF~'}p6 !ta  2#u?B!!#" o->uL!F ^`OfNF?^F  ^+t2)@*^v&)F& #~|--./qvg@j.*Ht
H|p
H~H@2` FF^)Q-ftv;Qp{45pWF7"4 #Fv:6f&p:&?@
44.:Ʋ7@
p8#<<ݻP<s0<1
AFGGU?&G(7?*G,2?fGAGfG." G#BA}^ো_#!_%2!(3 r)LC 	Dr	t2PF
cpcM"PpCaVcr)F v@.ވ"p`/GDH3t@IB2"E 1
<
?3_1QC_%*1"\83TUu"뀵-pG ~6*Gff`Df
hAp\!W@bjjWաD C4m0G퐟$ZP^$&G	r
rc!QGvcgrxcgajGGubjZGbjՁdx	bjdx
]Gr{cg
r}cgF 6 /fl`G3@WgtrF--3- @v<
  FFuf f1#}Ǡ  't
riϐ>pKt, 
 kD@Ƌ^F^VpK" .
pf1ܠpC
  -"ZgB  @^7v3
*&o@D @+{u++u$+u3	 KFFg4PQs?&tbs4-  @
LA~ԝ7>h > %'`$fF$aaM?\F}k
zPu2aPSV ppN9u2Gv_@x|?GrЩGÐz]wO W@@ @Pj P3۸YFiV԰@pRS$1$ÜX	S[	[PA}Sf3یfff[F @]qQN$     YrfSQVߋNfP¸$" з[!ff``B@0ρ v0*f+fX" " +$^Yf[sVWv^~F
N~ tIfȃt_^PQWfaBğ~NWqªQYê_YfX]a0..v= c"yɠ
S2P%trIFyrr̢ȀϢ.ǋFҀ}F++ ɂ"2$2`N`&(	@pP P0 ;FtN 鰭aBG@pVQȋsLY^<  ^]1}WfP2ff
`BúffP~fX ŝ_]}ހ}f$ +ڜ2C@@bPQRѹ`;ssZY1ffRPFr2^*/NpF!=Dw=Ds-t01-Gr	- vHHt!!HP L 跊P&VjWpt	3cVF@
  ~ 33(L$p2	ೡub% $P`ntZuVAE
v P`dpKPS'  0]V @K Q%0F 6((0A  @RPV^c }I+ұWL9Pu(
!Q9@u9Pgu
pP
?ﾺޢ ?P%0f+}f9Fu0P*~u0P% @!LN_!t ?,0H? McM"~}+vu9P
uދG
:$
𰫀%@$̰cM%0P`NN pF+v&FPC9F|,㮬M]$pI j#0P!t_PC8h60#`À*PÃİVrx!G
r,
r"Ph v*@y 뷐2QǇY&0H./[t1QG0@!(,*,,,.,0,2,40S 7Ox32y|3HGBV t; u`0Wd|䞁Q`9 (SA:}w6/L8`?@S7`ӻOq@*T@C,K"$CmCp6+ҦQ>Z`R©fFڋFbA[Q:NA#;G  {*VA1	F J9FuN\!P@K+F{HP~p0P  V_v Pp!V7`Ӌw2@PK"*@u#(KH#؋v`UtRc `SwA5bZ9FD HUG+9(I#+3؁:TnZ_hGI@III0t0Bp;F"bp'F+FNFOaO.9FPcPb;FUf`CQQ.*VZ^V"SSjThUKVFbHcr)mrL fc  '"t"oJ P2Cq0;0e@u&jCXXYjYaZ0x[\<0\	^0^dx_;-%P2;j0?9?u⮥?2*K|V 9?@Jv "@Є  ~ ~8,)Fy}^3D`U@2;i0J@ьAD+p6;FsG+05[FVuxrG 0GGR3 lq? `Щ?Ѹ?A05F +*#{.]0I骀^ejQWQJ_fcwM `@Єa4+@oP~nVp0CvS@wTBhUr LVO^fMb?F\qVP2F  GPdxM0UԈ ?^9@ts@^
`@KT!'u9z^͸`\ 	+;u
;uܤ!
qa93vUءx t5䦃x t:VCB7t32v@?3Qe=Q^9f4u{"y#@Nt$L(X)=uGtDtDtu"Hje*+Pj+0c,؀^[؋>`ܱ20FډGj12ؑGq_G,2} _p߉G'v0؃'$@ ưɋV'820[氇`dpbPPfh  fh  j@RPFPvp_72B9߃ u-^ jp'3 P p T؃
G3
G4
G5
G6
G7
G8tjG-PG3+ӑ/?EfG7?tG{A7_q#GH8C"S`ؑv0s
P@+`jE_.GOBA8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<_GC3?,-`9GtĀ8P"m p
rA1Ãn
@u .cDPf܀ t ݿ MGP9( o&Tu>$ o  A{c8 Z" Q" H" ?tP
 0C 0
Āt$0
37
ApB]Gor/)
!
`WI+`9F
  
0k t `-O!_ w-*+d-fv(f
ffff 
ס1- t 	
ZPՋV  t	Ր0/ 9 =   w t	a		8 4艁/
t2=~` t	dn !~ @^Q1/UA	1%	A,`B^_:RSf`=prP-X 	``@d&C`لP2ÙA&*&!9fg
 8:Q`bá>gG)Z.QG`
 ;q0Vff}!f~ ùQGV7R	G
	WP
WQGG/WpH Q;!Jq`gF"(U 9:::U: :!: :U@:%::):PRP(3A$A%
r#
1B u0U*PЊOԊ OъOa
 +ҕF*p
$AC8DhD1B\"A|
A%'0N)0O+AN-0O/N10O3N50O7aZS90O;SQ=0O0SA0OCSE0OGSI0OKjASM0OO䵆SQ0OSuZSU0OWadSY0O[SS]V0O_!BSa0Oc1Se0Og Si0OkjASm0Ooq0Osb0Okb0Ob0O!Zb0Ob0ObV0OAb0ON0Oeb0OjaTb0OCb0O!2Zb0O!b0Obٶ0OANV0Or0Or0Oau0Ou0O0ҋEG֋UI yKDyQ ySDyUa ycDye ygBy}p:;W }| })|+*lm yDy yӪDy yDy y۪Dy yDy yDy yD|
| }!|# }%|' }-|/~	~ڸ0T&Aet񱤈u	  0)ڀA薠PN
`{:u4tA*eH`0)0AEFсʫPQɎme>#PS$p	Fq3[rØ!<L2`)PS=P$h p6#}%^1pͽ@ h8 ϒ Gh"N Hppf!G
N   !
 *	HtHtHt@V0AAyS8Ģ  @ƁfyP	FuEuSfp͔pJ@.JsT?F t⑯`	ڬEfU៽38ျ7 ͋G#FG%F^F^VFVF~%3F tP+Ff%߀  f *_#Gb3_%FtSRf *$%3w2`>	O V%@8^P4Qf.S.ˑ#SƇ 3Gf Ghq	7=h=UరVЮ<;`4GѴVGW @u̐T'FFV FF+Ґ9Wdrw9GbvΫDܣq 2rrзvkt!o̅B ڼ@8W`FEP4y9~3ã36䧵R 82*p"bka4AÐజ6S+ fմF  7u	Q	"0t0QԪ	@NF~@8FB}  1
N~?? p 2~st.GGMF~
uFޠQ*PP'Ň uPYFt]  T@.S>stf" ?ۑ 
@χ f2sLP1bA@ut@XPǇ 5Ft!d [t뻱
 ?q(@	*bץ(C!퇰2f3ҿffu9	òރ"a HǇ@KJݣQGi@#A,sQ&Ǹ w0q~T wzaKƇ123PG
>

g Gw% qR0U"wqqДqiēq9 
 fPA##aݧ@Bк6$$v"4 E&k('.2E1J 1B #M ``  3PS΁GȃG`q0PAPSNN9u2Ѵv?@0>G{V99G쁇}2O|04@0[x ɬp  s Նnn< 1Q@FGz@@p@w;GQ@GvTC`CDx@,%7@AC{CG`1}CHCұH`f+f\ rIC
LpLC DWԠ4H#1h tPfj ܃
!ÊFr<t<uAÈGpQ@GjA׈Gq3RkAňGr3RlAĈGs3RmAǈGtz3RnAƈGu3RwoF`%ʩ)Q@ b X䐲bYSYzAuB@ff0Rpj|I?3pHG%C% u\R\%]#pDDwRqap$̕$% 'b'T vcq(WdpR)A)賸euQԞ_nF|t1JIrE,6b| Mא=#3 /@0@1234
FV
fq`t@ t^F&^F&
u; SWV~ANV^_|B}}~ŠߦA~y~ќFN
ȋNu	] }S!f{
2[N`SF PN3a_3E^yupfr;Vwr;Fv+FV
+FV؃ 2P#   P blksize tҌU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg`h i : ? a y w <v bt x j  s |1 
CLIENT MAC ADDR:!XENV+     GUID:
DHCP.Client:Arch:}0q:UNDIci0 dIP SKǝPROXYǢ
GATEWA£ ?MD  BD
Auto-select:
 0BOOT ?SERVERգ)ѝϦϫ/Ӫ-->  MTFTP0-T  Abortedroxy¢service did not reply toquest on p 4011.   coulClocate acureer Mi?ssing  address BIS bad ry structqchecksum get signaRinforma{tifail!free mecmoл)bopobj@ authorizþ flag!shutdow!i?nitial9mage/creYd  v0dϾintegrity54Netwo{rkcanc d by key ok`ARP timeoutopenError - F@ }NpfoundAcc Viol receivfrom unknopcoderep
Paconn@ө2Ը NoS poffers wep?Z Фހۢf@namw In џ API fun numbŠICr multicast4whathrb PHYfigurDataaћEEMsettarrupdtoo many /packs̒PisP M?edia tq!p,4cable NBPQbioӿbas Bp4discolip = nu and/fmp憾 C-آstrePnџ-mຠ de.  /-\
SM/D?MI BIOs ne d_U_	d
|!u
 zo uQPːz u{& 鐃>.3 u3\.3h[0N0-  r- vHHt
- r뾐:: 1LP3  P=?6 H10A)~!aoP='y$30-q6`k
hx9 -i[#3utyI[놢[3m{o33A뽼33=S#?	3=1 tw5= }.f   0))$=q 0w-2 tHt-= +7-s +HH -!
q` i  q9  >9 tQP JL`df99f22hP99@t{<I`kty3^h
J`kShRF~@g }R84RF9*9Fr䡸93M`k蹱3n>uY!" 1J7NMqIHp tptE|jOhR HFP)9Fu9R 9빮Q}/>0u>t/II7ؕL0N!//9P{0C  VPY+ҊԊ*ґE@zVF=+$ fVu3Aw>0t3E(3*3(h2OvqO E_/0N	1(37f(3Ifp7sEy WN뜐T3Ih96:6O636H3 |3O8tְE2u}dL% KҀĀfVQL0zGM|f+KfPI&VFVP7Puf6(RPK	0M" 9UabWFS?V^f`PVr$=NVu^F^f&{G(0zX^Pw؁yaCu-Е- v/&iGN@z^& u*&GaCz =pa u6s&GibCG#&br<a0]OfQ1N@]U .Dy/9u/@g0/0G|Fo9`[Gf9  fP2 ~UU2kHkm3l@k\3lPkKUajS*&`fPaj&(GbpG0FF5FF~bp9G6TNfNfQhsHT7U04t:T^*&O;~S*\Pp|S3`uc#w#wE#w#w@{Aw!wGG$ac`u޴o
P!w(G	TbeG7(3@#AP!V;.3fpBb  t&}?#AoghiE04|0І RP0+Ԅ
ԄЄ`e3& 2),04恒BA3*E3:}aORTfqe|1aCa V-tHHu9#A5#AdfEqOoiCbe GPQЕ Еїї І P3cC_S& f`[`K<2i?B_vJELS3 Kn*2CŐA;uQLc|bed=3 =2 } Yc!0-6 tPK?u@OhiB.044@L@y|fgB@mӈBP3DЎo2!05N~O tItEdefQ@]W9 cfƐv2AϱCb
Q!_
s܀wŷGP1@]&W2604PcfkFlPDQk+0TU0T0T0T0T$mIfjF=vG*F $KI~ t
0M! FËF_Ft0M#ސ0f@ÐBjfIQ #ƑF	U80;?2#ɰF$ fBŚH2ƭ=F8jx0;VE/F%!0 . Ҫ0e W)VmGR_&(ѼPD$GfUE
8ǘ-VDn'@NwF=|E@0L S+;Vr
w;FvFF3Wh3HE^K U!<"00@T0Q0ŋF<pﾭ`ð5[F2=D8ǰF~ tfRu@0f WV2a 1}2^_2&s;( ӳC0ɐo7Hv⸀22f kftrHuVHu0HuraRPK00N`ЋV!GHt.;ԻRSRPV tDt@u2^+v
rD7D0`eN&]@rNF( U04r`z@ F`4@aht3k Kt3R3u3 7v
 Kf2fx{3@0L|a[cSc>v`zt!wGHtP-I tJ-
 tE~3 n
 5FFb1-q t c\|K0]f3뷐S~+u!2$ bR 7Fv&$$$$$$
$$$$$+$6$<$C$$$$$$$$F*FN`u^9 V r -
 tT`Fu{>4P+h"(CcG			th&CpX	Ch. Cf>	 kt.aL FTƁU.
AIu(5 eha]GFJ"w^Lqp_o	au&S8!w9L  0h6H0kǺ
 _ /=1>{F> ???= ׄF&GF>^t'X;F6F9"-WEf% !I6QMX_39"7Fq!^33H6&PF39F|ך"4O
.@f`2V@WQfjp88Vh: C$,h:G PV3`e!{ ?BF젵;BG<@  o>W@sqzWD^ZwH^ZL^Z({uXSXXҌWwT^ZX^Zw\^Z`^Zh?___hEu! KQX2cMWd=)= wA.JNlߔ=ako-& 51nD- t-;^- tTV@Р9vO00V=4~C HtzNR - 頟F2WWRZWgG 7WpdÌ²W!&ǉWg4&xx;yy1x&wty{Gy{u$g$n	r"G$"hX	 苏DP hs F*Ci 鱮y`iW
 Sw"8~xyjvT:,,@Cg,&_*|&_~-5{ -1k	mt- t:p ` t$ u&?  u
Әbq ᣀ?tB&9Guf& u  t؍G =
 
*!ĩ`DW V DvvvBi7Vj
 &fXfYffff88A 9ߠ 7:QFQjPe+ hB ix pqUVBIRPE T
ix &nPF>_ ep`h0L FA=zӂP5@7u~ t	F
3
UtltppR32S'Ȏ  ǆr D0577 虍880[** ӒѸȍӆt𰓞 t^ uf~39Glu䁔pu-$F%@qSRQfP
R
21T7Tx&B𬏭6贐 777"+۰ϰ) ̋0- Dt-gut)ó uQpu7h)%?Ȍq}sPi0P)'
I`^+ y
FPR`0$10TsT% x`DP ivt u-FF9F"iPu3P9`RI
bv0տ¥i񤦵ruP}.ivQU tFs1 =P"b԰h\V2-.>_cu1MtiԒی&j&hy){CyX5?c۳tt(uwH!kl> zHjil`=iFoPqU<fXST㋀`@2	 9{RtPs: _j\^@HtHtoi  3h5&bĘ 3F0h92 ;; t	ՍYl P~3iF01P81+20! dם+1&$: g 2
o
K23dEX1;~ t3Ǫ@9)T cq0(ӡF٫2LP;3tq* u
1C D+~ r,rPL2FPL^ V@Cu~3*=*.FT2   oSRPW|*/P7=00oP!!k :1\!Opo8*:5:0̣iv@:ĘTydh2 F=9G@?@&=O#N; ~ ta=+RAP
@:#PG&WI9FVQLPNstգL9Mu9PMuNt[~ tH3LPNFAG-Lvi~@:ᢋ؎F"pP~;\usJt
F":`s	-!`V6hOb0Sn21f>&f`f9thxфѦhoS0@R9 t@3 Kf1V1ƹ +uhc0 R09oP藡X@0`rh?0^(
A") f|
f`:+h: o[6 P)dF 5 9F~_ ! `ux_ aak_ aa^`
_ pL_ !d?  p }/^ۋ }cFпPps_P dg.eB +.1Q à_`ujRjS  F9v[~!uꈤ@l[U lu1b$+"ɮl tuntI1"4#:%t\ jfjvÐ fv  軵4rƃ3P x"𾑺a t&Gtz,@ 8{!e|tzl (| u}Rl taԐÄ|0~rƋGulp upxJxXyЗhPC4*t--ePEz k*3cpJrƉf&)f\pFFtR~ t^eE{{ P99Ŵ t
^aEu4y:Ÿpq^B\4:FFu	+63 >;`#	*a+4*6FuHa^3PHa* u9,35B3@3ń t^>u
B33`pJVBC YApPe PEe> w$x׋V;xP^ÑׁӉtOf6 a1\aP)տq"T"&
Iz)_R!1u[&x3肱 7" 
 hTR f+F^!K
&Fpa^OCNFc	9FsA곋^	&9uG×p|C@\	 1aIu$GR&_GPt`|P|tw To'qxP tt>~ tz_Tm/h;)2g
*(xGpJ&F h(Rð=# /Ӽhf 3{.-4)/$&	#u^S!JrJsIb ˴_(F YGV`=(Dvf&0O3űa(Pw2f`~^NvVFn
fa
P[2݁ǿ  h&$6h^V6  u	rwPd t^`¾tfX u	   0[VADuyTT u
vxkP2   v wr@TX`|X>s$t̆uCwDQȥhR6=GXEZFp"	 Kຉ	@Xv&@*!Y F;Fw~T\ `tH`> t\n>rR
Q_N\E^UR


B!×OR
4`&8g@p%3u;v
軺% ZFrZ l0Zs
Vṵ@?Ht'&+h%)%[VNExEV3o+ǝW;%X*%Yo!qrZ%Z
%*3P$Is=R $eHAѵuUZ$ ǆp6fǆl @ Ɔh$2	& @}n$  hO%= Btw3--,uIA `t#)"3R6- [t- 
tؑאĞ&8t&pP
u!pa@)h#ǆqG vȾq# ȠڂZ#WP`G%
h C @f*!"W'2" @"M9! `Z*#eR
9FrF
 $*+`vЎf^f喇^*hXfhp p7VV73 Qc/@\
P_fh  pV1b)v6O+p0- Py33 `J #=.t = t -t߶)p tN&fh1V}1q'2;Q447>^6U鿐O-=KF{ i=Bk)B'p,H S-	t-
-= K-w- 9t-
t- 0Mt- tpHts![pV>Pu1$ >TJ9 QK$9>
 tFu&"L^Y ^^ f!24r0P9t3 2 ވv3@fQv&8 u@ffǀSoctegF@fTt `UF9EuES>? ~4pVv3` $&X%@ UXYV~ t?f(`<auX   ]]Y^ƀS0e$^e4[bK
'@'`9N`J`63ףL3_z`v'kRKt	t(>	!ht3h9 29 h8_ LRM.bL3 {zRK VijPǄ ff92uvf`ku:P`9u1h&_&;w!nm``pn ߄f9l&{:lt_i}ju|jJcbdu93ba0bL3١pua=Ë2 2 f2m>J3P VFVN3 &FtoHHt	HZf([u"hdFhl}}+h; \Lu< Owu	= > 6S[Y4[Q  x ep
 !$dN3 	>bKE%+ RHct
sa#wtkl9Q%- `9,~L~~`? k?Tc>2 upo9:?h2 >#TK nc#uBW_WKSRWYWmOQXX*<X)"YZ=Vt9느Ff=E~ v[Y`ה ]M]!zY(3O*3y|~>Nكq ,}ziˠ#; -c ah?v9Pۣv@u9|Y$#R&sv90CWl#PQv9_!>	>ewڰ aa>4d4Qb v$ h|ahcQq%
rtf'k[:klkEp:p/0ܭi	S0krk9 3t\jiu0ᭃ v\v5 i9f > isQ!c-k"l#>rwpؓaqRÐJP3`-E0 1Q'*N t:upVErɭA,:,v*+1B2@`fj
 fXfYffffF~*FwF0^)FX9Fv	FˋF _;Fs"Э́~#v#Fg"JKpKf+fPӣ63أH3OtRP`? tH#O9M}b   Rᎋ;F
c:t `aK8C0 Ek9f"z@\fpfFF432N`3-6 5|p~cN˙baݐߍFPж"}$SK9R݃t9"*ȍh1_x? @'W fKf 5Hj5͋*ڙډN^bwFV;r
w;vG:Rݏ@@+؋FVw RݽsP}tt11~`:aPtJFV43?`Ff\f`9FKOaBްndFu
/E
3aUVVvpZ$0=  t)ArZw <Ar<Zw FC:t^`  VfC*N-0S^RPTt@T0r@T9v Qb  WVׂ00N!2ےwߒӁV3{^_tV 
2C`=ʙ~ -utF0C_PVY
p\"Fɽb\@bh8hV3# ,V3X3Y!Z3@03\3`3ta3barP  PJ@ol3n3 Ipa$k9pZ#O99p391%9%9(Q9v0)2rp!'d3'h3( Z$""#^PX3
 b0#!'u	W3 &߀?r"1wh83P~ f Q O Ru!ap͉V`6FV
22##rZ&w#2#62;ȿu5;u1N72o894A\4aS2s%jNQ1 Z3ъ]R$E0"0?-f@B. @-ff-%/o
/ A2V =	- @`F ^%2DDE FtG@F0+F;FwwHIM-DE+V`L"F"LL9'qG4 ƣpH@FFf>6 tKa;8rBw;6v:>d'F
?+6 68= X 
 pV܀~t	F~drጒkú> ur[r]u`۞/a/;Fu$<u&pt
f>  @usM% Ht `&pS69FXc8wNX$0d0V~ t*f^&G&tpj&9&9WxFm%  F"\p3u9Fou ot䑬!\/ `aj!U~@xP'q (9g(Pz9) t99~ u-b`!* =tu s1G*]
a'0 t7_F^(l{t#U0q9Fq9FW`ۉc4	PtĨwG@ur BruF9FnaQwnЍF;Foz
 F09FO99v<w7a*[	^x? Áavma҂Qi) k5}0y	yQ01]0A6:3k^9u9ukFPa=0 s
! uhph? .Ӕp!Ƈy`h9!  9֠9  
9h9Q
 fP3S3&R39099ր't'Gr耤9жG
P G`\F:zS"akFS3rPOs!sWkLP<'9+	rж̝$f0= u 2Җz 
=z@Ā]
u^
 uf^49u$ч@ w_mĖ"".@@d`Ңbq"@5๖ -{aah:3Mp99[h.:  t!@b m  f W`Z3$FPj9&_@]3Ð ÇE;#$P

׍F:u6~Ku+~Tu%~ {ua :~Bu~Pu
 ɰtް-E Rxʑˆz   ǆ~ԍx~ǀ谖 _Fÿ_aSQ @@݆;؋s_Y[\pF̿0Fآ0)ֻR%ԣ0)w9҇Ftېч$`$FFV6PFF~nF0@ FFF FFFϢF}P	F&uFP

@FF`>F/ST$PnVF̢5oFP%

@[.&NXf* PWQRU>@[@ > j>]ȃ us>@ ul>L |ibw[>* L &D F +ȋ  ( B`V6H ^;s/# !sԡ( ]ZY_3 ~WW_f`.P>9tJw.0 q.A!0t9а r   fa.>*N t&.(N! 9r & ӄt"QfP(N u8Pwh3ظ O&.(N&G.*N[i Y@Y!ĜSQ3ۿËȋdtFAÑhf
Qt`Y[`f.(N}I f.@[PQRvo 
A	˃ӈ@
  .,N X tZYXÿ.",N
 V3YӋû^]
 @PuYБc Yt24W  _^]Q  2sYÀ>[
 u[
Z
XР3aP; CX
n&5T
ωV
&AX
`  @"ɀ>@*u1UV?+T
)0VfT
!|sPf!-f/  j.)*+9Vw-rowq) '/|"*댐>
 tZF0 04hl * %^9s6߷P m@506NohUPV37$
F 8Ft)F ~ t$:$* ^P +Ҁ>F`Ƃ9R$Th ?	-t-w,tPWV$pݚ;N ^~&&Q#2#222##;u;u3Fsf9 uETFbI?99EbI;`Ku;Ku?o^_03V}PF!URO;Fti"puP9BTHL24bI961M9Kt4Z7SSuIbI%`KKQRQ fSfQfR?f Šf;sf;wf;orZv[s@fZfYf[]`SQ?r`Y[ PS? [Ft%&?	u
h*~ FATށ(wp;@   a `: .c'QddQdqd*`@+!`(Th0>ɱAT`pd&Gfk\kR 
kwCk9l#k*k lnk	ln
nnn
n{nu@2\Ru	s2?2Z]vxuxPRwZXPRZX]!3P
pc FNp;3032AgG6,؂av 0^aȁF+2à @tHH @\Р^
t\
fw`
Оf!d
-P kepd
 @hРtd
37d
+ǰ_2f
9u+?f>`0&_4`ϡh
f`
fj
+j
l
f6j
2+>>`Ƌd
o)R@@p@@ɟÃ> `,8a  ;u!+V+ɉNFu3 >^f&3wsО WI&O
NHp0FF&9wvhV a9GtS
=u V>!3Y,thn
V	n
P ɊAP◐rÌ AXVfWtXˋf`V0 +N uf3lf3@fƉFfFfF / ߍlV ?Vv^ ˿^~0w3204\f_f^]PNrX OfCORPfEDOMf`༿q ]'fqufѳuf=23AIt
f=46AIu!a\P^_ | PtFncapp(BN0+V
OFtcOF&0i0+Pλ*#~ ~N?BR帾C F0N V#N'WV~Ťӻ!NS@WVBt5x5Dǳ9~F&%G<ar<zw, arzw :wr p18PSYp(G0iGWwGg
oF GFGWFGOG2Cuԉ[3a[[2ҹ G;tTwGg
0ogwww_ߒs|F,Vn*&'*@û@ &l &n f%Pf#f#f#f#f#f#f#fXS & [ÌرWVS3`(}Gڃ@V@(
VN3tii8 V Auif
r;Vwr;FvN3ҖOu؃ [^_\^N
Ȁuu	A\S#wf
2Ӓ\($0:<9vFbSW ۋSR3.:uJGuZRƀt%@}uw0йt
 t L`$Pr< u	ZXCu33_[΀Z^_SM_h^v_DMI_`0}^a$PnPR@^M_SYSID_PxP2P tP'+܀Ntatn$aOa /+t  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6   .     @	 _BM. "v }( B  @      #?_! H <*z5(5&5	$r
"pp
p
p0

̷́P
q
 p
 |pp ߊ p&q



  `܁"e ߁a     
 @@d`
Q34 0 $!A &!q
@dR  "2 d	cta#`!2#+  a#$r*4# a
$DA)A d*&a#@+@-%π% 0p'/> %$ :CZA/!%*& 	 7H y,t7 70$#9g
!(;Q#" ?"c#"`A%a #>:2@9/D#'bA'6,UC=p-#9@1073+9,"+*UCEIH 1=C0KQ5,r gMJCN@9`rKpUP5 /:aNdV4/SD:PAG u`( BeJjX($F" u*D\19ITC^b-0,KQr_
_%#!4a#LaYt*!((W+'!&$49^M@< \7q&6,!"D9 R4(Hdl+WTnȁB0(/R
 edcrVClcV"|Y '%@\/DPuRcJ Mvkx:@\ D_u\9Dv@a
CI^̤:#@+rklf9dh2' a#A>'!#Fr @uYFh\2) DՍv,Cxv ^!}l1@C0a#  P#iCeF}Zc# Hq~T K8I !IQlWė|ŋ:
5WE$ g	mė3T?`3 9#!=cEWFV9ėbWc9a3$'@A;#eY
S 
K q.iL c%5譶kaV+ca0 q΀i A6YcKc%5DEʚ5 B}ud=n'm9X"űiUܣ']d96CN(FnUB gCxf5w9dqHJmdC,)ѡu2bYA>@Cc.́IQ yu T7Qo@$a$LCPhJlޱa?G@X#Ρ`RVt.1GU@ *e@
:撉 U~Qz7@
Da
A;$P,4"aAHf$`A+RZ`!(2;),!=*@́)$*Q Qq1\O!fpU a3;`3a!=~@RAH& RR$(A;!4a` *; I`3A $a!  !@Q@`R#[AOag ހ% 3:)
E:!2H$qI!a?@7r
2}p4J|qt  H\        `	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ    ր     D[؎pc ЋDZpc+3f  Um L!$F10fPfSfQfRVWfUCES>b^ ukfB  N_  L^   tL^ ÿ tPo 3  t
z!	@@	 !	N_Fa 
f3u 6`< tf3
pY_>` pz_pb>z_N_;Fat{f   3ب tHPtPSQȁ u3Y[XtQ3{ɩ  XܠAf3ۂ  _^fZfYf[fX[fV 3
>a t
	r&afXf^PVW 3W Z_t
r
>T__^P  f&T f.\ 1f`f&T f .\ft'"$Ot..\<xu<\ܰ޻μ̯۾ݷاЮDD(|*8?)/,O-o./0n2!3AA$$~"m!d3A@65[0@?88$y$$$:$A5 s9WIr<90`6`>6<;;?5'Ya@25 @4A7	I!!\562A6>>>d9(F)))**LLH4B$H~B'8y8TF  >""ZFD=d05JL#m<L` =6E8hxL"J'yI><L=2
_
	A"SDx48 A8 0 p[4W	

>;Q$$D4@X>4N6((DD@=d9E ?A< 5
)HPRs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜cInIڍ׌߃OsJ\gpjځBȉymFGłrݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEьԐUiTivǗ؊qlӔC~t`N֖ؑ{pKWoYgȏlϏ[Ďx=b ͇  @  p0 ` 8 	iQ 1 @GP ?TDR2
 Pa Ǌ1!!#"& pԇ~|Շ  Pvщepg?   7 ! ^ )f@aÜp z0 `)i`T   `00p &7yBF?LXp0>z劈 27<2f03Z^`?08Ԥ刈S4T|   UP W F >"6>O9a' p9?~!Bc""!B'  /!B#b&2 CA`   tLwXC>p1_@@@ad00`Bft,0<`F爠00` އYpC !M2F q0 XD 
	p0 P $&# A8_ o Q| D~D D<Q B f<,$$0$l=C  1ƀ@ڀ?3``?"#!! @@ `â 	4 80	  6 aP1pp<Ű2P!3pDr`@PA`@\D2"##57A RPq[2Q8A|q %rm?  20`aa A 1$Q$$PyH {HHKxď d $p@@ 0!c $2&f# 0;xxMƠqxpMAGTbE@@@`)X0$x|pTT T8ZS0
 !_x1q0 b$3@$484(d(lD&1< ?! ?&!<? !!# f4cč!k,c?Ї|q0 X2ٶp!ü,4 T$9`0p6 " @t$Bc' a}"""A pp dQIi&0oP@st
`֚@^@  X#2Bb"6T$-`0`|Ppx3@@`0 p@ 0D)d90|s12m|%o38"5U QHU' &Pa! 3?!   =!4!3#CաO2b2c?1`		
	21"`na9$i$	$	55"33ac.FP?h8CI0#P;!"*220Hi)""?"!==0!'  <p$P$%)*$ $ ' @,!## (ށ$ `\7 ga×#16 < ~ < E  <$$$= ??d)),?4+fIa'0@p6( g}Kq6 )*Tp`(r'@0`R  <ƀ <!S=$T<0b64~
w*VhHWg=  ~  < {D=<$Z@-05'p'֔D]@
wp@aѸsD 
8h: 8pa2Њч 2oDRD2ht ""z}"ci""s2A0 "`@m
D
lb<,d,0%}IHTt(ь@(DPp 0
 .:23Vj& x S6^]y2/ x; `3NDAg pi2"Ri` @"4m0p`4ࢿ :I7>
|sp^D ƃX̏ HЊ0R{D 6bpS `o$$/A1 FD @@1#f1~(3H2~RHH~HH   9 "} 8F :8R)C)E+D:<`~""6L@6q"c  2"&	$  c2q}pf"bʇ
pv;? e $o@֕pĳՁ
rP?BF0L :Bm?$&""k  0p	  x q֤	#`4 cpu}PӶPpP? Cс
r(@p?@@DDD D0!ca0@7P u!DL|(0<
Á=tȱ>s=@4 20i#!e0 ` @5?!#3"$$00!?0!#! ! ?;y@PwL7@ }H4`xb2C"cy@Ch]ՠ8x	< }ia@g( (@@9/f56:Ҡ?錐z2wj8l
>b њ&:3
2b2  1#n }@@~#$a`F$?Z%Dh|  1    ` $0K {  p "r1~&#0 א` wLp1 ?c ݟ0

P`8Ǡ߀`X `g9cngIňa0S%b8Ga a  pRR2R2RRBb.I4dᴰ8e Â=R)Da2
 PekbPG?Da,=%$>ÇWHP06iS|D2D"DvDTDD6 #W aBu`bXxS G   ĀPZBz(_=_4Q`8	  6 P>;5 ЊL D`[Bf$,892k&	ap I" 1pxPX?	 qX3"&,0xP:#q_D
v_<x  pCjiA~k8|	(9H ;)*;*$*%+8TT5Vd7Rp3a6؂6~5uk{s pQO`0`: `v`0Ca$Äu @I i~p*H!K6cPdтC 8x ?~!B>c% #"@&%&b0(0oA(a8]u0"***" /"$'$&*"$" @? Z?0` R?~$BdB//B
BB~1"&D$(-pyZ22,!qG#ihh:bA )*S~S [P=I H<H$H$I$=" ǉ?;80O>@"@">#"D"l>("8""8>(l6c0`` @J@?4R$zea~pUS R PR `py?0 ;6~"~PE-.b҇aaPz! 3 ?$$$$5d$Dd < ~ `K [T $D$=0JC7WO0Y`/$y,(80d(lqD?  /"?(/(/(hOX CrX-`sycYRz!fR`l	 i?F#g@Z@caOtaQ{Qc0#y`(00 a?$`U?			?R" NE-5|!?Rcqc 1D= D~ = @Lk< %L8= @|D< !!"!"="0""?;@vBF\p8@h1@ApCb>HHHd,$|$$$TdTDT8l- &2`&f!Bb62~Z*\*jI0 56`x apv H0	  y 	w 	@| 	
lcé$#~''-D(((pCzsxB0  \ B F>lxPXHL0F`C2j0`aǠ0  0b64~
**hHAۉ\$lH UIHUH~HHQHU~{HA6ЌCE!wN8 2,b)) ?()()~?H!!!aGE]'40g zcs" F70G#`x-(p= 9P ♐<$'~l" ">A&>>" "&"cb@	"00P G@`` x7. PJR]?"#
 1px2H|  8p0 S#Q8#e4GH8<
%SG?  > "~&%,?(l)$`2:-?Qp2!;VRw!q# A] ߇=ab>?rZ $ '$!$34, g A>w??$`1bp "**~*Bb~?B$fáaBFD0@ @`@@}>""p>bB oa5?~w
(L(L.I.gCOwgи$}8@Tll$5?b5dk>^qcCYrZaxA	(	)	) ( )H	p@{c 5P|Pax1RW<?~""2&4?60baÀ`#&&~Phdqbࠆ084c 0q$@&bBO6  |@<  #<B<;/.s `
x@V;RF-h8; 	 `p1`|3"f- |Aobo@Acp>bp@$	,	(	88(2l"Faf3sgPgbgŖ`'$@t~ c3
D(z

0
@u}~}Pc<4 7  p }#"4&0PPc`?@   R\! uUpc_u0PU0P0PU0	P0PP../S./JZ /  [<u./ `uVʊ8r
8s8t>8t: t3-v(8r*<rw./` a2 PO e RV^Ztu`R\ts 2ǡp	G
aO sENjPW1 wts2q1	q 
<
t<
tD<tY<tw P@?  VP L t	| tL^ft PDΐXMct	f¹/ rus 2 󥪪
.>/u .R  `.ߎ/& u2CQ2P Y*2Ȱ&߃P! aqRDr
././PSR  && Z[X  ǇO
"΀#%.6@/F&eF&
P(.#~(WtOt)_%r-**+g#QR.6/ʊƳP ZY[XR1  12c23OsP2`5sP
Xs6<r<<r  /  /.&p#b'4u' /3ūQ9*a01B/;.>@/P2@<Xw2P <1<$CFa0PQRW &j_ZYX. 2.98t./ur=;cߊDP9<u<@û<F<@<F<F<F<F<ޠF<F}<@<F<F.>/ t`83ػ@ ./G./?F/Op0CMM././@N L "O0..B/.D/Q"L;P"  XLzkTTXd  WV>~	@X
> tj6h-_t!j^Z^؃&  hEqYjFqZ^;[T"\\[9"\>\["\I\^1\o\[RcbqZ^%  = h[Rc?^\@[Rc#e/f|Rc$\\_RcJqZf\fff[5RcNrZ^^p[~Rc\%1j% Q[Yf>T_!XNj_mdn$sVqtj`m
v2wUK\\2wmK^ non[X2wAx{?|[.2wa{xs
2wDZ{	?1\E{OrCx{u[rHpĊ[qZ[{rSpb"sWrUpvypۇ_.r[tZ[jrgvZ[1\iLp[a^ uZ% = u	^1  ^t9jU9\^bZdeab^VjQN_$跁Eafh  L[6a`t,>tjh_fjhIR>.~t%j h.W1qt2>Ha tQHafhᡝ3Nb tm+Nbsʥk1f3f
 ~f PFPhghb"ЬXh|3FPHY= t#h_蕴h V`_ѯPc V#௰a&"h~aBƀ)"ѯFyuXҰ>c>cѯJhAԴ=!]^ٶK^ѯPRQh\7Fp@Ьjh!!q~ahac Pc)I~bh^Yӱ^!VOY0+u%hٖ0aíO V1!E0pR*hDW[h4Ɂ!A?0șJэd)ҍjA^_   Va^F FPL <tPvVFF~r~ڌы F FIuPێF&L,^ڀF*+҉FVb+;u;ub% ;Fu	;VábVG2 A9Q9b% A
Ð**	K
ÁWV~FF&8uًǌ@8t
rￋƋ*
0ψFEDNuaِo W'Y߈Ffj hp)~{ fpwfb!n &\߃&^jLfPc  tjPۘPQYj FPqO
@GdF, AWV!P[YV=ut_ wVߊ`#@aGF| ֋ 
0u2|u|qht h & q F? GP qFNuFG		^'S 	/7Y
	Ot'S<At	Yq[+W^ !F[1;2e 1 ![1v>[1JvI3Uvo[f3vb[I1Aj_ v?[%3@v#[v$Y2&^% 9[$ u`/^@![$ (^^'`[k$
2&\% +1\1\jRcK$0<wup3rh-_".,3/h-K".rAa-^1pj".a3"!3@	4A".35`3j	4a".a3304't%/+,_,_jD".d~a3	2&%U4E".D<c=4C".$35#3	4H".a31%=54N".E3	4g".Ds351P4jitD+34rE jS".vFc=@4U".VFc=4\".6FP=-_% 1<![[DRGIG3p+V:,_^ &,_^ jT ;!,_Z&X@큠UWq mVPPW ڠ
\@f\ttk!EJ",[Vpr ?0y;V1\0>a1_qPPpkû  Z^ČF&&gۃ&`&v` &pf_&_rHaB N[bRh6`hV4i_h.4jh.hhcjmL]Q¦!D$t_@oO uI t
v` _` pAqq use t rPf@`Ppo0tQ V*ooK2pEppoW`@qAqqU@rXstat=tb{t^4e}O_ud&o ~po"ZgY__$ZahhJ&ҁ0i(ҁz0j&N_b^cQVjIA9s1Vg~CWj#S/	
*ŀ vf&b &bu-&C#&C&CWgb̀0ZahJ `3(MZ^3!$ [`&`3vb,Q.Z	_ ~a 0B>l2B^D[؃	s$2`&^~^^r3mtDqupo` :R`qJ5@B:SFBC BVgpуBCٱ`$ < u.!@<@k3<1 Q	0Z\S22b4nAſac6ZջjrӐazV@O cF^Nr'~#tP u^  1 %  	p\d",MVAF  jRǪK1дF	   =v3+QOY0ÐǠPcvB^th h ۋټ٠R6彋v/Og9F j ~@hhpM5aAډ1^	  ~u+}ҠFV vƂ F~ r~wttuFpfv
V,ӽPIuuSI  [t
Ӂ0@	 ^BzA~ f AۤFB F~P|Pv^ KF NqٍFFV~  tH Q!Z
cFFV`m
cP ĉvFWĳ~
j
!Z㊠`m
^F&? u!Z^v葱?!Z_S|
ķ^R\SV!Zx^vͿamxN	N!F5,avampF!ZbFFPj"b^&/GFPv4amFbFD[/@P !Z_oP1_qZP8Z&@p6AΊFp~2|FtFʒW^
~	¸' _P@}w ՋF".tQC ?~ t;]FҔԓ~ z u WV~~ŋN^bs! ^_s"j(ѹl`
"

[ , Ԕ(|WVvԋNУ?ԠV ҃~(|W~B:_~@u"¸{}HъBF&W-} ^' J.o0P!u
  PD%˖&t
	z&_#$~%F*@
%}&
/(O)d*.*</UWVv<~p5F
&GF!5w5&p
V~ߋʋv5^5F}GIu4^&^&8t e^^}q0GF>N }-A@ ~ߋs ANFN9`;u0B770>D<3ɋFpAFC&!5 BffF ~Ћs ^BFp ~?ѥBHb7ЬeDCVVlEGV~^9&F%I6&{XaYW\F"]Q2^%W^\"]_URSS>"]̱TWRSSI"]UsVRSSo"]UsVRSSb"]uT= ]pS S?RQTsVCS@S#R4[URSS$RT2&^% %Y9RT*CUSRcRZ\Z+10f1\j_R!Vc31ff`Rgg
2&_\% fKRgxc2Sf^1^jRg[ek@YlARg;eXlYlaRgcRZl0Xl;3T,_RU,_jDRgg	2&bhlERgSu*uhlCRgQu`*lYlHRg~Quqb*uhlNRg_SyVlYlSRg?Suu@hlURgSujuhl[Rg0^3AU+s1ljgQ!VA@n'i҄A1dlvl-_t j^Rg3@p&&,_^ ?_ߖDQҚ
ٝszX$
)>ʢ#ye	/G" ޠ>j6h0^j^^؃ c1jF^bèէb>èէgbIè릪Nzboèէ5b?è@էb#^,` է0^ݱjbѱ\è էj$z9y{f\ffflV`
h1Kf^ ocqAR!Va~U$҄UD	/ǍUE?lC©!VGH^lĊl&=N$ءlUQϋۿۇڊ5qS$ B_"ǹbխ[ lbg*lbi8laaըcFMP+
AQjh!#i" WVv!ދ~ &F<t<
br$F*;?\}7ޑE⿀~tQF&8tF|<r[2d4VD^Eu	A(|Ð@7 ~pNPfh#  F0^OF;rFf?*FH F*N*ȁ vFܨߊP`0^5Qv0
u+a^F @9 FOuH
r7яfa&a&>aW tPGaP`[ 5`dt
72LU A6 &bDR2 % Nu"b$<!2b%fb1bNuFQ= ~P :ZSP+ɉN3b33 еP u*b$<rPePARZb% ~	u$& ?u|t!pf2p
% WN	 p
`uUtIpw 0
u6c
V!u*#1ҰFO"aaa aa	aaa
aaa
aaaaWOcvFf^ ^ ,o_` Z E&gHf~ t3 f&^Ft~u}uO6! t t  tиu^t?!Q"p u"	P `$uS$$fh6h0^à7Xa,=G f*/ a+f+FF9DZujzRP0- DZF  vB F~2|<1~rƿF  p11uF_FD[
2{~a2jxY1.0EV@DZFRv葰.F@/b*J* -NzQϋ'45V#1FF@0|Fطf=-PI7h 0889i"2
2G3F܊f`-he1<<9 AbF֊f -t@ t؉Fh SAvv`h 1ލD~S s}u߶P"MGmuFh=h{( @A`߿h DFފfPAƊFf -jy@<_K9ŔAƢ: 10F1F2F3F4F5F6F7p18F9FAFBFCFDFEFF~Ƌvƹq;؊GFơUދNB }s@XFNG&F;u Y& 2N46h`sa[Pjo2m*@C
- i-`[0C NVT\`V|<a劆2N_$0Tdd*e*e!eˡ qd$6!ej)Qad_x
3iie_d1j߾bPf\im% ;]01]1u^- t*-} t9_00Z_R1r3_2rf]_ArZp/[&c\_ku!5LÈ1xFo ^io^_3wrZAoko ]c]~`GE31xbP 3|
/}VFV+PR ԈddWN_hyyqd$$2P%^bHln2ι\\10mjLFPQt Hj9)iSiEBjj&j1a_]pBsvWV3 WT^&@RFG|3]ő bҐR& FWr֒I Rbr]BPW>T_߸ _\\6 6 &= P_ Ft l]a㜅]o+
]
0u	2 =6Ĵ &&TAV0S~ t'j@F cI t/ ?u#'jQJ\t=7 tA]às`u`ul &l X^2tIKRbrbj P\R0`a -_tV2tC^]`^3pу+1^1p %3 A0`p	bX_bm`Pc`1a0aab_{\@\Q\R_UQ͡AU¿1ùp_qİıŲcŃ>u[h h:wDhpJ{C˚˯p*˵pZpjpzzpˊsˁBtzp˺g˽pZ^pMp˯@zWl
 Y)%PN۴ۻR\<ZF&? t5` (u%&|Ru)u&DPƋV@p.˽JFFb 3"^^fjfh 
  	{   ~G~ u &^  MH>"^ 葿tfj j 0@j3= H/=
td-
t]-! - ; - @ o= M -  -  -  NڀS  5 ۋ  &9w&E!U 6  VV"0` 6?KG#  9~ߡ H bA;^ 
f06>0~v``pv&@u? @{-^ 1; P 14vĴ І3wwuk 
 裏nZtP	JZP nb SvV>ͽRv  vVL*F^ pʰ
% 
PpB h
}h  !NaF
+F@NF !vvo0`	FJZNVF@֢j q4#FPNQ= '*PaJPVW  А 3_^ P	SJZ%q p
܃qF`h
FJZQvPfF
n_;F|aP	F@P]p!qVv0?! N ~%Ft&@&H&'A12u9F@P@CFPFPP@G @C̴{t,F"!FC PgFA0ru
@C
fB#Pĝ`5 P"3 	* ^@]B~9v5'VɁ&@C722F77Ɗ*䱯 u8U  P$ߋVn]Za>  tur3NFQ | N`&8tG vNߋًC؉^GF
&Ft^CGD@]>tp@#A
A뎐V^% = @ʃ@A3t ? Cߋߊ@aKA~aws> u~s3ı@&!P*;tAmrLR*_`?0
0ND]R t=>@]?F
t"Ut"B`fob
VuO"&BӀB>?Vu	C(USVhW$XWS!! 5(YrVC\u%`(lQU3'p^a5&dD%RP3>>!bXZ4D[@DtNE@D@2@D !d	qd20=FZPHf> tOADuI`gp3+Ȁh; ~
 ~IFZi~Tjj~Tn`jMBguBDiu~ SLZɽi}#rj}Doo}.Pl>FZ }q "`j}wFZrm_~&Hjjsaks~1.%H`l*Rs oso@vQpvpv`qHqx brHZ}HZf9Fuf9Ft46HZ6FZ{qLZLrFZsH@~M4 lqO 0LZ0zPZNZ·r-» 1ûFvs  @	r ·2 ~ tQQEBVA1a pFy;uP6E@i ;vЇu_39> ~@ ቎>Z`(*HF\&79F@!;F|Ў~
G;|ǋv`8 T>#  T>J`q
bFof&GW&G{Pu`F&M*+ȉNȿ&Eb|&}17tO&V,F>&:t~P}
AFF@Au񑕰6u ,c} Dc~V 9Ԟ*;}Ѡ`~2u̐3&8MtËF 0Nu\4tك *G;0B^|,Dt3696tVo99> 90>
ԞP7 3c
^&9O ~mV&&A^ߊF怼AFtIPu'9Nu"^*& P ж"|0AGpbv?
`uc   iF+F-   `FQ.3S𹄺0	7((ü b2^ PFP |31FFr`.r Ӽ.r³,q01=kFPи+ɉFN+ف H&wwfFf  G~VTȡ &|"ː~38tC_8 u&N3ɡV~^
AF )G
uSN3~(~ϋ`umӊR~ F;|ŐQ~`rRf@VNV%v<%tF0u DDF
0N$`ٰوF
EB/
QVFVp1tQЂ&;v~ .^F&uᗋF8WW"ˑ}  P~+΋8sg$xv"P~N&8 uN&= t1@S${fh  Z_fh A	覐9ܽf?6 !IQ XCc/N`" j }Mv~pWV@Zj` 3 ?~Bv j&ğ0:f!;~0Nu `&F*@ I{`PZ^VҰ?1aPE* ~ p~h3ҋ WQot4bPvB"_P"GW_ 9** PcP9Fu
P*`UP vv.Q	9[V,`nRFz}+F- P`9Q`JP$Ra Q {FVOa0 a3R \AFpEP!D/A"ְjB0Qofh=qRj0pP!29Аu	fOj!`a,t}OQ`I !~ PT #=7R F+P+4jsyPxH!ojt)z]b RPH Qt)+"`"WVf!+`qS eѐF`E+FFFPɀS3
)qS3)
P6R/	@pDPX_Q[q@{Q8Q35R+F+1Dp327)t6`:둞o6@P="$U8BEB9+!:S3< M*A`Rv3)V`?qAV3DEEAgGBP@F;v6P$?qmA@R/%UAEB!;:QSHP 3=n+6THP!OV輜-=&\&":4h!;tY!;} @R3DRB1PDTѓ3aǉFF~
`h:;&Fި@u[]Ft!F; VA][i \[&@tE];v}wvQGF;FBr+F-}	 FF&Ev;v~ a}~ \o;FaFC]RQ3} t~0ZVgZ~[P[tOsC\G\0
t/* ߂\F9F}\] ;F~a~~ 'y+sFb;`b%q&L
rDFF@ss+s@W) , W5@W	P@PF.@UEZڑw%
1xRg|px\hF44!`5i&^jv`awvFv'!d[P]R~i sl\t~
w+Fb;FHfh 1x^ teDĆTm6kq0\9~w ZDnaF ,a+Fg1xa@ 6,AԐ&O c+σQ.+`е@`Qtj[!BF#"k\Qj]h< 0B~vQPw=HmQn~Q"&`̀of
b0>
bbj Ww 
Ht8-t-9t- 	t "{fR ;1	 qYF~ tf
bF"  F
Pj q ΋v
 iPj q]PpHPV=

&wPP^tps 6^-/桯 }~ h	VV,QF
tF
u% "quP^0ᆁDV6 { tDu0ې3AҋǠA_؋^G@~ 蓣^D@@W*sHڑv)^ 9>u	 ]OROG[RkQ`Ou(+Huu@utj	jfh%Q[ÒP oѕbP1f~
 t

ZQ5£2@ݢ;ۋE`XU!-xw5Iv1Fzh DVV lvvU^@~ hω68 ؍]MS2Ŝ (1`F0L@]닮1ōF ˔ dE1a
*IGv$1řaH8O]2d ~q}Ǡ栬,Kt߄僀PM,E*?FFPIFGҀd 
@Y; V;NdNNQPuc_ a pz 3= K = ; --߄--@{PcW
1݈F `0 >nb@{ 0aly;v1׀;vFPVW`F ~F lG;~~אd - D- *{-@{#- @{"Se= Pk'K-5S. GS@6-  ; FS?tU`tP{P ll~_9Fu
VVIIVF>I9vu@0N l0fYNNbF ~9~ Z;pV 9vuT,< uN D빋v0@	 3& `Bߎ @x	 a/VN;Ћ Zu退@	xa^F;~mTa@X S	4~Du6nbr	;|t!N;v}O;@e]AY6VRޱ#~ u DFA!Dpl9v|G;' n ZZ9F| ׉~^&+^& bプF"!@Fb2`hT.BVt ;tt D0D3ff4WhgP
nr7P((h7G)(*v*0WV .c ` tN@2/@/V//^v/`0'f/U/>//F/np(`u(}1x;F~4o1xZ)arջN@uO6]p+.45#55'6u6n7.0
7p;>_ u)>~a tV>>c t^0>>^ tf-{_Ж蔹 Wh(%mh0A ,Au2jh\hRZ0x
j(hahdZEDDZBDC`hZBDh^hZEGGZszEGGZcEG=GZSADcC[RZCEDdKayEDKaiEFK`YEGK^IEGK^9zEGK^)EG=K^CK2(=z+mt)͚,^_= Ht.- t'PctF-4tcHt- t4/Q#Hjho`t1t߰YOZd[`U\*䊇 1upq^*HWv  zPV謀\t 'p&c A//1/12Ȅ1Ret13/hprT`U fj j@PV)WVhkV3j h.	diD@XHtHt#Qmh !^2o p p t^ mP	
޴mF(HtHtHHt$rqo"o utpH uq u qpr&&G< yjhr	G+PrP
GW>Cbz@PzXz u^PGPмv&ƀ P_~Rrj(6 PfPz3"}0>} F~~|`b bxջ~}v 8@b	&8 tb||9GP{u`.  >jу9uf   ^f~ t  ~|֊F1m	KA+~	`C@m	1D	"^ 	EBߋ^P3&~/tS&  v&߀8 u0*C;^|-F; aΐnbQ10^@? tvN~`"߉vpa(׃~ u	nbDFG&9 uԉ~'.~F=/5 X= 9-
 -"P -PLr ;uP< tIf`otsPt[QWV-
tLƽ=0XJ-&C- 	tI- - PX- tNIj*o@"#~D@F	p.f00wt" uNj `i  u
#=$N3~* ^}
}ފ~&8u	F;|`0-Կ 	m P(
`n ߋj\`P7
.ѝ
N_$A *	8fuY_b؋ЛѰtP3Z&GF |F`FP 
t- f3@fU fP`h 7j h4[h[PDB
%þ ѐ3{[ѴF&1 *Ht&= t	N_@ &N_hɀ Ѱ  D
4 O`tL^u	 h2h0
h HuO_tA.	 &	h wAB	ư{
U :pp`1.	 	@
@ Dt5Р	@UΉӀ&	}fR&O_5 aca-"  ~ZF`zPD0
#YQD[PwU"4.w"VFZ^P[^4 dV&VQW,W3FX
qX4A
\oThz_j@!j x^
P
Pp[f?sVbbdWs¿Z¹ [r4N_ t&
d 
E#\U|A)_Z
W$0 e%WP a?ZB
蓀ݘ Q谟`jg pE!D|B@)	HZH0 "GZ%  PɰR^ܔ
/
 $*0߀t
PN^x5bZrt
V`%i4VHv*=	{PF_|- 9t7-
j= Mt%
- KtV-Mt8p01@asHt,HtEHtXHtc* ,2
0&Zg
@Q2 D AAՐ^P,2a0#=#@hu-Ϳ hjah @)LsL#~RճA֔Ҥ% [ǐb=L#1 l
-cZN_  Vfhh ڐ\t&r
`)d_r
@!2Qzs2o3zS3!2Us22S3!2Us22S3 !2s22
@N_Zp
@ƀc
;r%\#VP-+tpt#'XKt
- t
uA#`b'/PU
0$4%أ &+f&Ð93Pf1 ]P
C"BŐz" +^ AG !' .? M0߫  Ht 2#!`#&"`#P(%(RɴВh
h 2ҹԐcDuʽ uS 1T;t&Zsc,!!
gs.3XV/QX
Q;;Bt$[0[\ǡT[U'[:yz^ iG] `e` `b$[P `e`bA$[ `*e`b $[ `z^ bUc`Qe`@bUi`0e`Ubi`Ub`U^i`V`i	`ѡpV[t&8?8pgpPKi  `pu2PS|dui
/MlXLFx&30=	 &.*8Fr¨^q^1`!A `A!bA"d$U[p$ &T[c#fA  zA@ Aum҄tfq_T[ 2 1C<&U[5p p1r"auGĎUP/fT[f^0Wfhq  60p1 2f^fT[&^"sPs
@Ót@P3ԕ   `3 2@((@% = $ 
u
0u`-8u5u,tu#ԗu4uԛu&<2 P^>rh`cv!Vh #WV]BPZ[HtHt$Ht-LX^+`!̡bd
쒪gZ)
7聨^'@lЮ5QܠЮ5~QgPnЮ5QgЮ`5ޱg0pЮ>@0$f+fFܾF F F FKF@^ ~D>== PI  - -tR!v   - -*t:- ߐ=>+- HM pM-KLpMt]}LxÁ4Ht/HtG:H?6ʌ 2(!ҫ1ʠ"ʀ#R1`3-0pOW!vFmt)*0{VN`ځh\!jA HF*HF=~4 fp0 fF\^vfvvFPvF +u63F~%v슅\ _:uFG;ǏF p^~ t
&H&(H`-(z~ & U08P 08! t׃&@PXÃ@PX@L"H_t)3ãÒ `b¬gqWV& !0 r 3v@Qp1`cX[P^[U~޴09Fhҫa1\qSr
X[`^3h@TB,-9t- 	t _& 
ӻ7fjP0p1s7hIa1gu.ӷ(uh TƐ>[ tu^fhw  `D%F-ѵSX@>~Ӡ2 h=h>rH@Th|ՍFq
3[,\& ~(QF |ןX%PHq >[ uu>`t(q6Z[ӱ@TU ;?!;sq  te3/.\3B
>^ uo	>@ j:#t (3g"t'2^6;B
p1@2 $su$l*utLfhI 퀡%Vi^* ~@()^)PRZ(\_*\,\.-.\w`^Pv.Ѡ& ,_ i3ZA-Ha-Nb0E.`.2萂/,-42-6`-V4c.b.5[/,2- 2-2¬.#9%62-7cE.g.<</ъrkxw Dt,-
t%-.t,-	 tE-
tYtL- t}/LC DNZ[:~ t{C}tD  o"E[q"V`t߀`uD&ْPa`wtHu
s&PsqJ`JSKSLsL@JSKSzLzsL JSK SrLr@r@uty@w;>}`T`TƀԚr}/thrGǀ@(tXҋ6pRFHtHtpE'PQ0҉PXVoWuR^֍FV^tF߬ T&uq*>`>?@B"CCDE1E>uh hD[hohRkkjh.
LG_@tпOo3҉65@w@;R}F.
r݋Ffh<2myj:YkJJk]*<6pf
 ~b@av3ɉNv~FV
tut9v~O@
|~*~f0\^^3
GF&/F	?{Q|u^*ۍF؊F% Fn}vBFVy	NJ;33V~"9tG;|	FCċFBF P~ы3$uG"4!t%6%s}2x@yf<\fffgҭ_F豀t
D̒5ē`<\ t&w^
!L^
DŒ sPGC `J
8|4 m` 𿀊^3߾n
n
tF^&FM!u	ԋό0$[FpzT3EPBѐnG2Ur2^yWy=0=	-tX-  - 9`V = M -at!Qe|-ua߭ c0C= Y.Jdtgqa<\ͻ<\+11>\P- 2&=\%_ 㐁ҳ  ! 3᳀Őj& jh@
t麦% ï0 t
g?_Pa uj{3n
^'G߃Pb厰xCB\񧘦F0\׾b <\ߠ\$@V
&f
Vu
 ^1f
@ys@ϭD
Tz s\ςA|轙L
l@fh
hl2UrUh
>haup
5  O hE&F<tF
hBP
@wF ˭FC|ߊFYny PG^VnF@$:Fv
@Ȑ%u(0"$
F&N
{q*@\1@/֓IP@\B\5D m#,DЖP
@@̒}Dꠚ( SDꥪ(̒)D{!dĊ1DU(	Z!٪ӓU+(&$Ub 1j$	˽ qYj$
qB*q;$rU5$m5ӓ
LJ1+
5

xqba,¨$L,B-
wP«
- Kt Qe00`@}кയ>N^n´,2A@~B\A A^ A A0 A@ `- 2&A띐B^ ( BduB@T#wĀD#-  3+-t`%&%]&%& %&@?jh"ppp,sr w@ A
E*2<þn$1 P6$b ~b^ImFf^f@n!,_ї0Lw0@jtj ї868J,_t&H6!JH8A9`9`8-#99S;A998A9hR9hS;2>9S;A99S;t_& ɨ6
07@^z3!6@t&pfh}jakhKn!Lp8@x9x@;E.N>vfhӆhE
FIaEV!tfh$"#h!P1MϠMM^zIϸ N&IaN6I)'(h&MfIΊN~SxNSfNI,^a+TNS}BNhP#^ >
o &Ҫ68 9 o&RFʸs[7cƀ&9@w@ut;->PraarhNhQY rwF\BZ& *F\Pe1a u$ w1 j hrh>PYg3  t~@ &` .27  	 rj 6F\z`fu.&`B׿jrl`l&&m.rljg0賝àhF l%c\@qcw g Dt,-
t%-.t,-	 tE-
tY- Ht- t/>C D f:>~sZt=x}Zx  諂y!pcbP4aVfPlvfhI
 0Pu 5h 覢؋F&?:tF&<:uFF
*0N&$P/
u!gg2ha@"F ~ uF	 F
  
}
х<  }wv}茄Pjk ^PִP}! qP~@&~ tghPvaf~ tD=y=趩=u=5} 1Ѕ ^3 FPP  q
F9Fr}} ԃQF-
 dv v sd ƨu= wAɐ&2ʋ~b P k㉻ѳq-z ~ t`gF@a  R  F {: . "  
AĊ
~dzPt} ƒۋCs3^ !V .tCau^GCquK  Kp.MI Nr{@~uh( W 㯦 I ۣ(pk|FVaF^ =uF 䆁NⲈ' 䃂ݗ]ÐWV`$ < upFH@@<@uPj`H`?aVbXrR h"hRrcwt10x6P61sH f 0xiEAӼuss4t-u6auUu6xi!v!v9!4dwH\o6E/x w69 y%"x\zDǡbx4&H٦޲YF pgcpg&7 F*yHt
x$ugh$v j@d@uf4赯l;F~QѧѰ*rN@uOphvh$e۞`WV3PWRՃм
Gor@}ԐhېOD   w : MHzKB SIMPLO  MOTOROLA  HP  1.12Adrivelock Computer Setup  <F1=Help> File  System Information  Display ssiSave to floppyDconfigur2 diskette Restore fromH'defaults  IgnBhanges and exit E s withouavingT Securit0Administ or pas?sword Pe aPower-Onw'pR`Device $'d<eDP'$2D1Lvs martCard_pBIOSv supports Embedded@$&		e]
6etac p s Tools BaCalib% th^qlect	b HDDlf-T opAs _Activ@ OStatu d sAdvanceLuag1 l5Dem Q of gray	field 'Boob$x!Presy keyue F10=, ESC=Cl R% %&Accep%=Yes#)No !&, A0$orQ$=M  *e&  UsarrowQ$po highlp/
he approprimenu i1p#<ENTER>} begin!.-follow!. 0`z: -> PSPACE = GNex@-A8BACK8#vioV9TAB8cSHIFT+<;=`%8(V< &8c&A( E.r This^cannb~d An e1E oc r	whF .Ede 0x01 pEeEn21enAtEpCQKrequiHIa 3d!ba.muFmovٰFe@ k/MEUNiDQG1 lqGHIiDiDcple!su(ssfu=lVManu1Or  NRQd&Pro\Ptyp0_spe`twepp9Cacize (L1/L2)0c _ROM R0sRdfamiVdbaoa;Be^se0l nu0	P^Video'g Keyf$rp5ver"BeDP\h
ld@I1Lh2o3p
4LhH0Xkhg_um_wxlefFy@^
lr//|{v
a9gownNkhip(<($Adcngp3? st7wXx O{}ߏmXd̡daUBS)N)<$ 1J2J3IME$JCJVKKK4XT!VJ:D;;/:S;tFWarn :a E`0\`ll0 o$0 13;$Lsq6T$r-ea a/@m,`le!QinPh5t0w@ab!x" A: V wa
qKt0ta^@@@rRBInv0	}悄PieAyouTwaLto  #һtt?-  i_qI   q r1 (Quickcr2 (arehens@3 (S.M.A.R.T.?) Esti 	3exCimPc): 30 3`0g#.&<0%\\ep	p=p1y ho،@Vup""E:fQC'tTݲf-QߞUnkn il6WrȽSesrvReaNdo Fp&!riba: 8JIexe"1  b Al=.  Ol`^ewV`hfy n@EnOOff OPT* @* PE=WroPl6L K\SQ0PNhdAd  W6EN2_L3cp als03L
?SmartCjt51  if12;ly= $]1dS# 3loss `YhouQLn`!3!Qof aaSgo ˰5` "evLsE;Doish$ed?! power-'D#LPBlankA P aP
 H`$f1m0 tv SAl
ѸvPis c4N4POn1
= s. FT
 W34&) ndPk asfunu.ЕrhaPfryaW.Para0k.%Qs S@loot MiP.&2 Fn+F2 uWNl!net P3 0t@TCD-eR06b ؑjJ8Y8384@b_t&]  pUPhi=Q@/ abouhеph8 u*Bq)* botUSER MASTD&)ct,ѻ4@pPUanP`-dcq,E`5~ keep ia#{ocTphysiS`sep`/,R  !\r. Ib rCqDJ,»E>0Xn be  !unMGA
 EDpA 0meh,P D&h0pibty. Ifrd!oTЄA,nѻESC! . 4s[A tSypC"'A' p +MѻF10a`Ade`"rmp =T@
XYH&jQEngl6"2nn Or,:oay@
p ({0rsR~) USBvvc6#w8rvSu`HxZ`#AFir㕠khi@F,th@;if |Six|bh E0|N@ha}Num st6 Swa}pP3/Ctrl! s KD A#nU.Sp"2`p@Adrvlegac00NC肰plsro 0rIn.0<Ж V`%o ? NTSmC <AL2-J#-M/1t ҁBid4&al EPP ECP [1size 32 MB 64A3-  Q%oPn Alwayn gwhi`ACc'2_p2yAg HagZnp p9ϔts )sNCtomنqE +rP4{`92t3{TokRu5p95u50;Unique IdPifM<Bel@?   tu1/ SC-ϯ
0CbNpﴷNPs<o	PDsϼOob mo/OÂBʊ&(H `|@oOȧ/ˁL@t MEU/ڋOځR!v^@/ߧ[pK1 : CVgP% ]m/C&0Ple8$2py0B yf$3I<g*yV /֯ޏy1<`s*~0[l  SppB `@hnology Au @MctwvLFreSxƇu5adap1=7oPXE RPL ExcfoPopup De( P0 10  2p
3p
4p
5p
6p
7p
g F{12j5 15
"3"BCgouchpaPrSPNon8<F1=Hilfe> i4in&cZ0fo'zei@$`ufx*jpweic1  KZKguaV &wie,0  0nveiEnu1$ -Ck>,#ignoriep,-dT,J'nt 0[neh(h'p(,5-Set@-Sheitsofunk4AdistN5enn0jt213 u%b(}=nlt-K354 GerteM09-8C-ID бG<-8AX6>N;3tCQxb6rwчsttz # fr BBIOASW6Bi<8gQ(N0/H1vorrA* #I:E"!#z_urckWzAEx2бAkkuQk`(KKQtsgewhlt`aQDD-S/elbss04NPQtivc( ! T1pQqZSsdSSpZPryw01RSpra\aSS1n9`3BZgran Feldsrt-OUk`/8A9UKc=t0PYilinejlieb!_Ti,q ~ Cfah5 =A], ES_C=AbbhAAiW2\jBikzeUq(jPiJamN8" m, JP-g=MehPm Ve\1)fz~M'arkwVs`j1SMenU d~fPfeiltgĠm(d8faw 7gabew"hmIV@VaO(.sfol #pqn  tc(fE|:-> 
r LeHx = NcahA7"t<-R1Pchritt-qpVo&!_/>Tabul2vs_ Holels+ogeBv0o!= h'*2Escvh'lb>irR[ kan*Qt we OeiVRDp2f_^rge[trn.c
 0PAV@'(fi0)t ^ 	kљCTFPDawϘfWsel2omvorgDer  !lRQ]VDWeskpU-\s""Mmu P\@waysSbzw.byMobi _gtz.wRD0K ti)IOo2hRѤX1wlgrq ab`chlos֥0C%-llQzntyp@NrbJRwig0ISaҷKC\- -Gre (L1/L2
kapazit OM-RpsArFami@q ŽV%pf@a@ 3umm G% GrafiksdsXr-Con @<ߣ@h?W1 26_ 3 4-CT1ooȏblink/OԻ vG}#%!@PsiP2ܸ(F@aP #1: a?͟/ _
?_Hٿog~a4
k(rP`P*:P  st|Bzn bis3BG n  6 Y@hE80Ѥ-/WJLDle!#atb@4f2* eiCCPJf  Lk A:VnfB7lL$*gep1A)KfPCgl`He  L   
mN1M!fwirk@by$D]&?/.Sf9, daf(qie1#oay&-T  TW 1 (@npOb$2 (UmfadGArifh¤dau G(Min.): 30UQdcS't .0%-!b$xD$wu O mG Ho`pUp5$-uqCbrpjB: H)hH*ė1UnbeaG311rvo-5L p>)Q.0CܐI3hafъAttribupID4m5Cuj Y.M.A.R.T.&>1^j -.#C A[sFE NeuCD+s<@ Dea4V^8wG Yy JaDo@F-t Fal1E2gebUEEF uVd|	 Odmin	{o<MI Dur GGRu>S )  a8@byd|'Ho]A'P_fG.X#@<f0SmaCErxoYZ , GsofQt0 fG wam.s Zu1fAv&`]*tenlust.qb s!n?@LlbsviceZas 0,csCtF`д ahyd gaB]g g PtfaE-c|pc^s k QuickLocmk1jSundarp `rre!MQ3t!,` `G񡱿_`bit qn!chutzf]Fr]@2 ^0?WPE.lsbE!:6n, l ӝ]2mehr!nl$S  Infйot-܊ParjeNDrahtNPx7e "k"; m CD-gFA1st$Q102ߘ03?0 srqQr^:nޓ!mBrive Rwb`1@dn`l@vs 9-sls mSx0unbrYbar. eIPGJ,!bewrms a :USb,Kt nn R𪠈Ae[ Fm, 2v4,  0b&zuPqyn
BQz0h[&-0P0GeiraPlw`ְ+de0BtQantAEٰ'$3WVdda1  Esc-BfG& P+²MviWQF'&'Q@1_C F1A0[Ex:ݝ*Of.gg4 dO7c#D `1r iP1,MuBayܘXfԏ (s (`US!B
r-;r܌rSuarZ[ip 1[2[U3[4[5[6[7[8[9[QNum-FunpGons-et z?B~q4n/StrgsĂ!nt3B1xUEngli`%SAtq@fP-ZegerBiebss2unabhngܚ\wGrafik-ContrQ0:I<!? Prim2:!aVideo-p'o7@n~DxBidireal Gr0 0s g ' L=!jm? ,Rb e2\`Sg -ss@ uEg Rparks0G_ڕf(on)_ <hEt!0?/tp	8To1R`zOo
	 _JصOԙ@aHAIti`aRq]ov؆Gku+O *!  "#%%ea( Kalibv0='+!M!Ok )Ϗ*/!NB<bheQB1/pmDual3/)aE27, -6_;1+2f?4 5>C89B_G= d:O@(:J>KODp9M>KHTra@riff-?) UYOO-X]S#2qL0Eobi ORK)`aUKO[c.d/eUKHR܏hi )l/mgfϏopT[Qr  1 : La!.x "% ]aүwab  8z20xEntlqx xw	}xy~{8z3} sSx}x/
!*`W {{ aE .:\?htsProzor-x utom  Legacy-ff<Radapa>AABootmPz`AExpq-A-Popup (.) Wadau@R_F12 (aZ`u P󰫠"Compropstn <F1=Hjlp>  Fѓ.oplysQVisc(ne Gtil qkonEfr"ʨGpfraMZի r4@gnorndr o`fslu`Q u2t0ȠrϳtneWjkhed AdministowradskoТ3 K$P aAg fo(Pg`XE dd
e{ć.-iL cyP
V=Sm`C`-h 0w lsf  BIOS@Y	W[a`r ?ԁ2
idflsfa *Sksl BPڢr)zd valgpbSP2HDD-selvЈ5t@r oߋD܂R"2? Avanc Spro_g Vl!sPmon@nedt t fel5OJ˄PT/^Tryk p  tas P@t ap=, ESC=AnnulFcGodd?=JaNej9 , A1w=M Brug pГ"e  relemeWnup,Qt<ENTER> e!qet.f 0wAઘ: -> e! MELLEMRUM = N`!z<-TILBAGErQ\	j^TABB!KIFT+
u{!q= Accel^ݠsf'ejl&kdr scodQen. F01no!@pla@2krvvek08i da0峪sr fly s0zènc/MEU2 b^@ uve tbrud5+2T&vpmf\B'2`duc'Qctyp0higpA0@tr cache (L1/L2P*4huko  ROM-famili%ek`fڡF i#Vo8ќs!Qpr-contro"D.S"-ba |s:=Ad&z:@2?AR3B4
:H w
let>FF" =H/?>'1/IN>hjMGat-taPFej蠛R^(Rat)@7RBU3V0E7R /F7RH)[JZ?L\M /]Oa>8Rå sdvar: DwA s0У  alti 2	hold !0o  dQ/P#b-R#ddQ,r k1bGesk#  "r'A:䗣՗Tss'f*(A'(s֗qpUgyldcignRtm  w`ngivH@u ,ovia?? iSK?P궍 T^A(Hur2)3NOmf)Psl@ (> ): 30@R 1 .60% fr {$ud@.2U'PRR0ǉT(ȓa: K@lrU!cS2resrv";TLsXribut: ID/)C=BS.M.A.R.CT.@`(ya.kYNyڣ Be@ft nμDeasU Fra0l hk ev@0(iѫC#shŦ &ﾤZ	&`i0٭ɱ d5gs@#rp .*L@vа> hvPh EtUiÁmectablata. Du bP*u$4!x@$fl0m/>vicehDmЁnİo V YѪÌ΂%  QuickLP""pau07LSsv<m`v`uSNdԵ
b1ut Ρ8Һ . HuGm 
n07),diо28p(ges.pg Ql p`|frard#tdl k@-nappOCd-rom- %Gc3d4$oH n 1@*U234r!7Ho`8:eysuqya rhT,Ar3r DArQ bBRUGER- HOVEDADGANGSKODEN,ʡr. algJC n dQ  opbeAQ/ƾed  oT#;s l4[P  GOu4V@uPa peb4!(n. EG,B# tryPR@+mE eC#2r omrv 'V' pe0	rF10 V8	0
4#4ӫ0-D 6sr4#T0-ѐDk Osrflg9=MultiBay (4M) 5!O) USB-floppynA$c@$<2$supe`nA$zipFt`n0edjp|IFSF  8j#oSy!O NQT-Num "Q-PB\iЯ 7 Fn/CtrQlѡcElk(aGi sk5F= egeenP LU&uPSnPe31m=e|6 Primqg9Video Out Para. TjStr0@=v:huko Bl0`0!d t snr cOompukL=ekh`MmR!2-{ Ud8>pBsty_c!topP3OFq!qbg&"FEth1 pGJOKP	HTo RiKO LONKSLSPEnt$gt id-nurH  cZI[S\^/_
`fO[cKalibϐzOa8ecind!, d?jj!8i. P `!"if8dm ?roKh/qvokl!bu?{cy~|Kho}wlS"ion?op?tߊlHagsώߓdO Kh?/lV!V_i mobuD Q(MEU) dϠKh/Og #ߦ0ߪ LO#m[in 1 : Opla .C\% ]. Wnempt2Afҷx5z_3Geno÷3 *9 O}qΕ_W̶Processor~X Autompa'iBba@  Legacy-free.!=mA8ۡHurtiArtpopupsin}k(sek.Q3 x`@P2au-30*b!ggWe P3p p  Konfiguqd datamas  <F1=Hjelp>6iliin`@jon:7 oms s2iLag6xkT	He0fra6*`/PE. diA@ *k@1ravsluA"h,s
lsprogra/$t Ad ratorpaQIaOpVAP/,UyrsdI sfunku8 6tif2@GWp-UTGn Sm`C@=>& BIOS6/Ipby @EO!4|idTilbakelfab2!Prkty z&d !Evalg
AlA8p0
 Bvt Ak p5@Qus
/Qv3eSprkPlg  $ Dem 
%Pdtelؔ9vz(u (5MT/rykk 11
Q
 =A$, ESC=Avbryd0R0O1eABp@82Ja4Nei c1, x/er=Mpi1  8kY-nepil7ne t.<ENTER> hvdu v J-t. Bruk10;<వ'>:  -> e r MELLOMROM G= NE <-BTILBAsKECrig^DTABC'[HIFT+HFI[= GoP8G`1cF{Gsfe!=FQ unQk`G$Pnop!p p? MRm kjresTvemWdRBWp`#ba\VflysC B3 ]Z
R;a1apB]=vfullR1. bkode 02P6b^Q dut No`blokk-mưdll`tyip hh/igRZh-ga0vTbuff@(L1/L2pMenAgdP;-0gUedeofoT/`!r tSroCuoSp,kobZb	u,os1 _wi 2xҚ3/zҚ4J{h2k
tng {t
tZ}y)u` did EѰ
G("0phx zo{ϐ}h~ oI//J__0ootEksAd b: DCUhslr tidlFhol:UHG@! /he- M D, b0!u1/fD sklb2kPCnn`؆A:ҢQ׫ 9b0reg#6i5ثUgyldigTES BaIƧ^EE!h'TAt bƶ,?/ 8¨ T& ignosAte? + H^T 1 (RP)sclp bj (): 303Tgr .VL0%08bFbstpAvWab: 3Kautb@UkjQESeQ `soxLestт R
SrXTrib`:7 IDC01RRsV S.M.A.R.T.-VAq1 m.  GpUN[kreft nKAv go06Pc Afa@b
kVv0lik3t ݡDuVp @/!
)>$a¨O dZs s0!rm 0p;f
s1!o
    #@wSDʘe@o27p&cin 0@\Z. bakuP/  Xm A
BX#vice.qS
HR lq@&0?߁-*>)llssDllanKrXpa`gphusG L[tr!m!X)#- gir beQ7b'esk[Al &Eq-"/0Ue. ĥ  rBgle !qD?wr p@`: a0E\ptp00frard-޲ParaPllKAqTrdl @'tPk KnapptSz1*   CD-C2R H)oXT:>eBhbvalgt/1/P$ :hxB  bdBRUKER~RHOVED-Twl@Rumu $bQ]d%`d[*A;@beb Uj;$0D +A`#2P  Q 0 mו-va&)f,R ike lÜ/R[ e 8-0È!}7.vԫ spl< a&fl Z b.ťAE?, 1⽐PO-A
H6 D0EA㑽2 4'DALock'=ELeF.4iJb3e::"F@gORNor0&lF]OUreB Mu?ltiBayZוC\ÏVnU()ϝmYZ0USBԫ^e!^%^O ZipkA Aa oum JqatBЩFn/CtrldFe԰gREl<(USA)SPekeen`0!#el(! ^gsroseQ>jsq[	jRpTP"isrrA!Cj0f	 Cj@iPN V¤`QQ0mU2c~XAg s9s/ssty[1OX&txy\ '(v\Ub/|A}<@/} Eth` zx5az5)3ooR
@[_[?bsj /O?]ni0X -tifipbBdc įϚ@y@2m$ l#ibRݠBADܣIE0pl aal PV- Oޞo)// [0~O)oxOo ksp.!} ޞ️)Bnd@?Ͽq3Z mob. ps޾8 o/\ ч9Ŀ++\?[ T
n/: La3.
И% ]!R
fullR2vAm@
e3v~@ igjenBon?Qx*fͱ
  xZO׫ProsvAuu1( z^/uAYU`fwtCi nd .T2 irk T:	FRinkoM<&E (se3xgKaF12-MD6."#gSwepute PhppConfiguraci3 l@omadora <F1=Ayuda> 
rchivoormnl SmapmrksT	Gu .1%`^co flexib >c%	| R=a` s@om'
$o pr~-finidoPo`/"Ȱpad`  Ign
ambios y s͠q
 ' 	gu
 W
bePidad	seSadp7r 
y#AJ$J#icio%'"`^posIiQ(s+3,IcE)f/ G# G	vJ{0s%3.3 Sm0Cpong0n5 BIOS8)O:u8+incorn0qU./>?,^A" 
cP
+fbrP/ HerramiaPoC͉`er`0GH@-D(!TK+Autoprueba/ HDDcQ%KLE 2I P	O?J!BAvanz dioSJ 
tTDem	C")Vamp@co gr@oM(b5o_YM+GZ\Oprim90quiPt3ec9in =T, ESC=?Cancelb!3|bd=Acep .e=SsgN(1d., CFao!Qa=MId B Uq5a8chfbhaEal   aQlemo apropiOl  p pL`<INTRO> 9 pz%XE1q[n.ls@aGdm9< 9[:PEspo o -> ?= Prx`!Retroces!y<-yai\$TABySuWAИMays+S~CX} 0 yg0ddErrWH oQ Q.DHS`9rjo u`AEG. Cd@01Bhay n u1nGRubT/"4 p{iCAs9kVbplH+acopRGniIebook/MEU/`"G8q
qmat`"߉12lOGsple@Qxitosa!pe FaFᢰ	 O!9?til Ti3XpTp{$Vc-lG@'uȥTam+aOm0Vr0`/h (L1/L2pϩiRDvisޡROM mil0f+DrqEN0@ri89l v`1()V r"l
 a TO/EF"nH')R1R2R3R4Canij2(I)RM//Oiz@raB˿Qru>Etiqupurs\Ԓpe-zȁ(bap_3P _?/˯ OJS/g/On TP
sn ! @FAdten :xQ9T{dQuirPQ  %ep&3!. P9re%/&, in ьOscriu-A:;OU @-npaaQl53: Qteg%3vl<usanp<I<	XgvaXre@OC-o(a) 0 eaowllEa?@Tgn?Xg i!l q@oir g/$A%MLPL1_ (Rp-)U)2 (Cf*3 (S.M.A.R.T.) Clcu#tie$XejF( Ns): 30J( pgn oo .ց0%F)b`GF)9 ?x@?ipalU)iArum!*?5R66: C
puc.aN`OS9Fal P pE;D9S_ervofA< t>apoya8L!=atribN:G IDyaapQax@GaU'uBs g,M4.CG1^PWsea!^TGnuevTif``ID0oSM`l$LApagTEdndS!`l74
JG:epavoc4
IpQa0s/JPc LcbHad 0Pe^r!#bPoet i1inhabpoVnW, tnZ 0b"Ҧ i0F]^oPvGs  	Smart}C, asso_1`,  QltyA`Y #[C&Ѧ;!PciCR /BfB pR^gprM2in2N S"SfҐlq3a  olQ`Jrv5kvi y.1o8_n{o  K3ې? OZon`aXU6|&asYy[Zau  QuickLockSuspen Blo0P!$$rCatp D}Sn_eZ	[ef`68n Rmej0! a '7c}yo\. PZrsrtc(c,pod0uF izQ1FuP`a orojoXl@S|mRedZal
mmBocΰ9I}CD-򭧖mE<	$@6d 0/PPH/P0PvjRP6:G0Usio:AXuDkPT  medi|AbDrive~̇`DkUSUARIOdPRINCIPAL`h 0?PI9 Xc1hp   7. An[ >y gup3@lugP!c".   0Tjh|mp:W. E
`tlr Pӯ|,x:9X bcЀvGfiocdegix3pJ1pons[@.qZLj, PAgR ESC. K ,alab@h'榨' PmF10@0Fb ,b:U6SYfPW!4 V h0̓Svh041Espaol aO"}Mu`gBaaPꯟP|ۿPk(V)ޖ ()~ܖUSB`RR#3"!i0 i	 1Su9k"$@Zip#搢me Terc!C@~wSexSppgo OvNotDjl o Num1m@g CO%s Fn/RTcPIngls (EE.UU<,posi0L !H1lmQg3XSdbQeQM"d
 pH?7r'QAc%Coreo Mo:Z~  Bidi0䜡yp6Tammemix d1jti#s-rmu8N cuX1~CA0FA@BrNbook 2pNEWe0gY7os04B;o,
 (si)
oEthet,&

 a/JOJpoTokp3Ringo/O1?!V"2"V"3 I tRJ.ExcGlus@L!>$AH !!PY*1)%8*C0P 4O,
*	NQXQ[cs.x/.0o`hy)i2sh2u D-56/1K2(9O4h5s
b`ۭ* 7?9;B35$o@HIC;K LG<AJ/@JoRCNUFK5MEU S.[/VOWO^YZUp2R]?e _`gcR5[0r1 :frg. oS+% ]np2`npx`vnm\roosCleteo3`n@r@mwou\yGq* }fFq }?E;6W_aajha NA i	utomcbl " Lcy LPAe Arranq1p~pҷy EDD@g᱂(UE	x`(`0PF12%6Ambos TouchP )P@!N u Îaƀv÷  <F1=Ajuda>	r0Info҇0so  o@i aBmPwUrҲRrt` Ozpadr Ign  le sairT
sНssFD
AnaPne0|avre  %d %!qDrrƱġ ǳ?@&h J\e StndRBIOSgĊgظaYA7embuti0􏺘gfb0FePMmas0BAgѝiS $Ӡle"OpuTPϠ(ֆAHDD Ar խ S/tatua0(CMuP@QÌh AvSLionxr	Acamp`cinz0س'lizbhocع<ess0e q6ƞtinu @=`SC=CancelAceXiimN, Qou<r=Mai@q[ Uiz %sc됑ڑ ҃dQ@t o ip3 apr#opÌu0я<ENTER> meJ~0o.rgut` r u3uo:o ->~PAO =gxi3<-oBACKCE0 jaʐ16+TAB6 o4SHIFT+C:A=(ﺬ
+SC2﹬ErG@,`6naЧoS#
Ri. Cdigbܐok 0N@h`p<oi@y `isizч@CA ALOevnsfqR+o notebook/a
HeP~Џm`ڳe2'ڋ
H m xi`)elzbNT  TiP  µV&c 1Чx( {@{) TaXhcache (L1/L20&,am! wROM{visFamlԀ~ /!b/ Pcⴕgsri)F'0o vdeVer4!ror!r !s2Qai897 Q;<#$=<3o?<4OAOl?C'ԉ3EFo:;jFe!bI9/KFir_M9ESti1bXe@bpJz3R#e)F'Y	(%)RS'P OYnZ#[nZ0A^nZ Co`nZ~qDbc+G ef/QORoiLM/l iPokps9<Q2<secunda.g4Advertn: ``F(10P !eʡBc q@c/f,vsium դ gravv6uns)A:
U3ӂA: n foiwpPQE SӂPv6Og۠Q(teg 5a"󶵂퀰ʇvl!͟zI(g ˃TНtezt ejCa P괓,?A$ i?C. ^ƜC#1 (Rp ͑-2o2 (A!ng 3 (S.M.?A.R.T.xPyq۠ 6(~P.): 30ayS.
0%qbsuced#%<)&hostromQ
: Issp8eFalAhkje=rmecl@ @ 1s8- tri2	fѳD0 A"
@exa@s I.áigQEovB5iEf0r0Gaפl0L  H{r&ӝ4irrtrig#ʇQciisQpg `{A6Ad@2 6hasmods$7at!tambdŠ D úeGα=mCard0Qj,P pviHpAsXdfbr0,us  0pnform".0/@  aaȠˢ{2ioOs. I* v a&? Op[2D1rQuickLock0 Suspenso Blo@70ouPv 'S~?׀aub Pe"x0{%b  
Հ6. |n(s>cs impPr9u*2. Pp p@ermetl b'Re1%QwotʣrI&CD-r0O'G$+˅ rR1
2

3?
4 PhTam}e:4usu: Voc`(0um׃dq	utin6 rive V tP~0~USURIO%  MESTRE00& )	3P`T@,xapaz= s. An`v8de- 0@)!bPisP!ұnpҪ 3. N0nvJj ,m!poPA1sbP5	 Sfha.35  Lembre'-se܅v%a`蠖sab U!"PSԈ,!ssione ESC. p%8ppg~clav''@8R9Fg10.e >X"br:GM *ͣ/RG*ugus Oq : Mu?ltibayg
DCJBAKvS(UnАMNr)USB@	R#
SȅzipSPrime[irrcVQAwS0pOv20pN @@ƂcЦ`  ~KʸБa{Qs Fn/CtrlrIIngls (E.U@V`i5sAi0Q&SSh @S_oΡdeo Q1ec`dRVayfafMoH~@|PB`wirYc@0Tahmmemw4dCdOpeP0 fu{ @@  qu2`o0CAy"҅P2KG#er0~g8nergyP1 jsrwQdO~_P?zp{Et0bnetks~ w| ~Ps
3Token Ring ςOŁ?ٌ0ٌԁIdnD 폑 BalSta'tusSAC`!/PD͜@4gemϚ.S𫤕l0C4rrDup %ted?]բ JoߝHWa|AO ?߳?߶3AlPܞQ*U ſɏćDRO/xO[ Et 1:rregr2.c0% ]pH/#le62:  @RnަE3: Re(SM* XԖ !_!K[գ Nme $!=&Tflexvec'ehHEbap`Ye/hk[RriPowpupI Ex8 {Seg{@P"F12(#S_|c1s Varq鮆`a NuPTietokq`tuk <F1=Ohje>d{osWJrjelmtt Nyt jTallen0[levykkee`kdk@on4obP`>%t?
o(unSsg
 OhR muu0 jopLp
atktAvFl$po u P= QurvPisunvojan  asa>@YMri Kynn yp4k! LapAtl$ {tu2!usnu!t_'<-(~+t lyk0ri-ti-BIOS+uki(b.-0aet suo3%(st3u"4tehd@Tyokalu03Ak 7P:o`ei  K$; i7a: sKi`ePvytDp.2O1
t:_=:1n N`?j<ALisKieliHP<|kDeE? harma QlGrkip!"nG  O"$2*%2oJatkiin!GjotN nWpp`e=$E, ESC=Per@YAP"NP=HyvksyR=KyllTEi Q, Jok	u!O=CQ|b4EnuoliOmi`Ub<k@h,`:sisN <ENTER>[ m(tSe0\b7. n ]yq^s seuraavlUZ:! -> i VLINPPIN = "aTs  <-bASKELPALAUT6cEd@	inܖARKAcH4VAIHTO+ghgfi|g1=  S'l!TcTQn;virh0Akkua eP<oi;da.;er: r
di 01rNkapQsP<4 sqaBrtV p@1"ytkeZpGkortaa^s4zsi{qzx.9lakxsP0Wsbkant0dlaajvus`ikk?q Hskeyty[i enwi^(;tu2qnp.AB	o27013EmjQhNi4? tyypp;	nc4'all~Vlimu i (L1/L2M2:@  ROM-Prp!|#)otepercEm@R.{si	sar2(?NdZstohjar~+QusnkohL|1:|2/ W3 W4Kahv2:iooiCke?\[0Zt0!oÜdNo(j0Noa)& ?HΤݹ ۩߻qJ<kro<s:_ Tmal!@atBnh S. J  [t Gluo` p8us-  n,@
irjR5onSΐ!A: LГr3ѠQs	h0d ^uQwsw Rl1{X`s`paA"h?̓gHrko!yAipN6{ʊnA?>{܃ 2ߏ  `?==Q1 (N#23`.M.A.R.{T.Arvid  w (min): 30=="s7 .g0%Nro';Is0HyysQ?i9>j$ăV#"Wssrunt0uKJServ?omoottJLukur!QstuE?ka-nrib tir 0cv Gǰ`a eK:Ӄe@^n .3aYP Uu^%VdPa p P2?aH	?!_	BU UvȀ4$Bs1҉A@P<1H&a -i (!)oanokk@aad an /ndkumysB`:7~@s1)P0, Os z@3ai qv	T79ǐ4@uɥ˯82Bi!.a unqn:рyp@vep:apahtum0t"id%ᡲa!2I5i0"An QuickLock ٗQ  h|Plu G\eJAֲ`qR@!0U8b"E?,^pNra! gJ-\ d8ta.
VsB)dqҀC n15t,<8Pqzq#. p0InfrapuneDRЇ xqDpLLang"{HtoR {r+in  CD- -lz1AK$  1T O2JP3JP4"8P50b
yj SAiot!\Bϥn D e4q(Dt6) -llC?  ?Uek KYTTώJN)A PSeSANAN,0]B ;C+.a] #P><sily`] ;WturlsPwri 0#tpS?u@[rI-),spSUЧxV ]LLA<q0[uud g{:XҜRb)T# ed@`ʲC oD?@0(dbc63,1d>ESC-nS?fvnAt'6W'<xs@en F10xAP)|qaa@Wp:VyS p`1m 6W W Y#A mi
<<ys0TɤMultiBaykv (ѩnϋ䌒) USBRKҏJҏZipDEnsimmx}T<p} Kol4oeljVi-rKneitܠ@dekP$ YKym@-!N;um҃p6VaiZ Fn//Ctrlxma5R0Eng4`(7USAPUs sinlArdP0P$n`)jaP5a Sib%nsQi񤡔`sV-OolhEtGkiostN:a@e AAb Ūuu pPxu7Hprge2-l#V rapd1p;(%߰+1@Ki`1ϰi- Y ?(ylosߺ&ü/Ethere4Ytpw%o%37To Eg ɒ̡o(eworkʳH m	ooyliv,A7 AkkuH6WTG  Dp+jo[libB ?ࣂddGdxNdDualЉ-o	 +ꂉb_ O_O'O_  O+΍'+ꀗv P0
?P	'
eaar@Ok5R _t/Oe /! F$r/O()"#/-J*&[ ae:*vaZA:.=6% ] 45H	72R8 kl0V? pure1og4:<'6M7/={973_8n O 4BD%6M7OEhF|9*@K* AKRrx}PumerIn   SpeedStep  techYogy Autow!I0ٸ#ogacy Free Yg`}bpkp@avuYXèYP`dUysciL` ([e x@pY % }:`]lF12:{Yi PQd%tapp}ilkoske py o mmaМK<^]  Ei mn ConfiguratiAord xteur  <F1=A > FichierPNforp_ cTv`WmSAffdage /eAfSa{uvPSrderjr disqup=ezhla czbKis RoP>r  } V`i'unewi.ljmi(oePalcsp dfauМ/obs dueIgnormodifepqu}cSV`ie lG'inVkae89j=x0regpw
y}~yz SKcuPM_vepss3dcebrPŅpz`e sousOpH=*on. priph8i:a s5LIDvI'+qsWDrZ;ASm qChpa9 BIOS ?gre DAsfazf֟Rtabl8@zspamЀ`w'us0 Ou:zonnfqza bPerieզ slecbn@pe0toBsvnvcA roثEta Bɧfzp]P0 AQcSangP Chois8I³Ind~fmps grPUX𑥪pzdrf E'? Appuyi1n7toupoPik0Vud@[=SVer, ECHAP=A%l M>2AccepyO_0=OuiN Q, N'imqe`yIԿ=`PrSAd  UWPUzrs fheamnr<zqcle vMukcer@npU@ibriVP1y]z1i <ENTREE>C2uczCpDrsuiQFt  1nC :G-> ou BARRE ESPACE = P"Aec-ل0IEPprecede>TABCA:MAJ+_޷@[eŀ!arrc n Ily 1ssib3dicn Ua3s'prodpendPאz. Co'0M1`fucFn`UɅ1 emplaceM_L'J!k Qꁫrepyөꐳ7s"d'accueil dpL#  nitxb!iQ /zepHyp_u Oo2¦S|a ruW FacMP Typc	epcVr /gDb
Taca(L1/L2) VolMޢmoiVe]rbROMP	mBARevPo qfNumro)Fvid00Nrasazclavd`o@!DcA0
p 
3"\4/$\amov1_&z
+,Mga./p)JAbinvpBpri 
7r(te) 6; =#?@?% B_'t(D)
oG3 -OJoK1#2MNoH5/RBVfWekdUe zp!O : CR09e0strus@ie `bi`Pb g^h /azm,M zr̋qnvkrorЂc [3zAa$`BelLv^f !dwtro | Pa'`e`c`v^Td  QO`oa0!dvBta!2zm.0bo 
qk:
f@ 3@rfes-vA084{lp  a@dz ? Ign	o7IiP EnregAe? T1 (rap)2 (coet)@ou` 0rimd5(@)Z30c`s .v0%m vr	" zl'hg"У0"$:Ì!'ƭec nuΗ#d'nvmxoLm supSppjAibQ: IDh!$ex@ӵPs S.M.A.R.TAban] .c !A\2`s`2jYai Vfrxn?1osasAA Ma%rA2  nY@YPas!Ae	 XјcQ/xmme, vKJad@QPphobligatr#ӯ%SBdԼ; պ-s@e	gϻi\ŞS@StCp^u   si0p̃ pӪesr80EZAacmpzala p ZSUforQ. Nuz4Ѫ0 { a-vPuou0|q0:pAsjrS Z4[̳_͐z{@O2ɧCd~#`]Ƚ qs|4 QuickLock1sus! j@St1Ywri`3Sq/Ц[nQreQcd҆x)݀;. L' AҀPg `draє ɄP"3@ra jllx$hj Rssqxfil Boఎ ESCD-XcE6egco p$0&J8\palfJҷ:@z2ףg_Z 0Dr 1. SϣЂмdez \deux(UTILISATEUR1PRINCIP?AL),  #g0alors   Nz@j
1PY`1qxpsr fe`rceluR i$ordinCu7. AuPv.A 	q
 Ӹ
Met Ӹ9+	"ڄ1VfQP: t@Y@ahsĤap`abt upjӽhf, appuyPu  & E?CHAP. "_, p,p|1z"'f', pui
c-r-T.F10TapPux2R~rmf"31"e7,% ~!Franaa3	O0odlsMultiBayjI|I?@R(POCoDET) sUnAjUSB
hpJJZipJoPremШ DiRXTTsBOQu9aQXCinpQXSixi  Se0Q HCRNeuvCODQQXMo<jA num`(>ΠermS.s Fn/Ctr0Cz# =Angl=	SA) PphഀtoQm@Ћs Arn=cechnAZJiadR elNtrz0Ef@Ah)[ڿ^`Დn`rimaQdtbi|id08bTZBidxA^P5 mmedQ`OsdVq&l÷&jPrʠxP'R : _ruf@2Gblo'c-n
Ga1q_a\ koF@1 nqon/t@(О!ur)Gccue@!vwOxgyBn/ EthQbtcy ~~op-Tok Ring/ʄل``uupIdq&Apb<u\k|e0a=ߑk oFU\l ^nQreQ
?Abs1f5G'FzDu@/ʛ? _ߞߨr@b?_ 
/ϹoZgn/?O_e E I
exD* ǿ_?_ mAIدݏ/[pe 1 : Cm.p=% ]A=pVjg2Dsm@G
*3R\K)N*   _} ]̯_~xNumro"#roceP Auto%`JAJ4erAdlibLegacy Amor1?c )p)Ӎ%bd Retar9d"Eexp)@YP') DY4F12
Apos]fZiK1ux Va0ktj"f '·ZAcun I$ (@\z^el'aV <F1=Aip>@nfo$W!\emal@p{wVSalva+l floppy@U8D!0J FttoVRipltina ddOhqifa@|
!iISUIgnor9d.ed esci E@&al'izPp>9%O%i*&Pltup cic8zza^Psswo	e&am0\rato c`9./g.pkcc0;23-,!J
vo;4s6sxV7pQr IDs80pT:W.DriveLock*4@e<f.S`EtC	 cupo0@ BICOS==@6!bg/avPi8F7G) bi8#ctruki Ckb
b3aN1NPl3leQaFOpSLQ3`}t"o rigiddAtkaH(RtSSkQlPd/ lob
VP Ava(tdLuPZDiam2WR\A3cak mob e@i(^g!SdQvv`G0o^`Q9jCb9Premi qsia`ktasAerA" u(  =[, ES?C=Annu@XiP@0hi!iA3t	]ei=SiSmNPZtj&,galt@g=Ap2oUj Us+chiav~5 freccP$!h_ih@vA3u ap@Q "#f<INVIO> #h t X('be.rpGegugL3hEy  uny:p -> o SPAZIO = su3ssS  <-}BACK ~CEč~
c`#rxTAB~C"^o҂M?AIUSC+(x= l(قj8cjErr/]GN  QuRhXnn pu &se DHSi  v`%Wu^"8N. Cp%u'^01 Nu@X
a^g&oggiao L 0U0s`#@ 0Nw]Cre@4Vs]OaggaxQvp,pF  n`Rbook}1b A3espa3!h0 09Nroq!wat"QMߏ:2U,*Nriu@&pFJVProdau 0p NT  TiB/VeloiSteppZiMis0caQ,(L1/3L2me 
VR _#ROM FamiglP"d8t eAzṖ_or#ahroll0h#Vr{er?vNOX1/X2oX3/ĆX4ņXhan!d㍤nɳX ˳X/oΗdR3a02$0U Яr*cvep(eh)1$)234T܇o ))з /Hl$7FfondaAOF:tAbso:u7Mgger  ]ph v{5 @1hre(R(/r<T, in !hfavыPbp?i A:URA:Wa1ono@&u`H# Iat&tV Nv0Nd ~ I&O y K SetGBGvo(a	 _"u#?$q) ؑIQ i(vqre?_+PM_( AORUTR1 (RappU)3!2 (Complet"tio }(1): 30^c o .0%1x"1ZB!T$!a1r@3`'h0] P3%49):Ks zQ1+Zg  Uo+pG/P v`7Ӭ/ #	L4!sSAO-Sribr i(gol m::~𓤋fangde  Xr7i S.M.A.R.T."uN.<fAv8s@sh=nuo  BqI2?&D\sX`SHA@ZSAZSi`Z@^bvDd0SAQ@k@%p`ю2@@4aPecJ"uDAm`xSqaG!@8I9O,  P@&Pfut]m@#3ezzaSNS?martCa=T SUS	R Q! 	,dwopuNerdzQQddati &Eff4i]soPin  ca@RFQaMvipae` QLa@rJO"}dsQ}Qs@ickLock@@spen0AB@@\cmous'oMUPQ/UZؠ:@  cgrad
t^oBe _RPe.@X! W{,c$35ari
 liVQ=B6rainfQ,qgRawPl Pulsԙ'o GCD-rcS vt AO ώO@zh= Pp:h=ut!!Ӡ
1a uD:ep. DeH@a  `0bBD'UTENTEPRINCIPALE  rq` a/
a 07manW\fuo. AnPˡPVQk@'@2 P]Pp%Pqa	eqg0f0 F\1(ң0d.0lFPq%uAadQ,Npu, E0 sbq?|re^D. RmqǙpraI@!@fVcc@n`1Q(pJQ.qP@\Ab֙,_m`yro ESGC. aLk3'A<dovaGr08 '֙'po e7F10.pBGZ1Aq+ DI4&Fwz֙0ȴBp>Q&Itp0( lPahaq:ũ MiBay6N () з!i USaBqBa֔Su0rBkR֣ZipRPrimoQa'rz!ڰAO vpD pDDecro q Nu%mJ'Rl`r Fn/Ctrl TrVIngpe (USA)qB iBpuPy1yo mplC 16o @(c5orqpl`&@/C*CڐpDV k.q/Mo0536g BidPgCapa( mem Kq?fQ p#J@| lehT2 N%RPJarmp0energ`1x BDpa4t|(p%al!#s" Eth0et f12_ 3?e Token Ring? /+h%%3 IA\?< 2inatp*hbݠ0ԁ?C`bpRH?  DF AP/  0(IpDu Q $oo#(
' ,O!o"0O%o&O0 5)*49O."o:2<=B?7@A:;awnigpoGK?IO_C DNSG<`#;mo}LVW XQZ[XoU_/` gԏLOcode]gheKb[ ap u:fro .q % ]/pcGomp̃r2pSpo
utqqvser3p`po){uqw|s*@fs A81?+Q,Qi/gl`kOm`uâb !AutomaКFloppy8Ulegacy AadRFѢRa@(sec.)C veeF12 ` 3@䠎*N0ùup <F1=Hjlp>rkiv SyA/infotPps S pkek`iCgu 0stll frn/loh nar}d Annua ndǀ woch@sluUAs b n to
S? Sker d0trsl9o  KAqa`rt-OlA-En ssִ8鶈-IDڶSfROt sdtd fr  BIOSÐbyggd GȐoi|ȣabrikPVerktygs Kf@r vlE" Svt01HDD Akbіus f|0F~@t VljrD`s_ nedt`tlq1G۾8ھTryК ^fri pgo nu1 st0=, ESC=AvbrypaFA@p0a䂭, V*=Mer Ыv pil`!a 0yHԡt<RETUR> om6L"ttq$. eljeuer!  : -> E BLANKSTEG = N`i  <-o FregeQLTTABffKIFT+scLT= w  sfelt gr p 9kπEt h!E upp/stodd7en. Felk01@innsg0Тgplat m krv   h	at0@nQТm  fl]y s t -dr/b ex4˯(ТQ> tidig
2-klTT`kQkNď,PE  P, typhastig gbCa-rlek (L1/L2) MP" ROM2$fami+ljԝk,$snummndeo&Qdلb#yrB F'E 1I.,V-2-23/240a0,-32-%,5.%, 6?84,hg:t.o'	5,vopV.OT ().1:/C0D2n:Sek`rwVarQ! D0   Pkneh0
cskapA 
/-4P1)iPkPbPA:C Kahi WSIRS2Rsky_ddad P
a0gOPWOP! Veo"B8D  թ_2?߫igO?t _frgWTk1nabbBk`f n BUkad k"Jp d (>): 30j0cpa}0%bHpk0l`srppQsvr4raPttP
:JM!wO#krTwSARzervo-7zL Yttribut: ID`
P
`d gr@S.M.A.R.T.- GammЧN0`ififn`4@J LT0!ibtv4 Pp􊄤vlika m`ӓ?W<  rG!ORin  s  @ fun0ӓ @<X/ O@}| om  dFLh4ts,Ja FbsQmClo. g̀RaQ@①glmtjz9h ielse<Pw0resuiҤuk(pN @pjň[,Quicktelge Lp*m HƠ˗ mjliggL0rb3"Ył
-   
Ř@Uko-ihg8bliX2&1arRt{i&P pfP"PpdXQHOTrdt`nappoCD-`%"RrTzxេD[Hrd1[ 
&0&34|@Y HuvupS`փ: D Ma#YQOh4d DPReѱe 5 LŠANV->HUVUDRBYPU4ʀpe``t ǿ.z  (ԡ@kb1qA
Nild frVVQ VȚkaVuh8 gʼ lП
 onGb`v'. -bePmfseЮm ֞ ``.LP  p- 㗼NѲNfѤ`''^ sedtaqqىԐ a:{ͤs哹 @Pn +`:xMPiBay=+ (9BB<mSB&[!  Zip-+FKq Fjt!p<!patKtoN@TNum R汲xVxbFn-/CGtrlr* EPlskt (USAm ܐkd %!}
dskrmspctrUoI3nakk?_PbbelP^"  eo ne Flk aXQo#``g!!S20W-"p˗Agg s0@mhr3"
`C3ݘDvL[, exp`@#,Ned/ O! Eth Я9$QC#&&D&&&`F(ToaR&+(+* uN o,M1.i30!uUnik `nt<6B?:^;tus <>/?? SBI_;YBKalibft@/EB}kC?D/IqyFLDual oHECoKOoFGN SOJV/SMCVZ QGoY_^TD`os]XN`a[5Rd?e_HandtaghlxCOko OfGns/jV#smo-6ZCu w%xoqOyoz$xj }~mԂ|ĂJ[eP, : Lar .Cp% ]PMklar2u 0$:2E3a$zo̕vA*@fC0hD A >]@ûR}r}T9χ<Auto
UÂbr0#݀egacy Free	@"ἀ>sadapĒlвdrj|8snabb2? (sek.F1 4d'BdStyIr!Pcpg9%en Ae `Je?  @5O`t opslaan ConfiguPPo  Vanaf %v_tndaardp sSc9ɼWiojzigneqrogramma 0@5Setup& z1r w8ô)_r¯s°veilbheerswachtwo_aг Aa'atbgD ID'sK`A5Sm C-Oàu2v` BIOS<ܯۏabouwdeW	saTFabrieksugzQ%xtAccuc| ex0 elecp a p s>zelftа-schijkfeA/i0Ac0< D ł<r_ wgn Geacpalaa1lem!`Rrgrijsgemaa 
ve	l0oB2T|
ukp hq | g=S&, ESC=AnnuD`1o0=eOJa	Nee "	fi@,c A1ah=M˼ &HulppijltjаN rui/dpjuiPnukeuz`ark<ENTER> indPRbeȡvol0R   :  -> of SPATIEBALK =<-BACK CEVorigltTABB4<HIFT+uskt=  I`
#nfouDeZkPni{w33ged|! F(vretij߽sV|en. a+co01ҳ(`af0isc$u weP`5etvoe1"re@< dbas* |.t{ n not?ok-pc/!) Ci!1s1p'a, "be Gigd_+,-2'E9д;1)t NU6m-yp~processSnels8sC spp5mD Om`e (L1/L2Gu0capaciROM-Revis0I |!J Herzienb7gavS$brS@s mmÁ{E6KUvideokVpJLtro \M3@pTMM1V2X3Y4[NrB \]N^]JTMM xabn reodTIn`0isMNItifSic.jSe5it !(POdz<)hWop qpY/rqZsqp\uq]owxJTyp d{:ifh+iUs^bSecui0zbL4op: rtC*t as egewf P.bef0ǈ  dq A:g-  /4Ʋ;gDe6).1<off'G 3֐A/d ŢĀJaa΍P/o0gщt0Oe4u a`ⰱ/wilt(?P)aU??Ȑpnh-ZTq1 (C)32G (UKP)PH@b70r8< (.): 30P pE&.v"0%tooB@ 3 ho83bro":)Ke1;nba(c(c@Mvo-	lees(Ç) rԶ.;3Mk:0.;bijαRe S.M.A.R.T.-ġ'Ǳaf7.̳ɠudxؠ0ieCuwxa1j!Blop!!⠮ AP
C P/ )p1A^!+`QkQ 飻n̂4@Nop$ls x V42Eis% ANbpHs̡1` u2N@̀?kelt, Ç6eRq0*  ´21StC -ˡ'A?^,  d@SSցѼ1AeksڝugSze  Sg𣼀@erloR-Z 4.ڝ!U Bbha10<іfBhoudHi 8$p* P  "C d$ gC:Ԟ TQam f b'S_HpfOgA/,R@P*b
r. 	e0Qk`traakP/ANtLQQQbAMP7p:Pfraroodc Par!RTېDdloo`etw Kn| Cd-r7Nl֘GV dWjpYjZjp\HoofdG@+ U#8'via@P!L31i($ lzow`HOOFD-GEBR?UIKERS˃oL  permana	 S2 C(  BRwl##s$ s5 fyQk@GPxĔNcomp -(M&sQANB(Ѯ@t  Č*pKѩڏ5/ . AA#$C,canDlijk 1^1^tG%2, u  laмESC-Q. O`UAю!ANGDF% rD"'F%M'ty0<bHkF10GpT NM@@l c 졘e%9XG2!Ne0l@^!oQ MultiBay'`j_Z6e (}s)\]|p^ USB-g`c`+`Pp-2 EbweHPXYVqЋV.eZespZpA1`Np@tus Num SUFn/CtrlHssegXFen2+hMS<`sappAOKHuм`nbYe2rmlPۄPnrsR0Bkij0V2o-QP3 oFPvdol !vvg
u$pnti0Н pq0@V*pN3 Z2+"ੰie
"8q (b )߃ODEt `!0\0d TbRA ݏݏC Og2X3 URkPPtc8 `ccuםƃh oѠ Sc~aGekal!i"K 5O"`P@oѱualQZ|zOo S܏nZ{z@SϲOd]B]w߷ӭ H@ygpvormq1sz?s\L@^er-MUE-yzO/Ͻ  R!`ozͯɃO  [np 1 : B$!rJo1Q.ְ% ]WpYtoo@2knt 2ֵԿNlןk3ls>֦?Xlן* *  !lﾣ,\`ModhzR`gacysKafAN2tadap4 0EqmV(>>sec.) &pop-ups0 0$	 aO`<F12 	)bb} cursorb07urEasyPoPN-G0:  Rs[^̃ZbgA`viSETUPj <F1=wv> t@C@VXe߀ɿւ\w܂@t`sfB Nɕۑ  ݒ#畜/	>HĂ
f`H g  Hꏟo׎ w<ɖύXɏI e 0AȌԻ܃eATea
'@Lc#ǗW҃p h#d)o oX v#@\̗L/cIDIDz& hu"N ()u&Ao폜Sm@YCy߽ܰ y. BIOS>4/ ߰ࡼ.N$2 #2b`R@co`e̒  OIA9!:n$`e~ g Iv ǇO<o=>&%9 !5:S2; {6@pB-߂F:=u>OJtB!9oI!Asu
>M{&#hN$̂%(L[ 1=:AEsc=?dUÍsVU,W0=ς͂CY`M  aYA 0TRW[iV @J\ #Tgpj~ڂ>ԠQ+g U-[EEt])TuCqψȉ\_Ab:`@Oc->- y#o[ =   <--[BackSpace]i!%j۝[Tabki'Kl[Shift]+m!onm@k/mFq[`Yr  !:G[   9͢;ł;rϒP 0?1 ݡvy@8v UqM7xGɂ?ACO! ڑKv&)bO x!iv;DT}emN+0* -MEU{{Ȃxyoxy2u^`i］у
ɰޯ   ۾ xïݸ  ށiL1w/L2p v`OM`rW>ހ̧ 0޼ޮ'رٔ  3۰ׂްޯ` ްt  ޯب@ا#234> #E
ǘE/E p6Űl(Â)ǨE3~4 yϨ7O "F`i9J_B%x:z"MςƁAAzɩ |͠?Ď |cA/
pg쐬+A:`݉ %BG}T!d $v HĪF w d/ʲĘUC̢vxŋ֎~w dvR2&Oy aXOo  ~B=тH
v @>?>=1iN0*p =2iS3  .M.A.R.Tp  \zsԁij: 30@w .֪0% AA OK z=A=s~@f@2v:?_wewm@QGūT{ǂ4+hT|Nv|sFIDizv.2vau .s EQz)V!oi"cs1& % f >>ZvT[JW|xw!d:W̈́T	Nxasp8
vAC̒v߼$22& Ed6ȆXӃ}҂^h	, ƏO7e8v2Qa'Y |ꍇu-0`@(iIp	 AeƂ HcTг$!d~A?x>!~_"fAD窢N.u .Thh"<.*@80T{{}ER./4!GdA* ی삪I` c 蕴 _wT(犃A!_ ϊOBqAuܰE ? CD-Mi GhD1J2J3J4PU .}^: .QUkOv@-i`%.@ ŧ_JA@;ŀvw
㽠#e]P3;O 7$b v-	AT %@VZ>Ĳ.|J .0Ui	"@[q|q.X͎00eRsf^ߩ痣 Szۊe$@`g%VT $r/XS]V2w1A1iq3mJY@!ߜ|Tg~綂$#ۏ؊ԓUłGlbu͗L "` yǺREX6Swql ӔC
cS{S>@v[Esc]20։p<~QQ(k7É̗DriveLock $t
[F10`@u1A!
`zt  P/jd-{";71O	/C}@`GN: mu
1 x`^kzTbO xqX(iꯜ8ɝUSBaRXqpQ ZipE1ԖW 234U5678910!Numъ Fn/Ctrl̐ 2 2{  p (USA) O|@!BcfPCXRKVʔSSvCC bcg~q Ų,1}bⶻ .r@IolC {W(_o !!T@YbA?O8ڑ͏7̧_s2gȓdoa1oe㯞ŉ8Etherne=E  K̀L̀M?=gqN } ?[џ_3Ԡ	lQoNOРja I+D Pb!  Oo 4풲pJ?P "納sfA /5_| 5 ,H_5 ,n0A/5MEUe	t/% O
__tD?bv1 : [d . % ]R񊮗5 2pp# o$O"v3pģ	)%&*'* .' !.Op@C0@j2oT i oIntel  SpeedStepP technology G
çtPDtB A_POGް  H B,A0x?(b) pfF12@ԁibBH0_r AY^`E`qb}CQBa 1p?H_IJKLM NP?Q_RSTUV WY?Z_[\]^_ `b?c_defgh ik?l_mnopq rt?u_vwxyz {}?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$% &(?)_*+,-. /1?2_34567 8:?;_<=>?@A ` a b c d e f gB, =         <  	 
      
  2G      v            D    (   Z  ) *   - . r / 0 f  $ %   & '     D[A NMA! MA( MA 8D[`D[D["D[(D[ /D[(5D[P;D[xAD[GD[MD[SQBEFʰMPF0FA<BB<A>VAبA0`8l YAv x|ܵvFY|Y|Ap_0pAV>\  V]A0D___ = ~  V=`U$$$<   DDD 0bAOAaƄe  i  o䔕 u _ y AnJAA   EA  IAO} G  U AYANA ~ `' ^    HAy z ~{ [ ] } \ @ ~ 2 V2[1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>Asl(? ) +1l)m#mo'?
p({[)|+}]-q[{]}'@ (#:st4u^p()\|+-qy~ z# {{ |[ }| ~ \ ^ @ ] } `]1m&12"3'4(5-67	_8
90)aAo$qQ'mM(%) +*,wW2,?3;.4:/5!|@ z {zkV"sst+*'7({N|$zk|  c+ao'()+'*/O1l3[OoCp2ؑ
\u()|o@-qcmRn'n -=
^~+]}@`)  ';+(:*[{s\_}\|      \KeD[}PD[& `ЪЪTD[ЫU
`} D[>ЪЪЫArЫڸ
B  9A:A;UB aCVB?A@AAABACA8 1 Юc _D[?^D[R\@R?,aD[bOP}|й
cD[UйPAQAURASATAUAuVA  WAXAZBhAO 6 D[U	ԸPꐹQPUP~P>Pqu#s  ]BU^A_B`AaA}b(D[_RZD[dʎUʐԐސ irO( 
]tkAP]lmn_ 4 ɏA 0AыьA ющ 3 	D[K̔@F10 Setup Image_SETUP  AreGgG 5 1ضқ*ќњۢ:H̟ѝ:ܼѽUղP6!JҲi̳t4I
OTo#B:Ah 4AJA̐l0GAUЦ0AA0gתAAAA۪AABAAnԿo 0J4 0몴華z3 L c^ A	*TնpR!pAB" " c" 2 _D[	ԿUԿ4ԿԿԿ 2 lGrb C
-
/M)0A{CBr"tB	 
  l	    6	789:;<=>?@-@
D[Կ*ԿԿԿԿTԿ Կ%ԿiԿU2ԿAԿhԿmԿ*Կ/Կ0,"Q)	A$0-\ge -2GAh Եh` It4 7@Nu43Z  w0B06g$jй2P ` йdjPN8p0:0:*0:0:0:xjAqzA3[  }AUAAU~%Wդ06  H =XpFbpFhpF|pFpFpFpFpF= HFH^HHHHH԰HH۫=$0K40KN0KZ0Kp0K0K0Kj0K0K0KHM<MVM\MpMMMM֚MMHPP,PNP\PtPPPPRR=S0S<SBSfSSS԰SরS @K0VB0Vd0V0V0V0Vܾ0V=@0X`0X0X0X0XO=Y!G<YUJYZYjYzYUYYYYȰYްYY	W="p]>p]Pp]Uhp]p]p]p]p]p]
=U:_d_x__U____}_=.pbUNpbrpbpbpbpbOpbpb=2dRdrddddd
 efRfrfff"dff
@Q0iL0if0i0i0i0i0i0i=*TpkiHpkVpkppkU4lpk4lpkpkpk=Un.nRn~nUnnnnMn]pq6pqUXpqtpqpqpqUpqpqpqpqUpqpqpqpqMpq Qpu6puU^pu~puputvMpu
 epF4wUfwwwwMwKy>yUJy`yyy5ưyy$ I{UR{`{n{|{U{{{{U{{{{M{
Y&U2DTzՠȰT@N0d000500]UlM@NHUR\hzUʰְⰅTS00 0(0U.040<0D0UJ0P0h0z0U0000000T@q000 0U(0.0B0L0UZ0^0b0t0Uz0000w0000kJ\tjذ
]0:0^0000bVkpRppjppp& K0|0000"!bxΰV"c0BUTdvsİԚ氞#H0006080<0@0D0H0L0P0Tl4ntrv0z0*0000waF000J0q$@pVpUppppS$% I0n00U0000S& 020L0U`0000500"' lUpxİ갰"(Tb6HPUhx5)bUN`5ذ*@NUZz谷+K00a00&, ^԰-@xRаް
.T 0:0H0T0Up0000M0/Y,U@Tn5$0@NUVpUS.1VpŜpppaodefga!p2@KX|˦˶Z3HUj͖ͬа͍4]aNlϘϨϺ԰!oΰ*5T@NpZp|pҬpppp6T@pXpԊpԜpUpԼpppUppppMp7 DUxך׾S"8ق٦M9N0~0ۥ0ۨ0y00: pZpݔpp; Q6RN)}bvUުİڰM<020U@0R0d00ղ000=T lr䜰ȰM>0h0500
?p<pdpp%ppppp*@@XpTpdprpppꌪppppꜪppppꬪppppp
AHpLph*ppppפֿIppep)ppwB(q0%X00!500CkpUTp~pppMp D L00M0
EK00M0FT0z05002G p5pp.H [p5pp"I Lp5ppJ pU@plppppK.0@0P0`000!00F0L pe0p/KZtȦpp姒pwppppppp MK0
\0
n0
0
0
ޚ0
0
 Nk0D0j0000000O]VذP :XxҰҰ!QQT]H\U԰MR 0.0UT0|000M0Sb0N0Up0000M0$T0z0դ000$UH!fZpUذV]0">0"Z0"l0"0"0"0"Ě0"0"W $R$|$$$$Ȱ$ܰ$$XH0'>0'`0'*0'0'0'0'@/g0'SY *0.Z0.|0.U0.0.0.0.Z
,00D00X00h000041j004100[@kRp3&p3!o:p3Vp3U~p3p3p3p35p3p3\ Qp6q.p6Dp6p6p6p6p6p6Jp6p6p6!p65p6p6]@N:Ur:::t;^@Np<atp<p<p<_k=<R=Z=y==5==` *p@dp@p@p@|Tp@)}p@p@p@5p@p@a]0DU.0D:0DF0DR0DUd0DxEE°EMEbkFJFUlFFFFMF
c *H\HUHHHH#d xJ%>JURJdJJJUJΰJܰJJ5JJe=NUNN"N*NU2N:NBN`N~NNNN̰NNNf0S0S.0Se60S-T0S~J0S0S0S%0S)0S!qSgDYUFY`YzYYUYYְYYS0h 0\0\0\S:i@r0]0]0]S8j }0^0^0^@k0_0_l@z___mT ````Sn 0bH0bf0b|0b0b0b(0b0bodFdrd8d*ddưdd1dKpm>0jP0jV0j`T0jaf0j~0j0jU0j0j0j0jM0jq@Do8oUfooooS rHq qBqUTqjq|qqվqqq$sT6ptXptvptptptptptptt@>vhvpvvvvvvvvu0yPynyyyyȰyjyyyv ^p|Rp|rp|p|p|p| w@D0~HR0~p0~0~0~50~0~0x@LpIppnppppyO@%!Nbzjz6060R0r0j000{@0B0X0n00000F0&|@*(nawo)*+,aw!o|ఊ)}Op6p\p/~10jppʚpp~@b080R0rt0R01300S "p&p<pU\pnpppՠppp
0,0:08P0T0!X0!:\0v000ܚ00"@7pvRpp!ppS,0x00U0000S@t060l0U0000 `0)B 02*0N0`0r0/DT0000M0 i00զ000T eXl5ްOpULphpppUppppMp @70X0d0r0!NpNVp%PpTppppp dR0$S:aR)Zt|!դ T6@0d00U0000SD0`00լ0004T'S$@000M0pp5pp@7t¬ذThÄÚ$ `cjzŚRŸqǸe#@pBp/h"KiltʯjkpɡlpɨpempҪpppp ^dфѲҰ60J0b0ӌ0Ӗ0Ӵj0000pPpjpՔpծjppp pbp׈pתpjppp6pZpppٞp٨pٰpppp
0Fn۔۲O000^0ގ0޴0ޚ00@>0^0~000J01@005004ppp!єpp㶪pppp" ^FVvD0Z0z0000*
  e0l0j000j윰@b/,:T|j6pdpppКpp
00P0r000000
64bT ^RdUS@'p,p4pU<pFp6JpUVpnpppp
@>  lj  Ұ @70000V0>F^UȰS&@bt)Bj00	D0	\0	t0	0	0	0	0	@pppp̚pp.'DpXpppppp%K T*N~UʰְS  " U(08>UFNV^UKHTSdJz巒R%VVްX<f
D0R0v0000L p& p!p!5p!p!  "~"""T #~###S@0%x0%0%M0%@p&bp&Up&p&p&p&p& Ip(Rp(dp(~p(p(p(p(!ȡp(p(p(0+eg@+,/GΈ+++++b++++ ^3L3l33333D5T5~5555֚55
D08H08n08080808080:80:V0:z0:0:j0:0:0:dRp<Fp<Pp<bp<Upp<p<p<p<p<D0?!LJ0?f0?x0?!ޜ0?բ0?0?0? T@AVA~AA5AA CUHClCCCMC .pEhpEEpEpE3apE5pEpE@tGU>GRG^GnGUGGGGS@pJ<pJZpJUxpJpJpJpJSipLpLpL5pLpL@rMUhMMMMS$@pOpOpOpOa<oGa<Sʀ0U<0U\0UUp0U0U0U0UM0U@0pW`pWpWpW!5pW֚pWpW ްY8TYYJYdY|YUYYYYS p\Lp\jp\Up\p\p\p\S  p^Fp^pp^Up^p^p^p^Up^p^p^p^p^p^p^T0b^0b0b0b5b0b -0dUJ0d~0d0d0dрe&eNedeeeƚeeҀphHJph\phlph)phUphphphphMph@k@kUZkdkrkk5kk@00nUl0n0n0n0nS&oxoo5̰oo"@0qUv0q0q0q0q%0q@ps>Jpsjpsps!psJpspsapsps%pspspsps@0x!U>0xH0xV0xv0xU0x0x0x0xi0x-0xـp|p|):p|@p|fp|p|p|jp|p|p|" pdpppʚpp -0T*0r000M00v0500 pUlppppS,M"@0|0500@pU@pdppp5ppဦpU*pJpZprpp!!`!+ppppD--.@t/GXp*1xppapppjpppު0P0b00j000  0L0r000000pBpVprppppp@ 6Rz°Ț찝  ,Df𠘪@Trڦ ,Vΰ覰"@ʰذ갧!T@p"p6pJpU`ptpppUppppMp TUj5퀐0U`0z000000T@?pTpppppPR/Shឡp@O0H0n00*0000!
ø"2Nbr԰䰺 0:0j0z000Ԛ00 p.pLpjppppppp@00 0$0.0D0`0Ø000:l!Т@?NJ`tefղ Tfpʂpʤpʰpʥpp)pp ,pDpZphpvp̈́p͒p͚pͨpͼpp ,pVpЀpЦppp"@0\0|0Ҭ000P*ӀӚΰ%5ذ 0U>0`0p0~0Sd@0֜0֨0U0ָ000U0000M0 >UDTlڊUڶ*-{|
2@Tpߠ߸M XU⨰ΰSplpp_  M,pPpSDdppp_BM00_MF}
MJMRWMV_M8\ՐT pp00B0T0d0vpxTppppMp t,0Dː:/0b0U0000Ƹ00000	M40`000ڦ0
nаڰ  ptpppppp p^pppppp 
 p <p Zp p p p p fp p  0>0X00000 ثM0B0P0V00000V0000@Hv  0
0
0
V0
(p2pUFpZppppUpppqp M2Vpְ ثMLM00N0r000ަ0 l
M 0aoGTa!00\q00Ԧ0@8^pLpjppԴpi@DЪ|Țp"Bp"Xp"rp"p"jp"p"p" $<$F$N$T$\$`$d$r$$$$  'l''2''&)5)а) @*4*p***ΰ*!,t,,,,,i,,"T /./B/P/5^/l/&}/Ք///#T 2t222_
$M@0404լ040404<%T55̰55& 6h6rv6666&6,'@ p9Zp9!uUjp9zp9p9p9Up9p9p9p9Up9p9p9p9Mp9(= =U.=R=z===ư=ұ=<{ʰ=B{=|)(5pB&pB,pBU`pBpBpBpBC*@7pE|pEpEpEpEpE+M*0GD0G^0Gx0G0G0G, HHH- I~III0.@70K0K0K/@0L0L̦0L0 0M~0M0M0M1 pNLpNnpNpNpNpNpN! 2MU"PDPVPPQP!!%ȰP԰PPP3G(S/ːHtT`S~SSSTSưSʰSbƕְSS4@[N[d[[[ޚ[[,5 	]n]x]]]֚]]6 _D_^_r___Ȱ___ 7 0bj0bt0b0b0b0b0b8@0d:0dB0dT0db0d0d0dj0d0d0d$9@4fZfvffffff:d0i`0il0ij0i0i0i;jLjdjjԦj< plvplplpl$=dmPmfmrmmmmmҰmjmmm>pBpfpppppp?@00sP0sz0s0s0s@PtBtbtttttA@4vz*vvذvvc`/Gc B@|6|\||j|İ|ܰ|C*~T~z~~}~Ұ~~DT1<\p Ț
Ep2LtjFf0T0j0|00000ƚ000ܚ00G~jtH TplpppSIVhTS,JZpppppK.8FTf~𐮪(L0000M pjppppRqN@n000M0O@pbp%pphp~pppp0:pPP06Z> UJRZ`hްQ8$-@FaA`eߩn%@԰R p@phpzpppppS@Nhj0h ʦ2Tﰫ U pppV ppp(W ppp8iX@JppY 00000Z RxRw̰5ⰱ,[0T!Rv000%00e0TbK/W\&p@pPqUXp^pjpppUppppMp]@00P0Up0000M0 ^f040UP0`0v00U0000S _@2JhÈ&P=Uèàp-` 6txƪ>Nj|ƚZQxahu {p8pbpʆpʮpqpbTdZ̪̀5԰c pUnpΎppp΋dfU@ϡ^j|όϢ϶e@p0pRhpӀpӘpӰpppff0L0r0ֈ0֤0000gա!X @paoxyz{aƪ!2pVpvpؒpزpppFphp᡾NpUjp~pppڴpi*0<0N0^0 Ut0000M0j@G0:0UH0X0d00M0
@00M0 k G0P0T06@|\=U0080T0U000Il 팰ዪ5԰.mplpp卪pjpppnlR.So@ 4U@LXdUjz5ppU`pppp5ppq pUbpppppr 07D0R0f0z0000d@=000e00 00s ppp2pJpVp^pnp~pppA=&p0<@paAIpApB@tD)Hbz⚰u@0N0n000̚00v@00
`j0
0
0
wp~ppp(x@nҰy|&z&Ц{ `d~F|@!FUXhxro@0R!}fpS.p/UPtGXUpp~pppIpHpUppppS~'0!H0!j0!Ք0!0!0!T"H"^""U""""M" kp%Lp%Udp%p%p%p%Mp%@p'<p'ULp'np'p'p'Mp' p)p)U.p)<p)`p)np)Up)p)p)p)Mp) Zp,Bp,Udp,rp,xp,p,5p,p,@
.UV.|...M. >p0Hp0Uxp0p0p0p0S. 02~0202! 020202Κ0202 4,484D4f444ư444p7Dp7\p7|p7p7p7p7p9jp9p9p9p9p94;V0;0;
0;0;0;(/{( 0;T@0BR0Bn0B0Bՠ0C0C0C!40DH0Df0D0D0D4E0DUCEFDFfFtF!FF暰FF%pIRpIhpIzpIpIjpIpIpI@KFKXKtK~JKKK!됰KUKKKذKS0O^0O0O50O0O  PlPPҰPTQ>QPQvQUQQQQMQ @pTpTUpTpTpTpTpT 0W,0W@0WX0Wh0WxRpXpX!#pXpX5pXpX@pZUXpZpZpZp[S @[^[[5[[ p]Up]p]p]p]"^2^D^^^|^^^^^֪^^^^^^ cc:0 c8cRc^cjc|cccҰcc2cc-hI.h>h%ThR\hዔhhUppаhhKJpm`pmUpmpmpmpmS0o@0oj0oՈ0o0o0o T@pJptpp5pp@rU\rrrаrMr ptjptՎptptptT@uTuuuupw<T*pwbpwppwxLK=pwJpwpwpwepwLK&mB0~SL@zZ0~r0~x0~0~0~0~0~0~0~&,xа0\0n000j000p*pDp|pppppp*:Xʪ(pа갌8Nfv~jذp\pppjppp@pbpppp@:T^ft𔀪𔺪.2DVhz𘌪%>Rdv𛚪):La@o=>?@a!`UְS\)ذ!@~𧡄RvT!M0p6pUNptpppոpppT.2`vUU5 鰰U.RոT0000S@簴@tUܰ
.@b𶕺)Vg(<L\l|𹪚6FaMҰ d50Ux0000S (U@\Ȱܰ쪰 "*@R^frŎŨư21<00I&0.0˥D0EN0V0ˢ0˚0ժ000T@p@p\pxpՔpϸpp T0p@p`p~p5pp 0UZ0ӆ0Ӳ00S@5fԒ5À0Ur0֞000S$Ā~עְŔ@pTptp!pٜpٴppZpp"0U(0@0X0z0"0/|tޯ~G0000C$PnP3D[D[      %k      [a! Vb   QxLGB=   0{+&!	!$08/14/03 Copyright 20`by Hewlett-Packardmpany p
!`t`{p
Tp
  'p~}P >"q"'DTutp
0
p
tp
tVatp
p
"p
#tDt=tp
@t0`#~ 1TD#>0ȥtv@D@wt(trD	Tp
'T?DDD T0
%!tq
tp
tp
Du1ү%D"!"#$$"#!P%d%%Ô
@$$p#"2` $ Ѓ0&e'u uаS(2Txu. B/+>$4 `Op" ({ *{*!
"  "2/)z|m}~ }䓣𣮂~)D`s )Cpb`t   +,-.0
..-$-2,,+$+8 Ѐ)t" ~}|}R 5"{ z}7!:tu0:=tq;q<} |<t=9>$9% B'%($('&"!B&cC&PDB&%ӔP&`ӔP%/3d߀@D$d	p?C7%u( %B&u*I)**)p)N`.(('$'82C;i~@<%&$ 5|DqP!B!
D @%((sOaWlz"RR"EP P!B0DTA"1UqTt~ 33U']pPLI"EV=!B#"U.YU#߭""E!21\?j"U
T	"uPu4"%$B42tʎ"0"
pHLp"0"_d    55ta)t`0
5"+ d+/ÞP.%Rd@B Sp`ad`%߀͹adm^{ +u.I-s`..8-N`Ipb,g {
ad,g}hBie,`Ced`"s`7tp
80d" stuvx/yOzo{|} 	9 ;&i 01/09P3
07/28/04 kC?rystal	.00"x#T*T0	ϣT@t/{3"~@xDx_v$ÔdPx>0P2'"2"`'~?"x x *} ;uu u	`J22@)aT$3TD ȃ@VF @~`T?0	T2`T%`@2dłŃ瀾x!T.xT?T/TDx!TDfxD@p`p
0d/dp^01d11$0ÿ10 H@ޠ KB
T`
0 T%%0TO~.aOT"¯|()ŝ) K()(@f`	JKrdxtTa "23C>ٲ T0_33$2P2 P	dxt0$7d4@k@к K07?xD + 'I³P2
2~14"x 0p"0}2` b"ÔP;Q"xD¯./u7ү 6N./"xt}
~豨xWvvuur0DJ_uu!vү0``Tk}𑛐``
$`$pɀ@ڀp xп~c
[xx txDESxxxx`D@O3}Io}vha|?c}d`&xKFJJ*x%tx}D 
 ǐ`0xtxtyuu !.}_O}uf#t]}mO+*-LQѴxdD0ȗ2 пx^D$pTxcD%xfoTP_@p# ) ,AaLYU1+*0߀Ps	ڐȎT@ӈ" x	0.7Ȑ}Џ)b`\ ` ¯u@ !3s#~l01 6\
1-¯)u)$4CU_QLࡿ)}+o)(햚Q@_}*x)( !#!@G(0%[vp"x)(*_0.}+,
-Ӱ@"x^}5}8=" }}:5'x%~x=0Td~`} 	D#R00x)xb`xc p~K0S(;ٿTB(x0)L09LP4B.1(0F{(`xR	(
xx 5!AC	
_(>ԤTBKPF< y(P>A
 0Tdp(	!?(P(
=}% !T"3 Ô2@Y0¯xЯx8x00`3)03 T߀}`	pYl"c_@#h^^%5M4๐ȉᛴx,pxtxx,P0{!x*b-t+bZ.С`YbC^b ݚ`}<TT?)T0Qp<0w)T`A*d`
u)?T'd`dpUp'D-Tr)T?Ӕ @
,T?M<T?`d`}*}W)pKP.,@p6y)Q-- 6/@3~1~W)'ѡ33T'?O)`8 4   )!94 )$`$pXo~," ," Ed0;`bux@_>N>0B? @T? @?0BЂЃ2>x^p` 	2@^;LAK!?*Q?Lx-?+_MLNx*MMx+H1LaeK`
LWM>?Q?J?J0}M\gMfM0M@KA~P
>FQxZ?YQ?RNSmRa@~`JQ`ǏRA>FS0?^Q?T!SMT1W?<;eSATTTUU?cQ?V!SVT~.EVBX\AOJUATViYS2A}4 A}:_2 !, uuҌВ}"`aDCa5Aax'`pqf#5d`!5F78f5`'`2`=`HpQxWwjf6uuuu`"Ģluu0muuludˏO$bƨpN`0T`
0CC0O  !A!Q!| }(xWp"(E(p
@vxp(Ц ()(x)(0U(!{)))((xY))"o*+fT0B 7/t
A!t&0%pd `.ge..>tb;uҌ( u響,-mp,l`
,-3wd@t 5u/1NPԅ+*,-"uPu4+p" Ebx]j	bxtcߍ#x70;x8q7t<P"#$%&c:bda"xe&%P$x," -DtF)AG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7jU?4c~;V~Pno|ZQ}_%]	`
e(i[&b'g>d\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RХZ  a  " ! * 2 1  ` I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p v t z q { y m Zc v v       
  	 x   ~  _  2Y}PJ @|Pгӳ !ww ~~   @".x4BaD`aDx2tx1tI#p%Eb0% %xivv T%_xi6e=PIxk"# $ $ !2x1 	ү  ¯߀0 ܯ#! K@3"0! Mx3=
Ēb
"xjF`@r D"pv~p"" %	x30#L0$<T`"p"xkjfp?
0!#3tJ.4}wxkq$3z 
 Hp_ʓ̐`m$I$'ykNv0@xgv"xw0	D0x$FӔ@Txwyv!D"0R԰48?xexvڵDpT0
QPðP|0r"xmAxn1xu"xmxvxnxxxu~"xpƾxo0q byoxpf`Ӏ`OxpP嬑qbvqpp".0&u)p9)@&a(@&"*f`@"x*ft %u*%o-@{-0*t7U-,-b,R--o++|,U-`RU,`  +u%*$U,00u,,u,0,*+P, 0  d0`PÔ@"0  	0
0 	@	"0 @U@H@@U`@@$U@@<@@T@"   R`(1  ?1ÔP2p0/0`0T%110 }0//A1Ӕ@t -tQ>.nY!=.¯P x.xgo`x[T`*Txf0gv"/*r37TOp0 0@0 
0 ^`]"`0/^aP!+00"7P` ""56q2 "2T1u$406S20 |09}> ~ } | 1+ ONMLVs:_^]\7>Tp7 6`7507505}1$Y2"150#1dn`1o #n0u1o!# u1n 6R3 7x%23Ӕ@
3_ԏ33p22
0
1#95@0
*1$`$`$p*&\Q,*'g55A,$c*$M*e.%/&0'01%e"476  7"4xg@@3xh4d|p%06#/7+{zy6$9p5v3v@30/4?_`)06#%51356:6
P86 - 
8A&; [$6
a>@38V<8688C16@>5679567`A/9t%77566 99b23rPF60r0+06&_<y?964@36	8 8976 K<~76r@I `4 
 o
 *A0`4
 63KLMhHI?74o`130"320u0-06(G8
@J9K=YQBAhR>N65Z\+];OWxoX:p260 ?r3+`*jP666QSfDIbEffbHIge4pve=[fBAg66b20 \0G6CʳEba262V+nbL>IbU3on\3o0n^?o=bQ76Ehfp79UwX#tOpm;	FRonndsnm#tws$t?3xfpJ	`F0}D~
)
) 1)3 3@"xfy}[{@"xz>MNOpxD Fe1``}HX@0
T"`(J" ##?pC{z}y[1zxyOd]P0@0
0 (YP~`0`010$`+$`W$`6$`$`&[$pYATp݀QAzRF>0Txv)!p؀Dx9ؠ00`沆``_P01 ߥ`@ 	DbPCA*89`{" PhTG`xd o R.3I~x~v
xD}E*0{^`
}_T?Dt}W_fi~4ti4mgpEA@`TﰞCl34a3$``$p"t1e4`tg4BH ǃb"A0ƾ0+0)1Td`x0dp# xF TTÔP
.xFt°fͭ׮[xBB2tͭ׮xNN2mͭ^׮xJ_J0r78_9t/qC:(x үR7%$ƽt:t:821(0 (:$⠾x`vT"` R9x"`үs 78 0(87wP p0 xvs#ď3xV53}+0̏4  %4',g4 ͫr""55?@P3p`, Ӡ ϐrc@cЎd`
*~'R-T0PO#-Cՠ,Cb<C@40120``/`@$pNՅ2o1Հ:I&IHE)?P~A [xP03oppG*`6u>p1 '?P"@TP~ +E?T@;үd`pxH @"i55@dq;"-.?Qڑm0`0j-x00 <m@
*0
DDTؠ0a	 0>Ԁ`_Y a}Dt
u/ /t߀l@@_-  r.ldpe`0-DxFu@0u rxPu000u0QY//}Cܣt`../0..}00 $0/	J!ϧ- }p
#.͂
ˠqY"^p @2IR)x0):E)4R⊿`+,02&).7pha)
0kO1 25 
x(0	(`!*((p@L@0v@|	!`@0`T``1_`8pϰd0p3DCD?ܣ%50op;Cc"2J.AT6%p0: ")p	S05B0D) >%%O0/Ҽvd-N-H/G"1r)-	|P.P*46P4p0B&S,8?-`Y 	3-c	FU,`		,._7|D.8TA-*. P3pu.
pGu.O.T)3*JЀ
O*+%KKӣ@+ 90&@Ⱛ0awT0 +	a`>APҼ050upo)?=*+pFR}}~0
pQ/+y*t%)ƿ!$Sp$S;"쎿uWP*1p5BŐ}`BT!p0=/&|$`$<*T0O_U45UpY2xO`Ti)ii[`i00̅54.pI/fDgSC88%mMo2̨WjW	0̀lUrr!jbs!lA$`{0Vk}
1s9'vȈ'kaBtd5swP7s6$$?P3c_x2|rVk}Fr)lWlz8-x5m8m}{` X0"pR"pLxwpGPp?'1b'#2't'TU``|Tx{}Bxz Hxy Fxx Gxw Cxv =xuxextx[xs xr ~xqxxpxЫx| Bx{ Hxz Fxy Gxxxw =xvxexuk{xt xs ~xrxxqxxp/"xdv0`iPTx`pIү9" -8d0-Tx` `bi``ipI -)^XC**W**!4c Z7C"ߏ)u,/n.-T*/.d^ $ XW2kO'c4)%,(֐;)d-AO*q+p·pGQ)䨤Dm++R
0;-pP X-y0hP5$p8?QY}EH)Dtm|E4N  $0 X6 $xpAPy
׮ "u*Pߒ09"RQ }/)PaI X~"=#) R 1)G+0R½$=+pMsQ0Do@`TPp$`Lů;D S)0)u+B+!12 K pp$u+T~aI6/#+"5%TwOd r в	p ``` =ӑ>nc$0>z	Ӕ@6   x?0@ @ x:"%P7?PQ?xv_
 (Ǉ
 % 0NP`> ;PQײ"0z*^AopT+-"L]Meq¿30.RT``P0}u}S?@533oTBDЗD xdw3"?t|`}#xVgxFЎP0PsP@TSmR
j-RM~Hqq3"x)"O[Ql Q0!OQ1#!743t"]V`
O0 )J'' 'BPDbV` !wP`	AVF"HߋI.B1TY*I{PEH05)nA^rpAPSAP}aYpo0:VQ5
 75
0q] $f:aeV1p$,
;
 e@s	D0s	 7"	1Oѵ@"BCC^paV!Cdp;Y2tǣt2rJºCF{D0`DCxgvBC@k"xF?xG@xEAxFt@0( @T.`x@@0xAFt"("r @CJ`"0"AA"xB!CqAB4 9!B
""'#N!OqMNT?%9!N+'(#UJ!KqIJ_**9!J+'(#DEFGT^`N JCT&`3S0ouE`HE@7
GFt#Y8 DBED}_}f}t}mEAMI !~++GxMp<Ô@"NxDTR|NEۀ ?D<$0k* ??⽽p}@1TPp}DOEpEjE^EHE<E&EEDDDDDDDDD  E|FB"<Yp\Gai1pt"x\@/IBJJ0JGM"G`iD1NIM <!6OMID 9GGMI`MT`MP:qPDpP$`RFFX`$FuOӔ@fVOpaiO1O0	xgZÀӛp}!MO`#`5?`2$pCHG`ix!HpiDQMC` `Vx[OOT?xfIMLV7f_PYQh
xc GÔ@π<@iTxcGPhӔ@Dh`aixBhRhNaTO\t{pcxhQQ[v+xfv2 <pt`4}t rt0}>{ t	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTAT=R> ?H&@VBуIR$QJ!0O`Od`[YuORCHHHHHHIII2I>IQI\IkIzIIFI:TDD$D JRpH_HT Ɲ!$UPĈA '@GdpG' &TGJJS
BSx>SHB[ha\@C0PZcO^D=Ěd
`#@`n@(`@<`pdP`@d`oO ǀ20:RD~ttdaRxtx\xXx\t x]txat"xbt2*xJxFxBxtx(tb}0DxxtxtxxtxPx #x> x=tP0x@t@0xTВŤ$"x3tԩƪxqVx!TToTD	ڭxTTx=Tx"``T=DЧ"Dӭxdv0}=t 1GWCWHWFWB}E?c"x0xN"xa@P"rS?/?@>"ޑ$tr>!$-"TpcÔ
P~0~7%OO_NN7%NN{ z yN=@Ld Lk+Ls3L{4L6L7L8L9L:L;L< w L`>NRK=PQpI0A91~5KWN&8S;SuNuNK0ůN"$`($`*`-`X/A^p4`
Ta>BVp=ASCRGRFRHRBPN$`$`!`0`?$apA_:3P2B0  :c. 卂,P3`G`[]Np_"Nב dpF_ $S `aDAST+7ۀ}. N07@O"K}$pL`PPKd`ПKxaK PKK?L9a@P
;Poxav@#@NՐNՑNՒNՓNNOO#O>OYOaOrOzOOOOOOOOOPPPP2PFPWP\PaPfPqP  P0q
v"xz>MNO`uL 8LLx@g}[dtxybt")L1
L'?4!pPo`"} XK}Uv`Ai"uM SMMTp_TM0CMu?0/ 0@x[TavjpdxTxdD0x~> x0x`@J`}K}I	*
 й"3<LxN| } ~ M4/AfoK`RLL  RP((sQ
QRR*R5R@RFRQQ/Q7QGQOQQQRZRnRyRRCpÔ_`PP"T?} 0xtp"K&MKAi`Jj0 V	>Po50 TPk?JuK"  Pcr@i0a>3 ,`PM"H$pa?x0Kp."xydP J"{z}y[yzML5daMucw!#"c~1`0M}?0p!p"!q p% :p(KFнT0P4ffdfampHS#l0#`>0xD  1TQhx@b_!A,,wxv`n魔flTfA,l12>3`lx0.u0/}+  $0.T`600//@"Sl0  " 6`6,g7:"09   6:}`6",.S-c9,Ô`,pC-S--S0:6-0"
Mxpo0 "@Ťox`A⭎/012*@t?0t /x}2x?D,? 0/2R1U2B|9դ[xxDxDK J K@ӭ3xWo`YW`M
WUU/UnUU$PVWW8WXW_Wl3x
,-Dx
tN,P
-,px
S`Tx
1SQ F{TRx
1S #N3QU0"t "T $Qxl	}JUBxkYxkßP2T#0 R%Z$JrUY$ÞPxk=NMp^QU`.`
)*u+S4e-7ү`M$`&0p<T7H7}_tdpJe_Fx+*)3Y^QU$xxl l@v FpYAxkvykxlsP] [   FZ\0{ 	b[3
QT xov 3^x^`rLi
nQUfnPQ`i Fxx
xBUQx	03W)`74P$WU@sV03bs@W WWWWWXAX	X
  Y`Tq$DDaC{D@0Pa<"?xD'Pi$P``qrн=@}TO((  +D" >1}T 2}}6~`/#@W *`@!fa_`OJt`н!mr_33TOzA D `ӌP  4"RΑ`p}TУ`- ,*))K9XS)S)x_vS))"()?,0,ZS Zx	`א}NMZu- u.DSS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-Q^P_ѕ22􀠙^,Nxa s@ Д\`3-ӗ`w--Ӕ@ nЫ0q`ҐZZZZ[[P[k[[[[[[[\$\%\+&\4+\@,\M-  \Rs,ps\Raxu,x@jsӫ!R*+RP
+* UyI
xҬ砡Rt?e+pt e* 
 F	cFѫF߆`rx Ѭ}}S{txҐ0ܐ-x't`[,^ѫ_vpqлo}U qtquuqvq$}ϵ}3̰r' A݀QX0:_ѬA>;ą)("`N^`A\\\\\\\\	\]]]]]']4];]X]]3]  ] r] rssssq
tt)%UUs	s
spʖB_*ϰeTepʣ(KQqT0BK
/$:D%0{\Pi$'#' B%&T'Q1~ iBuZQ`!qk0T[Gt('D4s䣢ڰBuc[xBUq`M`PCD !
Q ÅP'D  %+x"nqD13~"0'
  `""0. H" 0[`2o%$l`0Te1p<B30 ֣3d	`3

3 xgv"Ô
@"2}2D	1F.(1$`$`$Ap9^"_ u#	"`
la;󠜄
Dxg1@Tf"
g"xaJTB0J?p__" `0"$``#`$`%$p#F0 ꠺x
=#"x%tz%aCx<Fd' G"^ ^}te0	
}Q`Ax00Dx!ToT`p1K@K -TAL
! |1F!D`,!TM%5ў!
Q"  :	;
Z
123B=>C	D

~x`!ÔP^`_c"
%p=@MF`7PC0x( (c2xQC!bwˏ((`C0.+xT 3 L} 2 J. D0T_`
6 ، 3p
p00	3 bQS0cx($```9`B$ bxv z#!q DxTҎxStTT"Ha!(xS(<x)3)$``$p#(xSwx@!(A!	xD03QS0aP"*+*@*ӔwPQ,@
+;Pb=*$&~$cp!0.-C+(}W+֗/Sڏ+*d'+_C++++NcR,N2@2-@o-~ `J`N`R$dpT+ +Qs"+16d6dp0Q60ӀÒ.k+9+p0"*+i" ""xi@!"߀&<	1}i`$3mp`1}@,/@xdde8e>eGePeYeYe{e{eeeeŕeeef	ffffff͢gfgfgggggg̪gghhhRhRhhhhhĹhĺhԽhԾhhhhiii?i?i?i?ifif  i~)i0>`iC/MMT3/MC/00u6$5\ 0` ~PR/pOwՀMu/AN_}/RR=R,}RO5\c+4TT_UERJpTTWRTT)YRTT\SN P  ?:PO"`zOPLQ/OPӝ 03ME_~ R`| }e@^_іMCTBT?^RTRO_hR3a6c bӔ r dfb bÔdAmM| `z {eo@\?]L`ba?-.bfWj!r .pT_.-VT)jRTT/vRTTOxRTTozRTT|3Sm@#poV_ߎ-stS"!t{dz VT~RTIpACTɶTRT˶ToRTζTӎ`,$/0TP/ P5PP/9PO0q`!pTTQÔ@πu/0,/y`  & SP@+Q;qS:;~%`j`j$j!`T}Q`$;`!¯!xlաJܢKܣLxiA!<<xlP< q--0#70"p"; 0_"$P;OПUKLM<xl@-"678x>T9!35TJܷd@l09p5ip}ep& 5pҝ| $ >6/78P0 {dp!T`"9"}m~'ø}¸noC |qk`> @2/} }` ç`&TTm Mt
۫ܮ~`A( 'pЏ((1 p~'b2dDm@@sE@&h~+pr]~|D}o] 
1/n:l+la"/1Pɀm	s:мM }p
T?T`1"1"pAu0<.M.`~0Q~^ QBT0ЫOTOѺP../p3pO21*İX aPMpA.ߞ`1r1ǶPC15o~`1Co~P@PB1OPp053s,`&PP@0ۀm`p1"x_0@T_O"\`.4b 2oB00_0e.`.!ù6wMe.foB.oм M/@n/0}s  ~$w P	ADo)2@T3`Ð2"202` `2. p(u.r/u.@Mp}^0Q}]bUӝ d/Xu.8r B/.bllr'b6x"bb۴u0;ѷo@X0p.~sPFT1TT%%ҴHp0`t_0
P	.d`._/ӟ@	APO"bwp#5x^tpejEhrEU\Uu^tx^ՉOt}5}{z~y~qfs*2s*01L&trе4pލ(u)O&g'E~ @оe`-tB~@_"r`"2"¯02Q!`
)t`1	ÔP7o_үٰ11n`2o|0Q|\```23~@dz+'z1411dyt((st^tttuu?u`uuvmvwYwwxIxxxy yAybywr#{	j;7<mP6`>1TFfEF"Ju2`u3 { z y2K;+M2T`p[d`fzIJfEKDfERJl0;fE
FYle3p2l`&"0C.+JfEKM4WK4,9Reop455544D45s^
^`/aObncdTrVfE WImYZ@9\#UedLpjVfEK4T(vfE?wTV`ppNVfE_o|?{:}PVfEx?(@?fERfERfE<fE=JfE>/fEQ?TJw}MVfEq _t`SX6D!}09q08lTisD  4ct`DE
1?"04eE}1QIpǚ uy,u1(#!1$`=`l {î$|1u1!uxSoC4ı{`dE@ tu/( !)(]3aTT Np\ `, @M򯊫Ô@ oCѱ?u1{tpuҋ4|?1͢4as}
}`01s721*/n z3Y/GaH|d)ȖP.,ץ1|vA1{0W}"!$}_.3A8ܰoV%<p}ԣ X}tɠ90p0@0fӏpӕ/~/.Ð2cP$3/tP"sѐ}18
 9"""pqt~P
#0cQ pD"LION x1x2`TTxDxDp"p0À"x0 0p\A2	 x"0~	~ o`Ӏ2~10hbh opn`dx"@"P-- np3x&03%T~TOp&p"x!To`	xDpT}p"dp;"	F	>	2x#pd ײX"2LҀƀi3ꀚڀʀ3䓣Ń?
"ۤ0$ P##EN``#s"P"]"$


"  )"/33@" 
3@p"@"( p8

߇	
	4t)ς:!?	%

"*p7@		"g$q`""""BBE"`;Q 31p`!"""Ѓ?Ђ`%Q%tsߨ%&'sŃŃA(("% 	5$pp
s%h`ߑp - -~Q -v -n$U -b -Vb-UJe0 1~ 1F4ppO~4{pΖ6#.s _;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ ! #?$_%&'()* ,?-_./0123 5?6_789:;< >??_@ABCDE G?H_IJKLMN P?Q_RSTUVW Y?Z_[\]^_` b?c_defghi k?l_mnopqr t?u_vwxyz{ }?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$%& (?)_*+,-./ 1?2_345678 :?;_<=>?@A C?D_EFGHIJ L?M_NOPQRS U?V_WXYZ[\ ^?__`abcde g?h_ijklmn p?q_rstuvw y?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ !" $?%_&'()*+ -?._/01234 6?7_89:;<= ??@_ABCDEF H?I_JKLMNO Q?R_STUVWX Z?[_\]^_`a c?d_efghij l?m_nopqrs u?v_wxyz{| ~?_߄ ?_ߍ ?_ߖ ?_ߟ ?_ߨ ?_߱ ?_ߺ ?_ ?_ɟʿ ?_ҟӿ ?_۟ܿ ?_ ?_ ?_ ?_  ?_	
 ?_ ?_  ?!_"#$%&' )?*_+,-./0 2?3_456789 ;?<_=>?@AB D?E_FGHIJK M?N_OPQRST V?W_XYZ[\] _?`_abcdef h?i_jklmno q?r_stuvwx z?{_|}~߀ ?_߉ ?_ߒ ?_ߛ ?_ߤ ?_߭ ?_߶ ?_߿ ?_şƿ ?_ΟϿ ?_ןؿ ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_ !"# %?&_'()*+, .?/_012345 7?8_9:;<=> @?A_BCDEFG I?J_KLMNOP R?S_TUVWXY [?\_]^_`ab d?e_fghijk m?n_opqrst v?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ 7P       VBT             $VBT MONTARA-GM     d 0 
 0                   BIOS_DATA_BLOCK r  V
  d3104Intel(r)852MG/852MGE/855MG/855MGE PCI Accelerated SVGA BIOS
Build Number: 3072 PC Dev    09/01/2003  17:06:58
DECOMPILATION OR DISASSEMBLY PROHIBITED
  Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        		
	
		 	   ! "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ D                             ! %  8 I 0    Qe    X<KU $  ??W%X$3 oWX$q __/W'X&M `   `   `    @`   D`   `    H`   L`   `                           !                                         0  UT                                                            =                       $    (     
 
     X`                                                                                                                           !  	 CH-7009-A                  CH-7009-B                 SI-164      p             	 FO-450                                                                                   
 J   <   
    	 P S( | 
                                                                                                                                                                                                               <                    
                                     <                        <                        <                        <                        <                        <                  (  s ) ~(
(	
	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@1      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 	         @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +1                 ,          PY @      $AIM@             1	 CH-7009-B           C              $ADDIN30 [    $ADD_OUT               AIM3     I            \ i n     Chrontel Inc 7009 B CH7009-FP 05/02/03 #&0` ޱ #0`  -&0 	 # #&0` ޱ # #0`  - -&0 QW=  3ɳ
 Àrttc8 u.Mu
    .G.Gu5WгP$r, uu2< = 
_Y8 2óu t = 2f vf fa  s
fa   
3Sh<.$? 8 .U
u#ff3f  s
  0  &u!ff3f  s
 	  	  t.G.Gfʸ2 j j fXh fPfVW * ._Ѓ

u[ S$WM
 Ȱ@;ff  s%$@ u'Ȱ f  s$+j j fXh fPfVW * ._Ѓ

u[ S2
[S2<t<u
t	<tC
u*8 .U u	ha$?Nt
[SQRW8 .ǀt
 ֹ  ֹ .؇ u2
_ZY[SQRW8 .ǀt
 ֹ  ֹ .؇& ulGw <r\Ȱ  b <u
 V $ L @  ? u"Ȱ } * <u
o  $g 2
_ZY[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[ C@@QȰC@$<u++rYPa @      $AIM@             1	 CH-7009-A           o              $ADDIN30 Zwy#Baf    $ADD_OUT               AIM3   	  A   X   \ j o     Chrontel Inc. 7009 A CH7009-TV 05/02/03   :cȞ Y.ς~E: "^Ȟ 
*Ă~EZ m g!H
z=

 
_R 1X @      0X!@     QW=  8 .} 4 %+ ˰n  $< < .} ɰ ; ǀt+uwurt.
h  fVW * ._Ѓ
ut.t6.= u.<r
, uu2< = 
_Y8 2óKu+P  4Xz? u=2< = 
fRW8 .;Ew.;]v2Y .
ut" tRu f.f
   ff;tfȴ2_fZ`
ut
  *   t<Ru
    .G.GuT3Ɋ<u
  (<!u
  <Ru
  <bu   t.G.GJu2aW8 .;Ew.;]v $#2$
u<u<uR<uSh  fVW * ._Ѓ
ut
[!w$P!l$_ 2Z$< u WfXh! fPfVW * ._Ѓ

( #haHZU K 
_S2
t<t<t
<t 
up $<t<u   P      X ߀
u "u<u2u0[ $߳ u2
[SW2? uÀ"r22_[SW2&k uGÀ"r2_[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[:  rX%  tZ:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  i9  \:   撰68BCU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ g  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $         f=$    f$ $ u     f=$    f$ $ wf$ |  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  
  $ f$         f$ f=$ 	r	f$       s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X    SVa    .: ^[VL  .: ^V=  .: ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  Or<u   f f  fZfY[SQR   Sr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f    PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZX`8 8 8 WUU*UUU{  'G_PQW3   f.;
: t3_YXfP >>?<u>>?<t>>?tĀ fXð>>?ð    2ff fff戰䈽!   戰O     戰   戰䈻              u׾%   %   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                            `   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_vaÐ            f  f  f  f f f f TلDf f  /f f  f f  f     fHt쨎t<w.$f ffH$tt
                                    `      D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  4             D                D               E  @             E                D                F             D  i         @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <fQf%f  $f$
tppqtfff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аf/ff. f"  ؎ f%" 3؎f f  gfnf̼gn!fgf  $f$
Ћfgf  $f$
Њfgff  fffff̼ԥ$f̹ gf.f̼$ff f  gf  P$fP$
Ћfgff  @fffff   tfff%f
   ff  p$fp$
%gff  `ffffgff  p$fp$
$
f  t$ft$
$gf  $f$
Њff  r$fr$
f  xfff
  ff  t$ft$
`f̼V%ff̼b (fgff  pfffff   tfff%fgf&    f  $f$

 f  ~$f~$

%gf  h$fh$
Њfgf   `$f`$
Ћff   `$f`$
$@fPf   fkff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0f]ff  @$f@$
= u$<]2f(ff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и 4ff% = uf©f fשnf % ugfTfU../0./.f,f d< uf4fd< t<t
u掰f\f䎊fnfff掺<uff  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f̼r2f̺ t
^+;w 瀸	ذf%   f
   fʺfffʋfʃЃf3f   f̼fsf̼ fsf   uff̼,f̰Df%   f
   fʺfffʋfʃЃ$<@t< t<`t] f̼yff   u fuf̼fs ufɋf5f̀  f̼߭^fsf̼fsf̼fsf̼$fsf̼9fsf̼N?fsf̼cyfsf    t  f%   f
  fʺfffʋfʃЃ瀃vCt>t9t4t/v*f f 
 
 %%]f f%?ft  f	 ƹ )f f
   f   `"f"rf    f   tf̼v*ff̼Tff̼ff̼>ff   f̼t/ff̼/ff̼įGfU f̼֯{ff   u fuf̼
ofs ufɋf̀  f̼9fsf̼Q*fsf̼iCfsf̼~_fsf̼fsf̼fsf̼fsf    t;Df%   f
   fʺfffʋfʃЃ $<u> 9Df%   f
   fʺfffʋfʃЃ  $<@u f%   f
  fʺfffʋfʃЃt@tEv
tt ; f f 
 
 %%tv  
tt f f%?ft  f	 ƹ )f f
   f   `"f"rf   @f   tf̼Nff̼Zff̼f.ff̼rfff   f̼,ff̼,ff̼of} f̼ff   u uf̼ݲfs uf̀  f̼2fsf̼#Xfsf̼;qfsf̼Pfsf̼efsf̼zfsf̼Mfsf    tDf%   f
   fʺfffʋfʃЃ $<u f%   f
  fʺfffʋfʃЃt,; f f 
 
 %%ev f f%?ft  f	 ƹ )f f
   f   `"f"rf   `f   t?f̼ɴff̼մff̼9ff̼ff   f̼!*ff̼q*ff̼f̸f̼(
f̰tf%   f
   ffff%f
   fpf%   f
  ffff%ff̼f̸瀰`f%   f
  ffff%f
   *ff  f  uf
   f  uf
   f
   f   tf f    tff   f   uffff   f   uffff   `f    uf
   @ff   f̼jfff   t&pf%   f
  fffffftf%   f
  fʺfffʋfʃЃf    f32ɰ@f%   f
  ffff%  8tff̼_ffǊf3ffff uf32ɰAf%   f
  fʺfffʋfʃЃȰ@f%   f
  ffffff8tff̼ffǊf3ffff uf̼ȷ9$f̰f%   f
  fffɰtff̼$ff̼7%ff̼@ff̼df̰pf%   f
  ffff%ff  8 f  8 tf
   f
   $p
 
 @
 
 f
    ff%   f
   fff< wf%   f
  ffftf%   f
   ffff%ff%   f
  fʺfffʋfʃЃ
 Ћڰf%   f
  fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ< t?gf&    ~f%   f
  fʺfffʋfʃЃ
 %
 f   uf̼Ĺ4ff̼йD$ff̼ܹff̼f̰f%   f
  fʺfffʋfʃЃf f t't"ttttt	t(f   t	fX3瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼ӺM$f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  ffffgf&pf%   f
  fff$0fذpf%   f
  fffff   t	fP  f     fP  f   tff   gf&f   pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	fP  f    t	fP  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼~!f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  fffffư  gf&ffpf%   f
  fff$0fذpf%   f
  fffff   t	f   f     f  f   tff   gf&ffpf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	f   f    t	f  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   丫f3f3f3f3fffr;@  f%   f
  fʺfffʋfʃЃ@ffrAf s:@ f%   f
  fʺfffʋfʃЃ@f̼6f̨t$$Ӱf̼f̨t$$
؊f3g.  8tfg.  g.  @ۊf%   f
  fʺfffʋfʃЃ2f slPf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃi
Pf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃffAff@2ۊf%   f
  fʺfffʋfʃЃ؊ۊf%   f
  fʺfffʋfʃЃDt2ɰf̼)fr<tr2ɰf̼frtrff   % = uaf%   f
  fʺfffʋfʃЃ<w+<t'f,   2f%   f   uf    3ɰf̼^hfr
2u#r f̼@f 2+tt9 taf̼f.:vf̼f.:Gv]f̼f.:vf̼f.:Gv0	f̼f.:v
f̼%f.:GvA2ɰf̼J|fr".:vf.:Gvf.:Gvr2ɰf̼>fr.:vf.:Gvr2ɰf̼
fr.:vf.:Gvr2f  8 f̼fr$< t<sf<tr2ɰf̼$frufr3ff̼Rtfr,<t(<t u	f   tf   r3f?
f̼%fr,<t(<t u	f  @ tf   rff%   f   fffffff%   f   ffffffff   fffff3.<uff%  @ f  @ fffffff%   f   ffffffff   ffff؋.s<u uvfff   ff   `f   @f    sf䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf&  fX  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
<䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$tf%   f
  fʺfffʋfʃЃ両f  Hf%   f
   ffffPf%   f
   fʺfffʋfʃЃ%
   f     ff%   f
 ؋ǲ$2ظ.fʳǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  ItG ff%   f
 ؋ǲ$2ظff.fʳ@ǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  It?fʸf3
f  f$f   gff$f  fh  ?瀰Yf%   f
  fʺfffʋfʃЃXf%   f
  fʺfffʋfʃЃ$fd   f̼uf̰Xf%   f
  fʺfffʋfʃЃf  f̼3f̰Xf%   f
  fʺfffʋfʃЃ$Yf%   f
  fʺfffʋfʃЃ$%f%   f
  ffff% ٰf%   f
  fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$0@f%   f
  fʺfffʋfʃЃ$  f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$ff%   f
   fʺfffʋfʃЃ$f   f
   f
   f
  
 f
   0ffٰf%   f
  fffff%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃ$f%   f
   fʺfffʋfʃЃ< hf%   f
  ffff
   f
   fﰀf%   f
   ffff%f
   `f
   ff%   f
   fʺfffʋfʃЃ<r}f̼9
ff̼Ef̄taf%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ
 f   % = tAwf%   f
   fʺfffʋfʃЃuf  Gf  ?wf%   f
   fʺfffʋfʃЃuf  f  f3ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf   % = tAwf%   f
   fʺfffʋfʃЃuf(  Gf8  ?wf%   f
   fʺfffʋfʃЃufH  fX  f   ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf3fh  ٰzf%   f
  fʺfffʋfʃЃg.Ћڰxf%   f
  fʺfffʋfʃЃAfr丬瀰Df%   f
   fʺfffʋfʃЃ$<df   2ɰf̼ 
fr<Htfrf   -rf%   f
  fʺfffʋfʃЃȀπ ٰrf%   f
  fʺfffʋfʃЃhf%   f
  fʺfffʋfʃЃȁ ٰhf%   f
  fʺfffʋfʃЃjf%   f
  fʺfffʋfʃЃȀٰjf%   f
  fʺfffʋfʃЃf    ٰRf%   f
   fʺfffʋfʃЃJٰ`f%   f
   fʺfffʋfʃЃ"ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃȁ ٰf%   f
   fʺfffʋfʃЃdf%   f
   fʺfffʋfʃЃȀٰdf%   f
   fʺfffʋfʃЃ	 f
   `"f   f   f    0f  f  f   0fP  ff0fX  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0fn  0fo  0f  f   f    0 f%"	Cf%   f
  fʺfffʋfʃЃffff3f3gf	 f
   `"f   f    f    0f  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0f  0fP  ff0fX  0fn  ff0fo  0 f%"	ٰ`f%   f
   fʺfffʋfʃЃ ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃ0ٰRf%   f
   fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃذf%   f
  fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃt  ذf%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃ瀻 tDpf%   f
  ffff
   fذpf%   f
  ffffxf%   f
  ffff%?ff   f   f   f   f  ff   fpffذxf%   f
  ffff瀰f%   f
   fʺfffʋfʃЃ< tzhf%   f
  fʺfffʋfʃЃfx  ff   ff.
Њڰhf%   f
  fʺfffʋfʃЃff3ۊكrt, .H $ttfffʻ
t@fغ  ff% f؀f   ttf   ff% f;rfn䠢uu`p2<F&-4$*Px<Z0HPx<Z0H       a a a a a a a a a a a a a a a a a a a a a a a a   i i i i i i i i i i i i i i i i i i i i i i i i   1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1   9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9   A A A A A A A A A A A A A A A A A A A A A A A A   I I I I I I I I I I I I I I I I I I I I I I I I                                                                            
                   

       
    
   
	   

   	 

	 

	











	
	


		

		

		

		

		

     "!d!Bǅ 8080,( (   ,( (                                        '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽k񾰱fNf^f
8f{f#"f-f9fC
2fSf] fiܾfs<y]ff f骾f 騾f钾ff|fоfif f"f  f.f. f"  ؎ f%" 3؎ Q -pqtO  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        07/28/04BUC  .           T11  T1    ..          T11  T1      R o m p a  ?q . e x e     OMPAQ  EXE   Q11  Q1                                                                                                                                                                                                                                                                                                                                                                                                  MZU  @  j
   \X      M        
       M

      n  
  
  
  	  	  o	    `       M
5  ;        i  )      ^  M  D          +                       	 	 	               U   8    M
																		~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
																																			~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
			 	 	 	 	 	;  ;  S;  M;  1;  #:  :  9  9  9  <  <  <   				v	^	@	"						n	V	8			
 M
G  G  qG  iG  WG   M
MU  T  T  T  T  jX  @Y  ^Y    				z  R  ˇ                                                                              3Ðjhː
  F  F~ F F^J9 uvfv' }fvfv ~hh jGRP{Vtj
fvvP蘄
hh jHRPNVtj
fvvPk
 Ð3f>X  tf6X f>j  tf6j 逃>\  t
6\ UV|Ð  Vh jQh jFh j;h  h ݆h ~F ^v&v& =c   -!  - tHHt-3 t_ J  F^v&v&8 D^v&v& it^v&v&   R  R  N  R  L  >R  uR  |F  H  m-d _HHt- t- t- tf6B j RP`jRP}jRP}jRP}jRP|}jRPl}j	RP\}j
RPL}jRP<}jpRP,}j#WFF9F}-^v&&?-t^F&&?/uF nSJ=sjrRP|jVStjsRP|jVTSfh  j k~X Z X ujtRPt|jkVQuhh Y|jPVQFF*PFPhh> ^fh   Q\ uhhR |jV>P  tS<  St(n ! ~ 9  =  A  E  I jJj1fj}j l j ujtRP{jU		t(^  v j   l ؎f&frjrRPQ{jHU>N  t>P  tV  T  J  >V t>V u& & & >V u=>R  u	>J  >J   >V u3R Ht	HtHt8j uwjJulj?j.>V u?R Ht
HtHtHtIjj 1Ȑj#u+jRPkzjR HtHH>R  tD>L  t=<?h<h<jv
>H t jYRPzjIRPz>H  t7
j SK4  F >4 >N  t>P  tV  T  J  >V t>V u& & & >V u <~ tfj fj 'F  W=HtjH-
 -!- - - 
tEfUm
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >H  tW5L4 C= M- K- (-M- 0- )fj*>H  tj Q^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð<">
j hdh<h<jy>HT  Vfh  P FP|f<K  FDjhdh<h<jy>H t3^ÐFPsBFVhhx FPyRPhvvrhhx fvyRPh` Zrfvh` q ^Ð  FF	<">FDFjhdh<h<jx=*ÐU~uhhz  Ð~ hh h` =U686u3f0    8f66fh  f6X V= s6&G
 t	SSf0   f02f9r~"fh   RP6\ f6X \Lut뉐f66SO~ uhhz Adr j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPy
Mfh   f6X vj 6\ ,KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h` MS686tj frf-   fPf66q
f66jFPKq
f66Pt~ uF.~uF6b 8Fuc 8Fud 8Ftf66QkFPhPbf66Q ^_Ð~ hh h` R686f0    	02f0f9r~f66fh  f6X gR= j6&G
 ]fh   f6X f606\ I=t5fh   vj 6\ f6X Ir j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPw
x> tjJj1j f6j Lwjhh p j   l RPv
6n h	h| j   l RPv
r j   l ءZ +X  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  &  FF܌VF T   P   V   f<
S h<h<jPm
>H u_>?@T Rf<N  f@    FޣdFܣFhdh<h<js>H t>=uP   hHNu~ tV   Ft
F$p*V Ð&  VFF܌Vf<D FQCjDhdh<h<jr>H t3^F  FvڊB^& Fڃ~ | ^Ð>F  t	<&<Zhdh<h<j?r>H tjeRPo  fh  ! h	htjRPQF  @n +FHuF F^	&x&*hj*_RFn 9F}j vĈf<t<uhh CQÐ  o= t= u%F  F~}
FOu~|3Ð Ð>T  u#jERPnjFRPn3ø x&hjQhzt{u{Ð  DJ;fh  hPhvt"jGARPmjH1RPmjuRPmfh  eujARPm>H   2F hj
Pj
RPOΐFfrf   ffffN*+;B|;s<F*PjRPOj F*Pux&
hPh` jQRPiOjUARPjT7RPhh IOÐ  jF "hj
PjRPOFfrf   ffffN*+;@|;s:F*PjRPNF*P7ux&
x&
hj
{OjvcRPlju,j?GRPlj@7RPk>H  tlhvh` jRP+NÐ  D;fh ChPhvt"jGRPkjHRP{kjuRPikfh  ujARPIk>H   F hj
uNj]RPuMΐFfrf   ffffN*+;B|;s<F*PjRP5MjF*Paux&
hPh` jRPLjURPjTRPhh LÐ  F >V ut~ thh hh FP fhh FPwIFVu3vPfh  f6X nI= s^&G
 tF  fvBHO>V u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6X FP.F~rhh hh HFVtvPfh  f6X J= s^&G
 tF  fveG~ ujKRPcKhh j3RPKKF*  F 6u3s+tt~ thh FPdjhh FPrdj RPFP]dhh FPGFVtvPfh  f6X G= s^&G
 tF  fvF~ tj!iRPJ#.F~  F ohj
QKF  hj =KFj!;F~x& ܊F*PjRPJf6X FP-FF~s#~ t~ uw&
tFPFPj"RPI~ u~ tjjRPIF  F f6X FPW,~uPhh hh IFFVu3vPfh  f6X G= s^&G
 tF  fvEFÐUf6X FP,Ð  F u3F F~s7F*PjRPHf6X FP:uhh Hhh hh EFVtvPfh   f6X F= s^&G
 tF  fvVDx&

hj
9IF hj 'IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j LRPFP`hh FP.DFVtvPfh   f6X )D= s^&G
 tF  fvB~  j!RPF8EF phj
GF  hj GFj!R;F~x& ܊F*PjwRPFf6X FP<8FF~s#~ t~ uw&
t~ tFPFPj"RP1F~ u~ tjjRPFF  F f6X FP7u3À~uLhh hh BFVtvPfh   f6X "D= s^&G
 tF  fvAFÐUf6X FPA7ÐU  
2

p UvV>
Ð  >
vVF*^&F^&  >p% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젰
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  RhÐ*Gh  ~ t	h7FNuÐ  FjfvFP]\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fv_`Ð  FPNQVRhh fv`vvvhh FP"`FPNQVRhh fvi`vvvhh FP_FPFP#[ÐUvCRP:[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvxZfvZF
^v&  FF9F|^v&  ^UVfvfv5ZFN^v&8 t&@ ^fj <fh  vfh   !jWRPf6B BZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0VFVRPFXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& )RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRPyV *+ȃQ *P%jj fvvvvv9ÐUj=fvh 6V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7jRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wZRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0nڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0E׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6pFPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>p tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>V uFPÐFP	>V u^ÐU>V uFP+ÐFPU>V uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFpFp  F
FFFF  F9F~FF^v&8 uvvE~ u
FpF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh7htLth7hِ 1= t= ut փ>T  t fj hN3  F- ~ ujQFÐF Df>r   FF Ffrf   ffffN*+;<|;s6F*@N*- Sh8h*F*PЃuFv j h8h jЃ]FUtKjhЃh	h` j hlfj hTG=th8hEtÐh	hPh	hv~&IOÐI&OÐU~ u h	hvjh\Hh	hPjh\7F  F~ ujFÐF Df>r   F,u j h6:h2fh  <уu,- F Ffrf   ffffN*+;|;sF*@N*- ,Sh6:h2j F*PЃufj hr F; j fh  Ѓh	h` fh  {Ѓt"h	hPh	hvăt"fj hE
fj h6=uSh:h\t!h6:h2ttfj hzPU~ u h	hvjh\h	hPjh\F  F~ uj-FÐF Df>r   Fu j h;hBfh σu- F Ffrf   ffffN*+;|;sF*@N*- Sh;hjF*Pσu됐  fh ΃h	h` cfh ΃t"h	hPh	hv'Ãt"}fj hEqfj h6=uh;h\t!h;ht6fj hzÃ>H  tj ht4 4   - ~ ujFÐF Dj ؃u^ j hz=hhtF F~s3] F*- j hz=hvFP^uF= j hz=hNhe>V utTetMFtFj t:h;h\fj h6=thz=htÐ  - ~ ujFÐF DF F~s-F*- j h>hFP\uF= j h>hlh또>V ut>kt7j hIfj hT=th>htÐ  - ~ uj߃FÐj5փuÐF D^ j hZ?h
tF F~s3d F*- j hZ?h
FP|uF= j hZ?h
lhc>V utTtMdtFjt:h;h\3fj h6=thZ?h
tÐUfvh:  l:F.fh. U Lfh.   }Lj/gLFfh. ! fLj/PL~ufh.  LL~u
lN:OÐU*FPlP&L:*P
LÐU*FPlPLF*P:PKÐ  >L u7+  FV;Vrw;Fv	L ÐFP
uh h UL  >L u
FPh iÐUL  >L u
FPh IÐUFPh 9FPh -j>L th UFPh FPh FPh j|MÐ  >N tRFPh FPh FPh FPh j0 h l<uN  >N u&v*N"FF FF
FPvBl:Ðb=tw$-t-| u)n  >nt% Ðn -t-t t-0 tn Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? UnFPgÐFPtHtÐn	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  ` h FF )fF~}j v`tF`  F~s#>` tFPh F  f+fF볐>`  F  `>` t(^&9^&?t`  FfF~|F~s>` tFPh ;f+fFҐ>` uKF~}Afh   j FV^& ^& h.` F 닐FPh j FV^&^&`Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h bfh   FbPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~ubPh Zj FF  	&v FPȃtFPh	hv؃~ thh
hh
FP4hh FPFVu3vPfh0  FPfvFPh	hP=ظ U؊FPfh  fh@x hZh:RPhEÐfh@x h.h
RPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hwhV\^fh\  hXj 6\hIfhL8 h:hD  fh@ hh
RPh
fh\  h
f6\h
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB=
hxBPhxB.
F~|hxcB$PhxeBh   fhx MBF  F~
}Yhx%B$Phx'Bj2ԃhxBPhx
Bhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx ]?fhx N?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRve1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&v FPBtFPh	hv3˃~ thh
hh
FP'hh FP_
FVu3fj hvP(
fvfh  FPF
fv.	FPh	hPʸ   F CFPPj/U'
~ u3FCFPNQQj/@-FN

 PÐU>P u3ø  
ÐU>P u3Ð 
Ԋ*  f   fFffffFFtF>P u3ËV 	
tVF  FU>P u3ËV 

  VF
^>P u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûT RËTaËRaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁĎsh3P1L!66ƱH6Z\66gP6g
P6g6g6&V6 +۴J!6
+3	O3X 66666P.^Yظ X)ZP.^Yۚp^  y>	uXP	 PX	 5! %&Y!	)&6, 		3	sx		 	&, >3&= t4
 vt3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
"t ""z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;vuQVWv _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ RQP,[RYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGt
t"u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVNFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvt
t	"uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*it/ppPvvPvvF^&*iu^&?%t2XdVZ\T`3jfh~` uoF^*&itfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt it)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPitou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\iu̓.uMhhtAĞrr&.hht'jĞrr&pvv
iu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvniupVvvj u
T t nĞr& \~P|z\P`
 P|z\PV^*&;tpVvv RT uInC-c = w.Zpinl6n6n6npkpppp&nnl`lppipnlppkppiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^it$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vviu^] qqrDrprxrrrUwVW3FFv&vF
t~ }F, <Xw$ FF.qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuCIWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
^F
TFFt~ u	WZguF u	WX&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>P tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uMuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&R=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV.3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;rvJ;pvp ;s33󫖹 +v*39j	tvvvj	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6l	% uN&6l	&n	HȰ"Cu׍D&l	&n	% uDȰ"Ctd&l	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋp	"tp	F3] UFu		u { rFGFF3҃vvډWNu(t$>b uS#5!bd[F#%!u߇sʻ 	FV]U컃 .8tK
Ir	]PPR.^Y؃> ur	t	w1uRUVV EE< udF bF]ZXXˣ		UWVQS3r	t	 P	X[Y^_]ZXX˃PU츱	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		ȎغU$%!3]UWVRQSP.^Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uztz^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;rv;pvp3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]        	              4.54  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                            68xxx.BIN                $ ( , 0 $ % ;  ' ( 9  * + <  V W V= [ \ *> _ ` ? b c @ #  	 Z  	  D10/17/2001  O                                                                          *2>|:f
(Db 6bz <FNf
2LPX`jt *@Fn@`	
		F	b							

4
d
z



  Pr6d
N
`
p
                                  A    B    > f *	      ?    @    > f H	      C    D    > f f	      G    H    > f 	      K    L f 	      J    I h 	      E    F    L f 	      )     -    ' i 	      P     M h 	      &    -    $ i &	      N    O     Q   
R   
M g D	      T    U    S f n	      ,     -    * i 	      Y    X g 	      ]     -    [ i 	      a     -    _ i 	      d     -    b i 	      k    l    m    n     o     j f 	                 0Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          [[[[[[[               (((((                  H                                                                                                                                        
                                                     %Y%Y%Y                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                  \HBByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               f   ff   2fff   ff3!.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2!)19A           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE      fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   	Lfsf ff   fT   )Lfsf wfD   f @ELfsf [fOg&`Lfsf 3vLfsf oLfsf Lfsf )Lfsf fLfsf Lfsf I4Lfsf e
Mfsf  Mfsf Cs6Mfsf ]LMfsf Gf   tkMfsf 	(Mfsf f   tMfsf W	nnfLg&nffffsf fsf f   f   Mfsf f~fsNfsf 
&Nfsf 
m<Nfsf 
LNfsf *\Nfsf lNfsf f   tNfsf lNfsf f   tNfsf )Nfsf Nfsf Nfsf Nfsf n$f   uOfsf  Ofsf 'Ofsf #7Ofsf GOfsf $WOfsf $gOfsf %wOfsf 2 f%"f   t
f<xf  Ofsf t^$f  Ofsf f  Ofsf f  Pfsf V   Iuf  /Pfsf (f fsff   f   f   bPfsf tff Ag&ufPfsf 5$r8u:Pfsf $u$f3f   u
ffuf   tf fsf   ffufQfsf #tf   )0Qfsf #8uf   uffuf fsff   ftLxQfsf U#f   t$<t)<t/Qfsf +#ufffff   uf fsff   ft(
Qfsf "<t<tfffff   uf fsf   t8f   ftJRfsf "t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tIuEu0f   Sfsf s$t<tff @   f 9Sfsf !2  +ST.cSfsf j!<  ff   f.:w .DSfsf ;!<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Quff   f
.f   2f   f   ft/Tfsf + < t8stff   uffff fs2Quff   f
.f   2f   ft()Ufsf < t8stff   uff ff fs2Quff   f
.f   2f   ft(Ufsf '< t8stff   uffff fsf   f    ft'Vfsf $t<s
f   <tff   ufff fsf   ftXVfsf uuff   uf fs2Quff   f
.f   2f   ft($Vfsf < t8stff   uf?fff fsfffsf fsf 2Quff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t.f   t@ t).;s$t"ff   Y2fffff  f~fsff fs3f   fu.fftfftfUu2.<u f   t2kf   uff   uXfsf 1uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f    f    f   AYfsf f    f    3f   ftrYfsf 6fftYfsf fftYfsf fftYfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f~fsf fsfLf   f3f3ftr2f   tZfsf Ktf˰Zfsf /<	rIаZfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf".fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f  f Lgf&fftf  f~fsffHfuff Lgf&f   ftf@^fsf f Lgf&fftfz  f   tf  f  f   tf  f Lgf&fpffHf   tfHf~fs^fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	]_fsf fBgf&y_fsf  _fsf  ouff%   f
fHf   t
.f@Cg&ouff%   f
fHf   t
.fCg&fKgf&_fsf 4f fs]uff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fs侢uff%   f
fHf   tufHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}.fDg&(σ.fDg&.DfDg&f3uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`z|f~fsfffsf fsf f Ef   .@ fffsf fsf xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@ff   f `  tf Agf&   fAgf&   @dfsf lf$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
1fHf   t=fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	Uf   taf~fsff3 f.f~fsfffsf fsf f  f   uf   fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
Hyf.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   f}j  jfffsf fsf f ".f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf&  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   hjfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfru  f Lgf&f   tfu  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f Bgf&f< ufBgf&'f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsf   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&HX  fLg&fLg&fLg&fLgf&HX  fLg&f̀  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f
  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   f fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afArf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   8sfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   fDgf&f Dgf&   f fsf  tfsf $f  tfsf f fs <f fsfffsf fsf  fӇ.AufH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	



 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,      0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  fsf Ȱ < uMf   ؁fsf $< tk<t<t
<tY UfNgf&f   uB>tHH3f  0fsf Iɳ 
f  Jfsf 
Ȼ  f  cfsf ǰ < uHf   fsf $` < te<t
<t UfNgf&f   uB >tHH3f  ҂fsf ȳ
f  fsf kǻ  f  fsf q$
f  "fsf 5f  8fsf Aȳ

f  Rfsf ǀf  kfsf ƀf  fsf f~fsf fs       D   @    L       @       H         `      T    G|   @ 	 T    G	  i     	 		 		       
H@ ,@          	  	    @      
B  T     L     	 D    P   X     `  D    X      P    `                O    O    

O| 
O| 	O A    A             
  @      I         	04
B1e2  
D12  
H12  
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @   

 
# 
3 	P	P 	P0		 	0	T
	t         @  4  	4,  <	    , <	     <	    ,<	    ,<	    ,<	    ,<	    	,<	    	 T <	    , <	    ,0<	    ,<	    ,<	    	. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                         0                	4 @       T                          d  ` h  $ X  ?      @@             A   \   Z 	  X 	     ?                          8       ,      (  *  .         ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N           0              <ff%f  $f$
tSppqtDffupppppqffupppppqf   fff   tfRkff  f  gffLggf^gfnf    f
   "0f!fupppppqg- fŌffՌff  @$f@$
= u$<& fff  @$f@$
и f  D$fD$
аf\af% = ufxEf f0f % ugffU../0./.fύf d< uffd< t<t
u掰ff䎊f$ff6f掺<ufZcf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4徠f  l8ff  `8 68DTD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰f    Q7sY 戰f   ff   f   tf ff   rfBYf戰YgC,f3f   戰fHr4f f戰䈰f戰 rfFf    戰戰3r"f  f   f戰fSc$f[f   f   3f   f  戰g&5$fFfCg戰" 撰fPfSfQf   fQf3یff   "fYsQf%YfIufYf[fXSgu   ;u[fPfSfQfRfWf   f3یff   	 fBf   f3g}     fg   r%fG;wg}   f_fZfYf[fX                                        	            !       p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8       8     p     -         8i        8i 0       8     p     -         8i         8     PR 
 ZXPRjl tn tZXPSR  #Z[XPSRjl tn t
 "Z[XfPf   .>puf   f  f& fP  f  ff& fXfPf   f& f& fXfPSQVfWf   ff&fGf&EN fP  D$
vD ff&f|u؃ >afP  f  f& f_^Y[fXfPfSf    f   f  fdff   rf[fXfPfSf    f   fdff   rf[fXPSQfV5t r !f0   &Dtvu;6art &V !f^Y[XPSRVh t8h h% v&  Ƿ}k&>	u^Z[XPSRVh t8h h% v&  Ƿ}&>	uZ^Z[XPSR        Z[XRjl tn tZPSRRZZ[XÃ<t  v    l   b PR+XZXfPfSQfRV3z fU x  f   fdV fdVfdVfdVf] jh Vl t'h >n th &x jhu f  f@l thuf  fn thuf  fs^fZYf[fXRf  Ӄf3ӃZfPSf   j>l t!f    l>n t
f 0  n[fXfPSfQRVfUf  f;dtfdfdc   j$l t$n t$f       ff&    f  >c u[cfù f  gf;tgf)gf+gf)Cgfkf0f3ۻ gf;tgf)gf+gf)Cgfkff]^ZfY[fXPVujh ^XfP   xh;ju ;lu   xfXPSQRW0  I3  ;3  -3}_ZY[XPSRV&  Ƿ} &>rW&> r>t u&>.u&>.u&>/uB^Z[XÃ t                      '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      4    戰䈽QjW戰䈽gǰfsJf}<Űf4fưffWYff f%"ffýgǰffHf	f ǰf!f+)ǰf7f f
   `"	f   f3f30f  0fkRfuf   f f    0f  f f   0	 f%"f	ff.4f.( f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.:f..徠fP  
f[  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      f&4   A14Tus14 /4 
<4   >/4rf<4g24  24 ( r<4  .<4.4V><4M<4f34f&4<><43<4f34f*4f*4qrf*4f&4f>&4 wf&4   ><4<4f34f*4%f*4742f*4f&4f>&4 tr74f>&4 wf&4   ><4<434.><4<434m><4d<434ff   fF><4=<43454,><4#<43454><4	<434f54f <4.4 ><4 <4f34f*4'f*474
r$f*4f&4f>&4 t74rf>&4 wѰ.4f&4    <4/4 ><4ur<434@d><4u]<434R<4 D><4u=<43404/><4u(<4f34 ?
.4<4  <4><4	r<4  Krs 撰 #=ˁ3Mg̃̔ '5JffSgf[gfPfR>14uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf"4@
 >14 u> 5xzyt
sfZf[fXúz.yur
sfZf[fXPR tĺZXfSfRf"4@
 >14 uB ;yM@t-
s(xغz,y0@u
sz.fZf[Ru	sZ         p     -          i    p    8-        8       8`        8i    t    8-        8h       8i          i  t     i       i       i0       ip       i       i  4     i0        ip        i   f`>w tIux&4&&;Āu< &>v`w G ϻrfaPSQVϋL	;t	  ^Y[XPSD	%ÉD	f<t[XfWQ f&    Yf_f`f  &y6Cs>yt fafWf  &&E f_`r r3 a`ϊD
$&z
ĈD
&zs>ytaf` ЊD
$&|
ĈD
&|sTf  &< t>ythfa6rfWrNf_    f`f/f  &(ff&Uf&ErY6pp U prCQfP 3f  f.>ѹ fgf&fff.>fXYrufa`ϊ&z D
$
ĈD
ϻsZ>yt|a                 `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva taP=	J  f
   `"	f3f3f   0fffP  0 f%"	Xt! ^Js! ô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tfg  ?   f{  +   f     f  	  f   fHt	f쨎tf<w' H$tt
f       PSȎػ       !    A   f    4 metR  lffft<Q  xY3gf&A fgf&A gf&A f   u   H$   :  /  $[XR j# l1 nZSQW    _Y[SQW    _Y[SQW    _Y[fPfSfff
   ffߋf[fXfPfSSf3[ffÊ$Rf
   fX$f[fXfPfSRںff%  fffZf[fXSRPRZȝXZ[SRPmRZȝXZ[SRfPTRqPfXZfȝfXZ[SRP.RKZuXZ[SRPR3Z]XZ[SRfPfRfPffXZ7fXZ[      a f  f  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgDf  g'gGgf_ZA`AfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ2/[X               <t ø fSQ >04tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f"4p   rg<uf   ⃸   Yf[fS>04tf  r	f r>PfSfUUgf*gUfUUgf[Xgf"4   G r
g8u   f[          68DTD   BINQ  YPSR+;wZ[Xf>"4 tf"4tf`f  f3f3f3f @ gfffCgftftfaf"4   f"4ufVfSfQf   f   f*4Srf*4fYf[f^QVWf*4  04  ۿ ._^YfQfWfVf @  f   f  gff^f_fY           fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX戰3ظ  м{UN NNO<uNNf1fff          2ø     oM08/23/04DDT  