#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BDD ROM)  - Linux-Based"
BIOS_VERSION="F.0F"
FILENAME="sp28855.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(Hhȏ)Ii	ɐ
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(Hhȏ)Ii	ɐ
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  M8181  M81 L   Ar o m p a  ?q . e x e     ROMPAQ  EXE  M8181  Q1   HIMEM   EXE  ]M8181  SV' D  8DTV   BIN  JM8181  [81   68BDD   BIN  +R8181  \0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
device=a:\himem.exe 
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                    MZU  @  j
   \X      M        
       M

      n  
  
  
  	  	  o	    `       M
5  ;        i  )      ^  M  D          +                       	 	 	               U   8    M
																		~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
																																			~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
			 	 	 	 	 	;  ;  S;  M;  1;  #:  :  9  9  9  <  <  <   				v	^	@	"						n	V	8			
 M
G  G  qG  iG  WG   M
MU  T  T  T  T  jX  @Y  ^Y    				z  R  ˇ                                                                              3Ðjhː
  F  F~ F F^J9 uvfv' }fvfv ~hh jGRP{Vtj
fvvP蘄
hh jHRPNVtj
fvvPk
 Ð3f>X  tf6X f>j  tf6j 逃>\  t
6\ UV|Ð  Vh jQh jFh j;h  h ݆h ~F ^v&v& =c   -!  - tHHt-3 t_ J  F^v&v&8 D^v&v& it^v&v&   R  R  N  R  L  >R  uR  |F  H  m-d _HHt- t- t- tf6B j RP`jRP}jRP}jRP}jRP|}jRPl}j	RP\}j
RPL}jRP<}jpRP,}j#WFF9F}-^v&&?-t^F&&?/uF nSJ=sjrRP|jVStjsRP|jVTSfh  j k~X Z X ujtRPt|jkVQuhh Y|jPVQFF*PFPhh> ^fh   Q\ uhhR |jV>P  tS<  St(n ! ~ 9  =  A  E  I jJj1fj}j l j ujtRP{jU		t(^  v j   l ؎f&frjrRPQ{jHU>N  t>P  tV  T  J  >V t>V u& & & >V u=>R  u	>J  >J   >V u3R Ht	HtHt8j uwjJulj?j.>V u?R Ht
HtHtHtIjj 1Ȑj#u+jRPkzjR HtHH>R  tD>L  t=<?h<h<jv
>H t jYRPzjIRPz>H  t7
j SK4  F >4 >N  t>P  tV  T  J  >V t>V u& & & >V u <~ tfj fj 'F  W=HtjH-
 -!- - - 
tEfUm
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >H  tW5L4 C= M- K- (-M- 0- )fj*>H  tj Q^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð<">
j hdh<h<jy>HT  Vfh  P FP|f<K  FDjhdh<h<jy>H t3^ÐFPsBFVhhx FPyRPhvvrhhx fvyRPh` Zrfvh` q ^Ð  FF	<">FDFjhdh<h<jx=*ÐU~uhhz  Ð~ hh h` =U686u3f0    8f66fh  f6X V= s6&G
 t	SSf0   f02f9r~"fh   RP6\ f6X \Lut뉐f66SO~ uhhz Adr j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPy
Mfh   f6X vj 6\ ,KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h` MS686tj frf-   fPf66q
f66jFPKq
f66Pt~ uF.~uF6b 8Fuc 8Fud 8Ftf66QkFPhPbf66Q ^_Ð~ hh h` R686f0    	02f0f9r~f66fh  f6X gR= j6&G
 ]fh   f6X f606\ I=t5fh   vj 6\ f6X Ir j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPw
x> tjJj1j f6j Lwjhh p j   l RPv
6n h	h| j   l RPv
r j   l ءZ +X  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  &  FF܌VF T   P   V   f<
S h<h<jPm
>H u_>?@T Rf<N  f@    FޣdFܣFhdh<h<js>H t>=uP   hHNu~ tV   Ft
F$p*V Ð&  VFF܌Vf<D FQCjDhdh<h<jr>H t3^F  FvڊB^& Fڃ~ | ^Ð>F  t	<&<Zhdh<h<j?r>H tjeRPo  fh  ! h	htjRPQF  @n +FHuF F^	&x&*hj*_RFn 9F}j vĈf<t<uhh CQÐ  o= t= u%F  F~}
FOu~|3Ð Ð>T  u#jERPnjFRPn3ø x&hjQhzt{u{Ð  DJ;fh  hPhvt"jGARPmjH1RPmjuRPmfh  eujARPm>H   2F hj
Pj
RPOΐFfrf   ffffN*+;B|;s<F*PjRPOj F*Pux&
hPh` jQRPiOjUARPjT7RPhh IOÐ  jF "hj
PjRPOFfrf   ffffN*+;@|;s:F*PjRPNF*P7ux&
x&
hj
{OjvcRPlju,j?GRPlj@7RPk>H  tlhvh` jRP+NÐ  D;fh ChPhvt"jGRPkjHRP{kjuRPikfh  ujARPIk>H   F hj
uNj]RPuMΐFfrf   ffffN*+;B|;s<F*PjRP5MjF*Paux&
hPh` jRPLjURPjTRPhh LÐ  F >V ut~ thh hh FP fhh FPwIFVu3vPfh  f6X nI= s^&G
 tF  fvBHO>V u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6X FP.F~rhh hh HFVtvPfh  f6X J= s^&G
 tF  fveG~ ujKRPcKhh j3RPKKF*  F 6u3s+tt~ thh FPdjhh FPrdj RPFP]dhh FPGFVtvPfh  f6X G= s^&G
 tF  fvF~ tj!iRPJ#.F~  F ohj
QKF  hj =KFj!;F~x& ܊F*PjRPJf6X FP-FF~s#~ t~ uw&
tFPFPj"RPI~ u~ tjjRPIF  F f6X FPW,~uPhh hh IFFVu3vPfh  f6X G= s^&G
 tF  fvEFÐUf6X FP,Ð  F u3F F~s7F*PjRPHf6X FP:uhh Hhh hh EFVtvPfh   f6X F= s^&G
 tF  fvVDx&

hj
9IF hj 'IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j LRPFP`hh FP.DFVtvPfh   f6X )D= s^&G
 tF  fvB~  j!RPF8EF phj
GF  hj GFj!R;F~x& ܊F*PjwRPFf6X FP<8FF~s#~ t~ uw&
t~ tFPFPj"RP1F~ u~ tjjRPFF  F f6X FP7u3À~uLhh hh BFVtvPfh   f6X "D= s^&G
 tF  fvAFÐUf6X FPA7ÐU  
2

p UvV>
Ð  >
vVF*^&F^&  >p% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젰
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  RhÐ*Gh  ~ t	h7FNuÐ  FjfvFP]\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fv_`Ð  FPNQVRhh fv`vvvhh FP"`FPNQVRhh fvi`vvvhh FP_FPFP#[ÐUvCRP:[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvxZfvZF
^v&  FF9F|^v&  ^UVfvfv5ZFN^v&8 t&@ ^fj <fh  vfh   !jWRPf6B BZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0VFVRPFXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& )RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRPyV *+ȃQ *P%jj fvvvvv9ÐUj=fvh 6V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7jRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wZRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0nڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0E׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6pFPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>p tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>V uFPÐFP	>V u^ÐU>V uFP+ÐFPU>V uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFpFp  F
FFFF  F9F~FF^v&8 uvvE~ u
FpF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh7htLth7hِ 1= t= ut փ>T  t fj hN3  F- ~ ujQFÐF Df>r   FF Ffrf   ffffN*+;<|;s6F*@N*- Sh8h*F*PЃuFv j h8h jЃ]FUtKjhЃh	h` j hlfj hTG=th8hEtÐh	hPh	hv~&IOÐI&OÐU~ u h	hvjh\Hh	hPjh\7F  F~ ujFÐF Df>r   F,u j h6:h2fh  <уu,- F Ffrf   ffffN*+;|;sF*@N*- ,Sh6:h2j F*PЃufj hr F; j fh  Ѓh	h` fh  {Ѓt"h	hPh	hvăt"fj hE
fj h6=uSh:h\t!h6:h2ttfj hzPU~ u h	hvjh\h	hPjh\F  F~ uj-FÐF Df>r   Fu j h;hBfh σu- F Ffrf   ffffN*+;|;sF*@N*- Sh;hjF*Pσu됐  fh ΃h	h` cfh ΃t"h	hPh	hv'Ãt"}fj hEqfj h6=uh;h\t!h;ht6fj hzÃ>H  tj ht4 4   - ~ ujFÐF Dj ؃u^ j hz=hhtF F~s3] F*- j hz=hvFP^uF= j hz=hNhe>V utTetMFtFj t:h;h\fj h6=thz=htÐ  - ~ ujFÐF DF F~s-F*- j h>hFP\uF= j h>hlh또>V ut>kt7j hIfj hT=th>htÐ  - ~ uj߃FÐj5փuÐF D^ j hZ?h
tF F~s3d F*- j hZ?h
FP|uF= j hZ?h
lhc>V utTtMdtFjt:h;h\3fj h6=thZ?h
tÐUfvh:  l:F.fh. U Lfh.   }Lj/gLFfh. ! fLj/PL~ufh.  LL~u
lN:OÐU*FPlP&L:*P
LÐU*FPlPLF*P:PKÐ  >L u7+  FV;Vrw;Fv	L ÐFP
uh h UL  >L u
FPh iÐUL  >L u
FPh IÐUFPh 9FPh -j>L th UFPh FPh FPh j|MÐ  >N tRFPh FPh FPh FPh j0 h l<uN  >N u&v*N"FF FF
FPvBl:Ðb=tw$-t-| u)n  >nt% Ðn -t-t t-0 tn Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? UnFPgÐFPtHtÐn	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  ` h FF )fF~}j v`tF`  F~s#>` tFPh F  f+fF볐>`  F  `>` t(^&9^&?t`  FfF~|F~s>` tFPh ;f+fFҐ>` uKF~}Afh   j FV^& ^& h.` F 닐FPh j FV^&^&`Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h bfh   FbPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~ubPh Zj FF  	&v FPȃtFPh	hv؃~ thh
hh
FP4hh FPFVu3vPfh0  FPfvFPh	hP=ظ U؊FPfh  fh@x hZh:RPhEÐfh@x h.h
RPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hwhV\^fh\  hXj 6\hIfhL8 h:hD  fh@ hh
RPh
fh\  h
f6\h
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB=
hxBPhxB.
F~|hxcB$PhxeBh   fhx MBF  F~
}Yhx%B$Phx'Bj2ԃhxBPhx
Bhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx ]?fhx N?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRve1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&v FPBtFPh	hv3˃~ thh
hh
FP'hh FP_
FVu3fj hvP(
fvfh  FPF
fv.	FPh	hPʸ   F CFPPj/U'
~ u3FCFPNQQj/@-FN

 PÐU>P u3ø  
ÐU>P u3Ð 
Ԋ*  f   fFffffFFtF>P u3ËV 	
tVF  FU>P u3ËV 

  VF
^>P u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûT RËTaËRaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁĎsh3P1L!66ƱH6Z\66gP6g
P6g6g6&V6 +۴J!6
+3	O3X 66666P.^Yظ X)ZP.^Yۚp^  y>	uXP	 PX	 5! %&Y!	)&6, 		3	sx		 	&, >3&= t4
 vt3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
"t ""z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;vuQVWv _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ RQP,[RYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGt
t"u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVNFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvt
t	"uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*it/ppPvvPvvF^&*iu^&?%t2XdVZ\T`3jfh~` uoF^*&itfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt it)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPitou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\iu̓.uMhhtAĞrr&.hht'jĞrr&pvv
iu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvniupVvvj u
T t nĞr& \~P|z\P`
 P|z\PV^*&;tpVvv RT uInC-c = w.Zpinl6n6n6npkpppp&nnl`lppipnlppkppiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^it$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vviu^] qqrDrprxrrrUwVW3FFv&vF
t~ }F, <Xw$ FF.qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuCIWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
^F
TFFt~ u	WZguF u	WX&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>P tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uMuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&R=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV.3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;rvJ;pvp ;s33󫖹 +v*39j	tvvvj	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6l	% uN&6l	&n	HȰ"Cu׍D&l	&n	% uDȰ"Ctd&l	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋp	"tp	F3] UFu		u { rFGFF3҃vvډWNu(t$>b uS#5!bd[F#%!u߇sʻ 	FV]U컃 .8tK
Ir	]PPR.^Y؃> ur	t	w1uRUVV EE< udF bF]ZXXˣ		UWVQS3r	t	 P	X[Y^_]ZXX˃PU츱	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		ȎغU$%!3]UWVRQSP.^Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uztz^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;rv;pvp3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]        	              4.54  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                            68xxx.BIN                $ ( , 0 $ % ;  ' ( 9  * + <  V W V= [ \ *> _ ` ? b c @ #  	 Z  	  D10/17/2001  O                                                                          *2>|:f
(Db 6bz <FNf
2LPX`jt *@Fn@`	
		F	b							

4
d
z



  Pr6d
N
`
p
                                  A    B    > f *	      ?    @    > f H	      C    D    > f f	      G    H    > f 	      K    L f 	      J    I h 	      E    F    L f 	      )     -    ' i 	      P     M h 	      &    -    $ i &	      N    O     Q   
R   
M g D	      T    U    S f n	      ,     -    * i 	      Y    X g 	      ]     -    [ i 	      a     -    _ i 	      d     -    b i 	      k    l    m    n     o     j f 	                 0Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          [[[[[[[               (((((                  H                                                                                                                                        
                                                     %Y%Y%Y                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                  MZ #           ?:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         #XMSXXXX0Copyright Compaq Computer Corporation 1989,1991                                                 T                             

Error HM21: Windows 3.0 does not support memory above 16 Megabytes.

            Add the /ISAONLY parameter to HIMEM.EXE in CONFIG.SYS.

$                                                                                                                                
. . S. G vO[Ct7=uC u=. u5.>  u.>  t%RP 	!X
u<u@.. %)Kr
AtHVWP
tcĀtrv
rw
.:&M rX3J.>  uH .} .>_  t.I .Q . . u	X33XP% X. .} _^RQSPV.Y .+k .Q =@ s.Y   .>_  t.Y  .b  .)Q w	.Q   U.>h  t-.Y  .Q .h +w3.Q .h .Q .b =  t 33.b .Q .>Y  t@-@ ..>W u.` .D 2.F .I 3..6y &. &D. ^X[YZ._  3&f 3&> VDu4&> ISu+&> Ku#._ &- &, t@.b - .     u.b - πuM..& `.a. .> t
` .A a.P.%.	X.6 .. =u.   .>  t.b - .. .>h  t.>Y  t   <@u.;t%.>Z t.>Y  t.;o r
 .Z 23.>Y u.Z 
t.Z   23.>] t8 t
.]   2ó3.>]  tX t
.]    2ó3Q.>X u+. .>O  tz u .A . u.O  2Yó3Q.>X  t;.>O  t:. 8 .>O ut3u .A . u.O  2Yó3Q.>U  t
 .A '..%x |3H@ t@2Y  3ø 2.>  u.[ .Y O s"ڀtGW_

и ó3 sڀ t	O 2ó3`.;d r!.;f w.+d 3ҹ
 u?uaaĀu:QVW33.d .K ?uwG;s2҃
Ǌڋ._^Y?ĀuQVW3.d .K u?u	;Wwu?u t u
u+t9u1D  DED+Euָ 2_^Yó3QRVWsX| uT| t-\D.>d .K =uU;tU;t
 2_^ZYÇTUT뼳3ĀuBQVs3| u+3.d .K ?t@
T|
t^Yظ ^Y3ó3ĀuQRVWU>ӳs5| u-;Tw`r 2]_^ZYRZtD+T>F>)F3.>d .K =t	
DED+EE TReZt"+D>;Fwt
>)F>F>F TwtEDt>F;v tt>FD>F EDtEDED&w&w
&G  &G  X+Dȁ% &G&OXȁ% &&OVWR.6Z_^MLD+TtTUE3VRIZ^tED&w&
3&O&O&O&ODȁ% &&OVW.6_^DEDDEDLM]_^YY\DT3.d .K V?uw;uuw;uu
^ÐUSQR3FFF&F&LN?\r r_FV^\
a rZFV^n^rG*= u@|,= u4^tO^tOZY[ ~ tH^]Àt^V&w&&t+tLG +rB+FVr2GG^ËǺ ƃ v~wr߃vڳΐ                                                                                                                                         |        3                               FVNv*,6<0HtPQR6.7.w.w.4.t.t&. . ~ w9NsNU ˺3 3ÿ|&؋3ۋ.F EEӋʋ
  
  ])Nt^ 6*, > l^ u>H t20.G.G.<.G.G.Z[X*,6H.G.O..W..GËЋ3d K ?uu=9?u4GG;r*;Gr!GG;wvw;s+u
t
E uUÌȣ
@H  Ā3 VWfPfQfR( f=  vf  vfZfYfXƋ_^fVfWf3f3f3d K ?t&fffOf;sf?ufff;sfǃ
fγft2f_f^Ā VfRf fZ^QVW3d K u?u
f;Wwu?u t u
u:tHfu?fD    %fPfDffEffDf+fEufXָ 2_^Yó3VWQfRfPfSsf| udf| t2f\ffD>d K =ufUf;tfUf;t
f[fX 2fZY_^ÇfTfUfTf[f[fX3ĀG QVs63d K ?t@
| tT|
t^Yظ ^Y3QVs(3d K ?t@
fT|^Yȸ 2^Y3Ā VWfPfSf f[fX_^UfRVW֋fӳs?| u7f;Ts r 2_^fZ]fRfZtfDf+fT>fF>f)F3_^fZ]Q>d K =t

YYffDfEfDf+fEE fTfRbfZt(ff+D>f;Fwt>f)F>fF>F fT\tfEfDt>fFf;v ftt>fFfD>F fEfDftfEfDED&w&w
&fG    fXf+Df
&fGfXf
&fVWfR6fZ_^MLfDf+fTtfTfUfE3_^fZ]VRZ^tED&w&
f3&fG&fGfDf
&fVW6_^fDfEfDfDfEfDLM_^XX]fDfTf3d K fV?ufwf;uufwf;uu
f^                                                                    UfPfQfVfWS3FFF&ffNfn  \  f^]
  ^[VW*_^=  3Ɏf
f6&gf4   ffNfgfgfggfXf&gf4   ,= u:^tO^tO[f_f^fYfX ~ tH^]ót^&f&t(sDfGf
f+r;f;r.GfGf
ffffffff= v೧UP    uB9Fu;~Ut~^u- . "W
 Î$"e
  3؎X]X]..fvf~f   f;NvfNfQ6>fFf&e>fFf&efYrf)NffNfN2.
 .;d r%.;f wSR.+d 3һ
 Z[u.?ufPfRfVff3.d .K ?uuKG?uBfGfGf;r5fff;Gr)fGfGff;wvfwf;sff+u
tE fufUf^fZfX= s.#þj
C.6.0.2R.4 .<.>	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t)R uMdI uD`@ u;>V  u0d0 u+%) u$d  u` u>V  ud  33d$= tr$ 
t$ 
u    3= t
r䒨t,&䒨u$3䒨t$3䒨u 3ËR?Z% ;u ÜuR ?Zu	 }  `@ 6 6  .A `  .q  ?퐐.q   2 ?at4 u/d+ u&d" u ud u
d	 u 33d$tR)Z ôr &&?PTu&Lu&Gt 33S &>P OLu&&> uf$<um  [ôr!&Gu&	t&u	3v 3Î&& =HPu& $u 3Ë9t	""S.[u.OU .w.O+ >A "   /"8!!  b" 8! "!!  ,"!"  ("`    t4>$ u?O   V 3A 1t.t'?1tt-9>V  tX  
À>9 tV  >V  t3>#W>#_     PSQRWVU.> &]
t~430.9.&9B ȎЋ3 .9.9Ћ.>  &E.} ]^_ZY[X. p00!0<rP C/2<tD 3= t9=@ sP.I u?.9 u2.9 . . u2H3B3.#.> &E
[i4+.[ rHYdrt .>C  t	.94r( .><u	.9(.> .#&E&M33 &. &D. Ü3PX% = t# PX% tt 
                                             3S.w &&Btk&Wtc&G+SP.D .F  .I .6s Ȏ G  DT .G 
tX[3.D .F .I .W  "X[&G  &G.6s .G  [03COMPAQVWSR+ u"&&Bt&Wt.I .W Z[_^VWQ.>u 4& Y_^ZDS CORP &.& u	sEE>E  E E  .I .W &D  &|
&D  &D  &D &D & &D  VW.6_^&|&D
  &DO,&L&D  &D  W.6.& O, ui>3R   .ZO, 3&D  _W&|
&D  &D  &DO,&L& &D   VQ.6Y^&D s&D_R.><u7.>W u.` 2.D .F .I 3..W  r.<Z0s3.+k .Q RQSV3rCs37ú@ .S .>9u$   @..6y w&. &D. ^[YZÌ.c
 .}.s ..-.6.>W u"VWQW%0 .>s % .>` Y_^.><t	!Q
 3YtRZ0!.Q . .  .S  .I  .+  .+h  } RP53Ҹ  ! N9v    |K9d.>h  t.>Y tg=NG.>[  t?i5>3Ҹ@  EH9-@5'.o =u@ Q
Y3 H9.>< t5. 3 H95XZy '=  tPRZX H953.K K K9K9ù  ts-=s( # ='s =s =d s =
 s PSQR+ك ~3Ҵ tu.!ZY[XPSQR=  tʸ;sP0!X
 3= wZY[X.# t@.d 
 .K .#.d 3.K GGGGG
.f .   .    rPSQRVW3Q Ys        | m  cQ؍6O,rIq,? q,5 6,e ! V3=   B  >9 ^DuY __^ZY[XS û&?EIu&SAt[Ê$y<tRL\ًDtH 2PS  :r;r[X[X2   @ 2Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C   `Ȏ3.- ar< r=.>.t3 3ҹ &<tr r
Q B$&[1.- Ȏ؎  ?   . .Q .a.-ÉEUu
%-`Ȏ3ҹ -  -3   --PXs4$ sBKua`3ێ..CCt;&$<t..3ێ..CCt&$<t< t.. 1aaPQR..Ȏ3ҹ .  -.3 - -ZYXð%pq
tt.d .K ?t
        
HIMEM: XMS Memory Manager  Version 3.06   
Copyright Compaq Computer Corporation 1989,1992.

$
Error HM1: Unrecognized A20 hardware.$
Error HM2: HIMEM requires MS-DOS 3.00 or higher.$
Error HM3: Invalid command line parameter.$
Error HM4: Cannot unmap the Shadow ROM.$
Warning HM5: Cannot disable A20
$
Error HM6: Cannot enable A20!$
Error HM7: Unable to unmap Shadow ROM - memory area is in use.$
Error HM8: HMAMIN parameter value out of range.$
Error HM9: LEAVE parameter value out of range.$Warning HM10: LEAVE parameter value out of range.

$
Error HM11: Available extended memory was not found.$
Error HM12: An XMS manager is already installed.$
Error HM13: NUMHANDLE parameter value out of range.$
Error HM14: SHADOW parameter not valid on this system.$
Error HM15: SHADOW parameter only valid on COMPAQ systems.$
Error HM16: HIMEM requires an 80x86-based machine.$
       XMS Driver not installed.

$
Error HM17: Move Block failure clearing memory - unmapping Shadow ROM incomplete.$
Warning HM18: The High Memory Area is unavailable.

$
Warning HM19: The A20 Line was already enabled.
$
Warning HM20: ISA memory above 16 Megabytes does not exist

$  COMPAQ Shadow ROM area recovered. . . $  Minimum HMA residual size . . . . . . $  High Memory Area available  . . . . . $  Total XMS extended memory found . . . $  Maximum extended memory blocks  . . . $  XMS specification version . . . . . . $ HIMEM.EXE is an installable device driver that allows MS-DOS 
 programs to access extended memory using eXtended Memory 
 Specifications (XMS).

 To install the extended memory manager (HIMEM), include the
 following in CONFIG.SYS file.

        DEVICE = HIMEM.EXE [Option]
 Option:
        /HMAMIN=nn      Sets the minimum amount of the HMA in Kbytes.
        /NUMHANDLES=nn  Sets the maximum number of EMB handles.
        /ISAONLY        Manage only 16 megabytes of memory.
        /LEAVE=nn       Do not manage this amount of extended memory (Kbytes).
        /SHADOWROM      Free extended RAM used for ROM BIOS. (386 or 486)
        /ABOVE16        Manage memory above 16 megabytes on an ISA system.

 If HIMEM is executed from the command line, the current extended 
 memory information is displayed.
$ KB
$.$/INT15 /HMAMIN /NUMHANDLES /SHADOWROM /SHADOWRAM /LEAVE /!SHOW /ISAONLY HELP help ? /WINNOISAONLY /ABOVE16                    ptlcascade att6300plus ps2 hpvectra acer1100 at                    .:Ȏ؎иB p0: u   L! C/=<umøC/<< E n ~<Jú>C 3  <S<*>$ 3X<ô <= tg=ú<=3Ҹ@ H9ô< t>tt	=Ãu
s; s8PRB>XP3EH9X_=  t m>3%H9}fPfSfRfQ<fY   fZf[fXfPfRB>LfXfPff4 H95fXf[f tm>%fff H9fZf[fXfQf
   f3ffYftfRfZ0!s=r<ô< t	=tú<u<fQ<fY f; ff	<3ô<R3=u}sXQX;|ȃ} Q 3R].!X
 ؁ 	
؃	 3R0X,Y        A20 line currently enabled.
$  A20 line currently disabled.
$
$  (Additional free XMS memory could be available for this system.)
$  High Memory Area available  . . . . . . $  High Memory Area not available.
$  Unable to report available memory size.
$  XMS driver not installed.
$  VDISK loaded, unable to report on A20 status.
$  VDISK loaded, unable to report extended memory status.
$  Total XMS Extended memory free  . . . . $  Largest block of XMS memory free  . . . $  XMS resident driver major version . . . $  XMS resident driver minor version . . . $  S.:33Ɋ  u Ȏ & >BB^ [.1Bގ6 &t
 >BB< t#<
t<
tg rF&BP3JÊ< tG<
tC<
t?< t8<	t4</t
<-t<?t)F& rF&B<<&:FWSQRS3Ҁ<?uF<
t!< t&?hs.1&B[	[&NZY[_<=uFt"r=? wt
u.o ú
2&B.h   <=uF~t-Sr(.;Q w=@ sm2;.h .[   ú<2&Bt<=uFk3trk= w
t.K ú
3&BO?<=uF6 r<oft<onu!/)Ȏfr
tr
.<ú|3C3&B  Ȏ7r
Er
.<ú|3C3&B .C   .<  .  Mr.9 =  t.<4&VQ  u<A|	<Z FY^SQRV
 33Ɋ0 |	wF^ZY[V3< t$<	t< t<
t<
t<0|	<9wF@3= w^P< t<	tNXP< t< t<=t<
t<
uXVP3ɬ< t<$tAX^WVQ3ɀ< t<
t< t<=t
&= tAt|Y^_P$p  q<1t<3uXXȎ؃:
6Ð999BBBW9_9k9v99P99999@@*A@Q@Q@YAdAoAzA                                                                                                                                                                                                                                                                                              	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]f'Ik 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'ƛ1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,ed !"P.0S1t	C11(ppc1@%#I	,vInrypD	Shut2l/down` P~ %0Ѳڡe [PIN: [E]Nxoq left@
ERROR
wY`haA}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  ffff0 ISvݓV Q'  A  `          > o    T   gG W e M AY 9|@. 05  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .h*v PS $<t4r g[X  DisplayCompaqLogo `
u1*WGDWrBgWr<W. u)(.< t.߈hP.ca Oo !"$#`6Ph	rAV(< 
u^V3!&  ^(P*^ ''2 aSP( 22< tFX[úB +$PQR  ZY/02?3_4 56789;?<_=eAGraphics f`pt<.-  D.&.ރ6.u  #l O .PAtELrsCalling GetIntelBitmapAddr r8C vJr-+D+\  r@ .hXafa0A PR1.3PZiX@OOA.PQ`&Fa`.>OuhǲPP)XhNr.>CNSÿfPfQR	PaintBG A.fh f3f% aZfYfXeH URQSWF^
D= F\ ^^F_\މ^t
;v F;F
 < uW`b < ȭ22 IF t蘾eee~e빀c% d8t
`  euPj Ѓ;}
+V 
N JZ=@euAN`5-_[YZ]`PY&X&@SPQa^ kPZY0-UkPkP]]].uvw xz?{_|}~߀`Q0]h *Y]PeQwLQDf&YCC7PpKpabݻ  ]a3YaPnð@SjP3pX?[ADRY$&%<GP WP	 ff? t@  [ht&er2brsP2`Q24`Qf3XW k[WS_fRU3S`F.fGenuuhfineIu_fHuVf=sL=r=vPtK f  =   	tŀuvrr{ f@3t5uZfDY $<@tK<tGFrH$u6f5ۊff#rCt Bt	]fZf[
ffȱ Mˋh
f`^ pI 	 ߩh-+hHh5Nؾ BD׹ 0@"0rF1z""ؿ3:D@WhoO׶@߿EO`Vzꐴ^ ?#%u00U= r&#+==rҿW>&_<uc"&3 1&/7
, fgh  0 pqr  <ABCDE xyz{|}   γfsQfRZR &gB ro
&  ʯt0Bʫʭ0YQSQV3
Ê^Yw[.tD.FuN.PW#T _XUWfVUSW! fv߿ h[ ޿RF_~2p,ك!IN3d^
u
t_ӋN_[]f^_SV h²^[þ
 0OSRZF10=ROM Based Setup/# EHrHePrt 0A
  OP$  }
 )aN
SuR  p  h"/TF12=Networkrvice BootWake On LANAttYeHto" 5D>2W Ƒ- r	S8 ۱1uE_ RԲf\right01 q6 塶sRV3DL<^hZ3%as q uAWPu[s	rsQWVRЗuy3ELೈNF 4L3؁$L?	uCFG~N@t`Gf`h!14L"v^h3f)Z^_Y[Notebook hard driveH
MultiBayJDockHbC
b
(top)bottom)left|@
Flopp
  USBC#D-1ݯH|!SuperNICj11$2 3o% &'()+?,_-. /0124?5_6789:;=?>dop?p?	p?
p?p?
6PATPArPAPAPAlectDeͿEF͹U@ and mothe hplqyour cho.  PressCJose.Seconds until au atic defa`
 start:   Vl($O'?;P!ZipC>`t= Dr= k\do h"bS0ô0."&t ( Wܶ 24L3$L؊' tA<v<st1H& 2W2A]dQXYArb  s.D
*.F .pa+jjj(Pjf #Y  aDcz ߹ 
c  1  2gU
   t0W3H2Ɋ <tF8tF34L $ Z`qcdqURVQ.,.L.T^Y^Z]lSm._F*[m݁nQSVW/ s&Q#.<.-00?00.1Y_^[YsQ qSu hP" St0Tt+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu `2bzXʱsc¶d{ naDr
;w2Ҁd{aDJAlgFYô.*F<2ufQW0wްhNӷ fhą h~" hqӆ_f@!> 1;BFJ!o h؃f@ 6tif.fffȵ3vO2Micro SmNCBus ReaderT PW 7.g&:u&Gf_g&wg Oa߾T_ܤ  ?  O /  BPhPCg&F Og&F  u
hZvbg&F& XPg&Fa  r?a@ &   @ r) a"  X޾Ǎ~ع    vaQRV`DT r&%w^ZYfPfL	
"bLу  r?р^ " Gǜa$&Y@(  rP N(Q?'CYPQ2'Ar ug&9N(tPjmr`r[ ;w}(;r
֫	ttǫ`¬  r݋BٓܝCPQGysrPRY1 Z1.>oh	\"fPS@ǀuh3"<toB `.> t.ÑWf2f?\ff@_Qf gf&=TDSSu ǋ ff3gf_uf.>f^f_YPıQRW5r_Z@PVW TGI$tu!t쿪u ܺ&_^ H$ f3ɵ`6|옍A, I vخzv I;v~aSWQRHuʀPpq4bOXZY_V@A<A@3ɹ2 u#¼ P% = @uXu"V@%a
RC x@    @P`PC d `hUT X? `q	 {@@P쀀        ?QC A0`   1n,9SC0@4@8}(@;*  .P@b ,P :8ch @dP f   !@      !qC 6 @. Uaw /. p. ra08 . `REabh	 NN  ON!N 
0N`*
a

Ga
O 
$
a
(r
Ca
O a
3
@a
`ON 4
 Na]heu G? "W߿` hfQt o&QMO@fYf8t*쪃C@t&>Q tRc ~rE^(&Zuf3C hoO}h  G 1 < t&qG B3'&  !ma"f3(2*f&Q uf
ffKf&&&fC"-0A+')?*P+++#+3@,#+ ,whl`i߀@!2 !2&&0SQ"W3r`&&&@4@4ށ5Y[$fPffRfVWf 3ffCf[fKfSF0r!X0а K I+r{M"W_0f@SQVW龠 u3_^3t?3p}!Xf @M r;!7u'P Ϳo" hShWXChMkPRAH U8fW Qt% s	 f% fff>%?fh53ggr p ; pu7)f)Pf ~/u!Q/uQ/uQ/u	g& 2tx3KOrnfQMǂM@PUMP ~/uQ/t SV	 ;%QSGf&>^ _`b/cOdoefg hik/lOmonop qrt/uOvowxy z{}/~Oo σ/Oo ό/Oo ϕ/OożPAIf`f.%%u hP#5rWrRrM%tffA| pKV t#Br"p2}#   / 'ߚ \y> ?f]\  ?fU进r*6K  R߄ Z rGq~ Kuf]@ a8 rCF+ @!3Wcg&8E t fEGH #R]>K'm r'>%> t48QIhLM VPf&H\>W{ r^ r
  GC_>>?t$A?$wWw  _Wl  sq_  Q q0@B ? лð 3 S Sp' " TPß scAQ/AǊ?QWEǨuptPGX_Yù
 d h/ƓExs@Y
P <uAbϭu PR? ;? < uZ0ъAҁD t	AѽԀ eҝ<|<t<t2<tH0D[\߃"L
L{E#L޾륦#LfߔU
뿈T2+"D
D#DDff#Df0f`Sn k 0l : 1  S  T {hk T 1 @L j	 T
 Aj `u
 i h 01 `j 5h z   So p*i m w S n `h eL N M  < l! pX" l# ( IS$ @$q % V&Pj <h* d _ ; W1' ) y+ p[, ~Y- / 0 1  2 M3 l= > l? U@ ]mS ơA sp l5 1m 16 .m7 WS9 ZhG iMH P: 4 iC 0D UE jF &1I0J `O. 
K jL eSM SN lO RXP CmQ ӕR HV ShW zkXPY LZ 1[ gb 
c wUe hg 0\$" f")0 @ ؠ   !C  f   3.0π. ?.DĴPX% hX@ .X=X@u
_^rYPǊظH̢	̐
y9	PW=;f&E1_XhXThG"h! h+vv _H  PQq0> 3_YXLhc{SV2h# _hă1=>$L &=tGDG Hi$h}ss	I KO   ! $!f` TP *hT uOpDffa]7vP2F X98`3 4=ؾL &>L&DE{&&D >DLu kd(Y)6*׾ (Y)6*j@ } 2B}
Ȁ}	0> L33S[tS[@א23[sM43 tthۡCFc&s
Jhca'hDTD
ϰ< 7+DuL
p
E$<u;D
@sd
{#=r&_ u=fp-` uL
 6 6L󦀴uL9  @X6A &uhp^s7	\
b@:u p@ D&}?u = t&Eb t >;&E^D;&Efw>Ht6Hj t.& Ot	&  tLK&Lxu	<o\	PSqK PK ?K؍>!L_3& ?QW>"L	_[XHt+tK# M xtL  t Tw\迸D@9PV!$!"桾tXh{1(,q&  g^X99h9r!L	vTt
vw*V`W9{VP/~"L`$<v @Fu<]Ra3  v
p
u$@"<u@P>ȷX\PRt¿:1thG4!Dă ji=;ZX0`22ǿDL& +t54L=$LtOu90: u	0t!s9 = ur5 hs}r
t!O&wwwan׃/3`0hs?z  V @A[Mu @A}`0~^ z3f`JG@RMf_%{ְ}@}!U!ߚ   wM&egWʃO&MuO OfG2tM1t$O1t,t"OzG%{r Ǿp-MЄoOg&M/ @yZPi
P2Vha^G__kרtD<uLD8P =_7D D	 d
zMQQ^b;tS0rG&}	r??23ht`ha&EI$<	&M&]V`~.'	D%f rL!t]SϠ6U{շF 
~|h}s	s܃]RRn QZW&= uA6Pk[)
h[
 m_P
t  U!w#w !#` Ԋo#=hS5P ;.-.M!]NPstI ȳrJ;.58vhu@@dB 0!ߝaW$
1!D U
5Y# @[X_Ë
`PS@5[X Sϲ1!H50bLR
`!Z,<u(fPfRffCPf,ZJ vGdu
Ȼpχ P^S1! ~Ƽу[aj$ А@V	ڿSQWf3Ҡfe
<u	fpdv@_`n`֎f߷nh[[73۹ F
t):u%DLD	& hp"4L & 	 ϰh%"s(4L3ۃa93 
3 ` $L VS : !u 3#tV& [9 r6Qi- r*0&' t&f$+] '0k
vk'+ QQj1s 0RµmZmt0?t h 7 0aYQ?q=k[r=@u(C?% = t!/@Y1S3$L+6 
`JHH,E&NGEQJ,Gr0>phZtxf1V @u$P<PtRukZDfpj]lOrZ>pZ^0WV 0  PE	X@ Px
Qr(VW20ƀB1@C?!	C@E?r@D
ߋ@Cu,u`
@

+&C3ɿ23&]t0
t&
0  fb5  Ӱ(@T
uG b: >BHb? u
w ^PRW!&uA߈!&]!&U?
t ˀAI#]%_ZXb3һ -w62C.u
/u
yN 2hΓk~ )_ u߸^,0'`nҀ/?0_12Z>u  'o}  طBfcf3fZu 3 Q>K@Cs:yuBE&8Uu8P9]
R +B&U
ZK7ؾB@8<ZAfYB wqr h*LZ|b9!tu
AĐBb9Ãh}kVh
<tvZێûPpV>`^f0x  XK~EKD

A@NV?3QQGHHUf`X FwAE.  fafSfQf.;EfWfff#fYf[VVftGf    W.EIgf;t&fY Z,ZS[	ZFP8f^X`2rۈfaf``f faP`3_X.>0E06 .b[Z_TACOdFL>d Q[d&eed	&e .,E Yd%eΠܣgF5ei.E fFf.;E`oo3EF.?Ef.>;E 5E.?Er t@c1E߃tTtY@c2EtONpt Zo\@SIcVfB.qsfg;Vr?T%uYvZwxܠbti PYQfR[fXfffg7^Yr. o ,E]f@m.uffHmo3fXf}Бdf3rsu[vs?Izs*ZogVf+f;wfff33Ro҅Uo7EY^['R[[SÏ$.pZQP\ɠ`[333  QWύ>ppo_F
3}5߃upoJE#ȩ t0 t0 A7 `st
t} tWM_ }q   ؉F EF^V p SV^pQP&tY&  
`< tr&\]&\U@
&mNd $L
Sۋ؂[u 	F& 4F^[_2F FxQWU}10VWϋذЖ' HLr_^Y[XWfQSgɁ W fQt
!p[fY_` t =$PnPu2MءtaË6s } tp( ` j 5&& o_SRUQj@6Ŀ^]Z V` SۈK`^X~p*F
O  t#]poPTF ^FO d3duhZKu`<Uuùh3d {`hn4d&qtû   h9߻& hS39PhrƜưїǰ`ǝX!$!B   ¿BsSoB 
߰eh9   teNt 4 נh#G)` tKurՀ& &  
 ͐
`0h~s <t<uuBĪu?1*`PyhǊXhʻ % P ''P$[Zés# P柀Xz#@áMtnUP`Xέ} 
P`?G  _6 3 wD1۹ipÀ   ; Z x     0NPS`^~VbhL[1fF3.OeN rׁ s
0ވBFuр~2wFd6-00
<2wd8F w( 8F wI N@^F ;t
 u@mF^KہO.~r@V»  aPxû< fPy	p	f	f @ffRfPf!N'
 ffFf3fv1ZfFsfBPf{Wf R1 r9@^`f35ǿ:fы faÒfPV3v޸rF3`LX

S,0<	v	,$}Q.[W D

Lf^f R
T
T #	#
#f_Cf Ўfv[  P!ﯺ:FP
uof^fNfV_f^5 PrVR 0f$P$V!V"\F !hL!$`Xb
àff  fffffXP_,4ѽ !6f>f>f fagfg`p0R 9 `T%2 a5P*h	3EP,3SVW03fQhSlYI2uEqVth1 5/3_^[ø3PPRh!7>?? (>*>4>:>@>D>0@ f!Qj e  ;Pw hC=h ZXo>?R@@PSSꙻB0` ػ7   LA#Rpq$J >qK p3qð K&q"ɡL KĀu̀LKNt!%O MVր?tU֠7QuU`K%8û 3ɰK<KuPa;dEhC=_04s-U$dqH - t+==vPYP ZtPWa XZPہ?UuC33Ɋoђu u0' PV$ 33 Pf^ XeJ<dV&& &09t hԃu߿30U h
t[V Ȱ t
U֪ŀv#tW̰j7kkh75QPXalv[pBq8v&> 㟸 hΣɨ`t`t;_P3phu? $h4
#dV衶  s0~W uz.W0~W t2h4`!{蓭uP賸uK 
wAW2 Q  hPɴu= Dt= tY	Y{W^!U hPfx=s,uwX0<  1hU, `KvT L 6if.fof0,ha rGP?R r DRW3 hثՀtt_Z"vSQ |Drr	?!xxfY`pY!.BB <t BB2JݾxYௐ  8uQ@A`23Ұ
ShyVt0`́ y autОвi at]U [aSR  4V@`1-V1a h{KC	 hG
 "B02PaԀa$8uXRPU2XZ@QrtwvYu0ѹ }R wZPQ6 U2<UD@JJuoJ䰿uJu󓱧tC+f`gJS@ e h̸ u
3Ҹ w%vv P
 sC)V uPف>D A 
谁0@t0޷?hNt$h# 0KBO

h0   HH&i &&g & & & & p t0p @ǻA5ێû0 \ 
 q;0S1&>r 4u=fSbf B  1ҙ8f[P     f + },]@",]j	r>@s̀   ٕ`ٍ ٙ`ُ 
 ً "#ۗ 
 Uuo ݁Aۥ t&r .s _t v; ګtؙ "f%3f@O  f>  <  vPB f) '@  wf fQf;.S @!a۶Aݖ~`uft@ 뽟&|}~ٟfr݉sAB #b XP
8t"*eP|.xy{ 0G5Ɉ.߈ n21_ >@/sPj @
Ae.͡ u	t R.O߆ 252勠& ٧ ~sTh ًP~hqh s(  t>ar8h N$ f%д"` j j hMcXX1UGBʋzSh{ɳ9h" tE2s s1|1
x{0y t #um1
}/  tE. z0 
U0   tU!E@`6X6c	ta	@at aP[S09pv%ؑ^`١ D ٣ s'(t!R B!"[SW&L 2 㛀>u
b 0dBu
>@uY >Pu>L rp'L wf@rHb05U!];s.L 0&O  )WQSL O 33ۃ s,@Ro[Y_h І@u$%ҋBSd@93`<u-!f[߸U :'tu
9  w@"R(t(uL 28p _[WSPR`ZXL``*,6- &23 G&C=2  &E=f> >d?= r&u&5A4==X&>AG GF?A~6n@1
&@X$OO&2uG&2%& !+Xţ ~@[_*pεB ̙0d 0L+ `L=^`}0LMt2!vSRUfVЌňL 	f&7f u&Z&?Zu `R G&~!T &0dtL *f&6  80+t L "U2f^] VWf @  !XfAW3f0߯ OOf  1c[r_^0WWV p	`
^!`'Ɏ318 `. L DTDo   `\|a 0 ȳ h`.dw `l  Q
 fa (  fW @z`. fL H`. fA P`. f6T _W X2e`"``. fdؾ\qXAaa|\ƟD Pi/SӰ/ / pp StppGsq[@vg/
uh X÷Vhd!!4viw#!PxPQWh73 3s_Y uz 0XPQ= `t_  @fYX "|>@SP{
&  ff& X[@h  @W pr  Òr }`i hfRf JōOFfQ   hLX.\V%  <t. i~ tq.Ԥri."D.|u.:DtSISwD:zSr5+Ss&Sv
uqPQj
c\)A<PQRau!&U$`Ȱ hc~SQW@a$a  h~SÁ hq3ӻ'>֟_]2 TCA6n @QQPC@0@;uYð!$PPh|sf`p3f`	 3vĿ舭Іu6faÚ@i.sohpF`y
x;tYchK#.-gBwf`f`+  f%=}Twh3a8β/A@e>$L:*&}t#Mthyct~b
 uu F3d ĺ
  % {VWU-ƚ a"hx@ #EJ7sr&{ 
úvϰ ]Յ ʮ 0Y4%  0b `kՅ`Sa0gPDsP.2X2G# t
5d|@ M}
B}"|ðd`dr`aɶ m`a@:Q:BZPi& <`s$3	 +3A,`T `&XYJU KW @ 9FPؿYE0$&؁@ uM9NwNYuӃ~ t"F= wtg% @+w;X@~D@hcԯ⑸%r [ƚg
P" kX\E]w ]U7`Uh㚑    !	 @so a `7 `ts殿4 v t>0u *o䎨67 aӔdt5 t2y t tf2f
 ΰ03Genuu#fineIuЩnteluf 3{` 33Śt/7.6;tU mB3@ٔf.p hff`f.pf f .@f.6pD
0^hÑ*P$À:ffaW^f`i  ,mƀ%$Obf6 ki m` pv1xf@ƪĬ"|f`X t61PfQ#0/fZfYSr+E  =u?2;1,[ñ p0p Vw(ߥp0 e讀43gwf`@h,8r600s1r2s19:2s ŉ#=a*8faya8'=tL89f   gL3^;B13,?2k߀FF	 ff3Puf? @  DH7 H*tH`H ^HHHoPXÌ  M C"%N'% C< B<DPUODQDQ@Q$ PRRFpGˏ 	
3@ @urG ui83U@s.U;oWUnZ
?#YYY	Z Śp TuҊ؀޺a*#hPxt'M9cdR*ePjFrX?M~r  PUX@A|SQ 32Pue"kڔ0, 6xif.f?ff'fWh:!3
f`X q `"	  "	+@p,2% p,[3fSPAu uXvAtih$wЩl@uvv wxzfẒzv#vwfP}fQ}UwxTw~{	pϻ ;sQSfrP+"vCy2fƃ {0fXff
 qw[ffpY+vAШq_L2_&e uZ=PrUߋf#% >LuCf*.f=  t0a t( f`Ƚpf
!0"?`h"UёMd PV#f_Z $Kchct1

36x @ hkJ"hF ƿF hD"hPg@Xt 楙c hn
}ళ3؋
P
>t. h1#@uKh; uݓ .960% < t 
t
u8ùt$MR 䈰fT2u  w & PPQXt'vt
t@   h9ǻP% r/o h"hP>u   hͶ"hs?-&>! rr~ԵRzspZthZhuul	r`	 `+Zjj bp6uS`` FF ph"h ru=
V@ V  >t !$!$< uҵC` 
N<̣2<ģƾ	$"3`A7y1h[@u TYP=`u@t e@
u2Ɋ،؎ Ȏ؊t<u
e@PȵoȋE$<u&w $t՚nFbף/EL  N L N v ؠu   t  P[Eu
j jGgI(!!2(<!`bpV Psu$0t$~t!.#K .t4&^P<r&.w`K3.\  U.\E.d b P p W	x .|_DuQ&~% PPXӹ
 ~.:t
 ._
vaXP%8Xr6%ȸECEp    PJNL p      QKOMp @t  t P(.DG H he3 hvChҵ h AE^  f  %Pp m oĂ 
v %&.|t&ư
&sr"P$Q.:Dt1^ֺKuR
`E(pk" sR	EXQ&`31C `H ƶrUr`2h!"h_ٰvaVRQShuThԽSJbp.܍68u,2
t&6@t2ך s `'[YZ^Soûjsl<?tFhoO&Ejjjj Pf &hߴ\ {hzc$f'b(t = ;t= Dt
hGh[ pWVS`q
螷[ 𿋑.u"q,*׿OطhUA_t`/-0>J=Ot1 k0Ծ?#i rhO@#i4p5Bsﴇ^arÜ0ſ!ls:^ Q% St-$p<pu< 7 4 u1G ߷h2"h @@0۷Bh'Øt<÷CEDuheSSpR? 8m   о3YaaavJ߄U98afg  u@"t@"3P&&WKXfu33ff&3 uYFϋ5mg0ѰL `5[QS?  :NQS2 _ ?AQS%a 	
1VVVrV짋F׿pVW 2_2vct"Z2
u
2u 
 @2uc2&&ߋ&E`&e?
td&Ep`&&Erb`Ec&E<r&}	raaaVW^2Z^2*a
&}vePݠ߶h}PRQ3Z7j
%jtlY3RPSQY[XZhn$[uS5
g@vp _> EQ Q#TXYﻀe->7: tOtTv
*6h7)&&  t8Vt'[ u q,6 }ҵ6$@$ R& && E+ 
p`dպd{e`P`  XCIU @,
 ` . BdB把䇿8uGЉAЉ;Љ5Љ/Љ)Љ#CBЉ󇰌ь66PX ~х@ApuBpCp֐БÜVt𻰀vpvpvp蝊`<;weĿSX؊H<wM3ɆQ#"XR< rYыƊȊĴ3Їу?ڕ *8Z@ɄIhu@tJ	2fpP⫀k; 2Gѵ_f&. "  &k !< hP[Чu?$f&PBÊ$
߀ q?u%qϠuhӠ$档bܰ&{@Pf  f#f#f#f#f#f#f#nGIfPfSfQfRVWb܎h<)f&GLxp%{ff
fhSf3f3ɹ of0QM f+f ! Kpu*xآx$c3ہdsV4C\`y a^"_^fZfYf[fn3h)
  ``{3hD)DLtK4L$L?,1tu*Sg0 t߀wt	MtzuG⻹ D
  [u|M u
,t	 QDa`G2{ 揀 |s< |&	3yt`MZuz կ i&;-&{t
c}dRKBC Kernel: xx.xx
 ` ؾhv   t? pڍ.`v3۸ 2ҹJۻx%aVWQ	ٿ ^_^7BI` h>3hy u
$<ur r	.1 f3hh/.0 %
Pp3=dw t
{h%}gT{PDhV)=  t^bwY-s.>0Hf_=9{ t&Sf u@? o > c \TFd;e;f Fc~ck7~e uQ C9  h$p(
0>FPh>BFe:Ff`@r,  h _Fd@;  Q 	:  <g ht%hTasf`Wp[Kh~u>fB0l"5SCA[t$ [ hуNg r@nf   F^ï%P XSĻ  y ,p   h![t(t@t,֟ p,կÂ ' qht
{úwp."y**{կ/.%{<4{+Ë /U2NfQdYF :uE1n]!1Pt
t
u
t#u
otN `t"FFa*  u3! :5tFFdz_ ulm!`#F: uY"P#eob + #u6F14&$e$%FfP#f6)`@up  jjj(j	Rf 	UaURoh#1+2   ^p%1/ hZ]RZr@q  t0~C˿RQ QYsY2{{$
a32 _!u$pկ5Zf`GtB`u#I蚝4 *s! ƀu.>2 %fa`7Rt9k  m Nl0!tn ti )DgAP sE" 8>Hh	3P/#rho p %Q42B ==ZA0!?.3uQ$<u:op8ro"&!WtBT t2>BT t?nt ۊ΁<P uWPzW*TGPP Q o@ˢ$LSwQ 3Ru,SR腤[rET	ˁ<Y[C? <ff<1`00xx00`6a||c>>>Qr$.wRgtRgpH~ Pmr8'G ܯ<a7= &2hC  E korBo kEuN DO M0r)0q/sA ڭq0F70
j3 aUfV3vCDPDQD }7p	~f^]`
|#`=k%'
PduXT1f16@1 88 'Oaobcdet  "..v f%p@p6_FACS@|O4DBGP4HP HP0890  !CPQR  8 ? APICZ?["m!1
 2 		0
 gPpa3	 0Oн2t (upPUӜ
 2Ϟ RSDT(  #f`ht3hӻpf  fķ$fo  gfFgf  зFPTR ffggFf.^$.˙.șf.ę忿tgFm𵾻$aN~$f+0fh5l2s?43ffgf&f.>ęfff(.ə{tș2=  ~( N g&F	f
  rg#fffff+f+.̙ u4fЙ.>f$$$
P Xff-QñV3g&fFgf^fY[P1!ff=TDSDt+St#PtSBStf=CIPAtf=PGBDt*`1Qr$Ə< ur04bRUfQъ̓2 twSP)3rDr vǅ~;àAptg&P.XJfY8]efWfVŴ`Qf&߀f.v@̋oý@f fP̫q)Ȁ$ 4 
{ @-@ff	hΓN$ pf t=hfPW %騷fXIpF gf. ͑ Ӱsg&hS$Pp(ΐѣ_5V	șə˙ z|r @̙f  f%=  w@ǟDb^VRW D hث" o hN" _Z[fPSWtS`G[fP3h f&L sfuPQp Lw fXpV`xشh4" 03f0f	&?  / 6[Mu  	``	 0OGMfa3M[ P@Ŷ1
U1
  P M>wM&geE E 
uM
M0GfEB
tXA
t$OA
t32t)O$fMorþ0mMe&Ma࿻   'ø  1^T1mW f
0fh:^Xttտ Eƿ@WE E葹!!_Fh{!/ێË̌ӼRQYZҏh$pVf`FF  h4 ]up hT! w+$w+(w+,w+0w+4w+8w+ )qcÃ9FtFfN1+F> hɀ51351(fa`CYEp13ɊMh
t

h6B;rYua'WF( ^@cf fN`Ѹ< .%=N\f.9tu @tt_h rfQPH_Grf;^uf;Nt7<~=fAtD U
tF~Y_ꕏɐVfV <t> 	i.<t1!5vuEh5`,,׃`LL^_p0[GK0L0 u,hRKI..D+hZCuMVWSRQH, 	pif.ofaҋȅ+Z[_8fS!_ftA"pW  u
3AX  t'gf@YGhGCG$<lDCOMPAQ PC Card Smart]ReaderGEMPLUS GPR400PSCRq b]]^_LB REFLEX 20_241 PCMCIA_Reflex b v.2Tcc!]r$dHP\c  aZ@g&O jGd uqj`j ȳ rLfwK sr>qjG	 .DaZ
qjPoO@.d.D4fƱl_ PQWإ 0P
G.g&:uG`mY.5t_YXÁ8t J F`mNfWrjn@OgHnn
nUnnnnཁ#ZG f_` S[ 9u#x  p~~uk .1u  Ўߍ~rp&tj`ܐt_& rT r&= us J6>
qr/r4.1؋Vp< t ^OJs 
t u v   hǓ_hCw@sЌkZ%BhÍa'1~q6rPtI	y |
p
tQ&z0Í¥GYwV_
z +F~؍vf fDr ߺ+A fLs-<t(<#0{PL^ZY[632t
t
u
hVS#trt
<0r<9w*tM> ~SQ Y[,0>?E*SQi;| n1tu$;of`3p& thӖֿfvh[sgf9t \a2@   th!>BगЬ@gfVff3ЀO"ѷ1VRfHL{f!
޾Ph3۹: 8tCrP #trAhysf @u \ $  00Z E? 0    0     ' ' $ {
 پ/ ¿Kb6Vk0Z3V$0 eپ k"ѿ1V0xtPS_.B;VW ׎Ǎ~Qr&} uBr	{:p_^r5#r!rvE@&=u	ʾ%W#JHr&E$uT5×|tB;@~ӆ{ޣ ]rarP̈DTtr&e фoT
T3
%:/O$S	Эr# t itct ރt$y̰ffL []`0fBh31ڋ]
ð߮殄t@~+Wz  dr8uA_QYs_þL[ r&U0RþAN^4LC
P$X` $2LLnBa辀<tZHPv8u6
uB& D?Bldt
߀`[a@ 3 r/) r%BBJ 
`; 5 aù<t
6BȺJ @uH` ~BI2۬2 'u+BIl&2]ȑ8uS\u rq@m riP~ rañ@ tAc rF n r:i r5&D@u-&	$߃v	Qa> Yr	2^QWY`BA BƷrp8V          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$%f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t2g$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2cpPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{< fR fZG z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSS RLOfMUPKOSOLYZXV>YPsZSP[SfTRXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` ~( p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tϰk f_TCM!p߀MQfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c $ b a >r i  f}0 c j !fphG'`t6s   0 kq`%;`0MWff `p
t_ްnfnf
f`aOVWH#gSikW ;_t[lPmF[_^qWp!f` f8u cfffGfY2h2aܘPC
oXPS fS[s$fR
wf_fX$[ؒfӟRq1%D Ð[џBS22EޠHr'} Yuf H8s֊Ҋ
XQ iRP
t0kr?r#bEE  uf }úM % UPfPBTZ+]fa_f]rffr%m?&nѨ@..%f [,SfE.80@%D.%Ч!,=dr!stR
"誱_ 	f^ i
w tv;|苒*f`dk 	w1BcAv *)u6	B+	gf;N`f f{| 	Bg✯>?b>?f> fPDWB< t+
 /t
3 	r&Ղ 
1!股ذ3x 	Pc`}  
_
k

%1=V^=f.RfJjHZRUQf fuffVfKH=XfuNVFYQku F{MuY ?^Y]pg><afPRg'QSVfNVFfL^[YrfXftA/3PX۸OMN0"^O茢PhUWV spuP  ֡ _]x`phWU䙳q詡Y!蕦䋡 ]]BpXRVb 	^pVc#   	?_ ?_ ?_ 
?_
 ?_?4Z3ð4ZRo!"SQuP d$@X鄿u%J@!%QпaXUP&ޔ&-$C'4D'8P&t19$P&
,f1.1Vt!@  $ crQ <V .V <W .U  +tT `a,of(1> 1$f2U60Qs >,upYf2>UkfQ20e02Q5QԀf  PUdmgfQ7UB9.Y>Y u苶@R!4u>ZZ2 u

@p2<A=ppQWVV_ ؾ ^ૌȎ>T S߀rp>.HuEΊ؀ˀQBu	3r
P[Uftf  r	P>.]U p rGGΒJJKK͓;KX@LJ_Ґؒ
bJ%oJ J(OŖUO2 
(˔&Zܖw(^Hioy@Q4@LbjN2G[fW$sAB< ao,u#o0ZP|g fff=SCAFZ2Pf_U< u
 	<! F ]hW  s<w&'V3ɊoCFs̠!`^!	6a_pphV<v^._
tRa ؋nB{RpUEIG],5UP Xis.V OudA]		1k !HEHIA`kl	?$@e#fO@!HnH\!H!H=l¼lr'l"fbq޸}3kQWr2Xt"S":U*@'&vS M]["2ɵ"~Yù.zã.JfUQ"ۋfV/krK`Җg0260}N0}V0}q1&gUfffBfھEMuYa\f^Yf]Ë{:`3 )QSfVfLfT 5Dfޭkf!X	A  PXufQቱقІ{PQfVPU`P裱t3 a fZ蒱`_f]л`PfWhP0YtQ uUP XY1fA@P@YX0t
 t$!Ktu @ |a0%tXRfVytf^{fZj*4V`^fqYw#t ,r`\= r	`\ I `bf^>}PYfQWԕ2! u[ك!N[ F R Vvv6^N  (ro-a?V`I@`2 h^}b\_f`fɐbV3۬
Ê^qb {ѥe R PŹfV1Afaa63ff@;w	rf;wAS. " w~ @3>O!"RZQ@u$vjǊbv1AQ0:Q= <r <3ߜfpf
ffʝ`!­ f-  ? ffWp?>)d3&G;r_ 
<t   S t	t[c )exfsC3Ϳ 9)4e f       PSV-SPYPU==6<P=%%.@]&P܃7ƃ/?^Q?Pf̀S@ dˀ  Ͱˀ@fYXx = sf`/f퀈$02Y[$
0ߎ	pFE 
tN8tS~0Ft?f% 7Pнf@ t07 p"7@0ax fXfaRV s o@ZAҷӫ`$䡷$40dNff`4eA fu4fafWFD fw2f FP ^D  s f-}
0zf3#ҢfǻF$F(F,0  f3rBr~ fv,v0hfN,-(Xt($[PN$ ~} }uf2N t
ffFDlf3f fpPN xfP`#f#ffð0 fHfVPf#f@f+f;FLvFLfFPf)FLhf+PvQfI0p_ 9 fRPwf*`?f
fN XfG7Rs ~+fAD!;Vt
fA+! ĳ{  ~ f%PW"a %P	 "&F
P0F%  pP3ӿ` aaGevpfQRWSӶt1u	 ^
[_Sb QW ߀@? `b0AeabP- 
 ߀ u
 @@@Ü@]8  0Pa
ծ50(b1
Å"x
&%U09 E 8g"]ä"""\#!H'##)$x$rf%7|p)UCES0\f  .Af*uf#ٯs+ SfRQ<t2f3r6c,+af1u g> tat ri`\d<Y@0->..Q//gfQ0p11ZA26p23T,`70tt
~QBqr2*$c;pd7<v1=vqC=-;8?<-Et(1;r!f0@]h)7t1=e4;At?6 t1g&? dJCND8^E~çf#Lt  tu
@Mu$uP@tot tjP@Xr`ΒRP rGfZ3o@[G$
 T`G,KG$` 1UZG? ZEBVQ0fFP.PY@PS TGTGG  `2 TF$TFFk2ZAZFUFF@Z"ZF{$߲TFC\P\gqIs7fX+	ش ʑf@ࡕV~W  _W
t<5t}^`ԕr߀fЛ[r|==QRV uЎeFKYP Qj8uV@Ê$WP(p_T*u	 E 
yjtn)Ӏunt&  5߀& n)u&nu#qar
rnu! À8q@srr vsvwqxx1pRtY{0pvMPvuG	PvR|um< |u3{uO{tnu{ tSr0> |{S|:u@*8*6Rw:EFaru!x  Evr} 谝vtTt̀t߀wEtHPqЁo7с0F )t%> t:& tSuEu3é{tS|{q{ `M !xE׀>Iqu	PXaruP3 t)XY#Ct}wn y$Eq{ u{t{s{t0s~)#qwq`=Ew@Q)ox3;r.Dv+W1pXu4s~32}*u!.ð-s~@t}	~2(<Gr<Sv 0m,Gh.s~]h}Jc uS
<.r Lu2q w(2Kӣwh=r0q<.t<+u
0 uN<-`" uJ,0r& 
pv6 ;6 {R|Ü   HP |SIMPLOyMOTOROLAwcs4~ЎH谌r" 󤿈
 &Vs7زVPs߱	ߡscVP@VӃS`oв(`Ӹs˻ʆ1ߞ >6>-$~	SR&
 3-&Z[>萍>߷ߐ¹ԐĹ| t
1{t+؋R~ö袐Ŀ虐Ľ萐Ŀ﷩臐~wu؎A&3&M<St<Mt6	+A`6
6*^?VRΊO
*aۯ>```j`1®© Ač`ZĄ2 y` "ƣ õG`@>`5`Z`,`#`,̤3+αP= >&~X^RP
OXZp8' 쨀t
N&A jpu9ltgR't@m<stu9 5<ta'6PFPFr kXF;q13tĀuC2F <r۴10e"<tt. 588uGv <t]<'wVu~3$<s?<wH؀<'s*a߃f ^YNuE 8u| w&|u tf2? tB2 PP2i tEa2^ t={?b  t.1 g-@uG*r G F 2vP X'u/ P[FF P*X賺utzn
q1SA
Y
2f 
b 
@N$,3ۊ^ÐSQRtMNZHBT;o$< pf**
BȊJ @t2{1131Z@R9 Zð:V
tew:0Ow'ð:Ë tt	@upvp
t 
   3 D  YRm w$U
& ZPatׯuͯ& (àB t't!&C 0t{059 û@ ۻ /j >N w, r
?^  %e^<  u'' t	3rЁuސe 20 (0si1
u`  )220轿 r3<205r3DtkЮ&55E7K 80,?T} <`:s /Vb:ttD?R 5H I+. um=t?t?<t>~ ýS0,8't
 [lucs8tK@u<tB>u3G8$
 V3J8q u)98   襓
 38$8P3¿x Xô58 gJ@Ǵ-ø+i &g +dpa 
u
fN@NN]ϰ2JuM!PTKݴ`)S\8&&G S&G&G@T @T [ !UUU栊OVPV\&\ X~F0 ]PK..43 ( иL_  iPMC@[XWP+`3tyt*]O $l@]! & lX _6@PF6X`y6$aa    SfgQR+]4Ƒ]u^ffJufQݫ?fYgelZfY[ø <3]Ou j29fPS=Au@u;Áp u39 u+ f?wufP@unLXu
_ff`[fX%_{A6{N{S{qarar5{{arYq4{q$`sararq7{؀v{{Uawawawaw{{̀q
(<Pd7(8p8888*99 o0[&0[ bW<rLǁ  .7_Sw 
' t r
`[[e 诅u0^r!<u	rr&  3a[~s" r2.72&`r`[Q[~s  r q8 rЂ&& rr	a[ôQSs+&' @>' sq^Y~sQ
u>[q W r%Ђ$3 r` rȾA	O ^" $ a[Q0Pm 4X ust sA@@t1d`@pt t
@u!YÜP`
 }4Xr`QPt<XdYQP+1 t	`2q`q4d$!<!t`a@tPGXÃ3ɍ6DL.L@g.:Ls&3.D .Ls` B`r2!vPA2'4p$u KͿ렲^
D 3tt
u! W1訂 1 qu`O tѮ>wM.   .M u}@ J葚}uL A u3pAuv0bW~_tURQBUYZ6	u>^
 .D @+t#VZBLV^ 
E.LF Eϋ]Q3i | 9Ys. u&	 t	&Uu" ώǍ>p |  ö.f?.|fJ .|ʎ߿pW\v͗ΘPQW 3ۍ4Ls_YXfVwfWfdfR%f if[f_fRpNMf;tp Uf`Ȁ u`s uf t r<`
u
  faUQ҃U E] < t
}@<ۃY]}@ASPQRfvA
ˀtu2 ^~{bZYX rgf55f` X  P@
  Q	~P Fp
d@p(C@faҐd}2ڰ Nff?3u
1ـ%"ԢPAҹ  f3g0tNfF	"Xҳ0p ހgfffmڠ^c\UfPQwّcYqSRW*׿OзI  2 603_ZRWQLAs= Y LA`3OءP3  RQWSP r$ PX Q쨀tY
͝@
la		LtsX Ja	
p%	u:X( V_ m ޠ`P[_YZÃU2<UuX
֠`DYJBBPD
s;r
 !u P|
@~؎RXSP
u	 Iu  *ê?1u`&VWP Dt!WQ!:t
Tu8v
Y_߃0Y_XY_^ÇnL  Xtj~ u2u3pqt$t@/;73%s.>t;hC0amC~?߀tOwCtGrCB0)t9t5F  F --
  =%Pu<IrˌN.TV
u
r.2^.ln1LN-虽`? هX 4V3f	'O	O"O<$OImDV	uL*rx0.;Ttq8t$<t8B9Z:Q:H׾DDe3B93[R 4ZuP:u~U>9
0(>43 .P# 30043N2UC3	PH wX15'5'tOTV55O""G/A66I`FLcLHOrw pMj'`d`<u
 @&   EaL@tHLAuM1MPߝ'@u@_  uP,AP& XMVM!N  0`O  r
MM P<FqP u	s	U} Mu1MWu	 X UtGT uPu6FtE1[XuUrPRtKxGS[]t& 0R] Z-`DuhNp2 h`S`
Xuhb`X&  U au_@ ϱTb\в Mrwr
Hrr
 d P dXP $& 8th   hQ0uSai^ `Y@V E`*Ƴj: 5hfiXkQ0laiPߗ @i@XP0ӡYApt+ 1> &=$R&}FIs1@s07 uUMȰrlu`Qv᫰ax x0xxvxpewSf- f@{fP`d{@  
{`O{ `F}`=[u%fE{F{  " f&|  |u9Sf0.c{o r{p fE{r >߀u] (Ѯ l|ؤ {P- bafpfV 3&=UtZH츠 f   f  g&Nog&UE   &ufރf&& À\f^YSUh &]S^ ]}[&uDf&Dp~ VfA1L
^Ɛ j@% t PS'[Xu	pU &A 
tQCÊF 	@ N
F&? 
ĺࠋPh? $ i0r#}&\
_~t8s+Q )
uB@YÊE *F&dؠFpѣGpptP'ᛱ
͗&>  $>  10a辤'2ø fF A؊ϋ`P~
~~i >A  t	 Ypl?uge_πVPѰJD`FFМ$t#PP*( "u B tG6 |P  ͒XpIQ_vlFpoypOIEMAG  IZ P  !  	
?
 [ cHDA-L  H;DBA-E3Ce USB-FLrCDrHCLS Intnl  PCI-BC  % eOj_IYʵYX	UP 	/<M Lp;cLж	 M L` @ LӔ ?LCD001EL TORITO SPECIFICATIONтgu
#d}Pfd(fd&3؋+ s dMd5g}d ۸ jVmd<d;]ttd|{d^cP~vЎF	 ^kr-   ~vFUn ]~
 X? 023
' ' FF/N30.;v+GuBG
F/{ Ë% 	XNuQ
 10NYr%'0123456789ABCDEFSۻ_O׆[PPPP  A " * Gxx x y 1 "Ϡ *
~xx 0~ 	P ~a8R OI, 8y y `b é uT@EtذE
U0	 t
 rj`
 t
r
~xf`Yi2tW &  d_&E3ҀtB&U
&]&E^ tûP_Xu _&E!fa*578F'()+ 70 Àu v_5uaL@Yc `
x_t^t]t\7uaLstF15c3< v
<ar5<{s1$PɎdQXWcôrCհѾh"r9_2.ׇPhS[kB^G$PuP@t`<zw, 0tզ	 t
w
@!hb2]hSk@#J,g E"$Z$2)Pā
 kQ@t"< t[rr`	#PDvPQ@Fs	} s	jEo  @ B C SjTyTTTSSg]] t
33A@3gE
)S u8S,8 28 8 SQ>u5Môux% sr;<)v3 3 3YRV͈&͸XumuAvk:t#t##A>ur<t<tnuƝ< t 3^Z"ߪV껀u8:6@u P=Q?yu`r=-} AZ\uaFF G4pfS=IuOKт$PIR    $` a b c 1b aA} i  RfQ0 Qc jQphGQтi`tS U  U0S Qk`3. W 4Vp
V_ϊE
`ZaVWUS;t0Ut[ 
D[_^0jRW3X`  QUu tpGY[_h0__ޔ`_ZoSQV.U p=6T.UXbU uPА	Xd7]<t3 r
tVd4d8D^u  RWucdsk2iT?^ui@c f`|3&
yt,ߋـᇠat&M1&G&a~`sʇ_AnnLAAAUa+Íu 2<ytȃot
uȁvqu܈$FKuðWQ nu	ۍY;Y_xuyzS؀uu)4  }p0=  [Ã.DLt6@0<up2hp2 h7tls@B1qU3set;s
2兰 憚"  |  .D.ߊD
L ``IX& aø0 ߼ ^j 5&   3Լ{h  q։ͧQPӈQqXY}`.\.T@ώǍ>p.LP`Ua.D`SaQPƌPXX6aM?_6YYZ@ZVWcYYwǝ ^ ø  u<s/`+UUu< uBU<PG-Uu~ -s\}D?: hFpP`hv hJ`~v)S`hǢ= v O hȢaP$@<@pcfQfVfWfRf  TP`Tf Tg&f3fZf_f^f`c@ 2p n l îꐯЯP #  xq2Ҩtð
b@v,`]VO:$zt9ø"
1+а	!2s s	2  | { 	p[{"2ൿ tN :J pൗ
$ 
$n "u"_$"fZ[&[Z[[[\P\f]
]]]  M GKT" *02ǸLgȀnʾAbscuoeUR]K_"		 	Up{t
". {wVjã
JRuQ%F̺ ZvYc׈U 1o "!Z*1>Sf3[ffÊ$Rf
MfX$2E1>fffwߋRc%  ۿff#EfPRWS22f`~ CTrT Mu uM8sߊ[_ZQWRfP
t)Or Mff  u 8M8ufXZ_fY%M4 3vP0M
tX-M`tMWQ3Mr LY_ D_U_}_____________VS30u.:^u.^ \KK[^* UF.B_2 SF p=S._F[wCWN[QF\?tR_sF2~ tﴇY 7Oj\V_ ø80jdd0qQo`|S #`E$ $SWQ KptуiY_[% ŝBiJa`````@jr *QpnP@|#X$# G dvd
-iq$e03iorUXwkŁ	ʁ2hX(
4h0Dh0EhZQRaPmMfPS LogoTrapInt10h `~ff.Ta;bOO݅Restore.TafIEnterTextMode `TuhWÀ Cp9uh.	aúB   $gÜ.TabbbbS  ƣ"cȖ$%3T`ȰaReoDBE2 !Uӡ^+4/ 0 ڻ   D  FS rS uV  uV33PQU	 Y
 uV_ uV@3A3B3C  MP MQ uVR  MS uVT  MU MV WMW7X3Y3UZ3[3\3]3^3_  d` "da Sdb dc ddq5eq5f Gli\oOMbw\ig}
 IgE
 t0f"6DLDq@_ @B@[guHYsU IA$LPLC
$&E
mEHHHF˪CDPEOECA>1B]>Y4@Bv@f``tOX[u (茅$
jzOa,vqPTô%JqR+@V6fa0[МR=t*@S=0`U0P $tQ$<qWȋ ^f`%Z0P$Є %ހZ+ĄSڄ$躄 WfVSQfVF! os^(2۹  <`AF  +^D!8u3sf^@zW`\VQC3uK\! d`^!_@Aw]$I^:u:\!u] rwJ!`+f^Y[_Sp~f$L.
tذu@_u[sNNEYvO'܃$PP&{qk褃SR 蚃 谿萃3TR^T 藃tU0kϊW&|5XҝZjXBY)YY0kUpk5lK+  %m;$ PRZ@Sط$0<:rd u[XÆpx÷H @|=y0zz& Vr:gfFpXRyZÜSt	tv
Pvt[ÌȎ؎ ЍMߋhhQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfV  uQ/u/t u3N@f6 VT/u^puO/`#/ N\ Shi/tE/u.Hu֐.t!2/f
-u 
]]f^_WWWW#  	     D   G$ $  GN N  GP P  Gh hGt t   G   
G ?  G@`11 epp p y(y  f`0D Affty  Qf3BY,VmA AAA A18%wj+rA@T41fRfW.o@Aumf3gf&f=SCAFtVG t"ffff Wuf(tfPf}f_f}t vWu Vۃx 拔 tcPt > KXS!x$PXr$rvOu!!$
BB =vJJ4HX^ϊ>?Á>?QR>  !`^u ߀tP `rr˝*p`^Z[ÜPS}u[X/pdqP 3./@32ƀnuo@ϰnPǤ@XpGùUQJ\M\O\
ҫ\^CNCә1Uf    d\âYy?rfQ@U2Y>Y um м  .>ZP4)G9\ OyO`؋r 0-t4t pOO2撰f$uOf=ћsG t;\[
[t#f fP f3fQr߸`+r׿[>[ S+WPQd  sY@vQ3ɐtsW~rr
`r`Prܸ䠄t"ߡ
0   `u!@!t0  &k X`g Foi &  L
d_ŝa	p" ѣp(y86COMPAQ8
 
R3h  Zo  /Oo 	/
Oo
 /Oo /Oo  !"$/%O&o'() *+-/.O/o012 346/7O8o9:; <=?/@OAoBCD EFH/IOJoKLM NOQ/ROSoTUV WXZ/[O\o]^_ `ac/dOeofgh ijl/mOnoopq rsu/vOwoxyz {|~/Oo τ/Oo ύ/Oo ϖ/Oo ϟ/Oo Ϩ/Oo ϱ/Oo Ϻ/Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo/$L<)YYo       ؀<P7hˁ *1Ձ*1DT`r(D
@ JvArHvA.=sNfj@&t FN aR3V.LZr# Mu 6Kr 0t 2rXP u v thr&3&E0r" r$2vRs ÆUu
FUF ô	!	ӕ_	r@e"!E	p脀^F&?s $s& % &G&w&G %OD
 &	G'fPfR.Mf.u)E	ff&)E%*E+b+++VfQS\f[+fP'fY^f& u#f&G0Wf0A1 /WfZfXP'F~r .>_x؀t7@4y4/r?~P t8@4w tB4 t@4z62wrV7ʀs{L	08!9L~t$@:t@:u/~ǉ~ %3N?V`<3se;^<Í6wM.|uLZR..L`>K .:Utap?LaPWQS?ن? t0.}u.:Mw#.;]	w.:uwPCw.;ww	Dw[Y_P t>ـ?Br.u|
ՊGc)Ѐ ʋ.Ev p$fVfv )dDMHFfH
@NP@K.eXf~PȋHBs$
2~H
-JfXMIKdDMOfPUv]f^PR>_B Y Y Y YZXRPXuUW:>_]s*r  ZP$<`Z- r!P~Z@Xu@[>[ \@<@`ZPY 2sXXt^y>OUd_ \ b* 2bq[1~[   PRσPZ> P@ !f  XFrrPr^rT:rOt :DvL*DlP umfm@:
u
rP
l
u2 VWrd _^ rQPk&:Ev&;Ml&*E9m"nono@:0o,rFonr;Z@uxfyu< r
tCpr&tpu
fZf\r r`pR^Xt2K uu@uu u2\S ذ^A[X$D
>X`HD<7ƋBa`t>;P	 C@@p$Q+r++YsapXt!$!"条ZePZPQȎ@:Jr#@:Mwq>lt A@2:Tt
 YXuOkufYQ   <s& ? E\3 >wM}uЙ DL 
 4L$LVWf<u^<
uuw MzE<49<t5$S1B'[|u |
7|P5u5 t\_^FS}
uӝ}	q.O L@ )򡴢܀} "a`0uDaŖBtQV 3۬`+^YD0!)sG{c+fA1ff?/bffJfT!N
O2pXpf F PXPZfP~~t$=r0&Йw)0Efu1fu@:Cu~EpSVj|ttt
^[PfQ
  < 5@ f	t
` v=a f`ff fBf  f@b$P蜨f  Hff#f+ f;w߀fg+3g&Sg&c
uff+f@X撷faf@SR+6=$XfPXffX{ r2ǜ ]XZ[RUWXb[Go_]rQt	r6e` ]<XGKGFBMGURfQvV ufufYf/Q=fA<{1 u !ρn Oqr.V sfYZ]Tf;`fRff;fZ`υWf!rfρrf_fZrq
fS~' r#|s
`
<f[G{xorrBaP
X(Paߴ?r P{P}Sy[R "2ϜrSEƊa֊QPfS諒ff[fufXE0ֿt ft/+f #fSwff3ۀwf~wX2ZfYUAfU Vt?4 7 3 tp|ð-΂@Wľ^WVp fSP~WB Q Y_W}p{^0 lst6]V! <5u G	F^B^= t s.
<5{  p}豫O"Xf[2PuXo^YɳWfVfĀ¹P E0r&< u ~ U` C f^Yô PXs tu  a"?_a"a"7P߰
 $(  )ð) tA*)SYBHp,-Q,u
 O/O$
ؑ/OO 2/O _O$ 0q2OO$121,)b
>-/4 ϱ/6/~-Q38YQ
t
t
<{ ;q
o= <3ð&+`?)"@b7FA*!tt	*tEPtذQmS&P"
ǆW[eC<س <t<!t
<.<*R?`8ZQR+s	- Z)-   
VPލvS<û	 ?)[rX2^_ð,b
JU&KJ!b
J5-!Vf0q؃ t&r
Dfqa ^0K$t|U|U  ΰ$U<U<U N^Dq7"@EZ؊G% Lq7޶Z؋°\LL[0u PXðb
QVWPPUHLwX_^; qRU0b2!cPh # Nð8dS@r [t۰+N`PRn3XG!t+υ[߰ސ;p(0IJA=2;ʁC
P'+ Nf J13(W+îaoX>  A   "@ * G G y?qTry cT é uF ËEtE
M@ t
#r蛿Pw t
Ӿrð"f`t3W$  dd_&]{&E &E߻ {
fa
fPS^ۋ^&t`$u~G&uF`t`t]ֻ( / 1_t;6M6 6 
G3
t,=
u
"=

u5w<t<u gF`<qS $s
Ê& 
 [<ua Cw\wWQu& ` AI`'aܭᎿY6 FF';Іt@2
vPF X ꏙ dtPpwqD3 qp	
t	u%  @ ؾg ,2O м  Pra;s\&D
V &Dp*H d 
B jr!0r1uF.u{` ﷠a$rOsWJMʪK rr

_cyԟZ FFtpNµF"P@BBF(	Ur2BB2ۀ~ t`{  t3Ҹ߁K3б ;wu;sbFVFF"F
 F)QЎr4F$
F`R+ F @  VPX_V " aWPR uKZX_PRAȠ ZX9P 2XPUv F t	F !Ff ]XbX
WV.GF^_PSQR׺s-rD.\ZY[˺Ǌ`-@Pƺ ȊI-0HȰ>?ˆ? J/Y{/̰OS؀u
ϰ͂	[PPb?Xˀb0б0X( ~a>?Baςԁ(8ҁVWt_wZwU
uQrEt> r2
 C rRݍ r   1! `  ͊S_^A2
uCr>bϱˬq̀ԴοrtrG #/r*r0
 Dr7@CcޢP  
  Pft3\\Be̊\Պ$-r:W1Ӂת ~T0J_#@ORGH3Ɇt w nJB<t$AJB䄑B_32_    _SM_ P_DMI_ J  #f` AzE# u 'WJ5J &AJô#J+JJfa HМJtJ$tIW	ȋ_f` u1Az)I$III #IγI$I~%	*P'@TO OYeʠ$	!L DϢ)ߣC0fp!fP3P@] USPfX[p< &<u0crh .p]iGuESx @
߸y@55ʰ`EʳSz @L{ @ ~ @ @[< r
}@`'$$
Ȱ5DD$
ȷPMD@\r3 F@P)?i'X#@;r@'%@(I'ȋȻ")?r, '?('fP}*ffP+d+h0/uzp/!i	1xsS]SP	MXP rX[1< |?09` $$u  `u 
,3^?n?21h r'7x?tu	0S?<Xs:><;t@=u @m:f0~ ?'% ?[ ?e@kx A2AZ]BSRWP<u}2.P  .E o /u4`   
ްE E {kE pE3oPH PH =^E PH PHL 3|y rt&roMjreЫr` [rVj rQrL rG rB =t r8 r3 .r)= r$[ rqP I r
 rlgZs©_ɱ1a	 h<t<
uu5u
#XX: =9b2X%W	u/><t,`0t-<v<u`X/<r<
w`#-9tX	Y4wV
__P^XƨZ h~/
t	``Z`h| w<XYS%I"
ǰ P犿2M<eܠfO<~A`u.Az

ư2iƱ&aRt@ _ڊZ[lZ[Ty߃ uH`jŋ؊Ȁt, sl
uIlrq7m0wZhduWAz= 2hfOneHŃذf`iLŰeiEžC`j"jf,Pv'6O;3k Vkkx1llFmK ݯ1n?g:ۊt2ut%زoDpxpdr^Psu=u8oho
@:Š:2~gw:03kURq8u<Vu7GI|)p7:0:toۊoʀo0Z]G?bXUps1ll ]`K:ЅqKx1l{׌Q3pYڼ`tM M>rQ>p4Ys@EmI 3ɶzZ[xt<û=Puy{sUݸ@9ٸG 9{U葚L 8 K H86{ N aM CqS	mj³@2'߀8y$PMM GE Uf <@ ~<~@ u<@ l<@c<@%Z [?Q<
@YH<@?<@6W-P= uX\k<@/=<p@|]WfPCI `t!u_fQf fSt$fѻRr   f;ptN紃)" f[_^fZfYְff. 1r  fuހ
N`$u p ; r pPRZ,ȝXPVܻRZ	ػf PfXZ۱ffuٻ iZ裴Sy~ FZF:f"T !fPf``p"s t s t  QVW&= & sPR&EɎfXU ܨ _^YPw U ;t
X2 *Wq
_Dз#twX N sRQ覰ѱCf   fPff-f8s2fˑ/YZ@@0Ba{{߲ݯA*{qAAݰJxs@P FF
]X `j j v
@ )Mf.N. JtTF ~rp3@o^)tuw t&Du.^^t6a.@t&ڃã.^2Ȏڀ36t6^2~. @ PSFݻ@g0'.:t	tX._gepg?\ÁUUPГ   f  E2aur-s(@tКrr
 R1VvF\r:Gs5&DC H PrfڋyZQ_AFÉF(t S^$:u [r
F&F$%&=vHH&
D&d̠u rcwu
 !Ϡt&DB êĪǪ[` TVc HUSap_1s!
 -su fqt
 E PF&G )
V N8tr>u rG o!F) r\ A{r=H RrWsUTsV#@Rr
!@oMSa|`k1F("r#謂Qlr@rI2<> rF( &d&KV& %f)&t N.QSWfu/  Sv tV!ufPs fXtā)̯_[S<t;3fÑt	fسv
ut_f`f[h
 3p.afPԊ܁ɊfXf<P    X& @F$$<r$:u s
jút좌 
   @^38  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%$`BG B<(0ø fF" PXۋN8N`N o2N--?-!`GsHO-ßGHmIn-@
 {r
sHаmr77u&-d_"&&%'ü3bR&u 0ܤ5/t36rCE VQB A9O9 BYy^а 4s
3
3u3`Y?,dS%uètàt  !'&V&T tu^
* &u^ô     QPXuN%&:Lr * r$C`J \@uߴа<upZt躿+Q.?@ -h; E 77p+$<@tgA9Qj9" !$!${wQj`BoU0+0Vùg
+K<Pô`Sj[PS3j[
DjPGjXjQ1 W_p2fǳûw3иsɄ3ɺSriy93t 1|3ې2}\fPAMS! VW  wЎp  u
 g .  e`y˻ ro ɍvm F0 &_ Op00&_O15FUWnR_]v
 @_^$yy1mÑSf!Wfw h0n@ MB RW Y!! D u p&FGvuD )Tp cu#' M 1&%
;!f3ɀ tfuQ!& 3_ZâGF< uV u2gD~sN~ t
SPK?(["s\0ð =NuB t=/u03 ffXhqG װ]a`
qﴆQ-w5":r/-9`u4 $
Ǌ}@2AХ r	؊Y}W@Sph f@if8h[``  f 誐Hnի 蛐pol f
( Q rMf[5f{ 0[f%";tfff w fX2fv}_[RfxpfPٛaZP
XfZ`1+ê `d '@P&
f<~%!¹Q@Ȳef%W
 |dppB_8,s#Ѿ9ў{%Y3`fft@i" QBY ffhfaQfRWf ffӿ fRf3ff@itf fZfOu_fZYWry!tpЁQg ec˂
rQჍL G B = 8 3 . ) $    m` z_Q&GPQwd   @ Twts|#3r 4 撰PQ`Yqtq$ >?RP`$XZP <
XByŋˀp|.
X `c.cafV`f  
u 	r [r"Nsq`	 Zaf^ޣ~`0*2p$BNT@׎_Ǎ~W0pF$
v`&U_fw	  eZa ˡSR,غ*3% Z[W   t2_Fp 0ot
2Ґw PQRV X6\f0Vߺp_T@g@^Zٸ hݴ2诬r?$<0 y}W PyaP3 ú0PRUffZVW㋿Ԑ #_:_^` @a$"AtPS t 0[X<t#<tQЛf( ~PK<u    %$ _aUWV    $
t6s.A;uv uj /SFKՃtA8 ы #۸ ;Rw^_]rSoC# ꠌp 3xuP>u! M  VQRV1E 4M0	t SԠXH0p}5b #o uzX1vqH$tu1vG($)$*q aauЛEuPPu&uZPPE EPP runtime BIOS - Version 1.1  
 óýPwĜ5^jzņŒŕŘŀwU .\]:.I&.;L&c;&R.PBZ9QR&;Pj<rt2[:$ԁ !Ȁ
  ->>"Q@ .<:$ DC[Ñ<}%<u: xuCBFF SGeHF.GSHV<qFKEGG	L&n ^HHH LJW<"FKIaQ"Ol _Z u
TJT`UVU99SR<T$<<rF
 j ?G0	r
t  =).> @[.sŐ]@
議]]0^R3uAB$A@3j C8BBaaa$at@0cp$FfF͋N
~fiF Nu3 f'Ggȷrfnpgf ]
 3RQP~XÊHFFYNZ2mo$@kQȴY`Њpn  aÇً@"ԃǾM & Gar`q.&-ƒ'@'sQRְ Zs
 @q| Z ju l` XYZð
U 
P@XQR  {r{ = uf XX؋7[䰐؍6 @X  @; G{
0pޠ 	`aÓ׀ `
UЋ؎`]FaQWD3< t
AF `P *#[P6Ҋx$upöCБ{!` $<up 3 0ؾ   faÎ3Q]SP1} QVQm3qAY^` 
aËf3RQ3ɋff tfОа3fRA;v+R@qTYX0GY |ÜPUfWf uиjfWW]Wf_ff_]XÜfUfPPfXZ틠f]ffŝf]rP?m@ݿnbR% , ˺.c8c`%@Dʡ "Ĩ@
 
 ް  XPJXSP t+. s#. sXP&   &X[5P.4EG6Ota1pσD
 uj@t%v v t ArMv .sN-f-&A F'N- ύ6K׹ @Е3k
!r r	
F (|r
	u뿋^'Ât} %?	xA*!trP/5rr[Qo
u< r<0s<"N@P \!u'P$nvPf<0rw
sujs>M.`.
I.
M`.}u tj@&u |t
` ^!N%V#~Fp2r2P8 {ss6< s
	OtE""Lt*$Ot"#Ot%" 2丒)1ˀ ۊ׌ .EF2Tr]RsHs1I9 <$u2d*<#"< u<v<%2 ÆUu
F!UF% * F~&=r&}vfP&Mf&E&}C@X§smʝӀt^Ë^6CM3܋F'Rrfg	DEԺ~(LuTMs!sfPfڋ}3r1>wMM.  .GTώǿpR?:./ R3V#:Ttt<~'t9pY0YREE&MDDp%p5(6R~ 6wM u0PSf.Mf&]f0 [A'Q:  &r}辵rxtMrlErd|tZl+r@ u~ (um-VƎދog^tVffmruFr Yr)nr$]萵r(rrd诵_~pq rw
u fSfRW ـ?f.Efff׷f±
USffs̊MF F

tSuoNfVwMf.W*f8f'w*f'F'*2t*܊f
VvfVvF_ PFsQU n E]YRPXtUW:>ɶ_]sUr  Zâ '_2 HBPP'Pюً{ Po^CP_Bc'p cڳ m @w {གྷ # L #
t #P Z^Nz # ty͠<r{`xrv=%>OM= IM1SW>CMKߊ, c5<s-wMߊO8L`
t" >UMG<#<$܀0 
M"|QRPaX  k $ཏ²rzZruri8PNײrWu
_P2oع (x(讲r.t%ttt t	tS% sFurX	 2Pސ!Re F`{F sH<t<)t<(u;>A u/WU>Խ N]_ӓ=r0>Tʞ`0-?P^a@1 PSR 2Z[RFtN+P(X!	F
+#F
t
K
PK(0S~ t=~^f~^^~^~eF
!FFF  f[OfQ
tW8vN؈^~nNnNUfˈNnNnĢU~*Ŀ^
^amSfYTSQ@v @j 8rC5sfZRfXfP`{FfFQVv%跱EfXr+t3Ј tfZf   f+ YÀL@Eu$Pq2Mt
.x<^@ fF! PX! t<"u<"tV3޾x 4|gQ&?s0< ls& m &ǯGnnGn  @&O &OQf&GQ
q1rqMWQsQ׃ qqW*Iq> QVW:W }wtNuu .6 u/ ?.	
zy t,6p/o{OGA&&d&D&t&DE_^YXVM}}"`uxPyM
߰ ф^ MMچ~ّٗ٩z,U~g?0ۡEݾW$L.}
u.:wtu% xt>JrS.[tM.[u {yt	Ӌzt_M_EfUw"RҵgRеMwpgŐ.V PXF
Xf]h@ øϑ? n \V20ǰ=VUMأ6{}س.tL}!΀sϽ|bހ^SVD.d.$ʋд×^[AyOój?rcB֠@qDMt
1Mt%MtM{10
}1zu	F.<Fh ԕ@R:ÁUu	UFPTRG rТfL?\pg Zfa1D`0GfP`|wfDum
`@u}f!VWUuP &BrBnXUMM?>{ؽй0.>}ؽйu ؜`[Bra$3mBnݾ&G $n$PC&In(US*B>F &g0G1&O2C$ 2&G@AX]@[òl1<amn p
 |qrfBtGn 0`?WPD޲ raYxؾQƬeRE<sfQg0MjtpZr/0 g(D Qq[ÜsD_`@QWV.>xuG<tFb=DD.1}y>KU%5DَόɎv^_YSRӯt5۰`cSRg&/_p&_ @Y2E[fUfSf]Ã.DL\   `3Y$bUu#&?t+aÍ>tt"t  .:Utp`&Ta	 V tVRUZq|P렌-A$<t"<@:} u^^ Qp |Ys3䆊Ѐ u suu
ks2pt*ZRR@ @ .u 3ێZ
t	 "uuq #p
 u
Q@EsuVp1kPs4XPt)o&Qo5r _
[u"!uO/I<|ȨdZe*f g˦ZjUj__(C)Copyright Compaquterrporation 1982-2000-All s reserved.j/w*VRރ| 拴  t.Z^!VP  .1BBBX$JJJ쯊BZP0 t
tJ Xua>0b1@V tA&q JZ C@ĺ2u* uP= ]Xruŀ̀2	`1  F (8SQ2<

2ۆ.
$v2lp`1<w0
u߀  ` 0      Q
! YQ#8 O #$#PRS%@&+þ@&;w[HR`ݜuaa@uXXZXp! / PXǻ  Ü= srs+
3,,]{ _ ?^ P1wt蘉.螉譐0! /0諰2]ALq.j.b;a/PQNp K `_W'  A G#y 8P8 y ÿ" Ëuŀ}
$rrXs`tW   d_raކ?A?B_CԆ_WWWW~18 p9@ @  "`:FD-18 F҆G H    *P9	G%18	p9``" 8d[ dc"F18  #Ga acF Fp p  Gr r"Ls qsL
OrEcNw H"  M
 "p9 +O6bS  #	K҆
*tXtX҆#Oci0,}`d$!<!uyݸء\`& t"&& x<&  V<tr^@K^D]8t( 2]']v233.f>"  t."   a0b2ۊ( ҊȰe) ǊȊ&) "f* 븊[*g>+CfgPhf>,3g;Ph.- gi) rAji..jijPgRq=}DK w  F   Q Q"FPkXnf`g =/يu (J$
(ߴ$p4faRVМ`ut
Pt$tº^Z-f` u'~=Pt$ $p$faR/`PȄ
Xu!P<Xu`@P谑}t0a`
 @P!@pa@ISQ q t$Nl<tp1u
<v<s<3v 3RaXRfV 	SPo  wX[ f^f{Zf % Y<u,fCISGu%f» f f fw À2  2Ê$uGuﴀk\PSr?43' u f>$SMMu>X P dPu
4uXE[r 4g Yrz #< t $t$?a3 &1{r 37.73a/'  u3sL
tI<u	. u< ta|\  1tuu |$o
4q/[@ 7<p<uذUNwNN-O!mOاPSRС_t$Z5Ryt0M4p'2۴
÷|3`us5#v{QR
G'u6 aԀa$8uP& F^XZp7P= 4'Q`Ѻ<Yu<u
3Xuuu@Fukufq|#Шu@Fu5qKFL]yIIJcB1.F/CUWVRQSP36x \fFf?sEYc  u`v
<t<0$< D"<w<vr,2}b? D&\@ N [[YZ^_]Au9<u` taa~AsBr+ `ƝtNð
2
t
8u _]À>A`cA	t]
u'3F &LpHF]sƨu	VuQ2^ ˋ
D=]~D~D@كu B [\tGD&A J
@y2aea4C'u$<s'5D
\2f 	.c u-QطME`
~W9?q`t
M[d [t0PC u0 pN> uBG t$p<pupZmB'FO 8tWGCCGBC u33 	t<uSA[u8st/,H@>C0ŀ> pd XϷC PBB s@t2 	=3 KuZ&> C%T{BB3~u返B 菀MB{vBqlB5DSYSID_  1Y _UU! fl f@f="uf3p fl C$PnP!H0TPTYZCfPff `FfXtfUf	fSfPSfW0Υtg]`rfw q?rd4cߡf_#fXf[f]ge3pberVd4Ad^;sgu0
30Fes M ptAt<VIer0dDgį}
^PVW!>^gEdTg}e
d}gE Ptr00t}d8tPW<yt@Dڦrd0fU@f]{3 Q; u Ó' 4c.;Gt
._
up
fg6$+' +k@ +q 1 P a ~&  '  ' # 4@(E@ (ů' @(@( # *8 *M	 VK L   
  
 -t " ,/    L ހ	=ZHewlett-Packard 68BDD Ver. F.0F 07/23/2004 L-JC. /4
5 05L5 1 /3 68051!0sion XX.XX@X
 
 0</9=j57#oCߒ @`S pZU10 Intel(R)=D7 ǀPZ0NQ!Crnal L1 CacheF rGG2H	
   PC CARD-Slot 0  owww.compaqM  
	Ken|US|iso8859-1`Tg
 0<AZ!AJ  2NYN-BDIMM #1CCPp
oSAT2_U{V RIF 	@GBSST49F008`
 ?r@`[~F N~F
\ "A^@G~N  A~1
@8 Bp1rimary9>C8~dNMultiBaOfog48~  c   nBw  kn Gr !KENDp`C"A1	

 st	a^dd4x"Nrp~=5No batHy8"/yOz>7\QPՐ`*U#7.:f tP>7uD>.V.f] (<sW ._.  2PpwXs2Q(.u..&+.	 ( @ t^T.&u @ u42..
tw5Ő*
t*ľ&u XYP3WQP0 A3.G
XY_&(3 *.?(bWȎ'%'_D|so Ϟ/_~~~l|80G8|nr8|8a|çP<<@n  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x`~~®q m@n 0`` M  ff1$BE0xx00 0 wlllBllPl 0|x M0f 8l8vv ``B0``/`0  o<<f!0p䵑 0  || 0p0` x8`̣<l ށ8` Ppx|'p`aRp Q|x0 ff|ff@೐lЫl bhoxhb3`2f>  <``x pflxlf bf  ΐ8lƗl8`xƁxpcʀ3wx0 `@ͱ`x ׌2x``x  xxG0āx|``1pA8l`ˑvQ`l[vf0 Qxp``QRځ  àAG   bvfҷ 0|@1A!0ᶀԀP0d 00001qP v!ׁ uUf SvN ._\2[]
fPQRx>@  t&? ZYfXooT?oWoeMAY9Y.5nSSB.(B0P2X`3Ҵ Āu@IN@I<tDpQYRBpr8ror
2:6 voZ aQfRPCI01 ISp] D BD03COMPAQꊙ >004   
  p     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hlre
h[U샿VW ƿF F   `hp2 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3Pf S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 hr*F)'2(~ t
)F_^{Qd!
hURs .&4/udu   hr$?wط2hzkRhwUC4Ch5
 rf   f  f   gf&Q6..  1  Y`WVe1E0&E.&WV .^_U(Una<Qc< 	`@.e1E0eE'E.U s Cm2a h
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK__Y[X MMMc1@~M@  OMpM dB FO YMMxsQURMMd* &  <!TXM?C  3Y[~MQVWh5:u% p uK1__)  | = <ta;P09A9_^Y!JRW`  Ê e
Crr3ɺ Qe܋
AB rN _ZMSqe Y
ujizjU zj%1 DE<@1p;<<݀1p<3u """ka#t
#m[VfPfSfQ f3f3PXfffDDG(	Dh fYf[fX^u 0gO GoxQR@<3ۊED 	 C!~sG4Bi3u fDf3ۋfË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.he+[+V.`.^̋] dF. P!.hrXh͢C QR  16W  0"XYZ#[  
\a_nbA]cdb'^b` Џefgh qp10GpppQWĀ> t		 u		.	_c   O idJһ -ww~C.=e
/e
U@m_noG`L3۸ E =_F߸^FiQRrPS8[Xf%hzCqQDЍMˋh
            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй Ys hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0rXf[f}X:g&8u-g&
@gf&fB!??BfP+g&>B9g&@T=SWVfW=&2>X>*>f BSCtfGg&D= $"F<vwD"FCG D| u:tHg菂ACDB'B_^c=QRfUۼ ?} 5tR>0tKBCt!?E$fu
PpNANtN0OqOt	dI"  }f]ZYp=PSRi 9uAC.XrAC&PCTG tuVb0< `M'f5 ?*bX.bX2Z`8P A; u
@:R[3 t
\=SQV3ҠOCICHC  :OCtzffKfIC?As8_Y8ta9fF*0I8$ЊBb*PX1JBr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>oou	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
BDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VB QCffq FFt
hZS7gvu ?>t!?6fӢB qBf0KNf^fQ8SV  ^lQ  A;\LA;t% BA1 0*B7>	uHCHCY1MV
:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 	 o 6`58`9`ʣ:Uo0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъNuթ5e{ay脆vؠ@Nu TѓBC$U^fpSa=}001?11SAAP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<CL`Lf;0tf0f`0 8z";$KicjXf uogf ?EM{> fù fgf;t?)gf+C k@̻hix`d/ 1_y *Ra=K9KPV`^0`; ^=X0;0u0;R	bf. X50. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ?_:*86T M54	# !
  5# #U4444!	 p 4$44q!p  "!"!3  .>$ %

O'o()BB)+,-./1r12  S@ hB&Bc;!Iru
w>Bj @O7>r6> S!7tBBB>BBu 9BlpWCl!7r8B_J@990*ZBBBB賔7a64 ?I`6l3ۊ؀`ZB&;CaA^B;<CZ3Ǳ@PB7VS@t	T0"B [^KVB"AFBFFFUuDhS¾0BBۭL	u5&SCuSCDA߀kJ:Bt_b0P[gS> @OCS>CC>OC]&?Cpt(
ߠB2B0B[O0PrlVt>BB r1AVw%VVrAϊ&B#ST40XSWB8<ƀ8k [HD4EtEhG3E9FB GAPGG<pYI`\A*[0AC?GrAC&PC]BCCNN0RV1J2e|))_rhC u 8B $12B迌g&F@v@p{HsPkBk8B$l[w> po$3@ p%u0q'huQuvtrueQu^w\quMq&#su:+8rPu)FvtFvtFv@5 ,= IZ^QXp8!u	g&|t|@sSAX[P@CAWC^U]»A`r' PNBAAABBעBV.ott0A/0W> @BSRaH<v
hHC,bICBʀ 7RBƻGmr )R艵@F1FRcAG]oFBBB:BwPA5
a t
d1`x `1JBrgo&htBrC
BrAr
 JtVŖxintco=LQ2ag>a6՚WuEP g$PSXPSZaH,T UB_{%AA K} "u3Q Bf3fÇ" Bfлf3Q^ C㫉PF E *   <Fu@C3t	Dt<Hut2KtKn $`u tP%X!=C !7:C uB<Ft<Tt<et<t<t<Rw*<Ir&@C
2QtK>? RKA?QuYVWЭ5tAQ ft(PǴ:>Cuҵ0 gXfCYG609N g2â>Ck>Bŷ=C0Bt&<C൯8r ҵ>@t!7w{0$_B@CB2 Bf?pt<C:<tSQ@Aذ oY[pu
?l!21ֽUqVWWW*XCopyright (c) 2001 Intel Corporationf_M  Q;]uh&yp2 yMfޱ2f°v t;ff[0t*ܩpt tt@
   0L+&_%f_Mqްhj胒)u" sfsMfȸ &f%mܘSf?qMf }00YgfW`;ugFsM aqfgfNf!f벑FkMffgMM
ffg_r0p?gWfgG@SktleS[@ޡ!tY uIfgV8~N^fn f00! u&ȷ0f[QSfWfVUf&ff{3J_ffGf;qG<uAGf=_PR_u	f=CPU0;u>pڭ ځ0SuAf=NPSSufOffbk0v/8f!0{0	fF
f;sv}SfFrff3u "
f$@g&@@
	fM6FH.JG	"0)/f Qe1yQ
잡G
f`أ
!fItgJO_	S
!~j
_D̱f/E.!BQ.f_.^
utd&ubnmmf0(+؋{*@7f+ֱ.N20F	h"":f^f_f;kMwe!cuA1J8t3gF`2g^ΐ%??pQ0z 	 @ceM" RR!upVte kMJh΂qG k]F Fu`mjf3pft5f6_MRڡuRR G Z;`Cd  f&_MEuPh3<u	P!%RG$<`<0u$ +HQ`<t<t'<t<<t$<t,[fMJB>= JO1) f=ISGuPf0sg]M  p;aRt f6M~P>f	0;@[j
}Xf _t6IC0:NB*"UU IaAUy <&!_&>pC#f+O"<	7u+P2fN'`~PeۊfGP@^.>{gd$1s& _ `.@\veZujI_)`@ ld<(rl$m	p<:I1)`r8de)K,16pu1m }_eWe X@\|gfd	P0Fa/冃eef0iuK HM9NHtA SDA2?Z hc!`3iUqZY,P,  ]n_
  Nn̪212)

A
 e]d &d   .R@Je,#D" `mۗ"Țt-Y0Є - } %1. 6ћ!  z§ 0ua(1q0*ě-4%a0/4 !j§ [_,LQt
 2r%VSp!1q1ĴU&D!ĵDζئqRӨhBFS4ө1TQ$$?l%EWCDHì6C'!1/)!lĆU3PF63'tqE1d.ɡ`vA1ᔘ:#+)9+a+DƠ1ѯqAЀY&u
@J&RDHs"q`%խ#t@!" ,SXp&Q$hB "8ì.Dl<C0qS
A㰞' (#
/ 4!	䓶[@
@J WP	  P  8Jkؤ8B) `@ۀq(Ө*
У:%@a 	ZXbq3
$csT3D0b1&xiq	bÚրY( [(R"tѼ:`u,zѶp L!U'q'$D!D  qq&q&?_($q$"DD q	(У(ʼ!4롹.')1'
$4 1# /Y$ 1QՑa	aq;(q($"\D!3 aVq'O o!"&qqa$$
"$q$$aa$  q("(qՁ!Dq|"'/%!$ա$!ߥ,$ U'6,(!t@a+1b8'<=%?2?r$ $a?Bw=av  F HFPSQW  hihqi_Y[XPR P4K ZXðLp@  p|G i z>VN YfN瀀gPҀYttMQvRU УxR`УxS%УyRУyS [yT [gP V8Y qRZeS T Z)U\)VZ8W\8X]:Z _ NfWQf!P gf&D=FYf_c dD=f.cog&D=.boe.D
$.>Xo.%
.D
or.% .>botbcԹd2eggVhhsdo]rL!md
hJr93ikk|= USBSu _g&|=rti j`ooouoгm gwarFr  x8t(Omhio0{wj`8ezcsg|Sh0i`kiqot P}hIr It5QfP}c.F1G eor
vgcCf!RwfЁ^qf@teH.\
؀g.\hyK{`vr|;~  }`q}h~"phus$vjϒsw}W3ek rCk g&D=Vvx lW /DkHu㒦yoSoZ$i(Z_(QD7$!N_=%dĝ
O^D$$:#$F`e.jϢS@RP2  ėh >}Mu g&``T=
X<,(fʐk&`Gė:.6oo.oo . fPQ f.>mvmo f+f!R^V߃uP6nno +.jf.ϋ6jekpfAl YfXIqrQo JfaúW<ߨSBϬ譕*QfPf!Rgfxk
fXYrgλl aSGJ/j?s⻡j?`GOD/vc`l=3oMt*1Mt6%MtBoD$
ƈDƹdAl r
rђҹK i%t-Ơft=fT= t:tt hPIǑjaeށ(uVrLeB@M=@t1M=t%M=`	tM=`Mhc!I6EfaPSVo8dtd mepy_P}YϾo8DtD$ ae@ :p4^JSQdO	8t`g	G	_Y[CN@"GG	`G@ x}ab`oaoUGF!F !O'`bAGw|(}}}{qqgxgxjkl5mqr1UWRQSPV rwtj `ur(ffWRfhIqG ]! fZf_ uƥ@QCaPSpug@VoZ@Xo[oRo/ ib\]~ Sokb_^ Tod[XF f scO t  ^X[YZ_]c qoto P BsB h fdabu
!ro!ddfdpdp>p6t
d@dПdܐQ
ro!soBfU	f]q,>@u%ttt t	tfN tF Gru@:s
@136{1MuF ėD
 SfQVUt"×tUMـ?fPfDpfޠ'f 'T3(ff_fXs@AyuptLuY'f3f0	 f.mowMfW).*&mo8fw*fF*2t*.&nofX^fY[̠OCDCo rԠf"p^f4"5Āu߆Drp^vNox lhxlԠjSQVWU&BC tBC wؿر]_^PLS-120ZIP 250PHRVTsq`a`,`44A?5ߋ|58Uoos
hGrgfb<tV< uWQsfc `:kuFfG(UEEFXX  U
ZYf`BCu goA3EC`oZoao[o BRo79RW9F:A׊'$L} tE.e_Z[M-Sys   DiskOnKey SSK9iBLFC uy @  f<x fP px =urE"Fr 2rp0s0w6|=1s 1s	p ec f@fPuLsu[t6p r)g&aWug&Eg&ޕВ ێؐ&' rLTOf<VL\MU]bMSMPUNF:A׆Oe}Pye0:p: th;t@  u} amu aRpK3ɀ'Af?-f`2'-!q
q]fXuײ?K  LkBLGL_M^bMTM9F: 	 zؿر`W;PR)j3WP>#>;P>
?_lnOhfm;n 4  h\H ~e~Z A:u+`^s!$?
u${D[p 6^@	 - NiBd8}t 0	v` 0	d8jt|vh!mf!	d֎\dЎ0	xU0@xp@y@y@y cg 8e)) 88: : 0	fWQf!qY ! D5 o6No}osRP	otA̾zD
$&o
ĈD
𦱤ӽs f!g&W|5@er`r aï`xveMy %@`yH\
؀Цo
܉\cse `°y͠) c#P>r`4װ@!	&Qp"W3*#sr	aD=1WtP9Yy0q|ô('rkȲHMu6o=oo 6PrEQfP^!	.u|f.6q|\gffzff.PfXYer"gkYK!9=*_?U͋oXYVˤϴ0Ѱ¹D/osF`g s6Ytd hPsCg_:u`(uI!r?M=@t1M=t%M=`	tM7=p&MOHQfahQV0L	;t	E ?$pضy&` ;QhxO	8tg	G	;-0 0  r    @  Q  6 00 3 **Qqu0 3*@rr+ 3@q <B1 ̋ @P  s30d  @U	  U u q@3S U? ?	BC AFA1q?Ff (s3 H;A Uq qU3(7!̆&3)5(	q(31  q.Q*_}1 0 U Q3
41p- s	
3S< .P:U; )s2(Up'#&6#<4%-8s( < ((G3@uG0GA  7B8@;U&U&1N @O0p`QYr<f.;0t4Uuf.0# Rf  P]f0 3rgfP=  v	  +v> f3f́ QX  m #!Z'!Z6+߃ tQV@ ZbZZ [ǐYǋ`Xt./_ Q[./fRfW9@f_fZ*r_UffQUT+QAcfffROMIfMAGE ;ufWtg f3TP}Q`aJ 2ҀfGZYXuɃУG0G  Cl Rh2h΂~t"tAoo t	hV  WSQh|tuY[
Y[hW { s 霃mBku'f t!w X @ RfG9 GGfԓxfxfӸ U3; ΃0@||W0
UȎccAcU[P`Achx>t m PU  g8@ B;  fPfSfWU`cu	fP
sK~cg йhGCg#Āu`&ztPfhfT@  Ogfp% _f[QAqifVf3 m XUfĈ]gPg<ufGw!@gt!>tfOuIu0f.Bg? t% M^jfYAcr p  fW
fUUxf*eUǜϜ❋p suf3ɫ쥍tfYPQP@Y 0t  XQfR dr
fl fZ}Y@aOr FuT4Pbt,fU'b r'8tfGj$@hZЬ@8tpQ[G`~ lfQm8  N hbhqb0d~c  gp ֲ`}h  RW0  6ֳ3ɕoaj`rK0Oºÿ.OCP2Xf36o f30f\0fyƥ` # ǂ2f;Tu@f">>?.ߢΌ%ό{%Ќ%ьP.&̊? ` ΐʹ2α#< uw؊Ð?񿛰#̨  ruU#̃`r/Ȱ#֊$8tFPSr$u簄n㰆g`rL_rG@@9a%8rބ  aQIUvPPF X P.=.;AXP.=.;X /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&' )/*O+o,-./0 2/3O4o56789 ;/<O=o>?@AB D/EOFoGHIJK M/NOOoPQRST V/WOXoYZ[\] _/`Oaobcdef h/iOjoklmno q/rOsotuvwx z/{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo@/Oo ?_ 
?_
 ?_ ?_ !" #%?&_'()*+ ,.?/_01234 57?8_9:;<= >@?A_BCDEF GI?J_KLMNO PR?S_TUVWX Y[?\_]^_`a bd?e_fghij km?n_opqrs tv?w_xyz{| }?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ !?"_#$%&' (*?+_,-./0 13?4_56789 :<?=_>?@AB CE?F_GHIJK LN?O_PQRST UW?X_YZ[\] ^`?a_bcdef gi?j_klmno pr?s_tuvwx y{?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ !"# $&?'_()*+, -/?0_12345 68?9_:;<=> ?A?B_CDEFG HJ?K_LMNOP QS?T_UVWXY Z\?]_^_`ab ce?f_ghijk ln?o_pqrst uw?x_yz{|} ~?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'( )+?,_-./01 24?5_6789: ;=?>_?@ABC DF?G_HIJKL MO?P_QRSTU VX?Y_Z[\]^ _a?b_cdefg hj?k_lmnop qs?t_uvwxy z|?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	 
?
_ ?_ ?_ !"#$ %'?(_)*+,- .0?1_23456 79?:_;<=>? @B?C_DEFGH IK?L_MNOPQ RT?U_VWXYZ []?^__`abc df?g_hijkl mo?p_qrstu vx?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_  !#?$_%&'() *,?-_./012 35?6_789:; <>??_@ABCD EG?H_IJKLM NP?Q_RSTUV WY?Z_[\]^_ `b?c_defgh ik?l_mnopq rt?u_vwxyz {}?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_?_6   觋0  hNv 1 fPf fXf X8  Y߫øQؠ.&  "Tf>PAMSf>1`>󋰃 f3f&0Ef&ǿE 	 q!/Y
 H
Sp
 fqf   f+0MG hS  @
"3qM
 hDB ,
FqvA  +<H@(hb`2fPQfRWVf  h4S ?1$h0$rY  E6fP < u h'$h:'r f3")f"h['^_fZYX"h;M t.#$+or@!%ؾ%E<up&&/f0a&"1k)*, H6`W*ft P1;  ,"a`/7D"Ў8Qs+r&=t&} tV" &GF^9Y"aþY  h u0. u&7&e?e?8*:BþX w h4AC CHDubCEhCFEH CA& P~̀>?,1CCXS?e?[PSJ1CC[,OJPRغ0 t@ZP,-./01289AHIiU,?014589UWXZ?[_\)]`aPb 3 t~
2__a`$a,P$rRd 	^E_G`sdb_[2t`BBaÜ`h= >@ l> l1hGA lBlhOga`g6~1h$?Cpho! Gak@kA lkB  j$0sϊFn`g~8g  jj118  BnnnJF$!t%?JFost1r@^@wpj< ty̢zw̠xxyy`zޢ~@. llB ؿ hlBB΀ lU@@@@@ l?Тp~"6ľ?dj`aа 
@  QFF/nַUn`nnn n`nnnnۅpgs@@PztpdQ@.`FĎ@@}!rŀÏnnja	 nAp naaa"R%> tV>"$>&{ri>
[>$ȡ
᠞T>F>$F>
 ,u<w'>,~&Y@Ң$<w	@1fPS>+ t28[u, u&09
<ttu誠r	!ʠ [fXQfW1tUgf&g蓣tF襠g&G ps? <u$
Ӭ !aO 2_f_YaP1tg&G?"ןrЯ0tߣt)suӬЯpS	
!Y8t"8tzrD
SQyIY[t,&
u>ut
$*sE zt>  u. (2t$C	&
?sP@qL
to:8Ξ,{	> 2
XVr< t y198+uvۡtC 8< z@$ @@0*A>؀
	̀>t 6(tWˈq@P8uA $p 6t>%bu
`ʰj ~; "ptߴ 肢8JVqiQt`g pʤ,.t_htP =rB趝s?u%
u="ҬȮ?輣կӥaLLtzu :طcMtb"; sW;"sQ:u	1uP6u"
u1"
2Sf:胞F
  à/
赟t 蹝8q r
*PAt@-X?SfW0p@t
P-t_8؊f_OQ 襒`Ě@
,P@ ؠu @f`῿0p`Rf쐡AZlfa@n3/]_:(ߋ08Ef8 `1 D &Et^"Db$D(p s `8c&tȀ $>@" 
W&t
 L &}u??u8&=O r1&
I$ ` w
mm ``m c0Z'!
Pa 
* 4·O  af2 $$<@thZpKuK,[}Ku`.>;sKt&3NRr6sssat`@rr X ? :zCAt@rk!@gA"=;"a10$n 'a07K&fRQS[YfZt'8P6t] *t *u
| t󟧀9rWXCC#
,Y4D-,m.>  4f   =|h pkrof>.r`ff3hpf  ff0r9fffHff#f+ִ f;wfgf3gSgc
u ff+f..S9,.02@8! 1O<!0
KFsDCp jz%S	)$tAgN۠F8ODύυß=2 Ũ0D$#S<%{` t 
!D&_~R$Du" ~  
BE ZPQW,!L!𯮁89: p 't9!R0I oPfffXpNfff00p, QhC4<Y0pmPI`:KbS .S` 
PaTUPfQR  fQf P
@1hQ3E_#PK   ##{0H4 gT`  0 N  "  #"`ރ`""`΃`"Zf VQRDZZS[7 W3Y X_2t^A_q_ CcfPRQ]!D% = up= u]J= ^= u
Ĕf^]]ZYp޽`\  P]	"\` !!# 3f,rr9,t !3P[!DePt(Pt J*Pt.Pt]^P쫺Qv@PtDPtHPtf  xaxaxax,ax0ax48`x!Sn$f#y!|ЯTd  !et&}/*a3S!@[C vS3ӥ4t@t:@t[C0@-t<w>to80 @P軆0
 P)蠮Qa ,Aەt3c,蓕k@.@^?@W!t rc`rQ@<PfP`  !@rQ c
	 fX[!Et
d߉/sܭ٭֭$^t1`-r0@.frR֔t0≀p0s
:@0@ !@!> u藔t֘!@@aÉ@HO.

`A.I7.PJ*.`.؃?Pp	.@.25 *
s3y@sՐ Yѥ!F3}:߿u;Pu;t0P"p)ͬí =P3y Kzbp:! r:7Ȉ3&ͫ R+u賫 0	&q9oww
2ar`!
À
v
^!> 1+*22);qSRf*2*E  ```.JhxJS נ?QhP2 4 tRQ qXft<QQ _yY3 A f ݷA dɩ uT I`;ar0br%h8?=Ď H 鿂   DCOCho<aTE@RTFTGZfapI`  hfJaObRp0@0@0Zpo` +& a5B b5^PPRSOBމ0OC hϑ4QMT;%$'"%@`.p 1f`.&
tP9
fà  t<3mOhUpI3`t*Y"@`1:@`v4t-`VW0kG\u8McA"
"#vH[",ĵF*p""]OA0A9B# L#`1]}AOA 
ҵHڽ PXI" : " 0ch}ݽf)ߎи2P耽 : H"	0PVEa|
;)3 3_ @f@ ..     J
 }    E
G0.
!0Ta
!Mrqh5f&t.f; Qff  P`fRAr<fݹG@襹r(  蘹r 萹r 船r1-C #0@
kt
!! s!NAHQ Ms-T[3.;'tpm`rA!
䡢Iu! $`%0%2[&aÜRllJ쪊$JlJlBBJ(ZRW(O/Q*6P*=+_ZR  - -Z6KQVW  _^Y$흿+t	3%000#1aøv  PFEEMsq$q5y#h	ʢf`8P%}{Ⱥ:#%8  t
ف  ða`%_i t(  u
-Xt
 PJ`< Pé ؃3yۋPJtOIHf3ȿ fqf3uWff#f  
fufDt7PY h¢f !DvDPE{  uDXu`88GX6ڀPSQRu^u#؁ 9B8:GA9uSWW>XYqH[%87{Q# Y3#˰uGN{
7  G  OJLiTQRp6
GFu@R P`RR@R a
>0U""3u%߁4 m ԝqVI$t X6f7f#1=$7/ 5 Jq[]CqVrV@P=
 4QRfLY <!ZM <3~a:\u
o<YfK0oؐ(y&O&( fdfAhfUCESuG&`hfRVf\rf_ffff^fZU^MWRgdQe ،Ў~  PfXˀlu   t `O rWf@O1=?C@ t>n@9t t.~ntSp
 S@  [r~!f_n 0h1@_b qfК#ؾp  ff;t7`p
 v'Crv
@9vvuthfruhEh4}\r|fb߾	 ubyr!yby
fffLp`xCr7h'm|Wh:^ofhf{3ҹ  &ahnAGVUP1}>e<$F10uo d]^[QV H^PVSf 6yD2[^Q :D~@? +Y0zᴎd43HD#k@Rrd Tr]rPP dX`JXP<s6XW+[<u :<%@Rrrr#zXM@ڱэ@R<r`@R7 >:Ò***`"s\*r@⹀B
ṇar(
@\rzDr r+
+-+l+V怳r .*^q i VWQ?>pgK Y_^s3 .:st
$ կ.{hR.tDҦ à> u( 苛t+j (Ѷu!>tisr `ѶuAѶuu; W `qƵ`Ǒ8`91:17 > tD6XiTԚA` Sdu$C$?< u^	!r PQW<u
%7ugg{wP _Y Q7"vxP1o`nWh9SX ]迓W? W 2 yyȐ
{Pn*z
/S|PLR[[ð#h EҾî" 0 QP@{;Et0{h[]r} f4hf`F |` u
t۶"S <@/@VOfap^f`A@X0RfVfW^3_(< t}Ǿfv_X/f_fh1O"f" 1fC`Fo|SR3&|/a .0 ~t2Ж|.>pu|@!,觖{ }t=> ~0 *> u8bpWke  _ }tU5~0r|t}t{|-`}t0{s~z`?}@¨C{ z P&&X镀>&pƀ@!$du@!O
U_@!j`303 /<t+|t&u
$&Fz.aQfWu|t"N
tu<tg&G !f_PTzuUyyu >Q&t_" #xP^Q{WVa8?w&re6W p 2:> u6 *Ht4R*o hlE+3Ҭ؋hEB^_ c%&|}k>r*2-.a.@+->.2`/Σ/`5" 0,O|1(WJ0or.R
.汵.Pp/>I?SAMSUNG
BLTN141XB-L02
nB1P4`C3
C7B
Color LCDBIDTeCMOBSE`C6B 44444@I`IGIXKp4àLP MXPSغ8V  ^PMU~̀>?Xé  RQPSRZغ*3%  Z	`^a8S~S PTqS 33 U1{WqS p}_Ӆ5WmP{ 33 |fXX]N$߶P^3À>?6 0u:V qh`qH_re^u3_suquo0 cukI ?s Au錦at00=
ui4s-_Qßzi\{UrsQE4\06 u6\>6辛/l!me0mƬƛ"ol67p~m7n77m Qrurr^fjqprãܿvwxz ?{_|}~߀?M6x7yr]>7X o 67L}cP343Ҁ 7B4 M 8u!!u
 8{ut	3ҋPW
 
t	_" ك
_0Qhث&hUN%q%$f33ɭFff
~쀺fffu}`2f%QRtv$f`Z<0tXQVWt .S \j{ 蠐_^YPrj2V36 <dPSQWh{^&r6h,tQW _Yu`Y t
tPu_YGw
	  c"Ц
ĳW
P 8X00PS$Dm

S@uy
Цf
 @X
pܯ2P#No
XЦ=
2[Q.P2
[
$

ÀuЦ

;X[X f 1n
؀ 訽Ҷ
S
2o FP(<KrK{XC
`@ ӛyP0YaWf@3f   f fgf ̃' /f@%PѾPh f&>oftѿ0f%gPPfWf@Gx X<t<t<,SxPS$<w
0[.<$pu0;0SfAhf  {f[Pv< r &<<

A\+Fq 
8s E*qpz @V$<
v
ط  W tǀ>  t$
Bh}7$P
-d t40[ wl^h1&

g-d1
 pDu <&<
@ << >< u
8w`"_f.3лPh:>f9?P f> 5?3? b^ >rkC dC b0 !9?uP\po	h>. o 33 WY?SIZ.??[.??[BZr""
ZP A??JJúBRpǰAZPB XCSR@ذ4_ИSfQS@Wpu_[x·Fl
qq$==q
,A5 	
b,C[CG	GGBE<GBE<*"*H@@A@AGH݀E$=}0
퀽E
3!E
 AEA0.&5, .>5`BVvaX	qS ۴PY03VX  Xpf.GAX|p KAX[pmRL1 7f.WTS T@c)〦PU1	8BB&B0BBB|BBB   M!c!B ' EUUE&#U$$# #]TQTLw%D\PUU%U UUT t'P'`$    T oT A
)U)O '+U  P\&tHuu
hu/"r*,->,,@@
BǑ,_ - @u1 
 e1ü311 /0gA2@o0 0PXC8Cs2.CKrb@2?@ `&_M@Qh;.>uhPS ?>h >hT=Oq\thJ?hX@  
03!4E+t
3NO+t3GNO`UNKDӛEDKDK1GNQDJ쪺KHaFGF$GpFG`HQDQDHKHHaQҩeu"ћtP4GsOPfu%eC@ypdMt3ePPUGr"P& ;u
>Gs聁Ps4T&34uX4E"rppΡEE2 `j_ 2tzqPOUV<2@2 Pظ? $ಐ]{%[. @>{4
^]2 	ށ] YFX*Sk rɋߟAFӐ>}r<wc:1dQh0dyr|Ku#  hD1gCh24@$>t
 >5p4@pQ?k @g&M<1Wp44 ىpN @/K sPxTvUvPnGF X P.[G.YGؿ.WGAXP.[G.YG.WGXG!O&GG$qP>t/PS8rddr!S<dr 
d2}jt
\w  St Wq,a3;zQp3Qp3x hlQhÄhĄqPpH"YpSt5S:0<4 9:B:`hiPg੸ P pߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_	 ?
_
 ?_ ?_ !"$ ?%_&'()*+- ?._/012346 ?7_89:;<=? ?@_ABCDEFH ?I_JKLMNOQ ?R_STUVWXZ ?[_\]^_`ac ?d_efghijl ?m_nopqrsu ?v_wxyz{|~ ?_߄ ?_ߍ ?_ߖ ?_ߟ ?_ߨ ?_߱ ?_ߺ ?_ ?_ɟʿ ?_ҟӿ ?_۟ܿ ?_ ?_ ?_ ?_  ?_	
 ?_ ?_  ?!_"#$%&') ?*_+,-./02 ?3_456789; ?<_=>?@ABD ?E_FGHIJKM ?N_OPQRSTV ?W_XYZ[\]_ ?`_abcdefh ?i_jklmnoq ?r_stuvwxz ?{_|}~߀ ?_߉ ?_ߒ ?_ߛ ?_ߤ ?_߭ ?_߶ ?_߿ ?_şƿ ?_ΟϿ ?_ןؿ ?_ ?_ ?_ ?_ ?_
 ?_
 ?_ ?_ !"#% ?&_'()*+,. ?/_0123457 ?8_9:;<=>@ ?A_BCDEFGI ?J_KLMNOPR ?S_TUVWXY[ ?\_]^_`abd ?e_fghijkm ?n_opqrstv ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_!$SMM MODULE -- COMPAQVERSION: 1.0 t虘Ā> uGSDuuu&g !_ \s@[ðD$ ht隿v r
8 	t .B(þ
y`<v A
N; A";0["H$[gύυH¼
^00D#g  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffhO	t$h=p$Ūr> .<t
.._/!N!!NfafPSRV /A1fpr  >>?؀tU.$p!`%/tA&%
 &N'N=h ^Z[fXA/A*P*ArP>4XPSWRhc!	 >$L u&E *Ou&} ua.Ca.he	tb.,Z_[X`v-[hl	$&]r
 %[hC3^%3 %^5aðÀ>7 uC t$<w:9h	R>t"1:t1:t`1: u 
ZSfQRW3:&:;;d <{L_ZfY[7 tX袎(YsljgPP=W6_@XC>> D>?>ø  PR?BZ0DQFB G3Å0u$H` um    =  %Jt0 	 슿	aL
  3  ti  MV ".  f@@u.2h"	)P Qt
RR=0폃@TUK}Lt?PH@F.0N!(7_NNOIO"`"GiXHRY.$!HW$[XOYcZZ!HfP3f&T ff"2,Sv-#1	 .x.tI1_a.S.>;sR2 hP	v  r?ߠvf r,wrgr rtB=u
p買a.H1[,k te6I,@ ۋ^SF ^ShyI	[^n   $W07PQRp쨀thGCft
{/ZY)E؎ffVߚ p d f3 Uff,﫺.v8vv?7x"U kJ\h	ʲ	fr  ff.4 uffffO ~?_ ߇?_ ߐ?_@ߙ?_K`2?0ؾ r-*   Ȏ؍6ć \ar6ۢذ {`1}Q
 }#` fhrn9f`PX8  G ~ @O  COt% r  PB"I#AO(A*A:A4A3Qvv
0U)f@F0qw,.
Z)`p议 訮!0蜮1薮2萮  脮o߰Y _WRq%в G`zP 0   NuzaÊa$1x$
{a1xCҾPBҾx3¿B;ra 76

 Rww"U/3	詨ug  `vŲ#3Z#U1}fayC 8P8*h >Z ucM&O腻 %L~;M;t D2䰃C%?X,%8Ë߃3 ?é t/Y h²	!v  u@qD6sL
 <40J ?aE$<r' @grgYk}I	$odPfQ T hRb.
h2f   ޿B  hNH hݫ	fYoPU Gf`hjS ?Ah@"oVUhD	D
  t{| uu| up Qf]FF$AF 
F쨈uq2فP[<u UF ů]QY`qIu]^Ar`> 0m)p@!L ahcy  uwɀ f  2f3f% `{
 0f  tfIA {f0 0 p!P!a f۠
 0XX!"f` `fgff%`  gffP+ A`- pr oaPtGX  DA ; Z x     ?0NmQ
迷`	趷<Pw2 起1DfWfV`2葷fx؋6f6f;f^f 2fSQfRWf3ہ> w;`Hޠt>n6 2G%GGfflf _fZYf[SQRVWP謊Ȭ𬿊33@ %	*//h`RmZ`ȶU 2.w@`7 22#+= v ؓp_^Z@$
W`_#P@PuJD>_ó !! +t$tR"u#!#$!L>^t>*$,A&+~A&EA&>p"t:p!sp&qÊ&&rs)'rq* 'r藵à&&>)!*+Gp衧܅ܧrh+FYs)-0*UðDD$&J ~26;̓F2؀w3SVa.00t^X34.^UXQ-zÃ&{'&Dp&P(@8A,w&d dtKs	2s;yA=o!> != At $`;3葠!1=<;00X7D4 ߰d.  Q0?
000`B1YpPƀu	t2-LX0ųtCyc< ø -iR&>"IR"^"R>	J <ð3x+q
  _NL?_& BRO	COH9ȃI'@HJ 2  uqS0Tg
T@u]<tuQ0uI'PVUiW`@tWtXVY
r= tS tD3ۊ:t
u
> u'㉇| Q^p(
A$ [fQ^$tBO	߃qaf`~Εǖ`fd w	Ca&ffg0Ê)v%ڐ;%@uO hγp$t
^k߳ph~p. pw2jhqfhrdfp(qh*h4,h[,䝐rr'~
ufZrh:
utuf>QPH_u(lr#  f&Ofd|}a1bS){-+r(*F|A}| e Ar~PfRfV r s]fPC 
Rh f[tUІ@ uJmt ;mw<f6of6 r-f֡gbgB
grff%q Zp fWʰ҆1u
 Q  f> 3{f`P ? t\ǀ t
tQ@ f f? r9  3f01f[ H; 6frmgGƋw g fgfVfr7g>ffP;wp@
 gf^u
fFB@pQf$Сftgf&g&fY ,P\0 x  $<@`dh <L Щ<@DPp @ DLTX\0 @, ,  ,0@SS <`hlp@< p
 
 $(<!  ,@DHT_ߺ ?_ ?_ɟʿ ?_ҟӿ?_۞xz<PXYhijklmno	

 /Oo /Oo" # $	` a>0pbprph0ɤ$蚥褿$bðNNO OhZsmû  (	0 @ 6f.fffDۘ   㘻   ߘc躘˄螘 诘SaSfrVW f !1!!ȑf%QP0f.2fff`7u_QCf"uq
q
fg^	Q

` f0ffQtfYm0f10fP3XPSVWfQs:3ؾ$Lي t
؀u uf>fpv pUf  fY_^[XÁPOu!W!SRP.VXZB!=R!{P ^ a"/7X;@! WSQ ;sHB     h v Y[_ C'R'=FХ
̧ڨ-fy0edˊ 2<w.
an"buFx 򥨟t@$^`-5\$ M.BOg ??K	&,Q- `0 t/tW wptu6tj$
 s tQ>10tr7~  s`E]:<n]BA6 6%;tr7"; ! :

wP=	2C, CO`5uk@@߰[>0A;>t,1Bu-  Q^$^1KK4{!/[P`4 1BAa3v5 g >DuT>Du%  l"FuIbIFtzsrD辣?"1qD菆&:eKRK蛣DLL	DÐWXA3J
g@TP1Bu70
P*`L
Q-tB 鴤?R>
2PS55آڢQ-Nm.M 9p9V$@W^W$$.#X$p9X[b4t968or;$< 7`];]^$U˴2S 907q>
u :uCa}>0Ct'\utu})!FrqCXYCWp>_b4uAe
eqePAd[Ä87FtE5Q@$^
2퉜3rz>jzs3wmkFE5!2Q@^ 708u
`[7YX7O;5r=Xpt3 92r1!_P=
=n?;r2sf
.y  S8{ a4d3O44<E5Q@}r]{_ssqd \1r&&a5$@W8lPm`{"@Ww>$U[SAQq00Ј^0ơDa@z /p/E>A u)p&:0 Fpg?zC,	,[À@r! S= Rp C,
,kDD`I@C@Ch?>pt+&f&
,6 r) y펔S<;w?<w2P)`<w< tН<w>r[hr/2r!P3S
1$pGuhu+	

 @`fPSQW3  _trd fuhy_Y.uAy** End SetActiveDisplays: \  R$Nt5<x )ڊ} 8tu8ud QZYYQS[00t@uYXSQ2tWYE  J@t  Y#   1<uȸ
 mu`Q 	
3 0``D  VYYLu
  X!P6 [7e Y	X79иSRגP^PZ钸ڒċ؀ ْX!ђX跒ZRcŰů0tǢǈZYRq`ŐƄ tu?P00_mirƵZI$QRV9[X"3tϏϔ`
ҿ\u Yc h@``ϳV
u 0r2,RW>_Zptrp "`0&& &E"&] 5  'faP9??? SWU]f_fSW_Yð VRCZ Y .t rH rwt*tWft` [݊_S f&fǃ`b1fWfࠎˆr	 C f_Q`Vt' tf~@f ITA gfؾP 
 2gaYd 
`tX/EWH &=&M_0g.g͵ 4? t0;r+gCC ѮPhӴlb&@puuU\t VܾYf? fAfP"*6?`Ȏ؎-t բ (w >਱Qa thOQo <ܳ O *wG*A  />PtO 	t8 0Yu3PuQ%<
uQ&hC+u
3uCumrpuzgrAfN*VRWԷ Z2
a4⸎߷Y߻ wpt޿ ?! _"#$%&')?* _+,-./02?3 _456789;?< _=>?@ABD?E_FGHI `$`<`u*0 ٱ.} ۱1Lq ڒLh ܱKܓ u BٱJ. ۱@cOCO!Pn ܱO aŋO` t@BЌ$?`P h3XggW[0K8UfUg0MWXfQPSf3f3ɿޱf0e [P tfQ\d ߲ \1`\?A^\[SC]P]^; Xߩ t\DtOݱ[Xf_ ù@ fPffffX,fV3ɎhcfVf   E gf^!ff^[Vq[[\$]]c )o^_6`:`a/ݱb^bHcf%dWdZ
e8f_Br}@fg&' ׃`@sf&߉f_QWVW 萁 AY v~dvtT{K:"K;huB[QWw3zHwY;uY1^l>`xu5uz{2 6||ـp[QWW ﱇRD {PՀR;BFJ!Wf`f2aYf 
ɀfvv Ug&P t1 ug&P2ъЊ2! օPffa!AqԺGwOpWf..
.B.w65.Ҙ)?v
 .f.r.Zr! r PX
eu`Pf hGy3 qX0u쨀t
q<u <u õAr$r s..+21õrSr{rl@-UԡFő\/  ;"" QY;S]]W௩ r&.&POEyu' r Fr.&[('RP
Zr빸Hrt2ZY`t"U1SpqZZYa~r#ꅻErYƀӼ10x 3f3f3& &EZ2 Q&&,r#r8t2.&&EO h3'tS؀13y[&M.(2{$/#h z 5W h3XRh2h4S_ ?hh[|ҝfZrh  Ѓvw`35 &E
,#		/2!&%00` 0% < t fpaa`6( ? ppRV魆ī^ڐWprP3 _r-˸ ヷpXD uE/DStְ/BOb˰rDrS b"W2&*G_YS }P&*u&}Zu&E_[u _f  r\2ۃ<OuB<tLĎ`Ā[r:ѯ" r ^r 3hB1 0S 
pq`tu$<PtKu qBpYPW @Wuu2q? 'V o^Wrm_qF%Q͹ Y9BfPQ>U uι jred`ϣUY2stCUGr-t`w 0 r uҊA r
6u`d PrdItf s`Q0[3f0
0SRNr&r!ww3҆r r	sTfPR..sr!p.Ф ..Zq
pV{Y
sjb
[`r	r5rPfQA dtgfYuv>? fF@eT԰2 Clip@ >
  Pϰ K#2Ð,P ) >>?@uQSV-讅 1޾> f<$F10tuP"X4 -菅^pSذ*z r[`ސ pPSP1.01 U Ȱ>Īp0Ðp0zp0?1gnQ1a(03Q031a(P>t=
1?!'q#Sa5 t33}|"'z.54
t8  ttqÈI<PQRWVù+3> ? ^_ZQ=C>3>G<u
t ?{?VB_B'CCC=1a(^Ћ>?FA?!`C(A
g>"'AP//\r0PL撘
PRu9!?Z?V tU..F Q/F{.^P 蕐2u`S!SRVа7rN UNrC2r<,r32t  rr;wWҀ sڋ^ZW
S  е0u
˾   qSu @ fS· u^f2_ J3322^t`__ ``ZrnQc
$	"
u SƋd;sRZ3QbFcF2 52te	u
S_ø
_.@...`rC#r,蛽3PnpÐ<
 <`q<T2<`q
 h <tu w/xOyoz{|}~ /Ooφ /OoϏ /OoϘ /Ooϡ /OoϪ/OoUPRPRVFZX}гRR3PZ˿/O oϽ/O oÏį/O ȍͯ/OԌȎ؎0JЍMˋwhqa=HT0IS0ff%|h f
  fȺ41ًf# uOt
\f   t(0,#%9=tY@P!`71 0ًa@ t@pf.7fuf0f[fYQ]Ξά`(>`^ϠbSW   j u  葓 腓f@XPX	wOf`=@Hf`=ø  <ZuLPX?mrm PX/< l@PX hDUS ?1h60f r0a=s3  t	fa U
Pú:tt0TfPXtA $t"t
D% t
H"W2	yfpޠd uyPڀxf|q @+> U%` &֑B.QtC t࢏̀&ߎ.u'u!E t  t
u
Q S% [t!A	u[a2PRڨu;ʤQ
	O?  3#Q >7
Qp< t
QA
Q6RLsA:sp u
!pSt`t	t
Zp2RPv* XZԠ.m.qѺsѺ.uѺ@wѺ8yPfSR.yQ~`wс $.@,f`@ ًÏfZfCPb%  @Xd`!8!## ΢ "
o6p2fSI=a#t7  hv fȿ ffA33u^_fZfYf-R3һX3t@s@aQ 	!`!h"-
 M.` %O`%W T eff   e_fYw[S50hث"'$_2`%}x8xOα
$$,2沬Q a!fZ"OAA9b&0lصٲ1MAHh;
$ؙR]۠Xإ9ױڟύ:H_1ؔH)0DWjV0:A]ٶ<A>a1A>h<j?PXӹӴ 	7h}"'Q иfP OB	 ࿬ӹQC0I	#h	DrԹ:ӹ`CP"	s(m苐J`聐J}  @X*JpK0eJpKD3`3 @f`DD..ՐKlp0JpL@NNNPJ{)QQrDRN3h5"'& ߺ pPSS GYfY[XfRXfYuY ~HZcPSYZZ Qf f[Yf$`@V ⛹ P" J1'uy r} ru rm rer];uJBOaU ToV!ODO֖ Dr'JrRrCL M h"'u؝`,xqu ȐaQcmmd BB oYÜRonBnBB2JJnB$rnnZRV!(u/ۮpt6vv^Z4QVW _^Y`%pG`z2䬊
qGa桠
!  js-qix3.;'tCQ=؝rAil흿+t3Њ{PwEa&KøXԻ hûHvkos;OvkPvk3;t<uP.0D  Wqq89:76Qtðq^oq$Đ `S0dU$L aĐؾSؑuqSx3N &&y[Ü`T   rnntPnJFn aS  2À3ێ7!C &?!Cu3ۏf&>CPQCu
>W_^ _R .'Z0hS"'2< S .V[x "= À>_ uamq m`&o&O&7ߴaPQR=f&f=DtZYXð@zmAsmȰBlm4rS2&W`g0&u&87u&8Wu	&*guAӀN  YPS2r(ں 2]Q tQ's@S
y#Q
 rWqCuPt	 r _#p%r2߸ndӺQUYP X02T I аOkLk;vkJ &t }uK :3覰IPsX蕰̋.BX_a?>89&:-路 ΰhf"'.V3Ɏ٣gi
c
kİ u	 puЯPQfV;fWh"'Ngf&Lf_f^YXQWV߮
^{_Yخty+t1QWPPEhX@.X=X@uX_YoPB P!0%.W$>u
P3j@XuSWh , s hc!#'>&M&E&M~_[`!>푻$PnPt3t"3&M݉E<taðTCA\ yH4HHAb*MH OaH<RwS2.[Ziø `i XiаhhȾfY`p&0f3ɋ&G    `f&tffBf;@g&Gfw_|wUtNBtG f%WQg OY tghCWa aAA2fPR%Uf&fqgfd`TO_I CPNFOR J 3fSgdfCf[ u|<{    Lf@t6f!f! f3@DgE 
tfEF!t{ f!}	@C< u0C u-Q rPmgdCZrLr>r0r"tqrqgdK&@	#f]!*	0%RP%h"'h4S ?ڑ h rXD.`][V0E]f@d}}Q،M@rDbE; r .%:"&r'$h[| A[fZA
   !"Pe#uB$ڠ$$h'
*r0fRh:*Zr%&'(*)+PS">[S JhJ&2rh>22f[mϒݒߔ*tHBDCdH|B{@BHBH
G9G[
:BfŒ^;5YHBBBB   K,_'VBHH$HBH-HH0H˯si3ޮ{ѴњCH5O&˱if.PH!u<u<yw6Ocf&O	.b.l-bSؠذsbrb} S|0
Sp&;xV4t?Zu_P׋[f{f[XP֋Q<;<]^t^u6"^al`ff0-s
a>.h|n P\ffV!fP`edHbQgVbfA`ven }hab2+shadb^4@db:aeb`uWt9wdJjh]yF sr dKnv1khwopWA`Dbeb fAקtp	_fYR_aZ` Q<Ěj%OPsj߈a]àAn
4fb<sg]  rb
VUPSQ2ݡFF F3`X
A u`&&&; QX@?PFpF`XF0Y[X  /OoϢ /Ooϫ /Ooϴ /OoϽ /OoÏį /OȍͯҀ/OoՏ֯H ۯ$P'"dܟ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ?K_LM  p   
5MxMQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_  &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R  /      U NAIBML 761295520C??C"r   2004/ 20 15:22AL "BDR(7<C
DIAMOND1.0 M10P 32/64MB BR7099 m/250e
 (C) 1988-3, ATI Technologies Inc. BK-
VER008.01p02
8  paDMND-7.v611  P10 AGP DGD1UN  OEM VR
p21 h h q#.]-   .q  APC:yPz/0$TVSQ0  ' >A  RCPCIR>A 
MOBILITY RADEON 9600    ߈-. >  !A@ @ D  H00
x$   Na  AS !!0 3Q0` OD n@P`X PkR|q! rXf%hA A0q @!(= xr&Ϳp *** *+* f*` +*݈*!*I  *Ph1&*/*m۶z 1%c1""sM[
u ` 8{Aߴ
 !b7( q!aOU  L  'Hp q Tq //DO)q))%2 21	Z @9 dM>A@  OU ? 
>n H@a5AD<A4`??A w M0LL 0E&Q11 
%1!(A1I_11ڡ:
`(50   r-A!F 
%$@l%7   ?N  Q 7 PQP0Q R}aR LARtpSR0
`(H < B -p72p7*qUUB2QBQTmA -5@p  @"uu-߀ 7_0 # $ op   2 2  \2\B\2    >^ %RA*@___QB!<_B_AcEucuc&c1e+_`_a  1*Dc*c*d*&*e(H?2HH?aQo$

3@b #B@kA@A@4A@
  P  2f8Exm3B%lt)@kv;  v:5wg
`Dk dxhy s!"v{v{r  V}t  f`.>8 u..8.:	 u .<.9 u.<Ȳ.8fa.Qv4.>!u.Uv.&Wv.SvмYx.Svf`f`l1INIub. ST[)$
 t.VW _^*FIRE GL [T2xcCPU$/U}T+$X-aoATpR	fab4tW.`4P mX ` ef"WP2X _W&  PXuC &GOfGGOOf& G OOR? Zu p+ ӟcP2?FX1FXfP9SffM f
{$ f$fV3s^mns~X=ZuG販c@=V	)4 
 ¨Q
K谎$RC P DXADR ?u+br=2et tte0įuQfÍ;Bm&   (B,B>`@] u0>]2ĸ tP䍜f@ f| <1~ O5@p#@@ ѹBศ๪.>]ȣ#$ $Vr <v  !  32Ĉ&! .@2xd^Ð	AaNhVJ*814(Ld
F0(1!5sF
 a{$ 
Q.#Ń>ME F
u6]c赧dtta/x#x"txb2>SFN)N=fd{2`Sͳ Vapϻ b p Ϭ  t
u]a<ϒ ϋ Ht1u	 <to tjf;Qs Y#aF;$<t*<t0<
t'<t<t)<t<
`	t<t(<t<t (83
mh(c"I/ ?F f; [# ~ tF: FfF6~Fg wtn<uj`нt }t ^"N 39X8u aP  $X"8t+N ;N"rҿNN"F;t
~<uF1.a 0s2~tRSf_ߺNfϡ{ @a &f݋r  syQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(Ч( tR.&#8Z.``[PR.@]t2M ZX`@ F?wvؖ@:y=0	;5vv p tU;5tBEt:]r9Urmt5f3vf3ۋ^$f3f!CPs
@8sn~=}:n=a	  1'(u  	
 S?Bb
D"'b
cOQ]SE5
Y  gOV`Y'OQ֤NY"RR0
5 ,jcgvWX |ce
p$Vcj= | ݄hs" F cf	
U'  #$cu#ߥ%$G Lbcu#1 (d9#`t{2$ WBҟ1(r$dS Pן/?  =y.ҟ)/A×.ҟ1 81y.1 -*/0*y.q+ǟ
N/	
py.`t_ӟ,/
&C-@55B
?oW   A13ҵ SuRBoYW]M  aBip@ H!Bq`@?J`H!B@BUD`axQ
u<2ū jH`HUH`HH`HHv 3߫ЫJÀu#ڋHqLqLqLBK  `Ku	 2ô!OUw aF@
@@ [ ]UHbuqRjRSURSRSRS$
H\uWt0@ @`,^P@Y Xj  U    @xP \SQRVWf<t< t ux.D.< uhdG$?
t\2 0tʊ»d2..;w*`( @9 @..Ttd& _^ZY[&G@`Fu
Uhhh$@
hhSwZU G<uTG<u1GHab,Pt G2Cj nuamG%hKru/苂7BJp!sjS s1rApcppmGh[S FvwvXː.6
bytSzu@G2@  v.(4D
^.;
E08Cn
 {nEYVQـ.ZkYJ	 
 pfFn FnF@ .#$FDV .8졈Pj Bnj@{pAf 3@6nF:qFNF :yF%z"Wo  _赛QVY_Sb[BSW%XP u2 ) N~X_[(~WiXW[_"tF$F&0n
u9C+$
 jW`߲W ^W*1@vҙЌf3ɑ v K^Pm mNaMᱠV0԰߀tpGn} pK {˿ y -^ZAXCPDu@fPp  w@Vb
]u`
&V"tMzV@NIt<uN(u#a?@V faO ""߀t>0SvLBU[w߲Y$ pw
u2B[XS\DSUD  aU)tqAUtA+Ut *U~ m0 t
 wt Ұ-J
tASuT@A %?P%@
Ā?
XÐ( 	 c-'(+ B? O D#Oo§PPBc_OPUJŁ(/Ooȏɯ@ʗĀ@S  1PS0/Oo҉A@ T;(  Ga<! mM"A](
cP 
   Bbc7@O
"#B(89:;o<=>?zÄ+aGŃ_B2ޏdPࠀ"ozcfkJI2/@`ڑ>eꏟ2 _zP~P 
> @4E( f	

FP2 	 WDCءw_z %( (,%*26', 49$,0	
!&.3+0$8=-2o $8?CE  A܀8tcP#P\	2܂z(P܂ģw ?\Oo
`ܑ -/Oo	pޠgwrgwtf (2ȏާE ?*x?(_
`A@9A@`NQO/bz.43tu6=Oufo&5.yzP=: sX.#XѯBү6$ө%ܟrlo6*#=REFeD=$> >D8u&P$`l$ZuM<~.;u*6O<t8Dt	\S
OX:PL
uX.체0&G	tԱ  WG	0?c
u&.+X&c <-fKX FqBBPW.E#16_w^賿uиu
{2aX&IgUD^UD 3p]U h
F CE]Y[	QHFXPcw(Xv 誉>S+[( 7w/wu n9$=Hu m8
uRHGOmt999999_D]#P[U XM-  ڶu辩tnG vGU]Q S[ [S݋ L U026'C[2S  &'d[ ĸ Ë#RHutet&FS޹ 2i&Cidrvt	 Fb7	 2edn Ȋ3SPA|.0[t Pv PH7t@r̓rPHXuSصR[0U	$
Л[Êgu% ot4$
@ xCx t$ÊR
}P X3<Jqhu x<~$<t <t<t@؁ð@} ~}4u{}Á@ÿ)(V(3  @
@@ b !"# 3@{tb
%ƿ`]輁х{SIp(e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;upopuK>L tDI @.><]PH3ug":]<~8]&g7)0u3 32PQ33 YX2PR94$@t_ZXð$񓫨ӔBДR< 3Z8 3増 3߲SӔ3QӔ⚀єQR$WCrCTC f3fRȊoZ찓ПZX8t ZYX8ouTu w2u B83$
t	u$ O0t PwGXPG0зu
u$0<0u &o6<umA	qt	
t 
߈)<u+뿴1u P^_3u< ꑩ㱇܀4u< uqBPKV6u& <t	 z0eB"
С( G I|%ȋ쿉^NR = shPSlBЏP ?Ȁ>cuA-@ 3ۊ'.B.EJ0eXB]0U+{t8 %J|0<8t<?t a .B  躻 밠|%/ +PQ ȿ%K  =Ki Y뇐ȹ 3Y y2Q
 Yc.,bb̍, *S?PFϜrŰ G{	 GޝåA~~|ֺ| |8` 8|T8 lp <~<Pf ff`֠֙6xx~~~p`>>66f<ff<  >!Qf! f {; <f8ll8xA~ '} 0pp0AA$ff$n8|||aA<< lllAll0l ~|0` 8l8vvr >P``0  /`  3A88 A|| x"ߐ@f<| <l a|p |~a 0 A0a a~ ff|fff< l l  b`|``pƦB @ '<p  `bp'Ƒ|:a|a~ZC2sƹlpPl88 @< @| ,p|1|A0Ax|~ ` pPp!}6000ݫv@|p8Rx`flxl ' lAA2!	| |p	 | 06	
vp 0d PQ' QP [vܤA8@`׀݀P 4|eC5488C"l8|aja4f4|C@ a@Ɛ@l~n ~ DrCR"b
~ l`fl f`>c8c>  >Wa<44Ԓq0
܀
 ټ > >`gc=%C 0`p` 0|6>!(l<~Q! ? 6ll6A)l  "*U#+w+,,6---E--u/T/-"-A,;%u2@a24a4-7r/70?A?0c644t6a64a37a8A3c96673R t/65A57t/;A531a4$@R @$AAe@  f 
x+bݠΰ``~س| 8  l8a2l%8fƂ~ | 8`@``121J$~ @pK@ L@&,x aKp֠S?8 *p01|Q5QӁ'Ӄl0Cpԅ0lՀWշa֥@ e@1aץ@c@ $p؃#]ރ"PME>6vgf ~A~>?~~>`RւBf܃ h{dQ`||NTaޚef`$,ffb6 RZiQYSZBs-s`1DdxQVObf0v~T
 n@Ps@|2Kvv8FItGmz ipN4hN# Rh"Dh@Rm @f!N"|hN"~Wz {2րhp hRe!y_&.jf`d|d``몘
ζN1B# ǜ0Qu1a PHx2px旉p WWy@ `f`va c ' }N4inb$` "܄ĉaPhg6 @QN` Af @$,	VB	 ugƢQ	ĺA
  "Rn 2tzf@g~ 0fݴ  Aal1pӺ4_A`̂Y2{0xC))Ӊpxp*C ** 
)]e$K` Vf߄* )W)) INHwAl ` f1`1u~acc0c! ~!)K)V a2u$V0t! 3`%3R B< ;F@>up|`i ~ :T@Pl06>6n6@OA)F[00)~4*~D4+ ++*e2,Ft/ f/iZ
-	K/
j<
 0u41l1~K2 le3&]8| Ft/c7u/6~E7u/ 7'c8F:Z9 r/K!:'Fu3
 Fu5(
F& MMF%@)@[@-A@A/u0_2CC!iBDwb0PuPDuf|fFul2  UŔGGa``<fQ5HHʵ| `:~0"0JD~UfE!b|
/XrMOM{4N4xO-Kx8s]H70K~"R~O5t?W2@ _&&MTWI &FG_&E"&E#W~m_&]%&}&I2.2
t@ZW'YpW)W0W = ~=^~=~=~ &U*&$
$

S0B$
pW-pW1S2;t4&wtWbcbcbc]2RԊ%W+F0Zt=0iebh ݸ  t``jt:t`k?Fh׿܋ qjk?kuq&pllrj
'fkn1nnmڊ0`JR 2q@s &GFt%G uqtGÜQW+&=R&D&TAww	ww p&RWw_%&TAP
 XF2 CzD%Z|
{#}}#^ }	 
} {`@{}_Z_Yσ`v#wGQW(Q$0U󤾄0V0 tS|S:a&?Q$|f PzG }	ĸ z{ 2}WRЋȪ"FysZ}2fpt	2PqYCQEPt&GUwRw2wYh`P_40`VY t'wEPJJ B2BBXJ4wzUm$ԗ/VBBz3u^ʣ};$]:/ (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0433258:=<:98899:741	
	
Ш1

	

			P


 Bp#
*Np **u???!BPL Q   $$$(((---222888? ? ?/ /? ? ,Hϸ?'?/?7??Q7?/?'ȼO--?1-?6-?:-??:?-6?-1,HA   Q  O,HʁQO       ;H
Q?
O

,H܁ܿRLP$
XðN0N_ğ  qt>I~&G3up	u&Iút^cNb  P3&2J&oGWߋGLaģ`À0c? Bґ ZRmmÂ
  !"#$@ABCDrstuvk(
KQ[}Q{Q ;Ql(L!\!|!<!n2ߣN ^ ~} > m@M]}=`P@Pp0 aPAa	Qa	qa	1a	bPB}1R1r1!/1cj)dCSs"?dU/DT}t#4f?FVv$6@h@AHqBXqCx}qD8qrgJȿsGAtWAuwAv7AeVESA    HOL_R  "'ATI Technologies Inc. P10  01.00  @ @   V  : RVBE/FP L.6'<r2.\WVSQR  f&=$2u " W_WȎؿʾQІW`U`U" uzw &uW&E__W-WU .`.m.WU .`.X.W . `.C_ǃ"-W .W@uZY[^_O ËRQSVWU?WQ3P)Y_u6WV6-R2 ^_0Z
.8]EE
tE M]2].l.DEEӀ~ZӰE_E!P>#P> 
E"P>$ ~7`>>!?~$= >`>A#A  @"%߀~= EeUe@ZBtS23[@DN
tȈE}~=
 P )2E*؋EMډE,].

"+E04XqFPk
 f3O]_^[YZp5(RQUSˊ$6w
 K< @t| dQLEY
 b 
-ŀuZdp<T2ʋD<u<t<u<uA92PQ23`6 6X23 P XPC DmID2}bD@O5tu0\.<-[@n2O[]YZ5ø WVP$6OشANt8\t 4	2^ƀ t 3Ba@^Op5q PbA__	9C`3_" PWV>~F^&Vf=>^_ÊFG< uûY.>].<Wh8Ph
._twCCvPS($]i ^[XS0[ tt
uPSR Z[X8
t
߲<lrmBB@Z2ÀuPptp<wjut`2.:]1aPS`O2ˋaPXr(
uË uW3&Assy0_ wA5Op5< uL8赿/؋EIS [`U;vȁ~xAJS,f[Dt@S[%@SQS/2f3ۀbff3fY[f;Ës )A}riflx2uGf`P@`RPfZf@~ff3.fX<u軼S$f[fa= w=fPj$i[f%fPo@}~ؠȿXZREZϋfX25#y
uQR~ZZYA5@ouRY0ZtA5{3qt	Ao"} wl wf{=Д]QRWAo97 f&pf$of4_uYx& n  T8<\  VwRfpmtZ^fOfˋn#offfPfVX" OV $ѓPQRfRfQY  $ $  ZYXѓ
Ao@fz`ffv)Wf $Ao0ЖBa&`fIub'&`[\tQW!$_f.ߗ Q;tSΛu2 `X3ő`,yQS߀u0}3ɆtA߰
ڿ@5[YQ
$YA5`v?SQVWP)*# `R+ &Iccb^Y[A5PS7QRVWkE	_^ZYPbڋ_  f1 C5@:Rb`MR2 Zt $q
  tőSR suZDQS0P)(ǘK@5&= 0yRjSTU-W:VWXYMYY*]%h[[#O(ÐPMID[#D] $   gأ#$ $g6]XR ZRw A
 A ZÜW; _Üh @.83d f.;u	W 
߀	rh2[fXy3E& $4
zڴqffQQ2
QQQRWPH 0KfXR2Z0ff_fCXZp@"@ff/FslȈ䛊?jO1UR =fZff_ZÐ恁fPRl g +q7KK;rZk S 
S  S@ [@hSSSR	Q@Q `8QYÜ2C @@h  w `  b d #b)i fp3.Df .T
.d"rUA T'ZbR	F	{
r	.Dt fXZ
rM
TO<tu
D @@uw
DJGQ e8tqsu*cr Y~0QPWXr	8u
WP u5,XP	 "r%Wr "tr{Wjr "XQfu&2 Pv#t(SP?u$XP)rKru
 uKuXйW_ _3..QS  " "O ztGWrN " "r0t;Vt3Wr,Gt$Wr "r1p( "B/NKuй`u!Wr "dr
~ "sr'/Y@lo#s "RP*#s2Z6W _YQWs`)@8ťGr	zKuq_9P Q Ys% T@@MT@@ p0>gOO<Su=rjT[rbf١EuٷIrE8w8rXIP2XP2r+vG>@HrrvG% "r 謠DXu3`Ptu3S Q0;XY`[<ߢt<4Ⱐ[<uP<PPPǃ3艤PQWGGN蟤_YtXu5BSSpжuP;ZWPB_
t qoMnÀ`DBjt4`:uN`o0XX	Y u	n	3	u`wðpPXq^ðN<Zr,ZP2`N [S֠]`6_;w2XXXYf`		0uyt6P%2X dߖ O{@F 8t P DyDX ut!P%d Xtp.ueP dX P )P%dt:u@PXt0P^ i #u#P	kPA i 5  @ n
g8P
uu[XfaPpy	t_t2sA
RqghtuQQR_L s pqespqHXQru
~	bux \`0rsst@uhf?gIgt{ |ARNQ=QwQRڮdt	tQ߻;hQh.? t.;u.;Wt3!@^-'(+ ]c@ǂh߃^_OP{U5 W֒ ?o XGW  OA  σ@CT&F5Ď. W@)< `~<+ W
2$!SQ
t/+ '3߀t		ttuC9 cU *3h j ]aS3 A[/B$J .gSJ$
య42q	0﫰
50	zb 0W	
5
̿Ý0
Ȏq P@$/$@
J@=^v	@=vQ$?
úZ[wS+|`~۫IJS Q$p$0fP,(QT  P{cfX[S<S;s.:Guu.9R&$ZVWQPSN= NubwxЎ3f<8ATIuI 4ك4 t4D`#u*D.XD.Z.".#.>|P; [XY_^ PV
l<u2pc8uĊ^Xû..|.?tup.G# `~ ZYWVQlpZཌl,Y^_ÿ   SOUrs6 2iu lb. t[uAfoPsX`g'uYbbIhaa/b=d
ȿ$ p*ko5][3۩0   vрP! rXu22@t! $C Y0rtPLaW@ pa$aa쨟u1
 ع)$<t2
*آ
P
p$
`p|p0t$$ ޢ_$aߗqଠP ހ}0xc$
h$w
$
P$[4 R|1)&|x ҬRUD شa발bR1?$:awLiq~$q $@Z@w薓RSN%`'`"2[4$% 'A갭 ߤBQߢ!c0xPwQXPy赐R tj}kmukl{^^u^?_`@jFF	I3I+JF,F"FҨR<"yqrl%>PjkluQ/v3 ^{^n_^t
HtI7H"[F 16 $Upz	jR!R?S! "
 ؕ2ɲ Ē @j{vrR]$UIГ$
:쿲'$Py;$R&b #$P_
ĳ~R$4=(0$ ,1$(ӬQW2&d`F20x9Py< %
oMq@j
P?PP.R	tP X?RcNtGGFqr NjzhCjiiu	Py^Mn	2v	0x<&4\Pp&hnP]D\A(N
 d Py0xa*qnAdublgGh7hiA@juD-0nlC1/EFF{Uu"[[y[\Nx$ӬRW&I<#t=<2t9<3t5	 ߵ{ 	
SM[p_ѬfAPfX d.
$< d<t#<t<# < d < d <
 d ߋmeF* &E3uu u	FfF40 B8BY._f.EfP@B .GF4XH u܉F6XHf:f%  fF8fXEEf;`Df	F8Kme2..>7ڋFF4`?f_[(P !ea?E dSD[ d  Mu	 Q DMtR3ZF :C#PHF @DGFF
GP R{FG$`RF D	F@G 
G.M	̀

UVtV
ſFF	@
G	F	 R
F0GF DQGFG
F3F'F2F@FB DBB<B1@ QRF;%<t7<t3/ =@=
<t<tn2NAVB9CzFXBOdoef ghik/lOmono pqrt/uOvowx yz{}/~Ooh S(4f
   (fX[QH!, ĀuB  u*@@fDGtff.#Gf.Gf뺊mРuRuSC~
[.O.t	tItﰔqPIt$<0Ȳ2Y WB_@ n }Pd B `  	 ް R   p	 p p  00 0   ^{^^^Ûp`p<p1 "0I`0М0	 @KZPB  fPWQ2ɋYSQ2xY[SQt9/3.OɃ.;vpD2զ2Y[VS^-U5UtE*X~ QSfX PQ3@G YX fSf f%f[Ӌõgf[ F @ڋÐK
^_fX2QV23z.^= v8B} YRfPPfXfX`fPⶁ
ŠfXд<a  ѴoaᒷCֺ萾AQ2]P$?Xk"pPfQfR荱	O$8BP;%P᾿1$`i%[pX3Qf
BYfPPfPVa.w^2fXpþĝfZfYB&1u5f`C$PJafù Yf
(<tɊɭPWVRQ+&G
i`36 2Q!$@fX&2&YZ QR
FFbP$CfZYP:rSQR߹.
? I< Àtnt11tt"v02ǟtR` QYyv|@tp.Q
yYf.9VZY"SQV UwPO<``up It	-.Xvߊ"$o
Ypյx^ FRf± f.;T;vqvD :fg@wQjvef+бRvMK?v?Av2$v%vS%	r,w-ٟ{ZY0.WC D._ UNfV f^f@Gf.fff;rf@frx@Gf.Bٱ?^f;rLf/.0f;wff?+f'v
ACX.L9Q؋N]^tEt= r = r;.DP.wÃҰDB	[@:rp À wtQ:$Hw}^pwYܲV$T$QP8XY0AX0cS[$yg#ܲP%&O@t$&W7u t@a@n`"`HQZX" ZX P:RWۿPtݲHЊǯ_@ @`0Qf6fs BƠ薐 _E-0" PƸff0"
"#>#0""# j$P%9 f=  s{f'f_36&S$ 5 6](f6@$6;Ewf6P%ؾڲQڃp39Z71PPƻ5ft0:f||B  qۃSf4B\[%@Cø \Dw3`Hjðl +@KK;r02@S 
S  S@ [02hSSSR	Q7Q YQ2 Q@YÜ2C @`< 				  >  ޴>
U92kٲ[Y."D
$.
tcs] Cp %K2oF?/CDHհ0 > ]ز[&߈EaIP D@DBOX D~0I&DVDgBG&^Lو$^Ю&O1Ftf
^~opXf_Nn@;wP ٨[Xu;}`SfаظP٠а UbFF pW	T+=UU0
TUwUF00F+UrU	F?Ȋă/uX4J[q_n R%WX8}UF%z\X0v^PFf=￸$ؤ,fQ@f
 ZYf Ë؀~Àui΅ָ
tQ$<j۰`O$
R߲A HZ02 }A8A8,ooA8Po
QRc3ҹd  2R:(l.gZ[   (d
$tp  $$@!R
u{&41 *0) u.<tӲ.8n3Ý W߃ z1j[ ßWQRVS1Аjղ+$` 2@ WfuEдXf'ղ|P 3ဨ t	   |X` 2w2a]2I=P
@7_[^ZY_B(-:1 Ww2`ftu% t EfԞ%Yd{p B `Ó ա @ uZı 0p Vf^fPBo 	 v ƒAA?$W_  oz9ËË趿]à_"ϭr   VJӾy u ZX^.t6W+ӿ	ԣ_RԤ0VSߊ |;uq[^¥ҿsaҾ@}^(w 
1  3"LңV/胔@3 500QBw`X:pѲq7Ҩu3S葯Ѳ,Xq`  0Q  0%qҋ@GY PԂԝC3Ⱦ
 033 Xh l   Bp   & @*@LN  QRSUPػ
P$H8f0 ѲXP%
XX?!XUͰ[psQP ?t@ t@`t: -оQP@б]ѠP s!BX%ЯfXX2@R_څ1ps:s8  +.,G3E$>\F N(L.֋F2Ϳ2K ƌq\l߄K^ A呌
u3ɻ@p4ȵpNju"@amQpu	а R:p;$`?~Oβ)0$л 
舚tuaK_t  q 鿈VˋN8ċ<Kt
%$

_m@(铋wt	
ɀ0z~ܿx}@Z3݋ZCpۊ2~Jt7q2q?q0a`  ^tuͲ&$Po
PNa2ka qAYa   2 
Q}PXYP^8tuH DV%T$ vȰU$ 5t?-u0z/zT 	u @ UNw҉׉IЉ;f3.O>f.O%"߲$ (
tff f `f._O>uuh\rq
Fuq= Nu
_u .&'b
 ;Pu
5	<V1־p ׈
JňBƈߊJ鸈1(`t@0%$ 
"u`$`% jp uw mPp u`($m5p u/ʲ"+p2ˀu$+,pmp )pC-$pQ߀u3tFa(+  2ۣ*1u l$>1u7=q(,m
7 1*]1 ^qbNp o
ߣ*1}7ZXàS( P0D )/[XÀ@,8tBu=8S a[
tksE݊,FGG=%  D0zkU\2:1 I P L?ɻx1H#$yɁG"$xt%ߵfQ
fYfPfQ
肾LQ蕃Lȝ MkL@K
   MZrLQz p&f%gtP
%&ɸ|k qY`eȊ/ S ]MÐNQi3V
wL0W
ĐWø PSS SM   uF[p\-\mp\m!ZZG&F诮Ѧp`p\帔p\\ю师a~0\ ~P?f1Q:ȸMp\cUO[p\PfcG0]?] _ /0^p\'A!Z2_%${ø帕j akb丟a(Pj>ǶsihaaR6f@w~j 丕ek@p\@r @kin!Zl Jotpoap 3ItRZ8uR5
Z=RŲP x?XZ`?$0f! L. f.lPV#|л䠌Wq t bbR23Ұ
)uB
Z`..@] un> tgb2P>bP22AQJ2=QRP  32䣁ZYYy2 X aZYYR*8}2.8]ZàPm 2Ku2oW SQj[+2Ê2+ꐏ**&R  ZHuB$`JÜB J.6]ceH   `PQC3BBaaPQ YXaY=ԨuXÿ&NQ+.J8~ذ:]$0<0t<]:Jt. ÐS _r+}*2+ auX 0u*tX⑰ Py. 𕐤"㨀t0׊4"
Ê4"ð( пD $5m°݁  +ѥ,QVW++    U_^aYԊǊAдtb_ 8v2QY2P >ItP
RSߒ  PL[[ZRJ2ZË.b 03<?& t
uV Eñņ1?&JYZИ[1w2RąZL -ѝȴ aǋ
t
2&L ! >&}S`YU~ J<t
pA<Ut2[ð
6%ŀ2+Q++YZ+Ջ+Nu`$` t @ut|q Ҋ8~
td\8tX΀|I~D*
8t8 t2
8~
~v}tɊ*Ŵ
RQVW3ۋos@K 0_ QtP  _^Y@ Z^QR4`$G  ZYËxs_ 	r 2B	 PO脊=pffIhfƔL/ӲS[F fWfVfRfPb9fО`+Ɗ2BVZf^f_SRPǺ@fZ2f@[wpNБwy} o&I6w%$ƃ|t;@_v[`ovI鞃袭R"Z~ R@XR3Ѡ:twF P+>Ā"+Zh䂱toV	#+2㲂r~|@4ߋ&  F适  +u &F E&  qP 1+>2u	&}uƀtGVW_^t!3ut
>| 2pQ݁|u\ρwta? `rq`u
oQ@q6JX 2BƱ#GS
Ow 2@
pFf0"Ku["31~|AyX@[Ё u龀G鷀Pr>FX$6| 62 tm߰UP؊P0u)#ë`4&N>Xz ?}41{6  P5O 3Àt!&0Y:75? 6$ &@5O:&; 8r2Ê0⿋2/ЋR$aJp 0PXWQP͵suXY_>{Q I@DY+It";nF_v/Fov
 $ _u　PoP[О.XƋ`"Vي1|pF9umdXPRJWQQWC_G?8v
0EG Y_Ќ0[KZO&%_G+B;v
pEP` còθA/#!_oҠ1K@XL%MRWQRQWP8tXoPӃp&$CX_YFZ Y_Z@D]EoUVX/YOZd[;[@OG\U\]^c^>ct }
}>
u&fj3 f 3f$߀ l
||SP
߃ 0t&ۈ@p p&]X9h @ QqGpĀPԕ
`0*'0|sP&|طa@8]Ma% 0Ҋ%%T{URQz@T^
X&{t
!*۾c{s-{y T2"0'}~l{}yp`Q~>b2PI<
vL5@֊ǪA8sZzs*t u2<
u:6u Ɖz<uz<u
t22+tM++&eP>?ː.czy~2NzB.ۉ~v2 O03Ɋaʰ'uF yyIPJ8buy~4AJ``NVyb$
IB0(!Q̊.`ot.;t$.
DYb^]y#+3*2d!d"<PR3iZXt
ht
1y~hu<s0.ڪFkttpp)FO]tÆ`p&x|+p&}僬 32 `t밀w00$&e߀ te ò?PpNsQб2ĜBP~JGPP~/^ xQ&5&m&M CYw
u³$!m0WPücu4 8w@p vwտ &5&0MŻwwtn10p`w}4 0 `^뒑 ,1pT 'wot1p9 c1p.@P;PY0˱d2|XR~ ZSwsJB D? [Z SBB  #ȊPSfQf t^$t"a$2t t=fIuRvѱt%wu?tfY[X$ .խu׮<t
 u!QPzu<wPSPRb@1'n@	e0ѐa@=s=s=|s^=Js >ZXj[XI'<t<t~ppS&[Hu'tp>pBpF1u.| ~ &uȎʠ2..u 
*9 Խ<-[O5б
up銰w5wv@jİ& u͎..PEI.0FF tO5<-<o1<5OPS[gx&G&g3t!<}!<}Pô<t
<̀
&G߆20K T `T֋P$'"3ҹ <u{@P' X Q`i 
P"uÀu
&~LB@S3[t (22QpF t  +YuPW>&}t0&<t$8tGpȢ&Eހ!_X 3ta_tu0G80u&2} a1b̠jtp$
J	%Ǌȋ>hPu	@tHవa`,& L2O5t
<t<t F`J!s>=&]&M&U&E
ȝP0@bX	}2!PSQR.@]t	B0߷Za<|qSHQ J ,5[VQS&F E<
B@<
t2Bd `\' t&^ E	prs-PBl p	t2 SU][)X[YZ u: up`ygp~P^Fp<u	C.p.:r2.]@jÆà$0<0tu 3tq0
2.;t48~û{ C 3it@6m# `2V8Ҡ8t`2: P;;: < P=  ? Q=    ;=Q=@ARS*$Z.$SQߴSQp0Y[f.
uY0庨Xu	f.>  fCf.ƱDt
uPDqR(2ݪ 
ɐtxZp؋ .(2.OA.WBP tW+A_t;rÀtIN`P@
u_bB.@Ɇċȸ 3  u,Jtt@|$Q
4tu?Mp2@_
uJ}pJQXЀ@_

@ 0W}PG@[ZPQVWS.>Nt .T\Tuxo.н޺RUk@pP 3f<8ATIu? 7p%2QRS$<u `x<2[ZY> cY.ɰɿ.!Ij@[_^Yp,Ŵ 
XÜf`PSZYsOtytrS!I%{ IfP=ק[3W)ifk0fiZPjHPk
l	kPk\	f߹  lPkr fa`CfP2ɻ| fPfRk`r>kOPm!rk>0ttf h *tͧ_FCruut@^+(v:2 $
quXs zr z֦q zWfXQES.= t.;u.;]t3pHW6uRk  W:.epD <t<<t8<t4<t0<t< u0P@/6=@uuX5
X
 =u
¥_J@E=@Xx ^}Uw Р @jPmm @{wj X-- /   R~Xpu'P=u_!j3HΥPj$u|$!I$ f u$F pX菥$u  p ua$ ffo輤pWRW PW .? t.9u.9Wu.G2tD2ܻ2E_S!8.Ɋ
ܟ!3b[ÑaHa'cû ȧԗpA}WtD3PRY$ZnpRH%rf`fRY t3t+t#@t.tpt\t %ff%fP@~f$<t$f- < tf+ pf
 f2) ffffZfYf[V r`Ѱ2ȴ2f3.Df3ɋ% fPf@.PL_ P
P!"f{f f2  QXff;t9`;fX!Ͽ"+"`
S
ⴽ@b0? m``׿^'¿C00西.^(о蚿蕿萿܋1D芿E腿FG{.F*.~/ pgط Հtttt	t3.)$ ߿C	`  b ߷R⾁fX^    q  + ͐ = KC @αFRluu	 .F3HA /H_fXWf	[E^.~0@

0ـ	аtfP¿0ָ4葡`U = 8聂arfP HfPRQku@PxS3HܑHgxXPo.︐$ 	$	,"L@GFT߱R Xϴ\`#fju u8 Ptqt= }\ E~ p6P
uu
~BXTAtY]IUBE M<~	<%@ Ytq Y}ZHRSfPWL.E_fX[Zߝ4bF
 <}F; A=(P=;; >`֯ A`r  )܌88 )I? C
fЮQP;<t%'<tO@׿ǵP
 $0_ʞE!H ҰN
f
  pF-f詜Ppw	 f.{tc^܈T uEff
@ Sf% ~tv w ;x  [ܐ|	A_ZY^FRVW>EVа p3ಃ.;s& ?.\?ËQ O^ o L.bL.2J0&>G_^5ސLSD0[	% JۃP+("| fқ I#"dIа'3S""E蛛 "8 t&ƛ@螜aE0u{X0SGPPS2h
~!~RPVJX,,-AfW+&Gp ffÑtf.#&f߃!I}PPj3۹Z#fC IXКfb! 	!/WfVw0f.p1
f!I73408{4e衚Xjf^[H  $,48<DLPTX\`dhlptx|  ;PQ  _  ? c$
k*6
mc8*?1 d
  
 !F!armG@^#
"  0 @ B  
I @ .ޑ&yIϯEJ>KEIܿLJJ @ N-K_ IPm$ j8QhKEI&OIJRKT"IcXV, - Y- =pK"IPPP y5 K%^#~&LOJP^^O`ē^sRRfVS[H8#aР@UȆUI:WgK%I#VMFXj RN"I ؏7l	A# wE9W`n~"I [7lF+  /p-"Ivk{Y`Z[PZz /Bmno"pwyp ~ B+ 1b@ : IR# ToG~rH(+ hK#;U(,4PTcÃCPT PgPUjcacH-'!.p]hA,=.PUC
剁^O^] a`UՉ gӋЉcjыHaHf_ E҈EёWЅP4V   $TV N Ob{PWV@$  S[^
P-B؎?< u+~?PVf 3蹛^[`  N g?f=PzPV?Wf=P P#6?؃  M?=	wIu;/?(?=@ru!0ι ?S`UӋ=[<wqȎ؋t|PP봨AĀP@P(녨t{2>_fY`,  ?_-d Px@ PSRR $PR
XtuZ!0+RP$!"
XQ$角F$ߚK'P쑲- ݑ' 0 >/Q: 
tRPrt0t 	臑 XZ5WPX2 t3ɿ#;t8t_;P33 t=%$@Њ$0Ћʊ$!ŊĴ!$2<u	ᤌ= < G= }90W00<}s}f<RذJ蹰<q
.<$<$
ă1 `Ӏv<1uXü4 Q *@cd @A &06cL 0  A  0`Eנ  1X (E 0XB g8xVAVA PE	 -`N ((7 @D6@a2@UQW]_YuE۴0+A葟t `, AǐQ$ÿR-Ay$Tt$@$0>!	ƎTd
$%t[K&o:ُp/7C(>l!$m윏a,ֲ䌏 3* uAt$ʎil1dӏ($L$袎_茞;S*4p2Rmи *-贍# B-`-q$a%rbar t
tAݎpA~pԍp 6tGF2;r,!!WF`%FV_!R B0 Z!8`8ðA
Ͳ
	A
Ӷ8P
A
蹦"
	A
	 
?
@

y8mA
f
].A

V
1|p$ό`,jWa  (ZP!hToXss\HHxڌ$eX_[U᮲FP;s I7  RFNP'uڃ?^
[F b7@2FF
VFً ?P'7XӀ
á"YoIN  Y  ^HF6"FVЉVW%6$&&]V6 F  F^-9F$vp(Ffp簰F@0f8f "i6@,#F.1%GE+&F	Fp0}0"(%1Fs `.!*色3K+FPQR,$` 9
Ⱥ$?
ZYafSU ]fp pqff@d>]2=] M>$
ا>@98W?@ !>kW?@`>`E]@
4F~@8E  P zfĜcB$J&eL`M

 ML!N
 M^`ML`MWpP	L#Q P`MsK D%= vG$2U*@3°:׌ڰV%? pWVT T@f3 P>3ҹ ȋIXA;r3	ҥUX;v;tq\\2ƥXPQ ɥ\
2YX  tYZuaV5VfI}YZIXaafQffffY[f0\v`@ab  f_WTbf^RfP{?r1>fXےZhǆDdi 'j` $t 薆! @øN = Nt+
詇$pg螇$pq.<  <3f<8ATIu 2؃? u2 {PV࿾s׬	8uĊ^02໮.PsۗsMBt؋7t .& t._&@.?tǐ|?.Et!~ECCߠV[fStP`(踦.]1f ..M0T@XOf[^ |fp~9
ȲR0
̻g$
軅.E6蹅fqp$
M$`D$.e9~Q葅Wǀ}=p~	_X.]9t"=f"	=%f	}&Wfa}c蛠e$p8ސᄣ襅 QF>=p%
Ĳ0=2..71oou0fM>f%r%u

m!opo2Q
)
,
?2܄ 2pmu!腃3nxm
  N  0u  t < RNZ {Qnb'Qq׀	%bR$ZW |.E#_F@_VQ;tX $f%I%f=-  t*f=2A"荠f;ût>
 `ŀ~ KΊY^pQ!f=  _	 Ў$}ق R} 3_FLqiku耰镂*SByBQRR$ $4

[ZuА8?m 2Wǰt.m 辟ᄵ} m@aM,t葃u_D$opڂø$s~@	译a}4 t&@큱dt%${6t`hCpkX-R쁰BʁL0<f``\舐1IF"F a`iz׋F-+jDdF&2$P[n AD19>1/Q,9&[9uLF) D$
F)藀
F逻T UP 0fF4Ӏ 08ɀlfpF7t pF;5݀1Xf_FB@0舀tF'F(vF2Sf30W^_20Y[u3ۃ` 0uGL f f" LJ$
ff`Q
fﰯf
fRJ$1
f	f\
f̀ff"臎CRmpj;Z1To419.}9K7ֶ4c؇~ؒK~A|f~~۸~[ݑ1fX~[y~Yg1H~aMmЙw俢WUD 2F E]u:u Ju	FfǫF4  	8Q	_Y._Po .G)4X`%H|1u"6{XHЩf0X fF8fX:rf; Pf	 x2仩t..>7ڋFF}$u@|#_3vQ	4   @DO
ɑ:""
;W|g}.Et.;
u
.;Uu3_84pQ;5pGtSS2~t	P
RE_.PT!  P
TF"F2N(̀@!N}(TFz 'g!'N'T+_$fFQ Of`fPa!N)`!Fః
F$0'2.O$F&FA&%HF+0%`
f_fP *?F-F*q
+.oN3P.G$ 
Xn *q"*Faf	f	)-B.2ޣ.@/nU *+"P+Q/80*%-  ub 0$F1fF諿 N)&? n1f1XRy  PF,p*0'f..g0';Fx<O;@c<F=;F5=G	P01@$0{@
F0.`1 F1,
+B4B.p3fpB;fqEm*EGp3(2n;%;
; >SGn/
`4;If/fs8	B np+`N2AVBp  F.  | tZՈtU1
F:D6t_
#b~Aـ̙A
2WH~2
	F2_U:	6T	22 u(7Q: a2 8@C F H K L U Z d x     ( xa	ੰwSt$^cEQ]PFtP1
F u	F=7^~.Fgf. Twi/yhfQi"bNwn..Mf0{
dp_x`WF	apxbhfK^
kh@ҭhFgՑhhPwhd c hF6 cY#o2fVA'x9H5]wm$hXf^ˊ߃0ٸ4h^s"d~/t8wc^ w f^ wPF =$w,{`@ z)t
m}pua\蘅ZY1ȎؿD	DfD EeЊ]}$@.ILDu'uDڃ++І؊}Ё@@%??8DdCEeEÉDE	RڃDEeԁ}HDL+S2]Ë؃w㰋$  +ĈD\\[ˊE
/P2ȉL q0D3D< vRD҃<@`$PwX;&D!#Q	ËЋȉD)&뱊'Ep32~кD(D*&>@D+)-D`D0D.E`k؋4#\1\/ЉT23 ]PHt'@P ЍHD;XD5 p@^@ӫ@X ?^ЬЀ@ XP  Px@߰P  Samsung LTN150P1-L02   
 AQ	  H }  !@Rl L  "0Tn0F"d`U Vf3ɹ ҋy^
uyЎ؎fЕudf| uZft;# =	wIu 3t|pߨ~a֨ p¿2qĀ ]Y`UG1 a	 v Pep
E;$E;X e9= vU93Ƀ= t(9w$= u9EwAEoE ӋA@~ ̀} u7 pEDEDSQWV^_Y[| 7 {?Й.|& t.|&ù`vDDMmpdMmq2]a$@VWVS 2 3н8ATItF[ ؋7[tFA֐&G^±
±  .R u = uDu

 ڹ  _^VwQfS
ݿ
Rff;uf[.Y^ûp0uo Sp%oQ3 0Yc}4 _t_o0>oo$3ۊS  0ƌp0Q뻌3
譌ao
ao
[a'ocE3_e4_ÀӿQ+EȻo n}p En0nnyo#˂fPVWSupЋ$p%0輋*B?,觋D0q .D15.}4u
'+Z 01
 g2Tt._1@6 +s 蔋}&3|`EE.e0?3Pp[_^S w [ 
tq$22oÐrM10 OEM INFO 	/O
o /Oo /Oo !" #$&/'O(o)*+ ,-//0O1o234 568/9O:o;<= >?A/BOCoDEF GHJ/KOLoMNO PQS/TOUoVWXYZ\/]2  1COD  P h$"h_hS@.g[.Vgo.g~$!i1`h$gahfD) b1INI??SQP2.N= NXu2˃	w,.'
t #pfghЁpfu.&:0жr l?m_nopqrs u?v_wxyz{| ~?_߄ ?_ߍ ?_ߖ ?_ߟ ?_ߨ ?_߱ ?_ߺ ?_ ?_ɟʿ ?_ҟӿ ?_۟ܿ ?_ ?_ ?_?8^] /]_ ?	_

1600x1200 @  
 BR^ H }kv`k! 'R^={H   O=: <E
 Na p^A_   !!0 3Q0`a^ OD w P P`a^X   |a! k XVV%hAa^0a@(= xr&`]*** *+* fw*`+*݈*!*I  *PX1&*w/*m۶1%S1""cM$[
u ` 8A]$
  R7($p^a!"*OU  L  'H`aTa//D)a))%2 21	Z @dM>a^@  U'?
>$ Hd%@Q5qAD< `4`??A 0$w M`;LL 0E&Q&
11 
1(a^1IO11:
P(5}@E   '-a^F  
%$@l%   1$N   Q o PQP QRQR L1R`SR@E
P(H <0[-`72`7aUUB"QBQTmA -5PCp  0"uu- _0 # $ o`  2 2   \2\2\2 ^] %Ta(a(u_u_u_1$Q <_ *a(cecec&Rcba1e_`u_a   !*4c*c*rd*&*e(H?%H?a\
Ao!?!" #$&?'_(s)@*p/+O,o-.UP0`/012C_3P4567de88 :?;_<=>?@A C?D_EFGHI? L?M_NOPQRSU?V_WXYZ d[\]^_a  "obcde%f fghj?k_lmno!qrt?u_v w(yz{}./ 3߃78 ߌ?_ ߕ? ߞ?_ ߧoZ?_>t  ?_ a߳Oeof?_߼p/ǂL"Ooʏ˯͈{F_/OoՏ, /Ooݏޯ /Oo /Oo/Oo ,?_  ?_	 

oo? _O? _ "?# _$%()+?, _-./0124?5 _678o:;=?> _?@ABCDF?G _HJKMO?P _QRSo\UVX?Y _Z[\]{` b/cOdoefhi k/lopqr t/u&'xyz{ }/~Ooσ /Oό /Ooϕ IOoϞ /Oϧ/Oo+  !
? _  ? c$
k*6
mc8*1"

 {!S!´@^#
!" p	    
I 0. @&yT	ϯ\
>dEa	!
J @  -Xr	K#V
mӒ$ j8hT	&h
 Ra r	c`·, - Y- =  r	Pg
 y{50%^#~v?/ #%[/H8s!	 (KT	#_F*PNr	_ ؏,	# wE9@.r	 [,F+  /1 -~r	vk[Pz PPBm._/r0y0 P !B+ 1B#@ : IR#  ??(+ hsA;Q(,BPTA!DCPT P(PU@D1+FB-'qA.A]hH,=.BQH
5J^OD^ G] !`0LU%J (#L JL1+!LMvJM_ N"IM6RQ!REW FP MJTVUPUX1
w*
O "|1׵C* !@"Z"0i"A0	pA_
mb6!wA]ؿ]^ps2]F `# ; t`	Pcc 	d@'feRWr2]Uc4x,d
]b! r=~2] ڛ'#	`0& GX4 ecc` c:0HQA]]`b!Ar؟st%uv
b(wДi~ ?j`okQ1'|XTj}C.q.m2]H.,4
Lq~1.2]j镇, z% ?Q6k:4o-2]b_{6,r0npnJ5 !:7<8C`- `v)^_Rqo31382]_hhx }`p{73~:
a`^4 )E<eP
 O) a(A GBQCB̀CVdDWDEW FrFFRGQ=.H2w.LZ/Ip.@ЛQSq.`1PMjŜ!b(oŜ1+FCPn)cTVwWcTSorU$t?
u }F)./HOo 2	a`)&
jQ!%`㰧 era`s^
saeea`'s_pG.h԰!
~ra` yɗ!7G eq$Tr ߰!tn%V%K&VpS'(r(O2+0|oOp$1Q.a`8N0# 044a`n5W	37TA8bp/ K:2;a`A;<Mua=J o[@_@}A UCBFwDGEFG+. LnuI,#JJ@QUJS2N1+P Jt^T#OUQC <  4  !    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du7fs30f\0fyffÀ32 ;Tuff_f^fYf[$,o
 /Oo /Oo  !#/$O%o&'( )*,/-O.o/01 235/6O7o89: ;<>/?O@oABCDEG/HOInJK &	  /4(` oJbMGb૔ yuJL2ŭޮȧnNLdSlQKlE8?H[~U
dc1(S >||5.)a{hTuz[3:Y%7zv8n̰5MǢ}=KK[lO- CEVW R 蝔QtmܝIځu乧&s=ڍ .亩h~%rc9-8ua.<WreQ>^AW|e@K"kK-	a">_̷2T҅1`ak&>;&.z{4415-V׭ l8bQcк+7&V'*yi	AI5ގ~	rQרfDI-e)}v1/v@cm=/.;(mٱ>
J4OKN`.'f3ސqM%>-Zs>gp¼ڙ/^b_b
<*`r-j6OYS  [(*SJE(<SsVuU$r#X2~4.v&s-I3 iv1/1%ڜeB_-SK=@|3h%Wb>t\"u|6.L{W/&ݚ[&eab#A= rTq	>Rs.ܧ(6b|^#
5
oV:sp%\R<n,AGK 6n2u@7QmIc/sϴDM d=>͇
΁Z;b&U57>eʈg (z"a 8W׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=BMﭴOp	6OCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svK>,@~!.(i(N.KOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cvdP{q,m_;+恑~!j -k&>O^VthEKPLbMcIFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+j&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=c{>Oۨyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhBϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ~P  "Ptm4gMf~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu]|xd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIx29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠŷSh)`cǥm'dN5~+8a!"LF{M怂#,Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4흥 94JIn8-z9N/fj_pz}[;bï"8?9;U	NZK;#7-o?ښm	
 /Oo /Oo  /!O"o#$% &')/*O+o,-. /02/3O4o567 89;/<O=o>?@ ABD/EOFoGHIJ	K	PL!}LgeoղGY0W#,+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5`34O/lnSO}\7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯPGgM
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iyy|];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;wyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qy${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k	
 /Oo /Oo  /!O"o#$%&' )/*O+o,-./0 2/3O4o56789 ;/<O=o>?@ABD/EOFoGHIJ@ PL&lLg͖e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XY6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU*Z
_ِGUV%7on[nI'^v&٘alc;%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3Iϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ c     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &t&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`h&Bu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzo  2  > ~$@b@@ԄԄ @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7h὚v t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3Ph"3X[ÕXڥ/<\$<sYr.r@O C]CAp?6t_7r@Xπ`?`UAIJfQBEn}S  gf +u
' u d[Pp&^r c@CXra Jg7=)xxPe14l 8lmn p/qOrostuvw y/zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo 	/
Oo
 /Oo /Oo !" $/%O&o'()*+ -/.O/o01234 6/7O8o9:;<= ?/@OAoBCDEF H/IOJoKLMNO Q/ROSoTUVWX Z/[O\o]^_`a c/dOeofghij l/mOnoopqrs u/vOwoxyz{| ~/Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&' )/*O+o,-./0 2/3O4o56789 ;/<O=o>?@AB D/EOFoGHIJK M/NOOoPQRST V/WOXoYZ[\] _/`Oaobcdef h/iOjoklmno q/rOsotuvwx z/{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo@/Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+"s q}6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;t
|u. >
f3EG.Љ.fEfGpЈE
G
.f$ r-/te8  99- 9.Ѐ t8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GC} ;, 5C7D # qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6
 @HF`CÆQfQfPf$FfXsRSÒ3 E	7WTkUfQIffD$70WuUcT+9% si}
uFDdW+pWZE}t8YuS uNT-fD~7  !]6\0u]07 ^ i!]Yus]_ KT߀u#8
fɁYrgV1gV d_u8	1cc17϶,R0JfXf 2TQ߀Ysw0cYsVctfY+5 /j7 "k6k[gkq8r߲Wm_~lieoaȋTq8s"ns\fE-VVcD1SfڶnQokETf+r8s0W7T*WTߥ:d{ fD@@'4'f irfe  Y2pVQ^ t@lsF?N+r]Y
]ڐy3w@lD tM| /u
!9897<a\!5|6^<uhs
\ f!7s1k&q8sk8!~Nnj	xj95P:5i3wj+2fTaB{s
q|rD1pJg-kd
*fc.`vX~Q!}B'?t@R{f1%{s@l"⋟j嘭@lq8wAsZWq+@lw~oscT8p\5VF`^k5`K95FF<^jdR{w!mnlAW#jPХ8VYpsVr4sf7Ar\Bn-Х蚐f!E~F^ tttk%:5ȵn7sducn`o¬ʆp qrsTT%=upQWqh-Vf$&	!(=(tLQ	
v+`=urn2$0yrSFtQhٻ0<`1 (ұrLn@k@l+1| 7u Øn31|}3XkCm|`o1iVq$fedwcDjSjd8kn4j>2cT0SҎ iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tWA:AAⳔ`D親A♔ A4  + *2+*4+*8o+f5k-JYsM?ȁpߋuJføtsPørcw@d
wt?oslc#fE{t~Ў1 `J!%[B
@lK!]rB!p2P!Fÿbx+si d
pp1B  }߃߉ߏߕߘߛߞ ucQ s0cE
WV6g4Fg^_rg tY	P!!s
P! !M
fw_ord d" q" " tbyte %*/r ptry c #WV.3t"h6@:hs6J,6K&Ys#O0VBOO_Οf^f >eS fXPXP
$0<9~F!J!JhD
 s봰+ !J$ CqYsp8e+s-шsf    nPr Pr  ޳ w  r  \  `|rx   $pr ' 3( ,܀T/ 0 4T7 8 <!T? 	!x @ 
/ H $P$X$x ` Wa 'b  f@r c &@r h ( i +0 l 0!1(m 5,n 9,o ?,p Dג+q G.r K.s N.t R.u U.v Y.w ].x `.y c.z g.{ j.| n.} q.~ u. yl.8&8:0:;m6;: 6;6=(:06;?8:  |U.  B  !k PC: C  Q)8ے+ !F  r !  ߚ H ' K H .# PCkPCנN  Ur O AT O O O H H H H ! PCx~LM8 q)pXXXX  X([8[  /ROp]I E  ]^8PC. /1( ]ːaI/ #rcb+ 'E^ ,K 1A^ :X:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^&w D. Knw Qn Vn  [ ^p IIN  b%DrrIr4pp`qu WfE^ kE^ qE^ vE^ zC^8xAb`py~yvz vz(+mz0vz8szu $E^ E^w E^ E^w E^ y`$z|8fۉܓ b}87(bՄ03FzM   3`,	 0NԢщ ^1 ;  A^1 'č	 %e@+ T1Rҋ uҋ ҥ ֥ s*1 ݕw ᕔ 啔@ 2A 8UB ?UC EUD LUE RUF YUG `UH fUI lUJ sUK yUL UM UN UO T8 8(V0V8T@P鵍 e  e.@r1$`/䧂0䧃0Ip1䧅 2䧆2䧇3䧈04䧉$4䧊5䧋@6I6䧍7䧎P8r䧏 93 ew1 e2 e0 d8 w9ҡ    	     $ * / 5 : @ F    UOr!$  e K O8wSX ]v0b g kp u z ̓(&Ѝ!`ᗶ䜶m覶髶겶빶쿶ƶͶmҶض޶ϛ0(
6&.5v:?wGLRX^eGrklRFpsutz q8 ~(60684ݚuР़q0(Tg 50f83۾g(lRF8w8u% (08$fcuu'8 }D8$0 0Vڻ   
0 00V8 do8 f s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decbaa bou
arpl imupnsb out q jo Kjn0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff saPl@s!s stos lodcqbbbRb rolr rc cr shl4a@etp@^enteft!o iavemd xlaoop@!#s#fxza j@lockpne%e hlt ct ne doiv i'clP
tc (i i (d dbx1zx lf@g@sl0)hrd b{sf+r btp,sp,a,c i,x,sep!.`.p..zR./.e-@.pR.1 et 12b0gr*l*di14l14msw l -s!4sq4s4s5s -ver6w ffchs fab08tfx`"f7ld119l289me19pi9g29n";z f2xmp9yl2x fptan<a<re>1<xtrac8s1f>=S<p.p9sqr8s0/frnd!f@@7Aucompv7en:dis:cle<inf1 9B )fP@1wesc19env19c7stFGaGfreB8BB0AarG"G 5fbEiEb>>1EP@ @CG12E>MfiBIaO"LaM'AL wbinv+w	a@oQ`RARSzSRSR@RUQRlQ VTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y\z`&^{&^|&^}\{&^%^.s\߈x\{3%^3%^\t_.\G&^%^%^.g%^5a&^&^a&^&^,(%^-)*\.V`)PS\ ޤ\%p[&^X&^a4s%^{$%^<%^v%^{\t%^5s&cx䝀\|\5syw&y'5at%^$%^I~a5a5sQ&^5a|\}fe{$\

迾z%\c~<r%^<m t%^"y$v7%^&芵z)%^+t0%^-e{0{5s35s6Qe{9uf{;me{>{5sAjDt+%^F&__JdL%^Nt!%^P5sS{<e{Vu%^Xe{[%^]` 2scHf^5sie{lne{q}vu
%^xL{d}W{轆e{#\P&^O\oe&ߑϐ\\WuwuY&^_\ur}5s'nt杪ߪ~k唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6Ff.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SD?r [5ʿHz QMY5 F߸J2@ M)F/KEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXStï[_A mB C D P Q R S AmBCDgPO݀߁RS߃c?[ SpWP.@ơ.X.@ u<u	L <r<w,@. <  .>
  <  <;u.
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&aR<[`O?uu1R8f;t'uG⠰ ._pل	   hثv  hNȆg
Ȏ؎`ЍMˋh i
  _ R00o  f  
9     DSDTb  HP nc6000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12C

 A y 

  
A2A


\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Q4ph`p
 gpid#d
 {`
apRa bsbgcpcgz`
`vdgDQ5phg	gi
 A6gA7phpiQp
 fp
`'fsg`f b7f cuf!bc``A8A9E
Microsoft Windows ME: Millennium Editions NT C@AF
p\_OS_`pQga.agԩ#`9 
bra
oua#
 6#
 )%[Q$I`*
E"2 pK
pA8_INI QAH@B
fpig
f
 pipP0g0hprgfata
apa`"%ahha `a u1
 bobiib3ub`\[K
@C_HIDAJ	_CRSD)
&	p 2

 8@ @ Q98
~!8
 C010;mp;1t12!<w;p;3;p;4pyv<5
0)14t=4>D5< ,16pBA7A8Bp;9 =rQBa"CmAC  D[p;B   
,[Ep;Cw 0p;D a;8 EE?A [
UHFE20?9@[J6BJ21`;22,23'AL4 J5'26ZAM7F00AM8AM9AMA#2Ba;5V>2CODOEO}F>30 A`;31@3133R4R5R6 @"Q7Q8Q9QA  @63B !C3CCC EeE3D0)3C
W[$WERF@40XR4143wM,44
P!`
p2Ba}aiapa7[ )[ib{ab\[X56
_ADR
 [X6"` E E47
W#470)480p/46-48E"6X9& @e<f}A0I4A [#XBK#4C(`p`hp`b,48ee` ap E dpyt?cCdch
{a
09b0d4Dhp,b_btd
mE2nuiP42dcrd49` dza
aPqn@(pfufQjf a(du7`['g
.gXFL

 
2
B GuA  EvFw
avjܒw!94
 Iy@v5
Hy bv?y 'FdDXEh['4B B@51pibpkdrd
edAj~1ud hb sb@rb

bhb2ă3jă4CDj0)52CE23 @53crc'54BbN5gwblar$4Fab@2b2B4`21uDq3bu14atb
bc4ai`bac0`6p
f@k56tBA7n ;4F
P52cf54cpi53&[c12\baa'!_S3D
 4D
[7a pW

_[HN8aa59
`
[I	Au5ҀCDG5jaX5X6Y61S2 @ 63 H#64    ,65]aQ66@7 ް68 '69#A F6B 0C6P6DAEAF'70I71

J#710)7223 
<[=ѥo  @475 ࣁM77r8  L79 A>7B2C`
[+:D@7E90_7F F'80  #81I8m2ѬĤ8234Qp/85UPA86U,87R88W!98u8р88DGE[#\_GL_(bp
`{졳r`p`!
dv`J`!8B8C{hr0jp
Ρp
HE0904>Ra0q,8DbAr[P~bya
c}cbaa{6F
/` hdvdwd
`y
`ayii62c{ca a@90 (8p@A1x@9{2Bhi09|P!`y`jB,936``wh
0)94!pi66payjabypc67c d}d67M#9?5Ei"iS5
bMbC{brwc
e1sfey rer 
 dd)idlh
 y
ce"πe0)65caaghZ`z buc/` P0̕`ij}0`J6
)705)6F&SDàұA
 i
 A97qZ30ipRi6BGqQ bVGe0}8cD'%{㐺2j
O[IFP$]9 @
"999BCRQ90AE F }C0IA0
"`aB`wC ޠ
P	09&Nz{`H a0 
bw
t
	ra0 C#*1@C0p%{Aw"@A1
pI6'Bp/A2
0rriH9D}`Fa{q ` 
p{z! wi? 9A'{a` bA1b a}C13	B`pADwo
h Πl }q( qQ
ccF0CA4
l
FA5 ,A6 1p6e {/ky
p{A5  }2e0 lj
zq
6{`q}Vxq
7p #04b}e
e/d
\
 r !04	e`04e}`p2@dAy4{k
\
0f`}C
 9C yPCp?d!`P(Ad pi9ABsBe[@=A8p Ԑbcdyce@
	
Ar,AAhif"f
j
q
9
Ebrd_B	!'Sp,1D@V M 6SC"HIS$"Bb(%pS@oAb	c@bsD1p{yacʭD`cE@**`*EF mdb`ABaaXA6#aaAD

[>A1WAqAF-_PSWeZZ!AE3F@qQ3Q1F[(C0B0&`B1Z52#`/B3 0?1_234564az8J9:;(<=?CBp_!a
q8A cF?Gp7J`
sJCJ09J9#`H0ZBA	7B	
#  y ɋAP!B jh`^0`׀0@`"BD:AP`BE	Ri	հ`	`BFT` <!V tC0	pWq1 aXޡ	aXפ`[OC 7__UID
`_ST{A SE^^.~!_DISqBF\\_SR]SQC0h\ S^4Z7Za[\B?]ddo_d`aH4Z`@Zbc\COe mlgmh4ZHZck\D_mutouq4ZLZhs\Eou"}|w#} yq4Z@Zi|\F}2ل3/4ZZj\60 B錿C?4Z$0OZk/A1RϏSOb7WA7\79з@UF2з2-[QX]B!CC
D޽<WE [#Q"XPF6V	7u![WB%Fv!x)6LW46[KDWDID Y>8D2
,19D2pD3 4
L45 :_REG3QD3`@D1ȑ1__S3D
4m0D6R)(P_D7
 hA33`PP2*!VЧ84ñWKЧ9
35@{
h {`h)35i/12$ 1\._SB_ЧAt
a._DOSA1
`aж[^ЧBbbha[D/p/
_DC"aD`!5Gs8SSPXе+h3D(F%Ef
%F4;
%h^E0 B ؟D7	5`Նp{
P
{\/y40Ա86

E0SE0`D   ҳ !ҰK1B}풓hip7A@h ! ?@_\nҚ\/CA{FE { FFGH58,1
`96hjߡ
7hi``8Fol`CE25Fhb810R7FCE7Q!V E3g
^/uE1klG4 n/86` "oa& ΕEE!"aaC@AB[ׄO	7+R87`@05_ON_ ?87̟13_OFF }b_@_PR0PXE7PX58[G	_GPE
	S
@[p
Gb b Gf f y 1E9EAEB`CqD

EEF`
# pi~iط0A
EC8F0 [Bq  @@
@F1  PXF2`p 3456789AB ВFC FD AFEF oC100100U2	3	4	5	6	7	8 9ABK@C1	 EFC110Q1Q2Q3Q4Q5Q6Q7
1u890	1A11B_INI 
11C
>LA`DQEQF
vP201
2
312e450K267
Unknown 
NiMH 
LiIon N8P>{R QE9P@EBF8`E9
h!VDEE77TUA11@Ia)E}}hQa{a
Q"}qiq5!q6)20 *20T&W129	X0XCá-&4"A	1-pp
a	{`bI(B
[)h`p4`
csc
  dzi Vr`a[)av2bsdb3/b31R*45O6ccHC	@Shg0A+Ag
1E0!1F{`glDEhH!'BpмFCܑ0`=Fhi 	@=00'@ w`

axra
2 
dcbpb'@AC`fADa1`aCx0KT1Fg.1FT&`IC130
9+:p_
 'K=;;	ip
$1!0o<G>9	?P	D2cA3cF >A4Q 0
{``Y{^``VGp!:5@1R  9U2c cpQ eבeYeQYxcpecpcY(G20Gv,r32`(_Q03PVTNͲ _4o_<p
aCp
a`aQ05\TZ_ I3Q]Vf4['WfSfTZ3_paLa6 D
 0
h!135
hPR_CPUy0kh1_
h	2@me7/fOgjh0mɀ ' _8 
7Mj
 I`4`=E0dj
k7kCk8
`=H# _9 	Fj
v[ _A k9$zBzA$zEz`_Q10 -uM ~XrJ
sttQ/y	vđwx1^xuF
g{-z8iR=z7i?sd0^a`<W}aP(32pTaP [QC
3B
N$ `|13D[O(3Ca `|E_  `|F4p41r4P43 44 L
5!	4Vq4789
m414 14;14j4EA5051?@
[  '15153ҁ5q55V56r5I[58G55QU+p95515A8r.`)P0@`p`0ނ a/
 y6aa JpB5CE.#bcCbAcNB~9c3g~EbHp! dp50c=5CXya
@
 d
b
 9bdpdAc
_ c
9cֱ9@/5CO`5!3`kaa
a
vad_ alb1bb
vbdbS. 6pХ4CpbqD` 46B9#9Pcp 6E#!8zj00D5-0a=pE3ҥ bb	a.c-bbG
5F/583pdW3F12`  `E
60 *3EFFL& *41A2}61
{C0`{` 24 ia`q`-Ahp
py!@162	ӴB`2Uar c㎠.abc!.dK~(63 p^^4cIk65۠L
P66

Gy Q׎`j168sqȱE5BY.668QB 6P`n09[E6APS _DDN
COM16 AC6
30" uv38y S 6C/6BQϡې)е!+_DIS u~233`-6Bt`F_SRSph
D7ED𢧠r.6B@
aa0D

(Q!0(@u1줱[6E O  
"䡴F}__ON_0r
_OFFq` l0E[H:pFE4C170_ADRp_FDI"`
O
_

߰r%r


e
_

31İ4
GG?"@ *Jy4"3 
`z#pb" ~72p S..77U7!7q7779aAB	,`7B`CJcꀲk7eDp:)75*GX_v'rC1810cSrA@+cʀ""0.81"C(.r("`P#G"%A4$[P3 @D+Pu3EaȁRMV78 c/0E4gcpgpg	M E^82
)2a2#3p^0!`@u838_2[L$4CMC
_G 0" *
G9;9(
KCc@^qհEA
G9 Q*!?_;@"#
%P/'O(a)85@+,85[C@86 `QM7p`ˡ\ Q28
;87`^x r48Ѳ58a6
89eH
1 GxxR<xxg"A:rbx:xxucoefcb fNd2he3hb hdUliRlB58P %U659NAB qxx#Q9G
g *JKR~&8AOLaM`MLpr4PQ?Sٰ&x`1Q2A0!5pq&b& -/UOV@)MqC(+0.&0 r4΁aZC)58D p\/Q45C058@5(`O{r`  N7D2[#\_GL_{ϖ3
a['R$hQGPE`MEob}abg
9}[%`MRS = J"  y  9,6@ @ "~[7Ct 
9G Ҩ  _ *Q" ta aW Q-2t
Gp p Gr[ r" f3` `@Gd d@"J[˂I9 71
" y95[
29695烵᳞W96&O.9Ѹ и [+7  ;   ![N8$
99
?
[}AѳB[ @QCѳD[102"
G   1] _9C
9O`. [#p
MUa@['F	p79`  
A0
0[vA0A1 INIA1ATa3H3$!A 7c P C0MA@S3 G04 GB^ 7^PZC98[B 6 7q,E_GTM p2 N`dP 8p0DA9pPAApb,>AA{Tݰ
9
0A`AF@5MhhhݠFi `1.
w ˰ a:`` bwb
bwcib 7ac !rbTp[rc!u`4Eކab c5ACbcaA٠q:f롇!{0 JprDAI7
[6;F f밟A7K 3PC1B0ٯ܀ޠO0z_ߓAI
ƙE4
?
cM
 /Om, B0OB--
_PS0r3*A`1`ia].C0C2o	
# !3C4C5C6?C7C8C9{OoT OB1G
T	p,Z
T	GC1
 !h"h"e")$ q*5 4aQC)#"G 51
VQ:f,T	4-!,qe&-	1. )$.#.$p!a/12F@	F
R747d
d
Primary 
109 
LIon 
Hewlett-Pack?ard E798?Travelo9:a6E~@J@a6DA`tL2C	Ey2Ch`/` ?%
 ;}
H
 
q2FhACA3U0C2QIa\B2 LDy30ha`HEhpAIԽТ
_U
Iz L!EBIPCpRSTqX30ZCLw\[G 93O6)rPLQBRbRS<TNP_
ACPI=3+T>R/XE8`iWP22 pa3A^v[:I9v?
*_LIW9lJ86@QQ 
	/1?5?@SX"ِN`ACj22L3i OB4iuB5is ` kk`Qh`piaF-Q?B@ a{`
m }aVnmoap`k0paq m6znq m5s ЋB  B3q* B72h 

 l`Qrr0Bww `xBww`0xxp}
נyj 0x `>1 h)h`	qu7`~ibBbasabcpcau`apB8rwx i`zC03F
.aq43҂b`a
b
פ
9F[F!'cO
WDGD
PRU4<SMrJ/NAA T-MP2TA;9Kp$[?AC+|Nr2J)lBCpCWQAA*1uUCES
 {AQr&0wߍ 0xP[B9 y
KF B
FfghiGWSAB`
FB9ipiՙ1F䎰3O C
COMPAQ|PC[ C ; S 9tReader|GEMPLUS|GPR400|PSCR|B '%WQtB	3ŠBWSWBCBirrB0a?31ta(ג`2@b03m4aJJ46 	0
aBC J!	1BCl[#\_GL_y037 pj8pk903B\0AhB?`	l['BCbBD
QEFC0 PA1C0hCS0pDF/PE{h
ALEp{zh
 Ȳ	PDFƶB PNDeDd3145167ED8w 9 rMD YDQ?D9
[K#B@(A+DCMD yDq[DEFWĿDEUy
	`rh``vYF0UE1Т cdᢢJaߒc
``r=dt b}y|0baya
a0arA"!  eraye
	 evepeA4c uc0docMjE1auE0   bpbgC	bdp apbe)eAe ffg
fape`pffgvdueA`bΏ4` gA`1 $b pgd1CaggagubdM204qBpPbD7pѿ`cpbA5 ӂ6lyR@50؈JDJIC0bqEPh4h H
bhac `rEc1arFd߂
e5Ap-ad?ft`f"}uAad#uc2f;tdg&z`bର73 1D81sJ `PbE2pPaD8`
_INI@LE3BЧ51pibhb4p[pE4U5j5666bF E7 wA
arC00DbbA`bab{uaaRhހ}bPuaY+_CRS0D`V7`.`VtRY=}``ТѠ\/a
	`   y 
F\J1EGOC0E91
.GG }` @`_   yA[E9[D]MJ1EB-p|64F
bG G$ $ GN N AP P Gh h Gt t
 r	  G@0
9`y 0
y ^^E 63T0_0q3R4R5 H\_PTSphvW2Co_0K0P
@ђ {!EP%t{fh(B2L \_WAK LYBAO0EB(?0K9 KF!"1p/# k'yG)4&TZиEC(TZ1_
)20*v0@R)O_c`b-
,Ea?0c`cbccc',5A*YJ9MAF
 0A S51u746551!5{N\)QDG,<

0=n6

=>?@bqCCqCpAQEE=F[C1F0pFF2
F@uF@ 9F@:FrF7zF8*J9$LFA @3]b4
A`FBm
1͠CpFA@
:`Y1D3OQEiPtKFC
p`p3
QQp
.R>BOOUi`XRppOMHpFD
BOh FAp
~`Mp/i`9@~oTU9r^SW=i01MdoXU`bRWB0vFENla;hF9i@`w1h!=FFi w` aN68
vim_d".pKD!CB330v`gqxns"]33t
axa

`b V{08E
X
bt*?q_r
t2s_vAs
@dxX
#
PbU~?{seIC200	O(p
d	Ap
d1yYdNp{30PN{b
 t bbwb

arasMpLa 1oB1BWA럈 P)a f7h  g8@f``΄r䑍vmy
0bM`31Չ9hh` a"`G<f]5#p5bq~p~1`h)3_
mb 34p@@Q
hoh `t`s`x`0fjf?
p{tfGQufo yttcbbst`b&ؙj@bbI	iep
dk
 Sd/@sdOv1sefBipx&v6'%x&w6'i* *wh	ҁHaga[k6p~2N
_ON_!]CFF!]Q3-
qY
4-
Y$
ʳ5-
Y
~[;36(# _PR0["*7=H3ĽP f49=H5[H*W_AL6A1`AL2AL39_ACU0EBG B1E0D2ɀFS3\ F@PSV2"SLAPR_CPU0GAH}m
MF5fc(ҁ1pEEEFp0Fp
nAGp
G$	" q@1_TSP
dC1aTC2CRT q TMPpq~g`[G*BɠwFg20C:ς,RV=*Z63ڀ͠wݟش@NF\_GPEM0s M
_L00 17{` p',{`
@) Bs !*2s
3J5R47BK57C/8DO9I_L11U6`~ F3W6.`^{FXpGi46&0+`^:;E/0spg1 C輏EaIp'bpag(F6aZAaPb@ )mQ3PPPtB
KP7 {N64?`}` E@_4:&7,P8"f,KPC?R`!~45;G	PD?T pE,9+N <: 86  29/B	D	, lF
{g8i*37iSSDT eCOMPAQCPQGysr   MSFTN A?Ep@
-져0y 0  )0F/0031Q_PD?C{h5PPCT 
52A8E?	_PPC q)7KSS7N98S9:O ;t<;<> /?@oAODCFEH /HOIKKLMPPR`S:;UoR/V OWoX/ZZ]\_/_ boabcdfgi Oi/ll  p  
    	 _BMp "v }(   @    #)?_! ̮ _ 	

?_2ܾPV̾ $q&"@κ`31$
@π/H@l"!  "A$o%&a'1**?+Y,2`%*./r,`P%,23,Qp'O.o78$22@S;:;? O>o?@g:"DCBC EeHA22GGF H=06O@My:M9IQ)Ρ)4AIEsG06)$ܢ$ U^HPIAQV$W)T
WQKFG dX ?[XO"3Kv`X2R^"@I$Q%%U5PGabPIXV`6q$RFhX?i2VjfXRT$ mmVPn$qRXlqkT_ stuvx?y_z{h|}~RVXercWP\0 ZVtPI\~N`dZqvPIZ~LbpZZx0 X3
zRV~Jd҂ G1d$qZ!rEHh ċhV|ċl|R!qHj!`	!qi pE $ Qx$lppogj!2lfYrgCg)2 UCCԊAC`0 ,^20 4`0A`A@YZPIV J$3>ࣔX #(0ঔV󠱂%2TR2͊a6 !R0 A`6@֬AagGP2.0aCNPI`6R" jq0PR rLPI2״02a@ִ2421J%44@͇H0 @@ߠ7ܨ@r@ΧFPI8224w8AA܄ѼGDPI:36(Ї@ϊ<V4͇BPI>ԊA ɷ`ɲ*Q`R@)@	8C@0  Ї`B2JUB(&3%G>PI%D0(RIj D*3K ԗLչ,Zj HĈqViF%
̀PKg<PIÛ!
0,1P`*ٱV*ᰛF ݣ!U)᠖ZV':PIR&0 ߂aKe(j@y䱀j@QB[@ߑi@rVi$
ԒC8PI (]FQQQ 5jA !/"uMo``~(۱ Rq?O A"2l% (o
+  -0 O3oO6/9" > @L4<AD OGUO,NJ]=R!/M?A kĨ#S7 [S)\!O=
\$.@ !`B`:`} zd/W`\Z	 1Qj[0Qi]`[_Qot#pbQons߄tPuau!ځtA${am@pqB|Rvqga$&Q`"Oqg[rz݇ ЙjsqV=2t!Fԅe;qkRVqnqT:a]R _qkP]V !Z{QEPNSaLeB	LVEJQ (%:Hݻ,@ x."C@Hx%&D)RBR[!F<!b@˯T8 %TV*G q!XٲQFZ@;0л\@6.л^Up,л*(Br`a&P
dтۀhf ~!hD߀yv
l2xbbr>@pA} edwvSN/:S1F~]P  HIhQo4# QҕHʱf|p@ذS8ЬJq6@1س cz0QݳcLE#x3j1֓ܣUraA2q`bKAŀ`ȠQ4@At"дƠ afprR?_쀿?_|        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ    ̓     [؎c Ћ㿄Zc+3f  n L!$F10fPfSfQfRfVfWfUCES>^  fB  _  ^   t^  t s $s@P$ ï t
P
@@
 
_apf3u 6T`< t_f3
 _>T`jR
 
 _{ b>__;a 3ب tKPPtPSQȁ u3Y[X	 SQ3ɽ0	  3 w XP
3	2
 P 5P  f@f_f^fZfYf[fXfV 3b>_"b t
	"u&"bfXf^PVW 3W XZ_t
r
>__^P  f&T f. 1ff&T $.ft& )Ot..<xu<\߽޻μ̯۾ݷاЮDD/(|/8-0124/5!7!7AA$$~"!7A:90@?==$^$$$`?$9 =I@s>0p>`-;`>:@ @'@C:'YarRE9 @&9<Ew<	I!!9d;Wp7A";BQCCC=(`K)))**LLH9BL~B<y =J  >""ZFYI#Bdf9N0Q#<2Q` B;I~ =hxPFN'yNQC<P!B2

	F"cXSI8 = F8 0 p81\	

dC3@qV?$$D9SE\CRt;((DDPE B=FJC#F@9
)HsURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍cInIڍ׌߃OsJ\gpjځBȉymFGł񂪓rݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎쐬݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEь십ċNԐUiTivǗ؊qlӔC~t`֖ؑ{pKWoYgȏlϏ[x=b m@  0E  0 ` < 	i޴ 6 @璇T ?'YVҕ
 P g1!!#"& pt~|u  qp?  7  ^ )@fc1 z02  )2	` %Y   `00;BF?LXp0B$(%ҙ׎<Ҡ`Е08 _D`?08t ԢA|ģ   UP W  >"6>O >ǐs>?~!B""!B'  /!B#b&2 `   డaLwX>ap1_@@@dР @Р Bft,0<J@Р0` ~1^pEc P&RÃJgІ 0 UV 
	0 P $&# 8_ o & V| D~D D< V B f<,$$0$l=  ܀ʀހ?3`0 ?"#!! 0@ `c 	Ԛ 8	  6 a@1ppP!3p%`မ @\D2"##X;ᒠҠ@<| %rm?  20Р 2  1$Q$$ށyH A{HHKxď d $̀@@@0!c $2&f# 0;0xx R@rcxp RT0E?V@@`)X0$x|pTT T8_ Тx#60 @$1$484(d(lD@&1< ?! ?&!<? !!# f4cd!,?p|E0 \Ҡ ޶!c,$9`0p6Eb ° @ !$B' }"""  p 0 1dIi&0o`@0ⶫFD
 $_v!@^@"  \#2Bb"6T$-`0 |px39@@` 0֠pa0E 00`.=|s"ѠҒ`m|%o38"5U QHU' &a! 3?!  =!!3#AO2bAb7?1`		
	`21"`n9$i$	$	p::"33aΫ7#F?S8G0N0#@!"*22Hi)""?"!pBfBИ'  <p$P$%)*$ $ 'D,!## 0-!$  \7 gac#1" < ~ < QJ  <$$$= ??d)),?4+fI`a߁'0¢p6( g}0P`q6` b_.u/  -'@01 V  <  <X=$aY<p0b64~
w*0[hH\=  ~  <P {D=<$R_ܱ15''v谔Ebw`Apt#e?XI 
8hiЂ? 8P2pq2oDRDl""z}"n""s0 'Q@Q`Aq?V`Rq#@<1Rd,Д%}IHT1y(@qq@,Tp !
 .:23Vn&  } Sb b~r7/x?`RI l n2"Rpn  @@4!
0`ԙ ?;>g|TpcD ƃ)]+H/Hp0D 6bpS `$$Ϩ1 FD @@1#fѾ~(3H2~RHH~HH   9 "} 8F ?8R)C)E+D:< ~@""6@Q6q"c  2"&	$  c2$`k"b'gODu;?e ůRtb@5uŸdP!
U?BF0L ?q?$&""  0p	ޠ x ۤ	#`4 cp4F8} sPpP? !
(P# ?@@DDDD0!cD7 u!0&DL|(0<QR!=t Q>= 4	6a00i#!!`j0 ` 9?!#3"$$4!?5!#! ! ?@yw`Qq7 }H 4 }b2C"cy @l!b @!q=x	<	pf8Pg( (=ϔȖk">@?0{o8l>%q&?3
p7b2  1#n%sr~#$% SvG$?a_%h|  1  !    İO {   "rт&#0 0  wP1 ?c q"rиT

 Pd'=@߀ Ġ"!A+] A l1>se0S0*38%  RR2R2RRP0@Bb.a4dP8%cAR-OeeP7
 PpgK?Da,=%$>'\!"BM "00#;	X|D2D"DvDTDD6 #W ay`]x8#A `Ga"@  Ȁ1U9-$d=_4d8!a	  6 P>@ pL D 0`Bf$,892k&	a@M0'Ee 10bpxPX?	 ]1a3"&,0x>dDd<x n!nႢo8|	(9H;)*;*$*%+8TT5Vd<p36b";5X@աp{ pUO1 0 ?R {`0C"cpz @M 	~*H0&0K6cւ""8x?~!B>* #"**@0-0o,`f8a00"***" /"$'$&*"$"D?^2E?0``V?~$BdBp44B
BB~10@	"&D$(-y`_6,!	'	smsmf /.H/pX~X_=I H<H$H$I$= ǉ? @<S>@"@">#"D"l>("8""8>(l6cЋ   N@PāD4R$zeUS R Pe	Zf!8! 	py?0 ;6PPJ2A3r
~! 3 ?$$$$5d$Dd< ~  P0_@Y $D$=ЋGC1qTRЛZ0^ 	/$y,(8h(lqD?  /"?(/(/(hOX \%2 ~^~`a$bqQ	F'"@f`Tf`Pg0#t	 	(00	?$ Z?			?R" N1:?00gh ѓD= D~ = yPPp< %Q8= @|D< !!"!"="""?;@0{BF\p8@hі@A@uCb>HHHd,$|$$$TdTDTa##:wP>?~'$!$34, g A>??$|. }1Ò aL8`H2 &2 +f!b62~Z*\*jI0 /:G; x pQ H0	  y 	w 	 	lc$Ê'Aȡ+e2A-`-ސ-pzAsG0 a B F>lxPXHL0F`C Po0`@fǠ0P0b64~
**hH)  $lH UIHUH~HHQHU~{HA6pC!!`S8 2@1b)) ?()()~?H!!!aGaC,40p" zs"rK7K@
p`2P( F`p= B> <$P'~0q" ">*>>B¨"&"cb@	"00P  ` x7a3Va0a?"#
 1pxLC|  80 S#Q8#C"9L8<
S0PD  > "~&%,?(l)$ 7P?-0`DQ2!;VR!q # @b p<䇢Ap*f8g "**~*B`Xb~B$fAf! BFD0@ @`@ C""p C bB ߄:?~>"
(L,蘥"22gS&pC)}p8@Tl@l$5?b5d0>cqc\^_x	(	)	) ( )H	p_c 5aVR\A?~"!"2&460ba "(*F+8"mqig@8pn!̠ސ0q$
&bBO6  |<  #<@;3 3s `
xp ds12m8@ 	 `p1 3"f2 "|st@Acp>u@$	,	(	88(2l"FfAgAcyOed!'$Bg3
D(zo


~g<P4 7  p }#"4&0PP0h`@   :Wao uUcupp*	ppp$p..z/S.x/Zv/  [<u.z/ B`uVʊ8r
8s8t>8t: t3-v(8r*<rw.p/` aa 23P  	P#"RV{^Zua `R\ts 2ƃǡG
aa O sV
ENjW12wts2o		 T<
t<
tD<tY<t軮 PC  VPP t	| tL^fn!t PD0XM  Àt	¹/ u 2 T.>/u W. "! Q"" `.p/&
 u2CQ2P Y*2Ȱ&P% a#`#RDr
././PSR% && oZ[X
 OCP"P)" $*+.6/F1-F2q-P..P*,/WtO0_P(,4511
*QR.6v/ʊƳP ZY[X7  p$r8299OsP2 <sP
X=<r<0<rà
/  /.&*.5fu'ha /30!b? 67@8/B.>/P2BX;2&BB$CF{7PQRW,f
 _ZYX. 2.9`?t./DqB!D?<u<<@M<<@M<@M<@M{<@M<@M<@M<<@M<@M.>|/ t ?3ػ@ .z/G.|//O7S@T.z/.|/TzPS U0.././(eS;P(?  XDSQ"[@[Xd  WV>	
>  tj6 hm_t!j^\Z(_؃&  hEqA`jFa4U_aTb'c&bu9bo'ceub>'c&bbI'c&biba4_%  = Wbi?'c@&bi#Z5ll|i$#c5c_iJaf]ff_fa5iNa&_(_Oؑwai]%p% QqbP`f>_^j_Ztu$vz{j`t
|}K#c&c}Ct&_tubbX}AR߂bb.}aTU~vz
}DT	߇bETC|azH$wĊaa&b{S$w"UzWUQwۇ.Z[aagaabiva(_ uPa% = u	8_ў  6_t9j9*#c6jeWje^jQ_$WEfh  nbb6 t+t'fhjn_$zLbbP`.at,>ܐ{jh_fjhI>n{%j whnap1t2>a tOafhA㡬M󬳎b b3Pdl_ tU1Av`v`1$  PRJ$f3f
~fPFPhhb$Pq_h|`A3FeмH0k=#h&`Ch  &`Q/$ V`&haOƀQ{F $ɁRo~c[~cQAo$Tuނ^^jQJ61h1]FAPZjh!<@`jr1aOhaBd{IҰh^dA&^ت̎İ%hְ~4 VޢUȰE*_h[hߴ1"pS_ͨ}/۾A^_   V$b^F FPL <tPvV0FF~rыّ F FIu`F&?,^ F*+҉FVc+;u;uàc% ;Fu
;VuÐc	A2ë9Q9@c% G*a*	
WV~FF&8uqǌ@ړ8t
drￋƋ*
߈FLDNuqo WWP`F @fj hBc)~@{ f0wfҿcs;" &]߃&6_jLfPiP` t[jP_1
j FP1uo
 $ԡF -WVPbb4V=ut_ V1#z1
GF| KZ50u2<:5|1ca4 h _& 1
 F GPRE
1NuWFGpp^pO_n<4N1+Fe2l 1Ԑ&bb&&>bb&&obbU	)&&IbbUs+&&bbbq+pU& &?bbs+s&@&#bbk/&&$bbGq+2&5_% &9bb+q+u 	0!(6s(6_bbU-8.6_6_d8a*6"'`bb1:
2&]% +1]1]jRi1:<wu3-Ԓy=_>=3Va@=K>_=2&&=&_1`wj>B3:D@DA>"3:+@DjDa>=-B@D0DҦ?!(ls(ol_jD>=	2&'5DE>sMMDC>qM3@DDH>fqM5NDN>GsQ *@DDg>'sM3aFɳ1Djiz(qM!(@DJUT/ߣjS>=M@DU>S\MD\>S\Mm5L[ÑQ\WZVX}3`w+Jl_4_ &l_'_ jT	*Q\1`L2l_^Z&h[@ fW1 Q\"'W Q8b`
]@-f{QT{kJF2)/y @n/B]#<$h$b01
`0@Ի `Z^ČF&&g&`&` &.a &`arҹ bxv`Cyy_CynzN4yn4y*cCyZ|jL	QuP\$t`O uI t
` .a D1 u3!v? tv 	.aJ1 d nRKE.a@1@c؃ᄿ1⋑r
^ĴuO u}u& @{bZx_ܪdZRx0yfRTyhRz&_^ܭǥ>A0=&.1)0!&_.`tB njw:2w*"w~sҪj#ꐼӼ )
jEvf&b &bu-&#&&wb@`BahJpMr9Mj*_	 =k*a&+a3vl@ҿ&`ҎnZ	 ap~|r^[؃	s$2_&^ŬV^^Or3^P\:u*a 3C8+aQȥ&:@SIF ngC+aQѥ颪*a$ < u]Ѽ@<@x
@ر )`1]#20㑧t@տavZvܿPjSaQCk n+蕰 °WTqȐF^Nr'~#t u^ }  % د pka.d2`^VF  j@R@ت`=1qp F0`   =v3+QOYS0PrؠcvBh [ϋ!yk@Rԋ9Fth h o׏ةj hh~`^՝5Pr)m^p  %~u+`FV Sϋv F~ r~ttuF0Pfv
V#ʊ,{IuuSIұ [t
a' ^v~ fC F@B F~P|v^ KF PN1FFV~
tH FFVJc. Jc  ډvFW3~Oۭj
0Ocp
^F&? u^v}?m_|A_Ͳ\#VA^v}Q`NN Fp
lav}FcFFPjc_s^&/GaFPv4}FcF[ P C_
wPQC_yAZPxZ&@] 6$Ơ׊F0~2|FtFRW^
. ʍ~ʰ	b#͟ _ܡR FQCT~ t;tբQFTQz uP WV~ڋN^ ʰ3^_3"j(qlbP
% [& ,MT(|WVvԋCNcU%Ճh()~(|W~*aK_~@u"bc/}H`B F&2W2} 4, -./ҷ)!u<@   kDy;A<4#*}$:q'A<9?:P;F*;}@<
 =?$@D@<EUWVv<P~0KF
&wGFJK&@% s0#V~ʋvK^K޿FG4Iu`J^&^&8t %.^^O}ے10p0GFSN/ })-AU ~sVNFNO -;uWL0R3F`0AFC&JWfCfF ~pЋߥs^X
F0 ~@UД^1P
"M%ZCVV,[GV~^O&FIL&䐋a.Qi%i AjFg24_% 1 iApivioqj*ivi>3l0iviI3livibqj= Ui vi?_3li@vi#Bqivi$qj2&5_% Ek9uj6k6ڲio]p+1{1]j_Rmq{3{X|`}s}
2&]W% X|K}q{2&AiQ|&_1_(_j}is{*@A}Is{lЁa})q{IpЁ0RQ_3jlkol_jD}}	2&'x(E}(C}bvЁH}1x(N}mЁS}M@(U}-([}
3(k+1`pj[gQm}b iЁ6m_tW j^}b 晀&l_'_ /OoïŀgoIȩʩsz*Xʩٷ>zz#z)	z߾ml" z`.> pj6 h@lcj^(_؃ wjF4_J"ꕽ"oft">ꕽ\"IC"?@*"#4_,v/  jbr [1$?5b969f]fffW,d`
(w?K&'f&_/byAOرm1a$誒D	ܛEzCRڱmUH׽Ċ,4zNa,UPۇJk1S쒱"Z"[,"Ug¼,"i,o!h#sFAB Agj0h!#pWVv(ދ~ &F<t<w
br(F*;]}7Q[~I~taF&8tF|T<r2!J$JVpZ^V[u	A(|NÐ  a. ~0dPfh#  T@leF;rFf?*Fݠ`^ F*N*ȁ vFܾhP fv
u+$b^F  PO FOuP^p
f4b&4b&>>bW t?SW5b@%A% zt
QC a J &
cD2% Pu"c$<!Q2c%B|c1cPuF= ~ zZ)+ɉN3c33е qu*c$<r%pc% ~u$&?u|4pf20#% WP	0  uU4I0"w 0q
u6##Vu*S#gj$cFO8$b%b&b 'b(b	)b*b+b
,b-b.b
/b0b1b2b
!oOwFf4_ n lo_ `ZZp&g^3f~ t3f&4_Ft~u}54O6p6t6t6 t iu5_ t6806u8	56 :u::fh6h@lYX!B=`] fc@/ !Af`A`F\9ZujzRP- ZF  vB F~2|@R1~rƿF  0G4uF&`F[
@H{aHjxYCZV ZFRvpDaF@`Eb*J*BNzQϋIJV#FF F|Fطf٣S-_7h MON`OiG
HHIF܊f CheQORQO xF֊fBt@ t؉Fh SVvv`h 1MZ~Sq6s}u@Pp8M]muFh=h{(  A h _ZFފfP܊FfBjy RaQOŔb
:G0F1F2F3F4F5F6F70G8F9FAFBFCFDFEFF~Ƌvƹ1Q؊GFakދNB }Ps nFNG&F;un& b
2Pd`J0vuе@! !qPjo2P* Y
-i- qC NV(qr lp[|bRw<!劆2_$0TPzFzzzzˡ6Pz$6zj)1ay_x
~`eud߾cfы]e)% ;s0s15t- t*-} t9du0cpduR3du&surp0p&#1ruk05LFĄsiPStt37ZkQr#s~UvGEB	Aw`f 3|
/}PlFPl+PRQ	ƕHzzW_R~991Az$$2)%p6_c2]P*]1jLFP݂Hj9)sE&S1!du]0XTŋ` WV3 W&^&@RFG| x3v wb
R& FWB	2㖨I B	w2sbfW>_߸ b `1]]6 6 &= ``fp2_ Ft 0 @ժB2$bB/O밥

Oca `Fu	2 =`6 Ĵ &&T`V4S~ t'j F I  t/ u#'j`i0t= ts`.au/aul ߀&l SX6_2tI	S?*c2cj PSu5bbm_tVr2tC(_r 2r4_30+1&_10% `Ϣu0,Ib_HbƷap-c,,a,qapaAac,`\ \\_Ua׸UسQڡؿAّ0,%`1ڰڱڲ#ۃ> u[h hB@Zh0RܦϢ^02¢0b赢0r訢0蛢0U3ၢt0g0Zz0M0@]_fl
 d줢ߢtҡ\|ZF&? t5P(u%&|Ru)u&DPƋV@0D`FF"3b^8_fjfh 
0 0 	0 0  j<HA~   A u 0&&_ Ip2>b^ tfj j 0 3= H/=
td-
t]-! - ; -   o= M - -  - N@  5ۋ  &9w&EU 6  VV"u s6	H˰  9~޷ H;闌 f	K>~ 
[ 0
v&@u? ^B^r;PvĴ F3wk 
 菐ne@Z.
b vV>
  !vV@b*䱧F^#0p % 
P0X h
%h  % N!!"F
+F@PdF!vvou	F!ZNQlF@6bj 1ĀJ'FPNQ=)*P!`)-BVW ߾ ސ 3_^ |Z%#03q#C$1F ~
FZ"F@#.-U.;F|!*u*F@P)]<071VvT{)NyC;Fa/t& <A<=SɁǰGGu9F- . YFPFP )G  Y̴tޱBF6FC PFY--A
 Yݘ@#f2z'㪴bf8 5)H&*Ƃtp s|2~vJKQ=VA< YMư2MMƊ*q uNU  :Vn']p!> t гur3NF |N &8tGb	vNX؉^GF
&Ft;^YGY s3үTtpUV
WW뎐V^% = @@A3tTXߋ@!aA!$wcB> uc3qV&e*;tPWurqbg* Uds64SS sF
tPkt"@X 	f^v
V,O`8<B@XO?Vu	Y=Slծ(mmAm!)J(EoprVru; >lk<>8_!K&d;RP3>>wXZ![ ZtNE Z@qH Z y	1zqHRZ)`|>zpSOZuI }0(3+@(b~; ~
 ~IwZ~~T [M}uZu~ҤiZ˱}#2}}.~>Z }P 8 }wZr~&@!~~1. 	*qSSP c "Z}Z@|9Fu|9Ft.6Z6Z詡1ZчZ Ac5O ZZZ·r-» 1ߎûwЗs   r ЗH~ =tPQ[2GV!!05FP;uLE P ;vu_39>޿ ~@ ~Z >*HF\&7wOF( 7;F|~
G};|ǋv Ni>  T>J JbFf&ۋGW&GQu`F&M*+ȉNb&E"|&}1na7tOQ<VC,FT&:t~P}
AoFF WuQp6uA#} D# 9*;ȳ}摶 ~uP̐3&8MtF Nu\pJ@tك*G;W^|`,Dt3696tVoO9> 9S
p7_ 3Qy^&9 S~mlQ	&	&	й^F@AFtIu'9Nu"^*& )Ⱦ bm|AG0"еv
ϐ u#  B iF+F-   `FD3"iDw w"H^e`FP@+|3ЊFPЊF2س D2ؓҀD@2sA1#Нp$kFP+ɉFN+ف H&wwfFf GV؀aU 摻`8b/~38tC8 uеc3al~^
AF>{GД
uеi/N3~(~po uP F;| (2"f )V?NVA;v<%tFu DDF
0N$ pF
P[2,ˋ
- VFa-(V0GtQоB<;v~C^F&uF%NWqm,a8,aQ}  +΋э8sY8vv,a8N&8 uN&=/ t@ip $fh  Zfh 	POQf6 aI%QPtQ"V#EN 8ݐAy,j MCvќ0WVZ* ż3~Bv*á&{ğ0: {f;~=Nu 
p<Fʁ ň {I𰑿,aPZVpqRpE? ~	0~h3ҋ,W/
Bt4cPv">b%`P`8pGW_?^?  9Fu
? (?Dk vvc.EOnVB p,n"FP}+F_- P 9* !(PfFY
rOqpp!(Apz)\*F0'EP+DE*pjO0fh ' 11tjh017
9u	fj+ !(4} O +U(+VbȾ P0 R@MhR+F@A44j3P81H+j4?ps"6ԮRPOQ4?IA8 8WVf+@	A11izPF E+FFFP耑4I
L`?P11I`?ް
P6EIb01DP_Q11HM{NI5$+F+рZ0I3La?4L P /L@PIRNEOaAaPI`R|.M*A RvI`?V`bUWIZEZWgX@F?;vpLOPbU1,mWRFVE-UWXsQQ^Pc RЪ nAfL.^PdV輐C%Rs&<O4hΉbQtY;}^. I/DȰXDPT3!݉FF~_
 ~йP`Q&Fި@u[]aFt
F;k]aҮp rq& tp&s;v}v@	aGF;F+F-	Fp~F&Ev;v~v
~ r;FvFsPI} t~oV='p~p%>PqtOC@rG\P
t/*BrF.9F}\s£ ;F~A*w~~9<B+F"Q ȓx&L
qDFF ЈR m`?A$l|K m	PB&@PF.]. $EppQ'ڌ;
}|0x.L~FaJJ7 K&bv aьvFv謠7ypt悖s$~g 3@rt
ӌ+F"QFH_fh 2^rt tք ֝Iqr9~oaFʑBvw+FQ'g񍐕Yw@K螠BP&Ox+σQ.}+ 'p& . Ütj[覡7B.qFЀqQ'j]h /0vd.S )mѴ/< @	fJbp>JbLbj Ww 
Ht8-t-9t- 	t 迋"f B2	1oF~ tfJbF  F
Pj 1~Q v
 @
a2Ѵj xP`HPVS
Pq#&wP yt`&t0K`ӐC/a '~}	VVBSF
tF
.ъ% 1trrÁV6 t~Dup؎ 30``_طtG B ctD ! m*ʡ3HQR?^9>uf	 莰eߒ_P誱eG)qtRRk e؀u(+HuAu@uAtp j	j_fh%xqtBRPtbPf~
 t
w
ZB0H 0obE nUBx7Kp_Ft} DVV~vvjt }s6 ]bұ5'( FO s ڍ+F$'Eڅw
`_G$Yw^8 ]$1}_p``AKQtdDu@pS@A@?FFPIGF@z
 o;k;NzNNQPu# !0H= K = ; -`--- yW
FA  /P >b  v@$y?;v1a@+;vFPVW `F~F~G;~~PzP$A - D- *-^ #-  "e= Pk'-R`5.G@6-;F?tU tPPP~u9Fu
VV^IVF^9vu@@ANp{nNNbF ~9~o;0V 9vu,< uN>Y빋v  3  "$7  $@V$ !'VN;ou@ x!'^F;~ma4 $X)S+%~Du6b`2;|4` N;v}O; !xzro6Vhq9~ uY?FAY0ߐ9v|GPpPp9F| ~p2^&+^& "F% F"H h\.ċVt ;tt D3nf4Whg
rи>c>p7?0?6@6WV `Dc *a tV@D@QE^EQEfE+]a<nEQEFEQENE0>ۤ u`>};F~JopP?PwrջN@uO_L0AW6FJ5JSK'K5LvL6ZM0Q>&` u)>a t^>~c tfS>^ tnm_蔹h>% hAcWujh1]hZ
j(hahZZАZZZPY0ZZZh^h
[]֐][s]ߐ][c]͐]([SZ#YZaYzZaayZΰaai\ްa0aY]
[a]I]e^9]e^)](e^a=TA44?B^_= Ht.- t'ytF-4tcHt- t4A/Q#Hjh ыwttp҄op$q Ur*䊇@6u0t*HpWv5PV@rt<0	&# EQEJDGQEDGHDG{DGRIEh̍2j fj j )PV)WVhÀAV3j h6	dq^ DΠ  nHtHt#h !sp Ӆ Ӆ 耱t^ ĂX	{
tF(Р HtHtHgHt$1" 4Ԇ0q&&G<jhz	G_+Pr
a_G>AYjЏ@XQ ^a։GP닐v&߀ u~RrjP>6 fPQ3⒇Ж> F~| " "}v@R@j	&8 t"<9GPu D  >@~쑙9@uԁՒf   ^f~ t  |֊F	KsW?	 Y 	1	b^ ro	ST|A^3&~/t&  v&8 ue*C;^k|sCAFQ8%vPbgP-^ ? tvN~ 5"v0wց(׃~ ubDFG&9 uԉ~עPDp~aF=/5 X=A
 9-
 -" -L2 ;uP< tIf齠 tst[mV-
tL=mJ-<C- 	tI- - Pdn- tNAI_j*o P88~D@F	0D0pP"t"}@uNj  2Gq Ւ2 u
ױ39`N3~*^
ފГ&8u	F;|  C	P>
 .pq 7
C
_$~ *`8fu_bϋtP34[&GF |F FP
t- f3 fk f h 7C@j hteT[ZX
ؾ ѐ3͠{T[F&* Ht&= t	_@ &_(߀   D
4  t^u	 hh8
h Hu_tAÐD	 &
h w
p<$ :00vq1D	 
@
@ Dt5߀	@q&	f&_֢"bbw"bC"  qڿ4[F Z8
#TZTP7UEt.7F4[[^%T`PQt`$l&lm],am3Fm
1nA4 
Pr@_j 06j 8t#
P"
P0qfsVxbyW3ؿ4[ع T[2t_ t&&
qz &
Prk<|?vb
\

%

a<J
@X6QQ
ڟ`j 0M L<B ?oTPPs\2[%  PzpR
/
 $*B!!@""4#!@";"tB!x!""ʲ&3[D24#V! ;@"(TB!4!""&kH*=	FPw- 9t7-
q= Mt%
- Ktn-Mt`PP2IXpw= N.`ḷx ,2"0 6 6"&2[U655Q6 7 5555Ր),2!)0 < <g ~Pu/߿ h!"h Px3;飍 PsT> >=P;.;; 덽,t
gDG)2[_wxpVfhp?h wPrP~A@t&A 
@A KKCLLKKCLLKKCLLKKaLLKzKaLz
@_2[x
 @y
rB,PrРg-1#l-+{tP0t#'mKt
- tu;5 )@63[H)!->!
̚#==a>lj>ÐT3{PfpJ 	O
^"]qP- +. Gfb/ 0 q]1 g2h>  pwPHt ;0: )@B? ; )EU<0@@tBh
h πܡPyDu un 1o;t&3[3D!
3G3skH)%Ķ!
(Q)4'`!s$vvQ+^BE$_1o_aO 
fhAJo =B}
Qt 
RL޻
tnb۠!ö!J-w B!ā`
  %s%āU䴂0B!yāT`(`˵0B!QXā*` 0EB!7ā,`U@0B!āBh0B!ªC,BG!ת$B)$	B	[t&HH|!CqP$`ՠ
`u2p\-tU.y^.]|/h0gVX263/@3
46T4&<P^lzª?$ 5:1 a8ꡢ0: ;Ρ;za =[  &[@jXF"딡@ 놡v7u{ttm[ 2O 1pQsJ&[Cѐ a82100;b졗
軰}Hf[f4_rIWfhr  JqqJӱ1Tf4_f[&/5_b
@! RL D!@& qL6 88@!  % = $ u
@EHu-Tu$uduu_	(PT0?( PyNrhB,߲#vqVhSWV
	[iHtHtHt$Ht-oL!+Af!!A"2f2
2G!OjL@r
Syp*ОWрp\"	5`(p!ʁ
Eѐpׅ>!s*pТ޴GppЀߠI$f+fF0F@F\^F>pFF ՞DHD>== Pd  -7 -tRa   -. -*t:-~7 ߐ=Y_+- ch ph-fڡgpht}gxHt~/Ht:H@ѢS6@(0:r ;2Σ`1 3 a"թd@aFtm)% $HOV萠A{h^\,!- F`*HF=~4 fI fF^pvfvvFPvFCu63F1΃~%v슅^\ :uF3G;F `-~ t
&X&8XE8p~&0@H00q@qH t&P`hÃuPq`qh@"Ht)3 C̣"222|BQ-WV&(pJ Ǣ&P3vQJ.a[Dttt\> 9FhRJ\S
ߘ[.a3P&h;@o,-9t- 	t b]hJ
{ (pPfjj 0J3OEau.sQj&u}Dh 薰&Ɛ>\ tufh   f *!-q	t""5#>[ tKh=h>@ohۖ
3\l\& [h-F |E,Pc >[ u"$u>>>P$`t(ѐ?6[@o"}" @o;$1!$ 5"te3/n\--.>1"*u	>[ i@Z21jb3|3{t"* '9s"e `#g[8t'x:.3H4^w6
JtPrT [$x:3$H4,T0a~B!tȐ$Lfhq%'ABAEY a~A=iQ7]j7[.RJcJ?Kmjh\_j\l\n0On\.a0P`QP@H l_@ÿϿ4jN
aEObO͂P2T"QN5Nv`EO0VP͂PcW)[#QNNNSdOS2PZ%XN*cEOZ\PBP#^2Q$gP¿ظ Dt,-
t%-.t,-	 tE-
otY0tg- t/gC Di[:~ 轍tRe}*f  yofFbV/at`uCf&/atj;u
 &]l.allUPkmn@lUlPkmnU ll Pkm@P@utǀ;>}k v v r֎Qh"i	tXQ6  Qt?HtHtgw'Q0w/`yxYIu3t^0aFV^tFu&u	_O`oabcd ?e*fgf>> uh h[h;h,j
ղiP B@tp"q 3҉6 5ŀ@;@t}F>
r݋F@hVҎ9ҲB{R茁%pJ<b6wf
W~b0v3ɉNv~FV
tut9v~O.|܉~*`fp\P^31
GF&F$	Fߜu^*ۍF؊F% FnvBĉFVy	NJP;33V~"p9tG;|	FCF2BF ы3$uG£4t%)6%`Ȁdf|\ff?f0r @lwd` A|\»n
An
e tPQ:d H
غE}d bA ^3~
ǰ~
tF^&FSu	Vt,0#$0}FύEP}@nGv&rQ6p=A0=q	-tX- - 9 V= M -Pt!|-຀ cd= Y.0d~үԠ|\Q|\+101~\- 2&}\% !r w ր 3Őj@H jhP
5!FУ c$.Ra uj{3~
M'Gߐc ؎Pⳣ]8#hp\c]f|\]$@!fy
@@&v
#f
nv
@RTw@_@vχAT
Ad{tBl}B\
|fhppp
h@v$rnwx
>auz
6p  O hE0F<tF
h+F dMFC|gFT`GzvEVF$:Fvm
0u(Ы¬p$
F&AN
됕{\ѴP9v𸡀\'\մҀeu
骔;f 
 "l@V Rb+lkb
ĊUѴEbU	("Ubm('sbC"Ѵk*d 	bN!"jd 
bSB}d bUϡ&P
մ]d Eb(Pմ<d U
b*Ѵ,d C*մsbL&8W,bLB߱,-
bͭ
- Kt KBϗτ 4^9}pTѠ 0XhxĈĢĸ ,22Հ0ւ\ן:2; :2; :2; z:2;0 :2;@  
- 2&P뫝@CA;'_ (PA @^CAd@CAw@TQEĀCADQE1
-  3@
O+- xG3HiG3HuiG3H iG3H@jsh2&pN wl!$8DŁ9LV:{bFA?q<Wă&_Ir#hf&_f@Cl_vq@m@@aWta qHcXH ll_t&X`XkXsZZp4[pqZmZ4[\Z4[*sZZx4[x\_U4[\Z4[\t&`X
X@&_UW@t&fhkl7誸q~mXtWRb4[@}g>^NfhRh\g
VPk ^Jgf pCtfhp;p#$h"+Fqln@ognPk g6PkqFPk*R()h'Nr
vPkrUtrtrPk-,rtrh["B&`t
Q_ &cXqZ`t S&WNg}0Y&4[@@ut Ƌ;>``rhhhFzǄ 00\Z& *䣆\Peт u$P  1 j hthz!3  t~@ 6&` >.B7  + `j 6\z u.&&.j`t&6n!> |af@@'FńZׅ 1 Dt,-
t%-.t,-	 tE-
tY- Htο- t/ C D ܠ:w> ~m|t}}t  "ڒVVfvfhI?
 r2u 0h  Ǝ؋F&?:tF&<:uFF
*0N&$A
u2p҉@ F ~ uF	 F
  
0
q< w v ΃j^P@RPڰzU
~0G~ tghֳ v~ tD0==u5 Vѩp ^3 FPPԠƠ 
@F9Fr ѩpɀ-
 ؋ v v s0d ƨuP= wѬː(4@L~P0!;Pz~ tm0 FaR  R0 F% :% .% "% % K
%dP
~dz~t_ @e3^R/V1.tCu^GCuK  K.7/GI Nr~u`8 W@ Ѧ I 8aFVF^=uF&MNԈ'#7ÐWV*a$ < uhX@@<?@u`PX&Y߂hrb h<hbw贽bt1Йg6є aЙ@݃suϵL4a-6UQFPi5a954\FEϙ 1F9] 0""bA0޺AVXyR{F c67 F*0Ht
4up`4v jߔ/t@uf4;F~AP:rջN@uOhh4& 1WV3@Wp
GrН
    :    MHz@KB0q  SIMPLO  MOTOROLA  HP  1.0C0q drivelock  Computer Setup  <F1=Help> File  System Information  Display ssiSave to floppyDconfigur2 diskette Restore fromH'defaults|  IgnB	hanges and exit E s  withou
avingT Securit0Administ or password Pe aPoweOr-Onw'pR`DeviceH $'d<eD('$2 D1Lvs!martCard_$p%BIOSv support%s Embedded $&*	e]+etac p s Tools Ba/Calcib%1 thqlect*b0 HDDlf-T opAs Activ@2 3O|40Statu!̴d3 s7Ad_vanceLguag12 l5;Dem 5Q< of gray*field Boo4b?$@BPresy key/ue F10=;, ESC=C:l RF FGAcc{epF=Yes#JNo !G, Aj0Eo2rQE=M  KeG   Us|2arrowQEp2o highlpP.he appropri5meOnu i1pD<ENTER> >begin!24.Nfollow!O Q`>4:@-> PSPACE = Nex/@ -AYBACKYDviop9VZTABYc?SHIFT+ ]\^`FYIV] GYcGb(1 E~Or This8/cann?b1d An e1f koc r*whg .fde _0x01 pfefnS0Rent2fp:CQlrequiijad0 Td!baOsmu4gmov:ge@Ak/MEUoieQhR lqhij2hKe7iecple!3suIssfulwManu1/r  NsrdGPsro}Ptyp0·spe:teppZCac2ize (L1/L2)</0 R/OM R0sRfamiwdboa%\BseQl nu0*PVid{eo' KeyӇrErpVverBDq\
d@201$L020304LH0y8kp__lefg@
rP/{r.aZownhip(](Ed Є珷g3?Д 앿7XϙO ߰Xd0;da9UBSN)]$ 1J2dJ3IMEJCJVKKK4XTVJ:D;˿Ј;/:S;tFWarn : 0f`Q}`ll0 	oEQ R3\Emsq>26TEre5a a/@,`le!rinPt0w@ab!<" A: اpw# waqlt0t3a @@rsBInv01*}APiޡ;eAgyou'Twamto  Dt
:?-  i_qI  3 q4 r41 (QuickЄr42 (arehens@3 (S.M.A.R.T.) Esti *exCimP): 30;܁4 Tj`QgD.&]0%}}ep*pp13y ho@Fwup"3"f:Qd3'tT2f-Q Unkn /ilWWr	Ser9v/	Reao	do g'4G	!0rib:0!Ykjex1ّ  5b (A.  Ol%`ewV`fy nؙ@8EnOf'f OPuK @K PE'^WroP6'm l\SrPodAd= x 6'EoSm4T cp als09Tm.&SmartC%5:R ' ifR2\ly^/E~1SD Tloss >9`YhouQm4nx`-!T!rof aatgo  5 Cevmsf0ܹ9DoishEed?B power-v'5DDLq>Blank  >P3 P+ ?`EӇRm0- tv< AS'A+vP	s c"oUP<OnR
% %s. F4T. x0TU&J 7ndpP sunuQ.0bo5nA0t)pж"aPfraxrQPara0TQS9DPdSlo1tol!net &P?MiPqFnW+F2>U 0t@u'CD-stYY b kH[zH[3*[4btG~ !pUP_Q2 R aGbouphV[ uKBq>JK bot9USE=RAMASTg&Jc&tMIcpPva!nP`-NcqMg`5Akeep i a#(oc>uphysit`-sepR
Ms  !}r. I b6r0Cfgm,܌g0yn be  B"unoi A+f%pfd ;80me,@Pڀf&,0p;ibty. I
frdoT-Wdq,,1ESC!A. 4:}-*d typC"&'fd'A L pF10`"rmp_`w@.{HG-QEngl9>aYbV21 OerM:ayXc
u (ќ0O|bR) USBvXB[SujZ`cFirX㶠hi@FMth@ifSi9xb6h EᲰN@hNum ?PaY SwapV/Ctrl!As KDAADU.SpbV`p<@AdlegacpChplproRr;In@Q^з V`Fo @b NTSC^AL-J-MR"1tARBidpWGal EPP ECP}1/size 32 MB 6Y43N  QFoPn Alwayܟn whi`) @ACcHߒ2Agh< kagp}26O`;pp DD )S`ftSomE LrU ۽u[!2]3۽Tok4R! lXXlW[o@X\@X]Unique IdPSif`p#_Be@/  tu;oӏ SCN/ѐ҅CbqpONPs1_P36Da/@ۯ܁6b ۏB3OoxHA`)O6L MEUׯo/ O6RO׏ O/6[pn_1 : C@ygN% ]
Crle[2 00e U
e=3 @lSd
Xf*@ڶ @Ao- y^sK`}#l  Spp: bhnologOy Auoc7:DLsFre v2<FWadap_Z""PXE RPL Ex"Po'pup01(0 10  2.U3.4.5.6.q7.AF12-O5 15.02302Bpf oucWhpaPP%SP?Non[<F1=Hilfe> `iinG|7Hzei@EufK`peicn  K|gua:<V @=wieMRn\<v>?ein"@uQn:OBv-kz<?McDigno'riepMNdPwMHn;t }nehpJ>H>JMNSet-OS;heitsfunk8AdP9istq0XenntDST FIn1lt-KeTW-V ?GertePpTR8oZY-ID0ӧ]YfdW`\0tCњWr@`Qsttz`D f{r gcBIOSWoc@YAgI0q'R<idRvorrK`DkO\:oCDzurׁck`zz:Ex|S0AkkukڔImKst!=sgewhltr DD-Selbs0s8rtivIB v3Sr!Zp:stҐsbtGu{rrwRssSpra;~t!uQSnZTS:{gran Fel;dsqrt-#w ˁYZv_q{ipine@likebT, p9@efahV0=A5, ESC=Abb`h:W8}}kzeкI,JaNCI, J?=Meh$;6 Vep}JzpMarkw@s,!tMenv dPfeiltA !Jd`XgabeRmj1xk<1x#PqPJP :.fo1lDP"n e<IA:p->= +r Leja = NchXaX$DԢ<-Rqchritt-"ФVoHTabulT֧snR Ho"llӧ+ϪcgeTҁ0= HKgEsc֧Hl0_i 
r| kaynuKst we`pei"xsaeS1Ppr1=getrn.dc+ 0AxpHPJfmiJt  k1BuFe/QW@&wselSomv @7orgaeer9Bl;r"xDeskv-h}sCnmau,`qasQ޳'bzw.Mobi`g 
tz.sael`:ti@rJjϺ2s1$zJϑlgr; abchlos
 @d'-A)ll#z$typorbQlw&igjSs)a2mCQ~-`%;-Gre (L1/L2p.Ekapazit`/OM-R3s
/Fami %"xsFp P`Tummh' GraGfik sb>@zr-Con 1^Y?VB7Jr1 2 M3 4;#-uOclinkqqhF3saiqBT+(F0b q`DݚT? A|Y7o jz	OR
g/ak JCrD>K:A4"D PstPdPn bisAnƀWzE@#R1-/W?"=leDb$K
 aei0ekA`L@= k A:& nfЗ%l$KgeRJKB/$K%8
#dglEj/D A Lo!*-  -/)p:M<wirkEG<ϽG?Oc>SZ, dapJ:|IieD A :;<O:N?u  T y 1 (npE2 _(Umfa!dGل#fh"dauh(Min.): 30ev6dtIt .0% OCہEEwu`pm Ho vpE\OudbrЬB: JȷK$SUnbeqhR#4&S/rvo-MWL4& JO*"Rejhaf1Attr7ibuIDa$@mpVdu! {.M.A.R.cT._ .d Ap|sg!g N#eu?eVfMs! Deaw h`z JaeeugSO'q=t FalHggeb AwgefgR7rb=ĝQ+ dminP+orsn Dur`hp_8tBK  aaĝ'Ho~C-'h.HzaQ^Qf,QSmC7ffҙz{`, sof6s h wa.Ps Zu  ц7*5~L Benlusst. b s@DE6nPPamlsvice!5a@s ,æP`Qfg0 hPq`ga~t r
 5tfa #D :ef-Ý5c!& k9 QuickLockSu;nd \frreBCM Ό`hQ$bipt  CQ6chutz~fg~Q6Uȟxf.TӃbf@[, l3mehAr0r̷k@  f"<v"qAFڳ  Inf0ot-.|PareN&>Draht 0qNq'e "k"tm`CD-&W;&Rst	'1'	2'3߽'`ӣҡ r:nc36m6rive0G"# Ѡď⍠@!ps -Ӎs mpt6x#unbrazbar. Dc6Ik,BCbew2ss a:݀[S, mt>np t Eס0}w	#, 2Tq֪uU,  00!zuqњnv±0z0}- uqh ŊraׁMdectantfyĀTwARtA Esc-Xah  DM(o֊W
g''0ّ F100}T6aR:}cpfPPg@gvU8ġrp QD 4riRQNMu,BayW8fV (bso (b USB&/&' a-]  SuP  Zip' 10}20}30}40}50}60}70}80}90}Num-Funhons-t2aUn/Strg聏tTR%| wtEngli @GSAf-{Ze gerTradiR1! }Grafik?-Contr?[I^ Prim[AVideo-HAװnBidireal GrpAе;s gO  L@_m a@3tzbieb 2}tgNss Egsparp(Roscal@xā=A"m6(oP)$%&]P''EtC@ِ`o*+,-t_/(ToR,23 ?/531UO4:t?<_=1jPh -I@ti@at~>PikufLEF#	  /HOIoJ(KaDM Kalib^oLPGMpk6O6O?UGN]PhcTЎDualQXNfW \/RKSo[`oVW odZ8[ch/^K_og lob_?C&e_o piL_rpmriff-D?eVO oz~tKS}?xWqL&kobiq w q)OpSopmR )Oo(O;|y[r '1 : $.,`Gg% ]ab蠵2Entlѝ ؜i/렘3q`1$ m*}۠ k_OeDOVDProz@or-@  utomBo  Legacy-f0ɲFp1@adap ![Bogotmz \BExpQ --Popup (ހ.) W
dauBF12 (Z Be0P@GCompropstnP9 <F1=Hjlp>  F|1ToplysɮViss=n7e Gti"t y ͑konf@rB *GfraБ}Ϻ5 `ѐrxuՔz ognorn0# ofsluD1f ut /tfݣnePkphed Administosko0 K aA foBBE"8dp ejeS-i!pŰjSm CB-yls f & BIOSiA@ r,'j5id0ls!!Λfa0SksPAl Ba#Od,valgb0 HDD-selv402[tr " S	 Avanc Sprog Vlrs
>monnedt!t fel0[OʹTryk p tas۠t=a
, ESC=AnnulRFaGoud 9d=JaNej , A=M`VB Brug p0!@pe~!  relepmenup ,tT<ENTE'R> Dekρet.1"f 
@D#uϡ @~: -> e MELLEMRUM = N),<-$-TILOBAGE . rA.ʃTAB&.GKIFT+303CG= Acce x̃ a7Tx> sfejl@!k@Q`s0od<'en. F<R012>AQ=no )5  plaA>krv@vek g<i d;	s fly`	s#n<0Bü/MEU%@ b$ uveztbrud0[O>o?@2:;	Kvpmfp
8LducPMctypPGVh igHVP٠tr$ccache (L1/L2<ƊYhukoP ROM-fam/iliek<!fᦼ`i0%%V o)^1s(	r-contruoDG-ba	sk_)cdp0y_f2fB3gB4jj_Hl&etc k)cmdc@Mp5nhchjrzmapt-taFej wE(at)ewgg/{3 _|jwkwomoo \qrthcw#Epdwvar : DbCq s"0  alt0ǒ.holdѐ !o``	 / *HSb-gβHdqd4, r B=q=kbesk!IGr MA: D<5LB=fqONBLш6OзUgyldigAtM  nGgivfՠuD2,0vi0<*hf|? i؄hܫ?pJ Tppf(HurrX)pOmfQ	: *)slB 1 (`): 304A  .~60% fr`udQTLrհw( Ő鷴M(@: K=r4"BһU <ûS<erv`LsP	ribut: ID .TANңb(S.M.A.R.T.e"
My. vNy: BeDfwt nDea޵ Fral  Aa@"MʣHs  ##%̆DODB DC.Q9B)s dqgsHrp+rOp hvvSC  tBH%#meütabrata. D/u bOu JIflAQ0U$-@
viceh AP)D0% 
^
{J4  QuickLGpGpau\Lsam
vS4hQbt W#  . EHuR m$-m` 0@\ ,<di0]AMges. KD3apl pfrard
)!dl`PkRnapp Cd-rom-`Jc3ӔIdH`A 1T!2H3H4L\Ho8:"	euўЦ嗪!h,rr D> Zb0*BRUGER-! HOVEDADGANGSKODEN,RT\ U al@gQp 1nP)b N 
d,!opbeT&0䀚3  0 =?"Iat lY F (pYuW`ebᩁMnA.  UB=aݧ,H'tryQ= C9w Ps݀H񥒗 or '' .e0r(7F10#;Sqc0mH3ѐRD[s@YAݐR1D3wk OsrpflgP^UcMultiBay (r)GHRu) USB-floGppyECKcsBKFKsupeDKzipBFQned%jСFx!F`]MjSyI Oc Npv!TtTNum -袸i0`\p Fn/CGtrl81DEpl (a mi`sk) b7egeen`qU!NuNa&PnPZmhbe^^ PrimAaVideo Out Paraps
U Tzpj0BStrpB7v1bhuko ! BlؐHd t `nr? compuPA1kpqAeekPrm(xuH2- Udqe1'istyQ@<ptica:eHP=tp[&ahHtopZopHbIpEthаrtou l)rToP RQ <u(yv(y;x4
,u}v}Ent0Lgt id-nu7rC浟iS0B/O*ASo,KalibQondS__ pUa!`:HJ ϓߐX_kOrHb_
 /k߬ϡIion_ƚ ?_ߩ߳;Hpags +ok_OV#Ivi mobpuRl  H(MEU): kOo͇/AK P,>lßп6oC[0in 1 : Opla .c0% q]pDN	nem5t52Af᠘U3GenoS< * YPA o/пwܿProcessor# AutomN+P3b0&h  Legacy-freeUdm2_
%EHurtiartpopup@?sink2C(sek.ZA?=%=25-A[Q@:}bgge PP[p3 p_0 Konfigu datamas0  <F1=Hjelp>]il4i9n`jonbP#>W
 om sR GLag0^kt
آ
PA)HePfraVJOl@V`Ddih/A?3Jk 8oP"`og avsluQA6B,4l;s?progra W2t Ad0
@(r?atorpaq0p2i
a$0pOp4Ev%AAVL(Uyrsu2Ўi
+sfunku*p]tifPZg
	/6-u%/t%2og2&-n Sm C G2d2oF6 BGIOS20^O6Iby 	l'+o;,[+i<ЎTilbakelfab@Z00I0Aprkty Fnt valg7Al_P2oeNi;vt A AkF\EFC
`qus2oODq$vpZeSprkplg <@#0N Dem #%0
*Opdt0el2)YH/)R*RU&mH.TryMko t71o= =aN, ESC=AvbrAyЎZrZo[Apip_]Ja^Ne3i [, er=M["  bkyWne pilane !tY<ENTER> hvdu v jWt. BrukQP$ef
߇W:  -> e@Ar MELLOMROM = N A"?eB 0<-mTILBAKE nrig~n
TABnQHIFT+rps= GopXq[p%gsfeAgF.{ unqkgOp0nop L i Mr m kj7resve!G+mЁd|BE02pM#ba >flysc6 m0S@}7|B[abbv0full/|Q!. kode 02zV .{ du >t Noblokk-mЎlql0΀typ@	higr+-gaP)vtbuff`(L1/{L2Meng&pe-Pre
deoTKr@tro!mS,kobB@),o1@ i 2Ϣ3O4̥hRk*n鹿*мz1yϮIJdi٩ E078q(BZ8/! !<i OOj¸ĳEk%žAd 0G: Dc sl!r tid9lp?hold0D0HgjA {/h0e-  d, ZKuQYd s !kl1kp2cnn0Aa:{ bPAreg'M
ViUUgyld#igteSbڠ@i3)~EKhQt,kt%Ђ@L?O@b+|F ignok.?!te?  K H~IT A 1 (Rp)0)slؐ  (&): 30SGg7r .vv0%X"Lf"st)kvЁ%: Kaut`,IGUkj{Se{ oLe!s@r7r+ܒ~rib a: ID n01r|s! S.M.A.R.T.-v a[@.3  G#u%N6kreft nA%v  P`P%k ؁`@54vP,likt %Du)`) &%Y
L7IhOaaGo
 d-s@sPKr<P7e7s`Q6A54!3  + Cj5}d@ABR1apPinY`Є. bfkupY@  m@k54mMvice.}7#r!#JljFZ?	-TWTl9solank0撂paus #L AmKTMMG= gir beqabeska PT-BOPe.  u 'rmgleAdi<Ē+ 
%dp@PeKreH$u'b5m5MpPZfrard-DoParap&llDkaTrdl `Qtpk KnWappKtGSQT=  E CD-m!6J&Rr!% Hot':ie%l}h0valgtZP9QY0P2 dh06=>m=  b~BRUKERr;?HOVED-t'ql`9rumu PAq9Q2BB@Hd;Vke:be !1 ePPn Wk^p@  (\@-aAF==U,|@ik`BPgm[rA 0e: YPA%"]c. sh8@AR'flꠄ ZϢ
aek,! ]py-a4(b oqa
R `
'DaLocky'hrq F10ErhZIvbSe:Nf
4JkG{ rN#orR5F05Ou/re
m MultiBay0Pconׁ(4ā)vPUSBEKQ Zip#+A1 A@ um) vQt>5BFn/CtrlDre~E"lh(USA)p?ekeenPO$eQlA ts0r0%eq.32IpET0Nis!6rra:A#; #`i0z@. 1 qAqPmbց2`^Ag@sssZsty^`tica+e( ve=h<聜 (vӁb [ Et!h.?w1ϨhI2h3Ϯ o1R7߬dHsni YtifiBI,B`J (/N Dy ^mD libr=ABa%0O<I
Ppl 00->oˉ̏o Ϥoگԉܯ`ksp. O>O݉nd zO/O`? mob. P> \\̏\_3 q]r[ T7n^: La_.j	0% ]~mfu#ll)}c2!E	
Y	M
j
3: igjen6n_*07  =Pros!uT`Z!U𑐥Ơ# ;nd ZGLiRI`ti3Fp~inkxyR: (seA_`w;F12-y(Q*.POړS`epute PpConfiguraci_ l Komp.adora <F1=Ayuda>@7rchivoDorm/l S=maP!<r &2s3Gu Z\Q@co ?flexibi%6acz/Qp36 Ri)a/
s$o6:K8/;K<pPo@ prYfinido0</@ad<@Lx5 Ign 1 8ambios y s .E10K8 S g73E 7<EHE~F e/idadQ/P4seCa)dbr1 W/"8MANM &iciooO]RM10@posi};SsUVIdc/5hSp0UY@CM sp3VvZs(P\-^|] Sm%C$ o` BIOS{boSdbgUincorC  X"Zi0jVk:7cp0K8PXfbr Herra+mipa0C/erZSr(s`m@oSCauP@PXAutoprueb_a HDD 2c} PuwEp%A>R0 sp?%p3q?&zt>lAvanz 1DdioaDS&u4~Dem24LrFampkco @ g!r )xR_o)x8VrO AOprsimdquigtecp0cin06*=H, ESC=CancelTM"=Acep\%?=SӑN0S\"F, Co{N2=M詎 1 U(_2bb07chthaao@alv%  {lempo apropizl PKvQ<INTRO> cz Por[хn.6s/qP@ėctf :
Esp/o o -> = PrxR+LRetroceMs<-k/a!&i@O8TABSS
0MayKs+Cr p+0dGH8FHErrP2fro{ X0o $p%VsScr(jo u 9s/qoWr. Cd)100}1hay n`cun|!9Aub4\hL&ХiPCAØ˵ab!&R2s(PXacoq iBt"ebook/MEULIrp7C4Bmat/ ?_2yIrpple0{xitosae FaqA4`55zctil TiХ#OVpcXlGQu3(TaWma5zmr@\h (L1/L2,/invis0ROM pmila5QPXorc5N krqiΙl v[R0SV`%3rMl1@R52~ۏF⇿|1z|2$z|3z|4anijRes|o/FizҋC?r|KEtiquP10urspEIBeX(l(a,Of G?_qɿ}3
_
 W O  tz_ ?! zZ5
e%s n`6(6`j 7F>AdPteEn:cda{ouir{  1Pe@3^>. PFcre Ps>$6/:, in@܀Ps>1scriBcu@ XA:W|>(DzUu2`m%0P)!`l>Tg2t(`{1tega,3PX1(.a6P@vyl AIAusanP(I403UJ=
2=3vare7Hycmo(a3) "+eaq=o
Fa?~gn jǯG$H itKl0`  ir0K'Bg'NOvPv1 (Rp X)S2 (CT3 (S.M.A.R.T.) Cwlcutieej bp(Fxs): 30R`go .60%˦Sbq˦Sјi0iipal:SirumT_l`b: 7pu FXqaxycFalz +ofX1cServoff |5p6apoyav|Thatribx: IDca{xqaQls V^.qseäa(rnu3evif~sDwvApkagq~End>CS)7⯢utr:eЋvocr^ms% "|atz LÌdr%adF0&ҰepҺ'DØei6inhabPCIπ, tn@+@IL21+i@7p#%oϰ4Trs `3SmartC (, asao,  ltQ6  ;1 f@9ci` E,F!1f a|SprPxin S~f07'l]a* olpޱ?(uQYv@vi`.qo1ۙ  @vpH'? Opon@QasR%0  QuickLock~Q(Suspen Blo"K0Orat`n"IS Ήńi p` (qqmejKQyφ. Ppr21tt,a6pod+u`izC&pR!|u`nre Pu):a`u /rojou1lptjARed0oalm#BoqFI2!1CD-R'AEu1Q(3jdGaǰ
@/ɰ0
ʰڐPְ|Pu`:rUs'io: ; uक3;~D  medi,qDrive@D,USUARIOSPRINCIPAL+HPj` 5;s&d@21pp`F݀a. AnP; y gu @I]0lugpKLG/  ~jAmpe W. Ele  4,sdAd- +b5D1 0=+rfi@r&!?cde2Ǯi ^@Hponsr.фp6CHtv, k@I? ESC. - v5S1`Vala5b'&' F10p`V&s:\f`}-f ^`ȰG}֒^\Espaol O #ћMuBaDPE/@$()?_ (4 )8USB|ã(ȁ4Su p-kjZipme a@_ TercC'0"!"Px0"S]pБo O@7v?3No?DP?P*cl #o Num0 kǫ C|zs Fn/|0TêIngls (EE.UUPWp-posi vr᪑m0^pSČew #r2j&ca'ac*pO>eo Mo pdڽ2a  Bidqi`TamN!1mem + ĸ$i(:sAXfuPy0/! cu`@:B71CApA0kNP;book 2xefg!bpos^`"s"	o`P BOo,67 (s);= 4>E;th0)et,6; =EAȏBCpʯDCF!=Tok]RingoDIFLH$?!1OP2_QP3 Itt"YExclusvh%SAOP9X[CW᳅bYC+^$ZmXNc\co]^oy "X`
h1au`n?\ce_`ogbcs37b 
Y.fm_hip_bc?So_ow8xOr j?zS{uujݡxnyπqo|oOucMEU 
]Uг_ߋ??c[ 1 :rgrb4.Y% ] o )@Qd2Тc&u(=C^leteU3 5D[rl!*`" as?jeN
ha N8q&^ 6utom crblb4@4pz,L`%cy L\e ArranЬpR( ,"4sD10gaV&Ex03(1"pS F12_"u#Ae`$Ambos TouchP0 PѡN0Ou8B0a 3C  <F1=A_juda> 6r
 Info@6&so` od1Pi(ɑ+m@ Œ42HRqrtqvw`ůpadrpacE1O Ignl )~Se sair+(вs0s؀ۤmnKanpa7 ҴĀS #SDr& $'T bP,_dp|%e Sp*tdq$b'BIOS/8)a8embuti ԜDp	fbPF5em0
asog1 )i (S`̄ #le3`Ope T W68HDD A!r 
 Statu2`'aVMu@#e Avq4S5Qio1AnA8i8campcinzpA  w3lizow0*ess3e qPe $tinu=G
CSC=Cancel!Ace"imN!!, QUou
=Mai U 2izSsq` yd0 o ia? aprop`0#0 u1<ENTER> 4merϪଐo.L_"gu ٧r ua):P -> PAO; =PxiaK{<--BACK@.CE.a1@-.YTAB.o32SHIFT+c3CS%22=WbjYSC53Er` na0obPV;QT. Cdig\
o 0JN=#h=joP1$? BsP2i2 =CAc A=}ev> nsf@2Yo notebook/A3< e00m e>@5A2; |Rrm xiW el
NJ  Tip`%E"V0UcI0V<X Tahrcache (L1/L2Za@&m	 ROM visFaml`]]a`~cxBǳsriXU&_o vdeVerbro `=G1 Aa fhe5	 A ?jUkpQlFk3m(k	4o~lgq@asthite`xhyuira{gEtieBpya逃%eWHUoq9(P)߀ AΈpQΈ ooΈpqώΈr /uϗ {/|ϙ/hUke`Uksecunda]ൔAdvertn0: <V+3 $ea$2*ТCc	,Q̠˵/,si !um 5 gravv@ GunWA:t;IUd3Aw: n`foiP s30MHqdGXOǴV'tegSdaS8MvlDIuǴM +9T0PMtezR`a$eja S?oסoÄ i׳Ǝ &1 (Rpx[2 (AOngqN3 (S.M.A.R.T.5!Ax / e(.): 30taA%
.V90%ctѵ}b@Hsucedp$1X1Uhos9tt"romXr;: I5ss  #kFa	lRhPag er0mec
`FsraJ΀trIiP2af1 D.8A;=exaa@+s !.#2igsov,cifrJ"@a"l0L  qpF3b4i rr1ҵigpN&cis
gP 4 r% eAdp`MdDa'modtQsPR+at6tambQH T+0Or	ppJ#e
mCarQd&,# MCviSN0"Ac)sfbr [us` pform. ]b@(QOPM C .3JaBaios. IAY`v@CrO`"? O#F1 r/QuickLockJ Suspenso BloTre&FouSXC<auE b
  S 	 jd.`AWss impuSYd`. Exig=&6PR0&-erme@-qKl0:Re=SVot%rY2I
&aTCD-^4Gk1+`r1$?9T:2:T:3<T:G4 P$!mase: usuAE?: VocྰuV um7d\&	:utiQ&n eriveq( ƶ( t4USURIOQTI  MESTRE *aTQiD9$AZ@apaz$ . An$KpPde-` Wa.iAsU B5p2\`$b. Nv0yPpFTH A,Qpo)_&sbKD9M B3f *A.dF  Lem?bre-seQ	vQUaC  Csab0FQtF,ssionep2 ESC. о	XhQAþl+av'F'i<iF10.@e )o r:M@_$FeQ-ugus O ) *6: Multiba!y/>M"{B{!(~,)NUSB:Rc:(zipPrimeirrrc2QPS ՐOPvN`pc0`A{ s!&0HAs Fn/Ctrl-CyIngls /(E.UVB
iesi!CQV"S4h`̠
 oa "deoaSV`B!aCFTMoA/PicQpp.TazOhBmem#tOPC2 fu`pF  qurFBoCA@4 ŀ2{Gergi Anerg@!ǀɣAt `o porEEtpne	t1Ow䯱ʲ3Token Ringo ϶B20?IdQ p0O Bap TSta'tusV +Sc+\AC@&с\PCgemSPdFl`Cdr Duptedӿ?Օ ?s&{/N͟Ha`ѣAX ӟΟAl
^?߀"(2ZU _?OGDP x[ EtP 1:rregrrF.#
% ]xle"
2: 	


.f3: Re



g*V Ͽa{?ӝc! Nme@T +?amRVCflexvecXH8+6dap3RrCPopupy ExiSeg0qR'F12+( TB/s Var\1Ɛa NPIu?TietokPp tuk4 <F1=Ohje>3dos!Jrj@elmt5t Nyt j~~6Tallenplevykkeeh 9$9k 4oneo9Pn0V9tV<:R=V<o4e<7n@s'> Oh muu34 -jp9opLbDw4H!9ttWC9؏C?GCpou p73Iurv9isuY6nLvojan Pas}aMri7~?N Kynny0$NVOkQ L%aqtLeOlTM tuQusnuBa#t_OX8Fl-NGY[t lykpiN^ti-BwIOSW\ukiVYń^-4p<etJsuNAM/dbVVYs4duNd4i4e<tehd O4TyߔkalucAkgk@oi  UKk Pigak KiBvytPt0_xcO=7tkn4kq N p*mKA7Lis4Kieli2Pmku7e~v harmaLrki0RQSP xQ4S4TxcUxcJatkin@FwjotP npp.=u, ESC=Per H~=Hyvksy?=KyllӄEi сD, JokuGU=tp?فa5unuoli&cmi "mk 6Yh k@Fsis4sbJQ <ENTER> mrYteh.Q74n y1s seuraav : ->Ei VLINPPIN =Es  <-rASKELPALAUmTREd :inU4<PMARKA[xp=VAIHTO+''T<ǡ.= dG_pXlvirh)Akkua emo0kda.l%: R@>di 01@ka0$Bm4ࣙaPsrtpK p b`Sytke찋0xkotaasi@1?.ilaksQLKsKkanptNlaajv@9us@ikkPpxskeyty[i @9enѧi@(`l2n0_rBɳogadumALjI(KiPeQb? tyyppplɼn`D#eall~AMVlimui (L1/L2p.Mk 4  ROM-P@0R|ZotepercEm 4_Ыsip3sarNXr7`pN$stohja2K_ʠPusPnkohL¬1:\¬23O4KahvPck{)K}NOѯ?/נNoiCkeƀt`aᲫ3o$(j~oa)wά sҬԬߎ՝ oڟ_1ˬJ6mkrAso`ms:_ TmJay9lp?patPsnh7. J0t Gluo !prius-  9n,r4 >irjrfAFonP(ᯠNA: LS`	huY3 ; 3HX  paAhC'@H2koᩂi0g`qJBnA?o;C
CDA EFOI   DG?mp1 (Nо2@3 ..M.A.R.{T.p.Arviq$ (min): 30muSs7 .0%C`rosXplIsxyspiin*"$W#V32%unt@%KE 
)Serv?omoottP
)LukuUtuAvp%kPctotribFti2( pP%E@xpFpa v/e`K:e n .4!N UuaNVd! 0M6 PBo!yo8G9c: 6@eNGA6 Bma@y&C a o7?-S4(6Zon`Fokk aadan ONMNn$e95mysPs g>KU9@3LObZ3L,s Ъ đdai16:TiPJ@J5eoicPsidR.!
 un1nAkHPy0 	ve0kapahtum0@DPid"Vaa=iczG)a⺰rn QuickLock ̙Q hlu Px`%{r1A' R`Li"SQp,0ra '{-聍FI $ita.
sZd1`tnGt,@m&811T. Fg?uuQ &{TSp`Infr/apunwR࠵wŸh0}Lan1g(T{to2\in`  CD-- -l:bD~1BV 1ׂ234RiPG;j4AiotQ en D+ece(4g) -6Dllp  pek KYTTJNZ PSSAN'AN,ps ltVH..)aɐ |P`msily0bktur`Glsǧri`<4Ǳ7t0?p5q62P-ZP,Ap$ظ8LLAQm1aq7GPua zbML5D0"!pZT eurtPQ`(`(opX$"#g,qpBESC-np"p&B;nr4 5pB'v'QmCs en F10ث@iDaav: Up bU v /@㵠+NbT m1i;lmyspMultiBay+W.ﶼ (n$R) USB~d ~)!ZipEns'imm T0 KoleeljP=Vi@^P=K"`=eit 7dekU YKym ^aNump`<gVaiЍ Fn/Ctrlԫm!e1pEngd %(USMAUs0?spinlr5¥"BSd`a"dnN Zjafa SihaV8nsi1ǠsV@^olhyt Pz'kios!NRk#rEA1 1@uu0
P $RN5h{`*2\2-lQa"cV`a(0lk~i bp" optical d/ce d=AaV (ylosWc|BEtherИttu0D23VwToB  yg: !hИwork1{w/ D b`,>viliv]0>h AkkuoTAzH @ 0\joPlib= d P!Q^PDual-_ /O"!&¼b&O'o A */$.3( 2?,O6o7O0 O:o;O4vao? ?8:BG<F`K@AŘ aaХq
k`fD?E4F NP%QoIRSQ_M NWPRo[\oU`V_
]Yr[ %e0:]aky.h% ]  ogh{j2k@lpo pure q'gmnh
jo;lj3k!@Egu@vh
jx(y<l* ~$] ~"rސumerIn`  SpeedStep  techog?y Autoa	cYcgac?y Free`A RkۀGavu Pysi  (0e`0 ɐ0W@ :0F12:diP|Wtappi!koske``\15mmaK~ˏ  Ei mn Configurati@tord`teur  <F1=A@> Fichierfor0 mЅAffpage SauvrderНr _disque:la c: RQqr @ ''unU.hOtealps dfaupv duIgnomod1i`DquSш e l'in`capregͫa\ Scuess0d0qS%oJ0e sous`p@pon. ʴ ?priphpa sjȓID	'1sDAȖ|SmCpbf BIOS ȯ@gre Dsf!&ÖOKRtabl am 'usN Ou ܰĐqo ۰1a beriej solecn (qoPsBA@㲥EtaCA`0õ Acхang Chois{IndtÀmps gre0dprnjOez Appsuyԛtoua#poНu =Ser, ECHAP=AWl
Accepp0=OuUiNp QC, N'im1e( |= rЅN  U@zns fhe!mrAcle `uceqr 0 bri``z <ENTREE> ϧ#sui4   :z-> ou BARRE ESPACE/ = Pea	b-D
IE

precede\KTAB
C<gKMAJ+ wL 
%߳`rrp Il AsGsibfVЛcf U!s'Aprod@0end
Pw. Coa'D!01 ucan! @ emplace`PL'P}'TAre0 iPۆ&"s(d'accuei7l d0 rLr',itA$xD`biaЬPe0(w!pкq&0u`4R!/"O#f$2*2a wru FacM$1 TypRP6ce0Vp62a>Db.f?Ta1caa(L1/L2) VolbmoiVer"1ROM<mBERevtмŘNumroQ1FvidDQBpr!!clavG o -D PML$PH09R3T4VamovYۀ:=L~OM_^_
gaab\}"$inv(@D1$P6prii2(	te)hQnS pUrW?uZ4[w \g=/zOf`}/~cdo/{hB(ŘGeНde0' : C >etcruAD ie@ r"F P"`C'V /!`џR, r`Knroւ2c a,@D)!A! %LD)at6p tro PaC璏 #66^ /J"v`(GaD@0ȟ.篕 ͣ
?:@f 5fes-Avkl0D  o  ? Igno	i߲SA*ڐ Enrege`_tP TA޿1 (rap)Ӽ2 (co'et) uҢ0bVim( 4)p30iPc s .60% BvFļr;`l'h⼐ 5p1x:R'ǂ	c6nud'BvpJ-̃ѡLş] psupp0APibpQˏ: ID
$ex Rs S.M.A.R{.TPAban@ .# A s eќaP) %VfpLan񡗂saQ߂3߰A^ Mare n&!e<Pp˂5c(r.am?me, vSq
ad 4O0obligat2D  +dtD$| `s `-P<o)fhPNS tCPAÐ5   si0 C`K ,0œesrpk8`am0a`la pfor4. N5zJQ avouꂠ103ra s PC`zq*q 䰶O졹C$T }C1*s0 QuickLocksus 6J BA4L񵰌7ri P1S M1(aBXРPre cs*@'. L'r@-Lr' c draTG`QIpExigb|u)dNPQe %  rqa%all=K RsAs~1fil BoppD*PCD-Ex,GEG#R (009(0V(0X
@kpal
9":	 	c#)0ش"EDr. ScBdez RdeuxL(UTILISATEURPRINCIPAL),  '7`Lb!alors  d" Nz  ? 
p1#Q!qsrqfe 2celuDEordin5j. Au b<Pa?E>p@d
1"PN? 00Bm8Aet >pD :8: t+ҋa  aQ3dp ab" 5;`ѕ70B:,? appuy \` ECHAP. %a#aH@ЮQTzW':?', puiCbqrbQtcF10pׇTapgrmPB7Sf?WR4l%aaZ F_ranahOPNF%BQMu?ltiBay*|(0<|tv~(оoxxyzr) UnjUSBʚ#-(0ZipPrem D=iT:sbQua@Cin0Sixi Se yH@cNeuvcDMo num$G% Permscs Fn/CtrP,C rAngls>SoA) Pph$@opmugs AȠnc KechnaadeltSrCPzf hIߓ rn%ri#maadiid΂'Bid`apjT mmQ녙")V[l\jBsêp\ o r.uu2|bloc-nCG!񿑔a6{uc41B:pAЄppQu(A&ur)|ccueA,Ϭ&ozB Ethqt:&0ϴ䵰1p䵐2MTokRingO ߹ "*2#Id[aqupٲ@eP&r
 ďʯfP("|l@4/nre0C8/_AbsQ0U }]fDuu O_ub?ܟ ?_c-/ 
Ogn?ןѿO _?oe h{6~@zex @0_ _
p~
/O/[!pe 1 : C.r% ]ar`miі2Dg -J"3Rk!I&#n'* +  !+,}
34NumroBXroce|OpL Auto!ZqvTvlibKLegacy AmorQtc@^^E< RetardBz<exp^`p\) Dq0jGF12AvposfiX!1fux aPtB \׏a9cOun I ]`z01l\ <F1=Ai9>`nfqoZwHAemaBluJvKSalva0`l floppyM`umdHANP@{ttovNRiptina dNQoORPQifauQO@0Wi~sRuKIgnorS1ndİced esci E`\NRl'iHzp MsY[No[iN?`\ptup@icmzzapEssw5o?e]am  PratoOn0dedcc:fphjcA3Cvo[jslPvmK IDsXftKpwd=DALockJj`4rdSztC?@up;ofv BIOSt]vlAg*eaBvp8in'| m}IS HiXYwtrui CbPbSa5QfpleqH|OpsqiFtBUo roigidЙAt0aHP'Sq8l8(e lo-^چ Ava0^tЙL0uM;ÐDimRrH;aicaVH m 9o0 Щ{ gAЙv	v!gfo~oy'oPremi q siataMsweraX@Ru^  A=&, ESC=Annu`#`fAAit?e=SiáNp1\,8alt`8=ARuI Usachiavk freccHA$i`v8<aiu ap8 R` BY<INVIO> C    <4xO^'#e.Ҩ}eguҝSe  un: -> o SPAZIO = 
Hsuiss  <-BACK@CE@cYTKABCBoMAIUSC+HA= _p0!ɾErrf<g  Qun pu@\se <d~Si  v[u X80>SX. C['01 N 9u `R@ : ]oggiao LPPY`6P톗re¸`ͷTsaggaq8vb|"N  nbookQт6=aiespai`A@fY">roAatXq?Z2ՋLJriu`\|jJvKProdu Q!f> Nt  Tib8fVeloᅉSteppMisfcaqb(L1g/L2Bme @R CROM ?FamiglDPdnK 8ea8'1o0r<CցrollPCer_Bn$oĎ1O23O4haCnd7n ӎӎedSPh9Z@PJe(()?QH/I2:3:4:t: I/
I?! +"	O$h%D1!mfK<*0AondaaMuFNAso:1mgger  UW8U`EQre^r^/yrQ, in! <AfavPpui@'A:dPUr47A:2uҍaQono`\u~Cʨ9&; I
9UtQ\7t1 NFvPd@ 3Q&2Q-I25\o6yB@JWSe}b}vo!4^a XY?Z_@0K i2N^re?ap^Q AoT1_ (Rap)SW2 (Complet2X2tio ( h): 30tUc o .0%QYQbWtDWcar`S߀'hP S[TY_:s 7 q5gVaА  <1aܐ}A
fp- Fvmf YALTAssw cnrib i^gol@:panϰde@ mi S.M.A.R.T.HBu.sxqv `snuo!@ bۑRuFz!sÉhw`ÉaSi .v;0bѬz	dPӊa`͋v[04p,RA5ۀv2TSK.pc1BzAm2#	S/a}AvX4o,"  `LQpAfuēmv< ZSJezzaSmartCa t@)r 4 A?43b÷1ĄM!o0erdqd0JdatiN \EffjKiړsopin  car/	}qځ#vipa5L lڠ&`UOB LqT31`30i?ckLock``/spenPwB`#vR0mous
'M8Op`  0graB@ϲ?be ݥԛ e`  AF< .w,!Dikari 0lirRs`E,0.2blr!Fainf Qqb廑0L:-ROwp5l Puls'!.o GCD-c¥-SA -:4VaOB0 BOB`㴰s 4pp:su0t!Aֲ@0Q3a uBD:7e. DśH
`Ѐ 1PbbTz'UTENTERPRINCIPALE  r` 0a/
@a 07manwfu0Ro. AnppAV0Iqv'Rh ppA[p3!IJS	eP<fP@|QE(P>.P=l0|p/[u 1ad뇓,ڄpub F!R|0 sb?؆reLz. rq0wQ Av n1qT^$.;KPw,mOo ESC. 3'wrGdovO}rPnk ''Rpo1z e7F10.x }Z1aLqr!z 4&|ъ xtq\ItBP@p𞒻:ɱB MIiBayn) 
(#) 	&
|ADi USBxa:Su0ՠxkR:ZipRPrimoJq,]rz!.JwOv8z@BzDecr{o  Num'Al+4 Fn/Ctrl qTHVIngpe (USA)x2 IixPpupQ7o mplz BQlo@v"^c"(o
r/pl`&/c`C,zV@eeMoPEkSlg Bidp5ѝCapa0^ mem @q"u qAY`s |lT\2 N%Rparmpfenerg&`&  oyp1evic=! `v IBD	pa([CalAY/0K1s0Xo Eth0et+J2 51687278739e Token Ring7 <9<;=B?B3 Iaur  RӤpq6\ JK bIfN
OC`br~MNS  D!|"QaQR?X +^UpDu@Q[P/Q[ ?`TU/_dXZG1 h\^gmoab/lqe-Z_Ho/r_j?t _uznxy?r_s&anigpO wz|/0s`#2moV O/OmOo mϗA///OM[Y ap :0ro .# % ]xϧcomp#20Sҕ@N30  rɲ*!*5CG ᷿o1+bciϞO/m`u,b4UAutomaҐFloppybcU#legacy Aa
drVB!F#	Ra@(sec.).C vee6̐F12`ƒ, Ć4ӑ .N0uup <F1=Hjlp>rkiv SyVinfotPGP"p(s ]S pk:k`igu QGޘ؏0!stll frnlܣ۰! n`=ar_d Annua n. och@sluA  @n"A؋؊ Sker dՂ
trsl0  Ka2`rct-En ssv(-IDzAfԠtdytd fr & BIOS3??byggd  0>i habrikP
:Verktyg KRrc v 2}I Sԃvt0 21HDD Ak	6
0Mus f@~t Vlj"rkmo  nedt`%tl{|zzTrypҠ0friu g@ nqu& st=, ESC?=AvbryFtA@(p0!a*", V=OMer pv  pil$ʚPa 0)yAt5<RETUR> omtt2	. elj eer' } [(: -> @}*BLANKSTEG = N 	  <-- F?rege).nTAB.f >LKIFT+30싁= Fn67``=sfelPt gr V k }t# hE`(< uppstodGd*;en. oFelkp@01A^innsg<ppڱ>pla`Ątm krv
AI<@pmޠ flys t  U-d@Mr/ ex£OF;p"5tid#ig?@A2MKkl0T  kNd,1}  P5, typ*VhastigHVխg/Ca-Prlek (L1/L2) MB`SZ ROMP "\familjtkp,͓\'Us1?nummnp!deAog^1$b[yrB}_p!| 1.:dd2$eC3gC4h!Aa+d%U-k dcmCfc ">ochgqf_
l,v@pe+ (b)gf1^rf{3h|i\rSekv QrgVar! DeD3Qް  Oneh"Er+skap "/W- aiבNkbq+TLA:@ށ< KQ3=h	iIrNoS҉skyddad Aa
g$@ o!ڑ= # u᧖?0#ig ?w86
T1nabbPzb IfnOPzUP}kPad kXd (`): 330(<p=S40%Ta<ld@ Os5PppN1vrPD&a@t:A: <8)Okp⢮Sቁ<#ervo-ױLr<Np*B=V6p(ttribut: ID .`BA d grrH1S.M.A.R.T.-E GammAGNI7 ifin: 
춾 L T<ʂԶEA "
*DIvA?lika mp) `3EPt  hf>O&inؐȿƲ  's =w fun
3 s ˤQAv oGm  `@
hQ
tsQЯa "s<a`mlo@. g ax1glm¬/tjrqhelse0)reSsu1,iru @
pfeYQuick1 "telge LJGb%1m
" Hfk mjligqg3rbQk"-%  `ѢAekodihg`>aצb#liP]a" t0)K F¡om4cPiU ppfbP`6xHPTrdtT napp ICD- ]0Z r!Hrdђ pBfRf34 Huvup "v: DPÐh\t$d Deqޠl/@ANV-%HUVUDWՁ0ױtf Ipe  t g.c 0`A͑% DDild fr@!K5
 hka@uh!  lQp׀PAD n%癀Ơ
. &-kbeEf0sepm B=v֡)*d L .0%   D:-5* 7R. R䃞V&DIQ3'&' sed
tA#aDp7$hC*t a:DI!$s830FӱySw 2b:zUMiBayuV
c5 (dqRz7sSBƒa;'7`;_ Zip-3cFa! FjQtQtto?N?T@Num QVx`Fn-/Ctrl$ Gb 3EQlskt (USA5`kd\a;AFKdskrm]stroI!kn$IaIwfbbel0@TZ@	eone FlkcO!  YSErЎr5-bAgg9spєmhkYFS,dpti{ca0evic *v1r=XrutfpW4cv@MVexp c梅ed[/\ Ethp!qEW_z^a`|aa ~cToRQa{fc{f_eNCOgl_iIn_kUnik Ont2Tqvzu>v0tus wxzsz S$?v9}Kalib{/} Ȁkd~BRCFODual SOg~OOe /Sv~@_eO?ϏD&sq~HandtagX~/@/eV9Amo0I
q:~ ϰO/Oy :PϾ￤[ e0g : La	r 9.# w% ]3-] lar2upǛ{%3ZO̬ЂV* F~ 
$  !]4txQAuto8PFRbrc egacy FreeBBNb!|J4sadapR2lp=drj4assnabb~ (sek.0;,F1 oDNgGBdStyra!>PGpJgJqte>n`Ee'e `@ pOYslaan Configu0o  Vanaf `)v?TQ4ndaardAMԏ s3cWij7zigne ; 
rogramma (p pSetup zq@r w)	?R svesilBheerswachtwoAE?0ux	 AppPL'atbg$ ID's+')`!pSm C-kO)uv@ BIOSoAbouwdeP/7sa4Fabrieksugz1`xt(AccuC tex`1elecP a%Wes>zelft 1-schijkfe!jipHAc!3ܯ()*%>w D  bwR-?'% wpgn Gea2cqDalDX'em\@%2&4R-grijsgewmaa`FvelpH	Wes7
48\:uk*PQXg=S4, ESC=Annu L"p?DX@?O@0=%e/@a?JaCNee DfQiP, 1AA=Mp`z@Hulp/pijltj=p ruij`dP&juip0nukesuz@Kark<ENTER> ind0=Jz28bep/volI`ѡ=28  :  -> of SPATIEBALK =P#<-TBACK UCEUVorsigLVTAB"XQc7vHIFT+`UZpXS7K= ) @(tC{Y D^@t&7fou De`L1k0niwgeD3 Fpcp`reqtijs6en. AfcoF01c@a>is0C_u we0@petvoe]reK% ẃ% dbasK=d it n not ok-pc/ݐ' `Fils*lbAg ]be Ni#gd?f_gxh2b%/t0qv#`dt eN5qmhq3ypPIrocessSnelSsS0}p9poM Om@e (L1/L2GucapacpFi ROM-Revis  HerzwienBrgav36bRS  Lmm>a-%q50viOdeok V8uQptrop <n /P>-1I1o1213o141p`} f*-#L<ϝn reOfIn@2istgItifi)cij36eXp[(0Pdzw)Od PdЕϮdP@dؘOh*p ϡSB(/SecupiGB(=Loop: At}dt apsu egewK3 Pi=be*6if M dQ A:Rg-  /LJvG$eǢdwoffbG=an˶!je
d@A2	AȮ0jo 
gt>ǊP/##eou,LA`@Kzwilt?		(a5F?P HN
Z,*TQ1 (~)2 #(UJ0+)0* Brkrrw (~.): 30@0KPꔀ.];0%Ptoo`"p{;n hobroJ:,mdevnbAQccCbcC vo-leesec,¢dRri*v`nJk:Uivbije S.M.A.R.T.-Lbaf`xJ.(udXkieuw_XAlХBloPN+ A0?E#ݷ0jdPl!f@k11# Nbo ,ЪP_gls X Vo▀`LOis !bP>sl@;u `Fakelt, pqq05e j!2Q+d  lZ,SLtC-Ёb!>,  d 633a|eksؐCugz)eA g`^ 0erlo2hZori5* !bУAlwf"ohoudHi> s+Pe+ 0۔A ݖ:8;b~ DF9g#9L TǌAMmKF;B16bS?$ppP$ /$g!j',2r>0eb0r. (`L"s0eTk@traak0j!T11Rb l>pp>ʲ0rpau0fraroodO ParOp&DހJdloo@etw KnOS Cd-r>XVNa'VDYPYЕYPHoofdG LF U2Z'viaT0Lnĉ0,ii1bzow@9HOOFD-GEBRUIKERScaY  permaYnA0K S pFe  2waC`a Sp fypka{ppfcomp kg_fSds1!e Lt ?h3Z bWPrrlSNXs. Ae)adb#,$CIan$#lijk2@Tbs	, uAESC-. O@&!@QEfb R$/'b'ptytykqTF10pPTꊠ  7~]C'0Sb$cfvc
Nel 61  MultiBay`Yښf (as)3bЛ U'SB-GcUh 0p- EBݠ<wea!VQ2VaZesPZ+PANP tus Num >Fn/CtrlCssae}<
Ǖ`
enhM3@sapp0Q9O+!qu beprEmtl00n߯BijVFPpo-10 !HkQ&ذd	o@QlpPv1gEqubdKP
nti@-=uKpSؠPN$q e2! `0ieEQ (bѡ))?ZaEt@SZOhǐ[Ohǐ\Od TBR!%==@RSZ2.3 Upk00Itc@cccu7 ܬ1 SûaGekali oKB@pVual 3o u3/VĚBA?_X3 Hg@pvormn@o߼Ler-MUE-3/  R
3/
	  [qp 1O : B҇oor1I.% ]A8OfЖtooD
2nt53SNt  !#1*'$  'zO*wFMod z@:gacy6ӈafSadapq66ѪpJr(0|sec.)p(`cpop-upr>s;OD <yF12 i3P4)pbb  cursorbtur~a@EasyPo-=G9Gw  Rs[^̃ZbgA<viSETUPj <F1=wv> t@C;VXeG?Ɋւ?\܂;t<s@<fB?Nɕۑ  ݒCAoBCAC県FEĂDH&Ff>H`>gD  Ho׎ɞ<Ke?D%FNύXɏ_I  BPEPAAPO̿Ԃ@Fܫ@<e CSPlOIPDegUGoST<LXLǗ҃p?@<h[̃Ld[]'] Co ?X 	Z`@\̗L/?N3Fe?IDG?IDc h ?uHN [f\c#RA@F͍폜$FSmCߟܰ`l BIOSl ߰@lF]za^p `^pE]LRX<;c@<1?o<e̒  I$Vvw&Fn[Caa>e?g wIv`?ylz{Ac&Fv ?A<rwRA; ڍCt;\XAAk7߂awuK;@{@<{ObtBv!]φ~/sDFu@<j{ Nc`ȋUbbfL[I_ 6=wAEsc= Z8;@}Ēso3j/0=͂|  PA<ɓC>;J@<\{ gpIj!<Gڂ0| ?hg]k[Eq]ՀPF0ȉ,A̠;&T->j?y@<Pao[ = E]  <-j[BackSpace]R;[Tab!A[Shift]+Rϫh6!APmF[E  wG[  <vnył@F@yrfTV 01  MuV JъɂACOs!_`LڑAKv Jfb ZO Ax(x mathg jMEUh"ȂAlϵ22eŐ@ļ?!Hɰޯ   ۾ txf˽ïݸ  iL1/L2=gR
OMXrW{̧r An޼ޮ݇ʼٔԍ  ޵ѷѺ۰ׂް"ޯ} ް	֓t  ʏޯؠӃ234 ӥm
lݞ	֍'։Eʱ ͖ʵŰc(Â)v'
34/M ߗ֦Pe?wYJ;_x:ⷈƁAgH Eu"W AׂĎK퀹cC/Hp쐬wvhA:P݉ cgHK3C}H	oH  F' 	e֎~ rO 
cB`LLN  EOB FHC#W K3O KXXT/OVgUGX;To/|H}@{1iN ?g={2iS%3`=.M.A.R.T= \zsԁij: 30Yg}' .60% ) OK z1{ {{~;N,f;:*}')/mRQ/e3T@<{3ǂ(4h Z0T|xaIֹsFIDp&.`bM: - .=4@̉[V> _ðc'PcP؀{|೴A \BPqr @x\EF@Gv"	߼$P%\uob?\c8r@d ysuPX}2Z1hii 8Q@StuEQ C]Fɂ!:*PYꍇjei\bqSPG!^  YƂ` 6Z1-[dbvS: A?Dy{~A@<?S$Nhku7BlTA@h`<kGhu{#J/}ElV@q~TQOhA !%NA2-ی?E Z>P ]`TQ1@xeċNp8Pvq V@WA9 ?ԊOtDG
uBȯܰB% CD-R $ȃ35"t71234V`k} ^U:`kUˎjibpQe7l@ x(Q  a p`t@b]kPGAT`b}q9F|lb	`k'i`l}$ѹ\\͎ǐ3R@s0^]S#ۊb9 2b !bO]@bҿE&"u7d PY31c_p_PŠ^PܓpE`࿕ۏ؊ԓ ł|´͗Lĵ㼂`19A
s࿂ql`[ӔCMaAB{~[Esc]Apyb9yȍ~ -#"fytB̗DriveLock @bϗtBHp[F10D÷C41cJp   E%qj-xutq)ild}+`%: m*bTu!o DxړQ7b WO kxPXفiaa')aa'USBPHZ"XPpgޱ Zipv1_Ԗ 23U456758910΁<Num1cY Fn/CtrlR̟ؑ Gp`o{  p (USA)>|_uBfCXKV8ᒴD"v C ¢gP !% j7}z`kr"IoN̂ C@W} fo ^CY| NOauڑ͏̧0MS#Q؃28 Ngȓdcoptical device dOݏDEtherneC 	?
	zgPN  1O23$ lBAN
kpk
 ݆j ID b _v*N  !d g O*?Љ!"#_O$o%1f  W2 گ'#*?+& ,-J)v_0n#23 &?5_(w)8#: ;&=8J)nnA 8n#?C_D&E9v)MEU5IG#K L&ONmOJdQCO MTPV_R1P|bv1 : [d .]@X% ]ao\.׮x^2\A])\a]a_v
3\#])\fcHc
hVe*kFe k 7-/mHPoYjq􍒮T iopIntel  SpeedStep technology_  WtQP  _@4ް Ӱ S`j \x(b) @F12~ԁiCb6n * ^`pbBǑ߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz|?}_~~ ` a b c d e f g, =  N    >     	 
 Z   t  
    T    ҡ                    \     ) *   - .  / 0   $ %   & '     []~ Np~! p~( p~ H[t[["[([$/[P5[|;[A[G[ NO[,T@ЂU0P0~<BB<~>"~ب~0`8l~v x|vƖ||~p0p~"  "~0   = ~ =$$$<   DDD ~O~aƄe  i  o䔕 u  y   n~A0 E~  In~O ~U   Y~N~ ~ `' ^    ~y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:?5-_V<>~( ) +䱩#'?
ߨ({[)|+}][{]}_'@ (#^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] } &12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {V-+*'߇(aιs$|  9+'()+'*ȱ!ʳ0íb?
\()| /Џoҏӭҫ'5 -=
^~+]}@`)  ';+(:*[{s\_}\|    \[挐}X[&(PP\[PU감h}֐([FP襮PPzP	
  9~:~;Ó?~@~A~B~C~8 1 [ _[\[^[la[_c[CPJb[S1]@~Q~R~US~T~U~V~]2  W~X~Z h~O 6 	TB*:&`[~  ]^~_`~a~bX0 V Z[
[[		(|	A iA( 
t
k~lmn 4 :~ 044~ 44 3 	[V 44PHV F10 Setup Imageq_SETUP  ~򢰄" 5 644p44p̺44CPR6P
!!
 
`V !$UJ#~s д'~~ת~t#V ~#V (~!~а#U~~~~U~~~U~oTp2 W4 #V 4U4444U4444463 \ 64 444~	
0Pp;*E!;+	~$" c"" "" BC2 "0A	V TT5TTT 2 |0ATCK-K@LMNP/QMR)0JE0AV ~|3הs2"P
G NH  m4G I] I  744U
44	484U94:4;4<4U=4>4?4@4A4-P
[V TIT#W  TTTU!T&TjT3TUBTiTnT+T0T1T/2()TG~$0Jk#.S PkG,~d Tc` Ttr 7 *u' K w0JR0tNUdr@UPUxPUx5~z~{~  U}~U~P0tWT H =UXpbphp|pUpppp_= FU^ռ԰W=$040N0UZ0p000ն000T<V\Up5U,N\Utpppp=U0<BUf԰M఑ @0B0Ud0000}0=@0U`0000=!<JZjzȰް	="p>pPphpppppp
=:dx𝐪=.pNprppRpppp_=2RUrM
 Rr"M
@0L0Uf000000=*pHpVppp4p4ppp=.R~ޚp6pXptpppppppppppp p6p^p~pptp
 p4f暰>J`jư$ bn|𹊪tȪ=p"p0p>pJp\plpppp 0T0|0000=(VjT`jtÀÒæĪ@$*28@FLT\bhƀƒƜƤƪ 0$0.04080@0F0Z0d0r0v0z0̌0̒0̘J0̠0̦00i0!0 PbzђѪ p@pdpԈpԶpp0\0֊0ֲ00 X׆׮ְ @0T0ق0٪00 ! °Jh~ڠj԰"U6HZjܕ|܎ܠܡ
#ppp<p>pBpFpJpNpRpVpZ4rttx|ppppঢppapjppp $p>p\pp谚pp %0L0t000j000&@p8pRpfp숪pppp' °Nv~ʰJ(0<0UN0V0n0~0U0000S)TfUS*`5+pppp,,)-~UM.p@pUNpZpvpp՜ppp
/T 2FZUtS*00\0v0U0000M01pjppppoǥap
2	^						U3Npղ4 

T
r
J


!
M
05`UΰM6^U°Uܰ57U,J~54(8 0Ո0009Tppppjpp:@`԰); H`!xj< 0 00 F0 \0 j0 |0 0 0 ܦ0  ="H"r""ư""> p$\p$p$Țp$p$4? %fJ%%%e%%%%&@T(j(~((U((((U((°(ư(Uʰ(ΰ(Ұ(ְ(M(A 0-$0-U40-J0-j0-0-0-0-0-$0-!0-0-iϣ
B222TT2!v222a2 C 5p55İ55D07f0707Ԧ07E p8p8Цp8Fp9p9p9G@p:xp:p:p:0H ;;;,I <<< J=n===ذ=F="Kp?atp?Up?p?p?p?1p?ްL 0B80BL0Bl0Bv0BoC0B0B%0Bj0B0B0BM@J0JBJfJzJJJܰJJ$N@0Mf0Mp0M0M0M0M0M0MO pO@pO\pOpOpOʚpOpOP pQ>pQ`pQlpQpQpQpQpQpQIQS(S!6SURShSSS5SS R VU4VDV`VnVUtVV°VVSS0YJ0Yt0YՔ0Y0Y0YTTZ6ZjZZ5ZZU\%j\~\J\U\ư\ڰ\\+Vp_*q_p_UVp_hp_p_p_Up_p_p_p_S
W °bHblbUb°bְbbMbXd6dUJdfddd5ddY0gaS/OoǥaS!K20gT0gx0g0g4qg0g0gZ0nT0nKr0n0n0n0n0noV0n [o.0qN0q\0ql0q!0q0q0q0q0q\ 0tB0tT0tdT0tt0t0t0t50tpv] v$v,v0va4v8vBv^vvvvv*^zNpzpzᵺpzpz"_h0|p0|0|0|0|0|
` p~Lp~xp~p~p~p~ aǺ00.*0H0T0b10U000ոʰްbT FlհcTVp5d XxeĤT!Ÿʰ찈Se@4BUP\djUrzUư!-䰋갋 f 2JbJjt~!ΔΜmϺj䰐gŕ,XtaҐذ򦰖h(p<pRphpppiD000j@000k@000lh000m@000n 000j000o RR!gv՚pT!w0 0B0%X0x0eC0/D⮴F00!000q 2N`𬔪r@^԰氯s=:PxȚt_:J\aRլuT p2p8pDpURprppp5pp v0U00J0Z0x0U0000M0w qHUrx[,Z°"y]FafpRҰ_ిSz@p4pRpUhpÀpØpðp5pp{ U\ŊŠź5 |U,FdǊe!g }@gi/j!0U00P0r0ʘ0ʕ000anU~C,pFp\pUrpіpѸppѭpC2RDerRnUӢӸM  p"pU2pPplpלؕؾ̰%w⒰aءxLnێ۴Q a3Z݌5
pU2pZphpxpUp߶pppS0 yz%e q0 0B0R0v0000.@耰j̰0@0h00j000 0>0N0\0p0000f0 ˰ q0o@u厥@^0/v|$ް/0K G1)2")*a3RxaUְS RpUS@j5& ypՊpppTzS  v  M 
@0n0՞000TXve  BJ000N0i`0000eCؘ0-"a4>%Hht|ΰ phppjppp" 0J0r00j000 @z0D0n00j000@`0h0v00j000 0>0F0Z0h0000ܦ0@zHd~jư$@0t000Қ00@uXn @!!Z!!*"U6"L"`"z"U""""M" %@%Ub%%%%M%;'X'5'' 0)Uj0)0)0)0)S *N*|*5**2@0,0,0,Gk0,0,T (02T02r0202՚020202 T 04f04~040450404 5U25P5`5~5U5555M5&Q8b8U8889M8@l0;^0;Ut0;0;0;0;U0;0;0;0;pu0;0;T q>X>|>>Mt?@up@hp@5p@p@@A~AAAe}ܚAA C^CCCC
IrpE,pEa<pE%XpEhpEpEpEpEpEpEpE 0I80IN0If0I0I0I0I(@.0K0K0K0K@pLVpLnpL0M0M0M 0NL0NzR0N0N剸0N0NM0N@uPdPUPPPPUȰPаPذPPUPPPPS pTpT>pTUXpT`pThpTxpTUpTpTpTpT pW-pW2pW<pW%JpWfTpWnpWpWpWipWpW\f0]z0]0]0]0] ^L^h^^^Ҕ^^@O`j```(@0b0b0b0b"@pcpcpcpczddddxeVeneeeZee,(gU:gTgdgzgQga<ggggpk	B4l/^pk~pkpkpkTpka{pkpkpk5pkpk |psUBpsbpspsps5psps@zpuUTpu^puvpupuլpupupuT wDwXwtwUwwڰwwS yPy\yUryyyyy&0|80|F0|h0|0|j0|0|0|"~<~N~!r~x~~а~~ pTp|pppp
 0B0p0j000 olra#@h4D`|jذ (0N0l0000&@O opdppJpq e{o-./Ρ{5UFb5 Vzat𖬪UØ p:pRpUdpzpppMp΀@UnM XFU\jvUUM4 v՚4T>Tڰ찣B$ 0d0v0j000WJ<Pa`vj ԀEp4pNpXpfpxppp (`찭@0l0000@jҰްeO찰TE2^RaQQ𲢡R1eSTCUU2<JjU-0iZ.040Z0v00j000 Z`ƚP*nM԰r5ְ (UhĖS(pƌpƺpMp@ܰx5ް U<`ȂȚվT|0F0V0n0ˡ0iaaj0˶000
DOlmm<npT0ђp0ц0q0Ѥ0Ѯ0Ѹ0j000@L^ք֞jȰuHn؂pٞpٰppp >Rnڔڨ  0020N0v0݀0ݜ0ݪ0ݰ0ݾ0j000@h@b|ர@pPpnppp֚pp(@Kp|ppppp 00000 T2FU\p~UMhpPpUfp|ppp5ppU\vذ
TuP~a/Ooh0a!
>Dj|*Ȱ֫C0.0J0^0n00t0000  ;6fvju0 H0 f0 0 0 0 0 0 0 0  ; *@\6phpqp5pp* Zp\pppBpjppp Z	~			Ԓ			ek4Ph~̰র@Pz }jаh0d0t00040eO0@hU@bM@ Ṵ԰ܰT@<VUbhxUkppY.peZBpVRpdpqppMpu0"N0"r0"0"  MU&p#Lp#tp#p#p#p#M5H0%l0%D@0%}0%M^&&ް&"Mb'''&WMf(((_*Mn))})2Mr****MUT+x++԰+M+.'0-U6iHiZiji|i0-0-!0-0-0-0-	Mk,0/ϋmQV1p~00000q000 
Mp86p8Pp8|p8p8p8p8(MNp:p:jp:p:p:1;^;;;;;;
M:=R=z===== %?6?X?v??????@M B6BZBtBB°BB  %D0D^DlDrDDְD
 >FHFrFjFİFF 9pHdpHpHpH1IvIIFI -Ja8DJUNJbJvJJUJJJJ1K %0N,0NN0Nr0N0N0NК0N0N1pPhjpPpPpP -QLQjQQjQְQQ$@>jSSİS #T8T!A/!A8LTx1UTښTT Ep[Tp[zp[p[p[p[$@%0]h0]0]t]0]t] >p_Pp_`p_@4p_p_p_̚p_p_ NaDa^ataajaaaB0d60dX0db0dj0dp0dx0d|0d0d0d0d0d1pgXpgpgZpgpg C7Bhzhhh ! >pjPpjepjjpjpjpj$"@Cllll2ll#<tU"n2nJn\nUpnnnnMn> nְnMn$@rr5rr%#sՂsss&T U0u~0u0u0uS')pvNpv~pvpvpvpvpv(1xnxRxxxxUxxxxxxx)T;||6|P|UX|b|p||ռ|ް||* 1"Zp:eJ%`hRn!!ΰM+:պ,T'p@p^p|pUppppS*-%氈_.MVMа/o540%51 `52oUl53 kTRt4@6dU&<Nlez1ZКto45!!5T %pb0!(pBpU`prppp5pp06#0U~0000M07@:LUb8T >pNprppUppppS9VU5谣: -0UP0v000000
;TQp8pdppղppp<T kpVpzpp5pp&=@0500> E0Uv0000U0000S?S4BUPjոڰ@T@:pDp`pp5ppA80UT0t000500B >0b000C)p>pᣯUVWTYRpdpp5ppD8U.X~eES0H0d0x0000V0FC`2U\jGT UXvŦUΰްSH d"S@.PUnǪqȕITʊ!!,J(̐J̨̺eSK EB~5$L@0%P0b0anr0nU0Ў0Ш0ж0000MT@B6BXUjӘSN 90~0֨0M0O kpTphpרppPT@Ptؤة؀wQ*Vۂ0zl~ے۠jۦۮ0zۺ°ݰذRT;pp*pNp5dpp #pIp-pap2%pूfYp!!(SK)? 1MTB>U^~U 0h@.000(V@Rppp8W4uppX#0500Y `0500.Ze0500"[K0U^00000 \ 6L`ʨ! I]Q4%1FD3b4/5zM !!ښ^8p8pPpxpppp_'p Hp Rp jp p p p p p p  ` 1040H0j000j000lP0a -0T0r02u50aBU000q0b*p	Hp	bfp	4R5p	xv #p	p	p	p	c0P0x0j000dq
N
|

ؚ

*e `FjU@YȰ԰fTB060D0R0U^0r000ռ400gT&p2pPpnpUppppSh)BZrCY=oYai@ H bJ |   5԰  jB0#D0#!#X0#x#*0$0$0$0$a`M0$ k(p&6p&URp&lp&p&p&Up&p&p&p&Kl0)D0)UR0)j0)v0)p)-p)6@] /0)U0)0)0)0)Sm K0-Z0-0-e0-0-!inq.f...2..%ko01UN01\010101M01p@#2.2I<2anL2n\2Un2222U2222222qT E7T7x77577r а9UB9f9v99599sq;U^;;;;eȰ;ְ;;;t ">wD>@ >`>h>je=n>z*@v>~>q?>U>>>ΰ>ڰ>>>u d0D*0DA=Dމ=-F$0Dab0Dp0DI!0D!i0D0D0D0D0vT $JJJJ5ΰJJwpLULpLjpLpLpL5pLpL<xpN5pNpNylpO5pOpOz@pPppPpPpP{ $QQİQ|T "RnRRRS}>S2SRSUpSSSSjaSS~V@VpY0a*UhVtVVV°V̰Vo˕Y>p^"Jp^.p^6p^!iH0iUX0i<p^Dp^Vp^Unp^p^p^p^Mp^pb\pbUpbpbpbpbMpb pdPpdUdpdpdpdpd5pdpdfUVfnfff԰fڰffT@hph|hhUhhhhMh@pk8pkUTpkxpkpkpk5pkpk mUm:mbmmպm̰mmT ZoZooo5oo ZqU`qq̰qq@30s`B0sL0s\0sl0s0s0s0s0s0s0s pvFpvdpvpvpvpvjpvpvpv Zxbxxxڦx&pzRpznpzpzpzʴ{pz$ ܰ|x| |ai/Ooǻai!aU||ΰ||SDp>pbpppapp а:bvF -0%&0UL0000500 U*:vU԰䰊S>0&0*0a+.020:0X0v0000( $pppp
@pʰܰ p2pNpxpppRq1pvppIp!ѦpѶppppT ԰.>Nc^n*Ұ !UzưS$ l0p00M0 vp^ppppepp
 Bbp|=𠤪ªj@ Ъ0B\xT𥖥H!"Z|!,g=P &pFphpppʚppdpNpxpppp@0`00000" !l𳼚
dpTp~pppp0t0000!}@6LteW!SL4n𸉪eY/Z옴\ J[ 080>0Ub0n0x00ը000TPĀĖ5԰"pUFp^ptpƐpUppppS
 :TpUȚȴ5  pUFp|pːpˮpոp˾ppT&HfzUͰʰM@10<0UD0j0А0О0500 @pUJprpҔpҶpppp(T $ԐڰM 0$0U,0:0F0R0Ub0v0ր0֎0U0֪0ּ00500
>pU.p@pRphpUpڜpڼppMp 0*0U<0N0`0v0U0ݪ000  -!}/!&Nvߜ&" *xaĥap\ppppjpppPNf~뤪&pZphpzppp着ppppªpppp0f0~0ʴ00.TppppMpPJU\z4pJ%@p2pBpRpbphp|jpppj6CI|4T0 0 0 0 S* <ppppppT0&0B0h00!?00ª000000000 )&8DLXtJְE#@LpeGp%H*p4p<p.^Rppapp5pp9U@\5kUFnM"À1z5԰ @3UZSŀPpfpp5ppUj5Pd|*5@#0B0eYL0K[lto]00000.$PnP[%&[     l      [Z V[   QqLGB=   0{+&!	!$05/29/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
 'p~}P >""'D Tut


t݈
tt

"
#
=t
@t0`#~ *0{TaD>0-t`D@t#(tbD	T
'T?DDD Tw%t5n !t
t
t
Duү"!"#$$"#!P%d%%Ô
@$$p#"2` {$ЂЃ%&u u '2 Txu. B/!+>$4 `Op" !{ #{#
"  ".)z|f}~ }𣮂)D` ) Cp`t   +,-.
..-$-P2_,,+$+8 )t" ~}|}K}4"{ z}r79tun9d=tA;<} |u<t1=8L>$2%A'%($('&":A&B&CA&%ӔP&`ӔP%/3d@C?$d	p?Cr7%u( %@B&u*I)**)p)N`.(('$'8P2CT;b;%&$4CA!D @((sHZPePβQxRܲD P PACS:"TqTt~ 332U']p`LIDU=A#T.SYT#߭"ֲD!+[?cǲTT"uPu4"%$;4P2tʎ"0"
pKp"0"_d   45t(t
5"+c+/ÞP.%c@ Sp`c߀͹cm@^{ +u.I-`..08-N`I b,f {
c,Kg}3hBsie,`Cdd`"`7t
8c" s?t_uvwxyz|?}}	2x-{| ;_   01/0A02/ 04 kDi_amond3qHewlett-Packar1mpany.P0a0"x#T*T0	T@t/{3"x0x`v$ÔdPx>0#1~"};TT?"2"2zx wx)} P;uu u	``2`2@)aT$3TD ȃ@VF @c~`T?0	T`2`T%`@`2dłŃ瀾x!T.xT?T/TDx!TDxD@x``p
00/dp*tP M0 T%%0TO~Ps.!O?T"¯r_()B)J()(@=BbjR PMqM}xtPTa"C#x7$0./R//$.Ôп.P	107xTxDV')R~SM~0`ӧx 0p"xD¯./uvү5./"xt0
}
~q3}xXvvuu˲0P0Dࡸuu!B
L}ܠ!ү0Vm ~xvE``
$`$p
?షxЊe
'xx txDE SxxxxaD@5 n}upgp`p{A}d`3 &xNI@L,x%tx}D7 a Pa0xtxtyuu V0␻}^O}eCsQ]}lO-½,/ƴxeD0 ѠD 1^x_RcD%xfTP`P'p# * .}cf[3n-0i;IƑr	@0P}TϾ`ɉ"10gx a	00P0}epŎѽ3)"? b P¯^u|` w$T`#BRn045\NQʄХد)u)$4F^Kࠞ)}.,)(Ô@a*"x/)(`#䔽x0%xvՒ"x)(*a00}_+,`-  "x_}408w}71=" }9`5*1x%~x=0T4d~` 	D#Q"00x`)xc`xd @p@K0S(;TB(x0¯0*09P4.(0H(`xU*	( xTx k! (AT~KCPF@< y(P>֑
0Tdp(D !+P( @5?p WQ"6p@Ô2@YD0xx78Rx00`6+06m0
 Tߠ|`	p1[on٠  `a76ѝ нᛴ{x,Kxt;xx,!p0x*-tp+Z`KAY^ҚR xT0T?d?p_p
0aT`ad`
u)?T d`pUpD"TӔ @
"T?Mp;T?`d`}*}W)pKz0$"@p`
T1## %@=~'~W)33TT?O)` 7  . )/_7 ""G`rux_?N堕DF33ʰ333PE<ЂЃ2
2x_p`_ 	Baa$3ٸ5L 3*A3Mx-2+_NMNx*NMx+<QM0Kx"b=!==9qeL`
MN12A3K3K0=`C_F`C`CP`C4N/~522-"F	2:RxZ2YA3SNSmSQ4>@R`S5t2:T  3^A3UIUQ}@T1JUJKV 3cA3WIWTW3PRE@V1JWNS2A}3 A}9 !.A}  uuҌВ">HV_W47vjW0Vx'
q[0d`!0&-5-\P@'`2`=`HpQxX"`1\6uuuuҸbuu0buubYˏO$rWƨpN`0T`
0370Ѝ  q"[| }(xX"(`E(p
kAnk(  ()(x)(0(p)))((xZ))"*+д[T0 7/at
at&Ppd `g.堪2@t%x<6XjҌ(px#k響,-mp,l`
,-xd@vt j/Dtpʅ+*,-"uPu4e" Wx^!`yWxtwOx7vpx87t
1"ucd"xe!px,"". -BtF)DG qs=w1v8zrAp#$W@n23{;"xy> !u
Cֻ9./0H*5,7_SU4cU~TVV~OPK|QZYQP}d%]	`
e(j[&b'gi\af6h+l:@<>L|RX>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L R Z  a  " ! * 2 1 : A I J Q Y     )   3TP g d   pqkli/ur}z'tw l k i h Ju s r p  l t z q { y m Zc v       
  	 x   ~    Y Jw | # qww ~~   @"Gux4"01WڱD x2t 1tI%W0% %xjvv %xjZ> HRxl"# $ $ !23x1 	ү  ¿0 _3#!PK0ؿ3"0!PMx3>
2rWZ"xkF`g7rp"" %	x30#0$<T`д""xl `fp
0!#atI.4}xl$3z 
PHp`$HtN ylDˀxhv"xx0	Dc0Uy$Ӕ@TxxywqD"0 4xfxwU` еDT0
ϠaqP" xnxoxv"xnxwxoxyxv "xqxprP
rWypxq?f`Ӏ0SVxqX` grW1wB".0&u)P/)S@&*@&"*@\`~"x* \t %*u o-~-PtU-,-b,R-h-o8++ѓ,U-`RiU,`  +u%*$U,00u,,u,0,*+P,0 Pd0`Ô@"0  	0
0 		"0 H`$<T"   Rj1 apy1ÔP2~f0/ _\%110r0//}1Ӕ@t -A2nO2q.¯	 .x. xho`x\T`)Tgxgdx`yR"33"x4!,r3TOp0 0@0 
0 ]#000+1d'`8`2`,`&:` ;`5`M`A`P+3{ z y5"CPNH0 =5`<}DPA5d`5dw`
`
`
	`5

5a"3!54Y4#P "l"8̓6 "63qْ9S6|09}= ~ } | 6$ ONMLPO:_|b_^]\T:=T0f: 9+`:80:808u6$`47D   6"67?89x80䓵6789t:#UI$%I$%I$%6d'p/ $%0q++cҔ$06$):Z$	%z-;E/U
/f-1E//UR-2E//>-U3E//*-BE/U/-E//-:I #=8@ $ t8 78v0	0+
  +u7 08370 t08k2;
;8?;E:
<u8F6:T<>=%:
K>>;
:<u_8# 2;m:|7pu8J2;u7Q0Nu7!I:{< u8| + 	6u71:yF{j"GG:J<u8yu7 "GG;8Ӕ@
8b.ߏ88p!77
0
6%u8@-0
05$`$`$pPN(PPN)"PPg88 P&N$NeRR-SKT6'"9:9  :"9xh Wxi9d|p%09R:N{zy&u0YWv W0/PX_`)09#XVYZ>]9
P\1~Z - 
[^ &LZ
 !b W;`;@Z;s\YSdeb:;<<:;<`S<t%<<5;; <<"VVrPi90r0+09&n`yY9 Wr9 [ \Y SoYr@m   
 
 ,0 
 93?o_p|qlmZqc:Wo`V0VsV0u0-039(k\
mnTaue(vebcr95~뀱_{/|]0V90 ?2W`*
*t9@Z9Kumњ҉@	e9p6RaeEZ9"V0 \j9C3W򢆶YyJёl҃0*=Y0WGifp[\㗤s0;q iTёԖB䗀c6xgpJp `F0 `)k" ) ) 6 6"ܣxg z}Zt "1x{7MNOp#D Ee1_``}GX#0
T1d`*?"1#R~ pq{z}yZ1zxzӟd@0#
0 *`0`-0$`+$`W$`6$`$`&@[$pYT ԀQFq>q0Txv)qo!rDx͎000灭 r 0aaP؀-Pe`# 	p"F,:|`{"q TpF`xe  U05xv
xDߐ}D,0{ ^`
}^T?D=䫓_e)s)l'ۀ@ TpB,о34#3$``$p"t1e4`_tg4$Q[Հ&0.'0*Td`x0dp&@  xF TTÔP
xGQ0xFtpe xBCB"s7 xNON"l {xJKJ В"_78 2/F"!:(x ү7%$Ft:t:8230(0 (xv`3x`vT"` 9x"ү878 0(@87 p0 xφvS3xV53}., `4  %4`.4P""55Ô@`p`/``"آ# #d`
-~~/OTO/_s`oss 6120``/`@$pND21I:4y &$y x u )AP [x`03oppG{,8>p1 'AP` "pT`~ -95u ?Tp;үd`pxH  @R
M
 e
 e
 @dq;"-.o m``2-x00 <.@	@
0
t D~TP\0	 0A }Ct
1u/0/tl;@p-P r.zldpe`0-~aDxFGW0"@2#`"" 2#"xu00 '0u0/1s t../0D..}`0 $0/C-z *Q- })+?
.2r//`"/4  4*x0)\:)4
+,3`4iO)1<:A	7 8p
8:ph";a)
2Oza?0@|b55 
x(0	(c"QC}*";((0@@`?v@{	F`~4p0 ϰ&T``a_`$Ю<`:p5s _D?F ߣ%@50B
op;s R24qTf  U0: R2Mp	S08/$B0t M0%%cO`SR$Џ-A	N-H_<w=R+a:YQ-RN6ɱ6Xp0r0V+P]o0+-`0-ce-c-P`	3-PQ.[tRE\e߂-O.@! EP6&/u.
/~ku.As.W	YW,:::
,-Uoo p2- 90&ppp	Tg -		@Ȁo@ˀqtR080uqpo
)oa*+pF}}}0
0,/+*t%)F$ 
QH&SHS;":+Nap8Bߐ}@BTQ&0W=_JG>H`"< OT0O!y45+pY'bxaT) EB
C\0 `54`"Sm_tw:{U!rѓ'b{#{U	 `ѐ慖QQqH`{0}
a9WW!rde Pg6$$P3%b/}vՐ{ѐ#hQe\o}z 1w X`FpRGpLxpGNtp?RL1RՒL#RLRL
TU`6 |TBx{}Axz0Gxy0Exx0Fxw0Bxv0<xuxfxtx\xs0xr0}xqxxpxx|pAx{pGxzpExypFxxxwp<xvxfoxuxtpxsp}xrxxqxxp"#6Pxev0Txamү;Db" /:!e0/TxaP#aޒb;m /^s*****Q1X	 ~95gF")wu,_.00-T*/.~f00)@P (0HP|4+S @ѱ	1X
)@Ip,+=>')QqO*+\pGXJt+[+U*`>'-p=P|/y0hP5M/$\?uή@}}Dm)htmѱi4N۝0H0 P|950H(pPy
ӱ "u*ߑ09"u p}/)tmP|~?n) ӝӂ	 MG+0pr=p+pM&u0Do@TtHp;DےS)U)u+B+E@2Po&Hu+T~m8rb+RY%TwOS 70	  b`[`@BfB$`@Wϔ@6ᤰ   x0pq  x<a@I	77 Bxv
07PIs `rt`>*Pb"D{"ZŽ@q:opT L%qM30.vT`t`'}}S?p@Y33TB@D D xe3"tѐxV_xF @t`t]Twqv
  M.rJ!!3"x_*"PC[=Pu0OAaGF7X03ct+`
0Pp *J'?' 'Bh\A:{` Q:'P`	'{Aj"IJ;^
U{TNJ EI"-`1Y5Mn:Cढ;CwC1Ypo0:2-{uu1P[u10!$Њ:01銠H,&2;2044-D0-ڲP["-UO@?"CDOs(a{!Dd/p@}<Vpt=tr?A orDHEp=`EDxhvCDBF@xGAxEBxFt@0( AT.`xAA0xBFt"("DAEݎF0GBUCBaCCCADiB_DyEBJF8GT0LHNaCOCMDNIyENkKYLHJaCKCIDJTNyEJkKYLH;EF_;wGH`NJDT&` X@A0uFlF@[
HGÃtS}]PhCFEC}^}e}s}lEAMI aB++I`Ô@"OxD Tw{ЦOGƀ`cFÿ$0,2`cAz#}@T#}CP?PGGGGGGjGXGFG@G:G4G.GFFFF  G{I@1g $K $" P` ]kat"x]omnnpnkq"I
`Darm(r```aBvsr1n)C`]klq1nqxq1 =QC#Q$`mRH|$HPӔ@zPOaPн0	xhZÀӒ}|aB#rP`#`5`2$pCkalD#u#r zx\PPT`gxgCmrpz@Y
xd GÔ@π<TxdJӔ@`7sTsн t dxi vv\v+xgv2``#t "4}t Ŗtp)㐿}=t И	+"ÔP@ӔP@$?$P`YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATbb`cJ!e2{g}~L;"_$/LQ0P`Pd`uPgKK&K2K=KgKsKKKKKKKKKL kL4B=$D%~P?C`nv`plB"l$m $%A @W$kg~k ;TּLW.r0g" #xbwAlh" a2~g`P~0QOఀDz=d
`#w`(`{<`@dP`d`PȰPb0=vCp }t=td¡vxtxxXx\t mxat"xbtrNxJxFxBxtx(tb}p#Dxxtxtxxtoxx#x> x=tQ~x@t@0xTВ"xgtцx1ӡx!TTTD	xT@Tx=Tx"  Tk=D"Dxev0_}<t F{B{G{E{A}DA"x0xP"xbSs("2@S?/`?@>"=$t>a&$-"TÔ
P~0~7%PPOOB7%OO{ z yOaN N+N3N4N6O7O8O9O%:O0;O5<  O:bOIY!Q0IߒA9p1~5NbWO&8;uOuOKO``($`*`-|/p4
TbB <UwBFEGAO$`$`!`0`?$apAa@:32B*0 @#S0AB,3`G`[p]Opa"OdpFb ^$`DཱྀwTҧQ@0 GOp[cP"L}$pMbPS'Ld`ǀLxbLÔ PLNQNs!	@P
	

Pxbv
@QQQQQQQQQ^QyQQQQթQݪQQQR
RR`ReRjRoRtRyR~RRRRRRRRRS   S'01
v"x{7MNO`u{M`\MM{x}Z/xz[ј@"+"0M
MA0搓h0"} N}U6 "uNp0SNNTN0CNRp!!d0^p! 0p!@D Sx\bvUaaaaaa<xTxeD0xb@(xx n`}K}I$	a
a@"3aNxO| } ~ Pg4-/&LcU)MM U)SJ((sSSTTTTTTSSSSTGTMTZTTTU U	F2Ô`P	LOC"T?8} S
0xtД"LNL0Jю0;V	b50;TϐAuL<;>?rQ?p@0b3@P ;9N"	J7$p!9Aa0Lp."xzdPDC"{z}yZ8yzB	OM@7"9AHeu7IIeq?0M}!dTsIsIA!L@^|OL#T0 ˤҊ0!A0lU0#b0xD  ATx@c!T_TxxcvƠԊTT`BYDaZbZ`<xdX.u0/}.,0.ÿT ^00//pE@"U]"^.jga"`"^} ^",0V"d-,Ô ,dpCSV8`a95-"
r3xp0 "3xh`ۢՎ./01,@rDt?/t .x@Zx?DT?/.1R0U1B \xܐ x@!D!x#Dr"q p@:q@6x澐YbYt2YWvB3WWWXevYqYYYY6x
ߎ,-1kx
tu,P
-},0x
z{x
yxl{Vx
my #u6|0"t "T $QxmI{BxlxlßP2V0{ y%@$IԖ{$ÞPxxl{Iu'At I|bd)*u耧+ytүt$`&p<V}eԊ@ quI@x+*)t6	|$xxmӔO@vl hxlvylßxmPA  l1Ƃ߀0 	6
xTUxv 6x1`r\
0|Pxplxx
x{xx	06Y)bP$~~|P f}06P:ҙZ Z Z*Z4Z;ZGZZ	[$
  [i'1LDca̤SD@c"xgD`BO`$P``G3`@ʐPTORPPRP  -DmP"".@ATABӣ~F`/3ѥ%@ U,p@%1e1t^0Os01l33TOQҮ0ұPrp r06"y`p}T˄`- .*))pr;S)zS)x`vS))"(),0.\"\x	`}FN@t\u- u./0SS0S0u/ u1/U-n.Np.%.-3-111pEPS2xp]x	1.-a^_p $ 6  .Ģ6 +22􀰿m .Ӕ@x1ͺ0@ _??6-p ʠ--Ӕ@00.`Ҡ`]9]H]\]]^^/^J^e^u^^^^^^$^%_
&_+_,_,-  _1.䀙S_1!xu,4ӰF./xP?0ӳ.#4ӣ ց9t0P|*+AyP
/+*{4ُ
x؀t?e+pt e*l	mڢm`
pxvEvmx2Ӆ`x:Pؐ}v}Cztⶼ0/hOtb.گ`v`ao}atauavaL>}3af@Ԁ'P'ZH`ab pep)("ct`hP
________	_____````A``3`  ` ` cccca
tt)B/{rUc	c
c`-
1җT`cPLxT0BL:)P"
BL:M@`L'N MWOxARZx`!0Gеt(ODC4Q2	Rx{p⁵t[` jD:
1
@D aM*"^qD:o2}#210"00(1$`$`$Ap`aJ"_	%$'cze'1p;a(d	`
DDxh1jzg"
"xqTp@opa}` a" `p "$``#`$`%$p#F0 c
=#"x%txy1m.d~%m"2'I}t0	
A逰j""X`rxyqTTr=
* ̀+l!{D`T!T\ñ.p*
+"  =>C	D

~x`!P2^`_f"
%@o~sF`7 j0x(5(eLxj6d(S7(`S*3`C00+xT 6r}_ 2p. D:_T_` @BTU:0?0	6+`5q>dxS60cx7($```9`B$dxv (zBq DxTR?ҎxStTTTDHc;(xS(<x)76)$``$p#(p8xSxB(}B	x60600:=a>0cj2a<"*+*Ô@*ӔPMw@
MP@o*$1HѤ$cp!00-C+(}+ՀÖ!Q VJ+*fApMC++ MsMteqMucT@N@opO~0B`J`N`R$dpT+0+ac"+WTXdp0AX0ӀÒ0 +ڱq[+R"*+l"s=PD"xBP*"
]	1}i`$3mp`P<߱Põ} ~`b,/PfggRgXgagjgsgsggggggߕgߖhhh#hhhşhŠhhiiiijjj%j%jGjGjijijjjjjjkkk-k-k3k3kUkUkwkwkkkkkk  k~'QrkkC/ onT3/C/00u5$ 0` R/q ou/}o}/2ttt,}atBqfuVv(vsvVvyuVv͟{uVv}o P TPpBqqLBq|qӝ Tڑo~ at`| }`@^_ἑoJuVvuVvCtӂքӔo  pi|nÔd@n| `z {@\]L`s9-/.Yatx5op.˒~.+-wVvuVvuVvߝuVvuVvt@#@x؎#-pb~uJ!_{dz wVv?u٭cuRVvuVvuVv`,$/0Vvnq/q5qo/9p0U!~Vv?asÔ@πu/,/ΰ!y`AH S 3P b\pup;<~#`jPl$ m5!'`T}$<`!!WxmpI
աJ
KxjB==xmP=U550#70"' "<ɠ'"$<_v.OɨK`Š
J
K
Lʢ=xm@ǟ5"89:38T C
d@Y08l;}e֐& 8  | $ >89:pԦdP (A/dZ"8}~%}ܲ0qqނaޣmע ` (ɠ#2 N (}馀$TToȐקt


(~HsP((`!`~%2ұ#4ݰ@0v3D܌ϔ@#Yܐp@t	0 ދ 
41ppndn"14P&!o?u|  }p
T?T`4"4"cu0<..`~r~9^rTKqTO$&../'p3q*@Pz-nc.1@PC18@1ӺP@rB1$qqp083Z,A`&rm@` `䔽1"x`0T`2T_2Oz p.7Rٳqp1o;e.`.3?@ؖW	e.`qp.o/{/ W/0}  א~"Wް	!D7@T3`50"2ސ2` t@2.BrMu./Su.$!}r?}]`|/Swӝ/[Pzu. Z0/ܥq"'sƝs6u0Nq a.PTTT%%AFp0 $r0}
r	.d(._/ӟ@Ps	!nx b. bPYx}700,`.0& /p$/^00۰Pq/^!07O"!sȿ 6^6Et`466y4v=}6Մ s岰6xBd%xB^6tx4^6e6q4t}5}{zyc^`u$M04M@fM$UPUMg^`-$5tP~@_
qat"5"¿05Q5`
!t@	ϔPP//Eү0ίد!n`|r|\`2345Áf}M}4171х|v((svw"wCw^wwx1yyIyjyzHzz{8{{{||0|Q|rsK{	m@"!cpwc !]z}p1lklpu2`u3 { z y2Jrbs2T`pd`dppkJrs03Gwce3pe2`(Is003@Q3/2Vk^P3y
yXce|QӀ  @Fd1P;|$k400~Q3E2pU{s7{HO0$Vk4P59ysu9Vkkxs6u6R9"`z {T@\]Lp)67776Y6Vk<67
ϖ.:_>a!dLpi>kJr7(?b!k/IppNk?A=ʴvPkx/	 B(@:?BkJrVkkQRk<Qk=JQk>Qk?.ãUDgMk O !UDa^3DIm09L0_\TҎ~VkF` 7gvGkE510_"0$k}1o+ n!2u1@(#1$`=`l 
~$`#1 u1J!uxPX7ބ; dEb tuPNÔ(P2!TT Np\  02 @MJځÔ@qq` fu1;tpuPҋ7@<TH1Ƣ7 b/dz}` Ou2X䪰 /a~L`n +}3/ERn" H<tQURUXb/pAX08)}D02"(LPί.3A_ܠIV%[` m X}ɞ|4P90p=0.o0ӕ//.p*1 P$#%a$3/tP" 2 }_
 `"43t#o$jR3D2x 0 `Ð}p@2x0@@2xD7)	v"LION  1`TDx"À" 0sp޳"8bP3px"/q8 @1X!ӀÒo88"bb!Rs#"x& 3%T~TہO@&&"x!To`	+3~`xD@T"	F	Q*>	`*23*x*p!+s+d B*X-*LҀƀi3ꀚڀʀ3-䓣Ń1?
-1@*"#1143*$ PS7##EN``#s-"P"]B4"90:p:"  )"/33@ >" s=3@P">"(Ap80;
- :߇	p:	:t!;)ς:eC	%p:
G"*PE!;2Cp^C	AD	"EIGBG"""BBE"`;O3=p@ >P"""Ѓ?ЂETTtsߨT틶Vs1ŃŃ4W"%85`TpEp
Es`Uh`!*pt*\+\~+\va,\n$,\b-\Ve.\UJ&/e/101/1cp3p3d{V6p&77a8#'s jl/mOnoop qrsu/vOwoxy z{|~/Oo τ/Oo ύ/Oo ϖ/Oo ϟ/Oo Ϩ/Oo ϱ/Oo Ϻ/Oo /Ooɏ /Ooҏ /Ooۏ /Oo /Oo /Oo /Oo  /Oo	 
/Oo /Oo  /!O"o#$ %&')/*O+o,- ./02/3O4o56 789;/<O=o>? @ABD/EOFoGH IJKM/NOOoPQ RSTV/WOXoYZ [\]_/`Oaobc defh/iOjokl mnoq/rOsotu vwxz/{O|o}~ π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Ooŏ /OoΏ /Oo׏ /Oo /Oo /Oo /Oo ?_ 
?_
 ?_ ?_  !"#%?&_'( )*+,.?/_01 23457?8_9: ;<=>@?A_BC DEFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ ! "#$%'?(_)* +,-.0?1_23 45679?:_;< =>?@B?C_DE FGHIK?L_MN OPQRT?U_VW XYZ[]?^__` abcdf?g_hi jklmo?p_qr stuvx?y_z{ |}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ Ŀ?_ Ϳ?_ ֿ?_ ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_%& '()*,?-_./ 01235?6_78 9:;<>??_@A BCDEG?H_IJ KLMNP?Q_RS TUVWY?Z_[\ ]^_`b?c_de fghik?l_mn opqrt?u_vw xyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ɿ?_ ҿ?_ ۿ?_ ?_ ?_ ?_s     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/OoDUX(l              @ ` d$ UNDI  N MdPCIR$    I PCIRE      X b   $    $PnP       o          
Broadcom NetXtreme Ethernet Boot Agent v6.2.11 
Copyright (C) 2000-2003 Broadcom Corporation 
Copyright (C) 1997-2000 Intel Corporation 
All rights reserved.
 Broadcom UNDI PXE-2.1 (build 082) v6.2.11 
Remote Program Loader v6.2.11 MBA v6.2.11  Slot 0000 Broadcom Corporation Press Ctrl-S to Enter Configuration Menu ...
                            
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 t`h+  dMd            h+ VP@ ء .;uXuX.6>| .6^SQW  @ _Y[QSH .> t".>u.uXH S2.{r*= eu 4= fu  *= gu0  .9u
 @ ؊>l :>l tIu[Y[Y.> t.>u0 .>u  ø UWSR..>f&=$PnPu#&uFPj`hf&u
˃ u0   S3=_Su}M_u22]r< t[Cu[V[}#|OfSf]S_fSf[2= t#It2E= u= tGG= uG؀}|E$t0  Z[_].>u-fh  fPh hOh"ph%th mh fh_SQfRWV.>f.> t.@   ځ>  Utt r rf.>  h1
PH ?X%
PXE-EC1: Base-code ROM ID structure was not found.   r댊  t	|Sfj j H< tk>  t;sf=$BC$uErPj Wj < t뛌ێf.> t.@   f&=$BC$ h  .6.6.6.6.6j Ph#&u
˃Z t'hDRHPH +X
BC_Loader() ==   r tho%PXE-M0F: Exiting Broadcom PXE ROM.
 P6 X^_fZY[.>ufXff., f.. ff.0 f.>tf.ff.ff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZff., @ 6& ԋffPfSfWfUj j fj fj RV@ & .6E.6E.6E.6E.6E
f., ff.>t(Vf.ffЉVf.ff6Uf.. ff6UW0f6UfVf6UfVZ k	 t	 t	 t
 WPO
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>. uX.> u
h
If.f.fӎF.3.f.F.3 .> u5h
i
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sDh,P?
PXE-E20: BIOS extended memory copy error.  AH ==  .f.f^f. rvf&D    fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(DvF&DF&D&DPj Vj &(D	.6E.6E.6E.6E.6E
Wj v&\Z
 .> f3fp  
Wh v&\6 u96} t2  ءL ` N b 6E6E6]
6U6uf6]fSf6]fRfPfp  f	fXfZ  YWjuv&\Z  t$  8Wjvv&\Z  t  uj@ H F F  RWjv&\Z  tvXt
 u tfS^G HF +F )F[fSVWF   6Sfff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 .>u%fp  %f tfP  ءL ` N b .> u0	= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]k3e3_3..fP. tfX. tf3ffFfUfSQfRW^  G33.. G3.0 . ua^_f..^G3.>0  u	^ af.^f.f^G.3 .. 1f.^%^f_f. s
^  .>0  u	^ f.^f.f^f_f. s	^  ^G  f&<!PXEt.;60 r^ &DXrPj Vj 6< u^wG&D&D&D  &L
f., &D&&D ff&D"fG&D(ff&D*fG&D0&D8ff&D2f&D:.&DX&DPj Vj &(D^G  f&<PXENt.;60 r^ V&D,rPj Vj {< u^wG&D&D*., &D&TG&D G&D$&DPj Vj =&(D	  ^? t _fZYf[]f   fZfP.>t.> tfX2fX.>t
.> tfRfPfWfSfQhf   .f8h  f  ` 9fh  !ff   fh  fHh  f    fh   f..>t7.> t/fp  f   uf ff#f H ffp  . uC f   ff
f t!fff uffff.	Itff   .>u f   tf   fff ff   f.ff   f.ff    t.0ff   f.ff  0 f.ff   f.ff  @ f.fffp  ffffp  fYf[f_fXfZfRSfPfp  pf   t/f   t'fXfffff	ffffX[fZfPfRf h  &ff    f h  ".> t#fh  fff   fh  fZfXfPfRf h  fff h  .> tfh  ff   fh  fZfXS rR[fPffp  fZf fp  }f p  f  nf   f p  Mf   t_ [fRSfV sfHf fp  &f p  f  f   7f p   f   tV fp   f[fZfPfRfQf p  f    f'  f p   f   ufd   fIuf3fYfZfXfPfRf p  f     fZfXfRf  `ff8h  x f   f8h  W f   @tf<h  F fZfPf<h  G f  `BfXff8h  3 f   Sf8h   f   @tf'  9fSxf[fSxff[fS|f[fS|ff[óhf   f.f.> .>  V  fp  f   tf   t fR t#fffff	ffff fp  If   uf  f p  /f   Of p  f   tfp  ff&fZfItP^f`f&fIufPfRShf     fP fPf @  f   f3fP  .>t.> tfh  f  .>uhf   U tf  @ J @ ۊl :l tfX2 fX+ [fZfXÜfRf3.ff
   úfffZÜfRfPf3.ff
   úffXffZSQ@ ۋȊl 8tY[fRfQffh  ffh  f;tfIufYfZr.>  uPH X3. .P #. . .P 	Pfj j .( SXf%  fZfYf[fX t]fBroadcom NetXtreme Ethernet Boot Agent v6.2.11
Copyright (C) 2000-2003 Broadcom Corporation
All rights reserved.  MBA Configuration Menu  
       <Esc>    <Ctrl-F6>       <Left/Right>      <Up/Down>       <F4>
        Quit    Blink LEDs     Change Value      Change Field     Save This option is not selectable                                                                                                                                                    Boot Protocol  Preboot Execution Environment (PXE)   Remote Program Load (RPL)             Bootstrap Protocol (BOOTP)           >Select Boot Protocol     dj  Boot Strap Type  Auto Detect   BBS           Int 18h       Int 19h      Select Boot Strap Type x      Hide Setup Prompt  Disable   Enable   $Configure whether Setup Prompt is displayed during ROM initialization     .2  Setup Key Stroke  Ctrl-S   Ctrl-B  Configure key strokes to invoke this configuration menu x      Banner Message Timeout  1 Second     2 Seconds    3 Seconds    4 Seconds    5 Seconds    6 Seconds    7 Seconds    8 Seconds    9 Seconds    10 Seconds   11 Seconds   12 Seconds   13 Seconds   14 Seconds   None        *7DQ^kxSelect Timeout Value      Link Speed  AutoNeg         10Mbps Half     10Mbps Full     100Mbps Half    100Mbps Full    1000Mbps Full  "2BRb"rConfigure Link Speed       Pre-boot Wake On LAN  Disable   Enable   Configure Pre-Boot Wake On LAN       fRWf3ҊC fRf3ff   tf5 f fZfOuIu_fZfRQWf.fRf.    ft   # XfZf._YfZWfRfSfP>uf   tTX>T u
fUPf]TfU`f]dfff   t
 ff<ff0ffuW f t E,=
u ff%   f.  t ff%  0 fff%   ff uf   fHff%   fff%    f
E2=u
fXf[fZ_WSQfPfRXf @  f   fp  f%ffffffp  >T ufEPfE`ff%>
 tfffffffffBfffffff
f>Wu
> t ffffȀ>T ufEPf   
fE`f   f:X fYfff   fZfXY[_Uq 3KtRMtpPtHt.ct>  U =Uq} Us }Uqh 륃} t=} u7} uEEHEE 낃} t} uE@;Ev3E& b.2UUquUCRVUmUPUXUuUum
>n ]^ZQP>=;>uXYWQU>R=m uUZƋ=;>u]Y_PRR ZZXQR	 ZR { ZR m ZR [ ZYQR 2f ZYQR 2O ZYQR 2xZYQR 2_ZYSQ  Y[P< tFXô
PSQU  U>V]Y[XUP3>F 
tEAX]PQS >R &S P[YXø PS U>V[XRU  
U>VP ]Z(*q3ɺO f`P  .  : P ͊>V"UPU1.XU bP ͊>VL7RZRZ0N>S[P3fafPfSfQ ۻ  f?_SM_ts OvQj Sj < tAQj Sj < tЀwrgrafGf tWO  Q f Yuf=   wPfXf,g8 tIt#gfXfg8 tf@fg@tgef&=$PnPuW32&C&:]u
uBf&}
 t7j &uSj`&]
[uj &uSje&]
[3tfYf[fXfPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j S< uf>  tf fPfQfRfWf     t;h&rf_fZfYfX
PXE-E07:  PCI BIOS calls not supported. .  	 uM.;D u. 	 u4 toh,'
PXE-E01: Unsupported PCI Devices! h`'ڊP]
PXE-E04: Error reading PCI configuration space. f3ffDEFGHS]m
T^Bus =   Device =   Func =  QW '_YfRfPfSsf  Gff  f_   D	 Mf   f  /	 8{rf  ff[fXfZSfPh'.Ph'.Ph'.PfX[f3S.z .0..0..0..0..>t.B@ ۋ .[j  wPЃ Xu
U |U....>.VfTSAFu u
...>t'h h h.> uhfSfQfR. . .2 <t@h)PH X
PXE-E06: Option ROM requires DDIM support. f    .  f    f.f  fRjfjf. ffPj h2*fQ˃ffu0hR*fZf    x
Invalid PMM function number. f u&h*fZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.f.> tf."ك0t=t	 t  ` b   fd f.d f    .$ Pj h  j .(% . tf.>   r. K         UU *
 V4 *
 33 x ZZ j*
  Z*
 3 .                                   `  p ,  (                  
   
    < @7! <  &      
   '< $   4       <$ $ $!8                '' <  h`hb B4hb @cP$ <p"x$ <" c4 @cQ  !  <" B0 $ C     <pBD  
 P <pB P4Db8DcDd <x" <# <t$    ' <  U<Uc4<     C $U<Uc4     CP $ <  G ! '	 !(  hchbC     $* @      'PDc <xB +C  @ < <PDb + @ <DDcDDb$C @    HDb B00 B$ B, @ @<  
$%  8\d0\b B0@!       PDb <tc  
B0PDbB0+C @         '!(  <$!0  !8         
        '             < 0B4 < 0c4 <74 <"@ $ <" <   ` c$+ @P  `     !H   <B <  C$+D  <# @!@   <  <B <c  $@ !C !H  %  D )@ )% <B <chd@ !C  D E F G J  K        '( $    k   <B @          <" <B @ks< <pc
 
 B4 <pc b $ <1& 2&- hp 2 @  2P       2 @           " @    a  $
 @P   " B$ "
 B, @     <pB  @hs
       >       B" @    b B0 @ $B  C     B @          B B0 @ks< <pcM 
 B4 <pc b <Ɛ <$!(  !8      (Ps 
    ( $      0 '     hbh 
 hb  B8  B0' < B4< c4 b<bc $b\c ]c <  < h b <  <  < $   <$ C 0 B, @ $ <" <$    b8 B, c,%C  @ $ <" <p   $0 B0 C $ <" b$$C  B4 b  <"ks< hb B4hb\b B4\bDb <c B$ <"\$d <B   <$   <ƌ <$  !(      '' !  !   -     h\qhbd &+C 	 @     @hphb  B0 @         `\b B0@           '    B0@          $ <|#    B0 @     <|     B0 @     <|  <|B@         '  PDc <xB 
 -     PDc <B +C @ <DDcDDb$C  @     <-     DDb$P @    HDbB0    ' <B @    Lb	 @ $ b$$$C  b Le9 
Ld      <c $ b     b B0 @     <pB  @ $hbL 
         ' <$$       lXb b    PDb <cB0+C v @    \b \b  4\b \d'  @$ <B B$ < 
" <B B$ <"\b \d 4 \b  $  b$ B0   <B @ 
 !C  $!   ! @  0 @ & D $ " 0 @T @4@ 0 @T $ 0 @T c4 0 @T c4 0 @T c4 0 @T c4 0 @T  c4 0 @T@ c4  0 @T c4 @0 @T c4b0 @T 4 0 @ 0 B 4 " 0 @     B  4 " # & B
 "  "   "  <B    %b    $ , $  B $  $      ( '            ' <c$    b < B$  b]b4 ]d'$(E   @<%(E    22
 T<b8<c!(@  <  <<bA 4 $  $    $    b!  !(   B4   b    '     <B'0 !  4 !  (  $8 !  < , $     T b B0 @    b B0 @ $b 
 $ <B B0 @<c4 b8< 4$C  b $bdb B0 
+ qD` <B B$ B,
 @     b $c B0 B,# $ <$b q8<p <Ɛ R6 <s&  g! `  !(   2 2 <0B4%b b8<$$C  b b 42 $ B4 bd  e! ` $!0 8< 4r  
 s @P!  b B0* @! ` <B   B$ <"g
 $  !0 <B B(
 @8< b$$C  b b B4 b 
!   B4 $d  br!  b B0 @    d  
 $ & N*@    u <1&!    g $  !0 2 @    b B05 @!  hb B4hb\b $!   B4\b  g $  !0 <  
!        <<0B4%b <1&  " B( @!  8< B4( $d  bp 2 @        $ <$  g $!0  !   $ $d  qb B0 @ &*@ $b <$ $  g 3  !0 ! < 8 4 0 , ( $      @ ' <B' $P L H D @ <   C8       
 B0b B0	 @     b$ <%C d   b 
!   <B B0 @     b<c4$C  b $bb B0 
+ d   $ 
 $  '!   <<$ s64B4$  q 16( $%5D`d   bh`    '!@  C: c,&S B,%b  `    hb B0+@      R &b B0 @     & .@T 16  ' $ B $$  <$C 
 C $(  <$C  @ $hb B4hb\b B4\b $b $ B!  d  d $q "2@ &.@ $ 
 "2q "2 B8 B,! @  "2 @ 0 b!    <%C  b 0 @ $ $b $b! P L H D @ < 8  X ' Db b <%C   b b<c4$C   bb B0 @!  Hb $   !` ! ( $  `B$@ c$  B4 c4   !p   	 @'     
   b B0 @!  Hb $   b0 @ $    b     å
  
   B$ ¥B0 B, @ $
 ¡   ¥  @ B0 @ $ 
 ¡  
  ¡  
        Õ ¥ b,N@!x    <!" " @       B0 @ $   ¥ < čc4$C  ­  $ 0$C 
   ­ $   
   a 
  ¥ $a 
  ¥   Í  ¥$$b   íD` b $ <%C  b $  ¥  Õ#C qB,@T $ $a 
  ¥a 
 $
<J5  ȍ $$$@   B0%@ Í$8 @  @c0%8 $H   B0%H" $$0&  B0%0  $$( @  B0%(  $$     B0%   $$  B0 %b    ȭ ǭ ɭ ƭ ŭ ĭ í Õ$J   ­Dc b <%C  b $a 
  ¥
 Ñ $ b!  @ $a 
  ¥ @ B4 ­ Db b <%C  b $  ¥  $
 C$  Õ$D $d  C $	 $a 
  ¥
  C!  @!L 
 $ č<$  @< ̍<c4
<J5	<)5<5<4<4
<5<4
 $  ¥  ˕$`B  c0 %`$P  B0@  Í%PB$HI ĕ    %H#$@( 0% %@$8  B0  Í%8 $0  č  B  c0 %0 $h %  0 $ %h$(E   B8 B0 %(  $$  B  @B0%    $ ̭ ʭ ˥ ɭ ȭ ǭ$ ƭ ͭ  ŭ$   ĭ   B0%b  c4a 
  í
 Ñ $ b     , @ $  Õ#C qB,< @!  B0
 @ < $C 
 @ $  B0. @T<    B0* @T< $a 
  ¥ < ¥ bc4 $$C  b $a 
  ¥
 Ñ $ b      @ $a 
  ¥  Õ#C qB, @!
 $a 
  ¥  $ <%C  @<%C a 
 ­<5!  '    d_wfv_vr11.1  0.rDwfrevi        atafrrEl        ebifknLr    rdwfinIv            a_whgotu        ` x   8 @ @ d   h   \  |                                                            DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:  Download failed

 
Searching for RPL Server ...  Abort

 BCM570X Found

 RPL SERVER NODE ADDR: 

Transferring data from RPL server ...   Done

  Transfering Control to program @  :   /-\|               tttttWS ˌt&  ˍ$        !PXEX8             {                       M      d      d                              PXENV+,$                        M@ d@                 fUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
&  fXf^f_fZfYf[f].>  u
~
&` . h@ fv
Phv.6 j ˃
fUffSfQfRfWfVfP. g]g} twer`f&؎м fUh@ WS
f]f&g}& tu   fXf^f_fZfYf[f]fg}&` ڃ> tj USf. ff f3ff   f. 3h f&f. ff& []  Ã>tj j ff9h uf. fh     Ý   V@ g&5   +g&5   ^Ã> t&j f. ff f3ff   f. S3h f&f. ff&[&   Ã>t&j fPj ff9h uf. fh fX&    ÝfX&   Ü=PVu NVf. Uf ]ϝ.6 .6 . . SR[.9 u r   Z[UVSvf&ff&GfD[^]f`. > t;su .$%t а r   fa.>  t-. .>$t!  r ӄt"Qf.>  u8Pwh3Ɏظ&. &G. [i Y3YÜSQ3ێËȋf.>  tFwhff&9tY[ f. f&H f.     3PQRv ! ˃ӈ  "X tZYXPQRv ! ˃"  
X tZYXS. &ێӼ ON t+73!XuVV66N^VbON3tڋxZ&[S. &ێӼ V=OFN3t	ڋ5Z&[   f~ u f~ u^& ꐋF fvyFafvCfvfv֐fv̐fv{fv븐fv뮐fv7뤐fvu뚐fv5됐fv놐fv{fvqfvgfv]fvSfvIfv?fvE5fv+fv!fv= tw#=
 w@. 
= tw#- dHiHnHsHxF += tw- vH{- Ht- ϐF^&~@  >G t  hD2VZ^&GF&GF&GF&GF&GF&GF&G
FD<D?KG  >G u  G 3 3   >G u  FFhD2rYFF   D
uЍDru^&GK^&GT>oFu^@B&G \?^&G >Fu^&G	B^&G
P^&G	 ^&G
 G 3   >G u  FDF  %F@P P YFF^&9Gw&G^>^Z3 >G t>GtD%>F*G 3   FDf+fF^&GtN&GtN&GtNF&F@P P lXFF^&9Gw&G^>^FV"^G 3   VFD^uRptu?LB
FVFtL.
;Fu;Vt L
u^; ^ E?F^Î 	F ^ u	PPX	F   Y=F~'}*^f0fP <	^N&^ f	Ftŋ^ u
fjX	~'u^fPF>\^f&OfN^G F^F  ^&  &t.f&OfNF  F~}-^v& ^F&F  ^F&F~|F  ^v^F&F~|^*&GHtH|pH~I	^& FF^f&OfNftfvvQ&UV^&F&FF  ^&FF&9Gv:fvf&p&@
Vv^&@
Fv&@
F뻐^G  ^fG    ^FG0G2  ^FG4G6  ^fG<    ^fG"fG8F, G*^fG
   ^FNF=3^ DG 3   >G u  FDF  %F@P P *UFF^&9Gw&G^>^F3   V>G u ^ F  F^v& ވ"FF~|3^   >G u  fF    ^&GtN&GtN&GtNDFV3   V>G u ^ >GuDVu^&G  >F*^&G^&G^&G ^&G
 ^&G,  F  ^*F^v&@^"F^v&@F~|աD^&G.
E^&G03^ UfE^f&GfE^f&G
fE^f&GfE^f&G3 3 3   >G u  DhFNRvh3 U^&G^&G ^&G^^&G$&G	^&G&G
^&G&G3   FD^&G^^&G^^&G^^&G^^&G^^&G	^^&G
F^&G^^&G
^^&G3 UfF fP6  QfgF^f&G^3&G&G   FDF  >Gt^^&G F ^uLptu9L&FVFtL;Fu;Vt Lu	^뚐F F^&GHt- r-  ^^&G  qp>8FVF^0u
fF   fF  _uF#F#V^fG$fFfPh8^&G  ^_'^>  t
3&G  k8F  ^>  t^& ^   ^Pd
^&G ^PFأ G^&G^G^&G^GF^^&v*&G
*&oF^&G A&u+&u$&u*&G*&oF^&G ^&G F  F^&GF^&G
^&?u^&G&t
^&G^&G F- t- t^&G ^&G}^&Gs^PE
u!^&G ^PF^1F^F   %5F~}^_t^Q^_'Q^&G  F6   
UG^&G3   FD<<8^9Gu9Wt øFV^0u
fF   fF  _uF#F#Vu3ÐfFf#Fft!^0ufh   fj ^fG$fPhB5^ _'Ë9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^RPx10:0ÐURPx 0fv0 URP u @u
fj @fv|S4+4URP u @u
fj @fv|!4fv4   Sf+fFF^; GW ҉FV^fw^w^fwFV  ^^fh  FV  ^FfjFV  ^1vFV  ^CGG؉FG ^G^fG^fG^fG^f^FG_^7HOW #GG  fF^&-Ff~ t^fwlXCF  S2F2FV^扇^FFVQ+
u f~
tf~tf~Mt
f~mu
^Ƈ< ^Ƈ<,<2FV=(u u^+^戇<F<2FV^FFVċ^∇h1^,1FV^扇^F^怿ptqtǇ0Ǉ0 Ǉ2  1F^Ffj |1^fG   ^fwh1h% ^fj @^TFV=Tv,eK$F^XFVF%0 +- t- t&F ^抧F% +- t- t<VFFF@t^Ƈ.Ft^Ƈ/Ft^Ƈ=F΋^Ƈ= ^t>FVFt?F%? ؉FVFF  % ЋF	F	VfF    ^Ƈ,^pFVF^$-F^$p
F ^Ƈ, p {t^Ƈ /^Ƈ^怿quL/FVNfRvL//FVN^怿uNBfNFfv/^怿/ub fF    
 k.fFf~8 s^P=u܁u֋^ #^抧0t #^-fj Dhfh  ` 8h^fǇ   ^ +ҊԊ*ҋ^扇^ xFF  % ЋF^		^抧0ukǇ5  ^Ǉ7  ^Ǉ9  ^Ƈ; ^拇$-@ `uta- t\-  tW- tR-0 ~ tEfFf^F*5Ǉ5 ^Ǉ7 ^Ǉ9 ^Ƈ;f>b    s Ƈ* ^抧pt	fǇ `^抧ptu;(uƇ+=Ƈ*뼐Ƈ+^怿* u&~ t ~ tF+~ t~ uƇ+f+fF^抧0u!=u 0u
fF  ` fF  @ fvt ^怿.t~t	/ 4  *  Ƈ4^ "^抧t uOh  h ^ h*^ ^ mF
P^ FP^ h^ ^怿< th 	 )t^怿< uj 	 h ^3wFĊ֋^*^FFVF^*䈇^FFVĊ^*^F^抇^抇^抇^抇^抇^抇^fǇ    ^fG   ^f+f^戇^戇^扇^扇^Ǉ ^ǇdK f^ǇhK j^Ǉl n^Ǉp r^扇zx^扇~|^扇^扇^Ǉtv^怿u>@*FVf^抧 ufNf @  uN0fFf^拇HHtfǇ   ^Ǉ fǇ   ^Ǉ  Ǉ ^Ǉ ^Ƈ^s&uF^怿 u(uƇƇ^fGfG"^怿* tfǇ    ^Ƈ3Ð  SP #^& #^Î 	 #^è 	 #^ 	 #^ 	 #^G    (^GW^G  ^f+fG^쀿;uGGA|   $FG^'^GW^싇7FFG~^'^쉇  ^Ǉ   ^fǇ  @  ^Ƈ^f+ fFfFfF^f9 v(kD<GFf+fG^G^Î FC#ǐfv fF    fFfF^f9Gv)kD\I؉FG
 ^fG   ^&F"%u(^Ǉ PP| ^ u^ƇÐ  SVF  fwhh(^/ t ^}^ t^/% @fF   fv h^fǇ    ^fǇ    fj | gfj @]^*u	ǇT ǇT ǇV  ^fT /^0t.fF    fFf~Psfj FV ^?ݐ^_f+f^_G
  ^_G  ^_G  ^_G  ^_G  ^pufF   vG u!0u
F  F?v'F 񐊧 u
fF @vfF@v^tpuNfvl /^  u#up FVN Rvp fF4 $fv hfj@Dfj Dfj`Dfj4Dfj
8D^0t5fD^fDfh    ,Dfh    0Dxfj \nfj  \dfj DZ^;t"fj P$F^fwT$8^7hj X$"fh `  \$fjH$fjh$^fGffP,fj^*^fǇ     ^fǇ     fj Yfj Yfj ^ fj ^^f ^9j ^9HǇ  ^;u
fGz    fj;fǇ     fj ^ ^f wfj ^j^5j ^Wfj lXfj tXfj |X^fG    ^*䊇*튏****%FF  vP8fh  <fh &  dfj yfh   lfh  _fj Ufh Hfj>^fd</^fh< ^fl<^fp<^fx<^f|<^f <^f$<^ft(<fj 8<^fw<<fj 0<^fw4<fh   @<zfh   D<m^f0 <^^;t
fj 0Jfj  @fj 46^fT  ^* uU$fF  khf ufN	 khfv?^fT ^;u#+FNPvh( :!fj dfF  fv LfF  ^u uf @  uNfv Hifj (_fj 8Ufj Kfj A^; ufj ,-fj $#fj fj fj ^fǇ\   ^t\^f\\^fǇX   ^tX^fXhfjP^ptuUF F  fv|^
^b^ t2^ 0 F  fF    +uF fFf~ds
 ,^9Gu9Wuf~d fF    fFfFV^f9Gvc ^v_9 u69Pu1fFff`  ff^^w^9@u9PtfF^f9GtF ~ tF~ ^Ð^ t; 3^  SfjX/^GW$FNRvh^3Ð  Sfj X^GW$FRPhz^_thFNRvh^3Ƈ  Sfj X^GW$FNRvh 3  PSVt7؋GFF F؃
H^F(^e- F؃SFF  ^fGx^f9G
v^F^fD3^ÐfG
^f)Gx^GpFFGFfF    ^w*^f@^fG^w*^f@^f^w*^@F  FF^VGW
^拇9HNA#FFF+ҋ^9W r9G
 ^O^FGpWrFGFV ҉FVF+;Fu;V ^f7^FV8^fwFV  ^^fwFV  ^^fwFV  ^^拇9HNV #FF  FFufF @  FfFFMRPFYP^怿ptquj vFY+,^6F^qF~ 3^Ð(  RPSVFVfXZfFFtfFtfFtffF tNffFtN`ff~ t ^ÐFXZfvhF^ҋVf+fFfFfFfFFX^ҁ@ F؉VڊF$F$`Fހff   Nfffvށ 	B	RFF^9>F  vfrFp+F~}^Ҁpufj3^Ð
  SVs^f+fX^^\PPhfj \fF    fFf~'  sh[uf+fFfFf~'  s\9uF  I^ ^PF^6>Fu^P^ ^FuF~skF|F F붋^^ ^>^_G
FF+ҋ^9Gu9Wt<;u`w@F^&[^7HNA#F3^Ð  S/ t A	^^/%  s	^
 3Ð4  SV;u_G
FF  ^ʋGzW|G~F_GFF  ^GWFVfFf9F9^ʀ; t_FV ҉F̉V΍FЉFF  F~s1FFV΋^^v PԋF^F^GF t^ʃ& ^ʰE  ^G^- GG  ^f^fG^f^G  ^ʃPF^ʀ;u-7HNV #FF  _G
FF  5HNV #FF  _Gѐ^ʀ;u
fFfGzF^VGWfvXp^Ð  SRFV^* t
fF   0tfF  fFf#Fftz^^3  F   tf tfu; ttt
NFÐt	NFtNF  RPSF  tIFt)FtFtF 7Ft1F *Ft#FtFtFtF F^XFt^ tt
^X^fXh^\Ft^ tt
^\^f\\3ÐUSt
^Ǉ 3Ë^Ǉ 3Ð  SF * tÐu/0t# ^ FFu	^ ^h ^ j^ h^ j^ h^ h^ h2^ h^ h2^ h ^ rh 
^ e^苇t- t	-  ?hu
 Bhh^ 5hh^ (hh^ h ^	 3
h^  ,FV=(u# u^F^芇<2FFFꈇ<F  ^耿< u6j 	 ^fv,fǇ    !hh hh^ vh 	 ~^苇SVF! hF FA \F  F PF !FDF@ F F 3F@F F !u- = w.|55 5,585D5V5^f t!v3v^ v^	 ~u	h 3^ G^ =FF  j^ ^tpu+ujj  qfF   ^芧0u 0t
0tF F  c'F~ }^ FFtF ^f u F= uF ~ t~ u^Ǉ FF9F~F  똋^Ǉ ^ GF^fTVfFfNF% F N^fǇ ~uNfjP ^芧pu+tfNfǇ ~uSNM^芧pu+tfNfǇ ʚ;~ʐ= w.7P766777P7P7F^VTVfv 8fh  +݋^芧0ufh   fj
݋^胿uF^  F^FV/3Ð  P
@NF  FPvLfF    fFf~'  sL܉FVF  uF  f~'  rfF    F  P
 NNFPQLDfF    fFf~'  sL܉VF  u   RPxSܸhۉF@RPhF  hۉFF@t SF~|Ð  RPSfj @۸ .fhTveK^P۰FV^tIpt=fj pwfF    
 fFf~a  s pBۉFVFtfh  h7۸( ^f^fwh^=u$ 0ufF  ` 	fF  @ fvtfj @ڋ^ 0u_h 3afF    fFf~ds^3Āuh^ 0^< th j 	 h ^3fv^u
f@fF    fFf~8 s^PN=ut	
 
fv^^ڋ^ ptpuDfjPٸ PىFRP Pٸ V
fjp  ٸ C
fj  P3Ð  PV8hىVF  fcF$FV΂RP8hF  
 LF~d}8h\ىFVF @t݃~du3^Ð<h;ىFV*ȋъĊ֊n*ɋ؋VԊ^  RPS*j P\
F*j P`
F  
Fu.F~{~ uFtfF   fF P  FfF @ fF T  FF*+ҋ^{t  F  fj FVF {؃F~ @r^&wf&w
FV&G ^ ^&wf&wFV&G ^ ^&wf&wFV&G ^ FFfjFV ^f&7FV F  :fjFV fh   FV^f&7FV ׸ {
F~sFV ^&9u&9WufjFV vfj FVj{3   RPfF    fFfFf9Fw^Ff7FVFV(   = uuF PF TF  fF    
 o
fFf~'  s,fjFV fh   FV֋FVtf~'  u 3  PSVfFF  7F~}+F% FF  fFffFFFtfv FF9F}^v 1F1VF  뭋FV^Ð
  SfFd   fFfNft^ ,uF  PSF  ptuh 3m< L	3F
 FF3FFN~ 
~ th ^3( 	F  F ^ 0P^ h@^3^	 wFh ^	 h ^ h^ h ^ F   F
P^ h ^ ^h^ p^ F   ffF^^9 uF^9  F  F j^ h@^ h@^ F~~ F
P^ j^ F  ^^ ^ F~|h^ ^FF !F~p^ F^ F^FF ?F  F~}TF
P^ j^ F  j ^ F~|h^ ^uFh^ j ^ h ^ j ^ h ^ ^ P^ tv^	 gv^3[F=uD =uE =uF =u =uG =u =uH =u =uSty=uTtn=u]tc=u^tX=umtM=u
tB=ut7=ut,=ut!=ut=ut=u
MuÐ2Ð  hщFfRvhѸhщFf% = UPS  ^G  ^FG^G  Ë9Gu2Ð  PSV@+wV9Wu2^ËF7@^F^G^Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^  SVGF9u3^Ð@+wW^Ov^@^Ð  S F_GFF  ^fGtfFfFf9Ft[^6X؉F  ^PF^G
^F9I#+҉FV^fG
^fGx^_GFF  뜐F^VGtWvÐUfvb 8  Sst2"=t(rF^Fs^Ft^stfh   h
Ð  SƇ^f+f^Ǉ   ^G G
^Ǉd f^Ǉh j^Ǉl n^Ǉp r^vt^Ƈ^^8,t-
 +%< FF  V>F F  PF F F F ڐF ҐfF    uH= w.pF F,F4F<FDFLFF^V3Ð  SF  FF+ҋ^9W$rLw9G"vE&OFiF ^p G^fG    i^ p  ^GW^&F뤉VFF+ҋ^9 rOw9 vGÎ FiF ^p8G ^fG&    i^ p8l ^G"W$^Î Ff3  S
^&O^Pu  FFFFF+F   Ã ÐUPÐ  PF;FtN~ Ð@ &l &n   h̉FfFRPhfj hfF@B fF    fFfFf9Fv퐸hRPf@B fYf3ff> Ð  f6> RPfXfYffFfF    fFfFf9FvBfh  4RPfXfYf3fffÐ3Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^          2ff
   fP UfP fºffff]UWfP fºffFf_] Ð3Ð2C@@UPQRN;ssZYX]1ff       Vff  
@ &6 +&6 3^     X	S[	[P6  SfZ fFF| f^ fFfb fFFfd fFfh fFFfj fFn FVFP^ȲAt 3  VF  ^f+f&G^&G DGh4GG fG    fG  FD^t	 ^ ^*䊇船>F* ^:tF ^t"hF ^B^*䊇荹 hgF  ^vވM @^MwF~r؋^ X^Pq th.F ~tf.G^f&G>2G xM#G^&G^&G^&G
y^&Gs^&GF^ h@ 3 th`À>G u+0u$GPj
 .GRPfXfYffff

tYG*HtHHt7K>G}u<GPj
 .!GRPfXfYffff]
>GwVuG>GH3Ð  FDF F^^Pc	
u!^P	F^X	^G@WBÐ3Ð  PVF  ^^v& ^M^v&@F~|֋F 
^&G^   FD^Î /	Fuv^ u	PPX[F  ^f0fP <Cǋ^^ Fu F~'|ŋ^ u
fjXǁ~'u^fPFÐ  PSFDG  ^fG    fF^fG0fF^fG4^fG<    ^fG"fG8F, G*^fG
   ^F3  VFu^Ð؋G FPS ^G^G^S GQ	^G E	^G@ B	^GW  0	^GW	@ 	^G!W#	^G%
@  	^G'W) ^G+@
 ^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础DN^GLGB^GN 6^GPF  ^v@R F~|BS^GXFZ PhhI^d 3^Ð  VRFu^Ð؋G FPS ^)GG^G^S G^G ^G@ ^GWGG^GW  w^GW	@ e^G!W#J^G%
@ G^G'W) ,^G+@
 )^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础D^GLG^GN }^GPF  ^v@R F~|BSY^GXFZ Phh^d =3^  VFD^PF؋GF^^&} F^G- F^?aYQGF^GFF+F=CG*$Ht	HH~~:^GW	=@^GW
t=WtueNu	2G 2G  GF  CF~}-f^v@"*N t݀Nא^v@"F^F#GF~}>2G tF F  먐^G<)GhphxF   ~^#GF~|hqfj
 .!GRPfXfYffff ~ u^GW
^G tGWnF*G,G^G@t)GWRF؊N.G0GfG^G- Ff*GfР*G% RPF  PFF+*G,GG  ^G)h
 t thj
0G
h]
.G
G
^Ë^&F^^ÐA  SFD^P
u+^PF^&^G^_^G3  RVFF  eF^&9G,~_&x2 ~Gf&p.fv&@2
v^&@2Fv&@2)FF~ D3^ D 
u	DÐD  PVFu^ FDG FPfF fP^&GF  ^v^@F~|^&GFf&GfFF  8vf&p&@v^&@FFF^&9F^VG@WB^F3^ 9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^À>wD uwDvDtD   Ð3ÐUPFtDuvDpDrDvD ÐtDÐ  t À>vD uFV+pDrDFVfpDf9FsfFf+pDf  fFfFfpDtD+9Vwr9FwF)tDfFfpD3ÐvD 댐  PV-F8Ft,F~ t$* 	 	^ÐUPĊfÐUPV*ȋъĊ֊n*ɋ؋VԊ^	t	-t-,u 3Ð            Adapter - BCM570x NetXtreme Family B57           HardwareDriverMLID        
            `X  X                      	  
                             
                                                                                                                                            `a                    p                                                                          `ں  ZZZZXXX                [[0[[`\*[w\Z|\\/\`[[0[[\\!\"\)\$\Z\K]E]/]Q]]]```+]+][U>Z4 \+& Uu[u 	XZ
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+ t+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+DDڋDuP XÎه\.Et.  ǃPG*_G,_.O7Huù R.X tXu跩 +gl  gn  7 ñ..Y.ZYr`7Gû6Z 7t&&TW&L+.Xu< .:3ZuOu让.3ZY+.:3ZuuL
Lt\
DPX3~u< s"UX+Ұ.:4Zt+EZnZ]˻6Z  Y  &LOΌOWtَډ7G+&&DøV ^uY&,YXE"u.Yt!YYV^tEU*+QuMZYcQ Xu.4ZeZ`]Q".>Z u.>Z u;Y.>5Z uWu(g.Z.5ZD,ث+|t#+.X..X<rg3.X.X &u&D=vV pY3ɈM .X&&\&T##At.X.9Yu.9Yu.9YtÿpY.XrF;wr&\tItJpYE ].XD&D tz}.X@Mt.X s..X.X@_pYQ&|upY+&dE
&DE&DED)7.X Y@pYE<w.X
Dxt.X;wŉ5EEEU.>XtE  m.XM
u+P.XEP&DEP&DEP&D
EP
ZE.;YuYuJ&D&D&D&D3&L,\.&W&l &T*&LMt
+;r&l*X.X3Ã
Ëŋ+Ht.X
u&Dٽ.X.X+\2&L,&/Iu&l*\`  KBPUSQRWV^_ZY[]X+&D*.5Z+tZ,T+ێÊ&S+ێÊ&&G[úY|w! Lr	t+u+YTLʉLuIuËDDDV^\|uAྼYD<w<XøZøYøXøYWVQX  Y.Y.Y.Z.Z.Z.Z.ZY^_PS [X UFFt%&?	u
h&F^&? u UPFUPFÐu32PSQR 3ɺO3ZY[X   fFV
fFFtf~ t^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_ UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UP$0F<9vFFÐ  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BDD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               07/23/04BDD  