<%
//
// $Source: /usr/local/nimbus/projects/bladeime/src/hpwebadmin/webapps/ROOT/mxportal/bladeime/Attic/FolderDrillDown.jsp,v $
// $Revision: 1.1.2.21 $
// $Date: 2005/03/11 19:06:00 $
//
%>
<%@ page import="com.hp.mx.core.collectionmanager.MxCollection,
                 com.hp.mx.portal.bladeime.MonteroConstants" %>
<%@ page import="com.hp.mx.portal.ui.MxBean"%>
<%@ page import="com.hp.mx.html.table.*" %>
<%@ page import="com.hp.mx.portal.ui.MxOptions" %>

<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.Set"%>
<%@ page import="javax.swing.table.AbstractTableModel"%>

<%@ taglib uri="/com/hp/mx/taglibs/" prefix="mxtag"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session"/>
<jsp:useBean id="collectionMgmtBean" class="com.hp.mx.portal.bladeime.collectionmanagement.CollectionMgmtBean" scope="session" />
<jsp:useBean id="mxBean" class="com.hp.mx.portal.ui.MxBean" scope="session" />

<jsp:useBean id="collectionMemberTableSelectionModel" class="com.hp.mx.html.table.MxDefaultTableSelectionModel" scope="session"/>
<jsp:useBean id="collectionMemberTableView" class="com.hp.mx.html.table.MxTableView" scope="session"/>
<jsp:useBean id="collectionMemberTableController" class="com.hp.mx.html.table.MxTableController" scope="session"/>
<jsp:useBean id="monteroTree" class="com.hp.mx.portal.bladeime.MonteroTree" scope="session"/>
<%
//ISSUE0000267333 : to fix multiple user issues following appl and session objects
//are maintained which will keep track of chages to tree and changes to session.
%>
<jsp:useBean id="appobj" class="com.hp.mx.portal.bladeime.MonteroAppObj" scope="application"     />
<%!
    String url = MxOptions.URL_BASE+"/settings/Blank.html";
    public String myCollectionMembersTableDomId = "ID_MY_COLLECTION_MEMBERS_TABLE";
    private static final int MAX_ROWS = 5;
    private static final int ROW_HEIGHT = 19;
%>
<%
    MxBean.jspInit(request, response);
    loginBean.setLocale(request);

    // check to see if the loginBean session has timed out
    if (loginBean.checkLogoutConditionForWebPage(pageContext) == true)
    {
        return;
    }

    // do we need to abort?
    if (collectionMemberTableController.checkUrlForControllerMessages(request, out)) return;

    String collectionGUID = request.getParameter("collectionGUID");

    String mode = request.getParameter("mode");
    if (mode == null)
        mode = "";

    // init bean
    collectionMgmtBean.initialize(monteroTree.getResourceBundle(), loginBean, "CollectionManagement", collectionGUID);
    mxBean.initialize(loginBean, "CollectionManagement");

    // setup the display of the Repository Setup table model
    if (collectionMemberTableController.isFirstTime())
    {
        collectionMemberTableSelectionModel.setSelectionMode(MxTableSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        collectionMemberTableView.setId(myCollectionMembersTableDomId);
        collectionMemberTableView.setOnSelectionChange("mySelectionChanged");
        collectionMemberTableView.setUrlHandler(request.getRequestURI());
        collectionMemberTableController.setSelectionModel(collectionMemberTableSelectionModel);
        collectionMemberTableController.setTableView(collectionMemberTableView);
    }

    if (collectionMemberTableController.checkUrlForControllerMessages(request, out))
    {
	    return; // the table should not be modified
    }

    //same model is used for all drill downs hence clear the selection before going any further
    //if we have two drill downs, the selections need not match across them
    //
    String clearselection = request.getParameter("clearselection");
    if (clearselection != null && clearselection.equalsIgnoreCase("true") )
    {
       collectionMemberTableSelectionModel.setAllIndicesSelected(false); 
    }

    AbstractTableModel tableModel = collectionMgmtBean.getCollectionMemberTableModel();

    collectionMemberTableController.setTableModelWithSorting(tableModel);

    //  get the sorting table and tell it to sort
    //
    MxTableSortingModel sortingModel = collectionMemberTableController.getSortingModelOrNull();

    //  column #1, sortUp == true
    //
    sortingModel.sortTable(0, true);
    tableModel.fireTableDataChanged();

    boolean reloadTree = false;
    //only if finished and without errors should we refresh the tree else
    //no point rebuilding the entire tree just to show same old data.
    if ( mode.startsWith("finished") && !mode.endsWith("Error") )
    {
	reloadTree = true;
    }

    if (clearselection != null && clearselection.equalsIgnoreCase("true") && !mode.endsWith("Error") )
    {
       collectionMgmtBean.clearAllErrorMessages();
    }

    //ISSUE0000267333 Begin
    //Check if the tree requires a update
    //if treechanged_time is recent than the the tree_updated time then 
    //refresh is true 
                          
    long LastTreeChange = appobj.GetTimeOfLastChange();
    long LastTreeUpdtTime = monteroTree.GetTreeUpdateTime();
    if (LastTreeUpdtTime < LastTreeChange)
    {
       reloadTree = true;
        
    }

    //ISSUE0000267333 End
    
%>

<html>
  <head>
    <link type='text/css' rel='stylesheet' href='<%=collectionMgmtBean.getUrlBase()%>/css/MxPortal.css'>
    <link type='text/css' rel='stylesheet' href='<%=collectionMgmtBean.getUrlBase()%>/css/MxPortalEx.css'>
    <link type='text/css' rel='stylesheet' href='css/MonteroTable.css'>
<%
    Set members = null;
    MxCollection collection = null;
    String collectionName = "";

    if (collectionGUID != null && collectionGUID.length() > 0)
    {
        try{
        collection = collectionMgmtBean.getCollection(collectionGUID);
        }
        catch(Exception e)
        {
          %>
                          <script language='javascript'>
                          MonteroDataPane.contentWindow.document.location.replace("<%=MxOptions.URL_BASE%>/bladeime/MoRedirectToHome.jsp?nodeId=" + encodeURIComponent("<%=collectionGUID%>")");
                          </script>
         <%
        }
    }

    if (collection != null)
    {
        collectionName = collection.getName();
        members = collection.getMemberObjectList();
        if (members != null)
        {
            Iterator iter = members.iterator();
            {
                if (iter.hasNext())
                {
                     int numRows = collectionMgmtBean.getNumberOfTableRows();
                     int height = MAX_ROWS * ROW_HEIGHT;
                     if (numRows < MAX_ROWS)
                     {
                         height = (numRows +1) * ROW_HEIGHT;
                     }
                     collectionMemberTableView.setHeight(new Integer(height).toString());
                     collectionMemberTableView.setWidth("500");
                     collectionMemberTableView.dumpHeadContent(out);
                }
            }
        }
    }
%>

    <SCRIPT src="<%=MxOptions.URL_BASE%>/js/MxPortalApi.js" language="JavaScript" type="text/javascript"></SCRIPT>
    <SCRIPT src="<%=MxOptions.URL_BASE%>/js/utilities.js" language="JavaScript" type="text/javascript"></SCRIPT>
    <script src="<%=MxOptions.URL_BASE%>/js/MxBrowser.js" language="JavaScript" type="text/javascript"></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/Montero.js"></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/dataPageHelpers.js"></script>
    <script language="javascript" type="text/javascript">

    //
    // Called when the page is loaded to initially enable/disable the buttons
    //
    function onLoad()
    {
	MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_collectionMemMgmt");
        checkRequiredFields();
    }

    //
    // the function called to perform selection change, including
    // retrieval of new repository catalog
    //
    function mySelectionChanged(szIdTable, iRow, bSelected)
    {
        checkEnableRemoveMembersButton();
    }


    function checkRequiredFields()
    {
<%
        // If we don't have a valid collection, disable
        // all the buttons, else enable the rename button
        if (collection != null)
        {
%>
            checkEnableRenameCollectionButton();
            checkEnableRemoveMembersButton();
            checkEnableDeleteCollectionButton();
<%
        }
        else
        {
%>
           disableMxButtonElement("renameButton");
           disableMxButtonElement("removeButton");
           disableMxButtonElement("deleteButton");
<%
        }
%>
    }


	//
    // Enable or disable the Rename Collection button
    //
	function checkEnableRenameCollectionButton()
    {
<%
		if ((collection != null && (collection.getEditFlags() & MxCollection.COLLECTION_EDIT_FLAG_CANNOT_EDIT) == 0))
        {
%>
                enableMxButtonElement("renameButton");
<%
        }
%>
    }



    //
    // Enable or disable the Remove Members button
    //
    function checkEnableRemoveMembersButton()
    {
<%
		//this should be removed for non editable collections also should it not?
		if (members != null && members.size() > 0)
        {
%>
            var aSel = MxTableGetSelections("<%= myCollectionMembersTableDomId %>");
            if (aSel.length > 0)
                enableMxButtonElement("removeButton");
            else
                disableMxButtonElement("removeButton");
<%
        }
%>
    }

    //
    // Enable or disable the Delete Collection button
    //
    function checkEnableDeleteCollectionButton()
    {
<%
		if ( (members == null || members.size() == 0) && (collection != null && (collection.getEditFlags() & MxCollection.COLLECTION_EDIT_FLAG_CANNOT_DELETE) == 0))
        {
%>
            enableMxButtonElement("deleteButton");
<%
        }
        else
        {
%>
            disableMxButtonElement("deleteButton");
<%
        }
%>
    }


    //
    // the function called to rename the collection
    //
    function renameCollection()
    {
        var el = document.getElementById("clickedBtnName");
        if (el != null)
        {
           el.value = "Rename";
        }
        var iFrame1 = document.getElementById("operationDetailInfo");
        if (iFrame1 != null)
        {
            //ISSUE0000267333 ExistingColName parameter is added
            iFrame1.contentWindow.document.location.replace("<%=MxOptions.URL_BASE%>/bladeime/collectionmanagement/RenameFolder.jsp?ExistingColName=" + encodeURIComponent("<%=collectionName%>"));

        }
    }

    //
    // the function called to remove selected members from
    // the collection
    //
    function removeMembers()
    {
        var aSel = MxTableGetSelections("<%= myCollectionMembersTableDomId %>");
        var el = document.getElementById("clickedBtnName");

        if (el != null)
        {
            el.value = "Remove";
        }

        var actionString = "FolderDrillDown.jsp?collectionGUID=<%= collectionGUID %>";
        document.collectionDataPaneForm.action= actionString;

        disableMxButtonElement("removeButton");
        document.collectionDataPaneForm.submit();
    }

    function getCollectionGUID()
    {
        return "<%= collectionGUID %>";
    }


    //
    // the function called to delete the empty collection
    //
    function deleteCollection()
    {
<%
        if (members == null || members.size() == 0)
        {
%>
            var el = document.getElementById("clickedBtnName");
             if (el != null)
             {
                 el.value = "Delete";
             }

             document.collectionDataPaneForm.submit();
<%
        }
%>
    }
    </script>
    <script>
    function reloadTree()
    {
    refreshTree('reload');
    }
    </script>
  </head>

  <body onload="onLoad()">
<%
//ISSUE0000267333 Begin
    if ( reloadTree )
    {
       out.println("<script>");
       out.println("refreshTree(\"reload\")");
       out.println("</script>");
    }
//ISSUE0000267333 end    

    ///////////////////////////////////////////////////////////////////////////
    // IS THIS A POST?  Check data validity and redirect
    ///////////////////////////////////////////////////////////////////////////
    if (request.getMethod().equals("POST"))
    {
        String clickedBtnNameValue = "";
        //clear all earlier messages for the new operation.
	collectionMgmtBean.clearAllErrorMessages();

        // YES! Determine which button was pressed
        clickedBtnNameValue = request.getParameter("clickedBtnName");

        if (clickedBtnNameValue.equalsIgnoreCase("Rename"))
        {
            // call bean to rename the collection
            url = MxOptions.URL_BASE + "/bladeime/collectionmanagement/RenameFolder.jsp";
%>
            <script language="javascript">
              MxPortalWorkspaceSetTitleHtml('<%=monteroTree.getResourceBundle().rb.getString("collectionMemberTable.renameButton")%>');
            </script>
<%
           return;
        }
        else if (clickedBtnNameValue.equalsIgnoreCase("Remove"))
        {
            // Call bean to remove selected members from collection
            int selectedRows [] = collectionMemberTableSelectionModel.getSelectedIndices();
            String remError = collectionMgmtBean.removeMembers(selectedRows);
            boolean error = collectionMgmtBean.hasErrorMessages();
            out.println("<script>");
    	    if ( error )
            {
                out.println("document.location.replace('FolderDrillDown.jsp?collectionGUID="+collection.getObjectID().getGUID().toString()+"&clearselection=true&mode=finishedremoveError');");
            }
            else
            {
                //ISSUE0000267333
                appobj.TreeChanged();
                out.println("document.location.replace('FolderDrillDown.jsp?collectionGUID="+collection.getObjectID().getGUID().toString()+"&clearselection=true&mode=finishedremove');");
       	    }
            out.println("refreshTree("+"\""+remError+"\""+")");
            out.println("</script>");
        }
        else if (clickedBtnNameValue.equalsIgnoreCase("Delete"))
        {
            // Call bean to delete the collection
            collectionMgmtBean.deleteCollection();
    	    boolean error = collectionMgmtBean.hasErrorMessages();
            out.println("<script>");
            error = false;
	        if ( error )
	    	out.println("document.location.replace('FolderDrillDown.jsp?mode=finishedDeleteError');");
	        else {
	        //ISSUE0000267333
            appobj.TreeChanged();
	        out.println("document.location.replace('FolderDrillDown.jsp?mode=finishedDelete');");
	    	}
            out.println("</script>");
        }
    }
%>

    <div class="errorTextBold">
<%
        // Display any error messages
        if (collectionMgmtBean.hasErrorMessages())
        {
            // Display plurally-correct label
            if (collectionMgmtBean.getErrorMessageList().size() == 1)
            {
                %><%= monteroTree.getResourceBundle().rb.getString("error.single")%><BR><%
            }
            else
            {
                %><%= monteroTree.getResourceBundle().rb.getString("error.multiple")%><BR><%
            }

            // Finally, display the error message(s)
            collectionMgmtBean.displayErrorMessagesInHtml(out, "errorTextBold");
        }
%>
    </div>
<%
    ///////////////////////////////////////////////////////////////////////////
    // THIS IS NOT A POST - Display normally
    ///////////////////////////////////////////////////////////////////////////

    if (mode.equals("finishedDelete") && !collectionMgmtBean.hasErrorMessages())
    {
        //This is not required to be shown as per specs.
        out.println(monteroTree.getResourceBundle().rb.getString("collectionManagement.deleteSuccess") + "<br><br>");
    	monteroTree.setLastDrilldownObjectID(null);
	    out.println("<script>");
        out.println("refreshTree(\"reload\");");
        out.println("document.location.replace('MonteroHomePage.jsp');");
        out.println("</script>");
	//backed out the forwarding to home page as it was not possible to reload tree and also redirect to 
	//home page without other changes. 
	//TODO need to fix the forward to home page as part of the other rQM
    }
    else
    {
        if(collectionName.equalsIgnoreCase("Physical View"))
            collectionName = monteroTree.getResourceBundle().rb.getString("PHYSICAL_VIEW");
        else if(collectionName.equalsIgnoreCase("Logical View"))
            collectionName = monteroTree.getResourceBundle().rb.getString("LOGICAL_VIEW");
            
%>
		<div class='title-name'><%= collectionName %></div><br/>
		<script>
			startDataSection("<%=monteroTree.getResourceBundle().rb.getString("collectionMemberTable.sectionHeader.Members")%>");
			endDataSection();
		</script>
<%
    }


    if (members != null && members.size() > 0)
    {
        Iterator iter = members.iterator();
        {
            if (iter.hasNext())
            {
                // Display the table
                 collectionMemberTableView.dumpWholeTable(out);
            }
        }
    }
    else if (collection != null)
    {
        // Display a message indicating there are no members in the table
        out.println(monteroTree.getResourceBundle().rb.getString("collectionMemberTable.noMembersText") + "<br><br>");
    }
    else if (!mode.equals("finishedDelete"))
    {
%>
        <div class="errorTextBold">
<%
        // Collection is null - display error message
        out.println(monteroTree.getResourceBundle().rb.getString("collectionMemberTable.invalidCollectionText") + "<br><br>");
%>
        </div>
<%
    }
%>

	<br><br>
        <div align="right">
        <form id="collectionDataPaneForm" name="collectionDataPaneForm" action="FolderDrillDown.jsp?collectionGUID=<%= collectionGUID %>" method="post">
            <br><br>
            <input type="button" class="mx-button-disabled" value="<%= monteroTree.getResourceBundle().rb.getString("collectionMemberTable.removeButton") %>" id="removeButton" disabled style="width:125px;" onClick="removeMembers()">
            <input type="button" class="mx-button-disabled" value="<%= monteroTree.getResourceBundle().rb.getString("collectionMemberTable.renameButton") %>" id="renameButton" disabled style="width:125px;" onClick="renameCollection()">
            <input type="button" class="mx-button-disabled" value="<%= monteroTree.getResourceBundle().rb.getString("collectionMemberTable.deleteButton") %>" id="deleteButton" disabled style="width:125px;" onClick="deleteCollection()">
            <input type="hidden" id="clickedBtnName" name="clickedBtnName">
        </form>
        </div>

<%
    if (collection != null && (collectionName.equalsIgnoreCase(monteroTree.getResourceBundle().rb.getString("PHYSICAL_VIEW")) ||
       collectionName.equalsIgnoreCase(monteroTree.getResourceBundle().rb.getString("LOGICAL_VIEW"))))
    {
    }
    else
    {
%>
	<p>
		<script>
			startDataSection("<%=monteroTree.getResourceBundle().rb.getString("collectionMemberTable.sectionHeader.MemberOf")%>");
			endDataSection();
		</script>
    </p>
	<!-- H.Tokita
	<a href="javascript:void(0);" onclick="window.open('collectionmanagement/SaveInCollection.jsp?selectionType=collectionName&selectionId=<%= collectionName %>', 'AddToCollection', 'width=650, height=250, status=yes');"><%= monteroTree.getResourceBundle().rb.getString("collectionAdd.collectionLink")%></a><br><br>
-->

    <script>
      var html = "<a href=\"javascript:void(0);\" " +
                 "onclick=\"window.open('collectionmanagement/SaveInCollection.jsp?selectionType=collectionName&selectionId=" +
                 encodeURIComponent("<%= collectionName %>") +
                 "', 'AddToCollection', 'width=650, height=250, status=yes');\">" +
                 "<%= monteroTree.getResourceBundle().rb.getString("collectionAdd.collectionLink")%></a><br><br>";
      document.writeln(html);
    </script>
<!-- H.Tokita-->
	
    <%
    }
%>

    <iframe id="operationDetailInfo" style="width:100%; height:800; position:relative; visibility:visible"
            scrolling="no" marginwidth="0" frameborder="0" src="<%=url%>">
    </iframe>

<%
    if (collectionMgmtBean.hasSasServerPoolMgmtPage())
    {
    %>
        <jsp:include flush="" page="<%= collectionMgmtBean.getServerPoolMgmtPage() %>">
        </jsp:include>
    <%
    }
%>

  </body>
</html>
