<%@ page import="javax.swing.tree.*" %>
<%@ page import="java.util.EventListener" %>

<%@ page import="com.hp.mx.core.client.MxQueryClient" %>
<%@ page import="com.hp.mx.core.querymanager.*" %>
<%@ page import="com.hp.mx.portal.tree.MxTreeDataModel" %>
<%@ page import="com.hp.mx.portal.tree.MxTreeInstance" %>
<%@ page import="com.hp.mx.portal.tree.TreeViewSelectionListener" %>
<%@ page import="com.hp.mx.html.tree.MxDefaultTreeExpansionModel" %>
<%@ page import="com.hp.mx.html.tree.MxTreeController" %>
<%@ page import="com.hp.mx.html.tree.MxTreeView" %>
<%@ page import="com.hp.mx.html.tree.MxTreeSelectionModel" %>
<%@ page import="com.hp.mx.portal.core.*" %>
<%@ page import="com.hp.mx.portal.ui.*" %>
<%@ page import="javax.swing.tree.DefaultTreeSelectionModel" %>
<%@ page import="com.hp.mx.portal.bladeime.*" %>

<jsp:useBean id="loginBean"
             class="com.hp.mx.portal.ui.MxLoginBean"
             scope="session" />
<jsp:useBean id="treeInstanceManager"
             class="com.hp.mx.portal.tree.MxTreeInstanceManager"
             scope="session" />
<jsp:useBean id="monteroTree" class="com.hp.mx.portal.bladeime.MonteroTree"
             scope="session"     />
<%
    // REQUIRED: This line is rquired by Tomcat for i18n support.
    // rQm: 262545
    //
    MxBean.jspInit(request, response);

    response.setHeader("cache-control", "no-store") ;

    //  Get the lastUpdated time
    //
    String lastUpdatedTime = request.getParameter("lastUpdate") ;
    if( lastUpdatedTime != null )
    {
        out.println("<html><body></body></html>") ;

        monteroTree.setLastUpdatedTime(lastUpdatedTime) ;


        return ;
    }

    //  Instantiate the tree instance with the
    //  tree instance manager
    //
    String timeStamp = monteroTree.getTimeStamp() ;

    if( timeStamp == null )
    {
        timeStamp = treeInstanceManager.initTreeInstance() ;

        monteroTree.setTimeStamp(timeStamp) ;
    }


    //  Get the tree instance with the resulting time stamp
    //
    //  amgk : why can't I just make it a session-bean
    //         and call the initTreeDataBeans() method on it
    //  amgk : 17-aug-2004 : that should be done ASAP
    //
    MxTreeInstance treeInstance = (MxTreeInstance) treeInstanceManager.
                                                       getInstance(timeStamp) ;

    if( treeInstance == null )
    {
        out.println("<html><body>") ;
        out.println("<p>"+monteroTree.getResourceBundle().rb.getString("TREE_FAILED1")+"<br>") ;
        out.println("</body></html>") ;

        return ;
    }

    //  Get the beans in the treeInstanceObject
    //
    MxTreeView treeView = treeInstance.getTreeViewBean();
    MxDefaultTreeExpansionModel expansionModel = treeInstance.
                                                 getDefaultTreeExpansionModel();
    MxTreeController controller = treeInstance.getTreeController();

    TreeViewSelectionListener treeViewSelectionListener = treeInstance.
                                                 getTreeViewSelectionListener();

    MxTreeDataModel treeData = monteroTree.getTreeDataModel() ;
    
    MxTreeSelectionModel selMdl = null;

    //  call a synchronized method, so that the actions
    //  of modifying the expn/seln/GSL models are synchronized
    //  throughout Montero
    //
    if( monteroTree.handleTreeEvents(controller, request, out) )
        return ;

    //  Get the queryId
    //
    String queryId = request.getParameter("queryId");
    if( queryId == null )
    {
        queryId =  String.valueOf(monteroTree.getAllRacksQueryId()) ;
    }

    String  reloadTreeVal = request.getParameter("reload")  ;
    boolean reloadTree    = reloadTreeVal != null           ;

    if( controller.isFirstTime() || reloadTree )
    {

        //  call a synchronized method, so that the actions
        //  of modifying the expn/seln/GSL models are synchronized
        //  throughout Montero, including with MonteroLaunchTools.jsp
        //
        monteroTree.clearExpnMdlSelMdlGSL(treeInstance) ;

/********************************************
        //  clear the expansion and selection models
        //
        expansionModel.clearExpansion()                  ;
        monteroTree.getSelectionModel().clearSelection() ;

        //  clear the selection bean - either if the tree is
        //  reloaded using the "Updated" link or the tree is
        //  reloaded using the SIM Menu link
        //  
        //  this may need to be synchronized/work-in-conjunction with
        //  the MonteroLaunchTools.jsp actions
        //
        loginBean.getSelectionBean().clearEverything() ;

**********************************************/

        //  if the reloadTreeVal == menu i.e. the menu has been invoked,
        //  then clear off the lastObjectID, and the lastTabSelected,
        //  so that the home page would be displayed
        //
        if( "menu".equals(reloadTreeVal) )
        {
            monteroTree.setLastDrilldownObjectID(null) ;
            monteroTree.setLastSelectedTab(null)       ;
        }
        //ISSUE0000267333
        monteroTree.SetTreeUpdateTime();
        
        //  create the collections if not already created
        //
        monteroTree.setupBladeSystemCollections() ;

        //  enable debug
        //
        // monteroTree.setDevDebug(true) ;
        // ((MonteroTreeDataModel)treeData).setDevDebug(true) ;

        //  initialize and re-build the BladeSystem tree
        //
        treeData.initDataTree(loginBean, queryId) ;

         String encQueryId = request.getParameter("encQueryId");
	 
       	   if( encQueryId == null )
       	   {
       	  
       	  	  encQueryId =  String.valueOf(monteroTree.getAllEnclosuresQueryId()) ;
       	       	         	        
       	       	      
       	     	  ((MonteroTreeDataModel)treeData).appendCciEncQueryInPvTree(loginBean, encQueryId);       
       	         	       	      
          }

        if( treeData.getTree() == null )
        {
            out.println("<html><body>") ;
            out.println("<br>"+monteroTree.getResourceBundle().rb.getString("TREE_FAILED2")+"<br>") ;
            out.println("</body></html>") ;

            return ;
        }

        treeView.setId("ID_MONTERO_TREE") ;
        treeView.setUrlHandler(request.getRequestURI() + "?timeStamp=" +
                               timeStamp) ;

        treeView.setOnChange("monteroSelectionChanged")        ;
        treeView.setFlyOverHandler("flyOverHandler")           ;
        treeView.setFlyOverClearHandler("flyOverClearHandler") ;
        treeView.setSystemDrillDownHandler("loadDrillDown")    ;

        controller.setExpansionModel(expansionModel);
        controller.setTreeView(treeView);

        //  Nimbus pages will use loginBean.getLocale() here:
        //
        controller.setLocale(request.getLocale()) ;

        //  set the selection model in the controller
        //
        selMdl = monteroTree.getSelectionModel() ;
        controller.setSelectionModel(selMdl) ;

        // treeView.setContainerSelectable(true)     ;  -- based on Kyu's advice
        controller.setTreeModel(treeData.getTree())  ;

        //  set only one listener ever
        //
        EventListener[] currentListeners = selMdl.getTreeSelectionListeners();
        if( currentListeners.length == 0 )
        {
            selMdl.addTreeSelectionListener(treeViewSelectionListener);
            treeViewSelectionListener.setLoginBean(loginBean);
        }

        //  initialize the monteroTree bean's TREE field
        //
        monteroTree.setTree(treeData.getTree()) ;
    }


    if( treeData == null )
    {
        out.println("<html><body>") ;
        out.println("<br>"+monteroTree.getResourceBundle().rb.getString("TREE_FAILED2")+"<br>") ;
        out.println("</html></body>") ;

        return ;
    }

    if( treeData.getTree() == null )
    {
        out.println("<html><body>") ;
        out.println("<br>"+monteroTree.getResourceBundle().rb.getString("TREE_FAILED2")+"<br>") ;
        out.println("</html></body>") ;

        return ;
    }

%>

<HTML>
<HEAD>
    <TITLE>BladeSystem Tree</TITLE>

    <script src="<%=MxOptions.URL_BASE%>/js/MxPortalApi.js"
            language="JavaScript" type="text/javascript">
    </script>

    <script src="js/Montero.js" language="JavaScript" type="text/javascript">
    </script>

    <script src="js/MoTree.js"  language="JavaScript" type="text/javascript">
    </script>

    <link type='text/css' rel='stylesheet'
          href='<%=MxOptions.URL_BASE%>/css/MxPortal.css'>

    <script>
    var Wdays   = [<%="\""+monteroTree.getResourceBundle().rb.getString("SUN")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("MON")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("TUE")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("WED")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("THU")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("FRI")+"\""%>,
                   <%="\""+monteroTree.getResourceBundle().rb.getString("SAT")+"\""%>];


        function montDateFormat(format)
        {
            var o          = format     ;
            var t          = new Date() ;

            //  %a = 3 letters of the day of the week
            //
            o = o.replace( new RegExp("%a", "gi"), new String(Wdays[t.getDay()] ) );

            //  %D = yyyy/mm/dd
            //
            var mon = "" + (t.getMonth() + 1);

            if ( mon.length == 1)
               mon = "0" + mon;

            var day = "" + t.getDate();
            if ( day.length == 1)
               day = "0" + day;

            var D = t.getFullYear() + "/" + mon + "/" + day ;
            o = o.replace(new RegExp("%D", "gi"), D) ;

            //  %l - 1-12 hrs
            //
            var h = t.getHours() ;

            o =  o.replace(new RegExp("%l", "gi"), h) ;

            //  %M :: minutes 0-59
            //
            var mm = new String(t.getMinutes()) ;
            if( mm.length == 1 )
                mm = "0" + mm ;
            o =  o.replace(new RegExp("%M", "gi"), mm) ;


            //  %S :: seconds 0-59
            //
            o =  o.replace(new RegExp("%S", "gi"), t.getSeconds()) ;

            //  timezone -- not done ??

            return o ;
        }

     function storeLastUpdatedTime(lastUpd)
     {
         var   updUrl  ;

         if( lastUpd == "null" || lastUpd == null )
         {
             lastUpdate = montDateFormat(" %D (%a) %l:%M ")                 ;
             updUrl     = "MonteroTree.jsp"  +  "?lastUpdate="  +   encodeURIComponent(lastUpdate) ; 


             document.getElementById("mTreeCmd").src = updUrl ;
         }
         else
             lastUpdate = lastUpd ;

         return ;
     }

      function toolbar_reload_message(){
      return (<%="\""+monteroTree.getResourceBundle().rb.getString("TOOLBAR_MESSAGE_RELOAD")+"\""%>);
      }

      function toolbar_updt_dpane(){
      return(<%="\""+monteroTree.getResourceBundle().rb.getString("TOOLBAR_MESSAGE_UPDT")+"\""%>);
      }

      function toolbar_reload_dpane(){
      return (<%="\""+monteroTree.getResourceBundle().rb.getString("TOOLBAR_MESSAGE_RELDT")+"\""%>);
      }

      function montero_reload(){
      return (<%="\""+monteroTree.getResourceBundle().rb.getString("UPDATING_EVERY_MINUTE")+"\""%>);
      }
    </script>
    
    <% treeView.dumpHeadContent(out); %>
</HEAD>

<BODY onload='setTimeout("updateTreeView(<%=monteroTree.getTimeStamp()%>)", 120000)'>   <!-- 120s = 2min -->

    <form id='FORM_ID_MONTERO_DATAPANE'
          method='get'
          action='/mxportal/bladeime/MonteroDataPane.jsp'
          target='MonteroDataPane'
          style='display:none'>
    </form>

    <IFRAME ID="mTreeCmd"
        NAME="mTreeCmd"
        SRC="<%=MxOptions.URL_BASE%>/home/MxBlank.html"
        FRAMEBORDER=0 height=0 width=0>
    </IFRAME>

    <%
    if( reloadTree == true )
    {
        out.println("<script>")         ;
        out.println("reloadDataPane()") ;
        out.println("</script>")        ;
    }
    %>

    <script>
        document.write("<p  style=\"white-space:nowrap\">")   ;
    </script>

    <a href="javascript:updateTree()"
       title="<%= monteroTree.getResourceBundle().rb.getString("TREE_UPDATED_LNK")%>">
       <%= monteroTree.getResourceBundle().rb.getString("TREE_UPDATED_LNK_LABEL")%></a>

    <%
       lastUpdatedTime =  monteroTree.getLastUpdatedTime(reloadTree) ;
    %>

    <script>
        storeLastUpdatedTime("<%=lastUpdatedTime%>")   ;
        document.write(lastUpdate)                     ;
        document.write("</p>")                         ;
    </script>


<table>
  <tr>
    <td valign="top">

      <%
         //  Process the tree for any Montero specific changes
         //     the tree is already set in the monteroTree bean
         //     by monteroTree.setTree() above
         //
         if( monteroTree.getDevDebug() )
             System.out.println("TREE prepr = " + treeData.getTree()) ;

         monteroTree.preProcessTree(
                (DefaultMutableTreeNode)monteroTree.getTree().getRoot()) ;
                
         monteroTree.FilterNodeforCciEnc((DefaultMutableTreeNode)monteroTree.getTree().getRoot()) ;      

         treeView.dumpExpansionButtons(out) ;
         treeView.dumpTree(out) ;
      %>

    </td>
  </tr>
</table>


<IFRAME ID="statusComm"
        NAME="statusComm"
        SRC="<%=MxOptions.URL_BASE%>/home/MxBlank.html"
        FRAMEBORDER=0 height=0 width=0>
</IFRAME>

<%--
    System.out.println("GSL length = " +
                       loginBean.getSelectionBean().getNodes().size()) ;
--%>



</BODY>
</HTML>
