<%-- ---------------------------------------------------------------------- --%>
<%--  Put all your Java imports here                                        --%>
<%-- ---------------------------------------------------------------------- --%>

<%@ page import="com.hp.mx.core.subjects.*,
                 com.hp.mx.portal.bladeime.MonteroConstants" %>
<%@ page import="com.hp.mx.portal.core.*" %>
<%@ page import="com.hp.mx.portal.ui.*" %>

<%-- ---------------------------------------------------------------------- --%>
<%--  Put all your taglib imports here                                      --%>
<%-- ---------------------------------------------------------------------- --%>

<%@ taglib uri="/com/hp/mx/taglibs/" prefix="mxtag" %>

<%-- ---------------------------------------------------------------------- --%>
<%--  Create all your beans here                                            --%>
<%-- ---------------------------------------------------------------------- --%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="selectionBean" class="com.hp.mx.portal.core.MxObjSelections" scope="session" />
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="deviceBean" class="com.hp.mx.portal.device.MxDeviceBean" scope="page" />
<jsp:useBean id="bpvBean" class="com.hp.mx.portal.bladeime.bpv.MxBPV" scope="page" />
<jsp:useBean id="rbBPV" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="bpvBladeSystemBean" class="com.hp.mx.portal.bladeime.bpv.BPVBladeSystemBean" scope="page" />

<%-- ---------------------------------------------------------------------- --%>
<%--  Put one block of initialization Java code here                        --%>
<%--  In general, keep Java code to a minimum. Put Java code into JavaBeans.--%>
<%-- ---------------------------------------------------------------------- --%>

<%
    // REQUIRED: Set necessary HTTP header attributes (for localization
    // and page caching)
    MxBean.jspInit(request, response);

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
        return;

    // EXAMPLE: follow references to this bean for i18n support using resource bundles
    rbPortal.init(loginBean, "MxPortal");

    //
    // These are the localized strings for this JSP.
    //
    rbBPV.init(loginBean, "MxBPV");
%>

<%-- ---------------------------------------------------------------------- --%>
<%--  From here on, this is a well-formed HTML file                         --%>
<%-- ---------------------------------------------------------------------- --%>

<html>

<%-- ---------------------------------------------------------------------- --%>
<%--  The HEAD block contains meta tags, the TITLE, style sheet links,      --%>
<%--  JavaScript links, and JavaScript code.                                --%>
<%-- ---------------------------------------------------------------------- --%>

<head>

<%-- ---------------------------------------------------------------------- --%>
<%--  REQUIRED: This line is required by the browser for i18n support.      --%>
<%-- ---------------------------------------------------------------------- --%>

<meta http-equiv="content-type" content="text/html; charset=UTF-8">

<%-- ---------------------------------------------------------------------- --%>
<%-- Refresh the page every 30 seconds.                                     --%>
<%-- ---------------------------------------------------------------------- --%>
<meta http-equiv="refresh" content="180">

<%-- ---------------------------------------------------------------------- --%>
<%--  Most pages can get away with no title, because they are displayed     --%>
<%--  inside of a frame.                                                    --%>
<%-- ---------------------------------------------------------------------- --%>

<title></title>

<%-- ---------------------------------------------------------------------- --%>
<%--  Put all UI component head blocks here (these consist of style sheets  --%>
<%--  and JavaScript links)                                                 --%>
<%-- ---------------------------------------------------------------------- --%>

<% MxPortalRender.dumpHeadContent(out); %>

<%-- ---------------------------------------------------------------------- --%>
<%--  Any additional style sheets links go here                             --%>
<%-- ---------------------------------------------------------------------- --%>

<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxTools.css'>

<%-- ---------------------------------------------------------------------- --%>
<%--  Any additional JavaScript links go here                               --%>
<%-- ---------------------------------------------------------------------- --%>

<%--  COMMONLY USED: This includes the browser-based portal API --%>
<script src="<%=MxOptions.URL_BASE%>/js/MxPortalApi.js" language="JavaScript" type="text/javascript"></script>

<script src="<%=MxOptions.URL_BASE%>/js/MxBrowser.js" language="JavaScript" type="text/javascript"></script>

<%-- ---------------------------------------------------------------------- --%>
<%--  Put all additional JavaScript here                                    --%>
<%-- ---------------------------------------------------------------------- --%>

<script language="JavaScript" type="text/javascript">

function myOnLoad()
{
    MxPortalWorkspaceSetHelpTopic("monitor_system_nav_containerView");

    setTimeout("myOnResize()", 500);
}

function myOnResize()
{
    resize_w();
    resize_h();
}

function resize_w()
{
    //var w = Math.max(0, MxBrowserGetBodyWidth(0, 0));
    //MxTreeSetWidth("ID_TOOLS_TREE", w);
}

function resize_h()
{
    //var h_total = Math.max(0, MxBrowserGetBodyHeight(0, 0));
    //var h_tabs = document.getElementById("ID_TABS").offsetHeight;
    //var h_top = document.getElementById("TOP_PART").offsetHeight;
    //var h = Math.max(0, h_total - h_tabs - h_top);

    //MxTreeSetHeight("ID_TOOLS_TREE", h);
}

function getNumSelections()
{
    var count = 0;
    var mainTable = document.getElementById("MainTable");
    var elements = mainTable.getElementsByTagName("input");
    for (var i = 0; i < elements.length; i++)
    {
        if (elements[i].checked)
            count++;
    }
    return count;
}

function toggleNodeSelection(chkbox, szGuidServer, szGuidRootContainer)
{
    //
    // Note: Do not call more than one of the MxPortalNodes APIs at a time!
    // Each call takes 1/10 of a second or so to actually perform, and
    // calling another API before the work is done for the first one
    // can cause problems.
    //
    if (chkbox.checked)
    {
        if (getNumSelections() == 1)
        {
            //
            // Set the given server as the one-and-only selected device,
            // removing the root container from the selection list.
            //
            MxPortalNodesSetNode(szGuidServer);
        }
        else
        {
            //
            // Add the given server to the selection list.
            //
            MxPortalNodesAddNode(szGuidServer);
        }
    }
    else
    {
        if (getNumSelections() == 0)
        {
            //
            // Re-select the root container as the one-and-only
            // selected node, since no servers are selected.
            //
            MxPortalNodesSetNode(szGuidRootContainer);
        }
        else
        {
            //
            // Remove the given server from the selection list.
            //
            MxPortalNodesRemoveNode(szGuidServer);
        }
    }
}

function onViewChange(e)
{
    if (e.value != "")
    {
        document.location.replace(e.value);
    }
}

</script>

<STYLE type="text/css">
    <!--
        .noBladeBorder {border:thin outset 1px #CCCCCC;}
        .rackOutsideBorder {border-width:4 2 3 4; border-style:solid; border-color :black}
        .blade {margins:0px; border-width:0px; border-style:outset; border-color : White Black Black White; text-align:center; vertical-align:bottom;}
        .statusIcon {margin-bottom:6px; border-width:0px; text-align:center; vertical-align:bottom;}
        .powerSupply {border-width:1px; border-style:outset; border-color : #666666; text-align:center;}
        .switch {border-width:1px; border-style:solid; border-color : #000000;}
        .myTd {font:8pt verdana; text-align:center; vertical-align:top; text-align:left;}
    -->
</STYLE>

</head>

<%-- ---------------------------------------------------------------------- --%>
<%--  The HEAD block ends here                                              --%>
<%-- ---------------------------------------------------------------------- --%>

<%-- ---------------------------------------------------------------------- --%>
<%--  The BODY block begins here                                            --%>
<%-- ---------------------------------------------------------------------- --%>

<body class="tools-body" onLoad="myOnLoad()" onResize="myOnResize()">
<div class="body-proxy" id="ID_BODY_PROXY">

<%--  communication frame  --%>
<iframe id="ID_COMM_SERVER" style="display:none" src="MxBlank.html"></iframe>

<%
    //
    // Initialize the BPV bean.
    //
    if (!bpvBean.initialize(request.getParameter("target"), loginBean, selectionBean))
    {
%>
        <br><br><center><font color="#cc0000"><%=rbBPV.get("error.ContainerNoLongerExists")%></font></center>
<%
    }
    else
    {
%>
   
<br>
<table ID="MainTable" cellSpacing="0" cellPadding="0" align="center" border="0">
    
    <tr vAlign="top">
        <td>
<%
            //
            // Render the rack or enclosure.
            //
            bpvBean.render(out,monteroTree.getResourceBundle());
%>
        </td>
        <td>
            <%-- White space between the rack/enclosure and the legend --%>
            &nbsp;&nbsp;&nbsp;
        </td>
        <td>
            <%-- The legend --%>
            <table class="myTd" cellSpacing="2" cellPadding="0" border="0">
                <tr>
                    <td colSpan="2">
                        <b><%=monteroTree.getResourceBundle().rb.getString("legend.title")%></b>
                    </td>
                </tr>
<% if( bpvBean.isRackBPV() )
{
%>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="blade" width="18" background="/mxportal/images/IceBladeButton1.gif" height="40">
                                    &nbsp;
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.Server")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="noBladeBorder" width="18" background="/mxportal/images/spg_black.gif" height="40">&nbsp;</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.NoServerIdentified")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="switch" width="18" background="/mxportal/images/switch.gif" height="40">&nbsp;</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.Interconnect")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="noBladeBorder" width="18" background="/mxportal/images/switchEmpty.gif" height="40">&nbsp;</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.NoInterconnectIdentified")%>
                    </td>
                </tr>
<%
}
if( bpvBean.isPowerEnclosureBPV() )
{
%>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="powerSupply" width="18" background="/mxportal/images/spg_dkGray.gif" height="40"><IMG src="../images/Lbolt.gif" align="absMiddle" width="18"></td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.PowerSupplyEnclosure")%>
                    </td>
                </tr>
<%
}
%>
            </table>
        </td>
    </tr>
</table>

</div>
<%
    }
%>
</body>

<%-- ---------------------------------------------------------------------- --%>
<%--  The BODY block ends here                                              --%>
<%-- ---------------------------------------------------------------------- --%>

</html>
