<%
//
// $Source: /usr/local/nimbus/projects/bladeime/src/hpwebadmin/webapps/ROOT/mxportal/bladeime/Attic/SwitchView.jsp,v $
// $Revision: 1.1.2.25 $
// $Date: 2005/03/10 19:19:11 $
//
%>
<%@ page import="com.hp.mx.portal.ui.*" %>
<%@ page import="com.hp.mx.utilities.MxCMS" %>
<%@ taglib uri="/com/hp/mx/taglibs/" prefix="mxtag"%>
<%@ page import="com.hp.mx.core.nodemanager.*"%>
<%@ page import="com.hp.mx.core.client.*"%>
<%@ page import="com.hp.mx.core.objectmodel.MxGUID"%>
<%@ page import="com.hp.mx.core.objectmodel.MxObjectID"%>
<%@ page import="java.util.List"%>
<%@ page import="com.hp.mx.portal.bladeime.*"%>
<%@ page import="com.hp.mx.core.toolmanager.MxTool"%>
<%@ page import="com.hp.mx.portal.bladeime.MonteroConstants"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session"/>
<jsp:useBean id="deviceBundle" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="drillDown" class="com.hp.mx.portal.core.MxDrillDown" scope="session" />
<jsp:useBean id="actionMgr" class="com.hp.mx.portal.core.MxActionMgr" scope="session" />
<jsp:useBean id="rbColl" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="deviceBean" class="com.hp.mx.portal.device.MxDeviceBean" scope="session" />
<jsp:useBean id="bpvBladeSystemBean" class="com.hp.mx.portal.bladeime.bpv.BPVBladeSystemBean" scope="page" />
<jsp:useBean id="monteroTree" class="com.hp.mx.portal.bladeime.MonteroTree" scope="session" />
<%
//ISSUE0000267333 : to fix multiple user issues following appl and session objects
//are maintained which will keep track of chages to tree and changes to session.
%>
<jsp:useBean id="appobj" class="com.hp.mx.portal.bladeime.MonteroAppObj" scope="application"     />

<%

    // REQUIRED: Set necessary HTTP header attributes (for localization
    // and page caching)
    MxBean.jspInit(request, response);

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
        return;

    // These are the localized strings for this JSP.
    String nodeId = request.getParameter("devId" );
	String guiD = request.getParameter("nodeId" );
    // Initialize the Montero Rack bean (includes localized string initialization)
    bpvBladeSystemBean.initialize(monteroTree.getResourceBundle(),loginBean, Integer.parseInt(nodeId));
    rbColl.init(loginBean, "CollectionManagement");

    // init MxDeviceBean and bundle
    int validNode = deviceBean.initialize(bpvBladeSystemBean.getGuid(), loginBean);
    deviceBundle.init(loginBean, "MxDeviceBundle");

    String selectedTab = request.getParameter("selectedTab");
    if ( selectedTab == null )
    {
        selectedTab = "INFORMATION";
    }
    //ISSUE0000267333 Begin
    //Check if the tree requires a update
    //if treechanged_time is recent than the the tree_updated time then 
    //refresh is true 
    boolean reloadTree = false;                       
    long LastTreeChange = appobj.GetTimeOfLastChange();
    long LastTreeUpdtTime = monteroTree.GetTreeUpdateTime();
    if (LastTreeUpdtTime < LastTreeChange)
    {
       reloadTree = true;
        
    }
    //ISSUE0000267333 End

%>

<html>
  <head>
    <SCRIPT src="/mxportal/js/MxPortalApi.js" language="JavaScript" type="text/javascript"></SCRIPT>
    <script src="/mxportal/js/MxBrowser.js" language="JavaScript" type="text/javascript"></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/dataPageHelpers.js"></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/Montero.js"></script>
    <script language="javascript" type="text/javascript">
        function tabClicked(tabId)
        {

            var url = "";

            if (tabId == "info")
            {
			    url = "SwitchView.jsp?devId=<%=nodeId%>&nodeId=<%=guiD%>&selectedTab=INFORMATION";
            }
            else if (tabId == "deployment")
            {
                url = "SwitchView.jsp?devId=<%=nodeId%>&nodeId=<%=guiD%>&selectedTab=DEPLOYMENT";
            }
            else if (tabId == "events")
            {
                url = "SwitchView.jsp?devId=<%=nodeId%>&nodeId=<%=guiD%>&selectedTab=EVENTS";
            }
            document.location.href = url;
        }

        function myOnLoad()
        {
            if ( <%=validNode%> == 0 )
            {
                if ("<%= selectedTab %>"=="INFORMATION")
                   MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_pClassSwitch_information");
                else if ("<%= selectedTab %>"=="DEPLOYMENT")
                   MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_pClassSwitch_deployment");
                else if ("<%= selectedTab %>"=="EVENTS")
                   MxPortalWorkspaceSetHelpTopic("monitor_nav_eventView");
                myOnResize();
            }
        }

        function myOnResize()
        {
            resize_w();
            resize_h();
        }

        function resize_w()
        {
            var w = Math.max(0, MxBrowserGetBodyWidth(-10, 5));
            var oMenu = document.getElementById("ID_EVENT");
            if ( oMenu != null )
                oMenu.style.width = w;
        }

        function resize_h()
        {
            var h_total = Math.max(0, MxBrowserGetBodyHeight(-35, 5));

            var h_top = document.getElementById("DEVICEPAGE_TOP").offsetHeight;
            var h = Math.max(0, h_total - h_top);
            var oMenu = document.getElementById("ID_EVENT");
            if ( oMenu != null )
                oMenu.style.height = h;
        }
	refreshTree("refresh");
    </script>
    <script>
    function reloadTree()
    {
    refreshTree('reload');
    }
    </script>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/DevicePage/css/MxDevice.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxPortal.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxPortalEx.css'>
    <link type='text/css' rel='stylesheet' href='css/MonteroTable.css'>
    <mxtag:MxTabs dumpHeadContent="true"/>
</head>
<BODY onLoad='myOnLoad()'  onResize='myOnResize()'>
<%
//ISSUE0000267333 Begin
    if ( reloadTree )
    {
       out.println("<script>");
       out.println("refreshTree(\"reload\")");
       out.println("</script>");
    }
//ISSUE0000267333 end    
%>
<div class="body-proxy" id="ID_BODY_PROXY" >
<%
    // IS THE PAGE ABLE TO BE DISPLAYED?
    if (validNode > 0)
    {
        // NO! Display the appropriate error message
        String errorMessage = "";
        if (validNode == 1)
        {
            errorMessage = monteroTree.getResourceBundle().rb.getString("error.invalidBlade");
        }
        else if (validNode == 2)
        {
            errorMessage = monteroTree.getResourceBundle().rb.getString("error.deviceBean.locked");
        }
        else
        {
            errorMessage = monteroTree.getResourceBundle().rb.getString("error.deviceBean.locked");
        }
%>
        <p class=errorTextBold><%= errorMessage %></p>
<%
    }
    else
    {
        // YES! Display the page, tabs first
%>
    <div class='title-name'><%= bpvBladeSystemBean.getName() %></div><br/>
    <div id="DEVICEPAGE_TOP">
    <table  cellpadding="1" cellspacing="0" border="0" width="100%">
      <tr>
        <td>
          <mxtag:MxTabs selection="<%=selectedTab%>">
            <selectors>
              <selector id="INFORMATION">
                <label><%=monteroTree.getResourceBundle().rb.getString("tab.info.label")%></label>
                <url>
                  javascript:tabClicked("info")
                </url>
              </selector>
              <selector id="DEPLOYMENT">
                <label><%=monteroTree.getResourceBundle().rb.getString("tab.deployment.label")%></label>
                <url>
                  javascript:tabClicked("deployment")
                </url>
              </selector>
              <selector id="EVENTS">
                <label><%=monteroTree.getResourceBundle().rb.getString("tab.events.label")%></label>
                <url>
                  javascript:tabClicked("events")
                </url>
              </selector>
            </selectors>
          </mxtag:MxTabs>
       </td>
     </tr>
   </table>
   <br>
   </div>
<%
    // ========================================================================
    // EVENTS TAB PAGE CONTENTS
    // ========================================================================
    if ( selectedTab.equals("EVENTS"))
      {
        %>
        <iframe
            name="ID_EVENT"
            id="ID_EVENT"
            scrolling="auto"
            marginwidth="0"
            style="position:absolute; visibility:visible"
            frameborder="0"
            src="../search/EventByNodeResults.jsp?nodeName=<%= bpvBladeSystemBean.getName() %>">
        </iframe>
        <%
    }
    // ========================================================================
    // DEPLOYMENT TAB PAGE CONTENTS
    // ========================================================================
   else if (selectedTab.equals("DEPLOYMENT"))
   {
       %>
        <% // DEPLOYMENT TASKS %>
        <hr class='mx-hr'>
        <div class='subwindow-header'><%=monteroTree.getResourceBundle().rb.getString("deploy.header.deployTasks") %></div><BR>

        <table>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("deploy.tasks.fwRev") %>:</td>
            <td class="value"><%= bpvBladeSystemBean.getFwRevision() %></td>
        </tr>
        </table>
        <br>
	
<%
		loginBean.getSelectionBean().clearEverything();
		MxNodeClient nodeClient = loginBean.getNodeCtlr();
		MxObjectID objID = new MxObjectID(new MxGUID(guiD));
		MxNode node = nodeClient.getNode(objID, false);
		loginBean.getSelectionBean().addNode(node);
%>
        <a target=\"_blank\" href=http://<%= deviceBean.getIPAddress() %>><%= deviceBean.getIPAddress() %></a><br>
<%

            String[][] toolList = monteroTree.getResourceBundle().SWITCHES_TOOLS;

		for(int j = 0 ;j<toolList.length;j++)
		{
	           monteroTree.renderTool(request,out,toolList[j][0],toolList[j][1],true,true);
      	}
		
   }
    // ========================================================================
    // INFO TAB PAGE CONTENTS
    // ========================================================================
   else
   {
        %>
        <% // SYSTEM INFORMATION %>
        <hr class='mx-hr'>
        <div class='subwindow-header'><%=monteroTree.getResourceBundle().rb.getString("info.header.systemInfo")%></div><BR>

        <table>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.sysName")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getName() %></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.model")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getModel() %></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.serialNum")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getSerialNumber() %></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.location")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getLocation() %></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.contact")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getContact() %></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.sysInfo.swDesc")%>:</td>
            <td class="value"><%= bpvBladeSystemBean.getSwDescription() %></td>
        </tr>
        </table>
        <br>

        <% // SYSTEM STATUS %>
        <hr class='mx-hr'>
        <div class='subwindow-header'><%=monteroTree.getResourceBundle().rb.getString("info.header.systemStatus")%></div><BR>
        <%-- Use the common, external JSP file to render the HTML rack image  --%>
        <%@ include file="SystemStatusDisplay.jsp" %>
        <br/>


        <% // NETWORK STATUS %>
        <hr class='mx-hr'>
        <div class='subwindow-header'><%=monteroTree.getResourceBundle().rb.getString("info.header.networkStatus")%></div><BR>
        <table>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.nwStatus.ipAddresses")%>:</td>
            <td class="value"><a target=\"_blank\" href=http://<%= deviceBean.getIPAddress() %>><%= deviceBean.getIPAddress() %></a></td>
        </tr>
        <tr>
            <td class="variable"><%=monteroTree.getResourceBundle().rb.getString("info.nwStatus.dnsName")%>:</td>
            <td class="value"><%= deviceBean.getDNSName() %></td>
        </tr>
        </table>
        <script>
		endDataSection();
		startDataSection("<%=monteroTree.getResourceBundle().rb.getString("tool.header.folder")%>");
		endDataSection();
        </script>
        <a href="javascript:void(0);" onclick="window.open('collectionmanagement/SaveInCollection.jsp?selectionType=nodeId&selectionId=<%= bpvBladeSystemBean.getMyNodeId() %>', 'AddToCollection', 'width=650, height=250, status=yes');"><%= monteroTree.getResourceBundle().rb.getString("collectionAdd.link") %></a><br>
        <%
    } // INFO TAB
}  // end if valid
%>

</div>
</BODY>
</html>
