<%-- ---------------------------------------------------------------------- --%>
<%--  Put all your Java imports here                                        --%>
<%-- ---------------------------------------------------------------------- --%>
<%@ page import="com.hp.mx.portal.ui.*,
                 com.hp.mx.portal.bladeime.MonteroConstants" %>

<%-- ---------------------------------------------------------------------- --%>
<%--  Create all your beans here                                            --%>
<%-- ---------------------------------------------------------------------- --%>

<%@ page import="com.hp.mx.core.objectmodel.MxObjectID"%>
<%@ page import="com.hp.mx.core.objectmodel.MxGUID"%>
<%@ page import="com.hp.mx.core.nodemanager.*"%>
<%@ page import="com.hp.mx.core.client.*"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="selectionBean" class="com.hp.mx.portal.core.MxObjSelections" scope="session" />
<jsp:useBean id="deviceBean" class="com.hp.mx.portal.device.MxDeviceBean" scope="page" />
<jsp:useBean id="rbBPV" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="rbColl" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="bpvBean" class="com.hp.mx.portal.bladeime.bpv.MxBPV" scope="page" />
<jsp:useBean id="bpvBladeSystemBean" class="com.hp.mx.portal.bladeime.bpv.BPVBladeSystemBean" scope="page" />

<%
//ISSUE0000267333 : to fix multiple user issues following appl and session objects
//are maintained which will keep track of chages to tree and changes to session.
%>
<jsp:useBean id="appobj" class="com.hp.mx.portal.bladeime.MonteroAppObj" scope="application"     />
<jsp:useBean id="monteroTree" class="com.hp.mx.portal.bladeime.MonteroTree" scope="session" />
<%
    // REQUIRED: Set necessary HTTP header attributes (for localization
    // and page caching)
    MxBean.jspInit(request, response);

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
    {
        return;
    }

    // These are the localized strings for this JSP.
    rbBPV.init(loginBean, "MxBPV");
    rbColl.init(loginBean, "CollectionManagement");

    // Initialize the Montero Rack bean (includes localized string initialization)
    bpvBladeSystemBean.initialize(monteroTree.getResourceBundle(),loginBean, Integer.parseInt(request.getParameter("devId")));
    
    //For integration of context sensitive help - Begin
    String nodeId = request.getParameter("devId" );
    String guiD = request.getParameter("nodeId" );
    MxObjectID objID = new MxObjectID(new MxGUID(guiD));
    MxNodeClient nodeClient = loginBean.getNodeCtlr();
	MxNode node = nodeClient.getNode(objID, false);

	boolean IsPClassBladeEnclosure     =  monteroTree.isPClassBladeEnclosure(node);
	boolean IsEClassBladeEnclosure  = monteroTree.isEClassBladeEnclosure(node);
    //For integration of context sensitive help - End
    
    //ISSUE0000267333 Begin
    //Check if the tree requires a update
    //if treechanged_time is recent than the the tree_updated time then 
    //refresh is true 
    boolean reloadTree = false;                       
    long LastTreeChange = appobj.GetTimeOfLastChange();
    long LastTreeUpdtTime = monteroTree.GetTreeUpdateTime();
    if (LastTreeUpdtTime < LastTreeChange)
    {
       reloadTree = true;
        
    }
    //ISSUE0000267333 End

%>
<html>
<head>
    <script src="<%=MxOptions.URL_BASE%>/js/MxPortalApi.js" language="JavaScript" type="text/javascript"></script>
    <script src="<%=MxOptions.URL_BASE%>/js/MxBrowser.js" language="JavaScript" type="text/javascript"></script>
    <script src="<%=MxOptions.URL_BASE%>/js/utilities.js" language="JavaScript" type="text/javascript" ></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/dataPageHelpers.js"></script>
    <script language="javascript" type="text/javascript" src="/mxportal/bladeime/js/Montero.js"></script>
    <script language="javascript" type="text/javascript">
        function myOnLoad()
        {					
            if ( <%=IsPClassBladeEnclosure%> == 1)
	            MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_pClassEnclosure") ;
	        else if ( <%=IsEClassBladeEnclosure%> == 1)
		        MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_eClassEnclosure") ;
       }

        function getNumSelections()
        {
            var count = 0;
            var mainTable = document.getElementById("MainTable");
            var elements = mainTable.getElementsByTagName("input");
            for (var i = 0; i < elements.length; i++)
            {
                if (elements[i].checked)
                    count++;
            }
            return count;
        }

        function toggleNodeSelection(chkbox, szGuidServer, szGuidRootContainer)
        {
            //
            // Note: Do not call more than one of the MxPortalNodes APIs at a time!
            // Each call takes 1/10 of a second or so to actually perform, and
            // calling another API before the work is done for the first one
            // can cause problems.
            //
            if (chkbox.checked)
            {
                if (getNumSelections() == 1)
                {
                    //
                    // Set the given server as the one-and-only selected device,
                    // removing the root container from the selection list.
                    //
                    MxPortalNodesSetNode(szGuidServer);
                }
                else
                {
                    //
                    // Add the given server to the selection list.
                    //
                    MxPortalNodesAddNode(szGuidServer);
                }
            }
            else
            {
                if (getNumSelections() == 0)
                {
                    //
                    // Re-select the root container as the one-and-only
                    // selected node, since no servers are selected.
                    //
                    MxPortalNodesSetNode(szGuidRootContainer);
                }
                else
                {
                    //
                    // Remove the given server from the selection list.
                    //
                    MxPortalNodesRemoveNode(szGuidServer);
                }
            }
        }

        function onViewChange(e)
        {
            if (e.value != "")
            {
                document.location.replace(e.value);
            }
        }
	refreshTree("refresh");
    </script>
    <script>
    function reloadTree()
    {
    refreshTree('reload');
    }
    </script>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxPortal.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxDevice.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxPortal.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxPortalEx.css'>
    <link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxTabs.css'>
    <link type='text/css' rel='stylesheet' href='css/MonteroTable.css'>
    <link type='text/css' rel='stylesheet' href='css/Montero.css'>

</head>
<BODY class="tools-body" onLoad="myOnLoad()">
<%
//ISSUE0000267333 Begin
    if ( reloadTree )
    {
       out.println("<script>");
       out.println("refreshTree(\"reload\")");
       out.println("</script>");
    }
//ISSUE0000267333 end    
%>
<%
    // Initialize the BPV bean.
    if (!bpvBean.initialize(bpvBladeSystemBean.getGuid(), loginBean, selectionBean,monteroTree.getResourceBundle()))
    {
%>
        <br><br><center><font color="#cc0000"><%=rbBPV.get("error.ContainerNoLongerExists")%></font></center>
<%
    }
    else
    {
%>
	<div class='title-name'><%= bpvBladeSystemBean.getName() %></div><br/>
	<script>
	startDataSection("<%= monteroTree.getResourceBundle().rb.getString("enclosure.header.info")%>");
	startDataValueGroup();
	        
	writeDataRow("<%= monteroTree.getResourceBundle().rb.getString("enclosure.info.enclosureName")%>", "<%= bpvBladeSystemBean.getName() %>");
	writeDataRow("<%= monteroTree.getResourceBundle().rb.getString("enclosure.info.serialNumber")%>", "<%= bpvBladeSystemBean.getSerialNumber() %>");
	writeDataRow("<%= monteroTree.getResourceBundle().rb.getString("enclosure.info.fwRevision")%>", "<%= bpvBladeSystemBean.getEnclFwRevision() %>");

	        
	endDataValueGroup();
	endDataSection();

	</script>
		
<%
/** BEGIN RACK DIAGRAM
*
* The following HTML is duplicated from the file mxportal/home/MxBPV.jsp.
* Ideally, this code would be extracted into a separate JSP file, but the
* current build process (specifically \u201Cant jspc\u201D) generates errors.
* Until that is fixed, the following code should be kept in synch with the
* code in the other file.
*/
%>
    <%-- Use the common, external JSP file to render the HTML rack image  --%>
<table ID="MainTable" cellSpacing="0" cellPadding="0" align="center" border="0">
    <tr vAlign="top">
		<font size="1" color="#cc0000"> 
   		<%=monteroTree.getResourceBundle().rb.getString("legend.instructions")%>
	     </font> 
	    <br></br>
	</tr>
    <tr vAlign="top">
        <td>
<%
            //
            // Render the rack or enclosure.
            //
            bpvBean.render(out,monteroTree.getResourceBundle());
%>
        </td>
        <td>
            <%-- White space between the rack/enclosure and the legend --%>
            &nbsp;&nbsp;&nbsp;
        </td>
        <td>
            <%-- The legend --%>
            <table class="myTd" cellSpacing="2" cellPadding="0" border="0">
                <tr>
                    <td colSpan="2">
                        <b><%=monteroTree.getResourceBundle().rb.getString("legend.title")%></b>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="blade" width="18" background="../images/IceBladeButton1.gif" height="40">&nbsp;</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.server")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="noBladeBorder" width="18" background="../images/spg_black.gif" height="40">&nbsp;</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.noserver")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="switch" width="18" background="../images/switch.gif" height="40">&nbsp;</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.switch")%>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="noBladeBorder" width="18" background="../images/switchEmpty.gif" height="40">&nbsp;</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            </tr>
                        </table>
                    </td>
                    <td>
                        <%=monteroTree.getResourceBundle().rb.getString("legend.noswitch")%>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<% /** END RACK DIAGRAM */ %>

<%
    }
%>
	
<%
     if(bpvBladeSystemBean.hasIa())
     {
  %>
       <script>
	                  
	                   
          startDataSection("<%=monteroTree.getResourceBundle().rb.getString("ia.header.info")%>");
          startDataValueGroup();
          writeDataRow("<%=monteroTree.getResourceBundle().rb.getString("ia.info.ipAddresses")%>", "<a target=\"_blank\" href=https://<%= bpvBladeSystemBean.getIaIpAddresses() %>><%= bpvBladeSystemBean.getIaIpAddresses() %></a>");
          writeDataRow("<%=monteroTree.getResourceBundle().rb.getString("ia.info.dnsName")%>", "<%= bpvBladeSystemBean.getIaDnsName() %>");
          writeDataRow("<%=monteroTree.getResourceBundle().rb.getString("ia.info.fwRev")%>", "<%= bpvBladeSystemBean.getIaFwRevision() %>");
     
          endDataValueGroup();
          endDataSection();
      </script>
	  
  <%
    }
    %>

	<p>
		<script>
			startDataSection("<%=monteroTree.getResourceBundle().rb.getString("tool.header.folder")%>");
			endDataSection();
		</script>
        	<a href="javascript:void(0);" onclick="window.open('collectionmanagement/SaveInCollection.jsp?selectionType=nodeId&selectionId=<%= bpvBladeSystemBean.getMyNodeId() %>', 'AddToCollection', 'width=650, height=250, status=yes');"><%=monteroTree.getResourceBundle().rb.getString("collectionAdd.link") %></a><br>
    </p>
</BODY>
</html>
