//  Similar to MxBrowser.js
//

function MxBrowserIsGecko()
{
    return (navigator.userAgent.toLowerCase().indexOf("gecko") >= 0);
}

function MxBrowserGetBodyWidth(nAdjust_ie, nAdjust_ns)
{
    var o = MxBrowserIsGecko() ? document.getElementById("ID_BODY_PROXY") : document.body;
    if (o == null) o = document.body;

    var v = MxBrowserIsGecko() ? o.offsetWidth + nAdjust_ns : o.offsetWidth + nAdjust_ie;
    return v;
}

function MxBrowserGetBodyHeight(nAdjust_ie, nAdjust_ns)
{
    var o = MxBrowserIsGecko() ? document.getElementById("ID_BODY_PROXY") : document.body;
    if (o == null) o = document.body;

    var v = MxBrowserIsGecko() ? o.offsetHeight + nAdjust_ns : o.offsetHeight + nAdjust_ie;
    return v;
}

/**
* This function is for checking the state of the given iframe in the
* current document.
*
* If it returns null, then the browser is IE AND the iframe is in an error state.
* Otherwise, it returns the lastModified value of the iframe.
*
* (1) get the lastModified time on an iframe
* (2) load a URL (to a non-cached JSP) into the iframe
* (3) let a significant amount of time pass
* (4) check the lastModified time on the iframe. An error has occurred if:
*     (a) null is returned, or
*     (b) the lastModified time has not changed
*/
function MxBrowserGetLastModified(szId)
{
    var oDoc = null;
        try {
        oDoc = document.getElementById(szId).contentWindow.document;
        } catch (e) {
                return null;
        }

        return oDoc.lastModified;
}
