#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BDD ROM)  - Linux-Based"
BIOS_VERSION="F.11"
FILENAME="sp29402.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  P5252  P52 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  ^P5252  ;1   8DTT   BIN  P5252   P52    68BAS   BIN  px5252  E1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZX  @  
   f^      C        
 
  F  )  
    
  
  
  6
          \     
7              _  9  #      |  Z  I  @  a!  [!        q      }       
 
 
%  %  {%  b%  ?%  %  $   




















~
z
v
r
n
j
f
b
^
Z
V
R
N
J
F
B
>
:
6
2
.
*
&
"









































~
z
v
r
n
j
f
b
^
Z
V
R
N
J
F
B
>
:
6
2
.
*
&
"









 
 
 
 
 
@  @  @  >  >  >  >  P>  {C  uC  YC  mA  \A  



~
f
H
*
 




v
^
@
"

 
QN  N  M  M  M   
[  [  u[  m[  [[  t^  J_  h_    6	



  \  Ս                                                                              3Ðjrː
  F  F~ F F^:9 uvfv$}fvfv$~h7	h jIsRP腉Vtj
fvvP袊
h7	h jJFRPXVtj
fvvPu
 Ð3f>Z  tf6Z f>j  tf6j j \i  Vh jeh jZh jOh  h j\h  ~F ^v&v& =c   -!  - tHHt-3 t_ L  F^v&v&8 D^v&v& ot^v&v&   T  T  P  T  N  >T  uT  |H  J  m-d _HHt- t- t- tf6B jRP$fjRP踃jRP訃jpRP蘃j`RP舃jPRPxj	@RPhj
0RPXj RPHjRP8j/]FF9F}-^v&&?-t^F&&?/uF nX:=sjtRPڂj\~XtjuRP軂j\MYXfh  j wZ \ Z ujvXRP耂jw\t
>R  t@C  Xvt(n ! ~ 9  =  A  E  I jJj1fjj l j ujvRPj[ t(^  v j   l ؎f&fbjtRP轁j[>P  t>R  tX  V  L  >X t>X u& & & >X uD>T  u	>L  >L   >X u3T Ht	HtHt8j uwjJ9ulj?j.>X u?T Ht
HtHtHtIjj MȐj?u+jRP׀jT HHtH>T  tD>N  t=,?h,h,j2}
>8 t jYRP聀jIRPq>J  tj [Zg$  F >$ >P  t>R  tX  V  L  >X t>X u& & & >X uC$~ tfj fj ,F  s=HtjH-
 -!- - - 
tEf>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj ?e     F >J  tE<L$ C= M- K- (-M- 0- )fjF6>J  tp
j 6X^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð,".
Z hTh,h,j=>82  fFfbfFf+fFFPj fbf-    fPfvFP~ uf~uF    ÐfFfbfFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FFd+; w; r j ӹ l ؋F+NV&&Wt j   l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP襀
3Ðfv T  Vfh  P FPՀf,K  F4ZhTh,h,j}>8 t3^ÐFPTwBFVh7	h FP@~RPhfvh7	h fv$~RPh` vfvh` Hv ^Ð  FF
,".F4FZhTh,h,j0}-*ÐU~uh7	h  Ð~ fh  `h7	h h` Y&(&u3Ðf     
f    fbf9 sVfh   f6 fh  `f6Z Iu*u%f6&fh  f6Z Z= u&&G
 tf6&X놐f6&WA~ uh7	h 3ar j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP~
#fh   vfh`  j f6Z r
Bv  WV7	~ f~ th7	h FPRt~ FPu3^_h7	h$ h` W&(&tj fbf-   fPf6&v
f6&jFPu
f6&x~ uF.~uF6b 8Fuc 8Fud 8Ftf6&VkFPh@Rf6&U ^_Ð~ fh  G.h7	h$ h` V&(&
f     	 "fbf9 sTf6&fh  f6Z V= X&&G
 Kfh   f6 fh  `f6Z )t!f6&>Ufh  `b^_Ðfh   vfh`  j f6Z \Ur j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP${
FF>v tjJj1j f6j Z{jh7	h( p j   l RPz
6n h
h| j   l RPz
r j   l ء\ +Z  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  E&  FF܌VF V   R   X   f,
S h,h,j^q
>8 u_>/@V Rf,N  f0    FޣTFܣ6hTh,h,j%w>8 t>-uR   hJNu~ tX   Ft
F$p*X Ð&  VFF܌Vf,D 6QCZ4hTh,h,jv>8 t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	,&,ZhTh,h,jMv>8 tjgfRPs  fh  ! h
hxj=RPUF  @n +FHuF F^	&x&*hj*mVFn 9F}j zĈf<t<uh7	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>V  u#jGzRPrjHjRPr3ø x&hjUh~tuÐ  fh  u3fF    fFfbff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "hj
TjoRPSFF*;ds6PjNRPSF*Pux&
뫐x&
hj
}TjxRP!qju,jARPqjBRPp>J  t`hfh` jRP-SÐ  fh  h@hft"jIeRPpjJURP}pjwCRPkpfh  ujCF  hj
Sj
RPRF~uJ~FF*;dsPjRPbRj F*PNux&
띐t~ F bx&
hj
RF~sF F shj
RjQRPQ>J   FF*;dsfh   Pfh  j f6Z fh   F*Pfh`  j f6Z F*Pj$RPjQj F*PVu_&
\h@h` jRP)QjWRPjVRPh7	h4 	QÐ  fh h@hfgt"jIARPinjJ1RPYnjwRPGnfh  ujCF  hj
kQjRPkPF~uJ~FF*;dsPjRP>PjF*P*ux&
띐it~ F bx&
hj
PF~sF F shj
Pj-RPO>J   FF*;dsfh   Pfh  j f6Z qfh   F*Pfh`  j f6Z F*Pj$RPFOjF*P2u_&
\h@h` jRPOjWqRPjVgRPh7	h4 NÐ  F >X ut~ th7	h< h7	hH FP.hh7	h$ FPKFVu3vPfh  f6Z |K= s^&G
 tF  fvPJO>X u~ t	h7	hT h7	h` FPgh7	h$ FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6Z FPy0F~rh7	h h7	h< IFVtvPfh  f6Z QK= s^&G
 tF  fvH~ uj/RPLh7	h< jRPLF*  F xu3E-t*t~ th7	h< FPej h7	hH FPej!RPFPeh7	h$ FPIFVtvPfh  f6Z H= s^&G
 tF  fvG~ tj"MRPK/F~  F ohj
LF  hj LFj";F~x& ܊F*PjRPcKf6Z FP/FF~s#~ t~ uw&
tFPFPj#RPK~ u~ tjjgRPJF  F f6Z FP).~uPh7	h h7	h< GFVu3vPfh  f6Z  I= s^&G
 tF  fvdFFÐUf6Z FP.Ð  F u3F F~s7F*PjRP*Jf6Z FP<uh7	h2 Jh7	h h7	hT FFVtvPfh   f6Z BH= s^&G
 tF  fvEx&

hj
JF hj wJFj N*;~x& Րx&
hj
+J~ ujRP%Ih7	hT jRP
IF*  F u3t~ th7	hT FPQbj h7	h` FP<bj!0RPFP'bh7	h$ FP~EFVtvPfh   f6Z yE= s^&G
 tF  fvMD~  j"RPIH9EF phj
IF  hj 	IFj"R;F~x& ܊F*Pj[RPGf6Z FP:FF~s#~ t~ uw&
t~ tFPFPj#RPG~ u~ tjjRPaGF  F f6Z FP9u3À~uLh7	h h7	hT DFVtvPfh   f6Z rE= s^&G
 tF  fvBFÐUf6Z FP9ÐU  
2

` UvV>
Ð  >
vVF*^&F^&  >`% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젶
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  iÐ*i  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRh7	hl ^Sab~uvvh7	hv fvaÃ~P|FlFFPvvh7	h fvaÐ  FPNQVRh7	hl fvavvvh7	h FPraFPNQVRh7	hl fvavvvh7	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvh W  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6`FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>` tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>X uFP_!ÐFP>X u0 ÐU>X uFP+ÐFPU>X uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHF`F`  F
FFFF  F9F~FF^v&8 uvvE~ u
F`F^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh<htLth<hِ 1= t= ut Ӄ>V  t fj hN3  F/ ~ ujQFÐF Df>b   FF Ffbf   ffffN*+;<|;s6F*@N*/ Shx=h*F*P̓uFx j hx=h j̓]FUtKjh̓h
h` j hlfj h\G=thx=hEtÐh
h@h
hf~&QWÐQ&WÐU~ u h
hfjhdHh
h@jhd7F  F~ ujFÐF Df>b   F4w j h>h:fh  L΃uF  Ffbf   ffffN*+;=|;s7F*@N*/ 4Sh>h:j F*P̓uF2uF~ u~ 4/ F F~sF 4/ F cFfbf   ffffN*+;t|;snjSF*PShSf6Z Tڃfh   F*Pfh`  j f6Z ڃF*@N*/ 4j h>h:j F*P	̓h~ tfj hz!F\  fh  ̃h
h` !fh  ̃t"h
h@h
hf+t";fj hE/fj h>=uuh>hdt!h>h:tfj hrU~ u h
hfjhdh
h@jhdF  F~ ujOFÐF Df>b   Fw j hAhdfh ˃uF  Ffbf   ffffN*+;=|;s7F*@N*/ ShAhjF*PR˃uFuF~ u~ / F F~sF / F cFfbf   ffffN*+;t|;snjSF*PShSf6Z ׃fh   F*Pfh`  j f6Z ؃F*@N*/ j hAh#jF*Pyʃh~ tfj hzF\  fh 5ʃh
h` fh ʃt"h
h@h
hf蛼t"fj hEfj h>=uhRAhdt!hAhtdfj hÃ>J  tj ht$ $   / ~ uj߃FÐF Dj Ճu` j hDhtF F~s3_ F*/ j hDhFPuF? j hDh|he>X utTtMttFj t:hRAhdCfj h>=thDhtÐ  / ~ ujރFÐF DF F~s-F*/ j hEhFPuF? j hEhh
또>X ut>t7j hwfj h\=thEhtÐ  / ~ uj݃FÐjӃuÐF D` j hEhtF F~s3f F*/ j hEhFPuF? j hEhh
c>X utTtMtFjt:hRAhdafj h>=thEhtÐUfvhB  \*F.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
\N*OÐU*FP\PK**PKÐU*FP\PKF*P*PwKÐ  >T u7]  FVL;Vrw;Fv	T ÐFP
uh h UT  >T u
FPh iÐUT  >T u
FPh IÐUFPh 9FPh -j>T th UFPh FPh FPh j|MÐ  >V tRFPh FPh FPh FPh j0 h l<uV  >V u&v*N"FF FF
FPvB\*Ð=tw$-t-| u)^  >^t% Ð^ -t-t t-0 t^ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U^FPgÐFPtHtÐ^	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  P h FF )fF~}j v`tFP  F~s#>P tFPh F  f+fF볐>P  F  `>P t(^&k^&?tP  FfF~|F~s>P tFPh ;f+fFҐ>P uKF~}Afh   j FV^& ^& h.P F 닐FPh j FV^&^&PÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h Rfh   FRPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uRPh Zj FF  	&f FP*ătFPh
hfփ~ th7	h`
h7	hl
FP3h7	h$ FPUFVu3vPfh0  FPLfv4FPh
h@kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhLNfh\  hj 6Lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6LhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&f FP貶tFPh
hfaɃ~ th7	hx
h7	h
FP&h7	h$ FP	FVu3fj hvPo(
fvfh  FP	fvFPh
h@ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tûZ XËZaËXaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..]f^gef[UfS..]f^gef[UfS..]f^gfeff[UPfS..]f^Fgef[XUPfS..]f^Fgef[XUfPfS..]f^fFgfef[fX                           UfPS^tf3ff]  f.].] "  u  $" u [fX 0!<s3P˿
6 + r ׁ~sh3P1L!66ƱH6`b66gP6g
P6g6g6&\6 +۴J!6
+3	O3X 66666P.h_ظ ^3`P.h_ۚzd  y>	uXP	 P^
 5! %0_!	)&6, 		3	sx		 	&, >3&= t4
 |t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
t z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;|uQVW| _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ XQP,[XYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt(u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVTFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	(uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*ot/ppPvvPvvF^&*ou^&?%t2XdVZ\T`3jfh~` uoF^*&otfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt ot)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPotou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\ou̓.uMhhtAĞrr&.hht'jĞrr&pvv
ou̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnoupVvvj u
T t nĞr& \~P|z\Pf
 P|z\P\^*&;tpVvv RT uInC-c = w.dvoxr@t@t@t$vq$v$v$v$v0txrjr$v$vo$vxr$v$vq$v$voRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^ot$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvou^] wxxNxzxxxxUwVW3FFv&vF
t~ }F, <Xw$ FF.wV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuIOWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
dF
ZFFt~ u	W`guF u	W^&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>V tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uSuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B
&X=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV43V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;xvJ;vvv ;s33󫖹 +v*39p	tvvvp	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3
 u
_^]U VW 3~v
tȰCvu&6r	% uN&6r	&t	HȰ"Cu׍D&r	&t	% uDȰ"Ctd&r	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋv	tv	F3] UFu		u { rFGFF3҃vvډWNu(t$>h uS#5!hj[P#%!u鍋s̍ˍʻ 	FV]U컍 .8tK
Ix	]PPR.h_؃> ux	z	w1uRUVV EE< ujF hF]ZXXˣ		UWVQS3x	z	 P	X[Y^_]ZXX˃PU
ء	F	F]XSQR
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ_$%!3]UWVRQSP.h_ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;ut^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;xv;vvv3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              
              4.61  mm/dd/yyyy    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   7	                        68xxx.BIN                $ ( , 0 & ' @  ) * @>  , - :C  X Y C ] ^ D a b E d e F %  
 \  
  D10/17/2001  O                                                                           7	 7	 7	 7	 7	7	N7	~7	7	7	 7	27	l7	7	7	7	7	$7	L7	r7	7	7	7	7	$7	<7	N7	t7	7	7	7	7	7	7	7	(7	D7	b7	n7	v7	7	7	7	7	7	7	7	,7	07	87	@7	J7	T7	`7	l7	z7	7	7	7	7	7	7	7	
7	 7	&7	N7	r7	7	7	7	7	 7	@7	z7	7	7	7	7	7	7	&	7	B	7	b	7	v	7		7		7		7		7		7		7	
7	D
7	n7	Z
7	v
7	
7	7	
7	
7	7	 7	07	R7	p7	7	7	7	7	7	7	7	D7	r7	7	7	7	7	.
7	@
7	P
7	                                  C    D    @ h 2
      A    B    @ h P
      E    F    @ h n
      I    J    @ h 
      M    N h 
      L    K j 
      G    H    N h 
      +     /    ) k 
      R     O j 
      (    /    & k .
      P    Q     S   
T   
O i L
      V    W    U h v
      .     /    , k 
      [    Z i 
      _     /    ] k 
      c     /    a k 
      f     /    d k 
      m    n    o    p     q     l h $
               :`                           _C_FILE_INFO=                                                         
               
	
\ \                                  

  

                                                                                                                                                                                                                                                                                                                                                                                                                                             
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          aaaaaaa               (((((                  H                                                                                                                                        
                                                     /_/_/_                  h




<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                              P  D     ,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$2Ruc/C 203-Memory Address Error 
Non-System disk orceQ
replace and striky key when ready
}
602-Dette Boot RecordH3  5EE Run Configuration Utility1720-SMART HaDrive detects imminent failure (Fping Attr: ??)

Please back up the co{nt s of"!hd1run
HDD Self Test in F10#tup 1800-TempeAlert  7`{A `!proc ~has beSed !ap$s n@or($C7MOS&3-*)s aJ'2)()[(by POST o1155Bo?Comm P *Assignm!lic&611-Prima Flopp.01n22-SndA33_1s201tGrol&495Type417A8si:`=9Y6=>0=0=A0=A>9 1=FF>3h6x:2@>60-Fix )Bdoe)sup* wBlo ModJ%1YK1/LJM722@71 P~?Q11s73OKKODMAM3/NXM5Wa )Id ify`!mAm0\\Z^%_4] ` %8Ma_c^WParam`r TableBIp+Hal( c 59ap1i>Upd @ b0q!:j... Invalid elronic serial _numbeb19I/O ROM%39Kn$;3 s:304sUnit4Load_all -%hDk4`MonochromP&l 164ESiz<OsIxB$W"&Instxpketwork#rv:RdAct"No spachqk16P6Op*1spt$ h Che 2  PCI Bush|%;10-Ex0in0qStorag@<evi >HxF1[ z2h:lCU1U	21z2ߌ3܋3	22 9qrѕ/>IOCHECK a yl@|3-{Tiz& Da  O X 6   Powe{r-PPassd9XrOK Do youllz@a0to p1!"s? [Y/N]ҝRuV͛AdipaЈگRP$or1hiqnQo (ABOp= 'C_trl +`&tDel'|8-11@C: Tp!(changed2: 6mpne'A3СЈ3_: Videon-4z:rrup0-(f`5iȐM6_ an)P`$expansAbp   TurnR"ej@(fsݽ<F1>:G AbaU1b1^b-rmal2PUp mu`$U3giq"wa:,ѫ+Bk(Strg+Un/tbr,CI!5ѪpnT@!f:ow1;o@uWtom c2umed: ;s To  mci: KbytR+cksum$o,N@fauPou0OlxpkWA)Next? Ehti2%Exx1Sssa A7cce= cݠ F10 OF2 CߕSS Ibߔ  auinuempu0i %! Mai!ance HCoTt<.swix- uspkTmodu7[mefdrequire1s.  D @o cڄ.% LaM#B@l'Mib?ay12re0Oexcee@pܵq)QM )E1!+|p"CircuaL>vUnO )w0lndS(."j.@U%,E4H"#P$.S03 2)p cocؐ&,VInr1ŇShutmdown  &y@Q`!`e0c݈PIN:+ [
]Nrq!left ՀЊހ)@i.u ʕOysp)opU0" bp'%PӔpkeqdppcuchipq)bemn%p`͞O%&*!ld/*New-s~@^m+O,ҿ+6*bAeTb &r	R d1	7tܱt	A ' m_3, aff`p`;ma,𡰽bPmak< 7un3usiItAongP_en %86*0	 5eu^lJBw7re lAc ǐСaZFS~F2a}.`ERRORyYhp~goneyTla MѳIEx (MSGIDX) R  t   _      8     
   .h   n f  ffff$1 ISvݓV Q'  A             > v    T   G W e M A~Y 9@. 0Q  n"Sa0 G ( @ ظ   f3  ?wf
 4 P f pp6 f6    >/ ߎ 6 >x  .h1ʚv PS $<t4r [X `
u14XGNXrBqXr<$X. u)(.< t.h^.a !!`6PhDrAV(< 
u^V3$  ^(P*^`% &2 4aSP( 22< tFX[úB *$PQR  ZY?._/0123 46?7_89:;f`X/t.0, ~ xri rakfL+_@ Aكpr$ wr/}@f+D`Af+\ r@ .hrfa= PR),3HZX0GG,
@I`&Fa`.> GuhP'XhF r.>.pu?FKfPfQR>.fh f3f% aZfYfXURQSWF^
D= F\_ ^0TFU\މ^t
;v F;F
 < uWX < 22 IF t%[%[[~%[ޠY% #Z8t
` @[uPj Ѓ;}
+V 
N JZ=`[uAN3V5,_[YZ]`P P&X&0KPQW^ kPRY+UkPkP]]]- klmo?p_qrstuvx?y`ރ6.u;v{Q0h *Yp[QwLQ?f&YCoCpfKXݻ  a3_YapdP=SRP3pX?[>?P$&%<GP1PP	 ff t    <BMtf3@SP2PI􂊑X0P *r
:@PSfRU3Kt.fGenu fineIpnteluwf=sl=r'=v f%f2ft PY tI f ߅ =|x	tǀunj0`fހ@3tљ5uRfDQQ $<@tC<t?`>H$u.f1-ۊffCt	]fZf[
ffȱ Ѝh0
=?   ,zqh@-h]?whŲFؾ x  <D 010Ëދ38t" QW_YFð N;r+A+&FGN uɆF`="0rF1ؿ:?6b"hY@߿8E謀9m` @6m Ő~~U= r&+=ľ=rW>0 _<us&&&
, fgh  0 pqr  <ABCDE xyz{|}  ; üfQfRKR &
¾XB/ r
&Pɯe0R.0 Y!SQV3
Ê^Y[.<  .FuN.۬PW _PSWfVUSW! fv߿ h RV~2,!IN 3t^
u
t_ ӋN_[]f^_SVǿ h\^[þ
  âS
)F10=ROM Based Setup! E`ring=
G`.pu  
'atpE
= u'`+ W  	?p :"w	!
 ⯋
2OpO&
#tJú g$t
K~t. LF12=Networkrvice BootWake On LANAttoemptto" 5D`h4t`pE	r	 au8#t`o A4E )t_qsc SrP.$<X6}/4 4QQ!7 N1"R0Zs0sV3V<^h#`sW {QWVR4y3V0NF V3؁sV?	uCFG~gN(
t
Gf`hT'2Mvh\f(Z^_Y[QNotebook hard? driveHMultiBay^JDockbCb(top)bottomy)left@Flopp  USBCD-Qݯ!HDis!Super#NIC!j1'I1'(2)(3o' ./0124?5_6 789:;=?>_?@ABCDF?G0H	NH
lHHH
HHo @K>@KylectvDeͿNO͹U@ aond mothe highlRtyour cho.  PresscSose.Seconds until au atic defa` start: ($$HXl's;Y!ZipCG`t= Dr= kd hm S0ô0.&-t @  a0۶ 2V3sV؊' tA<v<st1& 2`P2}AfQaYAr矀 _@
.
*Ѐ +jjj(Pj #b  jlz  l  mA 02g^
   t0`32Ɋ <F8tF3V $ Z qlmq UR{VQ., L.T^Y^Z]uSv._*[v݁wQSVW/ s&Q.<.-00?00.AY_^[YQ q\u h^ \t0]t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu͐`2bXʱ|l¶d wjr
;w2Ҁm{JAuƁgFYô.*<2fQWa h<u X  h= fWhԏ@ڝ h`_yfPQ> Y,` h;BBJQX@ 6jf.fffƐO 2ɉX7O2Micro SmWCBus Reader, PW .g&:u&Gf_g&wgO߾,_X   ?  X   	\a`hqPLg&F Xg&F  u
hhbg&F&XPg&F  r?@ &   @ r)   a޾l׎Ǎ~ع   ל QRVைDT r&ߊ%^ZY2sfвfL	
ڢ⳾Lу  rр| ^ "  UG$r&YPS( t  r^[XRN(Q'CYZQ2' ug&9N(t Psr`r[ 2;w}(;r
V퉸tGB  r݋Bؠ/LVLCPQGysrPRb1 Z.>ohDfPS@λ0ǀuh3裎t	PB [fX.> t.fQfRWf  2f?YffP_fZfYQfWfVgf&!=TDSSu Ջff3gf_uf.>f^f_YPұQRWh\_ZВмVW t@۸Hu`ut_^`_8 tX@o, 
ῆ Z SႪw0' F?SM@ H/P JaÍ6௘pq$iW0W $rtDDRL8 @ A D]EHTLmd   ҿ$x'z b | 
   z PLQL           k lPLrւ 	 ϿP@CS  C  鑐G@ H T@ X 	   Y 1ó QL$4
&
. U `/.s p@. r0`\. ab
h    !! @!  UAC 6^@pQ #qPpqCU 
 P f
heu!!P=
PQR"`߿ h
fQ3Ҁ
t
PЊ͞ &ɭr`#fYf !"[	ÐrP'ZYX}&> tRc ~rE^& ~f3C hY}  G 1+ < t&G[ )	Q))3*&*, ,.)p.f342)*f&© uf
ffKf&&&fCڤ.0A75	îO677@8#7l 8rd4h;`r@ 0> !>&&i<SQ"`3r`&&q&q@@ǚ@rAY{[}fPffRfVW3ffCf[fKfSF0r!a0)а K I+r"`O_0ـf@SQVW3_^В3t`ޯ3ff@+
+bp
_A!af   m rQ-Mu2`1fθ ϻ" h[haR}%
 4tPR͡XUDfW Qt% s	 f' fff>'fh@3p秀; 	  u7)fw)fʾ~/u!b/ub/ub/u	g& >(tx3\OrnfQ^P  (^@af ^P,~/ub/t dg	;'Qd(GfFJɯopqs/t Ouovwxyz|/} O~oς/ Ooϋ/ Ooϔ/ Ooϝ/ OoϦ/OoPAZff.& 'u h^İ5rWrRrM 'tf݋fŠ | p\V t#8r" #   /  myN O7pf]m  KfUr*6\  R Z 1rGq EKuf]L aD rCF+ @-3hcg&8E t fEGxl #RnK\)R)>' t`04DQZh]S^ g P؇f&xlmJW{ r^ r
  GC_NNOt$A͊O$wΠWw  _Wl  sq?_  ?Q q0߰@B ? ð 3 S Sp' "Q ԀPԟ ̀ΰcAQy/A؊OQWEبuptPGX_Yù
 d hcxs@j
P <uAbuĀ PRO Ohh < ugZ0AD t	Aހ e㝂<|<t<t2<tH0S 1[\E"L
Lhs#L`UfN#Lf
ïT2+"D
D#DDf_f#Df0f`Sn m 1l j -2   ik U 2 L k	 U
 _k U t
 k j @2 ~k i    So `*i  v S o i L 
O M P 2< n! `Y" n# w( yS$ 0%q % <&Pj i*  _ ; Q2' ) Dw+ 0], >[- Ɉ/ 0 1 02 QM3 n= > n? @ oS fA 1sp n5 {2m 26 n7 S9 iG MH : 4 LkC 	2D -VE kF 62I0J O. P
K kL SM N nO DYP nQ ӔR xV iW mXPY 
MZ $2[ 9ib c Ve ig  2\0" f"91 @ ؠ   !R  f   3/$1?/ K.DմPX% hX@ .X=X@u
_^rYP؊ظFRݢcʐ
9PWI;f&E1_XhԚR7h['hߵ % ( h+Ru" PQq0> 3_(BN	hfcP dF$h's VM   ! $!nCvP2F Xñ E9Ypl	 Of3uf @  _7/`/*/`/׀/``/S/Y`3 @PL &>cV&DEJ&&D >Vu d4gY566 4kY5޷8j@  >%sV}{
Ȁ}	<>oV 33S[tS[So >2?[p)M@3 tth`Uc&s
Jha3hR݈D
ϰ< C)DuL
p
E$<uGD
@sd
{#Ir&_ uIfp9` uL
 6 6WVu]9  LX >6QM &uh/^sC	\
bLFu过 pL D&}?u I t&Eb t JG&E^DG&Efw>Tt6Tj t.& `t	&  tXW{&Xxu	H\	PSqW} PW ?W؍>pV_3& ?]W>qV	_[XTt+tW# Y xtX  t `w\D@EPV!$!"tVh14e8q&  ^XEEhARr!L	@1vTt
v#b`WEV\z;'Q^l$<v @Ru<i_bSQ3  v
p
u$@"<u@P>ȷX\PRt$:1thU4!Pߊă v쾑u=GZXŻ`2ҿￓV& 7t5ǃV=sVtOuE0: u	<t!sE I u~52fs~
t=!B%&aeaz׃/{P%3`0hRs&=  V @MWu @M^w p3f`VG@^Wf_ } U   W&egWʃO&MuOOfGtWt$Ot,t"wOqGr ǾKMoOg&W/  fPu
P2;bhpjGk_kרtP<uLD8\ =_7D D	 d
z-1QjbGtSrG&}	r??23tt`hyEa&EU$H	&M&]b`.'	P%f rX 0W3ϠUڀ ShRF 
~|h>so]RRB% %ZW&= uAPwоg)
hf
 m_  P
2 
31XDл31` бu#Ifh~T~ ;.
!i[ Z +;.-ы% uiĲu8w@M.:t;.Yp]  5GtG}5X \ &   "Iu T aË

	`PS@[Xr=2=.VބW tS1e{
5[ PjԿ ΋у[ȃav$tu @bSQWf3Ҁ	fq︠_`z`֎fzhg73۹ F
t):u%VD	& h5ʃV & 	? h4s4V3'aEB%3 
3 a<p sV bS . [9 r6Qu- r*䛃<u&' t&fw1+ $׹'11ꨠt
vw2'+`&QQvs& 0RyZytt hc C YQo?}I[r=Lu?(OK% = tkPYnWV]血p3sV+S6 
`VHH8E&NSEQV,{[Sr5P-0}uS|[ uphExfDϝ^1 @쨀u$P<PtR>uwZD1vxO"Z܇Z RWV 0  PEX@  	C	

r4he#W2<ƀB=Ɛ?
C@%?r@Dd
gU
Ðu,uށ
@1

+&C323&tPU

t&
0  5 ? U
2]P˶(4
Ou/: >02? %w {^PRW1&%	A8&&]7&&UK
t ˀA']H*_ZX3 -w2C.%/%N >hC	-_ %	߸^ F1+`z35/6O7f>u  'a{ w BCfsf3ffu 3 Qύ>US:uBE&8Uu8 >]
R +B&U
ZK~;ؾBC<~@ZfYB'qr hS/XG
f>gt%F@G>虜pÃhfrἑb
<tЂZێûPhqC
^f  XUOD
R$$bpYUHGI,IUf`d؎ FwE.  ڎfafSfQf.{Ef[fff#fYf[ZVftGf߾    [nEIgf;t&fU] ^l^S_	^F0P=f^\`2ۂۈfaf}`PV0faPӝd3_X.>pE>: .f_~^TACOhFRQh Q_h&iih	&i .lES ]h%i@sBkF5imnE fFf.{E`sssEF.Ef.>{E9E.Ev t@gqEtXtY@grE?tNpx ^ݡs`@SIg?VfB.qw0fk;VrT%y]z^{|ܠfxi P]QfR_f\fffgp<b]r. s lEaf@qfPf.yffHqssfXfqdgf3vwu_zs?I~s*^skVf+f;wfff33nRs҉Us[wE]^_'R__SÓ$.p^QP``_333Ҹ  QW>Sps_F
3}5upsJE#ȩ t0 t AM нwt
t} tWM_ }u   ؉F EF^V t SV^JwpQ&tY&  
`< tr&\]&\׋U@
&iqNd sV
S؂[}u	F&4F^[_YCF FU[Y}yA〳VWًذК0' Vr_^WfQS߿ h
f [ fUt
!p[fY_` t =$P`nPu2Mޱtp6s } tp( ` j Q&& s_SRU`Qj@6Ŀ^]Z0%V` WK ȑ^X~p*F
O  t#apsPXF ^FT d3duhhdKu`<Uuùd `FhQ}4d&w&Xqt   hn}r& h{9Ph>Cۜ%ʰʰ`ʝXÿ!$!G   °GsWv?G 
ehìr   tSt 4 aڠh`M.` tKu؀& &  S
 e@ `hdCsP<t<uV[uЂG0_u?1R*`PhnXh4-0λ % Pk ,' 	jt[s#_ PX7#eeQȹt?Pﰵ`}  2`G  c#d 3 8Do1*pÀ   ; Z x     0NPW`^~bhdI1fF3.O _r w
0ވBFuр~2wFd#d-00
<2wd8F w(8F wI N@bF ;t
 u@mF^KO.~r@V_  aP	|û< fuP	ypff @ffRfP2f!Np,
 ffFf3fv1ZfFsfBPf[f V1 r9@b`f3ɐ0:ǿ:fя faÒfPV3v޸rF3QX

S,0<	v	,$Q.[W D

Lfzf V
T
T  #!	#!
#!f_Cf Ўfv@S  P$p:FP
usf^fNfV_f^5#PZR#0fu'P'V$>V%F $h$'`\b
àff  fffffXC/4 $6f>f>f  fe!gfg`p0S 9 T5 a3P*hDIP,6SVW06fQhpYÆN2uHqthx=3/6_^[ø6CPRhd'Έ B Ph`󵿧H fPATAM_ h=TAQBR@ Cw hǝIC@ hcF  @5Af$Qn i  > hC@ZXf  w$fL
п$KBPL$LB$
_иKHULQfO \EOM8LMLMQ8LQRRNRN/LBMPSS@EJ0` 7    AGpq$[q\ p3qð \&qCɡ] \Āu̀]\_t%` ^ـt٠:bu`\%;û 3ɰ\<KuPW;`qEh\C@_07s-$d1Y - t+==vPjP ZtPa XkPہ?UuC33Ɋou uߌ3 Pڦ$ 6>3@` Pf^ X)[ dg&& &0<t hp430f hv
t[ Ȱ t
ŀv#t̰{7||y:5bPX~a}v[B8v&> 㟸 h`t`_P3 u $h`7D
#uV葵sy'st.>X ul2hS`!)uVuQ 
wGX2 Q  h^Ǵu= Dt= tY
衶Y.߸X^!r@hAPfA]{s,ui0<  Qhw `\ve(L 6jf.ff0/EBa rfXPR r KRW37Ftt_Z"SQ !fP(RWVwdt|"؀+kr3k@XG.[;wpI AXDA+ȿV ЦEA6F.[
C .[C8FC^_,, " 8u@xxY=`S0[$ .BB <t BB2Jݾ8[   8uQ@[`23Ұ
ShbsFt0`́ y autкi at]U [aSR  4 $@`1-1a`  h	 h|
 "B2PaԀa$8uXRPf2XZ@QrtwvYu0ѹ }R wZPb U2<UK@ZJuoZ̿uJuͧtC.fBg[W@  hz۸ u
3ҫ GԡFԸF԰) uԳPs\tֳ _
oN0[ 0KBO

di0  @/pYY&i &&g & & & & ǻp@tp @ǻA8ێû0 ] 
 q>0d1&>r 4u=fSsU. 1虾8f[ ֣     sf ̀. /^3@"/^*j	r>@s   `z ` 
  "# 
 Uuo A t&r .s t ׈v; t@u"f(3f@O  f>  <  vI f) '@  wf fQf.S @!aA`uft}@ &|}~fr\I #s X 
8t"*e t.xy{ 0G	5	߈. n21_ >@2sP{ @
Ae. 
u	t \R

.O#52&~  #;h Phh +  t{>ar;h _$ f%"a j j h&tXX1f@XGISh<hR;[" tE"2s s1|1#x${0%y t #um1
#}$/%  tE". z$0% 
%U*+$0%  % tU!E"@q6X6"cta@a aoPlS09pv%` D 4 s4(tI5!R6B758[SW&L 2 >u
s @uBu
>@uj >Pu>L rp=L wf@rHsSVWU]_^[s.L `&O  ?WQSL O 33ۃ B@t[Y_h Е@u$;BSd3?`<u-!f[U :=tu
9 6w@"R>t>uL 2}Np6_[WSPR`ZXiL`q@ڊB6C &323 G&CS2  &EfT TdUS r&u&5W4SSyX&TW GFUW6nVG
<@X$OO&2uG&2%& !AXţ ױ@[_q@p/B @uo 0b+ b= u׀0bct2!SRUfVЌňL Őf&7f u&Z&?Zu `h G&!j &@utL *f&6  80At L "k2fs^] VWf @  !XfAm3f0 OOf  1cqr_^0mWV op`
s`=ߎ3~18 `D b DTDo   v]|w 0 ȳ hz`Dzw vl  Q  |a ( ^ |W @`D |L H`D |AW P`D |6T W kX2{`8``D |zؾw]qnAaw|\D sPiESE E ֆ S hGq[`gE
uh X÷Vhd"!!04v0i#!0@PQWh3 0_Y` 0nPQ_= `tu0 @fYX "@SP
&  ff& X[@h  @m pr  Òr N`BfRf JhDOFfPQ   hX.^V; 赣 <t. l~ tq.dri."D.|u.:DtSISwD:Sr5+zSs&Sv
uqPQm
cr`
 Z Z?2PQRa!&$`Ȱ hycSQW@a$a_s2 TCA6 @1Q0C@Զ@;uY!$00fw` Ch3`\ 33h` 049faÚ0.ph4  hǳh=S@|sIpr< t t t@t߁(t(tɿ
 2ٺıc BSfQWLH0 !
Sfbh|SrT  _fupQ#~ BBaTذЀt!8 DHhW	6e蚐Ch&cCf`  f0 ""j4 @,b  @{>sV&}uu ۸F!p 6USޑ޺
  % {yquH
hx=|7-v "h`"x@ #3su&138 й`՛`aPDD/Xð t
53h!@3P aW 30.o3О>" pfðdM`d"݄U~  pw՛FPؿE0:&؁` uM9NwNuӃ~ t"F= wt% @+7h5Î1 @Q I 	 @p a `w `0tsF4 vG t>`uD*䎨ffG adt5 t2	
 t tf2f
A0I؁Genuu#fineIuntel[uw IБ` 3Ҋut۰/g.f;tezZP:fPfQVWSR , 6jf.fffCv_ X/1[_^fYfXxjb Ɨ! ĝ!ȝ!Н!Ԫ!!F0 #؝!!f`n% `Ep ǠS
0fZ@[a,u  %_=u
??2QG.f`phqcj6rX 0eˋ;r<s3 0煱
!h⓱+d2fa<14t1(2.3f =~6X`<Uo<Ì  = C"%>'% C< B<?b$fȀt<p t0#ȋپP޾ Q t!uDFYG`0o 3@ @urf? uipG3G@.\G;oInU<#KKK	L u8 @Sx u׀ޱ+#hP="tM	UVˢ+TWPjFrX?r { PX@ASQ 32PEW\ݪ@fWCh&3
ftX{	`ϻ ;sQSfArG M3҃f  2ff0fXffG
 fA0[ffpgY+vAdqq_L2_&u؃ uZ=PrU_fS
%Pw? uCf*0nf= o t0ao t( fm0f
Q
0"p`h'δٻd 0Դ hFOW_Z w$U8Ut1w

36x|@ hP"F F hJ"P]78Xt ||SU~ 
vφళ3؋
 
>`тt. h~3@uKh3;Pٓ
.{95Č% < t<ut
u8ùtPR@䏈52u  w & PPXRt'vJt
t@༓ps軀d% r/k hvBP>u` 7hBs?d-z&>! rrԘRzspZ thhuuh	r`	 `'Zjj 6uS`` FF ph r{u
V@ VF  >t !$!$< uҘC` 
N<̣2<	$ܣ"3]`Aʥ7u1ţd[@݃TYP=`E8t 58
u2Ɋ،؎ Ȏ؊t<u
58ȵE$<u&w $ĸF"L  N L oN @ؠu û  t  Pإ[UÐu
j jiɥgI(!!2(<!`۫F Psu$0~t)~$;~~M~.#Kv .t4&^<r&.w 3.\  U.\U.d b ԓ 0 W	x .| _@DuQ&~% PyׂP蝟Xӹ
 |.:t
a ._
vXP%8Xr6%Gȸu{Ua    PJNL p      QKOMp @{t  t P(.DG H hsW hvsvhu hu AE^  f  Pp m o 
v %&.|t&ư
7&r"$.:Dt1֝Ku
إ E(A@]" s	EX&P 3C n H r{r`2h!rPܰvaVRQSh}xuThp4JB`.68u,2
t&6@@t2 sDޝ[YZ^SP\cX<?tFhY Ejjjj P &h#\ h
c`A5

t = ;t= Dt
hU[_WVSp`f1
0[`Ԥ QԪu"1*׿Oط߰hGCǀׇt`>J=O8 0з7FZ rhP0c}Hs^AbF0z!lz{s:^ ~Q%| S{t-$p<pu ʥ7{ 4 u1G hL>rP ##0w÷%hf{t<÷&E'u×he 3`R{? s#_ ``߻ С3_aaav-8af6  u@"t@"3P&&W.Xfu33ff&3DuKFȋ_Fo0hL pB5[Q6?  :NQ62  ?AQ6%t 	
1999r9>ʋFe@CǋVW 2_2FUt"~=2
u
2 
 @2EU2&&&EC&e?
td&߈EpC?&&ErECEF&E<r&}	rDwDDVW^2=^2*D
&}vHhf~PRQ3=o7M
}%MtOrY3R`]^ZWhw$>u 
g@vS > EvQ 4X\Y޻|ű-7: tYOWTY
*6h&&  t8V}t' u ,6+Ҙ6$ $ `& &&K pcb`d՝d^e`P`  XCtU @p
ڹ  . BdjB把8uG݃lAl;݂l5l/]l)l#CjwBljooՃ66PXi h@AptBptCpt֐ttuÜV}tvS݂vSȰvS`<;weċSzX؊H<wM3ɆQ#"XR< r|YыƊȊ3Їѹڕ8=H@xWIhu@tJv	2&SP߀k 2g*јf&. c"b  &k !߻< h^Њu$f&PBÊ$
 Tu%qσuh~s$档&^@Pf  f#f#f#f#f#f#f#QG,fPfSfQfRVWhfS&*LxS%^ff
fhf3f3ɹ f0Q0 f+f ! KSu*Sآ$l3lsV4C\`4 a^p_^fZfYf[fQ3h|SS
   `^3hҢSVtKVsV?q1tu*SWg twt	?Wt]ЭuG⻹ D
  >u|0 u
qt	 ߯Da`*2|^ 揀 _`s< |&?	3yt`0=;u]uՒ L-&^t
c`4,KBC Kernel: xx.xx
 ` ؾ̋h( t?{ p.`Y3۸ 2ҹJ%qaVWQرI A_^t` h423d%%h1S uP$<X!&sf _@  t< 4 r	.a$<u
! Bf3hh/.` 
p tdw t
^hi`gT^Dh=  t^bwY-s.>`HpfѴ0:^ t&6V u@? o > yc 7Fdef Fc~ck7~e uQC9  h#
e!6@h!BFe:Ff`#r,ְ hs״ Fds׻;  Aڧ 	:  <g͆ ht%h"hƝafy`Wp>Kh " u>fB !pSCA[t$û N> h9N rpm@Qf`   F^ß߰P XSĻ  y ,`   h[t(t@_t,ւ S,Ւr ' ah}t
^úwS."؏**{Ւ/.%^<+Ë/U2NfQdYF :uE1Q]13t
t
u
t#u
otNPt"FF!
u3! :5tFFdz_ ulmP	F: uY@	eob +u6F14
e
 Ff@	f&`up  jjj(j	R 	EaUR]qhO!2   A %! hDZ]RZr@a  t0aCRQ QYsY2^$
Q !u$SiՒ5Zf` w PusI.&dbfd  sP8h#  sC ƀuPu.>b #$fa 'URt9~wMn p 1o tq +N֋oi/g+ kR΀,u4 ?VfRfaphfY%% ^f[r@dG" } HhD#@۩Qh߻r s %61R#lp%2P s r9W&Z+q4*`.cu}Q$<u:Rpr"&  tBD tbBD tA*Qto α"P uG@zGS5@@ A RA@஢sVްSQ 3Bu,SBC[rED	˱"ͿY[CA* <ff<1`00xx00`6a{||S>>N.rWtW.@u[͋8*rAG ;^<Q7 {&2hCC  E 7rB 5{uN D6I00aacA 6a0 F (4 k aUfV3vCDPDQD 7m7`?f^]PFu໰%K'JVxPduXDP2ߏ@  'OQoRSTU  ".. f%p깘0~6FACSO4DBGP4COMPAQCPQ005A !R  m8  P0||3	 0Р20" Ӎ
 2/ RSDT(?  f`hthB ]f  fRAؙf@x  gfFgf` FPTR ffggFСfT.И^$f3.ۘ.ؘf.ԘhectogFm0ؠgfN~$wf+h@#(qD3t3ffgf&f.>Ԙf <3f(.٘t؟2*X@@~(@N g&F	f  rgcfff3ff+f+.ܘ⦵w1,.>Иf3d$!dP`Xff-|V3g&fFgЛp4Y[@aff=TDSwDt+ҽSt#ҽPtнSBStf=CIPAtf=PGBDt PQr}d< u{ r|RUfQ̓2 tS@rDr@v;0ੁtg&P.XfY8]P4u|fWfV`Af&f0.]Tx0@(f`fPӷ΃)Ȁ$ 4 
Ȱ ^~-~ff	hΩC~@f }t պhBfPW eԨfX3 LbՆ gfҷ.@P33PDDX PUUXPffXg&]hu𠰠hp4_ĀfPVؘ ǳPF	 ٘AP~rP۞ܘ^ FRW  h`8 v h=_ZK3VPS~tSP%6KfP3h f&L fPAd L fXP*`h " 03f0V0m&?   6Wu  ` pOGWfma3[ PZX1U1  P W>W&geE E u{MMpGfEBtXAt$OAt3OAt)O$fMorþ0mMe&Waa&ͻ   ø 4 謵DW`f
0Vhp ^! hǝrЀttտ ϥƿ@G 葹_ĀPShT'pێËҎӼRQYZ?ҋh\P*qf`FF  h|  ]uᰦ hT w$w(w,w0w4w8w Ã9FtFfNDvF> hɀ(fa`E13ɊMh##t

h"r ;ruaޕ|WFH ^
f 1 fNф& %'NLf.9su *st_8 rfQPH_%6rf;^uf;Nt7('ft. E
tF~Y{_PR0 &t,!U6F3ZfV!20f%
 `߳f9Q9"2Hw`86 s
s r"6
k.<t..T{ hhp^_P1KPQR`;u;f@B s{ZYXr10r,@ % 
 rC % rB 9藗r?EC8PC Bߋ A= X%@Q#W h}pYCEFPQ;t  euI]KyLsdB"K<L@ULm%KALCNR.0ӫZRRfXSRhSpUS@hUpV 倃[` S_f][ #u#{ Z׹ pYYuxp .au = `r~01rp&tj`t_& rT pEr&= us=6>
ar/6r4.a؋Va< t ^>Jv 
w x y`<  h{DӪhZz yPhnpZ%,h"Za1Y_aTrPqbtI	&i| ?#
%ia߳
qbtQ& es
%iGYkV
wh&i} Ͼ,t _؍vfA fDv  ,PffLs-<_t(<n#0&i~ hqL[^0PRU32t
t
u
Z t u9<0r<9w/tM> ArSQ 8qY[@t>"$,0>*SQqE;f |t~u] 6f`3a&!hYSr֎fv0ܿpehsgf9tal2   t?h1r$s1av0wEgf Vff3u"9fpဪcfa
[QÒs޾m3۹: 8tC|P #EШtrohӎf u   0   /? 0    0     'r ' } 
 9o/ "bFIk`C`9 k1AsPS_.kPVW ũǍ~Qr&} u©Br	ǩ:_^$l2r5r!r&E@&=u	@HΓ Hr&E$yu*5ms@YӆΎ`3ra kDTtr&ϊeÀou*D
TǓ
_%ℲSAi1r# t itct  t$2P|ѩffL p]ƾa> 3]
Æs@Y+Waz `:r8ud_QY_QþѵL[ r&U;`?þ0{N}W1L螣P2
P$X` $2LnB<{tVHο8`	8u6
uBp& DBl0t
0a 3 r/) r%BBpJ`ذ
; p5 a<t
B֊J ڨ@u`pۊB%I2۬2؇`$ڇu+Bl&2]8u\u rq@m riP~ ra0ñӀ tAc rFn r:i r5&D@u-&P$߃vFQ> Yr	2^QR݀ ڷYwBABq`Brm B%g_fñtA"p  u
癴3A`t'g&gf GVg&G$<lWf @COMPAQ PC Card SmartReaderLGEMPLUS GPR400L?PSCR bQLB REFLEX 20Q241 PCMCIAVReflex  v.2Tc:!r$HP  a@g&O Gd \q`fȳKrLfK  =2r>qPG	 .Da
qP
O@.d.Df.4fƱ_  @W QfV0>
G.g&:uG`f^Y.5_B0=F`ffWrz	@PgH		
					 f~#G f_dXf`j ș@<S hBg#P\g^ hqƙ < f= pu\ [jh rc Sjjjj P t\ hq[cuo"#W?j!&&i^"p#$&ibg'tq= ;tbu= <t:Vݳ մe o1j5'y,ZtO;]faî q_Etș@u)?:PE< uAqu3@ "1`E3@r$ jrπ D    re{Za:  -Z=A"=vzA0$WP701_ǀ uvu'": 3?g r;ek. t;蘵ek  .afd  0q@^PPfs ;t0@+Y[\aZ~Is3hCt&iP99ڻ 3ڻ> -ڻ\ ZF  ~f`  tI+r=? \~ t]d@tp,@ MF t wk`@q0sN aN{F ~ tm;	+eTVh0SJtYf` Wlf3Q fY@@ Fș T `,TuJ0:%&= t: 迼U߅+ rFdi@f@VQ&[UAw
+sY^A^
+ff"eUc
@Qc?:%@4(@av IhX3,o Sgp,f w(@ m 5 pVߑfHp-@dܻsUu`YSgabu[$w	oaqm03t3$G
@c@n2n||{n f~^\h1ff>0XHR??tz11 ~B__qo_C`$w_7R< wwZtHpoaq7yv~QVs>pfp^DUYa.&dیKat'mH& 5trN~st.1UAК`U UW "'$P"%&'#6(e()*
*HTuVtםa          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu
  	3`r]aq #6CERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$l	f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	tv2Y$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2pPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{ fRO fZ z,X
[2JKLLLLVJLHM	NKL .PffqM PMLNKqSR RLqSfMUPKcWbqSLZXV>YPsZ_cW+ P[SfT^RXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` }`5 _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tk f_TCM!p߀MQWfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR   8 39t0 $@ (!H   XF )0*  	 
`%UPWffp,"͆. 
2:_nPnf
f aOVW贠H#gSikW2;_t[lPmF[_^ð` @ p@WVpfHW ;2fA	f2f.f@fGfYfy^PC
XPS fS[s$fR
wf_fX$s[`fCRР%D Ð[AfS22Er'}z} uf8s֊Ҋ
 XQ iRP
_t0r?C#bE?E  uf 0úM % UPfPBTZ훱]fa_f]rffr%m?&On訡&Sq f@ yv` @D 蘀  @L ' AN@pUVPA_
!,= srs2
誱_ 	f^ i
w t;kp-rß*f0mk 	w:"Av *)ur6	z"+	f;򱛹 f{ 	BgRfPQNNO(aa 	rO	ðc
]

#/Vـ^/ f.RfJ迠HZRUQf fuffVfK蝠Hr=XfuNVFYQku F{MuY ^Y]9g><afPRg'QSVfNVFfL$H^[YrfXftA/3PX|`ڸM2NOPhUWV} spP  ֡ ^_]`phWUSq!蕪㋡ ]BpXRV 	^VcC  	? _? _?  _?	 _

? _?__32_  rabWbW /5GMp"f~""!\\]WsV.}@6.:tLp%u%%t>JrSW.[t'W._[u P&7^%tP&	%t_M_"EfUv"v t Ar,Mw ..V PXF
Xf]h@ &A ϴ2j@0
tp0 n&u`G\ô'V2&c*22=V{W&).6%6.t.I.
Lj@s& `7|9u ޠ0^SV)5D.d.$ʋд×^[!2q24OÓ;c>j>rcOt@	OtOtLtDbWt
WttWtnW6&
6u	.<.}h δ/ 2;>ÁUu	U !p0пR%G r<fL\-`0ZfppI@>I<'K i<r|wfD!u
@OuxмScU>uP؎&Brd ȎXW'&bW>%S&.>+SDvu ߽)PQRa 3dB &Gݾ&G $@X$PCX&I@X(USX*B>F &g0&G1&O2#W$ 2&G [AX0pp&?sa]sd R@X@X_
 ff&GEeGa~1a!f"af@Xa@X 3SRWP޲ EvravE2LuRE<sfQ&LM}3J fYr/>WW.ǰpEGgώS 葯./40[Ü_Z[QWV.>pՀtG<tFr=PQi.E`o.&ݿW>U`ooo%o5om' 2َɎٍ6W߹ 0^PSRcmt5ێË0S.g&GWf&_f&_J0{2Z[fUf6&)Stf]ð4`d |ӊ|~SQuP $@X鄿uBw@Q~ʿXUăZ$saq8tu
֍9$
,0f1.1Vtfa茔 c2Q <V2V <W2U ? P p4T `Zaf>󾰎f@(6Ks >upL,2>(f}`$В$蓳 0(dՓϿf$━(r.,>, u`RQu \- u
袩
@0!q@NmV_ ؾsStR> dr. uߊ؀ˀEϠDA3r
ǡ`d[Uf~tf r	.a]+05&&U v rD~ww5AϧC^wC w&w\}C@?ti߅k9CMawW7A_Kޓ}Uwa߁H&ߨ߲pmܛJpwA&Tpm"fWsA1< Tx,u#Xx f3gf&ff=SCAF20ǆf_U< U
 	<! F ]PW  <w&< t'V3ɊȈCFƀ^ t	ǰ贇_K V<v^.ѽ
tBr ؋BuQ y2Ds]þUP XHsڲ.P,Ou2]DD&!Q&P-HD7FhFlJmFQp9@/zQ70&'"
pm5kvCi\rr﨩r#Qr7жt'kr-S"b*p foŸ iy["2ɵ"gYà`S
[PS3
[
U		X 
aPRZXø
곰ô	u
ӿwdHQRsɄ3ɺ?Pr=x@NI23t Q32fPAMSVW_^aݳɣkf!W_1Nw hᶾn MB RWѶ! D   &FGvv ؿp c0u#' V&
;
0f30 tf"	& 3r߆_ZRGF< u u2DQP2Xð =NuB=u0P fБܐԐXhܚ8N $S
q-w4pԅr.-ːu4 $
pKr؊"fQWfPfS h fa~f8h ` O f4@kH% pސl f
Pġ  rMf[5f 0f%r;tfPff0fWfXPxX_fYRfx ffú,eZP?]oXfZ`NfSp`d f@u0
f<0~fq
Qef%
|0pB_B3̍`D!9
 觍Yw`fft" QB0Y ffhfaQfRWf fbӿ fRf3fftf fZfOu_fZYWryѶtp g tc@݊ʆ rQ L IB = 8 3 . ) $     0﷉H_Q&GYða UpCt" X, = sfP  2zY[$
Ȁ. {	`F@ 
@{N8tS.Ft  @  - t03 P4"p4) 54p3x fXaRVY sZ  2Z!-۳z-x.y@/$04 N7ff`4eA fu4faf7?FD` 52pOtfߋFP0^D@ 5 s f
fWzLf_f#a-?fF$5F(3F,F0qOf36rB4rf-5fv,Hv0hfN,-!Jv(JXTK(J$иP hN$fFfV fN߀u@2N t
ff?FDl@H  N x`P:0SPuOfYf#f#ƿffÐK0 CfHfVPf#f@f+f;FLv CLfFPf)FL@uFO` 9Bfz0Bv1OfIHCU H0Wwf*͑
q\f`HfHNUXfWG2BS\NfAfB$b!btV;Vt
fA[ĳC N f% " Nb@"	 "BF0g0rXhKFUh C PgPPqW. vQPf_aXPmSӶ"t1$u	mY v
v[_ZYXS賩ګqtQmi Wv߀@vP`z6u:uvQ 
 uˠ
 @x@Ü08 ` APg\0B`5Q0ghh%}XhB%aj(()K)u)*')!#))4*fȑ
`(fP3Pb(  P] USPmX[#<0crh( .(]uESx 2
߸y $55°óSz L{  ~  [ß3r` zУ'$$
Ȱ5@
PM)@Q\r`P)XpQ};r@SȋȻb(0RS_r, SUҔFfAf?pЙtSs`SP	qXP rX[< ָ u``$u5`u 
ϸȸߜQh rxyt_u	 )P1^<Xs'K<t@""fS b˸'닂[++++d++++++++ ,SRWP<O 2°ǥ*  . ߢ ua`   
 ŗ k@*Ű	ް = Ӱ G_ ưc|y rt&roMjrey r` [rVj rQ rL rGpI =t r8 r3 .r)p%r$[ rѺ I r
 rl0Zs_{Z[@ u	@<t<
u@@5߿u
 zX?XQ`sx0X	uQ>QWt,pt-<v<uQ<r<
w[Qt0	sZw"
6MPp "t@~Q
t	e`@| uÀsHP ϿSIMPLOMOTOROLAUs4.~ЎHr"ϋR 
 &s7``WLf VP}/pVSE[_;ŇC.9#8~C >(> `$"Ű$v$Z %m&P%d{(ŀ'[SR1&3-&Z[>*&:,0'11 (&1 ? t
@.+؋Â.~p(>3Š% 5% 7@& 9Ő&ж L'AqM<St<Mt6-q}6.
6
^V׶?O@B9#}*Ue- g!U$ i kAU m	 oaK o0qq>sxpxCsPPcupUzap|pU~~pup-l퓯T+
BՍ>`&~X^fVfW@@1?` Q_f@R
uf;t!` 
f`Ȁps]a
ft-or(`
tE<u' @((afaUQU F @E] < t<̿<t#v0
Y]À4ofv u
ˀ >uр2׀<@ ^~
sR0 rgff5 A	jo tP  5	# *F"0#>`#~&#P<"$@?pmRP9   Nff3u
t	!P ]Jg=UfF0
	X)-c* gff \P2^*q
/efPQ0i1! ~A+
Yz!4 
уnV녃8 Hf<t0: u#f| !'t
fa쀺 8 Diɀ5j2撰T'syex@ r? 4 ?oxپsqq"q$tfA NORP
VXZP <u
oSQRp3ɺxZro.4
X `.4afV`fQ
uP	rr"V`Ls@#1M= 	 af^`K*2P$NT@׎_Ǎ~WP0QF$
&FGT&U_b8K	vB;k0ø3 PV5<^Xt>h?he?'BZ!uՀgtx!T7U0c# oVmm gt^sغ Q Y3ɃdtA`0`<u韺`<`҇` 65c `ךּ`ۃdnCaձb@c\`2aWu?` i
m@j_f`VfWgf  #EgrPrzrPrܺrPrvT2rPrP2PrgƃPr gbvu	f@w1 p`,@:@f_gfAr`gffgfĀq}a"fQ0y;gg&fGfXf7~f;wf+f@|+7gqvg uffzfgf&fas}vt ~@0y3D~u|{@y}ff _gf3х$"@z?@rz5yQq`  gf3fS 2Prwff#ӒffyZ?'wf3f3pn,;w6-#P|4ܼUbf[gfr ffP҃BǊԔfp+ȡ!X!A?P
1y#ӍwySكs À +SfVQ g46fFC3YQ sYPVf^\t g&{pGCffT ^[`)RPb
oPFC'}3쨀t
N&A ju2ltgR't$<stu<t<ta'6FPF諳@ 褳XF᧡3tĀuC2F <r0
t" wtAN}`@СGv <t] <'wVu~ $<s?<w<'s*1a߃f ^YNuE 8u| w&|u tf~ tBǢt tPi tEa^ t=-Ҽ t. g-@uGrP G F 2vP6 X'{`@/ P[FPPX,utzrϴ
G@#Sɠ AI2f  
 u$,@3ۊ^Ð0[RtMNZB號$ :*!*
BȊJ @t21?230IôbR9 Zð 7PV
䷠<wO'0ð Ë tt	@u6 Ê
tw z S3`ݴGRq $  I,
& ZPI!tquq&}àBt't!&C 0tt @ pAۻ /j >N w1 r
?u q^< u'' t	3r ߀u  [(6siK`˰ )뱳2 u<RDtkwЖXEPK?`T} <`Ps /V ttD?R 5H I+. uorPtPtP<t~ S8't
 [lucs 8tKTu<tB >Qu3茫$
Ċq u)00~  
 <3V$PD_P3Ҏ¿x ȫ?X{A8 aKa.lbAi &g + ~ Bpa p
u
fN@ `]ϰ2胨u!BS\8&&G&G&G  [ !   _`\&_\ppF0 ]..@3 и( иA  2}P BC@`XWPpAи3tݠ w*O $@M! ߀& X _ѩ@PשXb$a    -3RR4~f\ѱfQ$mfYg"MZfY[ø <_3]Ou "'2jfPS=Au@u;p u39 u+ f?wuf_P@u +AXu
_ff 4=%{AB{N{Sf({-..A{&{. -@{[o-1..s-{2{e{3333{{ 0/36V.L#.:Ls&3߻.DV.Ls` 67r2o O:}626ǃ6s1=u K{렢O^z=6 3t0>t
t
u! lMpߏ Bu 䐺 tA>>W. .W u}hG%HӀH JFcG}uLF K u3pKuvFbW~uK_tURQ>bGU ?R?YZ6	u>^
 .D +Qt#V
6L	^ 
.L?e6]Å: Q3@& |Ys. u&	 t	&Uu" ώ>S |  Êöp.f.|fP@ t\ .|j1Z߿_S\\J]K]PQW 3ۍV=_ qSRW*׿OзIr 2  i3ɯ_Z[AbQbcs Y$ebсc ro3O%dhg3@g!eRQWSP b$X Q"OIhAnn3lomPmo"	jnsX Jmn	uhoX(o V_  m mP)v[_YZÃU2<UuX½ngDYJBB7#{ {{qmrnsd z`s!uj@gPnsHg}؎uvX~Sk
u	 Gտ ت *ê/ xVWQP Dt!WQP:t
Tu8v
Y_dY_X?Y_^Ça+P  Xtju3pqt$t;73s.t;IaI?߀tOItGIBpt9t5F  F  F`Q
  }P(u<IdrˌN.TV
 8u
r.2^.ߊlnLN0si? u߇X@V pԇ	'O	O"O<$OIJV	uuLrx 0<u.;TtqtPZŞQŞHJ `e{33[R@bZuPĞus9e
< {t(¢4߅ .胗so3AZ	PXq'Й'tOTV WO"b/ILcL0O 1`T! t`<u
 @&   >@tAAuqPe@u  ,W& XVa  0`O  r
 P<Fu u}s	Ӹ uqᓻPBu	 X ¹tG` Bu6FtEuUzrPRtKxG#t& 0R] Zu$Duh?2 h^#
Xuh2X&  U au@ 2@BBб{ryr
R|r|r d P dXP 1& 8t  QX uS1^ `zUb`*:q 6(" 1Ϳ bP @ͨ@XQ@bdY  
 @ ` u,0b s!=$P`Na+Ё$?aځ j@& r-0$<u `
;ud.oMe3фS{p $[u:
t5<u
.oM u'3۹ .8rMtCSۥ $[
ó覠g ؃.0[ô` ab u ppI $
N tt5P
 `'@  p #t ЀuXR2 B8 Z& B(PX `pQ#˰`SR `tϰЂ$#踻ZP2Q|3ҳ@׍ s~p`_ЊOb"F W  "VK(+j@ t PS,'@[Xu	Є&A 
tÊF @ N
F&? 
ĺࠋ ?00r#}&\
~tp#8s^Q ^yu^B@YÊE *F&dؠF`}G`` t萋
^&>  $> `^紀 Ű' fF 1؊恋P@Ê~
~!~`! >_A  t	}Y
ul@ugπPFF $t}#* ݝu B8t]G襝&@60HVpC;  `3ə$ҙdY &?t+aÍ>@}
t"K	
t>U .:Ut0  QXV tVR+Z |!G!Gu-"$<t"!} "u^^ Q0
W3һA uC혂s`ks2t*RR.u aێ_Z
tqsN"uuq 蓘М
 Eu+Cn,
Q suQ1R11@2P+s4XPt)-&/.ڰ/s20 
0
o[u1P2?!uX<$PnP!  T 'T T  <><fPff\fXtfUf@fSfPfQfRfVfWЂtg]`rfw qC?rdlf_f^fZfYfXf[f]ge333brVd4Ad^;sgu0I
30GIs M pCtAt<Vr0HdDgį}
^PMLVWd_^gEdTg}IN

J}gE PKtr0H0It}d8t~PKW<yt@DrPg
0HONfU@Of]3
t QQ u Ó' l.;GtD._ pDfg6$+' +k{@=   ]S>@=]p\^]]`&]b  lFpoypOIEMAG  IZ P  eb   	

 [ `ShHDA-L  HDBiA-E#iiCUjiUSB-FLbkCDbkH3lLS Intnl  PCI- mBmC  % eOn_n9oIoIoHo	~EoP 	/t<M (W`uct5WutBu	OW W` @ Wrx ?WCD001EL TORITO SPECIFICATION`{<I#1IdmrIP0Ifd8xfrId6xII+ JdMd5MIpDZVdmd<d;]tPtd|d]^UP~vЎF#^r' ~vFUn ]~p
 X  "3
''ذ _FǰF/X3 .;v+GuBG
F/{ Ë?% 	oXƎNeQ
 !0NYb%'0123456789ABCDEFS ۻY[.[ZZZ  A " * Gxx px y 1 " *
nxҝx 0K  @ n ϠQ(B ?9t{8y y P é uT0EP7ذE
U `X
 rZP t
ràxf`i2tW &  qN&E3ҀtB&U
&] &E tû4[Hug&׉E!{fa (88 0pTP3` w AUBPRtACBZrVW8 `1A"#B_^1f`p't!PS>[XfWU t6;u+f_ ff|@ŋ Afȃuff#A]_Y[}fR크QRW$  r $tuU_ZYQQ Ybʹd<tg d Pʫ`΀ӷ͸fξs蒝P΀`u%<낷gbl0r*578F_'()+7  À[ v5u t
&  `
x_t^t]t\߀7utFٖ53< v
<ar?5<{s1$PɎ]Xu۴ôr2հѾsnr92@m ukAG$AuA@tߓ<zw, [tQ	D둰t
w
"nb2]2nSJ, E0_G܌2)P1
 ]' tor@r}	2vPQ:s	} 	|EߑYX p@ B C _````__g]ǊT tTQM3TpJ]!V
T_* uc_T,0 0SQ>Tu5M֋ôuM% Hr<9M3 0/ 3Y[ fSRV)ǈ&
T*ǸXMmMQM0wtt#垸>L^L
T 'nLƝ< tD3^ZFX躞VML00`u   L`r- 1ZlL	p	߸ 
4_r uQƉTTTFKt/w*VR@8ރ|   t.QaZ^]aaaa2bbP .bBBBX$JJ2JBpP ܰ舐etJ ]Xu1  SQV tA&q JZ  C@u*݄uP= ]Xruŀ݀ 	쀻 ` ن (8SQ2<

2ۆ-b.
$F2g@Q <ww !
uPɃ  ` 0   `  aU uPЀXd]<tG r
t!Hd8D^u @RWulls/"-T^uD`|I&
yt,t&M1&G&að`122LAAAa+Íu 2Sȃt
p9q:a9܈$FKuðWQV1u	Y;Y_|<u=>S؀uu)蔇4 @  [û2p n l B`CC C #  UNȰG@2Ҩtð
10:,0E,%F	$ztFø
KᆊаچE	ӆ F2̆s s	2 Ɇ | 躆賆H	@I֐FPJ{J2IÐFx tN :p
Ht@ImIf
Q$J
Xߡ$桐F= JDR.$J5<dPdcddd
eCeeeYu(<sW .e_. @9zYP XsZ׃ZT[QV.u..&+.	[? @ t^P.&u @ u42..߶
tbwbbc*,*,a&u wXY\3q<P[ A3.G@;
=X$>Pggh *."iAȿxir Sf3[ffÊ$Rf
|f !X$ ofSoffߋӆpRq%a{nfffPRWS22fPB r3	 G6u 968s܊[_ZpQWRfP
t) 7rPE6ff  u 58ufXZ_fY}Áv54 vv 5
t5wt5WQ35rO5Y_hhhhb  :c` G "W *0`(%AЫb YeoKB]Op0ryҮd"{gF!BRQ co̺ YU1 j@@Zr PQRu6 FaԀa$8uPP& AXZP= u4Q E<Yu<u
 u!uuu@>蔄ukufE쟔 Z@F舄u5PO!jjjjS  DUąƤԄeaRepDC(!gF+  h} r øK T *"6VDq PԴβ[gu! 5sU I⳿sVV  
$&&E@&E
1EF_ݲ-0 ȣ}>1]>@vT  T U q_ _ b  bA b  U	 Y
 bb@AbBAC  WP XQ bR  8XS b<XU @XV DXWXAYAZA[A\A]A^A_  7k` Bka skb kc  ldef GlibxYPj1hrqWfVSQfsVF! Ks^(2۹   F  +^D!8upgY[f^0>WVQCuK3۰Ϭ} !Pw $I^:u:\!utϸ \KrKf^Y[_S`BmsV.,ذu@u[Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZSط$0<:rd uꝰmP@H @= A& pV: fgfF迶f^ RyZÜSt	tv
vt[0l؎ Ѝſh@ofVUu()t u3N@f6 V(u^Pu(u( N\p Shp*)tE)u((u(t!(F
@  
]]f^QSWfqou/ r)v t!ufPs -fXt_[YfSf<t;`q3fÀo t	fam- u
utǳf3f-[f[5
 Ba uZ0Qxpo
|po
 _Ofccc{c)	     . .  GN Nc c  Ge eg g  	Gt t  G 0E Gpp)G G; ` y@yfPSPBCff.r?rOp .rf3"`vuhX2 h$ vuh$aúB  %'$:.rϻ@ f`X D <+ffty  Qf3+Y0,,E- ,z++t+ K+Y ,U^O-K{.</b/0+faavt rIu SQRVCx 拔 tcPt > KXS(x$PXr$;8u8! )$
BB;JJ84HX^ZY[ϹU$JB9M<9O59)>%9S>NS??A>(dg9xmRfίu@ (0D$QfC>$f6`D׸@8Yr _fx0|m1C.XxPu:mf3gf&P!f=SCAFtVIG t"ffff IWuf(KLKt/fPf?8 G OFp`I Aӊ)5ٸ0ٝ4VRB0٨tG!GߋZ^Ү 0sٵ ppB$
ŀTtt3$
8 fuBf=   s:7.
.tff`DpYf0f$pw^r7>. t SW f 3f9$u a ^^w&t@a$u`G&uF@at@atA"]` ( dP 6䠄t"
   f_u$g!g!tg &k XQR3Ɇ~ 
tw ZYJB<t$pAJB䄑mmBÐ `ÁUUufZp   f   p`rPqop`P^t
Xu!PSt<Xu @PFttHta`
  P9kv=@v=kB  NNOp
7fpzry0Or	y`g xi &  OR
s_d~`~ȝa
_SM_ P_DMI_ >o  #~gCOMPAQ{c	" y χ/Oo ϐ/Oo ϙ/Oo Ϣ/Oo ϫ/Oo ϴ/Oo Ͻ/Oo į/Oo ͯ/Oo ֯/Oo ߯/Oo /Oo /OosV<"5[5C0#  
3f_evx?gqbńD
 uj@ t%v v t ArMv .=sN-f-&A F'N- aύ6U v@ t30lQ4r r	
F (|r
	u^'t %?	xjQ*1_tr`/5rr[Qo
u< r<0s<"N@` \1u'`$nv`f<0r
sujs>bW.u.
I.
MȎ.}u tj@&u |t
p! ^!N%V#!~F2r20^%SsJs 6< s
	OtE""Lt*$Ot"#Ot%>2( 2)A *$.EF2d$!r]RsHsߴ1I9 <$u2t1*<}#1"< u1<v<%12 Æpu
F!UF% 4F~&=r&}v&fP&MIE&}Cf{X s&J^Ë^6W3܋F'o6;rfg	DEbPQ~(LuTMsGf-}39r1>WW.  -.GTώǿS 
?	./40.3V#:Ttt<~'t9r0ҢAEE&W!
DDH%H5迶O询&ߋ~076W Du0JfPfS8f.Wf&]fÞ@90Ad6'6QK  Kr?}]KrxQTKrlKrd|tZ+ٿr@
 u~ (um-VƎދo^ @TtfUfUfmKruFr Y<Kr)2r$]/KrJrRVKrdNK Y~P
 >r>w
u ?fSfRW ـ?f.Effff`Ucaffs<  MF F
]tSuNff3fPfVWf.Wb*f8f'w*f'F'*2t*f
VvfVvF_fZQNFsQU n E]YRPXtUW:>WL_]sUr  NZòmPRL2B`q`qĿZXQR`Uً  vo^ZYPpB0rSQRAP syI m ?  Uv H}]txv`d Z^Nzdv t JIr{| rv= %>W= !W1S>W KA, s,5<s-WO8LpE
t" >WߊG<1#w<1$~0\WZY[tPqmX wx k waHrzGruQHri8NvHrWu
pp%ع{ {qMHr.Ǵt%ttt t	tcDa% suGrG	 2PtReZF sH<t<)t<(u;>A u/WU>5 I]_ޣ5Gr@Ga`@-Œ^aPp0rPSR 2?Z[@pRFtN+P{X1dX	F
+3TU XXF
t
 
`{NXfS~ t=~^f~^^~j^~FF
1dFFF f[fQ
tW 8ؿvNa^~nNfnNfˈNnfNnĲ~*Ċ^
^mqdfY SQ_fPv j 8rCЈsfZRfXfPtFfjFaVv5dސfXr+t aa3kp tff    af+ kYÀLޠ:u$`UΎށJ2Wt
.詆?^Pp fF! PX0r t<"u<"tNV3޾x 4|Q&?ws@ s&  &GG
  P&O &OPLR af&GQa a AM8Waaaa׃ Wc  kX<sQVWA:W 7wtN7uu .G67 u/ ?	
͒ t,6o!OGA&&d&D&t&DJ_^YXV!
]HA}"pu`̀W
߰ F^fW[t+ 1PC>=$p7}FŁ10 uR
rrpU~`~~_aP0Pު~Z QSQVfff @@`` 1〠^Y[u(F`жǃ| ^	0u<Vf
o  upkr\^Ý uS]B^[;`u"t1e^~:Mt:Ej:`:V	:~L
:B:ȿ8:+.
u&^ cu>q6f_PQfV 3&=Ut\. *f   f  g1MNg&*eE0~ &u1ރ~  _\f^ftUh &]S^ c]0q_@Mu]DDV0& f\L
^RUfW @VЎ`& f`t@ 2 aʃo^pJ
@
&t_ 'f=먃'+¡	f׃;28EA
p W[L 1Zg&G_F E!330grru8T
f.f_tf`؀QMStQYrpfYf@
,S	  !f?>D
ƙ 

;f!U
UEG &E/"A!h{faÁ'"$nOGAw|$}AP_@P0W` a ؎w`?&`,f`f<t+fQЋ_%Y<%
f{u00f, %` EpYp"ffg
]5b6B6#7%P5D0w0Ðr](guD">uf.o@%:mAVQR:$;<$U=0yT}1^30sryi>l/Y^B~V"
qv f"f(A
Ѥ4?6'$PVpCW0H0L!=F
ftN"
WUnpf 
9^T
ENcfIfWfQ@
01
 26 G^OW 	I@렃(1Pu^#
~yi>ƠS\3
`0C aؾ:% b	EqI'85f)
h^`
_W3nvm!	p_ 
jhQAcR"hp?x^,`
ʠ"Lz	= YuQ0i>f
\vff[PQRݽ ȱ߀uXu@`ܸ1t;6p6 6 Jߎ13`,=
u
"=

u5w<t<u FQqS $s
Ê& 
 [<uaw\wWQRu& X` uOB`'?4&aᎿY6_ FF';Іt@2vPF X ꏙ pqDӗ q	t 
t	u%P @ 0jg ,2O2Ŧ м  ?H.Vt6}H<u@2Hh*2 hJOu
&ts@L1A㞡WsWt% ps
2pN |  p .Dt.D
uR`` 3 &<a0 ` j Q0Щ H3Լ{h  AGQPҐ!AAXY}`.\.TώǍ>S.ߋL `a.D`aQPƌPXXɎ6 a̛؛ߛSQR@r *.mfd /GPߊ؀q4GX$#GPcdvd
PzNqF$B3cr2m5WOqFҸqF:XqF1ZY[95:P 2XPUv F t	F !Fٽf ]XbX
f  ~<0 u<0 l<c<%Z<a?Q<YH<?<A6<
0-P= PX<0<0/o<p0|]WfPCI 2])JuQfRVWfSt$fѻRr f;tN紃)" f[_^fZfYff0!r  f up
NPIu I sͳ r 2SRPPRZhɊȝX_Z[-ZEɋtܼfq	PfXZffuڊRWZt[ڋ@ZͪtF*f@]fPf蜔 s"0s t s t  oQVW  s &Eq0NX Z _^YжVWPwﾐ;t
X2 *W 
_ #tYX _^N sRQǊуp7 fPPfМf?f 8s2fYZ 
CwzVS3 .:ğu.ߔşKu[^*qBF@82_SFPSѷ͟F[C3N[v QF ?tٲٟsF2~pٟY7A` _`8)d)dt	)`P	)	p`$ $%	*P'@TO OYeʠ$	!L U,]t}q  .]èߡ&&!$ROr.f% UCESksf1K3þ0K u"&fuf#f  0ssW3RQ<t2f3Cr6+蹏f 7u g> tt Br(2uY`[pW  !7"H"@)##эr$$_%y&fR5""t?t
Nr[2cfZ:./!*// uK0! V.8/-t( $mr!Jq#Pt $
J0&V.JH1?t:24g&{?ٰ,607cq77g8tߨ ,?tu
?u$2pH@t @u `tBtU CB
@KCq  t>?AFfMAFuPGBF} _[H2KI
t@ 菇 t}?2bIXriff#LfR f0 荌rGfZ3tt@F$`PF,F$t qQF Z8HfVQ!} r#fF _PS`PPFPWFfF  [XcU1F$P8FGF2V5WF"RF(wF@VYE$PE	R \螋\YSfP*fX@	ش [ SQWfV~W  t_SWP<5t^ufAl+rpf^_rkp0 3Fû PFKt
pSM!g8u7RpЁfVW=^ tH u# 1> &=$u&}Fuހl1ul0tfA}f`D@td_f^WVI.gGF< u^_`UQR׺s
rD.\0^RǊqàж oqQRȰNOvvvO1iOvwYOx+wzwiSu
Ӱ#|_#|[PZPzOXwwP||{}PwX( wNO|؁zP}P uht_wZwU
uQ0+rEt>~0+ r2
࠿H r r $ٰa& $Aٿ  $ 
gpcaq2
uCr>z{wwrtُrG Cs/Rr*ݎ_r
Sr`x2Ww' ^  
 0+   t3\Վ\ww\$r:WQ~?  `󳠹_s0 $@} $O $G1c
(<Pd5bKP@ &XW<rw؋ .{_Swt 
'C r_
p0[e膉u0^r!<u	rr&WѪs" r2.t`& rs0ts  rP I8 r && rr	}eô Ss+&' @>' M_s$|fsQ>[ W r%z $ r rȑ	i fд" $ ЫeMPm X!-ót s!-@t􁸽	`@pt t
@uqYÜP`
 Xr`QP	Xd zePpȐ
 t	`p&X˄d$!<!tDA>ϱ@tPGX	fUfPPZ;f]Cfŝf]r SPm @WnP?W @ JF@QD ]F BL  xBN  0BPa_fasa{{ݯA*qAAݰJs@PFF
]X `j j v
B)Mf.N. +tI F ~rp؊^)̀uw t&oDu⭋^^t<a.@t&ã.^2ڀ36t6^2. @ PSF@g
t'.:t	̰màX._ S ^Q
!  z z8   zPRS% + ;w[ZXf Zr-s(@ RH rr
 rR+VvF\r:Gs5&DC H PrfڋyQ_ AFÉF(t S^$:u [r
F&F$ %&=vHH&
D&d̠u ~rc_wu
 !πϠP&DB êĪǪ׭` T Vsc  HUrap1s!
 -s-u fq
 E PF 0G )
V N8tr>u rG ۰o!F])r\ A{r=8rWWsTs`-#@Rr
 s@M
a|o`k$F("r#謂Qlr@rk`<t rF( &d&KV& %f)&t N.f`O tRӊǛZ00faVWFPѳ0&֛fXfYʋދ_^`!(+/ 0 ppЛ$
՛tt$
ƛa uCuK,?rrA72B   树 X& @F$$<r$:u s
jút좌 
   @738  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%$`BG B<(0ø fF" PXN8NwN o2N?!`GsHOßGHmI|p
 r
sHfQmr77u4dfY_"Ø4&%'Á3bR&u 05t236e CE V/QB A9O9 B ^N 4s
3
3u3`YdS@Q%uèt?àt  !'4V&T tu^
*&u^  T>  K@QPXuN%&:Lr{PQ* r$C`J@uN<upZtQ.߶@  h; E 7Op$<@tgA9Qj9" !$!wQj  BoU{>0VùgK<P[bз#*E.øJfUQEufVKrK,ugfmPwNPwVPwFYfu&gfFfff`MuY2f^Yf]Ë: 3R)QSfVffLfTfDfLFf^[YrxXt	A3PXfM"øNOfSQfVfR@WfP<0t3   fRfZ+,_f]fZq{[PfW t0tQ uUP@XYQf}h PQ `YXPt
 t$0t]1`˻|tXRfVFtf^fZF*TVSQWfw#t {r0{ Ԑr	0{ _Y[f^QWVKǑ}^_YÐQЍW2! u[ك!N[P] R Vv 6^N  (m VI>R pm^1{_fSQV3۬
Ê^S DЭ;r 2p01fffa[.6fff`;w	rf;waf`f`PS`*. " Eu Ц?f%4?^oAR0e$''ذ10 +0= <r <3fȐf
ffʝff   f-;  ,QRW>"pg3&G;r_sZള <m  `Sh Q	t[c )exfsC3    )4e f       PSVз-轿//߻߻/пǻ.u/܃&&^QQ p_fhbs`@ ū @hfYX4Z4f4fZÀu< uEuPPuuZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .qM荐.ߋoM;c;ӐR.oMPBZ@QRW Pj<rt2[U$ԁ !Ȁ
 o -h?" ZYSUל$/ [[BuR״ xugߢW S5]W .4V UV1	 &n ^E}_&W٪l _Z@- u
BJS:U@@ַSR ٘S<rP
 j ?G 
t<t  ).>  g.s 
P`R3qAB$3ɠo@ q  0pFP a & '@M j
 t'   ``=' d u @@	 K L e l  
 t " `     	=hHewlett-Packard 68BAS. F.2F 12/10/2004M hh oJ
 O

 
 o@KBCXX.XXv 
H `o
# h @  A  ! U10 Intel(R)_ гQrnal L1 Cache ׀2 	
   PC CARD-Slot 0  
 32  
	[
en|US|iso8859;-1
 `Q Pa&Г &p DIMM #18
*	,92,- @*"̈́ 	гhSST49LF04P%h
h_ ?h@2~h .S&~h
8Rf6гb& P~

@8 hPrimary_/~;b&MultiBqa=>th  c0$`QFh  k
F hr !KENqD7hR
	

 Jk_L	5ddO"_&TJH}
N_o bat@ yG"PQ14Qf`C t^ӊ蠈0
faQP0Pt趈XY t 0䈵 pp賈$
踈2j$Wǐ_T*u	 E 
yjt6c)ӀuRct&  5& Qc)u&Qcu#ff
AgQcu_! 8egff j5hhk(ll mdRtYpdvMjuG	jpum<ppu3puOptRcup ts3t~Ag0>pZRtpp:u@8*6R:EFful_EjPg} ,jtTtt߀EtHepZ7AvPF )t%> t:& tSu0ZEdlul?!3oqhppo wt0z lvE>I@fu	PXfuP3 t赖X,tt#r#l@cpsy߄Eo wuotp]ot0r)f"lq =σE35 dx3;r.Dv+WdXu4nr32#r*u!.7ð-rhAr	Ss2ؕ<Gr<SvP Ê,GJn.r]Wn#rJӑ2 {us
<.rpwLu2fu@lrߕ2KC"lnr렐s<.t<+u
0 uθN<-Н" uJ,0r& 
j6 ?;6 opÜ   ad `
d`PQ3`t
sǣPä0Zrdr
`r`P!0!t"Ĩ@  
 ް  XPJXSP@  +. s#. sXP &   &X[çw '7Su!̤# `ur(D
@ vArdHvA.sNfj@&t ߉FNfaR3V.cVZr# M u16Uurj t 2rY@ u v pr&4W&E0|pr"|(pr2|mRs ÆUu
FUF `蛤	pϽ徰-}	ԅďrO	r蟦@eg5	ƌpWp	^F&?s s&  &G&w&GP&OD
 &	GfPfR.Mf.ݷ quE	_ffwE׶ERVfQS/fD[f@  fY^f& u#f&GWfAރ ܉WfZsfX@fF~r  t7 /r?@08  tB t 2frVʀskV	0!cV~t$@t@u/~ǉ~ %NVg`se^Í6W.|uL軼..gV`>U .:UtapkVaOWQS.ن? t0.}u.:Mw#.;]	w.:uwPw.;w	w[Y_@ p]>ـ?r.u|
ՊS ʋ.EQ͢v `fV|fvdǋD؊f
@NP@.eXfȋ.us$
2
{-fXIdDfUv]f^PR-Bê    ZXRPXuUW:>_]sr  ^$<`- r!P@Xu@>~ 	@{<@`P bsXXty>Dd 	 ~Q̀> 2qZ Q  PR9PGP⫑ЪX?rarTrOt :DvL*DA@ umfm@
Нr@l
u2 P%&:Ev&M1&*QE̂oo@НZrFnr;@u"2#u< r
t@r&du
 Zr_ rRXt2 u@uu+ u2	S ذ1PaPQS-6=Vǀ8<t߀-=V`/<[D
>X{`D<Ƌ%a`t>;P	 C@@_`4$4Q+r++Ysap߿!$!"桑WPPQȎ@Jr#@Mwq t߸ .12:Tt
 uOuA; i<s& ? t	23` >W}uE  FoV 
 VsVV<p3f<u^<
uuHMIE<I9<t5$S1p[|u |
׈|@Ku t\_^FSG}
uI}	OaJ.oVLMMN܀}|OKa`EQOP MuDRaQ2.QV 3۬P+^YD 4sSfAff?R^ffJf
!
p`=f F PX{PfP~dѿ=r0&E{w)Efu!ef`fu@Cu~`aSVM|`|tpht
^[õ׹+صu5kX"kػ k/URfQvV ufufYfQ =fA<%1 H uQ !apn r.V sfYZ] ^Tf;@mfRff;{fZ@mptWf!frf+= f_fZur
vw`rfSup r#v|s
,npr
<wf[uzG[{O|wzsr/{ruBAvvgwPYXxPAvr P%0tvS'r[ow v{}
lzEj{zl}Avj_QptPfSAff[fufXEmt fѕt/+f 啇#fSfѕwf3p3fѕw'ȀX2wZfYUUqt?*73ӗt`e֕pqfqkð-b@菻ľWVP fSP~WB Q Y_W%^neTst/mV! <5u G	F^q;^Vsq.
s<5% `wpUƬpXf[2PvVX^}YɓWfVf  t
P Er&< u  # @rȇ f^bYô PX@@Xs[ U  Ѹ?ѸfѸkP軴
 , $ tPp3ð) ðmtPSǼYހóu
 VI$
ǊK[ O ($'$!E) oŰQ32YQ
t
t
QQм3ð&)ӱF!tt	*tEPGQ@S&#"
ǆ*[8  <t<!t
< <*R`PZQRWs	   Z) ð  VP֎ލvS<û	 ߢV[rmX2~`^ð,BU`&ޢ`!B՘`ĎVfW u؃ trg
D?! x^ E@tU|U|V-9 pZ$H<q<qmߊ^`"Wpr% zF؋@?Z 
u ۊXBQVWPV "X_^ VWsV`2}P?ؐð2dS  m[tRNBP?RpXSmt aИ[n U܉Q2 ptʁyCa
P'Rfݸ1bUðWRñx $PMM E  `f(C)Copyright Compaquterrporation 1982-2000-All s reserved.	
/
0 "$(,jSww5F ø( Á(u0C/x+UUuӕ< 辕u~ r0C`ж}?: hQFߚ2   hv hJV iYhB= v O hB8	$@<@AfRf   %%p3f Pvg&Zf3fZX0   м  .>-  9GFQQ@ ؋r dt
t4tw ୴p`$掊FoQ2撰PRByuap5a+XXZXp! / PX`'ǻ `= srs+
3,,PSp{ _ ߸^ ZY[gQwt.}0! /0PY[- uɀ.j~.b;a/PQN0[ K 0@c'  A G y 8P8 y " ËEu t
#~r`tW  d_,a??_@ABC cccc18 p9@ @  G"`:FD-18 FG HA *P9	G%18	  p9` `  8d d L"F18  Fa a LF Fp p  Gr r"Ls sL
OrEcN H"  M
~rN +O6bS pN	TK
tX0tX Fci0,}`d$!<!uy$ $`& t"&& x<u&  Vpor^@K^D]8t( 2]']233._f>"P."   a0b2ۊ( Ȱe) ǊȊ&) "f* 븊-*g>+CfgPhf>,3gPh.- gi) rAji..jijPgR=;DK   F  0Q Q"FP3qy>18   "@ *T GOsuy d1{T é u#{F:tE
Mv;o$z@<{< $zr<7|f<3W$ a=>&]~&E &E̻ ~
b>{fa3,  SQq $Nx<t.1u
<v<s<3v 3 N^mXVSPoĊX[up !^Qu*Y<u,f ISGu%f» f f f`"2 .2Ê$uUuﴀ\ S3ێۻr?43 6w f>$SMMu>X P dPu
@ Xar 4ras\2&D
V &DH  
B r!`ruEF.w{2ж6$D%rOsJڙK Û$?rr
jrжOyϞZ @FFtN fF" pBB@F(	r2BB2ۀ~ tp]{  t3Ҹ߁K3  ;wu;sbFVFF"F
 F)Ў@r4F$
F+ F p  !VPпXVP"aWSPR!u{@ZX_à'AtZX^+p$q,氻.3 3Ҵ`&./@3Pƀnuo0nwC/pøOO2QH<n:
;IUWVRQSP36x $@ fFfsEYcP,Xu 
<t<$<  VP"<w<vr,2b? P&\@ N [[YZ^_]Mu9<u` taaEM JNrP`ƝtNð
2
t
08u?c׀>A`cA	tSc
u'q &L Hcsƿu	VuQ2^ ˋ
P|c~P~ߝP@كu B btGP&A J
_Ly2aeaN'u$<s'O
b2f 	.c u-QM`
~ q`t
т܌ad atPO u pN> uNNG t$p<pupuk:a4ߊFO 8tWGoOcONZO u33 	t<uSM[u8s":H@>50$߀> pd XϷN PNB st2 	=3u
Ku`&> 8%TlNuN3~u[N VN [QLN5SB=N83Np/n_SYSID_  1{Y _UU!fl f@f= f3p fl PSS"
߆ZQ2KM~a/`Lu.|

{P!2	ѶRLtSR@ ڊZ[`Z[T`|s uH

؊Ȁt, s0Pir!W
yZ0)LuW|=u2	fYeRذfPVeO~`
B
f6p1@MSsVVKxQf
K6rQ?{ Rot%dxd^pGKu=:Bu8|	
ً@#2| $uP$SUR!Ju<Au7߃Gt qzQ)#5 $.tʠ Z]Gp5XU!+sQ ]`K:\%+Kx,Q,Q3ɐ-Y|M -M>rQ-4Ys.`e
$-J 3Z[x F߻p75,u6ݸpٸG G5u6:L @;K 5V4 :N Ӂ=M >s6)
7
@2'S C8BBaaa$at@0 GUfFɷ͋N
~E F Nu3 I'JțInJJ ]
 HRQP~XÊ IFFYNZ3PAP%NQȴY`ۋ࿥Q aÇً t"0Ҿ & GӡU.&a'@'W濆QR0w ZCV
 } Z  X@Oa XYZð
V 
Q ~ S r = ufh   XX؋7[	R6 ^  _ %_Q@P^
pS_ 	d`ae `
gUЋ؎c]Ea^VC3<0zA0xa_`P )`jsh[himPN\$Y9SR^Z[` $<u 3 0ؾ   faq1r3r
sS !cշc} w`wVQl3jAY^` 
aËpíR0fPtf
f3fRAыf;v+RTTYX0GY@_ÜPUfWf@XиMfWY/]6/f_ff_]XÀՐ`*UB.:f{JvCuJ.V.f] $PIR   8 {3>0 9@ 9  =9H   6X ){(  	 
`zAlW8 s".0
Τ_ϊͻ 㯺쁦ѐaVWS;t0t%[ 
DHt[_^  @ Ў@PQRWfV3ҿH 0Qƣ. ЊUGY݋f^_ZYRV.  3ۍ6.^] r
R3҄  tZ~~~~l|8 8|r8|8a|ç|  << p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x~~® @ 0``0$ff$ vxx00 0 lllllPl 0|x0f 8l8vv ``0```0  @|<<f0p g0  || 0p0` x8`̣<l 8`; Ppx|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3`2f>  ``x pflxlf bf  8ll8`x|Ɓxpcʀ3x0 `̀@ͱ`x ƌ2zx``x  xx70x|``1pA]8l`vQ`lvf0 Qx  `QRځ  aAG   bvfҷ 0|004A!0ᶀԀP0d 00001qP v! uHf SvN .e2[]`'
fpx>@  t@&? ZYfXπvvT WveMAY9Y.QnSS  (B03P2X`3Ґp Āu~PNP<tD] tQ_Yppr8rr
2:6 vߡZp0gaPkXf PCI01 ISAA BS03COMPAQꊙ 12/10/04   
  t     ˸ @؎&м  : r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
g[U샿VW ƿF F   `j2 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @-<t	db>t <tjjjj3P R.wj5Jp$<t.<@t$t = ;t= D hUru 揿  7bFF~ t#^FLr
F Fa(U(~ wt:]''jf
 h\r*F)'2(~ t
)F_^Qd!
hTRs .&4/udu  ߷ hr$?ط2hmnRhVC4iR?h@
 qrf   f  f   gf&Q6..  1  Y`WVe1wE0&E.&WV .^_UU߾na<?Qc< 	`@.e1E0eE'E.U s Cm2a ﰎh
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK_Y[X MMMc1 @  @  @MpM dB FO MMxMsMURMMd* %  <!TXMC  3Y[MQVWh5:u% p uK!__)  | = <ta;P09@9_^Y!JRW`  Ê e
Crr3ɺ Ae܋
AB rN迷 _ZMSqe Y
ujzijjUz jj%1 DE<@!p;<<!p<[3u """vka#t
#m[V?fPfSfQ f3f3PXfffDDG(	Dh fYf[fX^ܠu 0gO GxQR@<3ۊED 	 wC~ҋG$B i#u fDf3ۋ?fË\py
C{  	T U S V :	N	b	v		`h	Ph	  h:	 hN	 hb	 hv	 h	 av.L.< t)F.6P3.PF.h+[+V.P.^?] TF. P.h+Xhr QR  16W  0"XѐYѐZА#[  
\qaq_RAm]fgR'^b` hijk qp10GҘpppQWĀ> t		 u		.	_c   O idJһ -wg~C.e
/e
@ mOnxo7`L3߸ E _F߸^FiQRrPS([XhaQDh
s            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_?_ p prq /Oo\p0px	@	G  
&HKOouPWBX@p_C`PpgDh`poDpwDxDDO  O 07U8?)!" #@$% &Ps'V(0' ((0(*@(*P(*`(*p(*( @@(tfSf0gfeWf[w1$2Q1	fY12PV3f1!"4fXPSQRй ~\s h^v ]ZY[Xgf& (88f t
fÝ1pP2
u
f1;0;0[T48fR1>4>Rf!H)5fPSVfWf Rg&D= $A<vwDAB D| u:tof_^@Ő8D1>D f%f
:p#F fE}8d
:Hݐ8	\
!Id
94RfUQ8}pt%)i fP  tS[rS&SfXYf]Z543t"g&T fA1Aۻ&7s@SRfP  , tSt VmQ88>R:r9Wf>(fWY t_dUEVU0ECWW6X\Y f)f\_Z tO(2>'GbG!F`FIH"b`b (8f!f*f ( UtsfIffXZT4QCR~f+t/ER+v//XfR[i (t$ 4R>|i0uQ{ `:u
ɡfu8f u:fT0s4j fX:=2n0<  M!'rjd!a#ds#	5QRVWift:33?3po茰vQtf(uBqދ3_^ZYP2QV3ҠSS pS@U :St{ffKfSP1g&!1oY$Њ?g&ǳ~effߋffqf-\ X)1R`rg&u2^D4Ckf% f
ӅS&7[ A1=v5hHR{iu<kwc3xf}qf;F QeQ`:ӄ?5 fd 7dcy4k4frR@;ּ "i 4R1@f
. '!ff
/*FR#s_R %(R CsdGqfrfA13f;EU8YGj;5fS< =࡟f`8fQqpt@AXf3f+F| tf͐89Ltf^Fۀǲqf1{p3+4kЗtfRk8Syitrjtf64Qȟt3k`A杀=PQA0 fF Bf6H?f9Du_>❦Hqj ttqj@ 
>0X`GG2_f$R@R@0_PK@S4k]9 fQk0Ey[4$fGR S"i
fAutu@R/fYڸ@cR@ cEP1__2 G09ϵUf,RL Rk= ̓"p|عtpn?2A4f_'ǾfihhS7gB	&t&"ju	t?rŘVN(tKO tF< Rg&ƅDA 0R迧g&	uSSR15SS2W42o SXi qj R-d&7b4WE/dE 2`eVrE@@Q>% @eѴ!XpaWQ\2/IB _഑]\hpwqj ( PaRspؠXfrqfF6wf(I5h[j(wH`gR:#Pȭs4<= V 3  i8 9 O; <tL0R'1Uǰqf0f <rsf0!o@
rZ
| N5Sb-S$756V"R R~ 0\^ 6fRfW<vUp0fPB`g0P剿m1fu1fGfq1gf]X [tgp{Tq1p@8UKLf3f;0t;
`0 \ gf8EL> ~fù10R0a{0`
gf)CFkF{R$ Ik Is{4$:kg`ffAL#%/&D'`'ÓiO(o)*%'N#P]7:FGeq<=bKQ
2#!KO3r4aKC x@V{Ơ
;
 ^@jf@;70uR:f. XÐ  ,P=  ]
  N>1=2=2=)Z>1?
}?
 e= &R>>   .ATВ?,T>#>C1?rA `m B+CrFoAGF_D}Eݔ@=0N  Є - } %GC=C.a> >NNOQJ!GqE= R> >zIRS 0uOS(TTC>CnUF0*G-J%K4CXRʱI0J/J3@ ![NS [_BP,L>E
 2Q%VUpq_1_1`U&`!aabRA`SR#ThBFT4#ULbS1fT1Wg$gtheluVjWWDHX6X'jbqV1m/Tn)n!ToloYUZPF[6['\bFE1t.4uJu>v`\t]>1@:s^+)v+I+z1r>![{EG|@=&u
В& JR2TDrBR"Q%!#`Pt@q^roP>,UXBF&`O$`PhB "=8X.\lRuAT<r0*f`ATaW
 J'@l (#0U
/ 4!`e	@a[@9
 P>W	P>  _ 8J8[) C@b#{yA|x#TE*I
 O:$=%C "A	BZ"bX=
tàTSAgq?&=xi	`C@=`P
  $` # 
 `"@l	  2UQ L-qFP>=	 h  Cq)R)Al""`P:T:aBQ* !bi(!(t$!t1!Sli'!'t# &!&t"bܺ,/`@Ua!hF鲼4óqo''4QѶ!hɻa?&xE$$414Ĩ9Oʴ O(!rd.Ƨ'I'$ QQ/"Ղ!#la$Q Ѷ1Ql(_(t"`P\DკdC߈Qv_'&_ea_	$_$ta{QQOBS(dS!aS'dу!MSU!qd$SQ !a֏Z(4qdt@ha#|X'4P 	ڋQ_$4d0A!   S2RSQWm hǝv @. _Y[/
thj
Á 0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGH?IRS ݫ?_*8۝6T FR@= t 	C!
3`"""	ġS`"R#2#%*%%%3DӀ2@ _ "@ ! .> +`+
`O-o.l/RRo/124?5_67R9   S-Q[PS&S u!(<ru
>S0诉 <<> XPS=tSSS>SSu~?R}[!>< tC@a>r> AB<??`@@RSRS.Y#><;`E;<@3؀`R&SGRS@3G S>VSR@t	Y0R[^fPQVRRg&g \RTRCL uu1KeSAKPRAKXR0R|S[^Yf!>VfU>RSS>S>S5&JSt(
ߠRL R0HR[@TTf]^@Vt>SS r18RZw%0[Zr@R&RsWQX90@]AZSR ?B> [J9bKKhSU
ALLL`M<`MDeMN?KO^2P`P.`8R"|[S9rS&SRSSRCSfSQRVgf&RBkR 0R7PdAΑ#*mal	uSS   = R Y1Rg&L@v@ LGaNsp
pRtqS>R rT3f3۰ rwUu>wV#nwW#u"Vuvutxue!Vu^\wuMwSyu: 8xPu)wtwtw;!= IL^ZYf@g&8Qu	g&gP6t@sPVSl0(RB[^^RVsRW-^a»0LawZ:RdRlRtR|RRRrS.uty0pRAZyCZkW>`TRSRN<v
hS,ƯSiRʀ 7RGr0 rP)lsڠLёLE瓋0@GuFRRR:Rw`R߻
 h^a t7
߅dvax稖 )1Pmrg& txRrsRr0PhRr
 JtbintؓREL@Q92v> u@LPzI$W	XWZN,YPYR_|@fPfUS3f0 	wYf]`Sf @Sf3fY[fR  f0 Sfлf3`@N01汰f@`SF E *  <FuS3t	Dt<Hut2o[tj[q $u tP(X$?S QA>S uB<Ft<Tt<et<t<t<Rw*<Ir&S
2 Vtv[>PVy[@/Ooeu1SVW p;tAQ ұAft(PǴ:?Suм` gXfC?Yf`j!9~ 2Skur˷ ;t&S8r >pta>w`$_^RS\S2 Rf?t<C0A<tSQG@ذ0Y[ـ u
lQ?9ܱ ffwgg5hhCopyright (c) 2001 Intel Corporationf]۹ ;
uhQw2 ]f2f| t;f` fְt*⩑tt f(@
  0L+V% f])Eu"osf] fȸ &f %☃f?]f f`CgfWf;ugF]PffgfNff F]ff]M=fwfg_`?gWfgGpSMtlS[p(tY	 uIf@gV8~ N^f!f`_0!	 uV0Af[SfWfVBf&ff}ް3l_ffGf;qM<uq	Gf=_PR_u	f=CPU0u 
> 
0
u
q	f=NPSSufOff
o ]L/8f!!=`	f}vf;sWfF
rffذP Rf$@gc&p1 1p	f6A F0lG	R!`)f"Pla"
!Gq$"A# !fItgO
$Qd!S?Q~j@/Il_u4Qr!4fE 42!
ut"dV#ub#$n$mf 
`./+؋ë0p=of+4N 2`F	hǛRR@Af^f_f;]wej Q7
uAza8t 3gFg^%??0v0 J 	w p]RRQupteP]Jh8N $Z1LS0Luof3`
ft5?f6]u  ZBJd0 f_&]Ku h3<u	!%N$<@e<0u$u02H`<t<t'<t<<t$<t,[f@SPB>=PPO1~) f=ISGu	flsg]]  AaAt鐿 f6]	>_f	l5	;pajz !_fPe?t6IJ`:(UH*zR[[ &Pfg q[  &Q& >}J#f2RB	u 28f%UWfkۊfwVpd~4>gjO*1s6&0e 
4pbk`uj'P_Yf@Pr_j 7< (xrU$s9v<'P1Yfxjk ǋK227u"asP1e @kk0	!_pb>˂gfd"7F5붉 ԕkߡfD[0ȌuB(RPNOSiTNtЭG 2YtG2 ? h3
'`  A
2u1ݰpPzqP dd/1XB
Ԝ000Uop@0ݯ䝕P0`_!_pp_QT_LLLLL0j0j0jJPI@ fWQf1Q;D=2ݑdYf_@Yîq	D=f.tPD=.ti.D$.>t.%
.Dtjr
% .>tt`QOb×KjSs#j$iٿtrQѸd0r>%;|= USBSuA|=w ttF A`t~DuRtlc ar4?rQ?&`|ur
``i |tt @pr*ItDQf@.'FQ Yz=P cϻfQfω5?fC2AcjfPHBSD'fXƳ^ ʙg0C `sjϵs
ەkWGqCCBg&D=o aWOd̡p:0
0z7doZRD(Z 0(Vy/s7D|A=%yodD$C$y`Ù.o:d@RP2  h >nWu 0101T=
XL(f4T=&ȃv.tZ@u&tN t}fPQ̀ f.>t l{+πlfQ^Vup6t +.o?f.6o8>Ud@YfXIlrt fay<sB *?QfPfQ0gfዠQ<Z
fXYxrͬ>nosGj/sR~``o?"^dRS) Al=^SGpbtbWtn,Wtz,tWttD`ƈD 7Pd@r
kr&`йK ;%t-бt=бT= t:tt h^A3(uVQsrLR@bW=@tW=ttW=`	tnW=P.bWg6,faPSVt8dtd.&j.	jt8DtD$?S??j^[XS.@8t.?.j@CCj[c P`EE	EЀG }}ttOI   ! !hI}DL` ၄'w;w}}oq+rr%wcwqNUWRQSPV rwj Pur(ffWR`h1\fZf_ utSaPSUpuwUtUttt/`WWX`XtկWX`Xt"c[XF f s`"Ut U ^X[YZ_]c ÈtƐ A`pR `R h fd}u
!t!ddfd԰c?dcrd6adzedvdfAdddr(bt!tRfU3f]wa5,>`u%ttt t	tfN !tF Qrku\np8zp%s
ڀ\1n#,6WuFq[r 5s|,JtSfQVsΒtvtW;ـ?fPfD`ѱ׷f{Ts|fffXs\onyuptLuY{f3ff.tWfW}.*&t8fw*fF*2t*܊.&tfX^fY[q!SS^A`_A``t б[R`bĀuNG`vt~ 4\}ߐ6SQVWU&S qS %]_^Y[LS-120ZIP 25?0PSQRVVWX `A`HЈ'ށut@s
hU6rgбR9<tV< uWQyfqJ *:uFfG('Қ-XX ? U^ZY@Bf`Su tStttt`t /RWj1!<sV} tE迅'5<_Z[M-Sys   DiskOnKey@ӟ9S u @  f<x fP `/'z'"Қ 2r0w|=1s s6`5 !~D9 9f@fPuL{st6`5@]r)g&ug&qJg&3' z< rLT!fS<F=BUP!e}$)5<pp th;=t@  u u 3{Af?cf{a
fXu׫?ğ @*⠣B߆ 	 + PRi3W>#>;!>
?_FOh`Ղ=; 4  h#OLS ,ZPBu+s!$?
u$˄[ðDj  KKD\I@0 K=1M @pE roނ)a]!r!.d ?i@!sP KtF tG p1r'1r'!߿r
@P@ I@ Q fWQf/(K0Yf_!f3D5 at6ttsU]att!!\D$&`t
Dt's f~g&|5 @r`{r  a`<~^8^lv!_Q;L~ E_`~fPHf%Kfa]ffDfX\_t
܉_pXsP _/B~ʐ!)+ *+@4>)r`$,s@,-/a]/0 Xb`A2W3
#c)rC]D=1W_ R+Dy0J6ہ($ |%r]򜁐nWu.rEQfP0a].߁f.6ہp0gff0f0f.#fXY[rb`uz
*_ p!!#D/$XYr`%Pq%&p2r FJ(//)s`6 ;s6etd h^ej:u`7(uIa`r?bW=@tW=ttW=`	tnW=&`bW's%faм.&l.	l$0@s@p@pClADlBpCpgI0 PE0!rIPTG   K@K!}  00 3pF0KDVL!LeMKPEPGD0PEIDIKcPaHMrW I3PINVMUAT <@SaCV@TPTUV VHBWApVTVYTpV@IaL$VNZC\RSSRRi^vSLYgQc`fS6VEAT? T`\]Z TZTf #TWQVVcefEYWaIiCg?ZiefXMl5nkqJpJ(e7nVPF3Vh!lÐTlhhhjZ JEfosdWOeM(%lsWhx3t{HzR\%lzEYS WgLU1SEbTXcU|QDQAKOW ]]nEhgTgQY c]'iZJ[bQV] UXfEcM< X!XdTWgogō "Gr{ePqTZTphaF<RLwzpF<G"SzE3 VNHvFE!f]fCxxHAXc JI`Q%Yr<f.;Wt4Uuf.Way#$Pf wfb3Pgf= v	 +v> f3Ff́  "F"JN6RÃ tQ@$rҬ2 ǋ;Ъt.V}s .VfRfWu vf_fZfrfϋf eQfffROMIfMAGE ;uaWt@.g f3TPQгJ 2`8fG0ZYXu;7G`0eG@ Y º2hǂt"t t	V  `SQhrtuY[ǿ
Y[W   󿲽u'fo t!q#w׹ @ $~aG9Gq#Gfff=oӸ  3۰vr#;#OΈϳ7?@1zȎ#𵱵lP8`P x˃>t aB @1  hݝC$׊h=B>8 G׃Efa1/#؀@n|=|QPQfWfV޲UU`ժ*U1hh#7f  ʊ'`8G1 .;t3f^f_YXhBc? PVhTS?;5`h\S?  U^X?QRZYB.S`36 faa30f\0fy0>0f`2`s2f;Tu0fǂNNO.ߢde{fgP.& pO0g{< u؊OBPtXruU`SQr/ȰS $8tċY[?r$u簄n㰆g`rLS_r{0G@S9%S8r_ ˱	J. 12	0 fPSfQfW
s2fU)y suf3Ɋf@gf4_fY[fQP@`g<t,`fU7" r8tfGwq$@%@8t``
P2DUvPF X P..ӎXP..XÑ"$/%O&o' ()*+-/.O/o0 12346/7O8o9 :;<=?/@OAoB CDEFH/IOJoK LMNOQ/ROSoT UVWXZ/[O\o] ^_`ac/dOeof ghijl/mOnoo pqrsu/vOwox yz{|~/Oo τ/Oo ύ/Oo ϖ/Oo ϟ/Oo Ϩ/Oo ϱ/Oo Ϻ/Oo /Oo ʯ/Oo ӯ/Oo ܯ/Oo /Oo /Oo /Oo  /Oo 	
/Oo /Oo  /!O"o# $%&')/*O+o, -./02/3O4o5 6789;/<O=o> ?@ABD/EOFoG HIJKM/NOOoP QRSTV/WOXoY Z[\]_/`Oaob cdefh/iOjok lmnoq/rOsot uvwxz/{O|o} ~π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Oo Ư/Oo ϯ/Oo د/Oo /Oo /Oo /Oo?_ 
?_ 
?_ ?_  !"#%?&_' ()*+,.?/_0 123457?8_9 :;<=>@?A_B CDEFGI?J_K LMNOPR?S_T UVWXY[?\_] ^_`abd?e_f ghijkm?n_o pqrstv?w_x yz{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ʟ˿?_ ӟԿ?_ ܟݿ?_ ?_ ?_ ?_  ?_ 	

?_ ?_ !?"_# $%&'(*?+_, -./013?4_5 6789:<?=_> ?@ABCE?F_G HIJKLN?O_P QRSTUW?X_Y Z[\]^`?a_b cdefgi?j_k lmnopr?s_t uvwxy{?|_} ~߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ Ɵǿ?_ ϟп?_ ؟ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_C DEFGHJ?K_L MNOPQS?T_U VWXYZ\?]_^ _`abce?f_g hijkln?o_p qrstuw?x_y z{|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ ԟտ?_ ݟ޿?_ ?_ ?_ ?_  ?_	 

?_ ?_  "?#_$ %&'()+?,_- ./0124?5_6 789:;=?>_? @ABCDF?G_H IJKLMO?P_Q RSTUVX?Y_Z [\]^_a?b_c defghj?k_l mnopqs?t_u vwxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ǟȿ?_ Пѿ?_ ٟڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_  !"#$%'?(_) *+,-.0?1_2 345679?:_; <=>?@B?C_D EFGHIK?L_M NOPQRT?U_V WXYZ[]?^__ `abcdf?g_h ijklmo?p_q rstuvx?y_z {|}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ ßĿ?_ ̟Ϳ?_ ՟ֿ?_ ޟ߿?_ ?_ ?_ "$&    @ A@ D  E  F G  L N O  P  T  U  V  W  X  \  ]  ^  _    B C H I J K M Q? R S a%(4'ZE'I1y֦/0.R'H(.̈́G/ֱd;Eh:sImm/b0X` t&ǤaPRu-诤Ô.>Q@t	 
桢ZXPSQWt %?V;_Y[XfP8 9:  H?t9fPR@  ;;  L hǝv h= @ h
#f hL$x ߁p!ffX!fff&$ , fQZ fYt2߯@'PyyQ`- nP` 
a."b/f`&!   33 / s#/   f  $f2"
Dۻ   : f!w .p"m7a012y34Ga6 t7A88!Qft<  t7ȁ  u3$Au <!uC'fY`s6d  {?96  P78"FB9? 9aÑ!?3fH9t 3Ga2JJfK K$KDd  SQfW;f_#g&&Qɠ'Y'f2Eua hg' tP-I tG,'"r< t:  @R\9U T9H fF {<8Kf% `HUQ&MRPSmSŏ TWrQPSOSTÀSQVW33 &?&`6:_^Y[Ü` غpF nBnnnt^nJFn awS@[b c3ێ7!C &?!Cu3ۏf&>CPQCu
>W^W _2ffEgR .'ZS$'f_< S .[a]@ ]= 󥝁_> uAðqHqo`&o&O&7lߴ9PQRpf&f=fDtZYXð@GAGBGlsrAtކtS2Pq&W qgw&u&87u&8Wu	&*gu?A m]  YPy2r(ں 2y tya'sPy
y#~#yu
 ;W`f0ftCu5t	 r _pqtQr|r2ؼ}dsQ{YPm XSQ` I аOFLF;vh'J &t uK ڒ_݂	zcX贂肂Cy貴h&yρ>89&:耴A߰hm'.3Ɏ٣gi
GEP.u	`upxPQfVfW hqj @gf& f_f^YXQWV
 ^_YUww+t1QWPPXhX@.X=X@uX_:YPaP!`.$>`u
PpD@XuSWh0Q, s h
''>&M&E&M~_[`>1$PnPt3t"3&M݉`1E<taðTCApnO;yOnƿOHP᳣4yOOokbescA
nO_<RwS2.D[wCø ݊ ݊аCCȧjfY_#jf3ɋ&G Qŀ A  yf&Pt`ffBf;g&GfwwURtNtGFf0h@']QgfY~gh þ7APQf^k!faUfߎ&fgfdtTOIׅ CwNFOR J 3fSgdfCf[ u|ܿ<aՁ{    "f@t6f!f! f3DgE 
tfEF!t{ f!	C< u֋C@0o rPmgdCѯZ߅L߆>߃0߂N"ݲ߁g?dK& ҿf]D[r`RPӡh'h[_ 1,0rX.{ ]UVf]fd} ،-MϤ`E  .#Ah[fZ!0 /Buj@؇hNr0fRhaZr/OoցSP`>QS0.'!h'rh1'2f[Mǥޥ¤t5LG>ypyO yO+jKLALyOM N>?L;fm yOXfq.|XyO"yO.yO2	yO7yOiOE8iO;	!J";u܅š?IyOJyzf.谑CN!u<u<vwֽ=f&2m]˥..RѢnQRS@kذs =r=i8SOd0p&;xV4t0f?"u@t_[ff[000c```;1] 't 'u6"Pnal fVffs
"2)>.h$7ff(-_,C*/R*f(-0Ǣ)*s
1)d*O,Ð)-*O=<`?6-2h&AF srpGd6?q3§hِ78pW(*-Pf៧t#9_fY`R_#*Zk`MM!OOOíQ1R;N72"àЁ6!fsg]s  r
Tu<w'>, oE"Z$<w	bY0Ff 
S>+ t2 Pu u&Ѕ<ttr	!o [QPSI*tUq"gtFg&G su0b <u$
#d_ b!q"O   2`Y`P1a<*tg"rb``1a*t9otNbu#daX	
`Y8t"8؀r`lm1Tt,&
u>ut
$OsE ?t> PqQ_u.Pq#5tt$r	&
sP\ P
t_]@S_	>P]2
X{7Y"t>*V3]+!p?tC@x z`_ ]< t\$  sq ru@rp`?m>{`m؀
	 >tpY4t+ ]u][ $^ Xt׀>%Yuu
TwjAy A; "^_#t{&Ð]oViQtù {Y`'t_atP rB3e۾bAcscu%
'uђ""df'%gztzVu *Њطc~tbP; sW;"sQءзu	*u0u"A
u"
2贿  t 꾐]| *Q~Prt^XfWyt
&t0h_8fPQ |{Л
P@ ؠupXI`ῦσ RfXѩZlfacШ_qnêp0`0(0"&#Ef pf  Dpf  &Et "D@E$Do( Es `ٳ&&tȀ >2@"
&t
 HL &}u?P?u8&=O r1&v&
I$  ``  Pm m 
 m0Qŵabƹ's`a`] q2`* ȃOA°Ӱ aP $$<@thhBKuKfN:ͨHKu3`.>Q@sKt&3 `NRr2gg xx~goca`rr X ? :tr/kҽ=X񺡦$pa`fRQSޖ[YfZOt'''(
| t{a[EXe
Em>uR &\V:W.19@tL/@*a3Sq[WF[C vS3#]t$Ft:$FtCt<w>t8xk \̢rYax
 0)))Q~a Ew趻t3Y,notFVHF.RFMFx d|t rY;2,\<>-fP ﰸq[aFr Y
	 fX, t
Yút/3]$Q~t1 -a2`[Fd.frRa7t00P^ߔ!`
!: x8! q[kFȀ>ur׺tq[uF\aÉ C@
HZ.

 L.IB.
J5. &.؃y0
. 
.2}	@'
s3y@s~PYPuFPl{!|!~!íX:{!u;nu;PtP!P^J@y9!p 81CGQ2{xKA"P^:!r:ȈG&<Qa0(uԠp~5-	&,""""e'ww
2q[B"r ! }
À
vw 9'>P]  f(2T'2'(M piSRb2,!m?tqVtrts .  ohZ\4Š  Ep1}ba1xhA\4+  ` ؠSSh	u/Ka4o56@4)7649DZfSW0 Wh
_QW1=fQRf0q@0Zf=YgQ4Ks@ A0I tS/ h42@C CDffSIh)3/ffyHI#fY=PPHWQB=fgfe	f   _fY[Pi`t"ot"_/ O Ptm.0Yp1o1KRa2aãOQBBOM+MM  t%jOM`N >cVXpQSUnQt0LMmXK\SZA0hgЃ0蛗BB3Jf+HaJ8IJof
Oc 0 #|A`v_Gk !"#$%&'kln?o_pq`a&&& 3 &$ar&&	r%sGRVW@ l 8  2 >GA lBl_^ќ`6y$?Cw! Gz@ {A { {B  a$0sF%~Q!Qn o ~FBY 2w&'rxP{~` y4&'x nBnnnFJnn }2w''rx &oPP&cǿ'p(lF"'Т#'yAw2
m  n􌾠߾'nG&   nnB߿&ďB"'#' &t''&|  @! 2A''	 n'  n$'Pt%1yR%> tVE%"$
C%&P :`1`(%
%$ȡ
 %p%$%
 Z0(
޽'h,%(,?9-4'֤L,w(j@ -&-`F8ܸ8%G	i-ȗs-&94'@"GFե՗@?+ܗPXtw**3*w*}h4fPߚ 5*rPLR_   
`3p3 @f ӫ..G+K+     }    z   0c @Yry Qrqh{@&.J Qff PNQfRܾ@r<fPx @ܿr( prr r }`C aٱī ,, sCsQ&s-j^M3.;'tP _xۜtrA!
䡢u!pơs"2aÜRllJ쪊$JlJlBBJ˃ZRW(O/6=p_ZR ϰZ6KߛQVWw  _^YƆ+t	3sҒ魓aø*`PRZXsq!qĀظ#hD_S D `H3fa f   @B@ptfP.fXHw fafYf%p>L Qt{?M @~Y$p>QWVN fQy t J 0 t%fP h\_ 
۾  eQPw+@Y$@?^_ z Q tl3Y$[~ ֺ  fQLRfWɰ S ދPBhBf-迍   u bM&f_`A!=`lu

!,F]@ "`{3aP߰q
}0LRt1+HQ!f-fH@ݠdgfKHQS 
f pfK-[g< l1qGW@f2RVh;_t0h_h[/whPr4 ff5 ^fZf`  _6G  u
tuՀ 254
 <@V@z
N-	rha-		faHf`bXRf7VfW H3
	< t~ fX
#"" h{Ӽ_a/f`7 ]##-ᵎ$%!,&?_aVS  6oD2[^Z/`00Q`0:D~ +Y22t330d6c2(76Da4PSVk˒rd $r]rPP 4X@<XP<s*mXMѓ+[<u ~R:<>%jr蹓r#M <ʓ<?^N4r@<kz/aDBk>:ð444`sz4r &
aHaڑr(
 ;,rz;u0D豑r  rpK1`L5(5K55VFr .4^ i VWQ>u]K Y_^SQ3`.:it
$ Q.^.jR$SrIH à> u( Jtr (Xu!> ?tQrsR[ ݋@[Xuc݇!YXuuQ L @[QY@[qa8@[9b:b7 > t$ZlMNrI!Y@[ IdLu$C$?< uae?R? @W<u
)7u]];w_iU7kvjxjkOaib@ccLtdqIˋX j@RL
a` W 2]` fi  ylpu {ksuzl 	|v2r}ʠrðC:}{> B2	h[ sem" 0 4. 8 t~2ɡ.>uĊ,辊q 觢t=> uD8 *>`uxbpke!r|B_ WYtK5`YD8FEtOB-1p`Yfswp d ǟP&&X? >&PcphduiQwCÉώX`h3 /<t+xt&*u
$&.qt"!tq tug&׈G !X(u)@ƞNuU>N :&t@CpfRWV8'!O"reS
6W p 2:> u6 Ht4o h{ 3Ҭ؋h B/^_ff!z,}S
>^Ҧ2 cת>$2`ਿ+,6-"or.x~H
.Is.pHPX>6 cYu:O `/@[QYXYӆ(ZxlgE[u\ksp[uQ]uoqY^0uk "s rY~!cuA:tI_=
u4nSpdk>1e6(irY`ffZLNrsnr1ehc= u p=`Y>=_be/Y ϣUcYh_e2W0W=X=e auԂhF?jӀhǝr[h
=`كf33ɭFff
~fffu_0)2 bSQRt$BfZpߔtߓݫAQVW .3J G ݠ _^YArV&'A<PSQWh
hrr6hgC,tQW _YuP t
tu_YCG	 `kӜ  `ĳP lmXG
CPSrmX3
 BCS:u%`״ [2P |X`k  1 :.P2
ˀթ$
؁ԩÀu`8;X[X ?fĐ򢩊؀ ްb 
ف򇩀2} ]!P(<KrK;X
 ._pPa ff@3f   f0fgf2m'_ f@aPh f&>Txft@a	P f%!g %PfWf@aG0X<t<t<	.iPS$<w
.-AB@
1Q@ASfwhBCf af[ @[A0 &AA

`+PcF@ 
8s * dz `V$<
v
ط  迧 tǀ>A  誧$
زhc$
-d t㋷rL~ n
^!whx=s&

@[-d0N
 =0O@u A&Aq%# AA< t>A u
8wàr"f.@1лPhBfC0VpfJCC+C S|`Y cr> Â/?|S~-CIUu`.hIC.E - v 333~3 +4f3W53Y73S+4~~PR.CZva<.Cy<a<BZ=c>0>""
ZP$D$wD0>J!B~f?JúqCCH?DqC= >C>ȱ>P<PBFXس=0@?SR4o`ZAQSW(_[JL  "# `ap0@N;~+3p<uqIQ+3GP
QGQrQ`PQ߰#PBDEoDE簻PayTE#V}3UDBVPST"TUD$8Z%YbTDO[~M^^AA^qF` 	
 aH I;ac;hN|HJAoNHJAoemO5fFFFFFNmO݀JAg7Jhg7fFj܀0.&5,  5d ~W	  X f033蹿\ o3~@p_fY0nn| o f.FoiArFpfnOq.prZo9r0sKpEni ߀@,vx	GGGGoHuH!HG  zd{H  'Hh${' EUUEv}Ut~}p}]TQTLD\PUUaU UUT ā~    T T AZ=UL`PQ}RU Q&tH迗uP
h}4ru /Zzr*1&>,0,b
T{HvPB@u p
 q Ȱ{H 307eΑyP yPI{`}Is2.7I/r¼Ò!Paf&] 5u>uhx}`<h3e<|rthd<hi=u"ty ^4As`u%-ҲR!3rAr& lQ@u
[AsgxfuxЎ@P&34o[xXЎJ2}!mpJJ2{p_ 2O{UV<22 Pظ Ş$p Ğ[.p!!>L"^]"2 	?U F}`Fpph
'r3@ϊ`&&q&qĸ RFFF Ëw
u2 tЎ7Qҥ`8&9ע:Ҁ
ѹ?_r)ÂL &,4? .LuP pBP̀NOXé  |뻈 Oxn^Q{ZQ!pXx Mv4Sk rMTrr<MwP NnrR	rGu#0dδ0d߳h7s2$>
 >焚q *}Y"5@ vy$`. Wmo s	nm`vP5NF X P."N. N.Nȱ*XP."N. N.NXnN!&nNnN$S8rdd)rS<drp)
do2EPt
w ptо mѐh3.h3h4dSpeO S^LS?pЎ3k/ Oo / Oo	
/
 Oo/ Oo/ O o!"#$%'/( O)o*+,-.0/1 O2o345679/: O;o<=>?@B/C ODoEFGHIK/L OMoNOPQRT/U OVoWXYZ[]/^ O_o`abcdf/g Ohoijklmo/p Oqorstuvx/y Ozo{|}~/ Ooχ/ Ooϐ/ Ooϙ/ OoϢ/ Ooϫ/ Ooϴ/ OoϽ/ OoÏį/ Oȍͯ/ OoՏ֯/ Ooޏ߯/ Oo/ Oo/ Oo/  Oo/	 O
o
/ Oo/ Oo !#/$ O%o&'()*,/- O.o/01235/6 O7o89:;<>/? O@oABCDEG/H OIoJKLMNP/Q ORoSTUVWY/Z O[o\]^_`b/c Odoefghik/l Omonopqrt/u Ovowxyz{}/~ Ooσ/ Ooό/ Ooϕ/ OoϞ/ Ooϧ/ Ooϰ/ OoϹ/ Oo/ Ooȏɯ/ Ooяү/ Ooڏۯ/ Oo/ Oo/ Oo/ Oo / Oo	

/ Oo/ Oo/  O!o"#$%&(/) O*o+,-./1/2 O3o45678:/; O<o=>?@AC/D OEoFGHIJL/M ONoOPQRSU/V OWoXYZ[\^/_ O`oabcdeg/h Oiojklmnp/q Orostuvwy/z O{o|}~/ Ooψ/ Ooϑ/ OoϚ/ Ooϣ/ OoϬ/ Ooϵ/ OoϾ/ Ooďů/ Oo͏ί/ Oo֏ׯ/ Ooߏ/ Oo/ Oo/Oo!$SMM MODULE -- COMPAQVERSION: 1.0 tUɀ> u>S@uuu&g !U _s"(b%p&[ðD$ htv r
8 	t .G
yB&<v A
0& ? 8,֤%gӫ1%܄Ddޣ-%$8Imm  	2qq<  2PPKdP; 7@7d_ VQ6oDY^PVq!;to^Xf`fff  w$`
$@W  蘻_N p<t@ B쪰 fafPSRV`=fprN؀t!@ Q# Bߪt 9h[	%A"f^Z[fXl=k=  =rP:4 >7 uC@̨ t$<w:9h%	R>t".t}.t`. u %
ZSfQRW.&c//E0d 0P%_ZfY[@, t
..>u
bWtT觚P2W6_`5XP80; ;`9#;?;ø  PRBZp9;B`<濒3he	u$>` um    :   %?t0 	0	A
  3A ti  `CV !.  f@u.2Wh'S&XaFFt
*H2hC&B5J5K%;8 X 辸P802  hꝾ	%Nh`JS9N
 OQ9p;`<fP3f&T ffX`;QRp쨀thU	t
쨿uZY  ؎ff uVQMp uf3ɺ f$[w]%&\hD	&)_  ff._B$B$
и @_'ghijkm ?n_opqrstv ?w_xyz{|} ?_߅?_ 0ؾ qX>xk   Ȏ؍6
1 BsX6xa``dXU`~
 fQd\Ifh>s.f`PXN8 %w 0N h#Oh=sP UA ߕ Dt% r v@eP`!!02Ac [f`d`fwPaP|J¡i@Ԣ7` AH ;I 5M/Y ) #a@+q9!2 NH fC%B5 a$q]$
aq]]CPBcq]rB;ra`ND cf   tЩ03KN@ 9MNw];;! w23۔6%u~[#
 1\0;B)%&P8,U-*h >- uz&O8À$L1z;t`9S萱0襱N 薱A
 4BMaPv2A  zgAnSܯbc +i`<f` _ ,!h5s.  @DLTX\htx @  $(,048<@DHLP`dhlptx|oˠ(/Oo8 ,f >pψ *tԗO40 ,D@ @PHX @ ,< ,< ,<` 0<@H@A<HTX 
 H 
<I݀?  ,@ Oo/ Oo/ Oo/ Oo / Oo	
/
 Oo/ Oo/ O o!"#$%'/(O)  <;(<T?, -)ۏ-1234 P4xz4PXYhijklmno07	

  4_>?@ABCE ?F_GHIJKLN-O" # $ ` apb crp0}	PN0P}b Rpr RPh0**(8ðpBrUBhhSZt @߻0 FW@A燎` eը.>Q@u .̒  @\SQWVl[[/@\^_Y[Ip]w\_pfPfRVW f Zaa!bb!b!a!ȁbf%f3f3f.2fffu_^ffC`_f"ahahfWid擿՜d
Pihf0faf}1=f  tfYm of!o0lȯmnR!OoP3XPSVWfQs: `sV t
؀u ufufpv @uf  fY_^[Xq_4rrun ps`&'"l'RP.XZW'g'Ų^U~.bnX ''|WVSQqsHU&  &8zź'tY[^_P}`RW* t.f`w栢2gcw'Br@甋f# ECTD cH蔯#ugŋL"uPCP甊 @f%u%ŋ$ 
t$u e @t	  tzᕿdpᕽߵfᕆ\CRH~ zH@#_sƋ`nf} Cfᑳ.f?f|IПOapr@A_LH]L"ԛMHMMÑp* iNHNVEHP, xtϒ㓰B e @<Zuu   ?xr芥 /<  @ް hef携 r!O3hbar  &PR?wtz/t ś;u:z&w. rśIfZRppfwzfXágՉ %%<tCwѰa/ត2 fY tADaɘjP 2_Xà< tWˀt\H\j`H`ϛί
pvYܰ &ـЯffà_ (cHUcdHd/bæ i%aOOià|(THTXX
 /؉bs?S>Y%opRhs7 u
P!tt	t
ZPRfP ЌKf!8RQ@ .{D f}L .N ߿P AذS. 0f}.pǛ|śP0豛fQSWQB /覛 Yf  oMxQzf  _[fYpQ@  @m23ɱ#L  $S $TQ2C7%;@_QWQX 
$? 
rɧ	c&"B0Z՚'A_pWW'+Ӛ_f+ # J<r߀A_PR  "Q 蒚2#Y~q+PpV  D   ; Z x     0Nm2=P
覫@w	<Pw2 蜫fWfV`66}2x6qff_؋6f6f;f^f_!S aWf3ہ> w;`6/6t[>N 2G%GGfpk3ؿlf _fZ gP]@a6謊Ȭ33@9Ԫ V	ͪ*//h`?RmZ`:U 2~0W:@`?7 2F2#G+= v @p_^ZP_$
W`6F#>>@97몪61M+~M%_t_ OO +Nt$t~RPuQO#ROrwt>*̩$,AT+ATEAT>pPtP:pOs~pTqÊ&Tr蒩WUrqX Ur~úToT;W!XfYGWZyݙ@rOYF@uW-0X<ðD+$&u `jo(ΐ`؀w5S}VtSP[^t^X0bP^iXm+[xÃ&=U&DpTPV`fAZu&d dtKs	2s?q O<`QÀ>tٸ B$e@wiPS	ɑOQki^}^xeD4 ðd.aQ^秊
^^⧠6^wB_&Nu	Nt2-X^tC`i øO BRT1l
xRPPP1lA#Z7ð3]r@UV t
  !|zD&@pr}	 wc}HȃI`vJ2ȉ  wuqPg
@u]AuQ0uIPӅ8@t}tXr= tS tD3:t
u
> u'㉇| @q@pV
ARw [Ъq@$tb}	f`n|Af  w	F%aK&{Ҕ3^ÊWÈuo_%0o%nGnAO h.$t
h. @/2h.h>ʔQrwdHw<h.*h[h+AN-fZrha-Sf>QPH_u(lr#  f&?fݖ0Q[+-+Wr(fa@@Ar.Vh f6tYв@4 uNf3+t ;+wTf6-ҲcQ r?fJgbgB;grf
f1q7 sЋfP<Wf> Jff?gf? tHǀ tfм f? /ѼSf׽r!fAQfJ$fftgf&
tg&fY뤬ٲ3<Ư ±#!3Ȓˊ02<w.|
BuFx <?t@$<5-$@{ҏ1Rq=@QOOPS	?&̱s< ! 1Q / tW wptutj$
 s tQS=t~  s`E]b<nB %t"; !

	vѣ c}0udЉ>ܐ;>t,u-  qg;$f;OPS1P/P aPջ  >@uT>u%  SV"uqtfs菠&1跆&>Pl"	!X#
@uHZ
u!* 
Y:?tB ߲
wPS55oDo%:s$:`ؒ&!$D9$s9aX[Nt9{ Q=r$^wS`bqq򍐋Wusv Њ@5>t'uuӏq/95.90Wu
K
[Z7tt$p
퀟2Ӵ	zwUmu
F!^u
 yY  ױO=< 3`ؒ1!{
0
c};rqѢ}
y 7SS=RSrQ<u}dC{qs$dQ \&&!5$D8P#ނ"ÜDŜDo5+ρ!0(@u@ [ 6^$b^[ u) ,) b&04ޣ3[À! =  pu 
OOǳރ>3t+&a&_M.
_6 r)`5ߡ Gyk.1S<;w?<w2١<)=<w< t0=<w ?>rb[}#>3
!$u- u-1鴆еߵ]b¶3i+Pf`f.a.Ғ.".QH6 .Bnv
PH.f.Pr.ҏfar!0r PQNX *
reu`Pf hU" P:QXeQ2R0u쨀t
fQP<u r õOr$rM 0{.0.\2Vr`rYr{[Z:[d[0\U[][j;[` ؾ;"" QYo;a]Db]a{gd r&pkԿ fObf_MYy%eeofg'_ r SNSN}FN.&mllYRe ff0\ZQRrSNHNt2@`Xٵt"a @ c@oTZY/ao~05puSNENY0qqY@ٸ 3!Ĺ f3& &EZ@z2 Q &,r豂#r8t2px`.k&EXlSO[&M.m~2tà~$~#h  5WO hŤ2ϡrh  _vw35 &E
,#		2va ~h"%00` }00a% k ?  Da`6(   0Q aVī^@W  3 _r-p}s˸ D}0EDbeՀ tB@fBe0O0g`g
rNr PrVPuW2&*G_YýSR  p&*{u&}Zu&KE@_@eoi Yenn rg rb2ۃ<O0		?B<tM0gxyTr;;_rg ra 3hcHC ~SQpP
pPVtu$<PteQKu洀aUPBnY[Q2R @QTTuu/2PY$0؉V o^WmОQfRtth;Bt0Ur:|Ut3_V 0a^tVh2B`f_^Dfq8M%Q͹? YP+9p  fPQ>2 uι c red`2aPatC2Gr-``w 0 r uҊ r
6u`dp Yp rdItf s`!QR@yf qSRNr&p0r!ww3҆r r	[@Z[`R.8.HrqL@.pPh.u҇.a/ZA˹P+{YaPv˰j2ˣ[0pr	rsφ5BPfQf   dgfYuvNO fFeT2 C P˰ " _2蛁P+,   )' eQNNO@u!SV-蘐 1޾> f<$F10tuP"X4} P+-y^pSذ1W r[P+ r | 1 QU ȿN`ݐ@`ݏ@`ݎn@OаX L!1!1P>t
ﰧOAS1 t33p|G0)o
ta ` tt@ÈEPQRWV+3N O ^_Z!3G<u
wtcV^Wݿ _p  p|1Э/ydxa
g ы/\rL 
M.3EPREZV tU..F/F߰.^ ۳ `Ɗ2?uRVа7rNNrC2r<`r32t  rr;w`Ҁ @sڋƿ^ZW
  е0u
˾E Au ߂ fo ufp2p J3322`t0p 0prn!!
$	"
uƋ߱d;sRZo3! Fa!F2p2t#	up
S_
_.pK.fRK.Y.IrB{qPc,w촆P26220	VǻX   h=SsPf P1Cޏ_fXfX B h`0=3N BzVz 臿oø4ҸECCL8jğf>PAMSf>P9wq61P:EH@@󋰙&bf&E 	 qu!>a6/b=u>> >E?=> B f+pMA h{S  ؘ@DD3qDBM>> hBS=A> jBAqrHI= 3A0GMJ A <KfL@MA1aR1&9f1TPWVf rYpE0+fP < u hNMhaMrBf2[fR/^_XTָ.T쿺ֻ@E<uWQXfB<W I[(\^sgPRR
`oif`?t5sư k"`0~i]"ЎjjQkr&=q tV" &GF^bkYՃ s5\ `sdю 	 h\B
fs!
fs"fsfsHs
ZfsHsPfs HvpsLP$~C res0꾙G zQresr+}zQW3Vuက 
cu@4uWu_1hm~SU!m.!<PK=.1Ʉ3s*!7q.0 ,gu
 @  .#ʆR W*5 ɍvQ)9FYf.a< 30 gg& fO0
 30g&Of.[aHuf1ˏU}5ӐFUWnhGY_]ffv
P 
.7':ʃ̃mf!<f*ffUCESu
 w2ÿfRVfAK\frf@ffffo^fZf ?3wѠR6fa v1m~  PvfXˀeu   t ` rWLQKO tC@ t>R t t.tSb
 S  [r~!fn `?_Yf[SPV#ؾ   t
ff;t7îЩ
 T'UT`T<1Y[SU|f	f uҲ!0Ҳ
fffL`й0XrYKr#1f3ҹ ogthYEG[_f`u@ u 
#dѹ#ffд{ f  `drffk H f :uA =g_f&_!O̐_   rft;wQ? Ɂ?S/ECUtPN<Rp ̹,\if`Rf
`?w	Ò;N ֒3& W` f_r26b$g&$fg&	Ӳp֡;ʡ֨bg&fGpt;9, f  r%~ rQ `fY	fQK f"Pgfoڒ5! r r?ᰴ  < t6@ct1g& :uK"FZZѭfKofyYb t8? w/TQ?S fUaffR$t	 /--R
f+`HfBf]^xߴJ` Qg`Xv? upF n ufǑN $ߐ~dBrQ吾
ԾYӠ	r !2/O	o
 
/Oo /Oo  "/#O$o%&' ()+/,O-o./0124  ` >$`<`u*X  .} лYb6q 6h aR5 u BJ. @9C1::n O aSR9t@B u$ZWP h
♰Xgg_s`@6?fA@g7?BRCfa0P@GX e PFPPofFd рFYF?HBG[SGHI; X tGDt9좃[Xf_0ù@ fPffffX,fV3ɎMfVf   E gf^!Pf^rEVJE FoFGHc HIJ:?KRLL^$MMfN+jOځ öPe_\P'A@Ӊf_fVB g C`q`tTfъa5a"a5bhD`5gQ Jgda&e;gcaY.}gC`Y$g^fX_>bu5VD`f!eueޒiofޖffEgfgEQWB ƲkD `fA=;BBJAX	

]p @`_3(@m^ftd f׸htg.u** End SetActiveDisplays: \ R$пKt5<P>x )ڊ׸ 8tAz^ 8uH@pQSaz[00to@uR|YX2tCzW'׀P  }@t |#   |<uȸ
 BauRQ 	
3s{0  D qPS|S|Lu
  oP [ e|b	X9pSRjP jP$ jjċ؀̿ jXjXj ?P=vБjZRn 0r t!rjPÀjfWFĔQRPS [X"3t߀bc|xd 
r\?u|o h @0h``V
urr2,RWA_Zr "&& &E"&]   'PEsP24????4`h|2ѮfWU]3W_|ð PRZ| .Qut rH rwt *_rbt` ]bֱsAfhh 0ǻ>0fвҳ0єڋ> f_Q``t' tff ITAfgf!P 
 2gaY|Ph@Q|uu;t! l!}e| f"06&`Ȏ؎t 0e# (w >Aa|8vxtbOV0Zų<  O Q05af/>to	t ЀIu3@uQ,
uQ&hӻu
3touCu3Q"NbpZ1ݰl|Ay0
 <@o <u2<ظ
 h  Ooݏޯ /Oo /Oo /Oo /O o /O	o

 /Oo/UPRPRVFZXPRR{3Z?  !#/$O%o& '()*,/-O.o/ 01235/6O7o89:;U<¸ Ѝh>@FG	?Gۃ@-%dZk('H(Vޣhdf1Օ8H"R'܄I?
/MGEC۞GEE'9DAF>PX߹䴆 %7h4=ߎиPnPI% I0m%#hDcJ$rv习vIPF%(jL"@#  P0QP}  tNP.0Q0P0QJ3Q3 @fJK..z~Qa TPm1TJPc}JT7#3h@& n  `xS Mq\\[XfR@QS\\uq\ ]路"PS[]0^Z Qf   fpQYf0pp" ⛹  @vP ~Q{"uy b"r} Z"ru R"rm J"rer]`PuJUXYpYUJ0VW r'AQ"rQ!r1!n5JL M h!u`,	hu$QįaQp1qd BB`rYÜR snBnBB2JJnB$@vnnZRV!(px/w6yv^ZáQVW  _^Y`%3gG}2䬊Gaà桠
!  !s-l_[3.;@t mV rA(_ p+t3Њq~"魥a&Kø什k1!û}Hns;OnPn3;t<u7' {.J  Zээ89q:q7 øtU ðqeq$À&X<`iDgsV0aö$ؾ8Stؿr[ݹahcJh ę_<ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ ƿ?_ Ͽ?_LؿmO ۯ$*("dܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ ! "#$&?'_()* +,-/?0_123 4568?9_:;< =>?A?B_CDE FGHJ?K_LM  p   
5Mx MQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R          Ux NtAIBML 761295520C??Cr   2004/02/04 18:54A. bBG ZF
U2 27Mhz VBIOS Rel5772,BR5868
 (C) 1988-2, ATI Technologies Inc. BK5.0.0 VR001.00p07d3 1 mssaphi.270 v611  MS2 AGP ?UN  \  \ T  q  !7CEeurj?
^  :0$TVSjJ0  ~  HD8P_CIRAAx P RADEON I`340M  CZAy0 3Q CD  <  AP @X A`wT M[H   Bf!0@@	  @#dM#A`$ uHAM1#! 1#DYp 4@s_tA @ u
A-A<@
 Q 3 *L  @, 
H < B _  .-uA.B,B`,Q-(A 
 T?0T A
-   $	
3  # CAav0p  lBwg
`D d6h6l6r 9t  9:F:f`.>, u..,..	 u1> .0.9?u.0Ȳ.,faf`S.=[P#R$yQP+$XdD .kfa Vi^dpz.>Dt贤_V F.< 
 ǣ	(I诉$eAF JPBXpJLB6P ?u3۩ t߀M0MM{ M  MPN = NXuM2@t	O @ÀQQ@t÷O!CB0S M ǀqTt
Z(vZOtcZ0tįuVZ<T u=T첺2ĸ FG葈f@ f@fb)f| u-ff]@ nf.TȣpV^ <v  !  32Ĉ&! .~ a@2ad^	AdNhV  *81@Ld
Ff^&|G
< .   k P+ @K_
(@dehF6 F
u'XxYt|Vho"G_oVX2FS_N)N=SY2`mnV<tipWVqtWVtuu	Wqt; t6f;Q= Y#l-F;$u<t<t<t
<t
뉰F f;X[# ~ tF: FphfǻF6r<F2AY\ wtÈn<uj`@atf ct p~^"N  3X8u qxP 
X"8tN ;N"rҋNN"ar /s2~}tRSf_Lf@  ffff&f݋p~oq {sQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F  yFf@F$ߋFFF@F&F(( tR.&P@,X.?
po[PR.Tt2K ZX`"@ FGon@rj=Y	;5vu tU;5tEt:]r9Urmt5f3nq\f3ۋ^$f3fq!}Cs
<2
8sn~=}:n=a P 1'(x#D Da S?BDR*C梦cOQ]0eGᅨu @gOVࠥ@hOQNbRU0TJu`ljBcgvW?X _ce
pdV0f|71cj`O| !f7µhsb |h cf	3JUB' $|yĽA)1% LyqHdy32½w G @ן/?  =ҟ)$ǡf1ҟ 81qҟ*$0*űǟw
 	
fŐ3ӟ,"

` A13G羢oY]M``aH袦ip}1 颦q ?UJꢦ3r 
u<2ū Ujۑ Uۈ Ճ ܄v 3ЫPÀu#ڋ GuD u	 2ôU qxƿFF
 F ҋ[ ]FbVuR S|j`UU```$VF\쨷ut@ @0 ,^P@p Xj  U   SQRVWPw<A=D...Tt& _^ZY[XPSRsP$ BbXZZ!2&G@а薨u
R$@
 XfPSFTE݄EFАst? F% qPu AOu/~@J2K@jqJ;[f1 EEF!Xː.?6
A|t%	u<@	2@ n.
6]_V
GP
X
c
#g
@	EgQـ.2VdYe	 
؀
u@	&Z^NF k pfFig FCgF40 F.$FCVap@@@?f`01fpfafFk[FNF rjF]kW  0_$<P⩗_QFY_kSW>NP u0x 0" 0"0"X_[( NX$M[_"ltF$F&p~@o?
u/~B~C
Mq;M`mMVD Gp*J( f3!, v GJ  P-yfN-A. @.{ty+ @	 Tw CU](  .wp'Mo
Ģ+]*u`
L"tML@荖`It<uN(߃u#3y  AEq b;b;wt+SAU1([Y$`>JACJ:{C@jQijtjKB0Bt
 6tK@@L%?%P%@
Ā?
XÐ( 	 c-'(+ Ҝ  ' PoGHԯIJPpK`c_OPUjL(@OMoNOPQJ@K`LiM  U@i0OWoXY|ZaS@ ST[\(@] ҫaڀi
AS mZTMB](
cpUe#f ç
   `bc7`LO
b MBHU89:;o<=>?J+_gGL_BReiJdpgZ"ozcfkjhI2Oi`jf1ogڱop>hꏟ2 qrP~ps 
`> @،(@uU	

JpRK 	_\ \wy^0{c_{`|1a}~ %( (,%*26', 49$,0	
!&.3+0$8=-2o $8?ce!ac8`xecpy#@~	Rc%m~(pcKLd _m|joRcS MdOoϝJ	eKgLh9MuScgTh9Utf(RUȯefewwy ?~_x{w_A@YUzAJ@0{ O<..puð=Ou&"P=: sX.4X;B;ݞEɔp_Y\l"/x=>|؎= q&P$$(%$C<~.;u*6G<t8Dt	\S
OX=PC
uX1체0&G	tԱ G	`)?
u&.+X&c b%VX͑ɊP`tXubtju
D2Z}X&I=0p!UF 3`]U 
F CE]Y[	A*FXPs(h ?XSƇ[i(.>ku\9Y9V9S9  ss't
18 7+8$%@uP{z7']c;PR: XC  Q S[RS݋ڸ026'C[2S  &'[ ĸ Ë#Butt&FS޹ 2&CQort	 F[7	 2n Ȋ_3Sa
.f[t 5v @7t ̓rP?XuSصK[	$
tSÊg% oŀt4$
@# t$Êpػ
}P X3<JQu <~$<t <t<t@؁ð@d  a u Á@W  3  @
@@ b !"# 3@Qtb
%%o`aSI߀ e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uPXmuK>L tDI @.>T@ϯ3u"T<~T&g7!0u3 30;(W2PQ33 !X2PR3$@tZXtQ3g0R< J3Z8 43oQ'3S3U3
1QR2aW;B;T; f3fRȊtlZj0#ZX8t`P ZYXkuT  &w@&2u ʈ2$
t	u$ 01 PYΊX@0Au3$0<0u e+&o
6o<uA,	*U+t	
te+/
 1)<u+,봀1u 
-
,a<3u< r3,<
܀4u< u̰-56u& <t	 p5ް뤜B"
0%d %^N49 * 7)Sr:P 7Ȁ>cu:,%@ 3ۊÜ.B.EC JXð+Qt8 &B BH<8t<?t1B .B 迼  D뷀% G.`G* BQ`J&Co G>CYJ 3X BQ
 |YkB.%NON% *P?#QPQG@HC G`C3S	 GDޝ~~|ֺ| |88|V8 WlW <~<0XffX Y@Y6xx~~~p`>>66f<ff<  >XXf^ f {; <f8ll8]x]~^ 2^ }0pp0$ff$j8||Qc|V<<Qa wlllllfl ~|0` 8l8vvb g``0 @ih`   W1A[$ehQc88 gP]|?| xalgfl<| <l n|onƀlЍ|@pAp q~n qэhg0@PcPc1sine q~g ff|ffp_ cf< l^l  b`|``oޚnƢu e <ryp ؿ  i`bqVup y|uCx y0g4z p|n~Zy|xlV}{l88uq^e< gP{0x i| 1s]||VP0Pix|~ `0vRPv onЅ6000_vΠq|P8yx`flxl`L" r l{ܒ^Ap|Px 0h|Ax g| 0!6a0Phpg2!f0"vЎ 0dG [qDa [ v0lqvY_{ |ƣƕ8y8l8| qa|f|ƣ0l3uuPlwQcl~n ~lppgopry0 ~l`?fl f^X>c8c> _ >a<Qqg A`{P|> >`gc=L`a0`vq`iqPo 0|w6>l<~te  6ll60l  "6UwRA6  `RAձ `QcQcCbj մAaUt7ұ70??0ø2!Ը!`Aû66E AԱA#b@ԱAEE  f`x̯ `b i8 ` ff`gPc~Pzr^|0a8 ul8qul8f_~`|1m 8`w`|k̈́j~ t͠gPs`Π[xakX je8fpK0D| dd cRH	UUaq2VdlVV5#WdlBX$X3XeX YAYYYZ AZZZd!add[d>6\vfasp~Y~%d>~~>%e"aXSp^d`{@_?`||` ka`℮ddbd $cdYrb7 p ?6ݢej9 ffj pxnbqf!n4 h0v~B`t9gr@shBf8 ɩj ZMp]l!mуmmlQ0no3o@o ` co	x0pтp r!qт|~	 cel4s6`2tpj|2uy4 v!vC" cS w#wcf`d|d``Pn
Rs cё| 4y4'Azzzp4{0{{ {|Q!}P}}xwp	e% ##a#
`c" s34DV¦d^$@d !C96Cd#V8 (pPo!@_ P80w(>a٢{ 7"&%W"2x$= 
F~3 t<Rd:,s  !uK=` ddQ QQГ3=d9Y0|Q#z;0x{7ŉ7Ai 7 h{73С#Y ;ŊXPs;`?p {?tgy\u2! ikf7 P YE0ED`jPYW A[WcU%3R] `{Acc0cB X7!Ή? DX:7 0> P$$! 3`03 B< ;D>
p
` ~"֠	"l06>6n6tѡQ$  D ;FŴ ԱƱE캌 c윏#'  #	ŵ5剘5 ܘԱùձ%  ձ%5úU #ұT%5 յշ4 T XÍ	{ah7ؒ!Ɓ"'>b0P"h: 4|t..te]%0<P``<f<( A| 0f0BV%v4P stǁ0:7Xt @y<_I/x8بSؐ0~4 u-t?W2@ _ר&&MPWI &FG_&E"&E#WKj_&]%&}&I2.2
tk@@' ܰ)ڊ = ~=^~=~=~ &U*&$
$

P0B$
-1|P2;t4&w_t eU e e 2OԊ%@+Fhݐt:b Sݸ  t`:t?F&݋o p4uf&	Rb]abvRъĐJ_O 2  &GF`%GpGÜQW+&N&D&TAΡ	ʡ p&RW_&TAF2 MD/Z
C37@	 !W_Z_Yσ`GQWM$0C󤾄V rt|q:&?Q	 G	ĸ  2WR% RҩZ42z0	2dYQMp&GCw/'Bw"wY5MP4 iY t'EPJJ B2BBXJߝ04wLT(VBBA wI^ ` (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0%433258:=<:98899:741	
	
(A*+ *

	

			`--


.0..R..30
{6*N1 **111u2? 3??13R3`3 -00B   $$$(((---2228884? ? ?/  4 4/? ? <7X888?'?/?7??a<7?/?';<_==--?1-?6-?:-??@:?-6?-1<@XAAA@   aE  uDE_FFI<IXJJJaN"MN_OO`U   R  KRXSSS
aW
VW_XX
[
<[X\\\P$
ĲXðKðK[  c1>I~&G3ue	u&Iú}ftԀpcN0jb  P3&2J&Gۢj ڋGLqkģ`À0cO BRl ljmbmlmmnpomÐ
  !"#$k(
K1z[1z{1z ;1zl(L}ߔ\}|}<}n2N^~>m@M}]ߵ}=`P@qPqpq0q aPAAQ}AqA߆1AbPBRr!/cj)dCSs}"?dU/DTt#4f?FVv$6eVESA w  0 JGϿI  00ATI Technologies Inc. MS2  01.00  @ @   &N   C>VBE/FP !.6P<r2.TWVSQR  f&= 2u " Wi_WȎ؋ʾ~IPW@" uz &u@&E6_W@`!@`@` __ǃ"@ڽ`0uZY[^_O ËRQSVWU?WQ3Y_l|u5WV6I2^_
.TEE
VtE M]2].l.DEEӀ~ZӰƿEE!# 
E"$ ~7꠷ a+~$ `к#к @"%~  EeUeB(S23[N
tȈE}~=
 P`,E*؋EMډE,].

+E0 X 
 2O]_^[YZ0RQUSˊ$Pw
 x < @t| dQL Y~b 
3Pɰ c}t
	$XPAjDmIjDj2rjDPku-tuY.pb%O[]YZPø VP$6Gشǿt8\t`	2^ƀ t %Ԃ@^;O ց	93&PWVFfPYfXF^&Vf=F^_ FG< uû7Q.T.0W,
._?twCCpPS(Q$ F[XSh*= rH[ ktpt
uPSR Z[X8
t
<RBB@Z2Àuptp<wjut`2.T
,a<u`O2͋iaPX(
uÊ uW^@!p*_O< uL0*؋RIS ;[2;vȁ~#?JS,f[Dt@SC[%@عSQ)2f3ff3fY[f;Ës >klIft2uGf`P1RPfZf ff3)fX	<u觾S$f[faw==f$` %%>(؀XZRQZfXr
uQR~ZY uRYhZt3t	! wl wf=	]QRW!9Dq޽a f&Pfǟ$
`&fA_u7Q&   0T8<\ }VRJ0fPtZ^fOfƢPRTZXtfffPf7VX ÑV~`RfֲS7ZuñQRfRfQY  ` $  ZYX
!f	^@
ff
v QWf`i !0B~r&@
~
fIu$t%B&t&@[\tWa_f.`**;t+u 2`+@Xw.,QSu3tA
[YQ
$Y@?SQVW# I  &I5z55^Y[7QRVW 	_^ZYڋ_ } T Q9̃8U@MR2 Zt $Q=ľ=
`= tSR <uZ?DQSO=o>?Ā&= 3JJeL=M{N~MNOdPP!QTHRMSHSÐPMIDT`   aB܌أp@ܼTXR ZRw M
 M ZÜW _Ü  .,3d f.;xu	W 
߀	r2[fXP3Q& $4
 UzyRHSQffQQ2
QQQRWPH f3fXR2Z ff_fXZ@2@ZYZ%Zo[\\ZV^fQ\fY`̏YZad\m\]jeV\)ggR`e}=OifZf ]f_Z^afl g +رKK;rZ` S 
S  S@ [phSSSR	QqQ @2QYÜ2C @pO@` Cw w Iwd xwxl zwzz{fn^~a.D= ="f`.T.
D~#PwQZSRC~l.s OZ^3~`
	.DfXu_ Z
B|Q3ɊOb.d"YTcV
 GQ A8ttuP3צt }bu
vt  U`PXP aĚSQ nt)hkrOIC-KuY &V
pEk8t
]NPKXBL`('`A! `Qvjr
g]Pᝅ
XQ臡P$B<93X㱭7r0PXQ QP`XrrXsYY2Y SQW _YQWar
&@G	Ku_@P AYs"'и'Yr?
 Pft2+QYIn00QU2F F  IЩF EK`pe~  tf~[  u
P t p]-wu @ktuS@[2SހXY@[<t<t0ⰠMu[<u <@˱u 2뎻' 
PQW&EN_Y&='XuSq0/upW&
_
t `p䜐uÀuW u		.WðpPXq v<Zr,ZPA [SE@r6_;w2XXnVW@pnH$S舗QUHyvA. t:uF
qPt0XqF}
d
0$4 tp]зR)`82
ڴ
Q$߻ 
ǨY0_$7q,|$ARm|$N\URN!$|#ۀg$RX$Z Cu9@0S%$'"2[M$%RB`CtP4vX%mm Sno`?KÑNNOF,F"Fan0v tWolnnnt
uut
NONpR $?ΠMS"
n2ACɹD  0q $`?  D b?+$p'$R b#$P䗯
ēPR_u$jW2Wp12;p p)
st`?
B8pP.ktP ^XзR vqN裯M^Mp)mEskmlem	phH($"R50t\
&辷O p)uC
kk;lm%"`?u%" dILLM T $ZBRW	 	2	$	$PS
[pPG_PQWP1XXp
u$<0!<t<t<p <0! r0!F, u	FfF6%:R._`*EfP%~GF6XHݎ u@F8XH0Xf%  fF:(B)f=(	F:qi2E..>̋FF(PwX0!}#r]L0!SK[0! Q Uu	 Qp'TtR3Z0Y.C2HFP$'GFF$.
Gz2 4F 4$`4Fp'	F 4$4.M	̀

7388
ňFF	$4	F	 4
F 4_Fp'3 4F G
F3F)F4FBFGD '%%>a$WPQRF;
!t7<t3<
t/"P"
<t<t(s2NAVBxJF Z`fv!-P%2XtkorDujP n0X P)P%G:u@P X0Pc X #u#PLP@hLx : p0d ;>u;852/,j[Xf 
@	[ihZgqgI"I;JCKհRu
	Y gg5hipu@TtIfEߴHHAGtڽtauIe{q[f.? t.;u.;Wt3E@^-'(+ ]cߺ@^ߏh_^_OPUU_ wb` _bЏc XGW@c n6gOad  _`ccbTF_fc2kUjj. `cImn  qZ @Ȁp
2[ESQp3`
/@+3!pt!p		t!p0uuC@S ux[>'B1J4g+PwwwvJ4g
ﰰ5gtx2w	npy 7g
ux;gpy	xPw py	Q|
uxPw
̀<g gwA 
Ȏ? pm&v$@
Jv@=^v	@=vB?
ú
 ^A0IJS b߲Q$P$fP,
 _fXEfX=ьP5쿲S#q?
;s.:Gu]u.@R&2 H pa f3.tUĀuB@y u*@ ff`'Gtff.#Gf.GfۊРuR}S&9[Y  fSfQfR\Hm  <afXf+@߹@ +`fSGS1rfDGN1f.N= NFd.Qf@if= N  ssfA!ff ffе f0u  r88
@YfZfYf@@ K PZ d ¦   	 0 0R  ߀ 	{    0    ߀p{pp ^0^0^0^'CxA𰱰 "p௰P	 @KZP´   2 KY[VS]XW πQSfXk  @}õpf[@ V	 f`
^fXQV2kk.^=a ~8Bb YR{
`fXf2@UГº
QpP$?`X"PUaw0P%PP%X3Qf
?Yfp2fPV.^2NfX ̝AȰ
Iquf&$Pϊ32fb˹pYf#PWVRQ+Ë&G
P36 2r-v8t3t.t)$t$)t/r
4v6sPQ@apfX⺲&2&YZ^_fX QR
FF?:q50+a&!0ƠSحfظ`  b.
$ Àtr_tt(It°0SIt 0tR0ro `da{@t@.
莰f.?=WZt Rp f.;Tvvy`'P  wjvef+б0RvM `v?~v2dtv%jv` e	r	wUNf߉V`^f*f.fff;rf@frx*f.?O^f;rLf?.q@f;wff?+f'av
ACX.LIa؋N]t= r = r5.DP.Ã (		[@E1À tpװPR	V$T$@Ru$ZXya&GG@tP@щ!!$&W7u t@v@nvHZXv`ZX   RWaq3t4Ж_ Q@w@`0a6؟f.qͰ E-  ͸pff  
N!>!  ! j"@#.qf.&s@ff;s!%f6#
߸${v%q&X&'r#5 6]'f60"6;Ewf6@#qQ@p7t<Q2P5aft@f\f
 \?
P@ "Sf44  Q3ff%_Q@ø \DwuHۿà     SPŊfD%f#p@Ƕ87p 7087
  7 0 7  7  SX\$p[ $Z
Ҡv)$@R  i u  @и(.q.&q6sE.q.qhw`F @@pH<Hqp$.@ZO>@!Rl 0%g +uKK;r 4 S`<
S  S@ [ 4hSSSR	Q OQ YQ2 QYÜ2C @S 				  aU p V
eu2[Y."D
.
veutcnus] @C &C2oࠢ2?/Z[հ00`U W&E_PZ[YOXZ[&DVZY^&^fpb$^fFtf
^~FfNn;w`K ߨ[Xu;ifG??P︀D
UlFF m	BkkUtfߞelUp@
߸TVp;UpF0͐ۋF-7ho{VpzUp	FȊă1n4RsQwnh%w8&UpF%! tQx0	VvPFf=P~)h@f
 ZsU]Ë؀~Àu聎Tt
 $Vܸ
t҉<071
Rp܊2M Z 4 ޡO",嵉"!?S 	QRc3ҹd 4R#x.yZ[  RP۲UXnP聐$`K@ݨ L ($$< 3tp  $$@!h206
u
&4u5 * u.0t.,ﾭ3Ý W߃ [ WQRVSQӰ.۲+$sܨ g 2@ W؀۲|P~@-Ϩ t	 |X  PxEbBt-OD@
7._[^ZY_V衿/=`VWwV?'P2Ҁ?څ2LnTС p  WPQӤ_ a5 P uD_pz
q Vf^fP_  @!@.fZ>Pu&?_0@Ɛ =ËË}ƫòA0؃"r  V پ?y ҤuMy ZX^.t6Wؿ
	Ծ_R0Կ 1VS|
;uwq[^ؿ_y\aؾ@}^ 
 3 3"QcОV胔 6  5  QPcײPpⲸ'X1RСXӑq NلA?;u@بu[û" 𻐧ڰ[!
gf1![z!`3ɎAۋf @  r/@s*tCVf gf@f!*f^f[Ao;tw59  f@AA:uf`Aa Xh l  Bp   & @*@LN  QRS1֐P0Pf0 
0ײXP%
XXUI[@Q ?NAtЃ@ tP/X0RR@s~  q.mց<NׂX F `یN.L/.xɋF2K Bd߀趠ۃ^ !֓ד
u3ɻX0ZL֊ȵPN鰓u: ջP u !$2逾P  $WdaOԲ) $л
Pu轎u"Lt Q  VQ 8Kt
;$

	(גђ@Q@ZXt3o&p;ߊPEߊ2bKt ^6r	 wa w tӲ&$P
0NR2!uaH
+Q޺PXY0^8bp%Tt$Uh$ 0MwɠuPN
麑T R	 
t U߿6錑P鍰w}邑BJ{f3.O>f.O&%߲$*
poof  f 
45f..O>u%s%usrE%
p
 M 	<w б 'ΐ` t ҲV_B&EJw0J
Wΰ`v0J.$FGG<v_T2`/HHز80pa69C6"4 >18\/hѲ8&E695$&%{+W 3	 &OO_969P$p/:ʏuCP[@uA?PX,fۺ U!-@0+fOf'>u/вޒ/j>u/C$:+M>.[/&`8f0fmƀ t
q$	TqRIAHcEFуKQL3?3ۻ  DK 0f+k&qo =5KK0tЋ&1f?PpGDK۴QLo_Ak_X࿊f% pQIu9]t*V~ϲPPqGX$
RIq<paDꍀuznG(WI`J`J!\JPQLraTQLL&M@&EAkpܡaQLck\uoRQS؀〰	[@@t#fY;vȋZ;ЀgPRfQnZSXnaUWϿ"ku$,,γJڌ!-܌q^Jƾku?!m2ۨR0 pSq1ϕ[op'@qpvk	u*,k萚u@w
=-iBSk
l@p$>m@n$*klgvkmnkPQR $ظJ/ZYXً$< t W}& G@<Q Y鿋p 0/ul R
,{-Bpu~P5u
uu]EOT`q+YE+23!"Eq]FpB@Q Nt b03F0BF11
`
t0%$ݯG 
Su}`
$zur`u$
Eu $*/u6Nͯ= NdSP[
OŔ oo 緀
rȉZXâe;#f0fql&Meg&U
g+'p33a 3У3fu@s@*` fЁ  "  s'i2~ol P $Q  f%oH˻
% 
	Qp$0!(f@ YQ tpB ౬h%[pPX
Nð
`  
- P@-ࡳP`$? xa? -gpoZ =u?Gb	$94 $ `F  jjjQ%A}IɸG(/$ɸA 4T,bf%QP @߸@Ŕm  3 ߱Aða3p߀8tR_
ZPSRUȲP IXoZ[X pRߊf$f[_ 1f "gR23Ұ
)u
Z`..T un> tgҊb2P>bP22AQJ2=QRPN, 32sZYYy2 XaZYYR*8}2.TZàʠ11m 2Ku2W S!u
@j[+2Ê2+`**&R  11ZHuÚ 31"JÜB J.TcwQ @ 0PQC3BBaaPQ YXaYXPԨuXGN!+p܋.J
u8~ސ؀T$0<0tTQ:Jt. `S /B_+`*2+1uX ʻ u*tX߰ . |`"aq0׊4"
ވÊ"ð( .ѝSr= $dm݁ ? +Q,QVW++    %_^1YԊǊ竊`4D2_`8v2QY2P >I?tP
RSbӇ PL[[ZRРJ2ZË.ߋ2 03<?& t
u߈V EÁ~
&J
Zv[
2RaZ`Lȴ
1
t
2&Lp`  >&}S`YظUJ<t
@A<Ut2[ð
` 6w`%P2+Q+w+ZPȐ"+Ջ+Nu`p$` t  .	{t	|A(.o!8~
td\8tX΀|+I~D*p
8t8*t2
8~
~߀ȐF}*t+Ɋ*Ŵ
RQVW3ۋs  2 ߀!t  `ޑ5 _^Y@ ZQR2ۋ3`T445G  ZYËxs& 	r ;b;;<	 P͍`@>р>ff@xfd?`R"S[F$fWfVfRfPb;f0D+Ɗ2BafXfZf^f_SRPf3݋f0GZ2f[迻@N(wy拄f䊷&Iplw$KE|t;@7pM_v[`+pMovI#CERZoO@REAP݆׆ѐ3p鿆yKtwFsL餆鞆OP+>PRR+ZRhiMt_o&XrRR+ZZq7UB	~(|R( 詿&F +	u &F E&  AcP b+>2u	&}utGVW_^t!hut
>| d2@b!ab	|`\Tt1b 0	rA(`u
QcAc6JX 2Ba\pmSXO@ 2cҐFf qKu[q3^K~RqV|A?g(
o`Q:uCG<PBaFgӁX$6| 62YtmU ؊P hu)#ë0&Ni>Xz ҿă脡1{  ׃Pi善O 陃cÀ?t!&0?$ n&WO O8r2Ê 2aЋ"s1RaGJ@A~PXWQPsêuXYo_QjIY+΂MtM_vNov
 驂 _uPUP[l.5X0qVPQۀf|@gFum4XPRJWQQWj_G8v
 IGY_۰ ![KZѝ&%_G+B;v
@Gzr0 3òθ~_rR_mp<@XߚRWQRQWP8tXP@u$֑X_YF"Z Y_Z?_ߦF4ªūTҬ3>ct鋀鏀>
u&f3 f _f$߀ }
ؐJDSP
S) Dt& `&]{Xp!9kĴ !GĀ# K
0) y'C[Pm1T1%  !%%ﰣxѣ"WYX&EzKt
x3k%t-ϐТ2" v}~~YǊ@0a~sK>b2PI<
vL^5$IǪA8sZ y`ayt u2<
u:6u ƉH~<u>~<u
t22+t++&eP>IR7`P}}1y}߉}މ.U~F2O 3Ɋ۱ʰ')uF r}h}ﳘ 8buܰR'}~0'0kNV6}b$
I((!Q̊.M\t.;t$.
DsY2k^|#+3*2d!d"<{PRZXt
t
|u<s I.ǟ3v>QXptDSݢ@@v3<JnktÆt``&F|+`&}Sa 2乿 0ì밀w 0$&e te ò @NsQ 2ĜB JG_  /^ {Q&5&m&M CYj{
u$0k cu4L){ vS	 &w5& 
M
z` I@kz}4 {  0k^a ,T 
ztM9 )3.>P;PY d߀2| XRa ZSںpB|w [= SBB  PfQf  Ѿt%tfIu! u t	0!uM!fY>0 vu ՗!Zu {"$ .aã<t
yy ny<wPSPR2п@vo@	f`B=s=s=|s^=Js ZXj[Xu<t<tˊ~03@mS'[xut05>05B05Fx.| ~ xȎpA2..x 
*@ b%Ƚu- 
u08p8w5wp6&İ8 u͎..v=.FF xu-b%b)b-uASK`[{&G&g3t!:<}{8<}:8ôPC<t
<PL̀
&Gw2 eТm 0֋P$u"3ҹ <uސ: K?:ށtpI0o
PqHuÀu
&~Ґ@Sҁ[t (22Q@iF t  +YSuPW>&}t0&<t$8tGWȢ&E@-Vpf8_XF3tV_tu cWG8 u&2}P. 1pt@$
J	U_Ǌȋ1uXtHవ10{&a L2u-t
bdt<t FQ S@TUVJQWW>X=&]&M&U&E
WȝP @-XX}2QZPSQR.Tt	>0ZY[X<|u?SBSz5[VQS&F E<
@<
t2P<Wd0\p' t&^ EQ	[trs`߉-P 5t}	t2SU' ][xX[YZ u߉:ubt`Isx;^F6t<u	C~&t.:r2c.׋]p7à$0<0tuPtá
2.;t8~û o tpg1#_^ߺPAwЇtӉg ҊЉ 1   ?     _Ϗ3R櫲*$Z.g$SQSQ@Y[f.
uY  ͵Xu	f.> Ofmf.ߋŀt
uꀓmRwŬ-
PFtZo ?
.1(m2.OA.WBotW+A_t;rÀtwX耐
u򪒑.&hċȸ 3  u,1tpt@F 
ݸ]wwu?G@2@
uJ@JЀ@

@ 訫`Pګ@[ZPQ.>dNu$.dTrT/>9_SQf@輪[#H`) 
XÜf`KPSZYvt	 轱 2!wPfӪ[1fЮl	2Dg	
f @502`)<࢐20FP6f))f  lT`
f Hh
uD˩P o$ut fafP2ɻ| @P$虩T 質fP諁wqP𲊩Q^P 谩߻舀f3f ߰"ֿ@Ã"諿d1øff	ҪϪ̪ީ2p, $
 fXM"@m@{X?X@d@h!@`pXfXS.= t.;u.;]t3o W.uRf 0fW.e0FD<t<<t8<t4<t0<P u0Pp~.=@uuX5
X
=u
M_@E=@pXx ^}0Րp׼0p P@jPmm@{wj X--   T ҿ4t~<VPuJ0f@.MtM%.M߸ ߊq;{0PPAOK  XPA֠P  $G蘦|$P2ק$-·$k 货$u $苧oWW PйW .? t.9u.9Wu.G2t}Г32_SQ.iɊ
܀ϳQkp<[QRS$puskN2[ZYÿhw.;WtГ3PR~$Z#Rm%fSfQfR蚼 t3t+t#@t.tpt>tD%ffȰ+0ff$<t$f- < tf+ 02f
 2f2) ffffZfYf[V@24ȴ2`.Df3ɋ% f{ f. UL  
QP!mfff   ! qXff;t9
0}fX!"
E"0a'$3#O@ް
Fb ?=a 4m0+0".^'@C)+`D뺰E溰FẰG.F+.~0 Яط t%tttt	t蔺菺߰芺 |PsC?j0a 2Xq PO'2CQfX^    = Y + s"+"C p"Ryou@:u	 .F3H艢p& Hq&'PNf_Xfp&'	(2)^p-.~1pa

p&1~,b	s`ðqtfP
0#)4٣@)   /8b00ofPRQa'nupRP`03`0q&H`0XP`5v5l4 _z4	`5$Q4`5,C4?L6a0p&=/T'b0/X:^/\:/`:#fmuo ] tqt= tߊ p p 
uu
߹XTtY]IUpEp~Mx<~	<%pD YtWE`GN`> YZRSfPW1fKQ&`>.E_fX[Za224
KF
 1 #M￸<5}IF; 00q(;; > 7POQP 41  )088 OYQI? C:QfQ ·n%Z<t0
 
0Z$ BNpE<H!\;0N
RP!00j X2Zf
  P&F.fΞP@)/pac  f./t acK/0ťyte/jtef
@ SPB$WXf% b i  [/&4d0q_ZY^ҕRVWtVV`ø %3ҿ.;s&@i?0.\P?ËQ O^~n  o[L.boL.o2Jp0&qqG_^2SSD4o[û\]w{w벞`uSw3x띰 w cy@൞0uYX@Wr`PS2 .
RPJ3XAmfW+&G ff
thf.#\fߑߝP43۹#fC fbv 	WfVwVჭf
`-Є
fU͇ܜr_ X躜f^l[H  $,48 DLPTX\`dhlptx|  ;VQ  _    ? c$
k*6
mc8*1 TT
  
 !c!1͚@^#
AQ"  @b @ rT  
  @ .PA&d!   |AEs b}Jށ0=PAQ; Im` $aP 8h.!td-4}A`삜Hy^, y-10- =d io"z%@A#o koVҲW̑` sqj P"&O۪¨/odOG` ) '9qAҲ [GTF+ A 8/~-ҲUp+,  z LmLҲQ\G(p# ' 9   PB ( 1Ҷ@:  # J Ϛ/
!(+ h(,1PUaC@U? PC؏'Û-'.]hA,,.֏
e1^OPT0]$[]`UU  SPQa7ސ$^_R2fQTWݪPP$][UT1߀  !X |1
w*
O"|1
:?"c0"ԭ@rҲz 74H  pSZ 

3sҲIhH  WF
➐wTH_{{ #ƶE) 	ë&Ҳ~CW;' +O4 ` O  ! H2юOSA	
(THk	»{ 1ŢOB  jҲ8~G[T 5 AupΰҲ \LG  S% 4 #7P ΂Q-ҲO`36Gr  &5 !$β[̳4S> oS pd\Ҳ^x0zp%6c#@~
(Dд C q) XмPG'+V*W+W0a*/,c=. 2w.*q., 1103r31`j2aP/6335o@274py4Ra6Va:5Wi:"5So0/t<>`>k>V).?_{ҲGT@3F,FGŠ3FIfG= A-YҲ+^zp`5 a }FyҲ_) >8 # A|@ҫҲթp)+ !*Ʈ@R SfUT% _A/FJ[ D
e\IG^~WҲ>
w}pN`! Q^9y RN STɖłRR/g@ )QU"}N\Pc	p8 UĦFҲn,+8 u- Eβ1̳yO`= `}ϭ;A !; 	 Ѯx ym{}ԟտOoۄܐ+. 18ݐ,clްS޲UA8b9,	 P$&/Bs>TUg$TV N ~@  0 $ 
t腋d  øN = Nt.x& Ȏػ2؃? u2A PVɬ0	8uĊ^X2t.یې؋7tP۹++.' t._'.G t.((@.?tS?.EtqECCRPVfSؾo.]1f..M0f[^XZРf9$
p
̀ 2P*H$3XP.E6ʊfѨp$
^$	
W$.e9
_W=	_L.]9t=6lHhfPfQf3.MIff @af% f迬fYfX$߰ $. 8 $Ьߊ R脋$C =%
Ĳ`=2.E.w̡0uf3fѼM>f&w%u

o轉2ta
蹈)$
ûG$<ۉ$< R苈ZP
XހWRq$Zr`%RRR$ZWР.E#_VQSPQtX q$Afذ9%<оf= t*f="f;t
 Pŀ~ f[fXΊY^fPAˁf=qu_fX 1PS1$  Bˁ}@r	脇T_[$Nqذ@֨u$@d
莈$蒐t݇"QR1uuKm ߵ肞1`ึOm@`l.>kou"L0%1读 ZYW1ְt]3#$Wv
QˋM,ӝtv@;_1ۮ@qأްٿqՇ$s0&m0$g轆_TTt߇$߆P7$ !ش @( |f Rt^PTYOF$fF"P赆 ߯F/-T虿F(2&P贆[?$
qsm31DUO?uBF+ 1m$
F+qˆf$
FT ~P х fF6᳋F:|$F9h X装FDB0ŅF)F*F4f ׀352^w:2@њY[u觢Y03ۃ0 `뽰 $J f /f J$
ffu
` 
f_fu
 
f	
 	
f	ﰯfu
 
f̀ff`oCRۧKAkeMGτ=e3qÄ
݄ fq  ux_ fX΃A%$荃u0Vǘ	@WUF 2F E]u	FfF6~`,:ҕY._VP , .GF6XqaF8XHf%~AfF:fXb//f=.f	F:3F>F@Oj2E..>FFAu_
R P0 q= u;60=Z	SRW =Xt = t
0:u.Kʺ!.= t.u3_Z[v~4   @>D>
ɺ""
ĺWף.Et.;
u
.;Uu3_PQR8;OZY`DQDtMtDS2t	E
 BP6Q.p5.%?F"0+.
IF$FQJ2N*̀oKN*IoF GfK)L)N)I+$fF 0@f`f.LN+ LF
F&pQ2.O$?F($FP%HF-F%
f_f.T?F/FbU@
DV.oN5P.G$ P
Xn TMcUF~f	f	TsXY4cYw Zn T+ M.V1SFD[UWcKZ$F3?fF	HyI.F,3QI0UQf..gQe`JFqe0@e@^eFrfe}fG	[ڡi$["j
F0pY \ F\I
qVbl GblpY0^fk@e`fnUaoG0^S2n4e|APe
@epgpn/
 _Rerf/f8 N	k n0V`N2AVBF0 F.   tW訆tR-_:A.:.̎0d2 `{ 12@00	F2+:h,23BFD(u374Q5qc a2 8 < C F H K L U Z d x     ( , `D|S$^O蒡Ft\
F u	F=b^~.Ff.`'΋E| ~Nn.X wf0
2}}0	fkA}Ցf^
֑PՑF͸{}Hg֑  Zё Pp6JґF6tP7<S2f[|x{ёXf^߃fٸ4|^r~/ 85^ `8_^5PF=$1 O, @)t
謝!3ZYqá{${r{%A{Rz1{$3ۊS{
[{53_H4_SQWJ`=zDzKE_z_Y[>Rb{#RB
t{  RS200M  OEM INFO!-_1024x768 |  
Ĺ t }    ! `   \XT  @^ -dd!-S0'0@ %]12fd!-; '>]_1  
YJ @Pl%ÏJ2U* oUH'Vk QI!-ORG<>]Ƀ߁q2D 
 X{͜1[ ʣW2"dw	!-Y 1>}WY2 @QĀ  ;Gɀ?{b A!-g ? B "АȀ^=`O`j p0w R À8Uʚھǀw%ڙnΚ 	a@6ΚڕBa`{LYLoΫ!- \v@=@4?23<e?Aӣ` s8c8t!- c mffӀP̽,i,w}!- i l
%q(  3 ?_x?Rο ?_ǟȿ ?_Пѿ ?_ٟڿۿ ?_	BB2q,  2ATI  ۱Ϲ:;#<1COD$q`$^sPS3۸ .G.>s.$.*1INI??SQP2i.N= NXu2˃	w,.'
t #jPBgpDPBi.&ep pGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_      t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhUv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &c&E
 ظ@	 P(^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hOBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhKÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzv  2 /JC ~N@bR@V@Z6Ԅ^Ԅb@ 12Qᅡ bR/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(}6RDDBGPwrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEwI*SMM!GŀdESEoTARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿7WR)Ԋ @T T  ! !EOP

 /Oo /Oo /Oo  /Oo 	/
Oo 
/Oo /Oo` !˫##ۚϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040_r'`*E*`*Dp204r	)`1X
?Zf[`001M01N09PS tatCu?`*L*7h}4v t-u$ؿP h;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
߀0
/=
q>)1 rE`Cx 2G G hP;_ Hs=CruX HrTh7;fP f"wqJC>
 f.|`0VQ6'爹?1A60R Y^PSQfRVW`*U*(&\f&Tf	 ^fZY[XS3ێù  Vp@s H ˜0U SXX#YXYX	Y j@B32uT6`*B,`* u.>B.P_u{.8_t.9_R@g JPGG }}ayrangac\aX}QaMFaB;a	70a,}%a
!aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ f ?buf.R>r>^w)1Q1QqZ 3Pqr#svPsszPss~Ps!f%#6 .,.>>_66@lsv6. vffaJ f=pO!f%$uc0R1f-ް&f 0 &yP
.QXPmqfZ$zsՀ`*Bsf%'f
 y+`*^	.Q~

z.|t}u..G`,s sO^ tbDB8S+.&Z5JxU .G_u
`*Y?~u)`*Kp2Q!)`*B	) .c!h"T~
fWz.6V.6If@mR|Kf }6Of3ffS'Ar輓oStA6 fuD>Q
6ˇd 01Tt	6݇U  } 4~tYo.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr衍>r6> _^V'ɡ s0fSfVfW)>64rt 3ҋ? fݠߋG 
t O
tw= ? _ 68)< 	s0B>uf_fVfY83A :r<+u<-uPR+Z~VR-aQȵ$0<:|uYXޟ@J}u @ l>@> @Uvu@V
lrS- w|Hro1PO
8rK}{?rDer)W.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVߋ_? t u
3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7<9ow<00 L0QѠf33w-.w-6/ё[)9/'"p2_Yc0.0Ӳ>nޢԛ
OրxӋ6t>|.s<u= Q> <u  <u0hr).[ӧӻ> PmPmDQBҠ +w?>ۨـ `*s!^03B>BFڤQTpg{&C*X裸W) )}q鷨J L6Mr, fNfOfAg&?2fffXPt á#?TBPme2f.;ew-ٽ  r%Q1ਐ tfGɰJ휥>8 r,vf2rmPAVXTT)@ r ,fffFg_f#8K .@{S2T~3aM`t
`, ,ffV&Pmxݒ@Qv"  u7 $t.$ Q fU.E.9.w.F.:wkGP;A5ŋf , tR5 uuufPm=Rf]ȁѨ9@P:w;5.=[ ! f4R RQ 
	`ZW Z\$S=
f  X Z0Sf3[ff$  fff'f 1%0$`%ߋ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/W$0!/t/?DH2撰撍6R3PI8>Ko ݚQѠ ػf?{tuCkPǟ O ntJfq<4T WFOPAtwOPX g>~ XTY*\~YfPQU T9GPF >Jus
, 6=A> > POXpV]Uf w]ayy|ŀ8Gbؾff&f_&J!KG> fG`Ga ԑATIIPJ6LMfWf>҈!f!QQQQfCf4ss4ttf~􀨢}VP6҈fasPVAVAVܠ0h"3PwhXX[ÕXڥ/<\$<sYr.謿r@O >C]CAp?6t_r@Xπ`?`?UAIJfQBEn}S  gf +u
'߁ u d[_Pp&r c@CXwra Jg=ư)xxPe14l 8lmnp/qOr ostuvwy/zO{ o|}~/O oψ/O oϑ/O oϚ/O oϣ/O oϬ/O oϵ/O oϾ/O oďů/O o͏ί/O o֏ׯ/O oߏ/O o/O o/O o /O o	/
O o
/O o/O o !"$/%O& o'()*+-/.O/ o012346/7O8 o9:;<=?/@OA oBCDEFH/IOJ oKLMNOQ/ROS oTUVWXZ/[O\ o]^_`ac/dOe ofghijl/mOn oopqrsu/vOw oxyz{|~/O oτ/O oύ/O oϖ/O oϟ/O oϨ/O oϱ/O oϺ/O o/O oɏʯ/O oҏӯ/O oۏܯ/O o/O o/O o/O o /O o	
/O o/O o /!O" o#$%&')/*O+ o,-./02/3O4 o56789;/<O= o>?@ABD/EOF oGHIJKM/NOO oPQRSTV/WOX oYZ[\]_/`Oa obcdefh/iOj oklmnoq/rOs otuvwxz/{O| o}~π/O oω/O oϒ/O oϛ/O oϤ/O oϭ/O o϶/O oϿ/O oŏƯ/O oΏϯ/O o׏د/O o/O o/O o/Oo ? _
? _
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+"s ѿq6 optP#+#`$+pĐ P?f. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG.Љ.fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ t8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@Cs<Q?r$?s6A}-`B+ 15GCЃ} ;, 5C7D # qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfX޽sRSÒ3 E	7WTkUfQIffD$70WuUcT+9% si}
uFDdW+pWZE}t8YuS uNT-fD7  !]6\0xu]07 ^ i!]Yus]_ KT߀u#8
fwɁYrgV1gV du8	1cc17,9R0JfXf 2TQ߀Ys0cYs{VctfY+{5 /j7 "kk[gkq8rӇ߲Wm_lieoaoȋTq8s"ns\fEVVcD1]SfönQokETf+7r8s0W7T*WT~:d fD@@'4'f irfe  Y軛2pVQ蟤^ t@lsFN+r]Y
]_y3wۋ@lD tM| /u
!98랐97<a\!5|6^<;uhs
\ f!7s1kq8sk8!~Nnj裹	xj95P:5Xi3wj+fTaB{s
qroD1pJg-kd
*fc.`vX~Q!}B'?t@;R{f%{s@l"⋰蓽j嘭@l@q8wAsWq+@lw~oscT8p\5VF`^k5`K95FFo<^jdR{?w!mnslAWjPХ8VYpsVr4s7Ar\BnХ嚐f!E~F^Ë tttk%:5n7ysduLn`o¬p qrsTT%=u?pWqh-Vf$&	!(=(tLQ	
v+`=urn2$0yrSFtQhٻ?0<`1 (ұrn@k@l+71|{ 7u Øn;3|}3kCm|`o1iVq$fedwcDjSjdQ8kn4>2cT0S iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidiؐ0phrTe{FbgOCf_2J0#escsssdsfs_gsfWP DVyaX
<6P ݰ: tA:AA\`D覔A5 A4  + *2+*4+*8+f5k-JYsMpuJføtsPørc@d
tn?oslc#fE{tЎ1 `J!%[B
@lK!]rB!p2P!Fbx+Wsi dpp1B  }߉ߏߕߛߞ ucQ s0cE
WV6g4Fg^_rg tYU	P!!s
P! !uM
fword d" q" " tbyte %*/r> ptr c #WV.3t"h6@:hs6J,6K&Ys#VO0VBOO_f^f >eS fXPXP
$0<9~FÖ!J!JhD
 s_+ !J$ CqYsp8e+s-шsf    Pr Pr  ޳   r    `rx/   $pr ' 3( ,T/ 0 4T7 8 <!T? 	!x @ 
 H %$P$X$x ` Wwa 'b  f@r c &@r h ( i +0 l 0!1(m 5,n 9,o ?,p Dג+q G.r K.s N.t R.u U.v Y.w ].x `.y c.z g.{ j.| n.} q.~ u. y.8&8:0:;6;: 6;=(:06;?8~:  |U.  B w ! PC: C  Q)8]ے+ !F  r !   Hs ' Kw H .#w PCPCנN  Ur O AT O O O H H H H ! PCxLM8 q)pXXXX  X([8[  ROp]I E  ^8PC. /1( ]ːaI #rcb+ 'E^ ,K 1A^ :УX: SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [ ]^p IIN  bDrrIr4ppU`qu WfE^ kE^ qE^ vE^ zC^8Ab`pyo~yvz vz(+z0vz8sz $E^ E^ E^ E^ .E^ y`$z|8}fܓ b}8(bՄ03FzM   3`,	ݏ 0Nщ: ^1w   A^1 ']č	 %e@+ Tr1Rҋ uҋ ҥ{ ֥ *1 ݕ  啔@ 2A 8UB ?UC EUD LUE RUF YUG `UH fUI lUJ sUK yUL ݀UM UN ݍUO T8 8(V0V8tT@P鵍 ew  e.@r1`/䧂$0䧃0䧄p1I 2䧆2䧇3䧈04䧉4䧊$5䧋@6䧌6I7䧎P8䧏 93 e1 e2 e0 d8 9ҡ  ޕ 󤵔 	     $ * / 5 : @ F    Or!$ { e K O8SX ]0bn g kp u z (&Ѝٽ!`ᗶ䜶塶m髶겶빶쿶ƶͶҶmض޶0(v
f&.5:?GnLRX^}eGrklRFpsutz ~q8 ~ㄷ(60684uݛРq0(Tgݻ 50f8ݿ3g(lRF88un% (08$~fcu޽u8 D8$0 t0V  w 
0 00V8 d8 f ֞s  txMUadd push pop or adc sbb and daa s;ub
s x
 cmps in_c decbaa bou
arpl imupn{sb out ~q jo jn0c@z@be ja j @jyp@`l jglg test xchg mov lea ncbw cwd call waitbff saPl@s!s stos lodRcqbbbRb rolr rc cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lockpne%e hlt ct ne div mi'clP
tc (Ui i (d db}x1zx lf@g@sl0)hrd bsf+/r btp,sp,a,c i,x,sep!.`.p..z R./.e-@b.pR.1 et T12b0gr*l*di14l14msWw l -s!4sq4s4s5s -ver6w ffchs fab08tfx`"fld119l289e19pi9g29n";z f2xmp9yl2x fptanڰ<a<re1<xtrac8s1fа>=S<pp9sqr8s0frnd!f@@7Aucomp7en:dis:cle<inf1 9B )fP@1esc19env19c7sqtFGaGfreB 8BB0ArG"G 5fbEiEb >>1EP@@CG`12E>MfiBIaO"LaM'AL wb7inv+wa@oQ`RARSz SRSRRUQRlQ VTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f{\ y\ߪz`&^{&^|&^}w\&^%^.s\{x\3%^3%^w\t_ߕ.\G&^%^%^.g%^5a&^&^a&^{&^,(%^߫-)*\}.V`)PS\߳ \%p[&^{X&^a߾4s{%^$%^<%^v}%^\t%^5s&cx䀤\|\ɺ5syw&y'5at%^$%^I~a5a5sQ&^^5a|\fe{$\
ަ
迵z%\uc~<ߪr%^<m t%^"y$v7%^&芵z)%^+t0%^-{e{05s35s6Qe{9uf{;{me{>5sAjDt}+%^F&__JdL%^Nt!%^P{5sS<e{Vu%^Xe{[%^]` 2scHf5sie{lne{q޳}vu
%^xL{d}W{膵e{#\P&^O\e&ϐ\\WuuY&^k\ur5s'nt杪{~#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6Ff.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5Hwz QMY5 FJ2{@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B mC D P ۀQ R S ABCDPOl݀߁R߂S߿c?[ }SpWP.@.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&aR<[`O?u]u1R8f;t'uG⠰ ._pل	  i hǝv ῀ h=g
Ȏ؎`Ѝh i
  + R00 o  d  >     DSDT~`  TCOMPAQEVON800 ~@ MSFT@[0\._PR_CPU0  _CST PSB_C000@12O
?
 P y 

}  z	}

	
dA1A

\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdߤgD5phg	gi
 A6gA7phpip
 fp
`'ϓfg``f bC7f cufvbc@``A8A9E
Microsoft Windows !ME: Millennium Edition"s NT C@AF
v p\_OS_`p!g@a.Sagi'Q`R9
bra
q uah'
 q 6b'
 s-%[(IW`.
&2/ p
q pq A8_INI AH@B
fpig
f
 pi0 4gP4h0 rgfata
apa`(ah`ha `a u5
 bbi`ibD7ub`v\[K
@C_HIDAJ	_CRSrD)
g&	p 
 `<P P =<!;
 C010>0?1t12?7?0?3>0?4py6@5
.,14t@4AD@ 016T0 E7bE8E0?9 rF! [0?A   
,[zAH0?B 00?C !?8 "HDC7[
^JE"HFC9@[J`:L20 ?21`022+AN3M4ր+25O6pI00O7O8O9&2A!?5`B2BARCARDAREARF E ?30@31T133T4T5O @"PT2T7AT8AT9  @`:3A F3BBGBa=G3C,3B
[$YDTETF@4T4T42M`043
!`
p2Aa}aiapa] ]ib{ab^[[4:
_ADR`pW
	
[ ?45bX [k[6Ed !H47

[&47,4J49
Z
[ggA0 @m fB034A4AE9[C?& @klAK4D [#~[EK`'4F,`p`op`b04Ae`e` apX dpy4CcCߒdco
{a
<bP4d`5I4F00bbtd
Qt Atuo82dcrdQ4C` dza
at ,wwfufpf a+du`['an
r2m@52B
n
 


Gw0|
mX}
|Pq~<

 | ''j50ґ{1Ӄ$o[+4E B{4pibpkdrd
edp{d_ hb @zbrb

bhb`t5P6Pڔ70j,55j16C56шcrcq+57bN`t86nwrar(52a%b 6bB686{17bu7atob
bpc@8yao`bac `9p
q59zEA;>52
553573o56]12^ш2aaS+p:E035A	{B
f<y A2
1BQ05Dp\/j`D48a{a #A3Bbpb1 _S3D
04D
[[A?5EEde5F
H
[KL60`06VqN6234567 Hp8 V!p9 E6aI6B(pC
!{h
aE68`i}`ha{`hq@@pD (8u AExx2FpPV70hi< 
`yaaNpO71
h|P4,6AI}CB9 0H7I6Dia{9ҳ?N0372K}FVNҷ1B]EB3ҷ19Bҷ[WLP3Ede74
@I	x=&75 pI76 +77 AJ7Q@7ЧH} a7A DqB!CZ71[7Z[8!N812S8qU84`B81R86A7`:81898AQŁR8C!H8D
i
PM&8K8ErL8F 
6"h8F  @C090@`091@!H92
G[.ͰqU9U+95671{99AN&9B[#\_GL_,bp
`93
 `
 [!
dv`A`9A96@<pjp
nП93p?94]5<w72֠aQհ097bˡx[ ѠBya
c}c=b0[G<̠:cde9D [́\9DppO9EjI9[ATA1`BSA2qUAUAUAA!A1AAAAB
=iP4`!6`9tA`pbz!	Ap
aPtrabcwc
ccpXccaC
'6Ippp3pD
ryQi`zy`
 a`s QAC`s  1aE

5pF	qL0 }jsLAB0
l
pIB1`0B2@B3`BB
@67	e{k
`:AE@arj`B2pPe
x31@61a}e
eMRDx3@63e-D@6Dep
@6Xe,oA4@A_5`< 6(R89 4g 1"bcyc
c}A1y
cqbc,A1eK`5B6xoxvD{ky00B7hipPf
j
6
 00@6EbL*d'3Aa 
d63*00	@6C 
xsI300BWb(dp3@6Ab	pk
@6@9Ehah,9Er2`r2bdB8EddB9zEd;BA@	
_  B"  	 
EQC	D	
#?  y q+Bva]`BA` b` DBDSC0A-P`1	E AOC1	Pp#2౼%"`	%`v!B "p#3]Cr
]`15[ICa
_UID DC3
 _STA2+0^^P5Eq_DIS1y,_SRS0C1hy,#Cx,)0d_*p+	+,1/-4.4@0)@e2p+o3,24Q<?63<7979R+;,3 <D=Co?a9$oAp+B,4?DK EKG9 Ip+	J,5KaSOMCSHN9APR+/R,6S[TZVQ9B_XR+Y,7@O[b\b/^b7p#C,7 76p
g8eE2g!CDCE
kF+/C0D02nCDn%k-gA`vCFVzCDl1flvklmnOl4'5H!rD0&1D3
,
rʻD3@D4 Rs5
Ls5qt6 :_REG3 "t(r~D2$rqw2v3D7pp(0D8
 h"!32^!|`|1!|$ l9C{b}3t#|KDA

3w
{A
 p傪`34 i }@B31$s   UDBt
A+._DOSq30
@a !o[^ lCbh@gDD¾ m@QDCB0D7:jGӉ9CSSjf0h{PrrFDRƉjrE0j{hpE1BD8	5h%p
`?{\/if}` E1 #E1 +  fq FC>hipN7Щh``8(pg\/wCCGh(@lD/11",E2
@1 `~6Cl`+g[E3C{h0  UE4
^/uљhijkl~j5E[Kp1	_GPE
	a
e
Gb b`Gf f`y jE6E7rkE{pEA

pwEBC~pD`
/svy(QE8p((i  E9aEE@[L1 @@ EF FQ0P1A23A4A5A27A8 F9 n FAFBpFQFD PFAF C100!101 U02s3s4s5s6s7s8 09ABN10C 0EP1111e12ǐ11111111u7P1@1191AB_INI ^Է11C
N
[CDAEAF
@1201
2
π+456c6
12j128r9
Unknown 
NiMH 
LiIon NAplpl>-{B AРnp1qlE6l t 1`nE6С
ױб$DEB
7$ױ׆e%8!١!@}hAaAаܵ}aiaϠ! 
12020$`B	%ѡRс4"C	Rw0`{{`}aa_12D
[)h`p(4`
csc
  dzir`a[)}aFbsdb/2`cc[CE	AgCg
 1Fp@{`gF?C130hblX0FAaEP'1}1 w16axra
c 
dcbpbҢ7BC`Da`a0s$ְ1Fgb1nQ+I2
+p/
 @~	ip
0?9r2c3d46W ٠)W{@`&{``p5  9R2c c@'f eeexcpecpc)F20rF+6a (p
2o6p
Ҡ#A`134>+(_Q03$
дpq4_ b
(_p
aA
baPvQs05`lPTZ_u5F&6['G&C&TZ3_`!K!6 
;(137
(PR_CPU0+(1_
(2 -%7&?'Z(^-A8)# y" 
w*8
/4W9
A#9)@5`!A *A9B9B9Ex9 _Q1ࣦg-3SN!1622ѱ78A8 71F7415,
{99iRF98i[kOP+C`
?3DpJP+EFA40[ D41pQK{p
 3E
@L2pHEH4340A\_oGL_0
41ИL 3FLaK0c42@0O40144NOLjaKQ@L5 43hi`{j`a}kabSh;ibz146 W
 Y`X`ya
Mp{`bY0bmڱI@4748A5>BYZ a4{^p a
`
`ap_ (0
U^t`japz0]p149wPX[kaa
a
vr$ albfb
 b
vbX
aiRPQ@f`Q5`
arbjt
bep*4A!43

p x`nqaA@`3Чa ]B	^"`z`haob{bp"qCn`yhaj_"` a1z@`{ 23? iaaۡW6hv
`ˠvkE	[Ck6hW70냈aay by cwpabcaepDK4F p^^C150cI*51L46
@52

Gy  154À5-5ry
Qza1 54ⁱBP|5y2 [B!}6e _DDN
COM15r1586
30%" aЈƈ胉8y +aڡ57wWDQDAx+_DIS e=22]570x
AF_SRSG2h
ь97awAe957@
!!0D

xqҁS03Ԍvxobpr/HQ'[MсA   
Aq
_ON_fC@&_OFF ߎv颢P/R0AH`W{5BcQ#ӇC
?牸 *
5&c2mVD *	br?P^5C>ŭ^,EѰ} A
 C*/Oð-[P"Cx?[2[F
 @iF[C:C160PPI61}pI`Q\@62
.Q"WA`Ơ`62d62S H
1 Gxxp@xg"A"x @x%`o0`o _{ Бլo63) Px%cq3EANM
HT0L?e,c6R┎3G
π' *c66567S8#ߤٌ皱ڠ4ȃ6/1xp
ƀ680$kr !AV69
MY69)~*6A p\/0s<C05EH3Ax(g~o`{掰u`C\BN$I$I6D
~tJ AK6Ka @J70671K72
G~ ~ G/@+rAL70
A1\`gQPxYBLA72Q/UMA 72[%35I	R  O"  y45I	R@ @ "[@Y5&I	 
G| G    *U"55I	~a a -f	
Gp p
r r
" &75Ih` ` Gd d "Ѷ[I 78	
" 09
[ӄ0U790ARC$@79w7A&s!QIOw.' ' I[+w   
 u7 IADR   I7D
[7D%E] 0INI%E#,F,-80-80_.q/81,	!320	 C0B&W+
	K`!8 ,y5_S3[u8,!8p(9`!9s9.!9[8!#0DO7b8(89;HTI8&,=S8Cq6>?=;aDAC8aDCFC09C0,8DPö|E_GTM p
;K`o0E@MA<F@M90pC0AB]MNF90m90rODOF
P88FPxF#M |Mk NhcNFi p `p
wN1za:`UyU` bwb
bwzcyib ac Wrr@XrcXuƐ^0BpfcMNabY55QZU{192{bc@t8D:6\g]!{ X  zDBIw
|[$NvCPKF 6\Z8 Q@57p֠k lp
}.C0C4	
# p"!e5eC6fCm7gC8?iC9jCAkCBl5TC

gAQ n
 opAp	pqUIrp6ppTop8pp@[v1sywCwe4^fTou31@	F
ob|D|Jd
d
Primary 
10~ 
LIon 
Hewlett-Packard E/|I}Travel~q{0@
 @ZVp{2F.2@L`!2E	n0E2Eh`/`L%
 ߀J

 
ݤV31ha{96Z@A`!3273`3aa19O6!32ha`Í0hA` &T
_UIED@ #1C@
_BI b KST32RCL\[Gr34'ǔ6#a)pt!rL
ACPI 3~;>_PSR?A`ye
2`33)[P3@GT
)_LID{^7C
91
	/15?@SXـBPN2ˋjO79899NAa@Vk`k`Yh`piaF?aP8P
 a{`
 
ò }a
aòaop`kpa aPA^ aP9@ 9q7 
 19B2dh0

a E ɐ0dB `B^`0dp}
yjZ  0 `R>bU1@Vh)h`JqB`ibbasabcpcau`a@9Crw  i`zC03E
 paq42b`a
b

QDԀNA9FE@IA0iA1`p{A2`A3	!p<`
0 @Ur
` a4ё5PA3ee[dwre  661EpFAILcqҨ_u}UCESH03psA5&A1bҠ2^7bb0,_p44ر8OpxVbJdߠ70U!XV 0Y` YPASSfѡdt9Fw`OA8pA5J`O37ap	
 aY390@3;ؠ2w}a`bb0X0 b ubdE3WDGL
xRU4<SMrJ/NAA T-MP2TAB ;9Kp$[?AC+|Nr2J)lBC 4_c,E=DAD!f )AE CWQAAi*1dؤ{	9 Q&_uk `9D ྤ
KWQ0
FfghiGWSABT
F$9Dipiw܀ OC
COMPAQ|PC[ C0 S0~trReader|GEMPLUS|GPR400|PSCR|cc '%WQt2
BWOSBCi!@a?{30da(`1P03]aZ45 6
`
WMAD`A0ija Z0@_ENFOM@  :  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=h4/~:zH8P̴9ˡc@1b90Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
P#C
2pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&(( K GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
 vH\I@Q`PC ?;Lp <͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9-qÐ
L؀.y.r24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hH" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[ AA JA[#ql[#\_GL_/yh
6ثpjk803A\C0CCh!	l['['qB
?
[CDRE C1B8BEphET BD/ЧC{h
Cp{zhԓت	ЧAED֮9 `[AD1C0F1A23:A45 C6 7 5rC `qC8C7
[39@(An`CAB Z"CCCD`CCUy
	`rh`k`vaF`CEAīC9c da
Jac
`rd b}ybay@a0apaQc1  eraye
	 evepeQ2c uc@dcM
F2Ecpc bpbgC	bdpp apbe)ecQe ffg
fape`pfafgvdueA`b2` gPQ`Ѳ4b pgtAAaggag dMC1D004q`p`c`bQ30˒4`y5@@ЈC050@r `h2h H
bhǠc `rא0Vʹdג
e3Q-adft`f2"u>Qad3uc2ftdg̊ۓ`bm7@1 AC6QA@DAF`D0`aC6
_INID1B54pibhb@2pD2rb
U3j3444bwF@5 wQ
arC00Dabpb> barQ`babuaab֐ `b`uap+_wCRSq0D`fsD5``_STA tb
`}``P
\/q
y@M1D6=D7
G    y 蘿A1Z5E@9=<50N
G. . GN N2c c Ge e2 g g 	Gt t G 2   GppAA GAֲ   	  RC
\/K6C
Q
66	o 	P66p
^^.C13CC14F\_S0_A43

@Q4

5PE
\_PTSphյ21@	h073 7`}` _7=0E5 A

Pɒh
5C12B
 ˠ 93I6F\_WGAK7yAO1CA?0E8 A_ CG0F0q" F,#q! еTZDC'T_Z1_
v(2)W0pq(3B&?%aA9b+3
+"Ba/,cbc/cc+7!)983
 |38~49
 Q
N\'!DG,<
b8n6

o89:o;
1>l:=n1> ;!E"DFE00A1
A2
A`4A4#CpA6cA7'
A8D9GFAA0`35136
ApEB
AŠgC{GP
0~`1DJKEi !KACu
pp
_LKp
_-cM>"J``
JFPi_SrM؀0JGHED
JhEAp
~`Gpi`?9`
~/OGP9rYR=i@Gd/SFP`]rMBEEI`phah!E9i@]pNAb7AFi ` aI667
  ˓i_-pK!D1CR35ࡒa
  )i!bG35t
axa

`bP|9B

bklm om
9
?q
	#r
!
I]ePu3`LC1F0_	F&NYdOmdI1e[p{Ƶ2F`I{b
 t bbwb

aranMpLa/ F!10KAςb!`)a0a7h 0!a8PղaЇpƴ26hy
hII	~pW36b  1Dpbhp ab
`%  O`&<`aW5j4y0y1`hv(3_
⊀b36SkPM@F1
bjh `t`n`x``~fqef
p{tfw|af_ .іtncbb3o}bC&Ȗ{e0b{bFi&
ep
d
MMd_z ndq*meiI) ) yEF	|QCarba[60y2BI
_ON_WCըFFW
s3
dE
:s4
䯮E
s5
dE
~{[F6'F _PR0@HF2["0y73"ø8&4ø75[H(_ALD AsL1S AL2S`AL3S9_AC0r B *1f02e@A3@ PSVzf2SLaPR_CPU0
G`FA QC=hb5S(|jDERDFp!E`#nBp
qB$̃E2́1`#1_TSP
d@ѻC1!TC2aCRTpnTMPFP[G)BcP
3FCB,
3ԧP
qtPG'\_GPE_L025(+B3(A)M{{530
`
9{084584046Q9& A5\a56D_L1345[":C0D8
`̝BB05`>@@. Y?_~K_L211B8
Oz`{0b0PIpa{`
@]aP!b'&`@]C
 a'rh!a@Pajz(B)SSDT3  COMPAQCPQGysr   MSFT N@۰D0;
   ٱ`y U
 S E'
J
1_PD?C{h aFF_PCT 
!FED&_PPC"b504BkpSN`KSS%N@S@O ` Oo "" $O$o%/'')),/,//1. O2o34O6699; O;/>=>?@B/C FoEOHH   x  R     U<ps   d$ $PnPqo  p
Copyright (C) 1997-2000  Intel Corporation
 Base-Code, PXE-2.1 (build 082j) $I $BC$+   @:^   
t2ôu3cUf`F  fa] j j
j
PS^< t	2PC[X] 0
$0<9vP ePFP!ӶfPf>fP@f%ij:64SQ0
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV@Vv C ^@^~p!˷!]0Uf^]2 thP~SwQpRibWZT1
-AX- -B)C)D"*S)ES-:-DI)S+SP-ÜPh)tX
Waiting...   t^

h 0@ 3SfQfRfVv&  &\f?UNDIt?h_2 o
EC4: 3 ROM ID structure was not found. Gs<h{kA4 '45o56is invali7Pj Sj < uf. fGf;sf=_ f3>>=T?>  f
@ &6 +&AfRSfP& fQ3ffJtuہ 3fX[fZNа0CW.;@=s.@=@A6&BԋfP1WfU_j j fIR@RVQ@A&Bv &D6ELPLLPLLPLL
PL
~p=FfP?ЉVE>Ny>N6U?yQWhTw
˃f6UfVQTT
Z cK tl tc" tZKW tQW tHh]Rjh*4099nexpected9loader error.  Status ==  P420: BIOS extend[memory c\469dri=v`\imagK;48: !?6S7;ac segment`ZNV+def.>  u=,$K ݕ43^CO:i;f0G=fp=^f. sLh\PCm  rm^_  AyHr]0r pqqtr*rv&D &L. &;D&s&D&N{@T{BN{H{Pu|J|R&D <Vp<&(Dv
V2}|~=	KLNWj 1z\pU
U  ujvL t  uj@BH FF  R{Xt&t1uf
G HF+F)F[?fSVWB  6	p=q|IfoT     fp_^f[ T^pUf]f_f[fXQ? t83ABgf` |0DPDJt u]D3AA2< f^fZf fXt ]˜= t.. ﾭށ.Гs	N]&}t	џt+{f&} us`.9wf&+f&;EsPMfXRӠwP~=  o
 s@Xr`&f.+| &uf@
Af]r.>pu	. 	PIp<.( s%
1P<Xt/-Press <Esc> to abort&nin0.;zR.1RfW ߀>  $u> PuAMu	> Gu[fZ? qa<V<f>/f . 1. . 20<t8hquZaOpanrequiP DDIM sup gf`  ˂._UzfU fRjfj =@f~ <hfQTRFfu0h;|p{
I; PMM fun}cnumbe`  u)hqE4@al'locR`0I@Pf硩Crgfgffߋf_p.A<h .tf.>@ r
{P  blksize t?_ҁU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j p | !LIENT MAC ADDR:  h     GUID{: DHCP <XEClig:Arch:@00:3#0bs $I5P SKePROXYc
GATEWA MD  BDӰ
Auto-selp[:
 aBOOT ?SERVER)b-->  MTFTP`T l AAed`roxyser?vice d !7replyest ! 4011.  s0`u!7re a@gc6aer MissP. d` addQ BIS bad g`ichecksum  get sign0]1;nfor=mfailfree%vAbo07objp[ authorDS  flagshutdowۮ|b/credg ;integrit `NetworkScancd byo key iok ARP timeoutopenzE\ - F s N57[AccaViolb rece bdomy xunkn3opgre0x!7connp[ix Nopoffers we6e0! pd"!@bf nam7! \:APIm إ֮`ICP7r multicastwhA֮!th"+ _,y-PHYk.-pfigu=rData0-	a'e'EE@MW .setyt!
rrup$too many_ packbs;R+b Media t1`i,cable NBPb;bi-op&q*bas B0+disc1o0bli0,B+CeBQdgu oand/mpq*F Cbt's ]1!Pinb-Lm`bg.@  /-\p
SM/DMICuuiedVP_UP_	T$
`}
p~ u@ːV u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- rZ뾐:: 1LP3 @Z fv?FFW)~!!_o]'Ґb``[b`-^u
hx9@i[FPX`btYacI[b`[`mob```A``=g?	3=1 tw5pZ= }.f   lOm$=q )w-2 tHt-= 7-s HHp!?3pcCV9  >9 t!W JLff99f2uhP99@t{<Ibtyqw^h
JbShRFP }R^PxRF9*9Fr䡸93Mbqwn>YuYb"޳d1J{NMqIH0_ t0_tEVjOhR@^sFP)b9Fu9R 9뮐Cs>\u>p\tsII{L ZrPV`s9^P  VYYpZ+Ҋ*QFVFP+$FVu3^Ã>t3و(3*3(wh2pva E/ Z	u(37f(3@f0{sEy WN뜐WT3]]h96:6P636H3 |3O8tְE뽐X2u}$% pҀĀ FVfF}GFf+pv晋FoV`7u]]f6(K
b	" 9U!cbWFPV^f Xa޸PVr$=NVu^F^pG(X]^p  !G-- vs&iGNЉ^& u*&G!V=0 u6&G"G#7&ХrO  !UqrusSG\ssG|F9 Gf9  fP2 ~UHVm@V\PVKU!S*& P!&(G"G0FFPFF"9G6NfNfQhHT7Ubҷ:T^*&O;~S*\P
u3 @ẋ#G$P@ t
P(G	\"G{(pwY!V;?.3u0V  t&}}?X/OdEb`tV RPV`t
Ȍ 3& _2),bQ\R3*?E3:s!VAơpf1T|1^! -tHHu9ㄸ5B^ѧs1X/dC" GP)ڎbڒ`ڐ٫ ٘ۚۜu ʆܗ `3#¢b& t  ߱ Ood?t6QEЏS3n*^25Cu#."ǰ$=3 =2 =}cse-6 t[KEu(]B4  C\t'۸̳B@P3/LsPyN~ tI4p$fQ 9dtv¡^
~QQ
@G &W26@sޣЮF+$mIfjFPvG*F $KI~ t
! FËFFt#aXPtfאf		 	Q	

~䰃s2pF}
$ 	HZ	PF
x~E^F
%$WqÁTPt% )-GIR&x$G&E

Z D.'B FP|E tL @+;Vr
w;FvF*F3h3HE^K%"QRt PtPtFyڢ0ﾭ Xpy	F	PD
ޱF~ ts(A'u6q WV2!3 2^_2&s( CP:t7H⸀22fftrHuVHu0Hu?`c2:!VRPEK?0]a` V汏HtBrazBVSRPVW tDt@u2^c+v
rD7D0 N& NGP2G  F8F`4 ht3 Kt3Ro3u3zvYY
 Kf2fx3 tL|p!cSc> tG;aHt[-pFIZtJ-
 tE~3 PQ 5FsTF"R1pqR{tZc`S\|p^f3PU~Wu!sT2TT|"XP `YdT7FSvTsTTTUTTTTU
TTTTUT+T6T<TUCTTTTUTTTTF*F ^PIsT9] 젚V 2V -
 t^ ґTFu{>4oh"(CcG			th&C0	Ch. Cf>	 t.sTab FƱAqNAI[u(XcZA([asT]]GOFJ⺐[sTq^^p]1_]	!&@i|ẑ}d twh6*HtPǺ
  /tFA łR{ `YdT~rcF&dToGF>t'^wFzF}>T-GZf% !]IjzM`3}z@UF!^33Hcz&PF[39F|5sTTQ.@f OR. Qf0O蟊88QLh: C$,h:QLGÞPV3H BFA0v`XG< X~߆  o@1:DHLP`5ITX\`rhs_h:uc~
d=PV)= wA.JNl=!Wk-PV&U5D- t-;PV^- t@9vOJQٙ=4PVC^ HtzpNW -PV ?FvOvGzpd?Ìrԏ&Wwx;ȼ&t9G];$$:	r"ZG$hX	 D@D3DߊF* c`ؼ W
ZSб|D<~Ij[~,,D<@C,&?_*b`|&_~-5PV{U-	t- t:ݳ X tq$ u&  u
"?tSO&9Guf& Pu  t؍G{
M*Ä WADDvvv7Vj
 &fXfYffff88 9 7:卧FjPEPe+9hB9ix 0Q1VB	RPAT
ix &nF}sap 2 F=zPx 7u~ t	ƴQ3Q4l4p032'rȎ  ǆr D%މ77ߖ 8Q8**9RȧtS@F t^:uf~tw9GluutApu@q$@1іtr8PfP

21
Qx&KO6Po 7Q7o)9- Dt-guRJt)@F utpuoh)?t֣Ȍ@Y}Pi
PʵO)
@ 뎐.^óAy
3FP`0c$0c3%@. FBDivvt u-FF9F")u32} "
"vN)u{rPV;u2.q?}.iv"t3"!=b=P""phaP%!$"$-%e "#u$)R*&j&?hyd0S{'9&X+5,f#t4d't"u!Hᮇï> zH)l =iFpP1<&̀Xі'` >2	 9;4<`P3<
]߄_*=\0^ >UUHtHti@ < 3(=kR&V>"sĘ3Fh92 蟸;p3퐧K;f!Y 4Wt-MFYWG01oHI3iF$4GPGN`G6xS4I2tB $8;Qo
&$<:D cUF20NZR/XIK2AEV93^Qd'SJ1;~ t3
jU P9^D#1k}aF3򏠔;3	wt1n u
 C Dao~ 7rAprFP`^ V Cu~3*=*qFQ2J  SRPWQ%o*/n0=0Q0޿P!BktJ@\KVpBO0F/8}C}ϣiv ~ĘT$v F~|9G  jO#N; ~ tawWR1PP1N ~fP0G&WI9FVP4ss`c9Аu9ust[~o tH׋F-bovi~ ~á柋؎Fe0RPs=;\u>3t
F} _s	-B`PpV6hbߐ`nѐ21f>&f ]f9thxސ袐h蕓0 9 t@3f1ƹ +uhc0 R09Pa@0 
rh/?0^`l
lfo|
f ءP@{:coh:K߰[6?DmdF 5ߊ 9F~a !uxa !ka !^Q
a 0La ?  0}/^ۋ F~AP0aGg]Ӡn\`ZuQ `PuԭRRpS F9v~!kuH޶ U u1"h+\ tGut1ee=s>t>\rDӭ̐aĹBÐfvK w42
30cǂ ѻ}QaD tP&_GtF,Q@ 8h!%tFlQ (D| ul t!P|~2
GlDp uTRpDxȕxD@րА4nt--ŐEz k*302
f&)f0FFtq҃~ t^%{ 0왣99	 t
^ݴ!u4ru:	0^\4:FFu	W63ļQ| g	*!+4*6JFuH!^3H!n uנ9,3k3 c3߀	 t^Qu
״33? 0ǋVR 0 `> w$ѻV;лA^QA[t}O
f6 A1!VP G)G1Hef&ğ	Jz)`v1t=@p_u&л!3cz
CT f+F^᎟
&F>0^NF#!	9FsA^?	&9u0 	 !u$qŋGR&GPt Patw T'qLpƲP tu t~ t]zq_Tm/hw)
*C (лpU0&F
(Bpz Z yhfv.pq4)(o/&o	
M	u^2sIb(F`VB(vf&0b!l@vf`~^NvVFn
fa
@͊ A  h&$zѳh^V6  u 	2Bd t^ u tfX u	  9 $uy$T u
vs#)@6F**  vD*+ OwrC*@$XPH XQs$h-tF.uw)Q&e.hvz=A*GX`ZF0f		 &C*Xv&ߊ@* F5;Fw57~M$\ P%`(ut)`Q tC*\QrݠR
RNā3\`^4R
4
)
>*?۞6R
;7^C*`&8gP0\%3Ľ5A;v
@6w%FrBDqs
hupZ@?Ht'&+h%\)%qG[iN?Ex)i3+];%Vp*%ȜoN1FrB%}B
%*2hIsPC{6 $ptC7H8uC@@uИ`$ ϐǆ0zITfǆl @ Ɔh$2	&uY Z@X@Jn$DO%= Btw3-`
-,u@,qIW  Wt#)vz- [t- 
tQ`Ğ&8t&0aY
uZ0@)h#ǆ1WEdv}16#d׃`FB#ZrY ZG%
h td @e"8kQSe @fp9ed B*#pR
9FrF
Y$*+ BvߎfPfߥ^@hXfhp 0{VoV3Q#s 
6fPfh  pu})vzz`+0t- P9w3  d#=.t = t \-tv])0# tNAjfhtVuI1k_vxxxGzUPaq=KF{vp=k'0pHS-	t-
-p= K-w- 9t-
t- _Mt- t0tυ0V>u$ {>Ts9 h9>
 tFu&^@ {^f"24@B@=9t3 p2~Sވv3 Tv&8 u f@octeF t  F9PEuE>~A? ~40v3  ;$&%@A`~ t?f( !5  t@J࠲c^@0pa"
'@' 9ǻN J ڡ_63L3z`v'Pt	t(>PM!ht_3h92A98 .bL3 z pjpP ff92uvf u:9u1ʀ&&;w龱 0 f9ӯ&:qtCu|J"u?9󥑥gL30=2 2 >J3D߄FN3 &`toHHt	H_Z(Qu"hdFhlppopݸ; \Џu< Ou	= ` 6dR4 PDxp
 !$N3? 	>"E%+Ht
3gtE9%-  =9`p~L~~ ?? k?œ>2 u09P@&:?h2 >#`{u_u/Ss_YvOt*5<)"uZ=t9ъFf=Ep veR`M !:Y?(3*3oƀyNevڃr1 `p}vi/-#+!v9lSʣv 9A|Y$#&3Σv9l#PQv9!>PM\₩wpp!>4{4$ |!ړQO%
tf[DtЮ:/y	29 3t\6iBuBL35 ir9f뻁> paʫ!r-"E>}2ʇ0S1ӕP3q@2 1k*䊇N tA~u0@2
p:`pvn+2@fj
 f@XfYffffF~nFwF^)FX9Fv	FF;Fs"?m~#v@#F0f+fpPO63H3btyR` :? tH9M}b  qҋF
`3:a`_  O8r E`Ю9f" f0fWFp&HHHFx32N =@3-6.@y|p`~N"%r!!FP(}$N9!Cs%xbAs%9"*18?R  kX ffxHj`yqnڙډN^"wFV;r
w;v:!O6b7& ,@+؋FV@ !35+s4K}t&3~ 
qR6:!tJFV43? ;FfПf E9FK=!>Bp>n]$;FC
/TC@$2E
3!!UVVv0$a=  t)ArZw <Ar<Zw FC:t^P  `O ȠVfpS*Nɯ-0^t 0r 9v "U  WVB
0QRNuwRXRXWA
VLSHT3^_4U7V[Pֺ=~puAtF0SRV
0`FUS"@"Uhp38hV3c,V3X3p+YJZ3@03\3`3Pa_3bbr΀	   l3PAn3 Ipp!h90㒾99po39h9Qik9Al`9%vl2r0Ejd3Fkh3@l Zpgpfff^ˍX3
 bf@eBku	W3 &?r"uwh83  `Hu!,{0V zFV
22##2&w#2#62;u5;+u1{/|P}xx!;Sav%YNu Z3ΨI$@Aq&t"t-}f ,Br  cpf&qro
sadFavV 	b
-   BF ^@i_ 蹙4 F=+F;FwBpn+VM ⏝@'1w	cV0 'FFf>6 tKa;8rBw;6v:>P'F
?+ۑ86 68 
0@&c~t	F~drKВú> u22u r!s;Fu$<ut
f>   upM% Ht P{`S69F}8Nl$`~ t*fۡp&^&G&t0&9&9WF?%  F0wu9FP-utլ r !ᘃ~ ӀkRk9ql9q@m99~ u-"m@ _=t1an]
P' t7pԉF^(Яt#9FR9F?Wq Yb#x	` 'ҵ BѵuF9Fn!nF;F@A`APި9w
F=9FO+9<7!cn[	R? v@!'Ɩ̮x@A
=6~vk^9u9ukFP!U=qOYAs
 uh0h_? yC0ӟƇO Lh9c o9`9`}
90h9
 fPݢS3&R39ݢ`29~@/9@j4kG@}9G
Pϙ`U	FUp::"ԝ!kFK2s3׶{k9U]	 2>Yߝ@$f
Y= u^ 2zE c
= @
u`
 ufx9u5cƜaڑ  {ߓcޠp+Rfq@@/! Sbp=  qȽQg`Ӥc`h:aĚ3M099h.:  [΀tOÁ! @b m  j@ 3`hpҍFPj9&_׃ wUKGthQQQFu6~Ku+~Tu%~ u@a :~Bu~Pu
 A
pBtްE8?Qz   ǆ~^`x.~p,p F5B!aSQ @@r  ;؋sY[`
0KFΰ0Fػl֣R@i{lң97F4KPUbPUaґ(`hFFV=6SFF＃~F - FFF@A<ċFFFFPMF&uFQRQ0 c߉FF KF$"h~VF$byFPơ%
\(QQ .&NXf* PWQRU> @ c> j>]a us>@ ul>L |i<b<w[>* L &D F +ȋѽ  ( B ?V6H ^;s# ;3<7ԡ( ]ZY_ÐB ~W::_f`.9>9tJ.B:0 c.;;0At9а r   fa.>*N t&.(N! 9r & ӄt"QfL(N u8Pwh3Ɏظ O&.(N&G.*N[i Y YSQ3ێËȋ^$OtFPQPhfPQt~ Y[ Gf.(NI f.`O BPQRTvMM˃ӈ N  .,NNX tZYXYZ./",N[
Z\V3߭`^]t`
  aP5aYŐ#a `t2aaW`b  _^]Q  2sYÀ>[
 u[
PZ
GXw!
PX
j5?T
V
j
X
 _   > nuV+T
mĉVfTm
sfpf  brpmn+9Vwrw1)jsm댐Ҁ>
 tZF ȓ@xhl* %ڋ[^U9pO3zP m yyNAhUQpPVCw7$
F 8Ft)F ~ twPP$~$* g^
+@2oҊF 
B}Ra$Tah?	-t-,tc
PWuV䳚1N߆ ^U~&&Q#2#222##;u;u3FsްUf9 u"99t"; u;`uo^_BvVR큊;Ftiu79L24"99`t4hPt͡u" `fSfQfR?f``f;sf;wf;rvОs@fZfYf[] SQrPP Y[ PS [b`@2Ft%&?	u
h*/FAk0 $  P/ : .I'jqa*䁤׃b+ l0>q`pa&GfԮ\ԮR 
ԮCԮ9*Ԯ ۔Ԯ	
䔲
ДAu 2Ru	s22Zhû5PRFZXPRZXvP
0d F.N`60)v2GÀpB6+^BF+2`6 @tHH  \^
~@t\
f`
fd
-DYk%0d
 @hptd
37d
+p~p2f
9uof>`|i4 =ȡh
`6f`
fj
+j
l
f6j
2+p 
d
)땫R ~ Ã>  p`Ƒ|!/~unV+ɉNFu3^f&pwwsW	&O
N`0FF@&9wvahV `6!9GtSQ
u.VvYpthn
V	p*n

Ѓ
P0rbÌw VfW4ˋf TV0 +N uf3lf3 VfƉFfFfF /-lVVvap^^~7320>f_f^]2OfCORPfEDOMf - 11'f1ufuf=23AIt
f=46AIp@Z !^_O`D ?tFqQsnq.V
QFtSFF&nP*S#~ ~N	 xaـ}N1V㑲kWVg~cWVF
tyWxys}>F&%G<ar<zw, arzw :wrg p-0`Sp0lGGWwGg
oF GFGWFGOG2Cuԉ[3![[2ҹ G;tqwGg
ogwww_ϒ3FpV*&'* û@ &l &n f%`Pf@S`#f#f#f#f#f#f#fXS  & [Ìq`WVsS3 lP6}G@ڃ ,V lR&&
V`6N@23a@+p8)P)V1{upf
.r;Vwr;FvN3ҖOu؃ [^_aN
@)u	*aS)f
)yRk$0~<9vFPSW ۋSR3.:uJGuZRƀt%@u0t
O t hr< u	ZXCu33_[ö΀Z^_SM_h^v_DMIw_ ;0P;}^a$PnP=@^M_SYSID_Pv tE'od@@S>NtPt䤊!D+t۲  `EFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}     {     UX(l   @ ` d$ UNDI  N MdPCIR$I E      ?X b S$PnP ]ԁo!
Broadcom NetXtreme Ethernet Boot Agent v6.2.11Copyright (C) 2000-
3 Corporation	199710 IntelAll R
s reserved.
   PXE-	 (build 082)h	Remote Progroam L erf	wMBAf	 Sl 0')Pps Ctrl-S to Ernfigus Menu ..  
t2ôu3Uf`F  fa] j j
ܿj
!PS^< t	2PC[X] !$0<9vPp##_P%%FPuq'%fPf@'fP!)fu#(j:6)*SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV1Vv13v@22^1^~34]0Uf^]2 t`h+  dh+ !VP@ ء .;uXuX.6>| . <^SQW  :_Y[QSH .> t"?u.uXH S2.{r*= eu 4= fB  `BgB0  .9u
 :>l :pEtIu[YPF??Fu DFG  B!WSR..>f&=u#&uFPj`hfJ
˃Ŀ u D  S3=_Su}M_u22]r"[Cu[V[}#|OfSf]S_fS.= t#It2EQuQGGRG؀}|_E$tCBZ[_]0V?ԀG- 1h  fPh @XO@X"{p@X%tCXm@X f#Y_SQfRWVsVf.> t.@   ځ>  Utt r rD] h1
PH ?X%
EC1: Base-code ROM ID structure was nfound.   PQr댊  t	|Sfj j H"k>  t;sfpJBC$uErPj Wg!h뛯ێE]]>h RJiǰ`  .]6I6nnnj Ph#J}
0LZpLt'hDRH3a+XC_() ==    rpSho%M0F: Exiting1cP6 X^_fZY[tVfX1k, ~z. f"{0{sVt"{{B}pf
:&6 +&@fRSfP& f03ffJtuہ 3fX[fsZWЀ.z{:6&`ԋ~(SfWfUj j ggRV{캐:&`.6E.{q.q.q.eq
"{ {0Q{F|(V|FV}F6Usp{IW0qf6U_fV@1qpLk	 t	 t`Ƞ]
p`WPOa20bIOS extended m ry c 
 error.b6:driv image is ?invaliea8: !qwcd@<bsegm0	7;9:NV+ߛ\] uXP] u
h
If @}ӎF.3 wF"v Ԥ5Ria3bC?c)f^f" sDh,P?xe/  AHsR#0trvf&D FO&D@1@BU@H@PJR&DjVg&(DovB"	ǃ/OcWj 0&\@q
Q\ f3fp  
Wh86 u96} t2 :L ` N b 6EP6]
 6u]fS˶R(rf	fXfZ  Y0I!jUuJ q$!8uv ˃uj@PH F FRuvXtutf"G HF +F )F[fSVWFr  6Se qPfTpm 0  f؝_^f[^@q?f]f_f[yY8~Tf@ M  ЁJt u`~@tV%d%{fqfPNˀ?א0	= t.. oﾭށ.s	IN]&}t	Qt+{f&} us(.pm9wf&+f&;EsfXRSw`=  
 s@r(&/f.+!uf@؁If]k3e_fP] tfXDt0~1F޳, \^{PG3. 󿫎G3 0֐Eap_ pvP]0  u	r apRgѴ.w 1%_s
r  J _:espCup~&<t.;60 rr ºXr~6< upwG&D
p  &sL@&@U " G1(*Q0@82:@Xʺرt V,r{P	˒	G 
 
*.ܒT
 *2$
=	@p?pS yf[]3fZ>tOfX20G
W~PQhf8.f8hp~ ` 9f}` !f~U8$!!Hd !`  1.؁±7/fpof8u ff# Hp%EC f0
r!fqu)*.	Itff!u f -)~R,pf  ~.0q~11 n /.pD00Ub211 |W11G1 ]0@A1E11 6`ff9!9fP0%ps&%Рq!G!W1z W	P۸ Q!&!  V@" H G#$!}SA!<Q23!fZ@1C@ oBu$!SF D3ES踿 rR[ I !&1EFA&}@" &f n@"&LMfn._  [;!V swfLHKU&LqMM7UN NVA&zV@Qf Ma= f'DVPT ufdf?Iu0;xWEV3  CEeR (Q xAM\WAX08t/f<DF[@J^G Bʆ\3A.@ S]H^W9fSx	fOc d/7d|e0f/qd3|-p V%<D=ݾpRB0>:?F6LIR@/u0/&dNi/FMOL@kdOUR, fItP^á/`Y%ttu@S  fP x @ֶV2P9fsb &czuU t!@ J pۊl }:~t7 fXw+  R``f
@݀úfffZeP#fXтSQ~~8tYOPVPLDr:?f;taYZr`XPH X3. .P #.Ao.pPֿ	Pfj .( SXf% L[A;m  l]Broadcom NetXtreme Ethernet Bo@AgP v6.2.11
Cright (C) 2000-3 6Corporation
All rs reserve MBA0nfigu Menu   <Esc>BCtrl-F6QLeft/R<Up/DownF4}> QuitBlink LEDsChange ValueFieldSave Th`opB`nselectableA  ӣߦ?_Protocol `e}bExecuBEnvironma()   R@teagram LP (RPL) strapf (BOOTP >SBv    OdjS"Type  Au?to DetBS(Ip18hI9z8x    Hide SetuRmpt  Dis@En  $>e wheqdisplayed during ROM initializo 02&Key&!ok"S@"B  k@s in-v@ tcʗ_u xƉ1BannMessaT_imeou`10Q  2   345678910ϗ|g  Non4  *7DQ^kxxd    LSpeedӸNegF10Mbps HalfFu )( "2BRb"rXy`.-BWaOn LANAz``& yCp)ff<f5 Pv[OuIu QWhRf3& tହ# X@E[.0_W <.p..T>T u
fUPf]T`dKu
' m<mf0fauWޒ*E,=
u l%4=(  t >511nq+  .fH R2 3m
E2  u
`P@_WSQؑ@xt9f% 0\00::CfEP`E`*%>
 tPv6_f!P5DB@FnSjD
@> u
>sUBB}CfEP-
 `D/:?XAPYfr:$AEY[_Uq 3KtRMtpPtHt.ct>   =} 뺳s }h } t=} u7} uEEHEE B""#@;Ev3#& b_.20uUCRVUmUPXU'um
>@]^ZQP>=; ,uXYWQU+R=m uUZd,]Y_PRR .ZXQR	 xZR {A1 m$2r1 [ ZYQR 2Of$4r14O#4 4x6R2X7_8SQ  Y[P< FXô
PSQU߸  *>V]Y[XUP3>F 
tEA;]PQS >R p?&S?P[YXw ; <ް=RU @; 
<Pp:]Z(*q3ɺO ;f`@  `& \o:BC!="%)1.)BbHL7RZRZL0N>S[F3faVSfQ ۻ@?_SM_ts OvQj S ;ARqSЀwrgrafGWO}QQ Yuf= 0wPmXP,g8 tIt#gfXhg Yf@fg@tge f&=$PnPuW32&C&:]u
uB[}
 t7j &uSj`&]
[@#^eU_3ۿtҎXCPRfW ߀>  $u> Pu~1Mu	>dGuf` bpBb A!SS< uf> sf_ 	Qb߸f t;h_&rfY
 -E07:  PCI BIOS callԢuppt!.i	iuM.;D umgn4 toh,'Uk1: UnFmlDevices! h`'ڊP]Uk4: Erroradl;space. f3ffDEFGHS]m
T^Bus =@Ssr{Funcq{QW '_Y1`P϶sЇ`Gf~f_
D	 MOf~/b8{rфAbЉPh'.Ph'4Ph'2PfX[f3S.z o0F@oPֈuֈuֈ.>t B@V .[j  wP Xu
U |U.k  >.VfTSAFu u
.둍.>t'h p }pД`hqPfR. .@2 <t@h)PH XUk6: Oc1requirDDIM5m. e"  fQ  f.Wj_fjf.ffPjs2*?fQ˃Au0hR*ex
InvrMM f|numberw u_&h*fEPkloceu. f`df	Vfrgfgf@f_1f.> "ك0t=t	 t` b 3fd f.] d f o   $ `h  0S.w(%tf0 r. K ѝѝUU *
 V4r33 x ZZ j Z:P. `ѝ  `  p, ͠( 0   СѝН
t < @7!. <W&@R'< $0 44 <$ $ $!8WW004   '0 < h`hb B4`ǯ @cP$ <_p"xtȀo c4 ȯQ0!<" B0 $ CBD P> Pe̼04Db8DcDdrxȡȈ#R/t$Əƒ  U<Uc4  pêU<U ʴ CyPaa  G! 0	 !(  hwcpCR $* @̡Ppax+C ؀<P0~Pڃ @_DDcD0$ptH0ΡB00 B$ B,@<$%  8\dc0\p`!@ѝ c2B0ۡaڰѝ!!({<0!0  È)
-Ŋ10B4 0 7<@u Ȕ4ό ?` c$!ܠݹPa%!HĪҒٌp ë#!p
cc@ !p!H@D )p )%hd% D E FPG; J Kң0(   k a̷Bg Н§<0a̸4ks@p0
 
 b <1& 2&- hp 2q 2PR "tap $
 @P   "$~`
 B,8  @hsН`dTB"vtB0B3 ˠtamMPƐq(Pspѝ`U :0 S
phpPqґ8Š0! @B4 {c4b`<pc˜p\c ] Ƞ<V0h  <$ ~ȴw$ ˪4춲P b8, c,%pڡ% Ȅ  0p% 
$apΗ ȡ/ h
Ǡ(˯\
`)>cȿ"\$B  R0  *'-0ai!0!PŲ! ơѝh\qb_d &a	t`p  +B0`4t 1Ɛ 0 
҂eaE|88#: :;a| 6R%!ƥi 
(!ڥ1eوܑΓ;<1#P ݡoPB5
Lb 3#$p$& J Le=90ALd%c $ b pˢڼ$! L0A1 Ŭ0!$p lXbMTL%vt0,U,4U,\d'p E@ը̡0A%2XȧUΰV VROb$p  RͰ`@AʈKo! @0a & }D "0` @T @4I@aaaa4 aaa *a@ aaba40`a0`) 4paajbНj 4pa # &j
pa`8"ӎp(a̬  0%b xҠ,łAM,0p(amaEp0qQ(<"ưc$  b <Xp ]b4 ]d'$(EpW<%0x p 2`2^T<b?8<c!(`<<bA0 J]$}p{  rq70}0pv! ֡ar!wnG4!00 !  4 !@( P$8 !  <p,  T
3NRdCaOpҁ'X0W<Ae@ф4a!'ed+ qD`OB!ߡ
tNp $c(aB,#$ <$bҌ8< R6 _<sP,g! `~. 2 A<0B4% <e&!'!& 42&dpʰea!0 8< 4rR씀^s!ʥ*a%X>ȴg
pâ.0(a8@8&e&^ B4㘁rQe
0 N*tشuВ1&!  %aei2V
5p᛭(G $#)i:. 0a <bȕ 0m((8@ՄB4(  PI0i9 ãqa*`C
tpáU 3c @տ`` H@4HPpL0HD@<080@1a˥%3!&0<@"!'iŀeġᘡN$}' <<$pps6G4pPqP{16!%5!eh`Q u͐`C:a"&SB,o `!נ,#=>  Rae .@ET!йt!  la^ <a
0%
a(1ڡDa()t! &d:2q"2pCaO.ạ"20!!"_c"2aa!&! !'c@$!  ` Ï`PGX/rD tƢt
aa_H :}p/!?` !@  `B@`du- 'c[!p1!3 pppp
  b0"  baaա` 
 )`]@<OO 
!p")!   Õp /b,N@xEP?'!" "rP$@t  p0< č%ʠu  :0	
p @0!kaAP$g	  Í" o
"2!'e
p #~0CqB,cи
a	
<J5! ȍ$$$@|a4%@
$8a^ @c0%8 $oH o H"R$$0&°o%0$$(H(zpJ$  ! q JRo! źíp $JQPc!^	
 ÑpMo! H)	4P!
P!CpJ!"D $d tá	z Ò!!Lq < ̍@J5	)5544
5;P4

! ˕$`B\c0 %1$PC@Í%PB$HI"Α P?2H#$@( 0% %@m!C48 $0ĝ!BS2pA%0 $h 6a6 J%h2!x°ä0!V!B@x!, ʐW˥0ap 5a Do c4a	!%! K$N!",<t*j
r,w@.ga,!aIH)
a! GDR)
t*
	F@a	a,5!a4td_wfv_vr11.1  0.rDwfrevitatafrrEltebifknLrrdwfinIvita_whgotutxp\p\ 80]@q]W d]]]h ^W \p_p_|_it_ata DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:@downlo{adeed

fSearching for RPL Server ...  Abort0iBCM570X Foun!ibjERVER NODEg

Transferrid`X fromRjsj0hne0i eniControl to program @  :   /-\|dt tttttWS ˌt&  ˍ  !PXEX8X{XMcMXI|}x0yNV+,rx{@p|ZfUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
ux fXf^f_fZfYf[f].>  uy
 w` Є afv
Phv.6 j  fUf҄g]g}Bweur`Sf&؎0fUcSІ f]Qfp汎&pRu _qf⒂ڃ> tj ЂSf. ff f3. 3h f& f& []áj ӚR9h uf. ?fh ` PV@ g&5+g&r^ tw Θ3Sߙ[wIePoȞfXVF=PVu NVf. Ђf ]ϝ    . . SR[.9u r   Z[AVSvGfD[^]f`Є > t;s u.$%tа _fa  t-. .>pt!  r ӄt"Qf 8Pwh3Ɏظ&.&G. [i Y3YÜSQ3ێËptFqh9wtY[Лր7Hpо@|3PQR@v0q˃ӈp 0X tZYX"
 S҄|ONQ+73!XuVV66N^VbON3txZnU[? V=OFc	5Z  cf~ Г   u^&ꐋFayFaBCB{T뽸7u5ߙ{Bq{g]SI?E5+!= tw#=
 w@. 
= tw#- dHinsxF+= t_w-pv{-pHt-p1݉~@ۃ>G tq hD2VZ^&GFPF0!!!!
F߂D<b?KGu0f3d!FFdrYFF~q
ubrz!GKT>oFu @B \? >F	B
P4 G!OFD  % F@oPPPP YF"&9Gw1^;>AZ	tb%>F*Ȑ`FDf+fF!GNR1"ޯ&
lXFF^FVw"	  V D^uRptu?LB
FVFt.
;Fu;Vt 
u; ^!E?FÎ 	~  u	PPX	F  Y=F~'}*f0fP <o	!N&#o f#t6$o
fj$	&u&PF>\QOfNPG F^F@0L `.t.,`Nc%P&~}-^v&F&b%1d0|xb% 1153 *HtH|pH~I	P` FF^,/ftpvQUV@8Fb:c%57P&FQv:Q9f&pB=&@
V 1`=2:@
:>3?뻐PG.fGA|!-FG0G2A4G6A<AfG"fG8,' G&AA
qz4FN+=33C"be		?X
*U/HSF	PVC B"RJFvP1ވ"FL|DDGHf JA|w'ar	O#ubV!ǐ	 !G#[M#[E],!pJ*F\ Q@_"g_RաD\.
E\0DGтqbGfc
fcfcTXDhQRv i	Ђ4B^~$$&G	#Um
#mgO@kGpp_kG_ʴr_Ѵr(Ҵr
a_0\pp
ppTXтF `CQfiga_d 3P[0\sXPwFIt!3$[PFR"L9&FV;F  p!(  F!@Ht- r0w!$&[~p琰p>8F_0*a%Jc _!F#F#V{&G$fPh8&[4_'!m>@t
zk` P!P& }pґPd
#k`[eأhG\"-$t@-@^1:v6
*&oF] A`.u+`.wu$`.uØ2 \R"F@F b!\d2?&tbn%~- t- t齇}ts^E/
u!$[ $`1F~F%%5F~}1!QQ|F6v
G\fo<'89Gu9Wt ҇VвfF#F#Vp!jÐxfpfP)!fhfj҇!$#ČB5pËMu2;òXPSV@޲0NM9u2PGÑv@ t|`fGPXpa1S^O|QP@PRPx10:0ÑxB 0 0UxRP u @˨*t |S4+W4ïŔƔ{!4Ą4bS;W οFV!Aw w0V0L^fhѠ7cFfjNE1@jEC G؉FGh^@raD0+DpD  sG_7HOA΃#GPfF -#f~ t\`Ͱl%CM2F2VppaqQ+f~
ttMt
mu
pƇ<Љ$,<=(u up+p`F<nta∇ 111ဿptqt@' Ǉ2P|1efj  YQC"Fн 1j% pCqTTv,eK$oFX%0 +- t&Ѐ|aa {t<V%FF@t.q/At"= @YΤAt>At?%? V`<RJ% А	F/	V"A@k,Rp~p$-Mp
 }p &{t`v>@ /@quL/Nf1j
/
1_NBmڇ@/ub^TU
 &k.Aݠ8 s1P=u܁u1%#tu- ۸Dj  ` 8jF+ҊԊ*Ϊr@R &xQ
p		~kǇ5 AǠ!9!Ƈ;$-@ `uP)a\-  tW- tR-0 ~7 tExfb*5!! AA""  NR#f>b  o  sI(	` `+; Ƈ+{=a+뼐/+u&& ~𠑊F /5&Q1u0r!u 3T`ӉT@40Pjt@00~t	2 4 8+ Ƈ4c 軔"	tf- uOh @_h 1@hEf@1<m@o
P> B{?h@r@>pth 	@)tuBuqC CP3wĊQ*󇠓'qF2*'VGG pG3LL3LL3LL3LL3LLD`*B$v̇ሇsR]ቇ SS Ǉ "dK fThUjTlUnTpRWrSSz xSS~ |SS SS Ttv~>@*
f	 up]Nf}ph@  u^0xP'p	HHǇ UǇ Ua"s&F u.0SgRPcG:0t`a0g`̾  t kQkÎDlll*ll܂lQk {    (`k`{WoGuGpzA|   $q^'RpǉW`kpFs~tRt Qq@bBr`6QqƇtqT @aaq9Pv(kD<G ͋q ߀`Bl@	C#ǐfv+@pyoGv)!{\IG
  ck}"c%ApP@XPP s`k  xQSVǨ6h@p1 t}  ? t	"%5j6 ``dibig%]0u	ǇT +cVcT /䁋8.BafFPs@V~R?0R!" *ŕЮŕPŕj u5 vG]Q\ u!h
5?v'5 ;5@=v#6@v t".Z;p_6l=s/ t"5 u#S\-"
 "{54 $fj@Dw0 ]0`040
8;5pQp    ,0x0 \n0 Ҭd0˸ ZQt"P$FwTp8Q7Xp"`@\p0Hp²hphf/P,  t*i5 ƌY`A.@ 1 еոе^C еqO9q"HS3r
zӌ;`tw*ոjc5лRW22t3"*qL*튏`ƪƣ$Ǥ$ǥ"%vPm8`HҸ<`H@ &@d`H y@ʁc l@ _0HUUHP>"d<4h 4lW4p0Hz4x{C|нԀ ^Ԅ$ot(з8Эw<П0ЕD[4Ї`@U@z@DЅm0Ѝ
0JЍy@ 46T #0U$5khf9Pf_N	6eP?Ԥ햽#@yNP6(=:!d5LЩʡ;*_d H/i(̀Ѝ8#KA`f⭺ - p##P`\#?t\spo\\`H쓋5XIX(aoXh`H1ΥP`Hao-U56`H|a
r$bЈ2\C#5𐾲5p0/u50ds^ a9Gu9W;uڂ~zV vc@v_9 u69Pu1Azf`uf0ffsws9@u9PtCzt` a1F~/^Pjxo; 31/GW$aD3CSA;RPztbtbq3@d 1j  PSV%7؋GFF 3؃
HpF(ce-pyVSFFwyQ@x^
vpgD@{f)!Gpy p{q!w@>f@0@h&@s'](@P xF^GW`NA#y F+!9Ww r0"WOPz%Wrb%uV_Ґ?VPz+;Fu;V7`FV8"4w4] B455U5645556s,1@zq-bFp3AxF}F=MRPFYP9btaqujf>+,96"$q ~ #(  R HfZyFtfpEEpEEfFЈNf`]kpEG`EqFEv `^ҋVeP@RFyyyFXN^ҁ@ FVڊF$F$`Fހff  Nf%
vށ 	B?	RF;L9>bv0Sfr;pASp
}4LcՠdC@SVsPqD^^ &yf~'  s[/uL.\9]!I`qjK`6>e`t`bF~skF|F"{vP '>0#@0$!.Pt<ý`u`!@'@mQ^[t!u -b-dC9A	^nu sn;4ýg2^ʋGzW|G~QgOr$WFV1zf9F9xBt_-V/72̉V΍FА+TVs1UFVsn*v P6Qw^	+ k tsk E!`- GGGPsp#vDGpfQGra;vu-$lqw:B;r狇5o𔴄
P'zC}wGWnq򸄠pCnSpRâ^1P#
`#wFf0zvo\PRɀ߀#t"u; tt
KN5Pm	`0708 DRtIFt)0tFt0 7t10 *#㘚ޠ0 e^X0tG
1W2\ﰟpR!qU죍t
Q[r=SF쀓юoPm@u/ȏ#!(2Fu@p^h 'jh0#j sBa߳hUSh2vCI|Ch UOrh P$Ce"(0- t	-  ?hu
RBhh5P(Yh 	 3_
h ,%V=(u# u)4^芇<2FF칊𿰿FB&<6	9!1v, Pf !0¹fv~! ËSVr! hz!@A \! @ P!!^@D !@00 3ѐaapu- = w.|55 5,585D5V55 t!v3'Q@`}!~uw	h ⴱs=U;j.Pᴢtua u_jq[Q&Ǐu6t
0
c'F~' }AbtܐQ&$A= u8
 ܐ tB¾`F9oF~rQ&GA!T V!EfNF%@ N!( `
p`fj}B pub Ea duSMʚ;dʿ= wč7P7667AP0 *Vp≱v{  8fh[ +.Azfj
aO0%1)B/@4P
@	N2ePLPiܯ[\CD ur\rHAٱ; v N0PQD\& ȠRPxS۸@,  հ@t2SF~|QmCfj @p2.fhTveK
P@۰Ept`	Iwt= pwpa\BBpDtfhQ7۸(ì`	0ϰ W@w=i$u` 	퐳@ 0Kt7`	To_h a3 dsĀu粼0 oPtn Z8v 
@8 se	N=ut=	b

0KT ^&ptbpuDWPٸ `$ $2V
fjp  &Cp& $qP7V8`pD2fc+$> tV΂ )
L~d}r)\%$@tݱ,u΁C<`;t-*ȋъĊ֊n*ɋVԊրCC*j P\
{F3`
~+Fu. {!u 5t逐  P  Fq @47T7F;*qh{JG3 [~_ {=@ @r^&0fP=
&GY #==U=>?==> 3?FWSV  ==C 5S:Cנ𱁶CD{
ڈsDG&9u&9oWuCvR;~Gj{:fFk0vwF0\*FV(׿ a=@ PN Tb
oh\,C*!DֹG*$Wt\u:PSVpZ_7F~}+F%fFtfv d@}9F}v 1F1)뭳P%Bm
qd \sNr,u3QXp um<L	 
 FF@}NP[ 
Pi t^(7	zpj֛0Plh@vjlw`hh snh ®hajoR0\Z 
ylhlAcAnihqAcptBu0 ffp_x^9 u@]yy 󄴡! j}ph@qoh|`^`bi;rjstS_xy'laP~5|h怆vt iP{!F~PipqS]qt5rׅ?qad~}TȀ `;qŃXؠ
pu٦Pp獲h pAcPCp7lt Ung0tj[^=uD $EF嘦G嘧H嘨򠘄 !StyޤTtn]{tc^tXmtM
tBt7t,t!ޤtt!
MuÐ2lV`fRaf% @R0gUdG>2FG pË9Gu" Z?@+w/K2 aP7@u`OG"aG@uuGN20KgvѰ1 !3<}O0P@q2"0KtWӯa_G\^fGt ]0bOt[6X P0G
^`9_I#+U
о> fGx0˽뜐^GtWvPb:8Sst2"0t(r}҈F@ȞtrEfh `
|QVSƇmf+fqǇ  >Gs Pdf#hj#lV[n#prqvtqwƇb͈q8,t-
 +'%<&0R*k>0:P0ٯ p`Q Q {Q t`RH= wSpF F,F4F<FDFLuFRx*۠#d40*99W$rLw9G"vEW&O1i  p GǽGPd  i^ _p ё Wxp 뤉VҊ'ߗ rOw9pvGÎ 8G &Y8lC"W$xAf0YQ4O  7P@:u dVF+F<: y<Puӿ;Ftb~ P@  l &gn rB\/f0*+Qḵ'`̱@BA7N1ð\9Fv2`NYf3ff>Ь2f6>QNX ]/DBfh  4t#f Mϳ/Oc	2ff
耊fP fP ff[f ]W<O_]:2C@@QRN;ssZYX]1 	Vff½p
&6 +&s	X	S[	[P6aZ  ]F| f^fbFfd!hF jn gVF ȲGAP:(Y0NV)D&!=G DGh4GG@7G"GpׂDP:	0I^*船>F*A:P:) 1%t"h"'$BG% hg(svވM_ @`+wF~orؠpX$Pq P:h.(ptf.yGD>2G{xM#G T2T2
yT2sT2$h@ 3 P:h`À>p"u+0 $Q"Pj
 .Gtf 

YG*HtHHt7K>G}<GU9!9]
<GwV1G!8H8"0N#FqpxP)c	o
u!C	҈CX	aG@WB0ahu?^p0&GM%H@F |W 
D4$CB#/E!vnPPR	PXTÇ0fP <wCP2L_ 0Y-~'|FM
fj-NRuu`bPv#ͷG"fWG0V4V<讁͋G"0W8yk,p*V
Xހ&Ѕ !aG @PS  GQCGQC]GQE QQE_@ B_W  0_W	@ߺ _!W#_%
Rc _'W)1`u +@
 f-W/T,#+@1-|@ߺ 貃f7W9-P_;( 虃f<W>$ 轇f@WBh4GhD-|`!NfLGBfN 6xf*@R eiBSfXBZ PhhIPd gú[R\] )[G05^^5_ѫ1`Pb#za#zaGߋG"G/Wbw#zbIe#zdJ#zeG#ze,#zf)#zg/i @PzjHkhlmoRpq}qrYtWtAu=ºU# !]F^^&߇}^-^?a׀ Y`QGЕG1F=C;$Ht	HH~: W	=@  W
t=WtueNu	2p#  Q"sCp}-ufช@")N t݀N뤡#GI}0t0rQG<)!phxrb ,~xG1Ihqf=:w   uЕG tGWn *G,pn@t)GWRعN.G0Gf"-`0*GfР*G%`F ptP+*G0@)h`
@k8t1`hj
0G
h]
@0{

10 wARXLPD+CC& `_ |pRVFse^&9G,~_q&x2 ~Gef&p.fvfċ@2
 ÜX)FIoDp D PD	TP˂Dû!G̲\pKKQ]YPfP44b+0ԡIPDFfp 8vYh	`ч0#9 V<Zʠ}q2?_	>wD uwDvD/tD B;ޣtDvBpDωrDAtDV>uwV+pDpVfpD@sf/ 0P+9Vw[rPw )U[F-F8 ,Fqt`$* 	}	<u!ĊfT!V ȋ ֊n* ]VԊwu		-t?-,uB	  Adapter - BCM570x NetXtreme Family B57hHardwareDriverMLID do
  #""`X  0	 Z   		  
	 ih
 O p	

`gapphi  Rں  ZWPPPXXXEP"[[0[[`\*[w\Z|\\/\`\\!\"\)\$\Z\K]E]/]Q]]]`+]+][U>Z4 \+&Uu[p 	X
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+.+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+ۉD 'p+DuP XÎ\.Et߹. 䫋ǃPG*_G,_.O7Huù@fR.X tXu跩 &glPgnP7 ñ..Y.ZYr0`7Gÿ6Z P(7t&&ߋTW0'L+`$`34< .:'uOu让.3ZY+.:<uuL
Lt\
DPX B~u< $s"UX+Ұ.:4Zt+EZnZ]8  Q(Y :OΌOWti&7`:& KD$V ^uY&?,Y AE"u.oY!P(YYV迟^EU*QuMZYcQ XPCu.4ZeZ`]Q".>uSPu;YPP5PQWu(go<Z<5ZD,ث+|t#@3X`6X~0`<rg3.X.X &u&D=vV pY3M .nW&`\9##At2Z.9Yu.9Yu.9Yt@RY.XrF;wrZtItJYE ]'XD&D tz}a@Mt] ss.Ub@_YQ&|uY0GdE
XEXED)72Z Y@Yf<w0ZX
Dxt.X;wŉ5EEEU.>XtE  m. ^M
u+P.XE{PXEnEn
EP
ZE.;YuYuJ&Dqqq3&L,p/&W`2&l &T*:M Vt
+;rs*X.X3Ã
Ëŋ?+Ht`3iu&0.ٿ]2Z+\2r&/`2Ius*\`  KBPUSQRW"$_ZYo[]X1GD*'5Z+tZ,T+ێÊ&SX&G[úY|w! Lr	t+u0+YTLʉLuIuËDDV返^\ uAD<w<XøZøYø0YWVQX/ Y.Y1ZюююZY^_PS [X FFt%&?	u
h?p&FAЀ? uށ΁?!ߴ{u@2`QR 3ɺO>3} V
Ftf?~ t@Ѐ  F&VˀRPWV~NV^_r{~@a1WVS3}GVڃ؀_VF
4
V Np3@F8@PVٱuf
r;Vwr;FvN3ҖOu؃? [^_]SpߋN
@u	Sf{
[pۑ/Cȋ^զWۂ/J^r$00<9vF
!@/O oϻ/O o¯/O oʏ˯/O oӏԯ/O o܏ݯ/O o/O o/O o    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6         	 _BM "v }( <  > _   H)?_! B 6(r&u$~u"u
p0ܾ0pp`


@ zp`Z`%B	 
*  ΁@ 5YA"a$20@a! H͚g$1&0R1!%4@tA2(
P
PĀ	!"NQ
s$߀`%!a#r"u(r$&d0*$pH', #(-~-p`R2B
)ޡ#$-,A1812 
!!55"8q$P6228`!	!05΀18@="0!08%?
g&@Q.A8B0Bρ$E*"5FF5QB8bHdG..`NF5AGLr>E3N  `%6dP>T$DQ 7@SdP!aT!0BDVrF!PC?
% Q%02"R 9$QqF&5A1%\p!] -B;>#)DU'N% c&-R# -Q\_2eZ..1]*(722 [Ai/U#_.vT$h01݁JU
s$UcH@c$+AoP* .tZhsD5 W&eva%$UXUw rZChasb>1c)\z !^%|__} Ch[P`b&p2& uotc `"AeCgj%+ 9B$U\$3n `n,2Z"']`Adn5_ u, 3q(b0]!:es\zW#Up$9!ibV~ !HaFY _%@(X& !bc$d %adJ3vy$?.a%Zt#ré~@5TM%p'8a>SUTVDyՕ qM%o Q;4?q(%r H"!6P^0"85PC Cb)bQP
ucRhd8	DMur!rfKJʑua< AF Rb%UJR+
cdQ=qM$R\d`c Ne
6>bX
a<CB@(@P`Spq(? A4(A>f)q2a<A@(X1(2NQ<Y@ 
$M,0p䑧!I, 9`.fbg9aF@]!`.DA(gpM`24`.$ r&a%S#QA2A(AB(R! ^2$7A41\ TgҪ ^r) ! 3#!# asU bG2aCa=!1ߠD1RsbC`ޠ L( @d(V> pF 1"b(\2"ɰ_  B	        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ      E
   	 _BM  " ( n x      #uf T>B \ 3  G?  f  2   v! ^̠H3EUVk		
	UaUwuUQ3@35
UW
	΀


6sU-i0	
2]#  "'0">=Uwb`N/Q2`W?`3>b=U^
l KHQ B"Q ?QWQfQQ #!#B "4w`$0 &d!()_R!l$Q,-3R@0B0%1/  Sq%?3s.##5  r0	$%Q" Q &$ 9;FA5e//`a<QQ.$b ?`DA5Q^/Bb&0  q!"3"TBqJ#
Մ;W@,QBQ< 4; M ?NPLq01MRLPuKJJ!E ;IP
0
TWwHPAV 
(W1XB
6XO  O1LL=XQpJѿ
Ԡ
W
Pa_u_tpJRa0>`au `
Q&@eeQW``g.1eݡeaiKi20j1ee107k2 gQa8l`e1m7k`b>W1e&``b_BpHqKDpVqH0S
`eg<<ܸrt`<@u2`ZpwJv&w݌w xq<Iwg!Li 
 xU hB{{"#` vCBwv}wQ"#Q0d wedmN0rd06}փdc 
Lf2a"xuuf} |ii.tփ@}Ui L0$t{@}L.g%.v{1AS0i 
(
'> p
>%d B vzƘ12a !Ë!̚q/Cq@}$1A! 1D2 uDAl1>b1}qDl8  x#2 A#C q?	; F%#qS"p!0( !	B8/=1(S1Qu[2Q801QS8 =⹑8r#q1D QwxQp%`"Q 1qR`@20Al?qKs+7Qİ=0F; +[Ǵ:1p~12@ UpD $sD+r 
ΐ.@2c+FUQp"3"a+C/ס1`sUqQϐ&ܢ1F@¬q˓!2b1A/"?p}N`=2i2Ġ1Q0 `զbp adq./ D1A$Q+D퓧D13??1@2310pz0Q"a b0d3q.& A SV@20a{ٓu A䷑1U q'138l3Y1
гPalRb0 bb.`p F1> u.PVЕ>   d
4 *C "2; qI?v!S@t`Qq 0 #:0꣺`A#P% QQ&Ҕ@QCQV/i&!JI2Vqh&$$1C$q /1>ч'2I3 2 B0A}5@]W"f8㡐&1".;(< V`8q Ğ?Jq8DD=0Ld&D󋳇wB3ALFd."}pz#Dd fd`Kacp4hbJpLȀNJ3\A]fsN )$SN$"ZS t-@\S(ҁ%U*OY#OHdVl@nJ  t`yZUL[[[ []^2^ ȶZa   e\          	 _BM "v ( e }  g Q#3 f [5   [ s  ? v! rD   FH !	
3	 O @
Q
?`1`-`(g`r   v o`g"'h   B  $``Р`
(p`Tr "/r?(`bf! QU?a8c!0/"O#N%31H&O!'/(D)X(0 `
H&@(!q.#&D0r+8H&Q' QUO`"b(@7w`S0*N6f"<q&!Jb5fB`=T==B>f` !0?C& q=v8`AS6_ADCwdC#B Q>
%#
r+#
XO	/KK(&<K2M<w߈D`/H`v<K C1GwOODDQOuUKq=gD Qy0RbO5KsS:DH.~ R5QKMUpO8QDC5#WB`X%&@;&x`HH3TH5KW"2X(Y\Z2TS@80V][Q"\OH|1TTw
fS|T ]H`b`bUNxHW Tbac9^*b1T bNU<`]gr&q=Wcbb!"ltmb@
GGx` qOOb"o	eb1Tp YZA@_QQOPp Y!i  h=q@;QYROeqTr#tt
1TFv12^  @;'@lw0! Qy$As^Oh@;dnb QyzAs;bh"|}{0bbd T0}@;( r~"|p(O2smOrr@;
p G'V` [PePxAH&pxo"gp H Ѓxq/"ube~b rw
?B"eQQ ݓQqQѐ`D@lonۙ  &0V3!Pq(P/p$" Aq RbOӔ0Q/ўQEoOt`T2wo "@l`T
F" t- LSz1-EoB!/b1 ­P@lQ$Q/әd&`Ӵne 3No"HBhqaκsoBByQ"51gL-r:q"(1_1m÷ /`Tә"ĥPTQQұ'Ʋ!1-ݺ3DS)F" &SQ_q&DV}Б@$tF<02	Us(@s֢Ƅo8qa2a$q 1!Pݥ` r1(/
B!ݺQUT O0us3s& |hQ3O(~stb|d?ӽ🄉"O p b12$ffxq'ۆbS`AĻ N@U1-RrT"}q ʟ ХW s1 1qa? RpR!$ 1&?ϝP
αqw!iUs@u
1qӔ$(H3/SG< ^T
&}3@s/@;o$s [qa p3 2|Կ "&QrȽўUD{r&B b5Ѿqۓ?Q8ӳHBQxԓ%=V@Tɑ5/ m~Vxӷ?U 134W ƀcsBsSw(s 7;R$z.3svuƴͺO Ō8TӣǑ5Et/F㐁O`Xb`$1m1`3Sp ђ_tǰ}
 Y/D1ѹ"h Rp+$b yQt sWߥ~SѠQ4b y@~6u(Aorɀrs0=~)'`(s vtewA fӘyDpЩohZӘsjLk0z2i' ٱRta& @`@l p hsޓo"`v h߃P hp|Yw'x_O
"_ h1qYw&BgbPn
O"v1vAEf'PAnzhz:v'kOAoB@l&;$b:(R
Gp&bL`-g-|NpBDvG`sh@0SYӏ0O
fApdh1rҏ
f`  horm*Hv(2xSc]$Ax"$-P"rSx$%Y?&UHwawO*sgwf"@f:1v-|.ROxfQh6
Dh2Ш$LL [ XШh"Ls@!@Dhbh ߈@DL   * ԗ     ]؎e Ћt\e+3f  iq L!$F10fPfSfQfRfVfWfUCES>`  fB  f~a|`   t|`  t  T@T @t- @:T@t 	P	fr   t
^1@@ 1f~afvc 3u 6Db< tf3
a>DbP 3ad>aP;vc vcf3a3	`	t
 }0  R`q@fR@
@fv
tpfߨ tu3qA_f^fZfYf[fXfV 3>d t
	&dfXf^PVW 3W B\_t
r
>a_^P!P  f&T f. 1ff&T A!'.f_tg)+Ot..<xu<\ɰޯ۾ݷاбκDD(|180o345670  `0~`:_"!A>;< <m;'Y >nB; @@?=@8:>$9	I!!`:0=!A!;e:><<C(0H)))**L{LH$$~BJ~B@y=G$$$L$B  >""ZF)F3:df@;M`P#<bP` !:Q:eF~=hxOFM'yL<<O1:2

	U?"W#FJ= U?8 0 p	

<=U$$DI]GI_T3B>0%^3<QSE AbEbA;((DD>0:F^4G<d?AeB:7E0;
)HTRs[^̃ZbgAvijwt@CVXeւ\fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗphdo@\Lu͍폜}JT|FؖcInIڍ׌߉s\gpjBȉymGł񂪓rݏOڕKvOxmxrWtÃ_xƂ쐬݉}֎~HS\zzfmQ{ǔsFV͈vdь`YilǉE십ċNԐUiTivIe^qlӔC~t`E֖ؑ{pKWoYgϏ[xb ͐  p>  p0 ` @ ?	iQ C q@GS ?WXU2
 Pa Ǔ1!!#"& pԐ~|Ր  Pvђe_pg?    ! 哯 )f@Haåp 訽0 `i`UX   _`00p ?yBFLXp0:z哈 27<2f
0I ]^`08ԭ呀S4T|   UP W F >"6>'@=a' pC?~!Bc""!B'  /!B#b&2 CA`   tLXC>p1@/@@a00`Bft,0<G瑠00` ސ1\pC o)4Q2SG q0 XD 
	p0 P $&o# A8 o PU| D~D D<PU B f<,$$0$l{=C  1π@3``?"#!! @@ `ë 	4 80	  6 aP1pp<ΰ2P!3pDr@PA`@\D2"##X?A RPq[2@A|q %rm  20`aaŀ A 1$Q$w$PyH {HHKx d $p|@@ 0!c $2&f# w0;xx0QpϠqxp0QAGb*E@@@`)X0$x|pTT T8 ]S0
	!_
t9^0 bc$3
@$484(d(lD&1< ?! ?&!<? !!# _f4cĖkc?А|q0 !^2p!-,4 T$9`0p¢ " @t߿$Bc' a}""" A pp d QIi&0P͐st
`(֣@^@    ^#2Bb"6T$-`0`|Ppx3@@`0 upp> 0D=2C0|s12m|%o38"5U QHU' &Pa! 3o?!   !4!3#Cޡ2b;c?1`		
	21"`na9$i$	$	>>b"33ac.'P?h 8K0#PD!"*220Hi)""?"!FF0!'  <p$P$%)*$ $ ' I,!Ϧ## e`@azL; x\I$ ?P0!$ `\7 ga  9 "} 8F C8R)C)E+D:<  = ~`<  V<$W'0V  |DXvXD|p0&Z>Q??$\`]1bpà#16' < ~ < `  <$$$= ??d)),?4+fIa'0@Ǣp6( g?}f q6  23Tp`1Nr@0
|`m  <ƀpV<!n=$o<0b64~
;*qhHrg`V ~ w < D=<$u@60w5'p'ҝѐ 2oDRD2yt ""z}"cz""s2!A0 "sK@~DyrK8 pa2Гi<5d,0%}IHTɯs_ 
8h8ѕ@1Dkp 0
 .:23V{&  / 3i_Aǀx pz2"Rz`! @w"m0p`4 Yՙ|s߂p  uAsՏ HН0RD %w6 ^Ϊ `o$$/A1 FD @@1#f1~(3H2~RHH~HH ΀~ ""6g@6q"c  2"&	$  c2q(p"bӇvv? e 8$@ߕpļށ
rkBF0L CB~?$&""k  0p	  x qߤ	#`4 cu}PӿPpP C:
r(@p$?@@DDD D0!ca0I7P u%*DL|(0<́{t|s=>@4 ;ؐ0i#!0 ` @>?!#3"$$09!?9!#! ! ?Dy@Pwg7@ H4`b2C"cyՀR@CCyLqޠ%Ax< i@@ԟڶ( (@#@B/(Ar6C۠?M2{8}l>b)ѫ&C3
;b2aW1#n @@$a `F Ö$?u%Dh|  1    ` $1f   p "r1&#0 ꐠ` gp1 c 1'20Ĝ

 A ߀Rs `xBcgIśa0S.bC8e)ÕFR2D԰;?
 Pe|Pb?Da,?=%$>Çr![cP [0?in|D2D"DvDTDD6 # aB2JS' J    בkZBz1D=408%
	  6 P>D:5 НL D`vBf$,892k'&ap d+x 1KpxPX	 qs3"&,0O#1xMDSPx<x  pC{zA|8|	(9H ;)*;*$*%+8NTT5Vd@Rpa"6#?5u|s {pl`0O #P``0a$%+×Њ AK d i~p*H.K'6cPd++C
8x &?~!}Bc2 #"@3t%3b0
0oA5=8xf/Q "***" /"$'$&*7"$" I? u0` m?~$BdB<<B
BB~10J"&_D$(-pu2?,!qG0h
 67nV0=I H<H$H$I$= @>@"@">#"D"l>("8""8>(Ol6c0`` @e@H4R$zeapUS R PR ʜ))`py0 ;6"PN:;bҚa!d! 3 ?$$$$5d$Dd < ~ `T vo $D$=0JLG7WX<̜t`/$y,(80(lqD?  /"?(/(/(hOX Cr a: dP^	tP| " ?4g0Ђ80Wh ""bp $ & "  `?4@ 
p@iF0g*@ ZPvAvXtpqQrg#`(00 a?$`^?			?R" NF:8ȡ 0@	xy g	 	xy~>""	zu">fT6bD= D~ = @U~< %U8= @|D< !!"!"="@i?;@BF\p8@h1@ACbzHHHd,$|$$$TdTDTc|@>?ްA'$!$34, g A#a P8S`": &{#f!ab62~Z*\*jI!@p EB I@`x ?RRpv H0	   y 	 `y1cú$#'4:D55pC2!Cz_sxK0e  B F>lxPXHL0F`C2)ưg0`@q0 
0b64~
**hH$lH UIHUH~HHQHU~{HAЧCE!qW8 29b)) ?()()~?H!!!aGEl440g* zRs" O70P##`Hx:@(yap" ">A3>>" "&"cb@	"00P G@v` xo!;  "P`dZ[	Q[ <QJ{3?S"a |Ɇ#(Q~I	))iIx	1!c@p>~""#"b>2>kaa* ? ?  ? ?$DX0b)+*{I#F(aeQ!BqjBpq#"?"#
 1px2Q|  8p0 S#Q8#x+eAGQ8@<
%SGH  > "~&%,(l)g$`?E- HQp2!;VR!q# ~l B2x'pq "**~*Bڸb~B$fAqBFD0@ @C`@Қ! `  2R2RR_Bb.IQ4d@G""pGbB A ?~B 
(L5+;I;gCXaa
}0m8@Tll$5?b5dk g>mqcCxaxS[ӚeM2[ 	(	)	) ( )H	p@c 5P 1 a1[`w?~""2&460ba`@033PH}&ࠣ0'83g0q$@&bBO6  |@<  #<͔BC;<@s `x(VFњ;Q1x 	 `p1ay3"f: ΂|Ab@Acp>b@$	,	(	88(2l"Ffűo'$@ r3
D(z

0
@~0g<$4 7 a  p }#"4&0PPr`@   [S[ uUpcu0P0P0P0	P0P,P..`1S.^1\ \1  [<u.`1 `uVʊ8r
8s8t>8t: t3-v(8r*<rw.V1` a2%P )e&''%&&&RV^Zt&u`R\ts 2ƃǡp.G
aO s+EN_jP-W-1%wts2q'1.q' /<
t<
tD<tY<t 'P@H  V'P U t	| tL^f7t P7D9XM7cÀt	f0¹/ u 2 /.>e1u .U@R@ @A `.V1&) u2CQ2P Y*2&P!D aqAfARDr
.f1.g1PSR D && Z[X ,, Oа/AGAgBHJ.61FKFK̰/PM.HMW/tOtN_JrRԕO*Pg(HQR.6\1ʊƳP ZY[XRV  BX~V2cWXOsP2`ZsP
Xs[<r<<<r , h1  j1.&pHbLBu'>	j13?Q^OaUV1`.>1P2@aX2PEa1a$CFaUPQRW K=j>_ZYX. 2.9]t.h1rb`c?DP^<u<@~<k<@<k<k<k<ޠk<kû<k<@<k<k.>b1 t`]3ػ@ .`1G.b11OpUCrr.`1.b;1@s` q "t0..1.1QGq;PG O Xq@kyyXd  WV>}	@9x
>0tj6 h+]at!j^F\a؃&  hE~jFq$a;1>놀Ioq$a% = hmjb OJ?@,j#	$%1Jqf^fffNraaAz^#% ׊Qрyf>a!}j_Z4$&MU`4
_,Kap1ARȠaUe&DU	yEEXCȠE.=HԕĊqꆀSԕ"VD1U@ۇگZ[tvPu =R jWX&mgvLi&a u = u_(a-a  &at9j9&ʃz1!`jQ~a$!fh  n!Ë tAt=pfhpjna$Dc!ȀtWfhtML>!tZ>tSct3tE>@jhafjhI>^~@%j h^WLAмпf3f
0~fԜPFPh"hd2)հ}h 3׉F ՜`H[辠~=p#?hbհͷh bؖx1ٟӴԾ V3k5&2hctƀS2@1F0hje`jexQP``رQbܫh o_F@Bպ_jh!fh PcWhcAP9I1U#h`aA`ސb%hq~D V1U5*_h]h"#cu1T,Lz?"1^_  Vd^F FPL <tPvV0FF~rыّ F FIu`F&-^ ȐF*+҉FVd+;u;u2ád9Fu	9Vuàd% ;
; 
Ðd% 1	)
j	@
WV~FF&8u}ǌ@P}ړ8t
drƋ*u
FjDNu~ Wk~F fj hV+{ fpf`d#F"&^߃&&ajLfPA otjPQ~1 F}Pq
зd*F o.WVAPV #V=ut_ V1	{#!GF|_ 'nu(]0)2|)Nu(|%t& h &'! F gGP'/
1NuFG0u0'2 +0/3Y4Ǖ0O5'2SLF nt_!2q$,AFS!22  1 =A0!2<V=>!2<V=IU	"@<V=bs-A*< V=?A<U@V=#C<ՀV=$uA2&%a% a=_%a AoUTC<V=9=AFpu~`2F>E&>& K`A"@LOAM&a&aO@&=`ЁQ
2&^% +1^1 _jRAQF<u3LB8U_UST3W8UK:UaQ2!=1Ua1jUDTQs[@[AU$QT@B[[aUQАNOL[0[~pV>\>\ajEUbT2&J[CU1erH[[HU1eAJe[NUc3gp@[[gUC3e3@]1,0\@ji#1e>ʠ[[kCjSUbTe@[UUre[\Ur	2&]JqdA[rmon83+vb\a$a vjX KrNt4]a$PjO% F!&a[=@CKT r2F dF\aH\&@&\aWA[W a*dA #
^@f0߹a`t}AJ"@D@ XAY _$2% 
^PFd^F  ^F&F~
rP{pJ\& &gb?&b &c &b^2FeP`d}@В^aP_bfГВzc r̷= Aѱ A{rN`vr^aF@toFt@bSZ`tT`uN&bb c .`t9ћPȀt"t!@c] !aw ua@tJHO]Ju5e@5Ќ2БL\&`NADbPAdRAa!r΀&~a`藵VGq|D@I.HAR@Y0  B߀&aw+.}@jubmbeb]avB #rGFc!
޲T\B&d&d &dN5&ޓ+&!&령&Ƈ;dT rp2chJ菀QZPMa Ec&cFVĥVA`}XAjeZA߰c\Ab	s$^Aп`AпbjAпdA`?rvaCq0e1c ܘcF)ģཚ@cZ7S!iŀSfZ7ȓGZ+Zc$ < uA@<@{Tr" 
E@+!p _p3@yfAhA(vcaSZrP@%rD	F^N0'~#tp u^  Q % ^  0Ñdr- tVAF  j
 @5RP#}2!N0   l>v3+Q OYW
@ |evB%ath ho @R싍˖Oo9F" j hhp t60ޅ
^0  ~u0+ҠFoV vƂP~ r~t t uFpfv
ۆ0pV,pIu uSI  [t
P`0 ^0	tA~ f a	FB F~P|pv^ K}0F N2FFV~@OF.FFVs6e/pһ6e] vFW~̟-j
s;eP
^F&? uvβ`QajQ]h`͗^@QΨ`vA`]NFPNp\cvݢA:ee0^/G^FPA ZAFeF]3a&3a/"FfoPP.p}hl>hV>`RP-+D,U, y 1c@! `+FPᕽ"F?-3aFB{-# h8BC,@,2ά^vIs5u2(F縬^(
p3 8F+ BV2'FA5A_)zv*%29-4,!>=^F33)C03p$` ["Hp`CtCˡC0F]A 6 ׊F2ʐ~2|Ftpa@W^
~0	' _p  }GQG;La@FBQCETF ~ t;SGla@rF+p~Ez uPM09MWV~~N^b03IAI^_3J"j(J P
TOqñUK ,METF(|WVvԋNPcHHUTJJ8!PKWvX@ ~(|W~YJ t_~@u"0c^}HB^F&aWa} c[*R-B./LPҷXp!udDGOMQgpDyj-7Qg4RY}S6J3V)hKh?iPjFS*JOPp
ln$osotKU^&^&8t %]^^}1_ù
 0GFð|N^ o}X-A~ ~sNFNGc[;wuЀ&@T10z3ɋFPAFC&< u󠀐*fF ~ЋߥsE^a!$F ~ ~Д0BB
CVVGV~^0&FIu/&sa]ଣ F2$a%S 1 ౑V>ĨVI姪Vb= W VoUfV?B@V#%V$2&%a%k e9dU&&Rv^+1@1 _j_R彩3A`bæ
2&^% K:bi2!a1ajRbLä@iAbQ,ä@ iabM 0hQapz3zA\\ajDb{Ҧ	2&СUxEbSôxCbQ iHbpQxNbQSp UiSb1SôU@xUbSôx[b 3p.+1\p.jgQAGP'iÁAA Q+t j^b3P&À&\a_a X_A2+$PjP΃ &?a߃@Ҁ.&c3vf3\\f   bfZ\	 cXjeQV`	s$2(?&aF``FrbhHql`ac S`hI(c Vc֧*@r؍Fjer*׀rXV#`=ٕr#pύO~q &lG6 _"lD> pJj6 ?h ǿj^a ̋؃ \ajF$aD.>I?@#$a,/ 뺁}jbq 끂$%z+Y9&Cf^fff`
K+fKażA/ŗa$vD	UE
4CRH૊ĊNTArU0ۇjrS"t	Zr[0fqv0Йu c= jWXV	8rg2ria `j!' WVvWދ~ &F<t<w
bcFrWF*;_}71~	'~t&!'F&8tFu)|)<r2K$yVP^6u	A(|N`.Ð.Da] ~Pfh#   F;rF`)f?*A4F`)@ F*N*ȁ vFܾ(2P2яQ33Kv
u+d^F &F FOu0>0,a
Df&d@>&&d&>S0d`>>1?W'd>2?>3?pt
B@ EҊQ;: <*&d&,2PE% d1d0uFF= ~E j\>LCF+ɉN3d3G3JuJG 0u*d$<EI?Id% Lu$&~pEu|I@pf2P% W0	u">M<uUIqAyI,N 0Lg
u6PEu*BE#B'FQG`Gd,FOgd dd	ddd
dddd d!d"d#d$d  O8a3F$a N\af&$aJ\& &g_~t@at@a u_Oibf~ t_ fh6 h à\ 2 ~rF*F*_NupX!ql>@ fci& !jf`jpωF9t\ujqRP- t\F  vB F¿~2| {1~uƿF  0p1duFbF]
@q{cqjoSlЃVPxt\FRv%!F@`nb*J*kNqQϋrsV! FF o|Fo؊fك|-7j|vOw`xaprF܊[f lj~z?{Qx QF֊fkt@ t؉FߪjzQvvb}0
~SasuFPMRmuFhl>h0 9o}#j{FފfPFfzpzQxʔ:CǠ&p0F1F2F3F4F5F6F70p8F9FAFBFCFDFEFF~Ƌvƹ1zF؊GFދNB P*sƠFNG&;u& %Ce`s6]d0!9Pj2P*Ё
-Iik-@$ NV2շ|"22d3<3劆2~a$0&PN$mj)ca@$
 e1d=f _Eɫ% w#0Q31՜- t*-} t-90̸3r.ƛ1 LoE]/"k!jLFdj%֮b3װZÛ~GE8/b  3|
/}F[PR8u袮0~a$$2U%P&ad@2s^W^1jLFPApLj9)sS&_] e /WV3 W2^&@RFG| 232]%Ѐ b"9f2PЃR_& FW8A6PЁ $8AbқfW>ao b__6 6 &= A  _ )Ft 09uZ2dCۡ݋E

!/`ou	: l> 16 Ĵ &&T 1\V0dS~ t'j9g2I t/ u#'Sj	@жt= t >u
b&c"b2cc` t?&bR`ul &l UX&a2tIBKWWdBdj P\W~'dBb]awtV2@2tC_apP^$ah3+1ga1a @$Y;da:dcY|ecac`c1ceb^^^PaU2Ց1Uā!qYbQ> u[h hB hR芃&
"
^2"
b"
ưr"
"
U"
"

t"
g"
Zz"
M"
@!
þcC	Wl
 i%96"$"!^l\F&? t50(u%&|RuP!)u&DPƋV@0m˽0FFD3R`(afjfh 
] ] 	] ]  j~L~    u p9&a MMp>R` ctf j j 03= H/=
td-
t]-! - ; - / o= M -@- - ߄ -I N /01 2 5ۋ  &9w&Ea U 6(  VV" (6KL0:c8  9P8~ H-@<<; ) < )A8A: J4f5t>np)~5><5v&@u?`4Ƞk^A;`)@`)9q)tBvĴ_"C*3%w!k 
 n! ސJz\PZ
@)d δvV>
  }MvVЊ*QЉF/^@OɰK% 
P  h
"Qh  "QaLNQMMF
+F@F!vvo}	FMz\NF@Pj scSFPNQ=`U?*PUʐXΜVW  0 3_^J JΠz\%A@O^ hOpg
Fz\pfNFNXY_;F|UUJF@PU]bVv`UN`pfF#t&"ggi#ǰppu9TP}@YYЁFPFP訠TG Ё̴t1nFbbFC PF0YYAꐰ
ЁNfւ]SC$ua1Tbt@J*d"ܠa]~svvhVgnЁp2x$yƊ{* uzU  eVn0S]@> tpur3NF  ` PN#&8tG#05vNًQ؉^GF
&Ftw^ GPfr+tpOc
ׂ뎐V^% = @ʃ@A3t@@ߋ@AO?w> u3&a*;tЂurA*/pKa~RF
tЖt"ؠ4f0%v
V2XO:c0hBQП?Vu	!QiSd!aU@v(Ś rVu0gilysh>(av&dfRP3>>aXZtM]؀tN@s a	sp~v\Tx>~OuIS3+S; ~
 ~Iv\0~z~TMu^1u~@ |\1}#}}.>v\ }(в #d}wv\r~/&x~1.x*`"ӷ ӷ1зx x\}x\9Fu} 9FttZI6x\6v\!|\|Qv\R9xtaBܶ!O p$|\p\~\·r-» 1ûZzPs  Jr ·Pt`(~{ tQ]V0qMށ~``F}к;uwEҀЪ ;vu_39> ~@ !n\i*HF\&7{F Tb;F|~
G; |ǋvy0>c8  T>0ɅJ1ɘ<dFf&G W @&Gu`1ώF&M*+ȉNߔ&E|&}39tO2gV,F0&:t~P}
AFFu8u@m ?3_} Dѐ? 9! *;g}0׃~ru3&8MtËF p܋Nu\ut`*G;p^|P,Dt3696tVo{9>  9p
7 3ѤJ4^&9 ~m4&5&Q5P^FAFtIu'9Nu"^*&y T  b|pAGPv
P@u    iF+F-   `Fں0p3EQ 0pJwhh s^`FPV`|3]qFDF3o pPmpOqOkFPAD+ɉFN+ف H&wwfoFf` G @?V 
 fc("[~38tC8 uPf3~^
AF@jGP
uP2"[N3~(~ޠ uA F;|_ƠSђMfTVNV1fv<%tFpu DDF
0N$F
І]AX #
X)VFX0TVrtQ}g;v~@o^F&uKF$zW#Xc3X}  _P+΋э8sdvWc_N&8 uN&_= tq@+$0fh  ZI/fh *	*)ӽ{P*f6 aA[IQ),*MpNc*)*@Xj M>,vQȰ?WVp\ݼ@3`~Bv@ !3&ğ G0D,fa#;~z! pNu`|8gF&3ـ A+w I51@cPZ*V<*a<E1=PkA ~@5E~h3ҋ9 @@XW谑<560Gt4eP.v="=bPCP<cCGW__AyBzPkBk |CC9Fu
HQkSFB H vv..J6{0ՉV,ݕn1CWnMFл}+F- P1I9.1Ad;<AI2P<7``
F JY09@O=`=As=<1=zU\UFREPaWD0qUbP!jO"*;0<fh ' ߱\jp/ذ\br69u	fjaW1A!3OS,O<1`WSaWЙ.3 P[ c~x/R`WFAll4`jP\HaWjjB1𞯢aTRPO-`QjIm2I!d1!dWVfaW&	m"2б\3@0F3؋E+FF0FP`t
Lj&荱\tj0
P6p;d`I\DPaQñ\:Py{yt5O+F+ tA3rxjw{S,w@PIA~bCy=EzD maE{t}|@ZRM*ARv#ujV`AItEVg@F?;v5xOP‱WmRƁpYUa|2QPc@,s~PnS,nmwAZPaVoAQA~&$hb{4ha|tYa;}^@Zt/D0q4ԵDT3FF~_
P!||&Fި@u[]Fta9F;`Ɓ]RQ  &tQ;v}v4Ǒ'GF;F+F-	@F~F&Ev;v~`A9~ ;FPF胞Ht} t~pV=䧛~RP>МtOCPG\p
t/*@ F Z9F}\2B ;F~U
~~9`hº+F|e&L
DFFȀP"Rj`m`PS|w	PQ@PFAZ].OERZ0g
qH|x Z̩Fu0v cv&vڠ1aQvFv cPP 2O~ t3
S+F|FH_fh ^q^ tȖS,Vv up9~`ǄaF0`0 n+FRgq@@w n&O0@+σQ.8Ή+ǠRQȀAZ1Ctj[!c8B.ΊFcbPRRj]h| /03vdAZA mS,)mAQ/3bh4f<d
p><d>dj "Ww 
Ht8-t-9t- 	t 迋"fH q^	@F~ tP
f<dFb  F
Pj ~a" v
 
]*Qj PHPVP< 
I:6&w"S,yQt@wo/ S~`	VV2nF
tF
.Q% pr"A!V1$6@ t~7Dup3!\_طG DL*!Hѷj^~@19>uQ*	 0aP1G,QatRk11u(+Huu"@ut+j	j_fhA%xQP6t`b/Pqf~
 t
 2w
Z$t AEUanxvqFP DVV~@vvQ P?`s6 i`]3Ǜr@1a'(q1FpP{2S,qkF0`0kݥREq
GH$q٢ 8P ]r)`}_?'QmK7td&?'SBm)2@?FFPIF@
~;`;N0NNQPB-u/  0?`t= K = ;P4 -æ-o--W
qWF Zp >d pOy;v1V;vFPVW7F`;~F@G;~~ХO - D- *-#- "?e= Pk'-4 @5?.BG?@6W-@A;BF??@tU?tP-PAʋF!~09Fu
VVPIVF>P9vu@pGBN9@pPNNbF ~9~`;9V 9vuG,< uN`빋vpJJ 3&P3 MOIJߎ Ox9 KO ΡR/VN;͍`Ju9JxR^F;~mGaOIX`USPW KtQ~Du6dHJ;|AH;+a<N;v}O;LPP6V!d~ u`FAa9v|GP|'@@ Л =9F| ׉~;^^&+^& <プFb=a23Fs1h\.Vt ;tt Dp 3nf4Whg
 rA0<w&iip7j0Ckڶkp(WV  oA(c c tV@rp@p^$qpfv"qcphn$qUpF$qpN qniui}q;F~voq jТrջN@uO0x]l6u5cvUv'CwwvAx6pKx|>b u)>c t^>je tfp>` tn]ab@h"j% ,hp@mur&jh _h\p
j(hch\賅\裂ф\h`_h\胅]s]c]S\0cyz0ci]1cY0o`I]90`)0`ril4j0n^_5 *= Ht.- t'tF-4tcDHt- t4E/Q#HjhPwtq*tU*䊇aq*u!*HWv @aPVt`h4& C(ppJrprtrҒrt qh@fj jTPV)0WVh V3j h6	d^ ,D ,HtHt#h !Pr S S 1<t^ DX	{
F ,HtHtHgHt$1" @@T@@$4񪰳&&G<`jhz	G_+Pr
_G>jP@Xѻ ^GPv&߀ ~Rrji6 fPѻ3bPp> F~| 좹}v}@j	&8 t 9GPuo  >99u3 f   ^f~ t  |֊Fq	K?		1	9R` o	&ҁ|^3&~/t&  v&8 up*C;^k|n.F}8AQ@론d/q/gpY^? tvN~`"v(׃~ uKdDFG&9 uԉ~g2"3o~F=/5 X=5 9-
 -" -(Lٲ78 ;uP< tIf齠>ts6t[V-
tL=pJ- hC- 	tI- - P- tNEI_j*odP.Bd~D@F	o0pMt"`}uNj ]G#0 2^ u
1_c}e.N3~*`^
!ފP&8u	F;| !o`	`Pj
@Z q 7 
2Co
~a$~ *J8fuad݌^ uItP3&]cpF |FPZ@
t-n f3f0 bf h 0<륐j hf0F]0vS 3  ڊF]F a*>aHtP= t	~a@ &~apRaQu
p
6p	p	p
 &
&
h*h@
h W A3 
@
@ Dt2	@e$!&	F &a&a)do`do"  a&]FPA@
?pFtlftJF&]^PF "f " ;&#,3FR
E4} (
-Н|d&dhaj8|+Pbj +
P*
PfsVB)=bEW&]  F].fP/~a t&.
 .
-Н +'j
jV445 4}_!"#$%R
c '>m(4hDbjg o)U*T*^j/,O-o./T0X0X13@@w2"]%  PzRr
K`2
J$*KdK L*ELLdK  LELKfdKKQL#]DLDdKf LĕRTcK"dKKR1tH_*=	0F- 9t7-
 = Mt%
- Kt1-Mt`\Yn= d.(DZh$J,2L0__8&"]0Pq`'a__`Րdaa_a__Ր^T,2R0e=e؀0u/PKh/ Cle 1eͺRp
ϸ&@g = le_
@4aee |QV|
sa2r5"]~a$]aa`Vfh~0Fh }Н|`@t߀&
 
@Qv vvcwwvvcwwvvcwwvvwwvv@Ɓw
@~a"]a$]
w
rg,НP'W`[# -+tZtcmPKt
- t0u]ae_R\ `3ftGWo h@h
h hhwoQ
sTJvK
93pfTg@ɨ`!hÐjy؁ܠpw&
3p0P}fu Н7
Ĉл%zPǲW{+BXG"YdYnZf'\<|05Pд $W W:}W4aecRi"RdR}f
Gjddhh fФDu+ u C1;wut?&#]SoWRee@fG@tR_*@Ή>]\?!6`
o.vPb&$]0]p1
S t_$_$@`$|3ɻ] &Arh[夣7G˲p夸XQueQftDu43,1To
qw|s]TNgvK0(aTP KEMz0Ņ@L# %TD0$JQ0eaǁd|
fh^au тϪUuϭ7u
Qt
rw
|`t,}~*Q@t>t`w Ґw @夲ᔠJvKrOTp K$M/& NK$ KmX$ REKL$% K+$`VU%@K
$Uۊ%‐KVi"TJK"hի	+!]&pp>zPw(
 +u2OP:WtXyX]|YhZ[V\6\/@r]
]6^ү.<JX~`4r1` 0bRcRdb`ff ?&]P
2er`q뱔Ru{ tt1Є] 2O 1cQJ&]Cѐ!b10a	eq@ dpsf]f$atWfh{  1uzƑuqpQf$af]&%a A @c(T w(0tU08t8 @t@w&]aD&`t`@HtH% = $ B1u
hppnu5u,u#tuutuhPq ǈvrhD֢4r2#vF2FPVh:[@@v
WVr!
qE2]0HtHtt-LJ3+A'!A'32'
2'{ԻvKT@$
27T3R4p+2+T3_,p+-+^5=,`VRp+!%A7t5,Tp+220@JD8p+2D,G5p+t,  WVf+fF090909F]^F^^F2:FFFp:Fp:Fp:$D>== `X ߄ -a -tR   -QX -*t:-a ߐ=+- v\ p\-Z[p\t}[x$@%Ht&/Ht:H@'S'6!G0b'1(!G`r(!GdF2)!Ge)1G3 7LSݰ)K@$Fy"@t)j 0ÊOPNPfsV?tp;t{R^QV u
 8NFT*HFl>~< ft fFR:vfvvFPvL@$Fnu63F,1˃~%v슅R^ :uFZ![G;F # ~ t
&`lr؃Wpr_~@N&j!_z!_p__j_z_A` t&!_!_׃__@Ѝ%"Ht)3C'2'#gff&RT _aAd7u  [P>] ucuq$j k^b`}3vnRuc]ff п]f ]j"qq҄q^q2 s9Foh1bt^
][c3%Гb?-9t- 	t7 0[mRt
{ QR_`1cfjjg Qo1 %tu0Mu.s4Q0Tau$th `Ɛ>^ tufh   m|	F}}-6q2`>_] tQ|l>hFRtn@hNSt3^`^& ]\ъF |Cv"lr p%tmSct >Plu>20\t&,$6]蛵@ W`~bte3/b^a>Plu	>ҰZ1.j({t;Bt@kJlt'Xڴ{h0w:m0MS{2l;l4TZ\bd 0jPc3@@c_j`J$XOu$hd}}tj2l<l55Z_b@j A fh=Q"j-u1^]h%ːCv ?@\^a^^`^^0b^{cPbQ)  \aC=ۤzcEd(2耮Á>ҴfbE`0(c2JrҴ@c`X}ҴeEF₶#GNB Dt,-
t%-.t,-	 tE-
tYBt- t/C D]:"@~ &QmO}y  oyBԳ
Vct߰buC̀&p_ cwtu
Сp_PcС̪@Сģ  СӼ!@utİ;>} ܉ ܃ƠQr֎/ha t;tXO6Q%HtHt܀&Pm'(Qa)軽zOߕ	#u3^_SWV3ɀ> N3һ  Br̱Ա@ߋFPWz~`U $X>"NQDt z&0_}Ab%8FV^tF&ubOoǏȯS ?ː> uh h]h0M{h!jhx
Lyх @t\<" N3҉6 o5*@;@}Fx
r݋FhPͿr2M)B{Y(RJ!%0<S6wof
0k~pf&d09v3Nv~FV
tut9v~O|܉~*;fd^^3ЏQ
GF&Fp	
u^*ۍF؊F%FnRvBĉFVy	NJ);33V~"0T09tG;|	FCFBF ы3$uQGOb4at%6%, RRR 
8fp^ff?fGr*{1*ZU
#$%%%p^ t&
Ө
#$ }Pʫ%%J%
x*0+t+`% %=^3
P
tF^&oFa0u	00($0Fְ0+&s+EP%̀znG`rS"r
(!]=B0=@	-tX-@C - 9C?Vx= Mu_ -BCt!|- =ǁCC c= Y.*^xĈĖ{/BOCCp^vJp^0K+1(1r^#- 2&q^% DE  aF 3!EŐj  jh
I[e@ ApAň{(MNN#aQF uj{1)3
 9 2'G7ߐd؎	cW#^197Cd^dLU@Vp^o^$@`
0_Q&
a
૨q[
@
RYS׀@TkϻVk
k` a{@k}` ab^`
 a bfhjjjhl`^r
>cu
?j  O hElF<tF04hÂ%xS"0F 6\]RFC|ߊFE
@X ZDGVF$:Fv
mjeuu(pb$
F&wN
5{]!t^q${ɦ%IЈ
t^v^D1
u${` |#l|}$0+y{( |Tl,t,$O{+ |h# U0+%{|h$%|{a|Ċq$)0+d|Uh	Ȅ,0+d|+hȄ10+d|Hq$t0+Td	F|2$+d5
|vz$
d||Vu$%|m$Tu$D
|L&%q$6!D&Uu$D|
=,:d:L:,;-
F=
- Kt ^>p;p? ;}R@L@ʺ*Rbr˂˜˲zO,2zEtEv^^Ҫ 䁪Ҫ ցҪ ȁҪ0 뺁Ҫ@ |- 2&u^F띐Ga ( d@T;Ā㰀D|-  3|+-Pӷ	ӷ	ӷ 	ӷ@뢟jhl%{p$sKo w\cL̅{>!FP̮qqd?aIfaftಷ\a)zz@t )Ȃ \a?t& UʪʪU]cғUʲʩrړt& 
p@aa@t&fhtcuh`ٺ@`;2xfhdh0
*c)2נtfh/d-.h,o /qtc ڽA` 2pz$c%24d23h1!ߢT5`2Xx2UXf27c6T2XB2h|JTbt
  & bt  &gȃ&@@S@ut裲%;>  B7$rhbh Sz^r\& *z^Peq u$0 :3 j hvh8>5  t~@ p`` xh|9  RP%  j 6z^zu.&`&hj`&px%z賾F`e!W  Dt,-
t%-.t,-	 tE-
tY- HtQ>- t/?C DK@:>W~tR	}<P
  
a%ưbJ2ơpVfvfhI
 ~ /ju Ph %؋F&?:tF&<:uFF
*0N&$Pv/
uarlpbWF ~ uF	 F
  
}
<  SvZ1jQJ^PwМ%֯JPa%@ /~~ tgh蔐v裡~ tD=
=趤=u5W }/ ^3 FPP@6@P
sF9Fr=W  9 5-
 ؋v v sd ƨu}= w!AҐ
".:FӋ~`uP!`˛#Ѯz@*~ t!Fa,Q-  R!@* F. :. .. {". ./ 
.`
~dz&t}W |1#Ʋ Ǉ0$ճ3^ Jw V`.tC:uw^!;GC:uK  KXo. !lI Nr;~u r_ W@ #A I rN9FV~=F^`=uF`u6N"D'`u0]WVc$ w< uג@AH@<@u4R}0hrt1p	6\piq6|  :p	NMANu\U4-Q6UU	iaa9a4|^ߣEo	 9 
K"R	XYDMx`2f7
8F cp9 F@tHt
0
nl nm jw @uf4 ;F~qbbm0trջN@uOdhhn淥lWV3apbWrfN
G0[r֐zbj    : jMHzjKB~j  (  +0kSIMPLO  MOTOROLA  HP  1.28ajdrivelockjCo Computer Setup  <F1=Help> Filelystem Information  Display sqiirSave to floppytconfigurr'u diskette Restore fromUuEx;vxw6xdefaults.|s:v  Ignyhanges and exoit E  sp withou@~aving%uMoV SecurituAdministvor password oSve a?RPower-On⧈pҊvDevGicedBqD0}sDnL oso@mart Card`pՏsupportEmbeddef&6ta|e1xet"uacpxswsvauthenticvC|credal_ Autorc8Tools Ba x CalibDlectb HDD`plf-TPx oprs Activ0 KO4S u14sĩustAdvance:pLPuagqB; lBoob:5Presy key!u0vue F10=#, ESC=Cl boAccep_=wYesNo A, Aor=Mx Rź!q  Usu arrowШo highlÀhe approprimenu irp2<ENTER> 0ubegAiDv#.G?followE5vn:j -> ЇSPACE? = Nexrzp-BACK vio௶FojTAB5fielpCoSHIFT+ CfCo0#ւzЀ0úֈ E~r This/cann@bvUd An e soc@ whqF۠.s vde _0x01 ex n0Aư t nuCrequiprwrd obapmu mov@j0uek/MEU /0p`1Ơr !l?[2%colesu0ssfulManuџ r  N0dProQЇtypqspe@teppCacize (L1/L2) mem ROM Rsr!fgamise l nupVideoKeybo1r@pverD	\
d$11L22	324LqaownhSip(5d0wg3
w
xq0vda BSN{$1
2
3L	ME
C
V   4%TV'
)D('-S11tFtuWarn: Q&ll|op @Ɠ1s oif⨶wTreKa t/F|w, 8leinP  
wabqLw t0un A: C5g>R?B? wat|tbi>6we?s> 7`rCInv=;wD5P|<);B|AxyouMwato  0rx9}:v?  iPɄ  p?RPE Ѫ Ҫ1 (Quick0Ҫ2 (oresnW3 (S.M.A.R.T.) Es3tirexvim`): 3A0p9᪀g2
.Fo0%vV"Pp_tuy haoVV ?Pup4ea:'t[f-]fcUnknL	ilAucW2F}fServfRceafAdow frib p:0!SexP5 Ymb@.q  OlPNewV`fy nYs=En=Off Od0 5 P86B3pWro s$t /"xpQtR#Tu5ȏ}{causKC$ (pH=h` @C1B9  {.3qeL70Oloss `9 ^YQMhouXpr nlcoof agoH`p]wQhQev`ٯB9DoMish6ed?u3 f:ᝤ`ddi谤OPPϢF бr.w4BW4ѥBk pMnQs)m:tSކ (φ6vPs`zS1F[1qP2O	nʁ e~R?S̉ F0됍bmf pPԓndP@M`unuЂu⸑ntartr!lGfryarPara0T?ks S Vloot MLiP Fn+F2 uWlanetr0 mtCD-@f"FT G~@ɚ  abouANuF0=hR? ubkOa bୂ9US{ERMAST@N9F	pCanpz Pc1xC 8wkeeWp iaSephys0ppgI m=p nr. I MO',9Lb n搃bun POq?Ne~Poď1AutEoac?SEd0`h+) TƟ;+oՏ֕h ρrQ顭RTurpt`0B9rth@TAB@8s!wX ok ABeudPerA֗[affFLa,ssib ma8Q@igi Ibsylrmm@@BAPul9W0repcla  ~ _Тr8  0R?`:,cz (ЂIgP'lHmer,7@fk]ppib@mty. IfMdorBNt \]ESC.!S AM{tSypO"x''p1869F10``!`Orm0E L{8(e%  Q.E@⺒)) Or:4PC )ay7+Damb+ (leftW-.h@/USB65a1#b2HaaER1Suv3ZipTFirDVo sFth mif 7Si9xq7h E17N ?hp_A8Num E@ Swap/Ctrls K$!(U.SP _9amd 
c0wa1legacplPAbRisP	!nrLpZry5BV@o @ NTSC`AL2D-JD-MKt<Bid rEPP ECPCыsize 32 MB 64AJ3  1omlwayʀni@[ACC Ag]!k" @1 D]+nN+2o/.`)Q. ɀWF+ESUV 1VW2_XW3STokRamLX8\Y 8\L[5PO`Q53QUnique Idf4Gmeg   GtubOiojj SC|g(Calib(?lgN0smhnoxPC DA| .qmtopvrAObym{wpo~zsSB܁u@߃fg/OhXsH @߁mp/ozAOL / MEUomOp/AOR 1/mo/pAO[h01 : 9C0g .(% ]p(oClIeAd2P4c PDEd3 3D8FD|* p ! O~ov
ϝyq@?s`9@l  Sp  &hnologyP1L?FreRF@dadapq:*FPXE ?RPL ExC!*Popup DeA(U0 10W  234567!F125 15D3by~>B~@6ouchpaЕP>S0NonP<F1=Hilfe> itqinQ!pnz'eig!fb3%peicZ  -KguĲa9V@fwie*Z$0Bn<vG7einunp/JF-qkZ~ՎHC@ ed%tnt nehߗѨޖ8_uSetSheitsfGunkt:P\n@dt_q ܢp8nlt-KE
 GertespOmq-IDimBtm!U@st3tz@>r HpAfz@  beim qP:@O_@g߀:Fhr95nsvorrRO~azurck%AzЯ~%BX>fog{	m
s_ExiAkkuk%K5t>s?gewhl DD-SelbsspSttiv߁/Q:iAZPГgErwp3Spra5Art-O o`#	e ٽe0lieb` Ta, 9` gfah`=AU , ESC=Abb
)W*)kzeߟ*)Ja3.N<i., yJխ'=Meh[. Veq'=z9Mark sqMen d0'Pfei#lta( .d&7@gaber8(m @KC"p	0:.<4fol`p1B2n !5Eңa'<:Pg-> Fr Lep8 = NchCAA<-CR	chritt-B2CVo(DgTabulF$Ds Feld HoBDll2F+IGge6tKgOa= ?OSEscFlb iࢰ kanU&t wefeirAQ'K rgetrn.Zc0 0aA03VP0fipt  kQZF7OYq'W
sel omv6orBer`lrDesk-s٢mau	_7as1sޓbzw.9Mobi@d2Zgtz%X.A@ @4
XZ/[B\2pQeDjnblgr abjchloAs Րe-!llztypJrt0w ^Cig^QF baRxQCq-@-Gre (L1/L2Pe{kapazit@OM-Rs}Fami1 SG@umm e Grafik7~@4~?>`r-Conav _dve"(V1߈ 2 
3_ 41Av
si 
"ꋎS(F	@ڱ| !a_܍/HaSek rdV ѧBVdw st bisGne`(EAQe-/aWBVleaڢ4bFD'r FeAit׀oL @Xk A:֣nfdoldgeKb'Ok"o-P
g@2
Qh  7/qM&wirk1c9'4?oS ^', da'j\tieqڡ@9of/`@ 1 (ynp2 (UmfaAudpGx *fhBedau (Min.): 30ѹd!t 
.S0%0czmswuPm #Ho@ojp|ҍubrKb+o: VDX%UnbeV eo3T^'rvo-mL@V T&3WBPohafQKAttoribuIDPGP\oc
urvPS.M.A.R.cT.1+ . As Neu_v0s}A Deat`0: Ja!0qst Falahjgeb a,frbW6\<qgdminp0<oҏb DurAg" CX mYg1cQ4is  n*sd,A @ Hqs "t.s Z	pJ1 5en bl0.@b# segnpfplR'sviceAaps z,Ep4'w bjPu ahp:=$Gga J	 (S)? Um\ Funx#=, m"eVB<n HPtectToolsc0#ty? Manag6lo Akd7!!HcA-n"QuickLockSMu0ndvr Ƃ|r qMcj`mV<bip1cbchutz  fq_g8gimr
Q(d Ar6N  0a\R`!v, lrS^gÚ$Wmeh 5>0)+  c,k]a|Fu  InfPzwot-<9Par e9ΩPDraht uN!e[ "o>k"+mjCD- ~AƩ=P5z+T(MLr:mnp(ÏsGm<4Criver `Fpp M[ " `s rG-Fs m{Junbr}a bar. |Ip5F,bbewrs vc],Ppp RS4 g p00g&NIcM, RסgF5Ek,  `P1 "B"nR*Gѳz	"0`pBegriffпx`d>Rautom`P>%J K0,oh)l*( ei`e 'sZfrk_`qe XtMSnT2SV:mVn OYWe	XR
jk@oo\uz@끎MJHsbJsn0	2^0a%u8x`q\,%ѿs  hAa3mHgI R  
B$̅S B	)gpJ0!f`  \urPn(R q.7 Escdr#`empf0jfA d\Qzu! rߕ%01d#4. o1 @@  .P2@B 7׋J-Bwnra
i&0t1Lant`̹Y JDIпAteEsc-?0IDxJ dШW'J'J _*c F100eI:Ffpg <g`ظC( sD @F0W`pqxMuBay@Xr`Ɔ 
k-E'a0
&(links)hȘz1tUSB-.=cB-6JSqu"CZipϫ 102030405060708090qNum-us-0t@#a0~n/Strg!t0#! E|q@F (USA:`5f0P-Zepa~BWiebss4unabhngp ͣqa/In Grafik-Contr|
2PrimSekVidGeo- ;r;<nd!Bidireal Grp@SEs gb_  Lfi࣢?b Aggr 3 J Egparfo,Ɇ(o)Bu0_E` t 1/OP'2ȯP'3/yToBQR#2O oj@/2ApaI.kb- Akku?
_  /OBa Kalibl/gMѿk N5:iualſ  o!_$+O#( OkO,!#+_0 &+'O/4O*' -h'_7~81,':~8.5Tra$s-- 6OBF<+EK@cLP$3obi ?8	MN8H OQoR85R1U V	OYoZ/TP\]5[!rpO 1 : .fΰ% ]dabqlooxg2peEntle dIjegkhxg3Qj 0jpeomrMo*wAh w2n'IU/bE`/~6P{rosor-ʡ U`
 Legacy-f #PadapBootm2倰zA
Exp--Popup ( .w) Wdau 
`pdP2 (ʁZp <ܰ Kz@ eComp0ropstn@ <F1=Hj?lp>  Foplys@V搕r hne Gtil0 <konf`2Gen fra]ل@ rXUtZ  Ignor 䑷ndrB oxfslu⡱F urvtP tՖFneдkP}hed Administowrad1sko3 Kdp aߩA fo¢"hP0駪
E` ddEJe-i PFJ6}Sm-kGod dels& f d`ndbygg`ds Rr rI'@fa@ks0	@&c Upd 0ļ!gXesiƃkطABa @
xP ¯d`valgbrHDD-Oselvv#tr Ԅ$r Avanct Spro_g Vlas OӮ{$ǣ첞Tryk p` tastrУt`=A, ESC=AOnnulrFpD=JaNej ", Aqd=M3v" Brug pbУ`P}e~  releP۾menup,tt<ENTE'R> deKαet.Qf `pddU ~: -> e MELLEMRUM = NIag<-DTILOBAGE@@r	KTABFfelt7SKIFT+3  K= AcceXK tXsfejlf k 1_ns D$od!	ͦ
An. F0	201Rq
no$ӡ 퀧plarakrvN vvek ՀЇ	i dzs_ fly@spgnP/McEUrE
 b uvetЧbrud#o
2ZvPmfPI rducpctyip0g#h ig8h#0trӼcache (L1/L2&huko` ROM-familiew@iPcV o"!	fr sr-contruoD-ba`y	s++.dPfh9+12_2334*+aPit-taцej18K(at)17'3o;3<P67.7%`PIdvar : DQd s  altD`holAdՙpw@o@@ / b-GdQ{dՙM, r b
QkqbeskAr A:`$#	Nb
f4ՙMLUgyldigH!֑tH  RngivFu4,JviP	!F\? iH?\*Ma TPh(Hur0%)ePOmf1)Zsl"  }(@): 30 q Qtc0% frUeudq!eR7@pwImn
:w@D
lP]ՂG2qUq@1	#qSL#	dtesrvB,qLsu0ribut: ID@tӚc.S.M.A.R.CT.wya.s}@ENy~Џft n|DeaՕ Fra}l eCA hQBPksCCo/ d墅dAϩe 
 bevi\]Qr Qd~es, f.@.@ram7A .U`DUǃ\me#rtabFata. Du bup Rfl!ɱHP"zD viGceh@pDbH@\0ΝrJ?0sr !}Ei HP "tectTool/{% Quickp;au)Ls-aamSkrpPrlv,tВcMLaaDsaOo HvCisJaSm`aI)r,dirA u.`bil`K⨊pAV3	l p~frardcƼOAdl0netpKnapp0Cd-rom-ǣt:IBw Ho0%:2e9qNu1HEMhZI,Ar Dt.  bB?RUGER-`aOVEDADGANGSKODEN,R!EM 5 alcgQ@a"s 0npt . @opa0[Tqed# Jc{ء/c l'&y paѣ`[d1hxa Zutomڟ ڑ byg	A?B' ok per3ma!an`#ig}*n4r޺@ fys.dsk Xnrbpc'n `!

 * *קRin D  u7%!mg, somhL La Oc˳ot. U"r'seD p0[c
\L	 rio\0HJ(C  ICbefa=l@kraf0%M|fDq0 wAT0\`pl . @Iu!\Y 	Eman
 S.-_R
bM"	d ai}DHu
0\a Q.Pa`tsryP`ESCp?am. GцEJnL or  ''gLep(  &/F10x3C(@pM	a铆ЫDcsic9  kD+k Osr= flg0!k& DP-bas0I MultiBay (0pP$ho?@hjAAUSB-flop#pyI#ȁCcS"C>rCsu?Cwzip"Fr|Z!Tredj0WFjPGIe SmjWSy2 Og NirK0cLNum -nimm Fn/Ctrl/|<EZcl(aisk)`w`egeen`ЂU!zst FuPnPAWq|2rm-czr Pri[m0Se`dWVo Out ParazSM TPjЫStrohuko@c Blvp@d t_&nr? compup|q0[PtrmF󷑖mstycѓA?H@topRa@bzfARbwEthPt 1c&f2fbf3cToa'Rfj<hjiɬfuo;huoiEntDgt id-nuRͷc@wHa<uvSЫďx yz{!Kb?uo~>p<KalibQ0p|/nd1igυU4 MA9@AO_ /ߍoό-R@boߖo _O.q ߝFߢ_;_<HA#gsoﭟ/냐߶ϫ-VAi moð[  @>(MEU)/ OoϽ !CмƟǾ?˶È[ Ta 1 : OP .p<% q]P<`nem5t2 AfrӆҠLY3 Genocӕ[[8 *̰	7 n???VProcessors`18DbV^  Legacy-freeMZNpO*Vt 4rA=GHur|Npopuppsink(sek.R!7552-!SpI 2b,(  P0Sp`U0 KonfigumasA  <F1=Hjelp>RilinjonpXs* 
s҄!LCagRt3D4k"	Hefras` Ndi!7 D"kq#@Brq_avsluaAC
,,lRf4oa%
sprogra`\ Od*t #paaL?Op=A9tNU@yrsU*ИsfunkR3
u2UPUtif0R`s H
--h!B
#n SmN [KC
'godkj  ֑aX,'Uneby`i(!x*B
i.tҿt0Tilbake:Qlfab R Ap4RJ)I*3! H*p(ag&~rkty = `valg@)DAlV	B
EFv_vt@4 Ak? T_?|@<5/=vPReASp;r<lg G AY!ZI_I|
BTrykk t!Q
A
@1`T @=H, ESC=AvbryИPQ@2Q/RA_pFSJacUNei CRR
, p	q eGr=MIR Xk9Nne2pilrX06@tO<ENTER> hv/du v0 G*Nt. Brukm[o]%PA:  -> e4r MELLOMROM = N@4b25 <-cTILBAKEd@rig>eTABdfel֕wHIFT+iug{jA= Goh@RCg\`sfe^Fr +kP!Ano'pE PP`C Mm kjresfuve@0mxEdsBuFxp Gbaпwfly"s' c "@={Q
saR"~vfull#r. k?ode 02qrduпt Nop/blok7k-mll찿N typՉh igƉ-gavbuff~(L1/L2Meng06ve4pdeo-	2T /rtSrocSg,kob5{3,oE1@/i 2Or3ϙr4Ddi,uň E`PQ
h( QP蜸0!O~EkUsAd@: D#vӉslr tidlgS2hol[ut0H'aq B/h0"e- M , BQEuPf s kl2a
k#nn 2 A:Urd׳ 9b42regQG6iسUgy!lsTSB@IƯEEhjbtb4ƾ? Y°|u& ignoSb.te?= + HCT@4 (R:)slr (): 310A@ugl0%&stbvx偶1:ᐳAutCUq*rSer  oxL rb )tRypurib : IDd01+spwQ S.M.A?.R.T.-VtR .  G!pN|pkrefAvWPbfaP %0w0`ikt ADu wOAPE@)	_AtasAOka0gxogs@"XAr dWQ
xmpe!lDQZ X`6*.345r2`Xp9.5 bpku4  aymb%c|ay@Gvice.Qt @)AoTDlQaQ!?UAv' @B"P\ps; i HP  tectTools0curity Ma-nr.-kKATl9edlanRypa|@Pus L|D!m/ayg+S@kgie> besk| ġ-"ȱ- u@[2X89Qy  . ŭgle u#`,2`aP@[ `%}. Kc
5mUFp --frard-R)Para4llR)KTrdl nPk _Knappt,S! ) CD-d:/22 SHo`yt:_e pcP@EPePU@ q[ho"cbBRUKERHOVED-t Q Rumu5R&1~eU@'1 -d:beႱEu\`5e ;b`BP !AR#Əa&u" 9E:v,p
^-@B&| `pp =0!ȜH45a[ automMD1Lock8:AbyggCj%=l>  man1ilgge	.? W@AxBo fysMad`w p0YFGw'V 6IC&]@KLcn˱}t1~s Y0dlda RESR. U°v omZd # CQPFUUpqM1~n[Y uB&\V nbefa} ւp	GtSPQw>zm ARkm*rq> sՀ@fL fga	IrA?H%Գ s`t1RHflansAP?ŭAƆ,x_ŐESC-F ?PA2ٔ!'6S'M F10t?b3e:2F`/5쇜  NorH6'F'Ore" MultiBaypE&t˯n(veae)pkoyngsba0$h9yUSBԳ#0Av61 Zikp-AQ A~<`PNum StBoFn/oCtrle E[M(USA)|`kekeen T3ela@)jZ tro0deoQjp*T2isrr0s tbs 0pti`A&Q̠m7 Ag ss?b'sty1o0%2 (	vЩboŁ? Eth W@fɡu3
oR˛П$-sѷo_ni|PXtifik4-Briaa`/ . yBmbUKalibPEB!esImpl`O4al p-O ioOopOi@ksp.//i Ind _Z/	/
 S mob. x<<o <?y
k= k[ yT: LaaD9.J(p% ]AM'full@s2)2 '%'+9(-)J-*)3'hi['1!n.?3[**7f1*  7_$< ;Pros @dnuT D"dޣ	U0PAQ!hcpCnd?raiQt\۩m1 @Gsin@z!hh (sekuЯrx1F12- hDvG1I.0Sepute P0pbConfiguracipe la ComPMadora <F1=Ayuda>~`rchivo hmNl S1cmaXQdQ`RGuC _pisco? flexi@rTacZNqmpU R k	aN@0stUgY+WZ+[valo1upAf doo[Nb_PcPaIT Ign P Wambioos y~liL0dO+WpG gVd Vdgd^e eNidad1N0Ss#ebO 7NWlAml icioOn=qkOposirs_tsuIDcNTHrPO5ަx@bl@PR6yso
};tSmqDCC SSoQЋeWc_<9rw Secvltyinc Pda EpBBX Euyu܆SY ^c3PO+Wyfb	rxa`M`ާxւ:ڌcq_nci~Automa`HerramiPaCNery3`@qabСA0_Ĕprueba HDDPc[ϚƇAO` rP^DPRQ^>AvanzO`cdi k`S	q~o	u񖿦| `Oprimpqui3tecPO~inUI=(, ESC=Call?=AcepF=SšNrQe, Cfoa=M4i P U~r]ch4halaalF  lemPo apOropi@0j<INTRO> T@z[Rz.n.sNP0_Utr Y:)EspNo o -> = PrxkRetro7cesA<-KNaEipTABScprM_ays+sC /ɀI$'gP8̳&gErr0ae7`o Au ^ҨB`C6S LrFjo uW3ҠN1ˡ>7. CdH201bhay n8unXubœnP``OACנ?eb=E0co&i"@ebo?ok/MEUOݠk )b6SQ_0NB?Q2)0pleOxitosaAe FaR@TA?til Ti ynV0cvlGpuQTamamemorPxh (LO1/L2KivisNROM 0milPATNp?riwATvzrV RrklO2T򭐑oOeFBG i1$Z2Z3	Z4 Etiqu
yrхsPd|
ev(aK
13Oop
"o :T%!sЅCAU?UF%VAdEB:ĐBQ:uir  oe_F}a]. Pbre[S]U/fY, in BS]sc #u_ wA:\][$OU5.@`к0TOqL]'.tS$@teg1o-S$*!20_vl_Y\$I+mX9P-O^a `co(a) P&eAa1@`a?nc,BC iclPddFLi fOJaKP~ӛ1 (Rp0l=)uO2 (CP3 (S.M.A.R.T.) ClcuCtie$͡jЅ\( p ?s): 30jN 溰g@o .0	%fObfOQbP5y ipauluOiq(rumAP_[r\": c3puAT1s_Fal`&Ѝa-~d_Servofab 102apoyaxAdatrib : IDŁ#҆ ex!Mhs	 RmZ.cmpP >:| nuevzroDPf ApagQE6S!`W%T3G~m:6evoc-oؐ!wala Opv L$n!a!dj![pe0A#Cpeq&| AZ}2` &ՀѶ{v,!^TFo,QwAi 3bRs&Pl	EAic"OAbB⹠b !xP'f!rt2din2N SByf2Ұ#lYa& ol0q;pSvT ,vq.Qoې   r0D?v@FPDA,aԱ'dqn!jn HPctTool0ii{o^%QuickLock$Suspe=n BloPpG\D ratlSrOb` #86 mejPG] @Mxspk!yو Prlb",tp',p'6^P*u iz.:Tp jreNŧ Pup%nxպ rojoպl4f#=Redalm#B!oQsAIGCD-=E5-$\/㞤xP5\:mUs#io:B렐zpu6pz?Ġmedi<)riveѤ@Գl tnSUSUARIO PRINCIPALCfo6_۠~manƀ p B p(. A gy gub lugpGHC`  Pzj`.(t `d̋ 2i{g3`q`&b?o@ @gg,;Vma |ݳ0ٵG@\orP!m ?`7d +$2ZR07 'uص/
  , fspm Z ܡ'ݢuCbAZ{#,5߿ -`̊ 0ru j#:iaaЍscu;b2b t2g 0&pn" apnFMdaUkos4;?ogrige 9oqenf`ET@~_ *lic`q2Cb2gre3az!3?. ϙ?k g3u !r `7#.Ql$4r#in1Wߢ[ Cvh t2mfiP@h: <ipQDponsB
 02DՀY, PVi[b ESC. B!'-xdZalab7''  .F10q12~2E1(:|&\yr|f  AZ |׫1y294
2ZWEspaol OpMultiBaP45fâ%?bxcot(CizRaPBD(߇echQ@u Bx2CJDw p@LQJSu``KkBJDfZipCJpmeAATeroK CtS 0}xPSpti@5OpvPNoPDPPl ~o Num0f Cues 'Fn/x=T=Ingls (EE.UU.)QKr ymm@?pl!~So!GleqsBJW} Q3er,~nteO1aQcO_eo Mo@:`  Bidi< Tam=1'memXa 䶑2i^wsifu0A %BLp CA!ggergosbpBF &?(s1Mior)mnPoEth^et, Nboo0)opn&s 1/tLu2OvLu3oxnTokR p"/v{Ox}ozEq1_v2v3 I >tif5ExclusA hDA l?ŊSQTˊCp29o-N PZc/NoF≉Fh q
ޖOk/osob?͊@???eF !/̛ 5aOϪ//kMEU  6E?ڎϻOooϺU@TRH_߿?r[/`1[ :rg.@#% ]0=/΀^ $<$2Pc|5Cple $3`)2,|g* ݵƲ:f !_Ԗ|Eha N1OProɒ$S1SrblQT@m SbL ]cy L<rran$QTpY^@ae>4De`/0OguEx EOY4`F12EY[A \AmbTouchPad !u.q^o Np"u S' apփ  <F1=Ajuda>`krPERInfo6`[s=o  o SfIAiA^`b-m1A !6iIRqr0t6 7 o padr0!#f Ign@l8^air`t6ss	f	
d
-aQn%apOnPa$v @ *@D9r V2*_`" a$(jT<!
S_tdMr\Ulizp c$^$Ir^ g S^Wc^9'I-Reto +e6hbPUQv%a#utag n1/(& 9@eP882jG2aTi^a HFepmDasPVbgF^i``S;@lerdOpU1Tj	9^HDD Ar =
? Statu7;Muj 0 F<e= Avd1aiS5=iofw@4.oHw@IL_essie qPVf0tinu V`=GGuSC=Cancel!V!RAceR"RimSN!S
, QUPouDP=gMai` Ugiz@sPB1`:c0d  o i~ aprope0:uPO<ENTER> t0me2jpJo._Yguq0 N0r u`: ->WSPAwO =xi<-dBACK&@eCEea*r\d&TABeo mpoiSHIFT+cjCQkiiaa=ЈbT*SClSEr:VP+<na&o,Vr7;. CϢdig]9o 50|NthtODo`1[v LysPii2:=tCA Atl;evunsf@i"r03otebook/s0s :59pmB:euw5x2Br:@"R&2m xit"& ]N  Til ]\|V&c8Pɍ@`< Taиhbcache (L1/L2Pa@]mށC ROMvi}sFaml<p`xsriAvdeΰ9Ver$Qro APA.=~1:qAa/B/5C x pO3hM4VtiQe`!p#馃\e厦$/(Q)ߦ <xήpήФ oήOq@DsecundaTAdvoert5: s0]b [QCe!$izcCPc9/ ,%si um  ?gravv@D3u8:tr	8LsA: n foiPp	N"s 5~OCtegiuaUō%vl ϩ9GIɍ kTPtez<BsejapEքL?/	a
 !i_	c0N ~fA?1 (Rp A@<n63@.M.A.R.TAceAxC f`(p?.): 30 3?A\ .0%УEbAuced2p[Q1&OhostR/rϧrr: I`kss!4pJ Z'FalrhP=aF
rp,mec&D`T0`Fsr%aFtrib091q`DpexrtexapaJ@b4s W瀝.ctiigov☂rr?blp GL
C	 U qVp}bFi@rrqigpT']'cisGgPP%  q
Ai{a^modsJRb0t faz1upW,,!_9(CpT]form!!K63 5 
&,(jaQ"Z.p}Ec`s01 usa erH.Ұ, @_Qܡ$s e3
B,rvioP!IAv@zr$P!qنQ?X?yurPr'"ad 4=is =M52b@KQuickLock Suspenso 7" u ~4S?pcbK%{ marm@ΓzZ`II 0]B_w
I.'(+Pcp[sa #>iibYTpuSseuպPExigL3tre7KmP uPJJp%ermeJ^lqFȢRetotq`.O>aCD-HҕQGϋNP=4!9ame:pusuA|: VocC  uDE1ŠruRaopDriv)e5'D Dt@4USURIO  MESTRE`+e	[4\ < A+q&
apaz). Aa-de-pt4z:Ƀis&q+bRprִ. N v`E&e tX,Mht`+!uP$P Eb6ZcaA P(tX.X@Є  GZ!H[s]!6ie'/D'=G9I֠(@FGcSuegsu'н@fijo,ks0HFm Ca*er $a p/H	r)suAo;v=P\aQn2ɂb  x'qu]{7 " }`V.gRE Saf
aGlܚ, ƈ$fY"] 0porpnal!&`e" -E 18bJratb ܤsubPtuCdg$-Ԝ? 
؛&<Qpƀ-l   b6h?b]BlP2%qPh]  Lembre1 %	vla@+@YsaquAiQh]`@s 1ye(R7 ESC@-Y4xǁlavA']'@4F10.0RIĒ="%r:MrW`!AM  Jugus O E >: Mult/ibayqwNTmM~cBBa baP'q4copl(`'+/LdiI%tDN0`B[qRS\٨zipPrimeirrcQpit9T`OvN01cp Ѐ j5<C0S
1_a7s Fn/CtrlJcIngls_ (E.UVXi siYDlPSrah`tro7pvdeۡX^!9cundDaXMogMPadr5Bi1KTaehmemWO-8RYO fu)01R{fpY"ec߅w CATere)ag2@qnerg01a12_?֗su<p%Etnet@YȠ/J3/#Token Ring O	/bO`
Idf JP4A Baa͏S%tsGSsHC`JblP8@XtgemnQS0QlqwCrDuploVted"#?Y %$!FЯ_, ._!a!#A$5760[8s63S;Al>- _>/?:@_3Z+}MEU_?FGBZOJED,HIPOKoL/SE#"[w Etf 1: R/rreg].ZG% ]oYc)lP- v[2:cZ'Y
^Z[_\[3: !w^EYdZ[e\*`iU\ ai?. п(#D?MH_Vq? NmercflexСqwc SQOH8Zςdap"aGRQPowpup Ex"`PƐF12 #|(bO }d1$s Varja N@upTietoktuk <F1?=Ohje>1 AJrjࡄtQt Nyt jTallenlevykGkee!契kon0o
Put֌ҍ֌o ]Chns Oh@ mutРQ lop1]YL ttPtדdp
ou }wurvisu0نnPvojan ssaMri; Kynyt֟k._ La`t9培l^	 turusnustߟЇf-UǩOt Wlyki0u 0GPo0n-uPkig]et`uDƯt֩s]xtehdFҼ t԰jڄAPmaincTyߔkaluдAkHCo萲K1iap Ki萒vytpɰX9OqtfqN x
ŁLisieli0 k rGBXjXJatk!inPllot _npp=, ESC=PerA"=Hyvksy~=KyllEi C, J'okua= nuolMimi`kh Psis⚑ <ENTEoR> mtىe0 .10n ss s?euraav0Uໄ:a] ->@i VLINP?PIN =@O"羔s  <-ASKELPALAUTEdrt<QIARKA`0uVAIHTO+gg|Q!= g!ڰTטPvirhAkkua eo9i Nda.ge: di 01kaТQh a0rt·d p ytk}eerkkotaa4 sipq 0lak!s ќ6skann`0 laa 0ikk0skeytyi eniP@2nr		o¯am"ji0~) tyypp	n'a	llVlimu` i (L1/L2~M2ఀ  ?ROM-P#otepeIsarr@sisstohjarT T Q0gkoh@]1:|2# 3o$ 40%I0taѨbIo!d)N(j0oa)"($-%`?/&((J䅈uqkra-5o@s: Tmńaat0nh`9. J|@t luo Npus-  n,򄀎irj7on<! A: L2?C@H? @Qh0ꀷu@ QA#?RC@1=B;$?``paBPlA=;HH:ko!Aipa9ʒn?ǻ_KÔL _r0Nϙ  %QX?3Q1G (N,V2VW3~.M.A.R.T.~Arvi7d0  (min): 30s fC0%c!tVo󨐲Is ysi 0_	`V#V!WsPecuy>UcK=ThdcServomootytfLukuL!Qtu!ΚȄPc}kp6ttrib@tie0bc@#rk`At YmeK	e@n .sa߰9G UueVahva ̰t P7ǔsvgw!xB 6 dBqArQtpвy=a	 u}-`t7n N okkؠ>
adan! o)(n7P[epauw@ 8fmys   `k@!h@ qeP:3fp5pL@7:Ϻ0i@=j:J unQ"n!ypA]@<veapahtum7;idp`\fO,aR\ixԒǀtii x7DdHP PectToolscuQ栲ge?r -apup
A.{-X"lQuicUk nhlpeСDQ`ZOpraTQ-τʇseAkD @/JiT:d90:`9yh@kr` s %dP
q Ǆ.06@}uuqS1po}rP InfrnR
 
<ApLangSf"Tto2! ҘinikpkCD- -ll:D8ń8oR P0yj0wAiots=\n D jeè(l$') -.Pв KYTTJNID PSSANAN,ӶCb [.egaIc@silAtcurqp  r0u<#At V-P,q9pLupEVvgLLA8gѼ8 !Oqe>Q p
  2( suaGZ(D߰ɇ,t0y  FS_A fفځ2  I+ޗ%" Щ. Nyky ["CC"C[ ~EsQ5FMt'Pq. TtdPBp89/ Nsiheialku0?Xehf ԃp`A@܀u@br=t $ta(@ /AaiemP[|fמt%C. xF犁m ЅVdwtRp Rps"э*ɶS_4x e@rP_ f fo@!::38?,>ESC-n2`#:[.n,@~}'
'c/ F10/@z~3d(aa`P':9 P7 :0!(x]miy!ysFn MultiBaPx)@wlAlakoi@ ( ,enaW/CDDoPXUSB2G G2GIBAGZipHEnsimm@0 
Kyo eljГVi@K{eit 2 MKak民 YOMKym쑐Lum2;p܀zVai Fn/Ctrl/mpa((>Eng0ްX(USAYUsPN ~s0{inla 4s)BGsWQ_SnqjЕJsiZ!
sz[V@olhTt WVakiIoNsA,[N t qZ`@uupSQr/a0 h V`#s  jp0l(6|@1i`0H@h@2ijD- YE (ylosGmnpo/k@Ether.Es Yju%vmow%v3yEToЀ ]g v|}y}o{Ework}j Ąmo/<LElivQ Akku!>TAJa`_t"joPlibrWu 8:EdFљ.ual0A-ߙ ϓ/?/IO_OklbϦ gk.E XϵϯgϹ0ϳkNvao _g˰-Eܐ'aa)nuskPDľ oΏϥOoӆ FoЏoߊ[ JRe}:1a@& .}0>% ] >`I2Ē0lP)9ur "/Ego3/ e*G Y
 noumerP	In0"  SpeedStep  technologyzkG&gacy Freep>4 Z"(fkp^qvu&>^P,pQys"iA`g (seWn o@M@5:@4OF12: 3iGPQtappi>14koske< 17 pmma0TK|K  Ei m<n Configurati`ord/teur  <F1=A`M> Fichier for@0	mPAffage oSauvrder sur disqupee!c uR"ar `4`'une..h!ePgals!# dfau0To!& du'Igno%modi0-qu4SQe lG'in7a8y}*Jregb/*M+0/1+, SKcuA )e #ss0dt2%3686,Te sousK5p8j9;on.Y46 priph8 Az8a su@ML@MID)8'kD6s9DrP{83/GAHW@Sm@#CD  
r1<PY r0̲,p&he0z3 Q  .<,aK KPB<Pf@tgre ta) yC,BTAKT$0#am3I'us0`/LOM"N5$rfrenc"[H=][G p&trAOu	0D Ulonn!Pb eriUe*f sle-c1ndp!dBps ) )Ah$2%o?iXjE2U+f,mBuhT uA cQangA? Chois, l3r%i,dKr  rHkJts]C/uEv@ AppuyTq tou!opoȐP u0
=Sper, ECH/AP=APl}@=s}~}Accep|4~0=OuiN_Q4, N/'impP,e+!t|=rP  U	z2%|s fphheAC}m !r\`,cle t )uAcer `bri aq+{zq <ENTREE>|ҍO',k0@#%suai i|8  A|k :-> ou BARRE ESPACE = PZeA -$ЖIE𖙗precedM|TABChamypGzMAJ+ wˀ
_3}0srr@ =ve Il jхssib 6Pc!gf UӦs'jprod49end,W. CoAt'$01u)cA|gn ѩ empla3ceL'0hjre+@?@IrgfsbBPaccueil d R`q` it!xOmobi@P,aW4P:Qu@2/F2Bema wru FacM𭜻 TyQp>0asV8>@wDbɳTaca!o(L1/L2) Vol0 >moi`VerOROMmNumrocVhɻRevrRdp e1P}r%,clav!ϠDoAatD t{gЮ؊gHڊg3o4uinv κ0prio
⮛b(te)ٿ ?OtQBgE'ePdBqe`,>CaȂjep%vtru!A%qi!
I2qIpX P}T#|qV /,[Q,  -`zk [noP(roT"\c`6AӶ,$AĦDL$At:P tro0 #to  u>  OkB%'a/# I
 :pf`:/%E&
El-v?ЌQl  OZ(I?)v/i4?2+/e?T0l Tj1 (rap)$2 (co.`et)	uTX06R_im`(P:)P30I#A\ }s .0% qv6$r$t<@l'h$@T`P&UX-Ħ:kPc'5Fl/`cT6nun2d'f	2Bvp
4 	L P|supG1A0ibP413: `D=Ħ@^Q l;s S.M.A.R.T0Aban  .@ AaII Na,0	A V VfpAnA	sakj+A, Mar*` diAn{8@@H!e HMPq3ЦcCRIvAmme, v3CQ@Jad( obligatÊsJũkbdTE$\MQ pePKaU!]y s'	,sA[@01 QrZ  form/aa0=a msԺ.8r oRwZX0Xq_".$1zTTqEqjsis av@ouRAH)rch@XA|ef0@z P UfSȁ@|  q9lrg(!@HP yPP~Tool>e[y Mar0OZKB ԔZ]M
a  ckLock#sҠ@4!@ari0FS]qC,]re1f    Tr!>O}Xa"Q,   h1$FdZ_)`  ` LA'ianuTrr CIЇdrai@.'b1yExiyPn|VupdP9S  frqacllǼ+ Rs!Ds~fil BoP)pʄ CD-X'E'JpalaJSrR:op	$@e Dri;veq. Shixbihndez 2deux̉(UTILISATEURPRINCIPAL)j$U0c`Br^D&bz N xziE 6@p01QNsr !fyeЇrcelur kordinW. AA 0BHPOpQi{/' sSͨetsS`Ly{HHy 4"=a 
saoqf@B [ P0')0$<janiR U%V'Rѩ@nr,"=c0 Sfy O 2
P Qcgډ8bpEuelIbú
aғ! Ac,' .top4a ­:O !BX"[ ѱd'oroiginIlR!v b`1qnIa u8Tfvq`&a)	ptpb@Ui
OdjAhv 	!s$0p*PRWUeܲKO)A1$@a`Nprntyb{df| ;_on: tx0P&9a1,Sn4 -p@"abt)@9`4, appuy q\0@6 ECHAP.sE@ʱzK&'', pui^raQwF10yTap  Ӎt asǀ'Ej	*F_ranaOH&aC.0ibMultiBay| DHX)'(soc0a(ga)o+,-") U bF USBf3*3Zip3PPpC Di00s7Qsua`7Cinޑ7Sixib S9ez: Huؒ:/Neuv7D97Mop݁ num|' PermPrs Fn/Ctr0Cc %Angl0& SA) POphOoґm(гs =Asstan00xhn2d'3pad welQ{trlÜ'ichLer@t@"mRw0:dI`ipidoBidv2mF1 mm1SJu JJV_lcR0jr
al2/u Gv   `Q.(1|blocC-n x^OU )2V
WyuP@0)0ccu Y[ f[\BVY EHtJz\fa 1J/bBc2cc3oeTok@Ringc*h_e9hg Q hmj,mlIdu4ER`aо%?u^v
R wxzzPht|vl{4o~naCrepoXAbqQLtY!]Du@) *?Y?_rXbߒ ߐ2^soM /ϡCgnߢ`Ye 3.lTrtex
sASmoP_ ?Yׁ߲1 MOo﹏/O[awpe 1 : Char'9.ʠ%% ]%԰>ӊ2PD Gʧ)mˊ3PR EΉOЮb*`	  a ݚ?ڽOH?ƿNumr=oroceA)TK)Klib@Legacy AmoraCc`mEHK ?Retardb-$expA) DPA1qF12\T)pos0FfBi A3Bux@>aPQt1BL@!Bcun I@DzPFQl> <F1=Ai>qnfo0
aDema#l)^SalvaPl floppy$  ?ttoR7ipr	inP@((isfa(
 pp	tIgnorQ!dred ?esci E	'l'iYPz1&5i&

pRtupc z{zasswoeP
am@ ratoIF!%Qcc#z$?Q&svos9 IDsb2$L`K? Pr a3S=t C SupQop=tS2 	$#$h#AHg  R9(X*'+*WPi fabbrS$	nziQk%1ض A%co*ruQi CQbEbBta9!9pRl(F*Op07Yto rigidJAt0Qa(=>+p;J lo¥
A; Avapt
JLplu; EN<vviJ-o>G<j!HPremi q@siaQtaspperu   =F, ESC=Annu@CO-rOPPAteP=Si3TNPEP	,MaltN=ApqWV5Q" Uschiav frecc;Oevi4`v  u ap .@@< M<INVIO> O@Z`'He.YiguqNiN%`  un`: -> o SPAZIoO = Jsu{ss>  <-doBACK eCEme c4رTAB`eCaPWfoiM?AIUSC+yjiر!= SXiP8nCQoErrP=c89  Qu=hCn`pu	se`$s*i  vxp; 	!+un erpp"89. Czq\'w01 N@uCPM=0%lloggiao Lx0@Z05iłi ~wt4As\agga`_vu+b  n@.bookdㅡespa&Ox99b0.0^atq6vwxz2*s*9riu	*)du`aP} N4  Ti"m"QVelopISteppEIMisca(L1g/L2me`AR`[&ROM ?Famigl;QeaQgq[or&AOrol1lO#ARber@} ]C1oC2C3oC4 P00@Yf
C]ePf(EO)	2$ߴ3߶4߸aFponSdaA:'FAGso:|U8gger  sPO\biQxOre/r8=, inA`Ofaqvr sc@75i ؅A:wr,YU2A:tB]aono	u*{h؅ Iy3(a1
pt Nv05ddr),dI	/y0ՀSHSe@BvoAa ? q@0 i]Qre?p6_=o T=1 (Rapp@)C`letjti8o (@): 30|co 
.0%B1E"4ar |+A
h@
r:#0sa1 v EN @UՌav0uv$Ltus1g>rib7 i.gol T:0`ezr҅an05pNde  CR i S.M.A.R.T).u3.qvZ Znuof@"6isCf>(
@E>AES`EXcamIb]k
d0>@A< ~K	s/p@ u	bH0Lc\Am @_q`A
ހ	|Aus
tРH'.mfu 5tm@"ez	z]B ᒣl2V3.qA0*I0]oP\P-erdp0 8Effiz$soBin  ca28PHv}ipaEsR'"(des[HR ŗ4%_!HP  tectToolsI 	KL2A #sickLock k^ kspen
B p)mousq# M] E݈53Ol ,AP   )gra*4%:e C%C!l# AV,dCsmQ bbG,)arp7i li !R3+ ؐQ"Aa#Uinf ``1U1.0YeRAw0lЃ PulsrGYo CD-R[eSuV27sf@0pU:H"A`R 3OTǥuZuDe<. De,Hq'2 ,b"҇'UTENTEPRINCIPALE  rP=`hOca ЇgmanA6fuo.Aqoa0V `2	Gi ߱a0Ԡ|0QaNAݠe 1.!4 R|nъ4.zl0Qu  F(nkh,p`AԃdqPsb=b_kHre%h./b| yB da"oЊPEMfTNd HG(FEt}	w Hre,@|Al deA- vZR$nIpr~vqluogo $ Jsrt u3+v-gNSBφ^6,A6URS i{)i=}G.BHǋ`l*p&s2m m-!2vΔ\Bd  O 2 c/V*(1K 0ңjc)Z mga1pi`3 w@ސ A" Zt ԑ D&K1Aà`u%92Àm_oŁlpDc?>UR /qud23.9l@@S1n䤂 spςnQz1P  Pq)d,a&m@BEA>o GESCF2's
N]dovArk 'd'poR&ymffF10.P zQh!ߑlk
_ TzF~eGٔP1I i  O(1#T:X|t M 6iBay sbaP?A"gga_ sD) 1hi USaBQǋXSuPhr`kr#XZiprP oA`5 TerzAA
0O}vP
N@ec!ao = NumS#TA16`OB> Fn/Ctrl qTT>vIngYe (USA)Q~iuE 
m1pl@`a@0r 9t`%¿Cpl2-ca`6``1*@=MoxaW BidUCapa memm aL-emp&GsBQlb,"tZps0.m\@"energp1 NEJ28Bda4H2&(q@o)<zsP EthPSet7 18
2
8
3e Token Ring
 Z3 I 1rc/0/s:tA6a!_ !"@KQ$%C` b !s#$) D ' ԟ'(/. ޠ+uDu`Tq1&/' 1?6*+/5:.0 G>24=Co78 /BG;-0_o/H_@ ?J_KPDNO?H_Ia lc?X_YM W\Q.R[/aUI5mob,S OZ/dOemf^Ohoimf clm/Zpr/sk/uOvMso[ P
 1 :0trΤo .# % ]}comp(#20~S~}N3 0~r~}Ɉ*B*5tC  E!89_itOz n/ym{uBϠ
+Av  FloppyBF7legacy A QSd sۦRR(sec.)c vecЭF122Ӛ
`amb@ʦN uޠup <F1=Hjlp> rkiv Sy,infotPs ]S pQk:kiguQ|stll frnϰlA ߢn`ar_d Annua nyd  och`WsluA PanA Sker  dЫtrsl  Ka2Ārt-En ssv(ƒ-IDzĂhtQ~d-Std frPut aav 'ѻ?Ѱbyggd Ʉusi׉>Yabrikp;ҕ|XJsbeh \sktsrktyg KRtr v p
 SvtP QbHDD Ak@6甬pО@Tljr{|tze>Tryp0fri g.@} nu ѱN@st=, ESC=Av'bryFtApa*", V=Mer pv  pil$Հa PyAt5<RETUR> omtt.Z eQlj eer  [: -> @SMELLANSLAGSTANGENTEN = N	a<-BACKSTEG	F?regeI

TAB	fl #KIFT	+#
f?= F?v!fel Det g`,s k St hЄ` stod uen. Felkp01 finnsg咰pplat0}`tŔm krv  ,{@0}pm flys t  U-dator/ exԘ'O%p"tidig 2,kl0T  kxNrd,1S  P5, typ*5hastH5g
Ca-/rlek (L1/L2) M!S9 ROMPҭ";familj4enummnpdeoA,;t;$bpyrR'H=pNR 1.AB2_CR"3D"4ZFr<rB'4inv`p~CV (b)'D1A7D?NEOsG<QSek 0PхVar! De#3QƠ  .xnehз"$rsWkap "/W!-Դai-kbqt[+A1:!î K03hi^Ir-]^2\skydda+d  agDZZ @ZZ a!qG  ui?F0ig﹄?@q2r6Tu=1nabbpMv fn.pMU/kPad kT7d (`):g 30HupK0%3vl@ .sU}/pp~vrP#F}a&tZ :@Uq)Okp2_S]Cer7vo-Lrɀ-0ޠBVVdpttribut: ID	`!  d grr'.M.A.R.T.-e GammAGN(7 ifipnZ ֑T L s"EA 0JD(vA?lika mp `SՕ$"  2fInő?ŵkan orsa@mtzi )*m[3AVyp Կ0O!m 0mslalo`. g@]a om hglmtjehselse0лreSsu1iuu  зf0u8P#0fun?8$p(erl3Wi HP @5tectToolsvyQuick1β tel?ge L)@2m Hgx׋ݣgpbrcg-äѓ@5٦Ӫr ngo2@ƕbli`sR͡a<@]t. K %ompi4 Df@޲Po6b'pSTrdt3 naspp (CD- < 09}^Ւ Rf}Sc HuvupҎ^ : DWkcZhrd4ed. #IV ANV>HUVUDƻQ#c`d (`maVnt w. = a7Ѥ "q ##Yild frA`a!* ݑ {d1Yhq   lʀ/A# Ѥmw.ڿ
  oQP(!b
bycggZ) g0Ĉod@Xa*- ¤Ok#o	mSc ")b0x!  ēasr6Фlr?ktu4aI҈Q#@!fa"nќkh
2.ut!Ďctg3s a蠴VoмѤ@ursprung` (h. Vi  rekopB0q4l҈ r`a (a#qs")b. A_s.QW!XdU '"ǢO 10ӠAgp7!g`!#q5-be0fpsem ih[Fofljqns .0}  ESC-?҈rYƑ .rYƲä֑!×qk3'&'sedt!0aF100pC7,a:ش@s,=KSJy rиy:HM0iBayXHV0GB (@rrMDh±xSBeAHD@H Zip-#01Fjz1Rz\_ttoLNzKTMNum r,ܑXVxmFn?-/Ctrl0@}j7 @E0als(USAxB`kdAHa1 byrms0ntroޫ,j0bbel0d0Aorlekeo`(ne Flk azcZ!  r2Agg spУmhaUASC-b1,d_2`)vP+_,p FNedOboc EthE4`g @ `fFhaiFh3j/n ToRqh mjmlNCӏnSdspurUnik ZAt\xpFѵi@|{}ptus /O Sb{oKalib1@o4bAO?F<ZDualq_ ߕ o&_O?//DqSqs?ߢߝU?_Htag ﮘo߱oϰOVE %!moUMxz/E oDG //،[~epn : Lar .cΐ@% ]p@m0klar52uDZѠRλe53oAm&Қ֏ז*`A3 a^ ۔?t{Ap Hbra  Legac?y Free"OYOB.1U\1sagdapUlJdrjAsnabbO (sek.H95F1a YGTB=d5Styr1aKPTpUg{eOnD@R1e`(4e_ @M`wOpHe opslaan Configupo  Vanaf7@g6W,v1Apard`AX`
3 sscYWijzig3neG programma 2_`wSetupF zQMr w XIsvei|XBeheeKrswachtwo!R
= 1Ox(+ AppPW'atb/g<d ID'sk+!`'aw!+SmA1C, O6uRA zcRmUjOBnGe 2]
0<~ g_%
svzieX?%#FabrieksUugzqpwOti "Vw ref1>nieuw2Xo.c > Ex=tpKAccu2 eP (@>elec%ap6@.p@s ( zelft a=-schijfeiPUAc@P9:;a6@~ D@&! ,8p6 w
g!%eac
QalQ#al8o={E`?REH-uk;@0g =SD, ESC=Annu W`w!MDLN0=b`6eM!MJaQNee Qf\i, Aq.=M
 h:NHulp~b@pijltjKgebruitrd07jui~pnukeuz !ark5<ENTER> ind`JX E!be
@volP (WaKE  09:  -> of SPATIEBALK =^, <-bBACKbC}E`cVorigd9TABe^vel%~HIFT+`h0fh= i
  94Q;gQMlvNT7fouta@ ZrBkp2t wgeC F0qr]etijysvoen. tco (01qaKil1'mu  wep  Netvoe jre`YS=6`~a6 d/bas !Kr@wt n notebook-pc/ARp8  Tiys;zpR=ujbe[igdsu8v2 xp@hA1Q, rt N~mvQDypWrocessSnel3A@pp}
 Om0e (L1W/L2GuP_capac0TiPqROM-RevisPA@p,numm! ~  He")gavQAvideok Pq 15_b troP3ܓY|` @L͓rB1rBI2rB3rB4a CPisIRtU1wje@f~*?i(0)^0dzq)%Ϫ 🏬pOL"9SecuҰiT"9Lrop: AO0trt[ aP3s e77gew`Y PwRKbep;r;P' v[ d A:W`>g-  /T6RZXRǺdepbr фoffApGaK6!|\6wd A!C .wo@ܐg1tK_
wo33Weru=Z Yx wiltH?/IbbaS?_
ӈZt=|;T1 (a=)2 (U@@X<))p;!yr졀a (.): 30p!UTچ.0%^toofܐAE@|=hobroXXa:=-r1eC nb _#q"qvo-ilees%q=# br.42w|;b |X@k:`cvSA0e S.M.A.R.T.-DLAp'af X.`9ud@y2:c Blo\c<  AaS `ҧwbr@̲s 1k
qo"}p= (Pmls   VbrV Z.c]is b Az I 
#mki, rmoijkoT9(E[7 zost]8*@pDvorY?/ "V"p! fT_,w-,L UgPӼ@=erlouZr2we- uW
b 2Є1f30q.houdpH 1RD@'aҠذ TOP$/2w(LvuQ3p*\ |HP Pr~ctToolsHdFIDPpa ل-`g0-a T%3 Tg[mPY/  bPfh$?grgtzb  PL  e!rps%,8P[  aKApf kt`Ik
w# saXbPp[Bz3Ct3p!fraroodH Par0tH;+D Cdwloo etwp KnpL CdC-r``G3ON|6ȧHoofd9GDX
  U10RVAia`M!L`|QiqA`zow-HOOFD-GEBR?UIKERS
pu1U  p93anD SCFcZ  H
pwpc@Vtw fyk!80ccomp _@[sYs!rbZL
rDt $\V"P 1	gaG |Q.T?pp^UAAutom(cWW?Z2;\)!en r;1;;_BtC  \U^"EaPz1:b c. Mo `
_7x6B1,`   cρ@k128_~mnt 0AIAopq hui@| 0d w2wasAn_uWLhggea25`8.  AnvlCoe}`k1(1C7sn HDUr ra!e``
 to\Oi	 gect.  #O Fbޞ. Omun@BA`|fpqgol8AZ. AU V,#Aҟ"hQѹgWp5`rukr<ESC-0! Q"AFDrfW d
'fWM'tyPnk1MF10pT  ld6Sp̌R $k!KW
&kF  Nel + g1k MultiBayeVUeFd`vQ%base (0ks)re+ OUSB-UQcNի]հp-K E 1weq8V!8V0`8Ze%sZAqPNStatu?s Num 3Fn/Ctrl#`kwiss*10@&a]݁OM~CijsappIb1.OU% !e 	 HP8n8qlR`Bij`
Veo-Qp+J_ddiPtion  G0IQvguV$DntilaAt%&DpL dbpIk`nrgieB1F(bote) ?Et 9L 1
2d
3To1RQ%  ҟLo2?x3# Uet0$cuA ď S3Da~Gekaliї/K(&oNeKual Ϝo'/ Uϛ!#o KB!ӗ(0%?+' Hแpq=c/0,_2|Ler-MUE-o7O,89.  RaՏ<>:@o=  [Qp 1 : IBoc!e.G@% ]!F&GΧtooI2IntRGEKnGHMJH3I4GE_SxT GHUVJ*@[JBJ  A[!:0]L<f &Mod zb legacy5γa`TdadapC& p }R(psec.)cxpop-uMpsn Ğ@F12 )gh)0bb` cursorb@uQ EasyPo-muismG Rs[^̃ZbgApviSETUPj <F1=wv> t@C`oVXesɊւs\܂`otps pfB@sNɕ  ݒu/vCwuvϕOzhyĂGw{yfrH rgw  Hoד@p%swɖyXɿI  yPAO̏Ԃ zW܃ pevaÂ,t}=we'{8/G`pLCǗ҃pj@s phώCdCIvorX ɍ@\̗L/ly%sIDsID_ hruB|N HㅁA z͍ݜX} pg J+ؒ@p۟@pT|؍̠\ r>ɀrpFX a@pMc prope̒?  Ia汉ynv!rre@spIv sǇϵᶂ&y AspX߲sRu; ڍ׃`obutО߂&azuCHڙL[} Qj=ᲁ_AEsc=o@Dɱsa~0=͂#; Ϧ  A͡A@p2˒Ir`o\ Ȏgp}joڂQ0rqg ɹО[Ed]	ջz=ȉcwӋA`oo->@sy po[ =   <-[BackSpace]xA[Tab݀rBShift]+AO`jmFo[@  G[  @pnł zsr&p 01 ݁W }ɂACOs ڑtKv}FbO Axݨ4mAtP MEU﵂ȂAoOg2tIޣs{ɰޯ   ۾ xïݸ  iL1/L2qg>OMrW`̧رٔ   ޼ޮ ް ۰߂ްr	@ ް7It  ޯ`IG
2>3>48% PŰ(Â)
3~4J%s@Jo_x:bsƁA!N'| ytׂĎ aw/{p>쐬6A:/݉'|b>v}/| ) %F ؏+&5- `e&~ׁO#1R 23vԸ%(  By2!Hw~` /<'`o܇o@/HC@1iNrPq2iSI3 q.M.A.R.Tq \zsԁij: 30gK W0% !M! OK z1 ~`oPf`o:*pKSm`cQSe&WT p={Wǂ(XTZTu}VsAFIDJ."^Q .a@1IV <bCQK 
`4A`owAό@wGijdA<#kvy-~r߼䃼4߽ 
Q2Rd 'ڠBкŨ Eewؒa`0tȂ&'9Eu"ŌA !^"*tY> ꍇ`i@X{8Pk ٹ~Ƃ`ע1Qtd"ӆ{|A?rĹHP ProtectToolsا}lWŒ";"|y e"SH#*hu`BT@h"ȃ{#nEШu Hhs^y_z#Qی삟i<be蕴`"A@`Tutӱ~8ċN8tv©AԊOshg.ufȯܰfE ? CD-a) DW Z} ^ e:yU뷁ꑀi`pue[ƖSFu[B`Dȵݸ⛻ + `zPk͍T @q]Eu鼜ҰiЄpDQ𑁮͎w WbR@sQԃ^S^ۊb] 򆋭 @oae&Fu[}̄/ t~둑ћ`P/y򐶂D`ۏ؊wԓ`łԾ͗L Ȩc@wły 8)+Oe!# E`f]KcsysAo'srWqΫ{  I 8)8t%߿s	Sbg hOatDȢɑbAf[ƈ)3 fbɉe; ^p% >f[,?|j9ݪͪآ  'χ0aOȑO1u[ůCC=!lt
oBle1wql ӔCq
˂9)?u"%[Esc]A7b]ȍ~%Q(C1_">듂DriveLock  t[F1	0$%%ΐn@w + %-! ĕ8
#D8N?i}O`E!': 39xQ[b`O xPXh;iǶaK=	?E?USB絒BZFBXPpP(D Zip1Ԗ U2F3F4F5FU6F7F8F9F10F9ANum,#~ Fn/Ctrl2%̐ؑ G`{p (USA)졐|t"уB@fo"}XBKVaP\d#Dv C7gP  [w} gZJ _UrDIoܐ CdWoU QCYǩU rOڑ͏̧0q#u g?ȓdCR:;1^4?2/@>?bdx`EthernetOdMXg 1h6i2i6i3k gPN  d1`mn$ap3q>lفNi+uk+uOm>{jn ID Pba7|a7  ~$ǩ |}_a\/.`f Rco[߉u ̇
?.?_u 7?zlPu_l
nsha o.uߘ6MEU?ߦtO oe-$#B? _߯TQZbv1 : [d .Sp7% ]A7/r׮82Ov
3IHO*` a @?_ d/jqTT isoPCIntel  SpeedStep7 technology2M`B7QtPQWXu  _@S29ް Ӱ? 9@Wa px(ϕb) -cF12ݎԁiCb"d͟OP * 8^"`bM
ZB"  $P~ ?_ ?_ ?_  ?_	
 
?_ ?_ !?"_#$% &'(*?+_,-. /013?4_567 89:<?=_>?@ ABCE?F_GHI JKLN?O_PQR STUW?X_YZ[ \]^`?a_bcd efgi?j_klm nopr?s_tuv wxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_Ɵ ?_ϟ ?_؟ ` a b c d e f g4 l>         P  	 
    ,  
  F      n    `                    n  - .   / 0  1 2 z  ( )   * +   0] Np% p, p ]]"]r#])]0]b6]<C]RI]O]WU]0P0<BB<>"ވب﨨0`?8lƀv x|kv||޿p0p|"  "0   = ~ =$$$<   DDD uOaƄe  i  o u ? y ށzA0 E  IO vU   YN ~ `' ^    y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>	( )O +	
#'?

({[)|+}][{]}'@ (#^
()\|+y~ z# {{ |[ }| ~ \ ^ @ ] } 
&12"3'4(5-67	_8
90)aA0
$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {V-+*'(Mas"$?|  #9$%+'()+'*' (	!**+-
#-/)*1?2
\,()|-5/07o2Џ3
'5 -=
^~+]}@`)  ';+(:*[{s\_}\|  ׫  ]FFFXg]GF(FPHPHF\]QPIFFJFGhG֐G(W]FPHPHPIJzPIM	N
  ;ހ?@ABCD!: 3 ] aH`]߂^]W\c]e]3VլPW6XWdO] _ SUTUVWeXޓ27 Z[dQ 8 ]U	TV2WV}X*Vb KWjXWNU^_`a5bcX_0 V`_\]hhhh]]PiPiA_ {e( A]( 
kjkhliljl 6 :g U^0gށ4ou4o 4o4o 5 	TWV`4o4oPsHsV`F10 Setup Imageqv_SET/UP  ޏ4o`>j 7 u6pU4o4opyyU4o4opy̺y%4oz27PoIs6pPjt4En(
`V`o#nR: s 4ʪn|0V`TRnT0u!"q$4!6 0*sڔ۪xT]y27 6  VV`  4o4o4o4o4o4o4o4o4o4o6o5 Q6p27kCoU` }	05 PX'E2	p\e@ߔ" I"EҦ?ZpLУT]T]>T]T]T] 4 Уs
4ͮ@Ooϴ-ЭUУV`T]37 27 |27" 
Z 4  vԔC  4  U@ABCDEFGHIJ/n
 aV`!T]"T]#T]&T]T]'T](T]+T]0T]sT]<T]KT]rT]wT]5T]:T];T]1nlaɷODЭITjPs0V`ޜ4"R`Rd 9 J'l4m4nRЭu>WTWUYbW0aPWUWW~WhWUPYaaaaWoOeq*OrOsOtOTOzO{O}OuO wO~OPsP l>`jpl>(PNPfPPꞪPPPPPl>,<Vbx쌪:
l>*F`P<P`PjPtPPPPPPPl> P8PHPfPrPxPPPP
 6ZxvjRNrUĐؐ^ 	l>&BU^pUS
`<Pd|l>>^~^~
l>2	P	f						l>"<`pΐl>JZpl>$P@PfPxPPPPPPPPPjPPPPJP`PPjPPP0PPPPP>blxj"PtPPPΪPPPP ,DP\jv䦐 V     " "h""2""E! $U|$$Đ$$S`&n&&5&&
'Uj'''ܐ'S
)f)z)U))))5))+U,+J+h+t+U++++U+++Ɛ+U̐+Ґ+ڐ++5++0U"0*000J0U^0z000U0000U00̐0ڐ0Uސ0000_ l>66.6J6^6r6666J66P9<P9UVP9nP9P9P95P9P9  ;Uj;;;;S!=f===="l>U4>b>>>M># @^@U@@@@M@$ 	BTBtBBBBBBBLB%`PE8PEUJPEhPErPEvPEUzPEPEPEPEUPEPEPEPEUPEGTGҔGUGPEPEPE
PE&PLUPL&PL,PL@PLU^PLvPLPLPLMPL' O^OUOOҐOOMO"( QXQUjQQQQĐQQQ,)TTbTzTT5TT.*UUUUUUMU+`6W:WUFWNW`WpWUWWWWS, PZFPZXPZUPZPZPZPZS
->P\RP\rP\5P\P\. ]~]V]]/P_P_P_)0 P`pP`P`MUP`P`P`P`MP`1`b2bU@bLbbbrbUbbbb_2l>e0eUHebe|eeUeeԐee
3cW'WANPh<Ph\PhPhPhPhPhI4 oNoNoբooo5Tq@qZqqUqqqq66sbstssss 7 u,u@upuuuԐu䚐uu8x$x(x,x0x6x@x^x|x*xxx9`P{ՆP{P{P{:T |||А||;~T~p~~~ަ~<cPPjPPP=`TЁI8ЁLЁhЁUЁЁЁЁ5ЁЁ> PUTPtPPPMP? r5
@ 	PhPPPAT 퐉xؐSB`ЊtЊЊMЊ
Cip5D>PjPPPETi>f*К,F`VftАꐑGN*jr|
3IA44"5ґE7HМA8vМjМММI`l䦐J\ΦKʦLi:M`PPP.NPPPOPjPPPP Vt4hQ$P|DxUʐꐨFQ_GzH)RoIJ>PPPLVP^PpP|PPPPjPPP S 	PZPvPPjPPPT6PFPlP|PPPPPQU ꐸ<\UpܐSV кNкZкUnккккMкWU$:`tUSX п2п@пUFпlппп5ппY PUfPP°PPMPZ jՒļ[$ P~UŘŬżũؐAc\`@\nɄɚɰƪ] :Nhv́hik'TA̪M^ PJPӕlPӌPӪPjPPP_`RBTvTUդղj` PFPdPنP٘JP٪PٺPAPMP a 	HUXpz܂ܩy܎ܘjܴb 	R߀ߨ֚,cP*PPPPd hze PhPP岒PPPIښPPf :FXl萐趐ԐgP`P낪PPPPh`rĚi ΐ&j\kPrPjPPPljZm*"+6Hj􊪐Ϊڐ*Qn`PUPP&PDPbPh~ȐАڤ
3A4V4oo5 PJP)Z T7pPPA8UPPPPS
p ɐ>TUjڐS q`Sr`S&sS0t S.u			S6v$


5А

w`Hj͎xD,8ZJpFDOkHϮJK yPUP(P4P8PUJPfPxPPլPPPzT`	ZvUS{`RhUS|2HUn}c&P FP hP P P ªP P P P P ~ ~P#NP#lP#P#P#P#ƪP#P#P#P#`y&P&p&&&&& I`(n(À(՘(((.$`**Ų*U**** {,>,EL,d,r,,,,ؐ,,`/6/P/j//////!h'l!A/`	7P7v777̐7AQ8QT :::P:t:U:::T;: <E0<L<r<<<<<<<  @.@J@z@@@@@@yT@@@@S* DlDD5ȐDD`FUzFFFFS GDGZGUGGGG5ސGG JUpJJJJJJ+L,LHLZLlTLALLL5LL OUzOOOOSPQRPQzPQՠPQPQPQ"T S|SSSMS3TlTՖTTTT VzVVVS`	PWTPW|PWՠPWPWPWT ~YHYRYbYUpYYYYMY[&[%4[D[O( [T[r[U[[[[[F[`\ԙkPd&TPdNPdfPdPdբPdPdPdT g@g^g~g՞ggg
T`iXiiiMi kxk5kkPltPlPlPlT`mdmmȐmMm0oo5oo`PpUFPpdPpPpPpPp	
PpQpPsNPsrPsPstPsOkv"Rz,z6zVzUbzjzzz5zz &~UV~~~~M~8U`v5`\tj `PnPPPjPPP3PTPPPPPPPP `ЈdЈЈЈЈЈܚЈЈfƐ`ЌRЌtЌЌЌЌ pF Џ|FЏURЏhЏ|ЏЏUЏЏЏЏS,В<В^ВUВГГГS ДPДvД՜ДДДmdx2P35'с5ΐ쐖`	U>VM О:ОU\О~ОООООc:J\p`УpУУTУУУ`DVr~Pۘ4ѧ`U\쐩S`^  PNRPfPPPPꑬ`^~j  JP"P2PINPU^PzPPPUPPPPS.`PPPMPD|ծ쐵T`pM&鐸5萸`йUbййййS,PfPP5PP мU`ммммм&2D\ޚ 2BJRZbjpx LVRb
brňIcŅdjA 
'U.X˂˖ո TGḧ́͠eAjG|ϮڐGpШڦpҜ PjjPӜPP  TrԊԬj̐ :TDVp֖֪U̐֋gu2POvk^HxyzPڠPڥPڲPPjPPP`#>^~j  Fpz䒪  `tJ搐樑АM PUxM`R|Aj`#JPLPtPAPPPAPP f`	Tz*`bၐ`e:TjК Hf RxĐcϗ'6P0PVPvPPPPئP VzJAM`P6PURTdP~PPUPPPPS0`PfPPղPPPT[
D
`

U



U



5

ڠ
UB
x


M
۠j՞Ԑ$ܤ &RGn~Tݠ# `P"RP2PIHPVPUlPPPPPPPT`PlPPPMP&`5 JUvΐS Jl5ؐ=U^S    Mؐ `!h!Ֆ!!!樠=P#ž>P#VP#l*P#P#P#P#iP#AP#&"&*&2&:&@&H&lT&Ą&&&U&&&&+0+8+cF+b+h++++++& 1h111112X2vJ222Aj2S4z44M46p6566=P7U\P7P7P7P8S&888M8
`D:D:Uh::::M:[<.<UN<^<v<<sA٤<<2<<u/MwD@\@Jx|@@@U@@@@M@ `G4GUTGfGGG5АGG$ IUPIvIIIոIII :LFLXL~LLLLL N`N~NNNNjNNN`Q.Q<QPQlQ|QQQКQQ S8SDSJSnSSSSS  :PVRPV|PVPVPVPVPVPXrPXPX&PX`Y:YFUTY`YrYYUYYĐYҐY5YY]U:]X]|]]U]]]]S
֐_<_T_Ul____P'PAGjPaPaPa תgVgbg~gRggGggSi8iHiUdi~TjiiUiiiiS mPmlmՈmmm  WjNn,nJnUhnnnnnnn WjNqqqU"q,qBq^qՖqqܐqWjN6Pt`PtPtPtPtjNU4uFupuuuuuuPxBPxpPxPxPx jN0yXydytyTyIyyy{yjNP}$P}8P}\P}P}P}P}P}"`orؐjN.V֚*	 zЂjЂЂЂ

}dt⾐jN2hƐ֐/
jN TžU^tđjNfF ".6>FNV`jt~ĪjN&4BT
NdjRzɎ$jNPtj萕u\ئyTRiJ ̐ vj
`ojj`jNZjN<`j`o|Pbئظ*hѠqʐ&PO@k>BfP*PPPPUPPPPMP}PdPՈPPPT`tЭrЭЭЭ5ЭЭ$ vUxƐ5␯"`tU^ĐMyPnPUPPPPS `rL`U5!UPpվ쐷 "TuйdйййMй # oPRPUzPPPPS $`wS%d&nP.PFPXPdPpPPPPPP'jN@PbPÄPâPPަP( Jn
ŔŦŁabPd' A_)jNH^U˞S*ːl͒ն֐+6P^T|PϨjPϾPP P, :RnҚҲj"-`jzԎԤƐАؐު .`؂تj*/`wjٔ̐0`rڌں>1jN(܅UdzܰS2 vހ޾M3nP*Pߩ:PIPP`PxPߊPߞPjjPPP4PPPP5rx丐䦐6`n圚 7h8`x訐Φ 9ub锚:`Zj;yPLPpPPP#PP<T^A&j=q *4<Xrz>u
"В:ŒJT`hnƐ?~j@`r@Ztj0AoiA`B ~j̐C v ~   0D$E ~FyLbLG}PZPlPPP=5PP H0>OkA^
ϧvPJPPPPPjEPIT}6dzլJTr^լKT NZtUML`rJUjܐMMn:U\~UʐҐSNPLPrPUPPPPMPO`4U`MPy R Uv   ܐ S"Q`P"P"P"SR oP#rP#P#UP#P#P#P#5P#P#
S %U0%>%L%f%Uv%%%%M%
T (B(U`((((M( U *F*Z*'ʁUn***ʐ*M*$VP1JP1UtP1P1P1P1P1A1.W`Ð3d3333jT4ސ33X}T666N6x6U6666M6Y8T8Ut8888588Z ;(;4;>;Wl>B;J;l;Պ;;;[T`t>b>>>M>&\t??U?Ȑ?w?]gw6PALPAzPAPAPAPA8^CCĐCʐCCCI{_TF*F8FFFUXFdFzFF5FF`HUrHHHHS(a`PJvPJPJMPJbrKrK5KАKcuLUfLLLLS&d`PNPNPNMPNe`OO5֐OO*f zPUPPPP&g`PRňbPRl>pPRPRPRPRl>PR huPU"PU(JPU0UgP6PUU<PUDPULPURPUUZPUtPUPUPUUPUPUPUWEEiqZ
ZA6ZŒDZ>PZl>\ZUZZZԐZMZ"juP`RP`UpP`P`P`P`MP`k`rPb<PbMlPbpkPbPb2ldd m vdddn`eee$oԠfff8p4 ggq`hUrhhhԐhMhrPjPPj+pPjPjPjPjPjs;0l<lPl`lDllO
koʐllȷl>l
ttt$t*t<tTtfttjtȐtt
uPwRwrwwwwww
vz0z:zP*zdzzzДzzzwT``}T}p}}}}ZVl>}}}Ԑ~x|`j}l><UHXtդy2`hX[~`UBl5"z XPՆPPP{T`3\Mؐ
|3b<[l>u }:Њ$Њ2Њ>ЊVЊfЊTЊЊЊЊЊ~`zPL*PdP|PPh]`P+,.'/AvPP`Е>Е^Еj*ЕЕЕЕv5ЕЕ
 ŐUBfzUȐڐꐘ `VЛHЛXЛtЛЛЛƪЛЛЛЛPzft,8l>aĐঐ``Pxʐ萢PlPPPP@Pg8PPPrPjPPP`zF`n|RIȐ֐`Ь@ЬdЬЬЬЬЬ``ЮRЮvЮЮЮЮ`#Xjؐ(3PjPPPFP Zгг5гд4<PUzPPPPS3жZжzжжжжжжжtS MFl>&mP4<DLT\tjGl>r&PڔnAK P^RA^&JdU|M`jPUpŐŰM
`zb5<Հɾ*`PʞPPTP~P˼PPS( M̜ҐSਐf̀UͶԐͣ
UHZjzϤQx`l̐ؐύ Ӆ	0OokRq
r*ӀӆӒӪP`ӨӺ`VJlۖj J`݂ݔݴȐPNf >XK
`nzj ;Db~未欐ΐܐ⦐`3Z醪 Pzj`#`옐츐2 uU(8RlU5̐`#UD\tդTVrϐ'/AUDbv*S
`<\5r cMuJ6^j( PPPbPrPjPPPପP.PJPTP^RPbPfPjPUrPPPPS``f5`}P	UP	P	P	P	@ LZjĚ* P
jP
P
P
 `OR"IE2D\nݚ`CZؐ```  x䦐3nj&ePPPP6ަ6jTPŷVPfPxPUPPPPPSP
TH (U06>F_nl>NlU5 jP$P$
[ P$8P$B$P$\RP$hP$A^pP$^P$JP^^P^P$P$P^`j*R*r***ؐ**`j,\,z,j,Ȑ,,uP.fP.P.P.ڦP.  /N/t//// >1\111А1U3F3x333V3&F4T4b4x5QWl>4444n7_zio֍r4P;PRJrLP;dP;^jP;Q;P;P;P;ԚP;P;``@j@|@@@ `,PBNPB`PBrPBPBPBPBҚPBPBD6JDnDD^D5DDĠGU<GXGlGGUGGGGS`zINIXIU^IIII5ҐII`VLU<LVLlLLULLLLML NXNUzNNNNSȠP8PTPՀPPPT`jPRNPRXPRrPRU|PRPRPRPRUPRPRPRPR5PRPR ʠZVU&V<VNV`VUrVVVVUVVVVSˠY0YBYI'IA@VY~YY̐YY̠u`R`R``@ΐ``FAA͠bAHblbABbPd֚PdPd|Pe,PeDPejPe~PePePePePePe 3hVhlhhhhhhhhhhhh  kHk|kjkkkѤêmmmm ҠoVo~oooooo`&PqVPqjPqPqPq`RrRrbrprTrIrrrUrrrrMr`wwMw(֠}xxJ>x PyPyMPy PznPz՞PzPzPz(٨ Q{>{{&{$P}P}>j>P}P}`&XPPlPPjPPPݠ$4PvRUTPPPPU4PFPRPZPUfPPPPPP
PPPg'JP$P,P>NPU^PxPPPQPЏHЏlЏЏЏԚЏЏ`RБZББББ yPfPPPPДrДДДД& sP~PPئP`RVt̐F 3Z<UPhzj֐8O9kX;Ut>$PnP]Oo     j      [h Vi   QLGB=   0{+&!	!$08/14/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
  'p~}P >" "'D Tut


t݈
tt

"
#tDt3=t
@t0`#~ 80TaDs>0[t`D@t#(trD	T
'T?DDD _T% !t
t
t
Duү,"!"#$$"#!P%d%%%Ô
@$$p#"2` `%> ЂЃ&'_u u (2 Txu. B/,>$4 `Op" /{ 1{1
"  "/)z|t}~ }䓣𣮂)D;` ) Cp`t   +,-.
..-$-03,,+$+`9 )t" ~}|}Yp5"{ z}R8:tu݋:D>tA;<} |U=t>9,?$@%B'%($('&u"B&C&DwB&%ӔP&`P%/3d@~qD$d	p?aDR8%u( % C&u*aJ)**)p)N`.(('$'`903aD4<p<%&$p5qDEB!D @,((sVh^QܒRXSE Q' QBDTH"UqbUt~ 33V']p@MIEV=B#U.3ZqU#"E!9\qՒUT"uPu4"%$I403tʎ"0"
pLp"0"_d   55t~)t
5"+pd+/ÞP.%d@ Sp`d,͹dm _{ +u.aJ-`..9-N`Ib,sg 
d,+hiBSje,`Ced`"`7tu
8d" su?v_wxyz{|}	up ;H   01/{09Q705/14 kLite 3qHewlett-Packard	any.01A1"x#Ta+T0	T@t/{3"~0@xDx_v$ÔdPx>02"2"'}"2x x*} 0<uu u	`@3@3@)aT$3TD ȃ@VF @~`T?0	T@3`T%`@@3dłŃ瀾xT?T_"x!T.0s/TDx!TDxD@pp
07/dp1 Dx>J@0P T%%TO~.`OT"2`() d)K()?(@좌JKPWxt}TA"/0g}` Tq000$/P/ P	d`$7ⴕ䟏PZк0{07?xDO+0'yJ~1``"x 0D9BD¯./uүp6ޅ./"xt}
~1PxWvvuuˀ𮀚D
I`uu!W\ү0@SkQ}1``
$`$pl
}P`x~ce
Cxx txDESxxxx`D@2پn}u@g@`@{>}d`&xKFI*Bx x}D7a!P`0xtxtyuup!./}^aP}eSs1^}laP+½*,܁˴xdD0D x^Qx_cD%xfT_bp# ) ,!`X0*h0wA˾qs	!Tp͈"c0x	}0.@ϴ@8}5@ʎ%tȐp)_? `P¯~u| p!~@T`#lU00p6`]7aνּ¯)u)$R4C_L`)}+t)(ѤÔ{@_>*w_x)(0#Q w X0%v@"x)(*`_00.}+,-2  
)"x^}4`q}7>"  }9@6!'B00x)xb`xc @p L0S(; TB(x`0)0 9P4r.( 0F(`xR=	(x᪀x 5! q_(>dTrK~PF = y(.P>q
P0Tdp(D!?(fP( @		5
<}p!Tu"2P Ô2@Y$0¯x 8Rx00`2)6020 T߰|`	pXl@ܱה ]]4C4A@ t1x,xtx@x,qހA0x*-t+ZP`TOxY#^֚b࢐};TT?)xT0p ;pހU!T`a"d`
u)?Td`dpUpD!%T!T?Ӕ @
$T?M;T?`d`}W}*)pKp&$@p6!q%% V'@+~ *~*)Q33T?O)`8 3  ] )A13 )$`$`
$-p} Y}"A3ȐEP3"`uxp_>N>0WA7 87B67`BЂЃ2:6x^p` 	?]g9@K07*q7Lx-!7+_MLNx*MMx+AQVL0x"b=qŧ= BB=@eK`LWM,6!7q7J7J0}G[Gf@2G`GF9KB996>QxZ!7Yq7RNSR8}DQ`R96 ?S07^q7TLTQuDSNTNROU07cq7VL߿VT`}V8 VAIDUNVRS2A}3 A}9 !, uuҌВ}"YZd;Z0AZx'D
q_0d`!0f/00_`0`'`2`=`HpQxWc_6uuuueuu0fuueu]ˏO$[ƨpN`0T`
0c;0  q"| }(0xWP/"(@E(cp
@oqP(qPP ()(x)ߎ(0դ(!t)))((xY))"*+p_T0 7/t
at&Ppd `.g..
t{[;nҌ( |n響,-mp,l`
,-3|d@zt 5n/1H΅+*,-"uPu4+i"o E[x]c=	[xP͠zl߆#x7x8ǧ7t4"PcdǇ"xe0!px," -AtF)DG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7_U?4c~;V~Pno|ZQ}d%]	`
e(j[&b'g>i\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RОZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p o t z q { y m Zc v v       
  	 x   ~    2YPJ @|PЬӬ !ww ~~   @"x7x4QApDYaD x2tx1tI#%E[0% %xivv T%_xi6^=Hxk"# $ $ !2lx1 	ү  ¯߀0 l#! K@3"0! Mx3=
⽒[
"xjF`@kz <"p7"" %	x30#0$<T`"p"xkcfp?
0!#3tI.4}࠼xkb$3z 
 Hp_ÓŐ`$H$ykHxgv"xw0	D0x$FӔ@Txwyv!D"0R 48xexvӵDpT0s
QP÷PuPr"xmAxn1xu"xmxvxnxxxuп"xpƷxmo0qP[yoxpf`ӀY'xpޑְj[vpp".0&u)1X)3@& @&"* _`@"x*_t %*%o-@-P"/t7U-,-b,R--o++,U-`RU,`  +u%*$U,00u,,u,0,*+0P, 0  d0`PÔ@"0  	0
0 	@	"0 @@H@@`@@$@@<@@T@"   RӀ 1 }1ÔP2p_0/b`%110 v0//A1Ӕ?@t -tq6wnR!.P ]x.xgo`x[T`"Txf0gv"/*r3/TOp0 0@0 
0 `]"`0/]P 00!P`	 7""452 "2T1u$b405S20 |09}= ~ } | 1| ONML
:
K_^]\6=iTi6 5`64064041$cY2"140#1dn`1o n0u1o! Wu1nX3Y3Ӕ@
3_s33p22
0
1"ɒ4@0
*1$`$`$p#%֐#&v#'Bϒ44A%##$#'%(&) )1$"465  6"4xg@@,xh4d|p%05#(6${zy#p.,v@,0/~-_`)05#%.1,./35
P1/ - 
1&4 #/
Xa7@,7V57/711/975678567`A(8t%77566 88b+,rP?50r0+w05&_5y9/4@,5	1 k17/ D7/r@B `- 
 
 *A0>`-
 53DEмFAB86-o`1,0",+0u0-05(@1
C9D6YJB:hK7G55SU+V4OPoQ3p+50 ?Vr,`*jI5/5JS_B[__[I`e4pv^6[_B:`/5b+0 \0@5Cs,[2/2OWg[>B[3hg3h0Wg?h=[97/p,hfp02"Up#mHpf;?hgglrg#mpy$m~82xfpJ`F0}D){) 1	})	2 2@
"yxfy?}Z@xzMNOpxD Ee1``א}G~X@~0
T`'" #}|XpC~{z}yZ1zxydVP~y0@~0
0 'P~`0`0*0$`+$`W$`6$`$`&[$pYA~TpրQA~RF>0Txv)!pрDxՠ001```	^P0* إ}`@~ 	D~bPC^A*¯7`ү" )T|F`xd  R=./2x~v
xD}D}*0{^`
}^T?Dt
_ei4si24lgpD`P~[@`TﰗBl34a3$``$p"t1e4`tg4B |}"}A~0Ʒ0+o0)1Td`x0dp# xF TTÔP
._/xFt°eͦקxBUB2sͦקxNN2lͦקxJ_J0rߏ789tZ/qC:(x үR7%$Rƶt :t:821(0 (:o$⠷lx`vT"` R9x"`үs q78 0(87P p0 xυv#ս3xV53}+t0ŏ4  %4 +4 ƫr""55Ô@̠Pp`,R̠Ȑrc@cɍd`
*h~R,ϜT0PO,CΠμCC@4A0120``/`@$pNο21΀I:I&IHE)?6PA [xPέ03oppG{*`	6>p1 '?<P"@TP~ ۵+܂E?T@;үd`pxH @"5i5@dq;"-.?hQӑm0`/-x00 <@
0
DDTйѠ0a	 0>d}`	 a}Ct
u/ /tl@@'- _ r.ldpe`0ߴ-DxFu@0u rxPu000u0//GCգt`../0..}00 $0/J..!ȧ- }p
.Ƃ9ˠq"pڡ	 @1R)x0).:)4R`+,01)'.7ݸ
pha)
/O1= 2
5 
x(0	(`!*((p@@0v@{	`~	@0|`T``1_`pȰd0p2CD?գ%5߃0op;Cc"w1AT6%p0:o ""p	S05qB0D" %%O0(ҵd-N-H/G" 1r)&P'P#46P-p0 Bۏ& S%1?-` 3-2cU%`	й%._0D'1T:-#?.P3sp_u.
p@u.H.T-V),*Ҁʀ
*+%DḌ@+ 90&@۸0aT0 +	aހ`>7AIҵ05[0upo)?6*+pFR}}}0
pzQ/+*tZ%)Ƹ!SpS;"쎸W P#1Āp5\BŐ}YBT|!p0=/`$<#T0?O_Nw45U pY}2x`TJbߴbb[`b0>0Ņ54'pB/_D`L7%fFhB2šPcP	U0ŀeUkk!cbl!eA`{o0Vd}
1lE9'o'dZBmd5lpP7s6$$P3cX2urVd}KFkePes8&5f1f}z` X0pRpLxpGIp? 1b #2  TU``|Tx{}A{xz Gxy Exx Fxw Bxv <xuxextx[xs xr }xqxxp{xФx| Ax{ Gxz Exy Fxxxw <xvxexudxt xs }xrxxqxxp"
yxdv0`bPTx`pB8" -88d0-Tx` `bb``bNpB -^XC****!J-c S7C^")u,/g.-T*_/.d^  Q1H'jc-ޭ)ۼ,(f;l)d&AO*+pǇKpGQ䨝iD++kR=
0;l-pPB Q-3މy0hP5$p1q?JR}DAm)=t>4N  0 Q6 xpAP
ק "u*PБ09"RJ ~})IaB Q"<) R <1"+0R¶<$+pMsJ0D@YTIxp`E;D S)))u+B+12 D ppu+TaB5#+".%TOyd k ǔЫ	p ``` =cʫ$0>|`E'~Ӕ@6y   x0@ @ x9P7T?PQxvP_
Ԡ ǀ
  0GI` ;oPQв"0*WAopT&"LtM^q30.~KT``I0}n}S?@.Ŀ33TBDАD xd3"8t`#xVxFЇI0II@TLK}
c<&RM~Gqq3"x)"O[Qe J0OQ17|-3tR"LVV `
O0 )J'' 'BP=[O`k !wP`	AO?"HI.gB*TY#IPEH0~."nf@yri@L@vZY?po0:OJ5 050vq $_Y:a^1p,; ^@	FsD0s 0"*OѮ@"BCCWpaO!Cdpe7R+tt2kC³CFD0`DCxgvBC?"xF?xG@xEAxFt@0( @T.`x@@0xAFt"("r@B`0AA"xB!CqAB9B
 N!OqMRN?9N+ !UJ!KqIJ_#9J+ !|DEFGTW`N JCT&`7,S0uE`AE@0
GFt#R1 =BED}^}e}s}lEAMI !++Gp5@"NxDTK{{NoE 8C̓$0* 8?Ap}@>1TPp}CO	E DDDDDDDDDDDzDaDHD/D'D  EF;V"AOx\@ab1~p|t"x\@Ԅ/BBCC0C@F"7F`bD1GBF 5!6HFBC 2@@TFB`FM`FP9q|PCpP$`RE֢Q$FOӔ7@OOpabO1O0	xgZӒ}|!FO`#`5`2$pCH@`b!ApbDJFCY YOx[OOTyxfBFEOfXPYQa
xc GÔ@π<@bTxcGPa@Da`abBaRaGZTrHUtpcxhJJ[v+xfv2 5p4}t kt0㐿}= m	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂAT6R7 8G9HO;|INR{r$QI!0O`Od`TuOR<H-H9HEHPHzHHHHHHHHI
II)?IG9T|D%~$C CKpAXAT| $UAPA| '@$@~p@' &;TIڇSr;Sx7؇LABha2U~@<0PS\ODz=ēd
`#@}w`@}(`@}{<`pdP`@}d`R 209KC{ǹ}ttdaKxtxxXx\t x]xat"xbt2#xJxFxBxtx(tb}0Dxxtxtxxtx@x#x> x=tQ x@tp0xTВŝ"x3tĢxaFѡx!TToTD	ʦxTpTx=Tx"PPT=D"Dæxdv0}<t 1FPBPGPEPA}D>"x0xM"xa@P;"bpS?/?@>"ޑ$tk>!$-"Tp\Ô
P~0~7%OOXNNrи7%NN{ z yN6@~K K+L3L
4L6L7L"8L-9L8:LC;LH<  LM`7NY$Q@Q`I A౱0PG1~5KuN& 8C ;CuNuNK N"$`($_`*`-`Q/AWp4`
 Tma7Bp<ALBBFBEBGBA@N$`$`!`0`?$apA_>p:3@2r*}_0  puS.qčr,@ 3`G`[]Np_7"N0dpF_e$kC`QDALWT'p. N00@O"K}$pL`nPP:Kd`ИKxaKÔ PKKdKȭQ@P
:ۀPxav@@~NdNdNdNdNqNNNNͨNNOO	OOO1OsOxO}OOOOOOOOOOOOP P3  P:0a
гv"xzMNO`uL 1oLLx@`}Zdmxy峑mp")L1
OL>`Phr`y"} H?K}UfPAb"uM SMMDpXTM0CM|80^ 0@tރx[Dav av*ppxTxdoD0x7px xP@C`}_K}I	
p"35KxN| } ~ Mzǐ41 VK`q R<LL R<P]((sPPQQQQQQPPPPQZQ`QmQQRRR+C~pÔ`PڭKLV"T?	} 0xti"KMKAb`yJc0
V	7Ph50}
TPd>uK6
@@b0fa7 %P@l
M"G$pQ
?Kp."xydP "{z}yZ	z<rLL%ٲpQ
Mqcuqgcz1Y?0M}8T ppqp 3|p !K#T0P$___QfpARe0#`70xD  *TQaxpb!1%%x v`gq٦_eT1%e*+7,Yex).u0/}+t  $0.TP/00//@"R0  "/P/+u'3" 2  /2}P/",./S2-S2,Ô`,pC-S--ST 36-0"
Flxp0 "@lŝ7xP:xҦ/012*@t?0t /xp+x?D%?0/2R1U2B2՝[xx=pD ?xD C  CpD@æ2x{W_ WPF}WTrTTUUIV'VVVVV2x
,-q=x
tG,P
-,`x
LPMx
!LJ>{Sx
!L #G2AN0"t "T $Qxl	}INBxk RxkP2S0 K%S$IkN R$ÞPxxk=GbF`WAN_._)*ux+ L4^үPF$`& p<SH}_d]p`C^XFx+*)2IWAN$xxl e@v>`R:xkvykxlsPVS  >qSU0{ 	RT2
JTxov 2WxqW`r<b
௡gANfgPJPb>xx
x2NJx	02W)_7P$PN0lO02[l@~WG WNWXWbWiWuWX!	XR
  XvaD4Z3tD@ @Z5"xD @b$P``3@b0vTO!!  +De">x"vv&w`/xxy@^y *Pz@z{yea^*`Os`}lb33TOs1x D@PÅP 4A"KƐ`p}TМ`- ,*))D8S)9S)x_vS)Љ)"(),0,YRYx	`}NFYu- u.<SS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-A^_22􀐒N,xalp [2-ÐsPp--Ӕ@zg0a`ҀZ>ZMZaZrZZZ[[%[3[A[V[d[r[$[%[&[+[,[-  [,`lә[Qxu,x~0cäK*+KP
/+*M9
x¥t?e+pOt e*Ф?	S??`{kxЬ}}Czt Հ-h t_,_v`ao} atauava}3Πk'1րA6H 3_K1 7Ѝp)(ߨ"`t G]P:\D\K\R\Y\`\g\n\	\\\\\\\\\]3]w3]  {]j]jUcccca
tt)r Nrc	c
c`2X*aZȠ^T`Ó!KJaxT0BK
r:4 t@bK'  2T`$!J!w2nmZJ`!a0DTGt( Du4c䣒Ӕ2nSTx2NpaPF`@<D
A~@DA "pgqD13"0,p'
  `vӿ""0.p`%T"" 0[P2%$e` Me1p<2◖30 ϓ3d	`3

3 7xgv"Ô
@"2}2416.(1$`$`$Ap 2^"[_	WP⪙;ұ쫖␕
Dxg10Mf"
"xQCT2 C8p_70e_;>"` 0"$``!`"`#$p!F0 䐳
=#"x%ts%13x<q?d @"rW}t^0	W
A:x00Dx!ToT`@)D0D%T1E
 |p!?!D`%!TM.ñʞ
A݀"  :	;
Z
123B=>C	D

P	~x`!ÔP
^`_c"
%`60FF`7@<0x(
(bxA<bh(($=`C0.+xT 2E} 2zC.u DT_`
& ь+@@00	2
 bDJS0cx($```9`B$bDxv zq DxTҎxStTTH`(xS(<x)2)$``$p#@hxSwx(	x02o0. 2]#0`
"*+*Ô@*ӔP!&@
%PR6*$a w$cp!0.-C+(}+ϖQ)zSi+*cď%C++2P%% Gcd"&Gn,@'@o'~``J`N`R$dpT}++A>c"+0T0dp0A00ӀÒ].y+y3+@*"*+oiE"N"xP"5	1}i`$3mp`1_}y:,/0qdddՅdۆddddeee:e@e@ebebeeef&f&fHfHfjfjggg%g%gGgGgigiggggggh/h/h?h?hahahqhqhwhwhhhhhhhhii  i9~(i<00i<C/yPGFT3/GC/00u6$%U 0` @R/@IPGu/H}/bLLL,}鉑LrI%UcNpˤNQ/OL@NNOQJ"NNS"NNU#H P ~PHYrII{LAҨrIIӝ  -GY~ L`| }_?@^_GNNX"NN/bsL[][ӗ ]f\[dgF| ?`z {_i@\]L`\i[-.Q\6Qk.@N.-JONOd"NN)o"NNr"NN?t"NNt_vMf@#@iP0-mYnMy!Qzz{\n{dz ONx"N(@;NɆNο"NˆN?"NΆN^`,$/0NI/I5 J/9V I0AZ!@NNKÔ@πu/ ,/ y`  SP]PP:!5a񧰔M:;~$`jPj$$ jy`T}!Z$;`!!xl UI աJ սKxi<<xlP<oAp'~p'0#70"p@"; p"$Z ;nO❨ J K Lў<xlp'"678x>T934T`љԶÿd@l0_9pஐ4ir@}5@& 4@P| $ >678 Pd;ppN`2"q}op~&s}n{~Ak50802/}}P0%TTm/^^qt
Ԫ }( pe((@~&[×2]cvf@sX$~̻@&8}pq}{|n؏ 
0/mkk"/0PlrҠp^ }p
T?T`0"0"@;u0<.^.`~ K~^J2T {ITO˹I..O/p3@Iz*&R1 G@;.01~ް ~;PC14~FpZ1QP@JB1TIIp043C,V`&J@@ =`@ԑ1"x_0 
T_
O"0.32ϻ `,nסm/e.`.܈܀^e.`n.ov^/ m/0}C  k~#AQP	D7# @T3``1"2 2`p̰2.Ќoǽu.B!/Su.^`} K/}]_\Oӝ]/[Ru.P2p/.\D<fB'\r[\մu0o X @.~0P`TzTT%%̴p0`DY0`
~J	.d`·/ӟ@		O"\Gj$rt@$5db5Q$OU$%5Eeٮ%tx$ݮIt}5}{z~yAɐ`rٿ/`,rw00t9@!u"η E~ ʎ_`-˥t~@_Qq"1"¯01Q`
tz	ϔP1үpan`i | K|\`0023Q^z4$ z3;131^ys((sstNtotttturuvvqvw.wlwxRxsxxxxyᗳq{	j155fPQ/0;a7#1?S>U?rCu2`u3 ?{ z y2
Eb4{F2T`pd``+zC>
E>U>^Ke4>
_?)fe3p2l`&[{0. a{C>
EuRF4P4"&9^bz`_ip455544>e
45W
 ?X_YZ[\EI^7NljOƶ>PfRS@ԉUsNa_dLpOʶ>

E3MbUo̶>pN&0ppNO>hIv+t
vPOж>xi}`z\(?{>_KR>O><_J>=o>)>>?oM*vMOҶ> 	`z
|QDL͘09kR09R1Tl>; 3s>1p("0¤7>}頯1B+1 %u{1(#q1$`=`lp{4$`{ou1ڤ!ux{@Mn3x˩dE|ptu|ޤÔ(qPq"x3TT Np\ q% @MBtڤ`	@pn!8u1˩tpu.3з̩ؤ131C|}`00?r̂*A@/` npz7g3/A"H"P(R*|p*a0}`Q"qO}u.31 O%p}^ͣ? X}^¾90pa0߶/A/. 1 ǳ$3/ tP"ʐ}ת1
~P2"""0@t%ܳPD"LION x1x2`TTxDxD"0"x04 03spA3"43px"Tq2Ⓑ4pDÒ44"56"x&3~oTO&0"x!To`	 xDT"	F	>߃	2Vx3pOdPX#BLҀԀi3ꀚڀ3!䓣łŃ&
! "/ߟ۴@̈$ P@##EN``#\s""P"]"4"  )"@/33@" 3@"P"(0p8 
"߇		D t )ς:q8"		%
"*
 pP				"w4p2
"""BBE"`;a3Ap"""Ѓ?Ђ patsߨ6s ŃŃQ8"%5 p p
 sh`ߡp""~a"v"n$e"b%"V"UJe@11V)pp_){pΦ]d#s o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
 ?_ ?_ !"# %?&_'()*+, .?/_012345 7?8_9:;<=> @?A_BCDEFG I?J_KLMNOP R?S_TUVWXY [?\_]^_`ab d?e_fghijk m?n_opqrst v?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ ! #?$_%&'()* ,?-_./0123 5?6_789:;< >??_@ABCDE G?H_IJKLMN P?Q_RSTUVW Y?Z_[\]^_` b?c_defghi k?l_mnopqr t?u_vwxyz{ }?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_s     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/Oo߯"m9  rX%  t9  t
%  !&  $  s9r%  5  r%  5  r5  r5  8  9   撰68BAS   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $   r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  N  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ Z  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 4  X  f=$ J  f$ f$ f
    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 9  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t<  $ =$ u	=$  w$ $       f$ $          f=$    f$ $      f=$    f$ $ wf$   ;  bf=$ uXf$ $ $ Cf=$ u9f$ $    $ f$         f$ f=$ 	r	f$     B  s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz/ZXfPfRfz$<fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytCsZ[Xfz/fyu$sZ[XSR=$ tO$ @
 fyf@t	s/fxfz-fyB@u	sfz/Z[                                 P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPQfp#fpfpfqfpfq`fpfqafpxfqfp fq0fpfqfpfqfpX         r
   r   SQY[           V    .K9 ^V  .O9 ^Vw  .S9 ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  1r<u   f f  fZfY[SQRXr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f  SfQfRf 0=$  u +=   sf P tW$  Sf  |[rRSUU*UUUUU*U[$ p  r<u   f f  fZfY[SQRXr   $ tZY[         PSQR 8 G$ffG$
@ظ 8 G$ffG$
Њ  $ff$
 ظ  $ff$
Њ  $ff$
@ظ  $ff$
ЊZY[XPRS  $ff$
$ظ  $ff$
Њ 8 G$ffG$
؀㿸 8 G$ffG$
Њ[ZXn6 6 26 =7 6 W7 Q6 6 26 WUU*UUU#  'G_PQW3   f.;I9 t3_YXfP NNO<uNNO<tNNOtĀ fXðNNOfPQP  NNO
ﰂNOYfXð      2ffSfQfVfWf   ff   2fff   ff3 7thf;|uf;Du7f   f   f30f\0fy   f3f3Ҍff0f   f3f30f   f   2f;Tuf3ҝff_f^fYf[	!)                                                                                                                                                                                                                                                                             b                           IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE       "  tm4                           f~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠŷSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE      f fff戰䈽!   戰K  `  戰   戰䈻              u׾$   $   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                              `   Y$ffY$
0ظ   Y$ffY$
ЊZ   $ff$
3ظ   $ff$
Њ_vaÐ            þ P                                          D          @8     D  !        @8     D           @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <HfC*
f%f[
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f67ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hfrf   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfbff D$fD$
2撰<uff  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON      t'/ &"慰 .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚰Lf   
ú$fӃĊÆ@  ؋f  úfӃËָB  ؋f  úfӃËְmf   
ú$fӃĊÀu$Sf  
ú$fӃø a؋f  úfӃËָ  ؋f  úfӃËְLf   
ú$fӃĊÆ$ 3.fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚸ f   ú$fӃЋÃ uOp f   ú$fӃЋÁ p ؋f   úfӃËָ f   ú$fӃЋÃ uN f   ú$fӃЋÃ⿸ ؋f   úfӃËLf   
ú$fӃĊÆXf  
ú$fӃĊÆ$| D $Lf   
ú$fӃĊÆ$of   
ú$fӃĊÀƃfʺfȱ ..'8v.G 
.Ŋ.'8v.G 
.f.'8v.G
ȺLfЋ.Ŋ.'8v.G
ȋѸ ؋f   úfӃËff3T.< ;t	f.Fи ؋f   úfӃËf.Ffи ؋f   úfӃËf.FfЃ@ ؋f   úfӃËf.Fи ؋f   úfӃËfff   
t@fغ  ff% f؀f   ttf   ff% f;rLf   
ú$fӃĊÆ f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃðpf   
ú$fӃĊÆ$?qf   
ú$fӃĊÆ$f   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆ@f   
t@fغ  ff% f؀f   ttf   ff% f;rqf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;r󰀴3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð f  
ú$fӃðLf   
ú$fӃĊÆ$Ǌf   
ú$fӃù .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚋ϊ2. ո ؋f   úfӃËֺ   ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËֺ

ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴۋf   
ú$fӃfʇո ؋f   úfӃËևffϋո ؋f   úfӃËfո ؋f   úfӃËfffűfff2ffȋи ؋f   úfӃËff ؋f   úfӃËf< x( Px <Zx 

 -<KZi
 (2<F %-4,<< O  O  O  O  O  O   O     P `0p?/`?f̼Yff̼ ff̼ ff̼gff̼ff̼ ff̼ff̼Ef22ɵԼ+ < ԼArr< u~ԼSr`<@ul	ԼerN<uwZԼwr<<uHԼ}r*$u4Լir<w"ʀta ΀f33 ft`յԼ r8vеԼr8vfյԼr8vеԼ*r8vffrf3f3 t0
Լer"$~t2t@ trf3f3  f3ҲԼJrnfɊf$еԼ0rTfɊf$ЀrCw>fft:fɊfɀt+fɊfr
w
fʀf͋ffNf    Լur f$ش..:	~.	fԼ_ԊfԼKԊfԼ7r>f .: .: 
s?"܆ˆf"fFff̼17ft0f̼?ff̼Ksff̼W.ff̼cfʸ ؋f   úfӃËָ ؋f   úfӃËָ  ؋f   úfӃËָ  0؋f   úfӃË֋33f3gf&UUgf&GUUgf&f   f=UUu&gf&UUgf&GUUgf&f=UUuf   rΊ3fʸ   ؋f   úfӃËֺ  ؋f   úfӃËָ   ؋f   úfӃËֺ  ؋f   úfӃËfʎԼH 2t3 fʸ  ؋f   úfӃË3Ҹ ؋f   úfӃËָ  ؋f   úfӃËֺ ؋f   úfӃËfʎԼ2tff   gf&ZZgf&    UUgf&f=ZZtf=UUt6 f   gf&ZZgf&    UUgf&f=ZZtpf=UUtlbf   gf&ZZgf&    UUgf&f=ZZtAf=UUu1f   gf&ZZgf&    UUgf&f=ZZtf=UUt2fˎ d <t벺 d <t` d <t. d  `u_<t d <t`fˋ䣡 T X   Z    \    ^         @          0             Д     Ԝ  O   L  TV B dF  ?L
h  ?p!r t  v     |    p  r  R                                      '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽ݽܰfvfڰf
`f{۰f#Jf-Ӱf94fC
2fSf] fifs<۽yiܰff ff ff+ܰff8ݰff f"f  f.f. f"  ؎ f%" 3؎  -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        12/10/04BSA  