#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTA ROM)  - Linux-Based"
BIOS_VERSION="F.06"
FILENAME="sp30428.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  E22  E2 6   Ar o m p a  ?q . e x e     ROMPAQ  EXE  E22  yp2Y  8DTV   BIN  SE22  y2    8DTA   BIN  v-U22  gN2    8DTH   BIN  022  K2    8DTV   BIN  z|22  y2    68DTA   BIN  J}22  gN2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$ p   `      POST  f   f.V .X <  
 f.d ` j  I     '            POSTf3 | * F * Y z G .	  t
 ) { )
 { \} ) k Y )  V 2 f3 2 =3    z ' Et v u  ! " ,# `$ ,% >& z' @O( ) *	+ , 	- 9. 8/ Y0 p11 2 `3 4 5 6 ަ7 8 t9 #,: `; $,< 4= s,> ?  0@ %,A YB YC B,D zE !F 4uG  H I 2)J yYK '|L )M  wN 3_ )P 2Q pR ,S AT W,U V W X *Y@Z t[ Y\ ] G^ t|_ Q` pYa" f" @      f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYߜPPSظ h@ [X <t
PW f&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI! UhBt/fk00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@>Rf0@
u߿ hH8ufY_ZXSQW< s۱1
2
 h3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
H/@
		! &
%s
> h}g3hp0 0t  Ãu
.(u	u/RPVF	` u tR	k@.)t^~u 8	t/} t^6
5
^Xf{QW~
,?  _fP	$S 9#0;r#Lt<
tw
u!ο ƿ	/_^p	65WfV*p#)6S
F f[tҋ3ff^ff[f`K.fa=0 @pCfVWU@ t  f7h2%3 tkfAh6 P{y'Q20O7
rg>Ut2g?FYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@= hR3>+f;r[? Wp
2h_
 WX
_: {r
gN1
gO?;r @9{9 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3f	ffY_QU/tg^H2N@?" h fËΑR   4]hQRWV^NV vq6Q3qI4GYGΕI^_Z!3Q'M0 pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h
s.  GFuJQVsuR?
 ۀO2ۊ~f@xk:P`?tWuf@ f.(|ftf!f.@# ^<
uF8Fuf_ts^ÑGVR.>(s$0q	.k6(.(z

ǀZF(PnĻ2
F0(FPPv2PqN~ t4vf2&fz10
FNNI.(ƔfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ .ƅ" ` P@hU.( `s$' ip3.(lh?z o.N /p\wFk@"~ 
N~f.$=6@.?(2ɠ0/tl)u4.B$f<t؅fɣ  `b$< F. C
1wq3V@~r F F;F F2u~w
`M~f1 kЖ lt
fNqu
ffsfF^PB4)F
Q*
*q4rF$<u&jFF .# ~ă$wp` *?.p< O<uO8q^`V@;(@..}(;(^V0&0
9t@{-2x@Z2
E/^SL 65^35#'uBX:NЎuP:
t3S9)&u=8N0_^WV\SVR`Ff~n*J[*!ffAyRffP%Ѐ`2fpʰKf;w
2>.fPRfPt#f3!fD`XfffNL$ss4
tP7u+q%
u	AfFaJfୀ}f^Z6Waf F݉^~K"8ueffFՋN_QtcV@hvb!F;pI=*3ϋ~+c:tsRVRfQF;F8u p? kv@kFM:`pb$$@K*@3frD` w;?=< uor,.;D$<u^π r0	 @BvFfYZt4}VWv Ђfݻq|~|URd
t"t_'t @DvP }xPkQ9SV ޾R3; t	 r^00k𿋼Rːӯ#Aq[%S~ ^Y~@j(*pt@;v7h!1k~@st 1;FtFk^% Bk^}cՊRa 3҃  V3k`[
*䊁R;FuR*3]ft7-k	)	# a
@S
+FHu
4uGrvFvVBs0c;~HVW΂߅tS03[^NuVp 3ҋ0_&61-Dr<lF(k/HpBHP)뷋~A(7oZ &0V  ~1|\0PN~ tKv0YFA.Qz$ x
fpO3g FfN<@P@ 
0K SQh(?	 \P,Q23If.` ?tf.&!. .8(tьL$QVW
_fvUKFp"`F^^F  FψF
fgFF ^Veb"]^`Lf`Ч!ɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;FyQr@i`bbbfC<4RVFъF8F?^ pVF0 N$ &(,ytN!!f8sШtE rts@CA9FvG 3r%if.(NͿ \ `N0ƺ0 
t
F%  .p >~ t(i'i_f^z e=u
 v@aQI8t%  Ntu Qw  vfIft'fAff#a f	pЊ?=rSf7.6 G                                                                                                              /                                                                                                                                              o  PQRa&h@ $`Ȱി h@rZYXSQWa$a$a  hg> h >5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p ~h)Ē
f`   hf4gf&`   fa.e-h[
 
H
߀hsfPfW@&'_fX`{i
_.h	-t~$||/hSh*   &  pΔZ@ ؀ K&}uu hk2!3d 
  % IVW
zF-5&$@#h<ff
AÀtf%1fhQsu h.;*,Ⱥ: @p 3ȰS, @uSh.h s!úvø fR\`,aP hr3ۨ0ݏ h	! t
{ aPQ" @ PQ= `t
3f3 @fYX _6ð_d`0-d  U{P8 6 <F  1ؿ
Et&؁8 uM9NwN#uӃ~ t"F= wt%   +ȳ%:Xh.ړ5`.e-   !	 `2 a `hFVEt* u B4u 6tPRfZX0=(~f.~ A;f` f ?  1@N1SfQfRfpA  fS%=uf?a2 ffZfYf[>SQRfW5f_ZP<f`fVp) f  g&G @ fq$<s
hEX_ n`%8PA	<@$f  E׃OGjE sFfLwf>@
 F`J'hHSQ ;s(Ǻ$ fޭ f^fWߧ0$
 $
ذv;)$ w'`$L )f_AhDV]def`b s0뿆``2r-
t@!/s! hpfr?8s @Pw
!QJhfaa	't5<t1mf o͒b@  Æ B<  CW< U$ # Q R ST1VW3XwBk?D?
` `_fځFW уtRưeR___]^(Ú   > ୛ A  T i M e M A@  9 }Y .    n SA aYᚗʠI` (
`Q| d0+e{!e ÀP2 P f2!h62f62F  3 p҃Х 62>x~!V.h$5SPS $<t4r [X)! ЍYӋoh33  m f`4 S  y6vh#%hD3p   D 3y "r< trF-2"u=-Zl -,r,- r%@-,&5&D&EN5-Aa
phcR 0-p|kte~.UV~^ 
8
3
~3
,.^
- pA:.fs&@ U$=u&8.f= =u H&H.&F.&D.9
, fgh  0 pqr  <ABCDE xyz{|}   )UV7 S#
fdQ}zQ~쾖5 r&.&.5 r
& {  5x"m .fXWCf  ~0f5wfx&ݣV3
Êu^P0(.'t%.FuN.PP^- _X0USW! Q,fv߿ hs  ޿R&_~22ك!IN܀3d	^
u
t_NA&>,_[]f^_ PVR&=;u&&4u&^P
P<q +&~& 1?E&DpSV h@b^[þ7o  W𙿜 <_\PF10=ROM Based Setup  Entering7 `. u  7 lKxt.7n@09 Su)!`- W  	8p 1uA	A7 17qrJp &7tFò t
.>	tw..P(*t h:PXhSHrF12=Networkrvice BootWake On LANAttemp-tto % ش àht8 009 r	 A09u 191I	t ItsR QP.09$<0+( T9RmnB1UB"09! ds@C	%24ؾL<^Ps D% VRynLkNF K3؁K?	uCFG~N0tG@hչaKp{vrhZ^òP*Notebook hard? drive MultiBay^"DockQ%b<#b (top)bottomy)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!I123                         =2P P 	n 
@m
0>"P [@ ^ -r  pqlectvZDeb]  ͹U8 aond _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   ??(D?$hP ?'ϳ?;S A;Zip.F`u h d0ô0.?ӌtӎ?`< A VK3K؊' tA<v<st1>& 2؍p;2}=Q#YAr	 > P @.>
*о}> @>+jjj(PjZ9  ? `>> z    ?a R 2җ
   t03>2Ɋ F8tFޣhK $/ Zbqqp URVQo.,.L.T^Y^Z]S,._>*[ݡQSVW/ s&Q?.<.-00?00.Y_^[YQr> u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰww`2҂ Xʱ@
>>>r
;w2p{>Jơ}gFYô.*><u2K0}h3ڑ hgh7d hb<u`B_ J qWo rf.>C5 hfgf&G, @ f   PG0f{@G,`u
hEtG,f",f_ffP QW2_Yf= TKSt0fXbo    ? o  J  rb؁h5p.
W
g&Fg&Fg&F"t7g&F0a 1 2H޾DD׎Ǎ~}ذ:{ rsFD	 k ל QRVDTQF r&e^ZYODffLo (]{^LрY`VUfQWbo
ِx
K&@
C' C$C]$0Grx  q##详 r]"0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$3u!#,9ABM  f.pFPS [XAu.6tFf.pFIDNU.tFSfV#O #^3%%gf@)3u
u ]r5t!q!} "оW3 hmZ ++hcr3%5	nbf_]`= vH OAH aP h2$@<@X7O4  PR ZX@ P.>G t.Go.G@aGSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ ^2 WW$ f3hcXRISWQR Zuʀ[Ppq4=B XZY_U M[у< @3ɹ2 uhX/#W) P% = @uXu%)4g/&@LhH0V̠QfPvf  g&?t9g@YR%fi<u @^  f%?f^#   f@"f۪<tf Q	? f !pf 1^AaZY^$fVL/z
/ZGP@t


 
"
f^ff? wD P]f% {
!
hVfi۾L <{D	"H3Pۄ4r H5 0P@p %2 P`x   O  Lqy@`@"rQ  	P  	`}itp   & Atf &D/&@/@ p Bp 3f$'Br"rst$ uf*Wc>D/ tuc ~rh^
&M/p=C<thcRp}[/  G11?}l4 Q < t&u/GUf&
3f30 2ɴ*f&D/ uf
ffKP,0&$0&4W0fC0=` RA9I
0p015RfVWf D3ffCf[fKfS܃fF0r0а K I+rߋb._;Zf5SQVWϾ u3螯_^ 	!BKsV 
R3
t<^f~
w/v`N0fkd`afft@`[^ɳ{VQWfv hG-F&1F&p & &P&
&0&{&&&1^y Uȡf  rX)Tu'P hk" h.hgޢaX`aWatif
]PRqQ  t%  sS fQ ffff>Qfh pJg&; PSu70W)f)PfY~/u! /u/u/u	g&t(tx3	[rwnf!ǂ0ـ  ;`o	1/uP~/t r!	 u;Q5-                                                               10Uf`f.QQ?u hNrW2rRrMQtf0f 0R| Wb t#Cr"t p ; (PJR  ZR Ff]L@V0r*6^  R ZrG	Ku ezdB rC\A 3?Xy8E tyEG 	UgSm r	S>Q	tlkӷQkpbƥc࿐W rt r
  GC_SRA0Zt$ؤ$]WPݰ  _W}  spO  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
R3'
//g&QQWjuptPX_Yù
 d h#9Cx1s y
2P -C<u4-uĀ qRRuaR12e< u3Z#ȴ$ t	J o U
	a!"Df@J{^h}YB*haßhr$T/hr 'Jh{B.uva { r PQW 0> 3_YXI9h:_c=F >E$hSs	? Dð   ! $!f` T| h8@u' t` h>* hٲ; tff%f
 ffa0vPZF X\`ؾL &>K&DEP&D >Lu d j@ tK}
 -Ȁ}	 >K 33SPd[tS[@? 2[sDy3 t^h#ʊYs
Jh{O#QaàhL"RD
ϰ<DuL
p
E$<u D
@Q3Csd
rSi&pS]@` uL
 6 6K u  (X6̔ &u{hT
	\

u.0   ND&}?u
 t&E_b t

&E^D
&Efww>Bt6j t.&t	&  t"& xu	\	PS   =? 6P'>K_3& ?! W>K	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v`WU$/! $<v@a`n3  v
p
u$"<uP>ȷX\PRt P:1߀thE]!&ă=0ZXx` 22PEǿL&PCt5K=KtOu570: u	At!?s96 u5 .\s
t!\&q s   a
׃/콿_3 "sfz&=  V P;Mu 0< ^  3f4G -;Mf{_ o }0} U!    (M&egWO&MuO O}qfGtM!t$Ot, t"OGro ǾJM0oOg&?M_/` o2%
<t29o21_kt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇2a&ES$`	&M&]AH`.'	@[%# r`S UϠRb۶0ZW&= uAnF:%I)
hJ
 m_XP
pt   U!w#w !#`ފ|nhS0 b.-.MSN=tI! //(rJb.58v@Mu% @BSB 0hgshaW!$
"1D hH
hCYp@[X_Ë
`PS@e![X SϲH<vLR
 Z,<u(Rfүffġf,ZJ vGu

 jS1 6у[Qa$ ;@aÁf3fh!<`b8 {	4`֎ސ0hu73 F
t):u%9dD	& h.SK & 	 h3ނK3G_a!3 
3 @  K SٹuTu " / [J rGQw> r?;fQ  w.<t*tR&' t&A+  ˹'z
z_'+Q}!@s& 0RµV|Z`|tpk hв YQ@@?zP^[r4fHq(u% = tR0Y *Q
@_HS3K+6 
HHǋE&NAE 1, @r \> \hpӼxxf1  ,V{A @p$P<PtR>eZDAAO  ZGpZ^a/\WV 0  Ph"X@ 02)
C@)2]ƀư?!C@u?r?@Dtϊ5. ׊u,u1 
@a

+&C323&@t  %
t&
0  W5  " Z  ( ~
u: 7/b!	"	? A%w ^sPRWAC&wA &]&U 
t ˀAi{] _ZXr#3һ -wv2C.u#o/5$N#h΃&_ '^ Y     Հ>u  '3W~ c[ 0_jmYf#`Zf3fcu 3? Q>\K`[C:uBE&8Uu8p]
R +B&U
ZK!ؾjZ6fYB)%qr hkʊ ;/1	Q(t0=
  5Ãh_~p8.
<to0Z`ێûߋPV#
@F^fǠ  X\KE_D
yC I nppUf``؎ Fw!m. ڎfafSfQf.mf fff#fYf[2VftGf   ~mIg@f;t&f 	F $f^`2ۂۈfaf`3pfaPP3_X.>m+ . P	TACO Fr  
t!	& .m 搝ws<F	m fFf.m  mF.mf.>m;E.m@  tmttYpmtNp  D@SIVfB.f$;VrT%1W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p m%f@c .f³fHpfXfdf3ۃ!u|+`s?I
s*"/S"Vf+f;wfff33RREmo4^q4'r44$.71p6ɐp08333Ҹ  QW>% _F
3}5u'JE#a0 t{ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^F ujwQ`  &t Y&  
 < tr&\]p &_\U  
&^kN!d K
SR[u 	F@& $F^[_b?F FY2p߀TV'?}PVWًо' }L! _^Y[XWfQSg Zfat
  [fY_` t =$PpnPu2MtaoË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jhsČD^XP
~*F
  tI# b Q`lF @Fxq d3duhXKu`<Uuùd `hc4ﰭd & Xtû   h;ͻ&p PhE'`X!$!   °rs} O
ehH   tt 4  hMKc` {tKu& &  
 ` h,s@<t<uuТ 
0u?1*w`P	h: 7Xh % P5 'D[%ys%aP?Xw$# ) )th`($} f.`?G  c@l3 EDQl۹@77 À   ; Z x     0N@`^~#bhW1fF3.Mw% rׁ 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KہSw.~r@V» 㐂û< f ff @ffRfP'f!N
 ffFf3fvZfFsfBf{〶fЩ1 r9pf3pǿZlfAP  fafPVa3v޸rF3X

S,0<	v	,$=y.[W D`

Lb f s ^ f 
T
T p s 	 
Sf_fp ЎfvPUYP, P}:Fp
uf^fNfV_f^pPrRp*fVA6*F@20hC@ Ϣ
 ff  fffffXChq p  `90z P9󤾤{" 6 a)P*hkcP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMShm  ߿ hHCwhhSZ?;PSS@apq$ q!̰/u!A tðvntt<1w}(<vsvPEh3_v P&
0
3q 33ҊtW/g.&;u;@.ont)@)hPmtν؀߾a`2G@t03@ @u  S_[
u93Q2,;8cN 

P-j1rX߀?03Qr |X@Y4SQo2P5'a&& &0hYC hزuɰ ho
t[ Ȱ t
ŀv#t̰,5-PX~v8v&> 㟸`t`_P3 u $h<J
#RV Ps} uu22hSgu]5uXP&
wL2 Q޻ hNu= Dt= tYԀ'
YY.^Ze[1HP #@]U  Pf/^ ]  `rr	 V$(afOLPHp      @6P0;V(e
u^V- ^"(P*^ߺ  2oMqSP( 22 pX[úB  $@7R  Z`7              zDKt}P( % $近 0rxfL+  ك%rSr$rF!f+Df+\ r*Jr3w r@ .h&ifa2 PR30 Zj@AR `&Fd??uhP&Xh$ r.>.pu 	AїQR.@h f3f%  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t _若~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
5ﴀ0:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCC`Kq (   ߢP3_YaPSRP3@mn??[`H@4$&%<GP 	 oپM <BMtf3%ĲP2W X` Fry
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 f@3{t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff60rZ r 1Y`W3P[tt_rހh`D trr	P}RW Z
xx ؎P.BB <t BB2J &ݾ   8u!@屋`23Ұ
Sh)TSt0`́ y aut0i at]U U[aSR  4hj
 h.ckZ[Õ`-1PԻ  h?9	 h"
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0ߺwZhEU?2<U|  hZ2 u
3Ҹ EFv)v upQstT 9 
7( ܣPf.  UfQfRfUfVf@Ch: rsNrG 2f. ff_7f^fq8Yf.> fHgffgf_ uUYKU q\ u, P3	fgf CpfIfAgagf.#f9kukpfY'Đ0    /p ];7h& =T8( ?Vm萩Q hc󰷱  h߳" Х  >OV3%@t u;F ;w
V3"/fUi &g3  f% '"3 #WFfF^faߡñcV p @Z  '
^Acq[3[<   k DTDw R o 0 [h  1   l ( Pb @0 W HzL P`A T W X~b, `
`! p@pؾx o A0
|\D`QWhGF3 3_p 0 PQ= `tq1 @0YX 05SPp
& p  ff& X[@aa"&    ir  v|"}@Q  JV傸O fQQMΰh2 . /ۀ Ӗ 脠 <t  l~ tq.ri."D.|u.:DtSI  wD:r5+s&v
uAm
c1PQoRfWT3^`
f@XÑ2a`2	  "	f 2f@0f@R %  3f3fSPaX Aih lUv  fb #&f fa dD 	h}W" (;sQSf  r_`
 t
2fOƃ	40qv!a
 Q[ffސY+vf[Wf+_f t%ȡH+f@`h0Qpgc- f@kf`0z q_L2_&UÃ uZ=PrUf%е uCf*wf=`  t0  t( f{ްf
1"0"fph2%/$8_!"
 \\-f g&%ٻf2@t
 <t+p g1~f&f  o , Xup Lr}=fBt<rfa&'?rfϰQЀÉ_Fo?<qP
 ) 
"a	Ub	~p@R2BuE1cff׉F &Ff{ t@sf @{f;~t	uɁ[~qNїV&~##`WfVfPXfXcr<w؀?.'0ճа_Ѱcf@&ːtg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PsP0Xt'vt
t@0r׻ % r/o h>u hrs-3&>rqrﲁRPz?sRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph ro{u
@ Ѕ&v  ؀>t !$!f$< u~RC  
N<2<ăƁ	"w3A]'y@h[u TYP=t 
u2Ɋ{،в3`t<u
E< tȵoE$<u&w $tRnVL  N L Nwڰu ` t  Pj[2u
@j jY!(!!2(<!1ʰe$ h5u$0;tM$_~q.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|hg>_DuQ&~% t PX
 ԛ.:t
 ._
vXP%8Xr6%ȸf)c4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
߲&;r"`p$t1TKub 
HM` `(q p" sr#J	cp&v3a C 	H ]r5r=`2gpjh!vZaVRQShY4Thأ4J"Ҋ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph:X<?tFhcRUujjjj PZ9 &hX\ hUcY$vbwt = ;t= Dt
hE~sp[@WVS$`́$
5][? @n< u"*׿Oطh񚾓Nt`-->J=Ot1W 0_ tyr rh  S^1 g 0 hL P5[ ?  :N2?Aq%  	
   VOFPgbǋVW 2_2µzt"@uG2 
u
2% /
 o2E2&&&EA &e?
tdƿ&E&&E E &E<r&}	r@ VW^2۠^2*à
&}vPuh_VRPRQ3f 
%*tº,AYZXRPSQY[XZh?tu	pp Є> qQ 5rXYj->: t
*֮hGFRL&&  t8t'[ u aq,& nq00r6$^$ Z& && ;`Z@ `dde`P`  X3U @>
  .PB B把8uG` A ; 5/)䊺@#BS 냑76VŜP߀X
 ~a@A@ uB C    ÜFt𻰀V$%%蝊<;weĿ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу?E pY8@C0	 ɄFWYuF5<?uz`0Dwf&	2
pu}8f߻hNePӀk 'B@. ,".  v&k !< uf& bÊ$
rۿ wAu%1uhSߡ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh^~KfKff
f'h*?f3f3ɹ f /f0m f+f3 ! Ku*آ'3ہEsV4C\` a^_^fZfYf[fv3hI 5U`2K L0s< |&	3ytvou4PP? 6w-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?{  .\3۸ 2ҹ*@GaaÍ6̨hVWa憎-z_^pk` hΫ$h  uP$<X5&sf @  t<   4 |r	.a$<u
P f3hh.` 
d]XiJ	h1<=  tdbw_3s.>`Nfm thtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  hӳ`5/
P	3kh}BFe:Ffu1r,
 h
 Fdt;   	:  <g htoQhȔ}`!af`7UPKhc'u>fB057!SCA[t$ N hD&N r hPf0̾   F^P XSĻ  y ,    hb-[t(t@tU,Vj Pj,>" ' À thtZdúߋw."**ED/.EqEq+Ëy؀d/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYe߹b +Πu"<6Fi1 ep~0Fff`Fup  0j(j	R"	aURUhT2  ɺ 1 h]Z]ÓoR+Zr@!  tCgRQ QK.YsY2$
 !uK$0dU|Z f`3  3uW fIŪ.&d"^fd  ChB%
>C ƀu8u.>b 1fa
ZURtLޱUHhkxk:Yn Yp to(tq ;CPZߋi@"gm  squ4@?VfRf恎h(%0;^f[r]d8" [Zbh3Vr _s 6Sj@ 2P sg rGZO5'_UqWqW`.cuQK$<u:`pKr"&  t  ttb tAt $uPq9(
ʐ

 K`XSQ 3u,S?蘰[rE	ˡ-Y[C& <ff<`00x?x00`~||	>>.p~r tr~ (ЃrL]CX̀'tCVG _=`Q<Q7W &TZs6C  E ц߆ԆrB zuN! D /u 0/)0/f#-&A ;q5 F -7&/p0W aUfV3vCDPDQD 7@4f^]&[໠QPЂ wPduXd@I(a@ `O` ͟/////- "  @f%pꄵкP ?FACSPJ DBGP4BHP  0944 A!  8  APICZOK	a	
@  		`
  MCFG<	P	 = U   @(@
 2! RSDT(  	f`hhwsif  fh0pfp  gfFgf  FPTR ff0WgF{pf.p^$f3..f.f0N0~$f;+@h~3ffgf&f.>f(.t22@_~( N g&F	f P  rgfffff+f+.
aM.?>f
$$#DPXff-qAFV3g&fFgY[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr>< uBONRUfQъ̓2 tPpx@rAr v; tg&_P)XfY8]VfWfV*f& fP&ؐ@(#f"fP)6Ȁ$ 4 
Ȱ ּ
ff	hcp (f t  hgsfPW EfX~3 wdiZ$vc g kr+
h*3=a+0Q;g&Ƴh&P_g  PSV  4[Yt >Gu	Cg : uDb& ߩ@ u  D` ^ RW D hH> h _Z!PS~WtSǲfP3h f&L f磖 B`#L fX`h%Q" 03fpep&?   6Mu z   DOG;Mf63{ pG   U!   ?M>(M&geE E puMPMLGfEtXAt$}Ot3 t)O$fM
rþQpmMe&?MaxӽܽU  r.]hӑ.d~<ko^  Ϳ #lø ݳ BltWp_f
Ph#6k0kf$tt& t E'뭿 5(P)io_ԜVΎގE^3f`FF  h?w }ur h  $g(,0w4'8  s7Ã9FtFfNA9F> hg4:ɀuh(fa`
Ew13ɊMh$ӯt

hRp;r#uac5WF ^SCf fN^Nf.91u 1tc` rfQPH_Erf;^uf;Nt;ft) @ 
tF~U_ս MfOV t;6(.<t1!QU)h:,,5  ^_U00 u,h..D+hXك p1_fqtA"   u
3   t}'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCIAReflex v.2$cr$HP
  ߮a@!g&O@ yG3d `P ߳ rLfK snr>G	_ .D
A O@.d.D4f_ PQW  
G.g&:uG Y.  _YXQ8t *Fg 
⡤'fW
"
@
@Bg"

̓%Qf_V`bSh1<0Gu#{ 蜯 euu .au = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.a؋V@< t ^Jv 
w x y 濸  h:Sh;z %ZMhCasia
qTrPqtI	f| e
u 
!tQ&C^	GYV
}  ,`؍vfD   ,AfLs-<t(<#@06~ h̓L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXnf`3Ҡ&w&h#G֎fwv*`%hÝgf9t0Xa` 2   0 thbq egf@ Vff3f"gf1 F f0ȱf!
!޾S3۹: 8tCRP #ܨt ro1hf uf@q  00i{? 0    0  _   q'  ' Dߜ 
 Y/[ bbk`oc@GY kLɖ 1PS_.xVW UȌ׎~Qr&} uRBr	W: v_^d>r5yr!r\E@&=u	_#$Hr&E$7u5#1¯Yӆa
ÿr&a)rI DTtr&ϊe`4o5`
T3
Ëʠʗ4S16r#@itct  t$?BaffLo  	] 	WQ
RΡ3q
]
1L1i+W!z Pr8u`_QY?_ þqL[ r&U߀þNLq`
Pw4$X` $2L nB0<{tH`8u6
uBp & DBlTt
aP 3 r/) r%BB!J@ 
; 05 a<t

B J 2@u8` BŅI2۬2؇Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&~a$vQ> Yr	{2Qid'Y߬B@Aq Br蹐B^	 ofpb3׾SR @ P`]ңPA\SX 03  _YPSWQ3߻ VSVt
KVt2Y_Q f`j hb  H_ h	S7jk h.f% ff= @u [jh nc Sjjjj PZ9 {g\ hUÜ[cuq?j&v^$bwtQ= ;tbu= <t/nEݳ9 hZtбjfaÐ     tH{!uu)Ɵ:p0< u}{up@ z`3pr! gr DƆ    r% Z ׃-Zҏ1p$Wp_ǀ uu' 3a re+ tg	%P  .afd,f tΠp/Y[}rߝs3hƴ \ڻ Vڻ> Pe փF  ~f iߋ `] tIe7r=? ً~ t@d@t0(5@ MF t w0ɓ3N !F ~ tٳ	u?e0SZAt9A`jEf` Wf3Q fY@ I8.L"
 z/2uJp2:!&= t: %J r> dl0VQ&Uq
MsY^D^
eOf"A	
pq
&:!Ơ& :X.ۋ IͿhB=B 
D腎@P (3 ?w  A-snC"upsV1u[	q	1D!IFt$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7R< !*Zt|'
QVJPf^DUYwR.&dm++t'H"`X{tŌ?t.a:``s; 6sbsd_p_pkodP6mooo#eooao
fo4bcםaꃿ  AUO
 B141XG08 V.1
BOE HYDISHT14X1B-120

QUANTAPLAYQDޠL205qSAMSUNG#LTNB-L02
TMP1EA0VOAP4@3O@M4A.FL072
              vȎ؎6qr[>e  >Y w 63Ҁ 07BA {8u!!u
( H 8u1	3ҋ?hkiPW
 
t_   @ك
_X( 
  H    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h{Bt & ^[SO
&h" <[U샿VWƿF F@    dZ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3PZ9 '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 hh<\2%PFAx~ t
F`_^Q
hV8ss.&uduP   hb,$?wط h*"ht| Q#h*f_01Fh+B%..  @  Y(`p3WVe1E0E.WV .^_UYP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	 +QVW?u% p ux 4  | = <t m;@C
 )(_^YqRWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Zb1SAWIpIyI
WROujvzKMJ; DE<@ ;<<n!<3aRu BMUEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fsX^@t#IgO GxnQRpA3wۊ9 r Cҋ97wB`s@zfDf3fË\` 	
C  T U S V 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.߭h@\[+V..^̋] zDF. P .h;"Xh} ؃4R  16W  0"Xa Y Z #[  
m\a a _BA]a f g'^a bN ` `hcij!k qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C./E2P+m?n8o7@W3۸  _f^߸^6_>QRrkPS[XhU(ȁ`fЍYӋwh
3     xp     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10z@03/14/05 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"Ϡx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGIuu!
kүx00POl}Dxe``
$`$p

xb<
Pxx txDESxxxxfD@/10y}}r k ;K}d`xGBF8&x}DQ00xtxtyuup
*}iQb}ps ~aU}wc+½*").xjD00q x^Dx_T_xc{D 
T e p# ) ,}1_U
-&0=!I_	P1Tx"p2xp3T0//}@!T^ ^ɀ$ u!`	{T`#8 )m&04`hb	р{P	;G	¯"+u+$?4?iq}T+}'Ư+p (++Ô@]D#,+G
H
0%1ܛvP7/",`]B0/}@j.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @UA
xPxt"xd}<}?!" * /}AZ#/00x )xh`xi  p~ 0S+;.TB+x+¯0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$P+-` 9
Q ` ~Ô2@VD0¯xx7x8r x008`6%06 @T߀G`	p>4UHm9A@#ZKZa150)4"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >?TxYYL)^ZLL&	Y]Wj`q!j0Qux^_DND0= +>@  U/>bgxdp&b]	:<	Zw?h@jQ@*ARx-	+_SRNx*SMx+` Kh `R0 
0oeQ`
 RWS5PP1 03X 0Q]pd GXWxZAYAXNSXW> }X$R0Yhp^qZ1ZTpL[Z1±
Y'Z[l0c1\\T=0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ">4"7x'D
 X /7d`!7g33TT7?O`C`|`07`'`2`=`HpQx] 6uuuu0k uu0 u_u5ˏʿO$ƨpN`0T`
0100@A"| }(Fx]@C"+,,E+p  +C,,+ +,+x,+0@qx!,,,++x_,,"-.T0㧠L721t
!Mt&Ipd `1g	11![txU!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0|" *xc"+xt`
o3x70x8W7tP}0h"[ZY
YcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x O  ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2t?x1tI-&%[0& &xpvv ?&xp[CSxr#$ % % "2x1 	  ¯0 $"@K@3w#b0"	Mx3C
r beJ"xqF`V0 p1#" &	x30$0%<T{`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hp`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D"0p4h4xlx}@ DT 0s
 pcpB"pxt1xux|"xtx}xuxx|	"xw#xmvPxyvxwf`Ӏp'xw ( Qu}B@
"-`a"x-Pt %-o0p0p tU0/0b/R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0! H `p$P	<0
`Tb" ! R0  _ZP!1D12nѧ2!1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)n柵vpP*r 3}TOp0@0 0 
]):Q0`*/[JP*'2BP`FӀ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$Mh' Ô@]Lp4Ң

$Y	0
	@À{0-$`
$`$p"Gaބ"߀V4#߀K0! :0!@À-0s
   is	!l~2!
2xnfPYo0*2d?|p06SU{zy f xovpW-%_`gK6P2 ( 	4  =E @;H	5345q3`~	t%5544}r	@ :0	h0"06`	2A[06< Lr@1k 
  
 *90 B 6, 
j6	" !!`BQ
p0( 6g"E^ @
-NU
]D7U 6.
j'	
@bG+6,y ,y=f-e2pO7)0	LoP85p
y&0y		ay	0
E ":"0y8;ofpOd:!/c)P3
(.Cxm`qe`?0}DН h,g,!a,a b}e"4xrMNOpxD  Pe4`^}R Vp0
T4d`$"4#ap~}e4x_d@P3 0
3 $`3`3$`e$`1$%7$`9$`$`})3K$pvA?T nq2c1[0TxvF>&`!	0,0)%m0Dx  Z30a 3\mP)6P 	@Rи?&j¯4!`p` pJTQ`xj  N*`/19xv
xD}O}`&h0{^`
}iT?Dt?8`PUpY9T~:ywOq"[@`T`M	0676$``$p``1e7`tg7"r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*xFt p[xBB~xNNw}^wxJqJpȏ:;_<t/?=(x ү!:%$t=t=;2!(0 (=$Px`vT"` 2'<x"ү3y:; 0( ;:@ p0 xv6QxV86}'p p 7  %76o(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(  4 #)4 040@O453``/`@$pN54&:I&duP2);P [x 
33oppG*L2]>gp1 ';P"ސT~ +ڵ?T#>үd`pxHo 8@22P65b3e1@d@>"01h/ 
m
`,R0xA%30 B1
@
 0E00
TDT@5q0	 3:@a_ AP}Nt
 u2P2bt߀l@
G0.
@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM"^p  d.1BS)x0,u`2:E,`e4 2UU.X5%.?,*ۀ 2732pha,
$,SO!% *R5 }
Q'x`S+0	+_- )-R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp/,~LDy}?N%@k53.Eop;OCD.2qXċTQϠu:93: !p	S31B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_0nX6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/;u1
p< u1a1P؉*C{p4z5z5
3z*+yuv {| A+ 90& n`AT0 +	al:hpd010upov6o,/-.rpF}}0
~P/.-rdct%,f Wu tq70YS 8S;_"W4쑔p1BŐ}BT_0=+_<I?_`$<p:T0Oő78e`pYלBxfSTAx`%daz0  87>P$4 q"W¥A3	``"uqq
r	1Q`{0
+}
9ȷ"rdP9$$P6"{ 2^F}&e
'AChS4Iq}a X@apR`pLxpG3p?u]1$U^#5_`@TU`#v@|T kx{}Lxzp R{xy PxxPQxwMxv0Cxuxlxtxa{xs`xrxqxxpx`{x|Lx{`RxzPxy@QxxRxw Cxvxlxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TkxfQf/^p0ᒝP -^ ##-{---Εi C?",u/=212B0T-21Կ^ L.S.W 'q,Đ/$=7,T{AO-.`\۷pGJQN.E[.NJP7Ĕ0p0Y))y0h&
P5
Ps|?`d7]k}OPn,rt7ar[4Ng0`a2Еf
p1
P

Q "u- w09r"l  },n1vg9_,  A3.0Q2O.pM=1s0D@[dT0uǀ`zP;kDS,c,u.B.t` 2 p0`u.Ta2C
.%TO]лQN]03p	 `` 9a :b K$ :b)NӔ@6S ? x0!  x60HQq7prrqxvWU	Xu

		0
  `
7P"q -
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axj6"]@t7 C9xVxYFdҢX\`T`HTǯ
PMs>@C!3"x)"U\]@0!Qqڢ97F 03tv`
pUr )J'' 'BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`=J=<A=<aYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp @0tǣt A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?6 0 G=k"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/*iJK
I
cJKL;Md`NPT&` v0uK K@ 
MLtS QPHKJ}i}p}~}wEAMI!9..Cf Ô@"TxDTTAnp @($0*ZE;@B}@RTs`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQo HpHi"pbbrAt"#xbo o "CD)p3,	0Np#q! b* 	Z\9wV NXV$`RQB2b L$BaUӔ@UOaůUP0	xnZÀӒ }?U`#`5?`2$pCx@x% D4SS [CxaUUT`?͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@_`B<pxr
T" Pt=`ixo aav+xmv25rt4}pt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂATAAAD!@b*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAE9D% potNA8`pC,D
 mT Ag ۗ@$KL7 &;T F87#rTRx@ZاEQ
ha2>W`P A7O0Dz=Dd
`#pw`(`0{<`PdP`d`U0׊U09NN!ǈt=@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtx x#x> x=t~p x@t	0xTВ
}@%x"Ttx!TTTaD	x?D@xTpT@=TT	Tx= Q
@TxDpi?=DDTxjv0}Ct UQdMdR eP`eLO;K"x0xJ1"xg/Ls"B S?/?@>"$"tO>Q$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H鰊TIY1	 Q
 I`A @tR1~5HWT& 8 `;cuTuTK0T"$`($`*`-w/rp4
TB V@CMb Q P"RLT$`6$`!`0`?$apA]D	:3P
2 *}࿣05 #'/A
,P3`G`[]Tp]C"T B dpF]K0$s `!DTwwq/# TЪ0 U "P$pR_	PLQd`DQxgQ PQH? Hdq@P
qJPoxgv@K K K K K
K(KJKNKiKKKKKKKLLLLL#L(L-L2LBLhLLLLLLL  L0
1v"xrMNO`uRRRsx}e  /x  "%m"0RZ
R;: ܵw"} HGG}0"uS@	0SSST
TS?0CSp@zu 0P/ 0@4xatgvajQ/jxTxjD0@FxƋGxbx"x@$xx"x`}_K}IF	
Q@L0""3`H.xT| } ~ Jǐ4Q_*N`PRR &NM
((sMFMLNUNdNoNzNNMkMMNN
NNNNNoN.?PAÔ`P/0"T? } >00xe`"QfSQ1vPJ0pV	`Ы50T;2uQۀ0K  0P0)	OS":Cm$p
;`!/0Qp,"xdP `e~A3~"~}e 0?ICR3AP>2IQbHbQ!0M}PEA@JWCWEa .XNY Q`lT0 ȀȑP O]0#0xD oTxh!1?xxhvY T 
AApB11u32}'  $31T3322@"O0  "(IW "O k p}"/*Oݏ0/ÔP/pC0S00O200 ۀ"
xp0 "pExƠ`B2345&k@"(t?3t 2xA325R4U5B axQxQD{QxQ  09t6xS^nS }CSQECQiQQR45 SJSrSSS6x
/0!x
tP/P
߅0/x
  x
Q{Px
! $60#t #T %Qxs	}TBxr0xrßP2P]0 p%@$T$ÞPxPr`1 	^,1^&,-u. <Tү$`&`p<Pq}_ p% CBp.-,6	%xxsӔ@v $(xrvyrxssP!  P&0{ 	r6
pxv 6xa`r
 qP 0	,x?x
xR!x	06Sɀ)^PM$3p 06d2S STT
TT T{T	T
  UB{>pwfDa4f D@ @B@"xDbU$P``3pTOW"X  +D "vz:hTph`/AE@^E *@@CEpi* O0~@ }w 33TOB`p@r@0"p<`p}T`- ,*,, F5@S,  lS,`xevS,,"+,/0,Vd@VAx	` }wNPIVAu0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_55,Ӕ@xA=-  X60c
+p00Ӕ@@6@0,	`	 VVWWW=WWWWWWXXXX?$XY%Xe&Xn+X|,X-  X,6S	XQxu/@xB![-.![P
.-`Y<	
x3 t?e.?pt e-``l	clQrl"	`Ax@}v}t&܀
-   bt^,Qev  q} pQ t u vAO}	}5!`N)q倩 Q!q]G"P/u0 ,+"7_wZJXXXYY
YYY3	Y:YAYHYOYYYcYpYwYYZ$3Z:  Z5^PXZ:Xs U S1
tt)ŵx#	
pp& ,D lTQ@ST0BQ|
b@Zl0'0SPؔ IZP  cZP[`!!I0~GJ{t(ಚDc4rKrgQ
x)1O`D1P,1P
`QJCS[ "gD `E -Pc80.u,,L,SÔ@ ."W,ҰP#t .`
T/Ӕ@""@
u/$ -$U/"x@|Ӑ T"5}5$24? [2x[[[['[/[@[I[J[K[N[Z[[  [  o_Q	xk`0/_" о 0/T 6uq(Q`Aa * " 0f33o%$1A_Pe2pG22640!+4d	`d
4WFPe"a?nv"qߝ"44$`$`2$`B$`J`[$Wpk0[3P S0//V_QR
D	zqv34A@GFG4pS
Hq
D""""0  ]v]~]]]]]]]]  ^ u2#^#u22b ! 0! ZQcPyA=r!
C\mb 6r2UDE.u8QZ/0!rHQ R 0 3}P2"0"x%0T~t@"@7@Pu@@	T@3" O0!xo~? d P""0 Ɛ}t 0	}i^l:0x0x!TT`Dp T!!D`!7T51 7ZxD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b`"
% F`7@0x+ +axqa;+s+I `C0/+xT 6 } 2}.uY DT_`6X PcTT`40	61 ` S 
0cx	+$```9@=`xv 0z q DxT"ҎxStTTH_]+xS+<x, 6,@C`$p#xSxݗ+	x060/E#

0_ "p.-Ô@-ӔPq @
QPQ/-$$cp50/NC.I}. 9VPo`@\DkT ]P-Bp}} bC..s b;@X $~SSN`R$dp[. .|Qs".<t dpDaQ0Ӏû/@ۣ.ۡq xk..TP"-.{{ i"p#"xi7"! 	ӛP	0@@0߀ ÞǴd`PÝ@ӛ@*pشÝP:;<u t/t"/01234u5Pu<$t}5}Ю/[cÃcdNdhdddddЍdЎee3e3eVeVeyeyef:f:fyfyffg5g5gXgXg{g{ggggggh)h)hnhnhhhhh˽hhhiii(i(iJiJiJiJilil  i~K0~ %~ p0% pC3/}u: u; u<3{bhߏ4iT330PW66
~ 6`  fR3`075u3@u:u;}u<{xu{{X$::;<{&5jhg0  3h)g

-RK>,@1E` 
} P0C3+R#~ 0`| }` @^_NR#`##(
"&

R5P)*)Np<Id @(-
c# :111{!7(+(/**81,/,h3/1/5H13G1҇O/]|@TF1R
BA$__TWB1 u2d I'8B=9='8FGXCWCIˈEE̪L͸GGUUo`VII#M0V6P!}VbhQW/"qV πu3/˭/\Cq/4"$y`yp!SPpnz @@ "@A~G`jPj$j1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@ABOr+ 	 	UU		V 
 
W
Bxs		 ے":0dx>T=@Q
38T>?`dkP?k>IIPw0=p1;P8i } P' 8@
ఐ| $ >D H\0
0k7dn Ep6"}`~I }oP k#@b!p1Pg0ڐ}P@ HTTn6 Yt
䣾#Dp#0PB~߈6+r++/0
~IС+2!_$QIuTl@&nّp0tV<.p{P 
41nll"14PmuD1xe@606
 0ǅ@60'Qk0e}pp
T?T`4"4" u2<}0n0`~~^z0kTODt001p32k2]* u1tAD00 	3yP)P08@PQ@`2VPD2B32ӷp087Pc`&jRP@P}`"aR{3"0PT_O"
070% o03g3@,pe0`!01?2_Vbeo0oP3ఊ1!n10~
_  c`5Fg9 	1DMcA&F=@T3`02`;:+"45775E4`546OP
(4`i77$pTo`MӐ4}`TM=`` `'p->T
r AE D i0$CBDf0Wq BݿÔZ	6*u1au0)<'2u0p
1}}]34Rӝp2u2u0@O*> $3@P20' ac@'
L`1`2^pܣEl;8002`BTTT%%Oi>6xEp0>3`Dm
` 
p	0d`0a1\Q]T?`<@7!?$p*3tT9)	 #c H@J01	a=2`nfO"c"Mc#N$'NTRtnپ*$	??
o)$	6
??u)txdd7eU"}{zy'1Wj7u7dj12u704<t`uq/'P~ sd./ds5%t#\|vh~@_[xtQrtY0ppT0qN`۔L=2t[	ÔPt  q䑘o`v`z45ӼV@/Gk4373  ~v0((svrvww wEw}xCxyy{{||}Q}}~~(~I~j~	{ z y4k	5P4F w
QhST{lSp)1
3D,t~5{u4?`u5 	]4T`pd` ՌQ?
p0
P!Fu	r	uzLoBmP[|| ax>[}} pmiiiPKß
Np&V$0/餙Ziz (
r6_7d6 N6@7"BPnRPJd0,v e5po4l`&{JPqw!]8*8EU| `z {E` @\]Lvv8999889p#!#f8`9#
							@45q0F_ 3t[c98(d`;!PDA-0/* 
E0A
jZk<uÐIIP2S|U~dLp{t@#aM`M8@_q;mpl`T@
`r/@;ňqdNpt/,V+`/XPՏYP7[Z|Np7>	 bUodppNCWWriҞ/T'P#^/i 4(R?dnJ&pf1h)<Aj=Q Vv>afx?PMrq iհ},KD|sT-`M098&0,P78+3 7gv3?"27}3+P~ A| 3$`A`yc $)~ 2ࣁ)u3#?ux 7 dER tu`
Ô|		q@3~jPt7pz9qTT Np: );4u3tpuq$x347P1`04Abİv[#p1 @On31%w@HD?6Pπ
΁~g1pc!2B<},2"u0_
03}@bY%N~N0J
:>p2pP߅u2f	op`8
0Ʉ
``619100bP"bxeT`&}$31PtP2"u}`q 
P"""4}{t t tP
3U02	~HTD"LION x9pP
 DQM{T":p
"aM~ d˒ Àz  0d"0Ӏñ 7p8`0@
D 
~,T e8 )[@pa"
,"`"x0 5"5q"psx 
qUÒfC>Ag>~ 0QR on`dx"j7ud8X`,7bP| `  Pnp	84gk8$24="89F;u<98~N98lpe;~N9E8 `vj@@~+k P" U
pmq< &Fx33 d ::Ӕ}@o:@>x#q,	:x P,Y=x@-_:Q SW<p ; B
ٰ0P]=<>?u@`"H  /(p??p>?
>Pj+@55@@	x&T@/"%T~ O7&} @"`"E"x!To`	TT@5S73o`p2D"C
xCpxa6@>4ra/T(--,r e,p,,~Me,`,,|21G3>d$-t"u;2<rA&8<9@Ju;;;`P9:݈0@ɐl56x>FM
 pb?b6655	d` 
GI~G6CM"¯ D+JptO*q+,U
,, +,0+@ޓ^l@T` fOFG$&^&x3t
 T0xT1QT4TDx!>CD@gp
0g1dpa2u3%33+23 2@
4pk0V4cl|N(%%q
_O Z0a00*OTieT		TYAc~L_` #Aq""	F	 >o	@2xpd' X LҀƀԀio3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``pEsB"P""): "P?%0 "b``"  )"/33ߝ@p " 3@P"Ø"(p p8u

r
߇		
KtQ
X
	
׆

} *32 	1	"t 
""BBE"""ЃЂOP  tsw6 s$Ńu1" "%5@bpp
s@h`1p1 1@~$1v1@n1 Ib1V1J1e 1111 p0p0^0p000#Vs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)    JK   P DSDTDSDTH}  7HP  nc6200   MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I`% 
u	913213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[O@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0AvA4
h<1Ы7E: p3 D+Ba(g80V1(@pwA5!i5p@"m7APFbA
iz9DF17B&$r8C}j80[GG6C@:*BA7
@
g[+  A8ফA9Q AA$AyC06D C0AE
A`9`C]
	   zo{` `za 0 
bw
t
	rabC
 101
a )T{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` 
p{z1 wip{wa` rbqAFb yC11	_9`p~Bw
h nwc }r    AA3
ccFB2
l
 B3 B)4 pBt e {ky
 B32e} `e Aj
4a{`ц xzq5@p #b}e
e/p !z	e e$}`@dAyA4{k
 	``z;}qA
 ЈAA y!-Ap?dr1p68d pA8"9 9oe@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
r7@
EbdB	!ba'c@z!Dby
PMT6CTHTPCIBb(px`Ab	s[@bB/cp7yacaABw'UC`CDe  dBob[FB9ŅGGGGD@DzB6 7|#BB
@ցBBBQBD-_PSW12ڡB`k (x!`AD[(0@iE֡ F C0
c	C1uVm	Vo	o	o	o	o	o	i	 Rc	po	o	o	o	o	o	 t.ҙo	@o	o	o	o	o	$N!zT%[MP 5c@#x`0833bý
[@PCB /@CC
P
[5   CD K ECFвD`OлD1 m 0D2pD33D @~  PD5{OT 9 62Q
 0D=:s
c`7
  28 0D9SDAA!D$/D(D///D 'D//f(!e!(.G !G!@($3(T N #F(F/,/M E0@ #F   //A eA !A N A GA "A T "c0EV/BE2g0E2//.3`03'3// a0%1a0%1a0n0a0G1a0G1a0@1BErtJ  JHE5	E6	
#  y ɋ Eh`и``
퀀`p`apa!E60E9	@	V}`Q	``[EA` a'#B	 p$Cq С	A`]v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_wSRSEBh__CRS5Wa70 r)$$+b1r )4f;	c!2r)C EDM h13r)  U[(iA 4r)H$`k0jQ(5r)3F$p{8k6r)71>8B[!a42[vF21F3
r 4
 <5 {[#"G`P9u[@KF26v1(W 8UO5 -G@F	QkF9
,r  FA @LBC :_REG3吰0QMFA`pPF8O 8_S3D
p 4p oFDRݠ}( FE
 h46 `U 5] !Fc7C0_KC100
48`
{	h`?{`h48{i }@
45$ q\._S{B_1ts._DOSq	4
` a|![^2bb ha[7CPPpDCR^FWD
 G F 7SShsrRS** %Y$
 
h7EFE	8hfp
` {w\/002#AO98
0y1`0D  7 Q   P  Cohip~8C@h{`>@}`  @C\=\/f	F1]5 I6|6H1N`'8
i;C0A4hj	 5hijCqa.50hR92s 1 0pm
p938F2 F)A
^/Ǵ0kl3vV+B 98` 2a{04aa`0`fBϠZDV	_GPE	
PWQ
Gb bGf f@y N10CnN10DN10P<#8F "10

p 112 3`
p 4/cD(PDpipp15
 a	isa`115[J  s@@ p!16F@417p # 8!9)AAB 11PsEF&2@p 122P.23Q 4 j5s 6c71289A UPBCDQE 130Q 1 2 3R335367k  8s 9@/3A!3CDe 0EA40Q i1 q4q44556347Q 
+494 Q4C_INI U4DO qDq~14F[  IC150 @@Y51:p 2	wh
@axa
db`t
@`TP
a
 @}a`*
;y`0`}`a@[8 3]< !azw`
d`xr`
  
@bau .54
q 5s 6
Q7
19 0B
CB|15D2E
Unknown 
NiMH 
LiIon Np5P}P}>1
  a |Qjq0C/1(`0=CP57
a
ZaD0m117FAV58@`	9Qυ}ha{a
/56ˠ}Q954!
 
Pp^Qw!5!5Da15F	ՀNP A9"C160	QaBp
P?{`~`JI861
[)h`pP[0F`
csc
  dzir`a[)absdb1/2J*(PccC	2m	hg3
m?60g
oU45D{`g
3M@4haC lN 21Q25pCa0- 128 w"Baxra
c 
_dcbpb'b,Cr	3A`a Ba$(`aࡔ-:4g!$ IX66
I+Ep
  W 	ip
Iq:/59."2BcDcڄF c6@0 f{``	{2``EFAA84  9H2ccdp e_eez
cpe'cpci5%4?s 5qp}
g5Bp
IBC`p
7`D5B!k!23C-'8vG@+yN)0W1FQ-  
qu>
>4(P2pzo
 5Wap%*!5"(B+BC@F`*se(a7hU/EE	549ata
!e
b@Kzch!

 

6Caa`i36
@ ra 9PQ paupaBHf:ba8h660U>992;0CUR=1c1Ur?22o [
069rAч
H{P   a3C
Sp
SIMPLOySMp
MOTOROLA aO`wRA~6A
p
 
Ajr (_Q03':Q{BA B4u11b}
4p
a4Y`bBaPQ0TZ6uB! C['cTZ3_J
6pn
àJ1a6Do
PRfP01A 
 M1_2 N8Et1#A
BE^F#9BnO116A9_E316

,
W{ (i2=8Ei$ŐS[IC170E
71
N 73F773 740  q !8 F 9AjABCB7Ds ^@17F88182
[ u њ8184886871889א8A҆871Ua@
A
!87M8a8ArҚa` 7A`
B>
 Z8BpOpi;8D8ErA ằ`cDbaCc3gFbQ paA
EA81c18P ya
 d
b
 bdpdS c
 c
Нc
B8EB`8F8Ap`kaʕa
v2C albab`b
vbyb 7917Dp`E7C9q !F#!AdBzj
a0E8W8B=C190#'8qbb	aq bbVQ91Q
A467`6f2
746" 66"7
q3
{C039
`{  iaw` `!{Chp!
`!K94	C)haDt0$b cU;0AabcA@'K95 p^^6cIX97LC
98

Ggy 19A A	B/ P99pqd79y8[B!}CF_C  _DDN
COM1!9D9E6
30U"    较8y `NS  9E_STA +9
w`1
3
 ,+_DIS {h03839
F_SRS V6h
aFcFr?e)r9D@
_C
w9

 ` c

n$LA[QA0   
1
_ON_q2&_OFF qPR0A0[LiA1SgMףF!# C
_G 0" *
g~c+#[":30"B K P@A2b! !P~A3:^<!q1As9F8!Ah!
I A *""	0CA7
r
;pX?#0A2s 7$JS3$$$30%2f[4`&8m&i&!P'`& $8[C:*9@?@AA}p`  @?AB
."P090QcR@AoAACIH
1 Gxx&xxg"q)x)xxLo  No r^r_ _u\SSACS`Pp%SSQ=CESASN?3?303LTaX3Tn*CGym3 *o32tUb0rAD44AE4?X4X550Z5w xxp
, `0AE@A[r88"6_F=_75_?_a =_PE8_F)5B0 p\/@uqw0270Cy(|ǉћ`{vz0 1tP|[Odd$aB`` 1B4  BB y
G``?Gpp 2+BCB5k
q 6`BuBB3B}3B7[%8# }^"  y s9%ڐw@ @ "-[5tah
 
 tP|
     *"@Atra_ a !-uBE
0 p Gr r " &` `0Gd d"l0BD
" X0A [!B")
UBEa  BEBFy&O.    0[+C1CC@
   
 
@DDC06C0ADR   1C2
D
[)C2C3 ГINIsC3[C4u5QD^ C[@Q6y-a {3*36a=>r:}d%'C6`0C #PRW
	
[N`C7"L C8A097`{` SjCB@D`>C9 p[ GGPE_L1A`D
C0D:	P/PPA
@0
0?
	_RMV O*_EJD M@B.!LP CQ BEQ F C1CC; C-  *FD ( %2S	p>1
c;t
6S3p 4 Q**tO CN

[A
C,(,A_DbQ#/D#	1#
		C T						G6C0[A6D7!NЪD ["09u#A*N_GTM p
7 `@BL  DC DrA!E lDFpE! B1FG{@@(0$C
DB!7%t10B
 
Q0
P
p
xpDE9}(F0EPKDDqED
C`ZMhT
hT
hT
hT
hS
Fi  `p
wC1E0pa:` PA` bwb
bw`
cib ac  rblO rc u`2abz2cE1bcaơ:6 !{  f1sI 3bL-@##M
joomjfjockoaAaPE$F  ,F !09RBEt3Q
_PS 3 O2<PbB8X97a	
#  A:8OD9ODAOEDOEEOEFLpb\_PICеhB\/fD6M`T Me6E

jQ5 R  1`Y
C#E RH 1

 G?C

 
	
$Q a
		0Q EF!`	A	
a	5!52# "cKB%6,!!! 3c !t!!G !Aap]65@	F
R  pd
d
Primary 
10  
LIon 
Hewlett-Pack?ard Ey?Traveloka	4~x@ j3-5P~Lȷ62	^0062h`/`p%
 

" 
 
]]65haEPAA6A10m9!axE6"xp 6ha`4hP6 
__UID sO0
_BI0^Q  ST ~ CL\qb[G6;6 `)CocrdJ6
ACPI3	G	gR/a005`D 57 $``Ahðy Np&Q_+PR0p1?81`ȓ`EG[:
 LIeD`-8@ #0
	/15?@SX%aN#1j"#A EB 
ʰC0@ `0kpyk`ђh`piaFa?0EB a{`
hs }aPap`k
  pap  @( C 4 1  &EEנw x
w
   y `2W` |hp}
yj    )>b1`h)h`a!	` ib`pbasabcpcau`a[D`FP>F0! a a1J/ o2iF3 &F4 5 F6	p5  p
`M

 P  r
` a7 8~F6eܠe[0wre
 
9q0R2BpFAILpapMF3SEgCUp{AAAY4aA5`M^AbLwrUB}CRUD]E-3GP
c{Fcp
W`B
#A3ޡ5
  sQF0t
ܰ-A	C20020!112 ^"R2_"2@g
54B  Ju%a%SIMWa6206F&O  b;2JT72`A10q  `rPASSA'$}1$aOACta`4Cap	 a14!E> ES?; 2CC+abOb`a`B b ubd TXqy20q `_WDG?
<4_c,E=DAAyB{M4C~ !f ɿ)AB0tWMAAuF2igj=10ytrR]p{ 6T@rI1{h
`7v044
^$`5 k047c5F7
,*m048K	
k cFB @L  , Aq3Cz#
l972) #R/*t*q*C:qk;{v68 pC$;2P	4	K52F!h658h	"P{_WEDs!('~WQABNߩFOM$  5:  DS }TK B"!,8.@YP!O : SAND L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@6?QV&X)xx52
9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =D&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`Q"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐĿ
LذWyWr24	;wpQvY#{|exuH#D#o0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'{[Ћ9 J01[9l[#\_GL_yh0o4BpipjҹkD04F\֐1hFl['['`[A

[AA1BACD bEF~C219DphDCC 1D p{zh` CFhZ7	B E A C222Ei	
E3DF	P[ED22627 8 9:A B0q2C @	D r92E02D
[ F@(q230!31 h
m31@ 32 }30 `UyA
	`_rh``vqF[34q2Facdp
aJac
`rd
  b}y   baya
a0/apaceraye
	 evepe8c ucdcM
534cpc  bpbgC	bdp apbe)ece ffg
fape`pfafgvdueA`b8`# gT `x$b pg~0agg7{ag`dMp6,05A ,0 p0`c+`bQ9 +A`Qy1 0CpB  D "h 8h H
bhxc `r +Dcada
g
e,2B-adft`f	ru'adSuc2ftd gPr:`4bA 3[7 F2CF&-@91536`Q&BaqD2Ca
_INI<37BC060pibhb0-8p0<38rb
D9
j19A"AA"bF1B w6
arC019abpb.0+bab`babu=aaP `bua 3/_CRSQCnQ19`v2-B`T`_STA t
{`}``6 9XD!

	     y q3p@=[K\/F2{3DmHH
Y3EF
RGGP   @  [  s3	0	  1	 3E[C\/*240}Q [196F
rG G$ $ GN N 
P P Gc c Ge e g gt t;    P A-\/v[	B1a

{
W!3p
`q ^^.C1705\_S0_
 !  3R    4  5   M\_PTSph%_37Hh
 Lh
}	0pz15t`Zb1E2 6A$\_WAK } 42<12AP%10E00? 26@6@ppTZu42 TZ1_
 2 :A15
ya8
p4@35bQ0
g
O1acbcc:c6D
V1:PR1:0p:1 
 abw57j5A6C1D8
 `?0BA-C1.2N3n4
 ,D\!P43G,
6

0Qnh

ob m[
p @
A	0	60EFw7

8
A93`0YQCD:JE F2W @50ОBpT16C
5`1
1({!h L!;0iiGi52
зp
'>1$R``Epi_Rdp	DP
3
hi50p
`pi`?`
p
rg#ip`OBBp54@`phah.Aw4Fihr@
!! #`5i ` a 6&NE
;M i`N1`9pK|H?Qp\R
   qqh0A0
0
	
 t!&
axa

`br0
~Bbt*? .oP$R
 R9
a!
.!H ~`26	B
[Cka T1
4/ofp{V43`p9{b
 bbwb

araMpLalla1p_x49 xq )aw2Dh 13E@b4 x/y
hFwI	{Hb  6h@ a`%  G 4C<g`s<qC4B4p !A0P7`hx3_
b !Q7K
@9h w`t`03`x`ofA@fI{tff .1tq7cbb7b;&8baFbbD
iP

ep
dC@V%;EDd*Eef$G#i01t
`a|׌AT	R04AarVa[ׄMi8@@i
$/_ON_U%0R[2ra2R_OFFb3p79N
6\Q
	A	'
	5	Q	
B
vQ
[iCg `0258["DH9CE؆AFB[H^_ALC 91@AL2	AL3C
F_GAC0 "1&D B2FPb3fPSVЦSLƔG60qzEBSx(,E4G5}p1E46p
{p
,48$Z8SQQ7?_TSP
dp rT`CRTP^0TMP5)ް[G0
ځ62

,"*30/$ D|\_GPEJ_L00qoE9 `tD{{` {b  {`{
a 1Cb @sc!a ` a zBzOK1 I{

67p9   ICB'C0DRo}A?CE["
d`fPa6`34OI>!9 HO;H0*_(o3 S/o3B67CSD?EK_L17 782?`} 7@2:+1C7@ 9C1Ey
5<F/FS{ƭ4
1RY?
?1EFC20Up)87842S863 `w64 Q+D|`E7 OG/98`FP\63uMCi> 82K&A6C1D7İ7+`lA%D8qFa4!Fq/a}>C  `79I
&F }p9`E$.""	<`
`
O#O#E#HL
/	$$h`_o097b@cנ@ePo4:+{a|*qc{bQ%38
AÐcrCcD}Co	eSSDT{qpkHP  HPQPpcpl  MSFT L4X5@	1 3      #__T	_w 
_	O@6wj

a14Ua7P]8͛67ij 8~  Ah/k2Ed12F 269_26A!9$@"1 J63031yj?2_@3=j-90B
D~@7bb`h65a bub 6C21s9A20Eh FE22rDy3C,
eb+1 y UO  VD'*[!@hPDC{hq6E@PCT 
1P6Dq C	_PPC  qS!6Bԑ7Yc7NLP7x7_EJ0mC80}AA0!p _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-    0      VIDEU  AIBM 761295520C??$  2005/02/16 15:33 #S' @<D	C
Aspen M24P/M22P 32/64MB BR11561 225m/300e
 (C) 1988-p3, ATI Technologies Inc. BK-VER008.020M.030.009  ptASPN11.v611  P24 PCIEDGD1UN  OEM 1.046 l 	l K$]B  n T1ŃzX
`TVSɖ :+  7:A@( A4R!Q  MOBILITY RADEON X600    ѮT T|  @ @ D  H@    !U	d!@ W/    W0u@#A@@
 `C&&L %<"0 &4(s0  p
@0 D ZHC`  -0  .@1/ i d`
 OD  P  o P`X ["| 2"3=X&Ju 0!4@A= x| 6 E qE+ f`U_ !U  P &BC/	m۶ %""c=MT#[
u`!q!"2
O0L  'H0D퀑DTD//D"O)QSB B1	1(Z @9`-1)dM QJ0'``/
s-[ H.@QAD0& 1w M0:LL 0a q9VQq2q#
  5?q<  = T- RU
!,$@l%. 3 :N  `   P P`   LQ` `E
H < B -V939Q  BBpmA -5?7p  ;uuR9_0 #  d o`a B   B rB 3  U T %jA1kʕ %QPQm&_Yn  %=BTPE J5e	  a? Q??q@EA(H?pH?a*Xn0$p
 w #4 (dt@l225Q3x73ߌ
  nPPr`U.U= 3mAag '0lt.Z)b+;!Wsg
QBdh  c Ą  bm f`.>: u>.:.<	  u  `1u .>.9P u.>Ȳ.:fa.w4.>q u.w.&w.wмy.wf`fP1INIuIcW	.Y	?d ST[)$
 t.VW	 _^~FIRE GL T2:13	P
U@UU$5UaT+$XBplpT	.
fa4t.b4P mX `  eJ f WP2X _W   @PXuC &GOfGGOOf& oG OOR? ZR:P@+ CCP2?FX 1FXfPSfwf-@ f
$ f$fPV:s^nt"qfPff
p@"q'U q"fX zqX=Zu>ߨ裌{V V4 
 6
Kݍ@$߰C PCX C_R ?ubr=22ft 0 t f0auAfÍ?ʛm $G  ,{@:^ u9^2ĸ tTe 
| 1~ 6@Jo$@  B@.^ȣ$$$VB <v  !  32Ĉ&! .@2ɨd^Ð	ҁ NhV*81@Ld
F8
0
aW@P
 a8 
1[ Y>vAE F
u6cަ.et;tavv"tv#c2>S6N)N=d2P< [@gb @ KbB   "t
u1#< $tu	P$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;c [# ~ tF: ǽFlfF62eF2vh wtÈn<uj`p$t }t  ^"N 39X8u P P$X"8t+N ;N"rҋNN"	F;t
~<uF1aa 0s2~@tRSf_zNf1 `IǑIK&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(P( tR.&%z:Z.0-[PR.^t2kM ZXÿ`\ @ Fvu@z=J	;5vv} `tU;5tEt:]r9Urmt5f3muif3ۋ^$f3gfa  C ߃s
8sn~=}:n=a	Ð   1'( -   S?BDcOQ]SMOVo}УhOQNgORrE0c	R 
l	jcgvWX ce
pVZa	cj| t[is  Gcf	ЮU'  q_ô|% Lʥa	d2 !ҟ6!@黼# /  =A)1nҟ 81Aҟ*0*Aǟ;
	
si	}ӟ,b	
#
.
ҧ2  A1K3E2_oY]M40a(+4ip !b6q?J*@)#B8ӂ4jU
u%2S.<t
 C[3Ы3Àu#ڋHjQ   u u 2 U QqƫFe
 f`f ҋv ]jUb_HS	C	8t	C$[. PRG\uP tW@ @J,^P@  Xj  U    @x`SQRVWc`f<t< tpux.D.< uhXG$?
t\2Ҋiptʊ»-2..;w~
( ( @..Tyt& _^ZY[A&G@Pn˫u
b $@_
@@qS^[НUu G<uTG<uGG%H
,Pt G2  AG%p	K`u/BJL k	 AYy@	G@[пS \Xno.6p
b} rJte u0Y2@ 3u.&Krn& i m
mYVQـ."jY賛	 
 pfFm FmF`  .%$FDV .:A |pMmu@{{f>pAmFLFNF zF{4Wo  p_<>SQfY_S[SWXP u2  )  ~@X_[(@vXXmX[_BtF$F&P
u9C+$
"|lXbXƵXX 蓚C `+f3a  v K^ l N    {tW|c 0V ) %y PFRB^Z,a X6D@C7 CBS$  {{PVWG
a ud
V"tQWDЭMt@uN,u'".VF ? faa_  t>/S/P/BU[0QY$ Ā >
u2B[X.TaDTZD@! 5tpUt Ut U@Ě0 t
 tt-J
tSuU@zA %?P%@
Ā?
XÐ( 	 c-'(+   t|PP c_OPU
(	@   c0	@ T(   3A 	MRŃ](
c    
   bco O
2 B89:;<=>?
 +
G _BQ$d "ozcfk
2  >?2 
P  
> @( $	

 0P;0 	  
  u    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8?@ (q,(c F@A ,
( 0HH0(,	H 8 H
8X > XgX<	X40TDgT@	Tf(XHH888' ? 4<P$
$ < @XA8@	d@Ap@ @ À?O{.2.r!suP =Ou{ &pp2P=: sX.$XqB%!&
<Ԣ̦.=*M$' !FcGeI$ %+6t&P$D$¦
N<~.;u*6|P8Dt	\S
OX:PM
X.0&G	tԱ PG	p?躍
u&.+X&c -_VX0`PW.E#ǴP_%w]udlu
I2`?X&I?UD0UD 3̓]U 
F CE]Y[	
 FXNPv(XK S[( ӆvv<uu buID]P[U XN- p4u<tH HU]Q S[?[S݋026'C[2S  &ߊ'B[ ĸ Ë#utt&FS޹ 2&?C@rut	 F07	 2
n Ȋ_3S.8
[t `v '7t ̓rPHXuSصS[P	$
k[Êg% oŀt4$
@   t$Ê`$
}P X3<J1u P<~$<t <t<t@؁/@  @HuPÁ@ÿ()3  @
@@ b !"# 3@tb
%`uÑSIa)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;{upuK>L tDI @.> ^ C3u&"0]<~]&g7[*0u3 3ߎ2PQ3f3f@  fYX2PR?4$@tZXP*Q  R<  4Z 8 b3"mP 3[3s AQR$WjDrIDTOD fRȊ7oZPRP, X#@ZX8t
tPZYXnu_T  w 2u _-3
t	u$ a0t P]X^0u0$0<0u  &o#6<umA	ut	
t0
߈ )<u+V뿴1u0*!*QS_3u< "	,܀4u< uqp 
hh6u& <t	 00=@SB"
: on`>%ȋ쿉^N"	 n Tg.P <Ȁ>cu>-@ 3ۊÜ$.B.Eq J@^X]`l+Ht8 JH  <8t<?t  .B   K%/+Q` K Ki Y@ 3Y |RQ
 JYf.-  b-7 *# ?#  F 

 G@s 	 Gޝ~~|ֺ| |88| 8  l  <~<0pW ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8]x~` }0pp0p$ff$18|||
<<a wlllBll  l ~|0` 8l8vv P``0 @ 0`   qaa88 |?| x" f<| <l |oƀ @|  ~ C P
a0@P 
  ~
 ff|ff f< ll  b`|``ޚ 
r < p ؿ `b% Ɓ|ְ4|~Zl) l88#<  P
| %| | -׾0Sx|~ `R   `̀ 6000q(v |8 x`flxlL2@ l ܢ-| p%| '| 06p'(Ɓ *2
v 0dG 61  8 v4plp;5 |ƅ8y8
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`?fl fEK>c8c> _ >a<Q4 g  ,+> >`gc= L G0`2#`?#: 0|w6> l<~61F  6ll6p` l  "6# U# w# #R#d  6 P P 5 `ROqPdJ U1UQ2d770?b?0aa`66 R9b@a	
 R>     f 9x̯eb]8Pf```p_d~̀Mi|?܀g8 Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S2tflD8p&mpK0t| oQi qAQف၁PQCmlEc%oFlpxpq5a q3Ԇ3v3wd҇ Qx>6`vfqB~~`4{>~~>ՂR2$ P3~ {p4?`||s 4S
@cU tE9_2`!@ AHiP!3pxF)bqfwP0v~mi {16879
 G-3a5әA0Pp| @ѓ`;Ҝ 2#a=Ғ~B C ҥ R`*ҤљނtPa7`p0iQ.f`d|d``
`ζL ӥpRp bqP
 xp S	 	
qQF#a`(L %4bLZ ~EQ࠵ 4-@B0a6P6rcl   a  	P$j b[6 qb
 P$=bX 
cO5.  'Ma0
A Bоc3 A Ut"{ ځY
0x"p	# 	$@%#Qb  
#p
 
%	"Ђ #Da6f0Prʀ 
$ 	% 	 	C	JCdw@`1|cc0c 5	?! 	8 ld>BPP<@ WWd! 3`p3 B7< ;8>dp` ~0]Zwl^l Q6=>6n6@s&t"#D+ f 5ڿZ  Ed

 Z Ӥcg 52cb
 d
d5e <5ek 
c
eq eeu%
 

9 Ը=3;1N Q1|b0i 2S$|ҏ05Yaxp``<f	P`q|  a0^0v  3 јn/AX `ix^ x8#?~ s6t?W2@ _&&MqSWI &FG_&E"&E#Wl_&]%&}&I2.2
t@' ڠ)p = ~=^~=~=~ &U*&$
$

AS0B$
	-	1$S2;t4&wt  pu`2VRԊ%@+F4t=@ eR ݸ  t` t:t ?FP܋ !?uq&>|ek ڊJ
R 2  &GF %G @GÜQW+&Q&D&TAα w!	ʑ  p&RW_j&&TAP
 XF2 CD9&Za
CD#`	 
a@[@_Z_Y`GQWP$0-󿤾p   r ts | :&?Q%a " G 	ĸ  2
WRU` aRFJyCZt 2f 	2PYs	QO&G<Y^O 74 7@Y쨿 t' EPJJ  B2BBXJ9~w脳A!U车,VBBq#w6)^!o]P9  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

?			   


6   rԐ 
*   **Q p   ?  ??Q r  ?   $$$(((---222888? ? ?/  /?? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   h1 h1 P,h   1   h
1 
h
1 
hP$
ĲX:N W/N^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`0c B2[a ajb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L \!|<An2N} ^!ߥ~>Am@M ]!}=A`P@ P}!p0A aPA Q!q1AbPB R!r}!/Acj)dC S!s"?AdU/D T!t#4Af?F V!v$6A@h@AH} BX!CxD8ArgJsG tW!uwv7AeVESA   0  PmR  @  ATI Technologies Inc. P24  01.00  @ @   ߠW   sVBE/FP t:.6rp p<r2.]WVSQR  f&=2u " WA_WȎ؋ʾ[Rp" uz &u&E_WPPPwU bp M_ǃ"``ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6R2^_@

.]EE
tE M]2B].l.DEEӀ~ZӰEE!@ }#  
E" $ ~7pqW~$@@@@ #  P"%~@ EeUeBS33[@N
tȈE}~=
 P1E*؋EMډE,].

-+E0pX1 
 f3O]__^[YZp0#RQUS$ w
 V< @t| dQLPY
 b 
NŀuZdĠT2D<u<t<u<uAA2PQ03 X23` ƻ
`	$XPDC@oDI0oD0o2 2pDo6tu[.- ̈́2O[]YZ)ø mVP$6|Pش!t8\t,	2^ƀ t &Ӓ @^;O-  	9s3"0WV>¶F^&Vf=>^_ÊFG< uûZ.^.>W : 
._@StwCCPS(.$] #y[XS*/[ vt{t
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.]0ap!`O2
̋AaPXq(
uË uW3&/_ADOD<oΰSuLA.؋6IS [';vȁ~P@JS,f[Dt@S&[%@عSQb.2f<ff3f` Y[f;s @+xryf@Ч
2uGf`PMRPfZf
ff3-fX<uʼS$f[fa==f "$[f%fP?ݍ@ذ
XZR>JZfX"[
uQR~?pZY!]"uRY)Zt^3"t	$B wl wf= ]QRW&9߲f&f$4 fgq_	uZ$& n  T8<\ VRf 3tZ^fO/f33sfffPfVX> V@cPQRfRfQY  $  ZYX!
9PfBffvWf<0B&qfIu" B&$@[\A\`tW!_f. { ;t ou2zX#%5$W$ ,3>QSu:3ɆtA
 [YQ
⿰$YqD??SQVWP# S &Is  R^Y[l7QRVW聿{	_^ZY^ڋ_  $[ǃ SPRa3MR+ Zt $$!
  t7SR #uZDQSÌС<P&= PH`UYS$TUVWVlXFYYZZ]^% ,\\ PÐPMID5$^   kأ$$$l]XR ZR
 q  ZÜW2 _Ü"oQ K.:3 f.;uw u h 
ÿ	rrs2[fX)D%)7 $4
 &`ffQQ2
QQQR@WP&۲ 0JfXR2Z[ff_fXZ - MTR]fqf_
V
4
X

H
틩RpfZf>`f_ZvfPRl g +1KK;rZ  S 
S  S@ [hSSSR	QpQ @DQYÜ2C @`)@h #    ` #  d H# B f 03.Dfa.T
.d"ĭ   $!'!Z./Rr$& -Y&
y"
	.Dt fXZ
+

<t%+%
D ^Ԡ0F`
DGQ e8t#su*cr Y$QP0ΫXr	8u
@Pu5,XP	r%0єrtr@jrXQfuQ2 Pv~qtQrSP?u$߻XPQrKru
 uKuXuW` _  QoS 

O ztGrNpr0t;Vt3r,Gt$ޠrr1PBNKu`~ u! rdr
psr1	}Y`ϲ#isRP*s2Z W _YQWs`¥Gr	zKuq_P Q Ys%Ӹ  $  m虠dOO<SurjQ[rbfa uIrE8w8rUIP2XPr+;ror6"0)?r @a,X u3ÀKu3S QPXY [<t<Ⱐ[<u < pǃ3苤PQWGGN衤p!_YvXu5搠u_WPD@_
t  ꜑
AÀita:u-a0Y	V u	@		u`|ðpPXq a <Zr,ZP2P [[S]pg6_;w2XXXYf`	 e|		ut6P%2}X0 y  t P DzxDX ut!P% Xt_ueP{ cdX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5 rPufaPt t
`	ttrѧ
u	ghtugQ Q;R`L @ @

0迗Xu
 	cWp   b Ю@Frcsst u~geefӪfPPQNwP}PQRԮt8
tk<Q
i&!i.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU g7 oo XGW 6O  	@sTv2ed. 
90  *+P;
2/SQ
t/+u'3At		tt?uC۰]4U $g wi ]a!S3  [W/B$J .gWp s  J$
2	佟@
ze`	Pw 	!
U 
̀{			
ȎT	 1P.
$@
JP@=^v	@=v$?
úZ[@5Sb?1/իIJS nQ$`$@fP,8 T 0  PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
  ~ ff N[VWQPS= Nu`r@Ўؑ3f<8ATIuI 4ك4 t4D8u*D.`
D.bp .7.8.>~5 [XY_^`PVm<u2@a8u^Xû..~.?t` up.G8J ZYWVQ翥m0omY^_ 82   F=P1t=T1t=`Tt=dTt* <w 
 <wf.
! p ßSU^]6~92ireb. t[RuAkQoPq X l'0u.a`w!=``akd
L$ ЬBh6][3۩} w0   PN  Xu22@t $C s t:тqTﲟW@pPFf $ A7Bu )$<t2
#r
p
w2\$ 8{R 
a<|10t$=!.$ #$y n?#賦=_ puoPv ̀$
'$w
,R
$[.
R?|>E`￸ 2HRU°  YIS$Jw'?1$! `ԭۨ@  RS{%pE'E"2[0$%i G`u Q#d ߪSD PQXЊ R tijmuk8l^ ]6] ^^_EFqGGHF,F"F`R/<`yakpLi#k7ckwQw3 P]]]pa^U]
G@HlG
A``d ne %@f !R!Rq7?@S A  "
 2 <%Ă  /  `@ $R@$0$
;'Ļ$ $1=Rt@g h벯#$}Vz"q#K$jR@$y&{pO$ Az P&{3xQW2wdF20o9 MЭ<  
mt}Q`o
BPvP..
tP XRN'FEE1#ihgih i	@`	X	>A6/Y[i#%Tp\[n@(yޔC
ѡ 0Hq 22Өu~hfg7`3g.E#030-*'	ihaAuDA B@7DDEUu"AZYZH[$"ÓRW$I<#t=<2t9<3t5	 豽B$	e,S_[\_f PfgX !0ѝ
$<<t#<t< <  < <
  Ok"F* y&E3usuu	OfF4Q 8т_._f.EfPF .GF4XH~ u lF6XHeuHff%  fF8fXf;@qPf	F8jd2..>ڋFF4 fKZ(P0[
CS7C[  Lu	 QLtR3ZF Yw.HF
GF[F
GP0FG$`@F	oFG0
G.M	̀

`3T
ňFF	`
G	F	P
F`GF	GFG
F3F'F2F@FB <!a?QRF;#t7<t3/##
<t<tYl2NAVBAF X!                                7 S (40f
   {fX[Q<R>] ĀuB u*@fEGtff.#Gf.GfۊubuS0I[`.O.t	q tIt䰔迡ٻPIt$<ȿ2YWq?D뾖P _@ n Ps d r     	 p   RR  { p 	   P  p 0  P  {p  P^p ^ ^>P^p  P "p  P	 @?KZPb 0fPWQ2ɋYSQ2Y[SQt93.OɃ.;vci@1 Z11Y[VSw|(f
S St/X~ QSfX PQ3@G YX fSfP f%f[ދõlf[j 
 ff
^_fX2QV2{.^>Su= v8ǰB} YRfPP%fX߲fX`fP:&
pfXr'! yQ
3osyQ2P$?zXVk"b.fQfR	O$BP;%P1$i%0[PXR;3Qf
npYp<fPufPV!.^2 >fXfZf}Y&Au@:5f$PJqfbYf
(<tAOMPWVRQ+Ë&G
ߠ3߹6 2a!$@fX&2&YZ" QR
FFB7 P$;f@?ZY&0 b"SQR޹.w
 I ÀtntQ  tt" PPvPQ@`tRp  Q`2Y|@t.Q
yYf.9VZYSQVN %0<`uY It	oY.XފP d$o
 Yյ^ R ef± f.;Twvq vcp  0f@ wjvef+бRvMv? ܐ v2 v%}vs u	r	wUNfV.Lf^pqf〳f.fff;rf@frx@f N^f;rLfPL.Of;wff+f'>sv
oACX
	؋N]f
tt= r = rA.DP.Ã.([Fӡr )À tAջ$`p0T0۲V$T$a PBXWS$W{t`ZXypqW۲P%&O@t  $&W7u t@B @`ېHZX	ZX RWڿ˃tܲ _a @`0Sf4[ \Dw34H 				      
 +Ń2Uڲ[Y."D
$.
tc΃s/] PC@p K2@b9/@㲰Pt0 
 ]ٲ[&߈Eq P00[OX0~&DVBg 
 &^EXu$^ Ftf
^~ofNnP;w@( ڨ[Xu;}@fЇٸP	  FF  	rpuED
T%F zFqv聵	FȊă4Y1n%{
8-F%XQ0PFf=$-, )@f
 ZYfË؀~Àu S׸
tQ~dA>
Riׁ˸ HZ3 }[04ؑ O," "q 
QRc3d YSR$.:Z[   (d
$a˼tp  $$@!
u{&4p5 *; u.>tӲ.:':3Ý W߃ i Y[ WQRVSqPTֲ+$װ 2@ Wfu5DQвXfֲ|P@E t	@2|X `Ȓ `O0wjor[= 
RI_[^ZY_B<t:b0Wws2ftu% t`KPCU	   &֑   ul_0
 0
0
 Vf^fPB ,0Ց@atf;ufY$Q_p`rƾ'#9ËËߎ^ÂQCBr |iV@n"ԾL u\ ZX^.tWqӿID_BpDеapVSĊ .;u[^?r1A	׎Ӿ } ^( 
 : 3!KfBCCУ    Q`wҲRX{YҲ1S@Өu[SiҲk,XA	&  wQ %Q$Ӌ@YT`("ӂҨ
 pԓ3 Xh l   Bp   & @*@LN  QRSѲUP ػ
P$Bһd
 ,һ 0 ȕҲXP%
XX XXUae[`Q(P ?>t@w t0	UP@0=ѱPW0		UB?XЯofXZX20	R__  p s  
.'B(HW̐ސ! g呋F 6NǍLȍ.֋F2kKOWgQ X ^ o
uO) $߻ 
趛PZuCLt  NVuN8Lt

Y$

_`k(It	
t، yόɌΌϑn@ZXt?3.  馌KLt܊2[Kt 
  {3^@?NWP  7tβ&$
N&2ށJ  1#p#! @r 
Qp_}P@XY^8鵋I	%T$ȰU$ uɟ0ɑnpuЏ_`T Ͽ_Ju  U3 4N"B#@I;'f3.O>f.O% FͲ$f3
tf?f%Pʊ %fĊ~@,.O>uu r̡
0 %%w0kx
f0 Ԙpgxu0&&KL
	<=Ӗ(1
'0
(KK	P.C<t8tXp@'X %Vj0Axْ p2!:t`0O%$@ 1
c}ˀ5$@~*鄉ˑ$oƐؐ Y˲"`AAp2ˀu$rp?2*聾$pIuR!= Nt(W	ߊ(8p " 2	Ј%Ɉ $q魈7uq/
b	v+	n
؀緀
NQZX( 0eR˻D ˀO[X@
8ttuoSP <X[vaS	m u[S
t`@ WJPBQD @A [
qqMðS 3ɸ.:T P2G=4̸ mP 5@ʻx v̿wA$bʡ$a4?+*%PzʻX7˰=%ߵfQ
-fYfPfQ
 QspfYw
  Q@A}$tqq ɻ f%gB9#
s%ɸ YKȊ  SP@b09
Gw
ø x pM h縍Z Tu L D- <m^4縁A,$l~q\  @渔c渒 fȸM渍詏u0
 p-Qm _ AqyA'$
_߸  Q
 r
IqA([脁ǳ.&
f}Q  p@   #帟 ҽQp"~ ?ItRZ8uR
ZCRdP X XZC@yN$f!8UprL. f.&#ؖ & By!R23Ұ
)u 
Z`..^ un> tgp b2P>bP22AQJ2=QRPr@q 32ZYYy2 XaZYYR*8}2.]Zà؋ m 2Ku2W S
uSj[+с2Ê2+U**&RM āZHuB$ JÜB J.]r ce 〃   PQC3BBaaPQ YXaYeԨuXÿ}N
+.J
u8{~` ]$0<0t ^:Jt. ` S +*21+uX  up*tX⑰ p/. P"㨀t0׊4"
ވÊ$"ÿ( @  !$%D
m݁  +

,QVW++  o  e_^"YԊǊU_ S8v2QY2P >It(P
ïRS"82 PL[[ZRРJ2ZË.O O 03<?& t
uV E,ņ!&Jd aZ	-[a2RqZ1L0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6w% B B2+Q+++YZ0"Ȱ+Ջ+Nu`$` t 鿗 Q"t|Ñp8~@td\8tX΀|0I~D* 
8t8`t2
8~
 ~߀Ȁ}RtɊ*Ŵ
RQVW3ۋs@ P/2 1t~@   _^Y@ ZC\+QRV`T3G  ZYËxs& 	rW Ǣ	 P
@  fff Ҋ baS?[F_@fWfVfRfPWbPpfV +Ɗ2BAXZf^?f_SRP1 ݋`VfZ2f04[迻u.N i wy拄 r銄f&Iwp$oi|t;@[ _v[`OovIG[bR:Z'`R!eh@A3hy
twFs
PdP+>PEbF+Zh鍃
tĿ郃R
#
+ [rnAU~6|m &~F) +Xu &F E&   P Qa+>2u	&}uƀtGVW_^t!#ut
>|  2g1
a|u\xtPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4 2
FfKu[3,~!#|AϊompBugG`PF٠ eXЅ$6| 62 'tmU؊Pu)#ëp &N>Xz !1{   PO 齀Àt!Ϭ&0@ b?`$ &PO s8r2Êв2},Ћ9!=1HJN@PRXWQP͵sêuXY_bQ(IY+qGturG _vqGؠov  _u　PUP[,^@.X`)V`4|4Fo umXPRJWQQW@3_G8v
 VzQGY_PĻ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_Ұive0XRWQRQWP8tXPY5$~FX_YFZ Y_Z Ï		a					T			ɲ		?>ctqP}}>
u&fP 3 f \f$߀t  
@n}h}SP㿁
3 踧t&   &]X@9	UĴߧP qG@Ā`ey
L'|CkP|A[]+A%  %%&|&1Ē*(DrX&߈i|t
UnI	-?|̢-2"[}~|yfr{>b2PI<
vL~w5`GrǪA8sZiat u2<
u:6u Ɖl{<ub{<u
tۿ22+at++&eP>Ҫ3pe{pбzz.u~}&2p
O>3Ɋ7ʰ'ﲿuF zzcR`R8buavz~1T`NVZzb$
Ip(!Q̊.t.;t$.
DYܡ^Dz#+3*2d!d"<PR3=ZXt
A>t
y>u<s .Ӫ-Bw! O #	J@ ZwtÆ =@&jy/}+>&}s! 32 =밀w0$&e߀ te ò 3NsQ2ĜB0:JG `;/^ xQ&5&m&M CYx
u	$aP0ߢcu4Mx0P !v= &5&݈M xN  	x}4 ޠ P^뽒a ,AWT wtXS9 @Y.P;PY0 d2|XR~ ZSںYBՀЀ [Z SBB  s Ȋ`PSfQf  (t^$t"$2t t=fIuvt%utfY[X$ .<t
4vaav<wPSPRRR@n@	e@}P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[ߌu Wt@ > B Fu.| ~ uȎ2.쮉.u 
*9 Խ-Ƚ60:
u00w5wpP&p u͎..F.aQFF 6u6-1566Sp$[x&G&g3t!<}虽
<}0
 <t
<̀
&Gpu2@| ֋P$`"3ҹ <uȰ P' Xẁ_
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tG8Pmu&2. aѬtW$
J	 ȋ@/utѿHa& L2ܾ6t
5`t<tc F0UJ>=&]&M&U&E
Pp>X}21PSQR.^t	00ZH<|CrSH!5[VQS&F E<
"@<
t2_Bdpp\p' t&^ E	qras -Pһ _q	t2但SU@,][ X[YZ u߉:Хuq`Iq~Am^F`q<u	CnPq%.:r2.׋] Ià$0<0tu` tq
2.;tq `i8~û 3no tPmU#_)ߺVqwpt# g P 2       ?     _@  Rߩ*$Z.$SQISQuY[f.
uY0t#Xu	f.>I Ef0(`f.ߋJŀt
uPa*R j
PRt|Zpr .@i(-2.OA.WB-tW+A_t;rÀtR p D
uB.&Ɇȸ 3  u,A	t0t𼀭 ]}
PGItu?M2@|
uJ J @1

@ éP@[ZPQVWS.>Nt .TTux .	ANP Ў3f<8ATIu? 7;2QRS$<uP`F|<2[ZYY.ɰ.Ɂ@n[_^Y@Hƴ 
XÜf`PSZYstytrS Ө)ݨ!f-[PtwF!fq21_[
	MGy	f߹  6s  fa-fP22ɻ| fPf"꧟0 f h ByaڨרԱ2ɐ $
΁X蒑 U  	fX7S.= t.;u.;]t3Х5W4uR hWί.eD <t<<t8<t4<t0<t< u0P`S4=@uuX5
X
=u
n_:@E=@ Xx _^}  u   Ѐ  @jPmm @{wj X--    r
V 

u`ӦP=ua	dFz$Υ|$!H^$+`<Τ  ;9$u p 聥Dp $ 0_fWDW PW .? t.9u.9Wu.G2tpU22T_Sb.Ɋ
܀qi:np[;D;;ûr q#Wt\3PRᣲw$Zp7R% FWfGb  ff0fR t3t+t#@t.tpt>tO%ffȐ7%flaf$<t$f- < tf+ f
 0f2) ffffZfYf[Vp>߰2D2f3.Df3ɋ% ffp.	 L  
P!qffpf  !Xf_f;t9`fX!"z譤" 
n菿茤#\@pSb ?J Am
8/&Q^'C `^(@pDEFG.F*.~/ @_ط tttt	tr}x@%sjaCX SOF 0=p1AfX^    q  + pE  C @CaRlu0u	 .F3H  H@"  wfXf	 }{^l.~0ǃ
w
p0q  	ap)tfP10.4"0   8!mfﰿpfPRQQluP矸3ٰ HːXP  ︐WC z	$,?LPp{F Tp   X`z
\Q `B#fQkuߪ _u8 it}qkt= 0ߊ (p ppC
uu
n߹XTntY]IUDpEPqM<~	<%  Ytr 茠 YZRoSfPWy1qgd.E_fX[ZN_4K
@>bF︳<0 /F;  (;; >p/HN 40  )>%88 A	I? CJfPVQz<t%u<t0%\
 $W^[zB"EA!HL A"`-YN
} Zf
  9F-fPaƠ1pD f.2ts3 4ff
@ S xf% 1MtAN   [:1__ZY`^BRVW,Vh 耝3Pg.;s& j?>.\e?ËQ O^ oL.L.2
0>G_^UC@SD0[@ Jۃ(
c I0u踜3HS#t֜, Qɜ tW@/:0u蜯XjT.PPS2 Q
~RPןJXG bfW+&Gߚ ff&đ}t詜f.#xf߃ }Ps3۹!fCX_f" 	WfVwsf&.
f蔿ew蜛.Xf^p$[H  $,48<DLPTX\`dhlptx|  ;@>Q  _`//  ? c$
k*6
mc8*1 C D
  
 =! !- @^#
l"  = @ rI  
I @ .&y$`,>$!EAs/BJ @  ?-vK I'm$ j8!ha	̈́&@R c۶(, - Y- =!P0\ y5%#~ +.C[/H8C O @Kd"#CF( N%_ ؏'	.# wEm9 Ƣ( [GqF+ ϡ /#!-+vk+ [P} z A_Bmc	o	b	y`	 g~ B+ 1@ : IR?# (O6 i  nb8(+ h"6 w-(, PTA PT PaP=U! lA?-'A.P]hq1,{.a5c
5^O1] a`0U 1&c cA$hG!A_	6eavWPp4V10  $TV0N  @PWVt  Sm[w^
@2؎|@< u+~_@PVf >=^[a   :{ ;?f=0%?f=0 #?؃  ?=	wIu'= Nvu f@SC0ы+[<wqȎ؋t@@봨qĀ@*0<뎨1N녨t`{2q?_fY   藟_@HD @x@ PSR͒ $P@
XtuZRP$蜒"
X萒$D $7o蓀>1pg|ҊPX'v  /ra: 
tRP$rQ
0t z	kpXZЈWPX2 t3ɿe;t@t_P33 t=@$@Њ$0Ћʊ$ P$2Ⱦ$=u$	$&>  m= = _  E贾C跠)蘀``
@|>@ Pfy=r r<߃S Q
<<$
ăQu<Xü4 Q *@3d @A &06SL 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N (('ȿ @$
>QW]J_YuEa-\t觏 `1/v$ÀBܑ~0($Qt$ސlP=@r	STd
諐$PtpQS鏱55GQC_>2aea߻$-K0:
;* u<#$yn$Q-@ُPA/$ɏҰ
" @@vP.?@ZbBA#p"4: ΁D$@c% % t
tQK9nL-`TtF2;rWF`FV_x m` Z bð9 =9ðNywiqOb96qYqRB	;p?/
%9bqp	q
p1 /|p+$~0 oWx  !ZPЍhTǍo X豍sc衍\ߍHHxp$ _[UQmF;s Ir8 V RFNP'uڃ?^
[F 8[2FF
V|Fً"~?P7XӀ
QYoINpY ^HF7FVЉVWz153]Vi7@dF F^9F$v FfH~F fo8f7j2Fp4ۨ16:F/	Fz 0
6AF q
FPQR؋$M 
Ⱥ$?
ZYA5fS@5xV бoEUۘ 'SAMEEfP'iЀofX
@T-'`c+_*	E#
4 #8ۊI Q 9 ?f>ĜcB$J&e 
_
BA
  0f	QS ãIM 8%= vޠ$B , 7@\ډI$蝉q7q%  084MVs @@f3 P3ҹ ȋIXA;r$	{uX;v;tcKoXPQ N@

LZYX  tPfCSj~IXAfQffffY;f 	&\<`   fBpG[f^O}wrN_[P #l ONqH9$t. .>.
px E
d3.ñ .<  .3f<8ATIu 2؃? u2, PV"׬P	8uį^@T@NJ.ǯۗM؋7tJ󤻖.& t._&@.?tǐ߉?.E8t ECCйVWfS сpP0(ڋ表s.D.|Cv.D W.}&.E_.]1f ..M06Xf[_^	f9ȿ
R00
̻j$
辆.E6迼fp$
P$@K$.ev5蘆Wkǀ=
	_0.]9t"=f&	=%f	}&f1	r )3SJ ҆<fXr
fff[fY~pe$\ 8!@`0=%
Ĳ0=2..a%{u

݅@* 
Ą)  d,%u)覄-5.[&m0f p"4,@
ȸxi3Ұ=8r  q2wPsA	uɊZYf[
 .  0u  t 
|loQ@麄!O襲 NP滼
z% m
  _u	m!< R蠃ZB'aryl14[% Z$ZW 8.E#_ @_VQqW te 肄$fؐ%;E.uDff%   10.:E0u12   1u"豿f;t
 ŀ~ _lΊY^P	E= /t= _aa9f=  _Y RWϰ1AX
s P;!0$}p }b-c_Ȱ!{cmQfPRQRR$@{$4
17C
藂Z~C+u 0"qEm$i9L404hӂqWH߂.m I͂#m@0M,t詃<_4@$㓰#,NSޑ#}4 t&Cc[/d%taEH$螁+5͂拁c,%@{ueQLuIa)p-I)rF"F !ÞuF-c+È񘂁F&2$[$
QūbA\`1e/qJDc9upF) qab$
F)赀T 艁P@܀fF4PǠ 81РpF7t1  F; qX蚀FB#@0퀀{F'ЊF(誀FO2f c3 P^w'2ÜY[!8u芤t``C3ۃ{ Ϧ ĺ f fb  `J$
ffe`
ff 
fҦJ$A
f	f%
f̀ff.CRcQWUD 2F E]!u5uEu	fF4 fF8 _._&FP.ۋG4X0HP6XHfPVuO fF8fXf;0Pf	  2@l`.>ڋFF_Y3ހ
"o"
W@.Et.;
u
.;Uuÿ3_1蛊6`u > dItcS2p5wې
@k:X_7.p
PIо P
пF"F 2N(̀ N( FF'G'׊N'`+`$fF ~f`f1N)Fp
F$`2.O$F&Fqh0+@%
f_fPj?F-Fa
.oN3P.G$ 
Xnn
Ff	f	cb2rc `nrU+ '/T
$F1F N& n1f12,F,f..7g` `#F @ G	 $^ 
F0` Fb
! B`f	n`Kf  G02ndq"0

sn/
 2f/f	 
 n !`N2AVB02=`P F tZt]U1CF:B6
C_A@0̝AB2WAsD	F2_SI@I6J2J2A:D7DDaph a2 8 < C F H K L U Z d x     ( !=ySt$^~螖 zFt -
F u	F=!(^~.?Ff.fhsp0x yoz Nn.5 f0
̢ ஠z[Puo	{v {wEf^
~fV`YVF$q}=	0
|M#f`|𙦂F6p 2[f|y|9|m5|	y1yXf^߃fٸ4^~/}8w膵^~ ^kePFPx=$U3E`, `@p)t
Z  }w"@ؿD	DfD1 EeЊ]}qt^TILDu'u蟉D*aw++І؊}Ё@@%??@Dd2CEeCÉDE	pb*DEe}HDL0+S2]Ë؃w$eĈD\\[ˊE
b	q|2ȉL qB1cD3D<v|$<@ $PX;}Pw`d;DX;D!#!Ë!ЋȉD)
'EPj2D(D*&vu @D+L-wD D0߉D.E94S\1\/?ЉT2?03 ]`(Ht@P D;XD5 ƀ@^@S @X ^P P @ ?XP !  qx@    Samsung LTN150P1-L02  1  
 A  H }  !bRl L  "0Tn0F"d`  U Vf3ɹ @{^
uyЎf<udf|p uZft# =	wIu 3CtĽ ֨ <2QĀ ]`UG1	HH	 I2Hq*)PeE;$up E;X e9= uPWAA_= vU9жpN)3= t$9w 9EwAE b ׋A@@} uQ7@UEDEDSQWV^_Y[| u {? =@.|& t.|&ù ZVYDNDMm xMm 2b]a$@VWQVS 2 Ў3 8ATIt[ 7[tFA5	
&G^±
p   ."$ u;= uDu

$ %ڹ  _^VQfSp	
Pff;u.QPnߊY^4_t*`vq$pq%pQ3 
0Ysԃ}4 _tbq4qp!.q$3ۊS 0Ўr0Ŏq3
贎1q
&q
[ÁppcE3_f_#ȻMp@GpPE=p`%n'b!ap#fPVWSu@׍$0Í*輲P?,讍0A*D0!.D1
.}4u'+`  Ԓ
 2U$._A1A6  ݰsߵ 蕍B}&3E.e0@3@q[_^fXSpl [À
t+R>wupÀM24X OEM INFO1W                                                                                                        x 20  1COD@ P h$h߻ hS@.9g[.A-gg~$ih$g! hfD`1INI??SQP2.N= NXu2˃	w,.'
t o#ܠg Шu_.&`P                                                                                                                                   K 8g-o             1600x1200  @  w
 Bہ}!N! _]_Z _\<!
E  ಑W0u A_    C L <a0 A4 0   p
@0S D HC` :0  @᱁ i d OD  P   P`a0X 
|1  X&J@ 0@A4= x@ .  qE+ f`e !UU  W &B/	m۶z %"""}M[
u`ր
$0 "2
O  'H%A&T&//D)QSB B1	2Z @H3dM Qڤ@?`J
 HT@QAD0& p)w M0LL 0a Q)	VAq#
  5}?5   r!O- B<
!,$@l% 3P q2N  `  7 P P` }  LQt` `@<
H <@C- 43P4Q ʡ BBpmA -5?7p  ;u_uR9_0 # $ oC PJB   B rB    | UR %TaB1 %GQ&_2*  %=RB 3 e	   a?Q??q@EA(H?wH?a`6YYYYY YYYYYYYY YYYYY0
YYYYYYYYPY YYYYY@`YYY2 2 YYYYYYYYYY+YYY. YYYYYYYYxYYY2 2U22Us2U2YY8YYYeQY Y!3Y3YYYY YYYYY0 YYYYYYYY YYYYYYYY/YYYYYUC% YYY YCYYYdbYYYY"Y /YYYYYYY`//YYYY YYYYYYYYY  d//% 3 /YYY cQ&YYYYYYYYYYYY/YYYY YYYYYYYY YYYYYYYY Y,Y& / YY/YY/Y YYYYYYYY YYYY/YYYYYYYYYY<,UBBUqX%YTB0RYA YY/YYY 3Y 3YY//YYY./YYYY YYYYYYYY YYYYYYYY Y/Y//YY/ /Y/YYYYY YYYYYYYY Y/YYY/YY YYY////]{TYYY/ YY/YY/YYXY/Y8YT1
S*     ? c$
k*6
mc8*1O/
 
 ! !R]< @^#
_" b	Q:  X    
I =.G@&y$ـ`,>$>!EAe/BJ @  -Xb	KXI'mA$ j8!]ha	̈́&@R ~c V', - Y- =@W ~P y5P%8^_#~07+.C[H8C`	O @%d"#CF( N% ؏'	Pz# wE9@ Ƣ( [GЃF+  /# } -+vk+ [P z P%Bmc	o	b	y`	pB+ 1@ : IR# (O6 i a8(+ yh"6 -(, !%PTၣ" PT PaPUÄ! A?-'A.P]h=1,.'a5c
51-^O1]k A+`0U 1&ccA$hA3_	d6eaWWPp4V10SX1
w*
OS"|S1CSt !@=" "0"
TSASpѱA
S Ab6ASAN$/)SSsBF }`A   ZtS@\ZS<S# 	/ A&Srb	U@4=@
6@`]bM ZS= oڛgJ	=& GX4 a	SS`s яf:`HVSASA&/-S'/
S~  s`oM s'X+SqSmb"HW.V4@yˀfLDSV~%jZz% Q6 So-(b{6']r  J5 !S<S.- X+fc._!o# ]3V.hhh	``	{7#V
] )Ve` ) AySЀNSRS SVSWSW^SSSAS aC.S2Gw.P1PQ/Sp.p!cqA.1RjBb2ycox6SCnc"`QV11WiPDSSoSd10?
u). $OjQ%S# T/P$2V#sSrSZ'΀GSȄ!o	~A`3 ya9 @`sqS c).ΆK@S
o	V/dÂ!v/# bbAy9noWcPAbb	O %kbAobMuaJM   k  夏+. 񣅧,
內`6tUᩒuZllŮYSS$<                                      u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
QhE@ Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &<&E  ظ@ P ^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PAƽ.TAA_fXOAu.UA.TA讽_f.PApqKKKJ	JCK9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH BhT[uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jr赳r TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  h>s* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x      d ưʴD` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7hؚ@ t-u$ظPo hh Lr 	uI[XˠC'P{e
.> t
P ZXPw Xr$$
0
w5 r?x   hP Γ	ruX0rPhBfP f"wC 
 f.|!VQ6'|6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  sϿ ˜0   # Zq	t a*u'迚 4,4 u.>.} u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.߃>0A6f.R6D.VffX QZ f / 
uf.R>r>^)n1  p ߁Z P3~r# Uv  z Ѐ~!f%#6 .,.>>6ˍ6
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP
.QX`0fZt
0T <f%?'f
  TPV!	.Q~

.
..GPWS ^) 0 MSZ.&ZπQ<tQ .G+u
@_!QJ+u)``KX!a @aI	`b  .S	!@%"
?f8.6V.6If#RAKf6Of3ffSkAor3$tA^`.u	DVQ
6ˇd dTt	6݇U  } 4
tY).V0#g&;B*R'Z=u EVW>ˆ菭b& _^FVW~ +䡍>Pdr6>]_^HPx_š pfLfVfWw>ߍ64 /t 3ҋ f1@
G` 
t O
twQ	= ?  68) <R se>uf_f RfYpo/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|ݟuYXP E {  F>@
>W  u
lr3- w|HroQO
8rK<?rDuqr)W.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVߋր? t  %u
3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
ê<fw<ar,W<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G2e-YE.p"PG>q޶BHr
x6ta >|.s<u=0> <u  <u0Pvr).a>PN{ÀssDQ w?QB>@
 Q0s?^P2>BoNYѓJހJg&IҧM 9}rqWGJ@6TMr,	fNfOfAg&@ ?S2fffXPtw aBA@i f.;iw- AZ r%&Q0PPY tfGɰʚ
>A_ r,f
 2mWT)bd@ r@f؀ffFgfd# 
 .႐S3a `t
~܃ffVp xv"  u $P.ߠ$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@f]anQn90P:P;ق651.=Q[ {fDJR_ RQ T
T
{
 Z Z\$
fX Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ~ffC*** Please restart the system manually.
 .<t$
  
$!~$$0AD?O2撰撍6ŢҘҘӯPE@> Q1Q ػf?tuPRP ү ntJfp˂a T WFOP}tO@wX >vTY|YfPQUGPF >JMu
,~2 6  POX]0qUf ]Qǃ0ŀ@Gbؾff&f&  G>̀ fG`GGaQ6VfWf>҈!f!Q =С ffD4D$fOЬV 6҈fP ʡ  ஀h}$Ph X[õ ޥߦ3@$<sA|Yr.ˠUrO ` SA (tD_orq XPנ"Q!f/0ѣ!EnS  gf /u
> up[PȰ&  cB|`&Xq!og= Bxx<w ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+ s q}6ppt+Ȓp+p
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;0t
|u. >
f3EG.Љ.fEfGЈE
G
.f$ r-/te   @ -@.Ѐ tP=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCsq?s6 &- + aGp }p	, 5' #  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6
 `F
Æ  fPf$FfX    E	@ k fQffD$ us+ؠ% si}
uFD4/ E}t#uS uN-fD~'  620( iQu K
߀u#*
f	rg
1g
 _u,	 1q/϶, fXfp5 Qߐsw`psY+5 < 7 6bga5rq_~ie@ aȋa8s"s1fE-p[!`D1S
چ	侥!f+B>sQ@"*#%>d{D@@@_RS`rfe  #bV+^	sF?N+R!%
!p	D
MRu
HaI I7<&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$ ,r
.`.qFbb$)Z7+P1wPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ ttt%EEw)|CP{u
s
>c`uF@F2	E TEDDd%=upQb5AIaR-df$0	К(=(t@q	
v+Ұ=uruQ2$GrStY0< 	("rLUY!
R"pY+C J g'S ÈZ1"b#SN1NsX`_|0^ eVfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPʠB6X
TA tWA  @親tAD   + *2+*4+*8o+f5c|- sM?ȁy@ߋu@føtsPørcwp d
q wt ?P~a slc#fEst~ a1`6`%["	
Kѧ]&rbpBb
Fÿbx+si ` d
` p p P" }߃߉ߏߕߘߛߞ uAcA s@E
WV6g4Fg^_rg t 	p!	
  	M
fw_ord db q tbyte %*/" Q ptry  WV.t"Ü6@:s6J,6K&ps#!0RO_Οf^f˕ fXPBXP $0<9~Fab !Ò  s봰+   1$  se+s-!sf    n `@  c w     e\ d  |(    $  ' ( ,ܰ / 0 4 $7 $8 < 4? 		 @ 
/ H  P0dX ` Wa  b  f@ c & h  i +` l 0!m 5 n 9eo ?p Drq G r Kes Nt Ru Uuv Y%w ]x `y c5z g{ j| nE} q~ u	 ylS
8&&#8 ` mf 6 (0 8  |UA     !k  	    10'8 0 % 2  , '  ߚQ+ e #,   u )  k9װ   U3    4   u  ص e 
 5 x~\
8 q/  f  ( 8c  /rð T s  ] 8؃1 /9 %˰ t/ #rFͲ b8 '5 ,$ 1 ,
,
 
b


r
QL 7e? ;  ?s*Fw DD? K w Qe V  [Z ^  (I#  b%  )`$ B`  f k qu v% z8x7r ~   f(+m08su0ZU  !w ! e"w # 0^D8 ۉc b87(be0٣@9 s  (,	 ;Ԓu tn ,   ; e q/ ' 	 % `d$ T  e  ҕ E sj	 ݵ w e @ 2A 8 B ?eC ED LE RuF Y%G `H fI l5J sK yL EM N 	O T
8 ށ8(ݶ 0f8Te e   y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 u$w1 %%2 %0 ̄&8 w9   e  	  e   u $% * / 55 : @ FC      Urڲ ! $e  ȥ5 K9 O 8wSuX% ]v0b5 gv k&p u zv& ̓(ɧЍ󽱻  fmv&빆쿶6͖mFަ	V
f
 6f&v.&5v:?uwGL RfX^	eU
Gr|lBp udz y8 ~sf( 0f8ݚР ़`誴 7 50 8۾(l8w8u  ƶ (f08t
ܶ ؅s'8 $ $`}$80 $ 0&ڻ  e$
 0 008  `o8 ˶  5!  MUadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl imuP nsbQ  out a  jo Kjn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff sa lQ 0ss stos lod cP
bbb b rol@ r rc cr shl4@  a@et`^ente"f`tA o iave`md xla@oop q c fxzQ jlockpnea e hltPc t ne doiv iQ cltc i
i d@d"xzx lf0gpsPl@`hrd b{sf@ r bt0 sp  c i x!seP 0 P b zbb p"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxf7ld1Q l2q me1piBg2nr z f2xmyl2x fptan` as re>xtrac.s0
f`/ p.sqrs01%/frndq f &+q
ucompvPendis0	clein+fQTf /wesc
env
cst   fre0Q /ar(AfbibC

;  ?	A	 r=fi2a ( wbinv%w	a ::ob @? 6 s zs 0@F@:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm ud2 wrxO .  f  yz` {|F}{.s߈x{33	t.dG
U.ޕ
EaF,(-)*d.V)PS ޤ[XFe{$U<v{$tU	&䝀$!!w'E t$$$I4芥"$Q(',}fU$-

迾E%$0c<5r1<" t3"$v74&)6+t06-U0{E#3$6Q9uF;m>{'A0Dt+=F&_<JF8L?Nt!ޕ@PE,S{<$VuBXU&[UD]` 20cf^1i*l
nޕ+q#*vu
UJxL%{E}G/轆'0#dPPOOQoIߑϐ$TT<w(YU_WeC}C'ICߪ<kU&@'tN^86tH`&@  6 f3 t3Vv^

ѷSQW.8
F  1 [Fn6Ff.0.>0QHY.&f.>R[  t8svpJ $GG _Y[PQ.> t7xFYX78eF PNS?r [!Hz %NYa F߸J2 uQFoKEMe	$ <t<t<uAE* om"ME' ;蜡  XEfPQfRf33JFfZYfXSt[OABC`mDP ҀQPہR҂S҃ABC DpPOP R S c?[ QSWP..X. u<u	L <r<w,@.`<  .>
  <  <;u.À
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&R<[pOp?uu18xf;t'u_G2p~ .0
_	   hH>@ ῀ h6؎ЍYӋh3     R  O O           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                             8o%  @8sUv V ufu`vQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf{;Pf;fZWf!r@mrf+Br
c`|s
wua

<1GM	jrrBanP蜗XPQqr Pp$SOs[OBMIE{/{J8O 0p`XE)t fat/+f %#fSfQ< t0Q2" Z(aҥUӫt?$7 3#tc֦00
ð-@^WV@ ~WB Q Y_W
t^9l5st6]V! <5u G	F^B^= t﨔s.
<5 = 
u>9r  Xf[2P
X^#WfV?f桕0t
P E3r&< u P_ B S߳ f^cô PXs7 #
# $$¥i
$P.)
u $ C'ð) 1U
 ? 2$
Ǌ4D O $ $
utpS  Y uðQ3)3zð&pFa
!tt	*tEP6Q/S&"
ǆ['~ <t<!t
<P	_<*^Rp`@ ZQRsu	 2
 Z3) ӻVP֎ލvS<û	 [rqkX2A^a
 ð!R7Ր $VfW7 u؃ t迦r
Dp<A) ,@i2@e^PD3K|
u|	 t0  ߬$<<q<
Av^À}" }} ؊% ȑ؋ *0Uu Xð2HQVWP 
L0?X_^YaQsKpUP2b趿= 2LB2`|ʁChY
P'/#f@15Q_OðWB12	R|@1 (S)ðT)ժ Y"5@Z5. Qb	U27
.PfUfQܐ`fVaPrMfXf}Q gf@ N V F`(gf ff"f0f@MufY(A#f]Ë< 3+fQSfVffLfTfDp1
Pf^[ofYr!X	AXf OÁLp 0O,R
WfPOt3  fRfZOnP_f] ^YPfWO tOtwQDUP/XY fi@P_ YXt
 t$tI  v| niO@X(RfVt `9(7VSQWfw#t r@?d$r	`@* _Y[f^/QWV<wy^_YSQV3۬
Ê^Y[S { e    rV1fffa.6H.fff;w	rf;w@0S.- "  u f%3/aBRNy@u$ Ċ Ċذ15y0.y= <r <3@f
f?fʝpff   f-   fPSQRW >E3&G;r_ZY[Xc%aTU   AS = t	tpQ fp  f@PPu$@f`U4Z?4f4f pg&>tq r 	r
  u f_@ǀ gf&^$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	wf#F	Pfa
`VvR	t#1
t.
wt9twtt&u&U2
~	t
t11tFt`
t~g&`
g&-@
p
 
u
g& 	TA1P a3Rfn\&^q\QUUt\߁ rD.W!]o!!3"" #C#q##)r.f% @ UCESusffr 3 11f!u%f#  	Lr`t s` u `a萉ff#ffߴ fp <rffapQ<t2f3Cr6
o+; gB*t r(P`t uDKYf@ʈf驡74x r?t
]#rhJR/8-t('r!f1utƀĆ
Jʇ?to:R!4!6m?#Ɔcckq8t , tu
@u$2H)@t'@u'-*tp(t
 /!-  t>bs fAu2Brr`33q 
t@ g t}SxkSuri/p/B/RZ/GrGU/Z3t!@Cr$
 `Hr,3r$`c pBrZrqVQ@0fF3YPSqqr  ynq$qq2q蹿qq@{q$
qq  a~ X OS0ֳ4fXೂೊد @s[!V~W   _ W
t<5t^ur˴ @[r}aQRV3@f FoKt
 J8u^ `ɿ迄fbz- uޑE`Ў`D@tܠ@РV`S[PS3 [
`9DXa@RsɄ3ɺhDrALJD345  .DfPAMS찐{VW 10 u
ׄ 
  t 	˻ʆ Crr ɍvuߜ (0& O 
Ȁ0&Oˁ=FUWn)_]v
 ` j_^ސ  1 Ip  MB  0$)- D ,&=} @
-&a GvPuN-v ^-p cu#' b.!F.&:` 
;u}b.f3ɐIHuD//&( ~~GF< u  u2D2@ bsN~@So[=Nu;ut

q&B jf|@͐K h y]1f8hðh`  f  躺 H  $p`| f@zl f
k艐ā [5V0@% ;tff@ f@Ћ_fYRfx Bp`,5Z`PXfﳳd``d 0?P>~n
f<?~fԡPSef%E0

P`DpB_:B3EA19!m`fft`y" QBY f΀h@WfBOf`f3f tf ЊOu_ ÿWyryAtp@12gz@c@?rQ@L G B = 8 3 . ) $     1P_Q&GYÀ';Aǹðdpv--,@ 5-q - -0 -P ,. 2.a .& @ . .	 / @ ' 8/Q @ /( 0 @ $0 9@ N c0
 p00@ 0 1   @ 	=2Hewlett-Packard 68DTA Ver. F.06 04/19/20056  16I %]  Z  l ~rq oKBC
sion XX.XX
 
  _ 	o~A# d @  Ap!~ U10 Intel(R)   9rnal L1 Cachea bi2e	
 p6PC CARD-Slot M
 `N	 www.hp.com  ;
 `   
  0}q8 
>
   DIMM #q18
2 4
B0 	ANqaSST49LF008A  ,
Qc ?T@G~.p_qHP/
\`g U 62"3$0M2No bat y1"5_d=$W2 _T*u	 Ey
yjt)Ӏut&  5߀& A)u&u#
u! À8W@ AU RtY pvMuG	0bum< u3uOQtru1 ta0> S:u@8*6Rw:EFu E0 } jQtTt̀t߀wEtH71F )t%> t:& tSuE蓥uy3é    pE׀>I q u	PXuP3 tݮXYtS%yE ut0#)	&2!q@=E ]*x3;r.Dv+W+Xuw432#*u!.ð-*1!	 2<Gr<Svƀ Ê,G.#]C%J {u$
<.r!Lu24$`.߭2K#/mrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ?;6 %10Ü   EA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xcept!z4 - Overflow!5Bounds Check6@Invalid Opcode7 Device NmAva_ilablJ8Aou` Fault9@{ Reserved	1]0TSS1SegmentkPr n12At V
3GenerP~ProtecErrorp
q  1 =  System Ha!Px$

-XÜPRJ$< tZ fVfR6m5Fup5/vz5PcP5Yύ615{{65tÍ6;5j1ǿ6@5`/E5Tſ6J5Jpȍ6O5A@Ǎ6T57XY_WQP6i5$QY5Q]5pa5
6e566F
05诳t5]&p6贯x96naP]6WJ}6_o@b [Q G% 	; I1`(0X[S	 m66ڟ p C8BBaa`a$at@0 UFfFɷ͋N
~fE F Nu3_ 'ȷn ]
 cRQP~
XÊܹ /FFYNZߊ1ۊA`QȴjY`Њ  aًP4:"ԃPA: & GT: .&!9'@'dQR` Z
  c }Z 
pXYZ
< 
7 SQR  ZY[S r  `؋  p 9 ^^  / Q!y
 	`=tita@ ؀ `
UЋ؎ ]_a	@]3G
AF `P C0[o0q$9SRZ[` $<u 3 0ؾ   fϥa3So ]Q VQ=3AUAY^` 
aËf3RQ3ɋff tff3fRAf;v+R'TYX0P@YP\UfWf&`1fW4]f_ff_]p_8f <u ~<  u<  l<c<@%Z<	;Q<
~`QH<i?<6<
-P= uX<~`<<pXL]WfPCI 2J訩u_fQfRVWfSt$"r   f;ttN紃 f[_^fZfYffr }  u
N`no  ` s r 2fSRfP[ȝfXZf[{<}ff}\}F5	vf s"`s t s t QVW&= & s fPf&EffXR L _^YaJVWPwR`;t
X2 *W 
_ߺ ϰ#tX _^!DNp sP6уufQ fPf'f8 P8s2fYZu< uEuPPuuZ@PPE EPP runtime BIOSVers.1  
 @@@@PAwAAAAB5B^BjBzBBBBBBwU .\@]:@.Z.Z r R.Z
qQRP<rt2[5$ԁ !Ȁ
 o -" Z`5	$ W p[	^	uR xuOR9]W SUU.V	`&n ^CLF CWU	al *Z uܠ @Ư U PSR<r
 j ?Gpp0^r
t<t ).>B x.B\ 
   PQR3쨀uAB$ԡ 3ZYXPSNT"
ǐ%UT[1Q \~a\Y`uWt= (u^
f	TeTfTeS20SSS>a VRtxSR ڊZ[  Z[Kwu?{ g՞Ƞ@
xSt%p0Q0
udC9Z^`u=Mu8qBp4
ً@}p v2m f0URϛu<u7Gt)&tڱۊ
@;Z]PGbXU 
 s ]`Ks:KxSY {M M>rQ4Ys]\ P 3Z[x0"Q`"χP3
ݸH 
?ٸG +V QLIPK ݜR
{ pN !M 軜zQȜc'
(<Pd|FFFGAGpGGHPQ&` XW<ram .7F_Swt 
' t r
2[e u0^r!<i	rr&_ Qs" r2.0F2& r $ ŀs  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9 f" ?$ pQ@	Pm Xa\#t sq]@tQadߨt bpt t
@uYм`
 萧Xr`QPPPtPXdoYQP訢0 t	3`DXd$!<!txPuPr/P  q&@tPG0X@ػ (`<u
 @&   >!w@tA AuqP7N@0  ,) & XV߁  0`O  r
 P<Fu us	` 	uA
w fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] ZS&DuhA8Z h` 
Xuh9rX&  U u@ Uϡt@Q!	 'rr
Xrr ﰭdP迕 d@y  $& 8t P ~`{QX uSQ^ `b+XNH `*C: E8011 {@@X@3NC*Y?    0 " 
p	C  lFpoypOIEMAG  IZ P?      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  -As B C  % eO   H	P 	/` <M L` c!LF	L |L ?LCD001EL TORITO SPECIFIC?ATION NON]NFN  A " * Gxx  x y 1 " s*
x"x 0_   s w_X _y\[8y y P\b é uT EtذE
UZ ʡ0
rV0 t
rwðÀxf`!i2tW & d_&E3aB&U
&]@ &EL t ûN_Du0_&E@ !wfa   @ @,B C O`PoPPPOOg]l tg}
3{mlgE
(O u7O@l 3/2    SQ>u5PGߴ y% tr!<3ɸ  3 3Y[fPfSRVk&kXThGt*t#$ >@<tƝ< t }3^Zf[fX_V Su P	9ir
- ZQFP =@ac
ېk2jgu
#p d,PfdfBd@!+ s dMd5 d	 J V,dP <d;]ttd|d]^  R 3
' ' FǠ  F/wQ3 .;v+GuBG
`F/ {@8?% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFS ۻSR׆[)T$PIR    ApVi j b c 0k` a k  y     0e\00czr'r9_h
`3. W:p
K_ϊͰ/
p aVWRS;t@St[a҃
D[_^pRW3`  Qu t`GYh l/$_ZSQV.R  B6R.R^Y[X.U uPА\Xd]<t3 r
tVd4d8D^uRWu'Es T^u 
p`|3&
yt,@
t&M1&G&afffLAAAp^+Íu 2<ytȃt
 Q ܈$FKuðWQ
u	Y;Y_uS؀upAu)A4e   \  [&f߿$f
0f ]RWS22f0r~ Zu L8s܊[_ZZfQWRfP
t)`Kr `ff  u08ufXZ_fYP h r3
r: t+a4 ޓv
t38t	
uY0	g&;t4g&Ct,g&Cf4C<vff٠
t
g&:#tfC1	fSfWfVf޴r7fg&F 	f`r!f`Gag&O@` Nb O 1f^f_f[2p n lU C  Ơ #  @@Ȱ@	@2Qð
?%,p???p?$zt?ø?
 ??а?	?2?s s	2 ? |0?|?{ u?	 nY{2^?2 	W?ÀA?@N:4=?6?/?
?$ 
!?$0? zB
>$2
>2WFWYWWW X9XX.Lt'} <u 2h@:躃 Zm[1qpsvst!ps
2  "  |  j`W.D.D
~ `` ^Y&&D aø0 м [j &&E  Z3Լ{1HQPTP !1XY`.\.T	ώǍ>.L` `aa.D`aaQPМPXX6ay
` u #P $t$?aQdh@ & Ўr 3ura.Zsa3d' $< u@hL;I<u	.Z u<@ 2$\   tu_u	V $
4 !d`kSp@ u7` $<uS[S0UNNNOz Oط0t$#rc#jU fJGMAO:*^N# f0 dâf>?uf   > t&?r_Vu0`RRWЏff+ `Qf@YrfǳQ	R^fdaW>uIf s@
f6ǁ0 utrr_> S`W]!X][]i]R]  M Gp`" *`0ʙ0qB|ppA~bcU]=p u UлD"@BGz}FJRQD%FٺY U 1 Z @ZP8^4  u(<sW.^_.0"_2cP0=XsDQm] \u..&+.	pV] @ t^Pt.&u @ u42..
t wPUU*} *Ġ&u XY`-3P A3.G
XP\ *.?\rWȎ\\_Q ___
````#`&`-`/`6`8`C`E`VS3.:Z_u.[_K@[^* UFP_2SF۹ S.c_F[C N[QF ?to_sF2~ t_Y@@7 `  _ ø8 ޏd׏`d9SA軏`0~8 3`8$ $0a6a?aJaYalaaa`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233p`f>"  tA" P a2ۊ( Ҋp ) ǊȊ&)  * 븊[* >+#1 d>,;0.- &) r.PR u>t;60n6 6 &3
t,=

"=
 
0I5w<t<u FÀ ts< 0 Ps
Ê& 
<uaw\wWQu& ` u6`!A &
ØY6 FF;t2Àc5cCc,cS e  Ya\"c`  \0ba3ac] daR~]D]E]pj`[\!\y\^\ \+t\ I|\Z[ ZZ g}
3gE
 t"6LD  ~[gu0EtsU I2KL  
o$4c&E
WE   F˽	dҤ>]>K
~SQfpVF! s^(2۹  PF  +^D!8u _#Nf^WVQCuK|ET! ذ!0w $I^:u:\!u lrwٷp Y[_SUeK.`h045@p |E\u 0$
h`&taRHP^>faRМFt@9$t, ȋ0yZC1Q)~к  #й$PRZaط $0<:rd u}P P H в = r q& fV :PgfFpXRyZÜt	t`v
 vлt[z؎ ЍYӋohf3  u SQNj0<tt	fP!XfPo BYN0]0QQ}7@gQYQu0߰ Y<u,fCISGu%f» fﻲ  f  '.>g .gQSWf@p&/ r)v}!ufPs R֐tā_[0Sf<t;f3fဿ t	f 1փ`)
utǳf>f׀`
 3a3 ӊQ0g0/\|0(_$0.$^tT.V.].
Pm.-^ZquR0.q'2.0.{ $p
faZ!fPS @pf."iiO[R*:."if`!uhZ hb  uhaúB   $Ü.`ifPQRfl f@f= p fl >@Ѝp&? ~0 ZYfXu酐5RVۃx  tcPtt>@ KXSQx$PXr$.Qu!$
BB x.JJq4HX%^ϱ`>|>@  uTf`0D fft;  Qf3[Y,6mH5 !93ӿ x^6`fUfPSXZ治+ f]17fŝf]rPmp[߸n跐 `0g 2li &  
d+d@0a_SYSID_  Ql _UU  UFUGUJU	  " 
 r
R3҄` /tZ((ý                                                  /                                                                                                                                                                                                                                                                  
    S   _ -%  DX' p Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.KZr# Mu 6\Kr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`E	 ӥ/2	r@e		p'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjof[fA1fY^f& u#f&GP Wfu   4WfZfXP'F#~r .>׀t7  /{r?`. t8 w t t  2SrV ʀs`,K	p K~t$` t u/~ǉ~ %"NV 1	s^Í6(M.|uL>R..K`>\K .:UtaKaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
_ Ѐ ʋ.E~;v j'fVfv`$dD @؊̿f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRWB@    ZXRPXuUW:>_]s*r  ZP$< - r!Pߨ@Xup>qw @<@0P  *sXXty>Wc * BQ	?Q	߸ QV  PRW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd [_^ q QP&:Ev&M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00v[fXPSpsq`D
>X`?D<PƋ4a`t a1t!$!"条q1&2PQȎ`SJr#SMwO "t 
`P2:Tt
a YXuOkuQ,9a"   <s& ? `P93 >(M}uǀ   Lt| KKVW_<uW<
uuFw ><@g2<t.$S[M[|u|
`g|`it\_^FS`}w
u}	 !.b>܀}@a`pO1uD}a1 #%D0QV 3߬+^YD$fރfA~ff?ffJf\c
bPZ#f F PXpZfP~Đ=r0&pw)Efpu fau}Cu~s3SV|wt` t t
^[PfQ
 0 < @f	t
` va f`ffafGߒfg$Prf  pqHff#f+ִ f;wfg 3g&Sg&c
uff+fX撝faf6SR	Z=>$pfP躑~qffX0ORBZruAZr
|gQ2ǜpXZ[fW|bt~b u:
rrw`U~a `B Ua p 0`crQSQVf1֙fiѥU@P U   ^Y[+u(PUFP @| ^	u<Vf
Eo 0QpLP	r=^ uS@]#^[u"X
 ! P ^~u.t Uj@w`V	_L
 B8`.
u&*P,uχ#_>SfQfV `@Ł=Ut<*MPTh+Z &Ep` `&ufރÁP  \f^fYfalSUh &]S^ ] $!&@&D0DV& fȡ\AL
^rPfWދ@VЎ & f`t@jLʃe^0 ݤP P&t_ 'f='+a¡f;MPE   Wf.ޒ	Zg&G_ǃE!#3crYR-uTf.ޒQ,f_utf`@]StQY fLOfpy,  !fPv H4f# ,;!`U
UEG &E"r@ifa{Ñ 'rnOGw{|P_@0 `n~ %؎`1#w裊 \0<t+Q 脊Y<%H
fu f` N` p?t{ Yp6.WM"fxNf.ޒg
袩7 -""#:qOOP9D	rQ99: Lxp;.9r()u zD>(uf.ޒp @- r=b*VQ$T$D
 V?&Ta<^3Csry9
lY^BG0 ~50L80o"B1EvfL *(A=D`s(d8PVWPW@NTP
DP EDLDra
fMt]LJWAM ;?f: vM^_OTrNe?:YffWfQ@Q4T=M
e UL`L@BLR G>`G^WXVyXPVFPW)G@(WPcWV+t	P& 	3

5O`f$Op%UOaaoؾ:!P	Qơb;`#SS(SQ@q	)UfhR`e_W3na  {Dku_1nhQfhhVhphgpmN`rpPjYj|t= YXi,`{Am
1$pf[iPQR Bȣu p$ q
 PSQR3۹ 3Ҵ./@3ۀƀnuo nZ]Yp'ðɆ 
tw ZYJB`"<t$
tAJBqpvBß@   D  EO qO %T%Tr%T PU	 Y
 %T w%T@%TABC  PP QQ %TR  8QS %TT  <QU @QV WDQWXYAUZ[\1]^_  c` ca cb fdc dd!eqf uHrlLMb\Q
! YQ 8  ` PRS%o` +ð ;w[ SRW*׿OзIr 2 {p3_p˺Q,ԴAs Y ro3O:3ɐqRQWSP b	$`X Q쨀t_Y3l !`@ sX Jt	u}RX( V_m 7	XAP)?[_YZ@2<UuX
8
DYJ܊Bƃ   brT;
!uAP  2
XS@
u	 聋  *ê?i<VWQPAQDt!WQB:t`
Tu8v
Y_PY_XY_^ _SM_ PPQ_DMI_ +,  #9%  2XPUv F t	F !Fٽf]X"X
W8 A t;"i &g +  pa
u
fN@  ]2ðq  S\8@&G~ &GPиG [ ǯ!@   栊@@\&\p 0F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $9F& ._贿@P X2$31     Rm`۳4!~fb ufQ8fYgBZfY[z<Ȏ3]Ou r 2LfPS=Au@u;Áp u39 u+ f?wufP@u BXu
_?ffP`< t``%{_{At{N})|S{_ k@Q  ~{{ oߜ{Kj !qO GF{YP A{^W{Q   Ag{op)RfW. um3gff=SCAFtV1G t fff Wuf(#3tfPffXuPZ"_32 p  
` tODu ($
Ѻ`,a軺ô%豺´+轺蝺faPKМJt* u$t0z$< Kf`a
%D	W	7 %1` ++A$!fa rx<
%	*P' @TO xOy Uer$DIsL:  h                                                                  RD3S@  qi  O IFYOO L vPQχF 0 .p	˸` q && f"ꊦ  ~f3z f f@i.<f.{:p >` 6a  !.wP Wf."""U"" !I a
#
~P" f3ۻxgf+ f`ffWgfǃ#Eg ٠`ܺA vT2gf頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7~;wf+f  f7gggfb	fP#ffa
tU@@P	3
gy
ff|0
gf3  P
@rΐ@
A
@  gf3fS @wff#b ffyZ?'wf3f30n,;w#`4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
P#W!fكs À +SfVQp g46fFCYQ  Y`@._f^\ g&GCffTp[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u  faUQ	U F @ E] < t<t
<t Uq`Y]p4 RPQRbfv2 0q ^~q^RZYXɓ	pr3`	x tt -  t	  i09`Kr׼=s\  "#?@@Np18P,Nff3u
~P t  f3g ?RrfF!b"AXtԳ$PPTfof`U^o3&fPQ2XYqo)YaP'у` koP!8 #	]of<tZ<? u#f$!6oA<oPtofaáPf䠄t"
桰   u$! !tp &k Xa{{{ݯ *qݰ J
s@P}FF
]X `j . j ۋv
)Mf.N. tI4~r@5p3؊^)tuw t&Du .^^;SIaϠ~@t&ڃã.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX._[X`P#
Xu!P<Xu @Pt
a`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u r}cwu
	A	πϠt&D@B êĪAT0	VcH Urp蟪sʁ `-su fqt
E$Eab&G )
V 蚷Nh8Kr>u rG mPo3F) r\ {r=H r8QWss#

Rr
3 s@M1 |#k##'F("r#謲Qlr@rk20!0p ×!r"!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uFwtt0b]( A м  .>gGa1Kr dt
t4t ߰pK'%2撰撿POo W校F X @F$$<r$:u s
jtA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXN8NwN 4o2N?0(`00sO/ mlpR
 r
fQmru$fY_b/++U+Ñ^ &u btbr_q? VQB  BY^	G $s
3
P&u3` @
r
%u@,àt <q66V&TЕup 
*&u^ô    QPXuN%&:Lr * r$ P @uP<ut.@ @5 ; E q2s2p$<@[t22P !$!$qXw= [[>ĺ".P[K<P  = sffP SQ  !ԆY[$p
 Ff 
۰N8tSFt f% f @f t0    "v   t0<@ t	@fX
PRV s vZ!
J
8
1
$og4 Nff`4eA fu4fafFDP2f tfFwP ۈ^DPm fu
fWzf`3#"fF$8QiF,0 AsrBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր  pp#f#ƿffá0 fHfVPf#f@f+f;FLvLfFPf)FqL%	ffv駎AfI )v@wf*}ff
wfAN
oXf%	G,fAʆ d!`
;V_t
fAP
Q
ĳ6"P  f%" f%  @"	 "]f'F0002FR) !.PSQR30? 䂊ffJDfZYPQRWSӶ3t"X  苂
[_ZYXS[  QW W߀@譂 _Y[:蓽pû z
  5u
 @ @Üu8 0+  ;P1 F4;@H0P >%F5 xN0Mt(BR'9ETDHP  SIMPLOiMOTOROLAVPAjVS\~ЎH_jo0P-s@^sʆb >u0n>w0А y0 {0辰}0﷣@0nSR &
 3-&Z[>00~0w 0 t
@~Ph+؋Òc0E@	0<	03`
0*~
0!0n؎&3&M<St<Mt6 6 
6^ViO٥ *~m>u l ªcıZ@ƖQmƿȪ0ʱ'* ϳʿ̱l>Uѱ ӱ Uձϰױ@-l+ 
r)>0&~X^dWV-.GF< u^_J+謫rD?.\J0ERǊAZqER~.Ȋ̱qpMQRR źZRU  ZYolR밇8AS؀u
RRp	[_P PXE%
cE%	X< $ZT
 
"
t`gVW_wZwU
uQ6rEt> r2
tC rͲ  r v 
!    _^a1n2
u[GrVei1sCr"trS ';Wr6"Q@
Er S֝)/Te  
 ` Pt ҮKw\	\*P')0\;#$ rIW(" ߳ kO_!P(B O55B< t%@r4;3r!- ,-Bq3ɰDD@Df`ó sG-ADw*VR@ ރ| 拴  t.Z^8P .;BBBX$JJ2JBPܰ\@*tJ 8*Xu` Gr V tA&q JZ  Co@A 젒*uP= ]Xruŀ̀2	
 ) (8SQ2<

2ۆ.
$=2rۆqd<w0
u@ð  ` 0    j3ɍ6L.Lu.:Ls&3߅.D}.L~s` 2`r2w`t }2K. u K^t
`3t t
t
u! t3ұ u Iú t>(M.|` .?M u} P J}uL   u3puv`bW_tURmQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L= ]Å Q3| Ys. u&	 t	&Uu"  |  Êöj.f.|f@  3.|4߿_\PQW 3ۍK#_,`Lp1( r p;`3k$t &?t+aP`)}
t 	
t>\K_ .:UǀV tMR_Z| $p$u$$<t} t	^^ Q3!*Vh (M| ^t
.uu
cs)t!JRڻ0W۵u3ێZ
t	'u
u
 pu搉@s+XPt ڰ`z︝̊̨t"Ĩ@t  p 
 ް  XPJXSPc .+. s#. sXP̀&   &X[ó5P϶'->@/HAC  }I@ σD
 uj@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& 	3!
Pwr ^	
F (|r
 	u^'Ât %^1+	d1*515r0/5Mrr[o[
u< r<0s<"N@PQN \

u' 
$nvf<0r
sus>iu.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r?20Oss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 ۊ؀	.EF
r]wsms1I9  <$u2 *<#"< u<@v{<%p!2 Æ ]
F!UF% &F4~R=r&@mv8fRF'P^S^!S&EF'f&U&]yrQ[P@ [`fZsSQt^Ë^6 M_	Aؠrf;	DE⻀~(LuTMs0]fPf}3fXr1Q}@M.  .GTAf f "./0`3V#:Tt`<~'t9r0l졂EE&?Mq<DD@ % 5I@~6(M 6u0fPfS&Mf.;Mf&]f&_} 
[!
A0'Qf*  r}讵rxL =rl`x5rdPtZ+cr@ H u~ (um-VƎo^@tffmru Y荵r)8r$c耵rre	rj蟵PT/PQX rpw
u `fSfRWBt:ـ?f.Efff߶fAUffsP-EMF F
tSuNff3f   fV(M0WP*f8f'w*f'F'*2t*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]s#   rRPR蟷pPӊ_B@ ǀ ZXюً 0oppȏB`PQK0% [ĳ߂ m h^ B_t Z^N軳rot
r`a r[v"> M fKf L, 3S5<s-(MO8L9
t" >MG<P#;<Q$@ dLPQ0X h   t޲rzvru3rij0rNrWu
p`dع 
!ʲr.Ǵ%a@tt t	tCHq% su~rt	 2PRF sH<t<)t<(u;ь>A u/WU>ӽ~`x]_3ﲱr0Cy`_P^a靠'c $PSR 2Z[`ÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfN߈n"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuK-QfXr+tðP@P3 Gp1 tff   Rf+IYL@uu$`Ύk2t
.q^G fF! PXPE t<"u<"tlV3޾x 4Q&?s0  s& p  &G` ` G`  в&O _&O`uRp`?f&G`Pa  AWQb b Z Wsa,ZX7RQVW:WgtNuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D\3p;_^V
} " uRP?M
  ^   @ eOfTPQ2@RP  4
W j <
1BQRs3ɺ@[P.
X `.afV`f  
u ߃	rp谷Cr" sR  y6	pA}Caf^U`@*߃2$ԉNT@׎Ǎ~WF$
&FG &U_@
	 `CaP[,*3% p[`>W  d t2_R Z؀ˀ$0Z'`  6dt
 * ; PȎ 萩ںf  uT @ DXø a2r$<q ؎f~f	R
 b cr&d cp0ff#f' \輐f 'f.4 tff                                   0ؾ +>+۹&۾ ߹ 36{a Á.6+0GARRùFf3۰S踹a"fV$
Ѐ
?tf`T}]"Tet4%~@ff2ȹ WfVa  gxtgGff0Xflxf    f  oTx<	gzRf#pf^f_@AWf __KUFUGUJU  A  G@ @  O" y" U-Q R"G
   _  *[%	  ` `Gd dp",q w qa aO 
p pGr rrs sq]
s P"  
~ 6r 		 
R.
  P3Ҏ¿x ȫp| Z(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ|X{u2jrwհr9_2._Skq G$!wu@t0<zw, 뭋 
t

	t
w
 b2]kS?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQUs	} V	NhESHP  TPRuaa@uXXZXp! / wXP总X@ŻÜ= swr~s
0{ _ ߸^ SQwtc.i0! !$諐 F1QjQb;˂QN 3۸ K PU'aJ >> F @K" Eup
$Sprq`tWǿ  d_pa(    K P3`σ0W%w,.s 8 ė0fg&'f Y= Y_f@`$<t'<t#<tN< uc g T~ M_ Hh<u 5  %l  
 aS Y#YhS@3xu@o G	u1ҁ X YT@ӾV 1ﻏ S!؀ UXX#XI^RU$	ppq}u$X{A u ?HHB$tu 21$q  ~WD	0yeeZCCyhhDDp!E;Edk_kÇq@0 *{ 7    I w  "5n3@@b ZQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPk趃XÀu3uCpN@*  f  fV@ ބuzyyt u3N@f6 V}yu^ uxyu?Ly@׿N`R\p ShytE 
zuyqyu#yt![yvi
Vp 
]]f^ꦍ p $ $  GNaP PGh; h"Gt1$  Ҟ   
G    *   0  v_r 4VQTLLU  Mv&Qa fWK.}
u.:tL u% t>JrS(M.[t ?M.o[u t	t_M_tEfUv"v t Ar Mw ű.V PXF
Xf]h@ &A ϴ 2j@!Q nru\ôV
	=VM.6# .t=I.
Lj@s&  |0u{ 
^SV#؁D.d.$ʋд_^[>	ã3j0rc߁Ot` 	OtOtLtDLt
LtLtL

1u	.<.}h ;$ BÁUu	U SfQR~#G rp
fL\Zf!n fP<r|wofDu
 0S_RVWUuP&Br& 1XM,L?>齨 ..>齮@u Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&G~AX]r|saps@Q\`b 
 ff&GfE  ~Aff@! 3SRWP͋޲ }ra$ꢙE˜LuR <sofQ@M}3  fYr/>(M@M.  EGώ 華./17p;[Ü}͝_Z[Ð.߀> tG0Fr=N.EP .&?M>\K@A%50ɚ @ٍ6(M C{SRt5ێËfQfS.q&Gf.;Mf&_f&_ - f[fY2PZ[fUfBSsQSl|f]Ê$uqﴀޠKsء NS3ێr?4 Pt W6̸ E1*_~Q§PX2%T鉿z u!pXuOǿ<2{f]
 N] d `5dȯPQ3 27y4rdr
` r`f<	Dϰ4p" )ð4   K SQuP $@Xu@AXe{$Htu
b5I4
<RVWf1.1Vtf	tz cjziQ<V@jV<WjU   P 0jT `HaofP > f 64s >up4zf2>kf@Jyf0dyOyf .> uy &R"quj`a  a@ u
_^Z| s Q@V_-7`;\>^- K߀r@"߀ u !迲R3rN[U=R  r.fZfY]za /  b)Y,
T!@BѤK K(K'`1`Oe(bogFg5dD		ߍy,`fW 3sA< uf,u#ǉǋp f3gf&ff=SCoAF2䀁f_U< `
 <! F ]a  i<w&< t'V3ɊoCF`S  ^ t	  QSQRVV<v^.
t;"_ ؋B^Z\@[r t ]U!P Xs¨부Oup*]ÿkkA fr! '' g kdd뙡"z uϑ+7!Qe#k(~%Q	r2t"S"觡*N   ["2ɵ"#Yø .633 s\迸&D0
V &DtH G 
B Mr!0rusu˾F. u踾/$諾rO薿sJ0ʊKZ Sžrr
r{BaFyoiZ2
 0
FFt NfF" B@ BF(	r2BB2ۀ~ P`{  t3ҸK3 ;wu;sb߉FVFF"Ѻ F)t` r4F$
Ft+ F P !VPX_V@"aWPR u	ZX>PRAtZba%= * 5Ӟ.:f tdu .f] $PMM 'm }$PnP!      PA efPff  @ fXtfUfp fSfPAafVfWg]?rddf_f^afXà]ge333C[rVd4Ad^;sgu;` 
p3 Zs M tAt<VZrd g_}
^` VWd_^gEdTg_}p[
}gE `tr	 	t}d8tW<ytu@D5pHZ
`PfUf]3
t u ' d.;Gt ._
u߸ g6$+' +k~~~~l|8 w8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0A*{q,ff$@+
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <<f0 0  || 0p0  x8`̃ <l 8`;p  x@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf   8ll8` x|xpᴃ$ x0  Px ƌ2z xp``x  xa"x -70Lx|`` p 8l`0
O v!`lvf0 x  `b  PSG  !T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
[ un>`f SvN .X2[]SWQ  ?tуpYQ_  PSR,غ:3%  Z[Xa TiAE eMA9Y.nSSK  A`( 
`3ҴqĀu N <tDmQYR" mr8rlr
2:6 v޿lZ af|PCI01 ISAPs#+T DA03COMPAQꊙ 04/19/05  ,9     F10_  m؎g ЋL_g+3f  m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_c&  hEWu}>u`RIWB2o1c% = ۘb	?g	@v	B#q
$s
|
JAfaffпfrNcӜcmqfw>
dQjut$UQ1E	`	$	c	,	A	
WТaUf	D@Īx"E
w2C
5M
HRx
R'#r
SF "+U~QcېFB b,1-,gPi*s0|0~}"py$O
z&&.x6(
{F*<c_t;j9= ==VQj>l;!"cjQd$W"!fh  nA{ tBt>dt	fh jnd$/GS
d_tfh1LbG" >tShet3~ tE>R6jhRdfjhIj>c t%j hc+>1t2>e {tefhQf t+6f *$f3f
ō~f PFPh Wwhf" !YQh}g!3F``H%>=#2hd跴h d*od' V0ұ1&	hed~ƀBJaFg)gBl	xACfcfcjFBhaFPm6@ ( jh!
Ѐa
	`#eOh!fB(0?YI 6Sh]c24
S]cxO^0M5%hK01!1
0! VD#E*hmhT")O	PBD	KB^_ 2FFTf^ F&<
uI) u&* _&8hftFFP9 1FOuÀыٹ F FIuFV)1 F*+҉FV2g+;u;uà3g% ;Fu	;V@á2gG2@4A996g% 
Ð7L*	6
ޠ WP!
@P@B0'@,\ f f`/2gc/p 3&a&cjLfP!r FPfj h!]PV=ut_ wV%#.GF| X02:8|Wd h ·&p F? GP	FNuFG0?7S 
yOl(HF Ham(tFR32N 1p !vQ>v
IbJf?Rã3@6#"qWr	v	$b2&c% 1cU oraZ

9=FPmu+&c53q3ȉpcRab`R	 	2&a% +1a1ajk_R3pW%2c%  c1jEAs 	aSFt2`h~Ѕ3^cjD
 EU

CQ @	H( 	NTa(gt31Y jibU	ʲ&WjS(
U U@Xcj~%&c_cr
x
xtt1!_p"q_Ft@߯c t#Qy"F.	U@z|p'cq-{B-&c/cjTʡ? &?c@w"_&w@6 =Oq:$_& &O} wg f/h  `dQW h◸0J
a ;f@o)dV t}qJP`F; ==av  Ђ^PѢF2g^F  ^F&F~
rR
1,e?&"e &h` ߃&d^gP@ f~@ cRdie  e# rʧ
/QQ!|@S`E  p  V60^aF@t)td Z*tT +uN&,e"e he r,9߀t"]Pt ߃Nס ѫ
+%@@4
		!A Qt:8O
d+uUԡ+~2@&_&0d(  *!g,d !r&d"cuolt5D @9".SFr{0@  &dw.j `j  3
vwB +#r}WF@T
-._B&f(&
g &{fy5& +&C!&.&Ƈfd r<|ehJ *MRcKxK@>de&eeFVD}0Afc24ae6d	s$8B:aT <K>]c;rvА)1uN1de Cܴ?eeF#񥕺@ty#Zj$	c>RjgZ	؁ de$ < u @<@/""r¸ ,1 ePwZa 94@14!fB4L(va2 e0 o
t%rPЋF^Nr'~#tp  u^ }   %  h )A^  ~u +ËFV VF6Ƃ6~ r~t` t uF~fv
0V32,pIuquSI]][t

^Q ^^p۸L~  f#} F B F~P|v^ KF{ NFFߌV~ NHt@HtcH} P )nA-pg0$6^F&? u/<cvA8>rd|mhxcΐ2RacV;3.cv`f.cm`
NN]F -ev膑{$F8?gFF7PjR?g_S^/GFPv4F?gFmP?c~aPa?:!Z`dD_&@0c16C`b`~2|FtFr(}QW^
4~`4	b-2O _`-+F1V!FQC94%~ t;F4.FҔ0
z u WV~vN^?>S
A0@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODRHAA~(|W~FIt_~@u"2Fw#}HFB^F&WN} 
 
%.APU!u@##Y KVDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq;&'h*V~oʋv!^PFG>Iub: ^&^&8t #^^?}۲h!#ù
 0GF N% }ۋp,-Ar  ~s԰ NFN<+;u0g}03ɋFppAFWC&PfSp@ ~0gЋsG^AaQFހp ~
韋vЂ@x|r
CVV,GV~^&wFIa&a8^RF"Q2c%Vc>R⻐I"kbf?NP33#1!
= r	v	$
a2`% 592~
oP_#_j`R#	2&aW% XRo!2c% Rc1cjAROp j	aR/! (!Q023ޓ޷cjD"E
	C
@Hp

Ns#ST
	 U4	@g
3s1 jiQS,py~r]Uyzpxx$P#0
7
{2
Rc26&cc2fAf   df߹	 e 2 g 0fc𸿞m؃@2-@pBᔢ T Kc]cFr#ᾐ4(C᣼ VҊ@lzFRQs7RS3zB
3~Qs9 ݑ1> j6hJjFc_ QnUeX>W@bIcW'?@#c,R U!
$+9UoR^3Ez}j`faf	ff؃}E	fcPX BA@@TA \a$ADVxÂE$U
C4
?
*Ag}H_ R2
N7BUacҭB %SpF "4)gjPL̲ip+2~0P442F2ͱ  8jh!YҠLWVvًދ~ &F<t<
b3rF*;a}7ay_~tF&8toFu|t<r21DVp^u	A(|ÐͿ ~Pfh#  ~0pF;rF f{?* F P F*N*ȁ vFoP0-BvPJ
u+Tf^F  FOuE	fdf &dfvctfcfq0@  &3g22`% u"2g$<22g%2g14gu84q= +N32g33 Љ  au6g$<u~6g% bPu&7
u]f2 % wD0	u 
uB
 )
u/Au#aa68g%FOr TfUfVf WfXf	YfZf[f
\f]f^f_f`fafbfwXAL f3K f 29L_ujvRPjk- L_FB~2|Ը1~ĀF  p ~ uFdްm
 e jtWqV L_FRvquF@ b*J*p
NvQWVqoFFP
|F؊f- Ӿh &m
'Fܷf h F֊ft@ t؉FjRvvYuh 0-~ڷSt` su嶯P0M2muhLh @h FފfPAnF[f jup:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~nƹp^؊R>QPƆ0[\@ 'POI1aPj?+*`
- e)@0hC NVZZG@|-\\\<\劆2d$0   ePtQ$j)!f@r 
CeۆeQ@2gЎvf@0)!"*- t*-} t94!13q$RFa2 OEjIOboLMBF m0#"7g
1-(P  GEtt/ 3|
/}@+F++PR1w6pWd qa"$ߒ1 v2g/ب ksaa1jLFPћ*1Bj9)"#2#"&#AD/]LDE WV3 Wp^&@RFGo|P38]6 2 R& FWbwq`I rR7<"JW>
d߸ ؖdQaa6  &=  t@M[_ Ft 0y 
"Tf#B-//

	
A@yu	( LpĴ &&TVP{S~ t'jPFI n t/ u#'jfyGqt=o tA:? >u
,e&he""e2he% P-he  t&,e 1`ul &l yfd_xfe۶gfe0ee{e>gdaPaQadUUd*qu[h hJP~h Z轊菢p:r@juBzhz[NjA4R 	'"	^		

w 
?		 	̢	$r	B		RaF_F&? t5(u%&|Rup )u&DPƋV@pFF" cӐfjfh 
 fh `  	     Dq~  A u &c E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Q   8>ۋ  &9w&EU 6`  VV{ 6Dˠ   9~ H  ;p! r
f
>~ K{Āv&@u?PM`^; vĴ 3fjth  <Њp N_  "f pvV>B   vV*r_F^ ɀCP% 
Pp h
 h  RaNF
+F{@0F!vvo 	FN_NF@ hbj a^0CFPNQ=`*P`VW  p 3_^=e #N_ @SᄊF`
FgNBqF.
%
;F|!%} F@P!y]!Vvm`NP`rF^Dt&@A$0#FlAQ@Pu< t (F7 PF@5
 f `(* yBub~9v*VA7Ɛ2xƊ*} ufU  ߋVn'] ᚃ> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ft^ 3G +tp
V^% = @ʃ@A3t`߰@!A;wⰀ>
 u31&A *;t{r1A 
*FD0F
tҕ t" ؾ`fp0;
V=O`2P.B@?Vu	T.SEHDMa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uo31~^
AߋF:߽G
uɋN3~(~ {u j  F;S|;pUD  fUVNVv<%tF` u DD^
0NÈ ؏u0+b1WQPWVFX3^tQrJ;v~ F^F&uF$=IW\qQb]R}  P+΋э8sYdvva!V0N&8 uN = tp&@* 0&At߱_m !
`f/+IQ@kqCTN`_
ʐ kj ##vH_j&F3v~Bv0Q&ğ 0b;~ANuv 0dFA  
`feP{0VV -cPQ  F ~ ~
~h3ҋ P{W t4>gPǰvdPq 	|ptGW5^o"p j9Fu
q_sPK0 vv#5+PFV 00NvD"F9F}+F- uP@!b' ɒq YF{F`V%"{ nT\QPEP)DPAjEP:! fh p39> ~jy/0 *9>u	A
@0
A/\&76I%'@2)
߃
G;|2*& /P c`z8(F
A
j Q/j V@VRPy=AQda'P? p<n@]c E +FFVda#
0UcSpbyf 0aDPdQ虡xQ	5Q`,+F+Ѡ`M*2X R 3Rg@=PDI=ӁF3@**A;}Rvs`V6rqyg*@F;vwPST4C
sR14+

uSK#aQCgPedD&A84	PeV輡VPɖ!~&-24hQRptY~AS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) `IϠf@`	PXhf@PF^U^EAgT`X2s|Pxb<FA@ŀ[0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4v .9~4aWFO^6,+F!}=pu.trpSq &OC@ +σQk._+ǀ
0|ctj[|Qu

FB.=Q j]>| LnW0!L# ' OKCA& !!ypa2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfzf?F  F
Pj   v
u}1Aju >PHPV`
Ϲ!&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C `uDPk*.e H!MbB되9>u	w r =`Gg	%R4O1miDu(+Huu @uqt j	j/fh	m<	"	PV^FPqf~
 t

>axQEPzU@ ]FY m DVVjvvұ{xX s6G ]3?#PS0N02XPr~CwWF0B@UJP1qE~
%G jR[807+$ }p  9]tl ##J/E=/`J/F_FP9 \ dpg
p; ;NNNQP[ @C7 򠽋= K = ;  -Pp-߄--xАW^p'Fj  k >f`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< u}N0빋v T|` 3P Ppo & !VN;
u_逐xA^F;~maiXS `
$~Du6f| b;|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F| ~'A^&+^& 'FK'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 _rz/~[I>mFWV  Gc de td@ U@ l tee
|t*ATD\[u0}Y;F~ ZpӁrջN@uOp0
DK*=Np>d u)>e tl>g tt >fc t|cx yhPb?0 Whp.u"jhahP_ݠ
j(h!fhb_eh_ j _h]ch_K^ _T _}B g_m#P_ak%b !fBz"	 e% jes%^ ]cc%	 KcS%
 TcC% Bc3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНp߶t1rtI߀DODpU*䊇>AvuA*HWvAPVt0<@p& }5*5446524I5r6597h.@mE@ jpPVCpWVh
	 !V3j hD	~^DXր`HtHt#h !    C wt^ f	{$F HtHtHHt$" @ $Ѻ&&G<P jh	G+PX
G>7x@n ^aGP0v&ƀ ~~RrjV6 ofP)37P Ы>X F`~|`֢"®s}vI@x	&8 t|r
9GPu O  >p~q9	uarf   ^f~ t  |֊F}Ñ!	eMG	yL0#	Kްa c 	{3$o0(~`(h跽pa^p3&~/tC&  v&8 u*C;^|ckaF^P9PP`^? tvN~}"v`<1
ރ~ u0fDFG&9 uoԉ~WRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ뿛j*Q`
0 R~D@F	5 0 % t" uNj p貁F  Bܲ u
gށMN3~*^
7 8&8u	F;|,Bdno
eP s$
P PC 
Cc!
d$  *8fudg"w^uԍQ/	tP3_0F |n FPf@
t)f3fn @Hpfh 륐j h4`h` 4$u @3~l3 ^1`F*A;HtϠ5= t	d@ &d} ڑ.dQu鉀&
:	@

 &
&
hhN
hɷ ?AA7B 
@
@ -*

@5wq&
 3F! "&d&d JfkwJf!B"  _FP~H AKN
3a`#\'"%4$:GBHF_^/`^Z4 č&Í,3F
W46 |x$dh0dj(|j 9
P8
PPfsV
bW&*_)@&` 4 d t&<
 <)뀖 x
"Q %1'@qx`
!l Ophdj 説 %cbN0f2f3	諠_% _ Piр`RB/
?
$_*H0/b$&40/04RTR"_RVdsp%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq鄿-Mtr` MYnp= d.К"ߛ0,[2@0`  8&_0'R!"ս,20z`  0PXu/1V hL}h 9ST  9YۂY݂Yހ
Y&"0ZdW a=	_[Q["
@4 |ޱ
U!@ _d_da0y@ Vfh0/h y Pc@t&
 
@ ACCC΁!#!
@d_d_
{Ɛ޾
r4( + (#+-+tp*tcmKt
- tu] &3& tuGђv 1vh
h P!wu
j8%AW&A܏
-C@#'&$'a'a{Ðjg؁ ڰ @&
)3bPf 
0>{+>>G~>d'>n!>/>f'>< Ћ5P$pD D:E4Q89JR4"" :L%9
5Bδ,hh V2^Du+! 5 31;utX&_\S7AA@A@tR_!P!_!
@>T`O? 6`L.ࡠAL&_T`~~<!Q"Q Q*|3ɻm &ArhOE@Qhp@	X^rQUUtD33,i
m; YK?T`mrFv!
orMoVv0%/@tx$P!D$$`
P#wBf~hx0%YAǁ6K=,D=H=yMT`;}Ա;
fhZ/ " [BGb %^
tн
]
ct,W*@t>tq *``(@a@1)@4AEV`ŏm>ƏxCQ/ M7# ғ,$ $ T0@0Qp@
%@U$R~2UW62`V`ҟlB	W`vuvXUP74	b
A
 ꫘058$}   	 NbvʤؤG H1p  AЗ1! 0W`0uW`}b"XWab 눋V` 2߁ 1 5r1p "(9@( f fcEWfh  _е
fcfV`&cN&._.@S56P6e!7>d>8FFj% 9N$N@fdfAcu
nvu-dum$uuu	V@V ,ǈ"]|roh֣2;voʋF8FPVh@PwMv
/WVO 
1!\` ^HtHtt-L7Z!B+ @3!!b?>
<ĶԪ1P3d %`4S 9@ET'`etG:l Eag@C
J
Šs( ,f+fF@ ؀  FF0F a^FKF`D>== p  -  -tRp   -ݵ -*t:-`ս ߐ=+-B `-@Pt]}qx$Ht/HtG:HC 6 Pۢ ( 1!z"!13 Rc" 'ހA
Fy
t)j UPTPfsV,ttp ;Ґ| a&7yBY!Fp *HFL~* f fF vfvvFPv{ڐ5Fpu63F *˃~%v슅 a :uFG;?F :a~ t
w&x |xP ~^@&p!U  p!qq t&AɯÃ@̌?"Ht)3Ã?@A ~r}b|ɀ&X qV>\` ucuHj 
&3v0 RheZ`ff``f `U   a9FhD R
Z`he3`ꢸ8-9t- 	to Y`r
  *Xfjj a
#5	1	u.#JN1uh Ɛ>` tu!fh  P	e-NR> `6
Lh45PhjB6a3`.a&  * F |b rPpu
ScA >p#u> a t\t&el6\`y  W륃h`te30a13
>`*u	>] 0!jkj2r3t;73Be'kJP t'${~80:2GR%4;44Z
`bh j@p?@?@(!F@[$
5$4pQ*tS?=<ʓ=5
5
]`Kh@a	@Ba	 fh+rD-q,Rpp$Qې#;$ %`/P*aRd,a.ac0ahen`P"r ) c%  = $οK
ef1 [L2 SRb
b
~c
rՒ
 }Zg
Pg
 0

 Gwϊ֢A] Dt,-
t%-.t,-	 tE-
tYt- t/PC Dɣ\`:B~B/ _p}}  soU&Viet,eu& riet+u
q0t`]heU@UU  -Ǿ@ut;>}`  Pr־%h	pjtXя60cHtHst `t' wQ houͨ
^_  WV3ɀ> N3Br]Zґ@FPWnr~Pr
NpDt  ^& Q _FV^tF&?ud,,,,,,,p+,,.>uh hmhߪE h 6 j?h~
Bޣ"?@t) 365?P@;@)}F~
rwF 
hl΢	
J=
Z 5#W<B6f
 ~Ĳfdf v3ɉNv~FV
tut9v~O|܉~*Pӈf2a^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpf>afff}&XS  
>at&
]S
 P@Jt	Œt`p` ^3

tF^&F!u	 |03$NoF#@
{EP2}pnGW^rF*f+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.LftW/ /  p- 2&?a% +11@a >a>a@ 3 ֐j5B jh
@鸾E
] C
@
@
/ /  (YP)@ wj}Q'3
^'G`ho2g5؎GS.aAc2a2g, >a7a$ a
0o&
c
]Q 
@DM
F@f 
fh0V" !B
p,pfh*+`()&' $%h#f0b\rc t
Kc eu
M0  O hE `F<tF "oh"B} by_F -FC|ߊFoàBaGVAװ
BaDaa!J/&PFۯ&J`lLH f`OeO KD]R]B
3HT4P3
	^Ċ70S
BE

ZH
<U㮣YF \X_	R[\t
R2D2A `>JT
Be5TphVhhUj&U%l$"6U5n42pFUEpyDBOQ
 !\,B`C`LB`fB`-
@- `
- Kt K<_Pc_`d$_@UCU8R`n|о $0F\r4,2"5^B^Da  ab zAB  !" 8-_ 2&Cdcl{dtஃ d@TĀDa?-  3 @+- b	κic )#@댉y  
#j+v qp wbpʿ|{@ʣ"LcfcfBcpp@tja axx`= `&UCADPJt &hDǎ&? t
&ؐ
~`@# 
誄
C	@


A C	 @c:Qq@t&fhv߂+x@{n~fhzh]
5}o4R5tfh:}89h7Rz/с0vrv?=>_h<^@L`	BA:2hhWVde$ < u @<@u"c߾@ut;-> `  ҵ*r$ h.h$g>A`1066JaW pꉰ
uY W4!-!6!}U!Ui9!4JaE 9  "",DB 4%@'^F  c` = pHt
q j0 r j 6|@uf4_;F~ q P˃rջ|N@uORphhtqnWV6UWI 
0nrvdt
~ & F Fdt &ce"8$KJcM&PD@&&w &&(rhRh"ؽb&o (F#LaJ_& *䣿LaPeA u$w4>7 h^rh<>9  t~@ td` |l=  VPΑ j-Lazp0u.&dlj`&t|"xq~臐
OF1Ď52#G2,A2%A2,A2EA2Y1a1/C1La:b/1 ]@1B1L1c&0VfvfhI
 Έpu mh߫ bF@c:tF&<:u-FF
*0N&$   
ue3һC7 ~ uF	 F
  
 
 < w C
v`
k*A
jq<N^PF
RPEP
? 0
~ ~ tghdv&~ tD赪E=`=u5 貇0
`
 ^3 FPPP }FF9Fr r% -
 ؋0v v sd ƨu= w1Ȑ*6~FPX.a@c y ~ t 4Fa    R F  :ޅ .E {" / 
Qfл~dzt}' VƂOFZIZ#3^ \NoXiV.tCq u^ GCauK  K .g" ƁWCI Nr@~u~_v W    I v@FĠrFV!F^@=uFv2N'22g+1@]WV6Khh芸C{*NK{ z`uPzzz4zSVzzgzz7Q2zFIdxz @zAza
"zj &z<f+f{F@ ^  ^:V^KFP6a2 > Lv3+Q OYo  l`- t$ fFf~ sA,GuhkܠdfQVȡaڙRPSQfXfYf3fffPfv˩MF fh  bU1g Fvh &CQPXpd P&qTY"ӗ!T"a̑yyyE  p 4  VW6rNq\		% 6|aD6Pf\ 6Lf|<`yݤ@
눤]0Ð3Ðp6  MHz` KBSIMPLO  MOTOROLA  HP  1.19!drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exoit EP  s! withouaving
o Securit@Administ or passworp5Cte a/"Po?wer-OnWGp Devi#cedeDgbD$L $s mart Card%G
supportEmbedde&f
taA!e'e
tr*ac',p(s$`*authenticS+e
credal /Auto2cH%Tools Ba| /0Calib( @(`'lectzb HDD:lf-T2 op8s Activ O Me]m
Chep? r s: ll=mb 	>>uA@AdvancuepaL`4uagaC lDt7  of grayq6fieldO Boow1b..Pres>=y keyH I ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQ?menu iYqKp"<ENTER{> Xbegi)ФWK%#.followM%Z&:fpc->  KSPACE = NexBR3c-BACK@vio"Fg0hTABE3iSHIFT+&*lF2@&10`
v[J #'9 E~r This60/cann)b`mU;d An e socH@ whs6c.pde _0x01 e@ondApGPu@p0{6Crequi yayE`d~jba@%mu0C
movP:y e4k/MEU )hQ1& ilAl//+2SDcleOs}u06ssfulManuZqr  N0
d:Pr9ottyp@speItepp+CacVize (L1/L2)SQ ROM ydd famiaseP8l nu|pi 	Videovis"KeybooFr06verDbI1<ed2e3Bbg4`1qa<ownPhip<(TdG
W
O3O	*	0Ĩtafdai5u%BSNZC*D$ 1
2
3L	ME
C

V


4TV
o
Do
So ྶB: D.   %FPA2d1!J#biFaP7WalRX0s&1&H} Addline4 AlXn.%F$Warn: rk TplIl0o  zsfTrea /4vր, lef ea waba002 A: 
de` +waqt@tҰ_ )Vu @9rnInv P
)!	:Ayou̔ {wa@|to  Т?m  aioa	  0o`b+-c(Quick`n22 [(Cvre@s3 (S.M.A.R.T.) 1EP1pexim@s ): 3A0¾# g¶30%v}} ty hao#0#upr4:1't4	f-UnknLkp{ilWR!mServRceaPS)doџ47`?a}ribp	:`exP9 'b`G H  Oylp New =Vfy nY7Enc8Off IO  ɥA L0A66#%AKroE   p dV
Ad1ݰU @ҭ5O<cpcaus7Ԁp@=AH"h` A&Opower-.AS΁Qa?U= loss  (dYAhcou  nlcof aQgoH04)ev`ۢ?[YDocHishR`e#d?!0f]Dddi1aly JJe HP`"UTool Cr.%oF8IL`ˣ Bk! g Uмn qHpm`@jtWASN !arv0	s /UcwcO֚P2"Onj* `e:Z%%% F@д%԰#Dn -f 0 TndĠfӰunuR?*z$n)tart8BQK`fra Par1yNs Spdlot CD-Q& vb $۠@yU@	|11` abourdzph҂ u20W!?1 bUSER"MAST xA
panPO9`cRR%Tk_eep i2acI=ewphysD`<phaR  7mpp`r. I62?R>
,ҚnRVun*"׀gFOOAutoOcEdpptY55 )0?#ON; 
O[?k2{iCb_pur?t \22tQh@Pqsow k ebdiPerJa@naff+bdata, ]ssiblma!aKpkicgi0d!V I0sWPl r mmAM | Tu@yl,lreplap[vo o/* y4y Xr" |t, CoHA=Wy|'qu{me`1r, @M6`*p0uibty. IfRdo4Ǆpw8`!ESCsA.!
T V NtypB'>'nђ@F10"q0rm,bShx,t+  E$@ MiBjQ  KOrpr: U ay OPXrHDCgDLb!~ (left@/hUSB t HQbsSu K Zipo'Firo!F`thifp Sixa h )ENh`ASwap Fn/Ctrls K8TU.S`aslegackC&>is`7)n0=Pr@ry Vpo  d NTSmC`AL -J #-M+t
Bid`EPP ECPd2size 32 _MB 64a F@p_AlwaynPPYi0AC3 gWLAN D Radi ViBluKet h /rS :chAӡ  SgB1rtNtЖ Ed (%+n,2())+P( z+f1Eqn7)&e 12]3TokRAHp
 kP	M3Unique Id"!fD`&pep [  (tu    S`KCalib!6N@s
P DKA.Xb 0B HwO
@ELi MEUk'g'MRoN/@G/U[:>1 : C0@g . % ]4 /C le	2  yc1`di k-d3	s
H

,
* A 5>M(4o!ylSp` @hnologygYadapAPXE RPL Exc"Popupz(`@0 _10  2@ 3 U4 5 6@7܁F12z5 15`@ 3 "MnB `ouchpaPuSNon`<F1=Hilfe> piYin[O՟nzeigpfxҠPpeict  KaguaobVwiePPxnLveinun(	-hkz
.igneDpd`*nwt nehPဂ7/%Set#SRheitsfunk:n`toa u
nBlt-KuO] Gertes/--ID FO`t7	U>sttz !@  0Qz#  beim 3st
ng !KAr`5}nHsvorrq##7..zu/rck z9
B .p,
PKf_g{ms>0ThEx)`Akkukr_eK tpBsgewǄhlDD-Selbss8@´ItivS9#LtIpr 3g 0: tpplAlTL
PZ`OS
@ PErw :%SprAaQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e SePMbqTa@0, um p_3fahB@i=A, ESC=Abb!#`WBkzae!TJasqN0\ , Ja	=Meh`mG VeZ
zpOMark"sy!*!'MenS% dPfeilt!
^dQg'abe2RmOq>ko?9 c`s.	folj
BnA 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchrit3t-`VowA(|GTabul!fts+ Holl+ge0dOx F2@
38= {gy EschlrLi@PK kan~Lt we YeiffMgy16P=`?rgetrЮn.Dc 01 L`fit B kqcQFY+<W\selomv6PorB]er0ilXWqDeskU-KsBhmau f 3asAރbzw.2Mobiޯbgtz%.`Qz qh@4Bi///"2f!
}[KAlgrѫ ab	chlos@`F-M`ll ProYz yprtit`wigH!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Grafik-R0sa@Q "f]r-Con "
A   °a?7J	b31O 2O 3O 4dqV si H>(F  `	o	 o
o1
L
2aSekr ET* "L$ƍD%'$b-!3Kc(1  WalkZero-T<One EdA`@PBnO`+: tbX7 stNqbislwnK.p  ZEucQN-/WB _&leQb s Atei#CP0&ILp`ak AM:nfC6
lW&$ge`KR/p+Pglp0%ɏ5 L  	/  M0$wirkQh"vQM?`3, daᱭ
l^ie0wQPocFLˤ01 ( anH12 _(UmfafdIGc$fhrxdauP(Min.): 30ZБdS`@0% cgt59wu<wm HoPuy p%ubr`"w: ؑH	<ԑUnbeaaMTHC52'rvo-L5.
32@lhafAttribu0FID 2u"LS.M.A.R.T.˸XXMs K`kwp eus<~1L Dea8  JaҠQ`eD/t Falgebe
U	ң BU5Ip OdminIoz< Dur1@`'@`|  'mg1i@eFN1sgd,E.@"< t>tifiz peq s{0yrt.@s Zu1`0ĆLzO 9p袓enl@~.Ajb s0Q!np'PlsAviceZTa s ,F$0@ h0`$pga|F	 :	 JZtfa@npWUm Fun)S7, m3e\Wn HP{tectToolsP=c^ty ManagпUo-- c}- k QuickoLockSubCndFr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B>#, lp$meh1A #I  Nk>"o3պf`ot-Parpen}imCD-ҏ& g1M!
UP:an3A7ym$"rive&Ftpla`t9;PcJs E-=\s mU8unb{rapjbar.¢IpT
b,ҋbewB>SDsTD,d{¼ ! C&&,	I, 2.\v%,   H2iB<nc4z@ N󝀞}Begriff0d>iautomLs O75@:oh)l<? i  Q֩g`yp#ps\V*f~
T 'U!!´!:mU"n OP o"e o)lnY@y#OBzs@瓡58c<sQy:Sn iQ.) r`uM(qS!|,qs mh!Aac%Cw  Prq ғ+I of0  qurn׳hE .7 Escdrr empf/qS	f d?zu! тROx t. 󉡛@  f.МYұF&1 2 B 7 b-B`ntra tAdant!W hj`!@Esc-&VlȠ>m kW
'p'p`\ F10`esRh:
x3fg`g sbD} m  ܡ@MMuBay&m )bBtghk`-EQb(links (1tUSB-b#a-2؆Su`1Zip 1`234 5`678 9`QFn/Str	g!Pt ų dEaCГ (USApf-ZeP]B`iebss"unab/hng`  cAIAn Grafik-ContrPrimSek% Video- rnԿBidirebal GrÔP us Lfa`iCb0tzbB
d}r WLAN-Gf0Blue_tooth9URn/a EgpaA'ggr e_%7(&.(o)u -9E`t 1"2P3Y5ToRRa C:=A q 1tv^Q1I0NqkBo>F AkkuN  `Pta   x a  Kalib  M`k`O  NƘiual _ !  O k   O D O,rOTra- ?6. .O .L4obi!qp9OO5"R !P	Egn@OOf`.[ц=rІ 1 :9. % ]!ablo(2^Entl h@o3 Pp1
Bm* 2
  GS-2'su' `Radap0aeBPmbz\A}ExpA-!-Popup ( .) W0edCau Q0PdW2 (Z@  Ke`~Compropstn@ <F1=?Hjlp>A>toplys!pVisúne; G0tily !Akonfx@b[GendPfraMqzp@QrU
J`gnorndr o&fslu r 1 u*t`gBOtne k)hed AdministoradAsko KP aodA7 fo% (hEd2jeG-iS q		 *	v*
J	Sm-k	G{od0delsf 7do_>dbyggPGOds -&2	 Nu@00faks l&2 Ua!g
s)9FHk@\HF BAa.@ġV  czb"dvalg b&HDD-selv\tPr HukoQA.ainPQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @myo2nedt_t felOC4 +'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=AnnuaFs!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we  releP %menup(,1Wt<ENTER> bqec>A)et. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-TILBAGEĀr!JTAB&2$KIFTa++ԻF2@	:*~= Acce1h0!hk<>{sfej 8AB3ku1i0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvvek`EnJJ
i db!?s flyMsÈn</MEUqoO5 bp* uveztzbrud 2JI>,nemfBx J@`  Prc c@or-typ hBigH  ztr`7Crcache ?(L1/L2>HVROM-d@ familieći;AWdeEo#f0pds:@Xr-cs]D.-ba`s i`9e2o`%I3o&4Z&at-ta`ofej1E("Wat)	O3OW@Ew ex{%Isr4E$ TyPy%܉xy lydes!Bmis\ 0'bvD1I'ij`Qeje var0: DB1! se  alt@P02[holda@ pBoPqt`/b Bb-Bdqdhuw5,pr Pk
kEuG
rBA:ރTETfDF%Ugyldig/
t-  @ng#ivuİ,vi av4,? i#BK?@ ~$1 (Hur P9)%Omf`
) sl(`{ (): 30(˄2j  `1x?0% frpudZ44b2@DR 	cq: KuB+"!UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft; nDeaeo Fra@l ! e@+ń4PR @{	s0FC 		ƈ4D䌀
&KE  beviвB7 9!Cfdes, f.. <ramG261 PoRR.RVuAjv@me+tabWata. Du bu$AM flAX:|Ը vicehCa D[G @[&?r !,ci HP tectToolo9"jK Quickpau`LsQmP Skrp!T0rKvt%`#k|qX)/sa1-$$ Hvis at ۘ`w@x6r,
di upbilK2;+1ol p@frard )x  C?d-rom- cU?Bg SHo2A:e@AuΑ5uhİu,; Dq .  bOBRUGER-s OVEDADGANGSKODEN,22QՉL.U altga9`s  n Be  ned op@Ia0'edS T#
{	aM8D lj ЂD_aBAQNhjlp eutom`oK, D,ZAbyg!iWj?5B^.k pegrma@anF`Pig`v2n:j fy]s dsk5 2 rbppc(On O"k	v  .cBna  @ucW"EKm/, somмa ck@
ҚTut. Urd}U pbz@oPc/cҁÀ pikoSӴ@.ƃP  бbefalkraf ǓPapx¬ 'A1ŀ@"plN . PAXu	u
q  &cO.q#m"J" 4,Q/d i`$HuA0˗0.a.j2:@ENtrA!5ESC. 奘% orPx '*F':ge@F10FYӄMsf
i/PcD+su  !Dk Oss{rflgm2 vDRRenAHPskm DSP-bas MultiBay (Kp0/$hjUSB-flop#py%#{cc{2|2 vbsu SbAzip~Fr@aVTredj Fj e SjSyRV O Ni  ȃ Skimѩm F?n/Ctrl jE`lPv(a@i`sk)  UegeUstt!
u@PnPAQ֠rm-cr Pri[m@Se`d V@o Out Para  TjStrCL`ohuk9oЙ Bld t 6nr compu 10P0ƀtrm
gAt WLAN-!spi}oBluet hK/A (trdllo|netr0Uc!mstyAփ&(x(top1*b*Ethqft 1K23KToJRaY HL	e+	 	Ent 5gt id-nu2@ 0ı@  S@   Z 7b/ JKalibB' n
daigO x 9 p6 @WNM H KO OM2[bo   O O #0OOOO$HAgs 1 @1O O
1VSi mo`gPa(MEU) J=K=OOG OqOO  OOO[ TPq 1 :3 O . `% ].gAmjt2 Af@FH5L)O3@	Genos	
k

, *  J/X4% G)g`hB`At `r|`bpopupsink(sek.!H0ȉ25f-1@b*gpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jons sypL!a@3$k")Hefra 6#:p`di!opQ	:¢k@'Pg _avslu!A ,lBDE;sprograpt STt Zpass@ a/$OpDFA0`|U'yrsei!vsOfunkur!tif@ԃ% @%-
vn Sm4 #godkj0RƐ!neby3Pi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & vaclg !Al`PP 65vt Ak 	MbT!#[ SS;G@$*
`H!4v wprlg 6  Dem75bM @ZdtJIel[3
.5E6o%<}5TrykMkC taJqLL&pg _=, ESC=AvbrAya bBAPpJaCNe3i rP, T\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMR?OM = NQ&86  <-TILBAKEPvrsig*TAB&|"HIFT++F2@	)}= Go f#l`bsfe*F`  SPk0`pZmnop@5 PS M0|m kj7resve!@m d;@ie pp 9!obaR.aflysbc^ 0dS w}a`1A|rv full1z. kode 02Io"Produ _t Nopablokk-mll  {typ h@igv&-ga zvAӄbuffN(L1/L2Meng`	Q	eniu V@wo-ЏҢTjrtroUSW,kCobgRi,oK51 qi I2234d0,p( E 
,9(Q `
oa
oA
o,
NEkg#Iml۔$Eo=%Hq ok!i*pxs("Walp9?g 0s"-hu1jH( AdWss e7"~e PRnAd 4~: DsA#.ys@QtidlSCholp`@DH[aQ "/hޠe-  d, drnP}u1p s&akl<k`cnn02A:%ژO b@ҼrCeg1i%HUgyldig#DSR`	PF
	#NEh0mtEb`?̀{]F igno3t_te?-  H|N 1 (R @nslXbP (): 30xA3ggr 0$s0%[v\s	t!vhF_f!_: Ka"qu!t``UÓ5$SQ&eGt To(Lesb'1pDu+q vribo: ID01rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreft -njAv`l ePcᰔ1qrEٰjvlikt aDu !0oC2Ѽ	aŤokag3ogs.rɐor dmpe!l& Tp}?ّ.rPa(A=pph.5 `bku  amK#|0vice. 0ula!?eD(s aI 0"H i HP ptectTools3curity Ma-n0`r.'-R0N%l  ēlanppa0us L@$AOmpEar`i!gi$}eu beska u"-U+/- +ӂWE%q  '. tgl@`rh,v@=$ڀPŶ.# K$RmEp! rfrard- ParlQl+vSq1   CD- )FsU1ut Ho $-:"Be5B`Dhpug h`h!3@b྿BRUKERHOVED-T5 B:I Ryumu0B@EQ
 an0]*RDCbe! 1KPP
0P  v@" 2$Va! #
6R,ARZP< 	!؆ 5)pp   t~I@HOM @ automPYpD!wLock	3cbyggZ)b06`  @]maPq޷ilg ]ge0.S k_[h 7fysAad $0GmqW  l#=	|u !m:fnd1]VsQs Ѻdda g }u%x. U⿲g omd @N1|0/e XG)0znq
` uPbVnbefat 31G	A|q.1A=w A0k1E5  fhP _!R!'Y}I7MT֐s w-QVflans NPBv
,x2ʰESC-yL ΢`rb'fD'J F10$ZCb#e:hf$ nd  Nor iFGO%re  MultiBayPG]y "Q'n(vef!e)pPko.ngsbahhsyOBUSBA|w Zip-U
A A0AaFn/oCtrle EAVd(USA)|GekeenAela	jZtroA2deo@!j"pTisrr`2F3ViA7tiࢀ`0mFgradi/@?trdl |t
WLAN) OFBluet_ooth /-PbftQ`mpbQ҅ Agsss`B	styQ"'1_"&2o! (v"*b/!1 Eth  ?	)	3 R@NsA'ooo/
8ni> gtifikOC&\=B6riQG HtB@    3ymbo Kali!bPaK B!es- IA09splХal ,-N	O	I	O	 O	51O	O	O	O	8ksp. _O	O	O	`lnd 4oO	 O	
%O	O	_Cs? mob. ^
 H.\L.\O	 !zo
{8{O	B.[ TAO/: La. % ]!fullC2Fa{@i3
"Qin/h* Oy  (o J/D 
irpk)mA sin hurtig (sekuPrF1#2- f1.Sepute P pConfiguracie la Com`adora <F1=Ayuda> rchivo  m%l 
Sma`pGu isco flex	ic1pٻK Ra`&sAvalopf@do@bPa۞y Ignambios y`li a A{  	g3 'Ln@epidadAse
'  ' Aj0iciof%0posi@s_SIc)$  +5`*bKskSm!=C SoqPe*cP#<) Sectyincor% E  0e" 30/c`VP>6OfbrI
aBаVc!3nci@])AutomaHerrWami aC2}H`er 8 P(8 ;prueba HDDKc 'EOGVЇ&Memoria2ad*mp.l1@JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? Fampr)co0N gr0<1o?)<UOprim'quitec0g2) Pbm=, ESC=Ca06la==Acep u=SSNK1"Y, Co2	=Mi y p UyB$dchDha6@alP}  alem o apropiu=@[*<INTR'O> z qx:\N1n.Fs{3pkTY :@Esp~o o -> = PrxcRetrooces<-{0@aؼTAB S	S'aMa/ys+#C(/`F2!-910 `rXŠ"b"uErr06F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bhay nunw>эqubDRnY2@AC1+>b1 r(Rp[corUD)JН@ebook/MEU?IX QP\2O`0ple0Vxitosa4e Fak T1ytil TisOp7,VclGpuWXTamauZ_0h (L1/L2Ocs FAAROM mil@cNmerD}ribvisUv@ j"6r g-l@y o!!
/#jI1l2n3p4 EtiqurAsIB2VeFK (ga`Woo.o3oopoi B	Esn!*J8T 5:Z$  ProbU%b}ssfactcXJ$ǔ =ll̿4Reo !0poX@1'	olnedi$l@z,
(CE|`oԜD"F%Ad :vH uir  eap. PreP#/, Wcq#scpYcuCA:'p, Uu  c lQas ' Ӣ,hp9tegAң
pS^@vlQI$\e'vaPa)00٠o(a) 8!@%c	6Za?`gnޗ,od ilO(g)-~:1 (Rp=);2 (CwF3 (S.M.A.R.T.) Clcuvtie&ej 2( ?s): 300go B0	%&~Db EaH0 _`ipaulGirumq
د : s,pu 10 qIQ{`3nh7S_ervof 4>4apoya atrib0: IDp#@eaxs G
X0YA`seaـKHnue!vL@)Df ApagE6 ndq9S@gODB".X		@e voc"	k"alpa 
0 1Lstnad ;` fRn"]e0#թ9 A*# \A<Q,` (02o,vA`Ơbs (R6% E  WciR|(LLB ̠hrpinR3 SBf_ olı9al ol`X#A!Yvu	jvip.AqoQ  '{Ùv?%(֠WapaAuydAn14n HPc_tTool@O)%!!&  QuickLockSuspe=n Blo`^Թ\rat S 6""t mej`eO݀@`?:0d++-y	(BI	( !)((rALlRt0,"D,0Xj&upizQ,a.`xHOre' Pun<P+rojo%q>!lWS9MIGCD-(
Eec%'WPi:XUsio:Mpu;Nmedi<riveA'0 tzUSUARIO2I PRINCIPALьjoe c&s UaJmanT p w. Anp2 y gu # lug3bP  p_jzQ.p-%H @d \WcGS1
!Qbb;vaY p=O(mc}7`PJ67EБor@1ܯ?b9
 4: @G:iR u(?s  ,/ fs`m1$  RhArQOoc,G" o~ /]y"<:Xou d/aap{sRcu42bRt£B! ?1 #zda$kosaՇg\ а6Se 0wo0enf 8d8 lic㡖Ӣ@reaz. ?k дu"`#PZҝ4=ԬainO} acj`TBBfi t@8Z`
`ri0<1pons2`>敩Y_, i0҅ ESC. BP^1alab'Fd'  ,F10@:l(FRrfG @ǋ7cT/Espaol OӗtMultiBaNQPna DiPsi`$3-pA ;]SdfbԢco+d(iz"a(@jech@-5 cB b a001ЇpSuw9krZipcpmeaaeTer. Jo C`5t5 `x S5O vNo0 DPƀCAsO Fn/`T@ncIngls (EE.UU.)s (cmSo}"leA$1nt!Ac@ GC0eo Mod"y!?  Bidi0 Tam&me!mpIׁi#	3si0fu0Ǌ{ BP޳ICA RՀk*WLANy{-Bluetooth IA zQyİyQho<вergRs؈GCpoosb3B_-PF8(s)ior)Ethet, N0boo S& 1/,2/L3/TokR @bOO`P23 IPtifd Exclus`pᑅAJa@4`   !,a*C~d`*-NX0S#ӏoATr)3Vh!,o	o	Pk	o	h	s0bh n	o	o	ehao	o	 o	ao	o	%MEU 6}o	.o	o	o	o	Ubo	@o	o	o	B8[n 1 :rgR9. c% ] /{Am2 c@4-Clē3	0@k",'* r 9ODJ)o!Ѥoh ~aБAbbl"ۑ @z>Arran@pٓc#uXDᎰ0gEx!`F12QTAmbTouchPad`u.o N`ubNaưub  <F1=Aj/uda>roInfoȇwsobo Sd E@i?5m!DbβIМR!0
r t@7<padr0
3r  Ign`air@A	sPs '&_A.1nanJ4aPO(aDr% &U'_`# Ɠb!X_d#!

SPtSd!܂υ8liz/p@ʉO
(I 0!ԇs@/R Q*?8g%Ϡbr
Gaut<nT 4dcЬeaQlha@o`Ma (QFeOmPasg1=iCP8$f!leRߠOpT`HDD A1)r  VR#Le Mem@A<x 4tatu S`MuW^Gp[⩨ Av82S%,io Qa^d; camppJcinz"o?CA9`esse )qlr wcи'Otinug=' SC=CelaAce imNK!S, Q%ou=Maikg Ut	i0: sC	qqn'	da o i~  aprop@w *u@Tt#<ENTER> t5meRez[@o.Tgu@n9 N^r ub:  ->
PAO = PrxiK\<-QBACKCExapQE06TABo$SHIFT+C%* F!2 	*:`=kSC# 9nErrrOA@Q@na0WoQpڃmRHE. CdigTGo 017  NPhG`,`:o `+) L s@ viK=CA A	bMev
;nsf`ZWotebook/C[ (RWS mGsTe2_DKKXqmBm xGitonN  Ti0Hۀ3
VpcS_\\ Tahcache (L1/L2੦FX a` ROM FamlY  N9 3sri
RevisSvde@̠_aJro QLa
Al! D	Ob a(34`Rtiep	JIOeu6(]){  7on)oo0.Oo$alS~ƕSecunda'$  1rcC% vfoi"gv@!0mO al  ޾Walk  )0e g1i	oa lien!M!oc0I@Adve7rt: 0[Aqo vae!!djWcqP/,!i@um  grOavvuu:e)EӎA:S n@Adc NS3 >B^hO!QtegiEa	c]
vl0Iy袧I= kT@ctez0eja $,Ca? iN >?ý~1 (Rp b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`хѡ0@CT =4Q0%?1$bucedeA,xqAhostDCrom1
:; Iss-@P$Eg
Ch``ƫ(*erPmec ` `6Q3sM tribߒLD`AМexaa@s wQUUig:Tgrg`alPSL
s   qL rB+ۤiPArrfDig'cis gҐSAdP)PPЉxacmod!CsާBx! fazA@ArEr@Ca,Πer< dform!r3Dn,Pja0.@eHCysHfbrcausadQearF. Tb Z Q[ea 㷑2krvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%` mabnb1
IY @k,$$al#.20P4sa eMiSib0RP}useu sEExigU`r	e*PbM0Q+ <&perme@$1lp즅+!GCD-"˯gGP$qme:PDusua: VocÈ@gp4@a0vr2utzoo>Drive& t@$RUSURIOBG@ESTRE_F SC%ɑ7q<Vapaz8:@I. AaN84P@9de-ФrMisPJEB>p"}@. NNv p[֣'6Ve ,V`(_(K` 0+bu:l*Ƥa !Ede]D.Hf``7/{s1!Bi屧O7T>WDI AV
l`9w9o  sumǛE0f`lo,al Af Caa_erf
a`uu zoTH :aq(˂40  Àoqur<ǵxD@FkgڲU yaf0T y 2y, p;) F `3Bor ncal|p`a-t
A^ ˢtEsu=btud C{ ?@*h R)ppa۵ptA-lVJ/q rWL !8Z  Lembre ՚vqMa0c`Pasa8
"qui_se`R ESC]ŉ9Šq3l+av'f'<rF10. r`r:MrʷTAc]D ugus Op1k: MultibayQYNc`isi reAFp=Ba baФ/copld(RPX ditHzB	Rc"zipcPrimeir"rc* QtӂO]v@N Ղc@aqAs Fn/CtrlIngls /(E.UV `ыxS[hp1troahvdeAcund2 a@hMo#aGPadrBiXQTaPhBOmemOܸ"sem fubw>zóec10CA.#RPa 0RlmWLAN)` &Bl0oothkAn2πڐ(a/ Eomenerga  ere*agBC/"*1w62,2oo-'0suЁ/0vEt#net g	O p
/*3/CToken RingO OboId!fDPPPb 3araT, qUSt sP)SڼCbQGP_tgemNSrl1CsrNWDuwplo&	ted /	)	E/	f ONOOO'	as7AXjO/	kC/	cIAl Џ OO/	Opjb{MEU/	/	-/	G9D q	/	/	/	O6[ Etp {1:rreg9. З% ]@Ojc3l 2:cvN3:M* 
 o9ayCJm*O"(sflex	 QSc`xrydapR쇕 i3Pop;up޴ Exǐp ~F12( "ߢ d>QZs Varava Nu`Ti k yktukP  <F1=Ohje>PaJrj`PtQt Nytt[ v0`tu kP Tallenna levykkee !dk@oUnoPPuVtF?Fo0ej'nsW Oh mutpA lopQ4YLr  ttt7fTpou@au=rlisuinvojan ssaPMritoKynyk. La tyl	
 P usnumep
o$-
t Wlykiu '
,(oPn-u kiG
/!(et F0.Dt13!fsxBg5*tehd 6OG" t!"$j;A)ma`*in Ty_kalu`A:$ oK < Ki3vyt?OA9 @ap6( Mu DOk"@ a6nɀD;m@.DHILishieliOIk aec  ha
rll10p> H3gQO3'SB3x$*3&Jatksinjot  npppA^=d, ESC=Per G=Hyvksy=Kyll΃Ei N, OJokuL= UYa` fnuoli
mip_kd b`h%@
sidsN <ENTER> m@t
ep,.I Lgn C0ss seuraavvU:A ->PYi VLINPPIN =|[s  <-bASKELPAL7AUTEdf"2x!ARKA+!hTVAIHTO+', Fa2@
)_!~=  we@!<virh`wAkkoua e=oi`΅?da.?: |Rvdi 01*kac1pt~ a0IrtPTm ypVeytke`"6ko>@	siPpRlaks`qpss,X` kaCtqlaa@Q@_TikkI)>skeytyi Fn
iP(0P2nL_ohecaGm"|j}~1?i e~B tyyppiIn :gapll!VlisQ ?(L1/L2U~A  ROM-Spb@nkohA	tuotepe"ɠsarr|W@^`si ?stohjab T;{	!1:$"#2o L3o`Ma4mJ`LtaAIon7(j \oa)



\	\J䑷kA'ra- DqACu$#:BD$ 9a9%dz| lpi!iEepoӟi Walki?ng 0 -[1Yloso Vaihtoe@ :Puvi7a us: Tm'lAat0nhp Γ. Jplt luo`ŕpuos-  n,ҎirjRonc!KA: L"X AYhkФuVV3 beFAG8p_Cpa 
4Hkoa]Wi !`zn?  ԲԌ`  H?4,i`%(N92R`3p.M.A.R.T.Arp$[n (min): s30s p2y0%cL dv0 gIspysAi- 4iVgR
{fb%un!tq'c{K)jServomoo3ttj
Lu!5ÂLvtuQj	}k@FttribPti2 ЗŽLy@a 6eqKxe nGG9 UuVahvu x 	P>Ȕ! PCda}A"+2 s@a	,-@ãPAJ!꠴n4-okkpDBad`5an 	nDP -e@7p$Rmys@ba
`k"h@` $ЁeT@ 	dE	ZEY2i0Xj [!K un"Qnawby:찙p\veapahtum"b@^Cid FLaJ4ftii l <HP PrpctTools`cuQ`Pger -apu(Д큶.f(-/U i` n QuickLock8fa hlu5qf,V "@PraZ&-Q,:*sekm #o$j$Ait)a{d||}yh' P P`0#UC.7>Cuu	SApor InfrPnRp% CD- -!fl~QԌV"s łP1ANjUWAiot;"nn+ De"(1o")Jlla.    KYTTJNI9! PS~SANAN,0IBfw.la"q %si3ly1Mgur R76qg  gri^Pf aZꀝt]r
Hf$VV-EU,Ap  iwLLAQ0<ѨWZ& OAMAJ  Qops ) V suE=:d,#tu@>x	_4 `o'l N
E U 7lEr
pRw%y iC. Nyky3b`+mPezsAv6Ar
t p N. TmttS`|q$دihvei<p=uperRU$<eh? IPa* ?-@l@w p[tЋHta1U]=c zAojAaieamlV|tp. Anm "P$PtTV@UG.2!` ZX2qїaF_Qy#А ekrm@o#\Xd,aT0ESC-n"sR;nQ,%'e'x> F100 ŴY4aaqw
:	o .cVQ llQݠtcmiA$ys u"bn Mult7iBa@Opc&xJlakoiu (enA/$oiP) USB$@)ZipEnsimm AKoeljM }Vi@}Kieit@Ka0k Y Kymὁai Fn/Ctrl"mhAEng(USA@UsPs#inla!ǁB-Rs$ఠS Rn1 jPBsi PPs Volh̙t\Vakio0s2sN`b#IguuQH Dpl verkko
WLAN-ro'Blu`Vo+th @/HEB@h^@s2V@Qs s`9Al@@Ǝ|+1`Ai<9.2v+-p	+ (ylosp*OG C|Or5EtherPn1E Yoedo3o8To@ p#gOo(@work Q#%GlH1liv3 AkkuR < TAJq `0ѿ rjoolibr@du c`d Wual^-OO O@I OK"kb_ OO O  ONrO$ O$O$tva_ O1  O1 OMЩaanusBk OD OOOM" OOOO
OI[ e`i:r
ada n y. Э% ] ` ODPW21l ur00 &OE-O
3
FGoMOH*  j  ,9 ƠȰBk 1vuCP` ɐiư  (se nA@S`y: F12:ʴi@P%3tappikoskePPP 'mmaK  Ei mn Configurati3ordPteur  <F1=Ap> Fichier Infoar m Aff age Sauvegarder su?r disqdc R@a*r /'une.Hh_DHeals dfaupow du'Igno%mod1i Tpqu S$e l'in`p$@@reg om	\ ScuOrita%
e ssLdS"#j@e sous te Ion.D
 priphP %J	a s0EIDyi'As
Dr ;Lockq
Smp(C0 Br13r3  'h9eP5  ,
b#a <ۂgre taR,)+5p7am''us3;),;rfrencMi =``t"#Ou@[< !@lonnLb`beriZ slecqSnE@psQs AIATA BFoV,mmoir`hcBDX C0ZZaFXB_V A0c`oLang4 ChoisPJ Ul3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppsuyDfatouq#po@gezu@l v=Ser, ECHAP=AlHAccep S0=OKuiuN*#Q3V, N'impp_e``D
=0aNw  UPzin3
s f'heM
mo!04ecl{e hmenuucer@r0wbrAi2qh@z!y <ENTREE>2nj+W	ss	sui@/ffa  !/ :-> ou BARRE ESPACE = PBe`-$IEpreceqd@STAB`CA*'MAJ+ix F2=1 p"w-$!S( rr`@P<TJ Il FA%ss#ibcQ7L U cs'Jprod{endxp#B$P. Coa<-'401c5CntP@-1 emplace(L' D SaQre@}C'y
GJ 
s}^ccueil dн# "4 itaxsmo#bia``
W 
u@` B!OOOF2BfCX+)a ru Fa0;cq0M<\ Typ0
osBVpwgDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numro#p	Rsev`cdo serS2ItrQclavpoLA}ud@;n+/Zp/zr3/t4n"3inv!/Qzi&5 #priтF!L( Ute)OOoOOOBV'edA Eo YMT֍ :$/t.   %6Er4 !SUPc;Walking 0t81lig''ad`auZC	od  al0ifAtip1SC[a=re@ptruA ieЪvPR! /簹r,  z{ nro°Ac	cY0]A}
jDL_v
 tro Pa
s
TX	  _[Rvja"`dH.On m:YfPS 0"Ӏ1f   +-vahPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (c]oet)u`값|pimA(z) B30堿ss pAU0% n#v$D9ʈl'hA+bF  `:˗	AhsGinpnud'+,`v`t
$.Lu( HpG3p 5A`ib!O: IDP00@"s S.M.A.R.TAbcanG2WpW AIxBY`se N!=apYeAÐ?/@;sa#A Mar uinKS;A, eecoac	;mme, vK*ad11P6OobPbatCs	eSd4D	΋ pe>a1a`(`ih sL4[,p@s  `Ug"?  formQg-Ahq#xѼsJ
.)rmQފb	hJU0`
1HAJ.6zT"`QDP~aR avoupR!AfrCw w7A^	 	zYR`($p"}ffQfd  k;l2ӄTcgNq`rHP P`o Tool:eRy MaJr O4K8CF!/  QuickLockUsusA|`$cp!ri 9d س<S&ol'S+,C)re!cB !
`K)!nk:,   v qi4//  / LA'(a'a
S$ud!rv
 KP
dra+D hn 4`ExiAudP `  4r1aQ8llƙxۗX CD-'EǞVpalJX
¡:!5pr5Sfe DriveA). SS@@@Adez deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z?I`! @~`E"Q!qhsr @+lfe</"celu&M<sDordi`Bb. AW 	z(@oDNU(Co cn U@fet#qxI+}MH"+t"~"asW"qmoeP:! :""t qD)<Z=Ianiq4 5#'Oǅ#!2/7r,"c̓X!pk!  3P@ߍIX!! ܐ!!{e ZQM7pj]%uelП 21`̰܂TC :H,g" "$"o }a8k E
O' fW'!b_^w# ,d'oroiginIl2!v`O"2CwIa B	u
vqSaPAQy9)Pt0M`
5Odjabvp!s{s`Pze*-$݁WQa0prs 0`Ta a?on: top@TP 2a344Z0pab0yt3ץk'
1uj, appuy
`  ECHAP. @@ OTzR'o', 'pui`CrDF10 Tap Xc1xCx Y^u}	U:/QFrana
OgvACJiMultiBayulBphA 1!3D,xsoca%(ga)OOFRz) U[8V USBfQr
jZiprP: EDhi@s QuaQCin`NSixi sSe ߑ  Hud^ NeuvCD`^Perm/r(s Fn/Ctrl`s AnglpSA) P$opm1`s A@stanlPhnROd'fad`n el!ɯtrl3' Ui3ch1uer&mr`
*d :i@7idoAѫa˭Bid`Ԃ 0 mmVl@jEK!cal  R o!=ril WLAN (rseil)AggrBlooth7S/?1   ;o`! g`N Wloc 9G ``@!WnX-b61a
bP-n o8)2ooypu9	3ccujod4ogB Ep!1t  1a"23To=kRingo oU/IduT6*ao aX  /     h( ll` n!Hre0/ x Ab!AC.!f*Duph* /)///tb/// //**-///Jngn$, /0,/ /e s` BtexЯsqbmoP/ /7/// ,///7[qRpe 1 : Char. % ]A. j 2D` GicM*n3@	Rkio.
1* T  @ @/M.$oOAg$Á4_Amor1cFe"5 RetardBTexpx `) Dг:a  F12tWposf[iP+Aux  PatqbAKw ?ucun I@z!Nl1 <_F1=Ai0>`nfo0gema	l p'Salval floppy%pAPttoRiprPina dmThifapĠ`i Ig'nor`daed esci 9EP a
l'iI?z`cipBPtup λiczza sswo!%e am< C0rato gPcc sP
_QC*vos7v% IDs
Ҥ&gDriveLock	Prt`ǃ)S t C7 Sup;  c30 gDHQg/ o+:,i? fabbrP
p4=i	/.nzi[Ocov
rui Cb5<bae9E2`lrOpa@t2;o rig[idAtaA'Vâ,a mepTW͠`<HKhMiM;A>o !WAva=t Lu!O l$Diam"& q6ca X sso eviQ g	vv!'#o*62wH8Premi qsiasi:csXperQVu L  @i=f, ESC=Annu ,aA Etpoeo=SiSN1T,aoltro#	=A bj Us"SchiavI frGecc'!i1`vocu ap`=f"_`<INVIO>  \k\'e5.ipYguyi  un%: -> o SPAZIO =m xsuWss`0  <-pBACMKCE`c<\ؽTAB@C%o"MAIUScC+)XF2	>-= mp "AC"IErri<S0D  Qu A87npupvse@t"Vi  v@u4T|NXJ. C{'/01 Npu0F>9a0 Dogwgiao Lk`IP'0  Q>re0
4Es"@a'gga%FvpSAcғ  npabGook"RQzespajT:\ Zf.atp1_
28o{briuPrf uduA ND  Ti"+0<PSpVeloIStepp@YMis1ca~(L1/L2 td&dDbROMIamiglk N@@o0H`(	RP[3[oi#qSrocll TsjrAer@ ~i1OFk2m3n4 ࡐ7w PVSTe)DE(d)8
	2$
3
4摭Fonda
 ,o:EV$ Tr$%OupyP!gTŒ@l+liASprB:bit 0t 1ИRindirip	i ] `|@'FAЎso:5X%? gger `|v`pAhAre!0M/rѧ, p`1favi PP`iVYXA:'mU[A:"maconouAh(_ IISɁQrita] Nsv@dpRlIQOyളSe3 `voPga ?AFbb iQfre?0@?: Aɐ~51 (Rap)62 (Complet"2tio (): c30>0%Q05"r6ar0'hD5|:s*Щ-@ 
˱֤(aD୆%aerv |")LċAPLA'	ribv i0gol: ID$Ban`de@z قi S.M.?A.R.T.!ޱuT0U _wordc(nu1o!i2 pDsc(UAi%L?bq+d`ᗑ 0{â"Znd? ՛O.A7T1cq^B&
Am AV f!B;Y ECr	t>0J2fum y3CePe<B) #u _t0s!1a哰.Q] ՒbdFo!erdPКa;tiwEff+Jizso@in  ca2ivEvPgaζOpdesХ @Jm9Yy HP tectTools Od. ZRV2+ ickLock^spen`3B0p5EY mou`s8 MM d?#<#,p  gra@p'!oe -!e$C- ))v!pKCsm@]0x!! bb	,'URar i lі@NR(@|ГVr|a infraQ)p y)o CD-" Se$DFVp:W<!SRQ#3ęwusanD e1&. !D6AF<P @@b}W'UTENTEPRINCIPALE  r@*a man4fu`o. AnPV:Fc P0rо a!eQB<p0b:0.l@d0AuULTkZs,^h	Q[m2H sbR; 3#reDV\b.ALN = Q_o@0%54 dE h=>`@
 >re,@q  d (`8t ЋrOD r luogo DF T!B'    #h$ f@ ER#:,!v E</sI"I@5-"̿WpCl$v {s"k mP0!R/DaB   /$BH@xQE~ a( ٰa~DA'a BgQ#}QAi  	Pktat{fa+ u eY/cdO::ly&.2nPqu_{9!.Y)qA`YHEsnOP䮅@K1'56h,mP邆эo ESCȣƚM'Ý)doivQr 'n-'pom!nF10. !n !kKWyĴ_6\%גt qI:P(i 3  O"A:D0@ $d5m MiBay ba1.gga4s$Z) og耲Chi USB]$SukbC
ZipBP6o ;Terz `OЁvN% ec AН" Fn/Ctrl TIngl~  (USA) Yi u`2O 
mpl 01aЃR7Cpl Aaп` 0̰Mo@exQנ Bid0HCapa memqLX5embs"FlDQ2'c/wNPs (WLAN){oBluetooth>Commu5/ (j)@sm energ ZphT1$0&1 N*'2HB$*Ca6*(0@o)ol,sp 7Eth0etW% V123e Toke?n Ring OE3 IahbyC@PB@taI   aov  CP/b// TDzS^oo  YHiPDu PT /  o 6  / o ,o// ooba  c  /  o uY\mo9S// -oooo ų///oo[ PAs 1 : 
ro 9. @% ]ocomp#2S'4,n6E3`
@ij* 
 /JoXaX/3i'o
   Flo'ppybUAİIAdc`Ƭ@(sec.)C velpP`F12b 2z@aCmb`Nu up <F1=Hjlp>@rkiv Sy^a|infot 0s~ S Kpk%k݇igu @1( stll frnlа1n@ard Annu>aa nd`o ochsld  an ? Sker0 dPRtrsl9pD  K!qaOB@rt-OlaEn ss8	(b -ID
S ao
`tPd-Std frut8Q !av 7K
byggd X
 usBi=*abrikP+ .J
sbeh #DEsktsrktyg Km +r vڐ S`;vtܱ0HDD Ak_V Minnes:  $01q5`?@An'@#B
Q|  VljrD;cBnedttl D!v(C-j+eTryQI fri Dg@q nr du v9iJPst0x X=, ESC=AvbryNaF|DAccepqaF, V=Mer X JvI pil	c	,/pCa yEt
<RETUR> om6
YRtt .ie,l5j`SeerI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG FregÆeyK TABf#OKIFT+H& F2`+?z= 'fO @%Aoi?Cfel 3t gqL` kA@t h+AO` Dstod uGen. Felk01(97 AsgFx{P|plat  NtPhm krv3?A  @pbyg{m0 fly5s t6 -dator/r ex$(|>0Ytidigooi2-@kl`TTA UkN4,  Pr Pr, typ
hast^hg0Ca-	rlek (L1/L2)|Yd ROM,tum  familjrenummn0Ddeo,`r!Y ttNb ~pqyrQ!]8H 1.zI2#3$4qrbinvpX ˦3 (bZ)g	1[


Sek# xI rq.4$@gaxr#%Ex!z=osk!ŰvidC|lmissl l~.s Walk0s - ~P f1jH Ad=d0s li7Ae nV;ar! D@/ѹ  7neh g"Cc^uskapay ą/G-t!ڱxiƱ=k b!h$2AA:1R KL>#Rhi{wIBB?skydWdadag
@
   Eˎ҇A!^Ԉ  |? ig? D܇jGa-{ 1nabb8$f@րn`X9UWk`ad k$pQd (0): 30@npan 2?0%bX A40Pp/]pp01çvr kaItPo:,t	!قOk%S(x ervo
-LzB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ R4d% pm}vlika mǄ  'InE?kan orsa@3iЈP9aH0SsNypPO@Om=<as1A1lo. 'Na om hglmabtj@De=h ;else-D @^uQuayVqΦ >8fun 08`perl^7ž!i HP tectTools%٩R-6-Quicka"q`telge Lp׌mPs GHgk
gpBpb*_-  &q2@&!џ!!~r ngo"8pKF5bli`X!aot. Kж7AompHi p@1f   Pk`anCD-pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsdk D`}e. Ё.Ч#`a]r ANVSHUVUD!{@Pƶmaqt W.[ !q>`KՠρQ@ild fr0!+"A
 GOha0w L l1ր'lGSWN.(X (oF `XAd/bbygg05P0 !g`2///dY5- FbW&:omC eB
7(b!>=  0>Dq8asB1 GcgCZ@ktu0ai`XQafanpkp@.Fu9t!L#\tg`Rsp]Vo,sursprung_cJXJ. Vi  reko@ޡt2`F	B}c	Vrй`+,ps`_b@}. A`K 4ɡȤ˄3w_Bg  &Ӄg`!(g}AyO-befls}e qm ihxђflj1e{ns. Trp{  >ESC- QBSRV@w#`'Z]'R-sedMtaGF10@cVi3a:+dD1}shxE ASve a 1w: N?, MiBayCrut@!}opBP5vi Ba 0G (䠇Pr (h aSB G> Zip-=PW As1Fj!Б1 utto NtT VxPFn-/Ctrle  E@l=s(USAbmYkd !AA b`nrmsNtrorx+,<f hbbel>orlekhPeo2ne FlkpaLPaIfEsi]o"trqtK (WLAN)Bluetoooth p/() -v@A=NѾmbe/ Aggгs`haE%-21i,2v
[,p$Ned Et!h)& 0	3n To!|RQN"Unik '$<QiD  Z @tus      S"bo Kalibo d@p{  F:DualQ.O 
o 

 
 9
Fo 
E 
D0!j1s 
Aoo
Et
Htag  *o 
* ʯ
VCy emo l]A*5ooe
 DIOOKood
D?[Ne _ : Lapr . 0% ]
klar
2u j253om FjOF* &V@1 >I *O!DgOߧ8U«br@4sadap@$lg~ rdrjQ>snabb0 (sek. F1 Bd StyrPguen!he 0ae/ `P}Op e@slaan ConfiguPpoanaAfpv8t ardQX3!/  scy	~WijzigS%ne@" programma @|0Setup ; zr w  ؃9svei !Behee rswachtwo o1څ
 $X. Ap aatbOgl$$ ID's 	XSm4CP Lp Oau3(P$PcR%mj+%O
Ge0g3 gssvzie2؏"Fa?brieks.Cugz7/);Vref.s:nieuwB8ON{c  ExtOAccuwB ZeN geselec Ea  es  zelftGa -schijfeai`Act PX
vG0u?1 I R!a/ 4UBgDAcg@7n ,DP=%_
 Qw 9aKc!:6 alaal =r/em 	rijsgemaak el;o" /;9
8ukAZ ]0ayMLg]@f=S, ESC=Annul"EDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`geObrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
crƱ]beZo !vol%@@1  0aiX:  -> of SPATIEBALK =><-BACKCEVorigl)TABb	#EHIFT!+%%ܺ2+Kq= ykp=t#B~fouta64k p It w_ge15 F0M0reqatijas Een. AcoZ01(b`a0.i1ZCu  we   ?Netvoe are0#FMPNps diVbas`ep3
 t n0 notebook-pc/P @.istNOQbep*i#gdooh2L	MЛaft eNmpALyp6rocessnel3Q pp OmPЂP}e (L1/L2`Zapac?i VHaROMU @ -s!fS<mm E  sHebvrgav_>0ideokp&p;b bpM 	m	ra1bI2rd3e4ahisgIR t}.jne C(_B(ЉwMdzQ%)
  `D#SecuibE.aw~H~$FtDb%)҆2!dH U2L53HNac-0-*1Tho_adresrlafwisnd pao=LTop: zPtX<ts e';ge t PSBbeЉf  vs d1 A:o>g-  /ޖ‑"x0zbLep6`NoffaG1Y\f_dقڑD`ѱ

boචgAt
wOC'Wee nu duъ"
wil?oݩ"
"a?Ox
Zl"+1 (zb),2 (U0Y ) Аpqwrpn (min?.): 30aee&p:L0%Qtoo 4;q{ho:5GbroA):]eeqx/nb !$32#k'vo-IPsE I"
2"qk:J S.M.A?.R.T.-af@APP@udh "/Blo!  A I-7B4k XqcrlpSX8
 Vr!a1& is% bBsAYoCf#/k, Tm]lijk0UKQߛg zoikt` dvor s:ka?0QH fQeksKPugzet,br lorAZ@¶ZOb$ 	uswb sqwYyfur9houd'Hi`! AQ `R`T`R&BѴ4񡘾 vuaY|ߐHP Pr@ctTools(*@%/ k  p?gspp`b TWmE #M"g&$rgΠ9b   ~erX#W>,.o(h( o( S("7'EAJb"f k otraakP)5w sXbtK;?ݠ ]Qŉ p\1׀frapd  Parˊ Cd-r 7HN񸆆Hoofd8UGr@JD  UQ0w`fb/ia D1LC5!;i0zow)HOOFD-"RGEBRUIKERS^Kn  p"an< SSC  hbwACI .t fykgcompS$ajs LQ}ZP$t d0Bb&qӜ.  @XPpQ~^zAutompJc49	yT `r:ZcY<<|7t7 O!V)?!9NP sN! !. MoWdL ioNTC,p@  #iRS8p0̀QU nt@@Odq K/ # `hui,50d@wұwas sto/!k wggeaГ. PWVAnvlCoeC~Xkh(WSs0n@PHܩ׍zYUTr!ra=8	2
 torH/)К Bget.  /o
 s  vBn. Om2un@
1]ѝA&`3fe*p& gol 8q. Aܹ_ӱ_,cdtabҔh! Dcpㅻp3ruk3<!ESC- (A9 н0D2i Rb'k'tyUbkn F10@`T*ZlusTB rl`V4  Neplg g MultiBayj!Vzkd@\base (k3s)re  USB-Մ c`b+zp-3 ER we璑V V@{ZKes >Z>Aa8NFn/Ctrl `Owiss/@ާ`SStaMcW3MijsappOXU e 0 Bnгl\Bij V o-1PFA/A뜴0d`ditwion  G`vgp<uqVpilatE?Bvp neVd$Radioj WLAN-aoeBlueth/oG`rgieм@qYI1[,(b!)ۏ`3Et@0 1
2
3fTozRa/-OMo@m@023 UUrt0cu!G< 4us     SaGekali@!тOK "r2
NQc ualP\JO OO EWOOO[B ['OOO H{ap!ң
O$O"Lpier-MUE- $J$OC$P n+OO+O  [jp 1 ': Bo9. % ]A/&p[лd2knte~l/{	3	#Ʉ
foh l/)* Jt  ;>.C,$ VęçaxդXadap @Fpr(0sec.)Cpop-up bijW sno F12 )Kbb@ cursorytuyEasyPo-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF県Ăg&f 
H
gɁ  Ho׎ɞ 
E	ύXɏ_I  `AO̿Ԃܫ@ea L(eA`LCǗ҃p h/do'o "X yf@\̗L/?E%ID&ID: h (uN XBSA$͍폜eX} 0g J 23TÃ|OH	, v".eI*"%ɀ;FX
 ؖy>f
cA>oAe̒  I(Df:nA%e> pCeBIvCc"F@ `F  H D%Jc9J; ڍc R5BM NP$߂MA%E@U`UO tÃB!#sNu%.37($b74L[BR af=!AEsc=C@bsAS60=͂
ς  aRAg)gjq5\ 3gp] jkڂ %iA@ugp>[Ex]  eȳ#wA̘r_->Epy`tOo[ = {ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,10nm˔F/[%  !CG[  @DBCł}@BDrp o 01 OyN^F`+@~3a
ɂACϊOk ~ڑKv@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e`	ýуޯ     xݸ  ށiL1/L2"`OM OM̧Fرٔԍ  ޵ ޼ ް ۰ׂްޯ ްir ޯ#2.3N4h	 pŰϼch3(?Â)FE-3N4(J(kvJ _!nF2w XcopF?$qv sxП6!;L{sV+Walk#0s?A-1B/:Z hѢٓp^`OD4x:2BtƁAC %C颴 ׂĎDa/ŗp쳐AFA:݉ b#}#v!h F} FS Pl	NXW<M֎~@Yq Zos/9@y`(c  ֿB	H #ċ gOog '`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OOK z3 eBs~ f{:@	{ewm`Q1kT {ǂݨUfIFIDP.Ba"R`R AFfV!'/i` ¢k@ΡdAJg(B(a ͤDxAJhvB"߼ /  Ǘ߽@{R@rRVdNJǂ̂(*p4u΁`@Ȃ
aUC	d !]ţ"^
Y釠cxei!ݡ£	 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lW?ŒǉTBq #j,.qB4PУMmNu<%"T h8' k{-E`O'OHD&J8-.))Tی삪D<D%蕴` g4`dt!(!ϋNb8v"Q ԊO GPu CD-pu$(3XH\@}@K^ 7Q: axUK^ߑ #i C^"c.t%``y x7"	3@9>Ā+ VAT:@!eN,Bi	.	i Ap!!F	͎2R qĐR`s񽂩痣HS{Cۊ"o"F`pAF/'ưAefw`6W1E <@߰ XPۏ؊ԓ "łb͗L ił粗`ȨAk)/)%)!?xƈ UX3oNu"*fBBFa(o(e|~!@#$'m8`X ( ?IO)F) u
((?(9(㜨gDs}Dv#<43ɑƈ	{MS f=ɉeN|^`Fa)F1jj 8cB  BgBb{aӑOB%O #&H2ef̯"8먎q]l`ӔC aUC$/g'"w}EE[Esc]1 쉟`}ȍ~elaӫm⛡TN?DriveLock }t[F10Ba MS  y_97`E!: ESxtkGb~`ÓO xXioiEcUSB Xp H Zip1Ԗ 2a U3b 4 5"678B910 Fn/Ctrl%̐ؑ |`{`\p (USA}) `|*B#fo+X>
KV&Ws
v C\g @}ZJ@_z rIo`̢ W}o% тACY O͏o̧al"Ni!LANj%MdBl?uetoot/cj!`ߓd p
 2Intel  Execution Disable-@++1)2̏)++odhEthernketX 123 g! p
AOKO3O >H!O Dj' ID 4b`K AM      ϰ.`@f@ R?ke jZ o \(%(*nP/h/!!!MEUt$ )ozoooD2s!5bv1 : [?d . % ]O<k2 !gOv3		)$J*   5`$>s'pmj&vSpeedStep@ tech?nology
u('"( 	_Ħް Ӱ # px(b) 3F12Qԁiby Ta ^`PbZB  @d                                                                                                                                                                                                                                                         i  ` a b c d e f gt" L           	 
    ֑  
         6    (    .             @   / 0 $  3 4 b 5 6 ,  ( )   , -   * + w  mp
 N % u@.   mm $ + 1 8>E K RXm `@E<B߹B<U> FبE0`8l v x|v||p0p7c   c 0A ߐ  = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y $n%Ap E%  IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {=VROM+*'(

C$: |O  s+'()+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|mA  m^@  .@  bm@ ED @n.mL@@ I mpW  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 rdmxcmRa em?gWm@@p }< fm@eW{Xt|dU Zt}[}#L  ]~R&  W_t`$itVa!
	$
| 	 
`	
 `
`
fabcDdeDfPhf(>{&P_@    @܀
 j( 
( 
r l0 |n o : *R  	mQ$ $ 9 0
T VF10 Setup Image_SETUP  !D	Sq  ;S 	d% *v@Jäb"P Ta|` C6
&$`ԩC ت TԫTԪ*J<g!"$Dcz: 'ᴳ4㴴4崵d紶4D8b_ : (m
6  ($))$**$++$,,$--9 -g  0	>`
9 
E#8i3jG@ #!" #" #" 
/8 RMUNLNOO 8 @
: 	 
     * /	&WPv  b"    %    N''!(( )O)P*Q*R+S+T,U,V-W-X.3V
md-dh.h1dii2dj3j6dk;kdlIlYdm@mCdnDnJdoEFdpGpHdq5 ajmfoq$HrڤHs $[bT{̠{`{|U`|$|`|`}U}{L`}8}UB}. ~X`~tYu wxЪ~*z{  }H kv 
G4C(3
QI] bxo4UtD\$` $RPNG\@;U44U 
釤d3 @9 Tgxt\ƙLR@ \ Ub v @ LU@ @ X z U@ }@L@ U. H T j@U~ ( ̀ WL8@ R r U @ @LU,@ L `  U@ @T@ B Z t U@ @LU:@ ^ j  ծ@̀WL2@ T f Ո @T@ V z  @ 	L@ & : N Z@dp @ @
߫L*@ B V n @ª @L @ @ `  @  @ @ `  @ 
C  . J@bv @ L@ < ^ ~ @j J@ H \ z@U ր@LU$@ 4 L ` U@ M@%@ > UT h @U @S@  " U& *@.6UP h@5 @$ -@ Ud   @_L0@ Z U  @Ȁ @T ,@ Z   M@@1@ 4 UB P ^@fUr~ @ժ @T6@ N x  @LUD@ ^   @B p @̀8@ f   @7@ Z   @RC@   պ @T@,@  0 F UZ@x U@ U@ M@ @H@  U  .@8U@F `@tU @U @ĀU @-
@>@:@ J6 R r@ @䚀 )@ F ^ v @ @!@,@ H l j @"@U@ n   @# 5@ j j  @$R@ f   @%@W@ L b  @2 AB&@T@ U> N ` r@A1 @ʪ @'L@ 
   @$A2 4U8<@V \@fv`hU| @e (d@ p   @)A@ J `  @j @*W@ H ^  j@Ā+]@ Z   @,@[@ > d t @ @ -@r@   0 N ^@|̚ @.f@ B P V @ʚ/f@ hj   0iR@ r A	 @S1@W@ ~  S2R@ d x @j @3h@ 8 D Z j@ @ 4]@ ( @ Z t@ @5 k@ hhhhAT@@VUp @  6"$ F f @ 7}@ XT % @؀M8 f@ J Ud @e @h9@ l ~  @
:@ 6 J z @̪ @;@m@ . 2 6 :@@Jh @ <@ d   @(=@ j   >@mR@ 4 h^@zբ @?T @    @@@ hB Z t@ @
A@ N v j @ B@ t   C@ z   D@    E @ zj   F@    G@n@ z   @H@ fT hr @ժ @IT{@ D T b Ut@x| U@ U@ U@Ȁ SJ@@ > H 
hV hvh@h  K@@ 	hJ@vh ̚@L@v@ p   @M@    @NW@   4O j@   $P@  ܦ  Q@@  ئ R@  ̚  S@ ^   @LAB T@ B ER ~ hA1 @h@hh&Uh
hF@Xh^@fx @ @ V@@ : b ~ @ W@ N t  @ 
X@ UD d x@5 Y@ UV b v @մ ZT@ P Z ` n j@ڀ [ ֪@ R l | @ @"\@ Z   @]@@ ` r j @^@ l   ج@_   4 D@`x @j @ ` Ӫ@ , B X l@~ @̀ a@@ hhhAT(@JdU~ @Q "b Ȫ@ f   j@܀c%U8 P d t@U @M d@@ 2 F b@ @Ie@@ * : UP@ U@ @h f @ H ~ j @g @ j   )h @ 2 V Х@@ꦀ
i J@ H |j  @jؒ@ . < JVd ~@ @k@@ b   @lT@ Z   @m @ b   @n@ j  ƚ @$o@ j   pF@ Z   ښ@q@@ \ f z @r@ ( 4 < B@JRX `@hpJx @hU @̀sv@  
 $6@> U\ @t8@ 	,R@Hd |@U @Mu @ < `  @vԀF@   wԀ@   (x @   &y@   .z@2@   8{TK@ x   5@|@@ ABJ \ n@~A1؀F} @ 8 Dh\Dh~)Ж@~U @ʀ@~*@ B b x @ĚN@ J `  @ @&@G@ d x  @Ȁ @ N n R @h M@* *@ R Uf  @U @S@=@ F d Uz @ @T @ H h  լ@ր@S@ ^  hj@IJ@ z  h@j T*@ ( @ V hMd| F@ @T e@ 8 N h U@ i@hh@hh	hA U(@>Lb Ut@ j"؀6@ b   @h%@@@ < `  @ Z@h U8 ^@lU @ʀ5 @@@ Uf x  @Jh A hh@Ҁr@ X   @R@ f   @]@ F n | @ʚ  D@ \   @ʀ h@ * h> L@\ ئ@@}@ ^   @ @ ^   @@b@ b   @* @ ~   @ l   @f@ ^  j @@  2 N ^@z *@ j hhhhT@*0 >@%Pbhz
IМ@Ф о@ @ P j Ђ@  7@ > \ z @ M@ L t  @ @@ h   @(@    $@    @ xj   @ : b  @Ā	h
@ : 	hX| hhБDhh@h
Q@ h >@UJRj @դ T@ r   5@@O@ UH ^ ~ @5 @ D \ @j @@ V ~  j@ƀ@j@ > v  @Ȁ @ @ L f  @Ҁ@ < J P ~@Ԛ @ \ ~  @䦀@@ @ j  @@*@ Z   ؀ T@ B f | U@ M@@ ^ U~  @S@ T z ՠ @
 @ hhhA4@Rl @ƀ .@ p   @@ R  j @@@ H l  @ @@@ & : P ~@  @ T n @ @@ < H P X@&f r@j @ V   ֦@@    @ @ d |@j Ъ@ z   @T@ D ` l Ղ@ T @ \   M@@ ~ Պ  @T @ l   M@"?@  5   @@ UJ t  @ S@@ n  ն @(T@ d   Ѐ @ l   @ M@   & ,@4<D L@fnv @* @
h@@ & h4T@P x@5  @ 	P@zj @@@ f   Z@ހh: Uf  @S4ˀ@   M (@:@  5  ( .@ Ռ   "T@/@ v   5@@ F ABf x@ A1j @, hhXDhhUt@ @д ܚ@ @@ 8 X x @j &Ҁ@ j t  @  @ Z n R @A S @ J r U @S@8@ L v U @Ȁ g @H@   B Z ~@ hר@@ hL R |@ ؀U@ V v j @ ,@ @ n  @ 2@ j  h @@@ 2 B ^ p@֚ @@@ N r  @ঀ H@ R ~  hhhШ@Āަ ހ@ 4 J ` @  >@ 8 X j @@@ PT A%^ @U  S@@ : P Uf @M @I@ ^ Uv  @րM @ @ UL b l@tU~ @՚ @
T @ L t  @ C@ *   @У @ h8 N@x @A@ t *  @Āh5 @@r@ U0 > P ~@5逦@ Uj   @S$Z@ z  M @\@ j Մ  @TY@ F r  5@$@}@ Ղ   ,T@M@    S s@ N r  hښ @d@ f ht hh@h@ j T@ < Z d p@
Ѐ$ ЮhʁS@@ h   h @ j  j @
􀙪@ R p  2@؀ ;@ Ud   @S$@@   M @ t 5  @ Ul   @S"@ \  բ @ހ CB 2 R bB@zA1h% hh& h
h8@hI\k j@rU @5 @  @ U4 F l @5 @ U0 V j @U @
@ 8 ^ @ޚ @Q@ ^ h z @  \@ : R ^ l@r @ ݫ\$@ > V p @ @ݫ\0@ F n j @@ d v  @̀\@@ v    @ W\@ . D UX f@U @_"\8@ N Ud z @ @W\*@ J \ f hhhAp @*  
@ 8 "^ @ @ 	\@ @ \ %~@ @րQ
 @  0 H UX@hx ծ@ހ
W\&@ H ` Uv @M  @ 2 U@ X h@vU @բ @
W\4@ R ~ լ @,T (@    }@\(@ < b@zj @@ v   ښ@ -  * B X@`n @Κ@+@ l   @$@ P x j @ (@ t   @$\T@ j   @7@ h   ,\L@ |   '@ PJ j  ШU @S@9@ N \ STI U@zU @U @ @TA@ * H ^ l@z
h @h ƔAQAC@ @R R j@5 
@"@ UZ   @M9@ v 5  M@׀S4@   S8@   @ @M@  !@C@   "Ԁ1@   #T@@    S$F@ T   
̀d>dN e`@ehA1@%P@ @ hjDhU @iހh &:@  * J d@ 
'5@ b  Ȧ  (@@@ & P r @ )@B@ N b  @ޚ*@e@ \   @+@a@ N x  @ʀ ,\ Ȁ 6 P\p@ @-@H@ F t  @ .:@ ^ j  @/ G@ ^   Ҧ@0j@ |   1e@ nT  @U @S
2 @   < UL n@5 @3P@ UR p  @5ր4@m@ V j hhhШA~ @΀ I5_@ L "j Ֆ@6T@X@ N r  5@7@U@ Uf    8, Xj n ~@L @9>@ J b | @ :@z@ > T v @ @j @2;E@ v   < @ |   "= g@ j   @h>T@@ ` r  M@0?@  U  @h @ @ &  i: T@t 
A@r@ hj    B @ l   @$C@@    Dd@ |j    E@ V   @F@@  Ț  (G@    @(QHl@ b x ՚@I @ P f v@ @ Ȫ@Ҁ @J@  B j @T
Ю hƀ@ A K{@ r  4 hހL@@ U`   @5M@@ UX r  @MҀN@@  5  2O@ 5  &P@ 5@ ؀ Q@ Պ   <R@   &ST@ d z  պ@ЀTCB. P r @ eA1@FU@D@ . DhNDhfU @ж @\ܚ V@ T j  @䦀 W@ N t ~ @Āܦ X^@ > J d x@ @Y @ Z ~  @
Z @ L n  @Ȁ [\@ & Z l @j \ @ : J p |j@\@Ц@$]@@ Z   @^@@ J t  @_@   
`@`@ 6 L X j@z @Ȫ @
a @ P f  @ b@@ T t  @ڀchhh	AT 6@ZUx @ЀMd@ R Uv  @Se@ F l  @Ѐ f @ 6 R f |@  @hgT @ J X r U@ Sh@@ F d U @ @iL@ &  U>@\ M@j@ b Պ  @2kT@ t  @e@րl@ L ^  Ц@
m@ x *  @ƀ @nT@ $ 6 d Ռ@oT@@ t   S p @ V  5 @q @ z   rT@M@ r   S s@@ `  M  t@  5@ Ԁ u @ Un |  @v U( F l@g @̀ @߿LL @w@@  ( 2 <@Jn @A к h$A hS,x@@ z   Ԁ "y @ \ z  @րz@@ J d  u@{@@   (| N@   <i} Q@ Ā 
~#j@   j@   .@    @ @ Z xT AB@M hA1B N b@И@hдDh LV  U& ,@>VUh @M @ T Ut  @5  @ U2 < R f@@䚀@5@ V r  @bYL @@ L ` ~ LTД @Ā5  3@ 5T n l[ @_܃L 5@$@B@ U\   @S"@   5 @$b@ Up   @^L*@ L ^ n@ @Ȫ @UC 4 L d U|@ 5@y@ A`LB ahhhATTA f@U @ڀ@ "> b @ޚ @@@ 8 %Z v   U* H Z j@Ѐ j@؀@Y@ F T d pj@f\j@uj@ 6;GeL"*D `@К @@ h   @I@@ N hz @и @ @@ \   @Z  U* 8 L@RUbp @5 & @ Uh   @Mڀ@ Z Հ  @T@@ R |  5@@ n  A@ @   Κ @&@ p*   @ @T@ J f  Mr@TI( }@BrLUR @U @̀5 @@ }" 6JL>@ /zL
>IZ hhh~Т @@ F ^ v@ @ q@ R r  @΀@    ,@@   @ j   * )j@   
Ϊ@ ~   ( @ b x  @̀
UCB* < L E\@hA1@  h
"DhBPV b@jTB R@pUx @5 @@ Uf   @Sk@ 0 R Ud @ @T@ X r  5@ހ@ UT |  @5@ UP |  @UĀ @St@ 6 F Ub @5 @@@ U$ H p @5Ȁ@ UJ h  @5 @ Un   @@@ ` t ~@ @@ 8 \ z @ @@ \   @ޚ@ 8  hhhAUDf @մ @ "N r @ &@@@ h %U @  0 \ p@4 h@@ UL d  @U @S0 @ r  U @̀ @h @@ p   @@ p  ֦ @@ B jT Ж@5 @@ UF   @S@ t   @д @6T@@ < f  5@܀ @ UZ   @S0@ x  M @ l ͘ @T@ ~   S@ d  M @6@ t 5   @ H n  ЮzqLJ@@ 6 UB  T@bUjr x@U @i @̀ؚ  @ >J F L 
Z@%r|Ќi@A  J@ B X Ѐr 4 LT@@ D f  զ@ĀT @ T x  5@@ U`   @M$π@ r ՘  @T @ Z   5@(@ v   AB&@ (D &A1T cJA@h hDhh}ЀXUL\@@  * 6 @@Np @ЀԀ@ H ^  @ @ < X n @F 
 A @N Ur @5 @@@ U, < Z @U @S @ ( X Un @M  @ 4 UN h ~@U @S@ H j Ռ @܀$T m@ h t  5@ڀ
@ Ur   @Ù @M@ ( U2 : B@TUbz @U @Mހ@ 8 UJ \ n@ hhhШA @0@ @ `J  @"M  @ l U  @+"%H h A%@% L@%m@ P Ul  @վ @T C@ N b x U@ S@ $ 6 UN T@Z`Uf l@tz՞ @ I@ \  @M6@  զ  @
T@@ T d v U@ S,C@   U @h a@ . B H \@pJ@ ΀ S\  ֦ @ v j  @*퀠J@   @@S@@   1 ABB +@ Un   @S*@   M  @ R U` j 0Ђ @
@ . 4 : @@FLR X@^dl ~@ @ԀZ 
h@%.4h<hR@AQt *@Ai@ UB \  @վ T@ Z ~  վ@ހ$T@@ ~   Sd@ ^  5 @ P@ Uj   @S@ v  5 @ w@ UT x  @eҀAB Q@ 2 D X lT@A1 @̀@hDh {@ :ʀ H b h$PnPm/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Ts# hNfP u	fX@  h ^UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"f,  ,fUvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:tw'_^
QRfU

}0tCR>tK-tE$fu
0t0t	dpQ  f]ZYPSRi u-Rr-&-sG tu0< 0
Ag'fA$. +"(zwZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	P#X,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>8A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _u,# XA	u-->1&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7ӥi({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/	` 	R
~>  6P ې  f8=hG+( 3Q h  f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\KuO@S1y?"w5`,=KuZO苆FFKu FQ$-$G^f ? @s++g^D	%ÉD	f8Ƨ2+f<v PfU IfPIfffa$f6f> f	>fBf@)ff]Xo t *̠N9ԁf_x@R@Ӄf;3 ZpbЃ> t50 A0*@@!p0 U
@ҟWRV6H 8f;tff ' F?#4?/$u qcf gfmEˀ>  fù fQ@;t)ogf+ C k#@`CW`Lk Ѣ}GÿGPV0w  ^h0 ;u}; ?;b4P4SXf.0Xa0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6Tg  z	Ad  !
؂  	 0 ! #n#   ˀ  _ " 2 r	 .>  B
   ,1         K   S
+`,&,A!Bru
7>, o  >  t,,,>,,uǾ ,"_< tC2`r,_Bb,,,,gQ	`PVB`
e3ۊ؀`,&~-,;-g3 M,pVS`@t	Vm,[^PQVߠ,0ӊ"@ӈ9,1,Wf u5uqyS1-,߾5,,-[^@sfU_>
-S>->-G&-t(
ߠ,bވ',%,=[QpQxVt>,, r1,w%y0r ",60}S,  gm6bdhETe!)) `!Q	pDt1,8h[R-?r-&-w, a-PRVqp!)7p	* 3:  , &},g&&@v@ '1&s0 ,i>,y $3P߶ % u> &j
'
u$uvatue&u^\uMu:w
8FPu)wttfpF
= IL^1X@8! u?	g&AFtF@s|S,X[0|SRV#+WC^/'ۊ»
1>qZڢ,A,I,Q,Y,a,i,2.RtvM,AW>pI,SRA<v
T-,-@,ʀ 7,G^&r )&uHIS	
I",,,:,w/=,!g
	߄cdx
	,rg&5tU,x}r],_dr!"E,FKr
 Jt x Ztĳe,=2oxL13
	upePaD$[Xހ[Zd,_@[Î@[,_1<ѿN &>luBSQ -f3fÇ2̓A,fлf3 =0^]-dF E *  <Fu-3t	 Dt<Hut25t5 y2$u tPX- }- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2rt5>s5oAbqurY(q#VWpptAQ ft(PǴ:-Ou 
  gXfCYv q9~ w2-k}-0t&-^8r ۀ>tw
$_ ,-9-2 ,f? t<C<tSQذ&Y[0u
~lq.u     	`h 9W0  q8r8 !^ !;   ([[\.Z:;BB^RSTT::; UWRQSPV 
rw8t ur6ffWRfP0 eXhLfZf_]+8 wƶ8-aPS puxg8k@i8l8c8/zmn~d8|poe8D[XF f sf Ձtf 0-[YZ_]e È88 aQ b8Pj0fd1u!8! ddfdm԰  >P6Sd ddSP (88fU{t=T=f]t,>@u%ttt t	tfN @8tF ÿ!r@uabl!s
 1Qh 6Lu߰Fk 08u$
SfQVێJeS 0uMrtـ?Pf{D`*f of0T ff/fXs "qwy#upELe~8 v` 80uYk׋f0$ fe~8(MfWpe*&~88fw*fF*2t*܊e&8fXfY[f`A_-+',!(-8  ۧ`ܤb "u!ựv_8yW t8!WfaSQVWU&- t 鿨i]_^Y[LS-120ZIP 250:1:q2:r2q2PKp x
}
\5	f8Ls!Org;<tV< uWQ<f<P\g&:D=FfG_(*X!X  fJA`u x8ֈ-q8k8r8l8c80 RW1h
K}0E?>4/_M-Sys   DiskOnKey 1 #azB-u @  f<x fP f0Q_>"~|= 2r 0w"1s sU3IH tqR ff@fPuLst6Lu2r{	uABc\,f_o PA rLTf<?PmRnRdVPeF5Qome}E2;; t0hDt;@ u`^gu#3 Af?LfH@P 
fXuײ?D0 @0|B0B0pJB0oB0eG05F6F 	 Ϯ&3FPRrco3W1>ߊ#>;!2>
1_YGh|Ph`p& 4  ߰h*< ZpW+ 1s!$?
uo$˄[         ,X @x
dY rTBB!sh5@  i|X  t   	bhwo4<fHffBf[shPJf&
dh/\uf
{dw&f  ffBfP  Bf%ꣀ% @ BBf  z6fBf=A&  `  fAVfaDf=%{t 5t;@3tZ0tZDfX$0g]=C  BIǷBSf@ t|PBo"sƑ tDf  f qBB<Bf>B u ` _D  2ft.sh@P ~^#rfu$B@s11 >B@!R0B'r"b"0 f!1VC@f,S	  tX	"rH'	"	0 
%9 uf۹-%tVq00 ZP3BP  	PB-tsK '	B -  rfY 
 pQDP؊*oB@6Pf>BgGf	gOg>{G]`0db>ğ,"3	0	ȭ`6@#Du	%&shf6Bf	f BfIng^g~W!
^*t4 ?0		0		{  FFhgJԆ<t
 &G5"p+u
 ߙ"؃ CG&GB&GqN&]gbL6%@( Bf (f 42a3ufBW  bf5t0awSgff9Bu gF9Bu 9Bu
gF9oBtgNXfFBzr=jC=0rxiGsVfqS'`c(gF'	Bg^ g"G0gF VN* /e*emd&b&g&g&G
G
 d0G]d*PGg&Gg&G
 G 3gn Fpp5t	f 6AkG^ 0\PfV csf@mdf p^fIf!B&BB+B(B  B < tB  ;v?ȉBqv ߄ f@x
BqygfOgG p ,gG
	qGfu"a ?H{f%fE@롮 !gG!&B߰B Gt@bk!qf#pFcn૔`_Oâ'PRx7з[fS
f3p5f$fӃ_\Qfyp#{-  !S䡍iy s9At ```*`a`b	`c		0]	0^	  
		 
							
 0hfoWQf`!Yf_`QD=ft8D=s8MD
$>i8%
ĈD
8 r%詿 >s8bcASgsL8rI`d
Qr7R@|= USBSug&|=w t t
U	 	`8aTX 8OΡ p arQ?r C0( z%rP`8M`2P>8?t QrIt2Q9fF`AdYrٜSf1fM^!WA@MH\
w؀e܉\b: H
p(rvA
x @
`0
!?
0
"sTq
=aWa'"CS# iD=qp*W.?43'PT2' oZ(Z
}2(
y_7
|_=%t99 R$RS$2Q	@ ?XR!@RP2 3* >Lu x T=
XS<(fT= & y#j688 r}QtA3`>~8~8p+` pta^Vu6 8 +.\Rf.O6XROPpYfX`XRI|G<b8 fa9<?,B3U+*/G/%QfPfph`1@YOfXY"?N0\;ՐJ?;G7/Osc`yMoDABA<e=S$l{=38%rp/8Lt; LtG LtS8D$
ƈ+DFP!r r
9rYԹ /Ρp%tFPtt=tT= t2:t+u:u hN,odty(u~(_rt{^@L=@tL=tL=`	tL= Lh1)6`oXaPSV88dtdw}LѠrFl@Ѿ88DtD$PQMw'Ph!Ѡd^[XSQLO	8t`g	G	Y[ - Si8   `  8` h<
 8  &0p    
		
					 		
 

  "@6/a5 .86_88sRe.IXR/&-8e 1vs fg&|֠tEB 1W++		m	MbWOAW`{9X&,8r,soeÖIXQoIXpZO RasQHS r`QQQQ-QQ&pa\W3
	#[_rgAೝt⹞԰ÛY"[Wϴjrjstx6bDtq=&[c"[tOt"[sfh~  W~~	~	f~~ ~F
}}}T `͹? !sJ%?tdooy%"o:u2;qqq!(~rgpppp2opQVpWL	;t	@PA:mʶo9X!=^YpWpp"I 0   0    Ro {d    n  A` r 0_0 3`  
& Aa t%  	B%
0 #
*a
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
 S<R"G 3D%M TVaX CJ UK8'(XAIc  WI defgghCopyright (c) 2001 Intel Corporationf`@ f.B<t<t$<tc<tK<tS
df&
duh sf
d   uh   u?RfADf380=ISGuђ s
g]d!t f6d	gftcRa tpt5Hsh @{u  u u0 ߰#ϰ 2  u
P f%3 
f>BfDt	u)fB;Bwuf@f?fhgUtf3۟f"Qt
0fsq
B  iv@#tz291݅!<ug


7	uu\	Q	'h9/%_BKfo6B	g u%S FB s@[%;u!,f=4R0	ff4	)fgfp	Q(f	f@f[aSfSfQfRfV*sWuh15 uu tApNC6g88fI4g^f3f@70}@7f^fZfYf[fP"Vf
Bf=`Bt"f=Ё &f= P/f=0 3f=@+=t8t34 , 't"#
ttfxh0 rfFP0fXURf.  fXr  	 Qf}ufQD8@M TR2@(2Of2f0LcBZ{RO>V\3h/G+( 3Q h uȷf3`_fbDf6E { Z<tatG@]_ToKg<u		upWJ$< t<0t$u RHP?y"P*WT%j_uPiAP#,RfWPR;B_rfc%1f f>=	f!Effg8u#>_444
f@[Jf_,,PSt{w&'H.1=`QYr;f.;lt3UufǧlA<mpf}Azffm fPtP= v	 +v:P,P}lf́   ~:lfP  6l1|߃ tL;Wf݉ ǰǋ;Ptl Q.lBYrrf@u0`b h+-arffpWf`f"0~ffROMIfMAGE0v;uq Wt#g0 yKP}Q (J 2 ofG f_ZYXug&wag&GweG0  "2/t"t  V   9cu'[0io&w j3
G94g&GGfԣ f>Cf-+׊Ӹ00pD;gf3@ h쀀1"`YW, `П.V.`B@~
>t1~a"pR ZuoWRv w xoP&abpZ&&FxdOR< uQS/RpBgtXr),uRG`SQr9R'ܽ$8tyYOtr$V簄O㰆HAr(QSFr(!zsqtrp@ppmq9 `N `4fq48 f܀g'p!>~@  ` FFBZrOs`b PQfWfVEUU &*4P U hX-ULP'G@3 .;qt3 _YXhSw `#no0@	F`ٿ `l"'`sJ4 "`".-2'.q q#80? pgW
sfUgg& suf3ɊfXl]tVfY{AfWڳ]g<t,fUzgR r!8tfGpPQq^$@'}a@8tPUvPtF X PSrN&sp s[XPSN?saA@f!.?SRغ P BDð1                                                                                                                                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - ,-./01289       Z `a     3 sRRFa` $a,PG3"ԯ"
P![2t*:aÜ`>@ l>0l!GA lBla6~$?C o! G @ A  B  $0sϊF  ؎v n "v   BnnnJFߊ$a %JFސ P  <  tq ̢ P  ̠W̡t ޢu     llB  ؿ/  lBB@_  l@    @ lr Тs N?&O ľ'f l  /$а 
_@  
FFn T 	n	n	n	Un	n	n	nnn 
 r s  t ? a  ACdQ̀`  3nnC q
p		 nA
` nta4u4aPfW@ f4g&g&f_X'=                    S %0FLɀ$ tXSTO MS7x% u BMK aSRP t@B u$Z[SfQWP #Xgg_fY[f`Q
`fgfafQRfWPSf3f3ɿOf0<  P tPf; X tDtN[Xf_ZfY<fPffffX,fV>fVf PJE gf^! f^	VJ					y:		N	^		f	W		fWf	_
g&' f @f&:fPSQWV!  tOъ#}#"A$#hfP u	fX@ߦ  h TQ lsY^_Y[fX>ְuD`臭t跡`X X3S'[C vS3ۀ> tVtr't:r'tC  [0Ot<w>t8t,>+
 
.ñ a r t3C,赬軬 '.'쾊'
ìt r3肒s<5fP@ &'r! 

A.	 fX`{gt

"3jgd
A
 0t1-b'.fr
Rt0
s< t
t:@ `k  ' > u蹫kt' aÉ  H0 

p6 I,  J @@P2ؾL
s3y@si  Y 11F0JKMo:Ju;pu;thprPs`us 0!  PWu0+_K`{:u~r:Ȉ@&u[  OuA 7 &	&Q[mۆ%0ww
w2:rp	R
À
v߶ ><  C22 f`8P%A#%z  t
ف     t1sPR 0@ZXW t(  
Xt
 %@  Pé t u>0M 9  t`@ r3pt%%tN߬tGcȿ fp|ff3uԖ[fff#f  
f!]ﴁ X sÝà^R.Q#؁ U~~	=c	%@Q# Y3o#0Ћ!` ZY[0
x  uiʳ # `uP
[ 0\=
 gPj%蟿t
z%ްfZeTQ ص!fp f#A$! 5 qq fA 
 i`!qf@f0` SP!3P#5u
=1"qf'ZYfoPS{4ISTm ThݏuusR^1Ar5   f-{4O-1#3p*@uRttQ@t
1
_uf
@} fSfI!2HtEPG F{p  P+GhD5t sP ! /zd3 @G4g&tC@ȱr1ft.f3A QA Т  {u1 U dh2)
  '  --h-8a@$#4"A& b
/ babR轹p  ZPQu4 pyKqb pYڀR0R- Gh":	
2
.&g t#.σg@X' T
.t&*0 0RVh_BԷtDhhl5htm7r2, f^fZf`2 3rob2 <Г?lT=rhfaf`uX
@`Pf3//ǾPcX	!7"?" hsQf`/)
4/O
O "	 	 R"	k/	(	!e&!_!!!p!hH>thg$wG	qfxf0&u ?2Rt Fo<tP$rf@0y3dtsfQVW 0 o_^Y}Tf  Df!yfft
tP%SQygf5rSQ?
f  P@[^ЛWWVhFV?4r=ыt
 u	  tt uʋ^_rfQf:Eb3:EF c6W p 2:> u6 GH\o h/T3Ҭ؋hB^_fZAfj
XK̈́
>
2e

VTm>T2@OHp
Nt.
O>rb   ,$,/ ,YaQo/ / /  O,<RwS2.A[ø { sа

fQh*_fYѷ ;aEf3ɋP*p۸`0X}&G     &Wft ffBf;Pgf>ww~rtwRtpff@'hDp3QgfY tgho#a$%AP0Y[0U>aPS 2h6&Wh`$2f[ t=> uJ *>p u0ihv_"tv;试t踕3迣tP]ds t
耔 0PX蘨> tp 	~du
[P
A` Ǻu9 5衙r/<t+t&Pu
$&}?.-aq貕t"Qtq2t`_g&G Q !t苓u茒)ʷuѶ>ʶw&ct鈐 z &  0 &  

À>ڰ 
8s   
t V$<
v
ط  F
 tǀ>  t 1
$
ؐ E
h?aŸ$(
d t㋷$؊ h^рhY%

5d			
s	 	,Amu  &    >  u
8wþpR 4
A g"N`ff@Af   ff BC?0QW'  @/%~dBPh p>ft	p'f%
ң  @!G ɀX<t<t<ÌPS$<w .# 
*"  T 6 PR0a#Z| 1.a# ^BZ s  ""
ZP .좵##; Jq vJúQ PR ( PB_X
	`ذ4ĝZ![QSW 0_[ $$$$$$$$$r p#}# $à@ PP `~̀R ĺ,@:3%  /}ȓ(/  !qm.ťf 33 3J蘋  hoE M (tJ PQW<u
&&y{ J{\_`6+z J빌|!~#ðh|i[Xǻ1  XtpEu%h/u~`C苡r>p> u,PZ
[r&>q&@uSr
 s
vdwr& >?PPg` XâG|  	!  , 	% &'  +s&,*( +w 1( 	Ϸ	! ,% '''''+a\(	!Ӣ L(  :(% 0.&, w0(Pu>u0(0(2^p,s 24u0u{c{tUV<2Pt2 Pظ $
 sw[.qq>$qe^]qq2 	?s)S r^.([S講rF`C.t r^a艏u_p;/~ǀˀAd2f.f`7vf.q  _hż?O 1;𪰠r]do. Vb d= ohu@P4 hL*.H*r=>h/^Պh<jbuuu&gq Sp  K[oPwXhhLUvPD+F X PS!~&1+&/+&-+[XPS1+/+-+#/#h!+a`++$q7ɳUԬHpBS8rddr200<drp
d2c贫ܬ pΓStv05{腳߸p,6nmq`W 2H}Yo&`8>`z`K                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( )(     ښ    ς Ͽ g `gw  h }    ;p   s / 7h& =TjV8( ?5VmS          P          %X%H _&                                                                                    `*} ` PzQT@    U@ U	@
 U
@P UX@Yhi Uj@klm n@o { U@    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@ߦ  h  fUf&paf&o>` 6a  !X[ &SP`\@ /'a&&@r
f3f僰gf祸 }f3fh   @p h &yïf`f1fff_ef  ս % ŀ-ff0M00!0)ffXf9ffaf 
  Wfi@] 0 m q  ,f5q f{~PeP ՁQ   ͡Ap  A` e_faa  !6>eуp Ń wPك"` peɃ T	
e} fe&` b "jeffefAffgd:ugdfepf3 gC)T "8fF3ۊde3 
td	  >p) @ 
peuxu._RTC u:/
'
%&bfgfd.S` [WP9A`XP&EX% &߈E_YǓ oooooce  f`Fffut$up$Ūur쪺  .<t
../ NA NfafPSRV5fpor؀tU./OtA
 NUN}2h?54^^Z[fXn34 PSWR/Qa>K u&_E q 7eZ_[XðhZ_gÀ> tQZ
fQs]GPSfQW_fY[X 33 3?3øPR0B1Z 0B13 $ `%>&2%	 
  3  t!  { 9 z &@u#92h2Ѽ_xrt0RW0_Zw LM	5'fSSR1UhӪ?Af    f0Lfs$R8 fZI%CPRrfPTmMf!`'yS'b'

R)	t2*[w.>*"s aPQRpt hE/t
?uZYp5' B>!C
@h1` N H B!<06102* $ /fW 0OQg&?t"g&Gbg&Gbou Qq& ufAκ(/ 
.uf_ 5`mP    NumaÊa$$
a C PB| B;ra 50賘Q8GX/88 ,0[V:* : ,ꐓ
 Q2RWĺZP ,ȡ%:؁ Ë34 g&D4eD
 <.G   Q:QQ>SJ I 1PQh?%Dt$hKT?4TP6@YSl`DDDtD (g@a HF@r[M t"s@#& >X ^h.ڰf
$1!/f2f3f% g0(p!P!q  f@
10X_X!!pafgff%lffP  R
 `C  fA"a; `n_M\zt`# u8$Ou0?	u,hTPuX(qt
*DSjyљ֙6ݚ"Gf`֐Aa  6&P&~`X v
``.pr&&r!Br  Pq X
  Pf? __a}X,}10uff	<u <u õr$Rr z&&X2qrrߠ]rN a`zw7da(SvxБQ` ؾ"" QYa$PP  r&&p'] Ob W
ym' P"նS""F"&&a bRj ~ ZQR_r3'H2't2o `2ٵ)w5 tt(TZY{a~r#uS-ER-Y03!pٸq4  f} & Z2 &rr8t32}0`.PO h?,啊tGS@1?eh%[&M.2t $:Dp#h -5 )-W< t ,4fRh$2hlt sP ! htm<fZrj  pvw@5} 
, #!`e`	A	2@ah
$%00`P 0S%-  D c`6(    pM V魆_ī^`WП 3 _r- Q+ fDZE/D;Հ B.ЙB O B<`<2rru{O0W2&*G_YS	 7&*,u&w}Z`E1j_[DA跼P`QF~> P 2ۃ<OtY	B<tmH777rPBBLѯ: r1 r,q h/Ddؿ8SQk
peat)|$<Pty+fKuҴhqiB`UY[-Qrj @"	ѿuĀBanYoof	V o^W mQfR D=F==rN|UtGV !m4^t1V?h_45f^Df`      $B       W<@ D ` d h`     w ܢ @ W `b  ܠH P X \HT                      `        _14     _  b(L'0#` P  @    UPa !( '     PXYhijklmno 	

                  K _,89:5?NNO OhX__'PfSfWebf(sfg_f&c@pOZ	 нf_f[fX`Drf[XpbVW f ZQ  !Q  A!!ȑf%C`f3f.ff^u?_^fZfYf":Q ء f' _C
f0P3XPSVWfQs:1Kي t
u uffpv @uf  fY_^[XQfWfVff
 5ff߾  pf  f`   <f[d0{t<$4'p?f^f_YA <bR5   ;f^fPSQR# 3%n0%B@ fq$<sy! !PB@6G%<"**of GjF|
sKf0$P
f>	@
 op/'B?<$
sǺ$  fޭ`5Xp4'o%:ZYc-9%@8SQ$
 $
ذv[$w>u@$- ߀@xf_=  Ds ; Z x  p 0Nm[$
Pd_u	q @2wXÃ&	 %_ H艀ȃIwذJp2ȉà,' 'ff w	.h <.a  a-${tҽµ 00hHYhrEd/(#/Jo'*/"#Yïh]AGf>QPH_u(Dr#1 Ofp!2 '46-Wr(Qp% -ronUWp(>f{  t ` tf frw=@W   _`ff!`2g&g
fKffRg&& gre Ghջur}e^-`fVGhݟZ,
- xф r k sfbSfRj07W6uLt;wEf6wff8 r/fRebfBfPerfw 0  Z`fWu
{ a 酀> PÀff`!u? t]ǀ t
tAe@zYf?
 : ) }(d! }_ f` ; 6frv`gGwf3Pz f֠yffPr: > ff@o;w!fVg&f_^ufFtfafQC3$pft󰥥Qg&09y08&pof=AT?ADtlf q:?&Ǉ qp Us  SU3a  zb z1 w 0~z3Ɋ yj qzUFWP
 XUu&.>J{   ub >u }`	`	ytpg$l0yyP$yC#	


 @`W3  dt1fMd YP`[A BC_.ܱfUf.6f]f]aeaa** End SetActiveDisplays: \ !$Tt5< ux )ڊ챸 8t  u
8ud a9Se[00t@uSQ2t7:ﶇP  Ex@@ p#tS Q<uȸ
  u`Q 	
30p  D Sq t1
S
L_
   Pݳ	 [޳]e`ߠR	X޳9 SRRoPkoP %p`jo[oċ؀ ZoXRoX8opNPSR10+#	oa\nPab tAnP ÀnXn۠ nQRPS [X"3t= z  
\U  Hp@`6
u&Ppr
u02,RW_Zr&&&E&]ж  faP$<???M=E>@. SQWU]hWPAXð PR Z} .a;tH rXt A`ft,` `C_S" Qr f $~ >Pָ``XnrpC f_`uQ`Mt'f ITAfgfP 2gaYld 
0`tXW
Hpc=&M_0g.g͵ 궃? t0;r+gCCE PsGPh0BaArJ`P!uu& tQ Py PfѰ pԊ6`Ȏt @.d (w >QOa8tY*_O# Qj<.uO R%K0f
1
fpDt`l? 8 Atu }p\u3鈰u#Q?G`
u"Qh9u
3kuC*u%sr'p lru#itg&ON  r ? 1OCk0`u<>l  !{ĺ@,fSIMWuUf OعfPr޹fAf1f;wO(hwvrap 1ð?OSECUQCuBfӐ1R 2(`XfGPu(1_-o$8tT q Gt+Soh
 oTT<tToA:`qohݿ
 
ʯ@  G5 -ffLw	ßPl& t
W&f_r2e Y$g& Og&	2WVWfGt0bt2t~tyf m   f'@,(< @ @ u^/u  rFf;r> : t, f    ur%P~)rQYw9	 q8V  %@tI`A
A!:0.2 r&q
"

rTr ~V!rP#j   t
ff;t;0
 + t˯ D@@D^@ ?hO,9hlt ksP ! rwp	߾	  u ff!` B
fffLp 


ghmhNR 1
a3`"~t3 v'%hN9GѺfwQV1
P6<t12:u"FI1()LD1' E-fY`7@g w.	A_S 
fUfp>@	 _--

~
f+>
B#f]^R)""w"  ,gbXvI? An>@u`$f!Q %  
s`_#_#_#ZYcUTp>vfrg&)S*S+r< Ԃ0`PPQ>d uι c r\d`dYCtCd>r-R`w  r0Ҋ1 r
-u`d/ P rdItf s`QRpy0ЪNr&Kr! [ww3r r	gPPRc0{pr 
 Z{PQq	s
d Sr	rs!V>RP   dtg3{uwR Z +}hk-C ZXUR. PPQ " Y  2  p,u QP hE3R밍

Z@u@Sذ* o rı=` ္] IQ oRWR  rPP3DC	 4ïP>S t33@J*0`Rމ
t#4 c ttpÈXQRWVŹ+3"~a^_Z#"#31$G<u
t$V 4^W _ 	"  !(e
Ź_ 	
R
q0P#H	
g&/ܱ1q;-r;r;x;q;PR(Xó J2Zq 0[RVа$rN ;rCr<,	r32;trr;w tsڋ^ZW
   е0u
˾ШBu P f~ uf(2 J3322t@@ 0~ 	rn
$	"
upmƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_..P.Q.Q.Q.67r.Y.2YDذVPC`D]f #g&   hpLtfPfb` ^CuGfX2X"U øD	d dpxx)pv<	< Q{}>C? "zBJDF2FC 
كIڈ#
N ~fqq f+fMܿf-Ef/ffqC  f>PAMSuff>r^0wS0p(Pø`#X> fɣ|	! f#SIIWV`0rY  E`/fP < u s󤏢orfcQ fQht^`b
ht.ԜrB  ؾ@
E@u@
P
`mGft0!0 I"a`Ej uL$<tD"ЎQHr&=t&} tV" &GF^YՃ"
\ؾdaþ0 	 hy+!
s 



Z
P
	





	h@gMLொ~?̀RȯRغ0 t@ZгB3 < f }<2<
 1_                                                               HUPRPRVFZX0RR{30ZO                              5ȌȎP ЍYӋh}3 u<
w'>pV'b w	>z'ñ03fPS> t=u7 u1 *<t&t!uVr0`r	B [fXQfWyLtZgf&gtKLVr3g&GȻ spw0ar$
 !O 2f_YPLtg&G"r KtEtQ@ 	
   VȾ 8t"8tr;2^SQw^Y[t,&
u>ut
$6sE t> ufM"t$	&
ڟsD
tFڠ	> 2
X*T@$t% IP`4uf0tCf P p< t &$  
` uYߴ{&ۑ> 
	 >t Lt0刱0q
'u@g *r$@, Bt>1u
 胿dA ) (r"/t JJ]SQPXtV
r@.VSGjItB0T0.r//Y`6It_6etP 	rB3_,s6u%
u= "7H6͹ RE6Atzu jQطcبtb;sW;saDQu	Iu u"
urڑ"
23Q,.  àڢ.dto b* .)P16tXSfW0~`
GtpD_8؊f_[&ֳǹfsg]  r
Ô,# fPRfQfSff%|h f
 1 fȺ4Aߋf# uOf3\f `(,#%9tf!!1 ~f0 t0f.f@Ff`f[fYZ0Z! R`ܸ [ݟCfW @ fg& u8  *wt fqlt	5f mf_À @f] p<Zu?F_rF /<E@ h>dt_ sP ! f
`qs= fɸpa$
w
0
ú:cktG/f@
@# ƇTz @{ D 1úd u"Au)O "   ߃ t 	Nf|@ @ ̀!b1@U	ـ@g&`p# % &Ѧ!#&pR%0(+1#Q~Ru-f#f? %+ރ8` $B' $ 
 f; 3 Q'
f~
bZS	*
 N'Н'p
f1f3 ޠ
s!=qrfYfĳ & A%#@3RS؁@!^SCVq#t6ۋD8 %f&ȿ ffP]t33u⿋^ Zfp
0jR3һX3t@s=7rS
`'`' h%Z@g! 
 * 40*ZT$BT0	f%0OJoÖD&$b P1T؃2沱1֐B'pRfZa`1غ   nBnnntnJFn aS w[ À 3ێ7!C &?!Cu3ۏR .Zh*fP 	fX@ߦ  h fJ{{Xj]]輿H&JJ;>&蠲;.pu	 muQ %FP?
 ^tPFtǬ+t8QWP3 PhX@.X=X@uX_YPDup$ q!桐.$> u
PbH@Xuð6C @B T }ASQgfsg tHfu.g :f`tg&ff(1(`2ffߋgf?ff<˪<(.&ߋgfBfsDP
hf!!
#4	fRc6U t 

(
ukXO0fMIQHBf   ti@GVp Up hk,zaRÃHt%tg&g!ggy@f`MRft9tg>E @~9g5Cg}gfVf),g>E %g>B !Pq'^d`g
ز
".   #bOf᠞ "Qw1o` 1YaBQ p@
OYXPp葧` ؠu 0`K؎ wRf쨀u Zlfa+n @(00	{`rEfm_ p D  &Et"D  $D( s0`ۊف&t y 0Q4>2@"Q
g&Ŀt
_ 0HL &}u?p ?u8&= r1	&
IW$Br P
` 肐 m  m 1bm p's 0a`] ar * $OQa	 & aN# $$<@t"hXQuKucKJ0|ުKuף`.>*"st&3r	&*rC舨薼蓼"aô`prr X ? trC0}q;w1#Q909$>ԯa0){fRQSY[YfZt'1`ta( u
| cIarW0
ADȁmG>  qf  h f>ûrxyh9wf r<fffHff#f+ִ f;wf3g&Sc
uff+f뺍
 0,.028 I5 7TF' &=F 
֐y| 8ƻ6
&K=`Ⱥ t  q&au Рx  
|  wQ  6tQR _ BPffX0fff݁p BEA  9 ` 
D""oR 33#f?f
 
@"f r σ%\hp-#p@=   urS׋гf"Ӹ 
>thC"cb Qa!% = u5
7= uu=  q܃` ! 2f##Pf3 9ҊP36Գ+R (aARoP Q   ,A048  PW4 #5 A S@`? 2'hD/FJfȱ3 tfP1!f4@!OY0a<t['fp2   b7t2 t,fP _4141RE'!'1'  fZp75݀2   ڲ i-,/ ,(.w۸M!n> Y	K +,<,
	?$~o,"cFD,)>
=4i, ,
,b,&`,,QxiƗޠ	}D f.߉4+!u<u<vw2.жh;f&@qqe Sذs9r}9F'[fSf;xV4t&? u O_A&[ff[@C8ø {8`z`Wtts6ߴ衛" 
2"zfhlsBtAt8~.hcr0 WZA@fP xZ6fAuVqm}dr
htz`syGNohId @ hSrx W`"D .x; xt_fY Vp&躻GYf^R5_'3RQ,ZTsoӏcR4B+ràq"G5	  蜠 P5ĳ6P@V6Xu/rBBD/6b5S!$^ uu5 gN5?5p/2P }bJ5X	%5@i62[P2
tˀa	5$

5Àu4<X[X }aPQa5؀a
52͠ .Y!u@<KrK7X
03!4+t
3NO+t3GNO`UN+$+N2쪺P R+SR2``pPSBФ                                                               jS,OtA 
d`           4  p                                                                     &T  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  vA68DTA   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 fys谂 f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3{f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰{}s 撰fPfSfQf   fQf3یff
   wfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
f>Agf  ,fsf {ta$f  ,fsf ;Ff  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i2Df  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tSg&4  g&;  ĀuE g&  vɃ  f˃  G
f  ؇faPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀms>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ _Nf04/19/05DATpf Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tSg&4  g&;  ĀuE g&  vɃ  f˃  G
f  ؇faPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀms>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ _Nf04/19/05DATpMZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        