#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTU ROM)  - Linux-Based"
BIOS_VERSION="F.05"
FILENAME="sp30429.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  E22  E2 6   Ar o m p a  ?q . e x e     ROMPAQ  EXE  E22  yp2Y  8DTV   BIN  SE22  y2    8DTA   BIN  v-U22  gN2    8DTH   BIN  022  K2    8DTV   BIN  z|22  y2    8DTA   BIN  J}22  gN2    68DTU   BIN  D22  *K2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    11/03/2004                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               I   <  X<
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                   <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                    p   `      POST  f   f.V .X <  
 f.d ` j  I     '     @  B    POST&2 d{ * F  mX y wF 	 r
 ) z )
 z ,| )  X ) u ֳ 1 &2 1 1   y  s ru dt  p! `" ,# 0$ v,% & y' N( h) *	+ |, - X8. 6/ X0 001 2 3 >4 	5 `6 ^7 08 s9 ,: ; ,< = ,> ? .@ ,A XB XC ,D yE F tG H dI 1)J IXK zL )M uN p2_ )P Q pR ,S T ,U 'V zW X *Y@Z }s[ dX\ ] F^ D{_ я` @Xa f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@`X=X@u
_^rYߜPPSظ h@ [X <t
PW f&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI! UhBt/fk00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@`=Rf0@
u߿ h"8ufY_ZXSQW< s۱1
2
 h3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
H/@
		! &
%s
> h}A3hp0 0t  Ãu
.(u	u/RPVF	` u tR	k@.)t^~u 8	t/} t^6
5
^Xf{QW~
,?  _fP	$S 9#0;r#Lt<
tw
u!ο ƿ	/_^p	65WfV*p#)6S
F f[tҋ3ff^ff[f`K.fa= ?pCfVWU[? t o f7h2%3 tkfAh6 Px'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@=_ hR3>+f;r[?> Wp
,2h_
 WX
_: r
gN1
g>r @99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY{_QU/tgw^H2N@?| h P~fΑR   둡4]hQRWV^NV vq6'Q3qI4GYGۋʫΕIw^_Z!3Q'M0 pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h
s.  G)FuQVsuR?
`ۀO2ۿ~f@x߲k:P`?tWuf@ f.(|ftf!f.@# .;
uF8Fuf_ts^ÑGVR.>(s$0q	.k6(.(z

ZF(Pn2
F~0(FPPv2PqN~ t4vf2&fߋz10{
FNNI.(ƔfQvPu@f(.;(s0e ~  ;u
t`g#_t@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ .ƅ" ` P@hV.( `s$' ip3.w(lh>z? o.N /p\wFk@"~ 
N~f.$=6@.(2̠0/tl)u4.B$f<t؅f  `b$< F. 
1wq3V@~r F F;F F2u~w
`Mg~f1 kЖ lt
fNqu
ffsfF;^PB46)FQ*
*q4rF$<u&jF/F .#~ ~$w_p` *.p< O<uO8q^`V@;(@..(;(^éV0&0
9t@-2xk@2
E/1^S 65^35}#'uB.X:NЎu{P:
t3S9)&u=8N0w_^WV~\SVR`FfnA*J[.*!ffAyRffP%Ѐ`2fpʰKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tP7u+q%
u	AfF~aJff^Z6Waf F݉^~K"8ueffFՋN_QtcV@hvb!F;pI*3ϋ~+c:tsRVRfQF;F8u p? kv@k7F:`pb$$@K*@3frD` w;=< ur,.;D$<{uπ r-0	 @BvFfY1Zt4}VWv vЂfq|~|URd
t"t_t( @DvP }PkQ9SV ޾PP3; t	 r^00kPP˾#Aq[%S ^Y@j(*pt@;v7ϋh!1k~@st 1;FtFk^% Bk^cՊPPa 3҃  V3k`[
ߋ*RP;FuR*3]ft7-kJ	)	# a
@~S
+FHu
4uGrvFvVBs0;~HVW}΂tS03ދ[^NuVp 3ҋ0_&61-Dr<lF(kHpBHP)A?(7oZ &0V  ~r1|\0PN~ tKv0wY_FA.Qz$ x
fpO3g FfN@P@ 
0K SQh(	 \P,Q23If.` tf.&!. .8(tьL$QVW
fv-UFp"`F^Ͽ^߄F  FψF
fgFF ^⿊Vevb"^`L`Ч!ɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;FyQrZ@րi`b԰bbfC<4R^VFъF8F^ pVF0P拫N$ &j(,yntN!!fsШtEH rts@CA9FvG 3r%if.(NͿs  `N0ƺ0 
t
F%  .p槿 >fg~ t:(i'i_f^z eu
 v@aQI8t%  :tu Qw  vfIft'fAff#a 'fpЊ=rSf.6  G                                                                                                             /                                                                                                                                               o  PQRa&h@ $`Ȱ h?rZYXSQWa$a$a  hA=o h >5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p h)Ē
f`  蘒 h
f4ٿgf&P ސ  fa.o-h
 
}"
hsfPfW@&'_fX`g
#r-h	,tO#_M.hQ\c*   &  pO<ۊ@ ؀ L&}uu hk2!3d 
  % UW-5&$@#h<ff
AÀtf%1fhҒsu h:*,Ⱥ: @p 3ȰS, @unSh.h s!v0@Pp"0.,  R   P.   f4%  0"g[  
hS( `ӻb4&&aP h"; # h	) t
 aPQ) @ PQ= `t
3f3@fYX _p>ðd`4d  UP@ = F  $ؿ
Et&؁@@ uM9NwN#uӃ~ t"F= wt%   +ȷpBXh6C=`.-   !	 : a `h2W2Mp t* u uJ<u a>tPRfZXD(~f./~ ACf` f   p9GڢV1SfQfRf I  f&  %=uf?a2 ffZfYf[FSQRfWf_Z ChLCjef`N s0뿆(L%L2r-
tf !?s! h`]fҐrs P<c
1=6Tfaa	't5<t1(Yf [r@ 
'Æ B<  C< $ # Q R ST}fp/RVW3 d,'#D $
` L~Kfp; oуtR&xQR/K#K_^ZY!Ú}   > 7 A  T ̟ M e M A@  9 Y .    ?n SA aᆗ .> (
qDah w  I0+pI{! J0ÐkA52 P f|1π!L6\1f_60 8  3 poБ 60>x:.h3cPSr $<t4r 䎷[X)! Ѝ|ߋhP23 Q f`4 S  y6߆h3%hD32U @e D 3y "r< t0WF~,2"@Zv,jl 󤾸,+r+,ސ r%@,+&5&D&ENon,Aa
ph U¤ @߿,p<tdPcS-Vj2-~^ 
8
3
~3
e-^
-  dpQs-W&@ U$=u&q-f= =u X&-&-&}-I
, fgh  0 pqr  <ABCDE xyz{|}   )UVw S#
fa0_bV4 r&-&-c4 r
& {  p4x"m -ccfXWCf  ~gf5wfx&ݣV3
Êu^`0(.'t%.FuN.P, _XSWfVUSW! Q,fv߿ hr  ށ$~22ك!IN܀3d	^
u
t_NA&>+_[]f^_ PVb&=;u&&4u&^P
P<q +&~& 1E&DpSV h@r^[þ`6  WfPݜFghS@Ȱ <fX_v^F10=ROM Based Setup  En?tering 6 `. u  6 lKyt.߀6 8 Su)!`- W  6p 1A	A6 1u6qrJp &6tFò  Ŕt
.>	t.Nt
(*衔t h9PXhcHsF12=Networkrvice BootWake On LANAttem[ptto %  Aht8 0 8 r	 PA 8u 81I	t/ tsR QP. 8$<0,( $8m>bBUB" 8! d's@C	%25M<^Ps 迃Es%r kVRyoMlNF M3فL?	uCFG~gN0tG@hջNM{vshZ^òP*Notebook hard? drive MultiBay^"Dock!:b<#b (top)bottomy)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!I123                         ;< P 	> 
\ z@
m0=.P ТpqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob. ? Press3w1bose.Seconds until au;atic defa A start:   ==(>$8P \>'>;S A;Zip.F`u h d0ô0.磃>ӍtԎ>0; A VM3L؊' tA<v<st1=& 2آٍ@:2;Q#YAr	 > P @.=
*}= @=+jjj(Pj48  > `== z    > R 2җ
   t03=2Ɋ F8tFޣhM $ Zbqqp URVQ.,.L.T^Y^Z]S,.=*[ݡQSVW/ s&Q>.<.-00?00.Y__^[YQr= u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2΂ Xʱ@
===r
;wo2pO=Jơ}gFYô.*=<u2K0fOh{ hAh7~d hb<u`B J qWo rf.>eB5 h`ӿfgf&G, @ f   PG0f@G,`u
hEtG,f",f_ffyP QW2_Yf= TKSt0fXbo    ? o  J^  b؁.h
5p.
W
g&Fg&Fg&F"t7g&ƷF0a 1 2H޾C׎Ǎ~ذ:{ rsC	 k  QRV~DTQF r&ew^ZYCffL m(].LрY`VU_fQWo
ِx
K&@
C' C$C$0Grkx  q## ru]"0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#p%$u!#,vABM  f.@EPS [XAu.6DEf.@EIDNU.DESfVܸ#O #^3%%Ýf@}3u
u\ru!q!} "W3 hlY *N*hhqh3p%5cf_ ]}`= vH wO1H aP h"$@<@X7LO4pJPR ZX@ P.>pF t.pF.rF@atFSQRWh@r__Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4B XZY_U M[у< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4g&@LhH0VQfPvf  g&?t9g@YR%fi<uޢ @^  f%?f^#   f@"f<tf Q	 f !pf 01^AaZY^$fVL/
/ZGWP@t


 
"
f^ff? wD׺ Pf% {
a!
hfi4H3m4r H5 0P@p <wD	2 	P` Eނ   S Lຈ@`^@"  	P 7 	|i tp   Z@& Atf &l.&h.@ p jp 3fU$'Br"rst$ uf*ڀc>l. tuc ~rh^
&u.p=C<th Up}.  G11?}4 Q < t&.GfO&
3f30 2*f&l. uf
ffKP/&/&#/kfC0,/0(8l
/p/15RfVWf D3ffCf[fKfS܃fF0r0а K I+r-_;Zf5SQVW u3_^ 	!BKsV 
R3
t<^f~
w/v0M0f~kd`︠afft]@`[^ɳ{VQWfv hG-F&/F&p & &{P&&0&&&&/^yUȡf  rX)Tu'P hk"w hhgaX`a؀atif]PRqQ ² t%  sS fO ffff>Ofh} @Kg&; Qu70W)f)PfY~/u! /u/u/u	g&t(tx3	[rn;f!ǂ0ِ  ;`o	1/uP~/t rw!	 u_;O5-  /                                                             10Uf`f.OO?uߣrW2rRrMOtf0f 0R| Wb t#Cr"t p ; (PJR  ZR f]L@V0r*6^  R Z?rG	Ku ezdB rC\A 3?Xy8E tyEG 	UgQm r	Q>O~	t脋lk޴Qkpbƥc࿐W rt r
  GCw_SRA0Zt$ؤ$]WPݰ  _W}  sp  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
R'
//&QQWjuptPX_Yù
 d h7Cx1s y
2P <-C<u4-uĀ ~qRR]aR12e< uZ#ȴ$ t	J  U
	ba!"(栘Pwf@Ip^hXB*haßhr$T/h ܴ7h{B.uva { r PQW 0> 3_YXI9h`c=F =E$h_5s	> Dð   ! $!f` T h8@u' tz h=* h; tff%f
 ffavPYF X(`ؾL &FL&DEP&D >Mu d] j@ tL}
 -Ȁ}	 >L ?33SPd[tS[@? 2[sDy3 t^hۅ#ʊYs
JhO#QaàhL"RD
ϰ<DuL
p
E$<u D
@Q3Csd
rSi&pS]@` uL
 6 6L u  u(X6Ӕ &uhT
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	& ϴ t"& xu	߈\	PS   ? 6P'>L_3& ?! W>L	_[XB
wt+# P xt  t  w\DPV!$!"tKh10&,@ &  ^X  hC!r!L	vTt
v`WU$/! $<v@a`n3  v
p
u$"<uP>ȷX\PRt P:1thE]!&ߊă쾁=0ZXx` 22PEǿM&PCt5M=LtOu570: u	At!s96 u5 ~.n\s߃
t!\&Sq s   a
׿/_Ƿ3 "s{&=  V P;Nu 0< ^  3f4G -BNf_ ր }0 U!ߚ    /N&egWʃO&MuO OqfGtM!t$Ot, t"OGr ǾJM0oOg&FN/` 2%
<t29o21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇2a&EwS$`	&M&]AH`.'	@[%# rT UϠRb0ZW&= uAF:%I)
hJ
߹ m_XP
pt   U!w#w !#`ފ|nhS0 a.-.MSN=tI! //(rJa.58v@Mu% @~BSB 0{hAshaW!$
"1D h"
hCYp@[X_Ë
ß`PS@e![X SϯH<vLR
 Z,<u(RffJ`fġf,ZJ vGu
Ȼ
 jS1 ~6у[Qa${ ;@aÁnf3Ұfh!<>`b8 {	4`֎ސ0hu73۹ F
t)?:u%9dD	& h6SM & 	 h3M3Ga!3 
3 @  L ڑSٹuTu " / [J rGQw> r;fQ  w.<t*tR&' t&߀A+  ˹'z
z'+՝Q}!@s& _0RV|Z`|tpk hyв YQ@@?zP^[r4fHq(u% = tR0Y *Q
@_HS3L+6 w
HHE&AEԀ 1, @r \ \hpӼxxf1  ,VA @p$P<PtReZsDAAO  ZG}pZ^a/\WV 0  Ph"X@ 02)o
C@)2ƀuưҀ?!C@u?r@Dt5. ׊u,u1 
@a

+&C323&@t  %
t&
0  5 茟 "   ( 
u:	 7/b!	"	? A%w ^sPRWAC&A &]&U 
t ˀAi] _ZXr#3һ -wv2C.u#/5$N#h΃&_= '߸^  Y     Հ>u  '3W c[ 0_iYf#`Zf3fcu 3 Q>cL`[C:uBE&8Uu8p]
R +B&U
ZK!؟iZ6fYB)%qr hʊ ;1	Q(tY0=
  5Ãh_~p8.
<t0Z@ێûPV#
@F^fǠ  XcLED
yC I mooUf``؎ Fwk. ڎfafSfQf.kf fff#fYf[2VftGf   kIg@f;t&f 	F $f^`2ۂfaf`3pfaPP3_X.>k+ . P	TACO F|r  
J!	& .k ޹s<F	k fFf.k  kF.kf.>k;E.k@  tkttYpktNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p k%f@c .ffHpfXfdf33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RREko4^q4'r44$.x71p6ɐp08333Ҹ  QW>% _F
3}5u'JE#a0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^PE ujQ`  &t Y&  
 < tr&\]p &\׋U  
&JkN!d L
SR[}u 	F@& $F^[_bF FY2p߀TV'}PVWًذ|о' M! _^Y[XWfQSng Zfat
  [fY_` t =$PpnPu2MtaË6!s } tp( ` j &?&E`?SRUQj@6^]Z V` j8rČD^XP
~*F
  t# b Q`lF @Fxq d3duhXKu`<Uuùd `hr4d & Xtû   h9ͻ& h:PhmSE'`X!$!   °rs} O
ehYG   tt 4  h'Jc` tKu& &  S
 ` h,
s@<t<u[uТ 
0_u?1o*`P	h#n Xhz % Pk 'jD[%ys%aPXw$# ) )t`($} f.`G  3Pl3 5Dal@7' À   ; Z x     0N@`^~#bh1fF3.v% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ#v.~r@V»/ 㐂û< f㺰 fﻀf @ffRfP'f!N
 ffFf3fvZfFsfBf〶fЩ1 r9pf3ɰpǿjlfAP  fafPVa3v޸ͿrF3X

S,0<	v	,$
x.[W D`

[Lb f s  f 
T
ST p s 	 }
Sf_fp fvPUkړYP, Pm:Fp
uf^fNf?V_f^pPRp*f:VA6F@20h
C@ Ϣ
 ff  fffffXCh?q p  `90wy P9tz" 6 ay)P*hkcP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMSqhm   h"Cɀhh䎢SZ?;?PSSE@apq$ q!̰_Āu!A tðvntt<1w(<vvP޲Eh3_ P&
0
3q 33ҊtW/g.&;u;ϴ@.Uont)@)whPmt{؀}a`2G@t03@ @u  S__[
u93Q2/,;8cN 

P5-j1rX?03Qr |X@Y4SQo2P5'a&& &0hlC hsuɰ ho
t[ Ȱ t
ŀv#t̰,5-PX~v8v&> 㟸`t`_P3 u $h<J
#RV Ps}x~ uu22hSgu]5uXP&
wLp~2 Q޻ hNu= Dt= tYԀ'
YY.x~^Ze[1HP #@]U  Pf/^ ]  `yrr	 V'afOLPH       @6P0;V(e
u^V- ^"(P*^ߺ  2oMqSP( 22 pX[úB  $@7R  Z`7              zJt}P(a % $近 0rxfL+  ك%rSr$rF!f+Df+\ r*蟼r3w r@ .`hifa2` PR30 Zj@AR `&Fd??uhP&Xh$ r.>b.cpu 	AїQR.ch f3f%  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t} 若u~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkP߶kPR]]]/?              $?`6.u;v` Ql0 >rh *Yr`"Q?wLQ`f&YCC`K (   rP3YaPSRP3@mn?[`H@4$&%<GP 	 joپM <BMtf3%?ĲP2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ  } 
 f@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff6᳖pZXW_ RWO  3OtCxx ~؎0P.BB <t BB2J &ݾ8   8u!@`23
ShUSt0` y aut0i at]U U[aSR  4h}f
 hcfZ[`-1Pϻ  h8	 hj
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wZhEU2<Uw  hZ2 u
3oҸ EmF)v upQstT 9 
( 3Pf. UfQfRfUfVf@>h
: rsNrBwW3f. ff_2f^fq3Yf.>fCgffgfׅ suYKU q u, P3	fgf CPpaIfAgabf.#f9ufpfY'D0  _  /p ;5h 6  .ԄU7 0GЩQ 5f %"  OV3'%@Wt p;F ;
V3"/fUi &g3  f% '"곍 #WFfF^faQ_V p @Z  
^`q[3[<  ~ f DTDw R 0o 0 ȳh  1   l ( Pb @0^ W HL P`A T W Xb, `
`!W p@pؾ0x o A0
|\D`̿QWh!E3 3_p 0 PQ= `tq1 @0Y?X 05SPp
& p  ff?& X[@aa"&    ir  vf{@Q  oJ&OfQQMh
2 ./ۀ Ζ Ġ_ <t l~\ tq.Ari."D.|u.:DtSIz  wD:r5+^s&v
uAm
c1PQRfWTc`o
fXÑ2a`2	  "	f 2f?@0f@R %  3?f3fPaX Ah lVUv  fb #n&f fa dD 	h}zW"ϻ (;sQSf  r`
 t
2fƃd	40q!a
 Q[ffY+˽vf[Wf+_f7 t%ȡ^H+f@`h00Qpg-@` f@kf`0z q_L2_&U uZ=PrUf uCfy*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&ߋ%Իf2@t
 <t+p g1~f&f   , Xup Lr}3fBt<rfa&'?rf-QˀÉ_xF?<qP
  
"a	Ub	O~p@R2BuIE1BcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&tg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PPܰ0Xt'vt
t@0r % r/o h>u  thrs-3&>rqrﲁRPz?sRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph ro{u
@ Ѕ&&  ؀>t !$!f$< u~RC  
N<2<ăƁ	"w3A]'y@h[u TYP=t 
u2Ɋ{،в3`t<u
E< tȵoE$<u&w $tRnVL  N L Nwڰu ` t  Pj[2u
@j jY!(!!2(<!1ʰe$ h5u$0t͛$ߛ~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|hA=_DuQ&~% t PNX
 T.:t
 ._
vXP%8Xr6%ȸf)c4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
߲&;r"`p$t1TKub 
HM` `(q p" sr#J	cp&v3a C 	H ]r5r=`2gpjh!vZaVRQShl4Th4J"Ҋ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFh UUujjjj P48 &h#w\ h/w$vbwt = ;t= Dt
hE~sp[@WVS$`́$
][? @n< u"*׿Oطh񚾓Nt`-->J=Ot1W 0_ tyr rh  S^1 g 0 hL P5[ ?  :N2?Aq%  	
   VOFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
tdƿ&E&&E E &E<r&}	r@ VW^2۠^2*à
&}vPuh_VRPRQ3f 
%*tº,AYZXRPSQY[XZhy?7	pp Є> qQ 5rX[Yj-: t
*֮h!ERL&&  t8t' u a,& nqr00r6$^$ Z& && ;`Z@ `dde`P`  X3U @>
ڹ ? .PB B8uwG` A w; 5䋀w/)@#BS W냑76VPoX
 a@A@ B C    ÜFt݀V$%Ȱ%蝊<;weċ X؊<wM3Q#"XR<  YыȊĴ3ЇуE pY8@C0	 FWYuF5<uz`0Df&	]2
pu8f߻hNeP߀k 'cB@. ,".  &k !< u?f& bÊ$
r߀ wA?u%1uhS$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVW~ҁh^fKff
fZhZf3f3ɹ f Zf0m f+fZ ! Ku*آe3ہ5esV4C\` a^_^fZfYf[fv3hI 5U`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .@\3۸ 2ҹǻ%&@GaaÍ6LhVWaL-z_^pk` hΫ$h  uP$<X%sf @  t<   4 |r	.$<u
kа f3hh. 
d]XiJ	h;=  tdbw_3s.>Nfm thLtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  hc`5
P	hWBFe:Ffu1r,
 h
 Fdt;   	:  <g ht5Lhh}`!af`7UPKh&u>fBSCA[t$ Nu 
D&N r hPf0̾   F^P XSĻ  y ,    hb-[t(t@tU,Vj Pj,>" ' À thtZdúߋw."***ED/.EqEq+Ëy؀d/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYe߹b +Πu"<6Fi1 ep~0Fff`Fup  0j(j	R"	aURhT2  ɺ y1 h8rZ]ÓoR~+Zr@!  tCgRQ QK.YsY2ާ$
 !u$0dU|Z f`3  3uW fI.&"^f?  Cgh
B%
>C ƀu8u.>⧏ 1fa
ZURtLޱUHhkxk:Yn Yp to(tq ?;CPZi@"ݤgۇ  squ4~@VfRf恎h$0;^f[r]䧀8" [ZbhTr _s 6Sj@ 2P sg rGZO5'_UqWqW`.uQL$<u:`pr"&  t  t8⧀ tAt $uPq9(
ʐ

 L`XSQ 3u,S?[rE	ˡ-Y[C& <ff<`00x?x00`~||	>>.r tr~ (ЃrL]CX̀'tCVG _=`Q<Q7W &TZs6C  E ц߆ԆrB zuN! D /u 0/)0/f#-&A ;q5 F -7&/p0W aUfV3vCDPDQD 7@4f^]&[໠QPЂ wPduXd@I(a@ `O` ͟/////- "  @f%pкг ?FACSPZ DBGP4BHP  0944 A!  8  APICZOK	a	
@  		`
  MCFG<	P	 = U   @(@
 2! RSDT(  	f`hhsif  fhpfp  gfFgf  FPTR ff0WgF{pf,.p^$f3..f.fgfN0~$wf+@hpJ
S
f3ffgf&of.>`f(.ߴt22@_~( N g&F	f P  rgfffff+f+.ނ
a M.>f,
$$#DPXff-AFV3g&fFg7Y[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr _v; tg&P)XfY8]VfWfV*f& fkP&ؐ@(#f"fP)6$ 4 
Ȱ ּ
ff	hScp (f t  h>hsfPW E[fX3 iwdiZ$ wc g kt+
h2<pFpg&h&P_g  PSV  4Yt >vFu	}Cg : uDb& @ u  D` ^ RW D h"= h _yZ!PSW?tSfP3h f&L f B`#L fX`h%Q" 03fpep&?   6Nu    DOGBNf3{ pGր   U!ߛ   FN>/N&geE E puMPMLGofEtXAt`$Ot3 t)O$fM
rþQpmMe&FNaxS\U  r.0]h2.<}mq;   mø ݳ kmtWp_;f
PhL#6k0kf$ttӿ& t? E'뭿 5(cP)zio_ԜVΎގ5G^3f`FF  h>w }ur h  $g(,0w4'8  s7Ã9FtFfNA9F> hA4:ɀuh(fa`
Ew13ɊMh$ӯt

hRp;r#uac5WF ^`SCf fN^ѸNf.9/u /tc` rfQPH_Erf;^uf;Nt;~ft) @ 
tF~U;_ս MfOV t;6(.<gt1!QQh:,, 
 ^_U00 ?u,h..D+hXك |p1_fqtA"   u
}3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart Reader,GEMPLUS GPR400,PSCR C1LB REFLEX 201241 PCMCIA6Reflex v.2$cr$HP
  a@k!g&O@ yGd `P ߳ rLfK s%or>G	 .WD
A O@.d.D4f_ PQWh  
G.g&:uG Y.  _YXQ8t *F 
⡤fW
"
@
@Bg"

2%Qf_V`bS蟨h;0Gu#{  euu .u = Ў~ 1rp&?tj  t_& rT  r&= us0=6>
r/6r4.؋V@< t ^Jv 
w x y   h8Sh:z 湻%ZMh}Casia
qTrP~qtI	f| e
|u 
!tQ&9s	GYV
}?  ,`؍vfD   ߺ,AfLs-<t(<#@06~ h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`3Ҡ&&h`#֎fv*`%߂hÝgf9t0Xa` 2}   0 thb$q egf@ Vff3f"gf F ff!
!޾f3۹: 8tCRP #ܨt r1hf uf@q  00i{? 0    0     q'  ' D 
 Y/ bbk`osd@GY k/PS_.{xVW ƌ׎Ǎ~Qr&} uBr	:`_^|d>r5r!r\E@&=u	#0#Hr&ߊE$7u:5}Ȑȣ/z¯Yӆaޣ
Cr&a)rI DTtr&ge`4o5:0
T3
 5K4Sr#@itct  t$BffL  	] 	VQ
RNQ3q
]
Öɱ/i+W!z PJr8u`_QY?_ þL[ r&U߀þ'NgL螳`
Pw4$X` $2L nB0<tH`8u6
uBp & DBlTt
[aP 3 r/) r?%BB!7J@ 
; 05 aù<t

B J 2@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$v޶Q> Yr	2Qd'YB@Aq Br썪蹐B^	 fpb3׾S @ P`ңP@\`j h\  H h	S7諳jgl h`% `f= @u [jh hc Sjjjj P48 g\ h/Ö[cuqW?j&v^$bwtQ= ;tbu= <t/U-ݳ3 {_	hZt耲FkfaÐ    翴 tHuuu):p*< uwuup@ z`37jr! grπ D    r% {Z -Z=1zp$Wp_ǀ uu' 3?a re+ tg	%а  .{ؿf  ѷf tp/Y[rs3hƮ ڻ ڻ> ڻe ЃF  ~f c `W tIe7r=? _Ӌ~ t@_@t0(5@ MF t w0Ó3N !F ~ twٳ	u?e0鰠SZAt9A`d f` Wf3Q fY@ oI8. G"
 /2uJp2:!&= t: A%J |r l0VQ&ǷUq
MsY^D=^
eOf"Am	
q
6&:!& :X.Ջ IhBB 
D5@P w(3 ?  A-wsC"upml1u[	q	1D!IFtg$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7oR< !Zt'
QVJPf^DǪUY!Ұ.o&䧿++t'H"`Xtut.a:``s; 6sc#e_p_pkod6mooo#eooao
fobdasfSAMSUNG
 LTN141XB-L02
1P43
TMDISPLAYCD@EA0yV@1EM4QUANTAQ>0FL072qXL201	AUO		B	G08 V.1
BOEg HYHT@1B-120

 
              vȎ؎6ar[>e  >Y w 63Ҁ 07BA {8u!!u
( H 8u1	3ҋʸhkB}PW
 
t_   @ك
_X( 
  F    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h{Bt & ^[SO
&h" <[U샿VWƿF F@    䏚Y F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P48 '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 hB;\2%PFAx~ t
F`_^Q
h&7ss.&uduа   hb,$?wط h*"hD{ #h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_U٬P)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ p^ B  (xsqUmf* %  < ! 1C  3	 +QVW?u% p u 4  | = <t ;@C
 )(_^YqRWQ` Ê uUCrr3ߺ ڑ%ZAB rN _Z1SAWIpIyI
WROujvzKMJ; DE<}@ ;<<!<3aRu BMEM0Nt
Mm[VfPfSfQm~Pnf3f3nPn<nXfffDDG(	Dh fYf[fX^@t#
IgO GxnQRpA3ۻ9 r Cҋ7wB`s@zfDf3ۋfË\` 	
C  T U S V 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.h\[+V..^̋] zDF. P .hs:"XhW ؃4R  16W  0"Xa Y Z #[  
\a a _BA]a f gn'^a b ` `hcij!k qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ ߃-w C.慏/E2Pm?n8o7@W3۸  _f^ϊ߸^6_>QRrPS[XhY/(ȁ`fЍ|ȋh;
3     up     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10ސz@03 5 kLite{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"ɪx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcł xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGIuu!
kүx00POl}Dxe``
$`$p
~
xb<
Pxx txDESxxxxfD@{/10y}}r k ;K}d`xGBF8&x}DQ¯00xtxtyuup
*}iQb}ps ~aU}wޡc+*").xjoD00q x^Dx_T_xcD 
T e p# ) ,1_U
-&0!I	P1T?x"p2xp3T0//}@!T^ ^ɀ|$ u!`	Tw`#8 )?m&04`hb	рP	;G	¯"+u+$4?iq}T+}'Ư+p Y(++Ô@=]D,+rG
H
0%1vP7/",`]B0/}@j.J@ /1@'"  "+7x0&x+7x_`t 7"6}

P}} }	!Y	  @A
xPxt"xd}<}?!" * /}AZ#/00x )xh`xi  p 0S+;.TB+x+0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+Y[P>

pB [Tdp+$!$PI+-` o9
Q ` ðÔ2@VD0xx7x8r x008`6%06 @T߀G`	p4UHm9A@#ZKZa150)4"@W@W# KWQx,pTxtx?0x,Q?OC0xT?Tx*W-tx+XZ >TxYYL^ZLL&	]Wj`q!j0Qux^_DND0= >@  U>bgxdp&b]	:<	Zwg?h@jQ@*ARx-	+_SRNx*SMx+` Kh `OR0 y
0oeQ`
 RSUPP13 0X 0Q3]pd GXWxZAYAXNSXW }#X$0Yhp^qZ1ZTpLZ1u±
YZR[l0c1\߿\T0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ"c4"7x'D
 X /7d`!7g33TT?O`C`|`07`'`2`=`HpQx] 6uuuu0k uu0 uu5ˏO$pN`0T`
0100@A"| }(Fx]@C"+,/,E+p  +C,,+ +,+x,+0@qx!,,,++x_,,"-.?T0㧠L721t
!Mt&Ipd `1g	11![tU!(0響/0mp/l`
/0d@TpyE2A.-Ϯ/0" *xc"+xt`
o3x70x8NW7tP}0h"[ZYYcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~T@ 2 Y	J @ | @ s   ww ~~ ]r  "8_x4D` T ` D)tX@Dx2tx1tI-&%[0& &xpvv ?&xp[CSxr#$ % % "2x1 	ү  ¯0 $"@K~@3#b0"	Mx3C
r beJ"xqF`V0 p1#" &	x30$0%<T`Pw#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hpo`p$S$; yrp 1pxnv"x~0	D0⾥$ 6Ӕ@Tx~y}D"g0p4h4xlx}@ DT> 0
 pcpBm"pxt1xux|"xtx}xuxx|	"xw#xvPx氹yvxwf`Ӏ|pxw b( Qu⅍}B@
"{-`a"x-Pt %-o0p0p tU0/0b/{R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0! H `p$P	<0
`Tb" ! ߿R0  ZP!1D1]2nѧ2!z1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)nvpP*r 3}TOp0@0 0 
]):Q0`*/[JP*'2BΐP`Fӟ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$h' Ô@]Lp4'

$Y	0
	@À{0-$`
$`$p"Ga"߀V4#K0! :0!@?À-0
   s	!l2!
2xnfPYo0*2d|p06SU{zy f xovpW%_`gK6P2 ( 	4  E @;H	5345q3`	t%5544r	@ :0	h0_"06`	2A06< Lr@1k 
  
 *90 B? 6, 
jj	" !!`BQ
p0( 6"E^ 
-NtU
]DU C6.
j'	@bG+6,y ,yf-e2pO7)0	LP85p
&w0y		ay^	0
 ":"08;oGfpO:v!/c)P3
(.Cxm`qe`?0}DН h,g,-!a,a b}e"4xrMNOpxD  Pe4`^}R Vp0
T4d`$"4#ύap~}e4xd@P3 0
3 $`3`3$`e$`1$%7$`9$`$`)3K$pvAT nqz2c1[0TxvF>&`!	0,0)Π%m0Dx  Z30a 3\mP)6P 	@Rи?&j4!`Ҽp` pJTQ`xj  N*`/19xv
xDߐ}O`&h0{^`
}iT?DtS8`PpY9T~:wOq"@`T`M	0676$``$p``1e7`/tg7r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*_xFt pxBUB~xNNw}wxJqJpȏ:;<t/?=(x ү~!:%$t=t=;2!(0 (=$Px`vT"` 2'<x7"ү3y:; 0( ;:@ p0 xv6QxV86}'p p 7  %76(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(0  4 )4b 040@O453``/`@$pN5o4:I&duP2);P~ [x 
33oppG*L2]>gp1 ';P"T~ +ھ?T#>үd`pxH 8@22iP65b3e1@d@>"01/ 
m
`,R0xA%30 B1m
@
 0En00
TD?T@5q0	 3:@a AP}Nt
 u{2P2btl@
G0.
|@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t11ί23#.w1}p<0 $32  a<0 }
1pAR E}rpM"p  d.1BS)x0,\u`2:,`e4 t2UU.X5%.,*ۀ 2732pha,
$,SO!% *R߀5 
Q'x`S+0	+_-} )-R	++@@?@`p7v@}	z `@~{A0y!T``Y_` VWy
7pDxp/,LDy?N%@k53Eop;OCD.2qXTQu:93: !p	S31B3dUA`hy%%OXvt0QON@pHR/ N9
d.0
`0unX6Fp0X-64F057g0`5#O0]c6e`	S8@1
!b-1ÀI%P/;u1
p< ߀u1a{1P؉+*C{p4z5z5
3z?*+yuv {| A+? 90& n`AT0 +	al:hpd010mupo6o,/-.rpF}}0
P/.炅-rdct%,f Wu tq7~0YS 8S;"W4쑔p1BŐ}~BT񑾀_0=_<I?`$<p:T0Oő78e`pYל>BxfTAx`%da\z0  87>P$4 q"W¥A3	`*`uqq
r	1Q`{0
}
9"ȷrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLxpG3pI?u]1U^#5_`@TUy`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxlxup&xtPxsxrxxqxxp"<pxjv00,p_TxfL@" -4j0-TxfQf/^p0P -)^ ##--W--i C?"ߏ,u/212B0T-21Կ^ L.S. '5q,Đ/$7,T{AO-.`۷pGQN.E.NJP7Ĕk0p0Y))oy0h
P5
Ps|?`d7]}OPn,rt7ar4uN0f`a2Е
p1
P

Q "u}- 09rg"l  },n1vg9,u  A3.02.pM=1s0D@dTu0u`zP;DS,c,u.OB.` W2 p|0`u.Ta2ُC
.%޲TOлQN]03p	 o`` 9a :b K$ :}b)NӔ@6S ? x0!  x60Qq7TprrqxvPWU	Xu

		0
  `
7P"q -
G1opTrALt`>M)60.~T`@}w}S?APĿ33TBDWD  Axj6"@t7 C9xVxFdҢX`T`H}T
<PM>@C!3"x)¯"U\]@0Qq97F 03t1v`
pUr )J'' 'BP_P` qw0PM `	qPa"NO.eB"TOEN Є1n`=J=<A=<aYpo0:BP e0!JI$e:1PJ1E,F;KF	D0c
^"CO`@"HIOv30aA!Idp @0t{t A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?6 0 G=k"xB!CJ!A!B/)B*( #NA
OJA
MA
N/I
N+U)D
JaKaIaJ/iJK
I
cJKLMd`NPT&`7 v0uK K@ 
MLtS QPHKJ}i}p}~}wEAMI!9..Cf @"TxDT손ToAnp @($0*E;@B}@>RT`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQ HpH"p&bbrA?t"xbo o "CD)p3	R0Np#q*! * 	Zv\9V NXV$`RQB2b L$BaUӔ@UOaůUP0	xnZÀӒ }?U`#`5`2$pCx@% GD4SS [CxaUUT`͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@`Bpxr
T" ܠPt`ixo aav+xmv25rt4}pt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATAmAAD!@ab*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAE[9D po"tNA8`pC,D
 mT g Dۗ@KL7 &T #F87#TRx@ZEQ
-ha>W`cP A7O0D=Ddw
`#p`(`0<`PdP`d`wU0يU09NN!ǈt@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtx x#x> x=tp x@t	0xTВ^
}@%وx"Ttx!TTTaD	x?D@xTpT@=TT	_Tx= Q
@TxDp?=DDTxjv0}WCt QdMduR eP`eLO;K"x0xJ1"xg;/L"B S?/?@>"[$"tO>Q$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H鞰TY1	 Q$
 I`A @tR1~5HT& 8 `;cuTuTK0T"$`($`*`-w/rp4
TmB @CUMb Q P"RLT$`6$`!`0`?$apA]D	:3P
2 *}05 #N'/A
,P3`G`[]Tp]C"T B dpF{]K0$s `!DTJwwq/# TЪ0 U "P$pR_	PLQd`DQxgQÔ PQH Hdsq@P
qJPxgv@K K K K K
K(KJKNKiKKKKKKKLLLLL#L(L-L2LBLhLLLLLLL  L0
1v"xrMNO`u{RRRsx}e  x  "%m"0RZ?
R;: w"}} HG}0"uS@	0?SSST
TS0SCSp@z 0P 0@4xatgvaQ/jxTxjoD0@FxGxbx"x@$xx"x`}K}UIF	
Q@L0""3`H.xT| } ~ J4|Q_*N`PRR &NM
((sMFMLNUNdNoNzNNMkMMNN
NNNNNN.?PAÿ`P/~0"T? } 00xe`"QfSQm1PJw0pV	`~Ы50ߤT;2uQM0K  0P0)	OS":C$p
;`!/0Qp,"x?dP `eA3~"~7}e 0?ICR3AP>l2IQbHbQ!0M}EA@JWUCWa .XNY Q`lT0 ȑP O]0#0xD Txh!1?xxhvǸY T A ApB11u32}'  $31T3322@"O0  "龠(IW "O  p}"/*Oݏ}0/ÔP/pC0S00O200 ۀ"
xpo0 "pEox`B2345&k@"(t?3t 2xA325R4U5B axQxQDQGxQ  09t6x澐S^nS CSQECQiQQR45 SJSrSSS6x
ߎ/0!x
tP/P
0}/x
  x
Q{Px
m! $60#t #T %Qxs	}TBxr0xrßP2P]0 p%@$T$ÞPxPr{`1 	^,1^&,-u. <Tү$`&`p<Pq}e p%ݯ CBp.-,6	%xxsӔ@v $(xrvyr?xsP!  P&0 	r6
pxv 6]xa`r
 qP 0	,xx
xR!x	06Sɀ)^P$3tp 06d2S STT
TT T{T	T
  UB{pwfDca4 D@ @B@"xgDbU$P``G3pTOW"X  +Dm "z:hTph~`/AE@E U*@@CEpi O0~@ w 33TOB`pr@0"p<`p}T`- ,*,, F5@S,z  lS,`xevS,,"+,/0,Vd@VAx	` }wNPIVAu0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410ka^_55,?@xA=-  X60c
+p00_Ӕ@@6@0,	`	 VVWWW=WWWWWWXXXX?$XY%Xe&Xn+X|,X-  X,6S	XQxu/@xB![-.![P
.˅-`Y	
x3 t?e.pt Se-``l	clQrl"	`Ax@n}}ǅt&܀
+-   bt^w,Qev  q} pQ t u vAO}	}5!`N)q Q!q]G"P/u0 ,+"_wZJXXXYY
YYY3	Y:YAYHYOYYYcYpYwYYZ$3Z:  Z5PXZU:Xs  S1
tt)ŵx*#	
pp& D lT2Q@ST0BQ
b@Zl0'SPؔ ZP  cZP`!!I0~GJt(ಚDc4QrKrgQ
x)1O[`D1P
,1P
QJCS[ "gD `E -Pc80.u,,L,SÔ@~ .",UҰP#t .`
T/Ӕ@""@
u/$ -$U"x@|Ӑ T"o5}5$24 [2x[[[['[/[@[I[J[K[N[Z[[  [  _Q	xk`0/_" Lо 0/ 6uq(Q`Aa  " 0f33%$1A_Pe2pG22640!+4d	`d
4FPe"anv"q"44$`$`2$`B$`J`[$W{pk0[3P S0/V_rQR
D	qv34Aj@GG4pS
Hq
D""""0  ]v]~]]]]]]]]  ^ u2#^#u22b ! 0! ZQcPyA=r!
D\mb .u2UCE6r8QZ/0!rkHQ R 0Б 3P2"0"x%0T~t@]"@7@P@@	T@3"X O0!xo~ d P""0 ƿ}t 0	i^l:0x0x!TT`_Dp T!!{D`!T51 7ZxOD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b`"
% F`7@0x+ +axqa+s+I `C0/+xT 6 } 2.uY DT_`6X PcTT`40	61 ` S 
0cx	+$```9@=`xv 0z q DxT"ҎxStTTH_]+xS+<x, 6,@C`$p#xSx+}	x060/E#

0_ٌ "p.-Ô@-ӔPq @
QPQ/-$$cp50/NC.I}. 9VP`@\DkT ]P-Bp}} bC/..s b;@ $~SSN`R$dp[. .Qs".t dpDaQ0ӀÒ/@ۣ.ۡq xk..TP"-.{{ i"p#"x7"! 	ӛP_	0@@0 ÞǴd`PÝ@ӛ@*pشP:;<u t/t"/01234u5Pu<$t}5}Ю/[cÃcdNdhdddddЍdee3e3eVeVeyeyef:f:fyfyffg5g5gXgXg{g{ggggggh)h)hnhnhhhhh˽h˾hhiii(i(iJiJiJiJilil  i~K0~ %~ p0% pC3/}u: u; u<3{bh4iT330~P66
~ 6`  fR3`075u+3@u:u;}u<{xu{{X$::;<{&5hgƲ0  3h)g

*-K>,@1E` 
} P0C3+R#~ 0`| }` @^'_N#`#U#(
)"&

5P)*)߮Np<Id @(
c# 111{!7(+(/**81,/,h3/1/5*H13G1O/|@TF1RBA$__TWB1 u2d I'8B=9='8FGXCWCI˪EEL͸GZGUo`VII#M0V6P!}VqbhQ/"qV πu3//\Cq/4"$y`p!wSPpn+z @@ "@A~G`jPoj$j1`T}%A`"`"xs@}}TW} U  VxpBBxsPBQ0_$70#"Ap
| "%@-AOr+T 	 	U		UV 
 
W
Bxs
		 ے":0dx>T=@Q
38T>?`d퀀kP?>IIPw0=p1;P8i } P_' 8@
ఐ| $ >D H0
0k7d FEp6"}`~I }o>P k#@b!p1Pg0ڐ}P@ HTTn6 Yt
#Dp#0PB~6+r++/0
~IС2!_$QIuTl@&p0tV<.p{P 
41nll"14PmuDү1xe@606
 0ǅ~@60'Qk0e}pp
T?T`4"4" u2<0n0`~~^؇z0kTODt001p322]*F u1AD00ߞ 	3P)P08@PQ@`2VPD2B32ӷp087Pc`&RP@6P}`"aR3"0PT_O"
070% o03g3@,pe0`01?2_Vbeo0oP31!n10~
 U c`Fg9 	1DcA&F@T3`02`;:+"45775E4`546OP}
(4`i77$pTo`MӐ4`TM=`` `'p->T0r AE D Mi0$CBDyf0q BkZ	*u1au0)'2Su0p
1}ˏ}]34xRӝp2u2u0@*> ?$3@P20h' ac@'
L`1`2^pEl;8002`BTTT%%Oki>xEp0>3`D
` 
p	0d`0a18\Q]T?`<@7!?$p*3t~T9)	 #c H@01	a=2`fO"Fc"Mc#NQ$'NTRtnپ۪$	??
o)$	6
??Xu)txdd7eU"}{zy'Wj7u7dj12u704<t`u/'GP~ s./ds5%t#\vh~@_[tQrtY0ppT0qN`۔L=2t[	ÔPt  q}䑘o`k`z45ӼV@/Gk4373  ~v0((svrvww wEw}xCxyy{{||}Q}}~~(~I~j~	{ z y4k	5P4F w
QhST{lSp)1
3D,t~5{u4`u5 	]4T`p[d` Q?
p0
PFu	r	uzLoBmP[|| ax>[}>} pmiYiiPKß
Np&V$0/餙iz (
r67d6 N6@7/"PnRPJd0,v e5p4l`&{Jqw!8*u8EU| `z {E` @\]Lvv8999889p#!#f8`9#
			0				@45q0F 3t[c98(d`픜!PDA-0/* 
E0
jTZk<ÐIIP2SU~dLpt@W#aM`M8@_ɫq;mpl`T@
`r/@;ňqdNpt /,V+/XPՏYP7[ZNp7>	bUodpOpNCWWriAҞ/'P#^/i )4(?dn&pf1h<ARj=Q Vv>
afx?Mr i},K;D|T-`Mg0980,P78+3 7v3"27傐}3+P~ A| 3$`Ao`yc $)~ 2ࣁ)u3#ux3 7 dER tu`
/|		q@3jPt7pz9qTT Np: );4u3topuq$x347P1`?04bİv#p1 @On31%w@H0D?6Pπ
~΁~1pc!2B}τ,2"u0_
03{}@bY%N჊~N0
:>p2pPu2f	opw`8
0Ʉ:
``6ӕ19100bP"bxeT`&}$31PtP2"u}`q 
P"""ҿ4}t t tP
3U02	~HTD"LION x9pP
 DQMT":p
"aM~ d˒ ÀӲ  0d"0Ӏñ 7p8`0@
D 
~,T e8 )@pa"
,"`"x0 ?5"5q?"px 
WqÒefC>Ag>~ 0QR on`dx"7ud8X?`,7bPk| `  Pnp	84gk8$24="8Ϗ9F;u<98~N98lpe;N9E8 `vj@@~+k P"z _
pmq< &Fx33 d ::Ӕ@o:@>x#q,	: P,Y=x@-:Q SW<p ; B
ٰ|0P]=<>?u@`"H  /(p??p>?
>Pj+@55@@	x&T@/"%T~ ۀO7& @"`"E"x!To`	TT@5S73o`p2D"C
xCOpxa6@>4ra/T(--,r e,p,,~Me,`,W,|21G3>d$-t"u;2rA&8<9@Ju;;;`P9:0@}ɐl56x>F?M
 p|b?b6655	d` 
GI~G6CM"¯ DJptO*q+,U
,{, +,0+@^Ml@T` fOFG$&?^&xt
 T0xT1QT4TDx!CD@gp
0g1dpa_23%33+23 2@
{4pk0V4clN(%%q
O5 Z0a00*OTeVT		>TYAc~L` E#Aq""	߿F	 >	@2xpzd X LҀƀԀio3ڀʀ3łŃ 
`	"3/?$ ̈$ P ##EN``pEsB"P""): "P%30 "b``"  )"/33@p " 3@P"Ø"(p p_8

r
		
tQ
tX
	


 *72 	1	_"t 
""BBE"""ЃЂP  ts6 s$_Ń1" w"%5@bpp
s@h`_1p1H 1@~1v1@n1 b1VT1J1e 11Y11 p0p00p000#Vs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)    J   P DSDTDSDT{  HP  nc6200   MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I`% 
u	913213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[K@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0OA4
yh1Ы7E: \p3 D+Ba(80V1(@pwA5!ikp@"m7APFbA
i9DF17BO&$r8C}j80[+GG6C@:*BA7
@
[+  A8VA9Q AA$AC06D C>0AE
A`9`C
	^   z{` `za 0 
bw
t
	rab.C
 101
a )*ۤT{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` ?
p{z1O wip{a` rb~qAFb yC11	_9`pBw
h nc }r    AA3
ccFB2
7l
 B3 SB4 pBt e {ky
 B3ee} `e Aj
4a{g`ц xq5@p #b}e
eˡ/p !	e e$}`@dAyA4{k
 	``;}qA
 ЈAA y!-Ap?d1p68d ^pA8"9 9e@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
7@
Eb~dB	!ba'c@z!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bB/cnpyacaABw'C`C~De  dBߤb[FB9DŅGGGGD@DB6 7#BB
Ĭ@BBBQBD-_PSW%12ڡB`k (!`AD[(0@E֡ F C0c	C1uVm	V o	o	o	o	o	o	i	Rc	po	o	o	 o	o	o	 t.ҙo	o	o	o	o	o	$N!T%[M 5c#x`0833bý
o[@PCBO /@CC
P
[ہ5   CD K ECFвD`OлD1  0D2pD3z3D @~  PD5OT 9 62oQ
 U0D=:
c`7
 d 8 0D9DAA!D$*/D(D//*/D 'D//Pf!e!(. G!G!@($3( N #F(FX//M E0@ #F   //A eA !A N A GA "A  "c0EV/6BE2g0E2//*.3`03'3//@a0%1a0%1a0n0 a0G1a0G1a0@1BEtJ  JHE5	E6	
#  y  Eh`и``
`p`aspa!E60'E9	@	V`Q	``EA` :a'#B	 p$qCq С	A`v[ODPHIDA_UID
`{|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)H$+b1 r)4f;c!2r)`C EDM 	h13r)@ U[(iA 4r)$`k0jQ(5 r)3IFp{8k6@r)71>8B[U!a42[F21F3
r 4
 <5 [#"GP9uZ[@KF26Iv1(W 8E,C054|zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ}(FD
 h246 `U 5XIEc7CZKFF
048`
{i}`h`?{`h@48{i  {@ 5$ q\._SB_C100tB~ o._DO{Sq	4
` a![^ 1bb ha[Â7ɠkDC^YFC
 G E SSaF
h3À˚rRcp*r&R%$C 

 
h06E0FD	8hfp
` {\/0{02<98
PҐt1`0D W Q   P Chi82`
hA@ \\n8\/	F1 YF5 @E6|o6HI"7
 i 74hj	 5hijkCq8c.5[0h92s 1 0p
Л93r8F2! F)9
^/p´0kl3V+A p8` 2a{` 4aak0aB V Q	_GPE 	
R M
Gb bGf f@y nI10BI10Џ1!P<#3E"F

pC11011 2`
 3/_REG(pipp15
 a	isa114[J  s@@p!15pF16p # 7!U8)9AABCD`,11F C12021P.22Q 3W 4s 5c[62789 p AB*CQDEиW130Q 1 2R33435^A6 7s 8@/393-BC DA3F 940Q q4q43AZ145f346Q 
484 Q4B_INI U4C QqCq14E[  IF @C150:p 1	wh
@axa
db`t
@`TP
a
`@{}a`*
y`0`g}`aa@8 2] azw`
d`xr`
  
@bau .p
53
q 4s 5
AQ18 \0A
Bw15C2D
Unknown 
NiMH 
LiIon N @gSxx>0
  awQjq0B {/1(`0BP56
ha
D1072EAV57@`	9ʅ{}ha{a
//55}Q953!
 C
p^Qw!4!xA15E	@NP An8"F	ܠbBp
P?{`~`JI860
[)h`pP[0F`
csc
  dzi r`a[)absdb1/2J!*(PccC1m	 hg3
qFg
oU35C{`g@`2& 3hC N 20Q24pa4h - v127 w"Aaxra
c 
dcbpbNb,Br	39`a Aa$(`a0-.q-3g3]IX65
I+Ep
 AyW 	ip
Iq:/49."2AcCcڄE c6p0 f{`z{2``EFA984  9H2ccdp eבeez
cpecpci4%4 ?ns 5qp
g5Ap
IBB`p
`D5A!k!22C-@!7G@+yN)0W1EQ-  
qu>/
>3  P2vpzo
 5Wap%*!4(B+BCF`*Pse(a6h/UDD	548ata
!e
bzch!

 

6Baa`i35
@ ra 9PQ paupaHPf:ba7h6E50>U88@EFR=U0c0r?11 [
068rAч
HP   a3B
Sp
SIMPLOySMp
MOTOROLA a`wK9~69
p
 
Ajr (_Q03':Q{BA B4u10b@³p
a4aFw
bBa:l!TZ6A!] B['coTZ3_J
6pn@v
J1a6C
[PR0pY1A 
 1_2 N8Et# 
BDT^E#9nO1169_D316

,
{ (i28Di$ŐS^[I0sFE
70
N 72F:772 s730  q !7 FU 89AABB7Cs D Eu78081
W[  њ81W8388 ֠86888lא89҆861Ua
A
!86M8a89Қa` 79`
A>
 8ApOpi8C8DrA ằ`gcCba?Bc3gEb pa:A
DA80c1}8P ya
 d
b
 bdpdS c
 c
Нc
Aޠ8DB`8E89p`kaʕa
v2C albab`b
vbyb 7817Cp`E7B'9q !E#!AdAWzj
!%FD8W8A=@"Fh#'7qbb	aq bbQ90Q
93ʪ56`61
736" 56"
q2
{C039
`{  ia` `!Bhp!
`!K93	+C)haC0$b cvU09abcA@'K94 p^^5cIX96LB
97

Gy 199 A	A/ PE99d797[B!BF_C  _DDN
oCOM1!9C9D6
30Uw"    }8y `NS  9D__STA +9
`1
2
 ,+_DIS h038d39
F_SRS Vh
aE7 cEr?e)r9C@
_C
w9

` c0

n$LA[Q9F   
0
_ON_q1&_OFF qPR0F[LiA0SgMףF!# C
_G 0" *
g~c+#[":20"B K P@A1b! !P~A2:^<!q1As9E8!Ah!
I A *""	0CA6
r
;pX?#0A1s 6$JS2$$$30%2f[4 7m&i&!P'`& $A7[Ce:$8@?@A9p`  @?AA
;."PrsFQcjR@AoAABIH
1 Gxx&xx"q)x)xx) *o r^r_ _u\,SSABS`PpE%SSPqBESASN?3?303LTaX3Tn*BGm3 *do3tUb0rAC44AD4?X4X550Z5w xxcp
, `0AD@܀rA885_AE=_75_?_a =_PEX:E)~5AF p\/@uqw023Cy(ǉћ`{vz0 1tP|[OC1Bdd$5aB`` , 1B3  (BB y
G``Gpp 2+B^CB4
q 5`BuBB2B2B6[k% 7# ^"  y s8%ڐw@ @ "-[5ah
 
 tP|
     *"P9tra a !-AE
0 p Gr r " &` `0Gd d"رl0BC
" 0A [j0B")UBD`a  BDBE&O.    0[+$C@
  ] 
 
@D?DC06`gC0ADR   1C1
Do
[)C1wC2 ГINIsoC2[C3u4QD C[@Q5-a {T335a=|,r:}d%'C5`0CPPRW
	
[N`cC6"L C7A0`{+` 7кjCB@D`>C8 p[ GGPE_L1A`D
C0D:	P/PPA
@0
0?
	_RMV O*_EJD @B.!LP CQ BEQ F CAQ B$; C-  **E (D% 1S	p>1
؀9t
6S3$p 4CtO CPCN

[AA
c
,(A_D#/D#	0#	
		C						G6C0A6D6!NЪDx ["P8u#9*N_GTM p
L7 `@A & DB Ca 9D lDEp B1E{@@(0$B
DA!7%t10A
 
Q0
P
p
uxpDD}(E0EPDCRqDC
C`ZMhT
hT
hT
hT
hS
Fi  `p
w/Fpa:` PA` bwb
bw`
cib ac  rbO rc u`2ab62cEo0bca:6\ !{ < f0I 3bL-@##?M
joo
mjfjockoa9aPE$F  ,F D8RBEt3|Q
_PS0 3 O2PbB8X97a	
#  A:8OD9ODAOEDOEEOEFLpb"\_PICеhB\/fD6M`T Me6E

jTQ5   *1`+
C#E PH 
1

 GCg

 
	
Qa 
		Q EF!	A	
la	5!52#q "cB%i6,!!!! 3c  !t!!G  !Aap]64@	F/
R  pd
d
Pri?mary 
S   
LIon 
Hewlett-Packard EyTraveloka	3x@ 2-5vP~L61	^0061h`/`pO%
 

" 
 
]64haEAA5A108!axE5"p 57ha`3hP6 
_UI sO5F
_BI^Q  ST  CL\qb[Gr6;6_ `)C ocrdJ6
ACPuI3	G	gR/005`D 56 $``A mp&Q_PR0p҂81`ȓ`EG[:@]
 LID`ۆ-8@ 1F
	/15?O@SX%aN#/0j"#9 EA 
 B@ `0kpyk`ђh`piaFa?0EA a{`
hs }aPap`k
  pa^p  C B 4 Ò1  &EDw x

.   ry `2` |hp}
נyj    )>b1`h)h`a!	` ib`pbasabcpcau`a[M EQ>F! a ?F0J/ 1iF2 F3 Q4 F5	p5  p
`

 P  r
` a 6 7F5ee[0wre
 
8q0R2BpFAILrpapMF2SECUp,{AAA3aA4`^P9bLwrA}BRC]D-3hP
cEcϡp
W`B
#A34
{  QEFt
-A	0FF2`B0201S2_"2Aa4nB  Ju%a%SIMWa6205&O  b;2JT7˒`A1p0q  `|rPASSA'$0$aOACta`4Cap	 a14E> ES?;P2CC+a>bb`a`B b ub TXqy20q _WDG?
<4_c,E=DAAyB{M4C~ !f )AB0tWMAAuF1ij=10ytrR]p{ 6T@rBQ%{h
o`=v04 3^*`5 k047$l20854
`FI ) A1B	g
p}i97&* q}#-J(͵((Cq8Cm;{_t68 
#A/Ή	3	K49E!h`64r7h	"x_WEDs%%{WQABNwFOMP"  P3:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPC!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9c@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H00*)'XFw6bL	=֐X|gMsb31/~[A70憁x9->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9Wq
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[ސ9 J000[9l[#\_GL_yh@04B[pipjbk`D!04F\C0F1hFPl['['`[A

[ BѸCD bEF~C219DphDUCC4D@ p{zh CFhZ7	B E  C222BEi	
Ee3DF	P[ED22627z 8 9A B0q2C @	D rV9@2E02D
[ F@(q230!31 h
31@ 32 3 `UyA
	`rh``vqF342FcPdp
aJac
``{rd b}y   baya
a0apaňceraye
	 evepe8c ucdcM
5q34cpc  bpbgC	bdp apbe)ecPe ffg
fape`pfafgvdueA{`b8` gT`$b pg0aogg7agdMp6,0C5A ,` p0`c`ebQ9 A`y 1  CH`p D "h 8h H
bhc `r Dcarda
e,2B-adft`f	ru'adSuc2wftd gLr:`4bA 7@(7 F2ECF&-091536`Q&BaqD2Ca
_INI<37060pibhb0-8p0<3_8rb
D9
Uj19A"AA"bF03B w6
arC019abpb.0+bab`bab{uaaP `bu}a/_CRSQCQ19`v2-B`T`_STA t
`}``6 9XD!

	     y q3@=[K\/F23DmHH
Y3EF
RG{GP   @    Ps3	0	  1	 3E[C\/*240}Q [195F
rG G$ $ GN N 
P P Gc c Ge e wg gt tw  >  P# A-\/[	B0a


W!3p
`q ^^.C16F4\_S0?_
 !  3    4  5   M\_PTSph%_37Hh
 Lh
}	0pz15E`Zb1E1 5A$\_WAK } 4y211AP%10D0BQ65@6@vppTZu42 TZ1_
 2\ :A15
a7
kp4@35b>F

Oncbcc:c6C
[1:PR1:0p:1 
 abw56j5A6C1D7
 `?0BAV-C1.2N3n4
 ,L\!P43G,
6

0Qnh

?b [
p@
A	0	60EF7

8
93`0YQCD:JE F2W @50О@?ApT16Bo
5`1
1({!h s! ;4FiiGi52
з気p
'>0$5R``Epi_Rdp	DP
3
hi50p
`pi``
p
9r#ip`OBBp54@`phaGhAw
hr@
!! #`5i ` a 6&NEw
M i`Nx1`9pK|CJ?QpR
   qqt$
axa

`b+j0A0
?
bt
 2

	P
!e
 $/L'6	FP #dpGdA(1p{43){b
 t bbwb

araqMpLa/]&]!1b`OR.8`a)a;R#Dh 11$E$ 0ży
h7I{	{a8b  a=pI'h ax`%  84C<`,3`a$́AQ@7`hh3_
b Ac'pM΀57
0*h w`t`&`x`of0f9{tfQf .1tq"+cbbS+bC&8!6bbFiq

ep
d
pJ d&`2dT/3e0iYy({,5	B*aYaBa[M58rU
_$_ON_@B!а>H^!N2R_WOFFO3@9
6Q
	AN	
	5	\Q	
B
yBcQ
[QVCB&3 0.58G[" mwDHE9CE ņAFB[HA_ALCr 1AL2	AL3C
F_AC0 "1& B2FPb3fPSV8SLA
G`m60@fBt=(BVA4C5pQA40!p
^,48$Z8SQQ7_TSP
dp T0CRTЏ0TMPp5)0[WG q6 62

,T"3̱/$QN\_GPE!
3"zO
_L'00 ol0xZBPn <pOI{` ֠{`
`aR &C`P5 0o3Ӆa \aJBK 1 I{v679 !I`xCBC0D2n}ACE["
d@`fa3Oz4I 9 HOH0*_ o3 S/oJ3B60RC_SDE_G_L17 !82?`}6@2lJ+1C C8t;z0FeS{4
C208+1EEP@Uг)7gE@p89!G_w65 +D|`@E6 _FO98`EO9 \64uMC	> &'66!MpGD`ܾrR8o`!F/!Y6a82W8МI_1F_9`E!_'.`"""<`
`
q###H0///*L
/	?%1%h`m097bPc@e0Pӂn+{a+kc{b%>+dP8
AcEcD}Co	5-eHP408 
646A} C015
8`l
 ~9SSDTq qHP  HPQPpc r  MSFT L4`6@	1 ̔   d   #_f_T	_w 
_	O~7wj
o
a74a8P]9P68ij 9  Ahf52Ed62F .26A_2$'1 Jmv<3031KyjE20eF3pJj9иC
D@,bוb`h66a bub P)192`20E0h F2E22rDy3aD,
b+`1 y= U  VE'*[F_PDC{ghP6F?PCT 
16Eq D	?_PPC  MS6C7Yqi7NLP27}}6_EJ0psC7 A нv _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ          VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
QhE@ Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &;&E  ظ@ P ^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PAƽ.TAA_fXOAu.UA.TA讽_f.PApqKKKJ	JCK9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH Bh3\uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jr赳r TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  hs* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x      d ưʴD` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7h@ t-u$ظPo hh Lr 	uI[XˠC'P{e
.> t
P ZXPw Xr$$
0
w5 r?x   hP Γ	ruX0rPhBfP f"wC 
 f.|!VQ6'|6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  sϿ ˜0   # Zq	t a*u'迚 4,4 u.>.} u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.߃>0A6f.R6D.VffX QZ f / 
uf.R>r>^)n1  p ߁Z P3~r# Uv  z Ѐ~!f%#6 .,.>>6ˍ6
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP
.QX`0fZt
0T <f%?'f
  TPV!	.Q~

.
..GPWS ^) 0 MSZ.&ZπQ<tQ .G+u
@_!QJ+u)``KX!a @aI	`b  .S	!@%"
?f8.6V.6If#RAKf6Of3ffSkAor3$tA^`.u	DVQ
6ˇd dTt	6݇U  } 4
tY).V0#g&;B*R'Z=u EVW>ˆ菭b& _^FVW~ +䡍>Pdr6>]_^HPx_š pfLfVfWw>ߍ64 /t 3ҋ f1@
G` 
t O
twQ	= ?  68) <R se>uf_f RfYpo/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|ݟuYXP E {  F>@
>W  u
lr3- w|HroQO
8rK<?rDuqr)W.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVߋր? t  %u
3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
ê<fw<ar,W<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G2e-YE.p"PG>q޶BHr
x6ta >|.s<u=0> <u  <u0Pvr).a>PN{ÀssDQ w?QB>@
 Q0s?^P2>BoNYѓJހJg&IҧM 9}rqWGJ@6TMr,	fNfOfAg&@ ?S2fffXPtw aBA@i f.;iw- AZ r%&Q0PPY tfGɰʚ
>A_ r,f
 2mWT)bd@ r@f؀ffFgfd# 
 .႐S3a `t
~܃ffVp xv"  u $P.ߠ$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@f]anQn90P:P;ق651.=Q[ {fDJR_ RQ T
T
{
 Z Z\$
fX Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ~ffC*** Please restart the system manually.
 .<t$
  
$!~$$0AD?O2撰撍6ŢҘҘӯPE@> Q1Q ػf?tuPRP ү ntJfp˂a T WFOP}tO@wX >vTY|YfPQUGPF >JMu
,~2 6  POX]0qUf ]Qǃ0ŀ@Gbؾff&f&  G>̀ fG`GGaQ6VfWf>҈!f!Q =С ffD4D$fOЬV 6҈fP ʡ  ஀hG}$Ph# X[õ ޥߦ3@$<sA|Yr.ˠUrO ` SA (tD_orq XPנ"Q!f/0ѣ!EnS  gf /u
> up[PȰ&  cB|`&Xq!og= Bxx<w ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+ s q}6ppt+Ȓp+p
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;0t
|u. >
f3EG.Љ.fEfGЈE
G
.f$ r-/te   @ -@.Ѐ tP=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCsq?s6 &- + aGp }p	, 5' #  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6
 `F
Æ  fPf$FfX    E	@ k fQffD$ us+ؠ% si}
uFD4/ E}t#uS uN-fD~'  620( iQu K
߀u#*
f	rg
1g
 _u,	 1q/϶, fXfp5 Qߐsw`psY+5 < 7 6bga5rq_~ie@ aȋa8s"s1fE-p[!`D1S
چ	侥!f+B>sQ@"*#%>d{D@@@_RS`rfe  #bV+^	sF?N+R!%
!p	D
MRu
HaI I7<&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$ ,r
.`.qFbb$)Z7+P1wPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ ttt%EEw)|CP{u
s
>c`uF@F2	E TEDDd%=upQb5AIaR-df$0	К(=(t@q	
v+Ұ=uruQ2$GrStY0< 	("rLUY!
R"pY+C J g'S ÈZ1"b#SN1NsX`_|0^ eVfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPʠB6X
TA tWA  @親tAD   + *2+*4+*8o+f5c|- sM?ȁy@ߋu@føtsPørcwp d
q wt ?P~a slc#fEst~ a1`6`%["	
Kѧ]&rbpBb
Fÿbx+si ` d
` p p P" }߃߉ߏߕߘߛߞ uAcA s@E
WV6g4Fg^_rg t 	p!	
  	M
fw_ord db q tbyte %*/" Q ptry  WV.t"Ü6@:s6J,6K&ps#!0RO_Οf^f˕ fXPBXP $0<9~Fab !Ò  s봰+   1$  se+s-!sf    n `@  c w     e\ d  |(    $  ' ( ,ܰ / 0 4 $7 $8 < 4? 		 @ 
/ H  P0dX ` Wa  b  f@ c & h  i +` l 0!m 5 n 9eo ?p Drq G r Kes Nt Ru Uuv Y%w ]x `y c5z g{ j| nE} q~ u	 ylS
8&&#8 ` mf 6 (0 8  |UA     !k  	    10'8 0 % 2  , '  ߚQ+ e #,   u )  k9װ   U3    4   u  ص e 
 5 x~\
8 q/  f  ( 8c  /rð T s  ] 8؃1 /9 %˰ t/ #rFͲ b8 '5 ,$ 1 ,
,
 
b


r
QL 7e? ;  ?s*Fw DD? K w Qe V  [Z ^  (I#  b%  )`$ B`  f k qu v% z8x7r ~   f(+m08su0ZU  !w ! e"w # 0^D8 ۉc b87(be0٣@9 s  (,	 ;Ԓu tn ,   ; e q/ ' 	 % `d$ T  e  ҕ E sj	 ݵ w e @ 2A 8 B ?eC ED LE RuF Y%G `H fI l5J sK yL EM N 	O T
8 ށ8(ݶ 0f8Te e   y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 u$w1 %%2 %0 ̄&8 w9   e  	  e   u $% * / 55 : @ FC      Urڲ ! $e  ȥ5 K9 O 8wSuX% ]v0b5 gv k&p u zv& ̓(ɧЍ󽱻  fmv&빆쿶6͖mFަ	V
f
 6f&v.&5v:?uwGL RfX^	eU
Gr|lBp udz y8 ~sf( 0f8ݚР ़`誴 7 50 8۾(l8w8u  ƶ (f08t
ܶ ؅s'8 $ $`}$80 $ 0&ڻ  e$
 0 008  `o8 ˶  5!  MUadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl imuP nsbQ  out a  jo Kjn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff sa lQ 0ss stos lod cP
bbb b rol@ r rc cr shl4@  a@et`^ente"f`tA o iave`md xla@oop q c fxzQ jlockpnea e hltPc t ne doiv iQ cltc i
i d@d"xzx lf0gpsPl@`hrd b{sf@ r bt0 sp  c i x!seP 0 P b zbb p"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxf7ld1Q l2q me1piBg2nr z f2xmyl2x fptan` as re>xtrac.s0
f`/ p.sqrs01%/frndq f &+q
ucompvPendis0	clein+fQTf /wesc
env
cst   fre0Q /ar(AfbibC

;  ?	A	 r=fi2a ( wbinv%w	a ::ob @? 6 s zs 0@F@:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm ud2 wrxO .  f  yz` {|F}{.s߈x{33	t.dG
U.ޕ
EaF,(-)*d.V)PS ޤ[XFe{$U<v{$tU	&䝀$!!w'E t$$$I4芥"$Q(',}fU$-

迾E%$0c<5r1<" t3"$v74&)6+t06-U0{E#3$6Q9uF;m>{'A0Dt+=F&_<JF8L?Nt!ޕ@PE,S{<$VuBXU&[UD]` 20cf^1i*l
nޕ+q#*vu
UJxL%{E}G/轆'0#dPPOOQoIߑϐ$TT<w(YU_WeC}C'ICߪ<kU&@'tN^86tH`&@  6 f3 t3Vv^

ѷSQW.8
F  1 [Fn6Ff.0.>0QHY.&f.>R[  t8svpJ $GG _Y[PQ.> t7xFYX78eF PNS?r [!Hz %NYa F߸J2 uQFoKEMe	$ <t<t<uAE* om"ME' ;蜡  XEfPQfRf33JFfZYfXSt[OABC`mDP ҀQPہR҂S҃ABC DpPOP R S c?[ QSWP..X. u<u	L <r<w,@.`<  .>
  <  <;u.À
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&R<[pOp?uu18xf;t'u_G2p~ .0
_	   h"=@ ῀ h6؎Ѝ|ȋh3     R  O O      8     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c aci`r  a ee  3    0ƅ00
hz
``;@:Wff > hp
襠 DfPff
fр aV'WA+S@)'}WŢpr;_t[s(`(F?[_^aWf` f vrup6ffпfGfY܂eh R1Xfߊ$
(ff A	S22*OPr'!$ 
 uf 8s֊ҊʠXQ;RP
t0k^r#XPX  uf }auSf{UPfPfXZw+ ]f0)ff]rff~m`e>#n z= srscB
Cb_ 1f^ ɉw @t; *Of@I}kw ; B)ђu6ѩz+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pgs>!f0rRg'QSVfNVFf߸L z^[YrfqXftA3PXQM| N OPQAs` XPhWU豐^PԚʡ A1д 謱 ]dXÀ-p΋_P^Z`Wᐊ f_} mp_p0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@n{
rf+Br
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO 0p`XE)t fat/+f %#fSfQ<g t0jQ#2" aʥUt?j$7 3#tcpզ0
ð-@_ɯWV@ ~WB Q Y_W
t^9l	st6]V! <5u G	F^B^= ts.
<5 = 
ut	>9rF  Xf[2P
X^#WfVf桖0t
P Er&< u PpÐB S {f^cô PDXs #S#q`$$¦)$P.)
u $7 C'ð) 1U
 ? 2$
Ǌ4D O $ $
utpS  Y uð迹Q3)3zð&pFa
!tt	*tEP6Q/S&"
ǆ['~ <t<!t
<P	<*^Rp`@ ZQRٿs	 2
 Z3) ӼVPލvS<û	 [rqkX2A^a
蚯 ð!R7 $VfW7 u؃ t迦r
Dp<A) @i2@e^PD3L|
u|	 t0  $<<q;<
Av^À}" }} ؊% ȑ؋ *0Uu Xð2HQVWP 
M0Xg_^YaQLpUP2b׾ 2LB2`|ʁChY
P'֢/#f@1!QWëWB12	R|@1 (S)WðT)ՠ Y"5@Z5. Qb	U27UStf r.]/fd 1ir.f% A UCES|sfgf q 3K 11f!u%f# k	-Lr`t s` u `ZPKaЏff#ffд f |rffap-Q<t2f3Cr6
+{t g> tt <r(WPW`Etf uKYf@,
@zˍ^4踎t]?t
Д#rkz o8Y-t(gr?!f1 t
J
?t:R!4g&?#zzc裌@x豍8t , tu
@u$߀2H)@t'@u'-*tp(Wt
 /!- o t> 7fAu2B@[Y a33q 
t@  t}AfQߋXri/p/B/RZ/rGU/Z3t!X@zx$
 V`{x,sx$z PxZrQQVQ@0fF3Yf^PS0x7xFx  [Xx$x'x2wwx@w$
ww  衋 蘋 SfoP迋4fX݂Oش ( [SQp}W  I_`¤ %_r o^_Y[茿rQRV3Ҁû{ fFKt
 J=8u 1C^ }Ppw`wf 5 ۨЧΑEЎ`UD@txxAl4v0X4v     S uP $@X锿uq@@x_XeT$[kHtu
߂I4
<RVW041.1V2I cI~`Q<VV<WU S8=T `ՙa!fP > f f .!6	!$s0 >!upI2!f2>.!f@**!JIIf  0.!d6IO0If*!. .2!>2! uQIP&&R"qu;`a  a3@0`
?
_^Z!   bY[Q1V_ ؾaYÌȎo>,pSpz"ucˀc!3r}4 rtb#є]i%i%za /  i%b(i%+i%S
!@BiѤK K(K}'`1i%`O'bgg5:&d/i%D	i%	+x&u`fW 3sA<f,0u#PQp f3gf&ff=SCAFq_U< u
 	<! F ]LaD <w&'V3ɊȈ7CF`Q 7^	ǐpL@RVV<v^}.
t" 蝽B窽KUe%]dmU%P X:&s.V Ou ]ëkkA   1`& g k<뙾Ѫ" 5!ѫ {"#+#?##k !N%'d$%Qr2q"S"4q*yނ Ч["2ɵ".Y8 .6t&3`S茕PPS3o[
Г47X舕asɄ3ɺDrñPwD3΀  @XDfPAMuSSVWrf e`}] !
 0
@  t 	˻ʆ\Drr ɍvp0u& O 
 30&Okˁ֜FUWn,_]v
K`  _^'w 1A6Ip  MB RWP
$b, D +&= @
R,&zGv1:,v ,p cu#' - |-&s` 
;Arb-f3ɐ"frl..&' 3_ZGF< u  u?2D@ sN~ t
Spp[@&W! hш?f8hi@`  f^   H  $p `| fl f
ր艐ā rMf[15!0of% ;tfwf ff ᮠ_fYRfx of 5Z`PXfqc``d  5oPf<~fQpRef%0

~5|DpB_B3En@16v9AnҾ wf ftp" QBY fh| Wfҧfӿ 3ff1f `Ou_f Wry!?Wtp ?jg>c>m@rQ>L G B = 8 3 . ) $     ͕0/q_QӘ&GYÀ' ǹðd ,,.,@ n,q , ,0 -P e- k-a -& @ . 5.	 >. O@ `.Q @ / / (@ =/
 J/G @ / /     	=Hewlett-Packard 68DTU Ver. F.05 04/13/20 /  `w[%]  Z  l ~rq oKBC
sion XX.XX  
 _
  _ 	o~A0B# p^ @  A U10 Intel(R)     rnal L1 Cachea Wbi2e	
  6PC CARD-Slot L
 8  	 www.hp.com  
 `   
S 

`R
 @ DIMM #1(28"t\S
~6)"Rpbs "K @],No bat y'+"p
/_  k$Wd1_T*u	 Er
yj)Ӏut&  5& A)u&
u! À8W@ AU RtY  vMuG	0bpoRu3uOQtru1 ta0> S:u@8*6Rw:EFu E0 } jQtTt̀t߀wEtH71F )t%> t:& tSuEu韷3é  t p_E>I q u	PXuP3 tgX랓tS%yE ut0#)	&2!qP=EwPÃ*x3;r.Dv+W+Xu432#*u!.ð-*1!	 2&<Gr<Svƀ Ê,Gzf{.#]fC%J u$
<.r!Lu24$`.2K#/fX2rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EUBQ C D P@SI Q S CSW= D@ E S }I1xcept1t4 - Over_flow!5Bounds Check6@Invalid O_pcode7 Device N hAvailablJ8Aou` _Fault9Pu Reserved	10TSS1SegmentPr nV12AtЏ V
3Gener~`xProtecErrorq  1 =  System Ha!P}&

-XÜPRO&< tZ fVfR6G4Fup_4/v}z{4`cP4YϿ64{4t Í64jA64` /4T ō6$4J6)4APǍ6.47XY_WQP6C4$Q34}Q74p;4
6?465F
04t4_]&4x5na75WJPW5o@eb[YQ G; 1`(0kX[S	 65 p C8BBaa<aa$at@0 ߀dFfFɷ͋N
~fE F Nu3׺ '7ȷn ]
 RQP~
XÊܹ /FFYNZ1A`QjY`Њ  aÇً`ܾ9"ԃ`9 & ߀G.9 .&7'@'dQR{p Zw
  c Z 
XYZð
< 
7 SQR  ZY[S r  `؋  p 9 _  K Q!
 	`cuua@ ؀ `
UЋ؎ ]`a	]ߋ3G
AF `P C0[@q$9SRZ[` $<u 3 0ؾ   fa3S fE^Q6 VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYX0P@YP\UfWfހ&и`1fWZ]7f_ff_]p_8f <u ~<  u<~  l<c<@%Z<	;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2\Ϊu_fQfRVWfSt$ѻ"r   f;ttN f[_^fZfYffr }  u
N`o1  `+ s r 2fSRfPmȝfXZf[N/ff\׊F׋5	vf s"s t s t QVW&= & s fPf&EffXPP  _^YaJVWPw@P`;t
X2 *W 
_ ϰ#tPX _^!DNp sP6уufQ fPf)f8 P8s2fYZu< uEuPPuuZ\?PPE EPP runtime BIOSVers.1  
 v????*@Q@v@@@@A8ADATA`AlAoArAAwU .6?]?.Z.Z r  R.Z
qQRP<rt2[5$ԁ !Ȁ
  -" Z`5	$vY p[	c	uR x?uR]>] SUUU.V	`&n ^2CʖF CUW	al *Z usà @: U PSR<r
 j ?Gpp0^r
t<t ).>A 
z.A 
y. yP%PQR3uAB$ԡ 3ZYXPStU"
ǐ%{U[1Q \aw\Y`p*uWt= (u^
f/Ue(Uذf,Ue%U20 UUda VR*txSR ڊZ[  Z[Kwu? gȠTTt%p0Q0
udB9Z^`)u={u8qBp4
ً@p 2 茟0URD)u<1u7Gt)LEtڱ
@;Z]PGbXU 
~ s ]?`K:KxS|Y {M M>rQ4Ys\ PU( 3Z[x0"S`"<P3
ݸH 0ٸG G(S QyLQK S
 pN pM Rc'
(<PdVEEEEFJFFFPQ&` XW<ram .E_Swt 
' t r
2[e u0^r!<i	rr& Qs" r2.
E2& ?r $ ŀs  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9 f" $ ӀpQ@	Pm Xa\#t s}q]@t4Radt= bpt t
@uYм`
 趨Xr`QPPPtQXdYQPnQ0 t	`DXd$!<!tQQQ  q&@tPG0Xz@ػ (`<u
 @&   >!@tA AuqP]O@0  ,O & ]XV߁ @:`O  r
 P<Fu us	|` 	uA
 fu	 X RtGTtu`6FtEuUrPRtK?xGr t& 0R] Zy&Duh7Y h0 
Xuh8rX&  U u@ ϡt@Q!	 'rr
Xrr< dP d@y  $& 8t ߗ  `{QX uSQ^ `b+~OH `*C: 8E8K011 @=@X@3*OC*
kraks\i&D
V &Dt [k 
B ?$kr!0rLksujF. u?jjI$jrOmksWJʊKZ Sjjrpkr
jajyoiZ2
 0
FFt N fF" B@ BF(	r2BB2~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)tЎ r4F$
Ft+ F P   !VPпXV@"WPR u	ZX_PRARZX    0 " p	C  @lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Intnl  PCI-As B C  % eO  ֨ H	~P 	/` <M M` c!MF	M M ?MCD001EL TORITO SPECIFICATION OVOdOMO  A " * Gxx  x y 1 " *
x"x 0   s w_X _y\[8y y  ÿb éALT EtذE
U q t
̆r;0 t
srÀÀxf`i2`tW &  d_&E3AB&U
&]@ &E`o t ûO)u0&E@ !\f$PIR   ? AШ i j b c  ?`tr " a @     0'c00Eh
`3. W .p
_ϊͻ ^p aVWPPS;tPt[
D[_^QW3`  Qu  t`GY-h /$_sQV.OP @ۍ60P.OP^0L @ EB C KRRS:SAS/R=Rg]i tg}
3igE
Q uQi} 3    SQ>u5$EôPܬ% ׬r!</3ɸ 
 3Y[fPfSRV9i&:iX8跑Dt荬t# z>p렽<t<tƝ< t 3^Zf[fX\V  nuۇ P	ir
- ZkQ9Q =pc
ujh2_hgu
#p d,,}PfdfBd@!{s dMd5 d	 J V+d,,d<d;]ttd|d]^  R 3
' ' FǠ  F/T3 .;v+GuBG
`_F/ {@PR% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFS T׆[U uPZXd]<t3 r
tVd4d8D^ua;RWue5es T^u>0<`|3&
yt,ـ Bt&M1&G&a
ff`fLAAAea+Íu 2<ytȃtm
 Q ܈$FKuðB
u	ۍY;YuS؀unAu)@4  RA  @[fߊ$f
ࣀf BRWS22f0}r Hu :8sߊ[_Z?fQWRfP
t)P0r Nff  u 8ufXZ_fYPL r3r: t+a4 v 
th8t	
uY0	g&;t4g&Ct,g&Cf4$<vf f٠
t
g&:#?tfC1	fSfWfVf޴r7?fg&p	f`r!f`Gag_&O@` Nb O q,f^f_f[Ã.Mt'} 螊<u 2裊h93 m1qwqs|w۳s\taVqs
2  憚"  |  j u.D0.D
 U~ ``XX&&D a0 м @yj &&E  މ3Լ{1?̉QPTP !X0`.\.T	Ǎ>.L` `vba.D`tbaQPƌМPXXɎ6aU2V3V6V~ =@} " AU-a RG   ]*[%	  P` Gd d@",  qa O 
p p Gr rrs sq]
s!" } 
 6r		 
 a݄ ` u #p $t$?aAh@ & rr 3u`._Z蔀' $< u0L:I<u	.Z u<` t$   tu _u	V $?
4 qfPS@ u7`P:<uR[SUNNNO밪 Oط $#c#j@]\\\  M G0 "W *a&00qb|3!Ab5c'U]0 ًUd"`٥g٢f,JRQ:d%f؊̺׻Y U Q ot!`٭Z0p ׹U f*!J
M
O

N# .!fQ0d
â2!f>*!uf 02 . 2!>2! t&r_VutPRpgWp7fǷf+ȐtQf׸@<
Yrfǳn9f^f@yk> uIfs@?
4!?
f6 0 u4!trr
>4 S@Wq!pm_  u(<sWq.^_.2BP0=Xs#_Q\Pru..&+.	pw\ @ t^P@ .&u @ u42..
t wPUU*P*Ч&u XY 3P A3.G@
X^ԙP[3 *.[rWȎ[[_A ```````aaaaaa"a$aVS3Х.:9`u.:`K@[^* UFP}`2SF۹ S.B`F[CN[QF?tN`sF2~ tY@`7
 `  _ ø8
 d`dt48NAo܎`0Վ8 3`8$ $ ugt;6P[6 6 O3
t,=

"=
 
K5w<t<u F߅À@<  s
Ê& 
<uaw\wWQ
u& ` u37`'Cv 
Ø
ԒY6 FF;t21cbbbSc#_"b V_dfdc0f$`a3R%`%D"`ErФo`0B]_!___;_+^ d^e]0^ "] ] 
E
 t "6MD_ 0 [guP2%sU I2L!M  
$pf&E
E   FW˭K>]>
  D  Q R UUQ    U	 Y
 U UUABC  SP SQ UR  SS UT  SU SV_ SWXUYAZ[\1]^_  qc` |ca cb dc :dd!eqf rZZZYYZ=ZY4lSNbQ\wf@ AEu $
`&auðk afaRМit\$tO ȋ`Z1~)
# #	$w Q.9.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZط0$0<:rd u@kP P H]   = ~r q& fV: gfFXRyZt	tv
 {v t[ u؎ |ȋhpg3 0o SQN/<tt	fP!XfP B ðYๆ/۵/Q!DpƎgRYQu/ 蘱Y<u,fCISGu%f f  f @.>g .gQSWf؀u/ r)vx!ufPs Ԑ߀tā_[ Sf<t;f3f t	f ԃ5
utǳffP`
 3^ac Qa<gb</{f<($`<;$˱;V;Һ:
:VD:^ZR:'::a{zZ $Tqj JbZfPSo У@@f.i@jO[R*:.if`蟅uhy~Y h2  脅uheaúB   $lÜ.i迡u0,RVP
ۃx  tcPtt>@ KXSx$P1Xr$.Qu!$
BB .JJq4HXK^`Q| -  t0uTf`0D  fft;  Qf3IY,665 !'!ҿ a0-pfUfP JXZ+ f]-fŝf]rPm}Nn跐 `0g li &  
x+d@0aU2V3V6V	  " 2y*_SYSID_  al _UU  
 r
R3҄0 &t23Ҏ¿x ȫUC*Z                                                                                                                                                                                                                                                                                                                   i   
    S    -%  DX' p J݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.LZr# Mu 6cLr pt 2rX~	 u v thr&3&E0r" r2vRs ÆUu
FUF ô蛇	 -q`	 ӥ/2	r蟥@e		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEUabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZsfXP'F#~r .>t7  /{r?`. t8  t t  2SrV ʀs`,L	p L~wt$` t u/~߉~ %"NV v1	s^Í6/N.|uL>R..L`>cL .:UtaLaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
Պ  ʋ.E;v j'fVfv`$dǋD @؊f
@NP.eXfa ȋ¾P	rs$
2

ў	fX!9
dwDfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZP$< - r!P@Xup>轝q @{<@0P  *sXXty>Wc * BQ	?Q	 QV  PRW> P߸@   XFrr#r^rT:rOt :DvL*D f umfm4
u
rPbl
u2 VWrd [_^ q QP&:Ev&wM!&*E9TaVBoCo<@,rFAnr;A?@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  uﴻ2&fPS `00v[fXSPSpsq`D
>X`?D<PƋ4a`t a1t!$!"q1&2PQȎ`SJr#SMwO "t߸ 
`P2:Tt
a YXÀu_OuQ,9a"   <s& ?O `P93 >/N}_uǀ   Mt| MLVW_<uW<
uuF ><@g2<t.$S[M[|u|]
`g|`it\_^FS`}
u}	 !.b܀}@a`>pO1~uD}?a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf6\c
bPZ#f F PXpZfP~Đ=r0&pw)Efݩpu fau}Cuo~s3SV|t` t t
^[PfQ
ߵ 0 < @f	t
` va f`ffafOfذN$Prf  pqHff#f+ִ f;wfg 3g&Sg&c
uff+f~NXofaf6SR	Z=>$pfP!qffX0ORBZruAZr
gQ2pXZ[fW|bt~b u:
rrw`Ua `UB a p 0`cViSQVfk1֙fiU@PV    ^Y[u(PUFP @| ^	u<Vf
Eo 0QpLP	r=^ uS@]#^[cu"
 ! P ^~u.t Uj@w`V	_L
 B8`.
u&*P,uχ#_>SfQfV `@Ł=Ut<*MPThY &Ep` `&ufރP  \f^fYfalSUh &]S^ ] $!&@&D0DV& fȡ\AL
^貟rPfWދ@VЎ & f`t@jLe^0w P P&t_ 'f='+a¡f;vMPE   W_f.ޒ	Zg&G_E!#3cgrR-uTf.޽Q,f_uɾtf`@]StQY fLOfp,  !fP H4ƙ# ,;!`U
UEG &E/"r@ifaÑ 'rnOGw|}P_@0 `n %؎`1#
H \0<t+Q GY<%H
fu f``G` p?t{ Yp6.WM"fxNf.ޒg
袩7 -""#:qOOP9D	rQ99: Lxp;.9r()u zD>(uf.ޒp @- r=b*VQ$T$D
 V?&Ta<^3Csry9
lY^BG0 ~50L80o"B1EvfL *(A=D`s(d8PVWPW@NTP
DP EDLDra
fMt]LJWAM ;?f: vM^_OTrNe?:YffWfQ@Q4T=M
e UL`L@BLR G>`G^WXVyXPVFPW)G@(WPcWV+t	P& 	3

5O`f$Op%UOaaoؾ:!P	Qơb;`#SS(SQ@q	)UfhR`e_W3na  {Dku_1nhQfhhVhphgpmN`rpPjYj|t= YXi,`{Am
1$pf[iPQR Bȣu p$ q
 PSQR3۹ 3Ҵ./@3ۀƀnuo nZ]Yp'ðɆ 
tw ZYJB`"<t$
tAJBqpvBß@ Pk@X1Y@ 0 qP0`pЭRW`R wpfˎۍq:W	rf+_`SfW.ܘuO!Bf g&$fD  ɋ? `2ۨu<@tĀutϳ.A˸_ f_[Q
! YQ ?8  ` PRS%` +ð ;w[ SRW*׿OзIr 2 p3_pQ,Դ=As Y r3O{:3ɐ!RQWSP b	$`X Q쨀tYl !`@ sXϴ Jt	uRX( V_m 7	XAP)[_YZ@2<UuX
8
DYJ܊B7ǃ   brT
!uAP  2
XS@
u	  ت *êЊy<VWQPAQDt!WQB:t`
Tu8v
Y_PY_XY_^ _SM?_ PPQ_DMI_ .,  #9%  2XPUv F t	F !Ff]X"X
W8 A t'" i &g +  pa
u
f_N@  ]ϰ2ðq  S\8@&G &[GPиG [ !@   栊W@@\&׍\p 0F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $_9F& ._@P X2$31    m R`۳4!fb ufQ8fYgnBW[z<Ȏ3]Ou r 28fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ffP`< t`%Z`{At{N(|S{_V k@Q  ~{{ o{KǠ !qO !E{3P ش${^{Q   Am%{
h{op)RfW. um3hff=SCAFtV~iG t fff kWuf(#3tfPffXPZ"_32_p9 x
` tODu (һ$
谻`,a蚻ô%萻´+蜻|faPKМJt*v uf$t0Y$< Kf`a
%D	6	 %` +
 $ fa r?<
%	*P_' @oTO xyOy er$DIsL:  h                                                                 RDSL@  q  O IYOO L vPQF 0 .p?	˸` q && f"ꊿ  ~f3 f f@i.<f.:p >` 6a  !.ݜP f.U""""U" ! a
#
P" f3ۻxgf+С f`ffWgfǃ#Eg ٠z`ܺA vT2gf{頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7~;wf+fa f7g~ggfb	_fP#fɰfa
t@@P	3
y
ff0
gf3  P
@r@
A
@  gf3fS̓ ΃wff#b ffyZ?'wf3f30n,;w#`4߼bf[gf} ӄp2
?ffP	c	i

OfAAXAoP
P#W!fكs À +SfVQp g46fFCYQ  Y`@.f^\ g&GCffTp[PfVfWQfR
/ШY~_f^RWof;rf`Ȁ u0s'1 t-r(@tD<u u P faUQ	U F @ E] < t<t
<t .w`Y]p4 RPQRbfv2 . ^~|.RZYXɒ	Oa.r3`	x tt -  t	  i09`Kr=s  "#@@-18P,Nff3u
P t  f3g /fF	!b"XtԳ$PPTff`U^-3&fPQXYq,)YaP'߃` ,P!8 #	,f<t`L< u#f$!,A,Pt,?faáPf䠄t"
   _u$! !tp &k Xa{{߲ݯ *{qݰ J6JJs@P}FF
]X `j . j v
)Mf.N. ttI4~r@5p3؊^)tuw t&Du .⭋^^;|aϠ~@t&ڃã.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX._[X`P#
Xu!P<Xu @Pt
a`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋy苡_֡FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	πt&D@B êĪǪAT~0	VcH UrpW蟁sʁ `-su fqt
E$W藀Eab&G )
V Nh8Kr>u roG Po3F) r\ {r=H r8ޠQWss#

Rr
3 s@M1 |#k##'F("r#謲Qlr@rk20!0p o×!r"~!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uF{tt0b](  м  .>3!gG訸a1Kr dt
t4t p掊%/=2撰P}O W校F X @F$$<r$:u s
jútA$ 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F u(@$3'E&f$`
ĢF f%R$PG ;B(FGq1 fF" PXN8NwN 4o2Ni0(`00s/ mlpR
 r
fQ_mru$贀fY_/++U+Ñ &u Zbtbrq? _VQB  BY^	G }$s
3
P&u3` @
r
%u@,àt <q66V&TЕup 
*&u^ô    ˃QPXuN%&:Lr= * r$ P @uP<ut.@ p5 ;/ E q2s2p$<@t22P !$!$qXw [[ĺ".Pù[K<P  = sffP SQ  !讅Y[$~p
 Ff 
۰N8tSFt f% f @f^ t0    "   t0@ tY	@fX
PRV s Z!
۳J
8
ۄ0
$g4 Nff`4eA fu4fafFDP2f tfFP ǈ^DPm fu
fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )v@wf*ݸfwf
fAN
Xff%	G-fA d!`
;Vt
f5AP
Q
ĳ6"P  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? 辁ff%fZYPQRWSӶ3t"X  e
躁[_ZYXS[  QW 1߀@臁 _Y[mpû z
  5u
 @ @Üu8 0  ;P1 F4;+@H0P ߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMO?TOROLAVPiVS\~ЎHil/P-s@^s˻ʆ~N >O/"n>Q/ S/ U/W/m>Y/mSR &
 3-&Z[>[/Ԡ]/ˢb_/b0 t
@~Ph+؋Òc_/ d/~f/| h/sj/j@	}/߷am؎&3&M<St<Mt6 6 
6^VlhO' *l>  @lype
 U3@	*	U!`

ձılRĿĴ+ 
r)>/&~X^ádWV-.GF< u^_}J׺+蘫rD.\J0ERǊAtZqERȊ̱]pMQRR ź_ZR  gZYol긏R8ASu
wRRp	[P uPXE%
cE%	_X< $OZT
 
"?
t`gVW_wZwU
uQ6rEt> r2
tC rͲ  ro  
!   ߴ _^a1n2
u[rVeĥi1sCr"trS ';Wr6"Q@
Er S֑)/Te  
 ` Ptz ҮK\	\*P')0\;#$ ?rIW("  kT_!P(B O55B< t%@r}4;3r!-q ,-Bq3ɰD0a@D`óp]GADw*VR@ ރ| 拴  t.Z^8ħP .;BBBX$JJ2J¿BPܰ\@*tJ 8*Xu` Gr V tA&q JZ  C@ĶA 젒*uP= ]Xruŀ̀2	
 ) (8SQ2<

2ۆ.
$2rqd<w0
u@ð  ` 0    j3ɍ6M.Lu.:Ls&3.D}.L~s` 2`r2`}s 2PL u KO^t
`3t t
t
u! tШ)3ұ u Iú t>/N.|`ӿ .F`ׅ u} P J}uL   u3}puv`bW_tURQRUK2YZ6	u>^
 ._D b+ t#VL^ 
.L{ ]Å Q3| Ys. u&	 t	&Uu" ώǍ> |  Êöj.f.|f@  3.|4߿\PQW 3ۍM/#_,m`Mp1(p p;`3k$t &?t+aP`)}
t 	
t>cL .:UǀV tMR"ZJ| $p$u$$<t} t	^^ Q3䆊!*Vh /N| ^t
.ͨu&u
cs)t!ߢRڻ0W۵u3ێێZ
t	'u
u
 ou搉@s+XPt oHڰ`oz̊t"Ĩ@t  p 
 ް  XPJXSPc .+. s#. sXP̀&   &X[ó5P϶'->@Ɵ/HAC  I@ σD
 uj@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& 	3!
Pwr ^	
F (|r
 	u^'t %1+	dj1*515_r0/5Mrr[o[
u< r<0s<"N@PQN \

u' 
$nvf<0r
sus>iu.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r2y0sꀰs6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 	.EFC
r]wsms1}I9  <$u2 *<#"<w u<@v<%p!2 Æ ]
F!UF%s &F4~R=r&@mv8fRF'P^S^!S&EF'f&U&]rQ[P@ [`fZsSQt^Ë^6N	Aؠrf;	DE蠺⻀~(LuTM߃s0]fPf}3fXr1uGN.  .GTAf f "./0`3V#:Tt`<~'t9r0lQzEE&FNq<DD@ % 5I@ߋ~6/N 6u0fPfS&Mf.BNf&]f&} 
[!
A0'Qf*  r}_讵rxL =rl`x5rdPtZ+cr@ H u~ (um-VƎދo^@tffmݵru蠡 Yr)8r$c耵rre	rj}PTPQXw rpw
u `fSfRWBt:ـ?f.EffffAUfпfsP-EMF F
tSuNff3f   fV/N0WP*f8f'w*f'F'*2t*܊f
Vvf߈Vv 4_fZFsQU n E]YRPXtUW:>_]s#   rRPR跶pPӊBz@ ǀ ZXюً 0oppB`lPX0% [ĳ m h謀 Bt Z^Nrot
r`a r[v">N fKf ׿M, 3S5<s-/NO8L9
t" >
NG<P#<Q$@ dMPQ0X h   t޲rzvru3rij0rNrWwu
p`d7 
!ʲr.Ǵn%a@tt t	tCHq% su~rt	 2PRF sH<t<)t<(u;ь>A u/WU>ӽ`x]_{3r0Cy/`_P^Oa'c $PSR 2Z[`ÉRFtN+P X7D	F
+CIH@FE_F
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP F}fCF ~VvuK-QfXr+tðP>@P3 Gp1 tff   Rf+¾IYÀL@}wu$`Ύk2t
.q^G fF! PXPE t<"u<"tlV3޾x 4Q&?ws0  s& p  &G` ` G`  в&O &O`uRp`f&GQ`Pa  AMWQb b׃  Wsa,ZX<7RQVW?:WtNᒀuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^V
w} " uRPFN
  ^t{;BI^.øJ1fUfQ  ufVKrM0,u gfm@ N V F00σu(gfFfff0/MufYf^4]Ë< 3R+fQSfVffLfTfDfL菒f^[fYrXP	A3PXAøMjøNcp O\ݒ`EQfV1UfWfP脒(t3  P3RfZp]:_f]|^>PfWI`tQ uUPސXY fվЅ `P8 YXt
 t$t t! v n X(RfV%t Z %(
2VSQWfOw#t   r$r	 _E^ QWVnwy^_Y iV3۬
ߊ^y 蘾 e =   IV1fffa .6-fff;w	rf;OwVf0aPS.- " J f%3/aBR绨@u$ , $ذ1λ0ǻ= <r <3`Ӏf
ffʝ0԰iff   f-   f bW >EE3&G?;r_yoQ <%Pt   AS ߰ ItpQ  f@)  fYV   f@ f⚰K4Z4f4f `,@RfWg&>tq r 	r
  u f_Rg^f$fî tt,$
g&"Fg&
FI*$
g&#Fg&FJ	f#F	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g[&@
p
\ 
u
g& 	TA1P ,a3RP\&^q\QU=CLWfyߐ߬`d$!<!uy@ ءP `& %"&& x<u&  V< @K!D8t( 2 ' 233._f>"("   a2ۊ( p ) ǊȊ&)  * 븊-* >+#1 d>,0.- &) r..P
fPQRfl f@f=  uf3p fl >P3t@&? 
 ZYfXϳ(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u  K&  `
x_t^t]t\7;utF5R3< v
<ar5<{s1$PɎ? X&1ôr2հѾf褄r9_2.fkq G$!u@t0<zw, [ 
t

	t
w
 Rfb2]bf0SJ, E ?G@2q)Pı
 t"< tr0r	
2vPQs	} U	(gE1C HP   PRuaa pXXZXp! / QWPXŻ pÜ= srs
0{ _ ߿^ nSwtc.i0! !$諐 su1{QjQb;uQN 3۸ K PU'  A G y   y " ËEup
$?qrq`tW  xd_qa(    K P3Xú0_1Q`%,  .s 8 0ff#@r o'f   X{ X_ff@`$'<t#<tN< uc T M_ Hp<u 5  %l  ߽
 aS  W#3XAVW3xu  G	u1@ W fW@"WVE 1-  Sa /WX#WpR/S$	ppquVUA;u  H $tu2$r  VD	05ee4BBh;iCCpCDPkKk)q@0 U2V3V6V%17Ш 6  IG  "6! ,@b ZWVF! s^(2۹  F  +^D!8u3qC~pCf^_W㿁QCuKE3 P!0 w $I^:u:\!u:r[_S  [L.
t@ŀÀu_@u"*~ fVUu+yOyt u3N@f6 V.yu^ u)yux@N`R\p ShbytE yux" uxt!yvi
  
]]f^eUPІ	   qѾ  pV G$ $  GN N P P  Gh hpGt1$  G   
G   {$     0    %P^r 4VMMU  MvO&Qa fWP}
u.:t u% t>JrS/N.[t FN.[u t	t_M_|EfUv"v t Ar MP ű.V PXF
Xf]h@ &A ϴ 2j@!Q nru\ôV
	=V
N.6# ..I.
Lj@s&  |0u{ 
^SV#؁D.d.$ʋд_^[>	ã3j0rc߁Ot` 	OtOtLtDMt
MtMtM

1u	.<.}h ;$ BÁUu	U SfQR~#G rp
fL\ZfX fP<r|wfD u
  S_QsUuP&Br& ȎX
N,M> ..>齮@u Pa 3PB &Gݾ&G $n $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]r|&?sa s@Q`b 
 fGfE  A[ff@C eSRWP͋ }ra$ꢙE艛˜LuR <s߰fQ@M}3  fYr/>/NGN.  EGώǿ _./17p;[Ü}͝_Z[Ð.> tG0Fr=N;.EP .&FNW>cL@A%50ߚ @ٍَ6/N C SRt5ێËfQfS.q&Gf.BNf&_f&_ - f[fY2PZ[fUfBSsQSX|f]Ê$uq݀K NS3ێۻr?4`ϰPt W6̸ E1*_Q§PX2%Tuz߀ u!pXuOǿ<2{f]
 N] d `5dPQ3 2W7y4rdr
` r`f<0	_ @PL!M@TPQ{ٰRP0,@ZP < 
䐾@ܸs3ɺzP.
p `.afV`Ԛ
uЃ	rNr" s O йAaf^ `@*߃2Պ$ԉNT@׎Ǎ~WF$
&FG &U_ؐ?
	~`a0=,غ*3%  6nK t22R Z؀ˀ$0Z  Kt
 J  @[Y  PQRVqW 60f01 ?RvTBt D^Z Yδ2r$<0؎f~fR
q b cjqd JpTP' \xfPf.4 f O                                0ؾ B\>3&i  Q6
aw Á..630GfPfSRR軡Ff3۰S谡"fV$
Ѐ
tf@`Twu"T]l4%PffZ sX u@ f  {gtgvGff0XfPafL	g&GR u#f^f_fYW= FFI2n TB  p #  ^Ȱxq2Ҩпð
bJ,p]VOp:$zt W9ø"а	2s s	2  | 런䟰 ݷ	 ֟ {2Ɵ2 	À tN :4
肟$ 
艟ߡ$0n Bu_$2
f%e1p% * UӞ.:f tdu .f] $PMM k R$PnP!    O  PA fPff  @ fX-Ufp fS2)RfVfWg]?rdTdߝ`%^fZfYfXà]ge333/\rVd4Ad^;sgu` 
3 [s M ltAt<V[rd g_}
^` VWd_^gEdTg_}\\
}gE rtr	 	t}d8t0tW<ytu@D5p4[
`PfUf]3
t  tu Ó' Td.;Gt ._
u g6$+' +k~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp	~	 0``0A*q,ff$@++0xx00 0 lll,ll  l 0|x0f 8l8vv ``b/0```0 @  0<7<f0 0  || 0p0  x8` <l 8`p  x@ |TQG `a
 
|x  ff|ff ll bhxhb `gf> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x;0  Px ƌ2 xp``x}  xa"cx -K0Lx|``Z pt 8l`0
O v!`lvf0 x [ `b  PS  !T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
[ uH=1f Svj.*2[]SWQ  >tу{pY_[ y P: Z~a TAE eMA9Y.nSS  A( p`
`3Ҵ"Āu N <tDlQYR"lr8rlr
2:6 vlZ aۉP fPCI01 ISAPs#+T DU03COMPAQ 04/13?/05  9     F10_  m؎g ЋJ_g+3f  m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_c&  hEWu}>u`RIWB2o1c% = ۘb	?g	@v	B#q
$s
|
JAfaffпfrNcӜcmqfw>
dQjut$UQ1E	`	$	c	,	A	
WТaUf	D@Īx"E
w2C
5M
HRx
R'#r
SF "+U~QcېFB b,1-,gPi*s0|0~}"py$O
z&&.x6(
{F*<c_t;j9= ==VQj>l;!"cjQd$W"!fh  nA{ tBt>dt	fh jnd$/GS
d_tfh1LbG" >tShet3~ tE>R6jhRdfjhIj>c t%j hc+>1t2>e {tefhQf t+6f *$f3f
ō~f PFPh Wwhf" !YQh}g!3F``H%>=#2hd跴h d*od' V0ұ1&	hed~ƀBJaFg)gBl	xACfcfcjFBhaFPm6@ ( jh!
Ѐa
	`#eOh!fB(0?YI 6Sh]c24
S]cxO^0M5%hK01!1
0! VD#E*hmhT")O	PBD	KB^_ 2FFTf^ F&<
uI) u&*_&8hftFFP9 1FOuÀыٹ F FIuFV)1 F*+҉FV2g+;u;uà3g% ;Fu	;V@á2gG2@4A996g% 
Ð7L*	6
ޠ WP!
@P@B0'@,\ f f`/2gc/p 3&a&cjLfP!r FPfj h!]PV=ut_ wV%#.GF| X02:8|Wd h ·&p F? GP	FNuFG0?7S 
yOl(HF Ham(tFR32N 1p !vQ>v
IbJf?Rã3@6#"qWr	v	$b2&c% 1cU oraZ

9=FPmu+&c53q3ȉpcRab`R	 	2&a% +1a1ajk_R3pW%2c%  c1jEAs 	aSFt2`h~Ѕ3^cjD
 EU

CQ @	H( 	NTa(gt31Y jibU	ʲ&WjS(
U U@Xcj~%&c_cr
x
xtt1!_p"q_Ft@߯c t#Qy"F.	U@z|p'cq-{B-&c/cjTʡ? &?c@w _&w@6 =Oq:"_& &O} wg f/h  `dQW h◸0J
a ;f@o)dV t}qJP`F; ==av  Ђ^PѢF2g^F  ^F&F~
r"1,e?&"e &h` ߃&d^gP@ f~@ cRdie  e# rʧ
/QQ!|@S`E  p  V60^aF@t)td Z*tT +uN&,e"e he r,9߀t"]Pt ߃Nס ѫ
+%@@4
		!A Qt:8O
d+uUԡ+~2@$_&0d&  (!g*d !r&d"cuolt5D @9".SFr{0@  &dw.j `j  3
vwB +#r}WF@T
-,_B&f(&
g &{fy5& +&C!&.&Ƈfd r|ehJ *MRcKxK@>de&eeFVD}.Afc02ae4d	s$6B8aT :K<]c;rvА)1uN1de Cܴ?eeF#񥕺@ty#Zj$	c>RjgZ	؁ de$ < u @<@/""r¸ ,1 ePwa 94>14!f@4L(va2 e0 o
t%rPЋF^Nr'~#tp  u^ }   %  h )A^  ~u +ËFV VF6Ƃ6~ r~t` t uF~fv
0V32,pIuquSI]][t

^Q ^^p۸L~  f#} F B F~P|v^ KF{ NFFߌV~ NHt@HtcH} P )nA-pg0$6^F&? u/<cvA8>rd|mhxcΐ2RacV;3.cv`f.cm`
NN]F -ev膑{$F8?gFF7PjR?g_S^/GFPv4F?gFmP?c~aPa?:!Z`dB_&@0c16C`b`~2|FtFr(}QW^
4~`4	b-2O _`-+F1V!FQC94%~ t;F4.FҔ0
z u WV~vN^?>S
A0@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODRHAA~(|W~FIt_~@u"2Fw#}HFB^F&WN} 
 
%.APU!u@##Y KVDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq;&'h*V~oʋv!^PFG>Iub: ^&^&8t #^^?}۲h!#ù
 0GF N% }ۋp,-Ar  ~s԰ NFN<+;u0g}03ɋFppAFWC&PfSp@ ~0gЋsG^AaQFހp ~
韋vЂ@x|r
CVV,GV~^&wFIa&a8^RF"Q2c%Vc>R⻐I"kbf?NP33#1!
= r	v	$
a2`% 592~
oP_#_j`R#	2&aW% XRo!2c% Rc1cjAROp j	aR/! (!Q023ޓ޷cjD"E
	C
@Hp

Ns#ST
	 U4	@g
3s1 jiQS,py~r]Uyzpxx$P#0
7
{2
Rc26&cc2fAf   df߹	 e 0 g .fc𸿝m؃@2-@pBᔢ T Kc]cFr#ᾐ4(C᣼ VҊ@lzFRQs7RS3zB
3~Qs9 ݑ1> j6hJjFc_ QnUeX>W@bIcW'?@#c,R U!
$+9UoR^3Ez}j`faf	ff؃}E	fcPX BA@@TA \a$ADVxÂE$U
C4
?
*Ag}H_ R2
N7BUacҭB %SpF "4)gjPL̲ip+2~0P442F2ͱ  8jh!YҠLWVvًދ~ &F<t<
b3rF*;a}7ay_~tF&8toFu|t<r21DVp^u	A(|ÐͿ ~Pfh#  ~0pF;rF f{?* F P F*N*ȁ vFoP0-BvPJ
u+Tf^F  FOuE	fdf &dfvctfcfq0@  &3g22`% u"2g$<22g%2g14gu84q= +N32g33 Љ  au6g$<u~6g% bPu&7
u]f2 % wD0	u 
uB
 )
u/Au#aa68g%FOr TfUfVf WfXf	YfZf[f
\f]f^f_f`fafbfwXAL f3K f 29J_ujvRPjk- J_FB~2|Ը1~ĀF  p ~ uFdްm
 e jtWqV J_FRvquF@ b*J*p
NvQWVqoFFP
|F؊f- Ӿh &m
'Fܷf h F֊ft@ t؉FjRvvYuh 0-~ڷSt` su嶯P0M2muhLh @h FފfPAnF[f jup:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~nƹp^؊R>QPƆ0[\@ 'POI1aPj?+*`
- e)@0hC NVZZG@|-\\\<\劆2d$0   ePtQ$j)!f@r 
CeۆeQ@2gЎvf@0)!"*- t*-} t94!13q$RFa2 OEjIOboLMBF m0#"7g
1-(P  GEtt/ 3|
/}@+F++PR1w6pWd qa"$ߒ1 v2g/ب ksaa1jLFPћ*1Bj9)"#2#"&#AD/]LDE WV3 Wp^&@RFGo|P38]6 2 R& FWbwq`I rR7<"JW>
d߸ ؖdQaa6  &=  t@M[_ Ft 0y 
p"Tf#B-//

	
A@yu	( LpĴ &&TVP{S~ t'jPFI n t/ u#'jfyGqt=o tA:? >u
,e&he""e2he% P-he  t&,e 1`ul &l yfd_xfe۶gfe0ee{e>gdaPaQadUUd*qu[h hJP~h Z轊菢p:r@juBzhz[NjA4R 	'"	^		

w 
?		 	̢	$r	B		RaD_F&? t5(u%&|Rup )u&DPƋV@pFF" cӐfjfh 
 fh `  	     Dq~  A u &c E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Q   8>ۋ  &9w&EU 6`  VV{ 6Dˠ   9~ H  ;p! r
f
>~ K{Āv&@u?PM`^; vĴ 3fjth  <Њp L_  "f pvV>B   vV*r_F^ ɀCP% 
Pp h
 h  RaNF
+F{@0F!vvo 	FL_NF@ hbj a^0CFPNQ=`*P`VW  p 3_^=e #L_ @SᄊF`
FgLBqF.
%
;F|!%} F@P!y]!Vvm`NP`rF^Dt&@A$0#FlAQ@Pu< t (F7 PF@5
 f `(* yBub~9v*VA7Ɛ2xƊ*} ufU  ߋVn'] ᚃ> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ft^ 3G +tp
V^% = @ʃ@A3t`߰@!A;wⰀ>
 u31&A *;t{r1A 
*FD0F
tҕ t" ؾ`fp0;
V=O`2P.B@?Vu	T.SEHDMa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uo31~^
AߋF:߽G
uɋN3~(~ {u j  F;S|;pUD  fUVNVv<%tF` u DD^
0NÈ ؏u0+b1WQPWVFX3^tQrJ;v~ F^F&uF$=IW\qQb]R}  P+΋э8sYdvva!V0N&8 uN = tp&@* 0&At߱_m !
`f/+IQ@kqCTN`_
ʐ kj ##vF_j&F3v~Bv0Q&ğ 0b;~ANuv 0dFA  
`feP{0VV -cPQ  F ~ ~
~h3ҋ P{W t4>gPǰvdPq 	|ptGW5^o"p j9Fu
q_sPK0 vv#5+PFV 00NvD"F9F}+F- uP@!b' ɒq YF{F`V%"{ nT\QPEP)DPAjEP:! fh p39> ~jy/0 *9>u	A
@0
A/\&76I%'@2)
߃
G;|2*& /P c`z8(F
A
j Q/j V@VRPy=AQda'P? p<n@]c E +FFVda#
0UcSpbyf 0aDPdQ虡xQ	5Q`,+F+Ѡ`M*2X R 3Rg@=PDI=ӁF3@**A;}Rvs`V6rqyg*@F;vwPST4C
sR14+

uSK#aQCgPedD&A84	PeV輡VPɖ!~&-24hQRptY~AS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) `IϠf@`	PXhf@PF^U^EAgT`X2s|Pxb<FA@ŀ[0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4v .9~4aWFO^6,+F!}=pu.trpSq &OC@ +σQk._+ǀ
0|ctj[|Qu

FB.=Q j]>| LnW0!L# ' OKCA& !!ypa2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfzf?F  F
Pj   v
u}1Aju >PHPV`
Ϲ!&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C `uDPk*.e H!MbB되9>u	w r =`Gg	%R4O1miDu(+Huu @uqt j	j/fh	m<	"	PV^FPqf~
 t

>axQEPzU@ ]FY m DVVjvvұ{xX s6G ]3?#PS0N02XPr~CwWF0B@UJP1qE~
%G jR[807+$ }p  9]tl ##J/E=/`J/F_FP9 \ dpg
p; ;NNNQP[ @C7 򠽋= K = ;  -Pp-߄--xАW^p'Fj  k >f`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< u}N0빋v T|` 3P Ppo & !VN;
u_逐xA^F;~maiXS `
$~Du6f| b;|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F| ~'A^&+^& 'FK'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 _rz/~[I>mFWV  Gc de td@ U@ l tee
|t*ATD\[u0}Y;F~ ZpӁrջN@uOp0
DK*=Np>d u)>e tl>g tt >fc t|cx yhPb?0 Whp.u"jhahN_ݠ
j(h!fh`_eh_ j _h]ch_K^ _T _}B g_m#N_ak%` !fBz"	 e% jes%^ ]cc%	 KcS%
 TcC% Bc3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНp߶t1rtI߀DODpU*䊇>AvuA*HWvAPVt0<@p& }5*5446524I5r6597h.@mE@ jpPVCpWVh
	 !V3j hD	~^DXր`HtHt#h !    C wt^ f	{$F HtHtHHt$" @ $Ѻ&&G<P jh	G+PX
G>7x@n ^aGP0v&ƀ ~~RrjV6 ofP)37P Ы>X F`~|`֢"®s}vI@x	&8 t|r
9GPu O  >p~q9	uarf   ^f~ t  |֊F}Ñ!	eMG	yL0#	Kްa c 	{3$o0(~`(h跽pa^p3&~/tC&  v&8 u*C;^|ckaF^P9PP`^? tvN~}"v`<1
ރ~ u0fDFG&9 uoԉ~WRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ뿛j*Q`
0 R~D@F	5 0 % t" uNj p貁F  Bܲ u
gށMN3~*^
7 8&8u	F;|,Bdno
eP s$
P PC 
Cc!
d$  *8fudg"w^uԍQ/	tP3_0F |n FPf@
t)f3fn @Hpfh 륐j h2`h` 4$u @3~l3 ^1`F*A;HtϠ5= t	d@ &d} ڑ.dQu鉀&
:	@

 &
&
hЏ
h ?AA7B 
@
@ -*

@5q&
 _3F! "&d&?d JfkJf!B"  _FP~H AKN
3a`#\'"%2$:GBHF_^`^Z2 č&Í,3F
46 x$dh?0dj(j 9
P8
PPfsV
bW>&*_)@&` 2 d t&<
} <G)뀖 x
HQ %'@q`
! Oph?dj  %+cbN0ff̠3	諠_%  Piр`RB/
?
$*H0/$&40/04RTRf"_RVdsDp%W
$
aH*=	- I- 9t7-k
 wqrMt%
- Ktq-Mtr`| MYnp= d.Ě"0,2@0`  8&_s0'Rz!"Ր,20`  0PXu}/1V hL_h STN  9YۂYu݂Yހ
Y&"0Zd a=	_[Q["
@4 |
U!@ _d_da0y@ Vfh0/h y Pc@t&
 
@ ACCC**!#!
@d_d_
ސ޾
r4(! + (#+-+tp*tcmKt
-o tu] p&3& tGђv 1vhh
h P!wu
j8%AW&A܏
-C@#'&$'a'a{Ðjg؁ ڰ @&
)3bPf 
0>{+>>G~>d'>n!>/>f'>< Ћ5P$pD D:E4Q89JR4"" :L%9
5Bδ,hh V2^Du+! 5 31;utX&_\S7AA@A@tR_!P!_!
@>R`O? 6`L.ࡠAL&_R`~~<!Q"Q Q*|3ɻm &ArhOE@Qhp@	X^rQUUtD33,i
m; YK?R`mrFv!
orMoVv0%/@tx$P!D$$`
P#wBf~hx0%YAǁ6K=,D=H=yMR`;}Ա;
fhZ/ " [BGb %^
tн
]
ct,W*@t>tq *``(@a@1)@4AET`ŏm>ƏxCQ/ M7# ғ,$ $ T0@0Qp@
%@U$R~2UU62`T`ҟlB	U`vuvVUP74	b
A
 ꫘058$}   	 NbvʤؤG H1p  AЗ1! 0U`0uU`}b"XWab 눋T` 2߁ 1 5r1p "(9@( f fcEWfh  _е
fcfT`&cN&._.@S56P6e!7>d>8FFj% 9N$N@fdfAcu
nvu-dum$uuu	V@V ,ǈ"]|roh֣2;voʋF8FPVh@PwMv
/WVO 
1!Z` ^HtHtt-L7X!B+ @3!!b?>
<ĶԪ1P3d %^4S 9@EޢT'`e~tG:lg@C
J
bs( ,f+fF@ ؀  F侰F}0FFF^~D>== p ߄ -  -tRp   -ݵ -*t:-`ս ߐ=+-vB `-@޵Pt}qx$Ht/Ht:HC 6 Pۢ 1( F!"!13 R3c" 'ހA
Fy
t)j UPTPfsV,ttp ;Ґ|a&yBY!Fp *HFL~* f fFa^vfvvFPvڐ5Fpu63F *˃~%v슅a :uFG;F :a~ t
&x |WxP ~@&p!  p!qq t&A׃@̌?"Ht)3Ã?@A ~r}b|ɀ&XT qȐV>Z` ucuHj k
&3v0 RheX`ff^`f ` ~ ބ 9FhDע R
X`heV3`8-9t- 	t Y`r
  *Xfjj a
#5	1	u.#JN1uh >` tu!fh  P蹵	-NR\>~ `6
Lh45PhjB6a3`,a& ~ ( F |b rPpu
ScA >p#u>p\t&el6Z`  륃h`te3/.a13
>^*u	> Z0!jj2r3{t;73Be'kJP t'${80:;2R%4;44Z
`bh j@p@@(!F@[$
$4pQ*tTS?=<=5
5
`Kh@a	@Ba	 fh=+rD-q*p~p$Qې#;$ %^/P(aRd*a,ac.awhe`P"r ) c%  = $Kmef1 *L2 Rb
b
~c
rՒ
֣ }g
Pg
 

 yGwA] Dt,-
t%-.t,-	 tE-
tYt- t/PC DɣZ`:~B~B y_ }  oU&Viet,ewu& riet]u
q0t`heҪ@ʪ  -Ǿ@ut軑;>}`  Pr%he	pjtXяǋ60cHtHt `t' Q軋 hpmou
^_  WV3ɀ> N3һBrZ@FwPWr~Pr
NpDt  & Q FV^tF&u	d,,,,,,,p+,,.舸>uh hmhE h 6v j 
B"@tî) 3҉65?P@;@)}F~
r݋F 
hl΢	
J{
Z 5#W<B6wf
 ~Ĳfdf v3Nv~FV
tut9v~O|܉~*Pӈf0a^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év 9t
G;|FCFvBF  ы3$uG

41t%I6%|bpf<afff3}&XS  
<at&
S
 P@t	t`p` ^3߾

tF^&FM!u	 |03$NF#@
EP2pnGW^rF*Wf+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.LftW/ /  p- 2&=a% +11>ao <a<a@ 3 ֐j5B jh
@}E
 C
@
B@
/ /  (YP)@ wj}Q'3
^'G`hߐ2g5؎GS.aAc0a2g, <aoa$ a
0ް&
c
Q 
@DMԯ
FW@f 
fhR0V" !B
p,pfh*+`()&' $%h#wf0b\rc t
Kc weu
M0  O hE `F<tF "h"B}x by_F ۄ-FC|ߊFà@aGVAװ
?@aBaa!JM/PFۯ&J`lDLH f`OeO UKD]UR]B
3HUT4P3
	Ċ7*0S
BE

H
<U㮣YUF \XE_	[\t
ZR2B2A `>T
BjeTphhhӪj&%l$"65n42pFEpyDBOQ
 !\,B`C`LB`fB`-
@- `
- Kt <_Pc_|`d$_@UCU8R`n| $0F\߿r4,2"5^@^Ba  ab AB  z!" 8- 2&Adcldzt] dw@TĀDa?-  3 @O+- b	uic] )#@댉  
#j+v qp wbp{ނď@ʣ"Lcfcf@cpp@ta axxz` `&CADRPt &hDǎ&? t
&ؐ
`@T# 
U
C	@U


A C	 @砚c:Qq@t&fhv+xU׸@{n~fhzh
5ޱ}4R5tfh:}89h7FR/с0vrv?=>h<^T@L`	BA:2h۔hWVde$ < u@a@<@uo"d s@ut;>`  *r$ h>h$-Qp1݋@66_Ha 鉀u%///)Ha\/R3 (-A͐:PP%@u'$F Pc= 0Ht
}q j r j6|@uf4;F~ w ʃbrջ|N@uOphzhBWV 6WOp 
nrvƐdt
Q &"F Fdt &ce7$KAJM&PAD@T%V%} _%T%&rhLh ޽$ 'Fc"JaH_& *JaPeA u$2ݵ,<7 h^rh:<9  t~@ rb` zj~=  TP1 jP,Jazp0u.&bPjjz`&r7z"pq޶|荐
F0#0000J00"0!,a:kVfvfhI
 Ԉ2u @mh߫ bFb:tF&<:u-FF
*0N&$  
ue3ػQ@C7 ~ uF	 F
  
 
 < w C
v`
k0A
jq<L^PL
RPE
? 0
~ `~ tghjQv&~ tD軪`E=f=u5 踇Ч
`
 ^3 FPPP FF9Fr x% -
 ؋0v v sd ƨu = wѧȐ $0~FPX.aFcy ~ t 4Fa    R F  :ޅ .E {" / 
Qlp~dzt}' \ƂOFZIZ#3^ \Lo^1hV$.tCq u^ GCauK  K .g"ǹŁWI Nr@~u~_t W    I t@FʠqqFV!F^=uFv2N'22g+7@]WV6Khh萸y*Ny fyfu}oyDt4H-H4HSHFgHHH7I2yFIP;9Az"CLzDzߡza
"zj &z<f+fF@ ^ o ^@V^KFP6a8> Lv3+Q OY  l`- t$ fFf~ sA,Guh׸ܠd fQVȡaڙRPSQfXfYf3fffPfvѩMF fh  bU
}1g Fvh ,CQP^pd %PqwT_"ӝ`!T(aʑyyE  p 4  VW6rNq\		% 6|aD6Pf\ 6Lf|<`y
뎤]0Ð3Ð   MHz` KBSIMPLO  MOTOROLA  HP  1.19 drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withou>aving
o Securit@Administ or passwor4Cte a/"Power-OnWGp DevicedeeDgbD$L $s mart Card%G
supportE?mbedde&Lf
taA!e6'etr*ac',p(s$`*aut?henticS+e
credal Auto2cH%Tools Ba /0Calib( @(`'lectb HDD:lf-T2 op8s Activ O wMem
Chep?e r s: ll
=mb 	>>uA@Advance`L`4uaYgaC lDt7  of grayq6fie?ld Boow1b..Pres=y keyH I ue F10=
, ESC=Cl  9RAccep/=wYesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQmenu iYqKp"<ENTER> XbegAi)WK%#.?followM%Z&:fpc->  KSPACE? = NexBR3zc-BACK@vio"Fg0hTABE3iSHIFT+&*lcF2@&10`
 v[J #'9 Er This60cann)b`mU;d An eα ocH@ whs6c.pde 0x01 	e@ondApGPu@p0{6Crequi yaydE`d~jba@%smu0C
movP:y e4k/MEU)hQ1& ilAl//+2SDcleOsu06ssfu=lManuZqOr  N0
d:Prottyp@speItwepp+CacVize (L1/L2)SQ ROM dd famiaseP8l nupi 	Videovis"Ke'ybooFr06verD$b1<ed2e	3bg4`1qa<ownPhSip<(TdG
W
O3O	*	Ĩtafdapi5u%BSNZCJ*D$ 1
22
3	ME
	C

V

d
4TV
o
DoD
So ྶ: D.   %FPA2d!J#biFaܐӰWalRX0sԔ&1&H} A{ddline4 AlXҁn.%F$Warn: rk T&pll0o!  zsfTrea ҁ/vր, letf ea w̓aba002 A: 
deĮ` waqt@t Ұ_)Vu @rnInv  ȍP
)!	Ayou̔ wa@|to A ?m  ioa	  0o`b+-c?(Quick`n2o2 (Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30¾# 1g¶30%v}} ty ho#0#uprХ:1't4	f-Un3knkp{ilyWR!mServReaPS)doџ47`?a}.ribp	:`LexP9 'b`G H  Olp New Vfy nY7Enc8Of'f O  ɥA LA66#%AKroE   p dV
Ad1ݰ U@ҭ5Ocpcaus 7p@=AH
"h` A&فOpower-.AS΁Qa?U= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[vYDocHishR`ed?!0fp]Dddi1al JJe HyP`"UTool0 Cr.%oF8IL`ˣ Bk g Uмn  qpm`@jtWSN !ar%v0s /UcwchOP2"Onj* e:Z%%% AF@%԰#Dn -f  TndpĠfӰunuR?*$n)tartBQK`fra Par1yNs Spdlot CD-Q& vb$۠@yU@	11` abourzph҂ u2W!?1 bUSER"MAST xA4panPO9`cRR%T~keep i2acIewphysD`<phaRڅ  7mpp`r. I62?R>
",ҚnRVun* "gFOO^AutoOcEdpptY 55)0?#ON; 
O[?k2{ iCb_pur?t \2F2th@Pqsow k e:bdiPerJa@naff+bdata, ]s7siblma!aKpkigi0d!V I0sWPl r mmAM P| Tu@yl|,lreplap[vo o/*  y4y Xr" |t,CoHA=Wy|'qu{me`1r, @M6`*ڐp0uibtyo. IfRdo4Ǆw8`!ESCs.!
T V9 ͲtypB'>'nђ@F10"q0rm,bShxt+  El$@ MiBj.Q  Orpr: U= ay OPX rDCgDLb! (left@/hUCSB t HQ̑bSu K ZipoFiroh!F`th;ifp Sixa h ENh`ASwap Fn/Ctrls KTU.S`as>legackCϘ>is`7)nd0=Pr@ryڡ Vpo  d NTSC`AL -J -M+t
Bid`EPP ECPd2size 32 MB 64a }F@pAlwayenPPi0AC3 gWLAN D Radi ViB/luet h 5/rS :chAӡ  SgB1rᱠNtЖ 9Ed (%+Dn,2())+P z+f1Eqn7)e 12t3TokRAHp
 kP	M3Unique Id!fD`&pelp   (tu1    S>`KCalib!6N@s4P DK A.Xb0B  Hw O
E=Li MEUk'@g'MRo N/G/U[:1 : C0@g . % ] /C le$2  yc1`dik-d3 	s
H

,"
* A 5>M(o!ylSp` @hnologyg<YadapAPXE RPL Exc"Po'pupz(`@0 10  2@ U3 4 5 6@q7F12zO5 15`@ 3 "MnB `oucWhpaPuSNon`<F1=Hilfe> piYin[|OnzeigpfҠPpeict  KaguaobVwCiePxnLqveinun	-hkz
.ignepd`*nt nehP7/N%Set#SRheitsfunQk:n`toa u
nBlt-KuO] G?ertes/--ID  FO`t7	Usttz !@ 0Qz#  beim 3st
ng!KAr`5nHsvorrq##7..zurck z 9
B .p,,
Pf_g{ms>ThEx|)`Akkukr_eK tpBsgewhlDD-Selbss@´ItivS9#LtIprN 3g 0: tppllTL
PAZ`OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e ҀSePMbqTa>@0, um p_3gfahB@i=A, ESC=Abb!#`WBkze!TJasN0\ , yJa	=Meh`m VeZ
=zpMark"sy!*!'MenS% dPfei#lt!
^dQgabe2Rm Oq>ko?9 c`:s.	folj
Bn 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchritt-`VowA(GTabul!fs+ H-oll+gedOx F2`@
38= {8gy EschlrLi@PK kan~Lt 3we YeiffMgy16P=`?rgetrЮn.Dc 01 Ll`fit B kqcQFY+<W\selomvPorB]er0ilXWqDWeskU-KsBhmu f 3aysÃbzw.2Mobiޯbgtz%.`Qz q h4Bi///"2f!
}[KAlgrѫ ab	chlos@`F-M`ll Pgroz yprtt`wi!g!60a"Ca`-i-Gre (L1/L2kkapazitOMdzPm"Famiks Sp; ummU Grafik-R0sa@Q "f|]r-Con " 
A  °a?h7J	b31O 2O 3O 4dqV si H>(F `	 o	o
o1
L
t2aSekrET* L$ƍD%'$b-!3Kc~(1  Walk?Zero-T<One E"dA`@
PnO`+: bX7 st9qbislwnKp  ZEpucQN-/WB _leQbh s Atei#CP0&ILp`ak7 A:nfC6
lW$ge`KR/+Pglp%ɏ5 L  	/  M0$wirkQh"vQM?`3, daᱭ
l.^ie0wQP ocFLˤ01 ( anH12 (UmfafdIGc$fhrxdauP(Min.): 30ZБdS`@0% cgt59wuwm HoHPuy p%ucbr`"w: ؑH	ԑUnbeaaMTHC52'rvo-L5.
32@lhafAttribu0FID 2u"LS.M.A.R.T.˒XXMs K2`kwp eus~1L Dea  JaQ`eD>/t Falgebe
 U	ңBU5I<p dminIoz Dur1@`'@`|  mg1i@eFN1sgd,E.@"< ttifiz eq s{0yrt=.@s Zu1`0LzO 9p袓+enl@~.AjGb s0Q!np'PlsAvikceTa s ,ܠF$0@ h`$pga|F	 :	 JZtfa@npWUm Fun)S7, m3e\Wn HP{tectToolsP=c^ty ManagпUo-- c}- k QuickLockS
ubndF	r#q\M#0"e$bi sϢnchutz  f_-?1d@imd& "+aF A)N+ * W"$B>#, lp$meh1A #I Nk>"o3f`ot-.Parpent}imCD-Ҁ&g1M(!UP:an3A7m$"rivie&Ftpla `t9;PὖcJs E-=\s mU8unbrapjbar.IpT
b,NҋbewB>SDsTD,d{¼  !C&&,	I, 2.\v%,   H2i<nc4z@ N󝀞}B?egriff0diautomLs O75@:ohl<? i  Q֩g`yp#ps\V*f~ 
T'U!!´!mU"n OP o"e o)ln Yy#OBzs瓡58c<!sQy:Sn iQ.) r`uM(qذS!|qs mh!ac%Cw Prq ғ+I o0  qurn׳hE . Escdr<r empf/qS	 d?zu!тROx t. 󉡛   f.МYұF&1 2 B` 7 b-B2`ntra ttAdant! Whj`!<@Esc-& VlȠ>m *kW'p'p`\< F10`eHsh:
x3fg`g sbD} m`  ܡ@MMuBay&m )bBtgk`-EQb(links (z1tUSB-b#-2؆Squ`1Zip 1`234 5`678 9`QFn/S'trg!Pt ų dEaCГ (USApf-SZeP]B`iebss"unabhng`  PcAIAn Grafik-ContrPrwimSek%~ Video- rnԿBidirebal GrP u_s Lfa`i8Cb0tzbB
d}r WLAN-Gf0Bluetooth9IUn/a EgpaAggr e_%7(&.(o")u -E`t 12P3,Y5ToRRa C:=A  q1tvH^Q1I0NqkBoF AkkuPN  `Pta   x a  Kalib 
 M`k`O  NƘiual_ !  O k   O  DO,rOTra-?6.  .O .L4obi!qp9 OO5"R!P	E gnOOf`.[цrІ 1 :. % ]l!abloz(2Entl ho3Pp1
m* 2
 GS-2'su' x`Radap̔0aBPmbzqA}ExpA-!-Popup{ ( .) W0edau Q0P]d2 (Z@Y  Ke`~Compropstn@ <F1=Hjlp>Atoplys!pVisúne G0til !Akonf@b[GendPfraMq zp@QrUx
J`gnorondr o&fslu r 1 u*t`gB2Otne k)hed AdministoradAskof KP ao:dA7 fo% ˇhEdjeG-i Sq		 *	v*
lJ	Sm-k	God0delMsf 7do_dbyggPGOds -&2p	 Nu@l00faks l2 Ua턐g
sD)9FHk@\HF Ba.@ġV  cb"dvalg b&HDD-selv\tPr HukoQA.ainPQ2hv OGH omv	Ir/ Avancq Spro_g Vl1?s @mo2ned}tt felOC4+'/#5l5!Tryk p=P7 tas<DG0=tZO^=A, ESC=AnnuaFs!܄3=JaNesj "J, A!R=MGb ?Brug pr
NA`RP70we  releP %menup(,1Wt<ENTER> bqec>A)e3t. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-TILBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sfej 8A3ku1i0gs 2dodQ)!F<F1n. Fgc01BRnoVpD-p% qpla`9G!krvvek`EnJJ
i db!?s^ flyMsÈn/MEUؒqoO5 bp* uvetzbru!d 2JI,nemfB J@`  Prc c@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ familiei;AWdeo#f0pdqs:@Xr-cs]D-ba`si`9e2$o`%3o&4Z&=at-ta`ofej1E("WaCt)	O3O WEw !ex{%Isr4E$ TyPyr%xy lydes!Bmsis 0'%bvD1I'j`Qeje var0:c DB1! se>  alt@P<02[holda@ poPqt`/b Bb-Bdqduw5,prI Pk
kE4uGrBA: TETfDF%U?gyldig/
6t-  @ngivudİ,vi av٦,? i#K?@ $1 (Hur P)%Omf4`) sl(`{ (): 30˄2j  `1x0% frpudZ44b2@DR 	cq: KuB+"UApyCS8'z$ervWdLsrib?ut: IDxl#ZS.M.?A.R.T.5ܐpyCD@iE8Ny  Be@}ft nDeyae Fra@l !e@+ń4 PR@{	s0FC		ƈ4 D
&K|E  beviв@B7 9!Cfdes, f.. <ramG261  PoRR.RVuAj@me+tabWata. _Du bu8$AM flAX:Ը vic#ehCa D[G  @ߒ[&?r !,ci HP te?ctToolo9"jK Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat `w@x6r,l
di upbilK2;+81ol p@?frard )x  Cd-rom- cU?Bg Ho2A:e@AuΑ5$uhu,;f Dq .  bOBRUGER-s OVEDADGANGSKODEN,22pQՉLU altga9`s  n Be  ned. op@Ia0,'edS T#
{	aMD l!j ЂD _aBAQNhjlp eutom`oK, pD,ZAbyg!iWj?5B^.k? perma@3an`Pig`v2n:j fys dsk5 2 rbfppc(On O"k	v   .cBna  @ucW"EK}m/, somlмa ck@
<ҚTut. Urd}U pbz@oPc/cÀ pikoSӴ@0.P  оbefalkrafǓPapx 'A1ŀv@"pl . PAXu	u
qD  &cO.q# m"J"4,Q/8d i`$HuA0˗0.a.j20:@ENtrA!5gESC. क़% orVPx 'F':gqe@F10FY ӄMsf
i/P4cD+su  !Dk Ossrflgm vDRRenAHPskm DSP-bas MultiBay (K0/$hjUSB-floppy%#{cc{2|wbsu SbAzip~Fr@aVTredj Fj oe SjSyRV; O Ni  Ȯ Skimѩm Fn/Ctrl E`lPv(ua@i`sk) ؜ UegeUstt!
u@PnPAQ֠rm-cr Porim@Se`d V@o Ou?t Para  TjStrCL`ohukoЙ Bl8d t 6nr compu 10P0ƀtrm
gAt WLAN-!spioBlueEt hK/A (trdlvlo|net@r0Uc>!mstyA8&(x(top1*b*EthNqft 1K2Z3KToJRaY HL	e+	 	Ent 5gt id-nu2  0ı@  	S@   Z 7b/ JKalibB' 7ndaigO  x 9p6 @W NMH @KO OM2[bo   O  O#0 OOOO$HAgs 1  1O O
1yVSi mo`gPa(MEU)J=K=O OGOqOO  OOO[ TPq 1 : O . `% ].gAmt2 AfFH5L)O=3@	Genos	
`k

, *  J/X4 %G)g` hB`At `r`bpopupsink(sek.!H$025f-1@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jonRs sypLa@3$k")Hefra6#:p`di!opQ	:k@'Pg avslu!QA ,lBDE;sprograpt STt Zpa+ss@ a/$OpFA0`|U'yrsei!>vsfunkqur!tif@Ԁ%@%-
vn Sm4 #>godkj0R!neby3Pi%it"ot5sTilbake@l#3fabP@P@BQ`g
i
 C7;avL`Sr_kty & ڏvalg !AlPP 65vt Ak& MbT!# [SS;G@$*
@`H!4v prlgy 6  Dem7`5bM @ZdtJIel[3
.5E6o%<}5Tr7ykkC taJqLQL&pg _=, ESC=Avbrya bBeAPpJaCNei rP, xT\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NhQ&86  <-TILBAKEPvrig*TAB&"HIFTa++F2@	x)}= Go f#l`bsfeF`  SPk`0`pZmnop@5 PS M0|m kjresve,!@m d;@i pp 9!obaRaflysbc^ 0dS w}a`1A|zrv full1z. kode 02Io"Produ _t Nopablok7k-mll N {typ h@igv&-ga zvAӄbuff~N(L1/L2Meng`	Q	enu V@woI-ЏTjrtroUSW,kobgRi%,oK51 q'i 22340,p( E
,9( Q`
oa
o0A
o,
NEkgB#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( A]dss e7]"~e PRnsAd 4~: DsA#.s@Qtid9lSCholp`@DDH[aQ "{/he-  dÓ, rnP}u1p sakl<k`nn02Aa:%ڲO b@Ҽreg1i%HUgyld#ig#DSR`@	F
	#NEh0mtEb`?̀{|]F igno3t._te?-  HN 1 (yR @nslXbP (): 30A3ggr 0$s0%[v\&st!vhFx_f!_: Ka"qut``U(Ó5$SQ&eGt :To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CCG  G#Npu  Bekreft njAv`l ePcᰔ1qrEّjv>likt aDu!0oC 2Ѽ	aŤ,okag3ogs.rɐor dmpel& Tp}?ّ.BrPa(A=pph. `bku,  amK#0vice.0ula?eD(s  aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l8  ēlanp撩pa0us #L@$AOmpEr`i!gi$eu bes!ka u"-U+/- +ӂWE%lq  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- ParFll+vSq1=   CD- )pFsU1ut Ho Ċ$-:Be5B`Dhpug hh!3@bBRUKER~HOVED-T5蠮 BI Ryumu 0B@EQ
 n0]*RDCbe!1KPP
0 P v@" 2Va! #
6R,ARZP< 	!؆ 5)pp  t~I@HOM @ automPYpD!wLock	3cbyggZ)b0`  @]maPqilg ]ge0.S k_[h fysAad  $0GmqW l#=	|u!m:fnd1]VsQs Ѻdda g }u%x. U⿲g omd@N1|0/e @XG)0znq
` uPbV>nbefat 31G	A| q.1A=w A0k1E 5ϓ f hP_!R!'Y}I7 MT֐s w-QVflans NPBv
,2ʰESC-yL P΢`rb'fD'J F10$ZCb#e:hf$ nd  NKor iFGO%re  MultiBayPG]y "Q'n(ve!e)pPk}o.ngsbahhyOBUSBA|w_ Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeeanAela	jZtsroA2deoݨ@!"pTisrr`2FViA7tiࢀ0ymFgradi/@trdl |t
WLAN) OFBluetooth 5/-PbftQ`mbQ҅ Agss`B	styQ'1_"&2xo! (v"*b/!1 Eth ?	)P	3 R
@NsA'oo`o/
8ni>> gtifikOC&\=B6riQG H
t@    3ymbo KalibPaK BL!es- IA09plХal ,-N	O	I	 O	O	51O	O	O	O	8ksp._O	pO	O	`lnd 4 oO	O	
%O	O	_Cs mob.  ^
H.\L.\ O	!zo
{{O	B.[ TAO: La. % ]!fGullC2F a{i3
Qin/h* Oy  (o J/D
iPrpk)mA sin hurtig (sekuPrF12- f1.Sepute P pConfiguracie la Com`adora <F1=Ayuda> rcOhivo  m%7l Sma`0pGu isco fl'exic1,pٻ Ra`&sAvWalopf@dobPyay Ignambios 
y`li a A{&  g3 'LЏn@epidsadAse
D'  ' A<j0icioxf%0posi@Rs_SIc) $ +5`*KskSum!=C Soq
Pe*cP#<)ާ Secty>incor% E 0e"  30/c`VP><6fbrI
AaBVc!3nci@])AutomaHe_rrami aqC2}H`er  8P(8 ;prueba/ HDDKc 'EOGVЇ&MemOoria2a"d*mp.l1@JNKRMu0G`SG#
s
 AvaCnzX`ESvVDD
W? Fampr)co0N Cgr0<1o?)<UOprim'quitec0g2) Pbm=, ES/C=Ca06la=|=Acep u.=SSNK1."Y, Co2	=M y p UyB$dchfDha6@alP}  alem o apropiu=@[*<INTRO> zp qx:N1n.Fs{3pkTY :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'aMays+#C(/`F2!-910`rXŠ"b"uErr06F/  No@8 AiPWGSPrjo u@Q|RA6K. CdК`01Bhay nunw>эqubRnY2@AC1+>b1 r(0Rp[corUD)JН@ebo?ok/MEU? IXQP\2O`0ple0Vxitosa4e Fak T1ytil TisOp7,VclʪGpuWXTamauZ_0h (L1/L2Oc FAAROM mil@cNomerD}rib\visUv@ j6r g-l @yo!!
/#$j1l2n3p4 EtiSqurAsI2VeFK 
(ga`W oo.o3oo0poi B	
Esn!*J8T 5:Z$  PGrobU%bssfactcXJ$ǔ =l3l4Rėo 0poX@1'	lnedi$l@z,
(CE|R`oD"F%#Ad :vxH uir  eap7. PreP#/, WcqscpYcuA:'p, Uu c lQas ' Ӣ,htp9tegA
S^@v!lQI$\0e'vaPa)00٠o(a) 8!@%c	Za?`gnޗod il O(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuvtieej 2( s): 30h0go B&0%&~Db EaH0 _`ipalGiruamq
 : s,pu10 qIQ{`3nh7~Servof 44apoya atrib0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S@gOB".X		@e voc"	kl"alpa 
0 Lstnad  ;`fRn"]e#թ9 A*# \A<Q, (02o,vA`Ơbs (R6%b E  WciR|LLB 0hrpsinR3 SBf_ olı9al ol`X#dA!vu	jvip.AoQ  !'{Ùv?%(Ӑ֠WapaAuydzAn14n HP~ctTool@O)%!!&  QuickLockSuspen Blop`^Թ\rat S 6""xt mej`e O@`?:0d+B+-y	(BI	( !)(rALlDRt0,"D,0X&upizQ,.`xHOre PunP+rojo%q>lWS9MICD-(
Eec%'WPi:XUsiko:Mpu;Nmedirive`A'0 tzUSUARIO2I PRINCIPALьjoe c&s UaJmanT p wO. Anp2 y gu # lug3bP  p_jzD.p-%H @d\WcGS1
!Qbb;vaY p=Omc}7PJ67EБor1ܯ?b9
 4:A @G:iR Āu(?s  , fs`m 1$ 겞Rh@ArQOoc, G"o~ /]@y"<:XouH d/aap{sRcu2bRt£B! ?1 #zda$kosmA;ag а6Se r0wo0enf 8d lic㡖Ӣ@refaz. &?k дu "`#PZҝ4=ԬFainO} a cjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅ ESC. BP1alab:'Fd'  ,F10B:lFRrfG@ǋ7cT/Espaol OӗtMultiBatNQPa DiPsi`$3-pA  ;]SfbԢsco+d(iz"a(@jech@-5 cB b a01ЇpSuwkrZipcpmeaaewTer Jo C`5t `x SO vNo0 DPƀC|As Fn/`T@ncIngls (EE.UU.)s (m3So}"leA`$1nt!Ac@ GC>0eo Mod"y!  Bidyi0 Tam&mempIׁ͙i#	si0fQu0{ B,P޳ICA R<k*WLANy{-Bluetoo/th IA  zQyyQhoвergRsGCpoos3B_-PF8{(s)ior)Ethet, N0boo0 S 1/,2/L3/TokR@bOO@`P23 IPtifd Exclus`pᑅAJa@4`   !,a*AC~d`*-N@X0S#ӏoATr)3Vh!,o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	%MEU 6}o	.@o	o	o	o	Ub o	o	o	o	rB8[ 1 :rgR. c% ] /{Am2 c4-Clē3 	0k",B'* r 9ODJ)o!Ѥoh` ~aБAbbl" @zArran@pٓc#uXDᎰ0gEx!`F12QTAmbTouchPaud`uo N`qubaưub  <F1=Ajuda>yrInfoȻsobo[ Sd E@i?5m!HDbβМR!0
r t@7padr0
3r  Ign`air@A	sPs'&_pA1na	nJ4aP@OaDr%&U' _`#Ɠb!X _d#!

SPtSd!܂υ.8liz/p@ʉO
(I 0@!ԇs@/R Q*?g%Ϡb9r
aut<n 4dcЬealha2@o`Ma (QFeOmPasDg1=i0CP8$!leRߠ֋OpT`HoDD A1)r Ɲ VR#Le Mem@A< 4tactu S`MuW^G[⩨ Av8S%,io Qa^d; camppJcinz "o?CA9`essNe qlr wycи'tinug=' SC=CelaAceX imNKܡ!S, Q%ou<=MaikgO Uti0: sC	qqn'	da o i  apr#op@w *u@Tt#<ENTER> t5meRez[@o.Tgut@n9 ^r u:b:  ->
PAO = PrxiK\<-QBACKCExaQE06TABo$SH/IFT+C%* F2 	*:`a=kSC# 9nErrrOA@,Q@na0WoQpڃmRHE. CdigTGo 01  NPhG`,`:o `+f)  s@ viKCA 1A	bMev
;nsf`ZWotebook/ C[(RWS mGsTe2_DKKXqmBm? xitonzN  Ti0HPۀ3VpcS_࠹\ Tahcache (L1/L2ȦFX a` ROM FamlY  N 3sri
RevisSvde@̠_aJroQLa 
Al!D	Ob a(344`Rtiep	JIOeu6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcCq% vfoi"gv@!mO al  WalkN  0e gy1i	a lien!M!oc0I@Advert: 0[Aqo vae!djWAcqP/u,!i@um  gravv
uu:e)EӎA: n@Adc NS3  >B^hO🽠!QtegiEa	c]
vl0IyI= kT@ctezx0eja $,C?C iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.RG.T.ax`=б_(.): 30<`хѡ00@CT =4Q0%?1$bucedeA,qAhosstDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*{erPmec ` `6Q3sM tribߒLD`AМexa@s wQUUig:Tgrg`alTPSLs   qƀL rB+ۤifPArrfDig8cis gҐSAdP)PPЉxacmod!CsާB! fazA@ArEr@a,Πer dfor!m!r3Dn,Pja0.@eHCsHfbrcausadQerF. TbZ Q[e a 㷑2k_rvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%` mabnbP1IY @k,$$al#.2P4sia eiSib0RPuseu sEExigLU`re*PbM0Q+ &perme@$1lp즅+8!CD-"˯gGP$qme:PDusua: Voc È@gp4@la0vr2utzooDriv)e& t@$RUSURIOBG@ESTRE _FSC%ɑ7q<Vapaz:@I. AaN4P@9de-ФrMis PJEB>p"}@.. NNv p[X֣'6Ve ,@V`(_K` 0+abu:*Ƥa !ECde]D.H@f``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a `uuzAoT :aq(2˂40  Àoqur<ǵ x@FkgڲU yaf0T y 2y, pو;) F `3Bor nal|p`#a-t
A^ ˢtEsubtu!d C{ ?@ *hR)ppa۵8ptA-l VJ/qrWL !8Z  Lembre ՚vqMac`Pasa8
"qui_se<`R ESC ]ŉ9Š\q3lav'f'rF10. r`r:MrʷTAc]D u?gus Op1k: MultibayQYNc`iFsi reAFpBa byaФcopld(RP diBtzB	Rc"zipcPrimeirV"rc QtөO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMo#aGPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WLAN)` &Bl0oothkAnP2πڐ(a/ Eomeonerga  ere*agBC/*1w62,12oo-'0suЁȰ/0Et#netg	O p
/*3/CToken Ring OObo`Id!fDPPb 3abraT qUSt IsPSڼC!bQGP_NtgemNSrTl1CsrNWDuplo&	ted/	)	E /	fONOOHO'as7AXj O/	kC/	cIAlЏ OO/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% Q]@Oc3l 2:cv0N3:@M* d
 o9ayCJm*O"(sfOlex QScp`xrydapR 쇕 i3Popup޴ Exǐ ~F12( "ߢ dQZs Varava Nu`Ti k yktukP  <F1?=Ohje>PaJrj`PtQt Nytt v0`tu kP Tallenna levykkee !dk@onoP2PuVtF?DFo0ej'unsW Ohק mupA lopQ4Lr  t
tt7f,Tpou@aurlisuinvojoan ssaPMrit^oKynytk La Ityl	
 P ~usnumep
o$-
t lykiu '
,(moPnu kiGa
/!(et  F0.t13!fsBg5*tehd 6OG" t!"$j;A6)ma`*in Tykalu"`A: o9K < Ki3Gvyt?OA9
 @p6( #Mu Ok"@䊢 a6nɀD;m@.DHILishieliHOIk aec o harll10p> H3gQO3'SB3$*3&Jatkinjot  nppՄpA^=d, ESC=Per G=Hyvksy=KywllEi ~N, JokuLB= UYa` fnuoli
mi$p_k b`h%@
sidsN <ENTER> m@t
ep,.I Lgn C0ss seuraavU:A ->PYi VLINPPIN =[s  <-bASKELPALAUTEdf"2!ARKA+!hTVAIHTO+', F2@
)_!~= we@!x<virh`wAkkua e=soi`?da.?: Rvdi 301*kac1pt~ a0IrtPTm pVeyt3ke`"6ko>@	siP.pRlaks`qdpssX` kaC9tqlaa@Q@_TikkI)>skeytyi Fn
i(0P2"nL_ohecaGm|j}~1?i eB tyyppiIn :gapll!VlisQ (L1/L2UA  ROM-Sb@nkohA	tuotepe"ɠsar`r|W@^`si ?stohjab T;{	&!1:"#2o L	3o`M4mJ`L#taAIovn7(j \oa)
 


\	V\J䑷kA'Gra- DqACu$#:D$ 9a%dz| lpi!iEepoӟi Walking 0 -[1Yloso V?aihtoe@ :Puvi7a us: Tm`'Aat0snhp . Jp>lt luo`ŕ}pus-  sn,irjRonc!KA: L"X $AYhkФuV V3beFAG`8p_Cpa 
Hk	oa]Wi !`zn?a Բ`  ҤH?,i`%(N92R`3p.M.A.R7.T.Arp$[n (min): 30s3 p2y0%cL <dv0 Ispysi- 4iVgR
{fb%untq'c{K)jServomoottj
Lau!5ÂvtuQj	k@FttribPti2 З`Žy@a 6eqKxe nGG9 UuVahvu Lx P>Ȕ@! P@Cda}A"+@2 s@a	,-ãPAJ!rn4-okkpDBad`5an 	nDP -e@7p$Rmysba
`kh@`! ЁeT@	dE	ZEY(2i0Xj [!K unQnawbay:p\veapahtum"b@^id FLaJ4ftii l <HP PrpctTools`cuQ`Pger -GapuД큶.f(-/U i` n QuickLockfa hlu5 qf,V "@PraZ&-8Q,:*sekm #o$j$it)a{d||}yh ' PP`0#UC.7>uu	SApor InfrPnR% C[D- -!fl ~QԌV"s ŎPANyjUWAiot;\"nn De"(1o")Jlola.    KYTTώJNI9! PSSANAN,0IBfw.la"q %sily1Mgur R7qg  gri^PfaZꀝAt]r
f$VV-`$U,Ap 8 iwLLAQ0<ѨWZ& OPAMA  Qops ) V
 suE=4:d,#tu@>x	 _4`o'lA N
E  U7lE r
pRw%y iC. Nyky 3b`+mPezsv6Ar
t  N. TmttS`|q$ihveip=upe1rRU$<eh?  IPa*?-@l@wp[1tЋHta1U]=c zAojAaiemlV|3tp. Anm "P$PtTV@UG. 2!`ZX2qїaF_`Qy#А ek rm@o#\X d,aT0ESC-n"sR;n,%'¦e'> F10 ŴY4aQaqw:	o .cVQ llQݠtmiA$ys u"bn MultiBa@Opc&Jlakoiu (ƐenA/$oi>P) USB$@)ZipEnsimm0 AKooelj }Vi@r}Kieit@ְKa0k Y Kymὁai Fn/Ctrl"mhAEng(USMA@UsPs#inla!ǁB- RsఠS Rn1 jPBsi PPs Vo'lh̙t\Vakio0s2sNb#Ig3uuQH Dpl verkko
WLAN-ro'Bl]u`Voth @/HE@h^@sV@Qs	 s`9l@@Ǝ
|+1`i<9.2v+-p	+ ?(ylosp*OG COr5EthCerPn1E Y oeo3o8+To@ p#gOo(@workQ#%G lH1liv3 AGkkuR < TAJq 0ѿ r{jolibr@du c`d  Wual^-OO  OI OK"kb_OO  O ONr O$O$O$tva_ O 1 O1 OMЩaanusBkOD OO OM"OOO`O
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGo@MOH*  j   In  SpeedStep  technology+9  ȠҰBk 1#vuCP`"ːiȰ  (se nA@S`: F12):۴i@P'5tappikoskePPP )mmaK  Ei mn Configurwati5ordPteur  <F1=Ap> Fichierfoar m Aff age Sauvegarder su?r disqdc R@a,r /'une.Hh_DHeals dfaupow du'Igno%mod1i Tpqu S$e l'in`p$@@reg om	\ ScuOrita%
e ssNdS"#j@e sous9 pKon.D
 priph8P %J	a sELIDy'As
Dr`<Lockq
S%mp(C0 Br1b3r3  'hePю5  1b#a <݂gre taR,)8+5p7am''us3;),;rfreCncM =``t"#Ou@[ !@OlonnLb`beriZ solecqSn@psQs AIA"TA BFoV,mmoir`hcBDX C 0ZZaFB_V A0c`oLang4 ChoisPJYl3Ind)!5_mps g! 5ePMd.r pa`k2Z}:z? AppuyDfatouqpo@gezu@l v=Ser, EC_HAP=AlHAccep S0=OuiuN*#Q3V, _N'impp_e``D
=0aw  UPzi3
s f'heM
mo!04ecle hmenuuceqr@r0wbriа2qh@z!y <ENTREE> 2nj+W	ss	sui@/fa  !/ :-> ou BARRE ESPACE/ = PBeb`-$IE~preced@S\TAB`CA*<'MAJ+ix F2=1p "w-$!S( rr`@P<TJ Il FA%ssibcQ7L U cs'Jpro9d{endp#B^$P. Coa<'401uc5CntP@-1 e?mplace(L' D SaQre@}C'y
GJ 
s}^ccueil dп "4 itaxsmobia``
WH 
u`  B!OOOF2BfCX|+)a ruW Fa0;cq0M\ Typ0osBVpwD3b KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numǂro#p	Rev`cdo e9rS2ItrQ/clav  LA}ud@;n@+/Zp/zr3/rt4n"3inv!/Qzi&5 #priF!L( Ute) OOoOOOBV'edA Eo M,T֍ :$/:.   %Er4 !SUPc;Wal?king 0ᥒ81lig'ad`auZvC	od  al0ifAtiHp1SC[a=9e@ptruAF ieЪvPR! /簹r,  z{ nro°c 	cY0]A}jDL_v
 tro Pa 
s
TX	C  _[Rvja"`dH.HOn m:YfPS 0"Ӏf   +-vaPC4 lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (co.et)u`|XpimA(z) B30堿s pAU0% nv$D9ʈl'hA+bF  `:˗	AsGinpnud'+,`vP`t
$.Lu( pϤG3p 5A`ib!O: ID P00@"s S.M.A.R.TAba1nG2WpW AIBY`se N!=apYeAÐ?/@;Ksa#A Mar uinKS;A, eecoac	;m?me, vK*ad11POobPbatCs	eSd4D	g pe>a1`a`(`ih s4&[,p@s蒵 `Ug"  formQg-h q#xѼsJ.)rmQb	hJU0`
1$AJ.6zT"p`QDP~aR avoupR!AfrCww7A^	 	z YR`(p"}ffQd3  k;l2TcgNq`rHP P`o Toolz:eRy Ma%r O4K8CF!/  QuickLockUsusA|$0cp!ri 9 2<S&ol'S+C)re!cB !
`K)!nk:,   v qi4//  / L' (a'a
S$ud!v
9 KP
dra+D hn 4`ExihAudP `  4raQ8llƙۗ<X CD-'EǞVpalJX
¡: !5pr5Sfe DriveA). SS@@@Adez deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z?I`!@р~`E"Q!qhsgr @+lfe/"celu&MsDordi`Bb. AW	z(@oDNU(er
oe cn U@fet#qxI+}M"+t"~"a sW"qmoePB: :""t qD)<<Z=Ianiq4 5#'Oǅ#!2/nr,"c̰û!pk!  3PߍIX!! ܐ!!{e ZQM7j]%uel@П21`̰܂T :H,g" H""o }a8 kE
O' fW'!b_^w# ,d'originIlB2v`O"2Cwa B	u
vqSaPAQy9)Pt0M`
5djabvBps{s`Pze*-$݁WQa0prs0`Ta ~aon: top @TP 2a3440pab0yt3ץk'
1uj,? appuy
`  ECHAP. @@ OTzR'o',O pui`CrDF10 TapXc1xCx Y^u}	U:/~QFrana
!OgvACJiMultiBayulBp!hA 1!3D,x\soca%(ga)OOFRz) U[8V USBfQr
.jZiprP: Dhi@sβ QuaQCiyn`NSixi Se ߑ  Hud NeuvCD`Perm/r(s Fn/Ctrl`s AnglpSA) IPopm1`s A@stanPhnROd'ad`n el^!trl3' Ugich1uer"&mr`
*d :=i@7idoAѫa˭Bid`Ԃ< 0 mm%Vl@jEK!al  R o!=ril WLAN (rsqeil)AϊgrBlooth7Sr/?1   ;)o`! g`N loc 9G ``!WnX-b61abP-n oR82ooypu9	3ccujodhogB Epb!t  1a"23T{okRingo oU/,IduT6*ao aX  
/     Ph ll`4 n!Hre0/ x Ab!AC.!f*Duph */)///tb// ///**- ///Jngn$, `/,/ /e ls` BtexЯ
sqbmoP/ /7/// ,///7[qRpe 1 : Char9. % ]A.  2D ` GicM*n3@	Rkio.b
* T   @@/M.$oOAg$Á4Amor1cFe"5 RetardBTexp `) Dtгa  F12tposf[iP+Aux  PatqbAKw~ ucun I@z!Nl1 <F1=Ai0>`nfo0gema	l p'Salval ?floppy%APttoRiprPina dmTh4ifap`i IOgnor`daed escis EP a
l'iI?z`ciBPtupv iczza sswo!%e aym C0ratoπ gPccsP
_QC*vos7v<% IDs
&gDriveLock	Pr`ǃ)S t C7 Sup; 
 c30 gHQg/ o +:,i fabbrP
4=i	/.nzi[Oco
rui C*b5<bae9dE`lrOpa@t2;o rigidAtaA'Vâ,a mepTW@`<HKhMi	M;A>o !Ava=t Lu!O l$Dim"& q6ca X sso e3viQ g&	vv!'#o*62wH8Premi qsiasuicsXperQZVu L  @i=f, ESC=Annu ,aA Etpoeo=SEiSN1T,altro#	=Ap bj Us"SchiavI frecc'!i1`vocu ap`=f"_`<INVIO> @ \k\'ke.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCE`c<ؽTAB@C%o"MAIUSC+)XF20	>-= m "AC"IErrxiS0D  Qu A87npupvse@t"Vi  	v@u4T|XJ. C{'^01 Npu0F>9a0 Doggiao L k`IP'0  Q>Cre0
4Es"@Oagga%FvppSAcғ  npabook"RQzespajT:\ Zf.atp1_
q2o{briu0Prf uduA쁳 ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1/L2 d&dDbROM>Iamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~i1$OFk2m3n4ࡐ7w PVSTe)DE(d)8
	I2
3
4摭Fonda
 ,o:EV$ TIr%OupyP!gTŒ@WlliASprB>:bit 0t 1ИRindirip	i] `|P@'FAЎso:5X%? gger `|vpAhAre!0M/rѧ, `1fav i PP`iVY&XA:'mU[A:"maconouAh(_ IISɁnQrita] Nsv@dpRl"IQOyഌSe3 `v1oPga ?AFbb iQfrea?@?: A51 (Rap)62 (Complet"2tio (): 30>0%`Q5"r6ar0䠈'hD5|
:s*Щ- @
˱֤(aD୆%aerAv|")LċAPLA'	rib i0gol: ID$fBan`de@z قi S.M.A.R.T.!ނuT0U _wordc(ncuo!i2 pDsc(Ui%L?b$q+d`ᗑ` {â"Znd ?՛O.A7Tbcq^B&
Am  AVf!B;Y@ECr	t>`J2fu"m y3CePe<RB #u _t0$s!1a哰.Q]@ՒbdFo!erdPКwatiwEff+Jizso@in  ca2i$vEvPgaOdes Х@Jm9Yy HP tectT?ools Od.@ZRV2+ ickLockspen`3B05EY mou2`s8 MM d?#<#,p;  gra@p'!oe -!e$ C-))v!pKsm@]0x!! b	,'URar. i lі@NR(@|ГV|a inf raQ)p y)o CD-" Se$DFVp:W<!SRQ#3ęwusanD e1&.C D6AF<P @@b}W'UTENTEPRINCIPALE  r@*;a man4fu`o. AnPV:Fc P0rо a!eQB<p@0b:0.l@d0AuULTkZs,^h	Q[m2H sbR;F 3reDV\b.AL N = Q_o0%54 d E h=>`@
 >re,@&q  d (`8t rOD r luogo DF T!B'    #h$ f@@ER#:,! vE</sI"I@5 -"̿WpCIlv {s"k mP0!R/DaB  /$BH@xQE ~a(  a~DA'aą gQ#}QAi  	 Pkta t{fa+ ueY/cdO ::ly0&.2nPqu_{9㐓!.Y)qA`YEsn OP䮅@K@1'56h,mP邆эo ESCƚM'Ý)dovQr 'Zn'pom!nF10. ! n!kKWyĴ_ 6\%גt quIP(i 3  ODA:D0@ $d5m MiBay ba1.ggias$Z) ogChi USB]$SukbC
ZipBP6o ;Terz `*OЁvN% ec AН" Fn/Ctrl TIngl  (USA)$ Yi u`2O mpl 01aЃR7pl Aaп 0̰Mo@eQנ Bidx0HCapa memqX5embs"FlDQ2'c/wNPs (_WLAN){oBluetoot}hCommu5Z/ (j)@sm energZphT1$0N&1 N*'2HIB*Ca6*(0F@o)ol,spo Eth0etWJ V123e Token Ring OE3 IahbyC@B@ta I   aov(  CP/b// TDzS^oo  YHiPDuPT /  o 6  / o ,o// ooba c  /  o uY\mo9S/ /-ooo oų///poo[ PAs 1 : 
ros . @% ]<ocomp
#2S' 4,n6E3`ɀ
ij* 
 /JoXaX/3i'o
   FlOoppybUAIAdc`Ƭ@(sec.)C velP`F12 b 2z@amb`Nu up <F1=Hjlp>@rkiv Sya|infoth 0s~ Sḗ pk%kigu @1( stll /frnl1n@ard Ann}uaa nd` ochslȠ  an ȑ~ Sker0 dPRtrsslpD  K!aOB@rt-OaEn ssp	(b -ID
 S ao
`tPd-Std fruqtQ !av 7K
byggd 
 usBi=*abrikP+ .J
sbeh #DEsktsrktyg Km +rc vڐ S`;vtܱ0HDD Ak_V Minnes : $01q5`?@An'@#B
Q  VljrD;cB^nedttlD!v(C-:j+eTryQI^ fri Dg@q nr du sviJPst0x X=, ESC?=AvbryNaFDAccepaF, V>=Mer X J=vI pil	cX	/pCa yEt
<RETUR> om6
YRWtt .ie,klj`SeerI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG FregeyK TABf#OKIFT+H& F2`+?z= 'fO @%pAoi?Cfel 3t gqL` 9kA@t h+AO` Dstod uGen. Felk0Q197 AsgF{P|plat  NtPh?m krv3? A @pbygm0 fly5s t6 -dator/r ex$(||0Ytidigodoi2-@kl`TA UkN4,<  Pr Pr, typ
hGast^hg0Ca-	rlek (L1/L2)Yd ROM,ސtum  familjrenummn0Ddeo,`r!Y t2tNb ~pqyrQ!]pH 1.z2#3$4rbinvp ˦3 (bZ)g	1[


.Sek# xAIrq.4$@gaxr#%Ex!z=ok!ŰvidClmissl l.s Walk>0s - ~P f1jH A{dd0s liJ7Ae nwVar! D@0/ѹ  7neh g"Ccuskapay 
/G-t!ڱx)iƱ=k b!h$2AA:1R K>#Rhi{wIBB?skyddadag

   Eˎ҇A!^Ԉ  |? ig?D܇jGa- 1nabbH8f@րn`X9UWk`ad sk$pQd (0): 30@np1an 2?0%bX `A4Pp/]pp0N1vr ka𚓔tPo:,t8	!قOk%S(x ervo-LzB!i @(f%ttribut: I1Dpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ R4d% pm}vlika mǄ  'InE?kan orsa@3iЈP9`aHSsNypPO@Om=<s1A1lo. 'Na om hglqmabtj@D{eh ;else- @^uQuayVqΦ >pfun p0`perl^|7!i HP tectToolAs%٩R-6-Quicka"q`telge Lp׌mPs Hgk
gppb*_-  &q2@&!џ!!r ngop"pKF5bli`X!aot. 1Kж7AompHMi p@1f 	  Pk`anCD-pP"V@t N
"4oSq? HuvudG@x@H: D`+@l<uAhrdsd D`}e. .Ч#`a]r ANVSHUVUD!{@lPmaqt W.[ !q>`KՠρQ@ild fr0!D+A
 GOha80w L l 1փ'lGSWNQ.X (oF XAd/bbygg05P0C g`2///dY5- FbWL:omC eB
7(b!>= a >Dq8asB 1GcgCZ.@ktu0ai`QafanDpkp@.Fsut!L#\tg`Rsp]Vo,sursprung_cJXJ. Vi  reko@ޡt2F	B}c	Vr й`+,ps`_:b@}. A `K4ɡȤ˄3w_Bg  &Ӄg`!(g}A\yO-beflse qm ih𠞰ђflj1ens. Trp  >ESC- QBSRV؀w#`'Z'R-sedMt:aGF10@0cVi3a:+dDB1}shxE A7Sve a 1: N?, MiBayCrut@!}opBP5vi Ba 0G (Pr (3h aSB |G Zip-=0PW As1Fj!p1 utto NT VxPFn-/CtrQle  E@{ls(USAbmYkd !AA b`nrmstrorx+,xf hbbel|orlekhPeo2ne FlkpaLHPaIfEsǻio"trqtK (WLAN)Bluetooth p/(6) -v@{ANѾmbe^ Aggгs`FhaE%-21,2v[,p$ΡNed ECth)& 0	3n To!|RQN"Unik '$<QiD K @tus      S"bo Kalibo d@p{  F:DualQ.O 
o 

 
 9
Fo 
E 
D0!j1s 
Aoo
Et
Htag  *o 
* ʯ
VCy emo l]A*5ooe
 DIOOKood
D?[Ne _ : Lapr . 0% ]
klar
2u j253om FjOF* &V@1 >I *O!DgOߧ8U«br@4sadap@$lg~ rdrjQ>snabb0 (sek. F1 Bd StyrPguen!he 0ae/ `P}Op e@slaan ConfiguPpoanaAfpv8t ardQX3!/  scy	~WijzigS%ne@" programma @|0Setup ; zr w  ؃9svei !Behee rswachtwo o1څ
 $X. Ap aatbOgl$$ ID's 	XSm4CP Lp Oau3(P$PcR%mj+%O
Ge0g3 gssvzie2؏"Fa?brieks.Cugz7/);Vref.s:nieuwB8ON{c  ExtOAccuwB ZeN geselec Ea  es  zelftGa -schijfeai`Act PX
vG0u?1 I R!a/ 4UBgDAcg@7n ,DP=%_
 Qw 9aKc!:6 alaal =r/em 	rijsgemaak el;o" /;9
8ukAZ ]0ayMLg]@f=S, ESC=Annul"EDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`geObrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
crƱ]beZo !vol%@@1  0aiX:  -> of SPATIEBALK =><-BACKCEVorigl)TABb	#EHIFT!+%%ܺ2+Kq= ykp=t#B~fouta64k p It w_ge15 F0MgetreqatijasFen. AcoZ0Q1b`a0.i1ZCu  we   Netvoe are0#FMPNp diVbas`e3
 t n0 notebo?ok-pc/P) @.istNpOQbep*Gigdooh2L	MЛaft NmpALyp~6rocessnel3Q p9p OmPЂP}e (L1/Ly2`Zapac?i VHaROM @ -s!fS<mm E  Hebvrgav|_0ideokp&p;b bpM@	m	ra1b2rd3e4ahisgI t}.jne  C(_B(ЉwMdzQ%)
  `D#SecuibE.aw~~$Ftb%)҆2! dHU2L53Hac-0-*1Tho_ad/resrlafwisn/d pao==LTop: zPٱt<ts ev'ge t PS&BbeЉf  s d1 A:|og-  / "x0zbLe6`NoffaG1Y\f_dقڑD`H

boචgAt
wOC'We nu duъ"
wi	l?oݩ""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 40;q{ho:5broA):]eeqx/nb!$32#Nkvo-IPsE I"
20"qk:J S.M.A.R.T.-af@APP@udh "/:Blo!  A I -7B4kXqcrlpSX8
 Vr!a1& iKs bBs AYoCf#/k, Tm]lijk0UKQΛ zoik` dvor s:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$ uswb sqwYfur9houd'Hi`!  AQ`R`T`R&BhѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gspp`&b TWm E #M"Mg$rgΠ9b 6  ~erX#W>,.o(
h( o( S("7'EAJb"f k otraakP)5w sXbtK;?@ݳ ]Qŉ ڹp1׀frapd  Par<ˊ Cd-r 7ćHN񸆆Hoofd8UGr@JD  UQ0w`f^bia D1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  p"an< SSC  hbwACI \t fykgcompS$ajsLQ}ZP$t d0 Bb&qӜA. @XPpQ~^zAutompJc49	yT `r:ZcY<<|7t7 O!V)?!9NP sN!= !. MoWd@LioNTC,p@  #iRS8`pò̀QU nt@ @Odq K/ # `hui,50d@wұwas to/!k w΢geaГ. PWVAnvloeC~XkPhWSs0n@Pܩ׍zYUTr!ra=8	2 torH/)К Bget. /o
 s  vBn. Om2un
1]ѝA&`3fe*& golp q. A_ӱ_,cdtabҔh! Dcㅻp3rukx3!ESC- ( A9н02i Rb'k'tyUbkn F10@`T*Z lusTB r`V4  Neplg g MultiBayBjVzkd@\~base (gks)re > USB-Մ cb+zp-f ER we$瑟V V@{Zes >Z>Aa8NFn/Ctrl `Owiss/@ާ`.SStaMcW3M?ijsappOU e 0 nгlBij V o-1PFA/Ah뜂0d`dition  GT`vgp<uq=VpilatxE?Bvp neVd$Radioj WLAN-aoeBluKeth/oG`rgieм@qYI1[,(	b!)ۏf`Et@0 1
2
3fTozRa/-OMom@023 UUratcu!G<< 4us     SaGekali@!тOAK"r2
NQc ualP\J OOO EW OOO[B['OO&O H{ap! 
O$O"Lpier-MUE-$J$OC$ Pn+OO+O  [jp 1O : Bor. % ]A@/&p[лd2knte~l/{	3	#Ʉ
fo@hl/)* Jt  ;>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno <F12 )Kbb@ cuorsorytuyEasyPo-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕ  ݒOCOFϕĂGg&f 
H
gɁ  Hoד 
ɖE	XɿI  `AO̏ԂW܃@ea ÂL(=eA8`LCǗ҃pj h/dCo'o "X yf@\̗L/lE%ID&ID:_ h (uN XBSA$͍ݜeX} 0g J 23T|OH, v".eI*"%ɀ;FX
 󖾠>f
cA>oAe̒?  I(f:nA%e> rpCeBIvCǇ"F@ `F  /H D%Jc9J; ڍc R5BM NP$ߛA%EL@U`UO tB!#sNu%.37($b74L[BRׂ af=!A/Esc=C@bsAS6?0=͂
  aRAg)xgjq5\ 3Ogp] jk?ڂ %iA@gp>[Ex]  egȉ#wA1̀r_->Epy`tOo[ = ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+0eF2!,,,10nmF/[%  !CG[  t@DBCł}@BDr熂p o 01 yNF`+@~3a
ɂACOk ~Kvժ@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e׳`	{уɰޯ   ۾ ̽ xïݸ  ށiL1/L2"`OM OMFرԍ  ޵ ޼ޮ  ׂްޯ 㰽ir G#2.3N4h	 pşch3(Â)F(E-3N4(JPkvJ _!ndFw Xco&pF?$qv sxП6!;LsV+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊO GPu 7CD-pu$(3H\@}@^ 7Q: axUKߑ #i C^"c.t%`D`y x7"	3@9>Ā+ VAT:!eN,B8i	.	i A!!F	͎v2R qĐR`s񽂩痣HSCۊ2"o"F`pAF/'ưAefw`6W1E@<@߰ XPۏؿԓ "b͗L iς`Ȩk)/)%)!?𠠐ƈ UX3oNu"*fBBFa(o(e|L~!@#$'m8`X ( IO) F)u
((?(9(㜨gDs}Dv:#<43ɑƈ	{MS f=ɉe|^`Fa)F1j 8cB  BgBb{aȑOB%O#&H2ef̯"8먎ql`ӔC aU$/g'"wEE[Esc]1 쉟`}~elaӫm⛡TN?DriveLock t[F10a MS  y_97`E!:	 ESxtkGb`ÓO xXioiEcUCSB Xyp H Zip1Ԗ 2b U3 4"567B8910r Fn/Ctrl%̐ؑ |`{`\p (USA}) `|*B#fo+X>
KV&Ws
v C\g @}ZJ@_z rIo`̢ W}o% тACY O͏o̧al"Ni!LANj%MdBl?uetoot/cj!`ߓd p
 2*"*1 ͯ+2'*3*odhEthernetX 12t3 gA 0p
AOKO3O <hOp Bj!% ID 2bJ aK C     ~р^`f`&? kejY  o \(%
*nP/h/!!!MEU 5r$) o3xoooD2q!5bv1 : [dϒ . 0% ]O<2 !gOv3		)J	*   5`$>s'pmj Intel  SpeedStep` technology
uGBH 	_0ް Ӱ C@px(b) вSF12Qԁi!by  ^ `pbZB  @d                                                                                              /                                                                                                                                                             ` a b c d e f gt" L           	 
    ֑  
         6    (    .             @   / 0 $  3 4 b 5 6 ,  ( )   , -   * + ~  mp
 uN % @.   mm $ + 1 8>E K RXm `@E<B7B<U> FبE0`8l v x_|v||p0p7c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y $n%Ap E%  IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:?5-_V<>1( ) +)#/!'?
ߨ({[)|+}][{]}_'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'߇(

C$: |  s+'()+'*&803&b

OO
\()| O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|mA  m^2@  .@  bmƨ@ ED @n.+mL@ŀ@ I mp  U?q@TrArBrECsDsOuFTueGuHTvP Ja 7 
m9 rdm?xcmRa em?gmU@@p < _fm@W{YXt|dU Zt}[}#L  ]~& T W_t`$itVa!
	$
| 	 
`	
 `
`
fabcDdeDfPh(>{&N_m`@    @ڀ
 j( 
( 
r l0 |n o : *R  	mQ$ $ 9 0
T VF10 Setup Image_SETUP  !D	Sq  ;S 	d% *v@Jäb"P Ta|` C6
&$`ԩC ت TԫTԪ*J<g!"$Dcz: 'ᴳ4㴴4崵d紶4D8b_ : (m
6  ($))$**$++$,,$--9 -g  0	>`
9 
E#8i3jG@ #!" #" #" 
/8 RMUNLNOO 8 @
: 	 
     * /	&WPv  b"    %    N''!(( )O)P*Q*R+S+T,U,V-W-X.3V
md-dh.h1dii2dj3j6dk;kdlIlYdm@mCdnDnJdoEFdpGpHdq5 ajmfoq$HrڤHs $[bT{̠{`{|U`|$|`|`}U}{L`}8}UB}. ~X`~tYu wxЪ~*z{  }H kv 
44(3)]Bx`o2*您T$\W` 䇧0L'\t ;
敇td @9 ڠ
GxTnaWLR@ \ b Uv @} L@ U@ X z @U @_L@ . UH T j@~U ( ̀ LU8@ R r  U@ }@L,@ UL `  @U @5@ UB Z t @U @}L:@ U^ j  @̀LU2@ T f  5@@ UV z  @ 	ޫL@ & : N Z@dp @ @
L*@ B V n @ @ޫL @ @ `  @  @ @ `  @ 
C  . J@bv @ L@ < ^ ~ @̚ @ HR \ z@U ր}@L$@ U4 L ` @U @S%@ > T Uh @ @T@  " & U*@.6P Uh@ M@$ -@ d Ֆ  @WL0@ Z  U @Ȁ5 @ ,@ UZ   @S@1@ 4 B UP ^@frU~ @5 @6@ UN x  @}LD@ U^   @B p j@̀8@ f   @7@ Z   @TC@    5@@,@ U 0 F Z@Ux @U @U @S @H@   U .@8@UF `@tU @U @ĀU @
@>@  J6 R@r @Ѐ  )@ F ^ v @j @!@,@ H l  @"@U@ n   @# 5@ j   @$R@ f   @%@W@ L b  @L AB&@T@ > N ` r@A1 @ʀԪ @'L@ 
 *  @AI2 48U<@V \@Efv`h|U @ (d@ p   @)A@ J `  @ @*W@ H ^  @Ě+]@ Z   @,@[@ > d t @j @ -@r@   0 N ^@| @.f@ B P V @ʀ/f@ h   0i@ rԀ A	 @1@W@ ~  2R@ d x @ @3h@ 8 D Z j@ @ 4]@ ( @ Z t@j @5 k @ hhhhAU@@Vp U@  6"$ F f @& 7}@ X %U @؀S8 f@ J d U@ @h9@ l ~  @
:@ 6 J z @̀j @;@m@ . 2 6 :@@Jh j@ <@ d   @(=@    >@m@ 4T h^@z5 @? @ U   @@@ hB Z t@j @
A@ N v  ʚ@ B@ tj   C@ z   D@    E @ z   F@ j   G@n@ z   &@H@ f hUr @5 @I{@ UD T b t@Ux| @U @U @Ȁ J@@ > H 
hV$ hvh@h F K@@ 	hJ@vh @L@v@ p j  @M@    @NW@   4O j@   $P@    Q@@   R@    S@ ^ *  @ABS T@ B R Q~ hA1 %@h@hh&Uh
hF@Xh^@fx @j @ V@˪@ :@ b ~  @W@ N t  @F 
X@ D Ud x@M Y@ V Ub v @5 Z@ P Z ` n @ښ [ @ R l | @ @"\@ Z  j @]@ڪ@ ` r  Ě@^@ l*   @_   4 D@`x @Қ @ ` @ , B X l@~ @j a@ @ hhhAU(@Jd~ U@ "b @ f   @Zc%8 UP d t@U @ d@@ 2 F b@j @e@R@ * : P@U @U @jh f ת@ H ~  @g @ jj   h J@ 2 V Ђ@@
i J@ H |  @j@ . < JVd ~@ @k@@ b  j @lT@ Z   ܦ@m @ b j  @n@ j   @$o@    pF@ Z   @&q@@ \ Щf z @r@ ( 4 < B@JRX `@hpxR @h պ@̀s$v@  
 I6@> \U @t8@ 	,@HTd |@U @Su @ < ` 5 @vF@ 5  w@ 5  (x @ 5  &y@ 5  .z@2@ 5  8{K@ Ux   @|@@ ABJ \ n@~A1؀} @ 8 hQ\Dh~JЖ@~ U@ʀ@~*@ B b x @ĀN@ J `  @j @&@G@ d x  j@Ȁ Ҫ@ N n  T@h @S* *@ R f U @ն @T@=@ F d z U@ 5@ @ UH h  @5ր@S@ ^  h@I@ z  h@ T@ (J @ V hdU| @5 @ e@ U8 N h @U @hhhhP	hA (@U>Lb t@ "ؚ6@ b*   @hi%@@@ < `  @ @Vh 8 U^@l U@ʀ M@@@ f x  @h A hhj@Ҁr@ X   @R@ f   @]@ F n | @ܦ  D@ \   @؀2 h@ * h> L@\ @@}@ ^  j @ @ ^   @@b@ b   @* @ ~  ڦ @ l j  @f@ ^   ̚@@  2 N ^@z @ʀ j h$hhh@U*0 >@PIbhz
ЄМ@Ф о4@ @ P j Ђ@j  7@ > \ z j@ M@ L t  Ԧ@ @@ h j  @(@    $@    @ x   @ : b  @2	h
@ : 	hX|D hhDdhh@h
T@ h >@JURj @5 @ Ur   @M@O@ H U^ ~ @M @ D \ @ @@ V ~  @ƚ@j@ > v  @Ȫ @ @ L f  @Ҁ@ < J P ~@ @ \ ~  @@@ @   @@@ ZJ   ؀5 @ UB f | @U @S@ ^ ~ ՞ @T@ T z  5@
@ hhhA4@Rl @ƀ .@ p  j @@ R   ̚@@@ H l  @j @@Ъ@ & : P ~@  @ T n @ @@ < Hj P X@&f r@ @ V   @@   2 @ @ d |@ @ z   @2@ UD ` l @5  @ U\   @S@ ~  5 @ @ Ul   @S"?@   M  @@ J t  @ T@@ n   5@(@ d   j @ l   Ī@ M@   & ,@4<D L@fnv @ @
h$@@ & h4@UP x@  @ 	P@z ښ@@@ f   @Vh: f ՞ @4T@    S(@:@   M ( .@  5  "@/@ Uv   @M@ F ABf x@ A1Z @, DhhXDhht@U @д @䦀 @@ 8 X x @ &Ҁ@ j t  @j  @ Z n  @A  T@ J r  @T@8@ L v  @Ȁ g @H@   B Z ~@4 h@@ hL R |@j ؀U@ V v  @ ,@ @ n  @즀 2@ j  hj @@ߪ@ 2 B ^ p@ @@@ N r  @ H@ R ~   hhh@Ā ހ@ 4 J ` @  >@ 8 X j @&@@ P A%U^ @  T@@ : P f U@ S@I@ ^ v U @րS @ @ L Ub l@t~U @5 @
 @ UL t  @ C@    @ @ h8 N@x @A@ t  J @Āh M@@r@ 0 U> P ~@M逦@ j Ք  @$TZ@ z   S@\@ j  5 @Y@ UF r  @M$@}@  5  ,@M@ Հ   T s@ N r  h &@d@ f h)t hh@h@* j5 @ U< Z d p@*
Ѐ ɮhʁT@@ h   jh @ j   Ě@
@ R p  @L ;@ d Ւ  @$T@@    S@ t  M @ l ՘  @"T@ \   @ހ CB 2 R b@zPA1h hh Ih
h8@h\kR j@r U@ M@  @ 4 UF l @M @ 0 UV j @ղ @
@ 8 ^ @ @Q@ ^ h z @  \@ : R ^ l@r @ \$@ > V p @ @\0@ F n  @@ d v  @̾\@@ v*    @ \U@ . D X Uf@ @"W\8@ N d Uz @ @\U*@ J \ f hhhAp @J  
@ 8 "^ @ @ 	+\@ @ \ %~@ j@ր
 T@  0 H X@Uhx @ހ
\U&@ H ` v U@ S @ 2 @ UX h@vU @ @
\U4@ R ~  5@, (@ U   @_\(@ < b@z @@ v   @ꦀ -  * B X@`n @΀@+@ l j  @$@ P x  ʚ@ (@ t   @$\T@    @7@ h   ,ܫ\L@ |   '@ P jR  Ш @@9@ N \ TIT U@z U@ U@ 5@A@ U* H ^ l@z
h $@h AQAC@ @ RT j@M 
@"@ Z U  @S9@ v   M@׀4@   8@   @ 4@M@  !@C@ 5  "1@ 5  #@@ Մ   $TF@ T   
̀d>dNJ e`@eA1@% ,@ P `@hЊDhвTA @ h& O@ , 4 J j@ 'N@ \   @ ( P@ F p j @ڀ) c@ . F n @ * e@ Z |  @+\@ . P n @ i,@@ & ު V@l @-ܫ\6@ R f  @.@d@ p ~ j @"/6@ ~   @40@d@  ֦ 1@@ x T @5 @ 2 	@ U* 4 @ \@Ul @M3S@ T Ur  @ҀM4u@ d v  hhhШA @ؚ5@ .J F l "5 6v@ U\ n  @M7Y@ b U  @ 8@z@ L xj @L@j @
9z@ > j  @ : @ J ^ t @ @̚ @;@@ z   @2<@@   = b@ \   @h4>T @    S?a@    @
@h  2 F  iZt @*A c@ j    Bx@    C@ v  ڦ Dr@ l j  @ E@k@ v   
F@u@ v   G @  j  @HR@ t Ђ @պ &I@@ p  Ж@ ª@̀ j@J ^@ & 0 > b@ T@
΀h Kh@ p  @4h $L @ U   @SM@g@ < Z Ux @M &N@  M O@  M P @ ~ 5@  0Q @ 5  R@ 5  S@@ Uh   @5ڀT@ ABN p @bA1 UJ@ " @ NDhnDhІ U@ ր\@V@ F t  @ҀW N@ R n  @RX^@ ^ j U @5 @Y@@ UZ z  @M
Z h@ * UJ l @[@@ & 8 F z@ @\@@ > Z j @ʚ @]@ P z  @覀
^@ R jj  @_ժ@ |   *` @ V l x @ª @ a@ * N p @ښ @b @ T t  @c@ h@hhhA8@UVz @5Ҁd@ U` r  @Me@ < Uf  @ڀ f@@ V r  @j  @gT@ h( @ j@Ux @Mh@ F Uf  @ʀ5 i@ U & 0 b<^ |@j (j@    k@ |  * @S(l @ l ~ 5 @*m@@ U   @i nb@ " . D V@ o @ j  ƚ @ p@ vj   q@ j   @0r@M@     s0@ j    tߪ@  @  "u @   Z @v, U: H@fU gƀ @ w@@ LT @$U* 2@HRU\ j@@@̀
dh@xЩ hL@zJ @Sy@@ B j U| @M z@P@ P j  @u7L4{@@ M |@  M } f@  M *~#@  M :@ ƀ S@   5 @@'@ T z  AB @.hA1b n @и@hDh^'L , ~4@:FL ^@vj @
=@ L t  j@Ā @@ , < R \@r 4@@@ U8 V v @bYL5@@m@ UF l  @ д@Ԛ @@ 0 ^ t @l[ ܃Lj@΀=@ l |  @ @ n j  @@@ p   @ ^LJT ` l@~U @΀ @T y@ >D T l@U @MS@ 2 J A`LbahhhAt@A  @̀ I@ B "^ U@ M@
@C@ > )X %z@  @  : J@hzR Р5 @Y@ UV f t @UʁF@@ , 8 6;޿LeLB J@d Ԛ@@d@ j   @)@ J n h@@ \@ N |  @ ) }@  , U<@JXl Ur@ 5@ w@ Uh   @5"@J@ Uz   @S"@@ r  5 @@N@ d   A2@     @ p   @  .@ 8 L j @ ҒTI(@BrL@R  Ԫ@܀ @@  ( 8 B@6JL>^@ zL
^@zhh  @@ L f ~@ @@e@ R r  @Ѐ@s@ d   @@ j   ,j@   @    *@   }@ h   @րQ@l@ ABJ \ l@|A1΀ "  hBDhb@pvR @B R@U@ 5@@w@ U\   @S@@ : P Ur @5 @@ U> V x @ն &T@ t   @؀@ (T@ p   U@ S@ : V Uf @5 @ @ U> D h @ռ "T@ j   M@  @ 8 Uh  @@ S@ n  @j @ g@ . : X |@ @ @ 0 N | @ƀ  @ H X hhhATd @վ @ L "n @ @@ < ^ T % @ @  P | 2 @ o@ U^ l  @ʀ Tf@ P j  U@    @ @ h  @2P @ր@@ ^   @, @ bR  ж@Ȁ5  @ UR f  @SR@ l   @Ā @6T@ 8 \  հ@Ҁ.T@ z   S@ f  5 @,@@ Ռ   
T@ l   S@ b  M @@ V 5  Ȁ@ UD h  @ zqޛL
 @ H V b  t @ @xi@j 
Ѫ@ @ ^ f lT@
hz hA   @ b xT @Ғ} 4 LS@@ B d U @ƀS̀@ J t ՘ @T @ \   5@@@ Uh   @SЀ@ P z ՠ @T@ p   @AB@@ 2b HD hA1T?J j@h@hDhhXoUL\@T@ & J V@U`n @5Ԁ&Ԁ@ Uh ~  @S
Հ@ . F U\ x@ @*֨ @ An  @Ā   @ D L \ z@ ؀@ 8 B H x@j @@@ : T n @ Κ@ڀ'@ N h  @ԚD m@    @*@    @ ݀@ $ 4 H R@Zbt @ @暀
 @ 2 F X j@| @ hhhA5ހ@@ UD `  @ì"  @@ f   @9@ %h  A%ƴ%@%& L p @ @〷@ 0 H n @ @ @ 2 D V n@tz @ @⦀@ H |b  @@    @@ @ t  @ܚ @ z   @F
@@ h. U< N@bh| @րԀo@   6S|   4q@    @ x 2  @  U@ j   
TYB, Z @5@@ Հ   T j@ f r  U@0Т @
 * > N@TZ` f@lrx ~@ @j @@R@ * 
h6N IT@\ rAQ@Q@@ h* D U^@ 5@I@ U\   @5&@ Հ   T@ `   M@ @ l ՘  @T@ x   M@" x@ V Uz  @ԀAB [@ 4* F Z nA 2U @΀"@hhDh @ < J d h$PnPm/ /      
    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Ts# hNfP u	fX@  h ^UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"f,  ,fUvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:tw'_^
QRfU

}0tCR>tK-tE$fu
0t0t	dpQ  f]ZYPSRi u-Rr-&-sG tu0< 0
Ag'fA$. +"(zwZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	P#X,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>8A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _u,# XA	u-->1&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7ӥi({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/	` 	R
~>  6P ې  f8=hT+( @Q u  f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\KuO@S1y?"w5`,=KuZO苆FFKu FQ$-$G^f ? @s++g^D	%ÉD	f8Ƨ2+f<v PfU IfPIfffa$f6f> f	>fBf@)ff]Xo t *̠N9ԁf_x@R@Ӄf;3 ZpbЃ> t50 A0*@@!p0 U
@ҟWRV6H 8f;tff ' F?#4?/$u qcf gfmEˀ>  fù fQ@;t)ogf+ C k#@`CW`Lk Ѣ}GÿGPV0w  ^h0 ;u}; ?;b4P4SXf.0Xa0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6Tg  z	Ad  !
؂  	 0 ! #n#   ˀ  _ " 2 r	 .>  B
   ,1         K   S
+`,&,A!Bru
7>, o  >  t,,,>,,uǾ ,"_< tC2`r,_Bb,,,,gQ	`PVB`
e3ۊ؀`,&~-,;-g3 M,pVS`@t	Vm,[^PQVߠ,0ӊ"@ӈ9,1,Wf u5uqyS1-,߾5,,-[^@sfU_>
-S>->-G&-t(
ߠ,bވ',%,=[QpQxVt>,, r1,w%y0r ",60}S,  gm6bdhETe!)) `!Q	pDt1,8h[R-?r-&-w, a-PRVqp!)7p	* 3:  , &},g&&@v@ '1&s0 ,i>,y $3P߶ % u> &j
'
u$uvatue&u^\uMu:w
8FPu)wttfpF
= IL^1X@8! u?	g&AFtF@s|S,X[0|SRV#+WC^/'ۊ»
1>qZڢ,A,I,Q,Y,a,i,2.RtvM,AW>pI,SRA<v
T-,-@,ʀ 7,G^&r )&uHIS	
I",,,:,w/=,!g
	߄cdx
	,rg&5tU,x}r],_dr!"E,FKr
 Jt x Ztĳe,=2oxL13
	upePaD$[Xހ[Zd,_@[Î@[,_1<ѿN &>luBSQ -f3fÇ2̓A,fлf3 =0^]-dF E *  <Fu-3t	 Dt<Hut25t5 y2$u tPX- }- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2rt5>s5oAbqurY(q#VWpptAQ ft(PǴ:-Ou 
  gXfCYv q9~ w2-k}-0t&-^8r ۀ>tw
$_ ,-9-2 ,f? t<C<tSQذ&Y[0u
~lq.u     	`h 9W0  q8r8 !^ !;   ([[\.Z:;BB^RSTT::; UWRQSPV 
rw8t ur6ffWRfP0 eXhФLfZf_]+8 wƶ8-aPS puxg8k@i8l8c8/zmn~d8|poe8D[XF f sf Ձtf 0-[YZ_]e È88 aQ b8Pj0fd1u!8! ddfdm԰  >P6Sd ddSP (88fU{t=T=f]t,>@u%ttt t	tfN @8tF ÿ!r@uabl!s
 1Qh 6Mu߰Fk 08u$
SfQVێJeS 0u
Nrtـ?Pf{D`*f of0T ff/fXs "qwy#upELe~8 v` 80uYk׋f0$ fe~8/NfWpe*&~88fw*fF*2t*܊e&8fXfY[f`A_-+',!(-8  ۧ`ܤb "u!ựv_8yW t8!WfaSQVWU&- t 鿨i]_^Y[LS-120ZIP 250:1:q2:r2q2PKp x
}
\5	f8Ls!Org;<tV< uWQ<f<P\g&:D=FfG_(*X!X  fJA`u x8ֈ-q8k8r8l8c80 RW1h
L}0E?>4/_M-Sys   DiskOnKey 1 #azB-u @  f<x fP f0Q_>"~|= 2r 0w"1s sU3IH tqR ff@fPuLst6Lu2r{	uABc\,f_o PA rLTf<?PmRnRdVPeF5Qome}E2;; t0hDt;@ u`^gu#3 Af?LfH@P 
fXuײ?D0 @0|B0B0pJB0oB0eG05F6F 	 Ϯ&3FPRrco3W1>ߊ#>;!2>
1_YGh|Ph`p& 4  ߰h*< ZpW+ 1s!$?
uo$˄[         ,X @x
dY rTBB!sh5@  i|X  t   	bho4<fHffBf[shPJf&
dh/\uf
{dw&f  ffBfP  Bf%ꣀ% @ BBf  z6fBf=A&  `  fAVfaDf=%{t 5t;@3tZ0tZDfX$0g]=C  BIǷBSf@ t|PBo"sƑ tDf  f qBB<Bf>B u ` _D  2ft.sh@P ~^#rfu$B@s11 >B@!R0B'r"b"0 f!1VC@f,S	  tX	"rH'	"	0 
%9 uf۹-%tVq00 ZP3BP  	PB-tsK '	B -  rfY 
 pQDP؊*oB@6Pf>BgGf	gOg>{G]`0db>ğ,"3	0	ȭ`6@#Du	%&shf6Bf	f BfIng^g~W!
^*t4 ?0		0		{  FFhgJԆ<t
 &vF5"p+u
 ߙ"؃ CpF&rFB&tFqN&]gbL6%@( Bf (f 42a3ufBW  bf5t0awSgff9Bu gF9Bu 9Bu
gF9oBtgNXfFBzr=jC=0rxiGsVfqS'`c(gF'	Bg^ g"G0gF VN* /e*emd&b&g&g&G
G
 d0G]d*PGg&Gg&G
 G 3gn Fpp5t	f 6AkG^ 0\PfV csf@mdf p^fIf!B&BB+B(B  B < tB  ;v?ȉBqv ߄ f@x
BqygfOgG p ,gG
	qGfu"a ?H{f%fE@롮 !gG!&B߰B Gt@bk!qf#pFcn૔`_Oâ'PRx7з[fS
f3p5f$fӃ_\Qfyp#{-  !S䡍iy s9At ```*`a`b	`c		0]	0^	  
		 
							
 0hfoWQf`!Yf_`QD=ft8D=s8MD
$>i8%
ĈD
8 r%詿 >s8bcASgsL8rI`d
Qr7R@|= USBSug&|=w t t
U	 	`8aTX 8OΡ p arQ?r C0( z%rP`8M`2P>8?t QrIt2Q9fF`AdYrٜSf1fM^!WA@MH\
w؀e܉\b: H
p(rvA
x @
`0
!?
0
"sTq
=aWa'"CS# iD=qp*W.?43'PT2' oZp(Z
}2(
y_7
|_=%t99 R$RS$2Q	@ ?XR!@RP2 3* >Mu x T=
XS<(fT= & y#j688 r}fPQtA3`>~8~8p+` pta^Vu6 8 +.\R?f.6XROPpYfX`XRI|G<b8 fa9?,B3U+*/G/%QfPfph`1<@YfXY"N0\ՐJ?;G7/Osc`MoDABA<e=S$l=38%rp/8Mt;~ MtG MtS8D$
ƈDFP!r r
9rYԹ ;/p%tFPtt=tT= t2:t+u:u hNodty(u~~(rt{^@M=@tM=tM=`	tM= Mh)6`oXaPSV88dtd߶}LѠrFl@Ѿ88Dt_D$PQM'Ph!Ѡd^[XSQLO	8t`g	G	Y[ -N i8 w  `  8 h
   0p    p
		
			 				
 

  "@6/a5 .86_88sR.IɽXR&-8e 1vs fg&[|tEB k1W++			MbWOAW`9X&,8r,seÖIXQoIX>pZ RsQHS r`QQQQ-QQ&pa\W3
	#~[rgAೝt԰ÛY"[Wϴj蛧rjstx6Dtq=&["[tOt"[sf?h~  W~~	~	~~ ~F
}}}T ` !sJ%tdoo%"o:u2;qqq!(~rgpppp2opQVpWL	;t	@PA:ʶo9X!}=^YpWpp"I 0   0    Ro d    n  }A` r 00 3`U  
& Aa %  		%
0 #
*a
|W 
3`@& <@a` @A@ @
b
	CF
? ?a	 "  d q a	!?  % %@%Q
 +3F	

 + (PE+
3$ 4̂ C8$ +(3+-E-( C -0294 - (`(E E3  .c+! 0
 @ /9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaXCJ UK8'(XAIc  WI defgghCopyright (c) 2001 Intel Corporationf`@ f.B<t<t$<tc<tK<tS
df&
duh sf
d   uh ~  uRf|ADf380=ISGuђ s
g]do!t f6d	gftcRa tpt5Hsh @u  u u0 ߰#> 2  u
P f%3 
f>Bf5Dt	u)fB;Bwuf͸@ffhgUtf3ۊf"ZQt
0fs
B  v@#tz21݅!<u'g


7	u\	Q	M'h/%_BٿKf6B	g u%S FB s@[%;u!,f=4R0	?ff4	)ffp	Q(}f	f@f[aSfSfQfRfV*sWuh15 uu7 tApNC6g88fI4g^f3f@70}@7f^fZfYf[fP"Vf
Bf=`Bt"f=о &f= P/f=0 3f=@+=t8t34 , 't"#
ttfxh0 rfFgP0fXURf.  fXr  >	 QfufQD8@M TR2@(2Of2f30c)BZ{RO>V\3h/T+( @Q u uf3`_fbDf6E  Z<tYatG@]_ToKg<u		upWJ$< t<0t$ RH]P?y"PWT%j_uPiAP#,RfWPR;Brfc%1f f>=	f!Effg8u#>_4:44
f@[Jf_,,PS>t{w&-1=`QYr;f.;lt3UuflA<mpfAzffm fPtP= v	 +v:P,P}lf́   :lfP  6l~1|Ã tL_;fu ǰǋ;Ptlߤ Q.lBYrrf@u0`b h+-ÑarffpWf`f"0~ffROMIfߺMAGE0v;{uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"tu  V   cu'[0i&w j3
G94g&GGfԣ fCf\-+Ӹ00pD;gf	!   h쀀1"ژ`W, `Пl..`B@ԑ
>t1a"pR ZuoRUv w ?xoP&ab{pZ& &FxdOR< uQSRâpBgtXr),uRG`SQr9R'ܽ$8tyYOtr$V簄OHAr(QSFr(!sqtrp@ppq9 `N `4fq48 f܀g'p!>@ W ` FFBZrOs`b PQfWfVEUU &*4P U hXI-ULP'G@3 .;qt3 _?YXhۿ `#o0@	ະF`ٿ  `l"'`sJ4p "`".-2'.q q#80s pW
sVfUgg& suf3ɊfX]tVfYAfWڳ]g<t,fUgRw r!8tfGpPQ7q^$@'}a@8tPUvPtF X PSrN&sp s؎[XPSNsaA@f!.SR P BDð?ð1                                                                                                                                                                                                                                                                                                                                                                                                                                                 @      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                       i ` ]*0 
  ɀ$ tT  au`
* u B KSRP t@B u$Z[SfQWP 
@ Xgg_fY[f`Q
`f
fgfafQRfWPSf3f3 f0<  P tf; X tDt [Xf_ZfYù@ fPffffX,fVfVf   E gfw^! f^	V					:		 r	^		f	W		fWWf	_
g&' f @f&f_fPSQWV!  tOtъ#!("A$6(hfP u	fX@  h TqQ sY^_Y[fX>uDB`t˜/ a3S&[C vS3> tty&t:y&tC p0ڶt<w>t8tɐ/>+3
 
Fñ a r 舶t3C,@F &.&&
N
 rn3
}<`8RfP@ &&r! 

A	 fXߜt
蕵s'3|
A
{ t1-b㋇.fr
Rt0
'< t
(:|@ ` m &pF> uDt& aÉ_  H$

p$I$ Jx$@U$؃@PC$<$2L
s3y@si  {Y 11F0>òY*:u;pu;th{P'ϯXP'!0!  PWu0+_K`:u薨r:Ȉ@&us  guY 7 &	&!:%0ww
w2:rp	
À
v߶ ><  22'n` غ   nBnnn?nJFn aS iÀ @E7!C &?!Cu3ۏR .Z!mhPP?qmJċX3՞見 &JJ谞茆Ҋ>&.pu	 uà]FP
 XuPFt+t8QWP3 PXhX@.X=X@uX_YPBPް7up$ q+!_.L$> u
P @Xuð6C @B T AjfSQgog tHu.g :ff3g&ffmn1nfffߋgfffYf3i<(z.&gBfsDP
hIg!r
wt4	fRc6U t uq

(
uXmO0fZSQء{A MaQsVp Up Y[Xhkt sP ! fRVh_ătDhhlhtmLr  f^fZßf`2 rb۶ <_0[lTrshfa?f`@f0PPf3۰//z<7fX !7"" hܿ=Qf`/)
4/O
, "	 	 &"	/	(	1&!_!!!p!h"=dÓhA`$wG	 [ff
]]ܰ^u2fbZRt F<t $rf0Z~f]RtuQVWŽ 0 pM_^pr}Tf DfdVaigfބt
t^%S3jyagQq?@"Z0`ZY ^PnWS?QRWVh2E?r=ыt
 uu	  tt uʋ^_Zqbz}fnWV:Eb3:EF c6W p 2:> u6 GHt\o h/tT3Ҭϋh_UB^_fZAff
XK̈́
>
2e

VTm>T2@OHp
Nt.
O>rR1$s,ߗ,/ ,0ao/ / /  ƣO,<RwS2.ߴ[ ø ` XаMFofY_揉"!f3ɋPw`qXp&G     &Wf&t ffBf;Pg&Gf}ww~rtwRtpff@Oh$p3QY tgho"AX0!S>aPS 2hWh`2f[H     w  `  ' . f6%f=HIBM%@ u_Ff!j  g.9u
g.R!Ff ǿF "Sf= @t1pu  ø gP>Q f a	 | `!ANuFgf~fݿVf  t
fP#faf
a23fY#F$V f;s	f
	  fV2 ~(Ff )g"f+s
0	~@Nf;s mȢF@	rf@f qg&g&fFfGg`^!N &Vf 1fA=uTA$<ufIg:!
g
@tT	fƹ@f ut=> u *ۀ>p u0thv(}_"3'0G;t3tP 蓞s +ޠt輞 lPXߜ>*p 	
du
)sDP
` u9 5jr/<t+@t&Pu
$&蹝s.肷apPt"Qtq2t`[F "G Q !Оǝuќeu&>&t鈐` M 0 &
À>ڰj 
8s N  
t V$<
v
ط   tǀ> t $
ؐ Ϻh?ߊ$(
d t㋷"؊ ^ѧhl%

\dְ	"	
s	~(,^ru &@ > u
8wpy 4
A y"ub Zm0B@hf]f[Mf iCfdx+'  @/%diPh @R>ft	Pip'f%İPfWͱCG6X<t<t<ÅPS$<w . pj P
  T 6   ` ma  !ف@	n` [pp%%_fBmFZBmBmljfpf%jf+ 
j00Dht  `1j`Qaff3f r  fPQfn<`)|<w  pa fXff
|
E,
ðG]	  I  A?PeĳP >?Xu"Bm*D}b/`FS! udu 
 [<2PJ
X	
@Q2~QP2ېBˀa	$

u
<X[X )Aax؀a
2t aP@<KrK{MPR좔 Z .Ϡ  BZ s  ""
ZPԽpDR   Jq vJúQ R (J
PBX
	SRذ4ZQSW 7W_[R?    
@|f 1ff! IUfF"FR`-pNT!t"ffvfXfDv fpfuf0f M "  0&  Йc5@ +f_4T  C7l
 c
 B6W8P"""""###'#RTX\`gvkpvzptw}@DJPV\n@DHLPUdxzuzlov|CEJMSYl 3#à@ PP 샗Ñ,غ:%  3` qad`ً]  ౣȑbWpE33⸑3SJ5  hx M m(@J0FQWp
!!y E{NP_j+z Eṅ|x"̽~ǽðwhvة玿K  tp'u%?th/unC,r>> u,Ў
 c$ s@uӦ
 
2`8䫝_$ KlPON`Y
&ttt
  +    %7f`#_Рt5arf1A%%fovdv- fajCTNI %?1Ff(7f30}׃Pr]VV?)Vѡ  i , ;% %Jx @,$,1', 8'ioi! ,% &&&&':Bc'+S'Ш '%  0.&, 7'>!07'7'20:s 2tpcUV<22 Pظ S$Pu fyOG[.  >{2# ^]2 	b?s(S r.'pqr.t аՇr菨&u_0hI6QpKOuh42f.f E f.q _h?d H0rVe. O6b eJ oh?-u@hS).O)`K4=
03!4>+t
3NO+t3GNO UNa)Z)a)Nh)תP aTa)SRh)-``a2⁬$fӃЬ[QXfy@fXnfX*fXahuh<jt WsP ! w (uuu&gq SPp  v[h_e$P0 X! hy5h([PvPQ+F X PSA&>+&<+&:+[XPS2>+<+:+1_0_UaDP٠Ґ`O\Җ84?8x6, N&,,$LMmwtM`ZS8rddr}S<dr
d2Р7btԠYStSXb Ӹp,QJ`z & ~p]^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               鬨!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( ((     ښ  Ւ  ς  g `g  h }  V  ;p    / n5h 6 U .7 0GS          P          %X%H_&                                                                                    U `*Y} `U UPzQ@    @ 	@
 
@P X@Yhi j@klm n@o { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ =/`hfPu	fX@  h  fUf&paf&>m` 6a  !X[ &SP`\@ /'ao&Uߡ&@r
f3f僰gf }f3fh   󯪰@p h &?ïf`f1fffef   % ŀ-fWf0M0U0!0)ffXf9ffaf 
  fi@] 0 m q:  ,f5q f~PeP Q Z  ͡ՅAp  A` efaa  !6>釿eуp  ՃnPك"` peɃ T	
e} f~e&` b "jeɃffefAffgd:ugdfepfa3 ?gCT "8fF3ۊde3 
td	 Ä p)'Ґ @ v
peuxu._RTC u:/
y'
%&bfgfd.S` [WP9A`XP&EX% &E{_YǨ o2oooǸoce  f`Fff`t$`p$Ū`r쪺  .<t
../W NA NfafPSRV$fpr؀tU./tA
 NUN?I!h?54^^Z[fX:"4} PSWR/Qa>L u&E q 7eZ_[Xðh_gÀ> tFyP
f|ysBPSfQW_fY[X "" "?"øPR0?B1Z 0B1o3 $ `%>&!%	 
  3  t!  { 9 z &@u#9?2h2_xrt0RW0_Zw G$Io#'fSS|R1Uh?Af    f0Lfs$R8 fZI%CPRrfPTmf!`	'yS'b'

R)	t2*[w.>
s aPQRp쨀t hE/t
uZYp5' ݐB!C
'@h1` ~ ~ ~!~0~1~2~ ~ }~/fW vQg&?t"g&Gbg&Gbum Qq& ufAλ(/ 
.uf_ 5`߇XP    NuXaa$$
{a C PB B;ra 'YbQ8@N:'; ]CV 9* : ,
"Q2RaWĺZP ,ȡ%:؁ Ë34 Pg& D4dTD
 <G    G:GG>IObFHh#t$h`JIJG4[? `eCCCtCۀ e'g[@a H2E`qZ2Lt"s@#&LN ]h6e
1.f2f3f% f0'p!P!q  f`
Q0XX!!fgff%kffP] @Q
 `0C  fA"a mGPl[Ϩt u8PNu0	u,htPuXP!s6E\kÙș(Ϛ 9f`aa  6&P{&}`X |+yv
``.r&&r!Br  Pq X
䏀  Pf' ^^|X|10uee	<u <u õr$Rr ks&&N2qrr]rN a`z7da(Svx^Q`0@ؾ"" QYa-FP  r&&vp'\ Ob 
y' P"S""F"&&xVa wbR ~ ZQRr빸3'H2't2@`2ٵ?(v5߀ tt(TZYa~r#S-EnR-Y03|!pٸ{q4  f &o Z2 &r豂r8t320`.vpO h?,wtGoS`1?hE[&M.x2t $?#h ,5 b,W< t +4fRhD2hlt sP ! htm<fZrj  pvw@5 
, ;#!`e	A	2`ah
D%00`P 0sS%-  D c`6(    pM@V魆ī^`W 3 _r- q+˸ fDZED;Հ BBe O B<`<2rruO0W2&*G_YS	 7&*,u&}ZE1j_[ÚDAP`QFگ>  0 2ۃ¿<OtY	B<tmHo777rPBBLѯ: r1 r,q h/dd8SQk
peat)|$<Pt+f'KuҴhqiB`UY[Qrj @!")дuBanYoof	V_ o^W mQfRO D=F==rN|UtGV !m4^t1Vh_T5f^Df`  D  ; Z x     0Nm0 =$
 d׀u	q 42{Xҏ	 d HΉȃI載ذJ赉2ȉ,' kt}OSQRfRBP' w	.0Z0"2{a  1 )aj$t=2+``| *w0hگrEϰd/(#/J+(1*f(fYïʥRh}ihlf>QPH_u(DЇ/ fP  -r(qQP-roSfP>fVfW (>f1t 3 tfہ40Z f   fǰff!2g&g
fKfRg` gre hջ5r ,`VGhݟZ,
-f_f^fZfYf[  r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/gfr`bBfg&rf]`b0  Z[XfWu
 f >  Àfof`g@? t]ǀ t
t@f?
 :N   ) _ 0f` ; 6fSrv`gGwf3ې fPfcfPr:p> ff0;w!fVg&f^ufFtf!Q. $pft Qg&$9R<&m=f=ATADtlf q:&ǇW  p s  US3a  Tb L1 { ߨ0߄3ɊȰ	j qU~FWP3J XU .>J   u{b >u `	`	kpg$l0uR$\C_AR2Gv(lvfSIMWuUf~, f@ENrfOfAf;w(h/FzI"Q[Gap qQ~08?SECU7fuBfS@:-AR@P_WSXfG9ؐu(AE_-,$81B KH q Gt+S
~ TT<twTрth
u^ 
_@  ff
 gw	`ßJl& t
fWk&f_r2af$g&  Eg&	d2tWV`p^fGtt2t~tyfs o  f`w'pA,u(0v z^ @ u^uBO`xd rFf;r>`L: t, f    ur%)rQY9	 ]s_   t%ht`A
A!:0.2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t D@@D@Ò@0b0/Wrwp	߾	P? u ff!` B
fffLp 


grϧS`|
!Х3Ұ"t3 v %`h`ܯ
UGܡ밣V1
< t6012:u"FIqr()
PD1' FE-fY&7@? w.	A_S 
fUfp>t	--


f+Рf
B#f]^P)""  ,gbX;v0? An@u`$fB ހ%  
?@_#_#_#Mfvfrg-(`*S+r[ ం0~PQ>0ι c r\d`0PSCtC0>r-t`w 0 r uҊ1 r
-`u`?dPqQ rdItf s` 3fSRNr&Kr! [ww3҆r r	s ЮfPRc!0؋ؿrp܍ȇQPQq	ss
d Sr	r!V>Rf   {dg3{uwR Z '}hГk)C Z. Ӱ P " Y0 `2迀  p",u   P hE33R

Z@u
Sذ* o rQ(`( @PS  I 1' RR  rPX蘙DC	 4P׀>DS t3306Js*bRo
t#4 c ttaÈ?  PQRWVͳͳ+3"a^S_Z$"#P1$G<u@$V{ǳ 4^W _ ³"  !(eٳ /	
%R
q0J
g&/ܱ1q;-r r;x;q;PYR(XוJ2ZO 0[RVа$rN ;rCr<,	r32`trr;wҀ tsڋ^ZW
   е0u
߳˾Ш 
u P f~! uf _2 J3322t@@ 0~ 	rn
$	"
upmƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_...m...6r.Y.2YDذVPC7\m\3 	A!˱5
	
QWfV3 P3Xt-nf[]~f
 f^_YA.
fUf.6f]tf]** End SetActiveDisplays: \ PwR$nt5< u Q)㋗d_@-;t  _um xD @Ӹg $tupZQ2tN
ك:P \s@t[dPЦ  ~GoO
 BRR 1p93t0	p $~ D qPSbbUg
10ߜ  Pn0	tR	g9ofgP~P;xgP$0 wg0ugċ؀ ggX_gXEgPS_R,>=80;gZmR ``bPtQgP` ÀfXf fQRPSa[X3`Ga cB"c
rQ j dK f`0 .!KOu$Nir
u.2*q	, trp$}p&` E&]W@ _fap.A4t
1r0???qSQ/"AfWU]aW_ð Qc b rH r;tp	WBTtu SAC_f`fo> ; tЩf fRFfa`k_<_Pfgf2gaЀlutQ SPߊ܀Q$?~X	?fAWѰ W6XWqHȎt/O P (v ؍൨y$at-`ZON@a<@C OOw_ B  }i*fu$$t$
!$$Ah1ϭTs `9t4>0t,PQz uX?a    Pj `   Vs D ` d h           ػ B @  b  `@H`X \  HTܢ3L_4 5W0@
@
` 1.                p   Z         14    XYhijklmno 	
@}
                  K _,89:u4NNO  OfhXukWӬg&f0.Ofgf&c@OZ	 Gtq0pDNf cqfRVW f Q  !Q  A!!ȑf%ff30 f.2fff?u_^fZtf":Q ء f' f
~f0pP3XPSVWfQs: ؾLي 2u ufufpv @uf  fY_^[XQfźff
ff0 fp  Gd4!'f_Y"OB GrGbR5   XP2 < pg < 2<?
 1 a                                                                UPRPRVFZX0RR3=0ZO                               ݸ Ѝ|ȋh3 ZU #Pl hSpOdPfB'fXfXhU ?ø0Aq  ؐ	r ْ
DzSzTJuFĽC HكIڈ#
Nrf00ffЂ f+fM?h?ff-Efffq  f>PAMSuff>r^0awS0GP`0X>J˸ fb|	! "f#bRWVf1hlt sP ! rY  E6fP В hmh-r f fht>
^_fZÚ
ht.rB q@
E<u@
P
`a=fat0(?"a`9j uL$<tD"pCQ>r&=t&} tV" &GF^Y"
\aþ 	 hy+
s!
"9
'
Z
'P 

h@?L P~̀R ĺZ`SRغ0 t@Z`<
w'> 6]&b @"w}	&A`+\4S> t=0'u7 u1ai*<t&
t!u[rPr	B #S$LtZgtKo[r3g&GȻ s0a$
 !O@e 2_YKtg&G"rKtLtA1X	
   VȾ 8t"8tzr2^[SQ^Y[t,&
u>ut
$#sE ?t> u.jP"t$	&
sDa%
t-PE%	> 2
0*Y@$t ߖITHu0tC P qK< t &$  
` uw> ؀
	 >t }Ot0z0P`S'uSg *sr$@, It>1u
 dA  (8r"/t Y@J]SQPXtV
r@.yXGItB0T0.tr//Y>6Ht_6ltP 2rB3OsGu%
u= "7H6͹ WE6A1Jtzu Vطctb;sW;sQadVu	Ku u"
uS"
23>VO/  àբ8/kt Ips * {/)P16tXSfW0`
pGtpD_8؊f_[^,f sg]/  r#
"1,# fPRfQfS [ff%|h f
 1 Ⱥ4A# uOf3\f1t(,#%9tP!!pt1 f=0 tf.ߗf@Ff  f[fYZ0Z ! -׊* Jؓנ % fW  u8  *t 	ff_À fð<ZuM p?*Fr:yF P/<JE@ h>d|fѠ`Ϳ{ѽP f`%
0ú:cktGf@#n ؇1 İ /D10_údߩ u"Au M "  t 	
Tf@ @ AtPǐ ـ@g&}S%` &7!#^MR%0(+2#[Q~Rw-4f#f8%+:ك8>` $B'
P@wf 3 Q'
f~BP|ZS	B A';'>p
f:1p8٠
s4!=qfYfĳ &_ A%#@|3RS؁@˅!^SCV p#t6& %f&ȿ ffP]t33uo^ Zfp
3һX3t@s7rS
`'`' h%! 
 [* 40*R0T0	?f%0OfpÖR3&?$bֱ P1T؃2Y1BàRfZ n瀠pd
P ;{ؠu  `<`K؎P#Rf찵 ZlfaJnM3 @qۃ(0{}EfShܸ p!S D  &Et"D  $D( sn`K`Q&tP% 4>2@"·Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
`  m  m 
 m pZ's 0a` r ?* `߃OQa	 & a@;# $$<@t"hXTKuKf LKuף`.>
st&3`&*RrM裲'Daô`prr X ? trKC0}qw1#!8Q909$˹a0){fRQSP[YfZķt'1tN( u
| t@ar0*
ADȁmG>  ޡf ? h f>rxffRhsd f01`r<fffHff#f+ִ f;wߴf!U3g&Sc
uff+f뺀
 ?,.028 I}.wo)q%ށd &6	mP֐()nzPV6`Ⱥ @߬  q&agu x  
| hu Ы;taR0k_ IkPffX@ff&`tPQq   ` 
DQ!ƠfQR๿ 33#~ff?f
 
u@f Asą%\h!fyP-py@    rp`ᩳ\rSbɉf lHth!crQa!% = u5
?= uu=  F%`0+!2f33f 9t a3?bbA+ rނݺPm UQ   ,A}048 X0Aa8#>5 A ~cqNShL_EeH!P3 P1݀f4fA! RY F[f71 07ԩt2? t,1/fP _tR'ȁ3'1', @Zbi    i,/ ,?;!w\~ꗠ 
nK gx-$F,"c4D,ʴ盗+v"G,,l,	,=$,,,?f״Kz*߼C	7֬f. 4W.!u<u<vw2.Ef&@pd Sx!sCrCq!E'[@;xV4t&? u_%[ff[pA@Ay`A62" 2Ryfhlt sjP ! srsqs8@}.hMcr00UA-@fP@#x X6fA:qm}dbr
htzsyGNohINЛdP@ hrxWfV"D .`NtfYPVR}&蔼GYf^@R5_t'cRQ,FϟM̏$k=B+ràq",-./01289     `a	FRF 	_$akPUG3""
Po[2t*@pp˜`>#l>0l!GA lBla}6$?C&! G @ A B  $0sF  Lgn 诀"g  BnnnJF$a %JF
P <ƿ tq ̢
P ̠̡eޢf    llB  ؿ  lBB@P뺇 lU@    @ lcТdN0&@'W] /$а 
@  
FFn  	n	n	n	n	n	n	nnn 
 cd t
qa  @Cd̀E
`  |3nnC q
^p		 nA
` nea4%f4Pa p' f`8틿P%7#%z  t
ف     t~sPRs@ZXߟ3( RH+7Xt
 %  Pé tPu>=u= Tq `@ `3`t%%tNtGf3 ff3uf  
f΢1E䱵 X @aÞQR.Q#؁ U~~	=c	%pQ#Y3o#pK!@` Ѽ) 2 %?
 QQRb
x  /2u⳷ # r`u车
  a9߀
 99!a%?轝t
y6Q $fp`#$ 5 Aq f t0 P
 0%ϻ0$# %3 'u%u
͹`&qf+PS84 8T T?8hפ߰0qR	 #A5f-H84-\8#`3p/8؀@uR8ttQ@t
z1S8׿u"@<p`ᒨq2AE p  P+GwhD5\/t 1ڊG4Q(tCPGB5ft.A A   {uA  dh2)
  '߂  P --h8La@R$#4r&Y b
X babRPp  OZP?u4 pbyKqb @Y!I0R- Gh1H	
2
B.&g t#.׃0Q' T
.t&*0 0 NUo! f̝(p   P&MXO                                                          0    ,OtGa bd~         pdp                                                                    S  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  yִfffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   ifsf ff   fT   fsf wfD   f @fsf [fsf Efsf fsf fsf 	fsf <fsf y3fsf Ifsf b5Yfsf xofsf fsf V	ufsf 	_fsf 
If   tfsf 
*fsf 4fsf s
nnfLg&nffOg&fffsf fsf f   f   ^fsf f~fswfsf !fsf Pmfsf fsf fsf ^fsf #f   tfsf fsf Uf   tfsf N%fsf 5fsf 9Efsf Ufsf q%f   unfsf !~fsf fsf $fsf fsf %fsf %fsf )&fsf )3 f%"f   t
fIe颋f  fsf ta$f  8fsf jf  Qfsf f  kfsf L   Iuf  fsf f fsff   f   f   fsf 
tff Ag&uffsf A%r8u:fsf )%u$f3f   u
ffuf   tf fsf   efsf t<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  fsf $f  
fsf Chf  #fsf f  =fsf z   Iu f fsf   ffuffsf #tf   )fsf #8uf   uffuf fsff   ftLfsf S#f   t$<t)<t/	fsf )#ufffff   uf fsff   ft(
g	fsf "<t<tfffff   uf fsf   t8f   ft	fsf "t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   t,,0f   ~
fsf [$t<tff @   f 
fsf !2  +.
fsf h!<  ff   f.:w .D
fsf 9!<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2,ff   f
.f   2f   f   ft/fsf ) < t8stff   uffff fs2,ff   f
.f   2f   ft(fsf < t8stff   uff ff fs2,ff   f
.f   2f   ft(
fsf %< t8stff   uffff fsf   f    ft'{
fsf $t<s
f   <tff   ufff fsf   ft
fsf suff   uf fs2,ff   f
.f   2f   ft($2fsf < t8stff   uf?fff fsfffsf fsf 2,ff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%7f   t7.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftf,2.<u f   t2kf   uff   ufsf #uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   fsf *<|f`Agf&   f    f    f   fsf 9f    f    3f   ftfsf Ufft9fsf ;fftSfsf !fftmfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   fsf <|g&f~fsf fsfLf   f3f3ftr2f   tNfsf tf˰jfsf <	rIаfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf7.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf fX7  f Lgf&fftf87  f~fsffHfuff Lgf&f   ftf@fsf f Lgf&fftf6  f   tf7  f7  f   tf(7  f Lgf&fpffHf   tfHf~fsbfsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	)fsf fBgf&Efsf  Ufsf  ,ff%   f
fHf   t
.f@Cg&,ff%   f
fHf   t
.fCg&fKgf&fsf f fs,ff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fs-ff%   f
fHf   t -fHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}8.fDg&(8σ.fDg&.DfDg&f30-f   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`3f~fsfffsf fsf f Ef   .@ fffsf fsf 00fffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@fsf ;f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
7fHf   t7fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	7f   t7f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H7f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   f	"  )"fffsf fsf f 7.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf7  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   !fsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gf,  f Lgf&f   tf -  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsf   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&fK8  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f8  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   f fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afAQ*f.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   *fsf *f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  
,fsf $f  ',fsf f fs<f fsfffsf fsf  fӇ.,fH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  :9fsf }ǰ < urf   V9fsf $<  <t<t
<t xfNgf&f   uf   9fsf 6$p2<uB >tHH3f  9fsf ȳ 
f  9fsf ƻ  f  :fsf ư < uHf   ":fsf $` < te<t
<t UfNgf&f   uB >tHH3f  u:fsf dǳ
f  :fsf (ƻ  f  :fsf .$
f  :fsf f  :fsf Ƴ

f  :fsf ŀf  ;fsf ŀf  ';fsf f~fsf fs    68DTU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 ;s E f    Q7sY 戰fM;  ff@;  f   tf ffM=  rfBYf戰YgCK;!f3f   戰 fHr4f f戰䈰%;f戰 rfFf    戰戰3=f  f   f戰fS_Bf[f   f   3f   f  戰g&6BfFfCg戰> 撰fPfSfQf   fQf3یffM;  U:fYsfYf[fXSguMO  ;u[fPfSfQfRfWf   f3یffM=  	 :fBf   K;f3g}MO    fgM=  r%fG;wg}MO  f_fZfYf[fX          D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G       	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	    , <0     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                             	4 @      T                      d  ` h   X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fjf%f  $f$
t)ppqtfjfupppppqjJfjfupppppqf  f  gffLggf^gfnf    f
   "֘fRk'fupppppqg- f{kffkff  @$f@$
= u$<& fkff  @$f@$
и f  D$fD$
аflgf% = uf.lKf fCl6f % ugf]lfU../0./.flf d< uflfd< t<t
u掰flf䎊flfflf掺<ufmifm%  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fn  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f往afBp  K"-jfNp  ?"對 f    < tg    f   ff   2fff   ff3q.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2qy           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      Pp     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  PC vZ[XPSR !Z[XPSR  PC v
 !Z[XfPf   .>&u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
+D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4* (f`  fg&Ftt vugf&>tgf&6f٢* &fE ~f^Y[fXPSRfVP tAP P% +g&ƅ    f{  1\g&  	uf^Z[XPSRfVP tAP P% +g&ƅ    f{  1g&  	uf^Z[XPSR     qZ[XSR  zPC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ffÁ f	Áfǁfff]X t fffÁ f	Áfǁf  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  fRPA vY[fXf` f;."t
f."!   ~P$C vf3 
 f    fgf&E   >! uF! f[  gf;tgf+gfkf0f0  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f{  1 < ? f  9g&"  @v@ g&  s ?f  9>* u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       ' 0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    d    戰䈽j戰䈽yݰffڰffÐ;ܰfϐfِ߰ff2 f%"frffٽܰf#Vf-Hf9@f E>ݰfQ(f[ܰfgf f
   `"	f   f3f30f  0ffpf   f f    0f  f f   0	 f%"fff.df.X f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.jf.^往af  
gf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pfԣ   0ߣUusߣ ݣ =
  >ݣrfg  ࣁ ( r  .ٖܣV>Mffԣ<>3ffأfأrrfأfԣf>ԣ wfԣ   >ffأ%fأ3fأfԣf>ԣ trf>ԣ wfԣ   >/>m>dff   fF>=ᣠ,>#ᣡ>	ff ܣ > ffأ'fأr$fأfԣf>ԣ trf>ԣ wѰܣfԣ    ݣ >urd>u]R		 D>u=ᣢޣ/>u(fᣰ .ܣd  ꣃ>	r  KP	s 撰 XETn=d~ŕ+1FXf{fSgf[gfPfR>ߣuz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRfУ@
 >ߣ u> 5xzytsfZf[fXúz.yursfZf[fXPR tĺZXfSfRfУ@
 >ߣ uB ;yM@t-s(xغz,y0@usz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>, tSg&4  g&;  ĀuE g&  vY, f[  IG
f0  A(faPSQVL	;t	 И ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 -f6YQms>-t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&.
gF
&.Qsw>-taf`fP  gF
$&0
gF
&0Qs@f  g&|5  t>-tVfarfWr<f_    f`f&f   g&D= (fgf&T=fg&D=rL6&& G &r6QfPf   f>& gf&D5 gf&fff>&fXYsufa`fИ  &. gF
$
gF
fИ  QsF>-tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva꒜  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   fҝ     f  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z֢f`֢ffPfQfW3 .;;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇TPZR[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR T# V1 XZSQW   L_Y[SQW   7_Y[SQW   "_Y[    f  f   fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .=<t ø fSQ >ޣtf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fУp   rg<uf   ⃸   Yf[fS>ޣtf  r	f r>PfSfUUgf*gUfUUgf[XgfУ   T r
g8u   f[                                Q  YPSR+;wZ[Xf>У tfУtf`f  f3f3f3f @ gfffCgftftfafУ   fУuQYfVfSfQfM;  f   fأ<rfأfYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fwf{fdfd    2ø     B  @ 8}04/13/05DUTf Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tSg&4  g&;  ĀuE g&  vɃ  f˃  G
f  ؇faPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀms>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ _Nf04/19/05DATpMZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        