#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTD ROM)  - Linux-Based"
BIOS_VERSION="F.03"
FILENAME="sp30430.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8BAR   BIN  O22  U2    68DTD   BIN  qP22  JY2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Legacy monitor to 800x600 only
                                                                                                                           Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        		
	
		 	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
 ` X                                                                                                                                    !    SI-1362-A   p                                                                                                                                                                               H  <   X<
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a L  XL  XJXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                   q p   `      POST  f   f.V .X <  
 f.d ` j  I     '     @  a    POST2 D} * F  -Z h{ 7H 	 t
 ) | )
 | ~ 	)  @Z )   @2 2 v2 2   {  t Rw Dv  ! p" ,# $ n,% & {' O( Q) *	+ , - 8. g7/ WZ0 01 2 3 N4 5 p6 n7 @8 u9 ,: ; ,< ħ= ,> ? /@ ,A ZB ZC ,D {E F uG H tI 5)J 	ZK |L )M wN 03_ )P §Q pR +S T ,U 7V W X +Y@Z ]u[ $Z\ )] DH^ $}_ `  Za f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h⚑)O [X /<t
PW f&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI!؀߰Uh~lBt/f00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@=^Rf0@
u߿ h8ufY_ZXSQW< os1
2
 h3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
H@
		! &
%s
> h3hp0 0t  u
.(u	u/RPVoF	` u tR	k@.)tމ^~u 8	t/ t^6
5
^XfQW~
,  _fP	$S 9#0;r#Lt<
tw
u!ο 	/ǫ_^p	65WfV*p#)6ڐS
F f[tҋ3ff^ff[f`K.fa= YApCfVWUA t  f7h>D%3 tkfAh6 Px'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`SfffϮ@= .3>+f;r[T@ WpX
2h_
ܿ WX
_: r
gN1
g?r @99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?" :h fΑR   둡4]hQRWV^NV vq6Q3qI4GYlGʫΕI^_Z!3Q'M0 pC8 YfWV3f_f"1
mIfPS. ,.(Fo(  f(0p^
#N~u_!h
s.  GFuQVsuRT?
`ۀO2ۊ~f~@xk:P`?tWuf@ f.(|ftf!f.@# <
uF8Fuf_ts^ÑGVR.>(s$0q	.k6(.(z

ZF(Pn2
F0(FPPv2PqN~ t4vf2&fz10
FNNI.G(ƔfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@Ѵ 8^rf(  _^ZY eWQ3.>(2 . .ƅ" ` P@h|X.( `s$' ip3.(lh?z o.N /p\wFk{@"~ 
N~f.$=6@.(32ɠ0/tl)u4.B$f<t؅?f  `b$< F.? 
1wq3tV@~r F F;F F2u~w
`M~f1 kЖ lt
fNqu
ffsfF^PB؀4)FQ*
*q4rF$<u&jFF .# ~ă$wp` *.ӊp< OO<uO8q^`V@;(@..(;(^V0&0
9t@-2x@2
E/^S 65^35#'uBX:NЎuP:
t3S9)&u=8N0_^WV\SVR`Ffn*J[*!ffAyRffP%Ѐ`2fpʰKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tP7u+q%
u	AfFaJfୀf^Z6Waf F݉^~{K"8ueffFՋoN_QtcV@hvnb!F;pI*3ϋ~+c:tsRVRfQF;F8u p? kv@kF:`pb$w$@K*@3frD` w;=< ur,.;D$<uπ r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"t_t̢ @DvP }PkQ9SV ޾Г3; t	 r^00kГː#Aq[%S ^Y@j(*pt@;?v7h!1k~@st 1;FtFk^% Bk^cՊГa 3҃  V3k`[
*䊁ғ;oFuR*3]ft7-+k	)	# a
@S
+FHu
4uGrvFvVB7s0;~HVW΂tS03ދ[^NuVp 3+0_&61-Dr<lF(kHpBHP)뷋A(7,oZ &0V  ˋ~1|\0PN~ tKv0}YFA.Qz$ x
fpO3g FfN@P@ 
0K SQh(	 s\P,Q23If.` tf.&!. .8(tOьL$QVW
fvUFp䲋"`F^^~F  FψF
fgFF ^Vڐeb"e^`L`Ч!ɺ ``Nf~ tFt'fy`e 9Fv@f0
FfHf;FyQkr@րi`QbbbfC<4zRVFъF8F^ pVF0 N$ &(,ytN!!fsШ#tE rts@CA9FvG 3r%if.(NͿ  `Ne0ƺ0 
t
F%  .ܞp >fg~ t(i'i_f^z eu
 v@aQI8t%  tu Qw  vfIft'fAff#a f𑘐pЊ=srSf.6 G                                                                                                             /                                                                                                                                               e<	) PQRa&h~l) $`Ȱ߲ hCrZYXSQWa$a$a  h= hM >5_Y[2揺 TCA6  @A Q C@}@ @;uYð!?$p h)Ē
f`  褔 hf4gf&     fa.-h
p

hsofPfW@&'UNNNO<su	@NJ	_fX`i/.t$;/h8?   &  3 hDsI跌@ ؀  >QN&}uu h:n$31"d %
  % VWa
-)$@#h<ff
, Àtf%fhs訔su hg:.` ܹ 
hR/`,úvñ0  Rv   p-9 5  f4%  0]  ' ߹ %	`%aPo hb:  h~( t
 D&aPQ * @ PQ= `t
3f3	@fYX _>ðd߫` 5d  UP@  > |F  !"ؿ
Et&؁@ uM9NwN#uӃ~ t"F= wt%   +ȷBXh!=`.-   !	 P: a `hXrM t*` u J<u >tPRfZX E(~f./~ ACf` f   07 HV1SfQfRf`I  f'  %=uf?a2 ffZfYf[Lf~f  @ /oa@ HSQRfW&f_Z ChBgf`P s_08N5N2衙rH
tf0C es8! h_f͒rs1؟s <ug5
=ShhhXfa't5<t1\~fo P_mN@ MÆ B<  C< $ j# Q R STU U VWX YZ}f5RVW3j,-K*D*
` P~POfQw&C vуtR~ URcnt
S hNB[,׺:Cp 3ȰS&5@uYS=h~~^ZYq(é t   >  A  T - M e M A@ 9 Y . 'U  n SȀA ǀa9?c (
O1q T0+T_{!U>@2 P f{<2!~pX62f61C  3 |pxP 61>xF.h]4#PSs{ $<t4r [! Ѝȋh33  ] f`4 S  (y6Vh{%Oh3` q FD 30Dh"r< tbF?2"eƾ*n ǿ-r/ǿ r%@@9&5&D&EN7ƿ7Aa
phꂰ  ߿^puZEpnV~_^ 
8
3
~3
>E
vǿC ؠoP|QFc&@ U= r&ǲ+= =rW>]&ϊ_<oG&d&&@
, fgh  0 pqr  <ABCDE xyz{|}   
fmin*5R 
5&7Ⱦ75B r
&   D50"[ ]ȃofX[V3
Ê^@P$. $t ".FuN.PP!% _XWfVUSW! q(fv߿ h.sz  Q$~22ك!IN܀3d	^
u
t_NA&>-_[]f^_PVB&=;u&&00u&m^P
P< +&~&@-E&DSV h@2^[þ6`WWfPwAh0 <fX_vZF10=ROM Based Setup  Entering07 `. u  37? L}t.07 `8 SujP'`P+ W  Y7p !	!07 1u7QFRLòp &07tJú t
.>0	t.h9PXhWmF12=Networkrvice BootWake On LANAttemptto %  htz> P`8wr	 Яa`8u8t 
 a8yyKAiEd/ ybSatisC2 1P.`8$<*މ6j 8!Lb	J!A
`8R?s 	
4ؾqN<^@4s W-A%rր|VRyckrN0hNF aN3؁QN?	uCFG?~N0{tGpgh#baavoh+ Z^  Notebook hard drive!O`$cal de&DockQ&b; Multibay (top)bottomy)left~f	Floppy*USBCD-!E HDis|0SuperNIC*
!I123                         T<rP  	 
@=
m&P D b [@<9zpplect[D7  U8 and `mo@=the highl@ tpayour choc.  Press3v1cose.Seconds until au;a A@fa> start: @i>\>(>$P >'>;S A;Zip.F`u hM d0ô0.>*tώ?; A bVaN3QN؊' tA<v<st18>& 2ԍ:2}T<Q#YAr	 h@ L jB.4>
*о`}6> 6>+jjj(Pj8  > `4>= z   o 	?  2җ
   t038>2Ɋ F8tF#haN $ KZ bqq`t URVQo.,.L.T^Y^Z]S,.6>*[ݡQSVW/ s&Q?.<.-00?00.p1Y_^[YQr= u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu0w`2҂ Xʱ¶4>==r
;w2p{4>J!}gFYô.*6><e2;0}fhڑ hh73L`V4i5*y	/  v
1 
O hc0ڃ>u7fYfP	tfYd hν<u2B J @́Wo rf.>C'gf&G, @ f   PG0f@G,pu
{hE$*G,f",f_fsfP 3QYf*1 QW2_Yf= TKStfXbo    ? o `Y  ah.`g&Fg&Fg&F"t7g&F0a 1 2X޾zD׎Ǎ~J{ rs|D	 k  QRVDTQF r&e^ZYDffL (ۋ]L PрYPfSVU_fQWo
@x
K&@
C' C$C$Vrkx  q## ru]"tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ%&C"u%p`'&u!#,CABM pf.FPS [XAumf`p );St1 ]t("^t{tBDt!fat$fa.6Ff.FIDNU)044B.FSfV()	Op(^3*Ýf^[
3u
'uqr!q!} "@W3 hn [ 0`0hHs3+5cf_ r`= v] O1] aP߰ h~lj$@<@X>O:PR ZX@ .>0H t.0H_.2HiHXSQRWh@2qr_ZEP TC r99 r/ u t t@XR1$tutZ0^ 8 ll?$ f35`PSWQR ouʀpPpq4B XZY_`\ @S6`ѿ< @3ɹ2 uhXd#^)¼ P% = @uXu%)4g&@RN]QfPf  g&?t9g`R%f <u @Qe  f%?f!f#   f{@"f<tf Q	 f !pfa chZYcV$fVL/
/P`GP@t


 
"
f^ff? wD Pf+%Ѐ=
!
 nfoAH3A4r H5v 0P@p <	C2 P` E   0  Lʃ0"J	ipy  $Lx&  p s V Rs  %A#Rt &@@ Rxfft8t*`&bp 3؃>
tuc ~rh^
& >C<th4w} Gi11?}4 Q < t&G f~&("6

G4P3f30 2ɴ*f& uf
ffKP}&u&_fC0ێɂɏl-pr5@RfVWfD3ffCf[fKfSfF0rq0а K I+rǒ_<Zfr6SQVWϾ u3_^ 	!BK#V 
R3
t<^f~
w/v}Nf }kd`@bfft@`[^c@|VQWfv h.7-F&>ʋF&@p &B &DP&F&H0&Jޠ&L&N&Pr@^U1f  arX )Tu'P h:n" hg3hgX`a̊؀atif]PRqQ 0ʲ t%  sS fQ ffff>Qfhs pJg&; Qu70W)f)fY~/u! /u/u/u	g&tȾtx3	[rnf!ǂ  p: o	1/u~/t r!	 u;Q5T,                                                               0UfU .QQ?u hNCrW2rRrMQt{f0f 0Rw| Wb t#Cr"t} p ; (߼PJR  ZR f]L@V0迱r*6^  R߄ ZrG	Ku eydB rC\A 3?Xyg&8E txEG 	UgSm r	S>Q	tCԊlkQkpb10ǥc࿐W rt r
  GC_SR밞A0Zt$oؤM$]WP  _W}  sp  a!`P
߰@S P  	ð D v S8 3 e WR	Ǥ!
gR'
//&QQWjuptPX_Yù
 d h\8Cx1迬s y
2P -C<u4-u qRR바aR12e< ugZ#ȴ$ t	J  U
	a!"(栘 p搫ۀKpRf^hZ"haßh$T/ r PIh
"uva { r PQW 0> 3_YX)Ohac=F >e$hSs	? *Dð   ! $!f` T| aTh~l!@u' t h>SavP1[F X`(`QAؾL &>AN&DE>p&D >qNu dEv Ij@ tQN}
 +Ȁ}	 >MN 33SPb[tS[>?o 2[sDy3 t^oh@#ÅWs
Jh#Oaàh9D
Ͽ<DuL
p
E$<u D
@Q1Csd
rSOi&S]@` uL
 0߃6 65Npu  (X6/ &uh
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&?  t"& xu	~\	PS   ? 4P'>NN_3& ?! W>ON	_[XB
t+# P xt  t  w\DPV!$!"桾tKh߶10Q&,@ &  ^X  hSC!r!L	vTt
v`WU$^/! $<v@a`l3  v
p
u$"<uP>X\PRtߊ N﹘:1thE[!~&ă=0ZXv` 22PEǿqN&PCt5aN=QNtOu570: u	At!s96 u5 .\s}
t!ZO&q s   a
׃/]3 ys{&=  V P;oOu 0<t ^  3f4G -Of_ [ }0 U!    O&egWʃO&Mu{O OqfGtM!t$}Ot, t"OGr ǾJM0oOg&O/` ۰2%
<t29m21_kרt O<uLDHD =_7_D D	 d_
z=1:B]tSpprG&}	r??23P3t`ha&ES$`	&M&]AH`.'	@[%# r`S UﴱϠRb0ZW&= uAF:I)
h 
 m}_XP
t   U!w#w !#`܊|nhS0 cc.-.MSN=tI! //(rJmc.58v@Mu% @BSB 0h=h aW!$
"1D h3
hYp@[X_Ë
`PS@e![X SϲH<vLR
 Z,<u(Rff+fş,ZJ vGu
w
_ jS1 6у[vQa$ ;@a܁f3Ұfh!}<`b8 {ڈ	4`֎ސ0h.u73۹ F
t):u%9dD	& hҿaN & 	 hʷ3aN3Ga!3 
3 @  QNk SٷuTu   [Qs  v{ rwufQ wb<t^<Pt fRPp<uB u:XfZP.XtU!&' t&n11q:Y`̹'f0~
6~'+pQCs& 0RkZt?k hC0 0YQC?S~([r4f"Lq(u߀% = tRY#*}T[r_HS3QN+6 
 HHqʋwE&E ꑮ, r__h+3{xfܑ#`/V @$P`}RŒZDnۡ O  ZGpZ^2 `WV 0  PhX@ 0t2E-
󪣶,2rƀrր?!C@?r@Dt52Àڊu,u1 
@a

+&C3ɿ23&@]t  %
t&
0  5  Ӱ"   ( D
u: >B/b!	"	? A%w ^avPRWF&A &]&U
t ˀAi] _ZXr#3һ -w֖2C.u#/5$yN #h΃&~_ '߸^  ]      Cـ>u  'Z} ^ bk]fc]f3fu 3 Q>M^:*uBE&8Uu8p]
R +B&U
ZK!ؾkZ6fYB)%qr h;|	Q(t0=
  5Ãha"pЭ8.
<tZێûP V#
@F^f   XM~ED
yCA IѦ   omq|qUf`` Fwm. fafSfQf.mf fff#fYf[2VftGf   mIg@f;t&f 	F p%f^`2ۂۈfaf`3pfaPP3_X.>m, . P	_TACO F>  
!	& .m ԓ<F	m fFf.m  mF.mf.>mp<E.m@  tm߃ttYpmtONp  D@SIVfB.Pf$;Vr?T%W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p m%sf@c .ffHpáfXfdf3ۃ!u+`s3?IРs*"/S"Vf+f;wfff33RmREmo4+^q4'r44=$.71p6ɐp08333Ҹ  QW>Q% _F
3}5u'JE߄#a0 tۿ 1710 't
t} tWM_ } ,   ؉F EF^V/ SV^F uQ` &t Y&  
 < tr&\]p &\U  
&aN!d QNo
SR[u	F@& $F^[_F FYp߀TV'}PVW>ًذ 6' uN'! _^Y[XÿWfQSg Zfat
  [fY_` t =$PnPu2MtaË6!s } tp( ` j 'U&&E`?SRUQj@6Ŀ^]ZV` jt Ō^XP
~*F
O  t# b Q lpF ^FPr d3duhXKu`<Uuùd `Fh}c4d w& Xt   hM}:& hg PhE'`X!$!   ¿s}ୣ O
߰ehJ"   tt 4  hM`w tKu& & ? 
 @е` h,s@<t<uuB 
0u?1*`P	h9 Xh % P  '`D[%Öys%aPX'w$# ))t`($} f.`G  Ӽn3 ׽D!n@7 À   ; Z x     0N@`^~#bhʾ21fF3.w% r 
\0ވBFuр~2wFds-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہx.~r@V» ␂û< f ff @ffRfPf!N
 ffFf3fvZfFswfBf〶fЩ1 r9\pf3ɰP?ǿ*nfAP  fafPVa3vrF3X

S,0<	v	,$y.[W D`

Lb f s  f 
T?
T p s 	 
Sfw_fp ЎfvPU.YP, P:Fp
uf^fNfV_Sf^pPRp*fVA6F1@20hC@ Ϣ
 ff  fffffXChq p  `90W{ P9󤿾T|" 6 a)P*h:nP, %ofPRh32R ĺZP  (Q * 4ff:aD0  f2MMShP   hCɀhhZ?;PSsS葮@Qpq$ q!̰Āu`!A tܠðvntt<1w(o<v'PEh+3_ P&
0
3q 33ҊvtW/g.&;u;@.\onut)@)hPRt׀a`2G@t03@ @u  a[
u93Q2,;8#fN 

Pe-j1rX?03Qr |X@Yް4SQo2ہP5'a&& &0hC9t hy}ru򿣶ɰ hm
t[ Ȱ t
嘪ŀv#t̰5,5-PX_v8v&> ߀㟸`t`{_P3 u? $h<I
#RV@ ܸs}X uu22h{Sg=u]uXP&
wLP2 }Q޻ hNu= Dt= tYԀ'
Y豶YL.!{^Ze[1P #|@]U  Pf^ ]   `rEr?A }.H u-(.J< t.I
.H'afOLPHÁ      06Pw4;V( i
u^V- ^"(P*^  ȿ2s4aSP( 22`X[úB  $0;R  ZP;              }2Kt@,A )~ xriЌrakfL+  كr<r$wr/}!f+Df+\ r@ .@hMkSfa@5@ PR)A30 ZCRA
 `&F@g0BpA^uh#P$Xh r.>B.Cput 	A1QR .C߁ph f3f%  fYpURQSWF^
D=  F\ ^F \^t
;v F;F
 < uWP  <22 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
58_[YZ]`P 2&X&`PQ0^ kPYxUkPkT]]]=              =`ރ6.u;v` n0 >xh *Yx`"QwLQ f&YCC`K (݀  x3YaðSRP3oPq?[Fp4$&%<GP@`	 0rp۾aKFt   <BMtf3 蛯6P2R Xp Ery
RU3`It.I0fGenuuhfineIu_fnteluV=sL=r=vStN f  P =   	t  
 f@3t#ށ %t5ubfD!a $<@tS<tOPNBH$u>f=PۊfP+rCtq Bt#Bt	]`@f
qffE[1YNW_ RWO  3OtCxx0؎@P.BB <t BB2J &ݾH   8u!@`23Ұ
ShVSt0`́ y aut0i at]U U[aSR  4hMSf
 hggZ[`-1Pһ  hx8	 h[
 "B PaԀa$8uXRP<u1Z@uQrtwvYu0ѹ }R0wZhEU2<U@x: h\Ś u
3Ҹ EF)v upQstTo 9 
(Ƒ ڣ%f. UfQfRfUfVߟf0>h": rsNbCW3f. ff_2f^fa3Yf.>fCgffgf uY*KU q. u, P3	fgf CPbIwfQgcf.#f9u5pgpfY'T0    /p ;H6h_ vZ37J Uax@Q 5f  %"   OV3'%@ Wtp;F ;
V3"/fUi &g3  f% '"Ï #WFfF^faQ_V p @Z  
^`q[3[<  ~  f DTDw R @o 0 ȳh  1   l ( Pb @0^ W HL P`A T W Xb, `
`!W p@pؾ@x o A
|\D ͿQWhHR3 3_ 0 PQ= `tqј @Y?X 05SPp
& p  ff?& X[Paa"&    ir  vf{@Q  oJ6OfQMhr_./ۀΖ tϤ_ <@l~̤ tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAm
?c1(PQRfW}c`
fXÑ2Q`2	  "	f\2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	hW"ϻ (;sQSf  r` 
 t
2>fƃ	40q
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&E uZ=Pr?Uf  uCf*f=`  t0  t( f{{f
1"0"}fh%/$_!"
 \\-f g&%pջf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGfʰAÉ_F?<qP
 Ц 
"a	Ub	~ @R2~BuE!2cf_fFa &Ff޾{ t@sf @{f;~t	un~qNїV&,##`WfVfPXfXcr<w .,0ճа_ѰSf@&ˀtg&TfV}R3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)?^f^uS2u  w & ?PP0Xt'vt
wt@0r % r/o hm>u  thRst-3&>rqrRPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rou=
@ Ѕff  ؀>t !$!~f$< uRC  
WN<2<ăƁ	"桻3A.'y@h[u TYP=t 
u2Ɋؽв3`t<u
E< tȵE$<u&w _$tRVL  N L Nǻڰu û` t  P[2u
@j jӻY!(!?!2(<!1e$ h5u$0˝tݝ$~.#K,.t4&^ t<r&Pw 3.\{  5!.\e@.d nb    W	x .|wh=A_DuQ&~% t PXӹ
 d.:t
 ._
vXP%8Xr6%ȸfc4;La    PJNL p      QKOMp @Kt  Jt P(.DG~H h2Qh  hvQ hޅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
o&;r"`np$t1TKub 
HM` `_(q p_" sr#%	cp&3a C 	H ]r5r`2gpjh!gvZaVRQShңouThyuJ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFhsUujjjj P8 &hX\ hcY$vbwt = ;t= Dt
hEsp[@WVS$`́$
[?W @n< u"*OؿhNt`-->J=Ot1 0Վ_ tyr_ rh  S^1  0 hL PͲ5[ ?  :N2?Aq%  	
   VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2^2*à
&}v~PuhaVRPRQ3f 
%*t,AYZXRPSQY[XZh?>tu	pp Є> qQ 5rXYj-:Ϩ t
*֮hH­&&  t8t'V u a,&\ nq00r6$^$ Z& &_& ;`Z@ `odde`P`  X#U @>
ڹ 靟 .PB B8uG` A ; 5䋀/)@#BS ˫냑76VŜPX
 a_@A@ B ]C    ÜFtV$%Ȱ%蝊<;weċ X<wM3ɆQ#"XR<  YыƊȊĴ3ЇуE pYE8@C0	 FrWYuF5<uz`0Df&	2
jpu8f߻hNePӀk 'B@. ,".  &k !< uf& bÊ$
r wAu%1uhӲ$ws}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<rfQKff
f\h\f3f3ɹ f \f0m f+f\ ! KQu*QآQh3ہ"hsV4C\`h a^_^fZfYf[fv3hV 5U`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .P\3۸ 2ҹǻ%&@GaaÍ6\hVWa\oǐz_^pk` hΫ&h  uP$<X5(sf @  t<   4 r	.$<u
 f3hh.
d]XiJ	hj;=  tdbw_3s.>Nfm ;thtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  h9S
P	D3hBFe:Ffu1r,
 h
 Fdt;   	:  <g ht5Lh#h`>!af`7UPKhrnu>ofB05SCA[t$ N {hD&N r hPf0̾   F^mP XSĻ  y ,    hb-[t(t@t,Vj Pj,>" ' À othtZdúߋw.":**ED/.EqEq+Ëؼd/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
otN`2t"FF0u3! :5tFFdz_ ulmb9p`F: uYeob +Πu"<6F14 ep0Fff`Fup  0j(j	R"	aURh.@2  ɺ 1 h=7Z]ÓoR+Zr@!  tCgRQ QK.YsY2$w
 !u$0dU|Z f`3 ߀ 3uW fIŪ.&"^f  ChY
>C ƀu8u.> c1fa
ZURtLޱUHh:cqkw:Yn Yp to(tq ;CPZoi@"g  squ4@VfRf恎h('0;^f[r]8"o [ZbhCXr s 6Sj@ 2P s rGZ5'_UqWqW`.uQQN$<u:`p+r"&  t  tt򩀂 tAt $uPNq9(
ː

 QN`XSQ 3u,S?x[rE	ˡ-Y[C& <ff<Ѫ`00xx00`||	w>>.r tr~ (ЃmrL]CX'tCVG =`Q<Q7W &TZs6C  E ц߆ԆrBo zuN! DO /u 0/r)0/f#-&A ;q5 F o-7&/p0W aUfV3vCDPDQD 7@4f^]&୻QPPUЂ wPd?uXd@I|(a@ `O` ͟/////- "  ~@f%pкߵ FACSPZ DBGP4BHP  099C A!  8  APIsCZOK	a	q
@  		`
  MCFG<	P	     @(@
 2! RSDT(  %	f`h!hsof  fhpfp  gfFgf  FPTR ff0WgFpf<. p^$f3.+.(f.$fgfN0~$f;+@hS
f3ffgf&f7.>pf(.)t(2W2@_~( N g&F	f P  rgfffff+f+.,
oa0M.> f
$$#DPXff-qAFV3g&fFgЛY[@ff=TDSwDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr}< uBONRUfQ̓2 tPpx@rAr /v; tg&P)XfY8]VfWfV*f& fP&ؐ@(#f]"fP߃)6Ȁ$ 4 
Ȱ ּ
ȀUN NNOPNX<fauff	Oh3pp)f t { h;kC~fPW EfX3 %sdZ
$u~3 g r-h4>@H@g&8( _i"PSV() + ,6>6Hu	 ,sCj@ uDb& ߩ@ u  @D` ^RW ?D h=bp߀ h _Z쁦 tǸSǲfP3h f&L *f* ްB*`#L fX`*h(0" 03fpep&?   6oOu_  t  DOGߞOf3ۦ{ pG   U!   O>O&geE E puMPMLGfEtXAt$Ot3 t)O$fM
rþQpmMe&OaxclU  r.@]hs7.<qko;   kø ݳ kktWp_{f
Phk0kf$ttӿ7& t? &뭿 'cP)zio_ԜVΎގ%E^3f`FF  h?w }u~r h>U  $g(,0w4'8  7Ã9FtF?fN8F> hm9ɀuh(Q`~
Ew13ɊMhrӯt

hrXp;r#uac5WF~ ^Bf_ fN^Nf.90u 0tc rfQPH_Erf;^uf_;Nt;ft) @ 
tF~U_ս UfOVff%f 
t;6 ).<t1v%R%*h\:,,׃  ^_p2V00 u,hy..D+hXكafS1_fqtA"   u
3   t'0gf GhECG$L<LD^COMPAQ PC Card Smart ReaderLGEMPLUS GPR400LPSCR CQLB REFLEX 20Q241 PCMCIAVRefl{ex v.2$ucr$HP
  wa@!g&O@0xGd `P ߳ rLfK smr>G	 .D
A O@.d.D~4f_ PQW¹ @ 
G.g&:uGPY.  _YX^Q8tP*?F 
;⡥fW
"
Q@
pB=g"
U

f%Qf_޲C`cShj;0Hu#{  f~uu .u = Ў~ 1rp&tj  t_& rT  r&= us`=6>
r/6r4.V@< t ^pJv 
w x y   h=9Sh:z %ZNhaGsja
qTrPqtI	f| U
u 
!tQ&׊DC{	GY V
},`؍vfD   ,AfLs-<t(<#@06~ hL^PRU32t
t
u
5# t u9<0r<9w/tM> 7SQ Y[t>"$,0>*SQLiE;߅f 	tu]ZXf`3&&hr#֎fv*`%h.~Þgf9t0Xa` 2   0 th#bq yegf@ Vff3>f"gf F`off!
!0A3۹: 8tCRP #ݨt r1h.f ufpq_  00i|? 0    0     q'  ' D 
 Y/ bbk$`oc@GY k6 0PS_.ѲVW Ȍ׎Ǎ~Qr&} uBr	:`_^d>r5r!"r\E@&=u	~+#PHr&E$7uZ5Ýʰ0bYa
cr&a)rI DTtr?&e`4o5Z0
T3
+_@U4Szr#t itct  t$BffL  	]J 	6WQ
Rn3q
]
ö0i+oW!z Pj˿r8u`_QY_ þaL[ r&U۾GNL螳`
Pw4$X` $2LPnB0<tH`8u6
uBp & DBlTt
[aP 3 r/) r?%BB!7J@ 
; 05 aù<t

B J 2@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$v޶Q> Yr	2Qd'YB@Aq Br
蹐 R~`	 fd3ھV7  *zr@p B`@P fRع! f6`οjzRAt0
t<asI, fNgfFI߻p3ผ	.ΐDt t03R&?3&Otur3 _P G	 	1uqy#uX$PXPu=0៻4 P%=`	XP$g2tx%g&Ǹ $|
faXu    P  ʡ ̡ A PRESARIO M2000HP PAVILION ZE1#NX70	6112	C 20`j h  H hˣ7Zfoh hg% f= @u [jh ҍc Sjjjj P8 g\ hû[cuqW?j&v^$bwtQ= ;tbu= <t/EݳX _hZt/NgfaÐ  p- ӥtH<uu)Ɵ:pO< uup@ z`3r! gr DƆ    r% Z -Z1ɑp$Wp1_ǀ uu' 3a re+ tg	%ۚ  .;Mf,ףf tp/Y[}rs3h \ػ Vػ> Pػ޵. F  ~f  `| tIe7r=? ~ t@@t0(5ȃ@ MF t w  蓪3N !F ~ t׳	u?ef^SZAt9A`щ f` Wf3Q fY@ IxȐl"
 z/2uJp2:!&= t: %J r lVQ&U fq
MsY^D=^
eOf"Aنm	
pq
6&:!& :X. IhBB 
De@P w(3 ?  A-wsC"up1u[	q	1D!IFtg$a3; 2 + fB \	(NffA(@~2Bt 1Q7ts$a$$$
7R< !*~Zt'
QVJf^DUY!.g&]*+t'H"`Xts.a:``s; 6s_+a_p_pkodqooo#oeooao
foo^`՝a|LGPhilipsLCD
LP150E06-A3K1SAMSUNG
 LTN141XB-L02
503
QUANTADISPLAYQD14XL20115XL060P}G1
AUOABaG01V2nX08`

TMc01EA0V`CMNXQ37Eo5F 
 13-C2K1 PHC3B93782ApLH12A3              Ȏ؎6er[>   >Y w 603Ҁ97BA ް8u!!u
( H 8u`	3ҋʸh:nBpMPW
 
t_   @ك
_X  
  F    SETU ˸ @؎&м  + r' W@ P& u_SV  GG0G h⚑)    Gu Fu t3  hC) 
h
Bt & ^[SO
&hl" X[U샿VWƿF F@     [ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @%<qt	dR>t <tjjjj3P8 C.wj5$<t.<@t$t = ;t= DP hEf 揿  7SFF~ t#^FLr
F FQ  ~ wt: ] [f
 h;\2%PFA~ t
F|_^Q
h7sk.&udu   hb,$?wط h+"h$} #f_01Fh$..}  @  Ys(`2WVe1E0 E.PWV .^_U(UAQS96 (96)e1E0eEE.U s@ m2a h~4$?e%5:$ء;9a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   scq@ @ p^ B  xsqUmf* %  < ! 1C  3	   kQVWrAu% p ?u  `6  | = _<t ; E@+1 +_^YRW@S Ê 5WCrr3ɺ ڑ܋[AB rN迷 _ZqSYUK0K9K
YQujzvzMzpOJ= DE<@ ;<<!<[3!Tu OOOt
Om[V?fPfSfQopf3f3oPooXfffDDG(	Dh fYf[fX^ v#@KgO GxApQRC3ۊ%< Pt wCҋxB`s |fDf3ۋ?fË\` 	
C  	T U S V +	?	S	g	u	`h	@xh	  h+	 h?	 hS	 hg	 hu	 aAxv.L.< t)F.6A3.PF.hy][+V..^?] |DF. P .h:↱Xh ؃ 7R  16W  0"Xa Y Z #[  
\a a _BAm]a f g'^a b ` `hcij!k qp10G pppQWĀ>`t		 u		.	_7   O 4a9Tһ -w C.E/2Rm?n8o7Y3߸ u _`߸^va>QRrPS[Xh(Ahȋh
3     xp     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/17z902/23/05 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"Чx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGIuu!
kүx00POl}Dxe``
$`$p

xb<
Pxx txDESxxxxfD@/10y}}r k ;K}d`xGBF8&x}DQ00xtxtyuup
*}iQb}ps ~aU}wc+½*").xjD00q x^Dx_T_xc{D 
T e p# ) ,}1_U
-&0=!I_	P1Tx"p2xp3T0//}@!T^ ^ɀ$ u!`	{T`#8 )m&04`hb	р{P	;G	¯"+u+$?4?iq}T+}'Ư+p (++Ô@]D#,+G
H
0%1ܛvP7/",`]B0/}@j.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @UA
xPxt"xd}<}?!" * /}AZ#/00x )xh`xi  p~ 0S+;.TB+x+¯0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$P+-` 9
Q ` ~Ô2@VD0¯xx7x8r x008`6%06 @T߀G`	p>4UHm9A@#ZKZa150)4"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >?TxYYL)^ZLL&	Y]Wj`q!j0Qux^_DND0= +>@  U/>bgxdp&b]	:<	Zw?h@jQ@*ARx-	+_SRNx*SMx+` Kh `R0 
0oeQ`
 RWS5PP1 03X 0Q]pd GXWxZAYAXNSXW> }X$R0Yhp^qZ1ZTpL[Z1±
Y'Z[l0c1\\T=0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ">4"7x'D
 X /7d`!7g33TT7?O`C`|`07`'`2`=`HpQx] 6uuuu0k uu0 u_u5ˏʿO$ƨpN`0T`
0100@A"| }(Fx]@C"+,,E+p  +C,,+ +,+x,+0@qx!,,,++x_,,"-.T0㧠L721t
!Mt&Ipd `1g	11![txU!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0|" *xc"+xt`
o3x70x8W7tP}0h"[ZY
YcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x O  ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2t?x1tI-&%[0& &xpvv ?&xp[CSxr#$ % % "2x1 	  ¯0 $"@K@3w#b0"	Mx3C
r beJ"xqF`V0 p1#" &	x30$0%<T{`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hp`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D"0p4h4xlx}@ DT 0s
 pcpB"pxt1xux|"xtx}xuxx|	"xw#xmvPxyvxwf`Ӏp'xw ( Qu}B@
"-`a"x-Pt %-o0p0p tU0/0b/R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0! H `p$P	<0
`Tb" ! R0  _ZP!1D12nѧ2!1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)n柵vpP*r 3}TOp0@0 0 
]):Q0`*/[JP*'2BP`FӀ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$Mh' Ô@]Lp4Ң

$Y	0
	@À{0-$`
$`$p"Gaބ"߀V4#߀K0! :0!@À-0s
   is	!l~2!
2xnfPYo0*2d?|p06SU{zy f xovpW-%_`gK6P2 ( 	4  =E @;H	5345q3`~	t%5544}r	@ :0	h0"06`	2A[06< Lr@1k 
  
 *90 B 6, 
j6	" !!`BQ
p0( 6g"E^ @
-NU
]D7U 6.
j'	
@bG+6,y ,y=f-e2pO7)0	LoP85p
y&0y		ay	0
E ":"0y8;ofpOd:!/c)P3
(.Cxm`qe`?0}DН h,g,!a,a b}e"4xrMNOpxD  Pe4`^}R Vp0
T4d`$"4#ap~}e4x_d@P3 0
3 $`3`3$`e$`1$%7$`9$`$`})3K$pvA?T nq2c1[0TxvF>&`!	0,0)%m0Dx  Z30a 3\mP)6P 	@Rи?&j¯4!`p` pJTQ`xj  N*`/19xv
xD}O}`&h0{^`
}iT?Dt?8`PUpY9T~:ywOq"[@`T`M	0676$``$p``1e7`tg7"r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*xFt p[xBB~xNNw}^wxJqJpȏ:;_<t/?=(x ү!:%$t=t=;2!(0 (=$Px`vT"` 2'<x"ү3y:; 0( ;:@ p0 xv6QxV86}'p p 7  %76o(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(  4 #)4 040@O453``/`@$pN54&:I&duP2);P [x 
33oppG*L2]>gp1 ';P"ސT~ +ڵ?T#>үd`pxHo 8@22P65b3e1@d@>"01h/ 
m
`,R0xA%30 B1
@
 0E00
TDT@5q0	 3:@a_ AP}Nt
 u2P2bt߀l@
G0.
@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM"^p  d.1BS)x0,u`2:E,`e4 2UU.X5%.?,*ۀ 2732pha,
$,SO!% *R5 }
Q'x`S+0	+_- )-R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp/,~LDy}?N%@k53.Eop;OCD.2qXċTQϠu:93: !p	S31B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_0nX6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/;u1
p< u1a1P؉*C{p4z5z5
3z*+yuv {| A+ 90& n`AT0 +	al:hpd010upov6o,/-.rpF}}0
~P/.-rdct%,f Wu tq70YS 8S;_"W4쑔p1BŐ}BT_0=+_<I?_`$<p:T0Oő78e`pYלBxfSTAx`%daz0  87>P$4 q"W¥A3	``"uqq
r	1Q`{0
+}
9ȷ"rdP9$$P6"{ 2^F}&e
'AChS4Iq}a X@apR`pLxpG3p?u]1$U^#5_`@TU`#v@|T kx{}Lxzp R{xy PxxPQxwMxv0Cxuxlxtxa{xs`xrxqxxpx`{x|Lx{`RxzPxy@QxxRxw Cxvxlxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TkxfQf/^p0ᒝP -^ ##-{---Εi C?",u/=212B0T-21Կ^ L.S.W 'q,Đ/$=7,T{AO-.`\۷pGJQN.E[.NJP7Ĕ0p0Y))y0h&
P5
Ps|?`d7]k}OPn,rt7ar[4Ng0`a2Еf
p1
P

Q "u- w09r"l  },n1vg9_,  A3.0Q2O.pM=1s0D@[dT0uǀ`zP;kDS,c,u.B.t` 2 p0`u.Ta2C
.%TO]лQN]03p	 `` 9a :b K$ :b)NӔ@6S ? x0!  x60HQq7prrqxvWU	Xu

		0
  `
7P"q -
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axj6"]@t7 C9xVxYFdҢX\`T`HTǯ
PMs>@C!3"x)"U\]@0!Qqڢ97F 03tv`
pUr )J'' 'BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`=J=<A=<aYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp @0tǣt A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?6 0 G=k"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/*iJK
I
cJKL;Md`NPT&` v0uK K@ 
MLtS QPHKJ}i}p}~}wEAMI!9..Cf Ô@"TxDTTAnp @($0*ZE;@B}@RTs`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQo HpHi"pbbrAt"#xbo o "CD)p3,	0Np#q! b* 	Z\9wV NXV$`RQB2b L$BaUӔ@UOaůUP0	xnZÀӒ }?U`#`5?`2$pCx@x% D4SS [CxaUUT`?͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@_`B<pxr
T" Pt=`ixo aav+xmv25rt4}pt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂATAAAD!@b*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAE9D% potNA8`pC,D
 mT Ag ۗ@$KL7 &;T F87#rTRx@ZاEQ
ha2>W`P A7O0Dz=Dd
`#pw`(`0{<`PdP`d`U0׊U09NN!ǈt=@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtx x#x> x=t~p x@t	0xTВ
}@%x"Ttx!TTTaD	x?D@xTpT@=TT	Tx= Q
@TxDpi?=DDTxjv0}Ct UQdMdR eP`eLO;K"x0xJ1"xg/Ls"B S?/?@>"$"tO>Q$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H鰊TIY1	 Q
 I`A @tR1~5HWT& 8 `;cuTuTK0T"$`($`*`-w/rp4
TB V@CMb Q P"RLT$`6$`!`0`?$apA]D	:3P
2 *}࿣05 #'/A
,P3`G`[]Tp]C"T B dpF]K0$s `!DTwwq/# TЪ0 U "P$pR_	PLQd`DQxgQ PQH? Hdq@P
qJPoxgv@K K K K K
K(KJKNKiKKKKKKKLLLLL#L(L-L2LBLhLLLLLLL  L0
1v"xrMNO`uRRRsx}e  /x  "%m"0RZ
R;: ܵw"} HGG}0"uS@	0SSST
TS?0CSp@zu 0P/ 0@4xatgvajQ/jxTxjD0@FxƋGxbx"x@$xx"x`}_K}IF	
Q@L0""3`H.xT| } ~ Jǐ4Q_*N`PRR &NM
((sMFMLNUNdNoNzNNMkMMNN
NNNNNoN.?PAÔ`P/0"T? } >00xe`"QfSQ1vPJ0pV	`Ы50T;2uQۀ0K  0P0)	OS":Cm$p
;`!/0Qp,"xdP `e~A3~"~}e 0?ICR3AP>2IQbHbQ!0M}PEA@JWCWEa .XNY Q`lT0 ȀȑP O]0#0xD oTxh!1?xxhvY T 
AApB11u32}'  $31T3322@"O0  "(IW "O k p}"/*Oݏ0/ÔP/pC0S00O200 ۀ"
xp0 "pExƠ`B2345&k@"(t?3t 2xA325R4U5B axQxQD{QxQ  09t6xS^nS }CSQECQiQQR45 SJSrSSS6x
/0!x
tP/P
߅0/x
  x
Q{Px
! $60#t #T %Qxs	}TBxr0xrßP2P]0 p%@$T$ÞPxPr`1 	^,1^&,-u. <Tү$`&`p<Pq}_ p% CBp.-,6	%xxsӔ@v $(xrvyrxssP!  P&0{ 	r6
pxv 6xa`r
 qP 0	,x?x
xR!x	06Sɀ)^PM$3p 06d2S STT
TT T{T	T
  UB{>pwfDa4f D@ @B@"xDbU$P``3pTOW"X  +D "vz:hTph`/AE@^E *@@CEpi* O0~@ }w 33TOB`p@r@0"p<`p}T`- ,*,, F5@S,  lS,`xevS,,"+,/0,Vd@VAx	` }wNPIVAu0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_55,Ӕ@xA=-  X60c
+p00Ӕ@@6@0,	`	 VVWWW=WWWWWWXXXX?$XY%Xe&Xn+X|,X-  X,6S	XQxu/@xB![-.![P
.-`Y<	
x3 t?e.?pt e-``l	clQrl"	`Ax@}v}t&܀
-   bt^,Qev  q} pQ t u vAO}	}5!`N)q倩 Q!q]G"P/u0 ,+"7_wZJXXXYY
YYY3	Y:YAYHYOYYYcYpYwYYZ$3Z:  Z5^PXZ:Xs U S1
tt)ŵx#	
pp& ,D lTQ@ST0BQ|
b@Zl0'0SPؔ IZP  cZP[`!!I0~GJ{t(ಚDc4rKrgQ
x)1O`D1P,1P
`QJCS[ "gD `E -Pc80.u,,L,SÔ@ ."W,ҰP#t .`
T/Ӕ@""@
u/$ -$U/"x@|Ӑ T"5}5$24? [2x[[[['[/[@[I[J[K[N[Z[[  [  o_Q	xk`0/_" о 0/T 6uq(Q`Aa * " 0f33o%$1A_Pe2pG22640!+4d	`d
4WFPe"a?nv"qߝ"44$`$`2$`B$`J`[$Wpk0[3P S0//V_QR
D	zqv34A@GFG4pS
Hq
D""""0  ]v]~]]]]]]]]  ^ u2#^#u22b ! 0! ZQcPyA=r!
D\mb .u2UCE6r8QZ/0!rHQ R 0 3}P2"0"x%0T~t@"@7@Pu@@	T@3" O0!xo~? d P""0 Ɛ}t 0	}i^l:0x0x!TT`Dp T!!D`!7T51 7ZxD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b`"
% F`7@0x+ +axqa;+s+I `C0/+xT 6 } 2}.uY DT_`6X PcTT`40	61 ` S 
0cx	+$```9@=`xv 0z q DxT"ҎxStTTH_]+xS+<x, 6,@C`$p#xSxݗ+	x060/E#

0_ "p.-Ô@-ӔPq @
QPQ/-$$cp50/NC.I}. 9VPo`@\DkT ]P-Bp}} bC..s b;@X $~SSN`R$dp[. .|Qs".<t dpDaQ0Ӏû/@ۣ.ۡq xk..TP"-.{{ i"p#"xi7"! 	ӛP	0@@0߀ ÞǴd`PÝ@ӛ@*pشÝP:;<u t/t"/01234u5Pu<$t}5}Ю/[cÃcdNdhdddddЍdЎee3e3eVeVeyeyef:f:fyfyffg5g5gXgXg{g{ggggggh)h)hnhnhhhhh˽hhhiii(i(iJiJiJiJilil  i~K0~ %~ p0% pC3/}u: u; u<3{bhߏ4iT330PW66
~ 6`  fR3`075u3@u:u;}u<{xu{{X$::;<{&5jhg0  3h)g

-RK>,@1E` 
} P0C3+R#~ 0`| }` @^_NR#`##(
"&

R5P)*)Np<Id @(-
c# :111{!7(+(/**81,/,h3/1/5H13G1҇O/]|@TF1R
BA$__TWB1 u2d I'8B=9='8FGXCWCIˈEE̪L͸GGUUo`VII#M0V6P!}VbhQW/"qV πu3/˭/\Cq/4"$y`yp!SPpnz @@ "@A~G`jPj$j1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@ABOr+ 	 	UU		V 
 
W
Bxs		 ے":0dx>T=@Q
38T>?`dkP?k>IIPw0=p1;P8i } P' 8@
ఐ| $ >D H\0
0k7dn Ep6"}`~I }oP k#@b!p1Pg0ڐ}P@ HTTn6 Yt
䣾#Dp#0PB~߈6+r++/0
~IС+2!_$QIuTl@&nّp0tV<.p{P 
41nll"14PmuD1xe@606
 0ǅ@60'Qk0e}pp
T?T`4"4" u2<}0n0`~~^z0kTODt001p32k2]* u1tAD00 	3yP)P08@PQ@`2VPD2B32ӷp087Pc`&jRP@P}`"aR{3"0PT_O"
070% o03g3@,pe0`!01?2_Vbeo0oP3ఊ1!n10~
_  c`5Fg9 	1DMcA&F=@T3`02`;:+"45775E4`546OP
(4`i77$pTo`MӐ4}`TM=`` `'p->T
r AE D i0$CBDf0Wq BݿÔZ	6*u1au0)<'2u0p
1}}]34Rӝp2u2u0@O*> $3@P20' ac@'
L`1`2^pܣEl;8002`BTTT%%Oi>6xEp0>3`Dm
` 
p	0d`0a1\Q]T?`<@7!?$p*3tT9)	 #c H@J01	a=2`nfO"c"Mc#N$'NTRtnپ*$	??
o)$	6
??u)txdd7eU"}{zy'1Wj7u7dj12u704<t`uq/'P~ sd./ds5%t#\|vh~@_[xtQrtY0ppT0qN`۔L=2t[	ÔPt  q䑘o`v`z45ӼV@/Gk4373  ~v0((svrvww wEw}xCxyy{{||}Q}}~~(~I~j~	{ z y4k	5P4F w
QhST{lSp)1
3D,t~5{u4?`u5 	]4T`pd` ՌQ?
p0
P!Fu	r	uzLoBmP[|| ax>[}} pmiiiPKß
Np&V$0/餙Ziz (
r6_7d6 N6@7"BPnRPJd0,v e5po4l`&{JPqw!]8*8EU| `z {E` @\]Lvv8999889p#!#f8`9#
							@45q0F_ 3t[c98(d`;!PDA-0/* 
E0A
jZk<uÐIIP2S|U~dLp{t@#aM`M8@_q;mpl`T@
`r/@;ňqdNpt/,V+`/XPՏYP7[Z|Np7>	 bUodppNCWWriҞ/T'P#^/i 4(R?dnJ&pf1h)<Aj=Q Vv>afx?PMrq iհ},KD|sT-`M098&0,P78+3 7gv3?"27}3+P~ A| 3$`A`yc $)~ 2ࣁ)u3#?ux 7 dER tu`
Ô|		q@3~jPt7pz9qTT Np: );4u3tpuq$x347P1`04Abİv[#p1 @On31%w@HD?6Pπ
΁~g1pc!2B<},2"u0_
03}@bY%N~N0J
:>p2pP߅u2f	op`8
0Ʉ
``619100bP"bxeT`&}$31PtP2"u}`q 
P"""4}{t t tP
3U02	~HTD"LION x9pP
 DQM{T":p
"aM~ d˒ Àz  0d"0Ӏñ 7p8`0@
D 
~,T e8 )[@pa"
,"`"x0 5"5q"psx 
qUÒfC>Ag>~ 0QR on`dx"j7ud8X`,7bP| `  Pnp	84gk8$24="89F;u<98~N98lpe;~N9E8 `vj@@~+k P" U
pmq< &Fx33 d ::Ӕ}@o:@>x#q,	:x P,Y=x@-_:Q SW<p ; B
ٰ0P]=<>?u@`"H  /(p??p>?
>Pj+@55@@	x&T@/"%T~ O7&} @"`"E"x!To`	TT@5S73o`p2D"C
xCpxa6@>4ra/T(--,r e,p,,~Me,`,,|21G3>d$-t"u;2<rA&8<9@Ju;;;`P9:݈0@ɐl56x>FM
 pb?b6655	d` 
GI~G6CM"¯ D+JptO*q+,U
,, +,0+@ޓ^l@T` fOFG$&^&x3t
 T0xT1QT4TDx!>CD@gp
0g1dpa2u3%33+23 2@
4pk0V4cl|N(%%q
_O Z0a00*OTieT		TYAc~L_` #Aq""	F	 >o	@2xpd' X LҀƀԀio3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``pEsB"P""): "P?%0 "b``"  )"/33ߝ@p " 3@P"Ø"(p p8u

r
߇		
KtQ
X
	
׆

} *32 	1	"t 
""BBE"""ЃЂOP  tsw6 s$Ńu1" "%5@bpp
s@h`1p1 1@~$1v1@n1 Ib1V1J1e 1111 p0p0^0p000#Vs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  V|  /I   P DSDTDSDTx  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[1@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0OA4
yh1Ы7E: \p3 D+Ba(80V1(@pwA5!ikp@"m7APFbA
i9DF17BO&$r8C}j80[+GG6C@:*BA7
@
[+  A8VA9Q AA$AC06D C>0AE
A`9`C
	^   z{` `za 0 
bw
t
	rab.C
 101
a )*ۤT{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` ?
p{z1O wip{a` rb~qAFb yC11	_9`pBw
h nc }r    AA3
ccFB2
7l
 B3 SB4 pBt e {ky
 B3ee} `e Aj
4a{g`ц xq5@p #b}e
eˡ/p !	e e$}`@dAyA4{k
 	``;}qA
 ЈAA y!-Ap?d1p68d ^pA8"9 9e@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
7@
Eb~dB	!ba'c@z!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bB/cnpyacaABw'C`C~De  dBߤb[FB9DŅGGGGD DB6 7#BB
Ĭ@BBBQBD-_PSW%12ڡB`k (!`AD[(0@E֡ F C0c	C1uVm	V o	o	o	o	o	o	i	Rc	po	o	o	 o	o	o	 t.ҙo	o	o	o	o	o	$N!T%[M 5c#x`0833bý
o[@PCBO /@CC
P
[ہ5   CD K ECFвD`OлD1  0D2pD3z3D @~  PD5OT 9 62oQ
 U0D=:
c`7
 d 8 0D9DAA!D$*/D(D//*/D 'D//Pf!e!(. G!G!@($3( N #F(FX//M E0@ #F   //A eA !A N A GA "A  "c0EV/6BE2g0E2//*.3`03'3//@a0%1a0%1a0n0 a0G1a0G1a0@1BEtJ  JHE5	E6	
#  y  Eh`и``
`p`aspa!E60'E9	@	V`Q	``EA` :a'#B	 p$qCq С	A`v[ODPHIDA_UID
`{|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)H$+b1 r)4f;c!2r)`C EDM 	h13r)@ U[(iA 4r)$`k0jQ(5 r)3IFp{8k6@r)71>8B[U!a42[F21F3
r 4
 <5 [#"GP9uZ[@KF26Iv1(W 8E,C054|zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ}(FD
 h246 `U 5XIEc7CZKFF
048`
{i}`h`?{`h@48{i  {@ 5$ q\._SB_C100tB~ o._DO{Sq	4
` a![^ 1bb ha[Â7ɠkDC^YFC
 G E SSaF
h3À˚rRcp*r&R%$C 

 
h06E0FD	8hfp
` {\/0{02<98
PҐt1`0D W Q   P Chi82`
hA@ \\n8\/	F1 YF5 @E6|o6HI"7
 i 74hj	 5hijkCq8c.5[0h92s 1 0p
Л93r8F2! F)9
^/p´0kl0^BRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10mBF10 #0DE

p1F@111`
 2/_REG(pip015
 a	ia113[J  @@@0140ް15p #  6!7)8A9ArB 11DoE F20+21Q 2 3s 4b2[52678 p9ABQCDE\A130Q 1R33334^5 6s 7@,383-AB CA3EF064q4Vq42 3A4045Q 
474 Q4A_INI U4B qBq14DG[  I E @F:C150	wh
@axa
d?b`t
@`@QP
a
 @}a
a
y`\}`a!@81AZ Aazw`
d`xr`
  
@bauaaF52
q 3s 4
Q &6+57 9
uAbt15B2C
Unknown 
NiMH 
LiIon N dPpupu>0
  `a@tgq0Awi/1(`0AQM55
a
DV0F7(DAPS56@`	9qǅ}ha{a
/54}Q952!>
 
0[QQt!3!3D15]PU7 A7"ưE	`bBp
P?{`{@I	F
[)h`pXD
csc
  dzir`a[)a_bsdb1/2*(ccCCo160	hg3
qEg
BlU25B_{`g  61`2hC N 1FQ230a3h - 126 w"9axra
c 
dcbpubb,ҒAr	38`a 9a$(`ap-q-2g2$@IX64
I+Ep
 vW 	Oip
q:/3r9"29cBcD c600 f{P`p{``EFA;ޱ  9H2ccdp eeez
cpOecpci3t%4?s 5q+p
g5IBA`p
`kD52021C-+6vG@+yN)0W1DQ-  
qu>
>2  P2pzo
 5Wap%*!3(B+BCB@H`*se(a5h/C	547ata
!e
b@Kzch!

D

6Aaa`i34
@ ra 9PQ paupaRHf:bc6h640U>77@E BFpUr?00o [
~67rAч
H{P   a`3A
Sp
SIMPLOySMp
MOTOROLA aO`wpV8~68
p
 
Ajr(_Q03':Q{BA Br4u0Fb p
a4aE
bBa:TZ6u9 A['cTZ3_J
6pn@v
;JazD
ab6B
PRA001A 
5 1_2 N8Et#
IBC^D#9nO
1169_C316

,
{ (i28Ci$ŐS[I}EE
6F
N C1771F771 720  q |!6 FU78A9ABs7Bs A7D77F80
[  њ882u884k85!887׶88҆85UVa9A
^!85M8a88Қa` 78`
J9>0k 89pOpi8B8CrA ằ cBbaAc3gDGb paA
MCBFc18P ya
 d
b
 bdpdS c
 c
Нc
98CB`8ѷ88p`kaʕa
v2C albab`b
vbyb 7717Bp`E7A9q !D#!Ad9zj
!%ECW89=!E#'6vqb_b	aq ސbbQ8FQ
8245`6C1930
726" 46"5
q1
{C039
`{  ia` `8{Ahp!
`!K92	H1AB0$b cU09abcA@'K93 p^}^04cIX95LA
96

Gy3 198 A	A9/ P99d796[B!AF_C  _DDN
COM1!9B9C6
30U"]    w8y `NS  9C_STA +9
`;1
1
 ,+_DIS =h03839
F?_SRS V;h
aD7cDr?e)r9B@
_C
}w9

 ` c

n$LBA[Q9E   
AF
__ON_q0&_OFF qPR0E[Li9FSgMF!# C
_G 0?" *
g~ c+#[":@
"B KY P@A0! L!P~A1:^<!4q1As9D8ܐ!Ah!
I A *`""	0A5
r
;p?#0KA0s 5$S1$	$$30%2f[46m&i&!P'`& $A6[C: 7l@?@A8p_`  @?~A9
.G"PWEQcNR@AoAAAIH
1 Gxx&xx"٠q)x)xxL  No r^r_ _u\SSAAS`Pp%SSPHqAESASN ?3?303LTaX3xTn*AGm3 *o3tUb0rAB44AC4?X!4X550Z5w| xxp
,, `0AC@܀rA885_AD=_75_?_a =_PEX:D)5AE p\/@uqw02"3Cy(ǉћ`{vz0 <1tP|[OP%dd$aB``a  1B2A  BB y
G``GOpp 2+BCB3
q 4`BumBB1B1_B5[% 6s# ^_"  y s7%w@ @ "-[A1:
 
 tP|
     *"P8tra a !-9E
0 p Gr r " &` `0Gd d"l0B}B
" 0A [P+B")UBCa  BCBD&O.k    0[+#C@
   
 
@D@C067B0ADR   1C0
D
[v)C0C1 ГINIsC1[C2u3Q#4 D
C0CPRW
	
vPP
@7[N C5Ö	_RMV `;*_EJD MМB.7P CQ kBE 0qC6Q I70'PCP! D D0qcDS	CP1
P

P"SI3 p 4C,ON

[AA

(A_CcD0D 7`B`
8P0A6)\[/7YA69p?D*D3e#4*K_GTMp
 `dr
5 pD6 .[D7pP
Eq B17{Q0$6
"Dp"8axϣ D8a@ M FM hhh 	Fߓi x `p
w@l a:` vA` bwb
bw0cPwib 7ac  rb [rc u`A2!abq6%2DBbcaq:r6C !{ Ð	&0I032rj}jvjs{9q4'[u0DF p(gF  D3N8i1PQD7	
# `hA8OD9ODAOEDOEmEOEFOF0L	\_PICPh\/הD6M_T MpcD6E

Q:   P


C?@ 3C) 

 GC

A 
	
Qa 
		 EF!	A	
a	5{52# "cB 6-!!!  ] !tԠ!&&G
 !Aa6a 0[63@	F
/R  Bkd
d
Primary 
pQ   
LIon 
Hewlett-Packard EyTraveloka	2Qsi@ 1-55PL`60	004h`/`u%
 
tz
" 
 ;
]63h}EAA4A0QrFa!pFrp ޡ4ha`2h˱6PT
_UI O{5EP
_BI0\Q[ ST @נCL\`[H1;' "Âms"E6
ACPI3B_PSRO005`O5r &\PR\`01͓181`^@yE[:v
LIDw{^98`p
	/15?@SXCsNBjfE2 PE3 U
4p5k@k`Qh`piaFa ?E3
 a{`
Pes }a
aap`k
  pap  q1 E4P4/ EE2  G>P6rt

 " PW `2`h~p}
yj-  &>Җ1 h)σh` 	6` ibPpbasabcpcau`a@7;E8@! Pa a9GEoAiEB 1C PED	! П p
`

 P  Сr?
` ap 'E FaDee[wre
 
m #F0F0ԛ02BpFAIaLquASIMW J/C04ppu ABC^1bTwr2}U3R4]u5-3acA6c"B
#35 sE8t
.A	Fg7YF7 `SA%QB	C4B7  *u&&4aD&O8`bp<JT7qD0@ `QưPASS(>97&aOp>FDB1$pLp` 4Cap	q 
a4E?E#@;'2`DCW,a>bba݃C b ubPUYo1:F q _WDG?
<4_c,E=DAAyB{M4C~ !f )ABqWMAA kEAij=10YttF^;p{P56
PUpH)F8{h
`3{;44T `z85k047_54
`F2   J 9 Aq3	
`)i97"& Q{#q,KC
DC{FDCF4m;{t68 
$5+/	IB	KOp:`0Cph4EA',
,Q2G!h63r6h	2_WEDs!)(AWQABNFOM%  6:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9qx"kXu1jHـQj(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1NW9B#?U>2Fpz7G	A>|=h4/~:zH8P9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTg_~"CBP(Ġ^|7ȑG!&((߅  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[C200 J00[# l[#\_GL_yh04BpipjҺkоD04F\C0F1hFl['['`[ 1

[ 0234 b5 206 C210}4phV433e44 Op{zh 3k6h7	2 5 1 95i	
5A6	P[ED21D21E F 20 1 2|0q23  W4 r925024
w[ 6@(22728 h[
28A9 }A0 `UyA
	`rh``vF	Bacdp
aJac
`{rd  b}y   Pbaya
a0apaňc eraye
	 evepeFc ucdcM
CrBcpc  bpbgC	bdp apbe)ece ffg
fape`pfafgvdueA`=bF` gT 股`$b pg17agg7ag`dMD,05A ,  p0`c`bfP20 1`Qyp1 0CpB  D "h Fh H
bhoc `r Dcada
eڲ2,22-adft`f	ru'adRuc2ߠftd 1gPq;`5bA 7E F23F&-@9%CD`Q&2aqD23a
_INI-EBC060pibhbFp0<2Frb
C30
j?301c11"bF@2 w6
arC019abpb|.0+bab~`babuaaP `bua 3/_CRS!3Q19`v1-32`T`_STA t
`}``69XD!

o	     wy p333 A=[K\/V234mHH
Y35F
RG{GP   @    Ps3	0	p  1	[F\/*237}Q [194F
rG G$ $ GN N 
P P Gc c Ge e g gt t;    P DA
T0 2 W 3*\/
AF
p_*2p
`^^.C16E3\_S0?_
 !  3    4  5   M\_PTSphU`37Hh
 Mhk
M	0{15 gˠ[d1DC FMWAK0~ 4 
M092?010A'tp8S 115a	b4Ї6 sTZ@x39~ TZ1_
 2 @15
aE0
p455bE

OrFacbcc:c6B
<PR<0 =1 
 
h?0CB
 6+BA-C1.J3n4
 {,K\DAG,<

0Qn6

b [, aMB|JC3WWENpkF
40
q  bQ@M445C6 7W a8ꐨG90^16Ao
59
({!h s(C4EirGr4A
pp
/F$5R`Mpi_R@np	DB
hps48p
`pi``
p
9r#ip`OBIо4C@`phawh47irr@
aFU` ! ,Di ` a bB{6E
X i`YP;?	 CpKAC39(0ap2
	
 u }qPjt
a	t~ xa

`b@[A0

bts
 2

	1[
!
 (F!0E_	F[ 'YdRdA,[p{v43-{b
0 bbwb

araMpLa_hVh1k[R27 "m@)aR'5#h 11(6`( !y
h;C{a<b M44)k+Y+h` a`+B9  A	<)`s6r=3+3AOF`hy3_
Rcb !K.MG
%::02hP
:t`2`x` !fQ:fF{tf'$$f t5cbb<5)b&q,B`bkbFi

ep
d
Y Id?1 =dO:q>ei)(qN	4haQa[&50  0d
$_ON_pNS,JVRm\AR_OFF]B@1
EQ
u	2	
	 lQ	
:3
p}qQ
[=p54취چ 0}350["U5MH1C6DpԆ2G3[@_sAL`AL1PAL2	AL3C
7_AC0 "1& B2FPb3fPSVPSLsqG#8pϑrG3q(`1r3pQF3oEp
p
S70$Y40SQU3F_TSP
dp  TP CRT uAw`wTMPA4P+o[Ga`/19#5A,@z37`1 ԟ+ HO\_GPE!
B҇O
_L00	 xxra=PI{` p{`S
p QuPm` {݃a ca@BGA 1 I{Z679   I8CBC0D~c}@CCEo["
d/34M@9 H0*_`.	oJR
3>
BK67CD?#EJ_L17 +82?`} %U@2(5 FS:A{f4
Ӏh
C54!E0C?1E7C1FD)F7%8'7GDG`!̾r28!f}!96a}`- ߻8211@	pF?59`L!?'.??3<`
?`
H5C 7@46JG
 C015
+ 
 	 ["SSDTq>HP  HPQPpc?  MSFT L4UD@	`f1    &   #3__T3	_w 
_	O`5Ewj{
`
a4aFP\6m0p5FijP60  A[h#2EdG$2 261_262A1$"2 J*33 Kyj20D38j93
Dpip*bוb`h5Da bub P)10jS205h 6jE19r4yA {64,/
b+1 {y U  V
!5'*[Ap NPDC{h{1660lPC
165q 4	_PPC `nS666      	 CPQL_BM  vp }( <  >0_  Hi O O  ! B f (&  $~" `ܾ `a!  B!

 zZ `  %!a   * `
! 5@b	Ya	!
"$b@ 	 a	!
 	͚$&Ra `AE
 D
A! `(d
`  A!NB 
Ϡd#b
@	"	&da*	H'a C	$ ~ #%'"h`-a))ޡ 	aA* b*/!'" 8a& 
- 1,0`%`!05΀(3A
@# `51*8@:-@2aD;%aρ/7B2"Χ`6	$b =a :%	1	3EE9C?HE /1' A;a@@d@?AAaA%a*"BC
 7 @@A@!9,aE
 %";J9 +Q;H@ F" C5!$(%C;AFP>@F@9BD :S	BPb<;DNA@(Z4: D+a>@UR\!$	@ݡT'E
O+@IX3$ ]*d H!ie@`A5C F"T]aV&#e "C
?Aa"D b^c"[+#"C CD(3#^ Sg_xkDj$  uCme)H$ ` RJ7p%pD2! .!!d^
}Bp5I3x S&`5 %!jcnH~G;wj4'a?JD yGe$}F5AI!  iZB#	"d E"A`Aȁ@ bAG'FF 
"!AK$Ic"{
6/"ă!QJ5B	7@"j  G&a|geĩfC'D H7!rdP G7 pE$
R " g0xHߤ ha$
hbdߡĀX!iܦ6¥@̢ Br ŊB8
c
0sdV0B} ţN %ae
@`A@@`ǀ a! !!aaԠa!A@@ `Ab,pA,$c`BObŅ³AA@c B
dǀĈ` 0A$ AaL"a̡(>ac$AdZA aPM@B @K B!! b<
!!  bീa@ `ߠD'"ޠ "}B  %d@ۢ  `Fh&" a\ ?  Bf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     "
   	 OSBP_BM   p ( n x0    C % uf T>B \ 3  G?  f  2  J !   Pentium(R) 4 M -( ^  H3EUV
Ua UwuUQ"3@35
UW 9}6@U.2  #f  "`0Ā "A=Uw
"
`/t a 2
?  3>=U^
 @	$AWb&
	##4@
w,
@d(A_A "el*@AF3(b'@$a/@C#`))H(!5$e" $a*!)-C'(A*'.$a6`,^"40") 50)B663`7""7A#?W!Q "6 >O@5<!BDe	c
A
E GcCF`H0HWw(@WJ MiDB FM6E  =	@J
@T@UK 
g  u
NI"uW'
P&0AB?.A QE# A2`!=g2,`!
8C	A>&΀BhDMH`d
̀!
ܠ8q8( ̀h`:` JA*@	>ߠ"@]`"a_# ;	"		Be	_#`0 mСg!ah5B  
 "@#s 
: 2 &E`mx" hpb `#`n %.
"p& U 'BD0A(@E.`+#.A eS0@, 
Ha>	 `>yP@!` $` fj2 :`"{cL/F\`#_!A !^2eC_
lt>@oA*A㡎Drb+␠3
#2blj !?! (!.BvfaaA )%| o"yeAca"AC2 :eAA0a"'N @BB#/dI&!Ic( @8!aB `	,?:#{#C`( 5 A  O@:EB$c	
"/ =	`ࡠ#=a%
C3)waD¾qB o  T#
aB5R2b/? f"N#A!@D@}"2"OE7M0g @EDBOO@B4A/AϢaX`v/dLb!Qc9?f	B? A!s cO od0oNA`z$>!ba D %cÿ#Cj @Ѐ #e*CetcfdF"_@ cZAa#|,	BgbY3³cA >#9#7BDL
n00W@1 @&#Dl?> 袋 P	VH> VB!%t *b2 R "kpetp`yfb0b {@;k @(!@dch @?	`/	aA"m$Ty⡙L *D!-atI@ᝡh`@A
	!@bB0AA'2"`NAñ. `# : e!A`baED@e0A#!3.'H f@ &`B@@3  L$@$@"*@ '`g+(l*"# 	`F`u   C`   F ^ @Z   \
   I  x	   	 OSBP_BMI  p ( e }0    C % 4 hG  f H  ɼ         
 Pentium(R) 4  H ",    
"#
  P@"{o"o r"nAb  ?b@
	 b | _
p"'HO 
U'
@HC/!/

 @	+do
$`*BY ooh/x@OOMA 2"#I $a}('"a#
Q a  # 
C*)b  %%)BZdr/$U*uP2_)@W@+*A "Z6 6A
&
7 .@2%	!:0j&J4U&<3\,=B `'>P;`a
>6AB>OD A& ߪU` 
F 1[=Z@A*sm @_4a"2A>G2""F"KaLYL%J@HmR22KXBL^}CM"QU
U,c(֡	&!JRT@"f&$`!#U)S&1  $A F
2@Ȁ`	 FD*X@ ,"Z)P[ 
 \
T 2`]Q h 	X@UY(c 	 UPrAY ,Ppt
"@$AR`] Zkk)
Ae
Ac>	0g@"] @c$aA_ c	u
%Zb 1L[ 	Ja`4]
Ex YA*P_@qF-vԀ#M_NQ	,!{!
H!w /AnBAГ$akD #YPAn&AQx 1!"_~I \4A_Cbxp a 3zIU
8v∕
$H ea:b5 B!7e2:  	`@QB ,!P!B2nD"$Awa䗇+aa9! FQ@@Bcjc	" 4!b@S3EBu[C'
`_%A~	E( PDf#C.eaA
\B)C.B@#@a`Z
B3P@ "9E'aA3" %B	A0 ON)|)C%)/!#a<Xv C8 a#@=-b//Z!<"b=!jd'HO4II
V  dE /h Oc-)#&!d@L AOPO5!"_¾ %# L c H{0	¹,X`:A"u"Aܱ!~O6Fa		Ba*e^b~
·d} el! ZD_!2 "f#!_ᓡbt
ȃeCch'
NDzN #Dh@AzHbb Yč Q)boY\ c8aAaB}@! a:`doA(abH!sC ¹zoP!a!@e	a}G b`a`( "Kya㎁ᴿBo!ɡ$瀓	_PHɷk"C{!ɬ#Wlp`T"{ ? @ɶ!a} |rx
i A@@
aC=A|)Ţa @wĦɩi
d
&_Ϡб hI۠b塣-[ A 
bUi'&`0	 ǡ$Lѡ@
@Gj@@@2aJ"U    OND\!db           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
QhE) Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &<&E  ظ@ P ^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PAƽ.TAA_fXOAu.UA.TA讽_f.PApqKKKJ	JCK9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH Bh]uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jr赳r TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  hs* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x    )  d D#` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7hзt-u$ظP hh Lr 	uI[XC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP Γ	ruX0rPhBfP f_"wC 
 f.|!VQ?6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˯0   # q	Vt a*u' 4,4 u.{>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`ߠB* >(6.>0A6f.R6D.VffX QZ ?f / 
uf.R>r>^)1 ۹ p Z P3_r# v U z Ѐ~!f%#6 .,.>>66
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP跿
.QX`0fZt
0T <f%'f
  TPV!	.Q~

.
.o.GPWS} ^ 0ʂ MSZ.&ZQ<tQ .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#R~AKf6Of3ffSkAr3$tA^`.u	DVQ
6d dTt	6݇U  } 4
tY{).V0#g&;B*7R'Z=u EVW>ˆb& _^FVW +ߡ>Pdr6>_^HPxš pfLfVfWw>64 /t 3 f1ž@
G` 
t O
ɟtwQ	= ? ¿ 68) <R se>uf_f RfYp/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|uYXP E   F>@
> U u
lr3- w|HroQO
8rK<?rDuqr)ߋW.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVր? t  %u
?3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
ê<fw<ar,W<Fw<A 7ÿ<9w<0`00AQ1f3aB3w-.-B6/mA)A/"G2-YE.p"PG>qBHmr
x6ta >|.s<u=0> <u 鿅 <u0Pvro).a>PNހssDQ w?QB>d@
 Q0s??^P2>B蛓SYѓJހJg&IM 9}qWGJ@6TMr,	fNfOf_Ag&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfGɷ
>A_ r,f B2mWT)bd@ r@f؀ffFgfd# 
 .႐S3?a `t
܃ߠ݌ffVpv xv"  u߸ $P.$qQnfU.E.9߂..F .:0G;5A1>5ŋf 瀿 t265 uuuf0=/R@#f]anQn90Po:P;651.=Q[ fDJR RQ T
T

ޠ _Z Z\$
０fX Z"Sf3[ffÊ$P  ffff%$p߻'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$_$0AD?O2撍6mҘҘӯPE@> wQ1Q ػ7f?tuPRP ү ntJfp˂a T WFOPtO@X >TYßYfPQUGPF >J~Mu
,2 6  POX]0qUf ]Qσ0ŀ@Gbؾff&f&  G>̀ fG`GQaQ6VfWf>҈!_f!Q С ffD4$fOЬV 6ҧfP ȡ r ஀hYr$Ph5 X[õ ޥ3@$<sA|Yr.ˠUrO ` ԣA (tD_rq XPנ"Q!f0ѣ!EnS  gf /u}
> up[P}& / cB`&Xq!g= Bxxw ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C.ߋ.+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+ s q6pߚpt+p+wp
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;0t
|u. >
эf3EG.Љ.fEfGЈE
G
.f$ r-/t   @ -@.Ѐ tP-=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCysq?s6 &- + aGp Ѓ}p	, 5' #  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6Ї߹
 `F
Æ  fPf$FfX{    E	@ k fQffD$ 蟀us+ؠ% si}
uF7D4/ E}t#uS uN-fD'_  620( iQu K
߀u#*
f	rg
1g
 u,	 1q/s, fXfp5 Qߐs`psY+5 < 7 诌bga5rq_ie@ aȋna8s"s1fEp[!`D1S
Æ	!fo+B>sQ@"*#%>dޠD@@@_RS`rfe  #wbV+?^	sFON+R!%
!p	D
9MRu
HaI= I7<&!y5 6^w<us
(N3AaNs@OA
}NaG Q5Q5Q"3"+ɶ8Qs
1߷D1 F$)-R&d
*fs.:a	qmncVt@wf%$ ,r
'.`.qFbb$)7+P1wPH_+KgD5VF`^q65PKAj5FF<^P9d~)w76P9NH; ސnV@{Ai8sR176sAYN1*B<p fgF^Ë ttt%EEw)|CP{u
s
>`uF@F2	E rTEDDd%=upb5AIaR-df$0	К?(=(t@q	
v+Ұ=u{ruQ2$G7rStY~0< :	("rUY!
R"pYo+C J g'S ÈZw"b#SN1Ns`_|0^ eVfedwc'DA+dS 
pedeb41>"
S~0 : #`ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPB6X
lTA tUA  @tjAD   + *2+*4+*8+f[5c|- sMȁy@u@føtsPørcp d
q t ?P~a slc#fEst a_1`6`%["	
Kѧ]&rb諻pBb
Fbx+si ` d` p p P" }߃߉ߏߕߘߛߞ诡 uAcA s@E
WV6g4Fg^_rg t 	p!	
  	M
fword db q tbyte %*/|" Q ptr ޳ WV.t"Ü6@:s6J,6K&ps#!0RO_f^f˕ fXPBXP $0<9~F-ab !Ò  s뿴+z   1$  }s뀐e+s-!sf    ֐ `@  c    /  e d  ( _   $  ' .( , w/ 0 y4 $7 $/8 < 4? 		 @ 
 HK  P0dX ` Wa ~ b  f@ c &n h  i +>` l 0!wm 5 n 9eo ?p Drq G r Kes Nt Ru Uuv Y%w ]x `y c5z g{ j| nE} q~; u	 yS
8&&#8c ` f  (0 8  |UA     ! ڰ 	   g 10'8 0 % 2  , '  wQ+ e #,   u )  9װ   Uڒ3;    4w  w u w ص ew 
 5 x\
8 q/ m f  ( 8c  ˾rð T {s   8؃1 /9 %˰ t #rFͲ b8 '5 ,$+ 1 ,
,
 
b


r
QL 7we? ;  ?s*F DD? K  Qe V  [Z ^  (I~#  b I )`$ B`  f k qu v%; z87rް ~ v  f(+[08s0ZݓU  ! ݛ! e" ]# 0^D8 c b8(be0٣@9 s  (,	 ;u utn ,    e q/ ' 	 % `d$ T  re  ҕ E ܐj	 ݵ  e @ 2A 8 B ?eC ED LE RuF Y%G `H fI l5J sK yL EM N 	O T
8 ܁8(ݶ 0f8Te e  " y5 y I yd y y yt y$$ y y y4I y y yD y y	 yT
3 u$1 ݸ%%2 %0 ̄&8 9   e  	  e   u $% * / 55 : @ FC   {   rڲ ! $e  ȥ5 K9 O 8SuX% ]0b5 gv k&p u mzv& (ɧЍ󽱻  mfv&겶빆6m͖Fަ	V
f
 f&v.&5:?uGL RfX^	eU
G~r|lBp udz y8 ~nsf( 0f{87Р `o誴 7w 50 8(l88u  ƶ (˶f08t
nܶ {؅s8I $ $`$80 $ 0&  e$
 0 00=8  `8 ˶  5=!  MUadd push pop or adc sbb and daa wsub s x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ b?e ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff sa lQ 0ss stos lod cP
bbb b r{ol@ r rc ?cr shl@  a@et`eWnte"f`tA wo iave`}md xla@oop q c xzQ jlockpnea e hltPc t ne div iQ cltc i
i d@d"xzx lf*0gpsPl@`hrd bsf^@ r bt0 sp  c i x!seP 0 P b Azbb p"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxfldM1Q l2q e1[piBg2nr z f2xmyl2x fptan` as rexOtrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cl-ein+fQTf /es]c
env
cst   fre@0Q /rX(AfbibC

; ?	A	 r=fi2a ( wobinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-wrdp 4rdt`rsm ud2 wrxO .  f  yz` {|F}.sx33	t.d{G
U.
wEwaF,(-)*d.V)PS w[XF譾e$U<v$tU	&}$!!uw'E t$$$I4轊"$wQ('z,fU$-

E%$0c<5r1{<" t3{"$v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=F&_<JF8L?Nt!@PE,S<$VuBX{U&[UD]` 20cf1i*l
nޕ+q#*vu
UJxwL%{E{}G/'0軠#dPPOOQIϐ$TT<(YUW~eCC_'IC<U&@'{tN^86tH`&@  6 f3 t3Vv^

ѷSQW.8
F  1 [Fn6Ff.0.>0QHY.&f.>R[  t8svpJ $GߘG _Y[PQ.> t7xFYX78eF PNSr [!Hz %NYa FJw2 uQFKEMe	$ <t<t<uAE* m"ME' ;蜡  XEfPQfRf33JFfZYfXStï[OAmBC`DP ҀQPҁR҂S҃AmBC DpgPOP R S c?[ QSWP..X. u<u	L <r<w,@.`<  .>
  <  <;u.
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&R<[pOp?uu18xf;t'uG2p .0
_	   h=) ? h6ȎЍȋh3 {  ௎  R   O O           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y   i 0 0j Uhp``ϋ;@:Wff > hp
 DϊfPff
fр aVWߤA+S@)'WŢpr;_t[s(`(F['_^aWf` f vru߀p6fffGfY܂h R1Xfߊ$
(ffw ~A	S22*{OPr'!$߿ 
 uf 8s֊ҊʠXQ;RP
t0^-r#XPX  uf a/uSf{UPfPfXZ+ ]f0)ff]rff~m`e#n z= osrsc:B
Cb_ 1f^ |w @t; *f驀@Ikow  B)ђuU6ѩȢ+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu Fߊ1KMuY ^Ys]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N O蛂P}QA` XPhWUQ^PԀ3ʡ A1sд 謱 ]dXÀ}-p΋_P^Z`Wᐊ f} mp_;p0                                                                            - ' +?Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.ANZr#MYu 6Mrgpt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF qô蛇	 -q`	 ӥ/2	r蟥@e		p脀'^F&?s  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0GE]EabgVfQSjf׋[G!fY^f& u#GWf  2WrXP'F#~r .>*t7  /{r?`. t8 * t t  2SrV ʀs`,IN	p AN~wt$` t u/~߉~ %"NV v1	s^Í6O.|uLu..EN`>M .:UtaINaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? tl>ـ?r.u|
_ Ѐ ʋ.E~;v j'fVfv@dD @؊fA
@NP.eXfa P	rs$
2

{	fX!^9
dD0f`v]f^PR_B@    RPXuUW:>_]s*r  ౟$<P0r!P@Xup>{q @<@`P  osXXty>c -Q	F?Q	 QV  PRPW> P߸@   XFrr#r^rT:rOt :DvL*D f umfm3
u
rl
u2 VWrd [_^ q QP&:Ev&wM!&*E9TaVBoCo0<@,rFAnr;A?@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  uﴻ2&fPS `00mvPSpsNp D
>X{`?D<OƋ4a`t~ a1t!$!";q1&0&PQȎؠRJ;r# SMwO "t 
`P2:Tt
 YXÀuOuQ,9a"   <s& ? `P93  >O}uǀ   qNt| aNQNVW_<uW<
uu*F; ><@g2<t.$S[M[|u|
pf|`it\_^FS`}
;u}	 !.MNP>܀}@a`puD}aǨ #%D0QV 3߬+^YD$fރf}ff?ffJf\c
bPZ#f F PXMfP~Đ=r0&pw)pEfu fu }Cu~s3SV|wt` t t
^[PfQ
 0 < @f	t
` vnPa f`ff`f@ذ%$P~f  pqHff#f+ִ f;wfg 3g&Sg&c
uff+fՅX撝faf6SRN=>$pfPxqffX0ORBZruAZr
gQ2ǜpXZ[UtQx r.]31 nn    M!蜌r.f%af UCEShsffr 3{ P1f!u%f#f   t	sLr`t s` u `~aff#ffа۹,Pkr,f8fVfSfRQ<t2f3Cr6
+讋f `1u g> tt or(2p(_ u2,Yp[f^U=@kfR53tt
'Љr$޲flp/8-t(r!f1ut7
J=?t:R!4g&? t09cֈQfR8t , t~
@u$2n(Hp)w@t'@u'-*tp(t
 /}!-  t> fAu2BfY?f[ a33q 
t@ 菇 t}qHXri/p/B/RZ/rGU/Z3tt@I$
Ê I,I$t P7IZ
Q! 0fF3YS0bIiIxI  11CI$JI_YI2$I+I:I@ 

I	  ˇ SS4fXނش  OSQWfV~W   _ W<5t^ufaXrf^_Y[rDQRV3>P'û FoKt
` J8u}^ZY`mf2  QHs# @w>  u$u uFuu1u v0tlЎp~D@tPf_f^p~2 *  h                                                                  < S7 A  -  O IFYOO L\vP)F X .$	qf&(q (&(&(Uf") ~и(zpf f).)pp >a 6( a   (.P (f.U""""U" ! a
#
 
 f3ۻ$gf+(С a]3O3O++++++  +P,y,+,--)-T-a .i/./W..:*tL u% *t>JrSO.[t O.[u  *t*t_M_DEfUv"v t Ar Mw Ŵ*.V PXF
Xf]h@ &A ϴaxj@!
oðnr`\0rVĂ
	=ViO**#p *.t.I.
Lj@s& { |0u ^#؁D.d.$P@	ã3j0rcOt` 	OtOtLtD3Ot
QOtEOt?Os

1*u	<.<>.}h $ BUu	U@qR#G rp
fL\OZ[ fP<r|wfD@u
  f@QVWUuP؎&Br& ȎXiO*,3O>O* .>ϡ*@^u *Pa 3PB &Gݾ&G $ $PC &I`(US`*B>0J&g0&G1&O2$ 2&GAX]_^&?sa s@ \`b 
 *f&G E  A*ff@1 @SRWP9޲ ]raZ^*EALuRE<sfQ@M}3  fYr/>OO.EGQ Ͼ./17[ÜȾ_Z[QW.>*u4tG<tF~=虾.EP .&O>M@A%50i @Ɏ6O SRt5ێۋ@S.q&G^Od_f&_ - Y2Z[fUfBSsQS=f]Ê$W1 _߅T8 R 
yjt)Ӏut&  5& A)Gu& Ÿ
u! À8W@" UAU} RtY pvMuG	l0bu< u3uOQtru}1 ta0W> S:u@萰8*6R:EFu :E0 } jQtTt̀t߀EtH{71 F )t%> t:& tSuEAu@3O  t E>I q u	PXuP3 t?褯X랓tS%y>E utPuU0#)	&2!q =E3$*x3;r.Dv+W+Xu432#*u!.ð-s*1!	 2Ǯ<Gr<Svƀ 4,G.^#]C%J u$
<.r!Lu24$`.a2K#/"rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EBQ C D P@SI Q S CS= UD@ E S I1xception 4 - Overflow!5Bounds _Check6@Invalid Opcode7 Device Not AvailablJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12>Atack V
3General otecEOrrorq  1 =  System Ha!P'
 t
-XÜPR'< tZ fVfR64Fup4/vz4_pcP4Yύ6j4{o4tfÍ6t4j 6y4`fX/~4T ō64J`64A0Ǎ647XY_WQP64$Q4}Q4p4
6465F
05t85_]&V5xr5na5WJ`5o@eb	[YQ G; 1`(0kX[S	 65 p C8BBaa`a$at@0  FfFɷ͋N
~fE F Nu3 }'ȷn ]
`RQP~
XÊ /FFYNZߊ1ۊA`QȴjY`Њ  aً m9"ԃ z9 & G9 .&Z8ߐ'@'dQR Z
  c Z@ 
XYZð
< 
7 R  Zˁ r  `؋   9%_  %Q!
  	`u0ua@  `
UЋa ]_a	@]3G
AF `PC0[oq$9` $<u 3 0ؾ   fa3S f]Q VQ=3AUAY^` 
aËf3RQ3ɋff tf
f3fRAыf;v+R'TYX0P@YP\UfWf&и`1fWI]&f_ff_]p_8f <  ~<~ u<@ l<c<`%Z<	;Q<
QH<i?<6<
0-Pk=0 <<<pXpL]WfPCI 2ou_PRVWfSt$ѻ"r   f;`tN紃 f[_^fZfYff r_ }  {u
N`ݬoҩ  ~̩ P r 2fSRfPȝfXZf[ff\nFO5	0vf s"s t s t QVW&=p s fPf&EffXГ 3V _^YaJVWPw`;t
X2 *W 
_ߺ ϰ#tqUX _^1ONp sP6qуufQ fPfgsf8 P8s2fYZf`ffWgfǃ  #Eg  ݀ܺA@vT2 gfgƃ0 g u	f@w1  f@f@f_gf1 gffgf0	a	fQ@;gg&fGfXf7E;wf+f@F+f7gHggfb	f0I#fgf&fa\
t@@P	u3
Ly
ff0
Wgf3  P
@r@
A
@  gfߥ3fSn̓ wff#b ffyZ?'wf3f30n,;w+#4ܼbf[gfѾ p2
ffP	c	

f'AAXAP
 #W!fكs À +SfVQp g46fFC3YQ  Y`@.f^\ g&{GCffTk[(u< uEuPPu`HuZBPPE EPP runtime BI{OSVers.1  
 BC C=CCCC$DIDsDDDDDDDDD3EwU .B]B.\.\ r VR.\
ZpQRPt<rt2[5$ԁ !Ȁ
 o -" ZQ`$ U p[		u"	 xuORt]W SUUOU.V)f	`_&n ^C O CW	al\Z u@ ߆W U PSRBt<r
 j ?GАr
t<t ).>2E Ҩ.2E\ 
   PQR3쨀uAB$ԡ 3ZYXPS&"
ǐ%&[1QȠ$~aܐ&Y`)uWt= (u 
f&e&f&e&20 }&&ۜa VR(txSR ڊZ[  Z[K@u?{rȠt%p0p0
udF9Z^`/(u=pu8>qBp4
ً@p 2
 0UR'u<pu7Gt0)Û輛tڱ
@;Z]PGbXU 
~ s ]?`K:KxS|0YޠM M>rQ4Ys\ P& 3Z[x0"$`"<P3
ݸH 觚ٸG G蟚S QyLIQK zS
 pN `qM X$ec'
(<PdHITIIIIJjJP&` XW<or .H_Swt 
' t @r
2[e pnu0^r!<i	rr&P PQs" r2.H2& r $s  r  9q	8 r 	&& rr	ô0Ss+&' @>'  sa$esQ
u>[ W r%p$S r rq	A9 f" ?$ pQ@	Pm 营Xa\#t sq]@tNadߨtbpt t
@u0Yp`
 -Xr`QPPPtVNXdYQPEN0 tg	` QXd$!<!tNN_N  q&@tPGpB`+ (`<u
 @&   >!@tA AuqP @  , & XV߁  0`O  r
 P<Fu us	} 	uA
 fu	 X RtGTtu`6FtEuUrPRtK?xGr t& 0R] Z&Duh7 [ h 
Xuh09rX&  U au@ ϡ*t@Q!	 r]r
.rr dP d@y $& 8t   `{QX uSQ^ `b+KH `*C: E8011ߗ @@X@3@*KC*Y{   0 " p	C  plFpoypOIEMAG  IZ P    	{
  `# HDA-L  wHDBs A-E r Cu 0USB-[FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M N` ;c!OFO@	 O N ?NCD001EL TORITO SPECIFICATION QPPP " * Gxx  x y 1 " s*
x"x 0_   s w_X _y\[8y y P\&b é uT EtذE
Uj ʡ`t
r0 t
rwð%Àxf`!i2tW &  d_&E3aB&U
&]@ &EL t ûQu}0&E@ !02<$PnP!Q Q Q  = "fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdAgf_f^fZfYfXf[f]ge333rVd4Ad^;sgu` 
3 s M tAt<VrdDg}
^` VWq^gEdTg}
A}gEm `tr	 	t}d8 W<yt@DM
`PfUf]3
t `$u Ó' Ag.;Gt ._
u fg6$+' +k@! `JB C STTTTSSg]蒚Q tQ3Qwv ]Q
mS- u|SIQ ;   SQ>Qu5{ô@4% /r!<3  3 3Y[à%SRVߙ&QXP"tt#ߓ Ҫ> Q<tƝ< t3^Z )XZV  ' u P	oir
- )ZRQQ߸ =`c
uQQQ2Ã.qNR   `31$:Uu &?t+aÍ>QN.}
tp 	
t>M .:U+	 V tMRZ|p  u$$<t} t	^^Q | Y03Ѐ u*Vh O| ^t
 Luzau
cs)t!RBu3ێێZ
t	u
u
 uP@s+XPz\ 9ڰ`zXð7U uPaXd]<tM r
tMd8D^uAPSQRWuh"hs T^ua_ZY[X`|P&
yt,ـt&M1&G&a螖`_LAAAsa+Íu 2Nȃt
 Q ܈$FKuð?WQN
u	ۍY;Y_uS؀u sAu)6w4  B  A3dߊ$f
Pfw 0DRWS22f0pYrZ u 8s܊[_Z AfQWRfP
t)`=r ff  uPF 8ufXZ_fYP`N r #Q3r: mt+ab4 v Q
tf8t	
uY0	g&;t4g&Ct,g&Cf4a}<vfA{٠e
g&:#0{C1	{Wz޴r7fg&F 	f`r!f`Gag&O@` Nb O ܱ }_f[hKt'} ߈<u 2䈻h#h:询M1qqswGs|]tbs
2 AQ"  |  {߀P.D`.D
pV~ ```ZZ&&D aø0 м ` j 'U&&E  3Լ{~1
QPTJP !XY`.\.T	ώǍ>Q.L` `a.D`aQPƌМ@XXɎ6aWWWWA z@ "0$qU-PRۿG      *[%	  ` `Gd dp",  qa aO 
p p  Gr rrs qsq]
sQ"  
 6r		 

  ` u # $t$?a\h@ & r 3u".\#3\' s u`LذI<u	.\ u<В @t$\   Ptu _u	V $
4 qf cSV @ t7`P:<uݳR[SUNNN_O Oطlߴ$#ܱjc#jU fJ$MON"ýfdâf>`uf   > t&r_Vu`_ ̐@of+0_Qf׸@bYrfǳ]A$XV>uIf` s@e_
f6ǁ0 utrr<> SWA\!XU`_`_  M pG " *;0ʙ0aq|6 A~pbcuUr]}  Uu"O]ÃJRQ%ߊ̺ bY U  TPakU `  (<sW .`_.0"2a`PXs⾴Qu..&߶+.	p@ t^PP.&u @ u42..뤶` wPUU*P*Ч&u XY`-3P A3.G@
XԙPk *.rWȎ?9_ >bObwbbbbbbbbbbbbbVS3Х.:au.a_K`@[^* UFP<b2SFPS.bF[C`N[QF ?t
bsF2~ tY@ ø7 `  _ ø8g @d9`dtu6A``0W6 3`I6$ $ccccc
d!d=d`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233p/cf>"  tq" P a2( Ҋp ) ǿȊ&)  * 븊* >+#1 d>,0.- &) gr..PR ut;60n6 6 3
t,=

"=
 
0I5w<t<u FÀ t< ` s
& 
<uaw\wWQu& ` uF4`!Av &
ØpY6 FF;t2fӿeeeSaa\"c` \0ba3ac]aR]D]Er]pj`[\!\\\
\+t\ dI|\Z[ ZZ g}
3gE
 t "6qND  [gu0EQsU I~2QN}N  
$dc&E
E   Fj	P>]>a
R  DR R S S VЭVQ    U	 Y
 V VVABCpP Q VS VT  U V WXYAZ[\1]^_  ^f` ifa fb gc 'gd!eqf 1\x\V\x[S[[[[nOwef_ SQfVF! :s^(2۹  `F  +^D_!8um3\f^iWVQCuKEb! !0"w $I^:u:\!u f:r:@Y[_S  [hQN.+pv@ CCo@[Љ0` !E{u @$
`&aqog`}]faRМetPX$t7K wȋ@Zޣ1a)G{ #$ PRZq$0<:rd u߆P P H  = r q& fV{0: gfF0XRyZÜtw	tpv
 vt[ ؎ Ѝȋhmj3  SQN<tt	fP!XfP BְY͆kQaEߴPڋj=aYQu rY<u,fCISGu%f» fﻲ  f   '.>j .jfPS P@f.IkkO[:.Ikf`|uhY [ h8  n|uhkaúB   $VÜ.IkuRVP
ۃx 拔 tcPtt>@ KXS~x$P|Xr$-Qu}!$
BB ,JJq4HX^ZY[Ͽp$ q#  3Ҵ./@32ƀnuo n Xp'uTf`0D fft;  Qf3Y,65 !п ө@`ð м  "FqG v</įr @t4t p`:I2撰ߒPɆt  w`A ZYJB4"<t$ AJBՄqpvB", _SYSID_  !n _UU  fUfP@CXZ+ f]fff]rPm0Kn WWWWa	  " ry fl f@f=  uf3p fl P3Ҏ¿x 頻ȫHZ @P :
                                                                                                                                                                                                                                                                                 
4    S    -%  ;n$$`fwyhAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6M  @ t	_3!
tr ^	
F (|r
 	u^'Ât %1+	d1*515r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0rw
sus>3O.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~?FPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 	.EF2	
r]wsms1I9  <$u2 *<#"< u<@v<%p!2 ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]yrQ[P@ [fZsSۣQtP^Ë^6cO~jAؠrf;	DE"d~(LuTMs fPf}3fXr1>OO.  .GTǿQ i./pPi3V#:Ttt<~'t9r0iQEE߀&Oq<D_D@ % 5v^i$~6O 6u0fPfS&Mf.Of&]f&_} 
[!
0'Qf  蘒r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^Y@tffm_ruLr Yr)8r$cr皑r"Va	)rj!P_TPQX rpw
u `fSfRWBt:?f.EffffAUffsP-EMF F
tSuNff3fifVOf.WP*f8f'w*f'F'*2t*܊f
Vvf߈Vv 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюً go^ZYpB`SQRX0% [F mo `7h. sďQ(&Q Z^N=rot
r`a r[v">cO fKfa`, 3S5<s-OO8L9
t" >iOߊG<P#w<Q$@ ~d-OZY[PQX hv ߇  t`rzru3rij`wNurWu
p`dع 
 Lr.Ǵt%ttt t	tCHa% su~藎r	 2PRZF sH<t<)t<(u;ь>A u/WU>)`]_34r0蓎Cyq`_^a'c`&PSR 2?Z[)ÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8ؿvNC^~nNfnNfˈNnfNn"~*Ċ^
^mQEfYSQKfPv j 8rC8sfZRfXfP8߈FfCF VvuK{QfXr+tðP@P3 Gp1 tff   Rf+IYÀ{L@#,u$`Ύk2Ot
.*;芆^G fF! PXG t<"u<"tlV3޾x 4|Q&߃?s0  s& p  &_G` ` wG`t&O &O`uRp`f&GG`Pa  5AWQb ]b  Wsa,ZX7RQVW:W qtNᒀuu .!6a u/AŠ ?L	
ǀ t,6pNoAOGA&&d&D&t&?D3p;_^YXVQ
} " uRPO
  ^nش`S`[PS3`[
мZ`!]`X`aesɄ3ɺTrA
!Z.63tk  \XfPAMSUjVW  Ў  j  u
  
  t 	˻ʆ rrp[ɍv5F0]& O0^
 30&OzFU"nj_]v
` и_^0jw 1
ޟAp  MB RW 
$ D -&= g&FGvuv p c hu#' ǖ &` 
߃;hu7a]f3ɐ ԁPkuB& 30_Z~GF< u  u2D@Ȑ1sN~ t
SH	[ôfQWph f'f8h   `  f  H  $p`| f_l f
,ā rMf[0#t5f 0Pf}% ;tf ff  @`fXQ_TRfxpffú ,5Z`PXfZcc``d f9@u

f<~OfaĲQ Ref%N0

 aDpgB_zB3E@j19An`f ftC" QBY ffhf{aÁqfa{ˁZӿ @j3ffGtf 퐳OuAmWry!?tUp ?Q0g>c>rQ>L G B = 8 3 . ) $     0/﷉_Q1&G t'J$ǹSWfQ0 Ȫ f4 谪ftYfY_[d JfYe``2 M跦 QDf6棍fP Cf$6	 5PqgsfX A 7{ffaCa$PIR    A&b` a b c aD dPe  i 0 i0j hp`3נW 
p
d_ϊͻ
p aVWГS;t`t[]
Dy[]0RW3`Q觨u0,@GYMQ</$_Z|V.  3ۍ6.w^rHP  SIMPLOiMOTOROLABuVPjVS  ~uHɇh@m0tw > 2>7ې P7 ɐ7ɰ7@06S pgv-&Z[>k8 98 j t
@+سÒcɰ;P@	?G	ZP?>`
ɐ?5
k?, ?#3lPqߊM<S0Mt6W0 
6E^V&.?Oʤi*> w Zn ʀMe@K\^>ʐN;kN2ʐN%' 0`Q>
T Z U @UڰkʀU@&T&ʿ&ʳ+ 
R> ~X^ A Pk?Xðo  s1Tp @PE`Ю j01R ֤pCӀ ˎۍq:ufW	rf+aSfW.ܘuOV.f g&$fDP@W? 2ۨu<@tĀutoP?ܘaY
˸_ f_[Q
! YQ 8  ` PRS%` +ð ;w[`]m SRW*׿OзIr 2 3_ZwRWQ,ԴAs Y r3O:p! RQWSP b	$쐧X Q쨀tYfl !`@ sX Jt	uRX( V_ mi`q7	XAP)[_YZÃU2<UuX
8
DYJBBƃ   brT
!u`P  M2
fW	 򿠶 0g *ê`gVWQP Dt!WQ:t
Tu8v
Y_#Y_XYs _SM_ P_DMI_   #9P  2XPUv F t	F !Ff ]X"X
W8 #@" i &g +  pa 
u
f_N@  ]ϰ2ðq  S\8&_&G pGGP    [ !@   栊W@@\&׍\p F0 ]
 ..c3 и( -  2P
C@@ XWP$<w3t u*p O $F& ._@Pޠ X2$31     VR -۳4q!AufQ?8fYgW[ <Ȏ3]Ou q 2fPS=Au@;Áp u39 u+ f?wufP@u BXu
_ff < t%b{At{N|S{_ k@Q  ~{n{텑 oo{KǠ !qO@H{¼P A{`{Q   Ak{oIRfW.}umf3hff=SCAFtViG t"ffff Wuf/(#01tfPfK yfar_32_p9
` tODu ($
o׽`ѳ,{aYô%O´+E[_;`МBJt*5 u %$t0$< ȋf`~a
%D	$ռ %` +߼$pr<
%	*P' @-TO xOy er$DIsL MT[p.øJfUfQ ufVKrMu gf@ Nm V F`҃u(gfF!fffMufY2f^@]Ë<RR+fQSfVffLfT6DfLf^[fYr Xt	A3PXføMøNp OfSQfV0/UfWfPEt3  fRfZ] *_f])^0~PfW˱ceEtQ!IUPXY f1l P YXt
 t$-Et t! v nkˠ1X(RfV8Mt Z| 'M(
:2V{f!nLw#t 0r{ $r	 @|f^ðU; QWVwy^_Y3
ÊS  e =}  t F0fV1fffa@>.6fff;w	rf;w1AZ.- An"  ?umf%3Yӎ/aBRǨ@u$1> >ذ1Po0= <rqph3ۿf@ Pl
ffʝ @ffQf- laRW>D3&G;?r_Z  <%<t  S E t	tpQ  fA  d   $ԡfYX4Z?4f4f `,@h0hg&>tq r 	r
  u f_sbA^f$fߺ tt,$
g&"Fg&
FI*$
g&#Fg&FJ	fj#F	 kPfa
`VR	t#1
t.
t9tt]t&]&Uu2
~	tw
t11tFwt`
t~n
g&@
qp
 
u
g& 
T|py B~3Rfn\&^q\QUÃ3ɍ6qN.L.:Ls&pUPF.D HF.LIFs` 2`r2WY 2aPQ u K렠?^t
pW3t 3t
u! è3ұPUu s t>O.| .O _u}߄ P ߴJ}uLu  e3puv`bW_otURQRUp@K2YZ6	u>^
蒿 .D P@+ t#VDLD^ 
D.LD ]Å Q!V | Ys.u`'	 t	&Uu" Ǎ>Q |  Êö.f.|fF  C.|CQ\PQW 3ۍaN _Hati
/g uRWf;rf`퀐vs'P1 }u : t-Aw(@tD<u u P %faUQ	U F @ E][__
<t~~`Y]p4ã1PQRbfv2  ^~SRɓ	sr`	x tt -  P	  iq09`K#rk=s  "#@@b@n 
`Nff3u
P!  f3gfF!ds"4yP@pff6^03&.fPQXYqS)YaP'уЎ@ 98 #	f<t`  u#f|$!AP}p]faá@䠄t"
桰   u$! !tp &k Xa{{ݯށ *q밻ݰ J
s@P0]FF
]X `j . j v
)Mf.N. 3tI4~r@5p3؊^)!a]uw t&Du .⭋^^;SIa.@t&ڃ`ԣ.^2uȎ0S6t6^2~Q. @ PSFg
t'.:ptX._`P"
Xu!P1<Xu @P
ta`
  P?3@C3aP2Xr-s(@r3H r rR VvF\r:Gs5&DC Hrfy苡_FÉF(t S^$}:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠQ&DB êĪǪoЫAT0	VcH UrpUsʁ `-su fqt
E$՗Eab&G)
V ۀNh8Kr>u rG Po3F) r\ {r=H r8QWsUs#

Rr
3 s@M1 |ۗ#kп##F("r#Qlr@rk20!0p ×!r"!F( Q'&dK0#V&Ơf)&t N.QSWfu/ r)v{!ufPs ȊfXt_[Y`<t;@3fÐ t	f 觊u
utǳf@Iff[`
 3|a  <	PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&Ѐ E 6F (@$3'E&f$`
ĢF f%R$P[G ;B(FGq1ø fF" PXۋN8NwN 4o2N0(`00s/ ml臽B
 r
fQmru$贀fY/_/++U+Ñ &u b%trq? VQB  BY^	G $s
3
P&u3` @
r
%uètàt <q66V&TЕup 
* &u^Ǵ  M  *QPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<Px7   @衆TPQƶـRPQM+XZP <u
XPSQRs3ɺ蒶@qZ}YP. `b6.c6afV`f
u}ʃ	rqoBr" s0_  ` 	˱af^3`@*߃2ϊ$?ԉNTw@~WF$
&FG &OU_j
ӓW   t2밎_R Z؀ˀ$0ZT`  t
op    %`  wVf`< T ,333ۺI uF;|D ݰ߀u	66uu%0#{	ҥ	o
`
	^"&S$ 2[ø 2 
r$<ù ؎f(f0d f+0ff,W.b 8 !7R  '  迳). 踂ɀ\ef5f.4 ffffE                                  0ؾ />&   A6׺a ŀ260VfPfSRRFf3۰S宊"fV$
Ѐ
ğtf `T誮"T蒮蟡P1PffZf[fXЮfQfWfV f  g&?tgf&G=PffкfEf   L	g&GR u#f^f_fY22p n Wl C  Ơ # ҭ˭Ȱĭ轭2Ҩtð
训,詭袭蛭po$z1ønw^аW	P2Is s	2F | 70 )	 "
{22 	ÀPN :4㬰
ά$ 
լ0 B$2
}ؾKοpnWVo.GF< u^_׺@'rD._\3aRǊAZ[` Ȋ̱cQRRByń]"zd^	{ZYolRÁ8AS؀u
RRp[P P2XE%
cE%	X'< $DT
50
$Sq"~Sr
t`QWt_wZwU
uQ6rEt>pr2
tC rͲ  r6
p~6 P _A22
u[rVei1sCr"trS '~;Wr6"Q@
Er GS֝@Te  
 @     tK\	\p*P')0\;#$ rIW(#  k_j!@7(B O5B< t%՟0@@r4;3/r!- ,-BP5Ϳ@D`ȳʠDGADw*VR`ރ| 拴  t.Z^8ħP .;BBBX$JJ2J¿BpLPܰ t
"tJ "Xu)` r V tA&q JZ  C@A u*uP= ]Xruŀ̀0	wɃ
 C" (8SQ2<

2ۆ.
$2rvqdϏ<w00@ð  ` 0      jǏ@ q @ F0 vP  b .& T@ z 	  @ Q Q d u @ 
 G @ : V    	=QHewlett-Packard 68DTD Ver. F.03 02/25/2005 m]  Z  lo ~@Aq oKBC
sion XX.XX  
 /
  _ ܺ	o~A# ū @  AP0  JP12 Intel(R)     rnal L1 Cachea _bi2e	
   6PC CARD-Slot 0  
 8>	 www.hp.com  w
 p    
> 

к
  q DIMM #q182H"
~"RVpr 9 ȅ"K @m,No baut y7+"8
/_tSWQ v8stуY_УW Pܡ ա"Ĩ@t в
 ް  XPJXSP t+. s#. sXP虡&   &X[fWt+ @ǿ>=$`&}F̑ 1!0Pu:
rrw`Ua `WB a p 0`cX`SQVf۸f@fa!UpF
PP7G .^Y?[u(P%RFP f&| ^	u<Vf!)Bo W uRpLP	r=^=uS@]#^[wАu"
 Y ^~u.t Uj@w`V	_L
 B8`.
u&* ` uaf_SV ! &=Ut<f MPTh [ &Ep` `&ufރf&&   \ YSUh &]S^ ][#&uD0D!@V& fȡAL
^rUfWދ@VЎ &1Df`t@ 2fʃGq^0 P P&t_ 'fys'+a¡f;MEg   
1rW_f.	Zg&G_E!#3crR-uf&T
f.qf_utf{` ]StQqY fro1pfp,  !f;p#3 ,rӹ;Q>!p$U
UEG &E"rkfaɽÑ 'rnOGw|P_@10W` " %؎`1#0 @2K<t+fQ Y<%z
fuސ f` ҁ` p?tڋY.6.WM"fxNf.gO
7 -	"E"	#:P9DrQ9 9:
q;.9r]()u)D>(uf.op 	rr=b*VQR$$D
 V&Ta<^3Csry9
lY^BG0 ~50.m80"B1Ev fs7f(AoDs(d8PsVWPWN TPDP E2LDra
fMt^QؾsJWAM ;?f: vM^_OTrNe?:;lffWfQ@Q4T=EM
e ULLl@BLR G_^WXV:XXFPW)G@k(WPcWVVn	P&O	3
5O`f$Op%UOaaoؾ:!P	Qbk`#SSjp(SQ@q	)Ufhf`ejm_W3nٰ  {Dku_1nhQfhhVhphgpmNS`rpPj	Yj|~t= lYi,`{A
1$pf[iPQR BȣuZYJ֣ן% B qץ@׿URfQ v ufufQ2=fA<t1 @Q !ϱ n r.V sfYZ]PT߆f;fRff;fZ`Wf!rfMrf+0zZr
r#|s
wua

<)fGM	rirB!PXPrO Pp$Ss[O֫BMIgEc{/J˼OQP oFfP~oXEɿt ft/+f##fSff3< tfF12"ZfYA0ѦUat?$7 3#tcQ!0
ð-@ḃľ!WV@ fSP~WB QKY_W
t^9lJst6]V! <5u G	F^B^= `s.
<5 = 
uI>rm !ϊXf[2PdX^2Y@!WfVft
P Er&w@ P?ȐB sճ  Ђô P+Xs #zD#a$Q$PD$P߰臑)
u $x SWpb_fD[t t
) R!aW
 v i$
Ǌk{ O H$ <$Ar&(7\%0 tS0	 ?Y{+ oQ3-3ð&{
tF!tt	*tEPIQBS&%"
ǆ,[: <t<!t
<	<*cR*aj`	`p
!PaZQR`s	8
ZY1` R<;VP֎vS<	 [rAtX2pJ^ ë!"@ r-`@ u tr
D@E2 r0O"3QN|
u|	 *t0  $<<q<
^q!"貎 ؊2% ɰ t؋ *ZP^u @EqYXðQQoVWP 
uNX_^YaQQN@^P2bV@ UB2|0ʁCqa
P'6#fp1}ðW"82	Rc7 B-S-ðT".ՠ Y<@Z<.sYk	U>Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRS| ?y(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Wu v5u t
&  `
x_t^t]t\߀7utF5R3< v
<ar5<{s1$PɎ Xu2Gôr2հѾr9_2.A ukq G$!u@t0<zw,  
tѦ
@
	t
w
 {b2]YSJ, E ?G@2q)Pı
 t"< t[r0r	
2vPQs	} U	jE9̶!HP  "PRuaa@uXXZXp! / WPXŻ PÜ= srs
0PSc{ _ ߸^ ZY[XSQwtb.hw ! !$?`OY[ ?u }PjQb;ˁPQN 3۸ K `޺W'  A G y   y " ËEu t
$rrs`tW  d_Hsa(    K P3Xú0fW%,  .s 8 0ff#ffg&'f  `Y Y_ fRffZX`st'<t#<tNPc  T M_ H<u 5  %l  ߽
 aS  :X#X[0&VW3xu@ G	u1@} W Y:!t%WVQ 1p Sa WX#OW^_S/S$	ppqu]WA H $tup'$r@  VD	0hNiE%F<|4G<GpGGmlr@02iWWWW%17   6  Go  "6! ,@;b Zf`g$/u (ev$
Cvô$9vOv/vfa0VМ8vt
+v$tº^Kf` u'= u$u $upu$ufaM$ufuﴀ@ ء S3ۻr?4{LJWX  fV@ﾐބu|<|t 3N@f6 V|u^ u|u{@N`R\ 	 ShO|tE |u{ u?{t!{vi
{ 
]_]f^eU  	 Љ    pV  G$ $  GN N P P  Gh h"Gt|1$    Z   
G   {$    0    %ar 4  = sf``QP SQ 2SY[$
TfFf 
tN8tSFt f% f @^ t0    "     t}	x fX
faRV s Z!
J
8
R0
$og4 Nff`4eA fu4fafFD fP2f> tfߋFP^DP s fu
fWzf{ 3#"fF"F(F,#0 f3srB޳rf-1fv,v0hfN,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր  0fYf#f#ff
0 fHfVPf#f@f+¿f;FLvLfFPf)FL%	fvAfI )5fBwf*fPff
fպ< 
Xf%	G,fA d!`
;Vt
fAP
Q
ĳ6"8  f%" f% з"	 "f'F0002KFR) !.3@; O=ffOf㏛䑐SӶ#t" vO
O?[ހpf  0x BO߀@蘯O %~OQ  
  5u
 @ @Ü]8Z  ;Pɩ1 
 F4;@H0P ߈>%S5 N0Mst(BR'^9EСDf@"sfl  0=  uAp fl >Tt@&?   Z_YfXϳ1=%T| u!uO ǿ<2{f]
 N] d `5dPQ3 27y4rdr
`~ r`W{ <ϰ4p!|3ð?4|   K SQuP $@Xu@AXe$Htu
2I4
<RVWK1.1Vtfa|`.c|qcQ<V V<W U   PautT `afP > f 6d2s >up?|K2_>fNJK|}Ajd8|O2|fk .> uS| &R"qul`a 茿؀ a@ u
_^Z2  QV_0\`ÌȎ>ƴ Dr@" [u@ !U3wr%[UkR  r.fZfY] a /  Bڃʒ_Fذ*@_BwK h~R	ܧЀ 	 0N:݂DݕjjHh}nM{۹dAn8 #	@ fW 3sA<0uf,u#p f3gf&ff=SCAF{2f_U< `
 <! F ]a  i<w&< t'V3ɊȈ[CF`S  ^  VV<v^.
t" ؋B Ur t ]dmU!P Xs.V Ou*]:n:n}B fr nn g :n"hqh"n_n nu:hn:n' %Qyr2!"S"v*N  x["2ɵ"YH .633ras\踽&D0
V &DtH G 
B Mr!0rusu˾F. u踽~$rO薿sJ0ʊKZ Sžr虿r
rBaFyoiZ2
 0
FFt ߋNЋfF" B]@ BF(	r2BB2ۀ~ p`{  t3ҸK3 ;wu;sbFVFF"F
`)tЎ r4F$
Ft+ WF P @!VPXV@"aWPR@zuڋ	ZX>PRAtZXá * 5Ӟ.:fdu`6.f] gu
#p dƉPfdfBdP*!ps dMd5g}d, J V1dP <d;]ttd|d]^  R 3
' ' _FǠ  F/3 .;v+GuBG
`F/ {@ Ë?% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFSۻ_[pS0^ۋ^&t` $ueG&uFwtt ]w(G?ϥ~~~~l|8 8| 8|8||  << p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>p<~~<pff f { >c8ll8x
~~p Q pp		 0``00$ff$
0xx00 0 lllҬll  l 0|x0f 8l8vv ``R0```0 @  <<f0{ 0  || 0p0  x8`̃ <l 8w`p  x@ |	pH `a
 
|x  ff|fcf ll bhxhb `f3> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x0  Px ƌ2 xp``x  xa"1x -01wx|`` -p 8l`0
@v!`lv-f0 x `b    ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
!ґ u=`f SvN .2[]`g i &  _
md@að
 `
R3҄u  tZa T?-AE eMA9Y.'UnSS<  ;A?c( 
`3ߴqĀu N <tDZQY
 Ir8r502:6 v&Z a U$PMM m rPCI01 ISA#+T DD03COMPAQꊙ 02/25/05  : ]    F10_  m؎g ЋJ_g+3f  m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M4
> tj6h+jF_c&  hEW>IWo1c% = ۫ۘ?g	@Wv	w#T	$s
|
7JAfaffпf
bNccm@f>
dQjut$kQ1j`		cR		pA	
FRaUf	%b	D@Ux
E
#C
5JHx
R'B}SF _"qUQcیB b,1-,DR
gP$Uis0|0b~}"Q4y$z&&"x6(2X::f{
,E
ct;j9>>_> b@<=1"c|jQd$'${A0h  nC  tAt=dtfh jnd$1!qtfhUL"I|q >tShet3 tE>RP8jhRdfjhIİ	>c t%j hc1t2>e tefhuof t+fS *$Cf3f
pǍ~f PFPh@@Uhf"L ZQh!3Fz``H@8=#2hwdh dWod V0,5&~	he辐b~ƀBJF&g能gƱ	tAyHfc/fcrFBhaFP7@ ojh!Cdp\
	`#?eh!fB(4=YI/Soh]cV]cҁO^z05%hK01!94 V}Em~*hmhT
$>O	QBD	ڏB,^_ a2FFTf^ F&<
uI) u&*_&8hftFF 1FOuÀыٹ F FIuF*1 F*+҉FV2g+;u;uà3g% ;Fu	;V@ÿ2gG2U@4A996g% 
Ð7L*	6~
o WP{
 P@B'~@,\ f wf`/2gc/0]&a&cjLfP3j FPfj h^8ͱ]Pb:1V=ut_ V%#.GF| 02:|Wa h &X F? GP	7	FNuFG0?7 
^xOw(HaƿF 1袱)qtF2` 1p vZsu>rWa	IbJf?3@6# Wr	v	$"
Ċ2&c% 5oFju c 769Ryx-&c533ȉ0)@q=	c TAB`	2&a% +1a1aj_RA	3p%2c%  nc1PjAQ 	a9F`h~3  ޗcjD
N
E/
*
C(* @	H& 
 	NA*gw31 jiő
Xt4*jSbG

 U'@(c+&ccRXxRs/t5* `c$@2_Ft@n#t#Auy`@z6)&ca{#2cߛcjTC@(Cc _&@c0w0
9 ;0rjAOBAC"_& &O ݐg z߁n 8
dW 1h>
a Yft賸d t}J2 2V J?AAa !p^PqF2g^F  ^F&F~
_r
,e?&"e &h` &d^g}P@ f~@ cRde  e.# rG
A֣/ђ|@ \`E  p  V6д^aF@tmP+t@^d Z`,tT,uN&,e"e he .9ʀtp"Pt ߃@dAA d
+%r*he@"6U
		! t:}8O
duUea+2@$_&0d&  (!g*d !r΀&d"cWoutD@&9".1FQ0@  &dw.j `jw w3
vB +#rsF0V
-,_B&f(&
g &f5& +&C!&.&Ƈfd r<|ehJWg0:MB>˞c1{xJ@>de&eeaFVD.AfK02ae4d	s$U6B`N8aTN:KO<]c~;rvsА)ude eeF@tCyZ"j$	jg3Z	3ށ de$ < u] @<@/"]"rQȸ`" 1 e@yZa`94>14!f@4L(kva2]eaj0 
t%rՋF^Nr'~#tp  u^    % F+ p)^  ~u +ËFV! VF6Ƃ6~ r~t` t uFcfv
0V32,pIuquSI]][t

W ^^apL~  f{# ߤFB F~P|v^ KF ^NFFV~ p@Ht@HtcH P )nA-pg06^F&? u/<cvmA8>rd|mhxc-2RacV;3.cv`f.cm`
wNN׍Fev膑$F8?gFFPjR?g_S^/GFPv4F?gFmP?caPa?:!Z`dB_&@0c16`b`~2|FtwFr(QW^
4~`4	b-2 _`-+F}VFQC94%~ t;F4FҔ0
z u WV~v?N^?>S
A0@
^_C
"j(c
l

[t ,md(|WVvԋNsOD .HAA~(|W~FIt_~@u"2Fݐ#}HFB^F&WS} 
 
.APU!yu@## KְVDia2Ҷ
%%		 	_F*Pg	}`	A
g<d-UWVv<t~P F
&GFq&'h*V~ʋv!^P޿FGIub: ^&^&8t #^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ N?FN+O;u0g03ɋFppAFC&PfSp@ ~0gЋߥsG^AaQFp ~
vЂ@x|r
CVV,GV~^&F]Ia&a8RWJFQ2c%0cR*>⻪Ik*bf?N3a3#1!
= r	v	$
a2 % 592_
obP_#_j`R#	2&a% XRo!2c% Rc1cjAROp 	aR/! (!Q023ޓcjD"E
*	C
*@Hp*

Ns#ST
	 U4	@g
31ܠ jiQT,pyXr~yz{	@	x	[	&% *{5c&cWcf`f   dfṿ	 e 0 g .fcm؃2@B T Kc]cFrc⡐`6↸W Vi@Ha1FRc4)CS0B|3~QtR ckߑfz>j6hhLjFcW SPe:>"bIc	?@#Ϩc,S_ Ƣ$+"9~oT3E\A	}j`faf	ff_؃'_fcPXA@ VgA \a$CDUxE$
C4
?
Ag_H_ 2
NԈBUacB [%q'SpF "4ɂgP5K2ip+E~0Pzqr442F5ϱ ;j}h!耐[a԰LWVvɋދ~ &F<t<
brTF*;a}7Ay~tF&8tFu|t<r2$VP^Ɵu	A(|鐠ο ~Pfh#  `PF;rF f?=* F 0 F*N*ȁ vF7P0"v`J
u+Tf^F  FOuy	fdf &dfvctffq0  r &3g22~`% u"2g$<p22g%r2g14gou84q= +ɉN32g3o3 Љ  au6g$<u~ҝ6g% bPu&7
u]f2 % ;D0	u 
uB
 )
u/Au#RaA68g%FOR TfUfVf WfXf	YfZf[f
\f]f^f_f`fafbfûX!LŶ f便3 f BȨ9J_ujvR6k- J_FB~2|~ָ1~`F  p ~ uFdm
 e jtV J_FRvKuF@ b*J*p
N?vQFWVQlFFP
|F؊f-^Ծh 
~'F܊f hF֊ft@ t؉Fjvv;qxh d-~St` suPk0M2mu`hLh{   h vFފfPAnFf6 juɡp:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ʊƹp^_؊210Jfb;<  UN2 OP NXb<t Y`Kಌ`*pOQ0AaPj?+ *
- e)@pk@ NV$^~|"`(`^ `<1`劆2?d$0   wq$j)!fu 
CeeQ@2gЎ z] fЗ`xEœӉ)q"*- t*-} t94R!13t$RFaʑr OEOboLwF m0#f"7g
1(  G/EBwQ 3 3|
/.Y' /PRqzh6pd qa"$2`g%c2g/ب osa`a1jLFP j9)"#2#"&#AD/]PDE@WV3 WD|^&@RFG|吐3xY.6 2= R& FW%1<` r 
7<"RMW>
d ێRۖda~a6  &=  C_  Ft  
"Tf#-//


	
|u	( LĴ &&TЫUV~S~ t'jF I  t/ u#g'jiyp`t= tA:?`>u
,e&he""e2he% P-he  t&,ep1`ul À&l yfdxf0egЕfepee{e>gdaPaQa_dUUd>uS[h hJݹzh ZW菢p:r@juzBzh[^NA4R^ 	'"		h

 
A_	 	 	̢	$r	B		RaD_F&? t5 (u%&|Rup )u&DPƋV@0鰭FFb c֐fjfh 
 fh `  	     &Eq~  A u 0&c-E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  {-P Q   8>ۋ  &9w&EU 6`  VVހ 6Dˠ   9 ~ H Ő ;p! 
fܱ
0>~ Kހv&@_u?PM^;  vĴ 3fjth  <nЊp L_` "f pvV>B  } vVP*rF/^ ɀCP% 
P h
 h  RaNF
+F@pF!vvo} 	FL_NQF@ hbj a^CFPNQ=`?*P!ȑ`VW  p 3_^e #L_  @SᄊF`
FLBF.
%
;F|!% F@P!]<!Vv !k{`NPy`rFD/t&@A0#FlAQǀu<  t (F7 PF@V5
  f#ʹ8؉& *vBఊ|ub~v*VA MƐ2xƊ*} ufU  Vn'] ᚃ> t`ur3NFّ\ |]NZ&8tG[ vNߋً! ؉^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋߊ@!A~;wⰀ>
 u~31&A *;t{r1A 
*_F0D0?F
tҕ t" `fop
V=uO`2P.B@>?Vu	.USEHDaS!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uۋ31~^
AwF9G
uɋN3~(~ ޞu j  F;|Ԁ;pUD  ߸fUVNVv<%tF` u DD^ù
0NÈ u0+b1WQPWVFM3^tQrJ;v~ F^F&_uF$=WR\qQb]R?}  P+΋э8sdvva!V0N&8 u{N = tp&@* 0At߱_m !
`f+KIQ@kqlCTN`_
ʐ kj }##vF_j&F3v~Bv0Q&ğ o0b;~ANuǋv| 0dFuA  
`feP0^VV cPQ  F} ~ ~
~h3ҋ P{W t4>gPǰvd'Pq 	ptGW5o"p 렶j_9Fu
q_sPK0 vv#5+PF7V 00NvD"F9F}+F- P@!b' ɒqhFF`%*"{ nT\QPEP)DPA EEP:P! fh p39> ~jy/0*9>/u	A
@0
A/\&_76%'@2)
Ʒ
G;|2*& P苴 c`8(^F
A
j Qj V@VRP=^AQda*'P? p9<`Pn@]c E +F+FVa#
0UcShpbyf 0aDPodQ虡xyQ	5Q`,+F+Ѡ`M*'2 RV 3Rg@D=PD=ӁF3@**A;?}Rvs`'V6rqyg*@F;vwPT4C
sR14+

uK#aQCPYedD&A84	PeVs輡V r!r~&-24hQRptYAS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;ƺ@Ɛ]q<vN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  `IϠf@`	PXhf@PwF^^UEAgTe`X2s|Pѹxb<FA@ŀ[0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4v/ .9~4aFO6,+F!}=pu.tpSq &OC@ +σQ._+ǀ
!0|ctj[|Qu

FDB.=Q /j]> Ln_W0L# ' ORCA& !!pa^2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "fo 	`!QF~ tfFfzfF  F
Pj   v
u}i1Aj >PHPV`
Ϲ!&wc¯FtB$P
QиN	VV2ٓ~F
t!@D% QD
莡Q
VQ6 B tDu遌Ǡ
!_ط!bG C] `D]Pk*. H!MbB되9>u	 ]r `OGg	R4O1miDu(+wHuu @uqt j	jfh	m	"	PV^FPqf~
 t

>taxQEPzU贝@ ]FY m DVVjvv{xX 6G ]3?툠PS002Pr~CwF0B@UPR1qE~
G jR[w807+$ }Ep  9]/t ##/E=/`J/FFP9 \ dpg
p; ;NNNQP @C7/ Ƒ= K = ;  -Pp---xАWp'WFj  ܩk >f`{ Pi?;v1!;vFPVW>FP~F~PG;~~P1% - D- *-^#- " e= Pk'-R
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< uN0빋v T`ߍ 3P Pp & !VN;
u逐xA^F;~m~aXS `
$~Du6?f b_;|qT/QN;v}wO;഼6V}Q9~ uFApL怰9v|GĀI0Đ0%9F| ~'A^&+^& 'F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 Wrz/~IV>FWV  Gc de t_d@ @ l tee
|tATD\m[u0Y_;F~ ZpӁrջN@uOp0
DK=ʃNp>d u)>e tl>g tt >fc t|c& yhb?:0 WhHp.u"jhahN_ݠ
j(h!fh`_eh_ j _h]ch_K _T _}B _m#N_a裚%` !fB"	^ e% jes% ]cc%	 KcS%
 TcC% Bc3#+(4`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНpwt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }55J4465245r659hM@Eۣ@ jpPVCpWVh
	 !V3j hD	~DXր`HtHt#h !    C wt^ f	$ޤF HtHtHHt$" x@ $Ѻ&&G<P jh	G_+P舐X
_G>7x@n ^aGP0v&߀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eM?	L0#	Ka c{ 	3$觥0(`(hOepa^p3&~/ߋtC&  v&8 u*C;^|5ckF^P9PP`^? tvN~}"v`<1
ރ~ u0fDFG&9 uԉ~MWRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBwtZPU-
tKŽtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@F	 f0 % wt" uNj pѲF  B u
gށMN3~*^}
7ފ 8&8u	F;|,Bdn
meP $
nPڋ P\C 
Cc!
d$  *8fudg"^uQ/	tP3_0F |n FPf@
t)fo3fn @H~pfh j h2`h` 4z$u @3l3 1K`F*A;Ht5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
hЏ
h ?AA7B 
@
@ -*

@5q&
 3F! "&d&d JfjJf!B"  _FP~H AKN
3aU`#\'"%2$:GBHF_^~`^ZQ2 č&Í],3F
46 x$dh0dj(j 9
P8
PPfsV
bW&*_)@&` 2 d t&<
 <)Ȁ x
Q %'@q`
c! O8hdjg  %cbN0ff3	_%  Piz`RB/
?
$*H0/$&40/0;4RTR"_RVdsp%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-Mtr` MYnp= d.ԛ,2@0`  8&_0'^]R!"Ր,20`  0PXu/1V hh ST飩  9YۂY݂Y
Y&"0Zd a=⠅	_[Q["
@4 |
U!@ _d_dax0y@ Vfh0/?h y Pc@t&
 
@U UACCCUE΁!#!
@d_d_
ހƐ޾
;r( + (#+-+tp*tcmKt
- t
u] &3& tGђv 1vhНh
h P4!wu
j8%AW&A
-C@#'$'Нa'a{Ðj́ ڰ @&
)3bPf 
0>{+>>G>do'>n!>]/>f'>< >Ћ5P$pD D:>E489JR4"" :L%9
5Bδhh V2^Du+! 5 31;ƻut&_S7髗AA@A@ctR_!P!_!
@>R`O? 6`L.ࡠAL&_R`~O<!Q"Q Q*|3ɻm &ArhOE@Qp8ۀ@	XrQ됀UUtD3,ޱi
; YKR`3mrFv!
oroVv0%@tx$P!D$$`
P#wBf~x0%YfAǁK=D=H=yMR`;Ա;
fhZ " [BJGb %^
tн
]
c_t,W*@t>tq *``(@a@1)@4AET`ŏmƏxCQ rM# ғ,X$ $ Mǆ0@0p@
U%@$UR~2U62`T`ҟlB	U`t12&vP
πvB\ }V5P)u	B0
 058҈$   	 $8LZhҥڥ Hb1p  A!ЗrzU`vU`c}b뤁Xab 눋T` 2 1 릀5џr1p "(+n ) ᠒ffc7cWfh  ցQ
qKf_cf0B&c]"7..eU86d69U>>%A;F$F <NNR` ffAcu
n7	u-du$uuu_	V@ V ,ǈ_|rh=ܒCvCʋF8FPVh@`zgv
WV# 
Z``HtHtt-LXfD+ C!!f"B@
?vתQpg* %^';*@EG@*`be~4g;*@Ti F*

tG
,Af+_fF@ ؀ } FpFFpFFP^PQ~TXD>== 0  - -tR0   - -*t:- ؽ ߐ=@+k-AD  W-  t}1x$Ht/Ht:HC 6 ޢ ( c@!@"!13 >R7" (A
Fy
t)j ЃUPTPfsV ptt0 ;Pa&oM"[!Fp *HFL~* f` fFa^vfvvFPv讐5F0u63F@,˃~%va :uFG;F :!e~ t
&x{~`xP ~@&p!  p!qq t&AÃ@`ό?"Ht)3Ã? @ 2b~Ǹ&X q휐V>Z` u#uHj 
&3v0 RpheX`fbf`^`f ` ~ ބ 9FhDb R
Xo`he3 b8-9t- 	t B-`2
  *Xfjj a
5	0u.#JNuh 0Ɛ>` tuVfh  P	-NRc>~ `6
Lh45쐟h^B653`,a& ~ ( F |b ra0մScA >p#u>p\t&el6Z`蹽 +륃hnP`te3.a13
>^*u	> 0!jj2F3tׄ;3Be'kJ t'{~80:2GR%4;44Z
`bPh j p?p@!F1@[$ژ
mu$d4D*tS?*=<=5
5
w`Kh@a	@Ba	P fh+rD-q*Rp~p$ސ#;$ %^/0(aRd*a,ac.ahen P"r ) c%  = $οK
ef1 [L2 SRb
b
~c
2ؒ
 }Zg
Pg
 0

 Gwϊ٢A]d Dt,-
t%-.t,-	 tE-
tYt- t/0C DˣZ`:B~B/ _ }  soU&Viet,eu& rietu
0twheUU@U  - ɾ@ut ;>}`  Pr%hmrjtXяǋ60cHtHt `t' Q軋 hp6u
^_ pWV3ɀ> N3һBwrZґ@FPWp~]j0r躐
N~pDt { & }Q FV^tF&ud,,,,,,S,p+,,.\>uh hmh {h 
 ;j 
pc/ޣ"?@t) 365P@;@)}F~
rwF 
h`s΢	
Jy=
Zj 5#W<B6f
 ~Ĳfdf v3ɉNv~FV
tut9v~O|܉~*Pӈf0a^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpf<afffQ&X'  
<at&
]S
 P t	s`p` ^3߾

tF^&FM!u	 |03$ F#z@
pEP2}Da
nGW^rF*f+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.@ZhKx/ /  p- 2&=a% +11>a <a<a@ 3 ֐j5B jh
@鸾SE
] C
@
@
C/ /  (YP)@ wj}Q'3
^'G`hߐ2g5؎GS.aAc0a2g, <aoa$ a
0ް&
c
Q 
@DMԯ
FW@f 
fhR0V" !gB
p,pfh*+`()&' $%h#w:0b\rc t
Kc weu
M0  O hE= `F<tF _"hx"BQyy_F ۄ-FC|ߊFà@aGկVA?@aBaa!JE/PFdq`lDLH [f`OeO UK[1UR1D
B
HUT4Pyݐ
Ċ70SWBTaD

H
<UUF \XE\_Y	/0
ZRq
B2A `5R1eeRȨphhbj$r&%l4e65nnDDFEpMT
#Q !\,B`C`LB`fB`-
@- `
- Kt <_Pc_|`d$_@UCU,FTbp~Կ$:Pf|4,2"5^@^Ba  ab AB  z!" 8- 2&Adcldzt] dw@TĀDa?-  3 @O+- b	uic] )#@댉  
#j-v Ep wbp{ނď@ʣ"Lcfcf@cpp@ta axxz` `&CADRPt &hDǎ&? t
&ؐ
`@T# 
U
C	@U


A C	 @砚c:Qq@t&fhށvЬ@{n~fhzh]
5}o425tfh:}89h7m\2
z/с0JRv?=>_h<2@ 
`	BAh2kvWVde$ < u@a@<@u"d s@uot[;>`  *r$ h2h$Qp1@66Ha u`%///)Ha/R3 (-HA͐PP%u@u'$F Pc= 0Ht
>q j r j臞6|@uf4Y;F~ K ʃbrջ|N@uOphnhlBWV 6W#p 
nrvbƐߔdt
Q o&"F Fߔdt &?ce7$KAJM&PAD@T%V%Q _%T%&rh@h 貽$ 'Fc"JaH_& *JaPeA u$2,<7 h&s?h:<9  t~@ rb` zj~=  TP訰0 jP,Jazp0u.&bPjjz`&r7z"pq޶|aFƱ0#0000J\000! a:kVfvfhI?
 V2u @mh ȣbFb:tF&߀<:u-FF
*0N&$  
u23Q@C7 ~ uF	 F
  
 
 <  C
v`
kPjq<L^P 
RPE
? 0
~ `~ tgh>v&~ tD菪`E=:={u5 :
`
 ^3 _FPPP WFF9Fr qF% -
 ؋0v v sd ƨu = wѧ $ʋ~FP.aczy ~o t 4[Fa    R F  : .E " ^ 
Q@p~dzt' ޅ2ƂOFZIZ#3^ \L21hV$.tCq uw^ GCauK  K .g"ŁWI Nr@~u_t W    Io t@FqqFV!F^=ugFv2NS'22g+@]WV6Khhdy*y fy:u}oyDt4UH-H4HSH_FgHHH7I2=yFIPv9Az"ClIDzߡza
"zj &z<f+fF@ ^ ߸ ^ޢV^KFP6a> Lv3+Q OY  l`- t$ fFf~ sA,Guhܠd fQVȡaRPSQfXfYf3fffPfv@fF fh  }bU޶1g Fvh  CQP2d PqٝT3d"q!TpʑypSڰE  p 4  VW6rNq\		% 6|aD6Pf\ 6Lf|<`y跤
b]0Ð3Ð8  MHz` KBSIMPLO  MOTOROLA  HP  1.10Adrivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exoit EP  s! withouaving
o Securit@Administ or passwor5Cte a/"Po?wer-OnWGp Devi#cedeDgbD$L $s mart Card%G
supportEmbedde&f
taA!e'e
tr*ac',p(s$`*authenticS+e
credal /Auto2cH%Tools Ba| /0Calib( @(`'lectzb HDD:lf-T2 op8s Activ O Me]m
Chep? r s: ll=mb 	>>uA@AdvancueaL`4uagaC lDt7  of grayq6fieldO Boow1b..Pres>=y keyI I ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQ?menu iYqKp"<ENTER{> Xbegi)ФWK%#.followM%Z&:fpc->  KSPACE = NexBR3c-BACK@vio"Fg0hTABE3iSHIFT+&*lF2@&10`
v[J #'9 E~r This60/cann)b`mU;d An e socH@ whs6c.pde _0x01 e@ondApGPu@p0{6Crequi yayE`d~jba@%mu0C
movP:y e4k/MEU )hQ1& ilAl//+2SDcleOs}u06ssfulManuZqr  N0
d:Pr9ottyp@speItepp+CacVize (L1/L2)SQ ROM ydd famiaseP8l nu|pi 	Videovis"KeybooFr06verDbI1<ed2e3Bbg4`1qa<ownPhip<(TdG
W
O3O	*	0Ĩtafdai5u%BSNZC*D$ 1
2
3L	ME
C

V


4TV
o
Do
So ྶB: D.   %FPA2d1!J#biFap7WalRX0s&1&H} Addline4 AlXn.%F$Warn: rk TplIl0o  zsfTrea /4vր, lef ea waba002 A: 
de` +waqt@tҰ_ )Vu @9rnInv P
)!	:Ayou̔ {wa@|to  Т?m  aioa	  0o`b+-c(Quick`n22 [(Cvre@s3 (S.M.A.R.T.) 1EP1pexim@s ): 3A0¾# g¶30%v}} ty hao#0#upr4:1't4	f-UnknLkp{ilWR!=flServReaPS)do џ47`?a}ribp	:`&exP9 'b`G H  Olp Newz Vfy nY7Enc8Off O  ɥA `La66#%AKroE   p dV
Ad1ݰ U@ҭ5xOcpcaus7 p@=AH"h` A&فOpower	-.AS΁Qa?U= loGss  (dYAhou  nlzcof aQgoH04)ev`ۢ?[Y;DocHishR`Ged?!0f]Dddi1al JJe HP<`"UTool Cr.%oFH8IL`ˣ BCk g Uмn qpm`@jtWSN !arv0s /UcwcO4P2"Onj* e:Z%%% F@%԰#Dn -fa  Tnd8fӰunuR?*$n)tartpBQK`fra Par1yNs Spdlot CD-Q& v@b$۠@yU@	11` abouȡrzph҂ u`2W!?1 bޢUSER"MAST xApanPO9`cRR%Tkeep i2azcIewphysD`<phaR  7mpp`r. I62?R>
,ҚnRVun*" gFOO/AutoOc
EdpptY5 5)0?#ON; 
O[?kRziCb_pur?t \22th@PqsowZ k ebdiPerJa@naff+bdata, ]ssiblma!aKpkigi0d!V IR0sWPl r mmAM |( Tu@yl,>lreplap[vo o/* y 4y Xr" |t,CoHA=Wy`|'qu{me`1r, @M6`*p0uibty.7 IfRdo4w8`!ESCs.!
T V ͲtypB'>'nђ@F10"q0rm,bSXhxt+  E$6@ MiBjQ  Orpr: U ay OPXېrDCgDLb! (left@/hUS!B t HQbSu K ZipNoFiro!F`thifp Sixa hS ENh`ASwap Fn/Ctrls qKTU.S`@aslegackCL>is`7)n0=2Pr@ry Vpo  d NTSC`AL -JF -M+t
Bid`E?PP ECPd2size 32 MB 64a F@pAlwaynPPi0AC3 ~gWLAN D Radi ViBluet h /rS :chAӡ	  SgB1rᱠNtЖ Ed (%+"n,2())+PP z+f1Eqn7L)e 123TokR AHp
AkP	M3Unique IEd!fD`&pepݶ   (tu    S`KCalib!
6N@sP DK A.Xb0B HwO
ELi MEUk' g'MRoN/G/U[|:1 : C0@g . % i] /C le2  yc1`d@ik-d3	 s
H

,
* A 5>hM(o!ylSp` @hnologygYadapAPXE RPL Exc"Popupz(`@0 10  2@ 3 4 5 6@7F12z5' 15`@ 3 "MnB `ouch+paPuSNon`<F1=?Hilfe> p
iYin[O>nzeigpfҠPpeicnt  KaguaobVwiePxnLveinuQn	-hkz
r.ignepd`*nt neh P7/%Set#SRheitsfunk(:n`toa u
nBlt-KuO] Gertes/--ID FO`t7	}Usttz !@@ 0Qz#  beim F3st
ng!KAr`5nHsvorrq##7..z_urck z9
B .p,
Pf_g{ms`>ThEx)>`Akkukr_eK tpBsgewhlDD-Selbsqs@´ItivS9p#LtIpr 3'g 0: tppllTL
PZ `OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!8`6")e SiePMbqTa@0, um p_3fahB@i=A, ESC=Abb!#`WBkze!TJasN0\ , J<a	=Meh`m VeZ
zpMark"sxy!*!'MenS% dPfeilt!
^dQOgabe2RmO q>ko?9 c`s.	folj
Bn 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchrigtt-`VowA(GTabul!fs+ Holl+gaedOx F2@
038= {gy EschlrLi@PK kan~Lt we YeiffMgЀy16P=`?rge[trЮn.Dc 01 Ll@befit &B kqcQFY+t<W\selomvPorB]e	r0ilXWqDeskU-KsBhmu f 3asÃbzw.2Mobiޯb-gtz%.`Qz  qh4Bi///"2f!
}[KAwlgrѫ ab	chlos@`F-M`ll Proz ypJrtt`wCig!60a"ꑆCa`-i-Gre (L1/L2kkapaozitOMdPm"Famik Sp; ummU Grafik-R0sa@Q "f]r-Con  "
A  °a?7J	b31O 26O 3O 4dqV si H>(F ` 	o	o
o1
L
2aSekrET* L$ƍD%'$b-!3Kc(1  Walk~Zero-T<.One EEdA`@PnO`+: bX7 sstqbislrwnKp  ZEucQN-/W0B _leQb s Atei #CP0&ILp`aok A:nfC26
lW$ge`KR/+Pglp%ɏ5 L  	/  M0$wirkQh"vQM?`>3, daᱭ
\l^ie0wQP ocFL.01 ( anH12 (Umfa*fdIGc$wfhrxdauP(Min.): #30ZБdS`@0% cgt59wuwm HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52'/rvo-L5 .
32@lhafAttr7ibu0FID Ȕ2u"LS.M.A.R.T.˒XXMs eK`kwp eus~1L Dea  JaQ`eD}/t Falgeb e
U	ңBU5xIp dminIoz Dur1@`'@`|=  mg1Ai@eFN1sgd,E.@"< ttifiz eq s{0yr{t.@s Zu1 `0LzO 9pVenl@~.Ajb s0Q!np'PlsAviceTa s ,ܠF$0@ h`$pg)a|F	 :	 JZgtfa@npWUmɏ Fun)S7,' m3e\ޱWn HP{tectToolsP=c^ty Man#agпUoD-- c}- k QuickLockSubndFr#q\M#`"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+  *W"$B>#, lp$meh1A #I Nk>"`Ƣ]n3f`ot-Parpen}imCD-ҏ&g1M!UP:an3A7m$"rive&Ftpla`t9;XPcJs E-=\s mU8unbrapjb'ar.IpT
:b,ҋbewB>SD!sTD,d {¼ !C&&0,	I, 2.8\v%,    H2i<nc4z@ N󝀞}Begriff0diautomLs O75@:ohl<? i Q֩g`yp #ps\V*f ~
T'U!!´!mU"n# OP o"e o )lnYy#OBzs瓡58c<sQy:Sn@ iQ.) r`uM(qS!|qs mh!ac%Cw Pr qғ+`I o0  6qurn׳zhE . Escdrr empf`/qS	 d?zu!тRO`x t.  󉡛  f.МY@ұF&1 2 B 7 b-B`ntra tAdant!Whj`!@Esc-&VlȠ>m kW'p'p`\ F10 `esh:
x3fg`gL sbD} m  ܡ@MM]uBay&m ̀)bBtgk`-EQb(links (1tUSB-b#-2؆ƢSu`1Zip 1`234 5`678 9`QFn/Strg!Pt  ų dEaCГ (USApfN-ZeP]}B`iebss"unabhngB`  cAIAn Grafik?-ContrPrimSek% VideoQ- rnԿBidireba?l GrP |us Lfa`iCb0tzbB
d}r WLAN-Gf0Bluetoot%h9UnU/a Eg{paAggr e_%7(&.(o)u -E`t# 12P3Y5ToRR aC :=A q1t v^Q1I0NqkBoF AkCkuN  `PtaA   x a~  Kalib(  M`k`O  NƘiual_ !  O  k   O DO,rOTra-?6. .O .L84obi!q p9OO5"R!P 	EgnOOf`.[цrІ 1 :. % ]!ablo(2Entl ho3Pp1 
m* 2
 GSm6'@su' `RadaQp0aBPmbƀzA}ExpA-!-Popup ( .) =W0edau Qt0Pd2 (eZ@  Ke`~Compropstn@ <F1=Hjlp>Atoplsys!pVisúne G0til !Akonf@b[GwendPfraMqzp@QrU
J`gnorndr =o&fslu r ,1 u*t`gBOtne k)hed AdministoradAsko KP aodA7 fo% ˇhE"djeG-iSq		 *	v*
J	Sm-k	God0d7elsf 7do_dbycggPGOds -&2	 Nu@00fakis l2 Uag
s)9FHk@\HF Ba.@ġV  cb"dvalg b&HDD-seliv\tPr HukoQA.ainPQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=OAnnuaFsp!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we~  releP %menup(,1Wt<ENTE'R> bqec>A)et. saf pPr'f!f~7: -> e!& MELLEMRUM = Nl<-TILOBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sf#ej 8A3ku1id0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvNvek`EnJJ
i db!?zs flyMsÈn/McEUqoO5 bp* uvetzbrud 2JI,nemfB J@`  Prc c~@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ famOiliei;\AWdeo#f0pds:@Xr-cs]D-ba`si`9e2o`%3o&4Z&at-ta`ofej1E("Wat)	O3OWEw ex{%Ipsr4E$ TyPy%xy l=ydes!Bmis 0'bvD1I'j`Qeje var0: DB1! se  alt@P02[hold a@ poPdqt`/b Bb-ɊBdqduw5,&pr Pk
kEuGrBA:ރTETf DF%Ugyldig/
t-  <@ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)%Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR 	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoRR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.pbilK2;p+1ol p@~frard )x  Cd-rom- cU?:Bg Ho2A%:e@AuΑ5Huhu,;̠ Dq .  bOBRUGER-s OVEDADGANGSKODEN,22QՉLU albtga9`s  n Be  ne]d op@Ia0X'edS T#
{	aMD Clj Ђ D_aBAQ>Nhjlp eutom`oK, D,ZAbyg !iWj?5B^.k permaf@an`Pig`v2n:j fys dsk5 2 rbppc(On @O"k	v A .cBna
  @ucW"EKm/, somءмa ckx@
ҚTut. Ur8d}U pbz(@oPc/cÀ ri`|oSӴ`@.P  |бbefalkrafǓP apx 'A1쀽@"pl . PAXu	u
׈q  &cO. q#m"J"4,Q/pd i`$HuA0˗ 0.a.j2`:@ENtrA!5ESC. 奘% orPx 'F':ge@F10 FYӄMsf
i/hPcD+su  !Dk Ossrf'lgm vDRRenAHPskm yDSP-bas MultiBay (K0/$hjUSB-?floppy%#{cc{2|wbsqu SbAzip~Fr@aVTr7edj Fj ސe SjSyvRV O Ni \ ȃ Skimѩm Fn/CtrQl E`lPv(a@i`sk)8  UegeUstt!
u@PnPAQ֠ߑrm-cr Prim@Se`d V@o Out ParaX  TjStrCL`ohukoЙ Bqld t 6nr compu 10P0^trm
gAt WLAN-!spioBluet hK/A (trdllo|netr0U|c!mstyApփ&(x(top1*b*Ethqft 1K23KToJR aYHL	pe+	 	Ent 5gt id-nu 2 0ı@  S@   Z 7b/ JKalibB' nndaigO  x 9p6  @WNMH KO OM2[b o  O  O#0 OOOO6$HAgs  1 1O O
1VSi mo`gPa(MEU)J=K= OOGOqOO  OOO[ TPq 1 : O 9. `% ].UgAmt2 AfFH5L)zO3@	Genos	
k

, *  J/X 4%G)g `hB`At `r`bpop{upsink(sek.!HH025f-1T@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jons sypLa@3$ak")Hefra6#:p`di!opQ	:k@'Pg avslu!A ,l BDE;sprograpt STt ZpWass@ a/&$OpFA0`:|U'yrse|i!vsfunkur!tif @ԃ%@%-
vn Sm4 |#godkj0RƐ!neby3Pi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & valg !AlPP 65;vt AkL MbT !#[SS;G@$π*
`H!4v prlg 6  Dem75bM @ZdtJIel[3
.5E6o%<}5TorykkC taJqLL&pg _=, ESC=Avbrya bBʯAPpJaCNei rP, T\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAKEPvrig*TAB&"HIFT++F2@	)}= Go  f#l`bWsfeF`  SPk0`pZmno&p@5 PS M0|m kjresvYe!@m d,;@i pp 9!osbaRaflysbc^ 0dS  w}a`1A|rv full1z. kode 02Io|"Produ _t Nopablookk-mll  {typ h@igv&-ga zvAӄbuffN(L1/L2Meng`	Q	Nenu V@wo-ЏTjrNtroUSW,kobgRiJ,oK51 qNi 223"40,p( E
,9(Q`
oa
`oA
o,
NEkg#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( Adss e7"~e PRnAd 4~: DsA#.s@QtisdlSCholp`@DH[aQ "/he-  &d, rnP}u1p3 sakl<k`nn02A:%ڲO b@Ҽreg1i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R @nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 ePcᰔ1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vSzq1   CD- )FsU1ut Ho $-:Be5B`Dhpug hh!3@bBRUKERHOVED-T5 BI Ryumu0B@EQ
 n0]*RDCbe!1KPP
 0P v@ " 2Va! #
6R,ARZP<0 	!؆ 5)pp  t~I@HOM @ aOutomPYpD!wLock	3cbyggZ)b0`  @]maPqilg ]g%e0.S k_[h fysAad $0GmqW l#=	 |u!m:fnd1]VsQEs Ѻdda g }u%x. U⿲g omd@N1|0/e XG)0zn0q
` uPb}Vnbefat 31G	 A|q.1A,=w A0k1 E5ϓ f hP_!R!'Y}I@7MT֐s wp-QVflans NPBv
,2ʰES#C-yL ΢`rb'fD'<J F10$Z4Cb#e:hf`$ nd  ˗Nor iFGO%re  Mu?ltiBayPG]@y "Q'n7(ve!e)pPko.ngsbahhyOBUSBA|w Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeenAel a	jZtroA2deoP@!"pT;isrr`2FViA7tiࢀ0mFgradi/@trdl |t
WLAN) OFBluetooth j/-PbftQ`mbQ҅ Agss`B	styQ'1_"&2o! (v"*b/!1 Eth ?	)	3 R@NsA'ooo/
8ni|> gtifikO4C&\=B6riQG Ht@    3ymbo KalibPaK B!es- IA09plХal ,-N	O	 I	O	O	51O	O	O	O	8ksp._O	O	O	`lnd  4oO	O	
%O	O	_Cs mob. ^
H.\L. \O	!zo
{{O	B.[ yTAO: La9. % ]!fullC2 Fa{i3
Qi!n/h* Oy  (o J/D
irpk)mA sin hurtig (/sekuPrF12- f1.Sep_ute P pConfiguracie la Com`adora <F1=Ayuda> rchivo  mn%l Sma``pGu isco fOlexicX1pٻ Ra`&sAvalopf@dobPay Ignambios y`li a AL{  g3 'Ln@epidadAse
'  ' Axj0iciof%0posi@s_SIc )$ +5`*KskSm!=C SoqPe*cP#<) Sect}yincor% E 0e"@ 30/c`VxP>6fbrI
aBVc!3nci@])AutomaHerrami aC2}H`er  8P(8 ;prueb_a HDDKc 'EOGVЇ&Memoria2aDd*mp.l1@0JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? nFampr)co0N gr0<1o?)<UOprim'quitec0g2) Pbm=, E_SC=Ca06la==Acep\ u=SSNK\1"Y, CoN2	=M y p UyB$dchDha6@alvP}  alem o apropiu=@[*<I?NTRO> z qx:N1n.Fs{3pkTYu :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'a~Mays+#1C(/`F2!-910`rXŠ"8b"uErr0^6F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bha7y nunw>э&qubRnY2"@AC1+>b1 `r(Rp[corUD)JН@ebook/MEU? IXQP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga`@Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE|`oD"FF%Ad :vH uir  eapn. PreP4#/, WcqscpYcuA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\e'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,vA`Ơbs (R6% E  Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0X&upizQ,.`xHO;re PunP+roj	o%q>lWS9M9ICD-(
Eec%'WePi:XUsio:Mpu;NmediriveA'0 tzUSUARIO2I PRINCIPALьj oe c&s UaJ7manT p w. Anp2 >y gu # lug3b.P  p_jဈz.p-%H @d\WcG S1
!Qbb;v aYp=O@mc}7PJ67EБor1ܯ?b9
 4: @G:iR u(?s } , fs`m1$ 겞RhArQOoc, G"o~ /]y"<:Xou d/aap{sRcu2bRt	£B! ?1 #zda$
kosag а6Se r0wo0enf 8d lic㡖Ӣ@refaz. &?k дu "`#PZҝ4=ԬFainO} a cjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅ ESC. BP1alab:'Fd'  ,F10B:lFRrfG@ǋ7cT/Espaol OӗtMultiBatNQPa DiPsi`$3-pA  ;]SfbԢsco+d(iz"a(@jech@-5 cB b a01ЇpSuwkrZipcpmeaaewTer Jo C`5t `x SO vNo0 DPƀC|As Fn/`T@ncIngls (EE.UU.)s (m3So}"leA`$1nt!Ac@ GC>0eo Mod"y!  Bidyi0 Tam&mempIׁ͙i#	si0fQu0{ B,P޳ICA R<k*WLANy{-Bluetoo/th IA  zQyyQhoвergRsGCpoos3B_-PF8{(s)ior)Ethet, N0boo0 S 1/,2/L3/TokR@bOO@`P23 IPtifd Exclus`pᑅAJa@4`   !,a*AC~d`*-N@X0S#ӏoATr)3Vh!,o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	%MEU 6}o	.@o	o	o	o	Ub o	o	o	o	rB8[ 1 :rgR. c% ] /{Am2 c4-Clē3 	0k",B'* r 9ODJ)o!Ѥoh` ~aБAbbl" @zArran@pٓc#uXDᎰ0gEx!`F12QTAmbTouchPaud`uo N`qubaưub  <F1=Ajuda>yrInfoȻsobo[ Sd E@i?5m!HDbβМR!0
r t@7padr0
3r  Ign`air@A	sPs'&_pA1na	nJ4aP@OaDr%&U' _`#Ɠb!X _d#!

SPtSd!܂υ.8liz/p@ʉO
(I 0@!ԇs@/R Q*?g%Ϡb9r
aut<n 4dcЬealha2@o`Ma (QFeOmPasDg1=i0CP8$!leRߠ֋OpT`HoDD A1)r Ɲ VR#Le Mem@A< 4tactu S`MuW^G[⩨ Av8S%,io Qa^d; camppJcinz "o?CA9`essNe qlr wycи'tinug=' SC=CelaAceX imNKܡ!S, Q%ou<=MaikgO Uti0: sC	qqn'	da o i  apr#op@w *u@Tt#<ENTER> t5meRez[@o.Tgut@n9 ^r u:b:  ->
PAO = PrxiK\<-QBACKCExaQE06TABo$SH/IFT+C%* F2 	*:`a=kSC# 9nErrrOA@,Q@na0WoQpڃmRHE. CdigTGo 01  NPhG`,`:o `+f)  s@ viKCA 1A	bMev
;nsf`ZWotebook/ C[(RWS mGsTe2_DKKXqmBm? xitonzN  Ti0HPۀ3VpcS_࠹\ Tahcache (L1/L2ȦFX a` ROM FamlY  N 3sri
RevisSvde@̠_aJroQLa 
Al!D	Ob a(344`Rtiep	JIOeu6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcCq% vfoi"gv@!mO al  WalkN  0e gy1i	a lien!M!oc0I@Advert: 0[Aqo vae!djWAcqP/u,!i@um  gravv
uu:e)EӎA: n@Adc NS3  >B^hO🽠!QtegiEa	c]
vl0IyI= kT@ctezx0eja $,C?C iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.RG.T.ax`=б_(.): 30<`хѡ00@CT =4Q0%?1$bucedeA,qAhosstDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*{erPmec ` `6Q3sM tribߒLD`AМexa@s wQUUig:Tgrg`alTPSLs   qƀL rB+ۤifPArrfDig8cis gҐSAdP)PPЉxacmod!CsާB! fazA@ArEr@a,Πer dfor!m!r3Dn,Pja0.@eHCsHfbrcausadQerF. TbZ Q[e a 㷑2k_rvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%` mabnbP1IY @k,$$al#.2P4sia eiSib0RPuseu sEExigLU`re*PbM0Q+ &perme@$1lp즅+8!CD-"˯gGP$qme:PDusua: Voc È@gp4@la0vr2utzooDriv)e& t@$RUSURIOBG@ESTRE _FSC%ɑ7q<Vapaz:@I. AaN4P@9de-ФrMis PJEB>p"}@.. NNv p[X֣'6Ve ,@V`(_K` 0+abu:*Ƥa !ECde]D.H@f``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a `uuzAoT :aq(2˂40  Àoqur<ǵ x@FkgڲU yaf0T y 2y, pو;) F `3'or nal|p`#a-t
A^ ˢtEsubtu!d C{ ?@ *hR)ppa۵8ptA-l VJ/qrWL !8Z  Lembre ՚vqMac`Pasa8
"qui_se<`R ESC ]ŉ9Š\q3lav'f'rF10. r`r:MrʷTAc]D u?gus Op1k: MultibayQYNc`iFsi reAFpBa byaФcopld(RP diBtzB	Rc"zipcPrimeirV"rc QtөO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMo#aGPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WLAN)` &Bl0oothkAnP2πڐ(a/ Eomeonerga  ere*agBC/*1w62,12oo-'0suЁȰ/0Et#netg	O p
/*3/CToken Ring OObo`Id!fDPPb 3abraT qUSt IsPSڼC!bQGP_NtgemNSrTl1CsrNWDuplo&	ted/	)	E /	fONOOHO'as7AXj O/	kC/	cIAlЏ OO/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% Q]@Oc3l 2:cv0N3:@M* d
 o9ayCJm*O"(sfOlex QScp`xrydapR 쇕 i3Popup޴ Exǐ ~F12( "ߢ dQZs Varava Nu`Ti k yktukP  <F1?=Ohje>PaJrj`PtQt Nytt v0`tu kP Tallenna levykkee !dk@onoP2PuVtF?DFo0ej'unsW Ohק mupA lopQ4Lr  t
tt7f,Tpou@aurlisuinvojoan ssaPMrit^oKynytk La Ityl	
 P ~usnumep
o$-
t lykiu '
,(moPnu kiGa
/!(et  F0.t13!fsBg5*tehd 6OG" t!"$j;A6)ma`*in Tykalu"`A: o9K < Ki3Gvyt?OA9
 @p6( #Mu Ok"@䊢 a6nɀD;m@.DHILishieliHOIk aec o harll10p> H3gQO3'SB3$*3&Jatkinjot  nppՄpA^=d, ESC=Per G=Hyvksy=KywllEi ~N, JokuLB= UYa` fnuoli
mi$p_k b`h%@
sidsN <ENTER> m@t
ep,.I Lgn C0ss seuraavU:A ->PYi VLINPPIN =[s  <-bASKELPALAUTEdf"2!ARKA+!hTVAIHTO+', F2@
)_!~= we@!x<virh`wAkkua e=soi`?da.?: Rvdi 301*kac1pt~ a0IrtPTm pVeyt3ke`"6ko>@	siP.pRlaks`qdpssX` kaC9tqlaa@Q@_TikkI)>skeytyi Fn
i(0P2"nL_ohecaGm|j}~1?i eB tyyppiIn :gapll!VlisQ (L1/L2UA  ROM-Sb@nkohA	tuotepe"ɠsar`r|W@^`si ?stohjab T;{	&!1:"#2o L	3o`M4mJ`L#taAIovn7(j \oa)
 


\	V\J䑷kA'Gra- DqACu$#:D$ 9a%dz| lpi!iEepoӟi Walking 0 -[1Yloso V?aihtoe@ :Puvi7a us: Tm`'Aat0snhp . Jp>lt luo`ŕ}pus-  sn,irjRonc!KA: L"X $AYhkФuV V3beFAG`8p_Cpa 
Hk	oa]Wi !`zn?a Բ`  ҤH?,i`%(N92R`3p.M.A.R7.T.Arp$[n (min): 30s3 p2y0%cL <dv0 Ispysi- 4iVgR
{fb%untq'c{K)jServomoottj
Lau!5ÂvtuQj	k@FttribPti2 З`Žy@a 6eqKxe nGG9 UuVahvu Lx P>Ȕ@! P@Cda}A"+@2 s@a	,-ãPAJ!rn4-okkpDBad`5an 	nDP -e@7p$Rmysba
`kh@`! ЁeT@	dE	ZEY(2i0Xj [!K unQnawbay:p\veapahtum"b@^id FLaJ4ftii l <HP PrpctTools`cuQ`Pger -GapuД큶.f(-/U i` n QuickLockfa hlu5 qf,V "@PraZ&-8Q,:*sekm #o$j$it)a{d||}yh ' PP`0#UC.7>uu	SApor InfrPnR% C[D- -!fl ~QԌV"s ŎPANyjUWAiot;\"nn De"(1o")Jlola.    KYTTώJNI9! PSSANAN,0IBfw.la"q %sily1Mgur R7qg  gri^PfaZꀝAt]r
f$VV-`$U,Ap 8 iwLLAQ0<ѨWZ& OPAMA  Qops ) V
 suE=4:d,#tu@>x	 _4`o'lA N
E  U7lE r
pRw%y iC. Nyky 3b`+mPezsv6Ar
t  N. TmttS`|q$ihveip=upe1rRU$<eh?  IPa*?-@l@wp[1tЋHta1U]=c zAojAaiemlV|3tp. Anm "P$PtTV@UG. 2!`ZX2qїaF_`Qy#А ek rm@o#\X d,aT0ESC-n"sR;n,%'¦e'> F10 ŴY4aQaqw:	o .cVQ llQݠtmiA$ys u"bn MultiBa@Opc&Jlakoiu (ƐenA/$oi>P) USB$@)ZipEnsimm0 AKooelj }Vi@r}Kieit@ְKa0k Y Kymὁai Fn/Ctrl"mhAEng(USMA@UsPs#inla!ǁB- RsఠS Rn1 jPBsi PPs Vo'lh̙t\Vakio0s2sNb#Ig3uuQH Dpl verkko
WLAN-ro'Bl]u`Voth @/HE@h^@sV@Qs	 s`9l@@Ǝ
|+1`i<9.2v+-p	+ ?(ylosp*OG COr5EthCerPn1E Y oeo3o8+To@ p#gOo(@workQ#%G lH1liv3 AGkkuR < TAJq 0ѿ r{jolibr@du c`d  Wual^-OO  OI OK"kb_OO  O ONr O$O$O$tva_ Oi1 O1 OMЩaanusBkO B=O OOM"OOOO
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGoMOH*  j ,9 ƠаBk 1vuCP` ɐiư O (se nA@S`: F12:ٴi@P|%3tappikoskePPP\ 'mmaK~  Ei mn Configurati3ordPteur  <F1=Ap> Fichier Infor vm Aff age Sauvegarder sur diCsqcֻ R@a*r 'une.H_DHeְals dfauow du'Igno%modi Tpqu S$e l'in`p$@@reg om	\ Scurita%
e ssLd S"#j@e sous te Ion.D
 ?priphP %J	a sEIDy'As
Dr`<Lock`q
Smp(C0 Br13r3  'heP5  ,b#a <ۂgre ta R,)+5p7am''us3;),;rfrencM =``t"#Ou@[ !@lonnLb`beriZ sl[ecqSn@psQs AIATAH BFoV,~mmoir`h cBDX C0ZZaFB_V A0c`oLang~4 ChoisPJ: Ul3Ind)!5>_mps g! 5,ePMd.rpa` k2Z}:z?? AppuyDfa7touqpo@gerzu@l v=Ser, ECHAP=AlH|Accep S0=OuiuN*#Q3V, N'impp_e``D
=0aw  UPzi3
s f&'heM
mo!04ecle hmwenuucer@r0wbri2qh@z!y <ENTREE>2nj+W	ss	suai@/fa  !/ :-> ou BARRE ESPACE = PBe`-$IEpreced@STAB`CA*'ӏMAJ+ix F2=1p"w-$!S( rr`@P<TJ Il <FA%ssib2cQ7L U c{s'Jprod{endp#B$P. Coa<'401Rc5CntP@-1 emplgace(L'` D SaQre@}C'y
GJ 
s}^ccuei7l dн "4r ita=xsmobia``
W 	
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ Typ0osBVppwDb fKTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numro8#p	Rev`c7do erS2ItrQclavpoLA}ud @;n+/ZpH/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OO oOOOQBV'edA Eo MT֍ E:$/. g  %Er4 !SUPc;WalkinGg 0ᥒ81wlig'ad`auZC	od  al0ifAtip1S)C[a=e@ptruA ieЪvPR! a/簹r,  z{ nro°c	cY0]A}jDLД_v
 tro Pa
`s
TX	  _[Rvja"`dH.On) m:YfPS 0"Ӏf   +-vaPC lp  ߚV ?? Igno7ꉈ+| z Enregeo#=1_ (rap`)#>2 (coet)u`|pimA(z) B310堿s pAU70% nv$D9ʈl'h A+bF  `䘁:˗	AsGinpnud'+,`v`t
$.Lu( pG3p4 5A`ib!O: IDP00@"s S.M.A.R.=TAbanG2WpW AIBY`se N!=apYepAÐ?/@;sa#A MaYr uinKS ;A, eXecoac	;mme, vK*aad11POobPbatCs	eSd4D	 pe>a1a`(`ih s4[,p@s蒵 `Ug"  formQg-hq#xѼsJ.)r mQފb	hJU0`
1AJ.6zT"`QDP~naR avoupR!AfrCww7A^	 	zY@R`(p"}fbfQd  kF;l2TcgNxq`rHP P`o^ Tool:eRy Mar O4K8CF!/  QuickLwockUsusA |$cpF!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//  / L'(a'a
$S$ud!v
 KP
dra+D hn 4`ExiA-udP `  4raQ8llƙۗX GCD-'EpǞVpalJX
¡:!5pr5Sfe DriveA). SS@@@Ade{z deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z ?I`!@~`E"Q!qhsr @+lfe/"celu&MsDordi`Bb. A W	z(@o@DNU(Co cn0 U@fet#qxI+}M"+t"~"asW"qmoeP: :""Bt qD)<Z=Ianiq45#'Oǅp#!2/r,"c̓û!pk!  3PߍIX!$! ܐ!!{ e ZQM7j]%uelП21`2܂T :HD,g" ""o }a8kE
O' f@W'!b_^w# ,d'originIl2v`O"2Cwa B	uD
vqSaP AQy9)Pt0M`
5djabvps{s`Pze*@-$݁WQa0prs0`Ta aon: top@TP 2ԡa3440pab0yt3ץk'
1uj, appuy
`  ECHAP. @@ OTzR'~o', pui`CrDF10 TapXc 1xCxY^u}	U:/QFrana
OgvACJiMultiBayulBphA 1!3D,xsoca%(ga)pOOFRz) U[<8V USBfQpr
jZiprYP: Dhit@s QuaQCin`NSi;xi Se ߑ  Hud NeuvCD`Perm/r(s Fn/Ctrl`s AnglpSOA) Poprm1`s A@stanPhnfROd'ad`n el!trl:3' Uich1uer&mr`
*d :i@7idoAѫa˭Bid`Ԃ 0 m)mVl@1jEK!al ږ R o!=ril WLAN (rsei{l)AgrBlooth7S/?1 K  ;o`! qg`N loc 9G ``!WnXԏ-b61abP-n o82ooypu9	3ccu@jodogB Ep!t # 1a"23TokRingo`oU/Id!uT6*ao haX  /     h ll` n!Hre0/ x Ab!AC.!f*Du ph*/) ///tb/ ////* *-//8/Jngn$ , /,/ /ce s` BtkexЯsqbmo PO/7// /,///7[qRpe 1 : Char. % ]A.  2D` Gic(M*n3@	Rkio.
* T  @@/M.@$oOAg$Á4Amor1cFe"5 RetardBĎTexp `) Dгa  Fs12tposf[iP+Aux/  PatqbAKw ucun I@z!Nl1 <F1=Aui0>`nfo0\gema	l p'Salval floppy%APttoRipr>Pina dmThifAap`i |Ignor`daed esci EP a
l'iI?z`ciBPŷtup icz{za sswo!%e am C0rato gPccsP
_QC*vos7v% IDs
Ҥ&gDriveLock	LPr`ǃ)S t C7 SupP;  c30 g@HQg/ o+:,i fabbrP
4=i	/.nzi[lOco
ruWi Cb5<b!ae9E`lrOpa@t2;o rigidAEtaA'V<â,a mepT W`<HKJhMiM;A>op !Ava=t Lu!O l$Dim"& q6ca X sso eviQ 1g	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu ,aA Etpoe.o=SiSN1T,altro#	=A bj Us"Schiav~I frecc'!i1`voc<u ap`=f"_`<INVIO>  \kZ\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCEĭ`c<ؽTAB@C%o"M?AIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"ViO  v@u4T|XJ. C{'01 Npu0F>9|a0 Doggiao Lk`IP'0  Q>re0
z4Es"@agga%FvpSAcғ { npabook"RQzespa jT:\ Zf.atp1_
2o{briuPrf udauA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1G/L2 d&dDbROMIamig	lk N@o0H`(D	RP[3[oi<#qSroll TsjrAer ~$i1OFk2m	3n4ࡐ7@w PVSTe)(DE(d)H8
	2
3
4摭<Fonda
 ,o:EV$ THr%OupyP!gTŒ@lliASprB:bit 90t 1ИRindirip	i] `|@'F:AЎso:5X%? gger  `|vpAhAre!0M/rѧ, `1favi PP`1iVYXA:'mYU[A:"m]aconouAðh(_ IIpSɁQrita]+ Nsv@dpRlIQOayളSe3 `voPga	 ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio (>): 30>0%Q5"r6car0䠈'hPD5|:s* Щ-@
˱ ֤(aD୆%aerv|")LċAPLA'	nrib i0gol: ID0$Ban`de@z قi S.M.A.R.T.!ޱuT0U _wordc(nuo!i2 pDsc(Ui%L$?bq+d`ᗑ {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YECr	t>J2fum y3CePe<B #u" _t0s!1a哰.Q]ՒbdFo!erdPКatiwEff+Jizso~@in  ca2i vEvPgaζOdesХ@J m9Yy HP tectTools Od.ZRV2+ ickLockspen`3B05EY mou`s8 MM d?#<#,p  gra@p'!oe  -!e$C-))0v!pKsm@]0x$!! b	,'UvRar i lі@NR(@| ГV|a infraQ)p y)o CD-" Se$D(FVp:W< !SRQ#3ę^wusanD e1&. D6AF<P @@b}W'UTENTEPRINCIPALE  r@*a man4fu`o. AnPV :FcP0rо a!e QB<p0b:0.l@d0Au ULTkZs,^h	Q[m2H sb0R; 3reDV\b.ALN =	 Q_o0%54 dE h=>`@
 >re,0@q  d (`8t rOD r luogo @DF T!B'     #h$ f@ER#:,!vE</s I"I@5-"̿WpHClv {s"k mP0!R/DaB  /$BH@ xQE~a(  ٰa~DA'a( gQ#}QAi  	Pktat{fa+ ueY/c dO::ly&.2nPq!u_{9㐓!.Y)qA`YEsnOP@K1'56h,mP邆эo ESCƚM'Ý)dovQrְ 'n'pom!nF10.  !n!kK WyĴ_6\%גt qIP(i 3 # OA:D0b@ $d5m MiBay baN1.ggas$Z) ogCh>i USB]L$SukbC
ZipBP6ox ;Terz P`OЁvN% ec AН" Fn/Ctrl TIngl  (U'SA) Yi u`2O mpl 01aЃ0R7pl Aaп 0̰Mo@eQנ Bid0HCapa memqX5em$bs"FlD Q2'c/wNPs (WLAN){oBluetoothCommu5/ (j)@sm energZphTp1$0&1 N*J'2HB*Ca26*(0@o)olz,sp Eth0SetW V123e Token RingOE3 I ahbyC@B@taI   aAov  CP/Ab// TDz S^oo  YHiPDuPT  / o  6 / @o ,o // ooba c   / o 0uY\mo9 S//-oo ooų///oo[{ PAs 1 : 
ro . @% ]ocomQp#2S '4,n6E3`
ij* 
 @/JoXaX/3i'o
   FloppybUBAİIAd c`Ƭ@~(sec.)C velP`F12b 2z8@amb`Nu up <F1=Hjlp>@rkiv Sya|infEot 0s~ S pkt%kigu 葐 >( stll frnl1n@ard Annuaa nd` ochFsl  anȑ Sker0 dPRtrslpD  K!aOB@rt-OaEn ss	(b -ID
S ao
h`tPd-Std frutQ !av 7K
byggd 
 usBi=*abrikP+ |.J
sbeh \#DEsktsrktyg Km +r vڐ S`;vtܱ0HDD Ak_V Minnes: $01 q5`?@An'@#B
Q  VljrD;cBnedt
tlD!v(C-j+eTryQI fri Dg@q nr du viJPsӄt0x X=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil	c	/pCa ҐyEt
<RETUR> om6
YRtt .Zie,lj`SeerI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG F?regey܊K TABf#OKIFT+`H& F2`0+?z= 'fO @%Aoi?Cf{el 3t gqL` kA@t Ah+AO` D?stod uGen. Felk0197 AsgF{P|plat  NtPhm krv3?A @pbygm0 wfly5s t6 -dator/r ex$(|0Ytid#igooi2-@Kkl`TA UkN4,  Pr Pr, ty=p
hast^hZg0Ca-	rlek (L1/L2)Yd ROM,tum ~ familj~renummn0D^deo,`r!Y ttNb ~pqyrQ!]H 1.z2#3$4rbinvp ˦3 (bZ)g	1[
p

Sek#	 xIrq.ْ4$@gaxr#%8Ex!z=ok!ŰvidClmissl l.s Walk0s - ~P f1jHހ Add0s Sli7Ae ݺnVar! D@/ѹ  7neh g"CcuskaUpay /G-tH!ڱxiƱ=k ab!h$2AA:1R K>#Rhi{wIBB?skyddadag

  ބ Eˎ҇A!^Ԉ  ȅ|? ig?D܇jGa- 1nGabb8f@Rn`X9UWk`ad k$pQd (0): 30@npan 2?0%bX A4Pp/]spp01vr katPo:,t	!قOk%S(x ervo-L zB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 OGammN u\7 ifin`@ D> L܀Q R4d% pm}vlika m0Ǆ  'InE?kan orsa @3iЈ P9aHSsNypPO@Om=<s1A61lo. 'N_a om hߏglmabtj@Deh ;elCse- @^uQDuayVq΀Φ >fun 0`perl^7!i HP tectTools%٩R-6-Quicka"q`telge Lp׌mxPs Hg$k
gppb*_- &q2@&!џ!!r ngo"pKF5b#li`X!aot. Kж7AoimpHi p@J1f   Pk`anCD- pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsd D`}e. .Ч#`}a]r ANVSHUVUD!`{@Pmaq+t W.[  !q>`KՠρQ@ild fr 0!+A
 GOha0w L l1փ'lGSWN.X (oF XAd/bbygg05P0 g`2//b/dY5- F`bW:omC eB
7(b!>=  >Dq8asB1GcpgCZ@ktu0ai`Qaf%anpkp@.Fut!L#\#tg`Rsp] Vo,sursprung_cJXJ. Vi  reko@ t2F	B}c	Vrй`+,ps`_b@}. A`K4ɡȤ˄3w_Bg  &Ӄg `!(g}AyO-beflse qm ihђflj1ens. Trp  >ESC-QBSR Vw#`'Z'R-sedMtaGF10@cVi3a:+dD1}shxE ASve aq 1: N?, MiBayCrut@!}oppBP5vi Ba L0G (Pr̞ (h aSB G Zip-=PW As1Fj!Б1 utKto NT VxPFn-/Ctrle  E@ls(USAbmYkd` !AA b`nrmstrorx+,f hbbelorlekhPeo2n?e Flkp@aLPaIfڒEsio"trqtK (WLAN)Bluetooth p/() -v@ANѾmbe Agg2гs`haE%-21,2v[,pp$Ned Eth)& 0	3n To!|RQN "Unik '$<QiD K >@tus   ,   S"bo Kalibo  dp{  F:Dual Q.O
o 

  
9
Fo@ 
E 
D0!j1s
Aoo
E
Htag *o 
P* 
VCy emol]A*5oo e
DIO OKood
D?[Ne _ :w Lapr . 0% ]
kWlar2u j253omFjOFA* &V@1  >I*O!DgOߧ̀U«br@>4sadap@$lg rdrjQsnabb0 (sek. F1 Bd S'tyrPguen!he( 0ae/ `P}Op e@slaan Conf'iguPpoanafpvt ardQ3!/  scy	WijzigS%ne@" programma @٠0Setup  zr w ؃Ȃsvei !Behee rswachtwoo1څ
 p$X. Ap OaatbOgl>$$ ID's 	Smb4CP p OaBu3P$PcR%mj+%O
Ge0g3 gssvzie2؏"Fabriek9s.Cugz7/);Vref|.s:nieuwBأ8ONc  E{xtAccuwB ZeN geselec Ea  es  zelftGa -schijfueai`Act PPXvG0u ?1I R!a/H 4UBgDAcg@7n ,DP=%_
 w 9aKc!: alaa1l =r/em 	rijsgemaak el;o" /;9
8ukAZ ]0ayMLg]@f=S, ESC=Annul"EDXG0=!emJacNee} fslui@Q, AQ-f`=MxNHulp?pijltjk~p`gebrui:0d )jui~Pw?nukeuzk@ark^<ENTER> ind 0
cr]beZo !vol%@@1  0aiX:  -> of SPATIEBALK =><-ޑBACKCE>Vorigl)TABb	#EHIFT+%%ܺa2+Kq= yk p=t#B~fouta64k p It w_ge15 F0M0r]eqatijasFoen. AcoZ01b`a0.il1ZCu  we   Netvoe are0#FMPNp diVbas`e3
 t n0 notebook-pc/RP @.istNOQbep*igdooh2 L	MЛaft NmpALyp6rocessnel3Q spp OmPЂP}e (L1/L2`Zapac?i VHaRWOM @ -s!fS<mm E  Hebvrgav_0ideok p&p;b bpM	m	ra1$b2rd3e14ahisJgI t}.jnAe C(_B(Љ,wMdzQ%) 
 `D#SecuibE. aw~~$Ftb%)҆2!dHU2L583Hac-0-*1Tho_a_dresrl|afwis_nd paoz=LTop: zbPt<ts e'ge t PLSBbeЉf ڇ s d1 A:og-  / ޖ"x0zbLe6`NoffaG1Y\f_dقڑD`ѱ

boචgAt
wOC'We nu duъ"
wil?oݩ(""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30 aee&p:L;0%Qtoo `4;q{ho:5broA):]eeqx/nb!$32#kvo-IPs EI"
2`"qk:J S.M.A.R.T.-af@APP@udh "/tBlo0!  A  I-7B4kXqcr lpSX8
 Vr!a1& is bBs AYoCf#Z/k, Tm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$% uswb sqwYfur9hou
d'Hi`!  AQ`R`T`R&BеѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gsppL`b TWm E #M"g$rgΠ9bl   ~erX#W>,.o(h( o( S("7p'EAJb"f k otraakP)5w# sXbtK;?ݳ ]Qŉr p1׀frap=d  Parxˊ Cd-r 7HN񸆆H/oofd8UGr@JD  UQ0w`fbia D1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  p"an< SSC#  hbwACI t fykgcompS$ajsLQ}ZP$t d 0Bb&qӜ. @XPpQ~^zAutompJc 4 9	yT `r:Zc@Y<<|7t7 O!V)?!9NP sN! !. Mo WdLioNTC1,p@  #iRS8pò̀QU nt@@Odq K/ # `hui,50d@wұwas to/!k; wgeaГ. PWVAnvloeC~XBkhWSs0An@Pܩ׍zYUT2r!ra=8	h2 torHh/)К Bget. /o
 s  vBn. Om2un
1]ѝA&`3fe*& gol q. AAܹ_ӱ_, cdtabҔh! Dcㅻp3ruk3!ESC- (A9н0 2i Rjb'k'tyUvbkn F10@`T*Z䍀lusTB `r`V4  Neplg g MultiBayjVzkd@\base (ks)re  USB-Մ cb+zЛp- ER we瑟V V\@{Zes >Z>Aa8NF?n/Ctrl `Owiss/@ާ`SStaMcW3MijsappĠOU e 0 nгlBij V o-1PFA/A뜂0d`dition S G`vgp<uqVpilatE?Bvp neVd$Radioj WLAN-aoeB/lueth/oG`rgieм@ qYI1[&,(b!)ۏ`Et@0 I1
2
3fTozRa/- OMom@0r23 UUrtcu!G< 4us X    Sa?Gekali@!тOK"r2
qNQc ualP \JOOO E WOOO[B['OOO H{ap !ң
O$O"Lpier-MUE-$J$OC$ Pn+OO+O  [jp? 1 : Bo. % ]A/&p[лd
2knte~l/{	3	#Ʉ
 fohl/)1* Jt  ;@>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12 )Kbb@ cursorytuyEasyPo-muisG Rs[^ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\ܻtsfBNۑ  ݃OCOF?畜Ăg&uf 
H
gɁ  HoO׎ 
ɖE	ύXɏI  `AȌԂ]܃@e
a L(eA`LCǗҫp h/do'o "X yf@\̗L/E%ID&I}D: h (
uN XBSA$͍w폜eX} 0g J 23T|OHN, v ".eI*"%ɀ;^FX
 Ϗؖ>f
cA>oAe̒  I$(f:nA%e>ʁ pCeBIvCۂ"F@ `F  H  D%Jc9~J; ڍc R5BM NnP$߂A2%E@U`UO tB!#^sNu% .37($b74L[BR_ af=!AEsc=C8@bsAS60=͂|
  aRAg)gjq5\= 3gp] jkڂ %iA@gp>[Ex]  eȉ#wA̀r_->Epy`tOo[ = ET  <-SG[Back?Space] a<%[Tab!AG#[Shift]+eF2`!,,,10^nmF/[~%  !CG[  ӂ@DBCłͫ}@BDrp o 01 yNF`+@~3a
ɂACOk ~ڑKWv@&eb r?O x1X
Mp!mQ^0fGdMEU		Ȃ2^e`	］уɰޯ   ۾  xïݸ  ށiL1w/L2"`OM OM̧Fٔԍ  ޵ ޼ޮ ް ۰ׂ޽ޯ ްir ޯ#2.3N4h	 pŰch3(Â)FE-3N4@(JkvJ _!nFw XcopF?$qv sPxП6!;LsV+Walk0s?A-1B/Z hɌѢʎp^`OD4x:2B>tƁAC %C颴 ׂĎhDa/ŗp쐬AFA:݉ b#}v!h F FSPl	NXWM֎~@YqZos /9@y(c  ցB	H #ċ g Oog'`,گЯ1iNp`2i׮S3p.M.A.R.T \zsԁi?j: 30Bײ8>v0% bj~!c OK z3 eB~ f{:@	{em`cQ1kT ={ǂݨUעfIFIDP|.B a"R`R AFfV!'/i `¢k@Ρ dAJg(B(a| ͤDAJhvٓB"Ǽ /  Ǘ@{R@rRVdNJǂ̂C*p4qu`@nȂaU C	 !]ţࣂ"^
YOꍇcxei!ݡ£	龂 ÉƂ `Ƣa7df!tf
`?"dHP ProtectTooslsh}lWŒǉTBq#j,.qB4УMmN*u<"T h8' k{-E`O'O H&J8-.))Tی삟D<<D%蕴` g@4`dt!~(!ċNb8v"Q ԊO GPu CD-pu$(3H\Z@}@^ 7Q: axUKߑ #iC^"c.t%``y x7"	3W@9>Ā+ VAT:!eN,Bi	.	i A!!F	ێ2R quĐR`s񽿂痣HSCˊ"o"F@`pAF/'ưAefw`6W 1E<@9߰ ϐXP؊ԓ "łb͗WL >ił`Ȩk)/)%)!?ƈ UCX3oNu"* fBBFa(o(0e|~!@#$E'm8`X ( IO)F)u
 ((?(9(gDs}Dv#<43ɑ8ƈ	{MS f=ɉwe|^
`Fa)TF1j 8cB3  BgBb{aȑOB%O#&H 2ef̯"8먎ql`ӔC aU$/g'"wEE[Es3c]1 쉟`}ȍ~elaӫm⛡TN?DriveLock t[F10a M:S   y_97~狃`E!': ESxtkGb`ÓO xXiǶoiEcUSB Xp H Zip1Ԗ U2b 3 4"5U67B8910r Fn/Ctrl%̐ؑ `{`\p (USA) `|*B#fo+X
KV&Ws
v Cn\g @}ZJ@_ rIo`̢ Wou% тAwCY OڑͿ̧Yal"Ni!LAN{j%MdBluetootH/cj!`ߓd p
 2Intel  Execution DisabCle-@++12)2)++odhEthernetX I123w g! @p
AOKO3O  >H!O Dj' ID 4b`K AM?      ϰ᮸`@f @R?ke jZ o \(%*nP/h /!!!MEUt$ )oz oooD2s!5bv1 : [d . % ]O<2 !gOv3		)J*    5`$>s'pmj&vSpeedStep@ technology
u'"( 	_Ħް Ӱ # px(b) 3F12QԁibyR a ^`PQbZB   @d                                                                                                                                                                                                                                                         i  ` a b c d e f gt" L  x    h     	 
      
                 "         V         / 0   3 4 V 5 6    ( )   , -   * + r  wmp
 N ]% @.   mm $ + 1 8>E K RXm *`@E<BB<U> FߨE0`8l v x|v||~p0p7c   c _0A }  = ~ 
=$$$<   DDD    O aƄe  i  o u  y @  n%Ap E%!IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$~: |  sډ+'()+'* &8F3&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 rdmxcmRa em?gm@@p < f+m@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
| 	 
U`	
 `
U`
fabUcDdeDf4Ph(>{&_N_m`@  U  @ڀ
 jް( 
( 
r lR0 |n }o : *ݖR  	mb $ 9 0
 VF10 Setup Image_SETUP  !D	Sq  ; 	Г *v@HJ$"P a|`j 6
&$`ZԩC ؄ TUԫTԠU*<g!"$Dcz: T'ᴳ4㴴U4崵d紶U4D8b_ : (m
6W  ($))U$**$++U$,,$--W9 -gW  0	`
9 
E#8Ui3jG@ Ƕ#!" #" #" 
8 RMNLNOO 8 @
:	 
@      /	&Wc  b" :   %u    N'U'!(( )UO)P*Q*R+US+T,U,V-W-X.3V
Wmd-dh.hU1dii2dj3jU6dk;kdlIlUYdm@mCdnDnUJdoEFdpGpHdq5 ajmUfoq$HrHs $[b{̪{`{|`|$|`|`}}ઠ{L`}8}B}.* ~X`~tuK wxU~z{  }RH kv 
44(3)]BxU`o2您T$\` *䇧0L'\Ut ;U
敇d N@9 ڠGxTnaLR@ \ b v @ L@ @ X z @ @L@ . H T j@~ ( ̀ L8@ R r  @ @L,@ L `  @ @@ B Z t @ @L:@ ^ j  @̀L2@ T f  @즀@ V zJ  @} 	L@ U& : N Z@Udp @U @_
L*@ B UV n @U @}L @ U@ `  @5  @ U@ `  @5 
CU  . J@bUv @ LU@ < ^ ~ U@ S@ H \ z@ƪ ր@L$@ 4 L ` @j @%@ > T h @ @@  " & *@.6P h@ @$ -@ d   @L0@ Z   @Ȁ @ ,@ Z j  @@1@ 4 B P ^@fr~ @ @6@ N x  @LD@ ^ j  @UB p @̀M8@ f Ր  @T7@ Z   @C@    @@,@  0 F Z@x @ʪ @j @ @H@    .@8@F `@t @ @Ā j@
@>R@  J6 R@Ur @Ѐ  T)@ F ^ v U@ M@!@,@ H Ul  @S"@U@ n  5 @# 5@ Uj   @S$R@ f  5 @%@W@ UL b  @ AB&@T@ > N `R r@A1 U@ʀ @'TL@ 
   %@A2 48<@V \@fv`h|* @ S(d@ p  5 @)A@ UJ `  @U @S*W@ H ^ U @ĀS+]@ Z   @,T@[@ > d t U@ M@ -@r@   U0 N ^@|ծ @.Tf@ B P V Ր@ʀ/Tf@ h   0i@ r A	 @1@W@ ~  2R@ dR x @U @S3h@ 8 D UZ j@5 @ 4]@ U( @ Z t@U @
5 k@ hhhhA@@Vp @j  6"U$ F f @վ 7}@ X % j@؀8 f@ J d @* @hS9@ l ~ ՜ @
:T@ 6 J z U@̀ M@;@m@ . U2 6 :@@UJh @M <@ d Ր  @(=T@    >@m@ 4 h^@z @? @  j  @@T@ hB Z t@U @M
A@ N Uv  @S B@ t  M C@ z 5  D@ Մ   ET @ z   SF@   M G@n@ z հ  @H@ f hr @ @I{@ D T b t@x| @ @ @Ȁؚ J@@ > H 
hV hv$h@h վ K(@@ 	hJ@vhդ @LT@v@ p   M@M@  5  @NW@ 5  4O j@ 5  $P@ 5   Q@@ 5  R@ Ր   ST@ ^   e@AB T*@ B R ~ hA1 @Āh@hh&Uh
hF@Xh^T@fx @U @M V@@ :@ Ub ~  @5W@ UN t  @ծ 
X@ D d x@ Y@ V b v @ Z@ P ZR ` nU @ڀS [ @ R l U| @5 @"\@ UZ   @M]@@ ` Ur  @S^@ l  e @_U   4 D@U`x @U @S ` @ , B UX l@~U @̀
 a@@ hhhA(@Jd~ @ "Rb @ f  U @܀c%8 P d t@ j@ d@R@ 2 F b@U @Me@@ * : P@ @J @hM f @ H U~  @Sg @ j  M h @ 2 )V Ђ@5@
i J@ UH |  @j@ . <T JVd U~@ 5@k@@ Ub   @MlT@ Z Ն  @mT @ b   M@n@ j Ֆ  @$oT@    SpF@ Z  ծ @q$@@ \ f Uz @5r@ U( 4 < B@UJRX `@Uhpx @h @̚sv@ $ 
 6@Щ> \ j@t8@ 	,@Hd |@j @u @ < `  ܦ@vF@  ڦ w@   (x @   &y@   .z@2@   8{K@ x   @Q|@@ ABJ \ n@~A15؀} @ "8 h\DhJ~Ж@~ @ʀ@~T*@ B b x զ@ĀTN@ J `  U@ M@&@G@ d Ux  @ȀM @ N n  @hj @* *@ R f  @ ֚@@=@ F d z @ @ @ H h  @ր@S@ ^ T h@SI@ z  Rh@ ST@ ( @ V hd| @ @ e@ 8 N h @J @hhhh	hA (@>Lb t@R "؀S6@ b  % @h%M@@@ < U`  @ @h 8 ^@l @ʪ @@@ f x R @h AR hh@ҀMr@ X Մ  @TR@ f   5@]@ UF n | @ը T D@ \   U@؀ &h@ * hU> L@\5 @@}@ U^   @M @ ^ Պ  @T@b@ b   5@* @ ~   T@ l   M@f@ ^ U  @S@  2 UN ^@zU @ j hhhh@*0* >@PbhIz
ЄМ@Ф о@ @ P jT Ђ@M  7@ > U\ z @M M@ L t  @ T@@ h   M@(@  5  $@ Հ   T@ x   S@ : b U @Ā&	h
@ : 	hX| hhDhh@h
@ h >@JRj @ @ r   @@O@ H ^ ~ @ )@ D \ U@ S@@ V ~ U @ƀS@j@ > v U @Ȁ5 @ @ UL f  @5Ҁ@ U< J P ~@ծ T@ \ ~  5@@@ U@   @S@@ Z   ؀ @ B f | @j @Ī@ ^ ~  @@ T z  @
@ hhhPA4@RUl @ƀ5 .@ Up   @M@ R U  @S@@ H l U @ M@@@ & U: P ~@5  @ UT n @ո @T@ < H P MX@&f Ur@ S@ V  5 @@ U   @F @ d U|@ S@ z  U @@ D ` l @̦  @ \ j  @@ ~   @ @ l j  @"?@     @@ J t  @ @@ n   @(@ d R  ЀM @ l U  @5 M@ U  & ,@U4<D L@Ufnv @U @
@@ & h4@P x@ Q @ 	P@zU @S@@ f  զ @ހʪh: f  К@4ˀ@ j   (@:@    ( .@    "@/@ v   @I@ F ABf Ux@ TA1 @, hhXDhht@J @д @ T@@ 8 X x U@ S&Ҁ@ j t U @M  @ Z n  @Aʚ  @ J r  @Ꚁ@8@ L v  @2 g @H@ U  B Z ~@ hF@@ hL UR |@M ؀U@ V Uv  @S ,@ @ n Պ @ 2@ j  hU @M@@ 2 UB ^ p@պ @T@@ N r  5@ H@ R ~  h@hh@5Ā ހ@ U4 J ` @ծ T >@ 8 X j Ք@@@ P A%^ @  @@ : P f @j @I@ ^ v  j@ր Ԫ@ @ L b l@t~ @ Ԧ@
 @ L t  @T C@    @ @ hU8 N@x5 @A@ Ut   @Āh @@r@ 0 > P ~@逦@ j  Ě @$Z@ zj   @\@ j   ڦ@Y@ F r  @$@}@    ,@M@     s@ NJ r  h @$d@ f ht hh@Th@ j @ < ZJ d p@
Ѐ% Юhʁ@@ hJ   hM @ j U  @S
@ R p @    ;@ d   @$@@ j   @ t   @ l  К @"@ \   @V CB 2 R b@zA1*h 1h h
hI8@h\k j@r @ @  @ 4 F l @ @ 0 V j @К @
@ 8T ^ @ն @TQ@ ^ h z @  \U@ : R ^ Ul@r U@ _\$@ > UV p @U @_\0@ F Un  @S@ d v Ւ @̀W\@@ v    @ \@ . D X f@ @"\8@ N d z @ @\*@ J
 \ f hhhPAp @U I 
@ 8 "^ U@ }@ 	\@ %@ \ %~@U @ր
 @  0 H X@hx @ހ
\&@ H ` v @j  @ 2 @ X h@v @ Ծ@
\4@ R ~  @, (@    @K\(@ < b@Uz @S@ v   @ T-  * B UX@`n զ@΀T@+@ l   M@$@ P Ux  @S (@ t   @$\UT@    S@7@ h  } ,\L@ |   T'@ P j  Ш @@9@ N \ TI U@z @ @ª @A@ * H* ^ l@z
h @h AQAC@ @ R j@ 
@"@ Z  j @9@ v   M@׀4@   8@   @ @M@  !@C@  Ȧ "1@  ̦ #@@    $F@ Tj   
T̀d>dN e`@ehA1@%P@ @ hjDhВJ @ހh S&:@  * UJ d@M 
'5@ b 5   (@@@ U& P r @պ )T@B@ N b  հ@ހ*T@e@ \   5@+@a@ UN x  @ʀ ,O\ Ȁ 6 UL p@5 @-@H@ UF t  @5 .:@ U^   @S/ G@ ^  5 @0j@ |   1e@ n  @ @
2 @   < L n@ @3P@ R p  @ր)4@m@ V j h@hhA~U @΀M 5_@ L "j @6@X@ N r  @7@U@ f  j  8U, X n ~@SL @M9>@ J Ub | @5 :@z@ U> T v @U @U @S2;E@ v  M < @ | 5  "= g@ Uj   @h>@@ ` rj  @0?@    2@h @ @ U&  i: T@t 
AT@r@ h   S B @ l  5 @$C@@ Ո   DTd@ |   S E@ V  5 @F@@ Վ   (GT@    @(Hl@ b x @ҦI @ P fT v@U @U @Ҁ5 @J@ U B j @
Ю ؒhƀ@L A K{@ r   hހL@@ `   @M@@ X r j @ҀN@@    2O@   &P@   Q@    <R@   &S@ d z  @ЀVTCB. P r @ eA15@U@D@ ". hNDhf R@ж @\ VT@ T j  5@ W@ UN t ~ @5Ā X^@ U> J d x@U @MY @ Z U~  @M
Z @ L Un  @Ȁ [\U@ & Z l U@ S\ @ : J Up |@5 @$]@@ UZ   @M^@@ J t  @_@   
`T@`@ 6 L X Uj@z U@Ȁ M@
a @ P Uf  @5 b@@ UT t  @5ڀchhh	A 6@Zx j@Ѐdߪ@ R v  @e@ F l  @L f @ 6 UR f |@ U @hg @ J X r @К h@@ F d  @ @fi@ &  >@\j @jЪ@ b   @2k@ t * @@րSl@ L ^ 5 @
m@ Ux   @ƀ @n@ $ 6 d @o@@ t    p @ V   @q @ z  ަ r@M@ r    s@@ `j    t˪@  @ Ԁ u @ n |  @v ( F l*@g @Ù @LL @wT@@  ( 2 U<@Jn @A к$ hԀAЙ h,x@@ zJ   Ԁ5 "y @ U\ z  @5րz@@ J d  uL@{@@  M (| N@  M <} Q@ Ā S
~#@   S@   S.@   5 @ @ Z x AB@j hA1B N b@DИ@hдDh зL  & ,@>Vh @j @ T t  @  @ 2 < R* f@@T@5@ V r  }@bYL5 @@ L ` ~ LД @Ā  3@ T n l[ @܃L @$@B@ \  ƚ @"@    @$b@ p   @^L*U@ L ^ Un@ U@Ȁ @C 4 L d |@ @y@ A`L
B ahhhATA f@ @@ "U> b @վ @@@ 8 %Z vT   * HJ Z j@ЀU @؀S@Y@ F T Ud p@Sf\@Su@ {6;GeL"U*D `@մ @T@ h   M@@@ N Jhz @и 5@ @@ U\   @  * 8 L@Rbp @ & @ h  j @ڀ@ Z   ئ@@@ R |  @)@ n  AM@ @  ՞  @&T@ p   @ @@ J fj  r@TI( @BrLR @ @̪ @@ " 6J{L>@ zL
hI>Z hhRh~Т @E@ F U^ v@5 @ q@ UR r  @5΀@ Ղ   ,@@   T@    S* )@   S
@ ~  M ( @ b Ux  @̀
CB* <* L \@hA1@L  h
"DThBPV b@jB R@px @ @@ f   @k@ 0 R d @ @@ X r  @ހ@ T |  @@ P |  @Āښ @t@ 6 F b @ @@@ $ H p @Ȁ@ J h  @ @ n  ƚ @@@ `T t ~@U @M@ 8 U\ z @ @T@ \   @ހ@ 8 hhhШADf @F @ "N Ur @5 @@@ h % @j  U0 \ p@ h@@ L d  @ @0 @ r   @* @h @T@ p   M@@ p 5  @@ B j Ж@ @@ F   @@ t*   @Е @6@@ < f  @܀ @ Z   @0@ xj   @ l   @ŀ@ ~   @ dj   @6@ t    @ H n  ЮzqWL@Ъ@ 6 B  T@bjr x@ R@i @̀ T @ > F L *
Z@r|IТ@AS  @ B X Ѐr 4 L@@ D f  @Ā @ T x  @@ `  j @$π@ r   @ @ Z   @(@ v  4 AB@ 1(D A1T cJA@h hDhhЀXUkL\@@ U * 6 @@UNp @MЀԀ@ H U^  @M @ < UX n @5 
 A @N r @ @@@ , < Z @ @ @ ( X n @j  ݪ@ 4 N h ~@ Ԛ@@ H j  @ܦ$ m@ h t  @ڀ
@ r   @̀j @@ ( 2 : B@Tbz @ j@ހ@ 8 J \ n*@ h@hhA 5@0@ U@ `  @j"  @ l   Z@"%H )h A%@%e @%m@ P l  @ @ C@ N b x @К @ $ 6 N T@Z`f l@tz @ I@ \ h @6@    @
@@ T d v @К ,C@    @2h a@ U. B H \@UpZ@ ΀ S\ 5  @ Uv   @S*퀠@   @@@@    ABB +@ n   @*@ j    @ R ` j 0Ђ 4@
@ U. 4 : @@UFLR X@U^dl ~@U @Ԁ 
*h@.4hI<hR@AQtU @Ai@ B \  @ @ Z ~  @ހ$@@ ~   d@ ^   @ P@ j   @@ v   @ w@ T x * @ҀABS Q@ 2 D X l@A1J @̀@hDhT {@ : H b ~h$PnPm/  /      8    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Ts# hNfP u	fX)  h ^UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"f,  ,fUvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:tw'_^
QRfU

}0tCR>tK-tE$fu
0t0t	dpQ  f]ZYPSRi u-Rr-&-sG tu0< 0
Ag'fA$. +"(zwZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	P#X,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>8A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _u,# XA	u-->1&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7ӥi({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/	` 	R
~>  6P ې  f8=h+( Q   f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\KuO@S1y?"莡5`,TKuZO苆FFKu FQ$-$G^f ? @s++g^D	%ÉD	f8Ƨ2+f<v PfU IfPIfffa$f6f> f	>fBf@)ff]Xo t *̠N9ԁf_x@R@Ӄf;3 ZpbЃ> t50 A0*@@!p0 U
@ҟWRV6H 8f;tff ' F?#4?/$u qcf gfmEˀ>  fù fQ@;t)ogf+ C k#@`CW`Lk Ѣ}GÿGPV0w  ^h0 ;u}; ?;b4P4SXf.0Xa0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6Tg  z	Ad  !
؂  	 0 ! #n#   ˀ  _ " 2 r	 .>  B
   ,1         K   S
+`,&,A!Bru
7>, o  >  t,,,>,,uǾ ,"_< tC2`r,_Bb,,,,gQ	`PVB`
e3ۊ؀`,&~-,;-g3 M,pVS`@t	Vm,[^PQVߠ,0ӊ"@ӈ9,1,Wf u5uqyS1-,߾5,,-[^@sfU_>
-S>->-G&-t(
ߠ,bވ',%,=[QpQxVt>,, r1,w%y0r ",60}S,  gm6bdhETe!)) `!Q	pDt1,8h[R-?r-&-w, a-PRVqp!)7p	* 3:  , &},g&&@v@ '1&s0 ,i>,y $3P߶ % u> &j
'
u$uvatue&u^\uMu:w
8FPu)wttfpF
= IL^1X@8! u?	g&AFtF@s|S,X[0|SRV#+WC^/'ۊ»
1>qZڢ,A,I,Q,Y,a,i,2.RtvM,AW>pI,SRA<v
T-,-@,ʀ 7,G^&r )&uHIS	
I",,,:,w/=,!g
	߄cdx
	,rg&5tU,x}r],_dr!"E,FKr
 Jt x Ztĳe,=2oxL13
	upePaD$[Xހ[Zd,_@[Î@[,_1<ѿN &>luBSQ -f3fÇ2̓A,fлf3 =0^]-dF E *  <Fu-3t	 Dt<Hut25t5 y2$u tPX- }- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2rt5>s5oAbqurY(q#VWpptAQ ft(PǴ:-Ou 
  gXfCYv q9~ w2-k}-0t&-^8r ۀ>tw
$_ ,-9-2 ,f? t<C<tSQذ&Y[0u
~lq.u     	`h 9W0  q8r8 !^ !;   ([[\.Z:;BB^RSTT::; UWRQSPV 
rw8t ur6ffWRfP0 eXhɤLfZf_]+8 wƶ8-aPS puxg8k@i8l8c8/zmn~d8|poe8D[XF f sf Ձtf 0-[YZ_]e È88 aQ b8Pj0fd1u!8! ddfdm԰  >P6Sd ddSP (88fU{t=T=f]t,>@u%ttt t	tfN @8tF ÿ!r@uabl!s
 1Qh 6*QOu߰Fk 08u$*
SfQVێJeS 0uiOrt*ـ?Pf{D`*f of0T ff/fXs "qwy#upELe~8 v` 80uYk׋f0$ fe~8OfWpe*&~88fw*fF*2t*܊e&8fXfY[f`A_-+',!(-8  ۧ`ܤb "u!ựv_8yW t8!WfaSQVWU&- t **i]_^Y[LS-120ZIP 250:1:q2:r2q2PKp x
}
\5	f8Ls!Org;<tV< uWQ<f<P\g&:D=FfG_(**X!X  fJA`u x8ֈ-q8k8r8l8c80 RW1h
QN}0E?U4*/_M-Sys   DiskOnKey 1 #azB-u @  f<x fP f0Q_>"~|= 2r 0w"1s sU3IH tqR ff@fPuLst6Lu2r{	uABc\,f_o PA rLT*f<?PmRnRdVPeF5Qome}\2**;; t0hDt;@ u`^gu#3 Af?LfH@P 
fXuײ?D0 @0|B0B0pJB0oB0eG05F6F 	 *ϱ*&3FPRrco3W1>ߊ#>;!2>
31_YGh7Ph`p& 4  ߰hE+< bZpW+ 1s!$?
uo$˄[         ,X @x
dY rTBB!sh5@  i|X  t   	bho4<fHffBf[shPJf&
dhL\uf
{dw&f  ffBfP  Bf%ꣀ% @ BBf  z6fBf=A&  `  fAVfaDf=%{t 5t;@3tZ0tZDfX$0g]=C  BIǷBSf@ t|PBo"sƑ tDf  f qBB<Bf>B u ` _D  2ft.sh@P ~^#rfu$B@s11 >B@!R0B'r"b"0 f!1VC@f,S	  tX	"rH'	"	0 
%9 uf۹-%tVq00 ZP3BP  	PB-tsK '	B -  rfY 
 pQDP؊*oB@6Pf>BgGf	gOg>{G]`0db>۟,"3	0	ȭ`6@#Du	%&shf6Bf	f BfIng^g~W!
^*t4 ?0		0		{  FFhjJԆ<t
 &6H5"p+u
 ߙ"؃ C0H&2HB&4HqN&]jbL6%@( Bf (f 42a3ufBW  bfLt0awSgff9Bu gF9Bu 9Bu
gF9BtgNyXfFBzr=БC=0rxiGsVfS'`c(gF'	Bg^ g"G0gF: V* /e*emd&b&g&g&G
G
 d0wGd*PGg&Gg&G
 G 3gn Fzpp5t	f AkG^ 0\PfV csf@md{f p^fIf!B&BB+B(B  B < tB  ;vȉBܠqv  f@
Bqygf=gG p ,gG
	qGfu"a ?Hf%fE@ !gG!&BB t@bk!f#pFcnS`_Oâ'PR7з[fS
fÐ35f$fӃ\Qfp#{-  !Siy Y9At ````a`b$	`c	0]	0^8	  
		 
			 				
 0hfWQf`!Yf_`QD=ft8D=s8MD
$>i8%
ĈD
8 r% >s8bASgsL8rI`d
{Qr7R@|= USBSug&|= t t
U	 	`8aTX 8;Oѡ p arQr, C0( %rP`8M`2P߃>8t QrIt2QfF`AdYrgSf1WfM^!WA@MH\
؀e܉\b: H
p(rA
x @
`0
!?
0
"7sTq
aWah'"CS# ~iD=qp*W.?473'PT2' oZ(Z
2(
_7
_=%t9 R$RS$2Q	@ ?XR!@RP2{ 3* >*?Ou ᠅ T=
yXS<(fT= & y#j688 r}fPQtA3`>~8~8p+` pta^Vu6 8 +.\Rf.6XROPpYfX`XRI|G<b8 fa9?,B3U+*/G/%QfPfph`1@YfXY"N0\ՐJ?;G7/Osc`MoDABA<e=S$l=38%rp/83Ot; QOtG EOtS8D$
ƈDFP!r r
9rYԹ /p%tFܳPtt=tT= t2:t+u:u hNodty(u~(rt{^@3O=@tQO=tEO=`	t?O= 3Oh)6`oXaPSV88dtd}wLѠrFl@Ѿ88DtD$P}QM'Ph!Ѡd^[XSQLO	8t`g	G	Y[ ;- i8 ߐ  ` 	 8 h
  c 0p   q
		
	 						p
 

   "@6/a5 .86_88sWR.IXR&-8e 1vs fog&|tEB 񞤭1W++			MbWOAW`9X&,8r,seÖIXQoIXpZ RsQHS r`QQQQ-QQ&pa\W3
	#[rugAೝ/t԰ÛY"[Wϴjrjstx.6Dtq=6&["[tO6t"[sfh,~  W~~	~l	~~ ~F
}˶}}T `͹ !sJ%tdoo%"o:u2;qqq~!(~rgpppp2opQVpWL	;t	@PA:ʶo9X!=^-YpWpp".I 0   0    Ro d    n  A}` r 00 U3`  
A& Aa %  	'%
0 #
D*a
\| 
3`@& <a`] @@ 
Ab
	 CF

? ?a	 "  d qa	!? % D%@%
 +)3F	 
+@ (E+
3$ 4̂  C8$+(3+-E-(C -02 94- (`(E  E3 .c+! 0 
 @/9F. 7'GC@<6A6D
!:7 ' "J",A!E?9B@,3
O<bJ# 
t S<R"G 3D%M TVaXCJ UK8'(XAIc  WI defgghCopyright (c) 2001 Intel Corporationf`@ f.B<t<t$<tc<tK<tS
df&
duh sf
d   uh   uRfADf38n0=ISGuђ۝ s
g]d!t f6d۽	gftczRa tpt5Hsh @u  u uϰ0 ߰# 2  u
P? f%3 
f>BfDt	u)fB;Bwu7f@ffhjUtf3ۊfi"Qt
0fs
B  fv@#tz21裺݅!<ug
X

7	u\	Q	7'h/%_BKf6B	g u%S FB s@[%;u!,f	=4R0	ffx4	)ffp	Q(f	f@f[aSfSfQfRfV*sWuh15 uu tApN|C6g88fI4g^ÿf3f@70@7f^fZfYf[fP"Vf
Bf=`Bt"f=Ё &f= P/f=0 3f=@+=t8t34 , 't"#
ttfxh0 rfFP0fXURf.  fXr  	 ܳQfufQD8@M TR2@(2Of2f0cBZ{RO>V\3hL+( Q z uf3`_{fbDf6E  Z<gtatG@}]_ToKg<u		ϨupWJ$< t<0t_$ RwHP?y"PWT%jb_uPiAP#,RfWPR;Brfc%1f f>=	f!Effg8u#>_444
f@[Jf_,,PSt{xw&1=`QYr;f.;lt3UuflA<mpfAzffm foPtP= v	 +v:P,P}lf   :lfP  6l1|Ã t}L;fՉ ǰǋ;Ptl} Q.lBYrrf@u0`b hI,-Ñfarffpnf`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&[GwG0  "2/t"t׀  V   cu'[0i&w j3
G94g&G}Gfԣ fCfs-+Ӹ00pD;?gf@ h쀀1"ژ`W, `Пl..`B@ԑ
>t1a"pR ZuoRUv w ?xoP&ab{pZ& &FxdOR< uQSRâpBgtXr),uRG`SQr9R'ܽ$8tyYOtr$V簄OHAr(QSFr(!sqtrp@ppq9 `N `4fq48 f܀g'p!>@ W ` FFBZrfs`b PQfWfVEUU &*4P U hXI-ULP'G@3 .;qt3 _?YXh `#o0@	ະF`ٿ E m' t
 @ cC.-	2P).qÁ q90 W
f5Ugg& suf3ɊfY@_ tPXfYfW~#_g<t,fUgR r8t?fG PQ_$@? ~@8tcUvPtF X PSO&tp t؎[XPS~PtaAf/0SRغ Po ĲEðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              i                        i ` *0 
  ɀ$ tT  a`
* u B {KSRP t@B u$Z[SfQWPp
@ Xgg_fY[f`Q
`f
fgfafQRfWPSf3f3ɿ f0<  P tf; X tDt [Xf_ZfYù@ fPffffX,fVfVf   E gf^! f^*	V					:		 	^		f	W		fWf	_
g&' f @f&f_fPSQWV!  tOtъ#("A$(hfP u	fX)  h TqQ sY^_oY[fX>uDB`tĜ/ a3SO$[C vS3ۀ> t赽t$t:$tC p0t<w>t8{tɐ/>+
 
?ñ a r \t3C, @$.J$E$
"
 r3!<`8<fP@ &Y$r! 

A	 fXƼt
i	(3{xu
A
 t1-bw$.fr
RWt0
'< t
(:@ `k  c$pF> uktm$ aÉ  H$

p$I$ J$@$@P$$2ؾL
s3y@si  Y 11F0òY:u;pu;thP'ȯXP'!0!  {PWu0+K`:u菨r:Ȉ@&ul  `uR 7 &	&!:%0ww
2:rp	

v >̀<   22n` غ   nBnnn?nJFn aS iÀ @E7!C &?!Cu3ۏR .wZ!mhPPqmJn蹌X]݌ΞP脿 &JJ詞ω|>&ۨ蓌.pu	 uà]cm
 Xumct5+t8QWP3 PXhX@.X=X@uX_YPBP7up$ q+!_.L$> u
P0!@Xuð6C @B T AjfSQgog tHu.g :ff3g&ff[mn1nfffߋgfffYf3i<(.&gBfsDP
hFj!r
wt4	fRc6U t u

(
uXO0fZSQءA MaQsVp Up Y[Xhkt Q 8 fRVh_ătDh^hlhtmLr  f^fZf`2 rb> <_0[lTrhfaf`@f0PPf3//z7fX	 !7"?" h쥿Qf`/)
4/O
, "	 	 &"	/	(	1&!_!!!p!h=dh$wG>	 [f_f
]]ܰ^u2fbZRt F<t $]rf0Zf]RtuQVW 0 pM_^pr}^Tf DOfؓVaigft
t%eS3jyɚagQq?"Z0$`ZY ^PnWSQRWVhX?r=ыt
@uu	  tt uʋ^_Zqb}fnWV	:Eb3:EF c6W p 2:> u6 GHt\o ?hl/tT3Ҭ?؋h_UB^_fZff
XK̈́
>
2
~
VT>T2E@OHp
Nt.
Or,R1is--/ -aI`o/ / /  O-<RwS2.[ ø  аo̩fY="!f3ɋPw`qXp&G     &Wf&t ffBf;Pg&Gfww~rtwRtpff>@h$yp3QY tghoAX0!S>aPS 2h#Wh`2f[H       `  ' . f6&f=HIBM&@ u_Ff!j  g.9u
g.R!Ff F v"Sf= @t1pu  ø gPQ f $a | `!ANuFgf~fVf  t
fP#ff
a2fY#F$V f;s	f
	  fV2 ~(Ff )g"f+s
0	@Nf;s ȢF@	rf@f qg&g&fFfGg`^!N &Vf fA=uTA$<ufIg:]!
g
@tT	f@f It=> u o*>p u0*thvl}_"30G;t跦3ӧtP gs t营 @PXz>*p 	
du
֧s=|P
` 舻u9 5>r/<t+t&Pu
$&荤.apPt"Qtq2t`貸 "G Q !О蛤u9u߀>苷&tK` M 0 &
À>ڰ> 
8s{ "  
t V$<
v
ط  + tǀ> t ${
ؐ *h?ߊ$(
d ts؊ ^ѧhn%

\wd		
s	(,{ru &g > u
8w}py 4
9A "ukb Z0B@hf]fL[Mf iCf\dx'  @/%diPh @R>ft	Pip'7f%~PfW~CGX<t<t<PS$<w ._ pj P
  T 6   m` a  !ف@	n` [pp&%fBmFBmBmljfpf&jf
, 4j0|0DR²  `1j`Qaff3f r  ̷fPQf<`)ɾ|<w  pa fXf?f
|
E
Í  P`kt~Sdiq|JPSV]brJ\^inpEQU[`duVY iEHKQTZl@NSVY]pVagntxEMSY^dyJUY^ai{DGJOQVbtǘ  à@ PP Pm R,:%  3` ZQȓ  A115333ðG
	 p[  QP
ĳP XuTBsD@Vbx
XS!U u'[
 4
 [-2P 0
X	
@2P2 Uˀa	
$

Àu	<X[XQ-p;a`Wߊa
2tMP<KrKTP`PR좻!Z .Ϡ! BZ s  ""
ZPԽV e"" Jq vJúQ R (J
PBX
	SRذ4a%fQSW 0J0_[¢    
@|f zff"q[UfFFR?/NT!t"ffvfXfDv(a 1fpfuf 0f M "  0& @ G@ +f!r03T  Il
 c
T5iKPÅ--?-ѡ   ! 	
N% _&rR ΰǃ,%-', 'ii! 7$$$$$,1' Û'Ш 	$% pՀ0.&, .>@J  hE M (J GQW
zzy {f_ ~+z |D"~sðCh|Ȗ  $ `tpSu%thӆ/u C/r>A> u߰,
萬%|@ӹk@u~
 
rn$%0Pރs QKPƙ`0<Qu't
  ,  ` &f`h_2t5fCJ&&f󯊤- fa3CTNI &AH~ f( f&13p 0'>},0''2s 2tpcUV<22 Pظ S3$i fOG[.  >  ^]2 	`W?sÅ(S r.o(} wr.tP^r苨诊uM_0h6xr0?Ouh42f.?f8 f.q _h?d <0re.o da Ne> oh)u@@h).) >/
03!40+t
3NO+t3GNO UN)))N)쪺P aT)SR)``a遳$fӃWг[QXf@fXfX*fXahuh<jt Q 8ڠ  (	uuu&gq q  uA[h~yl_e$P0 X! hgh(SNvP+F X PSA&+&+&+[XPS2+࡬?++QA:QTP SOد84?8x6, N&,,$Lw~M$htMPS8rddraS<dr
?d2`07bt۠9Y]bgxypǟdwp St).8ʸp-{0T Ào & {` rЊ&5X0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ?( @)(     ښ    ς  g `g  h } k   ;p    /\ H6h_ vxJU7a x
S          P        (  %X%H_&                                                                                     `*} ` Pz*Q@ U   @U 	@U
 
@UP X@UYhi j@Uklm n@eo { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX)  h  fUf&$af&>)` 6( ma   ߣ(X[ (&(SP`ͭ@ /'a&U}(&(@r
f3fgf }f3fh   @p h &üf`f1fffef   % ŀ-f_f0M0U0!0)ffXf9ffaf 
  fi@] 0 m q  ,f5q fϾЪfeP jQ   U͡Ap  A` efaa  !6>eуp Ń ՃPك"` $eɃ )	
e} fe&u` b "jeɃffeߝfAffgd:ugdfepf3 gCT "8fF3ۊdeր3 
td	  p)H @ۗ 
peuxu._RzTC u:/
'
%&bfgfd._S` [WP9A`XP&EX% &E_YǨ ooooǸoce   f`cff`t$j`p$Ū}`r쪺  .<t
../ NA NfafPSRV$fpor؀tU./OtA
 NUN%!h7`^Z[fX"4 hӣ_TcÀ> t yU`p  fDt t[D f!|GB f@ @^P{o   b ~0{ S  DfWRq~QWfQffYPWWU'ul5`,p}TS
a~H j9sN0-r~qvff$  D~R~a~ST!Dq!~fw3Ɋ WfȊp  Uȡdc	XZ8~,v f H#7}}f}W"}W"wp;@}J&g ?} (p"(+-k_SHGX
;S
4Q"/8Q"#'|01!|71|&|41 7|a׺ I
 Kf+M9vs?2/PSfQWY_fY[X ud h?WøPNPR0B1Z 0B13 $ `%>&v%	 
  3  t!  { !QV u#V2hILt0RW0_Zw !EMF PZR8q%fZSPR|0fPRTPRfX@  !cqc
f fhW`_@1|W| |!|0|1|2{| u| o|aP߰ tAUf[g&?t"g&Gbg&Gbou A& uf1κ( 
pu"` Q}99 ox 1ﺵ* : ,
 i2R1pĺZP ,}ȡ%*؁~ Ë34 2 g&D4`}*
 <c. 1b"0gh!qf`b˶1f2f3f%p :0p!P!䡮q @pr2 =e0XX!`Qfgff%?ffPv p*
 `kC  fqA"a/>Ud~!Ț
2of`@a  6&P& I`pX 6%rv
``ѿ. r&&`r!Br  Pq X
䏀  Pf hEa HXXH10u쨀t݁	<u <u õr$Rr rs&&J2qrr]rwN a{`z7da(Sv_xБ/Q`ؾ"" QYaFP  r&&oA Ob 
yV' P"S""}F"&&qa pbR ~ ZQRr3'H2't2ZY`2^"`T5 tt(TZYa^~r#S-ER-Y03!pٸ q4 1 f & &EZP 2 &r豂r8t320`.o O h?,..ptG[S 1?1h3[&M.q2tð$? #h ǿ5PƿW< t -Ƌ4fRh^t:2hlt Q 8ޠ htm<fZrj  v@w@5 `
, #!| ]	A	2ah~l
D%00`P 0S%-  DZ`6(  i@ pMV魆ī^`W| 3 _r- +˸ fPDrP;Հ B}B O B<`<2rruO0W2&*G_YS	 }7&*,u&}Zu&E_[DAyP`QFگ>  0 2ۃ<OtY	B<tmHඡ777rPBBL: r1 r,q h/cd8SQk
peat)u?$<Pt+fhKuҴhwqiB`UY[Qrj @qj"yjuBanYoof0P	V Wo^W mQfR h?vtD=F==rN|UtGV !m4^t1Vh_~5f_^Df`  D ; Z x     0Nm=$
pd׀u	q 42{Xҏ	 d HEȃI3ذJ,2ȉÑ-' dmvOSQRfRBP' w	.)Z0"3{a  D2 )aʏ$t=2+``|r *w0h5rEϰd/(#/J+('1*f(fYïʥRh}ihlQf>QPH_u(DЇ/ fP  -r(qQP-rofRfVfWp(>f1t 3 tfہ40Z fRff!52g&g
fKfRg` gr=e h#5rA | ܂Vh+Z,
-f_f^fZfYf[ rP sRfbSfRj07W6uLt;wEf6fQHf8 r/f`bpBfg&rf]`b0  Z[XfWKu
g 酀> Àff`g@? t]ǀ t
t@f?
 :  ) _ 0f` ; 6frv`gGwf3۰ fPfzcfPr:p> ff0;w!fVg&f^ufFt9f!Q. $pft Q?g&$9yR<&m<f=AT?ADtlf q:&Ǉ U p s  SU3它a ݳb Ä1 D 0腄3ɊȐFj qUFWP3J XU .>J^   ub w>u `	߉`	zp$l0샑Ƀޒ$ӃC_AR+@o(lvfSIMWuUf, f@E<rf=fAf;w(h/FI"Qw[ap qQ#?SECU7fuBfS %AR@P_PSXfGؐu(AE_-裁$81B KTL q Gt+Sg
 xTVT<tT7Ht})h~
u^ 
@  ff
w	YßJl& t
fWk&f_r2af$g&  EOg&	2tWV`p^fGtt2t~tyf    f`w'pA,u(0v z^ @ u~^uBO`xd rFf;r>`L: t, f    ur%)rQY9	 ]s_   t%htI`A
A!:0.2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t D@@D@Ò*@00/Wrwp		]P? u ff!` B
fffLp 


grϧS`|1
!Х3Ұ"~t3 v %`hr9
UGܡ밣V1
< t6012:u"FIqr()`D1' E-fY&7@ w.	Ah_S 
fUfp>߀t	/--


f+Рfy
B#f]^P)""  ,gbXv0s? An@u`$fB %  
s@_#_#_#Mfvfrg(*S+r[ ం0PQ>)ι c r\d`)PSCtC)>r-t`w 0 r uҊ1 r
-`u`dPqQ rdItf s` 3fSRNr&Kr! [ww3҆r r	?`HЮfPRc!0؋;rp܍yQoPQ>q	s
d Sr	r!V>Rf   dgg3{uwR Z '}hk)C ZPMJ. ߰ P " Y0 `2  p",u   P hE\3R

Z@u
Sذ* o rQ(`( @PS  I 1' ߋRĮR  *rPXDC	I 4~P>DS t33>06J*bR
t#4 c ttaÈを  PQRWVƳ?+3"a?^_Z$"վ#P1$G<u@$V 4^wW _ O"  !(e R	
R
q0J
g&/ܱ1q;-Kr r;x;q;PR(XוJ2Z 0[RVа$rN ;rCr<,	r32`t0rr;wҀ tsڋ^ZW
   е0u
Ш 
u P f!· uf _2 J3322t@@ 0 	rn
$	"
upmƋd;sRZ3QFqF2t
2t	u˸
S_ø
_..ߣ....6or.Y.2YDذVPC7m   `   $ ( < @ D T ` d h           ؓ a`aHA b  "@H P X \C  HT2 3L 4 :50@A`1.C                      M         1?4     `XYhijklmno 	

                  K ,89:6NNOp OhXۀW SS@ f`Uf#ҁ'f@ <	&  P[S4g&{UfBW f Q  !Q  A!!ȑf%:Q3f.2fffu_`_f"Q ء `& :չ
f0P3XPSVWfQs: ؾQN p؀u ufufpv Pf  fY_^[XqfWfVfw f w ,Nޱ f^f_ROB Mu  Πn( 	)*
	
fеq3  _Qt-&ɸ1pf޽fЍ  o_Y&.޽fUf.6f]f]** End SetActiveDisplays: \ нR$nt5< u)㋗d_;t  _um ZqPӸg tpu Q2tN
͋ك߶Y  m@Wt0`P< t  P쑵O
 Pp
R 1 3t`Wp $ D pRСUB
 "Pпѿ	tR	gѿ9`aP(aP$ aaċ؀ aXaXaPSRثuiaZBۧRS``eb tA0VaP _N@J;*QRPSa[X3{a B"c
0r j YK f`0UKOu$d_r
u.2*q	,rp޿$p&` E&]@@ _ffa.A4H1/qg???SQ/"S [fWU]^31SW_ð ѓ @а rH r0itp	`WB?Mftu LAC_D]f`f>fݨ ; tDf;fRPfa`k_<_qfgf2ga?ЀuutQ SP܀Q$~X	}[ fpѰ PŊ6CqHȎt/O  3 (v د$akt`ZON}Fa<@C OOû_ B  @@\u$$t$
 $$"h1|s`9tw4>0t,PQz uXa![^3 < mj <2<
 1                                                                UPRPRVFZX0RR30Z O                              t Ѝȋh3 =7ʕ虜֤ hSpn Pf܂_#fXf XzU@h_Tt
   }΋Pf  ԰d|ӎ҉	S@ "@i S zJX%y C Hك"Iڄ3밒Nrf` f+fMh/$ff-Ef'Aq;  f>PAMSuff>r^0
 wS!0ًP` X1 f̣|	2% %fP&b0WVf1hlt Q 8 rY  E6fP  hmh-rk f fht
^A
00.~rB A2@
E<u@
P14
`<f0tؾ(<?"a]"EQh>r&=t&}V" &GF^Y"\@q; 	 hy<C
!
"s

Zr
Pr 

h@WL P~̀R ĺSRغ0 t߃@Zu<
w'>05# $$<w	($b*3 S> t=u7 u1cP*<t&ut!ҿ[r0`f,r	BO qQfWKtZgf&g5tK[r3%g&G s0aQ$
 !Opd 2_f_YqPKKtg&G?"Tr -Kt贿t@ 	
~   VȾ|l 8t"8trK2^SQB^Y[-t,&
u>ut
$sE t> u.Lþ"t$	&
LsDa%
t0/%	> 2
XY@$ty *ITUuv0\otC ưP J< 3t` &$  
t>ý ؀
	 t Kt_00P@'ug *r$@, _t>1u
jߴdA  (r"/vtߴ 6p2J]SQPXItV
r@.XGHtB0 T0.rg//yY>6WHt_6tP rB36s6u%
u "47H6 WE6A1Jjtzu VطcNtb@;sW;sQahVu	Lu u"
u"
23BV{. + à+֢.t @L* /)P!(t+XSfW0`
GtpD_8؊f_[:W߁-fPsg]_  rS
RaÅ-# fPRfQfS [ff%|h f
w 10Ⱥ4A# uOf3\f~at(,#%93t0!!t1 f0 t@f.mf@FfP f[fYZ0Zl! \lj؀ؖ ؟5CCMfW d u8  *_t @~!	xff_À f <Zu?
0?ErE0/<D @ h>df Ԡ`bп0y v f`%
0ú:ckt}f`@# Qڇޑ  D1`_úd u"AuM "  t 	4Tf@ @I ƐU ـ@g&S%` &!#4R%0(+1#|Q~R`~-f#f%g+ك8` $B'
p߬f 3 Q'
f~ِZS	2; A''p
fϋ1g٠
s!=qfYfĪ & A%#@3RS؁-@!^SCV p#t6ۋ& %f&ȿ ffP]t33u⿋^ Zfp
3һX3t@s7rS
`'`' h%! o
 * A40*R0T0	f%0OpÖR3&$Xb P1T؃2g沱1BàRfZ~ ޵ pd
P ;*Aؠu  `<`KߎP#R_f찵 Zlfa+!nM3 @q(0{Efܸ up!S D  &Et"D  $D( s`K`ف&tP% 4>2@"߃Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m ?
 m pj's 0a` r * |`OQ۰a	 &? a@;# $$<@t"hXTKu3Kf LKuף`.>
st&3`&*RrN!%"oDaô`prr X ? tr/C0}}qw1#!8OQ909$Xa0){fRQSݷ[YfZt'0tN( u
| t͸ar0
ADȁmG> { f  hY f>rxffRhd f01`[r<fffHff#f+ִ f;wf!U3g&Sc
uff+f
 ?-/ -8y!1 
-8--n-?-oBI,c4D-㔗V"Qa-6--	-q%---
дKzz¿¯D	&	֥f.u2!u<u<vw2`bоp
Kf&@b S&ذsHrH&'[{`Q;xV4t? u |_|[ff[F`覕F(`R_Pai///6URm" ù_22r(fhl,sҒ"B8`,.ohcr0fA@fP`/C'R6fAgqm}Udr
htz=syGNohI	J{dpE?@ hrx@WfV"D I|b@*Wtf1YpVR&߿/Zqf^ oR5_'mRQ,ڟ5Џw"s}Bàq",.028~﻿j9fW)&>4?2Ci	ZI{*m|ݔ7ΠzlOv`Ⱥ tj  q&Ϭaau x  
| b Q  ^6t_R๿ 5QPPffXfff@O!ð   ` 
9P""pfQROdV 33p#Lff?f?
 
@vf 2wtt%\hp5Pfs |@pY 	 A  prS0yfv͸ Cth\d"Qa!% = u5
;= pku={ l1׃`!{t态f׳f3ff 9ft 3'6) ( 2PV Q   ,A048 03P#Q`5 A 0As fBCh/b3 tfP  f4y"DR'D'aPX/&[    iq,-./01289OH     `a-jv/RFQ$aPFe=G{3""
P[2?t*00`>pml>l!GA lBla6~$?Cppo! G @ A B  $0sF  @Vn _"V  BnnnJF$a %JF P < tq ̢P ̠̡TޢU    llB  ؿ lBB@?뺇 l@    @ lRТSN&/'FLw /$а 
@  
FFn  	n	n	n	n	nj	n	nnn 
 RS ta  a@Cd̀`  3nnCy q
p		 nA
` nT.`4Uq `\QIJ[0[P'\SO2E p  p 6RhD5<:Deb tG4!xtC{ft.gA fA zu=qR Djzak ycdh2)
 I   PӠ--h8ܵa@$#4pdbdy"_m |~RpIp { P?ZPłSuK Dzbqy,sY YQ|1	- hQ~TA".&5 t..5p'ϐ +`Q.t1*0V SbS0Q>`8P%#%j  t
ف    z@( 'gXt
 %@  Pé t u>#u# 
q  ~`˰3%tN tGf3ȿ fQf3u/ff#f{
fB1 X aðQR.a#؁ "Ӓ1u# ! t%%pQ# Y3#Mˠ` ໾AQRt1
h  z+uo # `u{s
  aR6
 c66p,+0p%qY3Q +rf#$ 5 b1q V0VWtN 
 ᴄQ !s!3#u貙7u
Դ"q׋fĲPS54~ 5Tx T5h~qR	 yZԿ5  п-(54-<5#3p5؀`+@uR4t@Q@t
n1
4%!u _<P'#<  _                                                              -O(aK rdE          ?p                                                                     6T  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                E   
 B440UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   <             TPM     
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   i#fsf ff   fT   #fsf wfD   f @#fsf [#fsf E#fsf #fsf #fsf 	$fsf <$fsf y3$fsf I$fsf b5Y$fsf xo$fsf $fsf V	u$fsf 	_$fsf 
If   t$fsf 
*$fsf 4$fsf s
nnfLg&nffOg&fffsf fsf f   f   ^%fsf f~fsw%fsf !%fsf Pm%fsf %fsf %fsf ^%fsf #f   t%fsf %fsf Uf   t&fsf N%&fsf 5&fsf 9E&fsf U&fsf q%f   un&fsf !~&fsf &fsf $&fsf &fsf %&fsf %&fsf )&&fsf )3 f%"f   t
fnRf  'fsf ta$f  8'fsf %sf  Q'fsf f  k'fsf L   Iuf  'fsf f fsff   f   f   'fsf 
tff Ag&uf(fsf A%r8u:(fsf )%u$f3f   u
ffuf   tf fsf   e(fsf t<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  (fsf $f  
)fsf Sqf  #)fsf f  =)fsf z   Iu f fsf   ffuf)fsf #tf   ))fsf #8uf   uffuf fsff   ftL)fsf S#f   t$<t)<t/*fsf )#ufffff   uf fsff   ft(
g*fsf "<t<tfffff   uf fsf   t8f   ft*fsf "t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tMM0f   ~+fsf [$t<tff @   f +fsf !2  +,.+fsf h!<  ff   f.:w .D
,fsf 9!<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Mff   f
.f   2f   f   ft/-fsf ) < t8stff   uffff fs2Mff   f
.f   2f   ft(-fsf < t8stff   uff ff fs2Mff   f
.f   2f   ft(.fsf %< t8stff   uffff fsf   f    ft'{.fsf $t<s
f   <tff   ufff fsf   ft.fsf suff   uf fs2Mff   f
.f   2f   ft($2/fsf < t8stff   uf?fff fsfffsf fsf 2Mff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%Xf   tX.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfM2.<u f   t2kf   uff   u1fsf #uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   1fsf *<|f`Agf&   f    f    f   1fsf 9f    f    3f   ft2fsf Ufft92fsf ;fftS2fsf !fftm2fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   2fsf <|g&f~fsf fsfLf   f3f3ftr2f   tN3fsf tf˰j3fsf <	rIа3fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufX.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf fXX  f Lgf&fftf8X  f~fsffHfuff Lgf&f   ftf@6fsf f Lgf&fftfW  f   tfX  fX  f   tf(X  f Lgf&fpffHf   tfHf~fsb7fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	)8fsf fBgf&E8fsf  U8fsf  Mff%   f
fHf   t
.f@Cg&Mff%   f
fHf   t
.fCg&fKgf&8fsf f fsMff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsNff%   f
fHf   t NfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}Y.fDg&(Yσ.fDg&.DfDg&f30Nf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`Tf~fsfffsf fsf f Ef   .@ fffsf fsf 0Qfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@<fsf ;f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
XfHf   tXfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	Xf   tXf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
HXf.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   f	C  )Cfffsf fsf f X.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsfX  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   Bfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfM  f Lgf&f   tf N  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsf   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&fKY  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fY  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   f fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afAQKf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Kfsf *f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  
Mfsf $f  'Mfsf f fs <f fsfffsf fsf  fӇ.MfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  :Zfsf }ǰ < urf   VZfsf $<  <t<t
<t xfNgf&f   uf   Zfsf 6$p2<uB >tHH3f  Zfsf ȳ 
f  Zfsf ƻ  f  [fsf ư < uHf   "[fsf $` < te<t
<t UfNgf&f   uB >tHH3f  u[fsf dǳ
f  [fsf (ƻ  f  [fsf .$
f  [fsf f  [fsf Ƴ

f  [fsf ŀf  \fsf ŀf  '\fsf f~fsf fs    f   ff   2fff   ff3\.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2\d          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE            D   @    L       @       H         `      |   @ Ď    Ď    T    G       	 		 		       
H@ ,@          	  	    @      
B  T     L     	 D    P   X     `  D    X      P    `                O    O    
O  

O  
O  	O A    A             
  @      I         	04
B1e2  
D12  
H12  
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @  @
	 	P	P 	P0		 	0	T
	t         @  4  	4,  <	    , <	     <	    ,<	    ,<	    ,<	    ,<	    	,<	    	 T <	    , <	    ,0<	    ,<	    ,<	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                      0                    	4 @       T                          d  ` h  $X  `  '      @@             A   \   Z 	  X 	     ?                      !    8       ,      (  *  .           ,   :  8    h   d   f     !    N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N                  0              <ff%f  $f$
tSppqtDfSfupppppqmfyfupppppqf   fff   tfkff  f  gffLggf^gfnf    f
   "+f!fupppppqg- f&ff6ff  @$f@$
= u$<& fvff  @$f@$
и f  D$fD$
аfaf% = ufٖEf f0f % ugffU../0./.f0f d< ufKfd< t<t
u掰fsf䎊ffff掺<ufcf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fJ  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4fR  7ǔf^  7對 f    < tg    68DTD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 s& f    Q7sY 戰f  ff  f   tf ff  rfBYf戰YgC!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3^f  f   f戰fSo#f[f   f   3f   f  戰g&A#fFfCg戰k 撰fPfSfQf   fQf3یffÝ  fYsfYf[fXSgu  ;u[fPfSfQfRfWf   f3یffÝ  	 lfBf   𡛚f3g}    fg  r%fG;wg}  f_fZfYf[fX                                  	            !       p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR   C vZ[XPSR "Z[XPSR   C v
 r"Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft$!vugf&>tgf&6f٢ &f ~f^Y[fXPSRfV  tA   % g&ƅ    f+  \g&  	uf^Z[XPSRfV  tA   % g&ƅ    f+  g&  	uf^Z[XPSR   <   ! Z[XSR  ~ C vZ[PSRRZZ[XÃ<t      PRt)t<ZXfPfSQfRV%&  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v [   qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $fkfs f	sfwfff]X t fffs f	sfwf  ffkf_f^fZY[fXRfŋӃf3ӃZfPSQ  f A vY[fXf` f;.t
f.    $C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f+   <  f[  g&"  @v@ g&  s f[  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         戰䈽1j7戰䈽GnȰfSf]Űfifs6ǰff鷋ff' f%"fgf7ĽǰfKfHf5f 3Ȱffǰff f
   `"	f   f3f30f  0fKfQf   f f    0f  f f   0	 f%"fff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.f0  
Βf;  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf4   a!?Uus? = 6
J  >=rfJg@  @ ( rJ  .J<V>JMJfAf4<>J3JfAf8f8rrf8f4f>4 wf4   >JJfAf8%f8E3f8f4f>4 trEf>4 wf4   >JJA/>JJAm>JdJAff   fF>J=JAC,>J#JAC>J	JAfCf J< >J JfAf8'f8E
r$f8f4f>4 tErf>4 wѰ<f4    J=} >JurJAd>Ju]JARJ	 D>Ju=JA>/>Ju(JfA <J]  J>J	rJ  KI	s 撰 X%iԻ5Ok|2NfSgf[gfPfR>?uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf0@
 >? u> 5xzyt7
sfZf[fXúz.yu
sfZf[fXPR tĺZXfSfRf0@
 >? uB ;yM@ts(xغz,y0@usz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tSg&4  g&;  ĀuE g&  v	@ f  GTf  (faPSQVp؋L	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6	ms>t fafWf   g&D= g&D= f_`r r8 a`fp  gF
$&
gF
&sw>taf`f   gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`fڴf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>ڹ gf&D5 gf&fff>fXYsufa`f  & gF
$
gF
f  sF>tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
ЊvaB  f
   `"	f3f3f   0fffP  0 f%"	- ttu! ssô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfZ  ?   fn  +   f     f  	  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgvf  g'gGgf_Z1`1fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZd/[X                              0 @ k UPS㋇ [XPSQRW0  3)  3  3
  3_ZY[XPSȎػ       !    A    a   f    4 ztR  vffft<Q  lY3gf&A fgf&A gf&A f   u   </   .  #    
[XR * 8 F 
ZSQW   _Y[SQW   _Y[SQW   _Y[SQW   _Y[    f  f  fPQgf0& YfXf    gf~gfNgfVgf_{fPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >>tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f0p   rg<uf   ⃸   Yf[fS>>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf0   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf>0 tf0tf`f  f3f3f3f @ gfffCgftftfaf0   f0uQYfVfSfQf  f   f87rf8fYf[f^fQfWfVf @  f   f  gff^f_fY               fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     PUN
NNOపNzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX        戰3ظ  м{f露ff鉲fD    2ø     r  @ {RX-02/25/05DDTS