#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTT)  - Linux-Based"
BIOS_VERSION="F.05"
FILENAME="sp30554.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    68DTT   BIN  b022  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                         p   `      POST  f   f.V .X <  
 f.d ` j \ I     '           POST3  * I : H {G 	 x
 ) P )
 i ̂ f)  _ ) f p2 3 2 2 З   x 2{ $z  ! s,# Ѕ$ {,% q' T( ) |* , - H9. 7/ 7_0 411 2 А3 .4 5 6 7 8 wy9 p; D= ,> ? /@ " ,A g_B n_C ,D E ږF yG 0H I )J L )M {O `3P )Q BR g,S T ,U V 
W ӖX *Y Z G^ =y[ _\ R] _ 
` ^a f3" f"q @ ؠ   ؎  f{  3f   ffY  0f h0pu    3  \  U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hߚc [X u<t
PW jf&E1_Xa
B fPfSfQfRfGenu fnteluxfineIuofP%0=  rYfa2f   uI؀/Uh{it/fi0tf  
 ZfYf[f
BPRWfQ
u5p 
(t'5"f0@
u߿ h~8ufY_ZXSQW]/13
 h3__Y[R Y" t

L@
$a(w&	%s
> h>3hp0 0t  
Ãu
.(u	u/UPVF	` u tR	k@.tމ^~u 8	t/ tS^6
5
^X'W~
(  _f S43rLt<
tw
uο 	+?_^p	9'^1WfV&p#)6S
F f[tҋ3ff^ff$`K*fa9. @@?fVWU@ tϰ ]3h6@%/ tkfϿAh6 Py'Qǀ. K3
rg>Ut2gFYPQ+1X\Pf3X f	]_f^PJf`Sfff@9 h3:+f;r[? WpX
2h_
ܿ WX
_: r
gN1
g_?r @99 \ARWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_MU/2tg^H2N@?" :h fΑN   둡4]dQRWV^NV vq6Q3qI4GYlGʫΕI^_Z!3Q'M0  t8 YfWV3ff"1*^IfPS. ,.(F(  f(`y^
#N~u!d*d.  CqQVRsqR?
ۀO2ۊ~fpg:P`?tWuf f.(|ftf!f.@# ^<
uF8Fuf_to^GVR.>(s$0m	.k6(.(v

ZFHs ^2
F0(7FPPr2PqN~ t4vf2&fz10
FNNI.(Ɣ{fQRVWPu@f(.;(s0e~ ˁ ;u
t`gt@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ.ƅ ` P@hHUb.( `s$p' ip3.(lh7z o.N /p\wFk@"~ 
N~f.=6@.?2ɠ0/tlu4.Bf<t؅fɣ  `b$< F.v 
1wq3VF~rF F;F F2u~{w
fF@ M~fNf k lt
fNqu
ffsfF^P 4)F
Q
*q4rF$<u&jF # ~Ã$wp` ?.p< O<uO8q^`V@;(@..}(;(^V0&0
9t@{-2x@Z2
E/^SL 65^35#uBX:NЎuP:
t3S9)u=8N0_^WV\SVR`Ff~n*J[!ffAҹRfߋfP%߀`2fpưKf;w
2fPRRހft#f3!fDf^XfffNL$ss4
tu+q%
u	AfF~aJff^Z6Waf F^~K"8ueffFՋN_QtcV@hvb!F;pI3ϋ~+c:tsRV F;F8u p? kv@kFM:`pb$$@K@3frD` w;?=< uor,.;D$<u^π r0	 @BvFfYZt4}VWv Ђfݻq|~|URd
t"t_'t @DvP }xPkQ9SV޾[3; t	p r^[ u k[ː_#Aq[%Sx^Y@j*pt@;v7h!1k~o@st 1;FtFk^% Bk^cՊ[a 3҃  V3k`[
*[;FuR*3]ft7w-k	%	# a
@S
+FHu
4uGrvFvVBs0;~pHVWξtS03ދ[^NuV}p 3ҋ0e_&61-Dr<lFk_HpBHPA(7oZE &0}V  ~1|\0PN~ tKv0YFA.Qz$ x
fpO3g FfyN@P@ 
0K SQh(	 \P,Q23If.` tf.&!. .8(tьL$QVW
fvUFp"`PF^ߔ^F  FψF
fgFF ^_Veb"^`L`ЧZ!ɱ ``Nf~ tF?t'f`e 9Fv@f0
FfHf;F{yQr@-րi`bbbfC<W4RVFъF8F^ pVF0 NU$ &5(,ytN!!fqsШtE $rts@CA9FCvG 3r%if.(NͿ  `N0ƺ0 
t
F%  .p >}~ t(i'i_f^z e{u
 v@aQI8t%  ֝tu Qw  vfIft'fAff#a fp~Њ=rSn6.6 G                                                                                                                                                                                                                                                             o         PQRa&h{ic $`Ȱി h;rZYXSQWa$a$a_Y[2揺 TCA6  @A }Q C@@ @;uYð!$p h(PRfW   h2
fg&G`g&Od0 f_ZXN.-hR
 h~527hݳ PgdϻX`hТng4hQhDB	3t)4h\va lnhS\@ ؀  &}uu h(h[߸Wu- $@#h$!h)su h/r#ذS%uShS&h fPSfQ3  hـfgf&7ˀ ~f` ޅ  {"fY[fXUúvø(fcb` ##aP hub3m`.PQ% @ PQ= `t
3f3 @fYX _ 5ð_d`@0d  U{P07 เ R:F   ؿ
Et&؁  uM9NwN#uӃ~ t"F= wt%   +ȳ%=XhZ8`.-  	 P5 a `hUC t*` u '^7uP9tf` ؜f(  fVf@fغffffff% }=a tfcbȝf 2pfTf D  	2E2Qfa~)W 5?q$+fSQJfU%a` 0f: ZF rf
0feXu753pMYf+ K  f$./<wfT % uf9<r2Zh 
2
m6h<ac4
5 R0@ڊĴ fh6$fXZ!fِ8f`X2h$'r% s \\2*r-
tf<y!s!'DCVr|s Meoq
NIxefa!
't5<ty1Jf JF@   C<   $  U V WpTQRVWoK}3n@<8DP9
` R"R``R[[_^ZTꚆ   >3 IA  Tr M e M A@ վ@9 Y . @ n SȀA  `<|a (
Vqv `[  +~[{!`\9àyJ2 P fl2!P_6L2f61  3 yp}N 61>x  .h}$S $<t4r [AǞ! ЍЋh@33 c f`4 S  y h=s%( h0g   D 3 "r<0YF?2"lƾZk^ǿ-r/ǿ r%@@9&5&D&ENƿ7Aa
phSz P߿^px%wVuV~^W 
8
3
~3
dE
vǿC ؀v0aV]&WU$=u&f= =u &&&
, fgh  0 pqr  <ABCDE xyz{|}   {RV S#
fCg^fRF5 r&2&4ȾS5 ro
&   `5~"X Z7fZafXUC~f   mff&0V3
Ê^(.@(tЄ.FuN.Ppq _XWfVUSW! ,fv߿ h.  R&~22!IN܀3d	^
u
t_NA&>-_[]f^_Q!PVҾ&=;u&&~p4u&^P
P< +&~&1E&DSV h2b^[ÿP7  R?W  gr fp <_@EF10=ROM Based Setup  En?tering7 `. u  7 Qvt.߀7 8 SuP)!`- W  7p P!|A	A7 1u7qrPp &7tFò  ut
.>	t.VTt
(*Qt h.PXhHsF12=Networkrvice BootWake On LANAttem[ptto %  ht8 08 r	 A8u 81O!	t_ 	91itsR QP.?8$<+(9R.B1B"8! ds@C	%4ؾ<^~s QE% VRyolNF 3؁?	uCFG~N0tG@h|Ra{vshZ^@òP*Notebook hard? drive MultiBay^"DockQ%b<#b (top)bottomy)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!I123                         <P =	.P 
L j @
m0 >P -r  pqlectZDeb]̹  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start: >>(?$(P L?'s?;S A;Zip.F`u h d0ô0.s?stԎ? < A V3؊' tA<v<st1>& 2ٍ0;2}<Q#YAr	 D P kF.>
*о}> @>+jjj(PjA-  u? `>x> z  z  ? R 2җ
   t03>2Ɋ F8tFޣh $/ Zbqqp URVQ`.,.L.T^Y^Z]S,._>*[ݡQSVW/ s&Q?.<.-00?00.0Y_^[YQrx> u h2B = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰww`2҂ Xʱ@
>x>x>r
;w2p{>JAơ}gFYô.*><u2K  h~Chޙ hch7d hu<u`B J qWo rf.>UC%gf&G, @ f   PG0f@G,`u
h)t~G,f",f_f fP QW2_Yf= TKSt?0 bo    ? o  J^  b؁.h%p.
W
g&Fg&Fg&F"t7g&ƷF0a 1 2H޾D׎Ǎ~ذ:{ rsD	pA  QRVDTQF r&e^ZYDffL (ۋ]LрY`VUfQWo
ِx
K&@
C' C$C$0Grx  q## r]]"0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"7u#%$u!#,9ABM f.0FPS [XAu,.64F0hSuf.0FIDNU
 44NU`.4FSfVx%r{'T$^3&ߊÝf 3(u
vu ^r q!} "пW3 hr_ ,`,h(w3&5cf_^`= vI OAI aP h{i2$@<@X8Sf'pBRytG f  uAtGfP7QfuGyG} !&rPmact
&tGJ|fZfYfQ>Wht ffC@f>uGFPtfB 2 ۻPsprGápG   Sf3fAff% f[
A0 2f06j&%  ? $?8t,fIn[вp?f߁ fо ֋f< t6fuGf;uËLt;@-P;DuL7'` ~f@B qoifW!	1 ( q1
ffùd f f $ XG3Xg&@ O Wef	 fff3cIEr  }1jWfӒ j "!lRFkp.bGmf]fa 31E2Y% ! 0 `%W 
5P&6a#

hMuEiF
rjEk	AVAEfZ#PQWri 
  f_Y=SQRWh2r_ZxPfPRf f {= t5fx$ LZfX TC r99 r/ 쨿u {t t`XR1$tut.ZSWQRpqZY_['aP  P P} (   /H%pLq   @ Z #  $@ ;@"@O=   `@	`   {	dp   3Bj		A r ` B! 	a` b"BD!R
`4p arQCp Ex  	fg
Z`
Zl `   l۠ 
T
P1
!
P	/>A
  #aKC&C  / /0@O     @    c633۾ {658P6X pN.:tc.D&&/@ p p ѢVɲp @&> tuc ~rh^& 
f3C<thSt} O G2?[}4 Q h&ȷGq&'5
F4OüPq~32ɴ*f&ȩ u
ffK|&&fC0ɂɏʁkpqAMD Engineering Sample qAthlon(tm) 64 Mobi!TuriML-TSemprDyXP? FX-m- model unknown Pro    ffVW Ӏ t夋?P  ^PtSwP`tH 	t=P~
t2Q t'@Q"!t0Q"te#tQ VQQ.c uQf.Y^fRu f;uP
.fZ2 f0`06r_f^[0 rS
 33RAusj AX_0[!
`00+ SQVWϠJu3_^P} 	!BKVR3
t<^f~
w/vTS.@@okd4г3fft@[^IVQWfv h."2F&=ʿF&?p &A &CP&E&{G0&I&K&M&O_Yf^$ ؀Ȁ= r&821 tf652 
Q° fȡUۿfW UȎ؎f   { r` \u'P h⤻" hh0X`a hu]ߴ_haqf]@PRZ@Q V5Բ t%  sS fV ffff>Vfhg&; 	  u7)f)q@g&~/u! /{u/u/u	g&t8tx3	[rnf!ǂ  upo	1/u/t r߀!~ ;V5?±:                                                               ee1UfU0m.|VV?u h2frW2rRrMVtf0of 0R|b t#;r"t A;  PJR  ZR ?f]L2j qV0r*6^  R Z rG	KueAB rC\A 3?Xyg&8E tPEG(V 	UQgXm r	X>V~	trԑlkQkpbgf&^C]#PW rt r
  GC_SRaPZt$ؤ$]W  _W}  sQpO  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
Rk'
[//%QWjuptPX_Yù
 d h
-Cx1迬s y
2 y -<u4-uĀ RRa/R2020h<8< ugZ#ȴ$ t	J  U
	a8ڡ1Vof  @L #^`hXªhàhs$T/Ûh Ihj®u_va { r PQW 0> 3_YX
BX
h`c=~E <E$h_s	=C 3Cð   ! $!f`faBvP_F XʀF(V`3ؾL &>&DE>&&D >u kdW j@ t~}
 'Ȁ}	 > 33S^[tS[:? 2[sDy3 t^h@#Sfs
ߴJh#Kaàh̈D
ϰ<D L
p
E$<u D
@Q-Csd
rSi& uS]@` uL
 6 6u  (X6є &uh
	\

u.0   mD&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  st"& xu	\	PS   ? 0P'>_3& ?! W>	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10Q&,@ &  ^X  hSC!r!L	vTt
v߲`WU$/! $<vR@a@z3  v
p
u$"<uP>ȷX\PRt`J:1th)W!&ķ=0߿ZXr` 22ǿ&PCt5=tOu570: u	At!sy96 u5 .^[s
t!V&q s   a
׃/Y3m r5s{&=  V P;u 0< ^  3f4G -@f_  }0 U!    -&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&D/` 2%
<t29h{ix21_kרt O<uLDHD =_7_D D	 d
/z=1:B]tSpprG&}	r??23P3t`hWa&ES$`	&M&]AH`.'	@[%# r`S UwϠuRb ZW&߃= uAF:I)
h 
߹ m_XP
t G4" w! `|nnFhrSh NpL aRC h aP uf3?.f0QRff`Nu @  tD  h5f#fh6RW AS JV#Ȑa
`PS@U#[Xr3{]rYT2
~3

wh
 PeS fу["\$ p6@a&fc
<u	fpev @`֎h.o73۹ F
t):u%R3^D	& hI & 	 hB3Ga3 
3 9   Q~S'Du  @#[J rGAo> r;fQ  .<t*dJp&' t&A;+ 'r
r'+ Qqu8s& 0RkFtZPttp?k h YQ8?r@[r4f@q(u߀% = tR`Y*I@_HS3+6 
HHE&1E !,z 0rT}Th+ô>pxfaVA @`$P<Pt}RUZDAn1O  ZGpZ^QWV 0  Ph߂X@ 0#i2(
3p'2ƀʀ?!C@m?r@Dt5,ϊu,u1 
@a

+&C3ɿ23&@]t  %
t&
0  5  Ӱ"   ( D}
u4: 7/b!	"	? A%w ^jPRWqA&A &]&U
t ˀAi] _ZXr#3һ -wf2C.U
/N<#hu&_ '߸^ @*
    X ̀>u  'cU Y `]soWfS^~Xf3fSu 3 Q>aY3:uBE&8Uu8p]
R +B&U
ZK!ؾsovZ6fYB<)%qr ; ;e!	Q(0$
  5Ãh_Qf`8.
<t Z0ێûPV#
@F^fǐ  XaED
ByC /An xsMu\uUf`` Fwq. fafSfQf.qf fff#fYf[2VftGf   qIg@f;t&f 	F $f^`2ۈf`skkfaPP3_X.>q , . P	TACO F O 
!	& .?q 5p<Fq fF_f.q  qF.qf.>q;E.q|@  tqttYpqtNp  D@SIVfB.|f$;VrTc%W B!:Z\ܐ	i %Qf2$fP'fffogf"'or. p q%f@cfPf.ffHpfXf}df3ۃ!u+`s?I
s*"/S"Vf+f;wfff33RREqo4^q4'r44$.71p6ɐp08333  QW>L% _F
3}5u'JE#ȩ t0 t{ 110't
Ήt} tWM_ } ,   ؉F EF^V/ SV^@F uiwQ` &t Y&  
 < tr&\]p &_\U  
&kjN!d 
SR[u	F@&a#F^[_rF FYBp߀TV'}pVWًذ|' ! _^WfQSG Zf^at
  [fY_` t =$PnPu2Mߋ!t6 !s } tp( ` j &&E?SRU Qj@6^]ZV`} jwĻq^XP
~*F
  tI# b  QplF PFq d3duh<Ku`<Uuùd `h4ﰭd & Xtû   h.B& h/PhE'`X!$!"   °os} /ehEr   tGt 4  hHs` tKu& & O 
 ` hs@<t<uuв 
0u?z1*`P	sh# Xh _% P S'D[%ys%aPXw$# )0)t`($} f.`G  C@ kDoQk@7] À   ; Z x     0N@`a#ehVr1fF3.{5 _r 
\3ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^K{.~r@V_ 㐂û< fu ff @ffR@   f!NP
 ffFf?3fvZfFsfBf㰶fː1 r?9f3ɰǿOZkfqP  faþfPVa3v޸rF3PX

S,0<	v	,$}.[W D`
o
Lb f s  fɀ
TO
T0p s 	 
Sf_f q ЎfvﭿU.Y,} P蠷:F q
uf^fNfV_f^pPRp@*fV|A6MFp2`hC@0Ͼ
0ff  fffffXphq p    `907 P9󤾭  6 aI)P*hsP, %ofPRh2R ĺZP $   l9:G;6TsPB    NP h1[PRf2MMSh9#ZPSS껜$賩КXpq$ q~!ʰĀuǀ̀!A tܠðv|tW
t<1w(<vvYh\PjEhm3%_ P焰&
0
3q 33Ҋ%_tW/g.&;u;@.\onut)@)h2tu ׀a`2G@t03@ @u  o[
u93Q2,;8#tN 

P%,j?rX?0AQr X@YްBSQ}2P5(a&& &0hkc h#Hu򿣶ɰ h
t[ Ȱ t
ŀv#t_̰,5-PXv8v&> `t`_P3 u $h$W
#RV 蠴s}.> uu22hSgu]迅uXP&
wL2 }Q h2u= Dt= tYԀ'
YcY.^Ze1蘲P #GU ð Pf^ ]  `rr	 V&afOLPH      @6,P0;V(s
u^V- ^"(P*^  2`}MqSP( 22< P*pX[údB  $@7R  Z`7               MtP( % $  rxfL+_  ك%rSr$迎rF!f+Df+\ r*r3w r@ . hJfa2  PR3 0Z@AR `&?Fd??uh3P&Xh r.>.pu 	AQR.h f3f%  fЎYURQSWF^
D= F\ ^F \މ^t
;v F;F
 ߬< uWP  <0ȭ22 IF t Ջ~u뽹% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR?]]]/?              $`ރ6.u;v` Ql0 >h *Y`"QwLQ0f&YCC`K (ݰ  P3YaPSR_P3@mn?[`H4$&%<GP֑ W 	 oѹ t <BMtf3puGP2W X0 Hr
JRU3`fGenuuhfineIu_fnteluV=sL=r=vS߀tNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<WtO`NBH$u>f=Pۊf}f+rCt Btq#Bt	ݱs]  f
ff60rVZ r 1Y`W3( h~5¸tt_rh`D trr	P}RW Z
xx    P.BB <t BB2J &ݾ(   8u!@`23
ShSt0` y aut0i at]U U[aSR  4h}k
 hckZ[`-1PԻ  h&-S	 h	
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0wZnh)U2<U|u{ hD\ݚ u
3Ҹ kEF) ud^st"_ 8a ۣPf.` UfQfRfUfVf@Bh: rsNrF 1f. ff_6f^fq7Yf.>`fGgffgf \uYKU q u, P3	fgf CPpeIfAgaff.#f9ufjpfY'}0  /up ;*h
+ $ ;Z,& =T h+ m h" {6తЗ>TE jUݳu	 TV3'uWtyU#;auG;6
pw
4fYi &g 9  f%,"O [FfFB^faAhV p ^  
^gq``3a`<   o DTD_w R o 0 oȳh  1    l ( Pb @0 W HL P`A T W Xb, `
`! p@pؾx o A
|\DQWhCU3 3_  0 PQ= `tq @YX :SPBu
&ߣ p  ff& X[ fa&    i?r  ÒzAV|JVuO fQ K@hc./ۀז { <tl~ tq.ri."D.|u.:DtSI  wD:r5+s&v
uAm
c1DQRfW3cX
f@ 2f%?03a` 3	  "	f9`W pf3fPa0WfX A h ZlZv m fb  #&dD {	*ϻ ';sQSf  r5q B
 t
2 f'ƃ0
40 w
 [ffY+vf`z q_L2_& uZ=PrUf   uCf*1Iwf=`  t0  t( fzf
0"f߰h3 ;S
 "U1US$6п!Q2 f  tˀ0 g&fGfY#Mn~rC*@X'0
cffF &Ffg&{ t@sf @{f;~t	um~qNтV&Î"aWfVfPXfXcr<w؀.g70՞Л_ћcӑf@&ːtg&TfV83g&Pf  `&fnu=жtsaNu(g&fVff`"oȀf+)^f^u2u  w & PP0Xt'v t
t]@W % r/o h>u hͶbst-3&> nrqr~RzsRƑuth<$uul	r` 	 +Zÿjj b6u|S`` FF ph ru
O@ @kf&  ؀>t !$!֕$< uRCps 
N<_2<ă}Ɓ	"3A'y@h[u TYP=Gt 
u2Ɋ،@3Ћt<u
E< tȵE$<u&w $tRV-L  N L Nfڰu ûН t_  P[u
j j4Y!gQU(!!2(<!Q~e$ h5u$0Kt]$o~A.#K,.t4&^ <r&w 3.\  5!.\e@.d b    W	x .|h5_DuQ&~% t PWXӹ
 .:t
 ._
vXP%8Xr6%Kfc4;LѲ    PJNL p      QKOMp @Kt  Jt P(.DGH hh ߂ hvQ h҅ hE ?E^Ef  Cp_ m& OE 
v %&M~t&:
&;r"`p$v`t1T/Kub 
HM` `(q @" sUr#	cp&3a C 	H ]r5r`2gpjh!VvZ7aVRQShk4Th6uJ.`PZ68u,2
t&62@t2 sk [YZ^Sû Ph3UX<?tFhSUujjjj PA- &h#w\ h<w$vbwt = ;t= Dt
h)sp[;@WVS$ћ$
w5[? @n< u"*׿OطhLt`-->J=Oti1 tSd rh ڠ SˇX   0 hL  5[ ? _ :N2o?Aq% p 	
   V짋FgbVW02_2µzt"@uG2 
u
25 ?
r2E2&&&EA &e?
td&E&&sE E &E<r&}	rw@ VW^2й^2*à
&}vPuh_VRPRQ3f 
%*tW,Y0zRZh$tu	pp Є> :qQ@ɰ5rXYjW-: tY
*֮hC:&&  t8t' u ag,& n+q00r6$^$ Z& &&K ;`Z@ `dde`P`  X#֪U @ڰ
ڹ   .PB B把8uG` wA ; w5䋀/)@#BS 냑6VŜPX
 a@A@ B C    ÜFtV$݂%Ȱ%<;weċ X؊<wM3ɆQ#"XR<  YыƊȊ3ЇѹE pY8@CH0	 FWYuF5<uz`0Df۴&	2U
pu8f߻h2ePӀk ='B@. ,".  &k ο!< uf& bÊ$
r wAu%1uhӲ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh9b|fLKff
fZhZf3f3ɹ f Zf0m f+fZ ! KLu*LآL3ہsV4C\` a^_^fZfYf[}fv3h 5U{`2K> 揀L0s< |&	3ytvou4PPs 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .Ь\3۸ 2ҹ*@GaaÍ6ܬh$VWaܬoǞz_^p[` hΫ"%h  uP$<X	"sf @  t<   4 r	.q$<u
k` f3hh.p 
d]XiJ0@0=  tdbw_3s.>pNfm thtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  hc`5/
P	khdBFe:Ffu1r,
 h
 Fdt;   	:  <g htoQhh`!af`7UPKh3u>fBїSCA[t$ N hD&N r hPfaV   Fo^P XSĻ  _y ,    hb-[t(t@tW,Vj Pj,>" '  thtZdúߋw."**ED/.EqEq+Ë؀F/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYeb +Πu"<6F1 ep0Fff`Fup  0j(j	R"	aURhT2  ɺ 	1 h-Z]oR+Zr@!  tCg˿RQ QK.YsY2{$
 _!u$0dU|Z f`3  3uW fI%.&t"^ft  Ch"
>C u8u.>?r 1fa
ZURtLUHh~2k:Yn Yp to(tq ;CPZiv@"go  squ4@VfRf恎hl}0;^f[r]t8" [ZbhTr s 6Sj@ 2P s rG=Z5'_UqWqW`.suQ$<u:`pKr"&  t w ttr tAt $utPq9(*
ː

w `XSQ 3u,S?蘱[rE	ˡ-Y[C& <ff<`00xx00`||	>>.p~r tr~ k(ЃrL]CX̀'tCVG =`Q<Q7W &TZs6C  E ц߆ԆrB zuN! D /u 0/)0/f#-&Ao ;q5 F -7&/|0W aUfV3vCDPDQD 7@4f^ǋ]&໠QPVЂ wPduXd@I(a@1 `O` ͟/////- "  @f%pꔹк` FACSPJ DBGP4BHP  0944 A!  8  APICZOKm	a	Q
@  	  MCFG<	P	      @  R @  
 2! RSDT(  	f`hjhs&f  fh@pfp  gfFgf  FPTR ff0WgF݌pf`f.p^$f3..f.f@ gfN0~$f;+hpJS
f3ffgf&f.>f(.t2W2@_~( N g&F	f P  rgfffff+f+.
oaM.>f,p
$$#DPXff-qAFV3g&fFg7Y[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr _v; tg&P)XfY8]VfWfV*f& fkP&ؐ@(#f"fP)6$ 4 
Ȱ ּ
ff	hSucp (f t  hmc^fPW EfX3 rdZ$c g Io+
h2< ;g&h&P_g  PSV 4tG$<u	@^PR 	ZSWtSfP3h f&L f <E`Lw fX`h" 03fp&?   6u    >OG@f3M{ pA   U!   D>-&geE E puMPMFGfEtXAt$Ot3 t)O$fM
rþQpmMe&Dax{drU  r.`]hF~*.t<ahP5 诺 øֳ`+hWX1f
඀hg5edf h~50ttӿ tۿh3߿  ƘPio_DVΎގA^`ѣf`FF  h7 }uPl_ h6  U$g(,0wu4'8  Ã9FtFfNDF> hDɀuh(fa`c}
Ep13ɊMhCt

h ;r#uacWF~^ Fݼcf fN0XN@f.90u 0tcH rfQPH_rf;^uf;Nt;of!t)  {
tF~U_E _@
t 2p A MɊP2۸W
 PM^@`CYQQRWV ft
fq 7^_XOv0O@>vg1wGuVf gzi0g tf%efd@訧~ 4  taB| Q	Qطf 9kQV2	
g&GgP u	G3^YS@8wB H. 6 f`lSRW}G_Z[StF_T6:4/  vCI ELA GDA SXC TGA R VfS .o` f;.uf[^f`r't'  (6r(R#6I$C$#c*# #$##ڑ#i#ib#tS+ԱE)iw@j]g r r r
Y2Ko#o#e#j#WPR R f?F ZX_O%K%M%J%J%G%<F$ s s
G1Rз
G% t	t;H 2y{ 

 2t9 3
ZS0d2  _1_fatA"  F
ﰙ3   t'0gf< Gh)?G$L<LDƐCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCI9}Reflex^ v.2$cr$HP
  ]a@!g&O@ Ggd`P ߳ rLfK sufr>G	 .D
A O@.d.D4f_ PQWʹ .
G.g&:uG Y.5{ _0iQ8t<tBF 
fWD
"
@
@"gT
b߁%Qfy_t|`Sh0cu#{  0u0 .qu = Ў~1rp&tj  t_& rT  r&= us6>
r/6r4.q؋V@< t ^pJv 
w x y   h}-3^h/?z D
ZehCaa
qTrPqtI	fzU
u 
!tQ&p.3	GYSQRV
},`؍vfD   ,PffL s-<t(<}#@06~ h	L^ZY[ɰU32t
t
u
5# t u9<0r<9w/tM> 7SQ Y[t>"$,0>*SQLiE;f 	t>u]s̷f`P3Ҡ&&{hr#֎fv*`%h._gf9t0Xa` 2 @u  0 t?hb&R egf@ Vff3u"gfd Ff azf t
P!@S3۹: 8tCRP #h{it rXPhf ufXP  0 @? 0  u0     n'  ' D {
 Y/ bKbkQBs2@GY kv0lѶ0PS_.рrVW uЌ׎Ǎ~Qr&} urBr	w{: v_^d>r5r!r\E@&=u	#$Hr&E$7u5ҿ0C0RYӆ
r7&a)B DTtr&eY`4o5`
T3
ë4SVr#itct  t$BffL  	] 	WQ
R3q
]
6ӿQl0i+Wz Pr8u`_QY_ þL[ r&UǵN}ѐL螳`
Pw4$X` $2L?nB 0<tH`8u6
uBp & D?BlT
[aP `3 r/) r%BϰB!J@ 
; 05 aù<t

B J 2@u8` BI2۬2Pu+BTl&2]Q8uC\u rq@m ri ~ racñ  tAc rF n r:i r5&D@u-&a$v޶Q> Yr	2Qd'YB@Aq Br썪蹐Á^	pb3u  ׀ @ `ңPX H  	 
 
 # ^F 
n
B B`{ @ OjF
@ԏ@ 
@ vB
@
 @UD	

@
@ 
 G 
  @ BBD

 
A@@	
Ҁ
    # B"E
@!@C&H S^$v2u)w"g&~ypґ t	"u 
CMO
 N150X3-L07@LGPhilipsLCD
LP08-A3

AUHBAG01V2QUANTADISPLAYQD15XL0s61E06K1SAMSUNmGcLTAPG@1
TMD1?41ECJE No41XB2
Z              !06r[>@e  >RY w 63Ҁ7BPa 8u!!u
( H 8ut	3ҋʸFސPW
 
Wt_   @ك
_Xå'   q    SETU ˸ @؎&м  i r' W@ P& u_SV  GG0G huߚc    Gu Fu t3  hC) 
hjBt & ^[SO
&hi" [U샿VWƿF F@    _ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @,<qt	dR>t <tjjjj3PA- .w j5$<t.<@t$t = ;t= DP6 h)  揿  7FF~ t#^F&Lr
F FQ  ~ wt: ] f
 hO0\2%PFA~ t
F_^Q
h8ss.&udu`   hc,$?ػ h*"hk䁃 
#h*f_01Fh;B%..  @  Y(`p3WVe1E0E.WV .^_UiP)UIQS6(6*`e1E0eEE.U s@ m2a h{4$ex57;$!<$:a3qr  utw
t1w
tQCPSQW33۹ G&._/N_Y[X   sc1@ @ p^ B     6]xsqUmf* %  < ! 1C  3	   jQVWAu% p u 6W  = <tKPS"eTh+$#U{\$"8u! [XAB.o`._^YRW W  Ê [Crr3ɺ ڑ܋_AB rN _Z S\5OO{O
p]^TujvzOQPSJA DE<@ ;w<<!<3Xu RRځSt
vSm[VfPfSfQssf3f3sPssXfffDDG(	Dh fYf[fX^y# OgO Gx!tQRG3ۊÅ? 0x CΡҋ|B`sfDf3ۋfç\` 	
C  A	T U S V i	}				`hA	 |hI	  hi	 h}	 h	 h	 h	 a!|v.L.< t)F.63.PF.h'a[+V..^̋] pDF. P .?h/7Xhd ؃:R  16W  0"Xa Y Z #[  o
\a a _BA]a f g'^va b ` `hcij!k qp10G pppQWĀ>@t		 u		.ߊ	_7   O 4a9@Xһ -w C.%/T2@0m?n8o7\3۸ U _d߸^d>QRr_PS[Xh<(! lЍſЋh
3     r     KBC  [m( Vn   Q LGB=   0{+&!	!$12/15/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;K   09/10zE!0{221{kTaos  {4{{.pTT"x#Tq[T0	T@ 
t/{3" 6xgv$dPx>0Y"2""e"" x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01u'0d>01"xt}
~"x_vvuu x!Du(u)u*) + 5KFGuu!Vfүx00Pl9}Dxg``
$`$p
p 

x bo
x2x txDE0SxxxxioD@Н.p_~}@ w p :ǐ}d`xGmBE&x}Do
¯00xtxtyuu ~	)#]nb}us U}|c-,"(xmD0p[1 x^Dx_T_xcDxfTү p# + ._Uf"
,&60pA{ pI	 Tx" R3
4~4T00ߴ0}!T^ ^P %u`"0	ޡT`#9 *mY08|0pi	P	B<GL	+u+$*4?jA~T+}'B+p (++@],+G
 H
0%1v 8",`00}k+.@ /2'" л"+;x&q+x_`t ;":}
PU  !	 ~ @}A}
x xt"xf}Bѐ}E"* 10}=
pZ#5<0 0x )xk`xl  p~ 0S+;0/TB+x+ ¯0+60 b 9YP4.>+ 20B+`xN	+ xTx !
+:8DTBKPF@ y+P>

 C[Tdp+$!$
P+-` 8P` ~Ô2@VD0¯xx7x8r x008`:%0: QATH`	p~4UmD"C@\ZVZl000+?xD$p@P	_pUү3HӔ@¡F7
"[[# O[{x,Xxtx0x,BSQG0xT?Tx*\-tx+\ZATOxY]3P^^J0PPP*	afn`5"uxb_FNF0W=j   >Y>`gxfpa	B>;?ZhnS@*ATx-	+_UTNx*UgMx+` N }pAT0ʀ 
seS`
 TURR1Y 0X Th G_YxZYZNSZY }#Z?[l0^1\1\TO\:q
[\]pc^/^TT b
2]	^S2A}@ A}=@ A $.354A~Q B~S  9A~R uuҌВ}"l"7x'q8
[ 007d`!7 k33TT?O C07`'`2`=`HpQx_ 6uuuu ob uu0 uu5ˏO$ƨpN`0T`
010`0A`aA"| }(x_ "+,,E+p
0 +AD,,+ +,+x,+0pb|!,,,++xa,,"ߨ-.@T0y M72wt
Mt& Jpd `1gU1}1_tU<!Ҍ(0響/0mp/l`
/0d@T`}E2qA
 .-/0T" *xe"+xt`
o3x7vx8aW7t@
 l"d[[CZYucdQ"xe[ A]0^x,  9     < .0 1/5 , =Q@! "    V q -; x U:   yP sW# $ )z  p 2  3 
{>a\dfUP	`[_
eVQ4c7j6h&b%](i'g+lX;oZ|?~|2Kd		

!$(+.2   & % . 6 = > F E N U j f 
   
- , 5 < C D M T [ ] X   # + 4 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@   2 Y	Jw @ | @ s   ww ~~ r  %79x4+D T` sDp)TZDx2tx1tI-0([0( (xsvv (_xsv[EXxu%& ' ' $2x1 	ү  ¯߀0 `̯&$@K3%b0$	Mx3E
r eJ"xtF` W p~0%" (	x30&Y0'<T`P%"xubfp
0$&""tY.4} 
xu$3z 
`Hp`p$X$N yup0xqv"x0	D0$$6Ӕ@TxyD"04hxox@ DT 0
 acB"pxw1xxx"xwxxxxx	"xz#xyP{ "yyxz?f`ӀpsxzP(X Q@vBB@
"00#+00Hu0Q Qu0H0# 0#
 *1HQd~*8  = ~0#HۀD 26/(!a0#0
	0oN0#dH"1p9x1"`|u [T`""3453 /:BNP"o3554!_Q0		"0#xqo`xcT`a} xpqvpP,r"3}TOp0@0 0 
,P:QH /[P'2lB; P`Ӏ$Q";<a "0a T?2u$40<S0#{z}yI237=
ui= <+
`=;0=;0;@2$h' Ô@]p4
D

^$EY
0


@À{0-$`
$`$p!Àa"[V4#K0# 
:0!Z@ß-0
  K s	2=0#
2xqfKr0*2d|pSH{zyD xrvJ%_`@gK=P2 ( 	O4  "QH	5345q3`	t%5544r
@ :0
h0"0=`	M2A0=< LGJr@1@^ 
 "
 ,90 B =, 
j	" #!`BQ
p0(? =!^ 
-NU
]DU =.
j'|	20#G+A6,S,zVf-e2pO7)0	LP85p
b3o&Ҕ0Z5c	z6j	0 Ql":"08_8;rfpO:2f`#/c)P3
r{Cxp`qe`?0}?Dp h,$g,#a,a b}jFq"4xMNOpxD Ue4`^}W Vp0
T4d`#"4#?p~}j4zxdW@3 0
3 #`3`3$`e$`1$p$$`9$`$`})3$pvA?T nq2c1[0TxvF>&`!	0,0)$Ф@Dx Z30a 3\PA6P 	@Rp?6%¯3`p` pTV`xm  N) .xv
xD}T}%0{^`
}nT?DtT`PuYT卤|Tmq"@`T`yR	067``$p``1e7`tg7"r((-b)(ူ u'=0+a a
Td`x0dp#  xF 0TÔP
 )xFtuxBBzxNUN|}wxJqJpr:;<t2/a?=*x ү!:%$*t=t=;2*0 *=$Px`vT"` 2'<x"3yю:; 0* ;:@ p0 xvs6xV86}'Bp p 7  %76'ŏ7  ""88Ô@ p/p0(   /..d`
&6~r7(jTP5O(z 4 4040@O453``/`@$pN߅54:$I&du*);
P [x 
33oppGҽ,L1ـ>gp1 !';P"T~ -P2V?T#>үd`pxH 8@22P65bi3e1@dq>1/ڀ 
m
`+ί0xA%30 B1
@
 7`00
TDT@5q0	 3:8@af AP}St
 u2P2btl@
p.
@	  r1zl0dpe`30QDxFU105@2`e bC7xnu30 0u3r2+(t1123#.1}p<0 $32  a<0 }?
1pAR ErpMf"pk  d-BS+x0,u`2:,]4 2UU.X5%-,'*W 2732pha,
$+πO!=% *R5 
Q'x`S+0	+_J F-R	++@@Y@`p7v@}	 `@~A0|y!T``!&_` VWy
7pDxp.LDy?N%@k5߃3Eop;OCDw-qXTQQu:93:o !p	S31EB3dUA`hy%%Ovt0QON@pHR/ N9
d.0
`/X6Fp0 X-64F0570`5#O02]c6e`	S8@1
!b-?1ÀI%P/G;_u1
p< u1a1PV,C{p4z5z5
3z,-yuv {| A- 90!& n`AT0 -	al97pd01/0!upo6o,/-.rpF}}0
P/.-rdct2%,f Wu tq70YS 8S;"W4`p10BŐ}BT|_0=_<I?`$:<p:T0?Oőw78e`pYל}BxiTAxJ`%dcz0 > 87>P$3q"BW¥A3	`U`uqq
r	1Q`{o0
}
E9ȷrdP9$$P6"{ 2F}K&e'AChS4Iq}ۊa  X@apR`pLxpG3p?u]1U^#5_`@TU`#v@|T kx{}Q{xzp Wxy UxxPVxwRxv0Hxuxoxtxcxs`xrxqxxp{x`x|Qx{`WxzUxy@VxxRxw Hxvxoxup&xtPxsxrxxqxxp"ypxmv00,pTxiL4e" /4m0/TxiQi/^ NP /^ ##----i C2V?6",u/=212B0T-21Կ^ L-Ϗ.W 'q,Đ/$=
7@,T{AO-.`\۷pGJQN.E[.NJP7@0p0Y))y0h&
P5
Ps|?`d7]k}TPn,rtar[4Ng0!`a2VЕf
p1
P

Q "u- w09r"l  }tn1vg8_,  A3.0Q2O.pM=1s0D@[dT0uǀ`zP;kDS,c,u.B.t` 2 p0`u.Ta1C
.%TO]лQN]03p	 ``֠ 97b  $ 9)NӔ@6S ? x0!  x_50Qq7prrqxvWU	Xu

		0
  `
7CP"q^ J
G!/opTrAL`>M)60.T`s@}w?}S?AP33TBDWD  Axm6"ﮰIt C9xVxFld`T`HT
PM>@C!3"x+ "W\]@0Qqڢ9C 03t*v`
pWr +J)) )BpP_P` qmw0P `	qPa"PQ.eB"TQ=EP Є1n`<젊<A<aYpo0:BP e0!J.I$:1PJ+1,F;KҠF	D0c
^"CO`@"JKOv30aA!Kdp`wl@0tt A2bKBL``LKxqvJK;"xFGxGHxEIxFt@0* HT.`xHH0xI@Ft"*"߭H> 0 I<"xUB!C!A!B/)B*( #UNA
OA
MA
N/I
N+)D
J*aKaIaJ/iJK
I
cLMNOd`NPJKT&` v0uM M@ 
ONtS QPJML}n}u}}|EAMI#..CZ Ô@"#;ߒ< Q #0<W xhp   ;#"VxDTpVoA p ?$0,I;E}@>qUTKF}Sp+WAA@@@@@@@@@@@o@V@=@5@!  ABQKK" f&edr! ?t"xdr o "BpD)7	RS#q*! * 	A^v `>qX`S \X$`RAb $BWӔ@W1OȯW0	xqZÀӒ"}vW`#`5`2$pCxD4SS [CxcWWT xps& OYq 
xl0y GÔ@π<PTxlC,@`B{r
Tr"  PtlxhxrPcv+xpv2P9Pvt04}tt  }I""YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBRBAC@*F?}Edb ${EŁ0*`Wd`)fuWRBDCDOD[DfDDDDDDDEEE Eo(E? BE]Bo>D 0stSpA$9 p C"-AE
mCPT gߗ@LɎ0M7 Q&TF E8@UxZF!R
[hrap>@XÔP`A@8a{O0D=Dd
`#p`(`0<`PdP`d`W܏W0>NSאˍt td	RxtxLxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtxt#x> x=tp x@t	p0xTВ
}'xt&"Ttx!TTTD	x?D@:xTT@=TT	Tx= q
@Tx#Dp?m=DDTxmv0}Ht V eR@eWeUeQ }T:"x0xI"xj/L"B S?/?@>"a$tO>$-"T0`Ô
P~0~7%WW@eVV7%VV{ z yV HG HN+HV3H^4Hf6Hn7Hv8H9H:H;H<  HVY$1	 Q
 I`A 91~5GɏV& 8 `;cuVuVK0V"$`($_`*`- x/arp4P
TmQB  HqRb V U"WQV$```$$`(`7`F$cpH[	A]}@
:3
2! *}0P6 `#'0A``,`003`G`[$ap]Vp"V  dpF]0$ks !`!DWTwwq0!$ V0 W "S}$pT_&PLSd`PESLjSÔ PSGHq@P
pKPx7jv@JJJJJϤJKKK+KFKNK_KgKnK{KKKKKKKKKLL*LDLULZL_LdLoL  L0
`2v"xMNO`uTTۭTsx}jF  x-  "$"0TZ
T:Ip; @x"} HGGm}U0"uU@	0SUTU0CU0z庠 0P 0@4xwctjvUa5QP0mxTxmD0F{xǐHxbnx"x`xx"x`}K}IF	
Q@PM0""3GxV| } ~ Iؐ4S_)*N QTT &NL((sMMNN&N1N<NBNMM-M5MEM MMNVNjNuNN.?AÔ`P/."T{? } 00xe`"SfUoS1𙻀J0pV	`Ь50T:uSm0ʀǁ  00)؀	0PU":C$p
:!/0Sp,"xdP P0A3!"~}j 9z0A>T3AP>2Ib1bu{b!?0M}EAT@JWC`X .YpN|Z S m#T0TɲP`O0#0xD TxPk !1?xxkv  Tf AApB11u32}'B  $31ÿT3322@"Oh0  "'źW "   p}"/)O}0/Ô/pC0S00O2V00  "
xpo0 "ox 2345%@"(t?3t 2x325R4U5B UcxQxQDQGx␖Q  09:x0S^nSݔ 
CSQCQ.QmQQ4 RSS8SXS_SlS:x
/0Qx
t/P
߅0/x
  x
Q{PNx
! &	:0%t %T 'Qxv	}YBxu0xußP2P0 p%@$Y$ÞPxxu^a 	^I1^C,-uߨ. <T'ү$`&0p<P3'} % `Bx.-,
:	'xxv?@vP$(xuvyuxvP!  &0 	r:
p
xv :.t`x,
 ́!V @	 -xx
xb "x	6:S/o^P*C"p :0:Pe@S SSSSSTGT	T
  U{}xiD̤ D@@"xDcV`$P``3@TOBX X  -D"p{9TiO`/AE@E ,@@jCEuUn Op@ | 33TO"Bβ@x0"<à`p}T `8 .5,,F_4S,  S,`xgvS, ?VS,,"+,/0.V ĐVCx	` }xNJVCu0 u1Txh`?&30!p23Q	D3E2MXSS0S3u2 u42U03U1Np1%10304440P-5xp7x	410k	^_1
55.?@xA1Pw pX:0c
.pp00oӔ@00.	`	 VVWWW?WWWWWWXXXXA$X[%Xg&Xp+X~,X@X.P:S	XQxu/@xEP[-.^P
.-0]<	
x3 t?e.?pt e-``p	cpQrp"	``Ex@}v}t"*
/!  2#t^.Qgv  q} pQ t u vAO}	}5! R)q逩 Q!q]"P`2w0 ,+"7_,{ZUXXYYYYY Y8	Y?YFYMYTY^YhYuY|YYZ)3Z:4ZE  Z@@\ZE\s  S1
tGt)ʵ|#	
pt&e/ (D pTCS@WT0BS
:4^p`'еPIĳ ]P  ڒg`P`!L0\t(1D8i`r`Obk#Q
 x-⌀p
*!S`pD!T,!T
MpDC_"gD E-@g`/d	`+d
`&t .e`]`Ӕ@"--[.t %-e.`.:--Ô@H[oZp[`to.`K_/U.`"U/`##,/bÔ@%O
	"x
qxt "`-$qqT"x@Q~"5}@05242b   _." \r 2\w\\\}\<S\U\Y\5b\[l\Kv\i|   hpa"xnސ00V@"00	B16(Лa  "	0[33%$N_e2p<2O640#0&4#n

4xqv"
@"4AZav!4$`'$`:`C`L`U$`]`n$W[][P 00f5_QR" 02. 0	qv34A!`hg4p-i&{
D"	 ""$`џ`,$p1	#-2)!%0#80ccP}=
^`"x%0T~t@"_Ô@P@@	T+"X 
 O@x~ d  " ˿}t0	Kk^x0x!TT`D0
ІT!D`!TM1  /!\_xD$:1]"  ScvL	\
l|b
E=>C	D
WX~x`!pBP ^`_b"
% F`700x+ +axqa(;+s+A `C00+xT :D ~ 2}.Z DT_`Y eTT`+0	:1 a xS 
0cx	+$```9`B$Аaxv pz q DxT"ҎxStTTH_~+xS+<x,{ :,0<`$p#ݯ(xS xݚ+	x0:00=

0_ "`.qc@-ӔPq @
dP/-$``C$dp<00UC.P}O.H, @@OO`0TD>nTUP#@-p}} c C/.. 		bnB	@ w	$~`E$`M`Q0M`_$ep`. .q3".4 dpI!0Ӏ/Ò0`tq xn..T`O"xh."-.{~{ i"s0$"x8" 	P	1t@ Þ߹d`JÝ@ӛ@*޹ÝP?@Au [t/twt"/0104u5PGu<$t}5}ౣ/@scd.ddddɈddeeeLefefeeeeeϙfmfmfffϡfϢghghgggggѩgѪgghhh\h\hhhhhhhhiii8i8i[i[i}i}i}i}ii  iՐ~P0~%~ p0p& pC3/}u? u@ uA3{b4i΁T3P66A~Q 6` P_wR3`0u75u3@u?u@}uA{uxu{]{X$:?@oA{&5Սhg0  0 _Uh)gU

-K><,@1E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+U/*81U,/h3/U1G5H13wO/|@T12SRBPA$__TWB_1 u2d I'U8B=9%U'8FGUXC*IˈEU,L͸G.Uo`VI1#M0V6P!}VܸbhQ/"qVπu3_//\Cq/4"$y` !SЧPpn툀nA @@ "BC~L`jPj$k+`T}'C`$ $xvB}}Y}մ Z  [xsDDxvPD
Q0`0&70%@?"Cp
 p_"'@COr+ 	U 	Z		[ 
 
\
Dxv		 Ӓ"<=>x>T?@Q
3=Taю@A~`d lPA@IIPw0?p/Pנ=j$ } P' =@
ఐ| $ >_<=>ih0
.kjd 7Ep6Q"P
}m`~N } p%}l#@@b!p92Pgې}P@ MTTni Yt
#DpV{1P,pe +r++/
~NwСe2!_$QIv
Tl@&p0t'p 
82olm"28P}muw_2xg:0:
 1ȇ:1'Qk}e}ppp3MT?T`8"8}" u2<0n0`~~c^z@0kTODՄ001p322]* u1AD00{ 	3PP0<*PQu2@PD=2B32ӷp0<7P0e`&RP@P}`"aR3"^0pwT_O"1
0;0% 0p$07Q7@,e0`01?2_Vbe~p$0oఊ1!n10~ W c`KgM9 	1DcSA&K@T3`02`;:+"45675E4`5469P
(4`i77$To`MӐ4}`TM=`` `'p->T
r AE D1 i0$@i@Df0Wq BݿÔZ	6*u1au0)<'2u0p
1}}]34Rӝp2u2u0O*> $3@P20' ac@'
L`1`2^qEl;8006`BTTT%%OP>6xEp0>3`Dm
` 
p	0d`0a1\Q]T?`<@7!?$p*3tT9)	 #c H@J01	a=2`nfO"c"Mc#N$'N&tn޾*$	??
o)$	6
??u)tx
dd7eU"}{zy	1uWj7ujdj12uj08<t?`u/'P~ s./ds5%t#\vh~@_[tQrt0ppT0qN`۔L=2ot[	ÔPt} l q䑘o``z4589@@oݫ43;3 3vg((svww<wWw|wxzy4yUy{B|+|}}}~~>~_~F~	{ z y4k6	5P4F w
R$i_SU |SA1
3D#-t?~5{Pu4`u5 ك	]4T`pd`@Q?
p0
PFv	Iֲ	uLpm[|| ]axu[}ट} pmkj,j jPKE ß
Np&d00z@(
r67d6`N67"PnRKdB0,@e5p4l`&J!:*:BEU2| A`z {E` @\]L׆_vSv:;;;::;dp#!#f:
;#
							@4uq0F s	Dt[;_:(d[픜q\PyD-00* 
E0Ќ
jZk<ÐIIP`S~dLpt+#aM`M8@UD_qmpGl`T@
`r/@A;dNpt/ ,V+ō/XPYP;[Z%Np7>	bUEodQp'pNWWri/'P#^/i 4֞(?QRdn&pfJq6r<Ft)=Vv>fx?UMr iTE},KDT-`M0398203,78k3? ;vT538ofW<6f{z'y x `45A:pPS8Ô8@ 33<P03H9480595(@5 {c
`44kÔ`40<q 305=Cf
`@$?}3)u?@A{b&00u"2;ՠ}ߣB3$`A`ympc $ 
~ 2|ɰ
u3A #ux;p{0dERu3>t8u@`ZÔ4!@u3qPڏjPt;p9PTT Np: !@p);4u3tuq$e3`3_;11`08Dq P 01  ƀՠe031$1Apig1pS2}t`6"u0Xl03}owRY%>߅l~
N0:>F2pP߇wu2f	op`8
0ya
``F1)100! DxgT`0?$31dtP6"u}`q 
@"""`tt ^P
7U06	~MTD"LION x9pP
 D/^T":e@a~"/~ dxaPÀӲ  0d"0Ӏ 78`@
D #	"
~g,T g8P@}p 61"a,"`"x0 п9"9q"px 
Uqs>Q>~ 0 on`dx"7@@?8u8X`,Y7bP| @` { Pnp	84g^k8$b$"zI;u<98~S98lpe;g89E8 `v@@~+P"~«
`<0&x33 d ::@@u:@@?x#,	 ,Y=x@-:Q =^W<p ;Bۀ
8 91@]=<>?u@`"H P/A(p??p>?
>@+@9{9@@	x&Tp/"%T~ O 8&0@"`""x!To`	TOTp573o`12D"E
qEpx6>A4ra/T(--,r e,p,Ы,~Re,`,,|211H:3>d$-t"u;2A&8<9@Ju;;;`/
P9:9@m,-kx>F^PV ~pxTr-- ,P,P	tx턡G G~QF/D!I!GT.s56MF66 55t
cNI/"¯DPwDV9*x 
-
@^M"T 6VFGL,?^CxtP# &T0xT1![4TDx!D@\p
0g1dpa23b33`22u320@ނ
4rK ]4@bwU0/%%q
Ok` h006OT0lQ[		|T`j~Q` B$#Aѓx"r%"	F	 >	m@2xpd@X LƀԀiu3ڀʀ3ł 
`	_"3/$ ̈$ P ##EN``#sB"P""):"P%0 Q"b``"  )"u/33@p " 3@P"Ø"ſ(p p8

r𣾁
		
tQ
X
	


 *2}@	1	"/t 
""̋,a   ͨ-8%`,5P`.9<-5 "BBE"""ЃПP  ts]6 s)ŃŃ!' "%ΐ$5Pbp p
s@h`6p6 6@I~6v6@n6 b6V6J*6e1616 p5p5ꀽ5p555#sp.u .33ł3ł傘@ߚ@-"  Y -xs3 133@"3@"u	3@
ߚ6"0Û0ۑΚ 0
ß"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  t  F   P DSDTDSDTp  5HP  SB400   MSFT[\._PR_C000  \ 12
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 72ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD13phg	gi
 0	4kg 5 phpi p
 fp
`'fg`f b~ 5f cufbc``67E
Microsoft Windows ?ME: Millennium Editions NT C8F
p\_OS_`pga.ag)`B7
bra
!ua
 n6
 s %[I` 
u	2 p
pQ S-B8A _INI 8H A
fpig
f
 pi` g hrgfata
apa`r
ahha `a u
 bbi@ ibub`L\[K
(B_HIDAJ	_CRSR C)
&	`++
)  p,, }p- y 
 ,F C0710t511 2C3py4
13t#13C5 15% 6 7  8 ]r @}A"6([	B   
,[B11CD6[
^ EF	8
[A
 20@21Q 2 3 4A5426 27H28
A@[D29!A"2B'8 CD(2EQ F`
30V)31Q 2 3 4 35A36} 37 Z 8 =39Q A B CADE0 @33F40Q 1 2 3 M,45
E!ߓ`
pu,35a}aiapa ib{a}b[p6'
_ADRPGPW
_
[7]QS[	8 q49
?4994A B

{[P&4B  C 
D B/@N4EC	0 ? ? ? `? ? ? ? < A0'4F [#C050K M51UH`p` p`b@E3Ee]e` ap dpy$4cCdc
{M@<5bPEd[52@JbbtGd
q07pu@D2dcrd~^4E` dz0RaepR Pefuff }aSdu`['AG2Nq
c\/-sP46 4`Pe^ A567 O
o458L

 ! uRuGwvmp#
PLM  `s H `l2?y }'$52
3 [d50 !75Apibpkdrd
eϢdA
d hb brb

bhbUB  CmD2j i5BS3 CPS5Ccrcl5DBbWN %Ev%wr!arq58abdbdRc e
ae
bu1eatb
bP cea(
`bac 1`(5F# ZsKbepb58
35B 5Dc-Cr60@Eaa#y`E`r61	62
Vj iy A"u
i62Qx64p\/'4Aa{aw562bpbe/5{4C`5 aP   aa F60y{aF@K`r5_S3D
p 4D
[F64ML66
@
[qo6  @t67q`69 D6A  @{6B q CD 
l 0EF[LEl `7071Q 2 3 4Aj7671c7c7Zc7c7Co7P` P7FP80}7 7F H	  81Qw82U
 84Q
~84P x85 o86 O l88Ut8l8l8lU8l8l889992 `g93 L	4 @95`Pv9998>B~99
r ,s9B   O @xbIC
85C9u9E7F9F C70s qUQS3U439ABt A%6AOA1!AA0
[)T AAaAAAA9[#\_GL_bp
`+A3`bp.[!
dv`J`A6aA7{hdpjp
3A HrE `>"a0A8bd[@Up	rya
c}cb6[0ASp3+IAp!A5C3@0ADS>t7AE
DAE AF0B0 PB1 (B2@B3 (8` 4@_`5x0 "6p+p7"WhiеҠ`y
jbvbybw`j E]J[B8GhqB2EAFEZ B7
i`zHB0@ZB053u4jЀa1 hB1K9}d6IAF5i
,@P	L𿜦"	/-!	B006	[LM$ SB@_
[BQBBBqPBICOCOCOCOCn1C5C6s ]7 8 ѸCpWUACBC#DACE
<'K CF
iܰ` 6`g7d8``0CEtb RCcwc

cc D0	
pI6'G`	D1pcK{EjP#w`ABCt	DD0D0D0J
1
0
3vt2`a{ O 
 "|ccp@ t
2

]5
3	zyE3ap& r}  @}AD4
l1D5 q6 7p
	a{k}
0D2Hoj@zD5[
x6 a>J
"a$RR@4a	`Ga2 кC5BDR!6WC.7F}
`eeLPD8)Da9 "!drwpA icL
{k"DBhifq
f
j
A
 ``C'Gj6;41I3 p`1` `}
@`b$z4aAp4Bv4=CdD@
pwcB& \ct p
!c}
 jp&4cAD.Q0"83? Gr-ic}0C9yaca Fb[G DD$k  PE-#k yQ?E FE0 1 #E2uS3 㩢5O`E
tM`/#$T }8
	q
E8	a	9R#  y  Eєap!J` v`EBpEMCŠ
L?)y	a ED	0Eq Ry`	mA`v[hE HIDA_UID
`_STA ޡC^^.#70?_DISQY_SRSEKDh
8HCF` KaOA1 OQOOD&bO2OQO@O˄-cO3OQOOHP2hO9O QOOK$	iOA$AOQO OD$?+jO+BOOO+$pE2kO2COQOOB0F75885 VE99D2[p?wF8 F9
r A
 @FB {[#PAXv3u[CF8<p:Cv6a"_86A&B,C047kK4FDP[jF,Ё FF 100
L 1 :_REGǠ3!`aAuFDAD_S3D
p 4p 102({3
 h|q3A V 9*aTp	4cBCPP105
 3CXP }`=h@{`h}~k3Ci@r @39$ q\._SB_~6t
վp._DOS3g8
 a![^7Ubb h 78" 
_DCQW 
 G 4n SSh9rR# B&* %$
 
h!CPs	ߠ8hfp
` {\/]04615}` `C0D   Q   P w\7\/g3F7TB pCC|C(sA^A)D
z `^h`j	~ 9hijsv10E*`& "F
^/2
kl ~AD[IC117u	_GPE
	I
J F
Gb bPGof fy Bw111`B112B[111#4A5

p61&18`
9/9(pipP08
 a	iaq>1AP.[J  @@  P1B  11Cp # @
D	E)FV,20Q 1 2234!25 @627#2 H129 As BcC֡2DEF C13031Q 2 3 1356718R33A3BC Ds E@+3F4v4142 p1445 6 qS149A1B/4CQ 
4UE45Q51_INI U52 
[  154[  IP5 @N56:@7	`@ax?a
db`t JP
a
`
@}pa
y`}`a!@-8	8# a w`
d`xr`@
@bauaaq
9

As B;
C
1PeE F+60
uq 1p162R3
Unknown 
NiMH 
LiIo/n N\60/+62q>1
B @5B0qq11 tj/1(`1=1!F5C
a
ZDb167!@5DC]5D@@J9}ha{a
/5B}Q959!
 
! TQ!A!<A!165	0Q aA7E"6	ynaBp
P?{`rt@I867
[)h`pA2`
csc
  dzi r`a[)abs+db1/2*(wccC 8	hg3
pc66gG
cU962@{`gx %9P%0CX N 26 Aea - E wh60axra
c 
dcbpbQb,1r	3F`Y40a$(`a-:9g9$`IX6C
I+Ep
 wW 	ip
Iq:/A9."30c2c𘶃34 c6!`{ `z{b``EF@5F;  9H2ccdp eeez
cpecpciA%4 ?s 5qp
>g60p
I%1"`D60!kD28C-EG@+yN) 24Q-  
qu>
>!29  P2pzo
 5Wap(%*!A(%
BB3PF`*se(aCh)3C3	54Eata
!ec
bнzch!
C	

11aaP3B
@ ra 9PQ pUaupaHf:bcDh6BCB>EE2;5 R=66r?77 [m
6FrAxч
HP   a𩑉
Sp
SIMPLOySMp
MOTOROLA a`wC170~70
?p
PӴ 
Ajr(_Q0!3':Q{BA /B4u16b
p
a4a5
bBaQ05 pTZp7`{p
 2['^cTZ3_K6pn
;nQ"73
6!PR00 1_
2 N8Ur# "
@4
_5# 9B	 mO116A9Ѿ_4316

,
W{  (i2=84i
Á_`[K6
77
Na
  79 uF77907A Ȑq DpE FF080jQ 1 283s Q85887a88
[  A88A8mBaC8Dԫ8E8pu90B8D1Ua`10~A
Q8WDM 9a9a `Aa`| !80`
 10;l 091Ove9394  oA Q!зc!3b2cϡ3g5blaa	4fB7c194uya
 Rd
b
 `bdpdSpc
 c
@c
194BХ95090`kaƕa
v? albab`b
vbub7F83pA829q`!5#!d1zj
a6491=A '17Eqb`}b	a  bb97Q
0A7C7D`6b %8307A6" 4"D
q9
{C0 z`{  ia` `92hp!
`!zqK1A	CK2hA30$b c  d}ydhccvR0FabcA(K 9B p^^0
CcIU9DL
!,E

Gy3 1A0 
Aa930  EAAnAbAEP@[BpA}2G_C  _DDN
COM1aA3<A46
30U"    较8y aS `,A4>_STA"O1{\/R046C054C095@
 .A3Q9
 /@+_DIS h02BA3
F_SRS`Wh
a5+1A5rBn)A3@
_C}@wC

 ` c
`
Pp$OBA[TA6   
D7
__ON_P8&_OFF 0Fq PR06[C:@'7ajݠ A8pj`  A#9
."5a)9ɔ@xs9!eAA&H
1 Gxx/ x" *
 x' x)  +o @r^r_ _ u\00.A.G%..EAe.qNYm.PAB`/./ ACPسl/3!BB1/nsAG/
 *00bPOB1
BB2#S444&BR'B4'CX5_5T Uxp
 BꐎB2жrє @9B|S:B3]:Y:_:a ]:Y:B3)չB4O p\/`P%VAp7s`eT(fy`{UPrP󰩭ЩO@5ө$B6  `78  BA"BB f T
G  G00 b+bbCB9
q AybBBB7B}7ABB[%@'Cյ#[  "  y sDEw@ @ "-[21
 
G`WG     W*"/E%t}a a U!-1Fe
Gp p Gr r " C0U` `0Gd d"I C1
" 0 C2
[Մ0C")ucC2@0dQcZ (B\CaC3&Ow.҄    P[++4b@
w   
 
]@DM@+A}C'ADR QC6
D
[)CAC7 nINI	7[C8u9*APRWa
{@3B[L ZCBt)ŋa^68
 Qaǅ2v}O@85x68߇o!(@.Da
 P.
!wHPPq
@ЄC.`c~	_RMV G _EJD pB.QP DCQ D& E13PC0-QQ +1D)" "*30"	[FqѩB*DuED 
1D7`F$D H1S3D:r 4p N	7[A0D6#d,(A
^CD/.&E1?q$3>obq
E 







z
C3C0BEABU0C$D_GTM p
`8 `!D̀ @DE pDFpC0CF YDPԄD1Fv F WM hhFߓi  `p
wC1E}0Pa:` |A` bwbw0ib ac  rb ruc u0D4
Vaba
84E2E1bcDCˠ:62 !{ PTV6I
[$܀1 F e&4IN
6^
E6?? ??275f5M?9M
? ???=
93?1E6^|`ۧ
_PS02 3 T0_B 1_F	?
# UF0OF1OF2OF3OF4GE5F6L07 `2\_PIC*h\/v nt9FEoT EE7M	
/S' Y
0**  $S.d G?C%
K
 A
	
	 
 !	A		,a	9Qx7 	D
 AASO0QGS0GA3BP 10 oG &(F^VW!E8 
[E856 H j057>rE9
!𹡮 FAqQ6B@	F
Ơ*R  Rd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	AZi@ 9-5C]L68	1 68h`/`%
 
b
" 
 
!X6BhAB AACA10UEBaPEBp Cha`&Ah 7?
_UIDBO6
_BI0VQ@ ST 0p~CL\\[GP#8{6`)f@drC7
ACPI3	_SRS4`{5C pr `BE[9s&
PLIDs
_098
@Q֠a0
	/15?@SX"`MN1UjE 9 ^FC1F0ֱzkPk`ah`piaFa
 ?{qPzp
 a{`
^s }aޡap`k
  pa>p  {Q  EF@4 1P  ~ F1 m} bm

  `r o `2``qhp}
נyj0  p>a"1Ph)h`P	F1` ib pbasabcpcau`a $2>7F3! Pa a4J/
5iqF6 F7 8p9F9	}.  p
`

 P  r
` aPA B9eǠe[0wre
 
CqC51EpFAILp`\pMF6SECUpuAAA7A6p^DbTFwrE}uFP200]r1-3ѦP
cp2=cp
 >`cB
#A3z QAF3t
-A		32041205S206D%7	B814Buu%a%SIMWa6209&OB Tb;2JT7 A101 ``#DPASSA'Q34$a'OA0`p1@`41ap	a a!40> E2S?;О2CC+aabb aǃB Ob ub TuXskΐr20As `_WDG?
<4_c,E=DAAyB{M4C~ !f )ABmWMAA~ fF5ij=10	tAE"k]pW3AVTI4{h
`7{eo38
$ג`9f03Bc47`8
_,*i03u>D	
 
cE   , :[
j#,
(
''<&o95 <) %1+.*a7nK
8
2Bo!h6B^REh	p_WEDs$#zWQABNFOM   1:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa t0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7G!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB @G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	b`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP_}E=<vAk@M,=9WqÐ
LްWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jL2
jԘt<
@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[ЋC J06[Cl[#\_GL_yh03Fpipjµk 2043\C0F7hA3l['['ޡ`[D

[1D1E1F10 r 1q12PC10sph10eFF 20 p{zhP FP2h7	`E 21 1kD 051i	
	162	P[wEDĻ229v}w2A B CD΄ E0q2F C230 rC!31030
[ 2@(A`324 h
m34@ 35 }6  `UyA
	`_rh``vF [37a32Qcdp
aJac
`rd
  b}y   baya
a0/apacq  eraye
	 evepeBc ucdcM
8r7cpc  bpbgC	bdp apbe)ece ffg
fape`pfafgvdueA`bBG` gT`$b pg13agg7agPdM9,05,  p0`c+`bQC +D`Ay4 p21 3 "h Bh H
bhxc `r +3cada
g
e,2E-adft`f	ru'adSuc2ftd g@r:`d4bA 7+[A F2FF&-PF%839`P&2EaqD2Fa
_INIށ-AB0Apibhb0Bp0<3Brb
DC
j0CD"DD"bF5E w6
arC00Cabpb|.0+bab~`babuaaP `bua/_CRS8
`fv2-E`T`_STA t
`}``6OhD1

	4      y ? ?41\ 5DpC1op\/G651[Ay242K\43-
*G  }0     p p	Pp	r43[K\/244=R]19CN	
GG. . GN N   G   @ PPRRlloo}  @ A-\/B5n

G
 q^^.C176B\_S0_
 D!  3 !  4  5   M\_PTSpheb2AHh
 Oh
~	10C1+65]$f1E~ BA"?\_WAKX 35179A113  @	Pw CbB6@sTZx46~ TZ1_
 2 :A08
a:<3164bQe5O6acbccmc73PR9004BAC1DB
 `=DCR-E@,7@"! +q776
 ,-!+A=*G\!B7C	2@


06


b755?a̵
 0[i
K849sL9ApFPRB
QM SM4ZNFҚ5M0O519P2 32W 4Р >172
5 5
1({!h 9_ 958ik;`6
#`pB7id!C`57
hi54
pi`"i0
`O8p`phahqu53i 1r	Q!  09i ` aP6{VB1
H iPIR4p?KbPTxb;54Ѝ5
|EP46QrpR	
   
p
S_bp{tbK7;<A1

bt
axa

`bp 2

	A
!

0O#_3L*A	WF0O"d~d'p{f37p`{b
 t bbwb

araMpL3a[[1^_Ng4b`0w)a&G1h 1'2PB( !yw
h6I	{8ob  =p*hP abw`]%  vp@50<`S0A5&01AQCB`hfg3_
b 1A) M5B
~4+h `t`(`x`f{!4f
P,f[,f 1tq,cbyb,b&8!@:?2bFi p

ep
d
 J d&3d1A5eiw(y,9	B*Ya~rFa[BPYC "A
d9_ON_ /{S#AL_P_OFUFQ7PDDM
POYObfCH
AE
AO`Opm
2F
2OBfOsn3?C2602ۗVS 04C["P1MH AGȄȪE3F[H_A-L60 1 PAL2AL3C3_AC0%""1&B2Fb3f@PSV SLGP4ᇍmAG4FBi([F89pF4"4BpC$ZQQл!B_TSP
dp Cyq 2CRT`0TMP`5p, [G +&
a
,"3!AAY\_GPE_L04ܱuA00E06a8{&8[
pؠ%62p0 ` aaD
{{8A
`}`
ޯA@		7 ~63D`LfD.`
-
o	a	<`
`
p`1F2C20*BF2
0@9	
94``
 `!<B-QC__L10LAC@121CaEp31o80`_90a{@ {a
h}a
ap}a0["
dk-D`Fa4ooTomacoc b6oJ_E1{8 +8D
+`5@3 5
)r?6Pc6C10@//490
///G%/` ``Oa9aI_{` !BP!D "dp`p !P[1ssa 𡤧a̙BDG'bUc~594PAw`#6#! YSSDT  HP ~ HPQPpc   MSFT M5(_7@	1       #__T	_w 
_	O068wj ;rCe27a9jP]Al69ij A  oAhFc21dmd22 0A5_0A3pġ$0 GJu4Kyj
5o6cj9PB
0@P3Rbוb`h67a bub ?6C21CB4!x
2ph C4E25q20y`PCT,
 5 y _PK_PPC 9䰈14tw VK73ТR6bw`7a 1lq
ZpDaa9S20U6B
   
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     K     VIDEUx  AIBM 761295520C??  2005/03/22 15:37Z T@  <
RS480M- HP TAOS 300/14 BR12225
 (C) 1988-3, ATI Technologies Inc. BK-VER008.028I.@ 0  yutaos.hp v611  M PCIE? UN  OEMt  W-  Q UY%xvp1t   C$TVSlS@    M}HDk(z  @	Rx  !MOBILITY RADEON Xpress G Ser -{2 O Q  #  !
l 0   4 Q#A9$Xa#A 1%GQ	  `  sCDAP`X 2"0A  p M[W  ` a,T D ݀+Z @
.,.dM/|UB/"l` @]D  `2 MPLL  LL0 8;M<@& 0g 
v
5? 28-o9
~* $ l   L  `  @
H < B U_@Q : BBqmA 5 8 bO p@ a<P' t	a*u  t N u $ 9
3p $  D-E} FoCF #@g1aCdP'!'zh H f`.>, u..,..	 u  .0.9P u.0Ȳ.,fa.m4.>q u.
m.&m.mмo.mf`7 S3R[)$
PtS$RR+$X-i2I n+ .fa"4t.104 臍 P # mPVn^\i<XP=Zt|.ߋ QȤ Vn^Xu蓩4 
 ,	oJ $A PBX B@Q ?u^r-atta0t{u bÍhhB!AO89 PW uW첺2 1
tG^f@ ff+f| +/ffs @ f.Wȣ,>VB <v  !  32Ĉ&! .@2ɨd^Ð	U   NhVS*814DLd
FTL>0p  `h@S@PN8t ^Xd01F9>6 F
u'_>`t1r"tr2_2>SN)N=s`2`S<ti ^q tW@Mtuu	 t; t6f;Q? Ys	-F;$u<t<t<t
<t
데뉰F f;_ [# ~ tF: ǻF.?F6r@F2Ac wtÈn<uj`tf ct  ^"N @w3X8u P P
X"8tN ;N"rҋNN"ar /s2~tRSf_Nf L  ffff&f݋	q  
sBQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F( D( tR.&0U,Z.1@%[PR.Wt2L ZX` @ Fqxq@vp=@	;5vv `tU;5tEt:]r9Urmt5f3!qAf3ۋ^$f3fa  }C s
Pe"8sn~=}:n=a	Ð Ⱐ 1'(+ S?BDbncOQ]SDwp  sgOV uhOQNgORE0c	R 
l	jcgvWX !ce
pVPa	߁cj| Ris B^ cf	
U'  g|}% Lܢa	d`2 8ן`	w6!W  ן/  =|ҟ)xfҟ 81a	*0*!
ǟ;
	
0li	}`ӟ,b	
0
H䱟 /A13аU}4oY]M`62a-b6ip #B8q?J +%":, `6jU
u%2S-.<t
 C[3Ы3Àu#ڋGWQ    u 2~ U qFF
@ F v ]jUbGS	C	8t	C$[. PRhG\ouP tY@ @L,^P@  XjU   @@xSQRVW	<QD. ..Tt
& _^ZY[XP2&G@ku
b $@
@@XfPSG<uTG<uFGt,Pt G2| uA߬G%K3u/#BJ  A+@	\G`
[f@S ?X˴.6϶
By ʢtPހ u< D2@ vp.6BHeW%  }i
iQـ.afY	 
 pfFiiF`  .$FDVpQۑnpJOi@舡f`KpNi߈F>DFNF vpFaq&W߹  _$<8UOSQfY_RSWDUP u   ~ X_[(UX T[_tF$F&p
u/C
 U⻊T:T[P ݓB Cf3a  v vK컉^h N  ؀t Oo}c `M z ZZ?a SXC3D@C4} C_<qD?C0e CBS$  	{0S<o
2aud
IS"tQSD`Mt@uN,߃u'"?@3`VF  X  ߀t@0/S0/BU[KC
t$BIC$BDQ&D+Q?D  ! s*t~l^R 0Q t
 t?R@A%?%P%@
Ā?
E 
Bt1߀t
B$AB$AqB$@ABAW( 	 c-'(+ y q	 TvpP p}c_O/PU
(P	@ s ? 0	_@ T(   ! 	M](
c    
   pbc O
 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0б0 	  
   U    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc $ 0,!$
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XA8@	d@Ap@ @ AO..r#suP =Ou W&P=: sX.XBTazV*FJBC$' .?}@4eI3: +t&P$vJ<~.;u*6I8Dt	\S
OX=PI
PX1체0&G	tԱ  G	P?
u&.+X&c '/VX00PWl.E#ᗋp_ZwYhu<tDu
~2\tX&IDUD 30]U 
F CE]Y[	
FXPv(XA 6S跊[x( vv !
u D]3PYW: XJ  Q S[WS݋ P	026'C[2S  &'B[ ĸ Ë#utt&FS޹ 2&C@nrut	 F[!	7	 2
n ȧ3ÐA.T[t v @%7t ̓rPEXuSصMP[	$
tWÊg% oŀt4$
@   `Ê!4
}P X3<J1u P<~$<t <t<t@؁ð@  EuP@ÿ!!"3  @
@@ b !"# 3@tb
% `ĺSIz"e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uupuK>L tDI @.>W@3u&"0W<~W&g7t#0u3 3ݎ2PQ3f3f@  fYX2PR@4$w@ZӷR+Q  R< 4{Z 8 b3"P m303s AQR趱$WBrڹTA fRȊoZPRP艰 X@ZX8t
tPZYXnuT  w 2u  ].3
t	u0 0t Pb1[X \0u$0<0u  &o#6<uA	ut	
t0
߈ )<u+V봀1u0*u!*Qq3u< "	,܀4u< um 
f铐6u& <t	 00=@SB"
e ml`>%ȋ쿉^N"	:  *Tpe.P <Ȁ>cu>&@ 3ۊÜ$.B.Eq J@^X]i+Ht8 CH <8t<?t4 .B   K%/+Q` D Ei Y@ 3Y |RQ
 Yf.&  b&7 *# ?#  F 

 G@s 	 GޝÐ~~|ֺ| |8 8| 8  l  o<~<W7 ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x~P 0pp0a$fwf$8||s|
v<<a lllll  l ~| 0` 8l8vvP P``0y @ 0`   aas88 || x" f<| <l |ƀD |  ~ C aP
a0QP 
  ~
 ff|ff f< ll  b`|``5 
r 0< p  `b% ?Ɓ|ְi|~Zl) l88#<  P
g| %| 1| -׾0ÿx|~ `   ` 60[00q(v |8 x`flxl@ lpP-| p%| '| 06p'( *2
v 0d 61 \ 8 vܤplp;5 -|ƅ88
l8|P'!f|ƃP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`fl fEK>c8c>  >a<4   ,+> >`gc=  G0`2#`?#: 0|6> l<~61F  6ll6` l  "m# U# w# ##d  6 0P P 5 `ROqPJU1UQ2d770??%0aa66 R9a	
( R>     f 9x_eb]qPf```p_d~̀Mi|u?܀g8 Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S28tflD8p&mp0t| o@1pqAQف၁P>Q#tlEcvFlpxpq5 aq3Ԇ}~҇ 1>6>`vfqB~~`>~~>ՂR2$ P {p4`|| s4S
@pC 5t%9_2`!@@AHi P!3pxF)bfwP0v~mi "{16879
 G-3 a5әAaPp |@ѓ`;@Ҝ2#a=Ғ~ BC ҥ R*Ҥљ tPa7
`p0iQ.f`d|d`` 
`ζL ӥ񦴝Rp bq
 xp S	 	
qQF#a`( L%4bLZ ~E1࠵ 4-"0a6P6rCl   a  	P$j Ƿb[6 qb 
P$=b X
CO5.  'Ma0
A "оc A Ut"{ ځY
0x"p	#@	$@%#Qb  
#p
 
%	" Ђ#DaĲ6f0Pr 
$ 	%  		C	JC dw@`1|cc0c4t	?! 	8 ld>BPP<@ WWd! 3`p3 B7< ;8>dp` ~0]Zwl^l Q6=>6n6@s&t%D+ f 5ڿZ  Ed

 Z Ӥcg Ecb
 d
d5e %5ek 
c
eq eeu%
 

9 Ը=3;1N Q1|b0i 2S$|ҏ05Yaxp``<f	P`q|  0^0v  3 јn/AX `ix^ x8#?~  +/t?W2@ _&&MSWI &FG_&E"&E#WIm_&]%&}&I2.c2
t@' dڠ)p = ~=^~=~=~ &U*&$
$

S0B$
	-	1S2;t4&wt  pu`2RԊ%@+F^t=@ eR Iݸ  t` t:t ?FP݋ !?uq&>ek ڊJiR 2  &GF %G @GÜQW+&R&D&TAα w!	ʑ  p&RW_$&TAP
 XF2 CD#Za
CD#`	 
a@[@_Z_Y`GQWP$0-󿤾p   r ts | :&?Q<#a " G 	ĸ  2
WRU` RFJyCZt 2f 	2PYs	QP&G<Y^+P 74 7@Y쨿 t' EPJJ  B2BBXJ6wOA!U{,?VBBq#5)^!]P5  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   

m
   r 
*   S**Q p   ?  ??Q r  ~ g~   $$$(((---222888? ?? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 h1 P,h   1   h
1 
h
1 
hP$
ĲXðN WN^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a a;jb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L} \!ߕ|<An2N ^!~>Am@M ]}!}߶=A`P@ P!p0A aP߃A Q!q}1AbPB R!r!/Acj)dC S!s"?AdU/D T!t#4Af?F} V!v$6A@h@AH BX!CxD8ArgJsG tW}!uwv7AeVESA   0  IbK  @  ATI Technologies Inc. MS48 01.00  @ @   P   sVBE/FP e:.6p <r2.VWVSQR  f&=2u " WA_WȎ؋ʾKp" uz &u&E_UWPPPUwU Ubp M_ǃ"``݋ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6L2^_@

.WEE
tE M]2B].l.DEEӀ~ZӰEE!@ #  
E" $ ~7pq~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P-E*؋EME,].

-+/E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
xŀuZdĠT2ʋD<u<t<u<uAA2PQ/3 X23` .ƻ
>	$XP{C@oDI0o[D0o2 2pDo+/tu[.' ͮ2O[]YZ)ø VP$6Iش~!t8\t,	2^ƀ t %Ӓ @^wO-  	9s3"0WV>ȯF^&Vf=>^_ÊFG< uûS.W._0W , 
._@StwCCPS($]b W[XSL+[ utzt
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.W,ap!`O24̋AaP$Xq(
u uW3&+_uADOD< uLA*؋6IS [';vȁ~PMAJS,f[Dt@S[%@عSQ蔿*2f<ff3f` Y[f;Ës @]xryf@Ч
2uGf`P詑RPfZf
ff30fX<uVS$f[fa==f "$b[f%fPO@)
XZRJZfX"[
uQR~ZY!]"uRY)Zot^3"t	$B wl wf= ]QRW&9f&f?$4 Mfgq_	uS$& n  T8<\ VRf 3tZ^fOf33sfffPfVX V cPQRfRfQY $  OZYX!
9]PfBffvWfP4<0B?&q?fIu" B&$@[A\`tW1_f.  ;t} u2X#%5$$ ,3>QSu:3ɆtA
	 [YQ
$YqD?SQVWP# 4L &_Is  =R^Y[l7QRVW蚿{	_^ZY^ڋ_  >$[ SiRa3MR+ Zt $$}!
  $t߀7SR #uZDQSСǾP&= PH`UsL>MNOQPQ`RR+SSW% FUU -PÐPMIDy"W _  kأ,>WXR ZR
 q  ZÜW2 _Ü"oQ K.,3d f.;u	W 
	rbr_2[fX3& $4
 	]ffQQ2
QQQR>WPH۲ HfXR2ZXff_fXZ* %RVp[fqf_
V
4
mX

jV
틩Rp}=fZf`f_ZsfPRl g +KK;rZ S 
S  S@ [hSSSR	QpQ  BpQYÜ2C @@'@h #    ` #  _   ߀Of֠ .D=p_=0"f`a.T._
DDA#S_}a Z0R#r1y? "U",7`(3`v	.DfXu Z
bD	Q3Ɋ5U *.d"Y1+&v
4075Q A8tPn  3	
		#  ee
fa		hPXP   SQ h~t)bK`.IC=;k
KuY@ Sn?78t
INb 0	PKXBLQ('ޠ 0{ \pjr
a RP
XQP$<63-X7rX>hs RPXQ QPXrrXsYY2YSQW _YQWPr
&0G	Ku_P !Ys"'Yr?PP?fa t2+QYI?t蹐 %QU2F F IF E:s T`~  tf~  u
 p t {]puÀ 2S 4pXY[[ױ' PQW&EN_Y&?=XuAS䰞u"W&
_
t ߀u Àu 9u?Z u	@	3u%ZEðp?PXq@_ @ <Zr,ZP1
o [Se6_;w2XX@f` cut3P%2XtqNx Wt P DwDX f )P%t:*uVP X  F X 9
u9P)P2 fl SP nX[ N rfaPt t
 	s<s4qtuR;RjS/M
u$PLu
	Qސ pq|rs0u0tSNQ{Q*R路t|ttR{ab!(b.? t.;u.;Wt3Q@^-'(+ ]c@7h?^_OPU g7 oo XGW 6O  	@sTv2ed. 
90p@]+ p3
2SQP=09q53~At'		t߀t!t	 רuC e@/SAI  A[p0B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀n	pg	
4Ȏr y1ԟ/
$@
JP@=^v	@=v$?
ÿZ[}S?'1v̬IJV +Q$$fP, T  ] JfXfXA @=S#1;s.:Gu@3u.pR&}$`SU7 Esf>. t7茶uJoPQr X KD(d
$P?][3۩ 0   PN = NXuZ2@t $C^ !B    ǀ Hp ŰW@ĚƢ $ ra쨟ua`w)$<t2
*#`r
p
w $0茠 
Y#"|z$ qo_$d ú$B
 <%1$f n[
($YS6 |R"$6R,tè@S%"'@#"2[!f$%@YV P/HY rb0P"XrjkuNlmp~H!KKLF,F"F:R`	4!lImwsjull'kuam
KmLbKB 1	17 8;ұ (<&" !RbuQ*?0SV "
0`B2 1/]Ă  0 r`HĂ ]`R
P]$2+'$!,R <0_#$R"$R? @N* >$ AO>*3MQW2@12^ 6Ct
{ot/
0{ ge@P.tP qtt{XRc J_JIQbki hTkjj		zD($l"9RPĀa
_G'v6uj!h>i(il.E# kj"u0- ELHIJ !]$abRW(I<#t=<2t9<3t5	 2f	PQ &SI[N
_hfPfX2$<A<t<t<@ < 7F* `&E3uu
u	fF4@  8 _._f.EfPF .GF4XwHe uSF6XH{guHfa
f%  fF8fXf;Gf	F8:mf2Q..>ыFF(PPJרX
tHSoG[p Qu	 Q
PtR3Z{Y.HFGFF
uGP0FG$`@F	FPG
G.M	

`3T
ňFF	
G	F	 
F0GF	@GF@G
F3F'F2F@FB <0!mQRF;
!t7<t3`l/@"@"
<t<tn2NAVBFF                                   S0(4 f
   KfX[Q.轡a.YuB u*@pf EGtff.#Gf.Gfo뺊ub uSH[`.O.t	q tIt䰔БٻPIt$<Ȳ2PfSfQfR\9HK<~fXf+@߹@ + ò<PfSGS1rfDGN1 f.aBðXd.|p ܰ㻬 GfZfYf;@ K Pp Z d r     	 p   RR  ߀ p 	{   P  p 0  P  ߀p { P ^p ^ ^P^'p  xP "p  P	 @KZPb   fPWQ2ɋYSQ2Y[VS@ %pX QSfX PQ3@G YX P f%f[ˋQf[ m  fà!
^_fX2QV2oq.^= v8ǰB^ YRp'
fX`(ߜ@CJQo2P$?X%"0/@.q0P%P$~% p%XB;3QfwЁY`<fpufPV.^2=fX-~|r
01u0$Paf0RYfPWVRQ+Ë&G
36 2P $@afX&2&{YZ QR
FFrPv3f1pPSq퀿ʢuȎ؎6>&D&E[Xp	2R.
n1 IS ntQ  tt"POP`tRp  Q-Yհ|.Q
Yf.9VZY[!TR`\f}0O;Tvq vpp  f@ wjvef+RvMWv? v2 v%v u	r,w{'ZY0WAE._t 
UNfwV'^jfpf.fff;rf@frx0f Np^f;?rLf@.Ff;wff+f'7sv
A
X.L
	؋N]t= r = r;.+P. VÃ"%я[pl!0q!À Nt˻$@`L߲V$T$a 8Z3ZШS$p|߲P%&O@t@ wp&W7u t@ @wn@HZX^	ZX RWI߿8x`ăt N`ǯ_ @`0Sf4[ø \Dw3H1l g +KK;r  `k 
S  S@ [hSSSR	QpQ YQ2 QFYÜ2C @p  				    y  
p2x26޲[Y."D
$.
xtcys/] IC`  D2B/dS 
 ]ݲ[&Eq _P00aOX0舰&DVB 
 &ѧ^Ͱ0ZV($^PY 7Ftf
^~f0Nn;w`0 Vި[Xu;}@fܸP@%  FF Ƞ 	rp=F L
Tv&wiFzFqM@	FȊă41n %
8
F%QbQ0PFf=$116, )@f
 
ZË~u Ur
tQ~8ؑF
RGS؁Cý[͸ Z@= !8t ,贕 : QRc3ҹd 0YSR.|Z[  RPڲUX P $  (d
$1ϼtp  $$@!
u{&4u5 * 
 u.0tӲ.,63 W߃ [ WQRVSڲ+$Kې 2 Wћٲ|[P30@Ϩ t	@ |Xھ  w?waX]rIw= 
@7_[^ZY_B?t>1lpWwA2 ③
0
#


  _ &

ۘa  ul  Vf^fPB ӻٟ@0ّ`a2f;ufY?$_P0pr3>ËË>srƀѷCBr  `rVvؾ| au| ZX^.tW z׿
ID_ByDxVS@+;uw[^~׿|\1A	n׾ } ^( 
@7 3K!fBCC胤У   QpwoPƲRXp(ֲ1רu[ Xh l   Bp   & @*@LN  QRS.ְQP ?d_-C - V>NP(ֻP Q ֻT ;P$ֻd
* 	| bBsֻߌx | @CO֊Ȑ1pqXcXX	XIXֽXP- $2_t[p[Qbut@ sMPRp_s  .˂KkPɅ//R//BF No(Op.΋FlT2WKM//@ N0l`^ Ѐ
u3ɻpՊu<i*Բ.s
tS0)XZőXZpGu4հ 2陀$
j}0	OȀ$߻ 
謟u9Nt  @V*rN8#Nt
P$

	h(t	
tݐwאܐl@ZXt3>F  鴐;4<	52QMtS: 
7͈uP  	t&$
 !N
D2L  .Q
Q`w0PXY&^8&TϏ$%T1$pȰU%$ t0pu闏T %齂u   Ukpi`Y^LW;-f3.O>f.O% uѲ$f3
tff-f!a	f
`2._O>uu@r
͎04
ݺ 	< Q< a ߋР&yA&EJ'J
W@2J.$FGG<v_HHز8] C P:\
>в8&E 1&% W	 &OO_2$0mp$@X馍u_CP t fXf P 0  f+ffI!^uޒϲF u}V$"A)P<[1۴ ! [fpfWDƀ t
a{@ѿ	*QЫ0EЃ21	}B3ۻ   0f+p&@)p=zϋ&if?PD۴AϡEQ X࿊f% P`Y|ρ
u9|t* TβP07$
rѽd~ҋƿuzgW6ϐFPTѰ0{α &MO&Ee%GuoRQS؀	襋[@@t Y;vȋZ;А PfQXDQ	-ӯ aˀ u$0@4۶@4ްu? 2ۨ} `Rwv S[] [RY^P	u* G'诘u@w
GE賆2/@

	f̰$		$eT=]L!t0}݉މPQR $ظ;MZYXً$< t W & GBQ Yu
N_ u	 ps=lQ
PZauA= Nu~>K 
<QY@rNu{
v`i\Ȅ\aH݈P`.C<t8tX'Xǈ |֌CT쌔1ʰat@r0s%06 I !
Csr>$@pw^ʁS!I艠ؐ
3uRrt({^R8M"c2'܇ jt}7u1
b{Uq2
؀
#/l@ܪQZX
Ò=̇g=P=8&MU>&U
>+'Ю333 3Cu@s@*DPS( eλɻD d$[X R#! 8tf;uaS	
 u[S
t`@ ߆!sQ 
!@ [߀
q߆ÀK3De%  p $BȸU~2( .%ߵ
fQ
fYfPfQ
 Qvspp
  ̀Q&  
f%g*!
=%YfXfSf lf[
zް
Qø u  - om ~Ȱø jѪ_bԡZ }R⸔@yJ!B⸈:1f nqǸM@0 20 A q$Pḕ}  \ rỐ3
f
  cQ pwptpY@  l@ dB {3ItRZ8uR*
Z 4RP  XZ 4$` ![{ అȃR23Ұ
)u 
Z`..W un> tgp b2P>bP22AQJ2=QRP@ 32ZYYy2ߢ XaZYYR*8}2.WZà؋m 2Ku2W S
u Bj[+с2Ê2+C**&R  ZHu_ ۰$JB J.Wr c» Q1s{ Y   PQC3BBaaPQ 6YXaYQԨuXN
+.J
uߊ8~` W$0<0tW:Jt. ` S +*21+uX  up*tX⑰ ,. P"Q0׊4"
Ê$"ð(Pр  !$%D
m݁  +

,QVW++  o  e_^"YԊǊU_ S8v2QY2P >It(P
ïRS"82 PL[[ZRРJ2ZË.ſ ŕ 03<?& t
uV E,ņ!&Jd aZ6	-[a2RqZazL0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6wЅ% B B2+Q++w+0Z0"Ȱ+Ջ+Nu`$` t  o}"t|ڑPa8~
td\8tX|0I~D*@
8t8`t2ſ
8~
~}ݿRt*Ŵ
RQVW3ۋsЈ P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 PO譊ी  ffPߑf u/0baS[F_@fWfVfRfPbpfV +Ɗ2BAXZf^f_SRP1f3ҋ`Vfޠ Z2f04[u.N i wy拄 rXf&Iw`$=7|t;@) _v[`ovI
R:ZK`RhσɃ@A3wh鱃y
twFs
鐃PdP+>PEbFߋ+Zh[
tQ3R
#
+ )rnAU~6|m  &`F +Xu &F E&   P ߀Qa+>2u	&}uƀtGVW_^t!#ut
>|  21
Ta|0\F݂tPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4߹ 22FfKu[3,~!#|Ayom[pBu5G.P>F eXЅ$6| 62 'tm߰U؊Pu)#ëp &N>Xz 鶀}!1{   PO 鋀Àt!&0Y@ b?`$ `&PO A8r2Êв⿋2,/Ћ!=1HJN@PRXWQP͵suXY_b{Q(IY+qGtrGn _vqGov
  _u　PUoP[,@.X`)Vي4|4F umXPRJWQQW@3_G?8v
 VQGY_Pİ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_oҰie0XRWQRQWP8tXoP5$FX_YF!Z Y_Z 						d		U		ɲ		>ctqP}}}>
u&fP 3 f \f$߀p  
@<}6}SP
3 \t&ۈ   &]X@9	U0P qG@Ā`ey
L'|CkP|طAW+A%  %%&j|&Ē*(DrX&7|t
Un	-
?|̢-2"ٰ[}~g{yr{>b2PI<
vLw5`GrǪA8sZkat u2<
u:6u Ɖ:{<u0{<u
t22+at++&eP>Ҫ?pezpбkz~z.ۉu~&2p
O3Ɋ7ʰ'ﲿuF dzZzcR`R8buaDz~1T`NV(zb$
Ip(!Q̊.t.;t$.
DY^Dy#+3*2d!d"<PR3=ZXt
A>t
y~>u<s .I0" *.t #\ b@Х(tÆ =@&8y|+>&}s! 32乿 =밀w0$&e te ò 3NsQ2ĜB0:JG_ `;/^ yxQ&5&m&M CY\x
u	$aP0胢cu4dx0P !v &w5&MwN  w}4 { P^a ,AWT wtMX9 @Y.ڰP;PY0 d߀2|XR~ ZSںY~Bxs [Z SBB  s `PSfQf  Jt^$t"$2t t=fIuvt%vutfY[X$ .[c|~<t
4jvaa_v<wPSPRRR߀@n@߰	e@P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[u _t@ > B Fu.| ~ uȎ2.b.yu 
*9 Խ'Ƚ+/0:
u00w5߀wpP&p u͎..,?.רQFF u+/'+/+  Sp$[x&G&g3t!<}虽
<}0
 <t
<̀
&Gpu2@| ֋P$`"3ҹ <uȰ P' Xẁ_
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tG8Pmu&2. aѬtW$
J	 ȋ@/utѿHa& L2ܾ+/t
 t<tc F0UJ>=&]&M&U&E
Pp>X}21PSQR.Wt	00ZH<|rSH!`5[VQS&F E<
"@<
t2_Bdpp\p' t&^ E	Sqras -Pһ -q	t2但SU@,][ X[YZ u߉:ХuZq`Ip~Am^F.q<u	Cnq.:r2.׋] Ià$0<0tu` tq
2.;tq `i8~û 3no tPmU#_)ߺVqwpt# g P 2       ?     _@  R*$Z.	$SQSQuhY[f.
uY0t㸨Xu	f.> Ef0(`f.ߋŀt
uPa*R bj
PRtZpr 1.@i(-2.OA.WB-tW+A_t;rÀtW-bp 
uB.&
ċȸ 3  u,A	t0t𼀭 ]T
ݸPG]tu?M2@
uJ J Ѐ@1

@ EPw@[ZPQVWS.>Nu$.T Tǧ vdR	[?N1@U[_^YA´` 
XÜf`CPSZYst|tuS0f`'l[!fsqm	21ݧ[M	4o
f @޲"st fa'fP2ɻ.P$胧| " wT 葨fP艁 pEOPĀ
h%<P 莧"fPf"Vf3f  蟧߻BAff	P谨߭誨(fx藨b獵2ɰ $
PfXR J" .XX
 0(!
XPX裦fX!5S.= t.;u.;]t33WRuR fW.׊eD <t<<t8<t4<t0<t< u0PQR=@uuX5
X
<=u
_8@E=@ Xx ^}     Ѐ  @jPmm @{wj X--  Px<˲t<t<ղtP<uJu@դ.MtP触%.M߸菀@A
5P
X   q
&hJ@&$ AK0U|$JPb2$6s&r$Ƥ& ?o$u p 跤0*8$;=p6_R!"WJW PrW .? t.9u.9Wu.G2tp[32Z_Sh.Ί
܀qopp[QRS$<uPN2[ZYÿ
w.;Q+Wtb3PR%$ZpR% ffR' t3t+t#@t.tpt>tѽ%ff ӹ%fpf$<t$f- < tfߺ+ `fߺ
 f2) ffffZ?fYf[V0E2ȴ2E.Df3ɋ% fwfp.	 L  
P!ffpf  !Xff;t9`fX!" 裰" 
ʣ#ؼ@p Ƽm轼
贼.^'衼C蠼`脁)ytopjqDiEdF_GZ.F+.~0 h߷ tttt	tr
~ $0C9 ߰bֻ ͻofX^ ! ݵP a&   D CRZlu`u	 .F3H!  H ! P@fXf	0^ .~1 ˃

p1 P	 ntfP袟0}4q0   8a fPRQQku@PX3>3@rHpXP ~ C z	$ ,?Lΐ{F T   Xz
\ `#fjuߟ X@ntqot= t   u pA
uu
rrXT!stY]IϐUBbtE0MA<~	<%  Yt  l柲 YZ RoSfPW$~m.E_fX[Zʝ4F
 <F;  `!(`;; >  xGN `#  )$88 A	I? CJf`TQ ' %<t;ùk Z
 $Uڜ赞!E H  !,WN
Xf
   9F.f蔜P[oa0p ~D f.02tNt!3p?d4`0Tf% f
@ JStf%ЅLtM1    [9ٝ|_ZY _^RVWbV ؜3ҿe.;s&0h? >.\c?Q O^ L.L.2
0G_^BSDLߜ[û`a pPƛ1cP&CFS!D蚛 7 ś@蝜1t0uūX 4TzPS20O
RP>2JXGc bfWP+&Go ffaztf.#fAP3۹#fCRϚf 	WfVw{pf￬.
f_6ًd蠚Xif^"[H  $,48<DLPTX\`dhlptx|  ;<Q  _г  ? c$
k*6
mc8*1 dBB
  
 ! !g- @^%
I"  `< @ G  
 @ . 0e6?:!"Cc1B; H `0Cq	 
a7  &  d 61h	29 >	@ a
bav۶, -? - =	a$ "0@ %{%_/$:_?Y"_ 7^p{$! 8 Рkے	/	, 0k6	;`P^U7 	 +91s0~ [Yg qV+q) /3+#k?O,  [. z }Jk	s#		
 	1|= (Fw 1@#h  '/# J`=_7 Z S^(, h27 . %PU# PV P@-'(+.P]hq;0p.p2`
5-_OPU/ m +\Oa	U &^0T1_]02hqEвp	1qTWEPpq20  TX |1
w*
OT"|T1CTT !@" "0"-UT$TrRKw W4N H
AYTT$TN3V ?:T98Tc6? H7
 T
>T7?;TUTsX	h>uTN A[T0B[ww^  '18 4 dTTor^a5aHp^T$N_/#T$A_?6T7#H?TT#	/)NR_?TTTlqYW~XAþ  O!{A[TXtYG[  F%Q~ 7QT_k+wk&w^00	{ w! T	4Tpa Q~oNPp^P\ h^		m		2XX~Xo2KhX	  ? ) 	T+TРOTT T S @RTWTW^TTWAT aT.T2ÀwpLNT[q.Bp!c02:`pLUjN{coy6HTbpRV1WirSoTd10T?
uƩ).ϩϩϩǩ^S%]A
 Tw4?:ĩ=Ecq2Ʃ5 s{UX_Aȩ'  5z1B{TKx 1v95 `ĩĩ yϩǩƩ$! !%
 ၶT_/$©7_?©0~ĩGϩ2ĩD ＂; T ?:TOrƺ*8P0P0b-_hg[@©// 5 ^mN؏		#!  	.н    ϩTϩϩϩɩTϩϩũ+'. Nǩ@Kʩl`cũU ©Va	ɩlqCWĩ,
g^]0	ĩ6ϩ©rTaé$TVN g 2! $t. 
t*P.>tI  gW
uV3.øN 	= Nt Ȏػr2? u2ֈ2 .lˎ 7ltl l.& t._&@.?tǐ?.Et ECCRPVWfSd'P%.]1.M0LXf[_^XZÐf`9$
0
̻^$
貈.E6讈fp$
B$;$.e9
興Wǐ=
	_^.]9t"=f(	 1=%f	}&fU1	蒈HfPfQf3.MIff  f% f[fYfXP
$t
8Շ nćS$輇0=%
=2.Q.с! !uf3fÑM>f_%F%u

茇q%%!2`( 
舆)$
 Ä*2u,j,{U, ' / .  Tt PS
w1gن#pA!J蠲 I[XÐ
s%b
  #|ph$`< R赅ZP
'↨SP߆$ *X[`Rz#Z m$\% RN$ZW@6.E#_ @_VQ#SWAte a$fذ%;E.uDff% @~a1.:E0u12 d 1u"ڟf;ût
 Gŀ~ _f[fXΊY^P	E= t= t _Xsfr:f=1_f] RPSQW1jW
 L _Y2q3$ }@r	.TPC_觰 Zcd
E$谒tC<u;葄.G`R.DoZ"QRR$ $4
1=$
KZG߄u 5xqIǄ`)A; a4h4F	 ZcQRWLt.m M$om@0vM,t]_4F]	賃a߄$`&oȑJ@$Br&}4 t?E`g~0^pVG PɄ)t1I$8m_D1΃`I$7V ZIq:f!Nu-	茐J .eY (F"fF P7 1F-c+T!F&2$P6[$
 F1e/@U݂X;uB;uF) !g$
F)NT "P@u^fF4蠂~A^F8薂D9p]pF7t5 F; oqX3FB#@0UpzF'AF(C 2fc3 $^0)2Y[<uݡ袏t<uR3ۃu ۼ@$J f fb  J$
ffe``
f׊f
_f		
f	f% 
f̀ff荎CR@3EQWUD 2F E]ou蔎u褎u?	fF4Q }8R_._JPF .GF4XyЌF6XHfPuH@'@T@zfF8fXf;tPf	  ;2Q..>ыFF_Y3vQ4   @ D
ɺ""
ĺW w.Et.;
u
.;Uu3}8QRi8PwOZYo  Kt~cS2R6ې
tuAP^_R9.%F p
 F"F 2N(̀ N(PFpGF'G'N'+$fF  f`fP1N)F 
F$Е`2.O$_F&FqnHF+F%
ff~ppF-Fa
.oN3Pb$ 
Xnt
Fѩf	f	\cb2c`nx+(/F
$F1fF N& n1f1R2.F,Pf..g` `F  '@^FG	  $ 
F0u` Fb% $
! Bu0xfu	Lf ۀ G02ndq"0
/

sn/
 2f/f{	 
 n !`N2AVB02Q F  tZFtUDF:rC6DR_aBcAfgq 0D2WPdE	F2_T0K@pK6tK2R_2hE7dEaEai a2 8 < C F H K L U Z d x   ?  ( Q@AzSt$^ ٔ Ft -
F u	F=!(^~.Fgf.@hri0ރz`z^|AzQ Nn.5 f0
̢ }v#|vF	@|v|{Df^
PF5$q Գfp}ͦAf}BF6 2f!V{5~98~57~z1Sq
Xf^ˊ߃fٸ44e^~/ ޲8	6
^^@zPFy=$a, `@p)t
 ۂ󀘹x"	ZYȎؿ`D	DfDь EeЊ]}cTILDu'u蟉D*++І؊}Ё@@%??`ODd CEeCÉ_DE	*DEe}HDL0+S2]Ë؃S[ |$0fĈD\\[ȉLE
 eMBacDC3D@< _vlTB<@P$PX;}?@w`;DX+D! #1ËߋȉD)Fz:A'Ej2 D(D*V u @ǉD+|-D D0oD.E :4\1\/^ ЉT2?03 ]'Ht@P D;XD57 ƀÐ~!2@^@S @X ?^P P @ XP Q  ` Q  x@߰    Samsung LTN150P1-L02    
 Aa  H }  !   pU Vf3 ҋ|^
uyЎ؎f( udf| uZftr# =	wIu 3Bt_ q  2QĀ ]`UG1	GA1	 2&=0*۰pLE#J6I*)Pe@E;$up E;X e9= uPWA_= vU9жN3Ƀ= t$9w 9EwAǿE b ׋A@} uQ70UEDEDSQWV^_Y[| u ? =@.|& t.|&[  DYDNDMmpxMm 2]a$@VWVS 2r؋7[ltFmA&G^
p p±  .# u ;= uDu

p$ %ڹ  _^VQfSr^
 ff;u.Q_ mY^P33 tt$@ЊÀ$ʊ$ ǐ$$2ȋ'00mD	&D&ED&EI D DPDfD{fDD0D
"fD$
` 0pXü4 Q *@c@d @A &02  L 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
4_t*q$ppq%qQ3 b0YYtbOpIq$3S 0,r0!r3
qLq
!Aq
[}pE3_w4_ :SPȻh{pbpEXp;nBb<ap#/fPVWSu0<$0.*'U,P@D0A.D1ؕ
.}4u'+` @격
 2 T._A16  s b}&3t>E.eP@3@Ӊ[_^zS ` [Àt
t	p p  MS48AnOEM? INFOl     ?u=u
 B2u`1u6uh   %d!`\?X֠w򂽇0*0*h\'`H )]0*I89 ' -m]^ QUFUI),)}ҿ's 	AK ЍD)PIzs1uW
9w0*!U 1 7gWWw $	I?|liͱnc ? E ٰOs O U{] P"R@)%<2Y-}o Y _:Ъ<l?j-O??Is{cq5i$	ih'a9 i of'a'\`q#jD0*Q=   o q#p#8@63<@A/_"0*"AA  o__7 *
a'*
P+w &1E   3k
PD{  A/ǚI1K?  &k2ATI  lQ   1CODPS+ 
u$[S 
i1i$,i
j
gi%ai0 i$nhS$j1INI??SQP2.N= NXu2˃	w,[.'
t #֠g 0.u.&ΐv щ               !u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
Qh)c Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &4&E  ظ@ P(^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PA覺.TAA_fXOAu.UA.TA茺_f.PApqKKKJ	JCKy2 Lk@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH Bh]uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jrr TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  hos* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x  h  ݗ  d D` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7hc t-u$ظPo hߒh Lr 	uI[XˠC'P{e
.> t
P ZXPw Xr$$
0
w5 r?x   hst u	ruX0rPhfP fȿ"wC 
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3?ù  s _˜0   U# q	t a*u'_ 4,4 u.>. u.8 t.9  g JPqG } yrsn}g#c\XQMF3B};	70,%C
!}S
 f`B* >(6.>0A6f.R6D.VffX QZ f / 
uf.R>r>^)1  p oZ P3r# v  z Ѐ~!f%#6 .,.>>66
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP
.QX`0fYZt
0T <f%'f
  TPV!	.Q~

.ͱ
.ߊ.GPWS ^ 0 MSZ.&ZQ<tQ .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr73$tA^`.u	DVQ
6ˇd dTt	6݇U  } 4
tY).V|0#g&;B*oR'Z=u EVW>ˆb&w _^FVW +䡍>Pdr6>_^HPxů pfLfVfWw>64 /t 3ҋ f|1@
G` 
t O
?twQ	= ?  68) <R se>uf_f RfYp/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|ݟuYXP E󂾀 轤  F>׎@
>  uz
lr3- w|HruoQO
8rK<?rDuqr)W.9Pu$e r$q:lVWwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVߋր? t  %u
3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
<fw<ar,Wÿ<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G22-YE.p"uPG>qBHہr
tx6ta >|.s<u=0> <u  <u0Pvr).a>PNÀss߂DQ_ w?QB>@
 Q0s~?^P2>B7YѓJހJg&ISIM 9}9qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt ;amBA@i f.;iw- AZ rE%&Q0PPY tfGoɰ
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a ~`t
ܿ݌ffVp xv"  u $P.$qQnfU.E.9..F .[:0G;5A1>5ŋf  t265 uuuf0=/R@Gf]anQn90P:P;651.=Q[ wfDJR RQ T
T

 ȿZ Z\$
yfX Z"Sf3[ffÊ$P  fff?f%$pwߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
_$!$$0AD?O2撰撍6ŢҘҘӯPEv@> Q1Q ػof?tuPRP |ү ntJkfp˂a T WFOPtO@;X >;TY>YfPQUGPF >JMu~
,2 6  POX]0qU쁿f ]Qσ0@Gbff&f&  G>̀ fG`ƣGaQ6VfWf>҈!f!Q  ffD4$ߢfOЬV 6O҈fP ȡ  ஀hY$Ph5 X[õ ޥ3@$<sA\Vr.ˠUrO ` A (tD_7rq XP"Q!fXnѣ!EnS  gf /u
> up[PȰ&p^  cB`&Xq!g7= Bxxw@w ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+ s q6ppt+Ȓp+p
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;0t
|u. >
эf3EG..fEfGЈE
G
.f$ r-/t   @ -@.Ѐ tZP=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCsq?s6 &- + aGp Ѓ}p	, 5' s#  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6Ї
 `F
Æ  fPf$FfX    Eg	@ k fQffD$ ?us+ؠ% si}
uFoD4/ E_}t#uS uN~-fD'  620( uiQu{ K
߀u#*
f	rg
1g
 /u,	 ߾1q/, fXfp5 Qߐs`psY+5 < 7 _bga5Orq_ie@ aȋa8s"s1fEp[!`wD1S
Æm	!f+B>sxQ@"*#%>dνD@@@_RS`rfe  #bV~+^	sF蓟N+R!%
~!pm	D
sMRu
HzaI I7<&!5 6^<us
`(N3AaNs@OA
Na Q5bQ5Q"3"+ɶ8Qs
1D1 F$)-R&d
*fs.:a	qmncVt@f%$ ,r
O.`.qFbb$)7-+P1wPH_+KgD5?VF`^q65PKAj5FF<^P9d)w76P9N; ސnV@Ai8sR176sAN1*B<p fgF^Ë ttt%EEw)|CP{u
s
>1`uF@F2	E TEDDd%=upb5AIaR-df$0?	К(=(t@q	
v+Ұ=uruQ2$nGrStY0<t 	("rUY!
R"pY+C J g'S ÈZ"b#SN1Ns`,_|0^ eVfedwOcDA+dS 
Fpedeb415>"
S~0 :G `ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPB6X
TA tͫA  r@tAD   + *2+*4+*8+f5c|- sMɟȁy@u@føtsPørcp d
q t ?P~a slc#fE~st a1`6`%߰["	
۽Kѧ߰]&rbWpBb
Fb_x+si ` d` p p P" }߃߉ߏߘߛߞ_ uAcA s@E
WV6g4Fg^_rg tU 	p!	
  	M
fwo/rd db q tbyte %*/" Q ptr  WV.t"Ü6@:s6J,6K&ps#[!0RO_f^f˕ fXPBXP $0<9~F[ab !  s봰+   1$  se+s߰-!sf    ֐ `@  c ;   _  e .d  (    $  ' ]( , / 0 4 $7 ^$8 < 4? 		 @ 
 H  P0dX ` Wa  b  f@ c & h  i +}` l 0!m 5 n 9eo ?p Dwrq G wr Kes Nwt Ru Uuwv Y%w ]wx `y c5wz g{ jw| nE} qw~ u	 yS
8&&#8ǀ ` 6f  (0 8  |}UA     !  	    10'8v 0 % 2  , '  Q+ e #, ݪ  u ݴ)  ٵ9װ   Uڒ3w    4   u  ص e 
 n5 x\
?8 q/  fn  ( 8c  rð T s   8؃1ȿ /9 %˰ t #rFͲ b8{ '5 ,$W 1 ,
,
 
b


r
QL 7e? ;ε  ?s*F DD? K  Qe V  [Zw ^  (I#  b  )`$V B`  uf kw qu v%w z87r ~ 킶  f(+08s0ZU  ! ! e" # 0^D8 c b8(be0٣@9 s׶  (,?	 ;u tn ܱ,    e q/w ' 	 % `d$ T  e   E ڹj	 ݵ  e @w 2A 8 wB ?eC EwD LE RuwF Y%G `wH fI l5wJ sK ywL EM wN 	O T
8 ܁o8(ݶ 0f8Te e  E y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 u$1 %%2 %0 ̄&8 9  { e w 	  ew  w u $%w * /w 55 :w @ FC      rڲ ! $e  ȥ5 K9 O 8SuX%w ]0b5 gv mk&p u zv& (ɧg󽱻  f塶v&m빆6͖ҶFަ	V
fm
 fm&v.&5:?uۻGL mRfX^	eU
Gr|lBp udz y8 ~݅sf( 0f8nР `誴 7 50v 8(l8ۻ8u  ƶ (mf08t
ܶ ؅s8 $ $`$80 $ 0&  e$
 0{ 00{8 Ұ `8 ˶  5{!  MUadd push pop or adc sbb and daa sub s x cmp s inc dec}aa bouParpl imuP nsbQ  out a  jo j%n@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff Ksa lQ 0ss stos lKod cP
bbb b rol@ r rc~ cr shl@  a@et`ente"f`tA o iave`md xla@oop q c xzQ jlwockpnea _e hltPc t ne div iQ cltUc i
i d@d"xzx lUf0gpsPl@`hrd bsf@ r bt0 s\p  c i x!seP 0 P b zbb p"epprb `eQt gpr 	Ul	diQ l _msw l`sUssss	wverR w f fchs fabP t "fxfld1Q l2q e1piBg2n~r z f2xmyl2x fptkan` as rextrac.sB0
f`/ psqrs01%frndq f &+q|
ucompPendis0	c[lein+fQTf /esc
env
cst   fre0Q /r(AfbibC

; ?	A	 r=fi2a ( wbinv%wa ::ob @? 6 s zs 0@F: @s s AlBAD CgQIA 8@=puid rdm-rdp 4rdt`rsm ud2 wrxO .  f  y}z` w{|F}.sx33	}t.dG
U{.
EaF,}(-)*d.V)P}S [XF}e$U<vý$tU	&$!!wކ'E {t$$$I4{芥"$Qz(',fU$-
{
E%$0׋c}<5r1<" t3"$v7ޕ4&){6+t06-U0E#3$6wQ9uF;m>'A0Dt+=F&_<JF8L{?Nt!@PE,S<$VuBXU&[UD]` z20cf1i*l
nޕ+q{#*vu
UJxL%{E}G/'0w#dPPO߉OQIϐ$TۺT<(YUWeCC'IڇC<U&@'tN^86tH`&@  6 f3 t3Vv^
fPfQfR	f20fZfYfXS]&0[SQW.x
E  1 [Fn6Ff.	02>pQZHY.&f.>	R[  t8svpJ ${GXG _Y[PQ.> t78FYX78%F NSr [!Hz MYaEJ2E  MIQEKv$ <t<t<uAE* mw"uyE' ;\~  XSEP@f33
FfZSt[AmBC`DP րQPցRւSփAmBC DpgPOP R S c?[ QS0#WP.	.X. u<u	L <r<w,@.`<  .>
  <  <;u.
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&	R<[pOp?uu18x
f;tguG2p .0
_Ȏ؎
ЍЋoh3 0    R  O  O           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu  	6r]dt 	#
C	EG	RXYjcA 5QPP(Yk	 ;ù G V  .:u.߷n^$"@
fQұ;!Y!fQRfCPt
' "c v
"2ɵ  W t"
oTPc@؊2fl  2÷QW!#w	t]
2< _YA3f@@ S' [P   X.
tذÀuÿ@u[f
4p#w"gf8 3&Rfߺf@'%fذ  +^;w"Z" 2$Ue <u
203<   $^4|<0%= 0q<%Q f<	&ka[<
@'P<'E<(q:k<
P)!/1f= uffX<+&<+V 0(]fW9 f2` & uf_QRfVfWSft,f_ff`,r!f A;tftfNᴃ}wn [fٿf_f^ZYWс; BIAf 蔂E_;uQ
P"0 P	]  sE:R,(SfRPFO1fXfZ['_P* 4v6Wl_ހO%Q_`	Q;Kf	:@TUf s#(  sf t s	  t
 @\QVWf&?p f&p@Q).fSP&Gf&_fXf[k^<pP`ǐL _^YSQR"fPw&f+d2b@RbPbf;t
fXRa09WKAF
ffff_f#f ff#t9 c  f_$0F iPSdMw bQVfuG PÒWf  "8s2ہz`ZaDSfWoE`-y qt#uP{!r )X߀tġɐ/[USf<t;D3` t
߀}-fu
utǳPQ[`qY3NaPf X1P{$PIR   ? rCch   }3  (` e  0  	 g
 0 
=`^8@8Wf f2B$
BϊfNff
fр aVWhc)S'%pW0APz;_t[C&0&F[_^Q1WRn8Bf0(QB簁tf ?tfA0MAXfߊ$
!#ff  S22!%Kr'Buf \ vuf K8s֊sʰXQ 7RP
t0*"Y#Se0S  uf a/u OfvUPfPfXZ+ ]f@$ff]rffymp`3zn  u= sf rAsQ_ f^ w Ѝt;kP *fDcsv >pB)au_.aȢ#f;1#Nf f @ng!Xd*6VS^6 .RfJqPZRUQf fuffVfKOpr=XfuNVFY!Uu FߊFMuY ^Ys]Pg>fmRg'QSVfNVFfL~u^[YrfXftA3PXQM諼`x N Ow蓂PQMAz X{PcWU |Z1̡ A\` Am]R`XÀ- ߋ_^ZW  f}ꑬ m _                                                                                 < ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.Zr# MVu 6arkpt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`	 ӥ/2	r@e	~	p脀'^F&?s  {s  &G&w&GP&OD
 &	G!PR.Mf.u E	f0GEEUabgVfQSjf[GfY^f& u#GWfk  .2W`XP'F#~r .>t7  /{r?`. t8  t t  2SrV ʀs`,	p ~t$` t u/~ǉ~ %"NVg 1	s^Í6-.|uLu..`>a .:UtaaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? tl>ـ?0	 r.u|
Պ Ѐ ʋ.E;v j'fVf{vdD @؊fA
@NP.eXf0` ȋ¾P	rs$
2

ў	fX!9
dD0{fЩv]f^PRWB@    RPXuUW:>_]s*r  P$<r!P~@Xup>q @<@гP  osXXty>c * BQ	F?~Q	 QV  PRσ@W> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm3
u
rPbl
u2 VWrd [_^ q QP&:Ev&;M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2&fPS `006vaPSpsqD
>X`?D<O4a`tߐ a1t!$!"q1&0&PQȎؠRJr# SMwO "t }
`P2:Tt
Q YXÀuOu5Q,9a"   <s& ? t`P93p >-}uǀ   t| VW_<uW<
uuF΁ ><@g2<t.$S[M[|uw|
pf|`it\_^FS`}
u}	 !.b܀}@a`p;uD}a #%D0QV 3۬+^YD$f郃f}ff?ffJf\c
bPZ#f F PXMfP~Đ=r0&pw)pEwf u fu }Cu~s3SV|t` t t
^[PfQ
 0 < @f	t
` v:a f`ff fذ%$P~f  pqHff#f+ִ f;wfg 3g&Sg&c
uff+f߃X撝faf6SR=>$pfPxqffX0ORBZru>AZr
gQ2ǜpXZ[ð4J3 J Ѡ    SQuP G$@@Xu-@A7JXe$D-Hp]`kdsI4
<RVWf1.1Vtf~]|cSЃQ<VV<W0U   QdT``葯afP > f 6rs >upf2>f@Jϳf B&dϸOf .> uϴ &R"qu`a`%؀ ߾a@ u
ɮ_+^Z  3Y[QWVV_j ^_Y@d>ƴ Sr@"W uq,d!-m!3r%[UfQfR  r.M!PY]T#T#a /  T#ڃUT#sT#9!J@B  zh_ܝku`&ݣH {݅ݢaiAi+$Y$dAT#D	T#2k6@JTT#^@ T#fW 3sA< uf,u#
p f3Eff=SCAF2@f_U< u
 	<! F ]SQW  貼<w&'V3ɊȈCF`뜼 ^a	  _P"SQRVV<v^.
t@" ~ ذL\Bl^Z`&Ur t P#]U#P X%$s.V OuЃ*]A `   VZ緅 g ~ee}"w b {  㽍 ,f*!R9#ĸI&O"'% Qu; %$.:<t.|$2ɵ"ǹYQ"  h .6g$3WVo.GF< u^_QR׺sqrD.\ eǊAMˊ_` Ȋ̱6˱QRR źZR  Zoj|R8ASu
wRRp	|GP PXE%
 cE%	 $=ZT
 !
P#@`5Wt_wZwU
uQ6rEt> r2`6C rͲ  r  P 
]!    057A_p^A#2
4[rVei1sCr"trS ';Wr6"Qr
Er ҝȢ)we  
 `   }  WtK\	\*P')0\;#$ ?rIW(? kV_!zP(B O55B 2P3Rr4;3r!- ,-BF3ɰD	@D`ʠDG]EAX= EBQ Cj D P@SI Q S CS= D@ E S I1xception 4 - Over_flow!5Bounds Check6@Invalid O_pcode7 Device Not AvailablJ8Aou~` Fault9tel Reserved	1]0TSS1SegmentkPr n12Atack V
3General otecErrorq  1 =  System Ha!P2
 t
-XÜPRu2|Z fVfR6T)Fupl)诇/vz)pcP)Yύ6){)tfÍ6")j 6')`fX/,)T ſ61)J`66)A0Ǎ6;)7XY_WQP6P)$Q@)QD)pH)
6L)6*F
0)诳t)]&*贯x *naD*WJ`d*_o@b	[Q G%; I1`(0X[S	 m6* p C8BBaaa$aH@0I߀FfFɷ͋N
~fE F Nu3 }'ȷn ]
 cRQP~
XÊܹ/FFYNZ1A`QY`Њ  aً ."ԃ (. & G;.g.&-'@'d鰒 qZ c Z@ 
G XYZ
p
7 [ r  `؋    9 [  ͑!
 	`V肀a@  `
UЋ؎ ]_aA@]ߋ3
ߐAF `P C0[q$9ao` $<u 3 0   fan3S } a 
 VQ=3AY^` 
aËf3RQ3ɋff tf
   f3fRAf;v+R'TYX0P@YP\UfWf&`1fW]ўf_ff_]p_ (88xxxxp@@`P3Xú_$  S WR e qP0$TA D   $f ZR
xy`
ZX`$<t.<t<t6p@0f?4 0Swھ0 _! [ 0~ W  @CfpfRWU΋.t<;u+lf%A fq  5ǿD  ;fuff#]_f fb u0QRfPRf f= t5fxޛ LZfX u H%uA|Ł 0]@4W?
p?
?
?
8
_

$

p
G|{
_QW   P%D%00#mf <u ~<  u<  l<c<@%Z<	~;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2 ru_f(VWfSt$ Hѻ"r   f;ѠtN f[_^fZfYff r } Lu
N`oտu  ϱ s r 2fSP-fXZf[1^}_^ff\="F׋5	f s"s t sP  QVW&=p &p s fPf&EffX[p V% _^A*Pw [`;t
X2 *W 
_ ϰ#t$X sNp s@k@у`H fPfлw0fm P8s2fYZf`ffWgf  #Eg  z݀ܺA@vT2 gf{gƃ0 g u	f@w1  f@f@f_gf1 gffgf0	Z`fQ@;gg&fGfXf7z;wf+f@{+f7g}ggfb	f ~#fgf?&fa
Wt@@P	3
y
ff0
gf3  P
@Cr@
A
@  gf3fSۓ̓ wff#b ffyZ?'wf3f30n,o;w+#4ܼbf[gfo p2
f'fP	c	
퉄
fAAXiP
 #W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffTp[@u@EuPPu!uZ:PPE EPP runtime BIOS - Version 1.1  
 :;;:;;;;!<F<p<<<<<<<<<0=wU .:]:.C\!.A\ 迚!r !R.A\
ZpQRa!Pt<rt2[5$ !Ȁ
  -" {`5	$ i op[	}/	uR xuR
] SUUU .VUf	`&n ^C=  CUWpV	al\Z u
 J U PSR<r
 j ?G? Аr
t ).>/= ../= 
   PQR3uA ԡ 3ZYXHP  SIMPLOiMO?TOROLAaVPyVS~ЎHyɇo Ws˻ʆ  >ɷH>ɷ? ɷ6 ﷒-ɷ$@ɷSR &03-&Z[>ɷ>ɷ~ɷ@01
@ t0+Òcɷ`ɷɷ~ɷɷ萠?ɷ&3P M<S:Mto6= 6 
6^Vx?Oʤ *~>U  UҰ@ʰ~^>ʰkʰ
ʰ% 
0ZʰY@	kʰP	ʰG`
ʰ>
ʰ5%ʰ,~%ʿ%ʂ+ 
r)>&~X^ɐ("
`V(QSQpaۊ`ƞ!`*uWt _u
f(e(f(e(20u p((~a VR*txSR ڊZ[  Z[K  u?Ƞt%PF@a@0
ud'APjZ^`
*u=u8qB@e
ً@躝p 2 裝۶UR)u<豮u7Gt )`Yпtڱ
lZ]PGb 
 s ]`K:.KxSQ3ɰYpްM M>rQ4Ys.\@P( 3Z[x0"&`"P3
H G?G ?S zQL "QK S
{@pN  qM 	&c'
(<PdCD^DDDDEtEP@ &` XW<r؋ .C_Swt 
' t r
2[e 蚬u0^r!<	rr&  Qs" r2.C2& ?r $[!
s  r 9q	8 r 	&& rr	ô Ss+&' @>' ~osa$sQ
u>[ W r%p$S r rq	A9 f" O$ pQ@	Pm kmX1#t sA@t腴adt`bpt t
@uQYÜP`
`mXr`QPPPt0XdYQP0 tg	` QXd$!<!t_  q&@tPGpB`+ (`<u
 @&   >!@tA AuqP"@u  , & ]XV߁  0`OͿ  r
 P<Fu uOs	 	uA
 fu	 X RtGTtu`6FtEuU LrPRtKxGr t& 0R] Z"&Duh8_ h  
Xuh9rX&  U au@ Ϫt@Q!	 MrsKr
DNrNr詘 ߭d蚐 dx $& 8t   0zQX uSQ^ `b+ϱH 7`*C: EN801 P @@X@3@*{C*Ywlrabms\j&D
V &Dt [l 
B lr!0rlsulF. uk lI$krOlsJtKZ Sk	lrlr
4lr膞akyoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)tɋ r4F$
Ft+ F P   !VPXV@"1WPWR u	ZX_PRkARZ LLLK  A " * Gxx  x y 1 " *
ܮx"x 0   s @w_X _y\[8y y `b -T ËEtذE
U  fr0 t
SrÀxf`qi2tW &  d_&E3ґB&U
&]@ &EP t û[L	u &׉E@ !<f0 $PnP!  M 'M M   e fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdf_f^fZfYfXf[f]ge333jrVd4Ad^;sgu` 
3 s M tAt<V rdDg}
^` VW^gEdTg}
}gE `tr	 	t}ߊd8p W<ytu@Doo
`PfUf]3
t縅 p$u Ó' .;Gt  ._
u fg6$+' +okP! A  B C COOP2P9P'O5Og]蛀M tM3M ]Q
N uNRMY D   SQ>Mu5(ô% r!<蒠3ɸ  3 3Y[%SRV&
MXeW`t蕯t#菓 肯>; 
M<t<tiƝ< t3^Z )X_V  '0ruۇ P	ir
- )ZQ=Q =c
uMMM2Àw*VRރ| 拴  t.PZ^PPQPQQP .߄Q`kBBX$JJ2JBPܰKutJ mXu` ۊ SQ V tA&q JZ  C@ĺA du*uP= ]Xruŀ̀2	
 逧(8SQ2<

2ۆQ.
$2lrqd$<w0
u@߀ð  ` 0 w  Pk  G#HdƾIPIfdfBJ?dJKP{SJdMd5H" J V1dP <d;]ttd|d]^  R 3
' ' FǠ  F/R3 .;v+GuBG
`F/ {@Pp?% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFS ۻ{S׆[U uPxXdk]<t@e r
ted8D^uaPSQRWus T^u_ZY[X`|`h&
yt,ـt&M1&G&a){+{`{LAAA {a+Íu 2pft
 ۊQ ܈$FKuðpQf
u	ۍY;Y uS߀uru)g4  mAZ  Y3|ߊ$f
sf`< [RWS22f0pr u 8s܊[_ZXfQWRfP
t)P0nr ff  u 8ufXZ_fYP f r@3߃r: t+aߓ߿4 v 
t8t	
uY0	g&;t4g&Ct,g&Cf4!<vf0 f٠}
g&:#C1	ВW޴r7fg&	f`r!f`Gag&O@` Nb O q,_f[ûb2p n l C  Ơ #  Ȱ2 ð
%0,pzslpW$zV?
 H/а(	!2s s	2  |0 	  {2w2 	À tN :4
$ 
$^0 B|$2
VVVWDWwWWW.t'} J<u 2Rh :_ hz fO1q#qs+w9sttAs
2 u"  |  i .D0.Dm~ `` X&&D aø0  ` j &߉&E  荆3Լ{1{ͧQPTP !1XY`.\.T	ώǍ>L.L` `"va.D` vaQPƌМ XXɎ6aÆTT߾TT @P G" AU-a RG      *[%	 ` Gd d@"z, Ga aOo 
p 7Gr rrs sq]
zs"  
P/ 6r&	 
 RIR    OrC@ { w  X(@@X  0  	 
 0 
`e. W ЊB$
_ϊ`
p aVW[S߀;[t[ 
[_^P3۹  2B QYPQ`ctAPXV.[ 6Z.[^႐` u ߴ# $t$?aQh@ & `r 3ur.A\r3' $< u@LI<u	.A\ u< ׃ pP^$\   tupu	V $
s4 ᒐS0ۿ@ u7|`O<u@ ذUNNNO Oط0$#!c#j^6^D^-^  M [6A@  " *;0 *
rB~68y Ay bnc é u`U ]EU  ʋU  ذ")r t
rPef`tJRQW %  d_̺01&UY U &E! t &]@ Z`%fa_  u(<sW13.^_.}22>P'Xs_Q9p`ru..&+.	p"p0@ t^P.&u @ u42..
t _wPUU*`*&u XY=3P A3.{GP
XPo *.torWȎ[oUo_B?{````````aa
aaaa aVS3.:5`u`6`JK`"@[^* UFPy`2SF۹ S.>`F[CpN[QFN?tJ`sF2~ t_Y@p7 `  _ ø8 QdQ`dPAQ`0Q~ 3`$ $bbb%b4bGb^bzb`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233Рlaf>"  t" P a2ۊ( Ҋp ) ǊȊ&)  * 븊[* >+#1 d>,;0.- &) r.oPR u4t;6X6 6 n43
t,=
 
"=
 
0I5w<t<u FÀ ts< p s
Ê& 
<uaw\wWQvu& |` uf`!AX &
Ø=Y6 FF;t2[ddddS3a\"c`  \0ba3ac]aR]D]E m]`[\!`\\M\\+t\ I|\ZP\ Z{Z g}
3gE
 t "6D_  [gu@sU I2
$t0d&E
3`    F˽	ң>]>
 SQf  VF! =s^(2۹  F  +^D!8u _#Nf^[WVQCuKEP! P!0w $I^:u:\!u 
=rw]= @Y[_S  [0f.`hЍ45@0u[̺й  Gsa . .BwN NĒ 2y1Aւ   @   1PPRRooւpӀ |  fV jYބupt u3N@fHVsu^aIunuB@N\p EShgtE u
gut!Qv
Lp`N  
]]f^QSWfP/ r)v0p!ufPs fXtā_[YfSf<t;f3f  t	f g̓u
ut߳fyff[`
 3<oafP fXu hVpۃx  tc_Pt>KXSx$PaXr$vQ_u!P$
BB AJJq4HX^ZY[eAMDK7PNOW!% WfQfRfVI	f^fZfYQ tY.>@i `@ip$ q
 z` 3`./@32ƀnuo n0Xp'"| `PÏuﴀô  S3ێۻr߁?4 Ӱ0t Wd jfZ1d_QuXû~uTf` D fft;  Qf3Yk,65 !ʿ fa_SYSID_  Qk "_UU  eQaQ	Q" `y fl f@f=  u05p fl P3Ҏ¿x ȫXR<Zd@/AI>BFBjjkk
$PMM0Vq bm	                                                                                                                                                                                                                                                                                                                                  
    S   _ -%  ;n$$`fwyhӁAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6a  @ t	3!
tr ^	
F (|r
 	u^'Ât %1+W	d1*515rz0/5Mrr[o[
u< r<0s<"N@`  \o

u' 
$nvf<0r
sus>.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r?20ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 o؀	.EF2	
r]wsms1}I9  <$u2 *<#"<w u<@v<%p!2 ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]<rQ[P@ [fZsSQtP^Ë^6wKArf;	DE"d~(LuTMs fPf}3fXr1>-E.  .GTώǿL K./pPK3V#:Ttt<~'t9r0JQEE&Dq<DD@ % 5vJ~$~6- ۤ6u0fPfS&Mf.@f&]f&} 
[!
_0'Qf  蘒r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^@tffm_ruLr Yr)8r$crr"Va	)rj!PT/PQX rpw
u `fSfRWBt:ـ?f.Efff߶fAUffsP-EMF F
tSuNff3fifV-f.WP*f8f'w*f'F'*2t*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@  ZXQRюً go^ZYpBw`SQRX0% [F m `7h. ĹQ(&Q Z^N=rot
r`a r[v"> fKfa`, 3S5<s--O8L9
t" >G<P#;<Q$@ dZY[PQX_ hv   t`rzru3rij`wNurWwu
p`d 
 Lr.t%ttt t	tCHa% su~藎r	 2P{RZF sH<t<)t<(u;ь>A u/WU>)~`]_34r0ߓCyq`_^a靠'c`&PSR 2Z[)ÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8FfCF VvuKQfXr+tðP@P3 Gp1 tff   Rf+IYÀL@Weu$`k2Dt
.4芆^G fF! PXG t<"u<"tlV3޾x 4|Q&?s0  s& p  &ǯG` ` G`t&O &O`uRp`f&G`Pa  AWQb b  WUsa,ZyX7RQVW:W qtNᒀu~u .!w6a u/A ?L	
 t,6pNoAOGA&&d&D&t&ƟD3p;_^YXVQy
} w" uRPD
  ^Uqt' r.] uя r.f%_ ff UCESqsffqr ੇX  ņ1f!u%f#f   t	 ôLr`t s`à `a0ff#ffߴ f~rpzfafVQ<t2f3Cr6
+f 0u g> ttr/( 3ǷP߃@ kuY^j@+6:`@44t?t
  r ʲ 8-t(@&r!f1ut (d
Jj?t:R!4g&Ӏ?A0f:ca`fR8t , tu
@u$߀2(H@:)@t'@u'-*tp(Wt
 /!- o t> 7fAu2Bdda33q 
t@  t}Qv?Xri/p/B/RZ/rGU/Z3t@$
Ê װ,$t PޝװZnfVQ! 0fF3YfcS0׷  ^m$t2?NעUd׷@ / 

6E	  {  SfP4fXpG	  [USQWfV~W  ߰ _ W <5t^uf3 pf^_Y[rq Q0Qfûf FKt
` J~8u һQfVW_f 5 uwZׁ>oЎD@tpb_fb$W㔹 _T*u	 E 
yjt)Ӏut&  5& A)߀u&uu#
u!+ p8W@W AU RtY pvMuG	0bu< u3uOQtru1 t_0> S:u@pM8*6R:EFu $E0P} QtTt̀t߀EtH7ݚ1 F )t%> t:& tSuEU[u ?T3  ܰO 脲E>I q u	PXuP3 t?LX랓tS%y(E u]tWt0#)	&2!q =ݱE3L*x3;r.Dv+W+Xu432#*u!.ð-s*1!	 2K<Gr<S 4,G.#]C%J {u$
<.r!}L 24$`.AK2wK#/PrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   !ݲܜط$0<:rd uꝾ݆P P wH   = @֕r q&@VV:СgfFf^0RyZÜSt	tv
 vt[`؎ ЍЋh33  A }/f`0:tEtu '$
`&aô#ĴĝfaRМQtĶ$tr$< ȋߺ ` u1pt)uF&<ĸ #,$Щ м  .>EGV貗i@ r dt4t p掊qV20 SRW*׿OзIr 2 |`p3w_ZRWQ,yԠv@sN Y r3Ov`Q3ɐ!RQWSP b	)< uX Q쨀t_Yl !`2sX Jt	u_RX( V_ m k7	XP)[_YZÃU2<UuX

DYJBBƃ   brT^
!  BP| ^352
X
u	 ت *ê@VWQP Dt!WQ0:t
Tu8v
Y_PY_XY_^ _SM_ P_DMI_   #9zs F +XPUv FF !Ff ]X"X
W8 @SR3i &g +pa 
u
fN@  ]ϰO2ðq t S\8&_&G pGGP    []  N!@  ]  P@@\&\p F0 ]
..c3 и( иA  P
C@@ XWP C<w3t*p O $` ! & 0._ϰ@`j {X2$31   ߞ R50K۳4!fr YfQ\fYgٝǝ[ø <a3]Ou r 2QfPS=Au@u;Áp u39 u+ҁ?wufP@u UXu
_?ff`< t``%V`{At{Nʹ|Sߠ{_ k@Q  ~{{ o{KǠ !qO C{P ؟"{^{UQ   AX#{op446RfW. umf3gf&
f=SCAFtV1G t"0fff Wuf(#3tfPfPfXf_P_3{2_p9  
zzzOȑzo($zz,az%´+ؼμb{{VWv{%ռt{* uzv|,諼w|Kf`{%{ 	{h w%b` +\r$R{ r<
%	*P' @TO xOy er$DIsL MT[p.øJzNfUfQ ufVK^NrMu gf@ N V Fu(gfFffffMufY2 Yf]Ë< 3R+fQSfVffLfT6DfLMf^[fYrXt	A3PXfMMøNp O蟥MfS0/UfWfPM,t3   fRfwZQ_f])^Yf[PfWMctQ!IUPސXY fqAlP0R YXt
 t$t t! v n7M1X(RfV\t  \(042V{f!nLw#to   r $r	 @|f^ðU; QWVwy^_YSQV3
Ê^Y` jVޑ e a  X FfV1fffa@>.6fff;w	rf;w %AZ.- An"  umf%>3YL/aBRĨ@u$ : :ذ1Po0= <rqph3f@ Pl
ffʝ  off   f-   laRW >%3&G;r_sZ  <%<t  O  S & t	tpQ  /fW  d@ E   $@`\fYX4Z4f4f @h0hg&>tq r 	r
  u f_sbi^f$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	fN o#F	oPfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g& 
T|} B~3Rf\&^q\QU3ɍ6.L@.:Ls&pU'.D '.L's?` 2`r2W 2߶P u K렠^t
pW3_t 3t
u! PH3ұPUu s t>-.| .D u} P J}uLu}~e3p߀uv`bW_tURQRUp@K2YZ6	u>^
 .D P@+ t#V%L%^ 
%.L% ޕ]Å Q!V | Ys.u@	 t	&Uu" ώǍ>L |  öi.f?.|fF  W%.|X%߿LW\89PQW 3ۍ#}_Hat~i
/g uRWf;rf`Ȁvs'P1 u : t-Aw(@tD<u u  TfaUQ	U F @ E][__
<t~`Y]}p4ã1PQRbfv2  ^~Rɓ	sr`	x tt -  P	~  i09`KSr=s  "#@'@b@n 
`Nf?f3u
P!  f3gfF!ds"yP@ffڀ^03&fPQXYqԑ)YaP'уЎ@ 98 #	f<t` ? u#f$!߯AP}p]faQR3Ɇ 
tw ZYJB"<t$
tAJBՄqpvBa{{ݯ *qݰ JHQIs@P0]FF
]X `j . j v
@)Mf.N. ptI4~r@5p3؊^)!a`uw t&Du .⭋^^;a.@t&ڃ`ԣ.^2uȎ0S6t6^2~Q.  @ PSFݻg`'.:ptX._`P
Xu!P<Xu @Pt	a`
  P/@/aP2Xr-s(@r3H r rR VvF\r:Gs5&DC Hrfy苡_FÉF(t S^$}:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠQ&DB êĪǪoЫAT0	VcH UrpUsʁ `-s8u fqtw
E$藀uEab&G)
V Nh8Kr>u rG Po3F) r\ {r=H r8{QWss#

Rr
3 s@M1 |#kп#'F("r#謲Qlr@rk20!0p o×!r"~!F( Q'&dK}0#V&Ơf)&t_ N.cD fX QE QRfl f@f=  uf3p fl >t@&? ϰ  Sd `4GdЈPQ3 t1G7u4rdr
` r`To 校F X @F$$<r$:u s
jîp_ _A$ 
   @`
  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&Ѐ E 6F (@$3'E&f$`
ĢF f%R$PG- ;B(FGq1ø fF" PXۋN8NwN 4o2NEEEi0(`00spE/ mPEސB
 r
fQ_mruE贀fY_/++U+sÑ &u{tbrq? V/QB  BY^	G $s
3
P&u3`~ dD@
r
%utàt <q66V&TЕup 
* &u^Ǵ  v  xQPXuN%&:Lr * r$ P @uP<utC.@   ; E qs2pcC$<@[t22P !$!$qXw= [[>ĺ"CP[BK<PY
`S[PS3[
u ~XaSQRsɄ3ɺr8rZY[PT83t  `88fPAMS3VW v   q u
Po
  	˻{P7rr@ɍvpF0 & O 
 30&OWˁFUWn薚_]v
 {` {_q[w 1uޟIp 7 MB RW02
% D -&= @
&FG酰u  ru#' Ǧ&P
`RJ4aZf3&
 tf&B&f 2ffP3_Z	GF  u2D$F lsN~ t
Sn@[=Nu#PӀP& (zu).t

q6pWVR-&`%P<u̃ .&P2^_tRVW33۹ e C r~eDfe׉T
@  eD   h~5c ̸ Ῐ..]u "e\ uХ ._^ZXW   hfِD ;t.Efր fP U
8_
 PB>I%   N8 % @ % A a  _ Ag   d z s  P "Bp  fQWh f RMzf8hP`PL`  f   Hn  $p`| f0
Vā rMf[5f 0ff% f/ff  ffX2ﴇ_jRfxffú Y5Z`PލXfZ0fS|d```_f0d@rH=
f<~f	QPRef%0

 aDpB_B3E<@19:<Y`f1ftm" QBY  +fhfaQfRWf ff fRf3ֿff"tf fZfOu_f:Wry^tUp^Ogpyc^1rQ[L G B = 8 3 . ) $    ۷ƷM c4QjpD@YÀ'B2ǹ!u"!}FChC _f6E_f.wQ1.Pp   跿vDt vf$ݸ #%@f ? fgf&fXq APffa !0ω	d bfPS ػ@1f.F?O#&:.Ff`uh_ h҈ uhaúB ! $%0Ü裿.F :!型(.G_q¯a==>W.}
u.:tL u% t>JrS-.[t D.[u t	t_M_1EfUv"v` t Ar`Mw@ .V PXF
Xf]h@ &A 2jG@!PpмurЪЈ\ôVĂ
	=V._6# .t.I.
Lj@ps& { |0u 
^SV#p.d.$ʋд^[	觞ã3j0rcOt` 	OtOtLtDt
tt

1u	:
.<<
.}h $ BÁUu	_UAq_SfQR#PGrp
fL?\P;Zf fP<r|wfD0u
 vuIp_SQVWUuP؎&Br& ȎXߋ,> ..>@u 
Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^ &?sa s@ \`b 
 f`NG`e fEA[ff@ 3SRWP7޲ XraȢEV(XLuRE<sfQ@M}3 Pr/>-E.  EGώǿL _
./17p;[M
_Z[Q.>u tG`Fr=
.EP .&D>a@A%50&Vg
َɎٍ6-ʀCqYSRt5ێËfQf{S.q&GФ@f&_f&_ - Y21[fUfBSsQSU*f]ÆT'  G y   y ?" ËP t
$袍rW`tW   d_ajǏ@ q @ F0 vP  _ +& Q@ w   @ Q Q c t @ 
 G @ 9 U    & 	=iHewlett-Packard 68DTT Ver. F.05 06/01/20  U ]  Z  l ~]@ uq oKBC
sion XX.XX  
 
  _ 	o~A`}#  } @P " ƐU10 AMD(R)      Internal L1 Cachea bi2e	
   6PC CARD-Slot 
 16	 www.hp.com  
 `   |ӡ 

~
  ! DIMM #1(28"tS
~6)"Rpbs "@],No bat@y'+"p
/_PSWQ  6kt7PwY_|PٞҞt"@t 
 ް  XP{JXXP@  t+. s#. sXP薞&  ~ &XX  =o spڋQfP SQ  2BjY[$
juFf 
۠[N8tSFt׻ 0 z Df t0  @ t"'  t `Q t	y fXSaRV s Z2
Z
H
ni@
$ow4 tNff`4eAPu4fafFoD f:2`tfFP`^D _ s fКWzf_f3y#"fF$wF(F,q0f3҃rBrf-5fv,v0hfN,- v(X(@$иPN$fFfV fNuf2N t
ffFDlf3fpKN xfWր  ЃfYf#f#fܐ
0 fHfVPf#f@f+f;FLvLfFPf)FL%	GtPf@bv駎AfI!)m fBwf*@+f
`fK
X7f%	G -sfA d!`
;Vt
fAP
Q
y6"8  f%"   @"	 "خf'F 00\2FR) !.P fR@? ff  ffZ PQRW_ZY`ĊӶQt"tf
of[CPͳ  SWf 2`c iFY~f fa ?0 _[1	?4B3/@ h }09u
 @ @ÜP8 _ >PQɩI> "K0q2 B%a Wf`f߸ ;<uf10t f.@v fWf @f赲03002Efanӿ3x	 fa3lt ?   @"f2%<u 	= r= v A&f~`@cQ8 YQXYŀv"<v.kfGfRZCаf{@-8P_LnX
x]0]*U5P`S)\f.L @Z?/ZP(

fHu@:и\bx	  VX   PJ0  > q ?M0}C	@f350/  tf;/f%ދE&̰ C9 􀀄A p0U( π`'d^ F˂R1ʀgfZ
ע5R 7
QdB^!fXt f !4SfRfu`D[[f40T!T,1	 `;s% Df{Au.T  SfWp3P* @X Zf<᫔CSϠ$!A  FfobTϣ51XݠˇfϋpS# 
ĊËooag (,_gמ(&  .(gURfQvV֠uLfQ2=fA<t1 `eQ !ϱ n 0Rr.V sfYZ]ÀT߆f;0Nf;fZzÐOWf!rfr?f+Zar
!.r#|s
;ua

<Q\GM	wrrڑBPmXPr Pp$Ss[OBMI>E{/JOAZH?[f!ufXߴE)t ft/+f"#fSQ< tfnA۴D2"DǥUYt?$7 
3#tcˤab0
-@TUľ^WV@ fSP~WB Q Y_W
t^plfst6]V! <5u G	F^B^= tys.
<5 = 
u>
r Xf[2PXo^2YcvWfVf` t
P E}r&< u P MȐB S f^b$Yô PG HXs0#Ĳ##a$Q$!$P)
u $ސ ð)  hU
  $
Ǌ߻ O $= v$~rs 3+p\t	~`
S)YðoQ3r+3ð&{QtFQ!tt	*tEP䌰Q݌S&"
ǆǌ[Ռ <t<!t
<P	<*}`R4

	`ZQRgsw`-Po ZYpt 
 ) 7VPލvS<û	 [rapX2F^a蚯 ð!B< )VfW< u؃ tFr
D1. 0nPK`_.Y3|
u|	 t0  $<<q;<
1{^ÀX" Ud ؊% %"؋ !4*ZPu z`AbXð"MQVWP 
 5X_^YaQܐP2b4} "QB2ʁCm ^
P'R4#f1ëW52	RW5 +S,WðT,ՠ Y9@Zr:.O/s&U;Ü= s rsD
nF`PS ){ _ ^ ZY[XSQwt貉.踉 _! !$1XY[ u APdQ\;ˁPQN 3۸ E `SQW uf<o0 _`` PUa(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Pu v5u t
&  `
x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾr9_2.S ukq G$!u@t0<zw,  
t
;
	t
w
 b2]kSJ, E ?G@2q)Pı
 t"< tr0r	
2vPQ0s	} J	eE=C HP   PRjNuaa@uXXZXp! '/ ^LPXŻ eM  M M N O S  SQ  @TU	 Y
 S_ S@1APSC  
R <RQ SR  `RS ST  dRU hRV lRWXYAZ[\1]^_  d` da db Aec ded!eqf mZZZYYZ8ZYrkJc\fP@ ظ䠄t"
桰   u$! !tp &k X(  (  Z 0ߠ`
p	!B  0lFpoypOIEMAG  IZ P?      	
  |`# HDA-L*;DBs A-E r Cu 0USB-FLr CD Hs LS Intnl .CI-%q ` 0&% eO   H	P 	/` <M ۛ` c!F	  ?CD001EL TORITO SPECIFICATION Qf`g t/Ku (v$
vô$v`svvfaVМvt
v$tº^Ѓqf` u'qK~^v $Xqnv$Nvfas$q  tTTTT%  A    G  0G  "{ y" P3@qb ;iQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkXPu3;uCf N  }~U fJMON# f `df>  uf @  > t&r_VuѳPp  ff+fQf׸@YrfǳQ	ZfXq>uIf s@
f6ǁ0 {urr>@SWfS"f[\r 4}Er]  h6                                                                  S fA  h  O IYOO UvPtF X .	˸ f&q && f"  иf3 ffi._f.]p >` 6a Ͷ !ŀ.P f."""""J ! a
#
 
 f3ۻgf+_С PfPS^ۋ^&t` $ueG&uFtt[fX]I( M?ЪT`x uuO~ǿ<2f]
 N]ϜfUfPP XZ+ f]ffŝf]rPm>`n跐  PR@ZX<0  !$    pTPQ^RPX0 <u
p s귄3ɺ*RP.
`.afV`fa
u 	r r" s    	0A۱af^`.`@*߃2$ԉNT@׎Ǎ~WF$
&FG &U_%
	!_a PV1ؾ<^XR Zo؀ˀ$0Z6SQW pCPd _Y[fPf=<0tfX  W~   wfPQRVWȎ3fPRf  fp== t5fx$ L$ $<u	 68.<~ >!<
D<tNTG  r%"   u_ rN r@@9 v?_^ZY3ɃdtA~aZ01tjguSVP3ۃt~C轝 Ί96XP-*# aa
rd
xrh
crQX[ø 02%4r$< ',ff{<R, + -ff31 0<GGzEH ߊ\ ;SRRhtF2S^t"fV$

t1AtT,trTt'tû  @ tn@ȺR`Qt PBP $?@SHA)
 ]X 
/Zf`c`<`WfV fg&?tgwGtfPfg=QL	g&Gj iu#_f+cf<0tfD0
$g&0?foh x f  UP	3 v$r `a&cX
P  
LP 
P L
W,	P Q   
@Q @

,P `
	 " 
@p 
kQ   P0 ی@ P"S ]Pj_f^pe@	fe00{	` d =ĜP    0 8  @g<glP !d 	a@	 {!  	h@ @P 5r* UӞ.:f tdu.V.f].@wu6  `3p$pUu0,&?t+aÍ>.}
tp 	
t>{apa.:UǀsV tMR_rZ|p  u$ft~} t	^^{ Q | Ys3С*Vh -| ^t
 ouUu
Ss)t!rRڻ۵u3ێێZ
t	 u
u
 75ǿuP@s+XP{t qڰ`m4zf
! YQ 8  ` ПS%o` +ð ;w[~~~~l|8 8| 8|8||  << p/  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z.>>`~~<pff f { >c8ll8Mx
~~p Q pp	}	 0``<@$ff$ѥ ;0xx ?0 lllll  l 0|x@0f 8l8vv ``? 0```0 @  O<<f0D 0D{ 0  || 0p0  x8`̃ <l 8w`p  Jx@ |	pH `a
 
|x  ff|fcf ll bhxhb `f3> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x0  Px ƌ2 xp``x  xa"1x -0Qwx|`` -p :8l`0
pn v!`lv-f0 x`b    !s vf' 0|004-!)*`2
6 	p&0d 00l1B  0 v
/ u5Af SvN .	X2[]`g i &  D
jd`̎@að
 r
R3ҿu 0eZa Th㍲AE eMA9Y.nSS`  wA|a( 3
`3ҴVĀu N <tDZQY
 Ir8r5r
2:6 v&Z amP f PCI01 ISAF#+T DT03COMPAQꊙ 06/01/05  >     F10_  m؎h Ћ`h+3f  o L!$F10fPfSfQfRfVfWUfUCES>c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfvf	 3ua 6e< tf3
@d>Se  d g>d;vf `voff3A3@!t
    2 1@b@Pa@f00tf pߨ tQEpYV ^ `]f_f^fZfYf[fXfVP3>
g t
	RC &
gfXf^PVW 3W __t
r
>d_^X \ɰޯ۾ݷاбκm,c-DD(|1 8     I50  ``6~ "!A8>8  B9 .@'Yar: 7 @;@?i<@_ &3?$	?o	I!!
0T!A>q

( )))**LLH#E$$E~B ~B
y$$$@ $
  >""sZFYdd  #<r 
sM` ?hx"'yPQ<R!2

	" g %8 0 p}V	

$o$D81 dZI 
!e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGłrݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉEċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t { S   0 ` R 	i D  =Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|{u m 0
Fq% pkt?   !  % )  f	! ( 02 S   `K00m) BFLXp0t  dEg!<"F 0lYpY.$`"08D(#ds$A|   UP W F  >"6>0-@  {?~!BC ""!B'  /!B#bo&2 //`    &2$-aLX'>9p1@@E@a!!: ' ( <'Bft,0<𰅇<` *0`  ?qt2pC ?Bxg ? @Ӂ00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l==   M@ π3` B?"#?!!  8@ `~: 	4H 8	  6 a@)1ppp" `$!3pHBQ0@S` P0ZT@L@\D2?"##(R,Y@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x dc $+Ph` @@` 0!cc1 $2&f# `\;0;@lxx0a1 
c
AZxp0!
g
  Up!rE  @>>@@`)X0$x|pTT T8 PcCQa- : D^b0 B`c$c  N $484(d(lD*&1< ?! ?&!<? !!# _f4c{ijv+ dDs?|e0v0 !"s 6`S!-cS,t. T8$9`0pGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@` F0Vupq@ 0u=a4`m|sGXm|%o38"5U QHU' &@'a! 3o?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!Ϧ## DEB`@].A^z! nxRK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!?}@ @Fq6 pբ66@ƀy9N@0ya؈  `0%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?bO < @$<}b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5' '-恴p7p^  ) 
8hRF pà2qq2DRD" T@""z" ""sbn0 `CF`  ||~ ނI+E`<aBzd, %}IH}T! 㔡aE@AjD0p 
 .:23V!&    B5I@v  `2"R`   @N!  0`'|Cd p>5D ( (H H  0
DP6NOeߘ  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c28`."b4`'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	?#`4 c$}R S SPpP O!
(#?@@DDD@"D?0!c 7E u0DL|(0<qt ` O='4КQ0i#!zM0 `  ?!#3"$$!?!#! ! ?~Rydwsλ7  H 4?b2C"c9yH@Qn4x<0	`Z ̀7( (`2)v&9^?0JbW8l>/&23
~b21G#n0  !$ #L`,!3p$?Aq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8`/A a ˀ4 usn# 8ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>Àǒ)jP|D52D"DvDTDD6 # 3a|bz,  1Gp#\  7ajė=  k4a8	  6 P>Tڅ  ptL D@~@Bf$,8?92k&arg@eP 1 WpxPX	G ^x! 3"&,0@JoD% 6}PU<x @P8|	(9H ;)*;*$*%+8 ?T?T5VdB"pa&b F ł(x; 9~%z`6U0` . `G09H~s ց 	{ d~@*H  ~K6cNCc4{8x F?~!BC  #" e `QP060oo!  8!` "***" /"$'$&*"$
"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
c =I H<H$H$I$W=@ @v 4R$ze bUS R P|7 8y0 ;)6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGJA\! B2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#.H	TTWD? ? pw 0,0  ""bp $ & "  q?|2@G
i-_ nF:@e$ a  8@
#]](00]V?$P?			?R" N8S;8

 ek| 0@	! y 	 	 ! o>""	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDTa C
w$>?  '$!$34, g A#A N<8`hO `&#f!b6@2~Z*\*jI0 bBn5	G x ?RRptF H0	    	  a |$# '!b[aaap5 2zasR0A: <  B F>lxPXHL0F`Cu@;0` 2Ǡ00b64~
**hH$lH UIHUH~HHQHUo~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@>#t40G zRs'"`7 `CD  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <<1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR_!q #  j   "**~*B  h b~B$fiBFD0@ @C`@.AY`M`  I2R2RR 0_Bb.	4d0.t ""p bB ?~b
(LA%ɧg󄣏UE``AC}}8@Tl@l$5?b5dk >qcQ"tdaxR4䣄	(	)	) ( )H	ߖp ^c 5] 1 aA#?~"! "2&460ba0"`F @"{D1 X8@ =@0 P` !bF! °?(HD>!"? |?;" p?.a ee   	 `p13"fdŝ Bi|"@Acp>@$	,	(	88(2l"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PPP`@   p   uUp cuW` U `	 `0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P S膅SP!bRV^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts27a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F. u 2 4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo._61FF!.W_tOT_G-p
QR.6`1ƳP ZwY[X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13o!a01.>1P20X2$CFAPQRW ((_ZYX. 2.9 t.l1BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>f1 t3ػ@ .d1G.f11OO#0.d1.wf1pd`X@Y 0..?1.10;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M	> tj6hyjF_hd&  _hE\>W?ohd% =_ ?@#2J	f~bfffػ
NZd\dm1f>]djut$QU_	`	>-	Zd		A	
UaUf	D@xE
C
5g2Hx
ԯ!=
SF "R
UQZdېB X''F')g_\dUi#+Z,+yU"z$Uhx&G
X\dx2bY[jdt;j9!06F688jL6cjQd$ fh  n; tAt=dtfh jnd$d.yqtfhcL@TA
 >tS(ft3 tE>e tjhefjhI蜀
>6%j whdp1t2>zf tOzffhqM~g t+~g *$~f3f
о~f PFPhehg" |ARQhC!_3F``oHS=#2h\enh \ePNod IV01&	hf@ƀBaFsfhfhH	xA&d象&d`KCBhbFP9@  j}h!		`#fhfbQYI|Rhd4
SdBT
OY0)5%h01!~3! V"=F!!*hmh"O	TPD	'L^_ 2FFg^ F&<
uI) u&*_&8(gtFFP9 1FOuÀыٹ F FIuFp*1 F*+҉FVg+;u;uàg% ;Fu	;V@ÿgG2U@A99g% 
ÐL*	~
7 WPS
`Ffj h SC5(-{ f f0g0s!6 &~b&jdjLfPav0~@[j`Paj FPI`FG*"aPޡV=ut_ V! { )#vGF|_ V]026|[b h &Ч F GP	FNuFG0u?7 

yǕOj,HF ˝FaAS)ޡ  4"d=0u
&hd&deyF´2 1p a{>vb
0E2
2&[d% +1Zd1hd 
Wd?*@#⼎Ao"jFmu&id6idU BF92
!.r43@
o3ȉ` ZQR	j/jdhj`2	2&b% ~b1bjk_R1˩3pW%2p%  jAi 	aI
Fbh~32d%djD
CT% 
@	
H 	N

g3\
1Y$ jij*YM	d|%jS
+ +h
M`h$>eRP0qU//@~/dj~a*&d	BHx^t5 qh@epP_Ft@n#t#!y"s&j@z+&d~D[dᾅT!>@&>d`Gw_&@!<.  OA=_& &O g M߀0<O7OqW (gQapm
~b  f@ qdod t}mJ2P2a;0m=o=b]!!@ ^PpкFg^F  ^F&F~
r$Ae?&e &(f &Te^@Bh}@ ^g>@ {d e@  ~zf# r
."{@V`E  p  V6`^aF@t 'tTe Y(FuM&ee (f )8ʀt !@kt ߃i 
U+%U@@1ie	a qt*E)!O
TeuUԑ+~ 20_&d e!gd!r&dc豴oot5D @)".cF{00`  &dw.j `j  3
vwB +#rS|WF3BP
-_B&g'&g &{g|5& +&C!&.&Ƈgd rp<?fhJ YY-M2>^dq"]0>$f&%fFVDA&@fhaf\e	_s$Ua`rvz`SQuNp1$f c^?%fFC?@t#Cj$	p=ggۭ$f$ < u @<@/""r!ø`" Y1 `>bv)p9414 `4L(va2]f3k L Up
t%r ҋF^Nr'~#tp  u^    % F Ґ)a^  ~u +ÿFVVF6Ƃ6~ r~t` t uFPލ~fv
F0V32,pIuquSI]][t

^1 ^^t۸
M~ f#$} F@B F~P|v^ KF{ NFFߌV~ 3NHt@HtcH} P )A-2h0V6^F&? u/cvw:A8A03e&mh8odΐ2bc ;3cvi1cm`
NN]FQ690fFF8hFF7PRh_S^R/GFPvFhFmP?ud~bP覑udFPNQ|Bq*0V.@%`&0i<Ht	HtHt7g@ .  &>b }n ~|  p,wb+P ~
-udF" @	` r hEQ  @QQAb6gَ (FAb-
4&-p.8F.}F4+ffP!KFMOb%p^F
)C!`@KL6!;FF9 9~2|FtFC~PW^
0O~ O	H#MO _ H R}VBFQC940@~ t;F4F4K
z uWV~v?N^YPYS
J@
^_C
"j(c
l`


[t ,md(|WVvԋNsODԠEHv\`\~(|W~adt_~@u"`ݐ#}HaB^F&WS} 
 
.0\o!yu@## PfPqDia2Ҷ
%%		 	_F*Pg	}`	A
g<d-UWVv<`~P F
&GFq&'d*V~ʋv!^P޿FGIub ^&^&8t #^^}R!#ù
 0GF N% }p,-Ar  ~s԰ N?FN+O;u0g03ɋF@ AFC&P0LfF ~ЁЋsG^AlF  ~
韋vЂҡLD
CVV,GV~^&FIa&|$a)6F"Q2hd% 1p Q>?T@#b= 9ڜhdo~*

_Z#3~b%+1 1bj`R:#	2&b% 2_Zd% {1 1\djA 	aھ"(K,32d%djD	2&[d% E
	C
_	@H?

N
	S 
	 UU@g3ps1 jiQaryYrPyfQ@zF	(x&$?

&dW[dRfa1f   \ef	 f  fh &dm؃`2`&  ddFrFC6J3^0 V>HFRJZZ)SS
B3z3~Qk}  gb`q>j6hT`JjFhd M<>$z?@#hd,(K 19~0Eo18L

!}j`f~bf	ff_؃'Zr_fZdPXx5
A@MѧA \
a$;QDUxrE$
C4
?
JJH_!Mm"NL2
UaZdVB ڊ!$SpF "4%gi%izJ'BY\dɳ//-FM  ?jh!cprGWVvދ~ &F<t<
b#r4F*;?b}7!y~tF&8tFu|t<r[2V0^u	A(|Ð ~Pfh#   0F;rF f?* F p F*N*ȁ vFߊP0Gv
u+g^F Щ FOupG	bf$g &$gvjdtbgq0  2 &g22`% u"g$<P2g%g1gȾu8q= +ɉN3g33 е  aug$<u~g% bФu&
u]f2 % D	u 
uB
 ;)
u/AKu#aqg%FO2 eggg gg	ggg
gggg g!g"gXaҸ
M2 f^3: f |9`ujvRP g- `FB¿~2|ȸ1~`ƿF  p ~ uF\em
 f jtWуV `FRvpF@ b*J*p
NvQϋWV򐹃FFP
|Fo؊f-oh R
~%F܊f KhF֊ft@ t؉FjRvv!h 0-~St` suٶP0M2muh
MhD IPh߀ FފfP~QFf KjuB:CF0F1F2F3F4F5F6F7 8F9FAFBFDFEFFw~Ʊƹ{P_؊P11T0fb;< 󍗆 '@O&6@AaPj,*`
- e)@iP NmV[[G|]] ]<]劆2d$0   ơjQw$6j)ѭf s_
C@eQlAgЎw.f`pՏU*+- t*-o} t94 )!13q$eRFaaR }OCOboLIF 0#"7g
1a1  GKE"t/ 3|
/@+F+PRQwr5pd qa"$ j1@vg2 k~bP(LFPB	j)"#M2#"#9AD/]LDE WV3 W$䐺^&@RFG|p3Xî6 2 R_& FWq` $rҍj7<"JW>do bVebb6  &=  t@M[_ Ft Py 
Z"g#-//

	
a@yu	N 
M~0Ĵ &?&TV@oS~ t'jpFI  t/ u#'jfy_qpt=7 tA:?@>u
e&(f"e2(f% P-(f  t&e1`ul À&l 9gdƯ8g fxh&fkfjf;f h[e@bbbȫd[eUuo[h hJ9| Zs轊p:r@jИhz ۢΪrB 	z	蚲
荂ސQ  FPP W
M   kA0
MAZ AO$< wrue 2A5Ӏ>et#~bŀ&jda
uid&id	ɀ>2e u|K`  (Pa O q{rcuad~u
h#u!$Rq=
u 4mc 
k4/UVI TTV TܢTqb`F&? tl(u(&|Ru!p )u&DPƋVk@ p*A.tu'm{u )uP&DDPDPpqFBݔfju!
   ` w 	   !  -Eq3~  A4 u &Zd`E Z>`tfHj j T3= H/ td-
t]-! - ; - p  r= M - -  -^P Q ퟓ  8Vۋ  &9w&EU 6`  VV @%6Dˠ   9~o H  1;p!/ 
f
w>~ KĀv&@u?Pe`^; @1vĴ 3Vfjth  <Тp 
`0 "g ÈvV>B  } vV*F/^ ɀ[P% 
Pp h
 h  RaNF
+F@0F!vvo} ´	F
`NF@ zj av0CFPNQ=`?*PqK`VW  p 3_^e 㚠
`%  @SᜊF`
F
`AF.
%
;F|!% F@P!]!Vv`NP@{FDt&@A0#F쁄Tg~u< ͷt (F7 PF@5
f  *	 Bఢb~v*VsA pӐ2Ɗ* ufU  Vĭn'] ᲃ> t`ur3NߎF`? `N`^&8tG[ vN! ؉^GF
&Ft;^ G 3+tp
뎐V^% = @@A3t`ߋ@!A;wȀ>
 u31&A *;t{r1A p:*FD0F
stҭ t" `fpV
V=O`2P.B@Ҁ?VSu	.SEH5Da!E'(Ezr7Vu`5 3?
l	#5߰d7RP3>>~Q XZ~38tC8 u31~^
AF9G
uN3~(~ 0u j  FO;|;pUC \fUVNVv<%tF` u DD^ù
¿0NÈ u0+1W/WVX ]V^tQоrJ;v~ F^F&uF%$=W\qQb]R}  P+΋8sgdvva!V0N&8 uN=w tp&@*®0MAtA߱ Gf6 !
}`f+IQ@kqtCTNMi
ʐ =kj ##еw`j&F3v~Bǉv0Q&Ľ 0.b;~ANuv 0dFAǐ
 &fP0^V ckPQP F} ~ ~
~h3ҋ P{W t4 hPǰv[e'Pq 	ptGW5"p xj_9Fu
0_sPK v#5@jFVFЙ0ްNvD"F9F}+F- P@!b' ɒq YFF`%jRp";nT\QP?EPPPPAjP:! fh  39> ~Wjy/0`*9>u	A
@0
A/\&7Kq6%'@2)
G;|2*& P c`8(F9
A
jw Q}j VNVRP=AQda'JP? <nCtbc E +FFVa#
0UcSpb9g 0aDPdQ虖8Q	5Q`,+F+Ѡ~`M*2f REg@=$==ӁF3@**A;}Rsvs`V6r1qyg*@F;vw_P4C
sR14+

OuK#a;Q&BPedD$A84	wPeV輡VN!!C&-24hQRptYAS;}{`=y#DȰdf&D&[T030`~
=P  q &F?@u[] ᐡFt^dF;@Ɛ׍]q<ЁN b®PO;v}}vǑa<GF;F+F-}	@pFF&Ev;v~}Qm~ $	o;FF	_F	} t~0Vgǋ~PtOC tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F\50%&L
q DFF 0J  Ϡf@`	PXf@PF^^EڪAgT l,2s|Pxb<WFA@ o0H&vڐo7QvFv݂FՍ\Pɒ #R@?~U 3'ts~F+FJFHfh iR( tTT4v .9~4aFPk6,+FB!}=pu.tPoq &OC@ +σ_Q._;+ǀ
0|PctOj[|

FB.=Q j]>0onW0L# 'Y0rCA& !!pa2#$QBC}P׾PCf:gpL@>:g<gj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFf:gF  F
Pj   v
u}?1ƭAj >PHPV`s
芝Ϲ&wIc¯FtB$P
QиN	VV2ٓF
t!@D% QD
9Q
VQ6{ B tDu8ЁǠ
!_؋!bG C pDPk+*. H!MbyB`tu	 rdPQGg	R4O1PmaiDu(+Huwu @uqt j	jfh	m	"	PV^FPqf~
 t
N
>a}gxQEPzU@ ]FY m DVVjvKv{xX 6G ]3?鲯S80 ̱2Rr~wFP1qE~
JG jR[807+$ }/p  9z]tك ##/E=/1/F_FP9 \ dpg
p; ;NNNQP[ @C7 򠽋= K = ;  -Pp-߄--xАW^p'Fj  k >g`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` `0a~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< uN>0빋v T` 3P Pp7 & !VN;
u逐xA^F;~ma4XS `
$~Du6g b;|qT/QN;v}O;x6Vf~ uFApL怰9v|GI0Đ0%9F| ~A^&+^& 'FK'302Fb`g!ihj@vVt ;tt D@gx3|f4Whyl
 _rz/~[I>mFWV  Gc $f td@ U@ l t%f
|t*ATD\[u0}Y;F~ ZpӁrջN@uOp0
DK*=Np>\e u)>f tl>fh tt >&d t|d`h|b?0 Whp.u"jhb ` i
j(hfh`= H` * r`hdh` ` `}z `m#`a% fB"	H f%r *fs% dc%	 dSz%
 dC%= d3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhoНpt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }554465245rt659hZӾ@E@ jpPVCpWV_h
	 !V3j hD	~DԀ`HtHt#h !x    C wt^ý f	$F2 HtHtHHt$" ^@ $Ѻ&&G<P jh	G+P舐X
GW>7x@n u^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GP{u   >pj~q9	uarf   ^f~ t  |֊FÑ!	eM譭	L0#	Kac ރ	3$C0(`(hOpa^p3&~/tC&  v&o8 u*C;^|ck
F^P9P硞g`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBݚtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@ǯF	 0 % t" uwNj p貁F  Bܲ u
gށMN3w~*^
7ފ 8&8u	F;|,Bdn~
eP $
Pڋ PPC 
Cc!
d$  *8fudg"^ku Q/	tP3`0F |n FPf@
t)f3fn @Hpߎfh 륐j r`z` 4$u }@3?l3 1/`F*A;HtϠ5= t	d@ &d> .dQu鉀&
:v	@
ʠ
 &
&
hhN
h [?AA7B 
@
@ -*߀

@5q&
 3F! "&d&d 
gi
g!B"  `FP~H AKN
3a$\'"%D:GBHF`^Ѐ Z č&Í,3F
z46 x$ddj(j 9
P8
PPfsV
bW&*`)@&`  d t&<
 w<)뀖䀝 x
苵Q %'@q`
豑! Ohej  %cbN0ff3	`%  Pπ`RB/
?
~$*0/$40/04RjTR"`RV"dbtp%W*
@

aH*=	_- I- 9_t7-
 wqrMt%
- Ktq-Mtr` MYnp= d.8N\,2@0`  8&`0'WR!"{Ր,20`  0PXu/1V hxh rST  9YۂY݂Yހ;
Y&"0Zd a=	_[Q["
@4 |
U!@ `d`?da0y y Vfh0/h y Pc@t&
 _
@ UAUCCCUQ΁!#!
@d`d`
Ɛ޾
r( + (#+-+tp*tcmKt
- tu] &3& tGђv 1vh4h
h P!wu
j8%A}&A
-C4@#'$'4a'a{Ðj=؁ ڰ @&
)3bPf 
F0>{+>>G>d['>n!>/>f'>< Ћ5P$pD D:E489JR4"" :L%9
5BXhh V2^Du+! 5 31;utb&`S7AA@A@tR_!P!_!
@o>aO? 6`L7.AL&`a~S<!Q"Q Q*|3ɻm &ArhOE@QGp@	XrQUUtDu33,io
; YKamrFv(!
or`xc$Pvz0%@txADP!DE$!D`
P#wBEf~$x0%YAǁK=XD=VdÐyMa;Ա;
fhZ " [BGb %^
t
]
ct,װW*@t>tq *``(@a@1)@4AEaŏƏxCQ #& ғW╱$ $ j4%0*@0ID
p@
%@(TR~26
42`aҟCB	avuv}UPT	b
A
 0z58i$ _  	 z(0ѧ H1p c AЗ!@] ]0a0ua1}b"뤁Wab 눋a 2w 1 릀G5r1p {"(9@( f~ fhdEWfh  _!zfhdfa&idN&.W.@S56P6e!7>d>8FF% Z9N$Ni 9@#fdfAjdn@	>d0uvnu,	u#D[utuuV1  ,ǈ]|rh;r#veF8FPVh@w Nv_
WVE 
a^HtHtt-oLB+ faA!!@f>
g=VϪ|aBaPe %$Q9@ED' `e<dG:bgC
@
\
i`ݠ,!f+fWF@ ؀  F|a^F蜀 F FF01<`1\5D>==   - -tR   -޵ -*t:-~ ֽ ߐ= +-!C]  -qt}xz$Ht?/Ht:HbC 6 ۢ (`  ! "!13 RY"  A
Fy
t)j UPTPfsV"Ptt ;G0}aq&oY!Fp *HF
M~(f@ fFܰvfvvFPvА5Fu63F *ˀ~%v슅a :uFG;?F : ~ t
w&`x|@xP ~^@&p!U  p!qq t&AɯÃ@@͌?"Ht)3Ã?@ဣ ~b|ʀ&X qV>a uuHj 
&3v0 RP(fafBf@af |aU < \ 9FhDB R
a(f3 B8-9t- 	t #`
  *Xfjj a
5	1	u.#JNuh @>a tuxfh  P蹵	-NR\ >< `6

Mh2aɀhB6W3aa& < ~ F |~b rAScA >|p#u>>p\t&el?6a[ ʃh0`te3a13
>*u	>\ k0!jj22t;-3Be'kgJ t'{80:2R%4;44Z
`_b0h jp0@ϒA!Fa@[$

uM$4fͦ*tS?=<=5r
5
C`Kh@a	@Ba	0 fh+rD-qp<p$ې#;$ %/0aeaada(fpPeq ) d%  = $Ozf~g1 P 2 )Rb
b
>c
a^֒
 }g
h
B 
b
 Gw3עA]$ Dt,-
t%-.t,-	 tE-
otYtQ˿- t/C Dʣa:B~A _p}}  9oU&V)fteug& ra@)ftu
0t ڮ(f@  -0Ⱦ@ut;>}`  Pr־%hԲrjtXя6 ]HtHst `t' wQ hu
^_ WV3ɀ> N3һBr^ZЈQ @FPWnp~rܐ
NpDt  ^& Q _FV^tF&?ud,,,,,,,p+,,.>uh hmhߪ; h^ , j v~
0c/"@t) 3҉655Q@;@)}F~
r݋Fn 
h΢	
J蛾
Z 5#W<~B6wf
 ~Ĳ߫f$g v3ɉNv~FV
tut9v~O|܉~*Pӈfa^3
GF&_F 	 u^*ۍFߊF%'F_n"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bpfaff?fXI  
at&
S
 _Pt	tp` ^3

tF^&ߊF!u	 |03$NF#@
EP2fnGW^rF*&+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.Pû   p- 2&a% +11a_ @ 3 ֐j5B jh
@}uE
 C
&?0:/ / t (YP)@ wj}Q'3
^'G`hg-5؎GS.~bAcag,~bfa~b$ a
0&
c
.Q 
@DM
F@f
fh0V" !{B
p},pfh*+`w()&' $%h#\b\rd t0
Od ǚfu
Q0  O hEI `F<tF "7h"Bs by^_F ۄ-FC|ߊF÷aGwVAͰ
aO ba!J/PFQd`lLQ'H }fz`OeO KcOSRӤB
)HT4PDĊ7*0SBaD
U
H
<UYD
}F U\X(T
~__	RQҔ
R](q
 bA `մt2
R bWfBhrR %jQ
T &5l0r$}1b*5nUr&f6EpCp(EA
y !\0,B`7C`LB`B`+-
- `
- Kt d0`a_____CUHn&64,2"5^^ bM  zab AB  !" 8- 2&d[d^t d@TĀD>b )# := u@-  }30A+5\snϺY3 빹@ = r m&jq /L@u1DtDt8^fpzCaeQL E@OA#"ңSZdK"sfZdfףaeapbp@tj xx =g&AUCADPJt &hH`ώ&? t
&ؐ
~@@# 
誄
C	@


A  @Zd:x@t&fh!~߆觴a"@Gyn~߶fhhF
5Q442<tfh:89h72
/q0򳱋v?B=>h<ڀ
T@UȢ`	DBChA}hʿ2sWV$f$ < u@0a@<@u"d s@utH	Ƿ;>`  *r$ hh$p1݋@66_b iru%çb Dt,-
t%-.t,-	 tE-
tY- Ht!- t/_C D0b:  ~
3 	}  AՐк:%@'$F P=c= Ht
@q j  r jݜ@6|@uf4;F~  ҃rջ|N@uOph0h.TavWVV 6W
nrvƐA퐃Tet
Q &FFTet &砞dm"8$_OAJcM&P!G[@T%V% _%T%&rhh T$ 'Fc"b`& *bPeA u$2,<7 hth:<9  t~@ rb` zj~=  TPJ
 =jP,bzp0u.&bPjj`w&rz"pq|Fh0#00000000!&bkVfvfhI
 2u mh ꡾bF@c:tF&<:u-FF
*0N&$  /
u3NQ@C7 ~ uF	 F
  
 
 <  C
[v`
>A
jq<L^PB
/RP"
?z c0
~ ~ tghv&~ tD1O=ܩ=u5 ƄЯ
`
 ^3 FPPP FF9Fr @% -
 ؋0v v sd ƨu = wѯFːx˞˶ˋ~FP.a<cy~ ~ t 4Faz    R~ F  : .E "  
QpÃ~dz߃t' jƂOFZIZ#3^ \L E1hV.tCq u^ GCauK  K .g"=Q
WI Nr@~u_t W    Io t@FqqFV!F^@=ugFv2NS'22g+@]WV6aسKhhy*y fycy}oyDt4UH-H4HSH_vgHQy72=yFIPv9Az"ClIDzߡza
4zj &z<f+fF@ ^ ߸ ^6ޢV^KFP6b<
Mv3+Q OY  l`- t$ fFf~ sA,Guhp诐ܠdfQVȡbRPSQfXfYf3fffPfvGMF fh  bU耶1g Fvh "CQPd MPqT¥!TqʑypyE  p 4  V6rNq		% 6<bD6g\ 6g|<`yY
]0Ð3Ð6 AMD  PowerNow!  Technology  MHz   KB (  +   SIMPLO  MOTOROLA  HP  1.06Ɓ  K    Restore default system configuration mpleted!  a) Press <Enter> to Shutdown S....a <  drivelock VB C 	u Setup  <F1=Help> FilesInformR  Di_splay5iSavefloppy[ diskette from+(s.Ign2hanges and exit EP  s! withou>aving
o Securit@AdministP!or passworPEC"e a/".'-OnWGpP&~Device$deDgDbD$L $s mart Card%G
supportEmbeddae&f
taA!e'etr*a!cp",p(s$:authentic;e
credal Auto2cH%Tools Ba /0Calib( @(`n'lec`B b HDD:lf-Tp- opDs _Activ O Mem
C+hep? r s: Sll31mb 	>>uA@AdvancePqL`4uagaC lDt7  o?f grayq6field Bo	ow1b..Uany keyUpY ue F10=
, ES7C=Cl  9|RAccep/=YesSNo \D, Ao$-r=MpI W  UsSarrow
 o highl@ *he appropriQmenu iAfqKpcNTER> cbegiggK%#.followM%%k&:@tj->  KSPACE = NexBR3c=-BACKlvio"FnTABE3iSHIFT+&*TsF2@&10`
v[J #'9 E~r This60/cann)b`mU;d An e socP^@ whs6c.de _0x01 e jndApGPu@p0{6Crequi yayE`d~jba@%mu0C
movP:0 e4k/MEU )hQ1& ilAl//+2SD`a06ssf{ulManuZqr  N0
d:Protty9p@speItepp+CacVize (L1/L2)SQ ROM dd famiaseP8l nupi 	Videovis"KOeybooFr06.verDHb1<ed2e3bg4`1qa<Phi)p(TdG
W
O3O	*`	Ĩtafdai85u%BSNK)%$ 1
2
3	ME
C

V


24TV
o
Do"
So : D%FPA2d!J#biFaWalRX0s&1z&H} Addߏline4 CAlXn.z%F$Warn: rk Tpll$0o  zDsfT[rea /V՚, lef ena waba02 A: 
de` waqt tҰ_)Vu @rnInv ȍP
)!	Ayou̔ w=a@|to  @Z?m  i0o	  0o b+-c(Quick`n22 (-Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30 ¾# g3>0%v}} ty ho0#0#uprХ:1't4	fy-Unknk&p{ilWR!mServRe1aPS)doџ47`?a}ribp	:`exP9 'b`G H  Olp New Vfy nY7Enc8Off O$ ɥA LA66#%AKroE    p dV
Ad1ݰU @ҭ5Ocpcaus7@APp@=AH"h` A&ف~Opower-.ASQVQa?Uׁ= loss T(dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHishaR`ed?!0f]Dddial <JJe HP`"UTool Cr.%oF8IL`ˣ Bk g Uмn qpm`@jtWSN !arv0s /UcwcQɡMP2"Onj* e:0Z%%% F@%h԰#Dn -f  TndĠfӰunuR?*$=n)tartBQK`fra Par1yNs Spdlot CD-Q& vb$۠@yU@	11>` abourz2ph҂ u2W!?1 bUSER"MAST xApanPO9`cRR%Tkeep i2acIewphysD`<AphaR  7{mpp`r. I6@2?R>
,ҚĬnRVun *"gFOOAutoOcEdpptY55)0 ?#ON;
 O[?k2{`Cb_pur?t \22th@Pqsow Vk ebdp·PerJa@naff+bdata, ]ssiblma!aKpkigi0d!V I0sWPlr mm AM | Tu@yl,lreplap[@۳o  o/* y4y@ Xr"ˀt,C oHA=Wy|'qu{me`1r,@ @M6`*p0uibty. I
fRdo4Ǆw8`!ESCs. !
T V ͲtypB'>'nђ@F10"q@rm ,bShxt+  E$@ MpiBjQ  Orpr: U ay OPXrDC$gDLb!? (left@t/hUSB t HQbSu K ZipoFiro!mF`thifp Sixa h ENh`ASwap Fn/Cwtrls KTU.S`aslegackC>is`7)n0=PrL@ry Vpo  d NTSC`AL -J -M+t
Bid`EPP ECPd2size 32 MB 64a 128>  AUTO`  o Qlw+aynRi2PAC ViWLAN D"Radi|kBlueth /rS;chA Tg2ǀ͡`Ptΐ E$ !h*,..2)+P)c-{-&3E1n8)e 123TokRHp
 kP	M3Uniq_ue Idfd (0e0   *tu@    S MCalibaᆏ6N sPPS DLA.Zb@0B  HyO
ELk MEUk'g'MRqN/G/U[:P1 : C g . `% ]/C&le2 zc1 dik-d3	ps
H

,
* A 5>M(o!ylSp   hnology'tFYadapDPXE RPL Ex#>Popupz(  0 10  2@ 3 4 5 6@7AF{12z5 15`"@ 3 "M.B ouchpa`Pr5SNon <F1=Hilfe>\iYin[`OPnzeig0`fppeict  K!guaobVwiex@nLvŘeinun	F%-s
kz
.ign@e0d A*nt neh7p/%Set#SRheitsfunkn toa u
=nBlt-KuO] Gertes/-$-ID  O t7	Uasttz !  Qz#  boeim /st
ng!Kr 5nHsvorrq##7..zurckz9
aB .p,
f_	g{ms>ThEx)`AkkSukr_eK t0BsgewhlDD-Selbss@´ItivS9#LtIwpr 3g 0:2 tppllTL
PZ`OS
@ PErw< :%SpraQ 1a;n!4:#U"gran FeldsArt-O &O9!86")e SePMbqTa@0, um9 p_3fahB@i=A, ESC=Abb!#`W8Bkze!T,JasN0\`, Ja	=Meh`m VeZ
zpMark"sy!*!'MenS% dPfeilt!
^dQgabe2RmOq>ko?а9 c`s.	fo1lj
Bn 
sg:@)->= 0r LeGQ = Nch XA\pd<-RBchritt-`VowA(GTabul!fsn+ Holl+gedOx F2@
38= {gy EschlrLix@PK kan~Lt we YeiffMgy16P=`?rgetrЮnu.Dc 01 `L`fit B kqcQFY+<W\selomvPor&B]er0ilXWqDeskU-2KsBhmu f 3asÃbz{w.2Mobi޴bgtz%. `Qz qh4Bi///"2f!
}[KAlgrѫ a}b	chlos@ٰ`F-M`l?l Proz +yprtt`
wig!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Gra_fik-R0sa@Q Bz]r-Con "
A  @°a?7J	b31O 2O 3O 4`dqV si H>(F ` 	o	o
o1
L
2aSekrET*@ L$ƍDD%'$b-!3Kc(1  WalkZero-T<One EdQA`@PnO`+: bX7 ΀stqbislwnKp  ZEucQN-/WB _leDQb s Atei#CP0&ILp`ak A:nfC6
lW$ge`KR/+Pglp%ɏf5 L  p	/  M0$wirkQh"vQM?`3, dap
l^ie0wQPocFLˤ01 ( anH12 (UmfafdIGcܲ$fhrxdauP(Min.): 30ZБd0S`@0% cgt59wuwmG HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52'rvo-L 5.
32@lhafAttribu0FID  2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Faqlgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  mg1i@eFN1sgd,E.@з"< ttifiz eq s{0yrt.@s Zu1`0LzO X9p袓enl@~9.Ajb s0Q!np'Pls^AviceTa s ,ܠF$0@ h`$̦pga|F	 :	 JZtfa@npWU=m Fun)S7, m3ex\Wn HP{tectToolsP=c^ty ManagпUo-- c}- k QuickLocmkSubndHFr#q\MЀ#"e$bi sϢnchutz  f_-0?1dԨ@imd&0 "+a A)N+ *W"$B>x#, lpp$meh1A #I Nk>@"o3f`wot-Parpen}imCD-ҏ&g1DM!UP:a!n3A7m$"Orive&Ftpla`t9;PcJs E-=\s mU|8unbrapjObar.IptT
b,ҋbewB>BSDsTD,d {¼ !C`&&,	I, 2p.\v%,  @ H2i<nc4z@ N}Begriff0diau'tomLs O875@:ohl<? i Q֩g`y@p#ps\V*f ~
T'U@!!´!mU"Gn OP o"e o )lnYy#OBzs瓡58c<sQy:Sށn iQ.) r`uM(qS!|qs% mh!ac%Cw Pr qғ+I o0  lqurn׳hE . Escdrr empf/qS	 d?zu!тROx t.  󉡛 ( f.МYұF&1 2  B 7 b-B`ntra tAdant!Whj`!@Esc-&VlȠ>mQ kW'p'p`\ F1A0`esh:
x*3fg`g sbD } m  ܡ@MMuBay&m  )bBtg
k`-EQb?(links (1tUS#B-b#-2؆Su`1Z[ip 1`2U34 5`678 9`QF?n/Strg!PAt ų dEaC>Г (USApf-ZeP]B`iebss"unabhng`  cAIAn Grafik-ContrҾPrimSek% Video- rn~ԿBidirebal GrP us g / Lf`ipDమtzb
}r WLAN-G"faBluetooth9Un/a jE@gpa!OAggr` `%(.(o@)urX.Ept 1DP235ToSRpb C=A 2r t1w`$_1INkb|oG Akku!O(  Pt   x %a  Kalib  M`k`O  NFi`ualq`   O l   O  DO,VspOTra-?6. .O .L 4obiqp9 OO5"Rб	EgnOOf`.[zQrP 1 :r.  % ]6abloq(2Entl ho3 ЗƱ
m* 2
  GS-2'su @<`RadapAͰBPm z0}ExpA-!-Popup (.) WedauQd02 (!Z , Ke`~Comp0ropstn <F1=Hjlp> |Atoplys!VisCnwe Gtil` !Akonf0b[GendPfraMz@QrU
J`gnorndr o&fslu r 1 u*t `gBOtnek)hed Administowradsko3 K aodA7 fo%P ˇhEddjeG-i q		 *	*
J	Sm -kort	God0delsf 7`do`_dbyg1gPGOds -&2	 Nu@00faks4 l2 Ua 	g
s)9FHk@\HFBa.@ġV p cb"dvalgb&HDD-selv4\tPr HukoQAQ.inPAQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk {pP7 tas<G0=tZO^=A, ESC=A'nnuaFs!3=JaNej "J, A!R=MGb Brug pr@
NA`RP70we?  releP %_menup(,1Wt<ENTER> bqec>A)get. safp Pr'f!f7: -> e!& MELLEMRU?M = Nl<-TILB'AGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sfej 8A3ku1i20gs 2dodQ)!xFF1n. Fg01BRnoVD-p% qplax`9G!krv'vek`EnJJ
i db!?s flyMsÈn/MEUqoO5 bp* uvetzbrCud 2JI,nemfB J@`  KPrc c@?or-typ 
hBigH  ztr`7Crcache (L1/L2HVROM-d@ fami'liei;A.Wdeo#f0pd⠫s:@Xr-cts]D-ba`si`9eI2o`%3o&4Zz&at-ta`oFfej1E("Wat)	O3 OWEwB ex{%Is8r4E$ TyPy%xy lydes!Bmis 0'JbvD1IL'j`Qesje var0: DB1! s|e  alt@xP02[holda@ poPqt2`/b Bb-BEdqduw5,pr Pk
khEuGrBA:@ރTETf DF%Ugyldig/
lt-  @ngivuİ,vi av٦,? i#K?@ $1 (Hur P)%Omif`) sl(ؐ`{ ():G 30˄2j  `1x0% frpudZ44b2@DR 	cq: KuB+"UApyCqS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeyae Fra@l !e@+ń4 PR@{	s0FC		ƈ4 D
&K|E  beviв@B7 9!Cfdes, f.. <ramG261  PoRR.RVuAj@me+tabWata. _Du bu8$AM flAX:Ը vic#ehCa D[G  @ߒ[&?r !,ci HP te?ctToolo9"jK Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat `w@x6r,l
di upbilK2;+81ol p@?frard )x  Cd-rom- cU?Bg Ho2A:e@AuΑ5$uhu,;f Dq .  bOBRUGER-s OVEDADGANGSKODEN,22pQՉLU altga9`s  n Be  ned. op@Ia0,'edS T#
{	aMD l!j ЂD _aBAQNhjlp eutom`oK, pD,ZAbyg!iWj?5B^.k? perma@3an`Pig`v2n:j fys dsk5 2 rbfppc(On O"k	v   .cBna  @ucW"EK}m/, somlмa ck@
<ҚTut. Urd}U pbz@oPc/cÀ pikoSӴ@0.P  оbefalkrafǓPapx 'A1ŀv@"pl . PAXu	u
qD  &cO.q# m"J"4,Q/8d i`$HuA0˗0.a.j20:@ENtrA!5gESC. क़% orVPx 'F':gqe@F10FY ӄMsf
i/P4cD+su  !Dk Ossrflgm vDRRenAHPskm DSP-bas MultiBay (K0/$hjUSB-floppy%#{cc{2|wbsu SbAzip~Fr@aVTredj Fj oe SjSyRV; O Ni  Ȯ Skimѩm Fn/Ctrl E`lPv(ua@i`sk) ؜ UegeUstt!
u@PnPAQ֠rm-cr Porim@Se`d V@o Ou?t Para  TjStrCL`ohukoЙ Bl8d t 6nr compu 10P0ƀtrm
gAt WLAN-!spioBlueEt hK/A (trdlvlo|net@r0Uc>!mstyA8&(x(top1*b*EthNqft 1K2Z3KToJRaY HL	e+	 	Ent 5gt id-nu2  0ı@  	S@   Z 7b/ JKalibB' 7ndaigO  x 9p6 @W NMH @KO OM2[bo   O  O#0 OOOO$HAgs 1  1O O
1yVSi mo`gPa(MEU)J=K=O OGOqOO  OOO[ TPq 1 : O . `% ].gAmt2 AfFH5L)O=3@	Genos	
`k

, *  J/X4 %G)g` hB`At `r`bpopupsink(sek.!H$025f-1@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jonRs sypLa@3$k")Hefra6#:p`di!opQ	:k@'Pg avslu!QA ,lBDE;sprograpt STt Zpa+ss@ a/$OpFA0`|U'yrsei!>vsfunkqur!tif@Ԁ%@%-
vn Sm4 #>godkj0R!neby3Pi%it"ot5sTilbake@l#3fabP@P@BQ`g
i
 C7;avL`Sr_kty & ڏvalg !AlPP 65vt Ak& MbT!# [SS;G@$*
@`H!4v prlgy 6  Dem7`5bM @ZdtJIel[3
.5E6o%<}5Tr7ykkC taJqLQL&pg _=, ESC=Avbrya bBeAPpJaCNei rP, xi\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NhQ&86  <-TILBAKEPvrig*TAB&"HIFTa++F2@	x)}= Go f#l`bsfeF`  SPk`0`pZmnop@5 PS M0|m kjresve,!@m d;@i pp 9!obaRaflysbc^ 0dS w}a`1A|zrv full1z. kode 02Io"Produ _t Nopablok7k-mll N {typ h@igv&-ga zvAӄbuff~N(L1/L2Meng`	Q	enu V@woI-ЏTjrtroUSW,kobgRi%,oK51 q'i 22340,p( E
,9( Q`
oa
o0A
o,
NEkgB#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( A]dss e7]"~e PRnsAd 4~: DsA#.s@Qtid9lSCholp`@DDH[aQ "{/he-  dÓ, rnP}u1p sakl<k`nn02Aa:%ڲO b@Ҽreg1i%HUgyld#ig#DSR`@	F
	#NEh0mtEb`?̀{|]F igno3t._te?-  HN 1 (yR @nslXbP (): 30A3ggr 0$s0%[v\&st!vhFx_f!_: Ka"qut``U(Ó5$SQ&eGt :To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CCG  G#Npu  Bekreft njAv`l ePcᰔ1qrEّjv>likt aDu!0oC 2Ѽ	aŤ,okag3ogs.rɐor dmpel& Tp}?ّ.BrPa(A=pph. `bku,  amK#0vice.0ula?eD(s  aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l8  ēlanp撩pa0us #L@$AOmpEr`i!gi$eu bes!ka u"-U+/- +ӂWE%lq  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- ParFll+vSq1=   CD- )pFsU1ut Ho Ċ$-:Be5B`Dhpug hh!3@bBRUKER~HOVED-T5蠮 BI Ryumu 0B@EQ
 n0]*RDCbe!1KPP
0 P v@" 2Va! #
6R,ARZP< 	!؆ 5)pp  t~I@HOM @ automPYpD!wLock	3cbyggZ)b0`  @]maPqilg ]ge0.S k_[h fysAad  $0GmqW l#=	|u!m:fnd1]VsQs Ѻdda g }u%x. U⿲g omd@N1|0/e @XG)0znq
` uPbV>nbefat 31G	A| q.1A=w A0k1E 5ϓ f hP_!R!'Y}I7 MT֐s w-QVflans NPBv
,2ʰESC-yL P΢`rb'fD'J F10$ZCb#e:hf$ nd  NKor iFGO%re  MultiBayPG]y "Q'n(ve!e)pPk}o.ngsbahhyOBUSBA|w_ Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeeanAela	jZtsroA2deoݨ@!"pTisrrFS @ 7ti` ΰفcm`gradi`"0trdl |t  WLAN) OFBluetooth j/-bftѬm҅ Ag@ssB	sty1"@e'2! (vp#c+b/!`1 Eth ܀?	n*	3 `QRaNs'Pooo/
9ni| ?gtifikO4C&=BA7riG 1Ipt   3y mbo KalibЩK Bes- I09plPAal ,-N	O	 I	O	O	51O	O	O	O	8ksp.1`O	O	O	lnd  4oO	O	
%O	O	_s mob. ^
H.\L. \O	zo
{{O	B.[ yTO: La9.  % ]full bC2 F{i3
iQ!n/h* Oy  (o J/DoRi򒇈pkm  sin@hurtig (/sekuМr  F12-f1.+Sep_ute PpConfiguracie la Com`adora <F1=Ayuda>rchivomn%l Sma`A1Gup!isco fOlexi@cXٻ Ra`&svalopQfdo bPPa y Ignambios yli a AL{  g3 'LnepidadAse
  ' Axjiciof%posis_SIc )$ +5*VKskSm!=C Soe*c`P#<) Sect}yincor % E0e"@ 30/c`VxP>6fbrI
aBVc!3nci@])AutomaHerrami a C2}H`er  8P(8  ;prueb_a HDDKc 'EOGVЇ&Memoria2aDd*mp.l1@0JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? nFampr)co0N gr<1o?)<UOprim'quitec0g2) Pbm=, E_SC=Ca06la==Acep\ u=SSNK\1"Y, CoN2	=M y p UyB$dchDha6@alvP}  alem o apropiu=@[*<I?NTRO> z qx:N1n.Fs{3pkTYu :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'a~Mays+#1C(/`F2!-910`rXŠ"8b"uErr0^6F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bha7y nunw>э&qubRnY2"@AC1+>b1 `r(Rp[co`rUD)JН@ebook/MEU? IXQP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga`@Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE|`oD"FF%Ad :vH uir  eapn. PreP4#/, WcqscpYcuA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\e'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,vA`Ơbs (R6% E  Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0X&upizQ,.`xHO;re PunP+roj	o%q>lWS9M9ICD-(
Eec%'WePi:XUsio:Mpu;NmediriveA'0 tzUSUARIO2I PRINCIPALьj oe c&s UaJ7manT p w. Anp2 >y gu # lug3b.P  p_jဈz.p-%H @d\WcG S1
!Qbb;v aYp=O@mc}7PJ67EБor1ܯ?b9
 4: @G:iR u(?s } , fs`m1$ 겞RhArQOoc, G"o~ /]y"<:Xou d/aap{sRcu2bRt	£B! ?1 #zda$
kosag а6Se r0wo0enf 8d lic㡖Ӣ@refaz. &?k дu "`#PZҝ4=ԬFainO} a cjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅ ESC. BP1alab:'Fd'  ,F10B:lFRrfG@ǋ7cT/Espaol OӗtMultiBatNQPa DiPsi`$3-pA  ;]SfbԢsco+d(iz"a(@jech@-5 cB b a01ЇpSuwkrZipcpmeaaewTer Jo C`5t `x SO vNo0 DPƀC|As Fn/`T@ncIngls (EE.UU.)s (m3So}"leA`$1nt!Ac@ GC>0eo Mod"y!  Bidyi0 Tam&NmempI dd!i	si0Ffuq| gC3JCARPQ *WLAN{-Bluetooth IA1 P{y0yь hoPergҩsC[po0os 4B-8(s)ior)Eth et, NbooS 1$/,2/L3/TokRbO OP23 IPQtif Excl#uspaAxKa 4`  !,a*EC~e`*-NPYSӏAo@Ur)Vh!, ao	o	k	o	
h	s0bPin	 o	o	eOi o	o	o	 `ao	o	x%MEU } o	.o	o	o	o	Ubo	o	o	ȏo	B8[1 -:rg. c% ]/@|PAm2  c4h-Cle3	k",'*  9ODJ)o!Qoh ~blۑ@zpArGranp" YcXDa0bgEx1ꀐ@ pF12oeQT0Amb TouchPaduo Nu`a0ub  <F1=Ajuda>r0Info ɇ䐥sobNo Si?5amAߡHDβМR0
r`t@7padr0
3 Ign`airA	sPs'&_1na`nJ4aZOD"r %&U'Pb _`#Ɠb!X`_d#!

SJtSdЅ8liz/pʉO
(IB  /R Q*?g%Ϡbr"
aut<Qn 4dcЬEealha@o`Ma C(QkFeOmas "g1= iCP8$!leߠOpT`HD7D A1)r  VR#Le Mem@0A<  4tat1u S`MuW^G[⩨ Av8S%,io a^d; ca{mppJcinz"o?CAp9esse qlr wc<и'tinugy=' SC=CselAce ,imNKn!S, Q%ou=Maikg 'Uti0: sC	qqn'	da o i  aprop@w *u@Tt#<ENTER> t5meRez[@go.Tgu@n:9 ^r ub:  ->
PAO = PrgxiK\<-QoBACKCExaQE06TABo$SHIFT+C%* F2 	*:`=0kSC# 9nErrrOA@Q@na0WoQpmRHE. CϢdigTGo 01  NPhG`,`:o `+)3  s@ viKCA A	bMev
;nsf`ZWotebook/ƀC[(RWS mDGsTe2_DKKXqmBm xiton=N  Ti0H(3VpcS_p\ Tahcache ?(L1/L2੦FX a` ROM? FamlY  N 3sri|
RevisSvde@̠_aJroQLa
Al!D	Ob @a(34`RtieBp	JIOeuH6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcC% vfoi"gv@!mO alx  Walkا  0e g1i	a lien!M!oc0I@Advert: `0[Aqo vae!djWcqP/,!i@um  ?gravvuu:e)EӎOA: n@Ad	c NS3 >B^hO^!QtegiEa	pc]
vl0IyI= rkT@ctez0<eja $,C? !iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.R.#T.ax`=_(.): 30<`хѡ0@CT =4Q0%?z1$bucedeA,qAhos9tDCrom1
: Iss -P$Eg
Ch`Ӂƫ(*e=rPmec @` `6Q3sxM tribLD`AМexa@s wQUUCig:TgrDg`al*PSLs   qL@ rB+ۤiPA3rrfDigcis g ҐSAdP)PPЉxaNcmod!CsB! fazA@ArEr@a,Πer dform!r3Dn,FPja0.@eHCsHfb}rcausadQerF. TbZ Q[ea 㷑2kr/vio 	Iy0rqX)QT?%0Р urb@r0k
ad`pis0S,B,QuickLock!Suspenso BlAo0ktB #u@aSM%` mabnb1(IY @k,@$$al#.2P4sa4 eiSib0RPuseu ysEExigU&`re*PbM0Q+ &perme@$1lp즅+!CD-"˯gGP$qm摕e:PDusu~a: VocÈ @gp4@a0vr2utzooDrive& t@$RUSURIOB|G@ESTRE_ FSC%ɑ7q<Vapaz:@I. AaN4P@9de-`ФrMisPJEB>p"}@. NNv p[֣,'6Ve ,V`(_K` 0+bu:*Ƥa !Ed!e]D.Hf ``7/{s1!Bi屧O7T>WDIAV
l`9`w9o  sumǛEf`lo,al Af CaFa_erf
a`uuzo T :aq(40  Àoqur<ǵx@FkgڲU
 yaf0T y 2y, p;) F `3Bor nal|p`a-t
A^ tEsubtud C{ ?@* hR)ppa۵ptA-lVJ /qrWL !8Z  LemGbre ՚vqMac`Pasap8
"quiP_se`R ESC]ŉ9Šq3lav'f'rF10. r`r:BMrʷTAc]D ugus Op1k: MultibKayQYNc`i#si reAFpBa baФcopld(`RP di!tzB	qRc"zipcPrimeir"rc QtӂTO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMox#aGPadrcBiQTaP=hBmemsO@PS	sem@ fupw?@{PecCA#Ra lm|@ WLAN)`@"&BloothkAAnP(a/ E omCeonerga ΀erec*agRC/+11x2e,12o-0su0Ȱ0Et#netg	O`p
/*3/CToken Ring OObo`IdfPb 3abraqT USt`IsSsڼC!bGPd_pNtgemNS sTlCAtr O"XDuplo&	ted/	)	E /	gONOOHO'as7Aj O/	kC/	cIAl0 OO/	Ojp{AMEU/	/	-/	G9Dс1	/	/	/	O6[ Et 1:rreg2. 0% Q]Oc3l 2:Acv0N3:@M* d
 o9ayCJm*O"(sDfOlex`QScp دrydap Y!畀i Popup> Exb@ ~ F12(? dQZs Vara֤a N u`Ti k yktukP  <F1?=Ohje>JrjذtQt Nytt v0`tu kP Tallenna levykkee dk@on oP2u VtF?DFo0ej'unsW Oh ا muA 0lopQ4Lr  t
tPt7f,Tpo uaurlisuinvojoan s saMrit^oKynqyptk LaItyl	
 P ~usnume
o$f-
t lykpiu '
,(moPnu kiG/@!(et  eP.4tQ3AΆsb5*tehd 7&oG"@t!B$jڪ;A)ma*in@#TykaluA: o@K < Ki 3vyt?05Oa9@@FDMuNk!  aR6npC:m -GdHLisieli O Ik aec  harll @1Q0= 22R2#2h%J7atkainjot  npp0]=d, ESC=PerF=Hyvksy=KyllEi cM, JokuAL=TY_ fnuoli
mIip_k`ah$@
sics"N <ENTER> -mB@t
ep+1.!I`Kgn C/ss seurgaavU: ->Xi VLINPPIN =P[s  <-bASKELPALAUTEd0fb1!9ARKA+! hV?AIHTO+', F2@
)_}= d@!;0virhvAkkua e =oi>da.>: Rvdig 01*ka c1s} apHrt2Pl pU@eygtke`"6ko0>@	siP\Qlaks1qиrsRW` karCt qlaaP^ TikkI)>skeytyi 
Fn
i(pOE2nL^o2h(PecaGmA|ja|}1?i@d ty'ypp iIn :!ډapllVlisQ (L1/L2ࠅU  ROM-Sbmkoh	tuotepe")sar {W]`si ?stohjab T;{L	!1:"#2o L3o`M4m魠JF`LtaQon7(j \oa) 



\	\JEkA'ra- DqA(CuP$#:D$ P9a%dzb~ lpi!iEepo3i Walking 0 -[1Yloso`Vaihtoe@ :uvi7 us: Tm󵐅@atpnhp . J|lt luop2us-  n,pirj1onc !K A: L"X HAYhku VV3beFAG8p_Cpa@ ᣾
gHkoa]Wi a`n? `O  HP?ͨ,i`%#(N92R`3.M.A.oR.T.@Arp$ [࿀n (mi?n): 30-%gs p2y0%cLx dv0 Ispysi- $4iVgR
{fb%untq'c{K)jServ?omoottj
Lu!5ÂvtuQ	k@Ftt7ribti2`ЗŽy@a T6eqKxe nGG9w UyueVahvu  x P>2Ȕ	! PC }A"+2`s@a	,-ãPAJ頴n4-okkpDad`5an! /)inDP -e@7p$Rmysba
$`k 1h@B` ЁeT@	dE	ZPEY/ i0Xj [.!K unQnwby:p\veapahtum0"b@^id FLaJ4>tii l̾ <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa3 hlu 5qf,V "@PraZ&q-Q,:*sekm #o$j$it)˄a{d||}yh' PP`0#UC1.7>uut	SApor_ InfrPnR% CD- -!fl ~QԌV"s łPANjUWAiot;"nn De""(1o")Jlla.    KYTTJNI9! PSSANAN,0IBfw.la"q >%sily1Mgcur R7qg  gri^PfaZꀝt]r
f$VV-$`$U,App  iwLLAQ0<ѨWZ& OAMA  Qops ) V suE=h:d,#tu@> x	_4`o'lɂ N
E  U7lE r
pRw%ytC. Nyky3b`+mPezsv6Ar
t  N. TmttS`|q$ihveip=upcerRU$<eh?  IPa*?-@l@wp[btЋHta1U(]=c zAojAaiemlfV|tp. Anm "P$PtTV@U G.2!`ZX2qїaF_Qy#А e@krm@o#\@Xd,aT>0ESC-n"sR;n,%'e'> F10 ŴY4aaqw:	o .cVQ ll0QݠtmiA$Ɣys u"bn MultiBa@Opc&Jlakoiu (enA/$o}iP) USB$@)ZipEnsimam AKoelj }Vi@}Kieit@Ka0k 9Y Kymὁai Fn/Ctrl"mhAΠEng(USA@UsPs#inla!ǁ@B-RsఠS Rn1 jPBsQi PPs VOolh̙t>\Vakio0	s2sNb#Igmk uuqJ@Fn verkko 
WLAN-uroGBluXWoth @/hG`h`sdV`Ss s;l``搳-1i ?Y02--)- (ylos,OG@CO7Etherp(p3E Yoeo3o:To
` %gOoHB workQ#%GJQliv!S AkkQuT < TaJ	5`Pӿ rjoolibr`fu bd w3ual`-OO O@I OKBmb_ OO O  OntO$ O$O$vva_ O$  O1 OMaanusBk 0"OD OOOMB OOOO
OI[ e`i:r
ada n y. % ]  ODPW21l@urPP &OE-O
3
fGoMOH*  j  L9@&ЮBk@QvucP` ˰iȰ  (se  nA@sy: F12:ʴi`P%3tappi1koskeppp 'mma K  Ei mn Configurati3ordpteur  <F1=A> Fichier Infoar m Aff age Sauvegarder su?r disqdc R`a*r /'une.Hh_DHeals dfaupow du'Igno%mod1i Tqu1 S$e l'inp$@0`reg om	\ ScuOrita%
e ssLdS"#j@e sous te0 Ion.D
 priphP %J	a s0E IDyi'As
Dr`<Lockq
Smp(C0 Br13r3  'h9eP5  1
b#a <ۂgre taR,9)+5p7am''us3;),;rfrencMi =``t"#Ou@[< !@lonnLb`beriZ slecqSnE@psQs AIATA BFoV,mmoir`hcBDX C0ZZaFXB_V A0c`oLang4 ChoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppsuyDfatouq#po@gezu@l v=Ser, ECHAP=AlHAccep S0=OKuiuN*#Q3V, N'impp_e``D
=0aNw  UPzin3
s f'heM
mo!04ecl{e hmenuucer@r0wbrAi2qh@z!y <ENTREE>2nj+W	ss	sui@/ffa  !/ :-> ou BARRE ESPACE = PBe`-$IEpreceqd@STAB`CA*'MAJ+ix F2=1 p"w-$!S( rr`@P<TJ Il FA%ss#ibcQ7L U cs'Jprod{endxp#B$P. Coa<-'401c5CntP@-1 emplace(L' D SaQre@}C'y
GJ 
s}^ccueil dн# "4 itaxsmo#bia``
W 
u@` B!OOOF2BfCX+)a ru Fa0;cq0M<\ Typ0
osBVpwgDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numro#p	Rsev`cdo serS2ItrQclavpoLA}ud@;n+/Zp/zr3/t4n"3inv!/Qzi&5 #priтF!L( Ute)OOoOOOBV'edA Eo YMT֍ :$/t.   %6Er4 !SUPc;Walking 0t81lig''ad`auZC	od  al0ifAtip1SC[a=re@ptruA ieЪvPR! /簹r,  z{ nro°Ac	cY0]A}
jDL_v
 tro Pa
s
TX	  _[Rvja"`dH.On m:YfPS 0"Ӏ1f   +-vahPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (c]oet)u`값|pimA(z) B30堿ss pAU0% n#v$D9ʈl'hA+bF  `:˗	AhsGinpnud'+,`v`t
$.Lu( HpG3p 5A`ib!O: IDP00@"s S.M.A.R.TAbcanG2WpW AIx NBY`se N!=apYeAÐ?/@;sa#A Mar uinKS;A, eecoac	;mme, vK*ad11P6OobPbatCs	eSd4D	΋ pe>a1a`(`ih sL4[,p@s  `Ug"?  formQg-Ahq#xѼsJ
.)rmQފb	hJU0`
1HAJ.6zT"`QDP~aR avoupR!AfrCw w7A^	 	zYR`($p"}ffQfd  k;l2ӄTcgNq`rHP P`o Tool:eRy MaJr O4K8CF!/  QuickLockUsusA|`$cp!ri 9d س<S&ol'S+,C)re!cB !
`K)!nk:,   v qi4//  / LA'(a'a
S$ud!rv
 KP
dra+D hn 4`ExiAudP `  4r1aQ8llƙxۗX CD-'EǞVpalJX
¡:!5pr5Sfe DriveA). SS@@@Adez deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z?I`! @~`E"Q!qhsr @+lfe</"celu&M<sDordi`Bb. AW 	z(@oDNU(Co cn U@fet#qxI+}MH"+t"~"asW"qmoeP:! :""t qD)<Z=Ianiq4 5#'Oǅ#!2/7r,"c̓X!pk!  3P@ߍIX!! ܐ!!{e ZQM7pj]%uelП 21`̰܂TC :H,g" "$"o }a8k E
O' fW'!b_^w# ,d'oroiginIl2!v`O"2CwIa B	u
vqSaPAQy9)Pt0M`
5Odjabvp!s{s`Pze*-$݁WQa0prs 0`Ta a?on: top@TP 2a344Z0pab0yt3ץk'
1uj, appuy
`  ECHAP. @@ OTzR'o', 'pui`CrDF10 Tap Xc1xCx Y^u}	U:/QFrana
OgvACJiMultiBayulBphA 1!3D,xsoca%(ga)OOFRz) U[8V USBfQr
jZiprP: EDhi@s QuaQCin`NSixi sSe ߑ  Hud^ NeuvCD`^Perm/r(s Fn/Ctrl`s AnglpSA) P$opm1`s A@stanlPhnROd'fad`n el!ɯtrl3' Ui3ch1uer&mr`
*d :i@7idoAѫa˭Bid`Ԃ 0 mm*0 VlA1jFcLal ږó R 
o>sil WLAN (rsei{l)!
gr`Blooth73/?1 K ;o@" qg@O loc :G @aXoXo.B71AbP-no92ooyPu:3ccu@kod`ogB EP"t!# 1A#23TokRingo`oU/Id!u47*aohAY  /     h ll@ nIre/ x Ab!D.f*Du Pi*/) ///tb/ ////* *-//8/Jogn$ , /,/ /ce Ís` Btkexsqbmo P//7// /,///7[qRpe 1 : Char. % ]!. 2D@ Gic(M*n3@	Rpkio.
* T  @@/M.@$oOAGabAmorcFE5 Retard"ŎTexp@) DA  Fs12tposf;iP+!ġux/  PatQBAKWucun Ip z!Nl <F1=Aui>`nfo\gqema	lp'Salval floppy%`A0ttoRipr>0ina dmThi`fAaP`i |Ignor`daed esci EP a
l'iI?z`ciBPŷtupicz{za sswo!%e am C0rato gPccsP
_QC*vos7v`% IDs
Ҥ&gDriveLock	LPr`ǃ)St C7 SupP; c30 g@H1g/ o+:,i fabbrP
4=i	/.nzi[lOco
ruWi Cb5<b!ae9E`lrOpa@t2;o rigidAEtaA'V<â,a mepT W`<HKJhMiM;A>op !Ava=t Lu!O l$Dim"& q6ca X sso eviQ 1g	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu ,aA Etpoe.o=SiSN1T,altro#	=A bj Us"Schiav~I frecc'!i1`voc<u ap`=f"_`<INVIO>  \kZ\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCEĭ`c<ؽTAB@C%o"M?AIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"ViO  v@u4T|XJ. C{'01 Npu0F>9|a0 Doggiao Lk`IP'0  Q>re0
z4Es"@agga%FvpSAcғ { npabook"RQzespa jT:\ Zf.atp1_
2o{briuPrf udauA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1G/L2 d&dDbROMIamig	lk N@o0H`(D	RP[3[oi<#qSroll TsjrAer ~$i1OFk2m	3n4ࡐ7@w PVSTe)(DE(d)H8
	2
3
4摭<Fonda
 ,o:EV$ THr%OupyP!gTŒ@lliASprB:bit 90t 1ИRindirip	i] `|@'F:AЎso:5X%? gger  `|vpAhAre!0M/rѧ, `1favi PP`1iVYXA:'mYU[A:"m]aconouAðh(_ IIpSɁQrita]+ Nsv@dpRlIQOayളSe3 `voPga	 ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio (>): 30>0%Q5"r6car0䠈'hPD5|:s* Щ-@
˱ ֤(aD୆%aerv|")LċAPLA'	nrib i0gol: ID0$Ban`de@z قi S.M.A.R.T.!ޱuT0U _wordc(nuo!i2 pDsc(Ui%L$?bq+d`ᗑ {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YECr	t>J2fum y3CePe<B #u" _t0s!1a哰.Q]ՒbdFo!erdPКatiwEff+Jizso~@in  ca2i vEvPgaζOdesХ@J m9Yy HP tectTools Od.ZRV2+ ickLockspen`3B05EY mou`s8 MM d?#<#,p  gra@p'!oe  -!e$C-))0v!pKsm@]0x$!! b	,'UvRar i lі@NR(@| ГV|a infraQ)p y)o CD-" Se$D(FVp:W< !SRQ#3ę^wusanD e1&. D6AF<P @@b}W'UTENTEPRINCIPALE  r@*a man4fu`o. AnPV :FcP0rо a!e QB<p0b:0.l@d0Au ULTkZs,^h	Q[m2H sb0R; 3reDV\b.ALN =	 Q_o0%54 dE h=>`@
 >re,0@q  d (`8t rOD r luogo @DF T!B'     #h$ f@ER#:,!vE</s I"I@5-"̿WpHClv {s"k mP0!R/DaB  /$BH@ xQE~a(  ٰa~DA'a( gQ#}QAi  	Pktat{fa+ ueY/c dO::ly&.2nPq!u_{9㐓!.Y)qA`YEsnOP@K1'56h,mP邆эo ESCƚM'Ý)dovQrְ 'n'pom!nF10.  !n!kK WyĴ_6\%גt qIP(i 3 # OA:D0b@ $d5m MiBay baN1.ggas$Z) ogCh>i USB]L$SukbC
ZipBP6ox ;Terz P`OЁv@N% ec AН" Fn/Ctrl TIngl  (U'SA) Yi u`2O mpl 01aЃ0R7pl Aaп 0̰Mo@eQנ Bid0HCapa memqX5em$bs"FlD Q2'c/wNPs (WLAN){oBluetoothCommu5/ (j)@sm energZphTp1$0&1 N*J'2HB*Ca26*(0@o)olz,sp Eth0SetW V123e Token RingOE3 I ahbyC@B@taI   aAov  CP/Ab// TDz S^oo  YHiPDuPT  / o  6 / @o ,o // ooba c   / o 0uY\mo9 S//-oo ooų///oo[{ PAs 1 : 
ro . @% ]ocomQp#2S '4,n6E3`
ij* 
 @/JoXaX/3i'o
   FloppybUBAİIAd c`Ƭ@~(sec.)C velP`F12b 2z8@amb`Nu up <F1=Hjlp>@rkiv Sya|infEot 0s~ S pkt%kigu 葐@1( stll frnl1n@ard Annuaa nd` ochFsl  anȑ Sker0 dPRtrslpD  K!aOB@rt-OaEn ss	(b -ID
S ao
h`tPd-Std frutQ !av 7K
byggd 
 usBi=*abrikP+ |.J
sbeh \#DEsktsrktyg Km +r vڐ S`;vtܱ0HDD Ak_V Minnes: $01 q5`?@An'@#B
Q  VljrD;cBnedt
tlD!v(C-j+eTryQI fri Dg@q nr du viJPsӄt0x X=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil	c	/pCa ҐyEt
<RETUR> om6
YRtt .Zie,lj`SeerI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG F?regey܊K TABf#OKIFT+`H& F2`0+?z= 'fO @%Aoi?Cf{el 3t gqL` kA@t Ah+AO` D?stod uGen. Felk0197 AsgF{P|plat  NtPhm krv3?A @pbygm0 wfly5s t6 -dator/r ex$(|0Ytid#igooi2-@Kkl`TA UkN4,  Pr Pr, ty=p
hast^hZg0Ca-	rlek (L1/L2)Yd ROM,tum ~ familj~renummn0D^deo,`r!Y ttNb ~pqyrQ!]H 1.z2#3$4rbinvp ˦3 (bZ)g	1[
p

Sek#	 xIrq.ْ4$@gaxr#%8Ex!z=ok!ŰvidClmissl l.s Walk0s - ~P f1jHހ Add0s Sli7Ae ݺnVar! D@/ѹ  7neh g"CcuskaUpay /G-tH!ڱxiƱ=k ab!h$2AA:1R K>#Rhi{wIBB?skyddadag

  ބ Eˎ҇A!^Ԉ  ȅ|? ig?D܇jGa- 1nGabb8f@Rn`X9UWk`ad k$pQd (0): 30@npan 2?0%bX A4Pp/]spp01vr katPo:,t	!قOk%S(x ervo-L zB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 OGammN u\7 ifin`@ D> L܀Q R4d% pm}vlika m0Ǆ  'InE?kan orsa @3iЈ P9aHSsNypPO@Om=<s1A61lo. 'N_a om hߏglmabtj@Deh ;elCse- @^uQDuayVq΀Φ >fun 0`perl^7!i HP tectTools%٩R-6-Quicka"q`telge Lp׌mxPs Hg$k
gppb*_- &q2@&!џ!!r ngo"pKF5b#li`X!aot. Kж7AoimpHi p@J1f   Pk`anCD- pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsd D`}e. .Ч#`}a]r ANVSHUVUD!`{@Pmaq+t W.[  !q>`KՠρQ@ild fr 0!+A
 GOha0w L l1փ'lGSWN.X (oF XAd/bbygg05P0 g`2//b/dY5- F`bW:omC eB
7(b!>=  >Dq8asB1GcpgCZ@ktu0ai`Qaf%anpkp@.Fut!L#\#tg`Rsp] Vo,sursprung_cJXJ. Vi  reko@ t2F	B}c	Vrй`+,ps`_b@}. A`K4ɡȤ˄3w_Bg  &Ӄg `!(g}AyO-beflse qm ihђflj1ens. Trp  >ESC-QBSR Vw#`'Z'R-sedMtaGF10@cVi3a:+dD1}shxE ASve aq 1: N?, MiBayCrut@!}oppBP5vi Ba L0G (Pr̞ (h aSB G Zip-=PW As1Fj!Б1 utKto NT VxPFn-/Ctrle  E@ls(USAbmYkd` !AA b`nrmstrorx+,f hbbelorlekhPeo2n?e Flkp@aLPaIfڒEsio"trqtK (WLAN)Bluetooth p/() -v@ANѾmbe Agg2гs`haE%-21,2v[,pp$Ned Eth)& 0	3n To!|RQN "Unik '$<QiD K >@tus   ,   S"bo Kalibo  dp{  F:Dual Q.O
o 

  
9
Fo@ 
E 
D0!j1s
Aoo
E
Htag *o 
P* 
VCy emol]A*5oo e
DIO OKood
D?[Ne _ :w Lapr . 0% ]
kWlar2u j253omFjOFA* &V@1  >I*O!DgOߧ̀U«br@>4sadap@$lg rdrjQsnabb0 (sek. F1 Bd S'tyrPguen!he( 0ae/ `P}Op e@slaan Conf'iguPpoanafpvt ardQ3!/  scy	WijzigS%ne@" programma @٠0Setup  zr w ؃Ȃsvei !Behee rswachtwoo1څ
 p$X. Ap OaatbOgl>$$ ID's 	Smb4CP p OaBu3P$PcR%mj+%O
Ge0g3 gssvzie2؏"Fabriek9s.Cugz7/);Vref|.s:nieuwBأ8ONc  E{xtAccuwB ZeN geselec Ea  es  zelftGa -schijfueai`Act PPXvG0u ?1I R!a/H 4UBgDAcg@7n ,DP=%_
 w 9aKc!: alaa1l =r/em 	rijsgemaak el;o" /;9
8ukAZ ]0ayMLg]@f=S, ESC=Annul"EDXG0=!emJacNee} fslui@Q, AQ-f`=MxNHulp?pijltjk~p`gebrui:0d )jui~Pw?nukeuzk@ark^<ENTER> ind 0
cr]beZo !vol%@@1  0aiX:  -> of SPATIEBALK =><-ޑBACKCE>Vorigl)TABb	#EHIFT+%%ܺa2+Kq= yk p=t#B~fouta64k p It w_ge15 F0M0r]eqatijasFoen. AcoZ01b`a0.il1ZCu  we   Netvoe are0#FMPNp diVbas`e3
 t n0 notebook-pc/RP @.istNOQbep*igdooh2 L	MЛaft NmpALyp6rocessnel3Q spp OmPЂP}e (L1/L2`Zapac?i VHaRWOM @ -s!fS<mm E  Hebvrgav_0ideok p&p;b bpM	m	ra1$b2rd3e14ahisJgI t}.jnAe C(_B(Љ,wMdzQ%) 
 `D#SecuibE. aw~~$Ft҈%)B2!dHUQ2L583Hac-0-*1Tho_a_dresrl|afwis_nd paoz=LTop: zbPt<ts e'ge t PLSBbeЉf ڇ s d1 A:og-  / ޖ"x0zbLe6`NoffaG1Y\f_dقڑD`ѱ

boචgAt
wOC'We nu duъ"
wil?oݩ(""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30 aee&p:L;0%Qtoo `4;q{ho:5broA):]eeqx/nb!$32#kvo-IPs EI"
2`"qk:J S.M.A.R.T.-af@APP@udh "/tBlo0!  A  I-7B4kXqcr lpSX8
 Vr!a1& is bBs AYoCf#Z/k, Tm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$% uswb sqwYfur9hou
d'Hi`!  AQ`R`T`R&BеѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gsppL`b TWm E #M"g$rgΠ9bl   ~erX#W>,.o(h( o( S("7p'EAJb"f k otraakP)5w# sXbtK;?ݳ ]Qŉr p1׀frap=d  Parxˊ Cd-r 7HN񸆆H/oofd8UGr@JD  UQ0w`fbia D1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  p"an< SSC#  hbwACI t fykgcompS$ajsLQ}ZP$t d 0Bb&qӜ. @XPpQ~^zAutompJc49	yT `r:ZcY <<|7t7 O!V)?!9NP sNz! !. MoWdLioNTC,p@  #iRS8pò̀QU nt @@Odq K/ # `hui,50d@wұwas to/!k wgeaГ. PWVAnvloeC~XkhWSs0n @Pܩ׍zYUTr!ra=8	24 torH/)К Bget. /o
 s  xvBn. Om2un
1]ѝA&`3fe*& gol q. A ܹ_ӱ_,cdtabҔh! Dcㅻp3ruk3!ESC-  (A9н02i Rb5'k'tyUb;kn F10@`T*Z@lusTB r`V4  NEeplg g MultiBayjVzkd@\base (ks)re|  USB-Մ cb+zp- ER weH瑟V V@{.Zes >Z>Aa8NFn/Ctrl `Owiss/@ާ`\SStaMcW~3MijsappbOU e 0	 nгqlBij 
V o-1PFA/A뜂0d`dition  G`vgp<uqĦntilat ?p neqWdr%  Radio	k W/LAN-Caoe_Bluet`	h
/o DHArgieP YJL%\-(b)0܏$aEt0 1
2
3,!gTo1{R/ -OMom@023 UpV0sat60!cuG< 4us     Sca~Gekali@!QOK"2
Nceual Q\JOOCO EeXOOO T\BQ\'O0OO HP|paӣ
O$O"Lier-MUE-$J$O C$PQo+OpO+O  [jp 1 : B1o`Q. 0% ]/& p[Pd2knte ~l/{	3	 
fohl/)b* Jt  ;>.C,$B摗 ֑DCa $Xadap Ɯp0(sec.)pop-up bij snoc 0F12i )Kbb cursorytuyEasyP}o0-muisGQ Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR af=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ex]  e= >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"`OM οOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 䠇sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPu CD-pu$(3H\@}@^ 7Q: axUKߑ #iC^"c. t%``y 
x7"	3@9>+ VAT:!eN,Bi	.	i	 A!!F	͎2R qĐR`s~񽂩痣HSCۊ"o"F`pAF/'@Aefw`6W 1E<r@߰ XPۏ؊ԓ "łbͯL |ił`Ȩk)/)%)!?ƈ UX3oNu@"*fBBFa(`o(e|~!@#$'m8`X ( IO)F)u
 ((?(9(.㜨gDsЯ}Dv#<43ɑqƈ	{MS f=e|^`Fa)F1j 8fcB  BgB<b{aȑOB%
O#&@H2ef̯ "8먎ߨql`Ӕ5C aU$/g'"wEE[Egsc]1 쉟`}ȍ~elaӫ`m⛡TN?DriveLock ߤt['F10at MS   y_97`E!O: ESxtkGb`ÓO xXioiEcUSB Xp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ `{`\p (USA) `Ӄ|*B#fo+X
KAV&Ws
v C\g @}ZJ@_ rIso`̢ Wo% тACY%@Oڑ͏ͧbrl1BNi!LANjEMeBluetGoot/cjA|0`ߓd  RIntel  Execution Disable.`--1+2*--odhEthernetMX 123 g! 0p
AOKO3O ?H!O Ej' WID 5bM aN  !    ?a`f`S?k ej\ o  \(%*nP/h/!p!!MEU 5u$) o3{oooD2t!5bv1 : [d . 0% ]xO<
2 !gOv3	Ā	)J*   5`$>s'pmj AMD vPowerNow!@ technologyPt'" 	_ħް  # pPx?(b) 3F12Qibxf a ^`Pb(ZB   d                                                                                                                                                                                                                                                           ` a b c d e f gtH 
M  ܍    ̑   &  	 
      
         b    T    d             l   D  / 0 Z  3 4  5 6   ( ) `  , - B  * + 4  mp
 N % @.   mm8m$mX+m1mx8`?mEm(LmRmHWYm `@E<BB<U> Fب﨨E0`?8l v x|kv||p0p7|c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o u  y $n%Ap E%  IC&O p   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$~: |  sډ+'()+'* &8F3&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      p]^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 3e idmbmcmffmhmu@A@2 gm@W{X,t|dU Zt}[}#LW  ]~&  W_t`$itVZa!
	$
< 	U^ 
y`	l
\ U`
f`
&aUbcDdeDfPh(>|{&`m@ UH r  @嘀
 {j( 
( 
r Kl0 |n o : u*R  ;	 hb b 9 D VF10 Setup Image_SETUP  P0Sq  ; D	dP" I*v@Jä"IP$ a|`պ 6
P&$`ԩC ؄ ٪TԫTԠ*<Rg!"$Dcz: 'ᴳ4㪴4崵dRՠD8b_ : (m
6W  ($))U$**$++U$,,$--W9 -gW  0	`
9 
E#8Ui3jG@ Ƕ#!" #" #" 
8 RMNPNOO 8 @
:	 
@      /	&Wc  b" :   %u    R'U'!(( )US)T*U*V+UW+X,Y,Z-[-\.3V
Wmd-dh.hU1dii2dj3jU6dk;kdlMlU]dm@mGdnHnUNdoIJdpKpLdq5 ajmUfoq$HrHs $[z {{l`{v|j`|`|`|| }{`}~}* `~tuK wxU~z{  }t kv 
444(3)]Bx`o2您T$\` U䇧0L'\t ;*
敇d @9 ڠGxTna%
MUP@ Z ` t U@ _
M@ > UV x @մ @ W
M@ , F UR h@|} N 
Mʀ 
MU6@ P p  U@ }@
M*@ UJ ^  @U @
MU&@ @ X r U@ @
MU8@ \ h  լ@ʀW
M0@ R d Ն @
	T@ T x  @ 

M@ $ 8 L X@bn @ @
M(@ @ T l @ @
M@ > ^ ~ @J
@ ^ U~  @ހ1A@ UH ` t @U @_
M@ : U\ | @5 @ F Z x@ Ԁ@
M"@ 2 J ^ @ @@ < R f @ʪ @@    $ (@,4N f@Ě @" -@ b   @
M.@ X ~  @ƀj @ ,@ X   ئ@
*@ 2 @ N \@dp| @j @6@ L v  @
MB@ \   V@@ n ՜@ʀT8@ d   M@7@ X U  @C@   j @@,@  . D X@v @ ܪ@ @8@   , 6@>D^ r@ @ @֪ @ @>@  * " *@0KUP l@U @S!@ @ N ` Ux @5 @"@I@ U> b  @M܀
#.@ Z Ո  @$T &@ V   M@% Q@ R U  @S&&;@ f | U @Ҁ'CC4 F X* h@zA2U@ @(T a@    $ U(@,04 ALNRV Z@pv ai @ RA)b@ b  5 @*^@ UN d z @ղ +TJ@ , @ b Ux@ M@&, Z@ t 5  - e@ U @ X ~@U @S .$@  " U: J@hxՖ @ /T H@ 2 \ j p@0Tt@ L   M@ 1f@  jA	 @,2yj@   3 {J@ ~  @Uƀ @S4 L@ @ R U^ t@5 @5z@ U. B Z t@U @M6@ , iiiiA8Zp @ @U7"> `  5@؀8j@ 6 T r %j 9@ N d ~ j : T@ i* R @՘ ;T~@ : P d U@ S<@@ 2 > UH L@PTUZ d@5 @= @ ~   
>T _@    M@ ?@q@ N ix@̦ @ @ p    A @ 0R H i\@tU @ĀM B@ H Uh  @SC@ f  5 @&D @ Ք   0E@@    FT@ h   M@2G@  M H@ ^ 5   I@ 2 Z  i @RJ@ J ^ Un |@U @U @U @ڀM K @ P %X b 
ip@i	ii@ @  IL@ J 	ili@M @ h   @N@ nj   Oj@   Pj@   Q @    BR >@   6S@   T @ T  j @UCCUB T d t@QiA2@؀-Vi iiHDiih@zi@ʈ @ؚ @W @ J \  @̚X@ 2 X p @ @IY@@ @ f U@ SZ@@ P x U @M [@ N r | @Ґ @ \@ Z t  @j @]@ l |  Κ@^ @ Z   @榀_@@ f *  @(`2 B V f@* @ƀ Sa@@ 8 N Ud z@U @ڀSb@@ * < iiiAJl @* @Ҧ"c@ `   @܀Fd@ %Z Ur @ e* 6 D T@Uh @5 f@ < L \@r @ꦀg@  T i@ *UF j@M h @ h Ռ  @$i@ T x Ҥ@@jT@ > j  5@$k@@ IP ^ lUx @վ @lT@@ `   5@m'@ UJ |  @M*n@  5  o@R@ U\   @Sp@@ r  M q@ T U|  @Sr@@ \ ~ R҈@Ҝ @s*@ . < J V@^dl t@z @Ri@ƀ5 tw@ %. 8 
B ҉X` i~ @F$u@ 	N@j҆ @j v @ 2 H ^ j@8wj@   @x@  y@   z _@   {@S@   |@6@ |   @&}@ H ACUl ~@ A2~$@L@ H Z@i~DiҠ ҸȪ@ @M@ 0 R d @ @ b l  @̚ 
@>@ H Z  @j  @ H p  R@րi @S 
@ V t U @ @Tm@ D h  U@ M@
_@ 2 UP j @5 7@ Z   i @&@ hJ   iU@ ( 6* J b@xiU@ 5@ R@ UB Z p @U @i@@ i@iiA.@UJ`n @U  # a@ ^   @di %9@ H ^  @  I@ 0 i>@UZ @U @S@@ < X U @Ji΀@ji  M@ Z z  ֦@ d@ V   @ @ R h  @ @&@@ ~   @Fx@ ( : L@i`n ~@ *@~@  j  @  P@ Z   ަ@@ \   @6@ v  Κ @*@ j   @ \   ̚@
@ 2 @ T p@ @&  iA$ ii4@LR `@ri
Ҧ$Ҿ@ id		*@ h z  լ 
T@Q@ J h  դ@ĀT @ P v  @@ j   &@    @@ z   1@ v   
o@ N d  @Zi4 D@d	i iiғi
"@i4R> iHh Ut@| 5@ @ Uh   @M"@ J Ur  @M @@ D n  ʚ @ Z   @֚@ P h  @j @@ @ T v @  @ B f t z@ (@@ ^   @ @ F j j @,*@    S@@ $ 8 UR l@U @S @ h  ը @T @ X ~  5@  @ H iiiA^| j@Ԁߪ@ X   @ @ 2 J | @К@ P r  @Z   U. > P@dUz @S@@ d ~ U  S@@ 8 J Uf r@z@8@ @@@ P   @ q@ z  Z @B Z Ҏʚ @u@ r   @I@@ & B UT@n լ@Ā*Tq@    S @ v  5 @ @ Uh   @S @ |  M  À@ P Ut  @S.v@   M @ R Uj  @ ƀ@ B f  @⚀
@ ( 0 8 @@HPV ^@fnv @ @&
@   
i0F P@^$ 
iz@҂A 5@@@ ^ 	҂֚ @ @ P t  @ˀ@ il  @T@ f   A@@  Ě  (΀@ j   @    ަ@ Ѐ@ 6 XR x@C @iA2M@
 @ J "^@iҊDiҦ  @T @  2 V Uj@ M@@@ X Ur  @5 @ UL f  @A@  V@ ^ | j @ @ > \ ~ @תi2 D R t@ V@i. H Z i~ @ـ@ 8 `  @ʚ @ N r  @ꦀ @ n   i @܀.@ D X d t@ @݀@ D b  @Ȁ@;@ ^   @iiiҨ؀p@ L f | @  @ N j  @ƀ @ ^ T A%@ @ ( B Z l@ @@C@ H v  @ƀ2@ N d r ~@ @j @ު@ b ~  ֦@@ b   @2 B ij @榀 @ x   @Li@ B UX b p@5 @@ Uj   @S$@@ v  M @^@ n ՜  @TJ@ N x  5@,@ Ն   $T#@ x   SN@ \   @i @^@ B n  iiR @i i @Vi ( U6 V@n @
Ҳ i @@ D z*  @S@ J v U @ڀS l@ f  ը @8 d  ʚ@.@@ j   @N@    <@ v  Ц g@ Z z  @ڀF @ ACV Uj @A2i E& iXDip@ivi @ j@Ԁ @ 8 L l ~@ @ J h  @ @ B ^R p Җ_  ] @ H U` | @Ȁ @W]>@ P x U @U @_](@ @ Ub | @U @_]<@ P Un  @ր}(]N@ Ux   @}
]D@ U~   @]& 2 D X@l @Ā ]@ < ` v @ @@@ 8 P h @ iiiiAU @_	]$@ > X v "j @ 
@ > Z ~ @%@侀 ]@ $ @ Z n @ ],@ H d  @ @
]J@ ` p ~ @ @Ҫ @@ r   @"@ j   @$"@ f@ zT Ҡ@M $ @  5  @+@ ( > L@h @ ]0@ Z  j @&@ `   ޾@]4@ ^   @].@ b   @]F@ x   , @    $@2@ ^*   @5 >@ U8 Z | @MnJ @UĀ @  T@7@  . : U@@Ph @ J @@&
i@D@ & KUV j@ iʀ"@ j   @@ V ~  @@@ N   @ B@   ! @    " /@   (# @@   ,$@F@   % H@ f   @Q&4tgF hX@hEhhzhA2:@Hh ҠiDi@'@O@ . >T aH@blUt @M ( c@ j ՜  @()T@d@ j   M@*@^@ D UR n @5 + f@ UP z  @}&,]L@ UT n  @؀-]U*@ V ^ f S  5@.[@ UX v  @Ԁ /T @    M@0 /@ b Ռ  @1T@f@ t   S2@@ v   3@u@ , @ X j@t @΀4 B@ P r  @Ѐ5]6@ Z ~*  @ʀi@iiAހM6 K@ B UV n @j" @7w@ n   Қ@"8@y@ |   @Q9e@  F n U @3J@:@ UJ b ~ @ ;T@ N z  U@ U@ M@<@^@ N Ւ  @=TO@ r   S>@   5 @"?@ t @Ҧ@ J@  Κ  A@-@ :R J `@rU Ӛ@5 6Bq@ Ք   *CT@    S(D Q@   M E@ | 5  Fj@ U`   @SG@}@ |  M (H @  5  In@ X   ij J @ f   T@ @MK@  U ( 2@<UD^ f@pU~ @ Li@֒@h&6
LJT Z@ M@ UL r @΀SN@ 4 P Ul @5 @O@ t   0P@   Q T@   RT@ ~   S0S @   ST@   5 @
U @ > ` ~ AC @ QV@ A2N Z %p@Ҝ@iҼDii @
W@ 5$ > ZUd @M
X@ R Un  @M
Y@ J Un  @5 Z@ U4 J j @ը [T@@ X b x U@ S \X@ b l Ut @5 @] @ UV r  @U @S^@@ l  ՞ @_T_@ X |  5@(`@ 5  
a@ Ux   @Uƀ @Sb @ 6 @ UN h@xվ @cT@ D b  բ@dT@ H \ p iiiiA @Ȁe @ > \  @
f@@ d r j @ڀg@R@ > n @U @
h  > TR d@iv U@ƀ S"i @ Z z Ք @ҀjT @ * : V U`@ht~ _$
M5 @k@@ UH v  @M.l@  5  m ѥ2 D vj @n@ x   )o@@ $ 4 UB@P^p U|@ M@*p@@  5  q@ Un   @S&r@   M s@ ~ 5  t @ Un   @S(u@@   Sv@i@ p  5 @w @ l z i @@`x 1@ : H N V@j\ b@jrx @ @Z
ey$@ 
i(iB ҩP
iz@* hTi @z@ B V j@ʚ @{@ D d  @ڀ|v
M@   }@   ~ @   2i@    jj@   -j@    "@ D j  @ȀACT@Y@ 2 F | TA2 @i
"Di:\/
Mf@zU  U@Ā S @ X z ՚ @T4@ * N ^ Uz@ @Ԁ2 R d @  F@ Z@! BR ^ @
M I@ 2 N ` ~@j \ ~
M r@ F j  j@ʀ4K@    $@@ b   @@ h> _
M U @My@ * U6 B Z@jUD @M @U@ 4 UP h @&Ab7@< iiiA A Ԛ >@ . H ^ t@T" @S\@ L X r @%2   l@ T  h  * @؀M |@ F Ub | @U @K@C T Ub z@΀P<2g
M "c@ f j  @ Ǫ@ Z   @i i& h@ ` n j @@ɪ@ N \ j zT  ъ @U @S@@ J l U @րS@@ H p ՜ @T@ p   M@ x@ \ Ո  @CB   @@ f j  @R@ < H V@Uj @Ԁ  nJ@XsW
M
 t  U@"*2 U:@R^f v@PK
MX@ 
M
Ҭ@i$ 
"@iiS @ b  I Ҵ @ S@ F d U @S @@ < Z Հ @&Ԁg@   Td@ z   S$y@   S@@ x  M "@  ն  @Tq@ : Z x AC b@iA2@.J@ B d nDiҐDiҰ U@Ā @P @}@ F `  @Ԛ,@ |   @Қ ;@ 6 P h @j @@ L t  @@ & H v @*}@ U8 H V z@U @M@@ L U\ ~ @5 
@@ UH p  @5ր$@ U^   @S @E@ l   @ @@ @ V j |@ @@ 6 N f ~@ @ L h*  @i@iiA5 @ U> \ z @" @@V@ R f J @ր% S@ L b U ʄ@
@@ : iN t@Қ @@@ @ R b @j @ת@ : D N RT@iVZ b@Հ T@@ V   M@ C@ z   @i8@ < J Z v@ @  j  @ T@ " 4 H@6`p @j  z@ |   @&@    ŀ}@ zj   @q@ X   @@     @ j   @@ z   V@ , Sr'@XvU @ U @؀U @S@@ j U. :@FXUr @ 
i@d
iR AP v@ ij  ԯ!
M8 X x @ @a@ X   @π@ b   @ @ J t  @覀@ \   @(@ l   @@@ ACUl z @D |iA2U
M% @i ii*i
iF@zV
Mv j^ vT@| @ն  T@@ F |  5@Ԁ@@ U` r  @ղ 
T@	@ . H  @A @ @ N j ~ @j @.ـ@ b p@    @ڀ@ F Z v @ޚ @ۀ@ $ J p ~@ j   @)@ R   ޚ@݀J@ P   @ a@ ( B L T@bnz @ @ʀ )@ * < N `@r @j @I @ iiiAU4@Lf U@ ""F n j @ *@ B r  %A%@%8 \ %|@ @@ 4 Z n @j @=@ F \ z @ ʪ@Ѐ j@@@ l   V@3: r 5 @ @ UF n  @ʀ 
T@ F t  M@ @~@ B R ` p@i @j @, Xj@   D@L4@ =  @ Պ   T@ r   @(@V j  @* >@ ABB @䦀@f@ j   @@ j   @֪.@I@ ` n U@ U@ U@΀ 5@ d@ U 0 J h@t
Ҍ HҲAȀ AR(@ l t  @ʀ
@@ F b ~ @@ F f j @ڀߪ@ `   @@ l j  @ @ x   @* @  j  @ A*@ 6 Z z ACU @eA2@rJ@ 0 R \Di|DiҘ U@ ~i$PnPm/  /      ƴ    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 < P Ap
P
0
 
@uG   PHK PWX @_` Pgh 	`opwx
  >	 0 U7 8?       @R   >   ׄP(Z0 0@P`p @@1fSfgfe_f[  Q	fY!PVfЀ!fXPSQR BIs# h2fP u	fXc  h IZY[Xgf&0/  a$f t
fwP
 =~p

u
f  sD
 f9/ 4 =/fÿ2fPSVfWf!A/g&D= $ <vD# D| u:t/f_^2Ő
DaD f%f
PI f5d
 `ݐ	\
ad
RfUQ<}Nt)} fP
  t/Gr/&0fXMYf]ZT3xt6g&T fq"6xSRfP  , t/t0YQ?>F/ B ATf"Q3fY tdJsuQtvaHvAs@f7fKq tO#Q;BBSi"$>J-fvFf=f AtsfAffXZ6QVfq@t/QANAf31pFtݏ| A?uQ{  5u
u8f u:fTQks]>p fX 8=0< &'TR1SgI	SBQRVW4
fqbt:33?3@
d\tfTuBދ3_^ZYpKQV3Ҡ00 0@' :0t{ffKfvfg&_Y$Њ?g&kffߋf2A&
X+/rg&qtu2^Ssf% f
 SO5R[Y0Z=kp!H9?p!}u<3(*qx
  r 6?V# R]f%fd ]]S*?fE] .nz4Fbf_
. ' qJff7
/*0IL(p<*!J=(J4)dV+frfo3fZC|
As7pg h=d)/( PQ  ]ߎi|_WfpwfQA߃t@hXf3f+!e| tf̀s9LtfBf f2|+ɔB
} t+fCs,_]zbHt2HfQtCI$A&gQw! frwf߃Frf9ODu[}sQ ttR@ 
>E ePw0Vw"S#7f$nS/n! s _gr@xnSWP@%fX[d
fGD/ 	0xO5L5b`PfQuΰtu@D/fYI
s|@:
O_9_f, "ls#< Ek 1f_'7ft#h<_EgRkQY&EGyu	E?"/V}mtKO tFk B] E/g&ƅDΰ .g&A	u 0 0!%!g SS2%e-2 Sh~Q 1 d(ødE b `ذX2[E@BQRB% ؐ	=Ѣ=Ab | BPDᣆQ B#ww H8 Qs*ІX/fjT؁ĖSf1<CEk[k"ix#\[sbd]` vƠ) ߳  P ! # $ELGGfߡfP% fAt
= ?(` @{x{!,eP|o$|^//$AVt.r}.<O7z^!fRfW<vPU!N0fP0Яfof wfGfsf]X߀ t@&v#s0^ 5oUQot3f3f;t \ ~ZgfE> Qfù1gf{P
gf)Ck{@"@]k{DAĠfO
`:	Ocv]6}
qgfe0A553#e2$%3V5B5 ^Oh>- f~`;u /Efۋ.` Xñ0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6T  	  !
M 	 ! #n#   ӀSa _ "2 r	 .>  B
   I/I/o      K  `-[Pi/&p/!4wrФ>iQ  X p > Z tp/l/l/>l/i/u I/ApPS9<pCrn/4nnnA/i/C/k/Q	`Pb4`
3ۊ؀`/&//3Uk/pVSp@t	[.@[^VE/H RФ..W}fШ_uqS1...o/[p2pfU2dي0S>/>0S&/Pt(
ߠF/ݢ1 G/.l[ވ
Wf]s wt>q/q/ r1.{w%0r.&E/;0AxSI/Չ   [h;bdh)}!F) `P	pst1.gh[/1r "0G]/P`/By@1= ƾ7p	;AK* }
 0G . [.g&&@v@ 'G1&s00{.> T3` ]Uu> V
WVu$uvatue&u^w\uMu:`8FPu)ttfpF= ILrXg&8Q	g&gFtF@sPVS¢z.^PRVj.WS^_z»˂.P@1 ZS/......".rt{.7W>8~K7/SRC<v
2 0,07/ʀ 7
/G!{BPr ])Kۢ7KES	.GV$$8/8/8/:7/w/..
O	c tG>Zȑ
	+/rg&Jt.}r Pdr!H".SKr
 JtIx !Ztĳ.=28o13
	ugPzaI7$0]oX]Zf,`]8`]7/_l4fUP'!= p#ӹ /f3f4͑ɇr/ff3 :0pdF E *  <Fu/3t	 Dt<Hut2o8tj8 Wސ2$u tPzXv?/ 1/ uB<Ft<Tt<et<t<t<Rw*<Ir&/
2ttv8>0uy8Mbqeurq#VWp御ބqAQ ft(PǴ:/u 
  gXfCYv 9~ w2/k|t&A/8r >tѠw
$_^ 9///2 ;/f? t<C<tSQ0ذ{&Y[pu
l}q.   5 `CyU/ހ  /bB0U0`op@`UP`B` 0pp0ЀS0	U				@ 
	 
	 
	
	PI@ fWQf BD=r̓Yf_f`D=ED=E:D$>E%
ĈDE&<Or%w %E@?fabob"<s""<$:EprMd@r;|= USBSu~|= t t

  q
`VE  F	 p ar@r  2`;%
i
{r``;3 ]R>Et r(It@QfSF fYimg@d3f5fgf^f? fCrꝡ;fPHf%OfDfXO#B#I#&B `a'(sFAWh6.("CC)g&D=# 11Wȼ?4#-T|0uyooZi(Z
2_(y
_7
V_=%2tT$RS$`E1\@ q F@Zs~@RP@f{ . h >u g&` T=
XS<(fʰ & vE
u&En 5tB	a8 f>EE f+` fǱi^Vu6 E +.@f.6@CW@:6QfPrrE U<C.B//',*QfPfazXPgfx`afXYrf epQ
>G:/
?sl`o^CDBD?le@S'l=p^1;Et t tED `ƈDcIQ| pr
rY蹖 y%tF܃Pt=T= t2:t+?:u_}Q(u~a*jrtd@=@t=t=`	t= h?ϟB+6`ofaE8dtd&"<	"< F8Dt_D$m&&<S`8tp 0 &#<[MP  	`@  O!OEE&  7  !# !uYpƁ  TTWUS8HdHOO@BCkCNHH UWRQSPVиrwa;t ur6ffWRfP0 e Xh㫚d)( PQ  fZf_ uF	0aPS pruEE` EEߊEpEUEEZ[XF f s` tcG  ^X[YZ_]e È-[EسQ pU`\E/ j0fdXAu!E! @uddfod  >P6pSd ddP (EEE/fU+徹:f]P:t,>@u%ttt t	tfN ltF X
r]@u`a;j,
ks
 1QK6uF .c$N
SfQVێeS tr`vـ?fP@wD`*f x׷fpxT fffXs "qy#upPLeb{` yuYf3ffeE-fWpe*&E8fw*fF*2t*܊e&E~^fY[1j0/}'~!(E YR0=  u荐G?vE>P  \OSQVWU&/ / i]_^Y[LS-120ZIP 250POSQRV:1:"7EĠÑ2PKp
#x
}~
5	EJs!h)e>e{rgjRc<tV< uWQEJfqQ v:uFfG(KRX!X  g0EAZY0_f`/u EQ/EEEwEE0\ xRW/ls} tEω/l_Z[M-Sys   DiskOnKey 1 #aB/ u @  f<x f_P 0 _K"B 2r@0wb1s? s~Ђ A~Q!f@fPuL	sTt6Xr)g&	ug&Qpg&C,f_ PAɊ rLTf<8(QRRVPeF5qome}
ǌ;p? t0hj4t@ u= u#P-{3RAf?LfHS N 
1fXuWײ?D0 @0B0UB0B0B0G05F6F 	  3FPRo{3W1>#>;!2>
_Yh7ĬPh`p& 4  h(< 6)̑ZPW+ 1s!$?
u$˄[V PC
0Pq  Hѕq
 I? @  PP ` @ pw πS 	U				@ 
	 
	 
		pP@ I@ Q fWQf㱾Yf_fD5 E6EEzsU0EtQD$&E
ĈD PQs fA	g&|5 Pgurr`{r  a`nP}}oQT`	e	_A~P 	u	`PfPoHf% fffDfX\~OE
܉ ~QsP QxQCb r`@4XW3		#~3rs˾poD=!W?_0"Dq@ 
TشZ(f
T=ʰPr\pu.?rDQfP{A.Tf.6
T~0gffffXYf\rv '_)
K!
y*/
a/
 
		D~	Tr 
/
"
#׹ H	/	s`v׹ =s0ctd h2̯Ue 7߁/:u2?@B(uq1rg=@t=t=`	t=`OxqoGfa&Q	Q$ ""Qp1P ` Q*I 0   0khOBdj@bd    D  ko @h 00O 3`Qo  
& oa %  	%
0`j#
clw
q 
3`@A{& <q` @t@ 
b
	 |F
?  "  d q	A? % D%@%
 +)3F	 
+@ (E+
3$ 4̂  C8$+(3+-E-(C -02 94- (`(E  E3 .c+! 0 
 @/9F. 7'GC@<6A6D
!:7 ' "J",A!E?9B@,3
O<bJ# 
8 S<R"G 3D%M TVaXaA8@8'(XAIc  vWI  @Bf  gf    P h5_gUg?f h6tt H h~6hl f0tf$ff= ufaH!'#/tfL|f`  sÁqy?rZ_e9f`b Q PQfWfVUUf*0UΡ h<!  'pG3.;^t3f^f_?YXhe& PPRV0" )h$h|O#  h9V^ZX
1

 
.02XBf`QYr;f.;`t3Uuf #fpf; f2Bgf0= v	 +v: f3`f́@  f`fP  6`Ã ;tL; Չ ǰǋ;Pt`} !.`fRfWf_fZf!)u0`b h)d)( PQ  Ñaקr99pDf2DfffROMIfMAGE;uq Wt@g"HMf3KPQJ 2fG ZYXuwag&G"IG cP2ɷhqLt"Q_tQR  t	V   Tu'fo t!!wp׹ @
G94 BGp?Gf{ fCfQr8fBR
D;@  Op1"Y1n,} p^ t V_.0b`Ra0
>t1faR ZcRU  cP&abpZ&&FdI< uKSREgtXr),uRG`SQr9wR'$8tm̋Y[tr$V簄O㰆HAr(QSFr(!sqtkrp@p{pq.^ ^0 fPSfQfW
pofepUgg& suf3Ɋfpp}Ttp=fY[fXPKVfW~CDg<t,fDxUgR rv8tfGO^fZPQE$@o{{@8tQZy!dUvPfF X PS5&fp f؎[XPS"5fga@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              -                        i ` "(    ɀ$ tT  a`' u B KSRP t@B u$Z[SfQWP @ Xgg_fY[f`Q
`cfgfafQRfWPSf3f3ɿ f <  P tf; X tDt [Xf_ZfYù@ fPffffX,fVfVf   E gf^! f^	VJ					y:		 	^		f	W		fWf	_
g&' f @f&f_fPSQWV!  tOtъ#%"A$%hfP u	fXc  h TnQ sY^_Y[fX>uzD?+f#f%2tE p  P <uh7f Q g $(f3f 	g&G4g&tCff&fft.fAf!A(  {u1  Հ hT+m	  a  2/0h(FLKa@$)#4rb2fP@'1$
RfՁ ;Z<
@2CL t0 hs!ο0>C$fQh+gf#QfW 
"eOf ot GH_f	  0%)'#+;YfB.&.5e( ]t'..(ep ݝ
.t5
) - f`$PTPf%JR@64`H t!1$/ @ mtqP h2HH t(aowJ<_|E־  LXt2 ur4sR8
t0C fӋ[lPSR$u$@ @C$àhjl?$YtMft?Ou6r|poh^Z[p@SQR{>a
f
H ؠsR n ZY`u迎ѳ1ѐ
 PR$tfoZX}? 
ku0!&"&cFuBÀpMSN4~ bT@ TTn%#mRW@Rttt
u8pû  h5dv pho	_@Pw`ht蘜 a3S$[C vS3ۀ> t7tu$t:u$tC  [0t<w>t8% ~萧&
 
ñ  S r t,  |$$۹$Թ`%t rx"i5pfP	RA$rA a+	 fXT@*dt3nkhP	u4с@4t1-w&$.trwRat0
w&J< t
K:@ 9  $>@u车t$aÉ } Hv!5

p| /Ir/Je@B؃@P0@-J)2
s3y@si { Y 11F0!"$裥:!u;pu;vthPJp J-!  ѣww
210nr &p	&p
À
v߶+ >˾2P~_22zfRV<ZxZDhth`̫harҢ f^fZf`9(b2 rb􂩁} <``Trhfa/f`qkX
  Pf3//8@׋fX!7"" h쥿תQf`/
G4ppO
O
w "	} 	 qE"	/	(	~&!_!!!p!hI~p5ït§wwH6	 ff
a0&3u 2f"Rpt _F<tP$ѵ)@ZtRsQVW%@&_^Y}TfZDfر`yft
{t%Syy隐gf'pQ?f  % P0^WVhU?r=ыt
 t
uu	 Pt u?^aCL`:8b3:EF c6W p 2:> u6 GHt\o hyi/T3Ҭ؋hdB?^_fZj
XK̈́
>
2
{
VT->T2@uOHBp
Nt.
Oidgr򍒎Ppl*w*l/ *ao/ / /  ٪Ol*<RwS2.[Аø (  а`YfQh_DfYbq)aEf3ɋP `qXA&G     &Wf&t ffBf;Pg&Gfww~rtwRtpff>@hRp3QgfY tgho\m&AX0Y[0U>aPS 2h<Wh`2f[ t7> uÿX $>p u0``Åb_<}+! (t)2#tP Ȗs Q`ty 衖s;>Pp 2 ̭du ͝'qQ>_SxbYhP`Qu9 5"r/<t+et&u
$&.輾a@pr3t"tq2t {g&G Q !pv`su
Tu`!>Y`v&!xX OZep{LMOQTYhzBDGLQYmLOQV[`zLMNPRVcmGKOV^fk8:=BGL_rfrÿ à@ PP  ȸnXPR@Z@kf 2`Rў 0fl-f1"mapXqpEXFW@݉f
 fQq 59_:3 05 &_
W1ؐ+02 
8s{ `/ 
t V$<
v
ط   tǀ> t ~${
ؐ h?wU$@ u
d t=؊ T^іhk

p8wd	
	
s	 
@:u &ϱ ߣ> u
8w2 Jy?D &`6;x ѰG@f`f Df HfCLfPfpUb`:8T$@@U@@pPPh >fwt	@pY~?f% @ @r<t<t<!^PS$<w .¯ƙ  t 6G	 N  DP	P 3	XuOARBD-	boPS! ujR + [2P ?'oX	@F	2oP20ˀ~a	$

Àu<X[X7 qam؀ߊa
z2t nP@<KrK?pSI0௢d!0I2.d! JBZ s  ""
ZP3X좸!ߠ! Jq vJúQ R (TPB X
	ذ4 ZQSW(,}_[fYe~Kt  h_ MPzKp&QW<u
y "{ w_Y*z "^|b"~葼ðh1敧т7矿Hװ5s$%&'
u     {`a#q#}# 3a`#$aGaìpup*;s"D
k*
؜#   % r&& " )%k*-%) &k*4%! k*% $$$$$)a_% O%f %% 0.&, 3%x>  y3%3%2s 2dx`xcwUV<2w2 Pظ $H /?v[.uuѿ>t^]tt2 	?s0 0tiu%th$up<_ݟr7~,p
³%h`c@uӴ`
 
`'d% q,pPWUV &S rm.&>a踛ro.t rm*u_pHudcJO%h2 
03!47I+t
3NO+t3GNOUN'w''N'쪺P `<Rׁ'SR['``!bx#j
hgf Q g +uuu&gq p  x[f. fPT ff.q p AV ݮ ݾro@5b 0"X肪u``x\ h(.(: ʠ$h{iOPyXh<ehfUvPa)F X PS&N)&L)&J)[XPSN)L)J)(x$(H&)1&)){$It¿xkàeS8rddr!S<dr@
d2pf*wm設à̛ð<d ߃prU0?࣊&e}àX                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              K s!$SMM MODULE -- COMPAQVERSION: 1.0        ,                    
 @ D X \ ` _p x |                 !  L Th ltg/ _   E@    $ ( , 0 <U<DI"  $(,0DHLTX oool 
P@#H; P` d tA+o)Р( 0
&C'J@
!H@-P@@<@  "B 0 ` @   P  $o                                            `JdJ - ` `P1  ` ` ` ` ` 	@SS 
!
}pj Q1J0K @R"@XF2pHBRUDUPUPAP%&*+P,89:P;<=?P@EGHPINOQPTZ[_Pbc ePfghiPjklmPnopqPrsuvPw}~ tP    @  01467 `
 	
p                            i 0py{107p77708p888	09
p999
0:p::P:X0;Yp;h;i;j0<kp<l<m<n0=op=w=wtF9@ =U  @U @U 0@1U23 4@5U
@   ! " # @pC                                 NNO Oh<fP u	fXc  h #φhPXfPfSfQfRVfWfU _f Q  K!Q  A!!ȑff*2fW 0@MMf3f3f.ffo: ZP fuf]f_^fZfYf[ff"Q ء f|( MM
f700%'#ȀAf`v;
P3XPSVWfQs: ؾي t
؀u ufufpv @uf  fY_^[X}QVf` fpf`LQ
Rf^f_Y@ fg& Q'hsQ"$hDx%C2Vf] @ kQf^f@ʈۍ2  R@ 臕 bb gО( ((5 p  v ϰwg n h Z  ;ɖ/ *
+ $ ;,& =TS                  %X%Q                                                                                   <  U* V0w `U  `Uz ` QХP3f3ۿ~ffg!)Af" 0Pgf+ л/`h?afUf&af&o>` 6a  !žX[ &SP`Ƴ /a&&~2p
f3f>zgf {֓ah   󪰫@p h &<ϔïyf`fffVf@  v  ~@ff>0Up
r0zpffXff?ff0 0 Z  2!q feP ړj Q  U&ޡp  A` efa
pa  6!>Be*Dp F .wHP2"` e" ݸw	
eJ fe&` b "j0e"ffefAffgd:Kugdfepf3 gCT 1 CfF3ۊd@[e3 >_MJ
td?J	 ; |" @m 
NpeOuxP;u._RTC Qu:/
'
%&bfgfd. S` @>[WP9`XP&EX% &E_Y'Ǩ ooooǸoc4/IXo~֠۠;'Lf`PHIa  6&pP&0`X v
``.0Sr&&pfaõr!Br  Pq X
䏀  Pf? h)3\ Xga20uOt݁	<u <u õr$Rr Uo&&0O2qrr]述rN a`z7da(SvxzБQ`es"" QYaFP  r&&` Ob 
yj' P"S""F"&&a UbR ~ ZQRr3'H2't2ZY`2ٵ$t}"5 tt)TZYa~r#S-ER-Y03!pٿ q4 AY f & &EZP 2 &r豂r8t32~.BO hu?,.tGS؀1?e6h%8[&M.2tJ$f50K#h ǿ5 ƿW< t -Ƌ4fRh2h`f Q g ha<fZrj } pvw@5 pS
, #!	A	2h{i
%00`P 0sS%-  Da`6(    pM aV魿ī^`W  3 _r-| `+˸ ~nfD_ED`b;Հ ]B@<B O B<`<2rruO0W2&*G_YýS	 7&*,u&}Zu&E_[5DAP`QFگ>  0 2ۃ<OtY	B<tmH¡7[77rPBBLѯ: r1 r,q h/$do0SQk
pqlat)u$<Pty+fKuҴhQpB`UY[-Qn @qj"yjuĀBAuYoof0P	VPo^W mQfR? hj?tD=F==rN|UtGVRѾ4^t1Vh_5f_^Df`  Da   ; Z x     0Nm1=$
Pd_u	q 42vXҏ	 6d HˀȃIذJ貀2ȉ{w*' ~?SQRfRBP' w	.CZ0"E3a  j2 )a*$t2+`` *0hyth5rEsd/(#/FJ+(\*f(fYïʥRh9}ihlfPSf>QPH_u(DЇ/= fP ݖ [fX-_r(qՉQP-roSfP>fVfW0f>f[X1t pP tf0Z f@ f  
 f4fff!52g&g
fKffRg` g;re h|6jr >VhZ,
-f_f^fZfYf[ r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/fg&bP Bfg&rf`bӷ0Z[XfWKu
 f   >P Àff`g@? t] t
t@  ?f?
 :  B@(! _ 0f` p`; 6frv`gGwf3ې fPfcfPr:p> ff0o;w!fVg&f_^ufFtf!Qy. $pft Qg&$9R<&㿲m=f=ATADtlf q:&Ǉ  p s  S3*a  {[b z1 E 0z3Ɋ0G{j qzUFWP3J XU .߀>K   ub >u `	`	]zpϬ$l0'zޑz$zC_AR}I 	


 @`YQW3( bt1fMd fH7 BC_YaZ.fUf.6f]-f]aeaa** End SetActiveDisplays: \ 0	R$Tt5<x )ڊﯸй8t  u
8?ud  LQSe[00t_@uYFQ2t7ׯ P  x@Q@}p7 <u
  uQ 	
30p ~ D q t1
S
L_
   P pAe\R	X9 SRzooP % Dooċ؀ oXzoX`opNPSR@jYXSK1oa\``-b tQoP À߫@nQRPS [X"3t= z  
\Um  HS@P`6
u&jr
u02,RW_Zr&&&E&]p  faP9$<???M=E>P;. SQWU]hWPAXð _PR Z}o .a;tH rXt @ At^f߃t,` &^Ca" Qf!f $~fWP }~XirpǾC f_`uQ`Mt'f ITAfgf!P 
 2gaYld0  `tXW
Hpc=&M_0g.g͵ Ŵ? t0;r+gCC PsKGPh{iD0BaAΝrJ@P!uu4%tQ Py P{fϰ pԊ612`Ȏt @.d (w >QOa8tY*_O#۷ Qj<.uO R%KM0f
1
fDt6f? 8 Atu p\xu3鈰u#Q?w`
u"Qhն9u
3euC*u!sr'p Jfru*htg&ON  r  x1OCk0`u٣>l  AV@,fSIMWuUf fPr߹fqfEf;w(hvrap 1ð?SECUQCuBf }LR 2(`XfGsPu(Pp_--p$8tp顽 q Gt+S_oh
 pTT<tTwoA:}oh
5 
@ р "ffLw	oßPl& t
W&f_r2Tf$g& g'&	2WVT0fGtЎt2t~tyf0`  f'@,( @ @ u^u @ rFf;r> : t, f    ur%P~)rQY9	 qvS  }%@tR`A
A!:0._2 r&q
"

r?Tr ~V!rP#j   t
ff;t;0
 + t D@@:D^@ ?hO,9h`f Q g rwp		  u ff!` B
fffLp 


ghahNR 
p2a3 ?"t3 v'%Chr
9GѺfwQV1
P6<t12:u"FI1()LD1' E-fY`7@g w.	A_S 
fUfp>@	 _--

~
f+
B#f]^R)""w"  ,gbXvI? An>@u`$f!Q %  
s`_#_#_#ZYcUTPMvfrg&(S+r< Ԃ0`PQ>? uι c r\d`?YCtC?>r-R`w 0 r0Ҋ1 r
-u`d P rdItf s7`QRpy07ЪށNr&Kr! [ww3҆r r	ʟPPRcpr 
 pZPQq	s
d Sr	r!V>RP   dtg3{uwR Z +?}hk-C Z_(\(Y(. PPQ迗 " Y  2  }p,u QP h)3R

Z@u@Sذ* o rı` t္ IQ ڿR]R  UrPPDC	$ 4P>FS t33@J*0` R{
t#4 c ttpÈXQRWV¹+3"a^_Z#"#31$G<u
t$V 4^ûW _ '"  !(e )	
R
q0P#H	
g3&/ܱ1q;-rRr;x;q;PR(Xó 蕐J27Zq 0[RVа$rN ;rCr<,	r32;trr;wҀ tsڋ^ZW
   е0u
˾ШBu P f uf(2 J3322t@@ 0 	rn
$	"
upmƋ߱d;sRZ3QFqF2t
2t	u
S_ø
_..P.Q.Q.Q.6r.Y.2YD_VPCP?#c%   hs5Kdۻ!f1ePfPe` w=fXX, fffU L=#WhSu0_0_Y[ k;~~0|4B	B 1ACDC
F zIOK 1TLL:2  K00`fu f+fMDhf-EXflfgf  ǰ  2f%  f+Áf>PAMSuff>r^0wSP.P 6` X>Ǹ 0f|	B%4 f`&3OyNWV@prY  E@5f0P < u oOrfCW fbWhm^@h
hj/$t.ٜrB  wؾ@
E ΟuA
oP
`Df`t0! F"a`|D"ЎQ$Fr&=t&} tV" &GF^YՃ"a h2Od+	 hL3<-
!
"s

_r
S 

A0~̀RاRLZRu
{P A@3 <} 3 <2<
 1Q                                                              XUPRPRVFZX0RR30ZO                              崌ȎP ЍЋh3 k*# "
   H     QSf = t&.fufPͺ$$4_ZfYf[fXԣԹxyջ "$ueCr Pыf#% uKCQR"uU0 c$uCC3%u2èt+2t1< tfig
6^f<Zu" ư?sKryK ǐ/<J@ hmg<f TfSR7 t2ߊ!3$`cZ[S t? ;!c$tPX0 .Uf3[DӃ tv  Tk*8fQ#;x U2f P- 1f{$#fA)%fgf` &(ӀfPR6"CZ&fP`ӿ)Ӵ2ӹ	  NcfհPBa*.QRVWqNv$ 
?fb  a0
-Ȋ2$*t2$
_^Z3`2ӿ ߹ iMafQft'ff tArf` fYfWfVfUf43f3fft;180n9 u<>q_  td3(=}2=%?F 5?4?W	?t!ff]f^fD(7 u3 +ãDaH0cHaWAPIX 5B1 SQW d h~5րhu_Y[QfWf_YRaCZu<
wY$$<w	{}$f0o3 5`.S> t=ޠu u1*<t&t!usQrVr	= %	rFtZgf&gtK:Qr3g&GȻ s@0aa$
} !OPe 2,PFtg&G"r6Et7otC c	
   VȾ@ 8t"8trO>2^i^t,&
m֢>ut
$(sE ~t> u.9B}"t$	&
sD
Z8 p	>`k
XO	t CKp!+u|0ÿtCƠ ƐP  #gPn%$  
uPڴwP1A> r؀
	pi ϟ> a [At0`1P+'ua *r$+ 9t> uBu
 i  (r"/t 蜽 2AJbSQPXtV
vr-INGhCtB00C.~r`/l/Y;5Ct_5\tP  rBw3V#sDu%
u "65 M5sA$tzu Lطctb ;sW;sQa}Lu	Eu u"
uiՑ"
23WL#. k àkݢ.[t YK* .)P5tXSfW@0at
At D_8؊f_[ٜ٢fsg]  r&p
pp  `Aغ   nBnnntnJFn aS À 3ێ7!C &?!Cu3ۏR .ZhocTef2KpV

X

*
o
Ih&KK
P
>&3a
.pu	 awQWV ^0lt迃t	+t8QWP3 P6hX@.X=X@uX_YoP8qup$ qO!И.
$> u
PI@Xuð6C @B T AgfЧgHu.gѫ:f@g&ffPpfpfffߋgfff<(.&wgfBfsDP
gh!
|DfRc6U? t  b@

(@ރuXZO0f4P؀͎f   f t ttNnp Mp /XïRÃt%tg0&g!gg7f`࣒Rft9tg>E @v9gW5CggfRVf),g>E %/g> !P(^d`g
ز
.   a"Qw2o` p1YQ 膫݀~`a¿`̃QPYXP0t` ؠu f`L؎ Rf젱 ZlfanУ% x @(00	| `@Ef p D@  &Et"D  $D( s `ف&tȀɧ Q4>2@"Q
g&t
 0HL &}u?p ?u8&?= r1	&
I$B>r P
` ߰肐 m  m 
 mQ p˹'s 0a` ar * P۰OQa	 & aP# $$<@t"h<RdۏKuKK|yKuף`.>st&3 &*rC	
aô`prr X ? trKC0}qw1#Q909$ ca0){fRQS[YfZķt'0tШt) u
|{ `dظar0P
ADmG>  fpb ? h3d  f>$rxzBNhf/  UY fr<fffHff#f+ִ f;wfQ3g&S`c
uff+fo뺀
 G CI N!ffpr諸PP   .<t
../ NA NpP^RVЛAfprPPP  tU. p/tA
 NUNh1tP^Zר4 hӣ$@{ t" Z ]sie$ mfh 
C
 &f`fa%@rP5qRwWBP $?@R˿HB83Xm_%qW#_rPSWׁF`Jׁ?9`
<   %
 	 
  31ov f@u#v2h3/E/яGh0o48VdEe60Rt` X Pq&T frfXh!`((( (!("( ( (a q@ f%  f` @b>Nq@9$f޺$6# 12R6ĺ/ZP 5X4). .. hZ3f`f@2f3f% M
 0P!ա
 X@! f`fgff%2@4 2fP `БC  fB"0cw*/ w*	R!b!:w*EP]xn w*Yw*w*l}cyQDw*Wgw*/w*	w*Sw*#w*g*Yg*pp&	 
vwf/	Xkݻ﷖Ѝ.u)!u<u<ww2. ;f&>@qe Y<ۼSذs:r	:([fS fS;xV4t ? u0_&[ff[-9ø |9|`W$$#60i" q
R{fh`<suv8.hr0kfA@fPz6fA0aq}s*dr
h
	zsGch푾IPpdИ@ hexW`"D 0/}|t!PvV &ۼZqf^R 7_'RQ,_ӏ?4B+rà;0/_  @ $ &  ֡  S   	  
     0@?12 03 45 6 7 8  }#7'&M橍-
/v$g_5,	d''Nģ,eѿ` t Ji  q& yRu w  
x{ pq Q   +t !pfߣxfX fff}aOҚ  C ` 
""f` ح#  /7u$5  `"fLPf "^ ]fG/ 4tp~ pr = u'.-=  m= meQ⼸
fՔ/~3f 9tP_3&BRA !s¦SQď)f#1?q6b40 `A`
9 sh}pAkQ=*zM)vp vStO9 D> /<                                                            L  k*ODZ~da\           x   ?p                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(    @ ` d$ UNDI  L  NhPCIR$I        ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
B0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                 E   
 UN44UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   < ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTT   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 [se f    Q]sY 戰f
!  ff !  f   tf ff
#  rfBYi戰Yf3gC!Df3f   戰fHr4f f戰䈰v[f戰 rfFf    戰Update BIOS$fSf=  tef[e戰3[f  f   f戰fSff[f   f   3f   f  戰g&ffFfCg戰4\]s 撰fPfSfQf   fQf3یff
!  ZfYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 :ZfBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX      d         
, ug`TPFC@83@      @ FAA<77777 PKxxxxxxx  ,                              	
  	
     Uf`` ~6  f3fNfNF   Nv, ff6    f6D    f6D    f6D    f6D    ~seg`r]_`fvfFf^f6\fNf6LVfvfF^f6f%   f=   uNf=   tm f6LfAfNfNF~Nv_  u	_9__ fa]PR  _ _3 _ _ZXUfPfSfQRf6d  2_
 f6Lf6\ _Ffff;rcf;v^fuf;tTf6Df   f+fNf6\ffNfNff ff6LfNf6Lf6l6-ZfYf[fX]UfPQF NrHf3F~rYfX]UfPfSfQfRh  fvfvfvT fFfFfFfXfZfYf[fX]UfPfSfQfRh fvfvfv fFfFfFfXfZfYf[fX]UfPfSfQfRfFfFfVfVfNzf^f3ffVfVf~ tf9VsfVf+Vff3ffVfVfVf3ffF0fFfHffHf3ff0fFfFf   r
sf;Fpf;Fs
fFffNfZfYf[fX]UfPfSfRfh   f~   vfFfFfPfh    fXfZfYfu3f   vfF   fVfVfF    fFfFfFfFfZf[fX]UfPfSfRfh   fFff3ffPfh    LfXfZfVfFfPfh   5fXfZfYfufV'fFf;FvfQfPfFfPfXfZfYfufVfZf[fX]UfPfQfFf;FsfFF fFffuF f~   rfFff% fFffu^~fYfX]UfPQfRF fFf		FuF fFf3ffftʈNuftF^~fZYfX]UfPfRfQfF    fF    VF -f6Df6Tf;vf;VvfVf6LftfNF,~r^ff sfFff sfFf~ u$f~   v
fF   fFfFfF    fFfFfFfF Zuf^f;vff^f 2f
   0fP  ff0X0fvfv^~0^~fFfFFF~ t <sF Z
tFFF~uFFFF<v*f~ t#fFffftf3ffF6-fvfv~u	~ufFfFvvfFfffF-v&f~   rfFffIffF653u~uCfvfv,fFfF~ tCft=fQfh   fFfPfXfZfYfu6-~ufvfv]fFfFfu6- fFf;FsfFfFf^fSf3fff 0fXftff0f 2f0fYfZfX]UVVF 3f6Df6Tf;v3
VN@fF,~r^XF:N> r*@ZBu6%s6%s	;#	F~r^]fPfQ f=" u`$8ufYfXUFqf   f   s<f   f   s)fvYfFf   f   sF   u~ tf3fv]Uf~ t7f~   s- 8W
t#P3 ^WXfF   <u
fffF   ]UfQfPF  fNrYf  fsIfrWCr5	s)frsf  fF~rfXfY]UQF  Nyr F~rY]fQVfsVGfTVfYfQfPf@  ?rfff"fXfYUfQxUF UFf6DfFfF    fF    ~ uFf U
u FU UF UFF F F F F F F F  N6L TFT8FsF~ u~T8FsFT8FsFT8FsF)T
t<uf6  F
8FsF*T
t<uf6  F
8FsFsT8FsFF~OF
VVW?^ff	V_F7
gwfnfvF
Twfn fv Nnffs2ffFL
T
uFEfff	FFf>
f3ff	Fffsfnfv~ "
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v ff	F
f3vft@	s	 v 	ff	Fn Rfff	F Rfff	F Rfff	F Rfff	F
 Rfff	F	 yRfff	F칈fFfFvFfVRf6fY]VPSf6drH9fPfD,fs	f6lf6tfX%:RuX@6D(6\*f6l[X^UVdQFFFF	]FNFft>F N6Ls^Vv
s	F~r܀~uFFFFF~vN~s3ɀ~tFb
6\(;vf6l Ff
If6@  ^]UWfQfPFfPFfF    fF    fF    6tf6tfvfFf6D6DfvsfF0QNnf6tfv@fFf6Df6DfFffsfnfN   ffsfn  tffs |P
tfnffrfn
 ^P
uffs^PW<uffrKfnC<u?ffs$ffrffsff rfnfnffr-PfnfN   ff sfn  tfn  sDsfn tufn#tufnufnfnfN   fN   W?^fff	Vfn_F Nf6L
sf^F~rffr=_O Bufn+Cuufn ufnufn	 N
tfN   <ffsfN   < fff	V蹐fF
fF
fF
Nf6fXfY_]UPQRNnffs2ffF[RN
u^@ff	VZN
u?ff	VZYX]UWfQfPMFfF    
f

fsfnF F@  u
$FFFNNTffsv^3MFAMF9MF1MF
)MF!MFff
t:fsfff
t:fsffffs7N^LL$:FsFL$:FsFL:FsF~ufNfN^N
ffs??fNff	VfF    fNNffsfNfNfFfN`~uN6L
~uA6L
F~y3L6!D
fFkfXfY_]UfQfPKFF    tu[LEr
Ffnf6D     f6D$    @  uaF$ufvVU2ufn=fv~ t fnvsnvsnf6,f6,
fUfvF NN^JF	KFKFJF
JFJF~unff8ft8ftf6,f6,
:fsfff8ft8ftf6,f6,
:fsfff8ftf6,f6,
f3fNN~t~uff6D ff N^"J3J$:Ftf6,f6,
:FvFFJ$:Ftf6,f6,
:FvFFI:Ftf6,f6,
:FvFFI:Ftf6,f6,

I$:Ftf6,f6,
f3fNN~t~uff6D$F@  uF~Cf6$sN~ t&fvfnvsnvs)n"f6D f6\$f;v
fvfUf6,
fXfY]UfQfPfRV ZIFXfPQf bJf s	f6lf6t3F TIYfX7 IF IfffFfF    F zfF    F AN6L
s3@ r# f@ffFf;Fv
fFFFF~rf~ f6D sf@fff^ff f=    f;^ ~  ~  f6tf6tf6Df6D f^f   f;u'f6LfNfF    fF    f6l6-Cff+fffN8rfFfFf6l6-f6Df6DfFfFfPfPfXfXfFfFN@fF f^f^ff6\f6d rf6LF~~^fZfXfY]VSx?؊[^VSu?u?؊[^VS?؊[^VS?؊[^VS?؋[^VS`?؋ [^PVSQ8v̾?؊vY[^XUNVv20FF>FFFV.FF"Ft;F+f	 fȊFVnE
t8Fs]UVfPfQfRf36D6D6DFFEFF   N^E FF  F NnE2~?sFFr~@rߋV~@ui8uecEF<t<ucSEF$ tGV6T~uVF$tV*E<u6T
E<u6TF$@tf6l~@uf6  F~66TtW~ t^3t
f6  f6l6\t
3uf6l~ t$3^t
f6  f6lf6  f6fZfYfX^]UfQfRfSFfFFf6drkDDw
~vF  D
t D:FsF FFf6ds4 lD
t$ bD
t
6D*f6l 6D(f6t 
6D*6D(9FvF ~r~vF ~ t~ tFf3f[fZfY]23SfQfR fZfY[SfQfR# fZfY[fQfRf   $fffZfYfPfSfQfRffѹ ff$fffffZfYf[fX                             ' ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    D]    戰䈽aejge戰䈽weOfefeOfefe@
fefe'fejfe
 f%"feHfe	e
ff,f
fHfff %ff1f
f;f
fGf
f f
   `"	f   f3f30f  0f{f
fn8f   f f    0f  f f   0	 f%"ffk
fAf.Def.8] f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.Jef.>]徰hf`g  
ofkg  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      h      l <                      ?    D @       a#c     Aa     
             @  p  !        @              L                        L  B        ?@   k  `   d     `   d     `    d    `   d       `      _        }           z        z    _      @   
 `        @ &    H #   P    !        @ ܣ   Ҡ   b  d      e   i   i   l   x K      j        P  P P  (  l        @   D A  E    G `  x    H   J   I  h       l      p gE#       
    R  e $ S      !  "  #  $  %  &  '  (   )  *  +   ,   -  . 0 /     * `   P             T    ? P  ?P    ?0   1   
   Q   U  h L g  a L x  t   p   | Q         . U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /  . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A           X           `        d                            @             @      $             N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N  <foTf%fo<fupppppq
pfpfupppppqf  f	  f   f@ fغfgffffff%   f=   tf   f@ fưfpfupppppqf gfgfV0f gfFgfV0$ pfpTfupppppqf  fff
 0  fff   ufqfupppppq"fBqfupppppq f 2f0f 2f
   0fffP  0fX  0fffh  0fAfo  vfqpfupppppqg- fqGfufq1f ! = u%% = t{= ufArftfUrff  G$fG$
а U../0./. d< ud< t<t
ufrxf掰frdf䎊frRf f%"f   2f%0 f
   `"	  "	f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3ҊPR Z
R 4Zf   f$<rf  Ժff
 f+;w
t@fغ  ff% f؀f   ttf   ff% f;rfft  +f   `ff   ff   dfff
   ff%ff    f   dfff%?ff`u  f  H$fH$
и f  D$fD$
иA 徰hfu  ofu  PR Z
R 4Zf  ffZRff  pff2Qff  tff!@pPff  xff 8 ff  |ff!  f                                                      	            !            p                                       @  0   G                             P  0   W    X  @   _    `  P   g    h  `   o    p  p   w    x                                       @@           fSfdvgf&f[fSfdvgf&f[fSfQfdvgf&	fYf[fPfSfQfdvfgf&!fYf[fXf t
fgf&   fS
u
fdvfhvflv.f[fPf   pf% f
   pS *[Vf%   f=   tQfH   <f   u<f   tpvf   fT   'ffP   f%f
   CfXfPfSfdvf  f   f%fd *f   f   f   f% ff   f  f   f4   zf%   f
. 'zf    f    kf(   bf    gfdD ff   rf   f3ff3 )f[fXP , ,XfQ gfd   t@g&Xf3f+gf&| tfgf&9Ltfgf&Dgfdǅ       fYfPfSQfWf    fgf&D= ff   ff9Duf   f   fgf&Df  @ 
>zv tf
    gf&D f   ff    Hf$   ?f   f   0f   f   0f_Yf[fXfPfSfQRVfWSf   f[f   fgf&D= fGgf&D=#yv wv(f   f   utu@yvf   f   f   f@  @f_^ZfYf[fXfPfSQfWfWf    fgf&D= ff   ff9Duf_f   f   fgf&Dff%gf&D f   ff(   
f,   f   f   f   f    f_Yf[fXfPfSQRVfWfWf   fgf&D= fGgf&D=f_8yv wvf   f   u	&ztu@yvf   f    f   f   @{f_^ZYf[fXfPfSQV6f   t/3 t*$f   u zvg&ƅD    vv^Yf[fXSS2 V&[f   2 S B&[f   f   f   d &[fPfSQf   pvfT   ffP   f   f   f@   Yf[fXfPfSQpvfT   f   efYf[fXfPfSQf   f[  @DpvfT   fYf[fXfPfSQ f   wfgf&D f (|mrN (fdvf taRr3 +% (p t(fdvf t	WYf[fXfPSQfRfW<v PfUfʻ  fP  ff0fwffwfGfwff]X tffwffwf   ffwf_fZY[fXfPfSfUfQRV'fqv	av  f    f   fgfgf&E   >av utav fv  gf{ tgfkgf{ tgfkgf{ tgfkfӹ0fP  gf{ tgfkgf{ tgfkgf{ tgfkf0^ZfYf]f[fXf t
fgf&#fSfhvflv&f[PVS vv _#[^XfPfSfH   pvf[fXPfSQRVgf&ǅ@      gf&ǅD       vv g&A    
 v wvg&R  @v@ g&G  s vwvP>yv uccdb=$fSfa  #f[g&^  %# $fSf  "f[g&_  	#"g&^  ug&_  u>{vt^ZYf[XfP3f.qvfX         f   f=Pt=Pt=pt
=t=u8f3f3f3ۻCfff  0f3f3f   2Cf.;Gt %A      jZ>        P   D  @   5{ ?< L<'`&t  j?@ 
5 ?o?  0 x7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
  =?o?   7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
 = ?o?   7 ? ?o?  
7   ?o ?
 7 ?  {  ? 
= ?o?   7 ? ?o?  
7   ?o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             PȎf   AXus  q  >rfg   ( r  .fV>Mff<>3fffsrfff> wf   >ff%f5fff> trf> wf   >2>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf     >urd>u]R D>u=/>u(f "'  >	r  Ko s 撰 Xщ>Ɋ
$@Qҋ#fSgef[gefPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRf@
 > uB ;yM@tNs(xغz,y0@u1sz.fZf[Ru	sZ                            	 d   d           d   d   d   d                                                           
      		      

      
      

      

      	     UVQRF F F F F~^ t  F  EN6Ls8F^F F
$<u  u~t F FF~r  tR~Es'~s~w	      ~s~wd d ~s    F  CN6Ls6F^%F F
$<uF~u F FF~r~u~u΍F:FsFf3ۋf8uf~Er  F  6N6LsF^du FF@  u
  uF ~rĀ~Es3~u	   ~u  ~ud  d  {~ud eu`F  #N6LsF^ FFF~r׀~w~s    ~s    ZY^]VS suXu&NuI2Duu>5uJ+u&V!uubunuz݊u[^UVSQ i
t
 _cFF~u!~uA~u6~u0+~u~u~u~u	~u݊Y[^]UVSQ 
t 
i2FF~u!~uΎC~uώ8~u2Ў-~u~u!ю~u~uҎ~uӎ݊Y[^]         f  f!  Bf3һMf  ff  ff  fff
   ff  ff   ff  fff
   ff!   tf3һi` f   ѓZd f3һݓNf`f   =dfF/f 2f%  ff3f 2f%  f   fff 2f   tff3`f   ZfѰde`f   sdfֻ~f ` f   d f3һZf   p3Ҹf  f
   ff   f  fff	f  f
   ff   f  fff &f`  ff&   fd  fffff`  ff   fd  fff<u
fϋfff
   $f$
ĊËfϋfϋfff
   $f$
ЊËfϋSfWfRfP눋fXfZf_[$f
   f fffff$f
   f ffff                                         0         @                                  0                                          0   ?    @  @         P         `          p   ?    @                         P@ I@ Q QfWf   gf&D=     ff_Yf`f  g&D5 |v6vvsU >|vt faf`pD$&v
ĈD&vvs f  g&|5  t>|vt far`{r ra`D$&}v
ĈD&}vvs>|vtN a`&}v D$
ĈD𖻠vHs>|vt afWpr f_fWf  g&D= g&D=Uf_f`g&d  g&k  Āu g&G  vv{v vvG 	Pvzwvأfa    f`f:?f  g&D= (fgf&T=fg&D==r>r6QfPf  f>: gf&D5 gf&fff>:fXY/sufaPS&	$&	[XÀ&&        fPfSfQfRf  Pffff?f   f  Pffff  Hffff  Hffff  hff  ff  lffff  ge f   fZfYf[fXfPfSfQfRf  Pffff?f f  Pffff  H$fH$
$f  H$fH$
Њf  lffffZfYf[fXfSfUUgef*geUfUUge$ge  ge f  gef[ZV`VfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X   `fffY  0h0pua`f    ffY  0ffбh0puaY  f
   `"	f3f3f   0f  0f  ff  ff 2ff%  fff  fff f%"	5 tt! >@s! 'ô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfS  ?   fg  +   f{     f  q
  f   fHt	f쨎tf<w' H$tt
f         f˻ f3ffйh0i0 ff" 3f   ff   f @  gff   ff  f @  f3gff˼   VW茠_^f 2f0Unf 2f%f
   0f  f3f3Ҵ02 0uP0X0Y0h0puf 0u00f 2f0~3Ã u 
u   RQ 
uHu
t!utuuYZV36.^                         ø  f   f$<wDE2 fl f fh f 	f f    }f 'Yf   uf   tf f   KMf f  ];f f    o)f f    f f    f  fff    tf  f  @ t f  ff ff   f$<vf ff  ff  ff   f$<v fl M3frZ>`xӺf                                         Q  YPSR+;wZ[Xf> tftf`f f3f3f3f  gfffCgftftfaf   fuQYfVfSfQf
!  f   frffYf[f^fQfWfVf @  f   f  gff^f_fY0123456789ABCDEFPfSg.<$tCf[XP
XfSQRfq   Ѓ.sZYf[PSQ؊Y[XfPfSQfع fYf[fX            f  f  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.?
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           `.<ta ø fSQ >tf  r	f r&  r-w ge0fp  )rge<uf   ⸸   Yf[fS>tf  r	f rf gef   rge8u   f[PfSfUUgef*geUfUUgefUUgef*geUf[XPfSfUUgef*geUfUUgef[X     9f ? fPufhvfdv 
flvfdv fXPRV d ^ZXSW  _[SW  t_[RfQfhvflvfYZPS  f   r  f   cff=   t  f  =    
[X     PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     ffffffffffff戰3ظ  м{fҨ]ffJf    2ø       @ 7]e06/01/05DTThU<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BDD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               05/13/05BDD  