#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTU)  - Linux-Based"
BIOS_VERSION="F.09"
FILENAME="sp30668.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8DTT   BIN  b022  2    8DTH   BIN  pk22  WW2    8DTA   BIN  6t22  nK2    68DTU   BIN  Co22  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412- Disabled Rotation
- Program Panel#15 to workaround 14.11 issue causes LCD dim down after S3
- Enable all resolution on non-DDC                         Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
 ` X                                                                                                                                    !  R`SI-1362-A   p                                                                                                                                                                               I   <      
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJXL  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XJXL  X,                                    p   `      POST  f   f.V .X <  
 f.d ` j  I     '       ~    POST2 { * F 
 X y F 	 Ps
 ) { )
 ){ | ) K X ) Տ 6 1 2 2 ]2    -z  us u t  м! " ,# $ v,% & z' pN( ) <*	+ ܏, - 8. G7/ X0 01 2 @3 4 i5 6 7 8 t9 ,: @; ,< = ,> ? .@ ,A 'YB .YC ,D zE F dtG  H I 1)J XK W{L )M PvN 2_ )P Q pR ,S qT ,U V ڣW X *Y@Z s[ X\ y] F^ {_ 1` Xa f3" f" @ ؠ   ؎  f{  3 q 3    U QVW.D7 PX' hX@s .X=X@u
_^rYʜPPSظ h@O [X /<t
PW jf&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI!؀ ߰UhiBt/f00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@5^Rf0@
u߿ h8ufY_ZXSQW< s1
~2
 hV3_Y[ABCDEx} U~"RVWfFf^fNfVЎ.< t ~.FuN.3_^Q	
}H@
	y	! &
%s
> h3Chup0M 0t  Ãu
.(u	u/RPVF	` u tR	k@.)tމ^~u 8	t/ tS^6
5
^XfQW~
,  _fP	$S 9#0;r#Lt<
tw
u!ο 	/_^p	65WfV*p#)6S
F f[t3ff^ff[f`K.fa= ?pCfVWU? t  f7h2%3 tkfAh6 Px'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@= hR3>+f;r[> aWp
2hq_
 WX
_: r
gN1
g~>r @9ʞ9 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?|u h P~fΑRx   _둡4]hQRWV^NV v<q6Q3qI4GYGʫξI^_Z!3Q'M0 ݀pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h^
s.  OGFuQVsuR?
`O2ۊ~f@x޲k:P`?tWuf@ f.(|ftf!f.@# ;
uF8Fuwf_ts^ÑGVR.>(s$0q	.k6(.(z

ZxF(Pn2
F0(FPPv2PqN~ t4vf2&fz10
FNNI.(ƔfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@ڴ 8^rf(  _^ZY eWQ3.>(2 .ǅ .υ" ` Pǿ@hU.( `s$' ip3.(lh|z9 o.N /p\wFk@"~ 
N~f.$=6@.(g2ɠ0/tl)u4.B$f<t؅f  `b$< F. 
1wq3V@~r F F;F F2u~Ow
`?M~f1 kЖ lt
fNqu
ffsfF^PB4)FQ*
*q4rF?$<u&jFF .# ~ă$wp` *.p< O<uO8q^`V@;(@..(;O(^V0&0
}9t@-2x_@2
E/^S 65^35#'suBX:NЎuP:
t3S9)&u=8N0_^WV\SVR۶`Ffn*rJ[*!ffAyRffP%Ѐ`2fpʰKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tP7u+q%
u	AfFaJfୀf^Z6Waf F݉^~K"8ueffFߋN_QtcV@hvb!F;pI*3χ~+c:tsRVRfQF;F8u p? kv@kF:`pb$$@K*@3frD` w;=< ur,.;D$<uπk r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"t_tD y@DvP }PkQ9SV ޾3; t	 rϋ^00kː#Aq[%S ^Y@j(*pt@;v7h!1k~@st 1;FtFk^% Bk^cՊa 3҃  V3k`[
*䊁;FuR*3]ft7W-k	)	# a
@S
+FHu
4uGrvFvVoBs0;~HVW΂tS03ދ[^NuVp 3Wҋ0_&61-D^r<lF_(kHpBHP)뷋A(7YoZ Ի&0V  ~1|\0PN~ tKv0YFA.Qzw$ x
fpO3g FfN@P@ 
0K SQh(	 \P,Q23If.` tfg.&!. .8(tьL$QVW
kfvUFp"`F^^F  FψF
fgFF ^V膵eb"˄^`LȬ`Ч!uɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;FyQr@րi`bbbfC}<4RVFъF8Fǋ^ pVF]0 N$ U&(s,ytN!!fsШGtE rt2s@C>A9FvGT 3r%if.(N쟊Ϳ  `N0ƺ0 
t
F%  .=p >~ t(i'i_f^z eu
 v@aQI8t%  tu Qw  vfIft'fAff#=a fpЊ=rSf.6 G                                                                                                             /                                                                                                                                               o  PQRa&hi@ $` hBrZYXSQWa$a$a  h~ hu ӻ>5_Y[2揺 TCA6  @A }Q C@@ @;uYð!$p h)Ē
f`   hf4gf&P   fa.-h
 
hVsfPfW@&'_fX`\h
-h	,t#_.hX_*   &  p<;@ ؀ ZM&}uu h2!o3d 
  % zUW;-5&$@#h<ff
AÀtf%1fh2su h?*,Ⱥ: @p 3S, @uSh.h s!%úv0@Pp"0.,  R   P.   f4%  0"[  
h 艪?`b4&&aPo h"; C# h~) t
 aPQ) @ PQ= `t
3f3@fYX _p>d`4d  U߃P@  TF  $ؿ
Et&؁ @ uM9NwN#uӃ~ t"F= wt%   +w0BXh.=`.-   !	 9 a `hVL0 t* u 5Jg<u!>tPRfZXD(~f.~ A`Cf` f   09GbV~1SfQfRfH  f`&  %=uf?a2 fÿfZfYf[aFSQRfWfs_Z PChDB}ff`hN Ms0KK2
r-
tf !s! h5\f6r\s3 <uc
<\6θTfaa	'?t5<t1Xf P[Yq@ Æ B<  C<U $U # Q R ST U VWX YBZ	f05RVW3i-)D *
` cRQ_fQvfA uуtR}WRPP_^ZYL!%!r փ   > ୛ A  T  M e M A@ _ 9 Y .    nG SA a጗@4^g (
qJan }  Op+pO{!r P0Ðq;2 P f1!R61f6<1@>  3s puЗ 601>x@.h9cPSx $<t4r [! Ѝȋh۰23 W f`4 S  y6h3%h9r[ @k D 3y "r< tp]F22Ϫ"`92l {21r12 r%@21&5&D&EN12͙Aa
phSªz @߿2p<tjVi3V~^W 
8
3
~3
(3^
2 `jvQ63^&@ U$=u&43f= =u X&D3&B3&@3I
, fgh  0 pqr  <ABCDE xyz{|}   {)[V S#
fgpeh4 r&3&34 r
&   4x" 3ƣifX^Cf  mfw5fx&V3
_^`0(w.'t%.FuN.P2 _XSWfVUSW! Q,fv߿ hy  $~22ك!IN܀3d	^
u
t_NA&>1_[]f^_ PVb&=;u&&4u&^P
P<q +&~& 1E&DpSV h@r^[6`[WfPFhS@  <fX_v^F10=ROM Based Setup  Entering`7 `. u  7 lKt.`7`[8 Su0)!`- W  97_p 1A	A7 17q&rJzp &7tFò  Ŕt
.>	t.Nt
(*衔t hYsPXhW@sF12=Networkrvice BootWake On LANAttemptto `%  ht8 0`8 r	 A`8u a81I!	t_ ytsR QP.?`8$<0,( K8mŞBUB"`8! dOs@C~	%25ؾzM<^@s 迃E%r VRyo{MlNF jM3߁ZM?	uCFG~N0tGh}NjMvshZ^ òP*Notebook hard drive MultiBay"Dock!:b<#b (top)bottom)left|f	Floppk  USBCD-!F HDis/Supe9rNIC*
!123                          D<bP m 	 
@ڐ
=4P R p @ТpqlectvZDeb]  ͹U8 aond _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   6>L>(t>$P >'>;S A;Zip.F`u hC d0ô0.>Ӎ tԎ?; A VjM3ZM؊' tA<v<st1(>& 2ٍ:2}D<Q#YAr	 > P @.$>
*о}&> @&>+jjj(Pj=  > `$>= z    > R 2җ
   t03(>2Ɋ F8tFޣhjM $/ Zbqqp URVQ.,.L.T^Y^Z]S,._&>*[ݡQSVW/ s&Q?.<.-00?00.Y_^[YQr= u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰww`2҂ Xʱ@
$>==r
;w2p{$>Jơ}gFYô.*&><u2K0fhV봢 hshu7d hb<u`B J qWo rf.>B5 h5	fgf&G, @ f   PG0f@G,`u
hEtG,f",f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁h5p.
W
g&Fg&Fg&F"t7g&F0a 1 2HtC׎Ǎ~ذ:{ rsvC	 k  QRVDTQF r&e^ZYCffL߹ (]LрY`VUfQWo
ِx
K&n@
C' C$C$0Grx  q##_ r]"0tsrg r70K:k;WQT rQ {GC""Y_r
E@t]^f[XQ!$&C"u
#%$gu!#,vABM  f.EûPS [XAu.6Ef.EIDNU.ESfV#製O #^3%%Ýf@}3u
u\ru!q!} "W3 h!mY **hq3p%59cf_ ]`= vH O1H aP hi"$@<@X7LO4pJPR ZX@ P.>F t.Fo.F@aFSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ ^2 WW$ f3hcXRISWQR Zuʀ[Ppq4=B XZY_U M%Zу< @3ɹ2 uhXdo#W) P% = @uXu%)4g/&@LhH0V̠QfPvf  g&?t9g@YR%fi<u @^  f%?f^#   f@"f۪<tf Q	? f !pf 1^AaZY^$fVL/z
/ZGP@t


 
"
f^ff? wD P]f% {
!
hVfi4H34r H5 0P{@p <D	2 P` E  =  L到@`@"  	P  	|i tp   @& Atf &/4&+4@ p -p 3_f$'Br"rst$ uf*|~c>/4 tuc ~rh^
&84p=C<thSp}F4  G11?}W4 Q < t&`4Gf&$
ݱ3f30 2ɴ*f&/4 uf
ffKP4&4&4fC04ʁ4p415RfVWf D3ffCf[fKfS܃fF0rw0а K I+r^3_;Zf5SQVWϾ u3_^} 	!BKsV 
R3
t<^f~
w/vƐM0fkd`afft@`[^ɳ{VQWfv hG-F&5F&p & &P&&0&&{&_&5^yUȡf  rX)Tu'P h{" h˳hgaX`a؀atiof]PRqQ ² t%  sS fEP ffff>APfhܳ @Kg&; Qu70W)f)Pf~Y~/u! /u/u/u	g&t(tx3	[rnf!ǂ0ِ  ;`o	1/uP~/t ~r!	 u;NP5 -                                                           @   10Uf`f.<P@P?u hNrW2rRrM@Ptf0f 0R| Wb t#Cr"t߃ p ; (PJR  ZR 7f]L@V0r*6^  R ZrG	Ku ezdB rC\Aݹ 3?Xy8E tސyEG 	U~gRm r	R>EP	tlkQkpbƥcW rt r
  GC_SRA0Zt$ؤ5$]WPݰ  _W}  sp  a!`P
߰@S P  	ð D v Sذ8 3 e _R	Ǥ!
R'
9//&QQWjuptPX_Yù
 d h=Cx1s y
2P -C<u4-uĀ qRRaR12e< uZ#ȴ$? t	xJ  U[
	a!"(栘Pfn@ J ^hWB*h=aßhr$T/h! 7hjB.u_va { r PQW 0> 3_YXI9h]c=F =E$hkSs	> Dð   ! $!f` T hi8@u' t h* hٲ; tff%f
> ffa0vPYF X>(`ؾL &>JM&DEP&D >zMu kdNW Rj@ t~ZM}
 -Ȁ}	 >VM 33SPd[tS[@? 2[sDy3 t^h#ʊYs
ߴJhO#QaàhL"RD
ϰ<DuL
p
E$ߠ<u D
@Q3Csd
rSi&pS]@` uL
 6 6>M u  (X68 &uhT
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  st"& xu	\	PS   ? 6P'>WM_3& ?! W>XM	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v߲`WU$/! $<v@a`n3  v
p
u$"<uP>ȷX\PRt P:1thE]!&ķ=0߿ZXx` 22PEǿzM&PCt5jM=ZMtOu570: u	At!sy96 u5 .n\s
t!\&q s   a
׃/_3m c"s{&=  V P;xNu 0<} ^  3f4G -Nf_  }0 U!    N&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&N/` 2%
<t29o21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇2a&ES$`	&Mo&]AH`.'	@[%# r`S UϠRnb0ZW&= uAF:%I)
hJ
 m_XP
pt   U!w#w !#`ފ|unhS0 #b.-.MSNv=tI! //(rJ-b.58v@Mu% @BS߿B 0hshuaW!$
"1D hb
hVCYp@[X_Ë
`PS@e![X SϲWH<vLR
 Z,<u(Rff5fġf,ZJ vGu

W jS1 6у[Qa$= ;@aÁf3Ұfh!<`b8 {	4`֎ސw0hu73۹ F
t):u%9dD	& h.SjM & 	 h3jM3Ga!3 
3 @  ZM SٹuTu " / [J rGQw> r;fQ  w.<t*tR&' t&A+  ˹'z
z'+Q}!@s& 0RV|Z`|tpk hв YQ@@?zP^[Wr4fHq(u% = tR_0Y V*Q
@_HS3ZM+6 
HHǋwE&AE 1, @r \ \hpӼxxf1  ,VA @p$P<PtReZDAA]O  ZG>pZ^a/\WV 0  Ph"X@ 02)7
C@)2ƀưҀ?!C@u?r@yDt5. ׊u,u1 
@a

+&C323&v@t } %
t&
0 迪 5  O"   ( T
uӴ: 7/b!	^"	? Aw ^sPRWAC&A{ &]&U 
t ۀAi] _ZXr#3һ -wv2C.{E/N#h&_ '߸^ Y      >u  '3W c[ n0_jYf#`Zf3fcu 3 Q>L`[C: uBE&8Uu8p]
R +B&U
ZK!ؾjZ6fYB)%q_r hʊ {;1	Q(t06
  5Ãhk]~p8.
<t0Z`ێûPV#
@F^fǠ  XLED
ByC I nooUf`` FwQl. fafSfQf.Klf fff#fYf[2VftGf   >lIg@f;t&f <	F $f^`2ۂۈfaf`3߀pfaPP3_X.>@l+ . P	_TACO Fr>  
!	& .<l ԓs<F	>l fFf.Kl  ClF.Olf.>Kl;E.Ol@  tAl߃ttYpBltONp  D@SIVfB.f$;Vr?T%W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p <l%sf@c .ffHpCfXfdf3ۃ!u+`so?I
s*"/S"Vf+f;wfffþ33RۿREGlVo4^q4'r44z$.7<1p6ɐp08333Ҹ  QW>% _F
3}5u'JE#a0 t~ 1o10 't
t} tWM_ } ,   F EF^V/ SV^E ujQ`  &t Y&  
 < tr&\]p &\U  
&jN!d ZM
SR[u 	F@&ߊ $F^[_bF FY2p߀TV'}PVW}ًذо' ~MO! _^Y[XWfQSg跁 Zf{at
  [fY_` t =$PpnPu2MtaË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jrČD^XP
~*?F
  t# b Q`l{F @Fxq d3duhXKu`<Uu߿ùd `hc4d & Xtû   h?ͻ& h}˳ PhۜE'`Xÿ!$!   °rs}ୣ? O
ehI   tt 4  hLc` tKu& &  
 ` h,~s@<t<uu֢ 
0u?1*`P	hN# X7h=@ % P5 'D[%ys%aP?Xw$# ) )th`($} f.`?G  3 l3 5Dl۹@7' À   ; Z x     0N@`^~#bhݞ1fF3.}v% rׁ 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہv.~r@V» 㐂û< f ff @ffRfP'f!N
 ffFf3fvZfFsfBf{〶f1 r9pf3pǿlfAP  fafPVa3v޸rF3X

S,0<	v	,$mx.[W D`

Lb f s ^ f`Ȁ
T
T p s 	 
Sf_fp ЎfvPUõYP, Pm:Fp
uf^fNfV_f^pPrRp*fVA6F@20hC@ Ϣ
 ff  fffffXChq p  `90y P9z" 6 ay)P*hcP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMSqhm   hrRɀhVh䎢SZ?;?PSS@찋pq$ q!̰_Āu!A tðvntt<1w(<vvP޲jEgO3_ ;P&
0
3q 33ҊtW/g.&;u;@s.ont)@)hPmt^؀a`2G@t03@ @u Ý 3[
u93Q2,;8ӉN 

P5-j1rX?03Qr |X@{Y4SQo2P5'a&& &0hUlC hزuɰ hOk
t[ Ȱ t
sŀv#t̰,5-PX~v8v&> 㟸`t`_P3 u $h<J
#RV Ps}~ uu22hSgu]5uXP&
wL~2 Q޻ hNu= Dt= tYԀ'
YY.~^Ze`v1HP #wU  Pf/^ ]  `yrr	 V'afOLPH    /    @6P0;V(e
u^V- ^"(P*^  2ސoMqSP( 22 pX[úB  $@7R  Z`7              zJtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*?輮r3w r@ .h_hfa2 PR30 Z@AR `&Fd??^uhYP&XhW r.>.put 	AїQR.h f3f%  f`YURQSWF^
D= F\ ^F \^t
;v F;F
 < uWP  <022 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u;v` Ql0 >҄h *Y҄`"QwLQ`f&YCC`K (   ҄P3YaPSRP3@mn?[`H@4$&%<GP 	 oپM <BMtf3%ĲP2W X` ϶Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 fް@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff6pZXW_ RWO  3OtCxx ؎P.BB <t BB2J &ݾ   8u!@屆`23Ұ
ShSSt0`́ y aut0i at]U U[aSR  4hf
 h^SgZ[`-1Pϻ  h==	 h
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wZhEU2<Uw  hY2q u
3oҸ EmF)v upQstT 9 
( 3Pf. UfQfRfUfVf@>h: rsNrBwW3f. ff_2f^fq3Yf.>fCgffgfׅ suYKU q u, P3	fgf CPpaIfAgabf.#f9ufpfY'0  _  /tp ;W;hÄ < j܄
=ЩQ 5f %"e  OV3'@Wt pe;F ;
V3"/fUi &g3  f% '" #WFfF^faQ_V p @Z  
^`q[3[<  ~ f DTDw R o 0 ȳh  1   l ( Pb @0^ W HL P`A T W Xb, `
`!W p@pؾx o A0
|\D`̿QWhG3 3_p 0 PQ= `tq1 @0Y?X 05SPp
& p  ff?& X[@aa"&    ir  vf{@Q  oJ&OfQQMh2 . /ۀ Ζ Ġ_ <t  l~\ tq.Ari."D.|u.:DtSIz  wD:r5+^s&v
uAm
c1PQRfWTc`o
fXÑ2a`2	  "	f 2f?@0f@R %  3?f3fPaX Ah lVUv  fb #n&f fa dD 	h}zW"ϻ (;sQSf  r`
 t
2fƃd	40q!a
 Q[ffY+˽vf[Wf+_f7 t%ȡ^H+f@`h00Qpg- f@kf`0z q_L2_&U uZ=PrUf uCfy*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&ߋ%Իf2@t
 <t+p g1~f&f   , Xup Lr}3fBt<rfa&'?rf-QˀÉ_xF?<qP
  
"a	Ub	O~p@R2BuIE1BcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&^|##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&tg&TfVR3g&Pf0Pfnu=жtsaNu(g&fVffA>"Ȁ.f+E)?^f^uS2u  w & ?PP0Xt'vt
wt@0r % r/o hOk>u  thrs-3&>rqrRPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rou=
@ Ѕff  ؀>t !$!~f$< uRC  
WN<2<ăƁ	"桻3A.'y@h[u TYP=t 
u2Ɋؽв3`t<u
E< tȵE$<u&w _$tRVL  N L Nǻڰu û` t  P[2u
@j jӻY!(!?!2(<!1e$ h5u$0t-$?~Q.#K,.t4&^ t<r&Pw 3.\{  5!.\e@.d nb    W	x .|wh_DuQ&~% t PNXӹ
 .:t
 ._
vXP%8Xr6%ȸfuc4;La    PJNL p      QKOMp @Kt  Jt P(.DG~H h2h  hvQ hޅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
o&;r"`np$t1TKub 
HM` `_(q p_" sr#%	cp&3a C 	H ]r5r`2gpjh!vZaVRQShUl^4Thأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Phi3UX<?tFhSUujjjj P= ߰&hW@X\ {hcY$vbwt = ;t= Dt
hEsp[@WVS$`́$
[? @n< u"*׿OطhN_t`-->J=Ot1 0_ tyr rh ڠ SǇ^1  0 hL PͲ5[ ? _ :N2o?Aq%  	
   V짋FPgbVW 2_2µzt"@u~G2 
u
2 
 o2E2&&&EA &e?
td&߈E?&&E E &E<r&}	r@w VW^2۠^2*à
&}vPuhk]~VRPRQ3fo 
}%*t,AYZXRPSQY[XZh?}tu	pp Є> qQ 5rX[Yj-: t
*֮hGRL&&  t8t' u a,& nqr00r6$^$ ⢠Z& && ;`Z@ `dde`P`  X3U @>
ڹ ? .PB B8uwG` A w; 5䋀w/)@#BS W냑76VPoX
 a@A@ B C    ÜFt݀V$%Ȱ%蝊<;weċ X؊<wM3Q#"XR<  YыȊĴ3ЇуE pY8@C0	 FWYuF5<uz`0Df&	]2
pu8f߻hNeP߀k 'cB@. ,".  V&k !< u?f& bÊ$
r߀ wA?u%1uh$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVW~ҁh^KfKff
fYh8Yf3f3ɹ f Yf0m f+fY ! Ku*آc3ہcsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2ҹǻ*@GaaÍ6hVWa2z_^pk` hΫ$h  uP$<X%sf @  t<   4 |r	.A$<u
k0 f3hh.@ 
d]XiJhT=  tdbw_0s.>@{Nfmw thtC	
A!U2 u@? l > ]sc 3Fd@ e f Fc~ce@4~e uQ@@9 hY`5
P	3hӳBFe:Ffu1r,
 h
 Fdt;   	:  <g htQhesh}`!af`7UPHh,u;E#f% PCAXt# N h=&N r k f ̾   F^öP XSĻ  y ,  o   hbS-[t(t@tU,&j  j,>" ' À tht*dúߋG."**D/.qpEq+Ëy؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYe߹b +Πu;6Fi1 epp~0Fff`Fup   j(j	R	uaURh2  pɺ ְ1 h>BZ]coRofB`r@!  tgRQ Q;YsY2w$w
 !u$ d%|Zf`  WWeI.&D]fD  pC`hB%
 C ƀu0u.>B 1fa
ZURtLށUHh<:Yn PYp to(tq ;C Zߋi@"gm squ4?VfRfQhÊ$0;p^f[B]D8" a[YbhN$r s 6Sj@ 2P s rGZ5'/UnAW`.CuQZM$<u:0p螱r"&  t  ttB tAt $puPNq9(
ː

 ⧾ZM`XSQ 3u,S?[rE	ˡ-Y[C& <ff<a`00xx00`֫Qɬ||	w>>.r tr~ (ЃmrLZCX'q@VG :]Q<Q7W &TZs6C  E ц߆ԆrBo zuN! DO _u 0/r)0/c#-&A 8q2 F o*7&/p`W aUfV3vCDPDQD 7pf^]&Â୻QM"%U  wPd?uX$epI|:eXa@ `` /////- "  ~@f%pdк0ߴ FACSPZ DBGP4BHP  0944 A!  8  APIsCZOK	a	A
@  		p
  MCFG<	P	    @(@
 2! RSDT(  	f`hj4hsif  fhpfp  gfFgf  FPTR ff`WgFpf.pp^$f3.{.xf.tfN0~$f+ hCpJ~3ffgf&f.>f(.ytx22@_~( N g&F	f P  rgfffff+f+.|
ۑM.>pf
$$#D PXff-qAFV3g&fFgY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf?=GFCMt"@H~ Qr< uBOаNRUfQъ2 tPxprAr v; tg&P)XfY8]МVfWfV* f& fP&ؐz@(#f"fP)fȀ$ 4 
Ȱ 
ff	h⓾p (fq t ߺ hffP{W EfX3 PwdZ$ wc g k5t+
h83=a+0Q;g&h&_g  PSVxy { |4Yt >Fu	}|CEf : uDb& @ u  D` ^PRW D hV_ZQPSWtSfP3h f&L  fy PB-!`#L fX@` hk&4" 03fp&?  @ 6xNu  }  DOGNf3{ pGր   U!ߛ   N>N&geE E puMPMLGofEtXAt$Ot3 t)O$fM
rQpmMe&NaxU  r.]h2.D~<mAq^  Ϳ BmøPݳ amWp_f
`hgk0kf$tt& tPE'뭿 5(P)io_ԜVΎގF^ 3f`FF  h|w }ur h  $g(,0w4'8  u6Ã9FtFfNA9F> hS9ɀuh(fa`
Ew13ɊMh$ӯt

hRp;r#_uac5WF ^5sBf fN^Nf.9/u /tc rfQPH_urf;^uf;Nt;f[t) pF
tF~߂U_ս MfOV t;6(?.<t1!QQh:,,k  ^_ĸU00 u,h..D+hXك p1_fqtA"   u
ﰙ3   t'0gf< GhEC?G$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCIAReflex^ v.2$cr$HP
  ]a@!g&O@ yGgd `P ߳ rLfK s%or>G	 .D
A O@.d.D4f_ PQW  
G.g&:uG Y.5 _YX^Q8t *?F 
;⡤fW
"
Q@
@B=g"
U

f%Qf_V`bSh@0Gu#{  euu .Au = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.A؋V@< t ^}Jv 
w x y   h>ShWs?z %ZMheasia
qTrPqtI	f| b
u 
!tQo&?s	GYV
} ,`؍vofD   ,AfLs-<t(<#@06~ hi	L^PRU32t
t
u
5# t u9<0r<9w/tMs>ư7SQ Y[t>"$,0>ϰ*SQLiE;f 	tuw]ZXf`3Ҡ&&h#ֿfv*`%hÝgf9t0Xa` 2   0 thbq egf@ Vff3f"gf\ F f0ȼQȃf!
!޾3۹: 8tC~RP #t r1hf u|f@q  00i{? 0    0     q'  ' D 
 Y/ bbk`os@GY k,vȼ/PS_.xVW 5ǌ׎Ǎ~Qr&} u2Br	7:`_^d>诩r5Yr!br\E@&=u	k#$Hr&E$7u5ȯ/¯Yӆa
r&a)rI DTtr&e`4o5`
T3
kɀɕ4S1r#@itct  t$yBAffL  	+] 	vWQ
Ru3q
]
,/i+ჿW}!z Pr8u`_QY_ þQL[ r&UnþNǑL螳`
Pw4$X` $2L nB}0<t{H`8u6
uBp & DBlTt
oaP 3 r/) r%BBܐ!J@ 
; 05 aù<t

B J 2@u8` BŅI2?2P<u+BTl&2]Q8uC\u rq@m ri~ rac  tAc rF n r:i r5&D@u-&a${vQ> Yr	2QKd'YB~@Aq Br6蹐B~^	 fpb3׾S @ P`ңP@\`j h\  H hS7jglπ hÈ`% `f= @u [jh hc Sjjjj P= g\ h[cu\q?j&^$bwtQ= ;tbu= <t/Eݳ3 ~{	hZtFkfa     tHuuu):p*< ugwuup@ oz`34jr! grπ DƆ    r% Z у-Z1p$Wp_ǀ uu' 3a re+ tg	%0  .A{fD  Ff tp؅Y[rs3hY ڻ ڻ> ڻe ŭF  ~f c `W tI
r=? \Ӌ~ t@D@t0(5@ MF t_ w03N !F ~ tٳ	eA0鰠SZAt9A`d f` W܋f3Q fY@ I8.U G"
 /2uJp2:!&= t:}`T  yr Dl0VQ&ǷUq
u$sY^D=^
%f"Am	
q
6&:!& :X.Ջ IhBB 
D5@P w(3 ?  A-wsC"upmi1u[	q	1D!IFtg$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7oR< !Zt'
QVJPf^DǪUY!p.o&D++t'H"`Xtut.a:``s; 6sc#e_p_pkodqooo#Keooao
fobdasfSAMSUNG
 LTN141XB-L02
1P43
TMDISPLAYCD@EA0yV@1EM4QUANTAQ>0FL072q3pXL201
AUO#BAG08 V.19 V3 
?BOE HY 
HT1B-120

+              Ȏ؎6%-r[>e  >Y w 6 3`37BA 08u!!u
( H O8u 5	3ҋʸhlPW
 
Wt_   @ك
_XW+ 
  H    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
hjBt & ^[SO
&hi" <[U샿VWƿF F@    DY F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P= '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 hA\2%PFAx~ t
F`_^Q
h7ss.&udu0   hb,$?wط h*"h{ 1#h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_U6P)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	 +QVW?u% p ux 4  | = <t m;@C
 )(_^YqRWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Zb1SAWIpIyI
WROujvzKMJ; DE<@ ;<<n!<3aRu BMUEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fsX^@t#jIgO GxnQRpA3wۊ9 r Cҋ97wB`s@zfDf3fË\` 	
C  T U S V 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.h@2[+V..^̋] zDF. P .hWXh؃4R  16W  0"Xa Y Z #[  
m\a a _BA]a f g'^a bN ` `hcij!k qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C./E2P+m?n8o7@W3۸  _f^߸^6_>QRrkPS[Xwh?%Ìȁ`fЍȋh
3     p     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10z@ 04/27/05 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGGuu!
kүx00PMl}Dxe``
$`$p

xb:
Oxx txDESxxxxfD@/10y}}r k ;K}d`xGBF8&x}DQ00xtxtyuup
*}iQb}ps ~aU}wc+½*").xjD00q x^Dx_T_xc{D 
T e p# ) ,}1_U
-&0=!I_	P1Tx"p2xp3T0//}@!T^ ^ǀ$ u!`	{T`#8 )m$04`hb	р{P	;G	¯"+u+$?4?iq}T+}'Ư+p (++Ô@]B#,+G
H
0%1[vP7",`]@0/}@jW.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @A
xPxt"xd}<߅}?!" * /}AZ#/00x )xh`xiw  p 0S+;.TB+x+¯0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$OP+-`z 9
sQ` ðÔ2@VD0¯xx7x8r x008`6%06 @T߀G`	p4UFm9A@#ZIZ_150ϙ)4E"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >TxYYL^ZLL&	,]Wj`q!j0Qux^_DND0= >@  U>bgxdp&b]	:<	?Zu?h@jQ@*ARx-	+_SRNx*SgMx+` Kh }`R0ʀ 
0oeQ`
 RSPP1 0X 0Q]pd GXuWxZAYAXNS[XW }X$0Yhp^qZ1ZTpLZ1±
YZ[l0c1\\T0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ"4"7x'D
 X /7d`!7g33TT?O`C`|`07`'`2`=`HpQx]w 6uuuu0k uu0 uu5ˏO$ƨpN`0T`
0100@A"| }(Ex]ߦ@C"+,,E+p٨  +C,,+ +,+x,+0@qx!,,,++x_,,"ߨ-.T0y㧠L721wt
!Mt&Ipd `1g	1}1![tU<!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0" *xc"+xt`
o3x7v0x8W7tP}
0h"[ZYYcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2tx1tI-&%[0& &xpvv ?&xpk[CSxr#$ % % "2x1 	ү  ¯0 $"@K@3#b0"	Mx3C
r beJ"xqOF`V0 p1#" &	x30$0%<T`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hpx`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D?"0p4h3xOlx}@ DT 0
9 pclpB"pxt1xux|"xtx}xuxx|	"xw#xv6Pxyvxwf`Ӏpxw ( Quk}B@
"-`a"x-Pt %-o0p0p tU0/0b/R0h0o../U0`OU/`!!.-[ /0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0!U H U`pU$P	<U0
`Tb" ! R0  /ZP!1D12nѧ2!1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)nvpP*r 3}TOp0@0 0 
ֱ]):Q}0`*/[HP*'2BwP`FӀ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$h' @]Jp4?

$Y	0
	@߀{0-$`
$`$p"Ga"߀V4#oK0! :0!@À-0
   4s	!l2!
2xnfPYo0*2d|p06SU{zy f xovpW%_`gK6P2 ( 	4  E @;H	53o45q3`	t%5544r	@ :0	h0"06`	2A0-6< Lr@1k 
  
 *90 B 6, Q
j	" !!`BQ
p0( 63"E^ 
-NU
]DU 6.
Jj'	@bG+6,y ,yf-e2pO7)0	LP85p
&0Sy		ay	0
¢ ":"0<8;ofpO:!/c)[P3
(.Cxm`qe`?0}DН~ h,go,!a,a b}e"4xqMNOpxD  Pe4`^א}R Vp0
T4d`$"4#`p~}e4xd@P3 0
3 $`3`3$`e$`1$%7$`9$`$`)3K$pvAT nq2c1[0TxvF>&`!	0,w0)%m0Dx  Z30a 3\kP)6P 	@Rи?&j¯4!`p` pJTQ`xj  N*`/19xv
xD}O`&h0{^`
}iT?Dt8`PpY9T~:wOq"@-`T`M	0676$``$p``1e7`tg7r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*xFtpxBB~zxNUNw}wxJqJpȏ:;<t/?=(x ү!:%$t=t=;2!(0 (=$Px`vT"` 2'<x"3y:; 0( ;:@ p0 xvs6QxV86}'p p 7  %76(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(  4 )4 040@O453``/`@$pN~54:I&duP2);P [x 
33oppG*L2]>gp1 'g;P"oT~ +ڵ?T#>үd`pxH 8@2M2P65b3e1@d@>?"01/ 
m
`,R0xA%30 Bo1
@
 u0E00
TDTq@5q0	 3:@a AP}Nt
 u2P2btl@
G0.
@	  r1l0dpe`30!DxFW105@2U`e bC7xnu30 0u3}r2+(ߣtw1123#.1}p<0{ $32  a<0 }
1pAR ErspM"p  d.1BS)x0,u`2:,`e4 2UU.X5%.,*ۀ 2732pha,
$,SO!% *R5 
Q'x`S+0	+_+ '-R	++@@@`p7v@}	 `@~A0y!T``Y_` VWyG
7pDxp/,LDy?N%@k53Eop;OCD߯.2qXTQϠu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`0nX6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[P։*C{p4Iz5z5
3z*+	yuv {| A+ 90& n`AT0 +	al:hpd01o0upo6o,/-.rpF}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p1BŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxfT)Ax`%daz0  87`>P$4 q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxloxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TxfQf/^p0NP -^ ##----Ji C?",u/212B0T-_21Կ^ L.S. 'q,Đ/$7,T{A?O-.`.pGʥQN.E.NJP7]Ĕ0p0Y{))y0h
P5
Ps|?`d7]}OPn,rt7ar4N03`a2Е
3p1
P

Q "u- 0;9r"l  },n1vg9,  A3.02'.pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`u.Ta2C
.%TO.лQNP]03p	 ~`` 9a :b K$ :b)NӔ@6S ? x0!  x_60Qq7prrqxvWU	Xu

		0
  `
7P"q^ +
G1opTrAL`>M)60.T`s@}w?}S?AP33TBDWD  Axj6"@t7 C9xVxF,dҢX`T`HT
PM>@C!3"x)"U\]@0Qqڢ97F 03tv`
pUr )J'' 'BpP_P` qmw0P `	qPa"NO.eB"TO=EN Є1n`=J젊=<A=<aYpo0:BP e0!J.I$:1PJ+1,F;KҠF	D0c
^"CO`@"HIOv30aA!Idp l@0tt A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("߭F?6 0 G=k"xUB!C!A!B/)B*( #UNA
OA
MA
N/I
N+)D
J*aKaIaJ/iJK
I
cJKLMd`NPT&` v0uK K@ 
?MLtS QPHKJ}i}p}~}wEAMI!9..Cf Ô@"TxD[T손TAnp {@($0*E;@B}@RT`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQ HpH"4pbbrAt"xbo o "CD )p3	0Np#Rq! * 	Z\9V NXV$`RQB2b L$BaUӔ@UlOaůUP0	xnZÀӒ ϐ}?U`#`5`2$pCx@%< D4SS [CxaUUT`͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@/`Bpxr
T" Pt`ixo aa?v+xmv25rt4}npt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATAAAD!@b*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAEނ9D potNA8`pC,D
 ȆmT  g ۗ@KL7 &T F87#T9Rx@ZElQ
ha>W`P A7{O0D=Dd
`#p`(`0<`PdP`d`U0يU09NN!ǈt@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
} %xtx"Ttx!TTTaD	x?D@xwTpT =TT	Tx= Q
@TxDp?=DDTxjv0}Ct QdMdR eP@eL`O;K"x0xJ/"xg/L"B S?/?@>"ށ$tO>1$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H琊TY$1	 Q
 I`A  tR1~5HT& 8 `;cuTuTK0T"$`($_`*`-w/qp4p
TmђB  C~Mb Q P"RLT$`6$`!`0`?$apA]B	:3P
2 *}_05 u#'/A
,P3`G`[]Tp]A"T @ dpF]I0$ks `!DࡋWTwwq" T U "P$pR_PLQd`DQxgQ PQG?Hbq@P
pKPoxgv@JJJJKK&KHKLKgKKKKKKKL
LLLL!L&L+L0L@LfLLLLLLL  L0
1v"xqMNO`uRRRsx`}e  /x  "%m"0RY
R;: ܵw"} HGG}0"uS@	0SSST
pTS?0CSP zu 0P/ 0@4xatgvajQ/jxTxjD0@FxƋGxbx"x@$x%"x`}KW}IF	
Q@L0""3@H,xT| } ~ J4Q_
*N`PRR &NM((sMDMJNSNbNmNxN~NMiMqMMNNNNNNNoN.?PAÔ`P/."T? } >00xe@"QfSQv0Jq0pV	@ܰ50T;2uQۀ0K  0q00)	OS":Cm$p
;`!/0Qp,"xdP @e~A3}"~}e 0?IAR3AP>2IQbFbO0M}PE!@JWCWEA .XNY Q`lT0b`ȑ0O[0#0xD oTxh!1?xxhvYT 
AAPB11u32}'  $31T3322@"O0  "(IW "   p}"/*Oۏ0/Ô0/pC0S00O200`"
xp0 "P%x@B2345&k@"(t?3t 2'xA325R4U5B axQxQDQxQ  09t6xpS^vnS CSQCCQgQQR25 SHSpSSS6x
/0!x
tP/P
0/xu
  x
Q{Px
! $60#t #T %Qxs	}TBxr0xrßP2P[0 pw%@$Td$ÞPxxr`1 	^*1^$,-u7. <Tү$`&`p<Po} p% ABp.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxv 6xa`r
 qP 0	,xx
xR!x	06Sǀ)^P$3p 06d2S STTTTTyT	T
  U@{}pwfDA4 D@ @B@"xDbU$P``3PTOW"X  +D "z:hTphO`/AE@E *@@jCEpwUi O~@ w 33TO"B@dPR@xrp0"p<`p}T`- ,*,, F_5@S,  lS,`xevS,,"+,/0,Vb@V?xw	` }wNPIV?u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_5?5,Ӕ@xA=- X60c
+p00Ӕ@@6@0,	`	 VVW
WW;WWWWWWWX
XX=$XW%Xc&Xl+Xz,X-  Xs,6S	XQxu/@xBs1W-.![P
.-`Yy	
x3 t?e.pt e-
``l	clQrl"	ߐ`Ax@}풿}tx&܀
-   bt^,nQev  q}U pQ t u vAO}	}15!`N)qS Q!q]E"P/s0 ,+o"_
wZHXXXYYYYY1	Y8Y?YFYMYWYaYnYuYYZ"3Z8  Z3PXZ8Xs  S1
tt)Qŵx#	e
pp& YD lTQ@ST0BQ
b:Zl0a'SP֔ ZP  cZP`!!I0~GJt(ಚD:c4rKrgQ
xa)1O`KD1P,1P
QJCS[ "gD `E -Pc80.u,,L,SÔ@ .",ҰP#t .`
T/Ӕ@""@
u/$ -$U_"x@| T"5}5$24 [2+[[[['[/[@[I[J[K[N[Z[[  [  _Q	xk`0/_" о 0/ 6u2q(Q`Aa U " 0f33%$/A_^Pe2pG20640!+4d	`d
4FPe"~anv"q"44$`$`2$`B$`J`[$Wpk0˯[1P S_0/V_QR
D	qv3ڑU4A@EG4pS
Fo
D""""չ0  0J]t]|]]]]]]]]  ^u2#^!u22b ! 0#! ZQcPwyA=r!
D\kۀb .uW2UCE6r8QZ/0!rHQ 
R 0 3P2"0"x%0T~t@"@7@P@@	T@3" kO0!xo~ d P""0 Ɛ}t 0	i^j:0x0x!TT`Dp T{!!D`o!T51 7ZxD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b^"
% F`7@0x+ +axqaw+s+I `C0/+xT 6 } 2.uY DT_`6X PcTT`40w	61 ` S 
0cx	+$```9@=`xv 0z q DxT"xStTTH_[+xS+<x, 6,@C`$p#xSx+	x06W0/E!

?0_ "p.-Ô@-ӔPq @
Q=PQ/-$$cp50/NC.I}O.A+ 9VP`@\D>kT ]P-Bp}} bޏC.e.s b9@ $~SSN`R$dp[. .Qs".xt dpDaQ0ӀwÒ/@ۣ.q xk..TP"-.{{ i"p#"x7"! 	ӛP	뫝0@@0 ÞŴd`PÝ@ӛ@*pÝP:;<u tkt"/01234u5Pu<$t}5}Ю/[ccdLdfd}dddd΍dΎee1e1eTeTewewef8f8fwfwffg3g3gVgVgygyggggggh'h'hlhlhhhhhɽhɾhhiii&i&iHiHiHiHijij  i~K0~ %~ p0% pC3/}u: u; u<3{bf4iT330P66
~ 6`  fwR3`0u75u3@u:u;}u<{uxu{]{X$::;o<{&5Սhg0  _2Uh)gU

-K><,@1E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+(U/**81U,/,h3/U1/5H13G1O/|@TE1RBA$__TWB1 Wu2d I'8BVX9$9='U8FGXCUWCIˈEEUL͸GGUo`VII#M0V6/P!}VbhQ/"qV πu3//\Cq/4"$y`p!SnPpnzŸ @@ "@A~G`jPj$j1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@AOr+ 	 	U		V 
 
W
B_xs		 ے":0dx>T=@Q
3ߒ8T>?`dkP?ו>IIPw0=p1;P8i } P' 8@
ఐ|? $ >D H0
0k5d Ep6"}`~I }oP k#@b!p1Pg0ڐ}P@ HTTn4 Yt
佣#Dp!0PAz߈5+r++/0
~IС+2!_$QIuTl@&nՑp0tTA*pyP 
41nll"14PmuB1xe@606
 0ǅ@60'Qk0e}pp
T?T`4"4" u2<}0n0`~~^z0kTODt001p32k2]* u1tAD00 	3yP(P08?PQ@`2UPD2B32ӷp087Pc`&jRP@P}`"aR{3"0PT_O"
070% o03f3@,pe0`!01?2_Vbeo0oP3ఊ1!n10~
_  c`5Fg9 	1DMcA&F=@T3`02`;:+"45675E4`546NP
(4`i77$pTo`M4`TM=`` `'p-n>Tr AE D i0$CBDüf0q BÔZ	*u1au0)'2u0p
1}}G]34Rӝp2u2{u0@*> $3]@P20贠' ac@'
L`1m`2^pڣEl;8002`BTTT%%Oe>xEp0>3i`D
` 
p	0dm`0a1\Q]T?`<@7!?$p*?3t?T9)e	 #c HW@01	a=s2`fO"c"Mc#N$'NTRtUnپU$	??Q
o)$	U6
??u)txdd7eU"}{zy#Wj7u5dj12u504]<t`u/'P#~ s./ds5%t#\vh~@_[tQrktW0ppT0qN`۔L=2t[	ÔPt  q侑o``z4ѼU@c/Gk4373  ~v.((svpvwwwCw{xAxyy{	{||}O}}~~&~G~h~	{ z y4k	5P4F w
QhST{lSp(1
3D,t?~5{u4`u5 ك	]4T`pd` Q?
p0
PFu	Ir	uzLoBmP[|| ]ax<[}} pmi,iiPKß
Np&V$0/Фiz (
r67d6 N6@7"PnRPJd0,v e5p4l`&{Jqw!8*8EU| `z {E` @\]Lvv8999889dp#!#f8`
9#
							@45q0F 3t[c9_8(d`픜!PyDA-0/* 
E0
jZk<ÐIIP2SU~dLpt@+#aM`M8@_ɫq;mpGl`T@
`r/@;ňqdNpt/ ,V+/XPՏYP7[ZNp7>	bUodp'pNCWWriҞ/'P#^/i 4(?Rdn&pfJ1h<Aj)=Q Vv>afx?Mr i},KD|T-`M03980,P78+3? 7v投3"27傐}3+P~ A| 3$`A`yc $'~ 2ࣁ'u3#uxo277 dER t8u@`
_Ô|		q@	Pt7pz9qTT Np: );4u3touq$xe3`3371!`04a wƀYaÀ1 PӅeP31˕axBdAU́1pCϑ2"߃Ӄ}`τ(2"u0X03} BY%.჆~]N0
:>F2pPu2f	opw`8
0:
``ӕ19100! ^xeT`&}$31dtP2"u}`q 
0"""4}t(t sP
3U02	~HTD"LION x9pP
 wDIT":p
"aI~? d˒^ ÀӲ  0d"0Ӏñ }7p8`0;@
D 
~Y,T we8 (@_p 21"1,"`"x0 5"5q"psx 
qUvs>qf>~ 0ab on`dx"j7 u8X`,7bP|  `  Pnp	84gk8$bd="89F;u<98~N98lpe;~ M9E8 `v j@@~+P"~
mȡ<0&Ex33 d ::Ӕ@o:@>x#,	: ,Y=x@A-:zQ R0W<p 
;PB
$ٰ0\=<>?u@`"H P/A(p??p>ÿ?
>`j+@5ސ5@@	x&Tp/"%T~ O7&@{"`"!F"x!To`	TTp57?3o`12D"C
xCp'x6p>A4ra/T(--,r e,p,,~Me,`,,|21G3>d$-t"u;2A&8<9@Ju;;;`P9:@@ɾl56x>FM
 pb?b665 5 	d` 
GG~G6CI"] DAJpO*q+,U
,, +,@+@^j&@T` OFG$&^$xt
 T0x"T1T4TDx!CD@gp
0g1dpa23%3{3+232@
4k`V4cmN(%%q
OPZ`a00*OMT@eT+		"TY!~L` #Aq""	߀F	 >	@[2xp=dPX LҀƀԀi@o3ꀚڀ3䓣łŃ 
`	"3/ߟ$ ̈$ P ##EN``#DsB"P""):0"P%g0 "b``"  )ߍu/33@p " 3@P"Ø"(p p8

r
		{
tQ
X
	


 o*2	1	"<t 
""BBE"""ЃЂP  tsn6 s$ŃŃ1" "%5|pbpp
߂s@h`1p1 1@~1v$1@n1 b1V1J1eP1111 p0p00p000#Us                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  "  %K   P DSDTDSDTX|  RHP  nc6200   MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I`% 
u	913213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[I@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0OA4
yh1Ы7E: \p3 D+Ba(80V1(@pwA5!ikp@"m7APFbA
i9DF17BO&$r8C}j80[+GG6C@:*BA7
@
[+  A8VA9Q AA$AC06D C>0AE
A`9`C
	^   z{` `za 0 
bw
t
	rab.C
 101
a )*ۤT{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` ?
p{z1O wip{a` rb~qAFb yC11	_9`pBw
h nc }r    AA3
ccFB2
7l
 B3 SB4 pBt e {ky
 B3ee} `e Aj
4a{g`ц xq5@p #b}e
eˡ/p !	e e$}`@dAyA4{k
 	``;}qA
 ЈAA y!-Ap?d1p68d ^pA8"9 9e@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
7@
Eb~dB	!ba'c@z!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bB/cnpyacaABw'C`C~De  dBߤb[FB9DŅGGGGD@DB6 7#BB
Ĭ@BBBQBD-_PSW%12ڡB`k (!`AD[(0@E֡ F C0c	C1uVm	V o	o	o	o	o	o	i	Rc	po	o	o	 o	o	o	 t.ҙo	o	o	o	o	o	$N!T%[M 5c#x`0833bý
o[@PCBO /@CC
P
[ہ5   CD K ECFвD`OлD1  0D2pD3z3D @~  PD5OT 9 62oQ
 U0D=:
c`7
 d 8 0D9DAA!D$*/D(D//*/D 'D//Pf!e!(. G!G!@($3( N #F(FX//M E0@ #F   //A eA !A N A GA "A  "c0EV/6BE2g0E2//*.3`03'3//@a0%1a0%1a0n0 a0G1a0G1a0@1BEtJ  JHE5	E6	
#  y  Eh`и``
`p`aspa!E60'E9	@	V`Q	``EA` :a'#B	 p$qCq С	A`v[ODPHIDA_UID
`{|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)H$+b1 r)4f;c!2r)`C EDM 	h13r)@ U[(iA 4r)$`k0jQ(5 r)3IFp{8k6@r)71>8B[U!a42[F21F3
r 4
 <5 [#"GP9uZ[@KF26Iv1(W 8E,C054|zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ}(FD
 h246 `U 5XIEc7CZKFF
048`
{i}`h`?{`h@48{i  {@ 5$ q\._SB_C100tB~ o._DO{Sq	4
` a![^ 1bb ha[Â7ɠkDC^YFC
 G E SSaF
h3À˚rRcp*r&R%$C 

 
h06E0FD	8hfp
` {\/0{02<98
PҐt1`0D W Q   P Chi82`
hA@ \\n8\/	F1 YF5 @E6|o6HI"7
 i 74hj	 5hijkCq8c.5[0h92s 1 0p
Л93r8F2! F)9
^/p´0kl3V+A p8` 2a{` 4aak0aB V Q	_GPE 	
R M
Gb bGf f@y nI10BI10Џ1!P<#3E"F

pC11011 2`
 3/_REG(pipp15
 a	isa114[J  s@@p!15pF16p # 7!U8)9AABCD`,11F C12021P.22Q 3W 4s 5c[62789 p AB*CQDEиW130Q 1 2R33435^A6 7s 8@/393-BC DA3F 940Q q4q43AZ145f346Q 
484 Q4B_INI U4C QqCq14E[  IF @C150:p 1	wh
@axa
db`t
@`TP
a
`@{}a`*
y`0`g}`aa@8 2] azw`
d`xr`
  
@bau .p
53
q 4s 5
AQ18 \0A
Bw15C2D
Unknown 
NiMH 
LiIon N @gSxx>0
  awQjq0B {/1(`0BP56
ha
D1072EAV57@`	9ʅ{}ha{a
//55}Q953!
 C
p^Qw!4!xA15E	@NP An8"F	ܠbBp
P?{`~`JI860
[)h`pP[0F`
csc
  dzi r`a[)absdb1/2J!*(PccC1m	 hg3
qFg
oU35C{`g@`2& 3hC N 20Q24pa4h - v127 w"Aaxra
c 
dcbpbNb,Br	39`a Aa$(`a0-.q-3g3]IX65
I+Ep
 AyW 	ip
Iq:/49."2AcCcڄE c6p0 f{`z{2``EFA984  9H2ccdp eבeez
cpecpci4%4 ?ns 5qp
g5Ap
IBB`p
`D5A!k!22C-@!7G@+yN)0W1EQ-  
qu>/
>3  P2vpzo
 5Wap%*!4(B+BCF`*Pse(a6h/UDD	548ata
!e
bzch!

 

6Baa`i35
@ ra 9PQ paupaHPf:ba7h6E50>U88@EFR=U0c0r?11 [
068rAч
HP   a3B
Sp
SIMPLOySMp
MOTOROLA a`wK9~69
p
 
Ajr (_Q03':Q{BA B4u10b@³p
a4aFw
bBa:l!TZ6A!] B['coTZ3_J
6pn@v
J1a6C
[PR0pY1A 
 1_2 N8Et# 
BDT^E#9nO1169_D316

,
{ (i28Di$ŐS^[H0sFE
70
N 72F:772 s730  q !7 FU 89AABB7Cs D Eu78081
W[  њ81W8388 ֠86888lא89҆861Ua
A
!86M8a89Қa` 79`
A>
 8ApOpi8C8DrA ằ`gcCba?Bc3gEb pa:A
DA80c1}8P ya
 d
b
 bdpdS c
 c
Нc
Aޠ8DB`8E89p`kaʕa
v2C albab`b
vbyb 7817Cp`E7B'9q !E#!AdAWzj
!%FD8W8A=@"Fh#'7qbb	aq bbQ90Q
93ʪ56`61
736" 56"
q2
{C039
`{  ia` `!Bhp!
`!K93	+C)haC0$b cvU09abcA@'K94 p^^5cIX96LB
97

Gy 199 A	A/ PE99d7s97[A;9BF_C  _DDN
oCOM1!9C9D6
30Uw"    }8y `NS  9D__STA +9
`1
2
 ,+_DIS h038d39
F_SRS Vh
aE7 cEr?e)r9C@
_C
w9

` c0

n$LA[f9F   
0
_ON_a1_OF}FPR0oF[LgA0CeM6C
_G 0" *
W~S)![ u2 2K
@>A1 @|A2D8^,o/Apq9E6A]X
I A * 
 	 A6
r
;`/! A1s 6"S2x""u"30#2c[+4 7m$i$!P%`$ $A7[C:$80=0A9p`  0= AA
w."@qFAa԰B>AmAшABuGH
1 Gxx&xx"q)=x)xx) *o r^r_ _u\XQQABQPÊ@n%QQPqB
5Q1QN?3?303<RQV3rRn*BGm3 *o3dSb pAC044pAD4?V4V55 X5uvxp
,] AD"0pr1088!]AE=]7j5]0]&2]qBq1uqY:E)%AF p\/,0sau02 33w(`{fx  !r@z[OC1Bdd$kQBP`X  !B3 P BBv
G``Gpp 2+2CB4
q 5F`2eBB2B2B6[% 7#~ ^"  y s8؀w@ @ "N-[5ah
 
 tPz
     W*"P9tba a U!-A5
0 p Gr r " ` }`0Gd d"l[IBC>
" 0AV[ B")UBDaҘ  {BDBE&ޱO.     O[+$3@
   
 
@DDC06`gC0ADR   !C1
D
[)C1C2 БI{NIcC2[KC3u4AD C[@Q5-a {335a =cr:}d%'C5F	C0C@PRW
	
o[B@C6"l#|@C7ط\/CBPD["

 C C0{`7>C8 p[`GGPE_L1A`D
C0Dz	/PPq
@.[NC1
	_RMV P*_EJD B.aLP CQ BEZQ F@CAQ B;@C- @*E`(ED& 1S	q>1
l9
 7S3@p 4CJO0CC#N


c
,(A_Dc/D $	 1#
		CП						G6C0A6D6!ND`["PO8#9*N_GTM p
7 `ɊA PDB$ Ca D lDEp  B=1E{A@@(0$B
DA!7et10A
 
Q0
P
p
xp!DD}(EY0EDCqDC
C^ZMhT
hT
hT
hT
hS
Fi P `p
w/F>a:` A` bwb
bw`
cЋib ac  rbP rc u`2ab62cEE0bca:6A !{ P00I 3bL-@##M
Gjoomjfjockoa9aPE$F  ,F  D8RB0Et3Q
O_PS0R 3 O2bB8X97	
O# `A:8OD9ODAOED6OEEOEFLpb"\_PICuh\/iD6MT Me6E

piQ5 J   1e
C#E JH 

 HGC

 
	
Q a
		Q EF!	A	
a	5!52#? ".cB%6,!-!! Q3c !t!!G !Aap]64@	F
aR  pd
d
Primary 
S   
LIon 
Hewlett-Packard E~yTraveloka	3x@ 2-5P~Ln 61	0061h`/`%
 

" 
 
]64hEAA5A108!axE5bp 5ha`&3h6 
_UIP سO5F
_BI^Q  ST  `CL=\qb[GP;6D `)C ocrdJ6
ACPI3.	G	gR/005`D>`56 $Z̐ƠA p-&Q_PRA0҂~=81`֓`BE[:@&
 LID8  1F
	/15?@SX%aN#0ej"#9 EA 
 B@ `0kpyk`ђh`piaFa?0EA a{`
hs [}aap`k
  pap  C B ~4 1  &E_Dw x

  E y `2^` |hp}
yjZ    )>b1`h)h`a!	` ib`pbasabcpcau`a[ׂE EQ>F! a ?F0J/ 1iF2 F3 Q4< F5	p5  p
7`

 P  r
O` a 6 7F5eqe[0wre
 
8q02Bp_FAILpapMF2SECUp{AAeA3aA54`^P9bLwUrA}BURC]D-3P
cEcp
W`B
#A3{4
  QEFqt
-A	^0FF2`Bp0201"S2_"2Aa4B  Ju%a%SwIMWa6205&#O b;2{JT7`A10q Ɏ `rPASSA'$0>$aOAÓCta`4Cap	ޑ a14E> ES?;P2CC+abb`a`~B b ub@gN 65;01h<piK8#M9MA]E
xx  q @ Q0_WDG?
<4_c,E=DAAyB{M4C~ !f )AB |WMAA|F1ij=8ItBMn"ep{a6P\zB!-{h
`=&04:a*u`p5r047s20B54
+tphFaQ 1 A8BzP!	
@oq97. A#R40P//CA@Cm;{z/|68 
#H7	3	K4AE!hoB7h	"M_WEDsQ- Q+@ v&?9-*p!-Qa,r A7s8 WQABNFOM &  >:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`LFpq!z|| !Y~GGS t.zR4:Np1NW9B#?U>2Fpz7G	A>|=h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1F0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`lp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
{LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[@C J00[1Cl[#\_GL_yh04BpiV!pjkD04F\C0F1uhFl['{['`[`D

[i pEѽF10 r 112`PC10ph10դFF4C220aEOp{zhp FPk2h7	`E Y2@DD 051i	
	162	P[ED2292A B CuD E0q2F C230 r9Q3130
[ 2@(!23324 h
34@ 35 6 `~035UyA
	`rh``v!F 3732qcаdp
aJac
`rd@ wb}y   baya
a_0apaceraye
	 evepeBc ucd_cM
8r7cpc  bpbgC	bdp apbe)ece ffg
fape`pfafgvdueA`bB`# gT`!x$b pg~13agg7{agpdM9,05A ,P p0`c+`bQC D` u`py)1 C  D "h Bh H
bhc `r Dc`ada
e,2E-adft`f	ru>'adSuc2ftd gr:`4bA n3A F2FFQ-9%8w39`2EaqD2Fa
_INI-A060pibhb0Bp0<3BrWb
DC
j0UCD"DD"bF3E w6
arC019abpb.0+bab`babuaaPo `bua 3_/_CRS8FQ719`v2-E`T`_STA t
`}``6 9XD!

o	 A    y q3F A=[K\/2{40mHH
Y41F
RGGP   @  [  s3	0	  1	41[C\/243}Q [195F
rG G$ $ GN N 
P P Gc c Ge e g gt t;    P A-\/v[	B0a

{
W!3p
`q ^^.C16F4\_S0_
 !  3R    4  5   M\_PTSph%_37Hh
 Lh
}	0pz150&`Zb1E1 5A$\_WAK } 42<11AP%G10D0BQ65X@6@ppTZu45 T_Z1_
 2 :A15
a7
5p4@35bF

Oncbcc:c6C
1:PR1:0p:1 
 ۠abw56j5A6C1D7s
 `?0BA-C1.`L3n4
 ,L\!C6G,
6

0Qnh

ob m[
p8qLL8
QM0UMA
1NB
NC3c40YOF50: 1 22W 116ApT16B
54
1({!h 9! ;4Fii]Gi55
зp
'>0$R``Epi_Rdp	D
6
֒hi5J`pi`?`
p
rg#ip`OBBp57@`phah.Aw52ihr@
!! #8i ` a 6&NE
;M i`N1`9pK|J?Qp\R
   qqt$
axa

`b+j0A0

bts
 2

	P
!
 $/L*9_	FP #YdpGdA(1[p{43){b
 t bbwb

araqMpLa/]&]1b`OR.8`aހ)aR#0h 11$1$ 0y
h7I	{a8b  a=puI'h axw`%  84F<`,3 a$pAQCA`h{h3_
Gb Ac'pM5A
0*h `t`&`x`f0f9{StfQf 1tq"+cbbS+bE&8b!6bbFiq

ep
d
pJ d&`2dT/3e0iYy({,8	B*aYaBa[M  rU
_$_ON_@B!>H^!N ~P_WOFFO6@C
9Q
	DN	
	8	\Q	
E
~BcQ
[5GFB&3 0.5B["C26w*DHCC1D2E[HA_ALF 1QAsL2 AL32_AC0 D"1& B2FPb3f0PSVBSLlAG`m63@hfBEs=(BVآAC8pQA49p
!p
,4B$Z`QQQA_TSP#
dp T CRTЏ0TMPp5)0[G5 q64 f65

,"*3@̱/$QB~\_GPE!
6"zO
_L00 ol0xZBPn <pOI{` ֠{`{
`a &F`P 0o3BӅa \apJBK 1 I{;679 !I`xCBC0D2n}ACE["
d-`fTa3O4I 9 HOH.0*_0?o
3 S/o3%B60RC_SDE_
_L17 !82?`}6@2J+1C C865 FeS{4
=C20B+ԝ1EE!} 
87AE]68 1)D ``E6 D98`Co9|Y67uMC< +$6 GD`!ھP8!FOAW6a82W8OF]59`3G
A]'.!!!`?
`
PS!`19pOOOJL
+	_#Q#h`_i097bc@aj+{a0)1hc{b#:k`4
AcE`D}Co	7FoaHp2E
v66 C016h
 07SSDTq`mfHP  HPQPpc`n  MSFT L489@	1       #__T	_w 
_	O Awj

a64aеBP]C6BijQ C  A[h32Ed42F 26]D_26E!D$'1 J:3031y%jC2paD3Hmj9F
D,bb`h69a_ bub `1Cr^211ph 2rE25q20y670,/
b+1 {y U  V
!1'*[A04PlPDC{hQ720PCT 
1P71q 0	_PPC `QS6F7Yg7NLPr7z6_EJ0qCG7`A 1t _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ          VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by        lʴD` q	                                                                JDBEXEPTNŠDBWAITCMRDCPUREG(^6RDwDBG r^SwCTR ^^MEMBUF)_ɠ CMRSP`IO?PORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESETARGЦ/0UMEޣwWRWRQ
/`]{RQ	A`^WR 2Ds`/1]{WRy	 	T Tp  !!EOP
                                                                < VWσ    -$  rtˌȎ  v$.UpfP.>Ap uWP.^Gp f3.UpW.H@ I O UM N@EB}C ^.@ W^   ApXfX`fSRoP.Bp3ug u_tT.Tp$ ^t?$.^ 0r'pEpD 4#r	
XZfy[`Mp0Np PS tatCu?L7h@ t-u$ظP hh Lpr 	uI[Xˠ}C'Pe
.>^ t
P ZXPw Xr$$
0
^^5 _r?_x   hP~ Γ	ruX0rPhBfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀h$Phʳ X[õ ރ3@$<sAl r.ˠUrOp ` ԣA (tD_rq XPנ"Q!f0ѣ!ES  gf /tu}
> up[P}& / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR鮐<w. [SrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &&E pظ@ P ^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff./.A_0Yu..nf. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
*  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q AB CPDöހQ@RmSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " hZv.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ h[:I:s r p  R  O O 	   hr@῀ h3VrA6BȎ؎zЍȋh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c aci`r  a ee  3    0ƅ00
hz
``;@:Wff > hp
襠 DfPff
fр aV'WA+S@)'}WŢpr;_t[s(`(F?[_^aWf` f vrup6ffпfGfY܂eh R1Xfߊ$
(ff A	S22*OPr'!$ 
 uf 8s֊ҊʠXQ;RP
t0k^r#XPX  uf }auSf{UPfPfXZw+ ]f0)ff]rff~m`e>#n z= srscB
Cb_ 1f^ ɉw @t; *Of@I}kw ; B)ђu6ѩz+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pgs>!f0rRg'QSVfNVFf߸L z^[YrfqXftA3PXQM| N OPQAs` XPhWU豐^PԚʡ A1д 謱 ]dXÀ-p΋_P^Z`Wᐊ f_} mp_p0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@n{
rf+Br
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO 0p`XE)t fat/+f %#fSfQ<g t0jQ#2" aʥUt?j$7 3#tcpզ0
ð-@_ɯWV@ ~WB Q Y_W
t^9l	st6]V! <5u G	F^B^= ts.
<5 = 
ut	>9rF  Xf[2P
X^#WfVf桖0t
P EAr&< u P ݐB S f^cô PXs #S#q$$¦)$P?R)
u $ސ0R C'ð) 1U
 ? 2$
Ǌ4D O$ $
utpS  Y uð迹Q3)3zð&pFa
!tt	*tEPGQQ@QS&#Q"
ǆ*Q[8QQ <t<!t
<P	<*^Rp`@ ZQRs	 2
 Z3) ӼVPލvS<û	 [rqkX2A^a
蚯 ð!R7 $VfW7 u؃ t迦r
Dp<A) @i2@e^PD3ZM|
u|	  t0  $<<q;<
Av^ÀO" OO ؊% ȑ؋ *0Uu Xð2HQVWP 
~M0Xg_^YaQZMpUP2b趿 2LB2`|ʁChY
P'֢/#f@1OëWB12	RN@1 (S)WðT)ՠ Y"5@Z5. Qb	U27UStf r.]/fd 1ir.f% A UCES{sfgf q 3K 11f!u%f# k	-Lr`t s` u `ZPKaЏff#ffд f |rffap-Q<t2f3Cr6
+{t g> tt <r(WPW`Etf uKYf@,
@zˍ^4踎t]?t
Д#rkz o8Y-t(gr?!f1 t
J
?t:R!4g&?#zzc裌@x豍8t , tu
@u$߀2H)@t'@u'-*tp(Wt
 /!- o t> 7fAu2B@[Y a33q 
t@  t}AfQߋXri/p/B/RZ/rGU/Z3t!X@zJ$
 V`{J,脿J$z PJZrQQVQ@0fF3Yf^PSAJHJWJ  [X"J$)J8J2J
JJ@I$
II  衋 蘋 SfoP迋4fX݂Oش ( [SQp}W  I_`¤ %_r o^_Y[茿rQRV3Ҁû{ fFKt
 J=8u 1C^ }Ppw`wf 5 ۨЧJEЎ`҃D@txx@l<N<NQJ !!!!""!!/"""!"G#Y#l##a %%%%%&&WZM.}}.: tL u%  t>JrSN.[t N.o[u  t t_M_.EfUv"v@ Ar MwP  aPXF
Xf]h@ &A ϴaj@!
<`nr\N V
	=VrN .6 #  .t.I.
Lj@s&  |0u ^SV#؁D.d.$m^[	觞ã3j0rcOt` 	OtOtLtD<Nt
ZNtNNtHN

1 u	.<識.}h $ BÁUu	UpXR#G rp
fL\mZfY[ fP<r|wf u
  xf@AUuP؎&Br& ȎXrN ,<N>  ..?> @芲u  Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX][&?a s@ s`b 
  @Cf&GCE  A߿ ffr@AB @SRWP޲ 7ra޲ ECdeLuRE<sfQ@M}3  fYr/>NN.  EGώǿ I./17[7_Z[QWZ.> u4G<tFX=.EP .&N>L@A%50cؕ @َɎٍ6N׹ YSRt5oË]S.q&Gf.Nf&_f&_ - Y2Z[fUf0BSsQSf]ð4B`4B \  <`SQuP Ȼ$@Xu@@ŻXe$׻Htu
I4
<RVW`1.1VtfAh藸 cߍXQ<V@YV<WYU ?僔 T `a&fP > &f &6&as >&upW&f2>&f@&Jf &d෸Oڷf& .&>& u&R"qu@`a V@ \a@`
J_^Z = @Q/V_ ؾ@**K>Z2 Sr" [u13r a 툤%)],+,+za /  ,+b.,+e1,+
!J@BѤK K(K'`1,+`O-bff5+}d,+D	,+1;,¯`[fW 3sA<f,u#荑莑p f3gf&ff=?SCAFpf_U<d
 	<! F ] jW 3<w&< t'V3ɊȈCF`  ^	{  0`nRVV<v^.
wt"N ߬؋p,Bৱׁr t (+]dmUW+P X+s뀚Oup0]A &&! C,ğG, g c+d뙡"& ((0(d)#+-'*%Qr2t"S"=*N@ֶ  蹶["2ɵ"kYØ .67,3à6`Sɏ[PS3֏[
 q@tXŏasɄ3ɺ藳rМ!b`Pyw31ΰ  @X]fPAMuSVW ?  Q+
  
+  t 	˻ʆ rr ɍvKߗǠރ0 ҿ& O 
 30&OˁFUWn%_]v
u` J_^'w 1A6Ip  MB RWPa8$%2 D 1&=} @
2&Gv1:J2v Z2p cu#' ^30ؿB3&6` 
;Arb3f3ɐtfr/44&- 3`_ZGF< u  u2D@ 8sN~ t
Sj[@&fPfS hԟf8h@@^`  f ꠔ H  $p| flw f
艐ā rMf[15f 0of% ;tf ff  fWfXpOX`J_fYRfx f6@ 5Z`PXfZ fSd``d 軗  @ri
f<~f	QPRe_f%0

|k|DpZB_B3EA1v`w9AhYw`f!ft" QBY ffhfa@yWfw fˡӿ fRf3ffPtf pzOu_fZYWryqjWtp ?jg>c>rQa;L PٷB = 8 3 . ) $     0/﷉_Q&GYÀ'/5ǹðd ;{221@ 12q 2 20 2P (3 .3a 3& @ 3 3	 4 @ #4Q t@  4 @  5
 
5G T@ 5 5    	=Hewlett-Packard 68DTU Ver. F.09 06/08/2005 `wK]  Z  l ~@ rq oKBC
sion XX.XX  
 _
  _ 	o~A`# p^ @  A  U10 Intel(R)     rnal L1 Cachea bi2e	
   6PC CARD-Slot L
 8  `$www.hp.com  ;
 `   
 


 ! D?IMM #1N(2L8"\C
՗~&"R2vpb "],No bat y'+"
/_P$W'7_T*u	 Er
yj)Ӏut&  5& A)u&
u! ×8W@ AU\ RtY  vMuG	0bpRu3vuOQtru1 ta0> S:u@,8*6R:EFu ?E0 } jQtTt̀t߀EtH71 F )t%> t:& tSu|Euܱ3  t ?E>I q u	PXuP3 t@X랓tS%yE ;utપ0#)	&2!qP=EP*x3;r.Dv+W+Xu432#*u!.oð-*1!	 2c<Gr<Svƀ Ê,G.#]C%J {u$
<.r!Lu24$`.ߨ2K#/^rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ?;6 %10Ü   EA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xcept1t4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N hAva_ilablJ8Aou` Fault	9Pu Reserved1]0TSS1SegmentkPr n12AtЏ V
3Gener`xProtecErrorpq  1 =  System Ha!P

-XÜPR[< tZ fVfR6
:Fup":/vz>:`cP\:Yύ69{{9t Í69jA69` /9T ſ69J69APǍ697XY_WQP6:$Q9Q9p9
6:6Q;F
0:诳t:]&:贯x:na:WJp;_o@b[Q G%; I1`(0X[S	 m6C;ڟ p C8BBaay[a$at@0 dFfFɷ͋N
~fE F Nu3 }'ȷn ]
 RQP~
XÊܹ /FFYNZ1oA`QȴjY`Њ  aÇߋ`ܾ>"ԃ`> & G> .&='@'d濆QRpw Z
  c Z 
XYZð
< 
7 SQR  ZY[S r  `؋  p 9 a  Q!
 	`ooa@ ؀ `
UЋ؎ ͷ]`a	@]3G
AF `P C0[o@q$9SRZ[` $<u 3 0ؾ   fϥa3So XQs VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAf;v+R'TYX0P@YP\UfWf&`1fWz]tzf_ff_]p_u< uEuPPuVuZAPPE EPP runtime BIOySz1.1 BB)BFBBBC-CRC|CCCCCCCDD<DwU .A]A.Y.Y r ]R.Y
ZpQRPp<rt2[5$ԁ !Ȁ
 o -" ZYP&5	$ yV p[		uR x?uR]{] SUUUV.VU0f	`&n ^CMO CW	al _Z uÐu ~0zu U PSRBt<r
 j ?G_`= 
t<t ).>;D {w.;D 
l  l PQR3uAB$ԡ 3ZYXPS$"
ǐ%$[1Q2a Y`'uW߀t=u2
f$e$f$e$20 $$ҝa VR 'txSR ڊZ[  Z[KiDu?{ iȠ$t%p0 s0
ud&E9Z^`&u=u8qBp4
ً@p 
2} 0UR_&u<藒u7Gt7)躜賜tڱ
@;Z]PGbXU 
 s ]`K:\KxSXYyM M>r}Q4Ys\ Pp% 3Z[x0""߻`"P3
ݸH 螛ٸG 薛S QLIQK yqS
 pN WqM O"\c'
(<PdGH]HHHHIsIPA&` XW<r​ǁ  .G_Swt 
' t r
2[e u0^r!<i	rr&    08Qs" r2.G2& r $s?  r 9q	8 r 	&& rr	ôQSs+&' @>'  sa$esQ
u>[ WAr%p$S r rq	A9 f" $ ӀpQ@	Pm 臦Xa\#t s}q]@tOadt=bpt t
@uQY`
 $Xr`QPPPtMOXdYQPn<O0	`DXd$!<!tO	OO  q&@tPG X0  (`<u
 @&   >!@tA AuqP@u  , & ]XV߁  0`OͿ  r
 P<Fu uJs	P 	uA
 fu	 X RtGTtu`6FtEuUErPRtKxGr t& 0R] Z&Duhq7Y h 
Xuh$9rX&  U u@ ϡ*t@Q!	 Xrr
rr dz wd@y $& 8t   `{QX uSQ^ `b+LH `*C: E8011 @@X@3@*LC*Y    0 " p	- lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Intnl  PCI-As B C  % eO  ֨ H	~P 	/` <M N` c!NF	)N M ?MCD001EL TORITO SPECIFICATION POOO  A " * Gxx  x y 1 " *
x"x 0   s w_X _y\[8y y P\-b é uT ËEtذE
U ʡr0 t
rð,Àxf`!i2tW &  d_&E3aB&U
&{]@ &EL t ûPu0&E@ !fa   @ @,B C QQQ	RRPQg]k tg}
3kgE
P uPj 3    SQ>u5Pfô 
% ݮr!<͎3ɸ  3 3Y[fPfSRjj&kjX蠎֎
t辭t# 諭>v@<t褎Ɲ< t }3ɿ^Zf[fX]V @uo P	&ir
- Z	Q{Qo =@akc
ېi2igu
#p d1}PfdfBd@!+ s dMd5 od	 J V1dP <d;]ttd|d]^  R 3
' ' FǠ  F/R3 .;v+GuBG
`_F/ {@8% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFS S׆[U uPЀAXd]<t3 r
tVd4d8D^uqRWuccs T^u_Z|3&
yt,ـt&M1&G&a>g@g3gLAAAga+Íu 2<ytȃtm
 Q ܈$FKuðWQ
u	ۍY;Y_uS؀uSCu)84  A  @3fߊ$f
lf BRWS22f0er Nu=8s܊[_Z?fQWRfP
t)P0裖r Tff  uٕ8ufXZ_fYPL r3r: ӿt+a4 v 跔
t̔8t	
uY0	g&;t4g&Ct,g&Cf4`|$<vf }f٠
t
g&:#tfC1	fSfWfVf޴r7fg&F 	f`r!f`Gag_&O@` Nb O Q)f^f_f[Ã.zMt'}}0<u 2ԋhpho1qqsw;s腁tars
2  憚"r  |  j .Dz.D
 U~ ``XW&&D a0 м ` j &&E  3Լ{1QPTP !XY`.\.T	ώǍ>.L` `ca.D`caQPМPXX6aTUUU P@} #"U-RRG      *[%Q	  ` ``Gd d",!  qa a0O 
p p  Gr rrs sq]
s" } 
 6r@		 
 Ą"Σ `q u #p $t$?a\h@ & rr 3ua.Ya3\' $< u`L:I<u	.Y u<` t$\   tu _u	V $
s4 qf cS@ u7|`P:<uR[SPUNNNO Oطl$#jc#j\[[[  M G0  " *a&00qq!0A~b5c']0 U"z,ÓJRQ%̺ rY U  !Z @Z\  u(<sW .n\_. P|ûzP'Xs׃Q_\u..&+.	p^@ t^P@ .&u @ u42..߶
t wPUU**p&u wXY03P A3.G
=XtPc^ *.P^r WȎ7^1^_ ]	^1^e^h^q^t^{^~^^^^^^^VS3p.:]u.]K@[^* UF~P]2SF۹ S.]F[wC N[QF ?t]sF2~ tY@ 7誁~ `  _ ø8苁 膑d`dt:gAc`0\: 3`:$ $È________`d$!<!uy!!`& t"&& x<u&  V<t @}K!D8t( 2 '2233p^f>t" ߃P a2ۊ( Ҋp ) ǊȊ&)  * 븊跊* >+#1 d>,w0.- &>) r..PR ut;6X6 6 k3
t,=
 
"=
 
0I5w<t<u FÀs<    s
Ê& 
p<uaw\wWQu& ` u8`!A &
ØcY6 FF;t2aaaaSA3a\"c`  \0ba3ac]`a[R]MD]EP m]`[\!'\\\c\+&t\ P|\Z[ ZBZ  
1E
߃ t"6zMD  [ ݰ0Evv@U I2ZMM  
o$c&E
PWE   F˭Ҥ>]>j
  D  P P SpSQ    U	 Y
 S wS`SABC  NRP RQ SR  RS ST  RU RV WRWXYAUZ[\1]^_  b` #ba Tbb bc bd!eqf AYYfYXcXXYXkN1a [SQf  VF!PϏs^(2۹   F  +^D!8kum3\f^WVQCuKEb! >`!0"w $I^:u:\!u Ar讏-Y[_Sd_ZM.pvy CC@@  !E#u $
`&aÐ faRМ`t$t ȋ@Z1~a)uUkK #E[$;`6PRZطð$0<:rd u}P P H  = fPfr q& fV: fgfFPXRyZÜ0tw	tv
 vt[ ؎ Ѝh'f3  SQNB<tt	fP!XfP BvY`&5QfRfVEE{faZfYQu Y<u,fCISGu%f» f  f  '.>Df .DfßQSWfp&/ r)v!ufPs ȃ߀tā_[YfSf<t;f3f t	f 觃`)
ut߳fff[`
 3|aC Q0g0/#}0($0.$_.V.֐.
.-^Z!R0.q'2.0.|r $lqbcZfPS Е@ (f.[hhO[R*:.[hf`uh~Y h  uhņaúB   $"wÜ.[h|u݅0,RVP
x 拔 tcPtt>@ KXSx$P1Xr$
0Qu!$
BB /JJq4HX^`Ϝp$ q 9  3Ҵ )./@32ƀnuo nߊbpQ'B| -  tnǐ.uﴀô #ۡ S3ێۻr?4t WQ jf01P_QuXû uTf`0D 1fft;  Qf3zY,6g5 !XRO -@d <ðɆt  w ZYJBR"<t$AJ_BqpvB`rg ki &  [
d@KaTUUU	  " y pys_SYSID_  l UU  fl f@f=  uKp fl P3¿x PeR5Z]                                                                                                                                                                                                                                                                                                                           
    S    -%  ߁DX' p Jā߁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.JMZr# Mu 6Lr pt 2rXĠ	 u v thr&3&E0r_" r}2vRs ÆUu
FUF ô	f q`	 ӥ/2	rg@e		p'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.߀u E	_ffPwEEabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZfXP'F#~r .>߯ t7  /{r?`. t8   t t  2SrV ʀs=`,RM	p JM~t$` t u/~ǉ~ %"NV 1	s^6N.|uL>R..NM`>L .:UtaRMaPWQSM? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>߀?r.u|
Պ Ѐ ʋ.E;v j'fVfv`$dD @؊f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZP$<~ - r!P@Xup>q @<@0P  *sXXty>Wc *y BQ	?Q	 QV  PRW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd ?_^ q QP&:Ev&M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tߴr&tptu
ZB\r rR$!Xt24 uu@uu`  u2&fPS `0~0v[fXPS4ps(Mp`D
>X`?D<PƋ4a`tߋ a1t!$!"wq1&~2PQȎ`SwJr#SMwO "t 
`P2:Tt
a YXÀuOuQ,9a"   <s& ? `P93 >N}uǀ   zMt| jMZMVW_<uW<
uu F ><@g2<t.$S[M[|u|
`g|`it\_^FS`}
u}	 !.VMb܀}@a`>pO1~uD}?a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf6\c
bPZ#f F PXpZfP~Đ=r0&pw)Efݩpu fau}Cuo~s3SV|t` t t
^[PfQ
ߙ 0 < @f	t` vTaif`ffQf i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+fofa1
fP4SR%Z=Q<$ o P@AfppffXMRAZruA4Zr
pf`P2ǜo4XZ[fWt u>
rrw`Ua `WB a p 0`ccQSQVf᣻ՙ}fPh  Ui@PP  p^Y[u(PUFP| ^	u<Vf+
Eo ` QpLP	r=^ uS@]#^[;u"

 
 ^~u.t Uj@w`V	cL
 B8`.
{u&* +uA·0$_<SfQfV Á=Ut<p*MPThY &Ep` `&ufރ1   \f^fYfkSUh &]S^ ] $!&&DDV& fȡA\AL
^yr fWދDVЎ &0 f~`t@i0Kʃz^~0 P P&t_ 'f=@_'+a¡of;M E p  Wf.`	Zg&G_E!#3ycrR-uPTPf.͒Q,f_utf{`@]StQqY fqKodfp,  !f p9I# ,i;1!U
UEG &E"rrifaޑ 'rnOGw|P_@0Ъ`Pm %ߎ`1#0a \<t/Q aY<pD%PH
fuސ f ma` ߰?tY`v.M"fNf.͒g
Sw -"|"#:OOP9DQ:	: ; 0M;Q.:r(G)uyD > )uf.7p ђ0t- =*VQ$$D
~@V&T<^30Dory9
lY^C0 ~u0]x0ߋ"VBqEvf;@*(A{DO(Τ8PVPWSPWQNP
P@EDLtDra
fNt;2KWpM T;0@fP: M^_1PTN?:j=ffWfQQtT=M
Pe@UBLOALBRL3S }GG^WX!WXV1GWiG@/(WLWWHP&	3
7uO`gdOp%Obboؾ:!Q	TQbL`#SS.hS3Rq	)3AUEfd#S`e_W3n `{Dku_qnGhQhhRV'hh/hذmO`pjj|t= cYj,{A
1$pf[ jPQRG B㡀u Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRS
 r
R3҄u  tZ?@ PkGXWAZag@ 0 P`Юp mRRWR4Rpfˎۍq:@^W	rf+_ٰSfW.ܘuO [f g&$fD  ධʋ? 2ۨu<@tĀut.z[˸_ f_[Q
! YQ 8  ` PRS%o` +ð ;w[ SRW*׿OзIr 2 {3_̺Q,ԴAs` Y ro3O:3!RQWSP b	$찂X Q쨀t_Y3l !`@ sX Jt	u}RX( V_`m 7	XAP)?[_YZà2<UuX
8
DYJ݊Bƃ   brT;
!uP P2
XS@
u	 諐  *ê蓐[XVWQPvDt!WQ:t
Tu8v
Y_߃ԠY_XY_^ _SM_ P_DMI_ 1  #95  2XPUv F t	F ȿ!Ff@]X"X
ras\b&D
V &DtH  
B r!0rs9@!uF.bf$UrO@sJʊKZ STo`8Cr
r=`yoiZ2
 0
FFt N fF" &'BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)ta r4F$
Ft+ F P   !VPXV@"aëWN uޠ	ZX_PA>`P@2p n l C  Ơ #  ʊʊ@zʊ2ҡCÿ
`H,pʰʰߊpʿ$z(øm
 v]ʿаV	O2Hs s	2 E | 6ʰ/ʰ^ (ʰ	 !{2ʰ2 	
Àɨ tN :4ɰɰɠx$ 
$0 Bɡ$2
Ð+^_32_   xf` tODu (衺 !`,aiô%_´+UkKfaPKМRJt*E u5$t0($< ȋKf`a
%D		幸 %` +ٹ$Ϲfa r脐<
t%	*P' @ޡTO xOy e*r$DIsL:  h                                                                 RDS@  q  O IYOO LUvPQF X .p	˸ q && f"  и~f3 ff@i.<f.:p >۲` 6a  !.P f."""""J ! a
#
 
 f3ۻxgf+ߥС f`ffWgfǃ#Eg ^`ܺA vT2gf頸ogƃg u	f@w1 f@f@f_gf1 gffgf0	arfQ@;gg&fGfXf7~;wf+fa f7gggfb	ff#f>fa
Wt@@P	3
y
ff0
gf3  P
@Cr@
A
@  gf3fSۓ̓ Š΃wff#b ffyZ?'wf3f30n,;wfPf#4ܼbf[gfѾ p2
ffP	c	

f'AAXAP
 #W!fكs À +SfVQp g46fFC3YQ  Y`@.f^\ g&{GCffTp[PfVfWfSfQfR
/fZfYf[f_f^R
uWf;Pf`Ȁ 0s'1 t-r(@tD<u u  faUQ	U F @ E] < t<t
<t cH`Y]p4 RPQRbfv2 >H ^o~#HR/ZYXɓ	Hr3`	x t`-  t	  ߳iO9`Kwr=sPȴ + "#@O@\G18P,Nfѿf3u
PL% @PQ!!  f3g \If'F!b"Xth$PPTffm`U^F3&\QfPQXYqF)Ya^P'у@_ yFP!8 #	kFf<t`L< u#f$!DF~AJF`-FfaPظ䠄t"
   u$!~ !tp &k Xa{{ݯ *qݰ Jc뜀s@P}FF
]X `j . j v
)Mf.N. tI4~r@5p3؊^)tuw t&Du .⭋^^;aϠ~@t&ڃ.^2Ȏڀ36t6^2.  @ PSFg
t'.:t	tX._[X`P4
Xu!P)<Xu @Pta`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋy赋_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u ~rc_wu
	A	πϠt&D@B êĪǪ׭AT0	VscH Urp蟁sʁ `-su fqt
E$藀Eab&G )
V Nh8Kr>u rG P۰o3F) r\ {r=H r8QWss#

Rr
3 s@M1 |#k##'F("r#謲Qlr@r?k20!0p ×!r"!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uFtt0b]( ތ м  .>&gG-a1:Wr dt
t4t p掊跖'%2撰PR[ W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PпXN8NwN 4o2NO0(`00s/ mlpR
 r
fQmru$贀fY_/Ø++U+Ñ &u btbrq? VQB  ?BY^	G $s
3
P&u3` @
r
%u@,àt <q66V&TЕup 
*&u^ô  豇  莉QPXuN%&:Lr * ri$ P @uP<ut.?@ p5 ; E q2s2p$<@t22P !$!${qXw [[ĺ".Pù[K<P  = sffP SQ  !3Y[$p
3 Ff 
۰N8tSFt f% f @f t0    "   t0@ t	@fX
PRV s Z!
J
8
20
$g4 Nff`4eA fu4fafFDP2f tfFP; ۈ^DPm fu
fWzf`3y#"fF$QiF,0 AsrBr{f-1fv,v0h],-u(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfuր  p #f#ffá0 fHfVPf#f@f+¿f;FLvLfFPf)FL%	ff{vAfI )v@wf*ݸff
fAN
X7f%	G,sfA d!`
;Vt
fAP
Q
y6"P  f%"w f%  @"	 "خf'F000\2FR) !.PSQR30? /ff%fOZYjPQRWS
t"X  :/
/[_ZYXS?[  QW /߀@\/ _Y[.{B/pû z
  5u
 @ @u8 V0  ;P1r F4;E@H0P 9߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMOTOROLAVPkoѿVS\~ЎHo߾/5P-s@^s˻ʆ" >5s>5~ 5 5ʰ5@5sSR &
 3-&Z[>5 5%5 %0? t
@~Ph+؋Òc"5﷕Q@	'5H	)5?`
+56
-5-@5$s؎&3&M<St<Mto6 6 
6^߃V/n?Ov `!*Yr>U[ ]x U_oaf@-c]rcUe<g3Ul( lgiq>n p r۰tZ@q
+ 
r)>T5&~X^ádWV2.GF< u^_J׺+ rD.\J0ERǊ}AZqER.ȊpMQRR źZR  ZYolR8AS؀u
RRp	[P PXE%
cE%	X< $Z	T
 
"
tg`gVW_wZwU
uQ6rEt> r2
tC r  r  
!    χ_^a1n2
u[rVei1sCr"trS ';Wsr6"Q@
Erߪ? S֝r)/$$e  
 ` ]Pt ҮK\	\p*P')0\;#$ rIW("  k_j!P7(B O55B< t%՟@r4;3/r!- ,-΀Bq;3ɰD@D̰`ó sGADw*VR@ ރ| 拴  t.Z^8ħP .;BBBX$JJ2JBPܰ\ktJ cXOu` Gr V tA&q JZ  C@A v*uP= ]Xrù2	
 ߤ (8SQ2<

2ۆ.
${2rqd{<w0
u@ ]  ` 0    j3ɍ6zM.Lu.:Ls&3.D}.L~s?` 2`r2`@y 2߶jP߶Z u K=^t
`3t t
t
u! 腢3ұ u I t>N.|` .`ׅ u} P J}uL   u3puv`bW_otURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ]yÅ Q3| Ys. u&	 t	&Uu"r ώǍ> |  Êöj.f.|f@  3.|4߿\PQW 3ۍjM#_,`zMp1(v p;`3|$腠 &?t+aP`)}
t 	
t>L .:UǀV tMRϢ+Z| $p$u$$<t} t	^^ Q3䆊!*Vh N| ^t
.uu
cs)t!FRڻ0W۵u3ێێZ
t	'u
u
 uu搉@s+XPt ڰ`V2z︝瞨t"@t  p 
 ް  XPJXSPc .+. s#. sXP諞&   &X[ó5P϶'->@/HAC  I@ σD
 uj@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& 	_3!
Pwr ^	
F (|r
 	u^'Ât %1+	d1*51}5r0/5Mrr[o[
u< r<0s<"N@PQN \

u' 
$nvf<0r
ݠsus><Pu.
I.
MȎ.}tj@&u |t
  ^!N%V#~sFPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 ؀	.EFC
r]wsms1I9  <$uw2 *<#"< u<}@v<%p!2 Æ ]
F!UF% &F4~R=r&@mv8fRF'P^S^!S&EF'f&?U&]rQ[P@ [`fZsSQt^Ë^6lN	Aؠrf;	DE蠺~(LuTMs0]fPf}3fXr1Q}N.  .GTAf f "./0`3V#:Tt`<~'t9r0l졂EE&Nq<DD@ % 5I~@~6N 6u0fPfS&Mf.Nf&]f&}k 
[!
A0'Qf*  r}讵rxL} =rl`x5rdPtZ+ٿcr@ H u~ (um-VƎދo^@tffmݵru蠡 Y荵r)8r$crre	rj蟵PTPQX rpw
u `fSfRWBt:ـ?f.EffffAUffsP-EMƿF F
tSuNff3f   fVoN0WP*f8f'w*f'F'*2t*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]s#   rRPR跶pPӊB@ ǀ ZXюًw 0oppB슱`PQK0% [ĳ m h謀 Bt Z^N軳rot
r`a r[v_">lN fKf <N, 3S5<s-NO8L9
t" >rNG<}P#<Qg$@ d6NPQ0X h   t޲rzvru3rij`wNrWu
p`dߊع 
!ʲr.ǻ%a@tt t	tCHq% su~rt	 2PޠRF sH<t<)t<(u;ь>A u/WUߍ>ӽ`x]_3r0Cy`_^?a'c $PSR 2Z[`ÉRFtN+P X7D	F
+9CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuK-QfXr+tP@P3 Gp1 tff   Rf+IYÀL@uu$`Ύk2t
. J^G fF! PXPE t<"u<"tlV3޾x 4Q&߃?s0  s& p  &_G` ` wG`  в&O &O`uRp`f&GG`Pa  5AWQb ]b  Wsa,ZX7RQVW:WtNᒀu~u .!w6a u/A ?L	
 t,6pNoAOGA&&d&D&t&ƟD3p;k_^V
ޡ} "] uRPN
  ^   @ TPQ@RP  4
W j 䎻<
1BQRs귄3ɺW?@[P.
X `.afV`f  
u 	rpr"V s  ʰy6	pAaf^U쿃`@*2$ԉNT@׎Ǎ~WF$
&пFG &U_غ@
	 `aP[,غ*?3% p[`>W  K t2_R Zطˀ$0Z'`  `t
   PȎ 6(ںf  T @ DXø a2r$<q ؎f~fo	R
 b cr&d xp0ff#f' \f 'f.4 tf}f                                   0ؾ +>+۹&۾  {36a \.6+0GARRԋFf3߰Sɋa"fV$
Ѐ
tf`T莋"Tv腋׺4%@f/f2 WfVa  {gxtgGff0Xf'xf o  L	gyR#f^f_ Wad _IU f&JHMBO;+N #z &f	dâ&f>&
?uf 
  &>& t&?r_VOu0QVpf+ Qf׸@ Yrf[R ^ f>&ǿuIf0m s@ &
f6}ǁ0 u&Prr` > SgW!`fUfPPXZSqTf]qff]rPmn (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ|X{u2jrwհr9_2._kq G$!wu@t0<zw, 뭋 
t

	t
w
 b2]ϗߵS?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQ~s	}:[	iEsSHP  TPRuaa@uXXZXp! / ]PXn@Ż`+= sr~s
0{ _ ߸^ SQwtt.z艾 ! !$諐 01{QjQb;˂QN 3۸ K PT'  A G y   y " ËEup
$prp`tW  d_Xpa(    K P3`0W%,..s 8 ė0fg&'f  _f@`$<t'<t#<tN< uc T M_ H<u 5  ߽%l  
 aS #AVW3oxu@ G	u1ҁ Zo @*ӾV j1 S!؀ X#[^RU$	ppqu*A u ßHHB$tu 2a1$Bq  D	0deD.Egg=FEFpFFjjo@0 *TUUU%17   6  ~IG  #"6! ,@@b Z.ᘐ}W. ?mf3ff=SCAFt{V1Gffff Wuf(#3tfPfY0 Ҙ@  WfX   QRfl f@f=  uf3p fl0@  t@&?   P  fV`ބuwwt u3N@f6 Vwu^ uwuw@N`R\p Sh	xtE exuowwu{wt!wvi
p 
]]f^eU  	   !  pVG$ $  GN N P P  Gh h"Gt1$  0G   
G   \$    0    %`r 4{VqfqH ~<`>0<pC l<c<@%Z<	;Q<
`QH<~i?<6<
-P= uX<}`< <pXL]WfPCI 2Vku_RVWfSt$f"r f;ttN紃 f[_ffp r } u
N`o\u `V s r 2䰮RfPgjȝfXHjk)j\jFi5	iffоs{"s~  `f&= & sϴ c&E JX} pfPPw`;t
X2 *W 
_ #tX _^0zÃNp sRQiуuf yTffgzff P8s2 YZø8 "it32Qi &g +  pa 0
u
7	@7`I]2ðq  S\8&&G &G&GP    [ !@  0@p@p\&\p @F0 ]
 ..3 ( и^  2P
C@@ XWPZ<w3t u*p O 信$ v! & @w_d{@P j{{X2Q{$3W1    SfQRb۳4!ff>ufQתfYg	`A[ø <Ȏ3`Ou? r =D`=Au@u;@ u39 u+0?wuP@u sXuw
_ (f@u誩%]{A{N.|S{_'{W@Q  {{] {(!q G{P w*{t\{Q   A0+{f{p%T,yu!uO ǿ<2ee]
 . d `5d{PQ3 }27y40Trdr
` r`f<0w$PIR  A&i j b oc =`r j a       000h
`3. Wp
_ϊͻ 
p aKVWUSSR`So Z[RD-[_^0RW3ґ`  Q]uL`GY-h ;/$ .  6p.X".øJfUfQ ufVKrM u ogf@ N V FfYfcu(gfFfpfhMufY2f^0]Ë< 3R+fQSfVffLfT bDfLUf^[fYriXt	A3PXcøM0øN)p O" xQfVUfWfPJwt3  `fRfZ6nP_f]^YpPfWtlwtQaLUPXY f   P YXt
 t$4wt_ t! ˻v nX(RfVt Z  (t2Vfaq0Pw#t r{ $r	 f^à; wy3@%
ÊرS  e   x `fV1~fa.6D3fff;w	rf;Ïw %CS.- q"  ?upf%3]ӎ/aRQt@u$9@ذ18tr01t= <rk3_f@ Ӑo=
fʝ `rwfɗf-  ʝPoQ<RW[>E3&G;r_> <%<t7 p! 3° t	tQ /f  f@ @pYuf@f`c4Z4f4f  ,P@g&߀>tq r 	r
  ?u f_^$f tt,$
g&"Fg&
FPI*$
g&#Fg&FJ	wf#F	Pfa
`VvR	t#1
t.
wt9twtt&u&U2
~	t
t11tFt`
t~g&`
g&-@
p
 
u
g& 
TA1p a3R`\&^Vq\QU@ҵ Jr* U4.:f tTuH.V.f{]$PMM Wl nP!#  P efPf{f)fXtjwAkFPFfWg]?rdbߝ3SfYXF]ge333ZrVd4Ad^;sgu` 
 ZsM tAt<VZVdgį}
^` VWd_^gEdTg}+[
Q}gE `tr	 	t}d8tW<ytu@D Z
`PfUf]3
t縅 @Q Ó' b.;G ._
u [g6$+' +kD  ~~~~l|8 8| 8|8||  << `  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp	~	 0``0qff1$0xx00 0 wlllll  l 0|x0f 8l8vv ``0``/`0 @  `so<<f0 0  || 0p0  x8`̃ <l 8`p  x@ |'pH `a
 
|x  ff|ff ll bhoxhb `f> @p <x p
pflxlf bf  ΀ 8lƗl8` xxp$ wx0  Px ׌2 xp``x  xa"x -70Ax|`` p 8l`0
O v!`lvf0 x  `b  ұ  !T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
1ޑ u`f SvN .2[]SWQ  ktуY_`W N PSR,غ:3%  Za T?AE eMA9Y.nSSK  ;A^( p`
`3ߴqĀu ?N ЙD蹘QYR"記r8r蔘r
2:6 v腘Z aP fPCI01 ISA#+T DU03COMPAQꊙ 06/08/05  < ɞ    F10_  m؎h Ћ㿂_h+3f  Km L!$F10fPfSfQfRfVfWUfUCES>bc  fB  fBdVc   tVc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  AfBdfe	 3ua 6 e< tf3
@Od>S e  pd Pg>pd;e `oef3A3@!t
    2 1@b@Pa@f00tf pߨ tQEpYV ^ `]f_f^fZfYf[fXfVP3>f t
	RC &ffXf^PVW 3W P__t
r
>Jd_^X \ɰޯ۾ݷاбκm,c-DD(|1 8     I50  ``6~ "!A8>8  B9 .@'Yar: 7 @;@?i<@_ &3?$	?o	I!!
0T!A>q

( )))**LLH#E$$E~B ~B
y$$$@ $
  >""sZFYdd  #<r 
sM` ?hx"'yPQ<R!2

	" g %8 0 p}V	

$o$D81 dZI 
!e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGłrݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉEċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t { S   0 ` R 	i D  =Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|{u m 0
Fq% pkt?   !  % )  f	! ( 02 S   `K00m) BFLXp0t  dEg!<"F 0lYpY.$`"08D(#ds$A|   UP W F  >"6>0-@  {?~!BC ""!B'  /!B#bo&2 //`    &2$-aLX'>9p1@@E@a!!: ' ( <'Bft,0<𰅇<` *0`  ?qt2pC ?Bxg ? @Ӂ00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l==   M@ π3` B?"#?!!  8@ `~: 	4H 8	  6 a@)1ppp" `$!3pHBQ0@S` P0ZT@L@\D2?"##(R,Y@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x dc $+Ph` @@` 0!cc1 $2&f# `\;0;@lxx0a1 
c
AZxp0!
g
  Up!rE  @>>@@`)X0$x|pTT T8 PcCQa- : D^b0 B`c$c  N $484(d(lD*&1< ?! ?&!<? !!# _f4c{ijv+ dDs?|e0v0 !"s 6`S!-cS,t. T8$9`0pGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@` F0Vupq@ 0u=a4`m|sGXm|%o38"5U QHU' &@'a! 3o?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!Ϧ## DEB`@].A^z! nxRK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!?}@ @Fq6 pբ66@ƀy9N@0ya؈  `0%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?bO < @$<}b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5' '-恴p7p^  ) 
8hRF pà2qq2DRD" T@""z" ""sbn0 `CF`  ||~ ނI+E`<aBzd, %}IH}T! 㔡aE@AjD0p 
 .:23V!&    B5I@v  `2"R`   @N!  0`'|Cd p>5D ( (H H  0
DP6NOeߘ  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c28`."b4`'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	?#`4 c$}R S SPpP O!
(#?@@DDD@"D?0!c 7E u0DL|(0<qt ` O='4КQ0i#!zM0 `  ?!#3"$$!?!#! ! ?~Rydwsλ7  H 4?b2C"c9yH@Qn4x<0	`Z ̀7( (`2)v&9^?0JbW8l>/&23
~b21G#n0  !$ #L`,!3p$?Aq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8`/A a ˀ4 usn# 8ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>Àǒ)jP|D52D"DvDTDD6 # 3a|bz,  1Gp#\  7ajė=  k4a8	  6 P>Tڅ  ptL D@~@Bf$,8?92k&arg@eP 1 WpxPX	G ^x! 3"&,0@JoD% 6}PU<x @P8|	(9H ;)*;*$*%+8 ?T?T5VdB"pa&b F ł(x; 9~%z`6U0` . `G09H~s ց 	{ d~@*H  ~K6cNCc4{8x F?~!BC  #" e `QP060oo!  8!` "***" /"$'$&*"$
"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
c =I H<H$H$I$W=@ @v 4R$ze bUS R P|7 8y0 ;)6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGJA\! B2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#.H	TTWD? ? pw 0,0  ""bp $ & "  q?|2@G
i-_ nF:@e$ a  8@
#]](00]V?$P?			?R" N8S;8

 ek| 0@	! y 	 	 ! o>""	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDTa C
w$>?  '$!$34, g A#A N<8`hO `&#f!b6@2~Z*\*jI0 bBn5	G x ?RRptF H0	    	  a |$# '!b[aaap5 2zasR0A: <  B F>lxPXHL0F`Cu@;0` 2Ǡ00b64~
**hH$lH UIHUH~HHQHUo~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@>#t40G zRs'"`7 `CD  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <<1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR_!q #  j   "**~*B  h b~B$fiBFD0@ @C`@.AY`M`  I2R2RR 0_Bb.	4d0.t ""p bB ?~b
(LA%ɧg󄣏UE``AC}}8@Tl@l$5?b5dk >qcQ"tdaxR4䣄	(	)	) ( )H	ߖp ^c 5] 1 aA#?~"! "2&460ba0"`F @"{D1 X8@ =@0 P` !bF! °?(HD>!"? |?;" p?.a ee   	 `p13"fdŝ Bi|"@Acp>@$	,	(	88(2l"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PPP`@   p   uUp cuW` U `	 `0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P S膅SP!bRV^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts27a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F. u 2 4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo._61FF!.W_tOT_G-p
QR.6`1ƳP ZwY[X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13o!a01.>1P20X2$CFAPQRW ((_ZYX. 2.9 t.l1BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>f1 t3ػ@ .d1G.f11OO#0.d1.wf1pd`X@Y 0..?1.10;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 MH
> tj6hjFT_c&  _hE>RIWz2o1c% = WۘWb	?g	@v	9B#Zr
$s
|
AJAfafffϢNcOcmf>JdQjut$WQ1}`	\		cR		2rA	
aZUf	a D@xrE
C
5J"Hx
R'[}SF _"3BUQcیB b,1-,gPq0is0|0~}"y$z&&fx6(E
{^R3c**%ct;j9<<= b>\;@bcjQB_d$G"_fh  nA tAt=Cdtfh jnCd$_/!~qtfhkLBG\q >tSet3 tE>p6jhdfjhI轤>" 8%j h"x1t2>e t=efh1}Uf t+f *$#f3f
ō~f PFPh|@Vh*g"7, YQh!3׉F``H[_9=#2hdh d7xod V05&	h&f4ƀB%Fİg[cg	tA}HccRFBhbFP6@ bPj>h!D_
	`#8fhafBX4YI1ShcflVcO^05%h01!4 V]EM*hҗmh
$O	QUD	^_ 2FFf^ F&<
uI) u&*V_&8ftFFP9 1FOuыٹ F FIuwF)1 F*+҉FVrg+;u;uàsg% ;Fu	;V@árogG2@UtA99vg% 
wwL*	v
 WP[
 Ffj hFSCW'-y f f0rg0 Z&a&cjLfPv~@[j`PQaj FPQ`2F`P"V=ut_ V (#GF| `02:@|Zl h & F GP	FNuFG0?7S 
yOt+HF_ dPQ	 w(wFR;v
2 1p j1y!A>UI
Ubf?R*3@6#"®r	v	$bĊ2&c% 1c ori*Z

91
Fppuq-&c53q?3ȉJr	
/c耜ab`R	 	2&a% +1a1 bj_Rûv3p%2c%  [c1jA{T 	a[NF2`h~ 3ddKjD
 E
*
C
 @	H 	Na(g|3;1 Kji]	&jS0
 U@Xdj~%&ddKr
x
x}tt5f/ @ a c
f&dFt1d@t#y:FA
rP%TzB)& dZR1{b9* p	/cjTɱ"@&!@dwX_&@`7 pU>O2a;Z_& &O g p 8[FdW 1L
a ?=fqLd +t}JQFp<&z>> bx  p^PqFrg^F  ^F&F~
r@1le?&be &` ߃&d^g@ f@ "od@ Be @ e# reG
A/ԁҒ|@PT`E  p  Vߋ6в^aF@t)td Z*tT +uN&lebe e r,9ʀtwp"Pt ߃a d
+%@@4
		! t:E)1O
duUԑ+`2@\_&pd^  e`!PgbOd !r&Bdbc=Wofmt5D@9".1F{Q0  &Cdw.j `j  3
vwB +#rS~WFгT
-d_B&*g(&Jg &*{gaz5&+ +&,C!&-.&Ƈ*gd r ͼehJg0:ZMB>cKxK@>e&eaFVDfAchja&fld	s$npa rڰtc;rOvsА):u1e eF@tCyRZj$	J>jg3Z	3܁ e$ < u W@<@/""rø`" س1 ew@bP94v14axv48fS(va2M]8fa0 q
3t%rF^Nr'~#tp  u^    % F PEڠ)^`  ~u +ËFVރVF66~ r~t` t uFލfv
0V32,pIuquSI]][t
z
 ^^apaܸL~  f# FB F~P|v^ KF NFFV~ NHt@HtcH P )nMA-g0$6^F&? u/|cvA8>d|mh߸cΐ2acV;3ncv`fncwm`
NwNF -ev톑$F8gFFPjRg_S^/GFPv4FgFm~P?cbPa?:!Z`dz_&ǯ@0c16`b`~2|FtFr(QW^]
4~`4	b->2 _`-Pʹ+FVFQC94%~ t;F4FҔ0
z u WV~vN^?>S
A0@
;^_C
"j(c
l`


[t ,md(|WVvԋNsOD
RHAA~(|W~FIt_~@u"2F#}HFB^F&:W} 
 
.AҜPU!u@##g KVDi-aҶ
%%		 	F*Pg	}`	
g<d-UWVv<ߋ~P F
&GFq&'h*V~ʋv!^PFGIub: ^&^&8t #^^}h!#ù
 0GF N% o}p,-Ar  ~s NFN+;u0g03ɋFppAF_C&PfSp@ ~0gЋsG^AaQ{Fp ~
vЂ@x|r
CVV,GV~^&FIa&a8QFbQ2c%cZE>B⻐UIkbf?N33#1!
= _r	v	u$
a2PP592

oPV_#_j`R#	2&a% XRo!2c% Rc1cjAROp 	aR/!T (!Q023dޒdjD"۰EӮ
	C
@Hp

Ns#ST
	 U4	@g
31 jiMQ,pyu~rUypzp!xx$2
7
u{2
R1
*C G&d_cBfQ!f   df߹	 &fZ h g fcm؃P2P  ccFrB3ὠ48S#ᢸ^  Vᅊi@kzFRJP6)SCzB#
3~Q s ݑ2> j6hJjFc QleV>>bIc%?^@?#c,(R !
$+9oR3Ex}j`faf	ff؃C	fcRPXBA@=`TA \a$_ADxE$
C4
T?
ag{H_ 2
N5BUac[B %
SpF "4)gաPLʲip+2~0P44h2FRͱ 08jh!YҰLWVvًދ~ &F<t<w
bSrF*;b}7ށ~y~tF&8tFu|t<r2QdV^u	A(|NÐᭂ! ~ Pfh#  |PF;rF f?* F p F*N*ȁ vFܾP0+bv`J
u+f^F 0 FOuЧE	"ff &fvctffq0`  &sg22`% u"rg$<2rg%rg1tg}u8tq= +ɉN3r{g33 kЉ  auvg$<u~vg% bPu&w
u]f2 % D0	u 
uB
w )
u/Au#aځvxg%FO fff ff	fff
ffffffߢfXaLö f3/ f B Ǩ9_ujvĿRPjk- _FB~2|Ը1~ĠF  p ~ uF{dm
 {&f jtWV@_FRvuF@ b*J*p
NvQWVqoFFP
|F؊f- Ӿh شm
'F܊f hҁ F֊ft@ t؉FjRvv}Wuh 0-~St` s}u P0M2muhLh ` h F޿fPAnFf jup:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFFw~ƹp^؊rqpƦtP{|`/ 'pMOQ!aPj?+ *`
- e)@0h C NVZZGnP|\\ٮ\<\2Bd$S0   -Ptq$j)af|@r 
C8@eQ@rguvf`P)1"*- t*-} t9K4Ю!1)3q$RFa+2 OEhOboL@F m40#"7g
1[(`  ~GEtt/ 3|
/@+FV+PR1w6pBd 2qa"$߲1 vrg_ب kaa1jLFPћ(1@sj)"#2#L"#AD/]LDE WV3 W^&@RFG߃|P386 2₈ R& FWbuq`Ó rP7<"JW>Jd dabb6  &_=  t@M[_ F?t  h
*"f#-//

	
A u	( LpĴ &&TVP{S~ t'jPFI l t/ u#'jfyEq0Ut= tA:? >u
le&e"be2e% e  t&le01w`u  Ð fNdkfege0eee~gdaaaHdժ\dqu[h hJP~h Zzp:r@juB^zh[WNA4R 	'"			

 
G		 	̢	r	B		a|_F&? t5(u%&|Rup )u&DPƋV@pFF"@cӐfjfh 
 fh `  	 {    Dq~  A u ˀ&c E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Q   8>ۋ  &9w&EU 6`  VV 6?Dˠ   9~ߡ H b ;p^! 
f
>~v KĀv&@u?PM{`^; vĴ 3Hfjth ? <Њp Ʒ_  "g pvV>{B   ߈vV*rF^ ɀCP% 
Pp h
 h  <RaNF
+F@0F!vvo ߴ	F_NF@ hbjy a^0CFPNQ=`O*Pđ`VW  p 3_^e #_ @SᄊF
FlBqF.
%
;F|!% /F@P!]!Vvܑm^`NP`rFDt&@A0#FlAQ@Pu< ot (F7 PF@5
 f= `(* yBఊu>b~v*VAƦ2xƊ*} ufU  V[n']> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ftw^ G f+tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;?w>
 uο31&A *;t{r1A 
*/FD0F
tҕ t" `fp0;
V=O:`2P.B@?Vu	.SEHDa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G
uɋN3~({~ u j ~ F;|;pUD  fUVNVv<%tF` u DD^ù
0N u0+b1WQPWVFX3^tQrJ;v~ F^F&u/F$=W\qQb]R}  P+΋э8?sdvva!V0N&8 uN = tp&s@* 0Atd߱_m򀛓 !
`f+I%Q@kq6CTNi
ʐ kj ##v^~_j&F3v~Bv0ܪQ&ğ 0b;~ANuǋv 0dF˺A  
~`eP0V cPQ  F> ~ ~
~h3s P{W t4~gPǰvdPq 	ptGW5o"p j9/Fu
q_sPK0 v?v#5+PFV 00yNvD"F9F}+F- P@!Nb' ɒRq YFF`%J" nT\QPEP~)DPAEEP:! fh p39>_ ~jy/0 *9>u	A
@0
A/\&/76%'@2)
G;|2*& PE c`8(F0
A
j Qj V@V?RP=A/Qda'P? p<n@]c E +FFVa#
L0UcS4pbf 0aDPNdQ虡Q<	5Q`,+F+Ѡ`M*2 R +3Rg@"=PD=	ӁF3@**A;}Rvs`V6ra=qyg*@F;{vwPTJ4C
sR14+
}
uK#aQCP,edD&A84	PeV9VP!~9&-24hQRptYAS;}`=y#Ddf&Do&T030`~
м  q &Fި@u[] ᐡF{tdF;@]Ɛ]q<ЁN; b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F	} t~0Vg~PtOC tG\'F
t/* ޲F T9F}\LF ;F~AZM
~~2G+sF50%&L
q DFF 0+  Ϡf@`	PXhf@PF^^EAgT`X2s|Px\b<FA@ŀ[0H&^v7QvFvwFG\Pɒ #R@~U 3'tsF+FJFH_fh i^R( tTT4v .9~4aFʱeO6,+F!}=pu.]tpSq &OC@ +σQ._+ǀ
0|c?tj[|Qu
]
FB.=Q j]> LnW/0L# 'd O)CA& !!pa2/#$QBC}PPCffpL@>ffj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFffF  F
Pj ~  v
u}1Aj >PnHPV`
wϹ!&wc¯FKtB$PƏ
QиN	VV2ٓ?F
t!@DW% QD
莡Q
VQ6 B tDu遌
!_؋!bG C `DPk*. H!MbB되9>u	 rH `Gg	R4O1miDu(+Huu @uqt j	jfh	m	"	PGV^FPqf~
w t

>a:xQ[EPzUt@ ]FY m DVVj_vv{xzX 6Gn ]3?PS0	02Pr~CwFJ0B@UPͩ1qE~
G jR[;807+$ }p  9]t #M#/E=/`J/FFP9 \ dpg
p; ;NNNQP @C7 Ƒ= K = ;  ǿ-Pp---xАߛWp'Fj  ܩ~k >g`{ Pi;v1!;vF?PVW>}FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@6-U ;sFc?a{tU tP`y cFa~9Fu
VVIVF]v9vcu@PNPN  PNNRF ~9~};V 9vu< uN0돹v T`o 3P Pp & !VN;򐅍
uk逐xA^F;~m?aXS `
$~Du6g b;|qT/QN;v};O;6VQ9~ uFApL9vw|GI0Đ0%9F| ~A^&+^&} 'F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 +rz/{~I>FWV  Gc e tǯd@ @ lj te
W|tATD\[u0Y;/F~ ZpӁrN@uOp0
DUK=eNp>d u)>&f tl>g tt >c t|dv] yhb?0ҝ Whp.u"jhbh_
j(hafh_8 _ eh_hch_ ` `} `ml#_a%M afB"	 8f% es% cc%	`aSz%
 cC%= c3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhoНpt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }554465245rt659hhӾ@E@ jpPVCpWV_h
	 !V3j hD	~DXր`HtHt#h !x    C wt^ý f	$F HtHtHHt$" ^@ $Ѻ&&G<P jh	G+P舐X
GW>7x@n u^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GP{u   >pj~q9	uarf   ^f~ t  |֊FÑ!	eM	L0#	Ka@c ރ	3$50(`(h蓵pa^p3&~/tC&  v&o8 u*C;^|ck
F^P9Pg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBݚtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@ǯF	 0 % t" uwNj p貁F  Bܲ u
gށMN3w~*^
7ފ 8&8u	F;|,Bdn~
eP $
Pڋ PPC 
Cc!
Bd$  *8fuOdPg"^ku Q/	tP3*`0F |n FPf@
t)f3fn @Hpߎfh 륐j `vJ` 4$u }@3?l3 1/J`F*A;HtϠ5= t	Bd@ &Bd> .CdQu鉀&
:v	@
ʠ
 &
&
h,hN
h [?AA7B 
@
@ -*߀

@5q&
 3F! "&Cd&Dd fykf!B"  *`FP~H AKN
3AJ$\'"%jD:GBHF*`^J Zj č&Í,3F
z46 x$dhpdj(j 9
P߇8
PPfsV̩
bW&**`)@&J` j Bd t&<
 <)뀖 x/
Q %'@q`
! Oh ej  %c
bN0*ff3	諠&`%  Piр`RB/
?
$*EH0//$&40/v04RTR"'`RVdspQ%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-M;tr` MYnp= d.
*F\j&,2@0`  8&&`0\'R!"Ր,20`  g0PXu/1V hhǗ STS  9YۂY݂Yހ
Y&y"0Zd a=	_[Q[_"
@4 |
U!@ &`Bd(`Dda0y@ Vfh~0/h y PVc@t߀&
 
@ ACCC΁!#!
@Bd&`Dd(`
Ɛ޾w
r4( + (#+-+tp*tcmKt
- tu] &3\& tGђv 1vhBh
h hP!wu
j8%AW&A
-C@#'$'Bɝa'a{Ðj؁ ڰ @&
)3bP}f 7
z0>{+>>G>d'>n!>/>f'><| Ћ5P$pD D:}E489JR4"" :L}%9
GBδfhh V2^Du+!Ͻ 5 31;wutX?&'`S7WAA@A@tR_!P!~_!
@>`O{? 6`L.ࡠAL&(``~<!Q("Q( Q(*|3m &Arh3OE@=QZp@	XrQUUtD33{,i
; YK`mrDFv!
oroVv0%@tx$P!.D$$`
*P#wB(f~x0%YAǁK=f͞D=H=yM;Ա;
fhZ " [BGb %^
t
]
Vct,WW*@t*teq *`v`(@a@1)m@4AEƏmƏxCQ M# ғ,*$V $ Sǆ0@0Ep@
%U@$RU~22``ҟlB	`0vuvUP74	b
A
 05K8$   ڡ	 ̤ 6> H1p  AЗc! Ս00u`}b"XWab 눋` 2߁ 1 5r1p "(9@( f fcEWfh  _е
fcf`&cN&._.@S56P6e!7>d>8FFj% 9N$N@ fdfAcu
nvu-dum$uuu	V@V ,ǈ"]|roh2;voʋF8FPVh@PwMv
/WVO 
1!` ^HtHtt-L7+ @3!!b?>
<ĶԪ4P3d %TS 9@EEaS'`eEG:lE6Dg@C
J
s( ,f+fF@ ؀  FFa^F6 FFD>== p  -  -tRp   -ݵ -*t:-`ս ߐ=+-ځB `-@Pt}qx$Ht/Ht:#HC 6 PƢ (; C!"!13 Rc" 'A
Fy
t)j UPTPfsV,tt~p ;|Va&yBY!Fp *HFL~* f fFV0vfvvFPvڐ5Fpu63F *˃~%v슅Va :uFG;F :a~ t
&x |WxP ~@&p!  p!qq t&A׃@̌?"Ht)3Ã?@A ~r}b|ɀ&XT qȐV>` ucuHj k
&3v0 Re`ff`f `j  a6 9FhDע R
`e3`8-9t- 	t Y`r
=  *Xfjj a
#5	1	?u.#JN{1uh Ɛ>a tuľ!fh  Pk	Y-NR>` t`6
Lh45PhB6a3ada& `` F |b rFPpScA ׀>p#u>6p\t&el6`y  W륃h`te3fa13
>*u	>] 0!jkj2r3t;73Be'kJP t'${~80:2GR%4;44Z
`bh j@p?@?@A!F@[$
5$4pQ*tS?=<ʓ=5
5
]`Kh@a	@Ba	 fh+rD-qbp`$Qې$#;$ %/P`adbada}" fae`Pbr ) d%  = $Lef1 M"6B2 )Rb
b
c
aޖrՒ
 }g-
g
 

 Gwg֢A] Dt,-
t%-.t,-	 tE-
tYt~- t/PC Dɣ`:B~B _p}}  9oU&Vetleug& rߩetu
q0t`ڮe@  -Ǿ@ut;>_}`  {Pr%_hذ	vpjtXя60cHtHt `t' Q {hىou
^_  WV3ɀ> N3һBrZґ@FPWr~Pr
NpDto  & Q FV^tF&ud,`,,,,,,p+,,.>uh hmhoE h 6 jh~
B"@t) 3҉65?P@;@)}F~
r݋F 
h΢	
J襾
Z 5#W<B6f
 ~}Ĳff@v3ɉNv~FV
tut9v~O|܉~*Pӈfha^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3?V~&v ؋9t
G;|FCċFvBF  3o$uG

41t%I6o%|.bpftafff̠}&XS  
tat&
S
 P@t	bt`p` ^3

tF^&F!Su	 |03$NF#@
EP2pnGW^rF*զ+= 0=a -tX-  - 9gB m= M k- t!Eh-@  Or= E.T?/ /  p- 2&ua% +11va tata@ 3 ֐j5B jho
@E
 C
*4>/ /  (݀YP)@ wj}Q'3Ƕ
^'G`hrg5؎GS.aAcharg, taa$ ay
0&
c
Q 
@RDM
F_@f 
fhK0V" !B
p,pfhw*+`()&' $%h#f0b\rd t
L d ޠfu
N0  O hE蹔 `F<tF "h"B} by_F ۄ-FC|ߊFàxaG{VA
װ
xaza4a!J/PFۯ&J`lLH f`OeOW KDU]R]B
U3HT4P3
	Ċ⪡70S
BE

H
<UʣYWF \X_	[\jt
R2z2UA `>T
2BeT2phhhB jR"&%l$b$65n4BpA{a*5pz4B
PF
ErYD
R/Qy !^,BbCbLBbBb-
^- b
- Kt Zd0`cPeaa_Ba@W8CWlʾؾ,<L\v߿6,2B7`x`za  ab AB  z!"  ;- 2&yfczt] dw@TĀDA-  3 BO+- d	uic] )#@댉 

 ~
 [mp%js/x 5t wdt@Ch=ApzOF_BAqa ΣP?cfcfxpdpp@tA Axx@d?t&UCADPJt &hDߩˎ&? t
&ؐ
~@@ª#@

C	
 
  TBB	DA0t@czqv@t&fh{
#!$@ǀn~fh2hu0
54cbB8tfh:B89h7D !P 2r
z/10 v?=>_h<Pp	BA"hB_LPWVe$ < u"@aa@<@u*e03"@uto1ۋ;>@`  2r, hh,v1p66a uU^ Dt,-
t%-.t,-	 tE-
tY- Hta- t/\C D0a: ~3 	}y   LӠ<"%@(dF  zc`  = P~Ht
`q j  r j胞>@uf4!;F~  0уrջN@uO2phhTrWV`>W 
vrv*tǑúЪ
Q &&VH&@:ԀH &di8$LLcOs&PF@d%f% o%d%.rhh(z% 'Fs"a_& *䣂aPeA u$:D7 hrhBD9  t~@ zj` rp \Ppq j`,azp0u.&j}rj`&z"q)F@0#00000000!&bmVfvfhI
 n`Nru oh 萣dF@e:tF&<:u-FF
*0N&$x   
u3tЀC7 ~ uF	 _F
 @L
 }
 <  C
wv`
ʇXjq<T^P["H
? 0
~ ~ tghAv&~ tDW O==u5 R
`
 ^3 FPPP FF9Fr @% -
 ؋0v v sd ƨu}`= wю.ɐ`Ɇɒɞɪɶɋ~FP.azcB y ~ t m4FPba =   R F  : .E " { 
ٴQs~dzt' q2ƂOFZIZ#3^ \TAhVބ.tCq uw^ GCauK  K .g"c~W#I Nr@~u_| W    I |@FfB	FV!F^@=uFv2N'22g+@]WV6赫Khrh,y*Ny vyqu}tyH4H-H4HSH[PgHuy712yFI9Az"ClIDBzߡza
"zj &z<f+f{F@ z  ^yFV^KFP6b> Lv3+Q OY  l`- t$ fFf~ sA,Guh׷ܠdPfQVȡbڙRPSQfXfYf3fffPfvmfF fh  bU覶1g Fvh ȝFQPmdK PqwT9!TaґypE  p 4  V6rNHq0	% 6aD6f\ 6f|<`y
*]aÐ3Ð@  MHz` KBSIMPLO  MOTOROLA  HP  1.21drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withouaving
o Securit@Administ or pa_sswor4Cte a/"Power-OnWGp DevicedeDPgbD$L $s mar?t Card%G
supportEmbedde&f
taA!e'etr*ac',p(s$`*authenticS+e
credal Auto2cH%Tools Ba />0Calib( x@(`'lectb HDD:lwf-T2 op8s Activ O Mem
Chep? r sL: ll=mbA 	>>uA@Advance:`L`4uagaC lDt7  of grayq6field 'Boow1b.x.Pres=y keyI I ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQmenu iYqKp"<ENTER>= Xbegi)WK%#.followM%Zr&:fpc->  KSPACE = GNexBR3c-BACK@vio"Fg0hTABE3iSHIFTa+&*lF2@&10`
v[J` #'9 Er This60cann)b`mU;d An e o9cP^@ whs6c.pde 0kx0`yT0!e ndApGPu@p0{6Crequi yayE`dl~jba@%mu0C
movP:y }e4k/MEU)hQ1& ilPAl//+2SDcleOsu06ssfulManuZqr  N0
d:Prottyp@speItepp+CacVize (L1/L2)SQ ROM d<d famia{seP8l nupi 	Videovis"KeybooFr06verDb1$<ed2e3bg!4`1qa<wownPhip
<(TdG
W
O3O	*	Ĩtafdai5uN%BSNZC*D$ I1
2
3&	ME
C

V


4TV
o
Do
So ྶ: D.   %FPA2d!J#biFaWalRX0s&1z&H} Addline4 CAlXn.z%F$Warn: rk Tpll$0o  zDsfT[rea /v֚, lef ena waba002 A: 
de` waqt@tҰ_)Vu @rnInv ȍP
)!	Ayou̔ w=a@|to  ?m  i0oa	  0o`b+-c(Quick`n22 (-Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30 ¾# g¶30%v}} ty ho0#0#uprХ:1't4	fy-Unknk&p{ilWR!mServRe1aPS)doџ47`?a}ribp	:`exP9 'b`G H  Olp New Vfy nY7Enc8Off O$  ɥA La66#%AKroE    p dV
Ad1ݰU @ҭ5Ocpcaus7@p@=AH"h` A&ف~Opower-.AS΁Qa?U= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHishR`ed?!0f]Dddi1al <JJe HP`"UTool Cr.%oF8IL`ˣ Bk g Uмn qpm`@jtWSN !arv0s /UcwcOMP2"Onj* e:0Z%%% F@%h԰#Dn -f  TndĠfӰunuR?*$=n)tartBQK`fra PCar1yNsz}a $mediaa D-  rw"`@zU 	1 	 ab#ouasu{0hQԒ uX" ybbUSERMAST yhVpanP:FPacSTkeep ia#Je7physpE =ph!E 7mp0ar. I7?>ÄD
,Pn!Q@SWun +AgGOOAutoOc(Ed00u HZ[6h60?#ON k<
O[k{ jaD"`0ur@t\2th Q1psjow k ue"djPerK8Fb oQaff|+bdata,]ossibmma!L0ligid!VK IsXl
rmmN q} QUpu zl,`mrepla0\wsp ~p/*` By4zXr|P4,oHA=Wy@}'r5|@m
e`1r,@M`*pPpuibpty. IfdoBǄw8`ESCqt.!
 rV rtyp
'>'o F10"qbrm,b`(yt+  AE$  MiB\jQ  Or0s:zU ay O@X`2DCgDLb (leCft /hUSB t HQbSu K Z;ipoFir`ܠoPF thv`ifp Sixa NRh ENPh ASwap Fn/Ctrls KU.S КP!}slegack0РQ>is`7)n0=r@ry V0o  d oNTSC`AL -J -M눱¡9t@
BidpR EPP ECPd2size 32 MB 64a F@pAlwayʰnPPi0PAC gWWAN =D RadiLkBluetRh /rS;#chqAS Tg@a`PatP E Ch*,`..2)+)c-{-&3En8)e I123TokPR Hp
 kP	M3Unique Idf (e   *tu     Ss MCalCibaᆏ6NAstPS DQL A.Zb0B [ HyO
ЇELk MEUk'g'MRqN/G/U[:P1 : C g 9. `% ]/MCle2 zc1 dik-d3	ps
 H

,
* A 5>M(o!ylSp   hnology'tFYadapDPXE RPL Ex|#Popupz(  0 10W  2@ 3 4 5 6@7AF12z5 15D`@ 3 "M.B~ ouchpa`P5SNon <F1=Hilfe>\iYin[`OPnz'eig0`fppeict  -K!guaob9Vwiex@nLvŘ7einun	JF-s
kz
..ign@e0d A*nt neh7/%Set#SRheitsfunk%n toa u
znBlt-KuO] Gertes/-$-ID O t7	Uasttz !  ȰQz#  beim /st(
ng!K@r 5nHsvorrq##7..zurckz9
B .p,
f_g{ms>Th̰Ex)`Akkukr_eK t0BsgewhlDD-S/elbss@´ItivS9#LtIpr 3g d0: tppllTL
PZ`OS
@ PEryw :%SpraQ 1a;n!4:#U"gran FeldsArt-O&O9!86,")e SePMbqTa@0, usm p_3fahB@i=A, ESC=Abb!#`qWBkzeX!TJasN0\ , Ja	=Meh`m VeZ
zpMark"sy!*!'oMenS% d?Pfeilt!
^dQgab	e2RmOq>ko?9 c`s.	fcolj
Bn 
sg:@)-{> 0r LeGQ = Nch A\pd<-RBchritt-`VowA(GTabul!fs+ Holl2+gedOx F2@
38= {gy E3schlrLi@PK kan<~Lt we YeiffMgy16P=z`?rgetrЮn.Dc 01 L`fi6t B kqcQFY+<W\selomvPoMrB]er0ilxXWqDeskUe-KsBhmu f 3asÃbzw.2Mobihޯbgtz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos`@`F-M`ll Proz Vyprtt`wig!6R0a"Ca`-i-Gre (L1/L2kkapazitOMdPm"F7amik Sp; ummU Grafik-R0sa@Q Bz]r-Con "
A  °a?7J	b31O 2O 3O 4dqV si0 H>(F  `	o	o
@o1
L
2a7SekrET* L$ƍD%'$b-!3Kc(1  WalkZeros-T<One) EdA`@PnO`+: bX7 stqbislwnKp  ZEucQN-/WB _leQb s Atei#CP0&IyLp`ak A:nfC6
lW$g	e`KR/+Pglp%ɏ̄5 L  	/  M<0$wirkQh" vQM?`3, daᱭ
l^ie0wQPocpFLˤ01 ( anH12 (UWmfafdIGc$fhrxdauP(Min.): 30ZБadS`@0% 0cgt59wuwm HoPuy p4%ubr`"w: ؑH	ԑUnbeaaMTHxC52'rvo-L5.
32@lhafAttribu0FIAD 2u"LS.M.A.R.T.˒XX.Ms K`kwp #eus~1L Dea  JaQ`eD/t Falgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  m	g1i@eFN*1sgd,E.@"< ttifiz eq s{0yrt.@s Zu1`0LzO 9p袓enlr@~.Ajb s0DQ!np'PlsAviceTa s ,ܠF0$0@ h`L$pga|F	 :	9 JZtfa@npW{Um Fun)<S7, m3e\Wn HP{tectToolsP=c^ty ManagпU!o-- jc}- k QuickLockSubndFr#q\M #"e$bi sϢnch?utz  f`_-?1dԨ@imd`& "+a A)N+ *W"$B>#, lp$meh 1A #I Nk>"o3f`ot-Parpen}ґ:-1a$P
mCD-ԏƘڅM#@Q:n@C38mĎ"rive(F0vpl!Q ;b=XځLs E-C?\s m pWبunbralb'ar.ēIT
:gd,rbew?E!s`Va2,0fp |b"Ea E'01.J, ҃08\',  02 QIj=n6QzւO @Begriff耤Ъd"kautomMRu @Q7V7;ohl;> A iIi { qt?^!Xʗf 
VA'!!b!amU"n# O`P o"epe )pYaf{#Oz`uA58ae<s2z:n@	S.)sa`uN(}Es  oh a@c%C Rp `˂r+`IqИ  6urn3wzhE q. Esdratempf`/	 d?1zuqO`Qdz.  A@ @@R7 .p`@r&ѽ2 ⲇ Q7 b-B n rap tAdant`Whٷj @QEsc-a&Llɠ>m kW!'p'p`\ F10  esh:
xfPg gCLcf sqD} mA@MM]uBay&m A΀)bBtg0k -ET`(?links)tUSB-b#-2؆Su 1ZipV 1 2@3U45 6@789 QFn/OStrg!PtbedEaCГ O(USAfG-ZePcB`iebss¦unabhng`  PInGrafik-Contr aPrwimSek%~ Video-qϧrntBidireal GrPu_s Lfa`i8CЯtzbB
d}r WWAN-EGfӁLBluetooKth9Unb/a Egpa!Aggr` ?'*0(o@)!u/Ep@Gt 1P2d397ToqTRcC ?!"sv@x`a`13IPkbovH AkkuP  @Rt   x a  KalibPb  MakaO  N連iuala   O  fm   O DO,t OTrat-?6.  .O .qL`b4obis p9cOO5"R 0	EgnOOf`.[r '1 :. g% ]abblo(2Entl ho30P@
m* 2a
 GSm6'su uĠg`RadapaABPmB`z}ExpA-!-Popup ( .){ WedauQ0d2 (ʁZ   Kze`~Compropstn  <F1=Hjlp>Atoplys!PVisx𵣼ne G'til !!konf b[Gend0fra MQzP@QrU
J@gn{orpndr{ o&fslu Xr  u*t`@gBOtne k)hed Admini{storad!7sko K0 aodA7 fo%WhEEdjeG-i3q		 *`	*
J	Sm`-kort	God0delsf	 7do_adbyggPGOds -&2	 Nu@00fMaks l2 Ua`pg
s)9FHk@\HFBa .@ġV  cb"dvalgte b&HD?D-selv\tPr HukoQA.ACinPQ2h; OGH omv	Ir/ Avancq Sprog/ Vl1?s @mo2nedtt felO C4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=Ann	uaFs!3=JaNej9 "J, A!R=MGb Brug pr
NA`RP70we  releP %meWnup(,1Wt<ENTER> bqec>A)et. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-TILBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!xhk>{sfej 8A3ku1i0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krvvek`EnJJ
iC db!?s/ flyMsÈyn/MEUqoO5 bp* uvetzbrud 2JI|,nemfB J@`  Prc c@orO-typ hBigH  ztr`7Crcache (L1/L2|HVROM-d@ familiei;AWdeo#f0pds8:@Xr-cs]]D-ba`s@i`9e2o`%3o&4Z&at-ta`ofej1E("Wat!)	O3OWEw ex{%Isr4E$ TyPyٹ%xy lydes!Bmis 0'bvD1I'j`Qejeܶ var0: 1DB1! se  alt@P02[holda@ poPqt`/Lb Bb-Bdqduw5,pr $Pk
kEuGrBA:ރTETfDF%Ugyldig/
t-  @nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)%Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR 	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoRR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di upbilK2;+1ol p@frard )x Qlash-@$PR@Cd-rom-@ V@ôB Ho4C:"eAauϱ6!hv1,< YD!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q\0MU alug:,s  n bf  ned op`JaP)edS t#
{	pND ll E_C0aQPhjlp@futo!mok- d-
\BbygAXl_6b_/k perma`anQigw13n<l  fys dsk6  4@rbqpc(On O"(l	v  H.dCn0b  `Au!dW"eLm/, soma ck@
tvt. U~u p{`ppd/cĠ ri}oU` .Q  0сbefalkrafȓpy 'AQƠ@"pl . paYu )v
ؑ!  &cO.q#o"J "4,Q/0d iDHuAP̷0..lR5:@ENtra!5ESC. řE# orpy U'F':ge@F10FYtpsf
i/PD+s  ADk Osrflgm vdRRenhaHPskm DSp-bas MultiBay (K0 /$hjUSB-floppyEC|c`c{R}wbsu SbAzipFr`aVTredj@Fj e SjSyRV O Ni @Ƀ Skimm Fn/Ctrl ElPv(a:`isk)!aOpegeUGst픙!
uPnPaq0#rm-c%r Prim Sed V`o Out Para#  TjStrCL`ohu3ko B< t 6nr? compu Q0PPǀtrm
gat WWAN-!sioLBlueEth/A (trdlvplo`~net@P2	݁UC>msty!8C(Q*8*top+b+EthN1ht 1K2Z3KToLR![ HL	e+	 	Ent6gt id-nuh`aP1riqB$  S    Z 9b/ `LKalib) ܯsnd!ig O x ;0R8ѷ  YPOH  KO OM\bo  O O#0ionOOOO$Hgs 1 1O O
1Vi/ mobPGu"[@|!(MEU)J= K=OOGO 1OO OOO[ TPq 1 : Oѿ@ .  %S ].gm5t2 AfFH5L)O3@	Genos	
k

, *  J/X4%G) ' (FA qt @@Ž֡ r "popupsink(sek.Hǀɀ2D5f- bAg0P p Konfigumas  <F1=Hjelp>ilDwin\0jon`s psy0La 3C$k"pv)Hefra6#:0 dio0	:k 'g a/vslu!A 
,SlBDE;sprowgra0t S{t pass e a/$OpFA |U'yrs%i!vsf'unkur!tif փ%@-
xvn Sm4`#godkj0RƐ!xneby3PPi%it"ot5sTilbake@l#3fabpP PBQ g
i
 C7;avL`Srkty & val1g !AlPP 65h 8Pvt Ak MbT!#[ S3EG $*
`H!4vanprlgy 6  Dem7`5bM @ZdtJIel[3
.5E6o%<}5Tr7ykkC taJqLQL&pg _=, ESC=Avbrya bBeAPpJaCNei rP, xi\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NhQ&86  <-TILBAKEPvrig*TAB&"HIFTa++F2@	x)}= Go f#l`bsfeF`  SPk`0`pZmnop@5 PS M0|m kjresve,!@m d;@i pp 9!obaRaflysbc^ 0dS w}a`1A|zrv full1z. kode 02Io"Produ _t Nopablok7k-mll N {typ h@igv&-ga zvAӄbuff~N(L1/L2Meng`	Q	enu V@woI-ЏTjrtroUSW,kobgRi%,oK51 q'i 22340,p( E
,9( Q`
oa
o0A
o,
NEkgB#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( A]dss e7]"~e PRnsAd 4~: DsA#.s@Qtid9lSCholp`@DDH[aQ "{/he-  dÓ, rnP}u1p sakl<k`nn02Aa:%ڲO b@Ҽreg1i%HUgyld#ig#DSR`@	F
	#NEh0mtEb`?̀{|]F igno3t._te?-  HN 1 (yR @nslXbP (): 30A3ggr 0$s0%[v\&st!vhFx_f!_: Ka"qut``U(Ó5$SQ&eGt :To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CCG  G#Npu  Bekreft njAv`l eP㰔1qrEّjv>likt aDu!0oC 2Ѽ	aŤ,okag3ogs.rɐor dmpel& Tp}?ّ.BrPa(A=pph. `bku,  amK#0vice.0ula?eD(s  aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l8  ēlanp撩pa0us #L@$AOmpEr`i!gi$eu bes!ka u"-U+/- +ӂWE%lq  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- ParFll+vFP]hielQrzp2   CD- %FtV2uu H)o $.:Be5C`Ehpvalgtuh h`h"4@b࿿BRUKERHOVED-T6 C:J Rzumu0B@EQ
 an0^*REDbe! 1LPP
0P  w@"!2 $Va" #
6S,AS[P= 	"ن 6*pp   tJ@IOM @ automPZpD!xLock	4dbygg[)c16a  @^maPq߷ilg ^ge0.S k_[h 7fysAad $0GnrW  m#>	}v !n:gne1^VsQs ѻdda g ~u%y. Uh omd @O1}0/e XG)0{nq
` uQbVnbefau 31G	A}q.1A=x A0k1E5  fiP _!R!'Y~I7MTאs x-QVflans NPBv
,x2˰ESC-zL Ϣ`sb'fD'J F10$ZCb#e:hf$ nd  Nor iFGO%re  MultiBayPG]z "Q'n(vef!e)pPko.ngsbahhsyOBUSBA|w Zip-U
A A0AaFn/oCtrle EAVd(USA)|GekeenAela	jZtroA2deo@!j"pTisrr`2F3ViA7tiࣀ`0mFgradi/@?trdl |t
WWAN) OOHLOJBluetooth /-eftmP7 Ag ss'styg!1% %*2$ (	v0&#.b/! 1 Ethߐ;?@	.-	3	  !R!(NT s*PooPo/
;niA@jtifikhRRC&@B:riJ( K0t  4 @6ymbo Kalib2K Baes- Ip<pɀ?D/ual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	ond 4oO	O	
%O	O	bv mob. a
H.\ L.\O	a}o
 {{O	B.[ TO: La. В% ]<afull"C2F~iH3
in/Qh*0 Oy  (o J/DJ/éiǋpkim: sin@ ~hurtigE (sekurxѷF12-`Df1.Sepute P@pRConfiguraciPe la Com`adora <F1=Ayuda>~`rchivo@`m%l SAmaGu`0isco? flexi acqܻ RP	a`&svalopfdobPay Ignambioos yli 0a A{  g3 'LnepidadA0s#e
g  ' Ajpiciof%pposis_SIc)$ +5@*KskSm!=C SSoϐe*c P#<) Sectyincor% E@0 e" 30/c`VP>6fb	rI
aBV:c!3nci@]~)AutomaHerrami aC2}H`er 8`#P(8 ;prueba HDDK!c 'EOGVЇ&Memoria2ad*mp.l1@JNKRMu0G`SG#
s
 AvanzX`"ESvVDD
W? Fampr)co0N grp<1o?)<>UOprim'wquitec0g2) Pbm=, ESC=Ca06la==Acsep u=SSqNK1"Y, C9o2	=M y
 p UyB$6dchDha6@alP}  alem o apropiu=@[*<INTRO> z qx:N1n.Fs{3pkԕTY :@Esp~o o -> = PrxcRetroce
s<-{0\@aؼTAB S	S'aMays+#C(/F2!-910`rXŠ"b"uErrx06F  No@8 AiWGSzPrjo u@QRA6K. CcdК`01Bhay nunw>эqubRnY2@AC1+>b1 r(Rp[co`rUD)JН@ebook/MEU?IXQP\2O`0ple0Vxitosa4e Fak T1ytil CTisOp7,VUclGpuW>XTamauZ_0h (L1/cL2Oc FAAROM mil|@cNmerD}ribvisBUv@ j6r g-l@yo!! 
/#j1l2n3p4 EtiqurBAsI2VehFK (ga` Woo.o3oopoi QB	Esnؠ!*J8T 5:Z$?  ProbU%bssfactcXJ$ǔ =ll4R9eo 0poX@1'	ln
edi$l@z,
(CE|`oD"F%Ad :vH ui[r  eap. PreP#/, `WcqscpdYcuA:'p, Uu c lQas ' Ӣ,hp9tegAң
S^@vlQI$\'vaPa)00٠>o(a) 8!@%c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuvtieej 2( s):G 300g3o B0%&~Db EaH0ּ _`ipalGirumq
 : s,pu10 qIQ{`3nh7Servof 44apoya atrib0: ID0p#@exs G
X0Y<A`sea<KHnuevL@)Df ApagE ndq9S@gOB".X		@e voc`"	k"alp3a 
0 Lstnad ;`f Rn"]e#թ&9 A*# \A<Q, (02o,vA`Ơbs (R6% E  WciR|LLꅠB hrpinR3 SBf_ oltı9al ol` X#A!vu	j+vip.AoQ  '{Ùv?%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\r#at S 6""t mej`eO@`?:0d++-y	(BI	( !)(%rALlRt0,"BD,0X&-upizQ,.`xHOre PunP+r'ojo%q>lWS9MLmedufh zBaC#D-q(E喁P&XPk:	Zv@Us0io:
OpuT=sPP  !rrive(Rl! tpb|USUARIOJ PRINCIPAL0Q @lo@圠dtVnKman`V p< Py. An[4} y gu$8@lug\П  `j7a{P..'tJ @d]"YIe@GӁ1
c@bU= Z`>&BQ3"mc8K)81FPor/A:
; ;QrkR ϐu@u  , fsm1$2A RirP
oc,#I"oi  /#_z"<Y q0!u SϠd/a|MsRcubb TtBB! ? 0|pda !$kosgѰ6Se xo1enf 8d2`licQ!"reAaza. LO?k Pu  `#PZRS4=Tin!~k  k0T1B¸fiup8Z!`
s|i@pons2> Y_, iѰR? ESC.  ձalaubp'Fd'  ,F10!":ҽxfGaG7T/Espaol O@rStMultiBatNPa DiPsi໤3-p  ;]ӟfbP"sco+(iz(@jech-5 cBb a1ЇSuwkrdZipcpmeaewTer Jo C`5t#0 x SOv NoD C|us Fn/`T@ncIngls (EE.UU.)sp¤ (ppmplfSo}"le0$b
er10Cnt!Ac@ Gΰeo Mod0z"y!  Bidiƃ Tam&CmpI!2i#	si0߰ɣfu0{ BX߳ICARPxQ׀k*WWANy{L Bluetooth IA
p}{Pyho<#ergs؈gCpoPosb 6B/p:(s+ior)Eth  et, NЗbooU& 1/,2/L3/Tok0R dOOP23 IpStif Exclus sAMa6`   .a*C0g`*-N0p[PSՏo`Wr)Xh!,o	o	Pk	o	h	s0bpk n	o	o	eoko	o	 o	ao	o	%MEU o	.o	o	o	o	Ub2o	@o	o	o	B8[0n1 :rg"9. c% ]/`~pAm2 @c@4-Cle0τ3	й@k",'* q 9ODJ)o!qoh ~1bl䑄@z>Arran1pBy@gÓXDPХg2ExQ찱` < ŐF12 QTPAmb@TouchPad ]u1o N u׀aPub  <F1=A_juda>rP0Info@ˇsobPo Sd Ei?5maDђpR0
rt@7xpadr0
3r  Ign`0aCirA	4sPs'&_\1nanJ4azOPDBr% &p͂_ `#Ɠb!X_d#@!

SͥtSd"҅8liz/p̉O
(Ib 0և/R Q*p?g%ҠbrB
autQ<n 4dcЬealha@o`Ma c(QF5eOmas@g1=1 iCP8$!leOpT HDD A1)r  VR#Le Mem@PA<  4tatu S`MuPW^G[⩨ Avd8!S%,io Qa^d; 1cam=ppJcinzP"o?CA9 Pbs`eS qlr wcи'tinu0g=' SC=Ce9lAce imNK!S7, Q%ou=Maikg Uti0: sC	qqn'	da` o i  aprop@w *u@Tt#<ENTER> t5meRez[@3o.Tgu@n9 ^r ub:  ->
PAO = PrxiK\<-QB7ACKCExaQE06TABo$SHIFT+C%* CF2 	*:`=kSC# 9nErrrOA@Q@na0WoQpڃmRHE. CdigTGo 0o1  NPhG`,@o `+)  s@ vizKCA A	̬bMev
;nsf`ZWot?ebook/C[@(RWS mG"sTe2_DKKXqmBm xitonN  Ti0Hۀ3VpcS_\ Tahcache (L1/L2੦FX a` ROM FamlY  sN 3sri
RevisSvde@̠_aJroQLa
Al@!D	Ob a( 3M4`Rtie!p	JIOeu6$(]) { 7on)o`o.Oo$alS~ƕSecunda'A$ 1rcC% v\foi"gv@a!mO al  Walk S 0e g1i	a lien!M!oc0I@Advoert: 0[0Aqo vaCe!djWcPqP/,!i@um  gravvuu:e)EӎA: n@Adc NS3 >HB^hO!Q/tegiEa	c8]
vl0IDyI= k9T@ctez0eja $,C? iN >?ý1 (Rpx b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`хѡ0@CT =4Q0%?1$=bucedeA,qAhostDCrom1
w: Iss-P$Eg
Ch`Ӂƫ(*erPmec    `6Q3s<M tribߒ焁LD`AМexa@s wQUUi!g:Tgrg"`alPSLs   qL rB+ۤiPArrfDigNcis gҀSAAdP)PPЉxac'mod!CsާB! faz A@ArEr@a,Πerx dform!Hr3Dn,P#ja0.@eHCsHfbr>causadQerF.  TbZ Q[ea 㷑2krvio 	Iy0rqX)QTa?%0Р ur@1r0k
ad`pis0S,B,QuickLock!Suspenso Blo 0ktB #u@aSM%` mabnb1IY @k, $$al#.`2P4sa eiSib0RPuseu s<EExigU`re*PbM0Q+x &perme@$1lp즅+!CD-"˯gGDP$qmse:PDusua?: VocÈ@ gp4@a0v[r2utzo}oDrive& t@$RU?SURIOBG>@ESTRE_ FSC%7q<Vapaqz:@I. AapN4P@9de-0ФrMisPJEB>p"}@. NNv p[֣'6Ve ,V`(P_K` 0+bu:*Ƥa !Ede]D.Hf``7/{s1!Bi屧O7T>WDIAV
l`9w90o  sum`Ef`lo,alp Af Caa_#erf
a`u@uzoT :aq(˂40  Àoqur<ǵx@FkgڲU yaf0T y 2y, p;) bF `3Bor nal|p`a-t
A^ ˢtEs{ubtud C{ ?@*h R)ppa۵ptA-lVJ/q rWL !8Z  Lemb#re ՚vqMaac`Pasa88
"qui(_se`R ESC]ŉ9Šq3Wlav'f'xrF10. `r`r:!MrʷTAc]䚺D ugus Op1k: MultibayQYNc`isi reAFpzBa baФ^copld(RP ditzB	Rc"zipcPrimeir"rUc Qtӂ*O]v@N Ճc@aqAs Fn/CtrlIngls_ (E.UV@`ыxS[hp1troahvdeAcuned a@hMo#aGPadrBiQTaPhBmemOp"sem fubw>zfec10CA.#%RPa 0RlmWWAN)` ooLo)Bl^oothkAACn(a/ E omCenerga9 erec-CagRF2.11{Ė5e/2o03su0ˏ3Et&netg	O `p
/*3/CToken RingOOboI5df Sb 6auaqW XKSt`sSs
CbGqPdbptgemNS vlCAwr R"[Duplo&	ted/	 )	E/	jON@OOO'as7AmO/	k0C/	cIAl0  OO/	Ojp~AMEU/	 /	-/	G9Dф1 	/	/	/	O6[ Etapa {1:rreg29. 0% ]Ojc3l 2:AcvN3:M* 
 o9ayCJm*O"(sDflex	`QSc زrydapY!i Pop;up> Exbp@ ~àF12(т? d>QZs Vara֧a N u`Ti k yktukP  <F1=Ohje>Jrj۰tQt Nytt[ v0`tu kP Tallenna levykkee dk@oUn oPu VtF?Fo0ej'nsW Oh  mutA 0lopQ4YLr  ttPt7fTpo uau=rlisuinvojan s saMritoKynqypk. Latyl	
 P usnume
o$f-
t Wlykpiu '
,(oPn-u kiG
/6 Sua(et`Fp.Ttq3Ѧs5*tehd@&7FG"R`t"b$j;A)ma*in`CTykaluA: o` K = Ki@3vyt?PO9`@EMu  Ok"  a"r6n D;m 
.GHLis=ieli O@I0k aec  harll`1q0= 22R2$2%Jatkinjot~  nppP]=d, ESC=PerF =Hyvksy=KyllEi M, JokuaL=TY_ fnu7oli
mip2_kah$@
sidsBN <ENTER> m7t%
ep+.AIK%gn C/ss seuraav0U: ->Xi VLINPPIN =p$[s  <-bASKELPAoLAUTEdPfb1!YARKA+!@hԭVAIHTO+', F2@
)_}=  d@!;PvirhvAkkua e =oi>da.>: R0vdi 01*ka@c1s ~4 apHrt2Pl pV`eytke`"6ko>@	siPQlaksQqsYsRW` kaCt@qlaaP^ TikkI)>ske_ytyi Fn
i(pO2nL^oRhpebaGEma|j|~1?i@d tyyppD@iIn :fap{llVlisQ (L1/L2 U  ROM-Sbmkoh	tuotep9e"Isar {W]`si ?s?tohjab T;{	!1I:"#2o L3o`M4m	J`Ltaqɯon7(j \oa)



\	\JekA'ra- DqACup$#:D$ p9ar%dzb~ lpi0!iEepoSi Walking 0 -[1Yloso Vaihtoe@ :Нuvi7 us?: Tmا`atpnhp . JltO luop2us-  n,ҐirjQonc@!K A: L"X AY	hkuVV 3beFAG"8p_Cpa  h
Hkoa]Wi a`nA?+ ?2`o  pi?ͨ,i`%(ND92R`3.M.A.R.T
.`Arp$ [ n (min): 30-Es p2y0%cL dv0 Ispysi- 4iVgR
{fb%uCntq'c{K)jServomogottj
Lu!5ÂvtuQ	k@Fttribti2ЗŽy@a 6e*qKxe nGG89 Uu/Vahvu @x P>2Ȕ	! PC }A"+2s@a	,-ãPAJ頴n4-okkpD;ad`5an OI$nDP -e@7p$Rmysba
`kD1h@` HЁeT @	dE	ZEY/ i0Xj [!K uEnQnwby:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTo7ols`cuQ`Pger -apQuД큶.f(-/U i` n QuickLocqkfa hlu5qf ,V "@P#raZ&-Q,:*sekm #o$j$it)a{d0||}yh'  PP`0#U8C.7>uu	SApor In+frPnR@%!bkܑCD- -aglWpbt`PBOj0WWAiot=bUon DИe$(qpTT#)|PKlla. P    KYTTJN:a PSSANAN,0&#K,x.ma$r@'silyqNhur@S9h 
 ri_g[t _r
VX-%PV,1pC@@jwLLA1=[Q'᫆ ONU @Ros`* $Vh suQFZ>R;)f,#tu?x	5ogm O
 G BU7m BFr
Sxez`jED. NykyscR`+`RAn𨐆{s1x6s
t@@\ PU. Tnt Ƞ}$6ih1xeip=ݏuperVd<eh? IPa*?-m@&yް\2tHtaqV^=c |AxojaiemmR}tAq.A 71pm @"Fdt" TV@UG.2!`ZXrr F_Fzc$ elnPĀo#\X#SS,aTpESC-n`bPsR6;n,e'e'!> F10`Y4aax :B	o .cVQ llQޠtmidys ubbn MultiB
aOpc&J7^lako0iu6 (en/$oi) USBd@)ZipEnsimm ABKyoA elj }Vi}Ki eit@Kapk Y Kym!aiо Fn_/Ctrl"mA8+Engo(USAUsP0s#a!1@B-RsQ S`nq`jBs#PPs V0o'lht\Vakiops2sN#Ig3uuQH`Dpl1% verkko "
WWAWN-roHLOwBluWothE @/Fh`H  sVp&Rs s:l(ӏ,1i`0>H y/2,-I, (ylos+OGCO6EtherHo2E Yoeo3o9To $g OohA workQc&G <IlivA AkkuT < TJr ӿ rPjo lib
reu ad S\ual`- OO OI OKblb_OO  O O sO$O$`O$ vva_  O1 O1` OMaa nusBkPB ODO OOMbOOOO
OI[ e`i:r
йa;da@n . % ] ODP$W2l` urpp&OE -O
3
 GoMOH*  j l 9#`Fނk`qvuɃ!Piǰ@ (se  n A @:@OF12:ڴiP%3tappi>QkoskeӐ 'mma K  Ei mn Configurati3ordteur  <F1=A> Fichier? Infor m Aff age Sauvegarder sur disqc Ra*r 'une.H_DHeals dfauow du'Ign=o%modi T&quQ S$?e l'inp$@Preg om	\ Scuritia%
e ssLdS"#j@e sous teP 8Ion. D
 priphP %J	a sE& IDy'As
Dr`<Lockq
Smp(C0 Br131r3  'heP5G  1b#a <gre taR,)+5p7am''us3;),;rfren!cM =``t"#Ou@[ !@lonnLb`beriZ slecqSn@psQs AIATA BFoV,mmoir `hcBDX C0ZZaFB_V A0c`oLang4 ChoistPJYl3Ind)|!5_mps g!X 5ePMd.rpa `k2Z}:~z? AppuyDfnatouqpo@gezu@l v=Ser, ECH/AP=AlHAccep| S0=OuiuN*#Q3V, N/'impp_e``D
=0aw  UPzi3
s Mf'heM
mox!04ecle hmenuucer8@r0wbri2qh@z!y <E?NTREE>2nj+W	ss	sui@/fa  !/ :-> ou BARRE ESPACE = PBe`1-$IE?preced@S.TAB`CA*'MAJ+ix F2=1p"w-$!S( rr`@P<TJ Ily FA%ssibdcQ7L U cs'Jprod{endp#B$P. Coa<'401c5CntP@-1 emplace(L' D SaQre @}C'y
GJ 
s}^ccueoil dн "4 itzaxsmobia``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ GTyp0osBVpwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numrqo#p	Rev`cndo erS2ItrQcl#avpoLA} ud@;n+/Zp/zr3/t4n"3inv!/Qzi&<5 #priF:!L( Ute)O OoOOOBV'ed6A Eo MT֍ :$/.   %ErF4 !SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0i5fAtip1SRC[a=e@ptruA ieЪvPR! /簹r,  z{ nr1o°c	HcY0]A}jDL_v
 t;ro Pa
s
TX	  _[Rvj!a"`dH.ORn m:YfP S 0"Ӏf   +-vaPC 
lp  ߚV ? Igno7 +| z? Enregeo#=1 (rap`)#>2 (coet)u`|VpimA(z) Bc30堿s pAnU0% nv$D9ʈl'hA+bF  `:˗	AsmGinpnu#d'+,`v`t
$.Lu( pG3ip 5A`ib!<O: IDP00@"s S.M.A.R{.TAbanG2WpW AIBY`/se N!=apYeAÐ?/@;saұ#A Mar uin KS;A, eecoac	;mme, vK*ad11POobPbatCs	eS¢d4D	 pe>a1a`(`ih s4[	,p@s蒵 `Ug"  f'ormQg-hHq#xѼsJ.)ArmQފb	 hJU0`
1AJ	.6zT"`QDP~aR avoupR!AfrCww7 A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:e^Ry Mar 	O4K8CF!/  QuickLockUsus A|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//;  / L'(a'Ha
S$ud!v
 KP
dra+D hn8 4`ExiZAudP `2  4raQ8llƙۗ&flashYd CcD-'gEcepWЫpala*Y:6PR63ge Drive!*. S3A@bAeBde{z deux"(UTILISATEURPRINCIPAL) "cEǋ	r SċOj N;z J@ ұ@Fᣐ#1"Qisr  ,mfe0celu&NSDordi@"c. A 0@QV	{( p$OV)Do `Co 5Afetr pyJ~N",t"	~"raSX""Qnof0; ;""t QE)=ah:>Janiq45#'/৆#!2/r,c`sĻ!Pl!  30ӿ)YH!!} !! {e [1NJ^%puel1d@݂͐sU :Hh" ""opDa8lE O'fW'ҜB`k_w# ,d'orig[inIlv`OH2CxaB	uȦ
vqSpցa0AQy9	0t0M@
5dSjaBvPsaH{S@P{e* r-$ށW1=aprs@4AAon: toP@Tr0a44p`abzt3إk'
vj, appuy
` ECHAP.@ @@ OTzR'o', pui@CrDF;10 TapX C1xCxY^u}	U/1Fr/ana
OgVACJiMultiBayѪ0ulAphA !3D,xsoca%(ga¡)OOFRz) U[8 USBF1r
jZieprP: Dhi@s Qu9aQCin`NSixi Se  Hud NeuvCD`Perm/r(s Fn/Ctrl@zS Anglp>SA) Pcopqm1`s =A stan0`˛hnROd'ad`neltrl' UichLuer&mRФ`
*d :i@7idoAABid@b 0 mmVlă@jEK!alX ó R o!=ril WWAN? (rseil)Agr
LB=lPooth73/?1  R >o`$ g`\Q loc <G `c!ZqX0b951AbP-n o;2ooypu8<	6ccumod`ogB EP$t# 1Ha%23TokRing ooUX/IduT9-ar a[  2     h ll`h n!Kre00/ x Ab!AF0.!f*Dupk */)///wb/ ////** -///Jqgn$, /,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Charr. % ]A.  2D` GicM*
n3@	Rkio.
* T   @@/M.$oOA$Ʊ|4Amor1cFe"5 RetardBTexp `) Dжa  F12\tposf[iP+Aux  PatqbAKw ucun I$@z!Nl1 <F1=Ai0>`nfo0gema	l p'Salval floppy%APttoRipr0ina dmThhifap`i Ignor`daed esci EP a
l'iI?z`ciBPtup iczza^ sswo!%e am C0rato  gPccsP
_Q,C*vos7xv% IDs
դ&gDriveLock	Pr`ǃ)S t =C7 Sup;  c30 gHQg/ o+:,i fabbrP
4=i	/.nzi[Oco
rui UCb5<bae"E`lrOpa@t2;o roigidAtaA'Vâ,a mepTW`<HKhMiM;A>o \!Ava=t eLu!O l$Dim"& q6ca X sso geviQ gL	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu`,aA Etpoeo=SiSN1T,altro#	=A bj Us"SchiavI frecc'!9i1`vocu ap70e"_`<INVIO>  \k\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pB7ACKCE`qc<ؽTAB@C%o"MAIUSC+)XFa2	>-= m "AC"IErriS0D  Qut A87npupvse@t"Vi  v@u4T|8XJ. C{'01 Npu 0F>9a0}oggiao Lk`IP'0  U>re0
4Es"@agga%FvpSAcғ  npabook"R=QzespajT :\ Zf.atp1_
2o{briu`Prf uduA ND  Ti"+0<PSpVeloIStespp@YMis1ca(L1/L2 d&dDbRO}MIamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~iI1OFk2m3n4ࡐ7w PVSTe)D
E(d)8
	2
3
4 摭Fonda
 ,:o:EV$ Tr%OupyP!gTŒ@lliASpr|B:bit 0t 1R?indirip	i] `|@'FAЎso:5X%? ?gger `|vpAhAr1e!0M/rѧ, `1faAvi P}PiVLYXA:'mU[VA:"maconouAh(,_ IISɁQrita] N
sv@dpRDlIQOyളSe3 `cvoPga ?AFbІb iQfre?@?: Aɐ51 (Rap)62 (C?omplet"2tio (): 30>0%Q5"r6ar0䠈'hD5|:s*Щ -@
˱֤(aD୆%aerv|")LċAPLA'	rib i0go=l: ID$Ban`de@z قi S.M.A.R.T.!ޱuT0U _/wordc(nuo!i2 pDsc(Ui%L?Ibq+d` {â"Znd ?՛O.A7Tącq^B&
Am  AVf!B;YECr	t>J2fuDm y3CePe<B #u _tH0s!1a哰.Q]ՒbdFo8@!erdPКatiwEff+Jizso@in  ca2iHvEvPgaζOdesХ@Jm9Yy HP tectTools Od.ZRV2+ ickLocykspen`3B05EY moeu`s8 MM  d?#<#,pv  gra@p0'!oe -!e $C-))v!pKsm@]0x!! b	,'URa]r i lі@NR(@|ГȡV|a infraQ)p y%La_hflasho CD- eS准2&PWЗPp`	:(Y =!AҍўDeyusan@D:e'. DU8G$=0R bRY"'UTENTE@PRINCIP?ALE  r+`"ρa Pm3anA5fu`o. AnV@!<dЊQt @P!"A eC!>c2<!t.`leAu0WMT[s,
`h	\@poI sab<4reWc.MaPi? `o`6d6dqGi>h@A
 @rea,q  d (1z:t tOCF r luogo ĴG T!¿'     i$  hSGT#:,eG</ I"I@5-"L7Y$r@lx|slmЄ!R/ċ|cB  /$²Ȓ Sz0SŔ@c( 0 0DA'Ps`  gPQ#pQAiqv  	lptat{+`uY/A dO::!al0{s&.2pCqu_{9c!." Y)@sA`YE	snO`d@K@ȱ0' 6h,mQo ESCFM9'ŝ)dovr0 'n'`po2m!nF10.ɡnQ!k0 Wyƴ_6\WPРIP(i 3G  O :Ćİ d5m MiBay ba 1.gga s$Z) og C}h`i USBAܘ]Suk\bC
ZipBP6o ;Terz  OЁv`N%ec AAP Fn/?Ctrl T`Ingl (OUSA) Yi沃u2O mp!l  A01aЃ`` R7pl AaP0ư0!Mo@ecW Bid0HaCapa memPqaX5eIm s"F!/lb@Q2'/wNPs (WWAN%){oLBluetoot}hCommu	Z/ (J)Cs m energ]phW'Ng)1 N,*2HIB-Fat-(Fo)ol/spo EthetWJ V123e Token Ring !OE3 IAkB| sCtQa L   AoQ(  C02b// WD|Saoo [Kvi0DuV /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@Nupup <F1=Hjlp> rkiv Sya|infoth s~ S pk%kigu഑@1( stll /frnlưn@ard Ann}uAa nd` ochsl   n ˑ~ Sker dP2trsslpD  K!aOB@rt-OaEn ssp	(b -ID
S a&o
@m`
Pd-Std fruqtQ!av 7K
`byggd 
 usBi=*abrikk+ .J
sbehrig#.DEsktsrktyg Km +r vڐ" 
S`;vtgF~HDD Ak_V Minnes:b 01q5@?@An'@#B
Q  V[lj4rDp;cBnedtolD!v(C-j+eTryxQI fri Dg@q nr du viJPst0x X=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil`	c	/pCa yEt
<RETUR> om6
\YRtt .ie,lj`SeerI  : -> MELLANSLAGSTANGENTE?N = NXS@<-BACKSTEG FregeynK TABf#|OKIFT+0H& F2`+?z= 'fO @%Aoi?Cfe=l 3t gqL` kA@t h+AO` Dstod uGen. FelkF0197 AsgF{P|plat  NtPhm krv 3?A @pbyؐgm0 fly5s t6 -dator/r ex$(|0Ytidigooi2-@kl`TA UkN4,  Pr Pr, typ
hast^hg0Ca-	rlek (L1/L2)Yd RO{M,tum  ?familjr?enummn0D/deo,`r!Yȓ ttNb ~pqyrQ!]H 1I.z2#3$4rbinvp ˦3 (
bZ)g	1[


Sek# xIrq. 4I$@gaxr#%Ex!z=ok!ŰvidClmissl l.s Walk0s - T~P f1jH Add0s l)i7Ae nVar! D@/ѹ  x7neh g"Ccuskap*ay /G-t!ڱxiƱ=k b0!h$2AA:f1R K>#Rhi{wIBB?skyddadag

  B Eˎ҇pA!^Ԉ  d|? ig?D܇jGa- 1na#bb8f@րީn`X9UWk`ad k$pQd }(0): 30@npan 2?0%bX A4Pp/]p9p01vr kMatPo:,t	!قOk%S(x eorvo-Lz B!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 G'ammN u7. ifin0@ D> Lܰ@Q R4d% pm}vlika mǄ  'InE?ka?n orsa@3iЈP9aHSsNyapPO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;els!e- @^uQ"uayVq >fun 0`perl^7!i HP tectTools%٩R}-6-Quicka"q`telgeG Lp׌mP<s Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot. Kж7Aom4pHi p@1%f   Pk`anFlash-@: s!CD-pBWu O#TpSr HuvudH`y`I: D,`m3vahrdud D~e!. /C怆a^r AN}VsHUVUD#$|`pmart w.]  A? L1q`ild frPA+A
 I1PhPx@L l Qף(l HTwO.
!Y  *oH XBe0bbycggP6Q1 g3///dZ6- FX;o	mc eB
08HcA?=  ?dr:asBQGdʜD[`ktuPaiq3ۖafanqkhr`.GutAMC]tgrs ^W!p,t1ursprung`LxK. Vi  reko`RF	b~c	Wr`+D,s`b`~. A`KT ̄3_bh  &g!(g AzO-kbefnse rm ih޶fljQfns . Tr  >ESC-QBS r26V"&PwC`'Z'R-WsedMtaGF10`cVi3Fa:+ddQ~shye aSve a 2 Q: N?, M iB;ayCrut`A~opBP5vi B1a PG (pyr (h@SB G Zip-=PW`AsQFj1AѱQ. utto NЛT VxpFn?-/Ctrle j' E`lsЭ(USAbmYkd@!aa b`nrmstrorxK,  hbbelorlekhpeo62ne@k@LpIfڒEsioBtrqtK (WWAN)LBluetoooth p/() -v@A=Nmbe1/ Aggs`haE(-21i,2v0
[,p'Ned Et!hඡ,& 0	3n To!RqN"!Unik *1D?qiG K `tus      SBbo Kalibo dp~-  F=s alQ.O
 o 

 
9 
Fo 
ED 
D0!m1s 
Aoo
E:
Htag  *o 
* 
eVC| emoo ]A*5ooe
 DIOOKoo@d
D?[N}e _ : Lapr . 0% ]x
klar2uj2h53omFjOF* &V@1 >I* O!DgOЀU®br@࠲4sadsap@$lg ?rdrjQpsnabb0 (sek. F1 B{d StyrRPguen!he 0aer/ `POp e@slaan ConfiguPpoanaf pvt~ndaardQ3!/  scy	WijzigS%ne@Āprogramma @ܠ0Setupv  zr w  ۃrsvei !Behee rswachtwo o1݅
 $X. Ap aatbOgl$$ ID's 	Sm4CP p OauP3P$PcR%mj+%O
Ge0gf3 gssvzie2ۏ"Fabrieks.Cugz7/):;Vref.s:nieuwB8ONc  ExtAccuwB ZeN gese'lec Ea p`Es  zelftGa -schijfeai`Act PXvG0u?1 @I R!a/ 4RUBgDAcg@7n ,DP=%_
 w 9aKc~!: Taal b  =r/em 	rijsgeomaak el=;o" /;9
8ukAZ ]0ayNMLg]@f=S, ESC=AOnnul"EDG,0=!emJacNee fslui@Q,c AQ-f`=MNHulppijltjkp`?gebrui0d )jui~Pwnukeuzk@ark^<ENTE?R> ind 
cr]beZo !vol%@@1  0aiX:  -> of SPATIEBALKc =><-oBACKCEVorigl)TABb	#EHIFT+%%ܺ20+Kq= ykp=t#B~fGouta64k pn It w_ge15 F0M0reqatijasFen. AcoZ0Q1b`a0.i1ZCu  we   Netvoe are0#FMPNp diVbas`e`*
 t n0 notebo?ok-pc/P) @.istNpOQbep*Gigdooh2L	MЛaft NmpALyp~6rocessnel3Q p9p OmPЂP}e (L1/Ly2`Zapac?i VHaROM @ -s!fS<mm E  Hebvrgav|_0ideokp&p;b bpM@	m	ra1b2rd3e4ahisgI t}.jne  C(_B(ЉwMdzQ%)
  `D#SecuibE.aw~~$Ftb%)҆2! dHU2L53Hac-0-*1Tho_ad/resrlafwisn/d pao==LTop: zPٱt<ts ev'ge t PS&BbeЉf  s d1 A:|og-  / "x0zbLe6`NoffaG1Y\f_dقڑD`H

boචgAt
wOC'We nu duъ"
wi	l?oݩ""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 40;q{ho:5broA):]eeqx/nb!$32#Nkvo-IPsE I"
20"qk:J S.M.A.R.T.-af@APP@udh "/:Blo!  A I -7B4kXqcrlpSX8
 Vr!a1& iKs bBs AYoCf#/k, Tm]lijk0UKQΛ zoik` dvor s:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$ uswb sqwYfur9houd'Hi`!  AQ`R`T`R&BhѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gspp`&b TWm E #M"Mg$rgΠ9b 6  ~erX#W>,.o(
h( o( S("7'EAJb"f k otraakP)5w sXbtK;?@ݳ ]Qŉ ڹp1׀frapd  Parˊ Flash-malCdC-r@WHN|ǉHoofdXVqGs`
jE  Uq13xaia DQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L1  p $an=	 SsC  cҦwacJ#! fy0k#0hcomp s%ksMq~`[p%t  Pbc(q. `Y0ppq8_{!_AutomKc%5:)z2U@Ҁr <zdZ==}88! O!V)?!2:NP O! !. Mo0Xe1_joOtD, `   CjrS8ΠRU nt@`Pe@p	M/ # huiǐ,UPd`w~was to/!k wgea. pwW~anvloeC7YkjY0TsPn`pZUt0rAra=8	R0` torH/) bget. Oo
 s @vb뎸. OmRun
1]A&`3fe*& gol q. Aݹ_Ա_õ,ubh A dc3䥼p3ruk3AESC- (A90Ri r4'k'tyUbkn F1!0`ۀT* Zlutłb r3`V4 - 1Nel@@g Mult/iBayjVzkd@\!baswe (ks)re  USB-Մ cb+zlp-" ErF@we鱠Vr V@{Zes >IZ῀>Aa8N Fn/Ctrl< `Owiss/`ߧSStaMcW3MijsappOu Ke 0  nӈ ӫ$l Bkij V o-QPFA/A0d`ditionN  Gvgp<uqVilat0E?b疩p neVd$Radioj _WWAN-aofLooBluet@h/o $JArgieP[K^.(b)ߏc3EtȐ 1
2
3iTo}R/-OMo@bo!023 UPXuAt060!cuI< q6us     ScaGekali@!1OK "2
NeEualR\JO OCOGEZOOO 4^B 1^'OOO H0~pAգ
O$O"Lker-MUE- $J$OC$P 1q+OO+O  [alp 1 ': Bo@19. % ]/& p[0d2knte~l/{	3	˄
foh l/)* Jt  ;>.C,$"q $#axXadap @PҢ(sec.)pop-up bijW snroC aF12 )Kbb cursorytuyEasyPo-muisG1 Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF県Ăg&f 
H
gɁ  Ho׎ɞ 
E	ύXɏ_I  `AO̿Ԃܫ@ea L(eA`LCǗ҃p h/do'o "X yf@\̗L/?E%ID&ID: h (uN XBSA$͍폜eX} 0g J 23TÃ|OH	, v".eI*"%ɀ;FX
 ؖy>f
cA>oAe̒  I(Df:nA%e> pCeBIvCc"F@ `F  H D%Jc9J; ڍc R5BM NP$߂MA%E@U`UO tÃB!#sNu%.37($b74L[BR af=!AEsc=C@bsAS60=͂
ς  aRAg)gjq5\ 3gp] jkڂ %iA@ugp>[Ex]  e >ȳ#wA̘r_->Epy`tOo[ = {ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,10nm˔F/[%  !CG[  @DBCł}@BDrp o 01 OyN^F`+@~3a
ɂACϊOk ~ڑKv@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e`	ýуޯ     xݸ  ށiL1/L2"`OM OM̧Fرٔԍ  ޵ ޼ ް ۰ׂްޯ ްir ޯ#2.3N4h	 pŰϼch3(?Â)FE-3N4(J(kvJ _!nF2w XcopF?$qv sxП6!;LsU+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊOD GPuA=0V @QlA [_CD-Pu3X(^ !} K^ S:`"AzUK^ᑀ %i E_$C0vb@{ y`9`$	5 ;?`,WAT<@fO."i	0	iBlpH	͎T spR@sѿ痣JS{#ۊqH@P!H/)Ɛ!eFybYG q> ߐ Y0ۏ؊ԓ "łb͗L kł粗`Ak)/)%)AxpȦ WZq.w"*FD`nDHa(o(f}@#$'m@\@Z ( ?IO)F) u
χ((?(9(ÞgDu$x#<43ɑ`檇ƈ|M3 f=ɉeN~^@&A)F1jj 8cB  BgBB}AӑO"O cĪ(2ef̯攌8d툐q]l@ӔCநaUC"1/g'y}EE[Esc] @ȍ~elAիmT.?DriveLock }t[F10B MS  y_ԝ7`E: ESxtkGb~@œO xXioiEcUSB Xp H Zip1Ԗ 2b 3 4"567jB8910r Fn/Ctrl~%̐ؑ ǯ@{`\p (USA)> `|*]B#fo+X
KV&Ws
v C\g͍  }]ZJ _ =rIo@⬤ cW>o%wACY Oڑ͏ɛ̧pa峀lNi!WANj%'ML@gBluetootHg/#jְ`ߓd 0
qIntel  Execution DisabCle`0ѯ..12,2O,..odhEthernetX I1237 gPq
 AOKO3O@$OF{j) ID P7bfN P     ' p\cf bpU?ke j] o \(P%*nP/h /!!!MEUv$ )o| ooo)@v!5bv1 : [d . Џ% ]aO<׮2 !gOv
3		)HJ*    5`$>s'pmj&vSpeedStep  technologyBP
u 	_АPް  px?(b) pF12Qiby_R !^`b(aZB @d                                                                                                                                                                                                                                                           ` a b c d e f gt" L      ڏ   4  	 
      
  (       p    b    h         ȡ    z   R  / 0 ^  3 4  5 6   ( ) H  , -   * +   һmp
 N % @.    mm(m$m0+m1m88m>m@EmKmHR_mXm U`@E<BB<U> FبE0`8l v x|v||p0p7c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y ֡$n%Ap E%!IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$~: |  sډ+'()+'* &8F3&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 dmca@ emgm@@ | *@bmW{Xt|dU Zrt}[}#L  ]~&  W_t`$itVa!
U	$
 	 
`	
 &fmU`
abUcDdeDf4Ph(>{&__m@    `m@  
 {j( 
( 
r Kl0 |n o : u*R  	mb $ 9 0
 VF10 Setup Image_SETUP  PD	Sq  ;S 	d% *vE@J"IP Ta|` C6
&$`ԩC ت TԫTԪ*J<g!"$Dcz: 'ᴳ4㴴4崵d紶4D8b_ : (һm
6  ($))$**$++$,,$--9 -g  0	>`
9 
E#8i3jG@ #!" #" #" 
/8 RMUNMNOO 8 @
: 	 
      /	&Wvc  b"    %    O''!(( )P)Q*R*S+T+U,V,W-X-Y.3V
kd-dh.h1dii2dj3j6dk;kdlJlZdm@mCdnDnKdoEFdpGpHdqIq5ajmoqHrZ$Is$i\6{UB |y{ }U|d`}rX}UL ~ `}}x ~U`~n~~tYu wxEѪ~*z{W  }t􏄠k~ 
O5L5(@4Q]`xo:Ufԕ\` dRT\;UU`
fe @9 ԠxԠ  &LR@ \ b v @ L@ @ X z @ @L@ . H T j@~ ( ̀ L8@ R r  @ @L,@ L `  @ @@ B Z t @ @L:@ ^ j  @̀L2@ T f  @@ V z R @ _	L@ & U: N Z@dUp @ @
WL*@ B V Un @U @_L @ @ U`  @M  @ @ U`  @M 
C  U. J@bvU @} L@ U< ^ ~ @ն @ H \ z@ @L$@ 4 L ` @֚ @%@ > T h @ @@  " & *@.6P h@j @$ -@ d   @L0@ Z   @Ȫ @ ,@ Z   @@1@ 4 B P ^@r~ @ @@+@ Z   @ @#@ P j  @VN | ժ@؀WLD@ r  5 @&@:@ Uf   @S
;@ h  ը @T!@  * < UR@f U@ U@ S 3@   U "@(:UD L@RlU @U @U @S  ,@   " JB^z @ښ @ 6@ < \ n @ @! N@ 4 L p @"@U@ h   @# 5@ d   @$R@ `   @%@2@ V t  @&.@ BUB T f@v 1Ī @ '@>@ $ & * .@26: >@BDZ\`dh~* @@h ʚ@ (@S@ D p  @覀)A@ \ r  @ * Q@ : N p @j + F@ Z   @,@o@ , N f @Ě -f@  ( 0 H@Xv @J.q@ @ Uj x ~@M/h@ Z Ր  @.0y@  A	 @:1@d@   ,2 r@  T @ԀM 
3@z@ < UN ` l@Ւ @ 4T]@ ( < P Uh@ @ހ5j@ : OhOhOhGhAFh~ @F 6 @ "L Un @S7@ D b  % 8y@ : \ r   I9x@ $ Ah8 U`@ M@:@@ H U^ r @M;@@ & U@ L V@ZU^b h@rՐ @<T@@ Z   M@=j@  5  >@ J \ Ehj @?^@ ~   @ @ > V j @̪ @(A@ p   @Bt@ b   @&C@    $D @  ƚ  (E@ j   &F@j@   G @ P   @(H@ Z R  Ah5 @ I@@ U\ r  @U @U @UҀ @MJp@  U0 \ x@IMh AhEh@Eh A K@ < ^ vR @Ih@րAhL @ T |  @"M@ r   $N@@  ܦ O@  ̦ P@  Ȧ Q@@    8R@   ,S @ z   @IT@@ Z B U@ LAh1
U@ 2 R Eh\OhKh(DOhGh @Eh A @V @ L `  @
W@@ L V p @j XȪ@ & B j ~T@Ф @S YS@ D n U @M Z@ P Ut  @@ [ @ : ^  @ܚ @\@@ 2 Z  @J]@ N Up  @ҀM$^ @ z դ  @$_H@ f p@U @؀ `T@ 2 N ` Uv@ @ހaT@ , @ Z h@zOhOhOhШAj @b Ģ@ 6 "X@z @c@ < \ zT % @d $ F T@tR Ц5 @e@@ UV h z  @Ϛ @f@ ( @ JJ R@VAhZ @h ަ@g@ P x  @2h@    @ i8 J j@| j@ bJ   МU @ր5 k@ UF l  @5Ԁl @ UX x  @M(m @ z 5   n @ Uj   @So@ h  5 @(p @ U   @S q@ h  % @M@r<@ 6 UV n ~@U @U @ҀU @Ahs@@ , > ^ v@~$В ШЩA @t(@ @ b R @к@ր 
u@ : T n @ @$v @   .w'@   ,x C@   4y @   >izv@  { 6@    |7@ < Z pJ @@< 5@}R@ TBh@2f r@ƀOhDOh~@ Х$ . Ah4LX \@n @Ѐ @ R ~  @؀@@ 8 J v @ƚ @ 6 V l @j "T@ AhJ j @A @@K@ * 6 D d@zj@ Ԁ   "@ < L j v@| ֚@ l@ d   @VCh& > l @ԀH #@ AhX x@U @΀Eh
@R@ 2 P f ~@j @ *@ < R h AhOhOhOhШA j@ڀ ]J@ . J "f@U @@ F AhhT % 5@ <@ U< \ l@Eh @1@ F X j z@@  I Z@ $ Eh:@I>B jFU`t @ƀM@ n Ր  @TJ@ R ~  վ@Ԁ
Tx@ 6 X j Ւ@TN@ \ f t U@ @Ah @ e@ v j  @(f@ t   ֚@(@ ~j     Ī@ X r  Ț@s@ xj   
@ v   ؚ@ @ j   @ @ @ b v J @jAh Oh Eh@Ȫ @ %Gh " I:B@\ ҁ e@ < T r@ @ e@ L l  @Ҁ @ n   @ f   @*~@    "@     @ z   @k@ R n R @Ih@Kh* N@rDЀ@OhЪDOhGhAh@4Eh@@ U$ < \ v@բ T@ \   @ԀT @ P j  ը@Ҁ@@ R r j@٪@ P p ~ @ .@ b   @ @ @ `   @ښ@ " P  @К @ P p  @ؚ@ |j   J@ l  @U @S@ N \ Ul @M A@ P Up  @ڀS  @ L r U @܀OhOhOhGhA@ > ^ | @ @ B j  @ʀ $@@ x   @@@ ` p    @@ P ~  @䦀 2@ @ R n@j @ j@ " * &@8D\ x@ (@@    " @    6 N r@j ê@ z   j@΀Ī@ . J V l@ @ p  Ԧ @@ h t  @(@    @ p j  @@@ ^   @(Ā@ p j  @@G*@ N |  պ TL@ V   U@ʀ 5@ ǀ@ U   &@U.6P X@U`p @ʀ F@ @  :b @  @ @T d 5@ @ UV z  @ր$ChN z  @ |@ z  ަ @@ t   
΀@ h   @6@@    @x@ :R Z Bz@ @Ё15 @@ "@ OhlDOhЈ R@A @5 @ UL l  @5ʀ @ UT ~  @Ā 
T@\@ H n  @ @ @ ^  @Ԁ
 U@ > `  @ʀ
UCh & 4 UV@n e@Ah@2R@ < Ah` f@Ր T @ B j  լ@ЀT@ T   M@ @@ P E~  Ah @T@ : F V Ur@ M@@@ D Ub  @΀M @ f   OhOhOhP@؀M߀y@ H U^ t @5 @ UL l ~ @5Ҁ  @ d A%r @  
@@ < N d z@ O@ X r  @䀾@ F T ` v@ @ @@i@ `   @j@ z   @@ EhL* b@ M@* ;@  U  @؀3^ @ U: D R d@Ւ T@@ ~   S뀎@ X  5 @"[@ U~   @S @ Z  5 @ @ h   T@@ Z   M@ @ b   Ahؚ@ J@ P z Ah@AhR AhEhʀ 2@A@j @ U 8 P n@xД @@ަ @4@ V j  @ChU0 F \ @մ T@ T x  պ@؀"J v  ܦ@@ n    @@ d   @$ x@    @@ l   @I@ J Bh U|@ Ё1Ah @"E8 OhjDOhЂ@AhӢR @ @T@@ J ^ ~ U@ S @ \ z U @ЀM @@ T p    \@ 4 \ t @ @\*@ R d  @Ī @؀\,@ < T v @ @\
@ . P d @ @ b   @\@ X   @S\ @ : F UX@l U@ _\@ 2 UP t @ն @W\@ 4 L Ud |@ OhOhOhA @	
@ 8 R lR @" M@
@@ F UR n @%\(@ 8 T n  @ʀ \0@ @ \ x @j @
@ ^ t  @ ֪@ @
\&@ ^   @("@ ~ j  @*@ b z  մ @
T @ l   M@ @+@ < UR ` t@U @ԀM3@ X U  @_"\N@ r Ո  @T@ \   }@\6@ UV   @_\B@ n 5  @5@ Ւ   T(@ v   M@ > U$ : H@`U @SI@ @5 @ U  ( 2@U<Vb h@Ux @Ҁ  7@  ,TA\@p @̀  F@ `   @ @ p  Ě @@+@ M@  @2 @   6!@K@   :" '@   Bi#J@  $ F@    (%A@   f &@@ 
 JT fgΈTЁ1Tb @к OhDOh' W@ 8J H X AbU| @5 
(@Z@ Ub   @S) *@ z  ՠ @*Te@ ^ l  ՠ@Ȁ+T@e@ X j  5@ր,E@ Uf n  @5Ȁ-@c@ UD p x @S @M.h@ R Ur  @5 / 8@ Uf   @S0i@ T | 5 @
1g@ UL   @S02@@   i 3c@ 0 F Z r@ j@ƀ4@P@ H j  j@̀5@v@ P t  
@ЀOhOhOhЇA6Tq@ H \ p @"@7 j@ r   @8@@ r   @ 9|@ FT  `   @LR@: h@ X d U| @ĀM ;@d@ L Uh  @ @<T@    U&@Jh 5@ = @ Ռ   0>T P@    ?@ R Ў@ 0@ N@   A}@ D T d z@   Bu@    C@ j   $D @ ~   Ee@ x  Ԧ F@ \ j  @G6@ r   H@@ j   I@@ \ J  @AhS Jq@ B Z U @؀@K@   * 4 >@FPZ d@l @j LR@ ( Mh6@iIN@Eh^ t4A@؀M @ R r Ah@N @ b ~  @ԚO @ D ^  @ P@ z   ,Q@@  ަ R@  Ȧ  S@@ z   ,T@    U@@ 2 T r @ҀB@V@ < j Ё1U @b OhWOh@<FTR h@n U\@є M@X@ T Uj  @SY @ 6 T U| @M Z@ 0 UP f ~@  մ  @[T@ Z   լ@\T@ > j  U@ M@]@@ @ UX z @5 ^@ U4 : b @ն _T@ ^   5@`@ r   aT@@ |   M@b@ " U2 F Z@pU @5 c @ U: V r @լ dT@ L l  @OhOhOhШA@e@ N j  @ր
f @ T z  @Ԁ$)g@ r  ո@ʀ
hT@@ 4 T h@ Ahi @ * D l @ @j @ b t  @ @&Lj @k@ v   @l@ x   m@ R* | @5 @n@ UR   @S0o@ \ n U~ @U @ހSp@ \  5 @q@ Uv   @S&r@   M s@@  5  t@ r    uT@@ `   Sv@ d  M 
wb@ L p  @*h@xT @ ` gv U@ @LT @̀ @yT0@  > T @p|Њ$ AhEh@Ehi Ah*z*@ x   Ҁ  {T@ Z x  մ@Ԁ|T@ H b  $vLЀ}Ԁ@   &~Ԁ,@   :4@   @ 5   @ 5  ,5@ U @ Ԁ  SG@ X v B@֦ Ch1@ LJ `@Ж@DOhKhDOhGh} L
  $ *@<Tf @ 
?@ R r  @  ޚ  
@.@ 0 : P d@R@M@5@ T p  @Y@ @T @ J ^ |L @ @ R l [ @jL @"9@ Z  Ě @ @    @"C@ n   @$_L(U> J \ Ul@ U@ƀ @C 2 J b z@ @1t@ Zae z OhOhOhARTA d@U @؀ o@ "< ` @ܚ @`@ 6 %X t   U( F X h@Ah~ j@ր@Y@ D R b nj@`j@
@'f@ : @ ^;3f(B ^@ @@ f j  @@R@ L Ahx @ж @,@    @
@b@ , : H \@br @Ȁ @ X x  @ڀ Z@ j j  @@ b   Κ@*@@@ ~Ҁ  A@"T@@    S @ `   @ހ M@@ < UZ v ҂_IL @}rL Ā   ̪@Ԁ  @@  ( 2 xJ-@ %LMhN AhjIx@ЎвM @ X l Ah@ @@ 6 T r @j @ R   @6 @   @`@    4@    @ j   2@2@    ؚ@@@ JT Bj |@E Ah1 @@ Eh@ OhbDOhЂ @TBR 谀U @S @ Z | զ @(T @ Z p  U@Ā S@@ : ^ Uv @M  @ h U  @M@ ~ U  @St@  ( UL Z@vբ @ T @ . P ^ Ud@ S@@ B h U @̀S @ X  5 @@ ^    @@ < N Z x@j @@ͪ@ 8 P n j@ʀ ê@ : \ h x @OhOhOhAU@ M@@ L l "@Ț  @ 8* \ ~ @% @@@ \  p   @U  F ~ U@ S  @ $ 4 Up @5 @@   $ Ah(@,4R p@j ( ̪@ ~   @@ p   րT@ , H r Ն@"T@    @ä @ , 6D T@j @@ ` j  @
@ n   @.@v@    a@ nj     @ d   @:ɀ@  ƚ  8ʀ{@ v*   @ @@ qLU" < Z@zU  ӦU @ʀU @ j@T @ * < V Ur@ *Ь@Āހ@AQ,T @ x   i@@ u@  : Z z @ަ @@ < Z  @̀@ d j  @ ٪@ L v  @Ҁ*@ ^   @*@@ n j  @ T@ Bn | @1D Ё1
U`% @ Oh,OhH@@ x@Ah~J M @@ H U~  @րS@@ b t U @M -@ 0 J  @oj @?@ P l  @ @0@ d r  @К@  ۀ@ H \ x @ @o@ & L r @ @@ T   @
@ R   @@`@ * D N V@dp| @ @j )@ , > P b@t @ @@ OhOhOhPA6@NUh @ $"H p  @䦀@X@ D tR  %FA% @@ %: ^ %~j @ @ 6 \ p @ @=@ H ^ | @ @Ҁت @ @ n j  @
+U< t  @S途@ H p U @̀M  n@ H v  @T@ D T b Ur@ U@؀ SI@    &@  A .@  ئ  v@ b j  @ >T@ v  @@ @ 5 @@@ UL   @S,p@    @ TX@ 4 Z @Ў @Ā ֪@܀ j@@֪@   ( 4 P@j (@Nh @
T@ b |  ծ@̀T@ D j  U@ S f@ `  ՠ @Tg@ l   M@ g@ x զ  @,T@    S
@ d  5 @ @u@ U: X p @B @&p@ . 1UN T@l"EhOhиDOhʇ 
 @ $PnPm/ /      Z    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй 
Us# hNfP u	fX@  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tKdmtE$fu
j0t0t	dp.  f]ZYPSRi uLHSrL&jmsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡimxjwj  :imtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
cmD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vbm kmff@EFt!hXUgvuN>tO6f뿢bm Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% cmSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVmmu/(` r'(>  4
P  ~
 @+=hn+( ZQ   f3۹ fbdTt ` 0:Q ?\^8ZFfC⁢PS@sw$yk{s>
p"o
d
\Ku@S1?"5`,KuZ'苆FFLKu FQ$Pdm$G^f  @s4j2jgOH^D	%߉D	f:O"-fp<v PfUJ?f@KfffQ$f6f> f	>fBf0+ff]X߀ t p,rPԁf_z0R0Ӄfw3 Z`R҃>/ t5  A U@@!`0ӳ
@lAԟGRV&H:f;tff) F#$A^q$e sqSf qgfÈ>  fù fAB;t)gf+ C kB;PEQM`?k ӒHGPV  ^ h2 ;uБ;~ ;b 6P6UXfm.0XR @ y  	`@  Q}o+p+ r3!B +!;PՁ  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXhޤ<fZf_;>+uƴ+kmaPS puve+i@g+j+a+U/xklb+znmc+D[XF f sf tf[ Ȑ![YZ_]e È++0_Q `+ cmPcm j0fdqtu!+! !ddfd԰  >P6Sd ddP ʱ(++ fU0t=T=f]t,>@u%ttt t	tfsN 0Et@)r@ua`ln)s
 1Qh 6 ZNuFk . u$ 
VێeS trNrt ـ?и{D`*fdofeT ff/fXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+NfWpe*&|+8fw*fF*2t*܊e&}+fXAf`PKem)'*!(++ f?꤫"Z  Āu(!`v]+6R p(Q?faSQVWU&dm tdm   i]aLS-120ZIP 25M0 RV:1:o2:p2o2PKp
>w
 z
\5	d+?>s!hErg;<tV< uWQ/f< Q:D= uFfG(* X!X  A0`u v+Qfmo+i+p+j+a+v0 RW1h
ȿZM} tEA /'_Z[M-Sys   DiskOnKey 1 #߅axBgm u @  f<x fP f0Q1"%|= 2rޒ 0w"1{s ȧsU3IH tuRfQf@fPuLst6Lu2r)g&	ug&g&oc\,f_߸ PA߉ rLT f<Q?GQkRlRQbV`cF5Qome}?  į;0hjt@ u u#P-3RAwf?LfHS N 
~1fXuײ?D0U @0zB0hB0nB0mB0cG05F6F 	  g &3FPRrco3W1>#>;!2>
g>_ÈYh|PhN`p&P  h*l }+ZXSW` 1s!$?
u$6˄[          Ұ,Xw @x^0 uY rTB5!0c@  i|X  to   ` 	bho4<fH f5f0cЉf&^h/uf߃^06.sf ff5fP  _5f%@ף% @ B5f  z6f5f=A&  ` AVfaDf=%{t 5t;@3tZ0tZ鑠DfX$g];6  5IǷ5Sf@ t|P5o"sƑ tDf q55<5f>5 u ` _D  2ft.0c@P +orfu$5@s11 >5@!R05'r"b"0  y1VC@f,S	  tX	O*rH'	"	0 
%9 uf-%mtq00 P3U5P  	P5?;tpa '	5 :  rf 
 pQDPΰ*5@6Pf>5gGf	gOg{G{]`db>:'"3	s0	5
`6@#Du	%&0cf65f	f 5fIng^g~W!
*t4h 0		0	  FFhGfJԆ<t
 &F5q*p09u
 'X*w؃ CF&F5&FzqN&EfbL6%@( 5f (f 42a3uf5W  bf~t0awSgff95u gF95u 95u
gF9o5tgHNXfF5zr=jC=0rxiGsVfqS'`c(gF'	5g^ g"G0gF VN* /e*emd&b&g&g&G
0G
 dЪG]d*PGg&Gg&G
 G 3gn Fpp5t	f 6AkG^ 0\PfV csf@mdf p^fIf!5&55+5(5  5 < t5  ;v?ȉ5qv ߄ f@x
BqygfOgG p ,gG
	qGfu"a ?H{f%fE@롬 !gG!&5߮5 Gt@bk!qf#pFcn4`_OBS'PR7з[fS
fa3Vf$fӃ_\Qfyp#{-  !S̡i y ,9t] ``U``a`b	`c	0]	0^	  
		 
					 		
 0hfWQf`!Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r% >q+bAS|es?+rI`d
=Qr7R|= USBSug&|= t t
U	 	`+cTZ +Qޡ p arQr C0& %rP`6@`2P>+t QrIt2sQfF`~AdYrSf1fM^!WA@@H\
؀e܉\b< H
p*rA
x @
`0
!?
0
"ܛsTq
{aWa'4"CS# i?D=qp*W.?43'PـT2' oKZ(Z
2(
_7
_=%rt9 R$RS$2Q	@ ?VEB@RP2 3* h > HNu ᠅ T=
XS<(fnT= & y#j6~+~+ r}fPQtA3`>|+|=+p+` pta^Vu6} }+ +.ZEf.6ViEOPpYfX`VEI|{G<`+ fa9?,B3U+=*/G/%?QfPfph`1@YfXY"gN0\J?;G7/O?sc?`MoDA/BA<e=vS$l=38%rp-+<Nt9 ZNtE NNtQ+D$
ƈDFP!r r
9rYߖ /p%tFPtt=tT= t2:t+u:u hNodty(u~(rt{^@<N=@tZN=tNN=`	tHN= <?Nh)6`oXaPSV+8dtd}mޠrgoa޾+8DtD$PQ@HPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6T!
*  	b_.>  
   UKUKo       2@SJ[PuK&|KО!i$ru
w>uK *: | > X * t|KxKxK>xKuKu UKFް'PSCrzK$zzzOKuKQKwKΓQ	z`P/$`
3ۊ `"K&K&K L3 wKpVSbm@t	V5m[^@pVcmTK "`K1m!f4 uuq!S1-mNKBMm68Հ?dm[^pqq?fUo>cmimS>L>im܊&Ldmt(
ߠRKcmZ SKK[ͩ@vf]AA`Ft߀>}K{K r1Kw%0r
 "cm6x҈0EUK h6bKdhEYQ!R) `* aӀQ	k 胢pt1Kh[L!rL&jmSKimLfPSQзKf3fY[fR~Kfwf3 0pfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >Ȁ$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO>L>`O4<hquriVVW@ξ HtAQ Zft(P:Lu 
  gXfCYP⯢qq q9~ w2LkYⷠLDt& {L8r m>taRw
$_^t0%GKLK IKf? t<CpR<tSQLذ&Y[ـ u
l˲qpJ@I - n iSg8   `  8jth<
   0  p 	 	 	 8
		
	 						
 

  fWQf04avQY`f D5 ,+6]++sR (,+z0SD
$&++
ĈD
 1s f_g&|5 EBr`jr  aï`fR))	\		M
vR`UR		߃`RH\
|~*+
܉\*seo bSQoaS͠ϼO" cc͐Ăr`͏͈-&p_W3
	#~rgqWt0Y"@ fUԴWj(?rjdYu6Dlq=UUlUpfqOh		cY`v		xvbFX
 T `&ӹ !sJ%|=td%"y:ur?rpq!(~rg؀2oQVfRL	;t	PAkϦ=}^A Q0   0    RrE {d    n  A` P 0_0 3`  
& Aa t%  	B%
0 #
ک*!
 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
QT S<R"G 3D%M TVaX CJ UK8'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<tS^f&^2c sf^   uh   u?RRfADf380=IoSGuђ s
g]^7!t fo6^	ngft_cRa tpt5H0c @u  u uy0 ߰# 2  P f%ᘅ3 
f>5fDt	u)f5%;5wuf@ffhGftff"Qtpѣ
07f1s
.B  v@#tz<21G0!?<ug


7	u\	Qn	'hr/%_5Kf65	g u%S F5 s@[%;u!,f=4R0	ff4	)ffp	Q(f	f@f[aSfSfQfRfV*sW2c15 {uBT tApN@76g88fI4g^f3f@70	@7f^fZfYf[{fP"Vf
5f=`Bt"f=Ё &f={ 0//f=0 3f=@+=t8t34 , 't"#
ttf5c0 rfFP0fXURf.  fXr  s	 Qfp߀ufQD8>@M ~TR2@(2Of2?f0cBZ{RO>V\3h/n+( ZQ  uf3^fbDf6E  Z<tatG@]_ToKg<u	?.upWJ$< t<0t$ RHP?y"PWT%j_uPlAPy#,RfWPR;5rfc%1f f>a-	f!Effg8u#>_444
sf@[Jf_,,PSt{㻀w&D31=`Q
Yr;f.;ft3Uufif!mpf|_ffm fPtP= v	 +v:P,P}ff́   :ffP  6f1|Ã tL;fU ǰǋ;Ptf} Q.fB	r;rf@u0`b h+-Ñ,.a	rffqp
C	f`f"0~ffROMIfMA{GE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t Ρ V   Ĝcu'[0i&w j3
G94g&GGf{ԣ fCf-+kӸ00pD;gfo&   h쀀1"`W, `П..`B@ԑ
>t1a   #i   UP A :Pnj>jFjNjVj^jfjMSV.>bm tvJj^>Q PSQRVW>vjujSRP#u<v
@wj,xjimujʀ 7UmG r ) 褵\!ujјP뾼S	%x
vjvjvj:ujw/:jP
 hN/L	c? tOûde
	jjrg&w0tRj觴}rZjdr!"BjuKr
? JthE	/CZp4tĳbj&=2ohsg13
	ucmP $cm} Xp Z#,_莶[$$O_^ZYe**=	Q  !   0  " ("2ѷi /f+Ld 4'=m$7g&* 	uwjwj w@MKm &Emݲ`J}"p,@vōp-s0D0Km,0$ 03۰ ɀw%1u> &
'$udmuvtueu^]\uMu:8FPu)ttfu,0= IׅLfg&8!<u	g& `=FtF@sPVS`@m蛱O([^XSRVmWOg^__Cr@ޕ14ZbUf%0ѫk$返[]0)R Z_oR Ն oP&abpZ&&FdR{< u\_R\RgtXr),u@TRG`SQr9R'$8t迠܋Ytr$V簄O㰆HAr(bgFr^(!sqtrp@pp蓶q9``æ  f18 f܀g'0z  pj FFBZss`b PQfWfVӝUU~*nЌP U 'hX+Uu'UG@J  .;qt3_YXh5  `#`Ⱥ0@^	p0 "' J@4 "`".im2'.q q㐰0 0!W
sfUgg& suf3Ɋfа ǯtfYVfWsg<t,zfUgR r!8tfG^fZPQ71$@a@8tPQqUvPKtF X PS2&8tp 6t؎[XPSR8tǎaAf!.bSRغ P BDðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              -                        i ` w*0 
  $ tT _ a`
6* u B KSRP t@B u$Z[SfQWP 
@ Xgg_f?Y[f`Q
`f
fgfafQRfWPSf3f3ɿ f0<  P tf; X tDt [Xf_ZfYù@ fPffffX,fVfVf   E gf^! Wf^	V		)			:		/ 	^		f	W	~	fWf	_
g&' f @f&f_fPSQWV!  tOtъ#;("A$P(hfP u	fX@ߦ  h TqQ sY^_Y[fX[>uDBo` tٜ/ a3S&[C vS3ۀ> tt&t:&t/C p0t<w>t8tɐ/>+A
 
?Tñ a r 薶t3C,NT &&.&&
\
 r3֒<`8l'fP@ &&r! 

Aǵ	 fX t
裵'3萱花
A
 ɗt1-b㋇.frz
Rt0
''< t
(:@ `  &pF> uR׵t& aÉ  H$

p$I$ J$@o$؃y@P]$V$2}L
s3y@si  Y 11F0LY8:wu;pu;thP'ݯXP'!0!  PWu0+K`:u褨r:Ȉ@&uρ  uug 7 &	&!:%0ww
2:rp	
À
v ><  22An` غ   nBnnn?nJFn aSiÀ @E7!C &?!Cu3ۏR .;Z!mh8PPqm:̋̆X軋;讋. %&::茆ڊ>&ߨ.pu	 uà]FP
 XuPwFt+t8QWP3 PXhX@.X=X@uX_YߜPBzP7up$ q+!_.L$> u
P @Xu6C @B T AjfSQgog tHu.g :ff3g&ff֠mn1nfffߋgfffYf3i<(.&gBfsDP
h3 f!r
wt4	fRc6U t u

m(
uXO0fZSQA uMaQsV軼p Up Y[XheNt :Q j fRVhj_ătDh̹hfh1hLr  f^fZ?f`2 rb <_0[fgTg
hMfa~f`@f0PPf3a//zy7fX !7"" Ϭh}{Qf`/)
4/O
, "	 	+ &"	u/	(	1&!_!!!>p!hdOh5VwuG	 [ff
]]ܰ^u2fbZRt Fo<t $rf0Zf]RtEuQVWo 0 pM_^pr}Tf DfؓVaigyft
{t%SY3jy2agQq?"Z0`ZY ^PnWSQRWVhV?r=ыt
 uu	  tt uʋ^_Zqb}fnWV	:Eb3:EF c6W p 2:> u6 GHt\o ?hi/tT3Ҭ?؋h_UB^_fZff
XK̈́
>
2

VT>T2E@OHp
Nt.
Or,R12s0-;-0/ -a`o/ / /  ԣO0-<RwS2.[ ø z rаg`o̩fY="!f3ɋPw`qXp&G     &Wf&t ffBf;Pg&Gfww~rtwRtpff>@h$yp3QY tgh!oAX0!S>aPS 2hWh`2f[H       `  ' . f6%f=HIBM%@ u_Ff!j  g.9u
g.R!Ff F v"Sf= @t1pu  ø gPQ f $a | `!ANuFgf~fVf  t
fP#ff
a2fY#F$V f;s	f
	  fV2 ~(Ff )g"f+s
0	@Nf;s ȢF@	rf@f qg&g&fFfGg`^!N &Vf 1fA=uTA$<ufIg:]!
g
@tT	f@f 胡t=> uԸ o*>p u0thvB}_"350G;!t3
tP s 9tʞ zPX菜>*p 	
du
֧sRP
` Qu9 5xr/<t+Nt&Pu
$&ǝ訸.apPt"Qtq2tn`{ "G Q !О՝uߜsTu[>T&t` M 0 &
虿À>ʰx 
8s \  
t V$<
v
ط   tǀ> t $
=ؐ h?ߊ$(
d t㋷"؊ w^ѧhUl%

\d[	<	
s	(+,^ru &A > u
8wpy߀ 4
A "ub Z0B@hf>]f[Mf iCfdxW'  @/%~diPh @R>ft	Pip'f%İPfWͱCGJX<t<t<ÙPS$<w . pj P
  T ~6   ` a  v!ف@	n` [pp%%fBmFBmBmljfpf{%jf+ '
j00Dt²  `1j`Qaff3f r  襷fPQf<`)ɾ|<w  pa fXf?f
|
EF
ðGw	  I  A?PĳP XXu"BDDVbI`FS!& u~, o [V2PdX	
@k2QP2ސBˀa	$

Àu
<X[X )Aa؀a
2t aP@<KrK{MPR?좔 Z .  BZ s  ""
ZP{pDR   Jq vJ/Q R (
PBX
	SRذ4ZQSW 7W_[R?    
@|f Kff! IUfFn"FR`- pNT!t"ffvfXfD fpfuf_0f M U"  M0  Йc5@ +f_4T  C7l
 
 B6W8P"""""
## #+#6#A#RTX\`gvkpvzptw}@DJPV\n@DHLPUdxxegikmorkpuzlov|`cfiloCEJMSYl M#u@ PP Pw1 ,غ:%  3`  f ȳ^  Q1dW1G3339:)  hy M (:GQW
5ܹ5ܴyޡ Yܴ{_l+z Yܹܴ|^"!Ƹ~?]h!(1ݪd tp'u%th/DupC_ r>P u,p
胭$t3_@us?
 
Ҭ Ä$ k߃flPP< ` {Q''&QvtPv
 P +   %f`#_@t5tfB%%/fBPxx- falCTNI %`AG`f(f3~s VVJVHѡ   /- % 5%dy# 4-,$/-K'4, R'ii! /-% &&'''T,a}'E m'Ш 0'% 0.&, Q'0>!йQ'Q'20:s 2c[UV<202 Pظ S$v fy[.>{L#^]2 	pd?s/(S r.(er&.t wɇr誨ou_ЙhpKOh2f.f Ef.q _hż?> Hr<e. 5b eJ ohHu`@Phm).i)`K4=
03!4>+t
3NO+t3GNOUN{)t){)N)쪺P aT{)zSR)``Ҥ"!$f_p[eQXffXfX*fXahjhdNt :jQ j  ] (tuuu&g~q p  uA[hi_e$P0:X! hh([vPk+F X PSA&X+&V+&T+[XPS2X+V+T+1_0_UaE@Ԫ`O\G԰Yӯ84?8x63, N&3,3,$LMStMF`@S8rddrqS<dr`
d22p@7bt@ahb膦0LzHp=StHMWϸp*-0T?p| & _@ ݊&蠉Xàb                                         /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               K ƨ!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( ((     ښ   ۺ ς  g `g  h } փ 
  ;tp  φ  / ;UhÄ [<ń 
=S       ~   P           %X%H_&                                                                                   _U `*V} `U UPzQ@    @ 	@
 
@P X@Yhi j@klm n@o { @    3f3ۻ%f~fg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>` 6a  !X[ &SP`\@ /'a[&Ջ&@r
f3_f僰?gf }f3fh @p h &ïf`f1fffef   % ŀ-ff0UM00!0)ffXf9ffaf 
  fi@] 0 m q  ,f5q f~PeP Q   U͡A]p  A` efana  !6>eу{p Ń ՃPك"` peɃ T	
e} fe&׎` b "jeɃffefAffgd:ugdfepf3 gSCT "8fF3ۊd[e3 _
td?	 ; |p)" @m 
peux;u._RTC u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_Y'Ǩ ooooǸoce  f`Fff`t$`p$Ū`r쪺  .<t
../ NA NfaÿfPSRV$fpr؀tU./tA
 NUNW!h?54^^Z[fXH"4 PSWR/Qa>ZM u&E q 7eZ_[X?hh_gÀ> tFy_RU
f|ysBPSfQW_fY[X "" "?"PR0B1Z 0B13 $ `%>&!%	 
  3  t!  { 9 z &@u#92h2_xrt0RW0_Zw -HYI#'fSSR1Uh?Af    f0Lfs$R8 fZI%CPRrofPTmf!`'yS'b'

R)	t2*['.>
s aPQRp쨀t hE/t
uZYp5' B}!C
@h1` ~ ~ ~!~0~1~2~ ~ ~/fW vQg&?t"g&Gbg&Gbu Qq& ufAκ(/ 
.uf_ 5`XP    NuXaÊa$$
a wC PB B;ra 5gNQ8TI:5;@
߰,0V:k* : ,
 Q2RWĺZP ,ȡ%: Ë34 g&nD4eD
 <G   @LxLL|NJ I 1
L.Mhj?%Dt$hOrO/L6@,Sl`DDDtD ސ(g@a HF@r[M t"s@#& >wI ^h.إf
$1!ް/f2_f3f% g0(p!P!q  f@
10X/X!!pafgff%lffP  R
 `C  fA"a= `nPL\zt`# u8$Ou0?	u,hTPuX(qt
*DSjyљ֙6ݚ"Gf`֐Aa  6&P&~`X |+v
``.pr&&r!Br  Pq X
  Pf? __a}X,}10uff	<u <u õr$Rr ]s&&N2qrrߠ]rN a`zw7da(SvxБQ` ؾ"" QYabKP  r&&p'] Ob W
ym' P"նS""F"&&a bRj ~ ZQR_r3'H2't2o `2ٵ(w5 ttTZY{a~r#uS-ER-Y03!pٸq4  f} & Z2 &rr8t32}0`.PO h?,啊tGS@1?eh%[&M.2t $?p#h 25 %2W< t 14fRh$2hfNt :Q jޠ h1h<fZrj  pvw@5 
, #!|`e`	Ag	2@ahi
$%00`P 0ϯS%-  D c`6(    pM V魆į^`WП 3 _r- Q+˸ fDZED;{ BЙB O B<`<2rru辽O0W2&*G_YS	 7&*,u&}Z`E1j_k[DAP`^QFگ>  0 2<OtY	B<tmH777rPBBLѯ: r1 r,q h/Dd8SQk?
peat)|$<Pt+fKuҴ~hqiB`UY[[Qrj @"~	ѴuBanYoof	V o^W mQfR? D=F==rN|UtGV Qk4^t1Vh_45f_^Df`  Dp  ; Z x     0Nm0 =$
d_u	q 42{Xҏ	 d HډȃIذJ2ȉ{;-' y?SQRfRBP' w	.>Z0"2a  1 )aJ$t2+``¨ *0hV!u?rEd/(g#/J+(*f(fY<ʥRhgihmlf>QPH_u(DЇ/ ftP  Q-_r(qՉQP-roSfP>fVfW (>f֑1t 3 tf4־0Z fR迌   fǰff!2g&g
fKfRg` gre hջ5rm Z2`>VhݟZ,
-f_f^fZfYf[  r  sRfbXPSfRj07W6uLt;wEf6fQHf8? r/fr`bBfg&rf`b0  Z[XfWu
 f 酀>_  Àff`g@? t]ǀ t
t@f?t
 :   ) _ 0f` ; 6frv`gGwf3 f[PfcfPr:p> ff0;w!fVg&f^ufF=tf!Q. $pft Qg'&$9<&m=f=ATADtlf q:&Ǉ  p s  S3a  o`b X1݋  03Ɋ	j q UFWP3J XU .>:   ub >u `	`	vw=p$l0{^$hC_AR@?U(lvfSIMWuUf, f@ENrfOfAf;w(hӅ/FI"Q;[ap qQ08?SECU7fuBflS@:AR@P_uSXfGؐu(AE_-8$81B KH q Gt+S
 
TT<tT݀t>hݿ
u^ 
@ Ѐ !ff
 gw	nßJl& t
fWk&f_r2#$g&/  Eg&	2tWV`p^fGtt2t~tyfs   f`w'pA,u(<0v z^ @ u^/uBO`xd rFf;r>`L: t, f    ur%)rQY9	 a]s_   t%>ht`A
A!:0./2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t DU@@DC@Ò@0Ű0/ϧrwp		P? u ff!` B
fff#Lp 


g#rϧS`|
!ХƠ3Ұ"t3 v =%`h
UgGܡ밣V1
< t6z012:u"FIqr()PD1' E-fY&7~@ w.	A_S 
fUfp>t	--


f;+Рf
B#f]^P)""^  ,gbwXv0? An@u_`$fB %  
@_#_#_#MfvfrgG(z*S+r[ ం0PQ>>ι c r\d`>PSCtC>>r-t`w 0 r uҊ1 r
-`u`dPqQ rdItf s` 3fSRNr&Kr! [ww3r r	 ЮfPRc!0؋r'p܍ȇQPQq	s
d Sr	r!V>Rf   dg3{uwR Z '}hГk)C Z~{x. Ӱ P " Y0 `2  p",u   P hE33R밍

Z@u
Sذ* o rQ(`( @PS  I 1' R۰RU  厢rPX3DC	 4ïP>DS t3306J*bRމ
t#4 c ttaÈ  PQRWV۳۳+3"a^_Z$"#P1$G<u@$Vճ 4^W _ г	"  !(e糹_ 	J
R
q0<J
g&/ܱ1q;-r r;x;q;óPR(XוJ2Z 0[RVа$rN ;rCr<,	r32`trr;w tsڋ^ZW
   е0u
˾Ш 
u P f! uf _2 J332[2t@@ 0 	rn
$	"
ſupmƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_......6r.Y.2YDذVPCߊ7m\3 	A!˱5
	
QWfV3 P%Xt-f[]f  f^_YA.fUf.6 f]ff]** End SetActiveDisplays: \ PwR$nt5< u Q)㋗(d_@-;t  _um D @Ӹg $tupZQ2tN
͋كHP  {s@t[dPЦ  |~GO
 ^BRR 1p93t0	p $ D {qPSbbUg
10  P
u0	tR	g?9oXgPP;jgP$0 igZgċ؀ YgXQgX7gPSRث0/u*"gZm_RfPabPtQfP` ÀfXfڠ fQRPSa[X3`Ga XB"cg
rQ dK f`}0 ./KOu$Zir
u.2*q	, trp$p&` E&]W@ _fap{.A4t
1/0g???qSQ/"AfWU]aW_ Qc b rH rtp	WBT~tu SAC_f`f>v ; tЩf fRFfa`k_<_Pfgf2gaЀlu$tQ SP܀Q$~X	3fAW W6XWqHȎt/O  3  v ؍`m$^at`ZON@a<@C OO_ B  i6fu$$t$
!$$Ah1ϭTsU`9t4>0t,PQz uXa    Pj; `   Vs D ` d h            B @  b  `@H`X \  HT3L4׈ 50@
@
`1.                    Z          14    XYhijklmno 	
@}
                  K _,89:u4NNO  OfhXukWӬg&f0 Ofg_f&c@OZ	(tq0pDNf cqfRVW _f Q  K!Q  A!!ȑf%tf30 f.2fffu_^fZtf"Q ء f' Wt
?f0pɚP3XPSVWfQs: ؾZMي 2u ufufpv @uf  fY_^[XQfźff
ff0 f'p  Gd4!'vf_Y"OB GdGbR5 ?  J2 <} 'f < 2<
 1ꀤ a                                                               UPRPRVFZX0RR30ZO                               ݸ ȋh3 =wLU #Pl hpOdPfB(fXfXnU ˟ø0Aq  Oؐ	r ٲ
IDzSzTJuĽC UHكIڄD#
NϿf00ffЂ f+fMh?ff-Ef?ffqۿ  f>PAMSuff>r^0awS0GP`0X>X˸ fpG|	! "f#bRWVf1hfNt :Q j rY  E6fP В hgh-r fv fh1h^_fZÚ
hjt.rB q@
E<u|@
PY
`S=fat0ޑ(?"a`+j uL$<tD?"pCQ>r&=t&} tV" &GF^YՃ"
\ؾDaþ 	 hy+
!
"sN

ZN
P 
  h@< ( L P~R ĺZSRغ0 t@Z<
w'>p8w&b $w	ϗ&ñb0.'4`S> t=)u7 u1cH*<t&t!u诳[r r	B_ S ٿKtZ1gtKz[r3g&GȻ ^s=0aQ$
_ !Og 2`YcKtg&G"r`dKt%t7X	
   VȾE 8t"8tSr2^SQ^Y[t,&
u墳>ut
$sE lt> u.~OP"t$	&
sDa%
tG%	>2
XY@$t aIT`Ku07tC P M< to &$  
` u[>{ ؀
	 >t bOt˫00PU'u@Vg *Lr$@, "tk>1u
 {dA  (r"/t[^\J]SQPXt}V
r@.XGHtB0T0.?Mr/ˬ/Y>6Ht_6EtP rB軱3(sGu%
߀u "7H6 WE6A1Jtzu oVctb;sW;sQaIVu	Ku u"
uߊ,"߿
23#V/  à/Dt "u* F/)P16tXSfW0`
;GtpD_8؊f_[Ó +-fsg]d  ry
/-# fPRfQfS [ff%|h f
 1pȺ4A# uOf3\fát(,#%9t0!!t1 f0 t𨀽f.6f@Ff fo[fYZ0Z5! b׿%53I_ CfW d` u8  *t a	ofݸ!f_À 
1 <Zu9p?ErFp/<E`@ h^f Ԡ`bп0yP ~fQ` %
0PPú:cktf`@# ۇˑ P D1_úd u"AuL " 0 t 	Tf@ @* ӗɐU ـ@g&SS%` &!#4R%0(+1#Q~R`~-if#fm%g+oك8s` $B'
uf 3 Q'
f~wP|ZS	2;w A''sp
fϋo1gm٠
si!=qfYfĪ & A%#@3RS؁-@!^SCV p#t6ۋ& %f&ȿ ffP]t33u⿋^ Zfp
3һX3t@s7rS
`'`' h%! o
 * A40*R0T0	f%0OJpÖR3&$Xb P1T؃2g沱1BàRfZ,.028 ?l+T,'Bߘ}¤)% &J	^֐6)|㠽QdJ3`ȺC 0t蘰o  q&au hx  
|   Y@t_R¿ 5P9ffX0:f cf`+`ư@A   ` ?
aA|!tPfQR
ܿܻ 33pj#,ff?f
 
|"@1f rUߋ/ܒ3%\hT0ǳnp<@j  j  bj`1WrS޹7f1- rMthVcbI]ڰQa!% = u5
D= 0u= 2*q6` G7!/g 6f#U1$7Zf# 9#t} 3DR_1\+ `\brPL Q   ,A048  Ha=[#V5 A SFClhDOT8_!Е@{3  P!f4pQwBJ_Y Kp[wUf1  K7t2 t,!NfP _OOqbtRy'qR#S'1'pT 0gZw`sְ   rgiPQ 9 P
YXPS` ؠu  @`;؎0tRf¿쨀u Zlfa-Jnh- @(00	kpoEf p D  &Et"D  $D( s@`&t0v p@4>2@"߃Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m ?
 m pj's 0P^ ar ?* @߃OQa	 & a@p# $$<@t"hXO=D=KuKf Kuף`.>
st&3r	&*rHJ`o6aô`prr X ?etrKCp0}qw1#!8Q909$ a0){fRQS[YfZķt'1pt tu
|  ar0U
ADȁmG}>u f ? hYruf>YrfffӸ ~ f @譿r<fffHff#f+ִ f;wf3nSc
uff+f뺀Ƒ
 >;-/ ;-߶M\~!}긠 
K ,_,7N$T;-cUD;-穗LCU;-#;-;-	;-W$;-+-+-`Kz8x
	lֺ^f.6.!u<u<vw2.%Ef&@ SW!ذsCrCP!'[_ am;xV4tڐn? u_v[ff[0蔻A Ap'`^_!h...6蒥l" ]2R'fhfNt :Q j s""8@+.h gr0 A@fP@.C'R6fAlqm	sUdr
=h1hz<2s6GjnhiI'IydPD@ hstx@WfV"D H.3H]0tfY0VR&l聼QY{f^mR5_'ClRQ,3ϟ֑:܏qd=B+ràq",-./01289     K`a*_bRF*$aP~%G3""
P[2tϺ*Py`>}#l>0l!GA lBla6$?C&![ G @ A B  $0sF  n "  BnnnJF$a %JFx+P ,<- tq ̢.P /̠_̡00ޢ 1  llB  ؿA lBB@q뿺 l@    @ lТNQ&aľ'x~ /$а 
_@  
FFn T 	n	n	n	Un	n	n	nnn 
  t,?+a  1PҲCd̀/.`  3nnC q
p		 nA
` na44ޓa`UQgc&@' f`8P%#%z  t
ف     tksPR 0@ZX葟w( "'+7Xt
 % Pé t u>^u?^ q _t`@Ю`30
t%%tNtGf3 f0ff_3udff  
fΡ1Eﴁ X ÛP[.Q#؁ U~~	=c	%@ OQ#Y3o#pK!`  _pR).5 2 &%?
 ɀ@1Z@Peb
x  (2u # r`u躑
 z9
 99fPb%蜝t
ff%fZfXr6Q $f@$f_#$S% 5 Aq p#fO t09 P
 0%-frfg0$p# %3 'uu
`&qf}+ZYf[@
PS84 8T T8hΰ#R	 V1Ar5fﰿ-A84-gU8#~3p(8؀.@uR8ttQ@t
1S
8uf
w섐 a#2E p  P+Gho\/C3C 'G4Q(tCEB5ft.fmA A   u1  dhQ)
  '߂  @emimh+Laf@R$g#4h8&GW b
X babRPp  OZPU^?u4 pbyKqb cY!I0Rim Gh1H	
2
(.&"g t#."׃0Q' T
.t&*0X 0X_ O5 ?                                                              /9-OdQ 
tRd{          `ap                                                                      V  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ۯ1H68DTU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 9ys耂 f    Q7sY 戰f
   ff    f   tf ff
  rfBYf戰YgC !f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3~{f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰{ 撰fPfSfQf   fQf3یff
   wfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
fA^gf  ,fsf {ta$f  ,fsf ;Ef  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf iCf  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G       	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	    , <0     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                             	4 @      T                      d  ` h   X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < flf%f  $f$
t)ppqtfmfupppppq,mJf8mfupppppqf  f  gffLggf^gfnf    f
   "ּfm'fupppppqg- fmffmff  @$f@$
= u$<& fnff  @$f@$
и f  D$fD$
аfRngf% = ufnnKf fn6f % ugfnfU../0./.fnf d< ufnfd< t<t
u掰fof䎊foff,of掺<ufPoifZo%  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fp  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  K"mlfr  ?"對 f    < tg    f   ff   2fff   ff3Ns.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2TsT{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>fu	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
kD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4j hf`  fg&Ftt vugf&>tgf&6f٢j &fE ~f^Y[fXPSRfV tA % kg&ƅ    f  q\g&  	uf^Z[XPSRfV tA % kg&ƅ    f  qg&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  fA vY[fXf` f;.bt
f.ba   ~$C vf3 
 f    fgf&E   >a uFa f  gf;tgf+gfkf0fp  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f  q <  f  yg&"  @v@ g&  s f  y>j u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       ' p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        戰䈽jǒ戰䈽גyݰffڰff;ܰff߰f%f/2 f%"fGrfQfٽWܰfcVfmHfy@f >ݰf(fܰff f
   `"	f   f3f30f  0fۓf饔f   f f    0f  f f   0	 f%"f$ff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.cf  
if˔  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf   0Uus  =
*  >rf*g     ( r*  .*V>*M*f!f<>*3*f!ffrrfff> wf   >**f!f%f%3fff> tr%f> wf   >**!/>**!m>*d*!ff   fF>*=*!#,>*#*!#>*	*!f#f * >* *f!f'f%r$fff> t%rf> wѰf    * >*ur*!d>*u]*!R*		 D>*u=*!/>*u(*f! .*d  *>*	r*  KP	s 撰 XÅD^}ؗ^kqטfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yursfZf[fXPR tĺZXfSfRf@
 > uB ;yM@t-s(xغz,y0@usz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>l tVg&4  g&;  ĀuH g&  vКl f  G 
fp  hfaPSQV L	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 mf6js>mt fafWf   g&D= g&D= f_`r r8 a`f   gF
$&n
gF
&nsw>mtaf`f  gF
$&p
gF
&ps@f  g&|5  t>mtVfarfWr<f_    f`fif   g&D= (fgf&T=fg&D=rL6ff G fr6QfPf   f>i gf&D5 gf&fff>ifXYsufa`f  &n gF
$
gF
f  sF>mtma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
ЊvaҞ  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f     f&  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z`fPfQfW3 .;{t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[    f  f@  fPQgf0& YfXf    gf~gfNgfVgf?[fPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .}<t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   T r
g8u   f[                                Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf
   f   f<rffYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fBwf{fUdfd    2ø     B  @ Oog齒06/08/05DUTL