#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTD)  - Linux-Based"
BIOS_VERSION="F.0B"
FILENAME="sp31378.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  G<3<3  G<3 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  G<3=3  2   8YVU   BIN  aG<3<3   03    8DTA   BIN  WwP<3<3  Zx/3    8DTU   BIN  S<3<3  *r/3    8DTD   BIN  *tV<3<3  N/3    8DTH   BIN  MX<3<3  M/3    8DTV   BIN  &Z<3<3  k.3    68DTD   BIN  "L=3=3  N/3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                ABSOLUTEP       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412- No limit for non-DDC monitor
- Disable Rotation again
- Enable SS
                                                                                    Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        		
	
		 	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
 ` X                                                                                                                                    !    SI-1362-A   p                                                                                                                                                                               H  <       
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a L  XL  XJXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XJXL  X,                                   U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '           POST5 $ - J  ] H GK 	 x
 , p U,
   + ە  ^ t, e ƹ P5 5 5 5     x 2{ $z  `! P" .# $ ./% & q' R( 1) ۅ*	+ l, y- ;. w:/ ^0 31 2 Џ3 .4 5 P6 N7  8 wy9 U/: Ы; V/< = /> v? 1@ W/A G^B N^C t/D E F yG H QI +J ]K L ,M {N @6O ,P Q pR .S фT /U V jW X -Y@Z [ =y\ ]] 	^ TK_ ` a ]b f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hc [X <t
PW Nf&E1_X  fPfSfQfRfGenu fnteluxfineIuofPP%=  rYfa2f   uI؀Uhlt/f00tf  
 p0fZfYf[f
#PRWfQ
u5p 
(t' f0@
u߿ ho8ufY_ZXSQW< s13
@3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	

@
		! &
%3
> h3hp0 0t  u
.+u	u/RPVoFI` u tk@.tމ^~u t/ t^6
5
^XfQW~
,  _fP	$S8#:r#Lt<
tw
u!ο 	/ǫ_^p	9+5WfV*0#)6ڐS
F f[tҋ3ff^ff[f`K.fa92 iD0CfVWU+D t  f7hD%3 tkfAh6 Px'Q2N7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^@Nf`Sfff@= hg*3>+f;r[dC aWp
2hq_
 WX
_: r
gN1
gBr @9ʞ9 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?" h fR   둡4]hQRWV^NV vyq6Q3qI4GYGʫ}ΕI^_Z!3Q'M0 pC8 YfWV3ff"1*bIfPS. .+F+  f+o^E
N~u!h*h. 
 蟵GuQVRsuR?
 ۀO2ۊ~f x߽k:P`?tWuf  f.+<ftf!f.@# ?
uF8Fuf_ts^GVR.>+s$0q	.k6+.+z

ZFHwPn2
F0+7FPPv2P1N~ t4vf2f:10~`FNNI.+ƔUfVTQh}rLS  rDSg0h`# @ N   gf  P^ 05*g@F]|QZ6  
fvh.~uF F 73hy3pZ_YH	h^y r rD(gf 
  #ƻfRS ҜN&t}Zfv tNhCHtDs ʆ hU/ 3hBFv} ~&#3
Pf~fݥXf   @
>tq  tgfNg A	~t{-F  ΁ 33
[a3yuBF t~y2h䓨Ff3ҲZhqFFf;Fu-0j43  
% CQ|u@(.;+s0~ ˁ ;u
t`t@Ѵ d^rf(  _^ZY WQ3.>+2 .ǅ.ƅ ` P@h1ZR.ߪ+ `$S 3o.+h ЛZN [pwFk@"~ 
N~f.=6@.2ɠJ0[tEu4.Bf<tرf5$< F.v 
1q_V@~rF F`! Lru~w
`~M~fɢ1Q/ t
fNu
ffs NFw^P@j4P*Q
Vq4F$<u&_F # ~P$wp` .鄁ph {<'u{8^`}V@g+@..+g+^SV0&0
9t@-2x@2
Eb/^s[ 65^35#u\BX:NкuP:
t3S9)ˁou=8N0_^WSVR`rfn*v[ܵ!ffARffTЀ`2fywf;w
2#ofPRf@qPt#f3!fD`2XfffNL$ss4
tu+q%
u	[A^aJfـf^Z6Waf V^~Kr"8uffFՋN_QcV@wvb!F;pI3ϋ~+c:sRVRfQ_;Fxu p? kv@kFل:`b:$$@K@3frD ` w;=< u  r7,.;D$<u r sh@BvFfYZ4VWӢ Юfݻq~Ud
t"t't @DvP }xPk9SV0޾W3; t	 r^[p@kW`_#Aq[%Sx^Y@j*pt@;v7h!tk~@st 1;FtFk^% Bk^Wa 3҃  V3k`[
C*䊁W;FuR*3]0t7_t-k		# a
@S
+FHu
4uGrvFvVBs0;~HVW΂tS03ދ[^NuVp _3ҋ0_&9>1-x4Dr<b}lFkHȀ=BHP뷋A+g7oZ Q&0V_  ~u1|\΍0PN~ tKv0YFQI.Qz$ x
fpO3g~ FfN@P@ 
0K SQh+	 \P,Q23If.` tf.&!. .8+tьL$QVW
τfvF%p"`F^^F  FψF
fgFF Vkeb"^`LY`!ɱ ``NҰ tFt'fy`e 9Fv@f0
FfH yQrZրi`bԁabfC<4R^VFъF8F^ǿ  pQ0U" R$ S&T(T,ܙUtN!!fsШtE rtsCA9FvG 3r%if.+N  `N0683 
t
F%  .pO c>fgF~ tf'iz e{u
 v@aQI8t%  vu Yw  vfIft'fAff#a 'fp=rS6.6  G                                                                                                                                                                                                                                                          % <	~) PQRa&hlc $` hV<rZYXSQWa$a$a  h~ h ӻ>5_Y[2揺 TCA6  @A }Q C@@ @;uYð!$p h
f`  ĕ hf4gf&     fa.0h
p
o
hsfPfW@&'UNNNO<u	@NJ	_fX` k'80/t3%;0h[XT[   &  S hDs׍@   >N&}uu h{U$31"d %
  % X}W)-)$@#hff
, Àtf%f￷hsȕst h:.` ܹ 
hR/`|vñ0  Rv   p-9 5  f4%  0^  ' й %{_`%aPb:  h( t
 D&aPQ * @ PQ= `t
3f3	@fYX _>ðѿd` 5d  UP@kCuS WQuF  #ؿ
Et&؁@B uM9NwN#uӃ~ t"F= wt%   +wpDXh!C?`.0   !	 < a `hZ2O t*` u{ uL>/ua@tPRfZXF+~f.~ AEf` f   8IX1SfQfRf K  f)  %=uf?a2 ffZfYf[Nffߩ  @ 1a@ qJSQRfWZf_ZDhcD9hf`xR Cs0OO2襚rH
tfD s8! h`frs1ܔsg p>5i
Q?jhjxZfa't5<t1^~f aqOg@ Æ B<  C< $ j# Q R STU U VWUX YZ	f:RVWc3o0K-D-
` TTfk|G G{уt]RYR#st
S hN[,Ⱥ:Hp 3ȰS8@u^S=h~ӂ^ZYLq+G     > ୛ A  T h M e M A@ }9 Y . S  nG SA ǀ<cg (
Е2v Yp+Y{!ZD2 P fL5!p]6,5f6׬4F  3 p} 64>xAI.h3#PSs $<t4r [ ! Ѝ.͋h 63 @` f`4 S  (y6Yh?s%h>c v FD 30Dh"ro< teF2" iƾ
o ǿ-r/ǿ r%@@9&5&D&ENƿ7Aa
p_h  ߿^p_\vEurV~^ 
8
3
~3
?E
vC rPQǆf&@ U= r&ǲ+= =rW>]&_<PrG&d&&@
, fgh  0 pqr  <ABCDE xyz{|}  w 
fqlr:8R 
5&7ȾG8B r
&  ^ T80"[ ]rfX_V3
Ê^@P$. $t ".FuN.PW#% _XWfVUSW! q(fv߿ h.}  Q$~22ك!IN܀3d	^
u
t_NA&>-_[]f^_PVB&=;u&&00u&^P
P< +&~&@-E&DASV h@2^[9`WWfPAhȁ  <fX_F[F10=ROM Based Setup  Entering@: `. u  C: MЀt.@:@p[; Sum'`P+ W  i:p s!	!@: A:QVROMòp &@:tJú zt
.>0	t.h9PXh'nF12=Networkrvice BootWake On LANAttoemptto %  h޴z> Pp;r	 ap;u8ﲖt 
 7q;ILiEd b#atisC2 1P.p;$<*6: ;!K$bb	B
p;R's 	
4N<^ s '-sA%r|kVRyckN0hNF N3؁úN?	uCFG~N0tGhs.2aN{voh`Z^   Notebook hard drive!O~`$cal de&^Dock!9b; Multibay (top)bottom)<leftf	Floppy*UsSBCD-!Et HDis0>SuperNIC*
!1$23                         d?oP  	 
@@
6P T r -@<9 pplect[D7  ͹U8 and `mo@=the highl@ tpayour choc.  Press3v1cose.Seconds until aeu;a A@fa> start:   VAlA(A$P A'B;S A;Zip.F`u hQC d0ô0.Btώ(B> A bVN3N' tA<v<st1HA& 2آԍ=2d?Q#YAr	 8A L :C.DA
*}`}FA FA+jjj(Pj.8  B߻ `DAA z  
  B  2җ
   t03HA2Ɋ F8tF#hN $ Z bqq~p URVQ.,.L.T^Y^Z]S,.FA*[ݡQSVW/ s&Q#B.<.-00?00.p1Y_^[YQrA u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu0w`;2҂ XʱmDAAAr
;w2pDAJ􁼱!}gFY.*FA<e2;0fhδ hh73L`V4ӿ5*^y	  v
1 
 hc0ڃoufYfP	tfYd h{<u2B J @́Wo rf.>F'gf&G, @ f   PG0f@G,u
hE$*~G,f",f_ffP 3Q~Yfڽ*1 QW2_Yf= TKStfXbo    ? o `Y/  a7h.`g&Fg&Fg&F"t7g&F0a 1 2X޾GߎǍ~J{ rsG	 k  }QRVDTQF r&e^ZYGffL (]L PYPfSVUfQWo
@x
K&@
C'm C$C$Vrx  q## r]"tsrg or70K:k;WQT r}Q GC""Y_r
E@t]^f[XQ%&C"u%`'&u̖!#,ABM pf.IPS [XAumf`p );St1 ]t("^ttBDt!fat$fa.6If.IIDNU)044B.ISfV()	{Pp(^3*Ýf^[
3u
'uqr_!q!} "@W3 hr^ :0`0h(w3+Z5cf_ r`= v] O1] aÿP hlj$@<@X>lP:_PR ZX@ .>@K t.@K.BKiKXSQRWh@2qr_ZEP TC r99 r/ u t t@XR1$tutZ0 8 l~l$ f35`PSWQR ouߊʀpPpq4B XZY_`\ @S6`у< @3ɹ2 uhXd#^)¼ P% = @uXu%)4g&@RN]QfPf  g&?t9g`R%f~<{u @Qe  f%??f!f#   f@"f<tf Q	 πf !pfÿ chZYc$fVL/
/^P`GP@t

=
 
"
f^ff? _wD PWf%0
!
 nfoAH34r H5 0P@p <	%2 P` E  ; 0  L0""ݒ	ipy  x&_  p s  8R4s 6 %A#Rt &@@ Rxfft8t*`O&8b6p m3؃>
tuc ~rh^
&ȹ >C<th4w} G11?}1 Q < t&G f&AO
`ti3f30 2ɴ*f& uf
ffKP&&fC0ɂ8ɏ+[p5@RfVWfD3ffCf[fKfS܃fF0rq0а K I+r{ǒ_<Zfr6SQVWϾ u3_^ 	!BK#V 
R3
t<^f~
w/vRf~kd`︠@bfft]@`[^c@|VQWfv h.7-F&WʋF&Yp &[ &{]P&_&a0&c&e&g&i@^U1f   rGt >):u
P0uh{gX`a_؀ad7f]PRaQ  hUjjj%jG P.8 	Pu hQ#
v o h8ܠ5ú   h蓍p# 
(0Բ t 	2se fOU ffff>KUfh pTg&; [u}0a)f)f@g&t` b   thtx3srnfǂB D	ސ~/uр~/t a	~;XUt8Mq 5O                                                            `  TfU.FUJUWu u[rWJrR-rMJUtf0fqP| @Wb t#r"t p ; }PJR  ZR f]L"V0r*6@^  R ZrG9	KuҰoqfVg&fFfFf^@e rC\A 3Yyg&8E t EG SBWiWm r`W>OUpt"m8lӷql0hQPҥc ˰W rt r
 GC_RZt$ؤb$]Wp  _W}  spO  a #`P
߰@S P  	ð D v Sذ8 3 e 0R	$#
R3'
//gqQWjuptPX_Yù
 d h7sxusz
ՏP .<u.uĀ RRuaR22hX< uZ#$ t	J  U-
	a!Vf nƐN`f^Мhm\àh=aӫh/$4/h 7h>¤u_va { r PQW 0> 3_YX9rhIbC=F (>$h"Ss	7? MEð   ! $!f` T hlC@u' tf/ hSa+vP^F X`>H`QAؾL &>N&DE>&D >Nu kdW j@ t~N}
 +Ȁ}	 >N 33SP[tS[a>Q 2[sDy3 t^h@2hWs
JhOwaàhD
ϰ<DuL
p
E$<u D
@11Usd
rSi&S]@` uL
 06 6Npu  (X6 &uh
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"& xu	o\	PS   ? 4P'>N_3& ?! 0mN	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10Q&,@ &  |` hSC!r!L	vTt
v`WvU$@{t! $<v_@a@l3  v
p
u$ "<uP>ȷX\PRt N:p1thEZ!&ă=0ZXv` 22PEǿN&PCt5N=ǺNtOu570: u	At!s96 u5 .\s
{t!Z&@q s  `a
׃/]3 2ds{&=  V P;Ou 0< ^w  3f4GPPf_ ޠ }0 U!    O&egWʃO&MuO OqfGtM!t$Ot, t"wOGr ǾJM0oOg&P/` ހ2%
<t29m21_kP*_P*`OHtS@LDhE =_7_D D	 d
z=1;b^tSqrG&}	r??23p4t`hba&ET$a	&Mo&]aI`.'`\%# rU VϠRnǠZW&= uAF <}K)
h 
 m_VP
@t   U!w#w !#`0ߊ|ovh3 3g._-.MTN>;tI! //(rJ=g.58v@Nu% @BTB 0hBh aW$
"{1D ho3
hYp@[X_
`PS@E![X SϲH<vLR
 Z,<u(RfffŠл,ZJ vGu

 kS1 6o[Qbw$ <@aaf3Ґfiߠ!<`c8 |	4`֎ph.v73۹ F
t):u%r9eD	& hN & 	 hyN3Ga!3 
3 ?  N SٸuTu   [Qt  w߃  >vfQ 0xs<to<Pt?1fRP ;q;[ rT<uB u:XfZP.总XW!&' t&A1 tYNι'v`
f/'+Q#	s& 0RZtk hs` 0YQD?_[r4f2Mq(Ku@% = }tRY%* V[r_HS3N+6 
0{HH̋E&ѲE , ^гr``h+c!~xf$0V @$PpRZDvї0O  ZGpZ^30aWV 0  PhX@/ 0S2u.
Ӹ-2@؀?!C@?r@Dt5A33u,u1 
@a

+&C323&@t  %
t&
0  5 ? "]  ˶ ( t
Ou/: >/b!	"	? A%w {^qwPRWG&A &]&U°
t ˀAi] _ZXr#3 -w2C.u#/5$NP#h΃&_ '߸^  0^       sۀ>u  '[~! _ cmom1^fd_f3fu 3? Q>(N_:uBE&8Uu8p]
R +B&U
ZK!ؾmoZ6fYB)%qr hk;/	Q(t0=
  5Ãh"bAர8.
<toZێûߋP0V#
@F^f0  X(NE_D
yC I1    xsMu\uUf``؎ Fwq.p ڎfafSfQf.qf fff#fYf[2VftGf   qIg@f;t&f_ 	F @%f^`2ۂۈfaf`3nnpfaPP3_X.>q`, . P	TACO F O 
!	& .q<F	q fFf.q  qF.qf.>q@<E.q@  tqttYpqtNp  D@SIVfB. f$;VrT%W tB!Z\ܐ	i %Qf2$fP'fffgf"ޱ'r. vp q%f@c .ffHpfXf>Ѥdf3ۃ!su+`s?Is*"/S"Vf+f;wfff3һ3RRmEqo4^q4'r44$.71p6ɐp08333Ҹ  QW>J% _F
3}5߃u'JE#a0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^I uSmQ` p&t Y&  
 < tr&\]p &\U  
&mN!d N
SR[up	F@& $F^[_ҴF FY<p߀TV~'}PVWPًذ 6' N! _^Y[XWfQwSg Zfat
  [fY_` t =$PnPu2MtaË6!s } tp( ` j S&&E`?SRU`Qj@6^]ZpV`} jwĻ^XP
~*F
  tI# b` Ql@F F q d3duhXdKu`<Uuùd `hc4ﰭd & Xtû   h9% h:rPhE'`X!$!   °os}ୣQ O
eh/G2	   tt 4  hIӬ` tKu& & O 
 ` h,s@<t<uou 
}0u?1*`P	h# Xht $ P 𽸩& D[%ys%aPX	w$# )D)tk`($} f.`G   Do@7DÀ   ; Z x     0N@`^~#bh̾2/1fF3.{% r 
\0ވBFu~2wFdC-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ{.~r@V» 㐂û< f ˾ff @ffRfP7f!N
 ffFf?3fvZfFsfBf〶fp1 r?9pf3ɰ ǿO
ofAP  faþfPVa3v޸rF3X

S,0<	v	,$}.[W D`
o
Lb f s  fɀ
TO
T p s 	 
Sf_fp ЎfvﭿPU.YP,} P?:Fp
uf^fNfV_f^pPRp*fV|A6칈F@20hC@ Ͼ
 ff  fffffXChq p  `907 P94 " 6 a)P*hUP, %ofPRh.g2R ĺZP  (Q * 4ff:aD0  f2MMSh/m   hoCɀhhoZ?;?PSSq@Apq$ q!˰_Āu0!A tðvntt<1w(<vP޲NEh3_ P&
0
3q 33ҊFtW/g.&;u;ϴ@.Uont)@)whP҉t{؀}a`2G@t03@ @u  a_[
u93Q2/,;8#fN 

Pe-j1rX?03Qr |X@Y4SQo2P5'$a&& &0hEoC hyuɰ hn"
t[ Ȱ t
sŀv#tW̰,5-PXv8v&> 㟸`t`_P3 u $hóV
#RVp s}8 uu22hSg=u]uXP&
wL02 Q޻ hNu= Dt= tY'
YY|.8^ZeZ1P # \U  Pf_^ ]  _ `rEr?A }.( u-(.*< t.)
.('afOLP?H      06Pw4;V( i
u^V- ^"(P*^  2s4aSP( 22`X[úB  $0;R  ZP;               }2Kt@,! )~ xriЌrakfL+  كr<r$wr/}!f+Df+\ r@ . ߅hkSfa@5  PR)A30 ZCRA
 `&F@g0BpAuhCP$Xh r.>".#pu 	A1QR .#ph f3f%  fYpURQSWF^
D=  F\ ^F \މ^t
;v F;F
 < uWP  <ȭ22 IF t _若~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
5ﴀ8_[YZ]`P 2&X&`PQ0^ kPYxUkPkT]]]=              =`ރ6.u;v` n0 >Xh *YX`"QwLQ f&YCC`Kq (݀  X3_YaðSRP3oPq??[Fp4$&%<GP@`	 0rp۾AFt   <BMtf3 ˮfP2R Xp? Er
RU3`)t.)0fGenuuhfineIu_fnteluV=sL=r=vStN f  P =   	tŀ  
 fް@3t# %t5ubfD!a $<@tS<tOPNBH$u>f=PۊfP+rCtq Bt#Bt	ݱ]`@f
qffE[1YW_ RWO  3OtCxx0؎ P.BB <t BB2J &ݾ(   8u!@`23Ұ
ShXSt0`́ y aut0i at]U U[aSR  4hCg
 h^gZ[`-0Pһ  h=8	 hCk
 "؟B Paa$8uXRP<u_1Z@uQrtwvYu0ѿ }R0wZhEU2<U@x: h u
3ҷ EF)v upQstS 9 
( ڣ%f.p UfQfRfUfVf0>hR: rsNbCwW3f. ff_2f^fa3Yf.>pfCgffgfׅ suYKU q u, P3	fgf CPbIfQgcf.#f9upgpfY'40  _  /p ;5h 6( V7* ApQ 5f  %" e  OV3'@ Wtpe;F ;
V3"/fUi &g3  f% '"꣓ #WFfF^faQ_V p @Z  
^`q[3[<  ~  f DTDw R  o 0 ȳh  1   l ( Pb @0^ W HL P`A T W Xb, `
`!W p@pؾ x o A
|\D ͿQWhD"3 3_ 0 PQ= `tqј @Y?X 05SPp
& p  ff?& X[Paa"&    ir  vf{@Q  oJ6OfQMhR0./ۀΖ _ <@k~ tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAl
?c1(PQRfWi}.c`
fXÑ2Q`2	  "	f\2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	hW"ϻ (;sQSf  r` 
 t
2>fƃ	40q
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&E uZ=Pr?Uf  uCf*f=`  t0  t( f{{f
1"0"}fhG/%/$_!"
 \\-f g&%pջf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGfʰAÉ_F?<qP
 Ц 
"a	Ub	~ @R2~BuE!2cf_fFa &Ff޾{ t@sf @{f;~t	un~qNїV&##`WfVfPXfXcr<w .,0ճа_ѰSf@&ˀtg&TfV}R3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)?^f^uS2u  w & ?PP0Xt'vt
wt@0r % r/o hn¢>u  th2st-3&>rqrRPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF phC rou
@ Ѕ&&  ؀>t !$!f$< uRC  
N<2<Ɓ	"3]A'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tȵE$<u&w ï$tRV[L  ߡN L Nڰu û` t  P[2u
@j jiY!(!!2(<!1ʰe$ h5u$0tߡ$ϡ~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|hb_DuQ&~% ߃t P.Xӹ
 D.:t
 ._
vXP%8Xr6%_ȸfc4;La    PJNL p      QKOMp @Kt  Jt P(.DGֿH hh  hv~Q h҅ hE Б?E^  ~` f  Cp m& OE 
v %&Mt&:
7&;r"`p${t1TKub 
HM` `(q p" sr#	cp&3a C 	H m]r5r`2gpjh!RGvZaVRQShEo4ThyuJ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFhrRUujjjj P.8 &h#w[ h)w$vawt = ;t= Dt
hEsp[@WVS$`́$
[?W @n< u"*OؿhNt`-->J=Ot1 0Վ_ tyr_ rh  S^1  0 hL PͲ5[ ?  :N2?Aq%  	
   VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2^2*à
&}v~Puh"bVRPRQ3f 
%*t,AYZXRPSQY[XZh?>tu	pp Є> qQ 5rXYj,:Ϩ t
)֮hD"&&  t8t'V u a+&\ nq00r6$^$ rZ& &_& ;`Z@ `odYde`P`  XU @>
ڹ 靟 .PB B8uG` A ; 5䋀/)@#BS ˫냑75VŜPX
 a_@A@ B ]C    ÜFtV$%Ȱ%蝊<;weċ X<wM3ɆQ#"XR<  YыƊȊĴ3ЇуE pYE8@C0	 FrWYuF5<uz`0Df&	2
jpu7f߻hNePӀk 'B@. ,".  檀&k !< uf& bÊ$
r wAu%1uhӲ$ws}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<οf'JKff
f_h_f3f3ɹ f _f0m f+f_ ! KJu*JآJ3ہsV4C\`h a^_^fZfYf[fv3h	U 5R`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .0\3۸ 2ҹǻ*@GaaÍ6<ghygpVWa<o=ǐz_^pk` hΫ&h  uP$<X5(sf _@  t<   4 r	.ѭ$<u
k f3hh.Э 
d]XiJh;<  tdbw_0s.>ЭNfm ;thtC	
A!U2 u@> l = ]c 3Fd@ e f Fc~ce; 4~e uQ@@8 hc`5
P	hQBFe:Ffu1r,
 h
 Fdt:   	9  <g htQhh}`!af`7UPHh򍢎u;E#f% PCAXt# N h=&N r k f ̾   F^öP XSĻ  y ,  o   hbS-[t(t@tU,&j  j,>" ' À tht*dúߋG."**D/.qpE}+Ëy؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYe߹b +Πu;6Fi1 epp~0Fff`Fup   j(j	R	aURh$2  pɺ f1 h82Z]coRofBr@!  tgRQ Q;YsY2w$w
 !u$ d%|Zf`  WWeI訪.&]fԭ  pC`h
 C ƀu0u.>ҭ 1fa
ZURtLށUHhU<:Ym PY8tn(tp ;C Zi@"{g squ4VfRfQhÊ+'v0;p^f[B]ԭ8" a[Ybh$q r 諈6Sj@ 2P s rGZi5'/UnAW`.ӭuQƺN$<u:0p r"&  t  tt tAt $puPq9S(
ː

 ⧾{N`XSQ 3u,S?mw[rE	ˡ-Y[C& <fÿf<`00xx00`֫Qɬ||	>>.r tr~_ (ЃrLZCX̀'q@VF :]Q<Q7=W &TʽZps6B  D ц߆ԆrA zuN! C 蓫_u 0/)0\/c#-}&@ 8q2 E *7&/p`W aUfV3vCDPDQD 7p~4f^]|&ÂQkM"%  烪wPduX$epI:eXa@ `` /////- "  @f%pк F'ACSPZ 4DBGP4BH{P  099C A!  8  APICZOK	a	a
@  		
  ?MCFG<	b$P	 0   @(@
 2! RSDT}(  		f`hU4hsof  fhpfp  gfFgf  FPTR ff`WgFpff. p^$f3..f.fPgfN0~$f+N hCpJS
f3ffgf&f.>Pf(.	t22@_~( N g&F	f P  rgfffff+f+.
ۑM.> f
$$#D PXff-qAFV3g&fFgY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf?=GFCMt"@H~ Qr< uBOаNRUfQъ2 tPxprAr v; tg&P)XfY8]МVfWfV* f& fP&ؐz@(#f"fP)fȀ$ 4 
Ȱ 
ȀUN NNOPNX<fauff	hScpp)f t  hksfPW EfX3 !rdZ
$t3߸ g q-hţ4>@H@g&g8(P_iPSV	  6>FKu	 sCj: uDb& @ u  ~pD` ^@RW D hoRp@ _Z PStSfP3h f&L fѡLB}"L fX@`ߴhr$4" 03fp&?  @ 6Ou    DOGPfۉ3{ pG   U!   P>O&geE E puMPM~LGfEtXAt$Ot3 t)O$fM
rþQpmMe&PaxtCLU  r. ]hR.ԭ<Qjn;   vj}Pݳ jmWp_f
πhk0kf$ttӿ7& tP&뭿o 'PL)io_ԜVΎގEA^ 3f`FF  hw }ur hS  $g(,0w4'8  7Ã9FtFfN8F> h9ɭuh(Q`
Ew13Mh9+ӯt

hg*p;r#uac5WF ^Bf fN^N92u 2tc rfQPH_urf;^uf;Nt;ft) p 
tF~U_ս UfOVff%f 
t;6+.<t1%RQh:,,  ^_2V00 u?,hƢ..D+hX>كafS1_f~qtA"   u
3   t'>0gf GhECG$L<LD^COMPAQ PC Card Smart Reader,GEMPLUS GPR400,PSCR C1LB REFLEX 201241 PCMCIA6Reflex Wv.2$cr$HP
  a@!g&O@0xGd `P ߳ rLfK slr>G	 .D
A O@.d.D4f_ PQWhƹ @ 
G.g&:uGPY.5 _YXQ8tP*F 
NfW
"
@
TpBOg"

%Qf_C`cSh;0Hu#| _ fuu .u = Ў~ 1rp&tj  t_& rT  r&= us`=6>
r/6r4.ѭ؋V@< t ^mJw 
x y z   h8Sh:{ %ZNhCasja
qTrPqtI	f} R
u 
!tQ&9t	GY~ V
~ ,`؍vfD   ,AfLs-<t(<#@06 h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ƻ 7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`3Ҡ&&hq#֎fv*`%h.Þgf9t0Xa` 2   0 tGhbq egf@ Vff3}f"gf6 F`ofރf!
[!0޾1j3۹: 8tCRP #ݨtο r1h]f ufpq  00i|? 0    0     q'  ' }D 
 Yo/ bbƭIk`oC@GY kא2PS_.{ѲVW ̌Ǎ~Qr&} uBr	:`_^d>r5r!r\E@&=u	~#0#Hr&E$7u:5}ΐί2bYӆa
Cr&a)rI DTtr&e`4o5:0
T3
 54Sr#@itct  t$yBffL  	[] 	VQ
RNQ3q
]
Öϱ2i+W!z PJr8u`_QYs_ þL[ r&Uþ'Ng>L螳`
Pw4$X` $2LPnB}0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BsB!J@ s
; 05 aù<t

B J{ 2@u8{` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2/Qd'YB@Aq Br  `	 f7d3MV7  *r@p B`@P fRع! f6@ҿjRAt0
t<asI, fNgfFIp3ผ	.aҐDt t{032Բ&?3&OtUr3 _P G	 	1uqy#uX$PXPu=0៻4 P%=i`	XP$g2tx~%g& |$|
faP j  | P +   A PRESARIO M2000HP PAVILI?ON ZE1#NX70	6112	C 20`j h  H hˣ7Zfgρ h% f= @u [jg ҍb Sjjjj P.8 g[ h)û[bu\q?j&v]$awtQ= ;tau= <t/EݳX ~詿hZt/~ffa  p- ӥ7tH<uu):pO:< uup@ z`=3r! grπ D    r% Z@-Z1ɑp$Wp1_ǀ uu' 3a re+ tg	%ۚ  .Mfԭ F9fֿ tp/Y[|zrs3hӆ Yػ Sػ= Mػ{ F  ~f  `| tIe7r=> ~ t@ԭ@t0(5ȃ@ MF t wƷ  蓪3N !F ~ t׳	u?ekf^SZAt9A`щ f` Wf3Q fY@ IxȐl"
 /2uJp2:!&= t: ߅%J r ԭlVQ&U fq
MsY^D^
|eOf"Aٶ	
p٤q
&:!& :X. IhBB 
DW@ (3 ?  A-ޠsC"uͺp	1u[
	q	1D!IFt$a3; 2 + fB \{	(NffA(@2Bt1Q7ts$a$$|$
7R< !'Zt%'
QVJf^?DUY!~.&ԭ++t'H"`XtC.a:``s; 6s?^[`_p_pkocqoooU#odooao
foo ^_՝a|LGPhilipsLCD
LP150E06-A3K1SAMSUNG
 LTN141XB-oL02
503
QUANTADISPLAYQD14XL201|15XL060PG1
AUOABaG01V2nX08`

TMc01EA0V`CMVNXQ37Eo5F 
5CPTgCLAEAD+5</
TLA2L@G09 V3 E2o`` 
b8g=6o1ECJaG02 V4 ' &13-C2K1 PHC3B 93782a%pLH12A3              Ȏ؎6r[>.e  >@Y w 63Ҁ O7BA К8u!!uߋ
( H 8u	3ʸhUrbPW
 
t_   @ك
_Xm 
  H    SETU ˸ @؎&м  + r' W@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h>Bt & ^[SO
&hl" X[U샿VWƿF F@    ԕ^ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @%<qt	dR>t <tjjjj3P.8 C.wj5$<t.<@t$t = ;t= DP hEf 揿  7SFF~ t#^FLr
F FQ  ~ wt: ] [f
 h<;\2%PFA~ t
F|_^Q
h:sk.&udu   hb,$?wط h-"h #f_01Fh$..}  @  Ys(`2WVe1E0 E.PWV .^_UƲ(UAQS96 (96)e1E0eEE.U s@ m2a h4$?e%5:$ء;9a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   scq@ @ p^ B  xsqUmf* %  < ! 1C  3	?
   QVWrAu% p u  `6  | = <t ; E@+1 +_^YRW@S Ê 5WCrr3ߺ ڑ[AB rN _ZqSYUK0K9K
YQujvzMpOJ= DE<}@ ;<<!<3!Tu OOOt
Om[VfPfSfQo~pf3f3oPooXfffDDG(	Dh fYf[fX^ v#@KgO GxApQRC3ۻ%< Pt CҋxB`s |fDf3ۋfË\` 	
C  	S T R U +	?	S	g	u	`h	@xh	  h+	 h?	 hS	 hg	 hu	 aAxv.L.< t)F.6A3.PF.h][+V..^̋] |DF. P .hs:↱XhQ ؃6Q  16V  0"Wa X Y #Z  
[a ` ^BA\a e fn']a a _ `gchi!j qp10G pppQWĀ>`t		 u		.	_7   O 4a9Tһ ߃-w C.E/2Rm?n8o7Y3۸ u _`ϊ߸^va>QRrPS[XhY)(AhЍ.͋h;
3     s     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;d   03/30/05909/13  kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Zڨ"2""Pf)"'zx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5EFuu!)zүx00OmE}Dxe``
$`$p

xc
	xx txDESxxxxgD@.j0}}@ v o :}d`xGBGE%x}DQ00xtxtyuup);}mQb}ts ,{c,+"(gxkD00r x^Dx_T_xcDxfTPe p# * -a`fU2
,L%01I	aTx"B2x3T0//D}p!T_ _|%0u!	W Tw`#8 )?n^04hq	UP	2;F"!
+u+$4>j~T+}&+p (++@]揑,p+
 
0%?
3
v7b",`]0/}j+.@ /P2'`" "+7x&x+Fx_`t 7"6}

P} }e	!	  @A
xxt"xd}A}D"* 10}=
0Ze"800x )xi`xj  p 0S+;0/TB+x+¯0*20b 9P4.+ 20AƏ+`xNU	+ xTx !
+9DTBKPF  y+ohP>

 C[Tdp+$!#P'+p-` 8F@P` ðÔ2@YD0¯xx7x8r x00!9`6$06 QATH`	p15TnIp:q@&(YZ0n?/)4"0X0X# LXޱx,`Uxtx?0x,@pPD0xT?Tx*X-tx+YZ>TxYZL^[LM '	^Gk`k Aux__DND0='  y  ˼V>RgxdpR^	;;BZ!Nh0kQ@*ARx-	+_SRNx*?SMx+` Kw `RS0 
 peQ`
 R_SPP1"̀ 0XM Ql̀`e GAX8WxZAYAXNSXHW}XH$0Yip^q}Z1ZTLoZ1ѱ
YZ[Ԑm0c1\\TQ\t
r[	\S2A}@ A}= #-A~^ B~`  5A~_ uuҌВ"4"7x'?D
`X /7d`!7pg33TT?OPC }`07`'`2`=`HpQx] 6uuuuk uu0 uu5O$ƨpN`0T`
010 @@A"| }(x]0R"+,,E+cp
0 +C,,+ +,+x,+00x!,,,++x_,,"-.pT0ӨL72!t
!Mt&Ipd `1g11[tU!Ҍ(0/0mp/l`
/;0d@TyE2AX.-/0" ֥*xc"+xt`
o3x7 x8W7t)}h"[ZYYcbdYZ`\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Gg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J ;@ | @ s   ww ~~ r  "8x4+D T ` sD)tXOpx2tx1tI-'%[0' 'xqvv N'xqk[CWxs$% & & #2x1 	ү  ¯0 p%#@K 3$b0#	Mx3C
r beJ"xrOF`V0 p@$" '	x30%0&<T`P$"xs`bfp
0#%""tX.4} 
xs$3z 
`Hpx`p$W$ ysp @@Шxov"x0	D0$$6Ӕ@Txy~D?"04hxOmx~@ DT 0
9 pcl0B"pxu1xvx}"xux~xvxx}	"xx#xw6Pyywxxf`Ӏpxx`( Quk~B|@
"00"+000u0ޠ u0 
0 !$0<HRTЍ}
0"HwD =1w6/w(!a0"0
	00"d0 $1¯@x1" |u Tp""3453/:NP"3554!_Q0"0"xoo`xaT`}ܓxnov+r!3}TOp0@0 0 
Q]P:}0 /[P'2)B7Ψ P` Ӏ"78$ "0a T?2u$408S0"{z}yH237C9
u&9 8+
`9709707@2$h'Ô@]0p4
 

`^$Y	0
	@À{0-$`
$`$p!a"V~ K0":0!@À-0
   s	 280"
2xofKp0*2d|p08SH{zy  xpvJ%_`gK8P2 ( 	4 ~[ "
H	534۩5q3`	t%5544r	@ :0	h0"08`		~2A08<K L?r@1@^ 
 !
 +90 B 8, 
j	"Ɠ "!`BQ
p0( 8!~^ 
-NU
]DU 8.
j'	20"G+6,,f-e2pO7)0	LP85p
b3+&K05	c&	0
¢S (":"08<8;pfpO:2"`"/c)[P3
.7=Cxn`qe`?0}Dp~ h,go,"a,a b}i"4xuMNOpxD Te4`^א}V Vp0
T4d`#@"4#dp~}i4xd@3 0
3 #O`3`3$`e$`1$p$p$`9$`$`)3$pv~AT Vnq2c1[0TxvF>&`!	0,0)$٦Ф@Dx Z3c0a ?3]
PA:6P 	@Rp>%¯3Z``w pTU`xk  NU) .jHxv
xD}S%0{0^`
}mT?DtG`PtYHTʩI{Sۀq"@`T`Q	067``$p``1e7`tgE7r((b)(u&0*a a
Td`x0dp#  xF 0TÔP
 )xFt t[xBBxNN{}^wxJqJpr:;_<t/a>=)x ү!:%$t=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xv6ѸxV86}&p p 7  %76o'7  ""88Ô@ p/p0'  /..d`
%~r7('TP5O(7 4 G4W04/@O453``/`@$pN~54:I&duP2):P [x 
33oppG+L1>gp1  'g:P"oT~ ,P2?T#>үd`pxHo 8@22P65b3e1@dox>1h/ 
m
`+0xA%30 B1
@
 `00
TDT@5q0	 39@a_# AP}Rt
 u2P2bt_l@
p.
@	  r1l0dpe`30DxFW105@2U`e bC7xnu30 0u3}r2*(ߣtw1123#.1}p<0{ $32  a<0 }
1pAR ErspM#"p  d-ju*x0,u`2:,`e4 2UU.X5%-G,* 2732pha,
$+O!% *R5 
Q'x`S+0	+` -R	++@@@`p7v@}	 `@~A0y!T``Y_` VWyG
7pDxp.eLDy?N%@k53Eop;OCD߯-kqXTQQu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`/X6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[PE+C{p4Iz5z5
3z+,	yuv {| A, 90 & n`AT0 ,	al9pd00o0 upo6o,/-.rpFB}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p0BŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxgT)Ax`%daz0  87`>P$3Yq"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmxup&xtPxsxrxxqxxp"ypxkv00,pTxgL4.j" .3k0.TkxgQg/_p0ᒝP .^ ##-{---Εi C2>",u{/212B0T-21Կ^ L-. 'q,Đ/{#ʰ6,T{AO-.`۷pG䔸QN.E.NUJvP60p0Y()y0Mh
P5
Ps|?`d7]א}SPn,rtFar4N0 `a2Е
p1
P

Q "u- 09r"l  },n1vg8D,  A3.02.pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`ou.Ta?1PC
.%TOл@QN]03p	 ``m 8a 9<b $ 9)Nϔ@6S ? x0!  x5?0A UQq~rrqxvWU	Xu

		0
  `
7 P"q 
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axk6"]@tF C9xVxYFdҢX\`T`HTǯ
PMs>@C^!3"x*"U\]@0!Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`<ك<uA<uaYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0tǣt A2bIAƏJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F>o 0 G<"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/*iJK
I
cJKL;Md`NPT&` v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"H..B˓ Ô@""7  "xf· 7""TxDTpT@ۀp ?$0k+H:D}@qTTJE}Rp*U@@@@@@q@_@M@G@A@;@5@@???  @B~`RtJKJ" #dbr! t"xbq o "B
gpD)`6	0)R#q! * 	A] _:qV`R [V$`mRAb $AUӔ@U1OǯU0	xoZÀӒ!}aAU`#`5`2$pCxD#4SS [CxaUUTܓxns& NYq 
xj0x GÔ@π<PTxjBٓӔ@`Bzr
T"  Ptjxf0Pav+xnv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATUBRBACy@*F?}ۍEb 5$zEr0U`Ud`)#uURBCCDDD=DIDfDrDDDDDDDD BE@:D 0rtR?$9 pC¿"-A0E
mPT gޗ@L0M7 Q&T E7@UxaZF!R
hrˀap>@X P`A@8aO0D=Dd
`#p`(`0<`PdP`d`U]ێUw0:NR/t td	RxtxxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=t~p x@t	p0xTВ
}}%xtx"Ttx!TTTaD	x?D@xTpT =TT	Tx= Q
@TxDp?=DmDTxkv0}GtU UdQ eV`eTeP}S:"x0xI"xh;/LU"B S?/?@>"A䓛$tO$-"T`Ô
P~0~7%U{U eTT7%TT{ z yT`G G+H3H	4H6H7H!8H,9H7:HB;HG<  HLOTY1	 Q
 I`A 91~5GtT& 8 `;cuTuTK0T"$`($`*`u-w/Arp40
T1B P.GQQb U T"VPT$```$$`(`7`F$cpH[p	A]@
:w3
2  *}0W06 `#'/A~``,`003`G`[$ap]Tp]"T  dpF]0$s  `!D}ࡌTwwq/!$ Tp U "$pR_PLTQd`0EQxhQÔ PQGcGǭ9q@P
qJPxhv@JmJmJmJmJzJJJJ֨JJK
KKK&K:K|KKKKKKKKKKL LL
LLLM _ LT0
`2v"xuMNO`uRRRsx`}i{  x  "$"0RZ
R:Up; > x"} >HG}0"uS@	0SSST
pTS0CSz {0P 0y@4xatWhvaUQ `ӒkxTxkD0FxǏHxbx"x@$xx"x`}K}IF	
Q@PM0""3GxT| } ~ ~?I4Q_*NT QRR &NTLw((sLLMMMMMMLLLLMtMzMNNN N+NC.?9qÔ`P/QHU"T{? } 00xe@"QfSoQЙJq0pV	@ݰ50T:kuQm0ʀ  0q0)؀	0PS":C^$p
:!/0Qp,"xdP P0A3"~}i y0?HR3dAP>2I
1dd~0M}E!@JC0" .PPN` QF mT0b`dɑ0N0#0xD Tx0i_!1?xxivT AAPB11u32}&  $31T3322@"O0  "'uW "   p}"/)OJ0/ÔЧ/pC0S00Ol200 "
xp0 "ŢxȰ♎2345%@"(t?3t 2x325R4?U5B 5axQx}QDQx␖Q  096x}S5_nS5 CS/PCPQQ2Q4 R?RRRSS6x
/0!x
tP/P
0/Pxu
  x
Q{Ox
! %60$t $T &Qxt	}XBxs0xsßP2O0 pw%@$X4$ÞPxxs`1 	_1_ ,-u7P. <Tү$`& p<OX} @p% BGx.-,6	&xxtӔO@v $(xsvysßxtP!  P&߀0 	r6
p`xv 6x.a`r
qP 0	,xx
xR!x	06S6)o_`P$3:p 06d2@S_ SfSpSzSSST9	Tj
  T{pwgD14 D@ @B@"xDbU$P``3@TOW@"X  ,D "z9TSph?`/AE@E +@@CEtUm O@p { 33TOB  @ /"p<1ß`p}T@`8 -5,,~ F4yS,  S,`xevS, ?S,,"+,/0-VbUx	` }2xN JUu0 u1ATxf`-30(Ӕ
P! 23	D3E2MXLSS0S3u2 u42U03U1Np1%1030444 P-5xp7x	410	^p_
55-Ӕ@xA1 w X?F60c
`/p00Ӕ@:P0-	`	`VVVVVW4WOWjWzWWWWWW$X%X&X+X&,X3- ? X8-`:S	X8!xu/}@xEǝP^-.^P
.-0]	
x38t?e.pt e)-0`0p	3pQ|Bp"	`pEx@}}t*p
.!  2#Pt_-Qev`  qW} pQ t u vA߀O}	}50R)LA Q!qmp]" 20 ,腿+"_`{Y`PXXXXXXXX	XXXXYY
YY!Y>YY3Y w Y \Yvs  S1
tGt)Ʌ|#	
pt%e DoTQWT0BQ
2:ԳP^`p '#pPIEdЉ]P  rgZ `!L0ZtGNt(D:i4rOBkQ
xaﲌ)SP`KDQT,T
qMC#_ "gD `E - gt .`T/@"À--d`"` 
`-[>.t %-Ue.`.6Ô@aG[=Z7[=%^"Xto.`:``F/U.`"U/`"",pO/[`c_Ô@ OeA
"x
xt "@
u/$ -$U`"xЊ0"5}"ܐ0{5242'   _" \@2P7\\![['\//\=I\LJ\[K\jN\yZ\[   @ko"xl / "0/Ҷmpx#R1l^ΰP@P!   U
0k33%$` e2pL2640"0,4d	$4
4trov"Ô
@"4`}4$`$`2$`B$`J`[$Wpk[P 0/V_QRc!D	q^v34A%4p-&q
0!D"/"""@$Y^^ ^&^,^E^i^^^^  ^u2#^u22b ! 0"tpat`u2F,!wu2=r(
C]
Qb(6r2UDE.`u8
Z/0"kHQ R 0Б 3A 2"0"x%0T~t@"Ô@P@@	Tb;" O x~ Od  "ܐ}t~0	|_F!# x0x!TT`DUƨp T!D`!Tb1 >mxDTKn"  :	;
/'
123B=>C	D
WX`~x`!SP ^`_d"
%'F`7h0x+ +bx@jwqa+s+Q `C0/+xT 6D }? 20Дl D_T_`vk vTT`P80	61 a@S 
0cx	+$```9 A axv pz q DxT"ҎxStTTH`;+xS+<x, 6, G`$p#+pxSx+	x060/QIy

0g`j ".au@-@	}-A-$``
$dp<0/yC.t}.l+ d@O`PcDl'T0dPG@{@aP-Bp}} Ǐs.kd%	C.	.@;1~`J$`S`X`]`h$epj. .
Qޣck.!Ĳ"dpsѴi.0Ӏ2p\0PT: Lxl..T>xf.881.T{P{ Aok
"7ӛP	!`P7Þݱd` Ý@ӛ@*ÝP:;<u t/t؁7tƚ"@į0@*` 0I"xp,E"Q 	/014u5Pu<$t}5}ȣ/ fee@eeećeۈeefff^fxfxfffffgggggghzhzhhhhhhiii)i)ininiiiзiиiijjj'j'jJjJjmjmjjjjjj  j~O0~*~ p0`+ pC3/}u: u; u<3{cr4jT330P66~ѩ 6` lwR3`0u75u3@u:u;}u<{uxu{]{X$::;o<{&5Սhg0  _6Uh)gU

-K><,P7E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+(U/**81U,/,h3/U1/5H13G1O/| 1RRBPA$__TWB_1 u2d I'U8B=9=U'8FGUXCWCIˈEUEL͸GGUo`VII#M0V6uP!}V۸bhQR/"qVÔ@πu3//\C4"$y`!SnPnr  ? "@A~K`j Pk[$l7`p&A`##xt@}}X} Y  ZxqBBxtPBQ0%70$0"Ap
 `"k&@AOr+ 	 	Y		Z 
 
[
BxtW		 ":cx>T=Q
38Tߔ>?`dPmP?ו> I IPw0=p@ "08k0 } P' 8@
0| $ >di0
lvrd Ep6ѡ"}`~M }q-Q m)#@!s1f}ϰPLT?Ton t
䣠"D0q^׉J?4+@s++.
~M12Q^:H`w
l@&ۅp0u߃kq2 
41pmn"14Pnv1xe ~606
 0A{ 򉱢6'q|pp
T?T`4"4"0u2<00`{~ ~^y5 0TODԳ001p_322\* u1C0{г0 	3PP`8׉Pp_2PD26B32epo087uP0Vc`&R@P}`"ޑQ3"0T_PO"
07/% ;q,03 3@,P9e0`0>&2_Veѥq,o0oP3й1!p10~3  ``Jgcp9P	1DJ@T3``2;;@+"45675E4`546P
(4h77$`cTo`M4TM >`` `'p-?Tr D Dh i)01$CrDe0rPB2~ÔZm	*u1au0)x'2u0p
1}@}]3ݲӝФ2u2u0*@> $g3@20U'`!c@'
Ls`2p[]rEl;=8002`&CTATT%W%O9>Ep`>3`#EX
X` 
p	0d`0Ơa1\]T?`<p7!?$p*3tTS :+	 #vcPH@00	=?2`f7O"c"'Nc#&O$'ZN&t oUݾ$	??
o)U$	6
??u)tx
d7eU񂫨}{zydAWk7vrj1vr04<t` au8/'P~ sO2./s5%tS\w>h~@_!\d1trup0pT`qN`L=2t[A	ÿPt@1qo[`<`@z45?@b/Gk43ҿ73 7wk((swxx@x[xxy~z8zYz|F}/}~~D!Bc	{ z y4lB	5P4F w
QhST|lS1
3D,t~5{u4`u5 	]4T`p[d`ӀQ?
p0
PFu	ߑ	uazLoBmP[|У| ayy[}>Ф} pm1iYiiPK
5@ß
Np&$0/ԙiz (
r67d6PN6@7/"PnRJd0,ve5p4l`&{J!8*u8EUs| `z {E` @\]Lvv8999889p#!#f8`9#
			0				@45q0F 34t[98(d`픜!PDA-0/* 
E0
jTZk<ÐIIP2SU~dLptpW#aM`M8@_ʫ1mpl`T@
`r/@1;ňqdNpt /,V+/XPՏYP7[ZNp7>	bUodApOpNCWWriAҞ/'P#^/i )4(?dn&pf1 6r<ARFt=QVv>
afx?Mr i},K;D|T-`Mg098r0,P78+3 7wX3"27傐}3P Ô|@3$`Db c $0h~ 2 0hu3#ux677pdE`30 `a>t8u@Pa6ZPt7p9TT Np:[ !p);R4u3}
tu
q$
 e3`37 1a`?04t¡0`w4`` 1 e31TݡxA0V'΂g1pϑ2b<}Ƞ2"u0Xǯ03}`>%nǐ~N0J:>F2pPFu2f	op`8
0і
``Vӕ1)100! xeT`&}$31dtߘP2"u}`q 
p"""4}t@t -P
3U02	~LTD"LION ~Rmp`(wPRx33dh_"_~= }@PMapV02btjP222  ~]2~UQ`ZSRߔPS@~Ptu4<P42&{4ru3`RJpT ;XPg~U@	@3'~\p~ @3P\p"00~Wp"/0634u5$*``0$pB/}u:u;~u<V{cr4E`eW{c/R{`>3//u: u; u<3/r4"{/
`  "p	` KWTi"/"!0 MY! ? P\!QOVt0P[t- P`ppB-ӟ@
- > e-`P <IAptޠQ`
Pp˯-"[pWUl3p,P@QR, `"jq @ОisP&qi 
]t&i`\A`T..ܑPTc%,'`-lP,vt@p,80A6	b"<x9pUP
 D{?T:p
"aB~? dڒ!^SÀӲ  0d"0Ӏ"7 I8`v0@
D bI
~,T^ e8"anN_p 211
`UP
`"`"x0 p5"5q"px 
qFs>Q >~ 0u12 opn`dx"7@u$pX?~`,7bPpPPP Pn{p	84gk8$bt"89I;u<98~`ae9p8lpe;09E8 `v@@~+P"~W
`1t0&P_~`::Ӕ@:@πvx#>,	: ,=x@A-:dQ <pk ;y
0=<>?u%@`"H P/A(p??p>?
>+@55@@	x&Tp/"%T~m O7&@"`S`}"x!To`	TTp573o`@G12D"C
x?Cpx6p>A4ra/T(--,r e,p,M_e,`,,|21q3>d$-t"u;2A&8<9@Ju;;;`ДP9:9@P56x>~FM pb?b665Ô5P	d` 
F~yG6C"¯ WDAJO*+u,U
,, +, +@_F@T` OF[F$&_ xgt
 T0x{T1T4TDx!CD@Pp
0g1dpau3%33+r 3!@
40`V4cq/(%%q
OkPZ`a00*6OT@eT		|TYqc~^` #Aqp""	F	 >	m@2xpdX LƀԀi@o3ڀʀ3ł 
`	_"3/$ ̈$ P ##EN``#sB"P""):`"P%0 Q"b``"Τ.` "  )߭"/33@p " 3@P"Ø"0	Ý0  _r`0"(p p8u@
!߇	P	Kt	1׆a
b}*q2	1	"wt 
""BBE"""Ѓ?ЂP  tsߨ6 s)ŃŃ& "%@$5bpp
s@h`߱5p5 5@~5v5@n$5 b5V5UJ5e1515 p5p5{v5pv5v5q5#Ys                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   ɀ  K   P DSDTDSDTX}  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[L36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42nA06 43_44 456a789QAB0 @ CDEaF  @"50 M,52
@F!`pa42a}aiapa ~ib{abo[<102'
_C _ADR
 [&3 an_STA j `=	P	4p
15657
T
C[)57tqr 6o D80P858o58E2t59& @? < A#5A [#BKu5CD`p` p`b`t58ePZe` ap dpy0cCdc
{a@u
 bjzdx555Cq{bbtd#
q07pu@2dcrd[59` dza
a@b{
xN afuff a@Pdu`['A
Ja
FL

 PG
aE7w `EyH d2?y S'&p}E z3[B B61pibpkdrd
edA
d hb @brb
_
bhb2 U 34[Dja62SE 3K662crc64BbN05!w{ar`j5FabP]	bR][]
]
bu]atb
[bP c`^a%
`bac `/$66SPSK] [5F
62 @~64c)6!k67P=aaq``\67v@1E~_S3p 4D
 f`L6 fS< W

X69X @4[} p_A [B%@ 
"@`6Cw
K6Ca@{^.h(2BADDEF@[B:H 
F
`
[A6F@70 714Q ^7^74aAW7AW77T78AG7Pq A g7B C!^7!^7F C080A\81F#82 H83 l84O

d14@85j86 
<[=   @788 898A2@  g8C 8Am8Eq8F`
[0 C09o0	 A91P
aT9`	 P93܀T@94
v95$
95697 
!
pW9X@98 g~9i9gqA2y9B?
[! 0kC99E }FA0GA1[#\_GL_bp
`O{ʔ[!
dv`J`9Ea9F`{h pjp;
p
Hr `"a0A0bqV[Jp	rya
c}cbaa2 (8` A3x0 A4Bhi q`y`j0OЧA5
h*F: p3+E+Cpa(81Vv1(@pwA6\qip@"m7BPFbA
iAEWF2}8C&$r9D}jA8_1[GGP7C@:*BA8
@
[+ PA90AAQ Bg P#$AD06E CAF
A`~qA`Cנ
	P  z{` `za 0 
bw
t
	rab0C
 1 1
 )zQU{0!rv"OL@B0
pI6'BB1
y
rmw iPH2AC`Ea{P ` 
p{z1 wi1{a` rbB0b yCv12	_A`pCw
h nc; }r E   AA3
ccF@B3
l
PB4  B5 tpe {ky
 B4e} e Aj
5a{`цPxq6@p #`b}e
e/p !`	^e `ٽe$}`@@dAy4{k
 	``;}qB
 ЈAB; y!-Bp?d1ܰp69d pA9"A Ae@{B7q0fB`7 D dyce@
QTѢ B9hif"f
j
8@
EbdB	!ba'c@z!Dby
PMT6*CTHPCIBb+(p`Ab	s@bC/cpyaMcaACw'D`DEe  dBb[FBAŅGGGGE DB6 7#BC
@BBqBE-__PSW12B`k (!`A/E[(0AFІC0 1c	C sVm	Vo	o	o	o	o	o	i	Rc	 o	o	o	o	o	o	4u-ҙo	o	o	o	Ho	o	$N!T%[M 
6c#x(`0b9C33"ý
[@PCC /@CD
P
[5  } CE K [FD0вD`OлD2  0D3pD43D @~  ~PD6OT 9P72VQ
 0D=:
cN8
  9 f0DADBA!D$/D(D///E 'E//f!e!(.G!G!@($3( N 6"E0G E0//M E1@ #F  //A eA !A  N A GA "A  "c0EV/#3(3//.4`03'4//a0%1a0%1a0n0a0G1a0PG1a0@1BEtJ  JHE6	E7	
#?  y  Eh`и``
=`p`apa!wE70EA	@	V`Q	o``EB` a' (C	 (Dq з	A`v[ODPHIDA_UID
`|EA^^03`0!_DISEBx)_SRSECh_CRS6W	a1r)@$+b!2r)4f;c13 r)C KEEM hA 4 r) U[(iQ(5r) #F`k0	ja06r)@p{8kq87r)z7 2>8C[!a5j2[F31F4
r 5
 <6 [#"GPAu[@KF3J7v1(W 9E,C055zF9
,Ѿ 0FA B
LBC _S3D
p 4p PkFDؠ(FE
k h247 ` 6JX$Fc8CZKC100
049`
{i}`h`{`h@49w{i  @ o6$ q\._SB_1tB~ o._DOSq	5
` a!o[^2bb ha[7ɠkDCYFD
 G F SSh3À˚rRcp*r&R%$C 

 
h7E0FE	8hfp
` {\/002<99
IPt1`0D _ Q =  P Chi83`'
hA@ \\8\/	F2 Y6 @E7|7HI-`'8
 i 75hj	 6hijCq9c.5m1h93s 2 1p
Л94Fr90s 1! F)A
^/p´0_kl̀0fLR dN	_WGPE	Ó
pOI
Gb bGf fv y F10BF10CF10 #@5EF

pC110@11 2`
 3/_REG(pip015
 a	ia114[{A  @@@0150 116p # P7!8)9*AABC 11 )11F C12021+22Q 3 4s 5c6֡2789 ABCQDEF@3131 2R3n3435A6 7s 8@,393BC DA3MF540Q q4q43A4504Y6Q 
484 Q4B @C_INI >4D 4~!4F[   IC150 @pV51&F 2Ph`#Ph3Dphf %^ 153v!44p`\`cp:5	wh
@axa
d?b`t
@`X@	
a
@}a
a
y`Pd}`a086a azw`
d`xr`
  
@bauaa" 7~	4Cw	
8	
4C59
q As B
QC
@1E F760
q 1162R3
Unknown 
NiMH 
LiIon N05
62>qBXo  5B6F1
X5C
ha
!Du107! l#5DSC^5D@)PE}#5Ba{a
;5B}QE59!
 
fQ!A!AD!164a	@1WP aAEQ65	 Np
J{`B ID66
[)h`pc0F`
csc
  dzi`r`a[)absdb1/2J*(ccC 7m	`hg3
@v?65g
wU9262{`g8M`9h!:C s820@]24БaAh 1 v127 wp{60axra
c 
dcbpbmQb]611r	39`f>Aa$(`a8->9gl$I@B
I+Ep
 ⡁W 	i'p
q:/A9"2AcChcE L 0q{``	{``IF@5Fx;4  9RL2ccdp eeez
c?pecpciA%4`?~ |p
s6I%1`p
o`4[60v22C-+Dv_@+aN)p[1EQ-  T(
>
>3(P2pzQ{
 5[|%*!4(B+BCC@H`*ae(a6h/D`	548ata
ai
bKzch!

E

6Baam35
@ ra 9PQ paupaRHf:bc7h650U>88@FR=0cUr?11o [
Т6ErAq
H{P   a 3B
Sp
SIMPLO0~SMp
MOTOROLA aO`wpVF6F
p
  
Aj(_Q03':Q{BRyᱠB94u10bS_p
a4F
ba:5@TZ 7u0 1['cTZ3_J
6pn@v
J na72
1PR01A 
 1_2V N8EtǠ# A0
B3^4#
9nO1169_3316

,^!
{ (i283i4`ѐS
 5[H0
ѹ77
NhĹ @ 8@79uF77977 "0q D#E F0$888283s 4  p^867!88
[  ћ89A88C8D8Ej8  z90҇k8D,Ua`1A
q8DMMP922`ћa` 80`
 1?0 `91Opj9394sA 8!c!3b2c3yg5b qaa	4B7c194zya
 "d
b{
 bdpdS c
 c
Оcz
194B`9590p`kaPߕa
v2D aׂlbab`b
7vbzb7N83p`F82O9q !>5#!d1zj
a647= 	aF l'7Eqbb	aq bb97Q
0A67C7D ʠ;``98
7A6" p4"D
q9
{C039
`{  ia` `P92hp!
W`!Ka)A	C)hA30$b cV0AabcA@'K9B p^^CcIY9DL2
!+E

Gy 1AAi0 `;A193/( PAA@e7E[A;A2F_C  _DDN
COM1A3A46
30U"  u  8y `OS  A4_STA  A3Q9
 ,+_DIS i0383A3 
F_SRS Wh
a5(A5r?5+rA3@
_C
x9

` c

Ao$LhA[gA6   
@7
_ON_M8_OFFPR06[L$z0#7CeM6C
_G 0" *
W~S)![ 9 2K,
@>A8 &@}A98^,o/pqA560wAX
I= A * 
 	 AD
rB
;`/!A;8!)D"s"9x""u"	4D#2c[[`AEm$i$!P%`$ $E[C:HF0=0`B0p`ˡ  0= B1
."@U6AaB>BmBшB sGH
1 Gxx&x?x"q){x)xx~) #*o r^r_ _u\QQB2QTP@n%QQB2Q1QN?3?303 <RQV3rRns2Gm3 *o3dSb pBa344pB440?V4V55 X5uvxp
,k BE40pr`188!]B5=]75]0]&2]qBqqX:B5)%B6 p\/0sau02 33w(`'{fx  !r@z[O>dd$kQBP`X @!BA P BBv
G``Gpp 2+2]CB
DC`2eBB9B9qBD[k%JE#~ ^"  y sF؀w@ @ "-[e
 
q tPz
     *}"C1C0tba a U!-@15
0 p Gr r " ` }`0Gd d"l[IC3>
" 0C[?C")UC4aҘ aC4C5&O.k     [+@3@
   
 
@D@C068C0ADR   !C8
D
[)C89 БINI	9[C%AuBA#C D
C0PRW
	
PP
@[NCDq	_RMV `;*_EJD КB.7P C3 BFZ 1qCEQ F @DP! Q0qc5S	qCP1
`

P"S3DBr 4p 1$OA#N

0

(A_CCDd8 7'
P"BP?A7n)\/7YA7Aـ?D*DBU#C*?K_GTMp
 `r 'D `DE [DFpP
Fa {Q1$E
bD`" E0PE@E0@M FMhhh 	Fi x `p
w ~@l a:` vA` bwb
bw cPwib ac  rbl rc u`AXp!abq7%|2E3bcaqˠ:64 !{ Ð	&1#I032rj
}jvjs{ d$'[0EF p(F  DBN9-i!PQD8	
# `hA9ODmAODBOEEOEFOF0OF1L	 \_PICPh\/}6D7M_T MpcD7E

SQ:  Y P
Y
C? R3C 

 G?C

 
	
$Q a
		0 F0!`	A	
a	5{53# "cKB 6-!!! ] !t!&&G !Aa6a 0[6A@	F

/R  Bkd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	9Qs@ 8-5uCPL`67	004h`/`u%
 
tz
" 
 
]6Ah*EAABAz0E7a!p7rp BhaM`9h7~T
_UID@ O BI00\Q[ ST p\~CL\`[H1t7'"Âms"E7
ACPI3?B_PSROq005`Oް5C pr &V\PR01͓~182`^Ȟ@E[:
L}I `{^99`p
	/15?@WSX!4sN/3jA PEB 
CZDk@k`Qh`piaFa ?E a?{`
Pes }a
aap`k
  p=ap  q %l ECP4 EYA  G}Ert

 E P `2^`hp}
yjZ  &>Җ1 h)h` ѨE}` ibPpbasabcpcau`a[(1F ;F0P! `b  1N<2MiF3 4  F5	!  p
`

 P  r
`' a 6 7 F5ee[Pwre
 
8q802BpFAILq8uSIMWЪA)C04r0p v MF34^ 9bwrA}BRC]D-3c6Ec`

F
	20U0
r12fHQG鐱 < 9a1F0t4	Gp" 320f02052062074K
89A4b!  Fu0/%pgT__%O(ڀbIb)J^T7ՆQ >` `qPASS5"512aOO0D `~@4Dap	o a4FLhSCM;D42QC8abbaP b ubpuf|F20Cs  _WDG?
<4_c,E=DAAyB{M4C~ !f )AB~WMAA~@xF2ij=<yt"1Skp{A7
pb}D,{h
`?{uG45a ,k`@E6x04QIGPE @55
nFW 0 G7B!
w,w98Pb*f#A4P
P(CaEЄ
`;{ς79 
M$K0	7	KO<pߐ@DphЬ4BG-
-𬑚21U!ǕhߣDh+	)QV@2ɀ
1;!m !I0%%,¶57
&&I`ޯ158h&#J0pC
w7$p ? 

p
1',,Cep
QobQ?8E0?60i?	p
_\
p
_3O6p3
o
)11R71q11)
x1eF3A)KOsd?A4P ૊pm) ;)!_WEDsSRWQABNwFOMO  `:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPC!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9c@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H00*)'XFw6bL	=֐X|gMsb31/~[A70憁x9->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9Wq
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[C210 01[P10l[#\_GL_yh
CpipjkE050\C0F2h50`ߠ	l['['ޡ`[ 1

[ 02 134 b5a16C2204gph4U3344 p{zh 36h7	2 D1 Z95i(	
5A6	PH\_TZ_2DG,n6

0Q
h

?b5 [ KE

aF
d
K
7
(
 30s 1
 2
Q3
.4
15#789AA B`W !C
(170(171
q 5
"D	py
h_ a{a̧`QL1E
pi `h
}`
``)3CIaqRbPc)b
 {bv1c `Pb
pzabrc
c3`B 3F`phahaw3Bi  `rP	a5сp! 1*C2[40 a}EbEc1 PC :
1pbq  C@A t
a	t xa

`br0bA1

btο
 2

	 P!

EQ"0 "OA2F!2	Fh
!{dp1
d{# p{r3bQLb (b
P bbwb

araMpLa[oB]1Dp148a0]pab)a&9h 1&sAh+ apbpa#b5bC{Q7b MVa<)*	*h;a=`R*B  v 8 s	<`#5h<7n-7p`D~3`h ~ `TZ3_
Rb"10a;M
%O9I9@hP
^9t`04`x` !fi
 f
p{tf'$apf t7cbb<8@Kb&q,`bkbFi
p

ep
d
ip
 d?1 ?d|o<@efi6i20(1 !M	4baBPa[794   _STAD#]_ONa_Z`>Ѕ FF T0#5U#6-.+U
7


[048INI ([_HIDA_UIP_PR0`44[V@o49MH5CUA6B}7[O_AL8 1PAL2	AL3C
B_AC02FxQ1VWU213PSVF4|}SLX{PRv0G\C!36]prB7n(R\o0DA32p
!p
.O4$Z4SQQQ3_TSP
dp Cp _CRT uZ=0ut^-TMP4o[J2h!D) jE2,G1 x/3+2[MTZ4_
S:9H`
`rr|rC13F`r	`
dpo
d`wY`rZтED}24F8 48C250 1 23 4"5o5  6 ?29  57`56
[ 8@(Av592A h C5AAB Cޱ`U[yA
	p`@qjF05r$58aaaJac
``rd
  b}y   @baya
a0aΒ50c!  eraye
	 evepe1c ucdcM
ErDcpc  bpbgC	bdpqe)wecb50eofg
fape`pfafgvdueA`b޳1` gTb 	`5 $b pg19agg7agub_dMF05%apP54}p0`c@"r52 3`_ u`py1 jDC  E "  1h H
bhQĐPr Ec0ada
e2%-adft`f	ru'adSuc2ߠftd 1gpr:`4ib0 `x601D,7&-A%-EF`Q&4@/
BmBC061pib{hb1p@61D2
j123"33"@Fp	4 w6
arC019abpb<0+b0`~`babuaaP `bua/jHSQ5`19PHftQ64DR`]t 60`` `Q9XD!

	          y p365[Kw\/6K266mHH
F67F
RGпGP   }@    Ps3	0	p  z1	[F26'	 k19CF
rG G$ $ GN N 
P P Gc c Ge e wg gt t       DA
T (3 W(4*
a1B7a
Op_*`^^.`6B\_S0_Q!P 3   J 4  5   M\_PTS7HSM OjZ6`'P1EP 7M?#\_WAK@q 4p^93<?@11A'0vyvy"116Ha	5yy67ÀIŀ\ A5
I8̿4 5ˏ10F

O@qcbcc:c?72
<0
 
h?30CP+BB-- K5@P\_GPEDBrO
_L01
bV1

P`I{` {`{
Ma 1NP@|
Z a'a a"BVI#L01 I{Z68jA@Z9IP98CCC0Dp4c}
0CF["
doU34OM@9 ;H1*_(ooQ
4>
3B6C/(D'#E/*L_L17 +q83?`} %@pL(55CS0F`^{P5 2Q055o7qlRx1E 0CRL)DEF0%8'WI
D

󐦿&a:\!dF6a}`V 3R92B	F@dA`N'0`v</`
J@0E_Bh4B
 ``
 >	 ["SSDTq wHP ~ HPQPpc@@pMSFT L4xRC@	1       #__T	_w 
_	O6Dwj
ara
aƉ46EP]F~AEij`j"F hF#2e$2 270_271 70$71 JV*3U3 yj2D3j9 	2
D`t+qbbP6Dh6Ca b 6C'22001Ӧ216RkE29r4yA73,
˂b+py U  V!4'*[A0`NPDC{hp|
alPCT 7574q 3	_PPC _PkSS775      	 CPQL_BM  vp }( <  >0_  Hi O O  ! B f (&  $~" `ܾ `a!  B!

 zZ `  %!a   * `
! 5@b	Ya	!
"$b@ 	 a	!
 	͚$&Ra `AE
 D
A! `(d
`  A!NB 
Ϡd#b
@	"	&da*	H'a C	$ ~ #%'"h`-a))ޡ 	aA* b*/!'" 8a& 
- 1,0`%`!05΀(3A
@# `51*8@:-@2aD;%aρ/7B2"Χ`6	$b =a :%	1	3EE9C?HE /1' A;a@@d@?AAaA%a*"BC
 7 @@A@!9,aE
 %";J9 +Q;H@ F" C5!$(%C;AFP>@F@9BD :S	BPb<;DNA@(Z4: D+a>@UR\!$	@ݡT'E
O+@IX3$ ]*d H!ie@`A5C F"T]aV&#e "C
?Aa"D b^c"[+#"C CD(3#^ Sg_xkDj$  uCme)H$ ` RJ7p%pD2! .!!d^
}Bp5I3x S&`5 %!jcnH~G;wj4'a?JD yGe$}F5AI!  iZB#	"d E"A`Aȁ@ bAG'FF 
"!AK$Ic"{
6/"ă!QJ5B	7@"j  G&a|geĩfC'D H7!rdP G7 pE$
R " g0xHߤ ha$
hbdߡĀX!iܦ6¥@̢ Br ŊB8
c
0sdV0B} ţN %ae
@`A@@`ǀ a! !!aaԠa!A@@ `Ab,pA,$c`BObŅ³AA@c B
dǀĈ` 0A$ AaL"a̡(>ac$AdZA aPM@B @K B!! b<
!!  bീa@ `ߠD'"ޠ "}B  %d@ۢ  `Fh&" a\ ?  Bf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     "
   	 OSBP_BM   p ( n x0    C % uf T>B \ 3  G?  f  2  J !   Pentium(R) 4 M -( ^  H3EUV
Ua UwuUQ"3@35
UW 9}6@U.2  #f  "`0Ā "A=Uw
"
`/t a 2
?  3>=U^
 @	$AWb&
	##4@
w,
@d(A_A "el*@AF3(b'@$a/@C#`))H(!5$e" $a*!)-C'(A*'.$a6`,^"40") 50)B663`7""7A#?W!Q "6 >O@5<!BDe	c
A
E GcCF`H0HWw(@WJ MiDB FM6E  =	@J
@T@UK 
g  u
NI"uW'
P&0AB?.A QE# A2`!=g2,`!
8C	A>&΀BhDMH`d
̀!
ܠ8q8( ̀h`:` JA*@	>ߠ"@]`"a_# ;	"		Be	_#`0 mСg!ah5B  
 "@#s 
: 2 &E`mx" hpb `#`n %.
"p& U 'BD0A(@E.`+#.A eS0@, 
Ha>	 `>yP@!` $` fj2 :`"{cL/F\`#_!A !^2eC_
lt>@oA*A㡎Drb+␠3
#2blj !?! (!.BvfaaA )%| o"yeAca"AC2 :eAA0a"'N @BB#/dI&!Ic( @8!aB `	,?:#{#C`( 5 A  O@:EB$c	
"/ =	`ࡠ#=a%
C3)waD¾qB o  T#
aB5R2b/? f"N#A!@D@}"2"OE7M0g @EDBOO@B4A/AϢaX`v/dLb!Qc9?f	B? A!s cO od0oNA`z$>!ba D %cÿ#Cj @Ѐ #e*CetcfdF"_@ cZAa#|,	BgbY3³cA >#9#7BDL
n00W@1 @&#Dl?> 袋 P	VH> VB!%t *b2 R "kpetp`yfb0b {@;k @(!@dch @?	`/	aA"m$Ty⡙L *D!-atI@ᝡh`@A
	!@bB0AA'2"`NAñ. `# : e!A`baED@e0A#!3.'H f@ &`B@@3  L$@$@"*@ '`g+(l*"# 	`F`u   C`   F ^ @Z   \
   I  x	   	 OSBP_BMI  p ( e }0    C % 4 hG  f H  ɼ         
 Pentium(R) 4  H ",    
"#
  P@"{o"o r"nAb  ?b@
	 b | _
p"'HO 
U'
@HC/!/

 @	+do
$`*BY ooh/x@OOMA 2"#I $a}('"a#
Q a  # 
C*)b  %%)BZdr/$U*uP2_)@W@+*A "Z6 6A
&
7 .@2%	!:0j&J4U&<3\,=B `'>P;`a
>6AB>OD A& ߪU` 
F 1[=Z@A*sm @_4a"2A>G2""F"KaLYL%J@HmR22KXBL^}CM"QU
U,c(֡	&!JRT@"f&$`!#U)S&1  $A F
2@Ȁ`	 FD*X@ ,"Z)P[ 
 \
T 2`]Q h 	X@UY(c 	 UPrAY ,Ppt
"@$AR`] Zkk)
Ae
Ac>	0g@"] @c$aA_ c	u
%Zb 1L[ 	Ja`4]
Ex YA*P_@qF-vԀ#M_NQ	,!{!
H!w /AnBAГ$akD #YPAn&AQx 1!"_~I \4A_Cbxp a 3zIU
8v∕
$H ea:b5 B!7e2:  	`@QB ,!P!B2nD"$Awa䗇+aa9! FQ@@Bcjc	" 4!b@S3EBu[C'
`_%A~	E( PDf#C.eaA
\B)C.B@#@a`Z
B3P@ "9E'aA3" %B	A0 ON)|)C%)/!#a<Xv C8 a#@=-b//Z!<"b=!jd'HO4II
V  dE /h Oc-)#&!d@L AOPO5!"_¾ %# L c H{0	¹,X`:A"u"Aܱ!~O6Fa		Ba*e^b~
·d} el! ZD_!2 "f#!_ᓡbt
ȃeCch'
NDzN #Dh@AzHbb Yč Q)boY\ c8aAaB}@! a:`doA(abH!sC ¹zoP!a!@e	a}G b`a`( "Kya㎁ᴿBo!ɡ$瀓	_PHɷk"C{!ɬ#Wlp`T"{ ? @ɶ!a} |rx
i A@@
aC=A|)Ţa @wĦɩi
d
&_Ϡб hI۠b塣-[ A 
bUi'&`0	 ǡ$Lѡ@
@Gj@@@2aJ"U    OND\!db           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀hX$Pwh5 X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " h%.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ h;:I:  3  P O O 	   hor@῀ 3h6BȎ؎zЍ.͋h3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y   i 0 0j Uhp``ϋ;@:Wff > hp
 DϊfPff
fр aVWߤA+S@)'WŢpr;_t[s(`(F['_^aWf` f vru߀p6fffGfY܂h R1Xfߊ$
(ffw ~A	S22*{OPr'!$߿ 
 uf 8s֊ҊʠXQ;RP
t0^-r#XPX  uf a/uSf{UPfPfXZ+ ]f0)ff]rff~m`e#n z= osrsc:B
Cb_ 1f^ |w @t; *f驀@Ikow  B)ђuU6ѩȢ+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu Fߊ1KMuY ^Ys]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N O蛂P}QA` XPhWUQ^PԀ3ʡ A1sд 謱 ]dXÀ}-p΋_P^Z`Wᐊ f} mp_;p0                                                                            - ' +?Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.NZr#M"Zu 6(Nrgpt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF qô蛝	 -qv	 ӥ/H	r蟥@e.		p脀'^F&?s  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0GE]EabgVfQSjf׋[G!fY^f& u#GWf  2WrXP'F#~r .u7 u/{r?`. t8.> tu  2SrV ʀs`,N	p N~t$` t u/~ǉ~ %"NV 1	s^Í6O.|uLu..N`>(N .:UtaNaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 'fVfv@dD @׊fA
@NP.eXfa ȋP	rs$
2

	fXy!9
dD0f`v]f^PRB@    RPXuUW:>_]s*r  }$<P0r!P@Xup>q ݪ@<@`P  osX切Xty_>c >* BQ	F?Q	 QV  PRPW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm3
u
rl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCoz0<@,rFAnr;A@uQBu< r
tr&wtptu
ZB\r rR$!Xt24 uu@uu`  u2&?fPS `00ovSPSpsq D
>X`?D<OƋ4a`t~ a1t!$!"q1&0&PQȎRJr# SMwO "t߸ 
`P2:Tt
 YXÀu_OuQ,9a"   <s& ?O `P93  >O}uǀ   N  NNVWi<ua<
uuӽPց H<u>uh2<t.$SQ\A[|u|
0g|`jt\_^F] }
;u}	 .qcQ܀}u	a`@uDaY$'QV 3߬+^YD &!hf!ff?ffJf0^1e
c[ %f F PX@OfP~$=r0&w)ІEfu fqu`~Cu~qt05SV|wt` t t
^[PfQ
  < } @ f	t` vjaif`0ff_ k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRK=A>o$p|P0CfQ`rffXORpC{Zru>AZr
`hPR2ǜq4XߝZ[?OOJ   $    <!N!a!ӌ!aߠ ###-$Wp;@,.:tL u% t>JrSј[t P.?[u 2t0t_M_EfUv"v t  Mw .V PXF
Xf]h@ PԏA !Aъ!
tQ r00L;n`h
	OVO.6#  .I.
Lj@1&  |.0u ^0#؁ .d.$~ дp0	3j0rcOt` 	OtOtLtDOt
OtOtOב

1u	
.<
.}h $^%ÁUu	USp;R#G rL?\Z 3[ ƹfP<rпwfDG
 FFQVWUP؎&Br@uXOߋ,O> ..>@iu Pa 3@B ݾ&G $P$PC &I (US`*B>F &g0@G1&O2$`{&GAX]_^a `b 
 N``Rf3KWP޲ {irs"jE<x< cyOLuRE<s߰fQA0}3  r/тP.  @bGώJ W./Q8@[ÜE_PNQWV>PtG<tFr=.EP ?.&Pa@UA%507
QَɎ P^_YSRt5ێËfQfS.q&Gf.Pf&_f&_ . f[fY20oZ[fUfCTRS赊f]ð4:H@  H ^  ]aSQuP $@X߀u@A_Xn$ՠQp`ޟR=
^RVWf1.1Vtf1'̉cQ<VV<W0U  zT `	a$fP >þ $f $6$Ss >$up茉$f2>$f@$J(f @$dOf$ .$>$ u0 /R+quX>$tm7`a E؀~ Ka u
N_^Zl A  PP0V_ɾ**> <r@" u@Ի 3r?[U`-R  r.6'СY]C)C)$a /  FC)ڃC)ʒC)Jث.@cB{K hV
C)!܍ 	C)4R>݆HݙDkkLl*Q۽dAC)< #R*?
C)@ ofW3sAq< uf,u#p f3Уff=SCAF2rf_U< 0f
 	<! F ]@lW  <w&'V3ɊȈ[CF` ^ t	  Q_uQRVV<v^.
t0"O pùBй^Zw@K  ?)]dmUn)P X*sm렜Ou0+]UU~A $$!  g Ugh" %`{&&:&`h'U' ()<>(%Qr2t"S"B*O o蟸 袸貸["2ɵ"Y( .6N*3  = sf`?ffP螰W02ˊY[$
 .F}q 
ۀaN8tS Ft f% I@0 t0JA=   "K  t "x fX
faRV s oZ!
J
8
1
$f4 Nff`4eA fu4fafFD fP2PptfFP ^DP s f!e
fWzf?_f3#"fF$RF(F,R^F0nqf3srBrf-1fv,v0hfN,U-(X(@$иP`N kFfV fNuf2N t
ffFDlf3f0w f!f N xfր  頉fYf#f#ff]
0 VP@f+¿f;FLvLfFPf)FL%	f|vAfI ) swf*͒fwf
fN
Xff%	GwfA d!`
;Vt
f5A Q
ĳ6"8  f% " f%ğ  @"	 "f'F0002KFR) !.P@X3@; Ǌ=ffjfV0˛͘PQRWSӶ萱t" 
[_ZYг`ֳ  QW iǀ߀@?Ǹ bпzLad0 
  5u
 }@ @Ü8   ;%P1P F4;W@H0P ߈>%S5 N0Mt(BR'9ETD$W^1_T*u	 a 
yoj)Ӏut& P5& A)u&
u! ×8W@ـ AU> RtY wvMuG	0bpRu3uOQtru1 ta0> S:u@8*6R:EFu E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuEu饷3  t LE>I q u	ҿXuP3 t	gX랓tS%yE utt0#)	&2!q7=El*x3;r.Dv+}W+Xu432#*u!.Û-*1!	 2,<Gr<SvƀŊ,Gj{.#]jC%J u$
<.r!Lu24$`.Ʈ2K#/jw6rPA)<.t<+0 uθN<-`" uJ,0r& 
P56 ;6 %10Ü ߣ JEA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xception 4 - Overflow!5Bounds Check6@Invalid Opcode7 Device Not AvailakblJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12AtOack V
3General otecErrorq  1 =  System Ha!Pb
 tߊ
-XÜPR]bZ fVfR6A4FupY4/vzu4pcP4Yύ64{
4tfÍ64j 64`fX/ސ4T ō64J`6#4A0Ǎ6(47XY_WQP6=4$Q-4Q14p54
69465F
04t4]&4x
5na15WJ`Q5o/@b	[Q G; 1`(0_X[S	 6z5 p C8BBaaBaa$at@0 ο`FfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~
XߊÊܹ/FFYNZ1·A`QȴjY`Њ  aÇً 9"ԃ 9 & G(9.&7'@'dQR Z
  c Z@ 
G XYZð
< 
7 `Rp S r  `؋  P 9_  ͑a!
Ю 	`%a@  `
UЋ؎ ]_a	@]ߋ3G
AF `P C0[q$9SRZ[` $<u 3 0ؾ   fa3S fK^Q< VQ=3AUAY^` 
aË0RQ3ɋf
RAыf;v+R'TYX0P@YP\UfW&`10u]Rf_ff_]p_u< uEuPPuX[uZ%<PPE EPP runtime BIOS kVerso.1  
 ?<V<`<}<<=?=d====>
>>)>5>8>;>s>wU .;];.
[. 
[r _[R.
ZpQRZPp<rt2[5$ԁ !Ȁ
  -" ZYP&5	$ B\ p[		uR xuR}] SUUX.V2f	`&nk ^C	O ZCWY	al _Z ?uÐu 0z Us PSRBt<r
 j ?G`= 
t<t ).>r> Y.r> 
J  J PQR3쨀uAB$ԡ 31HP  SIMPLOiMOTOROLARmVPNVS  ~H Oɇ  PVs˻ʆ 
p >ɷ\S>ɷS ɷJ ɷA~ɷ8@ɷ/SSR &D3-&Z[>ɷɷɷ &H
@ t``+ cɷPɷɷ~pɷ ɷ褐?ɷR`&3P M<S:Mto6>  
6^VMOO.ʤ ~n*kʰʰQ>ʰ֐ ʰ ڰݰʰQʿ>ZPʰ+$ʰ$0a!ʰm&ʰd@	(ʰ[	*ʰR`
,ʰI
?6@Q?ʿ?ʳ+ 
r)>&~X^PS*"
`V*[X0Q2נa ٠Y`7-uWt=Xu2
f*e*ذf*e*20 **莠a VR,txSR ڊZ[  Z[KH`uu? %WȠ$t%PF`^ s0
udjBPjZ^`U,u=tu8qρB`b
@͟p Ɵ2 g趟0UR,u<:tu7Gt_)votۋڱ
0iZ]PG?bXU 
 s ]`K:KxSP>YM M>rQ4Ys\ P+߅ 3Z[x0"({`"P3
ݸH ZٸG RS QL 5QK -S
 pN qM (c'
(<Pd,EYEEEE F[FFP&` XW<rǁ  .D_Swt 
' t r
2[e #ru0^r!<	rr&    08Qs" r2.D2& r $s g r 9q	8̿ r 	&& rr	ҁôQSs+&' @>' osa?$sQ
u>[ [Wr%p$S r rWq	A9 f" $ pQ@	Pm CX1#t sA@t^Radtbpt t
@uQY`
 Xr`QPPPt	RXdYQPi0 t	`̢DXd$!<!tQQQ  q&@tPGX ֻ (`<u
 @&   >!@t]A AuqP$@u  , & XV߁  0`O  r
 P<Fu u=s	  	uA
w fu	 X RtGTtu`6FtEuU8rPRtKxGr t& 0R] Zf&Duh:^ h 
Xuh@<rX&  U u@ Uϡt@Q!	 Krr
|rr  d蚐 ﰮdx $& 8t   ~0zQX uSQ^ `b+OH `*C: E8u01 Pߗ @@X@3@*TOC*Y $PnP!  6J WJ >J     e fPff  @ fXtfUfp fSfPfQfRfVfWg]?rd8ߝf_f^fZfYPXf[f]ge333#rVd4Ad^;sgu~` 
3 
s M tAt<V
rdDg}
^` VWd_^gEdTg}P
v}gE `tr	 	t}d8@b W<yt@D(
Ԑ
`PfUf]3
t  tu Ó' 8.;Gt -._
u u	fg6$+' +kEira0js\g&D
V &DtzYi 
B _ir!0risuhF. uhhh$hrOisJBʊKZ Shhrir
ir=TaXhyoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
аF)t߃ r4F$
Ft+ F} P   !VPXV@"WPR u	ZX_PRAqZX0A  (0 @0Bp	- lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M bO` c!oOF|	O HO ?UOCD001EL TORITO SPECIFICATION `oQQ)QQ  A " * Gxx  x y 1? " *
x"x 0 %  s w_X _y\|[8y y rb éALdT ËEtذE
U a0Z
p5r0 t
"rpq~xf`i2PtW &  !i&E3 tB&U
&]@ &EP t ûuQu0&E@ !ofa  z@,B C zR,S;SiSpS^RlRg]܊6J t4Js37Jܐw]k
Q[ uR3J z{   `{SQ>4Ju5Jô% 訬r!<\3ɸ  3 3Y[SRV܈&=J ܸX}\\t^t#X K>S\`=J<t<t\Ɲ< t`u3^ZpX褬V\ppu P	\ir
- P_Z[Q_Q = c
uPۉ7J4J6J2EÃ.NQT4  `3 $	Uu &?t+aÍ>N.}
tp 	
t>(N .:U ǀ	 V tMRZ|p  u$$<t} t	^^pQ | Y3䆊Ѐ u*Vh O| ^t
 bu
cs)t!vRѵu3ێZ
t	 u
u
 uP@s+XP`> [%ڰ`mzXÀw*VRރ| 拴  t.UZ^ϓUUUUhVVP .VPBBX$JJ2J¿B4Pܰ0HBtJ :Xu` 3SQ V tA&q JZ $C@A u*uP= ]Xruŀ̀2	w9
 鶉 (8SQ2<

2ۆcV.
$2rvqdp?<w0
u@ð  ` 0   g $PIR    A&.p` a b c % Y`	 gi 0 0j hp`3. W 軞p
_P@쁮p aVWWS;Wt[ 
[_^pRW3`  CQUu t`GYDh 3/$_ZSQV.W `[6V.W^Y[X U uPuXd]<t r
td8?D^uRWus T^u! 
p`|&
yt,ـ@
t&M1&G&a`ՇLAAAa+Íu 2 ȃot
 Q ܈$FKuOð`v
u	ۍY;sYuS؀uu)4  `u  t&fߊ$f
3?f< wRWS22f0 JXrX !u 8s܊[_Z tfQWRfP
t)vr 'ff  u ֛8ufXZ_fYP@ rڛ VQ3ћr: t+aߛ4 v 芛
t3蟛8t	
uY0	g&;t4g&Ct,Cf4B<vf f0
g&:#?tfC1	fSfWfVf޴r7?fg&`	f`r!f`Gag_&O@` Nb O q,f^f_fSF~t'} *<u 2/h<^ h= K1qqswWs[tas
2 !"  |  Sm`.D} .DV~ ``@N\&&D aø0 м Dj S&&E  j3Լ{1XЋQPTP !XY`.\.T	ώǍ>J.ߋL` `a.D`aQPƌМPXXɎ6aU f$JGRMAROo:R*RN# $f_ d Râ$f>$PuGf   $>$ t&r_Vu3pR@&Wff+`3Qf׸@QYrfuǳQ	p%^f8*>$u_f0 sVQ$
f6àǁ5u1$ < u;$thrUQ> GQXaS`W1-oYYYY_ `@ȏ "U-RqG    _  *[%a	@ `  Gd d`",1 >Ga aO 
p }p }Gr rrs sq]
s @" = 
` 6r`Ћ	 

 '`j`x`a`  M= GŐ#" **00qsr|Ab#cU] Uut"pwvwJRQt%v̺pY U a [!pZ@GaC  u(<sWq.%a_.92rPXs]SQsPܢu..&+.	p\艐@ t^P.&u @ u42..  _wPUU**Đ&u XYD3P A3.{G 
XP *.rWȎ_A bbbcc(c+c2c5c<c>cEcGcRcTcVS3.:iwbujbK @[^* UFPb2SFS.rbF[wCN[QF?t~bsF2~ tﴇY@ 70L\  _ ø8L όdȌ`dt6坾A謌`05 3`5$ $?dEdNdYdhd{ddd`d$!<!uy!!`& t"&& x<u&  Vw<t @K!D8t( 2 '2233pcf>"  t1" ߃P a2ۊ( Ҋp ) ǊȊ&)  * 븊跊* >+#1 d>,w0.- &>) r. ѹPR ut;6 u6 6 }3
t,=
~Я
"=
 
0I5w<t<u߰ F@ t<   @s`
& 
<uaw\wWQu& ` u3u`!Agv &
Ø謑LY6 FF;t2ÏfDn;fSaia\"c` \0ba3ac]faIR];D]Ep;؂]ࠀ`[ޒ\!\ޗ\\kQ\+t\ I|\Z[ Z0Z g}
3gE
 t"6ND  [guAPsU I2NN  
$$c&wE
pE   Fǿ˽	*<}>]>ʀ
SQfVF! d;s^(2۹  <pF  +^D!8u _#Nf^WVQC3uKET! `!0w $I^:u:\!u :rC];̿Y[_SdhӺN.ذ45@uk` R |EM|u 'b/$
@/`&La*/ô# /6//faRМ/t/$t7/z wȋ0Z u1Q){.$... #. .$.PRZX qÑ0<:rd uqP oPH pp= @_r q& qPfVްð:gfF`XRyZÜSt	tv
 vt[z؎ Ѝ.͋hi3 Q.E.:F.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSpSQN<tt	fPXfP B tY[Pί QA׀0D.j erYQu |rY<u,fCISGu%f» f P f  a9.>j .jqfPSo ~@f.k;lO[2!:.kf`gtuh9^ h  LtuhKaúB   $CÜ.kou酰RVP
ۃx  tcPtt>@ KXSx$P{Xr$,Qu!$
BB ,JJq4HX^ZY[Ϝop$ q /  3Ҵ./@32ƀnuo n Xp'B|    uTf`0D ӈfft;  Qf3Y,6	5 ! {ψ@T'м  Go!A0*$p|p%vt.r t4t p掀H2撰pɆt w ZYJB;"<t$dAJ_BqpvB$PMM q "_SYSID_  o  _UU  fl f@f=  uf3p fl P3Ҏ¿x ȫVZ]                                                                                                                                                                                                                                                                            
4    S    -%  ;n$$`fwyhAC  D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6(N  @ t	3!
tr ^	
F (|r
 	u뿋^'Ât %轲1+	d1*515r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>O.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r2y0ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 ؀	.EF2	
r]wsms1I9  <$u2 *<#"< u<@v<%ހp!2 Uu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZsmSQtP^Ë^6O[.Aؠrf;	DE"z~(LuTMs fPf}3fXr1>OP.  .GTǿJ 耪./pPq3V#:Ttt<~'t9r0HQEE߀&Pq<D_D@ % 5v%$~6O 6u0fPfS&Mf.Pf&]f&_} 
[!
0'Qf  蘒r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^Y@tffm_ruLr Yr)8r$cr皑r"Va	)rj!P_TPQX rpw
u `fSfRWBt:?f.EffffAUffsP-EMF F
tSuNff3fifVOf.WP*f8f'w*f'F'*2t*܊f
Vvf߈Vv 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюً go^ZYpB`SQRX0% [F mo `7h. sďQ(&Q Z^N=rot
r`a r[v">O fKfa`, 3S5<s-OO8L9
t" >OߊG<P#w<Q$@ ~dOZY[PQX hv ߇  t`rzru3rij`wNurWu
p`dع 
 Lr.Ǵt%ttt t	tCHa% su~藎r	 2PRZF sH<t<)t<(u;ь>A u/WU>)`]_34r0蓎Cyq`_^a'c`&PSR 2?Z[)ÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8ؿvNC^~nNfnNfˈNnfNn"~*Ċ^
^mQEfYSQKfPv j 8rC8sfZRfXfP8߈FfCF VvuK{QfXr+tðP@P3 Gp1 tff   Rf+IYÀ{L@#,u$`Ύk2c
.s^G fF! PXG t<"u<"tlV3޾x 4|Q&?ws0  s& p  &G` ` G]`t&O &O`uRp`f&GQ`Pa  AMWQb b׃  Wsa,ZX<7RQVW:W qwtNᒀuÿu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^YXVQ
} " uRPP
߰  ^nش`Sy[PS3膡[
м!!$Xuaes3ɺo!rA
!Z.Q!3t ځ \X5!fPAMSUߋjVW  Ў؀  苐j  u
  
  t 	˻ʆ  rrp[ɍv[fF0]& O0^
 30&Oˁ#ޅFU"nj_]?v
` и_^0jw 1
Ap  MB RW 
$ D -&= g&FGvuv p c hu#'  &` 
;hu7}a]f3ɐ ԁPkuB8& 30_ZGF< u  u?2D@ HbsN~ t
SH	[ôfQWph f'ff8h   `  f  H  $p`| f_l f
,ā rMf[0#t5f 0Pf}% ;tf ff  @`fXQ_TRfxpffú ,5Z`PXfZcc``d f9@u

f<~OfaĲQ Ref%N0

 aDpgB_zB3E@j19An`f ftC" QBY ffhf{aÁqfa{ˁZӿ @j3ffGtf 퐳OuAmWry!?tUp ?Q0g>c>rQ>L G B = 8 3 . ) $     0/﷉_Q b&G t'K$ǹSWfQ0 c fd4 cftYcfY_[d JfYe``2 ;c跔c QDf6棍fP 1cf$6	 5PqgsfX A 7{ffafWfVf  uzs 3f^f_fWgfǃ#Eg ׫ݐ뺘APvT2gfgۃA g u	f@w1 0f@f@f_gf1gffgf0	}a)fQ@;gg&fG7;wf+f@+7gf3ggfb	fȑ#f=qfa
Wt @P	3
y
ff0
gf3  P
@Cr@
A
  gf3fSۓ̓ 5wff#b ffyZ?'wf3f30n,o;wP#4ܼbf[gfo p2
f'fP	c	
퉄
fAAXAP3
 #W!.fكs À +SfVQp g46fFCYQ  Y`f^\ g&ހGCffTl[OЫ` u #< t $w$?aQh@ &# 3u.0ѓ' ;$x ڳL
tI<u	. u< t$\ ptu	V $
4RPS0@ u7P}ذUNNNO밪 Oط@ќ$#c#j A PkOXðo'  s1p @ѭP`Ю j  R ]pӀ ˎq:ufW	rf+aSfW.ܿuOV.f !"$fD  v@W?0# 2ۨu<@tĀut @.aY
˸_ f_[Q
! YQ ?8  ` PRS%` +ð ;w[`%n SRW*׿OзIr 2 3_ZRWQ,ԴAs Y r3O:3ɱ RQWSP b	$쐧X Q쨀t ;l !`@ sX J 1	-RX( V_p\ m 7	XAP)[_YZÃU2<UuX
8
DYJBBǃ   brT
!u`P @9؎2
6W	u ت * 8VWQP Dt!WQ:t
Tu8v
Y_#Y_XY__SM_ P_DMI_   #9P  2XPUv F t	F !Ff ]X"X
W8 pށ@" i &g +  pa 
u
fN@  ]ϰ?2ðq  S\8&&G pGGP    [ Q!@   U`R@@\&׍\p F0 ]
 ..c3 и( -  2P
C@@ XWP/<w3t@*p O $>F& ._	@P X2$30     VR 8۳48!AufQ8fYgW[ø <Ȏ3]Ou q 2fPS=Au@a;Áp u39 u+ f?wufP@u BXu
_fϋf0`< t`%b{At{N|Sߠ{_ k@Q  ~{{ o{KǠ !qO@D{	E{؎({+aW{Q   AG){?]k{o446RfWп.zmf30&
f=SCAFtViG t"fffꀷ Wu_f(#01tfPff  far_32_p9
p tODu ($
`,aô%+`PKМ۱Jt*~ u n$t0a ȋKf`a
%_D	>	 %` +($pr?<
%	*P_' @oTO xyOy er$DIsL MT[p.øJ
fUfQ 0fVK
rMоgu qN`VPɉFu(gfF!fffMufY2Yf]Ë< 3R+fQffLfT6DfL'
f^[fYrXt	A3PXføM
øNøOfSQR
WfP
=t3   fRfZ
 _f])^0PfWc=toQ!IUPXY f1l P YXt
 t$a=t t!- v _n1X(RfV8MtZ 'M(042V{f!nw#t 0r $r	 @|f^ðU; QWVwy^_YSQV3
Ê^Yp 膽 e }  t F0fV1fffa.6fff;w	rf;w
1AZ.- An"  umf%3aY/aBR*Ȩ@u$1> >01Po0
= <rq^ph3`ȠPl
ffʝ @ߜff f- laRW >Z*H3&G;r_Zϳ 
<t  _ qSڅ t	tQ f1 ط  d@     $ԡfYX4Z4f4f P,0h hg&>tq r 	r
  u f_cbah^f$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	fj#SF	jPfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~
g&-@
p
 
u
g& 
T|`y 2~3Rf\&^q\QUÃ3ɍ6N.L.:Ls&`U.DÇ.Ls` 2`r2wW }2PǺ u K렐^t
`W3_t 3t
u! GĨ3ұ@Uus t>O.| .P u} P J}uLv   e3puv`bW_tURQvRU`@K2YZ6	u>^
 .D P@+ t#VjLf^ 
U.LV {]Å QV | Ys.pu0	 t	&Uu" ώǍ>J |  ÊöSm.f.|flF  Ƅ.|Ǆ߿J\PQW 3ۍN _Hati
/g uRWf;rf`Ȁvs'`1 u: t-Aw(@tD<u u P %faUQ	U F @ E][__
<t~`Y]p4wó1PQRbfv2 ^~MRɓ	s[r`	x tt -  P	  i09`K#r=s  "~#@@r@n 
`Nff3us
P!  f3gfF!dsб"yP@ffۋڀ^03&fPQXLYq)YaP'у{ 98 #	f<t`  u#f$!AP ~]faá@䠄t"
桰   u$! !tp &k Xa{{{ݯ *qݰ JKLs@P@]FF
]X `j . j ۋv
)Mf.N. tI4~r@5p3؊^)1a]uw t&Du .⭋^^;Aa.@t&`ԣ.^2 uȎڀ@S6t6^2Q. @ PSFg
t'.:tX._П1PfXZw+ f]fŝf]rPm nꠤX r-s(@r3H r  rR dvF\r:Gs5&DC H Prfڋy苡_FÉF(t S^$}:u [r
F&F$%&=vHH&
D0&d̠u ~rc_wu
	A	πϠa&DB êĪǪAT0	VcH Urp_蟁sʁ `-su fqt
]E$藀Eab&G)
V Nh8Kr>u roG Po3F) r\ {r=H r8^QWss#

Rr
3 s@÷M1 |#km##F("r#謲Qlr@rk20!0p ×!r"!F( Q'&{dK0#߉V&Ơf)&t N.QSWfu/ r)v{!ufPs CfXtā̿_[Y`<t};@3fÐ t	f Cu
utǳf@I@;f[`
_ 3ja ;<	PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&!Ѐ E 6F u(@$3'E&f$`
ĢF f%R$PG ;B(FGq1 fF" PXۋN8NwN 4o2N0(`00s/ ml{B
 r
fQmru$贀f_Y_/+̡+U+Ñ &u b%trq? VQB  BY^	G $s
3
P&u3` @
r
%uètǠt <q66V&TЕup 
* &ou^"Ǵ  聻  ŃQPXuN%&:Lr= * r$ P @uP<ut.@ ;& ; E qs2p$o<@t22P !$!信$qXw [[ĺ".Pù[K<P?x   @ 6??TPQِRPQM+XZP <u
SQRs3ɺ@qZYP.
X `)w.*wafV`f ܿ
uʃ	{rqBr" s0 z ` 	~af^3`@*2ϊ$?ԉN舿T@~WF$
&FG~ &U_Иb
ӓW  = _t2밎_R Zطˀ$0Z;`  =t
p~    %`  wVغf`< T ,333ۺI uF;D u	 66uu%0_#o	ҥ	1o
`
	ޤ^"&S$ 2[ø 772u:r$<ù ؎ffߋ0d s<f+0ff,.b 8 !Rq   ). ;ɀ;\f5f.4 ffffE                                  0 />&   A6׺a 260VfPfSRRFFf3۰S;"fV$
Ѐ
tOf `T W"TϮP1PffZf[fXЮfQfWfV f  g&?tgf&Gffкff   L	g&GR u#f^f_fYR2p n l C  Ơ@#@&Ȱ2tð
,pڭ$zQ٭ø­˭貭а諭	褭2s s	2 | 脭{ }	 va{2f2 	_ÀIpN :4E>7
"{$ 
)0 zB$2
ھMпUY?tA̋ r.])`^ +zor.f% f UCES?sffr 3ﴇ 1f!u%f#f  s`t s``u `p VQaff#,д f@ rffafVRQ<Pf3Cr6
+߁f u g> ttBr(A2  uP/Yf4^0@@mPfR53t? r2fZ" qu8_-t(`mr!A1ut 

J?t:R!4g&? tZ?cQfR8гt ,tu
@u$2(Hp)@t'@u'-*tp(t
 /!-  t> fAu2B>P[ a33q 
t@ o t}afQ;Xri/p/zB/RZ/rGU/Z3tt@ި$
`O,Ψ$PqDݨʹ0Z
fVQ! 0fF3gYf^0rT蒨表  l$s肨2MLTc@. 

5D	  w SfP4fX 	  [@fV~W  _ W
t<5t^ut+r Mf^Pp5à3Ҿsû s FKt
po J8uPQfVW  QH u# @ǿ> &=$u&}F{up 1u 0tЎP{R݃D@_f^PSWQ  0tу!K_[ wEjǏ@ q @ F0 vP  b .& T@ z 	 *  Q ,Q }  @ 
 G G S o    	=QHewlett-Packard 68DTD Ver. F.0B 09/16/2005 m]  Z  l ~]Q[q oKBC
sion XX.XX  
 
  _ 	o~Aj# ū @  ApI!, JP12 Intel(R)  ׀   rnal L1 Cachea bi2e	
 z6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7Cޢ
     A 
|s|
  P5P DIMM #1O2#u
!~)"Rps Uʅ"K  @-No baty,"p
;1_PoYYYY)	" y y y Pq2+p"Ĩ@t 
   XPJXSP t+. s#. sXP&  `UX[fW<t+VW̑ 1!0 u>
rrw`Ua `UB a p 0`c:0SQVfakpfU
PP73Щ賑 b^Y[Gu(P1$RFP f&| ^	u?<Vf'Bo  uRpLP	r=^puS@]#^[饎u"
 Y ^~.t Ujw``V	 cL
B@8.
u&* ` uf_qV ! &=Ut<f MPTh^ &Ep` `&ufރf&&   \ SUh &]S/^  y]_&uD0D>V& frAL
^?r@fWދD߂V@ݾ &B󤠹`t@ 2 ʃŃ^0 ݤP P&t_ ߃'fyBȃ'+aޡf;MEg   
ށWf.K		ZpG_E!#3<crR-uf&T
f.	Nqf tf` ]StQY n *fp,  !fЕ+# ,i;!p$U
UEG &E"rri`aÑ 'rnOGw|P_@1c`}E`1#  @2a<t/fQ Y<pD%p
fuސ f@ ҁ`߰?؇3.v.M"fNf.	gO
w -
"E|"
#:բP9DQ:@: ;A
;Q.:r](G)uP)D > )uf.	p 
- =*VQR$$D
@V&T<^30Dory9
lY^C܇0 ~u0x0"VBqEv fw7f(A$D(8PsVPWSPWQN PЫP@EDLA2ra
fNt^Qؾw2KWM T;PfP: M^_1PTN?:ffWfQQtT=D M
Pe@UBLBLlBRL3S Gޟ^WX!W:XX1GWiG@>(WLWW-HP&0P	3

uO`gdOp%Obboؾ:!Q	TQb`#SSzhS3Rq	)AUEfdCf`e_W3na `{Dku_qnhQhhRVhh/hذmQ􍧶`$j
j|t= 6YXj,{Am
1$pf[ jPQRG B㡀uZ ףֺ% F uש@URfQ`vQ ufu(fQ2=fA<t1 @Q !ϱ n r.V sfYZ]paTf;fRf¿f;fZ`Wf!тrfrf+pzZ#r
Pr#|s
ua

<Rf GM	rrBaPXPQr Pp>$Ss[OVBMIϜEƺ{/ўJOQP fÐ1oXE~t ft/+fP##fSff3ۿ< tfQۺq2"ZfEYjpѦUYat?$7 
3#tcQ!@0
-@!ľ!WV@ fSP~WB QKY_W
t^9lEst6]V! <5u G	F^B^= ~`s.
<5 = 
u>叟r aϊX2P`X^2Y!WfVߊf^t
P Er& PuȐB ճ `ނô P5NtNXs ##A$ؑ$y$Pّ)
u $ʑ SWp~_fD[t t
) R!aW
 r e$
Ǌgw O D$z 8$=r&'7\%p tS0	 ?Y{+ oQ3-3ð&{
tF!tt	*tEP蛐Q蔐S&w"
ǆ~[茐c <t<!t
<	<*UcR`	`p
!PaZQR\ݿs	8
ZY R<;VP֎ލvS<û	 [rAtX2wpJ^ ðU!"@ r-1`@ u؃ tr
D@E2 r0Ob3N|
u|	 t0  $w<<qw<
^q!" ؊2% Ű t؋ *ZP^u ۊ@EqYXQQVWP 
N X_^YaQN@^P2bR@{ UB2>0ʁCqao
P'6#fp1пðW"82	R7 B-}S-ðT".Uՠ Y<@Z<.չYk	U>Pk2ÕJ  J %K R =R X@XPX dU	 Y
 X /X@1A@ׅXCVUQ XR  S XT  U V WUXYAZ[\1]^_  f` fa gb ugc gd!eqf R__w_^t^^_^}Pe_$u2u\@ ء S3ێۻr?4[UX Vy(X(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t pWu v5u t
&  `
x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ Xu2Gôr2հѾj轈r9_2.1j ukq G$!u@t0<zw, F 
t
P@
	{t
w
 kjb2]{jISJ, E ?sG@2q)P
 t"< tor0r}	
2vPQds	} U	fEQ HP   PRuaa@uXXZXp! . KWPXŻ Ü= sr_s
0PSpc{ _ ߸^ZY[XSQwt.辉 ! !$ OY 0SQ u|PjQb;ˁPQN 3۸ K  oY'  A G y   y " ËEu t
$trhu`tW  Pd_ta(    K P3Xú0fW%,_  .s 8 0ff#ffg&'f  ^ 	_ fGRffZX`Pst'<t#o<tNc T M_ H<u 5  %l  
 aS  (#[0&VW3x7u@ G	u1@  (s%WV 10 Sa |X#^_S/S$	ppquK|A H $tuw0Ȱ2$r@  ~D	0hh
BrB<|CCpCCmmt@02QGoYYYY%17   6  G F "6! ,@mb nf`g$/u ($
茰ô$蘰xfaVМt
t$tº^pKf` u'= A! $q1$faM`P
Xu!P݄<Xu @PЁtN҄a`
  P@a  fV Pބu||t P3N@f6 V|u^ u|u?[|@׿N`R\ Sh|tE }u&||u2|t!j|vi
ep 
]]f^eU  	      _ pV  G$ $  GN N P P  Gwh h"Gt1$    Z   
G   =$W    0    %&^r 4钄Er]                                                                     DS A  h  0O IYOO bvPtF X .	˸ f&q && "  иf3 ff  f._f.]p >` 6ma  !ŀ.P f.""""" ! a
#
Ƚ 
 f3ۻgf+Сݻ fPs_ fX   }l f@f=  u0p fl >@  t@&?   `%Tp| u!uOǿ<2{f]
 N] d `5dPQ3 27y4rdr
` r`f  WVo.GF^_rس׺s;rD.\RǊAZ!R o̱ऋR źZR  2Boi|R8AS؀u
RNRp	PXE%
cE%~cX< $=ZT
 !
#~
t`VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
2    _^a2
u[rVeisCr"tr?S '?;Wr6"Qr
Er ޥ)ܠ߫e  
 `     tK\	\*P')0\;#$ rIW("  kV_!P(B O่5B< t谤0@@r}4;3r!-q ,-BF3ɰDe@DPDȳʠDGNADjQPʂ ~<蓰< l<0c<%Z<	P;Q<
QH<pi?< 6<
ϕ-P= uX<<p<p XL]WfPCI 2du_fQf7fSt$fѻ"r   f;р:tN紃 f[_^fZfYff r } fu
N`ou A s r 2fSRfP`cfXZf[A^uc_Vcff\_5cF_c5	bff s"s t s0+  QVW&= & s fPf&Ef XW ?` _^ bTPw W`;t
X2 *W 
_ ϰ#tԿ_X S`~HsRQ8buf   fPffyff P8s2fYZÐ"* UӞ.:f tdu.V.f]gu
#p dƉPfdfBd߉3!+%dMd5g}d@ J V1dP <d;]t@3td|d]^  R 3
' ' FǠ  F/3 .;v+GuBG
`F/ {@ Ë% O	pXvNuQ
 	0uʕ 갔NY%'
r0123456789ABCDEFS`׆[qPfPS^ۋ^&t` $ueG&uFtt[fX]逳' ?~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8Mx
~~p Q pp		 0``0@$ff$T0xx00 0 lll2ll  l 0|x0f 8l8vv ``0`_``0 @  ހ<<f0 0  || 0p0  x8`̃ <l 8`p  x@ O|pH `a@
 
|x  ff|ff ll bhxhb `f> @py x p
pflxlf bf  ΀ 8l/l8` xxp$ x0  Px ƌ2 xp``x  xa"x -0ax|k`` p 8l`0
Pv!o`lvf0 ox  `9b  p  !4 vf' 0|004-p!)*`2
6 	p&0d 0000a1B  0 v
!/ uf SvN .߿2[]`g i &  _
$nd@að
`
R3҄u  `Za ThAE eMA9Y.SnSS<  Ac( i
`3ҴqĀu N <tDZQY
 Ir8r502:6 v& aϳ P P2X 01 ISAF#+T DD03COMPAQ 09/16/05  =     F10_  m؎h Ћ㿂_h+3f  n L!$F10fPfSfQfRfVfWUfUCES>bc  fB  fBdVc   tVc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  AfBdfe	 3ua 6 e< tf3
@Od>S e  pd Pg>pd;e `oef3A3@!t
    2 1@b@Pa@f00tf pߨ tQEpYV ^ `]f_f^fZfYf[fXfVP3>f t
	RC 7su!&ffXf^PVW 3W P__t
r
>Jd_^X \ޯ۾اбκܭ-.DD(|1 8     60  ``#8~ _"!AS9>9;  : ]@'Ya; n @<@?=@ 8&s@$	=A	I!!
0T!Ae>q

( )))**L{LHcF$$
G~B ~B
y$$$@ $
  >""ZFYdfd  #<r N` ~hxF"'yPGR<TS!2

	" g %8 0 p$X	

$$D81 [I 
!0e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeւ\fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗphdo@\Lu͍폜}JT|FؖcInI`Fڏ׌Os\gpjځBȉymGłrݏOKvxmȂ튮xtԍÃ_FsʌxƂ쐬݉}֎~HS\zԕzfmQ{Vvdǂь`YilWǉENԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb]{# - |@  S   0 ` R 	i D  Q @' 'TD ?g@dC" 
 P '1!!#"?& p㚔
~|u  0
Fq~% p? o  !  % )  f"	! ( 02 RES   `00m) BFLXp0t   dEg!<"F 8 mY.$`"08D(#d$A|   UP W F  >"6>px-@  ?~!BC ""!B'  /!B#b&2 //`   a &2$-aLX'>9p1@@@a!!: ' ( <'Bft,0<<` *0?`  ?<t2pC DBg ? @
Ձ0?0 H$@"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@߀ `: 	4H 8	  6 a@)1ppp" `$!3p HBQ0@S` P0ZT@L@\D2"##(RUY@>B&Z" Nk=bN\@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK~` x d $+Ph` @@` 0!ߘcc1 $2&f# ~`\0;@lxxpa1 
c
AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- : b05 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?||e0v0 a"s 6`S!cS,t. T8$9`0pGy 4g @ dt>$B<'_ @}""" c px% z`vdnIi&0WP?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@`Z F0Vpq 0uat`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\?2b" '?1`		
	`21"`n{9$i?$	$	`  >"33ak' l?HzM8<@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## <DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} ?8F `8R)C)E+D:<  = ~P<  b <$  '~  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@ƀy9@0ya؈ ¿ `%,#?% p $'!G@x pǌwc 1$&? l@ 2?$?$?b < @$<b =$! <`0b64~
w*  hH"e g * ~  <@ D=a<$" AL`5' 'p-恴pp^c  ) 
8qhRF pà2q2DRD" T@""z"> ""sbn0 CF`  ||~ ނIⰟE`<aBzd, %}IHT! G㡬aE@AjD0p 
 .:23V!&    _B`5I@  `2"R`   @4!  0`'>|Cd p5D ƃ( H H  0
DP6Oe  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'v?e 8+"@P,  b
WBF0L 02?$&""  0p	{ x 	#`4 c$}R S SPpP t!
(#?@@DDD@"D0!sc 7E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@CQnx<0	`Z ΀7( (`2)v&^?0JbW8l>/&23
b21#n0  !߄$ #L`,!3p$?Aq%$"h| "  1 o A  }    & <"rV&#0 I  81? c QQR?0S"PC 8`A a ˀ4 usn# 8 ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒx)jP|D52D"DvDTDD?6 # a|ḅ,w  1p#\  7ajė=  4a8	 ? 6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP< 1 WpxPX	 ^x! 3"&,0@JD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"gpa&b F ł(x 9%`'6U0` |. `094H~ ַ 	 d~@*H  ~ƟK6cNCc48x F?~!BC  #" e `QP060o!  8!` "***" /"$'$&*"$"? CJ?0``]0?~$BdB  a B
BB~15,"&D$(-jyB ,!.8	,HO
 =I H<H$H$I$=5@ @v 4R$ze bUS R P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z~  $D$= *XGJA\! /2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H"	TTWD? ?^ pw 0,0  ""bp $ & "  q?2@G
i-_ nF :@e$ a  @
#]](00]V?$P?			?R" N8S8
s
 ek| 0@	! y 	 	 ! o>_""	& ">fCv,`D= D~ = y , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT Cv
$g>?  '$!$34?, g A#A <8`hO `&#f!b6@2~Z*\*jI0/ Bn5	G x RRptF H0	  N  	  a |l$# '!b[aa^ap 2zasR0A: <  B F>lxPXHL0F`Cu@;0}` 200b64~
**hH$lH UIHUH~HHQHU~{HA6  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"B`7 `C  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xoz    Vj_@` <1p0?3?S"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(0evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)g$ -PQ@ 2!;VR!q # ~ j   "?**~*B  h b~B$fiBFD?0@ @`@.ADY`M`~  I2R2RR 0Bb.	4d0.t }""p bB o?~b
(LA%LɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tmdax{R4䣄	(	)	) ( )H	p ^c 5] 1 axA#?~"! "2&4?60ba0`"` @"{$D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?#.a ee   	 `p13"fd Bi|"@Acp>@$	,	(	88(?2l"FfÅV@@9`'$pzBp03
D(z
[
@ 
{t~<$4 7 a  p }#@B"4&0PPP``? ) )?)  ?2"/y1cI{P?pP	|?@   t   uUp cu`  `	 `0 ..1S.1lp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV^Zu
`R\ts 2ƃǡ G׿
a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>1u_ . 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && Z[X ` Op@p
oo.61FʑF!.WtOBT_G-p
QR.61ʊƳP ZY[X  "2价S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!a01.>1P20X2$CFAPQR]W ((_ZYX. 2.9 t.1BA	#+D<u<RaNw<P<S߰<0{<<<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1pǣ`X@Y 0..1.10;Pp2  X:XUFN
ȋNu	F] S f{
 [ SVF
u038ȿ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjFT_c&  hE膪k>NRIW02o1c% = ۘ
zb	?g	@v	A#U2$s
|
JAfafffWNccm_	f>JdQ3jut$Q13`	
	c		A	
辪aUf	ZD@x"UE
e2C
T5;
Hx
R'r
SF "֤+UQcېB (b,1-,gPUis0|0E~}"^Uy$=
z&U&x6(:X:܌:ު{
,h{ B7c*ct;j9@@W@wBBL?Z
bcjQB_d$7&:!_fh  nE+ tBt>Cdt	fh jnCd$3R
CdtfKhaLBKQ >tSet3 tE>p:jhdfjhI>" <%j h]"P1t2>e tefh11>f t+Mf *$Qf3f
ɍ~f PFPh9Zh*gn" ]Qh!3F``Hՠ2=#~2hdgh dxod V05&	h&fƀSBWFGg
ga1	uA+c-McȱBBhbFP7t@ qjh! W
	`#8fhafB(4YI}P5
#hclWc(
OY0 1%h01!4 VEå*hWmhSO	PkJD	q<^_ 2FFf^ F&<
uI) u&*V_&8ftFFP9 1FOuыٹ F FIuwF*1 F*+҉FVrg+;u;uàsg% ;Fu	;V@árogG2@UtA99vg% 
wwL*	v
 WP
 Ffj h pSC[(-{ f f0rg0g!* &a&cjLfPt~nP[j`PQ^1j FP`c6F*"aP¦\qV=ut_ wV!  )#GF|W 02|i[a h &z F GP	Y	FN_uFG0?67 

zyO,HF eAAy)wF2 1p ay1U>yWIbf?r?T3@6#B"a~r	v	$
Pʊ2&c% 5oBF nu _c 769Λxq/&c533ȉ	c耢AB`R1	2&a% +1a1 bj_R3p%k	2c%  nc1jAQ 	a9F`h~0n3 d /djD
pUEQ
W

CQ1( @	H  	NTD*g31Y jiس*X4*jSi
 UIz@(d #+&d_dRXxs/t5  f$F
@2_Ft@#t#y2@zX)& d{R0#2Bn
*S dcjTE`*EdX_&@ d0wv
; >0TnC!OaEZ_& &O g[ Ax 8
FdVQW ⢸A
a 藿fJdx Ld kt}qJRX@LACC b![!Ѝ^PѭFrg^F  ^F&F~
r!
le?&be &` ߃&d^g@ f@ "od@ Be @ e# reʧ
/Q|@ ^`E  p  Vߋ60^aF@tp-t``d Z.tT.uN&lebe _e 209ʀt"Pt ߑ`fA V
U+%*e@B8
	*	!A Qt:8O
duUa+젆2@\__&p2^  e`!PgbOd !r΀&Bdbc/o6wtD @9".DSF20 @  &Cdw.j `j ΂ 3
vB +#r]𓅍FPX
-d_B&*g(&Jg &*g15&+ +&,C!&-.&w*gd rP<ehJgj0:~MB>cZxJ@>e&eFVDfAcWhja&fld	s$npa rjtc;?rvА)1ue CeSF#@tJy#Zj)$	c>jgZ	 e$ < u] @<@/"]"r˸ 1 e`{Zb螩'P94v14ax48fS(v]8fa2^ 3  K
t%r ڋF^Nr'~#tp  u^    % F+ )mA^  ~u +ËF{VVF6Ƃ6~ r~t` t uF0捆pfv
0V32,{pIuquSI]][t

 ^^pM~  f# F B F~P|v^ KF ׉NFFV~ @Ht@HtcH P )7nA-g0$6^F&? u/|cvA8[>d|mhcΐ2˒acV;3ncv`fncm`
NNF -ev膑$F8gFFPjRsg_S^/GFPv4FgFmP?cb7PQd?:!Zfz_&@0c16`b`~2|FtFr(QWw^
4~`4	b-2 _`-n+FV_FQC94%~ t;F4F0 
z u WV~vNO^?>S
A0@
^_C
"j(c
l

[t ,md(|WV?vԋNsO4DRHAA~(|W~FIt_~w@u"2F#}HFB^F&W} T
 
.rAPU!u@## KVDiaL
%%		 	FW*Pg	}`	
g<d-UWVv}<t~P F
&GFq&'h*V~ʋv!^PFGIub: ^&^&8t #^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ NFN+;u0g03FppAFC&PfSp@ ~0gЋswG^AaQFp ~
v)Ђ@x|r
CVߋV,GV~^&FIa&a8Q諈FBQ2c%0cj!>r⻐UIBkbf?N3a3#1!
= r	Հv	$"
a]2 % 592
oPPV_Y#_j`R#	2&a% XRo!2c% Rc1cjARQOp 	aRM/! (!Q023ddjD"۰E
*	C
*@Hp*

Ns#ST
	 U4	@g
31ܠ jiQT,pyXr~yz{	@	x	[	&% *{5ch *# '&dc"f1f   df	 &f h g fcm؃020`ј  ccFr83d  VJG@-zSFRBc 1hS#ݺ)BZ3~Q wL Ièޠ> j6hFNjFcU S.eu>u bIc?@Β#c,V W2$+|9_cBoV3E:
}j`faf	ff׃"fcPXaA@@XSA \Ra$jEbDxUE$
bC4
?
ai=2
H"_ N$UaڿcB %ςS|pF "4gPLip+t2~0PX	Lݗc*L<x6s64F`5tұ `@j_h!Bp_AؾpNWVv̋ދ~ &F<t<
br4F*;b}7!y~tF&8tFu|t<r2簵V0^u	A(|wÐҿ ~Pfh#  "0F;rF} f?* F  F*N*ȁ vFP0 v L
u+f^?F л FOupy	~ff &fvcthfq0  2 &sg{22`% u"rg$<P2rg%Rrg1tgu8tq= +ɉN3rg33 Љ  auvg$<u~vg% bPu&w
u]f2 % D0	u 
uyB
 )g
u/Au#a!vx}g%FO2 fff ff	fff
fffffffXMpɶ f3 f ̨9_ujvRPpm- _F±Bİ~2|`ڸ1~@F  p ~ uFdpm
 &f jgtAV_FR_vKAwF@ b*J*p
NvQFWV迡oFFP
|F؊fٳ-ؾh ~
'F܊fݘ F֊ft@ t؉FjvvQkh d-~St` suPk0M2mu@hMh{ @h vFފfPQrFf6 juct:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹp^؊TFB  UN2 OP NXb<t Y^@`*PO1aPj?+*
- ek)@pk  NV$^@P|"`(`  `<1`劆2Bd$0   PyQ$mj)1afu 
C8@eQ@rgЎ zf@׉)1"*- t*-} t94г!13t$RFar OEIOboLMF m0#"7g
1-(`  GEBw] 3 3|
/f.' /PRqz*6pBd* qa"{$2x%crgب oa@a1jLFPj)"#2#"#AD/]PDE@WV3 WD>^&@RFG߃|吐3x6 2= R& FW&`I rQ7<"RMW>Jd߸ dbab6  &=  C_  Ft  
@*"f#-P//

	
`u	( MĴ &&TЫUV~S~ t'jF I  t/ ?u#'jiyq t= tA:?`>u
le&e"be2e% e  t&le01`uP Ð fNdf0megЕepeee~gdaaaWHdU۫d>u[h hJzh Zzp:r@juB^zh[WNA4R 	'"		h

 
A՗	 	$ 	̢	r	IB		a|_F&? t5 (u%&|Rup )u&DPƋV@0`FFb@c֐fjfh 
 fhw `  	     &Eq~  A u 0π&c E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  {-P Q   8>ۋ  &9w&EU 6`  VVހ 6Dˠ   9~ H Ő ;p! 
fܱ
0>~ Kހv&@_u?PM^;  vĴ 3fjth  <nЊp _` "g pvV>B  } vVP*rF/^ ɀCP% 
P h
 h  RaNF
+F@0F!vvo} 	F_NQF@ hbj a^CFPNQ=`?*P!ȑ`VW  p 3_^e #_  @SᄊF 
FBF.
%
;F|!% F@P!]<!Vv m{`NPy`rFD/t&@A0#FlAQǀu<  t (F7 PF@V5
  f#ʹ8؉& * yBఊ|ub~v*VA MƐ2xƊ*} ufU  Vn']'ᚃ> t`ur3NFّ\ |]NZ&8tG[ vNߋً! ؉^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋߊ@!A~;wⰀ>
 u~31&A *;t{r1A 
*_F0D0?F
tҕ t" `fop 
V=uO`2P.B@>?Vu	.USEHDaS!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uۋ31~^
AwF9G
uɋN3~(~ ޞu j  F;|Ԁ;pUD  ߸fUVNVv<%tF` u DD^ù
0NÈ u0+b1WQPWVFM3^tQrJ;v~ F^F&_uF$=WR\qQb]R?}  P+΋э8sdvva!V0N&8 u{N = tp&@* 0At߱_m !
`f+KIQ@kqlCTN`_
ʐ kj }##v~_j&F3v~Bv0Q&ğ o0b;~ANuǋv| 0dFuA  
`eP0^V cPQ  F} ~ ~
~h3ҋ P{W t4~gPǰvd'Pq 	ptGW5o"p j_9Fu
q_sPK0 vv#5+PF7V 00NvD"F9F}+F- P@!b' ɒq YFF`%*" nT\QPEP)DPA EEP:P! fh p39> ~jy/0 *9>/u	A
@0
A/\&_76%'@2)
Ʒ
G;|2*& P苴 c`8(^F
A
j Qj V@VRP=^AQda*'P? p9<`Pn@]c E +F+FVa#
0UcShpbf 0aDPNodQ虡yQ	5Q`,+F+Ѡ`M*'2 RV 3Rg@D=PD=ӁF3@**A;?}Rvs`'V6ra=qyg*@F;vwPT4C
sR14+

uK#aQCPYedD&A84	PeVs輡V r!r~&-24hQRptYAS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;ƺ@Ɛ]q<vN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  Ϡf@`	PXhf@PwF^^UEAgTe`X2s|Pѹxb<FA@ŀ[0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4v/ .9~4aFO6,+F!}=pu.tpSq &OC@ +σQ._+ǀ
!0|ctj[|Qu

FDB.=Q /j]> Ln_W0L# ' ORCA& !!pa^2#$QBC}P ffpL@>ffj qWw 
Ht8-t-9t- 	t "fo 	`!QF~ tfFffF  F
Pj   v
u}i1Aj >PHPV`
Ϲ!&wc¯FtB$P
QиN	VV2ٓ~F
t!@D% QD
莡Q
VQ6 B tDu遌Ǡ
!_ط!bG C] `D]Pk*. H!MbB되9>u	 ]rH `OGg	R4O1miDu(+wHuu @uqt j	jfh	m	"	PV^FPqf~
 t

>taxQEPzU贝@ ]FY m DVVjvv{xX 6G ]3?툠PS002Pr~CwF0B@UPR1qE~
G jR[w807+$ }Ep  9]/t ##/E=/`J/FFP9 \ dpg
p; ;NNNQP @C7/ Ƒ= K = ;  -Pp---xАWp'WFj  ܩk >g`{ Pi?;v1!;vFPVW>FP~F~PG;~~P1% - D- *-^#- " e= Pk'-R
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< uN0빋v T`ߍ 3P Pp & !VN;
u逐xA^F;~m~aXS `
$~Du6?g b_;|qT/QN;v}wO;഼6V}Q9~ uFApL怰9v|GĀI0Đ0%9F| ~A^&+^& 'F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 Wrz/~IV>FWV  Gc e t_d@ @ l te
|tATD\m[u0Y_;F~ ZpӁrջN@uOp0
DK=ʃNp>d u)>&f tl>g tt >c t|d yh&b?:0 WhVp.u"jhbh_ݠ
j(hafh_=8 _ eh_hch_ ` `} `m#_a裚% afB"	^ 8f% es% cc%	`aS%
 cCz% c3#z+(`嚔+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hjh߰Нp;t1rt߀DiODpU_*䊇>AvuA*HWvAPVt0<@p& S}5544%65245r659h@E@ jpPVߋCpWVh
	 !V3j hD	~DXր`HtHt#h !  ޣ  C wt^{ f	$F HtHtHHt$" @ $Ѻ&&G<P jh	G+P舐X
ǯG>7x@n ^aGP0v&ƀ ~RwrjV6 fP)v3P Ы>X F`~|֢"v®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |ߊFÑ!	eM	L0#	Ka@c 	3$0(`(h''paߋ^p3&~/tC&  v&߀8 u*C;^|ckF^P9Pg`^? tvN~}"߉v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - zҮ<5 1 ;uJ< tCB޻tZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@_F	 0 % t" uNj phF  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|,Bdn
e6P $
P7ڋ P.PC 
Cc!
Bd$  *8fuOdwPg"^u Q/	tP3ׄ*`0F |n FPf@
t)f37fn @Hpfh j `vJ` 4$u @3~l3 ^1J`F*A;HtϠ5= t	Bd@ &Bd} ڑ.CdQu鉀&
:	@

 &
&
hȘhN
hɷ ?AA7B 
@
@ -*

@5wq&
 3F! "&Cd&Dd fiwf!B"  *`FP~H AKN
S3AJ$\'U"%jD:GBHFo*`^J EZj č&Íu,3F
46 x$dhpdj(j 9
P8
PPfsVS
bW&**`)@&J` j Bd t&<
 <#)뀖 _x
Q$ %'@q`
! OFh ej  %cbN0Tff3	諠&`%  Piр`RB/
?
$*H0/^$&40/04TRTR"3'`RVdsp%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-wMtr` MYnp= d.Ɯ{,2@0`  8&&`0'zuR!"Ր,W20`  0PXu/1V h"h/ ST  9YۂYݺYހ
Y&"0Zd 蜊a=	_[Q["
@4 |
U!@ &`Bd(`Dda0y@ Vfh0/h y PVc@t&
 
U@ UACCUC΁!#!
@Bd&`Dd(`{
Ɛ
r4(搐 + (#+-+tp*tcmKt
- 7tu] &3& tGv 1vhޞh
h P!wu
j8%AW&A
G-C@#'$'ޞa'a{ߐj3؁ ڰ @o&
)3bPf n
0>{+^>>G>d'>nu!>/>f'>< Ћ5Ph$pD D:E4(89JR4"" :L%9
GBδhh Vq2^Du+!{ 5 31;ut~&'`㑮S7AA@A@tR_!P!_!
@>`O? 6~`L.ࡠAL&(``~?<!Q("Q( Q(*|3ɻm &ArhgOE@zQp8n@	XrQUUtD3{,i
; YK`mrDFv!
oroVv0%@tx$P!.D$$`
*P#wB(f~x0%YAǁK=͠D=H=yM;Ա;
fhZ " [BGb %^
t
]
Vct,WW*@t*teq *`v`(@a@1)m@4AEƏmƏxCQ M# ғ,*$V $ Sǆ0@0Ep@
%U@$RU~22``ҟlB	{`012&vP
vB\ 5WP)	B0W
 05/8$  k 	 2FZhv?ʦ Hzb1p  A!ЗrWv`}bc뤁Xab 눋` 2 1 w릀5џr1p "(w+ ) ᠒ffc7cWfh  Q~
qKfcf0B&c"7..e86d69>>%A;F$F <NN`  ffAcu
σn7	u-du$uuu	V@ V ,ǈ_|rh=ܒCvCʋF8FPVh@`z@Pv
/WV# 
``HtHtt-L7+ C3!!"B@
?vתȑPQpg %';@EaG@`beTg;@6Di F

bG
,Af+fF@ ؀  FpFa^F6 FFUPTTXD>== 0 ƿ - -tR0   - -*t:- ؽ {=@+-AD  -j  t}1x$Ht/Ht:HC 6 ޢ c(`= `E!@"!13 R7" (A
Fy
t)j ЃUPTPfsV ptt0? ;PVa&M"[!Fp *HFM~* f` fFV0vfvvFPvސ5F0u63F@,~%v슅Va _:uFG;ǏF :!e~ t
&x~`xP ~@W&p! U p!qq t&AÃ@`ό?"Ht)3Ã?@ p2b~̀&X q휐V>` u#uHj 
&3v0 Rpew`fbf``f `  a6 9FhDb R
`eV3 b8-9t- 	t B-`2
  *Xfjj a
5	0?u.#JN{uh 0Ɛ>a tuVľfh  P諹	-NRc>` tz`6
Mh45{쐟hlB653ada& `` F |b ra0մScA >p#u>6p\t&el6`蹽 +륃hnP`te3fa13
>*u	>֮ 0!jj2F3tׄ;3Be'kJ t'{~80:2GR%4;44Z
`bPh j p?p@!F1@[$ژ
mu$d4D*tS?*=<=5
5
w`Kh@a	@Ba	P fh+rD-qbp`$ސ$#;$ %/0`adbada}" fae Pbr ) d%  = $Kef1 L"6B2 )Rb
b
c
aޖ2ؒ
 }g-
g
 

 Gwg٢A]d Dt,-
t%-.t,-	 tE-
tYt~- t/0C Dˣ`:B~B _p}}  9oU&Vetleug& rߩetu
0te@ʪ  - ɾ@ut ;>}`  Pr%hrjtXя60cHtHt `t' Q hKu
^_ pWV3ɀ> N3һBrZґ@FPWp~j0r{躐
NpDt  & ھQ FV^tF&ud,,,,,,),p+,,.\>uh hmh h 
 jh~
pc/"@tî) 3҉65P@;@)}F~
r݋F 
hns΢	
J{y
Zj 5#W<B6wf
 ~Ĳff v3Nv~FV
tut9v~O|܉~*Pӈfha^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év 9t
G;|FCFvBF  ы3$uG

41t%I6%|bpftafff3Q&X'  
tat&
S
 P50t5	s`p` ^3

tF^&F!u	 z|03$ F#@
pEP2Da
nGW^rF*W+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.NhvY/ /  p- 2&ua% +11vao tata@ 3 ֐j5B jh
@}SE
 C
@
B@
/ /  (YP)@ wj}Q'3
^'G`hߐrg5؎GS.aAcharg, taoa$ a
0ް&
c
Q 
@DMԯ
FW@f 
fhR0V" !gB
p,pfh*+`()&' $%h#w:0b\rd t
K d wfu
M0  O hE `F<tF _"h"BQyy_F ۄ-FC|ߊFàxaGկVA
G?xazaa!JE/PFdq`lDLH [f`OeO UK[1UR1D
B
HUT4Pyݐ
Ċ70SWBTaD

H
<UUF \XE\_Y	/0
ZRq
z2A `521ee
2ȨphhB j$R"&%l4b$e65nnDB
DFEpMT
R#R(-   30) +o1xTzaP*ettfr/. Ab,bfcfLbfbf-
^- "f
- K;t Z0gpieeBe`[8c[v&6FVf®w ;,2pxd ^ ab AB  !"  ?- 2&y kct d@T;ĀDۃ -X@h)#̉uI]C 늩w@sڀ#߀ Z+j5x x wdxJCrAzOF{_BA?a ң"TcEfcfxpdvpp@Wta axx` h&CAJDPUt &hDqώ&? t
&
@@S#U 

C	@

 V
  D?@c:Qy@t&fh~^д"u@n~fhh
54	b7tfh:"89/h7
 !t0  /0"v?=>ho<Pp	BэAh"dWVe$ < u?"@Aa@<@u* "@ut"AǷ;>P`  "2r, hh,}Q1݋66_a  iLue\ Dt,-
t%-.t,-	 tE-
tY- Hta- t/YC D0a:  ~
3 	}p  Րb:"%@'dF P=c = PHt
@q j  r j>@uf4;F~  0ӃrջN@uO2ph hpWVV`>Wp 
vrvɺüA
~Q &&bF&;` &dg8$KJCM&PG@T%V% _%T%.rhh(.$ 'Fc"a_& *䣂aPeA u$:ݵ,D7 h4thBhD9  t~@ zj` rp \P$
 jP,azp0u.&jrj`ޤ&z"qFB@0#00000000|!&BkVfvfhI
 蔇Mru mh DbF c:tF&<:u-FF
*0N&$x   
u3(ҀC7 ~ uF	 F
  
 
 <  C
v`
Wjq<T^oP蜢"
? =0
~ `~ tghv&~ tDO=趩=u5 x
`
 ^3 FPPP ӺpaFF9F{r 8% -
 ؋0v v sd u`= wːHnzˆ˒˪˶ˋ~?FP.acy ~ t 4Fa    R F  : {.E "  e
Qr~dzt'/ ƂOFZIZ#3^ \T1hVd.t}Cq u^ GCauK  K .g"Q
W#I Nr@~u_| W    I |@FB	FV!F^ =uFv2MN'22g+@]WV6iKhZhuy*y fyʤu}oyDtW4H-H4H}SHvUgHqy72yFIP9Az!"CLzDzߡza
"zj &z<f+fF@ z  ^yFV^KFP6b> Mv3+Q OY  l`- t$ fFf~ sA},GuhjܠdpfQVȡbڙRPSQfXfYf3fffPfv!fF fh  bUZ 1g Fvh |FQPmd PqUwTtЯ!TxaґyyE  p 4  V6rNq		% 6aD6f\ 6/f|<`y3
ޣ]0Ð3y`6  MHz` KBSIMPLO  MOTOROLA  HP  1.15!drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withouaving
o Securit@Administ or passworp5Cte a/"PoweOr-OnWGp DeviceHdeD(gbD$L $s mart Card%G
supportEmbedde&f
tadA!e'etr*Cac',p(s$`*authenticS+e
credal Auto2cH%To?ols Ba /0Calib( @(`'lectb HDD:lf-T2 op8s Activ zO Mem
WChep? r s: ll=mb  	>>uA@AdvancepaL`4uagaC lDt7  of grayq6field Boow1b..Pres=y keyH I ue F10=
, ESC=Cl  9RAcc{ep/=YesSNo D, Ajo$r=MN W  Us|Sarrow
 o highl@ *he appropriQmeOnu iYqKp"<ENTER> Xbegi)WK%#.followM%Z&:fpc->  KSPACE = NexBR3c-BACK@viop"Fg0hTABE3iSHIFT+0&*lF2@&10`
v[J #'9 Er This60cann)b`mU;d An e ocP^@ whs6c.pde 0x01 e@on dApGPu@p0{6Crequi@ yayE`d~6jba@%mu0C
movP:y e>4k/MEU)@hQ1& ilAl(//+2SDmcleOsu06ssfulManuZqr  Nt0
d:Prottyp@spyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}s"KeyboorFr06verADb1<ed2e3bg4`1qa<o;wnPhip<(TdG
W
O3O	*	Ĩtafdai5u%BSNZC*D$ 1$
2
3	ME
C

V@


4TV
o
D@o
So ྶ:з D.   i%FPA2d!J#biFaPWaMlRX0s&1&H} Addline4 A!lXn.%׽F$Warn:a rk Tpll0o  zsfTr-ea /vրM, lef e7a wabax002 A: 
de` wa
qt@tҰ_)V@u @rnInv ȍ肔P
)!	A>you sۑ {wa@|to  Т?m  aioa	  0o`b+-c(Quick`n22 [(Cvre@s3 (S.M.A.R.T.) 1EP1pexim@s ): 3A0¾# g¶30%v}} ty hao#0#upr4:1't4	f-UnknLkp{ilWR!mServRceaPS)doџ47`?a}ribp	:`exP9 'b`G H  Oylp New =Vfy nY7Enc8Off IO  ɥA L0a66#%AKroE   p dV
Ad1ݰU @ҭ5O<cpcaus7Ԁp@=AH"h` A&Opower-.AS΁Qa?U= loss  (dYAhcou  nlcof aQgoH04)ev`ۢ?[YDocHishR`e#d?!0f]Dddi1aly JJe HP`"UTool Cr.%oF8IL`ˣ Bk! g @7мn qHpm`@jtWASN !arv0	s /UcwcO֚P2"Onj* `e:Z%%% F@д%԰#Dn -f 0 TndĠfӰunuR?*z$n)tart8BQK`fra Par1yNsza $media2a D-  rw"`@zU 	1 	 aGbouasu{0hQ uX" bbUSERMAST yвVpanP:FPacSTkeep ia#Je7ph#yspE =phh!E 7mp0ar. I7?>Ä
,Pn!Q@SWun +AgGOxOAutoOQcEd0 0uHZ[6h60?#O Nk<
O[k {jaD,"`0ur@t\2th Q1psow k ꁶe"djPerpKFb oQaff+bdata,]ssibmma8!L0ligid!V IsXlrmmN @q} QUpu zl,`mrepla0\wsp ~p/*` By4zXr|P4,oHA= Wy@}'r5|@me`1r,@Mh`*pPpuibpty. IfdoBǄw8`ESCqt.!
 V rtyp'>'o F10"qbrm,b(yt+  AE$  MiBjQ  Or0s:U ay OX`2DCgDLb (left /hUSB t 1HQbSu K wZipoFir`ܢoPF th`ifp Sixa Rh ENPh ASwap Fn/Ctrls KU.S КP!slegac`kРQ>is`7)n0=r@riy V0o  d NTSC`AL6 -J -M눱rt@
BidpR EPP ECPd2size 32 MB 64a F@pAlwaynPPi0PAC gWLAN{ D RadiViBluet h /rS :chHA  Sg@2ƀ̡Nt E$ (%+n,2()P)+P z+f1Eb1n7)e 1҂23TokRHp
@kP	M3Uniqu/e Idf`&0e0   (tu@    S`KCalibP!6N sPP D KA.Xb 0BY H wO
ELi MEU k'g'MRoN/G/U[:1 :s C0@g . N% ] /C le2  yc 1`dik-d3	s
H

,
* A @5>M(o!ylsSp` @hnologygYadapAPXE ?RPL Exc"Popupz(`@0 10  U2@ 3 4 5 6@7F1=2z5 15`@ 3 "MnB `o_uchpaPuSNon`BIOS DMA nsfers <F1=Hilfe>P^id[inQւ\ Onz'eig fR0peicQv  -Kgu4aob9Vcwieа@z @nLv7einun	J-jkz
.A.ign epd*nt Pneh7/%Set@%SRheitsfunk %ntoa u
z@naDlt-KuO] Gertes/-C-ID@ FOt 7	U!sttz !Ԁpѕz#  beim st(
ng!@M@ r5nHsvorrq##7..zurckz9p
B .p,
f_g{ms>Ui0gExGAkkuk`eK tBsgewhl@DD-S/elbs`sôItivS9#LtIpr 3g d0: tppllTL
PZ`OS
@ PEryw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86,")e SePMbqTa@0, usm p_3fahBj=A, ESC=Abb!#`qWBkzeX!TJasN0\, Ja	=Meh`m VeZ
zpMark"`s@{!*!'oMenS% d?Pfeilt!
^dQgab	e2RmOq>ko?9 cs.	fcolj
Bn 
sg:-{> r LeGQ = Nch A\pd<-RBchritt-`VowA(Tabul!fs+ Holl2+gedx F2@
38@= {gy E3schlrL@iPK kan<~Lt we Y!eiffMgy16P=z`?rgetrPn.Dc  01 L@`fi6t B kqcQFY+<W\selomvoMrB]er0ilxXWqDeskUe-KsBhmu  f 3asbzw.2Mobih`bgptz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos`F-Mll ProzVyprtt` wig!6R0a"Ca`-i-Gre (L1/L2 kkapazit OMPum"F7amik Sp; umm Grafik-Rs@Q Bz]r-Con "
A  °a?7J	b31O 2O 3O 4dqV si0 H>(F  `	o	o
@o1
L
2a7SekrET*@L$ƍ%'$b-!3Kc(1  WalkAZeros-T<One) EdqA`PnO`+: bX7 stqbislwnKp  ZEucQN-/WB _leQb s Atei#CP0&IyLp`ak A:nfC6
lW$g	e`KR/+Pglp%ɏ̄5 L  	/  M<0$wirkQh" vQM?`3, daᱭ
l^ie0wQPocpFLˤ01 ( anH12 (UWmfafdIGc$fhrxdauP(Min.): 30ZБadS`@0% 0cgt59wuwm HoPuy p4%ubr`"w: ؑH	ԑUnbeaaMTHxC52'rvo-L5.
32@lhafAttribu0FIAD 2u"LS.M.A.R.T.˒XX.Ms K`kwp #eus~1L Dea  JaQ`eD/t Falgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  m	g1i@eFN*1sgd,E.@"< ttifiz eq s{0yrt.@s Zu1`0LzO 9p袓enlr@~.Ajb s0DQ!np'PlsAviceTa s ,ܠF0$0@ h`L$pga|F	 :	9 JZtfa@npW{Um Fun)<S7, m3e\Wn HP{tectToolsP=c^ty ManagпU!o-- jc}- k QuickLockSubndFr#q\M #"e$bi sϢnch?utz  f`_-?1dԨ@imd`& "+a A)N+ *W"$B>#, lp$meh 1A #I Nk>"o3f`ot-Parpen}ґ:-1a$P
mCD-ԏƘڅM#@Q:n@C38mĎ"rive(F0vpl!Q ;b=XځLs E-C?\s m pWبunbralb'ar.ēIT
:gd,rbew?E!s`Va2,0fp |b"Ea E'01.J, ҃08\',  02 QIj=n6QzւO @Begriff耤Ъd"kautomMRu @Q7V7;ohl;> A iIi { qt?^!Xʗf 
VA'!!b!amU"n# O`P o"epe )pYaf{#Oz`uA58ae<s2z:n@	S.)sa`uN(}Es  oh a@c%C Rp `˂r+`IqИ  6urn3wzhE q. Esdratempf`/	 d?1zuqO`Qdz.  A@ @@R7 .p`@r&ѽ2 ⲇ Q7 b-B n rap tAdant`Whٷj @QEsc-a&Llɠ>m kW!'p'p`\ F10  esh:
xfPg gCLcf sqD} mA@MM]uBay&m A΀)bBtg0k -ET`(?links)tUSB-b#-2؆Su 1ZipV 1 2@3U45 6@789 QFn/OStrg!PtbedEaCГ O(USAfG-ZePcB`iebss¦unabhng`  PInGrafik-Contr aPrwimSek%~ Video-qϧrntBidireal GrPu_s Lfa`i8CЯtzbB
d}r WLAN-GfӁBluetooth9IU!n/a EgpaAAggr _%7(&.(o"`)u -E`t 1p23,Y5ToRRa C:=A  q1tvH^Q1I0NkoF AkkuPN  `Pt   x a  Kalib 
 M`k`O  NƘiual_ !  O k   O  DO,rOTra-?6".  .O .L4obi!qp9 OO5"R!P	E gnOOf`.[цrІ 1 :. % ]l!abloz(2Entl ho3Pp1
m* 2
 GS-2'su' x`Radap̔0aBPmbzqA}ExpA-!-Popup{ ( .) W0edau Q0P]d2 (Z@Y  Ke`~BIOS-DMA7-Daāb`݀EaCompPropstn <F1=Hjlp>@Dvoply9s!Viscވne Gtil !konfP[Ge;ndfraM@z@PSrU
J gnor0ndr oP(fslur ѿ ub,t  gdBOtnek@+hed Administoradsko K atodA7 fo@r'W`hEd`je-iq		+	*
J	Sm -kwort	Godкodelsf 7do_!dbyggGOds -&2	 cNu@00fa@ksl2 U$c 0g
$s)9IkA\2HF%@Ba.HAX  b"d`valgte b&HDD-Oselvp^tPr Huko@QAq.inЀRaQҽh OGH omv	IBr/~ Avancq Sprog Vˑl1?s mo2nedtPt/ felOC4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=AnnuaFs!3={JaNej "΂J, AR=MGb Brug ps
NA`RP7xe  releP %menup(,1Wt<E?NTER> sqec>A)et.tafpr'f!f7: -> e!& MELLEMRUM = cNlA<-TILBAGErTAB&2$wKIFT+0+tF2@	:*@= Acce хh0!hk>{sfej 8A3!ku1i$0gs 2dodQ)!FF1ng. Fg01BRnoVD-p% qpla`9G!kwrv vek`EnJJ
i db!?sP fKlyMs`Èn#/MEUqoO5{ bp* uve=tzbrud2JI,nemfB J@`  Prc cor-typ hBigpH  ztr`7Crcache (L1/L2@HVROM-dౠ familie'␟i;AWdeo"#f0pd@s:@NXr-cs]D-ba si 9e2o`%3o&4Zƻaptg-ta`oejt1("Wat)	O3OW Ew @ex{%IsrP4E$C TyPyC%xy lydesq!Bmis 0'bĀvD1I'j4`eje wvar0: DB! se  alt@P2[holda p!o Pqt`/b BSb-Bddu4w5,pr PΉk
kEuGrBA:tTUETfDF%v`Ugyldig/
t-  ngivuİ,vi av٦,? i#K!?@ $1 (Hur P)% Omf`) sl(`{ }(): 30˔2j  `1x0% frpudZ44b2@DR  	cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae 7Fra@l !e@ +ń4PR@{	s0FC	 	ƈ4D
&KE  beviвB7 9!Cfdes, f.. <ramG261 PoRR.RVuAj@me+tabWata. Du bu$AM flAX:Ը> vicehCa D[G @ߒ[&?r !,ci HP tectToolo9"jK Quickpau`LsQmP Skrp!*0rKvt%#k0|qX)/sa1-|$$ Hvisat  `w@x6r,
div upbilށK2;+1ol p@frard )x Qlash-@$PR@Cd-rom- ЃV@ôB H)o4C:"eAaAuϱ6!hvb1,< D֑!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q0MU alug:Ks  n bf  ned op`JaP)edS t#
{	ND ll E_C0aQPhjlyp@futomok- d-
\BbygAXl_6b_/k per3ma`anQ#igw13n<l  fys. dsk6  4@nrbqpc(On O"l	
v  .dRCn0b  `u!dW"eLm/, soma Ưck@
tvt. U~u pA{`ppd/cĠ iko U` .Q  0сbef{alkraf ȓpya 'AQƠ@"pl '. paYu)v@
ؑ!  &cO.q#o"J"4,Q/0d iDHu AP̷0.؁.lR5:@ENstra!5ESC. řEn# orpy 'F':ge@F10FYMs@f
i/PD+cs  1Dk Osr=flgm vdRRenaHPskm DSp-bas Mult?iBay (K0 /$hjUSB-floppyEC|cc{R}wbsu SbAz;ipFr`aVTredj@Fj e SjSyRV O Ni @Ƀ Skimm Fn/Ctrl EZlPv(a`isk)!apegeUst蔙!
uPnPaq0#rm-c%r PrimV Sed V`o Out Para#  TzjStrCL|`ohuko B< t 6nr compu Q0PPǀtrm
gat WLAN-!sioBluet hK/A (trdllo|netrP1UAmstya׃&(x(top1*b*E;thqft 1Ki23KToJRaYHL	e+	 	Ent 5gt id-nuRaiH@  S`    Z 7ѿb/ >JKalibB' ndaigO x 9p6  @WNMH  KO OM2[bo   O O#0 OOOO$HAgs  1 1O O
1VSi mo`gPa(MEU)J= K=OOGOq OO OOO[ T~Pq 1 : O . `% ]T.gAmt
2 AfFH5L)O3@	Genos	
k

,C *   J/X4%G) g`hB0`At `r`bpopupsin}k(sek.! H025fQ-1@bgpP`pA BIOS ATA /DMA-r Konfigumas  <F1=Hjelp>ilxin\0jon@s Ps2{Laӌ#$k"Pv)Hepfra6#:0 dio	:Bkq)g a/vslu!A 
B,3lBDE;sprowgrat S{t pass2a/@&OptFA |U)yrsi!vsfunkur!`tifՃ%୹b-
<vn Sm`16@#godkjSq0!<`neby`5̨i%itpt5auTilbakeAl#3fab PPR g
i
 PE7;aN Urkty Ƽ avalg AlQDb5h 80vt Ak` 	MbT!#`]a @U3EG*
`Hpp!4vanprlg <6  Dem750bM @\dtJIel\3
.5E6o%<}5TrykkC taJqLL&i  a=, ESC=Avbry`acBAPpJaCNgei rP,  k<\Rer=M@jbb `kYnepGpilr@Ot<ENTER> {hv ddu ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NQ&86 <-T?ILBAKEwrigʶTAB&"HIFT+0+TF2@	)<P= Gof#l ~WsfUeF`  SPk'0`pZmnop@5 P M0|m kjoresve!@0m d;i pp 9!oba\Rafly@sbc^ 0d w}a`1A|r=vfull1z. kode 02Io"Produ _t Nopablokk-mll {typ h@iigv&-0ga zyv$buffN(L1/L2@Meng`	Q	enuV@wo-TjrtSroUSW,kobgRi,oK1 qi 23R4ȁ0,p( E@
,9(Q 0 
oa
oA
o,
NEk#!Iml`4$Eozc%Hq ok!i*ps(A"Wal~p9g 0s"-h1jH( Ad`ss e7"~e PnA9d 4~: DsA#. z tidlSCholp`@DTԢH[aQ "/he-  d, rnP}u1p sLkl<k`ƣnn2A:0۲O b@Ҽreg1"i%HUgyldig#DSR`͠	F
	#NEh0mtEb`?̀{]>F igno3t_ʗte?  HN 1 (R< nslXbP (): 30A3ggr 0$s0%[v\st!vhF_<f!_: Ka"qCut``U5$SQ&eGt To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CC # G#Npu  Bekreft[ njAv`l eP㰔1qr`Eّjvlikt aDu!0oC2Ѽ	aŤokag3ogs.rɐor dmpCel& Tp}?ّ.!rPa(A=pphk. `bku  amK#0vice.@0ulaB?eD(s aݢI 0"H i HP ptectTools3curity M[an0`r.'-`RN%l  ēlanppa0us L@$AOmpEr`i!gi$eu beska u"-U+/- +ӂWE%q  '. tgl`rh, v@=$ڀPŶG. K$RmEp! rfrarwd- Parll+vFPh.ielQrp2=   CD- %FtV2uu Ho $.:Be5C`E}hpvalgtPuh hh"4@bBRUKERHOVED-T6 CJ Rzumu0B@EQ
 n00^*REDbe!1L PP
0P  w@"!2 Va" #
6S,AS[P= 	"s 6*pp   tJ@IOM @ automPZpD!xLock	4dbygg[)c1a  @^maPqi[lg ^ge0.S k_[h fysAad $0@GnrW m #>	}v!n:gne1^PVsQs tѻdda gp ~u%y. UXh omd@O 1}0/e XG)0{nq
` uQbVnbefau  31G	A}q.1A=x A0k1E5Г  fiP_! R!'Y~I7MTאs x-QVwflans N@PBv
,2<˰ESC-zL Ϣ`sb'fD'J FC10$ZCb#e:hf$ nvd  Nor iiFGO%re  MultiBayPG]z "Qt'n(ve!e)pPko.ngsbahh9yOBUSBA|w Zikp-U
A A0AaFn/Ctrle E|AVd(USA)>GekeenAela	rjZtroA2deo@!"pTisrr`2FViA7tiࣀ00mFgradi/@trdl |t
WLAN) OFBluetooth /-fPbftQ`mbQӅ Ags9s`B	styQ'1_"&2o!O (v"*b/x!1 Eth P8?	)	J3 R@@NsA'ooo/
8ni> gtiGfikOC&\=B6CriQG Ht@С    3ymbo KalibPaK B!es- IA09p|@<Dual ,-N	O	I	O	 O	51O	O	O	O	8ksp. _O	O	O	`lnd 4oO	 O	
%O	O	_Cs? mob. ^
 H.\L.\O	 !zo
{8{O	B.[ TAO/: La. % ]!fullC2Fa{@i3
"Qin/h* Oy  (o J/D 
irpk)mA sin hurtig (sekuPrF1#2- f1.Sepute P pBIO?S DMA-rސConfiguracie la Com adora <F1=Ayuda>rchivom%l Sma QGuؐAisco flexi`cۻ %Ra (svaloj1pqfdo@ bpa y Ignambios y lia A{  g3 'LnzepidadAse
  ' Ajiciof%Oposis_
SITc)$ + ՚ *vKskSm>CN0 Soe*cP#<) Sectyingcor % E 0e" 30/c XP>6f'brI
a`DPVc!3nci])AutomaHerra+mia C~H er 8`#P(8  ;prueba HDDKc 'EOGVp&MemoriIa2a d*mp.l1@JNKRMu0GbSG#
~s
 AvanzX ESvVDD
W? Fampvr)co0N gr<1o?)<UOprim'quitec0g2)Pbao=, ESC=Ca06la==Acepv=SšSNK1"Y, Co2	=M4y p U@{Bؒ$dchDhal6al~  alemo apOropiu=@[*<INTRO> z qx:N.1n.Fs{3PpkTY :Esp~o o -> = PrxcRetro7ces<-{p0`@axTAB S	S'@Mays+#C(/cF2!-910`rƠ"b"uErr 06F  No@8 AiWGSr`jo u@QRA6K. Cdp`0}1Bhay n cunw>эqubR"nY2@AC1+>bѪr(R[co rUD)JНebook/MEU?IX1 QP\2O`0ple0Vxito{sa4e Fak T1ytil TisOp7,UVclGpuWXTamauZ_0h (L1/L2Oc FAAROM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/#j1$l2n3p4 Etiqu
rAsI2VeFK (ga Woo.o3oopoiF B	Esn!*J8T 5:Z$  ProbUS%bs>sfactcXpJ$ǔ =ll4Reo 0poX@1'	l7nedi$l@@z,
(CE| ojD"F%Ad  :vH ouir  eap. PFreP#/, WcqscpY#auA!:'p, Uu c  lQas ' Ӣ,hp9tegAң
S8^@vlQI$\e'vaPa)00٠o(a)  8!@%c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Cwlcuvtieœej 2( s): 300go B0%&~Db EaH0 _`ipal:Girumq
l : s,pu 10 qIQ{`3nh7Se/rvof 44apoya atrib0: IDp#@ex0s G
X0YA`seaـKHnuevL@)Df_ ApagE ndq9S@gOB".X		@e voc"	k"alpa 
0 Lstnad ;` fRn"]e#՘9 A*# @\A<Q,0 (02o,v@A`Ơbs @(R6% E  WciR|LLB hfrpinRN3 SBf_ olı9al ol`X#A!vu	jvip.Ao8Q  '{Ùv?%(֠WRapaAuydAn14n HPct/Tool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S  6""t mej`eO@`@?:0d++-y	(BI	( !)(rALlRt0,"D,0X৵&upizQ,.`xHOre PunP+rojo%q>lWS9MLm+edufh zBaCD-q(E@喁&XPk:	Z@Us0io5:OpuT=s PP  !rrive(Rl! t@ab|USUARIOJ PRINCIPAL0 Q@lo@圠dtVKman`V p Py. An[4 y gu᠀$@lugpП  `Aj7a{P..'tJ @d] "YIeGӁ1
c@bU=Z`>& BQ3
"mc8K)81FPor/A:
; ;QDrkR ϐu@u  , fsm1$2 ARirP
oc,#I"oi  /#_z"<Y q0u SϠd/a4|sRcubMb TtBB! ? |pdah !$kos gѰ6Se xo1enf 8d2`licQ!"6reAaza3. O?k Pu `#PZRS04=Tin!~k k0T1B¸fiup8Z!`
s|i@pons2> XY_, iR ESC.  ձalabp'Fd' 9 ,F10!":ҽxfGaG7T/Espaol O@rStMultiBaNPa DiPsi໤3-p ;]ӟfbP"co+(iz(@jeCch-5 cB b a1Ї&SuwkrdgZipcpmeaeTer Jo C`5t#0 x SOvf NoD Cus Fn/`T@ncIngls (EE.UU.)sbp¤ (ppmplSo}"le$b
er10nt!Ac@ Gΰeo Mod0z"y!?  BidiƃO Tam&CmpIȘ!i#	si0߰fu0{ bB߳ICARPQ׀k*WLANy{-Bluetooth IA1 zQy1yQ hoPergRsCpoos3B_-F8(s)ior)Et}het, N0boo S I1/,2/L3/.TokR@b OOPr23 IPtif ExcGlus`pᑅAJ a@4`  !,a*EC~d`*-NXS#ӏoATr)3Vh !,o	o	k	o	h	s0bhn	@o	o	eh ao	o	 o	ao	o	%MEU  6}o	.o	o	o	o	Ubo	o	o	o	B8[ 1[ :rg. c% ] /{$Am2 c4Ќ-Cle̄3	0k",'* r 9ODJ)o!Ѥoh ~aБAbblR⑄ @zArran@p@ٓe#uXDİ0gEx !`F12QTAmbTouchPad`uo N`uTsсr DQ DM=ADBIOScaưub  <F1=Ajuda>rInfoʇsobo Sf E@Ј?4؁m0!Dbв$ОR!0
r t7padr0
3t  Ign`airP@A	sPs '&_A1nanL6a POaDr%& _`#ƕ b!X_d#!Pv

SPtUd!ނх:liz/p@̉O
(I  0!ևs@/R Q*Ag%Ѡbr
a#ut<n 4dcЮeal0hAlo`Oca (SFeQMmPasg1=iCP8$!leROpT`HDD Af1)r  VR#Le Mem @A<< 4tatu UQMuY`G]8⫨ Av8S%,io Qa`xd; camppJcinz"o?CA9 Pdse qnr ycк't'inui=' oSC=CelAce imNK!S, Q%ou=Maimg Uti0: sC	qqp'	yda o i ? aprop@y *u@Tv#<ENTER> t5meRez[@o.LTgut9 ^r ub:  ->
PAO = PrxiK\<-QBACMKCExaQE06TABo$SHIFT+C%* F2 	*:`=kSC# 9nErrrOA@Q@na0WoQp܃mRHE. CdigTGo 01  NPhG`,@ao `+)  s@ viKCA A	bMev
;ÔZWotebook/C[(RWS mGsTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/L2૦FX a` ROM FamlY  N 3sri
Revi=sSvde@Π_aJroQLa 
Al!D	Ob a(i34`Rti
ep	JIO!eu6(]){ 7on) oo.Oo$alS~ƕS?ecunda'$ 1rcC% vfoi
"gv@!mO al  Walk  0e g1i	a lien!M! oc0I@Advert: 0[Aqo vae!djقWcqP/,!i@um  gravvuu:e)E<ӎA: n@A%dc NS@3 >B^hOz!QtegiEa	c]
v!l0IyI= kT@ctez0 eja $,C? iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`х`ѡ0@CT =4Q0%?1$bucedeA,qAhostDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec    `6Q3sM tri!bߒLD`AМexa@s wQUUig:Tgrg`alPSLs    qL rB+ۤiPArrfDigpcis gҐSAdP)PPЉ:xacmod!CsާB! fazA@ArE8r`a,Πer dfoCrm!r3Dn,Pja0ّ.@eHCsHfbrcausadQerF. SZ Q[ ea 㷑2krvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo`qtB #u@aSM%8` mabnb1IY  @k,$$al#.2P4sa eiSib0RPuseu sEExigU`re*PbM0Q+ &per#me@$1lp즅p+!CD-"$gGP$qme:PDusua: VocÈ@gp4ؐ@a0vr2utzooDriSve& t@$RUSURIOBG@ESTRE_FSC% ɑ7q<Vapaz:@I. AaN4P@9de-ФrMiAsPJEB>p"}\@. NNv ݰp[֣'6Ve ,V`(_K` 0+bu:*Ƥa !Ede]D.Hf``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a`uuz΂oT :adq(˂4`  oqur<@ǵx@Fkg4U yaf0T  y 2y, p;) F `3B;or nal|pF`a-t
A^ 0ˢtEܴsubtuCd C{ ?@ *hR)ppapptA-l VJ/qrWL !8Z  Lembre ՚	vqMac`Pasa8
"quAi_sye`R ESC@]ŉ9Šq3lav'f'rF10. r`r:MrʷT!Ac]D ugus Op1k: Mult/ibayQYNc`ƍisi reAFpBa baФcopld(RP ditzBĢ	Rc"zipcPrimeir"rc QtRӂO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыx"S[hp1troahvdeA/cund a@hMo#aGPadrBiQTaPhBmemO"s;em fu0bw>zec10+CA.#RPa 0RlmWLAN)`` &Bl0oothkAn2πڐ(a/l Eomenerga  ere*a!gBC/*1w62b,2oo-'0suЁ`/0Et#netg	O p
/*3/CToken RingOOboId
!fDPPb 3araT qUSt sPSڼCBbQGP_tgemNSrl1Csr|NWDuplo&	ted/	)	 E/	fONOOO'as7A XjO/	kC/	cIAlЏ O O/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% ]@Oc3l 2:cv`N3:ɀM* 
 o9ay CJm*O"(s䡟flex QSc`xrydap R쇕 i3Popup޴ Exǐ ~'F12( "ߢ dQZs Vsarava NUu`Ts`ws D2DMAFWIOS i kЙ@{mtukP  <F1=Ohje>xpJrjptQt Nytt vPbtu kP Tallenna levykkee Adk@onoPpuVtF?Fo02ej'nsW Oh muA .lopq6Lr + ttt7fTpou`aurlisu0invojan ssapMrityoKyn1y0k L%a@tyl	
 P usnumAe
o$&-
t lyk
0iu '
,(opnu kiG
/ !(et F0.t13A sb5*tehd 7& oG"@t!B$j;A)ma*in`#TykaluA: o K < K9i3vyt?0jOa9@@DMu Qk(! aR6nC:m-GdHLisie#li Q I0k aec  harlAlQ@1Q0=  22R2#2h%oJatk!inPjot  nWpp_=d, ESC=PerF =Hyvksy=KyllEi cM, Jok	uAL=TY_} fnuoli
mip_k`ah,$@
sics"N <ENTER>[ mb7t
epb+.!I`Kgn C/ss seuraav0U: ->Xi VLINPPIN =p[s  <-bASKELPALAUTEd0fb1!YARKA+! hԯVAIHTO+0', F2@
)_= d@!;PvirhvAkkua e =oi>da.>: Rvdi 01*ka@ c1s} apH3rtRPl pU@eytke`"6ko`>@	siPQlaks1qrsrW` kaCt qlaa8P^ TikkI)>skeytyi Fn
i(pO2nL^oP2hPecaGmA|ja|}1?i`d tOyypp iIn :fapllVlisQ (L1/L2 U  ROM-Sbmkoh	tuotepe")sar {W]`si ?stoh3jab T;{	!1:"#2$o L3o`M4m魌J`LtaQon7(j \oa)



X\	\JEkA'ra- Dq QACuP$#:D$ (P9a%dzb~' lpi!iEމepo3i Walking 0 -[1Yloso`Vaihtoe8@ :uvi7 us: Tm󵐅@atpnhp . Jlt luop2us-  n,pir1j1onc@<!K A: L"X AYhk0u VV3beFAG8p_Cpa ᣾
gH&koa]Wi `n? `O  P?ͨ,iF`%(N92R`3.M.A.R.T.`Arp$ [࿀n (min): 30-%s p2y0%cL dv0 Is,pysi- H4iVgR
{8fb%untq'c{K)jServomoottj
Lu!5ÂvtuQ	k@Ftotribti2`ЗŽy@a 6eqKxe nGG9w UueVahv2u  x P>2	! PC }A"+2`s@a	,-ãPAJ頴n4-okkpDad`5aCn /)inDP -e@7p$RmysbaH
`k 1h@` ЁeT@	dE	ZEY/ i0Xj\ [!K unQnwby:p\veapahtuam"b@^id FLaJ4|tii l| <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfga hlu 5qf,V "0@PraZ&-Q,:*sek m #o$j$it)a{d||}yh' PP`0#UCc.7>uu	SApor InfrPnR%!bkCD-- -agl Wbt`PBOj<0WWAiot=bUon DИe$(qpTT#)PKll7a. P    KYTTJN:a PSSANAN,0&#Kx.ma$r@'sτilyqNhur@S9h  ri_g[t  _r
%VX-%PV	,1pC@@jwLLA1=`[Q' ON(U @Ros`* $V suQFZ>R;)f,#tu?x	5ogm  O
 G BU 7mBFr 
Sxez`j~ED. Nykysc R`+RAn𨐆{s1x6s
t@@ PU. TntȠ}`$ྣih1xeip=uperVd<eh? IPa*?-m@&yް\2tHtaqV^=c |AojaiemmR}tAq. 71pm "Fdt"TV@UG.2 !`ZXrrF_F0zc$ elnPĀo#\X#SS,aTpESC-nbPsR6F;n,e'e'!> F10`Y4aa(x :	o .cVQ llÌQޠtmidys ubbn MultiBaOpc&J7lakeo0iu (cen/$oi) USBd@)Zip~Ensimm ABKoA e7lj }Vi}9Ki eit@kKapk Y Kym!aiо Fn/Ctrl"mA+Eng(USA&UsP0s#a!1B-RsQ$ S`nq`jBs#PPsz V0olhttVakiIops2sN0#IguuQH`Dpl% ?verkko "~
WLAN-ro'Blu`Voth @/HE!h^sV0@Qs s`9lƎ|+1`i  <9.2v+-	+ (ylosp*OG`CO>r5EtherPn1E Yoeo3o8To p#gOox(@workQ #%GlHqliv|s AkkuRT < TJq pҰ rjol7ibr@du c`d pWual^-OO OI  OK"kb_O O O  ONrO$O$O$tva_ O1 O1 OMЩa]anusBk ODO OOM"O OOO
OVI[ e`i:r
ada n .< Э% ] `ODPW2l ur00&OE-O
3 
FGoMODH*  j  ,9 ƠаdBk 1vuCPPɐixư  (se nA@S`:< F12:ٴi@P%3tappikoskePPP 'mmaK  Ei mn BIOS DMA iedoPot Configurati5ordteur  <F1=A> Fichier Infor` mAff age Sauvegarder sur disq` c R:a ,r  ^'une.H_DHe0als dfau ow du'Igno%mocdi Tqu S%e l'in%Đregom	\ Scurit&
e ss`Nd@S" #j@ e sous te PKon.@D
 priphP %J	a asE `IDy'As
Dr=Lock,q
Smp(C0Cr13r3  'she5  1b#a <݂gre taR,)+5p7am9''usP3;),;rfrencMҦ =at"#Oux\ !@lonnL:bceri~Z slecqSn@psQPs AIATABFoV,mmoiricBD X C0ZZaFB_V AcpLang4 COhoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouFqpo@ge@|u@lw=Ser, ECHAP=A lHAccep S0=OuiuN*#Q3V, N'imp"p_e``1D
=aw  UpЈzi3
s f'heM
mo!04ecle hmenuucer@rwbri 2qhz!y <ENTREE>2nj+W8	ss	sui/fa  !/ :!-> ou BARRE ESPACE = PBe`-$IEpreced@S<TAB`CA*'zMAJ1+ix F2=1 "w-$!S(rr`@P<TJ Il FA%sGsibPcQf7L U cs'Jprod{endp#B$P. CoZa<'401!c5JCntв@-1 emplace( L' D SaQre@}C'y
GJ 
s}^ccueil dFP "4@ itaxsmGobia` `
W 
u` B!OOOF2BfCX+)a r]u Fa0;cq0yM\ Typ0osBVwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numro#p	Rev`crdoerS2Itr<QclavpoLA}ud ;n+/Zp/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoO OOBVj'edA Eo MT֍ :$/.   %lEr4 !SUPc;Walking 0ᥒ81ligN'ad`auZC	od  aYl0ifA#tip1SC[a=e@ptruA ieЪ!vPR0! /簹Lr,  z{ nro°c	cY0]A}jDL_v
 tro Pa
s
TX	  _[Rvja"`d"H.On m:YfPS 0"bf   +-vaАPC lp  ߚV ? Igno7ꉈ+| z Enr#egeo#=1 (rap`)#>2 (coet)u``|pimA5(z) B30栿s pAU0% Fnv$D9ʈl'hA+bF   `:˗	AsGin6pnud'+,B`v`t
$.Lu( pG3p 5A`ib!O: IDP00@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAÐ?/.@;sa#=A Mar uinKS ;A, eecoac	;mme, v0K*ad11lPOobPbat Cs	eSd4D	 pe>a1a`(`ih s4[,P@s 蒵 `Ug~"  formQg-hq#xѼsJ.)rmQފb	hJU0`
1AJ.6zT"`QDP~aR a-voupR0!Afr Cww7A^	 	zYR`H(p"}ffQd  k;l2TcgNq`rHP P`o Tool:eRy Mar O4K8CF!/  QuickLockUsusA|$cp!ri 9 س<S&ol'XS+C)re!cB !
`K)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAud%P `  4craQ8llƙۗ&flash<Yd CD-'gEfWЫpala*Y: 6PR63ge Drive!*. S3A@bAeBޱdez deux"(UTILISATEURPRINCIPAL) "cEǋ	r SċOj N;zJ@ Ҁ@Fᣐ#1"Qisgr  ,mfe0celu&NSDordi@"c. A0@QV 	{( p$OV)Do Co 5AfetrpyJ~NH",t"~"raSX"Qnof0;! ;""t QE)=ah:>Janiq4 5#'/#!2/7r,c`sX!Pl!  30@)Y!!} !!{e [1NpJ^%puel 1@݂͐sUC :Hh" "\"opDa8 lEO'fW'ҜB`k_w# ,d'originIlBv`O2CxaB	uȦ
vqSpa0AQy9	0t0M@
5djaBvBPsa{S@P{e*r-$ށW1aprs@4A~Aon: toP @Tr0a44p`abzt3إk'
vj,? appuy
` ECHAP. @@ OTzR'o',O pui@CrܡDF10 TapXC1xCx Y^u}	U/~1Frana
!OgVACJiMultiBayѪulAp!hA !3D,x\soca%(ga)OOFRz) U[8 USBF1r
.jZiprP: Dhi@sβ QuaQCiyn`NSixi Se  Hud NeuvCD`Perm/r(s Fn/Ctrl@S AnglpSA) IPcopqm1`s A stan0`hnROd'ad`nel^trl' Ugichuer"&mR`
*d :=i@7idoAABid@b< 0 mm%Vl@jEK!al ó R o!=ril WLAN (rsqeil)AϊgrBlPooth73r/?1   ;)o`! g`N loc 9G ``!WnX-b61AbP-n oR82ooypu9	3ccujodh`ogB EPb!t  1a"23T{okRingo oU/,IduT6*ao aX  
/     Ph ll`4 n!Hre0/ x Ab!AC.!f*Duph */)///tb// ///**- ///Jngn$, `/,/ /e ls` BtexЯ
sqbmoP/ /7/// ,///7[qRpe 1 : Char9. % ]A.  2D ` GicM*n3@	Rkio.b
* T   @@/M.$oOAg$Á4Amor1cFe"5 RetardBTexp `) Dtгa  F12tposf[iP+Aux  PatqbAKw ucunferts BIOSmDMA IIP zpOlr <F1=Ai:> nfog.Qema
l0|'Salva`l floppy%@At{toRiprina dnThПi@fa 0``ip">Ignor`d!ed esci EP a
l'	iI@Az eiBtupiczza sswo&e amD0ratogcc3R
q_QX,vos7v@% IDs
@Ԥ&gDri?veLock	ަPr Ƀ)St{ CP9 SupA=(c30 g Hg/o+:,i fabbr
4=i	/.nzi`[Qco
rui C`b5<bae9E lrOpa t2;o rigidAt"paA'VP!,a me0V W`<HKhM%iM;A>or !Ava=t Lu!O l$Dim"& q6sca X ssopd eviQ g	vv!'#o*62wH8Premi qpsiasiesXpeirQVu L   k=f, ESC=Annu ,TaA Et0qeo=SiSN1T},altro#	=A bj U}s"SchiavI? frecc'!ri1 vocpu ap7f"_`<INVIO>  \k\'e.ipYgui  un%:@ -> o SPAZIoO = xsuW{ss`0  <-poBACKCE c<TAB@C%o"MAIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87non pupvse@t"Vi  v@u4T|PXJ. C{'01 N0u0F>QQ9a0}oggiao Lk`IP'00 U>re0
4Es"@agga%Fv0SAc`ғ  npabook"Qzesp қ:\ ZҪf.atp_
2o{briuPrf uduAA ND  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4D葭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASpr:bits 0t 1Rindirip	i]  `| 'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, O`1favi P}PbiVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%LH?bq+d`ᗑ {â"Znd?՛O .A7Tcq^B&
Am AVf! B;YpCr	t>J&2fum y3"CePe<B #Eu _t`s!1a.Q]ՒbdFo!erqdPКatiwEff+Jizso@in  ca@2ivEvPgaζOdesХP @Jm9Yy HP tectTools Od. ZRV2+ ickLockspen`3B05EY. mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))`v!pKsm@]H0x!! b	,'URar i "lі@NR(@@|ГV|a infraQ)p y%La_hflasho CD- eS准2&W0Pp`	:(Y=!AҍўDeyusan@De'. !DU8G=0R bRY"'UTENTE@PRINCIPALE  r+`"ρa PmanA5fu`o. AnV@!<d ЊQt@P!"A eC!>c2<!t.`leu0WMT[s,
`h	\@poI sb<4#reWc.MaPi? `o@`6d6dqGi>h@A
 @re,q  d (1z:t tOCF r luogo ĴG T!¿'    i$  h SGT#:, eG</I"I@5-"L7Y$r@l$x|slmЄ!R/ċ|cB   /$²ȒSz0SŔ@ c(0 0DA's` B gPQ#pQAi qv 	plptat{+`u Y/AdO::!al0{s&.2pqu_{9c!."Y)@sA`YHEsnO`d@K@ȱ0' 6h,mQo ESCȣFM'ŝ)doivr0 'n-'`po2m!nF10.ɡn Q!k0Wyƴ_6\WРI:P(i 3  O ":Ć dM MiBay ba 1.gga4 s$Z) og Ch`i USBA]SukbC
ZipBP6o ;Terz  OЁv`N%ec AAP Fn/Ctrl T`Ingl~ (USA) Yiu2O 
mpl  A01aЃ` R7Cpl AaP`0ư0!Mo@excW Bid0HaCapa memPqaLX5em s"F!/lbQ2'/wNPs (WLAN){oBluetooth>Commu5/ (j)@s@m energ ZphT1$0&1 N*'2HB$*Ca6*(0o)ol,sp 7Eth0etW% V123e Toke?n Ring OE3 Iahby@P@tqaI   aoq$  CP/b// TDzS^oo  YHiPDu T /  o 6  / o ,o// ooba  c  /  o uY\mo9S// -oooo ų///oo[ PAs 1 : 
ro 9. @% ]ocomp#2S'4,n6E3`
@ij* 
 /JoXaX/3i'o
   Flo'ppybUAİIAdc`Ƭ@(sec.)C velpP`F12b 2z@aCmb`N=uTrasP2@ DMA BIOSup <F1=Hjlp> rkiv Sy!~infothps~ S pk%kpiguQ 3(stll /frnlpĐn ard Ann}u!a nd` ochsl``   n ʑ~ SkerdPtrssl0F  K!aOB rt-OaEnssp	(b -ID
S ao
 m`
Rd-Std fruqtav 7K
@byggd 
usBi=*abrik`m+ .J
sbehrig#.Gskts`rktyg Ko +r vP 
S`;vtiq~HDD Ak_V Minnes:B 01q5q ?@An@#B
S V[lj4rDPx;cBnedttlD!v(C-j+eTryx@SI fri Dg s nr du viJPstyY=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil`	e	/pCa PyEt
<RETUR> om6
\YRtt .ke,lj`SeerI  : -> кMELLANSLAGSTANGENTE?N = NXS G<-BACKSTEG FregeynK TABf#|O`KIFT+0H& F2`+?|= 'fO @%Aoi?Cfe=l 3t gqL @ kA t h+AO` Dstod uGen. FelkF0197 AsЌgF{P|plat  NtPhm krv 3? pbyPgm0 fly5s t6 U-Por/2 ex䚣(||0Ytidigodoi2-@kl`TA UkN,<q  Prr, typ
hGast^hg0Cap-	rlek (L1/L2)Yd ROM,um  familjrenummn0Ddeo, rY ttNb ~pqyrQ!]8H 1.zI2#3$4qrbinv0X̦3 (bZ)g	1[


Sek# xI rq.@4$@gaxr%Ex!z=osk!pvidC|lmissl l~.s Walk0s - ~P f1jH Ad=ds li7AeޡnV;ar! D@/ѹ  7neh g"Cc^uskapay ą/G-t۱xiƱ=k b!h$2AA:1R KL>#Rhi{wIBB?skydWdadag
@
  Eˎ҇A!^Ԉ  |? ig? D܇jGa-{ 1nabb8$pf@րn`X9UWk ad k$pQd (0): 30@npan 2?0%bX A40Pp/]pp01çvr kaItPo:,t	!قOk%S(x ervo
-LzB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ R4bd% pm}vlika mǄ  'InE?kan orsa@3iЈP9aH0SsNypPO@Om=<as1A1lo. 'Na om hglmabtj@De=h ;else-D @^uQuayVqΦ >8fun 08`perl^7ž!i HP tectTools%٩R-6-Quicka"q`telge Lp׌mPs GHgk
gpBpb*_-  &q2@&!џ!!~r ngo"8pKF5bli`X!aot. Kж7AompHi p@1f   Pk`an~Flash-@:v s!CD- pBWu O#TpSr HuvudpH`y`I: D,`m3vahrd\ud D~e!. /C怆a^r ANVsHUVUD#$|`pmart w.] A ? L1Ёq`ild frPA+A
 I1PhPx@L l  Qף(lHTDwO.!Y  *oH XBe0{bbyggP6Q1 g3///1dZ6- FX0;omc eB
8HcA?=  ?dr:asBQGdʜD[`ktuPaiq3afanqkr`.GutAMC]tgrs^W!p,t1ursprung`LxK. Vi?  reko` RF	b~c	Wr`+,s`b`~. A `KT̄3@_bh  &g!(g ApzO-befnse rm ih񓶈fljQfns . Tr  >ESC-QBSr26 V"&wC`'Z'R-sedMtaGF10`cVi3a:+ddQ~shye aSve a 2 Q: N?,{ M iBayCgrut`A~opBP85vi Ba P&G (pr (h@SB G Zip-=PW`AsQFj1AѱQ utto NЛT VxpFn-/CGtrle ' E`lsЭ(USaAbmYkd@0!aa b`nwrmstrorxK,  hbbelorlekhpeo2ne@kLHpIfEsȻioBtrqtK (WLAN)Bluetooth p/(6) -v@{ANmbe^1 Aggs`FhaE%-21,2v0[,p$Ned ECthೡ)& 0	3n To!|RqN"Unik '1D<qiD K `tus      SBbo Kalibo d@p{  F:s alQ.O 
o 

 
 9
Fo 
E 
D0!j1s 
Aoo
Et
Htag  *o 
* ʯ
VCy e!mo l]A*5ooe
 DIOOKood
D?[Ne _ : Lapr . 0% ]
klar
2u j253om FjOF* &V@1 >I *O!DgOߧ8U«br@4sadap@$lg~ rdrjQ>snabb0 (sek. F1 Bd StyrPguIOS DMAaaaȰ"Ben ieer/  ~Op Teslaan Configupo`anaf PvtŠardP",/  scy	Wijzig&ne prog?ramma @ЍSetup  z1r wـsveiBeheersw?achtwoo ۅ
 %X. ApaatbOgl$$ ID's 	ga,SmA6CP & Oa u"5P$cR%m@j+%O
Ge@gӨ gssvzieُ"Fabrieks.PEugz7@/);Vref.s:nieuw8OOc  Ext`AccuxB 4\e0P geselec Ea es  zelftGa-sc_hijfei Act YvG0u`?I R!a/4UBgTDAcg@7n ,DP=%_
 w 9aKc!: Taal b  =r/emP 	rijsgemaak el=;o" /;9
8ukAZ ]{NMLg]g=S, ESC=Annul"EDG0=!e!oJacNee fslui@Q, AQ-f =MN Hulppijltjkp`geObrui1Ѕd )jui`xnukeuzk@ark^<ENTER> ind 
crƱ]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-BACKCEVoriglɸTABb	#HIFT!+%%|2+K= ykp=t#B~fouta64k p It w_ge15 F0MЌreqatijasen.m AcoZ01b a0.i1ZCu  we   Netvoe are0#FMPN 9diVbas`e3
 t n0 notebookO-pc/AP @.
PistNOQbep*igdooh2L	MЛaft NmpALyp6rocessBneal3Qpp OmPЂP}e (L1/L2 ^Zapac?i VHROM *@ -s!fSP<mm E  H9ebvrgav_0ideokp&p;b bpM	m	ra1b2$rd3e4hFisgI )t}.jne C(B(ЉwM@dzQ%)
  `Dx#SecuibE.aw~~$@$Ftb"d%)҆2!dH U2L53Hac-0-*1Tho_adresrlafwisnd Kpao=LTOop: zPt<ts e'ge t PSBbIeЉf s; d1 A:og-  /ޖ@"x0zbLe6`NoffaG1Y\f_d قڑD`ѱ

RboචgAt
wOC'We nu  Њ8"
wil?oݩ""a?Ox
Zl"+1 (b),2 (U0Y A) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{ho:5broA):]e1eqx/nb!$32#kvo	-IPsEI "
2"qk:J S.M.A.R.T.-af@APP@ud@h "/Blo!  A I-7 B4kX qcrl0pSX8
 Vr!ap1& is 	bBsAYoCf#/k, Tm]lijk0UKQߛ zoik` dvors: ka?0QH; fQeksKPܿugzet,r XlorZ@P¶ZOb$ uswb sqwYf ur9houd'Hi`! AQ`R `T`R&BѴ vuaY߾HP Pr@c?tTools(*% / k  p?gspp`b 	TWmE@ #M"g$rgΠ9b  
 ~erX#W>,.o(h( o( S("7'EAJb"f k otrasakP)5w sXbtK;?ݳP ]Qŉ p1׮frapd  Parˊ Flash-malCd-r@WHNǉ_HoofdXVGs`
jE  Uq13xxaia DQ!Lc7A<i!Pzow*HOOFD-BSGEBR?UIKERS8_Lp1  p $3an=	 SsFC  cҦwapcJ#! fy0܁k#0hcomp s%ksMq~[p%t  Pbc(q. `Y0ppq8_{!AutomKc%5 :)z2U@Ҁr<zd@Z==}88 O!V)?!2:NP O! !. Mo 0XeMjoOtD1, `  CjrS8ΠRU nt@`Pe@	M/ # hui,UPd`wwas to/!k; wgea. pwWanvloeC7YBkjY0TsPAn`pZUt20rAra=8	hR0` torHh/) bget. Oo
 s @vb뎸. OmRun
1]A&`3fe*& gol q. AAݹ_Ա_õ, ubhA dc3䥼p3ruk3AESC- (A90 Ri r4j'k'tyUvbkn F10`ۀT*Zlutb `r3`V4  1Nel@@g MultiBayjVzkd@\!base (ks)re  USB-Մ cb+zћp-" Er@we鱠V V\@{Zes >Zῒ>Aa8N F?n/Ctrl `Owiss/`ߧSStaMcW3MijsappOu e 0  n ӫ$l Bij V o-QPFA/A0d`dition S Gvgp<uqVilat0E?b疩p neVd$`Radioj WLAN-aoeB/lueth/oG`rgie@1¡ qYIQ[&,(bA)܏`Et`0 I1
2
3fTozR/- OMom@0r23 UUrtcu!G< 4us X    Sa?Gekali@!тOK"2
qNQc ualP \JOOO E WOOO[B['OOO H{ap Aң
O$O"Lpier-MUE-$J$OC$ Pn+OO+O  [jp? 1 : Bo. % ]A/&p[лd
2knte~l/{	3	#Ʉ
 fohl/)1* Jt  ;@>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12 )Kbb@ cursorytuyEasyPo-muisG> DMA-}drB BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR h=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ez]  e= >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"OM пOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 标sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPuA0V @QlA [_CD-Pu3(^Z !} ^ S:`"AzUKᑀ %iE_$C0vb@{ y`9`$	5W ;?`,WAT<fO."i	0	iBlH	ێT supR@sѿ痣JS#ˊqH@@P!H/)Ɛ!eFybY Gq> 9ߐ ϐY0؊ԓ "łb͗WL >kł`k)/)%)ApȦ WCZq.w"* FD`nDHa(o(0f}@#$E'm@\@Z ( IO)F)u
χ((?(9(.ÞgDuЯ$x#<43ɑq`ƈ|M3 f=e~^@&A)F1j 8fcB  BgB<B}AȑO"
OcĪ@(2ef̯ 攌8d툐ߨql@Ӕ5CநaU"1/g'yEE[Egsc] @ȍ~elAի`mT.?DriveLock ߤt['F10t MS   y_ԝ7`EO: ESxtkGb@œO xXioiEcUSB Xp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ ǯ@{`\p (USA) `Ӄ|*B#fo+X
KAV&Ws
v C\g  }ZJ _ rIso@⬤ cWos%AwCY OڑͿ̧pYalNi!LAN{j%MdBluetootH/cj!`ߓd p
2Intel  Execution DisabCle- ++12)2)++odhEthernetX I1237 g!q
 AOKO3O >H!O D{j' ID 4bcK AM     g ϰ\` f  R?ke jZ o \(P%*nP/h /!!!MEUt$ )oz oooD2s!5bv1 : [d . % ]O<׮2 !gOv
3		)HJ*    5`$>s'pmj&vSpeedStep@ technologyP
u'"( 	_Ħް  # px?(b) 3F12Qiby a ^ `Pb(ZB1  @dBIOS ATA DMA]                                                                                                                                                                                                                                                            ` a b c d e f gt" M      v   Б  	 
      
  Ā               0         d    $     / 0 &  3 4 d 5 6   ( ) 0  , -   * +   wmp
 N ]% @.    mm(m$m0+m1m88m>m@EmKmHRmXm `@E<B7B<U> FبE0`8l v x_|v||p0p7c   c 0A   = ~ < p  <$$$<   DDD    O aƄe  i  o䔕 u  y $n%Ap E%0IC&O p   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:?5-_V<>1( ) +)#/!'?
ߨ({[)|+}][{]}_'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'߇(

C$: |  s+'()+'*&803&b

OO
\()| O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      p]g|mA  m^2@  .@  bmƨ@ ED @n.+mL@ŀ@ I mp  U?q@TrArBrECsDsOuFTueGuHTvP Ja 7 
m9 dm˸ca@ emgm@U@ | *@_bmW{Xt|dU Zt}[}#L + ]~&  WU_t`$itVa!
	$
 	ު 
`	
 &fm`
abcDdeDfPh(>{&_m@    /`m@  
 j( {
( 
r_ l0 |n o : *R  	mG$\ $_ 9 QD VF10 Setup Image_SETUP  P0Sq  ; 	(dP" *v@JÒ"IP a|` 6
&$`ԩVC ؄ TԫUTԠ*U<g!"$8Dcz: 'Uᴳ4㴴4U崵d紶4ՄD8b_ : (m
6  U($))$*U*$++$,,$--9 Ռ-g U 0	`
9 a
E#8i3jG@ #!" #" #" |
8 RMNLNOO 8 @
:	 
  P    /	&WP  b"  N  % ]   N''U!(( )O)UP*Q*R+S+UT,U,V-W-5X.3V
kdU-dh.h1diiU2dj3j6dk;kUdlIlYdm@mUdnCnDdoJoUE$FpGdqHq}5ajmoqHr$Is$i\6{B |y{ }|d`}rX}L ~ `}}x ~`~n~~tu wRxEє~Uz{  }teIk~ 
O5L5(F@4]`xoU:fԕ\` JdT\U;U`
fe @9S xԠ  &MR@ \ b v @ M@ @ X z @ @M@ . H T j@~ @M̀ M8@ R r  @ @M,@ L `  @ @@ B Z t @ @M:@ ^ j  @̀M2@ T f  @즀@ V zJ  @} 	M@ U& : N Z@Udp @U @_
M*@ B UV n @U @}M @ U@ `  @5  @ U@ `  @5 
CU  . J@bUv @ MU@ < ^ ~ U@ S@ H \ z@ƪ ր@M$@ 4 L ` @j @%@ > T h @ @@  " & *@.6P h@ @$ -@ d   @M0@ Z   @Ȁ @ ,@ Z j  @@1@ 4 B P ^@r~ @ @@+@ Z j  @ @#@ P j  Z@N U| @؀_MD@ r ՜  @&T@:@ f   M@
;@ h U  @S!@  * U< R@fU @U @M  3@  U  "@(U:D L@RUl @U @U @M  ,@   " JB^~ @* A 6@ U@ R j @U @S !E@ 0 T Ux @΀S$" M@ z  5 @ # T@ Uv   @S$ @ r  5 @% L@ UX n  @Ā&CB& 8 J Z@lR~A1@U @M'@  U  @"& A>@DH L@bhr @@h@ @(Tg@ l   M@)7@ X Un  @5 * f@ U6 J l @ղ  +T <@ V ~  M@,@[@ ( UJ b @ @
-TZ@ $ , D UT@r 5@
. ]@ U< f t z@5/@H@ UV   @*0i@  A	̚ @61p@   (2w@ R  @Ѐ5 3|@ U8 J \ h@U~ @M4 X@ 8 UL d ~@U @5 n@ 6 OhOhOhGhABdz @ 6 b@ "UH j @M7 @ @ ^ | %К 8_@ X n   9@
@ AhU4 \ @5 :@ UD Z n @5; }@ U" < H R@UVZ^ d@Un @S <@p@ V  5 @=@ U   @_*>MF@ X Eh@֦ ?@ z   
@ q@ : R f @ @蚀$A@@ l   @B@ ^   @"C@ j    D@@    $E @    "F @    6G@ j   $H@|*@ V ~  AhU @M*I@ n U  @U @U @ҀU @SJ @ , X t |@Mh$Ah@EhDhiA@KJ@ T f Ihi Ah
L@@ Z   ئ@ M@@ P   N @ ~j   6O j@   *P j@   Q j@   Rj@   
S @ X p  @T@@ ABU^ p @QAhA1#U@@ Eh: OhKhdDOhGhEhAɾ@Ѐ܀ VL@ D X  @֦W@ D N h @j @X*@ : b v U @SY@ f  U @΀SZ@ H l U @ @@[@ V x  @Ā @\@ R z  @ڦ]@@ F h  @ʀ^@@ r j  @_@ ^ h@x @Ъ @`@@ F X n @Ī @a@@ 8 R ` r@OhOhOhAT@5 @b@@ Q. "P@rՖ @cT@ 4 T r % Z@
d  U> L@lz О @e@ N* ` r @U @Sf@ 8 B J N@AhRV `@|֚ @g@@ p   @*h@G@ x   ڀ0i@ b t  @j @ ZJ z  ДU @΀5 k 	@ U> d  @5̀l@@ UP p  @M m%@ r ՚  @0nT@@ |   S o@ `  5 @ pV@ U   @Sq @ `  % @5@r @ UN f v @U @U @UҀ @Ahs@@ $ 6 V n@v$Њ РЩ@ @ t(@ > l  Ж @j @u @ J d z j@ v >j@   
wj@   x/j@   y)j@   z4j@   {@@    @|@i@ L nR  AB5 @}B1* N p@@OhDOhe  ~@?R@  A* B UN R@dU @ƀM * 9@ t U  @Sd@ . @ Ul @5 @C@ UL b  @5ҀB@ Ah@ ` @ @ B@   , : Z@p@ ʀ   i@ B ` l r@̚ @9@ Z z  @V
Ch 4 b A*ChN n x@ @ڀEh@ T D@ ( F \ Ut@ 5@Z@ 2 H ^ AhzOhOhOhAT @Ѐ  p@ @ "\ ~@ 
I @ < Ah^ %z @@ 2 R b@TEh M@k@ < UN ` p@U @ e@ Eh0 4$@8Ah< Uj @܀Sk@ d  5 @ @ UH t  @5ʀ o@ U, N ` @5 @ UR \ j x@U @Ah @ >@ l  ̚ @?@ j   @@ t j  @& a@ h  @ 覀  @ n     @ l   @ @ ` |  @j @@ X l x @jAh Oh8Eh@о* @EhKOh@08R@zJ @@ R t  @Ҁ v@ N n  @ @ h  Ě @(@@ j   $@    @ x   @ t   @) @ X ~ Ih HhF@@ EhB DOhKhlDOhGhJAh @Ah@ @@ 8 R ~ @̀ @ d |  @΀@ F j  @Ȁ
U. N d Ք@T@ L Z t U@ S$@ l v U~ @5 @@ Ub   @Uƀ @S,@   5 @
@@ UL p  @5ʀ. @ |   @@ b  @ @@ 8 H h |@ʚ @@ L l  @ܦ@@ N t*  @̀Oh@OhOhAS @ : X Ut @S@@ F d U @S @ T z U @ԀS@@ L f U  @,T@ r   @@  . J f@ @Z @X@Ҫ    8@T@    @ d   @<@ xR  @ހ@@ N b  @( @ x   @ƀ 
b@ 2 H ` @ƀ"@@ ~   @@ P ~  @~@ `   @@ v   @À@ f  ʦ @J@ L |  @) @ X  U@ S@ ` ~ U @U @܀ @T9@  , 4 U<@Lp @J @@Ȁ@ \ *  @S @ j ~ ՠ @T@ P l  e@րAh @ d @  RAh@   M & j@  5  ΀@ Մ   T@ Z r  մ@ʀЪCB, > X h@~A  A1@J LOhOh:@UZ`j r@zAh @j 
Ҁ֪@ > ^  j@ƀ @ P Z r @   @ @ T pR @o M@ {@ X U  @܀M@+@ \ Ut  @܀jAh @@@ @ d z R@ĀAh @Ch2 8 b @  @ \ ~  @@ T p j @" @ f Ah@ @܀@ ( D V x@j @݀@ X |  ƚ@ހ@ d x OhOhOhGh@Ě  @@ 0 F p @j @@ > P z j@΀T@ A%D h @U ܀M@
@ 6 UL r @5 *@W@ U\ z  @M؀ @ & U2 H R@ZUdl p@tU @S S@ Z  5 @@ Ut   @ʁ EhT@ ^ p  5@,@ Ux   @S^ @S@@ $ 6 Ud @Sꀳ@ z  M 
 a@ ` Ֆ  @"T@@ j   M@@J@ X Մ  @
T @ h   S M@ f  5 @@@ X  Ah@ @"@ AhZ AhlR@Ah @Eh @R AhҀM 
 y@ @ J V f@~Даj@ր(J@   Ah@5$@ Uf   @M @ V t  @@@ x   
@@ nj     @ Z   @$@ ~   @@ B f  @2AB@@ 8 H ` A1*Ahx @1@OhOhI@Ahh P@QX @U @@@ < N t @@@ 8 ^ r @ؚ @@ @T f @_  ](@ @ U\  @ @W]0@ X p U| @U @܀_] @ B U\ t @U @S@ N d Ռ @ހW].@ X  U @Ѐ_$]^@    @]@ $ 8 L b@v @Ԁ @ V l  @  ]@ 0 H h
 z@OhOhOhPA @	@ 8 V "|@  
@  : ^ z@%@Ā    N f@v j@̀#@ D f ~ @ @*
%@ P ^ v @ @ @*]R@ p   @]J@ |   ڦ@"@ F Z Ѐ ֦@ @ l   @.@ , @ \ t@j @؀ '@ N x  @]>@ T   Қ@(
@ v   ]"@ V   @ @ lj     /@ ~   6@ R  R @ S @ , N p @IT  @U @؀ @T @ . 4 D U\@z @и$ A_(]<@ V r  МȚ @@ f   @  M@ P | j @M -@   * ]j@   .!@@   6" C@   :#>@   >$I@   %F@ ` *  A 
@eU8eJeZ fl@fLA1&#@ : b rOhМDOh @ ']@ T A2 L@VU^t @5 2( -@ Ն   )T8@ T p  5@*[@ U< X p @լ (+T J@ d   M@,@ > UX z @5 -@k@ 5H P  @U @M".h@ ` U|  @̀M/@ j U  @S$0c@ v  5 @1g@ 5   2"@ `   j  3.@ * B T ^@j j@܀4 \@ \ ~  j@؀ 5 X@ h    @OhOhOhA5@6@o@ U, @ X p@" @7@@ X  j @8 @ f   Z@9 0 UX v@ L :T@@ 4 L h U@ M@;@ d Ut  @U @ @<T @ |   M@$=@@  M  >@ l Ն  @? ]@ ^ t@ @ @ zj   A [@ $ 4 J X@j~ђ@ .B @    "C@@  Ě   D@ |j   E@ t   @,F@@    G@ tj    H@    Is@ P  T к SJ@@ ^   @ު @Kp@    * 4@<V^ h@v* @MhL@s@i Eh.@D xj @MChU6 \  @MN @ : UV t @ @*O@   P@@   QTo@ ~   S0R @   SS@   ST@@ ~  ռ @U@ J h AB@ 
QVA18 D %Z@xІ@OhЦDOhо* @AW@@ * D \ Pj @X]&@ X t  j@Y@ P t  @ Z@ : P p @ [ @ ^ h ~ @ &\@@ h r z @ @]@@ \ x  @ @^@ r   @_ @ ^   @.`@   a@ ~   @̀ b@@ , < F T@n~ @ڀc@@ J h  @Ȁd@@ N b v OhOhOhAT @΀M
e @ D Ub  @ƀMf@ j Ux  @g @ D t @Z @h $ D Z j@Ah| @̀ i@ D `  @ئj@@ 0 @ \ f@nz &M @k@ N | j @4l@@    )m8 J U| @Sn@ ~  M 
o@ * U: H `@nU| @p@@ pj    q @ ^   @r @ x   s@ j   @.t@@    u @  ʦ v&@ ` j  @w-J@ \  И@U* Ѧ @Mxg2 UD X f@lMt@izU @U @Ȁ y mǗM, 8 F$ Ah`n@Щ AhIz:@ B ` Ut@ M@{@@ B Ub  @  |v@   ,}Ԁ(@   <~4F@ Ȁ 
@ 5   @ 5  2@4@ M  9@ H Ub  @CB$ :* P d@ЪA1@ڀE$ OhKh@DOhX@z`WM @A @΀j @ Ъ@ J r  j@Ԁ@@ L d  @ @ H@ BT l @ @ @ \ YMUd |@5 @P@ M0 <@\l @ e ^[  ` w V@̚ @T@ n   @*@ n  ̚ @@G@   _G@5 g@ U, @ V d@Up| @D  @T@ < R n U@ ARaMr@ OhOhOhAA  s@ B T h @ "
T@T@ F f  U@ %@a@ 2 N j  jҀ@1T@ ( J p@U @5 Z@ 56 R k@U @0M4@ Z;OMRf@J M@t@ \ Ux  @S<@ b   @Ah"Qx@ Eh` x@՚ T@ X n  U@ @T_@  * N Ur@ S@@ B ` U @S H@ f  5 @@ UN x  @(@@ A  V@ X   @
@t@ N h T Д 5@@ , IM:@HPrWMV@ ^Uf n@v~U @ @܀tJL@ dLhGh" Eh8T\ @e Ah @ 0 X  @ @@ L j  @̀< @   @   b@ p   @z@  Ħ @v@ n   }@ 2 R p @RA@B@@ @ AhA1Uh@t "кOhDOh@
@@ J $ * B UR@D L@^Uv @ƀ@t@ d   @ @ 8 X l @Κ @
@@ F j  @ښ(@z@ v |  @ܦ@ P ^  @ @
@@ 6 Z x @j @@ p   ֚@ `@ `   @즀@ f j  @"T@ H R b@Ur @Ѐ T@Q@ N l  U@ SS@ ^ z U @΀
 OhOhШA :@Zr @Z "" UF \ ~@ո @t@ %` t @ Qa@ D p @д ڦ@@ 8 T ~ @  @ F b r @* @AhU @S@ h  5 @@@ t   @ > j |@ ܦ@@ T j  @  @ V f x *@ 6؀ "T@ v   M@@ r 5  ŀ@ U^   @S"@z@ ~  M ǀ@ d Ք  @(@    T@ Z   M@
@ T ф Bh@qWM @S@ ( ȀU: H@PXU^ f@ntU| @iU @M  @ , 2 @ X@b$r@Ј A5̀@ >  X@ Mj@Ȁ΀U@ L n  j@ȀπȪ@ ^   Қ@"@ p   @
@ X ~ j @@ f   ܦ@Ӏ@ \ R  AB܀ C AhA1)T@e@0XfOhКDOh} UMh ҕ @A @ > H V x@ئ @?@ P@ f   @@ . D ` v@ @@ UV z @ @T@$@ 4 D b U@ S@H@ * 0 U` v@5 @@ U< V p @U @S܀@ 6 P Ur @S,@ p | ՚ @T@ z   U@Ԁ M@ @@  U0 : B@JU\j @U @M@ . U@ R d@v @OhOhOhA@ޚ=@ H* h  @"M @@ N Ut  @Ԁ@@ %P p A%%2@%|@ UX t  @ծ  T@r@ 0 V j U@ M@ @ , U> V \@b@ Uh n t |@U @S @ d  A@ @ x   @ @@ ( \ l ~@ئ @@ b   @뀹@ 4 B T h@nj @"@rj@   <CՂ   :Tt@    S"@ ~    @ pj   2 ` @ƚ@@ j   Y@ l x  @< i V@ 0 UD T@Z`Uf l@rxU~ @U @5 @h@ 0 Mh<T Z$@b x՚@ƀ
T@ 0 N h U@ S  u@ 8 \ U @ĀS@@ J x դ @*TI@    S
H@ b  5 @@ Un   @S" l@ d z U @ԀCB, @ X* j@~A1U@ bOhOh8@Z`n @$PnPm/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Wf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tK_mtE$fu
e0t0t	dp.  f]ZYPSRi uLCSrL&emsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡdmxjwj  :dmtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
^mD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V]m fmff@EFt!hXUgvuN>tO6f뿢]m Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ^mSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVhmu/(` r'(>  4
P  ~
 d+=h䍚0( Q   f3۹ f=bdTt ` 0Q ?x\8ZFfCPO@sw$yyk{s>!
 m"o
d
\Lu@S1?"
K5`,Ku?Z苆FF^Ku FQ~$P_m$G^f ? @s4j2jgH^D	%ÉD	f~:"-fp<v PfUJf@KfffQ$f6f> f	>fBf0+ff]X t p,̐Pԁf_z0R0Ӄf3 cZ`R> t5  A @@!R`0ӳe
@AԟGRV&H:f;tff) F#$Aq$e sqSf qgfÈ>  fù fAB;t)gf+ր C kBPEiQ`?k Ӓ HGPV g ^ h2 ;uБ; ;#b 6P6UoXf.0XR @ y m 	`@  Qo+p+ r3!^B !;P  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXh<fZf_;>+uƴ+fmaPoS puve+i@g+j+a+/xklb+Wznmc+D[XF f sf tf Ȑ![YZ_]e È++0_Q `+ ^mP^m j0fdqtu!+! !ddfdm԰  >P6Sd ddSP (++ fUw0t=T=f]t,>@u%ttt t	tfN 0Et@)r@ua`^ln)s
 1Qh 6OuFk . u$
VێeS tOrtـ?иD`*f{dfeT fffXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+OfWpe*&|+8fw*fF*2t*܊e&}+fX{Af`PK`m)'*!(++ a]?"U  Āu(!`v]+6R p(Qz?faSQVWU&_m t_m i]aLS-120ZIPo 250 RV:*1:o2:p2o2PKp
>w
 z
\5	d+?>?s!hE_rg;<tV< uWQ/f< Q:D= uFfGW(*X!X  A0`u v+Qamo+i+p+j +a+0 RW1?h.
N} tE?A/'_Z[M-Sys   Dis?kOnKey 1 #axBbm u @  f<x fP f0Q1"%|= 2r 0w"1s ȧsU3IH tRfQf@fPuLst6Lu2r)g&	ug&g&c\,f_ PA߉ rLTf<?GQkRlRbV`cF5Qome}?';0hNt@ u u#P-3RAf?LcfHS N 
1fXu׫?D0 @0zB0c*B0nB0mB0cG05F6F 	 ?&3FPRrco3W~1>#>;!2>
y>_YhMPhN`p&P  h]0l zZXSW` 1s!$?
u$˄[          Ұ,X @x^0 uY rTB5!0c@  i|X  t   `Z 	bho4<fH f5f0cf&^huf^06.f ff5ofP  5f%@׭% @ B5f  z6f5f=A&  ` AV_faDf=%t 5t;@3tZ0_tZ鑠D_fX$g];6  5I5S~f@ wt|P5"sƑ tDf q55<5f>5 u ` _D  2ft.?0c@P +rfu$5@s11 >5@!R05'Vr"b"0  1VC@fy,S	  tX>	*rH'	"	0 
%9 uf-%tq00 VP35P  	P5);t\pa '	5> ;  rf 
 pQDP:؊*5@6Pf>5gGf	gOg{G]`db>!:"3	0	5
ȭ`6@#Du	%&0cf65f	f 5fIng^g~W!
^*t4h ?0		0	{  FFhjJԆ<t
 &FK5q*pB9u
 'X*؃ C@K&BK5&DKqN&]jbL6%@( 5f (f 42a3uf5W  bft0awSgff95u gF95u 95u
gF95tgHNyXfF5zr=БC=0rxiGsVfS'`c(gF'	5g^ g"G0gF: V* /e*emd&b&g&g&G
0G
 dЪwGd*PGg&Gg&G
 G 3gn Fzpp5t	f AkG^ 0\PfV csf@md{f p^fIf!5&55+5(5  5 < t5  ;vȉ5ܠqv  f@
Bqygf=gG p ,gG
	qGfu"a ?Hf%fE@ !gG!&55 t@bk!f#pFcn`_OBL'PR7з[fS
f3Vf$fӃ\Qfp#{- 1 !Si y 9tt ``U``a`bI	`c	0]	p0^	  
		 
			 				
| 0hfWQf˹`!?Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r% >q+bASes?+rI`d
Qr7R|= USBSug&|= t t
U	 	`+cTZ +wQޡ p arQrY C0& %{rP`6@`2P>+t QrIt2QfF`AdYrϟSf1fM^!WސA@@H\
؀e܋\b< H
p*rA
x @
`0
!?
0
"osTq
aWa'"CS# iD=q8p*W.?4o3'PfT2_' 7/oZ(Z
2(
_7
_=%t9I R$RS$2Q	@ ?VE?B@RP2 3* h >Ou ᠅ T=
XS<(fT= & y#j6~+~+~ r}fPQtA3`>|+|+p+` pta^Vu6} }+ +.ZEf.6VEOPpYfX`VEI|G<`+ fa}9?,B3U+*/G/%QfPfph`1@YfXY"N0\J?;׸G7/Osc`MoDABA<e=S$l=38%rp-+Ot9 OtE OtQ+D$
ƈDFP!r r
9rY⹖ /p%tFPtt=tT= t2:t+u:u hNodty(u~(诚rt{^@O=@tO=tO=`	tO= Oh.)6`oXaPSV+8dtd}mޠrgހoa޾+8DtD$PQ@HPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
  	|b.>  
x   UKUKo      2@SJ[PuK&|KО!d$ru
>uK * | > X * t|KxKxK>xKuKu UK{Fϰ'PSCrzK$zzzOKuKQK?wKΓQ	`P*$ƹ`
3ۊ `"K&K&K L3Ǿ wKpVS]m@t	V5m[^@pV^mTK "`K1?m!f4 uՀuq!S1-mNKBMm68Հ_m[^pqq?fU >^mdmS>L>dm܊&L_mt(
ߠRK^mZ SKK[7@vf]AA`Ft>}K{K r1K=w%0or
 "^m~6x҈0^EUK hh6bKdhEYQ!R)j `% ?aӀQ	f 胢pt1Kh[L!rL&emSKdmLfPSQзKf3foY[fR~Kff3 u0prfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >Ȁ$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO>L`O4<qurYiVW@ξ HtAQ Zft(PǴ:LOu 
  gXfCYPqq q9~ w2LkYⷠLDt& L8r >t}aRw
$_^t0%GKLK IKf? t<CpR<?tSQLذ&Y[߀ u
l/qpJ@I - n Oig8 w  `  8th
   0  Jp 	 	 	 
		 
							
 

 > fWQf04aQY`f D5 ,+6]++sR (,+z0SD
$&++
ĈD
π 1s f}g&|5 EBr`jr  a`fR)j)	\		7MvR`U|R		`RH\
|*+
܉\*se bSQoaS>ϼ" cc͐Ăr`׏͏͈-̈́&p_W3
	#rugqWt0Y"@ fU_Դj(rjddu6Dq=U߱UUpfq?h		Yv		xvbbF
 T `&ӹ !sJ%|=td%"y:Cur?rpq!(?~rg`2oQVfRL	;t	ϮPAϦ==}^A Q0   0    RrE d    n  }A` P 00 3`U  
& Aa %  		%
0 #
ک*!
W 
3`@& <@a` @A@ @
b
	CF
? ?a	 "  d q a	!?  % %@%Q
 +3F	

 + (PE+
3$ 4̂ C8$ +(3+-E-( C -0294 - (`(E E3  .c+! 0
 @ /9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
QT S<R"G 3D%M TVaXCJ UK8'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<tS^f&^2c sf^   uh ~  uRRf|ADf380=ISGuђ s
g]^!t避 f6^	ngftcRa tpt5H0c @u  u u0 ߰}# 2  Pg f%ᘅ3 
f>5fDt	u)f57;5wuf@ffhj|tfOf"Qtpѣ
0f1s
B  4v@#tz210!<ug


7	u\	Q	'hk/$_5Kfo65	g u%S F5 s@[%;u!,f=4R0	ff4	)fgfp	Q(f	f@f[aSfSfQfRfV*sW2c15 uBT tApN@76g88fI4g^f3f@70@7f^fZfYf[fP"Vf
5f=}`Bt"f=Ё &f= 0//f{=0 3f=@+=t8t34 , 't"#
ttf5c0 rfFP0fXURf.  fXr{  	 QfpufQD8@M TR2@(2Of2f0cBZ{RO>V\3h0(W Q  uof3^fbDf6E  Z<tatG@]_ToKg<u	@upWJ$< t<0t$ RHP?y"UPWT%j_uPlAP#,RfWPR;5rfc%1f f{>a-	f!Effg8Wu#>_444
f@[Jsf_,,PSt{wO&1=`Q
Yr;f.;ft3UufOf!mpf|ffm fPtP= v	 +v:P,P}ff́   :ffvP ̠ 6f1|Ã tL;f ǰ;Ptƿf Q.fB	rMrf@u0`b h1-Ña	rffqp
>	_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gf$   hi쀀1"̘`W, 
`П..`B@ԑ
>t1a   #  U mP A :Pnj>jFjNjVj^jfjMSV.>]m tvJj^>Q PSQRVW>vjujSRP#u<v
;wj,xjdmuj 7UmG r ) s!ujјP込S	%x
vjvjvj:ujw/:jP
 hNٙ/L	c tOde
	jjrg&0tRj觴}rZj莴drէ!"BjuKr
 JthE	/CZp4tbj&=2ohs13
	u^mP $^mx Xp Z#,莶[$=$_^ZYe**	Q  !\   0  " "2ѷȰ.fLA+1L '=m)7g&a* 	uwjwj |LKm &EmJ" ,@v@ō -s0I0[Kmt,$/3 Pɀ%@1uU> &
'Q$u_muvtueu^w\uMu:8FPu)ttfu1= _ILfg&8!`<u	g& =FtF@sPVS@m类'X[^XSRVm?Wl^_;_Cݕ19ZUf*֫p)虴Z]ก)R ZoRU  ?oP&ab{pZ& &Fd@R< u}q\R[RgtXwr),uSRG`SQr9R'$8t܋YQtr$VO㰆HAr(gFr{(!sq^trp@۴ppq9`~s Ќf8 f܀?g'yA@    FFBZ,ss`b PQfWfVUUp~*P U hX+6a@U'UG@J .;qt3p_YXh s `#Ⱥ0@{	 ] AE '
 cC.dm	2P).qÁ q0? PAgW
f5Ugg& suf3Ɋfl@ȯtfY VfW~g<t,fUgR r8tfG ^fZPQQ$@? @8tqrUvP]tF X PSR&Jtp Ht؎[XPSrJtaA f/0SR P ĲEð?ð1                                                                                                                                                                                                                                                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              -                        i ` 00   ɀ$ t
T  a`/ u B KSRP t@B u$Z[SfQWP @ Xgg_fY[f`Q
`afgfafQRfWPSf3f3ɿ f0<  P tf; X tDt [Xf_ZfYù@ fPffffX,wfVfVf   E gߤf^! fU^	V					:		 	^		f	W		_fWf	_}
g&' f @f&f_ÿfPSQWV!  tOtъ#-"A$-hfP u	fXc  h TlQ sY^_Y[fX>ְuD=[fS`f%2tE p  p 6Rho`t LQ | :q(f3f g&G4g&tCff&fft.fA fA (  u1 D zghQ)
 I   3`mdmoh+
a)a@$b#4c3P`(S P%apRp{p  PZPQ7	3	CuJpybqĳysY p3YR1	dm h&Z*A~/.&. t...gw&'Uȳ +`Q.t1*0`V SbS0QXk`߸   nBnnntnJFn aS f> 3ێ7!C &?!Cu3ۏR .Z!jhMMqjPIj赘XY٘ʪL%衭&II襪˕x>&lcu	puàZ/9
 Uu9/t1+t8QWP3 PXhX@.X=X@uX_YPBPup$ q?!\.$> u
Px&@Xuð6_C @B T AgfSQglg tHu.g :fPYg&ffWWk1kfffߋgff?fYbI<(.&sgBfsDP
ghi!o
|wq4	fRc6U? t J

(
uXڵO0fZ~SQ2oA  t@puVp Up Y[Xhety`8P%,Ⱥ:#%j  t
ف    z t(  UXt
 %@  Pé t u>u 
q  3%tNR2tG  f1Eff3ujT}ff#f  
fΑ*1
 X`R.a#؁O "Ӓ1u#f@  r! t%%Q# Y3#f` Z1Qt1
h P6us˳`Q# `uZ
 pSp0;"
;""m{tq% lQ Àff#$ 5 1q 0qKPR 
s q@RfQ !s!3#uٌ7u
 ɴ"q׋fu.S!4PKS
"T T?!h~O:%<5,͊2h`f fg&R Z 5  -_!4=T-s!#$30F!؀ /@uR3!tt@t
1V+!3% ruf
eߐ"0`=L a rS)[C vS3ۀ> t޶tQ)t:Q)pwC P#[0׶t<w>C8t7 
 
oñ  S r 茶t,} KQ #u))4z)-
Yt r"5>PnfP	yRA)rA aҵ	 fX t3ǪĪwP	4Ӂ@۵t1-w&㋇}).9rwRat0
w&^H< t?
I:@ 0o ۘ)>@u_dt)aÉ  HQ=

p`}I0~J@؃?@P2c
s3y@si  Y 1g
1F0^ " J:u;npu;thPHH-!M ww
210lr &	&
À
v >Ͱ2  22<fRVhND>ttDh^Thfh1hrr f^fZf`92 rb"} <fTg
hMfa贯f`}X
RofVfWФ3//8fXf_f!7"" Ϭh륿${Qf`/)
4/O
 "	 	+ a	"	/	(	
&!_!!|!p!hoNhwG	ͭfzfк`u2Rt F<tvP$rfѠZR_tsQVWtp 0  _^l }Tf  DfdC1ڢfބt
t^p%Sܖpy?vӼ3fZpfpfWpWVhZ?r=t
 t
u	  tt uʋ^_Qf0WV	:Eb3:EF c6W p 2:> u6 GHt\o ?hl/T3Ҭ؋htB^_fZff
zXK̈́
>
/2

VTk>T2@OHp
Nt.
OrY򍒎Pn/ ao/ / /  O<RwS2.[/ø ' а?fQh?6Yb;aEf3ɋPp`pXA&G     &Wf&t ffBf;Pg&Gfwwm~rtwRtpff@hp3QgfY tghom&eAX0Y[0U>aPS 2hįWh`2f[ +t7> uV $>p u00~` ޜb_+!蠦~Χt蟦2#迻tP Os ?`tx (s>Pp 2YduqQ>_Sx$YhP`ϟu9 56r/<t+t&u
$ÿ&à?.
a@prڦt"!tq2t ɸ_g&G Q !pvl蓤u蝣1袸u>觷`v&߀}pr_@r_ j u             !!!%!0!;!F!Q!\!g!r!P`kt~Sdiq|JPSV]brJ\^inpEQU[`duVY iEHKQTZl@NSVY]pVagntxEMSY^dyJUY^ai{DGJOQVbt@5Ш	@DHLPSYdБ ]`tR]l]p|HMT`dlR]pPY]`dhydl dhp _~!à@ PP way`R,:%  3` ZQaN󓿯  ࡛=Yf 33 30" : &""
z01f7 
8s J 5 
tV$<
v
ط  8 tǀ>! t #$
ؐ 7h|$0D
d t㋷+ ؊ ^qhEo

pQd		
s	 迎ÀHxu !&!t !!>! u
8wnO
谨gA Bb ff@B]f   f@fġ Q^Zm' @/%^Ph >?ft	~!f%r W@ѽG/ X<t<t<PS$<w .0$B 
R#C   6   $` na % 
a  S!	[ +%f fg.9ug.Rf+  f$fף+   "1 ?
0Ψ0`0$ ]t  `f&`ff3f  ofPa帜;f<) 9  <w  a fXff
phEuG
	 pf  \P
ĳIPXu2BD|Vbk
S! ouc2N
 _'
 [Z;2P }#
X	{	@2aP2 Cˀa	$

1Àu	<X[XQp)Qa`Ea
2t qP@<KrKeX PRϢ&Z .& BZ s  ""
ZPD-'p-' Jq vJúBQ R (
PBX
	 ذ4afQSW 08_[ A    
@|f mff'15IUfFa-  R`-"u_fNT!t"fffvfXfDi HfpfufC0f M "  0f ffc5@ +f!` T  l
 
BQqW8PÐϐա  1"o"a)% '^  ^ 	
{% 2-a-AC    a1,+!h1 +"OƑ! 7)))))1
,1"y , l	)% `I0.&,.>p4I薉?  h/u MIGQW<u
aay{ {@_+z |!~ðXhϩѰ޻  l$c `i
 I  +&1  | +f`S_1't5gfq5++_fkikk- fa3_CTNI _+ 4q:0/f(|f+3qf+ >ͱ++2 s k2c+UV<2 2 Pظ Yg$P\ l^[.>}!p^]{2 	?osP tiu%th4u~p<tr7,;
N, `@u`
g 
 e@ւ,8q@k0kp-S r3.-0vCr춖i.t @视rohu_`hοfx=Ohd2f.f`7Pf.q qZh/?> 1;<r跿k. b l= oh菝u@ph...1
03!4W+t
3NO+t3GN߬O0UN...&N.P aT.SR.``  A$fӃ*[QXТfpfXܞfX*fX>ahNhd`tW LQ | 谼% (Ruuu&gq q  C|4?[hl_e$PѵX! hyeh(suvP0F X PS&0&0&0[XPS200	0^R^5{ƀ͢P`[g1A&g1g1轖Uk^XO<H8;~:pi?^G0Pa U 蹁XJ8<S8rddrS<drp
dO2 ht3PSt苧 蚭`ʸp2Kb肭kUΊ&艈X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  < 4!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( X.(     ښ U   ς  g `g ; h }  Za  ;p    / 5hք 6( wj75* AS          P          %X%H _&                                                                                    `*} ` PzQT@    U@ U	@
 U
@P UX@Yhi Uj@klm n@o { U@    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`h.fPu	fXc  h  fUf&af&o>` 6a  !žX[ &SP`@ /'a&&@r
f3f僰gf祸 }f3fh   @p h &yïf`f1fff_ef  ս % ŀ-ff0M00!0)ffXf9ffaf 
  Wfi@] 0 m q  ,f5q f{PeP ՁQ   ͡Ap  A` e_faa  !6>eуp Ń wPك"` eɃ w	
e} fe&` b "jeffefAffgd:ugdfepf3 gC)T "8fF3ۊde3 
td	  >p) @ 
peuxu._RTC u:/
'
%&bfgfd.S` [WP9A`XP&EX% &߈E_YǓ oooooc׎B|Mf`ffP fSIMWuUfg0f[ Qbr6ώfc;ڟw(h,UfK;fap p`p f&?SECUtC)fuDfQpR Phl\g&XofG' 
uRf%38 Su(vg&_-$8GAxt| 	Gt+SƠ
 נTT<tTtwh~( R"L@	=p3%=u 	 =
=uwfbEOFF@ Ȁ "/ffw	fZn& t
fWf>f_r2 f$g&P fg&	rSfQfR` fGtt2t~tyf  o f!f,0 t;fm@ 1^u-f rFf;r>1*: t, f {ur%ArQYQ	 f_fZfYf[Ԁ   t}% 
tR`A
A!:0._2 r&4"

rlr6SV9rP#j   t
ff;t;0
 + t WD@@D)^fZY@ =pFh^1hf`t kLQ | rwp	߾	F u ff!` B
fffLp 


ghghNRN
@fPh1hL	fX
%3E# 
t3 v0)Q%pJhq/WG!V< t6<{t13_:u"FRj*:+p;) .fY (7~@ w.	A_S 
fUfp>t	--


f;+ f
$f]^$*##^# -gkoXvPK? Cn@u߀%fzn  '  
Pg$$$$$YcXW@Unr]oV-]Q ]E#]^fRgw&gth}oTr>Oz`Q hxg&	hv
AfZfVfRQp&z E mffҠUff[!>  S3˹5(FffZo! f 
߄
Q,/Y]^RfVQS&>f"
 BO9BtЃ#уhHTQ   7___ [Yf ^`V/#W	
 R uB@  `RQ2Lr+POG 
 ` 
j m0_WVSQ  2ۊ0WF+ؾ8u `&
`YY[^_fPWQtPX"gY_fX1E   Z f`/ffYt$Yp$ŪYr  .d
../W NA NfaSRV fpr؀tU./tA
 NUNh+tG^Z[fPp4hӣ_J> t mU`pP"{ Dt t[D {f eGB zf@@{߿ f_4{ @({ ^{b   
{S  zDWzRzPzz~zWUVU,0f!wz hsN \ryЎ@vff$  D)cRbyS!ʗDqyyf3݊fȊp  j1qЇgy[ Oy CH7S
w+A_xf1)R"@x& x%x!xnx (辪XSQf[`蚘U HvjU4Q"^8R	iF	':	w01!-h!c&	P 	xaú I!fGK=js82/P`WY_pX 
 ? PRBZ B撀$ `%>&%	 
  3  t!  {} !Q" @Hu#"?2hG/ILtRW0?_Pr =
? gR8q%fZePR0fP f&T ffX@  !cqc
/f? fhW`@1wWw w!w0w1w2w w waÿP hi@@Uf[ѹt"g&Gbg&Gbu& uf  Mκ( 
pu"` =;K22oxu 1* : ,Ri2R1p_ZP ,ȡ%*؁ Ëw34p 2 nD4`}*
 <p. 1b"0h!qf`m1_f2ѧ% Pm:0p!P!q +or2 =0XX!f`fgff%Ƞ?gffP p*
 `xpC  CBп"a
!0J^Ŧٿf`/mPa  6&P& I` X >v
``.f&r&&`r!Br PX
䏀  PfhEDa HXH10u쨀t݁	<u !<u õr$Rr n&&=2䑵rr]rNn a`z7da(SvxБQ}`0p("" QYaDP  r&&;A Ob 
yj' P"S""F"&&=a <UbR ~ ZQRr3'H2't2ZY`2ٵ?`T5߀ tؾ'TZYa~r#S-ER-Y03pٸ q4 ~เ f & &E{ZP 2p^&r豂r8t32P`.;&EO h?,.<tGS 1?h[&M.=2tð$8 	#h 5PƿW -Ƌ4}fRַ2ɏfZr v~@w@5 &E
, w#! ]	A	o2ahl
D%00`P 0丨S%-A  DZ`6(    pV魆į^`W| 3 _r- + fPD;Հ B}Bˊ O B<`<2rruO0W2&*G_YS	 7&*,u&}Zu&E_[DAP`QFگ>  0 2ۃ<OtY	B<tmHێ7P77rPBBLѯ: r1 r,q h/cd!SQk
pqlat)u$<Pt+fhKuҴhQpB`UY[Qn @qj"yjuBAuYoof0P	V_ o^W mQfR hN?vtD=F==rN|UtGV !m4^t1Vh_~5f^Df`  D ; Z x     0Nm=$
pd_u	q 42^vX]ҏ	c H葃ȃIذJx2ȉÜ' 09BOSQRfRBP' w	.Z0"+{a  + )aʏ$t=2+``|r *w0h5rEϰd/(#/J+('1*f(fYïʥRhgihmlQf>QPH_u(DЇ/= fP ݖ -Wr(qQP-rofRfVfWp(>f1t 3 tf40Z f7Rff!2g&g
fKf{Rg` g{re h.5rA  ܂VhZ,
-f_f^fZfYf[ rP sR?fbSfRj07W6uLt;wEf6fQHf8 rO/f`bpBfg&rf`b0  Z[XfWu
 > Àff`g@? t] t
t@fO?
 :'  `) _ 0f` ; 6frv`gGwf3۰ fPfcfPr:p> ff0;w!fVg&f^ufFtsf!Q. $pf_t Qg&$9R<&m<f=ATADtlf q:&Ǉ  p s  S3a  Q~bց I~1 D 0~3ɊȐFj q~UF?WP3J XU .>I  z ub >u `	~`	oh}p$l0r}O}$Y}C_M-/S+`r[P<@050+PQ>(ι c r\d`1PAtC>r-t`w r uҊ1 r
-`u`dt[Q rdItf s`A$P3fSRNr&r!ww3҆r r	 8fPRcq`awreeQQOQ qPQ|q	s
d pr	?rqUV>R5f   dgfY{uwR Z }h`YkzC Z`.P\ P " Y~p `2耡p",u   P 繈jR

Z@u
S* o _rQ(`(o ]PS 0; 1' oRWR  rXDC	$ 4P>tS t33}ېJ*bjR
t#4 c ttQǇ  PQRWV''+3"~a^_Z$"#Ϡ[1$G_<uo${V! 4^W _ "  !(3 	
R
q0tJ@y
g3&/ܱ1q;-r r:t;ѡPR(X0aJ2u RVа$rN ;rCr<,	r32Wtrr;w0s^ZW
   0u
˾   
u P f! uf _2 J332[2t@@ 0 	rn
$	"
ſuƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_.....^.6 .R.D^@VPC菹E n `n     `      $ ( < D T ` d h         ` ܤaHa b  "ܠ@H P X \C  HT2 3L 4 5N0@A`1.?D                      M         14    aXYhijklmno 	

                  Z ,89:6NNOI O?hX?5SfW #VtVػP/Xf#ׁ'f@ <	& (a̠ܿ4ـދg&Wf0QfRVWi fk Q  !Q i A!!ȑf%]3f.2fffu_^fZնf"Q ء f' ]
f0eP3XPSVWfQs:۾Nي t
u ufufpv f  fY_^[XqQfWfVf䷽  1zf  ЀI.00_ROBKIu  P1Pn( ;	*
	
Qq3 Sot-`븐A"fKf  S_Ya.KfUf.6Sf]3f]** End SetActiveDisplays: \ R$nt5< up)㋗[߸d_;t  _um AZ7Ӹg @t0uQ2tN
͋ك{Y  m@t P< t  QO
i p
R 13t`Wp $ D ppaUB
ֿ "P=İn>	tR	g>9P qbP(bP$ bsbċ؀ rbXjbXPbÀPSR7IZHC;w!bZR``b tA0bP À@aXaQRPSa[X3е=a B"c
rp |YK f`09߿bŸKOu$X\r
u.2*q	,r0$p&` E&] @ _ffa.A4H11???LTSQ/"S [?fWU]^31SW_Pð? ѓ  Ѱ rH r0iPtp	`WBOftupOAC_D]f`f>f ; tސDffR fa`k_<_qfgf2gaЀuQutQ SPQ$~X	[ fp Ɗ6qHȎt/O  3  v ؍`qy$at-`ZONFa<@C OOw_ B  4 4Yu$$t$
$$"h1s/`9t4>0t,PQz uXa<^ 6 <} i <2<
 1                                                               UPRPRVFZX0RR30ZO                               t .͋hR3 \ѕ爐v֤ hpn Pf܂m4fXf XU hN_Tt
   aҋPf  _԰|2ӎ҉	S  "pi S zJ%yª VC HكIڄ3밒NXrf f+fMlh/$ff-EfAq  f>PAMSuff>r^0
PwS!0 P豻`PX10 fHѣ|	2% %fP&b0WVf1hf`t LQ | rY  E6fP  hgh-rk f f7h1h^A&
00.rB A2@
E<?u@
OP04
`v?f`tؾ(A"aN]"EQ@r&=t&}V" &GF^YՃ"\ؾԭq; 	ϰ hyC
s!
"9
'
Z
'P 
U  h@ Z@PRغ0 t߃@Zru<w	)$<w	])b+詿: SfW> tU`uR uIcB<t>pt9 2ok r-f'r!\H Mtg&G!P _  Of_qQpMtZgf&gtK r3 s0Q$
O Opf 2YqPG"4rLtt0 	
   SQVȾ	J0 8t"8tr8^Y[A	t,&
u>0ut
$gsE@t> u.Iþ"t$	&
(s@  P
tqp$	>!2
XnlbtZ JT6au.7=otCƠ ƠP L< 3tP'$ Ua>ý؀
	 t Ht_0PT'uTg *r$- t> uBu
 Ki  (r"1Wt~ ZJbSQPX*tV
r0."GbJtBv0D0.轟r//Y=6Jt_6tP {rB豽36bsPGu%
߀u "786 j56cC$Ktzu TWc/tb!;sW;sQa.Wu	5Mu u"
uPF"
23W\5  àڢv5tIt* 5)P!(tXSfW@0`
Ht`D_8؊f_[W֌f@sg]'  rC
BQÐ# fPRfQfS@\ff%|h f
 1 Ⱥ4A# uOf3\fQt(,#%9tp !!t1 f=0 t0f.ߗfEf f[fYZ Z! %܂"@B݋CfW T u8  *t 0	)ff_À Gf<Zu& ?wGryG p/<F@ h^f֠`Rҿ{ KpP Df`ж%
+  ú:ckt.fP@# A܇ȑ  D1P_úd7 u"vM "  t 	Tf@ @f/tpȐE ـ@g&||`% &7!#V۰MR%0(+1#lA~R-,f#f0%+2ރ86` $B't
`8wf 3Q'
f~:pZS	":> Pw''6p
f2130ޠ
s,!=qrfYfĳ & A%#@3BS؁@SCV@p#t6& %f&ȿ fڿfP]t33u^Zfp
Q3X3t@s7OrS
`'`' h%SR 
 * 4$0*ZD0T0	f%0O̰`R3&$R P1T؃2沱1BRfZ/ 
E$!fEg倠 CWK 11#"cDoϝ`_-Ҝ/*W77(lO1tuk;	Fȱj/<of.:!߀u<zw2`оf&@2^S_&ذsBNr;NX&([+ێP4!;x_V4t? {u+_q,[f{f[ b:LPJ3L@w؎@tA.' u6ʪ`1Rffhfƌs
R2|8>.h gr0fA@fPB 6fAlqm	sdr
hC1hzPs6GjhiIr d @ h$sx0WfV"D p/{TtfN!SYP`R&[pZqf^ R_'i!Q,ZsՏ#
Hvà;0/ABSOLUTEWfQPg&
0tffg&tXc_f^PQ9ۀ`0
YXPB8u  `Jq<yRf¿쨀u Zlfa`Jnh
 p@(0EzPtEf up D  &Et"D  $D[(*s `فK&t{ɿ 4>2@"۰Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m 
 Gm p-'s 0a` aװr * $OQa	 & ap1P# $$<@t"hXfP 	fXc  h Ku3KfS8Kuף`.>R#st&3r	&*qr>
⿶aô`prr X _? trCp0}qߝw1#?Q909$<a0){fRQS[YfZt'1vvv
߀| aY0*
ADȁmG>  By ? ht=rufPvrffC}׸ } fSr<fffHff#f+ִ f;wfѡ3g&Sc
uff+f듺qS} P,.028pGqQ lMy/-&
5t	&
G7/9â H^sbt]`Ⱥ@ t  q&au x  
|  Q  7tR P ffXffߣfȰ4ܱ  ( ` 
P."" fQR6K= 33 #ff?f
 
a@]f [ǃ$%\h0Pf+cp`0O   ArS a)f]rӸ CϨthndpQa!% = u5
<= u= P܃`܋![2f;aRPf3fM 9Mt} 33j) (P1 UQ   ,A04q8 b`4P#`5 A Aq fshHH2Hȑ3 tfP  f4q R'qDc'!X/,,&    i%,-./01289OH     N`a-׿㿹/RFAn_$a!PFe=G{3""
PA[2t*0 t`>0l>l!GA lBla}6$?C0! G @ Ap{ B  $0sF   =n 诀"=  BnnnJF$a %JF P <\ tq P ̠̡;ޢ<   llB  ؿ lBB@&_ l@  Ղ  @ l9п:N&ľ'-3 /$а 
_@  
FFn T 	n	n	n	Un	n	n	nnn 
 9: t?a   ͲCd̀㈂`  3nnC q
p		 nA
` nw;`4<q 	`\QIJ[0[R' +` pp Q6+Qvf=HIBM+@ {u_wFfQf+ g.9u
g.RFf0zF v"Sf= @t101Uu  øUPJQ Paz| 1 NuFgf~fVf  t
ffBffʷf
"yf fgăQf~#F$AV f;s	7f
`@ fV2 1~(F!+s
	@Nf;sfmȢF@	rf@ @ tz!qfFfGg^N &Vf A=uTAA<ufIg:!g
@tT	f@f7Á  ;f                                                              )O 1\ dBk          w  p                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                E   
 B440UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   <             TPM     
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  nByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   i#fsf ff   fT   #fsf wfD   f @#fsf [#fsf 5#fsf #fsf c#fsf M$fsf 7$fsf !3$fsf I$fsf 7Y$fsf o$fsf 3	$fsf 	$fsf 
$fsf F
f   t$fsf c
n$fsf xX$fsf 
BnnfLg&nffOg&fffsf fsf f   f   ^%fsf f~fsw%fsf ef   %fsf F<|%fsf  6%fsf j%fsf %fsf %fsf x%fsf =f   t&fsf &&fsf of   t?&fsf hO&fsf _&fsf So&fsf &fsf &f   u&fsf "&fsf &fsf Y&&fsf &fsf )'&fsf L'&fsf 'f   'fsf <w"'fsf 4 f%"f   t
fp鞬f  ^'fsf {ta$f  |'fsf ;tuf  'fsf Df  'fsf    Iuf  'fsf f fsff   f   f   (fsf tff Ag&ufF(fsf &r8u:^(fsf &u$f3f   u
ffuf   tf fsf   (fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  4)fsf $f  N)fsf isf  g)fsf rf  )fsf 6   Iu f fsf   ffuf)fsf %tf   ))fsf $8uf   uffuf fsff   ftL4*fsf $f   t$<t)<t/^*fsf $ufffff   uf fsff   ft(
*fsf 8$<t<tfffff   uf fsf   t8f   ft+fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   t_O[O0f   +fsf $t<tff @   f +fsf "2  +-.,fsf "<  ff   f.:w .DN,fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2gOff   f
.f   2f   f   ft/^-fsf !< t8stff   uffff fs2gOff   f
.f   2f   ft(-fsf  < t8stff   uff ff fs2gOff   f
.f   2f   ft(b.fsf  < t8stff   uffff fsf   f    ft'.fsf $ $t<s
f   <tff   ufff fsf   ft/fsf uff   uf fs2gOff   f
.f   2f   ft($v/fsf m< t8stff   uf?fff fsfffsf fsf 2gOff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%GZf   t?Z.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfkO2.<u f   t2kf   uff   uT1fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   1fsf <|f`Agf&   f    f    f   22fsf f    f    3f   ftc2fsf Ufft}2fsf ;fft2fsf !fft2fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   @3fsf <|g&f~fsf fsfLf   f3f3ftr2f   t3fsf Qtf˰3fsf 5<	rIа3fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf8Z.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf fY  f Lgf&fftfY  f~fsffHfuff Lgf&f   ftf@,7fsf f Lgf&fftfY  f   tfY  fY  f   tfY  f Lgf&fpffHf   tfHf~fs7fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	m8fsf fBgf&8fsf  8fsf  Off%   f
fHf   t
.f@Cg&Off%   f
fHf   t
.fCg&fKgf&	9fsf Ff fssOff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fs侸Off%   f
fHf   tOfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}Z.fDg&(Zσ.fDg&.DfDg&f3Of   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`Vf~fsfffsf fsf f Ef   .@ fffsf fsf Rfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@=fsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
OZfHf   t[ZfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	sZf   tZf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
HZf.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fMC  mCfffsf fsf f 8Z.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf<Z  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   8Cfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfO  f Lgf&f   tfO  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&fZ  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f+[  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afALf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   BMfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Nfsf ,$f  Nfsf f fs <f fsfffsf fsf  fӇ.WOfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  [fsf Ű < urf   [fsf $<  <t<t
<t xfNgf&f   uf   C\fsf $p2<uB >tHH3f  s\fsf fƳ 
f  \fsf *Ż  f  \fsf Ű < uHf   \fsf $` < te<t
<t UfNgf&f   uB >tHH3f  ]fsf ų
f  /]fsf Ļ  f  K]fsf $
f  e]fsf Rf  {]fsf ^$w<u|f   ]fsf B<|2f  ]fsf (f  ]fsf 0f  ]fsf $f  ]fsf f  ^fsf ĳ

f  -^fsf Àf  F^fsf qÀf  _^fsf Xf~fsf fs            f   ff   2fff   ff3_.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2_g          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE            D   @    L       @       H         `      |   @ Ď    Ď    T    G       	 		 		       
H@ ,@          	  	    @      
B  T     L     	 D    P   X     `  D    X      P    `                O    O    
O  

O  
O  	O A    A    
@          
  @      I         	04
B1e2  
D12  
H12  
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @  @
	 	P	P 	P0		 	0	T
	t         @  4  	4,  <	    , <	     <	    ,<	    ,<	    ,<	    ,<	    	,<	    	 T <	    , <	    ,0<	    ,<	    ,<	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                      0                    	4 @       T                          d  ` h  $X  `  '      @@             A   \   Z 	  X 	     ?                      !    8       ,      (  *  .           ,   :  8    h   d   f     !    N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N                  0              <fU@f%f  $f$
tppqtrffupppppq#ffupppppqf   fff   tfff  f  gffLggf^gfnf    f
   "⌰fFOfupppppqg- fo&ffff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = uf"sf f7^f %  fSBfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰ff䎊ffff掺<uf2cf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
и f  7f  7對 f    < tg 68DTD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 s& f    Q7sY 戰f-  ff   f   tf ff-  rfBYf戰YgC+!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3^f  f   f戰fSo#f[f   f   3f   f  戰g&A#fFfCg戰k 撰fPfSfQf   fQf3یff-  fYsfYf[fXSgu-  ;u[fPfSfQfRfWf   f3یff-  	 ofBf   +f3g}-    fg-  r%fG;wg}-  f_fZfYf[fX                                  	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR "Z[XPSR  C v
 r"Z[XfPf   .>fu	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
kÈD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4j hf`  fg&Ft$!vugf&>tgf&6f٢jð &f ~f^Y[fXPSRfV tA % kg&ƅ    f  q\g&  	uf^Z[XPSRfV tA % kg&ƅ    f  qg&  	uf^Z[XPSR   <   ! Z[XSR  ~C vZ[PSRRZZ[XÃ<t      PRt)t<ZXfPfSQfRV%&  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v [   qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  fA vY[fXf` f;.bt
f.ba   $C vf3 
 f    fgf&E   >a uFa f  gf;tgf+gfkf0fp  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f  q <  f  yg&"  @v@ g&  s f  y>j u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       ' p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        戰䈽j{戰䈽UȰffvŰffǰffgf%pf/ f%"fGNfQýWǰfc2fmHfyf Ȱffǰff f
   `"	f   f3f30f  0ffeOf   f f    0f  f f   0	 f%"f$qff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f. f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf   a!Uus  6
  >rfg   ( r  . V>Mff<>3fffrrfff> wf   >ff%f3fff> trf> wf   >/>m>dff   fF>=,>#>	ff  > ff'f
r$fff> trf> wѰf    } >urd>u]R	 D>u=/>u(f ]  >	r  KI	s 撰 XÌֵ֛Keׄ׫erx؍؟حfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzyt7
sfZf[fXúz.yu
sfZf[fXPR tĺZXfSfRf@
 > uB ;yM@ts(xغz,y0@usz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>l tVg&4  g&;  ĀuH g&  vl f  G efp  hø%faPSQV ۋL	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 mf6ûjs>mt fafWf   g&D= g&D= f_`r r8 a`f   gF
$&n
gF
&nûsw>mtaf`f  gF
$&p
gF
&pûs@f  g&|5  t>mtVfarfWr<f_    f`fiݴf   g&D= (fgf&T=fg&D=rL6ff G fr6QfPf   f>iݹ gf&D5 gf&fff>ifXYsufa`f  &nù gF
$
gF
f  sF>mtma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! ssô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f     f&  	  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgvf  g'gGgf_ZQ`QfPfQfW3 .;{t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZd/[X                              0 @ k UPS㋇⣐⋇⣒[XPSQRW0  3)  3  3
  3_ZY[XPSȎػ       !    A    a   f    4 ztR  vffft<Q  lY3gf&A fgf&A gf&A f   u   </   .  #    
[XR * 8 F ZSQW   _Y[SQW   _Y[SQW   _Y[SQW   _Y[    f  f@  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf-  f   f7rffYf[f^fQfWfVf @  f   f  gff^f_fY               fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     PUN
NNOపNzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX        戰3ظ  м{f郲ff%pfD    2ø     r  @ /09/16/05DDTsd