#!/bin/bash
#
# Utility script to prepare system BIOS
# ROM images for flashing.
# Copyright (c) 2004, Hewlett-Packard Company
#
                                                                                                    
# Check for 'root'
if [ $(whoami) != "root" ]; then
    echo "!! ERROR: Only root can run this utility."
    exit -1
fi
detect_drive_key() {
                                                                                                    
        echo "--------------------------------------------"
        echo "** Insert USB Drive Key now..."
        echo -n "** Press any key when ready: "
                                                                                                    
                                                                                                    
        read RESPONSE
        echo "--------------------------------------------"
        echo "Identifying Drive Key, please wait..."
                                                                                                    
        # In case they press a button TOO quick
        sleep 4
                                                                                                    
        # Check /proc for presence of device
        NUM_DEVICES=`grep -cis "usb-storage" /proc/bus/usb/devices`
        if [ $NUM_DEVICES -eq 0 ]; then
                echo "!! ERROR: No usb storage device detected."
                exit -1
        elif [ $NUM_DEVICES -gt 1 ]; then
                echo "!! ERROR: Multiple devices detected."
                echo "          This utility only allows 1 device."
                echo "          Remove devices, reboot, and try again."
                exit -1
        elif [ `ls /proc/scsi/ | grep -cis "usb-storage"` -gt 1 ]; then
                echo "!! ERROR: Hmm... Found device, yet there are multiple"
                echo "          usb device traces in /proc/scsi/ =("
                echo "          To be safe, remove devices, reboot, and try again."
                exit -1
        fi
                                                                                                    
        # Extract /dev/sd?
        USB_DEVICE=`grep -is "Attached scsi removable disk" \
                /var/log/messages|tail -n 1 | awk '{ print "/dev/" $10 }'`  
         # Extract proc/scsi/usb-storage-0/? - this assumes "usb-storage-0"
        USB_SCSI_NUM=`grep -is "Attached scsi removable disk" \
                /var/log/messages|tail -n 1 | awk '{ print $12 }' \
                | sed 's/scsi\(.*\),/\1/'`
                                                                                                    
        echo ""
        echo "DEVICE FOUND: ${USB_DEVICE}"
        echo ""
                                                                                                    
        # Try to find device info via /proc/scsi/usb-storage...
        # This assumes only 1 USB key inserted
        if [ -f /proc/scsi/usb-storage-0/${USB_SCSI_NUM} ] ; then
                cat /proc/scsi/usb-storage-0/${USB_SCSI_NUM}
        else
                echo "Tried to look at /proc/scsi/usb-storage-0/${USB_SCSI_NUM}"
                echo "!! Warning, could not determine device info."
        fi
}
prompt_reboot() {
                                                                                                    
        echo "Complete."
        echo "--------------------------------------------"
        echo -n "** Reboot now to flash system BIOS? [y/n]: "
        read RESPONSE
                                                                                                    
        if [ "$RESPONSE" = y ] ; then
                /sbin/reboot
        else
                echo ""
        fi
}

# Welcome/Menu
echo ""
echo "--------------------------------------------"
echo "This utility will prepare floppy disk or USB"
echo "drive key media to update your system BIOS."
echo "--------------------------------------------"
echo ""
echo ""
echo "--------------------------------------------"
echo "IF THIS IS THE FIRST TIME YOU HAVE USED THIS"
echo "UTILITY WITH YOUR USB KEY, RUN OPTION #3 FIRST"
echo "THEN REMOVE KEY FROM SYSTEM, REINSERT AND RUN"
echo "OPTION #2 TO BUILD YOUR BIOS FLASH UTILITY"
echo "--------------------------------------------"
echo ""
echo "1 - Prepare Floppy with BIOS flash utility"
echo "2 - Prepare USB Drive Key with BIOS flash utility"
echo "3 - Format USB Drive Key for data use (after flashing)"
echo "4 - Wipe USB Drive Key clean (use if USB key gets confused)"
echo "5 - Exit"
echo -n "** Please select option: "
                                                                                                    
read RESPONSE

if [ "$RESPONSE" = "1" ] ; then
                                                                                                    
        FLOPPY_PATH="/dev/fd0"
                                                                                                    
        # Make sure Rompaq.img is there
        if [ ! -f ./fd0_img/Rompaq.img ] ; then
                echo "!! ERROR: Missing Rompaq image!"
                exit -1
        fi
                                                                                                    
        echo "--------------------------------------------"
        echo "** Insert floppy disk into disk drive..."
        echo "!! NOTE: ALL DATA ON FLOPPY WILL BE LOST !!"
        echo -n "** Press any key when you are ready: "
                                                                                                    
        read RESPONSE
        echo "--------------------------------------------"
        echo "Copying image to floppy, please wait..."
         dd if=./fd0_img/Rompaq.img of=${FLOPPY_PATH}
        # Way to error check here?
                                                                                                    
        prompt_reboot
elif [ "$RESPONSE" = "2" ] ; then
        #echo "RESPONSE = 2"
        # Make sure we have everything
        if [ ! -f ./usb_files/usb_mbr.img ]; then
                echo "!! ERROR: Missing usb_mbr image!"
                exit -1
        elif [ ! -f ./usb_files/usb_files.img ]; then
                echo "!! ERROR: Missing usb_files image!"
                exit -1
        elif [ ! -f  ./usb_files/rom/* ]; then
                echo "!! ERROR: Missing BIOS ROM file!"
                exit -1
        fi
                                                                                                    
        detect_drive_key

        echo "--------------------------------------------"
        echo "!! NOTE: ALL DATA ON KEY WILL BE LOST !!"
        echo "Be sure "${USB_DEVICE}" is the correct"
        echo "device before proceeding."
        echo -n "** Continue with Drive Key formatting? [y/n]: "
                                                                                                    
        read RESPONSE
        if [ "$RESPONSE" != y ] ; then
                echo "Aborting..."
                exit 0
        fi
                                                                                                    
        echo "--------------------------------------------"
        echo "Formatting Drive Key.  Please wait.........."
        echo "--------------------------------------------"
        echo ""

        # USB keys seem to behave better when first formatted for normal data use
        # then come back and re-format them to be bootable file systems

        # First format for non-bootable data use
        # unmount device in case it happens to be mounted
        umount ${USB_DEVICE}1 > /dev/null 2>/dev/null
        # -uM = input/output is in Megabytes
        # --DOS = DOS flag for padding
        # 0=start of 1st partition, whole disk, 6=Fat16, -=non_bootable
        echo -e "0,,6,-" | sfdisk -uM --DOS $USB_DEVICE > /dev/null 2>/dev/null
        dd if=/dev/zero of=${USB_DEVICE}1 bs=512 count=1 > /dev/null 2>/dev/null
       
        # unmount device in case it happens to mount itself
        umount ${USB_DEVICE}1 > /dev/null 2>/dev/null

        # Format with 'mkdosfs' for FAT files system, usable on Windoz
        mkdosfs ${USB_DEVICE}1 > /dev/null 2>/dev/null

        # Make bootable partition using entire drive
        # -uM = input/output is in Megabytes
        # --DOS = DOS flag for padding
        # 0=start of 1st partition, 8=8M size, 4=Fat16<32M, *=bootable
        #echo -e "0,8,4,*" | sfdisk -uM --DOS $USB_DEVICE > /dev/null 2>/dev/null
        #echo -e "0,8,6,*" | sfdisk -uM --DOS $USB_DEVICE > /dev/null 2>/dev/null
        umount ${USB_DEVICE}1 > /dev/null 2>/dev/null
        echo -e "0,,4,*" | sfdisk -uM --DOS $USB_DEVICE > /dev/null 2>/dev/null 

        # wipe the beginnning of device clean
        echo "--------------------------------------------"
        echo "Wiping the drive clean......................"
        echo ""
        dd if=/dev/zero of=$USB_DEVICE bs=512 count=1000 > /dev/null 2>/dev/null

        # format new partition
        echo "Formatting new partition...................."
        echo "--------------------------------------------"
        echo ""
        umount ${USB_DEVICE}1 > /dev/null 2>/dev/null
        mkdosfs -I ${USB_DEVICE}1 > /dev/null 2>/dev/null

        #  echo "Copying boot files. Please wait..."
        dd if=./usb_files/usb_mbr.img of=${USB_DEVICE} > /dev/null 2>/dev/null
        dd if=./usb_files/usb_files.img of=${USB_DEVICE}1 > /dev/null 2>/dev/null
                                                                                                    
        echo "Copying BIOS files.........................."
        echo ""
        #MOUNT AND COPY IN BLUE FILE HERE
        mkdir -p tmpmnt
        mount ${USB_DEVICE}1 tmpmnt
         if [ $? -ne 0 ]; then
                echo "!! ERROR: Mount to copy failed - Sorry =("
                echo "          Your USB device may be in a funky state."
                echo "          Please, remove device, reboot, and try again."
                exit -1
        fi
        cp usb_files/rom/* tmpmnt/
        umount tmpmnt
        rmdir tmpmnt
                                                                                                    
        prompt_reboot

elif [ "$RESPONSE" = "3" ] ; then
                                                                                                    
        detect_drive_key
                                                                                                    
        echo "--------------------------------------------"
        echo "!! NOTE: ALL DATA ON KEY WILL BE LOST !!"
        echo "This will format a FAT16 filesystem."
        echo "Be sure "${USB_DEVICE}" is the correct"
        echo "device before proceeding."
        echo -n "** Continue with Drive Key formatting? [y/n]: "
   
        read RESPONSE
        if [ "$RESPONSE" != y ] ; then
                echo "Aborting..."
                exit 0
        fi
        
        echo "--------------------------------------------"
        echo "Formatting Drive Key.  Please wait..."
                                                                                                    
        # -uM = input/output is in Megabytes
        # --DOS = DOS flag for padding
        # 0=start of 1st partition, whole disk, 6=Fat16, -=non_bootable
        echo -e "0,,6,-" | sfdisk -uM --DOS $USB_DEVICE > /dev/null 2>/dev/null
        dd if=/dev/zero of=${USB_DEVICE}1 bs=512 count=1
       
        # unmount device in case it happens to be mounted
        umount ${USB_DEVICE}1                                                                                               
        # Format with 'mkdosfs' for FAT files system, usable on Windoz
        #mkdosfs ${USB_DEVICE}1 > /dev/null
        mkdosfs ${USB_DEVICE}1 
                                                                                                    
        echo "Complete."
        echo ""

elif [ "$RESPONSE" = "4" ] ; then

        detect_drive_key

        # wipe the entire device clean
        echo "--------------------------------------------"
        echo "Wiping the drive clean.  This will take a few minutes..."
        echo "Approx times: 16Mb = 2min, 128MB = 6 min, 256mb = 10min"
        echo "--------------------------------------------"
        dd if=/dev/zero of=$USB_DEVICE 

elif [ "$RESPONSE" = "5" ] ; then
        echo "Exiting..."
        exit 0
else
        echo "Unrecognized response. Exitting..."
        exit 0
fi

exit 0
