#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTH)  - Linux-Based"
BIOS_VERSION="F.09"
FILENAME="sp32626.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o4o4  {]3   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68DTH   BIN  i5s44  :Uj4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  .   c             F  /    I  
     &  o  A  )    %  z
  T
  
      U      y      n      n          "    	          ;  "  "  "  "  
"     }   g   '       %  %  )$  $  #  #   u
 u
 u
)  )  )  )  )  U)  8)   u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u

u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u
#C  C  B  B  B  H  H  }H  =F  ,F  E  E  E  Vu
&u
u
u
u
u
u
xu
Nu
0u
u
u
u
u
u
u
pu
Ru
4u
 uS  2S  !S  S  S   `  `  `  `  `  c  nd  d    	u
2u
,u
u
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3Ðj薓ː
  F  F~ F F^9 uvfv')}fvfv)~h	h jMRP詎Vtj
fvvPƏ
h	h jN~RP|Vtj
fvvP虏
 Ð3f>^  tf6^ *f>  tf6 j b荇  V  h j胐h jxh jmh  h jah ~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ÄF^v&v&8 uNV  *=p t -d jHH|f6B jRPjjzRP莈jjRP~jZRPnjJRP^j:RPNj	*RP>j
RP.j
RPjRPj
RPjaT-r - @- (FF9F}-^v&&?-t^F&&?/uF V]=sjxtRP與ja,]tjyURPij`a>V   h	h hn fvxvuj fh  ! hq
h@蝌f6vfh   hq
h@`f| f6vDefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRP蜆j`.]\fh  j X^ ` ^ ujzMRPajX`s>R  t!G  \t( !  9  =  A  E  I jJj1fjއ   ujzRP煃j_
t(b       ؎f&fjxRP蝅j_>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uaH>T  u	>L   >L   >\ u3T Ht	HtHt8j uwjJ9ulj?j.>\ u?T Ht
HtHtHtIjj MȐj?u+jRP跄jT HHtH
>T  t7>N  t0f|A  h|h|j
> tjJRP^>J  t
j H^vt  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uF'~ tfj fj /F   =HtkI-
 -!- - - 
tFf> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj lCd   F >J  t1@Kt B= M- K- '-M- 0- )fjTD>J  tzj "\^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j)}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFPff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPfvFPBfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;Fvfv_WFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPVFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP5
k3ÐSfv
 ÐT  Vfh  P FPcf|K  Fhh|h|jh> t3^ÐFPzBFVh	h FP΁RPhTzh	h fv貁RPhd 8zfvhd y ^Ð  F@Fq
|"~FFhh|h|j辀}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ u*u%f6vfh  f6^ +^= uv&G
 tf6v[놐f6v[?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP荁
fh   vfh`  j f6^ @v>  WV	~ľ" f~ th	h FPw~qFPu3^_h	h hd [vxvtj ff-   fPf6vy
f6vjFPy
f6v|j ff-    fPf6vky
f6vjFPx
f6v{~ uo~|ij ff-  fPf6v)y
uLf6vjFPx
f6v{F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXFPhVf6vX ^_Ð~ fh  h	h hd Yvxvcfp    	prff9psTf6vfh  f6^ wY= Yv&G
 Lfh   f6pfh  `f6^ 
*t"f6v Xfh  `^^_Ðfh   vfh`  j f6^ 
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP~
<F> tjJj1j f6 <~jh	h(      RP}
6 hq
h@     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjk\RPpv  fh  ! hq
h@{j3RPXF  @ +FHuF F^
&@VxR&*RhRj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRPujJ`RPtu3ø VxR&RhRjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hRj
VjRPUFF*;s6PjRPTF*PuVxR&
R뫐VxR&
RhRj
Uj|9RPMrj7u,jCRP1rjD
RP!r>J  thhd jRPYTÐ  [@7fh  hht"jMRPqjNRPqj{RPqfh  UujEF jWRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pu>X X}jKRPh	h> >SjLRPh	hD (S>J  SÐt~ h	h2 RF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPfRj F*PujRPh	hH hhd jRP)Rj[RPjZRPh	hN 	RÐ  4+fh UhhCt"jMURPiojNERPYoj{3RPGofh  ujEF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*PjRPQjF*Pu>X X}jKRPh	h> PjLnRPh	hD P>J  Ð9t~ F 8VxR&
RhRj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RP"PjF*PujRPh	hH hhd j uRPOj[eRPjZ[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ uj#RPMh	hV j!RP{MF*  F vu3%.t(t~ th	hV FPfj"h	hb FPfj#RPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$ARPL0F~  F ohRj
MF  hRj mMFj$;F~VxR& R܊F*PjRPCLf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%{RPK~ u~ tjj[RPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*PjRP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFVxR&
R
hRj
iKF hRj WKFj N*;~VxR& RՐVxR&
RhRj
K~ ujRPJh	hn j!}RPIF*  F u3t~ th	hn FP1cj"h	hz FPcj#$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j$RP)I:EF phRj
IF  hRj IFj$T;F~VxR& R܊F*PjORPHf6^ FP:FF~s#~ t~ uVwR&
Rt~ tFPFPj%RPaH~ u~ tjjRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !j-ރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0,܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvj_ڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7@كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w0؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0D҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &psуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh@htth@hِ = t= ut у>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShAhR*F*PʃuFL| j hAhR jʃ]FUtKjʃhq
hd j hjlfj hG=thAhREtÐhq
hhq
h~&Ð&ÐU~ u hq
hjhHhq
hjh7F  F~ ujFÐF Df>   F{ j h6Chfh  ˃uF  FuF~  ~1 F  Fff   ffffN*+;|;sF*@N*1 Sh6Ch`>  u)ff   ffffN*+ = utj F*Pʃq>X X<fj hF~4F 1 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*1 j h6Ch[>  u+ff   ffffN*+ = uFj F*PɃ2~ fj hF#  fh  Ƀhq
hd fh  uɃt"hq
hhq
h[t"fj hEfj hn#=uhCht!h6Chtjfj hU~ u hq
hjh.hq
hjhF  F~ ujFÐF Df>   F{ j hPFhfh ȃuF  FquF~  ~m1 F  Fff   ffffN*+;|;sF*@N*1 ShPFhF>  u)ff   ffffN*+ = utjF*Pǃq>X X<fj hF~4F 1 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*1 j hPFhEjF*Pƃh~  5fj hF?  fh ƃhq
hd fh ƃt"hq
hhq
hwt"fj hEfj hn?=uh"Fh9t!hPFh(tfj hÃ>J  tj h tt t   1 ~ ujރFÐF Dj ԃud j h*Ih$tF F~s3c F*1 j h*Ih$FPuFA j h*Ih$he>\ utTtMtFj t:h"Fhefj hn=th*Ih$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j h>JhBFPuF<A j h>JhBh/또>\ ut>t7j hj<fj h=th>JhBtÐ  Z1 ~ uj	݃FÐj҃uÐF DTd j h
Kh`tF F~s3Tj F*1 Zj h
Kh`FPuFZA j h
Kh`h/c>\ utTtMtFj1t:h"Fh%fj hn=th
Kh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPHtFPhq
hՃ~ th	hHh	hTFP3h	h FPUFVu3vPfh0  FPLfv4FPhq
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPгtFPhq
hȃ~ th	h`h	hlFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhq
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..bf^gef[UfS..bf^gef[UfS..bf^gfeff[UPfS..bf^Fgef[XUPfS..bf^Fgef[XUfPfS..bf^fFgfef[fX                           UfPS^tf3ffb  f.c.c "  u  $" u [fX 0!<s3P˿q
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666͜P.dظ WeP.dۚi  y>	uXP 
 Pq
 5! %Td!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.{twdydydyH{ wH{H{H{H{TywwH{H{tH{wH{H{wH{H{tRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }(}>}r}}}}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bq
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3q
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![t#%!u
sʻ 

FV]U컱 .8tK
I	]PPR.d؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUq
ء
F
F]XSQRq
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.dۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH&6		VW_^s+_;uX6	&t	;u؅t؅^&t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]          q
              4.68  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) zE  + , B  . / ^H  \ ] I a b I e f J h i K '  q
 `  q
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d						(		b														
	*
	J
	^
	r
	
	
	
	
	
	
	,		B	^		.			n			:	X	r							,
	Z
	
	
	
	
		(	8	                                  E    F    B l bq
      C    D    B l q
      G    H    B l q
      K    L    B l q
      M    N    B l q
      Q    R l q
      P    O n q
      I    J    R l (q
      -     1    + o Fq
      V     S n dq
      *    1    ( o |q
      T    U     W   
X   
S m q
      Z    [    Y l q
      0     1    . o q
      _    ^ m  q
      c     1    a o q
      g     1    e o 6q
      j     1    h o Tq
      q    r    s    t     u     p l rq
               ^e                           _C_FILE_INFO=                                                         q
               
	
\ \                                  [q
  [q
                                                                                                                                                                                                                                                                                                                                                                                                                                             *q
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          @f@f@f@f@f@f@f               (((((                  H                                                                                                                                        "                                                     SdSdSd                  mq
q
q
q
q
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ABSOLUTEU)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '       N    POST9  / N  `  N 	 {
 / Ђ .
  L E. +  a .    9 9 V9 9 ݪ    5{ } |  ! " 1# P$ 2% & с' U( ) *	+ , - ?. >/ a0 1 ?72  3 ^4 I5 6 7 p8 {9 3:  ; 3< = v3> ? 5@ 3A GaB NaC 53D ߁E F $|G H I q.J `K L /M ~N :O !/P Q  R k1S 1T J3U dV W ڗX +0Y@Z 
[ {\ `] Y^ $N_ d` a b `c f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h@O [X /<t
PW f&E1_X  PRWfQ
u5p =(t'SBff  u߿ h8ufY_ZXSQW< s1
2
 ht3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfVЎ.< t ~.FuN._^fZf[fXQ	
l@
		! &
%
> h43hp    t  Ãu
..uIu/bG RP~VF` u tvk@.itމ^~u \t/ tO^6
5
u^XfQW~
 
 #_fP8
VA/s
Lt<
tw
u!ο 	*ظ?_^p	9~!QfWfV**)6S
F f[tҋ3ff^ff[f`K.fa9 G7fVWUG t  f h2%3  fAh6 P{'Q2C7 hFC(2rg&>Ut2g&FP3EXYP-t7X\P%f3E
X f	]_f^Df`Sfff ? hR?-f;r[F W4
__S W_E rgN
g=Fr
G<< \faAEWfgf&Ffؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3f	ffY_EU3tg^5NC]" h fV   !8]`QRWV^NV vq6Q3LJYtKʫM^_Z6QP0 F8 YfWV3ff$ 5eLfPS.P .*.F.  f.g^)2{mNm^~uU]HS.P 
 ufUUVReQRC	
}ۀS2ۊ~fpo:`Ctuf| f..ftff.@# >C
uF8Fuf_ZFfX^ÑKVR.>
.s$0u	Q.k6
..
.O

ZJHbPr2
F0.FPPz2P
N~ t4vf2	f	f 1^"FNNI..$cUfVXQhnrrLS 虿 rD#j;f߾ @ R   gf  P^ g>i`Y I]0;Q^6  
fvhU~uF F 7P3p^_YDh^} r rD(gf 
/  #ƐQfRS 𒕾N&t]fvԹ tNhCHtDs ʆ hU/ 3hkRBFv ~&#3ώ
Pf~fZf   @
>tq  tgfNg A	~t-OF  ΁ ~3
&[P3yhkF{ t~y2h#Ff3ҲZh.ҭFFf;Fu-04Z3  
 IcCQЀAu'@(.;(.s0`~ ˁ ;u
t`ct@Ѵ `4^rf(  _^ZY WQ3.>(.2 .ǅ`.ƅb ` P@hX.*.w `$T 3.(.hC ПX[N[pwFk@"~ 
N~f.?d=6@.h2ɠJ&0\tiQL]u4.Bdf<tصf5$< F. C
1Q_V@~r`F F`! F2u~w
`~M~f͢1ŹQ/ t
fNu
ffs NFw^P j4P*Qj
Vq4F$<u&0_F n# ~$wp` j.鄁ph{<'u{^`}V@g(.@..(.g(.^Vp&R0
8at	@
u4@9t/2x_@4
1^]@818~s7#3gu:N PA<
t3 Г;)Qсfu=8Np_^cV9uh fhP]i^ԣ{
S  `&~u5u0jM !0 ,-CPfpF>R*3F*F~Պ^^>֊FՈF 03סf
 F f^Vb0qu{? @QV\ fz ufZ^Ykۀ0fN誰 Ny tFt"f0[9FvAFH;F`0Z|ܠQI A^f9Fv"<fH_!=F׊F8F u H.a<fIb>>Af}+ ;NsG>@.0e^(tf+f؄=P>
e
C=fpS~uK~ ktE24B.pN	 .BSVR`QnuaVGY[u1HjMffArRffЀ`2f&f;w
2Z2fPRf@`(t#f3qf-^3ZfffNN 8ss4
trWu+%H	avf u "^^ZbWf /P^~w1I`$^="8u.ffFՋN_Qβ;WV`wvA[Fhu"ϋ~XӴ`(Andwo 5sVRfQFXu B kv@kFhP:b~h$$@yj@afrDf` w;=< u    r,.ir$<u r s@pvFfYZ]cVW @fqַ~uRTd
t"tt]H&`Yvnrv0 }PSV0޾ T3; t	 r^[VW@k߼ T`W#A['S?^@h*pt@;v7!Pdtk~@Сt 1;FtFk^% Bk^㊀ Ta 3҃  V3k`
C*"T;FuR,30t7t-k	i	# a
@S
+FHu
4uGrvFvVBs0;JVW΂tS5ދ[NuVp 3ҋp_&`t |@1-4FR>	{lH<h_H`mCHPiA.7ZE &0UVP~1\02N~ tKvl09F1y o \w$ 
fPQ3I Ffqf
0M SQh.	 \P,Q23QR.. tf.o&..`C.8*.tѺ6~
 d4^ zF  F_FFďVf"] A0q褺@ƐNҀ tFt'fAUڐ쒊`Ғtmj֐dbaf;>7A/SъF8F  N%RFW0" FS$ U&T&U(Ó,Đ@ Fq!fv АN0rts`9Fv`Gb 3%Ajf. Ϳ \ EaN083p
t
F%  g.`  d>feF~/ t(gwixqu
 v@act#3t#Ëȁ ~wu !d|Px  vt'f#0ff0
=rcEn.6 H                                                                                                                                                                                                                                                     @       o  PQRa&hk@ $`Ȱ߲ hDrZYXSQWa$a$a  h4B hM >5_Y[2揺 TCA6  @A Q C@}@ @;uYð!?$p h)Ē
f`  蘕 hFf4gf&P   fa.4hޭ
 

htsfPfW@&'_fX`j
ߑ0h	/t%1hkUKc   &  @RQ ލ@ ؀  >N&}uu hUb!3d 
  % W߸W8`s-e&$@#h<~ff
qÀtf%af5hCϕst h>*,Ⱥ: @p 3ȰS, @uShm3.h̄ XC P
V0	
` ܹ 
h2b2p!úvû.6!5! f4%  02HT12X21-220LTN121XJ-L03 4IAXG02Cz41LTDEC5V<        1 1 P 1 1
 P f`O  313ۃOu+x21q73ɊOt
2r3_ø{ h88
]  w й u_`E:aP hζcp4P7 h= t
 QP> @ PQ= `t
3f3	@fYX _ Sðd`pId  UP0UkWu &GA'F  a;ؿ
Et&؁V uM9NwN#uӃ~ t"F= wt%   +gXXh:S`.4   !	 `P a `( u2hspYd 7t*7u UaSu=raAUtPRfZX[0.~f.~ AZf` f ?  ƀP^m!$fSfQfRf `  fp%=uf?a2 ffZfYf[]SQRfWf_Z pZhC=5gah!Deo  Ae3@P`OZ	 ϰ12^3r)fZ030s0 hSsfcr艓s Sz
8S\Mkfa't5<t1|pf rc@  Æ B<  C<U $U # Q R STp UU VW	uX YZf7RVW3-)D0*
` yAdpftRPlRee_^ZY~#7 Q Ơ  Q tc4TC4nc4NC4oV< f`Ȏ.7 .! 	-_771UUB7+G;rU7rܰG
辵faé    >  A  T l M e M A@  9 Y .    n #SA  =qb 3(
~  pZ  +Z{!p[0bD2 P f9!`^68f6|80?  3 p"S 6p8>xI.h8cPS㘻 $<t4r [X)  Ѝˋh93 0a f`4 S  y)6h3%$hTBd   D 3y "ro< tfF212"2iR1n 10r0ﾙ1 r%@10&5&D&ENJ1AP)`
pԯhʓ p߿1pt5v s/U2V2~^ 
8
3
~3
A2^
O1 s@QO2f&@ U$=u&M2f= =u X&]2&[2&Y2y
, fgh  0 pqr  <ABCDE xyz{|}   )dV S#
fpPnq; r&2&2< r
&   <kx" 2rfXfCf  vf5fx&V3
Ê^`0(.'t%.FuN.PW)s1 _XÖWfVUSWSQ,fwv(T  ޿RFU~2V2ك!IN3d	^
u
t_NA&>0_[]f^_ PV&=;u&&4u&^6P
P<q +&~& 1E&DpaSV h@r^[þ >`[WfPF}hS@ȁ  <fX_v^F10=ROM Based Setup  EnteringСP>`. u  S> Kt.P>nP? Su)!`- W  y>p 1uA	AP> 1Q>qfruKp &P>tFò  et
.>t.&Ot
(*At hCPXh?{F12=Networkrvice BootWake On LANAttemptto %   ht8 0?w r	  A?u ?1YJ	t 9tsR QP.?$<0,( ?ITBՁ"?! ds@C	%25ؾO<^`so _E%n VRmyoOlNF N3N?	uCFG~N0tGwhջaN<vshZ^òP*Notebook hard drive MultiBay"Dock!:b<#b> (top)bottom)leftf	Floppk  UsSBCD-!Ft HDis/>SuperGNIC*
!123                         CP  	 
@Do8P 
V t @VصpqolectZDeb]  ͹U8 and _mo@=the _highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   vEE(E$P E'#F;S A;Zip.F`u
 d0ߴ0.#3&*tԎHFB_ A VN3N؊' tA<v<st1hE& 2آٍA2CQ#YAr	 x? P ;A.dE
*}fE @fE+jjj(Pj'=  %F `dE(E z ߹ *  9Fa R 2җ
 蔿  t03hE2Ɋ F8tFhN $ Zbqqp URVQ.,.L.T^Y^Z]S,.fE*[ݡQSVW/ s&QCF.<.-00?00.Y_^[YQr(E u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ Xʱo@
dE(E(Er
;w2pdEJ鋡ơ}gFYô.*fE<u2K0fhit h4h7d hb<u`B J qWo rf.>J5 hSӿfgf&G, @ fo   PG0f@G,`u
hEtG,f",7f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁hFŐ5p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾J׎~ذ:{ rsJ	 _k  QRVDTQF r&e^ZYJffL (]΁LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,wABM  f.LwPS [XAu.6Lf.LIDNU.LSfV#{CP #^3%%Ýf@	~3u
u\ru!q!} "@*W3 hta **hy3p%5cf_ ]`= vH O1H aP߰ hk"$@<@X7O4pJPR ZX@ P.>N t.N.N@aNSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4{B XZY_U*uu} N[у< @3ɹ2 uhXDp#qX) P% =_ @uX%*4g&@MHIWfWi	t<f_!Qfpyf  g&?t9g`\R%fl<u @!a  f%?fa#   f@%fQ
<tf  f !pf QaadZYY0a$fVL/
/]GP@t

z

 
\"
f^ff? wD Pf%@~
!
k+fm7oH34r H5 0P@p <8	1K2 P`p E Ј"ɒ LP@p`a L`	P  	`iw_  DD( Actf &_3&[3@0SfU0'B!(ut uf*+]s cŃ>_3 tuc ~rh^
&h3p@C<ths}v3  G01?}4 Q < t&3WG}f&
n3f30 2ɴ*f&_3 uf
ffKP4&4&_4fC0K4#e+3p45RfVWfC3ffCf[fKfS܃fF0rỌ0 K I+rx2o_;Zf5SQVWϾ u3n_^ 	!BKsV 
R3
t<^f~
w/v U0fk{d`dfft@`[^ШVQWfv ߚhU-F&4F&p & &P&{&0&۠&&߀/&4^}PUȡf   rGt >`*:u
P0xhgbX`aĊ؀adf]sPRaQ  hUgjjj%jG PR	Pu hJփ
v o h=s5?ú  Гp (ϲ t 	2se fOX ffff>KXfh Ugo&; [ua)f)Pf0g&t` b   ttx3srnfǂB 0E 	~/u΀~/?t wa	~;XXtM!ܤ6O                                                               ؆TfU.FXJXWu u[rWJrR-rMJXtwf0fqPw| @Wb t#r"t} p ; }PJR  ZR f]LCqfUr*6@^  R߄ Z0rG	0KuҰo!!Vg&fFfFf^@e rC\A۹ `3ۿYyg&8E t{EG SBWiZm r}`Z>OXp?tҍtm8lqlZ0hѥcʰW rt r
 GC_RZt$֤b$]0WP谠  _W}  sp  ia #`P
߰@S P  	 D v Sذ8 3 e} R	u$#
R'
//QWjuptPX_Yù
 d h<sxus{z
ՏP .<u.uĀ qRRaR22hX< uZ#ȴ$ t	J 緹 U
	a!"9Vf @ƐQ`^h7[àhaӫhsr$4/h Kh~".uva { r PQW 0> 3_YX
h
aC=NF x=#h`4s	> kDð   ! $!f` T|`hkC@u' tf` hBCa+vPaF X׈[`!ؾL &>N&DE>P&D >Ou d֙ ڙj@ tN}
 +Ȁ}	 >N 33SP[tS[a>Q 2[sDy3 t^h@MhWs
JhOahPD
ϰ<DuL
p
E$<u D
@11Usd
r=Si&pS]@` uL
 6 6N u_  (X6 &uh
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"& xu	\	PS  { ? 4P'>N_3& ?! W>N	_w[XB
t+# P xt  t  w\DPV!$!"桾tKh10Q&,@ &  m|` hSC!r!L	vTt
vw`WU$@t! $<v请@a@l3  v
p
u$ "<uP>ȷX\PRt N¿:p1thEZ!&ă=0ZXv` 22PEO&PCt5N=NtOu570: u	At!s9ޠ6 u5 .O\s
t=!Z&@q es  `a
׃/{]3 ۸s{&=  V P; Pu 0< ^  3f4G -/Pf{_ o }0} U!    P&egWO&MuO O}qfGtM!t$Ot, t"OGro ǾJM0oOg&3P_/` o2%
<t29m21_kP*P*`OHtS@LD~hE =_7_D D	 d
zb=1;b^tSqrG&}	r??23p4t`h2a&ET$a	&M&]aI`.߰'`\%# rT} VWϠRǠZW&= uAF <K)
h 
 m_VP
@t   U!w#w !#`0ߊ|ovh3 3j.-.MTN>tI! //(rJ=j.58v@Nu% @BTB 0h4shaW$
"1D h
htCYp@[X_Ë
`PS@E![X SϲH<vLR
 Z,<u(Rf/fSŠл,ZJ ?vGu

Ͼ kS1 6у[Qb$ <@aáf3Ґ	}fi`{@hUt73۹ F
t):u%B7cD	& h6N & 	 hRN3G_a»3 
3 =ѧ  N aSu   [R r}OsF>ErfQ s.<t*DO<u&' t&wAw+ Ź'w
w'+QQz;s& 0R׃&yZ0yt~p_ h^ qYQ<?w [r(˦u% = tpYjL[S3N+6 w
HHaE&EԀ , rPVPVh+#sxfV @$P<PtRZsDPۑO  ZG}Z^+VWV 0  PhrX@ 02e&o
󪓮%2bƀub ΀?!C@?r@Dt51+pҊu,u1 
@a

+&C323&@t  %
t&
0  5 茟 "   ( 4
u: >0.bz!	"	? Aw ^1mPRW?&A &]&Up
t oˀAi] _ZXr#3һ -wƎ2C.E/N#h΃&<<'߸^   Vj    x А3р>u  'S W [q!Vf\ Wf3fu 3 Q>PNWs:*uBE&8Uu8p]
R +B&U
ZK!؟qZ6fYB)%qr hp;	Q(tY06
  5Ãh`蠤8.
<tZێûPV#
@F^f  XPNED
yC I  uwwUf``؎ Fwt.p ڎfafSfQf.tf fff#fYf[2VftGf߾   sIg@f;t&fU 	F Ȁ%f^`2۲ۈfaf}`cnnfaPP3_X.> t>, . ~PTACO F"  
!	& .sC<F	s fFf.t  tF.tf.>t<E.t@  ttttYpttNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p s%f@c .ffHptfXf1df33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RREto4^q4'r44$.x71p6ɐp08333Ҹ  QW> R% _F
3}5u'JE#ȩ `0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^L u)lQ` &t Y&  
 < tr&\]p &\U  
&lN!d N
SR[u0	F~@& $F^[_RF FYp߀TV'}PVWًذ ' O>!y _^WfQSg Zpfat
  [fY_` t =$P nPu2MtaË6!s } tp( ` j &&E?SRUQj@6Ŀ^]ZV` jXz0ŌD^XP
~*F
  t# b QlF F`(r d3duhX$Ku`<Uu߹d `hr4d & Xtû   h>% h PhE'`X!$! l °"s}ୣ O
ehFIB   t7t 4  hL` tKu& &  
 P` h,ss@<t<uuR 
0u?z1*`P	h~s Xhm? $ P 0&pD[%Öys%aPX'w$# )Р)t`($} f.`G  cp 赾D߾n@7 À   ; Z x     0N@`^~#bh)1fF3.=~% r 
\0ވBFu~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KہC~.~r@V» 㐂û< f ˾ff @ffRfPf!N
 ffFf?3fvZfFsfBf〶f`1 r?9pf3ɰ`ǿOnfAP  faþfPVa3v޸rF3X

S,0<	v	,$-.[W D`
o
Lb f s  fɀ
TO
T p s 	 
Sf_fp ЎfvﭿPUUYP,} P:Fp
uf^fNfV_f^pPRp*fV|A6F@20hFC@ Ͼ
 ff  fffffXChq p  `90 P9󤾔" 6 a)P*hU7P, %ofPRh2R ĺZP  (Q * 4f_f:aD0  f2MMShm   hCɀhth;Z?;PSSb@Apq$ q~!(̰Āup1!A tðvntt<1w(<v7&{PEhݶ3_ P&
0
3q 33ҊĆtW/g.&;?u;@.Wont)@)hPt؀a`2G@t03@ @u?  3|[
u93Q2,;8<ӉN 
~
PU-j1rX?~03Qr |X@Y4SwQo2P5'$a&& &0hnC hsu򿣶ɰ hm
t[ Ȱ t
嘪ŀv#t̰,5-PXv8v&> `tw`_P3 u $h<I4
#RV" йs} uu22h8Sgu]赹uXP&
wL2 Q޻ hNu= Dt= tYԀ'
Y迓Y4^ZeZȏP #\U  Pf_^ ]  _`yrr	 V'afOLPH@      @6P0;V(e
u^V- ^"(P*^  2ސoMqSP( 22 pX[úB  $@7R  Z`7              zKtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*?<r3w r@ .hyjfa2 PR30 Z@AR `&Fd??^uh3P&Xh r.>.put 	AїQR.߇h f3f%  f`YURQSWF^
D= F\ ^F \^t
;v F;F
 < uWP  <022 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              D?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCC`K (   P3YaPSRP3@mn?[`H@4$&%<GP 	 oپ <BMtf3襰DP2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 fް@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff6;PRXW_ RWO  3OtCxx ؎PP.BB <t BB2J &ݾX߿   8u!@屆`23Ұ
ShSWSt0`́ y aut0i at]U U[aSR  4hf
 {hSgZ[`-0Pϻ  h=	 h
 "?BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wwZhEU2<Uw  h9]ݚ u
3Ҹ EF])v upQst&,3 s ' 
Ö SPf. UfQfRfUfVߟf@@hF: rsNrDW3f. ff_4f^fq5Yf.>fEgffgf uY*KU q. u, P3	fgf CPpcIwfAgadf.#f9u5hpfY'0    /p ;:h 
U;! ބ<# :0Q ﰰ5 %"  QVO3%@򮀢t r;Fw ;ޝ
V3"/fWi &g 9  f% '" #YFfF^faߡQaV p @\  '
^bq]3]<   h DTDw R po 0 [h  1   l ( Pb @0 W HzL P`A T W X~b, `
`! p@pؾpx o A0
|\D`QWhG2_3 3_p 0 PQ= `tq1 @0YX 05SPr
& p  ff& X[@ca"&    ir  xh}@Q JV5O fQQMΰhFl ./ۀ Жp砳 <t k~ tq.补ri."D.|u.:DtSI  wD:r5+zs&v
uAl
c1aPQRfWT3^`
fXÑ2a`2	  "	f 2f@0f|@R %  3f3fPTaX Ah ZlUv m fb #&f fa dD 	h}W"ϻ (;sQSf  rї`
 t
2fƓ	40q!a
 Q[ffY+vf[Wf+_f߃ t%xH+f@`h0Qpgؐ- f@kf`0z q_L2_&U uZ=PrUf%в uCf*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&%ֿf2@t
 <t+p g1~f&f   ,[ XupG Lr}fBt<rfa&'?rf̰Q̀É_F?<  
 S 
"a	Ub	~Ip@R2B?uE1ɲcfȯfF &Ff{ t@s?f @{f;~t]	uɁ~qNїV&>\##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&ˀtg&TfVR3g&PfОfnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o hm>u  thrs-3&>rqrﲁR0z?sRޑuthX$uul	r` 	 +Zjj b6uPS`` FF phC rOu=
@ f&  ؀>t !$!~f$< uRC  
WN<2<ăƁ	"桻3A.'y@h[u TYP=t 
u2Ɋؽв3`t<u
E< tȵE$<u&w _$tRVL  N L NQǻڰu û` t  P[2u
@j jӻY!(!?!2(<!1e$ h5u$0t
$~1.#K,.t4&^ t<r&Pw 3.\{  5!.\e@.d nb    W	x .|wh4B_DuQ&~% t P讪Xӹ
 .:t
 ._
vXP%8Xr6%ȸfc4;La    PJNL p      QKOMp @Kt  Jt P(.DG~H hh  hvQ hޅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
o&;r"`np$t1TKub 
HM` `_(q p_" sr#%	cp&3a C 	H ]r5r`2gpjh!BvZaVRQShn^4Th4J".`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFhbUujjjj P'= ߰&h?X[ {h" $vawt = ;t= Dt
hEsp[@WVS$`́$
[? @n< u"*׿OطhN_t`-->J=Ot1 0_ tyr rh ڠ SǇ^1  0 hL PͲ5[ ? _ :N2o?Aq%  	
   V짋FPgbVW 2_2µzt"@u~G2 
u
2姹 粒
 o2E2&&&EA &e?
td&߈E?&&E E &E<r&}	r@w VW^2۠^2*à
&}vPuh`~VRPRQ3fo 
}%*t,AYZXRPSQY[XZh?<7	pp Є> qQ 5rXY`^,:Ϩ t
)֮hG&&  t8t'V u a+&\ nq00r6$^$ ªZ& &_& ;`Z@ `odde`P`  XU @>
ڹ Ъ靟 .PB B8uG` A ; 5䋀/)@#BS ˫냑75VŜPX
 a_@A@ B ]C    ÜFtV$%Ȱ%蝊<;weċ X<wM3ɆQ#"XR<  YыƊȊĴ3ЇуE pYE8@C0	 FrWYuF5<uz`0Df&	2
jpu7f߻hNePӀk 'B@. ,".  6&k !< uf& bÊ$
r wAu%1uhӲ$ws}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<ҭf7RKff
f@hʐXf3f3ɹ f Hf0m f+fL ! K Ru*(Rآ(R6g3ہTgsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2ҹǻ%&@GaaÍ6hVWa1z_^pk` hΫ$h  uP$<X%sf @  t<   4 |r	.!$<u
 f3hh.  
d]XiJhT<  tdbw_0s.> {Nfmw thtC	
A!U2 u@> l = ]sc 3Fd@ e f Fc~ce; 4~e uQ@@8 hsz`5/
P	|khJӳBFe:Ffu1r,
 h
 Fdt:   	9  <g ht5Lhsh`!afy`7UPHhu;E#f% PCAXt# N h&N r k f ̾   F^P XSĻ  y ,  o   hbS-[t(t@tW,&j  j,>" '  tht*dúߋG."g**D/.qpE4]+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fff`Fup   j(j	R	aURh$2  pɺ 1 h= Z]þcoRfB}$r@!  tgRQ Q;YsY2w$
 !u$ d%|Zf`  WWeIX.&$]f$?  pC`hF.
 C u0u.>?" 1fa
ZURtLUHhU<:Ym PY8tn(tp ;C Zߋi@"gm squ4?VfRfQhÊ$0;p^f[B]$8" a[Ybh~$q r 6Sj@ 2P s rGZ5'/UnAW`.#uQN$<u:0pбr"&  t  tt" tAt $puPNq9(
ː

 ⧾N`XSQ 3u,S?[rE	ˡ-Y[C& <ff<q`00xx00`֫Qɬ||	w>>.p~r tr~ (ЃmrLZCX'q@VF :]Q<Q7W &TZs6B  D ц߆ԆrAo zuN! CO _u 0/r)0/c#-&@ 8q2 E o*7&/p`W aUfV3vCDPDQD 7p4f^]&Â୻QM"%U  wPd?uX$epI|:eXa@ `` /////- "  ~@f%pDк߼ FACSPZ 4DBGP4BHP  0938 A!  8  APIsCZOK	a	Q
@  		
  MCFG<	$P	     @(@
 2! RSDT(  	f`h4hYf  fhpfp  gfFgf  FPT?R ff`WgFpfl.Pp^$f3.[.Xf.TfgfN0~$f+hCpJF~3ffgf&f.>f(.YtX22@_~( N g&F	f P  rgfffff+f+.\
ۑ`M.>Pf
$$#D PXff-qAFV3g&fFgY[pff=TDSDt3f St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr>< uBOаNRUfQъ̓2 tPxprAr v; tg&_P)XfY8]МVfWfV* f& fP&ؐ@(#f"fP)fȀ$ 4 
Ȱ 
ff	hԓp (f t  fPW UfXC 迥vt Z
$vs߸ g  Ls*h1 <Eg&gx%_f PSVXY [ \3[Yt >Nu	\Bi> uDb& ߩ@ u  D` ^PRW D hB ht _ZQ4PSSqSguPBP3h f&L *f*`B'+p#L fXP`*hw0D" 03f&?  P 6 Pu_    DOG/Pf3ۦ{ p H   U!   3P>P&geE E puMPMLGfEtXAt$Ot3 t)O$fM
rþQpmMe&3PaĒҒĜU  r.p]h%2.$<}jp;   jøPݳ kjWp_±{f
phk0kf%ttӿ' t?PE(뭿 5)cP*zio_ԜVΎގE>^ 3f`FF  hCw }ur h  $g(,0w4'8  cÃ9FtFfNA:F> h44;ɀuh(fa`
Ew13ɊMh$ӯt

hRp;r#uac5WF ^SCf fN^ѸNf.96u 6tc rfQPH_urf;^uf;Nt;~ft) p 
tF~U;_ս NfPV t;6<..<'t1!RS)hn:,, 
 ^_V00 ?u,h$..D+hXك |p1_fqtA"   u
}3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderlGEMPLUS GPR400lPSCR CqLB REFLEX 20q241 PCMCIAvReflex v.2$cr$HP
  a@k!g&O@yGd `P ߳ rLfK snr>G	 .WD
A O@.d.D4f_ PQWȹ  
G.g&:uGY.5 _YXQ8t *Fg 
⡤'fW
"
@
0Bg"

̓%Qf_B`bSh?0Gu#| 虯 euu .!u = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.!؋V@< t ^}Jw 
x y z 濸  h=Shs{ %ZMhasia
qTrPqtI	f} b
u 
!tQ& >s^	GYV
~ ,`؍vfD   ,AfLs-<t(<#@06 h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXnf`3Ҡ&w&h#G֎fwv*`%hUgf9t0Xa` 2   0 thbq egf@ Vff3f"gf F ff!
!޾i3۹: 8tCRP #ܨt ro1hf uf@q  00i{? 0    0  _   q'  ' Dߜ 
 Y/[ bbƬk`oC@GY kVo6PS_.xVW ό׎~Qr&} uBr	:`_^d>r59r!Br\E@&=u	_K#p$Hr&E$7uz5ýs6bYӆa
r&a)rI DTtr&ϊe`4o5z`
T3
K`їuw4Sr#@itct  t$?B!ffLo  	] 	VWQ
R3q
]
{6i+W!z Pr8u`_QY?_ þ1L[ r&U߀þgNLq`
Pw4$X` $2L nB0<{tH`8u6
uBp & DBlTt
aP 3 r/) r%BB!J@ 
; 05 a<t

B J 2@u8` BŅI2۬2؇Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&~a$vQ> Yr	{2Qid'Y߬B@Aq Br蹐L^	 ofpb3׾    @ P`ңP@\`j h\  H hS7(jkρ hÈ`% `f= @u [jg hb Sjjjj P'= g[ h"4?buq?j&v]Ԗ$awtQ= ;tau= w<t/Eݳ3{ {	hRZt`jfaÐ     tHuuu):p*< uwuup@ z`34jr! grπ DƆ    r% Z@у-Z1=p$Wp_ǀ uu' 3ɟa re+ tg	%  .!{f߾$  fw tpY[rs3hƮ  ڻ= ڻe ŭF  ~f c `W tI
r=> \Ӌ~ t@$@t0(5(@ MF t w0Ó3N !F ~ tٳ	e0鰠SZAt9A`d f` W܋f3Q fY@ Ix G"
 /2uJp2:!&= t:`T߅  yr $l0VQ&[Uq
u$sY^D^
%f"A6	
q
&:!& :X. IhBB 
Dg@P ;(3 ހ?  A-ݻsC"upmiY1u[	q	1D!IFt3$a3; 2| + f~B \	(Nf@2Bt1Qr$!$$
7R< !Z_t'
QVJPf^DUY!Ұ.&$++t'H"`Xtt.A
``s;߄ 6sbd_p_pkoCcqooo#Udooao
fo蠫Dbcםasf@SfQfRp>fGenu fnteluxfineIuofPH>f%`f=rYf˹a2?I@؀Ut/f00t[fPF 
= ZfYf  @(r3.À! 
  M   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h~Bt & ^[SO
&hk" `[U샿VWƿF F@    $a F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P'= K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h5@\2%PFA~ t
F_^Q
h>ss.&udu   hb,$?wط h+0"hd #h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	?
   QVWAu% p u  6  | = <tk ;E@+9 +_^YRWS Ê WCrr3ɺ ڑ܋e\AB rN _ZqSYKK{K
Z^QujvzO%NOJ5> DE<@ ;w<<!<3Tu OOpPt
Pm[VfPfSfQ0ppf3f3CpP\p|pXfffDDG(	Dh fYf[fX^v#JKgO GxpQRC3ۊ%< t CΡҋwyB`s|fDf3ۋfç\` 	
C  	S T R U 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.h
C^[+V..^̋] }DF. P .?h?b7XhJ ؃6Q  16V  0"Wa X Y #Z  o
[a ` ^BA\a e f']va a _ `gchi!j qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ -w C.=ő/⅒2VRm?n8o7Y3۸  =_`߸^va>QRrPS[Xfh"(hЍˋh
3     u     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;*v   03/30/058Y02/22/06 kLite{{-1|5?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$dPx>0@Z"2""Pf6"Bx xd} @Suu u	`	]^@)!T$3TD @VF @~`T?0	Tb`T%_`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*)} + 5EFuu!+;үx00PnR}Dxe``
$`$p

xe 
xx txDESxxxxgD@.0}}@ v o :}d`xGNB}E%x}DQ¯00xtxtyuup)ސ}mQb}ts ,{c,{+"(xkD00눀 x^Dx_T_xcDxfTPe p# * -aasV2
,p&0*О1I	aTx"B2xi~3T0/ߴ/D}p!T` `%0u!	' T`#8 )ok04h	%P	2;G-"!
¯+u+$4?j~T+}'#o+p (++Ô@^,p+
 
0%?
3
ov7b",`^0/}^j.@ /P2'`" "+7x&x+Xx_`t 7"6}

P} /}	!	  @$#}!}a 
x xt"xd}A}DѢ"+ Q1}=
P[f#J00x )xi`xj  p@0S+;P0TB+x+¯0*D0b 9(P4.
+@30A+`xOV	+ xTx k!
+:DT~BKPF  y+zP>֡

 D\Tdp+$!#P+.` 8j`Q ðÔ2@YD0¯xx7x8r x00A:`6$06m qBT0I`	pQ6UoV̐;q@&(Z[0/Q+5"PYPY# MYx,Vxtx0x,1AQE0xT?Tx*Z-tx+ZZ @?TxY[M)^\MN '	Y_gl`1l@aux`_DND0=K    W>Argxdp6r_	2<;f["`hPlQ@*ARx-	+_SRNx*SMx+` L >`R0 
@qeQ`
 RSUPP14 0YN S~f GwXEWxZAYAXNSXUW}X$0Y԰jp^qZ1ZTMZ1
YIZ[n0c1}\\TRO'\
r[	\S2A}@ A}= #-A~` B~b  5A~a uuҿВ"4"7x'D
Y /7d`!7h33TT?OpC@~`07`'`2`=`HpQx] 6uuuul uu0 uu5ˏO$ƨpN`0T`
010'@@@A"| }(x]Pd"+,?,E+p
0 +C,,+ +,+x,?+0Py!,,,++x_,,"-.T0ޠL72At
!Mt&Ipd `1g*11[tU!Ҍ(0響/0mp/l`
/0dc@TzE2AXυ.-/0"o *xc"+xt`
o3x7@x8W7t}Bh"[ZYYcdᶀYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >gg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D2 T ` D)Y7ax2tx1tI-'%[0' 'xqvv `'xq[C Wxs$% & & #2x1 	ү  ¿0 _%#@K ӿ3$b0#	Mx3C
r beJ"xrF`V0 pR$" '	x30%(0&<T`P$"xs`bfp
0#% tX.4} 
xs$3z 
`Hp`p$W$ ysp R`Шxov"x0	wD0߀$$6@Txy~D"04hxmx~@ oDT 0
 pcPB"pxu1xvx}"xux~xvxx}	"xxm#xwPyywxxf`Ӏp>xx( Qu~B@
"00"+000u0 u0 
0 !$0<HRT`  }
0"HD =16/(!a0"0
	0o0"d0 $1¯ `x1" |u T""?3453/:wNP"3554!_Q0"0"xoo`xaT`}xnov+r!3}TOp0@0 0 
Qu]P:0 _/\P'2;B P` ?Ӏ"786 "0a T?2u$408S0"{z}yH237U9
u89 8+
`9709707@2$h'@^0p4?


`פ$Y	0
	@À{0-$`
$`$p!a"*V ߀K0":0!)@À-0s
   is	 280"
2xofKp0*2d|p08SH{zy xpvJ%_`gK8P2 ( 	4  "H	5345q3`	t%5544r	@ :0	h0"08`	2A08< Lr@1 
 !
 +90 B 8, 
j	" "!`BQ
p0(? 8!^ 
-NU
]DU 8.
j'|	20"G+A6,!,z$f-e2pO7)0	LP85p
b3=&R0(51	c8	0
S :(":"08-8;pfpO:24`"/c)VP3
@IOCxn`qe`?0}Dp h,g,["a,a b}iv"4xEMNOpxD Te4`^}V Vp0
T4d`#R"4#ß4p~}i4xd@3 0
3 #a`3`3$`j$`6$p$$`>$`$`.^3$`qT$0 DQpAh0TxvSoKv`@906$= f`@`Dx@[30؁p	3^P Cp 	`r搬?%¯3~`0@
 pTU`xk  OV) .Zxv
xD}S%0{P^`
}mT?DtY䀑PtYZT[{S#@`T`Q	067``$pa1e7`tg7r))]*)б'0*a a
Td`x0dp#  xF PTÔP
~@)xFt txBVBxNN{}wWxJqJp:;<t/?=)x ү!:%$t=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xv6xV86}'#p p 7  %76'ۏ7  ""88Ô@ fp/pP( @ /..d`
&~r7(KTP5OG([ 4 kD4{04/aP453``/`@$pN5o4:I&du*):P~ [x 
33oppG+L1>gp1  ':P"T~ ,P2}7?T#>үd`pxH m8@22P65b3e1@dx>
1/ 
m
@d+0xA%30 B1
@
 @>00
TDT@5q0	 3:@a5 AP}Rt
} u2P2b퟿tl@
Ȑ.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2*(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM5"^p  d-u*x0,u`2:E,]4 2UU.X5-?k,*8 2732pha,
$+O!% *R5 }
Q'x`S+0	+a -R	++`@(s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp.~LDy}?N%@k53.Eop;OCD-qXċTQQu:93: !p	S31&B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_/X6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/(;u1
p< u11wQF+B{!p4 z5z5
3z+',yuv {| A, 90 & nPÑkT;0 ,	al{9ŀpd010 upo6o,/-.rpFB}}0
P/.-<rdct%,f Wu tq70YS 8S;":W4쑔p1Bߐ}BT_0W=_<I?`$<p:T0Oső78e`pYלBxgTAx`%daz0  87>P$3!}q"W¥AT3	``Euqq
r	1Q`{0V
}
9ȷDrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLx;pG3p?u]A1U^@5_:`@TU`#v@|T kx{⿐}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmoxup&xtPxsxrxxqxxp"pxkv00,pTxgLү4F" .3k0.TxgQg/`p0;P .^ ##----*i C27?",u/212B0T-21Կ^ L-_. 'q,Đ/#ܰ7!,T{AO-q.`۷pG)QNm.E.OVJP7!0po60Y()oy0h
P5
Ps|?`d7]}SPn,rtXar4uN0 f`a27Е
p1
P

Q "u}- 09rg"l  },nh1vg8  A3G.02=.pMR1s0Do@dT0u`zP;DS,c,u.B.` 2 p0`u.T~a1tC
.%TwOлQN]03p	 `` 9b  $ 9)NӔ@6S ? x0!  x5c0HQq7prrqxvWU	Xu

		0
 p`
7$P"q 
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axk6"]@tX C9xVxYFdҢX\`T`HTǯ
PMs>@C!3"x*"U\]@0!Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`<٧<A<aYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0tǣt A2bIAJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G<"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/iJK
g
b^0JKoLM`N T&` @ws0uK`K@ 
MLÃt HKJa}m}t}}{EAMI"!Z..C@) Ô@""7xo-"xf· 7" x`xo-"TxD0TTAp ?$0+Z2I:E}@UTsKF}R+U@@@@@@@@@}@w@q@k@R@9@ @@  @B}QoKKi" 5fbrA@t"#xb s o "BD)!7,	R#q! b* 	a^@`:wV䀤R@\V$`RъAb $!AUӔ@b"UQOȯU0	0!ZÀӒ!}BU`#`5`2$pCxD4SS [CxaUUTxns&@OYq 
xjPy GÔ@π<PT xjCӔ@/`B{r
T"  PtjxfPPav+xnv29pvtpx4}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAC@y*F?}EGb k${E0U`Ud`)5uURBD&D2D>DIDsDDDDDDDDEEE"  {E@b:KD PstRpA$9@pC"-aE
 mpT g ߗ@HL0M7 qv&T E7@U2xZF!R
hap>@XÔP`A@8O0D=Dd
`#p`(`0<`PdP`d`UݎU0:NR^ˌt td	Rxtx!xXx\x]txat"xbtRxJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
} %xtx"Ttx!TTTaD	x?D}@xTpT =TT	Tx= Q
@TxDHp?=DDTxkv0}Gt UdQ eV`eTeP}S:"x0xJ"xh{MMV"Bn S?/?@>"a䷓$tO>$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H( H/+H73H?4HG6HO7HW8Hb9Hm:Hx;H}<  H=TY1	 IQ
 I`A 91~5GT& 8 `;cuTuTK P0T"$`($`*`-w/Arpu4P
T1B  GQQb U T"VPT$m߰QIq|Ib ] $1~J$cpJ`	xt x   uT ᪐ ! j0t p  
A^:32  *}0B :#'/A0`,`0$`3`G`[$ap]Tp^"T  dpF^0$s  `!DQT+wwq}/0 T U "&$pR`PMUQd`QQxhQÔ PQGGq@P
qJPxhv@KnKnKnKnK{KKKKרKKLLLL'L;L}LLLLLLLLLMMMMMMN  MU0
?v"xEMNO`u{R`RRs0 }iv  x]  "$"0R1g?
R:y H气bЄ"}} HGN}0"uSp0?SSST
 TS0SCSp 10P 0@4xathvaQ =pkxTxkoD0SxP0Uxbx"x@$xx"x`}K}UIF	
Q@ Z0""3GxT| } ~ NJ4|Q`*OU]RR &OUMx((sMMNNNNNNMMMMNuN{NOOO!O,OD.?oNÔ`P/QH"T? } >00x`r"QfSQvJ!0pV	`50Tp:uQۀ0 0@I 0)؀	\S":C$p
:!/0Qp,"xdP P0A3Q"~}i y0?H܏R3AP>2JReue?0M}ET@J`dCe!.0fTN@g QFyT00Td֑ϐOˀ0#@60xD Txi_!1?xxivԩdݐTP FAA=Ap11u32}'#  $31T3322@"P0  "'W "   p}"/v)PK}0/Ô/pC0S00Pm2700谯"
xpo0 "uox`2345%@"(t?3t 2x`325R4U5B axQxQDQGx@Q  09Ī6xT6`nTCT0QCQRR3R4 S@SST TT6x
ߎ/0!x
tP/P
0}/ x
  x
Q{Px
m! %60$t $T &Qxt	}XBxs0xsßP2P0 p%@$X$ÞPxxs`1 
`1`
,-u . <Tү$`&p<P}_ p% *B}x.-,6	&xxtӔ@v $(xsvysxtP!  P&0 	r6
pxov 6xa`r
pqfP 0	,xx
xR!x	T7)`mPM$3p 06d2T` TgTqT{TTTU:	Uk
  U{>pwgD4f D@ @B@"xDbU$P``3TO֢WD#X0 ,oD "z;9Tph`S/AE@E +@@CZEtm O@@  { 33TOBOT?@ 20/ 
`Ο`p}Tp`8 -5,, F4S,z  S,`xevS, ?=S,,"+,/?0-WbVx	pV}2xNVu0 u1ATxf`-30(Ӕ
P!P23	D3E2pYMSS0S3u2 u42U03U1Np1%1030444 P-5xp7x	41_0	^p_
55ϴ-Ӕ@xA1 w YG60c
`/p00Ӕ@:x>0-	`	WWWWWX5XPXkX{XXXXXX$Y%Y&Y+Y',Y4-  Y9³-`:S	Y@xu/@xEP^-.^P
.-0]<	
x39t?e.?pt e-`0p	3pQBp"	`pEx@}v}t*p
.!  2#Pt`-Qev`  q} pQ t u vAO}	}50R)A逩 Q!qp^" 2 0 ,+"7``{Z`PYYYYYYYY	YYYYZZZZ"Z?ZZ3Z  Z^ \Z\s U S1
tt)Ʌ|#	
2pt& !^cTQWT0BQ
2:ԳP^`p a'#pQFdЉ]P  rgZ `!L0tGNt(Di4rOBkrQ
xbn)SP`DRQT,T
qM0A#_ "gD `C - gt .`T/Ӕ@"À--d`"` 
`-\?.t %-Ue.`.6Ô@aG\>[8\>%^"Xto.`:``X/U.`"U/`"",pP/m`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$U"x@!~"5}67P d77p676 @5242'   `"? ]P2]#]3]]']A/]OI]^J]mK]|N]?Z][   Plޡ"xl! / "0/mҐnpx#1l^$P  P1   
0k33%$ae2pL2640"0-4d	%4
4Uurov"
@"44$`$`2$`B$`J`[$Wpk@\P ~0/V_QRP"D	qvk3TW4Au24p-73VP!
PD"""" @@$ _%_-_3_9_R_v____  `u2#`
u22b ! 0"8t0!u2F,!wu2=rq(
C^QbP(6PrW2UDE. u8
Z/0"HQ 
R 0 3A2"0"x%0qT~t@"ï@P@[@	T<" Oxm~ < "ܰܐ}t0	}`S!#x0x!TT`D?ƨpT!D`!TM"1 p>an_xDLqo"  :	;
/'
123B=>C	D
WX`~x`!`TP ^`_e*"
%'~F`7`i0x+ +cx kx}qb+s+R`C0/+xT 6D } 20㐕sm DT_`6l PwTT`P80w	61 b S 
0cx	+$```9 Abxv pz q DxT"xStTTHaH+xS+<x, 6, G`$p#+pxSx+	x06W0/QIq

?0aw "p.!v@-Ӕ@	}-A-$``
$dp<0/yC.t}O.l+ d P` cD>lTcPG@@|@aP-Bp}} ԏ.ke2	C.-	.@;p1~`J$`S`X`]`h$epj.>.
cdx.!<"dpsi.0ӗ0\0T: Lxl..T>xf.881.T{P{ _OolS7ӛP	O PÞޱd`Ý@ӛ@*ÝP:;<u t/4؁7t" ů0@*` 0I"xp,E" 	/014u5Pu<$t}5}@ɣ/ fffMfffчfffg"g"gkggggg˗g˘ghhh˟hˠhhiiiiiͧiͨiijjj6j6j{j{jjjݷjݸk k kkk4k4kWkWkzkzkkkkkk  k~O0~*~ p0`+ pC3/}u: u; u<3{d4lT_330P6~ 6` lR3]`07]5u3@u:u;}u<{x]u{{X$::;<[{&5h5g0  WUh)g
U
-)K>,P7OE` 
} P0C3ۀ+R#~ 0`| }` @?^_N#`##(J
"&

5P)*)Np<Id @(
c# 111{!U7(+/U*
81,U/'h3/1WU5H13O/|.W1RBA$__TWB1 u2Ud I'8B=U9'!'8FUGXC&UIˈE(L͸G*Uo`VI-#M@6EP!}VbhQR/"qVÔ@πu3//\C4?"$y`!SPvnr" ? "@A~K`j!P$`mD`p&A`#0#xt@}}X} Y  ZxqBBxtPBQ0%70$0?"Ap
 `_"&@AOr+ U 	Y	Z 	 
[	Bxt		 ":cx>T=Q
38T>?`dPnP?> I IPw0=pR "08l= ?} P' 8@
Г| $ '>d0
ؗmd Ep6ѡ"}6`~M }r:iQ n6#@!1f}ϰPLTTp{0Xt
}"D0rk0}$+@t++.
~M_12Q^YH`x
lw@&#p0vxr2 
41q*no"1o4Pow1xe 60o6
 0A͋ O6'j`}pp
T?T`4"4"0u2<0m0`=~ ~^y5 0TODԳ001p322\* u1C0г0 	3`PP`8Pt2PD26B32ep087P!c`&R@P}`"Q3"0T_POs"
07/% ;r9033@,p*e0`C0>&2_Veѥr90oP31!q10~3  ``Jgc9P	1Dq&J@T3``2;;@+"45675E4`54iP
(4~h77$`cTo`M4TM >`` `'p-?Tar E Dh i01$CrDe0sPB2ÔZ	*u1au0)'2u0p
1}@}]3결ӝФ2u2u0*@> $3v@20U'`!c@':
L`2p]s$El;800s2`&CTATT%%O>Ep`>3`#E
X` 
p	0d`0aq1\]T?`<p7!?$p*|3tT :+	 #c]PH@00	=2`fO"c"'Nc#բ&O$'NV&t oݾU$	?E?
o)$U	f??u)txBd7eU}{z?yqAWk7wj1ww04<t`9n au/'P~ sO./s5%tS\wh~@_!\d1trvp0p=T`qN`L=2t[A	ÔPtc@1qo``@z45@b/Gk4373 Dxx((sxy,yMyhyyz{E{f{}S~<~' D.Op	{ z y4mO	5P4F w
QhSDT|lS1
3D,t~5{u4`u5 	]4T`pd`VӁQ?
p0
PFu	$ߑ	uazLoBmP[|У| 쮐az[}Ф}O pm1iiiPK
5@}
Np&|$0/ԙhiz (
r}67d6PN6@7"PnRJd0,ve5p4l`&{JA!u8*8EU"| `z {E` @\o]Lvv8999889p#!#f8`9#
							@45q0|F 34t[98(d`픜!PD<A-0/* 
E0
jZk<ÐIIP2SU~dLptp#aM`M8@_ʫ1mpl`T@
`r/@1;ňqd?Npt/,V+/XPՏYP7[ZNp7>	bUodAppNCWWriPҞ/'P#^q/i 4J(?d)n&pf1 6r<AFt=QVv>aBfx?Mr i},KD|T-`M098r0,P78+3 7xe3"27傐}w3P Ô|@3$`Dma c $0u~ 2 0uu3#ux77pdE`H30 `at8u@Pa~ZPt7p9TT Np: !p);R4u3
tu
q$
 e3`37 1a`04t¡0`w4Кm 1 e31TݡxA0V'΃g1pϑ2b.Ƞϊ?2"u0Xԯ03}`Y%nԐ~N0:>F2pPu2f	op`8
0tі
``xӕ1)100! xeT`&}$31dtPw2"u}`q 
p"""4}t@t ?P
3U02	~LTD"LION ~Rmp`(PRx33d8`*"`~ }@PMapV02btjP222  ~_2~Q`\SRPS@~Ptu4<P42&4ްru3{`RJpT ;ZP~U@	@3'~^p~ y@3hP\p"00~Wp"/0634u5/$*``0$pB/}u:u;~u<V{d4uE`eW{cu/R{p>3//u: u; u<3/r4"{/
` 0"	` KWTv"/"#M[! ?` ^1aOVt@P]t~XqB-`- ``C-ӟ@
- e-`P@  KApt Q`
^Pp-"]XfVC p .P`QR,V `"!`0vs\vi 2'7i`\a`T 0.3PT&,4(.lP,vt@p,0a7	#~YxD`d`X5*67`'`7`G`K`Z$fP'Xt2hc``\V@Va$M0IdPC2
::31p(P8U!#3Yp3o~Y"x9p%P
 DKӀT^:p
"1!O~ d!_Àz  0d"0Ӏñ 70U8`0@
D U
~,T e8S@BZp 21PY0`U%PY `"x0  ?5"5q?"px 
Wqevs>1]>~ 0z {w`  on`dx"7@8uT|XN`,7`bP\P ] Pnp	84gk8$b$"8ߏ9I;u<9Tbae9p8lpe;;9E8 `v@@~+P"~W
`a0&Ȁkl::Ӕ@:@ϰx}#,	: ,A=x@A-o:4P <p ;m
8 9|0=<>?u@`"H P/A(p??p>?
> +@55@@	x&Tp/"%T~ O7&2w@"`_b"x!To`	TTp57|3o`PR12D"C
xCOpx6p>A4ra/T(--,r e,p,Xae,`,,|213>d$-t"u;y2A&8<9@Ju;;;`P9:9@ɾ56x>FM+ pb?b665Ô5P	d` 
F~G5CPM¯ DAJBO*"+,U
,, +, +@7`S@T` OFG-$&`
xt́
 T0xAT1T4T?Dx!CD@p
0g1dpa3N%33+P3Q@
4^``V4cN(%%}q
OPZ`a00*OT@eT		"TYqcP`_` #A""	F	 >o	@2xpd'X LҀƀԀi@o3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#sB"P""):"P%0 "b``"ο.` "  )"/33@p " 3@P"Ø"0	Ý0  _r}_0"(p p8@
!	P	^t	1a
b*q2P	1	"w<t 
""BBE"""ЃЂP  tsn6 s)ŃŃ& "%@$5|bpp
߂s@h`߱5p5 5@~5v$5@n5 b5V5J5e1515 p5pܟ5v5pv5v5q5#)s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   q  3O   P DSDTDSDT  "HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`$\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[D36!7"38'5 9AX3BQ CUD EAFPZ40410+6 4a4`U245a678Q9A0[ @34BCDaEF Mn,51
E! `pEa41a}aoiapa ib{ab[V102'
_C _ADR
 [&   m_STAi `	3p
4ʅ5056
T
C[p)56Ptqr 5 D07075}7%o57EB2~t58&p? k A#59 [#PAK`u5B5D`p` p`bs57eYe` ap dpy0cCdc
{at
 b0zdPx5Czbbtd
qp6pu @2dcrdZ58` dza
aa`{
PN 0afuff aOdu`['A
Ja
EL?

 ЇGA
Dw `xH pd2?y '&Bp}p} 3[A B`60pibpkdrd
ed~A
d hb @brb

bhb1  2j3Cj0a61SD 2`K661crc6}3BbN0u4!wari/5Eab\b\b[]
q]
bu~A]atb
bP c]a%
`bac `/$365SRKr]Z75E
61 }63c)626P=aa3q`ܱ[66@1Eq~_S3 p 4D
eK67U< `W

QX6QX @4[ p9 [A%@ 
"@6B
 a@{^.Dh2BACDQDF@[B:H 
E
`
@[$EF70jQ 1 2r^73aW7W76 @. v77AG7Pq 9 @g7A P]7]7C]7oE F\80F#81 H`82 Ql83

Pd1384j85 
<[= o  @`687 8Af892@ f8B 8CQDp8E`
[0 F	 A90P
aT96`	 З92T93
Av94$
94596 
!
pW9X@`97  @ ~98 qx9A
[! B9CQ 9E FG0A0[#\_GL_"bp
`Ӑ{`ʔ [!
dv`J`!9D9E{hjp
p
HrE>"a 9FbqV[Jp	rya
c}cbaa A1 (8` A2}x0 A3Bhiq`y`j0OPA4
Ϡhݠ7E: p3 D+Bpa(80Vv1(@pwA5\ip@"m7ARPFbA
i9DWF1}7B&$r8C}j8_0[GG6C@:*BaA7
@
[+ лA8A9Q Ag "$AC06D C AE
A`~9`Cנ
p	а  z{` `za 0 
bw
t
	rabC
 1 1
1 )U{brv"OL&F
pI6'B0B0
y
rw iPH2AB}`Da{P ` 
p{z1 wi@{a` rbAAFb yC11	_9`pBw
h ncN }r  Q  AA3
ccF~B2
l
л3B3 B4 Bte {ky
\ B3e} 0e Aj
z4a{`цVxq5@p #b}e
e/\p !	e e$}`@dAy4{k
\ 	``;}qA
 ЈAA y!-A_p?d1p68d pA8"9 9eM@{B6q0fB`7 D adyce@
QTѢB8hif"f
_j
7@
EbdBW	!ba'c@z!Dby
VPMT6CTHPCIBb(p`oAb	s@bB/cpyacaABw'C`CDe  dBb[MF`B9ŅGGTGGD DB6 7#BB
@QBBPBQBD-__PSW12B`k (!`A/D[(0@E֡ F C0c	C1uVm	Vo	o	o	o	o	o	i	Rc	 @o	o	o	o	o	o	 t.ҙo	o	o	o	Ho	o	$N!T%[M 
5c#x(`0833bý
[@PCB /@CC
P
[5  } CD K [ECFвD`OлD1  0D2pD33D @~  ~PD5OT 9 62VQ
 0D=:
cN`7
  8 f0D9DAA!D$/D(D///D 'D//f!e!(.G!G!@($3( N #F(F//M E0@ #F  // A eA !A N A GA "A  "c0EjV/BE2g0E2//.3`03'3//a0%1a0%1a0n0a0G1a0PG1a0@1BEtJ  JHE5	E6	
#?  y  Eh`и``
=`p`apa!wE60E9	@	V`Q	o``EA` a'#B	 p$Cq з	A`v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)$+b1r) 4f;c!2r)C EDM h13 r)$ U[(iA 4r )$`k0	jQ(5r)3F{8k6r)71^>8B[!a42[F21F3
r 4
 {<5 [#"GP9u[@KF-26 v1(W 8E,C054zF/8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ(FD
 h246 ` 5*XEc7CZKFF
048`
{i}`h`{`h@48w{i  @ o5$ q\._SB_C?100tB~ o._DOSq	o4
` a![^ 1}bb ha[7ɠkDCYFC
 G E S=SaF
h3@˚rRcp*r&R%\$C 

 
h06E0FD	8hfp
` {w\/002<O98
Pt1`0D  Q   P Cwhi82?`
hA@ \\8\/	F1 Y5 @E6|6HmI"7
 i 74hj	~ 5hijCqm8c.50h92s 1 0p
6Л93r8F2z! F)9
^/p0kl0^LRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10BF10 #0DE_

p1F@~111`
 2/_REG(pip{015
 a	ia113[A  @@@0140ް1Q5p #  6!7)U8A9AB 11DE mF20+{21Q 2 u3s 4b252678 Up9ABQCDEA130Q 1R333345k 6s 7@,383ABe CA3EF064q4q42j 3A4045Q V
474 Q4A B_INI >4C 4!4E[   I F @C150&p 1Ph`#Ph3Cphf % 152v!M3p`\`cp:4	wh
@axa
db`t
@`X@	
a
@}a
a
y`Pd}`a085a azw`
d`xr`
  
@bauaam"@6~	4Bw	6
7	
4B58
q 9s A;
QB
@1D E F
v60161$62
Unknown 
NiMH 
LiIon No@\61>p ,  5A6Fy1
X5B
a
!D 0F7B! 6#5CSC^5C@)PEӅ}#5Aa{a
^;5A}QސE58!
 
fQ!9!9D!163	0@1WP atADQ64	 Np
J{`B ID65
[)h`pc0P
csc
  dzi`r`a[)absdUb1/2*(ccC 6	`hg3
@v64gG
wU8261{`g7`8hQ:C s81F@]23Бa9h 1 126 w"Faxra
c 
dcbpbQb6]6060r	38`>9a$(`a-q-8g$I@A
I+Ep_
 W 	ip
$q:/99"29cBcmD L 0q{``	{``IF@5E;4  9RL2ccdp e_eez
cpe'cpci9%4?~ |p
s5I%0`p
`4[5Fv21C-+C_@+naN)p[1DQ-  T(
>
>2(P2;pzQ{
 5[P|%*!3(B+BCBH`*ae(a5h/C`	547ata
aic
bzch!

D

6Aaam34
@ ra 9PQ pUaupaHf:bc6h640>77@EBFr?00 [m
Т6DrAxq
HP   a 3A
Sp
SIMPLO0~SMp
MOTOROLA a`w釁pVE6E
p
  
Aj(_Q0!3':Q{BRᱠ/B4u0FbSp
a4E
ba:@[TZ 6F 70['cTZ3_J
6|pn@v
J` na71
[1PR0Y1A 
 1_2 N8Et# A0
B2T^3#9nO1169a̯_2316

,!
{ (i282i4A1
 4[cIp
ѹ76
NĹ 7@78F7N7877 0q CD Fp788182s 3  p^85A6!87
[  ћ88Q9u88B[8C8D8 m z8F҇8C,UaC190A
q8CM&P91Q1`ћa` 7F`
80?0 `90Opj9293sA 8!cA2b1c3yg4b qa3B6c193zya
 "d
b{
 bdpdS c
 c
Оcؠ1B`948Fp`kaPϕa
v2D albab`b
vMbzb7N82p`F819q !4ϡ#!c80Wzj
a53-6=P5#'7Dqbb	aq bb968F9B7C ʠ`7
79 6" p4"C
A8
{C039
`{  ia` `P91hp!
`!Ka)9	+C)hA20$b cvV09abcA@'K9A p^^/BcIY9CL91
!+D

Gy 1A9F4 `;A192/ "9@e7D[N!P1F_C  _DDN
COMA2A36
30U"    较8y `NS  A3D_STA 3{s\/ g002fW3C0A2Q!8
-`p	ISP_RMV
{+ dl038pA2Ρ
qF_SRSYbh
a4 S,A4r4+BA2@
_C
}{9

 a`e bcrcB
04xA[jA5   
C6
_ON_D7_OF}FPR0_5[L$P%6hM" C
_vG 0" *
' ~#,$[#u82K
AA7 @A8c;^,Pr2@tA {A8R94A]X
I A * 
 	AC
r
;P0/!)7!C"Js"8x""u"4C#2f[
Dm$i$!P%`$| $D[C:0JEAFMp=  U~ЌB0
.G"-5dNB>BpBBCJH
1 Gxx&xx"٠q)x)xxPM No r^r_ @_u\mTST0LB1R q%QQBq2Q"1QN?3?303?<RPV3rRns1Gym3 *o32dSbrB244@B34?V4V55 X5Pxqyxp
,lB3 @r88!]qB4=]75]Zq&2]qBqq8_B4)~B5 p\/0syQ(`O{fx !r@{BP.T 0>QBP9 ?
[+ @VBB@CADQAzBC0 C1 ; 2ACABpa"7#phA0j BC1C3@
Ы0*4&{`h`h [@p\#o_UI \p

K_PS0C2 09ߒ98   ['"

Q0>&YD`a3 Ә
x  "%@uC0g1C7y @#C3 в aC0   paJC 1pF	 z`
a
C7BfC8 C97CAQ `vH1b9$ Cn[OCB$aCC` &'CE  D0D01
G``Gpp +BlCF
PmDBڴu̗D%)CDC}D%D1[% 2# =0"  y'q3
b@ @ " W[ր=A8
 
q@
     *"P4`9r~ra a !-/A
0 p Gr r " $A` `0Gd d"[ID}7
" 0\p[0@9
D8P `µDկD9x =O.    ހ[PKDA2@
 9
 
mOC067D'ADR   'oDC
P[0<DCD INI	mDEuԀEFF	C0a-PRW
	
[qTE0@fE1aECBPDrE?G7M7P2E2 p[PdGPE_L1A`aaD
C0w	0wPPM
@@E*
	 *_EJD MpB.AP CQ kBEQ F0E4Q 	50W0E> D`".9qaƓ
CQ1

*SK3Dr 4p C*O C <N

[A

D (,A_Dd#$#	<#
		C ,						FC0A6 ,C1F, 1A#C E_GTM p3
) `02 F3 pF4p E' {Qsn3
0F2!FMhhhF瓇ip]p
wP5Pqa:` `A` bwb
bw`
cib ac  rb r-c u`A
2!Kabq6%
2cF6bcpoF1q:6 !{` zv0I([$2 ;F &uF`088Ю`0i7	?
#  Z1 m8OD9ODAOEDOEEOEFL`H\_PIChb\/}gND6MT MqK6?E

`O*'   +

CJ #0$ 
 GC

 
	
IQ a			 			!	Al	5!52#q "cD
%6,!q|!G!H Q J !G.	!A0ET69@	F
q}R  RVd
d
Primary 
A   
LIon 
Hewlett-Packard EyTraveloka	8@ 7-5BL66	004h`/` %
 
e
" 
 
qZ69hgAPBAAAˑ10FAa
`uFA"p AG`8t7vv
 0_ jЬBI Yap ST .|CL\][Gp746\2AȠ)CɄocPrʜJ@7 
ACPI3	G	0R/005`D05B $Ja#Bp&]PR0 1o=81``[ T֑:@$
.LID["AHP_Tab4PC_Buttons b\` 
5
	/1?5?@SXr)JNq'6jҎF C200 
 1 2u0kpk`qh`piaFa
 ?{qя
 a{`
 ks }a
aakk
 kЋ2 14 pFJF  *203z

- `r `2`@hp}
נyj   >qb1h)h`@p!	` ibppbasabcpcau`a[5p45
 ! `b  ҕ!6I<N7P08 9 qAB	:  p
`M
R P  r
` a  C D>Bee[wre_
 
EAEeA2BpFAILОqL)ASECUp,eAMA9ASp^0(Fibxq10}Ur12]R3-3P
c014Mc@
U5
	
6
78f@82Oa= `#t@4	O!091!A1BC"Di0E)
EbF%CP4!  ZuA///SIMW62wT1__&O)b`I"+JT7 aQ=1 ``0PASS14v#A61aO`K22pOC0P p`4Dap	 a4CpLRM;w2PQC7a0lbb a~P b ub`yN@_1E5EH3h<p]iK4#M5M6t0N
qPӄAMq 4 5S0_WDG?
<4_c,E=DAAyB{M4C~ !f )AB WMAASij=DtZn´p{G6
j0D?1A{h
`o?{Տ44Pi^p,`p504722v*5Pv1c0  p_ B G @11p!AO
 ,C97221n#<0 T022M 268a{a
}@` `d`I~(Ja"	39P*	aDnKO!F:Ϡgp,14A6
b7ཁ2~!_!hμCh	2Ұ)A`;
1_;!m s7qaµ&&@56'&R@157-h$J:8
@$@ 

p
1-.0Cep
ob!H71I6  s?	p
<_\
p
_3=O6p
o
#)_3V37q37)
38Q521D^5KOV?C3Z  m) (;)!pM_WEDs@[AZPвUr5\Y\P[r 63s4`WQABNFOMT  m:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj',03[9

[  2A o\C1C+18_INI` [BжA[aBl[#\_GL_yh
 Bpi!pjk@E!04F\C0F1haF`	l['['`"C
! DEmF a30k31 BFphFEE3FqDp{zh
  4k1h7	D 40 3C 6430o	
305F1	PA\_TZ_48G,
@
|
0Q 
?b5 [P9
Z
F
<
2
v4As B

wC
AD
E
!F50s   25314 5W 0+p(16F 170
q 4
2"P7	py
h_ a{aͧ`@L8
i h
}`
` 56IOaqRb@cb
 {b!჈c `@b
pz~abrc
c^2`:P9`phahQ55i  `r@	ap! a A
 a bbHB  8@/
pR @56p6t
axa_

`br bA0

bts
 N2
<ߜP

	/s
!

V3D2a!0 !_QC#p
P4FL+C	Fh
"dQd$ p{rf2b1Db(b
 t bbwb

araQMpLQaS`AU1C@Z147aUpab)a&3ch 1'4h,n apbpa|&6bI	{8ob  =p*h1a<`%.  v03`e52<`C0h71C+1p`DQDD`h`@RTZ3_
b0C.aB
|n4;h `t`-`x`fi
 f
Op{tf!`f] 1tq2cbb32PAb&8! bbK	i
p

ep
d
ip
 drf
g&9d6;ef'i9g2 Q&?w1p/A	-Q\aIa[Mp]E   _STA7V#_ON_ ~15
W
Zs  _OFFQV8A_Fr
F	60	\	
<		1
2[@62,!]_HIDA_UIDs_PR02E[ n63MHFjC4605H1[G1 _AL2r 1CPAL2AL35/_AC0"9rwQ1VCW2B3ЅPSVFE|SLVPRu0Gm6150qBFas(Z!q4AGE *
-4E$Z QQQD_ToSP
dp C1wTC2CRT`v1TMPs[J18)7+1
 +8:
,Rq23 +A3[MTZ4_;
zH
`_o_o_oC13E`_o	`
dp
d`w^`rR_pƂEDdz269v72s7CA1B CW1D E!ѰC270 29  71[ 2@(AT7324 hlA1740875 6`UyA
	`ԐsF@/7r$72aJac
`rd
  b}y   baya
a0aB~6Ac  eraye
	 evepeBc ucd_cM
8r7cpc  bpbgC	bdp!e)ec±6Ae ffg
fape`pfafgvdueA`bB` gTb 	`6Bx$b pg~3agg7agubdM59a05%p6Ep0`cע@""6C D` u`py1 C B  D " Bh H
bhr Dcda
eC%-adft`f	ru>'adSuc2ftd gPr:`4b0 E7+Aᝀ,7&-91879`6E/
kBC060pibhbސ0Bpo7B DC
j0C*D"DD" λF5E w6
aru9abpbA0+b``babuaaxP `bua/HS8Ff`19PHt2-DR`t`7A``5`Q9XD!

	          y q3F[K\/6K28<SkHH
F81F
RGGP   @  -  @s3	0	  1	[CM
28tQ [19BF
rG G$ $ GN N 
P P Gc c Ge e g gt t     3 A-_1CB


W)3p{
`q ^^.5A\_S0_Aʠ 3R    4  5   M?\_PTSІf7H Li063rpτ1F7 AA'\_WAK` 492?`10uOxFx"1#15a	4oxex6Yƀɀs!@0005я10E

O"Facbcc:c?71
;d1T
 /PA6 0
 `@0B+-2N%l4,2!0A 1I\_GPEF5O
_L00
rrX0
I{` `{`
Oa% APv2P~k
 pa*҃a 70p'a &BX&E 1 oC	{Z67lP\<C:CBOC0D27c}@ߞCE+c
?@ ["`-jРIO	C	ExDO	fO	C_E["
d+'D0ثP3(4/)F"9 gHOH/0*_ooQ3@S/oJZB67C=#D<E?L_L17 Q82?`}8@24;d8
CCsEU6P31ELE2[jZC5VF*n4 ˱27Q54
221WE
 y8?6b6zG87>6
dD` L98+`pK81`86L C 8 @Ɵ85~100wӈ IrD"V:!r֊E_a6a}`@%yDƠUDp(`9`@!90`??6`
ڰ
 `E%	p8}8`l93197A!N[] *
wI88_!P!}D8D8Daa`tr 	bc. j 'ެpS{a +c!Q[ {A 
[ `|Bp
a)?5
0B|bn1b{b&1N
a08d7 o,rqD i8B``	|ޡAp

cHc
/1dQ
			vcv}b0TJ F27Bhœv60 ET>/SSDTqЈBHP  HPQPpcЉMoSFT L4'C@	o1  f   2  #_3_T	_ws 
_	ODwj
ara
a4a`EP]Pσij8FZ hFI2eJ2 290_291 +90$91 KJVP3U3/ yj2pzVi3p^j9 	2
D`tQa~Abb`h a bub `(3BBT30u231ⴤE44rFy593,
b+1 8y U  V!4'*[AR PD?C{h ~|`PCT p]95q 3	_PPC ~_PSS i27YA7'NLP7 _EJ01ИAà   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n      j     VIDEU0 ! z@ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`k aP b  c dP e  f gP h  io jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0  03 _DATA_BLOCK ~  `1284Intel(r)Alviso   Accelerated Sa 
Contact joe.david@hp.com
Build Number: 34{12 Deva
04/29/2004
 hCopyright (C) 0-`3 2`rp. All RAs ReservedPp      $		


	  ! 	TVD "LFPy{8 
    0| 02468:<@BDFHJLPRTVXZ\ m{
  8 (  8 L 0  @  ( 1 ? Q@ c u 
 @    @ɀm ` 0   P@DׄHLѠ pRb R! q }  ߏW     }p܁ 0
a		pa ?   H 
`  b _ 0 = 琝 ΢ $ (
  5             !0 R`SI-1362=-Xp үA^6K ,(>H M X <
  <
 2	 	Z e-  	    "	Q Ia("FT @$W?4΁S  `	  <  _* 
ZcTZcu$M
 bƀ/ /H d @A &06-0* Q 0@0p./xQ&@X%H?@0b2@@E( 6=S6 @-(     ɐh#  # ,ڧ q(s ) 	(		
	(	



(B
T

^
(



(



( 2
<(j|
(
(
(HZ
d(
(
(&
8
(p


(


(
*\ @ X  ' 0h^	 `" da>  1X (dP0C	? c`<# cxx Q@2߯(+A)w @_/A-"~/d  P 
00 *f  @
%,@`@	"7
)(<p#2%%%
P(
D. $< 00C2/<@pQX 82s

,+a N  Xc JUXL"o o o o , pʠ UfPfVfWfVtRu.t
fF߆   w FF\  耹*FXF dAu=?Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^pZffq_f^f߃ !;F}Nn߈^f~f~`.sf~ t$:V^:nQ:ND~tPfFtF3@u )  
f~v ø t2:~sPv0v^*ߊfދfV2fX]P!R_f3
 fQfZfXþ   
@|  M ` !/sw.+6 t 
؃p.	 
 
f.ap VWs tR 2u/Ga"t!
?rVhf" v f..L^߲ 0ff^3_^3@uv t&2t43U
PSRV<v
W<_2&fW< t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufR1u5 /wf
fZ
fVPfAC4% `= `Xf^2dfP r ~ f D`"fp!;r;r.T0$p7fP#2 $`GSfQ;tfY-ffXH=r.fɱS fYf.; r&p*[fVlu<-u ,^% @@H-VW;<u%f߸-5wf ]73bQ%`^!b䥿w0t$50rp%ufނ 53~%sV 2ffXu
Rh<Zsfqoa6bk5;uf-08 B8K5:25/ &5K:@]/tt=13="tR;Zr.
 @) ;Zs 	.#atu
 `{/`*{@rf`wR1	Hus4fP(\4 $r2ufvvvvwYw{0~~]﫦k"' ,!0!"`"&
a( ;);U"a,d#eB"fgt$h"T%! qUP 1=t.	o1ffX.6kހs.X p=Ou
uKa=_ j W'-6I=OuFt=Ot=_t
=OtP!IXOuK
 pt ,f]\Z/Ͼ .<t.:u.T1_F`2a   s2a4821 { s_+"YF H ^;+p q  Ð?.2 f/ u0u
ߖ0F t f#2\2f/fP*&PK#: 12tJi~j 9k
f/f_Q' d8S/c8u @5V
0Sf[ u	uNSaP'V *#M#X####	$	H$
T$ ") u`+uu/ x1Rr{%	ti!.u`_
^;A2ۄtq P'6ȱVfr/w**u`.`	q01s!sr"	rqs
@"t+S
[tpc t fPx0 r5&~		O?s
spf"T-fUu-P$8X$@
؉	f`2%(q	@iQ	ؾ$.8uPul$u]󏴐U/t q* 0^/d   uof m, }/ f?f)'4e/p-PQS--XL-]L/D^A8/ #uy-C!/,@-@@..faPSQrQH F2;YtlQ
 srYTZpDQDt c0@t@uY*Yd"ut,3r.D$tt	_f^ZY[S{3ɲ@t#w3u&
 ut
`21jf @ 0@APҊٺ &C.wtNZ uf~.VPQ\	Y2rP &.8tYX^r
gf& ⢊f_C	f`L?sT
0xtz$р tSRط4Z[B7P7uOTX=*'Ё?,}A$q-*[0C^X*+*f'tЮWw.]S.L2a.i
QPPfY
8Xt+YI+.t
P<0SQ;[tje핗`)^u'uB
2tPS#[;Xu){a+tu
~PSߋtIbY%tSQY[r[bdm+3QRvXu@ك 
T._tSA[rr %p(6#22`] 0(@; N
AOs 
G @` ZJ(L'FfS !} *(PQp]A^(L<vYX(r2(P `W0("&hvXi(	x&X$n&С&G.&7
 2Aa_`df
a~p!t@IQ : 54YM òTh)EXrPu(s#P7 R Wf_`V.4.tf^^ܱ +4g3K *?ks''d&f% `8ue#u㻐2@t"0r/ksp}@C))Z-3f
f^	ߡ%'Hn #fp p(QЕ°/r߀tDprcsR#FU(Y1L?#"t#OMu׺h(w/
%́iUQXw
[
SX$w
˳\%3һ &9
2P ,n---/.S.d.x..	.}0,Tr% usR$E\㫃u$nu@%Q}~%4ty#%fSf[#%X4tXS%݂
$$u0 `Q.2`;YrW!tq;  p~W$fP&fp>f jff3g&fGyP&f^U[2pQ&0h$8 &
Q2 ue 0 %r @$w ğ5	0 蒔.:\spg\Ш \*.$tBuIP B# ^Xu,.8 $.t2s!P`033XS9&[tрt
 Sg" |# 
pffr1%<!AW"$Љt*r[<
f^&E$g!n"$ 4Pf.3
f+أ42<"t2l1fPW O;
&2pJo$`Y0r%$,U4.81F0sv$ "x#![>c<!$tPu@uEtAv49*sfQ)1fwu!k10@;fYvt`q@00C0c=+ r
 wQ2Srs[Y+8<FHKUQnrM
rF@s)@.t
1`tF1u33L rQYߢdPP<vrs	 (PfWrZ@1㿏 .!u.Mm2ft!2 "SQ2QY8[r2QA÷sYf_XSW_A?_[$zrFsr?PŊ
=
t+8t$P`Պb"X8uЀ`ʰ8 4
a `_b	!kp6 "}w.&f ¢I]V0,u
Sµ7)s",@!f  Gt  ut
ъs!-P_^rXJuWp迻ذ32
>JU^ FVvnB]FPW 3w&!Gt8ubXuD>L t=s4Hй @Ek tFkir3vGk3UX&2VS2.k3V8r *[Y22aF<]W.>kt>Àt&}&t,(-)*.)` Rkÿ<v<t
<vÜ߫Pp3bNF<w<?t0f΅4es%2&J&P &L&ģ`&-pK L`  aÀ6 D66665
665D6D6D6r6`sIauM@B? 
<w
2t0EtHc5a 7a3۱R0 u tF@rѲtu!WV辿 ^_ 
?oG0W _ouGG d a `Zj	 QIڃ. (.[NXu}ð/؁ Y0%@t	p`T[FF!Gpu Y÷sssQS&G&w&_t0B JKu[pr&O_2P0 &
tuȋcPQV2
$̊FY^Y s0&G
Pp&W&w@
p߀?
ttHH,2>trssr&9p,uh 30p?s 

0_Gs'
 4G_.>`;`;9ëz 0&$F@f
r	up jǺt@+  4t<v<tP&X@F2 @&V` PetJf &&	7
aTugQc$<0tqZt2-ֲ u "~E aE1^X qۿѾ9.8u*fĐ @q}0aqo`A(  `
s6fft]]	} t̗~蜪$z $P ! 
Z10)0
VWSt#`IF[_^ rffV 2~Ê r:<w4
f	r**uf^21!Sf[f0ΠV߀Аs0`t*Q!.LYt  u
P"8u^ZqSQ"s	.S[ Yrߊ̀vX1Sf #brcŀtʀ tO<` |rCQvYr?I`P<f;Xr-u$ f.;vut	 `r_ &fYf MRVS&\$t|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQi0e.DYXuP!
~[` 0"Rf
2f&ffȐX&e&} ]@.ufp0 tRjZt	P "  t gHK%Q E MS f+Vm;P 	X~^[0
 |^9kz5S
B7^HK&E&E`JE aJ HK$A&? >  I m  @   	 -`pPP 1-l#	_@PSPS+׀1  p!Hs>s"1t?7J>S>.97I>r[._|E#[t &fVzGP@{5 ?.Fr YS@;[^u;t;Gr;w3O,?%?tFt` u&t?%?o  9{u8s(߃l6&=	rCsC	;v2aSS踿W0| u
۴tPۂt
 {u[[_[!Lf1E#%Kt&  &Dt&4RfЋp`D&Ft5C;v+z!Q \&Cr AYF⽹ = t0U fھuø RZvrQrg  {Pa YPVPV<v	 rL^@r0Wbp"fP@X2AK?$_spíd

f@f^Rb<w 7PEXϙ
sfBaf%
 f;w̡RRPPti.8x.<u`Y  Q2<v+<t'<vw! tưtBZSul0gFf
QXѽ .@
.&i Qs] cPQ0f!>P  w =YrVItӍppfXufэ
p$0VW#sB d@@<&|&\CrwPXu 	 ZPu
 u^ޠf(f 0D     	

#
Fr=.t5WC}RMu
C#C_2.@S6&[X<`r<qwRZP$< s#
S#(S[2vESp%RffZ_fـ 4[ڐP@.ХfB詰.Q VfqS
e?@菰0|a|dsdrdZsSuNUXpz5u p2ɸ,"y:-]F+<sau\U÷ zMي3
x`@!2 o;@"
Xr8|r !8Q9uUӊǋz% 2mFVP3Q^O9 L3
wN tWP1 PS ^p0[HFY.6?~VWR\Ԋr;~s8 ~JuZ_^N t0S[_0h
Đ>2440RGVz 
  5r@  6Pgp &PX6`"2PX uA@`2RZ Q拄P薟 ؆! PߣXү P?n0CvR	"݀up2`@a dsUDtM/rEWfV.4.tf^.T
f^&} _w(&
&U4\.9
u.9Uu`fQsr
\ r2DfQS}u>p tq u0G	> 趓^rt.d.L&e&Mf^_fk?@Q	Pf3fa$'tPpf@_fXf%b	
f7	o{fcctPK@C	Mb+	XMQ!1	fPPʾIf.VoffP1uc
 qu
'ut^sk  p̨hPB͒c% '@+ ϻ ס(@t {[P Pq*6Að%	& o u"A#P0Z	tA ^	r s  	t?@q_u
_w0l<XQVW_^YSp 	sK;`g`6@ |P  @7 39 	faVfW^W 󤀔&  &E _^VS3
t
<a|<zw$C[^V>    a|@ V$PP2u
at.:u}0?3xV ._^f.<Inteu   	  
 	 PRaPa C` PB BםA B;rXa0  .LuSbm u [.L|r4Or+f& Z/  ,7=f;7mPw f31f.f
+؀Bf9au	fSfG"ܰ_wsưA@5p.>Mp୽M^I.MLRf6 0.df 
00.D)PR.ff.` *N .FFMȋF 
tJHa  \FACFA _R '䀀Y`*
  S#jA;
r"1.E_0/Vй#$<1PG<uX.>Ot  p9.O< QPnXQ{1RFsZtF"$aXQossSttr	rg21RD؀t`.ȃ v(.жuc.<s.tFK_f u.t-.5utП."`b1
.ffQ̀WY   ٠JY,R,7P X ?Iyqjpm0h{t	Uhf' q Qc6 ?@J*0C6#tԎ@;J Sf< AS1rSYo vs40V+	3]Wk1s
,
rRR
RZR   $ bPBBCZQ
Q Q?QapfƊ$f`@fffwX#t
p tfpZYQ Qw `  	Qqt C
 tPP첺S 104뀛@U$$`2`  S S2䰿 JgQZ$VA$< Q fYɜ,u@R 2  %%Y;}YpuS
S` 
  `Rf
  #P  Ѡ>!ftsrg QZX^־Ҿ 7O&0A&k7Đ1PSX""
[Xr(QCf4'&&ff<QpGQ` K pG+
%fS+<+PPŀ5 &t@wۡ+2u-ffȋ/#ff#Of`	Xq5fQ.P3P3.-RQ- u fP.-fXP#ك#[uX 4a  *C               )Qr|rwKAH"6@V @;v7~Z++Qbbb@'Zf+lf 蓱MU`F 2u F . QFyQ	.8\uE.T;u	Ff-	 ftf"u
Ff`!
uC⦾E.  D 	t "Ÿ ;༾f9BaOf^a] ns(QN.SNڠ{ƒf^@=Ow_DSR	?ZLr8t+t P.\.DQ" YXsÀt10׀Е^ZSRWUю s"̰f_&;u Eu&M]q _ZA`~rAl?,;r1;r-fQ&
 =0fYuaQSR _sRZ[AR.6U.8u.| u
@.;6Ur꣞PVWrEDt	*tf{
f^O&M "9_݁V3t u2
^ rWVIrK+%f^u8@u*u%SQRPa0sXZY[s^_X@`ZQ QZ .w8u͋tYf$ADDfu
fIN30 *Et߃_(uyr'q50f^8rP$/<t<! $rf&E   ӻ΁$<<<fpRVr
.'|0#^Ȅ`Ȏ؎*`P$ t1.{\f^tB
sV! 
r.UEU
aL A(
  Rӊ(P` X Zu2totjkts^_,@sRSs+7,u#"` Wf_ZN^uG9Qұ   pm7 T/R.
D;t"t4.+0.t&.
,!qKKr.
,.VZ<>ˡ#W?7 >O tY[p!v9ϋ9 4PV(<"Wal%u=Wf;8f8rUwP2#u<` vtu=p 1D?aZXvNa_ڠM.|PXt	.t8ųo  /d %A0Pm%pM  2== Ng@kr+q>t"s	u
< u	f3 l[[ptT(?vB@1@fpQWSRD[C; rQYs
U1s#f@R.\Z0r$qC PNr. uP)"X^gt}XwefuvVW[UjQ ?Y s
 rˊٰ6.&;
Q!Ys" t_@Xt_t	߃@/pf tFQsf`s%;sH`јf4c03vD0Q)@2sEuKHKPAR8Z;sv`Q]tN `&aTa/a[a t-wǾ a rpÀ  !vs*s wf~;Ps
sL  t@ffRZXQ  ;v
t
  C
 7
`( pu1Ʋ݀wWR TZsNPlp  X.:@u0.> u(J=pZ0=pw#kᬐ !90 ;~Z .	fvfQ
p Z
@Z]iY4!Hp	Z3
 QVWfvfn2 	P	-rsaW& g/`J+ѡ ! 	
nV0SrFwfAk@uAc .`^PPPPPPPP P!P$P%PSwf3~ca0It3 mZQrt222ۨ#P0oVp
t-Q2te.ttְ2t!^[J0> ,Q G@PQW$<unvijRfZ`etuU  usEjtz 
s3 @	<wPhXs u7fV QQ+_ܠV
t$ t C #;tt@t2MM Ƣ.XW4@uQSTeeeff.f4fs4þes/ðFF3F :{.>fQP!Y! P6IrR Z)ߊAB Ð%	}2^@; vffg1g7gfggg
Tf2<vS[[t*f{_ +@,f^ڀ[#t,$o
<P࠿10߀1/ ,2s2u xD s@a þ/.p ȉN@jfC+YfSd cP] nf 0f t7f<)o!vff4Adf% ;[F  aw<s	40Ȧ0=ȃm 9t(K\DvBeH˳\!\ɳ\ߙ\"sQ-00
s Vhzhh}h@hn@ Wf_fVBE/fFPOA@Cr0f« f fߧf+À ?f
f  	4}!f#$01p8u2uA4 nii r_ 6SE5
Z<_u
 su7`( !/ -q   0uRS3:	[Zi+S3߶B:u}:F '9R l aq@ PQRV ti. ^qptubA	Oxr!`19f t4W_s)v!f&= `&} P &G
Swa`St[sSRڷZ[ K#A3ҋ>9r  PZjjkF6
k< w S.7j[01N޿Atcr$? r00H 8
@rS# ǈ^S2_$1`08t\t!H1k	PktwoAfbqrP< tD a2<탻MID u    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS ~ Corpoion#ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq =m$nooopppq	qujMhmf
il@.<t.:u tOFûE2&+]Nut"OW0OESA0O qϸkfZlfPߐfXfQv4h9t/P@w`ltfl sl trlxlfYfS_uV" f&E-  ߋ߃WúQ .U@Ύ޾6lJ  k fuVO$FJ^  uڵ ,𖀫]@ @]   ^'u; p pnҊwf@ơCrf߸
 re@@Qf2tmQRf af3ZY 
ҁ
ҊYu9]fk
l`,rRvFPSW_[XF$:Iu6r	 {@PpƲt
u%uބd^c@ͰLr
PVÀ>IvmwdtYw@t$;wR?$;v@f1Crݺ  t@Ѕxpqp#qQqXqzqR倰 ྒp.$f bt*R@	迠ZP	Xf  ~


F wf f` /8ta hf_I| B	t B_oH $*ca6ݿЀtE#>\Sw1gi& )ft:D)vGwAºBffP S }BBLvIT 
RVIۺ P!p:@v-8 t3
@oQP%πs`ZX2fQf;BQP4fqU`fYRDIwR}]:T`:TuZPފ̃X&ETE
ff'
 f@.; #fʶ  }  t &H_HKAV:^0w'^BH	
ea^K^fAǓY&E@(`  q0`-
hHK|	2.kȊ	݀8u!$?
A32IHݨu	p3r
v.
 @$
yslݨQVH.|g^17uf^PhP%iXv.t"{'{.D@t  }Vl^{r
 
2ї^û< <#t2 <"t
+ <!t  UP,=.	݃ffX0u7
u.͊Ȁ
ufP0;psڋиO O }Of]Yˀ u3fawy*pMfr-輦uРGE H@`uu t kudu^sY8s
tQG8s8s8t3 t-v&8swˊ
r*ˋc
㉗P8bu J N{rPÆ2ۋ !iR
tBi1`2$b&LNذH<v<v	r	e狕P F ^\`{r{otw%pvk&J`֋&O^͋sBuՃr' wP酓%u$0<0 t**F Ɗ
t*02P ؊š	a>`@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQW_YupD+ 	2?@
2@PP *ڀ n@
  toʋXZQ2	/ ++(+t؋X  + 
"a݁ǽBtG:#sNOFGuxsOGG$	Bw y*2䠃10>K , !+ 'k'ȋP&1du'`'"$4$&ǽ  %2{C3 B"pCR S ػ@
0Ȯ'Jur&^=ց3Ju=>wPA67)4&	55Fb1(Z6c5 XqJrv
t-r
 <G!M`sw r
XtJ׭àQqQ0QP2GpB2E tO FƮS PЎ،Ȏ 0u.&>| t
Ò$c-0@}ȱ\,ًppRC&ԿPD+(w2 _6t
0sus@a#Pb0 2&<u2ۭypWUƋ0t
Ju]+
ɟ]Q0 wLп㋟Paz x`֋Y$Ar!v$$ǀu　?60{0Ql$$s$guzի3*8*0*z^OFH,G`/${԰ Ë?*a)p
y$6| 62u>
xĪm?í&0  &_0%Ê)"r>!Mu:0+,Yr3,+K'B2NĀu9@ZZVWѤ ts
Ue_^GMu ]3@ø&ҋ$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>f߀  
T @ٟf'@
 F$
 =r7u̊ PW.ku>&}JpbQ_XwLĀr#Yts-" (&"%
Ī&#Z
r\sي
u7!~y@s
x`ALou1x  w|
p!! esX @
Off

,z	0	2ɸ,"yNu6@	@	ʸ ߰(⨀Pbr$$t<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [蛀D?rp^ʊ3ɸa0
OuVЊdЊPSQRaPaDXaZY[XR*vn
ĀՈF0F020.7Pus	|	;<s<t1rtJt0 2ۋ&<F 4w t3&ee!3<
EQ.~=T  @@5 ÊTP&߭0y Ou@ËÀ8 0
1>ǀh  fnNË̊ĊNuúq 2Fó π?} Q ` KNuf&KDSRP$?.&P_RP R T[[c   XʊZ[9P̊XPnXP% ~~~~l|8 8| <<<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8-p
~~~  Q  ~	 0``0$BB$ 

` l$Q  ll  l ||f6j 8L8xοz 0 0```0 @  <<f000  || 8x~ |p <| <l |oƀ "|  ~vH  a0!2  
x |߂ ff|ff    bhxhb `~ @< p flxlf bf } ΀؀|`W||~Z<ql|)Ƃ  O88l#<׌2 xp``wx  x -w/0 U x|v `` p 60x00x3v|x`lv 8 1b 7ܢ-| p| v | q$4-4 ֗ll3
6|p&0d (1B {00 # vD?&qp]|8̅
|Q!f!&88 `x`:|~~ ~?΀)h".a0%||`l``p9B~ ?p
h
6ff+ 8<448ll8 60` U6F= \E1>S6ll6W` l  "# U=# wA 4RT d  6 P 2[ 5 NOqPt_U1UQ2d770?rd?%0aa66 R9rja	
( R>     tv Q@bC8~llHpO3O rg8 s 8||`rTXl( <s"CBfa||"|ADPh"  l~`l~ Y%r[& p0joG<8p(5lyp}Xl<p&Plp~'0QE< (P< c򀓂ld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20 a4!֕BP{ Q|`Sl8>70k B @sV &
񉅇R`gcZ8|||8鋊;ff""nAR	+p+q`llҒMv	܃od  ä5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%2#R$F9B@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu 3'$D bBЦe  1d23]%@`aB= ְr;b95Qp$R "ëӬ03*Pw~Ry Ap otReۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwpD) ew) )ü ut  (Yǳx 7ȥWU> T 4s ^S̅d s͢Ͳ5Uc 	ֈ&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx -Mo 
/on 	/Oi .Mm +Ok /Imtܠ k$5Fpctq =FTfv|| 6<]} RRfyѯʤ<؜ p>| oD$09HW f!"#Ĭ$Ӭ0v?<Ë5þ&) ð {	!S{ P 豃{  1 0 a.&6| &>~ 
*r
t	2.}`Ϲ     ! ߀w<
u&| ϲ 2.⬉^FFF3ҹ `P⦸` Ц ʦĦ X  * : aQYS s2t  [øwq e_
>ctO/    ^^ >IЭmsu
^ t 36ȢJ2 Lc&̀>Iu	B$P
	JX̀v`
p uHȯܯ,tQ @ rw
2F.Ê.̀N$F $FF.q( ʰ OJE_yt<w$u 4$
p À0&&߀_+Q	_@Z<w?1A tS?H[
!&FE>{q<w$#@tÂ u5Bcb? ȫFt^#!)#
 艣`8 u{ 3ҴugĠtb(u].-ŴQYR  
 8 t$8u
(
=
28u2ɋZ aR23Z%t<vÊ>bSu
㋗PRYNVQ~ċюF&<
vu^Ft&FVRU v̒,]Z:Jr92:6v/RS=b=ƇP [
nZV n{^^YuZS[
<t<t<
t<
tx@(` t
t$0<0tu~r ͉N`u6$s%&2Ft0 u*ш})s&:s2& # E  a  { t ޱu ? t"<(* II `ga!īI<v,	..߲tI<tE2<t?<r<v7<	r
<v/<v)W  WuCt	t`2ۊêSP
@X[$t   ɟъ$`Ip
P4
Ī3RQ$2.kuZ&G&G_t  
 &_ët%
&;G 
 2     @    fPQVz fVf.Da 4f^^YfX< o!!14f3ٟf^FFfPfSLfa#fff f f% ;u@[`PSQRQmଊ'YZY[Q Ğ@YbLfp/Pf..7.
CCRRt!Q̀YZÿ67t&p
t&wG  x  u  b螡2
qf 虞Q3&&Ϭ&I1f P tQ | fYÀ蕜VFF30^XtJxQF	 DYPRfW10f "!fP   f3轿   0@P sg  [蝗u/ P
Dys-pCR
* w CA	  
 f$ a	i
Oѹ`F0
!3
ɹ1

f[X@f_Z) QVVķܗ^B*&5!&&
&^0 &T@}pRV0&$F@&FȁM  PX@F2 q`^ZRDMZ@ $ĀuY27V5Ċ嫊Nu}^D7İO~C7R9f<Z4QfV6Wf^Y55`4{h Ys4?t47t4\ 	4c464
rKQqc22U2222پ22RV2쪿B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              Ŕ!!!!!! !!     #v1xx">V==8f:=,=.=@==|=输===y==B=0==$ = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2Št$Жf`}$Od   : ̕ĪaAUcPC蕕P@0 @舰UqD"nX# 0] 
Wh2  ,h	PxX^_`. fȎ؎1)`.>f; lf3AHr(|$utD rBq  m.6rPgTP r    r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m|p r} tܰUl pAw<f;%*"l r&;f&_HIBM
fHQf=וQ
 r2u&} s
PQS1[  T<
QW 
 ftV`^tuA_Yå `VUB ^
DƣQ&EǣSￋ\ ;v++\Pۭ{=;6Qs;>Srڿa aǾñju6萑xPt'ࢱ ő+	@XPx N ð  t%u7貈!Pf@ۀ> @5 S襔[ 蝔[ f $ADDIN30F½AIM3b0A  @ X@  Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Sf.> v u`pb 0p7fX 2ZY2 о^0sbuL.;w.;v
RWfVvTtOBf.G} uO"Ұu0R j`ߒZRLZr
ۻ`
f^_fZ fV$< ov99fb #U}> $s1 3LXq_S nfVБo2П[S @t 3ɐR}Wt
_ZP4.$ W4J0_ `@n$<u<.\.r   PXf۾TA1f۾`1 "`Z`@.&=
U蟇s....@  "UO  5\OuyRK6Vyf.d..\fQ*yfPYw= r rL<&]fff.	\. .FG@ Q	3@ @.G$0<0u. apfVf.t2!.1f00uPd HhZ	f^[a!13KfugcФ6%	 ͫQFD4ӏ5VEp˫˳K̍}E	V  Z EDPŻU
ESDTY@ " HD|   H 	  
@  $ 6 d_   IL  K B W	 @ , "	eJz ,,ߏTg[ 00?
3

s i,,6Ld@Xkl 
 
PĖ` q@Q@k!n v lC q \w l @AEq@k6
-2-3 A  ``  3 dj 
=z 
< FL "ZZ  L  "V 

 ?E +S   
E 
y 
O 

SZ  MnE(  02<@(@(<2 3 = < @3`= @<`3=0; 3 ;1 0 w4 >`; `4@> ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9}  6@?906`? 90@06} (8  7 (`8]@7   `07?7`0s `w;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 /0=p    
>* *8 1 )  @? 7@1`?*)   2 )6@2ޠ*)  `ߠ2@( 5  3``)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0~@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5,7@-,@ 7-@,4-8 .+@ 8 .+ @9@.@+3`*:`_. +@3: {*  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ޠ @? /`61 1)/)1  `p< < + + `0* `"0*  1X (& @A &06DPҐѿ  萠ƃ`y f%ѣf=uMXРP R@U^>fu}= w
}w6fQWP;A3a_tf
@@$	XQrQYoQx_yf U<tP<t
!c둦RC"@_T2. t.w[f?7?01ˇ@ൣנr[WRZ_Sr3!f%mSOot]@f
qSafP2;j|`2f2 t&2!@t fXf^q 
fІB[@dtWeuVfvPVfD .8ttFfߥ ^Xq:=vL= v^˶Rp fP`
ݠbu$s-u绢ǒ* <  } Ȉrʠ+ Sx[nra
j  ! R b r "2B !Rz rU[  R g V
fƢq  %"
v
r 
~ #·ǒ ~%B
  #  #^ Ɣ & _& F $ Wظ z  e Vf @оλ Ϲp5?`	λ~aS8; u	[XجȺ01J f@f۾pKp G 6e^ u4a/3Q^ع ``N ^UV !OfRP3 (Xq/ Ӂ M@JaSfZ8t.L
#a"=5 ScAX-$X;áf10[a考fDst[@TQgҷҏӕ  _ղ   uOOGoration Generic Device 12 A Oas߅RU@0f^t!% sr*
7@	{#gTÿ	tgQW&]nrfS+
f[r$
eY00ྠ  @  8WPX*	 PSf@HFffڀYf t2Q'
Y[Z qqvda%aw{qwuLff&
T[ZQVҹ 0t.9Tr.9\r	^Y 8t&;Ew-&;]w}' P	Yr;rp zQy@m&}{u,p Au% uZ$&}&Mx[X{t
n wb	 &E
t&E&E&]QW  _YpfQfZrVA
Lt
u:;0P$$X7x쟃_^"uȰfu<u렆u,D|v'$<jR QrH&
5p EPP)
~D].\z|}fX/wtp1_@hB  ()bc./1 2@4 7 8 :; !  ft	C R Oչ cչ {{ Uf2!QRӹ0r8r2 GrZY [QJQfS@R;$6
ðaLY P$@?SQW:0tPQrt	tq+&#E'E_AQVfS)> =tPS.E= s
`	z"2BRbr#3CcsdtWWUzV  ֡u	 
 fftF.!f?SVй-c31bFffsf   fOf^ь.u	zpҎ1ff. #.p%^us fPϊfXϊ'sf# EQ Atpgs1슏轊jNq`f3*ryf x  7 r  .`r\C`D &] tR@   @   p f&	Ua!cff3J.D;<	t#<tU<tQ<"tq<P `g<<<<Јt    Bf 1pP
t
0b
@@t^@@"fr   ?  9 P f@ tϱ3T`i1 &U&]#mA#
@.&8Ujqs
H.9.9&EVWt,ItN`UO0؜FOu4W^KVW61A _^l&=@ !Cb_.E.]&ofRQ2?f.U@9.Kr.&J.JJ$?.|^0;ok .I$ s\-VPm 2Ɋ
.;v.
fr >~lP<0   1fڹ/rYA0!6 rCJt~r3.8:w
:8 r.7P.=q.;4 W-c tEG Q[tmY`V_)a{8Xffڹ)GrESp^S}+
S   P]\&_]_XRol}.|q8&E @$QQ.SW[r}PXfkY1ބfP0'`Rt uuZY0y~P?X< t c0z [#w[l #
RS6[rY`_+rOrFd	ar;QIoYu)΀t"tt
rfPxffXZBQ t&` u~r `tt@kr}
a t;( A8t(grWa1cx0kRt#B
 `Z߷ef1fs`j_Z!Ӌ4rR,rJ~& nnr4ttfsQ1I%ipGG] HMQH ^ ?࿹!|0]r\E]fR`f&U ArwfP|RrBtu f0R%߲K$@pr!t"t<u #3Zt
(v6 {#ps
r 
pGr<GRSڃ.[Z[esPR$ J4
ZX豹R|uuu4$] " V{s^wYf(>rfu rER.f Ptf;u,s
2tPw s1tfF ô6`{bQu>I@UX]@PG*j6TϡT`~ U$a? GmOOH z  R UT1p0Xl
tP) .8ty2
tlt	
t_.
tr
q<wffWSTGJs d5Ǒd`Ls1S`E%sf^a(  Total time for VGA POST:   Seconds 0.000 
 initialization < 10 Milli 
 `fUz-pff.@q.k.C u A3)7YzaU`1Ѝ1
h_k0J@f]aPSVD% t9ȋt,.@
.8tFF.L2tXs^P	
>
2.ۊ0:
gs4Lfy4@<
_gs1$f#/q53
gs>P. u
 tX2aDt
D2PwA"ʠ
2=wEr@3_hYh.>,uyKh2 ߹6pt$.p@gihO!@<hf.f.+ tiggg1
&t b?QW򠠯	fjf.>!˾
jjj 37  0@f`RsmpAf.!`gfշa
`+hf}pf moyI8 gAf+Xf-of!wffI sQ<h% fNn@.
_Xú#c&π `	 2?!ĊRZ$`
s$.NA 2	tA@
t*. 	23.  . úU)hUum_&
N:. e* ˿@    Y  | ?PëR                                                                                                                                                                                                                                                                                                                                                                                                             @      *    t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  ưʴD` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7h@ t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhRBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwh\ X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &@&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hd^.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ hz:I:  3  P O O 	   hBr@῀ 3ht6BȎ؎zЍˋh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                          l     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           - ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.NZr#MXu 6PNwrgpt 2rXĠ	 u v thr&3&E0r_" r}2vRs ÆUu
FUF qߴ	 lqv	 ӥ/H	r@el.		p脀'^F&?s߻  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0GEEabgVfQSjf[G!fY^f& u#GWf5  2WXP'F#~r .*u7 u/{r?`. t8.>*w tu  2SrV ʀs`,N	p N~t$` t u/~ǉ~ %"NV 1	s^Í6P.|uLu..N`>PN .:UtaNaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVfv@dD @؊fA
@NP.eXf~a ȋP	rs$
2~

	fX!9
dD0f`v]f^PRB@    RPXuUW:>_]s*r  $s<P0r!P@Xup>q @<@`P  osXXty>cr -Q	F?Q	߸ QV  PRPW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm3
u
rl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00vMPSpsq D
>X`?D<OƋ4a`t~ a1t!$!"q1&0&PQȻؠRJr# SMwO "t 
`P2:Tt
 YXÀuOuQ,9a"   <s&? ? `P93  >P}_uǀ   O  NNVWi<ua<
uu*P H<u>*uh2<t.$SQ\A[|u|
0g׈|`jt\_^F] }
u}	< .qcQ܀}u}	a`~@uDaD$'QV 3۬+^YD &!h{f!ff?ffJf0^1e
c[ %f F PX@OfP~~$=r0&w)ІEfu fqu`~Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` vjaif`0ff} k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRK=A>$pa|P0CfQ~`rffXORpC{ZruAZr
|`hPR2ǜq4XZ[ô`S>[PS3K[
uX:aSQRsɄ3ɺIrZY+3p  XfPAwMSàp>T pKѢ   u
  
  t 	˻ʆ 跏rrηvF0 & O 
 30&O՝ˁFUWn_]v
 ` _^w ߃
?Ip   MB RW1a
$>1 D 0&= @
.1&FGvuc1v s1p cu#' x2 [2&O` 
;ub2f3ɐ t /u_33&8  3Q߆_ZGF< u  u2D@ 譠sN~ t
S"x[{@&fQWS h fPg!f8h#4` yf  j H  [$p`,fKf
0̀9fāZrMf[0#t5P; 00΋f% ;tf ff  ffX2f~|_fYASS   d GT q0E r7*8I4fff
0Gf R
aRfx Bú 4Z`EXfa c``d \@u7v
f<~f Q Ref%0
 j |DpZB"_B3EOu@1m$9A'uf`fQdft~" QBY ffhfaQfRWffn fRf3ffPtf Ou_fZYWr~!Jtu JQ;lIhIrVaFQ L G B = 8 3 . ) $     }: q_QП&GYÀ'ǹðd ɸÿfWfVfpmuzss  3f^f_ÿUYt!ۋ rA.%])%`%%^& &&+'z'or.f%qf UCESs=98q 3`69  1f!u%f#fK	sLwr@Mts` u=`VQaօf#ffжz+ ΂߅r1!SfRQ<t2f3Cr6
+聅f P0u g> tt Br(t E } uY0[fk^U@oу{`.4۾3tt
裃r2f`= u8_-t(mr!f10

J?t:R!4g&? t0zc詂]fR跃8@t ,tp
 u$2(Hp`u@t'P eu-vp(tQ
w!- o t> 7fAu^B1]Բ]_3q 
t g t}Sj偃`ri/p/B/RZ/rGU/Z3tt@B$
Ê B,B$t PBHZgfVoQ! 0fP,Yf^p0aBhBwB  BB$IBXB2#B*B9wB@y 

B	 见 螁 SfPŁ4fXpG	شt [3SV~_W  Ф_ W
t<5t^uf+rﴀf^_qrp5QRV3}P'û g Kt
| J=8u^gPQfVW7  5Rpxā>!mdD{@t@_f^OOQJ ++++
,,++),,,+,A-?S-f--a ///20W .2.:*tL u% *t>JrSP.[t 3P.[u 0*t*t_M_(EfUv"v t Ar MwP *.V PXF
Xf]h@ &A paj@!
`ð r`ipnh
	OVO*.6*# *.t.I.
Lj@s&  |0u `Y^#؁D.d.$m @u>	ã3j0rc߁Ot` 	OtOtLtDOt
OtOtOܑ

1*u	豎.<.}h ;$ B%ÁUu	U@Dq`R#Prp
fL\^bZrP[ ƹfP<r|wfDPu
 ѢqSQVWUP؎&Br& ȎXO*,O>* ..?>*@]u *Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^&?swa s@ `b 
 *@Cf&GCE QE~A*ff@QB SRWP讌޲ v]rs^*E<u?* JLuRE<sfQAM}3  fYr/>P4P.  EGώǿ R>p=./Q8[Ü+_Z[QW \.>*u5tG<tFZ=}.EP .&3P>PN@AV%0502̋َɎٍ6Po p0_SRt5ێË`S.q&Gf./Pf&_f&_ . `Y2 )Z[f?UfPCwTRS~f]Ô11
1@ J1q 1 10 1P A2 G2b 2& @ 2 3	 3' B3 S3Q @ } 4 @ 04
 =4G @ 4 4  P  	=bHewlett-Packard 68DTH Ver. F.09 03/10a06P -g]  Z  l ~q oKBC
sion XX.XX  
 
  _ 	o~A~# w @  A у JP12 Intel(R)     rnal L1 Cachea bi2e	
 6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7C  ;
     
C 
  Ќ  DIMM #12#
.a~"Rp 7"kf @~-No bat y,"
1_A$WW6 _T`~   
yjt)Ӏut&ߖ b5߀& A)u&u#
u! À8W@ePh AUs RtY }pvMguG	0bu< u3uOQtru1 ta0> S:u@8*6R:EFu 
E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuEιu3  P jE>I q u	PXuP3 tX랓tS%yE ;ut0#)	&2!q =E3萪*x3;r.Dv+W+Xu432#*u!.ð-*1!	 23<Gr<Svƀ Ê,Gii{.#]viC%J u$
<.r!Lu24$`.ͩ2K#/iT0rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EUBQ C D P@SI Q S CSW= D@ E S }I1xceptu4 - Over_flow!5Bounds Check6@Invalid O_pcode7 Device N`iAvailablJ8Aou` _Fault9v Reserved	10TSS1SegmentPr nV12At@ V
3Gener~yProtecErrorp
q  1 =  System Ha!P#
 t
-XÜPR#< tZ fVfR6:9螯FupR9/vzn9蟿pcP9Yύ68{9tfÍ69j 6
9`fX/9T ō69J` 9A0Ǎ6!97XY_WQP669$Q&9Q*9p.9
6296:F
09t9诜]&9x:na*:_WJ`J:o@b	[Q, GI; 1`(0X[S	 m6s: p C8BBaaI\a$at@0 UFfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QȴjY`Њ  aÇ鋿ً>"ԃ > & G!> .&<'@'dQR Z
  c Z  
G XYZð
< 
7 SQR  ZpS r  `؋  p _9pS  Q!
 	` ,a@  `
UЋ؎ ]_a	@]ߋ3G
AF `P C0[q$9SR` $<u 3 0ؾ   ?fa3S RZQQC@VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYX0P@YP\UfWf&и`1fWg{]D{f_ff_]p_8f <u ~<  u<  l<c<@%Z<	;Q<
`QH<i?<~6<
-P= uX<`<<pXL]WfPCI 2u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYffPr }  u
N`o>  `8 s r 2fSRfPȝfXZf[zff\YF:5	vf s"s t s t QVW&= & s fPf&EffX T  _^YaJVWPwT`;t
X2 *W 
_ ϰ#t-X _^1ONp sP6\ѿufQ fPf}nf8 P8s2fYZu< uEuPPumuZODPPE EPP runtime BIOSVers.1  
 iDDDDEDEiEEEEF+F7FGFSF_FbFeFFwU .)D]D.8].6] "r tR.6]
ZpQRP<rt2[5$ԁ !Ȁ
  -{" Z`5	$ T p[		uR xuR] SUUm.VGf	`&n ^CO CWV	al *Z usà @: U PSR*Bt<r
 j ?Gpp0^r
t<t ).>F u.F 
   PQR3uAB$ԡ 3ZYX
(<PdCGpGGGH7HrHHP&` XW<rۋ= .F_Swt 
' t @Ur
2[e -u0^r!<P9	rr&Pb PfQs" r2.F2& r s  rp 9q	8 r 	&& rr	ô0TSs+&' @>'  sa$桖0TsQ
u>[ Wr%p$S r rq	 .8 f" O$ pQ@	Pm ,X,#t s-@tGPadtbpt t
@u0Y`
 ɦXr`QPPPtOXdYûQPOu0`	`Xd$!<!tOOO  q&@tPGЫX৻ (`<u
 @&   >!@tA AuqP!@Ё  , &w XV߁  0`O  r
 P<Fu us	  	uA
 u	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&Duh>a hЃ 
Xuhd@rX&  U 퐼u@ ϡt@Q!	 -rr
^rrO dP dXP $& 8t ߗ   QX uSQ^ `b+MH `*C: 8E8^01PP {@@X@30=MC* irajs\g&D
V &DtH 1i 
B 7ir!@0r_isuhF. uhhI$hrO迀isJKZ Shhrir
h,a0hyoiZ2
 0
FFt N fF"߀ B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)tЎ r4F$
Ft+ F P   !VPXWV@"0Ha0_WPR u	ZX_PRARZX  G  0 " p	`C  PlFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  0-As B C  % _eO  [ H	P 	/` <M O` c!OF	O pO ?}OCD001EL TORITO SPECIFICATION QCQQQ:Q  A " * Gxx  x y 1 " *
x"x 0K   s  w_X _y\[8y y  b éALT ËEtذE
U ʐ
 r0 t
r Àxf`!qi2W &  d_&E3B&U
&{]@ &E`o t ûQzu0&E@ !fa1<$PnP!P=FR gR ?NR  = "fPff  @ fXtfUfp fS@QfRfVfWg]?rdsff_f^fZfYXf[f]ge333rVd4Ad^;sgu~` 
3 sM tAt<VrdDg_}
^` VWa^gEdTg}

0}gE `tr	 	t}d8 W<yt0@Dڦ
`PfUf]3
t P$u Ó' sf.;Gt ._
u fg6$+' +k$PIR    A >` a b c %S @U   | i 0 %F0j h`3. W Qp
_ϊͻ _}p aVW TS;Tt[܃
 [_^!W3`  Qu t`GY[h /$_APSQV.T  3ۍ6 T.T^Y[X:  4cB C VVV
WWU
Vg]fFR tDR,3GR f0]$
U uUeCRY 3   p4SQ>DRu5Môu% r!<	Y3ɸ 
 3Y[ ?SRVie&MRjeXXY獐&t轨t# 誨>Xp:MR<t<tXƝ< tp.3^ZBXV  |X@`uo P	bXir
- `CZEXQQo =c
udGRDRFR2dà6U uP_Xd]<tpL r
tLd?8D^uA"RWu6gTgs T^u%#`|O&
yt,ـ(t&M1&G&acc`cLAAAca+Íu 2Mȃot
 Q ܈$FKu/ð QM
u	ۍY;sYuS؀u tu)4  `9'  `'pBfߊ$f
f Р)RWS22f0 YrZ u 8s܊[_Z&fQWRfP
t)Rr ff  u 8ufXZ_fYP3 r3r: t+aw4 v f
tO{8t	
uY0	g&;t4g&Ct,0Cf4Q|<vf fd
g&:# zC1	 zWy޴r7fg&܀	f`_r!f`Gag&O@` Nb O q,|_f[Ã.Ot'}}\<u 2ehh*ABkU1q9qs>w{stGos
2  憚"  |  {)l \.D@.D
;~ ``?[&&D aø0 м  `j &&E  3Կ{1QPTRP !X@`.\.T	ώǍ> R.L` `8`a.D`6`aQPƌМ0XXɎ6aùU fJ}SMwSOpS`SNU#N f0{ d9Sâf> uGf   > t&r_Vu3 Pn`f+`3Qf׸@RY_rfǳQ	ġX*>u_fP sVR
f׋6u1 < u;thrR> }RXaSW1-  
` u #h $t$?ah@ & r 3uL^.6]M^3!' $ ȠL0I<u	.6] u<x t$\   Сtu_u	V $
4 gcS }@ /u7:<u`S[SPUNNNïO Oطo$#Qc#j_+_9_"_  M Gw p" * 0ʙ0qq|p0A~b,c޿U]} ދUu" ߜߢ#]ÓJRQ%g̺qY U  ւ! @Zj`  (<sW.__.0923P'Xs`Q[]u..&+.}	p[ @ t^P@ .&u @ u42..
t wPUU** &u XY`D3!P A3.Gp
XPZ *.ZrWȿZZ_Q paaaaaaaaaaabbbbVS3 .:*au.+[aK @[^* UFPna2SF۹ S.3aF[C N[QF ?t?asF2~ tY@ ø7oM  _ ø8PM d`dtC7JA뷍`0%7 3`7$ $ cccc)c<cScoc`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233pabf>"  t" P a2( Ҋp ) ǿȊ&)  * 븊* >+#1 d>,0.- &) 'r.PR u;t;6X6 6  #3
t,=

"=
 
0I5w<t<u FÀ0<  s
Ê& 
 <uaw\wWQu& ` u5˟`!A &
Ø4Y6_ FF;t2Peee/dS   Ya\"c` \0ba3ac] daRR]D[D]E m]`[\!\\\Z\+t\ I|\lZ[ Z9Z׸ Ñ tP"6OD  [gusU I2NO  
$c&E
E   FW˽	KP>]>N
R  R 5S U U OW  OWQ    U	 Y
 OW OW@1ABCP Q OWS OWT  U V WXYAZ[\1]^_  e` ea eb 6fc_ Yfd!eqf ,
,ߎ߰aJn@Pd^PSQfVF! 's^(2۹   F  +^D!8um3\f^ WVQCuKEb! }`!0"w $I^:u:\!u ['r' pY[_ShN.pv CC@@`RZQطQ0<:rd u߆P PH .0=  r q& 1PfVpİ:`gfFpXRyZpt	tPv
 {vt[@|؎ ˋhh3 Q.F.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSSQN<tt	fPXfP B n Y _ QEķi!2YQu =sY<u,fCISGu%f» f P f `&.>i .iPS @`f.ujkO[2!:.ujf`фuha hR  uhaúB   $ED.uju酰RVP
ۃx 拔 tcPtt>@ KXSx$PQ|Xr$-Qu!$
BB -JJq4HX^ZY[Ϝp$ qP/ 10 3Ҵ./@32ƀnuo n Xp('Bp'|' -  t@uTf`0D fft;  Qf3Y,6ٶ5 !տ faH WfX   QRfl f@f= Pf3p fl >ht &?  Z м  GA0pv{@/⯋r t4t p`迂2PɆt w JBA"<t$0]AJBqpvBSWQ  !ԃt7`Y_5A9XpXqXtX	  s" "y_SYSID_  n _UU  
P3Ҏ¿x ȫaZ $PMM t  %m                                                                                                                                                                                                                                                                               i   
M    S    -%  ;n$$`fwyhAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6PN  @ t	3!
tr ^	
F (|r
 	u^'t %1+	dj1*515_r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>O.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~sFPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot}%" 2!)A
 ؀	.E?F2	
r]wsms1I9  <$u2 *<#"< u<@v{<%p!2 ÆUu
F!UǟF% &F~&=r&߀}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZ護sSQtP^^6O7Aؠrf;	DE"z~(LuTMs fPf}3fXr1>P4P.  .GTώǿ R k7./pP\73V#:Ttt<~'t9r037QEE&3Pq<DD@ % 5vߖ7$~6P 6u0fPfS&Mf./Pf&]f&} 
[!
0'Qf謒  r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^@tffm_ruLr Yr)8r$cr蚑r"Va	)rj!PTPQX rpw
u `fSfRWBt:ـ?f.EffffAUffsϱP-EMF F
tSuNff3fifVPf.WP*f8f'w*f'F'*2t*܊f
VvfV}v 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюً go^ZYpBn`SQRX0% [F m `7h.> ďQ(&Q Z^N=rot
r`a r[v">O fKfa`, 3S5<s-PO8L9
t" >OG<}P#<Q$@ dOZY[PQX hv   t`rzru3rij`wNurWu
p`dع ޠ
 Lr.Ǵt%ttt t	tCHa% s߀u~藎r	 2PRZF sH<t<)t<(u;ь>A u/WUߍ>)`]_34r0蓎Cyq`_^?a'c`&PSR 2Z[)ÉRFtN+P X7D	F
+9CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8F}fCF ~VvuKQfXr+tðP>@P3 Gp1 tff   Rf+¾IYÀL@Dweu$`Ύk23c
.*x芆^G fF! PXG t<"u<"tlV3޾x 4|Q&?s0  s& p  &G` ` G`t&O &O`uRp`f&G`Pa  AWtQb b  Wsa,ZX7RQVW:Ww qtNuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^YXVQ
} " uRP3P
  ^í&t{×.øJ!fUfQ  ufVK!rM0,u gf@ N V F00σu(gfFfff0/MufYf^4]< 3R+fQSfVffLfTfDfL !f^[fYrX@A3PXAøM øNp O `EQfV1UfWfP `t3 SP3RfZ :_f]|^>PfW ``tQ uUPXY fQﻷ PA YXt
 t$z`t_ t! v n_  X(RfVat Z|  a(
2VSQWf!w#t   їr$r	 _E^ÞQWV~wy^_YV3۬
Ê^y _	ޑ e V  M IV1fffa .6]2fff;w	rf;wVf0aPS.- ?" J f%3/aBRڨ@u$ Q Qذ1ڊ0= <r <3۫`ȠӀf
ffʝ0԰iff   f-   f bW >E&3&G;r_yQ <%Pt  _ 1S& It`Q fK`+  fY  ʷ f@@0f⚠K4Z4f4f P,0RfWg&߀>tq r 	r
  u f_Bg^f$fw tt,$
g&"Fg&
FI*$
g&#Fg&F}J	f#F	Pfa
n`VR	t#1
wt.
t9wttWt&W&U2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g&: 	TA1`P a3R@\&^qU\QU "
ǆ(2Na N*`uWt=u2
߰f׀3e׃ذfװe~׀20e `oNqa VRPtxSR ڊZ[  Z[K ă u?{ )NȠ֢փt% s0
udfZ^`u=[u8qB 
ً@Mp M2 M0URu<_[u7Gtf)zMsMҰڱ

GǴZ]PGbXU 
 _s ]`K:KxSQ3}ɰYM tM>rQ4Ys\ P߅ 3Z[x0"uջ{`"P3
ݸH ^LٸGiLS QL =9QK 1S
 pN qM LLc'@ 2p n lU C  Ơ # &Ԋ2ҨUð
{Ԩt,pv԰o԰hpS$ztpgRø;
 D+Ԋ$	2s s	2 Ե | ԰Ӱ Ӱ	  Ӑ{2Ӱ2 	ÀӨ tN :ӰӰӰ
$pr
$0 zBx$2
ܖ7w-C A PkX(alu@u k0 h[P``P c R jpӀ ˎۍq:МW	rf+aSfW.ܘuOaUf Z$f_D  ak?[ 2u<@tĀut.`˸_ f_[Q
! YQ 8p ` PpNS%o` +ð ;w[`Ym SRW*׿OзIr 2 3_ZRWQ,AsF Y r3O:3!RQWSP b	$< uX Q2kYl f!`p:sX J	uRX( V_ m k7	XAP)[_YZÃU2<UuX
8
DYJBBƃ   brT
!uP ؎2
X
u	 6 м *VWQP Dt!WQ:t
Tu8v
Y_#Y_XY_^ _SM_ Pq_DMI_ 
1  #9s P  2XPUv F t	F !Ff ]X"X
W8 qa~P" i &g +Xpa U@}
fN@  ]ϰ2ðq  S\8&&G  GGP    [ !@   栊ÀPP Q桍\&\p ~ 
F0 ]
Q..c3 и( oи- 2  C@@ XWP i<w3t u*p O SX9F& yPn.__@PfX2$31 o  ÛpRrr4!@fqfQ8fYgBp[ Ȏ3]Ou r 2=Au@u;Áp u39 u+ f?wufP@u BXu
_f`< t`%Ka{At{N2!|Sߠ{_ k@Q  ~{{ o{KǠ !qO G{ P ~{_{UQ   A7{3j{op446p.amf3cf=SCAFtVG t"ffff Wuf(#3tfPffwfXfar_32_p9P~
` ODP ($
з,aô%׽´+ͽýfaPKМʽJt* u$t}0$< ȋKf`%D	}$] %W` +Qg$Gfa ră<
%	*P'z @TO xOy er$DIsL :  h!                                                                  fdS@  l ? O IYOO  vPQF 0 .p	˸y`hq && f"ꊦ  ~f3 f f@s.<f.:p >` 6a  !.P f.""""" ! a
#
P" f3ۻxgf+С f`ffWgfǃയ#Eg ٠׫`뺘A vT2gf頸gۃg u	f@w1  @f@ۿf_gf1 gfgf_0	arfQ@;gg&fG7;wf+fa f7gggfb	fP#ffa
tU@@P	3
gy
ff|0
gf3  P
@rΐ@
A
@  gf3fS Š΃wff#b ffyZ?'wf3f30n,;w#`4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
P#W!fكs À +SfVQp g46fFCYQ  Y`@._f^\ g&GCffTp[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u P $faUQ	U F @ E] < t<t
<t `Y]p4~ RPQRbfv2  ^~RZYXɓ|	r3`	x tt -  t	  i09`K߳#r5=s  "#@O@18P,Nfѿf3u
P t  f3g OfF!b"XtбԳ$PPTffۋ`U^W3&fPQXLYq3)YaP'у` P!8 #	f<t`L< u#f$!wAPtfaáPf䠄t"
桰   u$! !tp &k Xa{{ݯށ *q밻ݰ J#LLs@P}FF
]X `j . j v
)Mf.N. etI4~r@5p3؊^)tuw t&Du .⭋^^;iaϠ~@t&ڃ.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX._[XÜfUfPP XZ+ f]ffŝf]rPmX n跐  r-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋy苡_֡FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	πt&D@B êĪǪAT~0	VcH UrpW蟁sʁ `-su fqt
E$W藀Eab&G )
V Nh8Kr>u roG Po3F) r\ {r=H r8ޠQWss#

Rr
3 s@M1 |#k###F("r#謲Qlr@rk20!0p o×!r"~!F( Q'&d&K0#V&Ơf)&t N.QSWf`ŀu/ r)v{!ufPs \fXtā_[Y`<t;f3f t	f ;u
utǳpǋ`f[`
 3 P ܡ;phf<	8PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXN8NwN 4o2N?0(`00sO/ mlpR
 r
fQmru$fY_b/++U+Ñ^ &u b%tr_q? VQB  BY^	G $s
3
P&u3` @
r
%uèt?àt <q66V&T߀Еߠup 
*&u^ô  ᆻ  QPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ".0ù[K<P~  = sffP SQ  !衊Y[$p
 F@ 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
PRV s Zn!
J
8
Ή0
$۶g4 Nff`4eA fu4fafFDP2`a  tfFP ۈ^DPm fp]fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )Bwf*ݸfwf
fAN
Xff%	G,fA d!`
;Vt
f5AP
Q
ĳ6"P  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? 豆ff%fZYPQRWSӶ3t"X  X
譆[_ZYXS[  QW $߀@z _Y[`pû z
  5u
 @ @Üu8 0  ;Pa@ F4;+@H0P ߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMO?TOROLAVPaVS\~ЎHb_4P-s@^s˻ʆ~ >B4%g>D4 F4 H4
J4@L4f{SR &-&Z[>N4f>P4﷟΢U4W@U0 t
y@~Ph+؋Ò~cR4`W4Y4[4﷩v]4mp4{da<؎&3&M<St<Mt6 6 
6^V`Oɦ *ʯe>  j@e|sh BU6@	-	U$`

	e+ 
r)>4&~X^ádWV1.GF< u^_J߳׺+BrD.\J0ERAZqER.Ȋ̱pMQRR źZWR  ZYolR8AS؀u
RRp	[P PXE%
cE%	X< $ZT
 
"
t`gVW_wZwU
uQ6rEt> r2
tC r}Ͳ  rJF 
p    _^a1n2
u[rVei1sCr"trS '~;Wr6"Q@
Er GS֝)/Te  
 ` Pt ҮK\	\*P')0\;#$ rIW("  kS_!P(B O55B< t%@r4;3r!- ,-yBq3ɰD@D`ó sGADw*VR@ ރ|   t.Z^8ħP .;BBBX$JJ2JBPܰ\C*tJ ;*Xu)` Gr V tA&q JZ  C@ۆA 젒*uP= ]Xruŀ̀2	w
 ) (8SQ2<

2ۆ.
$2rvqd<w0
u@ð  ` 0    j3ɍ6O.Lu.:Ls&3.D}.L~s` 2`r2]`px 2N. u K{^t
`3t t
t
u! 蟤)3ұ u U t>P.|` .3P u} P J}uL   u3puv`bW~_tURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ϋ]Å Q3| Ys. u&	 t	&Uu" ώ> R |  Êö)l.f.|f@  3.|4߿ _R\PQW 3ۍN#_,`Op1(u p;`3薢$蟢 &?t+aP`)}
t 	
tN .W:UǀV tMR?WZ| $p$u$$<t~} t	^^ Q3䆊!*Vh P| ^t
.u&u
cs)t!趤Rڻ0W۵u3ێZ
t	'u
u
 tu搉@s+XP{t eڰ`bz︝t"Ĩ@t  p 
 ް  XPJXSPc .+. s#. sXP&   &X[fW|$t~$C u>
rrw`U~a `B Ua p 0`cߪ+ SQVf fp   {U@  
 P  p^Y[_u(PUF    f&| ^	Nu<Vf
Eo 1:RpLP	r=^ðuS@]#^[Nu"

 
 ^~u.R Uj<W@w`UVJcL1YBS8WE
u&* ` u!f_fPfSfQfV   &=Ut< MPTha &Ep` `&ufޠ>f&&   \f^fYf[fUh &]S^ ]}[#&uD0DV& fȡAL
^rlfWދDVa &   f`t@ 2fʃbك^;0P Pt_ 'f=%ۃ'+a¡f;ME 
+ Wf.PPZg&G_lE!#3crRuf&T
f.Q,f_utf`@] ZStQY f{0fLfp,  !f^p91# ,L;Q>!p$U
UEG &E"rkfaÑ 'rnOGw|>P_@10W` "Ў؎`1#n@ @2K<t/fQ!Y<pD%PH
fu fp` QYP4v.M"fN?g
w -"|"#:O:OP9DQ:	: ; X;Q.:r(G)uP)D > )uf.p C - =*VQ$$D
@V&T<^{30Dory9
lY^C0 ~u0Ex0"VBqEv fS l(A=Dg(8PVPWSPW@QNP
P@EA2LDra
fNtQؾS2KWpM T;0@fP: M^_1PTN?:R=ffWfQQtT=M
Pe@UBLgALBRL3S }G`^WX!WXX1GWiG@/Ӄ(WLWWmHP&0P	3
7uO`gdOp%Obboؾ:!Q	TQb4`#SShS3Rq	)3AUEfdCf`e_W3n `{Dku_qnGhQhhRV'hh/hذm>t؍`pjj|t= Yj,{jA
1$pf[ jPQRG B㡀uZ փ־& " Q URfQ`vQ ufufQ2=fA<t1 `Q !ϱ n r.V sfYZ]ÐTf;fRff;fZ`Wf!тrfSr'f+pzZѧr
PWr#|s
ua

<f GM	rrBaPXPQr Pp$SsI[OBM=I:E{/ў[JOQP ~Lf oXE)t fat/+f`##fSfQf3< tfn!L2"ZfYpѦeUat?$57 3#tcQ!d[0
ð-@wM!ľ!WV@ fSP~WB QKY_W
t^9PliPst6]V! <5u G	F^B^= ~`"s.
<5 = 
uO>峟r aϊXf[2PX^2Y!WfVfAt
P EMr& ~P֡B ճ y`Ђô PIXs #J#A`$$J$PӐ)
u $7Đ ð) e1U
  $
Ǌ O $ $r[$s) 3+ \tA		SYPðQ3r+3ð&QtF!tt	*tEPÏQS&蟏"
ǆ規[贏 <t<!t
<P	<*!`R~#

	`ZQRs`-P ZYpD 
 ڣ) c7VP֎ލvS<û	 8[roX2 F^a ð!*; ")< u؃ tr
sD@- mJ3N|
u|	 *t0  $<<q;<
z^À7" 4C ؊% ."؋ '7*ZPQZu @!UXðLQVWP 
OX_^YaQNYP2b PB2ʁCqm]
P['"4#f1uðW52~1	R65l +S,_ðT,ՠ UY9@V-Z:.0V'UR<*< 1316k3p9XpXqXtX  A  G@ @  " y" zU-Q R~RG      *[ A	 ܠ` `  Gd d ",q  qa aO 
p p  Gr rrs sq]
s " } 
 6zr 	 
*
 @} (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Àu v5u t
&  `
x_t^t]t\7ustF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾi蓇r9_2.i ukq G$!wu@t0<zw, 덋 
t
F
	t
w
 Aib2]Qi߇S?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQ%s	} Z	iE HP   PRuaa@uXXZXp! . D\PXŻ PÜ= srs
n0PSPi{ _D^ZY[XSQwt.蔈 ! !$?UY[ ?uPPjQb;ˁPQN 3۸ K `9X': B PE I" ËEu t
$}sr2t`tW  d_sa(    K P3Xú0fW%,  .s 8 0ff#ffg&'f  @] ]_ fRffZX`yt'<t#<tNPc  T M_ H<u 5  %l  ߽
 aS  \#&][0&VW3xu@ G	u1@ x\ \pz%WV j1 Sa "\X{#y\^_S/RS$	ppqu_[H>AA H $tu;pʰ$Gr@  [D	0pn<|}p͕畠llgs@021jjz     pu u",@;b Zf`g$/u (v$
vô$vvvfaVМvt
v$tº^ Kf` u'=_ `v $Zqpv$PvfaM`P
Xu!P賃<X{u@P要tNa`
  P@a  fV@@ ބuJ{n{t u3N@f6 VM{u^ uH{u{@N`R\p Sh{tE {uwzA uzt!+{vi
&  
]_]f^eW`Ԍ_ $ $  GN NRP P`Gh h"Gst1$  B   
G   {Q`   0  T=`r 4ƃ4@g 3~4 U  < SQuP $@X߀u@p@ͯXn$Qtu
?R=
ERVWf1.1V0qā că~Q<VV<WU  ѥ0T `afP > f 6c?s >upf2>f֠@J8ĳf0d%ĸOf .> u@Ĵ /R+quX>tGq`a Up [a u
I_^Z  < _V_ ؾ{|YÌȎ>s1Sr " u]u '3wr@&[U  r.&1]33 a /  "3i@ 5! $3&ؐ-
@?Wb - h_ۯݻ Ͽ;v3 0ji3}
8_ah3\
3$Qfކ_ޚޮ`fW3sAq<f,u#Ή΋p f3gf&ff=SCAF2_U< 0Q
<! F ]!y  ,<w&< t'V3ɿȈCF`  ^ t	  az@VV<v^}.
t" ؋BfU_  /]dm0U^P Xs.V Ou']UUA !  g UTgg"CR`$$hUM < .%QNrAt1S.<[$ t t@t t	5@"2"#Yx .6M3Ê$uqﴀô sء S3ێۻr?4ðt W3>f&E1'_Q{X%TF{ u!uO C߿<2{f]
 N] d `5dPQ3 27y4rdr
` r`f 	p @ QR@TPQۊRPK,Џ <?u
 @s귄3ɺ茾P.Ў `.afV`f  
u	r Hr" s  > й Aaf^;`@*2Պ$ԉNT@׎Ǎ~WF$
&FG &U_f
	虝arAuP t2R ZB_$0Z3  P    { { Ab Vgغfm Tbt333aI uF;Կ ݀u	66Vu%2"#(.4		o
	ȤQQһ$ [ø ʹ2r_$<@Âyf~fR  d Nptp' \註fpf.4 f                                 0 `0f>&  󽤱=6aw Á. 6ջ0#RfPfSRRBuFf3۰S7u"fV$
Ѐ
tf `uTt"Ttt4%ffZf[fX 	QfWfV g&?tGffpbfbf!L	g&GR u#f^f_fYfB@Zn J)Kqf`0s Eeu 'f$
f`&afô#wffmffaRМufthf$t[f$< ȋºZ u1A	)/f%fG#ef$efa"*  Ӟ.:f tdu祐.f] gu
#p d1PfdfBd!+ s dMd5g}dЗ J V0d1d<d;]ttd|d]^  R 3
' ' FǠ  F/3 .;v+GuBG
`F/ {@ Ë% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFSۻ׆[fPS^ۋ^&t` $ueG&uFwtt6]' DG~~~~l|8 8| 8|8||  <<    <fBBf< }x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0QUU$ff$PVW0xx00 0 lllXll  l 0|x0f 8l8vv ``2[0```0 @    f<<f0 0  || 0p0  x_8`̃ <l 8`p  xx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf  ΀ 8ll8y` xxpp$ x0  Px ƌ2 xp``x o xa"x -7w0wx]|`` p 8l`0
zv~!`lvf{0 x  `b  `~  ! vf' 0|004-!)*`2
6 	p&0d 00001B  0c v
pou;Bf SvN .<2[]`0g i &  _
ld@að
 `
R3҄u  PZa TlAE eMA9Y.nSS  Aqb( Pg
`3Ҵu N <tDZQY
 Ir¿8r502:6 v&Z aP P2`PCI01 ISA`#+T DH03COMPAQꊙ 03/10/06  D ߣ    F10_  Ln؎h Ћ `h+3f  n L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.1Rmp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6h=jF_d&  hE >[QIWWo1d% =_ ۘGg	 v	z]G@VUk?#
,
N	#&d% *$2>d 	V
J!fbfffNzd|dmafw>d1jut$UQ"`	n2	zd		D	A	
raUVf	A$E
ECh	
=H)RSF "4\	U~zdېFB .///gR-iZ2z24~T
!y#U"z&-%2Ux6='nB{FuM)MQ
h 7}d*]+,ad t<j9*A=<*8@EdjQd$#fh  nbF tAt=dtfh jnd$/0!qtfhqLKbq >tSHft3 tE>2e tjh2efjhI誰`8%j hd~1{t2f tOffh[ߞg t+g *$)~f3f
0~f P?FPh@0Vhg"2 ]Qh~CT3F``He:=#2h|es `h |e=od V05&~	hf4?ƀBM%Fhih	tAyHFdFdXFBhb[FP8@ hprj h!J]
	~`#fhgB(z4YI1Sh=dr,V=dO^05%h+01!4 VcES*hLnh4
$$O	Q"D	"^_ !2FF4g^ F&<
uI) u&*_&8HgtFFP9 1FOuÀٹ F FIuF*1 F*+҉FVh+;u;uàh% ;Fu	;V@áhG2@A99h%_ 
ÐL*	
 WPa
Ffj h}LSC](-{ f f0h0!| &b&djLfkPQ~@[j`P FPW`8F*"aPbAV=ut_ V!  )# GF| ud02D|[p h &
A F ϋGP	@FNuFG0?7Ʃ 

yWOx,HaF/ TQ	A{)wF?
2` 1p QyZ%Au>r	UI
bf?U2%#Ƴ~	Ce	$
1dфo2mh

dRaG
 &]"@r9qFtu14WFB5 	% !d0` a
"`ףb% +1b1bj_Ra3p%+czzd1PjEAC` 	a#
 U
`nh~ Ќ3""d[jD
{E
C @	HB	N!,gD	3|1 ji%X|T*jSr)
 U@Xdj~a4%&ddKr
x
xR{tt1`	f"q_Ft@^ #AUyB#@z[2:p'8{b0T<ɺ*3 &d_{djTrxA:@(5d@w_&@d 8 f&_d1O27Q<_& &O ng q	}av VUW HfL
b fd w dV t}JABL>@@A@b&!{!0^PWFh^F  ^F&F~
_r
f?&f &H` &te^0`h}0@ ~g^@ d2e@  fn# r٣ qA*pU`E  p  V6P^aF@t+ttue Z,tT@-uN&ff H+f .9ʀt"Pt ߃]A} QHf@tO
teuUA&2 _&e   ` g d!r&dd蕳ofit5D @.CF2|0@  &dw.j j  3
vwB %#r~WF_
(`B&g"&g &{gav5&ˣ +&C!&u)&Ƈʝgd rP\fhJgP9M"9~dC 9Df&EfFVD}!Fd߄h
Af|e	s$"A4 +a=r'v01؝u`,Df C~EfFJ#@ty)#Zj$	cޥ>jgZ	܁ Df$ < u @<@/""rĸ`" Y1 e >bD)PU94333]G(va2XSf0 >b
t%r ӋF^Nr'~#tp  u^    % FW )A^  ~u +ËFVVF6Ƃ6~ r~t` t uF݈0ߍpfv
0V׶32,pIu~quSIXX[t
Ӂ
 ^^pܸM~  f# F B F~P|v^ K}F NFFV~ NHt@HtcH P )onA-Ph0$6^F&? u/dv萶A8>Se|nhXdΐ22bcV;3dv近mdLn`
NNF -!q$F8hFFPjRh_S^|/GFPv4AvFhFLn~P?dbPa?:!Z~`d`&@0c16`b`~2|FtFr(}QW^
4~`4	b-2O _`-+FVFQC94%~ t;F4.FҔ0
z u WV~vN^?>S
A0@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODRHAA~(|W~FIt_~@u"2Fw#}HFB^F&WN} 
 
%.APU!u@##Y KVDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq;&'h*V~oʋv!^PFG>Iub: ^&^?&8t#^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ N?FN+O;u0g03ɋFpPAFC&PfSpfF ~0gЋsG^AaQFހp ~
韋vЂ@x|r
CVV,GV~^&wFIa&a81FQ2d%Upr">⻐Ikbf?N>Q2&1%#B2
= 	Ce	$Q
j59RUo"R@FGbᰪ ]2PQ_v`VP
b% 6zzd1/|djA
 j 	aSr (T53^djDA{@Er2	C
{@H[

N;&S
	 UU@g}3|1 jiQRbi~bUyUzE`	`x9@`(#0
T7
{2
#26h BR5*S W&d{df0f   |efQ	 f  h FdLn؃2"􁚢 4 +d=dFr3d0:I VJ,@szFR3#8BݨSº)BZ3~QxsVp .rs
pς@>j6h`PjFd Ze>溂Ic^?#d 2W( 62$>d 	u]
9Dod,Xʕ2G [%]@ْ`fbf	ff؃/fzdPXXՏ2A@YSA \ja$jBGI
DxU2E$
eC4
?
!}$H_qRNԈbUazdB j)~SpF "Z4Vb	gPLM;ip/#Q~0PRyL4zxB*{AV_}d*L!{r@@>Fp߱ lj}h![BXWVvqދ~ &F<t<
brF*;b}7Ay~tF&8tFu|t<r2$VP^Ưu	A(|鐠޿ ~Pfh#  ` PF;rF f?=* F  F*N*ȁ vF7P0"vV
u+e4g^F  FOu)	"fDg &Dgwnp tsgq0  R*&h2`% !h1hu8= +ɉN3h33 Љ  uh?$<u~h% bpu&u]f}2 % DP	u<uyB )g
u/au#ah#FOr e4g5g6g 7g8g	9g:g;g
<g=g>g?g@gAgBgXMӶ f便3 f  ר9 `ujvRP v-  `F  vB F~2|俸1~İF  p ~ uF|eLn
 f jtWV `FRvKF@ b*J*p
NvQWVq{FFP
|Fo؊f- oh n
~'F܊f d` F֊ft@ t؉FjRvv}Wvh 0-~St` s}u P0M2muFhMh ;Qh߀ FފfP~`Ff Kjuc:;E0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvoƹ\؊GFAB Xsư FN&p;u0&LK 'O"a`0܁7aPjs,*`
- e)@fp۾ NV$Y!YG|"[([ [<1[劆2?d$0   !v$j)Qgp4
CfeQ A_hЎ 0f@ۉ6y*V+- t*-} t94@!13o$RFa02 {OChOboLR@IF 0#"7g
11  GEBrAr/ 3|
߃/@+F+PRqur6pd qa"$`a1dhˌب kb! b1jLFPQ}(1@j)"#2#"#
1#C/]LDE@WV3 WD!^&@RFG|吋3x6 2 R_& FWuq` $rP7<"JW>do ve!bb6   &=  t@M[_  Ft p 
Z@"4g#-//

	
@yu	( M~PĴ &?&TЦVP{S~ t'jF I l t/ u#'jfyEqt=7 tA:?@>u
f&Hf"f2Hf% Hf  t&f1`ul À&l YgdƯXg fhFfff[fh{e`b0b1bd{eU>u[h hJ퐔h Z{âp:h^@jBz育uւhR 	["		N	
Az
4!F* FMFk`  @AMb2X !Žpb$< wrעe RA~Ӏ>et"b`& Pa
u"0	Ȁ>Re uzfh  a  >qbvB@car1},c
\d!F !J=
u<cp3$upv tIŢtrtBtt@2b3+&?(u"&Rup )u&GPGP됽F^ u
 fj
 0 	   (E.~  / u p݀&zdqFF`U>~ tf Dj j P P= HtVjP M-
 -!/봐> ~ gH	;	~p		߃>	aQۋ@6RĴ &@u'3pxTyl  	&&G&Wݐlp}E"   s- ;t- t- te= M-H- {-యD@ +fjsg  ;@gp Ʒ"`p "g vV>{   ߈vVP*AF^ VP% 
P h
 h  <RaNF
+F@pF!vvo`ߴ	F"`NQȷF@`{vjy qpCFPNQ=`O*P!ؑ`VW   3?_^Qa #"`%A  S!F
Fg"`F.
%
;F|!%} F@P!y]aVv р`NcF&< t&@A0FAu
 )F~u<  tFF7 PF@50
 f㢴4@@*	`P~v*VA ;Г2Ɗ*1 ufU  }Vn']`!> tur3NFAY FNَ&8tGr vN! ؉^GF
&Ft;^ G  3+tp
뎐V^% = @@A3t`ߋ@!A;w"Ā>
 u31&A *;t{r1A 
*F0 F
t t" 0`f[p0;
V=O`2P.B@ÀO?Vu	.SEմHDa!E'(E02rVu`5 3
l|	Sd7RP3>>Q XZB~38tC8 u31~^
AF9G
u݋N3~(~ q ~ F;|;pUƄ  fUVNVv<%tF` u DD^ù
00N u0+1WCRP MX ]V^tQrJ;v~ F^F&uF$=W\qQb]R~}   P+΋э8s,dvva!VpN&8 uN&= ;t&@*A|ka01tP߱+ G0f6o !
`f_+IQ bkqCTNiS
ʐ kj ##vA`
&F3v~Bǉv0JQ&}P0z{b;~ANuǋv 0dFa{ 
FfP0V6Z cPQP F ~ ~
~h3ҋ P{W@t4hP{ǰv{ePq 	ptGW5z"p j9F
uQ_PK vv#5@jFVF20ްNvD"F9F}+F- P@!b' ɒq YFF`%R"[ nT\QPEP@DPAjEP:! fh  赁39>_ ~jy/0`*9Pu	A
@0
A/\&7K6%'@2)
G;|2*& P c`8(F0
A
jw Q}j V
V?RP=A/Qda'P? WVs<n@]Pac E +FFVda#
0UcSpbYg 0aDPdQ虡XQ	5Q`,+F+Ѡ`M*2Y Rg@=DI=ӁF3@**A;}Rvs`V6r1qyg*@F;vwPS _4C
sR14+

uSK#aQCPfdDp$A84	PeV輡VP1~&-24hQRtY~AS;}`=y#DȰdf&D&TfF3F@F~
P  q &Fި@u[] СFtdF;ƺ@Ɛ]q<vN b®PO;v}vmǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FfF	_F	} t~0{Vg~|PtOC tG\'F
t/*y F T9F}\LF? ;F~AZM
~~2G+F50%&L
q DF_F 0  Ϡf@`	PX f@PF^^EAgT l2s|rPxb<FA@ o0H{&v7QvFvFՍ\Pɒ #R@~U 3'tsF+FJFHfh iyR( tTYT4Kv^ .9~ݒ4a+Fek6,/+F!}=ptu.tPo9q &OC@ +σQ._+ǀC
0|ctj[|t

FB.=Q j]>~oW0!L# ' KCA& !!ypa2#$QBC}PPCfZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfZg?F  F
Pj   v
u}1Aju >PHPV`s
Ϲ&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C puDPk*.% H!MbB`tu	 rdP蝎QGg	R4O1maiDu(+Huun @uqt j	jfh	m	"	PV^FPqf~
 t

>alxQEPzU@ ]FY m DVV~jvvxX 6G ]3?鲯S0'02Rr~wF0BPR1qE~
G jR[w807+$ }Ep  9]/t ##/E=/`a/FFP9 \ dpg
p; ;NNNQP @C7/ Ƒ= K = ;  -Pp---xАWp'WFj  ܩk >g`{ Pi?;v1!;vFPVW>FP~F~PG;~~P1% - D- *-^#- " e= Pk'-R
|5. G@6- ;sFc?atU tP` zFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< uN0빋v T`ߍ 3P Pp & !VN;
u逐xA^F;~m~aXS `
$~Du6?g b_;|qT/QN;v}wO;഼6Vf~ u?FApL怰9v|GI0Đ0%9F| ~A^&+^& 'F%'302F`g!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>6FWV  Gc Df td@ @ l tE]f
|tATD\۲[u0蓾Y;F~ ZpӁrջN@uO_p0
WDK=Np>|e u)>f tl>h tt >Fd t|dwB`hfbu?0 Whp.u"jhbh$` i
j(hgh6`fh`` J `h=d_h`+ `4 `}" `m#$`a5%6 gB"	` f%^ Jfs% =dc%	 +dS%
 4dC% "d3#+(i`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hj Нp;t1rt߀DiODpU_*䊇>AvuA*HWvAPVt0<@p& S}5544%65245r659hD@E@ jpPVߋCpWVh
	 !V3j hD	~D$Հ`HtHt#h !  ޣ  C wt^{ f	$F~ HtHtHHt$" @ $Ѻ&&G<P jh	G+P舐X
ǯG>7x@n ^aGP0v&ƀ ~RwrjV6 fP)v3P Ы>X F`~|֢"v®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |ߊFÑ!	eMѭ	L0#	Kac 	3$豣0(`(h'聻paߋ^p3&~/tC&  v&߀8 u*C;^|ckF^P9Pg`^? tvN~}"߉v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - zҮ<5 1 ;uJ< tCB޻tZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@_F	 0 % t" uNj phF  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|,Bdn
e6P $
P7ڋ P.PC 
Cc!
d$  *8fudwg"^u QU/	tP3ׄ`0F |n FPf@
t)f37fn @Hpfh j ha?h` 4$u @3l3 1`F*}A;HtϠ5= t	d@ &d鵫Ǥ ڑ.dQu݉&
:	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*
{
@5q&
 3F! "&d&d *gh*g!B"  `F?P~H >AKN
3aU$\'"%aC:GBHF`^ Za0$ƍ&Í,3F
^46 x$dhej(j 9
P8
PPfsV
bW&*`)@&` ad t&<
 <)뀖 x/
Q %'@q`
! Ohej  %c
bN0*ff3	諠`%  P5Ѐ`RB/
?
$*E0/o$30/04TR$R"`RVdDpQ%W
d
aH*=	- I- 9t7-
 wqrMt%
- Ktq-M;tr` MYnp= d.ڝ"8F,2@0`  8&`0\'R!"Ր,20`  g0PXu/1V hbhǗ STS  9YۂY݂Yހ
Y&y"0Zd a=	_[Q[_"
@4/ |`r!@ `d`da0y y Vfh0/h y Pc@t&
 
@ ACCC΁!#!
@d`d`
Ɛ޾
r4( + (#+-+{tp*tcmKt
- tu] &3& tGђv 1vhh?
h P!wu
j8%A#&A
-hC@#'$'a'a{Ðjˠ́ ڰ @&
)3bPf 
0>{+>>G>do'>n!>]/>f'>< >Ћ5P$pD D:>E489JR4"" :L%9
5BδBhh V2^Du+! 5 31;ƻut &`S7髗AA@A@ctR_!P!_!
@>(aO? 6`L.rࡠAL&`(a~O<!Q"Q QƐ*|3ɻLn &ArhOE@Qmps@	XrQUUtD3,i
; YK(agmrFv!
or0t$Pv0%@EtxDP!D$mD`
P#wBf~O$x0%YAǁK=BD=H=yM(a;Ա;
fhZ " [BGb %^
t
]
ct,W*@t>tq *``(@a@1)@+AE*aŏ9ƏCQ E #3 ғƦU $ $%0 04p@
%@@tDR~2+6V$
2`& W	4DR>'
2d	rR,iųpǀp
o,a6&P?AsPD?A di^
MlXjF&  &֧*8F\n"L"#1p  Ap"!ab!Ca2 К+a@y+ac ` 뤁a@]b*a 2 [1 lfbW}1`0!@c!() `f*afd"Wfh  VAA
Qfdf*a&dw..@Sa=6P!6e >>d>@!@FF%AN$N@dҀ&VRdVCD^^AEvv u_
~ U
u3
u*
u!D	utud`uf  ,ǈgrh2E4RvɋFHFPVhPSЁ Xv
WV0
ߡ0ahHtHtat-L.L+ AK!!IH
GGB7)Lptuճ*%4S'`C@E1GTgE%BM
Et
'@,  WVf+_fF@ ؀  Fa^F贀 F FFF}4FT`_Ft4D>==  ƿ - -tR_  =-a -*t:-߽ ߐ= +- v -Qt}x$Ht/Ht:HaC 6  1(@  F! "!13 [bS" (A
Fy
t)j 㐋ePdPfsV?t9;``{aQ6@`_!F	p 
*HFM~f  fFvfvvFPv25Fu63F`.-`~%va :uFG;F : j~ t
&@{ P ~@&!  !qq t&AÃ@ ׌?"Ht)3Ã? @ bbNcԀ&h q f>0a uuHj 
@3v0 R0Hf.af"f 4af a T t 9FhvD" R
.oaHfa3"8-9t- 	t ű`R
  *hfjj a
 5	u0u.#JNHޱuh tƐ>a tuáfh  P*	-NRS>Ta t`6
Mhaph(B63ab& T a F |b rе!mScA >p#u>}p	\t&e~l60a	pމ K뵥hbte3b1y3
>4*}u	>t ׄ0!jj22tׄ;3Be'kJ t'zH{80:2R%4;44j`pr
x zp@ǟಐAр!F@[$
$4M*tS?=<=5
5
p.Kx@a	`@Ba	 	 fh+rD-q pTp$#;$ %4/0a2e bbdbHfP۠r ) d= $Nۺfg1 UO02 Rb
%b
^c
~߬
 }g
0h
` 
B
 Gw`ߢA] Dt,-
t%-.t,-	 tE-
tYt- t/pC DУ0a:B~AI _p}}yJ  oU2VIftfu& rA Ifwtu
P0t Hf@  -pʾ@ut@;>}`  Pr%/h\apj;tXя6 ]HtHt `t' Q 軽h	u
^_ WV3ɀ> N3һBrZA@ߋFPWr~0r>RNpDt  & Q FV^tF
&ud,
,,,L,,, v,,.謶>uh hLnh h  j v
<ye/"
@t\) 3҉
6o5P@;@)}F
r݋F 
h*M͢	
JX=
Z 5#W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpfbfffh  
bt&
]S
 PdJnt	E:t0pDq` ^3

tF^&F!Su	 |03$NF%@
EP2}̀nGWnrF*F+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.ػ
$2B/ /  p- 2&b% +11b bb@ 3 ֐j5B jh
΀}E
 C
|@
@
¼/ /  (YP)@ wj}Q'3
^'ۿG`hh5厀GS.bAcb׾h, bߠb$ a
0&
cu
Q 
@DM
F@f
fh0`z !"
p.pfh,-`*+() &'h%blrd t0
Nd Ǻfu
P0  O hEݑ `F<tF$hB"B by_F ۄ-FC|FàbG%VA/biba!J1PF&J"`	lLդHR ߰HaOeO KDRB
HT6PWʄ
aī90S1B;H

H
>UF \X\*_	Հd
Ra2C `bD2lTBeBD	
2QLphh!TB Q+[j d
R"
&%l߫#lVb$55nUr&Ep$("(-  ߁ 30) +1T{bP*et[D,e//y Ab,bfcfLbfbf-
^- "f
- Kt Zd0gpiee_Bee8e2Zt¬º"<TbjÀÖì;,2pdz  a^b AB  !"  ?- 2& k{dt ud@TwĀD -@h)#̉렺IC 늩@sڀ# Z+zw艠-x Kx wmdC.A6@OF_B~Aa ң"TzdEfzdfpd@ta a֣` hS&CADPЪDԃ؄t &hFώ&? t
&@@@# 
  B	@DC
~@zd:Qy@t&fh~["ud@ճ~fhh蟮`
76荂7tfh<":;?h9n !0 \1^2JA?@h>2P Rp	DэC}rh[v0WVDf$ < u2@pAa@<@u: 2@utQ͋[;>P`  "Br< hh<Q166b  ue\ Dt,-
t%-.t,-	 tE-
tY- Hta- t/YC Dpb:  ~
3 	=}p  Րb:2%@'dF P{c= P~Ht
@q j  r j臜N@uf4Y;F~ K 0ӃrջN@uO2phh茽pWV`NW#p 
rvbɑütet
Q &6bF6`Ftet &.Ͽdg8$ͿN(.8JCM&&PG&@T%&V%Q _%T%>rhh8Q 'Fc" b`& * bPeA u$J,T7 htuhR0°T9  t~@ z` p lPp {jP, bzp~0u.&z_j`&"q;aF90#0000 0+000b a:BkVfvfhI
 rIru mh }bF c:tF&<:u-FF
*?0N&$  ^ 
u3ҀC7 ~ uF	 F
  
 }
 <  C
wv`
΄ Tjq<d^P["0
? 0
~ `~ tgh>v&~ tD菩O=:=u5 V
`
 ^3 FPPPWFF9Fr @% -
 ؋0v v sd ƨu}`= w̐*6BNZfr͋~FP.azczy ~ t m4Fa =   R F  : .E " { 
ٴQ@ o~dzt' ƂOFZ&|IZ#3^ \d1h{Vd.tCq u^ GCauK  K .g"pyW#I Nr@~u_ W    I @FjB	FV!F^ =uσFv2N'22g+@]WV6ߦKhhd:y*y fy:u}oyDt4H-H4HSH.vgHqy72{I.FIP9Az"ClIDzߡza
"ʬzj &z<f+fF@ =   ^~yFV^KFP6bֆMv3+Q OYڀ?w`- t$phfFf~ sAGuh镠dpfQVȡbRPSQfXfYf3fffPfv襨MF j!X0АuCFpvh ԛcWY!u"u蚵 ufE  p P0  V6PrQJm		% 6\bD60g\ 6,gˉ|< ub0
訣!Y~0Ð3Ð 0 MHz` KBSIMPLO  MOTOROLA  HP  17.22  K    Restore default system configuration mplet?ed!  a) Press <Enter> to Shutdowwn S...a <  drivelock \V`B C 	u Setup  <F1=Help?> FilesInformR  Displayz5iSave?floppy[ diskette from+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passwor0>C"e a/"Power-OnWGpP&?DevicedeDgDJbD$L $s mart Card%G
s?upportTPM Embedde&E
ta!'eA'e
t*ac",(0sd:authentic;
credal /Auto2ceTools Ba|`/0Calib(p (`'lecB{ b HDDP:lf-T- opEs Activ O Me]m
Che? r s ; lls1mb 	>>uA(AAdvancuepjL4uagC lD7  of gray6fieldO Boow1bD.E.Uany keyUY ue F10=
, ESC=Cl @9RAcc{ep/=YesSNo D, Ajo$r=MI AW  Us|Sarrow
 o highl@ *he appropriQmeOnu ifKpdNTER> dbegiQg3hK%#.follow@M%ek&:`t k-> @KSPACE = NexR3c-BAC9K0mvio"F9oTABE3iSHIFT+&*ƔsF2@&10 `
[J #'9 Er Th{is60cann)bmU;d An e oc^@ #wh0t6c.Pde 0x01 e`jndA@pGu@pp{6Crequi@yȡyE`d~kba@%mu0C
movP:p e4k/MEU) hQ1&`0jll//+@SDFa06ssfulManuZ rr  Nt0
d:Pro utypspyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}sbKeyboorFr06PverADb1<ed2e3bg41qa< NPhip8(TAdG
W
O3O 	*	taf dai5u%BS)Ni$`1
2
3	ME$
C

V


4T!V
o
Do
So!  : AD %FPA2d!J#biFaPWalRX0sԔ&1&H} A{ddline4 Al Xҁn.eFdWarn: rk T&llpo!  zsڦTrea /, letf ea w0΃abLp0r A: 
deĮ` waqt`t Ұ_)u րrnInv  ȍOP
)!	%Ayou ͔ wa@|to A ?  iI  po b+-c?(Quick`n2o2 (Cvre@sʅ3 (S.M.A.R.T.) EP1pex03im@s@): 30¾# 1g3>0%v}}`t y ho#0#uprХ:1't4	f-Un3knkilyWR!mServReaPS)doџt7`?a}.ribp	: `LexP9 'bG H  Ol New Vfy nY7Enc8Of'f O  ɥA LA66#%AKroE   p dV
Ad1ݰ U@ҭ5Ocpcaus 7APp@=AH
"h` A&فOpower-.ASQVQa?Uׁ= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[vYDocHishaR`ed?!0fp]Dddial JJe HyP`"UTool0 Cr.%oF8IL`ˣ Bk g Uмn  qpm`@jtWSN !ar%v0s /UcwchQɡP2"Onj* e:Z%%% AF@%԰#Dn -f  TndpĠfӰunuR?*$n)tartBQK`fra Par1yNsza $mediaaAl Mmak ,n LANsQG CD-q0F y D!7C|U`	|Q4 abouud}h uR0[%_Q b0USERBMAST {a
panpR<ccUrEW"k_eep iRaL=ephysG?p1kr  :mpcr. I9RBr0A#
, nSUZun-Bڀ5j JOO1Auto!RcEdw\88 I3?#ON> 
(R[_nR~1Fbur Ct@_!R2tQh`Ss1rw  k edPerMd`qaff+bdata,@`ssibomaANnicgiAE!V IPs[pl r5mmaP  Wu`|l2,orepla^`r r/*@|4} [0uBΠӔ, coHA=Wy'u~me`1r, @MV`*ЪpPxibЩty. IfrdoTʄpw8`AESCvA.!
t V !Nҡtyp#b'>'q`F10"q`rm,bs {,t+  1E$` MiBjQ  KOru: U ay OpXےHDCgDL!bA~ (left`/hUSB t HqbsSu K Zipo'Fir oA0Fthifp Sixa h )ENhASwap Fn/Ctrl!s K8tᓃU.S00slegackcH $`7)n0=pr@ry Vo  d NTSC`AmL -J -MKt
BidЬEPP ECPd2size 32 MB 64a F@pAlw+aynPPi0PkACS gWW=D Radi AkBluetRh`/rS;#chA Tg"Rʠ`Pt ED Ch*,..2)+p)c-{-&3EQn8)e I123TokR! Hp
@kP	M3Unique Idf$ (`eP   *tu`    SӾ MCalCibaᆏ6N AstPS DL A.Zb0B [ HyO
ЇELk MEUk'g'MRqN/G/U[:P1 : C g 9. `% ]/MCle2 zc1 dik-d3	ps
 H

,
* A 5>M(o!ylSp   hnology'tFYadapDPXE RPL Ex|#Popupz(  0 10W  2@ 3 4 5 6@7AF12z5 15D`@ 3 "M.B~ ouchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\O؟nzeigfxpeicQv  Kgu4aobVcwieP@z nLvEeinun(	Ɯ-s
kz
.igneDpd*nwt neh䀂7/%Set@%SRheitsfunk ntoa u
 naDlt-KuO] Gertes/-$-ID@ Ot 7	U>sttz ! 0pѕz#  beim /st
nBg !@M r5}nHsvorrq##7..zu/rck@z90
B .p,!Kf_g{ms>0Ui0'ExG੟AkkukeK tBsgewǄhl@DD-Selbs`s8ôItivS9#LtIpr 3g 0: tpplAlTL
PZ`OS
@ PErweiP%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e ҀSePMbqTa>@0, um p_3gfahBj=A, ESC=Abb!#`W`Ierkze!TJasN0\, Ja	=Meqh`m VeZ
zpMarkė"`s@{!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 cs.	folj
Bn 
sg:-> r LeGQ ?= Nch A\pd<-RBc?hritt-`VowA(TaGbul!fs+ Holl+gedx F2@
38@= {gy EscLhlrL@i<PK kan~Lt we Y!eiffMgy16P=`?rgetrPn.:Dc  01 L@`fitM B kqcQFY+<W\selnomvorB]er0ilXW^qDeskU-KsBhmu  f 3asbzw=.2Mobi`Zbgptz%.` Qz qh4Bi///"2f!
}[KAlgrѫ ab>	chlosF-Mll Prozyprtt` wig!60a"Ca`-i-Gre (L1/L2 kkapazit OMPum"Famik Sp; umm Graf/ik-Rs@Q Bz]r-Con "
A   a?7J	b31O m2O 3O 4d0qV si H>(F ` 	o	o
o1
L
2aSe
krET*@ L$ƍ"%'$b-!3Kc(1  WalkAZero-T\<One EdqA(`PnO`D+: bX7 stqbislwnKp  ZEucQN-/aWB _leQb s AteAi#CP0&ILp`ak A:nfdC6
lW$ge`KR/+Pglp%ɏ53 L  8	/  M0$wirkQh"vQM?`|3, daᱭ
l^iew QPocF\Lˤ01 ( anH12 (UmfUafdIGc$fhrxdauP(Min.):G 30ZБdS`@0% cgt̯59wuwm #HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52^'rvo-L 5.
32@lhafAttoribu0FID 2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Fal8geb e
U	ңBU5Ip dminIoz Dur1@`'@z`|  mg1i@eFN1s
gd,E.@"< ttifiz eq s{0yrt.@s Zu@10D0LzO 9p袓enl@~.Ajb s0Q!Qnp'PlsAviceTa s ,ܠF$0@ h`$pSga|F	 :	 JZΰtfa@npWUm Fun)S7O, m3e\Wn HP{tectToolsP=c^ty MaGnagпUo-- cڑ}- k QuickLock6Subnd$Fr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B><#, lp8$meh1A #I Nk>"ʠo3f`ot-Parpe n}ґ:-1a$P7Waoke-O0ANS3tTjmCD-ր&g1M(%UT:an 3A;m$"rivie*Fxpla `t=?PcNs E-A\s mY8unbrapnbar.IpT
f,NҏbewBBSHsXDŒ,h  %G&*0	M, 22\v),   L2m@nc8z@ R󡀢B?egriff0dmautomPw S79@>ohl@C i  Qکk`}p#tw`Z*f 
X'U!!¸!mU"n O P o"a;)lrY}#OBzw痡58g<sQ}:Sn iU.) vduQ(qSX!qs qh!ac%Cw  Prq җ+I s0  qurFࡁn׷hE o. Escdrv empf/qS	 d?zu !цRO| t. 󍡟  f.РYҵF&1 2 B 07 b-B`ntra :tAdant! Whj`!@Esc-&Ll̠>m kW'p'p`\ F10`esh:
x3fg`g 	sbD} m  p¡@MMuBay&m )bBtgk`-E𴣑b(links)1tUSB-b#a-2؆Su`1Zip 1`234 5`678 9`QFn/Str	g!Ptŷ dEaCГ (USApf-ZePcB`iebss"unabhng`  cAr Grafik-Contr|PrimSek% VidGeo- rnBidirebal GrPus Lfa`iCb0tzb"d}r W_WAN-Gf0`Bluetooth9Uanbp/a jEgpaOAggr `E?'*0(o)ur/E t 1D20397ToqTRrB?!" svxHa`13IPQk"ovH AkkuPP  @RtA   x a  Kalibb 
 MakaO  Niuala   O fm   O  DO,tOTrat-?6.  .O .L`b4obisp9 cOO5"R0	E gnOOf`.[r 1 : . % ]labbloz(2Entl ho30P
m* 2a
 GS-2'su uĠxg`RadapΔaABPmB`zq}ExpA-!-Popup{ ( .) WedauQ0]d2 (Z Y  Ke`~BIOS-DMA7-DaƁb@߀EAComp0ropstn <F1=Hjlp> Dvoply9s!VisCވne Gtil` !konf0[Ge;ndзfraM@z@PSrU
Jgnorđndr oP(fslur  ub,t gdBOtnek@+hed Administoradsko K atodA7 fo@r'·`hEd`je-iq		+	*
J	Sm -kwort	Godкodelsf 7`do`_dbyggGOds -&2	 cNu@00fa@ksl2 U$c  Dg
$s)9IkA\2HF% Ba.HAX p b"d`valgte b&HDD-Oselvp^"tPr Hukox QAtrol.& inRrQҽh OGH omv	IBr/ Avancq Sprog Vl1?s mo2nedtPt felOC4+'/#5l5!Tryk {pP7 tas<G0=tZOP`=A, ESC=A'nnuaFs!3=JaNej "J, AR=MGb Brug ps@
NA`RP7xe?  releP %_menup(,1Wt<ENTER> /ec>A)get.tafp r'f!f7: -> e!& MELLEMRU?M = NlA<-TILB'AGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!hk> hsfej 8A3ku1i$20gs 2dodQ)!xFF1n. Fg01BRnoVD-p% qplax`9G!krv 'vek`EnJJ
i dd!?sP flyMs`Èn#/MEUqoO5 bp* uvetzbrCud2JI,nemfB J@`  KPrc c?or-typ 
hBigH  ztr`7Crcache (L1/L2@HVROM-dౠ fami'lie'i;A.Wdeo#f0pd@s:@Xr-ct^D-ba si 9eI2o`%3o&4Zzƻapt-ta`oFej1("Wat)	O3 OWEw B@ex{%Is8rP4E$ TyPyC%xy lydes!Bmis 0'JbvD1IL'j`e0sje var0: DB! s|e  alt@xP2[holda po Pqt2`/b Bb-BEdduw5,pr Pk
khEuGrBA:@tTUETf DF%v`Ugyldig/
lt-  ngivuİ,vi av٦,? i#K?@ $1 (Hur P)% Omif`) sl(ؐ`{ ():G 30˄2j  `1x0% frpudZ44b2@DR  	cq: KuB+"UApyCqS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeyae Fra@l !e@+ń4 PR@{	s0FC		ƈ4 D
&K|E  beviв@B7 9!Cfdes, f.. <ramG261  PoR.RVuAj@me+tabWata. _Du bu8$AM flAX:Ը vic#ehCa D[G  @ߒ[&?r !,ci HP te?ctToolo9"jK Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat `w@x6r,l
di ubilK2;+81ol p@?frard )x> Qlash-@$4PR@Irn>=m#LAN u7r  C?d-rom-p' YD4B SHop7hF:eIEu1:w3h0z,A@  Da$. l jb TBRUGER-0xOVEDADGANGSKODEN,6UP.U alPyg=s ni  ned opMau,edS "#
{	QDat l@po PWI_FQqShjlp iutComo0 08j_q@Fbyg[ao9b73pk perma anPTigz!ܑ6n?do` wfys dskP:2@rbAupc(On O"(0p	v  H.Gh)Gne AugW"Ņ Pm/, som!Pa ck@
Ryt. U p~ sg/c1  ikoqXS`.U  1befal kraf  ̓НFxᅄ| 'A @"pl . \u qÉy
G񴁴  &cO.q#ar"J "4,Q/d i૤HuA0.q.foq:@ENtr!5ESCq. t%@ or| U'F':ge@F10FYS Msf
i/P D+s	 u Dk Osr@flgdm vďRRen4HPskm DS-bas  MultiBay (K0`/$hjUSB-floGppycc{0wbsu SbAzip2FraVTredjƠFj e SjSyRV O3 Ni ̃ Ski mQm F?n/Ctrl qjElPv(aisk)pege Ust!
u1PnP0#rm-cr PrimSed Vo Out PGara֎T=j@StrCL>>ohukoPc B< t6nr compu0P ^trm#gt WWAN-!
sio_BluethМ/A (trodllo`~net0P2	pQၚUamstyC(Q*8*t#op+b +Ethat 1K23KToLR![HL	e+	 	Ent6gt id-nur7@VaFP1riqB  S!   Z 9b/ `LKalib) n
d!igO x  0"ѷ YPO H KO OM\bo   O O#01ion OOOO$Hgs 1  1O O
1Vi bPGu"[@!(MEU)J=K=OO GO1OO  OOO[ TPq 1 g: Oѿ@ . N % ].gmt2 AfFH5L)O3@	Genos	
k0

, *  J/X4% G)' ( FA qt @Ž֡ r "popupsink(sek.Hǀɀ25f- UbAg0P p BIOS ATA DMA-rq Konfigumas  <F1=Hjelp>`ilxinP0jon sP s2{Laӌ$ak")Hepfra6#:0@dioA	:Bk1)g avslu!A B,l BDE;sprograt St p'assa/@&Op4FA|U)yrsi!>vsfunkqur! tif׀%୹b-
vn Sm 16 ׀#>godkjSq0 neby`5i%itpt5auTilbakeAl#3fabP@Rg
i
 PE7;aN Ur_kty Ƽ a܏valg A!laQD5h 8>vvt Ak  MbT !#`]!@U3EG *
`Hpӑ!4vanppr΁lg 6  Dem75bM @\3dtJIel\3 
.5E6o%<}5TrykkC taJ&L&i  a=, ESC?=Avbry`a(cBAPp{JaCNei rP, T\Rer=M@bb `kvYneppilr@Ot<ENTER> hv ddu ve 'Vt?. BrukqdPp%l':  -> e$ MELLOMROM G= NQ&86 <-TILBAsKEwrigʶTAB&"HIFT++TF2@	)P= Gof#l\ ~WsfeF`  SPk'0`pZmnop@5 P M0|m kjresfve!@0m d;i pp 9!obaRaflEy@sbc^ 0d wAXa`1A|rvfucll1z. kode 02Io"Produ _t Nopablokk-mlql {typ h@igv&-ga zv$buffN(L1/{L2@Meng`	8Q	enuMV@wo-T:jrtroUuSW,kobg(Ri,oK91 qi 23R40,p( E
1w,9(Q0 
oa
oA
o,
NEk#Iml`ߢ4$Eoc%Hq ok!i*ps(A"Walp9g 0s"-h1jH( Ad`ss ꀆe7"~e PnAd 4~: DsA#. z tidlSCho!lp`@DTH[aQ "/he-  d, rnP}u1p skld<k`nn@2A:۲Os b@Ҽreg1"i%HUgyldig#DSR`	F
	#NEh0mt@Eb`?{]F igsno3t_te?-̙  HN 1 (R nsclXbP (): 30A3ggr 0$s0%0[v\st!vhF_f!_: 3Ka"qut``DUÓ5$SQ&eGt To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C80CC  G#Npu  Bekreft njA%v`l eP㰔 1qrEّjvlikt aDu!0 oC2Ѽ	aaŤoka9g3ogs.r8ɐor d<mpel& Tp}?ّ.rPa(A=pph. `bfku  amK#0vice.0u$la?eD(s aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l  ēla1nppa0us L@$AO!mpEr`i!gi$eu beska u"1-U+/- +`WE%q  '. tgl`rh,v@=$pڀPŶ. K$$RmEp! rfrard- 7Parll+vꡨFPhielQr/Pia LAN n0^af`04  CD-ڡ%vbX45w SHo/:eD@ Gh0valgAt5Arj h($s6 b~BRUKER?HOVED-8`tDK |umu ̅! E
 n_*GQFbe M`P
P ﱡ y "H!мa$ #
T,U]?	̢$ۆ P8P,pp 4qLL KOM @ autom\pDyLock5eabyggj]dT3lAc   `man1ilg_ge	. k_[ho fysAad $0ƴpqtW fo`?	ex@ᬿaphn@g@E_3s `dda gu»z. aUrrjomd Q1@0/e X G|pnq
LB  uSbVnbefaQwr G	 q.ҀAy A0k1E rғ&2;k _!R!'I7MEPsy-flAans NPEv
,2pESC-|L Ѫ(b u"'fD'J F10$Z
be:h& n؅$  QNor iFOrse MultiBayG]| "Qdn(vee)0ko>.ngsbaphhyOBUSBeA|w Zip-U
A A0@AaaˀFn/Ctrle EAVd(USA)Gekeen0AQel!	`jZtr9oA2@deoP@pJTisarrPfFViA7ti@Q@m<Fgradi/~trdl@ |t@
WWAN) OOH OHBluetooth /-eftQ`mbQn AgssNstyAg!1%%*2$ (v0&#.b/! 1 Eth;?	.-	3  !RP@NT s* ooo/
;niA@jtifikRRC&@B:riPJ K0t@ h  @6ymbo> KalibadK B!es"- Ip<pˀ?_Dual ,- N	O	I	O	O	5 1O	O	O	<O	8ksp.b O	O	O	`nd 4oO	O	
%O	O	bv mob. a
H. \L.\O	a}o 
{{O	B.[ TO: La. В% y]afull"C2F~i3
in/Qha* f!y   (o J/DJ/éiǋpkium sin@ hurtig~E (sekurѷF12-`f1.Sepute P@pRBIOS ODMA- rConfiguracie la Com adora <F1=Ayuda>~ rchivoࣺ m%l Sma@QґPGu isco? flexiacP޻ R	a (s!valoqpf doba`y Ignambioos y@li0a A{  g3 'Ln epidadAs#e
  ' Ajiciof%posi s_SITc)$ +՚@@*VKskSm>Cp SSoQ0e*cP#<) Sectyincor`% E0 e" 30/c XP>6fb	rI
a`DPV:c!3nci]~)AutomaHerramia`C~H er 8`#P(8` ;prueba HDDK!c ' >OGVp&Memoria2a d*mp.al1@JNKRMu0GbSG#
s
 AvanzX "ESvVDD
W? Fampr)co0N gr<1o?)<>UOprim'wquitec0g2)Pbao=, ESC=Ca06la==Acsepv=SSqNK1"Y, C9o2	=My
 p U@{B$6dchDha6al~  alemo apropiu=@[*<INTRO> z@ix:N1n.Fs{3pkԕTY :Esp~o o -> = PrxcRetroce
s<-{0`\@axTAB S	S'@Mays+#C(/F2!-910`rƠ"b"uErrx 06F  No@8 AiGSzr`jo u@QRA6K. Ccdp`01Bhay n unw>эqubRnY2@AC1+>bѪr(R[co rUD)JНebook/MEU?IX1QP\2O`0ple0Vxitosa4e Fak T1ytil CTisOp7,VUclGpuW>XTamauZ_0h (L1/cL2Oc FAAROM mil|@cNmerD}ribvisBUv@ j6r g-l@yo!! 
/#j1l2n3p4 EtiqurBAsI2VehFK (ga  Woo.o3oopoi QB	Esnؠ!*J8T 5:Z$?  ProbUS%bssfactcXJ$ǔ =ll4R9eo 0poX@1'	ln
edi$l@z,
(CE| oD"F%Ad  :vH ui[r  eap. Pre#/, `WcqscpdY#auA:'p, Uu c lQas ' Ӣ,hp9tegAң
S^@vlQI$\e'vaPa)00٠>o(a) 8!@%c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuvtieej 2( s):G 300g3o B0%&~Db EaH0ּ _`ipalGirumq
 : s,pu10 qIQ{`3nh7Servof 44apoya atrib0: ID0p#@exs G
X0Y<A`sea<KHnuevL@)Df ApagE ndq9S@gOB".X		@e voc`"	k"alp3a 
0 Lstnad ;`f Rn"]e#թ&9 A*# \A<Q, (02o,GA`Ơbs (R6% Ey WciR|LLꅠB hrpinR3 SBf_ oltı9al ol` X#A!vu	j+vip.AoQ  '{Ùv?%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLock ~Suspen Blo`jԹ\Grat S 6""t mej`eO@`? :0d++-y	(BI	( !)(JrALlRt0,"D,0XৠZupizQ,.`ؔxHOre P	unP+Orojo%q>lWS9MLmedufhdem Iqdno Wak.n LAN@H DtiRePI" ACD-Q(mEřal)[Pm:\ Usi+o:b	u4@S 0S`Rrive+2dL$ t dBUSUARIOM PRINCIPAL p1 oo şgwYNman@Y p 0|. AnТ;7 y gu`'` lugpp  cAjAp~0.1)TM @dk` \)hG1
f b5@ָ]@A "Tw
mc;N	;I0orD=
`> ʧ>1DRnRsuCw  , fsm1$ !RulrSoc,L"oI  /be}"<\su 3Ҁd/a4sRcuBMbVt"B! ?p~Pdah$kosa pg`԰6Se {oenf 8d@lic1a6re!azA3. /?k 0u񡂮`#PZ230a4=inͯK nTBfixP8Z`
v\i pons2> XcY_, pip2 ESC. ΰؑalabP'Fd' 9 p,F10:̼ݲwfGAᠿ'a7T/bEspaol O R3tMultiBaNZPa DiPsi3-p ;]fb0co+Ļ(iz(@jeCch`-5 cB b a1ЇШ&SuwkrDgZipcpmeaeTer Jo C`5t x SpOvfNo`DCUs Fn/`Ts@ncIngls (EE.UU.)sbPŤ (PPmplSo}"le$B
Ғ b!Ac@ Gѐeo ModZ"y!  Bidic Ta	m&#m@Pљi#	sifQu0p{ B,ICA IR01k*WW x{BluetOoothA@
p}{Py̱hoйergsGCp-oPos 6B/P:(s+ior)p¤Ethet, NЗboaoU 1/,2/L3/Tok0RdO8OEredPr23 IpStifd ExcGlus sAM a`  .a*C0g_-N0p[0SՏo`Wr)Xh !,o	o	k	o	h	s0bpkn	@o	o	eok o	o	 o	ao	o	%MEU  o	.o	o	o	o	Ub2o	o	o	o	B8[01[ :rg". c% ]/ip$2 @c4Ќ-Cle0τ3	йk",'* q 9ODJ)o!qoh ~1bl䑄@zArran1p@By@gÓXDPХg2Ex Q찱`  ŐF12QTPAmb@TouchPad u1o N uTsсr D DM=ABIOS֧aPub  <F1=Ajuda>rP0Info@͇䰩sobPo Sf EเЈ?4ځmaDӲ$pR0
rt7padr0
3t  Ign`0airPA	4sPs '&_1nanL6a zO DBr%& pς_`#ƕ b!X_d#!P

StUd"ԅ:liz/pΉO
(I b 0؇/R Q*Ag%ԠbrB
a#utQ<n 4dcЮeal0hAlo`Oca c(SFeQMmas@g1=1iCP8$!leOpT HDD Af1)r  VR#Le Mem @PA<PJ<  4tatu UQMuPY`G]8⫨ Av8!S%,io Qa`xd; 1camppJcinzP"o?CA9 Pds`e qnr ycк'tinuar i=' SC=Ce9lAce imNK!S7, Q%ou=Maimg Uti0:psC	qqp'1da` o i  aprop@y *u@Tv#<ENTER> t5meRez[@3o.Tgut9 ^r ub:  ->
PAO = PrxiK\<-QB7ACKCExaQE06TABo$SHIFT+C%* CF2 	*:`=kSC# 9nErrrOA@Q@na0WoQp܃mRHE. CdigTGo 0o1  NPhG`,@o `qS)  s@ vizKCA A	bMev
;ÔZWotebook/C[(RWHS mGsTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/CL2૦FX a` ROM FamslY  N 3sri
RevisSvde0@Π_aJroQ La
Al!D	Ob a(34`Rt)iep	JIOeu6(]){ 7o n)oo.Oo$alS~Secunda '$ 1rcC% vf+oi"gv@!mO al  Wwalk  0eʴ g1i	a [lien!M !oc0I@Advert
: 0[Aqfo vae!djWcqP/,!i`um  gravSvuu:e)EӎA: n@Adc N S3 >B^hO!QtegiEa	c]
vl0IyI(= kT@ctez0 ejCa $,C? iN >?ý1 (Rp bo2 (A@ng!qf3 (S.M.?A.R.T.ax`=_(~.): 30<`хѡ0@CT =4Q0%?1$bucedeA,qAhostDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec   `˄6Q3sM tribߒLDp`AМexa@s w0QUUig:TDgrg`alPSLs   qL rB+4ۤiPArrfDigci	s gҐ0SAdP)PPЉxacmod!CsާB! fazA@ArEr`a,Πer dform!r3Din,PjaD0.@eHCsHfbrcagusadQerF. SZ  Q[ea 2krviob 	Iy0rqX )QT?%0,Р ur@r0fk
ad`pis0S,B,QuickLock!Suspenso Blo`qtBD #u@aSM%` mabnb1IY @k,$$al#.2P4Lsa eiSSib0RPuǟseu sEEgxigU`re*PbM0Q+ &perme@$1l p즅+maok6n LAN}e H!C#D-"ίgGP$qme:SGusua: VocË@jp4Ca0yrV2utzroDrive) t@$UUSURIOEJ@ESTREbI SC(̑:xq?Yapaz=@L. AaQ4P@<de-ЧrPisPMEEAp"@. NQv p^֦*6Ye ,Y`+b(N 6 0.bu=l*Ƨa !Hde`D.Hi``Ĉ72{s1!Ei 崧O:WAWGs1 Y
oc<w<o  supʛHf`oo,ao Dnf Caaberi
a`xx}oW Ȓ:aq(΂4` a ƀrqur< Ǹ{@FngݲX |af0W | 2|,@ p;) F `3Bor nalp`a-w
Aa ΢atႻEsubtud C~ ?@*hR)ssa޵ptA-lVJ/trW L !8Z  LembreH ՝vqMac`Pasa8
"qui_ʰse`R ESC]Ō9Ƞq3lav'f'rF10. rX`r:MrʺTPAc]D ugus Op1k: MultibayQYiNc`isi reAFpBa baЧcopld(RP ,dit$zB	Rc"zipcPriomeir"rc QtւO]v@N ؂c@aqAs F?n/CtrlIngls (E.UV`ыxS[qhp1troa8؃RءdeAcund a@h`3LPadrBiQTaPhBmemO"s;em fu0bw>zec10+CA.#RPa 0RlmWWAN) ` oo`o)BloothkAAn(a/ E omCenerga1erec-agRF2.11{5e/2o03su0Ώ3;Et&netg	O`p
/*3/CToken RingOO bo֤Idf PSb 6auaqW, XSt`s)SsCbGPdbptgemNS vl⑹CAw#[Dup;lo&	ted /	)	E/	jONOOO'as7AmO/	`kC/	cIAl0  OO/	Oj8p~AMEU/	@/	-/	G9Dф 1	/	/	/	O6[ Etapa 1:rregr2. 0% ]Oc3l 2:AcvN3:M* 
 o9ayCCm*O"(sDflex`QSc زrydapY!瘀i Powpup> Exb@ ~àF12(т? }dQZs Vara֧a N u`T@s`s DDMAFIOS`i k0@{mtukP  <F1=Ohje>JrjtQt Nytto vPbtu kP Tallenna levykkee dk@on@o" P20utFDFo2CejunsW Ohݧ mu lop6Lr W t
2
tдt7!,Tpou aurplisunvojoan ssa0Mrit^oKynytk LaItyl	
  ~usnumeP
o$-
t lykiu  '
,0)moМnu kiGa
/!(et  F.t3fsB5*tehd F7OG" t!"$j;A6)ma`*inTykalu"`A;  o9K := Ki3Gvyt OA9@p%EMu@Qk!` Ea26n D:m`-GHLi{sieli`Q`Ipk aec  7harll 110= 22R2#j2H%Jatkinjot  npp@e`=d, E?SC=Per`F=Hyvksy=Kyl;lEi CM?, Joku!L=`TY` fnouoli
mipR_ka`h$@
si#dsN <ENTER> mB7Kt
ep+.I@KEgn C/ss seuraavpU: ->Xi VLINPPIN =Zs  <-bASKELPALAUTEdhb1!ARKA+! hVAIHTO+', F2@
)_= d@!;virhtAkkua e =o9i >da.>: Rudi 01*ka c1sh ~ apHrt2Pl pU eytke`"6ko>@	siPQlaks q0rsRW` kaCt qlaaP^ TikkI)>skeytyi FnB
i(pO2nL^oh0ebaGm!|jA|}1?i@d tyypp iIn :fapllaVlisQ (L1/L2@U  ROM-SbmЂkoh	tuotespe"isar0{W]`si ?stohjab T;{	!1:"#2o L3o`M4m)J`Lta1on7;(j \oa)
 


\	\J䅸1kA'r#a- DqACu0
$#:D$ 09aT%dzb~ lpi!iEepoi Walking 0 -[1Yloso@Vaihtoe@ :uvi7! us: Tmӵ atpn9hp 3. J0lt luo p2us-  5n9,2Pirjonc!KA: L"X AYhkuV V3beFAGB08p_Cpa ᣾
GHkoa]Wi `Ӄn? 0`/  0҈?ͨ,i`%(N92R`30.M.A.R.T.Arp$@[n (min): 30-s p2y0%cL dv0 Ispysi- 4i	VgR
{fb%untq'c{K)jServomoottj
Lu0!5ÂvtuQ	k@Fttri
bti2@З0Žy@a 6UeqKxe nGpG9W Uu^EVahvu  &x P>2Ȕ	 ! PC  ޤ}A"+ 2@s@a	,-ãPAJa頴9n4-okkpDvad`5an H	InDP -e@7p$Rmysba
`ǉk1h@` ЁeT @	dE	ZEY/r i0Xj [!K unQnwby:p\vea?pahtum"b@^id FLaJ4tii l <HP PrpctToools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa hlu5qf ,V "@FPraZ&-Q,:*sekm #o$j$it)a{ad||}yh'  PP`0#pUC.7>uu	SApor IWnfrPnR%!bkHS0m 4em`dHert`hiԐakx0ʡV CD- -jl
"4[w P1FSjPZWAiot#@ebn+ De#'(stt&)pOlla. p  /@! KYTTJN= PS~SANAN,0FCN{.qa!' v`"0*@lyQkur`V0< ribj^"#t@br
(V2[I-(pY,Qpc``mwLLA 4@1^q*C OQu `U	oЩs- V4 suqIzAr?Ii,#tu Bx	8op R
@J bU7pbI r
V|}meG. Nykyfr`+r0aq~sQ{6v
t`i @S.u. Tqtէ 0$ £ihQ{eip=0uap@MY<eh?  IPa*?-p@F|_bRt0HtaY(b=c /Aojaiem qrftat. !WQsm "ftBTV@U G.2 !`ZXu1F_f}0D e@pq0pǠo#\@X2Css,aT>ESC-npsRV;n,અ'e'A> F10%Y4aa{ :	o .cVQ ll qt{Ƅys ubn MultiBaOpc&JW!lakoPiu (Ɛen/$oi>) USB@)ZipEnsimm2 AbKoa oelj }Vir}Ki eit@ְKak Y KymAai Fn/Ctrl"mAȫ+PEng 0(USMAUsPPsa!QB-Rsq@ ƖnрjDBsCPPs EVPo,t>tVakio	s2sN#Igfuu QHРDpl1E ko@QWWAN-roHLOBl]uWoth @/Fh` sV߀Rs	 s:lPmӏ
,1i0> y/2,-I, ?(ylos+OGCO6EthCerHo2E Y oeo3o9'TokX$gOohA workQc&G IlivA AGkkuT < TԁJrPѿ r0jo@libr  ad Sual`-OO OI OKblb _OO O  OsO$ O$O$ vva_ OB  O1 OMvaa nusBkPBOD OOOM bOOOOX
OI[ e`i:r
йada@n . % ] @ODPW2bl` urp p&OE-O
3
GoMOH*  j l9#`Fǐނk`qvuɃP iǰ@ (s	e  nA @:@F12:ڴiP%3tappiQkoske@ߐ 'mma K  Ei mn BIOS DMA iedo Pot Configurati5ordteur  <F1=A0> Fichier Infor` mAff age Sauvegarder sur dis!q``c Ra ,r xP 'uneA.H_DHe0als dfau`ow {du'Igno%modi Tpqu S%e l'in %p regom	\ Scurit&Z
e ss`Nd@ S"#j@`e sous te PKon.D
 priphP %J	a sE@IIDy'As
{Dr<Lockq
Smp(CD0Cr1P3r3̒  'he5 Q 1b#a <݂gre taR, 9)+5p7am''us3;),;rfrencHM =at"#Ou\ !@lonnLbceriZ sle-cqSn@psQBPs AIATA$BFoV,?mmoiric BDX C0ZZaFB_V AzcpLang4? ChoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gepu@lw=Ser, ECHAP=A lH>Accep S_0=OuiuN*#Q3V, N'impp_e``1D
=paw  UprЈzi3
s f'heM
mo!04ecle hme;nuucer@rwbri 2qhz!y <ENTREE>2nj+W	ss	sui0/fa  !/ :!-> ou BARRE ESPACE = EPBe`-$IEpreced@S<TAB`CA*'zMAJ+ix F2 =1"w-`$!S(rr`x@P<TJ Il FA%ssibPcQ7L U cs='Jprod{endp#B$P. kCoa<'401!)c5Cntв@-1 empla3ce( L' 0D SaQre@}@C'y
GJ 
s}^ccueil dP "4@ itaxsmobia``
W 
u` B!OOOF2BfCX+)a wru Fa0;cq0M\ TyQp0osBV8wDb KTa@rcaa(L1/L2) VGolu`e!gD o ROMOamR~ Numro#p	Rev`crdoerS2ItrQclavpoLA}ud ;n+/Zp$/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoOOOBV'edA Eo MT֍ :$/.   %Er4 Q!SUPc;Walking 0ᥒ81l;ig'ad`aauZC	od g al0ifAtip1SC[a=e@ptcruA ieЪvPR! /0簹r,  mz{ nroc	cY0R]A}jDL_聡v
 tro Pa
0s
TX	  _D[Rvjaˈ"`dH.On m:YfPS 0"Ӏf   +-AvaPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9yl'hA+bF  `:@˗	AsGinpnud'+,`v`t
$.ELu( pG3p 5A`ib!O: IDP0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,P@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗ&flashѫbWake On LAN\ CD-'EZpalj\:A99s!Ɇj$e Drwivea-. SsD#DDEdez "deux,&(UTILISATEURPRINCIPAL)`%H	Balor@V N>z _MA`I!!&q%lsr `/qfe4Bcelu2*QDordibf4. A  pTV	~(`sdRZ-Ho `r uDfetCu |MKQ"t"	~"a"[""qoip> >""%x 0ՑH)@zANaniq4"05#'o牌#!2/r,Bcгǻ!o!  3pi\H!! !! {e@^qQW֊a"%uelR1dX :HLk" ""opa8pE* O' jW'Acbw# ,d'orig[inIlRv`OHB2C{a B	u
vqS"فapAQy9Ipt0M倮
5dSjavsH0P~7e* ߹-$Wq=aPprsP"t Ձon: to@Tp Ra1S44PpabP}t3ۥk'
Qyj, appuy
0`  ECHAP.@@@@ OTzR'o', puiCrDF;10@TapX 2 1xCxY^u}	UZ/qFr/ana
OgҝACJiMultiBay0ulƍAph0A Q!3D,xsocv'a%(ga)OOFRz) U[8֘ USBqr
jZiprP:0 Dhi @s QsuaQCin`NSixi` S9e  Hud /NeuvCD`Perm/r(s Fn/CtrlƓ Angl|pSA) Poॱm1`s{ A`stanp6hnROd'ad`n elAtrlS' UichQ&m`
*d :i@7idoA񯁿Bidآ 0 m)mVl@1jEK!al $ޖ R o!=ril WWAN (rse0i{l)1grA`PBlooth7s0/?1   >o`$0@g`Q@Wloc <G `c@P!ZqX0b91
bP-n o;)2ooypu<	6ccumod4ogB E1t# 1a%23To=kRingo oU/IduT9-ar a[  2     h(% ll` n!Kre0/ x Ab!AF.!f*Dupk* /)///wb/// //**-///Jqgn$, /0,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Char. % ]A.`Ij 2D` GicM*n3@	Rkio.
1* T  @ @/M.$oOA$Ʊ4_Amor1cFe"5 RetardBTexpx `) Dж:a  F12tWposf[iP+Aux  PatqbAKw ucunİferts BIOSmDMA I$P zpOlr <F1=Ai> nfogQema
l0'Salva`l floppy%@AttoRiprina dnThhi@fa0``ip"Ignor`d!ed esci EP a
l'iI@Az eiBtupiczza^ sswo&e amDrato gcc3R
q7Z,,vos7xv@% IDs
@פ&gDriveLock	Pr ɣ+St =CP9 SupA=c30 gHg/o+:,i fabbr
4=i	/.nzi`[Qco
rui UC`b5<bae9E lrOpa t2;o roigidAtpaA'VP!΂,a me0VW`<HKhMiM;A>or \!Ava=t ,eLu!O l$Dim"& q6ca X ssopd geviQ gL1	vv!'#o*62wH8Premi qpsiasiesXperQVu L   k=f, ESC=Annu`,aA Et0qeo=SiSN@1T,altro#	=A bj Us"SchiavI frecc'!9i1 vocpu ap70e"_`<INVIO>  \k\'e.ipYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pB7ACKCE qc<TAB@C%o"MAIUSC+)XFa2	>-Ћ= m "AC"IErriS0D  Qut A87nppupvse@t"Vi  v@u4T|8pXJ. C{'01 N0u 0F>QQ9a0}oggiao Lk`IP'0 Q>re0
4Es"@agga%Fv0S!t`ғ  npabook"Qzespқ :\ ZҪf.atp_
2o{briu`Prf uduAA ND  Ti"+0<PSpVeloIStespp@YMis1ca(L1/L2d&dDbRO}MIamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~iI1OFk2m3n4ࡐ7w PVSTe)D
E(d)8
	2
3
4 D葭Fonda
 ,:o:EV$ Tr%OupyP!gTŒ@lliASpr|:bit 0t 1R?indirip	i] `| 'FAЎso:5X%? ?gger `|vpAhAr1e!0M/rѧ, O`1faAvi P}PiVLYXA:'mU[VA:"maconouAh(,_ IISɁQrita] N
sv@dpRDlIQOyളSe3 `cvoPga ?AFbІb iQfre?@?: Aɐ51 (Rap)62 (C?omplet"2tio (): 30>0%Q5"r6ar0䠈'hD5|:s*Щ -@
˱֤(aD୆%aerv|")LċAPLA'	rib i0go=l: ID$Ban`de@z قi S.M.A.R.T.!ޱuT0U _/wordc(nuo!i2 pDsc(Ui%L?Ibq+d`! {â"Znd ?՛O.A7Tącq^B&
Am  AVf!B;YpCr	t>J2fuDm y3CePe<B #u _tH`!1a哰.Q]ՒbdFo8!erdPКatiwEff+Jizso@in  ca2iHvEvPgaζOdesХP@Jm9Yy HP tectTools Od. ZRV2+ ickLocykspen`3B05EY moeu`s8 MM  d?#<#,pv  gra@p0'!oe -!e $C-))v!pKsm@]0x!! b	,'URa]r i lі@NR(@|ГȡV|a infraQ)p y%La_hflWashBmnQsVLANp Off#o CD-" Se($(FZPp:[@ !SRQ#3ĝ^{usanD e1*. D:AJ@T @@bҁ['UTENTEPRINCIPALE  r@.a man8fu`o. AnPV >FgP0v a%e QF@p0f>0.l@h0Au YPTk^s,bh	Q_q2L sb0R? 7reDZ\f.APR A	 Qco0%98 P+ AB.`D
 Bre,0@q  d (`<t vOH r luogo @DJ T!B'     #l$ j@IV#:,!vI</s I"I@5-"÷[tHClz s"o mP0!R/DeB  /$BH@ æUEa(  ݰaDA'a( gQ#QAi  	Potat{fa+ ueY/c dO::l}&.2rPq!u_{9㔓!.Y)uA`YEsnOP@K1'56h,mP킊ёo ESCƞM'v)dovQrְ 'n'pom!nF10.  !n!kK Wyȴ_6\%זt qIP(i 3 # OA:D0b@ $dM MiBay baN1.ggas$Z) ogCh>i USB]L$Su}kbC
ZipBP6ox ;Terz P`OЁvN% ec AС" Fn/Ctrl TIngl  (U'SA) Yi u`2O mpl 01asciЃR7pl Ua 0Ѐ࠰Pפ Bid0HCapa memqX5em$bs"F!/lD Q2'c/wNPs (WWAN){oBluetooth>Commu	Ю/ (J)Csm energ ]hW'g)1 N,*2HB$-Fa-( Ko)oek/spo Eth`etWJ V123e Token Ring p!OE3 IAkB|# "Cta L   Ao(  C02b// WD|Saoo [Kvi0Du0V /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@NzupTras   DMA BIOSup <F1=Hjlp>rkiv {Sy!~infotpзs~ S. pk%kPiguQ 3(stll_ frnl@Ppn ard Annua nd`` ochsQl``   np͑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID 
S ao
 m`
Rd-St?d frutsav 7K
 byggd 
usBi=*abrik`m+ .J
sbehrig#Gskts@rktyg 9Ko +r vP6 S`;vtiGHDD Ak_V Minnes:" @01q5Q ?@An@#B
S oVlj4rD ;cBnedtolD!v(C-j+eTry@SI fri Dg s nr? du viJPstyY=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	e	/pCa PyEt
<RETUR> oqm6
YRtt .ke,lj`SeferI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK TABf#O`KIFT+H& F2``+?|=  'fO @%Aoi?Cfel 3t gqL @ kA t h+AO` ~Dstod uGen. Felk0197 AsЌgF{P|plat  NtPhm krv3? `pbyPgm0 fly5s t6 U-Por/2 ex䚣(|0Ytidigooi2-@kl`TA UkN,q  Prr, typ
hast^hg0Cap-	rlek (L1/L2)Yd ROM,um  familjrenummn0Ddeo, rY dttNb ~pqyrQ!]H 1.$z2#3$4rbinav0̦3 (bZ)g	1[

\
Sek# xIrq.4$$@gaxr%Ex!z=ok!pvidClmissl l.s Wal}k0s - ~P f1jH Adds li7AeޡnVar! D`@/ѹ  7<neh gx"Ccuskapay /G-tRxiƱ=k b!h$2AA:1R3 K>#Rhi{wIBB?sk_yddadag

 ! Eˎ҇8A!^Ԉ  2|? ig?D܇jG즦a- 1nabb8pf@րn`X9UWk ad k$pQd (>0): 30@ncpan 2?0%bX A4Pp/]pp01vr ka&tPo:,tq	!قOk%S(x er7vo-LzBր!i @(f%ttribut: cIDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ  R4bd% pm}vlika mǄ  'InE?kan orsa@3iЈP9aHSsNyp0PO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;else- @^uQuayVqΦ >fun 0`perl^7!i HP tectTools%٩R->6-Quicka"q`telge #Lp׌mPs Hgk
	gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot.c Kж7AompHi p@1f   Pk`anFlash-@: s!Wake On  fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhsrdvd D 
e . A1 a@`r ANV>HUVUD$} ɀmaV@tt .^ P 1A "RN`ҁ< ild ̈+A
 JёRh vpyL l "C*lqJVDQ.Z +oI XqeDGga2{b2bygg7ZSY3 g 5///1dA\J8- F"Z0a`=om s-KeB
C:d@=  At;as BG@fj'F\B] ktuai`qafaanasks .dIutN^tg Ps0`AYq,vїur?sprungQb#@&MM. Vi  reko a4F	c	YrA`+,0s@t b`b . A `Kad΄37 _j &g`!b(gA|O-befosesm ih`pґVfljgns. Tr0  >ESC-rQBS֠V ƁSw㞑`u'Z'R-sedMutaGF10` cVi3a:+dshc{ nSvea ҅ܠ: N?, MiBayCr3ut opBP5vi BaG (`r` g(h!SBV G Zip-`=PW AsFjQa uttoґ NpT VxFn-/Ctrle Ǔ E lsp(USA0@bmYkd! b`n`r;msPtrorx,& hbbelorleklheo2nek0!L!BIfs@i]otrqtK (WWAN)0Bluetooth /() -v@ĔmbyeQ Aggs`haE(M-21,2Svз[,p`8'aNed Eth,& 0	3^n To!R@PN"!Unik *@?iG K  tus      Sbo Kalib@o  dp~-  eF=s alQ. O
o 

  
9
Fo  
E 
D0!m1s
Aoo
E
Hptag *o 
*( 
VC| emoo]A*5ooe 
DIOO Kood
D?[Ne _ : ;Lapr . 0% ]
kl+ar2u@j253omFjOF*  &V@1 > I*O!DgOЀU®br @4sadapП$lg rdrjQpsnabb|0 (sek. F1 ܁Bd StyrPguIOS DMAaa˰"B%en iee/  Op Teslaan Configupo`anafPvtndaardP"/  scy	Wijzig&ne Pprogramma @РSetup  z1r w܃ȂsveiBeheerswachtwooޅ
 p%X. ApOaatbOgl>$$ ID's 	gaSmbA6CP  OaB u"5P$cR%m@j+%O
GeX@gӨ gssvzie܏"Fabriek9s.ugz7@/);Vref|.s:nieuwأ8OOc  E{xt`AccuxB 4\e0P geselec Ea p`Es  zelftGa [-schijfuei Act P6vG0u` ?`I R!a/H4UBgDAcg@7n ,DP=%_
 w 9aKc!: Taala b  =r/emP 	rijsgemaak e	l=;o" /;9
8ukAZ ] {NMLg]g=S, ESC?=Annul"EDG0=!e!oJacNee fslui@Q, AQ-f =MN Hulp~pijltjkp`gebruit1Ѕd )jui`~xnukeuzk@ark^<ENTER> ind` 
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-BACKC}EVoriglɸTABb	#HIFT+%%|2+K=  ykp=t#B~fouta64k p It w_ge15 F0MЌreqatijasen. AcoFZ01b a0.i1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebook-pc/AP @.PistNOQbep*igdooh2L	MЛaf.t NmpALyp6rocessBnel3Qpp OmPЂP}e (L1/L2 Zapac?i VH߯ROM @ -s2!fSP<mm E  Hebvrgav_0ideoAkp&p;b  bpM	m	raI1b2rd3be4hisgI t}.jne C(B(XЉwM@dzQ%) 
 `D#Secuib@E.aw~~@$"Ftbd%)҆2!dHU2Lp53Hac-0-*j1Tho_adresrlafwisnd pao􁎤=LTop: zPt<ts e'ge t PSBbeЉf s d1 A:og-  /ޖ"x0zbLӄe6`NoffaG1Y\f_dقڑD `ѱ

boචgAt
wO,C'We nu  Њ"
wil?oݩ(""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30 aee&p:L;0%Qtoo `4;q{ho:5broA):]eeqx/nb!$32#kvo-IPs EI"
2`"qk:J S.M.A.R.T.-af@APP@udh "/tBlo0!  A  I-7B4kXqcr lpSX8
 Vr!a1& is bBs AYoCf#Z/k, Tm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$% uswb sqwYfur9hou
d'Hi`!  AQ`R`T`R&BеѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gsppL`b TWm E #M"g$rgΠ9bl   ~erX#W>,.o(h( o( S("7p'EAJb"f k otraakP)5w# sXbtK;?ݳ ]Qŉr p1׀frap=d  Parˊ Flash-malIr=demia LAN a	a7hӁ@r}- Cd-r gHNѽfH/oofdZGw *I  U15|de(FB`DL`#:@izow.HOOFD-WGEBRUIKERSbPՙn  p'anA S3C  Hgw!#N$]  fykkvcomp3)AosQ1|_0)t D "g+ЯqA.  ]0qp1bAutomPOc8>}X @r?:h^AA_<T< O!V)?!=NPSS!= !. Mo[i@aQnoS4H,P   n2S8`PȒ`VU nt@ TAe.b/ |@hui`,̺dЍ wwas top/!k wgeab.JԻ7[!nvloeC]kPm\Wsn 0Z^U4r`ra=8	WptorH/) "gect.  o
 s  v"N. Omun@
1]A&`3fe*p&agol8q. Au_ر_,ܥCDyAbhl  $cpӲep3ruk3<pESC- (A9 ±Di 2B'k'tyUbkn F10 @T*ZĒlu0S4d ry`V4  NePl G g MultiBayBjVzakd@\~base (иgks)re> USB-Մ cb+z`p-f E2 we$qVV@{aZes >ZÀ>Aa8NFn/Ctrl `Owiss/j @м.SStaµMcW3M?ijsappq1Ov5e 0qՓlBij V o- qPF`A/Aˡ0d`dition  G@vgp<uqVPilat`E?"V/p neVd$`> Radioj WWAN-aofoBluKet@h`/o$JrgieĠQ[Kq^.(	ba)fcEt̐ 1
2
3iTo}R/-OMobo!023 UPXuAatcuI<< q6us     S#aGekali@!1OAK"2
NeEualR\J OOCOGEZ OOO 4^B1^'OO&O H0~paA 
O$O"Lker-MUE-$J$OC$ P1q+OO+O  [alp 1O : Bo@r1. % ]@/& p[0d2knte~l/{	3	˄
fo@hl/)* Jt  ;>.C,$"q $#aXadap PҢ(sec.)pop-up bij snroC <aF12 )Kbb cuorsorytuyEasyPo-muisG1 DMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋa\܂]tsfBNɕۑ  ݒOCOF畜ďg&f 
H
gɁ  Ho'׎ 
ςɖE	ύXɏI  `AȌԂ̮܃@ea L({epA`LCǗ҃p h/do'o "X yf@\̗L/E%ID&ID: h (uN XBSA$͍eX} 0g J 23T|OH', v".eI*"%ɀ;FX
 ؖ>If
cA>oAe̒  I(f:nA%e> pCeBIvC"F@ `F _ H D%Jc9~J; ڍc R5BM NnP$߂A2%E@U`UO tB!#^sNu% .37($b74L[BR_ h=!AEsc=C8@bsAS60=͂|
  aRAg)gjq5\= 3gp] jkڂ %iA@gp>[Ez]  e >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[Back?Space] a<%[Tab!AG#[Shift]+eF2`!,,,10^nmF/[~%  !CG[  ӂ@DBCłͫ}@BDrp o 01 yNF`+@~3a
ɂACOk ~ڑKWv@&eb r?O x1X
Mp!mQ^0fGdMEU		Ȃ2^e`	］уɰޯ   ۾  xïݸ  ށiL1w/L2"OM OM̧Fٔԍ  ޵ ޼ޮ ް ۰ׂ޽ޯ ްir ޯ#2.3N4h	 pŰch3(Â)FE-3N4@(JkvJ _!nFw XcopF?$qv sPxП6!;LsV+Walk0s?A-1B/Z hɌѢʎp^`OD4x:2B>tƁAC %C颴 ׂĎhDa/ŗp쐬AFA:݉ b#}v!h F FSPl	NXWM֎~@YqZos /9@y(c  ցB	H #ċ g Oog'`,گЯ1iNp`2i׮S3p.M.A.R.T \zsԁi?j: 30Bײ8>v0% bj~!c OK z3 eB~ f{:@	{em`cQ1kT ={ǂݨUעfIFIDP|.B a"R`R AFfV!'/i `¢k@Ρ dAJg(B(a| ͤDAJhvٓB"Ǽ /  Ǘ@{R@rRVdNJǂ̂C*p4qu`@nȂaU C	 !]ţࣂ"^
YOꍇcxei!ݡ£	龂 ÉƂ `Ƣa7df!tf
`?"dHP ProtectTooslsh}lWŒǉTBq#j,.qB4УMmN*u<"T h8' k{-E`O'O H&J8-.))Tی삟D<<D%蕴` g@4`dt!~(!ċNb8v"Q ԊO GPuA0V @QlA [_ށۓfрC!N7Wake on LANh CD-Pu3(aր $} ^ V:`%A}UK (iHb'C3ye@~( |`<ݭ'	8 >B`/ZAT?iR1"i	3	'iEl K	͎W vpR@sAMS#ˊtK@@P!K/,Ɛ!eF|e\Ӆ JqA 9ߐ  <\0ۏ؊ԓ "łbͯL |nł`k)/)%)Dp˦ Z7]t.z"*FG`nGKa(o(iLn$'m@_@] ( IO) F)u
ϊ((?(9(ágDx${:#<43ɑ`ƈM3 f=ɉe^@&A)F1j 8cB  B獑BAȑO"Ocĭ(2ef̯旌8dql@ӔC౨aU"1/g'|EE[Esc] 񉟂@~elAثm T.?DriveLock t[F10 MS  y_Ԡ7>`E:	 ESxtkGb@ȓO xXioiEcUCSB ӅAXPXp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ ǲ@{`\p (USA) `Ӄ|B#foX
KAV&ds
v C\gŉ  }ZJ _ rIso@嬧 cWos%AwCY OڑͿ̧pYblNi!WAN{j%M`Bluetootg /#jְߓd `qIntel  Executi@Disable`0ԯ..1,2O,.̯.odhEthernetX& 123 gPq
AOKO3 O@$OFj) ID P7bfN P     ' ppfbpU?k ej] o \(@%*nP/h/!!8!) MEUEw o** }ooo* w5bv1 : [ds . % ]!O<2 !gOnv3		@)J*   5 %o?s'0njvSpeedStep technologyu␨ 	_Dް Ӱ px(b) 0F12QԁibyH ^E`b!q[B  eBIOS ATA DMA]k9                                                                                                                                                                                                                                                        -  ` a b c d e f gt" M  Ǝ         	 
 Ҕ     
      Κ    L    >        Р         Ш   .  / 0   3 4   5 6 j  ( )   , -   * + w  Lnp
 N % u@.   0LnLnPLn$Lnp+Ln 2Ln8Ln ?LnELn@LLnRLn`YT `@E<BB<U> FبE0`8l v x|v||p/0p7c   c 0A   = ~ 
=$$$<   DDD    O ae  i  o䔕 u  /y $n  %Ap E%w  IC&O &U    Y'N( ~ `' ^    `!)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|LnA  Ln^@  .@  bGLn@ ED U@n_.LnL@)@ I mp  ?q@TrA*rBrCsDsO*uFTuGuHTvP Ja 7 
Ln9 SeLnXdLn2bLn fLnhLn@a@P  gL+n@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
\ 	~ 
U`	
| `
`
Fa
bc*DdeDfPh(>{&$`Ln6@ `   @|
 j( 
( 
}r l05 m | }o : *ݖR  	Ln`b b 9 
 VF10 Setup Image_SETUP  P0Sq  ; T	d I*v@Jä"IP$ a|`պ 6
P&$`ԩC ؄ ٪TԫTԠ*<Rg!"$Dcz: 'ᴳ4㪴4崵4窴d鴷4D9b` : (]7  )$*U*$++$,U,$--$.\C.9 .Qhໄ 0	`9 E$HTg4jH@ ȶ#"" $" $" 
8 b@JNu@OPP 8 ;	 
@      /	
Ln&XP  b"    %    UQ' '#(!(U")R)S*T*UU+V+W,X,UY-Z-[.3WU
e/di0iU3djj4dk5kU8dl=ldmLmU\dnBndoEoUFdpMpH$IqJdrKbzLnpqIr$Js$,i]cLnU@  }| ~U}`~} U@ },~ U"`8tYu wxEҪ~*z{tW  }tl 
O5L5(@4 Q^`ypJUfԖ]` dRd];UU`
f!f 3{y5ԡ  &^ M*@ 4 U: N j@zU @_M0@ R Uh  @ @WM @ , B V t@( WM @؀}M.@ UN n  @U @S @ < ` Uj t@U @ڀ_M@ 6 UP h x@U @S @ F f U @ʀS@ B d ՚ @	WM2@ V   Ā @
@ * 6 @ L@dt @j @@ 2 J b v@ ʪ@ڀ @@ \ |  @܀
@@ \ |  @܀A@
M&@ > R d x@ @ $@ Z t  @ʀM$@ 8T V d@~U @̄ }@ M@ U( < ` @U @_M@ 0 UD f @U @ @T +@ 
  , UD@l M@ /@ @ Ur  @S@&@ \ n U @5 @(@ Ud   @S@@  , U: N@^tU @ո @T 1@ \   M@ 8@ R Ul  @ P ~ j@ڀ0@ t   @(@B@ h j  @C@ j   Ț@
5@   , > T@h @ @j ?@    $@*<F N@Tn @ @Ā j@ @K*@   $ JUD`| @U @_!M"@ > U^ p @ո @"TH@ 6 N r Ֆ@Ā#TR@ j   M@$7@ f Ք  @%TZ@ b   M@&N@ X Uv  @΀'@8@ CD V h@xR 2 @(T]@ & ( , U0@48< U@@DD\^Ubfj U@Tai @M)=@ @ U^  @S*f@ N v U @ƀM + f@ : UT h @5 ,b@ UN t  @S-l@ 4 F Uh @5 @.m@ U0 B J b@Ur @M/p@ H UZ  @M0@k@ T t  @1@@ |  A	@2@5@ ~  3l@ f R  M 4 Y@ 8 UV h z@U @S5 z@ B V Uj @ @6@^@ D T iiiiA` @& 78@ B "Uf @S 8@@ : ^ | @% 9@ T v   & :@@ > iUR z@M  ;@@ L Ub x @M<@ 0 U@ Z f@pUtx |@U @S= @ t  5 @2>@@ լ   ? &@ d v i @*@f@   A@@ @ X p @j @B@w@ , > h @ "C@@ v  Κ @.D@ j   2Ej@   F@ h   @2G@@  ̦ H@ z j  @2I@ z   4@iJ@@ U, @ n @U @ KT @ 
   U@8 UB@JZp U@ 
i@iiLRi  @@^U| @ȀZ	iMiD Ul  @SN@ b  5 @ O@ 5  Pz@ 5  Q@@ 5  R@ |   4S @   0TT@    M@$U@ n  C@Ҁ Vi2J* V r@i@iiDii iUW  2 > UD@Vp U@ SX @ d | U @ʀSY@ > ^ Uh @i Z@Ū@ Z z  Ț@[@U@ 0 N n @j 
\R@  ( D@UZ @5ڀ]@ U6 R ` f@Ռ ^T@ < f  ը@ʀ_T@@ J ~  5@&` @ %~  @U @Sa @ < H U^ p@U @Sb@ 8 J U^ r@ @ԀiiiAc@@ 8 L h |@"j@Ԁ d@@ f t  @Ԁ% 
eT@ . J l U~@΀e  f
@ D P p @ 4
g@@ U\ r  @ i@   h @ \ |  @ i@@ V   @Vj< Z RҒ  @Sk @ f   @ l@N@ $ L X f@ @րmS@ d   @n@p@ \   @
o@(@ d   @p#@ l  Ț @&q@@ j   r@Q@ \   ܚ@s@(@ ^ h | @t@ * 6 > D@LTZ b@jrJz @iU @΀u @  
"$8@@U^ @5  v@`@ J	J@f҂ U@ M@w@-@ D UZ ~ @S4x@e@   <y*@   zԀ@   
{/@   |@9@   }T@@ x   5@ ~@ D Ch z@ʁ 2& (@ D V@izDiҥ@Ҵ R@Āa @S@j@  4 UF h@zհ @(T@A@ x   U@̀ S %@ ^ p U @ЀS @ < ^ U @̀i@ *@ b l  @Ī @@<@ F Z ~ @j @@@ & H f @ Q@ P p R @i S e@ ~  Y i" U, > L@`x i @܀ v@ @ X p @j @i. < iiiiAD `@v @ʀ "T v@ R t  @ʀiU%. H ^ Ut@ @  4R F iTp U@ M@@ $ U4 R n@ @i @i@
r@ N p  @@ l  j @( @ h ~  j@Ā@ < f  @D@ J , > iNj| @i @@ l   @@ b t  @ @}@ r j  @@ `   @@@ l   
@&@ P v  @榀@ L j t @j @@ < H  kV@ifi@iv ҎJ @ƀi@
ii i "J ~@ U 8 V Ux@ M@@@ R Ur  @S@ l  M  @ \ Ք  @(T@    S @ |  M  @ x U  @S@ \  *	i @Ҁ	i@ F ipDiҐi @iT@S @ < V U @ЀS$N@ h  U @ҀS@@ J n U @̀2 R h @@@ P ^ x @ ( @ p z  @j @ @ f   @ʀ @@ `  j @ ڪ@ P t  j@΀2 _@    I@@ f  U@ M@@@ < UL l @5  @ UP p  @M@ R Ux  @ЀiiiA @ > \ x @ @ J h  @Ҧ@ X ~  @؀@ P j  j @@@ ^ v  @@@  U2 N j@U @ @ T@  $@<UX @؀S@@ h  M  @ j |  ʀL @ R Uf  @S, @ |  U @ʀM  @ < UX d z@5 $@@ ~   T@ v   M@ @ d Ւ  @T@ ~   M@ @ l ՘  @6T@@ ~   M@ @ \   Ȁښ ȀL@ d   @ت @@@   $ ,@4<D ^@fn~ @ @
H@@ , HUp @ @ N 	r @@ d   @ Q̀@ i\  5@@@ Ո   T@    S@ v  M @@ v U  @SҀd@ H h C   Ģ@ڀ2@F @ N iDiҖ @΀4@Ԁ@ U& B f z@U @S" ;@ h  U @΀S @ 8 \ Uv @ A׀E@ B n  @ܦ!@ 8 N l @ 
ـ@ iUB T b@U @ i> X jT i M@@@ H Up  @ڀM$ ;@ ^ U  @S.݀@ ~  Q i S
 @ : T Uh t@ղ @T@@ T r  մ@؀"T@3@ n   @iiii4@@ UB \ v @բ WM*@ J ^ Uz @S  @ N n  A% @
 /@  U8 R j@|Ւ @T @ : X  U@ S2@ ^ t U @U @Ȁ @T@ r   M@@ r ը  @
(:@ B R iUz @̀M"@  U  @K@@ * UL f@U @S@@ z  M @@ d Ֆ  @"T O@    M@"@ v Վ  @T@ l   M@0q@  5  \@ Uv   @i 6 L j@ؤ i h i   i(08 >@FTi^ h@vU @րi
 
@{@ i  i<b ~@Ih@ j i դ@T X@ J l  ղ@ր@ T  Ҩ@Ԁ@ f   @0 ]@    A@    @ x   @@a@ J b R @C 
@
@@ i2*i:@TiiDiii i R@  < R@U\fx @}  ]@ U4 F l @]U@ 0 V j U@ }@
]&@ 8 A^ @ @]@@ ^ h z @Ԛ @ 2 @@ F T Z ~@ @]*@ D V z @ @]@ B l@     @ J f  @ڦ@ p R   @	]U@ , : Z Ur@ @
]U"@ 8 N j U@ 5@@@ : iiiAD`z J@ @S@ %2 V Ul @5 @
@"@ R%R j@zU @ր} ]@ U, < L b@U @@*@ J d v @ ,@ , < J X@bhl v@j +@ R   Ҧ@  (@ ^ ~  @^]6 UN ~@M "$@ z U  @Ԁ5  3@ UD \ r z@U @_]6@ ` Ն  @T7@ < j  5@@(@ U^   @_
]>@ n ՜  @"Ԁ6@   T@A@ f   S 6@ : j  @j @@@ X h v ֩J@S @ Ȫ@Ҁ F@
" , UD b@x 
Ҡ@$̀@J_]$@ 8 R n @Ҙj @ M@ b   Ԛ@$!+@ x   @ O"@-@   &#E@   *$@   2% C@   6&.@   :'@P@  ܦ  ([@ \   @@BD@Vhx Њ@2)@@ 6 ^ niiQDii @5*@"@ a. H R@Zp @.+]P@    ,@j@ P l j @ - `@ 8 T l @ $.@4@ `   @/f@ : T v @j 0@Jj@ D L @| К@1 6@ \ x  @Ț2m@ f   @ 3@ r j  @4 p@    2)5@C@   U@Ԁ S6y@ > P UZ f@մ @7T@F@ X z  ն@Ԁ8T{@ d   @iiiiA@9@ < T lR @" S:L@ T  Ք @ހ;TN@ b   @< , T r@ ( $=@@ H d  @ؚ >@ ` p  @ @ܪ @? @ x   @ @ l@ j   4A@    QB @ Z p@զ <C@s@   DT@l@   0 F UT@d   RE@   M F@@  5  $G <@ ~   HT@ x   SI@ \  5 @J@ r   KT@A@ j   SL @ \   @i M@@ B Z * @؀  M@N@l@   U* 4 >@FUPZ d@lU @5 O @ ( 
6N$@^ t5@؀P @ R r i@Q@@ b ~  @ԚR @ D ^  @ S@@ z   ,T@@  ަ U @  Ȧ  V @ z   ,W@    X@ 2 T r @ҀC@Y@ < j 2U @b iZi
@<FTJ h@nʊ M@4 @[@ p   @\@ H R p @ ]@ 8 L l @j @^ o@ R v  @Ȁ  _@@ Z   @Ҁ @.` @ \ t  @ؚa@ D P V ~@j b x@ X z  @c@ H   @0d@    
e@@ , > N b@v @Κ f @ : V r @j g@@ H h  
@iiiiA
hT @ L j  դ@iT@ J p  @؀jT@@ h   jԀ
k@ : P p * @i5 l@@ UF `  @ mT @ h ~  U@ @M5 @n@ Ul   @So@@ ^  M p@ H Un \ h@ji@ q B@ n   r@ j x  @j @sƪ@ " 8 J x@ 0t@@    u@ j    v@ ^   @$w@    x 3@ t   y ;@ j   z@    V@{  ,iU. <@ZU hU @ M |T@@    U&@<FP U^@@%@
i@}ú@ n  @~T\@ > d  U@ S@ X r Ռ @րwOM@H@  M $@6@  M 8 @  S"@   SN@   S*3@   M G@ ` v  @Cښ 2@ P i3@ i1Di3@ _M: N V@rx @ ƚ@ @ H j  @Қ?@ > N j z@ @2A" O@ UT v  @Ѐ ~[WM 2 N Ut@ @΄@{ @ @ > P n @f&]@~@|@ 6 Z  @$@.@     c@ R j  @ J@ X ~`MT  @T S@ & 2 J UZ@|D  @ Tj@ @ X p @AbM Ԁ iiiAA @
@ 8 NJ d @" @TB@ H b | )@% @Z@ D  X x  @Ȁi  TH@ 6 R l U@ @@֏WM2 D R Uj@v{x<KgMU @Sx@ V | ը @T@a@ t   i؀T }@ P ^  5@ @ U> L Z j@}zlM U@ @T@ f   5@r@ UT d  @M
u@ b Ռ  @T@@ H x  @*^j    =@ X   ښ@s@ XT id r@U @  JM
 @   DtWM& T .U6> F@NUVn z@Ւ @KL@h@ ޜn@iUJ, \  @Ҁ @ 0 X  @ @ L j  @̀<@@   z@  Ʀ @ p   @    @ nj    Ҫ@ 2 R p J@C@M@ @ T2h@t ҺihDi@
*@  $ * aU*D L@U^v @ƀ@ d   @@ 8 X l @j @
@ F j  j@ڀ(@ v |  @܀@ P ^  @ @
 @ 6 Z x @ª @ @ p  j @ @ `   Ě@@@ f   @"Q@ H R Ub@r U@Ѐ S@ N l U @M @ ^ Uz  @΀5 ii	A :@Zr j@ "U" F \ ~@U @@ %` t @F @@ D p @Ҵ @ @ 8 T ~ @j @Q@ F b r @ T@i @M@@ h Պ  @T@ t   Ā@ > j |@ @@)@ T   @  @ V f x @ @7T@@ : ^  ղ@Ԁ0T@'@ |   S
@@ h  5 @.@@ Վ   T @ n   S@@ d  M 
@@ X 5  @ UF j  @j |s @ J X d ʀkv @ @z@j@ @@ B* ` h n@
ҕ| ҮĀ " @ r   ! @^ 
@@ J j  @К@@ T r  @ꦀԀ@ ^   @@@ l   @@ T x  @ ׀@ p j  @CU> L Z pD L2JV  iDi @A H N@p @j @ z@ p   Ȧ@ _@ T f x @j @
J*@ < t  ո T@ B ^ r U@ M@" @ V Ud  @5 
@ U: N j @U @S  v@  > Ud r@5 @ @ U   @M @ t լ  @T @ 6 @ H UV@bn~ U@ U@̀ S#@ 0 B UT f@|U @ƀ
  J@ iiiA(@@Zx @j "U: b  @5ր@@ f  %@ҴA% %,R P %p@U @S @ N b Uz @5 @@ @ UP n | @U @Uʀ @M@@ ` Uz  @.c@  ڦ @ : b t @j @&)@ h   @@ F T d x@ @ @i@ ( nj  @>b2@ ΀ @ Վ   .To@     h@ j  @4@ l  Ā&d@ n@   7@    @
@ " >:* V@|U@ U@ S@@   U $@6BUJ V@r @
J @ 
Ҁ X  @Ȁ W@ @ f  @ښ }@ b   @ঀ @ b j  @@ n   @ @M@ z    m,@ X   @m0@ N d  @^mC U* B T@h|2@ iiңCi"@DJX r@x$PnPLn / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй `s# hNfP u	fX@  h aZY[Xg&ۅF ;9   Ã tfPfS
u	p  bf[f}XRg&u-g&
pAgf&A"fV  Vf	=t@/g&ƳV9g&PESWVfW&O*f%Vg&D= $ <vD# D| u:t+;'_^
QRfU
}0t[R>tKutE$fu
0t0t	dp:  f]ZYPSR uIW)_rIW&u5qVt tFu
:ǅU. %+~'<t< 0
l[ZHZ"P`0  ;p t; tށ t
t4d> ud:>u	d:uހuu o@ & u
( 3 uo u_X!
j0od:rq 2fSQV3Ҡuyy  :ut ffKfy+-Ƒ3  49fnP'D%g$ЊFg	Yu xQYr14"Wu'vx8Y x, x Y^Yf[PR 
 Z #R;;=b;a>Ҳ;!? <SDD"!US
F.>6A OfŰCEf`Cf2FRC|xfWAaaAfG E f~QD$
pD$ f|u6_^Y5OfQfZVffbXtf8Њt 	dWD 0 rfP%A\2YP	Vu uff0SF?t!hXcgvu}\>t]6f뿢wup0f7:f^ffKV  ^#Q ߱ ux @>tgߊT% us]S f!%#$hf,"%@ f@%90nQRV&>	>W&N N BU@߾&V&mfDf% ffDs7 ^Z`!u^.0f 4sp2(2{É4^^nBn@& D5t(Pf sf
  WXfff8[3`6'E82`D1~R Ih 0PPVVVVZ|ZVZS `So<1 			;/acZhpcR}cxZ4Q2p(`C F%fQfRVuu/7 1M3y o P  	 6=h䍚1( Q 2(  f3߹ f`dTt ^ Q ?ހZp8׀@0XFfC@u$G#w>k5ys>H
 "o
d
.Wu)@1?HVՅ`,VuZ苆FFVu FQ$Nu$G^fAɢpxx P^"D	%ÉD	f:-f ʃ@v@ s<v PfUK?fЂLf Rf$f6f> f	>fBf ,ff]Xo t `-̀Qyԁf𔓋_`y RӃf;3 Zaptރ> t5u A*@@!v0pU
0x@@בRV"T ;f;tff * F?#B/$ q gfQERڀ>  fù f1C;t)gf[+ C kC@F]`*iKk~ e1>SRPVp ^Aah3 ;u; p;[b7P7VXf.0X  &
d & 
 R #  DH ! 
 6P ё)d % ]#t@w ,{Xd !"$hB "80)
 W.g Pph	<
 0$,L	
 E2)Pq PP  (# P4!  u	  @
p	 p 8J8  ) p@: >  *J p  % R R!	RV2
X "


 @&V(xiQ)	(w.`+)dS )(b+"P( D: ,2	*0, LU(($!Tp'#	'$	#$	Q *	&
&
"
q,

F1(AhBK4CO''A,A 
/	
#	&h$
$
A5
Ip:0(|:!TMt:BJN'y'dQ$> 1#BuU#!,)$3 +\+F'Ya:Fq=A;( G0$G
"w\D#GV9/' ANdCN)$
$Qa!q>Q !Hr>PRBSRAh9B3e$bNL'UnqM#uY@uQl!%Ai
$
$y(Jcp(dpyt@
 >\c8Kss'tsvQ:y$y!!4F;	(AD@a䈣!vlxW'QJ#&$q3$n+$3	q//  @i@v
 v $a {#
 `"9	  aZ izazT
 Ľ" 	 !=,map 	 h}w ЀO 
PRfWfg&f_Z!Rغ Pý ZPðV Q|  	`о@  :] 66 r zq!B !;P  )aab/`(9T9@@PQR5S>9|9 UWRQSPV rw6t ur6ffWRfP0 eXhafZf_P>6u6uaPS7 pu6@666U/66D[XF f sftf] P[YZ_]e È66أQ 6 uPu j0fd!u!6! ȃ uddfdm԰  >P6Sd ddSP (66ufUg&t=` T=f]t,>@u%ttt t	tfN tƀÿ)r@ualn)s
 1Qh 6*Ou߰Fkވ .!u]$*
_VێeS tOrt*ـ? D`*f ׷f0T fffXs "qy#uptLe6 ` 6 uYf3f` fe6Wpe*&68fw*fF*2t*܊e&6fX^fY[f`um'n!(o6  =["  Āu(g&pv6z]  t(]9=faSQVWU&u tu **i]_^Y[LS-120ZIP 250PSQRV:*1:2:22PKp
y<w
m z
\5	6*K<s!hEfP u	fX@  h rg;<tV< uWQ5;f g&:D= uFfG(+;**X!X  JAZY]f`uu 6Qu66666v0 RW.h

N} tE2B*/_Z[M-Sys   DiskOnKey 1 #߅aBu u @  f<x fP f<"%|= 2rޒ 0w"1s sU3IH t gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&c,f_o PA	% rLT*f<?7(QRRVcF5Mome}9@**0;; t0ht3t{@ u u#P-30MAf?LfHPN N 
1fXuײU?D0 @0B0B0B0B0G05F6F 	 **&3FPqRrco?3W1>#>;!2>
?_YhMGPnh`p& 4  h4< QSW+ 1s!$?
u$[         Ұ,X @xjY rTB@!tkn@  i|X  tց   j` 	bhoddfHff@ftnPJf&jh\ufj6.f ` ff@fP  @f%% @@@f  z6f?Af=A&  `  fAVfA`Df=%t 5t;@3tZ~0tZ}DfX$0g]A   AI ASf@ t@[|P A"sƑ tDf  f qA A<Af>@ u ` _oD  2ft.tn@P +rf6u$@@s11 >ګ@@!R0[@'r"b"q0 f!?1VC@f,S	  tX	*riH'	"	0 %9 uf-%tq00 P3  J 	P@|tpa '	uPΐXL  rf, 
 pQDtP؊*ǷA@6%f>
AgGf	gOgG]`db>?t"3	0	5
[`6@#Du	%&tnf6
A?f	f AfIng^g~5W!
*t4h ~0		0	  FFhiJ<t
 &wN5q*pu
 'X*؃ CN&NA&ףNqN&ibL6%@( @f (f 42a3uf@W  bf+`сawSgff9@u gF9@u 9@u
gF9AtgNXfFAUzr=БC=@rxiGsVfS'`c(gF'	@g^f g0O G0gFu V* /e*eP`d&b&g&g&G
G
 d0Gd*PGg&Gg&G
ް G 3giFp@q	f AkG^ @ZPfV c?sf@mdf p^fIf!@&@@+@(@  @ < t@  ;vȉ@qv  f@ư
Bqygf{gG p ,gG
	qGfu"a ?Hf%f[E@ !gG!&@@ tbk!f#p@fNcn `_O3B'PR7з[fS
f3ΰ5 !f$fӃ\Q?fp#{-  !Si|y P9ґtU ````a%`b	`c	0]	0^	  q
		 
	 						
 0hfWQf-`1Yf_`QD=f6D=6JKD
$>6%
ĈD
6r% >w6bASZes*K6ZrI`d
QHr7R@|= USBSug&|= t t
U	_ 	`_6T 6ӡ p arQgr C0Yj %y P`zK`2P>6t QXrIt2QfF`AdY.rϟSf1fM^!WސA@KH\
؀eܛ\bJ
pŷrA
x @
`
L!?
0
"osTq
aWa'"CS# iD=q8p*W.?4o3'`fT2_' 7/oZ(Z
2(
_7
_=%t9I R$RS$2Q	@ ?P?@RP2 3* ~h *Ou ᠅ T=
XS<(fnT= & y#j666 r}fPQtA3`>6=6p+` pta^Vu6 6 +.Pf.6hpOPpYfX`PI|{G<6 fa9?,B3U+=*/G/%?QfPfph`1@YfXY"gN0\ؐJ?;G7/O?sc?`:MoDA/BA<e=vS$l=38%rpq6Ot} Ot Ot6D$
ƈDFP!r r
9rY׹ߖ /p%tFPtt=tT= t2:t+u:u hNodty(u~(rt{^@O=@tO=tO=`	tO= ?Oh)6`oXaPSV68dtd}ӠroӾ68DtD$PQJKPhӠd^[XSQ*KO	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6T!
*  	b_.>  
   VVo       2нS[U[PV&VZ!%ru
w>V *:  > X * tVVV>VVu Vް'PSCrV4%VVVVÓQ	z`P$`
3ۊ `fV&CWjVDW3 VpVSu@t	Vu<[^@pVuV "`bVu^Pd4 u:uqS1u^Vuʀ?u[^pqq?fU >uuS>JW>uzҊ&GWut(
ߠVuZ VVVh[4ͩ@vf]AA`Ft߀>V{V r1FVw%0rN "u6Ȉ0EV h6bdhEYuY!)Z J`RȀQ	%胢pot1FVch[WIWT"rIW&uVuJWfPSQзVf3fY[fRVff3 Wf3"WrfZ2F E *  <FuHW3t	 Dt<Hut2ZtZ >Ȁ$u tPaX]EW Y7BW uB<Ft<Tt<et<t<t<Rw*<Ir&HW
2@&tZ>GW`Z4<qurYiVW@ξ HtAQ Zft(PǴ:FWOu 
  gXfCYPqq q9~ w2FWkYⷠEWDt&DW8r >t}aRw
$_^t0%VHWV Vf? t<CpR<?tSQLذ&Y[߀ u
l/qpJ@I - n Oig8 w  `  8th
   0  Jp 	 	 	 
		 
							
 

 > fWQf04aQY`f D5 p6666sR (p6zľ^D
$&o6
ĈD
π 1Ts f}g&|5 EBr`jr  a`]mm	 	n	M]`UR		`:^H\
|n6
\nse bJ^QoaJ^}0@" cc͐Ă/r`܏͏Ј-̈́&pW3
	#rgqWtX0Y"@ f#a=ʴj(rjdu6bDq='ac#a#apfqh6	 Yv		6xvF
 T `ȹ !sJ%|=t'd%"y:ur?rpq!(~rg2oQV]L	;t	PAŦ:^=Y^A ]\0   0    |RrE d    n  A` P 00 3`  
& Aa % N 	%
0 #
ک*!
 
3`@& <a` @@ 
b
	 CF
? ?a	  " d q a	!? % %@%
R +3F	 
+ (E+
"3$ 4̂  C8$+(3+- E-(C -0294- (`(E  E3 .c+!  0
 @/9F. 7'GC@<6A6D
!: 7' "J",A !E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaXCJ UK8'(X4AIc  WI Rjklmm
nCopyright (c) 2001 Intel Corporationf`@ f.A<t<t$<tc<tK<tSjf&jvn sfj   uh   uRRfADf380=ISGuђ s
g]j~!t f6j	gftcRa tpt5Htn @u  u u0 ߰# 2  P f%ᘅ3 
f>AfkDt	u)fA;Awuf@ffhit=ff"Q-tѣ
0|fs
B  ңv@#tzs210!<ug


7	u\	Q	'&h/ś_AKf6
A	g~ u%S F A s@[%;u!,?f=4R0	ff4	)ffp	Q(f>	f@f[aSfSfQfRfV*sWvn15 uBT7 tApN@76g88fI4g^f3f@70n@7f^fZfYf[fP"Vf@f@f=`Bt"f=Ё &f= 0//f=0 3f=@+=t8t34 , 't"#
ttfyn0 rfFP0fXURf.  fXr  	 ܳQfufQD8@M TR2@(2Of2f0cBZ{RO>V\3hԚ1( Q s2(Qf3`_{fbDf6E  Z<gtatG@}]_ToK<u	ϨupWJ$< t<0t_$ RwHP?y"PWT%jb_uPlAP#,RfWPR;Arfc%1f f>=	f!Effg8u#>_444
f@[Jf_,,PSt{xw&]21=`Q1Yr;f.;rt3UufrA<mpf|ffm foPtP= v	 +v:P,P}rf   :rfP  6r1|Ã t}L;fՉ ǰǋ;Ptr} Q.rB肿
rrf u0`b h62 ÑS~a:
r~ffqp	f`f"0~ffROMIfMAGE@;uq Wt#g0 ~yKPQ (߹J 2 ofG f_ZYXug&wago&GwG0  "2/t"_t  V {  cu'[0i&[w j3
G94g&GGfԣ fCf-+ӵ00pD;gf7   h쀀1"`YW, `П.V.`B@~
>t1aë  	!  !  q  c  " ;;w  @nQRVQS ް u u蜫?g& 粰 u&quup!(fug&P!	u*yxyx>xi06xp` ;}1	ߦu	P!"Y 窯>up$3۰	%1uF &
@'uu ˷   ?鹮!uP&C ZwPuxwtVt	uTR1=ud:u< u2d> u	a (!u yufufdxd= I^Z`Xg&8!u	g&g DtF@sPVS ~u| hN3c[^XSRVvuWH^_+;»$11ZUf`(ӢLǲ&O6]Д r0 #3#[  56؆8 PxxxxxxxpSV.&tvxfW^0sQ P7W> yxSRȰWu<v
y,y@@̈x 7uG 7r )`́@%:S	ͧ1 y y":xw/x襧
/	c twdh
3	xrgo&AEtx}rxdr"xʦKr
 JthE	vcsZhtĳx{?=2oȧ13
B	uaCU$ࢿuTXp Z#,轨[$$_;tR ?Z{R JU  ?{P&ab{pZ& &Fd`R< u}12R1RgtXwr),u)RG`SQr9R'f$8t܋Yqtr$VO㰆HAr(<Fr{(!sq^trp@۴ppq90`~ f8 f܀?g' a`  @ FFBZ`b j nb PQfWfVcwUUP*`P U hX-  p' ,G~ .;}t3P_YXhŕ s  $Һ0 {	 ] 'J4 "`".u2(.} }s0 9paW
s+fUgg& suf3Ɋfe`ѯt0fYpVfWg<t,fUgRw r!8tfGp^fZPQ$@a@8tPAvUvP8F X PS±&%p #؎[XPSⱡ%a@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                f`8P%,:#%j  t4 %  ع ;uPXف      t(  Xt
 %@  Pé t u>  uƿ   q  tB @ J3p
%tNtGf3 f ff3u@ fgf&fff#f  
f~*jB XfafPSQR.a#؁ Ӂ~~@t%s	%PQ#~Y3#P1a ff
 pq'uf%fZY[fXC!
hQ I'uڳf d`ux̱
  k  `5  t ehFIfP u	fX@  h $  Gog0 dt`Kua߀
  %߿Yt
&,Q_ ¬+fp*f#"$~+ 5 q 0f t+&@%_
 ZAff ' *8+3-Pu
  +qfސ/ZYfPS4~ T ThX4,"+h4f fg&##R %5  -E{4	-Y# -30,@8@uRtt@t
1g ,, 
U,3P b/a/u@%+h$'( !!  ,-./01289 `E      x `a 3 6ſBŹRRF 9$WaaYPG3""
P][2tN]	 =aÜ`>@ l>l!GA lBla6~$?C o! G @ A  B  $0sϊF  ؎Xn "X0GBnnnJF$a %JF0wP  )< tq ̢P ̠̡  VޢW    llB  ؿ lBB@A_ l@  Ղ  @ lTпUN!z&1'߿H߿N /!% 
@  
F_Fn  	n	n	n	n	n	n	nnn 
 TU ta  @CdQ̀`  3nnGC q
p	p.nA
` nV 5Wq aPfWԁ4g&g&f_\'/>                    [T '0 
8	ɀ$ tH
C
?T 9	p݊'
A' u B9	K SR~p@B u$Z[SfQWP qXgg_fY[ Q
`f~gfWPSf3f3ɿ;	f0<  P<
f; X tDt:	[Xf_ZfY<fPf0fX,fV>fVf PJE gߤf^! fU^	V					:		:		^		f	W		_fWf	_}
g&' f @؀:WV!  tO
ъ#F%"A$[%hT
Q 
sY
^_W>uDsķ

`t$ X3S+[C vS3ۀ> tݰt+t:+tC  [0t<w>t8tз6 
 
G  S r t, JP "+++{
Xt~or"}5PfP	RA+rA aѯ	 fXy
t贯$3蟤虤P	4Á@ׯt1-w&㋇+._trwRaot0
p6<< t
=:@ 0  +р>@uct+aÉ  Hq

p@I濡J@؃y@P2}J
s3y@si  Y 11F0]mI:u;pu;thP<<-!  ww
210`r &	&o

v >2  22x-GfSpWf]2ptE p  %p ?[hx; 'Q W C$3ހ  G4g&tC0f&fft.wf3A MA `  u1 2U dFP h*]  '  luuh7<aǔ@$#4bAl  `aR@p  ZPQu4 pyKqb hYR0Ru h%Z	
2
~B.&g t#.gw&'r T
.;t&*0 0rRVhvvtDhs^xhr(hus*r2, f^fZf` ;2 >rb2 < U7rTrhfa蟴f`Y2yf@`Pf3// p~fX!7"" Ϭh{Qf`/)
4/O
^ "	 	+ R"	
/	(	A&!_!!!>p!hBt'h4SItwG	Prff
00&˃u Э 2f{t F<t0$.rf@Ӑ3dtfQVW 0 o_^Y}Tf㐑DWf} ft
t%Sqˠygf5rSQ?U P^Yf[WSQRWVhpY?r=ыt
 t
uu	  tt uʋ^_ZY`	nјfQf:Eb3:EF c6W p 2:> u6 GHt\o hk/T3ҬϋhoeB^_f,f
XK̈́
>
2

VT>T2@OHp
Nt.
Or2eƱ3 3/ 35COo/ / /  WO3`<RwS2.[@ T LC؊<؊fQhʐ_4ufYۉۉ;aEf3ɋP/No`pXQް&G     &Wft ffBf;Pg~fwwm~rtwRtpff@hp3QgfY tghoeAX0Y[0U%>aPSphy)Wh`>2f[W  i    ݉`    f6E,f=HIBMC,@ u_Ff!  g.9u
g.RRFfkF "Sf= @t1pu  ø PFQ f' a Ѐ| a!!NuFgf~fsVf  t
fP#ffA1fƝygfY#F$V f;s	f
	 _ fV2~(Ff )@ f+s
0	@Nf;sfȢF@	rf@f qg&g&fFfGg5`^N &Vf fA=uTA$<ufIg:!
bg
@tT	?f@f  /<"   &<"<"
À> t t 
8s t 
tpV$<
v
ط   tǀ>4" t $
؞ hi$ u
d tP{ ;ѿXO(  ^щhŹn%

>d`
@

#
 ð藱u 4"&5" 4"5">5" u
8wp[D &aWxb)G@f`Y Dfޣ HfCLfPfxHb 8 fU@@Չ@@PPh >ft	@pL	f%p @ ~&Gc<t<t<!MvPS$<wr .$¢ #û  t 6   ;%` Ja Y mc!t	&  [ C,%fbP$dPbPPNf%fE,Nf1 
N0Ψ0r$|t  tM`Dff3fEU  fPӸpfnp<*ɑ_<w  a fXff
phEu
ðG	  ߜ  P"ЊĳP XuiBD[bϐS! ulh ϴ [D2P =X	@D2~uP2Dˀa	c$

vuM<X[XQp)a3؀a
@2t P@<KrKX PR6'Z@> .6' /BZ s  ""
ZP F좃'' Jq vJ_úQ R ((
PB/X
	ذ4ۋZQSW 08_[s(((((((/ / j 3;CKT^|3=GQ[f h S[z<ENWa~r8<AFJc| (à@ PP !a_ؑ,:%  3` P }ȳ  aeYrO0~6333  
@|f 1f_fg)MUfFFR>`}NT>!t"ffvfXfDޑ fpfufT0f M "  0I F@ +fr T  l
 
S1H HP)9  hv M ( 9`HQW0
y ;{J_P+z M崟|m"AϺ~ʺðrMgh6]@3
! ك 
j"N"a7,% O   % b.. T p2-3-6"w2 $-="B! 3% ++
,,,2aO-j"݈ ?-N 8+,% 0q0.&,up  w
   1  TI,7f`3_bt5tf1C,I,fxK ſxx- falCTNI C,@060f(07fbЉ3W0t#-p>`#-#-2s k2TPcUV<2p2 PG $i //[.  ѿ>(0N^]?;2 	V?s  ti8u%th48u<r7,`
-! `Ǩ@uC`
 k
 `)@ ߀eqp0yx\.S rӢ..}Ѓ߀rV5.t C}rPnuM_hοرrJOJhRdL2f.?fPD0f.q AYhż?P !H r`. Yb J ohUu`@~h0.0𮠀ݡE
03!4=+t
3NO+t3GNO`UN000&N 0_쪺P aT0SR 0``a@y  ᭋ$fӃ0[2QXpffXfX*fXaheh=p; 'Q W P (uuu&gq q  ߿r[;  S	ހS@^F`xP UPG͛ZdPvP1F X PSòȌ&1&1&1[XPS1112.20v20U&v2v2\ST]Tpȟ0tR  wPa qU xX?Kϐ2 S8rddrS<dr
d2Ρt# St螮貰PҸp3cЧ蚰Àf & uQP؊&c!2@n t+  y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  /                                                                                                                                                                                                                                                               d!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( /(     ښ U   ς  g `g ; h }  Za  ;p    / :hք 
;! 
mjބ<5# :S          P          %X%H _&                                                                                    `*} ` PzQT@    U@ U	@
 U
@P UX@Yhi Uj@klm n@o { U@    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@ߦ  h  fUf&paf&o>` 6a  !X[ &SP`\@ /'a&&@r
f3f僰gf祸 }f3fh ^@@p h &ïީf`f1fffeWf   % ŀ-ff0M00!0)ffXf9ffaf 
  fUi@] 0 m uq  ,f5q f~^PeP Q   ͪAp  A` e׃fama  !6>eуp Ń ՃPك"` pew T	
e} fe&:` b "jeɃffefAffgd:ugdfepf3 ~gCTʰ "8fF3ۊde3 
tdg	  p)O @ 
pezu{xu.G_RT=C u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_YǨ dooooǸoc׎dXf`ffP fSIMWuUf}g0f[ Qbr6fc;w(h,UfKfap p`p f&?SECUtC)fuffQpR? Phk\g&XfGذV S 
u0'@f%6X!u(xg&_-f$8IaztKt#ɃGt<S{f
 fTjT^VY&VYtV:KftT.fe>fhXO RL@p=yp8%= ]	 =
=ufH/FFF@ kYt3!ffw	!z"n& t
fWf>_f_r2&% m$g&P fg&	r SfQfR` ނ !fGtt2t~tyf    2o fAf,P t;fr@ Q^u 3f rFf;r>1-: t, f ur%ArQYQ	 f_fZfYf[   t}% 
tR`A
A!:0._2 r&7"

rlr9SV9rP#j   t
ff;t;0
 + t WD@@D*^fZY@ =Kh^1$hr; k'Q W rwp	߾	K u ff!` B
fffLp 


ghshNR0S}
`fPhumgfX
%3H# 
t3 v0)Q%pMhy\\G!V< t6<t1ށ3:u"FWj*:+;) .fY (7@ w.	AE_S 
{fUfp>t	~--


f+ f
$f]^$*###ׂ -gpXvPK? Cn@u%fs  '  
?Pj$$$$$YcXW@UqGr1s:'sf0Xt&{Xz5A5:
x




Fz?VhhPh^fRg&hnr>8\s2g&5	t fZfVfRQP >0yffPpafWf!>  _3˹?A؝FffZ f 
߄
@],Y`i^RfVQS>f"1 O9Bt#hH_Q   7___[Yfi`V/#W	
R 0uBШ  RQ2Tr+hW_ 
 ` 
j m0_WVSQ  2ۊbF(+ؾ8u `&
dY[^_fPWQtPpX"0sY_fXP}֜TY*`ʡf`f&`1a&r&6&P&E` X g+
v
`.f&r&&faõr!Brw !PX
   PfhE|(TD X810?u쨀t݁	<u 1<u õr$Rr Cx&@&32!rr]rN a`z]7da(SvxБQ`ؾ"" QYoaVP `&Կ` Ob _
y'U P"S""F"&&	a bR ~ ZQRr3'H2't2`{`2ٵ?(t"5tDTZY{a~r#uS-ER-Y03?Ёٸ q4 L f & &EZP &r豂r8t32```.&EO h?,w.tGS؀K1?u|[&M.	2tð$D 	#h 15 >1WM 04}fRgw2ɟ_ZfZr pv~w@5 &E
, #!}	A	2ahk
t%00`P 0,S%0xA  Da`6(  ƿ  ` aV魆ī^`W  3 _r- +˸ fD@ED;{ B@<B O B<`<2rru辽O0W2&*G_	 7&*,u&}Zu&E0_[DA跼P`QF>0 0t<OtY	B<tmH777rPBBLѯ: r1 r,q h/do!SQk
peat)u$<Pty+fWKuҴhqiB`UqQrj @qj"yjuBanYoof٨	V o^W m h?TtD=/ί==rN|UtGV Pk4^t1Vh_5f^D  D" ; Z x     0Nm =$
Pdu	q 42~Xҏ	 i HQȃIQذJQ2Ð3' ~SQRfRBP' .Z7a   7a${t2+``B *0h菜h |Ed/Ψ#/(*f(fYHpRiOl`Sf>QPH_u(DЇ/&fP  [-Wr(qQP-roSfP>Wp(>fo1t  tf40Z@p f  fffq2g&g
`fKfRg` gre hջr s1VGhݟZ,
-텓f_fYf[pA r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/fpbBfg&rf`b˷0  Z[XfWKu
 f   > Àff` ? t] t
t@  ?f?
 :  B@(! _ 0f` ; 6frv`gGwf3 f[PfcfPr:p> ff0;w!fVg&f^ufF=tf!Q. $pft Qg'&$9<&m=f=ATADtlf q:&Ǉ  p s  S3a `b[b 1 辁 0چ3ɊȰ	{j qUFWP3J XU .߀>9   ub >u `	`	]7pϬ$l0Aޑ$(C_AR.1S+`r[P<ం@05CPQ>V(ι c r\d`V1PAtCV>r-t`w r uҊ1 r
-`u`dt[Q rdItf s?`A$P3fց@SRNr&r!ww3҆r r	9 8fPRcq`areeQbfOQ{ qPQq	s9
d pr	rqUV>R5f   dgfY{uwR Z }h`YkzC Z&&&`.P\ P " Yp `2p",u   P R밍

Z@u
Sذ* o rQ(`( ]PS o I 1'9R]R  Ur>XDC	 4P>otS t33ېJ*bjR
t#4 c ttQÈ  PQRWV+3"a^_Z$"#Ϡ[~1$G<uo$V 4^W {_ "  !( 	
R
q0tJ@y
g&/1q;_-r 蒹rt;APR(X0aJ2u߀ RVа$rN ;rCr<,	r32Wt rr;wҀ0sڋ^ZW
   е0u
˾   
u P f! [uf _2 J33o22t@@ 0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_..o..{..6 .R.D{@VPCE n w+"$C #g&P hpOM|Pf_Y]fXX@1U ø8	1˸wpP#<	r="    Cਸ zCJ C *HكIڄ#R
Nf1r f+fMh?vf-Ef-ffqA PAMSuff>r^7
UwS0V0)Pظ`X>ɳ f|	!4 "f#JIWVfߺ rY E 0fP < u⟪rRf#R fBR?^ bc
hTtq.rBؾ@
E<u@
P謁
`K]f멀QR`ϟ_"a@`#j uL$<tD"ЎQ^r&=t&} tV" &GF^YՃ"
\ؾ$Ӿ 	 hy
s!
"


Z

P 
=h@ '( g  Rغ0 t@Z\e b	fge
	
PQWfV3 h]t-3u̸ag&?f>\d Ff^_Y.>fUf.6Ff]@f]** End SetActiveDisplays: \ 0R$nt5P)㋗Nd_;t  __um ZހӸg t}uPQ2tN
͋nYP  v@t`P< tH O
i p
R 1P3t0	p $ D pU!
ֿ "P0n1QtR	g19jP~0jP$ jjċ؀ jXjXj@'W蚣kjQ( *n``b tQqjP _i@eVEQRPSa[X3@{a B"c
`r1 j oK f`~eUKOu$kr
u.2*q	,r$p&` E&]p@ _ffa {.A4t
1/g???SQ/"S~fWU]f!W_0ð 1ԓ pӰ rH r0Htp	SfQWBHYftu XAC_fYfxq@f`fqf ;v2wf fa|k_<_P`gf2gawӶut! SP܀d@%sX	Ŵit 	gf0
 @ʊ631Jt/O    v ؍`6Iat`>O2HaEOrQѰ_   
0hu$$t$
$$a$h1hs`9t4>2t,z u<τa>̐  Ȑ `  W@ D ` d h            a @  b  ` HPX \  HT3L4׈ 50@
@
<                   ~ `     14    PXYhijklmno 	
`
 #                 x ,89:4NNOyP OhhXJŵmW  2RRӯ #gf&fߐ f y*Tf0	@g&OZ	(0xsySfgBufRVW f Q  !Q  A!!ȑf%ÿf3f3f.2fffu_^fZx_f"Q ء f' Ŀ×
f0PR,5 % PSVWfQs:AN u ufufpv @uf  fY_^[XQf!ʺff}
1ffC@ foОf  q&4'rpf_Yq"OB 3%%bR5   @Q9 < h <u2<
 c                                                               UPRPRVFZX0RR30ZO                              S Ѝߋh3 3/ 3ֲЦ!V׻0I 7=2޻2
n3פo3ӝ"c>%<D,лTуѲgƵ33)3b3+33Z3**ц3hھz߿#	Uz6<
|ϔbf.wuN!u<u<|w2.9)df}&@#Q`< t
 u
ff
uf 7
Ssr&rk&[fq;xV4t? u _[?fP_ኼ_`0P #t tu6#`@" a"ffhr;_ 'Q W s	7>.hdr^0fA@fP R6fAgqs}Uwdr
a$huzPszGOuhfuRP XZIPr KK	@ h	~#! " ts@ӧt1fYôpR<(^sZqf^SQR<_s&ZY[!q.\;
sߏ,q[b<=à0AP1ABSOLUTEPPPE"g& tf0fg&tAX0_f^  af`ϫ4t$4p$Ū4r .<t
../ NA NfapSRVfpor$@tU.  /?tA
 NUNgh^Z3ب40h_EÀ> t;s%JfsM貿PWY'PS}فl pف_?_0BӿB3 $ `%>&~%	 
  3  t!  { ! @f@u#2h2>t0RW0_r p蓻P"R8/fZR0fP&T ffXy@0 !+q+
  fh` B B B!B0B1B2B B BaPfW R!J  g&?t"g&Gbg&Gbu @8 uf   κ( 
uf_#` [!3X ,7j * : , 22RVQ]Q]Z]X,a%*A Ëw34 CZ g& DA4 Fd+
 <`/1#`1h:܏e:f`1 fL2f3f% pQ
 0p!P!q  f
 `0XX! Kf`!ffgff%P@@@ gfofP +
 `C  fnA"aCu<wb+$o<w	+ Ef46W> tU'uR uI )sB<t>{t9u2wYr-2r!\S  Jtg&Gm!P _  '<yItZg tK#Yr Ȼ s0 /G <u$
@/OP 2.CPqIG"?r0HSItt蔌52 `	
   SQVȾq@ 8t"8tr2^ҀEAt,&
uߢ>ut
$rsEpt> u.~/M"t$	&
3s@ ÀY
t|^ph	>!]
hyxWmtep0?GQ Kolu:1HtCƠ ƐP  M p$  
uֿ{`a>@Я`
	 >t RLt_0pPpU'uUg *r$- t> uBu
 Vi  (r"1bt~ "[JbSQPX5tV
r0..VGFtBv0D0.ȟr//6~Ft_6tP rBT36msRu%
 "E;6 vU56cC$Vtzu Tطc:ݨtb,;sW;sQaSu	Iu"
uPFޑ"
23Sg/  àޢ/t urԁ* /)P5tXSfW@0`
+Eth_8؊f_[?گ߀3fRsg]Pxr
Ä3# ЊPS|{hf1 f rmf# uOf3\f   tQ}t0z#%9tf!!@it1f wf'00jf.ߗfEfy0ٰ f[fYA! 
jx
@*sCfW z_ u8  U*t  t	2fp f_΀ 
u   <Z_u_?Cr`C /<Bzp@ h?jf`y`=pz+ 5fɸpa$
	t`cptf@
@pW%NeƇaґ ҵ @ "`_ú}d u"vJ  3  t ?	Qf@ @ #9 ЮÅyi` %p &!#> ȂaqA~!-f# %Lq8c$B'Q  f 30Q'
f~"S	b"> w''p
f1fϋ s!=qfYfUĳ ;SS؁مi f@V~#t6$p%f&ȿ ff Ut33u^`fqSR3һX3t@s8rS`^p hB 
 * 4 )T0	a0fjҹ&?$
 PT؃2q2B0 RfZ,.028   +,h B0.Idh֎
*v^>}sǪg0&H7
0*\רfօ|i
`Et  1&Ruw  ix ?
w| qmm PZ>t aP :ffX:fc7fpl oЙsvǁ  j ` 
a|!u 33 k#BS3g!-ff<f
 
# f V%\qhaUp`o*0@k  k k`20!Ysf28f. JthaWC)cJ1_PVQ = u5
B= Pi= ,
q7`pH8!CsVq$8C\f 9t} 13@q&`a]) 1a]Pa Q   ,A048 Na;\#W`5 A G!@h_fP 	  h H`!P|3w Pf4XaxKY 6I[7Vfo@2 0qL7t2 t,nNf^P _"DPAPc4Ruc'1SS'1'Y0U @hZ@ga&'1`,   ڢki1~` غ   nBnnntnJFn aS ` 3ێ7!C &?!Cu3ۏR .;Zohʐ:ðP9t2XRVEp &994>&N.pu	 uQyԿ
 ^ktԻt +t8QWP3 PhX@.X=X@uX_EYoPTAqup$ qA!Pa.$> u
Pe
@Xuð6C @B T A3gfg tH u.g :fpg&ffs}| ffߋgfffT6.<(.&gf;BfsD?P
hh!t@
WBDBfR詷`6c6Uo z u

7(@kރuXO0f?qpRJf  oڃ tANp Mp pjXh	qaRÃ`t%tgP&g!gg7f`Rft9tg>E @ t_9g5C}ggfRVf),g>E %g> !P(^d`g
ز
.  ofRؾ"Q2` t1?YPQ stu
QPYXP k` ؠu 
X`:؎Rf切u Zlfa n  @(00	jEf upǑ D   &Et"D  $D{(0n`ف&tp΀O 4>2@"Q
g&t
~ 0HL &}u?p ?u8&= r1	&
I_$B}r P
` ¿肐 m  m wQam p's 0P] ar * $OQa	 & aO# $$<@t"hXRĔKucKK|ުKuף`.>#st&3r	&*!rA%;aô`prr X ? trC0}q;w1#!8Q909$a0){fRQSj[YfZt'1 [ t x
| pGZa?r0PJ
ADȁmG> fH  h4ruf>訴rfy̸ fRذXr<fffHff#f+ִ f;wf3`Sлc
uff+f
   t7uY $>p u0Xf9b_{ ɐq1!t2)tP#s t>h Ǡd> tp @9du@qQ/_SiQYY~P` < 8Br2<t.t)$u
$&r./#t%n.t2:3tiG Q !S}uu>P& 2tk_(mdXhy*h j                                                              3OQq d           %  p                                                                      G  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  WP       VBT             $VBT ALVISO         d 0   0                   BIOS_DATA_BLOCK ~    d1284Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    04/29/2004                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ m              
  8 (  8 L 0    ( 1 ? Q c u 
 
 
 
 
 
 
 
 m `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                      @   H `   H  b                                               =                       $    (     
 
                                                                                                                                                                   !0 R`SI-1362-A   p          @                                P                                `                                                                                                  M X <
  X<
 2	 	Z e-  	
                                                                                          	                                                                                                                                                                                              <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                                           0H d @A &06      0* Q 0@0p      /xQ&@X      H?@0b2@@      ( 6     6     6    6     (              @ @ @ @ ,@ @ @ @ ,   (  s ) 	(		
	(	



(B
T

^
(



(



( 2
<(j|
(
(
(HZ
d(
(
(&
8
B
(p


(


(
*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                         ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 艉s f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3ދf  f   f戰fS?f[f   f   3f   f  戰g&fFfCg戰닰 撰fPfSfQf   fQf3یff
!  (fYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 ߇fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf 5Jfsf Jfsf c1Jfsf MGJfsf 7]Jfsf !sJfsf Jfsf 7Jfsf Jfsf 3	Jfsf 	Jfsf 
Jfsf F
f   tKfsf c
n&Kfsf xX<Kfsf 
BnnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf ef   Kfsf F<|Kfsf  6Kfsf j
Lfsf Lfsf -Lfsf x=Lfsf =f   tVLfsf fLfsf of   tLfsf hLfsf Lfsf SLfsf Lfsf &f   uLfsf "Lfsf Lfsf Y&Mfsf Mfsf )'(Mfsf L'8Mfsf 'f   NMfsf <wbMfsf 4 f%"f   t
fawf  Mfsf {ta$f  Mfsf ;ff  Mfsf Df  Mfsf    Iuf  Nfsf f fsff   f   f   PNfsf tff Ag&ufNfsf &r8u:Nfsf &u$f3f   u
ffuf   tf fsf   Nfsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  tOfsf $f  Ofsf idf  Ofsf rf  Ofsf 6   Iu f fsf   ffuf
Pfsf %tf   ),Pfsf $8uf   uffuf fsff   ftLtPfsf $f   t$<t)<t/Pfsf $ufffff   uf fsff   ft(
Pfsf 8$<t<tfffff   uf fsf   t8f   ftFQfsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tuu0f   Rfsf $t<tff @   f 5Rfsf "2  +OS._Rfsf "<  ff   f.:w .DRfsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2uff   f
.f   2f   f   ft/Sfsf !< t8stff   uffff fs2uff   f
.f   2f   ft(%Tfsf  < t8stff   uff ff fs2uff   f
.f   2f   ft(Tfsf  < t8stff   uffff fsf   f    ft'Tfsf $ $t<s
f   <tff   ufff fsf   ftTUfsf uff   uf fs2uff   f
.f   2f   ft($Ufsf m< t8stff   uf?fff fsfffsf fsf 2uff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%f   t.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfu2.<u f   t2kf   uff   uWfsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   3Xfsf <|f`Agf&   f    f    f   rXfsf f    f    3f   ftXfsf UfftXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   tYfsf Qtf˰Yfsf 5<	rIаZfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8  f Lgf&fftf  f~fsffHfuff Lgf&f   ftf@l]fsf f Lgf&fftf  f   tf  f  f   tf  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	^fsf fBgf&^fsf  ^fsf  uff%   f
fHf   t
.f@Cg&uff%   f
fHf   t
.fCg&fKgf&I_fsf Ff fs侳uff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsuff%   f
fHf   t vfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}.fDg&(σ.fDg&.DfDg&f3vf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`|f~fsfffsf fsf f Ef   .@ fffsf fsf yfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_cfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
fHf   tfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H׀f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fi  ifffsf fsf f x.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfu  f Lgf&f   tfu  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1sf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   sfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  tfsf ,$f  ufsf f fs<f fsfffsf fsf  fӇ.ufH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  fsf Ű < urf   6fsf $<  <t<t
<t xfNgf&f   uf   fsf $p2<uB >tHH3f  fsf fƳ 
f  ͂fsf *Ż  f  fsf Ű < uHf   fsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ufsf ų
f  ofsf Ļ  f  fsf $
f  fsf Rf  fsf ^$w<u|f   ׃fsf B<|2f  fsf (f  fsf 0f  #fsf $f  =fsf f  Sfsf ĳ

f  mfsf Àf  fsf qÀf  fsf Xf~fsf fs            f   ff   2fff   ff3N.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2XXXX          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < fmf%f  $f$
tWppqtHffupppppqήfڮfupppppqf f  gffLggf^gfnf    f
   "4f4Ufupppppqg- f],ffmff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = ufyf f%df %  fAHfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰fذf䎊ffff掺<uf if*  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`fn  (fz  對 f    < tg                                	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft vugf&>tgf&6f٢ &fU ~f^Y[fXPSRfVӃ tAӰ Ӄ% g&ƅ    f  \g&  	uf^Z[XPSRfVӃ tAӰ Ӄ% g&ƅ    f  g&  	uf^Z[XPSR     Z[XSR  C vZ[PSRRZZ[XÃ<t  I  .  8PRt)t<ZXfPfSQfRV%2  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $fKfS f	SfWfff]X t fffS f	SfWf  ffKf_f^fZY[fXRfŋӃf3ӃZfPSQ  fӋA vY[fXf` f;.t
f.   $C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   < ϴ f;  ɴg&"  @v@ g&  s ϴf;  ɴ> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         戰䈽j戰䈽'f3Vf=밳fI@fS찴f_*fiWfuf f%"ff齧sffHff ff5ff f
   `"	f   f3f30f  0f+^fUf   f f    0f  f f   0	 f%"ftff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.`f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pft   @ Uus } M
  >}rfg  ׁ ( r  .i|V>Mfft<>3ffxfxrrfxftf>t wft   >ffx%fxנ3fxftf>t trf>t wft   >/>m>dff   fF>=נ,>#ס>	ff | > ffx'fxנr$fxftf>t trf>t wѰ|ft    } >urd>u]R%	 D>u=ע~/>u(fװ >|t  ׃>	r  Kl	s 撰 XBȔȮ(DUɮɻ'fSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRfp@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRfp@
 > uB ;yM@t=s(xغz,y0@u sz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v  f  ٴG 
f  ѴwfaPSQVP̋L	;t	 ` ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6鴻js>t fafWf   g&D= g&D= f_`r r8 a`fP  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`fδf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>ι gf&D5 gf&fff>fXYsufa`f`  & gF
$
gF
f`  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva "  f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfJ  ?   f^  +   fr     f  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Zq`qjqnqfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP(R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                0 ] IPS㋇ӣӋӣ[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[   q f  f  fPQgf0& YfXf    gf~gfNgfVgfßջfPfSfQfW<w f._
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >~tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fpp   rg<uf   ⃸   Yf[fS>~tf r	f  r>PfSfUUgf*gUfUUgf[Xgfp   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf>p tfptf`f  f3f3f3f  gfffCgftftfafp   fpuQYfVfSfQf
!  f   fx7rfxfYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{ffkffd    2ø     B @ EG
03/10/06DHTϟ  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        