#!/bin/sh

if [ "`id -nu`" != "root" ]; then
	echo
        echo "ERROR: This script must be executed as the 'root' superuser."
        exit 1
fi

echo
echo "HP CGESM Utilities Uninstallation"
echo
echo "Press N (Enter) to exit uninstallation.  Press (Enter) to continue."
echo

read x
if [ "$x" = "n" -o "$x" = "N" ]; then
	exit 1
fi

# find utils and docs
x="`rpm -qa | grep _Interconnect_Switch_`"
if [ $? != 0 ]; then
	echo
	echo No Interconnect Switch packages are installed.
	echo
	exit 0
fi

while [ "$y" = "" ]; do
	echo 
	echo Enter the number of the package to uninstall.
	echo "Enter multiple numbers separated by spaces (spacebar)."
	echo

	n=1
	for i in $x ; do
		echo "$n		$i"
		n=`expr $n + 1`
	done

	echo
	read y

	if [ "$y" != "" ]; then
		for j in $y ; do
			expr 1 + $j > /dev/null 2>&1
			if [ $? != 0 ]; then
				echo Enter listed numeric digits only.
				y=
				break
			fi

			if [ $j -lt 1 -o $j -ge $n ]; then
				echo Enter listed numeric digits only.
				y=
				break
			fi
		done
	fi
done

ret=0
for j in $y ; do
	n=1
	for i in $x ; do
		if [ $n = $j ]; then
			break
		fi
		n=`expr $n + 1`
	done

	rpm -e $i
	u=$?

	rpm -q $i > /dev/null 2>&1
	if [ $? = 0 -o $u != 0 ]; then
		echo $i uninstallation failed.
		ret=1
	fi

	echo $i uninstallation succeeded.
done

exit $ret
