#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for nc/tc 42000 HP Notebook System BIOS (68DTH)  - Linux-Based"
BIOS_VERSION="F.0C"
FILENAME="sp33124.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o45  {]3   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    8DTV   BIN  UL44  s4    8DTA   BIN  Wq55  -o4    8DTU   BIN  9q55  n4    68DTH   BIN  gr55  TM4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  .   c             F  /    I  
     &  o  A  )    %  z
  T
  
      U      y      n      n          "    	          ;  "  "  "  "  
"     }   g   '       %  %  )$  $  #  #   u
 u
 u
)  )  )  )  )  U)  8)   u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u

u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u
#C  C  B  B  B  H  H  }H  =F  ,F  E  E  E  Vu
&u
u
u
u
u
u
xu
Nu
0u
u
u
u
u
u
u
pu
Ru
4u
 uS  2S  !S  S  S   `  `  `  `  `  c  nd  d    	u
2u
,u
u
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3Ðj薓ː
  F  F~ F F^9 uvfv')}fvfv)~h	h jMRP詎Vtj
fvvPƏ
h	h jN~RP|Vtj
fvvP虏
 Ð3f>^  tf6^ *f>  tf6 j b荇  V  h j胐h jxh jmh  h jah ~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ÄF^v&v&8 uNV  *=p t -d jHH|f6B jRPjjzRP莈jjRP~jZRPnjJRP^j:RPNj	*RP>j
RP.j
RPjRPj
RPjaT-r - @- (FF9F}-^v&&?-t^F&&?/uF V]=sjxtRP與ja,]tjyURPij`a>V   h	h hn fvxvuj fh  ! hq
h@蝌f6vfh   hq
h@`f| f6vDefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRP蜆j`.]\fh  j X^ ` ^ ujzMRPajX`s>R  t!G  \t( !  9  =  A  E  I jJj1fjއ   ujzRP煃j_
t(b       ؎f&fjxRP蝅j_>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uaH>T  u	>L   >L   >\ u3T Ht	HtHt8j uwjJ9ulj?j.>\ u?T Ht
HtHtHtIjj MȐj?u+jRP跄jT HHtH
>T  t7>N  t0f|A  h|h|j
> tjJRP^>J  t
j H^vt  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uF'~ tfj fj /F   =HtkI-
 -!- - - 
tFf> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj lCd   F >J  t1@Kt B= M- K- '-M- 0- )fjTD>J  tzj "\^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j)}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFPff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPfvFPBfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;Fvfv_WFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPVFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP5
k3ÐSfv
 ÐT  Vfh  P FPcf|K  Fhh|h|jh> t3^ÐFPzBFVh	h FP΁RPhTzh	h fv貁RPhd 8zfvhd y ^Ð  F@Fq
|"~FFhh|h|j辀}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ u*u%f6vfh  f6^ +^= uv&G
 tf6v[놐f6v[?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP荁
fh   vfh`  j f6^ @v>  WV	~ľ" f~ th	h FPw~qFPu3^_h	h hd [vxvtj ff-   fPf6vy
f6vjFPy
f6v|j ff-    fPf6vky
f6vjFPx
f6v{~ uo~|ij ff-  fPf6v)y
uLf6vjFPx
f6v{F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXFPhVf6vX ^_Ð~ fh  h	h hd Yvxvcfp    	prff9psTf6vfh  f6^ wY= Yv&G
 Lfh   f6pfh  `f6^ 
*t"f6v Xfh  `^^_Ðfh   vfh`  j f6^ 
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP~
<F> tjJj1j f6 <~jh	h(      RP}
6 hq
h@     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjk\RPpv  fh  ! hq
h@{j3RPXF  @ +FHuF F^
&@VxR&*RhRj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRPujJ`RPtu3ø VxR&RhRjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hRj
VjRPUFF*;s6PjRPTF*PuVxR&
R뫐VxR&
RhRj
Uj|9RPMrj7u,jCRP1rjD
RP!r>J  thhd jRPYTÐ  [@7fh  hht"jMRPqjNRPqj{RPqfh  UujEF jWRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pu>X X}jKRPh	h> >SjLRPh	hD (S>J  SÐt~ h	h2 RF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPfRj F*PujRPh	hH hhd jRP)Rj[RPjZRPh	hN 	RÐ  4+fh UhhCt"jMURPiojNERPYoj{3RPGofh  ujEF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*PjRPQjF*Pu>X X}jKRPh	h> PjLnRPh	hD P>J  Ð9t~ F 8VxR&
RhRj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RP"PjF*PujRPh	hH hhd j uRPOj[eRPjZ[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ uj#RPMh	hV j!RP{MF*  F vu3%.t(t~ th	hV FPfj"h	hb FPfj#RPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$ARPL0F~  F ohRj
MF  hRj mMFj$;F~VxR& R܊F*PjRPCLf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%{RPK~ u~ tjj[RPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*PjRP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFVxR&
R
hRj
iKF hRj WKFj N*;~VxR& RՐVxR&
RhRj
K~ ujRPJh	hn j!}RPIF*  F u3t~ th	hn FP1cj"h	hz FPcj#$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j$RP)I:EF phRj
IF  hRj IFj$T;F~VxR& R܊F*PjORPHf6^ FP:FF~s#~ t~ uVwR&
Rt~ tFPFPj%RPaH~ u~ tjjRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !j-ރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0,܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvj_ڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7@كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w0؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0D҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &psуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh@htth@hِ = t= ut у>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShAhR*F*PʃuFL| j hAhR jʃ]FUtKjʃhq
hd j hjlfj hG=thAhREtÐhq
hhq
h~&Ð&ÐU~ u hq
hjhHhq
hjh7F  F~ ujFÐF Df>   F{ j h6Chfh  ˃uF  FuF~  ~1 F  Fff   ffffN*+;|;sF*@N*1 Sh6Ch`>  u)ff   ffffN*+ = utj F*Pʃq>X X<fj hF~4F 1 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*1 j h6Ch[>  u+ff   ffffN*+ = uFj F*PɃ2~ fj hF#  fh  Ƀhq
hd fh  uɃt"hq
hhq
h[t"fj hEfj hn#=uhCht!h6Chtjfj hU~ u hq
hjh.hq
hjhF  F~ ujFÐF Df>   F{ j hPFhfh ȃuF  FquF~  ~m1 F  Fff   ffffN*+;|;sF*@N*1 ShPFhF>  u)ff   ffffN*+ = utjF*Pǃq>X X<fj hF~4F 1 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*1 j hPFhEjF*Pƃh~  5fj hF?  fh ƃhq
hd fh ƃt"hq
hhq
hwt"fj hEfj hn?=uh"Fh9t!hPFh(tfj hÃ>J  tj h tt t   1 ~ ujރFÐF Dj ԃud j h*Ih$tF F~s3c F*1 j h*Ih$FPuFA j h*Ih$he>\ utTtMtFj t:h"Fhefj hn=th*Ih$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j h>JhBFPuF<A j h>JhBh/또>\ ut>t7j hj<fj h=th>JhBtÐ  Z1 ~ uj	݃FÐj҃uÐF DTd j h
Kh`tF F~s3Tj F*1 Zj h
Kh`FPuFZA j h
Kh`h/c>\ utTtMtFj1t:h"Fh%fj hn=th
Kh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPHtFPhq
hՃ~ th	hHh	hTFP3h	h FPUFVu3vPfh0  FPLfv4FPhq
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPгtFPhq
hȃ~ th	h`h	hlFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhq
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..bf^gef[UfS..bf^gef[UfS..bf^gfeff[UPfS..bf^Fgef[XUPfS..bf^Fgef[XUfPfS..bf^fFgfef[fX                           UfPS^tf3ffb  f.c.c "  u  $" u [fX 0!<s3P˿q
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666͜P.dظ WeP.dۚi  y>	uXP 
 Pq
 5! %Td!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.{twdydydyH{ wH{H{H{H{TywwH{H{tH{wH{H{wH{H{tRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }(}>}r}}}}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bq
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3q
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![t#%!u
sʻ 

FV]U컱 .8tK
I	]PPR.d؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUq
ء
F
F]XSQRq
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.dۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH&6		VW_^s+_;uX6	&t	;u؅t؅^&t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]          q
              4.68  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) zE  + , B  . / ^H  \ ] I a b I e f J h i K '  q
 `  q
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d						(		b														
	*
	J
	^
	r
	
	
	
	
	
	
	,		B	^		.			n			:	X	r							,
	Z
	
	
	
	
		(	8	                                  E    F    B l bq
      C    D    B l q
      G    H    B l q
      K    L    B l q
      M    N    B l q
      Q    R l q
      P    O n q
      I    J    R l (q
      -     1    + o Fq
      V     S n dq
      *    1    ( o |q
      T    U     W   
X   
S m q
      Z    [    Y l q
      0     1    . o q
      _    ^ m  q
      c     1    a o q
      g     1    e o 6q
      j     1    h o Tq
      q    r    s    t     u     p l rq
               ^e                           _C_FILE_INFO=                                                         q
               
	
\ \                                  [q
  [q
                                                                                                                                                                                                                                                                                                                                                                                                                                             *q
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          @f@f@f@f@f@f@f               (((((                  H                                                                                                                                        "                                                     SdSdSd                  mq
q
q
q
q
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ABSOLUTEU)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '     P      POSTv9  / N  a  N 	 |
 . Ѓ .
  L . + a .   8 v9 9 M9 ݫ    5| ~ }  ! " 31# P$ 2% & т' V( ) *	+ , - ?. 7>/ a0 1 62  3 ^4 I5 6 7 p8 |9 2:  ; 2< =  3> ? b5@ 2A bB bC 2D ߂E F $}G H I A.J aK L .M N 9O .P Q pR 1S 1T 2U dV W ژX /Y@Z 
[ |\ a] Y^ N_ d` a b ac f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h@O [X /<t
PW f&E1_X  PRWfQ
u5p 	(t'SBff  u߿ h8ufY_ZXSQW< s1
2
 ht3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfVЎ.< t ~.FuN._^fZf[fXQ	
8@
		! &
%c
> h43hp    t  Ãu
.-u9u/bG RP~VFy` u tBk@.9tމ^~u (t/ tO^6
5
u^XfQW~
 
 #_fP8
VA/r#Lt<
tw
u!ο 	*ظ_^p	9!QfWfV*`#)6S
F f[tҋ3ff^ff[f`K.fa9 H7fVWUkH t  f h2%3  fAh6 P{'Q2C7 hFC(2rg&>Ut2g&FP3EXYP-t7X\P%f3E
X f	]_f^Df`Sfff ? hR?-f;r[G W4
__S W_E rgN
gFr
G<< \faAEWfgf&Ffؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3f	ffY_EU3tg^5NC]" h fV   !8]`QRWV^NV vq6Q3LJYtKʫM^_Z6QP0 F8 YfWV3ff$ 5eLfPS.  .-F-  f-gin^K9N~u^ ]k.  e
 ifTTVRdQRB
|ۀR2ۊ~fon: `Bt'uf{ f.-ftff.@# D
uF8Fuf_ZEfX^JVR.>گ-s$0t	Q.k6-.-N

ZIHaPq2
F0-7FPPy2P
N~ t4vf2	f{	f 0>FNNI.?-$ UfVWQhnrrLS  rD3k:f @ Q   gf  P?^ =
k`X H]0:Q]6  
fvhU~uF F 7O3p]_YCh^| r rD(gf 
  #ƐPfRS 𒔾N&t^fv tNhCHtDs ʆ hU/ 3hkRBFv} ~&#3
Pf~fݥYf   @
>tq  tgfNg A	~t{-F  ΁ 33
[P3yhkF t~y2h#Ff3ҲZwhҬFFf;Fu-043  J
 ,QAu@(.;-s00~ ˁ ;u
t`3t@Ѵ `4^rf(  _^ZY WQ3.>-2 .0.ƅ2 ` P@hX.- `$S 3.-hC ОXZNZpwFk{@"~ 
N~f.4=6@.832ɠJ0[t9QL\u4.B4f<tش/f5$< F.
 
1^V@~r0F F`! FBu~w
`M~f1ĹQ/ t
fNu?
ffs NF^PSR 4P*Q:
Vq4F$<u&0VF ># ~$wp` :O.phz?<uz^`V@g-@{..-g-^V0&0
9t@ރ-2ۿx@2
E/^s[ 65^5#7u(:Nt@ нu=P:
t3S9)΁6um8N0;_^#Vuhh]`g^cy
S ^ $p|u5um0j !0 `*-fpF(3Fq(SF~^^h<֊FտF 0af
AF f^Vf1u? @QVpZ fz ufZ^Y_oэ@fߋN记 Nw tFt"fX9FvAFH;F`0Zpz`QI> A\f9Fv9fH]!:FF8F{@ uE-!:fI"<`<Af+ ;NsG .@b^3(tf+fD;<
wi
;f0Q~uK_~ tE2pv?.0N	-C@թ	fSVR`~nqTE[1D:KffArRff~Ѐ`˿2fT&f;w
2Z2fPRf@(t#f3رfoP-^3ZfffNN 8ss_4
twu+%
u	atf `"]^&^Z`Wf@/P^~ݲ2I$^B="8uA.ffFՋoN_Q;WV`vAFfs"~VӲ`R(Al4m
 s~VRfQ{Fu C kv@kFf:bf$$@w:@_frDf` w;=< u    r,.gp$<u r~ s@nvFfYZ4^VW @fqԊ~ԕTd
t"ttH׃&`,Yvlpv }d6SV0޾ T3; t	 r^[VW@k T`#A['S^@8*pt@;?v7!dtk~@Пt 1;FtFk^% Bk^ߊ Ta 3҃  V3k`
C*䊁"T;FuR,3}0t7
t-k	9	# a
@S
+FHu
4uGrvFvVBs0c;JVW΂߅tS5[NuVp 3ҋp_&t@|@1-4FR>)R{lH88HȠmCHP9뷋_A-7Z &0Vʐ~1\02N~ tKv m09Fqy.Q\$ 
fPQ3I FfPqf
0M SQh-	 \P,Q23QR.- tf.&-.`C.8-tãѸ6
S@0t^`,F  FψFZFVf "e _ pqkFڀЙN tFt'fځЊҊzҊtъWmюЗdЎba2f>1	7 / 'S # ъF8F~   N&RU" S$S&T(,@1!fсuАNrts SQ9Fv G" 3%zjf. ?Ϳ  a׋N0F830
t
F%  .` c>&e%e~ tf7iex` u
 v@act#3t#Ëȁ ~wu !d|x  v t'f#pffp
=rc%.6 H                            /                                                                                                                                                                                                                         @       o  PQRa&hk@ $`Ȱ߲ hDrZYXSQWa$a$a  h4B hM >5_Y[2揺 TCA6  @A Q C@}@ @;uYð!?$p h)Ē
f`  踖fa..4h htfPfWf_fXø hFBf@g&gf&f4 f&'B `RlXߑ10t&2hkUKc   &  Q6 $@ ؀  >N&}uu hU3d U
  % MY߸WN`s-$$@#h<~ff
`' Àtf%af5hst h>r(,Ⱥ: @p 3ȰSv* @uSh+h̄ XC P+
-	
` ܹ 
h20!vû,!! f4%  02HT12X21-220LTN121XJ-L03 4IAXG02C41LTDEC5V:        d1 o1 {P 1 1
 P f`O  313ۃOu+"21q73Ot
@2r3_ø{ h18c^  w й u`:aP hmcp4P7߳ hs= t
 QW& PQ= `t
3f3	@fYX _Pð_d`Gd  U{PRkuUu &GA'F  a;ؿ
Et&؁0T uM9NwN#uӃ~ t"F= wt%   +g`VXh:3Q`..4   !	 P a `( u2hpYa 7t*7u ^S{uraáUtPRfZX`Y .~f.~ AZf` f   ƀPX"k!$fSfQfRf@Z  fQn%=ֿuf?a2 ffZfYf[]SQRfWf_Z p^hCShwh!ބ_  ^3@P`OZ	 12^cǟr)@Px036s0 hSqfrϔsg SEx
S\M(efa't5<t1Xjf  pdwd@    ,Æ B<  C< $ j# Q R ST U VW	X YZf8RVWc3{p.*D*
` yB$qft]RFmRfsf_^ZY#v7 yQ |  Q tc4TC4?nc4NC4/W< f`Ȏ.7.! 	.b77UUB7+G;rVv7rܰ_Gf߀
fa*   > 7 A  T l M e M A@  9 Y .    ?n SA ʀ=>qb (
 Z  +@[_{![>0D2 P f{8!~^68f6,8?  3 |p  6 8>xJ.h8cPSC $<t4r [X)  Ѝ=̋h93 a f`4 S  y96h%4hBBe ` D 3y "r< t@gF12"PjR1n 󤾔10r0{1 r%@10&5&D&EN?J1A(`
phȓ Ь1p,kvv`s/2V2~^ 
8
3
~3
A2^
1 0tQO2Fg&@ U$=u&M2f= =u h&]2&[2&Y2
, fgh  0 pqr  <ABCDE xyz{|}   )eV S#
f3qn1r쾦; r&2&2; r
&   ;x" 2rfX@gCf  wf5fx&V3
Ê^`0(.'t%.FuN.PW)s1 _X#WfVUSW@SQ,fvS  ޿RT~20V2ك!IN܀3d	^
u
t_NA&>0_[]f^_ PV&=;u&&4u&^P
P<q +&~& 1E&DpaSV h@r^[=  WfP}h@ȁ  <fX_v^F10=ROM Based Setup  Entering0 >q`. u  > <M t. >nP? Sup)!`- W  )>p LQA	APi1>qrLzp & >tFò  t
.>	t.vPt
(*џt hPXh?Cg{F12=Networkrvice BootWake On LANAttemptto %  Qht8 0P? r	 `AP?u Q?1KQ	t iltsR QP.P?$<0,( t?=B%B"P?! ds@C	%25ؾO<^
s ͅE%B VRyoOlNF N3؁N?	uCFG~N0tGPhջraN<vsshZ^òP*Notebook hard drive MultiBay"Dock!:b<#b (top)bottom)leftf	Flop}pk  USBCD-!F HαDis/SuperNICH*
!123                         4CRP p 	 
m@ʐ
D$P B ` ~@?صpqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob. ? Press3w1bose.Seconds until au;atic defa A start:   &E<E(dE$P E'E;S A;Zip.F`返u 
۳ d0ô0.EӍ*tԎEB kA VN3N؊' tA<v<st1E& 2آA2ƾ4CQ#YAr	 @ P B.E
*}E @E+jjj(Pj'=  E `ED z  ڢ  E R 2җ
   t03E2Ɋ F8tFޣhN $ Zbqq~p URVQ.,.L.T^Y^Z]S,.E*[ݡQSVW/ s&QE.<.-00?00.Y_^[YQrD u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`;2҂ Xʱ@
EDDr
;w2p=EJơ}gFYô.*E<u2K0>fht푗 h4h7d hb<uɿ`B /J qWo rf.>I5߿ hSӿfgf&G, @ f   PG0f@G,`u
hEt~G,f",f_ffP QW2_Yf= TKSt0fXbco    ? o J     @  yxTY r "R@  QPhF5@3'g&Fpg&Fg&F"tug&F0a 1 2M޾dJ׎Ǎ~?@rL.gJp ˆq ݔ ˢQݰ̹1̽¡Jq@	̿vL 
QӫVWf0 _^QRVgJDT	: r&e^ZYpJffL &]LpрYPJ݈|\DLQH Yr)&?}atJT+ r
W3Js` 錄JSPfSVU/fQWٰ&v K&C' @C$BC$PXrx5  q#đ# r]"Ptsrg r7ێ݀ K: k;WQT rQ G1"C""Y_r
E@t:]^f[XQ$C"u5p6u!#,7ABM  f.MPS [XAu.6Mf(MIDNU.M?SfV/P0/^3U1Ýf^[3u
umru!q!} "W3 hubu !7#7hz3-5cf_ n`= vY O1Y aP hk"$@<@XH,PEp[PR ZX@ 0.>N t.N.N@rNSQRWh@rï_ZOP TC r99 r/ u t^ t2@XR1$tu;tp4Z `2 hh$ f3hciRZSWQR kuߊʀlPpq4B XZY_f*uu} _lу< @3ɹ2 uhXD#qi)¼ P% = @uX%*4g&@ ZQhfWi	t<f_!Qfpf  g&?t9g`mR%f}<u @!r  f%?fr#   f{@%fQ
<tf  f !pfa QrauZY0rV$fVL/
/ jGP@t


 
"
f^ff? wD Pf+%@
!
|f~7H34r H5v 0P@p <8	M2 P` E Й"zR LPo@p`a L`	P  	`i  DD( Actf &_3&[3}@0Sf0'B!x}t uf*J]s cփ>_3 tuc ~rh^
&h3p@C<ths}v3  G01?}4 Q < t&3GUf&Ǥ
3f30 2ɴ*f&_3 uf
ffKP4&4&4fC04R#+3p45Rff 3ffCf[fKfS܃fF0r0а K I+rx2_ְ;Zf5ɰVWϾ ߀u3n_^ 	!BKsV 
R3
t<^f~
w/vU0fkd`dfft@`[`~VQWfv hU-F&4F&p & &P&&0&۠&{&߀_&4^}Uf   rGt >`*:wu
P0xhgbX`aՊ؀adf]PRaQ  hUgjjj%jG P'=? 	P߻u hJ#
v  h=5ú G Гp ( t 	2se fY ffff>Y?fhٷ Ug&; [ua)f)Pf0g&t` b   ttx3srnfǂB 0EP	~/u ۀ~/t a	~;YtM!6O                                                               TfU.Y
YWu u[rWJrR-rM
Ytf0fqP| @Wb t#r"t p ; }PJR  ZR f]LCqfUr*6@^  R Z0rG	0KuҰo!!Vg&fFfF?f^@e rC\A `3ۿYyg&8E tEG SBWi[m r`[>YptҍmN8lql0hѥcʰW rt r
 GC_RZt$ؤÚb$]0WP谠  _W}  s?p  aͰ #`P
@S P  	ð D v Sذ8 ÿ3 e R	$#Ψ
R'
Ȝ//QWjuptPX_Yù
 do h<sxusz
ՏP .<u.uĀ qRRaR522hX?< uZ#ȴ$ t	J  U
	a!|"9Vf @PRЈu^h7[à{haӫhr$.4/h Kh~ruva { r PQW 0> 3_YX6h
aC=F =%$h`2s	> Dð   ! $!f` T`hkC@u' tf` hBCaۘvPbF X׈[`!ؾL &>N&DE>P&D >Ou d֙] ڙj@ tN}
 +Ȁ}	 >N ?33SP[tS[a>Q 2[sDy3 t^h@hWs
JhOaàhR̈D
ϰ<DuL
p
E$<u D
@11Usd
rSi&pS]@` u߁L
 6 6N u  (X6 &uh^
	\

u^`   ~D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"{& xu	\	PS}   ? 4P'>N_3& ?! W>N	_[XB
t+# P xt  t  w\DPV!$!"tKh10Q&,@ &  |` hSC!r!L	vTt
vn`WU$@t! $<v@a@l3  v
p
u$ "<uP>ȷX\PRt N:p1twhEZ!&ă}=0ZXv` 22PEǿO&PCt5N=NtOu570: u	At!s96 u5 .\s
t!Z&@q s  `a
׃/]o3 rBs{&=  V P; Pu 0<} ^  3f4G -/Pf_  }0 U!    P&egWʃO&MuO OqofGtM!t$Ot, t"OGr JM0oOg&3P/` 2%
<t29m21_kP*P*`OHtS@LDhE =_7_D D	 d_
z=1;b^tSqrG&}	r??23p4t`hea&ET$a	&M&]aI`.'`\%# rT VﴱϠRZW&= ucF <KK
h ?,h}" m0e_Wft
q t tP
}@t   U!w#w !#`0|qnv	h3 k.-.׊MVN@tI! //(rJk.58v@Pu% @BVB ۋ0h4s{haW$w
"1D h
h}tCYp@[X_Ë
`PS@E#[X SϲH<vLR
 Z,<u(RffSŢн,ZJ vGu
w
_ mS1 6у[vQd$ >@aܡf3Ґ	fk`֎@hUv73۹ F
t):u%B9eD	&߰ h6"N & 	? hRN3Ga½3 
3 ?ѩ  N aSu   [R rOuF r}CEtfQ u.<t*DQ<u&' t&A+ ǹ'y
y'+QQ|=rAG<Rږ{Z{t?g rhs0`	 & YQ =?|zt[r%u% = +0`YjpO,[s`U3N+6 
P{HHŋE&񫧋E , ^rYYh+Awxff`j`WV @p$P<PtRZDa]O  ZG>PZ^-ZWV 0  PhX@ 025(7
c'22ƀ2р?!C@?r@yDt5-@֊u,u1 
@a

+&C323&v@t } %
t&
0 迪 5  O"   ( 
uӴ: +>d!	"	? Aw ^nPRWA&A &]&U@
t ˀAi] _ZXr#3һ -w2C.E/N#h΃&_= '߸^  WY     `_Հ>u  ׄ'U Y主 ]rWfs^Xf3fu 3 Q>PNYC:*uBE&8Uu8p]
R +B&U
ZK!?ؾrZ6f?YB)%qr h@;Q	Q(t06
  5Ã?h`p8.
<tPZێPsV#
@F^f  XPNED
yC I  vxxUf``؎ Fwu.p ڎfafSfQf.uf fff#fYf[2VftGf   tIg@f;t&f 6	F ̰%wf^`2۲ۈfaf`cnnfaPP3_X.> }u, . PTACO FR ) 
!	& .QtsC<F	t fFf.u  uF.uf.>u<E.u@  tuttYpu?tNp ݡ D@SI?VfB.Pf$;VrT%W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p t%f@c .ffHpufXf1dgf3ۃ!u+`s?I
s*"/S"Vf+f;wfff33nRRE[uo4^q4'r44$.71p6p08333Ҹ  QW> R% _F
3}5u'JE# `0 t{ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^M u)lwQ` &t Y&  
 < tr&\]p &_\U  
&lN!d N
SR[u&	F@& $F^[_bF FxYq߀TV'}PVWϋذp' O! _^Y[XWfQSg vZpfat
  [fY_` t =$PnPu2MtaË6`!s } tp( ` j &&E?SRUзQj@6^]ZV` jX{ŌD^XP
~*F
 ' t# b@ Qyl F ȯF Xr d3ɻdhX$Ku`<Uuùd `hr4ﰭd & Xtû   h>% h PhE^'`X!$! l °Rs} O
ehFIB   t7t 4  hLC` {tKu& &  
 ` h,
s@<t<uuЂ 
0u?1*7`P	h~s oXhm? $ Pk `&jD[%ys%aPXw$# ) )t`($} f.`G  cp eDn@7W    ; Z x     0N@`^~#bh)1fF3.=% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
@mF^KہC.~r@V» ␂û< f ff @ffRfPgf!N
 ffFf3fvZfFswfBf〶f`1 r9\pf3ɰ?ǿnfAP  fafPVa3vrF3X

S,0<	v	,$-.[W D`

Lb f s  fɰɀ
T?
T p s 	 
Sfw_fp ЎfvPUUYP, P蝺:Fp
uf^fNfV_Sf^pPRp*fVA6JF1@20hFC@ Ϣ
 ff  fffffXChq p  `90߂ P9󤿾" 6 a)P*hUCP, %ofPRh廢2R ĺZP  (Q * 4ff:aD0  f2MMShm   hCɀhthZ?;PSsS@찋pq$ q!˰Āu!A tܠðvntt<1w(o<vgVPEh3_ P&
0
3q 33ҊĶtW/g.&;u;@.\onut)@)hPt	׀a`2G@t03@ @u  a[
u93Q2,;8#fN 

PU-j1rX?03Qr |X@Yް4SQo2ہP5'$a&& &0hnC hsu򿣶߰ hm
t[  t
嘪v#t̰,5-PXv8v&> 㟸`t߃`_P3 u $h<I4
#RVҶ 耸s} uu2_2h8Sgu]e߸uXP&
wL2 Q޻ hNu= Dt= tYԀ'
YCY.^ZeZxP #\U  Pf^ ]  _`yrr	 V'afOLPH@      @6P0;V(e
ɿu^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z `7              zTTtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*r3w r@ .hyjfa2 PR3W0 Z@AR `&Fd??uh3P&Xh r.>.puO 	AїQR.h f3f%_  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF ɿt 若~u빠% 8t
` `uPj ;}
+V 
N JZ=uϿANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              D?`ރ6.u?;v` Ql0 >h *Y`"QwLQ`f&YCC`K (   P3YaPSRP3@mn?[`H@4$&%<GPX 	 o; <BMtf3UGP2W X` Or
JRU3 fGenuuhfineIu_fnteluV=sL=r=vS߀tNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<WtO`NBH$u>f=Pۊf@+rC{tq Bt#Bt	ݱ]P0f
aff6?pZXW_ RWO  3OtCxx ؎PP.BB <t BB2J &ݾX   8u!@屆`23Ұ
ShSWSt0`́ y aut0i at]U U[aSR  4hf
 hSgZ[Õ`-0Pϻ  h=	 h
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0ߺwZhEU?2<Uw  h9]ݚ u
3Ҹ EFv)v upQst&,3 s߹ ' 

 SPf. UfQfRfUfVf@@hF: rsNrDW3f. fwf_4f^fq5Yf.>fEgffgf uYKU q u, P3	fgf CPpcIfAgadf.#f9uhpfY'0    /p ;:hV 
;! ބ<# :Q 57 %"瀊  >QV3%@t r;F ;w
V3"/fWi &g 9  f% '"O #YFfF^faQaV p @\  
^bq]3]<   h DTD_w R po 0 oȳh  1   l ( Pb @0 W HL P`A T W Xb, `
`! p@pؾpx o A0
|\D`QWhG2_3 3_p 0 PQ= `tq1 @0YX 05SPr
&ߣ p  ff& X[@ca"&    i?r  xh}@Q [J5O fQ9QMhFl ./ Ж Ԟo <t k~l tq.Qri."D.|u.:DtSI ^ wD:r5+s&v;
uAl
?c1aPQRfWT}3^`
fXÑ2a`2	  "	f 2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	h}W"ϻ (;sQSf  r`
 t
2>fƃ	40q!a
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&U uZ=PrUf%~в uCf*f=`  t0  t( f{{f
1"0"}fph2%/$_!"
 \\-f g&%ֻf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGf̰QÉ_F?<  7
 % 
"a	Ub	~p@R2BuE1ɲcffF &Ff{ t@sf @{f;~t	uuɁ~qNїV&>\##`WfVfPXfXcr<w؀.g0ճа_Ѱcf@&ˀtg&TfVR3g&PfОfnu=жtsaNu(g&fVffA>"[.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o hm>u  thrs-3&>rwqrR0zsRޑuthX$uul	r` 	߹ +Zjjw b6uPS`` FF phC rOu
@ f&  ؀>t !$!f$< uRC  _
N<2<ăƁW	"3A'yܵ@h[u TYP=t 
u2،в3`t<u
E< tȵE$<u&w $tRݚVL  N L NQu û` t  P[2u
@j OjY!(!!2(<!1ʰe$ h5u$0t
$~1.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h4B_DuQ&~% t PnXӹ
 .:t
 ._
vXP%8Xr6%ȸRfc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH hh  hvQ {h҅ hE Б?E^  ` f  Cp m& OE 
v %&M߰t&:
&;r"`p$t1TKKub 
HM` `(q }p" sr#	cp&3a C n	H ]r5{r`2gpjh!BvZaVRQSh{n4Th4J"Ҋ.`B68u,2
t&62@t2 sk ޝ[YZ^Sÿ Ph3UX<?tFhbUujjjj P'= &h?X[ h" $vawt = ;t= Dt
hEsp[.@WVS$`́$
w[? @n< u"*׿Oطh}Nt`-->J=Ot1 0_ tyr rhj  S^1  0 hL PͲ5[ ?  :N2?Aq% ? 	
  v VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&Eܒ E &E<r&}	r@ VW^2۠^2*à
&}vPuh`VRPRQ3f 
%*tu,AYZXRPSQY[XZh?7	pp Є> qQ 5rXY`^,>: t
)֮hG&&  t8t'[ u aq+& nq00r6$^$ «Z& && ;`Z@ `dde`P`  XSU @>
 Ы .PB B把8uG` A ; 5/)䊺@#BS 냑75VŜP߀X
 ~a@A@ uB C    ÜFt𻰀V$%%蝊<;weĿ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу?E pY8@C0	 ɄFWYuF5<?uz`0Dwf&	2
pu}7f߻hNePӀk 'B@. ,".  6&k !< uf& bÊ$
rۿ wAu%1uhӲߡ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<ҭf7RKff
f@hʐXf3f3ɹ f Hf0m f+fL ! K Ru*(Rآ(R6g3ہTgsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3gytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2;%&@Gaa6hگVWa1z_^pk` hΫ"-h  uP$<X/|#sf @  t<   4 r	.!$<u
 f3hh.  
d]XiJhT<  tdbw_0s.> ߄Nfm th3tC	
A!U2 u@> l = ]c 3Fd@ e f Fc~ce; 4~e uQ@@8 hsz|`5
P	Y|hJӳBFe:Ffu1r,
 h
 Fdt~:   	9  <g ht5Lhsh`!af`7UPHhu;E#f% PCAXt# N h&Ng r [ f ̾   F^P XSĻ  y ,  o   hbS-[t(t@t,&j  j,>" ' À tht*dúG."g**{D/.q<pE4]+Ë؀TF/VU2NfQa dYF :uEQ]g33t
t
u
1t#u
tN02t?"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;?6F1 epp0Fff`Fup  ~ j(j	R	aURh$2  pɺ {1 h= Z]coRfB$r@!  togRQ Q;YsY2w$
 !u$ d%|Zf` / WWeI.&$]f$  9pC`hF.
 C ƀu0u.>" 11fa
ZURtLށUHhUxk:Ym PY8tn(tp ;C Zi@"gހ squ4VfRfsQhÊ>.0;p^f[B]$8" a[Ybh~$q r 6Sj@ 2P s? rG{Z5'/UnAW`.#uQN$<u:ߺ0p萱r"&  t  tt"> tAt $puPq9T(
ː

 ⧾N`XSQ 3u,S?ݰ[rE	ˡ-ͿY[C& <ff<q`00xx00`֫Qɬ{||	>>.p~r
 ~ (ЂmrLjCX'PVF JmQ<Q7W &TZs6B 	 D  х߅ԅrAo yuN! CO _t 0/r)0/s#-&@ HqB E o:7&!/p`V aUfV3vCDPDQD 7p4f^]&Á୻P]"%U  vPd?uX$dpH|:dX`@ __ .....- "  ~@f%p4й ߽ FACSPZ 4DBGP4BHP  0938 A!  8  APIsCZOK	a	Q
@  		
  MCFG<	$P	     @(@
 2! RSDT(  	f`h4hYf  fgpfp  gfFgf  FPT?R ff`WgFpf\Pf.@p^$f3.K.Hf.Df gfN0~$f+hCpJF}3ffgf&f.>f(.ItH22^~( N g&F	f P  rgfffff+f+.L
ۑPM.>@f
$$#D PXff-qAFV3g&fFgY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf?=GFCMt"@H~ Qr< uBOЯNRUfQъ2 tPxprAr v; tg&P)XfY8]ЛVfWfV* f& fP&ؐz@(#f"fP)fȀ$ 4 
Ȱ 
ff	h⓽p (f t ߺ fPW UfXC ut Z
$Ous g  r*h1 <Eg&Ƴx%_f PSVHI K L3Yt >Nu	}LBi> uDb& @ u  D` ^PRW D hB ht _ZQ4PSSSguPBP3h f&L *f?*`B'+p#L fXP`*hw0D" 03of&?  P 6 Pu    DOG/oPf3{Ӿ p H   U!   3P>P&geE E puMPMLGfEtXAtߴ$Ot3 t)O$fM~
rþQpmMe&3PaēғŌU  r.`]h%2.$<]in;   ViøPܳ uiWp_±f=
phk0kf%ttӿ' t֟PE(뿭 5)1P*io_ԜVΎގU=^ 3f`FF  hCv }ur_ h  U$g(,0wu4'8  cÃ9FtFfNA:F> h44;[ɀuh(fa`~
Ew13ɊMh$ӯt

hRp;r#uac5WF~ ^SCf_ fN^NBf.956u 96tc rfQPH_urf;^uf_;Nt;ft) p 
tF~U_ս NfPV t;6..<t1!RS)hn:,,  ^_V00 u,h$..D+hX_ pξ1_fqtA"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart Reader\GEMPLUS GPR400\PSCRq CaLB REFLEX 20a241 PCMCIAfReflex v.2$cr$HP
  a@!g&O@~yGd `P  rLfK s_Emr>G	 .D
A O@.d.D4f_ PQW?ɹ  
G.g&:ouGY.5 _YXQ8t *F 
⡤fW
"
@
0BgS"

e%FQf_ - yEP`?Pf BaSzh?Ju=| nh iZu <t޿ rUr  ЎvVrr^~W  2_s
@?D<tJCrE.!&=t&.!uV< t ^aLw 
x y z   h=Ch
{ 滻 (ZPhfaPt =u GW    6
hU?f>q tQВ.!#6ջհ2ֻM<tֻ <^hhA+p _*XDvSQWȎ  <u
 crd~YrS&tM0 tB&=r6.?r(r%t&t2_Y[#`
׎Ǎ~؃^ԃ^֋ڃtU.6N09a 	9u;.>  [6̋N!&2 .>  2@ .wˀ` ˁ w˂ W05Ea6.6˃y krr 

rf	fB6`	rNb&at ?(4
	r \"	
Px'@ ;[ P 6rj&
 v p rTv&㰤rB@r7&}u%&E=uf&EDDpP r0
r 
t BB7
r
 sP '24=@	rl.&:r__ v W Q
rP@ tI	<} 
=@E
tQo&>3¥?GYۯ5h2>QSVW	'	6	r`(= u< s2.
q	%I@PP  r.2x0 w	_^[Y pC8ؾM t_W؎>'>'b?_
˃S3(QY2Dj5 3 3-W,.@|O_4,x60 ;^O_^<^ 
TT~ M,P_`v.˹  p ,DPfLFs-<t(<#Ȁ0&Z hL`E^ᥠEPRU32t
t
u
ku
r t!;rՀw/tM>ܐʇ"SQ X$Y[ώ>"Q;>0I`u 2a0`*SQY(E?;?!e	wͻ]ZE]f``3r&th3,ֿfvg{@qgrgf9tЦmak2 *0 thb}LR1 m@ Vff3`"gfs F fhF3pf t
c` /P޾i3۹: 8tCq'P qt?rX`ňf uPк2PRV
t@Y.P 	 & &$ЛTОRu	& 8t.ZPP^ P_   0 ? 0    0   0  З  0dд CRP1  _  '  ' s 
 /  $$R޳   ]	bVck$@s$@G k"$Q OM3	ir6PS.TԠB޾Zӎr\v uTWrL.^p ˀq ˏ ˞Q˭̷1w ` 	y5rx36rdxE@&=u
uֲq * w:QEP1[fݼd֕erWЅ$t^x!˹ғBq , @UBB
B "Jq[Zpuؑkz\]dxn(uIQC!n
$ٹ!60ӆΎރ"lrWa Zž^DTr eþ55xֈD
Tb
4I^ک%4Rr# t itct  t$1^0hffoL7	] 	eW0!	R֠S
)6@+0P3sr8u_QY_ 0Lr&U>L`
Æ-62U}O
ދA
s
t0<iu,#/+]RSՋ݈|\DL	=(`at /ՑŠn03APLۨN[B&G,ׁ
\DLC

@EױCPyX_.	@@` $2L1nB0<thE3H8t8u6
uBp & DBlTt
륑zaP 03 r/) r%BB!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ ra ñ  tAc rF n r:i r5&D@u-&a$v޶Q> Yr	2QQ'Y}B@?Aq Br蹐{᤿	 fШ3uf @^ `~pP`j Ȣ  H hz7K_7ag h3F% Pf=   u [jg 2b Sjjjj P'= g[ h"[buq?j&Җ]$a vt= ;tau= <t/7ݳ3 eɸhRZt `faʾ Pɾ   tuu):*̃< uup@ z`3: T rπ DƆ    r% ?Z@ s-߄Z  z p$WpF_ǀ uu' 3a rh+ tg	  .!f$  㿷fV t R/Y[rs3h yѻ sѻ= mѻ{. F  ~fpx WT tIe7r=> ѻ3~ .$@t0(@ MF t w  PN !F ~ tг	u?eXPf^SZAt9A f` W f3Q fY~@ L髀 G%
 22uJp2:!&= t: %J 9r $oVQ&Un f@ϳ
MsY^GЉ^
eOf" 6	
pq
&:!& :X.؋ IhBs 
Dp X3 ? 0q]ss"uͺm&au[
		1tQIFt$3J;P2@ [ {fSRWE
D&vjt
 tP _Z[C#\	(QffD+C2Et`
1T-r'a''':R? Zt  E'
QVM f^DUYfPR'&$m[.t'H"[{tt0ې=A0fX`> fv!XYssnsctrrr#rdTWtrrr
r-W Y~Νa PfSfQfRpAfGenu fnteluxfineIuofPKAf%=  _rYfa2BI Ut/f|00tfvPI 
 @H?0fZfYfq
0t t   (r3.+À 
  M   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h~Bt & ^[SO
&hk" `[U샿VWƿF F@    $b F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P'= K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h5@\2%PFA~ t
F_^Q
hv>ss.&udu   hb,$?wط h/"hd #h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	?
   QVWAu% p u  6  | = <tk ;E@+9 +_^YRWS Ê WCrr3ɺ ڑ܋e\AB rN _ZqSYKK{K
Z^QujvzO%NOJ5> DE<@ ;w<<!<3Tu OOpPt
Pm[VfPfSfQ0ppf3f3CpP\p|pXfffDDG(	Dh fYf[fX^v#:KgO GxpQRC3ۊ%< t CΡҋwyB`s|fDf3ۋfç\` 	
C  	S T R U 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.h
C^[+V..^̋] }DF. P .?h?b7XhJ ؃6Q  16V  0"Wa X Y #Z  o
[a ` ^BA\a e f']va a _ `gchi!j qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ -w C.=ő/⅒2VRm?n8o7Y3۸  =_`߸^va>QRrPS[Xfh"(hЍ=̋h
3     u     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;*v   03/30/058Y02/22/06 kLite{{-1|5?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$dPx>0@Z"2""Pf6"Bx xd} @Suu u	`	]^@)!T$3TD @VF @~`T?0	Tb`T%_`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*)} + 5EFuu!+;үx00PnR}Dxe``
$`$p

xe 
xx txDESxxxxgD@.0}}@ v o :}d`xGNB}E%x}DQ¯00xtxtyuup)ސ}mQb}ts ,{c,{+"(xkD00눀 x^Dx_T_xcDxfTPe p# * -aasV2
,p&0*О1I	aTx"B2xi~3T0/ߴ/D}p!T` `%0u!	' T`#8 )ok04h	%P	2;G-"!
¯+u+$4?j~T+}'#o+p (++Ô@^,p+
 
0%?
3
ov7b",`^0/}^j.@ /P2'`" "+7x&x+Xx_`t 7"6}

P} /}	!	  @$#}!}a 
x xt"xd}A}DѢ"+ Q1}=
P[f#J00x )xi`xj  p@0S+;P0TB+x+¯0*D0b 9(P4.
+@30A+`xOV	+ xTx k!
+:DT~BKPF  y+zP>֡

 D\Tdp+$!#P+.` 8j`Q ðÔ2@YD0¯xx7x8r x00A:`6$06m qBT0I`	pQ6UoV̐;q@&(Z[0/Q+5"PYPY# MYx,Vxtx0x,1AQE0xT?Tx*Z-tx+ZZ @?TxY[M)^\MN '	Y_gl`1l@aux`_DND0=K    W>Argxdp6r_	2<;f["`hPlQ@*ARx-	+_SRNx*SMx+` L >`R0 
@qeQ`
 RSUPP14 0YN S~f GwXEWxZAYAXNSXUW}X$0Y԰jp^qZ1ZTMZ1
YIZ[n0c1}\\TRO'\
r[	\S2A}@ A}= #-A~` B~b  5A~a uuҿВ"4"7x'D
Y /7d`!7h33TT?OpC@~`07`'`2`=`HpQx] 6uuuul uu0 uu5ˏO$ƨpN`0T`
010'@@@A"| }(x]Pd"+,?,E+p
0 +C,,+ +,+x,?+0Py!,,,++x_,,"-.T0ޠL72At
!Mt&Ipd `1g*11[tU!Ҍ(0響/0mp/l`
/0dc@TzE2AXυ.-/0"o *xc"+xt`
o3x7@x8W7t}Bh"[ZYYcdᶀYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >gg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D2 T ` D)Y7ax2tx1tI-'%[0' 'xqvv `'xq[C Wxs$% & & #2x1 	ү  ¿0 _%#@K ӿ3$b0#	Mx3C
r beJ"xrF`V0 pR$" '	x30%(0&<T`P$"xs`bfp
0#% tX.4} 
xs$3z 
`Hp`p$W$ ysp R`Шxov"x0	wD0߀$$6@Txy~D"04hxmx~@ oDT 0
 pcPB"pxu1xvx}"xux~xvxx}	"xxm#xwPyywxxf`Ӏp>xx( Qu~B@
"00"+000u0 u0 
0 !$0<HRT`  }
0"HD =16/(!a0"0
	0o0"d0 $1¯ `x1" |u T""?3453/:wNP"3554!_Q0"0"xoo`xaT`}xnov+r!3}TOp0@0 0 
Qu]P:0 _/\P'2;B P` ?Ӏ"786 "0a T?2u$408S0"{z}yH237U9
u89 8+
`9709707@2$h'@^0p4?


`פ$Y	0
	@À{0-$`
$`$p!a"*V ߀K0":0!)@À-0s
   is	 280"
2xofKp0*2d|p08SH{zy xpvJ%_`gK8P2 ( 	4  "H	5345q3`	t%5544r	@ :0	h0"08`	2A08< Lr@1 
 !
 +90 B 8, 
j	" "!`BQ
p0(? 8!^ 
-NU
]DU 8.
j'|	20"G+A6,!,z$f-e2pO7)0	LP85p
b3=&R0(51	c8	0
S :(":"08-8;pfpO:24`"/c)VP3
@IOCxn`qe`?0}Dp h,g,["a,a b}iv"4xEMNOpxD Te4`^}V Vp0
T4d`#R"4#ß4p~}i4xd@3 0
3 #a`3`3$`j$`6$p$$`>$`$`.^3$`qT$0 DQpAh0TxvSoKv`@906$= f`@`Dx@[30؁p	3^P Cp 	`r搬?%¯3~`0@
 pTU`xk  OV) .Zxv
xD}S%0{P^`
}mT?DtY䀑PtYZT[{S#@`T`Q	067``$pa1e7`tg7r))]*)б'0*a a
Td`x0dp#  xF PTÔP
~@)xFt txBVBxNN{}wWxJqJp:;<t/?=)x ү!:%$t=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xv6xV86}'#p p 7  %76'ۏ7  ""88Ô@ fp/pP( @ /..d`
&~r7(KTP5OG([ 4 kD4{04/aP453``/`@$pN5o4:I&du*):P~ [x 
33oppG+L1>gp1  ':P"T~ ,P2}7?T#>үd`pxH m8@22P65b3e1@dx>
1/ 
m
@d+0xA%30 B1
@
 @>00
TDT@5q0	 3:@a5 AP}Rt
} u2P2b퟿tl@
Ȑ.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2*(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM5"^p  d-u*x0,u`2:E,]4 2UU.X5-?k,*8 2732pha,
$+O!% *R5 }
Q'x`S+0	+a -R	++`@(s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp.~LDy}?N%@k53.Eop;OCD-qXċTQQu:93: !p	S31&B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_/X6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/(;u1
p< u11wQF+B{!p4 z5z5
3z+',yuv {| A, 90 & nPÑkT;0 ,	al{9ŀpd010 upo6o,/-.rpFB}}0
P/.-<rdct%,f Wu tq70YS 8S;":W4쑔p1Bߐ}BT_0W=_<I?`$<p:T0Oső78e`pYלBxgTAx`%daz0  87>P$3!}q"W¥AT3	``Euqq
r	1Q`{0V
}
9ȷDrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLx;pG3p?u]A1U^@5_:`@TU`#v@|T kx{⿐}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmoxup&xtPxsxrxxqxxp"pxkv00,pTxgLү4F" .3k0.TxgQg/`p0;P .^ ##----*i C27?",u/212B0T-21Կ^ L-_. 'q,Đ/#ܰ7!,T{AO-q.`۷pG)QNm.E.OVJP7!0po60Y()oy0h
P5
Ps|?`d7]}SPn,rtXar4uN0 f`a27Е
p1
P

Q "u}- 09rg"l  },nh1vg8  A3G.02=.pMR1s0Do@dT0u`zP;DS,c,u.B.` 2 p0`u.T~a1tC
.%TwOлQN]03p	 `` 9b  $ 9)NӔ@6S ? x0!  x5c0HQq7prrqxvWU	Xu

		0
 p`
7$P"q 
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axk6"]@tX C9xVxYFdҢX\`T`HTǯ
PMs>@C!3"x*"U\]@0!Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`<٧<A<aYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0tǣt A2bIAJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G<"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/iJK
g
b^0JKoLM`N T&` @ws0uK`K@ 
MLÃt HKJa}m}t}}{EAMI"!Z..C@) Ô@""7xo-"xf· 7" x`xo-"TxD0TTAp ?$0+Z2I:E}@UTsKF}R+U@@@@@@@@@}@w@q@k@R@9@ @@  @B}QoKKi" 5fbrA@t"#xb s o "BD)!7,	R#q! b* 	a^@`:wV䀤R@\V$`RъAb $!AUӔ@b"UQOȯU0	0!ZÀӒ!}BU`#`5`2$pCxD4SS [CxaUUTxns&@OYq 
xjPy GÔ@π<PT xjCӔ@/`B{r
T"  PtjxfPPav+xnv29pvtpx4}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAC@y*F?}EGb k${E0U`Ud`)5uURBD&D2D>DIDsDDDDDDDDEEE"  {E@b:KD PstRpA$9@pC"-aE
 mpT g ߗ@HL0M7 qv&T E7@U2xZF!R
hap>@XÔP`A@8O0D=Dd
`#p`(`0<`PdP`d`UݎU0:NR^ˌt td	Rxtx!xXx\x]txat"xbtRxJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
} %xtx"Ttx!TTTaD	x?D}@xTpT =TT	Tx= Q
@TxDHp?=DDTxkv0}Gt UdQ eV`eTeP}S:"x0xJ"xh{MMV"Bn S?/?@>"a䷓$tO>$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H( H/+H73H?4HG6HO7HW8Hb9Hm:Hx;H}<  H=TY1	 IQ
 I`A 91~5GT& 8 `;cuTuTK P0T"$`($`*`-w/Arpu4P
T1B  GQQb U T"VPT$m߰QIq|Ib ] $1~J$cpJ`	xt x   uT ᪐ ! j0t p  
A^:32  *}0B :#'/A0`,`0$`3`G`[$ap]Tp^"T  dpF^0$s  `!DQT+wwq}/0 T U "&$pR`PMUQd`QQxhQÔ PQGGq@P
qJPxhv@KnKnKnKnK{KKKKרKKLLLL'L;L}LLLLLLLLLMMMMMMN  MU0
?v"xEMNO`u{R`RRs0 }iv  x]  "$"0R1g?
R:y H气bЄ"}} HGN}0"uSp0?SSST
 TS0SCSp 10P 0@4xathvaQ =pkxTxkoD0SxP0Uxbx"x@$xx"x`}K}UIF	
Q@ Z0""3GxT| } ~ NJ4|Q`*OU]RR &OUMx((sMMNNNNNNMMMMNuN{NOOO!O,OD.?oNÔ`P/QH"T? } >00x`r"QfSQvJ!0pV	`50Tp:uQۀ0 0@I 0)؀	\S":C$p
:!/0Qp,"xdP P0A3Q"~}i y0?H܏R3AP>2JReue?0M}ET@J`dCe!.0fTN@g QFyT00Td֑ϐOˀ0#@60xD Txi_!1?xxivԩdݐTP FAA=Ap11u32}'#  $31T3322@"P0  "'W "   p}"/v)PK}0/Ô/pC0S00Pm2700谯"
xpo0 "uox`2345%@"(t?3t 2x`325R4U5B axQxQDQGx@Q  09Ī6xT6`nTCT0QCQRR3R4 S@SST TT6x
ߎ/0!x
tP/P
0}/ x
  x
Q{Px
m! %60$t $T &Qxt	}XBxs0xsßP2P0 p%@$X$ÞPxxs`1 
`1`
,-u . <Tү$`&p<P}_ p% *B}x.-,6	&xxtӔ@v $(xsvysxtP!  P&0 	r6
pxov 6xa`r
pqfP 0	,xx
xR!x	T7)`mPM$3p 06d2T` TgTqT{TTTU:	Uk
  U{>pwgD4f D@ @B@"xDbU$P``3TO֢WD#X0 ,oD "z;9Tph`S/AE@E +@@CZEtm O@@  { 33TOBOT?@ 20/ 
`Ο`p}Tp`8 -5,, F4S,z  S,`xevS, ?=S,,"+,/?0-WbVx	pV}2xNVu0 u1ATxf`-30(Ӕ
P!P23	D3E2pYMSS0S3u2 u42U03U1Np1%1030444 P-5xp7x	41_0	^p_
55ϴ-Ӕ@xA1 w YG60c
`/p00Ӕ@:x>0-	`	WWWWWX5XPXkX{XXXXXX$Y%Y&Y+Y',Y4-  Y9³-`:S	Y@xu/@xEP^-.^P
.-0]<	
x39t?e.?pt e-`0p	3pQBp"	`pEx@}v}t*p
.!  2#Pt`-Qev`  q} pQ t u vAO}	}50R)A逩 Q!qp^" 2 0 ,+"7``{Z`PYYYYYYYY	YYYYZZZZ"Z?ZZ3Z  Z^ \Z\s U S1
tt)Ʌ|#	
2pt& !^cTQWT0BQ
2:ԳP^`p a'#pQFdЉ]P  rgZ `!L0tGNt(Di4rOBkrQ
xbn)SP`DRQT,T
qM0A#_ "gD `C - gt .`T/Ӕ@"À--d`"` 
`-\?.t %-Ue.`.6Ô@aG\>[8\>%^"Xto.`:``X/U.`"U/`"",pP/m`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$U"x@!~"5}67P d77p676 @5242'   `"? ]P2]#]3]]']A/]OI]^J]mK]|N]?Z][   Plޡ"xl! / "0/mҐnpx#1l^$P  P1   
0k33%$ae2pL2640"0-4d	%4
4Uurov"
@"44$`$`2$`B$`J`[$Wpk@\P ~0/V_QRP"D	qvk3TW4Au24p-73VP!
PD"""" @@$ _%_-_3_9_R_v____  `u2#`
u22b ! 0"8t0!u2F,!wu2=rq(
C^QbP(6PrW2UDE. u8
Z/0"HQ 
R 0 3A2"0"x%0qT~t@"ï@P@[@	T<" Oxm~ < "ܰܐ}t0	}`S!#x0x!TT`D?ƨpT!D`!TM"1 p>an_xDLqo"  :	;
/'
123B=>C	D
WX`~x`!`TP ^`_e*"
%'~F`7`i0x+ +cx kx}qb+s+R`C0/+xT 6D } 20㐕sm DT_`6l PwTT`P80w	61 b S 
0cx	+$```9 Abxv pz q DxT"xStTTHaH+xS+<x, 6, G`$p#+pxSx+	x06W0/QIq

?0aw "p.!v@-Ӕ@	}-A-$``
$dp<0/yC.t}O.l+ d P` cD>lTcPG@@|@aP-Bp}} ԏ.ke2	C.-	.@;p1~`J$`S`X`]`h$epj.>.
cdx.!<"dpsi.0ӗ0\0T: Lxl..T>xf.881.T{P{ _OolS7ӛP	O PÞޱd`Ý@ӛ@*ÝP:;<u t/4؁7t" ů0@*` 0I"xp,E" 	/014u5Pu<$t}5}@ɣ/ fffMfffчfffg"g"gkggggg˗g˘ghhh˟hˠhhiiiiiͧiͨiijjj6j6j{j{jjjݷjݸk k kkk4k4kWkWkzkzkkkkkk  k~O0~*~ p0`+ pC3/}u: u; u<3{d4lT_330P6~ 6` lR3]`07]5u3@u:u;}u<{x]u{{X$::;<[{&5h5g0  WUh)g
U
-)K>,P7OE` 
} P0C3ۀ+R#~ 0`| }` @?^_N#`##(J
"&

5P)*)Np<Id @(
c# 111{!U7(+/U*
81,U/'h3/1WU5H13O/|.W1RBA$__TWB1 u2Ud I'8B=U9'!'8FUGXC&UIˈE(L͸G*Uo`VI-#M@6EP!}VbhQR/"qVÔ@πu3//\C4?"$y`!SPvnr" ? "@A~K`j!P$`mD`p&A`#0#xt@}}X} Y  ZxqBBxtPBQ0%70$0?"Ap
 `_"&@AOr+ U 	Y	Z 	 
[	Bxt		 ":cx>T=Q
38T>?`dPnP?> I IPw0=pR "08l= ?} P' 8@
Г| $ '>d0
ؗmd Ep6ѡ"}6`~M }r:iQ n6#@!1f}ϰPLTTp{0Xt
}"D0rk0}$+@t++.
~M_12Q^YH`x
lw@&#p0vxr2 
41q*no"1o4Pow1xe 60o6
 0A͋ O6'j`}pp
T?T`4"4"0u2<0m0`=~ ~^y5 0TODԳ001p322\* u1C0г0 	3`PP`8Pt2PD26B32ep087P!c`&R@P}`"Q3"0T_POs"
07/% ;r9033@,p*e0`C0>&2_Veѥr90oP31!q10~3  ``Jgc9P	1Dq&J@T3``2;;@+"45675E4`54iP
(4~h77$`cTo`M4TM >`` `'p-?Tar E Dh i01$CrDe0sPB2ÔZ	*u1au0)'2u0p
1}@}]3결ӝФ2u2u0*@> $3v@20U'`!c@':
L`2p]s$El;800s2`&CTATT%%O>Ep`>3`#E
X` 
p	0d`0aq1\]T?`<p7!?$p*|3tT :+	 #c]PH@00	=2`fO"c"'Nc#բ&O$'NV&t oݾU$	?E?
o)$U	f??u)txBd7eU}{z?yqAWk7wj1ww04<t`9n au/'P~ sO./s5%tS\wh~@_!\d1trvp0p=T`qN`L=2t[A	ÔPtc@1qo``@z45@b/Gk4373 Dxx((sxy,yMyhyyz{E{f{}S~<~' D.Op	{ z y4mO	5P4F w
QhSDT|lS1
3D,t~5{u4`u5 	]4T`pd`VӁQ?
p0
PFu	$ߑ	uazLoBmP[|У| 쮐az[}Ф}O pm1iiiPK
5@}
Np&|$0/ԙhiz (
r}67d6PN6@7"PnRJd0,ve5p4l`&{JA!u8*8EU"| `z {E` @\o]Lvv8999889p#!#f8`9#
							@45q0|F 34t[98(d`픜!PD<A-0/* 
E0
jZk<ÐIIP2SU~dLptp#aM`M8@_ʫ1mpl`T@
`r/@1;ňqd?Npt/,V+/XPՏYP7[ZNp7>	bUodAppNCWWriPҞ/'P#^q/i 4J(?d)n&pf1 6r<AFt=QVv>aBfx?Mr i},KD|T-`M098r0,P78+3 7xe3"27傐}w3P Ô|@3$`Dma c $0u~ 2 0uu3#ux77pdE`H30 `at8u@Pa~ZPt7p9TT Np: !p);R4u3
tu
q$
 e3`37 1a`04t¡0`w4Кm 1 e31TݡxA0V'΃g1pϑ2b.Ƞϊ?2"u0Xԯ03}`Y%nԐ~N0:>F2pPu2f	op`8
0tі
``xӕ1)100! xeT`&}$31dtPw2"u}`q 
p"""4}t@t ?P
3U02	~LTD"LION ~Rmp`(PRx33d8`*"`~ }@PMapV02btjP222  ~_2~Q`\SRPS@~Ptu4<P42&4ްru3{`RJpT ;ZP~U@	@3'~^p~ y@3hP\p"00~Wp"/0634u5/$*``0$pB/}u:u;~u<V{d4uE`eW{cu/R{p>3//u: u; u<3/r4"{/
` 0"	` KWTv"/"#M[! ?` ^1aOVt@P]t~XqB-`- ``C-ӟ@
- e-`P@  KApt Q`
^Pp-"]XfVC p .P`QR,V `"!`0vs\vi 2'7i`\a`T 0.3PT&,4(.lP,vt@p,0a7	#~YxD`d`X5*67`'`7`G`K`Z$fP'Xt2hc``\V@Va$M0IdPC2
::31p(P8U!#3Yp3o~Y"x9p%P
 DKӀT^:p
"1!O~ d!_Àz  0d"0Ӏñ 70U8`0@
D U
~,T e8S@BZp 21PY0`U%PY `"x0  ?5"5q?"px 
Wqevs>1]>~ 0z {w`  on`dx"7@8uT|XN`,7`bP\P ] Pnp	84gk8$b$"8ߏ9I;u<9Tbae9p8lpe;;9E8 `v@@~+P"~W
`a0&Ȁkl::Ӕ@:@ϰx}#,	: ,A=x@A-o:4P <p ;m
8 9|0=<>?u@`"H P/A(p??p>?
> +@55@@	x&Tp/"%T~ O7&2w@"`_b"x!To`	TTp57|3o`PR12D"C
xCOpx6p>A4ra/T(--,r e,p,Xae,`,,|213>d$-t"u;y2A&8<9@Ju;;;`P9:9@ɾ56x>FM+ pb?b665Ô5P	d` 
F~G5CPM¯ DAJBO*"+,U
,, +, +@7`S@T` OFG-$&`
xt́
 T0xAT1T4T?Dx!CD@p
0g1dpa3N%33+P3Q@
4^``V4cN(%%}q
OPZ`a00*OT@eT		"TYqcP`_` #A""	F	 >o	@2xpd'X LҀƀԀi@o3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#sB"P""):"P%0 "b``"ο.` "  )"/33@p " 3@P"Ø"0	Ý0  _r}_0"(p p8@
!	P	^t	1a
b*q2P	1	"w<t 
""BBE"""ЃЂP  tsn6 s)ŃŃ& "%@$5|bpp
߂s@h`߱5p5 5@~5v$5@n5 b5V5J5e1515 p5pܟ5v5pv5v5q5#)s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)     ZO   P DSDTDSDT  pHP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`$\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[D36!7"38'5 9AX3BQ CUD EAFPZ40410+6 4a4`U245a678Q9A0[ @34BCDaEF Mn,51
E! `pEa41a}aoiapa ib{ab[V102'
_C _ADR
 [&   m_STAi `	3p
4ʅ5056
T
C[p)56Ptqr 5 D07075}7%o57EB2~t58&p? k A#59 [#PAK`u5B5D`p` p`bs57eYe` ap dpy0cCdc
{at
 b0zdPx5Czbbtd
qp6pu @2dcrdZ58` dza
aa`{
PN 0afuff aOdu`['A
Ja
EL?

 ЇGA
Dw `xH pd2?y '&Bp}p} 3[A B`60pibpkdrd
ed~A
d hb @brb

bhb1  2j3Cj0a61SD 2`K661crc6}3BbN0u4!wari/5Eab\b\b[]
q]
bu~A]atb
bP c]a%
`bac `/$365SRKr]Z75E
61 }63c)626P=aa3q`ܱ[66@1Eq~_S3 p 4D
eK67U< `W

QX6QX @4[ p9 [A%@ 
"@6B
 a@{^.Dh2BACDQDF@[B:H 
E
`
@[$EF70jQ 1 2r^73aW7W76 @. v77AG7Pq 9 @g7A P]7]7C]7oE F\80F#81 H`82 Ql83

Pd1384j85 
<[= o  @`687 8Af892@ f8B 8CQDp8E`
[0 F	 A90P
aT96`	 З92T93
Av94$
94596 
!
pW9X@`97  @ ~98 qx9A
[! B9CQ 9E FG0A0[#\_GL_"bp
`Ӑ{`ʔ [!
dv`J`!9D9E{hjp
p
HrE>"a 9FbqV[Jp	rya
c}cbaa A1 (8` A2}x0 A3Bhiq`y`j0OPA4
Ϡhݠ7E: p3 D+Bpa(80Vv1(@pwA5\ip@"m7ARPFbA
i9DWF1}7B&$r8C}j8_0[GG6C@:*BaA7
@
[+ лA8A9Q Ag "$AC06D C AE
A`~9`Cנ
p	а  z{` `za 0 
bw
t
	rabC
 1 1
1 )U{brv"OL&F
pI6'B0B0
y
rw iPH2AB}`Da{P ` 
p{z1 wi@{a` rbAAFb yC11	_9`pBw
h ncN }r  Q  AA3
ccF~B2
l
л3B3 B4 Bte {ky
\ B3e} 0e Aj
z4a{`цVxq5@p #b}e
e/\p !	e e$}`@dAy4{k
\ 	``;}qA
 ЈAA y!-A_p?d1p68d pA8"9 9eM@{B6q0fB`7 D adyce@
QTѢ)B8hif"f
_j
7@
EbdBW	!ba'c@z!Dby
VPMT6CTHPCIBb(p`oAb	s@bB/cpyacaABw'C`CDe  dBb[MF`B9ŅGGTGGD DB6 7#BB
@QBBPBQBD-__PSW12B`k (!`A/D[(0@E֡ F C0c	C1uVm	Vo	o	o	o	o	o	i	Rc	 @o	o	o	o	o	o	 t.ҙo	o	o	o	Ho	o	$N!T%[M 
5c#x(`0833bý
[@PCB /@CC
P
[5  } CD K [ECFвD`OлD1  0D2pD33D @~  ~PD5OT 9 62VQ
 0D=:
cN`7
  8 f0D9DAA!D$/D(D///D 'D//f!e!(.G!G!@($3( N #F(F//M E0@ #F  // A eA !A N A GA "A  "c0EjV/BE2g0E2//.3`03'3//a0%1a0%1a0n0a0G1a0PG1a0@1BEtJ  JHE5	E6	
#?  y  Eh`и``
=`p`apa!wE60E9	@	V`Q	o``EA` a'#B	 p$Cq з	A`v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)$+b1r) 4f;c!2r)C EDM h13 r)$ U[(iA 4r )$`k0	jQ(5r)3F{8k6r)71^>8B[!a42[F21F3
r 4
 {<5 [#"GP9u[@KF-26 v1(W 8E,C054zF/8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ(FD
 h246 ` 5*XEc7CZKFF
048`
{i}`h`{`h@48w{i  @ o5$ q\._SB_C?100tB~ o._DOSq	o4
` a![^ 1}bb ha[7ɠkDCYFC
 G E S=SaF
h3@˚rRcp*r&R%\$C 

 
h06E0FD	8hfp
` {w\/002<O98
Pt1`0D  Q   P Cwhi82?`
hA@ \\8\/	F1 Y5 @E6|6HmI"7
 i 74hj	~ 5hijCqm8c.50h92s 1 0p
6Л93r8F2z! F)9
^/p0kl0^LRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10BF10 #0DE_

p1F@~111`
 2/_REG(pip{015
 a	ia113[A  @@@0140ް1Q5p #  6!7)U8A9AB 11DE mF20+{21Q 2 u3s 4b252678 Up9ABQCDEA130Q 1R333345k 6s 7@,383ABe CA3EF064q4q42j 3A4045Q V
474 Q4A B_INI >4C 4!4E[   I F @C150&p 1Ph`#Ph3Cphf % 152v!M3p`\`cp:4	wh
@axa
db`t
@`X@	
a
@}a
a
y`Pd}`a085a azw`
d`xr`
  
@bauaam"@6~	4Bw	6
7	
4B58
q 9s A;
QB
@1D E F
v60161$62
Unknown 
NiMH 
LiIon No@\61>p ,  5A6Fy1
X5B
a
!D 0F7B! 6#5CSC^5C@)PEӅ}#5Aa{a
^;5A}QސE58!
 
fQ!9!9D!163	0@1WP atADQ64	 Np
J{`B ID65
[)h`pc0P
csc
  dzi`r`a[)absdUb1/2*(ccC 6	`hg3
@v64gG
wU8261{`g7`8hQ:C s81F@]23Бa9h 1 126 w"Faxra
c 
dcbpbQb6]6060r	38`>9a$(`a-q-8g$I@A
I+Ep_
 W 	ip
$q:/99"29cBcmD L 0q{``	{``IF@5E;4  9RL2ccdp e_eez
cpe'cpci9%4?~ |p
s5I%0`p
`4[5Fv21C-+C_@+naN)p[1DQ-  T(
>
>2(P2;pzQ{
 5[P|%*!3(B+BCBH`*ae(a5h/C`	547ata
aic
bzch!

D

6Aaam34
@ ra 9PQ pUaupaHf:bc6h640>77@EBFr?00 [m
Т6DrAxq
HP   a 3A
Sp
SIMPLO0~SMp
MOTOROLA a`w釁pVE6E
p
  
Aj(_Q0!3':Q{BRᱠ/B4u0FbSp
a4E
ba:@[TZ 6F 70['cTZ3_J
6|pn@v
J` na71
[1PR0Y1A 
 1_2 N8Et# A0
B2T^3#9nO1169a̯_2316

,!
{ (i282i4A1
 4[cIp
ѹ76
NĹ 7@78F7N7877 0q CD Fp788182s 3  p^85A6!87
[  ћ88Q9u88B[8C8D8 m z8F҇8C,UaC190A
q8CM&P91Q1`ћa` 7F`
80?0 `90Opj9293sA 8!cA2b1c3yg4b qa3B6c193zya
 "d
b{
 bdpdS c
 c
Оcؠ1B`948Fp`kaPϕa
v2D albab`b
vMbzb7N82p`F819q !4ϡ#!c80Wzj
a53-6=P5#'7Dqbb	aq bb968F9B7C ʠ`7
79 6" p4"C
A8
{C039
`{  ia` `P91hp!
`!Ka)9	+C)hA20$b cvV09abcA@'K9A p^^/BcIY9CL91
!+D

Gy 1A9F4 `;A192/ "9@e7D[N!P1F_C  _DDN
COMA2A36
30U"    较8y `NS  A3D_STA 3{s\/ g002fW3C0A2Q!8
-`p	ISP_RMV
{+ dl038pA2Ρ
qF_SRSYbh
a4 S,A4r4+BA2@
_C
}{9

 a`e bcrcB
04xA[jA5   
C6
_ON_D7_OF}FPR0_5[L$P%6hM" C
_vG 0" *
' ~#,$[#u82K
AA7 @A8c;^,Pr2@tA {A8R94A]X
I A * 
 	AC
r
;P0/!)7!C"Js"8x""u"4C#2f[
Dm$i$!P%`$| $D[C:0JEAFMp=  U~ЌB0
.G"-5dNB>BpBBCJH
1 Gxx&xx"٠q)x)xxPM No r^r_ @_u\mTST0LB1R q%QQBq2Q"1QN?3?303?<RPV3rRns1Gym3 *o32dSbrB244@B34?V4V55 X5Pxqyxp
,lB3 @r88!]qB4=]75]Zq&2]qBqq8_B4)~B5 p\/0syQ(`O{fx !r@{BP.T 0>QBP9 ?
[+ @VBB@CADQAzBC0 C1 ; 2ACABpa"7#phA0j BC1C3@
Ы0*4&{`h`h [@p\#o_UI \p

K_PS0C2 09ߒ98   ['"

Q0>&YD`a3 Ә
x  "%@uC0g1C7y @#C3 в aC0   paJC 1pF	 z`
a
C7BfC8 C97CAQ `vH1b9$ Cn[OCB$aCC` &'CE  D0D01
G``Gpp +BlCF
PmDBڴu̗D%)CDC}D%D1[% 2# =0"  y'q3
b@ @ " W[ր=A8
 
q@
     *"P4`9r~ra a !-/A
0 p Gr r " $A` `0Gd d"[ID}7
" 0\p[0@9
D8P `µDկD9x =O.    ހ[PKDA2@
 9
 
mOC067D'ADR   'oDC
P[0<DCD INI	mDEuԀEFF	C0a-PRW
	
[qTE0@fE1aECBPDrE?G7M7P2E2 p[PdGPE_L1A`aaD
C0w	0wPPM
@@E*
	 *_EJD MpB.AP CQ kBEQ F0E4Q 	50W0E> D`".9qaƓ
CQ1

*SK3Dr 4p C*O C <N

[A

D (,A_Dd#$#	<#
		C ,						FC0A6 ,C1F, 1A#C E_GTM p3
) `02 F3 pF4p E' {Qsn3
0F2!FMhhhF瓇ip]p
wP5Pqa:` `A` bwb
bw`
cib ac  rb r-c u`A
2!Kabq6%
2cF6bcpoF1q:6 !{` zv0I([$2 ;F &uF`088Ю`0i7	?
#  Z1 m8OD9ODAOEDOEEOEFL`H\_PIChb\/}gND6MT MqK6?E

`O*'   +

CJ #0$ 
 GC

 
	
IQ a			 			!	Al	5!52#q "cD
%6,!q|!G!H Q J !G.	!A0ET69@	F
q}R  RVd
d
Primary 
A   
LIon 
Hewlett-Packard EyTraveloka	8@ 7-5BL66	004h`/` %
 
e
" 
 
qZ69hgAPBAAAˑ10FAa
`uFA"p AG`8t7vv
 0_ jЬBI Yap ST .|CL\][Gp746\2AȠ)CɄocPrʜJ@7 
ACPI3	G	0R/005`D05B $Ja#Bp&]PR0 1o=81``[ T֑:@$
.LID["AHP_Tab4PC_Buttons b\` 
5
	/1?5?@SXr)JNq'6jҎF C200 
 1 2u0kpk`qh`piaFa
 ?{qя
 a{`
 ks }a
aakk
 kЋ2 14 pFJF  *203z

- `r `2`@hp}
נyj   >qb1h)h`@p!	` ibppbasabcpcau`a[5p45
 ! `b  ҕ!6I<N7P08 9 qAB	:  p
`M
R P  r
` a  C D>Bee[wre_
 
EAEeA2BpFAILОqL)ASECUp,eAMA9ASp^0(Fibxq10}Ur12]R3-3P
c014Mc@
U5
	
6
78f@82Oa= `#t@4	O!091!A1BC"Di0E)
EbF%CP4!  ZuA///SIMW62wT1__&O)b`I"+JT7 aQ=1 ``0PASS14v#A61aO`K22pOC0P p`4Dap	 a4CpLRM;w2PQC7a0lbb a~P b ub`yN@_1E5EH3h<p]iK4#M5M6t0N
qPӄAMq 4 5S0_WDG?
<4_c,E=DAAyB{M4C~ !f )AB WMAASij=DtZn´p{G6
j0D?1A{h
`o?{Տ44Pi^p,`p504722v*5Pv1c0  p_ B G @11p!AO
 ,C97221n#<0 T022M 268a{a
}@` `d`I~(Ja"	39P*	aDnKO!F:Ϡgp,14A6
b7ཁ2~!_!hμCh	2Ұ)A`;
1_;!m s7qaµ&&@56'&R@157-h$J:8
@$@ 

p
1-.0Cep
ob!H71I6  s?	p
<_\
p
_3=O6p
o
#)_3V37q37)
38Q521D^5KOV?C3Z  m) (;)!pM_WEDs@[AZPвUr5\Y\P[r 63s4`WQABNFOMT  m:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj',03[9

[  2A o\C1C+18_INI` [BжA[aBl[#\_GL_yh
 Bpi!pjk@E!04F\C0F1haF`	l['['`"C
! DEmF a30k31 BFphFEE3FqDp{zh
  4k1h7	D 40 3C 6430o	
305F1	PO\_TZ_48G,
@
|
0Q 
?b5 [P9
Z
F
<
2
v4As B

wC
AD
E
!F50hs   253G4Aܡ5 ?6W v7
 16F ?170
 %R	174
2"08	py
h a{1a`ӡq Lq	9
i qh
k}`a
`57IaRb cb
 {b⃈c }` b
pza?brc
c2`:0A`phahQ56i `rB@	ap! A!B
 a bb9C !{2
 t  042>D p<3
pQ a57:GE t
axa

`br0bA0

btN
 2@㜟

Q	/!

V%3D2# q$@GA&p
y4F.F#DLC260	F/h
 &d.Vۙd"( p{rbHb@,bqbbwb

araMpLa XA Z1C^147a`Ypab)a2*4h 1+s5h/ apbpa&9bI{	{;b  QAkp).ha@w`%  v6i52<W`3h1;1#+71p`DQ?1`h`VTZ3_
b0#.aB
7>h `t`,`x`fi
 f
p{tfqdf 1tqb1cbb<1Db&8! bbK	i
p

ep
d
ip
 drf
g&8d?6a:eOf'iR9g2 &r>w1p/5B	ܒ-`a"Ma[712   _STA8Y_ON_a49S
z FR59a3#4-.+
5


w[= @6'![ D_HIDA_UID s_PR0{62[l67MH3C8495[NQW_AL6 1PAL2	AL3C
9_ACE0AvQ1VUCW2B3\@PSVFEB{SLQPRat0GUA
50lbAїns(U!l4ApC`@p
qp

q$ZQQQ@TSP
dp C1TC2CRTp'_TMPCVPJ3!a [J4 bBQ*@cC",= 41Ќq03,o2[MTZ4_
CjHPA
`kkk>C13E`k	`
dp
7d`w0[`r[P7EDv26838{E1F 70 1 2273  4 6|29g  A75@[ 6@w(A'772g8 hC78Au9 A`P%79UyA
	` pF07r$76aJac
`rd
  b}y   baya
a0az6Ec  eraye
	 evepeFc ucdcM
zCrBcpc  bpbgC	bdp~e)ec±6Ee ffg
fape`pfafgvdueA`bF` gTb 	`6F$b pg17agg7agubdMP7DA05%p72p0`c@"沋70 1` /u`py1 EC P; D "@ Fh H?
bhhr Dc@䡽da
er70%-adft`f	ru'ad"uc2ftd gq;`5b4 x7E!,7&-9%CD`Q&2/p
mBC060pibhb2Fp7FC80
jV`801c11" F@2 w6
arC019abpybA0+b``babuaaPo `bua/HS!3`19PHt1-82\DR`2t `7E```Q9XD!

	          y p38`o [K\/6K28=4mHH
F85F
RGGP   @  -  s3	0	  1	pi85[C28	 19BF
rG G$ $ GN N 
P P Gc c Ge e g gt t     gdP Aw-_1CB


W)3p
`q ^^. 5A\_S0_ 3    4  5   M\_PTS@>7HܰLi61F7 AA'\_WCAKѣ 4@92?10uOxFx"G115a	4oxex6F)ƀ\?5
CϿ4050Ώ1?0E

O"Facbcc:c71
G;Ԩ@11ĩ
 5BZA6 `@0B0+- KLl4,2!0A I\_GPEF9O
_L00
rX0

P`I{` {`
Oa AP2P~
 a*a a&BX&E 1 C	
{Z67lP\<C:CBC0D27c}
0CE+c
@ ["`-j IO	C	ExDO	fO	CE["
d+'DUP3(4/)F"9 HOH/0*_1ooQ3S /oJ-B67C=#D<E?L?_L17 Q82?`}8@24d8
CC9EUP31ELE2[p&ZC55VF*n4 !27Q54
221E+
 y8?6blGB 1/D`{ L98`pKe81`8AL C =8 @Ɵ85~100wYӈ ID"V:\!֊E_a6a}`@%yDUDp(Fc9`@|!90`??6`
ڰ
 `Em%	p8C`lD3197A!N[] *
MIC_!P!}D8D8Daa`r 	bc. j q'ެp{a +c!Q[ {E 
[ `|Fp
a)?5
0F|bn1b{b&1_N
a0Cd7 o,rqD iF`˓`	|ޡAp

cHGc
/1Q
			vcv}b0TJ F27B_hv6\0 T>/SSDTqЈHP  HPQPpcЉMSFT L4'90@	1   L    f#__fT	_w 
_	O1wj
ara
[a4a02P]PiYjP93 [hFI2EdJ2F 29]4_295!4$91 JVP3031y%j2pzV3p^mj9p6
D`tQaAbb`h~ a bub P)3BBT390u231ⴤE44rFy5(7,/
b+1 8{y U  V
,8'*[!/9"PDC{Èh ~`PCwT p]99q 7	_PPC _PgSS :997YA7NLP7 _EJ=0`E1ИAà   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n      j     VIDEU0 ! z@ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`k aP b  c dP e  f gP h  io jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0  03 _DATA_BLOCK ~  `1284Intel(r)Alviso   Accelerated Sa 
Contact joe.david@hp.com
Build Number: 34{12 Deva
04/29/2004
 hCopyright (C) 0-`3 2`rp. All RAs ReservedPp      $		


	  ! 	TVD "LFPy{8 
    0| 02468:<@BDFHJLPRTVXZ\ m{
  8 (  8 L 0  @  ( 1 ? Q@ c u 
 @    @ɀm ` 0   P@DׄHLѠ pRb R! q }  ߏW     }p܁ 0
a		pa ?   H 
`  b _ 0 = 琝 ΢ $ (
  5             !0 R`SI-1362=-Xp үA^6K ,(>H M X <
  <
 2	 	Z e-  	    "	Q Ia("FT @$W?4΁S  `	  <  _* 
ZcTZcu$M
 bƀ/ /H d @A &06-0* Q 0@0p./xQ&@X%H?@0b2@@E( 6=S6 @-(     ɐh#  # ,ڧ q(s ) 	(		
	(	



(B
T

^
(



(



( 2
<(j|
(
(
(HZ
d(
(
(&
8
(p


(


(
*\ @ X  ' 0h^	 `" da>  1X (dP0C	? c`<# cxx Q@2߯(+A)w @_/A-"~/d  P 
00 *f  @
%,@`@	"7
)(<p#2%%%
P(
D. $< 00C2/<@pQX 82s

,+a N  Xc JUXL"o o o o , pʠ UfPfVfWfVtRu.t
fF߆   w FF\  耹*FXF dAu=?Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^pZffq_f^f߃ !;F}Nn߈^f~f~`.sf~ t$:V^:nQ:ND~tPfFtF3@u )  
f~v ø t2:~sPv0v^*ߊfދfV2fX]P!R_f3
 fQfZfXþ   
@|  M ` !/sw.+6 t 
؃p.	 
 
f.ap VWs tR 2u/Ga"t!
?rVhf" v f..L^߲ 0ff^3_^3@uv t&2t43U
PSRV<v
W<_2&fW< t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufR1u5 /wf
fZ
fVPfAC4% `= `Xf^2dfP r ~ f D`"fp!;r;r.T0$p7fP#2 $`GSfQ;tfY-ffXH=r.fɱS fYf.; r&p*[fVlu<-u ,^% @@H-VW;<u%f߸-5wf ]73bQ%`^!b䥿w0t$50rp%ufނ 53~%sV 2ffXu
Rh<Zsfqoa6bk5;uf-08 B8K5:25/ &5K:@]/tt=13="tR;Zr.
 @) ;Zs 	.#atu
 `{/`*{@rf`wR1	Hus4fP(\4 $r2ufvvvvwYw{0~~]﫦k"' ,!0!"`"&
a( ;);U"a,d#eB"fgt$h"T%! qUP 1=t.	o1ffX.6kހs.X p=Ou
uKa=_ j W'-6I=OuFt=Ot=_t
=OtP!IXOuK
 pt ,f]\Z/Ͼ .<t.:u.T1_F`2a   s2a4821 { s_+"YF H ^;+p q  Ð?.2 f/ u0u
ߖ0F t f#2\2f/fP*&PK#: 12tJi~j 9k
f/f_Q' d8S/c8u @5V
0Sf[ u	uNSaP'V *#M#X####	$	H$
T$ ") u`+uu/ x1Rr{%	ti!.u`_
^;A2ۄtq P'6ȱVfr/w**u`.`	q01s!sr"	rqs
@"t+S
[tpc t fPx0 r5&~		O?s
spf"T-fUu-P$8X$@
؉	f`2%(q	@iQ	ؾ$.8uPul$u]󏴐U/t q* 0^/d   uof m, }/ f?f)'4e/p-PQS--XL-]L/D^A8/ #uy-C!/,@-@@..faPSQrQH F2;YtlQ
 srYTZpDQDt c0@t@uY*Yd"ut,3r.D$tt	_f^ZY[S{3ɲ@t#w3u&
 ut
`21jf @ 0@APҊٺ &C.wtNZ uf~.VPQ\	Y2rP &.8tYX^r
gf& ⢊f_C	f`L?sT
0xtz$р tSRط4Z[B7P7uOTX=*'Ё?,}A$q-*[0C^X*+*f'tЮWw.]S.L2a.i
QPPfY
8Xt+YI+.t
P<0SQ;[tje핗`)^u'uB
2tPS#[;Xu){a+tu
~PSߋtIbY%tSQY[r[bdm+3QRvXu@ك 
T._tSA[rr %p(6#22`] 0(@; N
AOs 
G @` ZJ(L'FfS !} *(PQp]A^(L<vYX(r2(P `W0("&hvXi(	x&X$n&С&G.&7
 2Aa_`df
a~p!t@IQ : 54YM òTh)EXrPu(s#P7 R Wf_`V.4.tf^^ܱ +4g3K *?ks''d&f% `8ue#u㻐2@t"0r/ksp}@C))Z-3f
f^	ߡ%'Hn #fp p(QЕ°/r߀tDprcsR#FU(Y1L?#"t#OMu׺h(w/
%́iUQXw
[
SX$w
˳\%3һ &9
2P ,n---/.S.d.x..	.}0,Tr% usR$E\㫃u$nu@%Q}~%4ty#%fSf[#%X4tXS%݂
$$u0 `Q.2`;YrW!tq;  p~W$fP&fp>f jff3g&fGyP&f^U[2pQ&0h$8 &
Q2 ue 0 %r @$w ğ5	0 蒔.:\spg\Ш \*.$tBuIP B# ^Xu,.8 $.t2s!P`033XS9&[tрt
 Sg" |# 
pffr1%<!AW"$Љt*r[<
f^&E$g!n"$ 4Pf.3
f+أ42<"t2l1fPW O;
&2pJo$`Y0r%$,U4.81F0sv$ "x#![>c<!$tPu@uEtAv49*sfQ)1fwu!k10@;fYvt`q@00C0c=+ r
 wQ2Srs[Y+8<FHKUQnrM
rF@s)@.t
1`tF1u33L rQYߢdPP<vrs	 (PfWrZ@1㿏 .!u.Mm2ft!2 "SQ2QY8[r2QA÷sYf_XSW_A?_[$zrFsr?PŊ
=
t+8t$P`Պb"X8uЀ`ʰ8 4
a `_b	!kp6 "}w.&f ¢I]V0,u
Sµ7)s",@!f  Gt  ut
ъs!-P_^rXJuWp迻ذ32
>JU^ FVvnB]FPW 3w&!Gt8ubXuD>L t=s4Hй @Ek tFkir3vGk3UX&2VS2.k3V8r *[Y22aF<]W.>kt>Àt&}&t,(-)*.)` Rkÿ<v<t
<vÜ߫Pp3bNF<w<?t0f΅4es%2&J&P &L&ģ`&-pK L`  aÀ6 D66665
665D6D6D6r6`sIauM@B? 
<w
2t0EtHc5a 7a3۱R0 u tF@rѲtu!WV辿 ^_ 
?oG0W _ouGG d a `Zj	 QIڃ. (.[NXu}ð/؁ Y0%@t	p`T[FF!Gpu Y÷sssQS&G&w&_t0B JKu[pr&O_2P0 &
tuȋcPQV2
$̊FY^Y s0&G
Pp&W&w@
p߀?
ttHH,2>trssr&9p,uh 30p?s 

0_Gs'
 4G_.>`;`;9ëz 0&$F@f
r	up jǺt@+  4t<v<tP&X@F2 @&V` PetJf &&	7
aTugQc$<0tqZt2-ֲ u "~E aE1^X qۿѾ9.8u*fĐ @q}0aqo`A(  `
s6fft]]	} t̗~蜪$z $P ! 
Z10)0
VWSt#`IF[_^ rffV 2~Ê r:<w4
f	r**uf^21!Sf[f0ΠV߀Аs0`t*Q!.LYt  u
P"8u^ZqSQ"s	.S[ Yrߊ̀vX1Sf #brcŀtʀ tO<` |rCQvYr?I`P<f;Xr-u$ f.;vut	 `r_ &fYf MRVS&\$t|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQi0e.DYXuP!
~[` 0"Rf
2f&ffȐX&e&} ]@.ufp0 tRjZt	P "  t gHK%Q E MS f+Vm;P 	X~^[0
 |^9kz5S
B7^HK&E&E`JE aJ HK$A&? >  I m  @   	 -`pPP 1-l#	_@PSPS+׀1  p!Hs>s"1t?7J>S>.97I>r[._|E#[t &fVzGP@{5 ?.Fr YS@;[^u;t;Gr;w3O,?%?tFt` u&t?%?o  9{u8s(߃l6&=	rCsC	;v2aSS踿W0| u
۴tPۂt
 {u[[_[!Lf1E#%Kt&  &Dt&4RfЋp`D&Ft5C;v+z!Q \&Cr AYF⽹ = t0U fھuø RZvrQrg  {Pa YPVPV<v	 rL^@r0Wbp"fP@X2AK?$_spíd

f@f^Rb<w 7PEXϙ
sfBaf%
 f;w̡RRPPti.8x.<u`Y  Q2<v+<t'<vw! tưtBZSul0gFf
QXѽ .@
.&i Qs] cPQ0f!>P  w =YrVItӍppfXufэ
p$0VW#sB d@@<&|&\CrwPXu 	 ZPu
 u^ޠf(f 0D     	

#
Fr=.t5WC}RMu
C#C_2.@S6&[X<`r<qwRZP$< s#
S#(S[2vESp%RffZ_fـ 4[ڐP@.ХfB詰.Q VfqS
e?@菰0|a|dsdrdZsSuNUXpz5u p2ɸ,"y:-]F+<sau\U÷ zMي3
x`@!2 o;@"
Xr8|r !8Q9uUӊǋz% 2mFVP3Q^O9 L3
wN tWP1 PS ^p0[HFY.6?~VWR\Ԋr;~s8 ~JuZ_^N t0S[_0h
Đ>2440RGVz 
  5r@  6Pgp &PX6`"2PX uA@`2RZ Q拄P薟 ؆! PߣXү P?n0CvR	"݀up2`@a dsUDtM/rEWfV.4.tf^.T
f^&} _w(&
&U4\.9
u.9Uu`fQsr
\ r2DfQS}u>p tq u0G	> 趓^rt.d.L&e&Mf^_fk?@Q	Pf3fa$'tPpf@_fXf%b	
f7	o{fcctPK@C	Mb+	XMQ!1	fPPʾIf.VoffP1uc
 qu
'ut^sk  p̨hPB͒c% '@+ ϻ ס(@t {[P Pq*6Að%	& o u"A#P0Z	tA ^	r s  	t?@q_u
_w0l<XQVW_^YSp 	sK;`g`6@ |P  @7 39 	faVfW^W 󤀔&  &E _^VS3
t
<a|<zw$C[^V>    a|@ V$PP2u
at.:u}0?3xV ._^f.<Inteu   	  
 	 PRaPa C` PB BםA B;rXa0  .LuSbm u [.L|r4Or+f& Z/  ,7=f;7mPw f31f.f
+؀Bf9au	fSfG"ܰ_wsưA@5p.>Mp୽M^I.MLRf6 0.df 
00.D)PR.ff.` *N .FFMȋF 
tJHa  \FACFA _R '䀀Y`*
  S#jA;
r"1.E_0/Vй#$<1PG<uX.>Ot  p9.O< QPnXQ{1RFsZtF"$aXQossSttr	rg21RD؀t`.ȃ v(.жuc.<s.tFK_f u.t-.5utП."`b1
.ffQ̀WY   ٠JY,R,7P X ?Iyqjpm0h{t	Uhf' q Qc6 ?@J*0C6#tԎ@;J Sf< AS1rSYo vs40V+	3]Wk1s
,
rRR
RZR   $ bPBBCZQ
Q Q?QapfƊ$f`@fffwX#t
p tfpZYQ Qw `  	Qqt C
 tPP첺S 104뀛@U$$`2`  S S2䰿 JgQZ$VA$< Q fYɜ,u@R 2  %%Y;}YpuS
S` 
  `Rf
  #P  Ѡ>!ftsrg QZX^־Ҿ 7O&0A&k7Đ1PSX""
[Xr(QCf4'&&ff<QpGQ` K pG+
%fS+<+PPŀ5 &t@wۡ+2u-ffȋ/#ff#Of`	Xq5fQ.P3P3.-RQ- u fP.-fXP#ك#[uX 4a  *C               )Qr|rwKAH"6@V @;v7~Z++Qbbb@'Zf+lf 蓱MU`F 2u F . QFyQ	.8\uE.T;u	Ff-	 ftf"u
Ff`!
uC⦾E.  D 	t "Ÿ ;༾f9BaOf^a] ns(QN.SNڠ{ƒf^@=Ow_DSR	?ZLr8t+t P.\.DQ" YXsÀt10׀Е^ZSRWUю s"̰f_&;u Eu&M]q _ZA`~rAl?,;r1;r-fQ&
 =0fYuaQSR _sRZ[AR.6U.8u.| u
@.;6Ur꣞PVWrEDt	*tf{
f^O&M "9_݁V3t u2
^ rWVIrK+%f^u8@u*u%SQRPa0sXZY[s^_X@`ZQ QZ .w8u͋tYf$ADDfu
fIN30 *Et߃_(uyr'q50f^8rP$/<t<! $rf&E   ӻ΁$<<<fpRVr
.'|0#^Ȅ`Ȏ؎*`P$ t1.{\f^tB
sV! 
r.UEU
aL A(
  Rӊ(P` X Zu2totjkts^_,@sRSs+7,u#"` Wf_ZN^uG9Qұ   pm7 T/R.
D;t"t4.+0.t&.
,!qKKr.
,.VZ<>ˡ#W?7 >O tY[p!v9ϋ9 4PV(<"Wal%u=Wf;8f8rUwP2#u<` vtu=p 1D?aZXvNa_ڠM.|PXt	.t8ųo  /d %A0Pm%pM  2== Ng@kr+q>t"s	u
< u	f3 l[[ptT(?vB@1@fpQWSRD[C; rQYs
U1s#f@R.\Z0r$qC PNr. uP)"X^gt}XwefuvVW[UjQ ?Y s
 rˊٰ6.&;
Q!Ys" t_@Xt_t	߃@/pf tFQsf`s%;sH`јf4c03vD0Q)@2sEuKHKPAR8Z;sv`Q]tN `&aTa/a[a t-wǾ a rpÀ  !vs*s wf~;Ps
sL  t@ffRZXQ  ;v
t
  C
 7
`( pu1Ʋ݀wWR TZsNPlp  X.:@u0.> u(J=pZ0=pw#kᬐ !90 ;~Z .	fvfQ
p Z
@Z]iY4!Hp	Z3
 QVWfvfn2 	P	-rsaW& g/`J+ѡ ! 	
nV0SrFwfAk@uAc .`^PPPPPPPP P!P$P%PSwf3~ca0It3 mZQrt222ۨ#P0oVp
t-Q2te.ttְ2t!^[J0> ,Q G@PQW$<unvijRfZ`etuU  usEjtz 
s3 @	<wPhXs u7fV QQ+_ܠV
t$ t C #;tt@t2MM Ƣ.XW4@uQSTeeeff.f4fs4þes/ðFF3F :{.>fQP!Y! P6IrR Z)ߊAB Ð%	}2^@; vffg1g7gfggg
Tf2<vS[[t*f{_ +@,f^ڀ[#t,$o
<P࠿10߀1/ ,2s2u xD s@a þ/.p ȉN@jfC+YfSd cP] nf 0f t7f<)o!vff4Adf% ;[F  aw<s	40Ȧ0=ȃm 9t(K\DvBeH˳\!\ɳ\ߙ\"sQ-00
s Vhzhh}h@hn@ Wf_fVBE/fFPOA@Cr0f« f fߧf+À ?f
f  	4}!f#$01p8u2uA4 nii r_ 6SE5
Z<_u
 su7`( !/ -q   0uRS3:	[Zi+S3߶B:u}:F '9R l aq@ PQRV ti. ^qptubA	Oxr!`19f t4W_s)v!f&= `&} P &G
Swa`St[sSRڷZ[ K#A3ҋ>9r  PZjjkF6
k< w S.7j[01N޿Atcr$? r00H 8
@rS# ǈ^S2_$1`08t\t!H1k	PktwoAfbqrP< tD a2<탻MID u    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS ~ Corpoion#ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq =m$nooopppq	qujMhmf
il@.<t.:u tOFûE2&+]Nut"OW0OESA0O qϸkfZlfPߐfXfQv4h9t/P@w`ltfl sl trlxlfYfS_uV" f&E-  ߋ߃WúQ .U@Ύ޾6lJ  k fuVO$FJ^  uڵ ,𖀫]@ @]   ^'u; p pnҊwf@ơCrf߸
 re@@Qf2tmQRf af3ZY 
ҁ
ҊYu9]fk
l`,rRvFPSW_[XF$:Iu6r	 {@PpƲt
u%uބd^c@ͰLr
PVÀ>IvmwdtYw@t$;wR?$;v@f1Crݺ  t@Ѕxpqp#qQqXqzqR倰 ྒp.$f bt*R@	迠ZP	Xf  ~


F wf f` /8ta hf_I| B	t B_oH $*ca6ݿЀtE#>\Sw1gi& )ft:D)vGwAºBffP S }BBLvIT 
RVIۺ P!p:@v-8 t3
@oQP%πs`ZX2fQf;BQP4fqU`fYRDIwR}]:T`:TuZPފ̃X&ETE
ff'
 f@.; #fʶ  }  t &H_HKAV:^0w'^BH	
ea^K^fAǓY&E@(`  q0`-
hHK|	2.kȊ	݀8u!$?
A32IHݨu	p3r
v.
 @$
yslݨQVH.|g^17uf^PhP%iXv.t"{'{.D@t  }Vl^{r
 
2ї^û< <#t2 <"t
+ <!t  UP,=.	݃ffX0u7
u.͊Ȁ
ufP0;psڋиO O }Of]Yˀ u3fawy*pMfr-輦uРGE H@`uu t kudu^sY8s
tQG8s8s8t3 t-v&8swˊ
r*ˋc
㉗P8bu J N{rPÆ2ۋ !iR
tBi1`2$b&LNذH<v<v	r	e狕P F ^\`{r{otw%pvk&J`֋&O^͋sBuՃr' wP酓%u$0<0 t**F Ɗ
t*02P ؊š	a>`@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQW_YupD+ 	2?@
2@PP *ڀ n@
  toʋXZQ2	/ ++(+t؋X  + 
"a݁ǽBtG:#sNOFGuxsOGG$	Bw y*2䠃10>K , !+ 'k'ȋP&1du'`'"$4$&ǽ  %2{C3 B"pCR S ػ@
0Ȯ'Jur&^=ց3Ju=>wPA67)4&	55Fb1(Z6c5 XqJrv
t-r
 <G!M`sw r
XtJ׭àQqQ0QP2GpB2E tO FƮS PЎ،Ȏ 0u.&>| t
Ò$c-0@}ȱ\,ًppRC&ԿPD+(w2 _6t
0sus@a#Pb0 2&<u2ۭypWUƋ0t
Ju]+
ɟ]Q0 wLп㋟Paz x`֋Y$Ar!v$$ǀu　?60{0Ql$$s$guzի3*8*0*z^OFH,G`/${԰ Ë?*a)p
y$6| 62u>
xĪm?í&0  &_0%Ê)"r>!Mu:0+,Yr3,+K'B2NĀu9@ZZVWѤ ts
Ue_^GMu ]3@ø&ҋ$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>f߀  
T @ٟf'@
 F$
 =r7u̊ PW.ku>&}JpbQ_XwLĀr#Yts-" (&"%
Ī&#Z
r\sي
u7!~y@s
x`ALou1x  w|
p!! esX @
Off

,z	0	2ɸ,"yNu6@	@	ʸ ߰(⨀Pbr$$t<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [蛀D?rp^ʊ3ɸa0
OuVЊdЊPSQRaPaDXaZY[XR*vn
ĀՈF0F020.7Pus	|	;<s<t1rtJt0 2ۋ&<F 4w t3&ee!3<
EQ.~=T  @@5 ÊTP&߭0y Ou@ËÀ8 0
1>ǀh  fnNË̊ĊNuúq 2Fó π?} Q ` KNuf&KDSRP$?.&P_RP R T[[c   XʊZ[9P̊XPnXP% ~~~~l|8 8| <<<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8-p
~~~  Q  ~	 0``0$BB$ 

` l$Q  ll  l ||f6j 8L8xοz 0 0```0 @  <<f000  || 8x~ |p <| <l |oƀ "|  ~vH  a0!2  
x |߂ ff|ff    bhxhb `~ @< p flxlf bf } ΀؀|`W||~Z<ql|)Ƃ  O88l#<׌2 xp``wx  x -w/0 U x|v `` p 60x00x3v|x`lv 8 1b 7ܢ-| p| v | q$4-4 ֗ll3
6|p&0d (1B {00 # vD?&qp]|8̅
|Q!f!&88 `x`:|~~ ~?΀)h".a0%||`l``p9B~ ?p
h
6ff+ 8<448ll8 60` U6F= \E1>S6ll6W` l  "# U=# wA 4RT d  6 P 2[ 5 NOqPt_U1UQ2d770?rd?%0aa66 R9rja	
( R>     tv Q@bC8~llHpO3O rg8 s 8||`rTXl( <s"CBfa||"|ADPh"  l~`l~ Y%r[& p0joG<8p(5lyp}Xl<p&Plp~'0QE< (P< c򀓂ld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20 a4!֕BP{ Q|`Sl8>70k B @sV &
񉅇R`gcZ8|||8鋊;ff""nAR	+p+q`llҒMv	܃od  ä5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%2#R$F9B@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu 3'$D bBЦe  1d23]%@`aB= ְr;b95Qp$R "ëӬ03*Pw~Ry Ap otReۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwpD) ew) )ü ut  (Yǳx 7ȥWU> T 4s ^S̅d s͢Ͳ5Uc 	ֈ&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx -Mo 
/on 	/Oi .Mm +Ok /Imtܠ k$5Fpctq =FTfv|| 6<]} RRfyѯʤ<؜ p>| oD$09HW f!"#Ĭ$Ӭ0v?<Ë5þ&) ð {	!S{ P 豃{  1 0 a.&6| &>~ 
*r
t	2.}`Ϲ     ! ߀w<
u&| ϲ 2.⬉^FFF3ҹ `P⦸` Ц ʦĦ X  * : aQYS s2t  [øwq e_
>ctO/    ^^ >IЭmsu
^ t 36ȢJ2 Lc&̀>Iu	B$P
	JX̀v`
p uHȯܯ,tQ @ rw
2F.Ê.̀N$F $FF.q( ʰ OJE_yt<w$u 4$
p À0&&߀_+Q	_@Z<w?1A tS?H[
!&FE>{q<w$#@tÂ u5Bcb? ȫFt^#!)#
 艣`8 u{ 3ҴugĠtb(u].-ŴQYR  
 8 t$8u
(
=
28u2ɋZ aR23Z%t<vÊ>bSu
㋗PRYNVQ~ċюF&<
vu^Ft&FVRU v̒,]Z:Jr92:6v/RS=b=ƇP [
nZV n{^^YuZS[
<t<t<
t<
tx@(` t
t$0<0tu~r ͉N`u6$s%&2Ft0 u*ш})s&:s2& # E  a  { t ޱu ? t"<(* II `ga!īI<v,	..߲tI<tE2<t?<r<v7<	r
<v/<v)W  WuCt	t`2ۊêSP
@X[$t   ɟъ$`Ip
P4
Ī3RQ$2.kuZ&G&G_t  
 &_ët%
&;G 
 2     @    fPQVz fVf.Da 4f^^YfX< o!!14f3ٟf^FFfPfSLfa#fff f f% ;u@[`PSQRQmଊ'YZY[Q Ğ@YbLfp/Pf..7.
CCRRt!Q̀YZÿ67t&p
t&wG  x  u  b螡2
qf 虞Q3&&Ϭ&I1f P tQ | fYÀ蕜VFF30^XtJxQF	 DYPRfW10f "!fP   f3轿   0@P sg  [蝗u/ P
Dys-pCR
* w CA	  
 f$ a	i
Oѹ`F0
!3
ɹ1

f[X@f_Z) QVVķܗ^B*&5!&&
&^0 &T@}pRV0&$F@&FȁM  PX@F2 q`^ZRDMZ@ $ĀuY27V5Ċ嫊Nu}^D7İO~C7R9f<Z4QfV6Wf^Y55`4{h Ys4?t47t4\ 	4c464
rKQqc22U2222پ22RV2쪿B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              Ŕ!!!!!! !!     #v1xx">V==8f:=,=.=@==|=输===y==B=0==$ = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2Št$Жf`}$Od   : ̕ĪaAUcPC蕕P@0 @舰UqD"nX# 0] 
Wh2  ,h	PxX^_`. fȎ؎1)`.>f; lf3AHr(|$utD rBq  m.6rPgTP r    r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m|p r} tܰUl pAw<f;%*"l r&;f&_HIBM
fHQf=וQ
 r2u&} s
PQS1[  T<
QW 
 ftV`^tuA_Yå `VUB ^
DƣQ&EǣSￋ\ ;v++\Pۭ{=;6Qs;>Srڿa aǾñju6萑xPt'ࢱ ő+	@XPx N ð  t%u7貈!Pf@ۀ> @5 S襔[ 蝔[ f $ADDIN30F½AIM3b0A  @ X@  Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Sf.> v u`pb 0p7fX 2ZY2 о^0sbuL.;w.;v
RWfVvTtOBf.G} uO"Ұu0R j`ߒZRLZr
ۻ`
f^_fZ fV$< ov99fb #U}> $s1 3LXq_S nfVБo2П[S @t 3ɐR}Wt
_ZP4.$ W4J0_ `@n$<u<.\.r   PXf۾TA1f۾`1 "`Z`@.&=
U蟇s....@  "UO  5\OuyRK6Vyf.d..\fQ*yfPYw= r rL<&]fff.	\. .FG@ Q	3@ @.G$0<0u. apfVf.t2!.1f00uPd HhZ	f^[a!13KfugcФ6%	 ͫQFD4ӏ5VEp˫˳K̍}E	V  Z EDPŻU
ESDTY@ " HD|   H 	  
@  $ 6 d_   IL  K B W	 @ , "	eJz ,,ߏTg[ 00?
3

s i,,6Ld@Xkl 
 
PĖ` q@Q@k!n v lC q \w l @AEq@k6
-2-3 A  ``  3 dj 
=z 
< FL "ZZ  L  "V 

 ?E +S   
E 
y 
O 

SZ  MnE(  02<@(@(<2 3 = < @3`= @<`3=0; 3 ;1 0 w4 >`; `4@> ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9}  6@?906`? 90@06} (8  7 (`8]@7   `07?7`0s `w;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 /0=p    
>* *8 1 )  @? 7@1`?*)   2 )6@2ޠ*)  `ߠ2@( 5  3``)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0~@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5,7@-,@ 7-@,4-8 .+@ 8 .+ @9@.@+3`*:`_. +@3: {*  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ޠ @? /`61 1)/)1  `p< < + + `0* `"0*  1X (& @A &06DPҐѿ  萠ƃ`y f%ѣf=uMXРP R@U^>fu}= w
}w6fQWP;A3a_tf
@@$	XQrQYoQx_yf U<tP<t
!c둦RC"@_T2. t.w[f?7?01ˇ@ൣנr[WRZ_Sr3!f%mSOot]@f
qSafP2;j|`2f2 t&2!@t fXf^q 
fІB[@dtWeuVfvPVfD .8ttFfߥ ^Xq:=vL= v^˶Rp fP`
ݠbu$s-u绢ǒ* <  } Ȉrʠ+ Sx[nra
j  ! R b r "2B !Rz rU[  R g V
fƢq  %"
v
r 
~ #·ǒ ~%B
  #  #^ Ɣ & _& F $ Wظ z  e Vf @оλ Ϲp5?`	λ~aS8; u	[XجȺ01J f@f۾pKp G 6e^ u4a/3Q^ع ``N ^UV !OfRP3 (Xq/ Ӂ M@JaSfZ8t.L
#a"=5 ScAX-$X;áf10[a考fDst[@TQgҷҏӕ  _ղ   uOOGoration Generic Device 12 A Oas߅RU@0f^t!% sr*
7@	{#gTÿ	tgQW&]nrfS+
f[r$
eY00ྠ  @  8WPX*	 PSf@HFffڀYf t2Q'
Y[Z qqvda%aw{qwuLff&
T[ZQVҹ 0t.9Tr.9\r	^Y 8t&;Ew-&;]w}' P	Yr;rp zQy@m&}{u,p Au% uZ$&}&Mx[X{t
n wb	 &E
t&E&E&]QW  _YpfQfZrVA
Lt
u:;0P$$X7x쟃_^"uȰfu<u렆u,D|v'$<jR QrH&
5p EPP)
~D].\z|}fX/wtp1_@hB  ()bc./1 2@4 7 8 :; !  ft	C R Oչ cչ {{ Uf2!QRӹ0r8r2 GrZY [QJQfS@R;$6
ðaLY P$@?SQW:0tPQrt	tq+&#E'E_AQVfS)> =tPS.E= s
`	z"2BRbr#3CcsdtWWUzV  ֡u	 
 fftF.!f?SVй-c31bFffsf   fOf^ь.u	zpҎ1ff. #.p%^us fPϊfXϊ'sf# EQ Atpgs1슏轊jNq`f3*ryf x  7 r  .`r\C`D &] tR@   @   p f&	Ua!cff3J.D;<	t#<tU<tQ<"tq<P `g<<<<Јt    Bf 1pP
t
0b
@@t^@@"fr   ?  9 P f@ tϱ3T`i1 &U&]#mA#
@.&8Ujqs
H.9.9&EVWt,ItN`UO0؜FOu4W^KVW61A _^l&=@ !Cb_.E.]&ofRQ2?f.U@9.Kr.&J.JJ$?.|^0;ok .I$ s\-VPm 2Ɋ
.;v.
fr >~lP<0   1fڹ/rYA0!6 rCJt~r3.8:w
:8 r.7P.=q.;4 W-c tEG Q[tmY`V_)a{8Xffڹ)GrESp^S}+
S   P]\&_]_XRol}.|q8&E @$QQ.SW[r}PXfkY1ބfP0'`Rt uuZY0y~P?X< t c0z [#w[l #
RS6[rY`_+rOrFd	ar;QIoYu)΀t"tt
rfPxffXZBQ t&` u~r `tt@kr}
a t;( A8t(grWa1cx0kRt#B
 `Z߷ef1fs`j_Z!Ӌ4rR,rJ~& nnr4ttfsQ1I%ipGG] HMQH ^ ?࿹!|0]r\E]fR`f&U ArwfP|RrBtu f0R%߲K$@pr!t"t<u #3Zt
(v6 {#ps
r 
pGr<GRSڃ.[Z[esPR$ J4
ZX豹R|uuu4$] " V{s^wYf(>rfu rER.f Ptf;u,s
2tPw s1tfF ô6`{bQu>I@UX]@PG*j6TϡT`~ U$a? GmOOH z  R UT1p0Xl
tP) .8ty2
tlt	
t_.
tr
q<wffWSTGJs d5Ǒd`Ls1S`E%sf^a(  Total time for VGA POST:   Seconds 0.000 
 initialization < 10 Milli 
 `fUz-pff.@q.k.C u A3)7YzaU`1Ѝ1
h_k0J@f]aPSVD% t9ȋt,.@
.8tFF.L2tXs^P	
>
2.ۊ0:
gs4Lfy4@<
_gs1$f#/q53
gs>P. u
 tX2aDt
D2PwA"ʠ
2=wEr@3_hYh.>,uyKh2 ߹6pt$.p@gihO!@<hf.f.+ tiggg1
&t b?QW򠠯	fjf.>!˾
jjj 37  0@f`RsmpAf.!`gfշa
`+hf}pf moyI8 gAf+Xf-of!wffI sQ<h% fNn@.
_Xú#c&π `	 2?!ĊRZ$`
s$.NA 2	tA@
t*. 	23.  . úU)hUum_&
N:. e* ˿@    Y  | ?PëR                                                                                                                                                                                                                                                                                                                                                                                                             @      ,    t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  ưʴD` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7h@ t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhRBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwh\ X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &@&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hd^.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ hz:I:  3  P O O 	   hBr@῀ 3ht6BȎ؎zЍ=̋h3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                          j     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           - ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.NZr#MXu 6PNwrgpt 2rXĠ	 u v thr&3&E0r_" r}2vRs ÆUu
FUF qߴ	 lqv	 ӥ/H	r@el.		p脀'^F&?s߻  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0GEEabgVfQSjf[G!fY^f& u#GWf5  2WXP'F#~r .*u7 u/{r?`. t8.>*w tu  2SrV ʀs`,N	p N~t$` t u/~ǉ~ %"NV 1	s^Í6P.|uLu..N`>PN .:UtaNaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVfv@dD @؊fA
@NP.eXf~a ȋP	rs$
2~

	fX!9
dD0f`v]f^PRB@    RPXuUW:>_]s*r  $s<P0r!P@Xup>q @<@`P  osXXty>cr -Q	F?Q	߸ QV  PRPW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm3
u
rl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00vMPSpsq D
>X`?D<OƋ4a`t~ a1t!$!"q1&0&PQȻؠRJr# SMwO "t 
`P2:Tt
 YXÀuOuQ,9a"   <s&? ? `P93  >P}_uǀ   O  NNVWi<ua<
uu*P H<u>*uh2<t.$SQ\A[|u|
0g׈|`jt\_^F] }
u}	< .qcQ܀}u}	a`~@uDaD$'QV 3۬+^YD &!h{f!ff?ffJf0^1e
c[ %f F PX@OfP~~$=r0&w)ІEfu fqu`~Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` vjaif`0ff} k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRK=A>$pa|P0CfQ~`rffXORpC{ZruAZr
|`hPR2ǜq4XZ[ô`S>[PS3K[
uX:aSQRsɄ3ɺIrZY+3p  XfPAwMSàp>T pKѢ   u
  
  t 	˻ʆ 跏rrηvF0 & O 
 30&O՝ˁFUWn_]v
 ` _^w ߃
?Ip   MB RW1a
$>1 D 0&= @
.1&FGvuc1v s1p cu#' x2 [2&O` 
;ub2f3ɐ t /u_33&8  3Q߆_ZGF< u  u2D@ 譠sN~ t
S"x[{@&fQWS h fPg!f8h#4` yf  j H  [$p`,fKf
0̀9fāZrMf[0#t5P; 00΋f% ;tf ff  ffX2f~|_fYASS   d GT q0E r7*8I4fff
0Gf R
aRfx Bú 4Z`EXfa c``d \@u7v
f<~f Q Ref%0
 j |DpZB"_B3EOu@1m$9A'uf`fQdft~" QBY ffhfaQfRWffn fRf3ffPtf Ou_fZYWr~!Jtu JQ;lIhIrVaFQ L G B = 8 3 . ) $     }: q_QП&GYÀ'ǹðd ɸÿfWfVfpmuzss  3f^f_ÿUYt!ۋ rA.%])%`%%^& &&+'z'or.f%qf UCESs=98q 3`69  1f!u%f#fK	sLwr@Mts` u=`VQaօf#ffжz+ ΂߅r1!SfRQ<t2f3Cr6
+聅f P0u g> tt Br(t E } uY0[fk^U@oу{`.4۾3tt
裃r2f`= u8_-t(mr!f10

J?t:R!4g&? t0zc詂]fR跃8@t ,tp
 u$2(Hp`u@t'P eu-vp(tQ
w!- o t> 7fAu^B1]Բ]_3q 
t g t}Sj偃`ri/p/B/RZ/rGU/Z3tt@B$
Ê B,B$t PBHZgfVoQ! 0fP,Yf^p0aBhBwB  BB$IBXB2#B*B9wB@y 

B	 见 螁 SfPŁ4fXpG	شt [3SV~_W  Ф_ W
t<5t^uf+rﴀf^_qrp5QRV3}P'û g Kt
| J=8u^gPQfVW7  5Rpxā>!mdD{@t@_f^OOQJ ++++
,,++),,,+,A-?S-f--a ///20W .2.:*tL u% *t>JrSP.[t 3P.[u 0*t*t_M_(EfUv"v t Ar MwP *.V PXF
Xf]h@ &A paj@!
`ð r`ipnh
	OVO*.6*# *.t.I.
Lj@s&  |0u `Y^#؁D.d.$m @u>	ã3j0rc߁Ot` 	OtOtLtDOt
OtOtOܑ

1*u	豎.<.}h ;$ B%ÁUu	U@Dq`R#Prp
fL\^bZrP[ ƹfP<r|wfDPu
 ѢqSQVWUP؎&Br& ȎXO*,O>* ..?>*@]u *Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^&?swa s@ `b 
 *@Cf&GCE QE~A*ff@QB SRWP讌޲ v]rs^*E<u?* JLuRE<sfQAM}3  fYr/>P4P.  EGώǿ R>p=./Q8[Ü+_Z[QW \.>*u5tG<tFZ=}.EP .&3P>PN@AV%0502̋َɎٍ6Po p0_SRt5ێË`S.q&Gf./Pf&_f&_ . `Y2 )Z[f?UfPCwTRS~f]Ô11
1@ J1q 1 10 1P A2 G2b 2& @ 2 3	 3' B3 S3Q @ } 4 @ 04
 =4G @ 4 4  P  	=bHewlett-Packard 68DTH Ver. F.0C 07/19a06P -g]  Z  l ~q oKBC
sion XX.XX  
 
  _ 	o~A~# w @  A у JP12 Intel(R)     rnal L1 Cachea bi2e	
 6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7C  ;
     
C 
  Ќ  DIMM #12#
.a~"Rp 7"kf @~-No bat y,"
1_A$WW6 _T`~   
yjt)Ӏut&ߖ b5߀& A)u&u#
u! À8W@ePh AUs RtY }pvMguG	0bu< u3uOQtru1 ta0> S:u@8*6R:EFu 
E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuEιu3  P jE>I q u	PXuP3 tX랓tS%yE ;ut0#)	&2!q =E3萪*x3;r.Dv+W+Xu432#*u!.ð-*1!	 23<Gr<Svƀ Ê,Gii{.#]viC%J u$
<.r!Lu24$`.ͩ2K#/iT0rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EUBQ C D P@SI Q S CSW= D@ E S }I1xceptu4 - Over_flow!5Bounds Check6@Invalid O_pcode7 Device N`iAvailablJ8Aou` _Fault9v Reserved	10TSS1SegmentPr nV12At@ V
3Gener~yProtecErrorp
q  1 =  System Ha!P#
 t
-XÜPR#< tZ fVfR6:9螯FupR9/vzn9蟿pcP9Yύ68{9tfÍ69j 6
9`fX/9T ō69J` 9A0Ǎ6!97XY_WQP669$Q&9Q*9p.9
6296:F
09t9诜]&9x:na*:_WJ`J:o@b	[Q, GI; 1`(0X[S	 m6s: p C8BBaaI\a$at@0 UFfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QȴjY`Њ  aÇ鋿ً>"ԃ > & G!> .&<'@'dQR Z
  c Z  
G XYZð
< 
7 SQR  ZpS r  `؋  p _9pS  Q!
 	` ,a@  `
UЋ؎ ]_a	@]ߋ3G
AF `P C0[q$9SR` $<u 3 0ؾ   ?fa3S RZQQC@VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYX0P@YP\UfWf&и`1fWg{]D{f_ff_]p_8f <u ~<  u<  l<c<@%Z<	;Q<
`QH<i?<~6<
-P= uX<`<<pXL]WfPCI 2u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYffPr }  u
N`o>  `8 s r 2fSRfPȝfXZf[zff\YF:5	vf s"s t s t QVW&= & s fPf&EffX T  _^YaJVWPwT`;t
X2 *W 
_ ϰ#t-X _^1ONp sP6\ѿufQ fPf}nf8 P8s2fYZu< uEuPPumuZODPPE EPP runtime BIOSVers.1  
 iDDDDEDEiEEEEF+F7FGFSF_FbFeFFwU .)D]D.8].6] "r tR.6]
ZpQRP<rt2[5$ԁ !Ȁ
  -{" Z`5	$ T p[		uR xuR] SUUm.VGf	`&n ^CO CWV	al *Z usà @: U PSR*Bt<r
 j ?Gpp0^r
t<t ).>F u.F 
   PQR3uAB$ԡ 3ZYX
(<PdCGpGGGH7HrHHP&` XW<rۋ= .F_Swt 
' t @Ur
2[e -u0^r!<P9	rr&Pb PfQs" r2.F2& r s  rp 9q	8 r 	&& rr	ô0TSs+&' @>'  sa$桖0TsQ
u>[ Wr%p$S r rq	 .8 f" O$ pQ@	Pm ,X,#t s-@tGPadtbpt t
@u0Y`
 ɦXr`QPPPtOXdYûQPOu0`	`Xd$!<!tOOO  q&@tPGЫX৻ (`<u
 @&   >!@tA AuqP!@Ё  , &w XV߁  0`O  r
 P<Fu us	  	uA
 u	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&Duha>b h 
Xuh@rX&  U 퐼u@ ϡt@Q!	 -rr
^rrO dP dXP $& 8t ߗ   QX uSQ^ `b+MH `*C: 8E8^01PP {@@X@30=MC* irajs\g&D
V &DtH 1i 
B 7ir!@0r_isuhF. uhhI$hrO迀isJKZ Shhrir
h,a0hyoiZ2
 0
FFt N fF"߀ B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)tЎ r4F$
Ft+ F P   !VPXWV@"0Ha0_WPR u	ZX_PRARZX  G  0 " p	`C  PlFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  0-As B C  % _eO  [ H	P 	/` <M O` c!OF	O pO ?}OCD001EL TORITO SPECIFICATION QCQQQ:Q  A " * Gxx  x y 1 " *
x"x 0K   s  w_X _y\[8y y  b éALT ËEtذE
U ʐ
 r0 t
r Àxf`!qi2W &  d_&E3B&U
&{]@ &E`o t ûQzu0&E@ !fa1<$PnP!P=FR gR ?NR  = "fPff  @ fXtfUfp fS@QfRfVfWg]?rdsff_f^fZfYXf[f]ge333rVd4Ad^;sgu~` 
3 sM tAt<VrdDg_}
^` VWa^gEdTg}

0}gE `tr	 	t}d8 W<yt0@Dڦ
`PfUf]3
t P$u Ó' sf.;Gt ._
u fg6$+' +k$PIR    A >` a b c %S @U   | i 0 %F0j h`3. W Qp
_ϊͻ _}p aVW TS;Tt[܃
 [_^!W3`  Qu t`GY[h /$_APSQV.T  3ۍ6 T.T^Y[X:  4cB C VVV
WWU
Vg]fFR tDR,3GR f0]$
U uUeCRY 3   p4SQ>DRu5Môu% r!<	Y3ɸ 
 3Y[ ?SRVie&MRjeXXY獐&t轨t# 誨>Xp:MR<t<tXƝ< tp.3^ZBXV  |X@`uo P	bXir
- `CZEXQQo =c
udGRDRFR2dà6U uP_Xd]<tpL r
tLd?8D^uA"RWu6gTgs T^u%#`|O&
yt,ـ(t&M1&G&acc`cLAAAca+Íu 2Mȃot
 Q ܈$FKu/ð QM
u	ۍY;sYuS؀u tu)4  `9'  `'pBfߊ$f
f Р)RWS22f0 YrZ u 8s܊[_Z&fQWRfP
t)Rr ff  u 8ufXZ_fYP3 r3r: t+aw4 v f
tO{8t	
uY0	g&;t4g&Ct,0Cf4Q|<vf fd
g&:# zC1	 zWy޴r7fg&܀	f`_r!f`Gag&O@` Nb O q,|_f[Ã.Ot'}}\<u 2eh`hSk1q9qs>w+stGos
2  憚"  |  )l \.D@.D
;~ ``?[&&D aø0 м  `j ȿ&&E  3Լ{1OQPTP !X@`.\.T	ώ> R.L` `8`a.D`6`aQPߋƌМ0XX6aùU fJ}SMwSOpS{`SNU#N f0{ d9Sâf> uf   > t&sr_Vu3 Pn`f+`3Qf@RYrfǳQ	ġX*>u_fP sVR
f6u1 < u;thrR> }RXaSW1-  
` u #h $t$?ah@ & r 3uL^.6]M^3!' $ ܠL0I<u	.6] u<x t$\   Сtu_u	V $
4 gcS }@ u7:<u`S[SPUNNNO Oط$7#Qc#j_+_9_"_  Mߣ Gw p_" * 0e0qq|p|0A޿b,cU] ދUu" ߜߢ#îJRQ%ފ̺qY {U  k! @Zߵ`  (<sW.__.09_23P'Xs`Q[]u..&+.	p[ @ t^P@ .&u @ u42..
t _wPUU** &u XY`D3!P A3.{Gp
XPZ *.ZrWȎZZ_Q paaaaaaaaaaabbbbVS3 .:*au.+aK @[^* UFPna2SF۹ S.3aF[C wN[QF ?t?asF2~ tY@ ø7oM  _ ÿ8PM d`dtC7JA۰`0%7 3`7$ $ cccc)c<cScoc`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233pabf>"  t" P a2ۊ( Ҋp ) ǊȊ&)  * 븊* >+#1 d>},0.- &) r.PR u;t;6X6 6  #3
t,=
~
"=
 
0I5w<t<u FÀ0<  s
Ê& 
 <uaw\wWQu& ` u5ϰ`!Aۊ &
Ø4Y6 FF;t2PeeedS   Ya\"c` \0ba3ac] daRR]D-D]E m]`[\!\\{\Z\M+t\ I|\Z[ Z9Z Ñ tP"6OD_  [gusU I2NO  
o$c&E
WE   F˽	P>]>N
R  R 5S U U OW  OWQ    U	 Y
 OW OWU@1ABCP Q OWS OWT  U V WWXYAUZ[\1]^_  e` ea eb 6fc Yfd!eqf ,
,ߎaJn@Pd^PSQfVF! 's^(2۹   F  +^D!8kum3\f^ WVQCuKEb! >`!0"w $I^:u:\!u ['r' pY[_Sh_N.pvy CC@@`RZQQ0<:rd uP oPH 0=  _r q& 1PfVpİ:`gfFpXRyZÜpt	tPv
 vt[@| Ѝ=̋hh~3 Q.F.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSSQN<tt	fPXfPo B  Y ί Q؀}Ei!2YQu =sY<u,fCISGu%f» f P f_ `&.>i ?.iӀPS @`f.ujkO[2!:.ujf`фuhb hR  趿uhaúB   $EDÜ.uju݅RVP
x 拔 tcPtt>@ KXSx$PQ|Xr$-Qu!$
BB -JJq4HX^ZY[Ϝp$ qP/ 10 3Ҵ./@32nuo n} Xp'Bp'|' -  t@uTf`0D fft;  Qf3Y_,65 ! faH fX   QRfl f@f= Pf3p fl >ht &?  Z м  GoA0頹pv@/⯋r t4t p`迂2撰PɆt w JBA"<t$0]AJWBqpvBSWQ  !tу`Y_5A9XpXqXtX	  " "y_SYSID_  n _U]U  
P3¿x aZ $PMM u % m                                                                                                                                                                                                                                                                               i   
M    S    -%  ;n$$`fwy?hAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- a6PN  @ t	3!
tr ^	
F (|r
 	u^'Ât %{1+	d1*515诌r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>O.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20s^s6< s
	OtE""Lt*$Ot"#Ot%>" 2!)A
 ؀	.EF2	
r]wsmsߴ1I9  <$u2 *<}#"< u<@v<%p!2 ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZsSQtP^Ë^6O7Aؠrf;	DE"z~(LuTMs fPf}3fXr1>P4P.  .GTώǿ R k7./pP\73V#:Ttt<~'t9r037QEE&3Pq<DD@ % 5v7$~6P 6u0fPfS&Mf./Pf&]f&} 
[!
0'Qf謒  r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-Vދo^@tffm_ruLr Yr)8r$c?r蚑r"Va	)rj!PTPQX rpw
uߴ `fSfRWBt:ـ?f.EffffAUffsP-EMF F
tSuNff3fifVPf.WP*f8f'w*f'F'*2t*f
VvfVv 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюߋ go^ZYpB`SQRX0% [F m `7{h. ďQ(&Q Z^N=rot
r`a r[v_">O fKf}a`, 3S5<s-PO8L9
t" >OG<P#<Q$@ dOZY[PQX hv   t`rzru3rij`wNurWu
p`dع 
 Lr.Ǵt%ttt t	tCHa% su~r	 2PRwZF sH<t<)t<(u;ь>A u/WU>)`]_34r0蓎}Cyq_`_^a'c`&PSR 2Z[)ÉRFtN+P X7D	F
+ȜCIH@FEF
t

`$PXfS~ t=~^f~^߈^~7^~FF
>FFF߀f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^o
^QEfYSQKfPv j 8rC8sfZRfXfP8Ff>CF VvuKQfXr+_tðP@P3 Gp1 tffߺ   Rf+IYÀL@Deu$`Ύk23c
.*x芆^G fF! PXG t<"u<"tlV3޾x 4|Q&?s0  s& p  &G` ` G`t&O &O`uRp`f&G`Pa j AWQb b V Wsa,ZX7RQVW:W qtNᒀuu .!6a u/AŠ ࿀?L	
 t,6pNoAOGA&&d&D&t&D3p;_^YXVQ
} " uRP3P
  ^í&t{×.øJ!fUfQ  ufVK!rM0,u gf@ N V F00σu(gfFfff~0/MufYf^4]Ë< 3R+fQSfVffLfTfDfL !f^[fYrX@A3PXAøM øN}p O `EQfV1UfWfP `t3 SP3RfZ :_f]|^>PfW ``tQ uUPXY fQ PA YXt
 t$z`t /t! v n_  X(RfV_at Z > a(
2VSQWf!w#t   r$r	 _E^ÞQWVwy^_YV3۬
Ê^~y _	 e V  M IV1fffa .6]2fff;w	rf;wVf0aPS.- " J߸ f%3/aBRڨ@u$ Q Qذ1ڊ0= <r <3՜`ȠӀf
ffʝ0iff   f-?   f bW >E&3&G;r_yyQ <%Pt   1S& It`Q f`+  XfY   f@@0f⚠K4Z4f4f P,0RfWg&>tq r 	r
  u f_Bg^f$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	f#SF	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`~
t~g&`n
g&@
qp
 
u
g& 	TA1P a3R@\&^q\QU "
߆(2Nao N*`uWt=u2
f׀3e׃ذfװe~׀违20e `oNqa VRPtxSR _ڊZ[  Z[K ă u? )NȠ֢փt% s0
udfZ^`u=[u8qB 
ً@Mp M2} M0URu<_[u7Gtf)zMsMkҰڱ

GǴZ]PGbXU 
 s ]`K:KxSQ3>YM tM>rQ4wYs\ P 3Z[x0"uջ=`"P3
ݸH ^_LٸGiLS QL 9QK 1S
 pN qM LLc'@ 2p n l C  Ơ # Ԋ&Ԋߊ2ҨU
{Ԩt,pv԰ohpS$ztpgRø;
 D+Ԋаw$	2s s	2 Ե | ԰Ӱ ۰	  z{2Ӱ2 	ÀӨ tN :ӰހӰ
$pr
${0 Bx$2
ܖ7w-C A PkXalu@u k0 hP``P c R jp ˎۍq:МW	?rf+aSfW.ܘuOaUf Z$fD  ak?[ 2ۨu<@tĀut.`˸_ f_[Q
! YQ M8p ` PpNS%` +ð ;w[`Ym SRW*׿OзIr 2 3_ZRWQ,ԴAsNF Y r3O:3!RQWSP b	$< uX Q25Yl !`p:sX J	u}RX( V_ m 7	XAP)[_YZÃU2<UuX
8
DYJBBǃ   brT]
!uP _؎2
X
u	 6 м *ê?VWQP Dt!WQ:t
Tu8v
Y_#Y_XY_^ _SM_ Pq_DMI_ 
1  #9s P  2XPUv F t	F !Ff ]X"X
Ws8 qaٿP" i &g +Xpa U@}
fN@  ]ϰO2ðq  S\8&&G v GGP    [ !@   WÀPP Q桍\&_\p  
?F0 ]
Q..c3 и( и- 2  C@@ XWP i<w3t u*p O ]SX9F& Pn.__@PfX^2$31 o  pRrr4!@fqfQ8fYgsBp[ 3]Ou r 2=Au@u;Áp u39 u+ f?wufP@u BXu
_f`< t`%Ka{At{N2!|So{_ k@Q  ~{{ o{[KǠ !qO G{ P ~{_{Q   A7{3j{op446p.amf3cf=SCAFtVG t"ffff Wuf(#3tfPff;fXfarO_32_p9P
` ODP ($
з,aô%׽´+ýfaPKМʽJt* u$t0$< Kf`%D	}$] %W` +Qg$Gfa ră<
%	*P' @TO xOy Uer$DIsL :  h!                                                                  d3S@  l  O IFYOO  vPQχF 0 .p	˸`hq && f"ꊦ  ~f3z f f@s.<f.{:p >` 6a  !.wP Wf."""U"" !I a
#
~P" f3ۻxgf+ f`ffWgfǃ#Eg ٠`ܺA vT2gf頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7;wf+fa f7gggf}b	fP#ffa
t@@P	3
3y
ff0
gf3 ڄ P
@r@ȓ
A
@  gf3fSv̓ Š΃wff#b ffyZ?'wf3f30n,;wm#`~4ܼbf[gfM p2
ffP	c	
=
fAAXAP
Pͳ#W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffTp[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u P $faUQ	U F @ E] < t<t
<t `Y]}p4 RPQRbfv2  ^~RZYKXɓ>	r3`	x tt -  t	~  i09`K#r=s  "#@'@z18P,Nff3u
P t  f3g f'F!b"Xth$PPTffm`U^W3&\fPQXYq3)Ya~P'у`_ P!8 #	f<t`L< u#f$!ΏAPtfaPft"
桰   u$! !tp &k Xa{{ݯ *qݱݰ J#LLs@P}FF
]X `j} . j v
)Mf.N. etI4~r@5p3؊^)tuw t&Du .⭋^^;iaϠ~@t&ã.^2ڀ36t6^2. @ PSFg
t'.:t	tX._[XÜfUfPP XZ+ f]ffŝf]rPmX n跐  r-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋ_y苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠt&D@B ĪǪ߼zAT0	?VcH Urp蟁sʁ `-su fqt
E$藀Eab&G )
V Nh8Kr>u rG Po3F) Wr\ {r=oH r8QWss#

Rr
3 s@oM1 |#k###F("r#謲Qlr@rk20!0p 7×!r"!F( Q'&d&K0#V&f)&t N.QSWf`ŀu/ r)v{!ufPs \fXt_[Y`<t;f3f t	f ;u
utǳp`f[`
 3 P ܡ;phf<	8PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXۋN8NwN 4o2N蟧0(`00s觌/ mlpR
 r
fQmru$贀fY_/1++U+Ñ /&u b%trq? VQB  BY^	G $s
3
P&u3` 菀@
r
%uètàt <q66V&TЕup 
*&u^ô  ᆻ  QPXuN%&:Lr O* r$ P @uP<ut.@ ;& ; E q2s2p$<@[t22P !$!$qXw= [[>ĺ"߰.0[K<P  = sffP SQ  !衊Y[$p
 F@ 
۰N8tSFt f% f @f t0    "   t0@qP@fX
PRV s oZ!
J
8
0
$g4 Nff`4eA fu4fwafFDP2`a  tfFP ۈ^DPm fp]fWzfϞ`3#"fF$QiF,0 AsrBrf-1fv,v0h,U-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfWր  pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )Bwf*ݸff
fA{N
Xf%	3G,WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PSQR30? 豆ff%fZYPQRWSӶ3t"X  X
譆[_ZYXSc[  QW $@z __Y[`pû z
  }5u
 @ @Üu[8 0  ;Pa@ F4;@H0P ߈>%F5 N0Mst(BR'9ETDHP  SIMPLOiMOTOROLAVPaVS\~ЎHb_4P-ێs@^s˻ʆ >B4%g>D4 F4 H4
~J4@L4fSR &-&Z[>N4f>P4΢U4+@U0 t
@<~Ph+؋ÒcR4`W4Y4﷧[4v]4mp4da<؎&3&M<St<Mt6 6 
6^V`O ׂ*eW> U @eT|Ush 6@	-	$`

Z	e
+ 
r)>4&~X^ádWV1.GF< u^_J׺+BrD.\J0ERǊ}AZqER.ȊpMQRR źZR  ZYolR8AS؀u
RRp	[P PXE%
cE%	X< $Z	T
 
"
tg`gVW_wZwU
uQ6rEt> r2
tC r>  rJ ɣ
p    _^a1n2
u[rVei1sCr"tr?S '?;Wr6"WQ@
Er S#֝)/Te  
 `߂ Pt ҮK\	\*P')0\;#$ rIW("  k_!vP(Bs O55B< t%@r4;3r!- ,-Bq3ɰD@D`ó sGADw*VR@ ރ| 拴  t.Z^8ħP .;BBBX$JJ2JB}Pܰ\C*tJ ;*Xu` Gr V tA&q JZ  C@mA 젒*uP= ]Xruŀ̀2	쀻
 ) (8SQ2<

2ۆ.
$2grqd<ww0
u@  ` w0    j3ɍ6O.Lu.:Ls&3.D}.L~s` 2`r2`px 2N.߶ u K=^t
`3t t
t
u! 蟤)3ұ u U t>P.|` .3P _u}߄ P ߴJ}uL   u3puwv`bW_tURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ]Å Q3| Ys. u&	 t	&Uu" ώǍ> R |  Êö)l.f.|f@  3.|4߿ R\PQW 3N#_,`Op1(u p;`3薢$߆蟢 &?t+aP`)}
t 	
tN .:UǀV tMR?+Z| $p$u$$<t} t	^^ Q3䆊!*Vh P| ^t
.u&u
cs)t!趤Rڻ0W۵u3ێێZ
t	'u
u
 tu搉@s+XPt eڰ`Vbz︝t"@t  p 
 ް  XPJXSPc .+. s#. sXPŠ&   &X[fW|$t~$C u>
rrw`Ua `B a p 0`c+ SoQVf fp   ѽU@  
 VP  p^Y[u(PUF    f&| ^	Nu<VfU
Eo 1:RpLP	r=^ðuS@]#^[饐u"

 
 ^~u.zR UjW@w`UVJcL1YBS8WE
u&* ` u!f_fPfSfQfV   &=Ut< MPThb &Ep` `&ufޠ>f&&   \f^fYf[fUh &]S^ ][#&uD0DV& fȡAL
^yrlfWދDVva &   f`t@ 2fʃbك^0P Pt_ 'f=%ۃ'+a¡f;ME 
+ W?f.PPZg&G?_6E!#3cϦrRuf&T
f.Q,f_utf`@] ZStQY f0fLfpy,  !f^vp91f# ,;Q>!p$U
UEG &E"rkfa{Ñ 'rnOGw{|P_@10W` "Ў؎w`1#n@ @2K<t/fQ!oY<pD%PH
fȿu fp` Q_YP4v.M"fNg
w -
"|"#:OOP9DQ:	: ; X;Q.:wr(G)uP)D > )uf.p  - =*KVQ$$D
@V&T<^30Dory9
lY^C܇0 ~u0Ex0"VBqEv fS l(ADg(8PsVPWSPWQN P
P@EA2LDra
fNt^QؾS2KWM T;0@fP: M^_1PTN?:RffWfQQtT=M
Pe@UBLgALBRL3S G>`^WX!WuXX1GWiG@(WLWW[mHP&0P	3
uO`gdOp%Obboؾ:?!Q	TQb4`#SShS3Rq	)AUEfdCf`e_W3nÂ `{Dku_qnhQhhRVhh/hذmt؍`pjj|t= cYj,{A
1$pf[ jPQRG B㡀uZ փ־& " Qׅ URf}Q`vQ ufufQ2=fA<t1 `Q !ϱ n r.V sfYZ]Tf;fRff;fZ^`Wf!тrfSrf+pzZѧ菤r
PWr#|s
ua

K<f GM	rNrBaP_XPQr Pp$Ss[OBMI:E{/ў-JOQP ിLf oXE)t fat/+f`##fSfQf3< tf!L2"ZfYpѦUat?$7 3#tcQ!d[0
ð-@M!ľ!WV@ fSP~WB QKY_W
t^9PliPst6]V! <5u G	F^B^= `"s.
<5 = 
uO>r aϊXf[2PX^2Y!WfVfAt
P EMr&w P?B ճ `Ђô PIXs #J#A$$J$P߰Ӑ)
u $Đ ) e1U
  $
Ǌ O $z $r[$s) 3+ \tA		SYPðQ3r+3ð&QtF!tt	*tEPQ輏S&蟏"
ǆ規[ﴏ <t<!t
<P	<*!`RW~#

	`ZQRs`-P ZYjpD 
 ) c7VP֎ލvS<û	 8[roX2 F^a ð!; ")< u؃ tr
9D@- mJ3N|
u|	 *t0  $<<q<
z^À7" 4C % ." '7*ZPQZu @{!UXðLQVWP 
OX_^YaQNYP2b} PB2Cqm]
P'"4#f1uWðW521?	R65 +S,߯ðT,ՠ Y9@V-Z:.S0V'UR<*< 1316k3p9XpXqXtX  A  G@ @ ? " y" U=-Q RRG      *|[ A	 ` `  God d ",}q  qa aO 
p p  Gr rrs sq]
s "  
_ 6r= 	 
 @} (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Àu v5u t
&  `
x_t^t]t\߀7utF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾi蓇r9_2.i ukq G$!u@t0<zw, F 
t
F
	{t
w
 Aib2]QiSJ, E ?sG@2q)P
 t"< tor0r}	
2vPQ%s	} Z	iE HP   PRuaa@uXXZXp! . D\PXŻ PÜ= sr_s
0PSPi{ _D߸^ZY[XSQwt莈. ! !$UY[ uPPjQb;ˁPQN 3۸ K `9X': }B PE I" ËEu t
$}sr2t`tW  d_sa(    K P3Xú0fW%,  .s 8 0ff#ffg&'f  @] ]_ fRffZX`yt'<t#<tNPc  T M_ H<u 5  ߽%l  
 aS  \#&][0&VW3xu@ G	u1@ x\ f\pz%WVE 15 Sa "\X#=y\^_S/S$	ppqu/[HAA H $tupʰ$r@  [߃D	0pn<|}p͕畠llgs@021jjz     pu Mu",@;b Zf`g$/u (v$
vô$vvvfaVМvt
v$tº^ Kf` u'= `v $Zqpv$PvfaM`P
Xu!P賃<Xu@P要tNa`
  P@a  fV@@ ބuJ{n{t u3N@f6 VM{u^ uH{u{s@N`R\p Sh{tE {uzA uzt!+{v^i
&  
]]f^e`Ԍ/ $ $  GwN NRP P`Gh h"Gt1$  B   
G   =Q`W   0  T=`r 4ƃ}4@g 3?4 U  < SQuP $@Xu@p@Xn{$Qtu
?R=
ERVWf1.1V0qā căQ<VV<WU  ѥ0T `afP > f 6c?s >upf2_>f@J8ĳf0d%ĸOf .> u@Ĵ /R+quX>tGq`a Up [a u
I_^Z  < _V_ ؾ|YȎ>s1Sr " uu '3r@&[U  r.&1]33 a /  "3@ 5! $3&ؐ
@?Wb - h_ۯݻ ;v3 0ji3>
8_ah3\
3$Qfކސޚޮ`ofW3sAq<f,u#Ή΋p f3gf&ff=SCAF2_U< 0Q
<! F ]!y  ,<w&< t'V3ɊȈCF`  ^ t	  az@VV<v^.
t" ؋BfU  /]dm0U^P Xs.V Ou']UUA !  g UTgg"C_R`$$hUM < .%QNrAt1S.<[$ t t@t t	5@"2ɵ"#Yh .6M3Ê$uqﴀÿ s S3ێۻr?4ð|t W3>f&E1'_Q{X%TF{ u!uO Cǿ<2{f]
 N] d `5d{PQ3 }27y4rdr
` r`f }	p @ QR@TPQmRPK,Џ <u
 @ܸs귄3茾P.Ў `.afV`f  
uЃ	r Hr" s   й Aaf^;쿃`@*2Պ$ԉNT@׎Ǎ~WF$
&пFG &U_of
	虝arAuP t2R ZB_$0Z3  P    { { Afb Vgغf Tbt333aI uF;Կ ݀u	66~Vu%2"#(.[4	ҥ	ǎo
	ȤQQһ$ [ø 2r$<@Âyf~fR  ȥd Nptp' \註fpf.4 f                                _ 0 `~0f>&  ޱ=6a; Á 6ջ0#RfPfSRRBuFf3۰S7u"fV$
Ѐ
tf `uTwt"Ttt4%ffZf[fX 	QfWfV g&߃?tGffpbfbf!L	g&GR u#f^f_fYfB@Zn J)Kqf`0s Eeu 'f$
f`&afô#wffmffaRМufthf$t}[f$< ȋºZ u1A	)/f%fސG#ef$efa"*  Ӟ.:f tdu祐.f] gu
#p d1PfdfBd!+ s dMd5g}dwЗ J V0d1d<d;]ttd|d]^  R 3
' ' FǠ  F/3 .;v+GuBG
`F/ {@ Ë% O	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFSۻ׆[fPS^ۋ^&t` $ueG&uFtt6]逳' DG~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8Mx
~~p Q pp		 0``0QUU$ff$PVW0xx00 0 lllXll  l 0|x0f 8l8vv ``2[0`_``0 @    f<<fc0 0  || 0p0  x̯8`̃ <l 8`Np  x@< |pH `a
 
|x  ff|ff ll bhxhb {`f> @p x p
pflxlf bf ƿ ΀ 8ll8`< x_xp$ x0 փ Px ƌ2 xp``x 7 xa"x -7w0wx|`` Ep W8l`0
zv!`lvf0 x  `b  `~  ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
pou;Bf SvN .<2[]`0g i &  _
ld̎@að
 `
R3҄u  PZa TlAE eMA9Y.nSS  Aqb( Pg
`3ҴĀu N <tDZQY
 Ir8r502:6 v޿&Z aoP P2`PCI01 ISA`#+T DH03COMPAQꊙ 07/19/06  E     F10_  On؎h Ћ `h+3f  'o L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.1Ump 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6h[jF_d&  hE>#>RIW[1o1d% =_ ۘ2Gg	 v	z]G@VU?#
,
l#&d% H
$2>d 	V)J!fbfffNzd|dmafw>d1jut$UQ"`	2	zd		b	A	
8raUf	E
EQ&Ch	
=̢H)BSF "4zU~zdېFB .//M
gR--i*2z2b~V
!6y#Uz&-%"Ux6='2{FuM)kAh 7}d*]+JQ
d t<j9*A=<%*81djQd$#!/h  nbF  tAt=dtfh jnd$0!q_tfhLKq>t]Hft= tO3>2e tjh2eVfhI ;	9*b	$j h¿dfjCnCfjP1t<af {taffhQmg t1+gCQ	3!	f3f
pˍ~f PFPh龐Uhg"R ^Qh!3F``H譅9=#2h|eh- |e]od V025&	hfĐfƀ)BF'hh̱	tAHFd5FdxFBhobFP9@ sjh!j^
	 #fhgqa 6YI} u#h=d3V=d2O_0%h+01!?4O VQEs*hOn+h4DO	Q"D	q",^_ a2FF4g^ F&_<
uK) u&*_&8HgtFFP9 ~1FOuÀыٹ F FIuF*1 F*+FVh+;u;uàh% ;Fu	;V@áhG2@A99h% 
Ð;L*	
 WWQk
 Ffj hVSC}(-{ wf f0h0! &b&djLfP~\j`P11 F{Pa`XFQ+"AbPAV=ut_ V!  )#莡GF|W n02N|[z h &A F GP	FN_uFG0?7 

zyO,HF ^Q	A)xFRI
2 1p z/AU>WIU
bf?2%#Ƚ!	Ce	$Rʙ
1dorwh

dGN
 &]R",@9qFtu14FUB ᏍB	% !Cd0` a
"`b% +1b1bj_R!Ǎv3p%%mzzd1jAM` 	a-
 U
`h~@Ќ3z""djD
{E
C @	HT	N!,gN	3|ɳ1 ji/XT*jS
j Ur+@Xdj~a4%&ddr
x
1xtWt1jPf"q_Ft@@#y J#@z[2:p'8{Ѓ*3 &d{djT²A:@(5d@w_&@߈d 8 f&dqOrAQ<_& &O wg q	av kVUW HL
b 'fd w d t}JABL>@@A@bF!!0^Pw@Fh^F  ^F&F~
r
f?&f &H` &te^0`h0@ ~g^@ d2e@  vf# r Ւ4pU`E  p  V6P^aF@t+tte d,t^@-uX&ff _Hf . IfB/ !fpʀtv!t mA@߃0P! Hf@tO
te+uU&@2_&e   ` g d!r΀&dodwojktD@."#F|0   &dw.j }10j) w!"vwB &#rCWFгS
R)`B&g#&g &{gw5&ˣ +&C!&*&Ƈʝgd r \fhJ}9ZM9~dK9Df&EfaFVD!Fd}h
Af|e	s$"A4 +a=rvst`1u -Df EfF)@tCߥpj$	Tjg35Z	3݁ Df$ < u @<@/""rĸ`" g1 {v@bZ)T9433u3tH(va2MRYfaא0 p
3t%rF^Nr'~#tp  u^    % F 0ĥ)^@  ~u +ËFVVF6Ƃ6~ r~t` t uKFߍfv
0u.~ u0Rt
Ɔ psyVsr?
 ^ ^p޸!M~  f# F B F~P|v^߷ KF{ NFFߌV~ 0PHt@HtcH} P )n.Ph07^F&? uq0dv萡9>Se|nhXdΐ42bcVA=5dvodOn`
NNF@!s@&F!:hF꿉FPjRh_S^~/GFPv4AxFhFOnPAdbP!c?:!Ze`&V@ 226`b`~2|FtF)QW^
.5~5	.3 _.GFVFQC94%~ t;F4]F1~
z u WV~vN^p@@S
A0@
^_C
"j(c
l

[\t ,md(|WVvԇNsOD +H6C C~(|W~HHPKt_~@u"G#}HPHB^F&W} 
 J
.AΰV!u@## gXDi˖aҶ	
%%		 	F*P
g	}`	
g<d-UWVv<~P F
&GFqw&'$j*V~ߋʋv!^PF}GIub: ^&^&8t#^^}j!#
 0GF N% }p,-Ar  ~ߋs԰ NFN+;u0g0>3ɋF rPAFC&PfqfF ~0gЋsΠG^AaQFq ~
?vЂyea}r
CVV,GV~^&FIa&a8}1qFQ2d%p"V>QrBIUUbf?}8Q2&1%#B
= 	Ce	$b
*59RUo"ᾡR@FGb㚪 ]2}T@_`	j`@P
b%  zzd1/|djA 
`j 	aSr (T53^djDA{@E2	C
e@HE

N%&S
	 UU@g}3|1 jiQRabi~bUyUjzEJ	`x9*`(#0
T7
{2
#26h BR5*S W&d{d2fAf   |ef	 f  h FdOn؃@2p"􁚢 4 +d=dFr#d <(CI VJ,@zFR#BsݨpS3º)BZ3~Qx@P .
낣@>j6h`PjFd Leb>Iczr?#d 2쁡W 6u$>d 	uGr9׊.
oψd,X+Go %]@`fbf	ff؃fzdPTXXy2A@YOA \Taf$WBG3
DxE$
t
!C4
T?
RH_J!NUazd۷B j)h2	SpF "4@gաPL%b
ip/
~0PQ2yLժzxBB{V}d*%L!e@@>7F߱ ݟljh![BXWVvqދ~ &F<t<
brF*;b}7Ay~tF&8tFu|t<ro2$VP^Ưu	A(|Ð޿ ~Pfh#  J PF;rF ߀f?* F  F*N* vF}P0G0"vV
u+e4g^F  FOu)	"fDg &Dgwp tsgq0  R*&hw2`% !h1hȾu8= +N3h33 Љ  uh$<u~h% bpu&u]f2 % DP	u><uB )
u/,au#aڲh#FOr e4g5g6g 7g8g	9g:g;g
<g=g>g?g@g_AgBg X!MӶ f3 f  ר9 `ujvRP v-  `F  vB F~2|1~İF  p ~ uF|eOn
 =f jtWV `FRvKF@ b*J*p
NvQsWV|FFP
|F؊f- hM n
'F܊f ` F֊ft@ t؉FjRvvWvh 0-~ڷSt` su P0M2muF됿h!Mh ;Qh FފfP`Fof juIc:;E0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹ\؊GF}AB Xsư FNۊ&p;wu0&{Li 'Oa`0܁7aPjs,*`
- e)@fp ߍNV$Yv!YG|"[˽([ [<1[劆2d$0  j !vl$j)Qgp4}
CfeQ AhЎ 0f@6*V+- t*-} [t94@J!13o$RYFa2 {OCROboL*F 0#"7ig
11  GEMBrAr/ 3|
/@+[F+PRqu6pd qa"$V`a1dheب kb! b1jLFP>1@j)"#2#"#	
1#C/]LDE@WV3 WD!^&@RFG[|吋3x6W 2 R&/ FW_qy` r:7<"JW>d ve!bb6   &=  t@M[_  Ft p 
"4g#-P//

	
@yu	( !MPĴ &&TЦVP{S~ t'jF I V t/ ?u#'jfy/q0Ut= tA:?@>u
f&Hf"f2Hf% Hf  t&f1`ul À&l YgdXg fhFfff[fh{e`b0b1bdUU{e>u][h hJ퐔h Zaâvp:h@jBzUuhR 	["		Nz	
A
4!F* F!MF`  @A!MoB2X !pb$<ׅ wre| RAh>et"b`y& Pa
u"0	Ȁ>Re uzfh  a?  {PͧB@card,c
\!F$ !J=
u<cp3Oupv tŢt$rtBttّ@2b3+&?(u"&Rup )u&GPGP됽F^ u|
 fj
 0 	   (E.~  / u p&zdgFF`U>~ tf Dj j P P= HtVjP M-
 -!/봐> ~ H	;	~p		߃>	aQۋ@6ưRĴ &@u3pTyl  	&&G&WlpD"   s- ;t- t- te= M-H- -యWD@ +fjsg  ;@g{p "`p{ "g vV>   vVP*AF^ VP% 
Pÿ h
 h  RaNF
+F@pF!vvo`	F"`NwQF@`{vj qpCFPNQ=`*P!ؑ`VW  ް 3_^Qa |#"`%A  S!F~
F"`6F.
%
;F|!% F@P!]aVgv р`/NcF&< /t&@A0mFAu
 )F~u<  tFF7 PF@50
 f㢴4@@*`P~9v*VA L;Г2Ɗ*1 ufU  Vn']`!> tur3NFAY FNَ&8tGr vNً! ؉^GF
&Ft^ 3G  +tp
V^% = @ʃ@A3t`߰@!A;w"Ā>
 u31&A *;t{r1A 
*F0 F
t t" ؾ0`fp0;
V=O`2P.B@À?Vu	T.SEHDMa!E'(E02rVu`5 3
l	Sd7RP3>>Q XZB~38tC8 uo31~^
AߋF9߽G
u݋N3~(~ q  F;|;pU  fUVNVv<%tF` u DD^ù
0¿0NÈ u0+1W?RP MԐX ]V^tQ}rJ;v~ F^F&uKF$=W\qQb]R}   P+΋э8sdvva!VpN&8 uN&= t&@*A|6a01tP߱+ G0f6 !
`f+I%Q kq6CTNi
ʐ kj ##v^A`
&F3v~Bv0JQ&ğP0zb;~ANuǋv 0dF˺a 
~FfP0V6 cŋPQP F ~ ~
~h3ҋ P{W@t4hPǰv{OePq 	pt>GW5"p j9FuQ_PK vv؁#5@jFoV2䰎0NvD"F9F}+F- P:@!b' ɒIq YFF=`+%U"[ nT\QPEP@DPAAjEP:! fh  赁39> ~jy/0`*[9Pu	A
@0
A/\&76%'@2)
o
G;|2*& P c`8(Fz0
A
j Q蜗j V
VRP=AQRda'P?= WV<'n@]pPac E +FFJVa#
&0UcSpbYg 0aDPdQ[虡XQ	5Q`,+F+Ѡ`M*52* +Rg@"=D=	ӁF3@**A;}Rvs`V6r1qyg*@F;{vwP _J4C
sR14+
}
uK#aQCPfdD$A84	PeV輜VP1~&\-24hQRtYAS;}`=y#Ddf&D&TfF3F@F~
=P  q &F?@u[] СFt^dF;@Ɛ׍]q<ЁN b®PO;v}vma<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF̣	_F	}w t~0Vg~PtOC tG\'F?
t/* F T9F_}\LF ;F~AZM
~~2G+F50~%&L
q DFF 0  f@`	PX f@PF]^^EUAgT lY2s|Pxb<FA@x o0H&v7QvFvFՍ#\Pɒ #R@~rU 3'tsF+FJFH/fh iR(/ tTT4Kv .9~{4aFek6,+F!}=pu..tPoq &OC@ +ϿQ._v+ǀ
0|ctj[|
.
FB.=Q j]>oW/0L# 'd )CA& !!pa2/#$QBC}PPCfZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfZgF  F
Pj ~  v
u}1Aj >PHPV`s
wϹ&wc¯FKtB$PƏ
QиN	VV2ٓ?F
t!@DW% QD
莡Q
VQ6 B tDu遌
!_؋!bG C pDPk*. H!MbB`tu	 rdPQSGg	R4O1maiDu(+Huu @uqt j	jfh	m	"	P裲V^FPqf~
 ;t

>axQ-EPzU@: ]FY m DVVjv/vxX= 6G w]3?鲯S002Rr~wFR0BP1q*E~
G jR[807+$ }p  9]te #S#/E=/`a/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >g`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` zFa~9Fu
VVIVF]v9vu@XPNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3P P|p & !VN;
uڐxA^F;~mOaXS `
$~Du6g b;+|qT/QN;v}O;6Vf~ uFgApL怰9v;|GI0Đ0%9F| ~A^&+^& 'F'302F`g!ihj@vVt ;tto D@gx3|f4Whyl
 rz/~I>FWV  Gc Df tWd@ @ l tEf
ǫ|tATDr\[u0Y;F~ ZpӁrջN@uOp0
DK=2Np>|e u)>f tl>h tt >Fd t|dB`hb?0N Whp.u"jhbh$` i
j(hgh6`f?h`` J `h=dh`+ `4 `}z" `m#$`a%6 gB"	` f% Jfs% =dc%	 +dSz%
 4dC%= "d3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hj Нpt1r't߀DODpU*뇲>AvuA*H>WvAPVt0<@p{& }55446$5245r659hx@E@ jpPVCpWVh
	 !V3j hD	y~D$Հ`HtHt#>h !    {C wt^ f	$F~ HtHtHHt$" @ $Ѻ&&G<P jh	G+PX
G>U7x@n ^]aGP0v&ƀ ~RrjV6 fP)3nP Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eM豭	L0#	Kac 	3$}0(`(hkpa^p3&~/tC&  v&8 u*C_;^|ckÎF^P9P9g`^? tvN~}"v{`<1
ރ~ u0gDFG&9 uԉ~W޴Rr0~F Z= ?-
 -_ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@Fk	 0 v% t" uNj p貁F  Bܲ u
gށ?MN3~*^
7ފ 8&8u	F;|?,Bdnߣ
eP $
Pڋ PPC 
Cc!
d$  *8fudg"^u QK/	tP3`0F |n FP\@
t)f3fn @Hpfh 륐j hah` 4*uŗ @g3`p1`F0	!	*;Ht  6= t	d@ &d饫߀ q}PhdQu}&
:v	`

 &
&
h2hN
h [=aA7B 
@
@rDt߀

@5
&

@Q&d&dD`*gsh*gA"  ~!`F`a0H JN
=@$f'Z"%aCDGB&HFo`^  MPZa#&&#u!,!3F"
!a4>6
`cw$쐤hej2Pj x9
P8
PfsOVmbe}W$`0) ` ad t&<
q <3
x
 %'@{`
c! Yhejg  %cbXff2	 `%  P?z_RB/
I
$*0/(7$30/:05PR$RQŉ`UdDp¨%3W
d
A!$H*=	-H- 9t7-
v q@rMt%
- Ktp-Mt r` LYnл= d.0Lbp,,2@0`  8&`0@'^]R!"Ր,20`  ؐPWu/qU hh S飩  9XXX
(Y&"pYd a= 	ZZ"
@4 |
_!@ !`d`daxxx`Vfh0/?h `ٰc@t&
a 
@U UACCCU ΁
!#p!
@d`d`
ݾw
r42`+ (#+-+tp*tcmKt
- tu] &3\& tGu quhHh
h h!wu
j8%A-&A
7磑#'$'Hɠ'zÐj uڼ @&
)3bPf 軤P
@%>{{+>>G>d'>n!>/>f'>< Њ5P@@$pD D:E489JR4"" :L%9
5̂δlhh `ҍu+a 5 1;wut 3?&`#S7WAA@AG@tR_!P!Q^!>(aO?ޑ 6`Lo.rࠠAL&`(a~<!Q"Q QƐ*|3ɻOn &ArhYLQpۀ@	XrQ됀UUtD3,ޱi
; cK(a3mrFvQ!
or0t$Pv0%@txDP!D$wD`
P#Bf~Y$x0%cfAK=lD=H=yM(a;Ա;
fhZ " [BJGb %^
t
]
c_t,W*@t>tq *``(@a@1)@AE*aŏCƏMQ # - ғоjƖV $ Q%0 0E$p@
%U@@~4RU2+6`2j& 	>4
RH^'
2T	r&R,i賙pǀa,a6&PAsGPD?ѰW
 di
/MlX5F&  &ԧ FTbp?¨"Lz"#1p  Ap"!ab!a2 +a@y+a1 ` 뤁ƒa@]b*a 2 1 lfbG}1`c0!@c!() `f*afd"Wfh  AA
Sfdf*a&dw..@Sa=6P!6e >>d>@!@FF%AN$N@dҀ&VRdVCD^^AEvv u_
~ U
u3
u*
u!D	utud`uf  ,ǈgrh\E>RvɋFHFPVhP]Ё Xv
WV0
ߡ0ahHtHtat-L.L+ AK!!IH
GGL7)Vptճ4%4]'`C@E;GTgE%BM
Et
'@,  WVf+_fF@ ؀  Fa^F贀 F FFF}4FT`_Ft4D>==  ƿ - -tR_  =-a -*t:-߽ ߐ= +- v -Qt}x$Ht/Ht:HaC 6  1(@  F! "!13 [bS" (A
Fy
t)j 㐋ePdPfsV?t9;``{aQ6@`_!F	p 
*HF!M~f  fFvfvvFPv<5Fu63F`.7`~%va :uFG;F : Ƀ~ t
&@{ P ~@&!  !qq t&AÃ@ ׌?"Ht)3Ã? @ bbNcԀ&h q*f>0a uuHj 
@3v0 R0Hf.af"f 4af a T t 9FhD" R
.oaHfa3"'8-9t- 	t Ż`\
  *hfjj a
 5	0u.j"JNRuh ~>a tuáfh  PU	-NR>T `6
!Mha{zhRB63ab&߈ T a~ F |~b rе!wScA >p#u>>p\t&el?60ap U륲_bbte3b1y3
>4*}u	>t ׄ0!jj22tׄ;3Be'kJ t'zR{80:2R%4;44j`pr
x zp@ǟಐAр!F@[$
Ǻ$4M*tS?=<=5
5
p.Kx@a	`@Ba	 	 fh+rD-q pTp$#;$ %4/0a2e bbdbHfP۠r ) d= $Nۺfg1 UO02 Rb
%b
^c
~߬
 }g
0h
` 
B
 Gw`ߢA] Dt,-
t%-.t,-	 tE-
tYt- t/pC DУ0a:B~AI _p}}yJ  oU<QVIftfu& rA Ifwtu
P0t Hf@  -pʾ@ut@;>}`  Pr%/hkpj;tXя6 ]HtHt `t' Q 軽hu
^_ WV3ɀ> N3һBrZA@ߋFPWr~0rHRNpDt  & Q FV^tF
&ud,
,,,L,,, v,,.趶>uh hOnh h  j v
Fye/"
@t\) 3҉
6o5P@;@)}F
r݋F 
hTͷ΢	
J
Zb3#W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*F؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|sbpfbfffghPbt&w
S
 P+nxt	Dt0pNq` ^3߾

tF^&FM!u	 |03$NF%@
ʱEP2̀n=GWnrF*F+= 0=a -tX-  ?- 9B m= M_ - t!Eh-@ } Or= E.4N\?l/ /  p- 2&b% +11b bbv@ 3 ֐j5B jh
!@vE
 C
@

@
/ /  (݀YP)@ wj}Q'3
^'G`hh5؎GS.bAcbh, bb$ ay
0&
c
Q 
@RDM
F_@f
fhK0V" !_
p.pfh,-`*+() &'h%blrοd t0
Ndz Ǻfu
P0  O hEё `F<tF$hl"B by_WF ۄ-FC|ߊFàbG/VA9bSba!J1PF	d`lL߭H HaO^eO KURDUB
HT6PakWĊ90S;D
UBEH

H
>UWF \X+ଳ\T_	d
RaU2C `l2vBeL
2Vphh+B 5[j
jR"&%l#lb$55nȪr&Ep$("(-   30) +1TbP**eteD,o// Ab,bfcfLbfbf-
^- "f
- Kt Z0gpieeBee8c[\¬º,<Lf~ÌĔê;,2pd z ab A^B  !"  ?- 2& k{d^t d@TĀDl c-@h)]#̉uIC 늩@s}# Z+z蓠-x Ux wdx0CXĞA`jOF_BAa ң"TzdEfzdfpd]@ta a` h&C*ADPUЄD؄t &hF˧ώ&? t
׀&@@O@# 
  UB	@DCU
@zd:Qy@t&fh~
"d@߳~fhh]`
7o6藂7tfh<":;h9xP !0 f12TA?@h/><P*Rp	DэCrh[0WVDf$ < u?2@pAa@<@u: 2@utQ͋Ƿ;>P`  "Br< hh<Q1݋66_b  鉀ue\ Dt,-
t%-.t,-	 tE-
tY- Hta- t/YC Dpb:  ~
3 	{}p  Րb:2%u@'dF Pc= PHt
@q j  r jN@uf4c;F~ U 0ӃrջN@uO2ph?h薽p[WV`NW-p 
rvlɑütet
Q &6bF6`Ftet &.dg8$N(q.JCM&&PnG&@T%&V%[ _%T%>rhh81 'Fc" b`& * bA u$J,T7 huhRT9  t~@ z` p lPp =jP, bzp0u.&z͂j`w&"qkF0#0000 0000
a:BkVfvfhI
 fIru mh 螡bF c:tF&<:u-FF
*0N&$   /
u3ӶҀC7 ~ uF	 F
  
 
 <  C
v`
 Tjq<d^P-"0
?z 0
~ `~ tghHv&~ tD虩O=D=u5 J
`
 ^3 FPPPaFF9Fr 
@% -
 ؋0v v sd ƨu`= w̐.T`lẍ́͐͋~FcP.ac y ~ t 4Fa    R F  {: .E "  
QJ o~dzt' eƂOFZ&IZ#3^ \߷dVd.tCq u^ GCauK  K .g"㥸pyW#I Nr@~u_ W    I߸ @FtqqFV!F^ =uσFv2N'22g+@]WV6ߦKh@hn:y*y fyDu}oyDt4H-H4HSH.vgHqy72{I.FIP9Az"ClIDzߡza
"ʬzj &z<f+fF@ =   ^~yFV^KFP6b!Mv3+Q OYڀ?w`- t$phfFf~ sAGuh镠dpfQVȡbRPSQfXfYf3fffPfv诨MF j!bАuCFpvh ޛcWY!u"u褵 ufE  p P0  V6PrQJm		% 6\bD60g\ 6,gˉ|< ub0
貣!Y~0Ð3Ð 6  MHz` KBPSIMPLO  MOTOROLA  HP  17.23!  K    Restore default system configuration mplet?ed!  a) Press <Enter> to Shutdowwn S...a <  drivelock \V`B C 	u Setup  <F1=Help?> FilesInformR  Displayz5iSave?floppy[ diskette from+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passwor>C"e a/"Power-OnWGpP&?DevicedeDgDJbD$L $s mart Card%G
s?upportTPM Embedde&E
ta!'eA'e
t*ac",(0sd:authentic;
credal /Auto2ceTools Ba|`/0Calib(p (`'lecB{ b HDDP:lf-T- opEs Activ O Me]m
Che? r s ; lls1mb 	>>uA(AAdvancuejL4uagC lD7  of gray6fieldO Boow1bD.E.Uany keyUY ue F10=
, ESC=Cl @9RAcc{ep/=YesSNo D, Ajo$r=MI AW  Us|Sarrow
 o highl@ *he appropriQmeOnu ifKpdNTER> dbegiQg3hK%#.follow@M%ek&:`t k-> @KSPACE = NexR3c-BAC9K0mvio"F9oTABE3iSHIFT+&*ƔsF2@&10 `
[J #'9 Er Th{is60cann)bmU;d An e ocH@ #wh0t6c.Pde 0x01 e`jndA@pGu@pp{6Crequi@yȡyE`d~kba@%mu0C
movP:p e4k/MEU) hQ1&`0jll//+2SDFa06ssfulManuZ rr  Nt0
d:Pro utypspyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}sbKeyboorFr06PverADb1<ed2e3bg41qa< NPhip8(TAdG
W
O3O 	*	taf dai5u%BS)Ni$`1
2
3	ME$
C

V


4T!V
o
DPo
So 
B  :  AD %FPA2d!J#biFaӰWalRX0s&1&H} Addline84 Al Xn.eFdW7arn: rk LTllpoB  zs᧦Trea /, lef ea w0abLp0r A: 
de\` waqt`tҰ_)u րrnInAv ȍOP
)!	%Ayou ͔ wa@|to  ?  iI  po b+-~c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1pex03im@s@): 30¾# bg3>0%v} }`t y ho#0#uprХ:1't4	f-UgnknkilWR!mServReaPS)doџt7`?\a}ribp	: `exP9 'bG H  Ol New Vfy nY7Enc8OOff O  ɂA LA66#%AKr	oE   0p dV
Ad1 U@ҭ5Ocpcaus7APp@=AH"h` A&فOpow'er-.AS QVQa?Uׁ= loss  (dYAhou  nlcof 
aQgoH04)ev`ۢ?[YDocHishaR`ed?!0f]Dddi΁al JJe HP`"UTool` Cr.% oF8IL`ˣ 
Bk g UмAn qpm`
@jtWSN !Jarv0s /UcwФcQɡP2"Onj* e:Z%%% F@%԰#Dn -f  TndĠfӰunuR?*$n)tartBQK`fr9a Par1ԥyNsza $mediaaAWl Mmak ,n LANsQG CD-q0F y@D!7C|U`	Q4 abouu}h u`R[%_Q b0USERBMAST {apanpR<ccUrEW"keep iRazLephysG?p1kr  :mpcr. I9RB0A#
, nSUZun-B 5j JOO1/Auto!Rc
Edw\8 8I3?#ON> 
(R[_nR~1Fbur Ct@_!R2th`Ss1rwZ  k edPerMd`qaff+bdata,@`ssibomaANnigiAE!V IRPs[pl r5mmaP ( Wu`|l2,>orepla^`r r/*@| 4} [0uBΠӔ,coHA=Wy`'u~me`1r, @MV`*ЪpPxibЩty.7 IfdoTw8`AESCv.!
t V !ҡtyp#b'>'q`F10"q`rm,bs X{t+  1E$6` MiBjQ  Oru: U ay OpXېDCgDL!bA (left`/hUS!B t HqbSu K ZipNoFir oA0Fthifp Sixa hS ENhASwap Fn/Ctrl!s qKtᓃU.S@00slegackcHH `7)n0=pr@ry Vo}  d NTSC`AL -J -MKt
BidЬEPP ECPd2size 32 MB 64a F@pAlWwaynPPi0PACS gWWzD Radi AkBlueth`/rSF;chA Tg"Rʠ`P:t ED h*,..2)+p)c-{-&3EQn8)e 123.TokR!@Hp
@kP	ЏM3Unique Idf$ (`eP  - *tu`  ƥ  SӾ MCalibaᆏ6N stPS DL@' Zb 0B[ HyO
@ELk MEUk'g'MRq@G/U[:>P1 : C g . `% ]4/Cle	2 zc1 di k-d3	ps
H

,
* A 5>M(4o!ylSp   hnology'tFYadapDPXE RPL Ex#Popupz(  0 _10  2@ 3 U4 5 6@7AF12z5 15`@ 3 "M.B ouchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\|OnzeigfpeicQv  Kgu4aobVcwCie@z nLqvEeinun	Ɯ-s
kz
.ignepd*nt neh7/N%Set@%SRheitsfunQk ntoa u
 naDlt-KuO] G?ertes/-$-ID@  Ot 7	Usttz !ր0pѕz#  beim /st
nBg!@M r5nHsvorrq##7..zurck@z 90
B .p,,!f_g{ms>Ui0'Ex|GAkkukeK tBsgewhl@DD-Selbs`sôItivS9#LtIprN 3g 0: tppllTL
PAZ`OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e ҀSePMbqTa>@0, um p_3gfahBj=A, ESC=Abb!#`WBkze!TJasN0\, yJa	=Meh`m VeZ
=zpMark"`s@{!*!'MenS% dPfei#lt!
^dQgabe2Rm Oq>ko?9 c:s.	folj
Bn 
sg:I-> r LeGQ = Nch A\pd<-RBchritt-`VowA(gTabul!fs+ H-oll+gedmF2`@
38@= {8gy2EschlrL@iPK kan~Lt 3we Y!eiffMgy16P=`?rgetrPn.Dc  01 L@l`fit B kqcQFY+<W\selomvorB]er0ilXWqDWeskU-KsBhmu  f 3aysbzw.2Mobi`bgptz%.`Qz q h4Bi///"2f!
}[KAlgrѫ ab	chlosF-Mll Pgrozyprtt` wi!g!60a"Ca`-i-Gre (L1/L2 kkapaz7it OMP{um"Famiks Sp; umm Grafik-Rs@Q Bz|]r-Con " 
A  °a?h7J	b31O 2O 3O 4dqV si 8D(F `	 o	o
o1
L
t2aSekrET*@R$ƍ%'$b-!3Kc~(1  WalkA?Zero-T<One E"dqA`
PnO`+: bX7 st9qbislwnKp  ZEpucQN-/WB _leQbh s Atei#CP0&ILp`ak7 A:nfC6
lW$ge`KR/+Pglp%ɏ5 L  	/  M0$wirkQh"vQM?`3, daᱭ
l.^iewQP ocFLˤ01 ( anH12 (UmfafdIGc$fhrxdauP(Min.): 30ZБdS`@֓0% cgt59wuwm HoHPuy p%ucbr`"w: ؑH	ԑUnbeaaMTHC52'rvo-L5.
32@lhafAttribu0FID 2u"LS.M.A.R.T.˒XXMs K2`kwp eus~1L Dea  JaQ`eD>/t Falgebe
 U	ңBU5I<p dminIoz Dur1@`'@`|  mg1i@eFN1sgd,E.@"< ttifiz eq SR0yr{t.@s Zu1 0D0LzO 9pVenl@~.Ajb s0Q!np'PlsAviceTa s ,ܠF$0@ h`$pg)a|F	 :	 JZgtfa@npWUmɏ Fun)S7,' m3e\ޱWn HP{tectToolsP=c^ty Man#agпUoD-- c}- k QuickLockSubndFr#q\M#`"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+  *W"$B>#, lp$meh1A #I Nk>"o3f`ot]-Parpen}ґ:-1a$P7Wak7e-O0ANS3T:jmCD-֏@&g1M%UT:an 3A;m$"rive4*Fxpla `t=?PcNs E-A\s mY8unbrapnbar.DIpT
f,ҏ'bewBBSHsXDŒ,h  %G&*0	M, 22\v),   L2m@nc8z@ R󡀢Begriff0}dmautomPw S79@>oShl@C i  Qکk`}p#tw`Z*f
 X'U!!¸t!mU"n O P o"a;)lrY@}#OBzw@痡58g<sQ}:Sn iU.) vduQ(qS!,qs qh!Aac%Cw  Prq җ+I sf0  qurࡣn׷hE .7 Escdrv empf/qS	f d?zu! цRO| t. 󍡟@  f.РYҵF&1 2 B 7 b-B`ntra tAdant!W hj`!@Esc-&Ll̠>m kW
'p'p`\ F10`esRh:
x3fg`g sb!D} m  p¡@MMuBay&m )bBtghk`-Eb(linkCs)1tUSB-b#-02؆Su`1nZip 1`U234 5`U678 9`QFn/Strg!Ptŷ dEaCГ (USAtpf-ZePcB`iebss"unabhng`  cAr Grafik-Contr־PrimSek% Video- rn~Bidirebal GrPus Lfa`iCb0tzb"d}r WW/AN-Gf0`Blue_tooth9URanbp/a EgpaA'ggr E?'*0(o)u/9E t 1"20397ToqTR C?!"s vxa`13IPQk"o>vH AkkuP  @RtA   x a  Kalibb  MakaO  Niual a   O fm   O D O,tOTrat- ?6. .O .L`b4obisp9cOO5"R 0	Egn@OOf`.[=r 1 : 9. % ]abblo(2^Entl h@o3 0P
Bm* 2a
  GS-2'su uĠg`RadapaAeBPmB`z\}ExpA-!-Popup ( .) WedCauQ0dW2 (Z   Ke`~BIOS-DMA-DaƁb@߀EAComp0ropstn <F1=Hjlp> |Dvoplys!VisCnwe Gtil` !konf0[GendзfraMz@PSrU
Jgnorđndr oP(fslur  ub,t gBOtnek@+hed Administowradsko3 K aodA7 for'P·`hEd`dje-i q		+	*
J	Sm -kort	Godкdelsf 7`do`_dbyg1gGOds -&2	 Nu@00fa@ks4l2 Uc 	 Dg
s)9IkA\HF% Ba.AX p b"d`va?lgte b&HDD-selvp^"tPr <Huko QAtrol. iInRrQҽh; OGH omv	IBr/ Avancq Sprog/ Vl1?s mo2nedtPt felO C4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=Ann	uaFs!3=JaNej9 "J, AR=MGb Brug ps
NA`RP7xe  releP %meWnup(,1Wt<ENTER> /ec>A)et.tafpr'f!f7: -> e!& MELLEMRUM = NlA<-TILBAGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!xhk> hsfej 8A3ku1i$0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krv vek`EnJJ
iC dd!?sP/ flyMs`Èyn#/MEUqoO5 bp* uvetzbrud2JI|,nemfB J@`  PrҰc corO-typ hBigH  ztr`7Crcache (L1/L2@|HVROM-dౠ familie'i;AWdeo#f0pd@s8:@Xr-c^]D-ba s@i 9e2o`%3o&4Zƻapt-ta`oej1("Wat!)	O3OWEw @ex{%IsrP4E$ TyPyC۹%xy lydes!Bmis 0'bvD1I'j`e0jeܶ var0: 1DB! se  alt@P2[holda po Pqt`/Lb Bb-Bdduw5,pr $Pk
kEuGrBA:tTUETfDF%v`Ugyldig/
t-  nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)% Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR  	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di ubilK2;+1ol p@frard )x Qlash-@$PR@MIPrn>m#OLAN u7r  Cd-rom-p' YD4B Hop7hF:eIEu 1:w3h0z1,A@  Da$k. l jb TBRUGER-0xOVEDADGANGSKODEN,6UPU alPyg=s ni  wned opMaau,edS "#
{	QD>at l@po PWI_FQqShjlp iutomo0 0j_q@Fbyg[ao9b73pk pegrma anPFTigz!ܑ6n?do` fys dskP:2n@rbAupc(On O"0p	
v  .GhR)Gne ugW"Ņ Pm/, som!Pa Ưck@
Ryt. U pA~ sg/c1  iko qXS`.U  1bef{al kraf   ̓НFx|a 'A @"pl '. \uqÉy@
G񴁴  &cO.q#ar"J"4,Q/d i૤Hu A0.q.foq:@ENstr!5ESCq. t%@n or| 'F':ge@F10FYSMs@f
i/P D+cs	  Dk Osr=@flgm vďRRenHPskm DS-bas  Mult?iBay (K0`/$hjUSB-floppycc{wbsu SbAz;ip2FraVTredjFj e SjSyRV O3 Ni ̃ Ski mQm Fn/Ctrl qEZlPv(aisk)pege Ust!
u1PnP|0#rm-cr PrimSed Vo Out ParQa֎Tj@StrCL>ohukoP B< t6nr compu0P ʀtrm#gt _WWAN-!sioBluethМ/A (trdllo`~net0P2	pQၚUamstyC(Q*8*top+b +E;that 1Ki23KToLR![HL	e+	 	Ent6gt id-nur7@VaP1riqB  S!Ѐ@   Z 9b/| `LKalib)p nd!igO x 0 "ѷ YPO H KO OM\bo   O O#01ionOOOO$Hgs 1 @1O O
1V*i bPGu"[@|!(MEU)J= K=OOGO 1OO OOO[ TPq 1 : Oѿ@ .  %S ].gm5t2 AfFH5L)O3@	Genos	
k

, *  J/X4%G) ' (FA qt @@Ž֡ r "popupsink(sek.Hǀɀ2D5f- bAg0P p BIOS ATA DMA-rq Konfisgumas  <F1=Hjoelp>`ilxsinP0jon )sP s2{CLaӌ$k")Hepfra6#:0@dioA	:Bk1)g avslu!A( B,lBDE;sprograt St passa/@&OpD4FA|U)yrsi!vsOfunkur! tif׃% ୹b-
vn Sm 16 ׀#godkjSq0 neby`5i%itpt5auTilbakeAl#3fabPRg
i
 PE7;aN Urkty Ƽ avaclg AlaQD5h 8>vt Ak & MbT!# `]!@U3EG*
`Hpӑ!4vanpprlg 6  Dem75bM @\dtJIel\3
.5E6o%<}5TorykkC taJ&L&i  a=, ESC=Avbry`acBʯAPpJaCNei rP, T\Rer=M@bb `kYneppilr@Ot<ENTER> hv ddu ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NQ&86 <-TILBAKEwrigʶTAB&"HIFT++TF2@	)P= Go f#l ~WWsfeF`  SPk'0`pZmno&p@5 P M0|m kjresvYe!@0m d,;i pp 9!osbaRafly@sbc^ 0d  wAXa`1A|rvfullأ1z. kode 02Io|"Produ _t Nopablookk-mll {typ h@igv&-ga zv$buffN(L1/L2@Meng`	Q	NenuV@wo-TjrNtroUSW,kobgRiJ,oK1 qNi 23"R40,p( E
1w,9(Q0 
oa
`oA
o,
NEk#Iml`4$Eoc%Hq ok!i*ps(A"Walp9g 0s"-h1jH( Ad`ss e7"~e PnAd 4~: DsA#. z tisdlSCholp`@DTH[aQ "/he-  &d, rnP}u1p3 skl<k`nn@2A:۲O b@Ҽreg1"i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 eP㰔1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vFPhielQr/Pia LAN n0^af`04=  CD-ڡ%vbX45w Ho/:eD@ G}h0valgtP5Arj h($s6 bBRUKERHOVED-8`DK |umu̅! E
 n0_*GQFbeM `P
Pﱡ  y "!мa$ #
T,U]?	$s P8P,pp  4qLL KOM @ autom\pDyLock5eabyggj]dT3Ac   `ma1i[lg_ge. k_[h fysAad$0@ƴpqtW fo `?	exaphn@gE_P3s t`dda gpu»z. UrXrjomd Q 1@0/e XG|pnq
B  uSbVnbefaQwr  G	q.ҀAy A0k1Erғ &2;k_! R!'I7MEPsy-wflAans N@PEv
,2<pESC-|L Ѫb u"'fD'J FC10$Zbe:h& nv$  QNor iFOrse MultiBayG]| "Qdtn(veሳe)0ko.ngsbaphh9yOBUSBeA|w Zikp-U
A A0@AaaˀFn/Ctrle E|AVd(USA)>GekeenAQel!	`rjZtroA2@deoP@⥵pJTisarrPFViA7ti@0Q@mFgradi/trdl@ |t@
WWAN) OOH OHBluetooth j/-eftQ`mbQ AgssstyAg!1%%*2$ (v0&#.b/! 1 Eth;?	.-	3  !R@NT s*ooo/
;ni|A@jtifikRR4C&@B:riJ K0t@   @6ymbo KalibaK B!es- Iȁp<pˀ?Dual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	`nd 4oO	O	
%O	O	bv mob. a
H.\L. \O	a}o
{{O	B.[ TO: Lar. В% ]afull"C2F~i$3
iBn/Qh* f!y  (o J/DJ/éBiǋpkim sin@ hurtigE _(sekur<ѷF12-`f1.Sepute P@pRBIOS DMA- rᐍConfiguracie la Com adora <F1=Ayuda> rchivo mn%l Sma@`QґPGu isco fOlexicXP޻ Ra (s!valoqpf doba`y Ignambios y@lia AL{  g3 'Ln epidadAse
  ' Axjiciof%posi s_SITc )$ +՚@*VKskSm>Cp SoQ0e*cP#<) Sect}yincor`% E0e"@ 30/c XxP>6fbrI
a`DPVc!3nci])AutomaHerramia`C~H er  8`#P(8` ;prueb_a HDDKc ' >OGVp&Memoria2aD d*mp.al1@0JNKRMu0GbSG#
s
 AvanzX ESvVDD
W? nFampr)co0N gr<1o?)<UOprim'quitec0g2)Pbao=, E_SC=Ca06la==Acep\v=SSNK\1"Y, Co2	=MSx p U@{B$dchDha6al~  alemo apropiu=@[*<INTRO> z@ix:N1n.Fs{3pkTY :Esp~o o -> ?= PrxcRetroces<-{0`@a.xTAB S	S'@Mays+b#C(/F2!-910`rp"b"uErr 06F  No@8 @AiGS=r`jo u@QRA6K. Cdp`01Bhoay n unw>LэqubRnYD2@AC1+>bѪr(R[co rUD)JНebook/MEU ?IX1QP\@2pO`0ple~0Vxitosa4e Fak T1ytil TisOp7,Vc*lGpuWXTamauZ_0h (L1/L12Oc FAAwROM mil@cNmerD}rqibvisU!v@ j6r g-l@yo!!
/#j1l2n3p4 EOtiqurA!sI2Ve4FK (ga Woo.o3oopoi B(	Esn!*J8T 5:Z$  ProbUS%bssfactcXJ$ǔ =ll4Reo 0poX@1'	lnedi$l@z,
(HCE| oD"F%Ad  :vH uir-  eap. Preh#/, 0WcqscpY2#auA:'p, Uu c l@Qas ' Ӣ,Фhp9tegAң
S^@vlQI$\e'vaPPa)00٠o(a) 8!@%`c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcunvtieej 2( s): 300go B0%&~Db  EaH0 _^`ipalGirumq
 :
 s,pu10@ qIQ{`3nh7Servof 44apoya atr{ib0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApkagE ndq9CS@gOB".Xt		@e voc"	k"alpa 
0 Lstnad ;`fR n"]e#թ9 A*# \A<Q, (02o,GA`bs (R6% Ey WciR|LLB hrpinR3 SIBf_ ol:9al ol`X#A!vu	jvip.AoQ  '{Ùv?@%(֠WapaAuydAn14n HPctTool@O)%!s!&  QuickLockSuspen Blo`jԹ\r#at S 6""t mej`eO@`?:0d++-y	(BI	( !)(%rALlRt0,"BD,0Xৠ-upizQ,.`xHOre PunP+r'ojo%q>lWS9MLmedufhdem Iqdno Wak.n LANL@H DtiRePI" ACD-Q(mE@řal)[Pm:\ Usio:b	u4@S0S`Rrive+2dL$ t dBUSUARIOM PRI?NCIPALp 1 oo şgw܀YNman@Y px 0|. AnТ;7 y gup`'` lugp  cj Ap~0.1)
TM @dk`\)hG1
f b 5@ָ]@A "Twmc;N	;I0orD=
`> ʧ>1Rn"RsuCw  , fsm1$! RulrSoc,L"oI  /be}"<\sBu 3Ҁd/asRcuBb&Vt"B! ?`p~Pda4$kosapg`԰6Se {oenf 8d@lic1a頴re!azA. /?k 0u 񡂮`#PZ23a4=inͯK nTBfixP8Z`
v\i pons2> c,Y_, pipԐ~2 ESC. ΰؑalabP'Fd'  p,F10:̼ݲwfGAᠿ'a7T/bEsp?aol O R3tMultiBaNZPa DiFPsi3-pA ;]fb0co+Ļ(izЂ(@jec!h`-5 cBb  a1ЇШSuwkrDZ3ipcpmeaeTer Jo CR`5t x SSpOv3No`DCUs Fn/`Ts@ncIngls (EE_.UU.)sPű (PPmplSo}"le $B
Ғb!Ac@ G|ѐeo ModZ"y!  Bidic Tam&#m@Pi#	sifu(0p{ BICA IR01ڀk*WW x{Blueto'othA
 p}{PyhoйergsGCpoPos 6B/P:{(s+ior)¤Ethet, NЗboo0U 1/,2/L3/Tok0RdOOEredP23 IpStifd Excl#us sAMa `  .a*C0g_-N0p[0SՏAo`Wr)Xh!, o	o	k	o	
h	s0bpkn	 o	o	eok o	o	o	 ao	o	x%MEU  o	.o	o	o	o	Ub2o	o	o	ȏo	B8[01 -:rg". c% ]/ip걟2 @c4h-Cle03	йk",'* q 9ODJ)o!qoh ~1bl䑄@zArGran1pB y@gÓXDPbХg2ExQ쀰`  ŐF12QTPAmb@TouchPad u1o UN uTsсr D DMABIOSaӇPub  <F1=Ajuda>rP0Info@͇䰩sobPo Sf EเЈ?4m@aDӲpR0
rt 7padr0
|3t  Ignp`0air(A	4sPs'&_1nKanL6az O 
DBr%& pς_`#ƕb! X_d#!

StUdt"ԅ:liz/ApΉO
(Ib  0؇/R Q*Ag%΀ԠbrB
autQ<n 4UdcЮealhAlo`Oa c(SFeQm&as@g1=1iCP8$!lYeOpT |HDD A1)3r  VR#~Le Mem @PA<PJ  4tatu UQMuPY`G]⫝̸ Av8!S%,io Qa`d; 1camppJcinzP"o?CA9 uPds`e qnr ycк'ti_nuar i=' SC=CelAce imNK!S, Q%ou=Maimg Ut	i0:psC	qqp'1da` o i~  aprop@y *u@Tv#<ENTER> t5meRez[@o.Tgut9 N^r ub:  ->
PAO = PrxiK\<-QBACKCExapQE06TABo$SHIFT+C%* F!2 	*:`=kSC# 9nErrrOA@Q@na0WoQp܃mRHE. CdigTGo 017  NPhG`,@o `qS) L s@ viK=CA A	bMev
;ÔZWotebook/C[(RWS$ mGsTe2_DKKXqmBm xito聪nN  TAi0H݀3VpcS_\ Tahcache (L1/L!2૦FX a` ROM Fam9lY  N 3sri
Rev{isSvde@_aJroQL a
Al!D	Ob a(34`Rtiep	JIBOeu6(]){ 7on )oo.Oo$alS~ƕSecunda'$ 1rcC% vfoi"gv@!mO al  Wa;lk  0e g1i	a l-ien!M! oc0I@Advert: 0[Aqo3 vae!djWcqP/,!i`um  grav)vuu:e)xEӎA: n@JAdc NS3 >B^hO!QtegiEa	c]
vCl0IyI= kT@ctez0 eja! $,C? iN >?ý1 (Rp b27 (A@ng!qf3 (S.M.A.R.T.aAx`=_(?.): 30<`ѡ0@CT =4Q0%Ѓ?1$bucedeA,qAhostDCroqm1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec   `6Q3sM trCibߒLD`8AМexa@s wQUUig:T"grg`aRlPSLs   qL rB+ۚiPArrfDigcis gҐSAdP)PPtЉxacmod!CsާB! fazA@ArpEr`a,Έer dform!r3Dn4,Pja"0.@eHCsHfbrcau3sadQerF. SZ  Q[ea 㷑|2krvio 	1Iy0rqX)QT?%0Р ur@r0k
3ad`pis0S,B,QuickLock!Suspenso Blo`qtB" #u@aSM%p` ma@bnb1IY @k,$$al#.2P4sa eiSib0RPuseu sEEx3igU`re*PbM0Q+ &peGrme@$1lp쐦+maok6n LAN}e H!CD-"ίgGPh$qme:SGusua: VocË@jp`4Ca0yr2utzroDOrive) t@$UUSURIOEJ@ESTREbIS C(̑:q<?Yapaz=@L. AaQ4P@<de-ЧrPisPMEEAp"@. NQv p^֦*6Ye ,Y`+bN 6 0.bu=*6Ƨa !Hde`D.Hi``7D2{s1!Ei 崧O:WAWGs1Y 
oc<w<o  supʛHf`oo,ao Df7 Caaberi
a`xx}oW :aq(΂4`  0ƀrqur<Ǹ{@FnghݲX |af0@W | 2|,  p;) F `3Bvor nalp`a-w
Aa ΢atpEsubtud C~ ?@*hR)ssa޵ptA-lVJ/trWL !8Z  Lembre $՝vqMac`Pasa8
"qui_se`R ESC]Ō9q3lav
'f'rF10. r,`r:MrʺTPAc]D ugus Op1k: MultibayQYN4c`isi rBeAFpBa baЧcopld(RP ditzB	Rc"zipcPrimeir"rc QJtւO]ev@N ؂c@aqAs Fn/CtrlIngls (E.UV`ыxS[h8p1troaRءdeA^cund a@h`3LPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WWAN)`  oo`o){Bloothk
AAne(a/ E omCenergra1ereۆc-agRF2.11{5e/2o03su0Ώ3Et&netg	@O`p
/*3/CToken RingOO bokIdf S(b 6auaqW XSt`sSsCbGPdbptgemDNS vlCAw#[Duplo&	ted/	 )	E/	jON@OOO'as7AmO/	k0C/	cIAl0  OO/	Ojp~AMEU/	 /	-/	G9Dф1 	/	/	/	O6[ Etapa {1:rreg29. 0% ]Ojc3l 2:AcvN3:M* 
 o9ayCCm*O"(sDflex	`QSc زrydapY!i Pop;up> Exbp@ ~àF12(т? d>QZs Vara֧Wa N u`T@us`s DwDMAFIOS`i k0@{mtukP  <F1=Ohje>JgrjtQt Nytt vPbtu kP Tallenna levykGkee dk@Kon@o" P0utFFo2CejnsW Oh mu loep6Lr W t2
tдt7!Tpou aurplisunvojan ssa0M?rito/Kynyk Lat$yl	
  ?usnumeP
o$-
t_ lykiu  '
,0)oМnu kiG0
/!(et F.t3fsB5*tehd F7OG"R t!"$j;A)ma`*inTykalu`A;  oK := Ki3vyt OA9ƀ@p%EMu@Qk!` a"26n D:m`-GHLis=ieli`Q`Ipk aec  harll 110= 22R2#j2H%Jatkinjot~  npp@e`=d, ESC=Per`F=Hyvksy=KyllEi CM, Joku!L=`TY` fnu7oli
mipR_ka`h$@
si#dsN <ENTER> mB7t%
ep+.I@KEgn C/ss seuraavpU: ->Xi VLINPPIN =Zs  <-bASKELPAoLAUTEdhb1!ARKA+! hVAIHTO+', F2@
)_=  d@!;ސvirhtAkkua e =oi >da.>: Rudi 01*ka c1s ~4 apHrt2Pl pU eytke`"6ko>@	siPQlaks q0rYsRW` kaCt qlaaP^ TikkI)>ske_ytyi Fn
i(pO2nL^oh0ebaGEm!|jA|}1?i@d tyyppD iIn :fap{llaVlisQ (L1/L2@U  ROM-SbmЂkoh	tuotep9e"isar{W]`si ?s?tohjab T;{	!1I:"#2o L3o`M4m)J`Lta1on7(j \oa)



\	\J䅸1kA'ra- DqACu0$#:D$ 09arT%dzb~ lpi!iEepoi Walking 0 -[1Yloso@Vaihtoe@ :uvi7! us?: Tmӵ atpnhp 3. J0ltO luo p2us-  5n,2Pirjonc!KA: L"X AY	hkuVV 3beFAGB8p_Cpa h
GHkoa]Wi `nA? `/  0i?ͨ,i`%(ND92R`30.M.A.R.T
.Arp$@[n (min): 30-s p2y0%cL dv0 Ispysi- 4iVgR
{fb%uCntq'c{K)jServomogottj
Lu!5ÂvtuQ	k@Fttribti2@ЗŽy@a 6e*qKxe nGG89W UuE/Vahvu  x P>2Ȕ	! PC }A"+2@s@a	,-ãPAJa頴n4-okkpD;ad`5an 	$InDP -e@7p$Rmysba
`kD1h@` HЁeT @	dE	ZEY/r i0Xj [!K uEnQnwby:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTo7ols`cuQ`Pger -apQuД큶.f(-/U i` n QuickLocqkfa hlu5qf ,V "@P#raZ&-Q,:*sekm #o$j$it)a{d0||}yh'  PP`0#U8C.7>uu	SApor In+frPnR@%!bkS0m 4e}m`dHert`ghiԐak0ʼV CD- -jl
"4[w PFSjPZWAiot#@ebn De#'(stt&)pOlla. p  /@! KYTTJN|= PS?SANAN,0FXCN{.qa`!' v`"0*@lyQFkur`V0< ribj^"ࡂ#t@br
(V2[-$(pY,Qpcp``mwLLA4@1^q* OQu `UoЩs- V suqIzAhr?Ii,#tuB x	8op΂ R
@J  bU7pbI r
V|}meG. Nykyfr`+raq~sQ{6v
t`i @Su. Tqtէ0$ £ihQ{eip=0up0@MY<eh?  IPa*?-p@F|_R1t0HtaYb=c /Aojaiem qr3tat. !WQsm "ftBTV@UG. 2 !`ZXu1F_`f}0D ep q0pǠo#\X 2Css,aTESC-npsRV;n,અ'¦e'A> F10%Y4aQa{ :	o .cVQ llqt{Ƅys ubn MultiBaOpc&JW!lakeoPiu (cen/$oi) USB@)Zip~Ensimm AbKoa e7lj }Vi}9Ki eit@kKak Y KymAai Fn/Ctrl"mAȫ+PEngli (USAUsPPsa!QB-R sq@ ƖnрĉjBsCPPs VPo,t|tVakios2sN#I̐guu QHDpl1E ko@QWWAN-roHLOBluWoth "@/Fh`$ sV߀Rs s:lPmӏ,1i0> $y/2,-I, (ylos+OGCO6EtherHo2E @Yoeo3oN9TokX$gO ohA workQc&G IlivA AkkuT < TJrPѿ r0{jo@librA ad Sual`-OO  OI OKblb_OO O  OsO $O$O$ vva_ OB  O1 OMaa nusBkPBOD OOO MbOOOO
OI[ er`i:r
йada@n . % ] ODPW2Ģl` ur pp&OE-O
3
Go MOH*  j l9#` Fނk`q#vuɃP iǰ@ (se  nA @:@F12):ڴiP%3tappiQkoske@ߐ 'mma K  Ei mn BIOS DMA iedo Pot Configurati5ordteur  <F1=A0> Fichier Infor`v mAff age Sauvegarder sur diCsq``cֻ Ra ,r P 'une.H_DHe0als dfau`ow du'Igno%modi Tpqu S%e l'in % regom	\ Scurit&
e ss`Nd @S"#j@`e sous te PKon.D
 ?priphP %J	a sE@IDy'As
Dr<Lock`q
Smp(C0Cr1P3r3  'he5  1b#a <݂gre ta R,9)+5p7am''us3;),;rfrencM =at"#Ou\ !@lonnLbceriZ sl[ecqSn@psQPs AIATAHBFoV,~mmoiri cBDX C0ZZaFB_V AcpLang~4 ChoisPJ:Yl3Ind)!5>_mps g! 5,ePMd.rpa` k2Z}:z?? AppuyDfa7touqpo@gerpu@lw=Ser, ECHAP=A lH|Accep S0=OuiuN*#Q3V, N'impp_e``1D
=aw  UpЈzi3
s f&'heM
mo!04ecle hmwenuucer@rwbri 2qhz!y <ENTREE>2nj+W	ss	suai/fa  !/ :!-> ou BARRE ESPACE = PBe`-$IEpreced@S<TAB`CA*'zՏMAJ+ix F2=1"w-$!S(rr`@P<TJ Il <FA%ssibP2cQ7L U c{s'Jprod{endp#B$P. Coa<'401R!c5Cntв@-1 emplgace( L'` D SaQre@}C'y
GJ 
s}^ccuei7l dP "4@r ita=xsmobia``
W 	
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ Typ0osBVpwDb fKTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numro8#p	Rev`cr7doerS2ItrQclavpoLA}ud ;n+/ZpH/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OO oOOOQBV'edA Eo MT֍ E:$/. g  %Er4 !SUPc;WalkinGg 0ᥒ81wlig'ad`auZC	od  al0ifAtip1S)C[a=e@ptruA ieЪvPR! a/簹r,  z{ nro°c	cY0]A}jDLД_v
 tro Pa
`s
TX	  _[Rvja"`dH.On) m:YfPS 0"Ӏf   +-vaPC lp  ߚV ?? Igno7ꉈ+| z Enregeo#=1_ (rap`)#>2 (coet)u`|pimA(z) B310堿s pAU70% nv$D9ʈl'h A+bF  `䘁:˗	AsGinpnud'+,`v`t
$.Lu( pG3p4 5A`ib!O: IDP00@"s S.M.A.R.=TAbanG2WpW AIBY`se N!=apYepAÐ?/@;sa#A MaYr uinKS ;A, eXecoac	;mme, vK*aad11POobPbatCs	eSd4D	 pe>a1a`(`ih s4[,P@s蒵 `Ug"  formQg-hq#xѼsJ.)r mQފb	hJU0`
1AJ.6zT"`QDP~naR avoupR!AfrCww7A^	 	zY@R`(p"}fbfQd  kF;l2TcgNxq`rHP P`o^ Tool:eRy Mar O4K8CF!/  QuickLwockUsusA |$cpF!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//  / L'(a'a
$S$ud!v
 KP
dra+D hn 4`ExiA-udP `  4raQ8llƙۗ&flashѫbWake On LAN\ C#D-'E8Zpalj\:A99s!Ɇj$e Drivea-. SsD#DDEdez "deux,&(UTILISATEURPRIN?CIPAL)`%H	Baloar@V N>z_MA`I!!&q%lsr `/qfe4Bcelu2*QDordibf4. A pTV	~ (`sdRZ-Ho r uDfet Cu|MKQ"t"~"a"[D"qoip> >""%x 0ՑH)@zANaniq4"05#'o牌#!2/r
,Bcгǻ!o!  3pi\!! ! !{e@^qQW֊a"%uelR1X :HLk" ""opa8pE *O' jW'Acbw# ,d'originIlRv`OB2C{a$ B	u
vqS"apAQy9Ipρt0M倮
5djavs0P~7e *߹-$WqzaPprsP"t Ձon: to@Tp Ra1S44P-pabP}t3k'
Qyj, appuy
0`  ECHAP.@@@ OTzR'o', puiCrDwF10@Tap X2 1xCxY^u}	UZ/qF_rana
OgHҝACJiMultiBay`ulƍAph0A Q!3D,xsocv'a%(ga)OOFRz) U[8֘ USBqr
jZiprP:0 EDhi @s QuaQCin`NSixi` sSe  Hud^ NeuvCD`^Perm/r(s Fn/CtrlƓ AnglpSA) P$oॱm1`s A`stanlphnROd'fad`n elAͯtrlS' Ui#chQ&m`
Ұ*d :i@7idÂoA񯁿Bidآ 0 mSmVlb@jEK!al ,$ R o!=ril WWAN (rse0il)1grAPBlooth7sr0/?1   >)o`$0@g`Q@loc <G `cP!ZqX0b91bP-n oR;2ooypu<	6ccumodhogB Ebt# 1a%23T{okRingo oU/,IduT9-ar a[  
2     Ph% ll`4 n!Kre0/ x Ab!AF.!f*Dupk */)///wb// ///**- ///Jqgn$, `/,/ /e ls` Btexв
sqbmoP/ /7/// ,///7[qRpe 1 : Char9. % ]A.`I 2D ` GicM*n3@	Rkio.b
* T   @@/M.$oOA$Ʊ4Amor1cFe"5 RetardBTexp `) Dtжa  F12tposf[iP+Aux  PatqbAKw~ ucun Tsferts BIOSmDM'A IP zpOlr <F1=Ai> nfogQema
l0'Salva`l floppy%@AttoRip}rina dn@Thi@fa0``ip"Ignor`d!ed ?esci EP a
'l'iI@Az eiBntupiczza sswo&e amDratogcc3R
q`7Z,vos7v@% IDs
@פ&gDriveLock	Pr ɣ+St CP9 SupA=c30 gHg/o+:,i fabbr
4=i	/.nzi`[؆Qco
rui C`b5<bBae9E lrFOpa t2;o rigidAtpaA'VxP!΂,a me0V W`<HKhMiM;A>or !Ava*=t ,Lu!O; l$Dim"& q6ca X ss=opd eviQc g1	vv!'#o*62wH8Premi qp_siasiesXperQVu L   k=f, ES?C=Annu`P,aA Et0q]eo=SiSN@1T,altr
o#	=A bj Us"SchiavI frecc'!i1 voycpu ap70e"_`<INVIO>  \k\'e.i&pYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pBACKCE c<TKAB@C%o"MAIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87nppupvse@t"Vi  v@u4T|pXJ. C{'01 N0u0F>QQ9a0}oggiao Lk`IP'00 Q>re0
4Es"@agga%Fv0S!t`ғ  npabook"Qzesp қ:\ ZҪf.atp_
2o{briuPrf uduAA ND  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4D葭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASpr:bits 0t 1Rindirip	i]  `| 'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, O`1favi P}PbiVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nsv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%L?bq+di	gA! {â"Znd?՛O.A7Tcq^B&
Am AVf !B;YpCr	t>J2fum y3CePe<B #u _t`!1	a哰.Q]ՒbdFo!erdPКatiwEff+Jizso@in  ca2i	vEvPgaζO8desХP @Jm9Yy HP tectTools Od. ZRV2+ i?ckLock/spen`3B05EY mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))v!pKs!m@]0x!! b	,'URar i lі@NR (@|ГV|9a infra@Q)p y%La_hflashBmnQsVL{ANp Off#o CD-" Se($FZPp:[@!SRQ#3ĝ{usanD e1*.C D:AJ@T @@bҁ['UTENTEPRINCIPALE  r@.;a man8fu`o. AnPV>Fg P0v a%eQF@p@0f>0.l@h0AuYPTk^s,bh	Q_q2L sbR?F 7reDZ\f.AP R A Qco0%98 P+ AB.`D
 Bre,@&q  d (`<t vOH r luogo DJ T!B'    #l$ j@@IV#:,! vI</sI"I@5 -"÷[tCIlz s"o mP0!R/DeB  /$BH@æUE a(  aDA'aȅ gQ#QAi  	 Pota t{fa+ ueY/cdO ::l}0&.2rPqu_{9㔓!.Y)uA`YEsn OP䲅@K@1'56h,mP킊ёo ESCƞM'v)dovQr 'Zn'pom!nF10. ! n!kKWyȴ_ 6\%זt quIP(i 3  ODA:D0@ $dM MiBay ba1.ggias$Z) ogChi USB]$Su}kbC
ZipBP6o ;Terz `*OЁvN% ec AС" Fn/Ctrl TIngl  (USA)$ Yi u`2O mpl 01asciЃR7pl Ua 0аPפ Bidx0HCapa memqX5embs"F!/lDQ2'c/wNPs (_WWAN){oBluetoothCommu	Ю/ U(J)Csm energ]hW'g)1 N,,*2 GB-Fa-( o)ol/sp EtMh`et VI123e Token Ringp!OE3 IAkB|# "CtaL   Aoք  C02b// WD|Saoo [0Kvi0Du0V  / o  6 /  o ,o// o0oda C   / o pUY\mo 93//- ooooȓ ///oo[ PAs 1 u: 
ro .  % ]ocGompp®#2S'4,n6E3 @
ij* 
 /JqoXaX/3i'o
  Flopp	ybUAǐI!dC@Φ p(sec.=)# vel0F12b 2zw@pambPp@NupTras   DMA BIOSup <F1=Hjlp>rkiv Sy!~/infotpзs~ S pk%kPiCguQ 3(stll frnlPhpn ar}d Annu͟a nd`` 7ochsl``*   np͑ SkerdPtrsl0F  K!a8OB rt-Oa6Enss	(b -ID
S a o
 m`
Rd-Std gfrut9sav 7K
 byggd X
usBi=*abrik`m+ .J
sb?ehrig#Gskts@r?ktyg Ko +r vP S`;vtiG?HDD Ak_V Minnes:" 01q5Q ?@An@#B
S Vl-j4rD ;|cBnedtolD!v(C-tj+eTry@SI fri Dg s nr du viJPstyY=, ESC=AvbryNaFDAccepaF, }V=Mer Xz JvI pil	e	/pCa PyEt
<RET?UR> om6
YRtt .ke,lj`SeerI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK 7TABf#O>`KIFT+H& F2`+?|= 'fO @%Aoi?Cfel 3t gqL @s kA t h+AO` Dstod uGen. Felk0197 AsЌgF{P|pla}t  NtPhm krv3?  pbyPgm0 fl]y5s t6 U-Por/2 ex䚣(|>0Ytidigooi2-@kl`TTA UkN,q  Prr, typ
hast^hg0Cap-	rlek (L1/L2)|Yd ROM,um  familjrenummn0Ddeo, rY ttNb ~pqyrQ!]H 1.z2#3$4r8binv0̬3 (bZ)g	1[


SKek# xIrq.4$@gaxrĔ%Ex!z=ok9!pvidC>lmissl l.s Walk0Os - ~P f1jH Adds li7AeޡnVar! D@/ѹ  7neh g"Ccuskapay /BG-t۱xi
=k b!h$2AcA:1R K>&#Rhi{wIBB?skydd+adag

   Eˎ҇A!^ԈG  |?F ig?D܀jGa- =1nabb8pf@րn`X9UWk ad k$pQd (0):g 30@npan 2?0%bX A4Pp/]pp01vӄr kat$Po:,t	!َOk%S(x ervo-LzB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.}-5 GammN u7 ifin@ D> LܰQ R4bd% pm}vlika mǄ a 'InE?kan orsa@3iЈP9aHSsNypPO@Om=na <s1A1lo. 'Na om hglqmabtj@D{eh ;else- @^uQuayVqΦ >pfun p0`perl^|7!i HP tectToolAs%٩R-6-Quicka"q`telge Lp׌mPs Hgk
gppb*_-  &q2@&!џ!!r ngop"pKF5bli`X!aot. 1Kж7AompHMi p@1f 	  Pk`anFlash-@: s!Wake On  fr\CD- 0Xw QPR%qSt HuvuduJ { fK: D . Gowhrdvd D e . A1 }a@`r ANVHUVUD$`} ɀma@t+t .^ P 1A "RN`ҁ ild ̀D+A
 JёRh vqpyL l" C*lqJVQ.Z +oI XqeDGga2b=2bygg7ZSY3 g 5///dA\J8- F"Za`=oms-KeB
C:d@= a At;asB G@fj'FB]. ktuaiqafaanDasks .dIsutN^tg Ps0`AYq,vїursprungQb#@&MM. Vi  reko a4F	c	Yr `+,0s@ b:`b . A `Kad΄37_j &g`!b(gA\|O-befosesm ih`pґVfljgns. Tr0  >ESC- rQBS֠VڀƁSw㞑`'Z'R-sedMt:aGF10 0cVi3a:+dBshc{ 7Svea ҅: N?, MޠiBayCrut opBP5vi BaG (`r` (3h!SBV |G Zip-=0PW AsFjpQa utto NpT VxFn-/CtrQle Ǔ E {lsp(USA@bmYkd! b`n`rmsPtrorx,x& hbbel|orlekheo2nek0!L!BIfs@io.trqtK (WWAN)0Bluetooth /() -v@ĔmbeQ Aggs`haE(-21,2)vз[,p`㰽'aNed Eth,& @0	3/n To!R PN"!Unik *@?iG K  tus      Sbo Kalib@o dp~-  F2=s alQ. O
o 

  
9
Fo 
E 
D0!m1s
Aoo
E
Hptag  *o 
* 
VC| emoo]A*5ooe
 DIOOK ood
D?[Ne _ : Lapr . 0% ]
klar2uj253oAmFjOF* &V@1 > I*O!DgOpЀU®br@ـ4sadapП$lg rdrj|Qpsnabb0> (sek. F1 Bd StyIrPguIOS DMAaa˰"Ben iee/  Op Teslaan Configupo`anaAfPvtndaard`P"/  scy	Wijzig&ne Pprogramma @РSetup  z1r w ܃svei|Beheerswachtwooޅ
 %X. Apa'atbOgl$$ ID's 	g`aSmA61CP  Oa u"5P$cR%m@j+%O
GeX@gӨ gssvzie܏"Fabrieks.ugz7@/t);Vref.>s:nieuw8OOc  Ex=t`AccuxB 4\e0P gesOelec Ea p`Es  zOelftGa [-schijfe:i Act 6(vG0u`? `I R!a/4UBgDAcg
@7n ,DP=%_
F w 9aKc!: Taal 0b  =r/emP 	rijsgemaak el=;o" /;9
8ukAZ ]{NMLg]g=S, ESC=Annul"EDXG0=!e!oJacNee} fslui@Q, AQ-f =MxN Hulp?pijltjk~p`gebrui1:Ѕd )jui`x?nukeuzk@ark^<ENTER> ind 0
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-ޑBACKCE>VoriglɸTABb	#HIFT+%%|a2+K= yk p=t#B~fouta64k p It w_ge15 F0MЌr]eqatijasoen. AcoZ01b a0.il1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebook-pc/ARP @.PistNOQbep*igdooh2 L	MЛaft NmpALyp6rocessBnel3Qspp OmPЂP}e (L1/L2 Zapac?i VHRWOM @ -s!fSP<mm E  Hebvrgav_0ideok p&p;b bpM	m	ra1$b2rd3e14hisJgI t}.jnAe C(B(Љ,wM@dzQ%) 
 `D#SecuibE. aw~~@$Ftbd%)҆2!dHU2L583Hac-0-*1Tho_a_dresrl|afwis_nd paoz=LTop: zbPt<ts e'ge t PLSBbeЉfڇ s d1 A:og-  / ޖ"x0zbLe6`NoffaG1Y\f_dقڑD`ѱ

boචgAt
wOC'We nu  Њ"
wi	l?oݩ""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 40;q{ho:5broA):]eeqx/nb!$32#Nkvo-IPsE I"
20"qk:J S.M.A.R.T.-af@APP@udh "/:Blo!  A I -7B4kXqcrlpSX8
 Vr!a1& iKs bBs AYoCf#/k, Tm]lijk0UKQΛ zoik` dvor s:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$ uswb sqwYfur9houd'Hi`!  AQ`R`T`R&BhѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gspp`&b TWm E #M"Mg$rgΠ9b 6  ~erX#W>,.o(
h( o( S("7'EAJb"f k otraakP)5w sXbtK;?@ݳ ]Qŉ ڹp1׀frapd  Parˊ Flash-MmalIr=demia LAN aa7hӁ@r-> Cd-r gHNѽfHoofdZGw *I  U15|deFB`DL`#:@izow~.HOOFD-WGEBRUIKERSbPƄN!7  p'anAc S3C  Hgw!#N$ . fykkvcomp3)Aos Q1|_0)t D졗"g+Яq.   ]0qp1bAutomPOc8>}X @r?:h^AA_<T< O!V)?!=NPSS! !. Mo[iaQ noS4H,P   n2S8P0`VU nt@ TAe.b/ |@hui`,̺dЍ wwas top/!k wNgeab.JԻ7[!nvlCoeC]km(\Wsn 0HZ^U4r`ra=8	WptorH/) v"gect.  o
 s  v"No. Omun 
1]A&`3fe*&8agolq. Au__,ܥCDyAbhl  $c8ep3ruk3pESC- (A9 ±i 2B'k'ftyUbkn F10 @T *ZĒluS4d ryl`V4  NePl G g MultiBayj!Vzakd@\base (иk3s)re USB-Մ c`b+z`p-3 E2 weqVV@{aZKes >ZÀ>Aa8NFn/Ctrl `Owiss/j @мSStaµMcW3MijsappqOv5e 0q׈ՓlBkij V o-q܀PF`A/Aˡ0d`ditionN  G@vgp<uqVPilat`E?"Vp neVd$` Radioj _WWAN-aofoBluet@h`/o$JrgieĠQ[Kq^.(ba)c3Et̐ 1
2
3iTo}R/-OMo@bo!023 UPXuAt0cuI< q6us     S#aGekali@!1OK "2
NeEualR\JO OCOGEZOOO 4^B 1^'OOO H0~paAգ
O$O"Lker-MUE- $J$OC$P 1q+OO+O  [alp 1 ': Bo@19. % ]/& p[0d2knte~l/{	3	˄
foh l/)* Jt  ;>.C,$"q $#axXadap @PҢ(sec.)pop-up bijW snroC aF12 )Kbb cursorytuyEasyPo-muisG1 DgMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕ  ݒOCOFϕĂGg&f 
H
gɁ  Hoד 
ɖE	XɿI  `AO̏ԂW܃@ea ÂL(=eA8`LCǗ҃pj h/dCo'o "X yf@\̗L/lE%ID&ID:_ h (uN XBSA$͍ݜeX} 0g J 23T|OH, v".eI*"%ɀ;FX
 󖾠>f
cA>oAe̒?  I(f:nA%e> rpCeBIvCǇ"F@ `F  /H D%Jc9J; ڍc R5BM NP$ߛA%EL@U`UO tB!#sNu%.37($b74L[BRׂ h=!A/Esc=C@bsAS6?0=͂
  aRAg)xgjq5\ 3Ogp] jk?ڂ %iA@gp>[Ez]  e >gȉ#wA1̀r_->Epy`tOo[ = ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+0eF2!,,,10nmF/[%  !CG[  t@DBCł}@BDr熂p o 01 yNF`+@~3a
ɂACOk ~Kvժ@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e׳`	{уɰޯ   ۾ ̽ xïݸ  ށiL1/L2"OM OMFرԍ  ޵ ޼ޮ  ׂްޯ 㰽ir G#2.3N4h	 pşch3(Â)F(E-3N4(JPkvJ _!ndFw Xco&pF?$qv sxП6!;LsV+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊOD GPuA=0V @QlA [_ۓwfC!N7Wake on LANh CD-Pu3(a $} ^ V:`%A}UK䑀 (iHb'C3 ye@~ 
|`<ݭ'	8 >B`/ZAT?iRģ1"i	3	i	El K	͎W vpR@sAMS#ۊ2tK@P!K/,Ɛ!eF|e\ӅJ@qA ߐ  <綂\0ۏ؊ԓ "łb͗L+ nł`k)/)%)Dp˦ Z7]t.z"*FG`nGKa(o(iSn$'m@_@] ( IO)F) u
ϊ(p(?(9(ágÁDx${#<43ɑ`ÈM3 }f=ɉe^@&@A)F1j5 8cB  B㑱BAȑiO"O cĭ(2ef̯旌8dql@ӔC౨aU"1/g'|>EE[Esc] 󉟂@ȍ~ elAثm T.?DriveLock t>[F10 MS  y_Ԡ7>w`E~: EBSxtkGb@ȿO xX~ioiEcUSB ӅAXPXp H Zip1Ԗ 2b 3 4"567B8910r Fn/Ctrl%̐ؑ ǲ@{`\p (USA) `|tB#fo}X
KVP&ds
v C\7gŉ  w}ZJ _ rIo@嬧 cWo%ACY O͏o̧pblNi!WANj%M`Blueto#otg /#yjְ>ߓd `qIntel  Executi@DisabCle`0ԯ..12,2O,..odhEthernetX I1237 gPq
 AOKO3O@$OF{j) ID P7bfN P     ' p\f bpU?ke j] o \(P%*nP/h /!!!) MEUEwo **} ooo* w5bv1 : [d . % ]!O<2 !gOv3		)J*    5 %o?s'0njvSpeedStep technologyu␨ 	_Dް Ӱ px(b) 0F12QԁibyR ^`Qb!q[B  eBIOS ATA DMA]k9                                                                                                                                                                                                                                                        -  ` a b c d e f gt" !M         D  	 
       
  8       v    h             Τ       b  / 0   3 4 J 5 6   ( )   , -   * +   wOnp
 N ]% @.   0OnOnPOn$Onp+On 2On8On ?OnEOn@LOnROOn`Y U`@E<BB<U> FبE0`8l v x|v||p0p7c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y ҡ$n  %Ap{ E%  IC&O &U    Y'N( ~ `' ^    `!)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'/@ (#jodߍ^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] σ} !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'o(

C$: | i s+'()+'*&83&

OO
\?()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|     { g|OnA } On^@  .@ | bOn@ TED @n.OnL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
On9 SeOnXdOn2bOn fOnhOn@a@P  gOn@W{Xt|dU Zt}[\}#L  ]~&  W_t`$ijtVa!
	$
U\ 	~ 
`	
U| `
`
Fa
bcDdeDfPh(>{&$`On6@ `   @
 j( 
( 
r Wl0 m | o : *R  	Onb $/ 9 
 VF10 Setup Image_SETUP  P0Sq O ; 	d *vT@JäH"IP Ra|` 
6
&$U`ԩC ؄ TԫTԠ**<gU!"$Dcz: '᪴4㴴4媴4紶d骴4D9b` ޠ: (7  U)$**$+U+$,,$--$.C.9 .hໄ U0	`9 HE$Hg4jHe@ #"" $;" $" 
_8 b@JNu@OP>P 8 ;	 
      /	
On&Xc  b"  N  % ]   Q' 'U#(!(")R)US*T*U+V+UW,X,Y-Z-U[.3W
eU/di0i3djjU4dk5k8dl=lUdmLm\dnBnUdoEoFdpMpUH$IqJdrKbzOnpqjIr$Js$,i]_cOn@  }U| ~}`~U} @ }U,~ "`8tu wxEҔ~zr{t  }tUl 
O5L5(@4 ^`yUpJfԖ嬤]` *dd]U;U`
ff 3R{yԡ  & !MU*@ 4 : N Uj@z @!MU0@ R h  U@ }@!M @ U, B V t@}( !M @؀W!M.@ N n U @5 @ @ U< ` j t@U @ڀ!MU@ 6 P h Ux@ 5@ @ UF f  @5ʀ@ UB d  @}	!M2@ V   Ī @
@ * 6 @ L@dt @ @@ 2 J b v@ @ڀ @@ \ |  @ܚ
@@ \ |  @A@
!M&@ > R d x@j @ $@ Z t  @ʀ!KM$@ 8 V Ud@~ @̄ @ W!M@ ( < U` @ @!MU@ 0 D f U@ U@ M@ +@ 
 U , D@lՌ @ T/@ @ r  5@@&@ U\ n  @U @S(@ d  5 @@@ U , : N@U^t @U @M 1@ \ Ն  @T 8@ R l  @ P ~ @ڀ0@ t j  @(@B@ h   ަ@C@ j   @
5@   , > T@h @ت @ ?@    $@*<F N@Tn @ @Ā̪ @ @K@  R $ JD`U| @ @!!MU"@ > ^ p U@ M@"H@ 6 UN r @ĀM#R@ j ՘  @$T7@ f   M@%Z@ b Ր  @&TN@ X v  ծ@΀'@8@ CD V h*@x 2U @M(]@ & U( , 0@4U8< @@DDU\^bfUj @Eai @)T=@ @ ^  5@*f@ UN v  @ƀ +T f@ : T h U@ S,b@ N t 5 @-l@ U4 F h @U @S.m@ 0 B UJ b@rՠ @/Tp@ H Z  Ւ@0T@k@ T t  M@1@@ | i A	@2@5j@ ~  3l*@ f    4T Y@ 8 V h Uz@ 5@5 z@ UB V j @U @M6@^@ D T iiiiA` @j 78R@ B "f @5 8@@ U: ^ | @j% 9@ T v  j  :@R@ > iR z@ծ  ;T@@ L b x Ռ@<T@ 0 @ Z Uf@ptx U|@ 5@= @ Ut   @S2>@@   M ? &@ d v i @*@f@   A@@ @ X p @ @B@w@ , > h @К "C@@ v   @.D@    2E@  Ԧ F@ h j  @2G@j@   H@ z   @2I@ z J  @iSJ@@ , @ Un @U @M K @ 
 U  @U8 B@JUZp @% 
i@i)iLi  U@@^| @Ȁ	iUMiD l  5@N@ Ub   @S O@   SPz@   SQ@@   SR@ |  M 4S @  M 0T@  պ  @$U@ n  C@Ҁ Vi2J V r@i@iiQDii ZiW  U2 > D@VUp @5 X @ Ud |  @5ʀY@ U> ^ h @ Z@@ Z z  @[@U@ 0 N n @& 
\@  U( D@ZU @ڀS]@ 6 R U` f@M ^@ < Uf  @ʀM_@@ J U~  @S&` @ ~  R@ 5@a @ U< H ^ p@U @5b@ U8 J ^ r@U @ԀiiiAc@@ 8 L h |@"@Ԁ d@@ f t*  @Ԁ%M 
e@ . UJ l ~U@΀  f
@ D P p @J S
g@@ \ r U @ i@   h @ \ |  @ i@@ V  j @j%< Z Ғ 5 @k @ Uf   @i l@N@ $ L X f@ j@րmS@ d   Ț@n@p@ \   @
o@(@ d  Ț @p#@ l   @&q@@    r@Q@ \   @Is@(@ ^ h | j@t@ * 6 > D@LTZ b@jrz T@i @5΀u @ I 
"8@R@^ U@  v@`@ 	J@fT҂ @ @wT@-@ D Z ~ 5@4x@e@ 5  <y*@ M  z@  M 
{/@  M |@9@  M }@@ x U  @ ~@ D Ch z@h 2 (@ D V@iQzDiҜ@*Ҵ @Āa5 @@j@ U 4 F h@Uz @M(@A@ x U  @̀5  %@ U^ p  @5Ѐ @ U< ^  @̀i@ *@ b l  @Āj @@<@ F Z ~ @ @@@ & H f @ Q@ P* p  @i5  e@ ~   iU" , > UL@`x i @ܚ v@ @ X p @ @Vi. < iiiiAD `@v @L " v@ R Ut  @ʀYi%. UH ^ t@պ @*  4 F iUTp @պ @T@ $ 4 R Un@ )@i @ii@
r@ N p  @@ l   @( @ h ~  @Ā@ < f  @D@  , >T iNj| @i @@ l   @@ b t j @ @}@ r   @@ ` j  @@@ l   
@&@ P v j @@ L j t @ ަ@@ < HJ  kV@ifi@iv Ҏ @$i@
iiK i i"J ~@Z  U8 V x@ո @T@@ R r  5@@ l    T@ \   M@(@  5   @ |   T @ x   5@@ \  	i @Ҁ	i@ F ipHDiҐi I@i@5 @ U< V  @5Ѐ$N@ Uh   @5Ҁ@@ UJ n  @̀2 R h @@@ P ^ x @j ( @ p z  @ @ @ f   @ʀ @@ `   @榀 @ P t  @΀2 _@    @@ fT  @ @T@@ < L l U@ S @ P p Ք @T@ R x  @ЀiiihA ̪@ > \ x j@ @ J h  j@@ X ~  j@؀@ P j   @즀@@ ^ v  @Q@@  2 N Uj@ @@  L @ @  U$@<X 5@؀@@ h   T @ j |  ʀT @ R f  5@, @ U|   @ʀ T @ < X d Uz@ S$@@ ~  M @ v Ղ  @T @ d   M@@ ~ ը  @T @ l   M@6@@ ~ ծ  @ T@ \   Ȁ ȀL@ d   @؀ @@@   $ ,@4<D ^@fn~ @* @
ҍ@@ ,T Hp @5 @ N 	rj @ª@ d   @ ̀@ iU\  @S@@   M π@  5  @ v   T@@ v   5@Ҁd@ H h C *  @ڀj2@ @ N iDiҖ J@΀@SԀ@ & B Uf z@5 @" ;@ Uh   @5΀ @ U8 \ v @ A׀E@ B n j @܀!@ 8 N l @ 
Qـ@ iB T Ub@ @ i>J X j iՔ @T@@ H p  ո@ڀ$T ;@ ^   5@.݀@ ~   i5 
 @ U: T h t@U @M@@ T Ur  @؀M"@3@ n   @i@iiiS@@ B \ Uv @} !M*@ UJ ^ z @5  @ N n  A% @
Q /@  8 R Uj@| M@ @ : UX  @5 2@ U^ t  @U @UȀ @M瀂@ r Վ  @T@ r   @
:@ BR R iz պ@̀"T@    @@T@ * L f@U @5@@ z   T@@ d   M@" O@  ծ  @"T@ v   M@@ l Ֆ  @0Tq@    S\@ v   @i 6 L j@J i Zh i   i(08J >@Fi^ Uh@v @ր
F 
@{@ i  i<b ~@h@ jT Ҏ @M X@ J Ul  @րM@ T  Ҩ@Ԁ@ f  ̚ @0 ]@ j   A@    @ x  ʚ @@a@ J* b  @C @
@@ i2i:@TiiґDii i& @  U< R@\fx @  W]@ 4 F Ul @_]@ 0 UV j @ղ @
]&@ 8 A^ @ @]@@ ^ h z @ @ 2 @@ F T Z ~@ @]*@ D V z @ @]@ B l@     @ J f j @ڀ*@ p   U @_	]@ , U: Z r@U @_
]"@ 8 UN j @U @@@ : iiiAD`z @4 @@ %U2 V l @U @#
@"@ %R Uj@z պ@ր W]@ , < UL b@U @@*@ J d v @ ,@ , < J X@bhl v@ +@ R j  @  (@ ^ ~  @U]6 N ~@Ռ "T$@ z   U@Ԁ S 3@ D \ Ur z@ @]U6@ `   M@7@ < Uj  @S@(@ ^   @
]U>@ n   M@"6@  M @A@ f 5   6@ U: j  @ @@@ X h v J@S @ @Ҁj @
T" , D b@x 
ҠJ@̀@J]U$@ 8 R n @Ҙ @ M@ b   @$!+@ x  Z @ O"@-j@   &#Ej@   *$j@   2% Cj@   6&.j@   :'@Pj@    ([@ \   @@BD@Vhx Њ@2))@@ 6 ^ niiDiiU @*@"@ a. H R@Zp @ր.+]P@    ,@j@ P l  @ꦀ - `@ 8 T l @К $.@4@ `   @/f@ : T v @ 0@J@ D L @| @1 6@ \ x  @Ȁ2m@ f  j @ 3@ r   @4 p@    25@C@ R  @Ԁ5 6y@ U> P Z f@U @M7@F@ X Uz  @ԀM8{@ d   @iiiiA@⚀9@ <* T l @"5 :L@ UT   @Mހ;N@ b U  @< , T r@ (i $=@@ H d  @ >@ ` p  @Ϊ @܀ @? @ x   @ @ l@    4A@    B @ UZ p@M <C@s@  M D@l@   U0 F T@d  * E@ Ւ   FT@@    S$G <@ ~  M H@ x 5  I@ U\   @SJ@ r  M K@A@ j 5  L @ U\   @i M@@ B Z  @Ҁ  @NT@l@   * 4 U>@FPZ Ud@l U@ O @ ( 
6JN@^ Rt@؀SP @ R r i@Q@@ b ~  @ԀR @ D ^  @ S@@ zj   ,T@j@   U j@    V @ z   ,W@    X@ 2 T r* @CM@Y@ < Qj 2% @ iZi
@<FT h@nԀʊ @4T @[@ p   @\@ H R p @j ]@ 8 L l @ @^ o@ R v  @Ȁޚ  _@@ Z   @Ҫ @.` @ \ t  @؀a@ D P V ~@ b x@ X z  @c@ H   @0d@ j   
e@@ , > N b@v @ f @ : V r @ g@@ H h  @ iiiiAM
h @ L Uj  @Mi@ J Up  @؀Mj@@ h   Ԁ
k@ : P p R @i Sl@@ F ` U @M m @ h U~  @U @_!M @Sn@ l  5 @o@@ ^   pT@ H n \ h@i@ q B@ n   r@ j x  @ @s@ " 8 J x@К 0t@@ j   u@ j    v@ ^  Ě @$w@ j   x 3@ t   y ;@    z@  j  @{U  ,. <@UZ hU @ !MK |@@  U  &@<UFP ^@U@@
i@}ú@ n  @L~\@ > Ud  @5 @ UX r  @րw!M@H@   $@6@   84 @  "@ 5  N@ 5  *3@ ն   TG@ ` v  @C 2@ P i3*@ iDi3@ !M: N V@rx @ @ @ H j  @Ҁ?@ > N j z@* @AS" O@ T v U @Ѐ{ ~[!M U2 N t@ժ @΄h@{ @ @ > P n j@&]@~@|@ 6 Z  @$@.@ j    c@ R   Φ@ J@ X ~O`!M U @M S@ & U2 J Z@|D U @M j@ @ X p @A/b!M Ԁ iiiAA j@
@ 8 N d T@" @MB@ H b | @%2 @Z@ D  X x * @ȀiM  H@ 6 UR l @U @{@֏!M2 UD R j@vx<KgW!M @5x@ UV |  @M@a@ t   i؀L }@ P U^  @S @ > L Z j@zlW!M @U @M@ f U  @Sr@ T d Ռ @
Tu@ b   M@@@ H Ux  @*^  Ԧ  =@ X   @Is@ X id Ur@ U@j ?J!M
 @ }  Dt!M& UT .6> UF@NVn Uz@ ͬ@K@h@ ޜ$n@YJ, U\  @Ҁ @ 0 X  @j @ L j  j@̀<@j@   zj@   @ p   @    @ n    @ 2 R p @C@D@ @ 2h@t ҺiDi@
@  $R * a*UD L@^vU @ƀ@ d  j @@ 8 X l @ @
@ F j  @ڀ(@ v |  @܀@ P ^  @j @
 @ 6 Z x @ @ @ p   @ @ `   @@@ f   @"@ UH R b@rU @Ѐ5 @ UN l  @մ T@ ^ z  U@΀ ii	A :@Zr @V "" F U\ ~@5 @@ %` t @j @T@ D p @Ҵ @ @ 8 T ~ @Ȧ @Q@ F b r @J @i @T@@ h   M@@ t 5  Ā@ > j |@ @@)@ T   @  @ V f x @ @L7@@ : U^  @ԀM0@'@ | 5  
@@ Uh   @S.@@   M  @ n 5  @@ d   
T@@ X   S@ F@ j   Ѐf|s@ ƪ@ J X d ʪ v @ @z@jȪ@ @@ B ` hR n@
|I ҮĀ " @ rJ   ԩ! @^ 
@@ J j  @Ѐ@@ T r j @Ԁ@ ^   Қ@@@ l   @@ T x j @ ׀@ p   V@C> L Z pD 2JV  ȈiDiI @A H N@p @ @ z@ p j  @ _@ T f x @ @
J@ < tR  ҸM ݀@ B U^ r @զ @"T @ V d  U@ S
@ : N Uj @5 @  v@ U > d r@U @S @    @T @ t   M@ @ 6 U@ H V@bUn~ @U @̀5 #@ U0 B T f@U| @ƀ   J@ iiiA(@@Zx @V ": b U @րS@@ f  J%@ҀA% +%, P %Up@ 5@ @ UN b z @U @S@ @ P n U| @U @ʀ @T@@ ` z  e@.cj@   @ : b t @ @&)@ h j  @@ F T d x@ j@ @i@ ( n  &@>b@ ΀ S@   M .o@  5   h@ j  @)4@ l  jĀ&d@ n@   7@   Қ @
@ " >: V@|RҰ@U @5 @@ U   $@U6BJ V@Ur @
 d@ 
Ҫ X  @j W@ @ f  @ }@ b  j @ @ b   @@ n j  @ @M@ z    m,@ X   @m0@ N d  @UmC * B T@h|2*@ i1iCi"@DJX r@x$PnPOn/ /      1    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй `s# hNfP u	fX@  h aZY[Xg&ۅF ;9   Ã tfPfS
u	p  bf[f}XRg&u-g&
pAgf&A"fV  Vf	=t@/g&ƳV9g&PESWVfW&O*f%Vg&D= $ <vD# D| u:t+;'_^
QRfU
}0t[R>tKutE$fu
0t0t	dp:  f]ZYPSR uIW)_rIW&u5qVt tFu
:ǅU. %+~'<t< 0
l[ZHZ"P`0  ;p t; tށ t
t4d> ud:>u	d:uހuu o@ & u
( 3 uo u_X!
j0od:rq 2fSQV3Ҡuyy  :ut ffKfy+-Ƒ3  49fnP'D%g$ЊFg	Yu xQYr14"Wu'vx8Y x, x Y^Yf[PR 
 Z #R;;=b;a>Ҳ;!? <SDD"!US
F.>6A OfŰCEf`Cf2FRC|xfWAaaAfG E f~QD$
pD$ f|u6_^Y5OfQfZVffbXtf8Њt 	dWD 0 rfP%A\2YP	Vu uff0SF?t!hXcgvu}\>t]6f뿢wup0f7:f^ffKV  ^#Q ߱ ux @>tgߊT% us]S f!%#$hf,"%@ f@%90nQRV&>	>W&N N BU@߾&V&mfDf% ffDs7 ^Z`!u^.0f 4sp2(2{É4^^nBn@& D5t(Pf sf
  WXfff8[3`6'E82`D1~R Ih 0PPVVVVZ|ZVZS `So<1 			;/acZhpcR}cxZ4Q2p(`C F%fQfRVuu/7 1M3y o P  	 6=h䍚a_2( MQ   f3۹ f`dTt ^ Q ?ހZp8@0XFfC/>@u$#wkO5ys>GH
 "o
d
.Wu@1?H7VՅ`,VuZFFVu FQ$Nu$G^fAɢpxx Pͧ^"D	%ÉD	f:Ƨ-f ʃ@v@ s<v PfUKfЂLf{ Rf$f6f> f	>fBf ,ff]X [t `-̀Qԁf𔓉_`y RӃf3 Zaptރ> t5u A@J@!v0pೀ
0x@@mבRV"T ;f;tff * F#B$K bq gfQERڀ>  fù f1C;t)gf+ր C kC@Fi]`*Kk e1>SRPVpg ^Aah3 ;u; p;b7P7VXf.0X  &
d & 
 R #  DH ! 
 6Po ёd J% #t@ ,X^d !"}$hB "80)
 . Pph	<
 0$,yL	
 2)Pq PP  (# P4!  	  @
p	 >p 8J8  ) p@: >  * p  %w R R!	R2
X "

 @&(xiQ)	(.`+)d )(b+"P( D: ,Ȼ2	*z0, LU(($!pU'#	'$	#$	 T*	&
&
"1
q,

F1(AhBFK4CO''A,A
/	
#	&hE$
$
A5
Ip:0(|:!TMt:BJS'y'dQ$> 1#uU#!,)$3+\ +F'Ya:Fq=DA;( G0$G"w\D#GV9/'ANd@CN)$
$Qa!q>Q!Hr>PRBSRAh93e$bNL'UnqM#uYuQl!%Ai
$
$ y(Jcp(dpy+t@
 >\c8Kss'tsv Q:y$y!`!4F;	(D@a䈣!vlxW'QJ#&@$q3$n+$3	8q//  @i@v
 v $a #
 `"9	 w aZ izazzT
 " /	 !=mKap{ 	 hw Ѐ S
PRfWfg&f_Z!R P ZPððÁ հQ|  	`@  :] 66 r q!^B !;P  )aab/`(9T9@@PQR5S>9|9 UWRQSPV rw6t ur6ffWRfP0 eXhfZf_P>6u6uaPS7 pu6@666/U66D[XF f sf|tf P[YZ_]e È66أQ 6 uPu j0fd!u!6! ȃ uddfd԰  >P6oSd ddܔP (66ufUg&t=` T=f]t,>@u%ttt t	tfN tƀ)r@uzaln)s
 1Qh 6*OuFk w.!u$*
VWێeS~ tOrt*?{ D`*f f0T fffXs "qy#uptLe6 ` 6 uYf3f` fe6Wpe*&68fw*fF*2t*܊e&6fX^fY[f`um'n!(o6  ="֐  u(g&pv6z]  t(]9=faSQVWU&u tu **i]_^Y[LS-120ZIP 250PSQRV:1:2:22PKp
y<w
m z
\5	6*K<s!hEfP u	fX@  h rg;<tV< uWQ5;f g&:D= uFfG(;**X!X  JAZY]f`uu 6Qu666660] RW1h

N} tE2B*/_Z[M-Sys   DiskOnKey 1 #aBu u @  f<x fPȿ f/<"%|= 2r 0w"1s sU3IH t gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&c,f_ PA	% rLT?*f<?7(*QRRV*cF5Qome}9@**0;; t0ht3t@ u u#P-30MAwf?LfHPN N 
~1fXuײ?D0U @0B0B0B0B0G05F6F 	 *g*&3FPRrco?3W1>#>;!2>
?_ÈYhMGPhۙ`p& 4  h1< SW+ߊ 1s!$?
u$˄[         Ұ,X @xjY rTB@!tn@  i|X  t   `Z 	bhoddfHff@ftnPJf&jh6\ufj6.f ` ff@fP  @f%% @@@f  z6fAf=A&  `  fAVofA`Df=%t 5t;@3tZ0_tZD_fX$0g]A   AI AS~f@ ot@[|P A"sƑ tDf  f qAߡ A<Af>@ u ` _D  2ft.?tn@P +rfu$@@s11 >@@!R0@'Vr"b"0ܰ f!1VC@f,S	  tX|	*rHZ'	"	0 %9 ufm-%tq+00 P3  ҂ 	P@|tpa ~'	PΐX  r?f 
 pQDP؊*A@6%f>
AgGf	gOgG]`db>tO"3	0	5
`6@#Du	%&tnf6
Af	f AfIng^g~MW!
*t4h 0		0	 = FFhiJ<t
 &N5q*pu
 'X*؃ CN&NA&NqN&i.bL6%@( @f (f 42a3uf@W  bf+`сawSgff9@u gF9@u 9@u
gF9AtgN<XfFAzr=БC=@rxiGsVfS'`c(gF'	@g^ Yg0O G0ogF V* /e*eP`d&b&g&g&G
ǿG
 d0Gd*PGg&Gg&G
 G 3gwiFp;@q	f mAkG^ @ZPfV csf@md=f p^fIf!@&@@+@(@  @ < t@  ;vȉ@qv  f@
BqygfgG p j,gG
	qGfu"a ?Hf%fE@ !gG!&@@ Gtbk!f#p@fcn `_OBL'PR7з[fS
f35 !f$f\Qfp#{- # !Siy P9tt ``U``a`bI	`c	0]	p0^	  
		 
			 				
| 0hfWQf˹`1?Yf_`QD=f6D=6JKD
$>6%
ĈD
6r% >6bASZes*K6ZrI`d
QHr7R@|= USBSug&|= t t
U	 	`6T 6wӡ p arQrY C0jV % P`zK`2P>6t QXrIt2sQfF`~AdY.rSf1fM^!WA@KH\
؀e܉\bJ
prA
x @
`
L!?
0
"қsTq
{aWa'4"CS# i?D=qp*W.?43'`ـT2' oKZ(Z
2(
_7
_=%rt9 R$RS$2Q	@ ?P@RP2 3* h *Ou ᠅ T=
XS<(fT= & y#j666 r}fPQtA3`>66pO+` pta^Vu6 6 +.?Pf.6pOPpYfX`PI|G<6 fa9?,AB3U+*/G/%QfPfph`1x@YfXY"N0\ؐJy?;G7/Osc`:MoDABA<e=S$l=38%rpq6Ot} Ot Ot6D$_
ƈDFዠP!r r
9rY׹ w/p%tFPtt=tT= t2:t+u:u ghNodty(u~(rt{^@O=@tO=tO=`	tO= Oh)6`oXaPSV68dtd}ӠrӀoӾ68DtD$PؾQJKPhӠd^[XSQ*KO	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܟT!
 ʂ 	b.>  
   VVo      2нS[U[PV&VZ!%ru
>V *  > X * tVVV>VVuǾ Vİ'PSCrV_4%VVVV賳ÓQ	`P$`
3ۊ `fV&CWjVDW3 VpVSu@t	Vu<[^@pVuV "`bVu^Pd4 u:ˀuqS1u^Vuʀu[^pqq?fU >uuS>JW>uzҊ&GWut(
ߠ_VuZ VVVh[}4@vf]AA`Ft>V{V r1߻FVw%0rN "u6Ȉ0EV h66bdhEYuY!)Z J`RQ	%pot1FVch[WIWT"rIW&uVuJWzfPSQзVf3fY[ffRVff3 Wf3"WfZ2F E *  <FuHW3t	 Dt<Hut2ZtZ >Ȁ$u tPaX]EW Y7BW uB<Ft<Tt<et<t<t<Rw*<Ir&HW
2@&tZ>GW>`Z4<hquriVVW@ξ HtAQ Zft(P:FWu 
  gXfCYP⯢qq q9~ w2FWkYⷠEWDt&D{W8r m>taRw
$_^t0%VHWV Vf? t<CpR<tSQLذ&Y[ـ u
l˲qpJ@I - n iSg8   `  8jth<
   0  p 	 	 	 8
		
	 						
 

  fWQf04avQY`f D5 p6666sR (p6zľ^D
$&o6
ĈD
 1Ts f_g&|5 EBr`jr  aï`]mm	 		M]`UR		`:^H\
|n6
܉\nse bJ^xQoaJ^0՟@" cc͐Ăr`܏͏͈-̈́&p}W3
	#rgqW?t0?Y"@ f#a=ʯj(~rjdu6Dأq='a#aآ#apfqh	 Yv		xvbF
 T `ȹ !sJ%|=td%"y:Cur?rpq!(?~rg`2oQV]L	;t	nPAŦ:^{=^A ]Η0   0   ? RrE d    n  A` P 00 3`  
& Aa %  	%
0 #
"*!
 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
: S<R"G 3D%M TVaXCJ UK8'(XAIc  WI Rjklmm
nCopyright (c) 2001 Intel Corporationf`@ f.A<t<t$<tc<tK<tSjf&jvn sfj   uh ~  uRRf|ADf380=ISGuђ s
g]j!t避 f6j	gftcRa tpt5Htn @u  u u0 ߰}# 2  Pg f%ᘅ3 
f>AfDt	u)fA;Awuf@ffhi|tfOf"Qtѣ
0fs
B  4v@#tz210!<ug


7	u\	Q	'h/ś_AKf6
A	g u%S F A s@[%;u!,Of=4R0	ff4	)ffp	Q(f	Of@f[aSfSfQfRf}V*sWvn15 uBT tApN@76g88fI4g^f3f@70n@7f^fZfYf[fP"Vf@f@f=`Bt"f=о &f= 0//f=0 3f=@+=t8t34 , 't"#
ttfyn0 rfFgP0fXURf.  fXr  >	 QfufQD8@M TR2@(2Of2f30c)BZ{RO>V\3h6՚a2( MQ  uf3`_fbDf6E  Z<tYatG@]_ToK<u	ŨupWJ$< t<0t$ RH]P?y"PWT%j_uPlAP#,RfWPR;Arfc%1f f>=	f!Effg8u#>_4:44
f@[Jf_,,PS>t{w&]21=`Q1Yr;f.;rt3UufrA<mpf|ffm fPtP= v	 +v:P,P}rf́   :rfP  6r~1|Ã tL_;fu ǰǋ;Ptrߤ Q.rB
rrf u0`b h2-Ña:
rffqp	f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&[GwG0  "2/t"t׀  V   cu'[0i&w j3
G94g&G}Gfԣ fCfs-+Ӹ00pD;gf M  h쀀1"c`WV, `П..`B@ԑ
>t1a  	!  !  q  c  " ;;  @nQRVQԴ ް u u蜫g& 粰 _u&qupݧ!(fug&Po!	u*yxyx>xi06xp` }Π1	u	P!"Y 窀>kup$3۰w	%1+uF &
@'uu >   ?鮃!uP&C Z݇PuxtVt	uTR1=ud:u< u2d>g u	a (!u yufufdxd= I^Z`Xg&8!u	g& DtF@sPVS ~u| hN3c[^XSRVvu?WH^_+;7»$11ZUf`(ӢLǲ&Ok6]Д r0 #3#V  56؆8 PxxxxxxxpSV.&tvxf^0sQ P7W> yxSRȰWu<v
y,_y@@xʀ 7߶uG ˁ7r )>`́@%:S	1 y y":xw/?x襧
/	c twadh
3	xrg&ۅAEtx}rxdr"xʦKr
 JthE	vcZhtĳx{=2oȧ13
B	uaCU$uTXp Z#,诽[$$_;tR ZO{R J Ն {P&abpZ&&Fd`R{< u12_R1RgtXr),u)RG`SQr9R'f$8t܋Yqtr$V簄O㰆HAr(<Fr^(!sqtrp@pp蓶q90` f8 f܀g' a`  @j FFBZ`b j nb PQfWfVcUUP*`P U hX-  pu' ,G~ .;}t3P_YXhŕ   $Һ0 ^	  'J4 "`".u2(.} }s0 paW
sfUgg& suf3Ɋf`ѯt0fYpVfWg<t,zfUgR r!8tfGp^fZPQ7$@a@8tPAvUvP8F X PS±&%p #؎[XPSⱡ%ga@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               f`8P%,Ⱥ:#%j  t4 %  ߋع ;uPXف      t(  >Xt
 %@  Pé t u>  u   q  tB @ J3p
%tNtGf3ȿ f ff3u@ fgf&fff#f  
f΀*jB XfafPSQR.a#؁_ Ӂ~~@t%{s	%PQ#~Y3#P1a ff
 pq'uf%fZY[fXC!
hQ I'u<۳f d`ux
  =k  `5  t ehFIfP u	fX@  h $  Gog0 dt`Kua/
 $/L/ %ot
&,Q +fp*f#"$+_ 5 q 0f t&@%
 ZAff2 ' *+3-Pu
  +qf/ZYfPS8.4 L.T* T>.hX4,;"+h4f fg&##Rq %5  --4	--# -30-؀@8@uRr-tt@t
w1{j-g ,, O|U,3P b/a/u@%+h$'( !_!  ,-.?/01289`E      x `a 3 {ſRRF 9$aaYPoG3"_"
P][2tN]	 aÜ`>@ l>l!GA lBla6$?C ! G @ A  B  $0sF  ؎Xn "X0GBnnnJF$a %JF0P  )< tq ̢P ̠̡  VޢW    llB  ؿ lBB@A Wl@    @ lTТUN!&1'HNw /!%а 
@  
FFn  	n	n	n	n	nj	n	nnn 
 TU ta  a@Cd̀`  3nnCQ q
p	p.nA
` nV 5Wq aPfWԁ4g&g&gf_\' />                `    [TF(0 
8	$ tH
C
T 9	p'
' u B9	K SRp@B u$Z[SfQWP qXgg_fY[ Q
`fg׈fWPSf3f3ɿ;	f0<  P<
f; X tDt:	[Xf_ZfY<fPf0fX,fV>fVf PJE gf^]! f^	V					:		:		^		f	W		fWf	_
g&' f @:WV!  tO
ъ#%"A$%hT
Q 
sY
^_W>uzDs

`Sti X3S+[C vS3ۀ> t"t+t:+tC  [0t<w>t8tз{ 
 
茥ñ  S r аt, 蕰 g++Q+J
t~rc"T5P'fP	RA+rA a	 fXyOt8%3ޤP	4Á{@t1-w&ؿ㋇+.trwRat0
p{<< t
=:@ 0  +р>@u诨t+aÉ  H,"q

}p2"@I("J"@!؃@P!!2J
s3y@si  {Y 11F0m莮:u;pu;th=P<{1<-!  ww
210`r &	&o
À
vo >2  22޸xGfSpWf]2ptE p  %p ?[hx; 'Q W C$3  G4g&tC0f&fft.f7A MA `  u^1 2 dFP h*]  '  luuh7<Ka@$)#4bAl  aR@Îp  ZPQu4 pyKqb hYR0Ru WhZ	
2
B.&g t#.g&'' T
.t&*c0 0~rRVhv>vtDh^xhr(hus*r2, f^fZf` ;2 >rb2> < U7rTrhfaf`Y2f@`Pf3// pf'X!7"" hQgf`/)
4/O
^ "	 	 Rb"	
/	(	A&!_!!!p!hsBth4StwG	Prff
00&˃u Э 2fà{t F<t0$rf2@Ӑ3d/tfQVW<¾Z 0 _^Y}TfzDf}e ɣfބt
t^%Sq^ygfM5rSQ?U. PO^Yf[WSQRWVhpY?r=ыt
 t
uu	  tt uʋ^_ZY`	јfQf&:Eb3:EF c6W p 2:> u6 GHt\o hk/T3Ҭ؋hoeB^_f,f
zXK̈́
>
/2

VTk>T2@OHp
Nt.
OrY23 3/ 35C`o/ / /  O3`<RwS2.[@ø  а?fQhʐ_4ufYۉۉ;aEf3ɋPNo`pXQް&G     &Wft ffBf;Pgfwlw~rtwR{tpff@hp3QgfY t?gho.AX0Y[0U%>{aPSph)Wh`2f[W  i    `  n  f6E,f=HIBMC,@ u_Ff!  g.9u
g.RRFfkǿF "Sf= @t1pu  ø PF>Q f a	 Ѐ| a!!NuFgf~fsVf  t
fP#ffA1fyg̃fY#F$V f;s	7f
	  fV2~(Ff )@ f+s
0	@Nf;sfȶF@	rf@f qg&g&fFfGg`^N &Vf fA=uTA$<ufIg:!
g
@tT	fƹ@f  /<"   &<"<"
À> tet 
8s It 
tpV$<
v
  9 t>4" t $$
ؐ 8hi$ u
d tP{ XO(  ^щhn%
}
>d`
@

#
 ðܱu 4"&5"j 4"5">5" u
8w}p[ثD &aWxb)G@f`Y Dfܣ HfCLfPfǣHb 8 f@@@@PPh >ft	@pL	f% @ &G<t<t<!ÒPS$<wr .$¢߸ ~#û  t 6   ;%` Ja mY c!t	&  [ C,%fbP$dPbPPNf%fE,Nf2 #tN00r$|tE  tM`Dff3fEU  fPӸvpfp<*ɑ_<w  a fXff
phEu
Gs	    P{-
P XuOBDۅbES!f ul(  [>D2P 
X	
@2uP{2Dˀa	$

Àu
<X[XQp)a؀a
2t P@<KrKX PR6'Z@ .6'y BZ s  ""
ZP F'' Jq vJúBQ R (
PBX
	ذ4ߨZQSW 08_[s(((((Ə((/ / j 3;CKT^|3=GQ[fi S[z3<ENWa~r8<AFJc| _(à@ PP !ظa?_,غ:%  3d` P ȳ_  aYrO0~6333  
@|f 1ffg)MUfwFFR>`}NT!t"ffvfXɯfDߑ fpfufT0f M "  j0 F@ +fr T  >l
 
S1H HP)9F  hv M m( 9`HQW0
**y P{NJ_P+z P幒|"A~ðMh6焿3
! ڃ 
j"N"a7,% O   % /b.. T 2-3-6"2 $-="! 3% ++
,,,}2aO-j" 7?-N }+,% 0q0.&,p  w
   2  TI,f`3_bt5tf1C,I,_fxK xx- falCTNI _C,@060f(0f͡bЉ30t#-p>`#-#-2
s 2TPcUV{<2p2 PG c$i v//[.  >(0N^]?;2 	?s  tiu%th48u<Ur7,;`
K-! ~`@uC`
 
 `)@o ߀5qo@0ÿ́x\.S rӢ..}Ѓ$rVz.t =}rـ7u_hοرJOJhRdL2f.fPD0f.q A?Yhż?P !H r襤. mb J o~h蚯u`@h_0.0𮠀E
03!4=+t
3NO+t3GNO`UN000&N 0쪺P aT0SR 0``a@y  ᭋ$fӃ0[QXpf<fXfX*fXaheh=p; 'Q W P (3uuu&gq q  $s=[hk_e$PvqX! hesh(qY4pY	CYd1Øϰ~V1V ι#vP^2F X PSό&K2&I2&G2[XPS
K2I2G22W&22AVDWw4Wzàt<8<:T2p wPa 0U xXf+8S8rdd rQS<dr
d2跮ts B@p3c 蚰`j & zV܊&cq6r t+; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             K d!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( /(     ښ    ς Ͽ g `gw  h }    ;p   s / :h 
;! 
mބ<j# :S          P     @     %X%H_&                                                                                   W `*} U` UPUzQ@    @ 	@
 
@P X@Yhi j@klm* n@o { @    3f3ۿ%fð_fg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>` 6a  !}X[ &SP7`\@ /'aV&&@r
f3f׿僰gf }f3fh @@p h &üf`f1fffef   % ŀ-f_f0M0U0!0)ffXf9ffaf 
  fi@] 0 m q  ,f5q f~PeP jQ   U͡Ap  A` efaa  !6>eуp Ń ՃPك"` peɃ T	
e} fe&u` b "jeɃffeߝfAffgd:ugdfepf3 gCT "8fF3ۊdeր3 
td	  p)H @ۗ 
peuxu._RzTC u:/
'
%&bfgfd._S` [WP9A`XP&EX% &E_YǨ ooooǸoc׎dΐff`ffP fSIMWuUfg0f[ Qbr6fc;w(h,UfKfap p`p f&?SECUtC)fuffQpR Phk\g&X?fGذV S 
uOu@f%6X!u(xg&_-?$8IaztKt#αɃGt<Sԡ
~ 塰TTV&VYtVtTvW>hhXO RL@p=yp8%= ]	 =
=uf?I/FFF@ yg3!ffw	!z"On& t
fWfL_f_r@&% m$g&P ff%g&	 tg&  R!SfQfR@u!Ђ!fGtt2t~tyf   f!f,0 tf΁s@ 1^u3
f rFf;r>.: t, f ur%ArQYQ	 f_fZfYf[   t% 
t`A
A!:0.2 r&8"

rlr:SV9rP#j   t
ff;t;0
 + t UD@@D*^fZY|@ pLh^2hr; 'Q W rwp	w	L u ff!` B
fffLp t


ghsGhNRT
@ߜfPhumfX
%3ҠI# 
t3 v0)vQ%PNh]]G!V< t6<t1p4:u"FXj*:+p;) .fY (7@g w.	A_S 
fUfp>t	_--


f+ f
$f]^$*### -F?Xv0L? Cn@u%fǱt  '  
0k$$$$$YCYX Vrrt:tfYt&{Y5A5:
x




FViᑐi^i^fRg&;׃hnr>\|tg&	`u љfZfVfRQP zfOf0paff!>  _3ҹ?AFffZ f 
Ƅ
@],`Y`i^}RfVQS>f" O9*Bt`#ah_Q   7p___[Yfi`V/#	
UpR B]  ГRQ2Ur+W薐 
 ` 
j m0_WVSQ  2ۊbF(+ؾ8u `&
dY[^_fPWQtP{PX"0sY_fXPٜ0LgОf`f&`1A&R&6&P&7` X +_v
`.f&r&&faõr6ur5]]!P$s XY
axt   PfhE)Ec Xh10u쨀t݁	<u <u õr+pr&r xD:&&32r4rtrc財
]J虡9q{pbu`1ؾ"" QYa"VP &` Ob ~%'/~* r!%%F%&&a cRjqpZQR_r#*H)t2_P~`bٵ(t" tvPGCZYa^~r#C0mE/03Sٸ 7 O f & &oEZP &rr8t32pc`.&EO h-z.tGS؀1?[&M.2tð$D 	#h 15 >1WP 04fRj2b]fZr~ p߃vw@5 &E
, #!	A	2ahk
%00`P 0sV%@{Q  Da`6(    c aV魿ī^`W  3 _r- +˸ fDPEDr<Հ B<B O <<4rru)P0W2&*G_	 7&*,u&}Zu&E@_[çDA $SQG>` 2 x<Ot`[	B<tmpI7C77rPFLѯ: r1 r, hOįd!SQm?
pqgct)u$<Pt+gKuҴj]QkBR-QRl @Ql"YluBQpY?@+Vo^W m`? h_tD/>>	>rN|UtGVp@l 5^t1V?h_ 6f^Da  D ; Z x     0Nm P>$
Pd׀u	q  52~XB	 ei H谌ȃI螌ذJ藌2ȉ3' AJSOSQRf'p.Zp"7a   7`)a
$tr+?a?a *0h華TÓh Eϰd/#/:a(g*f(fY	R@jlSf>QPH_u(DP/&f  ݀1q[-r(Q!ÉP-roSfP>@Wp(>f1t  tf4pZ!@Џ f  f 5fff2g&g
fKf Rg gre hջhr s1VhQݟZ,
-{f_fYf[ r  s0RfbXPSfRj07W6uLt;wEf6fQHf8? r/fbP Bfg&rfb0  Z[XfWKu
 f   > Àff`g? t]ǀ t
t@  fO?
 :  @(!e _ f` ; 6frv`gGwf3ې fPfcfPr:p> ff0o;w!fVg&f_^ufFtfᡀ!Qy.`$pft Qg&$9r<&㿲m=f=ATADtlf q:&ǇǇs  S3*a  z[b r1 辁 043ɊȰ	{j q:UFWP#J XU.߀>9   ub >u `	`	]葆pϬ$l0ޑx$C_AR.1S+r[P<?ం005CPQ>(ι c r\d_`1PPAtC>r-t`w 0 r uҊ1 r
-`u`dt[Q rdItf s`A$P3foSRNr&r!ww3҆r r	ʟp 8fsPRcq`areeQbfOQ7 qPQ q	s
d r	rqUV>R5f   dgfY{uwR Z ?}h`YkzCpZ&&&`.P\ P " Yp `2p",u   P R

Z@u
Sذ* o rQ(`( ֐]PS@  I 1' R۰RU  厢rX3DC	 4P>tFS t33J*bjR{
t#4 c ttÈ񒱹  PQRWV88+3"a^_Z$"#Ϡ[1$G<׬uo$V2 4^ûW _ -'"  !(PD )	
R
q0tJ@y
g&/ܱ1q;-r rt;APR(X0aJ2u RVа$rN ;rCr<,	r32Wt rr;wҀ0sڋƿ^ZW
   е0u
˾   
u ~P f! uf _2 J3322t@@ ?0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_......׉6 .R.D@VPCE n w+"$C #g&P hpOMPf]fXX@1U ø8	z1˸pwP#<	r="     Cਸ zCJX C Hك"Iڄ#R:
N6`ހf1r f+fMJh?vf-E^frfϋfq âPAMSuff>wr^
UwS0V0)P׸`X> f&G|	! "f#JIWVf }rY ߁E 0fP < urRf#R fBR?^ bc
hTt.rBؾ@
E<u@
P˸
`]fQR`Z_"a@`\j uL$<tD"ЎQy^r&=t&} tV" &GF^YՃ}"
\ؾ$Ӿ 	 hyy
!
"99


Z9

P 
=h@< '(g  Rغ0 t@ZeK b	fge
	
PQWfV3 #]t-3u̸ag&fǣ\d f^_Y.fUf.6f]f]** End SetActiveDisplays: \ 0R$nt5P)㋗d_;t  _um Zӛg tuPQ2tN
͋كYP  v@t`zP< tH ?O
 p
R 1P3tz0	p $ ?D psU!
 "PעuvQtR	gv9jP0jP$ jjċ؀ jXjXnj@'ثUgf5aY?jQ( *)``;b tQ,jP À$@  QRPSa[X3@=a B"c
`r1 qj oK f`eKOu$kr
u.2*~q	,r$p&` E?&]p@ _ffa .A4t
1?3??SQ/"S~fWU]yf!W_0ð 1ԓ pӰ rH ry0Htp	SfQWBYftu X~AC_fYfq@f`fqf ;v2f_ fa|k_<_P`gf2gawӶut! SP܀d@%?sX	Jit 	3f0
 @631JȎt/O    v _؍`IaWt`>O2}HasEOQѰ_   
0Jhu$$t$
$$a$h1hsF`9连t4>2t,z u<a>̐  Ȑ `  W@ D ` d h         ?   aw @  Ub  `u HPX \  HT3L4 50@

@
<                    `     14    PXYhijklmno 	
`
  #                 x ,89:4NNOP OhhXJŵmW  Q>Rӯ #gf&fߐ f ySf0	@g&OZ	(0xs<~SfgBufRVW f ZQ  !Q  A!!ȑf%ĿKf3f3f.2fffu_^fZxf"Q ء f' KĿ
f0PR,5 % PSVWfQs:ANي u ufufpv @uf  fY_o^[XQf!ff
1ff f fo  q&4'srpf_Yq"OB %%bR5 ?  薠@Q9 < h <u2<
 c                                                                UPRPRVFZX0RR{30ZO                               S Ѝ=̋ha3 3/ 3Ƥ̤V!
Suӎ 7CЂK 3޿ 3

#3"cӃ+D3ǥ: KљѬ33)33+333ooX;B3hh	{\<
bf.wu:N!u<u<|w2.~)df&@#Q`< t
 u
ff
ugf 7
Sذsara[fq;xV4kt? u _[fωP~_w_`0P #{t tu6޼`@" 荟a"ffhr;W 'Q W s	7>.hdr0fA@fP 6fAYqs}wdr
a$ChuzPszGOuhfuRP XZIPr KK	~@ h~#! " tC@ӧt<1fYPR<(^sZqf^SQR<_s&ZY9[!q.;
܏,,y[b<=à0AP1ABS?OLUTEPPPEg& tf0fg&tA=X0_f^  af`Mϫ4t$4p$4r .<t
../ NA NfapSwRVfp[r$@tU.  /OtA
 NUNh^Z3鰄ب40h_EÀ> ts%JfsMPWY'PS}l pف?_07B87B83 $ `%>&~غ%	 
  3  t!  { !@ @f@u#@2h2t0RW0_r pP"R8fZR0fP&T f<fX@0 !+}q+
  fh` B B B!B0B1B2zB tB nBaPfW R!J  g&?t"g&Gbg&Gbu @8 uf   wκ( 
uf_#` ο[!3X ,7j * :~ , 22RQ]Q]Z]X,a%*A Ë34 CZ g& DA4 Fd+
 <`/1#;`1h:e:f`1} fL2f3f% pQ
 0p!P!q  f
 `0XX! Kf`!ffgff%P@@@ gffP +
 `C  fA"aCu<wb+$<w	+ Ef{p46W> tU'uR uI )sB<t>{t9u2wYr-2r!\S Itg&G!P _  '<yItZg tK#Yr Ȼ s0 /G <u$
G@/OP 2Ԁ.CP,G?"?r0HIt蟟t52 `	
~   SQVȾ6q@ 8t"8tr2^ҀEAt,&
uߢ>ut
$rsEpt> u.L"t$	&
3s@ ÀY
tw|^ph{	>!]
hyxWmtep0FQ~ Kolu0ÿHtCƠ ƐP  M p$  
uw`a>@`
	 >t 
Lt˫0pPpU'uUg *r$- t> uBu
 Vi  (r"1bt "[JbSQPX5tV
r0..VGFtB0D0.r3//69Ft_6tP rBT36msRu%
 "E;6 vU56cC$Vtzu aTc:ݨtb`;sW;sQa;Tu	^Iu"
uPFޑ"
23TgT/  àޢ=/t 7݀urԁ* /)P5tXSfW@0`
Dth_8؊f_[Ä3fRsg]TPxr
#3# ЊPS|hf1 f| rmf# uOf3\f   tQ}t0z#%9tfY!!@it1f wf0f&.&fEf0ٰ f[fYA%! R%#9O o % foW z u8  *t  t	X2fp f_À 
u ø  <Zu?CrC /<Bp@ h?jf`y`pz+ 5'fpa$
	`cptCf@
@pW%;eƇaґ  @ "`_úd u"vJ  3 ߃ t 	Qf|@ @ L#9 ЮÅy\f@  %p &
!#ȂaqA~!-Yf# ]%q_48c$VB'Q ef 30Q'
f?~gS	bg s'g'cp
f_1f] sY!=qf\Yfĳ SS؛م f@V#t6$p%f& ff Ut33u^`fqSR3һX3t@{s8rS`p hB 
 [* 4Ǒ T0	ba0jҹ&s$
 PT؃22B0 RfZ,.028   ?+,,Ghe!B0.8KO*ֻƃŸg0kٍ7
SuoGסO8)`Et  1_&Ru  ix 
s| qmm PZC>t_ aP :ffX:fcfpl 6Йvǁ  j ` 
a|!u 33 k#ٝBS3g!-ff<f
 
# &f V$%\haUpg`o)0y@k  k  k`20!Ysf28f&. OKthaWLdJ1_PVQ = u5
B= Pi= o,q7`ppH8!$C
sVq$8C\f( 9(t 13â@q&`a]) 1a]Pma UQ   ,A}048 ,Nas;\#W`5 A G?!@hfP z	  h H`!P|3 Pf4XaxK_Y I[7Vf@2 0qL7t2 st,Nf^P _DPAPc4Ruc'1SS'1'0U J@hZ@ga&'`,ְ   ki1~` غ   nBnnntnJFn aÿS `À 3ێ7!C &?!Cu3ۏR .Zoh:ðP9t2XRV?Dp &994>&Nv.pu	 uQyMԿW
 ^ktWԿMt +t8QWP3 PhX@.X=X@uX_EYPTAqu{p$ qA!Pa.K$> u
PyE@Xuð6C @B T A3gfg tH u.g :fpg&ffws}| ffߋgfff6.<(.&gfݫBfsDP
hh!t@
WBDBOfR`6c}6U z u

(@kރuXO0f?qpRJf  oڃ tAN軴p Mp }pjXh	q~aRÃ`t%tgP&g!ggf`yRft9tg>E @ t9g5CggfxRVf),g>E %g> !P(^d`g
^
. ŵ ofR"Q2` t1YPQ s׀tu
QPYXP kڝ` ؠu 
X`:؎Rf쨀u Zlfa nУ  @(00	jEf$ pǑ D   &Et"׉D  $D(s0`ف&t}p΀ 4>2@"oQ
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` ݂ m  m Qam p's 0P ar * $·OQa	 & aO# $$<@t"hXRĔKuKK|󨀯Ku`.>#st&3r	&*!rA%;aô`prr X ? trKC0}qw1#!8Q909$ҩa0){fRQS3[YfZt'1݀ [ t x
| pGAar0QP
ADȁmG}> fH  h4ruf>訴rfy̸ fRذXr<fffHff#f+ִ f;wf3`Sлc
uff+f뺀
   t7u $>p u0Xfۜ9b_ ɐq1!迿t2)tP#s t>h Ǡ> tp @YA9du@IqQ_R$YP` < 8Br2<t.t)$u
$&r./#t%).t22tiG Q !S}uu>軆P& 2tSPZ'?f                                                               s3OTl dAd           մ  p                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  P       VBT             $VBT ALVISO         d 0   0                   BIOS_DATA_BLOCK ~    d1284Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    04/29/2004                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ m              
  8 (  8 L 0    ( 1 ? Q c u 
 
 
 
 
 
 
 
 m `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                      @   H `   H  b                                               =                       $    (     
 
                                                                                                                                                                   !0 R`SI-1362-A   p          @                                P                                `                                                                                                  M X <
     <
 2	 	Z e-  	
                                                                                          	                                                                                                                                                                                              <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                                           0H d @A &06      0* Q 0@0p      /xQ&@X      H?@0b2@@      ( 6     6     6    6     (              @ @ @ @ ,@ @ @ @ ,   (  s ) 	(		
	(	



(B
T

^
(



(



( 2
<(j|
(
(
(HZ
d(
(
(&
8
B
(p


(


(
*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                         SByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 艉s f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3ދf  f   f戰fS?f[f   f   3f   f  戰g&fFfCg戰닰 撰fPfSfQf   fQf3یff
!  (fYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 ߇fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf 5Jfsf Jfsf c1Jfsf MGJfsf 7]Jfsf !sJfsf Jfsf 7Jfsf Jfsf 3	Jfsf 	Jfsf 
Jfsf F
f   tKfsf c
n&Kfsf xX<Kfsf 
BnnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf ef   Kfsf F<|Kfsf  6Kfsf j
Lfsf Lfsf -Lfsf x=Lfsf =f   tVLfsf fLfsf of   tLfsf hLfsf Lfsf SLfsf Lfsf &f   uLfsf "Lfsf Lfsf Y&Mfsf Mfsf )'(Mfsf L'8Mfsf 'f   NMfsf <wbMfsf 4 f%"f   t
fawf  Mfsf {ta$f  Mfsf ;ff  Mfsf Df  Mfsf    Iuf  Nfsf f fsff   f   f   PNfsf tff Ag&ufNfsf &r8u:Nfsf &u$f3f   u
ffuf   tf fsf   Nfsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  tOfsf $f  Ofsf idf  Ofsf rf  Ofsf 6   Iu f fsf   ffuf
Pfsf %tf   ),Pfsf $8uf   uffuf fsff   ftLtPfsf $f   t$<t)<t/Pfsf $ufffff   uf fsff   ft(
Pfsf 8$<t<tfffff   uf fsf   t8f   ftFQfsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tuu0f   Rfsf $t<tff @   f 5Rfsf "2  +OS._Rfsf "<  ff   f.:w .DRfsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2uff   f
.f   2f   f   ft/Sfsf !< t8stff   uffff fs2uff   f
.f   2f   ft(%Tfsf  < t8stff   uff ff fs2uff   f
.f   2f   ft(Tfsf  < t8stff   uffff fsf   f    ft'Tfsf $ $t<s
f   <tff   ufff fsf   ftTUfsf uff   uf fs2uff   f
.f   2f   ft($Ufsf m< t8stff   uf?fff fsfffsf fsf 2uff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%f   t.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfu2.<u f   t2kf   uff   uWfsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   3Xfsf <|f`Agf&   f    f    f   rXfsf f    f    3f   ftXfsf UfftXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   tYfsf Qtf˰Yfsf 5<	rIаZfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8  f Lgf&fftf  f~fsffHfuff Lgf&f   ftf@l]fsf f Lgf&fftf  f   tf  f  f   tf  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	^fsf fBgf&^fsf  ^fsf  uff%   f
fHf   t
.f@Cg&uff%   f
fHf   t
.fCg&fKgf&I_fsf Ff fs侳uff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsuff%   f
fHf   t vfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}.fDg&(σ.fDg&.DfDg&f3vf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`|f~fsfffsf fsf f Ef   .@ fffsf fsf yfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_cfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
fHf   tfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H׀f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fi  ifffsf fsf f x.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfu  f Lgf&f   tfu  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1sf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   sfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  tfsf ,$f  ufsf f fs<f fsfffsf fsf  fӇ.ufH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  fsf Ű < urf   6fsf $<  <t<t
<t xfNgf&f   uf   fsf $p2<uB >tHH3f  fsf fƳ 
f  ͂fsf *Ż  f  fsf Ű < uHf   fsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ufsf ų
f  ofsf Ļ  f  fsf $
f  fsf Rf  fsf ^$w<u|f   ׃fsf B<|2f  fsf (f  fsf 0f  #fsf $f  =fsf f  Sfsf ĳ

f  mfsf Àf  fsf qÀf  fsf Xf~fsf fs            f   ff   2fff   ff3N.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2XXXX          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < fmf%f  $f$
tWppqtHffupppppqήfڮfupppppqf f  gffLggf^gfnf    f
   "4f4Ufupppppqg- f],ffmff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = ufyf f%df %  fAHfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰fذf䎊ffff掺<uf if*  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`fn  (fz  對 f    < tg                                	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft vugf&>tgf&6f٢ &fU ~f^Y[fXPSRfVӃ tAӰ Ӄ% g&ƅ    f  \g&  	uf^Z[XPSRfVӃ tAӰ Ӄ% g&ƅ    f  g&  	uf^Z[XPSR     Z[XSR  C vZ[PSRRZZ[XÃ<t  I  .  8PRt)t<ZXfPfSQfRV%2  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $fKfS f	SfWfff]X t fffS f	SfWf  ffKf_f^fZY[fXRfŋӃf3ӃZfPSQ  fӋA vY[fXf` f;.t
f.   $C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   < ϴ f;  ɴg&"  @v@ g&  s ϴf;  ɴ> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         戰䈽j戰䈽'f3Vf=밳fI@fS찴f_*fiWfuf f%"ff齧sffHff ff5ff f
   `"	f   f3f30f  0f+^fUf   f f    0f  f f   0	 f%"ftff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.`f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pft   @ Uus } M
  >}rfg  ׁ ( r  .i|V>Mfft<>3ffxfxrrfxftf>t wft   >ffx%fxנ3fxftf>t trf>t wft   >/>m>dff   fF>=נ,>#ס>	ff | > ffx'fxנr$fxftf>t trf>t wѰ|ft    } >urd>u]R%	 D>u=ע~/>u(fװ >|t  ׃>	r  Kl	s 撰 XBȔȮ(DUɮɻ'fSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRfp@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRfp@
 > uB ;yM@t=s(xغz,y0@u sz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v  f  ٴG 
f  ѴwfaPSQVP̋L	;t	 ` ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6鴻js>t fafWf   g&D= g&D= f_`r r8 a`fP  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`fδf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>ι gf&D5 gf&fff>fXYsufa`f`  & gF
$
gF
f`  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva "  f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfJ  ?   f^  +   fr     f  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Zq`qjqnqfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP(R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                0 ] IPS㋇ӣӋӣ[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[   q f  f  fPQgf0& YfXf    gf~gfNgfVgfßջfPfSfQfW<w f._
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >~tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fpp   rg<uf   ⃸   Yf[fS>~tf r	f  r>PfSfUUgf*gUfUUgf[Xgfp   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf>p tfptf`f  f3f3f3f  gfffCgftftfafp   fpuQYfVfSfQf
!  f   fx7rfxfYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{ffkffd    2ø     B @ -H
07/19/06DHTC  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        