/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.nodemanager.components;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.controllers.NodeAssociationsController;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.components.MxDefaultDynamicStatusHandler;
import com.hp.mx.core.objectmodel.MxObject;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class BladeIMEOAEnclosureBubbleHanlder
extends MxDefaultDynamicStatusHandler {
    private NodeAssociationsController m_nodeAssociationsController;
    private MxNodeController m_nodeController;

    public BladeIMEOAEnclosureBubbleHanlder() {
        try {
            this.m_nodeController = MxNodeController.getDefaultController();
            this.m_nodeAssociationsController = NodeAssociationsController.getDefaultController();
        }
        catch (MxObjectPersistenceException e) {
            BladeIMELogger.log((Exception)((Object)e), "BladeIMEOAEnclosureBubbleHanlder.Exception in static initializer: " + (Object)((Object)e));
        }
    }

    public DeviceStatusType getStatus(MxTransaction transaction, MxObject object) {
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
        if (object instanceof MxNode) {
            MxNode node = (MxNode)object;
            DefaultMutableTreeNode topologyTree = null;
            try {
                NodeAssociations deviceNodeAssociation = this.m_nodeAssociationsController.getNodeAssociations(transaction, node.getDeviceKey());
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatus.deviceNodeAssociation " + deviceNodeAssociation);
                if (deviceNodeAssociation != null) {
                    topologyTree = deviceNodeAssociation.getContainerDeviceTree();
                }
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatus.topologyTree " + topologyTree);
                if (topologyTree == null) {
                    DeviceStatusType status = node.getOverallStatus();
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatus.status " + status);
                    if (status == null) {
                        return DeviceStatusType.UNKNOWN;
                    }
                    return status;
                }
                return this.getStatusForTree(topologyTree);
            }
            catch (MxException me) {
                BladeIMELogger.log((Exception)((Object)me), "BladeIMEOAEnclosureBubbleHanlder.getStatus.Unable to get topologytree. MxException: " + (Object)((Object)me));
                return DeviceStatusType.UNKNOWN;
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "BladeIMEOAEnclosureBubbleHanlder.getStatus.Unable to get topologytree. Exception: " + e);
                return DeviceStatusType.UNKNOWN;
            }
        }
        return null;
    }

    private DeviceStatusType getStatusFromDeviceKey(Integer deviceKey) {
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey(" + deviceKey + ")");
        DeviceStatusType retval = DeviceStatusType.UNKNOWN;
        try {
            MxNode mxNode = this.m_nodeController.getReadOnlyNodeObject(deviceKey.intValue());
            retval = mxNode.getOverallStatus();
            retval = this.getModifiedOverAllStatus(mxNode, retval);
        }
        catch (MxException me) {
            BladeIMELogger.log((Exception)((Object)me), "BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - MxException retrieving node " + deviceKey + " - " + (Object)((Object)me));
        }
        catch (OAException oae) {
            BladeIMELogger.log(oae, "BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - OAException  " + deviceKey + " - " + oae);
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - Exception retrieving node " + deviceKey + " - " + e);
        }
        return retval;
    }

    private synchronized DeviceStatusType getStatusForTree(DefaultMutableTreeNode topologyTree) {
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree(" + topologyTree + ")");
        DeviceStatusType retval = DeviceStatusType.UNKNOWN;
        DeviceStatusType tmpStatus = DeviceStatusType.UNKNOWN;
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.topologyTree.getChildCount() " + topologyTree.getChildCount());
        for (int i = 0; i < topologyTree.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. childNode " + childNode);
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. childNode.getChildCount() " + childNode.getChildCount());
            if (childNode.getChildCount() > 0) {
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. Not a Leaf Node");
                tmpStatus = this.getStatusForTree(childNode);
            } else {
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. Leaf Node - No children");
                tmpStatus = this.getStatusFromDeviceKey((Integer)childNode.getUserObject());
            }
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.tmpStatus " + tmpStatus);
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval before comparision in loop " + retval);
            if (tmpStatus.greaterThanBubbleUp(retval)) {
                retval = tmpStatus;
            }
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval after comparision in loop " + retval);
            if (!retval.equals((Object)DeviceStatusType.CRITICAL)) continue;
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.Critical Staus. Breaking from loop");
            break;
        }
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval for devices" + retval);
        tmpStatus = this.getStatusFromDeviceKey((Integer)topologyTree.getUserObject());
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.tmpStatus for root" + tmpStatus);
        if (tmpStatus.greaterThanBubbleUp(retval)) {
            retval = tmpStatus;
        }
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.final retval " + retval);
        return retval;
    }

    private DeviceStatusType getModifiedOverAllStatus(MxNode mxNode, DeviceStatusType retval) throws OAException {
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus(" + mxNode + "," + retval + ")");
        if (mxNode.getDeviceType().equalsIgnoreCase("MgmtProc") && mxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString()) && mxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString())) {
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.It's an OA device");
            OAHelper oaHelper = OAHelper.getOAHelper();
            OnboardAdministrator onboardAdministrator = (OnboardAdministrator)oaHelper.getOLDevice(mxNode, mxNode);
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Primary/Secondary OA" + onboardAdministrator.getIsPrimary());
            if (!onboardAdministrator.getIsPrimary() && this.isPrimaryNormal(mxNode)) {
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Secondary OA status " + retval.getStatusValue());
                if (retval.getStatusValue() != DeviceStatusType.NORMAL.getStatusValue()) {
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Bubble up Minor Status for Secondary OA");
                    retval = DeviceStatusType.MINOR;
                }
            }
        }
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.retval " + retval);
        return retval;
    }

    private boolean isPrimaryNormal(MxNode secondaryOAMxNode) throws OAException {
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal(" + secondaryOAMxNode + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        boolean isPrimaryNormal = false;
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            int enclosureDeviceKey = myNodeRelationshipManager.getAssociatedDeviceKey(secondaryOAMxNode.getDeviceKey(), "MgmtProcToEnclosure");
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.enclosureDeviceKey " + enclosureDeviceKey);
            Vector associatedDeviceList = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(enclosureDeviceKey, "MgmtProcToEnclosure");
            int deviceKey = 0;
            MxNode mxNode = null;
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.associatedDeviceList.size() " + associatedDeviceList.size());
            for (int i = 0; i < associatedDeviceList.size(); ++i) {
                deviceKey = (Integer)associatedDeviceList.get(i);
                BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.deviceKey " + deviceKey);
                if (deviceKey == secondaryOAMxNode.getDeviceKey()) continue;
                try {
                    mxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
                    OnboardAdministrator onboardAdministrator = (OnboardAdministrator)oaHelper.getOLDevice(mxNode, mxNode);
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.Primary/Secondary OA " + onboardAdministrator.getIsPrimary());
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.OA Overall Status " + mxNode.getOverallStatus());
                    if (!onboardAdministrator.getIsPrimary() || mxNode.getOverallStatus().getStatusValue() != DeviceStatusType.NORMAL.getStatusValue()) continue;
                    isPrimaryNormal = true;
                    continue;
                }
                catch (MxUndefinedNodeException mune) {
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.MxUndefinedNodeException.deviceKey " + deviceKey);
                    BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.MxUndefinedNodeException " + (Object)((Object)mune));
                }
            }
        }
        catch (NodeAssociationsPersistenceException nape) {
            BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.Node Associations Persistence Exception: " + (Object)((Object)nape));
        }
        BladeIMELogger.log("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.isPrimaryNormal " + isPrimaryNormal);
        return isPrimaryNormal;
    }
}

