/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.tools.datacollection.collectors.wbem.WbemGatherData;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.PbleClassAssociationDataHandler;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.utilities.wbem.MxWBEMConstants_t;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DesktopAssociationDataHandler
extends RackEnclosureTopologyHandler
implements MxWBEMConstants_t {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    String associatedDeviceSerialNumber = null;
    private String associationType = "";

    public DesktopAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode dev, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"desktopHandler");
            log_.debug((Object)(" dev.getDeviceNameStandard():" + dev.getDeviceNameStandard()));
        }
        String hostOrIP = null;
        long startTime = 0L;
        int associatedDeviceKey = 0;
        String enclName = null;
        MxNode d = dev;
        String associatedPropertyStr = this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString();
        containerDeviceDebug.fine("IN The DESKTOPASSOCIATIONDATAHANDLER.... for device " + d.getDeviceNameStandard() + " And product type " + d.getDeviceType());
        if (!d.getDeviceType().equals("Desktop")) {
            containerDeviceDebug.fine("IN The DESKTOPASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        containerDeviceDebug.fine("IN The DESKTOPASSOCIATIONDATAHANDLER.... - Getting the new associations");
        String wbemEnabled = GlobalSettings.getProperty((String)"wbemEnableState", (String)"enabled");
        if (!wbemEnabled.equals("enabled")) {
            containerDeviceDebug.fine("WBEM Protocol Detection skipped (WBEM DISABLED GLOBALLY)  ");
            return;
        }
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            containerDeviceDebug.fine("DesktopAssociationDataHandler : Working Address is null for device : " + d.getDeviceNameStandard());
            return;
        }
        String hostOrIp = d.getWorkingAddress();
        WbemGatherData wbgd = new WbemGatherData();
        this.associatedDeviceSerialNumber = d.getClientAttribute(associatedPropertyStr);
        containerDeviceDebug.fine("   EnclosureSerialNumber= " + this.associatedDeviceSerialNumber + " for node=" + hostOrIP);
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("associatedDeviceSerialNumber:" + this.associatedDeviceSerialNumber));
        }
        try {
            while (true) {
                DesktopAssociationDataHandler desktopAssociationDataHandler = this;
                if (desktopAssociationDataHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                Thread.sleep(100L);
            }
            log_.debug((Object)("associatedDeviceSerialNumber:" + this.associatedDeviceSerialNumber));
            if (this.associatedDeviceSerialNumber != null && d.getSerialNumber() != null && !this.associatedDeviceSerialNumber.trim().equalsIgnoreCase(d.getSerialNumber().trim())) {
                associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(this.associatedDeviceSerialNumber, 12);
                if (associatedDeviceKey != 0) {
                    this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToDesktop_Ia", false);
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    MxNode associatedDevice = null;
                    try {
                        associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    SnmpRequest snmpReq = this.getSnmpRequest(associatedDevice);
                    PbleClassAssociationDataHandler pecadh = new PbleClassAssociationDataHandler(associatedDevice);
                    pecadh.getRackAttributesFromTheMib();
                    pecadh.getCommonEnclosureAttributesAndTopologyFromTheMib();
                    pecadh.getServerEnclosureAttributesFromTheMib();
                    pecadh.getServerBladeAttributesFromTheMib(true, d.getSerialNumber());
                    this.doRackEnclosureDeviceProcessing(pecadh, d);
                } else if (this.associatedDeviceSerialNumber != null && this.associatedDeviceSerialNumber.trim().length() > 0) {
                    d.setSWAttribute(associatedPropertyStr, this.associatedDeviceSerialNumber);
                }
                int enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "DesktopToEnclosure");
                if (enclDevKey > 0) {
                    try {
                        enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceNameStandard();
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    d.setEnclosureName(enclName);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
            }
            containerDeviceDebug.fine("Enclosure Serial Number from WMI/WBEM Association : " + this.associatedDeviceSerialNumber);
            containerDeviceDebug.fine("Device d Serial Number from WMI/WBEM Association : " + d.getSerialNumber());
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            DesktopAssociationDataHandler desktopAssociationDataHandler = this;
            desktopAssociationDataHandler.myNodeRelationshipManager.releaseWriteLock();
        }
        containerDeviceDebug.fine("WBEM enabled device=" + hostOrIP + (System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
            containerDeviceDebug.log("In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (device == null || !device.getDeviceType().equals("Desktop")) continue;
                if (associationTypeNumber.equalsIgnoreCase("DesktopToEnclosure")) {
                    if (deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setParent(deviceKey2);
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    continue;
                }
                if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToDesktop_Ia") || deviceKey1 != deviceDbKey) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
            }
            myResultSet.close();
            myStatement.close();
            myResultSet = null;
            myStatement = null;
            containerDeviceDebug.fine("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
        }
        catch (NodeAssociationsPersistenceException nape) {
            containerDeviceDebug.exception("A Node Associations Persistence Exception: " + (Object)((Object)nape));
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        catch (SQLException myException) {
            containerDeviceDebug.exception("Failed to get the vector of devices that have associations " + myException);
            {
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void doRackEnclosureDeviceProcessing(PbleClassAssociationDataHandler pecadh, MxNode d) {
        try {
            if (this.associatedDeviceSerialNumber != null && !this.associatedDeviceSerialNumber.equals("")) {
                containerDeviceDebug.finest("DesktopADH : In rackEnclosure Device Processing");
                this.myNodeRelationships.setSlotNumber(pecadh.getBladeSlot());
                this.myNodeRelationships.setMmHeight(pecadh.getBladeHeight());
                this.myNodeRelationships.setMmWidth(pecadh.getBladeWidth());
                this.myNodeRelationships.setMmDepth(pecadh.getBladeDepth());
                this.myNodeRelationships.setNumBladeSlotsUsed(pecadh.getBladeSlotsUsed());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(pecadh.getBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(pecadh.getBladeSlotsUsedYDir());
                this.myNodeRelationships.setSource(this.associationType);
                containerDeviceDebug.finest("DesktopADH : Finished storing blade attributes");
                if (pecadh.getServerEnclosureIndex() != -1) {
                    containerDeviceDebug.finest("DesktopADH : Before storing enclosure information" + pecadh.getServerEnclosureIndex());
                    NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(pecadh.getContainerEnclosureInformation(), pecadh.getRackName(), pecadh.getRuid());
                    if (theEnclNodeAssociations != null) {
                        int myDeviceKey = this.device.getDeviceKey();
                        int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                        containerDeviceDebug.fine("The encl device is " + theEnclDeviceKey);
                        containerDeviceDebug.fine("Slot number for myNodeRelationships in storeenclosureinformation is " + this.myNodeRelationships.getSlotNumber());
                        if (this.myNodeRelationships.getSlotNumber() != -1) {
                            this.removeOldAssociationsFromThisSlot(myDeviceKey, theEnclDeviceKey);
                            this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "DesktopToEnclosure", false);
                            this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                            this.myNodeRelationships.setInContainer(true);
                            this.myNodeRelationships.setParent(theEnclDeviceKey);
                        }
                        theEnclNodeAssociations.setMaxNumItems(pecadh.getMaxNumBlades());
                        theEnclNodeAssociations.setMaxNumItemsXDir(pecadh.getMaxNumBladesXDir());
                        theEnclNodeAssociations.setMaxNumItemsYDir(pecadh.getMaxNumBladesYDir());
                        theEnclNodeAssociations.setSource("Enclosure");
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    }
                    containerDeviceDebug.finest("DesktopADH : after storing enclosure and rack information");
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public SnmpRequest getSnmpRequest(MxNode d) {
        SnmpRequest snmpReq = new SnmpRequest(d);
        snmpReq.clearSnmpReqInfo();
        return snmpReq;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToDesktop_Ia");
        Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("DesktopToEnclosure");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "DesktopToEnclosure");
        this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
        for (int i = 0; i < v.size(); ++i) {
            this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
        }
    }
}

