/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.PbleClassAssociationDataHandler;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class EClassServerHandler
extends SnmpRackMibHandler {
    private String associationType = "";

    public EClassServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        String snmpEnabled;
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        int ribLoc = 0;
        Object theRibSerialNo = null;
        Object theCpqSiSysSerialNo = null;
        boolean isThisAGardianServer = false;
        int associatedDeviceKey = 0;
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The EClassServerHandler.... for device " + d.getDeviceName() + " And product type " + d.getDeviceType()));
        }
        if (!(snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked")).equals("checked")) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("EClass Server Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
            return;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("EClass Server Association skipped ; snmp not detected on " + d.getDeviceName()));
            return;
        }
        if (!d.getDeviceType().equals("Server")) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The EClassServerHandler.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The EClassServerHandler.... - Getting the new associations");
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("EClassServerHandler : Working Address is null for device : " + d.getDeviceName()));
            }
            return;
        }
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("EClassServerHandler....After getting rib location  " + ribLoc + " for device " + d.getDeviceName()));
        }
        int doesThisHaveEnclosureMgmt = 0;
        try {
            block36: {
                if (ribLoc == 0 || ribLoc == -1) {
                    this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.2[0],1.3.6.1.4.1.232.2.2.13.1.1.6[1]");
                    boolean endOfTable = false;
                    String typeResponseOID = null;
                    String serialNoResponseOID = null;
                    String serialNumber = null;
                    while (true) {
                        EClassServerHandler eClassServerHandler = this;
                        if (eClassServerHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                        Thread.sleep(100L);
                    }
                    while (!endOfTable) {
                        SnmpResponseVarBind vb2;
                        this.snmpPdh.snmpReq.SnmpGetNext();
                        SnmpResponse curResp = this.snmpPdh.snmpReq.getResponseVarbinds();
                        SnmpResponseVarBind vb = curResp.findById(0);
                        if (vb == null || vb.isError()) break;
                        typeResponseOID = vb.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The TYPE RESPONSE OID : " + typeResponseOID));
                        }
                        if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
                        serialNoResponseOID = vb2.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The SERIAL no. RESPONSE OID : " + serialNoResponseOID));
                        }
                        if (!typeResponseOID.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.2.")) break;
                        doesThisHaveEnclosureMgmt = vb.getIntValue();
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Value returned from type OID : " + doesThisHaveEnclosureMgmt));
                        }
                        if (doesThisHaveEnclosureMgmt == 3) {
                            isThisAGardianServer = true;
                            associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(vb2.getValue(), 12);
                            if (associatedDeviceKey != 0) {
                                this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Ia", false);
                                MxNode associatedDevice = null;
                                try {
                                    associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                                }
                                catch (MxUndefinedNodeException ex) {
                                    // empty catch block
                                }
                                PbleClassAssociationDataHandler pecadh = new PbleClassAssociationDataHandler(associatedDevice);
                                pecadh.snmpPdh.resetSnmpRequestSettings();
                                pecadh.getRackAttributesFromTheMib();
                                pecadh.getCommonEnclosureAttributesAndTopologyFromTheMib();
                                pecadh.getServerEnclosureAttributesFromTheMib();
                                pecadh.getServerBladeAttributesFromTheMib(true, d.getSerialNumber());
                                this.doRackEnclosureDeviceProcessing(pecadh, d);
                                this.snmpPdh.resetSnmpRequestSettings();
                            }
                            if ((serialNumber = vb2.getValue()) == null || serialNumber.trim().length() <= 0) break;
                            d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), vb2.getValue());
                            if (!containerDeviceDebug.check(10)) break;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)(" Value returned from SERIAL NO OID : " + serialNumber));
                            break;
                        }
                        this.snmpPdh.snmpReq.clearSnmpReqInfo();
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(typeResponseOID, "0");
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(serialNoResponseOID, "1");
                    }
                }
                int rackDevKey = 0;
                int enclDevKey = 0;
                String rackName = "";
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"EClassServerHandler....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
                    if (enclDevKey > 0) {
                        try {
                            enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                        }
                        catch (MxUndefinedNodeException ex1) {
                            // empty catch block
                        }
                        rackDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclDevKey, "EnclosureToRack");
                        if (rackDevKey > 0) {
                            try {
                                rackName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey).getDeviceName();
                            }
                            catch (MxUndefinedNodeException ex2) {
                                // empty catch block
                            }
                        }
                        d.setEnclosureName(enclName);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                        break block36;
                    }
                    if (this.myNodeRelationships.inContainer()) {
                        MxNode encl;
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("device " + d.getDeviceName() + " thinks it's in an enclosure, but we have nothing for it - fix that"));
                        }
                        if ((encl = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure")) != null) {
                            NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(encl.getDeviceKey());
                            if (theEnclNodeAssociations != null) {
                                DefaultMutableTreeNode topologyTree = theEnclNodeAssociations.getContainerDeviceTree();
                                topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                                theEnclNodeAssociations.setContainerDeviceTree(topologyTree);
                                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                            }
                            this.myNodeRelationshipManager.update(this.myNodeRelationships);
                            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        }
                    }
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Done trying to find associations for SERVER : " + d.getDeviceName()));
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            EClassServerHandler eClassServerHandler = this;
            eClassServerHandler.myNodeRelationshipManager.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block6: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (device == null || !device.getDeviceType().equals("Server")) continue;
                    if (associationTypeNumber.equalsIgnoreCase("ServerToEnclosure")) {
                        if (deviceKey1 != deviceDbKey) continue;
                        na.setInContainer(true);
                        na.setParent(deviceKey2);
                        na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                        continue;
                    }
                    if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ia") || deviceKey1 != deviceDbKey) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block6;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void doRackEnclosureDeviceProcessing(PbleClassAssociationDataHandler pecadh, MxNode d) {
        try {
            Vector enclosureInfo;
            String enclSerNo = null;
            if (pecadh.getTopology().size() > 0 && (enclosureInfo = (Vector)pecadh.getTopology().elementAt(pecadh.getServerEnclosureIndex())) != null) {
                enclSerNo = (String)enclosureInfo.elementAt(8);
            }
            if (enclSerNo != null && !enclSerNo.equals("")) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : In rackEnclosure Device Processing");
                this.myNodeRelationships.setSlotNumber(pecadh.getBladeSlot());
                this.myNodeRelationships.setMmHeight(pecadh.getBladeHeight());
                this.myNodeRelationships.setMmWidth(pecadh.getBladeWidth());
                this.myNodeRelationships.setMmDepth(pecadh.getBladeDepth());
                this.myNodeRelationships.setNumBladeSlotsUsed(pecadh.getBladeSlotsUsed());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(pecadh.getBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(pecadh.getBladeSlotsUsedYDir());
                this.myNodeRelationships.setSource(this.associationType);
                this.myNodeRelationships.setSwitchApis(pecadh.getSwitchesPresent());
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Finished storing blade attributes");
                if (pecadh.getServerEnclosureIndex() != -1) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Before storing enclosure information");
                    NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation((Vector)pecadh.getTopology().elementAt(pecadh.getServerEnclosureIndex()), this.getRackName(), this.getRuid());
                    if (theEnclNodeAssociations != null) {
                        int myDeviceKey = this.device.getDeviceKey();
                        int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("The encl device is " + theEnclDeviceKey));
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Slot number for myNodeRelationships in storeenclosureinformation is " + this.myNodeRelationships.getSlotNumber()));
                        if (this.myNodeRelationships.getSlotNumber() != -1) {
                            this.removeOldAssociationsFromThisSlot(myDeviceKey, theEnclDeviceKey);
                            this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "ServerToEnclosure", false);
                            this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                            this.myNodeRelationships.setInContainer(true);
                            this.myNodeRelationships.setParent(theEnclDeviceKey);
                        }
                        theEnclNodeAssociations.setMaxNumItems(pecadh.getMaxNumBlades());
                        theEnclNodeAssociations.setSwitchApis(pecadh.getSwitchesPresent());
                        theEnclNodeAssociations.setMaxNumItemsXDir(pecadh.getMaxNumBladesXDir());
                        theEnclNodeAssociations.setMaxNumItemsYDir(pecadh.getMaxNumBladesYDir());
                        theEnclNodeAssociations.setSource("Enclosure");
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : after storing enclosure and rack information");
                }
            } else {
                MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
                if (dTmp != null) {
                    NodeAssociations dTmpNodeAssociations;
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("MIB shows server " + new Integer(d.getDeviceKey()) + " was not in enclosure - removing it from topology"));
                    }
                    if ((dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
                        DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
                        topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                        dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
                        this.myNodeRelationshipManager.update(dTmpNodeAssociations);
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
            Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            for (int i = 0; i < v.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }
}

