/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceUrl;
import com.hp.mx.core.nodemanager.DeviceUrlType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeUrlManager;
import com.hp.mx.core.nodemanager.NodeUrlTypeManager;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.tools.identification.associations.SyncObject;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.iLOXml.ILOAllQueryConstants;
import com.hp.mx.portal.iLOXml.ILOICMBConstants;
import com.hp.mx.portal.iLOXml.ILOParser;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class IloAssociationDataHandler
extends RackEnclosureTopologyHandler {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private int associatedDeviceKey = 0;
    private String rackName = null;
    private String rUid = null;
    private String enclSerNo = null;
    private String enclUuid = null;
    private String enclosureName = null;
    private int numSlotsX = -1;
    private int numSlotsY = -1;
    private int bladeSlot = -1;
    private int bladeHeight = -1;
    private int bladeWidth = -1;
    private int bladeDepth = -1;
    private int maxNumBlades = 0;
    private int maxNumBladesX = 0;
    private int maxNumBladesY = 1;
    private String associationType = "";
    private Vector topology = new Vector();
    private int serverEnclosureIndex = -1;
    private MxNode theServerDevice = null;
    private NodeAssociations myServerNodeAssociations = null;
    private NodeAssociations myEnclosureNodeAssociations = null;
    private String modelToSetSubType = null;

    public IloAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        try {
            BladeIMELogger.log("IN The ILOASSOCIATIONDATAHANDLER....");
            if (!d.getDeviceType().equals("MgmtProc") || d.getModel().toLowerCase().indexOf("integrated lights-out") == -1 && d.getModel().toLowerCase().indexOf("remote insight lights-out edition ii") == -1 || d.getModel().toLowerCase().equals("integrated lights-out (ilo) for integrity and hp9000")) {
                BladeIMELogger.log("IN The ILOASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                this.cleanUpAssociationData(d);
                return;
            }
            BladeIMELogger.log("IN The ILOASSOCIATIONDATAHANDLER.... - Getting the new associations");
            BladeIMELogger.log("ILO : Finished getting the node associations object.");
            String workingAddress = d.getWorkingAddress();
            if (workingAddress == null) {
                BladeIMELogger.log("IloAssociationDataHandler : Working Address is null for device : " + d.getDeviceName());
                return;
            }
            MgmtProcessorParser mpp = new MgmtProcessorParser();
            DeviceUrlType dUrlType = NodeUrlTypeManager.getDefaultManager().getUrlTypeByRootName("compaq.hmmd.MANAGEMENTPROCESSOR");
            DebugOutput.log((DebugSubsystem)MgmtProcessorParser.mgmtProcIdentificationDebug, (int)10, (String)"The durl returned a durl type");
            StringBuffer urlName = new StringBuffer();
            DeviceUrl du = NodeUrlManager.getDefaultManager().getDeviceUrlByBase(d.getDeviceKey(), dUrlType);
            if (du == null) {
                BladeIMELogger.log("DU is still null");
            }
            if (du != null) {
                String urlInfo = du.getUrl();
                if (urlInfo != null && urlInfo.startsWith("http")) {
                    urlName.append(urlInfo);
                } else if (urlInfo.indexOf("80") == -1) {
                    urlName.append("http://");
                    urlName.append(workingAddress);
                    urlName.append(urlInfo);
                } else {
                    urlName.append("http://");
                    urlName.append(workingAddress);
                    urlName.append(":80/");
                }
                if (MgmtProcessorParser.iLoSimulationDebug.getEnabled()) {
                    urlName.append("xmldata.asp?item=All");
                } else {
                    urlName.append("xmldata?item=All");
                }
                BladeIMELogger.log("The HTTP url for getting association data for device " + d.getDeviceName() + " is " + urlName);
                String xmlData = mpp.sendTheRequest(urlName.toString());
                mpp.setXmlData(xmlData);
                while (true) {
                    IloAssociationDataHandler iloAssociationDataHandler = this;
                    if (iloAssociationDataHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                    Thread.sleep(100L);
                }
                if (xmlData != null) {
                    Element rootElement = mpp.getXmlRootElement();
                    this.parseIloSpecificDataFromXml(d, rootElement);
                    this.parseIloRackEnclosureDataFromXml(d, rootElement);
                    this.doRackEnclosureDeviceProcessing(d);
                } else if (MgmtProcessorParser.iLoSimulationDebug.getEnabled()) {
                    urlName = new StringBuffer();
                    du = NodeUrlManager.getDefaultManager().getDeviceUrlByBase(d.getDeviceKey(), dUrlType);
                    if (du != null) {
                        urlInfo = du.getUrlInfo();
                        if (urlInfo != null && urlInfo.startsWith("http")) {
                            urlName.append(urlInfo);
                        } else if (urlInfo.indexOf("80") == -1) {
                            urlName.append("http://");
                            urlName.append(workingAddress);
                            urlName.append(urlInfo);
                        } else {
                            urlName.append("http://");
                            urlName.append(workingAddress);
                            urlName.append(":80/");
                        }
                        urlName.append("xmldata?item=All");
                        BladeIMELogger.log("The 2nd HTTP url for getting association data for device " + d.getDeviceName() + " is " + urlName);
                        xmlData = mpp.sendTheRequest(urlName.toString());
                        mpp.setXmlData(xmlData);
                        if (xmlData != null) {
                            Element rootElement = mpp.getXmlRootElement();
                            this.parseIloSpecificDataFromXml(d, rootElement);
                            this.parseIloRackEnclosureDataFromXml(d, rootElement);
                            this.doRackEnclosureDeviceProcessing(d);
                        }
                    }
                }
                BladeIMELogger.log("About to update node associations from ILO ");
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                if (this.myServerNodeAssociations != null) {
                    this.myNodeRelationshipManager.update(this.myServerNodeAssociations);
                }
                if (this.myEnclosureNodeAssociations != null) {
                    this.myNodeRelationshipManager.update(this.myEnclosureNodeAssociations);
                }
                BladeIMELogger.log(" Finished updated node associations from ILO ");
            }
            this.getDatafromiLO(d);
        }
        catch (Exception e) {
            BladeIMELogger.log("Exception in IloAssociationDataHandler : " + e);
            MgmtProcessorParser.mgmtProcIdentificationDebug.exception((Throwable)e);
        }
        finally {
            IloAssociationDataHandler iloAssociationDataHandler = this;
            iloAssociationDataHandler.myNodeRelationshipManager.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block5: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            int deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (device == null || !device.getDeviceType().equals("MgmtProc") || !associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ilo") || deviceKey1 != deviceDbKey) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block5;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    private void parseIloSpecificDataFromXml(MxNode d, Element rootElement) {
        block34: {
            BladeIMELogger.log("In ILOASSOCIATIONDATAHANDLER: parseIloSpecificDataFromXML");
            try {
                Element attribute = rootElement.getChild("MP");
                if (attribute != null) {
                    String productName = attribute.getChildText("PN");
                    String serialNumber = attribute.getChildText("SN");
                    d.setModel(productName);
                    d.setSerialNumber(serialNumber);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                if ((attribute = rootElement.getChild("HSI")) == null) break block34;
                String serverUuid = attribute.getChildText("UUID");
                String serverSerialNumber = attribute.getChildText("SBSN");
                String productModel = attribute.getChildText("SPN");
                this.modelToSetSubType = attribute.getChildText("SPN");
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("The Product Model for the Bare Metal Blade:" + productModel));
                }
                MxNode associatedDevice = null;
                String iloDisc = GlobalSettings.getProperty((String)"iloDisc_enabled_state", (String)"NOT");
                if (serverUuid == null || serverUuid.trim().length() == 0) {
                    serverUuid = serverSerialNumber;
                }
                this.associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(serverUuid);
                log_.debug((Object)("server DeviceKey :" + this.associatedDeviceKey));
                if (this.associatedDeviceKey <= 0) {
                    try {
                        this.theServerDevice = associatedDevice = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(serverUuid);
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    if (associatedDevice != null) {
                        this.associatedDeviceKey = associatedDevice.getDeviceKey();
                    }
                }
                if (this.associatedDeviceKey != 0) {
                    try {
                        this.theServerDevice = associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(this.associatedDeviceKey);
                    }
                    catch (MxUndefinedNodeException ex2) {
                        associatedDevice = null;
                    }
                }
                if (this.theServerDevice != null && this.theServerDevice.getDeviceName().matches("Serv_.*")) {
                    if (log_.isEnabledFor((Priority)Level.FATAL)) {
                        log_.fatal((Object)("The Server Name:" + this.theServerDevice.getDeviceName()));
                    }
                    if (this.theServerDevice.getDeviceSubTypes().isEmpty()) {
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.info((Object)"The Bare metal blades Subtype List is empty.Add subtypes");
                        }
                        this.setProductSubType(productModel, this.theServerDevice);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.theServerDevice, false);
                    }
                    if (productModel.matches("ProLiant xw[0-9][0-9]p Blade Wor.*")) {
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("IloAssociationDataHandler.setDeviceType(" + productModel + ")"));
                        }
                        this.theServerDevice.setDeviceType("Workstation");
                    }
                }
                if (associatedDevice != null && associatedDevice.getDeviceType().equals("Server")) {
                    this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), this.associatedDeviceKey, "MgmtProcToServer_Ilo", true);
                    this.updateServerNodeAssociations(d, this.theServerDevice.getDeviceKey());
                } else if (associatedDevice != null && associatedDevice.getDeviceType().equals("Workstation")) {
                    this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), this.associatedDeviceKey, "MgmtProcToServer_Ilo", true);
                    this.updateServerNodeAssociations(d, this.theServerDevice.getDeviceKey());
                } else if (this.associatedDeviceKey <= 0 && iloDisc.equalsIgnoreCase("checked") && d.getModel().toLowerCase().indexOf("integrated lights-out") != -1) {
                    attribute = rootElement.getChild("INFRA");
                    String enclName = null;
                    if (attribute != null) {
                        enclName = attribute.getChildText("ENCL");
                    }
                    if (enclName != null && !enclName.equals("")) {
                        this.theServerDevice = new MxNode();
                        this.theServerDevice.setDeviceName("Serv_" + serverSerialNumber);
                        this.theServerDevice.setAgentUUID(serverUuid);
                        if (productModel != null && productModel.matches("ProLiant xw[0-9][0-9]p Blade Wor.*")) {
                            this.theServerDevice.setDeviceType("Workstation");
                        } else {
                            this.theServerDevice.setDeviceType("Server");
                        }
                        this.theServerDevice.setSerialNumber(serverSerialNumber);
                        if (this.theServerDevice.getSnoozeTime() != -3) {
                            this.theServerDevice.setSnoozeTime(-3);
                        }
                        this.setProductSubType(productModel, this.theServerDevice);
                        Integer i = new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5"));
                        this.theServerDevice.setSnmpTimeOut(i.intValue());
                        i = new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2"));
                        this.theServerDevice.setSnmpRetry(i.intValue());
                        i = new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5"));
                        this.theServerDevice.setIcmpTimeOut(i.intValue());
                        i = new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2"));
                        this.theServerDevice.setIcmpRetry(i.intValue());
                        int defaultsMask = 255;
                        this.theServerDevice.setDefaultsMask(true, defaultsMask);
                        try {
                            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), this.theServerDevice);
                            this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), this.theServerDevice.getDeviceKey(), "MgmtProcToServer_Ilo", true);
                            this.updateServerNodeAssociations(d, this.theServerDevice.getDeviceKey());
                        }
                        catch (Exception ex) {
                            containerDeviceDebug.exception((Throwable)ex);
                        }
                    }
                } else {
                    if (serverUuid != null && serverUuid.trim().length() > 0) {
                        d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverUuid);
                    } else if (serverSerialNumber != null && serverSerialNumber.trim().length() > 0) {
                        d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverSerialNumber);
                    }
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                    DebugOutput.log((DebugSubsystem)MgmtProcessorParser.mgmtProcIdentificationDebug, (int)10, (String)("Failed to set the GROMIT-SERVER association for " + d.getDeviceName()));
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    public void updateServerNodeAssociations(MxNode d, int theServerDeviceKey) {
        this.myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theServerDeviceKey);
        if (this.myServerNodeAssociations == null) {
            this.myServerNodeAssociations = new NodeAssociations(theServerDeviceKey);
        }
        this.myServerNodeAssociations.setTheAssociation(theServerDeviceKey, d.getDeviceKey(), "MgmtProcToServer_Ilo", true);
    }

    private void parseIloRackEnclosureDataFromXml(MxNode d, Element rootElement) {
        try {
            Element attribute = rootElement.getChild("INFRA");
            if (attribute != null) {
                this.rackName = attribute.getChildText("RACK");
                this.enclosureName = attribute.getChildText("ENCL");
                this.enclSerNo = attribute.getChildText("ENCL_SN");
                this.enclUuid = attribute.getChildText("UUID");
                this.maxNumBladesX = this.getIntegerValueFromXml(attribute.getChildText("MAX_NUMBER_SLOTS_X"));
                this.maxNumBladesY = this.getIntegerValueFromXml(attribute.getChildText("MAX_NUMBER_SLOTS_Y"));
                if ((attribute = attribute.getChild("BLADE")) != null) {
                    this.bladeSlot = this.getIntegerValueFromXml(attribute.getChildText("SLOT"));
                    this.bladeHeight = this.getIntegerValueFromXml(attribute.getChildText("HMM"));
                    this.bladeWidth = this.getIntegerValueFromXml(attribute.getChildText("WMM"));
                    this.bladeDepth = this.getIntegerValueFromXml(attribute.getChildText("DMM"));
                    int temp = this.getIntegerValueFromXml(attribute.getChildText("NUM_SLOTS_X"));
                    this.numSlotsX = temp != 0 && temp != -1 ? temp : 1;
                    this.numSlotsY = this.getIntegerValueFromXml(attribute.getChildText("NUM_SLOTS_Y"));
                }
            }
            this.topology = new Vector();
            String enclSer = null;
            String enclUUIDfrmTplgy = null;
            List rkNodes = rootElement.getChildren("RK_TPLGY");
            if (rkNodes != null) {
                Iterator l = rkNodes.iterator();
                while (l.hasNext()) {
                    attribute = (Element)l.next();
                    this.rUid = attribute.getChildText("RUID");
                    List icmbList = attribute.getChildren("ICMB");
                    int indexIntoTable = 0;
                    Iterator k = icmbList.iterator();
                    while (k.hasNext()) {
                        Integer hexValueProdId;
                        Element icmbAttributes = (Element)k.next();
                        Vector<String> tplgy = new Vector<String>();
                        enclSer = icmbAttributes.getAttributeValue("SER");
                        enclUUIDfrmTplgy = icmbAttributes.getAttributeValue("UUID");
                        if (enclUUIDfrmTplgy != null && enclUUIDfrmTplgy.trim().length() > 0 && enclUUIDfrmTplgy.trim().length() >= 10) {
                            tplgy.add(enclUUIDfrmTplgy);
                        } else {
                            tplgy.add("");
                        }
                        if (enclSer != null && this.enclSerNo != null && enclSer.equalsIgnoreCase(this.enclSerNo)) {
                            this.serverEnclosureIndex = indexIntoTable;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Server index : " + this.serverEnclosureIndex + " and Ser no. " + enclSer));
                            tplgy.add(this.enclosureName);
                        } else {
                            tplgy.add("");
                        }
                        Element childElement = icmbAttributes.getChild("RIGHT");
                        String leftNgbrName = childElement.getAttributeValue("NAME");
                        if (leftNgbrName != null && leftNgbrName.trim().length() > 0) {
                            tplgy.add(leftNgbrName);
                        } else {
                            tplgy.add("");
                        }
                        childElement = icmbAttributes.getChild("LEFT");
                        String rgtNgbrName = childElement.getAttributeValue("NAME");
                        if (rgtNgbrName != null && rgtNgbrName.trim().length() > 0) {
                            tplgy.add(rgtNgbrName);
                        } else {
                            tplgy.add("");
                        }
                        String prodId = icmbAttributes.getAttributeValue("PROD_ID");
                        StringTokenizer st = new StringTokenizer(prodId, "x");
                        String temp = "";
                        st.nextToken();
                        if (st.hasMoreTokens()) {
                            temp = st.nextToken();
                        }
                        if ((hexValueProdId = Integer.valueOf(temp, 16)) == 3 || hexValueProdId == 5) {
                            tplgy.add("false");
                            tplgy.add("true");
                        } else {
                            tplgy.add("true");
                            tplgy.add("false");
                        }
                        childElement = icmbAttributes.getChild("RIGHT");
                        String leftEnclUuid = childElement.getAttributeValue("UUID");
                        if (leftEnclUuid != null && leftEnclUuid.trim().length() > 0 && leftEnclUuid.trim().length() >= 10) {
                            tplgy.add(leftEnclUuid);
                        } else {
                            tplgy.add("");
                        }
                        String leftSerNumber = childElement.getAttributeValue("SER");
                        childElement = icmbAttributes.getChild("LEFT");
                        String rgtEnclUuid = childElement.getAttributeValue("UUID");
                        String rgtSerNumber = childElement.getAttributeValue("SER");
                        if (rgtEnclUuid != null && rgtEnclUuid.trim().length() > 0 && rgtEnclUuid.trim().length() >= 10) {
                            tplgy.add(rgtEnclUuid);
                        } else {
                            tplgy.add("");
                        }
                        if (enclSer != null) {
                            tplgy.add(enclSer);
                            this.prodIdList.put(enclSer, temp);
                        } else {
                            tplgy.add("");
                        }
                        if (leftSerNumber != null) {
                            tplgy.add(leftSerNumber);
                        } else {
                            tplgy.add("");
                        }
                        if (rgtSerNumber != null) {
                            tplgy.add(rgtSerNumber);
                        } else {
                            tplgy.add("");
                        }
                        this.topology.add(tplgy);
                        ++indexIntoTable;
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        block19: {
            try {
                Vector tpgy;
                int enclDevKey;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ILO : In rackEnclosure Device Processing");
                if (this.serverEnclosureIndex == -1) break block19;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ILO : Before storing enclosure information");
                this.myEnclosureNodeAssociations = this.getEnclosureInformation((Vector)this.topology.elementAt(this.serverEnclosureIndex), this.rackName, this.rUid);
                this.myNodeRelationships.setInContainer(true);
                this.getRackInformation(this.rackName, this.rUid, this.myEnclosureNodeAssociations.getDeviceKey());
                if (this.getTheRackDevice() != null) {
                    this.setSubTypeForRack(this.modelToSetSubType);
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ILO : after storing enclosure and rack information");
                this.storeTopologyInformation(this.topology, this.getTheRackDevice());
                if (this.maxNumBladesX > 0 && this.maxNumBladesY > 0) {
                    this.myEnclosureNodeAssociations.setMaxNumItemsXDir(this.maxNumBladesX);
                    this.myEnclosureNodeAssociations.setMaxNumItemsYDir(this.maxNumBladesY);
                    this.myEnclosureNodeAssociations.setMaxNumItems(this.maxNumBladesX * this.maxNumBladesY);
                } else {
                    this.myEnclosureNodeAssociations.setMaxNumItems(this.maxNumBlades);
                }
                int serverDevKey = 0;
                serverDevKey = this.theServerDevice != null ? this.theServerDevice.getDeviceKey() : this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToServer_Ilo");
                if (serverDevKey <= 0) break block19;
                MxNode serverDev = null;
                try {
                    serverDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(serverDevKey);
                }
                catch (MxUndefinedNodeException ex1) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: Unable to retrieve serverDev - " + serverDevKey + " exception: " + (Object)((Object)ex1)));
                }
                if (!serverDev.getDeviceName().startsWith("Serv_") || (enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure")) > 0 || (tpgy = (Vector)this.topology.get(this.serverEnclosureIndex)) == null) break block19;
                String enclUuid = (String)tpgy.get(0);
                MxNode encl = null;
                try {
                    encl = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUuid.trim());
                }
                catch (MxUndefinedNodeException ex) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: Unable to retrieve encl by UUID - " + enclUuid + " exception: " + (Object)((Object)ex)));
                }
                if (encl == null) {
                    String enclSerNo = (String)tpgy.get(8);
                    try {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: attempting to get enclosure by serial No: " + enclSerNo));
                        encl = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclSerNo.trim());
                    }
                    catch (MxUndefinedNodeException ex) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: attempting to get enclosure from db_deviceinfoex" + enclSerNo));
                        int enclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerNo.trim(), 14);
                        try {
                            encl = MxNodeController.getDefaultControllerNoEx().getNodeByKey(enclDeviceKey);
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: enclosure deviceKey = " + enclDeviceKey));
                        }
                        catch (MxUndefinedNodeException ex2) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: error retrieving enclosure from deviceinfoex - " + (Object)((Object)ex2)));
                        }
                    }
                }
                if (encl != null) {
                    this.myEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(encl.getDeviceKey());
                    if (this.myEnclosureNodeAssociations == null) {
                        this.myEnclosureNodeAssociations = new NodeAssociations(encl.getDeviceKey());
                    }
                    this.myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverDevKey);
                    if (this.myServerNodeAssociations == null) {
                        this.myServerNodeAssociations = new NodeAssociations(serverDevKey);
                    }
                    this.myServerNodeAssociations.setTheAssociation(serverDevKey, encl.getDeviceKey(), "ServerToEnclosure", false);
                    this.myServerNodeAssociations.setSlotNumber(this.bladeSlot);
                    this.myServerNodeAssociations.setMmHeight(this.bladeHeight);
                    this.myServerNodeAssociations.setMmWidth(this.bladeWidth);
                    this.myServerNodeAssociations.setMmDepth(this.bladeDepth);
                    if (this.numSlotsX > 0 && this.numSlotsY > 0) {
                        this.myServerNodeAssociations.setNumBladeSlotsUsedXDir(this.numSlotsX);
                        this.myServerNodeAssociations.setNumBladeSlotsUsedYDir(this.numSlotsY);
                        this.myServerNodeAssociations.setNumBladeSlotsUsed(this.numSlotsX * this.numSlotsY);
                    } else {
                        this.myServerNodeAssociations.setNumBladeSlotsUsedYDir(1);
                    }
                    this.myNodeRelationships.setSource(this.associationType);
                    this.myServerNodeAssociations.setSource(this.associationType);
                    this.myEnclosureNodeAssociations.setSource(this.associationType);
                    this.addDeviceToTopologyTree(this.myEnclosureNodeAssociations, serverDevKey);
                    this.myServerNodeAssociations.setInContainer(true);
                    this.myServerNodeAssociations.setParent(encl.getDeviceKey());
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    private int getIntegerValueFromXml(String intString) {
        if (intString != null) {
            return new Integer(intString);
        }
        return -1;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDatafromiLO(MxNode iLONode) {
        block17: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("iLOAssociationDataHandler:getDatafromiLO(" + iLONode.getNameString() + ")"));
            }
            ILOAllQueryConstants iLOConstants = null;
            ILOICMBConstants iLOICMBConstants = null;
            try {
                MxNode serverNode;
                NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
                int associatedDeviceKey = nodeAssociationsManager.getAssociatedDeviceKey(iLONode.getDeviceKey(), "MgmtProcToServer_Ilo");
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("Server Device Key:" + associatedDeviceKey));
                }
                if (associatedDeviceKey <= 0 || (serverNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey)).getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) break block17;
                MgmtProcessorParser mpp = new MgmtProcessorParser();
                ILOParser iLOParser = ILOParser.getInstance();
                MxNode enclNode = EnclosureNodeUpdater.getServerEnclosureNode(serverNode);
                if (enclNode == null) break block17;
                StringBuffer urlName = new StringBuffer("http://");
                urlName = urlName.append(iLONode.getWorkingAddress());
                urlName = urlName.append("/xmldata?item=All");
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("Url for ALL Query:" + urlName.toString()));
                }
                String xmlAllData = mpp.sendTheRequest(urlName.toString());
                mpp.setXmlData(xmlAllData);
                Double iLOFW = null;
                Vector powerEnclInfo = null;
                if (xmlAllData != null) {
                    Element rootElement = mpp.getXmlRootElement();
                    iLOConstants = iLOParser.processAllQueryXml(rootElement);
                    String FW = iLOConstants.iloFWRI;
                    if (FW != "") {
                        iLOFW = new Double(FW);
                        powerEnclInfo = iLOConstants.rkTplgyHolder;
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("iLOFW:" + FW));
                            log_.debug((Object)("No.Of Power Enclosures:" + powerEnclInfo.size()));
                        }
                    }
                }
                if (!(iLOFW != null && iLOFW >= 1.8) && !iLONode.getModel().toLowerCase().equals("integrated lights-out 2 (ilo 2)")) break block17;
                String serverEnclIcmb = iLOConstants.infraIcmbAddr;
                StringBuffer url = new StringBuffer("http://");
                url = url.append(iLONode.getWorkingAddress());
                url = url.append("/xmldata?item=icmb&addr=");
                StringBuffer serverEnclUrl = new StringBuffer(url.toString());
                serverEnclUrl = serverEnclUrl.append(serverEnclIcmb);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("ICMB Query for Server Enclosure:" + serverEnclUrl.toString()));
                }
                SyncObject syncObject = SyncObject.getInstance();
                synchronized (syncObject) {
                    if (!EnclosureNodeUpdater.isEnclNodeUpdated(enclNode)) {
                        String xmlData = mpp.sendTheRequest(serverEnclUrl.toString());
                        mpp.setXmlData(xmlData);
                        if (xmlData != null) {
                            Element root = mpp.getXmlRootElement();
                            iLOICMBConstants = iLOParser.processICMBQueryXml(root, true);
                            enclNode.setClientAttribute("AdviLO.AdvanedILO_IP", iLONode.getWorkingAddress());
                            EnclosureNodeUpdater.updateEnclNode(enclNode, iLOICMBConstants, true);
                            EnclosureNodeUpdater.display(enclNode, true);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclNode, false);
                        }
                    }
                    ArrayList powerEnclNodes = EnclosureNodeUpdater.getPowerEnclosureNode(enclNode.getDeviceKey());
                    MxNode powerEnclNode = null;
                    for (int i = 0; i < powerEnclNodes.size(); ++i) {
                        powerEnclNode = (MxNode)powerEnclNodes.get(i);
                        if (EnclosureNodeUpdater.isEnclNodeUpdated(powerEnclNode)) continue;
                        for (int j = 0; j < powerEnclInfo.size(); ++j) {
                            Vector powerEncl = (Vector)powerEnclInfo.elementAt(j);
                            if (powerEnclNode.getSerialNumber() == null || !powerEncl.elementAt(1).equals(powerEnclNode.getSerialNumber())) continue;
                            StringBuffer powerEnclUrl = new StringBuffer(url.toString());
                            powerEnclUrl = powerEnclUrl.append(powerEncl.elementAt(2));
                            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                                log_.debug((Object)("URL for Power Enclosure:" + powerEnclUrl.toString()));
                            }
                            String powerXmlData = mpp.sendTheRequest(powerEnclUrl.toString());
                            mpp.setXmlData(powerXmlData);
                            if (powerXmlData == null) continue;
                            Element root = mpp.getXmlRootElement();
                            iLOICMBConstants = iLOParser.processICMBQueryXml(root, false);
                            powerEnclNode.setClientAttribute("AdviLO.AdvanedILO_IP", iLONode.getWorkingAddress());
                            powerEnclNode.setClientAttribute("AdviLO.pwrEncl.Prod_ID", powerEncl.elementAt(0).toString());
                            EnclosureNodeUpdater.updateEnclNode(powerEnclNode, iLOICMBConstants, false);
                            EnclosureNodeUpdater.display(powerEnclNode, false);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), powerEnclNode, false);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block17;
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
        }
    }

    private void setProductSubType(String model, MxNode server) {
        if (model != null) {
            ArrayList<String> subTypes;
            server.setModel(model);
            if (model.matches("ProLiant BL[0-9][0-9]p.*")) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("IloAssociationDataHandler.setProductSubType(" + model + ")"));
                }
                subTypes = new ArrayList<String>();
                subTypes.add("Blade");
                subTypes.add("p-Class");
                subTypes.add("HPProLiant");
                server.setDeviceSubTypes(subTypes);
            }
            if (model.matches("ProLiant xw[0-9][0-9]p Blade Wor.*")) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("IloAssociationDataHandler.setProductSubType(" + model + ")"));
                }
                subTypes = new ArrayList();
                subTypes.add("Blade");
                server.setDeviceSubTypes(subTypes);
            }
            if (model.matches("ProLiant BL[0-9][0-9][0-9]c.*")) {
                subTypes = new ArrayList();
                subTypes.add("Blade");
                subTypes.add("c-Class");
                subTypes.add("HPProLiant");
                server.setDeviceSubTypes(subTypes);
            }
        }
    }

    private void setSubTypeForRack(String model) {
        if (model != null) {
            if (model.matches("ProLiant BL[0-9][0-9]p.*") || model.matches("ProLiant xw[0-9][0-9]p Blade Wor.*")) {
                this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
            }
            if (model.matches("ProLiant BL[0-9][0-9][0-9]c.*")) {
                this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
            }
        }
    }
}

