/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PbleClassAssociationDataHandler
extends SnmpRackMibHandler {
    private String associationType = "";
    private static Integer syncenclIa = new Integer(0);

    public PbleClassAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        int ribLoc = 0;
        String theCpqSiSysSerialNo = null;
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The PBLECLASSASSOCIATIONDATAHANDLER.... for device " + d.getDeviceName()));
        if (!d.getDeviceType().equals("MgmtProc") || d.getModel().toLowerCase().indexOf("proliant bl e-class") == -1) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The PBLECLASSASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The PblEclassASSOCIATIONDATAHANDLER.... - Getting the new associations");
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("PbleclassAssociationDataHandler : Working Address is null for device : " + d.getDeviceName()));
            return;
        }
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Integrated Administrator Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
            return;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Integrated Administrator Association skipped ; snmp not detected on " + d.getDeviceName()));
            return;
        }
        theCpqSiSysSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.2.2.2.1.0[1]", true);
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("PBLECLASSASSOCIATIONDATAHANDLER....After getting server serial no. " + theCpqSiSysSerialNo + " for device " + d.getDeviceName()));
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("PBLECLASSASSOCIATIONDATAHANDLER....After getting rib location  " + ribLoc + " for device " + d.getDeviceName()));
        boolean hasARib = d.checkMibStatusArrayForMib(9);
        if (hasARib) {
            if (ribLoc == 4) {
                try {
                    this.getRackAttributesFromTheMib();
                    this.getCommonEnclosureAttributesAndTopologyFromTheMib();
                    this.getServerEnclosureAttributesFromTheMib();
                    this.getEClassSwitchAttributesFromMib();
                    while (true) {
                        PbleClassAssociationDataHandler pbleClassAssociationDataHandler = this;
                        if (pbleClassAssociationDataHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                        Thread.sleep(100L);
                    }
                    this.doRackEnclosureDeviceProcessing(d);
                    this.doSwitchEnclAssociation(d);
                    Vector powerDetails = this.getRackPowerSupplyDetails();
                    if (powerDetails.size() > 0) {
                        this.setPowerDetailsOnEnclosure(powerDetails, d);
                    }
                    this.setAssociationsForTheListOfAssociatedDevices(d, theCpqSiSysSerialNo);
                }
                catch (Exception e) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)(" EXCEPTION : " + e));
                    containerDeviceDebug.exception((Throwable)e);
                }
                finally {
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    PbleClassAssociationDataHandler pbleClassAssociationDataHandler = this;
                    pbleClassAssociationDataHandler.myNodeRelationshipManager.releaseWriteLock();
                }
            }
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)(" HASARIB IS TRUE for HALO and SSN : " + theCpqSiSysSerialNo));
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("SnmpDevId " + d.getDeviceName() + " rib " + ribLoc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block6: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    String mgmtEnclAssocType = "MgmtProcToEnclosure";
                    if (device == null || !device.getDeviceType().equals("MgmtProc")) continue;
                    if (associationTypeNumber.equalsIgnoreCase(mgmtEnclAssocType)) {
                        if (deviceKey1 != deviceDbKey) continue;
                        na.setInContainer(true);
                        na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                        continue;
                    }
                    if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ia") && !associationTypeNumber.equalsIgnoreCase("MgmtProcToDesktop_Ia") || deviceKey2 != deviceDbKey) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block6;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAssociationsForTheListOfAssociatedDevices(MxNode device, String theSerialNumber) {
        block21: {
            MxNode associatedDevice = null;
            NodeAssociations theAssociatedDeviceNodeAssociations = null;
            NodeAssociations theEnclosureNodeAssociations = null;
            try {
                MxNode theEnclosure = null;
                try {
                    theEnclosure = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(theSerialNumber);
                }
                catch (MxUndefinedNodeException ex) {
                    // empty catch block
                }
                List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), theSerialNumber);
                Iterator iter = allDevicesWithThisProperty.iterator();
                containerDeviceDebug.log(20, "Size of the associated devices iteration : " + allDevicesWithThisProperty.size());
                while (iter.hasNext()) {
                    Integer associatedDeviceKey = (Integer)iter.next();
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)(" Adding association for device keys : " + associatedDeviceKey + " and " + device.getDeviceKey()));
                    try {
                        associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey.intValue());
                    }
                    catch (MxUndefinedNodeException ex1) {
                        // empty catch block
                    }
                    theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(associatedDeviceKey.intValue());
                    if (theAssociatedDeviceNodeAssociations == null) {
                        theAssociatedDeviceNodeAssociations = new NodeAssociations(associatedDeviceKey.intValue());
                    }
                    if (associatedDevice.getDeviceType().equals("Server")) {
                        this.myNodeRelationships.setTheAssociation(associatedDeviceKey.intValue(), device.getDeviceKey(), "MgmtProcToServer_Ia", false);
                    } else if (associatedDevice.getDeviceType().equals("Desktop")) {
                        this.myNodeRelationships.setTheAssociation(associatedDeviceKey.intValue(), device.getDeviceKey(), "MgmtProcToDesktop_Ia", false);
                    }
                    this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
                    this.getServerBladeAttributesFromTheMib(true, associatedDevice.getSerialNumber());
                    theAssociatedDeviceNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
                    theAssociatedDeviceNodeAssociations.setSlotNumber(this.getBladeSlot());
                    theAssociatedDeviceNodeAssociations.setMmHeight(this.getBladeHeight());
                    theAssociatedDeviceNodeAssociations.setMmWidth(this.getBladeWidth());
                    theAssociatedDeviceNodeAssociations.setMmDepth(this.getBladeDepth());
                    theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
                    theAssociatedDeviceNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
                    theAssociatedDeviceNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
                    theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
                    theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
                    theAssociatedDeviceNodeAssociations.setSource(this.associationType);
                    if (theEnclosure != null && theEnclosure.getDeviceType().equals("Enclosure")) {
                        theEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
                        if (theAssociatedDeviceNodeAssociations.getSlotNumber() != -1) {
                            if (associatedDevice.getDeviceType().equals("Server")) {
                                theAssociatedDeviceNodeAssociations.setTheAssociation(associatedDeviceKey.intValue(), theEnclosure.getDeviceKey(), "ServerToEnclosure", false);
                            } else if (associatedDevice.getDeviceType().equals("Desktop")) {
                                theAssociatedDeviceNodeAssociations.setTheAssociation(associatedDeviceKey.intValue(), theEnclosure.getDeviceKey(), "DesktopToEnclosure", false);
                            }
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)(" Just before adding the device " + associatedDeviceKey + " to the topology tree of " + theEnclosure.toString()));
                            this.addDeviceToTopologyTree(theEnclosureNodeAssociations, associatedDeviceKey);
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"Finished adding the device to the topology tree");
                            theAssociatedDeviceNodeAssociations.setInContainer(true);
                            theAssociatedDeviceNodeAssociations.setParent(theEnclosure.getDeviceKey());
                            associatedDevice.setRackName(this.getRackName());
                            associatedDevice.setEnclosureName(theEnclosure.getDeviceName());
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), associatedDevice, false);
                            this.myNodeRelationshipManager.update(theEnclosureNodeAssociations);
                        }
                    }
                    this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                }
                if (theEnclosure == null) break block21;
                List nodeSubTypeList = theEnclosure.getDeviceSubTypes();
                boolean bModify = false;
                if (!nodeSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                    bModify = true;
                }
                Integer n = syncenclIa;
                synchronized (n) {
                    if (bModify) {
                        theEnclosure.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclosure, false);
                    }
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    public void setFanDetailsOnEnclosure(Vector fanDetails) {
        for (int i = 0; i < fanDetails.size(); ++i) {
            Vector tplgy = (Vector)fanDetails.elementAt(i);
            String enclsoureSerialNum = (String)tplgy.elementAt(4);
            try {
                int theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclsoureSerialNum, 14);
                if (theEnclDeviceKey == 0) continue;
                MxNode theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                int fanPresent = (Integer)tplgy.elementAt(0);
                if (fanPresent > 0) {
                    theEnclDevice.setClientAttribute("fanPresent", "true");
                    break;
                }
                theEnclDevice.setClientAttribute("fanPresent", "false");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void setPowerDetailsOnEnclosure(Vector powerDetails, MxNode d) {
        boolean leftPowerSupPresent = false;
        boolean rightPowerSupPresent = false;
        String enclsoureSerialNum = null;
        for (int i = 0; i < powerDetails.size(); ++i) {
            Vector tplgy = (Vector)powerDetails.elementAt(i);
            enclsoureSerialNum = (String)tplgy.elementAt(0);
            String powerSupIndex = (String)tplgy.elementAt(1);
            String powerSupSerialNum = (String)tplgy.elementAt(2);
            if (powerSupIndex.equals("00000001") && powerSupSerialNum != null && powerSupSerialNum != "") {
                leftPowerSupPresent = true;
            }
            if (!powerSupIndex.equals("00000002") || powerSupSerialNum == null || powerSupSerialNum == "") continue;
            rightPowerSupPresent = true;
        }
        try {
            int theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToEnclosure");
            MxNode theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            if (theEnclDevice != null && theEnclDevice.getSerialNumber().equals(enclsoureSerialNum)) {
                theEnclDevice.setClientAttribute("leftPowerSupply", String.valueOf(leftPowerSupPresent));
                theEnclDevice.setClientAttribute("rightPowerSupply", String.valueOf(rightPowerSupPresent));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        block7: {
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"PbleClass : In rackEnclosure Device Processing");
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"PbleClass : Before storing enclosure information");
                NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(this.getContainerEnclosureInformation(), null, null);
                if (theEnclNodeAssociations != null) {
                    int myDeviceKey = this.device.getDeviceKey();
                    int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("The encl device is " + theEnclDeviceKey));
                    this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(theEnclDeviceKey, "MgmtProcToEnclosure");
                    this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "MgmtProcToEnclosure", false);
                    this.myNodeRelationships.setInContainer(true);
                    this.myNodeRelationships.setParent(theEnclDeviceKey);
                    theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
                    theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
                    theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
                    theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
                    theEnclNodeAssociations.setSource("Enclosure");
                    this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"PbleClass : after storing enclosure and rack information");
                int enclDevKey = 0;
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"PBLECLASSASSOCIATIONDATAHANDLER....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToEnclosure");
                    if (enclDevKey <= 0) break block7;
                    try {
                        enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    d.setEnclosureName(enclName);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    public void doSwitchEnclAssociation(MxNode d) {
        block6: {
            String switchSerialNum = this.getSwitchSerialNum();
            String enclosureSerialNum = this.getEnclosureSerialNum();
            NodeAssociations theAssociatedDeviceNodeAssociations = null;
            int enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToEnclosure");
            if (enclDevKey > 0) {
                try {
                    MxNode theEnclDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey);
                    MxNode theSwitchDev = null;
                    if (!theEnclDev.getSerialNumber().equals(enclosureSerialNum.trim())) break block6;
                    try {
                        theSwitchDev = AssociationHandlerUtil.getNodeBySerialNumber(switchSerialNum.trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (theSwitchDev != null) {
                        NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDev.getDeviceKey());
                        theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theSwitchDev.getDeviceKey());
                        theAssociatedDeviceNodeAssociations.setTheAssociation(theSwitchDev.getDeviceKey(), enclDevKey, "SwitchToEnclosure", false);
                        theAssociatedDeviceNodeAssociations.setSource("SwitchToEnclosure");
                        theAssociatedDeviceNodeAssociations.setInContainer(true);
                        theAssociatedDeviceNodeAssociations.setParent(enclDevKey);
                        this.addDeviceToTopologyTree(theEnclNodeAssociations, theSwitchDev.getDeviceKey());
                        theEnclNodeAssociations.setSource("Enclosure");
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    }
                    BladeIMELogger.log("PbleClassAssociationDataHandler:doSwitchEnclAssociation : set Switch As client Attribute with Switch_SerNum:" + switchSerialNum);
                    theEnclDev.setClientAttribute("Switch_SerNum", switchSerialNum);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDev, false);
                }
                catch (Exception ex1) {
                    // empty catch block
                }
            }
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToDesktop_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToEnclosure");
        Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("MgmtProcToEnclosure");
        for (int i = 0; i < v.size(); ++i) {
            this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
        }
    }
}

