/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.SnmpSm2MibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class RiloeAssociationDataHandler
extends SnmpSm2MibHandler {
    private String associationType = "";

    public RiloeAssociationDataHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        int ribLoc;
        block19: {
            String workingAddress;
            int associatedDeviceKey;
            block18: {
                BladeIMELogger.log("RiloAssociationDataHandler.getAssociationData" + d.getDeviceKey() + "," + idInfo);
                BladeIMELogger.log("RiloAssociationDataHandler.getAssociationData ModelName :" + d.getModel().toLowerCase() + "for" + d.getDeviceKey());
                if (AssociationHandlerConstants.isHPSystem()) {
                    return;
                }
                ribLoc = 0;
                String theRibSerialNo = null;
                String systemUuid = null;
                boolean isThisAGardianServer = false;
                associatedDeviceKey = 0;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The RILOEASSOCIATIONDATAHANDLER....");
                if (!d.getDeviceType().equals("MgmtProc") || d.getModel().toLowerCase().indexOf("integrated lights-out") != -1 || d.getModel().toLowerCase().indexOf("remote insight lights-out edition ii") != -1) {
                    BladeIMELogger.log("RiloAssociationDataHandler.getAssociationData : model does not match " + d.getDeviceKey());
                    BladeIMELogger.log("RiloAssociationDataHandler cleaning up the associations");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The RILOEASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                    this.cleanUpAssociationData(d);
                    return;
                }
                String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
                if (!snmpEnabled.equals("checked")) {
                    DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Riloe Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
                    return;
                }
                if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                    DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Riloe Association skipped ; snmp not detected on " + d.getDeviceName()));
                    return;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The RILOEASSOCIATIONDATAHANDLER.... - Getting the new associations");
                workingAddress = d.getWorkingAddress();
                if (workingAddress == null) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    RiloeAssociationDataHandler : Working Address is null for device : " + d.getDeviceName()));
                    return;
                }
                if (this.isThisDeviceAnIloRiloe()) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"    IN The RILOEASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                    this.cleanUpAssociationData(d);
                    return;
                }
                ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
                BladeIMELogger.log("RILOEASSOCIATIONDATAHANDLER ribLoc:" + ribLoc);
                boolean hasARib = d.checkMibStatusArrayForMib(9);
                BladeIMELogger.log("RILOEASSOCIATIONDATAHANDLER hasARib:" + hasARib);
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    hasARib = " + hasARib));
                if (!hasARib) break block18;
                if (ribLoc != 2 && ribLoc != 3) break block19;
                theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
                BladeIMELogger.log("RILOEASSOCIATIONDATAHANDLER theRibSerialNo:" + theRibSerialNo + ":" + d.getDeviceKey());
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    theRibSerialNo = " + theRibSerialNo));
                }
                systemUuid = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.11.2.10.3.0[1]", true);
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    systemUuid = " + systemUuid));
                }
                if (systemUuid != null && this.isValidUuid(systemUuid)) {
                    MxNode hostServer = null;
                    try {
                        hostServer = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(systemUuid);
                    }
                    catch (MxUndefinedNodeException ex) {
                        hostServer = null;
                    }
                    if (hostServer != null) {
                        associatedDeviceKey = hostServer.getDeviceKey();
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    RILOEASSOCIATIONDATAHANDLER..... The associated device key (via UUID): " + associatedDeviceKey + " for RIB " + d.getDeviceName()));
                    }
                }
                if (associatedDeviceKey == 0) {
                    String theCpqSiSysSerialNo = null;
                    BladeIMELogger.log("theCpqSiSysSerialNo:" + theCpqSiSysSerialNo + ":" + d.getDeviceKey());
                    theCpqSiSysSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.2.2.2.1.0[1]", true);
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    theCpqSiSysSerialNo = " + theCpqSiSysSerialNo));
                    if (theCpqSiSysSerialNo != null && theCpqSiSysSerialNo.trim().length() > 0) {
                        associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theCpqSiSysSerialNo);
                        BladeIMELogger.log("RILOEASSOCIATIONDATAHANDLER :associatedDeviceKey:" + associatedDeviceKey + "for device " + d.getDeviceName());
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    RILOEASSOCIATIONDATAHANDLER..... The associated device key : " + associatedDeviceKey + " for device " + d.getDeviceName()));
                        }
                    }
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    associatedDeviceKey = " + associatedDeviceKey));
                }
                if (associatedDeviceKey == 0) break block19;
                BladeIMELogger.log("make assc MgmtProcToServer_Rib for :" + d.getDeviceKey() + "and" + associatedDeviceKey);
                this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Rib", true);
                break block19;
            }
            List listOfAssociatedDeviceKeys = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("compaq.Devices.associatedIpAddress", workingAddress);
            Iterator iter = listOfAssociatedDeviceKeys.iterator();
            while (iter.hasNext()) {
                associatedDeviceKey = (Integer)iter.next();
                BladeIMELogger.log("associatedDeviceKey:" + associatedDeviceKey);
                if (associatedDeviceKey == 0) continue;
                BladeIMELogger.log("make assc MgmtProcToServer_Rib for :" + d.getDeviceKey() + "and" + associatedDeviceKey);
                this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Rcc", true);
            }
        }
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    SnmpDevId " + d.getDeviceName() + " rib " + ribLoc));
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
    }

    private boolean isValidUuid(String systemUuid) {
        systemUuid = systemUuid.trim();
        try {
            Integer intUuid = new Integer(systemUuid);
            if (intUuid == 0) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block6: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            int deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (device == null || !device.getDeviceType().equals("MgmtProc")) continue;
                    if (associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Rib")) {
                        if (deviceKey1 != deviceDbKey) continue;
                        na.setTheAssociation(deviceKey1, deviceKey2, "MgmtProcToServer_Rib", false);
                        continue;
                    }
                    if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Rcc") || deviceKey1 != deviceDbKey) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, "MgmtProcToServer_Rcc", false);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block6;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rib");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rcc");
    }

    public boolean isThisDeviceAnIloRiloe() {
        BladeIMELogger.log("RILOASSOCIATIONDATAHANDLER:isThisDeviceAnIloRiloe ");
        int isThisAnIloRiloe = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true);
        return isThisAnIloRiloe == 5 || isThisAnIloRiloe == 6 || isThisAnIloRiloe == 7;
    }
}

