/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.core.tools.identification.associations.SyncObject;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.iLOXml.ILOAllQueryConstants;
import com.hp.mx.portal.iLOXml.ILOICMBConstants;
import com.hp.mx.portal.iLOXml.ILOParser;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class WorkstationServerHandler
extends SnmpRackMibHandler {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private String associationType = "";

    public WorkstationServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"WorkStationHandler.getAssociationData()");
            log_.debug((Object)(" d.getDeviceName():" + d.getDeviceName()));
        }
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        int ribLoc = 0;
        Object theRibSerialNo = null;
        Object theCpqSiSysSerialNo = null;
        boolean isThisAGardianServer = false;
        boolean associatedDeviceKey = false;
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The WorkstationServerHandler.... for device " + d.getDeviceName() + " And product type " + d.getDeviceType()));
        }
        if (!d.getDeviceType().equals("Workstation")) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The WorkstationServerHandler.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("WorkstationServerHandler Server Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
            return;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("WorkstationServerHandler Server Association skipped ; snmp not detected on " + d.getDeviceName()));
            return;
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The WorkstationServerHandler.... - Getting the new associations");
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("WorkstationServerHandler : Working Address is null for device : " + d.getDeviceName()));
            }
            return;
        }
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("WorkstationServerHandler....After getting rib location  " + ribLoc + " for device " + d.getDeviceName()));
        }
        int doesThisHaveEnclosureMgmt = 0;
        try {
            block34: {
                if (ribLoc == 1) {
                    this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.2[0],1.3.6.1.4.1.232.2.2.13.1.1.6[1]");
                    boolean endOfTable = false;
                    String typeResponseOID = null;
                    String serialNoResponseOID = null;
                    Object serialNumber = null;
                    while (true) {
                        WorkstationServerHandler workstationServerHandler = this;
                        if (workstationServerHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                        Thread.sleep(100L);
                    }
                    while (!endOfTable) {
                        SnmpResponseVarBind vb2;
                        this.snmpPdh.snmpReq.SnmpGetNext();
                        SnmpResponse curResp = this.snmpPdh.snmpReq.getResponseVarbinds();
                        SnmpResponseVarBind vb = curResp.findById(0);
                        if (vb == null || vb.isError()) break;
                        typeResponseOID = vb.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The TYPE RESPONSE OID : " + typeResponseOID));
                        }
                        if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
                        serialNoResponseOID = vb2.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The SERIAL no. RESPONSE OID : " + serialNoResponseOID));
                        }
                        if (!typeResponseOID.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.2.")) break;
                        doesThisHaveEnclosureMgmt = vb.getIntValue();
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Value returned from type OID : " + doesThisHaveEnclosureMgmt));
                        }
                        if (doesThisHaveEnclosureMgmt == 2) {
                            this.getRackAttributesFromTheMib();
                            this.getCommonEnclosureAttributesAndTopologyFromTheMib();
                            this.getServerEnclosureAttributesFromTheMib();
                            this.getServerBladeAttributesFromTheMib(false, null);
                            this.getSwitchAttributesFromTheMib();
                            this.doRackEnclosureDeviceProcessing(d);
                            this.doWorkstationIloDeviceProcessing(d);
                            break;
                        }
                        this.snmpPdh.snmpReq.clearSnmpReqInfo();
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(typeResponseOID, "0");
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(serialNoResponseOID, "1");
                    }
                }
                int rackDevKey = 0;
                int enclDevKey = 0;
                String rackName = "";
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"WorkstationServerHandler ....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
                    if (enclDevKey > 0) {
                        try {
                            enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                        }
                        catch (MxUndefinedNodeException ex) {
                            // empty catch block
                        }
                        rackDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclDevKey, "EnclosureToRack");
                        if (rackDevKey > 0) {
                            try {
                                rackName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey).getDeviceName();
                            }
                            catch (MxUndefinedNodeException ex1) {
                                // empty catch block
                            }
                        }
                        d.setRackName(rackName);
                        d.setEnclosureName(enclName);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                        break block34;
                    }
                    if (this.myNodeRelationships.inContainer()) {
                        MxNode encl;
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("device " + d.getDeviceName() + " thinks it's in an enclosure, but we have nothing for it - fix that"));
                        }
                        if ((encl = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure")) != null) {
                            NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(encl.getDeviceKey());
                            if (theEnclNodeAssociations != null) {
                                DefaultMutableTreeNode topologyTree = theEnclNodeAssociations.getContainerDeviceTree();
                                topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                                theEnclNodeAssociations.setContainerDeviceTree(topologyTree);
                                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                            }
                            this.myNodeRelationshipManager.update(this.myNodeRelationships);
                        }
                    }
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Done trying to find associations for SERVER : " + d.getDeviceName()));
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            WorkstationServerHandler workstationServerHandler = this;
            workstationServerHandler.myNodeRelationshipManager.releaseWriteLock();
            this.getDatafromiLO(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        block17: {
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)"WorkStationHandler:loadAssociationDataFromDb");
                log_.debug((Object)(" device.getDeviceName():" + device.getDeviceName()));
            }
            try {
                NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
                MxNode theDevice = null;
                try {
                    theDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceDbKey);
                }
                catch (MxUndefinedNodeException ex1) {
                    theDevice = null;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    MxNode dev1 = null;
                    if (deviceKey1 == deviceDbKey) {
                        dev1 = theDevice;
                    } else {
                        try {
                            dev1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey1);
                        }
                        catch (MxUndefinedNodeException ex) {
                            dev1 = null;
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("load assn for " + deviceDbKey + " k1 " + deviceKey1 + " k2 " + deviceKey2 + " dev1 " + dev1));
                    if (dev1 == null || !dev1.getDeviceType().equals("Workstation")) continue;
                    if (associationTypeNumber.equalsIgnoreCase("ServerToEnclosure")) {
                        if (deviceKey1 != deviceDbKey) continue;
                        na.setInContainer(true);
                        na.setParent(deviceKey2);
                        na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                        continue;
                    }
                    if (!associationTypeNumber.startsWith("MgmtProcToServer_Ilo")) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
            catch (NodeAssociationsPersistenceException nape) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("A Node Associations Persistence Exception: " + (Object)((Object)nape)));
            }
            catch (SQLException myException) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void doRackEnclosureDeviceProcessing(MxNode d) {
        log_.debug((Object)" workstaion handler: doRackEnclosureDeviceProcessing");
        log_.debug((Object)(" d.getDeviceName():" + d.getDeviceName()));
        try {
            Vector enclosureInfo;
            String enclSerNo = null;
            if (this.getTopology().size() > 0 && (enclosureInfo = (Vector)this.getTopology().elementAt(this.getServerEnclosureIndex())) != null) {
                enclSerNo = (String)enclosureInfo.elementAt(8);
            }
            if (enclSerNo != null && !enclSerNo.equals("")) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : In rackEnclosure Device Processing");
                log_.debug((Object)(" getBladeSlot():" + this.getBladeSlot()));
                log_.debug((Object)("getBladeSlotsUsedXDir():" + this.getBladeSlotsUsedXDir()));
                log_.debug((Object)("getBladeSlotsUsedYDir():" + this.getBladeSlotsUsedYDir()));
                this.myNodeRelationships.setSlotNumber(this.getBladeSlot());
                this.myNodeRelationships.setMmHeight(this.getBladeHeight());
                this.myNodeRelationships.setMmWidth(this.getBladeWidth());
                this.myNodeRelationships.setMmDepth(this.getBladeDepth());
                this.myNodeRelationships.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
                this.myNodeRelationships.setSource(this.associationType);
                this.myNodeRelationships.setSwitchApis(this.getSwitchesPresent());
                log_.debug((Object)("myNodeRelationships.getSlotNumber():" + this.myNodeRelationships.getSlotNumber()));
                log_.debug((Object)("myNodeRelationships.getNumBladeSlotsUsedXDir():" + this.myNodeRelationships.getNumBladeSlotsUsedXDir()));
                log_.debug((Object)("myNodeRelationships.getNumBladeSlotsUsedYDir():" + this.myNodeRelationships.getNumBladeSlotsUsedYDir()));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Finished storing blade attributes");
                NodeAssociations theEnclNodeAssociations = null;
                if (this.getServerEnclosureIndex() != -1) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Before storing enclosure information");
                    theEnclNodeAssociations = this.getEnclosureInformation((Vector)this.getTopology().elementAt(this.getServerEnclosureIndex()), this.getRackName(), this.getRuid());
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : after storing enclosure and rack information");
                    if (theEnclNodeAssociations != null) {
                        int myDeviceKey = this.device.getDeviceKey();
                        int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("The encl device is " + theEnclDeviceKey));
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Slot number for myNodeRelationships in storeenclosureinformation is " + this.myNodeRelationships.getSlotNumber()));
                        if (this.myNodeRelationships.getSlotNumber() != -1) {
                            this.removeOldAssociationsFromThisSlot(myDeviceKey, theEnclDeviceKey);
                            if (this.device.getDeviceType().equals("Workstation")) {
                                this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "ServerToEnclosure", false);
                            }
                            this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                            this.myNodeRelationships.setInContainer(true);
                            this.myNodeRelationships.setParent(theEnclDeviceKey);
                        }
                        theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
                        theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
                        theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
                        theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
                        theEnclNodeAssociations.setSource("Enclosure");
                        this.getRackInformation(this.getRackName(), this.getRuid(), theEnclDeviceKey);
                        if (this.getTheRackDevice() != null) {
                            this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                        }
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    }
                }
                this.storeTopologyInformation(this.getTopology(), this.getTheRackDevice());
            } else {
                MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
                if (dTmp != null) {
                    NodeAssociations dTmpNodeAssociations;
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("MIB shows server " + new Integer(d.getDeviceKey()) + " was not in enclosure - removing it from topology"));
                    }
                    if ((dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
                        DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
                        topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                        dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
                        this.myNodeRelationshipManager.update(dTmpNodeAssociations);
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void doWorkstationIloDeviceProcessing(MxNode d) {
        String theRibSerialNo = null;
        int associatedDeviceKey = 0;
        try {
            List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), d.getAgentUUID());
            if (allDevicesWithThisProperty.size() > 0) {
                Iterator iter = allDevicesWithThisProperty.iterator();
                containerDeviceDebug.log(20, "Size of the associated devices iteration : " + allDevicesWithThisProperty.size());
                while (iter.hasNext()) {
                    Integer assocDeviceKey = (Integer)iter.next();
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)(" Adding association for device keys : " + assocDeviceKey + " and " + d.getDeviceKey()));
                    this.myNodeRelationships.setTheAssociation(assocDeviceKey.intValue(), d.getDeviceKey(), "MgmtProcToServer_Ilo", true);
                }
            } else {
                theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
                if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0) {
                    int isThisIloRilo;
                    associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theRibSerialNo);
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("SERVERASSOCIATIONDATAHANDLER..... The associated device key : " + associatedDeviceKey + " for device " + d.getDeviceName()));
                    }
                    if (associatedDeviceKey != 0 && ((isThisIloRilo = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true)) == 5 || isThisIloRilo == 6)) {
                        this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Ilo", true);
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rib");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rcc");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
            Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            for (int i = 0; i < v.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDatafromiLO(MxNode serverNode) {
        block17: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("pClassAssociationDataHandler:getDatafromiLO(" + serverNode.getNameString() + ")"));
            }
            ILOAllQueryConstants iLOConstants = null;
            ILOICMBConstants iLOICMBConstants = null;
            try {
                NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
                int associatedDeviceKey = nodeAssociationsManager.getAssociatedDeviceKey(serverNode.getDeviceKey(), "MgmtProcToServer_Ilo");
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("iLO Device Key:" + associatedDeviceKey));
                }
                if (associatedDeviceKey <= 0) break block17;
                MxNode iLONode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                MgmtProcessorParser mpp = new MgmtProcessorParser();
                ILOParser iLOParser = ILOParser.getInstance();
                MxNode enclNode = EnclosureNodeUpdater.getServerEnclosureNode(serverNode);
                if (enclNode == null) break block17;
                StringBuffer urlName = new StringBuffer("http://");
                urlName = urlName.append(iLONode.getWorkingAddress());
                urlName = urlName.append("/xmlData?item=All");
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("Url for ALL Query:" + urlName.toString()));
                }
                String xmlAllData = mpp.sendTheRequest(urlName.toString());
                mpp.setXmlData(xmlAllData);
                Double iLOFW = null;
                Vector powerEnclInfo = null;
                if (xmlAllData != null) {
                    Element rootElement = mpp.getXmlRootElement();
                    iLOConstants = iLOParser.processAllQueryXml(rootElement);
                    String FW = iLOConstants.iloFWRI;
                    if (FW != "") {
                        iLOFW = new Double(FW);
                        powerEnclInfo = iLOConstants.rkTplgyHolder;
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("iLOFW:" + FW));
                            log_.debug((Object)("No.Of Power Enclosures:" + powerEnclInfo.size()));
                        }
                    }
                }
                if (iLOFW == null || !(iLOFW >= 1.8)) break block17;
                String serverEnclIcmb = iLOConstants.infraIcmbAddr;
                StringBuffer url = new StringBuffer("http://");
                url = url.append(iLONode.getWorkingAddress());
                url = url.append("/xmlData?item=icmb&addr=");
                StringBuffer serverEnclUrl = new StringBuffer(url.toString());
                serverEnclUrl = serverEnclUrl.append(serverEnclIcmb);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("ICMB Query for Server Enclosure:" + serverEnclUrl.toString()));
                }
                SyncObject syncObject = SyncObject.getInstance();
                synchronized (syncObject) {
                    if (!EnclosureNodeUpdater.isEnclNodeUpdated(enclNode)) {
                        String xmlData = mpp.sendTheRequest(serverEnclUrl.toString());
                        mpp.setXmlData(xmlData);
                        if (xmlData != null) {
                            Element root = mpp.getXmlRootElement();
                            iLOICMBConstants = iLOParser.processICMBQueryXml(root, true);
                            enclNode.setClientAttribute("AdviLO.AdvanedILO_IP", iLONode.getWorkingAddress());
                            EnclosureNodeUpdater.updateEnclNode(enclNode, iLOICMBConstants, true);
                            EnclosureNodeUpdater.display(enclNode, true);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclNode, false);
                        }
                    }
                    ArrayList powerEnclNodes = EnclosureNodeUpdater.getPowerEnclosureNode(enclNode.getDeviceKey());
                    MxNode powerEnclNode = null;
                    for (int i = 0; i < powerEnclNodes.size(); ++i) {
                        powerEnclNode = (MxNode)powerEnclNodes.get(i);
                        if (EnclosureNodeUpdater.isEnclNodeUpdated(powerEnclNode)) continue;
                        for (int j = 0; j < powerEnclInfo.size(); ++j) {
                            Vector powerEncl = (Vector)powerEnclInfo.elementAt(j);
                            if (powerEnclNode.getSerialNumber() == null || !powerEncl.elementAt(1).equals(powerEnclNode.getSerialNumber())) continue;
                            StringBuffer powerEnclUrl = new StringBuffer(url.toString());
                            powerEnclUrl = powerEnclUrl.append(powerEncl.elementAt(2));
                            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                                log_.debug((Object)("URL for Power Enclosure:" + powerEnclUrl.toString()));
                            }
                            String powerXmlData = mpp.sendTheRequest(powerEnclUrl.toString());
                            mpp.setXmlData(powerXmlData);
                            if (powerXmlData == null) continue;
                            Element root = mpp.getXmlRootElement();
                            iLOICMBConstants = iLOParser.processICMBQueryXml(root, false);
                            powerEnclNode.setClientAttribute("AdviLO.AdvanedILO_IP", iLONode.getWorkingAddress());
                            powerEnclNode.setClientAttribute("AdviLO.pwrEncl.Prod_ID", powerEncl.elementAt(0).toString());
                            EnclosureNodeUpdater.updateEnclNode(powerEnclNode, iLOICMBConstants, false);
                            EnclosureNodeUpdater.display(powerEnclNode, false);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), powerEnclNode, false);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block17;
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
        }
    }
}

