/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAXmlJaxb.FANType;
import com.hp.mx.portal.OAXml.OLConstants;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class DeviceFansType {
    private List deviceFanTypeList = new ArrayList();
    private String redundancy;
    private final String[] CLIENTATTRIBUTES = new String[]{"FAN_CNT_", "FAN_RED_"};

    void init(MxNode deviceMxNode, String uniqueIdentifier) {
        BladeIMELogger.log("DeviceFansType.init(" + deviceMxNode + "," + uniqueIdentifier + ")");
        this.redundancy = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier);
        BladeIMELogger.log("DeviceFansType.init.redundancy " + this.redundancy);
        this.print("DeviceFansType DB");
        try {
            int FAN_COUNT = Integer.parseInt(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier));
            BladeIMELogger.log("DeviceFansType.init.FAN_COUNT " + FAN_COUNT);
            DeviceFanType deviceFanType = null;
            for (int i = 0; i < FAN_COUNT; ++i) {
                deviceFanType = this.getDeviceFanType();
                deviceFanType.init(deviceMxNode, uniqueIdentifier, i);
                this.addDeviceFanType(deviceFanType);
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "DeviceFansType.init(DB).Unable to initialize DeviceFanType " + e);
        }
    }

    void init(List fanList, String redundancy) {
        BladeIMELogger.log("DeviceFansType.init(" + fanList + "," + redundancy + ")");
        BladeIMELogger.log("DeviceFansType.init.fanList.size() " + fanList.size());
        this.redundancy = redundancy;
        this.print("DeviceFansType JAXB");
        DeviceFanType deviceFanType = null;
        for (int i = 0; i < fanList.size(); ++i) {
            try {
                deviceFanType = this.getDeviceFanType();
                deviceFanType.init((FANType)fanList.get(i));
                this.addDeviceFanType(deviceFanType);
                continue;
            }
            catch (OAException e) {
                BladeIMELogger.log(e, "DeviceFansType.init(JAXB).OAException " + e);
            }
        }
    }

    void update(MxNode mxNode, String uniqueIdentifier) {
        BladeIMELogger.log("DeviceFansType.update(" + mxNode + "," + uniqueIdentifier + ")");
        BladeIMELogger.log("DeviceFansType.update.deviceFanTypeList.size() " + this.deviceFanTypeList.size());
        BladeIMELogger.log("DeviceFansType.update.redundancy " + this.redundancy);
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier, String.valueOf(this.deviceFanTypeList.size()));
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier, this.redundancy);
        for (int i = 0; i < this.deviceFanTypeList.size(); ++i) {
            ((DeviceFanType)this.deviceFanTypeList.get(i)).update(mxNode, uniqueIdentifier, i);
        }
    }

    void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("DeviceFansType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier));
            enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        BladeIMELogger.log("DeviceFansType.move.deviceFanTypeList.size() " + this.deviceFanTypeList.size());
        for (i = 0; i < this.deviceFanTypeList.size(); ++i) {
            ((DeviceFanType)this.deviceFanTypeList.get(i)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }
    }

    void clean(MxNode deviceMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("DeviceFansType.clean(" + deviceMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        BladeIMELogger.log("DeviceFansType.clean.deviceFanTypeList.size() " + this.deviceFanTypeList.size());
        for (i = 0; i < this.deviceFanTypeList.size(); ++i) {
            ((DeviceFanType)this.deviceFanTypeList.get(i)).clean(deviceMxNode, uniqueIdentifier, i);
        }
    }

    private void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("DeviceFansType.redundancy " + this.redundancy);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }

    public List getDeviceFanTypeList() {
        return this.deviceFanTypeList;
    }

    private DeviceFanType getDeviceFanType() {
        return new DeviceFanType();
    }

    private void addDeviceFanType(DeviceFanType value) {
        this.deviceFanTypeList.add(value);
    }

    public String getRedundancy() {
        return this.redundancy;
    }

    public class DeviceFanType {
        private String type;
        private String status;
        private String pn;
        private String productName;
        private String pwrUsed;
        private String rpmCur;
        private String rpmMax;
        private String rpmMin;
        private DeviceFanBayOccupanType deviceFanBayOccupanType = new DeviceFanBayOccupanType();
        private final String[] CLIENTATTRIBUTES = new String[]{"FAN_TYPE_", "FAN_ST_", "FAN_PN_C_", "FAN_PROD_NAME_", "FAN_PWR_USD_", "FAN_RPM_CUR_", "FAN_RPM_MAX_", "FAN_RPM_MIN_"};

        private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceFanType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            this.type = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
            this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
            this.pn = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
            this.productName = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty);
            this.pwrUsed = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty);
            this.rpmCur = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty);
            this.rpmMax = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[6] + clientAttributeProperty);
            this.rpmMin = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[7] + clientAttributeProperty);
            this.print("DeviceFanType DB");
            this.deviceFanBayOccupanType.init(deviceMxNode, uniqueIdentifier, i);
        }

        private void init(FANType fanType) throws OAException {
            BladeIMELogger.log("DeviceFanType.init(" + fanType + ")");
            try {
                this.type = fanType.getTYPE();
                this.status = fanType.getSTATUS();
                this.pn = fanType.getPN();
                this.productName = fanType.getPRODUCTNAME();
                if (fanType.getPWRUSED() != null) {
                    this.pwrUsed = fanType.getPWRUSED().toString();
                }
                if (fanType.getRPMCUR() != null) {
                    this.rpmCur = fanType.getRPMCUR().toString();
                }
                if (fanType.getRPMMAX() != null) {
                    this.rpmMax = fanType.getRPMMAX().toString();
                }
                if (fanType.getRPMMIN() != null) {
                    this.rpmMin = fanType.getRPMMIN().toString();
                }
                this.print("DeviceFanType JAXB");
                this.deviceFanBayOccupanType.init(fanType);
            }
            catch (Exception e) {
                throw new OAException(e, "DeviceFanType.init(JAXB).Exception " + e);
            }
        }

        private void update(MxNode mxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceFanType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.type);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.status);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.pn);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty, this.productName);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty, this.pwrUsed);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty, this.rpmCur);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[6] + clientAttributeProperty, this.rpmMax);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[7] + clientAttributeProperty, this.rpmMin);
            this.deviceFanBayOccupanType.update(mxNode, uniqueIdentifier, i);
        }

        private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceFanType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
            StringBuffer clientAttributeProperty = null;
            for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                deviceMxNode.setClientAttribute(clientAttributeProperty.toString(), enclosureMxNode.getClientAttribute(clientAttributeProperty.toString()));
                enclosureMxNode.removeClientAttribute(clientAttributeProperty.toString());
            }
            this.deviceFanBayOccupanType.move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }

        private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceFanType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            StringBuffer clientAttributeProperty = null;
            for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                deviceMxNode.removeClientAttribute(clientAttributeProperty.toString());
            }
            this.deviceFanBayOccupanType.clean(deviceMxNode, uniqueIdentifier, i);
        }

        private void print(String SOURCE) {
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
            BladeIMELogger.log("DeviceFanType.type " + this.type);
            BladeIMELogger.log("DeviceFanType.status " + this.status);
            BladeIMELogger.log("DeviceFanType.pn " + this.pn);
            BladeIMELogger.log("DeviceFanType.productName " + this.productName);
            BladeIMELogger.log("DeviceFanType.pwrUsed " + this.pwrUsed);
            BladeIMELogger.log("DeviceFanType.rpmCur " + this.rpmCur);
            BladeIMELogger.log("DeviceFanType.rpmMax " + this.rpmMax);
            BladeIMELogger.log("DeviceFanType.rpmMin " + this.rpmMin);
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
        }

        public String getType() {
            return this.type;
        }

        public String getStatus() {
            return this.status;
        }

        public String getPN() {
            return this.pn;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getPWRDUsed() {
            return this.pwrUsed;
        }

        public String getRPMCur() {
            return this.rpmCur;
        }

        public String getRPMMax() {
            return this.rpmMax;
        }

        public String getRPMMin() {
            return this.rpmMin;
        }

        public DeviceFanBayOccupanType getDeviceFanBayOccupanType() {
            return this.deviceFanBayOccupanType;
        }

        public class DeviceFanBayOccupanType {
            private String connection;
            private List occupies;
            private final String[] CLIENTATTRIBUTES = new String[]{"FAN_CON_"};

            private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("DeviceFanBayOccupanType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                this.connection = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                this.print("DeviceFanBayOccupanType DB");
            }

            private void init(FANType fanType) throws OAException {
                BladeIMELogger.log("DeviceFanBayOccupanType.init(" + fanType + ")");
                try {
                    this.connection = fanType.getBAY().getCONNECTION();
                    this.occupies = fanType.getBAY().getOCCUPIES();
                }
                catch (Exception e) {
                    throw new OAException(e, "DeviceFanBayOccupanType.init(JAXB).Exception " + e);
                }
                this.print("DeviceFanBayOccupanType JAXB");
            }

            private void update(MxNode mxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("DeviceFanBayOccupanType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.connection);
            }

            private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("DeviceFanBayOccupanType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
                StringBuffer clientAttributeProperty = null;
                for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                    clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                    deviceMxNode.setClientAttribute(clientAttributeProperty.toString(), enclosureMxNode.getClientAttribute(clientAttributeProperty.toString()));
                    enclosureMxNode.removeClientAttribute(clientAttributeProperty.toString());
                }
            }

            private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("DeviceFanBayOccupanType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                StringBuffer clientAttributeProperty = null;
                for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                    clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                    deviceMxNode.removeClientAttribute(clientAttributeProperty.toString());
                }
            }

            private void print(String SOURCE) {
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                BladeIMELogger.log("DeviceFanBayOccupanType.connection " + this.connection);
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
            }

            public String getCONNECTION() {
                return this.connection;
            }

            public List getOCCUPIES() {
                return this.occupies;
            }
        }
    }
}

