/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.OAXml.OLEnclosure;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class DeviceManager {
    private Properties m_deviceClasses = null;
    private static DeviceManager deviceManager = null;

    private DeviceManager() {
    }

    public static DeviceManager getDeviceManager() {
        if (deviceManager == null) {
            deviceManager = new DeviceManager();
        }
        return deviceManager;
    }

    public OLDevice getOLDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        BladeIMELogger.log("DeviceManager.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        BladeIMELogger.log("DeviceManager.getOLDevice.m_deviceClasses " + this.m_deviceClasses);
        this.loadProperty();
        OLDevice olDevice = null;
        try {
            olDevice = (OLDevice)this.getDevice(deviceMxNode, initFromMxNode);
        }
        catch (ClassCastException e) {
            throw new OAException(e, "Unable to get OL Device object " + e);
        }
        return olDevice;
    }

    public OLEnclosure getOLEnclosure(MxNode enclosureMxNode, MxNode initFromMxNode) throws OAException {
        BladeIMELogger.log("DeviceManager.getOLEnclosure(" + enclosureMxNode + "," + initFromMxNode + ")");
        BladeIMELogger.log("DeviceManager.getOLEnclosure.m_deviceClasses " + this.m_deviceClasses);
        this.loadProperty();
        OLEnclosure olEnclosure = null;
        try {
            olEnclosure = (OLEnclosure)this.getDevice(enclosureMxNode, initFromMxNode);
        }
        catch (ClassCastException e) {
            throw new OAException(e, "Unable to get OL Enclosure object " + e);
        }
        return olEnclosure;
    }

    private void loadProperty() throws OAException {
        BladeIMELogger.log("DeviceManager.loadProperty()");
        if (this.m_deviceClasses == null) {
            this.m_deviceClasses = new Properties();
            try {
                this.m_deviceClasses.load(this.getClass().getResourceAsStream("device.properties"));
            }
            catch (IOException e) {
                BladeIMELogger.log(e, "Unable to load the device.properties file. DeviceManager.loadProperty.IOException " + e);
                throw new OAException(e, "Unable to load the device.properties file");
            }
        }
    }

    private Object getDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        BladeIMELogger.log("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        String deviceType = deviceMxNode.getDeviceType();
        BladeIMELogger.log("DeviceManager.getDevice.deviceType " + deviceType);
        String className = (String)this.m_deviceClasses.get(deviceType);
        BladeIMELogger.log("DeviceManager.getDevice.className " + className);
        if (className == null) {
            BladeIMELogger.log("Unable to find class name for device type. DeviceManager.getDevice class name" + className);
            throw new OAException("Unable to find class name for device type " + deviceType);
        }
        String uniqueIdentifier = deviceMxNode.getAgentUUID();
        if (uniqueIdentifier == null || uniqueIdentifier.trim().length() == 0) {
            uniqueIdentifier = deviceMxNode.getSerialNumber();
        }
        BladeIMELogger.log("DeviceManager.getDevice.uniqueIdentifier " + uniqueIdentifier);
        Object object = null;
        try {
            Class<?> classObj = Class.forName(className);
            Constructor<?> constructor = classObj.getConstructor(MxNode.class, String.class);
            object = constructor.newInstance(initFromMxNode, uniqueIdentifier);
        }
        catch (ClassNotFoundException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.ClassNotFoundException class name" + className);
            throw new OAException(e, "Unable to load class for class name " + className);
        }
        catch (SecurityException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.SecurityException class name" + className);
            throw new OAException(e, "Unable to find constructor for class name" + className);
        }
        catch (NoSuchMethodException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.NoSuchMethodException class name" + className);
            throw new OAException(e, "Unable to find constructor for class name " + className);
        }
        catch (IllegalAccessException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.IllegalAccessException class name" + className);
            throw new OAException(e, "Unable to access method for class name " + className);
        }
        catch (IllegalArgumentException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.IllegalArgumentException class name" + className);
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        catch (InstantiationException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.InstantiationException class name" + className);
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        catch (InvocationTargetException e) {
            BladeIMELogger.log(e, "DeviceManager.getDevice.InvocationTargetException class name" + className);
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        return object;
    }
}

