/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.Invoker;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYINFOType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYOCCUPANTType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.SWITCHPortMap;
import com.hp.mx.portal.OAXml.OAXmlJaxb.SWITCHType;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.OAXml.OLSwitchPortMap;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OLSwitch
extends OLDevice {
    private String mgmtURL;
    private String fabricType;
    private String fault;
    private OLSwitchPortMap olSwitchPortMap = new OLSwitchPortMap();
    private final String[] SWITCHCLIENTATTRIBUTES = new String[]{"SW_MGMTURL_", "SW_FABTYPE_", "SW_FLT_"};

    public OLSwitch(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        BladeIMELogger.log("OLSwitch(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
        this.mgmtURL = initFromMxNode.getClientAttribute(this.SWITCHCLIENTATTRIBUTES[0] + this.uniqueIdentifier);
        this.fabricType = initFromMxNode.getClientAttribute(this.SWITCHCLIENTATTRIBUTES[1] + this.uniqueIdentifier);
        this.fault = initFromMxNode.getClientAttribute(this.SWITCHCLIENTATTRIBUTES[2] + this.uniqueIdentifier);
        this.print("OLSwitch DB");
        this.olSwitchPortMap.init(initFromMxNode, this.uniqueIdentifier);
    }

    public OLSwitch(SWITCHType switchType, BAYINFOType bayInfoType) {
        BladeIMELogger.log("OLSwitch(" + switchType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", switchType.getContent(), OLSwitch.class, this);
        this.calculateDirection(2);
        this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
        this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = bayInfoType.getSIDE();
        this.validateAttributes();
        this.initUniqueIdentifier();
        this.print("OLSwitch JAXB");
    }

    public void initializeINFRA2_SWITCHTypeImpl_BAYImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = Integer.parseInt(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
    }

    public void initializeINFRA2_SWITCHTypeImpl_MGMTIPADDRImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = ((SWITCHType.MGMTIPADDR)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_SPNImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_SPNImpl(" + element + ")");
        this.spn = ((SWITCHType.SPN)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_BSNImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BSNImpl(" + element + ")");
        this.bsn = ((SWITCHType.BSN)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_MANUFACTURERImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MANUFACTURERImpl(" + element + ")");
        this.manufacturer = ((SWITCHType.MANUFACTURER)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_STATUSImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_STATUSImpl(" + element + ")");
        this.status = ((SWITCHType.STATUS)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_UIDSTATUSImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_UIDSTATUSImpl(" + element + ")");
        this.uidStatus = ((SWITCHType.UIDSTATUS)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_UUIDImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_UUIDImpl(" + element + ")");
        this.uuid = ((SWITCHType.UUID)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_MGMTURLImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTURLImpl(" + element + ")");
        this.mgmtURL = ((SWITCHType.MGMTURL)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_FABRICTYPEImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FABRICTYPEImpl(" + element + ")");
        this.fabricType = ((SWITCHType.FABRICTYPE)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_FAULTImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FAULTImpl(" + element + ")");
        this.fault = ((SWITCHType.FAULT)element).getValue();
    }

    public void initializeINFRA2_SWITCHTypeImpl_TEMPSImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((SWITCHType.TEMPSType)element).getContent());
    }

    public void initializeINFRA2_SWITCHTypeImpl_FANSImpl(Object element) {
        BladeIMELogger.log("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FANSImpl(" + element + ")");
        SWITCHType.FANSType fansType = (SWITCHType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
    }

    public void initializeINFRA2_SWITCHTypeImpl_PORTMAPImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_SWITCHTypeImpl_PORTMAPImpl(" + element + ")");
        this.olSwitchPortMap.init((SWITCHPortMap)element);
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        super.updateDataOnDevice(deviceMxNode);
        BladeIMELogger.log("OLSwitch.updateDataOnDevice(" + deviceMxNode + ")");
        deviceMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[0] + this.uniqueIdentifier, this.mgmtURL);
        deviceMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[1] + this.uniqueIdentifier, this.fabricType);
        deviceMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[2] + this.uniqueIdentifier, this.fault);
        this.olSwitchPortMap.update(deviceMxNode, this.uniqueIdentifier);
    }

    protected void updateDataOnEnclosure(MxNode enclosureMxNode) {
        super.updateDataOnEnclosure(enclosureMxNode);
        BladeIMELogger.log("OLSwitch.updateDataOnEnclosure(" + enclosureMxNode + ")");
        enclosureMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[0] + this.uniqueIdentifier, this.mgmtURL);
        enclosureMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[1] + this.uniqueIdentifier, this.fabricType);
        enclosureMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[2] + this.uniqueIdentifier, this.fault);
        this.olSwitchPortMap.update(enclosureMxNode, this.uniqueIdentifier);
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        BladeIMELogger.log("OLSwitch.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                BladeIMELogger.log("OLSwitch.update.Cleaning device data from OLSwitch uniqueIdentifier " + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                BladeIMELogger.log("OLSwitch.update.Cleaning done from OLSwitch uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                BladeIMELogger.log("OLSwitch.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLSwitch.update.Exception " + this.uniqueIdentifier);
            }
            try {
                BladeIMELogger.log("OLSwitch.update.updating device data on itself " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLSwitch.update.Exception " + this.uniqueIdentifier);
            }
            OAUtil.commit(deviceMxNode);
        } else {
            try {
                BladeIMELogger.log("OLSwitch.update.Cleaning device data from enclosure uniqueIdentifier " + this.uniqueIdentifier);
                this.cleanDataFromEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLSwitch.update.Exception " + this.uniqueIdentifier);
            }
            try {
                BladeIMELogger.log("OLSwitch.update.updating device data on enclosure node " + this.uniqueIdentifier);
                this.updateDataOnEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLSwitch.update.Exception " + this.uniqueIdentifier);
            }
            OAUtil.commit(enclosureMxNode);
        }
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        super.cleanDataFromDevice(deviceMxNode);
        BladeIMELogger.log("OLSwitch.cleanDataFromDevice(" + deviceMxNode + ")");
        this.olSwitchPortMap.clean(deviceMxNode, this.uniqueIdentifier);
    }

    protected void cleanDataFromEnclosure(MxNode enclosureMxNode) {
        super.cleanDataFromEnclosure(enclosureMxNode);
        BladeIMELogger.log("OLSwitch.cleanDataFromEnclosure(" + enclosureMxNode + ")");
        this.olSwitchPortMap.clean(enclosureMxNode, this.uniqueIdentifier);
    }

    public void move(MxNode toMxNode, MxNode fromMxNode) {
        super.move(toMxNode, fromMxNode);
        BladeIMELogger.log("OLSwitch.move(" + toMxNode + "," + fromMxNode + ")");
        for (int i = 0; i < this.SWITCHCLIENTATTRIBUTES.length; ++i) {
            toMxNode.setClientAttribute(this.SWITCHCLIENTATTRIBUTES[i] + this.uniqueIdentifier, fromMxNode.getClientAttribute(this.SWITCHCLIENTATTRIBUTES[i] + this.uniqueIdentifier));
            fromMxNode.removeClientAttribute(this.SWITCHCLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        this.olSwitchPortMap.move(toMxNode, fromMxNode, this.uniqueIdentifier);
        OAUtil.commit(toMxNode);
        OAUtil.commit(fromMxNode);
    }

    public void remove(MxNode enclosureMxNode) {
        super.remove(enclosureMxNode);
        BladeIMELogger.log("OLSwitch.remove(" + enclosureMxNode + ")");
        for (int i = 0; i < this.SWITCHCLIENTATTRIBUTES.length; ++i) {
            enclosureMxNode.removeClientAttribute(this.SWITCHCLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        OAUtil.commit(enclosureMxNode);
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        return subTypeList;
    }

    public String getDeviceMgmtURL() {
        return this.mgmtURL;
    }

    public String getDeviceFabricType() {
        return this.fabricType;
    }

    public String getDeviceFault() {
        return this.fault;
    }

    public String getDeviceType() {
        return "Switch";
    }

    public OLSwitchPortMap getOLSwitchPortMap() {
        return this.olSwitchPortMap;
    }

    protected void validateAttributes() {
        super.validateAttributes();
        if (this.mgmtURL == null || this.mgmtURL.trim().length() == 0) {
            this.mgmtURL = "";
        }
        if (this.fabricType == null || this.fabricType.trim().length() == 0) {
            this.fabricType = "";
        }
        if (this.fault == null || this.fault.trim().length() == 0) {
            this.fault = "";
        }
    }

    public MxNode getDeviceMxNode() {
        BladeIMELogger.log("OLSwitch.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        try {
            deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
        }
        catch (MxException e) {
            BladeIMELogger.log((Exception)((Object)e), "OLSwitch.getDeviceMxNode.MxException Unable to find Switch MxNode  " + (Object)((Object)e));
            try {
                deviceMxNode = OAUtil.getNodeBySerialNumber(this.bsn);
            }
            catch (OAException oe) {
                BladeIMELogger.log(oe, "OLSwitch.getDeviceMxNode.OAException Unable to find Switch MxNode : " + oe);
            }
        }
        return deviceMxNode;
    }

    public boolean isUniqueIdentifierExists() {
        return this.uuid != null && this.uuid.trim().length() != 0 || this.bsn != null && this.bsn.trim().length() != 0;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLSwitch.mgmtURL " + this.mgmtURL);
        BladeIMELogger.log("OLSwitch.fabricType " + this.fabricType);
        BladeIMELogger.log("OLSwitch.fault " + this.fault);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }
}

