/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.Invoker;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYINFOType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYOCCUPANTType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.ENCLMGRType;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OnboardAdministrator
extends OLDevice {
    private String role;
    private String youAreHere;
    private String fault;
    private String wizardStatus;
    private String fwri;
    private final String[] OACLIENTATTRIBUTES = new String[]{"OA_ROLE_", "OA_HERE_", "OA_FLT_", "OA_WIZST_", "OA_FWRI_"};

    public OnboardAdministrator(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        BladeIMELogger.log("OnboardAdministrator(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
        this.role = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[0] + this.uniqueIdentifier);
        this.youAreHere = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[1] + this.uniqueIdentifier);
        this.fault = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[2] + this.uniqueIdentifier);
        this.wizardStatus = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[3] + this.uniqueIdentifier);
        this.fwri = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[4] + this.uniqueIdentifier);
        this.print("OnboardAdministrator DB");
    }

    public OnboardAdministrator(ENCLMGRType enclMgrType, BAYINFOType bayInfoType) {
        BladeIMELogger.log("OnboardAdministrator(" + enclMgrType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", enclMgrType.getContent(), OnboardAdministrator.class, this);
        this.calculateDirection(2);
        this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
        this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = bayInfoType.getSIDE();
        this.validateAttributes();
        this.initUniqueIdentifier();
        this.print("OnboardAdministrator JAXB");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_BAYImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = Integer.parseInt(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_MGMTIPADDRImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = ((ENCLMGRType.MGMTIPADDR)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_SPNImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_SPNImpl(" + element + ")");
        this.spn = ((ENCLMGRType.SPN)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_BSNImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BSNImpl(" + element + ")");
        this.bsn = ((ENCLMGRType.BSN)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_MANUFACTURERImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_MANUFACTURERImpl(" + element + ")");
        this.manufacturer = ((ENCLMGRType.MANUFACTURER)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_STATUSImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_STATUSImpl(" + element + ")");
        this.status = ((ENCLMGRType.STATUS)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_UIDSTATUSImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_UIDSTATUSImpl(" + element + ")");
        this.uidStatus = ((ENCLMGRType.UIDSTATUS)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_UUIDImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_UUIDImpl(" + element + ")");
        this.uuid = ((ENCLMGRType.UUID)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_ROLEImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_ROLEImpl(" + element + ")");
        this.role = ((ENCLMGRType.ROLE)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_YOUAREHEREImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_YOUAREHEREImpl(" + element + ")");
        this.youAreHere = String.valueOf(((ENCLMGRType.YOUAREHERE)element).isValue());
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_FAULTImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FAULTImpl(" + element + ")");
        this.fault = ((ENCLMGRType.FAULT)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_WIZARDSTATUSImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_WIZARDSTATUSImpl(" + element + ")");
        this.wizardStatus = ((ENCLMGRType.WIZARDSTATUS)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_FWRIImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FWRIImpl(" + element + ")");
        this.fwri = ((ENCLMGRType.FWRI)element).getValue();
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_TEMPSImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((ENCLMGRType.TEMPSType)element).getContent());
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_FANSImpl(Object element) {
        BladeIMELogger.log("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FANSImpl(" + element + ")");
        ENCLMGRType.FANSType fansType = (ENCLMGRType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        super.updateDataOnDevice(deviceMxNode);
        BladeIMELogger.log("OnboardAdministrator.updateDataOnDevice(" + deviceMxNode + ")");
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0] + this.uniqueIdentifier, this.role);
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[1] + this.uniqueIdentifier, this.youAreHere);
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[2] + this.uniqueIdentifier, this.fault);
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[3] + this.uniqueIdentifier, this.wizardStatus);
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[4] + this.uniqueIdentifier, this.fwri);
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        BladeIMELogger.log("OnboardAdministrator.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                BladeIMELogger.log("OnboardAdministrator.update.Cleaning device data from itself uniqueIdentifier" + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                BladeIMELogger.log("OnboardAdministrator.update.Cleaning done from OnboardAdministrator uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                BladeIMELogger.log("OnboardAdministrator.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OnboardAdministrator.update.Exception " + this.uniqueIdentifier);
            }
            try {
                BladeIMELogger.log("OnboardAdministrator.update.updating device data on itself " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OnboardAdministrator.update.Exception " + this.uniqueIdentifier);
            }
            OAUtil.commit(deviceMxNode);
        }
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        super.cleanDataFromDevice(deviceMxNode);
        BladeIMELogger.log("OnboardAdministrator.cleanDataFromDevice(" + deviceMxNode + ")");
    }

    public void move(MxNode toMxNode, MxNode fromMxNode) {
        super.move(toMxNode, fromMxNode);
        BladeIMELogger.log("OnboardAdministrator.move(" + toMxNode + "," + fromMxNode + ")");
        for (int i = 0; i < this.OACLIENTATTRIBUTES.length; ++i) {
            toMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[i] + this.uniqueIdentifier, fromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[i] + this.uniqueIdentifier));
            fromMxNode.removeClientAttribute(this.OACLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        OAUtil.commit(toMxNode);
        OAUtil.commit(fromMxNode);
    }

    public void remove(MxNode enclosureMxNode) {
        super.remove(enclosureMxNode);
        BladeIMELogger.log("OnboardAdministrator.remove(" + enclosureMxNode + ")");
        for (int i = 0; i < this.OACLIENTATTRIBUTES.length; ++i) {
            enclosureMxNode.removeClientAttribute(this.OACLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        OAUtil.commit(enclosureMxNode);
    }

    public String getDeviceType() {
        return "MgmtProc";
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString());
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        subTypeList.add("HPProLiant");
        return subTypeList;
    }

    public boolean getIsPrimary() {
        BladeIMELogger.log("OnboardAdministrator.getIsPrimary()");
        return this.role.equalsIgnoreCase("ACTIVE");
    }

    public String getRole() {
        BladeIMELogger.log("OnboardAdministrator.getRole()");
        return this.role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsPrimary(MxNode deviceMxNode, boolean primary) {
        BladeIMELogger.log("OnboardAdministrator.setIsPrimary(" + deviceMxNode + "," + primary + ")");
        MxNode mxNode = deviceMxNode;
        synchronized (mxNode) {
            if (primary) {
                deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0] + this.uniqueIdentifier, "ACTIVE");
            } else {
                deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0] + this.uniqueIdentifier, "STANDBY");
            }
            OAUtil.commit(deviceMxNode);
        }
    }

    public String getYouAreHere() {
        BladeIMELogger.log("OnboardAdministrator.getYouAreHere()");
        return this.youAreHere;
    }

    public String getDeviceFault() {
        BladeIMELogger.log("OnboardAdministrator.getDeviceFault()");
        return this.fault;
    }

    public String getDeviceWizardStatus() {
        BladeIMELogger.log("OnboardAdministrator.getDeviceWizardStatus()");
        return this.wizardStatus;
    }

    public String getFWRI() {
        BladeIMELogger.log("OnboardAdministrator.getFWRI()");
        return this.fwri;
    }

    protected void validateAttributes() {
        super.validateAttributes();
        if (this.role == null || this.role.trim().length() == 0) {
            this.role = "";
        }
        if (this.youAreHere == null || this.youAreHere.trim().length() == 0) {
            this.youAreHere = "";
        }
        if (this.fault == null || this.fault.trim().length() == 0) {
            this.fault = "";
        }
        if (this.wizardStatus == null || this.wizardStatus.trim().length() == 0) {
            this.wizardStatus = "";
        }
        if (this.fwri == null || this.fwri.trim().length() == 0) {
            this.fwri = "";
        }
    }

    public MxNode getDeviceMxNode() {
        BladeIMELogger.log("OnboardAdministrator.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        try {
            deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
        }
        catch (MxException e) {
            BladeIMELogger.log("Unable to find OA MxNode having uuid " + this.uuid);
        }
        return deviceMxNode;
    }

    public boolean isUniqueIdentifierExists() {
        return true;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OnboardAdministrator.role " + this.role);
        BladeIMELogger.log("OnboardAdministrator.youAreHere " + this.youAreHere);
        BladeIMELogger.log("OnboardAdministrator.fault " + this.fault);
        BladeIMELogger.log("OnboardAdministrator.wizardStatus " + this.wizardStatus);
        BladeIMELogger.log("OnboardAdministrator.fwri " + this.fwri);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }
}

