/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.jdom.Element;

public class MxBPVOnboardAdministrator
extends MxBPVElement {
    private MonteroResourceManager manager = MonteroResourceManager.getInstance();
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;
    ObjectFactory m_objFactory = new ObjectFactory();

    public MxBPVOnboardAdministrator(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws NodeAssociationsPersistenceException {
        super(node, parent, loginBean);
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
    }

    public Element renderXML() {
        return null;
    }

    String getDrillDownURL() {
        BladeIMELogger.log("MxBPVOnboardAdministrator.getDrillDownURL()");
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN + "&globalsetting=true";
    }

    public JAXBObject renderJAXBXML() {
        BladeIMELogger.log("MxBPVOnboardAdministrator:renderJAXBXML");
        try {
            OAHelper oaHelper = OAHelper.getOAHelper();
            Device device = this.m_objFactory.createDevice();
            device.setBayType("MgmtProc");
            device.setLocation("Rear");
            OnboardAdministrator oAObj = (OnboardAdministrator)oaHelper.getOLDevice(this.node, this.node);
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device, oAObj);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            BladeIMELogger.log("Device Status:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setUID(deviceStatus);
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            return (JAXBObject)device;
        }
        catch (OAException e) {
            BladeIMELogger.log(e, "OAException in MxBPVOnboardAdministrator:renderJAXBXML");
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOnboardAdministrator:renderJAXBXML");
        }
        return null;
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        BladeIMELogger.log("MxBPVOnboardAdministrator:setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            BladeIMELogger.log("X direction:" + this.numSlotsUsedXDir);
            BladeIMELogger.log("Y Direction:" + this.numSlotsUsedYDir);
            slots.setXDirection(this.numSlotsUsedXDir);
            slots.setYDirection(this.numSlotsUsedYDir);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOnboardAdministrator:setSlotsInfoForDevice");
        }
    }

    private void setCommonInfoForDevice(DeviceType device, OnboardAdministrator oAObj) {
        BladeIMELogger.log("MxBPVOnboardAdministrator.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(this.getDeviceName());
            common.setProduct(this.node.getModel());
            common.setSerialNum(this.node.getSerialNumber());
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL());
            device.setCommon(common);
            device.setIsPrimary("" + oAObj.getIsPrimary());
            device.setFirmware(oAObj.getFWRI());
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOnboardAdministrator:setCommonInfoForDevice");
        }
    }

    private String getDeviceName() {
        String name = this.node.getNameString();
        if (name == null) {
            name = this.node.getWorkingAddress();
        }
        BladeIMELogger.log("MxBPVOnboardAdministrator.getDeviceName returns:" + name);
        return name;
    }
}

