/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.ui.MxLoginBean;
import com.sun.xml.bind.JAXBObject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class MxBPVPowerSupplyEnclosure
extends MxBPVContainer {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private String m_typeOfEnc;

    public MxBPVPowerSupplyEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        this.deviceType = "PowerEnc";
    }

    public void populateAll() throws Exception {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"Start:MxBPVPowerEnclosure.populateAll()");
            m_log.debug((Object)("powerElementObject:" + this));
        }
        MxNode powerEnclNode = this.getNode();
        String prodId = powerEnclNode.getProductId();
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("PowerEnclosure ProductId:" + prodId));
        }
        if (prodId.equalsIgnoreCase("3")) {
            this.m_typeOfEnc = "3U";
        } else if (prodId.equalsIgnoreCase("5")) {
            this.m_typeOfEnc = "1U";
        } else {
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrEncl.Prod_ID")) {
                prodId = powerEnclNode.getClientAttribute("AdviLO.pwrEncl.Prod_ID");
            }
            if (m_log.isDebugEnabled()) {
                m_log.fatal((Object)("Product ID of the power supply enclosure from iLO:" + prodId));
            }
            if (prodId.equalsIgnoreCase("0x0003")) {
                this.m_typeOfEnc = "3U";
            } else if (prodId.equalsIgnoreCase("0x0005")) {
                this.m_typeOfEnc = "1U";
            } else {
                this.m_typeOfEnc = "3U";
                if (m_log.isEnabledFor((Priority)Level.FATAL)) {
                    m_log.fatal((Object)"Product ID of the power supply enclosure is not set.");
                    m_log.fatal((Object)("Value given by ILO:" + powerEnclNode.getClientAttribute("AdviLO.pwrEncl.Prod_ID")));
                    m_log.fatal((Object)("Value of prodId:" + prodId));
                    m_log.fatal((Object)("Value of m_typeOfEnc:" + this.m_typeOfEnc));
                }
            }
        }
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("PowerEnclosure ProdId:" + prodId));
            m_log.debug((Object)("PowerEnclosure Type:" + this.m_typeOfEnc));
            m_log.debug((Object)"End:MxBPVPowerEnclosure.populateAll()");
        }
    }

    public Element renderXML() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"MxBPVPowerSupplyEnclosure.renderXML()");
        }
        BPVXML bpvXml = BPVXML.getInstance();
        Element powerSupply = bpvXml.createPowerSupplyEnclosure(this, this.loginBean);
        return powerSupply;
    }

    public String getTypeOfEnclosure() {
        return this.m_typeOfEnc;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }
}

