/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MxBPVTyphoonServerEnclosure
extends MxBPVServerEnclosure {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private final int numSlots = 10;
    private final int firstSlotNumber = 0;

    public MxBPVTyphoonServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getNumSlots() {
        return 10;
    }

    public int getFirstSlotNumber() {
        return 0;
    }

    public void populateAll() throws Exception {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPVTyphoonServerEnclosure.populateAll()");
        }
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.setSize(this.getFirstSlotNumber() + this.getNumSlots());
        int slotNumber = this.getFirstSlotNumber();
        BladeIMELogger.log("Total Number of slots that we will run in a loop:" + this.getFirstSlotNumber() + this.getNumSlots());
        while (slotNumber < this.getFirstSlotNumber() + this.getNumSlots()) {
            BladeIMELogger.log("Current slotNumber/loop:" + slotNumber);
            if (slotNumber == this.getFirstSlotNumber() || slotNumber == this.getFirstSlotNumber() + this.getNumSlots() - 1) {
                BladeIMELogger.log("This is switch slot.:" + slotNumber);
                int pseudoSlot = slotNumber == 0 ? 0 : 9999;
                ArrayList elementList = this.getElementsForSlot(nodeClient, nodeAssociations, pseudoSlot);
                BladeIMELogger.log("The number of devices @ slot number :" + slotNumber + "is:" + elementList.size());
                boolean isDukesSwitch = false;
                if (elementList.size() > 0) {
                    BladeIMELogger.log("Switch present at slotnumber:" + slotNumber);
                    for (int i = 0; i < elementList.size(); ++i) {
                        MxBPVElement element = (MxBPVElement)elementList.get(i);
                        BladeIMELogger.log("Switch Name @ index :" + i + ":" + element.getName());
                        if (!(element instanceof MxBPVSwitch)) continue;
                        String dukesSwitch = element.getNode().getClientAttribute("LOCATION");
                        if (dukesSwitch != null && dukesSwitch.equalsIgnoreCase("RearUpperCube")) {
                            isDukesSwitch = true;
                            BladeIMELogger.log("Dukes switch present:" + element.getName() + "@ slot :" + element.getSlotNumber());
                            MxBPVElement parentElement = element.getParent();
                            if (parentElement != null) {
                                ++parentElement.numDukesSwitches;
                            }
                            if (element.getSlotNumber() == 0) {
                                parentElement.setDukesSlotNumbers(0);
                            } else {
                                parentElement.setDukesSlotNumbers(1);
                            }
                        }
                        this.setSlotNumber(pseudoSlot);
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("MxBPVTyphoonEnclosure.populateAll():pseudoSlot:" + pseudoSlot));
                            log_.debug((Object)("MxBPVTyphoonEnclosure.populateAll():getSlotNumber():" + this.getSlotNumber()));
                        }
                        this.set(slotNumber, element);
                        if (!log_.isEnabledFor((Priority)Level.DEBUG)) continue;
                        log_.debug((Object)("MxBPVTyphoonServerEnclosure.populateAll(): DUKES_ATTRIBUTE:" + dukesSwitch + "SlotNumber:" + slotNumber));
                    }
                } else {
                    BladeIMELogger.log("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)("MxBPVTyphoonEnclosure.populateAll():pseudoSlot:" + pseudoSlot));
                        log_.debug((Object)("MxBPVTyphoonEnclosure.populateAll():getSlotNumber():" + this.getSlotNumber()));
                    }
                    this.set(slotNumber, emptySlot);
                }
                if (isDukesSwitch && elementList.size() == 1) {
                    BladeIMELogger.log("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    this.set(slotNumber, emptySlot);
                }
                ++slotNumber;
                continue;
            }
            MxBPVElement top = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber);
            MxBPVElement bottom = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber + 8);
            if (top != null && bottom != null) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("MxBPVTyphoonServerEnclosure.populateAll(): ****Blade  Name:" + top.getName()));
                }
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("MxBPVTyphoonServerEnclosure.populateAll(): ****Blade Name:" + bottom.getName()));
                }
                this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                ++slotNumber;
                continue;
            }
            if (top != null && bottom == null) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("MxBPVTyphoonServerEnclosure.populateAll(): ****Blade  Name:" + top.getName()));
                }
                if (top.getNumSlotsUsedYDir() == 1) {
                    bottom = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                } else {
                    this.set(slotNumber, top);
                }
                slotNumber += top.getNumSlotsUsedXDir();
                continue;
            }
            if (top == null && bottom != null) {
                top = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                ++slotNumber;
                continue;
            }
            MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(false, slotNumber, 1, 2);
            this.set(slotNumber, emptySlot);
            ++slotNumber;
        }
    }
}

