/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.events;

import com.hp.mx.portal.events.EventException;
import com.hp.mx.portal.events.Events;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.Properties;

class EventManager {
    private Properties m_eventClasses = null;
    private final String EVENTS_PKG = "com.hp.mx.portal.events.";
    private static EventManager eventManager = null;

    private EventManager() {
    }

    static EventManager getEventManager() {
        if (eventManager == null) {
            eventManager = new EventManager();
        }
        return eventManager;
    }

    Events getEventInstance(String eventType) throws EventException {
        BladeIMELogger.log("EventManager.getEventInstance(" + eventType + ")");
        BladeIMELogger.log("EventManager.getEventInstance.m_eventClasses " + this.m_eventClasses);
        if (this.m_eventClasses == null) {
            this.m_eventClasses = new Properties();
        }
        Events eventsObj = (Events)this.m_eventClasses.get(eventType);
        BladeIMELogger.log("EventManager.getEventInstance.eventsObj " + eventsObj);
        if (eventsObj == null) {
            try {
                eventsObj = (Events)Class.forName("com.hp.mx.portal.events." + eventType).newInstance();
                this.m_eventClasses.put(eventType, eventsObj);
            }
            catch (ClassNotFoundException cnfe) {
                BladeIMELogger.log("EventManager.ClassNotFoundException " + cnfe);
                throw new EventException(cnfe, "Unable to get event instance object");
            }
            catch (InstantiationException ie) {
                BladeIMELogger.log("EventManager.InstantiationException " + ie);
                throw new EventException(ie, "Unable to get event instance object");
            }
            catch (IllegalAccessException iae) {
                BladeIMELogger.log("EventManager.IllegalAccessException " + iae);
                throw new EventException(iae, "Unable to get event instance object");
            }
        }
        BladeIMELogger.log("EventManager.getEventInstance.eventsObj " + eventsObj);
        return eventsObj;
    }
}

