/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.events;

import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObjectFactory;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.events.EventException;
import com.hp.mx.portal.events.EventManager;
import com.hp.mx.portal.events.Events;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.List;
import java.util.Vector;

public class EventsBean {
    private CriteriaDataObjectFactory criteriaFactory;
    private MxQueryClient queryClient;
    private EventManager eventManager;
    private String deviceName;
    private String deviceType;
    private List subTypeList;

    public void init(MxNode mxNode, MxLoginBean loginBean) throws EventException {
        BladeIMELogger.log("EventsBean.init(" + mxNode + "," + loginBean + ")");
        this.queryClient = loginBean.getQueryClient();
        try {
            this.criteriaFactory = this.queryClient.getCriteriaFactory();
        }
        catch (MxException e) {
            BladeIMELogger.log((Exception)((Object)e), "EventsBean.init.Unable to get criteriaFactory object " + (Object)((Object)e));
            throw new EventException(e, "Unable to get criteria factory object");
        }
        this.deviceName = mxNode.getNameString();
        this.deviceType = mxNode.getDeviceType();
        this.eventManager = EventManager.getEventManager();
        this.subTypeList = mxNode.getDeviceSubTypes();
        BladeIMELogger.log("EventsBean.init.deviceName " + this.deviceName);
        BladeIMELogger.log("EventsBean.init.deviceType " + this.deviceType);
    }

    public String[][] getBPVEventsList(MxLoginBean loginBean) throws EventException {
        BladeIMELogger.log("EventsBean.getBPVEventsList(" + loginBean + ")");
        String[][] bpvEventCatagories = MonteroResourceManager.getInstance().getBPVEventsCategories(loginBean.getLocale());
        if (this.subTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            bpvEventCatagories = MonteroResourceManager.getInstance().getBPVOverlordEventsCategories(loginBean.getLocale());
        }
        if (bpvEventCatagories == null) {
            BladeIMELogger.log("EventsBean.getBPVEventsQueryIdList.bpvEventCatagories " + bpvEventCatagories);
            throw new EventException("Unable to get events list for BPV");
        }
        return bpvEventCatagories;
    }

    public String getQueryId(String eventType, MxLoginBean loginBean) throws EventException {
        BladeIMELogger.log("EventsBean.getBPVEventsList(" + eventType + "," + loginBean + ")");
        Events eventsObj = this.eventManager.getEventInstance(eventType);
        BladeIMELogger.log("EventsBean.getBPVEventsList. eventsObj class name " + eventsObj.getClass().getName());
        Vector criteriaVector = eventsObj.getCriteriaList(this.criteriaFactory, this.deviceType, this.deviceName);
        return String.valueOf(this.getBPVEventQueryId(criteriaVector, this.queryClient, eventsObj.getEventString(), loginBean));
    }

    private int getBPVEventQueryId(Vector criteriaVector, MxQueryClient queryClient, String queryString, MxLoginBean loginBean) throws EventException {
        BladeIMELogger.log("EventsBean.getBPVEventQueryId(" + criteriaVector + "," + queryClient + "," + queryString);
        int queryId = 0;
        Query query = null;
        try {
            query = queryClient.getQuery(this.deviceName + queryString);
        }
        catch (MxException e) {
            // empty catch block
        }
        BladeIMELogger.log("EventsBean.getBPVEventQueryId.query " + query);
        if (query != null) {
            queryId = query.getQueryId();
        } else {
            try {
                query = new Query(this.deviceName + queryString, "EventViews", criteriaVector);
                query.setDynamic(true);
                queryId = queryClient.addQuery(query, loginBean.getLocale());
            }
            catch (MxException e) {
                BladeIMELogger.log((Exception)((Object)e), "EventsBean.getBPVEventQueryId.Unable to create new query " + (Object)((Object)e));
                throw new EventException(e, "Unable to get new query ID " + (Object)((Object)e));
            }
        }
        BladeIMELogger.log("EventsBean.getBPVEventQueryId.queryId " + queryId);
        return queryId;
    }
}

