/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.iLOXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.iLOXml.ILOICMBConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EnclosureNodeUpdater {
    private static Logger log_ = Logger.getLogger((String)"Montero");

    public static MxNode getServerEnclosureNode(MxNode serverNode) {
        MxNode serverEnclNode = null;
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)(" EnclosureNodeUpdater.getServerEnclosureNode(MxNode" + serverNode.getNameString() + ")"));
        }
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(serverNode.getDeviceKey());
            int enclDevKey = nodeAssociations.getParentDeviceKey();
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Enclosure Device Key:" + enclDevKey));
            }
            if (enclDevKey > 0) {
                serverEnclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("Server Enclosure Name:" + serverEnclNode.getNameString()));
                }
            }
            return serverEnclNode;
        }
        catch (Exception ex) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
            return null;
        }
    }

    public static MxNode getRackNode(MxNode enclNode) {
        MxNode rackNode = null;
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)(" EnclosureNodeUpdater.getRackNode(MxNode" + enclNode.getNameString() + ")"));
        }
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(enclNode.getDeviceKey());
            int rackDevKey = nodeAssociations.getParentDeviceKey();
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("rack Device Key:" + rackDevKey));
            }
            if (rackDevKey > 0) {
                rackNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("Rack Name:" + rackNode.getNameString()));
                }
            }
            return rackNode;
        }
        catch (Exception ex) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
            return null;
        }
    }

    public static ArrayList getPowerEnclosureNode(int enclDeviceKey) {
        ArrayList<MxNode> powerEnclNodes = new ArrayList<MxNode>();
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)(" EnclosureNodeUpdater.getPowerEnclosureNode(int" + enclDeviceKey + ")"));
        }
        MxNode enclNode = null;
        List subTypes = null;
        int deviceKey = -1;
        DeviceAssociationObject device = null;
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(enclDeviceKey);
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Rack Device Key:" + nodeAssociations.getParentDeviceKey()));
            }
            Vector enclKeys = nodeAssociationsManager.getDevicesThatHaveAssociations(nodeAssociations.getParentDeviceKey(), false);
            for (int i = 0; i < enclKeys.size(); ++i) {
                device = (DeviceAssociationObject)enclKeys.get(i);
                deviceKey = device.getDeviceKey();
                if (deviceKey == enclDeviceKey) continue;
                enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                subTypes = enclNode.getDeviceSubTypes();
                for (int j = 0; j < subTypes.size(); ++j) {
                    if (!subTypes.get(j).toString().equals("PowerEnc")) continue;
                    powerEnclNodes.add(enclNode);
                    if (!log_.isEnabledFor((Priority)Level.DEBUG)) continue;
                    log_.debug((Object)("Power Enclosure Name:" + enclNode.getNameString()));
                }
            }
            return powerEnclNodes;
        }
        catch (Exception ex) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
            return null;
        }
    }

    public static boolean isEnclNodeUpdated(MxNode enclNode) {
        String iLOIP;
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("EnclosureNodeUpdater.isEnclNodeUpdated(" + enclNode.getNameString() + ")"));
        }
        if ((iLOIP = enclNode.getSWAttribute("AdviLO.AdvanedILO_IP")) == null) {
            return false;
        }
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("The Enclosure " + enclNode.getNameString() + " is already updated"));
        }
        return true;
    }

    public static void updateEnclNode(MxNode enclNode, ILOICMBConstants iLOConstants, boolean enclType) {
        block16: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("updateEnclNode(MxNode" + enclNode.getNameString() + ",ILOConstants " + iLOConstants + "boolean " + enclType));
            }
            ResourceBundle rb = ResourceBundle.getBundle("com.hp.mx.portal.iLOXml.ProductName");
            try {
                enclNode.setClientAttribute("AdviLO.encl.SerialNo", iLOConstants.encSerialNo);
                enclNode.setClientAttribute("AdviLO.encl.Uuid", iLOConstants.encUUID);
                enclNode.setClientAttribute("AdviLO.encl.FWRI", iLOConstants.encFWRI);
                enclNode.setClientAttribute("AdviLO.encl.HWRI", iLOConstants.encHWRI);
                enclNode.setClientAttribute("AdviLO.encl.MaxNoOfSlots_X", iLOConstants.encMAXNUMBERSLOTSX);
                enclNode.setClientAttribute("AdviLO.encl.MaxNoOfSlots_Y", iLOConstants.encMAXNUMBERSLOTSY);
                enclNode.setClientAttribute("AdviLO.encl.PowerZone", iLOConstants.encPwrZone);
                enclNode.setClientAttribute("AdviLO.encl.UuidStatus", iLOConstants.encUidStatus);
                enclNode.setClientAttribute("AdviLO.encl.Temp", iLOConstants.encTemperature);
                int j = 0;
                if (enclType) {
                    Vector srvComponentsHolder = iLOConstants.srvComponentsHolder;
                    enclNode.setClientAttribute("AdviLO.encl.TypeofEnclosure", "" + iLOConstants.srvComponentsHolder.size());
                    for (int i = 0; i < srvComponentsHolder.size(); ++i) {
                        Vector server = (Vector)srvComponentsHolder.elementAt(i);
                        j = 0;
                        while (j < server.size()) {
                            enclNode.setClientAttribute("AdviLO.server.Loc" + i, server.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.server.FuseA" + i, server.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.server.FuseB" + i, server.elementAt(j++).toString());
                            try {
                                enclNode.setClientAttribute("AdviLO.server.ProdName" + i, rb.getString(server.elementAt(j++).toString()).split(",")[0]);
                            }
                            catch (MissingResourceException ex) {
                                enclNode.setClientAttribute("AdviLO.server.ProdName" + i, " ");
                            }
                        }
                    }
                    Vector netWrkComponentsHolder = iLOConstants.netWrkComponentsHolder;
                    for (int i = 0; i < netWrkComponentsHolder.size(); ++i) {
                        Vector swtch = (Vector)netWrkComponentsHolder.elementAt(i);
                        j = 0;
                        while (j < swtch.size()) {
                            enclNode.setClientAttribute("AdviLO.switch.Loc" + i, swtch.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.switch.FuseA" + i, swtch.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.switch.FuseB" + i, swtch.elementAt(j++).toString());
                            try {
                                enclNode.setClientAttribute("AdviLO.switch.ProdName" + i, rb.getString(swtch.elementAt(j++).toString()).split(",")[1]);
                            }
                            catch (MissingResourceException ex) {
                                enclNode.setClientAttribute("AdviLO.switch.ProdName" + i, " ");
                            }
                        }
                    }
                } else {
                    enclNode.setClientAttribute("AdviLO.pwrEncl.TempA", iLOConstants.pwrEncTemperatureA);
                    enclNode.setClientAttribute("AdviLO.pwrEncl.TempB", iLOConstants.pwrEncTemperatureB);
                    enclNode.setClientAttribute("AdviLO.pwrEncl.LoadBalWire", iLOConstants.pwrEncLoadbalWire);
                    if (iLOConstants.pwrEnclRedundancy != null) {
                        enclNode.setClientAttribute("AdviLO.pwrEncl.PowerRedundancy", iLOConstants.pwrEnclRedundancy);
                    }
                    Vector powerCmpHolder = iLOConstants.pwrComponentsHolder;
                    for (int i = 0; i < powerCmpHolder.size(); ++i) {
                        Vector powerComp = (Vector)powerCmpHolder.elementAt(i);
                        j = 0;
                        while (j < powerComp.size()) {
                            enclNode.setClientAttribute("AdviLO.pwrCmp.Loc" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.FWRI" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.ACInput" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.Current" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.MaxCur" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("IAdviLO.pwrCmp.nputTemp" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.InputTrip" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.InputFail" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.OutputTemp" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.OutputTrip" + i, powerComp.elementAt(j++).toString());
                            enclNode.setClientAttribute("AdviLO.pwrCmp.OutputFail" + i, powerComp.elementAt(j++).toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block16;
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
        }
    }

    public static void display(MxNode enclNode, boolean type) {
        log_.debug((Object)("Serail number:" + enclNode.getClientAttribute("AdviLO.encl.SerialNo")));
        log_.debug((Object)("uuid:" + enclNode.getClientAttribute("AdviLO.encl.Uuid")));
        log_.debug((Object)("Firmware Revision:" + enclNode.getClientAttribute("AdviLO.encl.FWRI")));
        log_.debug((Object)("Hardware Revision:" + enclNode.getClientAttribute("AdviLO.encl.HWRI")));
        log_.debug((Object)("Max_Slots_x:" + enclNode.getClientAttribute("AdviLO.encl.MaxNoOfSlots_X")));
        log_.debug((Object)("Max_Slots_y:" + enclNode.getClientAttribute("AdviLO.encl.MaxNoOfSlots_Y")));
        log_.debug((Object)("Power:" + enclNode.getClientAttribute("AdviLO.encl.PowerZone")));
        log_.debug((Object)("Temperature:" + enclNode.getClientAttribute("AdviLO.encl.Temp")));
        log_.debug((Object)("UID status:" + enclNode.getClientAttribute("AdviLO.encl.UuidStatus")));
        if (type) {
            log_.debug((Object)("NO.of Server Slots:" + enclNode.getClientAttribute("AdviLO.encl.TypeofEnclosure")));
            for (int i = 0; i < Integer.parseInt(enclNode.getClientAttribute("AdviLO.encl.TypeofEnclosure")); ++i) {
                log_.debug((Object)("Location:" + enclNode.getClientAttribute("AdviLO.server.Loc" + i)));
                log_.debug((Object)("FuseA:" + enclNode.getClientAttribute("AdviLO.server.FuseA" + i)));
                log_.debug((Object)("FuseB:" + enclNode.getClientAttribute("AdviLO.server.FuseB" + i)));
                log_.debug((Object)("Prodname:" + enclNode.getClientAttribute("AdviLO.server.ProdName" + i)));
            }
            for (int j = 0; j < 2; ++j) {
                log_.debug((Object)("Location:" + enclNode.getClientAttribute("AdviLO.switch.Loc" + j)));
                log_.debug((Object)("FuseA:" + enclNode.getClientAttribute("AdviLO.switch.FuseA" + j)));
                log_.debug((Object)("FuseB:" + enclNode.getClientAttribute("AdviLO.switch.FuseB" + j)));
                log_.debug((Object)("ProdName:" + enclNode.getClientAttribute("AdviLO.switch.ProdName" + j)));
            }
        } else {
            log_.debug((Object)("TemperatureA:" + enclNode.getClientAttribute("AdviLO.pwrEncl.TempA")));
            log_.debug((Object)("TemperatureB:" + enclNode.getClientAttribute("AdviLO.pwrEncl.TempB")));
            log_.debug((Object)("Load bal wire:" + enclNode.getClientAttribute("AdviLO.pwrEncl.LoadBalWire")));
            log_.debug((Object)("Power Redundancy:" + enclNode.getClientAttribute("AdviLO.pwrEncl.PowerRedundancy")));
            for (int k = 0; k < 6; ++k) {
                log_.debug((Object)("Location:" + enclNode.getClientAttribute("AdviLO.pwrCmp.Loc" + k)));
                log_.debug((Object)("FWRI:" + enclNode.getClientAttribute("AdviLO.pwrCmp.FWRI" + k)));
                log_.debug((Object)("ACINPUT:" + enclNode.getClientAttribute("AdviLO.pwrCmp.ACInput" + k)));
                log_.debug((Object)("ACINPUT:" + enclNode.getClientAttribute("AdviLO.pwrCmp.Current" + k)));
                log_.debug((Object)("Max Cur:" + enclNode.getClientAttribute("AdviLO.pwrCmp.MaxCur" + k)));
                log_.debug((Object)("Input temp:" + enclNode.getClientAttribute("IAdviLO.pwrCmp.nputTemp" + k)));
                log_.debug((Object)("Input tempTrip:" + enclNode.getClientAttribute("AdviLO.pwrCmp.InputTrip" + k)));
                log_.debug((Object)("Input tempFail:" + enclNode.getClientAttribute("AdviLO.pwrCmp.InputFail" + k)));
                log_.debug((Object)("Output Temp:" + enclNode.getClientAttribute("AdviLO.pwrCmp.OutputTemp" + k)));
                log_.debug((Object)("Output trip:" + enclNode.getClientAttribute("AdviLO.pwrCmp.OutputTrip" + k)));
                log_.debug((Object)("Output fail:" + enclNode.getClientAttribute("AdviLO.pwrCmp.OutputFail" + k)));
            }
        }
    }
}

