/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxNodeIsLockedException;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.querymanager.TreeViewDeviceObject;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.html.core.MxButtons;
import com.hp.mx.html.core.MxDefaultTag;
import com.hp.mx.html.core.MxTag;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.MxBPV;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.list.MxSystemsListRenderer;
import com.hp.mx.portal.skin.SkinParser;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BPVSkin {
    private MxBPV m_bpvBean = null;
    private String m_skinXml = null;
    protected int counter = 0;

    public void applySkin(JspWriter writer, String guid, MxLoginBean loginBean, String typeOfView, boolean isExpired) throws BladeSystemException {
        MxNode node = null;
        BladeIMELogger.log("BPVSkin.applySkin(" + writer + "," + guid + "," + loginBean + "," + typeOfView + "," + isExpired + ")");
        try {
            node = loginBean.getNodeClient().getNode(new MxObjectID(new MxGUID(guid)), false);
        }
        catch (MxUndefinedNodeException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxUndefinedNodeException");
            throw new BladeSystemException(e);
        }
        catch (MxNodeIsLockedException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxNodeIsLockedException");
            throw new BladeSystemException(e);
        }
        catch (MxFailedAuthenticationException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxFailedAuthenticationException");
            throw new BladeSystemException(e);
        }
        catch (MxInvalidTransactionException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxInvalidTransactionException");
            throw new BladeSystemException(e);
        }
        String deviceType = node.getDeviceType();
        String deviceSubType = "ServerEnc";
        List subTypes = node.getDeviceSubTypes();
        if (subTypes.contains("PowerEnc")) {
            deviceSubType = "PowerEnc";
        }
        SkinParser s = new SkinParser();
        String[][] paramLst = new String[][]{{"deviceSubType", deviceSubType}, {"typeOfDisplay", typeOfView}};
        s.configure(deviceType, paramLst);
        if (isExpired || this.m_skinXml == null || this.m_skinXml.length() == 0) {
            this.refreshBPV(guid, loginBean);
        }
        s.parseXML(this.m_skinXml, writer);
    }

    private void refreshBPV(String guid, MxLoginBean loginBean) throws BladeSystemException {
        BladeIMELogger.log("BPVSkin.refreshBPV(" + guid + "," + loginBean + ")");
        this.m_bpvBean = new MxBPV();
        this.m_bpvBean.initialize(guid, loginBean);
        this.m_skinXml = this.m_bpvBean.getXML();
    }

    public void addSystemsListButtons(MxSystemsListRenderer listRenderer, JspWriter out) throws IOException {
        BladeIMELogger.log("BPVSkin:Skin.dumpSystemsListButtons()");
        if (listRenderer.m_bSuppressSaveAs && listRenderer.m_bSuppressInteractionButtons) {
            return;
        }
        MxButtons buttons = new MxButtons();
        buttons.setPadding(new int[]{6, 6, 6, 6});
        buttons.clearMxTags();
        buttons.setId("ID_BOTTOM_BUTTON_ROW");
        if (!listRenderer.m_bSuppressSaveAs) {
            this.addMxTag("ID_SAVE_AS_BUTTON", listRenderer.m_ResourceBean.get("SaveSelectionAs"), "saveSelectionButtonClicked()", "true", buttons);
        }
        if (!listRenderer.m_bSuppressInteractionButtons) {
            if (listRenderer.m_bHasDeletePriv) {
                this.addMxTag("ID_DELETE_BUTTON", listRenderer.m_ResourceBean.get("Delete"), "deleteButtonClicked()", "true", buttons);
            }
            this.addMxTag("ID_PRINT_BUTTON", listRenderer.m_ResourceBean.get("Print"), "printButtonClicked()", "false", buttons);
        }
        buttons.dumpButtons((Writer)out);
    }

    public void dumpIframes(MxSystemsListRenderer listRenderer, JspWriter out) throws IOException {
        out.print("<iframe id='resultSpace' name='resultSpace' ");
        out.println("src='/ui/jsp/EmptyFrame.jsp' width='100%' height='0' frameborder='0'></iframe>");
        out.print("<iframe id='ID_TABLE_ACTION_IFRAME' name='ID_TABLE_ACTION_IFRAME' ");
        out.print("style='position:relative; visibility:hidden; width:0; height:0' ");
        out.print("src='MxBlank.html'></iframe>");
    }

    public void addMxTag(String id, String label, String URL2, String disabled, MxButtons buttons) {
        MxDefaultTag btnTag = new MxDefaultTag(id, label, URL2);
        btnTag.setAttr("disabled", (Object)disabled);
        buttons.addMxTag((MxTag)btnTag);
    }

    public int displayNodeByQuery(MxLoginBean loginBean, String QueryName, JspWriter out, String typeOfDisplay) throws Exception {
        BladeIMELogger.log("BPVSkin : displayNodeByQuery for Query :" + QueryName);
        MxQueryClient qClient = loginBean.getQueryClient();
        DefaultMutableTreeNode queryTreeRoot = null;
        MxNodeClient nodeClient = loginBean.getNodeClient();
        String deviceType = null;
        this.counter = 0;
        try {
            int m_allDeviceQueryId = qClient.getQuery(QueryName).getQueryId();
            queryTreeRoot = qClient.runQueryWithTreeResults(m_allDeviceQueryId);
            queryTreeRoot.setUserObject(QueryName);
            Enumeration<TreeNode> enumeration = queryTreeRoot.children();
            if (!enumeration.hasMoreElements()) {
                out.print("<br><font color='red'>");
                out.print(MonteroResourceManager.getInstance().getString("EMPTY_COLLECTION", loginBean.getLocale()));
                out.print(".</font>");
            }
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreeViewDeviceObject o = (TreeViewDeviceObject)childTreeNode.getUserObject();
                MxObjectID obId = o.getObjectID();
                int devKey = obId.getKey();
                BladeIMELogger.log("Device found with deviceKey :" + devKey);
                MxNode childNode = nodeClient.getNodeByKey(devKey, false);
                deviceType = childNode.getDeviceType();
                ++this.counter;
                SkinParser s = new SkinParser();
                this.refreshBPV(childNode.getGUID().toString(), loginBean);
                String[][] xslParamLst = new String[][]{{"typeOfDisplay", "bpv"}, {"deviceSubType", childNode.getDeviceSubTypes().toString()}, {"deviceType", deviceType}, {"counter", this.counter + ""}};
                s.configure("zoom", xslParamLst);
                s.parseXML(this.m_skinXml, out);
                this.m_skinXml = null;
                out.print("<p>");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        BladeIMELogger.log("count:" + this.counter);
        return this.counter;
    }
}

