/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.skin.SkinURIResolver;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.jsp.JspWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SkinParser {
    private TransformerHandler m_transformer = null;
    private SAXTransformerFactory m_saxTFactory = null;

    private void initialize() {
        BladeIMELogger.log("Start:SkinParser.intialize()");
        SkinURIResolver uriResolver = new SkinURIResolver();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setURIResolver(uriResolver);
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            this.m_saxTFactory = (SAXTransformerFactory)tFactory;
        }
        BladeIMELogger.log("End:SkinParser.intialize()");
    }

    public void configure(String nameOfXSL, String[][] xslParamLst) throws BladeSystemException {
        BladeIMELogger.log("Start:SkinParser.configure(" + nameOfXSL + "," + xslParamLst + ")");
        try {
            this.initialize();
            this.m_transformer = this.m_saxTFactory.newTransformerHandler(new StreamSource(this.getClass().getResourceAsStream(nameOfXSL + ".xsl")));
            for (int i = 0; i < xslParamLst.length; ++i) {
                BladeIMELogger.log(xslParamLst[i][0] + ":" + xslParamLst[i][1]);
                this.m_transformer.getTransformer().setParameter(xslParamLst[i][0], xslParamLst[i][1]);
            }
        }
        catch (TransformerConfigurationException tcex) {
            BladeIMELogger.log(tcex, "Exception while configuring.");
            throw new BladeSystemException(tcex);
        }
        catch (Exception tcex) {
            BladeIMELogger.log(tcex, "Exception while configuring.");
            throw new BladeSystemException(tcex);
        }
        BladeIMELogger.log("End:SkinParser.configure(" + nameOfXSL + "," + xslParamLst + ")");
    }

    public void configure(String nameOfXSL) throws BladeSystemException {
        BladeIMELogger.log("Start:SkinParser.configure(" + nameOfXSL + ")");
        try {
            this.initialize();
            this.m_transformer = this.m_saxTFactory.newTransformerHandler(new StreamSource(this.getClass().getResourceAsStream(nameOfXSL + ".xsl")));
        }
        catch (TransformerConfigurationException tcex) {
            BladeIMELogger.log(tcex, "Exception while configuring.");
            throw new BladeSystemException(tcex);
        }
        catch (Exception tcex) {
            BladeIMELogger.log(tcex, "Exception while configuring.");
            throw new BladeSystemException(tcex);
        }
        BladeIMELogger.log("End:SkinParser.configure(" + nameOfXSL + ")");
    }

    public void parseXML(String xmlStr, JspWriter writer) throws BladeSystemException {
        BladeIMELogger.log("Start:SkinParser.parseXML(" + xmlStr + "," + writer + ")");
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(this.m_transformer);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.m_transformer);
            Serializer serializer = SerializerFactory.getSerializer((Properties)OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
            serializer.setWriter((Writer)writer);
            this.m_transformer.setResult(new SAXResult(serializer.asContentHandler()));
            if (xmlStr != null) {
                reader.parse(new InputSource(new StringReader(xmlStr)));
            }
        }
        catch (SAXNotRecognizedException e) {
            BladeIMELogger.log(e, "SAXNotReconginized");
            throw new BladeSystemException(e);
        }
        catch (SAXNotSupportedException e) {
            BladeIMELogger.log(e, "SAXNotSupportedException");
            throw new BladeSystemException(e);
        }
        catch (FileNotFoundException e) {
            BladeIMELogger.log(e, "FileNotFoundException");
            throw new BladeSystemException(e);
        }
        catch (SAXException e) {
            BladeIMELogger.log(e, "SAXException");
            throw new BladeSystemException(e);
        }
        catch (IOException e) {
            BladeIMELogger.log(e, "IOException");
            throw new BladeSystemException(e);
        }
        BladeIMELogger.log("End:SkinParser.parseXML(" + xmlStr + "," + writer + ")");
    }
}

