/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.nodesecurity.MxNodeSecurityHandler;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MonteroSNMPUtils {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private MxLoginBean m_loginBean;

    public MonteroSNMPUtils(MxLoginBean loginBean) {
        this.m_loginBean = loginBean;
    }

    public synchronized ArrayList getSNMPData(MxNode deviceObject, String pOid, boolean convert) {
        String status = null;
        try {
            status = deviceObject.getOverallStatus().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> snmpData = new ArrayList<String>();
        if (status != null && !status.equalsIgnoreCase(DeviceStatusType.CRITICAL.toString())) {
            if (!this.checkSNMP(deviceObject)) {
                if (log_.isEnabledFor((Priority)Level.ERROR)) {
                    log_.error((Object)("MonteroSNMPUtils.getSNMPData(" + deviceObject + ", " + pOid + ", " + convert + "): SNMP Not supported , SNMP Data will not be retrieved for this device."));
                }
            } else {
                SnmpRequest snmpReq = new SnmpRequest();
                snmpReq.setDeviceAddress(deviceObject.getWorkingAddress());
                snmpReq.setCommunityName(MxNodeSecurityHandler.getSnmpMonitorCommunityString((MxNode)deviceObject));
                snmpReq.setTimeout("" + deviceObject.getSnmpTimeOut());
                snmpReq.setNumberOfRetries("" + deviceObject.getSnmpRetry());
                SnmpResponseVarBind vb = null;
                snmpReq.setAsn1Numbers(pOid + "[0]");
                while (true) {
                    snmpReq.SnmpGetNext();
                    SnmpResponse curResp = snmpReq.getResponseVarbinds();
                    vb = curResp.findById(0);
                    if (vb == null || vb.isError()) {
                        if (!log_.isEnabledFor((Priority)Level.DEBUG)) break;
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "*End of reading the MIB Tree for the device with IP*:" + deviceObject.getWorkingAddress()));
                        break;
                    }
                    String val = vb.getValue();
                    String oid = vb.getOid();
                    if (!oid.startsWith(pOid)) break;
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "Value from the Tree:" + val));
                    }
                    if (convert) {
                        try {
                            val = Integer.toString(vb.getIntValue());
                        }
                        catch (NumberFormatException numFmtException) {
                            val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                                log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + numFmtException));
                            }
                        }
                        catch (Exception e) {
                            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                                log_.error((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":Exception while retreiving data from SNMP:" + e));
                            }
                            e.printStackTrace();
                        }
                    }
                    if (val == null || val == "" || val.length() == 0) {
                        val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                    }
                    snmpData.add(val.trim());
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "Value from the Tree:" + val));
                    }
                    snmpReq.clearSnmpReqInfo();
                    snmpReq.addSnmpGetVarbind(oid, "0");
                }
            }
        }
        return snmpData;
    }

    private boolean checkSNMP(MxNode deviceObject) {
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        boolean retVal = true;
        if (!snmpEnabled.equals("checked")) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "SNMP is disabled for " + deviceObject.getWorkingAddress()));
            }
            retVal = false;
        }
        if (deviceObject.getWorkingAddress() == null) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "Ipaddress is null for this deviceObject. "));
            }
            retVal = false;
        }
        if (!deviceObject.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "SNMP Protocol not supported by device with IP:" + deviceObject.getWorkingAddress()));
            }
            retVal = false;
        }
        return retVal;
    }
}

