<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

    <!-- -->

    <!-- TODO: Do we need the enclosure number or just the name? -->
    
    <xsl:param name="isAuthenticated" select="'true'" />
    
		<xsl:include href="c-class.xsl" />
		<xsl:include href="p-class.xsl" />

<!--    <xsl:include href="../Forms/EnclosureLogin.xsl" /> -->


    <!-- -->
    
    <xsl:template name="renderBPV">
		<xsl:param name="typeOfView"/>
		<xsl:param name="deviceSubType"/>
		<xsl:param name="encName"/>
		<xsl:param name="enclSerialNum"/>
		<xsl:param name="typeOfDisplay"/>
		<xsl:param name="deviceType"/>
		<!-- Create an table to prefectch the images that are loaded from the javascript,
			  The image will be cached by the browser and will be visible once the image is loaded from 
			 javascript{skin.js}, As the style of the table is set to none the table will not be visible.
		-->
			<table cellpadding="0" cellspacing="0" border="0" id="cachedImages" align="left" style="display:none">
				<tr>
					<td>
							<img>
								<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
							</img>	
							<img>
								<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MAX"/></xsl:attribute>
							</img>	
							<img>
								<xsl:attribute name="src"><xsl:value-of select="$IMAGE_RIGHT"/></xsl:attribute>
							</img>	
							<img>
								<xsl:attribute name="src"><xsl:value-of select="$IMAGE_LEFT"/></xsl:attribute>
							</img>	
					</td>
				</tr>
			</table>
			<table cellpadding="0" cellspacing="0" border="0" id="renderBPV" width="100%" align="left">
				
					<xsl:if test="$typeOfView='EnclosureView'">
						<xsl:attribute name="bgcolor">
							<xsl:text>#CCCCCC</xsl:text>
						</xsl:attribute>
					</xsl:if>	
				<tr>
					<div id="enclTitleBar">
						<td class="subTitle">
						<xsl:if test="$deviceType!='Rack'">   
							<div>
								<xsl:attribute name="class">
									<xsl:choose>
										<xsl:when test="$typeOfView='RackView'">
											<xsl:text>subTitleIcon</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>subTitleIconLeft</xsl:text>
										</xsl:otherwise>	
									</xsl:choose>
								</xsl:attribute>
								<xsl:if test="$typeOfView='RackView'">
								<xsl:choose>
									<xsl:when test="$typeOfDisplay = $BPV">
										<a href="javascript:void(0);">
											<xsl:element name="img">
	<xsl:attribute name="onclick">toggleEnclosureVisible('<xsl:value-of select="$enclSerialNum"/>', this,'<xsl:value-of select="//I18N/L10NMaximize"/>','<xsl:value-of select="//I18N/L10NMinimize"/>');</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NMinimize"/></xsl:attribute>
												<xsl:attribute name="width">11</xsl:attribute>
												<xsl:attribute name="height">11</xsl:attribute>
												<xsl:attribute name="border">0</xsl:attribute>
											</xsl:element>
										</a>
									</xsl:when>
									<xsl:otherwise>
											<img width="11" height ="11" border="0" >
												<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
											</img>
									</xsl:otherwise>
								</xsl:choose>	
							</xsl:if>	
							</div>
							</xsl:if>
							<div style="cursor:default">
								<xsl:variable name="status">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NHealthStatus"/></xsl:with-param>
										</xsl:call-template>
								</xsl:variable>
								<xsl:call-template name="statusIcon">
										<xsl:with-param name="statusCode" select="$status" />
										<xsl:with-param name="titleMsg" select="./@titleStatus" />
								</xsl:call-template>
								
								<img width="5" height="1px">
									<xsl:attribute name="src">
										<xsl:value-of select="$ONE_GRAY"/>
									</xsl:attribute>
								</img>	
								
								<font color="white">
									<xsl:value-of select="$encName" />
								</font>
							</div>
						</td>
					</div>	
				</tr>
				<tr>
					<td>
						<xsl:element name="div">
							<xsl:attribute name="style">padding:10px;border:1px solid #000000;</xsl:attribute>
								<xsl:element name="div">
									<xsl:attribute name="id">
											<xsl:value-of select="$enclSerialNum"/>
									</xsl:attribute>
									<xsl:choose>
									   <xsl:when test="$typeOfView='RackView'">
											<xsl:call-template name="renderRack" >
												<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
												<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
												<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											</xsl:call-template>	
										</xsl:when>
										<xsl:otherwise>
											 <xsl:call-template name="renderEnclosure">
												<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
												<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
												<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											</xsl:call-template>	
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:element>	
					</td>
				</tr>
			</table>			
		</xsl:template>
  
    <xsl:template name="renderRack">
	<xsl:param name="enclSerialNum"/>
	<xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay"/>
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<!-- Front view cell -->
							<td width="26%" valign="top">
								<xsl:value-of select="//I18N/L10NFrontView "/>
									 <xsl:choose>
										<xsl:when test="$deviceSubType=$ServerEnc">
										   <xsl:call-template name="cClassEnclFrontView">
												<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
												<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											 </xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
										<xsl:call-template name="powerEnclFrontView">					
											<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
										</xsl:call-template>	
									</xsl:otherwise>
								</xsl:choose>		
							</td>
							<!--Seperator-->
							<td valign="top">
								<img width="10" >
									<xsl:attribute name="src">
										<xsl:value-of select="$ONE_WHITE"/>
									</xsl:attribute>
								</img>	
							</td>
							<!-- Rear view cell -->
							<td width="26%" valign="top">
								<xsl:value-of select="//I18N/L10NRearView "/>                
									 <xsl:choose>
										<xsl:when test="$deviceSubType=$ServerEnc">
											  <xsl:choose>
												<xsl:when test="./@type=$C_CLASS">
												   <xsl:call-template name="OvrlrdEnclRearView">
														<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
														<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
													</xsl:call-template>
												</xsl:when>	
												<xsl:otherwise>
												   <xsl:call-template name="renderPEClassEnclRearView">
														<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
														<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
													</xsl:call-template>
												</xsl:otherwise>
											 </xsl:choose>	
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="powerEnclRearView">					
												<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
											</xsl:call-template>	
										</xsl:otherwise>
									</xsl:choose>	
							</td> 
						   <!--Seperator-->                
							<td>
								<img width="10">
									<xsl:attribute name="src">
										<xsl:value-of select="$ONE_WHITE"/>
									</xsl:attribute>
								</img>	
							</td>
							<!-- System information cell -->
							<td  valign="top">
								<xsl:call-template name="displaySystemInfo">		
									<xsl:with-param name="enclSerialNum" select="$enclSerialNum"/>
									<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								</xsl:call-template>	
							</td>
						</tr>
					</table>
    </xsl:template>

    <xsl:template name="renderEnclosure">
	<xsl:param name="enclSerialNum"/>
	<xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay"/>
        <table border="0" cellpadding="0" cellspacing="0" id="renderEnclosure" >
			<xsl:if test="$deviceSubType=$ServerEnc">
				<!-- Select Checkboxes cell-->
				<tr>
					<td>
						<div id="checkBoxEncl">
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<xsl:call-template name="drawCheckBox">
										<xsl:with-param name="checkBoxName" select="//I18N/L10NAllBlades"/>
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
										<xsl:with-param name="checkBoxId" select="'All Blades'"/>
									</xsl:call-template>
								</tr>
								<xsl:if test="./@type=$E_CLASS   and   number(./@firmwareRev) &gt;= number($ECLASS_ENCL_FRMREV)">
								<tr>
									<xsl:call-template name="drawCheckBox">
										<xsl:with-param name="checkBoxName" select="//I18N/L10NAllInterconnectSwitches"/>
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
										<xsl:with-param name="checkBoxId" select="'All Switches'"/>
									</xsl:call-template>
								</tr>
								</xsl:if>
								<xsl:if test="./@type=$P_CLASS or ./@type=$C_CLASS">
								<tr>
									<xsl:call-template name="drawCheckBox">
										<xsl:with-param name="checkBoxName" select="//I18N/L10NAllInterconnectSwitches"/>
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
										<xsl:with-param name="checkBoxId" select="'All Switches'"/>
									</xsl:call-template>
								</tr>
								</xsl:if>
								<xsl:if test="./@type=$C_CLASS">
								<tr>
									<xsl:call-template name="drawCheckBox">
										<xsl:with-param name="checkBoxName" select="//I18N/L10NAllEMs"/>
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
										<xsl:with-param name="checkBoxId" select="'All EMs'"/>
									</xsl:call-template>
								</tr>
								</xsl:if>
							</table>
						</div>	
					</td>	
				</tr>
			</xsl:if>	
			<tr>
                <!-- Front view cell -->
                <td width="33%" valign="top">
                <xsl:value-of select="//I18N/L10NFrontView "/>
						 <xsl:choose>
							<xsl:when test="$deviceSubType=$ServerEnc">
							   <xsl:call-template name="cClassEnclFrontView">
									<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
									<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								 </xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
							<xsl:call-template name="powerEnclFrontView">					
								<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
							</xsl:call-template>	
						</xsl:otherwise>
					</xsl:choose>					 
                </td>
              </tr>
              <tr>
				 <td valign="top">
                    <img width="10">
                    <xsl:attribute name="src">
						<xsl:value-of select="$ONE_EMPTY"/>
                    </xsl:attribute>
                    </img>
				</td>
				</tr>
                <!-- Rear view cell -->
                <tr>
                <td width="34%" valign="top">
                <xsl:value-of select="//I18N/L10NRearView "/>
					 <xsl:choose>
						<xsl:when test="$deviceSubType=$ServerEnc ">
							  <xsl:choose>
								<xsl:when test="./@type=$C_CLASS">
								   <xsl:call-template name="OvrlrdEnclRearView">
										<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
									</xsl:call-template>
								</xsl:when>	
								<xsl:otherwise>
								   <xsl:call-template name="renderPEClassEnclRearView">
										<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
										<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
									</xsl:call-template>
								</xsl:otherwise>
							 </xsl:choose>	
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="powerEnclRearView">					
								<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
							</xsl:call-template>	
						</xsl:otherwise>
					</xsl:choose>	
                </td> 
                </tr>
                <tr>
					<td>
						<img width="10" id="BPV_EMPTY_SPACE" height="1">
						<xsl:attribute name="src">
							<xsl:value-of select="$ONE_EMPTY"/>
						</xsl:attribute>
						</img>
					</td>
				</tr>
        </table>
    </xsl:template>

	<xsl:template name="renderAttribute">
	<xsl:param name="typeOfDisplay" />
			<tr>
				<td nowrap="true">
					<xsl:value-of select="./Name" />
				</td>
				<td  nowrap="true">												
					<xsl:choose>
						<xsl:when test="./@displayAsURL='true'">
							<xsl:choose>
								<xsl:when test="$typeOfDisplay = $BPV">
									<xsl:choose>
										<xsl:when test="./@dispInWindow='true'">
												<a href="javascript:void(0);">
														<xsl:attribute name="onclick"><xsl:text>openNewWindow('</xsl:text><xsl:value-of select="./@URL" /><xsl:text>')</xsl:text></xsl:attribute>		
														<xsl:value-of select="./Value" />	
												</a>
										</xsl:when>
										<xsl:otherwise>
											<a>
												<xsl:attribute name="href">
													<xsl:value-of select="./@URL" />
												</xsl:attribute>
												<xsl:value-of select="./Value" />	
											</a>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>	
								<xsl:otherwise>
									<xsl:value-of select="./Value" />	
								</xsl:otherwise>
							</xsl:choose>	
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="./@displayAsImage='true'">
									<xsl:call-template name="statusIcon">
										<xsl:with-param name="statusCode" select="./Value" />
										<xsl:with-param name="titleMsg" select="../@titleStatus" />
									</xsl:call-template>
									<!-- <xsl:text>&#160;</xsl:text><xsl:value-of select="./Value" /> Display only image of status icon-->
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="./Value" />	
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>	
				</td>
             </tr>
	</xsl:template>
	
	<xsl:template name="displaySystemInfo">
		<xsl:param name="enclSerialNum"/>
		<xsl:param name="typeOfDisplay" />
		
	      <table border="0" cellspacing="0" cellpadding="0" class="pad1x10" id="AttributeTable">
			  <xsl:for-each select="./Attribute[@Section='Power And Thermal' and @isMultiValued='true']">
				  <xsl:attribute name="PowerRedundancyName"><xsl:value-of select="./Name"/></xsl:attribute>
				  <xsl:attribute name="PowerRedundancyValue"><xsl:value-of select="./Value"/></xsl:attribute>
				  <xsl:attribute name="width"><xsl:text>300</xsl:text></xsl:attribute> 
			  </xsl:for-each>
	      
	       <tr>
				<td>
                    <img width="10">
						<xsl:attribute name="src">
							<xsl:value-of select="$ONE_WHITE"/>
						</xsl:attribute>
					</img>	
                </td>
			</tr>
			<!-- Display all the attributes both in "Identification" and "System Status" -->
			  <xsl:for-each select="./Attribute[@Section='General' and @location!='EnclosureView']">
					  <xsl:call-template name="renderAttribute">
						  <xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
					  </xsl:call-template>	  
			  </xsl:for-each>

			  <xsl:for-each select="./Attribute[@Section='Identification' and @location!='EnclosureView']">
					  <xsl:call-template name="renderAttribute">
						  <xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
					  </xsl:call-template>	  
			  </xsl:for-each>
  			  <xsl:for-each select="./Attribute[@Section='System Status'  and @location!='EnclosureView']">
					  <xsl:call-template name="renderAttribute">
						  <xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
					  </xsl:call-template>	  
			  </xsl:for-each>
  			  <xsl:for-each select="./Attribute[@Section='Power And Thermal'  and @location!='EnclosureView']">
					  <xsl:call-template name="renderAttribute">
						  <xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
					  </xsl:call-template>	  
			  </xsl:for-each>
		  </table>
	</xsl:template>

<!--
 Moved to deleted.xsl by deepak 
<xsl:template name="nonAuthenticatedEnclosure">
-->
<!-- Not used need to delete it 
<xsl:template name="computeWidth">
	<xsl:variable name="enclName">
		<xsl:call-template name="getMember">
			<xsl:with-param name="memberName"><xsl:text>Enclosure Name</xsl:text></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="number($WID_SRVENCL)*2 + 90 +string-length($enclName)"/>
</xsl:template>
-->
</xsl:stylesheet>

