
PRODNAME="HP BladeSystem Integrated Management 2.1 SP1"
HPSIMNAME="HP Systems Insight Manager 5.0 with SP5"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool -l f -t BogusToolName"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_52="C.05.00.02.00"


#############################################################
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? = 200 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo ====================================================
echo HP BladeSystem Integrated Management 2.1 with SP1
echo 
echo This product is an enhanced management plug-in for
echo ${HPSIMNAME}.  The installation
echo will stop and restart ${HPSIMNAME}
echo if it is currently running.
echo 
echo Enter "'y'" to continue this installation.
echo ====================================================

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Installation was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made."
    exit 300
fi

# extract the version string from the "mxversion" output
verString="$(echo $simVersion | sed 's/^.*- Linux \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^.*- HP-UX \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^Systems Insight Manager \([^ ]*\).*$/\1/')"
#verString="$(echo $verString | sed 's/.[^.]*.[^.]*$//')"

# Check to see if we can recognize the version of SIM
if [ "$verString" != "$VERSION_52" ]
then 
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
fi

echo
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
wasSIMStarted="FALSE"
GetSIMStatus

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    echo
    echo "Stopping the ${HPSIMNAME} daemons..."
    $MXSTOP  

    # Remember that HP SIM was running so we can restart it at the end
    wasSIMStarted="TRUE"
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo

# install new files
x=$(pwd)
cd ${SIM_LIB}
if [ -e bladeime.jar ]
then 
	mv bladeime.jar ${SIM}/bladeime.bak
	echo "COMPLETED BLADESYSTEM INTERAGTED MANAGER FILES BACKUP"

	if [ -e bladeime.jar ] 
	then
		echo "BACKUP BLADEIME FAILED"
		echo "HOTFIX UPDATE FAILED"
		exit
	else
		cp $x/bladeime.jar .
		echo "COMPLETED BLADESYSTEM INTERAGTED MANAGER HOTFIX COPY"
		echo "STARTING THE HP SIM SERVICE. THIS WOULD TAKE A FEW MINUTES"
		$MXSTART 
		sleep 60s
		echo "HP SIM SERVICE STARTED"
		cd ${SIM_TOOLS}
		if [ -e bladeimeVersion.xml ] 
		then
		  mv bladeimeVersion.xml bladeimeVersion.old
		  cp $x/bladeimeVersion.xml .
		  echo "BLADESYSTEM INTERAGTED MANAGER VERSION FILE COPIED"
		   
		  if [ -e ${SIM_BIN}/mxtool ] 
		  then
		    ${SIM_BIN}/mxtool -r -t "BladeSystem Version"
		    ${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/bladeimeVersion.xml
		    echo "UPDATE COMPLETE. YOU CAN NOW DELETE THE EXTRACTED FOLDER"		
		    
			  else
			    echo "PATH INVALID. CANNOT ADD TOOLS AND RESTART SIM"	
			    echo "HOTFIX UPDATE FAILED"
			    exit			
			  fi	
				  
			else
			  echo "HP BLADESYSTEM VERSION CHANGE FAILED"
	                  echo "HOTFIX UPDATE FAILED"
                          exit
			fi	
		fi	

	else
		echo "SIM PATH ENTERED IN START.BAT IS INVALID"
		echo "HOTFIX UPDATE FAILED"
		exit
	fi
