#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for nc6230 HP Notebook System BIOS (68DTA)  - Linux-Based"
BIOS_VERSION="F.11"
FILENAME="sp33267.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o45  {]3   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    8DTV   BIN  UL44  s4    68DTA   BIN  Wq55  -o4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  .   c             F  /    I  
     &  o  A  )    %  z
  T
  
      U      y      n      n          "    	          ;  "  "  "  "  
"     }   g   '       %  %  )$  $  #  #   u
 u
 u
)  )  )  )  )  U)  8)   u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u

u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u
#C  C  B  B  B  H  H  }H  =F  ,F  E  E  E  Vu
&u
u
u
u
u
u
xu
Nu
0u
u
u
u
u
u
u
pu
Ru
4u
 uS  2S  !S  S  S   `  `  `  `  `  c  nd  d    	u
2u
,u
u
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3Ðj薓ː
  F  F~ F F^9 uvfv')}fvfv)~h	h jMRP詎Vtj
fvvPƏ
h	h jN~RP|Vtj
fvvP虏
 Ð3f>^  tf6^ *f>  tf6 j b荇  V  h j胐h jxh jmh  h jah ~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ÄF^v&v&8 uNV  *=p t -d jHH|f6B jRPjjzRP莈jjRP~jZRPnjJRP^j:RPNj	*RP>j
RP.j
RPjRPj
RPjaT-r - @- (FF9F}-^v&&?-t^F&&?/uF V]=sjxtRP與ja,]tjyURPij`a>V   h	h hn fvxvuj fh  ! hq
h@蝌f6vfh   hq
h@`f| f6vDefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRP蜆j`.]\fh  j X^ ` ^ ujzMRPajX`s>R  t!G  \t( !  9  =  A  E  I jJj1fjއ   ujzRP煃j_
t(b       ؎f&fjxRP蝅j_>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uaH>T  u	>L   >L   >\ u3T Ht	HtHt8j uwjJ9ulj?j.>\ u?T Ht
HtHtHtIjj MȐj?u+jRP跄jT HHtH
>T  t7>N  t0f|A  h|h|j
> tjJRP^>J  t
j H^vt  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uF'~ tfj fj /F   =HtkI-
 -!- - - 
tFf> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj lCd   F >J  t1@Kt B= M- K- '-M- 0- )fjTD>J  tzj "\^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j)}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFPff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPfvFPBfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;Fvfv_WFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPVFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP5
k3ÐSfv
 ÐT  Vfh  P FPcf|K  Fhh|h|jh> t3^ÐFPzBFVh	h FP΁RPhTzh	h fv貁RPhd 8zfvhd y ^Ð  F@Fq
|"~FFhh|h|j辀}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ u*u%f6vfh  f6^ +^= uv&G
 tf6v[놐f6v[?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP荁
fh   vfh`  j f6^ @v>  WV	~ľ" f~ th	h FPw~qFPu3^_h	h hd [vxvtj ff-   fPf6vy
f6vjFPy
f6v|j ff-    fPf6vky
f6vjFPx
f6v{~ uo~|ij ff-  fPf6v)y
uLf6vjFPx
f6v{F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXFPhVf6vX ^_Ð~ fh  h	h hd Yvxvcfp    	prff9psTf6vfh  f6^ wY= Yv&G
 Lfh   f6pfh  `f6^ 
*t"f6v Xfh  `^^_Ðfh   vfh`  j f6^ 
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP~
<F> tjJj1j f6 <~jh	h(      RP}
6 hq
h@     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjk\RPpv  fh  ! hq
h@{j3RPXF  @ +FHuF F^
&@VxR&*RhRj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRPujJ`RPtu3ø VxR&RhRjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hRj
VjRPUFF*;s6PjRPTF*PuVxR&
R뫐VxR&
RhRj
Uj|9RPMrj7u,jCRP1rjD
RP!r>J  thhd jRPYTÐ  [@7fh  hht"jMRPqjNRPqj{RPqfh  UujEF jWRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pu>X X}jKRPh	h> >SjLRPh	hD (S>J  SÐt~ h	h2 RF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPfRj F*PujRPh	hH hhd jRP)Rj[RPjZRPh	hN 	RÐ  4+fh UhhCt"jMURPiojNERPYoj{3RPGofh  ujEF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*PjRPQjF*Pu>X X}jKRPh	h> PjLnRPh	hD P>J  Ð9t~ F 8VxR&
RhRj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RP"PjF*PujRPh	hH hhd j uRPOj[eRPjZ[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ uj#RPMh	hV j!RP{MF*  F vu3%.t(t~ th	hV FPfj"h	hb FPfj#RPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$ARPL0F~  F ohRj
MF  hRj mMFj$;F~VxR& R܊F*PjRPCLf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%{RPK~ u~ tjj[RPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*PjRP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFVxR&
R
hRj
iKF hRj WKFj N*;~VxR& RՐVxR&
RhRj
K~ ujRPJh	hn j!}RPIF*  F u3t~ th	hn FP1cj"h	hz FPcj#$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j$RP)I:EF phRj
IF  hRj IFj$T;F~VxR& R܊F*PjORPHf6^ FP:FF~s#~ t~ uVwR&
Rt~ tFPFPj%RPaH~ u~ tjjRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !j-ރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0,܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvj_ڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7@كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w0؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0D҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &psуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh@htth@hِ = t= ut у>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShAhR*F*PʃuFL| j hAhR jʃ]FUtKjʃhq
hd j hjlfj hG=thAhREtÐhq
hhq
h~&Ð&ÐU~ u hq
hjhHhq
hjh7F  F~ ujFÐF Df>   F{ j h6Chfh  ˃uF  FuF~  ~1 F  Fff   ffffN*+;|;sF*@N*1 Sh6Ch`>  u)ff   ffffN*+ = utj F*Pʃq>X X<fj hF~4F 1 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*1 j h6Ch[>  u+ff   ffffN*+ = uFj F*PɃ2~ fj hF#  fh  Ƀhq
hd fh  uɃt"hq
hhq
h[t"fj hEfj hn#=uhCht!h6Chtjfj hU~ u hq
hjh.hq
hjhF  F~ ujFÐF Df>   F{ j hPFhfh ȃuF  FquF~  ~m1 F  Fff   ffffN*+;|;sF*@N*1 ShPFhF>  u)ff   ffffN*+ = utjF*Pǃq>X X<fj hF~4F 1 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*1 j hPFhEjF*Pƃh~  5fj hF?  fh ƃhq
hd fh ƃt"hq
hhq
hwt"fj hEfj hn?=uh"Fh9t!hPFh(tfj hÃ>J  tj h tt t   1 ~ ujރFÐF Dj ԃud j h*Ih$tF F~s3c F*1 j h*Ih$FPuFA j h*Ih$he>\ utTtMtFj t:h"Fhefj hn=th*Ih$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j h>JhBFPuF<A j h>JhBh/또>\ ut>t7j hj<fj h=th>JhBtÐ  Z1 ~ uj	݃FÐj҃uÐF DTd j h
Kh`tF F~s3Tj F*1 Zj h
Kh`FPuFZA j h
Kh`h/c>\ utTtMtFj1t:h"Fh%fj hn=th
Kh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPHtFPhq
hՃ~ th	hHh	hTFP3h	h FPUFVu3vPfh0  FPLfv4FPhq
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPгtFPhq
hȃ~ th	h`h	hlFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhq
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..bf^gef[UfS..bf^gef[UfS..bf^gfeff[UPfS..bf^Fgef[XUPfS..bf^Fgef[XUfPfS..bf^fFgfef[fX                           UfPS^tf3ffb  f.c.c "  u  $" u [fX 0!<s3P˿q
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666͜P.dظ WeP.dۚi  y>	uXP 
 Pq
 5! %Td!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.{twdydydyH{ wH{H{H{H{TywwH{H{tH{wH{H{wH{H{tRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }(}>}r}}}}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bq
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3q
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![t#%!u
sʻ 

FV]U컱 .8tK
I	]PPR.d؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUq
ء
F
F]XSQRq
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.dۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH&6		VW_^s+_;uX6	&t	;u؅t؅^&t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]          q
              4.68  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) zE  + , B  . / ^H  \ ] I a b I e f J h i K '  q
 `  q
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d						(		b														
	*
	J
	^
	r
	
	
	
	
	
	
	,		B	^		.			n			:	X	r							,
	Z
	
	
	
	
		(	8	                                  E    F    B l bq
      C    D    B l q
      G    H    B l q
      K    L    B l q
      M    N    B l q
      Q    R l q
      P    O n q
      I    J    R l (q
      -     1    + o Fq
      V     S n dq
      *    1    ( o |q
      T    U     W   
X   
S m q
      Z    [    Y l q
      0     1    . o q
      _    ^ m  q
      c     1    a o q
      g     1    e o 6q
      j     1    h o Tq
      q    r    s    t     u     p l rq
               ^e                           _C_FILE_INFO=                                                         q
               
	
\ \                                  [q
  [q
                                                                                                                                                                                                                                                                                                                                                                                                                                             *q
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          @f@f@f@f@f@f@f               (((((                  H                                                                                                                                        "                                                     SdSdSd                  mq
q
q
q
q
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ABSOLUTEByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '       s    POST9  60 J  a 8 O 	 |
 / ` r/
 y ܅ .  a / u ƽ 9 9 F9 9   }  | " ~  `! P" 1# $ 1% & a' V( ) *	+ |, y- ?. g>/ b0 71 2 3 >4 	5 `6 ^7 08 g}9 1: ; 1< = #2> v? 5@ 1A 7bB >bC 1D oE F }G H aI /J aK L /M N  :_ /P Q pR 1S T 2U $V zW X 0Y@Z `[ -}\ a] ^ O_ ` љa ab f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hc [X <t
PW Pkf&E1_X  fPfSfQfRfGenu fnteluxfineIuofPP%=  rYfa2f   uI؀ Uh*jt/f00tf  
 p0fZfYf[f
#PRWfQ
u(5)(t' .?f0@
u߿ h>8ufY_ZXSQW< s۱1
2
 hO3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
X/@
		! &
%
> h}3hnp0 0t  À@ @(r3ѿ.Q#u
..pu9u/RPVFy` u tBk@.	tމ^~u (_t/ t^T65^XfQW~~.  _fPb	&S:P%<r%Lt<
tw
u#ο 	1_^p	9-7WfVu,`#)6S
F f[tҋff^ff[f`~K0fa94 
H0EfVWUG t  f h4%5  fAh6 P)Q4Q9DhC*2rg&>Ut2g&FP{3EXYP/t9X\P_&f3E
X f	]_f^Qf`Sfff A hRA/f;r[F WX6
_\_S W_{#:E rgN
g^Fr
H>> \faa[Wfgf&Ffؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_VU3Ug^5N $E]" h f!X   18] nQRWV^NV vt6Q3OLYlMʫ%O^_Z6QR0  G8 YfWV3f_f$05QrLfPS. ..Fo.  f.tin^K9N~u>m^Qx. e
` SzTVszRB
 ۀR2ۊ~f }p: `Btuf  f..ftff.@# nC
uF8Fuf_tx^ÑJVR.>.s$0v	A.k6...
?
ZIH|Ps2
F0.FPP{2P
N~ t4vf2	f	f 0>FNNI..Ɣ UfVWQhrLS 虿 rDj:f߾ @ Q   gf  P^ g0=j@ H]0:Q]6  
fvh~uF F 7O3p]_YCh^~ r rD(gf 
/  #ƐPfRS ҡN&t=^fvԹ tNh!CHtDs ʆ h/ 3hkĒBFv ~&#3ώ
Pf~fYf   @
>tq  tgfNg A	~t-OF  ΁ ~3
&[b3yuBF t~y2h:Ff3~Zh(FFf;FWu-043  
 ,Qu@(.;.s0 ~ ˁ ;u
t`t@Ѵ `4^rf  _^ZY WQ3.>.2 .ǅ .ƅ ` P@hVR.. .`$S ~3..hu@s ОHZNpZpwFk@"~ 
N~f.=6@.2ɠJ0[t,	u4.Bf<tضf5$< F. 
1^V@~r F F`! FBu~w
`OM~f1ƹQ/ t
fNu
ffs NF^VP"4P*
Q

Vq4F$<u&0&F # ~P$wp` 
?.phpz<uz^`V@g.@..}.g.^V0&0
9t@{-2x@Z2
E ^s[ 65^5#u(:N?t@֐нuP:
t3S9)΁oum8N0_^˓VmuhhP]`g^՝  $Fp|u53u0j !0 `*-fpF(3Fq(SF~Պ^^h<֊FՈF 0aʐ@F f^Vf1u? @QVpZ fz ufZ^Y_oэ@fߋN记 Nw tFt"fX9FvAFH;F`0Zpz`QI> A\f9Fv9fH]!:FF8F{@ uE.!:fI"<`<Af+ ;NsG .@b^3(tf+fD;<
wi
;f0Q~uK_~ tE2pv?.0N	.C@թ	fSVR`~nqTE[1D
KffArRff~Ѐ`˿2fT&f;w
2Z2fPRf@(t#f3رfoP-^ZfffNN 8ss_4
twu+%
u	atf `"]^&^Z`Wf@/P^~ݲ2I$^"8uA.ffFՋoN_Q;WV`vAFfs"~VӲ`R(Alm s~VRfQ{Fu C kv@kFf:bf$$@w
@_frDf` w;=< u    r,.gp$<u r~ s@nvFfYZ4^VW @fǊ~ԕRd
t"tt8׃`,Yflpv }d6SV0޾3; t	 r^[VW@k`#A['S^@*pt@;?v7!dtk~@Пt 1;FtFk^% Bk^b 3҃  V3k`
C*䊁;FuR,30t7
_t-k			# a
@S
+FHu
4uGrvFvVBs0;JVW΂tS5ދ[NuVp _3ҋp_&t@|@1-4F^R>)&lH_8HȠmCHP	뷋A.7YZ T&0V~1\02N~ tKv m_09Fqy@o \$ 
fPQ3I Ff|Pqf
0M SQh.	 \P,Q23QR.. tf.&..`C.8.tѸ62i
GS@0t^`,F  FψFZF⿊Vf vd"  WpqvkFڀЙN tFt'fڪЊҊ젎ҊtъmюЗdЎba2fw>17 / 'S # ъF8F _  N&R" US$S&5T(T,Ui@1!fu4АNrts SQ9FvP G" 3%Խjf. 쟊Ϳ  akN030
t
F%  .L` c>&e%e~ tf7ie`< u
 v@act#3t#ًËȁ w?u !dx  v t'f#~pff³p
=rcEn.
6 H                                                                                                                                                                                                                                                             o  PQRa&h*jc $`Ȱ h[ArZYXSQWa$a$a  h? hn >5_Y[2揺 TCwA6  @A Q C@@ @;uYð!桟$p ߴh)Ē
f`  觖fa7.1o3h >"hOfPfW hf@g&gf& f_fX`[lA1P0tn&2h
*   &  0*@ ؀ N&}uu h23d 

  % )YW}-5"$@#h<ff
% Àtf%fh!_st;&,Ⱥ: @p 3ȰS( @unSh:*hL svø fB й ߳h_ß`)aP hr00} h! t
 aPQ! @ PQ= `t
3f3 @fYX _3ðd`0*d  UP5k8u  ~U  T
F  
Et&؁P7 uM9NwN#uӃ~ t"F= wt%   +w9Xh.S4`.13   !	 3 a `h0WBDt*u Aw6u18tPRfZX;.~f.~ Ap=f` f ?  ƀ4;M1SfQfRf0=  fQ%=uf?a2 ffZfYf[q@SQRfWf_ZP>f@`fVp. f  g&F @ fq$<s
hEV_ n '8PA	<@$f  GfNGjE sFfHf>~@
 F=K'hxM ;s(Ǻ$ fޭ f^fWO߀0$
 $
ذve>./$ w'`$Lo )f_AhDޓY#ghh$cbf`_ Rs0HbEb2ir-
t!s! h.cpf諓rџs Swq
TMefaa	't5<t1if nf(@ 
"@ < V  B<  C< $ #V Q R S_T U UVWX YZ	9VW3 { JFD0G
` jjf鱊v` уtwRFoROiCi_^0   >  A Y T8k?h M e M A@ 9 }Y .   EnSA aǀᡗQg (
 RP n +o{!ro À!Y2 P f9!r68f6l8O  3 pҎ 6`8>xa^.h5SPS $<t4r [*! v؋h93 `u f`4 S  y)6h#%$h۾:y   D 3y 1"ro< t{Fu.2" ~..m p.-r-u. r%@.-&5&D&EN&.Aa
pԯhT 0߿.pve0U/V~^ 
8
3
~3
/^
'.  pvA+/{&@ U$=u&)/f= =u X&9/&7/&5/y
, fgh  0 pqr  <ABCDE xyz{|}   )0]V S#
f m; r&/&/; r
&    <x" /CfX`_Cf  pf5fx&uV3
Ê^P0(.'t%.FuN.PWO. _XpUSW! Q,fv߿ h峖w  ޿R&~22ك!oIN܀3d	^
u
t_NA&>-_[]wf^_ PVR&=;u&&4uo&^P
P<q +&~& 1E&DpSV h@b^[þk=`[W0  <_]`F10=ROM Based Setup  Entering 0> `. u  3> M@t.0>? Suв)!`- W  Y>p I1A	A0> 11>qFr%Mp &0>tFò  腠t
.>~	t.P(*at hdcPXhb<cWF12=Networkrvice BootWake On LANAttemptto %  !̠hؾRt8 0? r	 0A?u ?1	Lq	t iK3tsR QP.?$<0+( ?BB"?! d?s@C	%24ؾN<^
vs /D%[ VRynNkNF N3؁N?	uCFG~N0tGзhջaNpvrh0Z^òP*Notebook hard drive MultiBay"Dock!:b<#b (top)bottom)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!123                         dCmP  	 
@D
6P T r @u-r  pqolectZDeb]  ͹U8 and _mo@=the _highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   VElE(E$P E'F;S A;Zip.F`u h d0ô0.3&tӎ(FB A VN3N؊' tA<v<st1HE& 2آ؍A2dCQ#YAr	 (A P B.DE
*}FE @FE+jjj(Pjߚ:  F ~`DEE z  
  Fa R 2
   t03HE2 F8tFޣhN $ ZҀbqqp URVQo.,.L.T^Y^Z]S,.FE*[ݡQSVW/ s&Q#F.<.-00?00.Yӯ_^[YQrE u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}Ͱw`2҂ Xʱ@
DEEEr
;w2pDEJơ}gFYô.*FE<{u2K߻0OhO?{ hshn7~d hb<u`B J qWo rf.>I5 h.	fgf&G, @ f   PG0f@G,`u
hEtG,f",f_ffyP QW2_Yf= TKSt0fXbco    ? o J     <@  yX r "R@  QPh5@3'g&Fpg&Fg&F"tug&F0a 1 2MJ׎Ǎ~?@rL.̗Jp w̶q  wQw1oJq@̦L 
QɾӫVW0 _^QRVJDT	: r&e^ZYJffL &]LPpрYPJ݈|\DLQH Yr)&}at{JT+ r
W3Js` JSPfSVUfQWٰ& K&C' @C$vBC$PXrx  q#đ# r]".Ptsrg r7 K: k;WQT rQ G1"C""Y_r
E@t:]^f[XQ$C"7u56u!#,WABM  f.MPS [XAu.6Mf$MIDNU.MSfV/Q0/^3U1Ýf^[3u
u nrt!q!} "W3 hqvb 17h{3-5cf_n`= vY OAY aP߰ h*j2$@<@XHPE  PR ZX@ 0.> O t. O.O@rOSQRWh@r_ZOP TC r99 r/ uw t t2@XR1$tutp4Z `2 hh$ f3hci_QZSWQR kuߊʀlPpq4B XZY_f*eu} _lу< @3ɹ2 uhXD#qi)¼ P% = @uX%*4g&@ ZQhfWi	t<f_!Qfpf  g&?t9g`mR%f}<u @!r  f%?fr#   f{@%fQ
<tf  f !pfa QrauZY0rV$fVL/
/ jGP@t


 
"
f^ff? wD Pf+%@
!
|f~L <D	oH3P4r H5 0P@p 2 P`     )Lψ@`@"ܒ  	P  	`ip    [ ( Actf &:0&60@ p 8p 3fU$'BR"}st$ uf*ڀcփ>:0 tuc ~rh^
&C0p@C<thTs}Q0  G01?}b4 Q < t&k0GfO&
3f30 2*f&:0 uf
ffKP0&0&0+fC0` 1fC0pe05Rff 3ffCf[fKfS܃fF0r0а K I+rS/_;Zf5ɰVWϾ u3n_^ 	!BKsV 
R3
t<^f~
w/vU0fkd`dfft@`[`~VQWfv hG-F&1F&p &{ &P&&0&&p & &1^| Uf   rGt >`*:u
P0xhg޲bX`aՊWadf]PRaQ  hgjjj%jG P: 	Pu h%s
v  h۬:5ú   hpЕ֓ 펵( t 	2se f?Y ffff>;Yfhٷ pTgo&; P]ua)f)Pf0g&t` b   ttx3srnfǂB 0EP	~/u ۀ~/?t wa	~;HYtM!6?                                                               ؆TfU.6Y:YWu u[rWJrR-rM:Ytwf0fqPw| @Wb t#r"t} p ; }PJR  ZR f]LCqfUr*6@^  R߄ Z0rG	0KuҰo!!Vg&fFfFf^0e rC\A۹ `3ۿYyg&8E t{EG SBWi[m r}`[>?Yp?tҍtm8lqlZ0h0ҥcʰW rt r
 GC_RZt$֤b$]0WP谠  _W}  sp  ia #`P
߰@S P  	 D v Sذ8 3 e} R	u$#
R'
//QWjuptPX_Yù
 d h9sxus{z
ՏP .<u.uĀ qRRaR22hX< uZ#ȴ$ t	J 緹 U
	a!"9Vff@ƀR`^hgZàhaӫhsr$4/h Kh@kruva { r PQW 0> 3_YX yvhaC=G H>$hlSs	W? Q;Eð   ! $!f` Th*jC@u' tf` h?* hⷩ tff%f
 ffaT0vPcF Xx]`ؾL &>yN&DEP&D >Nu d} j@ tN}
 -Ȁ}	 >N 33SP[tS[a@Q 2[sDy3 t^hhYs
JhOQahLRΈD
ϰ<DuL
p
E$<u D
@13Usd
r=Si&pS]@` uL
 6 6mN u_  (X6g &uhT
	\

u^`   ~D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"& xu	\	PS  { ? 6P'>N_3& ?! W>N	_w[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  m~` hC!r!L	vTt
vw`WU$@t! $<v@a@n3  v
p
u$< t"<u P>ȷX\PRt P:p1thE\!&ķ=0߿ZXx` 22PEǿN&PCt5ǙN=ǉNtOu570: u	At!sy96 u5 .\s
t!\&@q s  `a
׃/_3m rBs{&=  V P;Ou 0< ^  3f4G -Of_  }0 U!    O&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&O/` 2%
<t29o21_kP*迷P*`OHtS@LDhE =_7_D D	 d
z=1;b^tSqrG&}	r??23p4t`hea&ET$a	&M&]aI`~.'`\%# rU V]ϠRǠZW&=w ucF <%KK
hK?,h" mz0e_Wft
q t| tP
@t   U!w#w !#`0|qv	h3 ck.-.MVN@tI! //(rJmk.58v@Pu% @BVB 0hshnaW$
"1D h>
hOCYp@[X_Ë
`PS@E#[X SϲH<vLR
 Z,<u(Rff+.fĤfп,ZJ ?vGu

Ͼ mS1 6у[Qd$ >@aaf3Ґfk!<`e8 ~	4`֎phx73۹ F
t):u%r;gD	&0SN & 	 hN3Ga!3 
3 A  N ڑSټuTu " / [R rOQzF rCxfQ z.<t*U &' t&A+ ι'P~
V~'+QBrAGARkFZPtg rhؐ`	 & YQA?c)[r%ku`% = 0Y1!j T[s`U3N+6 
&EHHqʋwE&E ꑮ, r`^`^hp3{xfkPoWV @쨀u$P<Pt}R5ZDnpO  ZGPZ^10p_WV 0  PhbX@ 0:2*
*2ƀր?!C@E?r@Dt5/00u,u1 
@a

+&C3ɿ23&@]t  %
t&
0  5  Ӱ
"   ( $
u: >Jd!	"	? Aw ^sPRWD&A &]&U
t ˀAi] _ZXr#3һ -wF2C.E/yN#h΃&~_ '߸^ pZ`      0P>u  'Xa 3\ n `asqZf`P[f3f3u 3 Q>M0\:wuBE&8Uu8p]
R +B&U
ZK!ؾasZ6fYB)%q_r h{;	Q(t06
  5Ãhla 8.
<t Z0ێûPpV#
@F^fp  XMED
ByC Iq   hw=yLyUf`` Fwu.p fafSfQf.uf fff#fYf[2VftGf   uIg@f;t&f 	F  %f^`2ۂۈfaf`3pmvmpfaPP3_X.>u , . P	_TACO F>  
!	&? .ujn<F	u fFf.u  uF.uf.>u <E.u@  tuttYputNp  D@SIVfB.f$;VrT%W B!Z\ܐ	i %Qf2$fP'fffgf"{'r. p u%f@c .?ffHpfXfЁdf3̃!u+`s?7I
s*"/S"Vf+f;wfff33RmREuo4+^q4'r44=$.71p6ɐp08333Ҹ  QW>I% _F
3}5u'JE߄#a0 tؿ 1710 't
t} tWM_ } ,   ؉F EF^V/ SV^M ujQ` 0&t Y&  
 < tr&\]p &\U  
&kN!d N
SR[u&	F@& $F^[_F FYbp߀TV'}PVWًذ| 6' N! _^Y[XWfQSng Zfat
  [fY_` t =$PnPu2MtaË6!s } tp( ` j &?&E`?SRU Qj@6^]Z0V` j{ ŌD^XP
~*F
  t# b Q lpF FPq d3d0hXtKu`<Uu߹d `&hc4d & Xtû pw;b% hֳ oPhE{'`X!$!B   °s} O
eh'I   tt 4  hM` tKu& &  
 ` h,s@<t<uuҚ 
0u?z1*`P	hY# XhH< $ P &D[%Öys%aPX'w$# )P)t`($} f.`G  c  D߾m@7 À   ; Z x     0N@`^~#bhiX1fF3.% r 
\0ވBFu~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ.~r@V» 㐂û< f ˾ff @ffRfPf!N@
 ffFf?3fvZfFsfBf〶f1 r?9pf3ɰǿOmfAP  faþfPVa3v޸rF3@X

S,0<	v	,$.[W D`
o
Lb f s  f`Ȁ
TO
T p s 	 
Sf_fp ЎfvﭿYP,} PM:Fp
uf^fNfV_f^pPRp*fV|A6F@20hC@ Ͼ
 ff  fffffXChq p  `90' P9$" 6 a)P*h7P, %ofPRh2R ĺZP  (Q * 4f_f:aD0  f2MMShm   h}>̀ɀhOwhZ?;PSS96@pq$ q!˰Āub!A tðvntGt<1w(<7vPPkEhm3_ P焰&
0
3q 33ҊtW۰/g.&;u;@.ont)@)hPt@؀a`2G@t03@ @u  3[
u9z3Q2,;y8ӉN 

P-j1rX?03Qr ||X@Y4SQo2P5'$a&& &0hXmC hؾu򿣶߰ h
t[  t
嘪v#t̰,5-PXv8v&> 㟸`t߃`_P3 u $h<I4
#RVr  s}( uu2_2hSgu]߸uXP&
wL 2 Q޻ hNu= Dt= tYԀ'
YY.(^Ze[1P #@]U  Pf^ ]  _`rr	 V$(afOLPHp      @6<P0;V(e
ɿu^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z `7              zTtP( % $  rxfL+  ك%rSr$rF!f+Df+\ r*Tr3w r@ .hhfa2 PR3W0 Z@AR `&Fd??uhdP&Xhb r.>.puO 	AїQR.h f3f%_  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF ɿt 若~u빠% 8t
` `uPj ;}
+V 
N JZ=uϿANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              D?`ރ6.u?;v` Ql0 >"h *Y"`"QwLQ0f&YCC`K (   "P3YaPSRP3@mn?[`H4$&%<GPX 	 o} t <BMtf3P2W X` FOr
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@t_S<tO`NBH$u>f=Pۊfg@+rCtq Bt#Bt	ݱs]P0f
aff60rZ r 1Y`W3P[tt_rh`D trr	P}RW Z
xx ؟0P.BB <t BB2J &8   8u!@屋`23Ұ
ShUSt0`́ y aut0i at]U U[aSR  4hk߻
 hSlZ[+`-0PԿ  h9	 hʕ
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0wZhEU2<U|  h]⚨ u
3Ҹ EF)v upQstT 9 
o( Pf. UfQfRfUfVf@Ch: rsNrG 2f. fwf_7f^fq8Yf.>πfHgffgf uYKU q u, P3	fgf CpfIfAgagf.#f9ukpfY'D0    /p ;7hj 8U 9`Q h:ﰱ 6 h߳" {e  OV3@t ue;F] ;
V3"/fUi &g3  f% '"?곗 #WFfF^fañcV ߳p @Z  
^Acrq[3[<   k DTDw R 0o 0 ȳh  n1   l ( ^Pb @0 W HL P`A T W Xb, `
`! p@pؾ0x o A0
|\D`QWhF2]3 3_p 0 PQ= `tq1 @0YX 05SPp
& p  ff& X[@aa"&    ir  v|"}@Q  oJ傸O fQQMhj ./ۀ Ӗ T <t k~ tq.ѣri."D.|u.:DtSIz  wD:r5+^s&v
uAl
c1PQRfWT3^`o
f@XÑ2a`2	  "	f 2f?@0f@R %  3?f3fPaX Ah lVUv  fb #n&f fa dD 	h}zW"ϻ (;sQSf  r`
 t
2fƃd	40q!a
 Q[ffY+˽vf[Wf+_f7 t%ȡ^H+f@`h00Qpg- f@kf`0z q_L2_&UÃ uZ=PrUf%е uCfy*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&ߋ%ٻf2@t
 <t+p g1~f&f   , Xup Lr}3fBt<rfa&'?rf-QЀÉ_xF?<qP
  
"a	Ub	O~p@R2BuIE1ɒcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&ːtg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"[.f+E)^f^uS2u  w & PP0Xt'vt
t@0r % r/o h<>u ohrst-3&>}rqrRPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rou
@ Ѕ&f  ؀>t !$!f$< uRC  
N<2<Ɓ	"3]A'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tȵE$<u&w ï$tRV[L  ߡN L Nڰu û` t  P[2u
@j jiY!(!!2(<!1ʰe$ h5u$0tߥ$ߥ~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h?_DuQ&~% ߃t PީXӹ
 T.:t
 ._
vXP%8Xr6%_ȸfnc4;La    PJNL p      QKOMp @Kt  Jt P(.DGֿH hh  hv~Q h҅ hE Б?E^  ~` f  Cp m& OE 
v %&Mt&:
7&;r"`p${t1TKub 
HM` `(q p" sr#	cp&3a C 	H m]r5r`2gpjh!BvZaVRQShXm4Thأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Pht3UX<?tFhTbUujjjj P: &hb<X[ hcY$vawt = ;t= Dt
hEsp[@WVS$`́$
[?W @n< u"*OؿhNt`-->J=Ot1 0Վ_ tyr_ rh  S^1  0 hL PͲ5[ ?  :N2?Aq%  	
   VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2^2*à
&}v~PuhlaVRPRQ3f 
%*t,AYZXRPSQY[XZh?>tu	pp Є> qQ 5rXYj,:Ϩ t
)֮hF&&  t8t'V u a+&\ nq00r6$^$ Z& &_& ;`Z@ `odde`P`  XSU @>
ڹ 靟 .PB B8uG` A ; 5䋀/)@#BS ˫냑75VŜPX
 a_@A@ B ]C    ÜFtV$%Ȱ%蝊<;weċ X<wM3ɆQ#"XR<  YыƊȊĴ3ЇуE pYE8@C0	 FrWYuF<uz`0Df&	2
jpu7f߻hNePӀk 'B@. ,".  &k !< uf& bÊ$
r wAu%1uhLӲ$ws}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<ҭfIKeff
f;\hZS\f3f3ɹ f C\f0m f+fG\ ! KIu*IآI'3ہEsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3ytvou4PP 6;-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .@\3۸ 2ҹǻ*@GaaÍ6LhVWaL.z_^pk` hΫ"%.h  uP$<Xu/|#sf @  t<   4 r	.$<u
к f3hh. 
d]XiJhT<  tdbw_0s.>{Nfmw thtC	
A!U2 u@> l = ]sc 3Fd@ e f Fc~ce; 4~e uQ@@8 hd`5/
P	3kh%cBFe:Ffu1r,
 h
 Fdt:   	9  <g htQhph`!afy`7UPHh!u;E#f% PCAXt# N h&N r [ f ̾   F^P XSĻ  y ,  o   hbS-[t(t@tW,&j  j,>" '  tht*dúߋG."'**D/.\pEq+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fff`Fup   j(j	R	aURXhc2  pɺ v1 h: Z]þcoRfB`}'r@!  tgRQ Q;YsY2w$
 !u$ d%|Zf`  WWeI航.&]f?  pC`h.
 C u0u.>?ⱴ 1fa
ZURtLUHh}xk:Ym PY8tn(tp ?;C Zi@"ݤgۇ squ4~VfRfQhÊk.0;p^f[B]䱀8" a[YbhY$q _r 6Sj@ 2P sg rGZO5'/UnAW`.uQN$<u:0p r"&  t  ttⱀ tAt $puPq9(
ʐ

 ⧾N`XSQ 3u,S?m[rE	ˡ-Y[C& <ff<q`00x?x00`֫Q~ɬ||	>>.r
 ~ (ЂrLjCXˀ'PVF JmQ<Q7W &TZޣs6B 	 Do  х߅ԅrA yuN! C I_t 0/)0/s#-&@ HqB E :7&!/p`V aUfV3vCDPDQD 7p4?f^]&ÁP]"% J 炪vPduX$dpH:dX`ߏ@ __ .....- "  @f%pй FACSPJ 4DBGP4BHP=  0944 A|!  8  APICZOnK	a	Q
@  		`
  MCFG<	$1P	  S   u@(z@
 2! RSDT(  #	f`h|k4hsif  fgpfp  gfFgf  FPTR ff`WgFpf. p^$f3..f.fgfN}0~$f+@ghCpJ}3ffgf&f.>Pf(.	t~22^u~( N g&F	f P  rgfffff+f+.
M.> gf
$$#D P~Xff-qAFV3g&fFgY[pff=TDSDt3 wSt+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr< uBOЯNRUfQъ̓2 tPxprAr v; tg&P)XfY8]|ЛVfWfV* f& _fP&ؐ@(#f"fP)fȀ$ 4 
Ȱ 
ff	h⓽p (fߡ t  hhfPW EfX3/ tdZ$tc g~ 1p+M
hZ3=a+0Q~;g&h&_g  PSV	 o pYt >Ou	߃C7h? uDb& @ {u  ?D` ^PRW D h> hO?_ZQ4PSWtSfP3h f&L qfsyPBġ`#L fX@`vh4" 03fpep&?  @ 6Ou    DOGOf3{ pGր   U!ߛ   O>O&geE E puMPMLGofEtXAt$Ot3 t)O$fM
rQpmMe&OaxCLU  r. ]hQ(2.~<nim^  Ϳ giøPܳ iWp_f
Phk0kf$tt& tPE'뭿 5(P)io_ԜVΎގe=^ 3f`FF  hu@ }ur h  $g(,0w4'8  n6Ã9FtFfNA9F> hS9ɀuh(fa`
Ew13ɊMh$ӯt

hRp;r#_uac5WF ^h.sBf fN^Nf.96u 6tc rfQPH_urf;^uf;Nt;f[t) p 
tF~߂U_ս MfOV t;6.?.<t1!%+Qhl:,,k  ^_ĸU00 u,h..D+hXك p1_fqtA"   u
ﰙ3   t'0gf< GhEC?G$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR C!LB REFLEX 20!241 PCMCIA&Reflex^ v.2$cr$HP
  ]a@!g&O@ yGgd `P ߳ rLfK slr>G	 .D
A O@.d.D4f_ PQWXʹ  
G.g&:uG Y.5 _YX^Q8t *?F 
;⡤fW
"
Q@
@B=g"
U

f%Qf_t - y2Y``?Pf BaS?zh<Ju=|jh iZu <t rUr  ЎvVrr^~W  2_s
@?D<tJCrE.&=t&؋.߱uV< t ^aLw 
x y z   h:Chb
{  (ZPhpfaPt =u GW    6
wh-f>q tQ.#6fֻְֻ
<t׻{<fhA+p _*XDvSQWȎ迌  <u
 crd~YrS&tM0ʰ tB&=r6.r(|r%t&¿t2_Y[#`
׎Ǎ~^ԃ^֋ڃtU.6̋Nۂ@9a 	9u;.>]  [6 !&2 .>  2@ .ẁ` ́ ŵ W05Ea6.6̃y krr 

rf	B6c	rNb&^at ?(4
y	r "	.
P3b'P@ ; P 6rj&
 v p rTv&㰤rB@r7&}u%&E=uf&EDDpP r0
}r 
t ׃BB
r
 sP '24=@	rl.&:r_ v W Q
rP@ tI	<} 
=@E
tQ&ҳ;3¥?GYۜ׻5h2>QSwVW	'	6	r`(= u< s2.
q	%I@PP  ro.2x0o w	P__^[Y xpC8ؾM tW؎>'>'b?_?
˃S3(OQY2D5 3 3-W,.@|_4,x60 ;^'_^< 
TT~? M,P_`v.̹ } p ,DPfLFs-<t(<#Ȁ0{&Z htL`E^ᥠEPRU32t
t
u
ku
r t!;rՀw/tM>Ɛʇ"SQ X$Y[g>"Q;>0I`u s2a0`ϰ*SQY(E;?!e	w]ZE]f``3r&th(3,֎fvg@qgrgf9tЦa6k2 *0 t?hb}&R1 m@ Vff3`"gfǹ F fh3pf t
` /PS3۹: 8tCq'P qtrX`ňf uPк2PRV
tb.P 	 & &$ЛTОRu	& 8t.PP^ P   0 ? 0    0  { 0  ЗO  dд CRP1    '  ' s 
 / ^ $RN   ]V	bVck@Вs$@G k"$Q OM3	)ا26PS.ؠb޾ӎr\v uTrL.p @q O ^Qmw1́̻ ` 9|5rx36rdxE@&=Wuʳڳzq ׾G޼$וewrWЅ$^8ay̒A̫!ؓV BB
B
mqZpuؑk]dn(uIMQC!.
$fyڌ60ӆΎރ",rWa ZžֈDTr e۾558D
Tb
	ۧ4Rr# t itct  t$z1^0(ffL7	] 	W0!	RLuנS
ۚ۵6@+0P33r8u_QY?_ 0Lr&U_{}eL`
F܊62UO
ދA
s
t0<iu,:#/+]RS֋݈|\DL	z(`at^ ֑Šܙ03A׶LNB&GB
\DLC

 EرCPyX_.@@` $2L1nB0<thE3H8t8u6
uBp & DBlTt
륑zaP 03 r/) r%BB!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ ra ñ  tAc rF n r:i r5&D@u-&a$v޶Q> Yr	2QQ'Y}B@?Aq Br蹐{᤿	 fШ3uf1 @^ `~pPSQWY u  _Y[УPSWQ3  h?SVt
KVt2Y_~
`j Ȩ  H_ h7軩^G`3F% Pf=   u [jg 2b Sjjjj P: {g[ h[buq?j&]$&awt= ;tau= <t/n=ݳ9 eihZt萨&_faо PϾ   t!uu)Ɵ:0҃< uup@ z`3: ȃ! gr DƆ    r% Z@ s-Z   p$WpF_ǀ uu' 3a rhp+ tg	к  .f  뿷fV t R/Y[<Aߋ:ros3hd$# ѻ ѻ= 
ѻ. F  ~f  ] tIe7r=> л3~ .俱@t0(@ MF t w  PN ![F ~ tMг	u?cePf^
SZAt9A f` W f3Q fY@ IL"
 z/2uJp2:!&= t:   r lVQ&U fٳ
u$sY^{DЏ^
%>f"܇	
plq
&:!& :X.؋ IhBB 
D@ (3 ?  A-ޠtsC"uͺs1u[
	q	1D!IFt$a3; 2 + fQB \{	(NffA(@2Bt1Q*r$a$$$
7R< !ZKt'
QVJ f^DUYw $&m++t'H"`X{tWt`: y`s; 6sdWaY_p_pkoc6mooo#odooao
foСVcXQΝa  AUO
 B141XG08 V.1
G09 V3 
BOE HYDISHT14X1B-120

QUANTAPLAYQDޠL205SAMSUNGLTNB-L02
TMP1EA0VOAP4@3O@M4A.FLG07213	~V-AG
CMHF1 /1ECJ|aP12-1QO@VC

              Ȏ؎6r[>`e  >rY w 6`3 =7BA 8u!!u
( H O8u>	3ҋʸh0FPW
 
Wt_   @ك
_X5 
  K    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h@kBt & ^[SO
&h:j" <[U샿VWƿF F@    䙚b F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P: '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 h=\2%PFAx~ t
F`_^Q
h>ss.&uduк   hb,$?wط h0"h #h^*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UֶP)UIQS6(6*`e1E0eEE.U s@ m2a h*4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	?
 QVW?u% p u 4  | = <tڀ ;@C
 )(_^Yq?RWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Z1SAWIpIyI
WROujvzKMJ; DE<@ ;<<݀!<3aRu BMEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fX^@t#IgO GoxnQRpA3ۊ9 r Cs7wB`s@zfDf3ۋfË\` 	
C  S T R U 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.h<2[+V..^̋] zDF. P .φhbXh%؃P4Q  16V  0"Wa X Y #Z  
[a ` ^nBA\a e f']a a _ `gchi!j qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C.=慏/E2VPm?n8o7@W3۸  =_f^߸^6_>QRrPS[Xh;%Ì`fЍvߋh
3     s     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;d   03/30/05@"11/21  kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Zڨ"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 56EFuu!)zүx00OmO}Dxe``
$`$p

xd
xx txDESxxxxgD@.|0}}@ v o :}d`xG*BYE%x}DQ00xtxtyuup)̐;}mQb}ts ,{c,+"(yxkD00 x^Dx_T_xcDxfTPe p# * -a`U2
,^&01I	aTx"B2x3T0//D}p!T_ _ϰ|%0u!	 Tw`#8 )?nh04hq	P	2;G	"!
+u+$4>j~T+}'+p (++@^,p+
 
0%?
3
v7b",`^0/}j+.@ /P2'`" "+7x&x+Fx_`t 7"6}

P} }e	!	  @A
xxt"xd}A}D"* 10}=
0Zw"800x )xi`xj  p 0S+;0/TB+x+¯0*20b 9P4.+ 20A؏+`xNg	+ xTx !
+:DTBKPF  y+ohP>

 C[Tdp+$!#P'+p-` 8X@P` ðÔ2@YD0¯xx7x8r x00!9`6$06 QATH`	p15TnSGp:q@&(ZZ0?/)4p"0X0X# LXޱx,`Uxtx?0x,@pPD0xT?Tx*X-tx+YZ>TxYZL^[LM '	^Gk`k Aux__DND0=9    ݼV>/RgxdpR^	;;TZ3Nh0kQ@*ARx-	+_SRNx*?SMx+` Kw `RS0 
 peQ`
 R_SPP1"̀ 0X_ Ql̀`e GSXWxZAYAXNSXW}XH$0Yip^q}Z1ZTLoZ1ѱ
YZ[Ԑm0c1\\TQ\t
r[	\S2A}@ A}= #-A~^ B~`  5A~_ uuҌВ"4"7x'?D
`X /7d`!7pg33TT?OPC }`07`'`2`=`HpQx] 6uuuuk uu0 uu5O$ƨpN`0T`
010 @@A"| }(x]0R"+,,E+cp
0 +C,,+ +,+x,+00x!,,,++x_,,"-.pT0ӨL72!t
!Mt&Ipd `1g11[tU!Ҍ(0/0mp/l`
/;0d@TyE2AX.-/0" ֥*xc"+xt`
o3x7 x8W7t)}h"[ZYYcbdYZ`\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Gg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J ;@ | @ s   ww ~~ r  "8x4+D T ` sD)YOpx2tx1tI-'%[0' 'xqvv N'xqk[CWxs$% & & #2x1 	ү  ¯0 p%#@K 3$b0#	Mx3C
r beJ"xrOF`V0 p@$" '	x30%0&<T`P$"xs`bfp
0#%""tX.4} 
xs$3z 
`Hpx`p$W$ ysp @@Шxov"x0	D0$$6Ӕ@Txy~D?"04hsxOmx~@ DT 0
9 pcl0B"pxu1xvx}"xux~xvxx}	"xx#xw6Pyywxxf`Ӏpxx`( Quk~B|@
"00"+000u0ޠ u0 
0i !$0<HRTЍ}
0"HwD =1w6/w(!a0"0
	00"d0 $1¯@x1" |u FTp""3453/:-NP"3554!_Q0"0"xoo`xaT`}ܓxnov+r!3}TOp0@0 0 
Q]P:}0 /[P'2)B7Ψ P` Ӏ"78$ "0a T?2u$408S0"{z}yH237C9
u&9 8+
`9709707@2$h'Ô@^0p4
 

`^$Y	0
	@À{0-$`
$`$p!a"V~ K0":0!@À-0
   s	 280"
2xofKp0*2d|p08SH{zy  xpvJ%_`gK8P2 ( 	4 ~[ "
H	534۩5q3`	t%5544r	@ :0	h0"08`		~2A08<K L?r@1 
 !
 +90 B 8, 
j	"Ɠ "!`BQ
p0( 8!~^ 
-NU
]DU 8.
j'	20"G+6,,f-e2pO7)0	LP85p
b3+&K05	c&	0
¢S (":"08<8;pfpO:2"`"/c)[P3
.7=Cxn`qe`?0}Dp~ h,go,"a,a b}iQ "4xMNOpxD Te4`^א}V Vp0
T4d`#@"4#p~}i4xd@3 0
3 #O`3`3$`j$`6$p$u$`>$`${`.3$`qTc$0 DQ{pAh0TxvSKv`}@906$ f`@`Dx@[3c0p	?3]6P C:p 	`r搬?%¯3l`0@
w pTU`xk  Ng) .|Hxv
xD}S%0{P^`
}mT?DtG䀑PtYHTʩI{Sۀ#@`T`Q	067``$pa1e7`tg7r))*)б?'0*a a
Td`x0dp#  xF PTÔP
@)xFt txBBxUNN{}wxJqJp:;<t/?=)x ү!:%$>t=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 ?xv6xV86}'p p 7  %76'7  ""88Ô@ p/pP'  /..d`
&~r7(9TP5O(I 4 Y4iX04/`P453``/`@$pN54:I&Ddu*):P [x 
33oppG+L1>gp1 ? ':P{"T~ o,P2%?T#>d`pxH 8@224P65b3e1@dx>C1/ 
m
@d+0xA%30 B1
@
 `00
TDT@5q0	 3:@a# AP}Rt
} u2P2b퟿tl@
Ȑ.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2*(t1123#.1}@80 $32  a<0 }
1pAR ErpM#"^p  d-|u*x0,u`2:E,]4 2UU.X5-?Y,*& 2732pha,
$+O!% *R5 }
Q'x`S+0	+`3 /-R	++`@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp.w~LDy}?N%@m53.Eop;OCD-}qXċTQQu:93: !p	S31B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_/X6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/;u1
p< u11PW+C{p4z5z5
3z+,yuv {| A, 90 & nPÑkT0 ,	al9pd000 upov6o,/-.rpFB}}0
~P/.-rdct%,f Wu tq70YS 8S;_"W4쑔p0BŐ}BT_0=+_<I?_`$<p:T0Oő78e`pYלBxgSTAx`%daz0  87>P$3kq"W¥A3	``"uqq
r	1Q`{0
+}
9ȷ"rdP9$$P6"{ 2^F}&e
'AChS4Iq}a X@apR`pLxpG3p?u]1$U^#5_`@TU`#v@|T kx{}Pxzp V{xy TxxPUxwQxv0Gxuxmxtxa{xs`xrxqxxpx`{x|Px{`OVxzy@oUxxRxw Gxvxmxup&xtPxsxrxxqxxp"򓂯pxkv0|0,pTxgLү44" .3k0.TkxgQg/_p0ᒝP .^ ##-{---Εi C2%?",u{/212B0T-21Կ^ L-. 'q,Đ/{#ʰ7,T{AO-.`۷pG䔸QN.E.NgJP70p60Y()y70h
P5
PIs|?`d\7]}SPn,rtFar4N:0 `a32%Е
p1
P

Q "u- 09r"l  _},n1vg8V, : A3.02z.pM=1s0D@dT:0u`z^P;DS,c,u.B.` +2 p0Ⱦ`u.Ta1blC
.%TOлQN]03p	 `` 9b Nn $ 9)NӔ@6S ? x?0!  x5Q"0 UQq7prrq?xvWU	(Xu

		0
  `>
7P"q 3z
G1opT+rAL`]>M)60.T`@}w}S?AP33oTBDWD  Axkw6"@tF }C9xVgxFdqҢX`T`mHT
PM>@Cp!3"x*"U\]@0Qqڢ97|F 03tLv`
pUr *J(( (BP_P`k qw0P `	qPa"NO.egB"TOEN Є1nf`<<A<aY?po0:BP e0v!JI$Y:1PJ1,F;KFF	D0c
^"CO`@"HIOv30aA!Idpe`w@0tt A2bIA؏J``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G<"xB!C!A!B/)B*( #NA
OA
MRA
N/I
N+)UD
JaKaIaJ/iJK
I
|cJKLMd`NPT&` v0ouK K@ 
MLtS Q@HKJ}m}t}}{EAMI"H..Bݓ Ô@""7  "xf· 7""TxDTpTo@߀p ?$0+H:D}@>qTTJE}Rp*Ui@@@@@@@q@_@Y@S@M@G@.@???  @BYQJJ" #&dbr! ?t"xbq o "BypD)6	R0R#q*! * 	A]v _:qV`R [V$`RAb $AUӔ@U1OǯU0	xoZÀӒ!}aAU`#`5`2$pCxGD4SS [CxaUUTܓxn& NYq 
xj0x GÔ@π<PTxjB듀Ӕ@`Bzgr
T"  Ptjxf0Pav+xnv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂATUBRBAC@*F?}E#b G$zE0U`Ud`)#uURBDDDD%DOD[DxDDDDDDDDD BEB-:D 0rtRpA$9 pC¿"-`AE
mPT g"@L0M7 Q&T E7@UxZF!R
hrap>@X P`A@8aO0D=Dd
`#p`(`0<`PdP`d`UێU0:NR^qt td	RxtxxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
}%xtx"Ttx!TTTaD	x?D}@xTpT =TT	Tx= Q
@TxDHp?=DDTxkv0}Gt UdQ eV`eTeP}S:"x0xI"xhw/Lg"Bn S?/?@>"A7$tO$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H H+H3H4H#6H+7H38H>9HI:HT;HY<  H^nTG IQ
 I`A 91~5GT& 8 `;cuTuTK0T"$`($`*`-w/Arpu40
T1B P.GQQb U T"VPT$```$$`(`7`F$cpH{[	A^@
:3
2  *}_006 `u#'/A``,`003`G`[$ap]Tp^"T  dpF^0$s  `!DࡌTwwq/>!$ Tp U "$pR`PLfQd`0EQxhQÔ PQGuG٭q@P
qJPxhv@JJJJJJJɦJͧJKKKK$K+K8KLKKKKKKKKKKLLLLL!L,L_  Lf0
`2v"xMNO`uRRRsx`}i,  x  "$"0RZ
R:g$p; P x"} HG*}0~"uS@	0SSST
pTS0OCSz 0P 0@4xathvaQ `kxTxkD0FxǏHxobwx"x@$xx"x`}KW}IF	
Q@PM0""3GxT| } ~ I4Q`*Nf QRR &NfL((sLLMMMMMN
LLMM
MMMNN'N2No=NU.?KqÔ`P/QHg"T? } 00x|e@"QfSQЙJq0pV	@ݰ50T:}uoQ0S n 0q0)	0PS":Cp$p
:!/0Qp,"xdP P0Q0"~}i 0?H#R3AP>2[I1d1d:0MC}E!@JC0 .PPN` 7Q mT0"b`ɑ0N0#0xD Tx0i!1?xxivnT6 AAPB11u32}'  $31T3322@"O%0  "'W "  k p}"/)O\0/ÔЧ/pC0S00O~2%00 "
xp0 "ŢxƠȰ♎2345%߶@"(t?3t 2x325R4U5B 5axQxQD{Qx␖Q  096xSG_nSG }CSAPĲCPQ'QDQ4 RQRRSSS%6x
/0!x
tP/P
0/Px
  x
Q{Px
! %60$t $T &Qxt	}XBxs0xsP2O0 p%@$X4$ÞPxxs=`1 	_21_,,-uP. <Tү$`& p<OX}e @p% IBYx.-,?6	&xxtӔ@v $(xsvysxtP!  P&0 	r6
p`xv 6vxa`ra
qP 0	,xx
xR!x	06SH)_P$3Ӏp 06d2@Sq SxSSSSSTK	T|
  T{pwgD4 D@ @B@"xDbU$P``3@=TOW@"X  ,D "z9Tph`/AE@EW +@@CEtm OJ@p { _33TOB @ /"p<1ß`p}T@`8 -5,, F4S,  S,`xevS, ?%S,,"+,/0-V bUx	]` }2xN JUu0 u1ATxf`-30(Ӕ
P! 23	D3E2MX^SS0S3u2 u42U03U1Np1%1030444 P-5xp7x	410	^p_
55-Ӕ@xA1 w XX60c
`/p00Ӕ@:P0-	`	`VVVVVWFWaW|WWWWWWW$X%X!&X*+X8,XE-  XJ-`:S	XJ!xu/@x;EP^-.^P
/.-0]	
x3Jt?e.pOt e-0`0p	3pQBp"	`{pEx@}}t*p
.!  2#Pt_-Qev`  q} pQ t u vAO}>	}50R)A 0qFp^" 210 ,+"``{Z`PXXXXXXXX	XXYYYYY,Y3YPYY3Y  Y \Y\s  S1
tt)T|#	
Ypt% DoTyQWT0BQ
2:pԳP^`p '#DpPWdЉ]P  rgZ `!L0tGNt(Di4rOBkQ
xﲌ)SP`DQT,T
qMC#_ "gD `E -~ gt .`T/Ӕ@"À--d`"` 
`-[P.t %-Ue.`.6Ô@}aG[OZI[O%^"Xto.`:``F/U.`"U/`"",pa/[`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$U`"xЊ0"5}67 dp77p676@5242'   `" \b28\=\M\+\!'\[/\iI\xJ\K\N\Z\[  x l"xl / "0/ 0opx#1lr^PP q P  *
0k33o%$7`e2pL28640"05.4d	&4
4W vrov"Ô
@"4!b~4$`$`2$`B$`J`[$Wpk [P _0/V_QRc0#D	qv3ڑU4AQ4p-R0q
0!D"""" $P[^D^L^R^X^q^^^^^  _&u2#_)u22b ! o0"tF`Wu2F,!wu2=r(
C]2ۀb(60rW2UDE. u8
Z/0"HQ 
R 0 3A2"0`"x%0QT~t@"ï@P`@[@	T =" Oxmq~ = "ݰpސ}tp0	6~_r!#x0x!TT`D?ƨpT!D`!T1 >AoxDLQp"  :	;
/'
123B=>C	D
WX`~x`!@UP ^`_dI"
%'6xF`7@j0x+ +bxk`yqb;+s+`P`C0/+xT 6D } 20pSn DT_`m 0xTT`P80	61 aS 
0cx	+$```9 Aaxv pz q DxT"ҎxStTTH`g+xS+<x, 6, G`$p#xSx+}	x060/QI

0`Y "P.w@-Ӕ@	}-A-$``
$dp<0/yC.t}.l+ dO`PcDlTI0dPG @a}@aP-Bp}} Y.܀kdQ	oC.	.@;P1~`J$`S`X`]`h$epj..
Cc.!d"dpsqai.0Ӏ\0T: Lxl..T>xf.881.T{P{PӀok7ӛP	 ~0Þ߱d`pWÝ@ӛ@*ÝP:;<u Ft/ށ7tf"ů0@*` 0I"xp,E" 	/01p4u5Pu<$t}5} ʣ/ fe4e^eeņeef
f
f-f-fvfffff֗f֘fggggȠgghhhhhhʨhhiii3i3ixixiiiڷiڸiijjj1j1jTjTjwjwjjjjjj  j~O0* pC3/}u: u; u<3{c4kT13 6b!~1 6` kwR3`uu3pwuu:u;}u<{uxu{]{X$::;o<{&5ՍhgR0  e _'Uh)gU

%-X>*05EE` } P0C3w+1!~ .`| }` @^_N0"`"!"*H
$*
#5'((INp:I?d @(Z
cCt 001{Tq 7'+'U(.))X0U,/,28.U17.4h03g0o.|U1rPAA$__TW&A1 Wu2dG'XAU=9='UXEFxBUwBH˨DDU(KFFSo UHH#Mp6/P!}UBfP"/"U@πu3_//ZC4"$y``Д!SPkqp ? "@A~Kw`jAO$lAa`Pk&A`#`#xt@}}X} Y  ZxqBBxtPBQ0_%70$"Ap
| @"&@-AOr+T  	Y	UZ 	 
[	Bxt
		 ":bx>T=Q
38T_:>?`dPmP?> I IPw0=p@ "08k: ?} P' 8@
఑| $ G>Dh W`֗ld Ep6"}6`~M }`q@4Q km3#@!1fݐ}ϐ0LTTox t
}"D0q[ܒ0}kƿ+ s++.
~M_12Q^H`v
l@&p0ux"q2 
41pmn"14Pnvf1xe 606
 0!ˉh C6'\}pp
T?T`4"4"u2<0m0`~@~^y 0^TODԴ001p322\* u1C0ް0 	3+PtP`7 t2PD2B32Cp7077P !`&R@P
}`@"P3"0u 0T_O"P
0._$  ;q)033+)e0`!0>f1_V҇e1q)0o210pJ ~}c  0`Jgc8 	1Do%J@T1`1:C:p*"45675E4`1546xP
 (4~g77$bTo`M3`TM0=`` `'p-1>TaRr C Dg h0a#CC e/rABÔZ	)u1au0( 2u0	0}}]p2~ Qb|ӝꀣ2u2u0P*< $3@`20C@'a@u'
L`SnV1@\rD^p:p7002`ATTT%%O=XDp=3`"{`@
	0d`0p_18ZQ[t?`<5A?Dp*G3tq~T81*	 "a F@P!/0	<2`dO"F!K"Q$%'Nd%tlݾߪ$	??
($	6
??X(tx75UR}{zy[Uh7vYdh0vY04<t $p_u/'GP~ q./dq5%tZt g~@_Z4rQpu{@ pT0oN`kl<2tZ	ÔPtA}䑖o`!;k~`x45c@2/Gk4373  אwR((swxx'xBxgxyTzz/z{|}d}~,~~~0$Ef	{ z y4lL	g5P4F w
Pg?R$SzR13D,t~5{u4`u5 	]4T`pd`ѫgQ?
p0
CPFtt	բ	u1zLqnblpZ}} pmdgggPK
ß
Np&F0/4Qw&
b67d6ДN6Є7"PnR@Id.+ e5p4l`&kIaT 8)8CH|} `z {pD` @\]L
8t899988ӓ9!Q!d58 9!
0@&2nB0gC' #TĤ[s98&d]픜P610/E
8: F FP2GPzdLp;|t#II<~_~mpl`??c\,@1Ҿ7UdNpt OLVKOKeK7UuNp7>	r^HQo`JapOpNӐVSYSSniA;b/9'P#vZ/i )T2&(?`ik&b m<ѝRo=q>
s?Mn iϕ}lI;DT-Kg098n0,78v3 7w?v%3"27u~}-3APa eÔ|@3$`D ^b c $~ 2u3#ux77pdE`3P0 0a>t8u@Pa~ZPt7p9TT Np: M! A)};4u3
tu
q$
 e3`3s71`041Pwp 1@  Ue ?31eلvAd0V_ɂd1pˑ2\}Pʈt2"u0xY03{}]=%܄Y~RNa:>f2pPu2f	op`8
0)a
``vӕ1)100A1xeT`&$31dtߘP2"u}`q 
 """4}t t P
3U02	~LTD_"LION(RPmp`(PPRx33d_I"_2~ }@P0L V2btjP2߀22  ~]2~QZPSRPS@~Ptu4<P42~&4`âu3QJpTX@P~Uб	@3'~\p~ <@3P \p"00~W H"/0"534u5$*``0$pB/}u:u;~u<V{c4E`]eW{c/]R{=3//u: u; u<3}/r4"/
`  "p	` JWT"/"6LY!? p\!QNVtPO[tq-z P`ppB-ӟ@
-  e-`P  IAptQ{`
Pp-"[VTo3p,PQR[, `"q ̓ ZpsP&p i n&i`\A`ʐT..PTc%,'`-lP_,vt@p,0A6	b"<x9pP
 D?T:p
~"B~ dx!SÀӲ  0d"0Ӏ"7 I8`0@
D bI
~,T e8Gt@Np 21!M
QM"`"x0px 	âiS?N?~ 
0 on`dx"7@0unX`,7`bPPNPN Pnp	84gk8$Br"8ߏ9I;5<u=98~`e9p8lpe;.9E8 `v@@~+P"~U
`qrp$Ȑ]^::Ӕ@:@tx#*	: *q>x@+:Q  =p ; x
$ />e<`rp=5=?@uA5P+F @sx@@p?@?@;A55A@@	x&T 0"%T~ O@8&03@"`@T`B~"x!To`	?TT 68G3o`G2D"C
@Cpx!7 ?4r10*Dϐ~_o`ezS+ `1~uK >dI&<A/t"u;2@F<9@Ju;;;_` F FP P9:9@ɰ56x>EM  >b665þ5P	` 
F~GvB"¯DIfCRN*2_+,U
,,+,+_r&T NFmG	_,xt!`
T0xwqT4TDx!CD@p
0g1dpa3%33p*`3p*a@
4p6U4cv.@'%%q
O =`0l(OTdZV		RT3Yb~^` #A""	F	 >	@2xpdɊ X LҀƀԀin3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#sB"P""):"P?%0 "b``"Τ.` "  )" /33@p " 3@P"Ø"0	Ý0 䞭 `r0"ſ(p p8@
!	P	t	1a
b*q2}	1	"/wt 
""BBE"""ЂP  tsےC6 s)ŃŃ& ";%@$5bpp
s@h`/߱5p5 $5@~5v5@In5 b5V5J5e0151,5 p5p5v5pv5v5q5#s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   [  GN   P DSDTDSDT  vHP  nc6200   MSFT[O"\._PR_C000   1
 O_CST p\/_SB2P345`p
1L`
 678p o\/9O9?Aa{ua0 `a I{ 	B
 p
C
  pp
D  EFsq10C ]G@PP1V WWp11p
Uq2y2y2z2qC11 2D
 D y 

BEG  D
]qFIG_
&
0;}9
d\32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD15phg	gi
 a6g7 phpi p
 fA"'ϓfg`f b 7f cufvbc``A89E
Microsoft Windows ?ME: Millennium Editions NT Cp&AF
3p\_OS_`pga.Sag)`B9ߠ
bra!718ua
 6
 s %[I` 
u	A1h3Q0841A+85_INI AH2C
fpig
f0@i` g@hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\G[K
 :D_HIDAJ	_CRSR E)
&	@M1
  @NN 02
_ C021  +2tD2M20N4C@5py6pB1t$5?EG27% 8 9 A r C"8ۮ([0
D   
,[́D1EF8[
 3031	A
[ہ1 32@33Q 4 5 6A7 _38 39H3A
C@[L3BZ!C"3D'A kEpF_40Q 1`
42 3A4j56 47nA0B 48f49 4ABaCDEjQFPi5k@ 1052Q 3 4  @"55 M,57
@F!hpa47a}aiapa ~ib{abo[[102'
_C _ADR
 [&	8 u_STA0q `=	@9p
1AB5C
T
C[)5C |qr Bo DD0P85Do5DE2qE& @? < A#5F [#C060oK}61Dw`p` p`b`t5DePZe` a}p dpy0cCd{c
z~@u
 bdx66Fbbtd
qpu@2dcrd[5E` dza
ga@b{
N afuff a@Pdu`['A
Ja
P64L

 G
aE7w `EyH d2?y '%6p}
3 3[`60 066pibpkdrd
edA
d hb @brb

bhb7  892ja67S3 8K68crc169BbN0!A!w{ar`j64abP]	bR][]
]
bu]atb
[bP c`^a%
`bac `/$6BSPSK] [64
67 @~69c)!kc6CP=aaqp``\6C@23~_S3D
=p 4D
 f`L6 fS< W

X6EX @4[ p3F [C0{70%@ 
"@`71
K71a@{^.h2BA0FDQ3F@[B:AH c74
`
[T74@75 6 ^7^79AW7AW7C.T7DAG7Pq F g80 Up 18!^8!^84 5A\86F#87w H88 l?89

d19@8Aj8B 
<[=   @CnD 8EkFA9@  g91 9Am09q93`
[0 47	 A95P
aT96  P9	D@98
9$
99AJ9!
!
pW9!
f9C g~0AgqD3E
g[! FA0Q 1 aA3GA4[#\_GL_bp
`{ʔ[!
dv`J`Am1aA2{h ͺjp
ps
Hr ӧ`"a0A3bra[Jp	rya
c}cbaa5 (8` A6x0 wA7Bωhiۢq`y`j0OЧA8
h!4: p3"3+1a(86V1(@pwA9qip@"m8 +FGbA
i7.F5D1&Ӡ$rE2}}jr6[GG@ @:*BAB
@
[+l PAC0ADQ E @$$B0|06B1 CB2
A`qD`C[ix
	0  zo{` `za 0 
bw
t
	rabmC
 11
A )RۊU{0!rv"OL!3
pI6'BB4
y
rmw iPH2AF`!B1a{P ` 
p{z1 wi1{wa` rbB3b yC15	_D`pAFw
h nc }r    AA3
ccF@B6
7l
PB7 !8 ! tP*e {ky
r B7e} e Aj
8a{`Yц0.xq9@p #`b}e
e/rp !`ؽ	e z`e$}`@@dAy4{ks
 	``;}qE
 ЈAwE y~!-Ep?d1p6Cd pAC"D D7e@{BAq0fB D dyce@
QTѢ"Chif"f
j
B@
EbdB	!ba'c@z!Dby
PMT6*CTHPCIBb+(p`Ab	s@bF/cpyacaAFw'B0j`B0b1e  dBb[FBGGGG1@DBEU 7#BF
@BCC1-_PSW12ڡCCYC1 (!`A1[(ІC 4c	C5uVm	Vo	o	o	o	o	o	i	6 Rc	o	o	o	o	o	o	`7u-ҙo	o	o	o	o	o	$N!%[M 9cP#xB#cCC33".
[@   /@C@&P
[5   zDKց 1DD3 OлD4  0D5pD63D7 @~  PD8OT 9@92oQ
 U0D=:
c	A
 d B 0DCDDA!D?*/D(D//.E0 & //e!e!( .G!G!@(C E1N "E2G E2//.3
@ #'3//A eA !A N A  GA "A  "$sW0*n0#5(5//*N 6`03G 6//@a0%1a0%1a0n0 a0G1a0G1a0@1BES  JH E8	E9	
#  yS  EaSи``
퀀`p`apa!E90EC	@	V}`Q	``[ED` a' 4E	 4Fq С	A`]v[ODHIDA_UID
`|EC^^03
5!_DISEDx)_wSRSEEh__CRS8HXa6 r)$_+b!7r)4 ;c18r)XC F0M hA 9r) U[(iQ(A r)$$@k0ja0Br )4p{8	kq8Cr)7  4>91[!aV?8A2[F51F6
r 7
 <$8 [=#"GE Fu[V@KF59v1(W EO*5 -GFĞ	|QkFC
,  FD E
LEF :_REG30QMFD`pPFB B_S3D
p 4p 5C100Rݠ({ 1
k h砱4C ` BJ]`2cDC0_K3
%4E`
{	h`{`h~4E{i @
4B$ q\._SB_	4ts._DOSq	A
` a![^5bb ha[a7
PPpDCQ^V 
 G 2 7SShǃrR** %Y$
 
hAE	8hfp
` {\/002r0'A
0y1`A0D   Q   P  Chip~92@h{`@}`  @2w\=\/	3F4]8 bz9|9H[p,B
i;C0A8hj	~ 9hijCqla.5p
5hR97s 6 5p
6p9894s 1z F)D
^/x0kl3V+E 0A` Baנ{04aߤa`03[L۠@DV	__GPE	
Q
Gb bGf f@y N10FN110N11P<# 2A3

p41 ?16`
7/cD(PDpipp1A
 a	isa`118[A  s@@ p!19F@41Ap #  	B!UC)DAEF 7Y2Pr21 2&2@425P.26Q 7  8s 9cA12BCD EF 30Q 1  133A456R3n3839A PBs C@/3D3F40 P 10
443 4 q4Vq4781934AQ 
4C4 Q4F C150_INI >~51 p p!53[   I 4 @Y55&60p`#0p<41phn %157vh!8x`\`cP:9	wh
@axa
db`t
@`[@	
a
`@{}a1
y`0g}`aa08Ad azw`
d`xr`
  
@bau5"6 B~	50w	
C	
50D
Es F
(6P`q r P`Q]3 4
1516627
Unknown 
NiMH 
LiIon Np?5
66>qF0s  F6!J2
1\60
a
Dx14
7! #61 <s61@)PEڅ}Fa{a
;5F}QE5D!
 
jQ1!E!qA168a	 qZP AA2Q69	Np
J{` ID6A
[)h`pM4`
csc
  dzi@r`a[)abWsdb1/2a*(cߤcC"B	@hg3
y69g
"{U)D266{`g0&C'Е:C s824 8aEhi 1 12B w"4axra
c 
dcbkpb1b]K655r	73D`a Ea$(`a->Dg5D$I4F
I+Ep_
 W 	ip
$q:!>E9"2Ec0c32 3Q0={0``	{җ``IFA384  9RL2ccdp e_eez
cpe'cpciE%4`?~ |p
s6 IB5`p
`4[64v26C-C171_@+aN)02m2Q-  T(
_>
>7(P2pzQ{
 @5[|%*!8(Q%BB3`@F`*ae(aAhU)1C1	54Cata
ai
bKzch!
C	

6Faa`39
@ ra 9PQ paupaBHf:baBhU69C9U>CC2;30UR=44Ur?55o [
Т72rAq
H{P   a@3F
Sp
SIMPLO0~SMp
MOTOROLA aO`w*373
p
` 
Aj(_Q03':Q{BRyᱠB4u14b
Աp
a4^3
bagQ05`[TZ074 5['zcTZ3_J
6pn
'J naſ76
qPR!01A 
5 1_2 N8Et# A
IB7^8#9nO
1169ï_7316

,!
{ (i287iPP17S
} 9[HRA
ѹ7B
NĹ  UC7DF7C 77 OC180q 1> 2 F`ŵ88!8687s 8   8AaB!8C
[ m ћ8DqEn9091929  z9֓091,Ua 5 A
91MP96Qq`8ћa` _84`
q50?0
 `95Opj9798sA p! c7ba6c3g9b qaA
8BBc198zya
 "d
b
 bdpdS c
_ c
Оc
598B`9994p`kaPϕa
v2D albab`bo
vbzb8N87p`F869q |!9#!^d5zj
!%A8B=pAh#'2qbb	aq bb9R
47Eʪ01 ʠ`V9C
7ED6"`8p4" 1
qD
{C03E
`{  ia` ` 96hp!
`!Ka)EW	C)hA70$b cV0DabcA@'K9F p^^C1A0cIYA1L6
A2

Gy 1AA4 `;A197/ PAAh@eCA2n[A;A6F_C  _DDN
COM;A7A86w
30U"    8y `OS  A8_STA m A7QD
 ,+_DIS i0g3D3A7 
F_SRS Wh
a97A9r?9+rA7@
_C
>xE

 ` c

o$LA[gAA   
@B
_ON_MC_OFFPR0A[L$&BCeM6C
_G 0?" *
W~S)![ D 2K
@>AC @}AD8^,o/pqApAD6AX
I A * 
 	 B1
r
;`/!A;C!B1"s"Dx""u"30#2c[B2m$i$!P%`$ ~$B2[C:p30=0A4p`  0= B5
."@UAzB>BmBшB sGH
1 Gxx&xx"q)x)xxJ7 Ko r^r_ _u\QQKB6QP@n%QQ402Q1QN?3?303<RQV3rRn#*6Gym3 *o32dSb pB744pB84?V4V55 X5uvxp
,k B80pr88!]B9=]75]0]&2]q40qqY:9)~%BA p\/0sau02 33w(`{fx  @z[OyMdd$Q
BP` P!BE  CCv
G``Gpp 2+2CF
DC0`h2eCBDBDqC1[% 2#~ ^"  y s3؀w@ @ "-[5ah
 
 tPz
     **"P4tba a !-55
0 p G7r r " ` `0Gd d"l[ۂIC7
" 0[i0@")UC8`aҘ  C8C9&O.     [+ 3@
  ] 
 
@DDC06DC0ADR   !CC
Do
[)CC;D БINI	pCEuFADC07o2[@-D0y-ªa {3*30a =>r:}d|%'D0B
=@PRW
	
[N0Pp #|!D>\/6C0D0["

 C3C09C`{`CFGPE2J0F8 p[c_L1A`D
7
P0;PP1
@q0@D7?	_RMV P*_EJ7D @B.!MP C6Q  3 D4Q 5. DD +9 *qa֣'
CC3
gC0Nu
7S3@p 4<tOƱ;FN



H (A-_DE3d31 1	B=$
		B						G0)AAE 70-ЫE1"`2e#3*N_GTM p
8 `@4L E5 6E7 mE8p2 58{A `5
E
57%u10 G
QQDxpE7}80E@E6q76
C`[MhT
hT
hT
hT
hS
Fi  `p
w~  a:` PA` bwb
bw`
cib ac  rbP rc ua`@sabA2cEAb[ca:6B}. !{ f4I 3bL-`Z#M
joomjfjockDoa3aPE$F N ,F E(g[B*t3Q>
_PS0 3 O2	KCX9Aa	?
#  A:mBODCODDOF0OF1OF2LPh9@\_PICжhB\/}jD9M`T Me9?E

0jQ5*   1`
C#E (H 

 HGC3

 
H	
Qa
 		Q FpS!	A	
a	5!58# "cB%6(!!! Q3c !t!n!G !Aap]6E@	F
!R  pd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	Dx'@ C.pnҩ6B	^00P6Bh`/`p%
 

" 
 
]6Eh2FAAFA{10^@EFaxF"xp Fha`DhP7
__UID sO9
_BI^Q  ST F~"CL\qb[G76 `)"4`8d 0rdA
 _
ACPI3	NgR/a005`K 60 $P07AeHp&VQ_PR0p18rF[:
pLIDS0A0ߐQ"9
	/15?@SXNAjF3 FY4 F5p^ `kwk`Ah`piaFa?F42 a?{`
 gso }aap`k
  pap  6ސ 5 4 1  ~%F70v} rv

@  `rx `2`pzhp}
נyjp  '>qҘ1 h)h`Ѱ!	` ibйpbasabcpcau`a[0F}8<F9! b  AA<!/BiC ГFD QE FF	Æ4   p
`
2 P   r
` aC200  1Fee[0wre
 
2pQ U;30p/FAILp0`pD)CSEgCUp {AME 
RE^03bKxr4}5R6]7-31P
c8}cp

U
9
	AU
BbCfqH2GaE
  9aF9t 4	G!DE1F@d11.E
b213144nb!  u..SIMW1@21gT__%OsA.냈bH*JT72a>0= `ԠPASS3"QJ}AW1aOQrN pA `p52ap	! a54K@RsL;p2PCw7a>bbaO b ubrNP6G5 H7h<piK8#M9MAF8
lsq 8 0Q _WDG?
<4_c,E=DAAyB{M4C~ !f )AB}WMAA ?FBij=qDt1Z-rp{CpiI0E{h
`704A
$` B`~04D:}580A
,*A04EK	"
  aN  a F AA5##
3@9CR4 A#>2PZD25C!O6m;{CA  W:	11	K 12QG8!h|oA71h	"@)\7
1;!m  i71]""`VQ5B#&1OChJpLB
'=$P 

p
1*a*Ѝ{Cep
ob E4D%. C/n?	p
_\
p
_3O6p3
o
)-v-R7%B%
h-B/4%KOPR0C??9QV Жm) `;)! M_WEDsXV pQAn9XUQX2\Wr A7s8pWQABNFOM0Q   j:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa t0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7G!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	b`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP_}E=<vAk@M,=9WqÐ
LްWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jL2
jԘt<
@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[CQ[Cl[#\_GL_yh
`շ1piQpjkz3055\ 4h15`	l['['`[@D

O[ PEF20 r 12`PC~20ph20FF>4C230 aEp{zh
k  FP2h7m	`E 31 2D 05B1i	
	16302	PM\_TZ_39G,n6

0Q
h

[b [ A
d
K
o7
(
3Bs wC

D
AwE
F
4041s  Q3445Q6 7 ~W a8
 174 175
q 9
"09	py
h_ a{a1ȧ`Lq	A
@i `h
}`
``48IaqRbcb
 {bۃ݈Qc `b
pzabrc
c7`:0B `phahQ47i.` `r@	ap!  C
 a bbJ&4D Xp8/
p`RA Q486A4
0
	
 tq 
axa

`br
bBbtG*?pp
R
 R
a!

-p+
!)P )  6H 2E	B
h
GC($p4
1@ U/ofp{r8ubOb3b
  bbwb

ara!MpLa _/
F2 a1.11 14Ca``pab)a;15h 126hc7 apbpa1@bwI	{Bb 3p5hqaG`%  v>p43<`#;hB2n#62p`D~pPF`h`~]TZ3_
b!5#9aK
N?;h w`t`P5`x`fi
 f
p{tfqkf 1tq9cbyb:0Lb&8b!bbD
i
p

ep
d#i%=gFd*GsefDI#i$*~t
hAb21 R	] ^1a"Ua[7C250   _STA9a_ON_q_A1 FF Pi1#2-.+
3


[p54_HIDA_UID{_PR050C5MH16273[{N_AL	AL1PAL2	AL3C
7_AC0"BR|Q1Vp
U2C3 PSVFFSLPPRz0Gp"84a1vB@p(b&vv3BA3Cp?3Dp
Qp
-Q$ZFSQQE_TSP
dp Cp]q 2CRT '_TMP#CEcI4d [J1.9(/М",=*P21!E.3*o0[MTZ4_
CjHPA
`jjj̏j3`j	`
dp
d`wZ`rZ0͂EDu25B838^HC1D E1F 6061  2 {2E  6362
[ 4@(A'6526 hA66A7 8`~P%67UyAK
	0` o`F06r$64aJac
`rd
  b}y   baya
a0ay5CcѲ  eraye
	 evepeDc ucdcM
RO69cpc bgC	bdpe)ec5Ce ffg
fape`pfafgvdueA`bD`[ gTb 	`c5D$b pg15agg7agubdMB!06tp 60p0_`c@"5E F` u`py6  p  "  Dh H
bhȐ r 3c da
eE%-adft`f	ru>'adSuc2ftd g`r:`4b F@w6Cˀ,7&^-C05F%AB`Q&0`/P
_INI-CB6pib{hb1Dp6D@DE
j0EF"FF"pFC270 w6
arC01Eabpb0+b``babu=aaP `buaj`/HS71`31EPHt1s70DR`tp6C``k`Q9XD!

	         / y p37@# [K`6K27=2mHH
F73F
RGGP   @  -  0s3	0	  1	pi73[C]27	1A0F
rG G$ $ GN N 
P P Gc c Ge e g gt t     3࠰ A-_1BB


W`?9p{
`q ^^.P9F\_S0_ 3R    4  5   M?\_PTS@5?3CH LŒi[ %ճE FA$\_WAaKꁄ 47r5AsvvvAx)9ww6@ٿu:AÓ\p>p1rF1Ϳ45ʏ1?13

O4acbcc:c76
G1:t1d
 a`E60AбE1Ҙ?0YB+C5.6Ny7n%F\_GPE?J_L0p!S4
p`}D{{`w {b  {`
L/a QMF3b Ea0)Sa  a$BU$E1 oC	{

6D?F `Y9C6C0Dqo5}
}0D1+c
@ ["t+0IO	`C	B(DEO	eO	1["
dZ%DP  3/'u4'I9 HOH]O3*_3o6 S/oJ3B6@RC?;RSD:E?=_L17 &88?`}:8@8Mp-07@8PTzO5/8C0F0 @{eA
p>kK
1F8C216
pp
8p8ZъID}8 1
dA̺` G0A`PFQh1W77MC &;%Y0 ݏ\r\A%D_
k88S4!6~y4oa/a}Z92  @͟2t2@RK!F p>F`G
'.`!!	?`
A@*J"`9K,	%9%tD2
 o31/9CyLS1
I9((09_0909aa`v 	b`c{.l '^t{a02Qc[4B ,
[  6Cp
a)?5
7Coo4b{b24N
a"89dCp,^u0jaC``	~AݡAp

cHc
5Q`
q			vcv}bACLV/A'	1ho>7SSDTqHP  HPQPpcMSFT L4WD@	1   L    f#__fT	_w 
_	O_Ewj
ara
kaf907FP\8ij!80 PhfK33dL34 281_282A1$ 71 J536y%jV7 z&80YujK83
2`t Ta0?bb`h~ a bub 6C22CΡ221E222E35q30y6|84,
eb+P5y UO  V!5'*[A͠PDC{h`PPCT nZ86q 4	_PPC _PSS R37Y7'NLP7Pݞ_EJ0D1P`A!Pԁ _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-      %     VIDEU  AIBM 761295520C??$  2005/07/18 18:c8 #S' @<D	C
Aspen M24P/M22P 32/64MB BR14055 225m/300e
 (C) 1988-p3, ATI Technologies Inc. BK-VER008.020M.030.014  ptASPN14.v611  P24 PCIEDGD1UN  OEM.001`1 l l a$ZBĿ   T1vX
`TVS :+7A@( A4R!Q  MOBILITY RADEON X600    FX= "{  @ @ D  H@   W !U	d!@ W/    W0u=@#A@@
 C&&kL %<"0 &4(0  p
O@0 D ՒHC`  -0  .@1/ i d`
 OD  P   P`X "| 2"3X&J 0!4@A= x| 6.  qE+ f`U !U  P &BCw/	m۶ %""c=M>T#[
u`!q!"2
O0L  'Hn0DDTD//D")QSB B1	1(Z @`-1)dM QJ0'``/
s- H.@ZQAD0& 1w M0:LL 0a q9VQq2q#
  5?q<   T- RU
!,$@l%. 3 ~:N  `   P P` >  LQ` `E
H < B [<9D9Q  BBpmA -5?7p  ;uuR9_0 #  d o`a B   B rB 3  U T %jA*1k %QPQm&_"n_n E %=BT/P Je	  a?Q??q@EA(H?pH?a*Xn0$p
3   #4 (dt@225Q3x73
  nPàPr`U.U 3iAag '0ltu.Z)b+!ǄWsCg
QBdh  c Ą  bm f`.>: u>.:.<	  u  `1u .>.9P u.>Ȳ.:fa.t4.>q u.t.&t.tм	v.tf`fL1INIui_W	.Y	_` SP[)$
 t.VW	 _^~FIRE GL T2:13	P
R`QQ$UQP+$XB8lllT	.
fa4t.b4P mX ` W e f WP2X _[W   @PXuC &GOfGGOOf& G OOR? ZWRP@+ CCP2?FX 1FXfP:Off-@ f
$ f$fPV:o^jPp"mfPf߃f
p@"mGQ m"fX mX=Zux13V< 4 
 AT
(H/V$? PP@X @N ?u^r=2Rbt P t 4b0auAbÍ?is $G  ,{@:$Z u9"Z첺2ĸ tTce 
| 2~ '6@`$@  B@."Zȣ$$%VB <v  !  32Ĉ&! .@2ɨd^Ð	ҁ NhV*81@Ld
F8
0
aW@P
 a8 
1[ Y>ȅiE F
u6_0Natct]賿rr"trC_2>STN)N=`2P˳< @^ @ KB   "t
u1#< $膪tu	P$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;
` [# ~ tF: FlfwF62eF2d wtÈn<uj`p$t }t  ^"N 39X8u跽 P P$X"8t+N ;N"rҋNN"	F;t
~<uF1a 0s2~@tRSf_Jf17 `IǑIK&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(P( tR.&%z:Z.ߟ0-[PR.$Zt2I ZX`| @ Fqq@v=J	;5vǿv `tU;5tEt:]r9Urmt5f3)qif3ۋ^$f3fa  C s
8sn~=}:n=a	Ð   1'(? -   S?BDcOQ]MJOVУhoOQN^gORE0c	R 
l	jcgvWX ce
pVZa	cj| [is  cf	ЮU'  qô% Lʥa	d2 z!ҟ`	σ6!w % ן/?  =!ҟ)pҟ 81!
a	*0*!
ǟ
N	
pui	_ӟ,b	
0
?ԇ4 A13%4oYW]M`62a-b6ip #B8q?J +ʈ%":b6jU
u%2S.<t
 C[3Ы3Àu#DQ ڡ  u u 2 U 1sFg
 h@h ҋv ]jUbDS׻:	C	8t	C$[. PRC\uP tY@ @L,^P@  Xj  U    @xSQRVWf<t< tux.D.< uhUC$?
t_\2Ҋl tʊ»P2..;w
( ) @..Ttt& _^ZY[q&G@p蕡u
b $@k@/
@@S[W Uu C<uTC<uDC"D
,Pt C2̃ 0AC%p	KSu/"xoBJ k	 Av@	C@[AS߻ YXː.6
 RxutX upL2@ ak. 0Jo

&  "i
5iUеRQـ.F^fY	 
 pfFni FHiF9`  .%$F@V@.:A oph
@{f0hQhF?FNF vFw'W  _P<>L^`"SQfY_S[SWTP u2  )  @X_[(rTXiT[_tF$F&s
u9?+$
|bohT^T0ʴTT`6 `f3a  v 迓G^   00@ {t`W%s U0( `o PONBZZa X?5@^@@A6 ?>S$  @N{_S1Go
aP
ud
R"tQSD@Mt@uN,߃u'"3N`'F  fa^  t>/S/g8>UA[ 0hY$ Ā@=
u2>[X7Pj@Pc@! $tfQtg Qt Q@0 t
 ̼twt6F
tOuQ@= %?P%@
Ā?
X( 	 c-'(+  	 {P c_O/PU
(P	@ S ? Ps0	_@ T(    	Mƃ](
c    C
   bc O
 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0 0 	  
       
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc  $ Ы,!
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XAX@	d@Ap@ @ MO~+R.r/iuP =Ou0W&URP=: sX.爐$XaBҊ&%=Vs&2_"&+$' s*Fϭ$eIs% w+j&P$ЬD$ԥJ<~.;u*6M`8Dt	\S
OX:PI
X.체0&G	t G	?
u&.+X&c .eVX0`PW.E#_amYudlu
ѳ}2.\{}X&I?UD`UD 30̃]U 
F CE?]Y[	
@FXJPlV%XK : S[!% }lluQ
u tuED]P|WU XJ- `ǵFuNt!D )DU+]Q S[WS026'C[2S  &'B[  Ë#utt&FS 2&C@Mhkt	 F[!	7	 2
n Ȋ3S1.8
[t Pv {'7t ̓rPDXuSصO[P	$
WÊg% oŀt4$
@   t$Ê`$
}P X3<J1u P<~$<t <t<t@؁ð@  @HuPÁ@()3  @
@@ b !"# 3@tb
V"o`HSI߀w)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uTfuK>L tDI @.> Z C3u&"0Z<~Z&g7q*0u3 3 ߎ2PQֿ3f3f@  fYX2PRI0$@tZXP4VQ ' R< 
0Z 8 b/"ŷP m//s AQR迱$Wt@rS@TY@ fRȊseZPRPh X_@ZX8t
tPZYXduT  w 2u _7/߲
t	u$ a0t PA~]wX^0pu $0<0u  &o#6<uA	ut	
t0
߈~ )<u+V봀1u0*!*Q3u< "	,܀4u< uqp 
hh6u& <t	 00=뤜@SB"
: on`>%^N"	  Tg.P <Ȁ>cu>-@ 3ۊÜ$.B.Eq J@^X]`l+[t8 yGH  <8t<?t! .B 追  볠K%/+Q` yH Hi Y@ 3Y |RQ
 uYf.-  b- *# ?(#  F 

 G@s 	 Gޝ~~|ֺ| |88| o8  l  <~<0npW ff 6xx~~~p`>>66f<ff<  >Wqf  f {; <f8llw8x~` 0pp0`$ff$18|||
v<<a lll2ll  l ~|0` 8l8vv P``0 @ 0`   qaa88 || x" f<| <l |ƀ @|  ~ C P
a0P 
 y ~
 ff|ff f< ll  b`|``k 
r < p  n`b% Ɓ|ְ|~Zl); l88#<  P
ΐ| %|b | -׾0Cx|~ I`   `̀ 6000q(v |8 x`flx1l2@ lȡܢ-| p%| '| 06p'( *2
v 0d 61  8 v$plp;5[ |ƅ88
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7  0
	'!r~`l`fl fEK>c8c>  >a<E4   ,+> >`gc1=  G0`2#`?#: 0|6> l<~61F  6ll6`` l  "# U# wH# ##d  6 aP P 5 `ROqPTJU1UQ2dt770?RK?0aa66R9R a	
Q    ~  f 9xeb]Pf```<p_d~̀Mi|?܀g8 .Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<pS2tflD8p&.mp0t| oPqAQف၁|PQTlEcVFlpxpq5 aq3Ԇ]^҇ _>}6`vfqB~~`b>~~>ՂR2$ PVe {p4`|| s4S
@<kl mtn9_2`!@AH@iP!3pxF)bfwP0v	~mi D{1687 9
G-3 a5әAP p|@ѓ`;Ҝ2#a=Ғ~ BC ҥ R*ҤљނtPa7`p0iQ.f`d|d`A`
`ζL ӥ񦴝Rpb@q
 x
p S 		
qQ0F#a`( L%4bLZ  ~E࠵  4-0a6P6rø l  a  	P $jǷb[6 qb 
P$=b X
O5.  'Ma0
 A΢оc A Ut"{ 8Y
0x"p	#	$@%#Qb  
#p
 
% 	"Ђ#Da6f?0P rʀ
$ 	%  		C	J@Cdw@`1|cc0cд	? !	8 ld>BPP<@ WWd! 3`p3 oB< ;8>d4p` ~0]Zwl^l Q6{>6n6@s &tؕO؁PD+ f 5ڿZ  Ed

 Z Ӥc g_cb
 d
d5 ei5ek 
c
e qeeu %


 9Ը=3;1N Q1b0@i2S$|ҏ05Yap``<f	`q| , 0^0 v 3 ј/AX `iʼx x8#$?~ '6t?W2@ _g&&MIWI &FG_&E"&E#W)c_&]%&}&I2.?2
t@' @)p = ~=^~=~=~ &U*&$
$

}I0B$
	-	1`I2;t4&wt U pu`2HԊ%@+F4 (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   


 
  r u
[*   **Q p   ?  ??Q r     $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :??-6?-1h   1   `h1 h61 P,h0   1   h
1 
h
1 
hTP$
ĲXðG2GAX  t  À>I~&G3u 	u&Iú}btԀQcNb  P3&2J&Gۢq P[GLq ģ`À0c BÀ&a aNjb{mphrmÂ
  !"#$@ABCDrstuvk(
K [!{} ;Al(L \!|<An2N ߤ^!~>Am@M ]!}=A`P@} P!p0A aPA Q!q1AbPB R}!r!/Acj)dC S!s"?AdU/D T!t}#4Af?F V!v$6A@h@AH BX!CxD8ArgJsG tW!uwv7AeVESA   0  LN`O@ { ATI Technologies Inc. P24  01.P @ @   6T   sΘVBE/FP :.6p <r2.YWVSQR  f&=2u " WA_WȎ؋>O_ " uzW &u&E迌_WPPPwU`b갡 M__ǃ"` `uZY[^_O ËRQSVWU?WQ30
Y_u5WV6O2 ^_

.ZEE
-tE M]2B].l.DEEӀ~ZEE!@ #  
E" $ ~W7pq_~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P0E*؋EMډE,].

-_+E0pX1t
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
ŀuZߊdĠT2ʋD<u<t<u<uAA2PQ3 X23` ɻ
$<XP%<0oDۢI oD o2 "pDo'6tuUU.. 2 2O[]YZ)ø VP$6Mش!t8\t,	2^ƀ t ֒ @^O-  	{9s3"0WV>(F^&Vf=>^_ô< uV."Z.>W : 
._`@StwCCPS($]
 [XSL.[ tt
uPSR Z[X8
t
<RBB@Z2Àu < LuLa.؋.IS [;vȁ~O$;JS,f[Dt@S'[%@عSQ-2f05$ff3f` Y[f;Ës :xxft1JOpJ2uGf`P耑RPfZf
ff3n-fX<uS$f[fa=u=fP$[f%fP&:v*@ذ
XZRCZfXrSC	
uQR~hZYqUuRY*ZtV3 Wt	1B wl wf= ]QRWA9 Yf&f$4 of_q_	uVu& n  #T8<\ VwR{fP+tZ^fOfˋR+S+sfffPfVX OV0ycPQRfRfQY{ $  ZYX!
Q1PfzBffvAzWfa40B&qfIu" B'&$@[A\`tWa_f.ߗ ށ ;t Λu2X#%5$$ ,0QS߀u:3ɆtA
2 [YQ
ð$Y~ ?SQVWc# O@ &Is  R^Y[0e7QRVWys	_^ZY0Wڋ_  tS1 HâY3MR, Zt $$!
    t7SR #uZ?DQS  {&= PHGOP%RWSZSTeUU0VVZ% KXX 2ÐPMIDK$(Z    cأ$$%dZXR ZR
 q  ZW2 _ÜgQ K.:3 f.;uw u h 
	rk2[fX)D%)7 $4S
 &!`ffQQ2
QQQR@W@W @JfXR2Z [ff_fXZ-h R]fbqf_
V
n4
X

H
틩RpfZf`f_ZvfPRl g +ؑKK;rZ` S 
S  S@ [hSSSR	QpQ PDQYÜ2C @`)@h #    ` #  #d # B f 03.Df a.T
.dԷ"   $!'!Z/Rr& -Y&
y"
	.Dt fXZ
+*

?<t%+%
D yԠ0Fp
DGQ e8t#su*cr Y$QPƫXr	8u
Pu5,XP	r%{ɔrtrjrXQfuQ2 PvqtQrSP?u$XPQrKru
 uKuX vW\ _  QS 

O ztG0rNpr0t;Vt3Pr,G{t$@נrr1PBNKup~u!`ڇrdr
psr1	Yǲ#isRP*s2Z W _YQWs?`Gr	zKuq_P ©Q Ys%  $  MyDOO<Surj1[rbfa uٷIrE8w8r5IP2{XPr+rr60)r @a,X0u3ÐKu3S QPXY0[<t<Ⱐ[<u] < pǃ3kPQWGGN糖p!_YVXu~fޠu_WP$Pʟ_
t @`✺
Àlt3]:uM]0Y	V u			u]|ðpPXq a <Zr,ZP2Po [S Tg6_;w2XXXYf`	 e|		ut6P%2X0 }  t Pߥ D[{DX ut!P% Xt_ueP{ kgX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5 {uP~xfaPt t
p	wiwu
ujktu4KJLF @ @

0迗Xu
	cWp   b  PuvyvwujhmiӲiPPtK{8JpJQRײt8
t	K*e&!e.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU Y7 oo XGW 6OF  	@sTv2ed. _
90  *+P;
2&SQ
t/+u'3~At		ttuC۰]4U 'j l ]a!S3  [)B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀^			 
ȎJ	 z1P(
$@
JP@=^v	@=v$?
ÿZ[@5S;?1/دIJS nQ$`$@fP,8 T 0  PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
  ~ ff N[VWQPS= Nu`r@Ўؑ3f<8ATIuI 4ك4 t4D8u*D.`
D.bp .7.8.>~ 5 [XY_^`PV:i<u2@a8u^Xû..~.?t` up.G8J ZYWVQi0oiY^_ 82   F=P1t=T1t=`Tt=dTt* <w 
 <wf.
! p ßSU^]6~92iveb. t[HuAk*rPt X l'&u6dcw!Eccdkd
L$ ЬBh6][3۩} w0   PN  Xu22@t $C s t:тqTﲟW@pPFf $ A7Bu )$<t2
#r
p
w2\$ 8{R 
a<|10t$8!.$ #$y n?#7_ puoPv ̀$
'$w
,R
$[.
R?|>E`￸ 2HRU°  YIS$Jw'?1$! `ԭۨ@  RS{%pE'E"2[0$%i G`u Q#d ߪSD PQXЊ R tYlvmmumo^ `>`aa,?FqAABF,F"F`R/<`yanplm7nwQw3 P`e`pia]`
A@ZB9A
A``d ne %@f !R!Rq7?@S A  "
 2 <%Ă  /  `@ $R@$0$
;'Ļ$ $1=Rt@g h벯#$}Vz"q#K$jR@$y1!{pO$ Az  P!{3xQW2wdF20o9 MЭ<  
qt}Q`o
BPvP..
tP XRN'~@?Z?1#tl߾joiflkx 0p]_U	й;A3^^n#1%Q_
^~:({vC
 `Hn02bӨu~ i=j43j.E#`0- g'$kk^ ,tuDA ;p7J>v>n?@Uu"F]\]M^$RWI<#t=<2t9<3t5	 貽r !	 f -S`[
_Af!!PfgXP!0
$<<t#<t< <P < <
0 JoRF* y&E3upuu	OfF4 8_._f.EfPF .GF4XH~ uPlF6XHNhuHff%  fF8fXf;pqPf	F8nwg2..>}ًFF4 fP](P`[
= S=[  wFu	 QVFtR3ZF Yw.HF
GF[F
GP0FG$`@F	oFпG`
G.M	̀

`3T
ňFF	
G	F	P
FGF	GFG
F3F'F2F@FB <Qa @QRF;#t7<t3/##
<t<t^p2NAVB;FPX!                               x 7 S(4,f
   wfX[Q8b>] ĀuB0 u*@fEGtff.#Gf.Gfۊub uS@I[`.O.t	q tIt䰔ٻPIt
$<ȿ2YW;D뾖P _P@ n Ps d r     	 p   RR  { p 	   P  p 0  P  {p  PP^p ^ ^>P^p  P "p  P	 @?KZPb pfPWQ2ɋYSQ2Y[SQt93.OɃ.;v cen+ V_+Y[VSs|f
V@VtX~ QSfX PQ3@G YX fSfP f%f[ދõlf[j 
 f f
^_fX2QV2w.^BVu= v8ǰB} YRfPP%fX߲fXfP6&
ŰfXr'ay	3osyQ2P$?zXVk"Pb.fQfR	O$BP;%P1$ i%0[PXR;3Qf
nYp<f`ufPV!.^2 >fXfZf}Y&u@:5fІ$PJqfbYf
(<tAOMSQR{߹.
 I Àtn_tQ  tt"o H? H뷰H4 )`t5Rp .kh Q)'Y[X|@t.Q
Yf.9VZY SQVN %r0w<u Q It	TQ.X>ߊP $o
 Yյ^1ƐR`\f± f.;Tvq v[p  ~f@ wjvef+бRvMPv? v2 v%vޡ u	r,w-ZYWËE._M UNfVf^jff.fff;rf@frxЮf; N^f;rLfPÏ.1If;wff+f'7sv
AC~
X.L
	؋N]f
tt= r = rA.DP.Ã.[?`!r +!À Ftλ$? gM۲V$T$a Ppa[@[pS$Z{tZXypp۲P%&O@t $&W7u t@ @wPjېHZXZ	ZX D`RWEۿBPŃt:ݲξp_a @`0Sf4`;[ø \Dw37H 				    z  
+쾁2ڲ[Y."D
$.
tcs] БC@  yH2;/ܲm 
  ]60&E}q P00OX0
&DVB 
 &qo^1G!Z$^~J Ftf
^~ fPЀNnЄ;w@( ڨ[Xu;@fPpٸPm` ` pFF Ƞ 	rp9F,D
T&FsFqڵ 	FȊă4UF1n%އ
8F%Q0tPFf=$^|A	-,Q
)@f
 ZYfQË؀~Àu JV
ظ
tQa~fA>
R}Ÿ HZ3 ~[04, ,l ^Zy0C6 
QRc3ҹd YSR.Z[  SZײUP`
P$߻d
 ׻`=0 0tcزXP%
{XyX XXUP3[p	зP ?t@w ty0	ֻ_P@nױذ3`		ײ|BX0YfXXh20	R_T  > sܗ  ϗ.Llyz_0!  ڇ7F |N錗!U.Ջ׈Fܲq_2K=jQ TM`}^ 4
uOղ) $л 
zg(uTt  NVᖀuN8ږTt
'$

t	(it	
 
`铖 qԲ+@ZXt3щ  kKxLt2S=tP 
ނ  3kINQ  tgԲ&$
N2;y v1#2ޡpH^q @^r 
Qt yPܠyXߟY^8z{gH	\%T$ ;ȰU$ uɐr3pu$%T 衿_u  UNB蔀@ؔݔj_R֔`&;'fO>f % Ӳ$ 
tfȟf%鏐P	f@,.O>uuncrkҡ`L
U`D@<=
+1
蘢ЕFu0&&	<g(1
쓀퓒aTۓܓdTΓPU.C8tXp@'X鸓 wʉ+psp2!:``0%$@ 1$
c]$@*Ia|Pe$4蔠ؐf~"`AAp2ˀu$Wrph?2O$pIڒ߀uR!= Nt(%(8t " 2	%鎒郒 S$?r7uq@s
b	;+	3
؀
qQ|( 0e ѻD ѐ@
8ttuoSP<X[vaS	2u[S
t`@ J~BQD֠ 렁A [
тqݑðS 3ɸ.:T 2GҸ PmP @YлxDA$0С$/4?+Rл%
 H1Ѱ%ߵfQ
fYfPfQ
 Qsp|P
  `QJ"qK$衭tqqr ϻ 
f%g#
A%ϸ YKe fXfS@4߃0ឳ

fV J BM :, &u  }- moA: νq\_ }@츔{c츈츒 Zff%θM츍{u0
 ps-Qkm c_ [SAqK
$ø1츕  #
 r
q([Rͳ 
`f
  Q 븕@   #븟 @ BL ù?ItRZ8uR
ZCR2̲_P & ?XZC@y $#VUprL . f.Pf#u p^ ByЍR23Ұ
)u 
Z`..$Z un> tgp b2P>bP22AQJ2=QRP6@q 32ZYYy2 XaZYYR*8}2.ZZà؋}   2Ku2W S
@Sj[+с2Ê2+U**&R  āZHuB$ JÜB J.Zr c Q ʹ  PQC3BBaaPQ YXaYeԨuXÿ}N
+.J
u8{~` Z$0<0t Z:Jt. ` S +*21+uX  up*tX⑰ `P"㨀t0׊4"
Ê$"ð( @п  !$%D
m݁  +

,QVW++    e_^"YԊǊ_ S8v2QY2P >It(P
RS"82 PL[[ZRJ2ZË.  03<?& t
uV E,ņ!?&J aYZ	-[aw2RqZ1L0 }
+_@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6]% B B2+Q+++YZ0"Ȱ+Ջ+Nu`$` t  Q"{t|ÑpW8~@td\8tX΀|0I~D*} 
8t8`t2
8~
 ~Ȁ}RtɊ*Ŵ
RQVW3ۋs P/2 1t@   _^Y@ ZC\QRV`T3G  ZYËxs& 	r UǢ	 P@ Ҁ fff  baS[F_@fWfVfRfPbPpfV +Ɗ2BAXZf^f_OSRP1 `VfZ2f04[nu.N i wy拄 rNf&Iwp$3-|t;@ _v[`ovIbR:Zo`R!ehō鿍@A3h駍y
twFs
錍醍PdP+>PEbF+ZhQ
tGoR
#
+ qrnAU~6|mг 詿&F팡 +Xu &F E&   P Qa+>2u	&}utGVW_^t!#ut
>|  21
Ja|u\<tP~A drqF`uߴ
oQˀ

6JX 2B$]Xc@]SO4 2
F}fKu[38,~!#|Aom綐pBu+G$P|F eXЅ$6| 62 'tm犿UPu)#﫬p &N>Xz 鬊!1{~   PO Àt!&0@ b?`$ V&PO 78rw2Êв2,_Ћ!=1HJN@PRXWQP͵sêuXY_bQ(IY+w鶉qGtrGݨ _vqGov
  _u　PUP[,^@.X`)V`4|4Fo umXPRJWQQW@3_G8v
 VzQGY_PĻ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_Ұive0XRWQRQWP8tXP5$~FX_YFZ Y_Z Ï		a					T			ɲ		?>ctqPsw>
u&fP 3 f \f$߀t  
@2,SP㿁
3 t&   &]X@9	UĴ߭P qG@Ā`ey
L'靆CkPA[Z+A%  %%&`&1Ē*(DrX&߈-t
Un
	-̢-2"[}~مyfr>b2PI<
vL~w5`GrǪA8sZiaat u2<
u:6u Ɖ0<u&<u
tۿ22+at++&eP>Ҫ3peЄpбa黄.u~}&2p
O>3Ɋ7ʰ'ﲿuF ZPcR`R8bua:~1T`NVb$
Ip(!Q̊.t.;t$.
DYܡ^Dʃ#+3*2d!d"<PR3=ZXt
A>t
鞃>u<s .%]ߔɡ" O
 #8 >[@ɢҢt_1 =@&.ߊ+>&߈}s! 32 =w0$&e߀ te  3NsQ2ĜB0:JG `;/^ oQ&5&m&M CYR
u	$aP0(wcu4	0P !v &5&M䁺-Nۑ  ́}4  {P^ao ,AWT 锁tX9 @Y.ڰP;PY0 d2|XR~ ZSںYB蔊 [Z SBB  컊s Ȋ`PSfQf  t^$t"$2t t=f_Iuvot%utfY[X$ .7?XZߥ<t
4_`aaU<wPSPRRR@n@	e@}P=s=s=|s^=Js ZX?j[X <t<tˊo~ S&[ t@ > B F.| ~ Ȏ2.>.o 
*9 Խ.Ƚ'60:
u00w5wpP&p u͎..(F.QFF ~'6.26'  Sp$[謂&G&g3t!<}
<{}0
ô <t
<̀
&Gpu2@ ֋P$A"3ҹ <u{Ȱ P' X̀
PuÀu
&~a@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tuG8Pmu&2}. aѬtV$
J	 Ǌȋ@/utHవa& L2'6t
 t<t F0J>=&]&M&U&E
ȝPp>X}21PSQR.$Zt	00߷ZH<||SH!5[VQS&F E<
"@<
t2Bdpp\p' t&^ E	I{ras -Pһ #{	t2䆠SU@,][ X[YZ u:ХuP{`Iz~Am^F${<u	Cn{w.:r2.] IÆà$0<0tu` tq
2.;tq `i8~û{ 3n tPmU#)Vqpt# ? P 2  ~     ?     :@  R譯*$Z.$SQSQunY[f.
uY0tXu	f.> Ef0(`f.ŀt
uPa*Rv j
PRtDZpr .@i(-2.OA.WB--tW+A_t;rÀtp 
u蹮B.&Ȇċȸ 3  u,A	t0t𼀭 ]~
PG~u?M2@
uJJ Ѐ@1

@ 葯Pï@[ZPQVWS.>Nu$.T T R	KN1K@[_^YA̴` 
Xf`CPSZY}tyܿtrS\0f`'踮[PtF!fq2Ӯ0)p
	y	f  iC} fa'fP22ɻ| fPfP?."p0 f h 	B%"
2@ $
ȁX3ŭ   󵭰	6fX0S.= t.;u.;]t?30/WuR `bW.eD <t<<t8<t4<t0<t< u0P]M=@uuX5
X
=u
衬_Q4@E=@ Xx ^W}     Ѐ  @jPmm @{wj X--    
} <u`P=uaI	@$0|$A$+嫼`oÿ 4l$u p 贫Dp >$ 0CW@>W PW .? t.9u.9Wu.G2t O22N_S\.Ȋ
܀!c z [QRS$<u۰s |<2[ZYû"q#WtPV3PRw$Z ~7R% @W f@b  fffRȊ t3t+t#@t.tpt>t%ff@n%fef$<t$f- < tf+ f
 f2) ffffZfYf[Vp>0ٰ2G1g2f3.Df3ɋ% ffp.	 L  
P!ffpf  !Xf_f;t9`fX!Uǰ"ર" 
¿迪#ǰ@pǰb ? xǰm
oǰfǰ]^'HCG :`+.^( ǰǰqDǰEǰFǰG.F*.~/ @_ط Qtttt	trư߰@%ưưC?菐 膰} 0t裩hAfX^    q  + pE  C @CRwuu	 .F3H  eH@" PuʨfXfJ	v^.~0

p0xq 	p)tfPd0a4U٨0p   83E!mf` fPRQQ;vuP3HXP o 0V`  	$ͳ,L F T٣   X
\ `u#fzuu _u8 itqkt= t p p~pC
uu
nXTntY]IUDpEHPqMb<~	<%  Y)@tA 迦 YZPRSfPWy1!蚤藀.E_fX[Z聿4~F
@q g<0 _F;  Q(;; >p/HN 0  })%88 A~	I? CJfPVQzv<t%b<t0\
 $W董莥B"EA!H A"`-YN
 Zf
  9F-fKPHaƠ1p;D f.2t't3d4	Tff
@ S xf% 1M_tAN'   [:贤|_ZY`^RVW@,Vh 賣3ҿPg.;s& j?>.\e?Q O^ L.L.2
0G_^UCSD0[û@颺o J(@_ I(0u3HS#	_ Q t@bm0uﵨX^.PPS2@ Q
R}PJXG b c$
k*6
mc8*1 
  
 ! !- @^#
P  "  * @ 5  
I @ .1&y$`,>$QEA1_/BJ @  ?-1bK I'm$ j8!ha	d	&@R c۶(, - Y- =QP`H y5%#~ +.C[/H8CPO @Kd	#CF( N% ؏'	  # wE9 Ƣ( [G ^F+ ? /#Q׿-+_vk+ [P z }qBmc	o	b	y`	 Sj B+ 1@ : IR# (O6 i 0Zb8(+ h"6 -(y, PTq PT PaPU! A?-'A].P]h@2,.a5c
5!^O1] Z`0U 1& ccA$hG1_	6eaWUPp4V10 p X |1
w*
OS"|S1׵CSS !@" "0"
TSASp`  A
` Ab6ASA$T/)SSsBF `Aw   ZtS@\ZSS# 	/ A&SrU@4j=@
@`]bM ZS= ڛgJ	=& G?X4 a	S9S` яf:fHVSA+.SA&/-<S'/
S~  s`oM s'X+SqPm~%H.V54ˀfLDSSܢ(jZ  z% Q6 MSo-+b{6']r  J5 !PS<<S.- +fc._!o# ]3V2hhh	`	``	{7#V
q] )Ve ) AySЀNSReS SVSWSWSSSAS aC.R2w.PMS/Sp.bp!cq.1MRjSb2ycox6SCnc`QV11WiPDSSwoSDd10S?
u). dPOjQr%S# /*P$V#sSS9Z'GSr!o	~A` y`a @9qS @c).gK@So	V/dÂ!v/# 䅧bbAyno`WcPAbb	O kbAobM
uaJM  k   㤇夏+. M,內`6tUᩒuZllŮYSS$TVN  0rPSfQWVf3ɹ   Se[^
t2؎TA< u+~7APVf߹ 5^[a  } : ;@f=p @f=0 @#@؃  @=	wIu'= Nvu >ASC+[<wqȎt @
봨q.Ā@@R뗨 @d1v녨t{2qq@_fY[XÿPW_XJD Px@ PSR $P 
XtuZP$蔏"
X$<۰ $/61PR_Z	PP'  /ra: 
tRPrQ
tt r	 pXZSQWPX2 t3;tt_Y[P33 ty>t$@$Ћʊ$ P$2Ƞ$a>u$	$> 	E> > 7  菾p=b` T@fPfQ>r }Jp+PQ
==$
oăQ݄z==Xü4 Q *@Vd @A &06WL 0+  A  0`e  1X ( 0XB 8xVkyVA P	 -`]N (('ȿ @$
>QW]F_YuE裱.a-Tt蟯 6fn$ÀBԎ~0 $Qwt$@duP=@r	KTd
裍$Ht[fq25ጱ55Gf3;>*a]an$C0:Y
3* u<$qfz$Io诜Y8ьPA'$
" @@u&?8AR9S#p , !CD_$@3m% % t
tQK1ۋL%`{TSQRtG2;r
ZW  QRWF`GV_P!x eǵ [Mbðh: =a:ðXQwAq::6q1q*]	p?
9b9p9
K 1 /|p+?$v0e gWx  &ZPȊhT迊of诊X詊sc\蓊HHx聊踊$ _[UQmF;s IJ9 V RFNP'uؐڃ?^
[F 8[2FF
V|Fً"~?P8XӀ
QYINpY ^HFy8FVЉVW1X53]VA8@dF F^9F$v FfHF f8f7jn2Fp417:F	Fz 0
}7AF q.
FPQRЈ$_M 
Ⱥ$?
ZYvaUfS@5fW бEk 'KEEEfP'aЀfX[
@T%`c+W	*	E~#
4 #8A I 9 ?fA[cB$J&e 

BA
  0f	zQS }ãIM 8%= v$B, 7@c҆A$蕆q7i%  (8{4MVs @@f3 P3ҹ ȋIXA;r$	wuX;v;kt_KkXPQ J@

LVYX  tPfCKjIXAfQffffYf 	&\`   fBpG[f^O`urNW[P #dd OFqH$t. `|.>.
px oy
d3. .<  .3f<8ATIu 2؃? u2$ PVJ֬0	8uĊ^@@N.ܫۗM؋7t .& t._&@.?tǐ?w.E8t ECCйVWfS ypP0W.}&.E_.]1.M0TPXf[_^`f09
-0
̻舄$
܃.E6ڃfp$
n$@i$.e923趃W =p	_U.]9t"=f"	=%f	}&f1	&3SG <fXr
pff[fYpe$~ 8 蝄 :0= %
Ĳ0=2..}a%u

ó( 
߁) 4*Uu)+,+$TͰ.f@ 4mfȸxi3(ZYf[
 .  0u  t} 
1薃p~A ۓ遠軼
迂% 
  d躁N!< R倲Z@r@%4跔[꾀{ad% R$ZWP3.E#_ @_VQlWB⒠e ǁ$7f/%;E.uDff%   -.:E0{u12   1u"f;t
 H͞~ _!hΊY^P	E= _t=  _6f=  3_"Y R?W1芞W
n ;-$M }r_
$^QcϫPQRR$ 薀$4_
4
ZApu 0"oCCX$ۮ6A2H2N脩 WAF$t.m aGhm@0ʝM,t_4a>$D!" ߓ#q萏V~#}4 t?A~~腀~AC~W4'tDp$~_-\ Y~sހ4LPآUF61aMupzA+	JJ+F"F 1~r~׋F-c+~~F&2$ҙ~[$o
a~QՃ`1e/q~k~:uF) `~$
F)}T ~PP~fF4.~`Ġ 8$~A~~pF7t~`3  F; qX}FB#@k0 }xF'F(}F2fc3 `}^`){2Y[:uMjbto\:3ۃ̦ @׌G f /fb  J$
f_fe`Q
ff
fbJ$
f	f%
f̀ffMCRQWUD 2F E]@uTudu	fF4bqF8q_o._HP`.GP4XH˴P6XHfP0u@R fF8fXsf;Pf	[2a..>}ًFFY _YS.Hq{f.{{.kk{qۺ{{pj8{m[{A){@!B{Pl!I 2Hpf. tk`p.O
+..W{ aG$?:!Gd``aWʰ-BM3
Q""
qW.Et.;
u
.;Uu߳3Iď6  \It@cS2kG@
eRlDvk_J.d ($
ωF"FG
2N( N( FqF'G'N'`+`$fF f`f`+1N)FP
F$p`2.O$F&FqHF+@%
ffGF-F
.oN3P$ 
Xn
F!f	f$cb2c]`n+9/
$F1fF N& n1f12 ?F,1-Pf..7g` `F @FG	P $ 
F01` Fb%
! Bup4fu	P^f ۀ G02ndq"0
/

sn/
 2f/f臵	 
 n !`N2AVBAb FP tZtUUF:2U62rU_qSsR0f3q @U2WPTt~V	F2_@\@ \6\2a_2xV7tVqVa`{ a2 8 < C F H K L U Z d x   ?  ( PA2uSt$^~藒 FtP-
F u	F=Q(^~.?Ff. z2{s@`t ovQ︐ Nn.50f0
̢ ɕv[p1	cyv@lEf^
[VNVF$q2	%
0f[F6@u 2f!uj95t1QXf^ˊ߃fٟ4B^@h~/8w{^~ ^ `ePF=$J3=`,= `@p)t
 6@	s"`Ȏؿ2D	DfDQ EeЊ]}0uTILDu'uD*++І؊}Ё@@%??PDd2ٿCEe DÉDE	`x*DEe}HDL0+S2]Ë߃${
ĈD\\[ˊE
b	}2ȉL qBacD{3D<v|$<{@ $PX;}Pw`d;DX;׉D!#AЋȉ[D)
'Ej2D(D*&u @D+xL-D D0D.E94S\1\/?ЉT2?03 ]`(H?t@P D;XD5 ƀ@^@S @X ^P P @ XP     ` Q  x@    Samsung LTN150P1-L02  1  
 AB H }  ! pRl L  "0Tn0F"d`
U Vɹ ҋ+w^
uy؎f<udf|0 uZftpD# =	wIu 3Dt .֨ d2QĀ ]`UOG1	PIQI	 aJ2I+:PeъE;$up E;X e9= uPWA_= vU9жOT3Ƀ= t09w'9Ew"xt=` wf.E.D`A.@A@ } ;uA7`VEDP@SQWVr^_Y[| u ?P?@.|& t.|&[[DFPDMmyMm 2]a$@VWaVS 2 Ў3!8ATIt[ ؋7[tFA5	Ƞ&G^±
p ±  .2% u0E= uDu
`{
% &ڹ  _^VQfS0Dp	
0ff;u.Q1 pY^54_t*Em$lPm%lQ3 늰0Yփ}4 _tbqqdl!m$3ۊS 0變m0m3
蒊m
 m
[ÁJlwE34_#PȻ'l!lEil`%nbk`l#kfPVWSu浉$0芉*Pu,茹A*D0.ߋD1
.}4u'?+`  B
 23._A16 ްs s"}&30pE.e@3@O[_^Sސ n [Àp
t10OlpSM24Y OEM INFOAX                                                                                                                   2  1COD@ P c$?c 2cS@.9c[.AQb)bS$dc$c! dfD&1INI??SQP2.N= NXu2˃	w,.'
t #ɯ.g 0 u.&                                                                                                                    K 8"              1600x1200  @  
 B m}P !! _]W>_  _\!
E  0W0u УA    CPL <0 A4P0   p
O@0 D ՒHC` 0  0@!Я i d OD  P   P`a0X 
|1 X&JS@ 0@A4= x@ ]  qE+ fw`e !UU  W &B/	m %"""M[
u`
$ "2
O  'H%A&T&//D)QSB B1	2?Z @H3gdM ʤ@`rJ
 HTk@QAD0& p)w M06?LL 0a Q)VҔAq#
  5?:   ?- @
!,$@l%߼ 3P q2N  `  o P P`   LQ` `A
H <G[< 4DP4Q  BBpmA -5?7p  ;uuR9_0 # $ oC NB   B rB     UR %aBq 2%GQ&_"*k  %=RB 3 e	   a?Q??q@EA(H?wH?a`6YYYYY YYYYYYYY YYYYY0
YYYYYYYYPY YYYYY@`YYY2 2 YYYYYYYYYY+YYY. YYYYYYYYxYYY2 2U22Us2U2YY8YYYeQY Y!3Y3YYYY YYYYY0 YYYYYYYY YYYYYYYY/YYYYYUC% YYY YCYYYdbYYYY"Y /YYYYYYY`//YYYY YYYYYYYYY  d//% 3 /YYY cQ&YYYYYYYYYYYY/YYYY YYYYYYYY YYYYYYYY Y,Y& / YY/YY/Y YYYYYYYY YYYY/YYYYYYYYYY<,UBBUqX%YTB0RYA YY/YYY 3Y 3YY//YYY./YYYY YYYYYYYY YYYYYYYY Y/Y//YY/ /Y/YYYYY YYYYYYYY Y/YYY/YY YYY////]{TYYY/ YY/YY/YYXY/Y8YT1
S *   4                             0R1    t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by   k   %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hؚc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Ph%X[ 3@Ĵ$<sAl r.ˠUr=O!` A (tD_rq XPנ"Q!fnѣ!ES  gf /u
> up[PȰ&  cB`&X;q!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .2[S[W>  t> _`W} v	0EAC r3ۉ_`?2St]AM][Q_Ϡ &
R`9P
PR<w. [õSrġؑzP `1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hιbar1TaP<u< <uϴp. .:.p o.c>`2p .>b:P	dn.e> e,À@p u 8r f΀g[ø0
.a.?&b΋p1p.moX@E2@g.*f΀ v&.f&˸ Laap7*kc.C3`θ0b  ϊŴ* # PQW`
 _YXR.i
 Z k@@ZBB PV}<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.qu#rp t
ArZwG ZYS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`o8u" wf`Ph^ @F F@ &} tC t;k{0Tta30h &=&E pظ@ P ^ X Wu-  ~apPfatQ@  YeQRW..| w#&.!
tff..A_0Yu..n_f.ӱ cQ޹R'@lۋ۩mcЛ{?Qvd1>+ r.  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.>Թ &_^Yy3	0		_Q @~Y!<8t	 `<PVt=EIAc
<
t0FXA{P QpRt @Qȵ$0<:|uFP ff PffXV	 Xi
Pj}^Vf3
f^ | Z  f`
Qf
p  >"Orf0f3ftY "++x fa

{E    1C< tN< XÀ {Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u}`< r 
A`< u4 _P&OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fow<A 70,0@r
WfU-f!*fP3 fXpfAN_ u#
%f]@TQ b_<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
u÷G O?Û=/ 3EPVWuצu0_UU UUJ VU?c!0W4#WU)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.)ۻ0IQjY f.>)R[ 8svp $h/ 'Qv t7H485 26r SH7z ueaJ2  UuQK蝹7e	$ <C EouA/m"' ;l  Xc3PQfR1[3w Bf>|@Q APBCD@ހQR0SmABC ;DpPOP ہR S co?[ QSWP).X.> uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s_ b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)WR<[ ]Op^?p.u18x f;tu_G2pޡ ܳ_1Sfa u<] Pɰ݃f   ~`4gB0{0t  t t !Ѵrer ZfAA Uta	$_`<`ut
*B5
u0
}t		 u
l. + ( @
r.ݰ

{ZE"R@r r}0MdZrЂB BU
a" r"<0P w  "
 B$<߁  wuS0p@ "8_t2TuNuF;J~ t> @ u.Suvtյ "1ֶ'
 " h^.'uη                                |x KJuII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ]5 7HĴJ!R:$ u#@G@6J B3tB  DECB@CЭZNBD r0`1	$ D[m rPfh j qbA$<+`mb+
cJ$<u	f  rPpc\ B9[ h_:I:  ώ  P O O 	   h>r@῀ hO?rA6BȎ؎zЍvߋh3 =o                                                                                                                                                                                                                                                                                                                                                                                                                                                          Ҿ     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                             8o%  @8sUv V ufu`vQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf{;Pf;fZWf!r@m&rf+Br
c`|s
wua

<1GM	jrrBanP蜗XPQqr Pp$SOs[OBMIE{/{J8O /0p`XE)t fat/+f %#fSfQ< t0Q2" QaҥUVt?$7 3#tc֦0
ð-@zWV@ ~WB Q Y_W
t^9lst6]V! <5u G	F^B^= t訔s.
<5 = 
u>9r? Xf[2P
_X^#WfVf桕0t
P Ecr&< u P 3B S f^cô PXs # 0#$$¥$PR)
u $R C'ð) 1U
 ? 2$
Ǌ4D O $= $
utpS  跭Y uðoQ3)3zð&pFa
!tt	*tEPQQQS&Q"
ǆQ[QQ <t<!t
<P	<*^Rp`@ ZQRs	 2
k Z3) ӻVP֎vS<	 [rqkX2A^a
 ë!R7 $VfW7 u؃ t?r
Dp<A)g @i2@e^PD3N|
u|	 t0  $<<q<
Av_^À. t" PP % ȑ *02u Xð2HQVWP 
N0X_3^YaQNpUPw2b趿߉ 2LB2`|ʁyChY
P'/#f@1OðWB12	RO@1 (S)ëT)ՠ Y"5@Z5. Qb	U27P*7 10016k0=D'.fUfQܐ`fVarMfXf}Q gf@ N VP F `(gf ff"f0f@MufY+A&f]Ë< 3+fQSfVffLfTfDf11f^[fYr!սX	AXf 2p 0/R
WfP&$Ot3  fRfZP_f]#^YPfWé tNtQG}UP2XY f@Pb YXt
 t$Nt%L  v n@X(RfVt c<?p(:VSQWiw#t /r@Bg$or	`C- _Y[f^ÞoQWV?7wy^_YSQV3۬
Ê^Y[S { e =ƒ   kblV1fffa.69/fff;w	rf;w@0S.- "  u߸ f%3/aBRK@u$ cĊ [Ċذ1K0K= <r <3@Ȁf
ffpff   f-   fPSQRW >E|3&G;r_ZY[Xf%aWX   1S t	t`Qf`  f@@@u$@fPX4Z4f4f Pg&>wtq r 	r
  u f_0p gf&^$f] tt,$
g&"Fg&
FI*$
g&#Fg&FJ	f#F	Pfa
`VR	t#1
t.
t9ttt&U&U2
~w	t
t11wtFt`?
t~g&`
g&@
p
 
u
g& 	TA1P a3Rf\&^q\QU`S[PS3賚[
PN0QX袚aCRsɄ3rr?P,.T3t  .8fPAMS2VW< Ў P u
 
  t 	˻ʆ0rr ɍv(F0~& O 
Rj0&_OˁFUWn1_]v߹
 ` _{^`<Z 1pIp  MB @ A$. D -&= @

.&FGvu?.v O.p cu#?' S/7/&+` 
;ubo/f3ɐApLu:00&"VkIGF`  u2{DF`sN~rSu[=Nuru3t

q0ؠ|fS h fǍf8h ? ` y0 / j H [v$p,faKf
P9fZ[A5f 0 [% ;tf fp  fI!!p_rW  de T q r7*E4fYf
^f :
xRfx "X0PX@SY5Z`PXf`d``d 诗f@`wsf<~fqPef%0
 u |DpB"_B3EA109!)rd`fft " Q0Y ffhfaqWf1fӿ0f3fvr tf Ou_!Wry>tpp ugKcK$rQKL G B = 8 3 . ) $     <p&GYÐP!>Dǹðd"JVfPz胸s @3_ÿUtp r.']'(() )))+*较r.f%w7f UCESqo{s@9a8q 3p9  ӆ1f!u%f#fpM@	ވLrNts` u=`襂߂a%`f#ffдHзrfP! SfRQ<t2f3Cr6
+Ђf 0"t 葁r(0vP uYpV_ta @}4
4t?t
0Yr߁$@8-t(r?!f1tY
J_?t:R!4?0[cs8Ќt ,tu
u$2v(HvG@t'Od-2xp(t+pQ
ay!-  t>ׁ fMAuB^B=ղ2A_3q 
t@ g t}A4٣ri/p/B/RZ/rGU/Z3t1@>$
ǰ >,s>$  `>ʹHZBVQ7! 0f,YPS00>7>F>  Sb >$>'>k24==>@=$
==  ~ ~{ ~!fP4fXpG	شPt [ëV~W  `_ W
t<5t^uz~r Mf rf~p5QRV3û g Kt
` J8uPѸ^pgPQfVWT~w!- x=EmsD@t0	_f^p.u.-@ &.q . .0 .P / #/a /& @ / /	 /' 0 .0Q @ о 0 @ 1
 1G _@ 1 1   e  	=ќHewlett-Packard 68DTA Ver. F.11 06/23/o2006  SqI ]  Z  l ~.q oKBC
sion XX.XX  
 
  _ 	o~AP#  @?  AC& U10 Intel(R)  z`   rnal L1 Cachea bi2e	
 E6PC CARD-Slot 
 	 www.hp.com ABS 70/71 79 7A 7B 7C  
    p 
3
  p/ DIMM #z2#ȃ*
a~f+"R,p `%.";/V @-No baty,"
0_8$W23 _T*u	 E
yjt)Ӏut&  5& A)u&u#
u! À8W@} AUU RtY pv;MuG	0bu< u3uOnQtru1_ ta0> S:u@!8*6R:EFu E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuEuѵ3S   cE>I q u	PXuP3 t5X랓tS%yE utut0#)	&2!qp=E3*x3;r.Dv+W+Xu4n32#*u!.7ð-*1!	 2X<Gr<Sv Ê,G߻.#]C%J u$
<.r!Lu24$`.2K#/űrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10   EAX= EBQ C D P@SI Q S CS= D@ E S I1xceptu4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N`iAvailablJ8Aou` Fault9v Reserved	10TSS1SegmentPr n12At0 V
3GeneryProtecb	Errorq  1 =  System Ha!P'
 t
-XÜPRQ'<Z 66Fup-6趿/vzI6pcPg6Yύ65{5t65j 65`fX/5T ſ65J`65A0Ǎ657XY_WQP66$Q6Q6p	6
6
66\7F
06诳t6]&6贯x6na7WJ`%7_o@b	[Q G%; I1`(0X[S	 m6N7ڟ p C8BBaan_a$at@0 FfFɷ͋N
~fE F N3 'ȷn ]
 cRQP~
XܹP/FFYNZ1A`QȴjY`ߊ  aÇً:"ߋԃ`ݾ: & G: .&9'@'dQRp Z
  c Z> 
G XYZð
< 
7 SQR  ZY[S r  `؋  p 9 ] _  Q!
 	`e葾a@ ؀ `
UЋ ]_a	@]3G
AF `P CY0[ߊq$9SRZ[` $<u 3 0   fa3S w\Qh VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYߋX0P@YP\UfWf&и`1fW~]i~f_ff_]p_8f <u迂 ~<  u<  l<c<@%Z<	;Q<
`QH<~i?<6<
-P= uX<`<~<pXL]WfPCI 2 u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYff@r_ }  {u
N`ݬoc  `] s r 2fSRfPȝfXZf[~_ff\>FZ5	 vf s"s t s t QVW&= & s fPf&EffX 褹 _^YaJVWPw`;t
X2 *W 
_ ϰ#tX _^!DNp sP6AуufQ fPfqf8 P8s2fYZu< uEuPPuuZ*APPE EPP runtime BIOSVers.1  
 DA[AeAAABDBiBBBBCC"C.C:C=C@CxCwU .A]@.].] r "R.]
ZpQRP<rt2[5$ !Ȁ
  -=" Z`5	$ =W p[	e	uR x?uR]@] SUUU.V	`&n ^2C̖F CUW	al *Z usà @: U PSR<r
 j ?Gpp0^r
t<t ).>wC ?x.swC 
0  0 PQR3쨀uAB$ԡ 3ZYXPSQ&"
ǐ%wX&[1Q \ߞa\Y`R)uWt= (u^
f&e&ذf	&e&20%%%薞a VR(txSR گZ[  oZ[Kwu? g-Ƞ%{%t%p0Q0
udbD9Z^`p(u=襓u8qBp4
ً@՝p Ν2 賾0UR&(u<[u7Gt*)~wtڶ
@;Z]PGbXU 
 s ]`K:KxSY {M M>rQ4Ys\ P7' 3Z[x0"#`"P3
ݸH bٸG Z(S QLIQK 5S
{ pN qM }# c'
(<Pd$GQGGGGHSHHPQ&` XW<ram .F_Swt 
' t r
2[e Du0^r!<i	rr&_ Qs" r2.F2& r $Às  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9 f" ?$ pQ@	Pm KXa\#t sq]@tfPadߨt bpt t
@uYм`
 Xr`QPPPtPXdoYQP 0 t	3`DXd$!<!tOO/O  q&@tPG0XP2 $PnP!  I I I   fPff  @ fXtfUfp PfVfWg]?rdd?f_fRXf[f]ge333
rVd4Ad^;sgu` 
_3 
sM tAt<V
rdDg}
^` VWd_^gEdTg}:
`}gEm `tr	 	t}d8< W<ytt@DM

`P@pfUf]3
t @u Ó' d.;Gt -._
pu 	fg6$+' +kp@+`<u
 @&   w>!@tA AuqPG@`  ,9 & XV߁  0`O_  r
 P<Fu u&s	 	u~A
 @5u	 X RtGTtu`6FtEuU!rPRtKxGr t& 0R] Z} FDuh>b h 
XuhD@rX&  U au@ ϡUt@@	 4rr
err{ dP ﰮdp $& 8t   QX uSQ^ `JKH `*C: E801a @g@XpRiKsIY D  (0 C Ep	 C  pKlFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M 1O` c!>OFK	XO O ?$OCD001EL TORITO SPECIFICATION 1c>QPPP  A " * Gxx  x y 1? " *
xx 0 %  s w_X _y\|[8y y {-b é uT ËEtذE
U  ]
r0 t
r,Àxf`Qi2tW &  l&E3ґB&U
&]@ &EL t DQu0&E@ !fa  }@,B C IRR
S8S?S-R;Rg]iI tIu3Iiz]n
Q uQiIY p}   P~SQ>Iu5ôPެ% r!<蜍3ɸ  3 3Y[ SRV;i&I<iXo蹑xt菬t#艓 |>EPI<tsƝ< tPx3^Z`XլV```u P	ir
- @Z،Q~P [=@ac
ulhIIwI2ah!#d-2Pfdfr?d@ߋ+ dMd5n	 J V-dP <d;]ttd|d]^  R 3
' ' FǠ  F/T3 .;v+GuBG
`_F/ {@8% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFSۻT׆[U uPЀAXd]<tp r
td8D^uPSQRWu'Es T^u_ZY[X`|&
yt,ـt&M1&G&aff fLAAAea+Íu 2࠰ȃt
 Q ܈$FKuðWB
u	ۍY;Y_׮uS؀uSu)4  ۸A  @3ߊ$f
πf BRWS22f0[rW\ u 
8sߊ[_Z?fQWRfP
t)P0mr ff  u 8ufXZ_fYPL r3r: t+a4 v 
t8t	
uY0	g&;t4g&Ct,g&Cf4Q<vf1٠
g&:# C1	 W܋޴r7fg&F 	f`_r!f`Gag&O@` Nb O Q_f[2p n l C   #  Ȱ2qð
%,pp$ztø{
 kаd	]2Vs s	2 S |0D= 6	 /{22 	À`N~:4
$ 
$0Ƿ B$2
X0XCXwXXX#YmY.Nt'}؉<u 25whh
A_pl1q	qsw[s~txos
2  "  |  j .DБ.ߊD
 l~ ``oHZ&&D aø0 м ` j &&E  p3Կ{1^QPTP !1XY`.\.T	ώǍ>I.ߋL` `aa.D`aaQPƌМPXXɎ6aU0V1V4V zP@ "$U-RBʿG      *[%Q	  ` ``Gd d",!  qa a0O 
p 7Gwr rrs sq\]
s"  
 6r@		 
r
 ۄܣU fJ諃M襃O螃{N#| fQdgf>0uf 0  > t&r_NVu`PRpSWff+Ȑ`Qf׸@Y_rfǳơ7R^f@eW>uUf sL_
f6ǁ	u,7 utmr>` 
谂XSWa^0Z@` u # $t$?ah@ & r 3u].]]3' $< usLhI<u	.] u<  _$\   tu u	V $
4 @S~@ u7`pP<wu[SpUNNNO =Oط$#sїc#j`___  M= GP@." **<00qs"|7PAbccUU]P U$" '&Z]óJRQ$%&ߊ̺ Y U  T+ bkU0`  u(<sW .o`_.82üP'XsQ[su..&߶+.	pZ@ t^P.&u @ u42..
t wjPUU**Đ&u XYC3P A3.G 
{XPbZ *.϶OZr@WȎ6Z0Z_ a
b2bfbibrbub|bbbbbbbbVS3.:au.aK@[^* UFPa2SF۹ S.aF[C N[QF ?tasF2~ tY@ 7} `  _ ø8} d~`d 6}Ab`0[6 3`6$ $ ut;6E6 6 L3
t,=
~
"=
 
P65w<t<u FÀ t< @ `s
Ê& 
<uaw\wWQTu& Z` u5D`'C6 
.萑Y6 FF;ސt2ëd`dnd7WdSA4NI"M IPOOSNPJaRJ[DJE@ZJ0mHI!I8IpII+I 6IlHH GG g}
3gE
 t "6ND  [guP2ssU I2NN  
$DQ&E
E   F˽	U9>]>
SQfVF! s^(2۹  F  +^D!8u LC;f^WVQCuKEA! p!0w $I^:u:\!u qr޶봇0Y[_SfӉN.Uz45@P[h@? 1iE1~u $
`&`ۊàfaRМpt $tЏ ȋPtZq1qr)}@dzZ߸ #Tj$JpPRZ!ط$0<:rd uP P H  = 0_r qw& fVؠ:зgfFXRyZÜ@t	t v
 vސt[h؎ Ѝv؋hh3  b SQN<tt	fP!XfP BYp}QѶ7 7hqYQu Y<u,fCISGu%f» f  f Х '.>6h .6h`PPS۸ @@pf.hi?O[:.hf`uh)S uhaúB   $vÜ.hu酰RVP
ۃx  tcPtt>@ KXSx$PnXr$p/Qu!$
BB ;/JJq4HX^ZY[Ϝop$ qy# R 3Ҵ./@32ƀnuo n Xp'Bp|@ v `0.uﴀô  S3ێۻr?40ư`.u WqP Wkf`1eP_QuXûpuTf`0D fft;  Qf3Y_,65 !? N1/^^w&t` $ueG&uFtt1]' p4мPGs6%xT0r t4t op #k2SWQ  d҃tуY_ 7GU0V1V4V	?  " yr_SYSID_  m` _UU  
 r
R3҄ <tZP3Ҏ¿x ȫ`VZ+T%$PMM u r&m                                                                                                                                                                                                                                                                                                         
    S    -%  DX' pˁ Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.yNZr# M3u 6Mr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 qv	 ӥ/H	r@e.		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZfXP'F#~r .ߍu7 u/{r?`. t8.>u tu x 2SrV ʀs`,N	p yN~t$` t u/~ǉ~ %"NV 1	s^Í6O.|uL>R..}N`>M .:UtaNaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVfv`$dD @؊f
@NP.eXfa ȋ}P	rs$
2

=	fX!9
dDfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZP$< - r!P@Xup>{q @<@0P  *sXXty>Wc * BQ	?Q	 QV  ?PRW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r_ rR$!Xt24 uu@uu`  u2&fPS `00v[fXPSpsWNp`D
>X`?D<PƋ4a`t a1t!$!"q1&2PQȻ`SJr#SMwO "t 
`P2:Tt
a YXÀuOuQ,9a"   <s&? ? `P93 >O}uǀ   N  NNVWi<ua<
uuuPx H<u>wuh2<t.$SQ\A[|u|]
 h|`jt\_^F] }
u}	 .Npcі܀}u	a`91@uDa0؀$'QV 3۬+^YD &!hfѡff?ffJf0^1e
c[ %f F PX[fP~$=r0&w) Ewfйu fu Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` vSaif`0ffAf k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRZ=A>$pP0Cf`rffXORpC{ZruAZr
`hPR2q4XZ[fW7t9 u>
rrw`Ua `UB a p 0`chQSQVfѥqf@j / U@PP  p^Y[_u(PUyFP| ^	u<Vf
EEo P pLP	r=^ uS@]#^[u"

 
 ^~u.t Uj@w`V	cL
 B8`.
u&* +u10$_Q=SfQfV  Ł=Ut<p*MPThb &Ep` `&ufރ!  \f^fYfmSUh &]S?^ ] $!w&&DDVp&? fȡ1\AL
^?rfWދDVЎ &Ǒ/ f`t@kK[^0 P &t_ 'f=%'+a¡f;ME `  Wf.P	Zg&G_lE!#3crR-u@T@f.>f_utf`@]S~tQY fqKEfp, g !fp9*g# p);!! U
UEG &E"9r~ifaÑ 'rnO}Gw|P_@0`m %؎`1# Ɋ \<t/Q IY<pD%PH
f߀u f p` ߰?t^ YPv.M"fNf.g
w *-"|"#:t1bqbP9DQ:	: ; 0M;Q.:r(G)uyD > )uf.p  - =.*VQ$$D
@V&T<^30Dory9
lY^rC0 ~u0>x0"VBqEvfZ@*}(ADϣn(8P9VPWSPWQNP
P@EDLDrna
fNtZ2KWM T;n0@fP: M9^_1PTN?:KffGWfQQtT=M1
Pe@UBLnALBRL@ GG^OWX!WXV1GWiG@(WLWWfHP&	3
uO`gdOp%Obboؾ:!Q	TQb-`#SSphS3Rq	)AUEfd#S`ez_W3nٰ `{Dku_qnhQhhRVhİh/hذmOS`pjj|~t= Yj,{A
1$pf[ jPQRG B㡀u f`g t/HMu (%$
ô$ƴƝ0RVМt
ƶ$t^ZQRf` u'qߴL$Ƹ $q$迈faZY fl f@f= O3p fl @ 5J  dJ J Q R UpUqU U	 Y
 U wUUABC  }SP SQ UR  SS UT  SU SV WSWXYAUZ[\1]^_  d` da 'eb ec ed!eqf ['\\'[[[[\[lOd!_Q
! YQ 8  ` PRS%o` +ð ;w[El SRW*׿OзIr 2 {Э3_ʺQ,ԴAs p Y ro3O:3qRQWSP b	$X Q쨀t_Y3l !`@ sX Jt	u}RX( V_pm 7	XAP)?[_YZð2<UuX
8
DYJ܊Bƃ   brT;
!uP `2
XS@
u	 ΅  *ê?超P8VWQPtDt!WQ?:t
Tu8v
Y_԰Y_XY_^ _SM_ P1_DMI_ -  #9E  2XPUv F t	F !F{fP]X"X
W8 ! tC"i &g +  pa
u
fN@  ]ϰ2q  S\8&G &Gְ 0G [ _!@   栊ա@@\&\p F0 ]
..c3 и( -  2P
C@@ XWP/<w3t u*p O $9῰F& .__@P eX2L$3R1    R۳4!f ufQ8fYgBZfY[ z<Ȏ3]Ou r 2AfPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ffp`< t``%a{At{N#|S{_V k@Q  ~{{ o{KǠ !qO F{G{G{u`{Q   A {h{opIRfW. um@3gдff=SCAFtV1G t fff Wuf(#3tfPf'@fXZB_32 p  
12OD60$0,{aj%`´+VlL2VmW3ST*F 3u6U0)$<!ȋKf`Z"% D	潸 %` +ڽ$нfa ru<
%	*P' @TO xOy er$DIsL QkOkO|x  Ƣ*S|eޣ?.a UϦWN.}
u.:utL u% vt>JrSO.[t O.[u wסt	xt_M_7EfUv"v t Ar Mw Ŏ.V PXF
Xf]h@ &A ϴQjw@!
t0? rt0n h
	OVO}.6y# {.t.I.
Lj@s&  |w0u [^SV#0f؁D.d.$ʋд^[w	ã3j0rcOt` 	OtOtLtDkOt
Ot}OtwOsy

{1xu	.<.}h $ yB%VUu	UpP`R#G rp
\Z@^ ƹfP<r|wfD Wu
 dlHSQVWUP&Br{ eXO,kO>y ..>{硽@1u Pa0 3B &G $ $PCv@&I`(US*B> &g01&O2$&GAX]{_^`&?poa s `b 
 }f0GfE  Akf GAB~ 3WP 1rsG2vE<u` LuRE<sfQAM}3  fYr/>OO.ǠًEώǿI_./Q8[Ü_QWV.>vu5pG<tFr=_.EP .&OW>M@A%50/0qَɎٍ6O ^_YSRt5ێËfQfS.q&Gf.OA_f&_ . pY2Z[fUfCTRS8f]fWgfǃ#Eg ^`ܺA vT2gf頸ogƃg u	f@w_1  @f@f_gf~1 gfgf0	}arfQ@;gg&fG7~;wf+f  f7gggfb	fפP#f}fa
t@@P	3:
y
ff0
gf3  P
@r@
A
@  gfo3fS̓ @{QIf#b ffyZ?'wf3f30n,;w#`4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
P#W!fكs À +SfVQp g46fFCYQ  Y`J_f^\ g&GCffT[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u  faUQ	U F @ E] < t@M
<z q`Y]þp4@PQRbfv2`x`q ^~{EqRZYXɓ	*'qr3`	x tt -  t	  i0{9`K]r=ss  "#@D@~p18P,Nff3u
P t  f3g rfF!b"XtԳ$PPTff`U^o3&fPQXYqoԑ)YaP'уЎ{ oP!8 #	of<t<Zx#f$!foAloP`dOofaQR3Ɇ `w ZYJB"<t$
tAJBՄqpvBa{{ݯ *qݰ J߲@P+F]X `{j . j Pv
@)Mf.N. tI4~r@5p3؊^)tuw t&Du .^^;YIa.@t&ڃã.^2ڀ36t6^2.  @ PSFg'.:t	tX._[X`_g }i &  @
ĺd@8a PSR,غ:3%  Zr-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋ_y苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u r}cwu
	A	πϠt&D@B êĪAT`VcH Urp蟪sʁ `-s8u fqt
E$藀Eab&G )
V Nh8Kr>u rG P۰o3F) r\ {r=H r8QWss #

Rr
3 @oM1 |#k###F("r#謲Qlr@rk20!p 7×!r"!F( Q'&d&K0#V&f)&t N.QSWf@΀u/ r)v{!ufPs 7fXt_[Y`<t;f3f t	f u
utǳЮf[`
 3닰pP  phf<	DPO   校F X @F$$<r$:u s
jîp_ _A$ 
   @`  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
F f%R$mPG ;By(FGq1ø fF" PXۋN8NwN 4o2NO0(`00s/ mlB
 r
fQmru$贀fY_/Ø+U+Ñ &u{%trpq? _VQB  BY^	G }$s
3
P&u3` @
r
%uètàt <q6(V&TЕup 
*&u^ô  較  虅QPXuN%&:Lr * r$ P @uP<ut.Ϡ@ ;& ; q2s2p$o<@t22P !$!信$qXw [[ĺ".Pù[K<P  = sffP SQ  !|Y[$p
ć F H 
۰N8tSFt f% f @f t0    "v   t0@qP@fX
RV s Z!
J
8
0
$g4 Nff`4eA fu4fafFDP2`a  tfFP; ۈ^DPm fp]fWzf{`3#"fF$Qi'F,0 AsrBrf-1fv,v0hW,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3of1	 f p N x_fր  pp#f#fѷfá0 fHfVPf#f@f+f;FLvLf?FPf)FL%	ffvAfI )Bwf*ݸff
fAN
Xf%	G,\fA d!`
;Vt
kfAP
Q
ĳ6"P  f%" ]f%  @"	 "f'+F0002FR) !.PS0? 范ffJDfZYcPQRWSӶt"X  3
舃[_ZYXSc[  QW @U __Y[;pû z
  }5u
 @ @Üu[8 0  ;Pa@ F4;@H0P ߈>%F5 N0Mst(BR'9ETDHP  SIMPLOiMOTOROLAVPdVS\~ЎHd:1P-ێs@^s˻ʆ" >1i>1͐ !1 #1~%1@'1iSR &-&Z[>)1+101t 00? t
@~Ph+؋Òc-1﷕B@	219	410`
61' 81 K1i؎&3&M<St<Mto6 6 
6^߃VRc?O ^!*d{h>Ufr hi Uj`lW@-nNhnUp-r$Uw wrctg>yސ {ժ }̰Z@g
+ 
r)>_1&~X^ádWV..GF< u^_J׺+ rD.\J0ERǊ}AZqER.ȊpMQRR źZR  ZYolR8AS؀u
RRp	[P PXE%
cE%	X< $Z	T
 
"
tg`gVW_wZwU
uQ6rEt> r2
tC r  r  
p    _^a1n2
u[#rVei1sCr"trS ';Wr6\"Q@
Er S֝)ܠ/Te  
 ` Pt ҮK;\	\*P')0\;#$ rIW("  k_!ڀP(͝B O55B< t%@r4;3r!- ,-Bq3D@D`ó sGADw*VR@ ރ|   t.Z^8ħP .;BBBX$JJ2JBPܰ\tJ XuS` Gr V tA&q JZ  C@A 젒*݄uP= ]Xruŀ2	
 y (8SQ2<

2ۆ.
$2rqd<w0
}u@ ]  ` w0    j3ɍ6N.Lu.:Ls&3.D}.L~s` 2`r2`Ku 2ǙPǉ u KO^t
`3t t
t
u! 3ұ u _ú t>O.|` .O u} P J}uL   u3puv`bW_otURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ]yÅ Q3| Ys. u&	 t	&Uu" ώǍ>I |  Êö澩j.f.|f@  3.|4߿I\PQW 3ۍN#_,`Np1(r p;`3$ &?t+aP`)}
t 	
t>M .:UǀV tMRң+Z| $p$u$$<t} t	^^ Q3䆊!*Vh O| ^t
.1uu
cs)t!IRڻ0W۵u3ێێZ
t	'u
u
 qu搉@s+XPt ڰ`V=z︝舟t"@t  p 
 ް  XPJXSPc .+. s#. sXPE&   &X[ó5P϶'->@/HAC  I@ σD
 uj@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& @	_3!
Pwr ^	
F (|r
 	u^'Ât %1+	d1*51}5r0/5Mrr[o[
u< r<0s<"N@PQN \

u' 
$nvf<0r
ݠsus>kPu.
I.
MȎ.}tj@&u |t
  ^!N%V#~sFPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 ؀	.EFC
r]wsms1I9  <$uw2 *<#"< u<}@v<%p!2 Æ ]
F!UF% &F4~R=r&@mv8fRF'P^S^!S&EF'f&?U&]rQ[P@ [`fZsSQt^Ë^6O	Aؠrf;	DE蠺~(LuTMs0]fPf}3fXr1Q}O.  .GTAfh "./0`3V#:Tt`<~'t9r0l졂EE&Oq<DD@ % 5I~@~6O 6u0fPfS&Mf.Of&]f&}k 
[!
A0'Qf*  r}讵rxL} =rl`x5rdPtZ+ٿcr@ O u~ (um-VƎދo^@tffmݵru蠡 Y荵r)8r$crre	rj蟵PTPQX rpw
u `fSfRWBt:ـ?f.EffffAUffsP-EMƿF F
tSuNff3f   fVoO0WP*f8f'w*f'F'*2t*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]s#   rRPR跶pPӊB@ ǀ ZXюًw 0oppB슱`PQK0% [ĳ m h謀 Bt Z^N軳rot
r`a r[v_">O fKf kO, 3S5<s-OO8L9
t" >OG<}P#<Qg$@ deOPQ0X h   t޲rzvru3rij`wNrWu
p`dߊع 
!ʲr.ǻ%a@tt t	tCHq% su~rt	 2PޠRF sH<t<)t<(u;ь>A u/WUߍ>ӽ`x]_3r0Cy`_^?a'c $PSR 2Z[`ÉRFtN+P X7D	F
+9CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuK-QfXr+tP@P3 Gp1 tff   Rf+IYÀL@uu$`Ύk2t
.vN^G fF! PXPE t<"u<"tlV3޾x 4Q&߃?s0  s& p  &_G` ` wG`  в&O &O`uRp`f&GG`Pa  5AWQb ]b  Wsa,ZX7RQVW:WtNᒀu~u .!w6a u/A ?L	
 t,6pNoAOGA&&d&D&t&ƟD3p;k_^VQ
ޡ} "] uRPO
  ^   @ ffTPQ@RP  4
W j 䎻<
1BQRs귄3ɺU?@[P.
X `.afV`f  
u 	rpCr"V s  ʰy6	pACaf^U쿃`@*2$ԉNT@׎Ǎ~WF$
&пFG &U_غ@
	 `1CaP[,غ*?3% p[`>W  De t2_R Zطˀ$0Z'`  dt
߻  v PȎ 6(f  T: @ DXø a2r$<q ؎ff	R
q b cr&d qdp0ff#f' \f 'f.4 tff                                   0 +>+۹&۾  36a sÁ.6+ѿ0GARRnFf3۰Sca"fV$
Ѐ
ğtf`=T("T_4%@ff2 WfVa  gxtgGff0XfVyfǿ    f  >y<	gzRxf#pf^Sf_@AWfd``KÇߍߖߡ߰`d$!<!uy@ ءP `& t"&& x<u&  V<` @K!D8t( 2 '233.f>"  t"   a2ۊ( Ҋp ) ǊȊ&)  * 븊跊* >+#1 d>,w0.- &>) r.. PRfUfPP>XZSQTf]Qfŝf]rPmмn跐 (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7;utF5R3< v
<ar5<{s1$PɎ|X0"1jrwհѾr9_2.Skq G$!u@t0<zw,  
t

	t
w
 b2]kSJ, E ?G@2q)Pı
 t"< tr0r	
2vPQs	} jW	j?ESHP  TPRuaa@uXXZXp! . YPX@ŻÜ= sr~su
0ޢ{ _߸^ SQwt.# ! !$諐 01QjQb;˂QN 3۸ K PU'  A G y   y " ËEup
$=qrq`tW  d_qa(  X  K P3`0W%,.s 8 ė0fg&'f Z{ Z_f@`$<t'<t#<?tN< uc g T M_ Hްh<u 5  %~l  
 aS Y#S@3xu@o G	u1ҁ SY Y@ӾV 1_ S!؀XX#TY^RU$	ppquX#A u ßHHB$tu 2a1$Bq  XD	0ffDjDyEEpEEkkr@0 *U0V1V4V%17   6  ~IG  #"6! ,@@b ZQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPk
GÀu3uuCpN@*  f  _fVpބuzzt u3N@f6 Vzu^ uzu?wz@׿N`R\p ShztE 8{uBzzuNzt!zvi
p 
]]f^eU  	     pVG$ $  GNa P P  Gh h"Gt1$  PG   
G   s$  U  0    %br 4鲂ET]                                                                    S A  kh  O I#YOO 2	bvPtF X .	˸ f&q && "  иf3  fi._f.]p >` 6ma  !ŀ.P f.""""" ! a
#
Ƚ 
 f3ۻgf+С} fP s fX   QRfl f@f=  u0p fl >@  t@&?   `%Ty u!uOǿ<2{f]
 N] d `5dPQ3 2W7y4rdr
` r`f  ϰ4py3ð?4y ?+  \.QuP $@Xu@AXe{$Htu
;I4
<RVWf1.1Vtfa cuQ<V V<W U   P tT `HafP > f 6B;s >upf2>f@J'f0dOf .> u/ &R"quk`a ؀ a@ u
_^Z2 =s Q̿V_=`ÌȎ>O. Sr@"o u !ZS3r%[UfQfR  r.fZfY]za /  b#V'
!@BѴK K(K'`1`O"bhqh5
ހB	D	v'¯`ofW`3sAq< uf,u#ǉǋp f3gf&ff=SCAF2f_U< 
`<! F ]  c<w&< t'V3ɊȈCF`M  ^ t	  SQRVV<v^.
tݬ" ؋
B^Z`U  ]贉U'P Xs.V Ou0+]A fr! f!j! g ef뙡"`u=&'|f#"%Q	r2t"S"Lt*@O   ["2ɵ"#Y( .63-ras\貽&D
V &DtH A 
B Gr!0rosužF. u趾$襾rO萿sJ*ʊKZ S迾r蓿r
r<a@yoiZ2
 0
FFt} NfF" Bw@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F)tЎ߃ r4F$
Ft+ F P  !VPXV@"aWPRzu	ZX>PRAtZXr* 5Ӟ.:f tdu 6.f]$PIR    A&~i j b c A ` a pwl   Đ  00H0rvYh
`3. W Ep
E_ϊͻ A2p aVWS;t@t[ 
D[_^RW3`  Q6E_uaSP>GYh /$_Z!SQV.  3ۍ6.^Y[X`Po
Xu!Po<Xu @PtPoa`
  Po@sa~~~~l|8 8| 8|8||  <<    <fBBf< }x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``00$ff$
0xx00 0 lllll  l 0|x0f 8l8vv `` 20`_``0 @  ހ<<f0 0  || 0p0  x8`̃ <l 8`p  x@ O|pH `a@
 
|x  ff|ff ll bhxhb `f> @py x p
pflxlf bf  ΀ 8l/l8` xxp$ x0  Px ƌ2 xp``x  xa"x -701x|k`` p 8l`0
@v!o`lvf0 ox  `9b  R8  ! vf' ?0|004-!8)*`2
6 	p&0d 000001B  0 v
! u?`f SvN .|Y2[]Pb䠄t"
   u$! ptq&k Xa TkhAE eMA9Y.nSS<  Ag( À
`3ҴĀu N <tDmQYR"mr8rmr
2:6 v{mZ aA1P2XPCI01 ISA#+T DA03COMPAQ 06/23/06  2C     F10_  1n؎h Ћ"`h+3f  
o L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.17mp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_d&  hEs>VRIW82o1d% = ۘb	Gg	 v	zA]G@VU?#
,
#&d% $2>d 	VyJ!fbfff_O
Nzd|dm)f>d1jut$QV`		zd		A	
RaUjf	gb	D@xUP
E
/QC
5Hx
Y2+-SF W"UQ?zdېB B00RgTPfRiS4z\4I"	~}"U(2y$B
z&&Q<x6({F*!h R9}d*,1d t<j9B=^9@1djQd$w$ 1fh  nG! tBt>dt	fh jnd$2b
dtfhaLbMQ >tSHft3 tE>2e tjh2efjh/I @:%j hdWP1t2f {tffhQ1>g t+g *$Qf3f
ˍ~f PFPh ]hg"f !_Qh@D~S3F``H`3=#2h|eMh |eodS V0h5&	?hf	?ƀB%=F-oh追h!	xA ,oFdkFdiBBhbFP7@ sjh!Z
	`#fOhgB(4YI65
#h=dV=d
OY0< 1%h+01!u4 VDE*h1nh49"zO	TPQ"D	q""^_ 2FF4g^ F&<
uI) u&*_&8HgtFF  1FOuÀы F FIuF*1 F*+҉FVh+;u;uàh% ;Fu	;V@áhG2@A99h% 
ÐL*|	
 WP
@Ffj hSC_(-{ f f0h0!b &b&djLfP1Zv~P[j`PqD1j FP轭`I:FG*"aPBqV=ut_ V!  )#GF|濃 02N|[a h &` F OGP	?	FNuFG0?7 

xWOw,HF/ A})wF2 1p ayZ2{u>_a	Ibf?%
2*2%#R	a	Ce	$
`
1do!d

dqGBϚ &]Rbx#@92[Ftu14FUB && !d0` a
"`R	b% +1b1bj_Rv3p%%zzd1jA` 	ay U
`h~Ќ3z""djD
8{ E
C @	HT	N!,g3|ɳ1 ji"{XT*jSN

 U.@Xd/j~a4%&ddr
x
x^(t1f"q_Fwt@#QylQ@z[p'8{
#BB*3 &d{/djTα:@(:d@w_&@d 8 f&dAO<_& &O} g _dv  0RUW HCPL
b fd@w ﷡d t}JBAVLP>]@_@b$!yy!p0^@Fh^F  ^F&F~
_rs$1f?&f &H` &te^p`h}0@ ~g^@ d2e@  f.# r
ڣ/ցR|@U`E  p  V6^aF@t,ttue Z -tT-uN&ff H+f .9ʀt0"Pt ߃ߝQ! V$
U+%U@@6
		! t:8O
tWeuUԡ+ 2@_&eڑ   ` g d !r΀&dd''ontD`@9".DF0 ֠  &dw.j `j ΂3
vB +#r]FsV
-`B&g(&g &g{5&ˣ +&C!&.&wgd r\fhJgj0:q{MB>~dK@>Df&Ef!FVD!Fdh
Af|e	s$U"A4 U+a=?rvQ3А)u1Df EfSF@tJyZj)$	>jgZ	 Df$ < u] @<@/"]"raɸ 1 ey b輩'94333L(vZ]f!2^0 0
t%rC`؋F^Nr'~#tp  u^    % F C)^   ~u +ËFVCVF6Ƃ6~ r~wt` t uFfv
0V32,ӽpIuqu_SI]][t

q ^^pM~  f# FB F~P|v^ KF NFFV~n @NHt@HtcH P )nA-Ph0$6^F&߀? u/dvA8>Re|nhXdΐ22bcV;3dv`fd1n`
NNF -$F8hFFoPjRh_S^/GFPv4F?hF1nP?dbPFa?:!Z`d`&U@0c16c`b`~2|FtFr(QW^
4~`4	b-2' _`-0w+FQVAFQC94%~ _t;F4FҔ0
_z u WV~vN^?b>S
A0@
^_C
g"j(c
l5

[t ,md(|WVvԋNsODRHAA~(|WÍ~FIt_~@u"2F#}HFB^F_&W} 
 
.APU!u@## KVDiaeҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq&'h*V~ʷv!^PFGIub: ^&^&8t #^^}۲h!#
 0GF N% }p,-Ar  ~ߋs԰ NFN+;u0g0>3ɋFppAFC&PfSpfF ~0gЋsΠG^AaQFp ~
?vЂ@xe|r
CVV,GV~^&FIa&a8}QFQ2d%"V>rQ⻐IBUkbf?}NQ2&%#2
= 	Ce	$Q
59"oPr@FGU ]ͩ@_v(`VP
_b% 6zzd1_|djA
  	ar (zT53djD	TA{@EQ2	C
Q{@	HU[
NQ;&
SU
	 U@g3|1 jiQA#bi~byz`	`xr@`(#0
7
{2
#26h BR5*S W&d{df0f   |efQ	 f  h Fd1n؃m2" 4 +d=dFr'3d0:I V,@s&zFR3#8ݨSRBZ>3~QxsVp .1rspς@>j6h`PjFd Meu>uIc?#d 2PW 62$>d 	u]
9Dod,X2G %]^@ْ`fbf	ff_؃_fzdPXX2A@YѧA \ja$BGI
DĪx2E$
C4
?
QpJ$H_rRNbUazdVB j)~SpF "4Vb	gPL;ip/#"~0PQOߠ}d*Lp997Fpر Cjh!TBQWVvqދ~ &F<t<
brF*;b}7Ay_~tF&8toFu|t<r2$VP^ƨu	A(|Ð׿ ~Pfh#   PF;rF f{?* F  F*N*ȁ vFoP0"vO
u+4g^F  FOuE	fDg &Dgv tlgq0  R &h{22`% u"h$< 2h%h1hu8q= +ɉN3h33 Љ  auh$<u~h% bPu&
u]f2 % D0	u 
uyB
 )g
u/Au#a}h%FOR 4g5g6g 7g8g	9g:g;g
<g=g>g?g@gAgBgX!Mζ f3 f rѨ9"`ujvRPjp- "`F  vB F¿~2|߸1~pƿF  p ~ uF|e1n
 f jtWV@"`FRvzF@ b*J*p
NvQϋWVm1vFFP
|Fطf-ݾ7h i,
'?F܊f  ҐF֊ft@ t؉FjRvv}qh 0-~St` s}uP0M2muFhMh @=Sh߀ FފfP;~xFf ju"m:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹڀ^؊GFAސB Z Bsư FN@F;u0&# д4 '@Op! a7aPjo?+*`
- e)@00 /NVZ"pn|\\\<\2d$S0    v2$j)g@ 
CfeQ@hЎvf`ՑU )a"*- t*-} [t94 J!13q$RYFa2|OCObo!LF m0#"7g
1(  GKEt?/ 3|
/@+[F+PR1w6pd qa"$ 211dhب kbb1jLFoP|j)"#c2#"#AD/]LDE WV3 W ^&@RFG|P385 2 R& KFWbA` rđ7<"JW>d mBveb꿢b6  &=  t@M[_ FtA 0 
 "+4g#-//

	
A@yu	( MpĴ &&TVP{S~ t'{jPFI  t/ u#O'jfyqPt= tA:? >u
f&Hf"f2Hf% @Hf  t&f`1`ul À&l YgdXgfhFf0ff[fh{e`b0b1b_dUU{e>uw[h hJݹP~h Z{菢p:r@juzBzh[^NA4R^ 	'"			

 
		I 	̢	r	B		2b`F&? t5(u%&|Rup )u&DPƋV@0FF"cӐfjfh 
 fh `  	    } Eq~  A u ˀ&zd gF B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Qj   8>  &9w&EU 6`  VV׽ 6eE   9~ H  ;py! 
f
>~ KĀv&@u?PM`^; vĴ 3޿fjth  <Њp $`  "g pvV>B  } vV*rF/^ ɀCP% 
Pp h
 h  RaNF
+F@0F!vvo} 	F$`NF@ hbj a^0CFPNQ=`?*Pđ`VW  p 3_^e #$` @SᄊFa
F$`A@F.
%
;F|!% F@P!]<!Vvܑm{`NPy`rFD/t&@A0#FlAQ@Pu< t (F7 PF@V5
 fp L`(* yBఊub~v*VAƐ2xƊ*} ufU  oVn'] ᚃ> t`ur3NF\ ]NZ&8tG[ vNً! ^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;wⰀ>
 u31&A *;t{r1A 
*`FD0~F
tҕn t" `fp0;
V=O`2B|@?Vu	.SEHDa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G^
uN3~(~ =u j  F;|;pUD  fUVNߋVv<%tF` u DD^ù
0NÈ u0+b1WQˋPWVFX3^tQrJ;v~ F^F&uF$=W\qQb]R~}  P+΋э8s,dvva!V0N&8 uN = tp&@*m 0At߱_mf6o !
`f_+IQ@bkqCTN`_S
ʐ kj ##v`j&F3v~Bǉv0Q&} 0{b;~ANuǋv 0dFA[  
`FfP0V6Z cPQ  F ~ ~
~?h3ҋ P{W t4hP^v?{ePq 	ptGW5o^"p j9Fu
q_sPK0 vvc#5+PFV ّ00NvD"F9F}+F- P@!b' $q YFF`%T"[ nT\QPEP)DPAjEP:P! fh p39> ~jy/0 *9>u	A
@0
A/\&76%'@2)
G;|2*&_ P c`8(F
A
j ]Q_j V@VRP=AQRda'P? p<	n@]c E +_FFVa#
0UcDSpbYg 0aDPdQ虡ˠXQ	5Q`,+?F+Ѡ`?M*2 R 3Rg"@=PD=ӁF3@**A;}Rv9s`V6rQqyg*@F;vwPT4C
sR14+

uK#aQCPedD&A84	PeV輡VP!~&-24hQRptYAS;}^`=y#DȰdf&D&T030`~
Pڏ  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN# b®PO;v}vǑa<GF;F}+F-	@pFF&Evo;v~Qm~ $	;FF	_F	} t~0Vg~PtOC tG\'F
t/* F T9F}\LF ;F~AZM
~~92G+F50%&L
q DFF 0 R `IϠf<@`	PXhf@PF^^EAg*T`X2s|Pxb<FA@ŀ[0H&v7QvFvwFՍ\P #R@~OU 3'tsF+FJFHfh iR( teTT4yv .9~w4aFO6,+F!}=pu.tpSq &OC@ +σQ._+
0|ctj[|Qu

F%B.=zQ j]> LnW0BL# ' OCA& !!pa2#$QBC}P ofZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "{f ;	`!QF~ tfFfZgF  F
Pj   v
u}O1Aj >PHPVv`
Ϲ!&wc¯FtB$P
QиN	VV2ٓF
st!@D% QDu
莡NQ
VQ6 B tD/u΁Ǡ
!_؋!bG C `DPk*. H!MbB~9>u	 rdP`G)g	R4O1miDu(+Huu @uqt j	jfh	m	"	PV^FPqf~
 t

>aΤxQEPzU@ ]FY m DVVjvv{xX 6G ]3?PSq002Pr~CwFR0B@UP1q*E~
G jR[807+$ }p  9]te #S#/E=/`J/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >g`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` cFa~9Fu
VVIVF]v9vu@XPNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3P P|p & !VN;
uڐxA^F;~mOaXS `
$~Du6g b;+|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F_| ~A^&+^& '_F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>jFWV  Gc Df td@ @ l ڡtEf
U|tATD\[u0Y;F~ ZprջN@uOup0
DUK=Np>|e u)>f tl>h tt >Fd t|{d yWhLb?0 Wh|p.u"jhbh&`ݠ
j(hgh8`fhb` J `h=dh`+ `z4 `}=" `m#[&`a%8 gB"	b f% Jfs% =dcz%	 +dS%
 4dC% "d3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНptN1rt߀DODpU*׊>AvuA*}HWvAPVtw0<@p& T}55446I5245r659h*i@E@ jpPVCpWVh
	 !V3j hD	~DX`HtHt}#h !    C wt^ ޤf	$F HtH?tHHt$" @/ $Ѻ&&G<P jh	G+P舐X
G>7x@n ^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®]s}vI@x	&8 tr
9GPu=   >p~5q9	uarf   ^f~ t  |֊FÑ!	eM	L0#	yKac 	3$0(`(h	ɽpa^p3&~/tC&  v&8 u*C;^|ckF^P9Psg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WiRr0~F Z= ?-
 - ހҮ<5 1 ;uJ< tCBtZPU-
tKŐtHtL- wt<17@t0- tOAJ뛐j*Q`
0 R~D@F	 0 % t" uN;j p貁F  Bܲ u
g~MN3ɻ~*^
7ފ 8&8u	F;|p,Bdn
eP $
Pڋ PPKC 
Cc!
d$  *8fudg"^u5 QK/	tP3`0F |n FP\@
t)f3f͹n @Hpfh 륐j  [a`5` 4*u @g3`p1`F0	!	*>;Ht  6= t	d@ &d饫锻 qPhdQu}&
:	`

 &
&
hhN
h =aA7B 
@
@rDt
{
@5
&

@Q&d&?dD`*gi*gA"  !`/F`a0H >JN
=@U$f'"%
aCDGB&HF`^  PZ
a#&&#!,!3F"
!a46
`cw$쐤hej2Pj x9
P߇8
PfsV֩mbeW$`0) ` 
ad t&<
q <3
x
" %1'@{x`
!l Ybhej 贬 %cbXf2f2	 `% _ Ps_RB/
I
$_*R0/($040/05SPRTRQ`Udsp%3W
$
A!$H*=	-H- 9t7-
v q@rMt%
- Ktp鄿-Mt r` LYnл= d.ߝ"ޝ,[2@0`  8&`0@'R!"ս,20z`  ؐPWu/qU h>}h 9S  9XXX
(Y&"pYdW a= 	ZZ"
@4 |ޱ
_!@ !`d`dax`Vfh0/h `ٰc@t&
a 
@ ACCC ΁!#p!
@d`d`
{ݾ
r42`+ (#+-+tp*tcmKt
- tu] &3& tuGu quhh
h !wu
j8%Aa>&A
7磑#'$''zÐj!uڰ @&
m)3bPf߼ PЍ
@%>{+>>G>d鷍'>n!>./>f'>< Њ5P@@m$pD D:E489JER4"" :L%9_
5̂δh?h `ҍu+a 5м 1;ut 3&`#S7A:A@A@tR_!P!Q^!>*aO? 6~`L.rࠠAL&`*a~?<!Q"Q QȐ*|3ɻ1n &ArhgY䥹zQp@	X^rQUUWtD3,i
衶; cK*amrFv!
oroVv0%@tx$P!]D$$T`
P#Bf~4x0%cAK=D=H=yMߚ*a;Ծ;
fhZ " [VBGb %^
tn
]
ct,W*@t>_tq f*``(@a@1)@4nAE,aŏwƏMQ W M- ғ6Tо╱$ $ ǆ0* 0p@
%@@$R2-6j2j&_ 	r$RH'
2PD
	r&R.i/Tpǀao.a6&P?As?P?Ѱ
 dzi
MlXF&  &"8Jbtѧ"L"#1p c Ap"!ab!a2 -a@y-a ` 1a@]b눋,a 2o 1 lf]b=}1`0!@c{!() `f,afd"Wfh[  AA0
Sfdf,a&d..+@Sa=6P!U6e >>d>U@!@FF%AmN$N@dҗ&VdVCD^^AEvv u
~ U
u3
um*
u!D	utud`u@Rf  ,ǈgrhE>RvɋFHFPVhP]Ё Xv
WV0
ܱߡ2ahHtHtat-L0L+́ AK!!IH
GGN7Vptqճ4%E6]'`C@E嶴;GVgE%M*
Ev
'@܀,  WVf+fF@ ؀  Fa^F趀 F FFF6FV`Fv4D>==   - -tR  =-a -*t:-߽ ߐ= +-  -Qt]}x$Ht/HtG:H@aC 6  (@ 1 ! z"!13 [b" (A
Fy
t)j 㐋ePdPfsVt9;``aQ63@`_!F	p 
*HFM~* f  fFvfvvFPv{<5Fu63F`.7˃~%v슅a :uFG;?F : Ƀ~ t
w&@ P ~^@&!U  !qq t&AɯÃ@ ׌?"Ht)3Ã?@ bbcԀ&h q*f>2a uuHj 
@3v0 R0Hf0af"f 6af aU V v 9FhRD" R
0aHfa3"'8-9t- 	t Ż`\
=  *hfjj a
 5	0u.#JNRuh ~Ɛ>a tuáfh  ]P	e-NR>V `6
Mh45zPhB63ab& V   F |b rе!wScA >p#u>}p\t&e~l62aGpމ U뵥hbte3b1y3
>6*}u	>v ׄ0!jj2Լ2tׄ;3Be'kJ t'z{80:2R%4;44j`pr
x zp@ǟಐAр!F@[$
$*M*tS?=<=5
5
p.Kx@a	`@Ba	 	 fh+rD-qpVp$#;$ %6/0 b2ebbdbHfP۠r ) d= $Nۺfg1 UO02 Rb
%b
^c
~߬
 }g
0h
` 
B
 Gw`ߢA] Dt,-
t%-.t,-	 tE-
tYt- t/pC DУ2a:B~AI _p}}yJ  oU<VIftfu& rA Ifwtu
P0t Hf@  -pʾ@ut@;>}`  Pr%/h8kpj;tXя6 ]HtHt `t' Q 軽hu
^_ WV3ɀ> N3һBrZA@ߋFPWr~0rHRNpDt  & Q FV^tF
&ud,
,,,L,,, v,,.귃>uh h1nh h  jh
Fe/"
@ts) 3҉
65P@;@)}F
r݋F 
7h΢	
J
Z0v4(W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|܉~*Pӿfb^?3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3Vs~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bpfbfff߳|&hPbt&
S
 WPx*t	xt`pNq` ^3

tF^&F!u	 z|03$NF%@
EP2̀n{GWnr\F*F+}= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E. / /  p- 2&b% +11b bbv@ 3 ֐j5B jh
!@E
 C
X @
/ /  (YP)@ wj}Q'3
^o'G`hh5؎GS.bAc_bh, bb$ a
0&
c
Q 
@DM
F@f
fh0V"z !`
p.pfh,-`*+() &'h%0blrd t0
Nd Ǻfu
P0  O hEo `F<tF$h"B by_F ۄ-FC|ߊFàbGcVA9bba!J1PF=dq`lLHH HaOeO KUcORUB
HTU6PDk^Ċ90SUoBEH

H
U>UED
_F \UXT
X_筃_	
RVa2C `tBvBet
B	Vphh_R5[j>
b
&%lZr55n3n*Ep"(-   30) +1TbPī*et4o// Ab[,bfcfLbfbf-
^- "f
- Kt 'Z0gpieeBڡee8e6P^lz0>F\r  ;,2pd  ab AB  z!"  ?- 2& k{dzt] dw@TĀgD -@h)#̺IC 늩@sڀ# Zj+z-x Ux wdC
AOF_BAďa ң"TzdEfzdfpd@ta az` h&CADRPЄt &hFώ&? t
&
@@T# 
[  B	@UDC
@zd:Qy@t&fh}~
"@~fhh
767tfh<":;h9
 !0 f12TA?@h><P*Rp	DэCrh[0WVDf$ < u2@pAa@<@u:e32@ut;> `  Br< hjh<1P66 b̕ u5] Dt,-
t%-.t,-	 tE-
tY- HtA- t/ZC DP b: ~s3 	}p  1a֠
B;_2%@(DF  c` = 0Ht
`q j  r j距`¾N@uf4UĿ;F~ G ԃrջN@uOphhٽtaqWV@NWP!
rvO^Űatet
Q &6BG6}@Gtet &.dph8$N(a.K#Ns&&PG&@d%&f%M@o%d%>rhxh81o 'Fs""b `& *䣿"bPeA u$wJT7 hZthRðT9  t~@ z` p lPQ j`,"bzp0u.&zp΂jz`&7"q޶]F±0#0000"\0000!&"lVfvfhI?
 JRu `nh ĢcF d:tF&߀<:u-FF
*0N&$  
u23q`C7 ~ uF	 F
 @L
 
 <  nC
v`
RA
jq<d^P
RP|
? 0
~ @~ tgh:v&~ tD苩 O=6=u5 څ`\
`
 ^3 FPPP SFF9Fr= @% -
 0v v sd ƨu@= wѪː ,8DP\̋~FP.acvy ~ t 4FPba    R F  : {.E "  e
Q< p~dzt'/ ~ƂOFZ&IZ#3^ \d.AhVD.t}Cq u^ GCauK  K .g"PzWI Nr@~u_ W    I @FqFV~!F^ =uF6v2N'22g+@]WV6Kh h`y*y) vy6u}tyH4H-H4zHSH.PgHQy72I.FI9AzC"ClIDzߡz(a
"zj &z<f+fF@ ={  ^V^KFP6߶bZ> Mv3+Q OY  l`- t$ fFf~ sA},GuhܠdPfQVȡbڙRPSQfXfYf3fffPfv`fF fh  bUڵ 1g Fvh FQP.^d PqwT/"m!TէpypkOE  p 4  V_6rNq0	% 6\bD60g\ 6,g|<`y賣
^]aÐ3Ð@p MHz` KB0SIMPLO  MOTOROLA  HP  1.28drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exoit EP  s! withouaving
o Securit@Administ or passwor5Cte a/"Po?wer-OnWGp Devi#cedeDgbD$L $s mart Card%G
supportTPM Embedde0&E
ta!'eA'et*ac',(0sd*authentic+
credal Auto2ceTools Ba`/0Calib( (`'lectb HDDP:lf-T2 op8s Activ O Mem
Che? r s ; l)l=mb 	>>uA(AAd_vancePaL4guagC lD7  of gray6field Boow1bD.E.Pres1>y key1J`I ue F10=
, EoSC=Cl @9RAccep/=YesSNo D, AoZ$r=MN <AW  UsSarrow
 o? highl@ *he appropriQmenu iZKp"<ENTER> PXbegi)WK%#.follow@M%[&:fc-> @KSPACE = NexR3c-BAC9K@vio"FgphTABE3i?SHIFT+&*DlF2@&10`
[J #'9 Er This60cann)bmU;d An; e oc^@G wh0t6c. qde 0x01% eondApGu@pp{6C>requi@yy<`d~kba@%mu0C
movP:  z e4k/MEU)hQ1&`0jll//J+2SDc leOsu06ssfulManu<Z rr  N0
d:Pro utsypspeItepp+CacVize (L1/L2)SQ ROM dd fgamiaseP8l nupi 	ViwdeovisbKeybooFr\06PverDeY1<Z2$e3bg4䠈1qa<ownNPhip<(TAdG
W
O3O 	*	jafХdai5El%BS)NZC*D$`1
2
3	ME$
C

V


4T!V
o
Do
So!  : tAD.   %FPA2d!J#bisFa0WalRXS0s&1&H} Addlinqe4 AlHXn.eFdoWarn: rk Tll0po  zsh᧦TreKa /, lef ea 
w0abLppr A: 
de` waqttҰ_)u րrnInv ȍOP
)!	%A you ͔ wa@|to  :?  iI  po`b+-c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1p3ex03im@s@): 30¾# g¶30%@v}}`t y ho#0#FuprХ:13't4	f-Unknkp{il䑬WR!mSer9vReaPS)doџt7࿸`?a}ribp	:0 `exP9 'bG H  Ol New Vfyc nY7Enc8Off O  ɥA LA66#%AKroE   `p dV
Ad1 ݰU@ҭ5Ocpcaus7p(@=AH"h` A&فOpoOwer-.A S΁Qa?U=> loss  (:dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHis9hR`ed?!0f]Dddi1al JJe HP`"UTool Cr.@%oF8IL` Bk g Uмn qpm`@jtWSN !arv0s /UcwcOP2"O	nj* e:Z%%% F@%԰#D
n -f  TndĠfӰunuR?*$n)tartBQK`fsra Par1yNsza $m/ediaaAl Mmk> ,n LANsQG CD-q0F yD!7C|U`	Q4 abouu}h uR[%_Q b0USERBMAST {a4panpR<ccUrEW~"keep iRaLephysG?p1krڥ  :mpcr. I9RBr0A#
", nSUZun- B5j JOO^1Auto!RcEdw\ 88I3?#ON> 
(R[_nR~ lFbur Ct@_!RF2th`Ss1rw  k e:dmPerMd`qaff+bdata,@`s7sibomaANnigiAE!V IPs[pl r5mmaP P Wu`|l2|,orepla^yr r/* @|4} [0uB ,coHA=Wy'u~me`1r, @MV`*ЪڰpPxibЩtyo. IfrdoTʄw8`AESCv.!
t V9 !ҡtyp#b'>'q`F10"qPrm,bs {t+  El$` MiBj.Q  Oru: U= ay OpX ޒDCgDL!bA (left`/hUCSB t Hq̱bSu K ZipoFir ohA0Fth;ifp Sixa h ENhASwap Fn/Ctrl!s KtᓃU.S00s>legackcҐH `7)n0=prL@ry Vo  d NTSC`AL -J -MKt
BidЬEPP ECPd2size 32 MB 64a F@pAlwaynPPi0ACS gWWD Radi AkBluKeth`/rS;chA Tg"Rʠt`Pt ED h*,..2)+p)c-({-&3EQn8)&e 12]3TokR!Hp
@kP	M3Unique Id"f$ (`eP [  *tu`    SӾ MCalibaᆏ6N st
PS DLA.Zb 0B[ HyO
@ELk MEUk'g'MRqN/@G/U[:>P1 : C g . `% ]4/Cle	2 zc1 di k-d3	ps
H

,
* A 5>M(4o!ylSp   hnology'tFYadapDPXE RPL Ex#Popupz(  0 _10  2@ 3 U4 5 6@7AF12z5 15`@ 3 "M.B ouchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\|OnzeigfpeicQv  Kgu4aobVcwCie@z nLqvEeinun	Ɯ-s
kz
.ignepd*nt neh7/N%Set@%SRheitsfunQk ntoa u
 naDlt-KuO] G?ertes/-$-ID@  Ot 7	Usttz !ր0pѕz#  beim /st
nBg!@M r5nHsvorrq##7..zurck@z 90
B .p,,!f_g{ms>Ui0'Ex|GAkkukeK tBsgewhl@DD-Selbs`sôItivS9#LtIprN 3g 0: tppllTL
PAZ`OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e ҀSePMbqTa>@0, um p_3gfahBj=A, ESC=Abb!#`WBkze!TJasN0\, yJa	=Meh`m VeZ
=zpMark"`s@{!*!'MenS% dPfei#lt!
^dQgabe2Rm Oq>ko?9 c:s.	folj
Bn 
sg:-> r LeGQ = Nch A\pd<-RBchritt-`VowA(Tabul!fs+ H-oll+gedx F2`@
38@= {8gy EschlrL@iPK kan~Lt 3we Y!eiffMgy16P=`?rgetrPn.Dc  01 L@l`fit B kqcQFY+<W\selomvorB]er0ilXWqDWeskU-KsBhmu  f 3aysbzw.2Mobi`bgptz%.`Qz q h4Bi///"2f!
}[KAlgrѫ ab	chlosF-Mll Pgrozyprtt` wi!g!60a"Ca`-i-Gre (L1/L2 kkapaz7it OMP{um"Famiks Sp; umm Grafik-Rs@Q Bz|]r-Con " 
A  °a?h7J	b31O 2O 3O 4dqV si H>(F `	 o	o
o1
L
t2aSekrET*@L$ƍ%'$b-!3Kc~(1  WalkA?Zero-T<One E"dqA`
PnO`+: bX7 st9qbislwnKp  ZEpucQN-/WB _leQbh s Atei#CP0&ILp`ak7 A:nfC6
lW$ge`KR/+Pglp%ɏ5 L  	/  M0$wirkQh"vQM?`3, daᱭ
l.^iewQP ocFLˤ01 ( anH12 (UmfafdIGc$fhrxdauP(Min.): 30ZБdS`@0% cgt59wuwm HoHPuy p%ucbr`"w: ؑH	ԑUnbeaaMTHC52'rvo-L5.
32@lhafAttribu0FID 2u"LS.M.A.R.T.˒XXMs K2`kwp eus~1L Dea  JaQ`eD>/t Falgebe
 U	ңBU5I<p dminIoz Dur1@`'@`|  mg1i@eFN1sgd,E.@"< ttifiz eq s{0yrt=.@s Zu10D0LzO 9p袓+enl@~.AjGb s0Q!np'PlsAvikceTa s ,ܠF$0@ h`$pga|F	 :	 JZtfa@npWUm Fun)S7, m3e\Wn HP{tectToolsP=c^ty ManagпUo-- c}- k QuickLockS
ubndF	r#q\M#0"e$bi sϢnchutz  f_-?1d@imd& "+aF A)N+ * W"$B>#, lp$meh1A #I Nk>"o3f`ot-.Parpen}ґ:-1a$P7Wake-O0ANS3TjmCD-֏& g1M%
UT:an 3A;ym$"rive*Fxpla𥀱`t=?PcNs E-A\s mY8unb{rapnbar.ƢIpT
f,ҏbewBBSHsXD,h % G&*0	M, 22\v),   L2me@nc8z@ R󡀢Begriff0}dmautomPw S79@>oShl@C i  Qکk`}p#tw`Z*f
 X'U!!¸t!mU"n O P o"a;)lrY@}#OBzw@痡58g<sQ}:Sn iU.) vduQ(qS!,qs qh!Aac%Cw  Prq җ+I sf0  qurࡣn׷hE .7 Escdrv empf/qS	f d?zu! цRO| t. 󍡟@  f.РYҵF&1 2 B 7 b-B`ntra tAdant!W hj`!@Esc-&Ll̠>m kW
'p'p`\ F10`esRh:
x3fg`g sbD} m  p¡@MMuBay&m )bBtghk`-Eb(linkCs)1tUSB-b#-02؆Su`1nZip 1`U234 5`U678 9`QFn/Strg!Ptŷ dEaCГ (USAtpf-ZePcB`iebss"unabhng`  cAr Grafik-Contr־PrimSek% Video- rn~Bidirebal GrPus Lfa`iCb0tzb"d}r WW/AN-Gf0`Blue_tooth9URanbp/a EgpaA'ggr E?'*0(o)u/9E t 1"20397ToqTR C?!"s vxa`13IPQk"o>vH AkkuP  @RtA   x a  Kalibb  MakaO  Niual a   O fm   O D O,tOTrat- ?6. .O .L`b4obisp9cOO5"R 0	Egn@OOf`.[=r 1 :9. % ]abblo(2^Entl h@o3 0P
Bm* 2a
  GS-2'su uĠg`RadapaAeBPmB`z\}ExpA-!-Popup ( .) WedCauQ0dW2 (Z   Ke`~BIOS-DMA-DaƁb@߀EAComp0ropstn <F1=Hjlp> |Dvoplys!VisCnwe Gtil` !konf0[GendзfraMz@PSrU
Jgnorđndr oP(fslur  ub,t gBOtnek@+hed Administowradsko3 K aodA7 for'P·`hEd`dje-i q		+	*
J	Sm -kort	Godкdelsf 7`do`_dbyg1gGOds -&2	 Nu@00fa@ks4l2 Uc 	 Dg
s)9IkA\HF% Ba.AX p b"d`va?lgte b&HDD-selvp^"tPr <Huko QAtrol. iInRrQҽh; OGH omv	IBr/ Avancq Sprog/ Vl1?s mo2nedtPt felO C4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=Ann	uaFs!3=JaNej9 "J, AR=MGb Brug ps
NA`RP7xe  releP %meWnup(,1Wt<ENTER> /ec>A)et.tafpr'f!f7: -> e!& MELLEMRUM = NlA<-TILBAGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!xhk> hsfej 8A3ku1i$0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krv ve)k`EnkIJ
i dd!?s^P flyMs`Èn#/MEUؒqoO5 bp* uvetzbru!d2JI,nemfB J@`  Prc cor-typ hBigH  ztr`7Crcache (L1/L2@HVROM-dౠ familie'i;AWdeo#f0pd@qs:@Xr-c^D-ba si 9e2$o`%3o&4Zƻ=apt-ta`oej1("WaCt)	O3O WEw !@ex{%IsrP4E$ TyPyrC%xy lydes!Bmsis 0'%bvD1I'j`e0je var0:c DB! se>  alt@P<2[holda po Pqt`/b Bb-Bdduw5,prI Pk
kE4uGrBA:t TUETfDF%v`U?gyldig/
6t-  ngivudİ,vi av٦,? i#K?@ $1 (Hur P)% Omf4`) sl(`{ (): 30˄2j  `1x0% frpudZ44b2@DR  	cq: KuB+"UApyCS8'z$ervWdLsrib?ut: IDxl#ZS.M.?A.R.T.5ܐpyCD@F8vNy  Be@}ft nDeae Fra@l !e@+ń4PR@{	s 0FC		ƈ4D 
&KE>  beviвB7 9!Cfde_s, f.. <GramG261 PoR.RVuAj@me+tabWata. D/u bu$AM flAX:Ը vicehCa D[G @ߒ[&?󥌥r !,ci HP tectToolo9"jK QuickpauN`LsQmP~ SkrpP!0rKvt%#k|qX)/sa1-$$ Hvisat ``w@x6r,
di ubilK2;+1ol p@frard )x Qlash-@$PR@Irn>m#LAN u7r  Cd-rom-p' YD4B H)op7hF:eIEAu1:w3h0zb,A@  Da$. l jb TBRUGER-0xOVEDADGANGSKODEN,6UPU alPyg=Ks ni  ned opMau,edS "#
{	Q|Dat l@po PWI_FQqShjlp iuto!mo0 0j_q@Fbyg[ao9b73pk perma anPTigz!ܑ6n?do` f;ys dskP:2ܠ@rbAupc(On O"0p	v  .Gh)Gne ugW"Ņ Pm/, som!Pa ck@
Ryt. U p~ sg/cҁ1  ikoqXS`.U  1befal kraf   ̓НFx|¬ 'A @"plN . \uqÀy
G񴁴  &cO.q#ar"J" 4,Q/d i૤HuA0.q.foq:@ENtr!5ESCq. t%@ܥ or| '*F':ge@F10FYSMsf
i/P D+s	  Dk Os{r@flgm2 vďRRenHPskm DS-bas  MultiBay (Kp0`/$hjUSB-flop#pycc{wbsu SbAwzip2Fr|aVTredjFj e SmjSyRV O3 Ni ̃ Ski mQm Fn/Ctrl qElPv(aisk)pege Ust!
u1PnP0#rm-cr PrimVSed Vo Out Para֎Tj@StrCL>ohukoP 1B< t6nr compu0P ʀtrm#gt WWAN-!sioB/luethМ/A (trdllo`~net0P2	pQUamstyC(Q*8*top+b +wEthat 1K҆23KToLR![HL	e+	 	Ent6gt id-Cnur7@VaP1#riqB  S!Ѐׁ   Z 9b/ `LKalib) nd!igO x 0 "ѷ YPO H KO OM\bo   O O#01ionOOOO$H
gs 1 1O O
1VTi bPGu"[@!(MEU) J=K=OOG O1OO  OOO[ TPq 1 :3 Oѿ@ .  % ].gmjt2 Af@FH5L)O3@	Genos	
k

, *  J/X4% G)' (FA qt @Ž֡ r| "popupsink(sek.Hǀɀɉ25f- b*Ag0P p BIOS ATA DMA-rq Konfigumas  <F1=Hjelp>`ilxinP0jonR sP s2{Laӌ$k")Hepfra6#:0@dioA	:Bk1)g avslu!QA B,lBDE;sprograt St passa/@&Op4FA|U)yrsi!vsfunku8r! tif׃@%୹b-
vn Sm 16 ׀#godkjSq0 nebAy`5i%itpt5auTi_lbakeAl#3fabPR g
i
 PE7;aN Urkty Ƽ avalg AlaQD5h 8>;vt Ak L MbT !#`]!@U3EGЀ*
`Hpӑ!4vsanpprlg 6  Dem75bM @\dtJIel\3
 .5E6o%<}5TrykkC tDaJ&L&i  a=, ESC=Avbry`acBAPpJ=aCNei rP, T\Rer=QM@bb `kY;neppilr@Ot<ENTER> hv ddu ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NQ&86 <-TILBAK9EwrigʶTAB&"HIFT++TF2@	)P= Gof#l ~WsfeF`  SPk'0`pZmnMop@5 P M0|m kjresve!@0m dX;i pp 9!obaRafly"@sbc^ 0d@ wAXa`1A|rvfull1z. k?ode 02Io"Produ _t Nopablokk-mll8 {typ Mh@igv&-ga zv$buffN(L1/L=2@Meng`	Q	enuV&@wo-TjrtroUS:W,kobgRi,oK1 qi 23DR40,p( E
1w,9(Q0 
oa
oA
o,
NEk#Iml`4$Eoc%Hq ok!i*ps(A"Walp9g 0sS"-h1jH(w Ad`ss ue7"~e PnAd 4~: DsA#. z tidlSCholp`@DTH[aQ "/he- M d, rnP}u1pf skl<2k`nn@ֆ2A:۲O 9b@Ҽreg1"i%HUgyldig#DS R`	F
	#NEEh0mtE b`?̀{]F igno3t_te?-  HN 1 (R nslXbP (): 30A3gggr 0$s0%[v\st!vhF_f!_: Ka"qut``樢UÓ5$SQ&eGt To(Les b'1Du+q vrib: IDf01rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreft njAv`l eP㰔1 qrEّjvlikt aDu!0o뀁C2Ѽ	aŤokag3ogs.rɐor dmpel&B Tp}?ّ.rPa(A=pYph. `bku  amK#0vice.0ula?eD(s aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l  ēlanppa0us L@$AOmpEr`i!gi$eu beska u"-U+/- +ӂWE%q  '.
 tgl`rh,v@=$8PŶ. K$RmEp! rfrard- Parll+vuFPhielQr/Pia LAN n0^af`z04  CD-%vbX45w H)o/:eD@ Gh0valgt5Arj h`($s6 bBRUKERHOVED-8`D:K |umu̅! E
 an_*GQFbe M`P
P  y "!$мa$ #
T,U]?	$ۆ P8P,pp  4qLL KOM @ autom\pDyLock5eabyggj]dT36Ac   `ma1ilg_ge. k_[h 7fysAad$0ƴpqtW  fo`?	ex ᬿaphn@gE_3s `dda gu»z. Urrjomd  Q1@0/e XG|pnq
B  uSbVnbefaQwr G	q.ҀAy A0k1Er &2;k _!R!'I7MEPsy-flAans NPEv
,x2pESC-|L Ѫb u"'fD'J F10$Zbe:h& n$  QNorR iFOrse MultiBayG]| "Qdn(vefe)0ko.ngsbaphhsyOBUSBeA|w Zip-U
A A0@AaaˀFn/oCtrle EAVd(USA)|GekeenAQel!	`jZtroA2@deoP@jpJTisarrPF3ViA7ti@`Q@mFgradi/?trdl@ |t@
WWAN) OOH OHBluetooth /-eftQ`mbQ7 Agss'styAg!1%%*2$ (	v0&#.b/! 1 Eth;?@	.-	3	  !R(@NT s*ooo/
;niA@jtifikhRRC&@B:riJ( K0t@  4 @6ymbo Kaliba2K B!es- Ip<pˀ?D/ual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	`nd 4oO	O	
%O	O	bv mob. a
H.\ L.\O	a}o
 {{O	B.[ TO: La. В% ]<afull"C2F~iH3
in/Qh*0 f!y  (o J/DJ/éiǋpkim: sin@ ~hurtigE (sekurxѷF12-`Df1.Sepute P@pRBIOS D'MA- rᐍConfiguracie la Com adora <F1=Ayuda> ?rchivo m%l Sma@QґPGu isco flexicP޻ Ra (s!^valoqp
f doba`y Ignambio7s y@lia A{  g3 @'Ln epidadAse
  ' Ajiciof%posIi s_SITc)$ +՚ @*VKskSm>Cp S)oQ0e*cP#x<) Sectyincor`% E0e" 30/c XP>6fbrI
a`DPVc!3nci])?AutomaHerramia`C~H er 8`#P(8` ;prueba HDDKc ' >OGVp&M?emoria2a d*mp.al`1@JNKRMu0GbSG#
s
 AvanzX ESvVDD
W? Fampr)co0N gr<1o?)<UOprim'q;uitec0g2)Pbao=, ESC=Ca06la==Acepv=SSNK1"Y, Co2	=My p U@{B$dchDha6al~  alemo apropiu=@[*<INTRO> z@ix:N1n.Fs{3pkTY :Esp~o o -> ?= PrxcRetroces<-{0`@a.xTAB S	S'@Mays+b#C(/F2!-910`rp"b"uErr 06F  No@8 @AiGS=r`jo u@QRA6K. Cdp`01Bhoay n unw>LэqubRnYD2@AC1+>bѪr(R[co rUD)JНebook/MEU ?IX1QP\@2pO`0ple~0Vxitosa4e Fak T1ytil TisOp7,Vc*lGpuWXTamauZ_0h (L1/L12Oc FAAwROM mil@cNmerD}rqibvisU!v@ j6r g-l@yo!!
/#j1l2n3p4 EOtiqurA!sI2Ve4FK (ga Woo.o3oopoi B(	Esn!*J8T 5:Z$  ProbUS%bssfactcXJ$ǔ =ll4Reo 0poX@1'	lnedi$l@z,
(HCE| oD"F%Ad  :vH uir-  eap. Preh#/, 0WcqscpY2#auA:'p, Uu c l@Qas ' Ӣ,Фhp9tegAң
S^@vlQI$\'vaPPa)00٠o(a) 8!@%`c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcunvtieej 2( s): 300go B0%&~Db  EaH0 _^`ipalGirumq
 :
 s,pu10@ qIQ{`3nh7Servof 44apoya atr{ib0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApkagE ndq9CS@gOB".Xt		@e voc"	k"alpa 
0 Lstnad ;`fR n"]e#թ9 A*# \A<Q, (02o,GA`bs (R6% Ey WciR|LLB hrpinR3 SIBf_ ol:9al ol`X#A!vu	jvip.AoQ  '{Ùv?@%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`jԹ\rat S 6""t mej`eO@`?:0d++-y	(BI	( !)(rALlRt0,"D,0XৠupizQ,.`xHvOre Pu°nP+rojo%q>lWS9rMLmedufhdem Iqdno Wa}k.n LAN@H& DtiRePI" AGCD-Q(mEřal)[Pm:\ Usio:
b	u4@S0S`Rrive+2dL$ t dBUSUARIOM PRINCIPALp1  oo şgwYnNman@Y p< 0|. AnТ;7} y gu`'8` lugp\  cjAp~0.1)TM @dk`\)h@G1
f b5@ ָ]@A"Twmc;N	;I0orD=
`> ʧ>1RnRsuCw  , fsm1$! RulrSoc,L"oI  /be}"<\s!u 3Ҁd/aMsRcuBbVt"B! ?p0~Pda$kosapg`԰6Se {oenf 8d@lic1a頴re!azA. L/?k 0u 񡂮`#PZ23a4=inͯK  nTBfixP8Z`
v\i pons2> cY_, pipԐ2? ESC. ΰؑalaubP'Fd'  p,F10:̼ݲwfGAᠿ'a7T/bEspaol O R3tMultiBatNZPa DiPsi3-p  ;]fb0sco+Ļ(iz(@jech`-5 cBb a1ЇШSuwkrDZipcpmeaewTer Jo C`5t x SpOvNo`DC|Us Fn/`Ts@ncIngls (EE.UU.)sPŤ (PPmplfSo}"le $B
Ғb!Ac@ G>eo ModZ"y!  Bidyic Tam&B#m@Pi#	fsifu0p{ BICA IR01ڀk*WW x{BluetoothA
p}{Pyhoйerg`sGCpoPos 6B/P:(=s+ior)ܐ¤Ethetw, NЗbooU 1/,2/L3/Tok0RdOOEredP23 IpStifd Exclus sAMa `  .a*C0g_-N0p[0SՏo `Wr)Xh!, o	o	k	o	h	s0bpkn	o	o	eoko	 o	o	 ao	o	<%MEU o	.o	o	o	o	U b2%o	o	o	o	B8[01 :rg". c% ]/ip걟	2 @c44-Cle0τ3	йk",'* q  9ODJ)o!qoh ~1bl䑄@zArr#an1pBy@gÓXDPХ1g2ExQ찱`  ŐF12QTPAmb@TouchPad u1o N uTsсr{ D DMABIOSaPub  <F1=Ajuda>rP0Info@͇䰩sobnPo Sf E@Ј?4ma DӲpIR0
rt7padr0
3>t  Ign`80airA	4sPs'&_1n%anL6az O DBr%& pς_`#ƕb!X _d#!
T
StUd"ԅ:liz/p ΉO
(Ib 0 ؇/R Q*Ag%brB
autQ<n 4d*cЮealhAlo`Oa Xc(SFeQmas@g1=1iCP8$!le,OpT HDD A1)r  VR#L?e Mem @PA<PJ  4tatu UQMuPY`G]⫨N Av8!S%,io Qa`d; 1camppJcinzP"o?CA9 P:ds`e qnr ycк'tin/uar i=' oSC=CelAce imNK!S, Q%ou=Maimg Uti0:psC	qqp'1yda` o i ? aprop@y *u@Tv#<ENTER> t5meRez[@o.LTgut9 ^r ub:  ->
PAO = PrxiK\<-QBACMKCExaQE06TABo$SHIFT+C%* F2 	*:`=kSC# 9nErrrOA@Q@na0WoQp܃mRHE. CdigTGo 01  NPhG`,@ao `qS)  s@ viKCA A	bMev
;ÔZWotebook/C[(RWS mGsTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/L2૦FX a` ROM FamlY  N 3sri
Revi=sSvde@Π_aJroQLa 
Al!D	Ob a(i34`Rti
ep	JIOCedt6(]){ 7on )oo.Oo$alS~ƕSecunda'$ 1rcC% vfoi"gv@!mO al  Wa;lk  0e g1i	a l-ien!M! oc0I@Advert: 0[Aqo3 vae!djWcqP/,!i`um  grav)vuu:e)xEӎA: n@JAdc NS3 >B^hO!QtegiEa	c]
vCl0IyI= kT@ctez0 eja! $,C? iN >?ý1 (Rp b27 (A@ng!qf3 (S.M.A.R.T.aAx`=_(?.): 30<`ѡ0@CT =4Q0%Ѓ?1$bucedeA,qAhostDCroqm1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec   `6Q3sM trCibߒLD`8AМexa@s wQUUig:T"grg`aRlPSLs   qL rB+ۚiPArrfDigcis gҐSAdP)PPtЉxacmod!CsާB! fazA@ArpEr`a,Έer dform!r3Dn4,Pja"0.@eHCsHfbrcau3sadQerF. SZ  Q[ea 㷑|2krvio 	1Iy0rqX)QT?%0Р ur@r0k
3ad`pis0S,B,QuickLock!Suspenso Blo`qtB" #u@aSM%p` ma@bnb1IY @k,$$al#.2P4sa eiSib0RPuseu sEEx3igU`re*PbM0Q+ &peGrme@$1lp쐦+maok6n LAN}e H!CD-"ίgGPh$qme:SGusua: VocË@jp`4Ca0yr2utzroDOrive) t@$UUSURIOEJ@ESTREbIS C(̑:q<?Yapaz=@L. AaQ4P@<de-ЧrPisPMEEAp"@. NQv p^֦*6Ye ,Y`+bN 6 0.bu=*6Ƨa !Hde`D.Hi``7D2{s1!Ei 崧O:WAWGs1Y 
oc<w<o  supʛHf`oo,ao Df7 Caaberi
a`xx}oW :aq(΂4`  0ƀrqur<Ǹ{@FnghݲX |af0@W | 2|,  p;) F `3Bvor nalp`a-w
Aa ΢atpEsubtud C~ ?@*hR)ssa޵ptA-lVJ/trWL !8Z  Lembre $՝vqMac`Pasa8
"qui_se`R ESC]Ō9q3lav
'f'rF10. r,`r:MrʺTPAc]D ugus Op1k: MultibayQYN4c`isi rBeAFpBa baЧcopld(RP ditzB	Rc"zipcPrimeir"rc QJtւO]ev@N ؂c@aqAs Fn/CtrlIngls (E.UV`ыxS[h8p1troaRءdeA^cund a@h`3LPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WWAN)`  oo`o){Bloothk
AAne(a/ E omCenergra1ereۆc-agRF2.11{5e/2o03su0Ώ3Et&netg	@O`p
/*3/CToken RingOO bokIdf S(b 6auaqW XSt`sSsCbGPdbptgemDNS vlCAw#[Duplo&	ted/	 )	E/	jON@OOO'as7AmO/	k0C/	cIAl0  OO/	Ojp~AMEU/	 /	-/	G9Dф1 	/	/	/	O6[ Etapa {1:rreg29. 0% ]Ojc3l 2:AcvN3:M* 
 o9ayCCm*O"(sDflex	`QSc زrydapY!i Pop;up> Exbp@ ~àF12(т? d>QZs Vara֧Wa N u`T@us`s DwDMAFIOS`i k0@{mtukP  <F1=Ohje>JgrjtQt Nytt vPbtu kP Tallenna levykGkee dk@on@oPu VtF?FQo02ej'nsW Oh  mu0A Plopq6Lr  ttpt7fTpo@ua{urlisu0invojan s@saMritoKyny]k La0tyl	
 P usnume
oĀ$-
t lykiu@ '
,(op[nu kiG
/`!(et F0.t13fsBg5*tehd  6OG" t!"$j;A)ma`*in@Tykalu`AH: o@K < Ki 3vyQtOA9 @cpDMuDPk!  a26npC:m -GDHLisieli Q Ik aec  ha
rll 110= 22gR2x#j2H%Jatkasinjot  nppd_=d, ESC=Per`F =Hyvksy=Kyll΃Ei CM, OJoku!L=`TY_ fnuoli
mip^kd@a h$@
sicsN <ENTER> mB7t
ep+.I@Kfn C/ss seuraavvU: ->Xi VLINPPIN =P|Zs  <-bASKELPAL7AUTEdfb1x!9ARKA+! hVAIHTO+', Fa2@
)_=  d@!;0virhvAkkoua e =oi>da.>: |Rudi 01*ka c1s} apHrt2Pl ypU eytke`"6ko>@	siPQlaksqкrs,RW` kaCt qlaaP^ TikkI)>skeytyi Fn
iP(pO2nL^oh0ebaGm"!|jA|}1?i@d~ tyypp iIn :fapllaVlisQ ?(L1/L2ࢅU~  ROM-SpbmЂkoh	tuotepe"	sar{Ẁ]`si ?stohjab T;{	!1:$"#2o L3o`Ma4mɭJ`Lta1āon7(j \oa)



\	\J%ѶkA'ra- DqACu0$#:BD$ 09a9%dzb~ lpi!iEepoi Walki?ng 0 -[1Yloso@Vaihtoe@ :uvi7 us: Tmӵgl atpnhp . Jlt luop2uos-  n,юPirjonc !KA: L"X AYhkuVV3 beFAG8p_Cpa@ ᣾
4GHkoa]Wi `n?  ӌ`/  0?4ͨ,i`%(N92R`3.M.A.R.T.@Arp$[n (min): s30-s p2y0%cL dv0 gIspysAi- 4iVgR
{fb%un!tq'c{K)jServomoo3ttj
Lu!5ÂLvtuQ	}k@Fttribti2@ЗŽLy@a 6eqKxe nGG9W UuEVahvu  x 	P>2Ȕ	! PC ޤ}A"+2@s@a	,-@ãPAJa頴n4-okkpDad`5an 	InDP -e@7p$Rmys@ba
`k"1h@` $ЁeT@ 	dE	ZEY/r i0Xj [!K un"Qnwby:찙p\veapahtum"b@^Cid FLaJ4tii l <HP PrpctTools`cuQ`Pger -apu(Д큶.f(-/U i` n QuickLock8fa hlu5qf,V "@PraZ&-Q,:*sekm #o$j$Ait)a{d||}yh' P P`0#UC.7>Cuu	SApor InfrPnR %!bkS0m 4em`dHert`3hiԐak0ʡV CD- -jl
"4[pw PFSjPZWAiot#@ebn De#'(stt&)|pOlla. p  /@! KYTTJN= PSSANAN,0FCN,{.qa!'0 v`"0*@lyQkur`V0< ribj^"#At@br
(V2[-(pY,Qpc`8`mwLLA4@1^q* OPQu `UoЩs- V
 suqIzAr4?Ii,#tuBx	 8opA R
@J b U7pbI r
V|}meG. Nyky fr`+raq~sQ{6v
t`i @Su. Tqtէ0$ £ihfQ{eip=0up@MY<eh? IPa*?-p@F|_Rt0HtaYb=c /Aojaiem qrtat. !WQsm "ftBTV@UG.2  !`ZXu1F_f0}0D epq0pǠo#\X2Css,aTESC-npsRVF;n,અ'e'A> F10%Y4aa({ :	o .cVQ llqt{Ƅys ubn MulotiBaOpc&JW!lakoPiu (en/$oi) USB@p)ZipEnsimm AbKoa elj }Vi}Ki eit@K5ak Y gKymAai Fn/Ctrl"mAȫ+PEnyg 0(USAUsPPsa !QB-Rsq@$ ƖnрjBQsCPPs VPo,t\VOakios2sN#Iguu QHDpl4QE ko@Q~WWAN-ruoHLOBluWWoth @/Fh` sdV߀Rs s:lPmӏ,1i0> y/2,-aH, (ylos+OGCO6Ethe!rHo2E Yoeo3o9TokX$gOohA workQc&GIlivA AkkuT < TJrPѿ r0jo^@libr ad Sual`-OO O@I OKblb_ OO O  OsO$ O$O$ vva_ OB  O1 OMaa nusBk PBOD OOOMb OOOO
OI[ e`i:r
йada@n y. % ]  ODPW21l` urpp &OE-O
3
GoMOH*  j  l9#`Fނk`qvuɃPiǰ@ (se  nA @y:@F12:ʴiP%3tappiQkoske@ߐ 'mma K  Ei mn BIOS DMA iedo Pot Configurwati5ordteur  <F1=A0> Fichier Infor` mAff age Sauvegarder sur disq``c uRa ,r P 'une.H_DHe0als dfau`ow du'Igno%modi Tpqu S%e l'in %8 regom	\ S?curit&
-e ss`Nd@ S"#j@`e sous te PKon.D
 priphP %J	a sE@IDy'As
D=r<LockXq
Smp(C0"Cr1P3r3  'he5  (1b#a <݂gr?e taR,)+5p7asm''us3;),;r?frencM =at"#Ou\ !@lonntLbceriZ slecqSn@psQP!s AIATAݒBFoV,mmoiricB DX C0ZZbaFB_V AcpLang4 ChoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gepu@lw=Ser, ECHAP=A lHAccep S0/=OuiuN*#Q3V, N'imEpp_e``1D
=8aw  UpЈzi3
s f'h	eM
mo!04ecle hmenuucer@rwbri 2qhz!y <ENTREE>2nj+pW	ss	sui/fa  !/ :!-> ou BARRE ESPACE = P"Be`-$IEpreced@S<TAB`CA*'zMAcJ+ix F2 =1"w-$0!S(rr`@<P<TJ Il FA%ssibPcQ7L U cs'Jprod{endp#B$P. Coa<'401!c5Cntв@-1 emplace( L' D SaQre@}C' y
GJ 
s}^ccueil dP "4@\ itaxsmobia@``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ Typ(0osBVwDb KTa@rcaa(L1/L2) Volu`e!gD  7ROMOamR ?Numro#p	Rev`crdoerS2ItryQclavpoLA}ud ;n+/Zp/zr3/t4n"3inv!/Qzi&5 #pGriF!L( Ute)OOoO@OOBV'edA Efo MT֍ :$/.   %Er4 !(SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0ifAFtip1SC[a=e@ptr1uA ieBЪvPR`! /瘰r,  z6{ nro°c	cY0])A}jDL_tv
 tro Pa
s
TX	  _["Rvja"D`dH.On m
:YfPS 0"Ӏf   +-vaPC lp  ߚV ? Igno7ꉈ+| z EnGregeo#=1 (rap`)#>2 w(coet)u`|pimjA(z) B30堿s pAU0% nv$D9ʈ<l'hA+bF@  `:˗	AsGimnpnud'+,`v`t
$.L"u( pG3p 5A`ib!O: IDP00@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAÐ?\/@;sa#zA Mar uinKS ;A, eecoac	;mme, avK*ad11POobPbat@Cs	eSd48D	 pe>a1a`(`ih3 s4[,P@s蒵 `Ug"  formQg-hq#xѼ)sJ.)rmQފb	hJU0 `
1AJ.6zT"`QDP~aR [avoupR`!Afr Cww7A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:eRy +Mar O4K8CF!/  QuickLockUsusA|$cp!ri 9 س<S&ol'S+C)re!c B!
`K8)!nk:,   v `qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`GExiAuKdP `  ư4raQ8llƙۗ&flashѫbWake On LAN\ CD-'EZpalj\:A99s!Ɇj$e Dri;vea-. SsD#DxDEdez "deux,&(UTILISATEURPRINCIPAL)`%H	xBalor@VX N>z_M A`I!!x&q%lsr `/qfe4Bcelu2*QDordqibf4. A  pTV	~(`s@dRZ-Ho r0 uDfetCu|MKQ"t"~"a"["qoip> >""B%x 0ՑH)@ࡥzANaniq4"05#'op#!2/r,Bcгǻ!o!  3pi\!$! !!{ e@^qQW֊a"%uelR12X :HLk" ""opa8pE*O' jW'Acbw# ,d'origi-nIlRv`OB$2C{a B	u
vqS"a@pAQy9Ipt0M倮
5dj)avs0$P~7e*߹-$WqaPprsP"t Ձon: to@Tp BRa1S44PpabP}t3ۥk'
Qyj, appuy
0`  ?ECHAP. @@@ OTzR'o', puiĀCrDF10@TapX 2 1xCxY^u}	UZ/qFrana
OgҝACJiMu?ltiBayulƍAph0A Q!3D,xsocv'a%(ga¡)OOFRz) U[8֘ USBqr
jZieprP:0 Dhi @s Qu9aQCin`NSixi` Se  Hud NeuvCD`Perm/r(s Fn/Ctrlz Anglp>SA) Poॱm1`s =A`stanpΛhnROd'ad`n elAtrlS' UichQ&m`
*d :i@7idopA񯁿Bid 0 mmVl@jEK!al $ R o!=ril WWAN (rǊse0il=)1grAdP Blooth7s0/?1   >o`$0@g`Q@Wloc <G `c@P!ZqX0b91
bP-n o;)2ooypu<	6ccumod4ogB E1t# 1a%23To=kRingo oU/IduT9-ar a[  2     h(% ll` n!Kre0/ x Ab!AF.!f*Dupk* /)///wb/// //**-///Jqgn$, /0,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Char. % ]A.`Ij 2D` GicM*n3@	Rkio.
1* T  @ @/M.$oOA$Ʊ4_Amor1cFe"5 RetardBTexpx `) Dж:a  F12tWposf[iP+Aux  PatqbAKw ucunİferts BIOSmDMA I$P zpOlr <F1=Ai> nfogQema
l0'Salva`l floppy%@AttoRiprina dnThhi@fa0``ip"Ignor`d!ed esci EP a
l'iI@Az eiBtupiczza^ sswo&e amDrato gcc3R
q7Z,,vos7xv@% IDs
@פ&gDriveLock	Pr ɣ+St =CP9 SupA=c30 gHg/o+:,i fabbr
4=i	/.nzi`[Qco
rui UC`b5<bae9E lrOpa t2;o roigidAtpaA'VP!΂,a me0VW`<HKhMiM;A>or \!Ava=t ,eLu!O l$Dim"& q6ca X ssopd geviQ gL1	vv!'#o*62wH8Premi qpsiasiesXperQVu L   k=f, ESC=Annu`,aA Et0qeo=SiSN@1T,altro#	=A bj Us"SchiavI frecc'!9i1 vocpu ap70e"_`<INVIO>  \k\'e.ipYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pB7ACKCE qc<TAB@C%o"MAIUSC+)XFa2	>-Ћ= m "AC"IErriS0D  Qut A87nppupvse@t"Vi  v@u4T|8pXJ. C{'01 N0u 0F>QQ9a0}oggiao Lk`IP'0 Q>re0
4Es"@agga%Fv0S!t`ғ  npabook"Qzespқ :\ ZҪf.atp_
2o{briu`Prf uduAA ND  Ti"+0<PSpVeloIStespp@YMis1ca(L1/L2d&dDbRO}MIamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~iI1OFk2m3n4ࡐ7w PVSTe)D
E(d)8
	2
3
4 D葭Fonda
 ,:o:EV$ Tr%OupyP!gTŒ@lliASpr|:bit 0t 1R?indirip	i] `| 'FAЎso:5X%? ?gger `|vpAhAr1e!0M/rѧ, O`1faAvi P}PiVLYXA:'mU[VA:"maconouAh(,_ IISɁQrita] N
sv@dpRDlIQOyളSe3 `cvoPga ?AFbІb iQfre?@?: Aɐ51 (Rap)62 (C?omplet"2tio (): 30>0%Q5"r6ar0䠈'hD5|:s*Щ -@
˱֤(aD୆%aerv|")LċAPLA'	rib i0go=l: ID$Ban`de@z قi S.M.A.R.T.!ޱuT0U _/wordc(nuo!i2 pDsc(Ui%L?Ibq+d`! {â"Znd ?՛O.A7Tącq^B&
Am  AVf!B;YpCr	t>J2fuDm y3CePe<B #u _tH`!1a哰.Q]ՒbdFo8!erdPКatiwEff+Jizso@in  ca2ivEvPgarζOdesХP@Jm 9Yy HP tectTools O d. ZRV2+ ickLockspen`3B05EY mou`s8 M@M d?#<#,p  gra`@p'!oe - !e$C-))v!pKsm@]0x!! b	,'URar i lі@NR(@|ГV|a infraQ)p y%La_hflashBmnQsVLANp Off#o CD-" Se(P$FZPp:[ @!SRQ#3ĝ{usanD: e1*. D:AJ$@T @@bҁ['UTENTEPRINCIP?ALE  r@.ਰa m3an8fu`o. AnPV>FgP0v  a%eQF@p0f>0.l@h0AAuYPTk^s,bh	Q_q2L sabR? 7reDZ\f.APR A Qco0%9 8 P+ AB.`D
 Brea,@q  d (`<t vOH r luogo DJ T!B'     #l$ j@IV#:,!vI</ sI"I@5-"÷[tClz s"o mP0!R/DeB  /$BH @æUEa(  ݰaDA'Pa gQ#QAi  	Potat{fa+ ueY/ cdO::l}&.2rPCqu_{9㔓!. Y)uA`YE	snOP䲅@K1'56h,mP킊ёo ESCƞM9'v)dovQr 'n'pom!nF10. !n!k KWyȴ_6\%זPt qIP(i 3G  OA:D0@ $dM MiBay ba1.ggas$Z) ogC}hi USBޘ]$Su}k\bC
ZipBP6o ;Terz `OЁvN% ec AС" Fn/?Ctrl TIngl  (OUSA) Yi u`2O mpl 01asciЃR7pl Ua  0а࠰Pפ Bid0HCapa memqX5eImbs"F!/l@DQ2'c/wNPs (WWAN){oBluetoot}hCommu	ZЮ/ (J)Csm energ]hW'Ng)1 N,*2HIB-Fa-(F o)ol/spo Eth`etWJ V123e Token Ring p!OE3 IAkB|# "Cta L   Ao(  C02b// WD|Saoo [Kvi0Du0V /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@NzupTras   DMA BIOSup <F1=Hjlp>rkiv {Sy!~infotpзs~ S. pk%kPiguQ 3(stll_ frnl@Ppn ard Annua nd`` ochsQl``   np͑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID 
S ao
 m`
Rd-St?d frutsav 7K
 byggd 
usBi=*abrik`m+ .J
sbehrig#Gskts@rktyg 9Ko +r vP6 S`;vtiGHDD Ak_V Minnes:" @01q5Q ?@An@#B
S oVlj4rD ;cBnedtolD!v(C-j+eTry@SI fri Dg s nr? du viJPstyY=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	e	/pCa PyEt
<RETUR> oqm6
YRtt .ke,lj`SeferI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK TABf#O`KIFT+H& F2``+?|= 'fO @% @oi?Cfel 3t g1qL @ kA t h+AO` Dstod uGen. F7elk0197
 AsЌgF{P|plat  NtPhm krv3? pbyPgm0 fly5s t6 U-Por/2 ex䚣(|0Ytid#igooi2-@Kkl`TA UkN,q  Prr, ty=p
hast^hZg0Cap-	rlek (L1/L2)Yd RwOM,um  ?familjr?enummn0D/deo, rYȓ ttNb ~pqyrQ!]H 1I.z2#3$4rbinv0̦3 (
bZ)g	1[


Sek# xIrq.4I$@gaxr%Ex!z=ok!pvidClmissl l.s Walk0s - T~P f1jH Adds l)i7AeޡnVar! D@/ѹ  x7neh g"Ccuskap*ay /G-t۱xiƱ=k b0!h$2AA:f1R K>#Rhi{wIBB?skyddadag

 B Eˎ҇pA!^Ԉ  d|? ig?D܇jGa- 1na#bb8pf@րީn`X9UWk ad k$pQd }(0): 30@npan 2?0%bX A4Pp/]p9p01vr kMatPo:,t	!قOk%S(x eorvo-Lz B!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 G'ammN u7. ifin0@ D> Lܰ@Q R4bd% pm}vlika mǄ  'InE?ka?n orsa@3iЈP9aHSsNyapPO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;els!e- @^uQ"uayVq >fun 0`perl^7!i HP tectTools%٩R}-6-Quicka"q`telgeG Lp׌mP<s Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot. Kж7Aom4pHi p@1%f   Pk`anFlash-@: s!Wake On ܏ fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhrdvd D e . A1 a@`r AN}VHUVUD$} ɀma@tt .^  P1A "RN`x ild ̀+A
 JёRh vpyL l"C*lqJVQ.Z +oI XqeDGga2b2bygg7ZSY3 g 5//b/dA\J8- F`"Za`=om s-KeB
C:d@=  At;asBG@fj'FB] ktuaiqafaanasks .dIutN^tg Ps0`AYq,vїursprungQb#@&MM. Vi?  reko a 4F	c	Yr`+,0s@ b`b . A `Kad΄3@7_j &g`!b(gAp|O-befosesm ih`pґVfljgns. Tr0  >ESC-rQBS֠ VƁSw㞑`'Z'R-sedMtaGF10 cVi3a:+dshc{ Svea ҅: N?,{ MiBayCgrut opBP85vi Ba&G (`r` (h!SBV G Zip-=PW AsFjQa utto NpT VxFn-/CGtrle Ǔ E lsp(USaA@bmYkd0! b`n`wrmsPtrorx,& hbbelorlekheo2nek0!LH!BIfs@ʻiotrqtK (WWAN)0Bluetoothm /() -v@ĔmbeQ Agg2s`haE(-21,2vз[,pp`㰽'aNed Eth,& 0	3n To!RPN "!Unik *@?iG K > tus   ,   Sbo Kalib@o  dp~- ʴ F=s al Q.O
o 

  
9
Fo@ 
E 
D0!m1s
Aoo
E
Hptag *o 
P* 
VC| emoo]A*5oo e
DIO OKood
D?[Ne _ :w Lapr . 0% ]
kWlar2uȀj253omFjOFA* &V@1  >I*O!DgOЀU®br@>4sadapП$lg rdrjQpsnabb0 (sek. F1 Bd S'tyrPguIOS DM
Aaa˰"KBen ieהe/  Op Teslaan Configupo`anafPvtndaardP"/  scy	Wij7zig&ne Pprogramma @РSetup  z1r w܃sveiBeheerswachtwooޅ
 %X. ApaatbOg|l$$ ID's 	gaSmA6CP  Oa u"5P$c"R%m@j+8%O
GeX0@gӨ gs;svzie܏"Fabriesks.ugz7@/);Vref.s:nieuw8OOc  Ext`AccuxB 4\e0P g?eselec Eia p`Es ? zelftGa [-schijfei Act 6vG0u `?`I R!a/4UBgDAc*g@7n ,DP=%_
 w 9aKc!: Taal b  =r/emP 	rijsgemaak el=;o" /;09
8ukAZ@ ]{NMLg]g=S, ESC=Annul"EbDG0=!e!oJacNee fslui@Q, AQ-f =MN Hulppijltjkp`gebrui1Ѕd )jui`xnukeuzk@ark^<ENTER> ind 
cr]be8Zo !vol%@@0`1  0aiX:  -> of SPATIEBALK =>`{<-BACKCEVoriglɸTABb	#>HIFT+%%|2+K= ykp=t#<B~fouta6r4k p It w_3ge15 F0MvЌreqatijasen. AcoZ01b a0.i1ZCu  we   Netv3oe are0#F0MPN diVbas`e3
 t n0 notebook-pcI/AP @.PistNOQb;ep*igdooh2L	MЛa\ft NmpALyp6roce;ssBnel3Q̷pp OmPЂP}e (L1/L2 Zapac?i VH^ROM @ -es!fSP<mm <E  Hebvrgav_0ideokp&p;b  bpM	m	ra1b2rd3ďe4his(gI t}.jne C(B(ЉwM@dzQ%) 
  `D#/SecuibE.aw~~@$DFtbd%)҆2!dHU2L53Hac-0-*1Tho~_adresrlafwi}snd pao=LTop: zPt<ts e'ge t3 PSBbeЉif s d1 A:og-  /ޖ"x0zbLe6`NoffaG1Y\f_dقڑD@`ѱ

bo
gAt
wXOC'We nu  Њ"
'wil?oP""a?Ox
Zl"+1 (b),2 #(U0Y ) Аpqwrpn (min.): 30aee&p:vL0%Qtoo 4;q{ho8:5broA"):]eeqx/nb!$382#kvo-IPsEI"
2"qk:J S.M.A.R.T.1-af@APP@udh "/Blo`!  A  I-7B4kXqc rlpSX8
 Vr!a1& .is bBsAYoCf#/k, Tm]lijk0UK8Qߛ zoik` dvors:ka`?0QH fQeksKPugzet,r lorZ@¶ZObJ$ uswb sqwYfur9houd'Hi`!  AQ`R`T`R&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k"  p?gspp`b TWm E #4M"g$rgΠ9b   ~erX#W>,.(o(h( o( S("7'EAJb"f k> otraakP)5Gw sXbt K;?ݳ ]Q p1׀frazpd  Parˊ Flas7h-maluIr=dem?ia LAN aa7hӁ@r- Cd-r gHNѽf_HoofdZGw *I  U15|PdeFB`DL`#:@izow.HOOFD-WGEBRUIKERSbPՙ  p'anA S3C  Hgw!#N$  fykkvcomp3)AosQ1|_0)t D 졗"g+Яq.  ]0qp1bAutomPOc8>}X @r?:h^ AA_<T< O!V)?!=NPSSz! !. Mo[iaQnoS4H,P   n2S8PȒ`VU nt@ TAe.b/ |@hui`,̺dЍ wwas top/!k; wgeab.JԻ7[!nvloeC]km\Wsn  0Z^U4r`ra=8	WptorH/)ڰ "gect. o
 s  v"N. Omun
1]A&`3fe*&agolpq. Au_ر_,ܥCDyAbhl  $cӲep3rukx3pESC- ( A9±i 2B'k'tyUbkn F10 @T*ZĒ`luS4d ry`V4  NEePl G g MultiBayjVzakd@\base (иks)re| USB-Մ cb+z`p- E2 weHqVV@{.aZes >ZÀ>Aa8NFn/Ctrl `Owiss/j @enStaµMcW3MijsappĀqOv5e @0qՓl\Bij V o-qPF`A/Aˡ0d`ditwion  G@vgp<uqVPilat`E?"Vp neVd$` Radioj WWAN-aofoB/luet@h`/o$JrgieĠQ [Kq^&.(ba)cEt̐ I1
2
3iTo}R/- OMobo!0r23 UPXuAtcuI< q6us X    S#a?Gekali@!1OK"2
qNeEualR \JOOCOG EZOOO 4^B1^'OOO H0~p aAգ
O$O"Lker-MUE-$J$OC$ P1q+OO+O  [alp? 1 : Bo@1. % ]/& p[0d
2knte~l/{	3	˄
 fohl/)1* Jt  ;@>.C,$"q $#aXadap PҢ(sec.)pop-up bij snroC aF12 )Kbb cursorytuyEasyPo-muisG>1 DMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR h=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ez]  e= >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"OM пOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 标sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPuA0V @QlA [_ۓfC!N7Wake on LANh CD
-Pu3(a $} ^% V:`%A}UK/ (iH b'C3ye@~Q |`<p'	8 >B`/Z?AT? iR1"i	3N	iEl K	͎W] vpR@gsAMS#ۊtK@P!K/,@!eF|e\ ӅJqAr ߐ < <\0ۏ؊; "łb_͗L nł<`k)/)%)Dp˦ Z 7]t.z"*FG`nGKa(o(in$'m@_@] ( I O)F)u
ϊ((?(9(ágDxt${#<43ɑ`ƈM3 f=ɉe;^@&A)F1j 8cB  B獑BAOȑO"Ocĭ(2ef̯8dwql@ӔC
aU"1/g'|EE[Esc] 񉟂@ȍ~elAثm ءT.?DriveLock t[F1	0 MS  y _Ԡ7>`E: ESxtkGb@ȓO xXicoiEcUSB ӅAXPXp H Zip1ԖW 2b 3 4"U567B8910r Fn/Ctrl%̐ؑ ǲ@{`\p (USA) `|B#foX
KV&ds
v C\gŉ  }ZJ _ rIo@嬧 cWo%ACY Oڑ͏̧p복blNi!WANj%M`Bluetootg /#jְߓd `qIntel  Executi@Disable`0ԯ..1,2O,..odhEthernetMX 123 gPq
AOKO3O@$OFj) I+D P7bfN P     ' pfbpU?k ej] o \(%*nP/h/!!8!MEUv $)o |!% OOv5bv1 : [d . P% ]xO<
2 !gOv3	Ā	)J*   5$/?sЏ'O mjvSpeedStep technologyugh 	_PЯ Ӱ c`px(bs) sF12QԁibyߚҚ @^```b1[Bq @dBIOS ATA DMA].                                                                                                                                                                                                                                                           ` a b c d e f gt" M           	 
    ғ  
         (        ȳ                / 0   3 4  5 6 F  ( )   , -   * +   1np
 uN % @.   01n1nP1n$1np+1n 21n81n ?1nE1n@L1n?R1n`YU `@E<BoB<U> FبE0`8l v x|v||p0p7c g  c 0A   = ~ 
=$$$<   DD_D    O aƄe  i  o䔕 u  y[ $n%Ap﵏ E%  IC&O p   Uk A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#j|od^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ?] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$: |  s+'()+'*&`83&ď

OO
\()| O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      p]g|1nA  1ne^@  .@  b1nQ@ ED @n.W1nL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
1n9 Re1nXd1n2b1n f1nh1n@a@P  g1n@W{Xt|dU Zrt}[}#L  ]~&  W_t`$itVa!
U	$
\ 	~ 
`	U
| `
`
Fa
bcDdeDfPh(>{&&`1n8@ b  * @
 j( {
( 
r_ l0 Mm | o_ : *R  	1n$ $ 9 D VF10 Setup Image_SETUP  P0Sq?  ; 	QdP" *Rv@J$"IP Ia|` 56
&$T`ԩC ؄ TڪԫTԠ*<Tg!"q$Dcz: 'ᴳ4㴴4崵4紶d鴷4D9zb` : (7W  )$**U$++$,,$--$.C.W9 .hTໄ 0	`9 #E$Hg4jH@ #"" $" $" |
8 b@JNu@OPP 8 ;	 
  Џ    /	
1n&Xc  b" :   %u    Q'U '#(!(")UR)S*T*U+UV+W,X,Y-UZ-[.3W
Ue/di0i3djUj4dk5k8dlU=ldmLm\dnUBndoEoFdpUMpH$IqJdrKbz1npqIr$Js$,}i]c1n@ U }| ~}U`~} @U },~ "`U8tu wxEҔ~z{t  U}tl 
iO5L5(@4 ^T`ypJfԖ]` ddT];UU`
ffH 3{yԡ  &MR@ \ b v @ܾ M@ @ X z @ @M@ . H T j@~ ( ̀ M @ < V v @ @M"@ 0 P d @ @܀M@ , F ^ x@ @M>@ b n  @ЀM6@ X j j @@ Z ~  @ 
	T @ * > R U^@ht U@ M@
@ F UZ r @U @S
@ $ D Ud @M  @ D Ud  @ĀM
C$ U2 N@fzU @} M@ U@ b  @պ @!@ L ` ~@ ښ@'@ ( 8 P d@ @@ B X l @Ъ @,@ " & * .@2:T l@ʚ @(/@ h   @M4@ ^   @̀j @ ,@ ^   ަ@*@ 8 F T b@v @ª @3@ d   @ &@ T z  @F9@ x 5@Ԁ0@ UD n  @M"7@ b Ր  @T @ b   5@@$@ U> H T f@U| @؀  WM@   U" *@06U> F@LRUd n@v|U @ƀU @ A+@ & * . @@FRLJl@U @S  I@ 6 J Uf @ @!T Q@ F ^ v ՚@"T+@ j   M@#@I@ f Վ  @$T*@ b   M@%@J@ ^ U  @րM
& Q@ L Cl ~@J @25 @'2@ U* . N P@UTX\ `@UdhlDU @U @Q΀ai@M(S@ B Uh  @ڀS)@U@ T v U @ʀS* Q@ 6 V Ub |@5 @
+@k@ UF v  @M*,l@ \ Un  @΀M- P@ D UP X j@rU @Ȁ.d@ P p  @ 4/@k@ |j   
0 J*@ p   A	S1 t@ |  M *2l@  e  
3@e@ & 4 L `@~ @Ā  4U@ V j ~ @ޚ @
5|@ 6* ` l |@i@iiiA@U @S6~@ J j "@7@@ R b J @% S8c@ X | U @  S9@ T f iz@ : @ X t  @;@ H X h @ @ @$<@ j  Κ @$=@ j   >@*@ p   i5 ?@ UR   @S,@@@ h  U @ƀM A@ 4 UB T f@մ @ BT R@ t   M@C @  5  $D@@ Ռ   .ET@    S$F@   M *G@  5  $H@@ U   @Ii . @ T@hĪ @J@@ " & * .@26: >@BF` j@r @, 
i Ki  i@iH h @ހ	iL@ il  @M@ b   @N @   O@;@ |j   4P@j@   0Qj@   $R@j@   Sª@    @&T@ j R  C
U@ F i2Ur@~ "iiiDiFiV@ i& .@HZ f@l~ j@΀
W@Ī@ D `  @΀ X @ V f  @V  Y& F UZ @M Z @ D UX v @5 [@ < B P@l @ঀ\@ 4 N ^ z@j @] ժ@ < d  j@Ѐ^ @ T r  Ԛ@&_@ rJ    ` @ & B Z d@p @j a f@ : N ` r@ *@܀iiiA
bT@@ F ` t @"5ڀ c@ Uj   @eހ%dת@ F V r  ȄրFe @ ( UD l@xU @f 2 r @* @Ԁi@gT@ `   5@(h@@ ~   i @ 8 d @Һ @*j @    k@ U , >@LUt @U @S$l@ h  լ @mT@@ R   M@n@ Z Ռ  @"oT 0@ d   M@ p (@ z 5  q @ U\   @Sr@@ D d I ҐҤ պ@̀sT@ 6 D R U^@flt U|@ @iȪ@΀ )t N@ 6 @ 
IJ i`h҆ @ܚ u@ \ 	rҪ@ v@@ @ V l @"w@e@    x;@   (y@   2z/@   0{@9@   8|@@   Қ @} @ JR l C@  @2S~*@ L l "~iҢDiJ @e @A @ * . @ \@n @؀ O@ P l  @j 
@@ H ^  @Ā  @ > d  @΀Ui < ^ U@ @T@(@ 6 L n U@ M@@ < UH N p@ը @T,@ V x  @i @ p  ږ i* J T@ftJ @i@5܀@ U8 P h @U @Mg@ : 
iV dAiiiPiAl U@ @ @_@ "8 Z z@j @i: %V p@ @F@  > \ n@i| @ @^@ < L \ z@* @i#@`@  iU@2Fv ՘@T1@ b   M@@@ P Un  @΀5 h@ U< d  @M@ 8 F T f@iv* @i @T @ d   M@@ b U  @S/@ l  5 @@@ U`   @S
N@ f  5 @2@&@ Ux   @S`@ X t U @5 @@ UP d p  k	~i iRi@Ҷ @܀i%i@(iI0J@rզ @ @ B ` ~@ @@@ Z z@    @ \   @(@ j   @ |   @Z@ x  Ԧ h@ h   @"@]@ \  T 	i @&	i@ ` n@iҘDi)i@Ԁii AL@ , D d ~@  @ d   @܀" z@ X r  @ڀQ @ Z z Ր@
T@ X x  ՠ@ T@@ P j  U@ M@@@ @ Uh  @Ȁ5 [@ U* X  @5؀@ UX x  @5 @ Մ   
@@ t  @ @ @ V d t@ʚ @@ X x  @@ @ T z  @ iiiAS @ F f U @S @ J r U @ҀM ,@  զ  @ T@@ F h x U@  @M @@ * UX  @ @ H Z v@j @*@ * 2 @@U@Ld @5 @@ U^   @S* @   i 
U> V z@5 "@ U   @5ր
 @ U8 J d @U @S @ |  M 
@@ l ՞  @T@ ^   M@@@ r զ  @ T@ j   M@$@@  զ  @T@ `   i@ @ 8 \  j@؀ Ȁ˪@  & . 6@>FL T@\dl @ ʚ@ @ T 
&< F@RT p @@ ZR v 	Қ M@ 8@ F Uh  @ԀM P@ Z i @@ ~  ܦ  @ r   @@ rj   G@ l   ޚ@@$@ NJ p  C @T2 " <@	bv@iDTiҾ @ A+@ F N j @ @@ J d  @Ԁޚ G@ F `  @j iU4 X j @5׀>@ UT ` v @ն  ؤD@ ` ij |@ @ ـ@ if  @ij @ <@ Z p  @@@ L r  @ؚ"@ *   @i
@@ 2 L b |@ @ڀ$@@ ^ |  @܀  g@ J p * @iiii@A@ H j  @ @g@ R r  @Ԛ ( @ vJ   A%ȀMW@ 2 UN `@zU @ЀS, @ b  U @S@ \  U @U @5 @ 1@ U> t  @Mހ@@ f ՚  @ 褀m@ N j zT@i @M f@  հ  @
48@ . b@ UR@t U@ʀ S T@ t  M \@ ^ Ռ  @Tm@ ~   S @@ J t ՞ @Tp@ f   M@@@  5  \@ Up   @ u@ iF ^ t@֖  i i R 4@i>H iPX `@fRni@U @
i@2:iHid@ )@ v  ն@̀T @ P r  ն@ڀ"Tn@ ^ |  jЀ4@  @   @    ;@ |   c@ h   @@ P r J @ЀC Su@ 2 J 2ib| D@Ҿ iDiiii(J : B@AdUz @ռ @T@@ 8 ^ x }@  
]6@ UD b  @ո W
](@ < X j@ِȚ @@ D r  @ 
]@ @ X d r@x @Ā 
]*@ D \ v @ @@ 6 L t @ƀ@ j |  @Ҁ
]F@ |  R @ _
] @ 4 UJ ^ l@U @S	@@ > T Uj @5 @ 
 @ U0 P b l@iiiAv@ J@ 
@ > "d @ @
+]"@ F b %@ j@܀
 T@  6 N ^@Un~ @
]U,@ N f | U@ S@(@ 8 F U^ n@|U @ @
]U:@ X   }@
]2@ Ud   @}
].@ B ih@j @ @ |   @
]@ ( : Z v@ j@΀"@ h   @ '@ X n  @@
@ l   @:@ p   @((@    :7@  Ț  26@ l*   @M
0@ . UF h @MI@ƀU @ 
]U@  " < UH@N^v U@ *
@YJB UV j @@" @@ j   @  @ V ~  @!@@ HN@  @"@R@   #@K@    $@O@   (%@@   ,&@E@   '*@ f   @(8
~ ѐ@ѠѲ2:*@Hh iiiDi}@)
]@ . > H i`z @j * ?@ `   ڦ@+a@ x   @, ;@ \ j  @ƀ-@j@ V h j @Ԁ.X@ d l  j@ƀ/ H@ B n v ~@  Ě@0h@ P p  @j  1@b@ d   ֦@ 2N@ R zj  @3@;@ J   @.4 r@    5T@C@ . D X Up@ մ@Ā
6T@e@ F h  լ@ʀ7T@v@ N r  @΀iiiiA8@o@ F Z n* @"M@9 @ p U  @S:]@ p  պ @;@@  ^   @P< _@ V b z @ښ 
=@@ J f  @ @ >@@    $@Hfj @? @    .@@p@   & A@l@ P U@ S.B v@   SC@ B R Ub x@U @M Do@ R Ր  @"ET@    S&F@U@   M G@s@ t 5  H @ U^   @SI v@ v  M J@`@  5  K@ Ur   @Li 2 T t@F 
M @ 0 U@ H@R\Uf p@xU @U @؀S$N@ N Z *
h ЀI@Ҧ ڀS
O@ \   iȀP@@   j @Q 9@ B \ v j@2R@j@   Sj@   Tv@    2U @   &V @   W @ N d  @L CX @ \ En  2 @
Yi i8DiP@nx R@Ҽ @\ ZT@ Z p  5@[@ UT z  @5ʀ\@ UD P j ~@U @S] @ @ ` U @ҀM ^ @ R Ut  @΀M_ @  U, ` r@զ @
`TZ@ @ P v U@ Sa@ 6 ` U @΀Sb@@ P z 5 @$c @ 5  d@@ U< R ^ p@U @΀  eT@@ 4 V l U@ M@f@@ Z Uz  @
giii	ҨA <@`~ @Jh@ X U|  @S
i@ L r  @րj @ < X l @  @ikT @ P ^ x U@ Sl@@ L j U @5 @ m@ } *M U"@Db 5@n@ Uh   @S8o@ z  @h@܀ip@@ R d  @q@ ~   @j  r Ъ@ ( 6 H T@j| Ҧ@s@ b j  @t@ f   @2u@    $v'@ j   w@ v    x @   ڦ y	@  j  @z T@ iR Ti`@Un @ {@ & . HWM>j4:UB J@PXUn x@ @ Me 
 |iI (@@ r F@}@@ H U\ p@5 @~@ UJ j  @@"v؀   ?@   $Ԁ@   84"@   .@ 5   \@ 5  @@ UJ p  @e΀C *@ 8 L  i 4 @Li
(Di@bҔ@Ҥ@ j@+@ Z z  @@@ 4 L p @ @@@ AUT t @5  @ DA ZML d@ Z@ @{T $ D@TUp @΀ N\@~R@P| > h U@ Sa@   M 8@ V Մ  @  >@ h  _M@j @@ > L X d@|D j @f@ : V r @AaMҀ iiHiA@A S5@ < P Uj @j"@@ N n z J@%@S%@ 6 R Uv @؀ T@ X h  @ƀ @ t@ : Ǝ v@j  @ ;MfM@Ri@ `  ծ @"T@@ |   @i
|@ UH `@5 @ @ UV p ~ @>kMU@؀ Sq@  , UP t@M @@ D Ub  @M@@ h Ք  @T@O@ P z  M@ U@ \ j @{@ Z   @ @ P jR  Җո @@@  . IWM<@JRSls@O@| `Uh p@xU @ @ހJL@@ $ :TJ^ @@~@ 2 J b@j @ @ > ^ ~ @ 0t@   @@    6@   @    4 @   @ N d  @ʀ CT@@ 8 H r Ti2 @@ii
.@<B V@\aB bR@bv~ @  @@ l@ j   @ 6 X j @ @ @ < ^ x @L@ Z   @@ V   @ʀj @@ < L h @ @@ * N v @΀U@ P n  @ @ t   @ TR f z@U @؀M@@   U> b @U @S@ b  լ @ @ . > iiiAJl @ @ @ "UT x @ @"@@ n % @Ā "U 6 b v@ 榀@@ R j  @ƀj @6@l@ x   @Ҁ T@i @S@ v  5 @@ v   Ô@ H p Ҝ@ @ @ L j  @ŀӪ@ z   @ Iƀ@ . 7F UV@l M@@@ b Մ  @T@@ p   M@0ɀ@  5  @ p  @ T@ f   M@<@@  5  :@ Ux   @f @ r@( > \@|  Ԩ @̀* @5j@ @ U, > X t@ 
ҮJ@ƀ2@.-@ Uz   @"@6@р@< \ | @@@ > \  @΀Ӏ@ f   @Ԁ@ N x  @즀@@ `   @, @ p   @"׀@ CUp ~ @D 2rU  @ i.4i
J@ V ӕb z@ʢ @Ҁ ـ@ P l  @8@@    @؀
 /@ < T* n @ĀM ܀@ @ UX t @U @S@O@ d  U @M 
ހ@ N Ul  @5 @@ U2 B J p@U @S@ P x  @
]U@ . J v 5@ހ @ UD N h r@Uz @U @ހ T@ > P b Ut@ U@Ԁ S
@ 2 F iiiAZr @j @XT@ "l  @M性@ @ h  @%VC%$ B J%^@% 5@[@ U, B Z @U @M@-@ > Ul  @U @5 @_@ U  : ^@U @.3`  Ҧ @A@ B l  @ @k@ 0 X l @Ȁ&l@ h x  @j @ q@ , 2 F Z*@@d@   =F j  @,K@    )@ p  5@44@ E  S$@@   M  @  5  o@ U< J T fUl @j @  $ * 0@6<B H@NVh t@| *@܀ 
ғ  @  i&D@< Ҁն @TT@ > X r U@ SU@ L p U @ԀS{@ h  5 @ @ Ut   @S& f@   M  @ ^ }   	m,@ UZ ~  @ր	m0@ P Cd x@ @2 '	m*@ 4 iTDip @$PnP1n / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй 
Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tKdmtE$fu
j0t0t	dp.  f]ZYPSRi uLHSrL&jmsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡimxjwj  :imtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
cmD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vbm kmff@EFt!hXUgvuN>tO6f뿢bm Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% cmSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVmmu/(` r'(>  4
P  ~
 @+=h0( Q Ǡ  f3۹ fbdTt ` 0:Q ?\^8ZFfC⁢PS@sw$yk{s>
p"o
d
\Ku@S1?"5`,KuZ'苆FFLKu FQ$Pdm$G^f  @s4j2jgOH^D	%߉D	f:O"-fp<v PfUJ?f@KfffQ$f6f> f	>fBf0+ff]X߀ t p,rPԁf_z0R0Ӄfw3 Z`R҃>/ t5  A U@@!`0ӳ
@lAԟGRV&H:f;tff) F#$A^q$e sqSf qgfÈ>  fù fAB;t)gf+ C kB;PEQM`?k ӒHGPV  ^ h2 ;uБ;~ ;b 6P6UXfm.0XR @ y  	`@  Q}o+p+ r3!B +!;PՁ  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXh<fZf_;>+uƴ+kmaPS puve+i@g+j+a+U/xklb+znmc+D[XF f sf tf[ Ȑ![YZ_]e È++0_Q `+ cmPcm j0fdqtu!+! !ddfd԰  >P6Sd ddP ʱ(++ fU0t=T=f]t,>@u%ttt t	tfsN 0Et@)r@ua`ln)s
 1Qh 6yOuFk . u${
VێeS tOrt}ـ?и{D`*fdofeT ff/fXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+OfWpe*&|+8fw*fF*2t*܊e&}+fXAf`PKem)'*!(++ f?꤫"Z  Āu(!`v]+6R p(Q?faSQVWU&dm tdm ui]aLS-120ZIP 25M0 RV:1:o2:p2o2PKp
>w
 z
\5	d+?>s!hErg;<tV< uWQ/f< Q:D= uFfG(*X!X  A0`u v+Qfmo+i+p+j+a+v0 RW1h
ȿN} tEA/'_Z[M-Sys   DiskOnKey 1 #߅axBgm u @  f<x fP f0Q1"%|= 2rޒ 0w"1{s ȧsU3IH tuRfQf@fPuLst6Lu2r)g&	ug&g&oc\,f_߸ PA߉ rLTf<Q?GQkRlRQbV`cF5Qome}?70ޡ;0hPkt@ u u#P-3RAf?LfHS N 
1f_Xuײ?D0 @0UzB0hB0nB0mB0cG05F6F 	 x&3FPRrco3W1>#>;!2>
g>_YhhPhN`p&P  h'0l DZXSWw` 1s!$?
u$[         Ұ,X @x^0 uY rTB5!0c@  i|X  t衭   ` 	bho4<fH f5f[0cЉf&^huf{^06.f ff5fP  5f%k@ף% @ B5f  z6f5f=As&  ` AVfaDf=%t 5t;@3tZ0tZDfځX$g];6  5I5Sf@ t|P5"sƑ tDf q5ߡ5<5ÿf>5 u? ` _D  2ft.0c@P +rfmu$5@s11 >W5@!R05'r"b""0  ?1VC@f,S	  tX	*riH'	"	0 
%9 uf-%tq00 P35P J 	P5;tpa '	5 1:  rf 
 pQDP؊*5@6Pf>5gGf	gOg}{G]`db>:d"3	0	n5
`6@#Du	%&0cf65f	f 5fIng^g׊~W!
*t4h 0A		0	  FFh9hJԆ<t
 &O5q*p09u
 'X*؃ C O&O_5&OqN&7hbLҠ6%@( 5f (f? 42a3uf5W  bf~t0awSgff95u gF95u 95u
gF95tgHNXfFW5zr=БC=m0rxi?GsVfS'`c(gF'	5g^ g"G0gFֱ V*	 /e*emd&b&g&g&G
0G
 dЪGd*PGg&Gg&{G
 G 3gn Fpp5t	f AkGF^ 0\PfV csf@ܲmdf p^fIf!5&55+5(5  5 < t5  ;vȉ5qv  f@
BqygfgG p ,gG
	q?Gfup"a ?Hf%ofE@ !gG!&55 t@(bk!f#pF❪cn`_fOB'*PR7з[f=S
f3̰Vf$fӃ\Q?fp#{-  !Si y 9t ````aJ`b	`c	0]	0^	  
		  
							
 0hfWQ[f`!Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r% >q+bASes?+rI`d
Qr7R|= USBSug&|= t t
U	 	`+cTZ +Qޡ p arQr C0& %r{P`6@`2P>+t QrIt2QfF`AdYr}vSf1fM^!WA@@H\
؀]e܉\b< H
p*rA
x @
`0
!?
x0
"sTsq
aWa'"CS# iD=qp*Wy.?43'3PT2' yoZi(Z
2_(
_7
__=%t9N R$:RS$2Q	@ ?VEB@RP2 3* h >{wOu x T=
XS<(fT= & y#j6~+~+ r}QtA3`>|+|+p+` pta^Vu6} }+ +.ZEf.O6VEOPpYfX`VEI|G<`+ fa9<?,B3U+*/G/%QfPfph`1@YOfXY"?N0\;J?;G7/Osc`yMoDABA<e=S$l{=38%rp-+kOt9 OtE }OtQ+D$
ƈ+DFP!r r
9rY⹖ /Ρp%tFPtt=tT= t2:t+u:u hN,odty(u~(_rt{^@kO=@tO=t}O=`	twO= kOh1)6`oXaPSV+8dtdw}mޠrgla޾+8DtD$PQ@wHPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGH?IRSVݫ      Z *8۝6TS!
  	b.>  
   UKUK o      2@SJ[PuK&|KО!i$ru
>uKӉ * | > X * t|KxKxK>xKuKu UKFϰ'PSC|rzK$+zzzOKuKQKwKΓQ	`P/$s`
3ۊ `"K&K&K L3} wKpVSbm@t	V5mߡ[^@pVcmTK "`K1m!f4 uՀuq!S1-mNKBMm68Հdm[^pqq?fU >cmimS>L>im܊&Ldmt(
ߠRKcmZ SKK[o@vf]AA`Ft>}K{K r1K{w%0r
 "cm6x҈0EUK Аh6bKFdhEYQ!R) `* ~aӀQ	k 胢pt1Kh[L!rL&jmSK_imLfPSQзKf3fY[fR~Kff3 뇾0pfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >Ȁ$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO>L`O4A<quriVW@ξ HtAQ Zft(PǴ:Lu 
  gXfCYPqq q9~ w2LkYϠLDtߊ& L8kr >taRw>
$_^t0%GKLK IKf? t<CpR<tSQLذ&Y[ـ u
_lqpJ>@I - n ig8   ` T 8th
   0  p 	 	 	 
		
							
 

 } fWQf04aQY`f D5 ,+6]++sR. (,+z0SD
$&++
ĈD
 1s fg&|5 EBr`jr  a`fR))	\	n	MvR`UR		`RH\
|*+
\*se bSQoaS}͠ϼ" cc͐Ă/r`y͏Ј-̈́&p_W3
	#rgqWtX0Y"@ fU迹Դj(rjdyu6bDq=UcUUpfqh		Yv		xvbF
 T `& !sJ%|=td%"y:ur?rpq~!(~rg2oQVfRL	;t	]PAϦ{=}^A QΗ0   0   ? RrE d    n  A` P 00 3`  
& Aa %  	%
0 #
"*!
 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
:QT S<R"G 3D%M TVaXCJ UK8'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<tS^f&^2c sf^   uh   uRRfADf3~8w0=ISGuђ۝ s
g]^!t f6^۽	ngftczRa tpt5H0c @u  u uϰ0 ߰# 2  P f%ᘅ3 
f>5f5Dt	u)f5%;5wuf͸@ffh9htff"Qtpѣ
0f1sq
B  iv@#tz2910!<ug


7	uu\	Q	'hd/%_5Kfo65	g u%S F5 s@[%;u!,f=4R0	ff4	)fgfp	Q(f	f@f[aSfSfQfRfV*sW2c15 uBT tApN@76g88fI4g^f3f@70	@7f^fZfYf[fP"Vf
5f=}`Bt"f=Ё &f= 0//f{=0 3f=@+=t8t34 , 't"#
ttf5c0 rfFP0fXURf.  fXr{  	 QfpufQD8@M TR2@(2Of2f0cBZ{RO>V\3hě0(W Q Ǡ uof3^fbDf6E  Z<tatG@]_ToKg<u	.upWJ$< t<0t$ RHP?y"UPWT%j_uPlAP#,RfWPR;5rfc%1f f{>a-	f!Effg8Wu#>_444
f@[Jsf_,,PSt{wO&9/1=`Q
Yr;f.;ft3UufOf!mpf|ffm fPtP= v	 +v:P,P}ff́   :ffvP ̠ 6f1|Ã tL;f ǰ;Ptƿf Q.fB	r;rf@u0`b h0-Ña	rffqp
C	_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gfg@ h쀀1"`W, `П..`B@ԑ
>t1a   #i   UP A :Pnj>jFjNjVj^jfjMSV.>bm tvJj^>Q PSQRVW>vjujSRP#u<v
@wj,xjimujʀ 7UmG r ) 褵\!ujјP뾼S	%x
vjvjvj:ujw/:jP
 hN/L	c? tOûde
	jjrg&w0tRj觴}rZjdr!"BjuKr
? JthE	/CZp4tĳbj&=2ohsg13
	ucmP $cm} Xp Z#,_莶[$$O_^ZYe**=	Q  !   0  " ("2ѷi /f+Ld 4'=m$7g&* 	uwjwj w@MKm &Emݲ`J}"p,@vōp-s0D0Km,0$ 03۰ ɀw%1u> &
'$udmuvtueu^]\uMu:8FPu)ttfu,0= IׅLfg&8!<u	g& `=FtF@sPVS`@m蛱O([^XSRVmWOg^__Cr@ޕ14ZbUf%0ѫk$返[]0)R Z_oR Ն oP&abpZ&&FdR{< u\_R\RgtXr),u@TRG`SQr9R'$8t迠܋Ytr$V簄O㰆HAr(bgFr^(!sqtrp@pp蓶q9``æ  f18 f܀g'0z  pj FFBZss`b PQfWfVӝUU~*nЌP U 'hX+Uu'UG@J  .;qt3_YXh5  `#`Ⱥ0@^	p0 "' J@4 "`".im2'.q q㐰0 0!W
sfUgg& suf3Ɋfа ǯtfYVfWsg<t,zfUgR r!8tfG^fZPQ71$@a@8tPQqUvPKtF X PS2&8tp 6t؎[XPSR8tǎaAf!.bSRغ P BDðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - PQ ktu
YXP@p` ؠu 
Xf`J؎ Rf¿쨀u Zlfan   @(00	zf&Ef  pDp   &Et"D  $D( s `ف&tȀ ׃4>2@"Q
g&Ŀt
_ 0HL &}u?p ?u8&= r1	&
IW$Br P
` 肐 m  m 
 m p's 0a` ar * $·OQa	 & aSQf# $$<@t"hXfP u	fXc  h KuKfZY[yKuף`.>(st&3r	&*r.
葚oaô`prr X ? tr/C0}}qw1#!8OQ909$Ca0){fRQSȠ[YfZt'1 tt' u
| t踡ar0U
ADȁmG>  &f    htnruf>0rfff0Gf  %fq@ff脶r<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀?
 >,-./01289OG     K `a%
 3 RRF 8%$a,PoG3"_"
P![2t*:*`>@ l>0l!GA lBla}6$?C ! G @ A1 B  $0sF  en 诀"  BnnnJF$a %JF&P '<ƿ( tq ̢)P *̠̡++ޢ ,  @pllB  ؿ< lBB@l l@ U   @ lТNL&\}'sy /$а 
@  ~
FFn  	n	n	n	n	n	n	nnn 
  t'&a  ,CFd̀*)`  3nnC q
p		 nA
` wna44aPfWH4g&g&f;_X'=                     S &0 Y	ɀ$ tT Z	Ћ% u BZ	KqRPt@B u$ZfQWP l!lXgg_f@f`Q
`FfgfQRfWPSf3f3ɿ\	f0<  P t]
f; Xߩ tDt[	[Xf_ZfY<fPffffX,fV>fVf PJE gߤf^! fU^	V					:		[		^		f	W		_fWf	_}
g&' @p:fPSQWV!  tO
##"A$#hoԧTQQ sY^_Y[fX>uzD"sf f`8P%a|w#%z  t
ف     tוsPR0@ZX t(  Xt
 %@  Pé t u>
P
 Sq ``@ࢮ3t%%tNtG!п ff3uT0ff  
fαJ X  R.Q#؁ W~~	c	%@ Q# Y3#P!` P]
x  uγ # `u蒑o
 ! 
>   p(%Et
8%fZ#@Q !f~p f#A$! 5 qq faAr 
 `!Z/f@fPS` SP!3P#u譋u
?  1"qf'ZYf-PS4 T Thݯ3t۰1,2htf fP]B5R`25f-Q4=	-e#"308؀.@uR%tt@t
1guf
gP ?`Lt| 3S+[C vS3ۀ> tt+t:+t?C ` t<w>t8tpt :蛻ñ ~ S 0 ɰt,} 莰 `++`+Y`tr\"M5OfP	R^A+rA a	 fXcеHt3]P	4Ӂ@t1-w&㋇+.trwRat0
p⊺ < t
!:@ 0  +p>@uׯt+aÉ  HA>

p2I}2J@؃@P2
s3y@s߃i  Y 11F0臮:u;pu;thpP P@=` -! . ww
210Dr &	&Q
À
v >Ͱ2  22#@t0Nf2ptE p  P+GhoNt :Q j /T3ހ 0G4g&tC0±Bmft.f7nA ZnA   u^1  dhQ)
  '  emimh+Kaf@$)g#4h21b b
 babR0p  ZPQu4 pyKqb `YpR0Rim Gh"v	
2
.&g t#.σg' T
.t&*0 0RVhPk/{ıtDh^hٽf5h1h7r2, f^fZf`2 =rob2 <S?fT;g
hMfaf`X
0PPf3//nǾp X	 !7"?" hQf`/)
4/O
\ "	 	 R"	/	(	!e&!_!!!p!h><dh?I.OwnG	qf20&cu 2pĂRt F<t$]rf@ 3dtsfQVW!E 0 ¿_^Y}TfP  ^Dfffɷt
t %S!Ǘy~gf5rSQ?f_  P" s^WWVh0E?r=ыt
 t
uu	  tt uʋ?^_B7fQf:Eb3:EF c6W p 2:> u6 GHt\o h:j/T3Ҭ؋hB^_fZAfSj
XK̈́
>
2e
*
VTm>T2@OHp
Nt.
O>rRbǰqͬ!2 2/ 21"Co/ / /  O20#<RwS2. [pfø  &аf_fQhZ_4ufYpډ^pډq)aEf3ɋP~k`qXp&G     &Wfހt ffBf;ۇPgfww~rtwRtpff}@hp3QgfY tghoAAX0Y[0U>aPS 2h,<Wh`2f[ t7> uԸ# $>p u0R`	b_C躞t+!螝覞t2#蒞tP Fs ϛ`qt
o 
> p Gg	du	7gqQ_^R2YP` bu9 5r/<t+t&u
$&|蹸.ͷa@p@豝t"tq2t 茸g&G Q !pv@v芛u(eu߀q>j`v&^tK{ P%q%  &q%q%
À>0
 
8s{   
t}V$<
v
ط   tǀ>i% t 
${
ؐ h_e$0'
d t&؊ c^qhXm

p4wd	v
	
s	 e
À+@uu i%&j%K i%j%>j% u
8wQ&&&'''$'/':'E'P [ f'q'|' "߶  ߺ8s} 	ÿ 'à@ PP  ~̀R ĺZXpR, :3_%  ZQ1\{  qKYIef 33 ~3 H
A b ff@Uf   ff VCSQe'  @/%dVPh p>ft	bof%ҷzW}@!GȀX<t<t<&PS$<w- .(߸ 
(  T 6 PR0M)2.My)BZ s  ""
ZP@5C)) Jq vJúBQ R ( PBX
	ڠذ4_؝1'fQSW 0_[ g踃IE  hC M (xI PQW<u
y {a_-+z |ϰ"~ðm'hm蝞°?q`o2r! ڃ r%%va/,% 6v   {% ~-- r 1-29,k%!1 @,r%idi! 2% ++,+,A}1ak,%2 7[, p#,% 0.&,;?,l> 脀m?,?,23_s 2ll{clUV<2k2 Pظ R$
 ej[.pipi>'Pi^]_i[i2 	?s0 xtiu%qh$u~<,r7,y
-Ha`@uӑ`
 
 ~d- qbp@Pc-S rM.-[Sr6Om.t _r蠬谛Zu_:G؀ˀAT2f.fÐ6ef.q %Zhż? a:@rl. mb blB< o~hRuИ@ Uh'_/.#/ 0a=
03!49+t
3NO+t3GNOUN5/./5/&N</_쪺P aT5/SR</``8q1~Q hPkoehdm3  uuu&gq @p  聆[h*j_EP:oXh:"hL SUvP0F X PSQu&0&0&0[XPSBw0ࡎ00+'o+) 1Ċ& 1 1\qLĳ4zdm g0j }Pa qU BX躐`׎S8rddЮr{2;<dr
d2t6	;Jp 2n2ÐE AR^}Hx&` 0a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              i 逮!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( Ϥ.(     ښ      g {`g  h } Z +  ;p?    / W7h΄ mw8Є 9S          P          %X%H_&                                                                                    U `*Y} `U UPzQ@    @ 	@
 
@P X@Yhi j@klm n@o { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ =/`hfPu	fXc  h  fUf&af&>m` 6a  !ŀX[ &SP`@ /'ao&Uߡ&@r
f3f僰gf }f3fh   󯪰@p h &?ïf`f1fffef   % ŀ-fWf0M0U0!0)ffXf9ffaf 
  fi@] 0 m q:  ,f5q fPeP Q Z  ͡ՅAp  A` efaa  !6>釿eуp  ՃnPك"` eɃ w	
e} f~e&` b "jeɃffefAffgd:ugdfepfa3 ?gCT "8fF3ۊde3 
td	 Ä p)'Ґ @ v
peuxu._RTC u:/
y'
%&bfgfd.S` [WP9A`XP&EX% &E{_YǨ o2oooǸoc׎B~f`ffP fSIMWuUf>g0f[ Qbr6fc;w(hs,UfKfap p`p f&?SECUtC)fuDfQpR Ph*j\g&XfG' 
uWf%389 Su(vg&_-̠$8GAxtT; 	Gt+S萠
 TT<tT`q_tARh R"L@	=p3%= 	 =
=ufcJOFF@ ʀ )2?U3ffw	f"zOn& t
fWfLf_r@& =f$g&_p ff%g&	 tg&  rSfQfR@ fGtt2t~tyf   f!f,0 tfn@ 1^wu.
f rFf;r>1+: t,߳ f |ur%ArQYQ	 f_fZfYf[  ߀ t% 
't`A5
A!:0.2 r&5"

rlr7SV9rP#j   t
ff;t;0
 + t DU@@D*?^fZY@ pGh^2hfNt :Q j rwp		]G u ff!` B
fffLp 


ghghNRO
@fPh1hL	fX
%3F# 
t_3 v0)Q{%pKh(/XG!V< t6<t1p4:u"FSj*:+p;) .fY (7@g w.	A_S 
fUfp>t	_--


f+ f
$f]^$*### -F?Xv0L? Cn@u%fǱo  '  
Ph$$$$$YCYX Vor1q:'qfYt&{Y5A5:
v




F8Viጐii^fRg&;hr>\|t2g&	`u єfZfVfRQP zfOf0paff!>  _3ҹ?AFffZ f 
Ƅ
@],`Y`i^}RfVQS>f"
 O9*Bt`#ah_Q   7p___[Yfi`V/#	
UR 0B]Ц  ГRQ2er+^hU 
 ` 
j m0_WVSQ  2ۊbF(+ؾ8u `&
dY[^_fPWQ--tF-,-P{&-PX"0s?Y_fXP  Q`ۚff<nt$np$)nr쪺  .pn
../ NA Nfa
SwRVx.fpr؀tU./tSA
 NUN+h)nE^Z[fP,4PSWRgh4I@>N u&E q LZ_[Xðh_NÀ> tOgWfOs?PWPB_ЀX ,w, {,j,ÀPRŚBϢƚZ Bƚް$ `%>&+%	 
  3  t!  { Κ    @u#Κ2h2_q}tRW0_@r \EF跞-2fSSfh?iAffffs$R8 fZICPRrfPf&T f7ʚf!`'p!S'b'

R)	6t2*[v.>(s aPQRp쨀t hE/z@?uZYp5wB!C
8@hd1` e~ _~ Y~!S~0M~1G~2A~ ;~ 5~/fW -M@< f  qt"Gbg&Gbu[ߒ uf   κ(/ 
.uf_ 5`fP    Nu"Na$$
a C. PB _B;ra 5")菑Q8#Q0I1(,0V:P *J : ,2Q2RWĺZP 쾘,ȡ%π:؁ 34 ܁D4eD
 <M'G ౓^^D_`J I 1`^_hPk?%t$hWaOa^6@Sl`DDDtmD (og@a HF@r[Mt"s@#&>;qQ ^h.fl
$1!/_fѮ2%  
 0(p!P!q ? f
 0XwX!!f`6fg?ff% lgffP  R
 `C  aSB"a `nPL\`# u8$Ou0	u,hPuX(qt 柤٥(fk˦<rܪf`m_a  6&P&~3``X _v
``.f&r&&r!Br ݁aPѧX
䏀  PfХ__0}X}10uff	<u q<u õr$Rr s&&A2rr]rwN a{`z7da(Sv_xБQ`00"" QYa]P  r&&p'] Ob U
y[' P"S""F"&&a bR ~ ZQRr3'H2't2۴ `2)w5 t ھ'TZYa~Wr#S-ER-7Y03վpٸ}q4 Ό f &o pZ2 &r豂r8t32`.&E?O h?,tGS@e1?Eh[&M.2tð$< 	#h u.5 .W -4}0fR2fZrq pv~w@5 &E
, w#!`e	A	2@ah*j
D%00`P 0丨S%-  D c`6(   k  V魆ī^`WП 3 _r- +˸ fDZED;{ BЙB O B<`<2rru辽O0W2&*G_YS	 7&*,u&}Z`E1j_k[DAP`^QFگ>  0 2<OtY	B<tmH7r77rPBBLѯ: r1 r,q h/cd8SQk?
peat)|$<Pt+fhKuҴ~hqiB`UY[[Qrj @"~	ѴuBanYoof	V o^W mQfR? D=F==rN|UtGV !m4^t1Vh_~5f_^Df`      $B       <@ D ` d h`      ܢ @  `b  ܠH? P X \HT                      `        14       b(L'0#` P  @    Pa !:( '     PXYhijklmno 	

                  K _,89:5?NNO OhX|__'PfSfWeobf ?kfgf&c@~pOZ	(нf_f[fX`Djf[XpbVW f Q  !Q  A!!ȑf%ذ`f3f.ff^u_^fZfYf"uQ ء f' ^ذ
f0P3XPSVWfQs:1ՉNي t
u uffpv @uf  fY_^[XQfWfVff
 ff߾  pf f`   :fEq:$4'pf^f_YA - :bR5   9f^fPSQR# 3%n0%S@ fq$<sy! !PB@6X%<"**of GjF|
sKf0$P
f>	@
 op/'B?<$
sǺ$  fޭ`5Xp4'o%8ZYc-9%@8SQ$
 $
ذv%z$wzu@$- ߀@xyf_=  Ds ; Z x  p 0Nm[$
Pd_u	q @2oXÃ&	 R[ HSyȃIAyذJ:y2ȉ2' 8AJ'ff w	. &a  %${tҽµ 00hxLYh/~rEd/(#/Jo*/"Y1ïg|hmAGf>QPH_u(Dr#1 Ofp!2 '46-Wr(Qp% -ronUWp(>f{  t ` tf frw=@W   _`ff! 2g&g
fKffRg&& gre Ghջur}eO.`fVGhݟZ,
- xф r  sfbSfR_j07W6uLt;wEf6ߵff8 r/fRebfBfPerf %0  Z`fWu
 a > PÀff`!u? t] t
tAe@zYfO?
 :  }(! _ f` ; 6frv`gGwf3Pz f[ˠyffPr: > ff@;w!fVg&f^ufFtfaޑfQC3$pft󰥥Q?g&0908&pof=ATADtlf q:&ǇT qp s  SU3它a  sb s1 ހw 0Hs3wɊ yj qNsǿUFWP
 XUu&.>I   u{b >u `	`	rtp$l0rrP$rC#	


 @`W3  ]t1fMd fqP`uA ByC}_.qfUf.6yf]ʫf]aue}aa** End SetActiveDisplays: \ !$Tt5< ux )ڊ 8t  u
8?ud a9Se[00t@uSQ2t7:P  q@@o p#tS Q<uȸ
  u`Q 	Ɵ
3{0p  ?D q tu1
S
L_
 п  Pr	 s]e`ߠR	Xߡs9 SRhPhP %p`hhċ؀ hXhXhpNPSRojz`ha\C``\b tAMhP À߫E@A2!QRPS [X"3t z  
\U 0Ap@`6
u&Lfr
u02,RW_Zr&&&E&]ж  faP$<???M=E>@. SQWU]hWPAXð PR Z} .a;tH rXt AXft,` wXC_wS" Qr f $~ >Pjʸ`~`XdrpC f_`uQ`Mt'f ITAfgfP 2gaYld 
@`tXW
Hpc=&M_0g.g͵ Ã? t0;r+gCC PsGPh*j0BaAΝrJ`P!uuǷtQ Py P{fѰ pԊ6`Ȏt @.d  w >`QOua8tY*_O# Qj<.uO R%K0f
1
fpDt\b? 8~ Atu p\2u3鈰u#Q?`
u"Qϊh:u9u
3auC*ulr'p bruzbtg&ON  r  g21OCk0`uܣ>l  ./S+`Nr1cP]0PQ>ư c r\d` WBtC>r-`w 0 r0\nҊ1 r
- u`d`Q rdItf s`QRpƁ 4iNr&r!ww3҆r r	?~aRc1@%rчQ0pPQss
d Sr	r1V>Rдf   dgfPyuwR Z@}h ٓk~C Zd{.!Q "; Ypp  2  ,u  QP hEo/2R

Z@uѢذ* o rā t 0eINQ ڿR]R  UrDC	I 4~P>qS t33J*~`R
t#4 c ttcqÈ~~QRWV+ʹ++3"a^S_Z$"#`1$G<u $V{% 4^W _  虄"  !(<t7ʹ 	
R
q0xJ
g&Ơ/ܱ1q;QM_-r;@N
r;x;q;0(XJ2`ubupcRVа$rN ;rCr<,	r32pt0rr;ws^ZW
Ph  0u
˾  uQN fQl uf2 J3322t@ ?0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2tAu	u˸
S_ø
_.@W.~.1.ы.a.6r..2YDذVPCp X8@f #g&   hpOMD c GfXfdX)#U øD	AeP;eP̲*	  ?DD zTJEF VC HكIڄ#R
N)zf1r f+fM=h?tff-EQfeΟffqy  f>PAMSuff>r^0
wS`01ལɾθ f?|	! "f#JIQf[f1hfNt :Q j rY p E 0fP < u ohgh-Wrf#R fBRh1h^Aa[
hPkTt.~rB @
E<u@
/Pk
`Ffpt0`7I"a`j uL$D"ЎQVHr&=t&} tV" &GF^YՃ"
\~ؾ䱈0 	 hyų!
 



ZD
@
	


 


	'h@߰(4Rغ0 t@Z`A9 <} h <2<
 1V^                                                              xUPRPRVFZX0RR30ZO                              ƌȎ Ѝv؋h3 PSu<wߗZ+pw	+ב7fPSfW> tUuR uIB<t>t9u2Vr-pUr!\s Mtg&G!P _  f_[fPSQ3MtZgf&g)tKVr30Ȼ s0w0s$
 Op 2YPLG"brLtt0 	
   SQVȾ
@ 8t"8tr5o^Y[At,&
u>ut
$sE t> uJ"t$	&
Vs@  P
to9 {	>!2
XTvt PIOQuu4QtCƠ P < t'$  
uwa>؀
	 >t It0z P'ug *cr$- t> uBu
 =胿i  ((r"~1kt 	ͮJbSQPX>tV
r0.SG%JtB0,D0.r//Y=6It_6tP mrB36su%
u "i786 R56cC$_tzu QطcZtb5;sW;sarQu	Ju u"
߀uPF"
23LQd2  ߢM2t * 2)P5t:XSfW@0`
Ht`D_8f_[X\fsg](r3
q2# fPRfQfSff%|h f
 1 fȺ4Aof# uOf3\f (,#%9tfu!!01 f0 t0f.{fEf`f[fYZ Z! &
#@CCfW @ f$_ u8  U*t fmt	T5f`nf_À fp]  <Zu+?:GrJG /<ZF@ h^Nt :Q j f
`ޱt{pP Ofpa̠$
	
0
ú:cptT+f@
@# N6Ƈ| Ā| D_ 1údo u"viO "    t 	'Of@ @< !@b,l@U	ـ@g&Nf@  %0 &!#WiPsR%0("+1#\A~Rw--f#f1%+3487` $6B' $ 
 9f 3Q'
f~;pZؔS	*; P'α'~7p
f31f1
s-AqfYfĳ j%s@S؁SC@V~#t68p%f&ȿ ff]t33u7^`Zf
jR3һX3t@s8grS 
'` ( h?%Z0`! 
 * 4*ZtBT0	f%1OKjۊBE&$ PT؃22B(RfZ2/ 2öM*!wKmꆠ ]K T1e1$2"c#D2tͣ>e2222*22#2**.rU52L  Q<	n0<F f.:!u<zw2~ aKf&@c"lk`\ߐSlذsIrHe([+4q;xV4t? u+_q,[ff[PbGQyG`0 ׎؋w0ѿ}tA.' u6`" faò
rzffhflcs
{|8>.h g|fr0kfA@fP 6fAliqm	sdr
h1hluzPs6GjhiIr d @ hsxWfV"D pw󰴧tf!SYPR&]rZqf^PR_'i!Q,͵֟PCƧà;0/ABSOLUTE=WfQPg&
tfAfg&tRXc_f^` غ   nBnnnnJFn aÿS `À PA3ێ7ǿ!C A!Cu3ۏ0;R `E.ZphZfP 0	fXc  h IfI~~ɴXm``C&II>茴>&]裴.pu	Ԁ u6Qzۚ?
 ^lt嚿tʮ+t8QWP3 PhX@.X=X@uX_YPTArup$ qA!桀./$> u
P/C@Xuð6C @B T }Aq|SQgfg tH u.g :fpg&ffs~} ffߋȀ5p5fW󨰒<(.~&gfwBfs~DP
hg!!
#4	fRSpjc6oUq u芐d

(PE
uXO20fQ`Rf   t Vp Up YheVИRÃНt%tg&g!gg@f bOt9tg>E @ t9g5CgT@Z),g>E %^g> !Pq'^d`g
ز
U".   R*·Of "Q1` t 1Yq,.028 L$֋Z̳^/-3qSkP;/1C%IbPR9ƘX
H=e`Ⱥ tP߬  q&aQu Nx  
| R Q  F7tQR¸ fAPffX0fff~c    ` 
a""rRls 33#<fp<?f
 
@f ދӃd%\hpPf=a# W"p   #f_prSaifָ =t5ha!cbfPRQa!% = u5
>7= u= Ʊ!` !gf;Q/3f#b 98P33HZ+ (aAPm UQ   ,A}048 |N@?W~4l#	5 A ` 2shDބ_foCȺ:3 tfP1!f4A  Y -<t[)f߁p2   7t2 ty,fP _$iRD''1' fKXq755o&    i-G:	    `G:ĳ <P 1;MXw1?BD۾1;bm:@S!:uP: ):Pׁ}12P u%o:X	 :@|;2䀥SP2
tˀa	:$

:Àu9<X[Xpx?!~ak:؀a
x:20i0|P@<KrKuX C                                                             L Z2Od1}) tQd@~             p                                                                      x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  68DTA   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 ys f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰5yf戰 rfFf    戰戰3|f  f   f戰fSlf[f   f   3f   f  戰g&CfFfCg戰|w}s 撰fPfSfQf   fQf3یff
   `xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 xfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
fQgf  ,fsf {ta$f  ,fsf ;Vf  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i%Uf  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            f   ff   2fff   ff3Nd.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2TdTl           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < f}f%f  $f$
tWppqtHf}fupppppq~f~fupppppqf  f  gffLggf^gfnf    f
   "ft~Ofupppppqg- f~&ff~ff  @$f@$
= u$<T)f~ff  @$f@$
и f  D$fD$
аf4f% = ufPsf fe^f %  fBfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰ff䎊f*ff<f掺<uf`cf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`tf  O}f  對 f    < tg                                      	            !       p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR   C vZ[XPSR !Z[XPSR   C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV  tA   % g&ƅ    fK  \g&  	uf^Z[XPSRfV  tA   % g&ƅ    fK  g&  	uf^Z[XPSR     qZ[XSR  z C vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  f" A vY[fXf` f;.t
f.   ~ $C vf3 
 f    fgf&E   > uF f+  gf;tgf+gfkf0f   gf;tgf+gfkffaPf  3XPSRfVg&ƅ    fK   <  f{  	g&"  @v@ g&  s f{  	> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      4    戰䈽QjW戰䈽gfsPf}밳f:f찴f$fаff f%"fדfmffHf	f f!f+/f7f f
   `"	f   f3f30f  0fkXff   f f    0f  f f   0	 f%"fff.4f.( f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.:f..`tfP  
zf[  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf   FUus  6
  >rfg   ( r  .V>Mff<>3fffrrfff> wf   >ff%f3fff> trf> wf   >/>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf    } >urd>u]R	 D>u=/>u(f ']  >	r  KI	s 撰 X+Eۗ;Uo/=RnfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@
 > uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v)` f+  G 
f   ufaPSQVL	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6)!js>t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&
gF
&!sw>taf`f   gF
$& 
gF
& !s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f  & gF
$
gF
f  !sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њvab  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tfz  ?   f  +   f     f  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z6`6fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇$ *"[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR $# &1 (ZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fО  fPQgf0& YfXf    gf~gfNgfVgfϤfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .
<t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   T r
g8u   f[                                Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf
   f   f<rffYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{ff[ffD    2ø     "  @ *5M06/23/06DATǞ  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        