#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68YVD)  - Linux-Based"
BIOS_VERSION="F.0C"
FILENAME="sp33587.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o44  )t4   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68YVD   BIN  2?55  M5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  6   d             F  /    I  
     &  o  A  )    %  z
  T
  
      U    y          ?  .          q  i  G    5          s"  m"  !           &       &  %  $  c$  N$  $  5#  /#  !#   }
 }
 }
Z*  A*  !*  *  )  )  )   }
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}
C  rC  AC  ;C  B  I  I  H  F  F  1F  +F  F  V}
&}
}
}
}
}
}
x}
N}
0}
}
}
}
}
}
}
p}
R}
4}
 S  S  S  S  S   ya  &a  a  
a  `  d  d  e    	}
2}
,}
}
    u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3Ðjː
  F  F~ F F^9 uvfv)}fvfvu)~h	h jMRP%Vtj
fvvPB
h	h jN~RPVtj
fvvP
 Ð3f>^  tf6^ 覌f>  tf6 蓌j b	  V  h jh jh j鐃h  h 苒j>bh 蚐~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ?F^v&v&8 uNV  *=p t -d jHH|f6B jRPvkjzRP
jjRPjZRPꈃjJRPڈj:RPʈj	*RP躈j
RP誈j
RP蚈jRP芈j
RPzjqbT-r - @- (FF9F}-^v&&?-t^F&&?/uF ]=sjxtRPja]tjyURP凃ja>V   h	h hn  gvxvuj fh  ! hy
h@f6vfh   hy
h@f| f6vefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRPja]]fh  j Ԉ^ ` ^ ujzMRP݆j`s>R  tG  =]t( !  9  =  A  E  I jJj1fjZ   ujzRPcjZ`
t(b       ؎f&fjxRPj`>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uH>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRP3jT HHtH
>T  t7>N  t0f|A  h|h|j苁
> tjJRPڄ>J  t
j ^Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uwG4(~ tfj fj G0F   =HtkI-
 -!- - - 
tFfA> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Cd   F >J  t@Kt B= M- K- '-M- 0- )fjA>J  tzj \^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j襄}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPyfvFPfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;FvfvWFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPtWFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP豄
k3ÐSfv
 ÐT  Vfh  P FP߄f|K  Fhh|h|j䁃> t3^ÐFP^{BFVh	h FPJRPhzh	h fv.RPhd zfvhd Rz ^Ð  F@Fy
|"~FFhh|h|j:}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Uu*u%f6vfh  f6^ ^= uv&G
 tf6v\놐f6v\?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP	
fh   vfh`  j f6^ ~@v>  WV	~ľ" f~ th	h FPZx~qFPu3^_h	h hd [vxvtj ff-   fPf6vz
f6vjFPy
f6v|j ff-    fPf6vy
f6vjFP]y
f6vb|~ uo~|ij ff-  fPf6vy
uLf6vjFPy
f6v|F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vzYFPhf6v]Y ^_Ð~ fh  h	h hd Zvxvcfp    	prff9psTf6vfh  f6^ Y= Yv&G
 Lfh   f6pfh  `f6^ %*t"f6vXfh  `^^_Ðfh   vfh`  j f6^ }
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP~
<F> tjJj1j f6 ~jh	h(      RP6~
6 hy
h@     RP~
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|jt
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   h!NNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jz> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|jy> tjk\RPv  fh  ! hy
h@O|j3RPYF  @ +FHuF F^
&@VxR&*RhRj*YF 9F}j >~Ĉf<t<uh	h2 XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRP vjJ`RPu3ø VxR&RhRjYh4XtwupÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RP9LFVfFf  fP!L;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  f|

 hh|h|jv> u0>} u)6~fv5K6fFf   fPK^_ÐfF    fFffFȸ	~4 fffFfFfFfFf-   f;FvfvJFVِf~qhXku2f+fFfFf~svBPƋVFVRPfJِ^_   jF "hRj
GVj[RPGUFF*;s6Pj:RP&UF*P4uVxR&
R뫐VxR&
RhRj
Uj|RPurju,jCRPYrjDRPIr>J  tVhhd jRPTÐ  F=fh  Qhh?t"jMQRPqjNARPqj{/RPqfh  ujEF 
jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPSj F*P{u>X Xt	>X YvjKyRPh	h> _SjLcRPh	hD IS>J  /t~ h	h2  SF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPRj F*PlujzRPh	hH hhd j_RPKRj[ORPjZERPh	hN +RÐ  :l1fh hht"jMRPojNRP{oj{RPiofh  ujEF  jRPh	hH QF~  FF*;s>  u+ҊN*+= utԊF*PjURPAQjF*P%u>X Xt	>X YvjK#RPh	h> 	QjL
RPh	hD P>J  t~ F 8VxR&
RhRj
QF~sF F FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RRP>PjF*P"uj0RPh	hH  hhd j RPPj[RPjZRPh	hN OÐ  F >\ ut~ th	hV h	hb FP*ih	h FPLFVu3vPfh  f6^ xL= s^&G
 tF  fvLKO>\ u~ t	h	hn h	hz FPhh	h FPLFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPUCȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP0C  F /u3tF f6^ FPu1F~rh	h h	hV JFVtvPfh  f6^ ML= s^&G
 tF  fvI~ ujRPMh	hV j!RPMF*  F u3A.tt~ th	hV FPfj"h	hb FPfj#JRPFPfh	h FP JFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$RPL0F~  F ohRj
MF  hRj MFj$;F~VxR& R܊F*PjsRP_Lf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%RPL~ u~ tjjRPKF  F f6^ FP%/~uPh	h h	hV HFVu3vPfh  f6^ I= s^&G
 tF  fv`GFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP&Kf6^ FP{=uh	h2 Kh	h h	hn GFVtvPfh   f6^ >I= s^&G
 tF  fvFVxR&
R
hRj
KF hRj sKFj N*;~VxR& RՐVxR&
RhRj
'K~ uj5RP!Jh	hn j!RP	JF*  F u3At~ th	hn FPMcj"h	hz FP8cj#RPFP#ch	h FPzFFVtvPfh   f6^ uF= s^&G
 tF  fvIE~  j$YRPEI:EF phRj
JF  hRj JFj$T;F~VxR& R܊F*PjRPHf6^ FP
;FF~s#~ t~ uVwR&
Rt~ tFPFPj%RP}H~ u~ tjjqRP]HF  F f6^ FP:u3À~uLh	h h	hn EFVtvPfh   f6^ nF= s^&G
 tF  fvCFÐUf6^ FP:ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S[c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPlbFPNQVRh	h fvbvvvh	h FP3bFPFPm]ÐUvދRP]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfv\FN^v&8 t&@ ^fj <fh  vfh   !j݃RPf6B \*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0%݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0ۃFVRPZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjكFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
X
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7؃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w׃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0уRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &pуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0΃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFPY"ÐFP>\ u*!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhDAht<thDAhِ != t= ut uу>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShBhR*F*PʃuFL| j hBhR jvʃ]FUtKjXʃhy
hd j hjlfj hG=thBhREtÐhy
hhy
h~&Ð&ÐU~ u hy
hjhHhy
hjh7F  F~ ujFÐF Df>   F{ j hChfh  >˃uF  F+uF~  ~1 F  F*@N*1 j hChFff   ffffN*+;|;s9 u(jSffYffffN*+ = utj F*Pyʃr>X Xt	>X Y6fj hF~.F 1 j hChF HFff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ 'ڃF*@N*1 j hChE>  u+ff   ffffN*+ = uFj F*P[Ƀ2~ fj hF
  fh  Ƀhy
hd fh  ȃt"hy
hhy
h幃t"fj hEfj hn
=uhhCht!hChtTfj hU~ u hy
hjhhy
hjhF  F~ ujFÐF Df>   F{ j hFhfh ȃuF  FuF~  ~s1 F  Fff   ffffN*+;|;sF*@N*1 ShFh0>  u)ff   ffffN*+ = utjF*PHǃq>X Xt	>X Y5fj hfF~.F 1 F 5Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ ׃F*@N*1 j hFh)jF*Pqƃh~ fj hF#  fh -ƃhy
hd fh ƃt"hy
hhy
ht"fj hEfj hn#=uhFht!hFhtjfj hÃ>J  tj htt t   1 ~ ujރFÐF Dj ԃud j hIh$tF F~s3c F*1 j hIh$FPuFA j hIh$he>\ utTtMztFj t:hFhIfj hn=thIh$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j hJhBFPuF<A j hJhBh또>\ ut>t7j hj }fj h=thJhBtÐ  Z1 ~ uj܃FÐj҃uÐF DTd j hKh`tF F~s3Tj F*1 Zj hKh`FPuFZA j hKh`hc>\ utTtMtFjt:hFh	gfj hn=thKh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPtFPhy
hՃ~ th	hDh	hPFP3h	h FPUFVu3vPfh0  FPLfv4FPhy
hqո U<ՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H4hLӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhT  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAhуfh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhJуm$PÐUj
0ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
~ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h=σÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hW̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̃fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth 
Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPTtFPhy
hgȃ~ th	h\h	hhFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhy
hǸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..qcf^gef[UfS..qcf^gef[UfS..qcf^gfeff[UPfS..qcf^Fgef[XUPfS..qcf^Fgef[XUfPfS..qcf^fFgfef[fX                           UfPS^tf3ffqc  f.c.c "  u  $" u [fX 0!<s3P˿y
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666QP.eظ eP.eۚj  y>	uXP 
 Py
 5! %d!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.|Vuxyyy{|w{{{{yx
x{{ru{x{{w{{zuRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }}}}~"~K~}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.2}V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33By
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3y
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![#%!uslkʻ 

FV]U- .8tK
I	]PPR.e؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUy
ء
F
F]XSQRy
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.eۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uTtT^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              y
              4.69  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This is an older version of BIOS which is not compatible with your system configuration BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) E  + , B  . / H  \ ] I a b VJ e f 8K h i 8L '  y
 `  y
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d					$		^														

	&
	F
	Z
	n
	~
	
	
	
	
	
	(		>	Z	|	.			n			6	T	n							(
	V
	
	
	
	
		$	4	                                  E    F    B l by
      C    D    B l y
      G    H    B l y
      K    L    B l y
      M    N    B l y
      Q    R l y
      P    O n y
      I    J    R l (y
      -     1    + o Fy
      V     S n dy
      *    1    ( o |y
      T    U     W   
X   
S m y
      Z    [    Y l y
      0     1    . o y
      _    ^ m  y
      c     1    a o y
      g     1    e o 6y
      j     1    h o Ty
      q    r    s    t     u     p l ry
               e                           _C_FILE_INFO=                                                         y
               
	
\ \                                  [y
  [y
                                                                                                                                                                                                                                                                                                                                                                                                                                             *y
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          fffffff               (((((                  H                                                                                                                                        "                                                     ddd                  rny
y
y
y
y
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                               p   `      POST  f   f.V .X <  
 f.d ` j  I     '     @      POST $`  f  ; ^ l w	 `W
  p_ 
 _ ` _ x ;  w  `    ] x P^ w W Y X  ! " 
# pd$ n% "& 4^' 0( ) tX* d+ , - . e/ 0 w1 2 23 ;4 Ф5 [6  r7 ^p8 9  : :; 'X< = > ? 9c@ A B ֦C D E <F &<G H B^I wJ pK CL M ;N _O P pZQ PR !S T U 
V cW X Y Z >[ w\ 	]@^ V_ P` Wa ;b 9wc yd we f ;g f3" f" @ ؠ   ؎  f{  3  3    ] QVW.D? PRNZX+ hX@ .X=X@u
_^rYPSظ hc [X <t
B	PW |f&E1_X  fPfSfQfRfGenu fntel ineIufp%={pifa2fuYA؀,߰Uh%|buf0/0P   t
 p0fZfYf[fUfVfWfQh'rOS  rDwM@h0f @f  f   gf  P^  5wMP_f^]UQWfV6  
fvh.~uF F 73h3f^_wYH	h r rD(gf 
  #3fRS B_&< t2Z@fv tNh.sHtDs ʆ h}/ 3h=(BFv} ~&#3
Pf~f#ff   @
>tq  tgfNg A	~tfF  ΁ 3
[""{3yą(BF t~y2h5*Ff3ҲZh"17F?fVFf;Fu-04Z3  
 VWRkQS:5>P-Ƈ~<[YZ_ ^d<<0@ I=~>A   0! <" #@ W AW W W g  g !g g w w w Yw      . 0     E A gggg  ww   A  3   W@ g  =S@ c W &0+ '0!'<"'#' PQRa&G$`Ȱ hRTZYXSQWa$a$a  h6GbV h >_Y[2揺 TCwA6  @A Q C@@ @;uYð!桟$p hL6f`  訞fa.h!c	 hv

 < _WR/R@g&gf&PPPX`qfX61POsP@2hsX_$h*N(4Jy1t'J3hdW~hTX_h,dN`N  &  -fغf@c  @tÀt0kfp
Ph+
}}
thDs_gfTDSDh|< n su1V}uu US3 d U
  % [VWUW4Ai
$ ~,#h_93*uuɀ0 \@@h[Xsu h/D,Ⱥ: @p 3ȰS3 @ukSRhG 7wivhs}  f4  =p* t*+
-@9/6/a fDd  
hS (ů`4aP斨*<X`Q3 @ PQ= `t
3@ @fYX _Fðd+`>d  BPHku   P"ǰepЖEt&؁K uM9NwN%uӃ~ uЋF= wt%   +PNXh"#I`.  	`  a? `h0#t*#u UT^Ju LtPRf `PX~f.@p DpA^ ~ Rf` yf ư:M0?"1aPSQRfW.f_Z3f0fV  ]  g& Y @},fq$<s
h r0@#8P%<@$ Vf aGjE sFf`Ǫf;>@pF=['hr\ ;s(Ǻ$ fޭ޺f^whw3jf`Hd ns0 hUuf u0hv2ɨr-
tp ^asagr?1s O}
PLIkfa	't5<st1ofƞUÿ7@ O i  "B<[ \ ]_^^   C<` a b cڄ deB+VWc3p96DP7
` yֽft]RpfR^_^C R^"R  Zt  ZRu  ZZY L 6P  C6Tf.fff$a0fW.^u& 5f 5_xuwu.f_,+  > A A   T  M e M@@  9 Y .   }n SdA A }t (
p@   +i{!0j0S2 P f{\!~ m6<f6K  3 |p0 6>x  .hncPSҔ $<t4r K! 
h03 o f`7 V  %3PChaO"߱hBs0 &D 3 P>hhR1>&߈D{Ŀ2X"pr zF>2廙"i>z0l=r=> >=r% >=&5&D&ENa>yA	VW `h#
 ߿?y S?
34$eU?rVD?~^ ؐ8!3~3w? Ŀӝ'?p0?f`RPf&@ U$=u&?f= =u ʾ&?&?&?f
, fgh  0 pqr  <ABCDE I@xyz{|}   nV ;SC
f
a r&?&?芿 r
&   x"@&
@pCfxf5f\v&V3
Ê^ ..0t+.FuN.Pp'ӌ>6GX& °pUSW! 3fv߿ hS  ޿R&_~22ك!IN܀3T
^
u
t_NA&>=_[]f^_"GEWM
) "5! ` PNvE S\PVr?&=;u&&0u_&^SH&<#I+&~&p>E&D*mSV h^¹^[þwp`nWfP Rȁ  <fX_vqF9=Boot Device Menu  Lo?ading AK/r..t=  `   N@ 3u.?$<t) \p !0r @ ^qֲaN &	4Zò Gt
.>@ t.F10=ROM Based Setup EnterPQQCV2u0M Ԁ
a@at2 t*164sW / 	QURf1Mr? Pt
(*˦t hCPXhDsF12=Ne_tworkr2((Wake On LANAtte7mpt'to(%p  ah!bt8 *@r	 A'@u1+ A1+Lq	~o YK1-t,sMsU. T.@W.- d!.3~b2-@1- 7_"ss..	BIؾ`<^*Rso Ŋb8CSVRyS`ЎNF _3؁_?	uCFG~N0tG;h7aw_vﱕhZ^òP*Notebook Hard Drive O`#cal Disk Dock1Mb= Multibay? (top)bottom)leftf	Floppy)US9BCD-!G 1
B Superu6Controller|NIC 123                         $BP ` 	m~ 
@
0 2P P n <prlectゔs  ͹U8 and _mo@=the highl@ tp`your cho .  Press3x1bose.Seconds until au;}a A defa> start: R!,!(T!$xP !'!;S a;Zip d}D`&Zry!, h2 wv.!
00.!eR!p   _3_؊' tA<v<st1!& 22}$Q#YAr
 T@y`B.!
*! @!+jjj(Pjߚ[B  ! ~`!  }  ̢ z>! u !u~ M 2.蔿  t03!2Ɋ <F8tFn_ $ bPdq AURVQ`q.,.L.T^Y^Z]S,.!*[QSVW7 s.t$Q!.<.-00?>@.@уY_^[YDQt  u#2 = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=Ј
=
tu z`2΂ XʱpP0
!  r
;wo2 `O!JQ1gFYô.*!<%20fˀOhv̑{ h6οh7 hU#иd h<u	f  ` }f0hB_ J  Wo rf.>%46fgf&G, @ f   PG0f@G, Ru
hG,f",f_ffyP fQpt#QWK2_Yf= TKStfXbco    ? o N     @  yx] r "R@  / h/45wg&Fg&Fg&F"tug&F0a 1 2P޾&׎Ǎ~A@rL.&p q  Q1'@	( 
دVWpL _^QRVT	 r&e^ZY&ffL]LPp r
рYSQ&|\DLQH Yr)&}at&E'T+ r
W3`$&c 錄&UPfSVU/fQW (v K&C' @C$BC$ rx  q#ȑ# r]" tsrg or7݀ K: k;WQT r}Q G1"C""Y_r
E@t:]^f[XQ}$C"uV6e7u!#,ABM  f.)PS [XAu.6)f))IDNU.)SfV0sQ`/^31Ýf^[
3u
u r5t!q!} "6W3 hQo< a70"cGhU3 .5)cf_p`= v[ OQ[ aP h%|h$@<@XJQ FSQRWh^Bkr_ZMP TC r99 r/ uw t t.@XR1$tut0ZSWQR fu
ʀ;gZY_
_*eu}  Ygу< @3ɹ2 uhT{#b)¼ P% = @uX%"4g&E@0RIaX;mWi	t<f_+H1q 2r u3 4Q0 L  @ ^"r o 	nid    5
 A
 rrtf &@&@@ p p 3Wf$B[st$ uf_*sC>@ tuc ~rh^
&@ f3C<thhP}@ O Gp2?[}4 Q < t&_@Gf&

AAv3f30 2ɴ*f&@ uf
ffKЌCA&;A&KAfC0TATXP`2Ap8AfipRf wfP3ffCf[fKfS܃fF0rЁ0а K I+r?_f^fZАuVWϾ u@3^_^ Ց	!BKV 
R3
t<^f~
w/v/f0kd`Pfft@`[0VQWfv h.G-F&BF&p &{ &
P&&0&&&&B ^Uaf   rGt >`*:u
P0Yh\X`aƴWõadf]PPRZJQ  dh}jjj%jG Pϴ	fPv h~sg
w  hkEú  O hckp_4 h/sm ~  (` t 	2se f3 ffff>3fhsU	 `Ug&; 	 f)f)ftg&t` b   tHtx3~srnfǂB 0E	f~/uP~/t a	pW;(3tM ˤ6]                                                           @   'Tff.33Wu u[rWJrR-rM3tf0fqP| @Wb t#r"t p ; }PJR  ZR pf]LCqfUr*6@^  RNZ0rG	0KuҰo!!Vg&fFfFf^0ӱe rC\A@3ۿYyP8E tEG? SBWAi5m r`5>3p@ҍmN8lql0h0c߰W rt r
 GC_RZt$ؤÚb$]W 躿 _W spO  a #`P
߰@S P  	ð D v Sذ8 ðe R	$#
R'
//(QWjuptPX_Yù
 d h$Bsxusz
ՏP <.<u.uĀ ~RR]1R22< uZ#ȴ$ t	5J k 
	a!ybVfpwf@Ơ,Ј1^heàhӫh8\$4/h GKhɣuԺv û  PQW 0> 3_YX;hQs=I @%h*Ss	B~ Hð   ! $o!f``STPVh%
@u' tf hGa60vP<F X8[`ؾL &>_&DEP&D >`u dv ٙ%j@ t_}
 +Ȁ}	 >_ 33S [tS[a> 2[sd3 th2h܋Ws
JhOaàh;ƈD
ϰ<QDuL
p
E$<u~ D
sd
rSOi&pS]@` uL
 6 6_ u  (X6 &
uhP
	\

u   	D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&?  t"& xu	~\	PS   ? @4P'>__3& ?! W>_	_[XB
t+# P xt  t  w\DPV!$!"桾t+h*s
h_F
1 &.@ &  ~`"hC#r!L	vTt
vCn	`WU&@t! $<vJ_`
SQ3  v
p''
u$< t"<u PP>ȷXlPRtϊ σϰϹ:В7thT^' *#ă@B=q4]ZXPz` 22Iǿ`&Gt5_=_tOu:0: u	Et!sE=`: u5 2Scs
{t!^& q s  a
׃/ a3eDs{&=  V ?`u ?a^  3f8G0.af_  }0 U!    a&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr Ǿ`NM0oOg&2a/` 8o(5'_
B!8e<t2>Er54_k,P*`THtX@LDhJ =_7_D D	 d
/z=1>bctSvrG&}	r??23ɰ6t`hȈa&EY$f	&M&]aN`.'`a%# rZ [wcϠuR0၍ZW&߃= uqF=HNY
{h Mߧ˃8h݅P. Rhg+ҚmZ˰k_Wfat
q tVP
} t   U!w#w !#`0|wnv
h3 E.-.׊MZN0CtI! //(rE.58vSe+`T[uA gr@ О\B   ڋh6ӝhsaW$
D h
hvYТ@[X_Ë
`PS@&[X Sϲ
A HWU<vLR
Z,<u(Rf/fU |,ZJvG! !
u
wߊ 0wS=H
sA  Uу[¡n{$pu 0Go@a  f3Ұfw<z p@`{Ph.F3۹ F
t8:u4u%BDqD	&߰ h!п_ &	 hS_3GaB3  Jѹ  _ aSYu0  Y [\ rYǃN rKfq `4<t0s]a&' t&߀1@R- عK'\
'+QrM$uRÉ
ǆZЉtpt! ?g rhh0		 & YQPI?|C`[r%u % = +0Y!j\W[s`U3_+6 
{HH؋E&AE 1, ^@r g gh_хxf@txްWV @@'$P<PtRZR1pwŁ 褀 O}Zs Z^1iWV 0  Ph/X@ 052+7
*2ƀƐ,?!C@?r@yDt5Q0 1u,u1 
@a

+&C323&v@t } %
t&
0 迪 5  O"   ( ;
uӴ: +>d!	"	? A%o ^Q|PRWD&A &]&U ˀA] _ZX"3һ -wf2C."/⾵#N 3#U_<XV߸^  [^    9dp>u  'SX \ P`NZfDa[f3fSu 3 Q>O_\:uBE&8Uu8p]
R +B&U
ZK!ؾNZa6fYBP)7%qr h܋  G;!	't/u=
 4Ã?h*sB@-
<t`ZPێPsV#
E^f  XO_ED
B H1   RSSUf`3؎ FwAP.p ڎfafSfQf.;Pf fff#fYf[2VftGf   .PIgf;t&fW ,m	F`$f^`2ۈfaf`c࿿faPP3_X.>0P , . P	TACO F S 
!	& .,P0s<F	.P fFf.;P  3PF.?Pf.>;P;E.?P  t1PttYp2PtNp  D@SIVfB. f$;VrT%1W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p ,P%f@c .f³fHp3fXfadf3ۃ!u|+`s?I
s*"/S"Vf+f;wfff33RRE7Po4^q4'r44$.71p6ɐp08333Ҹ  QW>Z% |F
3}@u'JE.ȩ t0 t ߋ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^) u{Q`  &t Y&_  
 < tr&\]p &\U&T 
U `&$|Nd _
S &	F& $F^[_µF F@Zp 0UW(rPVW> ًذP6' `S'! _^Y[XÿWfQS Q[ fbt
  [fY_` t =$P nPu2MرtaPfh	#fZ6أ#s } t@( ` j &&E`?SRUPQj@6^]Z`V` kVPǌD^Xp~ 
*?F
  t#cR0`n{F F[s d3d0hKu`<Uuùd `fh}4d w& Xto D߻& h/ PhE'`X!$!"   °osA 
ehì"   t7t 4  hϿs` tKu& & O 
 0` h,s@<t<uouв 
}0u?1*`P	hC Xh % P 'PD[%ys)aPR怺NZX÷*%#@!1*1Up)t_QX`$}  .`G  c`3 :Dqp8,    ; Z x     0N@`^~$bhl201fF3.Z& r 
_0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KہãZ.~r@V» 㐅ÿ< f ff @fUPxf!N 
 ffFf3fvZfFswfBf〹fЬ1 r9\pf3ɰ?ǿzfAP  fafPVa3vrF3 X

S,0<	v	,$\.[W D`

Lb f s  f 
T?
T p s 	 
Sfw_f@s ЎfvPV.ZP, Pr:F s
uf^fNfV_Sf^pPRp*fVA6F1@20hC@ Ң
 ff  fffffXܽq p  `90] P9󤿾J_" v / a+P*h}P, P)9u&ն^t$g hGh/8bfPRh7l2R ĺMP  (Q * 4ff:aD0  %=f3X2St 2MMSh   hɀhvh7]BvcZqpq$ q~!̰Āuǀ̀!A ts0NCðvstut
t<1w(<vP޲|Eh3_0P&
0
3q 33Ҋ|tW/g.&;u;@.ont)@)hPҎt	؀a`2G@t03@ @u  c,[
u93Q^2,;8.Np

PH/j4rX? 7Qr 3X@Y8SQ@2P5 && &0hh~C hL÷uɰ hh"
t[ Ȱ t
坪ŀv#t̫,5-PXv8v&>궸 㟸`t`݀_RP3 u $h_9H  
#V   .>8c  22hޓ|ur述um&?迵ua 
wU0c2 }Q  hcu= Ct= DQ tY0)Yq"Y.8c^Ga1讶P$WSQR4 @3@_&}u -:$ [#%aW곽aZY[_
U ° Pf_^ ]ӡr5r	 
c) OLP?HO      6dP8;V(6 
u^V- ^"(P*^  2{SP( 22< `2X[úB  $P?R  Zp?              sfp0[t /d& X   fgff+f@fABfLrkr.r^gf+Ff ^0r8Zr 8df\ rKCd7hHCab
fa<d PR 30 ZR" `&FpKJuhPp*Xh r.>d.dpu 	AѧQRfW.d0h f3f%  ff_ѫXURQSWF^
gF=Fg^ W^0F P^fPgfv
f;v F;F
 g< uYa  < g22 IF t Ռu뽸% 8t
` ppPj Ѓ;}
+V 
N JZ=u<N00?_[YZ]`P "&X&`PQp^ kPYPUkPk`W?]]]/D              'Dff6f.gu;v` Qx0 >jh *Yj"SwNQ f&߃ 'CCwKg  r)`Ÿ  j{=Y>SLP3rz?[M26$&%<GPPp	 @u꾱R  β <BMtf3rP2`@d  !XUrxUVWfU؎fO  f]f_~efpgfft&fVf( 7 f^3tHtHtuf@@ WvÀgF
fp f+3fGenuuufineIulfnteluc32= w7= wf+tHB,x<w<
r	gf0fP.nt%t0w<wėnf^f^3R_=u  @P	sfˀrڋ@<v rsKsrUt f 'u f%A'u븑'Y=uUfQ g*t`ftp  ffGg:tErIgfY]Y]`b`lf!;gtxg Q4 I 7f8"gYs g롑fH0\I!"ffú f@tfHptsuf( 0    rm8mlm` ! rmmm lnmnonZ:ɰ::Y1&u (yP=<}t	<@tMt# ufff uf@p t{U $3f=@  _rf,2us
_ws ] ff17;r? % r 1~W3P hG"t/ _@︄D trr	@RW Z
xxŎPp  .BB <t BB2J &ݾXp   8u!@塴`23Ұ
Sh0ht0`́ y aut0i at]U U[aSR  4h
 h/cZ[Õ`-1p  h@BS	 h#
 "B຀PaԀa$8uXRP<uYZQrtwv	Yu6ѹ }RPwZthU2<U   f@ ~ hoܚ u
3Ҹ EF) ud\st'Q鞀Yu	穀 o 1P)<%f.r URhUfVߟf!/#: r?sNk 2f. Gfjja]akf.>rff@Qfgf0uYKU q u, P3	f0pzCpzI{fzfgf.#f9u5ppfY7dw0    /p ;-hD [Zr/ UF]t PLQ h5, ٸo h*" /  OV3'%2@20Wt4; hޓ ;
V^BC"/fUi &g 9  f% '"u #WFfFA^fañcV ߳p @Z  
^Act[3[<    DTDw R Pto 0 ȳh  n1   c l ( ^Pb @0 W HL P`A T W Xb, `
`! p@pؾPtx o A0
|\D`QWhN3 3_`ӡ 0 PQ= `tq @YX pSPp
& p  ff& X[maa"&    i7 Qv|"}  [J傸O f!oQE S.\@.t4/0 聙L <t.@l~I tq..ri."D.|u.:DtSI  wD:zr5+s&v
uAm
cYC1%bPQk73^S
f -XÑ2
O`2	  "	f\Й@0f̰%  3f3OfPaX Ah  l0v  fb #&f fa dD 	hW"ϻ (;sQSfr?f.z
 
2@҃ȴ	40qޠ
 Q[ffY+vf[Wf+_f߃ t%xH+f@``h0Qؐ- f@rf`0z q_L2_&#y uZ=PrUf%@ uCf* f=`  t0  t( fu{f
1"0"fph_8%/$_!"
 \Ƞ\5cfFQ &Ffg&{ txs  @z{f;~t	uɰ&[~q|N|V&t||~VfPXfXT`r<wؠ.|YT5_1f{&ʿtg&fVlA8&f &fnu=жtsaNu(go&fVPf#"Ȁf+p*)^f^u2u  w & pP0XRhg+ZHt5vm2t
t@Y % r1 hh2>uqhsT-3&>por&qrRzsRPuthuu	r~` 	 CZjj b6uЂS`` FF ph2 ru
@ l&f  ؀>t !$!f$< urC u 
N<2<ăƾ	"3AG`[u TYP=t 
u2Ɋ،3`t<u
E< tȵE$<u&w $tRVL  N L wNh*`PC3u û t_  PH [Eu
j j4"GaE(!!2(<!a~$ hs7u$0ctu$~Q.#K-.t4&^  Jr&w 3.\  ".\B.d b    W	x .|h6Gr_DuQ&~% t PRXӹ
 .:t
 ._
vXP%8Xr6%Kfc4;5N    PJNL p      QKOMp @Kt  Jt P(.DG H hõ2h ߂ hR h  hAE AE^  ` f  Dp R^mZ oG 
v %&1O t&<
7&=r&0dp$qKx t1vVKuB!
O@!Ec(q  " s*R$	UfнP&` 	3a C 	H =rr`2ilhxI`˰v ]AaVRQShh~4ThL!5J.qbD6趋越8u,2
t&6<r@t2 sl ޝ[YZ^Sû PhCSX<?tFhhTwjjjj P[B &{h[\ hV[$vbwt = ;t= Dt
hr[wWVS%a%
a[= p= u"*׿OطhsOtd--B%J=Ot1vAf rh ^P#֧  o0dЅL P5W ?  :J2^?=q%A 	
   0X짋F`jeVW 2_2µ}t2 
u
2e o
 `r22&&&EA &e?
td&E&&sE E &E<r&}	rw@ VW^2`^2*à
&}vxh*sSPRQ3& 
%*t,YZR0 Zh?>tu	Wr0r Ї> UsQ  6dtXYl-7:Ϩ t$
*h"&&  t8t'V u ,F\o00"6$ `$ B[& &_& U<@[@ `odde`P`  XCĪU @p?
ڹ P顟 .p0B B8uG` A ; 5䋀/)@#BS ˫냱76vȜPR怺NZX @A@ B C    
& t𻰀&&'蝊<;weϋ X؊<wM3Q#"XR<  YыȊĴ3ЇуE [8 E
6u@uu<uz`0FVv	2U
8Fhtg}P׀k )ف. ."/  ҋ߀&k o!< uf& bÊ$
2 7Cu%|1uhG$3Pf  f#f#f#f#f#f#f#QLfPfSfQfRVWrh^~LfZLff
f[ohT0sof3f3ɹ f cof0n f+fgo ! KZu*ZآZ}y3ہysV4C\`;! a^ _^fZfYf[fX3hI# 5U`2L Ms< |&	3ytwpu4QU5? @֗w-t
"ARbKBC Kernel: xx.xx
 ` $ pK    t?{  .]3۸ 2ҹ5*@HaaÍ6h'9VWaر ?{_^ֈe` hhM>(U3=h5 uP$<X3(sf @  t<   4  r	.$<u
6 f3hh. 
d˃]p j`Jh2E=  tdbw_?s.>߄Npfo t@h3-LDC	
q!U2 u@? l > ]c p3ƿFd Fe f Fc~ce`@4~e uQ@@9 h|5Ĳ
P	Yh~BFe:Ffu1r,
 hU
 _Fd;   	:  <g htuPhɔcaf`THhKҏu;E#f% PCAXt# Nu	N r hf;   Fo^P XSĻ  y ,  o   h[t(t@_t,i i,>" ' À thYtZdúߋw."**=ED/.pE$q+Ë؀F/VU2NfQa dYF :uE]Àg33tVtst
}t
t
u
2րt#u
tN 3t"FFQ0u3! :5tFFdz ulm":``F:_ uYeb +u<6FO1 ep0Fff`Gup  j(j	R	aURh2   `1 h7Z]þpRfB0ap}r@"  t3hRQ Q;YsY2ޗ$
 !u$`e|Zf`  ðXXfI莧.&_f?  `Dh.
 PC u0u.>? 2fa
[FRtUqVHh}}yk:Zn @Zp to(tq 	.S u|#[i"g Tsq@u4VfRfsA`h*Ns3< ^f[^8" \c[YhYr vs pU١6raR 2R s rZQ4'VqpX  `.uNҝ_$<u7 pCr& .S t t@v t`t a%u 9Sި`
`
`
y`P` ¨_YSQ u,S?[r&
	!.Y[C<ff<`00x?x00`1~9||	>>.@ r
 ~ (r]ˀ'p &G =`!<!7' &$ spsC  E rB uzuN D /u00fAo ;q5F -7pc@V aUfV3vCDPDQD 7@f^]&o໰PP򁭼%OЂ ҰzwPduXdGd8`c@ ___ ̀/./././.$.a/ "  @f%wpԚq 4ō$r ?I FACS 
DBGP4BHP  30A3 A!  8  APIChOL6	 G	-		

 		
  ` MCFG<	?TCPA2`
PO A	    @( e '7
 2'A*N     %E  E ("A)EI*RSDT}(  I(X,f`Ȏ؎hcV h0ԟKf V fԝf.f\.gf^$f  "gfǆ`f3..ݝN~$_f.> `f$F@F f7hỤ0/#
3ffgf&f7.>@q~@$f.&F ~ FPTR UR
wg&FfyI!NcBpQffP[1(.
,.t~2P 6	~(Nb	Sǳ&  P 2fffcff+f+. umfm2
qiP	2	fYq@G>E@o4`P0Xff- ñqV3g&fFgY[sff=TDSDt; St3Pt+SBSt#f=CIPAtf=PGBDtf=GFCMtf=APCTt0tQr>$< u2{zRfQf̓2 t}dpumprUr*v!';l0 }E<Qtg&P
rX*fYf8ʰȥfWfV5?f& f~ >@/4~zp(@86f6fP)婊Ȁ$ 4 
Ȱ F
ff	hӊp@;fhirthpR;u3ɚ tQ fP{W %fXS /nDZfP-@p*ve*Xg$$n e i@g&_ h 3hT3X7`1f._]V   04[Yt P h*s 	t@pD8R^fñntD1``!! b# z  (dfK gD* 'RW D hG̀ hv _ZpPSS PSwu0PfP3m f&L fS\E@
L fX`hp" 03ofڴ`&?    6`u  a XOG.af63{ pޭ   U!   2a>a&geE E puMPM_GfEtXAt$}Ot3 t)O$fM
rþQpmMe&2aarrU  r.]h$r.ZmaMf |   \)ճ aW }f
PhezD0f%ttw' t %(뭿7 )P*io_VΎގƚ`L ^&Sf`FF  hHD uP h  $g(,0w4'8  s8Ã9FtFfNA:F> h64;ɭuh(fa`QDؿE13ɊMh?4t

hm3V;r%uacUWF ^USDf+FNPiNBf.9ߗu tc rfߺQPH_Drf;^uf;Nt;ft)   
tF~U_ 4WVf`w4
`ɍ_ @hS%*&VYRt }`!	Y8g&HPH `g&@uhfP _u	fX: ht@P@b
.ߵZXyu .qp ﲩ3 @ & .>tE fa^_.f   Q3g&w@hX
YH`g&Hh`XhuʋPd ְ+t+Wu+P+ òB@t\ؐ&PYɱRWV^_ )evG 6q_~qtA" u
3   t'>gf 1G򒀶G$L<LT|COMPAQ PC Card Smart Reader\GEMPLUS GPR400\PSCR CaLB REFLEX 20a241 PCMCIAfReflex v.2$cr$HP
  a@U! ,O@Gd hG`   rLfK s_cr>G	 .]D!G
A"O@.d.D4f`_ PQW 00)
G.P:uG Y.5 _YX8t<t@Fg 
a'fW
"
@
@B䀧g"

Pǁ%Qf_* - ,ycP`?P_aSMh2Ehu=} h5M^ Zu <t rUr  ЎvVrr^~W  2_s
 D<tJCrE.&=t&؋.ouV<0 ^Lx 
y z { RH  hC˸hDc| ,ỻ (ZehcLPt =upW  f  6
hߝ.?f>q tQа.#︻2M<t <^_A+p _*X$SQWȎ / <p^ c{rd~YrS&tM tB&=r6.থr(r%t&t2_Y[`
׎Ǎ~؃^^֋tU.6No09a 	9u;.> t N!&2 i `j0@雁kݮ!n󮁀n݂n@oU05Ej6.6y rr 

rf	B6Y`	rNb&at ?(4
<	r "	!vPb'О@ ; P 6rj&
 v p rTv&rB@r7&}u%&E=u f&E{DDpP r0
r 
t BB
rM
 SP r'24=@	rl.&:r_ vp6W Q
rP@ tI	<~ l
=@E
tQ& >¥?GYۜ5h2>QSVW	'	6	r`(= u< s_2.
q	%I@PP  r.2x0 w	P_^[YSQRpCТ8ؾM t_W؎В>'>'b?_
˃S3(QY2Dj5 3 3-W,.@|O_4,x60 ;^__^Z<^ 
TT ۸,P_`v.  p ,DPfLFs-<t(<#Ȁ0&Z h[L`E^àEPRU32t
t
u
ku
 ur ߀t!;rՀw/tM> ~"SQ X$Y[>"Q;>0I`u? 2a0`*SQY(E;?y!e	w]ZE]f``3r&th"13,֎fvp\@qgrgf9ktЦa D2 *0 thL0Rd1 m@ Vff3u"gf\ᲀ F f !3pf? t
@ /0޾'3۹: 8tCq'P qtrXfPňf uPPRVo
td췀P 	 & &$ЛTОRu	& 8t.ZPP^ P   0 ? 0    0   0
  З  дi CR01    '  '| s 
 /  %Rp   d]	b%ck@S$@G k"$Q  OM3	irPS.T2nް޾Zӎr\v uTW{rL0^wq  wQw1˸` 	y5rx36rdܸxE@&_=u
q * :QEP1[͹dޕerWЅ$^x!jғBq , @BB
B "JqZpuk\]dn(uI&QC!n
$̼0ӆΎރ"lr͐Wa Zž^DTr eþ55xD
Tb
4I^S4R߼r# t itct  t$1^0hff߉L7	] 	W0!	RS
ÿڽ@+0P3sr8u_QY_ 0Lr&U/{}L`
Æʾ2UO
ދA
s
t0<iu,:#/+]RS݈|\DL	z(`at^ ˸Šܙ03APLN[B&G,
\DLWC

@CPyX.	@ ` $2L1nB}0<th3H8t8u6
uBp & DBlTt
֐륑zaP 03 r/) r%BB J@ 
; 05 aùܿ<t

B J 2@u8ý` BŅI2۬2Pxu+BTl&2]Q8uC\u rq@m ri~ ra   tAc rF n r:i r5&D@u-&a${vQ> Yr	2QQ'YB@Aq Brm蹐~{  	  @@ `  !f@v  ff   S3 hӧtf3a	0mP P[1f`  t~ hëo tRTDWqXZ h/%  '( Wh{▟fa`    ut@u):< uup	@ o `e3OHrd rπ DƆ  P rZ  s-߄Z@  z p$Wp_ǀ uu' 3g rhC1 tg	 u%  .?!o  ڿfVʠ!&""Y[sf0u.#̒ߝs3h ̻ ̻> ̻hP F  ~f`n M t\+sf=R	H N  ? =̻E~ .@t0*@eMF t w  p-CrN QF ~ t˳	Rpf^0S#UV  h~ h<XXtFrq ؋
00õ D	  A;[t	q= ;t_"Se[Suu覱;KSxTVfa @"fRf³<fZ
`SDDajPf` WPf3Q fY`0@ N(  ' 4buLPC:!&= t<R UZ~1 r01oVQ&U f۹
&Y^G@^
6f"p 	
fp
PX:!@7 KH7 ؋ IͿhN#Ss 
0U|p` ;H< ްP -q]'λs0uPsyYu[		1tQZWt3$1DJLP2@| [ fSRWE
|D&kt
 tP _%b#\=	(bffU0:T2Vt `
1e;'''|':R? j"Zt}  E'
QV^ f^DUYA{'&{.t'H"ltz=tKˠ0}`L &zOP[Rjjjj P[ByVY\ hVd
Zdvj&F]^#^egFF= <t
ťNPQȝa Vh' o p4> 	r
	 0cf?Г3@ffj @f p B'}P}tofPwfa/  0 f  @ 3gfh0s-Ha# $~ EQ0Sf3CES6Y  f
ff{K`Pf@&@ Cp   q3B`C[fSfWa  
fy_>bq? %@_f^KE Y sv@u}e%O...̻`P t3Qu	?  c t .>t*Q YQΠP5Y  ްg $u@Q  hfYfXr`!t[~u . f u-
upuϱ0s&#EffS PХzQp  
PLMNF弋كt
t _"[ !  qt ph°Pj wf=  p5 [jh tc SKZKdcuWLMqCARLLP$FLuW uLPXLLFBLE20d PD' tD? 
2y2v
 UUW              i Ȏ؎6Xr'63f<tB>f&f;t	u3ϋʸDPW
 
t_   @ك
_X4SQW  hGChv _̀?		[Y
W@`\fX}  Xfcg&3 rfTbu!g&Pg& [1]``Pua^ UR@k   @v
 bV$bA[ g.k;ё
:8!0 Pf% g_.mfkg@0Rߤ O@lDTOD    qgD ODB } g ) 
 8[t d dRrrf
QRfq	  ru
O@	br	_g&Ƈ0%IP's ŀR
a-PhjTo6{XPR Z S .>P t.PQ .TԐ`ft.Aaɔ70Q!O H C DUǃzTf.
 .Է h_f.wP f@}ufpb	h;cT<ݠLv=пfDʀ 
u4 
  <uq
N
f.t	
;
utiu. {Iqp@W`.B؁uf@@PQfZfQW o3	< 	009__fYBҭWCUr.
fQr~}~1fvfgfff  hH%f_ v^Q` 3fffۃYP
SfQf"9sf-Ԉ\0fD Cr"
uf.`` @.) t2@[R BE@fQVff3 3f^fY3 ~
  '    SETU ˸ @؎  Y r IW@ P& u_SV  GG0G hc ߇   Gu Fu t3  hC) 
h|Bt & ^[SO
&h5 '[UVW F F@    x< F`D2ED2E{
 2E 2E  2    D(2E($
f&nEPwXuafa!tE/e.a ƅ @<qt	dR>t <tjjjj3qP[B .w译j5Rr$<t.<@t$t = ;t= DP h5   7"FF~ t#^FLr
F? FQ  ~ t: w] *f
 hiE2%PFAc~ t
FK_^Q
has^Tudu   h+$?ط h dR"hw (f_01Fh|2$..]  @Y'` 2WVe1E0PE.WV .^_U (UQSi50'i5(e1E0eEE.U s@ m2a h%#5$eU49$:8a3qr  utw
t1w
tBPSQW33۹ G&./뿐N_Y[X   sc3@ @ y  p^ B  (xsqUmf* %  < ! 1C  3	_
QVWb>u% p u㾐 P3  | = <t ;A( _^YqRW0P  Ê %TCrr3ɺ ڑ܋XAB rN迷 _Z1SUEH H)H
VNujzvzJz`LJ5; DE<@ ;<<!<[3Qu KKLt
Lm[V?fPfSfQl mf3f3lPllXfffDDG(	Dh fYf[fX^r#ڙ0HgO Gx1mQRpA3ۊ9 @q wCҋuB`sxfDf3ۋ?fË\` 	
C  T U S V 		-	`h0uh  h h h	 h	 h-	 a1uv.L.< t)F.63.PF.hAZ[+V..^?] yDF. P .hD҃Xh~ ؃04R  16W  0"Xa Y Z #[  
\a a _BAm]a f g'^a b ` `hcij!k qp10G pppQWĀ>t?		 u	?	.G	_7   O 4a9Rһ -w C.5/2Pm?n8o7@W3߸ e _f^߸^6_>QRrPS[XhV(`f
ha
3     x     KBC  [z( V{   Q LGB=  	 0{+&!!$03/04/05 Copyright 2003 by Hewlett-Packard mpany D@ !`t` T`  'p~}P >""!'DTTut0vp0wtttP!	" 	# d~ J0DwD
=t @t	0!`#hTDS>0t"rD@@(tbbD	{T@'T?nPD  	 %
"tqt{t0DuqүE4""#$%%#$"P&d>&&Ô
@%%p$"2` н`ЂЃ u u 3 2q Txu. B/q >$4 `Op" A{ J߀ d{J(
"?  "tz|}~ }𣮂ڹ
 ` -"Cp`t   +,-.@/..--p,,++  䵿@t" ~}|}rp"{ z}!tu t,}{ |tl$Y%P '%($('&_8"!&3&`8@&%ӔP&`ӔP%/3d@$d	p?1%u( %p&u* )**)p)N`._(('''PYTP?%&$ Q
0
Q
PB!D @E((sow2 7 A@0 Qa" qt~ 33B']pMIA=#,". #"!Rq "aTT)"uPu4"%$b4,tʎ"0"
pXp"0"_d   [5t~UtUp\5"++/ÞP.%@] Sp`AZE͹m{ +u.!-..3-N`I0
,3 
	,BSe,`C"d`"7tui8"r          	) ;pqu   06/16z@05/2 6? kLite{{%-1|5?|6|.SS"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0 Y9"""peX""wx wxc}  Ruu u	`	\\@)!T$3TD ȃ@VF @~`T?0	T@a`T%`@0błŃ 瀾xD¯01ui1c`01"xt}
~P"x]vvuu_x!Du(u)u*) + 5YF`Guu!xүx0PPp"}Dxe``
$`$p

Ox f
x1x txDESxxxxgD@@.}}@ v o ;}d`xH	BFK&]x}Dࡍ<00xtxtyuu *J}mqaS}ts p,{b,+b(xkD0P1 pxY xZTx^Dx_T_xcDxfT`e p# * - aVb,&0/ #<`aI	Tx"3
xB5T0/ w/t}!T` ` `&``#0	 0 T`# : 2+r04 i	A_P	<G$!
¯+u+$w4?j1~T+}'+fp (++Ô@^,p,

0%x?
3
v09b",`^0/} k.J@ /3 )`" "+8x'x+œx_`t 8"7}

P}} }	!Y	  @A
xxt"xd}A}D"+ 1}=
`[e#pqR00x )xi`xjw  pP0S+;p0TB+x+¯0*L0b KP4.y+`30Bb+`xOF	+ xT_x !
+:DTrK6PF` y+P>

D0]Tdp+$!$HP+-` 8Q~ܐP2@htx0  ¯xx7x8r x00:`7%Q07 QCTPJ`	p!6Ur;@,HZ[00b*+5OB~ZїZ# pO1[x,0X&xtx0x,A@SF0xT?TӾL*[-tx+r\Zt@T#`O]N^^NbO"?݀`Nk02co`Ao Auxpd_DND0= >	  [ [>Rgxdpc	r>;[!hoQ@*ARx-	+_SRNx*SMx+` !OĀ >`R0 
teQ`
 RSUPP1o 0YM PUi H2XJWi@YAXNSXf @ Px	W}GX$0Ynp^qZ1Zf  YZ[ r c!\	\TUI\tb[q	\S2A}@ A}= #- A~l B~n  6A~m uuҌВ"ǌT#7x'D
\ `7d`!7k33TT?O@C037`'`2`=`HpQx] 6uu?uupb uu0 uu5ˏO$ƨpN`0T`
020ԓCCD"| }(x] "+,,E+p
0 +F,,+ +,+x,+0pR}!,,,++x_,,"-.`T0ޠO72t
!Pt&x&Tpd `+1gw11ÿ@2@tx#Ҍ(響/0mp/l`
/0d@T	PE21D^<.-/0|4" ,xc$-xt`o3x7x8Q7t0 n"`_^S^c2d"xer_ abx," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >C g d  FApqIkli/ur}z'tw l k i h Ju s r p ; t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ |x @ s   ww ~~ r  :xW4D@ T` D )dZф2tx1tI-']0'A'xqvv 'xq]C`Wxs$% & & #2x1 	ү  ¿0 0_%#@Kpؿ3$b0#	Mx3C
r RgJ"xrF`X@ p$" '	x30%0&<T`P$"xsPdfp
0#%""tX.4} 
xs$3z 
`Hp`p$W$ yspPxov"x0	wD0߀$$6@Txy~D"04hxmx~@ oDT 0
 `eB"pxu1xvx}"xux~xvxx}	"xxm#xwPyywxxf`Ӏp>xxı Qw҇~B@
"00"000u0 u0 
04e I!P$(0W<;HsR^TB`  x
0"HD =16/(!a0"0
	00"d0p$!01¯P)x1"}u iT!""3453/:PNP"3554!_Q0"0"xoo`xaT`~~[xnov +r!3}TOp0@0 0 
A]P:0 /\P'2BL;P``Ӏ_"89 "0a T?2u$409S0"{z}yH237:
u: 9+
`:80:808@2$h'Ô@^ p4O=

zP$Y	0
	H@À{0-$`
$`$p!a"V4#<K0" E:0!@À-0
 .  s	!#290"
2xofKp0*2d|p09SH{zy  xpvJ%_`gK9P2 ( 	4 ޢ "H	5345q3`~	t%5544}r	@ :0	h0"09`	2A[09< Lr@1 
 !
 +90 B 9, 
j6	" "!`BQ
p0( 9g!^ @
-NU
]D7U 9.
j'	/20"G+6H,,f-e2pO7)0	L[P85p
b3^&05	c	0
S ":"088;pfpO:2`"/c)P3
~Cxn`qe`?0}Dp h,{_g,"a,a b}iO"4xMNOpxD Te4`^}V Vp0
T4d`#"4#
p~}i4xd@3 0
3 #͐`3`3$`j$`6$p$$`>$`$`.2%$`p q?T%!0𖶓 DQpAh0TxߕvSۀKv`@9w06%6 f`@`Dx9@[30p	3^Pp c	`r搬?&3¯3`y @
 pTU`xk  OF*J .xv
xD}S&10{P^`
}mT?Dt䀑PtYTȤ{S#@-`T`Q	0787$``$pa1e8`tg8r))6*)б'0*a a
Td`x0dp#  xF PTÔP
~@*JxFt txBVBxNN{}wWxJqJp:;<t/?=)x ү!:%$wt=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xv6xV86}'p p 7  %76(ۏ7  ""88Ô@ fp/pP(m @ /..d`
&~9r7(TP5OG( 4 Đ4040bz`P453``/`@$pN54:$I&du*);WP [x 
33oppGҽ+L2&>gp1  ';]P"T~ ,}?T#>үd`pxH m8@22P65b3e1@dx>
1/ M
m
@d,xA%30 B1
@
 r`00
TDT@5q0	 3:@a AP}Rt
} u2P2b퟿tl@
Ȑ.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2+h(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM"ps" d-u*x0,u`2:,]4 2U.U.X5-׭,* 2732pha,
$,O!% *R5 
Q'x`S+0	+aC ?-R	++`@@`p7v@^}	 `@~oA0y!T`w`Y_` VWy
7pDxp.LDy?N%@k53]Eop;OCD~-qXTQQu:93: !p	S31B3dUyA`hy%%Ovt0QON@pH R/ N9
d.0
`07X6Fp0X-64F0570`,5#O0]c6e#`	S8@1
}3!b-1ÀI%P/;u1
p< u11ްQ6+BC{p4pz5z5
3zO+,yuv {| A, 90 & nPÑkwT0 ,	al:1Ɓpd01|0 upo6o,/-.rpC}}0
P/.-<rdct%,f Wu tq70YS 8S;":W4쑔p1}Bߐ}BT_0W=_<I?`$:<p:T0Oső78e`pYלBxgTAx`%daz0  87>P$3!q"W¥AT3	``Euqq
r	1Q`{0V
}
9ȷDrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLx;pG3p?u]I1U^#5_:`@TU`#v@|T kx{⿐}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmoxup&xtPxsxrxxqxxp"pxkv00,pTxgLү4" .4Yk0.TxgQg/`p0;P .^ ##----*i C?",u{/212B0T-21Կ^ L.. 'q,Đ/{$H7,T{AO-.`۷pG䔸QN.E.OFJvP70pc0Y)N)y0Mh
P5
Ps|?`d7]א}SPn,rtŶar4N0 `a2Е
p1
P

Q "u- 09r"l  },n1vg8ԭ,  A3.02].pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`ou.Ta?1C
.%TOл@QN]03p	 `` 9b  :$ :%Nϔ@6S ? x0!  x50Qq7prrqxvWU
	Xu

		0
s  `
7P"q{ C
G1opTrAL`>M)60.T`@}w}S?AP33TBDWD  Axk6"@t C9xVxFdҸX`T`HT
PM>@C!3"x*"U\]@0CQqڢ97F> 03twv`
pUr *J(( (BP_P` qw0P `	qPa"NO.eB"TOENX Є1n`==A=aYpo0:BPx e0!JI$:1PJ1,F;HKF	#D0c
^"CO`@"HSIOv30aA!Idp`w}@0tt A2bIBbJ``JIxovHI< "xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G=4W"xB!C!A!iB/)B*(T #NA
OA
MA
N/I
N+)D
JaKaIaJT/iJK
I
cJKwLMd`NPT&` v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"..Cg Ô@""8xo-"xf;· 8" x``xo-"TxDЬT0TAip @$0+ZH;b`E}@1UTsKF}R0+UAWAQAEA/A#A
@@@@@@@@@@~@j  AcBQo@KKi"ebrat"#xbr o "C0D)6,	PR#q! b* 	^_;1wV R[V$`RqB-b G$B\UӔ@UOȯUp0	0!ZÀӒ!}!BU`#`5`2$pCx`E@D4SS [CxaUUT[xns&NYq 
xjx GÔ@π<PTxjCuӔ@/`B{r
T" PtjxfPav+xnv29vt4}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAD@9k*F?0$0ᶽDP9}Emb $|F a0U`Ud`*uUrCDDDDDDEE E3E?ERE]ElE{EoE@CE"o;D IttRB'
pE<B.}1F
m0T Ag@$$MPN7 1&;T FK7Ñr`Vx['GAS
hRa?`YÔP؀B`9AO0D=Dd
`#p`(`0<`PdP`d`U]ݎUw0;PR/`npttd	SxtxxWtxXtx\x]txat"xbtxJxFxBxtx(tbx%tp&x)xxxxxxxtxtxtxxP#x;x:Q>0x=tx@_tI  	aP	0x6t<xTВU}.xtxu"Ttx!TTTDހ?D@xwTp
Tp=T	p T Tx= Tx0D'D
?=@D@aT@TCxkv0_}Gt U0jQpjVjTjP}S;"x0xJ"xh3MsF"B S?/ #?@>"Q$tU>$-"T`eÔ
P~0~7%UUpjTT7%TT{ z yT0ﰈH H+H3H4I6I
7I8I9I(:I3;I8<  I=@TIY1	 Q
 I`A 91~5HeWT& 8 `;cuTuTK0T"$`($`*`-0}/wp4@
TB VpGQb U T"VPT$```$$`(`7`F$cpH\p	A^@
:3
2  *}0`: `#'Ӣ/A``,`003`G`[$ap]Tp^"T  dpF^0$s  `!D񑝧Ttwa/!$ T  U "$pR`PMEQd``IQxhQ PQH?THq@P
qJPoxhv@@K^K^K^K^KkKKKKǨKKKLL
LL+LmLrLwL|LLLLLLLLLLM MM>  ME0
`2v"xMNO`uR RRsл }iO  /x6  "%6"0R^
R:p;Pܵp}"} HGH	}01"uS0SSST
TS?0CS`~u 0P/ 0@4xathvajQP0@kxTxkD0Fx̏Hxbx"x@$xx"x`}_K}IF	
Q@PM0""3HxT| } ~ 'Jtǐ4Q`*OE QRR &OEMh((sMMNNNNNNMMMMNeNkNxNOOOO4.?AÔ`P/QIF"T? } 00xg"QfSQma Jw0pV	~ 50ߤT:uQ-0`P 00)	0PS":C$p
;)!/0Qp,"xdP P0A3*"~7}i 0?IR3AP>2Qgg8MC}Eq@JWC`X .Y`NZ 7Q mT0""ϑO 0#0xD TAxАi!1?xxivAin0T6 AA=B 11u32}'  $31T3322@"P0  "(W "  k p}"/*JP;0/Ô /pC0S00P]20000"
AxpP" x0ΐR3456&4@"(t?4t 3+x436R5U6B eaxQxQD~QxD Q  097x@T5`nT5 }CT/QCQRR#R4 S?SSSTT7x
01!x
tP0P
10Px
  x
Q{Px
! %70$t $T &Qxt	}XBxs0xsP2P0 p%@$X$ÞPxxs=<`1 <	`2`,-܅/u.p0=T_Iү0$`&ppAPi}!  `p0u/Bx.-,/O7
&xxtӔO@v%)xsvysßxtP  @'߀0 	b7
`0Hxߕv 7tx.Q`r
 aP!0	-xx
xB"x	07T6)o`rP$# :p 07 e2`T_ TfTpTzTTTU9	Uj
  U{`xgD1 D@2A"xDcV$P``30TOX`Y  ,D"{:1TS`i?`/AE@E +@@CEtU7m O@` { 33TOB T? @ 2^00b"`=!`p}T``8 -5,,F5	S,  5S,`xevS, ?S,,"+,/0-WRVx	` }"yNJVu0 u123xf`-30(?Ӕ
P!@P23	D3E2NYLSS0S3u2 u42U03U1Np1%1030444P-5xp7x	410k	^`_
55-?@xA1 YF70c
`/p00_Ӕ@: 0-	`	PWWWWWX4XOXjXzXXXXXX$Y%Y&Y+Y&,Y3-  Y8-`:S	Y8xu/@xEP[-._P
.- ^	
x38t?e.pt e-0` q	#qQ2q"	`pEx@}}t*`
.J!  2#@t`-QevP  q} pQ t u vAO}	}c50R)1 Q!q6`^"20 ,+ߨ"`@ZP@YYYYYYYY	YYYYZZ
ZZ!Z>ZZ3Z  Z0_ZvUs  S1
tt)u}#	ʓ
pu&| uD pTӮQ WT0BQ
":ĴP^`pÀ'`Q6$T]P  rgmZ`!L0d-GNt(Di4rOBksQ
xbn)S@`DAT,T
`qMC#_ "gD `E - gt .`T/Ӕ@"p--d`"` 
`-\>.t %-Ee.`.7@aG\=[[7\=%^"Xto.`:``œ/U.`"U/`"",pO/`c/@ OeA
"x
xt "Ӕ@
u/$ -$UݯP"xՃЊ0"5}67 d`77p676@55FP57C B242'   `"? ]b2]F]V]7]0']d/]rI]{J]K]N]Z][   fps"xl0/h"o0/T1H: \$Ԕ %E 0k33%$Ga e2pL2H640"0-4d	%4
4ura
ov"Ô
@"44$`$`2$`B$`J`[$Wpk1׉P 30//V_QRP"D	zqv34AqaN4p-7bVP!
PD"_""Q!0! _$_2_8_>_W_{____  `0"u2#`u22zb ! 0"Вtpu2F,!wu2=ra&
Ck^Qbp&6_r2UDUE.pu8
Z/0")5HQ R 0 3A2"0"x%0T~t@"Ô@P@n@	T<" O x~ <9 0"ސ}t 0	Y~`X#x0x!TT`Deƨp@T!D`!T7r1 `<nxDxR   p"@'x  	x Ӏ "  :	;
/'
123B=>C	D
WX`~x`!`WP ^`_g"
%*7xF`7`l0x+ +d?x n{qc!+s+@U`C0/+xT 7D } 20㐘sp DT`6o PzpTT`P;0	71 b S 
0cx	+$```9 Dbxv z q DxT"ҎxStTTHaw+xS+<x,{p7, J`$p#+pxSwx+	x070/Xy
~
0a ց"p.!y@-Ӕ@	}-D-$``"`(`C`G$epY /dC.` _}.  Pr` dD}!lT er.z-p}} .d@aPVM+@@COFg$ C.-
.{qQ~eg @fdRuŃ%Ńse @? ? ? ? ? ? ?  ? ? ? ? ? ? ? ? ? eeeee.T.
1fj.!"dfjb0I/@0'  xl..T'xxf.r-.D&u{@&{@&\-&M8-&om#7ӛP	ӝP@_ }|d`@vÝ@ӛ@*ÝP:;<u it/dر:7t"0pLpF< h"xHڐd"A 	/01234u5@2u<$t}5}p/0hh1h~hhhƈh݉hi i iIiciciiiii̙j\j\jjjjkWkWkzkzkkkkkklllKlKlllllйlкllmmm'm'mJmJmlmlmlmlmm  mĐ~V0F pC3/}u: u; u<3{fq4mۡT73Vp6bq~ 6` `R3`u3pwuu:u;}u<{xu{{X$::;<{&5jhgR0p  ߶'h)g

-X>*05G]E` } P0C3+1!~ .`| }` @^_N0R"`"!"H
$*
R#5'((INp:Id @(-
cC :001{ 7'+'(.))X0,/,28.17.4h03g0҇o.]|U1PrP
AA$__TW&A1 u2dG'XA=9='XEFxBwBH˨DD̪(KFFSUo UHH#MPU6P!}UBfP>/"UÔ@πu3//ZC_4"$y !SPvkqp" ? "@A~R`j0n$o1`T}{&A`##xt@}}X} Y  ZxqBBxtPBHQ!0%70$"Ap
  &Z@AOr+ 	 	Y		Z 
 
[
Bxt		  ":bx>T=Q
39T_]>?`dPP?_> I IPw0=_p"09n
 } P࿴' 9@
| $ >Dh0
0oSd 
Ep6B}`~T }u/DQ {p#@!t1f}Ԡ0STTs- t
"Dv+Ѐ_ђ0  QP$Fw+~@x++/"0yu1u2}u3ƀ0ТqEɫ123 С`qPT?T?`@ %%Opt0`	"13$521~pV0}sTD kt @A?31"~T_"2k p}qVP|
@&nEp0z2Rv`@ 
41sqq"14P3r{w,1xeT`q707
 0qmC70'|}pp
"T`4"4"0u2<}0{0`~`~^ׇ0ۨTODԿ#1p3222j*0 $$Q0п0{ 	3;P#yP80+`
8aP @n2PB=2&B32p08[P`
R@P
^3"0xOO"̀0<# 0Hu. 0338e0`01K>_$Seau.0o? 1/T`J@.N`\QPa2=E	DsbCD 0~! S ``Og-c#rƩD
Kx墉OP+@bT7`6McMp/"5676E5`  @" p7Nv` "Ke7`}R56c6p5n`0npo`(}$	4 ӣސ@ [xS\2	Pu8:
88$"9:9p:b"9:`x!D"p TV454W6u7}u8W4WvEɫ_678QmvӰHRTNpV``pmP4RU Wu5u556@
ڡX7BU5Z5#`Ud"W=6F@F6Tñ__GC(u1	02u0AA?*:/qrb=e=ÔZ	Eu1xiu0D "	BSp}u2A@M}}]O~ x`@ӝ@2u2MÙ@;pY Ӝ@20 S0@[!?$Ýt#
JE쁍@':L`3MRwߋ3`	y`60҄1 X@L<?0?;`@B@	R2}cO"	aڢb$U'NV\tАU$	??
(F$	6
?? LxB$x7EyU2}{z?y~al~(0{j$~/){jw04<t@wGu/'P~ @| }` @_^_NǇ/$ƥ|tq{~@_aqzpTN`K42tpl	ÔPtPݐ!}qo`wk`45Cޑ@/Gk4383  |c((s|}}8}S}x}~eu=5Vw	{ z y4o	x5P4F w
I4"0v5<%LPJ3D,t~5{u4`u5 	]4T`p[d`pxQ?
p0
PF	R4	uzLT}P} pma$3[kPKpß
>Np&>40/餫њ	r&
b67d6N@7"PnR Ĝad.+ye547l`&kI!Ũ2^8)8CPP| !5`z {pD` @\]L}
`89998O89!Q!ֵd8Ф9!
@&2nB0gC' 3
ڤ[#98&d]픜P60/f
8 F FP2GPzadLp;|t#
I(I#<~I_8mpl ??a\,@7U1dNptOLVKOKeK8UuNp7>	r^HQȕo`Jp?pNӐVSYSSni;b/9'P#vZ/i T2&(`?iikRkm<Jѝo=	q)>s?TMn iǕ}lIDT-K098n0,98v3 8|Pv%3{?"2u3u~}t2Tp|p4 Ô|@u44$`Eb c $ ۇ8~ 28u4x #ux߅23@dE`T@P @t8uC@pj90!
PtPo	9TT Np;7 ! Q*:42u4
tu q"[e4`43"u0p`04$QC¤ x0~hmVĀ pP	ÅϏ0!"0p@xl0!Ð}Z}ྐÐ~' ~& Pu114
tϕ11sP`x03{}:%ROCج"Lp0N U12>+`} /g20ˊ z w~0Y@ :2pPu2op`00
``֫ӕ1q0100 ߈xeT`}$1ßP`$g2"}`q 
"""4}{tt x 0 ИQ
xP
3U
02	~STD"LION`Y'mp`-wPYQ)x33$2>d`/"`~ }H@X!0]г2tjP2߀22  ~d2~X;a;Z <Y>PS@~Wtu4<W42~34p꯫`u3Jp[pA_P~3\	@b
3'~cp~ @3Php" 0~^"/0734u5$*``0$pB/}u:u;~u<]{fq4E`e^{c/Y{00o//u: u; u<3/r4"/
`:  "p	` R^["pPS` "0B c!QW]tVbtCu- P`pUZ E-ӟ@
-  e-`P KAptYX`
Pp-2"b`[A3p0-W0xQY, `"q ,КGȀsP&p i &i`\A`[0/.P[c%,'`-lP,vt@p,06	b"?!$(p  h{a@1hP%g1122"$&`
p:~k`oj["oT<fP_O0h%a	O"!i*h-esk8jtg`bST^ .T ~Bio`P<h0 M
0`2Shqeo`'j`#jp.pA
 dpR~0/x D
 6
p4Ɩ{OI5w32p,` 55px<Wx;D"05?5 du<>40/105.`* }} n x; _/0524Tp <  9pP
 DeT:p
~"
qh~ d9ApxÀӲ ޴ 0d"0Ӏ"z "7n8` 	@
D	xorb~,PT e8jyP@sp 2s0s"`"aP	0C
pp3
a@td@r@"0z {`  opn`dx"7@8uVX?)`,7bPqPPr Pn{p	84gk8$"9:I<6p-=u>:9~nAe:p9lpe<ʓ:E9~ `v@~+vP" $Ȁ
0%S;;Ӕ@;@x#q,	; P,A?x@-;P 9>p <p
9:0?e=p>`p>6>@Au_B6P,F оAAp@A@@;B66B@	x&T 1"%T~ O`=&4@"`PѤ"x!To`	TT79W3o`k3A 7HCҟCpx!8@5B ~Y0P*Dp0 Dϐ~msX44`1K Ad'0t"u;2CF<9:Ku;} `O I I::9:9@p56x>HMx  X@b665ð5P	` 
G~3IVD"¯ DkKCQ*+u,U
,, /+, + o`X Ta QG%Gה`xt!0^
T0xT?T1U4TDx!CD@Pp
0g1dpa 3%33+p3+q@
40YW4cQp(%`q
O5[c0*OTjV		[eЂl` #A""	F	 >߃	@2VxpOdX LҀԀiq3ꀚڀʀ3䓣Ń ?
`	"3/$ $ P ##EN``#sB"P""):`"P%0 "b``"Τ.` "  )"u/33@p " 3@P""0	Ý0 arPb0"(p p8@
!	P	t	1ua
b߃*q2	1	"wt 
""BBE"""ЃЂOP  tswf6 s)Ńu& "%@$5bpp
s@h`߱5p5 5@~5v5@n$5 b5V5UJ5e01515 p5p5{v5pv5v5q5#s                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
     MESSB\5m6]}!O:d>_vI,	]								

$
>
G
L
~







I.)
i




&>Tilps{l1L	)Gh
@Uj+@Pn,t#OV 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
h
R	Rorhi7n: (ABO= 'Ctrl +P=t` Del'p08-1"j: @changed2: r)mB* ne@A P+@*3/: Video	Hֿ-4: rrupfPZ5D_i)8]6_an`!expansb D  TurnB!!"ej0fs}!)b<F?1>: Abr
bARrmal820UPZ mu@P#gi!Dqwaa6#+Bk-(Strg+Untbr,QI n%T@Mf owᳫ$oOp6utom0czb4uqhed: os ToW miuX: Kbyt0Vcksumtj,fauP/Jpku`l cpWNext? EfqttibExPfa Ks/ssaPeAcceP'= p F1~0 0 F2 C S I zB Apinue mpuP}s?  MaianceDb
 uyta6.<wirS us Tmodu+mme$+requires'.  $oc.,d. LBPU7MpibOOay1__2_]re`excee !QԱ@5b1`vCirccuue Undpw lndsy..P؂(. 4dobWee.GS ١nI5c5`^ XInrLShut
downi 0 	-a:Pe Y;PINW: [
] \Nb<1%left+ 0H1HB@6 u`Uρo
v^oax00S,ZbpCer@uSлUe@dLPcuҢchipQ+be TEp퍓JovldNew_ Pԁ*upu'< *Warn0/)fTPMoVc{O2	i8xrevpo aaks,STpa Tmr aI5->rmin[r` c&n>
U0_ >: XX hours a ` @sAAf($EpѪm	hk-.t*G uhSq
IfүkGnow#E%,FsAmj0"jcthXìultI `is.2K.!bAe$=4r"Q du`Rt!>TA n ADrZ
5 aff`Hb^a@)0{ak5xPunusKVPzItmsg'com a2
f@a%greplac2mâ aSF2 _dU`qo!B's TrPlatдm!(A)!:be.Bi2(HXe[C 5A?9aA f P;o takйos]k[ 	Pgt	g/ /S OEM Spec`Wc OmEƟb,dx
NOTE: `BBcBrwitch WARNINGirs#@갇2bYRlo c01@0b
O!;pAencrypqbh!yDoso]ghBhV~applĉ^Hy
 from funr п@4RR 
ERROR -BfБr gonePyjtlUaMaPIHx (MSGIDX)        	 OSBC_BM  p ( d }0    C %   O L Ʀ ҭ V s&  ` B ! B Genuine Intel 
 '"B#@ 'B1 \ w  ^  Π @^` Z    @      >"m2#3/V"aJ<!2!-"B#}2#3/
#32#
3z>"3#* `*@  gwb.A2".@ Ϫ ̀#@` # #	
/bf `((  +*# a@ 
!ϠiAmin"2/a!3d! b2oBcON /""aoAE`#Ufgw'vf	dA !D@@ wfUVfvh!$a"! %#`IWeW
U	v  I+",J	A!/d/L* Cu`
fwUn)@&-?>*eU@TfN7`
E0Ud 
_k:$aLJVeE> v y$w@F 
BDio.FF !W.LAU F@.NtED@y_TQWv`EhT@Y@!	hW@VO[/^          @ > !*gEgTbgy !K<bfW(uO
fW.@$W2ϖO* f T
 Uf!_kq ey!!X"V,NgI%X`GysDBO&na"WM,AGi
"cy o0 _6_84 .Y`1Rb4yn1@Z   OPMk!6URl7}mQ@! x@" UOA}aO B; )oug_ ?tK`+>i@i@`.9 Cx 0DoAb`&cakh-	!vo!uXN^O!#] KdA
#	$A	Ȗg("
f._"%		7@ 5n$oo Dh
1oo7=%SB!(o'!ih@3A4 >%
a@/H@Ip&
> D
;O !8 .E .A'b7B_b/aO&A7iɕ'
]aGB8
$7a8d';# ^@`t2`ƥG%c.%
agFN@Cb!"YbR j!˃R!tUEQED	O@: |`
<_Lfj
`$	_agb^"Zg΄pObN Yྂ20dO] WXf{Pn.E$:hind``s[

'!!wat)!"d>aD2b2d!, _ ~TU e A!N\  @ !U
!Bf .  i @6f@  a BF HaV" ,@ s $ {gJy`uأG`Tbpa!@b`g	J` HaςB
 Ta="B @$a\~ Q( # c`m," " 2̀ }!8 "
d@"  8  L	   @	 OSBI_BM8  p ( d }0    C % N . @" ^C ̤ O ۿ ҿ ʳ   `    Genuine Intel 
 \ ̟  `@  ^@ " 2!Z; #3   ,$1T!4Ft  $xCo8 A
+/`OCo  Aw?q`B A@_ O ?b `4D	)A"
TB	aO@!

\b-_OD$
 Uq. @`	'@
]74`A._3#@ / `C:MB
 /Gv"BD  "  A
WD2 4 132%`3.hB": #"
n_`-%eOl & 
`'@*@BARD 
*с!B+4*i - 
-Q?%#aqAT
 ),AX )Ia/ od`& 5/ot/@B :>Co 2  Aq \/ 9"`i@Bc 1gu= ,J%A
!5"=34('d*8WMTPAS o1       aF3HGw\`[`7!*9߇ K2$hA;"gC bDI*\kCh
20 B$6!(1h
`@ 5:b8LC#	UgF@
!EO[aFWB(E'2K$VEBjD[*m I?F0oc""H[a
U[G s#k`T *`;wdEO] M
a a,[4OKaK   2"(0""ak,Ve
 "$aX o2`C@$"ZT  (\[8a [9]K< 	_q>@I U!PgbKRmQd]g  !.OEG d S@$o f
Pc dO&i
 
K O#EІ!Q 2[`  qoU
	aTWv!" @.B_"O)]	 
#	{ !,f;
%		7 (B1n.oo&DAK!3OPL@B! =oC; oWw{ :A/.@qa1 $0 A;9k $B bQ	a` 6K@@.!E$2A@J	h6 Id6!Q?J @aC:E-$!Фa@[HBDJef QwA
` a\Th¶d@ݯo WJBb^OaWx	
aA ӆ H!(CO ص"" 0/0M"[pYaNUDk0d:$avR!$
 qd^
	z Ayo"Ab9r y{$Cbo`!~ae(t'	 J]>O  
	t`&  s
aFؔ pc!3DAH(@e`+BKK@vT u[@wo# w[b2UT` B3ob#+bVA vNT$@ !D`A6b!@@ZA t`$A! A@ˣ
 "(7@ $c
 G   9(!,.@#0F`Q@ $6 H7`%    
   `	 OSBI_BM  p ( d }0  $ C % e | ˯ Ծ ɥ  Ը    s% `    Celeron(R)  \@   ^`  !\ `3Z"!1	4DZ32 Vf?TXDC _UTR*
 NJ@LjUDg;T ew  WwvwtDEkTDodvW    F m 
DO`t?e_`]eG
e
UI@_R`D@ D gwoTU
O 
_	
UU@G!
Ac
@TDFR O@
`xJUIN_aG Uo guk"f B E!DR!o!T@o@
@	F oTDy]Hw#X 8D()U6#MT4D ,h 'eU )!U@.@- xb
F) ') ) o ) V%X 'o b*d '$` D24@!%V b%o%AJ 2.Y0%a. .
 5"d!:8+ >_`>EF#	
DO_` &
GOI
`?ooPabW@Ua   $/CE8a  C6D "A	A@!"$g:WX>,&&';	 DAQ! "u@1  P'"Q!#-VRB)tQ 2fD*	$.F `/$A2A2HWuNVz ave>RZ       | p&UE2F]Hfnyof*h ]hy2xe"lg"4vy2V*z'&awX0z#zX6Jeq|Q:tvv?a2ߪ
` &
:OA&?egNRY
@*"{A(IVa1(A`^!Zo ._O  \Z	"G2Aw j8	
Y!T@\
b@fh@{os
@N$\"(r~"Km,!S:
" `
 ?2	h   # O8i~<r>jb
P`Rb"@""
"/*+'  eK	!z`
/!`x !'A &a
.!a\@ CP-O `
a  3@ u
B@;BA)b!	 5+ lo
	F- #!%oi
6* L-OO C/,0olC{7B/A8Μ@O!9.${`;AG(k >	= 
(6!9/f$Kd$A 78@[%
@?b)!@"<:A2!6A/HIDJ	 6A7b] 	!4DB(& X^1 `hF%
'd Ei\R *8"Q!
` +*"#!hoXdB_[ B^/Wy4
AQx"BwDO" PZe00M@]B U+ee6d:fC;c7D qd'
 z /c#BD	"`y$ |Aua+?O~($b1`}b_y  ̴ "b&]CL! A4d
t.$, a-#CwF*/(Bx U	 y` "~##7 xA!!D` " H`8bF@	<C$CwA	 #)!
 "+!Y!@  W $" `!B``@!(w@BŪ' #,+`	 $0 H$B`%6n@I &  
  g   	 OSBI_BM
  |p (  b0  	  C %  Ǩ ӯ ٹ  Φt F x. ` j ÒU ɜe    O O O  . "#@B@(gb0:$a&6"Ex&u2 .rO.2T,8(`z#O@2x&
	
 V 	$@:"x'w@ga
K2}8 څ <axJ>c%( ˇBrD!D`
!h *O 
 `a  O}A"!B`  	 [
W@)o C@ W`#	@
@@ ,"A!A'`H/&"x'Q`!"@'V"Yooh`9!"@$&!#C#DOM8(4$ ,!A	!$b
"($ 4-DAO>L/,.!0 7854?4 A`6O_R1!/d=$%:_on$$ 8A>da9M T
 7%%FER ='$:* >.GF	. KK A
U?!.:!6:K/>/ 90T@VOJodt`I ZC-`] KK !/*!3!i`f4@UBB WeB7 ]a`eC@g@"Q `H)
jodABa!tVfo/gDN? r8'fcF"KUO$@a&QQ_@z$4XA]"B_%_Aha6&{ hB0`]jn/$U kq mEaly4paGR0 i`uOH*',{>R tA|`}ҢuOT7yr*Zw;@{u` }B}pdz~ $`_rqkyx KWKap:AxB@ubx k4eF`*0O O O         	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-      t     VIDEUw  8BIBM  761295520C??D03/07/06,10:23:53 : < OS|<0q FGL M56P PCI_EXPRESS DDR2 
HP Vail2.01-P 128M ATOM BIOS CRT/LCD 425E/c37  
YOU HAVE NOT CONNECTED THE POWER CABLE TO R VIDEO@RD.PLEASE REF` 1'GETTING STARGU' FOR PROP HWARE INPLLATION.(C) 1988-2005,@
I Technologies ?Inc.  BK-!VER0_09.01 0A 7 9054 BR .BIN  248113  _ 7415  configh$  ] jA8r
0Rq   	  	I| qM .&.fPfQfRfSfUfVfW&ff2҉("/0fľ24tf\fL;u
f^ fN   SfPV> f=	rf f- P  fD^fX[E9 g`..  w ijELP.'.&&fP.& 
fXt f.!f_f^f]f[fZfYfXUF f3F3FRӋdFZ]>. u,.$fe @pB  | s~@w@l ,ȣllmPMIDj+    ?  pR1f6f2`XE>A:Ct.:&4u$<u W K O JJXut % r^uCAC$< uK	3l 	<u
@^Ff	<u h
N@%Vh	<u=%I
01o
Ff:	fF#
3  .>'	<u8
uǻ * u3ۓN	0$  x
f< F 
uK'T
E3@20&F   蟍w ozF N0uI
/@
?<<<<<uD L"  qd
<u6 3$
PL
Xp  0o
̑!
9j< 
u! Bp#N?	 ¿%	$#L	muC #
'u
 p%@ 
"
 
% a	 
	8,F< p"ua
 GF [Nu

ޟ-xr[Q
2
tP(p+Nw
$
t 	u m "<
茟< QtU	^3f t߀
  tL
 t
f߁  p:tea
 
 
@	%@Pɀƽ @ @`̀C!V<@!jS؊$̀
"
[ø\؀
ߊ
SWt1	
̽[6B? 231
uM<uKt>"JfȱqppȰIf ;gf   Of0L_0u]SQ   f&JY[kUu@>{N nF ^F. Pwu'	PO u_RQ@@t Y;vȋZ;А G/	`G\!	vWV		b	m 	u+[Ua<^ 
= 
T
iًÀt t f!3c@w Q1
CY<u#Q!& " &鄰"Bm{%<u&\U3\ U<u/)t
5a1B  0"<0) uHQL1p.з >0PO?tqy  Q_z
C$ 
mGu!Q$ 
t鴰u23tu%{"L$<|0uCiDP VScJ[f%f
À!eqYn C诚4	{uff%u{u\$f
0Ns u$ u	 heu5Ѐt
pRt餿 n$
2
pu01v$oP$eu0gx$I	 辙Du $u
p ptu
#2~EF 2ЍfͲ'u
@w wPH#@0@u&{M@&U
@+'
u33u3 u@&%м20Iu$"
۱t	g˰3\`2pBuKtC;w	aJ+ڋ+;ru;w+Ë++ À ۓUV+rEw;vMx +r @s߁ ʋ3^]ÓP 7p7XP RfPǡ$ffXZRf  2Q  ZÜ 躣 Cu詃k ff0 lf4 ʁP fXf[Z:f_kQfPMr0fXYRQA.S@@;_pf[Y"P{60:B軦F
YˀV4YfXPfgo\#aa1E wF Ð ff r: 'w R*eDXRhEU;z  R
 ff?ЊfZ;U@3VV f
@3]`~@VV> FZ])w	f09.
f` U 0Q..Y{YÊ $?nQÊ$?1[a}Oq,&CfPS W[j  fX ò80q=#9?0&@SP3Ɋo X[Z	}f!$f3迻% @[>٩p-#%:36pBt@p@ ;0 frK踔
Y˯ qMPA?X`u5f%? u50p%ڌ) pI``
AU323 诃#1t
t
|@v_t#1u   (-v xw'y8i t 2Pta@t
`
 0c Ű蟡 Sp[tQ=Y
2Q0Yt'uT,;DvDu|=4v Ý+SQè S| [&
Yt SQ~9G莀	Y [[f% $ D&  DQt
D
d8t0tA |C IʴG	i5a 1 B,
 t tt*{r
ў$ {
  t  Pq 




P 
(iVaƧ^VS}0[t$ H Tfti uBaБ *@`>D
ѣF y/ Df J e@OFA`!H	t(+v )z@LLp >Et!		_  	D	   	&!a!=M7t@ss kW#
^ B if &5/ |/E A@@ **0!@OF1!Au
i)
$NG ;O
ȃK$N F
& (tf-|) )H))Ŀ)	0q[P:2 !	23 l		v9u<F  !5YB 8$
guoaP!rP9u( z5`5P|ZP5		 5a	z`@6HO
P0dC 4
F 2
#P- 
c@-uZ*?p#0'C@%OS$OA{uDu''
Q  ô @ap et $
aD ϵ  !  W33ҋt	@ -Sn 5^V~" S_PRB$
ZXß [Ɠ `Pc"$ `<t$
[X1P }@$0pRR!$<ZS$<u?f@3[~]%bd a0N	P	 S o6V拜
 ^ !#%x'P*(- 0258Qwt ~  ^u 3U
  I`K"Jn# @`YPQ 2s9Y6$T)dV3ɪ!ސu$7! g:LT[3t/ tJ
u$<#u 8<2 ,<3u( D}
P& :Dt LT
^`  @Q Q A~A^
1 Q _Q b # 2 3 `qL o;t	`DP2L^0SQR$ ff3fff3fZYf12 ǵ#[2$u	% 8uðtC	9pV@fa^L(| wL|
 wEd(?3Ŕ, {:L.FG|uDo+ Pu[DP
ED(tE EQ  $ߓ  D+
? f1q $(0:@t;  tf@ÊTt\|Wt8_@uZVfs-fQӆ^Ld\|)?TV^Nv0TA@ fQf7ȃPP 3Cz`KfXo fYKKf6qN3AC aĂ L^b0b@(w2ccdd d@ $. tL u	lCSPRb܊ ZX,QR	 pEPTR ~  +KK;rc2C @`p V> vp  	!  32Ĉ&! ^LC3BBaaĹ paM SÜ&t
 9 ~ !'"HPNK[à["twW<V N`+ 1}>(-' u7p$PPS,fpg-@@t0S=S )QYQ@[${S}.fM@ԯf:?@2 [$<vTm  t2DIxAK? SQfVov ^@7p  	0
F  ܃Mp4pDqfGF f0 P	
DpDFDFDFDFDFF02@M[!u `
蔂 [?}@
Nf1 ", UQRA P^tf\8fL 0H 8 fs` `f @~}/ Fba@r~~:F}cDR\L=B F
J؀`"A	fkf`  j/ N2WN!!fqXf{ \Rm}f   oDRff;r AC`!p ^z fiBf;}f+f+qP&`Qu\H
1cٱ2;N}A4`d:N~	QeF}@P' t{vA11ً^ /ZY]t+!렛 	 r0 
ﵤpB3ðt[@+*[2FnNF VيfF ^t!BӞS7<~!\d- L^#S6 [F0p]`*S]Q4`[0 ;r5P[;rH/;DHvwЫ @@z  q fЀ{f=  s2QVt9yXtSH& G OtN u
t:duG2YemAQ;Lu;T
+u53@cH/SS SK\+[=d$K\
!$L[
D E}UfWfVfRfSfQ$f <   Rf3p6  \<@W  +X&^\#п0|Q% tEߚx nA` t;|6 ߷P u& <uf4f߃˳ @ p \A3<w
`4wXEff  tH3P	2iи`
0xB
 EedNⰹ`PaPwf Qt.3ۊRϖ .ͻ2pf1t	fX۴ 0XffZf^f_]ûh/0Mv? tPfY02f}`{Iq"O3uC Y	3Í]`@ʀoPu @<upË2p
`c;<t;$?<;r%+ 0/R&%Í\~33 t $ to0O"Ouǀ ÷ 	``lP  
0p
	 w 
     q[q#N 0
 X[<b 8 qKb QH1 < p+F RKc  EsAKH   PRPB X0QRVWP{ Pu
thΰfN i*҃q$`/t{	 PYwSp@(OvK~Q_^ZYø		 =ҋF @	<u2O3NPou2= NuJ33w"2O@2 2wǲǂ
ˀ
ϋr#t3uô$
V\)	^d!$N? 
t$@y$ T @3o fRSe|Xu:ߏf [3Ǿt2tfft
Fe\X^KXVE2۹h r
ugv3ۊ@ C@B   ^Qis.
,Fu{Y
 @@ \9p 	 B sƊ:Ht
;r23Lf^S&SfPQ
ffYf1f$
4fARRQQ8YZCBE@S裃A@7ܳ-}gܳj[0
:6u# wmu j#2[/ )2@u6ACMu)2u"/`%uQ"Q>pZYp~ou#0Ast
2ϙu *u{֒$Y 0`<RQteP
xp2Ht`
uK^tu:0tl t*q@
Zt KuސXu
aAc
u+(2
1r PpXC QfRWSSQ O$$ڹ 6Y[@uouhuaPu\uT`!auCЋxʟ< u P{=uB~p{ۋݴ@P *V+Hڀ,75X[_YQ5W/
B:@uuOu	3_PqupuFudA9诲u- u&uuW(PRW  ،Ў&w&L2  +&&M20&!G&!W2&GFp Fn^D2m0+@Ur#F#VgLu&	0?	W_ZP1
@	f			
'$@Ws+
E/
MNF N5rO
O
B
 O
!SVpҎq< ts<uX& uL&;Gu)k&G&<	tVWыD&)G&&@ 0w逾3^.R
(&G&Gp& 3Ҡ&T֎ (.	2$r	vLt_suo&4 u!)&Gu&g&W
 G&G42 &W.1#s
ҭ^Z:D(7&4&_
&&\@j;X;|;;  ;;@/3(|@s#%uG<&Df,@<w]2}!
.:wG&w+@( 
	߉G"$&G3aa$_!V
|&WA>>4% 12_$ G 1/>t""E0@J#2.J#;vA#2"3b&>$G$`+bwA!
2
.TT2#0 AP"========SQ< u";@ss_&Dx!\udw_$(u=^R^^WHP_"@%O3F 3&EE-_PB"
0c$>1^_9&U&>s&1W%D%`w"T=?G+me(ͥ0".0QWH	GICA!YqU#G+BvoPo&__+ bVXPl&!O R*S~Tg}T9lrq_SPjQOPwPO*3~3Y_?30
+ t[,.y cMW
+:p^-'FXWT<\01ϋX1s0	BdppWЌЌ
[	"e,!G fW
i/5
j" ?W*2(??4		`	e!	!e7  W  r u#-
 oc)7$p'xQR
H
[#p4	0	z0U""D
	)'D
UQR&\,2_q3D T+\-A12D TP00\>@NLU@ TW//(.%׎`\0LQs@8q;Gu
&;Wu[0wZ1ruWs37  0Z2OG((,(CUƃܗYF8FfV~FFCoC{&#G#ѣ<P!1?ю<s&OB^ҲT$6ZBA!O0Of]0&Wt kM`eFg-k#/E#EE+C0cnAd\Wb-"s	/K//~<ZZt[<cu3`~f;W
upu#&/G0g9Tһu"  s2"`g/@݈G45t0 q${	.2(qxGxXʜ®0b"f5/2JD&W14T2 ~`@W.&P2PG(`Q [,t&:G0uş&= ωw_F_40200,u ?8 ĆSP* kT ],-W+*_ƋtH0؋tƟÃ pQP΀Q8؉F`ۉFF f؃? V~fF F  fF  F  F~ wV.^2?tz&EМXȃ	2&E t3P	_tAaQ^&^b !E0׋v1^ 
P		F2 f  _??f  wr} ^fW[uPc
^^tݍ3^&)qF?2 Z@~ t2f_ ]P22ɰ|@r:W#HCcBF! ABoċfZ
fPRRWW2<tSSg2×0˃> | SB_sd_ f~S\k2_`F~R-V\"00</	5@U3
\%/E%
룀Rи 怋o:))Z]ˀ]˸;Nø[NøJð5ð2ðQ Q  (@22ð2AëQ "$!&pS4[K0P<}<p] fPfQfRfSfUfVfW< u< <u%
t P ĀX  <u^ <   <V <uNQ <P;~
^T <pSP <	u8	w<
u	~ Fc<0@f@T<u
.
UC<2<uHxfV< 

	OC
Ff_f^f]f[fZfYfXP.,أllm $XP2=;uFR_ 5 -X 01.00 VESA P  aa	 bpP  ? ߃f3fvP" OGOOO "2ptL ߃@ O2 fPG6QW _Y EE@ E@ EE@ fE> :ffE(aM}W Q<MUEEYQYc@
uQ%0.(E E!`"#Ep
EE  	+ 
t@E Xt^tw
ppnE/  ! "V ##2 O	E
t0$?$E w߸ S`3[ȐE࿈E.&EE6E E7E!E8E"E9E#E:EE2EE5E4wW_u% <fX߾2
 OÁtC
utO:ސt/ 
x
$t~  3)%33N&J0&&Q ` Pb Ib&L  w& 
1@ 	

   S 	 2侚 S1u'vu&$<#u	<2 
<3 0
O øO Q;	Ytr tt:tJr4:&0:QحtY t.ߋ (_ TR >`31Yt$t(t,t)t&t.P[f Ρ * Œ 0 뼿24  - ÐJDfCm"!%(踾FC	T	#	&	)		@	*ح@	 {Ё ' P 뼼	  O P	f	 6MG3к`
 V  uE;>H?0B;Ј˰?HH舺$u1u
hˑ먀u($PUˊXP3 ;wX) 
u#sS|$薺[ ػ ɻ[tRc~R= rt*@[u`C u ?^W@RSfP @# 耹fX[ZÜRx R跷ZÀtOкf{ශ0ѻAں$Ȁff	PfD  f%f% fXf{$qfe ff4a@ ffV t  ikB4 `mU FF\fб	?	f`Pqf!ߺȋ1?ȇX>ffq 2҇  tf r
o I@ A0+t
tMN!;VA¹$@<00D;gpP
  `
u 请]fA@:!,:S0@'g&R D
L.ӔV`,C@t?ʲ
& G OC ;Lu;T
u ' Q `1:ű
t } % AtN D Sy{rE ,uTt%2|`  d4P _
B e'2
39Ϩ +YE
+ 2L$^ɡLߨ tQA@ kѪ ű< QRQ[ Wff&^_ ߶uM@x'p80<2S1[q'&EM迨
ɱ `! Qu12虨~` 8П
 vP ,tݧ0bu:
_ : P: 	>2h u	f6uD{ ]» % 1 u	޵$u@@_m uQ@Y_Suh³̹#u(̹x'u̹2u	̹8p
 ̹6f[gSٹ 4f[ft[`  rBaPX.]^~^\ߔmqzKΚ5М2)a]' aR݀&Pq;uXú체0&GԱ uI	 BAS5G
[u&.+X&c aoPVX tf. 3 B|D\33ËF / ( W .
` 02&'C[2ð&g  ﰽ `	Ë#uaGt0&F`S2 dCp@2t	@F[7氼2мgûg
} 3<Jau $<~$<t <t<t@؁ ð@  'uPàÿ(`R`͕    
@b@# 2@3tb
,t߈q`~q_,tq$SIH2.`e&f[,0(0-0)0*0.0?)0.8%u.]3} ;u3,uC>0t<I @.>*+3u0(<~&73 3嫡0 6s1u  Ӏ 2u4*RP12XZ""c$b25uK<u@ 1$@ 
 u{ݕ1H& 0&0X PC: 	0u
u$0<0u  &o6<uA	ut	
tw0
߈ )<u+V1u
tu!QA;À3uހ4u<`!Iκ 
1Ep6u& <t	  먜R=B"
ó L K@2౿%쿉^N   (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   


   r 
uZ*   **Q p   ?  ??Q r     $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7??/?'h--?1-?6-?:-??1 :?-6?-1h     1   h1 h1 P,h     1   h
1 
h
1 
h_( 	 c-'(+ ߹ Q71;p9 o P _OPU
(
@    0@ T( s DW  
0 MA](G
c 1 p>n1  
   
> @P 0JI @ 	 
  
`%( (,%*26', 49$,0	
!&.3+0$8=cd dg3c pp.  (89:;<=>?
(d  00   0 $0
$
( F 4g8O
8(8`J1g8	8f(<000( 0o* ,
T 4 8@A@@	HR8AL8   Lbk2
B
 *H
GTWBkɲ+_B$(gC=l _+e
 88P$P˴@b` c eÃf;u  : F ĸ P 6 "QS  
艷#SPȀ>cu/n@ 3ۊ.B.EQ J +t0 c@i<8t<?t_iBI%@.@*0Q` d `7dk Y @ 3[ 	Q, 0YX[RRPF ._n  >bnÜ3
pYGS G`~~|ֺ| |88| 8  l  <~<W ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x.m~Pp` 1a0pp0p0u$ff$8|||
<<a lllҿll  l ~|@f0` 8?l8vvpg} P``0 @ ^0`   haa88 || x" f<| <l |7ƀ o|  ~AB qP
a0QP 
  ~
 ff|ff| f< ll  b`|`[` 
r < p w `b% Ɓ|ְ|~Zl\) ll#< p P
| :%|| -XQ0x|O~ `   `̀ 6000q(vU |8 x`flxlq0 	lܢ-u| p%| '| 06p'( x*2
v 0d 6y1  8 v5plp;؀5 |2ƅ88
l8|'!5f|ƃP/&&00 %:l~n ~ހ1 -7 0
	A'!r~`l`fl fEK>c8c>@>a<4:   ,+> >`gcc=  G0`2#`?#: ̿0|6> l<~61F  6ll60` l  "# U# ݑw# $d  6 P P 05 `ROpqPDރJUd770?B?0a a66 Ba	
      f~ 9xeb]Pf``y`p_d~̀Mڒi|v܀=8 ]Sl8T(vr(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xma@ϐ<<S2tflD8\p&mp0t| GqҁPQSlEc5Flpxpq5 aq3ԆC ч >6`vf ~~`D>~~>ՂR2$X PC {p4`||s4S
@0 setU9_ 2`!@AHiP!3pxF)bfwP'0v~mi {16879
G-3 a5әAPp|@ ѓ`;Ҝ2#a=Ғ~BC ҥ  R*ҤљނtPha7`p0iQ.f`d|d``
`ζLӥ 񦴝Rpb q
 5xp S 		
qQF#a` (L%4bLZ ~EP  4-e0a6P6rh lq   a 	P S$jǷb[6  qb
P$=b X
v O5. 'Ma0 
AΒ|о cǃ~A U` t"{ ځY
0x "p	#	$@%#Qb 
#p
  
%	"Ђ#Da 6f 0Prʀ
$ 	%  		C	 JCdw@ρ`1|cc0cФ 	?!	8 ld> BPP<@ WWd! 3`p3 B< ;8>dp` ~0]Zwl^l Q6>6n6@s&tؕўD+ f 5 Z Ed 

Z Ӥc gc b
d
d 5e5ek 
c
 eqee u%


 9Ը=3;1N Q1b0i2S$|ҏ05Yap``<f	`q|  0^0 v 3 pј/AX`ix x8#?~ )SY/*1(ҡ P2GM  "TpEYV!" tWrX"f<<fDY3\qmypf2hwfw$0 Iq    ts | >>]
Ë3Ҏ&&Ϭ
&PSSUSjSSQRPtFW2@ _O&&M.$W@
&FG_&E"&E#W_&]%&}&It2.'2
t@' () = ~=^~=~=~ &U*&$
$

0B$
	-0
12;t4&wt U pu`2Ԋ%+Fàt6@ X2 ø  t` :t0?FË fPuB%C ܊J 2  &GF %G @GÜQW+& &D&TAα !	ʑ  p&
&TA2 [PD_{ 	 I!_Y`< GQW(6(5p 65r ts | :&?Q 0
G@6D	ĸ 

 2
P2	2YQ4;G4軆~vn"f2^Y^ /4 /9EPJJ  B2B0 XJw|VBBF^ú$
Ĳ@`?  t Q%P䀀p;;$<~&G3u<#t<2t<3tP	u&IRtAcNb  P3&2JGۢq IGLq ģ`XR23Ұ
)u 
Z`N.. un> tgp baLP>bP22AQJ2=QRP
u 32ZYYw2 XaZYYR*8}2.&Zà؋!+m 2Ku(W S
u
P]`[+сÊ2+**&R9  @/ZHuÊU
J@B J"b1 P#Ԩ`X3d>I#t(q 2t! 3tQtt1|pd  Q@ !
+ .J
u8~^` @(sC<0t *:Jt. ` S +!*2+uX  u*tX⑰ Ë`u"㨀t0 ]׊4"
ވÊ$"ð(cрѝ = !$%D
m݁ ? +

,QVW++    e_^Q"YԊǊ竊_ S8v2QY2P  t (P
RS߂7P2 PL[[ZRJ2ZË.  03<?& t
uV EÁ,ņ!?&J aZ5	 [a2RqZ 7L0 }
+ȴ@A
t
2&LōP zW >&}SjcU~`T<t
K<Ut2[ðo
 6C%ŀA`A2+Q+++YZ0"Ȱ++Nuâ` $` t  2tatBñ8~
td\8tX΀|0I~D*
u
8t8`t2
8~
~Ȁ}RtɊ*_
^!NQTt
w櫋0['$jtPi"t
wwyÀ|t#GZqKR2#Ze<RMHU9Qpw@ @ AK?+>+r,+Z 	Û脷"+RTo7t|Sr`ı@ (&Ѭám +>u@F E&   P o!V1GO+>2u	&}uƀtGVW_^t##ut>|  2 	1
qh|Z`+0w!  pjr,`u
UQPЁ
6JX2D|BQ> CSu O2PpoFfKu[3dT)!o(|=?TSoUkujGPbs 1KXPk$6| 62 &tiU؊PPu'U#ëNp &Np>Xr ì}.1%   P 徖I ãt&0@ ֕"?   ì&O 8r2pÊ02fQ fduh Z `   R!Pfff  ZJ PXWQP; spfGufXYo_R
Q+IY+R3at8tǾP	pHbQu　PUwP[1@.ׅXn-VlA8|8F۶umXPRJWQͷ2_8v
VaG_YY_PP*[KZp_G+B;v
3a  sòθdcttQ˰@euu&fP - f ktf$߀t  
ء~SP
:t t&   _&]Xu3Ĵ0G`ĀP(ft mw`$eL軭ѹY&0uѼ% P~%%@Ñ1Ģq>0JBbXXnIt1t_Sm)?5"2"٠K}~`bt2PI<
vJfu3JpzǪA8sYaPdPt u<
u:6u Ɖlu@L<u{<u
t22+qt땽++&eP>Ѓۋп  f2ñ.=#t 	O3ʰpyv?F ]=8Pu\q? |NV
I_u-7ԑ!Q.)2t.;t$?.
DY2^#+3*22<PRs;ZXt<ty =u<s.eϝN>! )AE #]sz @ 7~tÆE;P&D0=&}# 2 0<뵀wCP0$&e߀ te P ?02Nx20aJG`b`  Q&5&m&M  ǿCYð2	=$ǑN0?w u4 yàNR!v &w5&MúLq `9q4   {^o \1U  ]pOHqVk 8qW`)t*2S!q["qƿf
b  %^q[PP;PY0 d2|PXR9 ZSں[ SBB  s Ȋ PQIu0zXŋ$ ރ.-5JD<t 0ñp<wPSPRM@u@	l t@zP=s=s=|s^=Js  ZX][Xqp<t<t~ PS#[þpt@ 8 < @É.| ~ Ì@2.(. 
*@ ֽo w 5
uw5wvP|&P u͎...ULF
FwoswwS&G&g3t"<}A
<}	q-<t
<t̀
&G2  [àÐ @ߋP$ "3ҹ <u`Ȱ  3 2}ut
PpuÀu
&~̀ҧޠ@Sb[t (22QŐF t  +YsuQPW>&}t0&<t$G Ȣ&E̠+P!_X@3t__tG80hu&_2.ѫ!tR$
J	 ȋ>/u@ztHҊ& L2ܾt
wt<t FX0J>=&]&M&U&E
P0>X}21PSQR..t	00ZY[XpD|S1P~`5[VQS&0<
@<
t2~0xb@@Z@' t&^ Eq	蟸sr AsБ+Pu {	rt2@SU% ][ X[YZ>:p0.d. B
 cF<u	A _.:r2@.] IÆ$0<0tu` tq
2.;tq a8~û i tPpt!(_[t0Pt#  P 2       ?     @      ސ  @  AV6tt#L6f3۲#t	 ufFFfËȐPk%;Xi^2y[j?'Sj k$u*d  z;j`yzV iû`k\tkP1,j Pi(i]}Lku@&qiXoiıi2fQ &k~#'f`uga3cjcf  / jk gjr ju$h;
 j^i j$i:  g `   j p 
  & > 9jP h+v t qv̑kMPgGj$>=<vEi iEf+Eiiu R Qi4+E	aauP+
F@B`"<hf$%%&f`bc
 RV+Jw wXwy+uu  
Mi<u '-ivu$wtVw^ 2_:t6Ӌ_ڋ?t&:0Gڋp:Du<O+0.ZPWV2ɐ
wu u0  uI{Pqh0Xut+o*tPhE|	Q	ڵ
y
	!8;u n^~! !Yo	p_fQfRUfa f@ ff3}f(  f F Fd R؋F ?; pm2Ȁ?T@f@ dAq0ftf@0;fof+	^ v,Q
~ }rF='}F_}2
͊]fZfY5JHg`6eJ= e p <4  P;T_WÐPfRPU.ff2ffZ OfRSWP uDɐS,?0@@u-f f@Qf@QR»<!BB8B CfX2fPX_[fZÐRQaEfY@$!a  0[RG%`fw% iH5H> A4a	fa  $ff a|A	4a

4ih $}^e"m"5YZ#fQWVSRPeulfS3ްd, Plf[fIf c fACmd[膢dr D
u0EbppjZ[^_QSPǀt10`-rZ$]f߻`!'	"X[fRf׋?fPX Lغ" $ gLB"  $ L" $ TkL4" $ (?{@ ># ::
;;;<A<<8=>I>s>3<&& >Q?j |a|C  H   0 A o7o7MkMC98p788o75@ 5@U@    _A @    @WB @    @EU @    q@|C @ U   @W̀̀̀Ù̀̀UU//////G  G@   EF >DA    @H 3H   .I@I s @@



@ k@     ^ H A  @U @ @ @ @ @?E kcNqNwNt@ |NN`  NNNNNNNNNNmNNiNNNN   D  @*<h:  <ΎΘ LӶӜ  4&.Xlz     P$L0  dnv@
h,Zn<"̂NH  J|>@tvTh NaZl  @  0  P"S\\F   < P D5F@@ ^~ NUuU  ` 
P	$   <( 

HH(? K
8 
UпH 
 
	
U  @ XY 5j<  8H q 
8 Xx  } u
H0P VK @o@ w
U@  &  d	U<  1   	U+0L
F  `    
K`j 0 ($
U@ `a 0*	$K `p < @ :V
U 0 *
<4
K0=
 x> 
+	,<p   H?Z	2D
A
i TF
O	Y
U	  r`A O	8<} ` e
K	@ pq AU	<< 
@ p
K(
   h[	@<P lt
KY	hp  `C B TdM "z_ Pc @d F 
@  : `_ `0 a /    p4 Kχ GH<(  dt@t@ 
pk/
	Mk:
N
$  r@FE
6  pR  Z(\Э
  2l      2c- }7df h i0          _ Pwg @ 	y yy 		



g g 4p\jU	 #20 3
jj
jUU
U


 @ 


 	
3456
STUV
c Ud e f !
" 
#	$ 	0DEF
stuv
    
 )
 l  
 ?-  @@3x r (     9 `;E > K8-`$X@: $ATI5  ! ]AE 1qs 2l[43R bl ~XӐ<xH  p 	6MeLB d`03  3 }|} ܀   w  0`F
 #L  6IGp rUHP   @ B" D$HD$I$RJRKJTU UUjj0 mkZ۶m[mmn {{{} /1 9_   y `	 T2Rp	,B0	p  	B h2O_ 1P 
 	q '``0'&%$#"! ? ¡J`r  Jd  M7 cA 0xIc
bjW p bȇbG0Bir̀
Gi)ݿDچ\
́TT́wii,ԁGH߃cȀDоTˋǀ8g I־ѿQЉ)`~>*㿬투ο\و
⿲;p
Vjd̿څρɇHs BBr퀋HY"Q=(ھt57ӅAG[^KQ>@CRT7uu7T%F []][	f!,'пξ)<3H;!i)i@2zoH^ <cb?bc<!??)a KduTu*G
%~R;ž6 /IwB[kk >MԀۿs́m4 SſQ%þs؀bzoP.【Hކ!ڿ 	J߽&ɿڀڀɒ-珙4+]O̿2m*{Jľ" RR4RR{GR
 ] RC RRR;R=RoR	@
 C  R?@RHRs
7O0 3a? L tD~ ў3`p-
]C@   -P_> E
Mo  71T p 	}
}%`eR7w%9d%9P /5%[{ c[ :2 [x7 !@p 
@ z_ T @  ٓp  -SB n`rpq ?@  "@ \1 \.` Y 
  sO; O0`&
e 
e Q  ހi@ +/
 	߰0V% &
O pp  
ef @h  eg T 
T T T0 T @%%
%DT A T 6

 P 
e 
" ~}!
%I%J%TT  

e
 ppT #
%f 
%h %g (
%7 `%0`$6T6[nV 0 @	
-
  !}

@g	
 @!
0`@',b@
 	
@ 
@f-
B -
B@U*!/!	 
6p `BS#0q `oau"bPc
rd22`e^s f311@gs ]h!zis jkQ@p' l@m@ n o p q@rst u@ms H	 s  s  SA AA 3  0pqr`A : 0&??  ?^40r 

A EAp 0E
> OIp IC{> e	e`a
 	 c%$'a% a%Q .   q a e	%`a%r	! !P ! e`A@1%I`Y? 
)![3![ M [7^[U  % [ |aeVYR< P91% -@ "
< $Iw6  %^
%QV 51 2
  W
#= QT pL}1R[pN
 %A3%A>%A D/ J% D	AZ	A	ApZ	
`	 M "/ A
%pQM`	A1AA. 	A>AE{A
A

 AQq 
`uuK I RRm?t[Pt}= D=poI K@oIO7 <@с w<1   >9 D q 1R#T cppu0p"YpԢhTh
Q0^T(PrP0AA0@0@
%=@zI T0 ?CT0!q J%3<Px 
 S1 
~*pP|Eu
E$ut
J w ! WD:9 b#*S[@3 @	%@%@"C@b@DA3 @%@*@@ @e
0 \
  \
 
\
ށ \
\+
   U J '\
( 
&K t` ]Rw\`3 
%B\
  \ / +cE|07a} 4r `Q
%
 [ b#H h!i QJI#6`PJ	 D-< hiP !=ehgeiP PPg[W%<I\I\@\\  fPP L% I=pЦCBJ; @IQ pCVK [ yQ0v0 S6 ( <RQ!p,V pQ)C9p qa
 Q
e0R
s)Gro(roR/ 
DZ 
Dpq  D DQ`DD1DvDFA Pi C%6a 0h`da%K`t   r` %_X
l~W0AO堀IR?
@  w[ R! =D@D>>Q/ " Ѳ r
%
CQyB, [zAF[ha P P 7 
P  @ 0 @O)PT pQ fQX  Qdސ :
: 	 >D p I@`C 䗪Q
Q
Q
Q
@@ R0P(Ȗ

A
uKffgY` aaafINe

r
e	





LDT  Dg بf	 d- >e
a gf
  zr@= >  =\ [A
%`# ֠=BPq@p 
忥T&@C`1T0y
`}KSDk@T0<% {D~-Dq '% b "	
T  
Q
 uQ`ep T(1[ q\Ra|@;D(0Oq  Dؓ<=f$ &1
 `" @ ' !M%b  e$q5

%

%J%g W  Je  
AA	 AG p 	HˀA > F;C[ D[0
 ]Hb>  EC T

 

b  C YPC%NIQ9
` Ʊ[## DM Gf=dpJ~PJ

IQIP T 	T Ch	U
JЬN [ )dH =&& "; D@ Cc :FApd	 Ccb JAD `?4Ra q 32qMB

p
0 =EBQdQ @a``OC0E
$C
% CT `%"!` [[K*5= CE=}J@D2 : @&T $@ %: `7! ; 0 D/~pDC:d` p@ V}1w ʐ0Uߌ 	 ߎ
	{ߑ l	 @	p
Z* ~8_S }Pߜ Pw Q ]s    
 
 PV>}VW_ 쐷  Y :   N0Z{ ! T @   Uwxѽ߻Ea[о;0
пUUV Pa3 ,Pc9b@<qT B 0%>X%?> 
=x $'c	!'k*' "'LL 'p`('nW&'$'}"'#!''z R0ύ݄l.#'q'*	!'w 41!'>l"'9	
!'V!'- 5"'n"'-,OI4''$'}."#/	ߠ "'>]N"'/ U m /' '<0!'u"' 'T  "\& T $ %`$/&/&/&%&R"&x "&8]#&ET @%%`)%%g%>l%H-a%p `%ba%L
 
L  L$JLAL
<LtL rL%@wVLAL0>   On(L( WLLL]uL % 
L%L.%LPL}PrF0 0P%б%gx%%*%KKT  @ @ĀŢ #H@#;P? HH
JЕu[ Er5pDsDq6p%q% %p p` qDqAp q%t^p@p p!
pqsut@ p4Cs !	 Q (	"6
6ñp ?T(6[ӡ&
3{s J%I@@ f$@( L%@Dj|p
 @DA;D}
7D`krr\cbɂV
R`'[1 ᒥ꒵ g=e6 p ;DFq DV  CPd%[gPe?0sT v@%e@8eQ %i8Q el lepAp %ueP 
ewf
ABT ^Bp@  -
@A
B@RM>`_@  C ^ Z.VAA -ߊAA- F B z^ki[ Q :f;V V 	
]    &T0;i! ;`Rǆ E0 DN  (  e `2'p1 brC0T8 ![ءDU {U  IU5I  i 	% >P7D pkq? C9 

V 9 
 wA@ 
- ґ1ȑ@A'@  >A G -@u
 @[  @R\  m @Ġ5 ȚpP  pC]DD@P-FFsà!:)tH%Ap6BT @ =`TKoTL@M
N TI~@JA
H
%@>%A D V ApC	 {	pt32 D @RIL% DQR#T "00T *ڑ P!d%P'T YaepN:0`!0I\O %% iT5w 
  paP0<0 DDRI^OD<

 "γ
a!!jp& d *P

CD0 !T !PR 
%'?J%
 I}J` DmXCvJ
 
Ap8<
 MR8Q3
AA Fsw F0 h@`P5@\
my`1@%(@sJp D_ "\@j`pT0 &1`&2&3
 
4 7
5Q 6@%iI008 Ci [EaDf9bb)cP Q 	  o1
 
@V,	9 )3 {  --\
! v`$A"PN	1`

޶	ש 
"""`TOAOb c[{B) c 6 cC cP c@ b co c| c@  	o ZZ!	 Jj  ?`\%q\%@e! aa!_  
F  VPAMAM CMJ% D?`fA~ IX p? 	ACb  &k 	 ` e@-@=%  P PLa@TKM
pM NHA
A@_APM.La?[$ZT0Q@ 0sT :pS:SeoP 8T{8@\  QGR@'Q[r=DP-"3xpQ	8	~@ B9c_T  c
#c*ZZT [ CDp f- ȃb2`bc ` ; s_ Ǣ ހj 9? ? M!n  `0wDɠOD!iMK#`5a{0uD > D @G   qCqp C/  T0	@8E	]C7BPp!GP Qp6:[aC0}P
 ~-]P|
a* D8-{+0ppq-@-*\@AV( }~'[ ]pl% "`p1oO%ĵG
e
p3iC
`OO RNO 1yOAO-QOOT bE11VV TQcXP OVTN_PQP-9c0]P >Q`<9\%  @
JI1#  [7%Фz>8 `6 eC6q[ E@f$ XQ sY0pI3 "A
>CDA#J[ pQ`F1PJIT @ q r p sm<=  u -=  R%<%E0QRY @+%pNAN @5%%T
!@ WU -e%L0M `M
eNNp
OO P01Q`* %R8=e`bLN;Q`Q   ,"W,*@ 2 :0p.,pTU(ДbB:c cUc0w73Wo7  p #`>`I6 2p`e-%!ePCd%qeNA%{@/[ @vb,`dDD Qb:+C %$ '~ 01& U!`qp9001= I)C 0
BUdf *P0= n$33q`IV( % !!g 23vQ
JI`/LCg5q\"pQ2e$ 
II~$ eA&Drt^L[T $2 ~323'*%_2222ߐ 22*	&; 6bU.CP>)=&1`P% V  IgIA"Cp,0J@8v~@
 0 d:D2E 22@= D, *
 ` ! [eQ[[ |aU  [0m!j` k\%j\%k` mQj`6k`?[ ѭ`а& !P12 0BF  Pe CM '@
@pV 3@!@- !2Pbdq=H}@a@1@bBI QA. 	A>AE W gә4U	
 
@  @	%0Y Dg  sY d@'I"
@bP [ c~@	
@1@A Ep 0E,/ ց|De|s  D!s `D DpDq 
@Ig G `Gʁ h GC^%acCbPcAa  pf311 gq a
O C	 dz	bzA	
	@	@	tB		@	mhwqB	tq B	D	$


a笅`

r
fcUQbq 
ICspD1c 206	2{(e1P
/R6 
eP.[0@ &&&&bC&&P $coQ"`%%D%%$;D$P
$ .
 $Z1,$E-
(s$C'z77Cs/"	1p.)!)dp 		"9C	  CN(
1"	!&p;)u'		`&.R

U
)1Q
P
a&]Dg&A  O%DʾA0b0
c O`Dq D}!vACeC   12F`P
F	$B8S
(@c  $ %0Ba2B%
%"p@q !T"IO& H3A@  A *
{0O +y NaB7
@@RC@T7 HA@@@C
J)Tq 
sv. s Ŝ QQU vc!@\K 1	aQ `s  Q|@=U@ 0PV  RRR;[ ^ < C]S 啄 ݗ  b   R;R[ )<% D z! |+ C(P  : J%0 A-A` KDW C``T 2AQ*r 30>%A I`Д=I D !yA7  A AC Np6	%A 
1	[.=1)A8  LD- eAC- TA[T !  [ H@A&  2P B"  : KpD p 0A Aޑ  { ځu% P OC T OT @ P@ % &[bR<`
 / D O%
 
% Qr OQV
 
@@Qq Qp [B! c1`6 C
ef 
eh eg fC8 fQ >
B`ŖP	 P   	 $	 -
B@
 BKepx R7 Q-
Bf ?
%h ?$g
f 
h g P[             t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@byA      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VW@Vσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hY!c t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h	1$Ph0%X[ 3@Ĵ$<sAl r.ˠUr=O!` A (tD_rq XPנ"Q!f0ѣ!ES  gf /u
> up[PȰ&  cB`&X;q!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .2[S[W>  t> _`W} v	0EAC r3ۉ_`?2St]AM][Q_Ϡ &
R`9P
PR<w. [õSrġؑzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hιbar1TaP<u< <uϴp. .:.p o.c>`2p .>b:P	dn.e> e,À@p u 8r f΀g[ø0
.a.?&b΋p1p.moX@E2@g.*f΀ v&.f&˸ Laap7*kc.C3`θ0b  ϊŴ* # PQW`
 _YXR.i
 Z k@@ZBB PV}<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.qu#rp t
ArZwG ZYS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhYus33`o8u" wf`Ph^ @F F@ &} tC t;k{0Tta30h &E&E pظ@ P ^ X Wu-  ~apPfatQ@  YeQRW..| w#&.!
tff..A_0Yu..n_f.ӱ cQ޹R'@lۋ۩mcЛ{?Qvd1>+ r.  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.>Թ &_^Yy3	0		_Q @~Y!<8t	 `<PVt=EIAc
<
t0FXA{P QpRt @Qȵ$0<:|uFP ff PffXV	 Xi
Pj}^Vf3
f^ | Z  f`
Qf
*  >"Orf0f3ftY "++x fa

{E    1C< tN< XÀ {Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u}`< r 
A`< u4 _P&OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fow<A 70,0@r
WfU-f!*fP3 fXpfAN_ u#
%f]@TQ b_<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
u÷G O?Û=/ 3EPVWuצu0_UU UUJ VU?c!0W4#WU)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.)ۻ0IQjY f.>)R[ 8svp $h/ 'Qv t7H485 26r SH7z ueaJ2  UuQK蝹7e	$ <C EouA/m"' ;l  Xc3PQfR1[3w Bf>|@Q AB CPDހQ@RSmABC ;DpPOP ہR S co?[ QSWP).X.> uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s_ b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)WR<[ ]Op^?p.u18x f;tu_G2pޡ ܳ_1Sfa u<] Pɰ݃f   ~`4gB0{0t  t t !Ѵrer ZfAA Uta	$_`<`ut
*B5
u0
}t		 u
l. + ( @
r.ݰ

{ZE"R@r r}0MdZrЂB BU
a" r"<0P w  "
 B$<߁  wuS0p@ "8_t2TuNuF;J~ t> @ u.Suvtյ "1ֶ'
 " hi.'uη                                |x KJuII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ]5 7HĴJ!R:$ u#@G@6J B3tB  DECB@CЭZNBD r0`1	$ D[m rPfh j qbA$<+`mb+
cJ$<u	f  rPpc\ B9[ h>j:I:  ώ  P O O 	   hGr@῀ hv6BȎ؎zЍ
h3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu5	  	6r]dt B
#
CB
EGB
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl2QW!#w	t
2 _Yô{A3f@@ S' [P   X.
tذu@u[f
4p#˻"gf8 3&Rff@'%gfذ  +/;w"Z" 2$Ue <u
m203< U  $4|<0%= 0q<%Q f<u	&ka[<
@']P<'E<(q:<
P)!/1f= uffX<+^&<+V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYѫ; BIAf 蔂E;uQ
Pr"0 P	Ү  sE:R,(SfRPF1fXfZ[Ó_P 4Rvr6Wl_M8Q_`	(Kf	:=Uf s#(  sf t s	  t
 @\QVWf&? f&@Q).fSP&Gf&_fXf[^  }P`
\ _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$`	 iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` bi j b kc a ee    q6 G 00
yY
h 0	z	`b;@<Wff  jp
腠 FfRff
fр aV'WC-S@+)}W襢t;_t[s*`*F?[_^aWf` f xtup8ffпfGfY܂eh_ T1X fߊ$
*ff !A	S22,/Rr'!& uf 8s֊ҊʠXQ=RP
t0`-r#Z0Z  uf a/uUf}UPfPfXZ+ ]f0+ff]rff‸m`g#n |= osrsc:B
Cb_ 1f^ |w @tb;h w*f驀@Kkow  D)єuU6ѫȢ+f;q%Nf fCtg 0V0^p.RfJyZRUQf fuffVfKr=XfuNVFY[u Fߊ1MMuY ^Ys]Pg>!f0tRg'QSVfNVFfL |^[YrfqXftA3PXQM~ N O蛂P}SA` XPjWUQ`PԀ3ʡ A1sж 謱 ]fXÀ}-pЋ_P^Z`Wᐌ f} mp_;p0                                                                           Wjtj_ u
rP@u
df%  t 5u6?ju f1fxY~jrܱ uSfj[*u;.>  u
	

 PmX@  
f=` . P%^ Pr. 
uK遠uw m@Ac	Y
XO .E;
u&fgFf ` f&| uP	0tV߸ &=UtKf MPTh|< @Epk g `0l&ufރf&  } \f^SUh &]S^ ]T&uvD0D Vz& gfȡ \AL
^PqfWދ&TVop&ǑwAft@ 2fʃN4^ P P&t_ 'f=~6'+a¡f;M0ǭEP A
P# Wf.0	zg&G_q3<0r'R{u
Rff.Mdt]StQGYfo(3fp,  !@
3# L,5ڍ!%U
UEW &ƿE"Q*r aD`hsɽÑ"'rnOGR0w|R0q1P_@p@4` $ 'ߎ`1%@ 5!<t/fQ Y< uM 
fu f ` Ct?5A<05Ds;5 )0<T
AE6Ef.g"(q9R88$%J;"Q#APh

f
n
	14R@r('/uQ ">..p - Df`VQ$$@
 qB^3J
ry9
lY^Hg5 ~U5/X5"6HeQKv fd h(QN2^Dx-a>PVޣVW@TVp
 KJLJ HT
fStQؾdQWpaS 4@ 4f0? S^ hVTTD?.=ffWfQ`WTZBS
`m ["Rx!R`G2RWY }G^W^]^^Lp]IL@h/.(]]\0(V=&e	3
7T`TmDTp%uTgg1wؾ:!U	 h-`#XX-HXWw	)3!Z%l&#l`0_W3n pDqu_QthQnчnUO
hnns<R`vppyps|z= `/Yo,jA
1$p3f[`oRRRReAqJPSRbUriIbxbR r:0ftf>К* Z\ `Ua  Bu;ZYggpA ua`~O{n    ' f `fHP_D1 q] [#rf[4sf # R= tJ=`Y C灂f3fffX=tfX葲YfftN]fTCPAt7fS3 fy[ p! #  &EtswPfVT$P	7@n6bg@^Xpz7f^X_fSPA B?6XFa N V!~n$f_  fXSf. "   Aff3Ҍfff fm $EYPe^T 		Wf0w f_KAf`


2]
' u ]
!
fa`rf farO"f3f &  s`xR
Q[ZarfǮ1fH!?ޔr0Mf	}f'`34cru3.| tFV.D.ty< < t&CF^ t&W CI
Z~!3tpf20rqIrp   @ &d&TPQ[ۊPARP+zXZP <u
`ESQRs귄3ɺ[4ZY[@G.!
`X.!Ya`:
u ߃	rF 
r" s _  P 	Haf^K`@*ђ2$ԉNT@׎Ǎ~WF$
&пFG &U_P
	 ѲqW  $ 2_R Zo؀ˀ$0Z`  _$tЀ ]VȎ 6"f  T 쨀t D^_ 2r$<97R 
 I#d 
$p0f#f' \YqRf.4 htffϴ                                               K ׸ 0P #ۍ>#&ܾ ߹ B6{#a ֍6RRTFfaST"fV$
Ѐ
tfK`TT軕T"vT}TTD% Pf7fZV0k X`諰qRQ`Vf<0fs p{p	`_fЭ
,  
P W P Q 0 ,Q   	
,p   
T 
   # w
@p 
P P  0 @# 
F
g&o*t{U)a:۵5  @
c	 	t0
4	  @@f0 T     @		TU͊  ڊ 0a  pt	<p


s

	
$AB @z

B"@ [	#"  x  $ C  DЯ
<&*
apI4u &>*tX<s"R  Zt0 ZRu  Z Z'艡Y:}ߊPP$` XP$K !! XP0}Pf!'kp-f p= fE   tRg&  
 g& g&GPg&GP a#  GoGYQ4 	q0`   $C=f f ? C%'!PR-\O$ t.kOR

RfZqSQ`$O@t } iq1/-6----.-.øJOUfQ ufVKOrMfXfu gf@ N V Fu(gfFffffMufY2@YYf]Ë< 3R+fQSfVffLfTfDfL;Of^[fYrXP	A3PXfMOøNp OOfSfR
WfP.ONt3  fRfZO_f]fZ[PfWN$uNtQ uUP^XY ]@``YXt
 t$=Nt tp `z`p  	h˔N`_gRfVplZ fW m2VdՀw#t{ dr@y#r	` f^; QWV1/wy^_YxV3۬
ߊ^ S 7ϑ e {.  % o01fffa.6?fff;w	rf;w%pS./ ߃" _ POPO֐f%P[3/aBRK@u$Li aذ1K :0K= <r`WP<3՜p
ffʝ ff Cf-   fAW>`33&G;r_SQ <%<^   1S/ @t	t`QQ/fO  f@Hu* f@Sf 4Z4fc4f P,qfWP>tq r 	r
  u_ f_bñT^f$fS> tt,$
g&"Fg&
F J*$
g&#Fg&F	`0Z#F	ؐZP
0YVR	t#1
t.
t9ttt&
FU&A@S_a~w	t
t11wtFt`
t~j`
k@
pqew
df
Tg i Ri{3Rf]&^q\QU  = szQfP SQÊ2Y[$
P1Ff 
tN8tSpFt@Zf% f' f t0  Pt"H' U  t	x fXR# RVﴐ s Zn!
J
8
0
$=d4W p8Nff`4eA fu4fafFD fд2fr5oFP ^DP s f߃u
`vf 3#"fF$;F(F,0p; f3srBrH fv,v0hfNW,-qJ(X(@$иPN$0 uf2N t
ffFDlf3ɑ1	PaN xfր  ԡ`#f#fѡN0 fHfVPf#f@f+f;FLvFLfFPf)FqL%	ffv駎AfI )o aBwf*͘ +`RfAN
X7f%	G-s`fA d!`
;Vt
fAP
Q
y6"p  f% "ҁm6ѣ @~ p "F'WF0R.Fs) p k3> nffǇ3ȠjC|sPQRWSӶEt" C
[_SЭ½  躁 QW ߀@eϸ Kkܿ5b Ё 6u
 @ @Üu8   <PqQ GT< 0pr ߧW%!T! P11Nt9)br(SF` F8FWV ?.GF< u^_׺sCrD.\ RЎ@CZ1R Ȋ̱C QR@ źZR  ZYol|Ru8AS؀u
RRp	p PX E%
cE%	X< $ZT
 0
"~
t`ТVWU_wZwU
uQ6rEt> r2
tC rͲ  r P 
2!    _^a2
u[rVei1sCr"tr?S '?;Wr6"Qr
Er ³)ܠ01ce  
 ` E RK;\	\*P')0\;#$ rIW("  k_j!P7(B O55Bd[@r4;3r!- ,-BF3NDt?@DXRʠDG]?AD>>>>D a> > >0 '?P w? }?a ?& @& *@ G@	 P@' w@ @Q @ *A ;A P@ eA
 rAG @  B B   0 	  AHewlett-Packard 68YVD Ver. F.0C 08/01/200660@I }  Z  l~103C_5336AN w ~a	ܮrKBCsion XX.XX 
 
  _ /	`A #  @  A pPU10 In?tel(R) { u`rnal L1 Cachea bi2e	
   6PC CARD-Slot 0  
  	 www.hp.com ABS 70/71 79 7A 7B 7C`
   
3
  DIMM #1o(28Ѡs,
0~BV-"R.0 0"+1V /No baty'$"
(_:p C8BBaawa$aPP@0 QUFfFɷN
~fE F Nu3 'ȷn ]
 cRQP~pXܹ /FFYNZ1·A`QȴY`Њ  aÇ鋿ً:5C"ԃ BC & GUCp.&"B'@'d@ Z
  c Z@ 
G XYZð
 
7 @b r  `؋  ~  9`迺  #!
 	`D9p9a@ ؀ `
Uп؎ ]_aqp]3r
AF `P C0[oq$9v` $<u` 3 0ؾ   fan3S } a q VQ3AAY^` 
aËf3RQ3ɋf QDRAыf;v+R'TYX0GY5f <Ղ ~<~P֓ u<ֿ l<pc< %Z<	;Q<
 QH<i?<@6<
ڕ-P= uX< <<p@XL]WfPCI 22R٠u_fQf`fSt$ѻ"r   f; tN紃 f[_^fZfYffp r }  u^
N`o<u 6 s r 2fSRfPCQȝfXZf[ñ$QQff\PFPu5	Pf@# s"s t sЪ  QVW&= & s fPf&EffX@c - _^qPw0c`;t
X2 *W 
_ߺ ϰ#tkX Np s03OуufpJ fPff1f5 P8s2fYZf`ffWgfǃհz#Eg p{z0|ܺA|vT2}gf{p~gƃ~g u	f@w1  f@f@f_gf1 gffgf0	a	fQ@;gg&fGfXf7A;wf+fq f7g~Eggfb	_fF#fgf&fa
t@@P	3
Hx
f?f0
_gf3  P
?@r@
A
@  gf3fS̓ pwff#b ffyZ?'wf3f30n,;w6+#4ܼbf[gf p2
ffP	c	

fAȁAXA?P
 #W!fكspÀ +SfVQp g46fFC3YQ  Y`@.f^\ g&{GCffT`h[(fVfVp[
2Wf[f_f^rsR
uZf;t Zf`Ȁ u@^s*1p t-r(@tG@l u faUQ	UЗF @ E] @<t
<t ჻`Y]p4Pafv2! ^~{RZYXɣAr2@H	{ tt -  t	  ߷iR{9`K
]r=s{ +@H"#@OѠF! @80,Nfѿf3u
0L& r"P!"{ qg fF ""Xt$@Tff@U^Dc&Q5fPQXY ԑ)Ya'уЎ^w߃8 	f<tY< u#f!"߿߳t߃faHPSIMPLOyMO?TOROLAbVP݉VS0~P
HA  X`s꿊˻ʆ+i- >wAN>yAE {A<~ }A3A*@A!SR &3-&Z[>A AA &
@p+ÒbA A豰A@A~A`A荎 &3&M<St<Mt6=O {6O 
6+^VOþۥq!,*󯍍> ª ıذj@ȱƍȿʱ̪ѱ B̿αU_@	ӱV	ձUM`
ױD
ٱ;2+ 
r)>A&~X`À1 a   x P  X@ Y h i j@klm n@o  @ @	 
@
 @*p              S M HffS@.Tf.TXø 84=2t b<f0DRf1dR S O
uRS @P2@fu3"fQuNs' LAYQf.<0?/A  
@Rf.@RF	ff tf:~2fu}a06+V8 b0 	'@i &gy  pOa `
1@]ϰ2q  S\8&0&G &G&GP    [ !@   栊W@@\&׍\p F0 ]
q..7U3 и( иp  2P
C@@ XWP<w3t*p O $ ! & _%@P %X^2s%$3y1    wЫR۳4! f`u!fQfYgn	Л[.<Ȏ3]Ou r %fPS=Au@u;Áp u39 u+ f?wufP@u } /Xu
_PfP+< t#%s{AHW{Ne|SJo{_ ?@Q  RV{{ CU{[ !q# {P إ{3r{Q   A^{CA3ɍ6`.L@.:Ls&3.D0.L^` 2`r2 { 2_. u K󼧈^t
Ъ3t t
t
u! #l3ұ u U2 t>a.} .2a u} P J/5uL}   u3puv`bW_tURQvRUPK2YZ6	u>^
 .D t+ t#VݢL^~ 
.L ϋ]ÅQ3p1 | Ys1 u&	 t 	&Uu" ώǍ>Z |  Êö 澣{..| L.|M!߿Z\Zh	!cjZPQW 3ۍ_"_YX $PnP![ '[ '[ rfPff  @tfUfp PbPg]?rdx߱ߋfX]ge333rVd4Ad^;sgu` 
`F s M tAt<VdDgį}
^` VWd_^gEdTg}'

M}gE `tr	 	t}d8tW<ytu@D[
`PfUf]3
t s8u Ó' x.;Gt -._
u pv`1	fg6$+' +kh3X0}SQRW%,  .s 8 0fp~#ffg&'f 7 O @G_ZYQfPRb fZ0`$<t'<t#<tNpc  t T M_ H<u 5  %l  ߽
 aS  _#[SQVW3x[u@   	u1@ 	 __^Y[WV j1 Sa X#
^_Y[X 	S$	ppquà uZПRW H $tud`$@r@ s	t   $
_0	qT p	AB  plFpoypOIEMAG  IZ P   	 
 # HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Int{nl`CI-As B C  % eO   H	P 	/` <M `` ;c!`F	` o` ?|`CD001EL TORITO SPECIFICATION& *578F'()+3457V
t `K v5``w
&  `
x_t^tPt\7uΑtF5R3< v
<ar5<{s1$PɎ7a Xu2#ôr2հ%>rVPsu\} "9H2.' uqq 0$!u@t<az<zt, ottt
w
aE2@q返=6K-q(	G\2A)Pā >apt"߀r r	<zw2vPQs	} 	%\?EB6$PIR P A& ` 	"i j b c a 0l   q6  0(0C@	+h 0		`3. Wbp
j_ 
p aVW@cS;zct[ 
ް[_^RW3ҁe`  Qu? GYh /$`wXhV.?c 6 c.?ckX c%fZ@` y}v 2}hU< hԾ  1qqsw sJ`w/ ods
ͺ@虺bp .Dt.D
u  `` e&&a0 LfZj &&E }3Կ{|QPTP !XYub`.\.׋T U.L` `a`aQPƌМPR怺NZXX`J6ϻZa$Qd}>PpfdHfұdF+ dMd5@J V=d>d<d;]t td|d]^  R 3
' ' FǠ  F/g3 .;v+GuBG
`_F/ {@ Ë%`	pXvNuQ
 	߀0ʕ NY%'
r012 k6789ABCDEFSPۻg[S3.:gt	Àr2ۊ[2U uPXd}]<t@ r
-d8D^upi}yys T^u<`|`&
yt,ـBt&M1&G&a	`·LAAAa+u 2pȃt
 Q ܈$FKuðWQ
u	ۍY;Y_uS؀u u)45  0Sˁ3ҀNPS0
BJ<Zu$ u !N t3 `aqt$߃t$UNN<Uu$ Oy'N#ط$0<:r u0[P Pw`M p_ A aלfr A) QfV: (fPgfFf^YPPRt p	t	tv
 vt	؎ Ѝ
hk3 WfVSQf!VF! s^(2۹  ptF  +^D!8u3]ɴ^WVQCuKE3 m`!0 w $I^:u:\!u rp[_0< tG  )M
_ ± F@rP
fV
 b
"d
d
$
br	S@-l_.CذÀ,@u[û@ 2p n lU C  Ơ@# qEȰ>72Ҩtð
( =,p#p $zt3ø
 а	2s s	2  |  	  {22 	Ào tN :4kހd]
H$>
O${04 B;%$2
,êlllmEmxmmmiMiNiQi  A  G@ @  " y" U-Q RG   *[%	  ` Gd d`",q  qap O 
p  Gr rrs qsq]
sA"  
 6rM 		 

  ` u #PC[ $t$?a!h@ &o r 3u.}o3'w $ ]L
tI<u	.}o u<迃  2$\   tu0vu	V $
4 z0S0@ u7d<u `[SCfVPfWOe7NO@ $mc#jqrqqiq  M   *  "W *a&00o *
r@-~!8y Ay bc é uU~0]۠EPU  U0 t
"}r2 t
jrðf`tJRQW %  d_&UY U &E! t o&]@ Z`yfaOrK  u(<sW.-r_.趹] zP'Xs[Qmu..&+.	pV`@ t^P_.&궠u @ u42..
t 부wPUU*} *Ġ&?u XY0`nP A3.G
{XP *.϶r`WЃ_ sss$t't0t3t:t=tDtFtMtOtZt\tVS3.:qsu.r[s@K`"@[^* UFPs2SF۹ S.zsF[C3N[QF?tssF2~`"7 `  _ ø8 {d{`d w^J}A{`0{@ 3`2$  $GuMuVuaupuuuu`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233ptf>"  tA" P ap( Ҋp ) ǿȊ&)  * 븊* >+#1 d>,0.- &) gr..PR uq~t;6X6 6 GIY~3
t,=

"=
 
0I5w<t<qFp t<a0 0s
Ê& 
<uaw\wWQOIu& UI` u/?I`!A1I &
ØY6 FF;t2wLwZwCwSa\" c` \0ba3ac]aR]D]EPGn]@`[\!\i\衽\\+&t\ I|\Z[ ZZ g}
3gE
t"6`D`  [g@0Eqs߸U I2_ύ
`ѽ 
$&&E0d&E
E   F˪	>]>_
e[  [ [   ,hp,hQ    U	 Y
 ,h S,0ABC  fP fQ ,hR  fS ,hT  fU fV fUWXYAZ,h\1]^_  w` wa xb }xc נxd!eqf  oGo%oGn"nnn|nl◙vf |E `$
&afaRМওtp$ty@ ȋZ@ã1)u M-C# #3$QSWf0/ r)v!ufPs fXtā_[YfSf<t;f3f t	f ẽ
utǳfoff[`
 3:afPs fX?,u ^VBx 拔 tcPtt>@ KXSB$x$PqWXr$YQu!$
BB $JJq4HX^ZY[ | @ɢŅ i  pͅ$ q} qqp 3P./@32ƀnuo n Xp'Ê	uô c S3ێۻr?4°t W |fpJ1_QuX`fUfPP#XZ+ f]"ff]rPm0ɸn `P
Xu!P~<Xu@P詁ta`
  P7e@;eaSWQ  .tуY_0 g.yys
	~^+ A4.Y!HP  " 
 r
R3҄  tZP3Ҏ¿x ȫXR >Z                        >=# O@s    /%  !FZ.' r JƁ߁4N^ `Y	r(D
@ JvArHvAGsNfj@&t FN RV._Zr# M,u 6O_r pt areĠ	 u v tpr&@_&E0nr_"r}20RsUu
FUF -
 [9qp
 /B
r?@e{(
	pk^F&?s  s& p  &G&w&GPG&OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSWf[aGApfY^f& u#f&GP _Wf   4WfZfXP'F#~r .u7 u/sr?`. t8.> t]u  2KrߊV ʿs`,_	p _~t$` t u/~ǉ~ %"NV 1	s^Í6a.|ufRf  fZLR.._`>O_`k.:Uwta_aCWQS-ن? t0.}u.:Mw#.;]	w.:uwPw.;w	@wP[Y_ @o>ـ?r.u|
Պ!Ѐ ʋ.E<v mfV{fv0%dD @_؊
@NP.eXfa PP	rs$
2

	fXy!9
dDwᨎfUv]f^PRUBO` I C =7ZPwPVXuUW:>	迦_]sFr  P/$<~z1 r#P@Xu>>k Tߤ$@<@ ~P sXXty>~5+ T , b
~
 X  PR?艤
Z> P-s'`}2d!  R%a  XP`(  `0arSHmIrcr^t :DvL*Doȱ p u	R£mZ
R跣fmZ>
u rlR衣lZ
u2tp1
 VW
 _^ q _u
&:Ev&M
&*E
b
o

o
ް
urQ
nZrAA&赢@uq ``rJ r
tHr(tu"1ZQr r2*-=0t4ρB u@uu`  u2#3?fPS `*ȰQ[vPSAذsqD
>MD<_Ƌ.t u a?>stЇ!$!">;63@PQȎ bJ;r#bMwq_'0 }sqp2:Tt
 YXÀuOua9GƠ  <s& ? 0_pG@3 >a}uǀ   `  __VWi<ua<
uuP H<u>u0x2<t.$S!k4[|u|
v|`Azt\_^F] }
;u}	 .Arq܀}u	a`T@uDaP%'0QV 3߬+^YD&vރfff?ffJf mt
rj@%f F PXifP~ġ=r0&w)Ef0u fu Cu~A 6SVt|$st t`t2
3^[PfQ
 ǚ <  !@ f	t` vaif`ffпf {vB fHff#f+ִ f;wfgP3g&Sg&c
uff+ffaf@7SRm<r=?$`j0Ef!~`ffXRRpEZssrmuZr
w0V2PXZ[ %)d%&  +%dURfQvV ufuf_YfPQ@=fA<\1< uQ !ϱ n -Or.V sfYZ]À)T߆f;f;fZWf!rfrR f_f\Qr
fS r#|s
an`

<f[TGM	wrrڑBP
XPr Pup$S's[OBMIRlE{/lJOQ PfSff[f0ufXE)t fat/+f %#fSfQwf3xf!wX2"WZfYgeUat?$7 3#t N	Q!B^0
ð- Pľ^!WV@ fSP~WB Q Y_W}^9pHlGst6]V! <5u G	F^B^= ts.U<5ЙC >迧r Xf[2PxXo^2Y#WfVfUt
P E1r&< u P B S f^b$Yô P(	)Xs- ###a$Q$!{$P)
Х $o C'ð) h1U
 O O$
ǊOO O N$ N$NNks)B%ZA3+0\tq	 
S1'Y ðQ3)@+3ð&tF!zt	*tEPQS&q"
x[] <t<!t
<P	<*Q`Rj

	`3ZQR`-^P ZYp 
 ) 7VPލvS<û	 A[r!pX2PF^a ð!@萠 R)Vfs؃ tkr
3D@F-4k^ I3P|P|  w` $@ <q<
z^À	"  ؊% L"؋ ~LL*ZðRQVWPp`?X_^YaQs_XP2bω= R[2ʁCl0\
P'2<0f01*_ðWb4Kщ	R!`4 B*p
is"Sb+ST,Ҁ5Y:"UV/Z"<,U=*1> 141Uo6k4_U6EUP	}s
 7AB67c-Rϋ3 c!' t8tD
S讔[2P}B;áG _SM_ PМDMI_ >  $ A f3xߊ$f
Щfޠ$RWS221 rb r`u d8sѿ܊[_fQWp
t)ǯr xff  u '8ufXZ_aX r+pQ3"r:t+a쭿4 v ۭ
t8t	
uaYH_SYSID_  q _UU AI    A " * Gxx  x y 1 " *
x~"x 0   s w_X _y\[8y y `b é uT ËEtذE
U 0 t
 ]r΃0 t
Jrw Àxf`ti2tW & Gd_&E3ҀtB&U
&]@ &E  t û u &E@ !3f`ߜg /u ($
ô$ԴԝRVМt
Զ$tº^ZPSQRf` u'AZp߸ $jq$`faZoY[XP9?P  2XPUv F0*t	F !Ff ]X~"X
PS`{d{ߠP	2NF| PF~q`uW=u2
fveo߃ذfs߰elPu20S N]Fa VRftxSR ڊZ[  Z[K0%fPxu? Eޢރt% s0dA*Z^`u=΃u8ρB 
@DEp =E24 g-E0URu<脃u?7Gp`)DDпtڱ

 PGbXU 
 _s ]`K:KxSQ3}ɰYڑ6ހM M>rQ4Ys\ P߿ 3Z[3x0"cݻ=`"P3
ݸH CٸG CS QL {QK S
 pN qM C?Cd't.8~%mf3gf&ff=SCAFtV1Gz"ffff Wuf(#3`fPfo#fXs_32_    ͒~Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 V|s_}|789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+VspHIKMOPQRSfl f@f= 3p fl %	*P'z @TO xOy er$DIsL U]tf r.]èq S芫r3f% ff UCESM{rm{sffr 3 @1fqu%f# p	еLr`t s` u.`lgaff#fp* f 蘪rf_o 0Q<t2f3Cr6
+藪cu g> tt Xr(t uRY.V&@ i=4ԩ3t?`z蹨r`fZ q8u-t(r!f1u_t 
J&?t:R!4g&? ne"=c迧N ͨ8t , tu
@u$2(H	vp)@t'W@uU'*߀tp(t
 /!- 7 t> 1@u2BfYf[ a33q 
t@  t}b[QvXri/p/B/RZ/rGU/Z3t@$
p ְ,$ts @Z
fVQ! 0fF3Yfy^ 0X_nַ ?  9$@oO2֢!0ַ@$ї	 车 ﴦ ~SfPۦ4fXPش  [USQWfV~W   _ W
t<5t^uf~3Ar Pf^_Y[P-p5QRV3P'  f FKt
`ۋ8u^Z0QfVW  5 uEf_ЎD@t0	_f^YXÀu< uEuPPu?uZħPPE EPP runtime BIOS - Version 1.1  
 ާި(RwȩשکwU e d]P|.o.}o Ǵr FR.}o
ZpQR P<rt2[5$ԁ ! 
 -w"  S`5	$ V~ p[		uR &x?uR]d] SUUU?.VUf	`?&n QN CWf	al _Z 0m
 J: U PSR<3
 j ?Gu 
ty ).> @7?. 08W
   3R3uAB$ԡ 3ZP1 
(<Pd5bKP@ &` XW<r؋ǁ  .{_Swt 
'0bpr
@ w[e bvu0^r!<9	rr&z Qs" r2.t2& wr#~[!
s  r 9q	8 r 	&& rr	MôQSs+&' @>' gsa$5sQ
u>[ W r%p$S r rq	9 f" $ pXqPm CX#t s屓@t,Radto` bpt t
@uYÜP`
 LCXr`QPPPtQXdYwQPQ0 t	3`PXd$!<!tQQ/Q  q&@tPGy S ػ@0f.DحO<.Df`Muhg<  :1k2aúB  $;Ü.Dύ+߲ݯ *{qݰ "Nas@PpzFF
]X `j .  Dv
B:-Mf.N. tI F ~pH p3؊^)@uw t&Du .⭋^^t7a.@t&ڃ.^2Ȏڀ36t6^2.p @ PSFg
t'.:t	t?X._`3g }i &  @
̰d@a PSR,غ:3%  Z r-s(N@rH rr
FјvFr:s5&DC H P>rڋpJNFÉF(t S^$:u [r
F&F$+%&=vHH&
D0&du rcu
:	A	πϠ&DB êĪǪ AHA0	o rpU`^b`ospu fD
E$E F IG q
V@yN~tr>u rG D}ykA3F) ar\RDQwZr=H r8 SsUs#T
P
r
S s~@H٭ $ARVF(`r#!#rr蕼`ip!<t '!r #!F( '&d&Kp#V&f)&t N.`R~D fX E QRfl f@f=  uf3p fߣl >t@&? _  ХRظt"
p  ௨u$! !Ҕ&k Xws'` [ݓу!  %a 1	aI Xτ @F$$<r$:u s
qú#t'tw 
   @(Ww  $tV̳rF.^4uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$` ŢF f%U$PG >B(IJq4rvø fF" PXۋN8NwN 7RvoZ2NIII?rQ vIßIvmZIr ruf?QuA{FupDIfYI2p/5/  &u Zftg#  Uuw VQB AB 4uBY^ 
rK `&s
3
'u3` H@
%uèt?àt  A:*V&T tup 
* &u^ô ϋ0QPXuN%&:L@, r&"Tjt r@u<utGS.@ BD ? R 1434pG+t$<@t414tN !$!ss$$á]j=p``spBss5GsFaxsG<Pð43 p H
   SQP@*$@Q;Xu*@A**Xn*$^*Qu
aR=
ERVWf1.1Vtfā c~ăQ<VV<W0U     gT ` aзfP >Ġ ȷf 6Էs >зupHf}2>f`@Jÿf ྋdøOf .> u@/R+quY>t.`a D)؀ J) b
O~_^Z B Y[QWVV_  ^_Y>> r@" u]p( (3r@&[UfQfR  r.7fZfY]ZZa /  ȑZNZZ̐6*!@BK w(X}dn`x	AZt~ƕMڈTs->ޓa.ZD	Z:k.FhrZPT×͗חߗCfW@sA< uf4~,u#v|8~w|p f3gf& f=SCAF2Pf_U< u
 	<! F ]SQW  '<w&< t'V3Ɋ_ȈCF`! ^ t	  _$SQRVV<v^.
wt"  ؋&B&^Z (U2"4"V]贉UP X-s.V Ou,]}}A ! g g }Ar6kkơ` vٹލplO} ?o:U@<%kQBr2t"S"*PQ o% % %%["2ɵ"YÊ .6g3 t`<u  @& M!@tA AuqPjpp  ,\ & Xe߁ ?`O  r
 P<Fu uo4s	 	߀uA
 t
u	 X RtGTu`6FtEud1r_RtZxVr 0& ?Rl Z.u3Cu
h1< $DuohN hk 
XuhbX& `U au@ Ϫrt01k2rK1r
 4rx4r" d P dXPp$& 8t ߗ   QX uSQ^ `8?~ ݰ`*C: E801Y @@XQ>dY@l$PMM GP 2Q``(.G_q¯a==SW_.}
u.:{tL u% t>JrSa.[t 2a.[u t	t_M_afUv" Dv t Ar Mw FPXF
Xf]h@ &A ϴ~Puj@! rPOq?ôk
	RV`.6׿# .t.I.
Lj@s&  |0u ^SV#?؁0.d.$ʋд^[	觳ã3j0rcOt` 	OtOtLtD`t
`t`t`

1u	u.<u.}h $ B(ÁUu	U  nSfQR#G rp
fL\9Zfk fP<r|wfDЮu
  ufXtVWUP؎&Br& X`,`> ..>@u 
Pa 3PB &Gݾ&G $ $PCv &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^0&?sa s@ `b 
 ff&GfE  Aoff@! SRWPs޲ rv,E<h<  mǀLuUE<sofQAM}3 fYr2>a[3a.  EGώǿZ 3s./8[Ü!s_Zı.>ktGFr=r.EP .&2a>OU_@A%50Rr1َɎٍ6ap SRt5ێËS.&Gf..af&_f&_P. f[fY2P)Z[f~f%DwTRSLf]ûxuTf`0D wfft;  Qf3Y_,65 ! sfa2j SRW*׿Oз\r 2 H8>3_Q,ԛA(+Щ@Y krx7PO3ɠ!RSP b	$d=d)X Q'dt75Yw a߰c`sX SQ2c'	uB7X/2V_ RcmZ +#
{ 	 RcgC[ZÃUSc2yc<Uujkc6TYJ*cB$cBcB cBc crQN![P@
g6bS"
!
"X"
u	  ت *êoXVWQP Dt!WQ:t
Tu8v
Y_ԐeY_XY_^ÃfRf  XfZ.`!{  `3$Uu3&?t+aۍ>4t"tC .:Uǀ	 V tMRⴎZJ!|p   $$<tw}@^^ Q |tYs3Ѐ u*{Vyap ^t
 ,)WPcs)t!YRڲɵu3{ێKZ
ta, u
u
 yuP@s+XPt [ڰ1mzp胱|@9"Ĩ@t  p 
  ̠ XPJXWPB,+. s#. sXP@&   + &X@W5P϶'->@/HAC  L@ σD
` t% ;MvЪ.sN-f-̡ªF'N-  ̧ύ6& @ Yy̬r 	
F (| r
f	u^'Ât %0	Z1*5036_r0/5jr,r[
u< r<0s<"N@`  \b`
䓪' 
$nvf<0rѨ
sмs>`.uZ
Mʡr|t
^!N%V#~FPS2 ?r2 {0<ss6< s
}E""w*$2"#%ҷ 2q!)A
 ؀	.?EF C
r]s`ޠ1I9  <$u2 *<}#"< u@<v<%p!2cyÆ@Q
F!UF%FF_~R=r&}v 8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZsmSQt^P^6`m iAri	D蜻~(LuWMsfP`EfXr4=Ql.Thçh3V#:Ti<~'t9"0h!<DD@ % 5]hQ?~@66u0fPf_S&M]&}20
[Q
W`'QPvJ  6@ ĵ1FT_ "Urxtn/+rTO u&~ (u	 [ <VƎދRZoZ^'pqtZfR mZruLr Y蓵r)8r$grr
賵r諵Pp
u  r@!w
u 0!fSfRWBt:ـ?f.ffAUffs / MF F
tSuNff3ffVaWP*f8f'w*f'F'*2t*܊f
VvfVv5_fZqFsQU n E]YR`PAYXtUW:>葷_]s=r  "ZPqPR腷 X@XB`  XZXQRPюً PRY^ZY`XBXSQR[@( S^Va˳Pk|蛀W ))0 Z^N}谳rttRXZ蜳r`a r[sz">`iK0j`, V5<s-aO8Lp
t" >` < T#<T$@  h`Z 
PWX kܲ   x` T7rzHP{Nݲrh!uP`ph&RWZعW 裲r.Ǵt%ttt t	?t% suwrM	 2P`R^QRF sH<t<)t<(u;ё>A u/WU>@Խ ]_3r0蛦C~a/`,^a*dV(PSR 2Z PfFtN+@.XV"Xq;G	F
+#NM5VM
%*VJ JF
t
ΠRrWXfS~ t=y~^f~^^~;^~FF
!CFFF  f[fQ
tW 8ؿvNH^~nNfnNfˈNnfNn"~*Ċ^
^mIfYSQ0PfPv j 8rC"sfZRfXfpR߈Ff@HFᦈVvP{0耱fXr+t@UT3Kp' tff   `Wf+ MYÀ{LPJu$ fΎr22at
.i褩^K fF! PX`K t<"u<"trV3޾x 4|Q&߃?s@2  s& p  &_G` ` wG `  0&O &O{R ef&GG ee  5A@Wf ]ag  Wf- _X 9PVQVW!:W }tNAu!u .Q6 u/ˠ ࿀?`O	
 t,6@QoAOGA&&d&D&t&Dc<_^Y y=} w" uRP2a
 蓱 ^  Z v< 
u`S8_[PS3E_[
۠^`$^X4_ajs3ɺr
_03t 뷃0bXԙfPAMSÿUp4VW  Ў؀ ppp  u
  
q 	˻ʆ Arr_ɍvcF0@b& Ob
 30&OˁxFU$nd_]v
` _^ow 1
?p 0 MB RW߸ 
$U> D =&= lE>&FGvu|>v >p c@lu#' ? ?&` 
; mub
@f3ɐ  ށRou@@&k 3 _ZGF< u  u2D@ _sN~ t
SQ#[=Nu0t҃ut

q}fQW h flf8h0  ` 蟢f Ǔ H  $p`UftEf
bfārPf[8Q f 0f% ;tf0ff  efX =Qƴ_Y0a肠t} 赹}辟@ şԟ10Qll'k ɢ d T q r7*94fffqefT P 
Rfx ffú XW4Z`PXfZ`d f`@u!
f<@ ~OfQ` ef%
 P#|Dp zB$_B3E @1'9+ f`fްftʹ" QBY ffhfañf˱lӿ p|3ff0tf POuqWryNtppN?gPNc[N\rQQNL G B = 8 3 . ) $     > 1\_Q~^&GP':B0cðd `13hf   g
h Of6ocO  .p  gf$u 0PP% ? fgfXq AA Jg߿ >`gffa 
VWQh< 6ذw8Du2f3Y\áWfVfu=szft0@f^f_fpp<
tSq##(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.@ A B C 0&"g]W[ t[g}
3[WgE
L uV[ 3    SQ>[u5M嚆ur!<3ɸ  3  ORVkV&
[lVX躛<{tt# >Zr
[<t<t舛Ɲ< ^ZKV$$`/u P	
ir
-PpøZQP =c
U[[[2UiMiNiQi  A	  " y y y @zuaa@uXXZXp! / NaPRNZX  Ü= srs
0B{ _ ߸^ SQwt	.} ! !$諐 S{QjQb;PQN  K i' G? y  P" ËEu
$Zr `tW   d_a߱     !rcs^&D
V F&DtH 5 
B =r!PresuF.bаިe$%FrQsLFM rr
or*. %|EZ
 
FFt NF"pB@ BpF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F)@ r4F$
Ft+ F P   !V
V@":aPgWPR uu	ZX_pfRA(t pfPS^ۋ^&t` $ueG&uFtt`]]̻(`]χ}@0*I%~I   6  @G ͠ "JJP3@;b D]fqRfVri^f+Q  f׸@Yrfv2ơps^qPf>ȷu^"w sU
f6ķPxiu6蘕}p; u0qtfry> t YQS WЧ}f Kk	XA{ujuuCNCf  fVpϾ@ u葍t u3N@f6 V蔍u^ u菍c@N`R\p ShȍtE $.u:t!rv
mpj *
]]f^hh  ;	`h  _ pVG$ $  GNa P P  Gh `Gt1$  G   
G w  $ U   0    %r 4pcT]                                                                    PoS A   ? AO IYOO 2	|vPtF X .	˸ f&q && f" Пff._f.{]p >` 6a  !ŀ.wP Wf."""U"" !I a
#
{ 
 f3ۻgf+ QR3t 
tw ZYJ;B;<t&<t"$
tAJh;B䄫荱M;B%T? u!uOǿ<2䰕f]
 N] d `dPQ3 Д7y40rdr
` r`f<0ϊ$W _T*u	 E 
yjt)Ӏut&  5& A)u&u#
u! À8W@ AU> RtY pwvMuG	0bu< u3uOQtru1 ta0> S:u@.q8*6R:EFu LE0 }0PQtTt̀t߀wEtL71F -t)> t":& t߀Su EP$<X/3`C t	 E>I@q u	PXu᷆ t>pX랓t#%yLEQ utuCt0c)	'r!q =p
3o +x3;r.Dv+W+Xu4n32c*u!.7ð-# *q!	 2a<Gr<Sv Ê,G߻.#$]˜%J u3%
<.r "LuC4 %.n2K#0ʠrP)<.t<+u
0 uθN<- " uJ,0r& 
5;6 e11B   EA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xception 4 - Overflow!5Bounds Check6@Invalid Opcode7 Device Not AvailakblJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12AtOack V
3General otecErrorq  1 =  System Ha!Pst
XÜPRst< tZ@fR]6Fup诳/vP	ύ6{艐fÍ6x 6nfX[b ſ6X`6O0Ǎ6E1XY_WQP62Qߣ)Q p66F
0-tҠI]&g¯v`_}lp	i_ U%BI I?`60,X[Sm6 p@P m* UW.:f t^3Xu^.V.f]w*VR`ރ| 拴  t.Z^"P .BBBX$JJ2JBSQPܰ t
褃tJ 蜃Xu` Y[P V tA&q JZ  C@A P*uP= ]Xruŀ̀ W	
  (8SQ2<

2ۆ.
$=2rۆqd<w0
u@ð  ` 0       м  G.> vߡbZ[r t
t4t p掊e&2撰5~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~pq Q pp		 0``0@$ff$
50xx00Plllbll  l 0|x0f 8l8vv ``0```0 @  <<f0 0  || 0p0  x8`̃ <l 8`;p  x@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf`bf ƿ ΀ 8ll8`< x_xp$ x0 փ Px ƌ2 xp``x 7 xa"x -0x|`` Ep W8l`0
Pv!`lvf0e x0;`9b  p  !4 vf' 0|004-p!)*`2
6 	p&0d 0000a1B  0 v
q/˱>Gu9f SvN.
n2[]Q
! YQ 8  ` PRS%o` +ð ;w[ZXf  A߳Aa TAAE eMA9Y.nSSK  At( 3
`3ҴqĀu N <tD~QYR"~r8r~r
2:6 v~Z aP 2XPCI01 ISAF%-V YD03COMPAQꊙ 08/01/06  < B    F10_  Pi؎ ^ Ћ<V ^+3f  i L!$F10fPfSfQfRfVfWUfUCES>Y  fB  fZY   tY  t MstpU@p o@t-P u@d@`tڰ 	f  f   tf`   t
^Q @@  AfZf\( 3uq 6l[< tf3
@Z>l[0 Z j]>Z;\ `\f3A3"P1t
 }   2 1@&b@`a@f >r tf` f  tQEpYV ^ GP
]f_f^fZfYf[fX[fVP#3!>\ t
"y	BC$su%&\fXf^PVW 3W 
V_t
r
>Z_^X \ɰ۾ݷرκʮϵܧ12D_D(|1 8     y:0  ``<~ "!AC=>=  r> @'Yar?  @@@?A@ &cD$	-E	I!!
0T!-A>q

( )))**LLHSJ$$J~B ~B>
y$$$@ $
 ? >""ZFY7dd  #<r R` h3x"'yP7V<DW!2

	" Y	

tI  a~5] 
   At"#1 ((DD!@&ba$$Dc$%#A X)&)`' &Rs[^̃ZbgAvijoWt@CVXeւ\fHݒHoߕύXIۑAOԃBĂeLphd|IeuN͍}JTp\FffnL`FڃMߑIOsځwE\KxuvQƁBȉgjڃymxtԍrmÁFGsʌx݂한쐬ȑ}ł񂠂֎~HS\zԕzmQ{ǑV͈vǎҕKvd`Yi@lǉ십ċNԊO_ӌUiTivI"ىe^qlC~txEؑ{pWoYڏMȍ[hxb]Kj{# - |@  т  0 ` R 	i D  Q @' 'dD ?W" 
 P '1!!#"?& p<
~|u  0
FA~% p? o  !  % )  f"	! ( 02 Ri    0

0ec M.e     UP W F  >"6>%
!` &dEG<"F {) BFLXp0Ԃ H(,`"081+d$Ad|9  1@  ?~!BC ""!B'  /!B#b&2 33`   $*6$1aLX +>=p1@@@a%!> + ,ـ @+Bft,0Ì< @` .0`  Ct6pC R ,B
ۢC@"BD!<| D~D D<P B f<,$$0$l= 2 I@ 3`<k%b<@ѠA |a  %rm  2 Q ? " !aA<a  1$Q$${a?yH ! {HHK` ?x d $PV` @@` 0!cc $2&f# `J0;@Zxxa 
c
{AHxp!
g
 `` !`E  ((@@`)X0$x|pTT T8QC7O-  
	`E0 P $&# ` g8 o & OfT05 B`$c  L $484(d(lD &1< ?! ?&!<? !!# f4cm[\^0  *L@[* R4fBoFJ@qdp1xi?|Cad0a ѱ"i 0`E!cE,1B ,2$9`0po?"#!!;  `07#	4vg 8s  [ @ |enZIi&0xCGP(Z/cc"d{
  zzM@^@40  #2Bb"6T$-`0|p.x3 G(i@@` 0pހ ߆ ?` 0l@MY@0M0s``8xbv' ?HbK)' 
H%0#$ !"*229Hi)""?"!  f '  <p$P$%)*$ $ '` ,!## 4ED`@/$ !   BxM)A$ U\7 ga|"  ""
"4"dQ0O!  0|`bsD% 6s &@Ea! 3?! @F !dF!3#:~?;>}>; r?`8 p9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p n%8 >!n??$C @ 1bp΀8 (~l =Od<<$$$8< "***" /"$'$&*"$" ? Db2b2U?1`		
	f?21"`nд `U%2%?' X p $'!E@ox pǌwc 1$&? l@ 2?$?$?bVVppTD`$ ~  <@ D=!<$"  a\5' '$'0p6( g!}@  q6C  H2`
8h(LRN2$2q2DRD" T@""z" ""sN0 
CJ`zz| ʂM@*t<Dtd,%}IHT! ϡ[@AjDfp P
 .:23V!&    D81< @F<qb O=$! @~ 	^`/ P"Tj|>? @1l?jk  3C1(ff2/ =\  | %~j  li 	b`q0@ >)2"b>" "~"B"B>B"33aH  0DP;6[e`}  ) 4 `22"R`2   @UF|Ctd pUD H G1$?$q81 FD @@1#f~(3H2~RHH~HH `~"""6_I 6q"c  2"&	$  c2A*b$?AS%aDh|0  1    wQ_RuL!3p    7  "r0 aVU 01? c0ɟ苠?0S""C 8o`ÈA a d W>sP 1π B %z&6J J)6  #҆ژހ   0H@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>z		E@e%f|Do2D"DvDTDD6 # a ('}/`z" o7 )fb(? 8ctp"}  PpP? ȁ#}
( H k =K0{4РSO  @aBđ=  u4a8	  6 a	`1pp	  6 P>TЅ  pVL D@@Bf$,892k&	aT%@@ BgB(@Pa]1 pxPX	O 4 c!!r! 3"&,0@ġ?0blP<x @ ^ v?$&҂X 8|	(9H ;)*;*$*_%+8"e aRa
BF0L 0y@ D2"##(#`F~TT5VdV!ocp @a>b F a9$i?$	$	`  vx%` 'R	0`
JIC```WHJ  	|!W~@w_*H  K6cccN8x d?~!BC  G#" e jj0P0o!  8&CW0WcCf0` ?~$BdB  a B
BB~1I8"&D$(-( (B ,!1	8Hk
 

=I H<H$H$I$=] @ @ŀ 4R$ze US R !P@555 `6y0 ;6@bPgAwawDp! 3 ?$$$5d$Dd0R< ~   l ݀t  $D$= JGG^Avq! 2T<oDg/$y,(8p(lq$B0' % @ d  H4b2C"cy%5@ߡ0lx<D?  /"?(/(/(hOX wa@`\A %+\ 	ppsD`  0  ""bp $ & "  `c@`?6@M
3iF>D@e Zq@#opa(00of?$P?			?R" N$m|%o38"5U QHU'@S8 0@,yy {	z! p¥>""	& 0">f` |sgAA@ D=  =  2 < % 28= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$TdT?DT n%%">?R $ '$!$34, g A#A B8`nU w$&#f!|ࡖ0i#!`  b6@2~Z*\*joI0A
 PpR 3 `00 B " xBB	 0#B~5G ͈x RRpF H0	   & 	  &a K$# 'kooogp 2`zsb0AB@  F>lxPXHL0F`C0 `<0ʐQ0b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`a8 ?@@DDD! 0!cN 2"$"b)) ?()()~?H!!!aG`_c#40G zRs"r7 rC " `ȄV(  fWWkp" ">a>>b 2  "&"cb@	"00P G  x   <10K3?S"aK@ (! ~I	))iIx	1!c @>~"}`"b>2л
  >A  ;z ?A5A  ? `H ? ?$DX0b)+*{I#F(en} },lbf?"#
 1pxbj|  8 70 S#Q8#C!'8<
`NS`'  > "~&%,?(l)$ -S耝Q@ 2!;VR!q #  x p  "**~*B  h b~B_$fw D0@ @A`#p`$ 
Ei[  ~  O2R2RR 4Bb.	A4[d02 /w" u"p  bB o?~b
(LA68ɽg[]CppC}8@Tl@ l$5?b5d>qc 	()	) ( )H	ߖp `c 5_ 1 aA#?~"! "2&460ba#b @#D/ ZS?!#3"y$G! !?! #! ! ?y@wp7$   @
0y!K! `֜s `7xPe `T@$Bp8p'|"@Acp>'$ , ( $BV@b.F D !ss	\3
D(z

@ 
~~@<$4 7 a  p }#@D"4&0PPP``? ) )?)  ?2"/y1cK{PApP	١ ~"6qw@7  "r"@  ( gd&Ik	? ~!<$d$$$%=6 c`M}R  Pp @ǀC# ~
D@     ހ uUp cu`U  `U	 `}@ ..<3S.:3Vhp 83  [<u.<3 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.23` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VP < t	| tL^fat PwDXMCÀt	F- u 2 4.>A3u . 2 13 `.23&1 u2CQ2P Y*2Ȱ&P aB RDr
.B3.C3PSR  && Z[X ` Op@Cp
oo._6l3FF!.W_tOT_G-p
QR.683ƳP ZwY[X  4"2S2OsP2 sP
XÃ <r<0 <rp1@D3  F3.&@Qpu'r!	F33o!a0n3.>l3P20X2$CFAPQRW ((_ZYX. 2.9 t.D3BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>>3 t3ػ@ .<3G.>3r3OO#0.<3.w>3p<`X@Y 0..n?3.p30;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV> M> tj6hQjFV^Z&  _hE4>ЭQIWo1^Z% = ۘGa	f"\fff;
]tgQ	h X)<c@v Vv_\gáj?X#ނX%$>_	  WdJsSX:Nq!PZRZ'f>Z%j_t$Q$&`XXӚRPZ	(a0$JDtgUE	F"
C"1Hx)#45SDJ "$UPgZF ڲ9:9glbiS>P\>OR2
~p-6/2y "\$\. 	zl* 0!Gx=Gu{	?Mh2="AUr"'DPBUG=F.bg]H1
Xt;j9;IQV= zVYjQZ$-fh  nY tTtPZt	fh "Z$Z:tjnA49U1	tfh?LB`0 >
t][t= tO3>[ tjh[VfhI u>A*
$j hZfjuCCfjPsB1t<a&\ ta&\fhQ ] t1+ ]C	 	f3f
ߍ~f PFPh[hD]"rAsQh腾!3F``HC>=#2hR[Րnh R[od V022&~	hH\4?ƀBűF3o]G]Aa		AaZZj6FBhXFP/@ Fjh!(Ѐb
	 #Z\h\@pDYI $S7hZP4
SZO^0=k5%h01!1
0! VAE1~*hPih
EO	dQـ,Ys*iYA^_ 2FF\^ F&<
u3L) u&*V&8\tFFP9 1FOuÀٹ F FIuFn"1 F*+҉FV]+;u;uà]% ;Fu	;V@á]% *2]@9A9nB.A 0
	
 WQ` fj h`S:C-{ f f0]0o X&XjLfPp~]j֠PѺaj ߍFP{
`F"AbcPBV=ut_ Va @)# GF|ǯ 0n2
|[& h & F GP	FNuFG0:?|7 

UyO.4`WV3 #  ^&@FG|忀 345 "1 ! & FWRA`'Ã r16H!F_ d)lV!! AFW!	;2  1p ᅵr=
>2!Ijbf?X#rq5$
2&_Z%  `Z1oꈮX

&B]GR_"\%@ +1 1B]j]R(SpP\ `b `Z
@3	#*&@A!1	r9F uF3FrqX 18C	
- "`P	 c`Q2X%RX1Xj_	3X%Q XjrPqQP[Z1ja e`h~ 3z++ZjD"-h#3!"$E"H#
Q &
(C"!(#
 

$
H"## . s%$N"%T5g'*i)d/jS+|U-\4 Zj~B06!g#ZZw3Rb1p x dkt*!5
 77A:Ftq8a;_B]t"yk1I;c;t#!zryJ`>j>Zr.{QA	"
&
߂R0+0B6QZ&Z'V&@^Z @PJI &`Z߀ZQQh ZAYrWW 1ʂ|pR
Q fZ0 迩Z t}qJAN`5cJd5c7tAo7X4p^P1F̌]^F  iF&F~
rk Rd#h!@Gkt#@Z"Y9`Ab%VN8Zc'  'V& &g[?&[ &` &J[N^௿]@   \Z[@ ڀ   &\S reʷ%!FԑB鉠	U`E  p  Vߋ6 ^aF@t
.tJ[ e/t_0uY&[[ [ `1] [29%P t" t 10߃v `
Z $Ur	60*U@@:U
q
q
a tzOn
u#Y[>Qu̡ *2 V&0  l[!jo]Z+!r΀&ZYqknVBP*EA$.ѫ'Z$0` ZL  &Zwj.j j	 }j B7vB 7#rCF^@d
9%vB&D]*&d] &D{]~5&E +&FC!&GC^&wD]d r̞ [hJ `7Q~MBJTZfK@J[&[aFVT Q9"$qH\&R[	s$(YU*q
<,0=.rvR[hH԰+quP4[ [FH\R@tC}#]a h$	BjgZ#RZ	3 ] ra߸`  c !XS,I20A2Ճ22ZM(vgZ\	j2h01 u`
t%r" A͋F^Nr'~#tp  u^    % F+ C)pj^   ~u +ËFV@ VF4Ƃ4~ r~t` q~uKFv
.u.~ uWt
ƆƆ psyV_sr
z ^ ^ApaM~  f# F FB F~P|v^ KF^NFFV~ F@NHtDHtqH P 7?|j
$]`^F&? ujvނAY@Hm1,([!9n& u..Zaj:RXV!<A0YvhYwPi@NwNF@/}\v 'FQ5]FF{P]_S^ /GFPv4F?]FPiP'1<kZXPdkZ9Z@g4V&ǯ@236@B@~2|FtFʲ*QW^]
6~ʠ6	/>#2 _/FFVA(FQC94p&~ t;F4F2
z u WV~vN^PA@S
!1@
;^_C
"j(c
l`

P)r@pr ,md(|WVvԋNsODPTHD D~(|?W~(I0Lt_~@u"rH#}H0IB^F&uW} *
 
.pB9W!u@##O fXD]ZgaҶ&
%%		 	F*+Pg	}`	
g<d-UWVv<Ё~P F
&GFq&'k*V~ʋv!^PFGIub: ^&^&8t #^^}j!#ù
 0GF N% }p,-Ar  ~} s԰ NFNy+;u0g03ɋFrAFC&PfrfF ~hЋs;G^AaQFr ~
vДzA~r
CVV,GV~^&FIa&a8FؚQ2?^Z% 1p aRڀ>d2IGbjf?*XӮXq	= q0q3$r
2&_Z%  9RrA	oB"糡Gb"\%@ Q"\1$/\j]Ro h N# -& @j	" ׮	c_3X%Q
X1Xj`R
2_X%"/Xj"}aP!PZ1RZja"]a	T (\=_3q$s$ZjD s3	E v
QC		H-N.

SU a(	 g"AiR$!~&}
3R	1 jyQB9**z*Q,,x,..{:.h f	E#2'#$3(273Cp+ 8&&Z_QZ"f1f   R[f	 H\Z " ]  ZPi؃02~& 
1BZZFr7x  VJ[@AzSFR&JcS#2((Bת3~QڰW ]( WVv~ &F<t<
brF*;X}7ށvy~tF&8tFu|t<r߭2QdV|^|u	A(|;Ð! ~ vPfh#  xpuF;rF f?* F p F*N*ȁ vFP0'``zv
u+\^F 0 FOuЅ]"f\ &\vt&\@q0` ]% = `g*pGRAu]$<  2]% FАu! =o * Au*&]3Uqv]1w]A	u6B	= +ɉN3{]33 kЉ ^	u&
 = uP`HBaT
2p
u/[&	u##			] 'FO \\\\\	\\\
\\\\\\\âBπ>Z 4L[>XA?X6 6 &=  t0_ @3FtA @ "+\#-//

	
88qu	 M7f6Ĵ &&T:V~S~ t'jpF@:I PR/ u#'j |)qZt=?3A@ >
u
[&["[2W[1p   t&[S1`u\ À&\ \Zڿ\[!^"[0#\\[]Q[XPX XZժ\Q[>ua[h hB0h Re轊菢p2r@buBrhz[NjA4R 	'"	^		

 U޷		$ 	̢	r	IB		RX6VF&? t5`d(u%&|Rup )u0DPƋV@RPuFFRY efjfh 
 fhw `  	     jE~q~@bA u pc&PZ FP>`?)t j 93= H/=
td-
t]-! - ; - p  r= M - -  -  Q   8>ۋ  &9w&EU 6`  VV` 6Eˠ   9~ H Ő ;p(!0k
f
Pw>~ Kv&@u?PȰ^; @v_Ĵ 3fjtЗh  <$ p >Viǟ@] jWvV>~ vV0*^&.P^ ɀCP% 
P ^ h
 h  RaNF
+F@F !vvo} 	F>VNFF@6 hbj a^rCFPNQ=`*P``@fWVVW  3 3_^e #>V8` S!F
F3>V@ia.
#
;Fk|!% _F@P!]aVvm`NuPaD/t&@A#Fb@QF~u< tot (ur@7 09@5{ ݾf􇋱}F
@tuub~v*VsA 
Ɓ⸄*} ufU  Vn֠']ᮃ> t=`ur3NFّ\ ]/NZ&8tG[JvNً! ^GF
@Ftw^ G`֠!ѐ+tp
뎐V^% = @ʃ@A3t`߰ߋߊ@!A~;wWV> u#3
1&A *;tsr1A *
 bF
tҕ t" }`fh 
#O P.B@H?Vu	T.SEHDMa!E`.(EqrVu`5 3l	#5d7RP3>>Q XZ@E~38tC8 up0~?^
AQSG0bBJN3~(~ {u j X F;|;YƐbƾfUVNߋVv<%tF` u DD^ù
 +¿0NÈ u0+	oD
T:FD3d^向R^@VF!S@bVctQвO;v~@K^F&uOFf
b~VV}   m+΋8sgvf3a[ppN&8 uN`=w t&@D/P0fh ЗyZfh   0 s?6 k+IQ^ĂyYN*d_!vaqj oaYA8V&щF3v~Bv0Q&ğ`0Za
;~ANuv piFˁ-0  Љ
~[P V \PQ @F`~ ~
~h3ҋ W2`t4]PsvQ \ 	yGWubu ^Pa9Fu
!w1_P0 vvO9~FV`#0Sv"F9F}+F- P@!!u$Cq_(mFF`/Tb" T\QEP虁DPAaAP:|Q!0fh a39> ~jy/Z`*9>u	QoA@0A/\&76m);o
G;|2*& P `8]A	FqP{Pj  ʑHjw@V{1NVRPyADAQd>a2?$ A%@Ry!i`EA +F+FQPa#
д0A S L;aDPZQE"#<&5 O`,+F+`M*2cQ$R@'P9=aD=F3@*ǐ*A;}Rv9sV O1Q@Ƕ%g*@F;vw'P4_
IR14Aa

uQ#aQC4
edpuA84	P
V iBB&-24hxXtYY;}`=y#DȰdf&D&Tp3p ~
 @@&Fި@u[]@ЦFtdF;u@Ɛ]q<ЁN bPO;v}Avѣa<GF;F+F-	@pFF&Ev;v~ Qm~ $	;FfF	_F	} t~0{Vg~|tOC tG\'F
t/*y F T9F}\LF? ;F~AZM
~~2G+F5p%&L
q DF_F 0 @вϠf@`	Pf@oPF^PVWEAgGT2s|rxb<Fq[0H{&v qSFv.!Fڍ\Β #R@~ɫU 3'tsqF+FJFH鿈fh imaR( tTX,T4+_v/`.9~ 4aFePl`6,+F!}pvu.@Z Pd9 &OC@ +σQ.+ǀC
0|wctj[(Qu
pZ`yDB.=0a"Oj]1nhm0 'BPaQ !!a2#$QBC}PCf\pL@>\\j Ww 
Ht8-t-9t- 	t "fޢ 	!QF~ tfFf\F@F
Pj  v
u} Ӌ1pAj >PHPVpoa
Ϲ&wucstBPQиN	VV2~F
ta.@D% QDrbَQh
VQ6 B t~Du33!郤
a_؋!bG C `DPk+*. H!Mb9>u	 uZP:!vGg	R4õ1xiDu(+Huu @uqt j	jfham	"	P^	S^P7qf~
 ;t

a}EPzU@ ]2FY m DVVjvv{xX> 6G 7]3?虠PʢS390	0ހPr~#FJ10c@UPͩqE~
G jdR[;807+$ }p  9]t #M#/E=/豿FFPFGdpg
p ; ;NNNQPL @C7/ r= K = ;  -Pp---xА焛MFj  Uk >@]`{ P;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` l`0a~9Fu
VVIVF}p9vu@PN,PN  PNNF ~9~};V 9vu< uN0빋v T` 3MP Pp & ^!VN;~
u逐xA^F;~maXS `
$~Du6@] b;|qT/QN;v}O;Ǎ6 VǁQ9~ u[FAِpL倰 9v|GNI00%9F| ~-A{^&+^& '/F'302Fc731vy߁V0.tCq uw^ GCauK  K .f#{9Pq {!ohb"rVt ;tt D@m~3tf4Whr
 +rး5@6LWV  Mc [ tW\@ @ d l[
ǫttALDrTau0!O;F~ Ppف
rջN@uOp0
<|<7p>R[ u)>H\ td>] tl >Z ttZ ] hb ĝ ]hpu"jhXh@V}
j(h\hRVmZ |d [hVMhZhV= V-z
 VYhV
l#@VaC%R \3%	|^ Z\#% [% Z%	 Z`k"
 
Z Y l+(``+(^_Eps= Ht.- t'`tF-4tc@[Ht- t4AZ/Q#Hjh5pt1xt߀D/ODpU*䊇uDuA*HЯWvGPVL>t0<@v&=Sy 5U54465245rޤ65n9ht^@j h	Q ˸ (.	s7Y P	$MaJj h1Ȱ"Ћ^3&~/tC&  v&_8 u@*C;^|ӣ
AFP9Qk@]э1d^Ц? tvN~ _"vVY߃~ upv@]FG&9 uԉ~i0N0~FR =  -
-mꃑ!אRZ0 <5<<V<s<}<R<O<`<Q<P<L<M<G<H<I<7<S<N<J<50PәI-
߄=\Ð8:(!;`3C,"u+~M 
0 @
( `
 
} 
1  0$PpIՁŁ@0$PpIwNtJtytsP tm;u< t>]j*w^@0r~D@F	ǷF!0    t":uN{j @괳@. Bҋ u
ޡ)jcN3w~* ^
ފ^&8u	F;|  b܄ܐj	蟐 P 	/pыx00p=c4
Z$  *8fuZ_j]8_~u@qE	tP3oPF |n FP\`
t)f3f_ ^fh 륐j {h$WIz0v*u @g3y`PGWiF0	!	*QHt  L= t	Z@ &Z饫 ݐqZQu}	7 b	r	z	 &x	&	h@h	h =aA4B x	@	@cDtp{	@5q
&p	`Q&Z&?Zd`\o\aW"  !VFP*^ `	@W#'*"%$$CB^FV^ W^4$ D~&C~A~,A~3FB~
A~{4	@,0z|#ehZj2pj |	P	P0f?sVxг0zbzW$Vf W $ ` t&	} ;  	ME' +%bhG@		) C hl[j SpC2	CV%  P_R^B/ 

$*PE$j40/05pRHTRrRVUd&t pP%3W


.
bD~P*=	@-|骰}9t7-
= Mt%
- Kt0Mtb`Yn= d.>Zp~:,2@0`  8&V0`'ՐR!"Ր^,20`  PPWu/qU hh SS  9XXXݼ 	(Y&ypYd q=W	ZZ_	@4 |	!@ VZVZax@Vfh~h ۀRY@t&
 
@ ACCCƁ	л	! !	@ZVZV	$w
r4 + (# +-+tp*tcm`Kt
- tu] &3\& tGu quhVhB
h h!wu
j8%A&AB
磑#'$'Və'zÐj[u@
@A&@
)3bPf 2p6
裚Ap>3+>8>G>E'>&!>/>'>%>#> ěP蜚);; >VtThzh
	&Vb
 j` &Vr
>DWuDWpqzaV
遠&b
/&rb  tj
A!@@G>
> 5@Gz
8ACD0V?&"@EPWeD+Ǚ#
h @вR#u+C 5 1;uVE3cB"M"M@%M@tN,,"С,1pCDW~`:qH`	6\t|3ɻ
Pi &ARr hR/L%u!jG
R pE&C&@	X$Qpa!tD)V3%,aWT
wqG 9>lWDWRy}ɶ.!
q{}Eo$ர0%/@MD2w$$-Dp}4W"H$p698lJzJJ~[
DWZIQI`
fhahN"h iyBpHgbHUx
fjjGbX
=˱=e=Yt,0f*q@tƂ>tb>@>@oCor
@Dp0k;
0C iHH IGInF FwZ
@MXoFW%{&
ᱚ "[` M  2:T0dBQ$ C% MR0"5@0bТ@
UE
@r$uRP
G6՘2& 	rv$R' 
TD

~!@E
)KH4" 	l¡֡0>LZpѢ N1p 1 a1!`d`^@HXnGW  "뤁^ab@(FW 2 1 Lfb }{
@( ] fFWf^ZEWfhI m HбBf^ZfrA
_7v
v]a_Za:0!`Z0ڀ&DC<!>a? @̪DC@AԄTaa}

@PPd
rhJr.EcvɋFFPVhe~Rv
WV 
TLWeHtHtHt$Ht-L7JA+ A@3!!>=
G<4Ö^pQ@ <%P$Qy'`8@EDWG``apd5g:%B
E¤
!
Ѐ,  WVf+_fF@ ؀  FW^FЀ F FFF}PFp`_F½D== @  -  -tR>  - -*t:-~@ ߐ=`+-   vbC  - t}Qx$Ht/Ht:HAC 6  1(` `F!`"!13 S" (A
Fy
t)j pPPfsV`t2;煹h}XڱY !fFgp h*HFM~ f fFX^vfvvFPvD5FPu63F`.ʃ~%v슅X :uFG;F :`d~ t
&@}~@&pUQ   Q q t&qÃa@ߌ?"?Ht)3Ã? ? b~|b{ܧ&P	q2Q>LW uÎuHj 
3v0 R0"[JWf2f PWf W p  9F_h4Db R
JW[[13P҂8-9t- 	t #`d
=  *@fjj a
i 5	0u.#JN̐
uh оƐ>W tuqfh  P	&-NRk>p `6
Mh5.hB63WX& p  F |b r\0~ScA ׀>p#u>p\t&el6LW *hv`te3 X13
>P*u	> 0!jj23tׄ;3Be'kJP t'z:{80:2R%4;44  `@ǟ qAр!Fa"@[$
$4M*tS?=<=5
5
#.I@a	P@Ba	  fh+rD_-qp)pp$#;$ %P/0 X[XXZ X[P·Pr ) Z%  = $4&\ ]1 52 詳Rb
b
 Ԓ
 }g
P	
	B
 Gw0p֢ Dt,-
t%-.t,-	 tE-
tYt1- t/C DpʣLW:B~AI _p}}y  oUDcV[t[u&PñP [wtu
PH Hګ[@*@@&88 j 00-Ǿ0@ut%;>_}`  {PXr%_2hs`vpjtXя6 ]HtHt `t' Q {hiu
^_ WV3>
 N3һ
 B:rZ׃@HP@Fxr~ arPNpDt Ѻ&@QHPFV^tFj&ud,j,,,,,), +,,.螷>uh hPih[ h L jhN@c/"j@tî) <3҉d65P@;@)}Pr݋F 
h	΢	
B軽
R 5#W<B6f
в~}Ĳf\ v3ɉNv~FV
tut9v~O|܉~*Pӈf"X^3
GF&F 	 u^*ۍF؊F%@-Fn"	[6FV N; 3?V~&v ؋9t
G;|FCċFvBF  3o$uG

41t%I6o%|.bnpf.Xfff̠`
`.Xt&4
S4
 TPVt@2X8,bqĲB2X?t&$\$
!㲪
5 H@	
-A	4X%@^3D
ǐ%D
tF^&F!u	 Dz%0$F0&*EPR	nG2`
rcNQ3Wȑ3=B0=I-tX-+- 9=-ɚ= M%-  t!Mȯ-Q PN pN= .Xrڶ/ /  22+1 16XJ;",2  16CB !"   Π.X,2*.0X{ .-@ 3j[0 jhO&e cN}gV`/ x/  aP7@ qjwQ53D
l=$'G`v !']C؎U0fX< A"#"X].XX$ t&,
v	&<
,
4Q <
@D\U@ffhh 1 *
fh{Z T"2(
B@eUa
("HBIHb"
Xu
!
_$
@B  fhfhw
`  	
h݇@
rZ t>
4Zj `F\u`
6  O hEjˈF<tFv
7hV̓Z^tF V$!FC|ߊF۠8VͭvMǰE8X:Xu^Qd`l ]PT}Y 2fdS Y}bfY)(D
Y@
SHEiM0\Fi)	!^դh0J 1oC b_Aro	R& hB	2	lfdCb:XVyy
"U{&}$Ū54Vu4
%-3 &@+18]:X"Յ6
$
`k,"o$oL"oN"o o
(- n
- Kt W$bncn0r@san`ncn(BP^lz½ҽ"8Nd`7ak7mA mk`9k= aj^ ; ABo@ 뺠:- k<7QZd&9X\ 2 % 냐zr] b@R;Āu(C	]i!c"u)# {q (
*t {By w`!=!Ҿܾ/$ P qAbM?PZb֣sfPZf80I^Pq@qtA A]@!b0C&RD&B..eFFCt &Vh)`܎&? t
׀&^@V@^SfRC	fnD	nU Av
v@U~~C	
?@PZaq@t&6fhCA}DK^p4"6ua>>@}Ld|tlT
<fh`z^_h]P
zqpR3tfh~hoT0$"$"#h!~,@'1&lDhurgà@?Vi
x@xBx`d2`Cl稜 fxŘѠ￧ߛDp@
Ũ,q H)~Gh
q +] $] )] Cp ] (] *]ؠ`ͫ ˘ˑ  !˶$(6  @!Ǣ@BX  @[ ab[@Ǆ\!@@ɬޑ 2 L wnË	"\fH "\f@XB]$t	SNB]P>z .  p)  dKLJ`LCB<M)bK$O"OdP"GȤQC"GRIA	hX-_ÐJ[t
#&5CYAYJ[@T&Z"L$4\]Ӏ&d\@0@utW ;>_}`  rhXƿh踱-0FFX:V& *FXPeA u$ 4 j hnhQ6  t~@ N>` VFZ:  0P j 6FXzpu.&> Fjz`&N7V"~q޶XgF̹#' Dt,-
t%-.t,-	 tE-
tY- Ht=- t/>C D0:> ~/t}p  QX	@Z"~Vfv
 < ^u  8h zvF@w:tF&<:uFF
*0N&$  0
u2F ~ uF	 F
 =
 
 <  C
v`
`hjq(^PҟYE2
ag 0
~ ~ tmh^7J~ tD;=濦=u5' p

 3 FPPP!WFF9Fr' ڌF% -
 ؋1v v s0d ƨu}= w\Ȑ*6Bɋ~FP.ƞz&`y ߃~ t 5F Ta  RR F  :PUE "  
t@~dt~t'_ 辋2t"+FI Nr^߀~u@P W    I P @;FVF^ =ugF6,NS'@,,'%uÐWV6jvEh|hrε?wt*:6 f^aS ;ueBh@BW4AB-AB4AB}SAB?UgBB712BFB[9  C#"C,CDBћa
 Cp&#=P6f+fF@ @Xf e ۣX*{V^aEFP6X(( Mv3+Q OYe& t$F   fFf_~ sA(GuhhXנdPfQVȡXڙRPSQfXfYf3fPfv`fF fh  "OH`ސfFp;FvjfyTAJLd PPIf@NNu
MssbhE  p p4  V6`qrGrk		% 6|XD6\\ 6/\|<r"qѡk|V0353P.z4srhrhQq 7HX r	HtHt`sYO Y  > tOtt?Tk\ j@r@dޱ?t0Tghw&jprB?:
_Ɓk?U.'.?L?)1$6āHX+
?āO xR= V6RPfhWXfhUVaߊ&JXh.hW밐މ^)KKt&-{+`
t/`-Kt
- ta,JX2JXo% 1p !@@tqYUP0IV 0*:0l wPa(踰  >txH0tiju,6hlErQqQsu/Bn@fo:QhB@t N#:m#1^8`YQ<ш}Y4< s u ^a8@p MHz` KB01.33adrive?lock   B Computer Setup  <F1=About>  File  System Information  Display   Restore Defaults.eConfigurDIgnqChanges And Exit Q 	 With	 Saving  o Security
Passwor0bU	e4Power-OnPort Op gVariwous rtsPG Th`
TDJJiDLFsHmaCard@tHSuppP) TPM Embedde.vicPtat@$Ava?ilabil P'Hi &O&et To Fac'(ettp!sAuthenticr+&Cr}e0tial po.csDia*s@s HD=Dp3lf-T0/_Activ`  Mem
Che8 r  stalAlA35c72L@2uag9elect lDT5  of grayQ4fieldO Boo*;b!o*;'d?Built--t 5#in5Press any key to conue F10=, ESC=Cancel`JDRAcc{ep/=YesSNo F,PGyk o@#r=MpL+Q For addiPal iQ `&
T,  please ref V(>DMsBUH:wa TaPSoft Guide. UAfollowAP`stK a:`^->  SPACE = Next@2^=-BACK vJFccTABE#dSHIFTa+&*dgF2@M+= c c^J'Manuf@[r  Note ,k M{odA"Proc%΀Typ@mSpee teppCacYSize (L1/L2);Q ROM DM BIOS VersrSer E NuP	V`oRRKe'yboYQ,rxRD{nba$sndqVBatN|y 1|2345fAsWra	
fOwnhip +Ta+$(<d
O3O@
GBA7CV&UVX:%$ \DZ.   %F[^ed!JErrorjFm% Wal"00&1&High AddOline!4 +Al0nQePBp,RFlopp^Warn@: is p0 wiSllZ boUhp?VrsabqJdiskue  vckremae/!GNin *t@wR| fR ] A: 
eBd` was; n0jdetn!	N@' Uu PeInvalifromP
)toA`youޔ want@l  @PmBd%[2?FOi
`e Qs ib+-A?(QuickL22 (re`s 3 (S.M.A.R.T.)c Eex Qmin): 30#@}&g|30%|m q!%Suy0@Ppp@by ah $
0#!up46:1`'t4	QUnkno!w "0qWR!mZvoReadS)do1)4Gp ଡɐXribՙ:`w01d0a P'bG H  Old pNew gify nYBE}nc8Off OBi  `A E66vAKroE  eб mu@eqAudV
r`imodt@QImPcaus胙Ƥĩ1bJdch as 00п 'ӝNpB!a.`@!>T@los#s ൨cY@ x Ponly1KcAof agoP{03~ev  2\?ZاcGishR_ed? `f\tDж JIU"P`"TTool VPPr.$F8THգ BP fѴ?suspenRH0mp`tWASF!aqvp	s .Tcb 8SY?%3%,% `g4% 0#Bf ppnd ep/cunu=*R5#n)t `iRPInfqrāPara%xQs ya#MOediarOIWA΁mak`n LAN Ambi6LQPn  USB 1394cCb0Slo[x@@a3CD-2e [B`rqQΠр
7b!0!PhѶr uRf_Q b0USERMAST `~6pepnTp@caXrYQkeep iuaPe GJ phys0&lEsepmr# =c. `1E Kc
,bXnW Y]unk 0 lmOOAutoAcE@d@8<H<6 "A	T[t HO
JGJdurEt`i !Rb1th`U:1tw  /k edPerhfqdaff`P+ba,xossibqmaQpigiGt VK Is]pl 
r 4mmR  ru@Ylm,repla``t t( @~4]BϠԔ,cH?;2@v`me,@K֒0pWpyibPtyo. Ifdo"w6[BESCQx.R T9 Rtyp'<'sqa a2F10" qBBrm`$`/}*  qE,$ M`iBgg Orw:S Nay V AHCdHSDPAB (leCft /h !tetqu3vsSu`I Zipdm'Fir @oڐF`th ifp Sixa h )E!|NhASwap Fn/Ctrl Keys P җAcU.S дd0cLegacy
(p6y,<Pr ~pry Vo a oNTSC@AL -J -M+r`9t
BidEPP ECPd2Asize 32 MB 64a FVAlwaynOi00AC veWWAN }D Radi hBluet h@/rS;ch1A Sav"SATA N KD1CotCPU'F CPge Agqs#S`3X EPL𖈎012-d/)#1}@1NetPM KEqn`mI123TokR1 H	r m3õl  SpPSt@ TechnologyrtAfUAdap'L0P?XE RPL&MPopDe7( I0 10  U2@ 3 4 5 u6@7F9,bYF125 1I5@ 3 (Pe@-s UGTopaWS NonBIOS DMA r(Transfers VSan z!AvQtk sFa]2/ mu˂CPbomo s0 p!  Ple@e As11inb1  C dRse0P賱 V҃k |$ 00.0%le!bi4#EKrrwdv 3fy[e R ľ cycl\ o<F1=o>B/ei Si ԇ8`|OazeipgYwein{lluBeP B-MkguA.ign@epqd *nicꝁnehspeppV/%#S"hei?tsfunkq-Kenn p 2chalt(OmAQl'uss1Vp4dnpne sH`'s-ID` -
H
O
aS@~i"v Usttz!  0tifiz #  beim
 'st\wTPMteg"*tu<7}nHsvorr1$"fgbarkGerts m!bbnNufR3n zurckz!6OaB 3p1@6@Yf_g{mք*prDia09s@HDD-Selbs0,0X) A1v3;E$:pr4g < pD` =+Dra>< swhG3A 4"K2gran FeldsLrt-e; eKc>F'%Q(i`<be0bQ
Tq, um 3fahC`=A
,q=GAbbXWI8kzetT$J qN\e, JY	=Mehdmbe@9Icz f1iq\0?AbPQt KW  | AAware-cYWoft hmb PwafolXp40n KyX:rron:x-> pr@D = Nch XZdnd<-R!;ch`}t-`VoAma'GTab?ulators2* Holl2+ge:_bmJF2@
28 = ywgEsc}lEC@E-!llf@oz  uypRr Ntsgesw#igY`a"1dC@-E-Gre (L1/L2@EGkapazitt P!-@Ф -u|`אnnumm GrafikR@Tx;`gr-g!wDesk -E+2ps0Ck	?8	Akku O2OO4EU_ɠesihq3(F !k 

o1
oQ
oq

/WIXHd :u$hvQi .   %'"bDr!FeerKH`alZero-T\<One vE0dހbAlPPaxrnOBe z8 4Irq:es7 stpYb#isLTn@*  ZiEU,-/W:Bbߢleq_b@_or ATeib>p0in Lauf4:nf6
lWge aK0v/+Pt gl`OL_  `M>Dwirkl@0  qQ?C$S |ҋQdaь
aie!qQoca
p۟41 (`bn`I82 (UmfandJGrQe&fhXdau(Min?.): 30a݅d!`%C%dhe%O=wuD=oGpmp%ubr@BrG9: kan5H	xP2aUnbePK#7d4'rvo-LB6.
4C`3ShafAttrib-uHID0a3UC1PS.M.A.R.T.`%[0\BQs GNeups@N Dead§ cusaJaSЀ3F/t GFal9g0?AbAfPr9U"4YbIdanDurq<as pesSV  'mg?qidX!
fQF,L +(  dsrPtva. s Zh?C6Âen>lust.hb sENAnu 䂾@,iceQa@s ,s`&؇! Ц B ha  crgaD	 :	 
Wۓ? Um FunP}zu ,' meFYjHPQztectwTooSec@[ty Manag:3v	enoЪ"?.F*c1|'QuickLockSunId01 &PrqMPS.!P#,$biePS0Übkchutz  |.Adminyo310h=im$& "+q A)~+ H* WX"d9;P#, lsგv :Qm0%I J@cpґZ1r ot-Par/e v:-]$p 1!7Wake-=O0AN L t~  USB-PF?1394-A% : C<Bus-S@+kp ExpБmECD-ُFeej#MrvV: !n %3:md"Oriveb/Fy@ ABD ߁Ɓ]E-#F\s m \@GXunbraobar.3I#T
h,7bewFLsP ^a",itnc)uX L.0eQ, r1h8\-E,  ҭ@qɠPcɐDn<Az 2³V3^Begriff \drautomTx~ X76>BohlvE?mbedde*V'{}0E>Zw@knUa8@n 1f&`}%2 [~,B bme n 
Oquf OJ#L`СPN}a!sf!UsfemSv t"<sEvXcAߢ"-%fnPDBXfgO!gE`yagubT'`qSūs t	haa$B һR 3#B*H@w  mZursprnӝHD . Esdrq@empf.ч	3 d=qzuA1 O5$`. _S Е 2s,. 0 9򵦠Q 2 ⶇ 7 @a-BtDenԧraI:t!cant Vf4dibsc-!&Kk&p?l kW
!'o'Z@[a F10eHrh:v m`80 sD l` vMuBayl Q)IU
k-E! (links)Qtn"-2abSuBZip U12 3@4U56 7@89QFn/Strg!xtPo%dEaC W (USAЩf-ZePr B@iebssunab/hng`  Dr Grafik-Contr!PrimSek¡ Video- 1gmn4Bidireal GrUs LKf`ipCntzbr WWAN-GfcBluetooth9UnBв/a EgpaNݰ SATAeDualcore-p LAlaA!s!BAkkAgssu6!%(hs0ha}CX-06(o)u`! ֥E@ V7U 1O	203,>To\R CF) 2{}1nAl Qedpp  `hnology	xLx=0
adapQ`p0m2,zCA-!ppoup ( @.) Πdau ԑF9,qfF12eZ IpC IOS-DMA-2.[borayPR5nn0kr T-c2gP7ch emPG5d0c l` A.DٗePЕ` Compr wdVorRa3omRloЎB AThQв"Acibp1YbʲCtr`.y00,0 % abdFcLFe rQYm QT
jA|^	s Zufp{sdM-Zyk opstn <F1=Om> FihSloOplysV< эne Gt`ar$1nUkonf@ 3gn\r nr o fslut Ar 1F
 u]akg m O@nkkd AdN#kodr#K!s\OVp ?hPstilЕ!9h``pp `  qcT0-id Sq	/
[SmL-k0sfwGoddel 'af 7pdO_  TPM I?ndbyggO""'Re
c0pg0zaT  Skj	_ Nu i{l A fabr 0 UAst`Sgs 	7fq]hF%@#+HDD-selvtؠð<Huko1	0 ;ѩ!ainҮh Sprog VǰB 怴mo@/nedtЖt!p3q{(#ErE2B!oA=0>fTryok p$ t0@?F0R =
, ESC=AnnuCFs!ܤ1=JaNesj "O, AQ=M0Om'  YP&a@r M7Z nсSetupy pw!|du i1U _i`jled\n H \Rsoft aru` 0XU]
u: -> r MELLEMRUM = cNqX<-TILBAGEPr1Ԭ* TAB&R%wSKIFTa++zF2@	Z+ = Accegp!!jduc yǾe0c2-typ h@JHpltVce ?(L1/L2X9qo   "psbx~ipA<reviX12a-cDa@z-ba WzcBAri 1Ze2o3o 4z@et-taejи15(=at)	OA3OWITvS :u$ T t .   %YN] ly`!9f0=mis`w 0'st`bD1I$jPQ tnjeaqd!vard:7 DeP h!r sl!%alt`tP2L_holdUAXo Q`/0Jskab-  `NxZ\(਱ k1kyP,Q 
v A:ܒ  blprfxfASU?gyldig/
ffraWAltm  ngiAvrb`Ú n,!pavi H]un?O ic!?@ K"'1 (Hug)#(Omfde-) sl + & (min): #30 "8ٟ% fru'df`"7nsřCqv 	a_fbrudF t: K0Т&Bd!U9CSx")C'$ervo(Lsribut: IDt01(odq?QyY .M.A.R.T.5@Ay1FpF9X Ny  Bekrft nDeaCŦ Fra aAk1: !5Ъ		=P@spG 	0	ry  -k0me, K	Z`es, f.eks.  `pbܑ apntific	@ǲSHǅ< bTata. Du b!un  J flUleQmZPv@	h DYC	X?eD0pTb "A($:ЫHP  tectToolskK Quick pauLssNmus*SkrpPϫamg ,r0GvƠt hTAdLitori8sAa1,$/`H!'#qno0Swۨr, odie ubilpK2"Qll p plr;d Par|ivlash- 7@POQJm@@sΡ04 USB-e o1394  CoBus-sloExssQ$C?d-rom-и cY0BG H)oP2:Be	Au䵇Ahy1EW@eǆ.  b+BRUGER-w OVEDADGANGSKODEN,:`\U aldx@Nus InBi ,opbe /P0S 04&#
{	U8
E# l nTL_AJp\+hjl}pPAutom0DdEPJlejQA`TfSfu6 perma`anv^B>ig. 9}Iyp:,'fys!!1cArbAucompir.`&EDDLQ, tN
s   la+EoplKni@ @ukW#E`Tm0,1 D#-Oda_   ӟD~t. UrdSm pviQ"x0l/cl rkoaӹ Bπ/cY   xbefa=l`<krafna?s, Ġ 'Bqˀp_ pladЌua}
$qD  &cP.a# v"KpCRr1P8d i`$HuA
ybQβ.ю0:OtrgESC. 4`eC or` 'FG'B@e8@F10FZ 1Nsg
j/c`D+siek  Dk `BrЯwgnOIprR-#|pIetkLDS@-baz MultiBOay (Lѱ)/%hS)}floppyE!c`#| wSsuSbTziprFrЏA1TredjFj 0e SjSy2W Os Ni ̃ Ski@mqm Fn/CtrlԱգE lw(a:ci@sk)?pegeen`UQst0!
udPnPŐ"rm-cr Porim Se d Vo OuX얠¢ Tj`StrL@>1ohuko nэ BBp< t6nr` kO@trmcgt WWAN-Z"spioLBlueth/A (trdllo.netpP2	@dASATA-en ~vDu`1Core-CPUArS0POi Э UCmsty orh@[V".00top !Q2b&2Ethqt 1K23KToRR H$L	e+	  	c ="X*ёid%Jv.popup00k"{(0.89,!UAF12[=!-:B@[b*egrP;pza~ BIOS %_ DMA-r :b2$Wa ( pa@ttF )l <{qtCXc<qlu "= P(#zproGcesAaprl.
e00,0%
DСo=dfejl2sfic< Rlkrcyklu  figuK;masiil`qi}nasjonVDP HQ ´`퀛o4CkEk1"DA Iv l  UR$,la X LEsFgr tp(tQ)@)h&A|PgKZqmBB#tPb (	5-xۗfunk Sm JH` vgodkja£5+T{PMpneby HatusitЗTilgig
xobake?fabPtO  [7a?iag{noVkk A$"pvt  A0սY' MbTЬPbB|_= Spr H#el[ Tm50BE >pndt &0eln1h743Eury$T ɱV2Q13ᒳ@=!,=Avbry@a BA pJ=aCNei j0 p&=M`Du fa*`v¶ ħlysacbmkS P9Eipl. i a-Q>adokum`^"bQw {b```  \`Xv@-> r MELLOMROM = NQ'18<-TILBAKErAn* TAB&&ySHIFT++|F2@	-= Goi`#o  odutatb@k-mllsegtyp  hN#edѸcbuff(L1/L2`MQde ; 
-a-y("up%TP@YQr0}uS,QkobsABW,aoKTA@@ `4@`paVs
b=brPC E  >	n-%(r@p`bkJoaoAo
IXRX :$Z.   %\ ok! FAep3R\,_i  "Wal1 O0s"-h1jH w Adss пe7"Ve Pn0 3Ad:  !0@Azholdp HhGa "/he-,pŀJ@$ sPA/kl0٢ḣnnSp؆ҰA:e1% 9b ҪregaWm Ugyld"Dfra6q	`)fènEt hxDpZtea8en? k0caF ia.te?M  H.0 1 (uR ) sl l(p): 30!C`gr ~% full۰ ppmvQEa}Qf7:g Ka#utƖUA7$c%%0Vo(Les (020!+d0trib`:7 IDv01s=PS.M.A.R.T.-f`ÎE F  GӀ#Ny0Be0ft njA%vo g P 3q JɱmP m v likt `` 0Ý2Q0aeaoka@qA3ogs$wՠgliudaempel`Fhΐ .
QZ/B"rQ
a=p. br ku Y  $mP Eベ!&`vice.`uB_?ed(DФW 0QI  
H i HP tectTools3curity Manpar.'-N$l@ lanq6paPpus LsRѵm9Sb&!giew besk02AuR+/- +ຢW%XA  . vgl`p]nosh,"x@2=$pQ U. K$RmEaAs0ord- ParllkwF/lashiPPia LAN Lysf  USB2!C>pbus-k(p&@qxp(S wCD-г)c[: HoW2:eG ЀilgtPP1E h'oт9 b`BRUKERHOVED-: GN umu @7VEBi+I12be Ⲅ@ \tryP
P   %$6D #
W,X`A 	'P7Y	 0; 4,OMOEBvhjelpautomED!Lock 1!byQWdVg PhE`!0oiegPd.S  Øf b rad=PB$ՠC!-or 0C ?	|@u/n(P.&cJA1s 0@dda~. UR2nomm PT2Q@V0YXG 
:iPne0a:# urWP. Vmnbef!a{2 ө G	Q/׃B} A0k 1Frד `<aoo!1raكI7$0%0s}0A!Xטd!ans O@Ev
, QPяESC-Qx1 Bx'D'- F10Е[bòe:iĶ o ] 1NoriFǋOrwe MultiBay '^s Qdn(vee) Юko.ngssba0hhyO B}w_ Zip-U
Aq A0 !ba@Fn/Ctrle E le(USA)e pekeen`!el` !jwermtroaVideo0@jp
Tis!rrbp0F3ViA7ti` `ၙ1 m`zYgradi`/trdl |t 
WWAN) OOHOHBluetooWth /-3ft mи"1	SATA-CDual Core-pros@$
bari Ag`nss sty>i1Z k.1+-e02* '(vp,c4b/!<@1 Eth́u ?	n3	%3 `'qR1@N&s 0oo`o/
@BD#&KCi2; G1
P`lx9XXC ($uEr`B9-,\]F12-[DS*epute P@FpR?BIOSO DMARr pGQP!ԡ^s R TilQagsl قE qsQZA!FC Ȳ :KɃ׀F.|RAj00.0%pll@A
CfFe`{2vQE5Xk f`[sykl`r ConfiguraGci0Gm`adora <F1=Acerca>rchivoormel Sma^qШs
R@a2PNfdo`c	bfa9 Ign
 ambios y@ Sa A
p gu7  GFnlepida9dA@se|K`ciobF1p'osis_S}Iдtific  e "}!KskSumKC  Soc0#<)o Secty `sPM inc.da EOr9b WponibiltegofaOc Цc3ِ8:1fbrp)6cnci@]	cDiagn@co*nprueba HDD!c0+OGV'Memoriara)+mPPkap/+,`.i@; 	JDD`pL#= rDamp';coK grI
o:.o?mW#i>H<p&g,rim "nPquiqfec0]GinO =,A=CaP5l ALap=SSNJ1"X, Coa3	=MsBv"fy0obɻd2xei/10rav&P,ds6m sancn~SetupoGuXwadoft .S U@s:iRk0Y y: E \ o -> = Prxb+dReces<-y/, AB S	3*# Mays+b#C+/F2!0910`tGs0 $b#$vuFaI@Fel[)\35ΠA@lo)cVUGuWXTamaAlh (L1/La2 OF chu$$Hsǐ0 Aomeraribh,vil2vqMrܑ9aB\coplamQ'`)@/!e .1
2
3
4
2s
qlQeboodEtiq8 r@pieԉ
4I+K (Mabrasoo2 oooo4oj? pn:$  Proban:up.   %w(rssfuErrpQa ;l3l2Reo 00PX1'	lne®d	i]l+
(#Co00co FlexAd`:W EѢuir  BeǖQ3.Chcx /6, `Dsc  cuA: fTUu00P| N2qޢנ!련
0S^`vp&us"(I$<@ԈJ0}o(a) PC!@%w?Xoe il@ 5
~:1 (Rp`]);2 (l QF3 (S.M.A.R.T.) Clòtie&Dej@R(@?s): 300 Vg`o BT0%0#Db f!ȀEЦ%B ip0Grrumq
bH: s,pu@qIS`>nh7Servof |40Dapoya|tatrib`/: ID00abRexws G
X0Yi0"nuev ZDPӆ ApkagE&S`ֈgOB".		@e@vocB	bl!ala 
0 Lt!ad ;>nsaے"][֘7 A*# @\aŋֶm (025o,G1a!ipUs OF Et(?LLhقr0p}S"If_ Glཱ9al' ol XnjAPievjv. qoq  '{v?dvWapaAu9ڱGHPPctTool )%6!EQuickLockQNSuspe=n! Blo^ratAS 6""`nMmeja@<:0 +-y	(BI	( !)(P4`0r+lg Rt0,"D,0XjuPizQ,a. ̔xHOre' PunC<  rojo%!lpWCMLme@7hdem Ino Wake-ono-Lanns3luz | :g	s USBE
13?94 RanCbusJEx0:s{rd$qGCD-(
EeQuc.ChUPr:aPUsio:a@uWjd` 'di>DriveA0!@"( tUSUARIO2R PRINCIPALѕsoe l&| ^aSman] p 0. A; y gu ,@~`lug3b  2phj1<@mpg.p6.Q @d e`lGS1
!A=bDvab\pF. U 0"hoau bmch`o@;]HmbedudSityBI Wcinb   lO1`Pn@QXwDRnAd@w( R0Dאhuhc}y#tngBn ,X@lΡsm%mu@teboo`qj<N, !{osBtQ#bŽ! K!=b`yJBu׀[D0aAL!Kcub`\t! @ qШbda`?%k,b bAg gِ7Se roenf 9Ed 2lic큠܂ refaz. &?k cu`q Ͳ>Ainҟ#˨2CtTB"fi @[`
@|ܩipons2u9`, 0iِӲ ESC. `P"08b'&e'  ,F10@c:L&2sqfМ  7CT/qEspaol OҺ`uMulOtiBaBNPb|pxOCDfMbbc9o+(izt(jech-  by`IAEʡSu@xr
kdZipcme0ᯀe TerIo C 5t#p x SOv NoLŀD Cј>us Fn/ TIngls (EE.UU.)!aWӱlqmppl3So!~ele $b
b_ a"Ac@ PGְeo MoPu0z!  Bidi<΃ Tam`&C!mO!i#	3si0fuЊ BSICAHRP1 WWAN cor1L Bluetoot	hA
ƈ1{Pyqhyo#ergQR ()n SATAPUnclepogNMpzbaPsu`	po0o%srj Ƴn B7^B(s!3ior)Ethet, NT 1$/,2/L3/Tok0R lOPOr123C{qD2bl21- Arranȑ.^pB?`c<U_D!:PpNgŢPZp PaH@F9,m F12OJFJdpJAmbTouchPP o N`u@T0s#r DQ DMAdBIOS L~iL5_@6d}oipCclez½o R4 lPYPersKap|2b`<t0Ps8`9.  Aأ`ѐaLa aPO%;CP0qacℲui	<N	  GrPs
$ 00,0%rletaC H AE Mg(avBftFCic1cPdGՇQO֥  <F1=So/bre>`Uru[Inԇs*@S ePE`$G?4padr0(ˇndur3	sIgn0cr ``pairs+'seml'Bv;UpQna nhD`adgOp㰡ar v0~qsW/t w(@_
j
&Q$St sd⑅O&p
">  TPM Ib`'V`KRn`*6_£S7`cvAɏ
	R@ -U<54fbr瀫fautq  8I jף1lj0[a >lagnsĠ%TNGoHDDc A۟ VG~rDe Mem pPA8= q@ -ciBu?S'ele+is8 8ampoinzq]`G4"4o?>	VUw
!x;A+C% sss kalWtin ='ހSC=CelAceimNAKR, Q%oup=OMais^ Cob\it]t
Wa@vӁ10,sL  seeePSet[up!KGuSHBwade Sofit UizPIsqgw c'r u$@0 ->
PAO = PrxL\<-QBACKCEpQ#{TABP&?SHIFT+ 8!(* F2 	O-: = k  9n`ULgTQiP1adsRbV9cPPas\fnhr@he1/L2Ԧf>a ROMAs8 s N1BWriXVReviAn 'm!Aۚ
OBp  4
#cEti`p mFj'(E epson oo.o	&al fd :u$@B}g.   %o0#foi a v!0'Wal ޾Walkq 0 g1i	alptenekAlƮcҫnqGP !ed60t: @6  4edOsac0*VDò/,|i um vpu: ŊOA: n@Ad N S3`p@ jO"Ca	]
 Cv@և2ztaDI= kTctߐeja $,C?0Ё iӓN >ߟc1 (a2 (Abgf3 (S.M.A.R.T.r>xecuqz0(min.): 30<%andA%?q=bucedeA@xp!hostDCRr01#: I0~ss-P $Eg
CheЧ(*armesc e l %Q3sbPtrib@ɁLJD`0^!Oa xa`Ls waQUUi!g:Trg$`rƂl Ls  ѫLBaiPArr1rDig@АsQgp6 S%`GQS o%@8modCs5>  faz rArACV QaQRs, rigorosa (S"9pcurity)`4ҾrІAfJrPusafer0؆. Woq~S]1l La o2mrvios.S I1{o`&qZ p+QV6?eeWPrpk
8nS.e#QuickLock1Suspenso tD¬$au ttaR  1W%1n+ mabpdP}0b%I GAd 0XA,$"""@.2PL sa giUiS, o u3seu s0ema@ExigUJr	e)PbO0SP <0perme@$BQl0r5F5h0dP&re`Jam"rNs0Xuz ambi|Qn$s USB139SlotCbu&E
xHssY!@GCD-1ԯGkP!#Fm1e:dZ@usuAM: Vocc0qI" rҔuRxo0DOrive-W WtaqIWUSURIOJbMESTREi0<P ,@1?0񆼓D``apazB Í. An6X4@de-pA$V`is`I3ıEp. N9v@ev/w_ ,!` LAiS : bB*vfa Ldef[fa5B.H'7{ \ &H. />JЍEm?beddedjhoB
e 0(1Usuvz%"pnEuo,$I EBpa%g,mߡ#́k E]RB:a1)X5n   2xqu2=Sip`R`'"!d^ G0tgP岋] afA]P@,@`<aF  4oPPRea-
f ࢊSRcatp{F sub tudC?h&3+p-l BKy2XLs"AZ  Lembre %,HvQ1Na+ÔbӦ
@2quiq`mpe< ESCv`^%`  Р pA$Ӽlavυ'g'QrF10.rb
A:Mr*TaAcV]S1a AAugus OЏѺ˖: Mul_tibayNd4ƉD2wp2܈pbBaa baPcopld(`RPdiAtCRbh
zipriomeir"rc QutO„v ߂cim`InaтAs Fn/CtrlCIngls (E.U.) iVQPip)si!1Ay SQqhpౢ0troa8CRߡde`cund a @h LPadrBiQTahOmem0OBys;empy fubw F>@{ecF0CAR 0lm sWWAN)` @ooLokBloothkAAnPڀ(a/ EomCEnergp= _CPU DC reg.rp.AWa GereA1ag$2JceG21v9b32o57suЩ`070Et0+netg	O`p
/*3/CToken RingOO oSflexR@dapҼ9Aa>`hS@PopupW`D`y  3F9,i0F12*9L duplos Vsar7Na NSumV@{s#!7ws DDMABIOS@~@es o{Pop䚃lez"sbl Id0  PGersqM!Eopag1t RT@xq s<.  A2eьqO # mC PQzA
	
	'R"P
$ 00,0%lO	<a Erag+`| oif Cic0eatbA0vTi Wk 9/tukP  <F1 = ja>b!wJrj!lmtQt Nytto v tu`kP PP0 o
%jnsMkon @lh` mup	 @l0!ta Lr 
 tallmat7!WT^Tpou] aurplisuu/Pan m1Kyn1yM k La@tt8%M2@
ila.f
pusnume'- 
t lykin  "'
$ nnu`kiG
' TPM Su#etC0&T`Q0vy iss? Piil's1e-tehdf3fG$" 3t$&j
8ߍa -in`s'cKi`05v`
; 9O]t$0k @ Ea5np<h:m*@G;Kieli(@ePpk Nc  ha:1@1/ (2H..2'J"2'C#a!SistgNJatkm	jot  nppV =$
,=jD@ơ=Hyvksy=KyllEi M, JokuJ=LPx@XY KatPA#2-[JDte@o-Sohj[ oppaa`ko+``L.b2&aL`3se`avmi ->Yi VLINPPINdSd[ <-bASKELPALAUTEdeN!/ÂrSARKA+$#tV?AIHTO+',F2n+_q= 7eQs"11ajw'io ]ASyyppRIn cPgaskhV<"=1/L2#>~qu  ROM-P-vQi%  -@s sarjaa Vi`N.dst%abko3jpp)0` `)@~Ak&01:b2o3I3o44m.hq|  p|y0q.;(jCoa)
 


\	(Z:e$\\`^a .  s %_c lNzp!ivirhaވepo3i Walkq0 -[1Yloso@QgVaihtoe@ `Zuvio^'mkkeB@̀us: T-0lG@T6!patvnhp s. J` uluoxpzus7-  n,KuirjQonc -pA: L"  ei
pvu{ C1 1# 70A^Vv-ǺHko{E@A:n?kS 0r`  ?b/i ((N( :2PQaW3.M.A.R7.T.Ar'ѬPi(mi?n): 30
%s x%Ld3 Is`Q pysљi30ke ]V8-#voic
b%u( ;K*jServomoott0g
Lu7?ma*tutќ@aka-7ribti2`P01@a 6` KsetQJJ=:hUusi Vahx`ba DwdB!2A"+p2ua	-Êk䂁>p r/ v y4Nk@smys`TPU,,kn v	R$ۡ!˩ ˀ}e T  	a
@p2 WUOOTjWF un!nu߇!kyselvelpahtum`^
ZGzabEJ /vii R⮀7HP P@ectToolscuqger -apu3a\.#6iB!lQuickq
Pa hiirlPVA1(F ]raU '
((Pek`
U$i T)@xdAy!apypzyh p؀ ƣ8&#5Q sen R.ad:uuA0|	ASAporK InfrPnR~P"akkais q |"khm4emE5s2lhr ` tB1а<@USB-"`1394 nCagrdb ti 
LxprlCD-Ѿ-l((ąc3wQ@%Pc:`߂TjMWAiot'BsWn DeC-(uD4,)0$:.P@O"`' KY?TTJNC10 PSpSANAN,0f"s"8m.raA- Ȁ(`ltu1r0Qm  ]kaR00bՀ/sir
.$Vn-`P P,~	p㖴u1wLLAgU0nuOW5yJ  op}s %V su`mG2?E9E,#tuHx	>rr$ Y
 U7 kUr
\'~UrsM. NykylRJ@`+RKw00bE,n8|
tpp`Y. TxtU Іذ$ãihqeyip=Puper_D<eh? IP@a*?-v@@f!etHta_0h=c OAojAaiem  wֆtz. єV qym "3 tbTV@G.2 !`ZX{AF_f0уPĵ e1vw@ o#\Xc#3,aTESC-nsRF;n,\'%'A>!F10`Y4aa:	o .VQ llіx`tЁ Ȥys uBbn Mult7iBaOpc&6 el miluU (ena,/$oi)q䎂b)aZipEnsimemr 0BbKoހelj@}Vi }KRie!mְKakp Y KymȁaiP Fn/Ctrl"m(Eng`(USMA`UsP s  a!ҡ-RsѬ&nAjDBs CڐPs =Volh8pq kio	s2sNc0Jgf`uu`ґH Dl Ѥko WWAN-roHLOBl]uWoth @/F@hA`Lի-sATA- @s Dual CoreC -saFaAgpU VP@Ws `?P}0AGe@b 斳31!iE\62V3- 2 (ylosP2OGCO>=Etherp(vn9E Yoeor3o@Tok_gOoxH workQ -G {8E޷!CPBDP0Br7 Gavu']>P `i@ (?eoI Q@'F9:`k:p0OF12:i ZPatappiqkoskж)mK`i mjn BIOS DMA`igedo\`>otf uhd閡!p"Dpo>o Nope  gParaMuQ Tț2!w kki1 `Var`b6 7kyt tySqNQba uho{c9&㐤Qle$ 00,0 %Qiuprhe taxtark S1n1Ut  asyklipConfiguratiordЕteur  <F1= propde>  Fichier Infor # @. ,m/Aff age R1uGrer"
`sЗr df*as c	w duGIgnc#mod1i t	qu1S7pe l'inP:auvegardns{regom	\ Scu k8+`e 
:Np so$@s`a6rt		frent @NBl'$I	Dy'A3
Fq SmartCpUr)r * ph 6  `Ӟb#Ea +3seTPM F	ʂ?gre ,priphP qubDnibi:?? Masqu %)#H
f+98am+>'u l;?&,?rB"cMHta ?Pc)PsMi80KActFoVV mmoir`|cDN`2D! !ILwangP ChpHP`1Indu'|@mps g, 6dp,rPU X
Z\a[V#ೌ4G>+ AppuypCsuC goucPipo P[ u@b=Slepo r, EC_HAP=AlgAccep \0=OuiuN&#Q_, N'imQe@WepvD
=Hn %PQpЏ00ijlP Sp, rez-vAU0smpr jMa lk@ri QxPplog{ic s. UPWq3ai`-f$`  - :-> ou BARRE ESPACE = +d`}u%IE>prece@\։eTAB`C*<'jMAJ+iXF21= !u-#!&abry0MocdeuU ab Typbu KsVv@XwDsbi\TaiQ'ca1(L1/7L2)lu DvztFD ROM erf"Numǂro3^P#
Rv Evido&qp8rlcavq/0yoc'auF"	qbpe	1/,2$/L3/l4*1iC2riCtaQ[y/(Q(`6'te)q?v .OOOoOOe MiVi :E$aqqjl.   %mrussi ! Err(q#up ^c;/Walk0}:1lig 	d`!uQfq*C	7od alлifSg@ Ati70tR Ca;epPrtru}anpWpni1r&PU`csnQ /PR, z{  LP c`	da0r1;A!]4av
 !tro`c
@ s	a_[Ra'"J.@On m: XfinobiEzcP"ai2{lP |OO? &@-M?ep>1_ (rap`)?2 (clete)uнex0b0im@C(min)C30`ss CR0% 1m!vD;!l'hA+BFecrrqF: @Gw	bHinnud'+,voS7.Lu( 0I?Attrib!vQQ: = 0oSpk"s S.M.A.R{.TAbanGXY AIZ N!=aPY.@7/.@;saςCЀ	A`rP v 8KS n';A,(frgcoB cc 	oQ;mme, vz"I*re4`ʲT	@Ǡ^Μ
L`a`S?pe@a@"c!s@us1u@?i_B ǏV.
,r0bPdpGLla pHs.Ԅ8z!%pa av0nou TQ$irb. gy	 	֑ `UL'Үfonn1Q  ^q>#l1egaQP<A!hHP PqTool<ey0r =%:/_& ckLocksuspendb~Ű!ri; E3?S^&ol' ЍcbqCc8jM)ad@fnur,  x k3//v  / L'(Aa
S$
ud!v
 NP
dra+sy7stinpqpQ`ZExip)Q^@Yred%Pb2  4ra Q8ll0F[flashrߐveil"appel rsP_b%a#pi`ambi0C	s USB	1394*(n$C@b0<Ie ExPss d CD-'EbpalM^@Sү:>?&DɎE Dri;ve2. SIIx"J%Kq!dez "deux+(UTILISATEURXPRINCIPAL)*#N	xФ$aloriX*% N`DzR a`` O!!xP,*tsr biffe9celu/0ՓDordi 0@s3. AubY ZV@	 (`{W_2o`z Ifetc} |E@"0t"	~"a"ɣfa""!GoaopVD [D""eR 0ݑ^N)eFFSan r< `m5#'kH
Up#!2//r,B=ϻ!u!  3`a!! !!{e`VW
g%uPRn'R13^ :Hpҗ" "" #opa8uE b#O'}oW'aRi+hw#1orig[inIlRv`OH2Caa B	u(
vqS"apAQy9ɗt0M
5dSjavs[oPbce *-$WqzaPprspʀ ע on: toQa1ө440-pPZabЂt3㠥k
Q7j,a|uyPK `  ECHAP. hTzR'o', p"CraDF10Tap0SXр1x CxY^u}	Uڢ/  FranaOgrAC@tЈiMultiBayul U R.d2DX,/%socqv'a.(ga!)OOFy)m	q7Q&Wp
jZipÛ, : D hi :@s QuaQCinpSixi Seȑ  Hupd NeuvCD`Perm r$(s Fn/OCtrl˓ gAngl0SA7) Pph@ o1ms{ A@3stanp6hnNd'00adml!trlS'Tich@&m`
d 9ilidopBid/1 mm)oVl0@1j2EKal $Ӳ R o<prйWWAN ( @0il)1gr
L{Blooth7Sk/?1Po`$c0if @A&oPldoyCh;ar rapДmCbaSSuG ga^u r0WPfexs7?1bloc#-noCB2ooyu{ @	=ccuodogMB Et* 1a,2t3TokRingo to/EA׵Y:b\AmorC<=5 RetpZrTeиec)0J F9,pnqF12.\`apos0fJixLD aP?tD8CNA
cunXP;0BIOSm.QHDMAOaQ4 @T䀡j   jr R6 Zs@Hs va6AsJ$PH!Ԁ\fѓl6ѥVnpk QJlapA3c8Ï	нtruV	4»ֱuc0@ơ% 00.0% aE / I Errv@~2cfCy0m>żalatQc IIpmzl!Nlt <F1=InSfoi> )qemagi;suezzayRipr0 faudgř0` aIgnocP*! ed ci EP l'i
`	salv SQx	etupar@ep 7ssw ҿOC	[ens_Op6ֲ8Z ID'` ID 
@h	# x%Sаt CO Supc8TPMRqgp(S@oƣRvo)TniϐIPto~he Nasc04
K	)0w7p4i fabbrp98	!I3Q2nzib#([?caa4`$Rai
 qdi Z(V0R(a me qiAW @`=O(%IDL`}ue 0$DCim@L6 r6ansso  eA g@vv!G7oJ "q DI x9*aѾpkalsiata$qak"u   =, ES?C=AnnuPaADt]eo=SiSN1!T,altr
o#	=A bbBa PӰP|`u!{ SQS,  v]0XpYt=h  h!"~OGuida sdwq\uoft . UsQeseguGeAun'e:-> o SPAZIO =suW@vm<-pBACK&CE@c18^G~ TAB@C'oMAIUSC+)XH F20	.= Xm "A"I}e|>duttoAAllo NPboo@_Ti
1VePSHStep	p!MkpԐ/?(L1/L2drBD@CROME#a  Nume(aAڧ	Rp=cV`p'4roqI2"erMbasGagganAcA	~Ba   D4bG`M0 PY P/ Mpcѝq(&Ʃ(G)H8	2
3
4Md:$ Ttjzg; .   %OI	upZ!·0EoHm|lTSprbbit 0  itQTdira	U T`e ['vFlopp9y pnso:fD=ŀgger	 "`uTNch`cA_punfS/rR,  8 -qmfavq f	P q_'u A:, UA:@.n  0]o ciuANJ I

qQa N*l /YPIOy×SeՠRvoMgu t?oiepbRFb iwuׇre?oҠp: A?051 (Rap )62 (Clet"uti o ():G 30>%B56a0"3'hD5 @
CA:3sB@ᰇ-l'峆PP¤(DB-%Aervp̓")L,!0BQ0'	 rib  i0goel:01NR7anŠdeg`Yi S.M.A.R.T.uT0UHvecchfnuo 2F0`q(`#U#L  1LX?pbi)	dʲA {@v! \Ⴊ?v)6i% 
 iAmP+AVfA	SaWa2>K<Cng0M"	t砶`eq^ЏQm3Cee,<L#e ~'.!R^@FovoberdAdKd@ xEfif+!Kizsoin`ari9qu@^!0`vgaO. Qm 륺 %psnJ ͔r@~uQocq|eV1pϡe HP tectTools &/R2y `
ick0suspen3B#\0Z mousп8 M] (X(fO#A#Ъnup '!oހ&F0`e$)B
) )@C4t!`Psm]0vaa 	,'DU#Sari lQNR<(| RVa0  aQ)ǰeL1`h pashmgnASQLANn_u0Na!	e USB Slot@rdbus@S ExssbBo GCD- S@&,dHf^pp:_C!S`3rqcusanD e.. D>NCX  r]V[l'UTENTEPRINCIPALE  r 2 !;a manq;fuŀo.o\VNBfkp PzYp_@A)e1JDPjBPP4. l`lPaupUSTjrs,fh	pu0p`ao@ sb2C:re$^r.!T  6TAgo`= ! qQkrG@H!ty,@",d@(0As!jAs!<πg!rV!luog 
Bw 4"B!!GN a|t ~ vNA# un"G` `By#2дsm f0u4yjC  $"6|!o!ӍPZ4ap !)"(@E'Az `DIgPd Bip  	p 1Чp`^lu+{A+u %af$PQ Q;.,Զ+C0B4w0quR`9"
!.BZ)`z!BFG@ n qPq0d L@!RCh,m0"qo ESCfCN'){)dov1r 'Zfo'poRmnF10.  Jk+zst` \wT AuIi 3  O 1:sAp\ $eUM MiBay bagga0s$") ogCh i`B 7JQ$SurkcZipPP7oPP;Terz POvN@ec AЦ" Fn/Ctrl Tx fIngl I? (USA)A@Yi`uO mpl B ?Legacy7pl 5a  Րx[ BidpH|ACapacѪmemq0YH5CqsbFa/l@R2C10wO0s (WWAN){oBluetoot}hCommu	Z/ (J)Csm energ`anva SATA PP/rapi bѿ0aq*08$`icutցN.1 N2/2HIB2PLa62(PF o)ol4spo EthetWJ V123e Token Ring 'OE3 AV   KC`fT@U7b|QRQq (@#.)SМ9e`F9,A_P'F12PDْ% Z27CAC`\Nu@Tras cSDMA BIOStE<A s2puQab V RPpxc~oc0tuq\`Rsu.  AG r q comp08 EcQgIC<Qd𮢿cM CiѮtru1	Ӣ$
`&fsuo0>$ 00.0%!P "a Errrs<xBCiclBupAmup Arkiv Sysinfothc]s~ stllfpn<ardk5Łenuka nd`` ochsl [5  
 an0l) S_? SkerpsN -l`ȢKAStPv#olik@yrCorn-IDJa`/
t @ld-s5Std fp, ͎!Yav 7 TPM Inbyggd  I s!usi=TiollgPigDOeaPl(fabrikP#H,Jsbeh"%bsktsagnpi@SjlvtV HDD Akr_V Mi̀4b)a#t;  V[ljПrDx C8nedt 00-X*'ck=Ar2"@$!sX0Tryp valfring.T nu Vps =,q=AvbryD ;aFD!bp pXF, V=M`YQ(2Pg om"y3S f s`` Kt Cc m i M?askin-MuhQb. [MeQ(ljReUxP5Sdu  |DD: -> r MELЭSLAGSTANGENTEN = NuOyg<-BACKSTEG FregeyK TABfa$O  SKIFT+Hr'qF2`),?= "geOwAh"I@tk `, mo7Pr,' ty hAhpugCa-rlek (L1/L2)=d oROM-0`um>GenummQ6@0#<43b i0VyrsRBqW9B 1.z23d4cg0RU1
o {ian/ (@ `;
bITS. :U$  TaZr.   %EZ!\@k!ðClmisslPades WalBg 0s - `P f1jHr Ad=d s lip7]Ae P"n#`W k0E@ar.! DhW܀qstti=dQneh' NBJC[skaUp` җ/-4Q^i skbN$рA:,`ϓ
feaouIhеtfqISpeskydd+adawg

*r@ifBW O᲎npp5o  $?ϴ iд?gRӵF0 1Pna#bbf`9n" Upp  d kR&d }(0): 30~Ppgr % kl06`2Tpp3ьvrd(a~t48:@.t q2$	AOkB'S!*1( eorvo-L lî, |r*V&`|ttributo: IDz01Bnskҷ.M.A.R.T.-5 G` gNAyVa߁nAv. ? LD4Q Ra6d 0Ҫ m!М0"m krvs  tGؓOmCBrLؠ?k,`  pap321És t ex!I#S@! .	,_ŠTa F;s&AlGlo. GOPm  Thpglm3Adtj`eh`:els#e.!1P `uqucZ`=ǔ3fun\Юkr  ưAji HP tectToolsF$I	lQOuicksv7elge Lwmau GHgk
gbhB)`7sadbzi p&n !!!+Pgo"Js14bliWan`d`pt. K7!SomGip 2"`f `"P`l o Flash-9 sS3enBom`=Bljus USB-qbus-kplats ExphCD-s{ T(Sx HuvudL An: D`1 q{hrda F. sC4qB abr ANVHUVUDHdlPmavt W.3aP`H`%PQU`0ild an-A
 *MNuUhxp@ L l%upp <-l!TQ.A] Po1 _TX3 5bFBbVg@8<glng\xa1!b  h. !na LAcni nD Sk0hsk @p7c
@Edim	 
sRG'-Kx_@ktupa*pt,sojnnsa PWuqmмutQatg 0rs+b0\QZyP3yurpungd0APO. Vi  reko @HQmRF	c	6D&rn q͢s`b. AJT 2l3Ag@eB1gWA!7-be0zfPrse`vm ih@qofljjnso. Tr  HESC-tuA 1ܶ>"fwà23r_'B'9sedtF10Ui2a:c䧑sh~ڥ Svoka1 r: D?, M@iBay?pNp[0Bg6h Ba  (`}r  (haҠvawG@x_ Zip-c<FFj!1\stto NạRT VxPFn-/CtrlԠǕ EElsp(USApkdAAs b mrmsP'tro2w,ffbbel!SS`plek6Peo 2nekYlG"nPa?Inbygg`1siotr1t1K (WWGAN)LBluetooth p/() -v@ANƔmbe OSATAJ𮼢CPU:pSlad)ekr0rRAgrssBhaAB #hi [4? (DEP)C .M-1,Ĉ2Svy[,p 8 &-Ned Eth3& 0	3^n ToaRa@PNT& "4(Gj9tbrp4P 9d/sagdapl `Ddrj%&R (%.>F9-y,YF12- >F(Sek)e*ABd StyrAJPB g BIOS DMACaBs@C1۾Qg[ 1 ZmAnpap ҄ 07 זK$d)GH< Wproc@8F RӒea.
i00,0 % klEB FelAB=g`afiSlumpm Cqc[ykBen@`e@P~a@-   f>]` QѪA@& bemconfigu`Wijzig#ne`«qgrammaaq  znr wop slaanopBs`veiZgqwachtwos. 
6. A1a'atbhOgl$ ID's 	W`G!\ASm!G1C7 OA@ufv@c(c#mȧ`jQK"O
TPM Ge`N@oe 'Ptcusp%svzie2!/chikb0,he3 B!  	qFabriesks2ugz@CsVref39opnieCuw5OEec8B bzela -jfeai AcO|vGeheuP@1C "h ACgDf-)Dal!a Telec-emK rijsgema @Rl 9o  /97LsD9xQbouw )S&Drup `U0ذ{egAL=S
,=Annu@DG0=AcceAJacNWee fia,t^=M00 A`u[P6aoam ݡZ) v0t  #doCompur R]+  #Hpel9B0q8P< dw1YofPTre@olp>a`rui0Pqb  X:  -> of SPATIEBALK =7m <f BACKCEVori8j TABb	c&}SHIFT+p%S(
 F2X-K1= sa V cIk@f-mode5yp9ebnelRU̷ ppx Om@`jPre (L1/L2 @apac&i@ROM--sa enumm@d nqrevi!Q FdpOb`cp7m0u 12340isЋgIwts atj
Re'n+$Ԥ(nW2zijde
  `DKt`_ :u$&d ew0t>g . g  %%rhge17gd!ou  djps7$0de-0-*1ZTQpho BasrlQafwisQknd Kpao!pO!}Lop: ^t4Ǵqss 1ege@t P
"fb!ofpWQ A:gS>g-  /t	1TmapӢ3e6ะroffaGGoFa\.f isFd"AB@%a

o@g VanafWtpwOh͚'WeuR kuP ՜Jwil"6?@С"8"au{A?`
Z.1} a).2 (Uitw) Pe vostG (p.): 300Ae$d&%~too 6>P]`ho=c8broa+:o@qE@geqdonbfD482#@kvo-IЬsC&K2G2dezLL 7pk:Њ0hMU S.M.A?.R.T.-a~afPaSS`;ud(  N"/xS݉aBlok@.b  a K-W =V~4qkcm !A00mPVX8
 Vr!5 B@FS "WPA-ke(kunn³9&~d,  zoFpikIv S  ᑶ@AL gqG f_W, gF zerlo@G.p8 5(t 1ub"y0Hfhoud 'H : 0aP`JS̀Q% r2rfɺVHP Pr@ctToolsH)'o蠰 $S `g3q# TשmumSt_@H$M"g !zQb   erW++,Qh8Pi(?((ag( o( S(62b"f k@nP@,@Hsy&P+emXAbs K[>A:@\Q"ĉ QpP$t >frapd  P  Flash-medialPYJ Ir` m!$Aia Pnetw`W`doli BbUSB-"	1394   Cd-r  'HNQơGHoo	fHGdI?}f!)! Autoc DqLP>& C`grr#KR ]HA  
-goedL!`j=Yq6bew1 T sP2PVucomp@' 6[
aAM  n@ P'{50OA"3U1@p1 DA(  GzowPbCOO!2JzFF!4A !6,pMawAB!!t J!. Mo`/obP,P   c ; $? = 8? 5 @hui ,H̾dБw?was to/!sk @OgeaBj. 0Կ`nvlp<Bׇ Bkra s
njk;cUE0rkra>8	!6toH/) ge#t. o
 @s vN.dun
`h!LefE&aQgolq OubܱA,ͪB$~bh Q #ײep3rukx3ESC- ( A9 Ul 2T<B':m'typAw0;knRF10 0@T*pZ:KxS4ѳd '3i3X4  Nel 'g MultigBayk@tiBV9&Fd]~Ѵbase (gks)rea)#5cÎKlp-B EF`we AѪVr V Zes?IZ @A@:N Fn/Ctrl<!wiss1ʶ'0ñSta"MXNijsappaOu@e Pa@dil "-ij` 
Vo-aG0A+ Kd`dition  G!vg=uzyVilatԐ ֨䵳ppXdr&pRadio2	l WWAN-aofLooB/luet@h/oP-e
niepʠΠ~ SATA-wus cesP^>dubbO @zDl2]secuPDcu PhѕaVQ r1`ڀjAefF7(	b)fdkEtـ 1 $2
3aqToRq/-OMow023fEa7adap`Pfa> B(pp!.)pop-upsq#I"F9,`F12 (% OD'cur ݠtu2+E_asyPod-qG DMA-̕0drB BIOS #gez"g\e Saniti (n)sc 1 qa` AQp  akWjq0VgePVtZxB tijps cedu8@sl!I.G|*;`lo`\`B n!.bQt00,0% lpIGx] Fou a"ld_Vn`leke!Ecycli  Rs[^̃ZbgA` viSETUPj <F1=o W> t@C VXe Ɋւ\낷 fHgɐݒ  HoO׎ ̥aɖ%ύXɏI  ۑaAȌԂ܃`eBa qL(a
eLC p00h̲d8o |g I1v,e#6ID B%whu!NSA͍폜TT  #}
Ja 		 )0*T3OHTPM , 0)o,X"p Q \  A-/-("B6kFظ
 ؖ 9穓
f&@n1% 6B 9ZP6t9X!>LɆ; `Fq  k? qFt2Mp1<F)@H4BCP#߂A_I(D`Kp
 OPL"`
sHu2-0u"$=V#&$	8L[C]10=
AEsc= CXsA50=͂@)aRA ^)^; []` ڐ\́A w$E0!Aу\ag# K0bhx u[CySetup]vQI=̈ȉ
 gpYA'j^aj ?Le->F`iy`m|k = ER  <-3I[BackSpace] b%+ [Tab!A'&[Shift]+gF2!///`
pmF/[p"%  ］z  ɰޯ   ۾  xïݸ  ށiL1/L2"OMt 7&رٔԍ*rI  ް ۰ׂްޮ ޯ` ްwi ?ޯ 1#U2.3N4	
mun"p[As ^OŰ (ސ4Â)	c	-3N4hZB[F :$\a; .   %'^"cаj`R0!̃G[MsE WalkFq0s?1nC Шh1Up^Oet"so  x:ݱТ2bƁAWw ⥳ עB`ׂĎDHa/p_쐬=TA:@7݁ȧ
>
}RO
  FłиÂW	qX`֎~bXopsOoC[  āB`k=H O Ň׌ȯ|Н1iNй2iS3.M.A.R.T0 \zsԁij: 30נ<B% 9~ OK zC7`E~ D: @	)gmQXE3kT{ǂݨd@"A"4MFIDt01 .Qa  UU0EpDI&ܐV!'/ }2B m@@!LJr>?(ᕌ檓ͤDLhv"SDbA߼ݤtN  Ǘ߽܀|KCvQB9ARWdP;J& 粨u֌`Ȃ!WVNBۅ	db^œA"g`
Y@c)ԓi̡r	׾Ƃa7dh!f
n?b\@feviHP ProtectTools!A}l?ŒǉTs #j.0oMu "TphM؃{-EPO'OHpJ8-.))Tی삪ɻD<D%  gz4 Q(!ċNb8viq" Q ԊO Gu!~3V 0Qlp᥊_BVӌ`6T  USBD1394&Jpo!Xg ExpressCardFCD-I 4
Ud&}^ Y:'UKѢ*i  KeeC'5D|gD `qa>`2*	 ;@bE`]AT@BaleU#1B8i	@6	i"!qM	͎Y  y PSȠUǂv, )M)N/5/@`fƓRh^C`g@C@΢
 ǌ>BSd_pۏؿԓ`b͗L_ŏCk>@qł`k)/)%)@G &B:J`pwvqpbv+̒*6J OJN	(lOQP%a֯)I*  /*!j%8
F*   pӀ_2* b*))g ̬Fpo td=4ɑ`&ƈ)gO3 fR?ɉe;Ѕ^fL/)3"j@  GD'OȑO"EOCRBh r4%6f̯B&L:ȗqlӔC`!W2h?BG[Es3c]Q@πȍ~%noaVn@DriveLock t[F10> :@U   A{a=7$:  `AO:FSxuJULJڂb O xuiǶoiEcaB$	bXP{p{H Zip&1Ԗ 2b 3 4"567B8910r Fn/Ctrl'̐ؑ {_p (USA)ѡ| B#f0C}XbKV1P(v@C_7g0 `RW}dJ_ =r0Iow W?o%wACY@OAǐڑPi̧flbNi!WANj%MɆL Bl?uetootg/#jւp{dpSATAC+uUR_ACPUi b튂̍?[d @nsh~0.1d620k2o2od(Eth_ernetX 123n g P@q
AOKO3O0'O3 Intel  SpeedStepR technology⨭NH0 p_PSdް Ӱă q%9x(b) F9AdF12̱ibB +_ERE ^`bIB1  BIOS 2 DMA]t^Ni/aV,pgf 3 œKCcmɀ @|bتc}IڀKKƏ#xqKמjw00.0%j̴@LtG󃉰oH:f`u yI]N                                                                                                                                                                                                                                                            ` a b c d e f gt M         Ќ  	 
   
         v                ^ bc  * +   . / Ʒ 0 1   2 3     Ģ  % &   ' ( &    Pi] > 
$ @0) ~ PijPi2Pi!Pi'Pi-PiZ3Pi"9Pi>PiDPizJPiBPPiC <B7B<> ?ب`0`8l v x_|v||p0pc   c 20 7  =
=$$$<   DDD  A  O aƄe  i  o u  y   n$A  ﵏ EP%  I%O Q&U n`  Y'N' ~ `' ^    E)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>0( ) +)#/!'?
({[)|+}][{]}'@ (#j|od^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ?] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$: |  s+'()+'*&`83&ď

OO
\()| O276'6 -=
^~+]}@`)Y;+(:*[{s\_}\|     { RgtPiA   VPi@ &@ | ZPi@ TED  f@Ԁ&PiD@x@ I o ]Tq RT\Tr?r@TsAsBTtCtDTuPvFTvGv; 4 Pi9 ([Pi.ZPiRXPiYPi\Pi]Pik@@ ʀD@@U J{Kt|L|Mt}N}Ot~q&  PtQR[Ho 9 !
	$
 
T 
	^Pib
 H`
`
STUĄVWąX` Zf(6{&@V @ |   @̀
 {aZ( 
( 
bU^ _ @ a 7 .*  } | 8 `	Qt$ 	)D
@@*dpBcUP "bAs@Qw u`*`ƪ4#y9W  4U !Ty@7 2
#t t!\Cq  "T G0Ȃ00D7 @

Ҫd  d!!֪d""d##d$$ 6  f$&'J'((	 dI#&*>@ 佣!"!C$" 
 5 B@3Dr5EdFF 5 * D" 
@      *	d	NSx ҔE\SGz  uJ{" Ժ   EʄC  ;8789:;	<	=
>
?@A.O@&^aDb\bBDccdBDeU2e%Dfaf(DgU)g3Dh.h/Di0i1 Z
PiFh*k+dl,Jl-dmT |	^Pi+J+%*T$aM@<6&qeSO` @  : ( Scd 2jjtkltmg &e*[fd\d@G GX
hءBUe$fb`?:el:  ']mF4 :g"W h ij_vpj M<@ H N b ~@ @M"@ , < V h@ @܀ @  > \ r@ @ M @ @ \ h ~@ @
@ : R h @j @@ 0 N Z `@ @
M*@ N l  @4A  @ U" 2 F Z@Ufp @U @_M(@ @ UX x @U @	M@ : R f x@ @
 @ N n  @ M8R@ L j x@U @} M@ U$ < P t@U @_ 
M@ . UD X z@U @M!@  U  @&U@X @ MU4@ D v  5@@ @ U` r  @U @S"@ `  5 @ @ U ( 6 J@UZf| @U @UȀ @S $@ P x ՘ @T 0@ h   @$MT@ | @К@1@ j   @ @ ^  j @(9@    @ @ 2 < H Z@n @ʀj @ ?@    "@(08 >@DV` h@n @ ڪ@ހ  @=@    * 2@8>ADU^@z U@܀ S @ P d Ux @5 @>@ UD ^ v @A* @L $@  U0 2 6@:U>B F@JUNDjlpUtx @U @̀5  8@ U  D d @U @K@ @ AV\T@^dx @!@@ Z   @j " 
@ N h | @ #2@ f   @Ѐ.$)@   j @% $@ $ 6 > V@f  &a@ : Z l @ @'`@ Z  Ț @.( m@ T A @M)G@ D UV ` r@՞ @*T j@ 4 H \ Ux@ 5@+AU. P f@U @S,M@ L n Վ @-T@q@ D b  ղ@Ѐ.TQ@ X z  ժ   /o@ B \V ~@ 0 V@ P f | @1`@ 4 D ^ j@tx| @ @A&
2TU@ h   S3{@ |  5 @4^@ F \p@j @.5@    6v@ @ T n ~@ @Ā 7@n@ 2 D V @Ț 8@ d   @9@@ r  ަ : d@    ;@ nj   <@y@ l   =@@   ̦ >{@ n *  @\M ? @ 2 UF t @U @S @@@   U @U  $@>HUP `@v @Ѐ\d\\A\&AàF d  @ @B@ \UX @M C@@ f Ր  @
DH@ A*R  z@\@\\hD\\E\U  .@>Uft @մ @*FT@    Gò& 8 @ F@Xr @ȀH @ @ Z  @ I@ : bR v t5 @&J@@ U: Z ~ @Ȁ K@@ X \| T@ @L 8 Z r @ @䦀M@@ V ~  @ )N@ D l AU@ @OT@ 2 H \ Ux@ @PT@ 6 J ^ Er@A@ 
Q@@ : N p@ @R@@ D f  @֚ S@@ . P b@* @M@ T@ 4 UT r @ ؀.U @ V f ~ @R \5 @V@ UV   @5ʀ2W@@    V X8 J j@| Y @ b   @T ؀ SZ @ ( 4 UB \@hzU @؀S[@ `  դ @\T@ d   M@,] @  5   ^@ UX   @S_@@ p  M `@@ H Ur  @a@@ J TT hz U@΀ Sb@  & U, 4@<BUJ R@Zbj \ @ր  c\
@ (F@p @ڦd@ 0 >J d z@ @\  e @ 2 L f |@A\A**@ f\
,D\N`f@pv @Ԁ\ @gT@@ @ d  ո@Ȁ"hR< \T X@Uj @Mi @ d Un ~ @ @jT@2@ J v  U@ k@ \X z @l@@ 6 b l @ @ހm@C@ @ d @ 2@\n@ Uf   @Mo@!@ `   A΀j @pXR@ : \H Z@Ur @5Ԁq@'@ U4 V p @U @4A r@*@ U> T f |@U @Ms @ f   @\ޚ t 9@ < R v @ Quf@ \2 N@Ut @΀ vT @ 0 L | @\J \5 @,w.@ Un   @Sx @ ~  5 @yF@ UH ^  @U @Sz@y@ t  U @{@K@ \. >R H@\Tf x@\@ "|-@ z  К @"}@"@ p   @
~@e@ f   @ @%@ T |  @,S@    &^@ l   @@ L h  @j @  @ X d 䀻r@\\@[@\@ J@Ѐ\
 $@> fj @@f@ 4 H f ~@ @{@ V t  @ҀF`@ \d@%\\b\D\\\% ( \2@\QL z\@k@ T p T ˢ @@k@ f ~  @욀@@ P p  @Ț@ NT Ar @A~@ & H p @ޚ @(@ B z  @ @@@ N r @ @  @@ 8 \  @ @ V x  @ހA T@ " 6 P Uj@ 5@3@ UV x  @5؀&@ Ur   @S
A: X Ur@ M@ a@ \ Uv  @M @ X U  @S
@@ N r U @ M@
S@ , U@ V @5 @@ UZ t @5  @y@ U& B N V@M^  l@Ux @S@ \  5 @@ U   @F@ j U@ S @    @T@ 6 D P Uh@t U@ K @@ b Ֆ  @T@    S@ H j Ք @:T@    S*@ z  5 @@@ j   T@[@ Z |  5@@ h t @j 
ʪ@ V b ~ @ @ Ҫ@ڀ  @  $ H ^@~T 
@Ҁ@T@@ ^   5@ @ J n j @Ī@ ^   ʚ@A** * D@j\~@\D\U @S @ ( < Uf r@~ո @2T&@    1@E @@ U. 6 R v@U @S@ F \ Uz @5 @ @ N f @j *]U6 T | @5ʀ@ N f  ] @@ F ^ ~R@] @] @ B l  @ئ @ H j  @A]ښ @@ 2 L ` l@ @  @ : X v @@@ P v  A   @ < V l @ 
@ > Z z @
 @ N rT @ @  2 J \@r @@ f   @΀@@ T b n @ @ @, @ t  ƚ @>À@ j   
ƔA B R ]z @̀"@    @I @ 0 ]> UV@bn U@ 5@ ;@ Uh   @S& F@   M   @ L j  @ T@ H x  M@@@ f Ք  @T@@    S@@ t  5 @ E@ Qf ] @պ @(R]6 ]H \@J]fp ]xU @]@ @Ѐ@ 2T BZ b@R]p M@рQ@ ` ) ]@ M6\"Ҁ`@ N Uz  @ހS @@ F j  @ʀA*]Ԁ@ D ]vD]]]@j ]U, 8 L r@բ T@ f    @׀@ P j  @蚀 @ 4 P b r@ @Uك( L d U@ M@@@ P S\ @5 ۀ;@ U  B V@Ur  a@ 6 Z f n@ @@@ X   @A$T @ B V j U@ @܀T@ N d z U@ M@H@ > QV AvU @ԀSဝ@ > d Uz @M  d@ 8 U\ x @ @ @ 2 L `@x j@z@ : V x @ @@ R b p @ @j @ @ Z x  j@Ѐ @ p   @@ UH `@M   @ \ U  @Ѐ5  @ U< X d p@U @ T@ \   5@"@ Uv   @S@ X  5 @@@ U^ ~  @S@ j  5 @8@ 5  
 @ Ut   @,\6 L b t@ @ܙ?  @   ( 0 8@@JT ^@h @ @V\@.I4DX@ @j  @ @ X z j@Ҁ@@ j   ަ@@ Z  A*  \QBD\p@U @ƀ5 *@@ UB R j @բ $@@ Z v ²@U @M@@ r 5  @@ U8 d  @5Ȁ @ U6 ^ r@  5  @ Ub j @5@@ UH f  @_  ]@ " U^4 R@hU ̄ _]6@ T Up  @ ]UF@ v   }@ ](@ R  A@ @]*@ < F X t@ @
],@ N p  @Ȁ/]4@ X A~@ @]&@ L j j @؀@ V h  o]܀	 @ \   @  
@@ UF r @S<m @_]@ 8 Ud | @5 @
@ UD X n @U @U @S

@ r  M @  5  0@ ~   @"@ V l@j 8
j@     @  , B P@`x @ ~@]o 0 P t@@ r   ]H@ x  Ҿ  ]2@ d   @( %@   ܦ @ d *  A @ 5  @)@ Uh   @@ > T v@ھ ]$@ :T J Z@bUlv @U @U @}]>@ ^ h t 
J@ @A$T@=@ v   @
]U.@ R x  M@
 >@ : UV r @5  ! A* & <@ZDh@\DT\ @ڀ "4G@ P tE  Un@ S#@5@ r   @n
$@&  : Z p@ %@'@ < X | @j @& N@ J ` x @ &' ,@ < \  @΀ (@R@ T   @ )'@ @ V t@ @"*@ > h  @܀+@Y@ ^  j @ , E@  . B V@l| @ -^@ F b ~ @. c@ H h  A @/`@ H f  @ր0@@ X   @܀)1f@ P f U@ @2 E@  F* f |@\U @S3@u@ J f U @M *4@ R Ub ~ @M@@ղ @.5T x@ p   S6 F@ Z  5 @7@p@ `[^ p \ @8o@   9T a@ > P ` Un@ M@b 5@:@ U& < N |@դ 4;T P@    S< p@ f  5 @.= @ ՜   $>T e@    S$?@   M $@V@  5  &AS@ U   @+"B\0 H] UR@p UV \Ѐ C@  pT  ^@&U. 4@<RU\ f@tM ~A  \
D\" T@ @E  D b ~@̚ @F j@ B `  @ \A*)G@@ . R d\D\5 @@5 @H @ UB N \ p@UI @    4@8G@@MJ @ H Uj  @ҀMK@ . U> Z j@U @@Ly@ T v  @j M@ N Z v Z@%@l@ NT@@ @ T n@՜ L@؀m OT @ R v  5@P@@ t   AQY@ & 6 L `@v O@H jD ހR@ > b ~ *@ AA S@ @ R f @ @T @ V v  @֚ U@ F Z v @  IV@ : P Ur@ M@W@ $ U4 @ ^@zS|v @ĀU KU1 (@SX@ ^ t Ր @YT@@ V ~  @Z\>R R |ն @ [T@@ t   U@ Y \T  * @ UN@\pv U@ S ]@ J l U @ʀM &^@ | ժ  @_T@@ d   M@`@@ ^ ň  ,aT@    Sb@ j   @ c@ ( < Z v@ ? @F,b U @̀ @ d @ j ( 2 @@^@ M
N jA\x\T \ e @ X l  @ f@@ D l ~ @ g@@ V t A* @  \Sh\
*@8U>J R@XUr @U @Si 
@ l   @n,2n  qj@ U. P z @5Ҁ"k@ U@ ^ p @U @Sl/@ B d U~ @m#@ ^ im.@Ԁ$  (n @ p   @ƀԚ o@ 8 P r@ @ p &M. V  @܀q@ ^ |J  @AM r@@ 8 R h \| @܀s @@ B Z r @t@P@ @ \ A~j @
u1@ F f  @ v3@ F j  @ڀw@D@ F \  Ą IxF@ 4 H Un@ M@y:@ : UL \ @5 z@3@ U4 > H L@P\T \@z @{ $@ z  ʚ @0|m@ J   S}C@ 6 F Ub @S~ @ p  U @S^@ . N d p@ZMU@ | @0 @AT!@ j   M@@@ z 5  @ n   T@O@ b   M@4@ t 5  @(@ Z   TV@ j   Sa@ >@ d  @j @@@ D P 䀻b@px @ J@b] @ڀ T C@ L T Z *
h@I@S@\@ ^ v U @ P@ L@ B  դ@Āy@ H f A*UR ] @b \ \
&@EMT V@\~U @؀M  @ R z  @X@ N j @ ܚ@o@ r   @ꦀ@ : L j v@ @A$T <@ ^ ~  U@ S @@ 0 6 U^ @5 @ y@ Uf x  @մ  @ T @ 4 J b Ur@ M@"@@ ^ Հ  @T @ \ f n U|@ U@ M@
e@ 8 UJ \ n@U @M
@ . TAD@\vA @ƀ@@ V p j @@ D l  @@ D b ~A@T@ < L b Uz@ M@
 @ 4 UH ^ @U @S
@   U" *@06UZ ~@  @ j  @, @ b   ƚ@܀@ 2 P x @U@ h   @J S@@  , U@ N@`tUz @.@   @k@   @]@ t  ֦ @ L xj  @@@ b   @@ AZ j@@ x    @ h   @& @ X Uf x  @U @U @UҀ @S @ ( B ` l@x
J @\ @T@@ T ~  U@ M@@ X U~  @̀M@ T t  @A*j @ \>D\U\@~ U@ M@y@  UL z @ր@ b x| BVPnPPi/  /   
    P DSDTDSDT  HP  nc8430   MSFTC000
 [B
\._PR_CPU0  1
 HCSTH %p
p
 \/_SB_02p34p\/L506``3INI_ ,3{78
sISMI
=
 ! PPC_ `
9[6
12
{NaA
 t apa[#o
a
BA!C

D`0`
 Qar0{tc3}?c
c
T cEc
['b
0\F2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 710ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD1phg	gi
 '12g 3 phpi 0%f%`'?fg`f b 3f cufbc'@%45E
Microsoft Windows ?ME: Millennium Editions NT 019
 jA1+8D5p\_OS_`p
g~*.ag)`5
braQ914ua
 !D	"
6p ߠB[I`+ 
%2p?P>u SPJ2PB6Dqp@8@>1W4A_B !+8'BHC
$fpig
KfHiPE g0Ih Frgfata
apaa9aah@*ha `a u
 bbۇi+ibub`
\1M0E1DzIGI[K
0E_HIDAJ	_CRS-F)
&3	 V 
   W@W U  y 
 CW022  3JS24 5C@6py7
MP26@D"6F 2)8X 9 AY S2B pI2A@%D#O `
EB9o~A7[PF   
7,[	FQ30311	9p[
 32 3B
ҷ[1 0A`
3U4Q 5 6 7A8 j39 AH3BA[]  @C{D@3E@
bFE@[E140P41V+42l8 3*44m45Q 67 8A9A2B14D!
[07P1DAEF0u50Q 1 2k 853U45Q67Q590A !5BCQ5EF 6D?[B(62|63H665H6@(7b 8 9"ABCBDEZFa70b 1 92"74@a 776H(77b q79Ar7CwMB7D
c۠!pp4Da}aiapa ib{ab[ǀG0}27
_C _ADR!:&:  _STAp `=	
Fp
q,+808 .82
T
C[P:82 q~q 81 D30PM8383ED 84& @? < }A285 [#	m6KP87\w`p` p`bS83ewe` a}p` dpy@cCdc87
ߓ{a
 b di8U87bbtd+
q9ruR2dcrdl84` dza
/af Pfuff aPhdu`['A
\a
AL

   G
UsV`s H2y '&89 3[!6 BQCpibpkdrd
edA
d hb @brb
_
bhb%D U EF8jqDS9 E68EcrBbNC090!war^p8Aab@obBomo
o
buoatb
bP cPpa%
`bac `9$91SKRn`k8A
8DL  8Fc)EP}c92P=aaÉp`l92@24_HPP


@_S3D
p 4gD
`w93U= PRWo

i94iw @5[ a95 [6%A 
"A`97
 aA{^.h2CBE8E9G}@[I=I 
A
`
[N9AP9A&9Al9d9UE2o9dAdAdAdnA3AHAPq 5  xA6 kAkAkAށkAA qABnpACAD H
 `%04 HpfB0g

 s0B0B1b{B2 c
}`  @ B34RGjQ4 y5	B	BuB829   B	@|B	BC 0UBDE`́0 	oF	 AC0P
ZaXCW C	D0C3C kC}C5"C6
<[p[C6ЃC7  @C8 q9rCA@
[S! B2CцCQCQCFG0D0_GL_bp
`O{ S[!
dv`J`aCD!CE{h Ujp
p
H\rP"aCFbf1aq	rya
c}cbaaD1 (8` AD2x0 D3Fhiu`y`j0O D4
yhp1AA: \p6 9+7a+ΐADZ*Gp{D5aikp@"qA6`RMbA
i59M147O-+r4w8p
4E}jKG@6D7=K[+ PD8D9Q A D#D`.3DD CDE
sA`9`C
	Q  z{` P}a 0 
bw
t
	rabpCR
 1@A(U{ by"OL$F
pI6'BE0
y
rw i@H,DB`"Da{@ ` 
p{z1 wi`1{a` ubQwDFob |C11	_9`pBw
h qc }u    A12
ccFE2
l
fE3 @BE4 ?E%w@)e {ky
p;E3g} e? j
4a{` -xq5p #@b}e
e/` !@	^e @e$}` @dAyA4{k
 	P`:}qA
 DA; yp!-Ap?d1ܠr68d `D8"9 9e@~E6q E6 c`dyce@
QTE8hif"f
?j
pw쑫PEbdBW	!ba'c0|!Dby
PAS6JCTH@BIBb(p`Ab	s@bBu/c`yacaASBw'C`CDe  dBP@R`TAAp
59`z
ha-bLREA ׎!EB
k
EECED5_PSWA\EC r0&D``QE#F mFc
	F1p				!9	 `				壞!	p		9B@ 			D 		Y			N4s'[M15a`!B7#`
0
[@FB% WFC
P
[5   FD K E!FFC10 O: 1 [  2@3a{10.ہ
  5O@T 9 62o
 UДDP=:
c`7
  8  
p;e A! 10$5/10' //.D 'D@//f!e!(.G!G!@@!$3(N #F(F//M 10B@ #F  //! A eA !A N A GA "A  "C 1jX/B 12G 12//.3`03'3//a0%1a0%1a0n0a0G1a0G1a0l$J/#5(5//N 6@CG /@H @@@@@A 3T*/ C 8(8//*.9 Sg09//@@@@@@@	6 
7
wHB	PC	
#  y  Q61Eh`؏`o`
p``ί`apa!M pF	0	w`1	AC120`:'`1	0q2q 	A`vO_HIDA?_UID
$~^^.C009B!_DIS`@x)_SRS h_CRSwaCr) $ +b!Dr)H4;cEr)C 2$PK hFr )iA0r)$+j1r) 4;k!2r)7pB7>BA[! 
1j2[E8 pN2@q `<@GB [#"G`c@8u[AK8Cv1(W 7J\._SB_ISMIDk[#\_GL_phC05Bpi` Cpj Da	/`023O	k['2	D5BD:C07J2L g25ȑFȾP30
,1 31 L23 :_REG3S31 Zp` 4F_S3WD
p 4p  34  `({P5
 hq`{5 `U 4Ac
7c6CdK8
P57`
{	 }`h`{`h `	{i @
$ qS@9tҨ._DO{Sq	3
` a![^`Abb ha[u@)3  v{DCd34
 5G 7 SSh0C`bhz3D
d
3

% 3
:
A
H
O
V
]
d_BCLaDE0O@MC\r8
}b@p'p}ha`kar0Q!1E"zqS vz up@=4
 a41E`35	8hdp
` {\/<b3C8
00"`041D   Q   P pChip~BB(h{`(}`  (Ї\L\/a	MlB t@C|C"142
iBC0D4hj	 5hij 5.43
C@kl4qKaa[G f	_GPE/
	3
PPZ
Gb }bPGf fy !W45G46j"W4V489

w4AzB  C`
 WD/CG(0GP.p* P)o	i484E[G  @@ݰ4_F  5T$  1!2)3AU45617 589`5A @5B5Cp5555 P5Frr 6@ 61AW+62134 U5A6781U9AB!CquDR3s 6EQ70 p 1s 2@7!74j5677?779 A BA7A7E1F@80Q 182Ʋ83 a85 `67_INI %88 1Q8Q8A[  IްB @\8C&D!y4e5 y@ 77I78w458EAvlP"Fp`\!`c@90	wh
@axa
db`t
@` _@	
a
P@}a`1
y`j}`aR8B81x!h qazw`
d`xr`
  
@bamu5"@2~	s86w	93	
+86B`9t d@Dn6} }Pw {`Pa95
q 6s 7
Q fRc9@BSCSD
Es9FA0
Unknown 
NiMH 
LiIon G#Am129FO   %99FBh , !9`a 7a# 9899*Av]98 1A29D@4(7Bst u(945QAC@p1L}Pt97a{a
@97}Q M95!3 
!@Q!6!@"A3	@򀥆 aB%A4	bUp
R{`'I@A5
[)h`p 10`
csc
  dzi`r`a[)absdb1/2*(`ccC0"6	yЋg3
A4g
cB|!95":9F{`g`@&7&8	h"BC ?AXa9Ћ 9 62 wa$Daxra
c 
dcbpbmbe9EiEr!73*374*`a\$0/5g5$Ip4A
I+Ep
 W 	ip
q=SEU@-64!665cq7c9 cX7
{P``	={``PF@9C$>  9S2ccdp eבeez
cpecpci6%4?n1 ep
{9  9E!'E`p
`db9DA~5DkC-NCg@+񌷠N)59Q-  T(
>
>KE(P2pzт
 5 c(%*!F(B+
BB6F`*ᆨe(!1h/8C	82ata
pc
bPzch!
C	9

66a6F
@ ra 9NPQ@tupaHf:b#2h<fCi>3c3@AABBBECC [
 ADrA
HP   a75
Sp
SIMwPLO`SMp
MOTOROLAr`wxE!AE
p
0 
񂴏00B00D00eCAPB0(_Q03W<Dr`>14aY0"\B1jlPR_CPU0
 1E5`]TZB2Pt 3
 ['W1 TZ3_PJ
6|q
J }pB4
1ׄ1y	LN
1_2 N8vc#
DR5^6#9qO01169֯_5b316

,Qٯ
{ (i285iA4D8$7.u1pT1B8r49B1p
7AN@E
F
0AF0a+ Z2B C[OA
!BB
N 	qBDFBC lp`BEF +C/r 1 o2 FC3 4!5q6C7Zs 8 9CCBqCC
[ u CqCEF D0D16D2"<D3 < D9px
Ua 5A
D1M DaD4pa` A'C4`
5ºP ZD5@Ou;D7ED8 &~A !ѕc7ba6c3g9bQ@|aA
8BBc10D& ya
 rd
b
 bdpdS c
 c
c
5D8mBD9D4`kaa
vaу albab`b
vb1bC3C7{pb9q !9#y!d5zj
!%A8B=pA#'21bb	a 0WbbDR
4)B@01 נ7`6&C
3BE6"C06" p0
qD
{C043
`{  ia` w``cD6hp!o
`!`K1E	C6%hA710$b c  od}yd`xcc;43abcA`(KDF p^^C1E0c{IE1L
pE2

Gy 1^E4 ED0A	 pEEP~CE2 [BE6G_C  _DDNo
COM<E7xE86
30Uw"    }8y PwS `,E8pTAa`!9@E7QD
W+_DIS t0432SE7@
F_SRgSah
aA7EArA9+E7@
_C`1F

`  c

pz$NЁA[SEB   
CB
_ON_OC&_OFF EqPR0B[C:n)CaiEDpi`  02*E
;."r4Aq@`sE Eq-%H
1 Gxx. x" *
 sx& x~( # *o r^r_ _uH\//.F.)ppM%..0!ha.b.!Nm.PF0`/./ F1 l/3pF01/n(FwG/
O *00bPNFD1
F6F7#S4444F0s 64S1X5_5S Txpe
 FPF7'pAVrѓ  @9R:{S:+F8]:Y:_:a z]:Y:F8)?F9 p\/`P00@Badl(|ex`{UPq Y vCY/&X6"|`{0C7
DCF$f1aFBC`ĭ P,F  BFF200 Y!
G``Gpp 	   ; P L afeP1%d50y{b1 FE
q Ef 	dFjFA
2
=6N$S	3
1Y.
p
4 
5T`7uFGV]$_DSMph`||@A@6hijk1p;J  B Owj
 j
 B
 3A`ek `MZ

7 39~갓ud
˒ C|@H}@207i
 C 0  5D
` 
pY9`E7J8'4Kp{z2 
T	sB8Ipk71
 
E e^ 
N ncE/9	 Q `}`
`"?Q:%05V5b  "  y sBw@ @ "@`[5g5: 
G9 G     *"=C>a a !-?DT@
? p Gr r " E` }`0Gd d"IFE
" yC10
[C11ѕ 1@6p[Y212" {
&sޡO.
2    [+3"     xOC093214_ADR   215
D
[ 
6 PINI6[+p7u8O1-AP B9bBP9i  ei0B19/QD&9L
C0FB`WpD	
DHBCiD i
^^6q@51BAJmFBD["

un`{`7#C p[yGPE_L1A`aaAc4

D
>
[! 'E I	 
P(F BGl20a21   
0[ 2  @ P3Ap24sC`0o2M
F7FEr	a
dNpp@c,2p a}a?p'| dk2a#b023!!3$4.b keC$
	
@Ip	q
r02 
5@`1PG(J 	_RMV 0mEJD 
\.P Fm4 EE A.07O/@ 9C$$%&PM& 	aK'CI(FACELAFo30 
b:  V
 @I<A+D0
;
 
 a{a pF2FwARI.0
: !
H!"
D4
fA5
Ьa	>s
 
?
r</=
²# 2}H!2@K006`I\/`33_LID
 O
#@rq0
8
?::Y"
<xFК4co?	H
CLRID
bK`a#1B6"v@@1AI5M@  a{`a`
{`
qbb"ALRD	/!4h3!AgLWRb3hiQDALED	W.h}/c7@zC7-{7A`%	|&pMpS3D
S4p 	 VS
0j! Z@l04Un
@VVrV3qV)WtVQZ _Z6Z3aCX3_07S	
# PA8O09O0AO23O24O25Lp*\_PICPh>A E%T EM
T)p   !$jJc aHH֤ #
*
 


GC%
  A	a	$ Q 	A"p20
		 $	!	A	a5 7E%%c%&"cF9/)3),(s$ q*Q&?52!AA9@	F

NR  d
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	8A2 @ 7-9@eq L"A6adlh`/`r%
 ?4 
" 
 
k9h37P=nA	37+a1U7y7oboAha`S8hpAs
_U@ 3O\ BIFAAQN ST 3CL[_4;?;:6<ISBg
ACPI3{F?_PSR oĚR2aJ` $Ja#߀hˏAHbPR_CPU01Dِ7? ` bpb~04#o`A&aq 9ǥ9`pA]@(#pa1(a3[:
*aC8  "ڤ`C
	/15?@GSXR( QEs F

1 }N40j341 p42 434Q`kk` u`ph`piaFaв?{qp
 als }a
aap`k`pap  0,7 33/ 4  G5/| |`~`2z`hp}
kyj  p>`6b1`h)h`v	5` ibpbasabcpcau`a 47
 8 C49`
39aA `! rOHBL/4CiD  4E Fp50C	s ` p
@b P  `pr
` adP1 5250ew0p@ e[0wre
 
3q3@932pFAI851p gpO/D?SECUp0AKE1j F0^4bBϪwr5}6R7]8:-3PʵiP
ca9cSpP

A
U	B
CUbDmE5BFF@f@   `׀&t09O$C260x6a116263"64Pi2S0EB5f66$674$ (139u!21SIMWE6T____F,O52b R1JT7͔ @YF bb W` ar`6ZPASSa:)1SB8aOS6t"05cp`p!ap	 /a`!CT [TSU;C`2YC'>atb\ab  `ab ubNg3OA5x&s6Pph<piKA5#MBMCFx
q !S
_WDGD
4_c,E=DAAyB{M4C~ C+KGYР@!f )AB L\FߛK^B IK--0AJ<	Q3BC' h5L>j<BD FΘ@pEMEBE ( /2IQv-BF =2=f'C⓭BG  6dBB$BH  5MI
WMAAdijKqW4i,tqnr0k`pP55
E}| !sM'1{h
`7{`53
} $`(4В056j7EE
0. {A5Q7[
!`T-P55  62 Ge6003

P,C7BDѕИ#NZ??`68UCb76a`;{B58 5I8F 	4	Kq5w ]59!hBӯCh	PMpA0

1a@04As?a
0B` 
;!m   bpc1c`p  b  c ]5B'_	09)2(&b3hV"JCVbYa0
gp
1..=0p
0V6
2U4 	p
<
p
	A ep
c)//=T#(C.(
/D1)71KO5?BPbe m) jP;)!jIGєzyeympn?p	
?  OC
Pw{zp #& BFD z\dKA[bW[b^b^bذr[ sE ~ 
@[QmE6F0q70Q }1 2 @ 3q456A6F
R?TBbёF3
3
a	34`"5 `q	?
A`C!ab?ѱCAA2ar(Da7N&
BIOS Configuration Change 
 Q NGSecurity 
An attempt has been made to Access features unsufully

+
Unknown Event  e  typeC	_WEDB ࠃAЦra77 E Hs`q0 r C9sA8P'Tq&!'A B%UCD PA)E4@a*F_
   80`2 1!2 3TAa50K668 B7!A$1a1x11F90
serial port91
P~ (llel PE2
My asseagr3
EnableB4
sDi0 5
  w, *h6
* 7
 *PXE, RPL28k
 *9
 	A
UB
*AvailHidwden"C
 m*D
xE
F
*F1/Boot, Allow u1rejec`No pro@3sA0
e I*__A1[4OA*2
Gk3
c4
|
1%6
 0,_ 5, 1p 1 2 2 3p35B
             D9O       ;A'@	
S3863 
\SystZ+_\9 Op_9sd
 `1 9
9;? B	Infrared?	?	?	5	#n?	?	=	[I?	?	?	ex?	?	iq?CD-ROM#9			Q?}		~	Floppy			$		$
$terneNetwork Adap0?
?
?
.a?
?
	.J?
:
 ModAi

8
SELECT * F"HP_!EnumeWHERE Name='' AND Cur=r@Valu#x'Rr r2rj>OqGwap Fn/Ctrl Ke0b5Devisce;UH,	iHA#USB Legacy Sup/
/
/
.
@/
/
o	RN .Fan{ways 0while ACwer



h

?


Multib7	-ifoifGJash Me?dia Re	]o		mKF9,`0 and2 Delay()@
_A
0
0 U
1p 1p2 23pqzDpfJSt0ard , BidirЧal, EPPPECP?
(B,=J(E 
PP@CP _cEWExpp`PopuplׯXXX2oWkWiMОma2+CqRB-OPM/$\f$B?3Pp۰wdfScetSIs`=134)`LAN/WP  Switching
=uilt-cIn )C>_
_
? e'mbe d Btth%Radiop//// [//? QLp& 








W



 


+8 Sav** F
?
SS{|

_	ϕBAuthHicCKCCy	\#mCoCoCoCoC`CV.	(AvailabilMW='R??? n҇
ompc DrivelockWX */H 4\
Ptra 
 Glio(Ul+++?oo
? hRequ  P}Rest{


vn	I`D?ata ExoPrev&on	oNoNoNroN
	| ߡ+ DMA 2Transfer!s



^

	bSATA0t@pC



 
_	ޑҿ	Շ		O	1394					O:1bus Sl?	?	Š?	?				9Ϫ		zMMDualMCPUO	O	..ᐟ.	/		Wake @n 		O W	/	FހBAmbinLi{ghnnsor
8


 _
	\Lecoqy Batte F{as hargM??

/
BN??0*&, Hin?____Sv 
%	oAcpfate 0Next B?
1Ԇ/ ${|$y rolic*F1 toR, Allow us@rejec`No prompwONOOOOOOOOOOFq 
c) C2ABCO
!- OrdeRqOcPh .k =ar(C:), Floppy  erCD-`sNet0kttroller, . NYB
;YQN??Multib<  
p? !V 6Z_CG?d*^skXul 
kb
 C#
OIbOa$DB

/!
 
>
	HiA
.EJO
[~1\#2	43#`	D43!T5Cd6St76FCP%6T`d	234567q>B0NOLqssetcking Nu0ntag PlaHcol@G9IDb!GOw]nhip  tpha&PManufactur

FilenforQmB0,ProductZPqIcor TypP(*JSpee: 
2Mtepp!<'Cache size(L1/L2)qFF"emoSP!C2aDOOO!eZ:'KDi V2Q$ \,H=SeriO=ԟ-^2NPCVideqRяu8_
KeyboAph9`>AP1 _
0 
 S1p U1S2 2 T3p35R2ooB3%
Sta1> sBidirp alPP@CP 	WMBH
 ] A2i
pj`p`ap
 bp`b dubub e0fpccC280zP c uc 36D6F37979c * A BFC\._SB_C076 A 7B9CAϒed
f Neufa /f
3"J. m4
q 5/ܳ*
 `K`P. >u``
 p
u62 u`p`c
 c0u`p
cucr`
cFi_aa 47
  a
0aw
9t ap Aara

a
pp aDc d@dOdAd@ d@d
Ad_rd

d@d@0d}ya
 dd{d
dp=db e u`  \p
 g *d *'e9AAd p*7\C019!+ +7 dv bugudvgF)
	p
bO'
p
Y2sLt3z  04vb sx ;sAz.B1B4eFy/9`)F0 0000p0B()>
p
?(?( ?(?(?(@?(C?(7(5?(?(?( ?(?(?(;B:(LbWe7VB0VVVAVCP"3C7293093 YQEIMk4a4|fCKD820Кl Port Modeՠ%l'
*g6

	 
!`GggF9, OF10  2 lay() 
0`m5
У
 
	  
P0ZJ^Expr@ bz'Popx `?CInter Netbk Adap01"y,PXqEr,;1.RPL.0OHE@dded +urity,vi Availabil@ 
'%&8lp: 9#g;Hi(8?A v2 Alic#3
F1 tPP 

@1h
llow usP rej 
mANo promptsACU%Trh
'gFXLracking3SA`bap13a a4QeveuduevPb`lVV(Wpdm4ք855vo5p EH׳O;wn hip
	mPa066a uap &upugCA2Pg)1dc?bvbF-v\eaeaDdDD 2a@aP@],d  p
auauڑx8G5mD
Optic@5Disk DrivP4% R1F OH\P3(C:LxJ	USB Flopp7
h8
	@i>Superqp		CD-ROM	t@		K9RControz0 E
*P@%_R"
 aFfAar
'
gGp7:uAfӮ"pa@`@6ADUB9CA!E
5f3à%qxoaH$139{
gf
 &7Ba79`>	239
{ep	F(i
 6
! 7 8
 	
 pj`p`Jbк`b dGubuAM[cKcB$PB ^7A(D@bf eCufa RhePXB >uaparbapal`afaiςcϪ1b`b/b!b ː b`b
Ab_rb

b`b  0soood3FB7`.|7:X(|
A (&((~(oI{WQBCs1^`phbK3 ݸ @78Q b9G2FDD}
 52q 
!iAAh H` ᒈ7
/4A0/cy0dfc7d Ye 
,0* *|p0|f@AELAN/WP  Switch !L{f
z

.z 495^
 %a6n4k!r		"z"OBluet hRadio7 
2M&fJ0	LP
Nf,FbJ	  fbWm l ! !f!bN__Y,$8i8*AW:)#,7M9IAP(C-D/5Bm
E*L666663N(NFDKPWara`l rŠuf
k3fAM86ءcKvA aKD
F9, F10 and 2lay(@' kf
z7f
cPB1D
Express#PopCup3/2//J$4pVF,A2
E!0j"	)1
"vd f
*h1l`-+i2m)iggf13h87f dusN;{D{{rh
9'{"h)|D[zBB#0+7CBGpMUD8OEQFhpjfAŅC07
BNC1JpwCRDR	E2"
WFO3bV70O4G1O5

a6`QaF7q 0q "q7 q1/Bb@aBP%a[)!`pA0`
asa
 MHz@ 4!C
	FI7A87a28b3a
d esd
/ fsfegsg
 KB cpMcGG!9	9a 9 @&b`bsb
	
 
4
@4
<MB0­; HE;3<e1gR;74`; 0Ā`0AB@qpa0NG
P  eJߠ0D  g1d	gI¸8k`;ZOFe `<PH`1ie?4B`  Kp	bb$8
 LAaa , ]a"b 	\\9gq	VABVC4! agFޤHJBW@qGEKEr*CCBo
{
 !b bbC5OOOOOO@KKFgBCWXCq	$D
"sCs cDp Hs I WQABFOMB     DS }T% BGFb IA ԟ@~ t(@ "W6`Qv GGnhQ ]R.7w' `T΀ iD!D
qFt~Hp*~:ٜ`r<H  ,4"kcN
a$8%$¥@hl'E,yJIQD6'(%BX&v/ sq1ښĈ,^ʓBHhQ*L0\F)V -@THA<\=rgpIO85f|Ljh8DI=R`w2
^~&=ӊ1!o !#x(|8ӊg  Qav38G +}(|)O5Nw8|dqD99O"'@ày .?@~xH#Dk<B,SE!c|}t z7=.>F~ L>:v?K!#Ɵ|
 Otԁ2A6[@E0"ENZcDy2@{2F\,_p?p
zBS9S5Lg(-| ߙDp)3
x|@ C
`A'*u\aFYƧJc^I}1T7P7g
5LJ5j? j GG8GF \Rp4 G!0_h|ePBBSĳ/?^}
!G!c(_|bPA"Hg@?

@7G!YN|B(tg*#;K&,}	YP?! v pG/ 	Ag!3:$_/=g!u>1MCp0?^WN	,0ȸFmg!A.#!Lć)	E15
,dx
x䟅a{2cY}<%^

53|V{Ѳq#: 
s)|rlV3O B!4DAm
P{9vt6p
:%jg3S	|1^d @Ql"!D3:b¨ cM=_t؈1!&ԗ"XCc7e0Ή]|:yt~2|zha=C8Yไ0; N5} cE]מ鲁Rs /)F0
ЏemxCmo(m@<3n\7 0*)'h
Pn~^	ࢀo oX~ |1
碀o `7(m=!x|98yvLp<hbr48?aG8 VmPa :>8t78T塀q2i(S)IC
<1lduK2Do8Dy߈bgP]ȣB(/F#	AXOőF:x>x!9s{T8N_%L
׀3X>l	,!L`':c/|2|M0"}\oع:hN>(*`U`!C=.s>\gppqippM `
,I&#0() )ؓ0hzL*?0c93$Q';W
qw)+cFr/ul`9 
Xg<i1VaAu?+iGܢ
<ӂcKXl\X!!`IF >8G#}3{:"{ў-|x4B8vHN09y@ۗ6*߈b e., T7__^pq=t 
<0Q1ܷ9Jx;rhBOO>)
&P
>(>x-N✉j8c85$=-#8<2ǐ!yq|ge|.hhd|A0쉳 wP B yV5Jg_pSd
SLuGQMTvZ`g!v]I/Yp ܳ8فup/D2 Q'YI0q WC )8pdxP F{>-9!SŃ1*ivK~sxUi"/{1
}#J=-c wz 8zz y qGP8~lG qCy 
%Rp;.k(!03O1{38Gvx#Cܑ6vp!@dCǎǎ;P10	&LG-c&<!"@> c	W<x~Z]Г9Ǉ,Oq҇Yܠ]k)C'_=YؽOuL9Wv!wI6
!g$~0<
3xG8ˆ|`uQ2;7K>vy3`|4AM{D8_`EC	8P$8/>4y>p{P@=!3=FN٩wf?<~.=
S_>3p
Mχ
pa
Q j/S`hg1TPg1z \> 3#*u>	~6Cf@ph܆
04zq9; ៣Ꮝ`]1۷g+6@NFaPc#<~lph̑ƙh؀Rȱ)>8*W>1]7t_.|1/->!KR!ЀOk>0UW!I
|Ox`ãg%c;xp018PqC`YO_Y<(@ 8*8ۄGL3(a`Pg2pE 9g8C=h=kߢ)\*N ^
|yhh;Q熁;P n!>xTg;ᔎ?N5Gv.`"O	[!{sloaG9=xo>=0pL1-Ptx"G0a c,JWGV8i=l'PU .u} KP P#36cbbO6||}6;~ g@?`*n\( ,HGNrd{!뇇zOcy8±Ntp.N؆#'Z*ŏ!,H{<Gt;KFgW9#Dahv#:.X%DgG:&Ct`ɀ?`4Н]uHwvz.g0Pae zjP \|8ZQ	#X-=}
_C|'% s1FTF;-x8ܳyx8|:^?!p6> G5`+Q9
#
uT]|}"p!^"Q`oQ
0o7V@Ol/j!<tQ
j<a Ql'??<  Ίá# p9*3^ȩ=rJ,TE
WOO18CI _^|1B
?]t1.wV8zgXOX%`X/ƌ0#G-c @1`	
XOPɣ P Gˀ݅1
.a *EkC^8U_	A?4X(~h>{ohzA|6v)P
/<X^x)Kw&ssf4 U<	&y
=MI08Jb?|p! B<H$NI_&<PFy43ЋdWI
~O,u,O1g ya #x
c<*$ÂT<Nz,a| }B
u	Ω pӅdB9i#X:	x #$FpqĹTρS?qyni};\5 aNO%
67Z{p<8eZ]>,$lp,[=]ft6Rq 8!iGC:[/{ه|p4|!:m0'd_XUz	|;{/a	jTE00$s|
фf7o:zH"y>8xRW#lPSa.v,\'쓍O`ǜ}Gih֗kg	@0 Ӵ.)Wx}l|13?HT'"FbhtHp0=s  H7}A]kǍ}gSx?8!^}e7}E	"hC<
ex(>34x /c 5> C20wG
wZMɠG=qQAtlP7qt|18.sᛎGaF`ϼ`f'10Ż>.cEw9M0q0.9Op8G =޻|vbi
!U'0(I:5=Ёh6=2 %\w_BOK=`XÆ^0Pzx#@q3&#&nv*M:L:#!>`3?k FyED`w:('G~I
 t/@>8Γ\Xk|t`\[{gy3	k+8j0-0"{+?d0>Qn`*f<+uhsw);wlO',j///oȾ)=x7)dcM(0l4FX@^. 86'|'}hM'
p<I|ĝ<wey}c$F닏 cX!} .!	4s YGّcEW`9G>~V@cQG$~Ns"88-3%v'%сrсx&P|wC9R;"w q
w07Gp?RhӧFV
(ӠVJ
(b18,%?boLa%pn#P:@XLH 1½bi	X$a@|5 L@z8&
B=0H@W@Mi51
"9C@`
Eby] r旟Hr/ D@(hk& !j0=B
P1,"0pT	h*T 4% S
Bt TP@ޗ D@NB|2 T'#(P s6 Z1 4qs 4;  y	AfBM 'h $AfoY=M"0gq<[ 4#}<0DG"Aj4LAӀP_+ȗHB@@h^An~5A@ȫ&0j d@AL@4'
B|q4L"P}!iAhX x[=8BhmwP T3M  2&tR5`R`&Mp$*DkѨ 4> B 4 "D 4i	PD&)fAh ,

8LP"PKAhl*	,*69PD`DDa@h *
 )@,
C
y.G
B 4W-sx T/%&Xh
sd 4SADã ur S 
;| dR([C12D JC139[# l[#\_GL_yh
C05wBpi` Cpj Dpk Ep
 vF\07hp `	l['['`[C2CE

[ FD0L
[  1p2Q 3 4 
2D5 r 6 7
7 #E
pha CF @C2EU0K4>6'{h
 b{zh
  4CF2h	C2BA E1 DF 0a
P_h
	6F0p2	H\_TZ_ F3I

 #   
 &6
0l!
bBr6! 
4
d
P
F
	5s 6
	7
a
8

93ABzCD
E F300
(B201wB3
0511B7
Q 302s 3` &4
py
i aߠ{h a p
`~*``B
05pi dpdaQj  +h
}d`d{d`dK_adP.e.be
}bCe buqc1)b
 {b
 q@c `q
pzabrc
c\/_SB_C002@ 3 5C18E`K`6
qpha3Fi ccyP
hr@Q! ! 7i `bb8
@- th{ ph`i
r`bt b
{b %p
bE	9p\.3C` DbEaEa`+!ba dwd

drdg


 `,~1at`sc/,ua=0#A#9!{	" p1$v51A%K 'B9&!'p
!*AM&s 2 >P(`
0OD` & E "w` ua`-aPB2@.C\/ D0
0
	
 /a?TZ0__AC0axa

`bpQ &brb
bb1__CRTH		2		s
	 

U!/
A!

.47
p

AHnHO<A<DLD1MBD)ME	Hh
5FIb+%51D54E54Fccbpcb?@
NJ?t#p0
1
K==3 PI!5PEbE0Cbwb

ara&M?pLa7C14z1y7182a ܯpabQ)aPWDh 0q:h$Y aq\bcpb a$A`b]h@E{aib!}mcm#{^Qnb pXhJaz`( [ v`bB`_hFA1q `D!$XTB
%&F`hˡ3rb+33HaL
dkh `t`W`x`@f{1cf
Df
f qt2Gcbkba>dqbfhFILi'tQSBT
%f1MP
w	P{B`|10*Vi07    @tPR_CPU0 1[:01@_STA 2~ _ON_h5=FF"E2E3CE4MI5KMA6 E17Q3C}bDS<q 2ѧ|p|t
ЧCq 3<qPr
3[18_INI c@ B_HIDA_UI`iP'0 	11W[" 9MH2CAp4C
		5	DMH6CE

7[{F!_AL8 1AL2C
AL3B#@ "1&A2F6D3f:
'_TMPϖC!a=E ;HPSV9 ; L!- E_TSP,&`TC@}q 29IA/
B[A(0&p&DFf
F00$"AE
`p`Qڤo`[M
3_L
RA

̬*[G	TZ4<@qHq
`C179	{``
d`wrs`rsED31F949C3_20 1 23 4" 325  6 r600e֑[7 26
[ 8@w(Ah292;A [ AuB C`pN2BUyA
	`P`Fp2DQ28aJac
0`rd
  b}y  baya
a0a1cq  eraye
	 evepe1c uc~dcM{2ErDcpcbpbgC	bdp apbe)ec"2f0fg
fape`pfafgvdueAϲ1` g
Tb2٤$0g19agg7agubߤdMF 086b024}p `c@"`P 3ryOC027 3-8 7  9 "  1h H
bhސc `r 9c da
e2%-adft`f	ru'adSuc2ftd gr:`4b 7C330Ѵ,7&-5Z1EF`4/
mBCpibh}b1p	  D2
j123"33"bFp	4 w6
arPFΠb0+bab`babuaaxP `b+ua 3/ SQ
PHt34DR`tpS}``6pD9XD!

	        y p3335HG	336mHD
37B
^GwG  @    s3	7	P_ 	 	p37[K]334R.1E0N
zG	 G$ $ GN N AP P Gc c Ge e wg gt t     ະ @  A-`1FAn


W@Fp
`q ^^. DF\_S0_ 3R    4  5   M\_PTSphe`41H.AP_j-A$d23D 7J6?\_WAKa DGu-fEEI
3_
qyBAPد`y||
C150 F||B
1#Dj))߀=*
 \@8
$ISMI
=#wyFD1E1$$Gކ0 
?239A1%ɑaB
9ߎЎ006@149OBAacbcc:c1B4
!@
`1t
 +b+198ιM0EA)F1.2Nl@=;E XKACEL.1@{L111E
@W
 B\_GPEN?_L00 P0D0
1P`Qj
cL{{` {b  {`
 }a
a  +{c"cbЙi 0a 7301B2} 3a !/a22FBd}dqc706&{P*4Ba95L1 C	k09955po1C
dFBC102}
@B+["i`2$B8FO	C	:&z 0BC224+ 0qI

I \$
xv&
["
d'M&2>%BDpu58`C'.`
(.e3ྲ2x|7EC12E=?`
A i:*I`cM`
?&4&j&i$N0	:fC
\&3LC`D4DB})9 H/v)H&0*_Pj)o-3.) ,)1)T$o A-M-B-S@-oT1UBK93TCaD_`s EcJ_L17 QAF?`}X@F561E9a*@QQ~ Qogcg$i\ZwP21A@ C)815<<<
R7tt\QŠSD CU
dA߰
 mC8`l81 3BDrpDrp4!V/a=}TB  BRMӸ3 pEց	DPE31?
C0k	
IADxBCoBCBCaa`	c.p~ 'Ѥ {a`ccwKQ[@F @p
[ C340?p
a)?5
 %402S1b{b 1@
aR%Dd70,bDw40``	p>	s0
v

}b+F+D 26E !!  1p
 SSDTYʤHP  HPQNLP M/SFT@PE_EJ0;1BpPPA >֑: PATE1D6_ADR o [a!42"RD43% E_GTM p
 `T`#4 `$5 A6pE 9E0{XQ0$5
4!`OMChO	i (`p
wC`a:` pA` bwb
bwc@ib ac j r0  rc u`A
`!abq#
2Q40Gbca pP` Q[$57vd0F Q6q]89 d0$GF144
 3
K Td99
 19\j3i69S3CE`RA3CF4H_SDD"!h+!5B

Lpq C DcXEYF 50s 1#~52҇h
p3ppHCpDp
p
T3FC C#dCCC@54 OgO _D,N,P,,D6_E8_E_E-7,p
xp
}460E4554`ujq645 )56K#J
KKS
hT
LJ
6 55 555NNN5M
         
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй Ys# hfP u	fXc  h ZY[Xg&ǅF C9   Ã tfPfS
u	{p  踂f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tR>tKFtETfu
L0]t`t	dpX  f]ZYPSR uyvryv&L2qStN tCu+?7:ǅ%. *'<t<  
Z"Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3ҠKji  :Kt ffKfj+)a3  `49f 'D%g$ЊFb	踐E F\r4Vu'v< D T^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
FfKf.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfVD MfKFt!hu\gvu U>tU6f뿢D@)_a[af^f!aFV  ^SQ  ?e0Qa@9taT% EG跆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRVOu2xr QERi ߳ u  ;&KpISK]0`@h1	_S( kQ  `f3۹ Wfs_Ձ@T@{" 2: 1Bj0 f=EFfC`?	5	tt$<GvHxs ?!"Ⱦ
Ќ (o
d
wu+
1?Mviqp1vuZ/'7FF^vu #*VF$^fȢO__o0V mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6ӻs=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢrÿrPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`krCfaf`  ufc3pֻ0v X f!6j,gfwP׋F GPrR(W-n<AvPUf;f>n, uf% j ffZ	Çf苇y{, a ufz蘇fr,鸀, 
 j,z` 2_v1Onf?WfA_fr1f
={rGXZ0r2Ȇf`_ rRfGf>|,f r<
r7 	Eg&V0fqf+Ug&D
3GRNafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXhS( kQ  @Zf_ >;u<MaPS- pu߿;;` ;;;U/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; EPE j0fdQu!;! ȃ uddfdd l >P6ۡSd d?\dtP 剱(;;EP:Ug&t=` T=f]t,>@u%ttt t	tf߃N tF Cr@uAzalaCs
 1Qh 6`uF w. u$
TVWێeS~ t`rt?{XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;afWYдe*&;8fw*fF*2t*܊e&;fX^fY[wKG'!(; ߰k" b  ĀuBTv;|  tB2|l}SQVWU&F tF r]_^Y[LS-120ZIP 250PSQSRV:1:2:ِ2Qؑ2PKp
Bx
6~
ߋ5	<;2Eik>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfGW(`*X*Xu ͠HAZY[0^`Fu ;QH;;;w;;0 RW1h7

_} tEc]/_Z[M-SysPDiskOnKeyP#jBI ut @  f<x fP ߳f(0QA"`z|= 2r 0w"1s? ?sU3IH ?$ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&o,c-\w?t,f_ Aï% rLTf<?(ժP5Qe}$ a[
1p<p<? t0h|4t u= u2${3@Af?MpI`N 
fXuײU?0 00J0000FF 	  FPRdoK@3W2>#>;2>
8?Z_Y<hG; 4  h }S| }ZXSW0+@0s!$?
u$˄[ð_ - 8i B g`	qAq 	  q
		 
	 						p
 fWQ OYf_qD=f; D=;FD
$>;%
_D
%n;IbϙΉs@s
<rI`d
Qr7R[USBSu\ t t
U	 	`;KTB <w9١ p arQrY< C0'V % 7F`2PD QrIt2QfFzafAY{rSfigf^qf@FH\
؀e܉\b$K
prA
x @
`0
!?
0
"osTq
aWa'"CS#PD=q0*W.?43'T}2'ú0oZ(Z/(
_7
qO_=/%t9/T$RQ$2Q	@ ?WK@RP2 s с>`u ?g&` T=
XS<(fʐA &~ yj6;  r}fPQttA3>~f+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9??,B3U+*/G/%QfPxh`gf<fXY"N0\OސJ?;G7/Osc`MoDA @Ac7e=S$l=38%p;[t `ot ``;D?$
ƈDaz ϋP!l r
9rYAݹߖ /p%tyFIðtT= 2:t+:u hYoety~(u~(rt@`=@t`=t`=`	t`= `6`oWfa0V
<8dtd}rـo<8DtD$PQFxPhrޠdl^SQEO	8t`g	G	t҅< !" !  3  @nO 

  !vv xQfWf>_l Fo'#fW_YØ^PSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYgf[fRfVgfeG`-PgeG,΁fQ"!
6'Ps[ ,P!V _f^V;;faf]	6&ys'&P/rR<vRr30
?ge t_0 AO@ra'P[180m6*i%AfgfC  gf	 
{s>ra8PQu:YrPiAbp
fP&s
f	 
f
 Q{ 
!U?Wv'eGseG`~i _VRP W31P gZ!
.
(#5W0
S
B֭
%?@q}r$$ <
`flpcC4Cs!hccoreeJ1*A<tK< uMf۾5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
ww?`}pRqx& r&L&T <|PFh3P(Pf_\{3VAf?_ffXqf 
~qfXuײ? fffW} Nfqc:f˴p]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF>reCR~C5P5PIi7+6p6P b!1fgY♠
W
KA

$I#j
pI QY6BeQep+	Y	xr /
U2WQ
seSAO}7%tJ?wA0PZ`S1_Xf񇟘Bu _
u }% 
 !g!%O% 5Ϟ     }3f߁  PYt 	z2fp uf]Zqtp  tfq f	bCfff@Orfurffyɐ+f%ЮQStf

 sహPqr`QR0cDf3fAp@yHR
fâPXpAw f>Q`r/fC
@;S&7 !f P`0U{u

C	ݠ3ݎfqC &;" PB3
q aa!@%[ppxtfmf RQ)`(! BRUu@$#%7"*E   us5# r,Hr'7
 NPSSg
#-@P)'C,R"G-
"10v)%
!02 }Vf>/`˝8?梿&|Bf P?z!?ψDpu%f<E t
t
t&z[ sPf
Z͉6/- gFq	g7zgFq gFyzps b3|B,3u +|~0+   < t~  ;vȉq tv  f@-CffQgwf
GGg_G-  	R
 Q
Gfyǁ0f{fHfb_f@@I1&~ t@q qg f<00SfRg ofE3A,3;	@t`$2f&F t	DG^^^!  sf@Q	Ffy  ǀ`G
  A !Iy>					d{+ః	2@	nO	@	D@4z 2@Bv462=fA7Km"xff59h"hRa{TmboHfuZ<0i }f&m$ِuZ@U t`)]% efd	W\Dyu=Fm t5f\=lf  f+8f;rߔ     ߔߔ֔ЁTЁv6_W~____T&ti@___l_YS_ _________|___b _____Y__l_XP_oS"^______YuyU=
6Wc
   ____ 				O	ScfSc [=   vA	ws  q@ D `@  "2E `i߀ @w
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfe@Q_faEA	>dlucl}@fQfCdfld 2Fhlil%PWf~;f+Va++ g*@ f=? ЖfS	XAOhvUftQh_;adf /p1$4	C:cl3
f
?)I4ө% 
и@tBgՠEuGߋf>%2ggefFfGff!g {@] f2+ǐfj-Ѿ@t#f+ qHt-Af
 uh7gk))Xt(8{f	 p~7el A}flfQ_-c;q `u @Gu
gele<>t|f Wflr lsc`u1ge~M 	C =OBG рK~f  O$<P{bt t
@ {>hP
>i
 PHj		%PgP3- 	 ?D9D
eVfrFsr?2 r" f( rFĀu&&P'Psp_"Sge8Ftff;reqK0D$O y0 ,d0fWl@c 0dq	f`fI! W jgbg_$"/ւaj_`eOeW$Gb plgq2bY!BfβA G1ROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6T!
fqr   2!	A}.>  
?  < x uuo @       St[Pu&u u!KruBuBӉ ?C > XPS tuuu>uuu uR[ CruKWuuuuQ	`PK`
3ۊ؀`u&svutv3 upVSD@t	V[^0QVEug&"шupJ4fu1uq]4S1péu谫F[^PSVfU>EKS>zv>Kϳ&wvFt(
ߠuEg&uuN[艳ߡf]^Vt>uu r1vu{w%0r~@!E6|0aSuP  [6̨Waƪi`z2٩<ОQ	2pPUt1vuIh[ZuKzvyvfPSQxvĉY#\SPufwf3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvbyLr;qeurqVW@fFtAQ څt(PǴ:?vvu 
  gXfCYೋqq q9~ w2vvkYⷠuv`Ct&tv8r #>t}Pw
$_x#0%uxv.v2 uf? t<CP<tSQ@K߰&Y[ـ u
lq| ` - ~ i8 @` T@8h
@ U0p%	qk l 
		
							
 

 }fWQf{&D=^QYf_侁gD5 ;6;;yߣsR;Py``}D
$&;
ĈD
 1Fs fg&|5 EBr`耿r  a`|	 		M|0R		`R}H\
 {;
܉\se bb}Qoab}f`衬軣g&`vr ql=Br`h >;pt `t `t;D$
ƈDfl-Pfp& &~p;_W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;螫轞j(f
T= &P蛿rjrp`u6;; 6 rDQfP.?f.6;ǀ+܉fX2fXYffrgh*`	[ Y* 		Ӌ$	hb %WG0F
/
PsV ` !sJ%|=td%"t+T=:ur?`B(uq!(~rg`=@t`=t`=`	t`= .`h7_262ogfaaoV߶PCL	;t	wPAq$R}X <R^ASQ2|O	8tg	G	Y[\i0   0    |Ro d q n  A` о 00 3`  
& Aa %  	%
0 #
	"*
| 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
:aT S<R"G 3D%M TVaX'K8'(XAIc  WI O  x fSffV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 f^fYf[ f߰ PfHzRf3u#Muf;ku
 @ fC  ZwW fu$ -UT fP{%ffXrdqPt@5f90f  fm
Wf fNf_AS0>efzr@i!ffff3  0[Я  @ Ԁ ت  @\ t@dl fVf$f&~   wt   
fD`fd.f^<tP#ˉ Q5 R*Nh%|4<t
t %܊SS( kQ ᠠ Qޠ$0s@f"E$!4",޶-cPS1#|&3M38t< t 4 v-g#tt 0&#SV>?EgV8p U< @DHPMr:t"`B-w?u-È.GGa?;-rfTDaff DI	fAKfg8u#HDqQrf1s
f@ (`+1HSHPS'} <O&?}`f`h0H|(!G@<<t<=t<>t<Ft<Gt
c55
qGN1Z]    %`M3of0Va? tf<]  $ fcP   t#@rfuHB aqftQS0^fC`BUބc U44`f&; f>/vq% }! eIf!ig~uPi

qCDq; ^r
ɩrC
Ro-?  &|f 6zwf  sZqf9Qu gF9zu 9u
gF9tXz2/g-tvVf>Q  rxsFf!` gFqzg^ g`A  {F|q 3:`kFC t	f;QoG;;f@2M3
 "4 !Ix					D+I@i	@	nO	@	r&z+|~   0a~ }BM ;vȉq tv  fm@ 
fn`3fQgG p gG-PA	q?Gfxi@Uf@՛f&Y8"!1gGA&~@wt@ afBr SfRqf3_9!^5{	@ SfYtt.M.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationzN1OS@eP%p`"ѣt2Cqt"~Af%  =  ҟ <pdt<tH<tN?<tL800uxujuTfPF<:f!a<ISGu%fц}	f`C s
gJНRVfUf❁z f6bkt*pGt
B  ` nou]hC%t.^At#Oǣ4ǣo%>ӥNR#` @ İk-% 1` $Gf]]aUP].)`t411wgf#f  ϊfgR1tx-T	!,	a'""ԕR4b#SЏJ
>PeY]uxt*"IT$$*	g&<ж1	a?5c	07Zt$N<tԢ/)
`FDO0E	@HK30Rr+5$A pT6g%q6jqf$ ;g[Sy1l4?lSQ@	r#-<0~^W:XXߙ`q @O0 u(P*P  rwyr} Yr)ffWRdh݋Zf_rJPSƊflp>8Pu	1Pil3 hl&P%P[X} &zs	wf d w 68PBA*PÈ`
 fd!7P! ȃ ud|d~fddf@l66`>>á0\qdtffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
׽s1|SQVƾ`tـ?龰&D~'fATfffXs2B	x3p&t&L5P 6P uY±iވ5Pa>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	F&F/  	_&} &_Z+S/-e`&W
[`9t4h|4t1
&u &uf`Q?؎@܀wgapq23ag&s&C#}g 0WFSf3Byc@eC
uK[ðlP><u躿<  It  <?Xh0f  `R0ff%?fДEg&0F Fl)p0
ZlQTd rcYБ	
D.K P2Xöf fпf% ? 0f
P$}Z  fPg&1~{!ۅCXC C q#sB _&   o&!z ;t4 &  rtuft! X&OVbC4"Bt{'B(BuBA 	s %I+0%sj vVS"f bm _XSV1 	 h^)CAEsd^ ѣ%	g&KZ
7CZLs}! 3Z  V
P<
?t?a$g&Q?ffÑQ$rcfv0< u@ 
f  Lf  aG,(
 aGf%f
  
rGaO8b <fT &tf$B4A5 4 Q6@f
nr<f' fv  f f&Ʋ
P!h J2T  G
 s	<W% <t+f SL7 %u @: R
O	 z,R
/r=?r>f{	%r
 UPBg %O f+f0p aUErEF?k<p)  
 :C `#/ujR$3''pfp `4"b',f2"u#/   sZ ] [ \   z @ b  L ` oa e^ +@  A @c 7g 2e @ _uf @ @  k i^j  @(T @  ˀ >  @ a  `6EgVf.;P ?!f! ;C@   | 'U$ 0  f 
ܸAfUP	Y	]	a\ L IfQ  M@ BIf$  gf  Q0ޡƀ 
L@f;sgf9t}pLf1#`}e?fif-q_?
 4P`Sf3 hT/hĭu7 fr	tf1dGIR 4@ Х t؃ u˳ `P`RԡdTf?fd<Rfd?8RDA$RA"] uzwhhlŏW!}*w!襐貏~xf~sad@-PfXQJ d ]	 ! W Q %_ " &:܁&k PaQRVWQrR  P% $x>00V %&qw( Xf@@X!	u*idie>e  6ep s-1	'葭w`"O- ow>D:P?!ƶ$Pa33zn!	%buQOVS&S?3'1uF*IG# Gu`O$<܀u ߼PΗ;tF	t
 H 0.Kd:u>? u4d> u	1 t#uhuf@1ddFރu<u2!^u	I9 _^Zg&8!@zu	g&g B%DtFsPVS u h`|6^RVWdu^_7»* 11u Ufz /eosRox?f]1; `T`r;f.;t3Uuf=#]f
W `?aË= v	 +v93f́  ffvP  6^Ã tL;Sg ݉ Pǋ;@tߺ c.mҠrfѓr9 w0`b h TUʑafϋfo ~fffROMIfMAGE;u;W{tg!3\3KPQ@J 2fGXZYXu}wa`+GSG p "2hct"t з t	V M\ cu'f t!w{
G940G\fd fCft)7O0E0r RD;gfԷ  i 1"na)- pHP,.`󻀽 
>p?\aPrbn ##V  A7v P`(08@PHX`SV.etv4q^pMQ Pu>hgSR $u<v
7i:,j [gʀ 77wG`r )0Ppᅁg wS	lp4pwOh`_:gw/$Dp
Q!	 tw$dh&
@w&F\orٶуt<o}rD肿odr%#LioKWrQ,Po2s
 J?kh_1	o=7	t Tn G2?6#n
uEP1P$EMXp Z$,\q[p&p&uu ڠ ? QаVb  ?t<NGfwVf搩fP{f A5 kr cf\GR8Б #f^p0Up f
 D]&'00p/f'	߱sU&u  ]  
4!MD 0U ab bG !	O "SQFZ wೃNZhFZqR  >b !f '| d %X\,CR @F${`q0suO4ef="Btށ 'Bt(B!u0$pY ,Xb{ *RfDvfk xfgߋEP^NZ&*b			fϵ5 Wf>)  yq_Qp@f% kPffE/2f592p`x v)` ;sff+c f-6>at
3T1I!APk
 !
f`=ff1 A6 fffp	f9r
f)p @VVf$4VfU^  $fӃ\Qofq+f%=x h1
ϖ[_縸\/)]/If;@t> u Q w&1*:& ~ PS!
Xh fm .Ӡ .8?r
/Q

hհ>@t t   _fp+SQ	@0*p=tuf_ rP9%B0<s<0v0uo@ pN_R  ? OfLSdx	 r<6%U0f0u @0Q f}@ Y#h<`w$Oh/`C! `! ]>2߻ftg:Gvg_fg譶V !bтIf0ࢂf
f~H( X3W0?t%h0H@	g&G/ 6X(Jp.p tpbaf
="t
p $C7s;2Zh0)@ffߋfȐ62Ƞ1\* w* GfGݑW`1dȣc@tʱUax3w6N=t=tO"tC hTOr#
uU0 fd&2
. Q:sб ; nu5fuHpwzn@2xif#~ s<5	u uztI S01VPt)fufKn D	`s4te[}0uuWrZtuL#[P1Af,FQ~f%
&|
 =s uv0_m  u*f&mB  s~f*=RSDTu}`w_$!f=FACPt?f;vVf!Ow u-Cѧ(b D!+4T u ,3$pSuüPpf ~fG u	ClP`g3 W23f_
 G	ZCpu#f0₄ ~0铠릿gfFffۃ>u2ff@  6Rpg61p>gp^0&0fPՋ>BG0AR ZR   P&abpZ&&FdXPR< u@S_RgtXr),uRG`SQr9R'訴$8t9Y[	tr$VO㰆HAr(QSFr(!sq轳trp@ppq[`irDrT~f}iY0Yd>:t	[ fa !  rTv0La@f`yt>A _{ G{faa~h'`q/e`>wkO?/P#.4蚑 6ð@ð Wj@Ȱ蛿g&Cp&Cf  @ڀ@t} G ڠH!	W sf_ҞVfWbq{5o@Rg@g<PC^fZf3gfACDff@r츟g@?CoP@Љ Qg&;t4g&Ct,g&Cf;4@d$<12Yf
t
g&:#tfCfYFa;tft{ S e޴r7fg&F t+_`mr!f`Gag&O@` Nb O cz_QfVuu+rB f Ur(al
"Ȁ$
Q3Ў{tGz@a U\ U@<a/8r p312Kˠ P0U `<r<9Pŀ&0Yqtuq "t؀><:/sº7g  UvPOȇF X PSø p&<Ȍp :Ȏ؎[XPSء<Ȏa@s`5٤}q<  ;} /d3 97) E2 P# d 22	 
vrRu见&y`~0š?EgP,~fX                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  `    ( /Q(     W    ς  g    h XX k  ;p    / -hD [r/F ]jtS          P     @     %X%H_&                                                                                  3f3ۻ  f@yfg!)A  f" 0 gf+ >n `h7fPpu	fXc  h  fUf&af&>` 6a  !ŀX[ &SP`@ /'a[&Ջ&WP `XP&EX% &E{_YǨ o2oooǸoc< u0 < k <u2<a
 1                                                               UPRPRVFZX˾0RR30ZO                               a{ 
h3   f`ffot$op$or쪺  .<t
../ NA NfafPSRVIf﬿pr؀tU./?tA
 NUNh7]Od^Z[fXǿ4 h/_À> t%f
`fftsPSfQW C_fY[Xȁ ȁ?ø@PRBZ B3 $ `%>&%	 
  3  t!   fQRW0_Zr #O	PR
fPT ffXfP
 a$>$
` fh/&` ,/ &/   /0/1/ / /aÿPfW @ f  g&?t"g&Gbg&Gbu  1 uf   κ( 
uf_ a$$
a wC PB B;ra`_Aqͱ?},hR/ >Q n S7Qaﺵ* : ,`
222Rq8ĺZP ,}ȡ%(؁~ Ë34 b0g&D4E*
 <B0' 0hs" 9f`1fL2f3f% P
 0p!P!q  f
 `0XX!Jf`1"f gff%?? gffP `BaPPfS,(CP0
K   gCw CIhΟlh2 Xg&CcfXCfQPfV uf  guugf>u
 ߻Pf^X A
f55  fott4 p  P7hx,fl:f&_'qfh@ hl^'\}h%|&T@d&OOh?f3/
&G4@FtGGrBFB
6
fy_g  !hfLW  gݰh*A   dGdKh=< d>il thLFOndHRyh6dICdJ͡ WfZ+'Qfff f"% fdSl41;AfdWlffa6ddlw f`^ t fdclh0fw 0[l @b_lfd}W2f; efYWf f_#B*J"eRd辁 ҁoZPQ:_uq"yqC*YYWAK;T/;  t2&>Q1  ;j3 ?hmoB4=_Rb{ hcrUZ*r\Z~ &@ t@s@p>'E@ r>cr>ZRn%t;7Tg q0 b0  Pu<wN$<w	Nft<ucW> tUPuR uIК/B<t>Zt9u2C8r- qOr!\m'l+t nG!pn_ n@ī.J+tZcgtK7r3*Ȼ s=0G <u$
GPhOP 2A.t*G?"\r030*t~t讳*	
~   SQVȾJ@ 8t"8tr^WY[At,&
u>ut
$菲sE t> u.."t$	&
Ps@ #
t舳`ȷ3Ұ	>!2
ҧD6LtHp{1߿0K K'tCƠ@* # 0< t'$ } 
u脲a>^{ 	 >t -t0z P ug *膴t%覷r0.> uBu
 #胿i  (Kt#_kr1 `ͨJbtV 
ӵr-5GF(tBH00/-rŌ1 //e5't_h5tP ]rB@13ǰ26蔰ssP=%
za "275 L45B#?tzu >3طc^tb;sW;sQa3u	*u"
m`uEñ"
232}Q 2! à2!:訲to 賰	) o!)PA5t>XSfW/~`
&t_8؊f_[Li("frsg]!  r&
Y]
!< u)50
9+u$$t$
 $!Pd#Q  W 7
!|P0`Pàu :f`;؎ R_fb Zlfa)@Enñ K @(00̾k0Ef" pǞ  D  &Et"D  $D( s `ف&tȀ ׃4>2@"Q
g& 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m ?
 m pj's 0a` ar * | XOQ۰a		? ak # $$<@t"h/KuKfZroK&Ku`.>Gst&3r	#r/QQ=aô`prr X ? 1tr<0vq;w#8:9=\Mϋa){fRQS讉[YfZt'0! tu
| t輷a0r&JC
ADjGpt  Jf` h!_Vruf>rfffdf `|݋frlr<fffHff#f+ִ f;wf!3g&Sc
uff+ʀT
T 0?`8P%,Ⱥ:#%h 
ف     t(  9$^Xt
 %@  Pé }( @63 %tVaGf3pE faf3uSff  f*%w   HQ0X
 WQR.#_ ӑll3k%߰Q#cY3#ˆ`` p9RP)5  %?W
 P0ZbRhΟ,h2LDQ
  =$uv # `]
 G)߀
 )*Rw=u
ff% -ﾑ%Z w(w Ih	tEf0 tFf6 %f$f#a $% 5 q PfQ#
 PPf` &`1'3)uu
Դq(qf+ZYf̰S(4 (T T(h7';Xjb,)h0[f~_ f,RvQ-U(@tP5ADfX{4 
-V(SfQR3  u 6@( @u(АϨt t
n10'@
 7uf%1fr 3tmsZfR(b4,a4f R5 @@tf@ f%'fy (ޢ { u z kQRP<>q;t=I% tfm t? ?q% p9,.028 -  OQV0]*/W/2|ywRP%Bx8*),	/_/f|( ڭx^zQwzi(R/w8OLT܊N%0)m/S_/bZ++/`ȺmB ph  q&a0u1 R  
ݡhB"3Q  7@!0RG 1PfffX f;7f0`oذpIO H ` 
 !P,,,	, 33 $#u_ ) 	   R_f),f U' fxqGfAJ4If%\h ft-s|g@0[W    E1D6
p
f),	 K%(	!	v#	0 [Q$% = u
= uL=  `& @Q=W',jfkS3R@R@?Y@ 0- (P_0AP 0 qPWD eQ L ,A048h!g@Ohf#BBw0t`tӖB&#Rwu  Di! h0H_S( kQ  PG  0%f_X V%N0 fM M  t pw> u" ^QWV   f   ^_Y
fO`hT_fUfA"%=t=:V,hjBofFfAf.::u"f  f Цl
  Q=2UfE pyQPf52fa`{ ffYh9?  ?3)tD
A3hy	7:faPw pDFf$g@9 ؠgff
3ҐtЬ0f#P@wPx>!j      Qf8ЄhTrfѹR'
0
3yhTƢ3st*2	覐#N2 u!,}0  ?f   "0.0p0""@/t}	!03Df 3psf s+CX14fVW س SRffP f
0u_^K                     K `t0 	4ɀ$ t		T 4	x u Bo4K`SR@B u$Z[WP C	VXAg_f`R
`	f{gga fWp3f3ɿ4f0<  &P5f; X:aDp종4[ù@ fPޫfX,f;V`JVJ7E gߤf^! fU^	V					:		K4	^		pV	W		+	_~û'Њf@#cy!  tO5{a"hdsT(Q ysYlؐ}>uDJ=?t萀pa3SN[C vS3ۀ> ttNt:߇Nt{C  [t<w>8{t,g 
&ñ øS r 輚t, {聚 SNN뤊Nt r[O"@5P4fP	RANrA a	 fXjp;tp~{xP	4a϶{@t1-w&ؿ㋇O.trwRaәt0
p;< t
;:@   N΀>@u诔tOaÉ  HT

pZIP JC@ ؃@P2J
s3y@si  wY &w
1F0^;_;a;mz:^;u;npu;thPpP;ˢ;`!  ;;< <tdww
210;r]  	&]T
dÀ
vo躨 >2dP22z@~h|<??tDh凌hh޼rž f P2 rb۶ŕ <pCϬT
hMгf`X8
b!f3//8?fX@!7"" hs1֪!fP`/)
4/O
H
 "	^ 	b"	1/	(	&!_!!!p!h9GTh6IUvwF˭fpBs_u 2f fSRt F<tv$rf9PZ/tQVWrQq 0 _^Y}TfpEfر2fot
t/%S/ygfQ?p\1 Pp^WSQRWVh?6rGыt(
 tuu uett0uʋ^_ZY< 
WV;Eb/4;EG Cd6W p 2:> uύ6 FHt\o hy5JT3Ҭ؋hoLB^_Fj
K̈́
>
2
%
T>T2E@OHp
N(u.
~P	er,2ETDT/ TFC`o/ / /  OT;G<RwS2.D[0Cøa ;4
-
fQhT0_ufY\lQ P`0rXQ&G     &Wf&t ffBf;Pg&G}ww~rtwRtpff@OhUTASp3QgfYghoƴeA ГY[Ua>taPSphtWhL42f[ Y&D` sW=xG@f@ oDft HfLflPfǣt 8 f@@@@PPh o>4~ft	h@|	f%0ćfrqP@t@r<t<t<XÕ,,PS$<w 谿 .Heo @GC  ~ Ǿ6!sh1p	fO f$XðG	ל  tG	ĳVP 
XuvBDb	qS! u
2	 p	״ [e_h2P ˳l	X	G	@
2q(P2
tˀa	)
$

<
Àu	<X[X ! a	a

2t }P@<KrKJX PR0ڢ:JZP1.:J BZ s  ""
ZP@좎JߠJ Jq vJúQ R ( PB X
	 ذ4ðZQSW P(_[f%{̃ 薈t7>t uZK $ۀ>p u0L  -Вb\_3`0(u< 8At3ar-<t)+	pu
$&4.HaCt%6t2tg&G Q !pNu蚅uߴ>Q2&߀Q_PLLLLLLLLLLL@DHLPXg{TX\dhpP HL`tPW[_cgv<T\p J KPUY]am~FKOSW[g~dl|9;>CEKZm Mà@ PP {.`X!,:?%  3`  PP`rȓ[  !OaYPf 33[3#:>s  Z Mcg:GQW<u
-,-,y Q,{I_+z Q,,|ϰq"3~PR~{NZXð3Kh7]R6q}	|+P|" h8TL$`ؐT8! s 8{*a`O% *X   :% OPP r :T9PTjOcAT= qOj99! T% O"O6O,O@OaBOwRO{ 3bTO% 0.&,pO ÿ >  &pOpO2 s 28s !c P] PSUV<2v2 Pظ? A$^ Thϼ[. t>M  ^]?[Xhh~e2 	?s À>tiu%thY!duP<퍏r7,a t
V8P !`A@uC`
 u
 T'ò ޱ @Ͳq
pmep>>(f.?f-Pf.q  Ϟ--g 2 r誾 vb 31|11ɌuyhQ.Q033QS r3.Q>r_ׁ.t =^r1诈hu_  	0`@2 
03!477;  +t
3NO+t3GNOpUNRvRR(NR_쪺P aTRSRR```p@
PҍXh5hG&NUvP|SF Xʿ PS&iS&gS&eS[XPSiSgSeS ]e吥袈uuu&gq pp  t[?x@T MP&@T@T$aK?dLw0TLдS8rdd8rS<dr
㳿d2t诉	蝎pTNQæv A YC&0X @\                                                                                                                                                                                                                                                                                                                                                                                                                                           Z p( f fo龗h8fP u	fXc  h @   foMgeuge&p #0t)fSz Q   f[ 1u $  g
ulfem   hR ˚>Q n0uIe	:f f  gf&ey /-ggø0&&o  P            $ >         < L h  D ` d`    ``п   ܢ @  `b  " 	 	H`
X \EHT ȯo1 2L@34 0/ @!                              a1    14   @  8 @@0  0 0	 7T,#2l        Z PXYhijklmno 	

                      - 
,89:GNNO Oh/j4rfPfSfWru  Jh'/Tuh(wf  i@g&OZ	(f_f[fX0Z &g&_f   #Ʌ:  (飑 wq[fwXf[XQfRVW f Q  !Q  A!!f%uuf3f3f.2fffu_^fZfYf"uQ ء f' ^u
f0PR5 % ZXPSVWfQ _ t
؀ut upf  fp  h*_dr u* pv @uf  fY_^[X~`'QfWfVpff
  ffst  p$א f    vyf^f_Y# Kyu/ybR5   >fPSQR	0Ow3q-q-fxs=6xؠ+@ f-$<s!h8Ū !pQt61%<@"u3GjFy
sKnP )`f>5@
 oh ;'>>>$
s$>> fۭ2ZY>,-./01289iL      `a{{{ 3 v
wRRFa`{$a,P~G3""
P![2t*:aÜ`>@ l> l!GA lBla6$?C ! G @ A  B  $0sF  ؎"|n  ""|  BnnnJFߊ$a %JFސ{P {<{ tq ̢{P {̠W̡ʣʠ |ޢ! {7 ?llB  ؿ{ lBB@| l@    @ l|Т|WN&{'|| /$а 
@  IFFnK  	n	Un	n	n	n	5n	nnn 
 || t{{a  J{0`RCd̀ɁȂ`  3nnC q
p		 nA
~` n |`47!q a_4!I a' !$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`ftfdP l3rFrAfW}Wf_迗  2 h幟YTxg& fa0jW33۹ G.%/Nޱ߰_Y 
tn
r' t
( scr)S0_[f
ax
ae[  t@
Êβ
hsڱh4	X_ˀ t bQhӰԑYtM
uS"@}$L[} Oh- N	r!?
$4>)uh%|d?h52)ޟ&_
-t  ƕY6{D	GߊD	#;1_4/_7/:P,=F@.7 7:772Gr>QOReUXY[ 	T!a"dl#g$=3Ef% ff UCES t HG)  !t`E@a2J!a\t+_ @uY-@ u@这stF 

8  0!S]2
^e!ddf0  t[fp %J  B2ܕ* qfd0ؐ tD-㲾k=M tD B&G& r跲@UH=F|a' f   fif   u"'XBP#I t8 t%PRNZX]!qvp"fPVe\'h+r/hufq ^k  t! E  Z! '-c2= 2   Ъ&p1sx%f(`!CãwZhR >Q n hK< zfzP'E'P (g!{:fFfGR5G:g< t~	 .f_ø|> I/GfF< ucA1G' W?*F
p ( ?片z
?@{?`
@f3ɋRD $f;3L MB 
@_@j3U4
3
p @a>`SC 3
w TQT!ZB"QPbF2  `FfY$ff>[Fr	f_@@f ?e#~dg&GLUPV` 0%vB+++Q+Ǖ(	((123ff20.$gNgVnq	f0J@~*qfWa 4fV2Ao
035q2f^
k+f_rBi _^XɷPV"'ϊPfSfQfRfVr R4SSS*S~Sgf&ǇB6Ǉ bR2Տ R
"!P&B(@G~G@bRH B@t@g`ajT@y@rtY3 ~ rW t	 @@t zPf& _ t=תf	 u&Nd,fV7 Sf^5 ф@} -锲20 ߎf) 
gf;tzgf=f3Jbfwfϱt
    2 1@`S@a@fBfߨ t1f^fZfYf_[f`u PwKFa蟩ff#ffдgL rfpa,`-RQ<t2*f3hѦ,OfuD1d9g> t'ht  rmI2qR u_Y [pCMc7LW \nzf1D"_1$&~vEjMM(t_

A
r:fu%_X0r2F G0r/8u/ fZYs"~$A     '47        _PS葽  ͽp [Xr讽 S$}g菽0zl4$Hp  M Dpʳ;)A4)))\))kJ)#8ͥNtt/)VsP{ ? t r=G̐5+?+<+:8+#r+q0rQZǂY1LPtD65+O5
 22fZRLR   ZFfPS7`Tl&C! r
Xp@@a	[fQ[
u	h*yNoIf;tAs34`dVf`Ȱuas輤1t-r(8) <u0;u00O `
РG`ћ !gpA]P	!gf>tq  u7gf_!Ѵýb!gߛ!faQfVWo,!Ϲ`f$؃<t<}9Qoa YqpS%
f?u n}!!C߀06	 Y PQ1fWhd ? </({rhMLoR"ZY0Vs	!<n@!*g@ F U
Y]W,pj,u
mq+fPfAS0t0q͂Z.%tV
fff&{^q
UJ 7SQ"» h
<wNOf9WaCfG?:l	Ղf_1Ap3pN  Y[R֡<vmA
GtR}s?Op~ۊ؋h	:5BhEf_Zp Pt`iXs SRrb9wcw Z[P0fXf^P1aM䞌@@t8B`d?oD@tB*!!!q$1EZzEf`tfdP lSIMWuUf>fCp  pܾf ;w(h0oX@fapp !f31?SECUtIfuffdxqT  R Ph%|'X;ذV 
u?I+f%QX9!uOB-@ OY@ΓUh,/d.S%!sGt<S蝳
 _TTV{&V[tP#V[lXT<Mt/h7'
wRL>AG= "%= n =
=ufpd{>>@ ƀ %]j#ffw	b#
%On& @{f_r@'Bf$g&$ ff%g&	 t0ǁ  #9W$IfGtt2t~tyf% Kp&鏘 f`8a ,,0x?xv f1^u`4
f~ rF`_jr>0:t, pur%prQY	 аc e Y% 
ДtR`A
A!:0.A_2 r&&"

rr(|@lRVÐ
\ _rP#j   t
ff;t;2
 + t D@@D.+^@[нP<gaq$FG@V ߌ،w	0R uB	
ff!` 


fffLp pB
gr迒C
`fPοfXA3aq&3 vڰR%h"y1/G~fQVP61`7:u"Z-*.M$f+,L 1fY7@? w.	A_S 
fUfp>	 --

f+0f
"'f]^ -##贂 /I?Xv O?An@u%f  '  
@$$$$$Y3\[Yxrhy=tf \B&{q\A5:
R




gŧVl2l9l^lfrheRwwP& MnsO/iy t@2lfV0f^AcgsJ@A91pln	`   ;a ѐ   i "`x}6f:!!	"q&ǭ

S

s 
pf>_ r @  Z8fe 
ls̸Ћfff_lAIff޼dϨhog81)^Ø@s@Ka]OLG [/KF!%QqVW0tCu*!+1΂_ f kͳ,@2r1 ?6
 ω`f6v#!s
s7N7`a GE؀ˑAGa%êQO  3!4f;G/u Yб?.D&Dh錿UQr>?S@g&5	P7fZ!8RQvPܟ `ff@  R!$^>   &3Ҁ(FffZo5f 
߄
萤
__?_7Yt@6@VQSv>f"
 O9B1\#hHQ  ? __T_[1)Z`V/#	
`R  eB   MWVQh -=
j Y^_S  2ۊ~ F`&+ؾ8u `&
0Y[fPWQ)t))P)fX"pY_fXkذ/KfV}f`f&\ta d G&P&Y` X v
``.f&tr&&faõr6r5] P$s  XY
 At   Pfh|'Ք X(10?u쨀t݁	<u <u õr+r&h#r D8&&t2QOrr,6r%}]zpPqu`0"" QYatP &` Ob v~%'/D~&* r!%%F%&&a cRjqpMZQR_r#*H)t2_в`bٵƀtqrultE@>ZYh*#s,   h6GOwPa
/r#
35E64 #C$Pٸ Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGS`1o[&M.2` t
$w/`#S[>5 U>WW =4>fRo2ɿgbfZr} pvw5 &E
o, C!	A	2ah%|
%00`P 0S!^%Pg  Da`6(    j aV魆ī^`W  3 _r-"}2˸ fD}EDCՀ wB DB O D D4rruX 3W2&*G_YS	 蛾 ?&*P.u&}Zu&E_[úKH TZNF  20<Otb	B<tmPێ:R:!:IrPF"Tѯ: r1 r, hOdd:SQt
pujt)u$<Pt+o'KuҴqayB@]Y[Qw @s"suDa~Y+V o^W mQfR hO2etD/>(I>>rN|UtGV@u 5^t1V?h*N_ 6f1^Df@h  D ; Z x     0NmA݊$
Pdu	q  52̿O,Xrÿ	 > H豙ȃI蟙J蘙2ȉT' ﳹŹSQRf⤋ .xZp"ea  e`)c$tr+ccR] *0hr/hEϰd/(#/J+(*f(fYhR`k/n Sf>lQPH_ug(20?&fá ݖ d̀[`-r(1ˉQqˉProzryq#tr?fSfFfVfWp0>f9t  tf<b @` f  f`fff!02g&g
~fKfRg gre h7Ur6 >Vh4
a5f_qfYf[` r  sZfbXPSfRj07W6uLt;wEf6fPf8 p<־g&bP Bfg&rf.j0  oZ[XfWPu
 f   酀> Àff`g0? t]ǀ t
t@  f?t
 :  
@(Y! _  f` ; 6fyrv`gGwf3ې ofPf`kfPr:p> ff0;w!fVg&f^ufFtf1!Q.Ȋ$pft Qȟg&$@<%D&v@<f=ATADtlf 9&Ǉ ǫs  S3a  讓b u1 PD 0h3ɻE@s qnE`۸Up EGWP XUЩ.>:   ub >u `
`
߅ۡ	z`p$ v0

ޒ$_Rff%f
PCf_LQ #g&Ɵ h\DTH|BqUPft"eTfX2bXj׸0qc/clP\1B 	   U
V  C9BV *#tIyC ي	
ڄ
Ch2
O ׿>pMFfff+fMRh0?bf-Effzfófq  PAMSuff>dr^ tq"wS0pfPEbX>¸  f.|	h! "\f#nhP?WVf1?rY 5E6yP < u}sϏrff f^0\Y0o
oh.BsE<u@
P2
`Ϸvf,tbI0*#y" `觅c<tD"ЎzQIxr&߀=t tV" &GF^rYՃ"Ӵ\Aؾ玈SdV07 	0^4ϳ!
9 
:?|2Ȼ ZH'ó
_X
_	.P P	

_


'h!ױPL~̀R ĺZ!Rغ0 t@Pbythذ t&?oXW8>ޙڻgVl͓ͧ> 9K g?!{b=9q
$P͏T3!D W99$WˢM̴TAT(TTNTT[KTՔj̮̑'T;DzԻw0T`ج!^&T0ARf.\/u{!uM<~w2.f&@\bXH
< tOR\af u
f
uf 7S͇CeS dذs袈r%Sw!|;xV4tڠ ? u_Q[x\f[pۆÎ ԆUQrt t߀uql=At U>"jwfle s	7x.ho0ZA@ft{`6܌uOuv$q^zsl.|@o|OvjcGvhhr h	@ h_XfVtWR$"Q$<QZ0Yf^SQRd\_SZY[!7kS""<àP=p-f`r%Qrr/Q?fc
Я]
f_
fBqfЌUǃu3F 6  h/8 
~tJ]
/t"(L	_
f c
 ,m1u]ޮr21]QWRHuO@rJU&
uuـп t&
&&ƅ]
HOr½X_YUfV4MOqT3I^TV	


 @`QW3 qot#f1% #d f  _.fUf.6f]7f]** End SetActiveDisplays: \ R$0t5x )ڊ#и 8t k8ud s 7S{[00t@uPSQ2tM35P  豂@tw @# Pt}  <u
  u@: 	
3a0p  - CPSAS@Pр|o p|R	o9
SR/xPsHxP$ Gx8xċ؀ 7xX/xXxZRwj
M w``wa t{wP ÀwXw QRPS߸ [X"3t V
qVf`p
u&wzr
u02,RWi_Zr [~T&&&E&]1  fa
s @
/)"7c??q SQ+7fRfWU]fS-SW_ð ˹`R  .7t rH r0*tf G=kftd*` Ok>qnqP >@fPvfWrP]4qXxrP  f_ڰQt`xr/`?t"f ITAfgfaP  g&FfG2ga C Yp`t' tfǁkqd 
 kgtXWH=&M_0g.g͵  Ճ? t0;r+g_CC 0| wuuHt~ fC°  6_0" Y\K ۢaDtv@6m 1@g Atu Q!钀j3 
u#Qh%`
u"Qh59u
3YvuC*u~r'p vruDqtg_&OPhN}ih1Q#`yUu5aiPSǷtb@LdtTfte+AQSS+rqZ V0rZfPQ> uιPc r\d?`YR3CtC>r-`w 0 rTeҊ1 r
-u`d/ aoP rdItf s`}QRf3ZYbNr&r!ww3r r	gv`PRcӀt`''r㺞Zh`PQ~s
d Sr	r\!V>RP    dtgf0~yuwR Z }hUk!C Z777.a Q " Y0Y `2 ,u P h4R

Z@u⋋ذ* o r`~ t-0 Ib1 ߋRĮR  rDC	$ 4P>jFS t3306J*@` ;R{
t#4 c ttXQÈw(xQRWV۹+3"a^_Z$"#31$G<u
t$V 4^ûW _ '"  !(<t)۹ 	
R
q0P#H	
g&/1q;aO-r;PPt;(Xó ݕJ2ueAneRV$rN ;rCr<,	r32;trr;w}Ҁsڋ^ZW
`j  а 0u
˾  yu B f!o uf_& J332[2t@@ 0	rn
$	"
uƋ߱d;sRZ3QFqF2t
2tAu	u˸
S_ø
_.W.p.q.q.q.`r.#.RE|ذVPCsÛT! `S0ff%|h f
 1 fȺ4Af# uOtph\f   t(,#%9tYp\!! 71 ȁe0 t^f.	fuЎYf4! 5ߤ߲$42H^ ~CfW Rfg& uU8  * #h:f۸_  G  /OffSV  <r<whR >Q n f `@lP<Z0%h_rh 7< gPU2P^f[Ð_y4  O0f`anú:tpVF	@d `Ƈ)1 İD rºdߩ u"At$
   tў 	sf 0 % @H U	g&g&~`0& % &%cfQP(*.d0W0hf#fl%P.nic8r!l''  
 tf 3 Q'
ĿfP~?vfjfS	-v P'α' rp
n1?fl
s#h?qfҨf3 %x3C؁SWV#t6T;p%ȿ ffr33u^!3һX3t@s9r M
'` ( h%!`! 
 * 4*P&TQ/%c@RM
@lṠ#H&O$0R PAW2沬2PDðXђf\Zh~Df`h*s =$[f2Qgfa/i   &ii
oÀ>ot`o: ı 
8sp# 5Ltю} ГV$<
v
ط  )o tǀ>a t o$
ؐ (oh/
$$ u
d t㋷uL`ꊰg^hh~t

 d	n	
s	 n[+ a&be ab>b u
8wкTCs#YbtK_PR怺NPX@t?IPS` Ap                                                                                                                                                                ` غ   nBnnntnJFn aS ˻[ À 37!C &?!Cu3R .Z0hT0ĸfY:#n "#X#F##P#`&&::. ">&~".pu	 uQ 
 ^ts+t@QWP; 02`ޝhX@.X=X@uX_Y!܊u{p$ qP!`. $>:rP*/aXt	auð6_C @B T ASQgffg tHu.g :ff3g&ffffߋgf?ff@@<(.&ߋgfBfsDP
hj""
4	fRc6U0 u

(
uXڵO0fZ/؂f  f؃ ttNp Mfp 00繍~PfRÃt%tg0&g!ggf`fZRft9tg>E @ t9g5CggfRVWf),g>E %^g> !P(^d`g
ز
U.   *HfRR"Q2` t1/YZJ*qU@60X2) P K^g%3S:P                                                          `     TO>f  tad            %  ?p                                                                                      d        
 S2X3                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй Ys# hfP u	fXc  h ZY[Xg&ǅF C9   Ã tfPfS
u	{p  踂f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tR>tKFtETfu
L0]t`t	dpX  f]ZYPSR uyvryv&L2qStN tCu+?7:ǅ%. *'<t<  
Z"Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3ҠKji  :Kt ffKfj+)a3  `49f 'D%g$ЊFb	踐E F\r4Vu'v< D T^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
FfKf.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfVD MfKFt!hu\gvu U>tU6f뿢D@)_a[af^f!aFV  ^SQ  ?e0Qa@9taT% EG跆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRVOu2xr QERi ߳ u  ;&KpISK]0`@h1	_S( kQ  `f3۹ Wfs_Ձ@T@{" 2: 1Bj0 f=EFfC`?	5	tt$<GvHxs ?!"Ⱦ
Ќ (o
d
wu+
1?Mviqp1vuZ/'7FF^vu #*VF$^fȢO__o0V mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6ӻs=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢrÿrPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`krCfaf`  ufc3pֻ0v X f!6j,gfwP׋F GPrR(W-n<AvPUf;f>n, uf% j ffZ	Çf苇y{, a ufz蘇fr,鸀, 
 j,z` 2_v1Onf?WfA_fr1f
={rGXZ0r2Ȇf`_ rRfGf>|,f r<
r7 	Eg&V0fqf+Ug&D
3GRNafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXhS( kQ  @Zf_ >;u<MaPS- pu߿;;` ;;;U/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; EPE j0fdQu!;! ȃ uddfd԰  >P6ۡSd d?dP 剱(;;EP:Ug&t=` T=f]t,>@u%ttt t	tf߃N tF Cr@uAzalaCs
 1Qh 6`uF w. u$
TVWێeS~ t`rt?{XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;afWYдe*&;8fw*fF*2t*܊e&;fX^fY[wKG'!(; ߰k" b  ĀuBTv;|  tB2|l}SQVWU&F tF r]_^Y[LS-120ZIP 250PSQSRV:1:2:ِ2Qؑ2PKp
Bx
6~
ߋ5	<;2Eik>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfGW(`*X*Xu ͠HAZY[0^`Fu ;QH;;;w;;0 RW1h7

_} tEc]/_Z[M-SysPDiskOnKeyP#jBI ut @  f<x fP ߳f(0QA"`z|= 2r 0w"1s? ?sU3IH ?$ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&o,c-\w?t,f_ Aï% rLTf<?(ժP5Qe}$ a[
1p<p<? t0h|4t u= u2${3@Af?MpI`N 
fXuײU?0 00J0000FF 	  FPRdoK@3W2>#>;2>
8?Z_Y<hG; 4  h }S| }ZXSW0+@0s!$?
u$˄[ð_ - 8i B g`	qAq 	  q
		 
	 						p
 fWQ OYf_qD=f; D=;FD
$>;%
_D
%n;IbϙΉs@s
<rI`d
Qr7R[USBSu\ t t
U	 	`;KTB <w9١ p arQrY< C0'V % 7F`2PD QrIt2QfFzafAY{rSfigf^qf@FH\
؀e܉\b$K
prA
x @
`0
!?
0
"osTq
aWa'"CS#PD=q0*W.?43'T}2'ú0oZ(Z/(
_7
qO_=/%t9/T$RQ$2Q	@ ?WK@RP2 s с>`u ?g&` T=
XS<(fʐA &~ yj6;  r}fPQttA3>~f+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9??,B3U+*/G/%QfPxh`gf<fXY"N0\OސJ?;G7/Osc`MoDA @Ac7e=S$l=38%p;[t `ot ``;D?$
ƈDaz ϋP!l r
9rYAݹߖ /p%tyFIðtT= 2:t+:u hYoety~(u~(rt@`=@t`=t`=`	t`= `6`oWfa0V
<8dtd}rـo<8DtD$PQFxPhrޠdl^SQEO	8t`g	G	t҅< !" !  3  @nO 

  !vv xQfWf>_l Fo'#fW_YØ^PSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYgf[fRfVgfeG`-PgeG,΁fQ"!
6'Ps[ ,P!V _f^V;;faf]	6&ys'&P/rR<vRr30
?ge t_0 AO@ra'P[180m6*i%AfgfC  gf	 
{s>ra8PQu:YrPiAbp
fP&s
f	 
f
 Q{ 
!U?Wv'eGseG`~i _VRP W31P gZ!
.
(#5W0
S
B֭
%?@q}r$$ <
`flpcC4Cs!hccoreeJ1*A<tK< uMf۾5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
ww?`}pRqx& r&L&T <|PFh3P(Pf_\{3VAf?_ffXqf 
~qfXuײ? fffW} Nfqc:f˴p]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF>reCR~C5P5PIi7+6p6P b!1fgY♠
W
KA

$I#j
pI QY6BeQep+	Y	xr /
U2WQ
seSAO}7%tJ?wA0PZ`S1_Xf񇟘Bu _
u }% 
 !g!%O% 5Ϟ     }3f߁  PYt 	z2fp uf]Zqtp  tfq f	bCfff@Orfurffyɐ+f%ЮQStf

 sహPqr`QR0cDf3fAp@yHR
fâPXpAw f>Q`r/fC
@;S&7 !f P`0U{u

C	ݠ3ݎfqC &;" PB3
q aa!@%[ppxtfmf RQ)`(! BRUu@$#%7"*E   us5# r,Hr'7
 NPSSg
#-@P)'C,R"G-
"10v)%
!02 }Vf>/`˝8?梿&|Bf P?z!?ψDpu%f<E t
t
t&z[ sPf
Z͉6/- gFq	g7zgFq gFyzps b3|B,3u +|~0+   < t~  ;vȉq tv  f@-CffQgwf
GGg_G-  	R
 Q
Gfyǁ0f{fHfb_f@@I1&~ t@q qg f<00SfRg ofE3A,3;	@t`$2f&F t	DG^^^!  sf@Q	Ffy  ǀ`G
  A !Iy>					d{+ః	2@	nO	@	D@4z 2@Bv462=fA7Km"xff59h"hRa{TmboHfuZ<0i }f&m$ِuZ@U t`)]% efd	W\Dyu=Fm t5f\=lf  f+8f;rߔ     ߔߔ֔ЁTЁv6_W~____T&ti@___l_YS_ _________|___b _____Y__l_XP_oS"^______YuyU=
6Wc
   ____ 				O	ScfSc [=   vA	ws  q@ D `@  "2E `i߀ @w
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfe@Q_faEA	>dlucl}@fQfCdfld 2Fhlil%PWf~;f+Va++ g*@ f=? ЖfS	XAOhvUftQh_;adf /p1$4	C:cl3
f
?)I4ө% 
и@tBgՠEuGߋf>%2ggefFfGff!g {@] f2+ǐfj-Ѿ@t#f+ qHt-Af
 uh7gk))Xt(8{f	 p~7el A}flfQ_-c;q `u @Gu
gele<>t|f Wflr lsc`u1ge~M 	C =OBG рK~f  O$<P{bt t
@ {>hP
>i
 PHj		%PgP3- 	 ?D9D
eVfrFsr?2 r" f( rFĀu&&P'Psp_"Sge8Ftff;reqK0D$O y0 ,d0fWl@c 0dq	f`fI! W jgbg_$"/ւaj_`eOeW$Gb plgq2bY!BfβA G1ROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6T!
fqr   2!	A}.>  
?  < x uuo @       St[Pu&u u!KruBuBӉ ?C > XPS tuuu>uuu uR[ CruKWuuuuQ	`PK`
3ۊ؀`u&svutv3 upVSD@t	V[^0QVEug&"шupJ4fu1uq]4S1péu谫F[^PSVfU>EKS>zv>Kϳ&wvFt(
ߠuEg&uuN[艳ߡf]^Vt>uu r1vu{w%0r~@!E6|0aSuP  [6̨Waƪi`z2٩<ОQ	2pPUt1vuIh[ZuKzvyvfPSQxvĉY#\SPufwf3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvbyLr;qeurqVW@fFtAQ څt(PǴ:?vvu 
  gXfCYೋqq q9~ w2vvkYⷠuv`Ct&tv8r #>t}Pw
$_x#0%uxv.v2 uf? t<CP<tSQ@K߰&Y[ـ u
lq| ` - ~ i8 @` T@8h
@ U0p%	qk l 
		
							
 

 }fWQf{&D=^QYf_侁gD5 ;6;;yߣsR;Py``}D
$&;
ĈD
 1Fs fg&|5 EBr`耿r  a`|	 		M|0R		`R}H\
 {;
܉\se bb}Qoab}f`衬軣g&`vr ql=Br`h >;pt `t `t;D$
ƈDfl-Pfp& &~p;_W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;螫轞j(f
T= &P蛿rjrp`u6;; 6 rDQfP.?f.6;ǀ+܉fX2fXYffrgh*`	[ Y* 		Ӌ$	hb %WG0F
/
PsV ` !sJ%|=td%"t+T=:ur?`B(uq!(~rg`=@t`=t`=`	t`= .`h7_262ogfaaoV߶PCL	;t	wPAq$R}X <R^ASQ2|O	8tg	G	Y[\i0   0    |Ro d q n  A` о 00 3`  
& Aa %  	%
0 #
	"*
| 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
:aT S<R"G 3D%M TVaX'K8'(XAIc  WI O  x fSffV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 f^fYf[ f߰ PfHzRf3u#Muf;ku
 @ fC  ZwW fu$ -UT fP{%ffXrdqPt@5f90f  fm
Wf fNf_AS0>efzr@i!ffff3  0[Я  @ Ԁ ت  @\ t@dl fVf$f&~   wt   
fD`fd.f^<tP#ˉ Q5 R*Nh%|4<t
t %܊SS( kQ ᠠ Qޠ$0s@f"E$!4",޶-cPS1#|&3M38t< t 4 v-g#tt 0&#SV>?EgV8p U< @DHPMr:t"`B-w?u-È.GGa?;-rfTDaff DI	fAKfg8u#HDqQrf1s
f@ (`+1HSHPS'} <O&?}`f`h0H|(!G@<<t<=t<>t<Ft<Gt
c55
qGN1Z]    %`M3of0Va? tf<]  $ fcP   t#@rfuHB aqftQS0^fC`BUބc U44`f&; f>/vq% }! eIf!ig~uPi

qCDq; ^r
ɩrC
Ro-?  &|f 6zwf  sZqf9Qu gF9zu 9u
gF9tXz2/g-tvVf>Q  rxsFf!` gFqzg^ g`A  {F|q 3:`kFC t	f;QoG;;f@2M3
 "4 !Ix					D+I@i	@	nO	@	r&z+|~   0a~ }BM ;vȉq tv  fm@ 
fn`3fQgG p gG-PA	q?Gfxi@Uf@՛f&Y8"!1gGA&~@wt@ afBr SfRqf3_9!^5{	@ SfYtt.M.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationzN1OS@eP%p`"ѣt2Cqt"~Af%  =  ҟ <pdt<tH<tN?<tL800uxujuTfPF<:f!a<ISGu%fц}	f`C s
gJНRVfUf❁z f6bkt*pGt
B  ` nou]hC%t.^At#Oǣ4ǣo%>ӥNR#` @ İk-% 1` $Gf]]aUP].)`t411wgf#f  ϊfgR1tx-T	!,	a'""ԕR4b#SЏJ
>PeY]uxt*"IT$$*	g&<ж1	a?5c	07Zt$N<tԢ/)
`FDO0E	@HK30Rr+5$A pT6g%q6jqf$ ;g[Sy1l4?lSQ@	r#-<0~^W:XXߙ`q @O0 u(P*P  rwyr} Yr)ffWRdh݋Zf_rJPSƊflp>8Pu	1Pil3 hl&P%P[X} &zs	wf d w 68PBA*PÈ`
 fd!7P! ȃ ud|d~fdf@66`>>á0qdffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
׽s1|SQVƾ`tـ?龰&D~'fATfffXs2B	x3p&t&L5P 6P uY±iވ5Pa>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	F&F/  	_&} &_Z+S/-e`&W
[`9t4h|4t1
&u &uf`Q?؎@܀wgapq23ag&s&C#}g 0WFSf3Byc@eC
uK[ðlP><u躿<  It  <?Xh0f  `R0ff%?fДEg&0F Fl)p0
ZlQTd rcYБ	
D.K P2Xöf fпf% ? 0f
P$}Z  fPg&1~{!ۅCXC C q#sB _&   o&!z ;t4 &  rtuft! X&OVbC4"Bt{'B(BuBA 	s %I+0%sj vVS"f bm _XSV1 	 h^)CAEsd^ ѣ%	g&KZ
7CZLs}! 3Z  V
P<
?t?a$g&Q?ffÑQ$rcfv0< u@ 
f  Lf  aG,(
 aGf%f
  
rGaO8b <fT &tf$B4A5 4 Q6@f
nr<f' fv  f f&Ʋ
P!h J2T  G
 s	<W% <t+f SL7 %u @: R
O	 z,R
/r=?r>f{	%r
 UPBg %O f+f0p aUErEF?k<p)  
 :C `#/ujR$3''pfp `4"b',f2"u#/   sZ ] [ \   z @ b  L ` oa e^ +@  A @c 7g 2e @ _uf @ @  k i^j  @(T @  ˀ >  @ a  `6EgVf.;P ?!f! ;C@   | 'U$ 0  f 
ܸAfUP	Y	]	a\ L IfQ  M@ BIf$  gf  Q0ޡƀ 
L@f;sgf9t}pLf1#`}e?fif-q_?
 4P`Sf3 hT/hĭu7 fr	tf1dGIR 4@ Х t؃ u˳ `P`RԡdTf?fd<Rfd?8RDA$RA"] uzwhhlŏW!}*w!襐貏~xf~sad@-PfXQJ d ]	 ! W Q %_ " &:܁&k PaQRVWQrR  P% $x>00V %&qw( Xf@@X!	u*idie>e  6ep s-1	'葭w`"O- ow>D:P?!ƶ$Pa33zn!	%buQOVS&S?3'1uF*IG# Gu`O$<܀u ߼PΗ;tF	t
 H 0.Kd:u>? u4d> u	1 t#uhuf@1ddFރu<u2!^u	I9 _^Zg&8!@zu	g&g B%DtFsPVS u h`|6^RVWdu^_7»* 11u Ufz /eosRox?f]1; `T`r;f.;t3Uuf=#]f
W `?aË= v	 +v93f́  ffvP  6^Ã tL;Sg ݉ Pǋ;@tߺ c.mҠrfѓr9 w0`b h TUʑafϋfo ~fffROMIfMAGE;u;W{tg!3С3KPQ@J 2fGXZYXu}wa`+GSG p "2hct"t з t	V M cu'f t!w{
G940Gfԣ fCf)7O0E0r RD;gfԷ  i 1"na)- pHP,.`󻀽 
>p?aPrbn ##V  A7v P`(08@PHX`SV.etv4q^pMQ Pu>hgSR $u<v
7i:,j [gʀ 77wG`r )0Ppᅁg wS	lp4pwOh`_:gw/$Dp
Q!	 tw$dh&
@w&F\orٶуt<o}rD肿odr%#LioKWrQ,Po2s
 J?kh_1	o=7	t Tn G2?6#n
uEP1P$EMXp Z$,\q[p&p&uu ڠ ? QаVb  ?t<NGfwVf搩fP{f A5 kr cf\GR8Б #f^p0Up f
 D]&'00p/f'	߱sU&u  ]  
4!MD 0U ab bG !	O "SQFZ wೃNZhFZqR  >b !f '| d %X\,CR @F${`q0suO4ef="Btށ 'Bt(B!u0$pY ,Xb{ *RfDvfk xfgߋEP^NZ&*b			fϵ5 Wf>)  yq_Qp@f% kPffE/2f592p`x v)` ;sff+c f-6>at
3T1I!APk
 !
f`=ff1 A6 fffp	f9r
f)p @VVf$4VfU^  $fӃ\Qofq+f%=x h1
ϖ[_縸\/)]/If;@t> u Q w&1*:& ~ PS!
Xh fm .Ӡ .8?r
/Q

hհ>@t t   _fp+SQ	@0*p=tuf_ rP9%B0<s<0v0uo@ pN_R  ? OfLSdx	 r<6%U0f0u @0Q f}@ Y#h<`w$Oh/`C! `! ]>2߻ftg:Gvg_fg譶V !bтIf0ࢂf
f~H( X3W0?t%h0H@	g&G/ 6X(Jp.p tpbaf
="t
p $C7s;2Zh0)@ffߋfȐ62Ƞ1\* w* GfGݑW`1dȣc@tʱUax3w6N=t=tO"tC hTOr#
uU0 fd&2
. Q:sб ; nu5fuHpwzn@2xif#~ s<5	u uztI S01VPt)fufKn D	`s4te[}0uuWrZtuL#[P1Af,FQ~f%
&|
 =s uv0_m  u*f&mB  s~f*=RSDTu}`w_$!f=FACPt?f;vVf!Ow u-Cѧ(b D!+4T u ,3$pSuüPpf ~fG u	ClP`g3 W23f_
 G	ZCpu#f0₄ ~0铠릿gfFffۃ>u2ff@  6Rpg61p>gp^0&0fPՋ>BG0AR ZR   P&abpZ&&FdXPR< u@S_RgtXr),uRG`SQr9R'訴$8t9Y[	tr$VO㰆HAr(QSFr(!sq轳trp@ppq[`irDrT~f}iY0Yd>:t	[ fa !  rTv0La@f`yt>A _{ G{faa~h'`q/e`>wkO?/P#.4蚑 6ð@ð Wj@Ȱ蛿g&Cp&Cf  @ڀ@t} G ڠH!	W sf_ҞVfWbq{5o@Rg@g<PC^fZf3gfACDff@r츟g@?CoP@Љ Qg&;t4g&Ct,g&Cf;4@d$<12Yf
t
g&:#tfCfYFa;tft{ S e޴r7fg&F t+_`mr!f`Gag&O@` Nb O cz_QfVuu+rB f Ur(al
"Ȁ$
Q3Ў{tGz@a U\ U@<a/8r p312Kˠ P0U `<r<9Pŀ&0Yqtuq "t؀><:/sº7g  UvPOȇF X PSø p&<Ȍp :Ȏ؎[XPSء<Ȏa@s`5٤}q<  ;} /d3 97) E2 P# d 22	 
vrRu见&y`~0š?EgP,~fX                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  `    ( /Q(     W    ς  g    h XX k  ;p    / -hD [r/F ]jtS          P     @     %X%H_&                                                                                  3f3ۻ  f@yfg!)A  f" 0 gf+ >n `h7fPpu	fXc  h  fUf&af&>` 6a  !ŀX[ &SP`@ /'a[&Ջ&WP `XP&EX% &E{_YǨ o2oooǸoc< u0 < k <u2<a
 1                                                               UPRPRVFZX˾0RR30ZO                               a{ 
h3   f`ffot$op$or쪺  .<t
../ NA NfafPSRVIf﬿pr؀tU./?tA
 NUNh7]Od^Z[fXǿ4 h/_À> t%f
`ffsPSfQW C_fY[Xȁ ȁ?ø@PRBZ B3 $ `%>&%	 
  3  t!   fQRW0_Zr #O	PR
fPT ffXfP
 a$>$
` fh/&` ,/ &/   /0/1/ / /aÿPfW @ f  g&?t"g&Gbg&Gbu  1 uf   κ( 
uf_ a$$
a wC PB B;ra`_Aqͱ?},hR/ >Q n S7Qaﺵ* : ,`
222Rq8ĺZP ,}ȡ%(؁~ Ë34 b0g&D4E*
 <B0' 0hs" 9f`1fL2f3f% P
 0p!P!q  f
 `0XX!Jf`1"f gff%?? gffP `BaPPfS,(CP0
K   gCw CIhΟlh2 Xg&CcfXCfQPfV uf  guugf>u
 ߻Pf^X A
f55  fot4 p  P7hx,fl:f&_'qfh@ hl^'\}h%|&T@d&OOh?f3/
&G4@FtGGrBFB
6
fy_g  !hfLW  gݰh*A   dGdKh=< d>il thLFOndHRyh6dICdJ͡ WfZ+'Qfff f"% fdSl41;AfdWlffa6ddlw f`^ t fdclh0fw 0[l @b_lfd}W2f; efYWf f_#B*J"eRd辁 ҁoZPQ:_uq"yqC*YYWAK;T/;  t2&>Q1  ;j3 ?hmoB4=_Rb{ hcrUZ*r\Z~ &@ t@s@p>'E@ r>cr>ZRn%t;7Tg q0 b0  Pu<wN$<w	Nf<ucW> tUPuR uIК/B<t>Zt9u2C8r- qOr!\m'l+t nG!pn_ n@ī.J+tZcgtK7r3*Ȼ s=0G <u$
GPhOP 2A.t*G?"\r030*t~t讳*	
~   SQVȾJ@ 8t"8tr^WY[At,&
u>ut
$菲sE t> u.."t$	&
Ps@ #
t舳`ȷ3Ұ	>!2
ҧD6LtHp{1߿0K K'tCƠ@* # 0< t'$ } 
u脲a>^{ 	 >t -t0z P ug *膴t%覷r0.> uBu
 #胿i  (Kt#_kr1 `ͨJbtV 
ӵr-5GF(tBH00/-rŌ1 //e5't_h5tP ]rB@13ǰ26蔰ssP=%
za "275 L45B#?tzu >3طc^tb;sW;sQa3u	*u"
m`uEñ"
232}Q 2! à2!:訲to 賰	) o!)PA5t>XSfW/~`
&t_8؊f_[Li("frsg]!  r&
Y
!< u)50
9+u$$t$
 $!P#Q  W 7
!|P0`Pàu :f`;؎ R_fb Zlfa)@Enñ K @(00̾k0Ef" pǞ  D  &Et"D  $D( s `ف&tȀ ׃4>2@"Q
g& 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m ?
 m pj's 0a` ar * | XOQ۰a		? ak # $$<@t"h/KuKfZroK&Ku`.>Gst&3r	#r/QQ=aô`prr X ? 1tr<0vq;w#8:9=\Mϋa){fRQS讉[YfZt'0! tu
| t輷a0r&JC
ADjGp  Jf` h!_Vruf>rffff `|݋frlr<fffHff#f+ִ f;wf!3g&Sc
uff+ʀT
T 0?`8P%,Ⱥ:#%h 
ف     t(  9$^Xt
 %@  Pé }( @63 %tVaGf3pE faf3uSff  f*%w   HQ0X
 WQR.#_ ӑll3k%߰Q#cY3#ˆ`` p9RP)5  %?W
 P0ZbRhΟ,h2LDQ
  =$uv # `]
 G)߀
 )*Rw=u
ff% -ﾑ%Z w(w Ih	tEf0 tFf6 %f$f#a $% 5 q PfQ#
 PPf` &`1'3)uu
Դq(qf+ZYf̰S(4 (T T(h7';Xjb,)h0[f~_ f,RvQ-U(@tP5ADfX{4 
-V(SfQR3  u 6@( @u(АϨt t
n10'@
 7uf%1fr 3tmsZfR(b4,a4f R5 @@tf@ f%'fy (ޢ { u z kQRP<>q;t=I% tfm t? ?q% p9,.028 -  OQV0]*/W/2|ywRP%Bx8*),	/_/f|( ڭx^zQwzi(R/w8OLT܊N%0)m/S_/bZ++/`ȺmB ph  q&a0u1 R  
ݡhB"3 Q  7~@!0RG 1PfffX f;f́0`ذpIO H ` 
 !P,,,	, 33 $#_ ) 	   R_f),of U' fxqGfAJ4If%\h f-\|g@0[ U   E1D6
p
f),	 K%j(	!	v#	0 [Q$% = u
= uL=  `& @Q=W',jfkS3uR@R@?@ 0- (P_0AP 0 qPD eQ L ,A0>48h!g@Ohf#BBw0t`t薠tB&#Rw  Di! h0HS( kQ  PG  0%f_X V%N0 fM M  t pw> u" ^QWV   f   ^_Y
f`hT_fUfA"%=t=:V,hjBofFfAf.::u"f  f +Ц
  Q=2UfE_ p^QPf2fa`{ ffYh9?  ?3)tD
Ahy	7:faP pDFf$g@9 gff
3ҐtЬ0fP@wPx>!j      Qf8оhTrfùѹR'
0
yhT3st*2	覐#N2_ u!,0  f   "0.0pp0""{@/t	!03Dfg 3psf sCJX14fVW س SRffP f
0u_^K                @     K `t0 	4ɀ$ t		T 4	x u B4K`SR@B u$Z[WPo C	VXAg_f`R
`	fޒgga fWp3f3ɿ4f0<  &P5f; XaDp종4[@ fPޫfX,fVN`JVJ7E gfw^! f^	V					:		4	^		p	W			_~'.Њf@#cy!  tO5ъa"hdsT(Q y=sYl}޶>uDJ=?tpa3SN[C vS3ۀ> ttNt:NtC  [t<w>8t,g 
&ñ øS r ÿ輚t, {聚 SNN뤊Nt rO"@5P4'fP	RANrA a	 fXjp;tp~{xP	4a϶^@t1-w&O.trwRaәt0
p;< t
;:@ k  N>@u蔙ktOaÉ  HT

pZIPߺ JC@ @P2ؾJ
s3y@s߃i  Y &
1F0^;_;a;mz:^;u;pu;th=PpP;{ˢ;`!  ;;< <ww
210;r`  	&T

v躨 >2P2z2z@~h|??tDsh凌hhrž f P92 rbŕ} <pCT
hMгf`X
b!f3//8fX	@!7"?" h1g!P`/)
4/O
H
 "	 	b"	/	(	&!_!!!p!hGTÓh6Uv$wF}˭fpBsu 2f fSRt Fo<t$rfPZtQVWrQq 0 o_^Y}TfpEf+رft
t%SygOfQ?p1 %Pp^WSQRWVh?6rGыt(
 tuu uett0uʋ^_ZY 
WV;Eb/4;ExG Cd6W p 2:> u6 FHt\o h5JT3Ҭ؋hoLB^_Fj
K̈́
{>
2
Y%
T[>T2@OHp
N(u.
~P	eϏr22ETDwT/ TFCo/ / /  OT;G<RwS2.D[0Cøa ;а4
-
fQhT0_ufY_Q P¸`0rXQ&G     &Wf&t ffBf;Pg&Gwgw~rtwRtpff@hUTASp3QgfY~gho\ƴA ГY[Ua>aPS=phtWhL42f[ Y&D` sWxG@f@ Df HfLf}Pft 8 f@@j@@}PPh o>4~ft	΃h@	wf%0frqP@t@r<t<t<XÕ,,PS$<w  .He @GC  ~ 6!sh1p	fO f$X?ðG	ן  tG	ĳVP 
XuivBD[b	qS! u
2	} p	 [eh2P ˳l	X	G	@
2q(P2
tˀa	)
$

<
Àu	<X[X ! a	؀a

2t }P@<KrKJX PR}0ڢ:JZP>1.:J /BZ s  ""
ZP@좎JJ Jq vJ_úQ R (( PB/X
	 ذ4ۋðZQSW P(_[f%{̃ 薈t7> uZK $>p u0L  -Вb_3`0(u< 8At3ar-<t)+	pu
$&4.HaCt%6t2tg&G Q !pNu蚅u>Q2&Q刐PLLLLLLLLLLL@DHLPXg{TX\dhpP HL`tPW[_cgvߍ<T\pر J KPUY]am~FKOSW[g~dl|9;>CEKZm Mà@ PP .`X!,:%  3`  PP`rȓ  !OeaYP?f 33[3#:>s  Zg Mcg:GQW<u
-,-,yޡ Q,{I_+z Q,,|q"3~訣PR~{怺NZX3Kh7]R6q	|+P|" h8TL$`ސT8! s 8{*a`O% *X   :% PP r :T9PTjOcAT= qOj99! T% O"O6O,O@O}aBOR7O{ bTO% 0.&,pO  >  &pOpO2 s 28s !c P] PSUV<2v2 Pظ A$^ Thϼ[. t>M  ^][Xhh~e2 	?s À>tiu%tOhY!duP<r7,a t
?V8P !`A@uC`_
 
 T'ò  -@q
pmep>>(f.f-Pf.q  鞶--g 2 rm b 3111ǌuyhQ.Q03ó3QS r3.QӀr_ׁ.t =^r1hu_  	`@2 
03!477;  +t
3NO+t3GNOpUNRvRR(NR쪺P aTRzSRR``p@֨
PҍXhy5hG&NUvP|SF X PS&iS&gS&eS[XPSiSgSeS ]e吥uuu&g~q pp  t[ï?x@T MP&@T@T$aK?~dL0TLдS8rdd8rS<dr
d2t艌	蝎pTNnQðv A Y}C&0X@\                                                                                                                                                                                                                                                                                                                                                                                                                                            Z p( f fo龗h8fP u	fXc  h @   foMgeuge&p #0t)fSzW Q   f[ 1u $  g
ulfem   hR >Q n|0uIe	:f f  gf&ey /-gg0&&o  P            $ >         < L h  D ` d`    ``  ػ ܢ @  `b  " 	 	H`
X \EHT o1 2L@34 0 @!                             a1    14   @  8 @@0  0 0J	 7T,#2l         Z PXYhijklmno 	

                     - 
,89:GNNO Oh/j4rf?PfSfWru  Jh9'/Tuh(wf  i@g&OZ	(f_f[fX0Z &g&fu   #Ʌ  ( wq[fwXf[XQfRVW f Q - !Q  A!!ȑf%uuf3f3f.2fffu_^fZfY_f"Q ء f' uՃ
f0PR5 % ZXPSVWfQ߃ _ي t
؀ut upf  fp  h*_dr u* pv @uf  fY_^[X`'QfWfVpff
  ffst  p$ f    vyf^f_Y# Kyu/ybR5   fPSQR	0w3q-q-fxs6x資ؠ+@ f-$<s!h8Ū !~pQt61%<@"u3GjFy
sKP v)`f>5?@
 oh ;'>>>$߀
sǺ$>> 렿fޭ2ZY>,-./01289iL      `a{{{ 3 v
wRRFa`{$a,PG3"ԯ"
P![2t*:aÜ`>@ l> l!GA lBla6$?C ! G @ A  B  $0?sF  ؎"|n  _""|  BnnnJF$a %JF{P {<{ tq ̢{P ɯ{̠̡ʣʠ |ޢ!~ {7 ?llB  ؿ{ lBB@| l@    @ l|Т|N&{ľ'|| /$а 
_@  IFFn T 	n	n	n	Un	n	n	nnn 
 || t{?{a  J{`RCd̀ɁȈ`  3nnC q
p		 nA
` nw |`4!q a4!I a' !$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KAqqNˆ+[Tω3Ԍ2lލ0XΏf`ffP 3rFrAfW}Wf_  2 hYTxg& fa0jW33۹ G.%/WNޱ
߰_Y 
tn
r' t
( scr)S0[f
ax
ae[  t@
Ê
hshMS	X_Êˀ t =bQhԑYt
u{S"@}$L[} h N,	!?
$4)uh%|d#h5Ε)ޟ&_
-t ~ ƕY6D	GD=	;1_4l/_7/:P=F@.7 7:(77Gr>eORYUXe[ 	)T!a"d#fg$=3Eڳf% ff UCES t HG)  !t`E@a2諏J!a\t+ @uY-@ u@迳ƹstF 

8  0!S蛲u2
^e!ddf~0  t[fp %J  B2* qfه0ؐ DҾkM tD B&G& rѷ]@H=F|a' f   fif   u"'XBP#I t8 t%PR怺NZX!qvp"fPVe\'h+r/hufq ^xk  t! E  ! õ'-c2={ 2   Ъ:&p1x%f(`!COãwZhR >Q n h< zfzP'E'P (g!{:fFfGR5ƟG:g< t	 .f_øo|> I/GfF< ucAڐ1G~' ?*F
 ( w?z
?@w?`
@f3ɋRD $f3L MB 
@@Ej3U4
	3
 @﷾a>`SC 3
w TQT!ZB"QPbF?2  `FfYް$fǪf>[Fr	f_@@f ?e#dg&GLUPV`~ 0%vB+++Q+Ǖ(	((123f?f20.$gNgVq	f0J@*qfWa ,4fV2A
0352f^
_k+f_rBi _^XPV"'PfSfQfRfVr R4SSS*SSgf&ǇB6ǇX bR2 R-
!PB&B(@G~G@bRH B@t@g`aT@y@frtY3 ~| r t	 @@t Pf& _ t=תf	 u&d,fV7 Sf^5 7ф@} -锲20 f) 
gf;tzgf=f3|Jbffϱt
  k  2 01@`@au@fBfߨ t1f^fZfYf[f`u PwKFa蟩ff#ffgL rfpa,`-RQ<t2*f3?hѦ,OfuD1d9g> t'ht  rmI2qR u%Y [pCMc7LW \nwf1D"_1$&~؎vEjM(t_

A
r:fu%_X0r2_xF G0r/~8u/ fZYLs"~A     '47        _PS葽 ྐ ͽp [Xr﮽ S$g菽0l4$Hp  M D{pʳ; )A4)))\))|kJ)#8该Ntt/)VsP ? t r=G5+<?+<+:8+#Hr+q0rQZǂY1LxPtD65+O5
 Z22fZRLR   ZFfPS7`JTl&C! r
p@e@a	[fQ[
u	h*NoIf7;tA34`dVf`Ȱuas輤1t-r(8) <u0;ou00 t`
РG`ћ !gpA]P	!gf>tq  u7gf!Ѵùb!g!faQfVWo,!`f$؃<t<}Qoa YqpS%
fu n!!C06	 Y P}Q1fWhܔd  </(rhMoR"ZY0Vs	!<@!g@ F UY]0W,pj,u
mq+fPfS0t0q$͂Z.%tV
ffҷf&^q
UJ 7SQ"» h
<wNOfWaCfG?:	f_1p3pN  Y[R|֡<v{mA
tR}s?Opۊ؋h	5BhEf_Zp Pt`iXs SRrb9w~cw Z[P0fXf^P1aM@@t8B`d?oD?@tB* !!!q$1EZzEf`~fP SIMWuUffCp  ~pܾf ;w(h0oX@_fapxp !f31??SECUtIfuffqT  R Ph%|'XcV 
uI+f%QX!uOB-ۨ@ OY@Uh,/d.S;%!sGt<S蝳
 TTV{&V[tP#V[lXT<Mt>/h7'
wRLAG= "%=| n =
=uwfpd{>>@ ƀ %]j#ffw	bï#
%On& @{f_r@'Bf$g&$ ff%g&	 t0ǁ  #9W$IfGtt2t~tyf{% Kp& f`8a ,,`0x?x fȠ1^u`4
f rF`jr>0:t, pur%prQY
	 c]  Y% 
&Дt`A5
A!:0.A2 r&&"

rr(@lRVÐ
\ _rP#j   t
ff;»t;2
 + t˯ D@@D+^b@[нP<gaq$FG@V/ ߌ،w	0R uB	
?ff!` 


ffяfLp pB
grC
`fPfXA3aq&3 vR%h"1/G~fQVP61`7:u"Z-*.$f+, 1fY7@ w.	Ah_S 
fUfp>	 --

f+0f<
"'f]^ -8##贂 /I_?Xv O?An@u߀%fz  '  
$$$$$Y3\[Yxry=tf& \&{q\A5:
R




gŧǹVl2l9l^lf	rheRwwP& Mns/y Ɔt@2lfV_0f^Acgs@A91pln`   ; a ѐ    i "`x}6f!S!	"q&

S:

s 
pf>_ r @  ZW8f 
ls̸Ћfff_lAIff޼dhog81)^ö@s@KaOLG /KF!%jQqW0ߛtCu*!+1΂_ f Ikͳ,@2r1 6
 Ή`f6v#!s
s7N?7`a GE؀AGa%ÑQOڶ  3!4f;Gu Yбc.D&Dh鿼UQr>8?S@_g&	sPfZ!8RQvP} `ff@  R!$^>  o 3Ҁ(FfϋfZo5f 
Ƅ
}萤
__H?_7Y@6@VQSv>f"
 HO9B1\#hHQ   C___[1)Z`V/#	
`R  eB   MWVQh -=
j Y^_S  2ۊ F`&+8u `&
0Y[fPWQ)t))P)fX"pY_fXkذ/KfV}f`f&a  G&P&Y` X v
``.f&r&&faõr6r5] P$s  XY
 At   Pfh'Քǰ X(10u쨀t݁	<u <u õr+r&h#r D8&&2QOrr,6r%}ޡ车pPqu`0"" QYatP &` Ob Wv~%'/D&* rW!%%F%&&a cRqpMZQRr#*H)t2в`bٵƀtqrultE@>ZYh*#s,   h6G|OPa
/r#j
35E4 #C$Pٸ Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGS`1o[&M.;2` t
$w/`#S[>5 U>WW =4fRo2ɿgbfZr pvw5 &E
, C!	A	2ah%|
%00`P 0S!^%Pg  Da`6(  ƿ  j aV魆ī^`W  3 _r-"2˸ fDEDC{ B DB O D D4rru½X 3W2&*G_YS	  ?&*P.u&}Zu&E_[KH{ TZNF  20<Otb	B<tmP:R:!:IrPF"Tѯ: r1 r, hOddo:SQt
pujt)u$<Pty+o'KuҴqayB@]Y[-Qw @s"suDa~Y_+V o^W mQfR hO2etD/>(I>>rN|?UtGV@u 5^t1Vh*N_ 6f^1^Df@h  D ; Z x     0NmA݊$
Pdu	q  52O,Xr	 > H豙ȃIذJ2T' ~ŹSQRf⤋ .xZp"ea  e`)c${tr+ccR *0hr/<hEd/(#/J+(*f(fYh	R`k/n Sf>QPH_u(20&fá  ݀[`-r(1ˉQqˉ>Prozryq#tr?fSfFfVfWp0>f9t  tof<bۼ @` f  f`fff!02g&g
fKfRg gre h7hUr >VhQ4
a5{f_qfYf[` r  sZfbXPSfRj07W6uLt;wEf6fPf8 p<g&bP Bfg&rfj0  Z[XfWPu
 f   酀> Àff`g0? t]ǀ t
t@  fO?
 :  @(!e _  f` ; 6frv`gGwf3ې fPf`kfPr:p> ff0o;w!fVg&f_^ufFtf1!Qy.Ȋ$pft Qg&$@%D&㿲v@<f=ATADtlf 9&Ǉ Ǉs  S3*a  讓[b 1 PD龁 0h3ɊE{@s qnE`Up EGWP XUЩ.߀>:   ub >u `
`
	`pg$ v0

$_Rff%f
PCf_LQ #g& h\DTHBA]Pf"eTfX2bXj~ø0qc/c;Pа1B 	    U
V C9BV *#tMIyC ك	
ڈ
C2
vO >pMFfff+fMRh0?bf-Effz?ffq[  PAMSuff>r^ 
q"wS0pfPEbX>  f.|	! "f#hPWVf1?rY 5E6yP ߀< usϏrjf f^0\Y0o
oh.BsE<u@
/P2k
`vf,tbI0*#y" `c<tD"zQIxr&=t tV" &GF^rYՃ"Ӵ\~AؾSd~V0 	0^4!
 
:?|2Ȼ ZHó
_X
_	P rPN	

8
_

p
h!ױPL~R ĺZ!Rغ0 t@Pbythۗذ t&oXW8>ޙڻgVlͧ 9K g?!{b=9q
$P͏T3!D W99$WˢM̴TAT(TTNTT[KTՔj̮̑'T;DzԻw0T`ج!^&T0ARf./u{!uM<~w2.f&@\bXH
< tRaf u
f
ufh 7S͇CeS ذs袈r蛈%~S!;xV4t ? u_Q[~xf[pۆ ԆرUQrt tuql=At U>q"jf7؏e s	7~x.ho0A@ft{6VOuGq^zsl.|o|OvjdcGvhhr' h	?@ h_XfVtWR$"Q$<QZ0Yf^SQR_SZY[!7S"΁"àP=p-f`r%Qrğr/Q?fc
Я]
f_
fBqf~ЌUu3F 6  h/8 
~tJ]
/t"(ޖL	_
f c
 ,1u]ޮr21]QWRHuO@rJU&
uuoп t&
&&ƅ]
Hr½X_YUfV4MOqT3I^TV	


 @`QW3 qot#f1% #?d f  _.fUf.6f]7f]** End SetActiveDisplays: \ R$0t5x )ڊ#и 8t k8u?d  7S{[00t@uPSQ2tM35P  豂@t @# Pt  <uȸ
  u@: 	
3a0p  - ^CPSAS@P| p|R	o9
SR/xPsHxP$ Gx8xċ؀ 7xX/xXxZRw
 wd``wa t{wP ÀwXWw QRPS [X"3t ؒV
qVf`p
u&wzr
u02,RWi_Zr [T&&&E&]1  fa
s @
2)"7??q ƱSQ+7fR?fWU]fS-SW_ð `R  .7t rH r0*tf G=kftd*` Ok>nqP @fcPfWrP]4qXxrP  f_Qt`xr/`?t"f ITAfgfaP  g&FfG2ga C Yp`t' tfkqd y
 ktXWH=&M_0g.g͵  Ճ? t0;r+gCCE 0| wuuHt~ fC°  6_0" YK ۢaDtv@6ߊ 1@g Atu }Q!钀j3 
u#Qh%`
u"Qh59u
3YvuC*u~r'p vruDqtg&OPhN}h1Q#`yUuy5aiPStb@LdotTfte+AQSS+rqZ V0rZfPQ> uιPc r\d`YR3CtC>r-`w 0 rTe1 r
-u`d aoP rdItf s`QRwf3ZYbNr&r!ww3҆r r	v`PRcӀy`'r㢰2ߞZ{h`PQs
d Sr	r!V>RP    dtgf0~yuwR Z }hUk!C Z777.a Q " Y0Y `2 ,u P h4R밍

Z@u⋋* o _r`~O -0 װIb1 RR  rLDC	 4Pk>jS t3306J*@` ;R
t#4 c ttXQ燂w(xQRWV۹۟+3"a^_Z$"#31$G<u
t$V 4^W {_ "  !(<t)۹_ 	
R
q0P#H	
g&/ܱ1q;aO-r;PPt;񰆛(Xó 蕐J
2ueAneRVа$rN ;rCr<,	r32;trr;wҀsڋ^ZW
`j  а 0u
˾  yu B߂ f!oo uf_& J3322t@@ O0	rn
$	"
uƋ߱d;sRZ3QFqF2t
2tAu	u˸
S_ø
_{..p.q.q.q..`r.#.RE|ذVPCsT! `S0ff%|h f
 1 f4Af# uOtph\f   t(,#%9tp\u!! 1 ȁe0 t^f.	fYuЎYf4! 5ߤ߲$42H^ ~CfW Rfg&_ u8  U*[ #h:f_}    /OffSV  <r<whR_ >Q n f `@lP[<Z0%hruh < gPU2P^f[Þ_4  0fd`anú:tpVF	@d `Ƈ1 D rºd u"At$
   tў 	sqf 0 >% @H U	g&g&~`0& % 7&%fQP&(*.d0W0hf#fl%P.nc8r!''ƀ  
 tf 3 Q'
fP~vfjfS	-}v P'' rp
n1f3l
sh?qrfҨf3 %3C7؁SWV#ot6T;p%ȿ ffr33uƏ^!3һX3t@s9ro M
'` ( h%!`! o
 * A4*P&TQ/>%@RM
@Ṡ#H&$0R PAW؃22PDXђfZhDf`h*s߻ $[f2Qgfa/i   &ii
oÀ>ot`o: ı 
8sp# ~5Ltю ГV$<
v
  )o t>a t o$
}ؐ (oh/
$$ u
d t_㋷uL`ꊰ;g^hh~t

 d	n	
s	 n[+ a&be ab>b u
8wкT~Cs#YbtK_PRNPX@tIPS`Ap                                                                                                                                                            x     `    nBnnntnJFn aS [ À 3ێ7!C &?!Cu3ۏR .Z0hT0ĸfY:#n "#X#F##P#`&&::. ">&~".pu	 uQ 
 ^ts+t@QWP; 02`ޝhX@.X=X@uX_Y!܊up$ qP!`. $>:rP*/aXt	auð6C u@B T ASQgffg tHu.g :ff3g&ffffߋgfff@@<(.&gfݫBfsDP
hj""
4	_fRc6U0 u

(
uXO0fZ/؂f  f؃ ttNnp Mp 00繍~PfRÃt%tg0&g!ggf`{fZRft9tg>E @ t9g5CggfxRVf),g>E %g> !P(^d`g
^
.   *HfRR"Q軦2` t1YނZJ*qU@60X2) P K^g%3S:nP                                                                TOf S tad            %  p                                                                                     d  x  {S    
 MBA U<<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.4 
Copyright (C) 2000,P 5 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:\` 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  t\`A%D
hX p t `SfQfRfVv&  &\f?UNDIt?h o
}
3EC4:  ROM ID structure was not found. Gs<hh^ '5is invaliPPj Sj < uf. fGf;sfA7 f   u `Ef
@ &6 +&p fRSfP& ߎfA%3ffJtuہ 3fX[fZNwp' W.;	s.
`6&PfP WfUj j f2 R0	RVQ캐	&v &D_6E  U   
 
 Ff 0'VuH6U9Whw
˃f6UfV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6'drivimag{'.8: A!0c_.S.*c1fsegabp
pgNV+.> >u=h2!a! +%93C44f)J4Nf04^f.P sLhP  roo  AH" ԴN'rv&D &L. &;D&s_&D&Q- @] Bq.HPeJR&DBVB&(Dv
AzEA	666Wj 1_\0
0 uvv| t  uj@GH F_F  R{Xt&t1u1f
G HF+F)F[fSVW |1N  6,
òTۑ IfT     f`_^f[PA^@@f]f_f[fXw t8sVTUf1 ڑPUUJt u VYY1i< fo^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  
 s@8r &f.+RQA)ufqAA	f]r.ۀ>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to aborMt?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZ~ 	AxS@xf>f . . .P 2`<t8hnE^WOpѰKrequi
 DD?IM supS=f0'  ˂)B	.<0g~fh fRjfj0~fЃhQplrzfu0h|%{
I# PMM func>2
numbec` u)hgE allocufP~pfprgfgfff_-.kJah   .tf.>J r$t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j ( |  LIENT MAC ADDR:A  #x     GUID{: DHCPPXECli:Arch:@00:A 0# I5P PSKePROXY3@
GATEWA MD  BD` 
Auto-sel:
  BOOT ?SERVER)    -->  MTFTPTT l! A1Hed@roxyser?vice d 51replyJ?est  @> 4011.  ul25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[>/cred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeo{utcopen+EQ - F@ NAcchViolrg SrecedPom ##unknop!c$re*	<	connp!pRB NoS7p6)offers we	'  ]f#nam %e.RAPI}e 5u{ICPr multicastdwh~0thr /)PHY+figur3lDataL+@)aW8EEPM7i
sett<a,rrup(too many /packsdF ; MediGa tAE7,D8cable NBYPabi o=basE> BCQ4FdiscopDsFlim6H-u a7nd/)mpHC CPFO&%s`DQ,nE6jbn-mq.Pp  /-\r]
SM/DMQIŏe Hd+_Us_u	 Db
 
`~ uː  u^& 鐃>.3 u3^.3h]t0F-  r- vHHt
- r 뾐w:: MP3   fv?FF)~! o'Ґ f  -u
hx9~P\FmCt\놂[mo{cA벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t¿ Mff99f2 hR99@t{Jtq ^h
LShSF` S^TF9*9Fr䡸9N KpL?2#ZQ"1KNJHJ t0 tEVPhSp"
FPH*9Fu9R 9뮐3>'u> (t
KjJ!
; 
ta@0`9^0   V@/[0.+Ҋ*A FVF	$FVu3^Ã>гt3y(3*3(wh2v Es05	(3;7f(3 fpsEy O뜐WT3Q44h96:6@ 636H3 |38tְE<2u}% 0ҀĀ FVfF^}IFf+	`v6 FoV7u>P>f6(bK
:	@" 9IW:XF@V^fGPVr$=NVu^F^G(P	eYD^  G-- v%0&iGN ^& u*&GO=p u6`&&G G#7&r&`O0 	[!W8"`7u7'G P99HG9@Gf9  fP2 VH@&#P6VS*&	&R&(G G0FF`FF9G6@NfNfQhA UVU U^*&O;~S*Q
u3s  S3#G$PpTqQ(G	\1'G!EI<<hW;?.3%lB  t&} }??XgFdְSV RPV`T 
 C3& _2,Ph!o&Gk3?F3:Yw			7pf(21sK,  8-tHHu9N5COBv-*}OO$+SEA20 GP)a b   Q  u  P  Hx3cV";{G& 4@ P`_

6D/*WE T3WAe1kDiuQX\(PB@	=3 =2{ }NcwE-6 t`KiuhBC 8f#30QG.o'Dp'P3Bm"ol~N~ tI01DR{fQ [:×3URF)v; 			[
";S`
 HǍG0**c&W7p![ 0XFP V1Y+`ppp q`q$JfjFH$*F $ t
{! HËFFt|y#fÐBaf'dUmB`G?F$ 5dg2
I2
 2
8
1
I~zf0fFB
%a "2
P 7,G9bF&$U'b
81_H~fPo'F萟{FPtM +;Vr
w;FvF@F3!h3F^>M@Q"dP򻐘p (Fb +ﾭaޠ+)6H)ࠩ?FN)z) t)hE)`WuC` WV2! \t2^_2&spO( IP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Mf2fx{3RN|r!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"DH			th&Dժ	#Eh.dDf>	 t.ڳa Fp&J>1u(as$])I)K &^lQ_@	+&`aL h6npVIǺ
  /daF^q ur}t ,1R#F&3GF>t'h*FFb5-0wf% JZ3M.3:F!^333&PF63_9F|׃>> B.3Bf FgQfG9m9!Kбh: C$-h:LiHPV3 Qa BFgjƒCG<Dp w o@*DNHL刁i	TX\.
`Nh#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^- t@9vO0j>`c  Pjqn@mv0*-< -`d.F;Ƌ}	r58X	 1"o@*F69Fr3pqQ#z{#=4PhK{0Htz0ӽNh - j F<B&&B$6'GIr(p7l)q&W#qNxCpA&tiG]		$ 5$"qG$Bs!FQc"  =! @$[W
vS12Uc~j,hPWb	,5,ԚD+,&_*&G|&_~-5ps0-+@)t- t:' t $ u&  u
&0B2)?tₑ&9Guf& u   t؍G){
p*tP\WJDvvv87Vj
 &fXfYffff99A : ;SFqTjФP+hB`ix  qS2CRPT
ix &nF}Ljp3#b F=zӂP0z07u~ t	Ơ`82[Dlp@aAg3kp-`'C<  ǆr Dӯe8}8 u9c9*`Ӳȍt0 t^u_f~}R9Glu]"pu $%#Aqm Qn4!"&`afP
bq;2ge2dp&O#a77# q8#8u)̋- Dt-guB%t) upuh)5'@D04Ȍ#XP}Piܠ,)oP-)I
#p&&b``y
FP11&Æo%ca;iv1t u-iF f"3u30RӖ
Rv35erѲ,u1}.iv; 
t۶0=>P-"RhQ,"-

uۡ	? )&j&hy4B{sX5tۢdtxuHC$N"lT=1AiFUPA9=% pXD` 2?	 9t>2Pc
4 c_*\6p^p0)HtHti 4H
5&6
2{-Ęo4F@Ch92 < c+|<, 4t	"]
5lW
!!
~
3iF 2pah36!1$30 #םqpqQ&$ ;' cb;
D?'0
	!5
0
ndu>2; tpy)j{pn:9&Y` RP3@"{4dtq  u
ѨC D ~ rq rરlFP ^ V Cu~3?++v^F1*"  SRPW^Qu0@|1a}1̿P M"8k@1au`ug\p1:O790qiv<"ĘT1 F9GwxO#N; ~w taRVEPV9
4P`XG&W%?:FVЭAi39Fsq93u93ut[~o tHS`׋Fa-2ovi~`؎FQ@>PSS;\u>St
FR`_s	.!P`V\7hbn21f>&fp9f9thx轌 p~hq9 t@3ޠf 1ƹ +uh?1 .9Ps!1rh1^`2
b2 f|
fPȡp`:޳1h:U777ubQ^dF@R1Ċ 9F~A !@ux  k^ ^}
 ̽L  ?   }/^ۋ  FPС0eޠgQ&>pSp8Qe @
uTRRS pېF~!uU @u1rBK+o t'Muft1eРxy҃yy \t1{Ðfv0pߌ 5b# qO4 t&Gt,!@ &!t&lŀ (| ubl t | ~GlpS u0pUxTxTp _ {t--Ű%`Ez G+3Bf&)f1F?FtbQ~ t^ݰuK{ 률ؙ99̴ t
w^MQ5ף:pθ #^85:FFu_	63PaX`ɀ	* 5*6 FuH^4H3 u9,3ܒ	4<  4  t^Q`u
43	VVCg `= = > w$1,̋V; -^Gqك#tOaf6 K10*da@&ğɤV*@L"A!i2P8PR&73c 
pI3T f+@F^h
&F>pS^qecNF#	9FsA^b?	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 0(q@;EP tutp@6~ t]z>_T9PI0hw*Z*#$(pK@|%0z&F
`](R0>z`c 
Zs	
hfp w/			/	&			cu^ABsI>0_)FyV)vf&0a`_f`~^NvVFn
fa
@P~ǿ  hRP&$ RNh^V6  u*	gA$d t^!U$tfX u	   $uy$T u
vxay%2     v wr#@4
XpnXs$htfuCwt&h⸻=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw~d\ `n`t`1 t\nr0eR
Nx!
\^%
R
"


 Gq(e
OR
d'3`&8g &3;v
軖&`Frb@s
hu8p@?Ht',ha&)&Q[NExE#i3o+Ǎ&k&K!%}%"_%+`Is)tr %eH!up%  )fǆl @ Ɔhj%2&  %hJ% 0O&= Btw3-O-,u 1!?0hI! t#*Bb- [t- 
tQ Ğ&8t& `	
uAp@_*h$ǆȁ
 v}/$׃Ƞ ɋ$
̃ P#&
h [4j*"8gb X9A	
@R$ơR
9FrF
0r%*+P/Їvߎf`fߥ^z2hXfhp VoV3QP
wPʿfh  pv>)vp+- PY3 $=.t = t -ot ) [ tNfhs
V
$q

pc
g
U鿀=K_F{0=ikI'HS-	t-
߄-= K-w- 9t-
t- ,Mt- ttrV>Pu$ >=T 9  r'9>
 tFu'^ !^ fq q24RPV>90
 ^)@Zu)°N J?63L3١FVx'p#) rt	tp	M ht3h9 2~9
 8 .!L3 (R 6 jPP ff92uvf u:9u1Sʰ~(v(;w l!d  f9S&:Qt?F3u*֡Ju9L3 =2 g2 
>J3`kE~F vN3'@'toHHt	H?Z !"(~ u"hdhl{p  ڰEP ظ; \&u< Ou	=  6 t?4ft3DpuxPp
 `_7N3? >r-&+'Ht
&pVtge9ԑ&- P9pQ~L~~?? ?D#)>2 u@ܿ9 Pp:?h2 $7"0-2C{ur_? ScjRY~O d< #@@=t9느p
Fߊf=E` v`W W QM [(3*3'$v_	v	1b
 g}^c    	-C$а=Jv9s!vp29a|Y&v9P31%PQv9X#> l
GڰSM>4J4Mېp9$ G*GLQ?MV?tfG[GGID:D/p
L
3LL9 3t\Ni2uY@:ADE5 9莠(뻁>? K9Y#9U]-U"Us>":Pe 3df;ÐnP3|t 1*䊇N tqu; wb ѐ:Аv+{2@Вfj
 fXfYffffF~"FwF`^)FX@/9Fv	F_F ;Fs"O=~#vPp ?F~s}{@~f+f:uP63
H3r~tR}P? tH9}b  3OF
z:Aj` mP
  E03v9f"0fPfF  FQ3?2 23-6@|p[~6g{!H~FP@2R}Y	9"
C<	vaRs
9" *vOb__{P @X)W) ffаHYj&ڙڿN^+wFV;r
w;ȏv:k@+؋F K@H$d +3
`6@3s/ pq(~6F:7`6t 843[`Ff(3f@ 9Fg-/	
 SP]dF\

ׄt)2|3a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*N-008 t` 0rn 9v҃ F~   WVA?P0bNq؋ɻB  RV3^_V @'=@Sw~u!tF0T QN?V
 FXơD!@
P"{
 ވv3 vaufpocteσF t  q9[EuEc>f4avm3dҕ%|! c~~ t?!(r4@q0]B3^
0A 	 r"h V3 V3X3LY)Z3@03\3`3pa3Kbr`qpȣl38n3p8`aͣ9Х99p399ֱ9!ʰ9~Zv?r:qd3vh3 f `ZP	@M^ X3
 UCb!ggu	W3 &?r"` wh83t\A۲ 1  >kuёaa_{	`{V` FV
22##b&w#2#62;u5;+u1`=1;Sa7`N
 Z3;aǨS$Sp"p-}`f`m  3AF
a%RV x
b- PZFp ^ $ !tF f+F;FwSGsp"8@O+V  " 	2  @3QFFf>6 tK;8rBw;6v:j> '
?+v6 68{P 
@и@;"	P~t;Vwr_;FvQdau> uBuХ12122;Fu$<ut
f>W  po M% Ht pZM"69@2$ t*f`Ŧ^&G&tp&9&9WZF N%  F9FИu t6"u
ǷFe P$ 0V `Mr0M97AM@MQ@M 99~ u-B1N =tu1QO
p
  t6_F^r't"&
9F29FXa2"cK	
$`$a8	 
B@Au.n tohXASF9?F{P<@F= ^\l3n;FDVFRq@  9F9nJi	+QmlpmKv	~`-t<1Z΃e_q0!v`$,)P(_%4 18r6\dk^9u9ukF?P!d0ABs
 uߺhh? 3}!Ƈ¢h9 迵9P9P
9Ȼh9
 fPSS3&R39p9p9 34G2p9 эG
Paf
! :
":ukFC	qB*siQC


w
t!9

	
|`ЮAf@o= uE 6"~ {
C 0\
u[
 ufs9u6a 苀6X_6PPR@`霁@^#br`@Q {a	 Sf f h:F3Sp099oh.:  tPá'`b ?q3[g5wt38FPj9&_0`Ð*GKC!ՍFu:~aua J~Ku.~Tu(~Bu~Pu?
  st`" Đz   ǆ~ /x ~bB F  !MSQ @@  ;sY[S `F@0Fآݮ֣Rԣ`ң9"\FHb	X AW`FFV6!ZPFFw~oFH  FFF^0ċFFFF u0F&uF@ͨB 0FFF%'?A`VF *|k%ōFP#
L@.OXf* PWQRU>@ ~> j>*]/ us>@ ul>_L |is b w[>* L &D F +ȋѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tF.."
0 .!
<!
0t9а r   fa.>O.O! 9r & ӄt"QfpO u8Pwh3ظfP&.O&G.O[i Y0HYKSQ3ۿËȋ$tFhf_tbY[Pf.OI f.p	PpPQRvo`q
˃ӈ`
  .O
X tZYXÿ."˒O
jЄV3pӋû^]
 PY@ pσt2W  _^]Q  2sY >[
 u[
`lZ
OX
 ^!PX
R5?T
V
aaaX
c_  p}b> uV+T
VfTm
sff  2p+9Vwr@wA)
i댐>
 tZF  ץв` hl} * %w^$9N P m@NQhUAn`PV7$
F 8Ft)F ~ t/$$* ^ u`+OJ F ⟡Rq$Toh`y?	-t-,tzPWVVN ^4~&&Q#2#222##;u;u3Fsޠ7f9 usD99r;u;uo'^_`VA;Ftip9^Qaf	L24	9a9FPt4ŷͱuPPR"`fSfQfR?f`<`Pf;sf;wf;r v s@fZfYf[]SQr QY[ PS [2BppFt%&?	u
h*tЯF
Qm!:P'  0Őw0: .W9'1:aqa*'I+@0>ɱMQ 
p~q&Gf \DR 
4Cn9w*d !۔	u$
wdw
ڤD1u`2Ru	s2G2ZPRZXPRZXp6aIP
 w F`N0C L2aGÀ0v0V^  F+2@ @tHH  ÿ\`^^
 t\
!f`
fq d?
-	k d
 @hc td
37d
+
@2f
9pucf>`0i4ߣ@h
0f`
fj
+j
l
f6j
2+[TQUp΋d
)R%0PÃ>S j
^0]uݡmV+ɉNFu3P\^f&@gp ws0WI &O
NԀPU `FF&9wv1hV_ a9GtS
uжVdoY@vthn?
V	`an
 `܊q ܂ rrÌ ơOVfWOˋf V0 +N uf3lf3@fƉFfFfF /lVVgv ^`^~320Uf_f^]н2Z
OfCORPfEODOMf`ްW'fufuf=23AIt
f=46AI`(࠸[`^_`p< htFqKV1Ym`ЋV
l/FtSYnF&PU #@P*C#~ ~ON.`xDN;׋Vw"?WV~ӤyÇWVRft x⠅.F&%G<ar<zw, arzw :wr? `SpwਉGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ϒໆ^FV m*&'*@?@ &l &n of%$Pf P%#f#f#f#f#f#f#fXS & [Ì؞WVS3й}G@9ڃVp 
VN3Q||8 pVفKu~f
r;Vwr;FvN3ҖOu؃ [^_N
Ȑu	!Sf
΂Ӣ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@uP{09t
 t`Cr< u	ZXCu33_[ö΀__SM__v_DMI_0 _a$PnPB@_M_SYSID_BP ʡ1/ tc'dD@3NtaA t䞊аȑ +tۂ6 0S                                   5k   
 UNDIUL+B    @ ` d$ UNDI  ; :`PCIR$I  w      ?L 	 #$PnP ]u_ !
HP Ethernet Boot Agent v8.3.9 Copyright (C) 2000,P 5 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 A  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tx\.  <`!68\.	 VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX3S2.ur*= eu 4= ]f   @g@0  .9u
>l :@ tIu[SY@ @@ WuB    1*WSR..>f&=QEu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E u}qGG1G؀}|E$t2Z[_ϋ]  .Vf p .f XtfX; fRSfPp u'fXff)Q)0*	f ffX[fZ? sf 1f  f
f
kf
fa PfRfQ`
 q\
f'Rs
f_ufdQ
fIu sfݺf$qV
5fYfZ` 9
 sf3(
V3qfR	fQz
fPh  u
f`h  u0zf&	Iu`}^(u
1 *40"t*	3tt"t!
tuA- .-0h  fPh p @ &eKPy)}v ohSQfRWVsf.> t.@   ځ>  Uts r r hPH 
X%
nEC1: Base-code ROM ID structure was n`{found.   3r덊  t	}Sfj j Rel>  t;sf>BC$uErPj W"뛌ێÅ0 2B ʀ
  w.6C6Q   j Ph
	D
CZDt'h.	RRBX
BC_#~() ==  srp@hY	M0F: Exiting P6 X^_fZY["
fXgX=eKt}, q . fТ 0l S&t  D
c&6 +&p F& Do3ffJtuہ 32F,G.0	pi6&ԋbIPTWfUj j @RV{0l&@.6E.{ ..ā.e
`Y{v(VVE6UYW0f6U_fV  !eX t tk Ȱ6 ɀ4WPoO3203IOS extended mry c` error66:3driv0image is invali5%98: !$o8b8;seg9:NV+%GFjXGWhIf "` p)ӎF.3v wFV 5pI3ICOII=f^f sDh
PFx5  AH@Rdrvf&DFO&D@ B!U H`PeJR&DPVS&(DovAE@	ǃO6O6C6Wj 
&\P
/nf "zp WhX6 u96} t2 QL ` N ?b 6EF` 6]
076u7]/fS˶ RfZ  YpjUu
 [$8v uj@OH F FRvXtauPtfыG HF +F )F[fSVWFU  6@e0(!(pQfT`k   f`_^f[^i?f]f_f[a!8s]T\0 !%P\\Jt uw ]`)`T%T0pofPp = t.. ﾭmޡ.s	N]&}t	q t+{f&} us.z9wf&+f&;Esp `_fXRw/=  
 s@8r&f.+EQAuf  A1f]e3_` GY  ГPb tMtAC< ޣ@^p.G3. G3Z O0 Ra_Q Q Q^p0p	 aTTR!U'U$郑H.w 16%_%IOs
  ]'uTtTs
 Ჺ	`&<jt.;60 r }RMXrإM=< u wG&DA 0S  &LpS&S S"]GT(T*T!T0PV8UV2Vi:1QWXzUqUQrt }VV,rUY˲Gu*.
n T
 b	$ZD	R$?``f[]s,$ QSxQ/'f[ B :$|0K ! 2Rf.>2fPh7fA @SV ; pp m@f{raPpEs6 <u-ftq຿  O,m~ 7F`uP4!T1h@$"uz	!X taN@ M ۊl 	:p u@X2@+`TRp f
`RúfffZSYPsfXSQȡ8tYQf`S Gf;ta#U	CODOtSfQh= u.fU f
af= tAg(of<ac rp"uX3.P.P #.QW.m@P	P@@..( SXf%/bx]Etherneot Bo Agp v8.3.9
Cright (C) 2000,P 5 Hewlett-Packard Develop Company, L{.P0All 2s reserve MBAnfiguration Menu `  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"ChanpValue3$FieldRSave Thop2
@1selectable1     Dis   En 9                 $Protocol  eb&Execu"EnvironR#(j@)Rpteqgram Load (RPL)! *ap (BOOTPx 1W}S-6  #  X/S"Type  Auto`-t BSI218h 9 	ix@π  Hi0Setumpt 1he9:displaypdurin}ginitiz5 6 { G@ Y]`anKeyok`5SP+B6B  kPcs ` t!1c; u 1 @Bann Mess!Timeout  1  Q6  2 `9  3 45y6I78910 5 7	7
7  NonB  ;HUbo|4'3F y   LHSpeed&Neg.10Mbps Half	FuT( M]m}M%810;@ :-;Wa@On LANp)1Bc9АC ff tf5 fQjOuIuЖQ@ #-_WsZf ؠ> u
fUPf]T ` dff˾!@΋f< qf0f	u 
2
E,=
u=nu % P> t 4 011auyH9=П0|
E2`u
F)fZ_W VfEPE`ff%>! t0@ƀf¾>0	BD`	
>u
>s 1pȅ		E` ff Ns*2˸ᶪ`Ԫ
Q##ѬY[_q 3KtRMtpPtHt.ct>  Ρ =C} Cs }h 륃} t=P u7} uEEH _E 22@;Ev3& b.# @uUC)RVUmP	Xum
>n ]^ZQP>*=; uXYWQUQR=m uUZƄ]Y_PRR0 ZXQR	 ZR {  ϰm  [ ZYQR 2f4RvO裿 xS2_SQ  Y[P<P>FXô
PSQUE  >
]Y[XUP3>F 
tEA@]PQS >	o  &
 [YXø  RU n 
uP	]Z(*q3ɺO	f`
   `!p:ޅ 1.? PbXL7RZRZP0L>
[3faCWa.f8B  ` of܆ܫ`4Hsp [ .1LPu"=!OQX?tP۾Rm c@ffptN ]#
t=`aiwu	 Pf_f#Hpd ݇\!_ tÐga`8 ~ f%5t|  s5u&f @S%	f(U|PwuJZ/$yohrm uC}!kfnr!afRmQg.	Itf{f]s`};d}f1^`zrp{fSs.k3r05t.?0zmy pAxf@! b_$t$t
%	t nqxf ,u1 n2q t#T3QCG34F"u+tf  'o)[T$t:+t:AhSr;1BPq(Pq})
f y%T$[Q0r rffR2 u	! ޅ7f7&7'7`8
݃Iu_cM37ro.Je_da [qQ ۻP?_SM_ts OvQj Sjo `jA u ЀwrgrafG24tWOpQШ Yuf= wSX,g8It#gfXfg f@@:g@tgef&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[e3?t2)W >u>^> Mu	>p GufQb` Pfj D< uf> f^s PQ1߸fAf t;h_)cYP2
PXE-E07:  PCI BIOS calls nsupported. .	uL.;D u3 tnh/*U1: Un6Device! hb*׊P^	4: Error readQ
space. f3ffwY}~ hxjkBus =# FuncAQW *_YSSϬs<f f rfh*.Ph*$PP*rP׿fX53QUf
|70M&V ] YAUi ٻӰp`!.>B@P5 .]f[j  wPРXu
U |U.P  >.{@[TORPu$.SAFus
.B ` t'?hUp    vh!Q .P 2 <t@h,PH X}U.6: OpB#ROM %quires DDIM.. 9c7~ ~f;G0jfjf.`9afPj,(-?fQ˃Qlu0hH-Ԑ2=x
Invali0MM f'"-number0- u&h{-6E;:oc/e1. @@Cf	 `frgfgfff_ .f.>1 &փ0t=t	 tz` b 3fd @d f   $ Ph   ^.(%tf'P r
 1	. Qr 
 < pxcDIX+802.3 Media test failure, checkMble 
CLIENT MAC ADDR:ownload"ed

`SearchFfGRPL Server ...  AbQBCM570?X FounERVER NODE

Transf`Kdata fromrs,xne NControl to program @  :   /-\|@ ă tttttWS ˌt& 0ˍ$Aȍ!`X)R#ڀ| df `  fNV+S,#/E@ @f`G#?VfPF= t
= twM. ~
F&LێӼUh@ WPC
P \Xf^tq[f3]1pu
 /` jv
]w.6 j p>
f0<
	g]g}
wcr^c
f&H؎p
fU
S

f]
f501&7uPPf]f܃>Dj v[SJJ/f@Aa@ . 3h p f&D []` 9h uf. fh ``  V hg&5+g& ^RЀ+?>S_\[$`0	eP
fX&
=PVuwNVf. sf ]ϝ# 0$ . . SR[.9,up r   aVSv"q GfD[^]f`p1 > t;u Tb%@ ߰ Wfabp-. °t!  r Nӄt"Qaf֠48Pw h3 &.@&G. [i YpYйÜSQ3ێËy`#tFhz'09t`Y[*P#~ Hkp	03PQRv`q
˃ӈ`
BOp
X tZYXï"kO
ZSKJ7L_PHK+ 73TuVV6R6pgK^ySKK3tڋVN[tUVKJ:2	3V}Ȱwf~ PH   u^&Uꐳ ;FS{Fk @ϐ{C5A#cE{됣C逩Uq gCY]SރI#{?5c+g	!	C
= tw%= w@."= tw!-
lHqQ v {HtFj+=~w
-~- t-ڠϐ~@ː!>54 t^pj  h12uV&G)4p *4E+q - /Q1
3419r <:54!Oqu|C3A3!
% 2}
&1c ېV"!+f"43F4fUF3^|@lAGK T>3ua@B .<b	  	a? >4{	B
P/p20o54	}	Nt	\Of"4SP
L/	!	;p/	#	 		-S F1p&%@ F+PvnP TFFA#9Gw"^;)q c''t""n3*" xFw1F(GNR  ba0E&

z

F

^
FV]0+  V7!&;F^Î 	
w 00	PPX	F9F~'}*ffP <	 " ttf
fjmr	RuQPF?(; ^<#fNpG F^sF`=p{  t.&ЂN
P
~}-^v&.F&E"
|P O6F*DHtH|pH~I)b FF^/Nft0vQOR\0Fb e0Fv:f&p &@
R
p@
 w뻐+GfGFG0G2 4G6u<tfG"fG8$?, G
AFar93RK-B9999Q99x?zdIVZ%2F3v!ވR3@0f#|eff*C=G=G=D=!e49'	l
a/E[uE^a
adG"G!nGS.S]G
 ,H ?ZY@REա{1.J20tQGf 
ffEqrE|1hnSaRRv=Pjcvǰn:nj^$_&G	c .rG`"Pzss _WG  
-v9l1s
 +4#AfF @8MfsGЍ3 @\2\Fn#t7qW?K_t"
|@#'@@b05 FБHt- rP `ȸ0DVc+
0[ <	 u' f#Fkf0ee 菥 mJƇReG$PsfPh蜂/Gf3>PNt
4F} r\>t& 3{W_Pl
pR%ڠ6P| *G7i  xpj0|^!^vb
*&oFD: A`lu+lu$@mu#z") Fɠ1@08?&cD - t- t鑤 {^K
Gu!Hb @ 7N~XFǃ1F~w}&*t1) Gy+3  @5l4E<<69Gu9Wt +V-(++ *+ :++8t!U0ufhr0fj22,,1@`ރ8Ë mu2ÂP#SVp 0pNo9u2vv@VGGPlÐO p@RPx,,A,1P,`|10e|0b0k GG؉FG5 _^ Va5@ 
~qG_Q"HOW #@0GfuF@>*b{u tfwl`$""02F0Vp(ډ`p ``f~
t2 t(CMtn{t~t
#mu
Ƈ'  ,/=(u uPڈ@	<}t	ވ!fj  w/@ ZS`/T8hPuC% p Pu?p]   uǇ`.hfƇ^a\ږ1 t&b ě}#Ft^p{tq qtǐ@  Ǉ_ڰƇ]O f'rw% i}G
~uc]`.R&'T&	BTveK"Fm XS"%0 +- tQ $F8
%  P- t/5@% - tQ 	Иc00ZfC t_P@T 4t.'(,d
먃u0	Bt Ft' +w  p@⿹tR/a ,f5'0a>(DfG - 4.va:s ]A;P- u~ .|<Ǉ, dK fch j3lnp rtv&0 FV VFFuP0--$ suV@ L?ՀFV H*AHFFa c?VĊUSǻFAvQFރ~|~auae8`#u(psu)w)s+ҊԊ*A SjD2 >% 0# V		V!#B  Kt@^ $#Ƈ&E  $-@ ` =0 tuС6 9C1еU  6#P10{@c t+
u0-I5u~ptt~t~ux2Ln`ugƇMЏ5 0j!	RpP. `D- 4-p --t~ tF	@7'gtrTfu ށh E3of@7wZ=Uufux+<<s,@Mr AA  s$p>K$[`]?u>@(V?-bq	`!wVwixgHHt ABib=Fi\`c*n?C$bA$Ibg uxDq 0AyRHQ0C)¸ 襴  [Î  U¢sr``% WT̀P-װ9Fސ^WPF"~!]" wǇBP1ƇzP /0q!9Yv(kD]pG`]0!!ǐfv
Gv)6gG
P_ pc uu# (x ]zPP|@hCwSAVEpQO@xN/lp t譀lBp\% o@'FCC h@jt! 2"ʹ!ѫAuǇT p+V|PVT P-t0.ˡfFPsPPV"eeB_f 	pP `ue `-aqT4 $vfj@Dՠ t q @`@]4
8Q`4 _P?$0~p=Pr#Lq`@ A>-/(遰T`smğ`vf&0B`fV-  fj 0#&VP$A@T ^!"XX `  \fjH*P h!GfP,g{ӸMǇl& &YLp  B   [ Nc
J?s
$q
Q/
PwHÇ(`Oru Z4r rRר t`B| ٔR>c**䊇*   %5vP8Bfh<5  &dP(p
_ @b 506q@c 
fh fj s:d'<K h , lp`t( 8`^Sw<@yu0o4a$$@T %D`GT	 P	8A
*
B+0 p`
 -4T aLsπUHZs P`P(PJ0dA
CSLW<H 05O(腠 8 0ޣ qg7{82S. P8I?  +\ Z߇tP\s1W\\XXXh`!P +HtHtHtHtHt3.   Hi2ҧ ō&J]
wQ^'ss1p!2*RP_+yDȋ+p13w4+Nѣ4ha낲PxPzfps!!s tfah PF1tt2gQu; UP[S5A`GW$ Rh~s3|hcPOEWlRP}hlt*"#+!"+3@ЁJ3  PSV7؋GFF H߃00$[ F I	07FFPn4p`
v@%IfDrRېb0f)OGp0`8И$sw*^f@Q @@p@+Fц^ GW BcNA#FF+9W߇ r]O0E`͉@WrBੋV `+;Fu;Vܠr"wYr@$%'8E
	
FM=F M99Y讵 6  y~0>c(  R%3{f@HZ WFtWf  @BfF֠NfPV!`!S aP@NvMZx z_P___FX! ^ҁ+ FVڊF$F$`Fހff  Nfffvށ 	B	RF9߇)v frpN\~|DSV^^^@_[&遹Q^iW']un.ab";p0 6X  P54F~skF|FlBEP
PwPHPP@G69Gu9Wt*w ?@aI^1::}DUPS~ tL ;
 qQ;4`G~qP	QBCJW߉FV!f?9Fд0a߀W _ t a F@'Z- GGQp3Gof Gr !KV=PC
wW0{s@lPS;C;^ |Sq졐 0f#Ff0dBf@@== u; t뇌q t
NO	pONFBtIFt)` tF{t  7 t1 *]#" @	q+^XtDC
PQcvg\ěE( S
x:0 uh $3qǇ *IS
F~}PtpSt}Ru]h%`  F u<h@QWhfaW$Pea	-	 u&`7`3x}qF]9{aJ )0O
 ,B=q 3t9I^C@}!A % = u݁ksut`F-a2S+u
h,}SV=(u# u^q ^ '2FF`  F䋇 RVH! h=A \ > Pz!p?D@@  P  3@a#!u- = w.2F2P2\2h2t22
:!v}&vC 	 m~@}<))Kk M CŇkjֳ#_ hp0 0
 %1J]
x tP,Ht0B#~ t']C1 }0B1>Ft@2Kuz= u\ t:C	Ra.a{䐏TQfN	*䐶  F9F~BoNuN,  x䊧puq'! `xtohcʚ;{u%Q= w3"4W40  X"   *VV!"89w!/3`	9_fj"gZA q&?00VAQjP
@ wNpML௑*ө  uFQu#QJ INRPQi	U }RPxm߸ 21
@` 1FMm@t]F~|߄c 	@վ@D^b{`TveK ۸P ]p ,~ޣ=` unB
RjްBa5``X   V ޠ| P q޸(grPh~n胠g ww (u:@ t\q>Q 
Mu
@s@98 ss=ut	 
m
QDPfB @t |蟇݀ ݆*RP=
0t0A u PJ T&#	I
Nz+,fj@P$ 6"ݔ tutAP 7Fp	}+Fn&ΐf!Ftfv? `9F}@͊ *+1F1VC
Ң@ Wh{ <l a [0
1ీ_0)'Wh@ba0bP p:`(~ `V@CO3Α5fq"f% A WVd uBfh /RPfXfYf3ff	fQAv~pt8AV*@?pSfh4  Fj dݝ`Q Pp
Ra{t!W
;E(A#^_S``u
 uP2u'u
6`c$	Sct<S=8H:"4@LAڸ zЯƇdGh%?%  e`tku75|@F۾}pu:Q8{ٶ` u
 a8u@q62P A/{P5$<q,t %u<فfvP28̰QspRtK|t?fj7 $j#]Paoy u
RPِ!ff_Q!"s`ɂSh j1#h;"h h@EhPC`Ma0tT֋PtHt<Vt0"$(x$@uï2Ç!@`'P*"40ك~g
})`'ЖRiQE@AX9FuΊF$u%U`)8R. `p;Ft 
RE˰2Rpuu1ݥ?u0SPCWqZ'zQ_0%j Oth ^RB"b| ur?v= @v#` uv	Ѿ@vl hM" @ҽP?+`R@R"|h |
 ؈}^Bo0tfb_uDPn yu8fhU a! n=u;tdN"d|ݸ[4<bfj`Mқ@VPSƒG`
PG` (9Gu,B)`@+wac9Wu2{>|7@0P)G}GpuGNW9HvYG`k@	3yO>@W ?`8_GGf׋Gt@f9FtgH6XP^Wi`P	ۋGpˏ$I#+5< !ufGxf8A^P(GtWvc`w6"xgh2 =t(MCuF 爇h %fh@D>f+f|a?Ǉ  sG dUfSh j#[lnp r!DvtDƇP֠>>P` a? ? {a@ @O ">H= wsvC&C2C:C?BCJCRCᨐN<NFXඡX+9W$rLw9G"vE&e-iPЩwGA"Gi^ðU8$Wl뤉V) rOw90vG  [GtQsP&YlS"W$a|g1"
@Qe[Pu9ïFNFPaA+K F &@BEE?PS;FtN@  l &gn c of5^A\и GA1@BP409FvߪB+F 3p7::`f!f6ulGFAfhA880ؾÐ3S/P /P/P/P/P/P+PA"G 2f
#f  Q0  РȺff-$˝]WO@>"f_] H2C@@!PQRN;ssZ?YX]1t
X	S[`[PMVB^H& p 1蘼H4hh4J4 JK4fS4Jp¡ʰ	p^,*n3*sk at$?h: 倨߰G hZ e@Ccvވп: >RN:uFo~rѳ q 0hn  tfb4qA>f4 v:W4 }D
wq'h  3 h 軔PÀ>u+0C$Pj
 .{S4Tf

YJ4*HtHHt7K>O4}H<O4uU~]
@Q4wV4Q4Q	HB7`F\a|^<`Okc	@! 	rqސX	!G@WB`%'&!(0&:@#|< Q
&c	A(r]/1Av	P0OXif`<@s}" SE,;$?~'|6"A˲0P@Vµ1⟁~Gefqf+G0 43<ga׋G" 8Pȋk,*C
N"ha<u AM؋G PS  G1GpGQmE @ BW  0W	@ !W#%
 'W) t+@
  -W/;=@1T<|@ 7׉W9;ߺ( 虃<W>$ {臣@WBhPDB|PNNs	LH4B3
N 6
G@R ~u	BS3
XQ1Z Phߨ Gad gCRjLC][4C^ceѫQhaP baK4ߋM42kG/WwIe#JG,) w γC}a	YC	=2U"r1nq@!6F^^&߇}^Љ- ^?a׀ Y QG0G QF=C]$Ht	HH~ : W	=@W
t=WtueNu	f{   }Cp@}-uf0\ߊ@"|N t݀N@AW4[}btt3R!G<]0 h Bb ||/` wu_h oflqw  uG G tGWnP^4`0W@t)GWRI Nb4d4f06-f^4fߠ^4%F @@ +^40ua)	)h Z
p1蕷`t1Yw h Ih
d4
h"[
0

!a*`` +`ġA׳rV1ʱ {+{q.|&-q_ P@_RVFeЀ^&9G,~_! &x2 ~G f&p.1@2w
!1PpXq)F|@Ε1@ _1 	`1}PV3q qPѶ@;fP L^@Mp6hFf #8vY' QP<s9PV3P~22ooooooodЀ>1 u111p 1oRQ?11a1#苧@! u  V+10퉿Vf1 sf  rp+9Vwrw V)
q댤F, 8`,ߊF,q t$*$* 	v	6aĊf!V¾pȋp֊n* VԊ:	 	-t-,u!GAdapter - BCM570x NetXtreme Family B57HHardwareDriverMLID}  
 QTo  UE Q   /	  
R 
 ^<      < ]@   ¡pO   5  
ں  _W@   BUFUUub1!XWWzX"]rYWX{WXhYX]XXXXXXXYYYYZ'Z"]! YY[XUV4 8Y+& Uu[X  	 
 ]˺wW<SVsrt*ݕ+V^[ø.V* &D&Tr++D&5&].Vù VøtK
t(S [;Wrw;GrWڋR [;u+uo+DDuP Xه\.Et. ǃPG*_G,_.O7HuR.4U tlUu4  glvgn@w7 ñ..V.V"Vr0]7GûV  7t&&TW?L+0`~< .:uOu+.V&V+.: uuL
Lt\
DPX~u< 0s"UU+Ұ.:Vt+EZV]~  &V0B_OΌOWt&PDB#V ^uV&U+pE"u.Va!".VVV^cEU觫.QuMZY`Q Xu.VeZYQ.>V u _u;BVp Wu(gVVD,ث+|t#6"UPU <rg3.U.U &u&D=vV U3ɈM .Ɛ&0\`!##Atʢ.9Vu.9Vu.9Vt@0.UrF;wrtI着tJE ]P9
UD&D tz}R@Mt>2 s.
 @_ Q&|u~`dE

E
ED)7
 Y@۱PQ<wpU
Dxt.VU;wŉ5EEEU.>UtE  m.PM
u+P.UEP E E
EPVE.;Vu"VuJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.	U3Ã
Ëŋ+HstCP
u&PIٽ{r+\2!&/GIu*\  KBPUSQRWYkX_ZY[]XA6D*VV+tV,T+ێÊ&S&G[ú<V|w! Lr	t+񬿪u+<VTLʉLuIuËD頋D@ V^\uA߃!D<w<XøWø~Vø.UøUWVQ.U0]P U.$UVP  Q   AVY^_PS [X FFt%&?	?u
h00S`&F}QÀ? uޡ~\ V ӣpV~පu20QR 3ɺO@ 30`ᰠV
 Ftf~ t _F&VRPWV~@N{V^_< $~ӤAWVS3}GVpVF

VN 3Fp ӳ80pV`ٱu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3E^	۲	ɰ	ȱ	f		+FV
?+FV	Vhoi^b&$0<9vF%@܁                                                                                                                           -     P16X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                               .6                                                                                                                                                                                                                                                              eUPQRVW3fu@F(.;3s0k@.$~ ˁ ;u
t.$t@~ f^rf(_^ZYXWQ3.>32 .ǅ$?.ƅ$ ` P@hc .3 Y_$
fPSfQW	3.3^hH ^ hGRNwFk@"~ hU 
N~f.$=&@.$2.>m <$uv4.B$f<t	of!h$< F.4 
_fY[fVF~r$F F;F FBu~w
fF@ M~UfNf!t
fN}!$pu
ffsfF^P2$p4ڀQ$
fqDF$<u&f36$F # ~$wp` $.
u0 <uO8 P^`)V.k63@..3.`/^V0&0
09t@ރ-2ۿx@2
E/^S 65^5#5o$u+:Nt@_^13$::O
t3-S9)Q9$um8Nuû_^7fPf3Vuh  fhA] ğ^fYfP%
S?  $(t uq5um0j !0 `*z-fVWfpF(3ǉFq(('F~Պ^ȿ^h<FՈF 0ff
J,F f^Vf^qu? @  QV3 fz ufZ^Y_ft23fN Nf~ tFt"f 09FvAFH;F`0Z 	QI A~f9Fv9fHf;F!:F׊F8F uE3!:fI"<`<Af+ ;NsGf.\ :^3(tf+fxD;<
I;f0Q~uK~ t5E2aP_F?.3NP3I3@_fd'ag	i"
S#0K"# Lt#^`#F  FψF$
$F$Vmf` ^$" $$} "u`UqVڀ"ư N" tFֿt'fځ"ڪ"wtm"5+d"b1"a2"f>1"7 %/ %'%S %#% %ъF8F 4  ߋNhs"  $&j(U,VP2@DcO ffbh$Ntt(sPeSQd9FvI" 3f%h   f. (Ϳ  ByN50z30b
t
F%  .`, q> h6ă~' t!~/ h*< VWUhPC t  f yy@N fAh 5 PhoQe 6 h/<rg&>Ut2g&FP3EXYPьX\P0(vX0}f	][Xf`Sffff hm33   f;r[hnU WcX
q_ WH_S0"J {rPgNAOg	rH. u \fawWfgf&Qfؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_zU!yg^&N;=g =fb> U?  q^6-A])QRWV^NV v0Wt6Q4pdCY$DʫξE^_Z QкК tYfWV3ff1%^f_cfSVR߶ÉFon1Z^f[ffABRffLЀ`2fTf;w
2ZǖfPRft#f3رzfdpZfffNN 8ss4
t}7u+%
u	afFf `^^ZuW0ZF8^~nI^B"8uAffF@b_QWVfvnAF׼ϋ~f3`RiAМ$ч45SV ޾@c3; t	 r^[à,Vk߼@cpPW#A[S?^@俊$*&t@;v7!tk~@t 1;FtFk^% Bk^P؊@cap 3҃  V3k`Ջ
C*Bc;FuR3t7*t-k		# a
@S
+FHu
4uGrvFvVBs0;4VW@B΂tSދ[NuVp 3ҋ-`@_^P@ʠ**ˣ^S(IRl2XH⠻-HP$뷋A37Z  fGVRfQFu   kv@kF.b~$$I$@frDfw;=< u r,.$<u r_ s0	 @vFfYZu@0.3FNf1Պ~߲d
t".tt؍׍pvXv둀~ }ZPRρ00;F~f!20a㐥""0P2N~ tKv њ0`X9lq.A\$`
fPQ3I> FfP"f
	M SQh3	_ \PBfq23QR.3Ѯtf.7&3.`.83tYflPRWfQ
(5.'{ "  u߿8ufY_ZXNW!` u1V#3
6G_@+fz`  Pfj7/@
xVfWf.
ۉ^2ۊ~$=`&	?ftufP f.3| 1cf.@( h)R
uF,8Fuf_@EbgR.>_3s$	Q.k63.3VЁ #eq 8
 v@a
#3t#ًËȁ; :u!d|;  v t'f#pffpp=prc#n;V_F"y:` up/Bqr[tހ~u (ji/ t>x"`{(`Z J I<`:<F  .3;2;sN0 t4v;2w&;zf~FN@I.3qe:2fV4Pb0)6SJJe{([tҋ\fsۂf`K8?faS/ $ !V V03  1@ ^YX@Qu~  u0Vށ833LitQn
tw
wu7Yο y	_^Ha? nchppL" "  ta#2JP Xu	Axu/ u5   (ru.LÀA. $0G Wo?C                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   A     TPM U(    G  N K 3 U fWfVfSˎێf3  _f=G<t<t
<t<ti  f[f^g.$`f_tIFXTPMDRV-MP-SEG16 v0.95 Copyright 2005, Infineon Technologies	QfSfR
gf. 
g.a3g.1Ƈ3 4 Ǉ,J gf   u u  fP< fXf1ZYcQ讱Ot[RS  gq	o <  3[Z0 
  
2%uP 	xcst	 0	f{
A
2

 WDF<		
g1$u	
E|C3f
f%Q`&3ɽ
$f6Kfff˰ gCA 7u3gF b`RfgD`"gC"f(g3fGf߹ \"agf4$ +Iffg` fG(  (	Z	_fGg'3gf`Ufr)tfJrr`i,Z4.;gM1"2.3N4g1  f_fY`>Zf^f}PA9!F3RQT/ʃ`ʊP a  3YZRfQSڃ <u1 u%t<u u3
߹ w 0 <	IR	컊T		 0 tϸ 93 s d _ psOJu0t  $&&A	ML'a
pn qv2fR&St2p  f  `OQ f"FB? 49 f t|gf> tup ~ tmށ  te t]ffֶ-N0.^.6A\RZf;sEA\u
 ',[5 1 
@JB$
gb +\^Ðdr
3ҷqBH ` u
5J
0bu"K ЃuBw1dUogG"GH!G[I#JHf<k>gu0hph~@ Y	uBjd<u/
uG u\  OƀtHDt$2ED$@ff+f+#Z舢qu  q^rQQBNL$K		v
u YpC0b%3 wz}ǀ 7ujPbT[4\ tL2`Qxff3ff%f  gf!a	QRdgAbetff<f;s gb
fgucgB`ZSoVo oA!o'oBmpEqfgPR%S%"R%Q%
iEgxr	S t9
 [_Ҩ% Ƈz1yn 吞RБ tk [@eP{m `rCfRS2 !@^R nook n```` s
@l  @nr
 蓦 PagdTf_3g3-3-t
1#H GCCQw	000
000 0j=ݱP>~p%a"Q,k+A-$#qrqrtP Dtt%53Q . ) t  tA@tt
 22: T,.bFg%65f fQ! !Nql݊q5qt21?  0w6a`qtnf+fH  gV ]M6kLPaG.O_!t4DY+*+s0,rF`"atfSuN3 (`H0  W. usIu3PiY mX7PS[`4 !6&  SIuއY[Xp$
pqS oq[ჿA tKC>X p3P   = pr" fR
4A1f}f+8f#b%  t	fˁf{jf%j
tpe/$z Fidk&   x < BufН         2 8   ^      SEC3(     SUW3_3 G܍M  S.{0.r ۏ R f= uf&TCPA W HPD1\_][U˳ "P		  @ z
  @  A   < t.` t<w!3ۊ.;@ !W 
 t_  @  4  `) nzp
`<wX1R[1a b > 3@ upawP.Q< `0~ u~tPfAi /@
t%f=uaebS
RuCfUf   0k "q  
 FC1ލ
u
 
s4"#@A0f] Íݷ&]0'7F!'4s  iR !}j]@

% 
@
fǗ  %?34QR
_u" 8?	%:U	0?H
2%8L8  6WX
hrsqˉX
WFR#_  "-H  u7fEfp2<#5#6
M)F <0<Q6=U6fPvFWfX(> ?U@?΀?? @U @7@@X@p@E A@AA BWBTH2QBHH@83 ]. 6us9]Յ@κ軃%"c᪥tK%
%
\\"
I%v5	u;2# 	t	1
T
Rfu aZRwn u
1PYUjc1@1VmP@aPaul=qG`fQot<tvq `,^,YPu_ƋA'ar	u_̴ٍq6QlC
{u/FfvuQo}uxA k e0Mw@\
q~
~P:
@a `mbcPhpuf]ZVSvbrl蝻vZR8_`q9hgA;gBrQR`p|ZYqUCŻaDtxw3&uwԄB{ux$ pP|N9`tA|ba f;tCC` 7C@C
o0bC3ffFfCfr#=qLsuM4@pNF CO`,OP
tpTP,OTtWK{@Yff_fC@XPS
rYUY D~!֋sKRp5ӜqaoOfUV1(a Zё#a ѫoXCr'C m)%!	*ѢDVPV^t@up H
CXPq8VWx_^ tKS[t^8srN)P^rNfǷ u  fF3sSV+1-$ 끻qD;w4ƀ1W_r#^?[Vs1	Vfu1+^&F QVW/$q}Y3^ѻ TA FKZtVW7{ P^?                                                                                                                                         0    o ]FprT@F"` qqSb@ eCompressed BIOS codeOther     Calling INT 19hReturnP
 via#8hBootBCV Device 6E6    IPLCPU _patch                                                                                                                  #EgvT2b`4  WWsհǃPǃqǃ9ᐉǃ01wЊƃ1r u
@ow*`Q  	@g@_p
ȫ_a`Q;d&GX7 ;w+В +ȃ73󪋒@&ast@3CÍV_3P Q 3ff@r	#3Sɰa pw#@ yZ1'w33n!;wP##X~ܼ	2b[
fۄſPAbc"aW	RX APۂA𓍳&a    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ÕByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$U)CompuTrace V80.829 \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      Ow qOqP WWsUPX!	 nlAmNa &f`2a UVW~
3vNWXZ_^]
 !~3АH9E}!/f`!
u`"!W>WVIVhF۪U rr	rH0n`w	fmq29%fUْ!om̑3ɊF0r	wk
"e <ar<zw$ߓ&G+tdwCu*䉵D]f͏ ^m^ǓGGް;v2Ft	
n[9ؗW75Fb,1hCV~<=t }[2F uƕ@]GscQm^|
HۙG}~wWCfEnGff;sB_V 2mtl9
3ڸ W+vOΚ))_J?JѰ[.	<	6V8d]l,\l]Pj{[ lOPhC
DC>C5ul1?C4u uxytG
	t
ƾn2jn^6]~5?t$xNF[
jPw^97w3 s)PP-՗ }6uUۀ |F#juu6>b{,.)'?8Dj
4
2
wMv21
@uf
Ϛi4$hЊF#bPk

h&Y
Jv
,1oCjel*OWenhh
0=}kT{Nw?^>|::VJ
UUK\rP h0t\V4Qdx?$dF3PJ

ݭLAL-hRPӀ'j9sT!A{ r!HG;tg
[4J |;luh\":2fRf9Kt8a'WF뜳\&서Δ\ެף"<Wz摅V_>u]XZWoQ hLDn\'އ2k$6&>O`/"F)#K<Den%ᄳ6$vP %,`uVP' vjX6n;vt_kj|ԾwF
5x sD_G@ui5FfdE+
w;Z bu.hVkD #Wlvu6r83
o^ rn ~ޝu&j o{F uWkÃpLF3{Ulk%o[T#
N&"c?٠(`58^	V1
)@@>>)BxeJ",h"Dd,
@^~y
 JD(PypZPH,E%d|(@WuJ,|PNB?XfpE'7	=r
$oyR#f1 2Pu]VnK=kv=,l|."]	 (PhֽоT"brR" !mVB3xV
Ђ:
0&
~Dk>)Vb.WIG<@|] Ze%' ]$D0ݶ(4
 5dEhVDMuc5 W
'90|{"`FJv-t- tt
tuCnu7u9/u/yUu%}7wXeoԀ}% KRPS4ǨW,;2j-RN,u
۱<<S|-TbfInr JYp!/xxNF>'27Yv 
<z%':6JC$I3gk-$Kn
W	6<-b~9uCQ*jK,2?$ X#t
YKjVmZ:ZXm8:X:mmO2u-62<9;_"K0hH!FT2nP#w`L7[[PP,dw$l\ kaJ5o9t<I{r_uG7M6Jv>g:Avf#aA]Wq	sc ,7E	P"A۟|R`\#< XeXZ'^cN,"}wV( w#VV!uU33
O y-[!bύW~ePhJe'BVWBr$KukEKLLfMfXfꭆ[5Nf+,9tk'7KwKY-\po=w!u:5o*tA<3_Pҕ,*$CƙMtZнt
.-
4	s#DeYS?\t iFt+ted7ORNޭ+GH#FDuu <fH+#$7#H3l;N3Y|(U*ۢx EG"7I,5P( W?4~r͋JK:MRP ٭[j1I>
#26U$<uT$_f@t=%? 	W{%N;xf8$ۂ\^FOwmto㲆e*c:ğ
a^8mč۞d&ًM$NX&(zl NfPfd "ƅ0CYJ%6h JiI\	j-[Ife[~ƥ3tE^<R;lu-þV.GV$hs@	fGF!"+= r9puB[0~k 0y	t Jxt]K0Nʷ`H;;u	Xd0+}-^? ?CCG%[!L:
cȁmWs]i5Ѷc)xR+:ʋwO
9UuNw, 
~HOo %l4(@Z
6JGDsuDJҎfǓFN#}`  
HgClD(?F6,H/Dhf#'`J-`{ #~T`^,/'Ui=hC|$-Blxn޶.ئt}w" M6N	q".C"Plwƾl۹ZߠD= w({.2@usyj95Gt/@nd+@u2{|@tR~
׽vuaJ?C:?7@
?+1+s>{u$N0BKϹ6. ؙ
;~rc
i./a8CRU+z"TkBNO	rm{d
\q&	2
 r	Xvt9rw9~6
?P
|+RH6Nr45x4H	^$#l?tDD>$S
=yNQ-H:+$زE<>:4!SH / :}3G61B'R
2$!<ezi~O#<>e[(@tetK?H! mΰl#EG|js%W?	N7N*q(>gϦҪf࠾?wE ۴,ۍQ)b˴o;WPP!{;P tIV%Hnk4h;$Kaz#VNAJ|BdFpn*UFń }歷.DR
j4'ZIzJx ~SHPIә(s
`|G V=IKu'w"dr!:c'I?F*R<Zf#Q,pnBT>'OV@[%tZ
t=.DA;pwE8`ȇ,^l0Qfɪ3bEMPUG mtٳ!Չǆbt#MfU<Y	]äFedt6ƛ
;c5뻄D j;xa<2`p@¼-c@Bnr
M9vMu	P3DVP<ZvLuMѡ7"+ҋE0g;tcF[fF8rf`˚ R$;F3u/-agf'/OB;a;Z!c떼:\a&NQ\fN{v3FWyRȦγ`2Z,)sZ}7j Za3Z|R u2ϊs0j0'/^ 9uH9Fo[+C2&D6L_P=)?nq֥&MvV;lNQ7Vl]G3kvB` 	
|,*rXGrLv!L.fSҗaCGL%'=A #"A'l#at$!!U"ۀ	
	/0'vL&DY.LrHC6c;l6,۵2ތR##*eT\2ʎ;6ƣ~ǖt6\-3߱_5+~u&# _̌.ƷH(j|v^[@%Y`PC[Ё
4-4m3dn9W#t\Z#@9jt [BSԽn#lxF"XFe]Eܶ	
@K%^3H+-P ո~&pV
B	LmG=Nzfh`;65b;'!f%T0eJmLtştdkꃀmdPVYGV-U"t*{¢ST{L鶆R),Q
@
XPjҏ47`Sr@Ĵ F/Of@v%
{l;Qpx>R/2)35T@ SVjd]Wj
+h^YQ#
N Q#_7;l*=#DD wr͢FWD 'hu!*rŠ%,k{BpWI|}0:.	!wFnm&(.,
ptXEj$$;+*^%4%#5gy {OMP״5t~
!`C)%Bev`?}"0;vp1+J	B7+h2~Lp`՚Ko%GtU꥕ϲdkw@D[MQ
09pv*ι>l
MN
o
7
:*m9sV-nTO;v})
e۽9,0FP;cKSWЋU'9`*R-xɽ'q{zU+x1lR1u4W	<{P%; X:,
t3,;K;Tt%3vi9	;uVRR1#}sS4 u;|0k"aox^;+D
-7k	WN8^E@t
zxRe.b{etw :^	wߛn!°
D\3"&C34v<-[
LQFmG/haٚM@Mj@r.G$9bd2/HH\ -EZ(?'lhOl8'_ms(9yq{YGYwQY2r<pS[AE/9[rK"r SuS.h1_m7xjP.JD
+~jz8/epֽ?W)`^l
A1^E*}~ /9|W7[3? l+/,;rw;r-	6"	pf:0(#6{\{!N
*A}t( C1 BaiR3 REٶW"$W۾ge:|Jowzrgcss+;T*6nG^Gwj=& Gso{uV܃i~5JбG݁26T|Pl͊
BWh A@fbG!a]oՕ4;u)^LQWc`N;P<@;;(
y<Nkw{p5і9
kG[uՎ?`s@? =GKpcG]+=\
tE_@Iv~@nPyt¶uZ9seD܋ʃ{+[; @kaqR1t	D	&,q%<H)F`*R,(!7L.66E@bG]ŗt K|	SԾ}ݮHu|CCQ+!"ZusHǜɄ^+674$GAB
v"dO&7gcD0m;4tfKάʴwJ(`_\Zc#!V(65'L8,d`#hJ8
uDkLs,5\VVbѦ "aAH![bхQ;<*bL
(${k$Hx
]Рktq,|=0yUzDNoR
fQ6pf]wP
ߞ6+T
TK|wt1f+4A&`Tyi+ȁqxΈSd/NPG&&>*0xhnl
?"oVWVvB=[%.85;)n?6oL6@m&TS*蹳#66**OdD̽ LluVzJ
!
Hoq|-+!VcXs)I%ቦ%di1GNIs2xpvN X\L1dlHBPF/a[d]Qm,#&z#rr6Xrv]ANY^Tte<@'c5a5fj8#'2R$<Mؠ4XwHmTq2 ;f)gRN Q{u$A/V3.ј5G-f1Ujh QP,cO9WBtH/{C:Ame*PJPќ_Wf<OT+NB F;sfB;v,)N-PO
4lӆp04(!dYKBOSº%칗ɲe_0!{ lcτu{E 0aclt"9
ֶ	
lV[7)l7SdrA#^\K=^IP+`7|`SZ޸Mp -wr(rwk5"RL6,3#@|bVBD~=<Nm4aL0wm&&ҥr<xذ*\BVA6	"U7d(NΠ,T$lL-TRsab[	MVO½
r r&wvd He;+BBkM;˂7b49
5aFUG)K0G@8{	P'+5OFpEovP
QueuKtj/kg.3YЙ*mFo GG:k9|f.'|pp+VR'&_$>DOuҿA#2V]DEnl~ͳ#uM+n	>6w@ 0t1@;wGJщBbG
m5HIc,o.HHLWJ${DDt:ln
Fe4@Bb[
L8
%<Kw%6Pg+$LN%\rV.J W"Cô,ۋyDFV۷HTJo< ,>ޭu)D^m(AhgTD#6fȻQjqÛl@xYHF+JCFdDRzAXT֗mnVX]5@(N*ʋHG18v
6^8:3kUr9(JBsBs;V^~R9r
eЩxcx.FF}tj
5){^ƎEa~
D)W[2$0Fo22Ȉ
`e
0-81sRk2Y:\htfƴǄ|0<H_8G2*w96 w]9~ v$+ǹvCmTҞuk2(S odZvyr9Rg)>k6ΥAv;9u@;?S~v/8f5]!raeA-q+'multi(0)di`skrpartion(1)\WINDOWS \Sto| Menurog{ramsupIAUTOCHK.EXE)ystemo	BOOT.INIvMSES.SYS7inBootDirė7BAK8-rpcnoetp.exe&ϗ&&MZU{m-@1I(ǻOǶ$Ǵ/RichSPELiD1\%uk% } O 4XW(
e [d<.tta_#n`.daή2K
.c(E0'mAsAR'reloc'VB  4G4
*4MDRb4pz4Mbi
Kֺ/D7i	Rk\??\C:Rp"k\ee%,{Regi-ry\Machi+&Ԡ}
ntColSEU!ervicesO Local OhbjechImagePeh TypmEGorF#0  : \^Ib	hl@ d:$7ۉl+SVEeտE9EEdރ,VB-O~=hom9N3Vmo"jh;7V#PhPPu	@}` C|+E59640kkud	m@(-P˲7݃@-)Vbe} M}H ;̽
vk2MIv#3"H߶
ܭAR8H}
t'hn!)s>8?mf]_^[: ۗN/8F> Dt3(;p`P+L4afR@JbAu#8ƅ*H~݌K#@|L(<2j[B xC&0Lp!Nj	&e[Pxf2'j)_RYY3۳`4g-;u2j0(
j.7tr;j+̅ tWfCZ)A:p9fqiI:li Fvk{3}C؊(un\f342#	gtUW$6EfY
fY˳3WWiZ;)We}}c}cf9=ޭq
V

xt}S N<ƹI	W	gPSDn{pWI݉M@86\	9>uu[Ac%,Y8$S*:UW?  	mO0vz(MLavӀV.L6S9DWPZ>uS;5[̭̔ Q} 0f[R 1MaR%zBB7X
VjhAJ oӎL*[Xy_禷M}6ZZ`
Ë1l7 U949O`a'@o N7hȍeFilrwcscatRtlQu
yEnoףnme,Viab(_U c9Fs4wCDeleRRd0g
F9lKKeyW
E,|orchr nInmUcoden%
$ng%١s[=PTmk(6osٵupys]EAmwdQtdBll.@JK[
j9z>9ǚ3b9o<~<9?99{#sc ,6
NR5PHaCݰwF>dMpJNP563L=:S<|`Gr<&p'@HEYpiZL8$D,HMum7zAi*@LZfizi+aa;4,<MR`t44MMiC 0<NiZpi~Цi
".H^A@4Ҿ4MMӀp\4J>
R(sEI0Uzsvo&EyEږ ImOp**L,t5Ht2H4fois,kxklrc.ed+SRd^RequeZsk,lclI5kD:AvaXcvs Moz/4.0 (.mp*i$ۿ; MSIE 6;f)Eַ5W%}HatpMi_BjOSTGAd극HBsMX</'Softwav\MAr^]
\WKowsV8\App m&ip&ڟ{SgTagI'D-Lmg;: %d
%sts;}0
,V%%++*/ *!K.!@"rp(t(77./--K/ܒ//?3n#@.r#fF}MVWf=A3t	|$Kgw{dDuP&l&^ʋUa7jHkEBXYtVQ-m4-N]n'V 
&	V>4ڳ6f.ZsZ}}50Q!"E43>wr
C~^חBRtuKKF]jD}dH!G ssb# 燯KAXN<
HDm(+P	JQS39tuSSjPQ<0u 5&c7/;[z}8
	/4Dt '(!
	ɈH܍鴧+6Vu<VOX6u%A;*?AAYtlruE;>YP@4@C6k1pky~Eh/
hy75c64wf(iJ<
Epc
Z<< w8bƝ&HɋT/z
/01^uJFPQ _`cAC_Ph`l!=>sW`:u۽YLRmciAwoudBWw\(a!hZD4d#dxe FS+cY^>-W;\s6M%D0G	@3ҹMNvV`gVC~_^[j$hHr\eZi;Hww34D\@S2~rA.WnaHlB.jT6HCԑU(Dv%ލLPbg ^(uS^B*{xfZcR
[$9ߺ'v4+Q3 :"shYnxl"ܳO9]v/k u޶VQLЍQPfͧLI@mg0?P(upkNOZlj
,qKZ] -`̄vnR,ׁ`\̛`r/_tm׊2_DUW$lU{͒Ķ{=H
t"ǾTh
q7'dD1ӋeVU'ԝn_][%@\ppVub	lV0Ę.a6eVhM
N"^k >;-hɱ=URu
g{ؽ`6}PbniDCۮ-jC1 ~ H?a({(9VD]-u$0~PHB%NiP	(0mwmuQWj\d"Y2RFU.ܺxkGxׁRR@W݁
|3 hYW7v0;s<Uum?G:\hQ2Шr7:r]S][/Hy; }	^xfi;|AB
X9${whJG h@YSGA_@1?A
,rh8isl ،g,EVlSad9.$WnVOhlם8Sdkl mFZf~X<[>0)vCFxV#`} JSP^h~TV\DSb(hF9XDE&3s	09Cu}^u$HhdčV6@z6LQjn('^:F*͍劫&s.Zm=Bp6Wmml`叚kt5;t19PjTRDvWhK,k#gFࡡd`6𪋟^n|c|DhdCp'5C`<y4B}j<(/fv
P٥=3p2z`xL#z8RhXn5( haM6
Gp$eӫA؟'OB޽хu	=x!<]qh,`U8T
fǀRoCah`(ǅd૯h٬7p1XÚstN;u	;(8@'EVIw=bW$l9zsFS]]s9t	RoLC(jHv8Dr[H^.8
j(zkZ^^}W݃5`MgB+}9k
xt9t0+}J
06ٞed]\\]>x@u`tm-<M4^x-%2B!4,B:Yҩ |CQp$ ;!OJN^g$<@ 	^&3ھ
CQ"63Y 4XF@ ;|ܭI7Y䱾h5<VFxWQʑV88І@KN\77A謆&,7mb*eR9P/QvHR4IIs`ET-ԍ/n؁8!rcYf,SHH[3l-w{-6atqFW/dujd'8+APD3Iz%quSh'5$04,Eepdnw>d@-йP(%NÐNl0P2STg}̌<}V58Q$|($Da4
4SnoXO4 ٟ%JlFk(ܺH }nhb{u2!^qHQY.Wyz&5\s<tudYO;tiFltNpNl}T˝S^<;5.h+8+=,^+0tjh.\ր$lСY^t 6NT~Zwb!|{:u,ZW n,i. 
h[\DI4L%c<2l,,40=@@?*Du8B!ρ-jw9.u9'|Ohj`U֊4fՆԢ'Ǿ*njЩez+R;`3Zj5fKtdA{&FxPQsQ4ᓊ#lqbWK^&Hk!nX*
=ƸRVIVJ=hwUAK:o[SێQ 㬇 ;< xV`xXlHp3"Ԇ98o9SJ忢K-,CDVuύ-rj[ = iGob[m~$	1`v5<h0پF$\(
0L,$#,gwFtVR39w:Ib\ x^{hɭ75m4tFP,FmPZtL5J=:azhq~\8SFg!:`W0k}C"F3U<ȋX+Ѓ9Ul\A>
%wVRW+8h8Iͯ(p ϽnS ns
4PS wĕșV$Rnh<RP&% W4Wػp2x`r@$
X0{t
?ى=2N7juf(0sh8$ʸa N멸-4ԃCAZV4,+hX&8 t&Ĳ(rn3PVwKGu|Fc^vrU
-jfQqlw7@YWhЧ3$`t+l8QZj\
>hoHi98$X\HӬ>j(h*>}Kh F+atPX(|coWUZ;u|l|mtċF<6@?UYY`-1DGKe"A-r
'ez	p	0ń\|j3AC^GEr:H=1>R
H`x@~ Í3+K
X603<@GyVi
ion|;Jkl(mlYUk"K̆Qjz\\
3';mt;^
%;%>XtǺ#*u
E^,(fmGrIþFc:D_٢p}'f:՜!A,mܯ!l2(	Tf7CttlR:QOSqk3XSi|l5:{ӣ=ECe7 l|,> +L2'0@(vtza6E0!}
t M p4$wa?u:0ɯ?ldTXЛ[oPs?y"95\P8h8*LaX,qpP
y%@f^:
8zoWtt	øV5%+!CS[lp(8vIVA)O  H"0V
lj%谋L- et|Dvhy-DHVJ-q->t`5/9X(5Uuo* >W@(d8F;[tDA_%<x=)Cr"
n'gtb=hf+l@>P,kŅl3*DExAnt]v֓S#c9\W*\JW][Sŋa]-PbGt0Zh(Qb=XCVθ8|ڣh0T}[wQUV3ퟵEh0+p
«"	* R- Qu
V%][$==)]k J&V1_[$=93C>j{ӡ]ӝ^Pg**7`Uy\^`]Y(VTG.ThCT{Kt>=x [
rp Q PG/F׻X!kXУ!2uݡM Sx@@b*Y54AGS}h?ץG'"B_Ɖh`ɨˣ
%	9=&hä:﫱P}NzC"I؄1)cЊ0&pOL0 <& L
(
 9c-}WrيEdɖ!j4h`~OȨre{8;GzF\b^>Gu{vB9 jnUeb?DJ
J\j@ZPhX(UR[9N>~׀%y<kT7b?jHPXh6@Pڀ	cQrHP]
d
QqBfxJ%VQo
@A)!x]=Bt(JaR0ַƹ f
e/Rl?OGodtI+σNmL#pуwo$:
}p/\}9->w-SpK9
۱
-V
{3L"O 3}
Co^Bw;˓uGq:	IQ`)4$/M9DR3`c2ڮbӀ؁3X2ۋkapV2sf+!u!FBh3%^\Q~dl%5ow9d;u;},<t8;4/k	/;5q(]@h	sj}f[  xG9nn|~@<֡nw]6 xS]&z<C&gc(vCzEջFH	E
ӍY\/}tIuʻASB/m27u /*e2IUڢ+;_}
kA5oD~o3 ]5Kz62[ Jlx%À
w8~ۈo
}}}qwrhwb6Q}W)	V(L
V_	+<#8}[%G8۫̆<b#;2^\0^T Ph,<~mUkS{\1VO;bP}O;|Ԋ.b?dtSrv6R[PWtt
%+f|,aj.bS~[BXK~@$2\9a!Ȓӽك2. nD? A 4{8>r2ˢEP-OCK32)PuThdMkUK~TimerD(>vEx
is vch1G,:GeezfCN ECla;?Qui0 Translv-aPeekڗwݠZtf첑efK`USER K
K͛Ar)۪ayA}ForS leG 	Ev(@ hAlv1R
FFPO7eØ책ddrgStd[⏬f(m0mmzy sqkeG!
ZikAS=GI|&  ,itg޾+dAR`9#S4Codw{um#홌ObrppedltLZwCna!iL t
NZVP1|:B3Te2iL6;$(a%. X; Lib;(
QVt+pS=py|8lx*t@HB`iB[@l>[M ]GvT3 "O-P7lٶi6l.;́aMFpswH8aYp<atG4lP0f f"lizxStԜғKNELDz(Jڱ=d6Cn'r?N79[\'5	_=$sUs*{~KeTokju]5h5\6Qo
⾀Y٩QUXқqADVAPI EfyE5AEB!Q|%@(wʔDM5(MhGeSP=@
m893c(&
d@`! A1iQN
] F(GHdĢ̛
'i<9~a |6M=-3+(8G#  W 11333333333333333 444 4,404<4@4L4P4X4\4d4~4445R5t5y55555555556	666 6&636>6H6`6t6}6666666666677777!7P7T7778388889
:(:::
;%;M;;;;;;m<<<<<<<=(=R===+>|>?-?7?^?y??umPw0/0P000K1m1u11H2j2{22223Z4c45:6K6\6d6k6q666666657 7߱777888ߐ8888'9.959i999999:B:K:R:X:m::::]::DS;Y;c;i;n;v;;;w<<<1<?<^<u<<<<<=$=*=/=5=L_=m=w===>>8>R>m>>>>>>	??!?(?:|?V??Y<0H00I0U00000001>1L1U1f7%11272e7)22$3 ;3\3x373344#?4++G4V4a4g4r44444/44555!5)5L5W5d5v5}5555555?566+99|6?S6[6b߀66=

ރ%767C7W7k7|75777777tAz88
9q:::::::::w;(0(0,0 80<0@0D0H0L)TX0% ibP111142@2KU2^2?3H444ė5p5~5;6x&677(7DTGAа˂(     : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       08/01/06YDV*U(   2 G  N            N   U      WVS3    _3   G<t#<t
<t
<ti        	:  [^.$   _tIFXTPMDRV-MP-SEG32 v0.95 Copyright 2005, Infineon Technologies   QSR  .   .   3f.   f%  Ƈ  Ƈ  fǇ  J '     u#  f u   f u3P9   X   Z[YfQfSR3.     f t	   3   Zf[fYfQfRfS      f%    f             f3f[fZfYfQfRS          f%      .     .   u .    3     R   Q  .   t	  >   5     
  0  f t   u
  f JK   f u?   j
     `
    $u
   <
    $u
   (
  f3[fZfYÜVRSQW3f ?  f   5  ލ,  f 3f fǇ0    z  f W  f3ۊ  f@  ff ,      (  Gf \   57  4$f f+ffI߇Gf( \   5U  4$f( f+ffI߇Gf	 \   5~  4$f	 f+ffI߇Gf5  4$fG5  4$GffJrZ5  4$f5  4$5  4$G5  4$G5  4$G5  4$3
f f _Y[Z^<t.!   f3fRfQf%  ff`fʊfʰafʊff3fYfZfRQfSf%  ff+  ff<u9ff<u+ff<t<uff< uf3f 
f	 f  Cff[YfZfRfQf%  ff!`ffʰaffʰ f tf f3fYfZfRfQf3  fs*f fd f   f3   fs
fJuf f3fYfZfRfQf%  ff0ff3tf f ff3fYfZfRfQf%  ff&ff3f%  fʰ'ff%  ff3fYfZfRfQf%  ffpfʀfʰqfʊff3fYfZR.   ff3t2f2ff3ZR.   fZ VSRQf       	       fǇ0    tw> tr~ tl~ tf~ t`   ֋N^63f  f;s  uf
 4    f u  f u	2   f 
f f fǇ0    fظ   o  3fYZ[^QVSRf3ҷ  f      f      fu  f 8     fu  f   fuB&  f   f             $3   fu   f   f    @ pf	u    f   f um@   Jfu
o  :f
uJ)  f uf S  d  f uTƀtMt$8  2D$t$++ȋt$  '  f uƀt  f u      f  Z[^YVQt$L$	  f u	t$f3 Y^SRQf3F      f u7t      f u"3Ɋ    tff t  YZ[SQfR    3f  t tf;sf          fZY[fSQV3f 5    f uv  ^Yf[fSQ  Ƈ          Yf[fSQV3f 5  (  ^Yf[fSQVR    fS      f3ۈ    3f 5     f[  Z^Yf[fSQVR<    fS       f3ۈ  Ƈ  3f 5     .      f[  Z^Yf[fRfS     ff     f t     f f[fZfRfS     ff t   f t   g  f f[fZRfSf2 f  K   f u.   f nf3
f f f[Zf3f sf f f3f fRfQfrf
   fr
fJuf f3fYfZ RQ3Ҋ    t   f uOf        ;w(     f u  f t  f f YZS  s   f u+    frfrtDtt*<f :f 4f .؀f t#f t؀@f t
f	 tf
 [fSQV3f 5  ;   ^Yf[fSQV3f 5     f u5  f% tf ^Yf[RfSQf2 f {f u.   flf3
f f Yf[ZRf2 f A2f u.   fff3f Z QVR3f 5  ,  3f+HHdf u  c   f t	   f3Z^YQRS3f  .   7   f tZf tf f3[ZYf3Yf f sf3f3Bff rf3 Q."   tf  uf3   f      fr   fsfIuf3fP   m   fX."   tfYfPfSfQ."   tfC   fB   0   f '   fsfIu   ."   tffYf[fXp$
pqfSfp$
pfqf[.    tUf tJ   Y   fs
   3      9   fr
      3'     S'     [S'  #   [Ë%  t     %  t  '  $IFXTPMz       $IFXTPMFidk                                                                                                $IFXTPMBuf                                                                                                                                              f   ff   2fff   ff3.7tZf.;|u.Dtf   f   f30fy   f  f\0fnf30f   f3f30f   f   2"2B     9                               &`"L1^9M|ȵ-M0%V\FWFVՄI/N#~j0
\3GVcz7PAF
͹"MWa
&i,#,γŔ(4İٖD'9m	yι7sM'pUgrDkA[JN

΂5hqYTV?z2oKqYs!Ј]vFwl|g<۲^пIS!A w`J_
s
	_KPP{V+{+~6ooXi(?>ֻ>aPU|G)XbHc!d[bcSy,\ޜ~N
_Y
(V,HgRQк'XS#@K^alf\г EW"YFh&}=tU@	5syz[s~q]To,M[
$+X)f7ꛮm$TȪ~%<?ԐBR4Fvc߬znuNax$iZDxoI:'0"֖߫S-ӭa;ya
"|4'",wK(`sRO8YZD۩|;ȱ84h$]DVJ^:F]^H.jc@> >޿K8f^ u.I(֜SM8rն{~Z/,ATOk@**El_}#	;l}(QS[!8}TeiԔv2ʄ"y,^묆-+oXÄcXAJ<H_|+f"́&DsKƵ+8l~cr+$@m#%LCh.E"s&7}8emg-ϧKv1T}QR5BaiN*W?[3F	߆1,Hb'EBޒ_s6v>i Iċ"#k/SԋOm#,\䎧ܿT0Hͩc,#rд~!Q^GhMm_[` npkm4R{`Y;/ 2NS\
Ub2y,PP"d1-y(Q
ЯJg q=`*q̼F4-|^ŵ_~ExcJ3'tfW8;("x (,Đ<rC֓Ftu0ls,LS5mWg$EكGf%f9l ڀzFM[9p06LMVP4SX>~?%Jcg~qc6XFO4U*a`ɣe /t-zc`|QMe鎝jz#̗~k\&hFq0l%F#l`;TsC lk+O[>T##G 'j/q>8[6ie>::D#.2" K6ɥ馺t6`6IQO"ɆLb]LE}}cPgҝ靼` U"ܖ6Cg#OJ
j\CidyfuB+^zp~&$`!}_+@P0oBCO3'Oh@ONpU5ه y
T)ئqmո.a8DߗF#7!m
0`/[uٓj8ehxy8j
L>GgoO.8g6Ɇ~7GG#2g^	D/W/J	OlKت(x՞s?0I+֧xa}*b>$V{=[u[_6mRn>*YZBn&Z*Oy$$d1rW|/c ,&\>W]~:xjM=я&
/Ը]U"=!9a!Cʄ1Fp.\^7\lUI#ȆN
%â)-)Cdg*cFQ׾F'E7lU\=|8|5embBA$!}!4o|4řb??R
)g`t,t.VثbkHdT`pQ_PT<q%툐H.
7SVsh:nIs?$jL- D^t6.W?d$xHGʏ\պH|lEk#[{68C~U#+7X
]v&e*%[GDmg*	QIf*W>jLNJXSbZi~`5={
.$	tRbN0z_hTw(# T<NXQ[16;6Ƒ{-tr1Bw8.rXX3HK(͉r.J
%ah5$3~Ԅo,-D#zI7[z;3sD^>$έ^si
Ad9dttQQz@0cZ|f-]>И'?|@ٓN=;Dt~y8`mSѬ7}'CޞK0po/8_ߑ]66Sbu:	Z?xqLGO&jM@cNbBjfo[Z*cs$ʻ߆g70N]Ɯ~h	.HyWٞ21<AbZĜqZC(}dq[eTsٹYqލ@nP.BU"z(Qb[ pE0GH	ѿ2Ƭ񃄗Sf	wS:}$AL.M4Ys%ȯH0[׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   T      fp                        c~l݁|TL3cOE1@HJCI'>zηן+H?.
Wynl,,>"D:2)y-zf܉t	=]]%>|QlR(ݖR!kV>
Ky!gx|8<ޱd'C5%LK&t3`(.lHwKCG@Y*\.Ɯ)Efed%*B<fw\lu	`#_i2l Z0)3%>{u?2aC×)R'Y:ʞ!Wˊ?ZȺ0*Нm$Wꯒ@j;S
 pƯ=eUix~;dڋ7 ؟vkndX̠\\Y_8g7tuȦYd(1Iք|+<Z-J+\e25[,57-閔 7xRC1i\L %
8/lLjۇ+sԄjP5,HdsKJs$֑{k(!-w?n=1 Vc	S/TORu.M7ԛ'
ܩm <k@9 G<9N퍥5)4i<u3(A\8 	nW !;aS>~<JVüC#3㛟0נn?Ê*:ES'G3ޚ`Wؾ#Qx9v=QMH][.3t;aN 脓7l,(a4Bb2 VuFW82
֞4?&,Sr A0-pjۼ;AOsN"m[to_ց=h%CKQW6ή+.
cV?H&+u>G(^*"mxuwĠoo)&@R+<{ug	Ҹ3NcRf^Hōփ~Hޤ" ts<MkfXc퇪ws9P'ܛoj3k8XN5w}4{01*߼Q\Y@^	A2/4^AO._c̡;ͨ:ߒZ.[W4C
`N XiK_denЄ9#CL8%|Us6 7[(AV
,0gDx&8<Q&_'W)9ȴ\Gc4>Ȩۀam!KN!M_X=2th(dn9O'|^J»l!"=1܅h=/D	C'^Q<@P|>@@V?;Y-b1ɾ
 \FhAX%46)unҮ/1h87C6ʅ|޾LEgŵk]LV64gz/!=)M?+sqZJSJ],)qȱ!>øYx%ok,-29td] 0
nxnZE+zb5mҫf7Q$-"S,(Y(W@Ϯm[L'TY9>JqUna7UgKeJo83T\cp, Wij(X
<euB2I(N-d,0ժ	_>^3졗pLs-ZBǻBѣljs5KJhxF9"ۚcJ!9[w+KXzݷ=6bΫz{܁׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEc
1FCvx=T-~߯ilΘsމ5:nK%aťxC=E$'=?oxlߒ.*?4z7	Iw8WDC{EpfX`*dU8&b/)<TA<E[zd)G5TKQ._Jq2PH SEcx=N,E|n:C'>@1y4VҸ/\b*IIm ʸh+);vKj=~do{>s,[7<[o!	q3$?ūkW$F޲7x]K2ώ|R]j>%ϖJйVXrxEC<ʆM:#CTUŉ9bw 4f>#){~qŖ62B6	%]7LRކ
@d|
}
Xi>'MJ	1ȫw)0,a@oaޒy	ǉ }eûH}_FrJ?)1^,0)oWEt+n#b#
Mf>t_OGzp3	T8fs2dNGdiP &ҍ82ɢjbˇ7ScnkA'vaOΏMi!"r/|׏#&2̴"ت/Powz0!3{[n8}I	b$BJh!fH"PNŗ${	ÊHG?--kqxå^bS,1e!H5fjdjāk1Gu'Jh>*:M<ۿga|hb-
K`8 D%Iɘ,ɯ[5>   6    #  ZU                        @-w`VM|RJ O9/byOWه#2KجPꆜU˝_2:HB["0#huM4˝'<Ÿ[_Ŷ[IA1|[dKF.Ɠ<jp>`3iFݟ
a+mQ fF;"	 Sҝ iu*A [`Z\]4 \]8
M̒_]+ۊod
U	g|J#	jMè|(B楌ͼ]CMz˂u3Z&daQs;[F,D~s;DZ6ݩl#Fw]@I=.ُ7	(9RżҷĜ qg(	P*1"8Yr-mfjt։:ZjͲ6xͨS!kJ`~
P+;|N 6_qRnq	>!ctydBggٖ\U6)
ۙ!	s9|ct{ 8_nm]vJgfBdᇙMÕ,ԯչ)Z!&"<iJ4B"dUfBSjDl'	ܚ= ;AJU"# P5J&W}zQB4JһN1'ĉ$\O4Ru<y
2Cƕ.}k82NBG?kTHJR#ϗi+2EEչba^!(ySns
lIЇ2̟&4؊EEwzg@DȻ3{xR2e$$Gxbp.IW=)0L5uatWx@ϻQ
@Rx@Pl&ݩd|];λ;i(cs?Z2놫mJ;})Ӹ_캸LC'~e0}ހ._'dߧ4s*C`O6҈T
UP;`j0Z)=#Xr2
OWH
ty"!RE%T#4m?̗57`|6	
zO`_P|mi!h9hZv᯸; &Dtwt,:%9>-VG%.Ro7[>[''<Bw<zi_>.$xD7{וs 8-慪 {U*\.hCc6+32ѹ	qL>ρ.ů,CpTÃ7iG׮q7Ժ_
φ6׭(>Ӌ:itӨÓwPz
(qMaHiEb拉]+E_f34=do:Fckb\A
?&XO,}'9lŹI؉Cpf﹈LSJ6l0N]+9k+d=>!S<o786Texa
C^wiږAvcov~Bq兦(RR*""J(b}ڬ4+>":Cf=,fݬ:NRK~";+50%`W~Q \(z=يE+
o	XuM驤Taфяjcw+wW)K&HD2>e7RՀ0yAf9w@,[2
V>-3p^3e
e\ˉR.Ռ-\n2iK"C;&|8hI$ZTK6Ҝĕe`=29H 30j;/:LoF8,.>~iue$Cft<~wԀR3$rN]a1oXҵD_ɤojяOu	d;S2`/|Swa	Fi6_4$Mp'B}3Tɉ5UL,0VJyvMΖ@GXT7UzF؋hKAWl.'!kkdt
m2\1h\)
<^V6D";m*]}ъpqz~n}*~[.	iwJ`<%O;m[m]SH<pצH/%ӐEL НHD"CPn o)4҆A#SWRK*H^0
x寑|i.4EDE޲0r-'_Q1c&h&Zw rDQL}xuv/KN@i(a6#ǢR/
-)ƵpnwcC{w҉ZOm_FQ?Ɇ
嚠93HmRf \'sAϊ;ХӋYzǞb0Bk+-!@^o7Mڞ۹O0`/~Y%ie7{wNM`Rgd'<ާ%pbR9qg+
	!L
j@ՋZ%raAR}rL,37Ydkj\"%"hX#-FQj =m
+v&Lq pْks]j}'l;	>q֚Mѹeޔ7"s',LI_{+N٣ÚIGӓ	Tvt+FHv(js ΆkV^`7?1GǻϗEIc5]	ǲ5oDM拆}
uҋQ7*cz`n?Ĝs{ou*!Pݕc~XT3a֒53n 1q#Dd7\](".m>PFn&UԜlJP/aCZc׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   H      }                        #=Byf[WsgqF oy|.'E6=3zToh@ǿyc'խBKSCT<ң]坆峮|	n+UnujrY$>ii[bcamuP35&Rʟt;)+E*%}0!`2Qn_RK~RoE@ɟuXV@|ɞRMߑkFƺ9uK@ay5q]{D 
+W;1Ucʹ8Hza4	L*♀6qTy}9ASƶƒO*BJH
݊c)<LƙCmR5lsErrmYڠW3ϑ/FH{yj&'4ɴl1ܿ3ڼg8BjNƒbȏVK
2M73@q=BC
ނsc2H7\>'So7ۢtv
uCapQ {qżs^jJ8ꧾ3#o1rf&ɱ2ȧ/QEʼq!
K,s<ɂ@eʱ۔Qd.}U
i( 
ٜ9frFˑTFm"򦉝z17ԇ%IJ}Тd'5JP˭$;?.Vσn/<%$Y-@.DUCRIMDwG	UR eE;Q(M^;|aRΘ8.^H4 tJc48w<$jk2M.g|5z߂JaAbS.˶G]ZzȜxH4q;!xND35p@Hnj;g4Ȭ0ϺYOeYɚ\i@d4
NV'H4W77s^:R	KaWyƀ]MC@E~b}>j?cԓTa5ovJ/G{?̡0&{er:_1ove3˃wh8 fˡO@Ζn6B&]Uy]hUV*ML缟JP<<DD蕋Z
=*)!Nh8&6FD# ml2p?OP=.66'Mp~*3k+:R%zF5\	f6=?x1VYvv~a}a,HQmRݜzNo.^A4Wd22:>qUK+PK?~$4WSTtD|"2D!/2n>p\5)mpTgrK<D}-i'"g/,wpr9{HW9М :t K*Tv$2lOwy{]% n"C9M(c *3CI6@c?/f*bK@
?[kM8t˓:w<%{"pA#J91FLMv')\xm;{aPPVnMA2ARl;4!ZɽX-K6%FV/;&͌yӃ%12u?hK͇Dn*"I0BeM7f	ߣ4Sm"o o=ేFȲ1w0{+*K;Wk6ƣ(IۀAl2Upa{E6,.\JiզBu%y
g38Ya5&R&md.y"gnM |x@w /J˦F0lҥo&z5iQ0&#N4^A6a;Qu%/RuWeG+WgVR+F`Z]s8x V[-T>H_
O};w]kwȒobm 2M\:p
x{xdCG:L_ ;KmojŘ:fd<.*e %@b1یyq骾Ǔ@W(C!ΪZDkb3LQ2 grG&^Z"E((XW*s5:MC[˪[G|5lױ/?`2V25V!F3*,$~M#r\,C3`W!.|VC2^J
><Xpnm܌x4#jftXzn6;A:cóݺcU 'tZnK#wp<3ȗINN؁syoSuQQS\GKxAClcb!?#{%WB:F-HlܐPGt} 8{)7F79y|c{I^You8WKނ97og, buJ&vza;p

t良/^e5N2f<ߤa'F=$բWp
]&uUސ99
\0I9<ѳNГn):}z

k<to]'A})L*~_x7BiVsQTW|z};3!lR[1[NKIKʐɰ]Sm2l[Hqp-jGɺ`d5IZjYUŸf#o ݸR`&6pжF-@K)	 "/`FTd	1a-9MǅZoxGQʍG!#P+|RJG1dUӋr֭EmE
TQlL	J0ۿdB۞PZsv]JF)׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H       fffsf fsf f
   fffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsffffsf fsf f
   ffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf f  tf3f)U  fsf 9r!f   tf   fLU  fsf f~fsf fsfff%   ff  g.02fU  fsf vrgfU  fsf  rRfU  fsf 8r=fU  fsf gr(fU  fsf rfU  fsf f fsff@Cg&;f(V  fsf f;V  fsf f   u
tsf fsffoV  fsf Rf@Cg&;fV  fsf zf   tt"ssŀ2ɀ@v8sfV  fsf  f@Cg&;f fsfs退@s,fW  fsf  f@Cg&;f fsfrBfQW  fsf pfdW  fsf  f   uf   t
f fsfr'@s+fW  fsf f@Cg&;f fsf$fAg&$;g&$;fBf u
g&'g&'g&f fsffffsf fsf f$Agf&;@gf&$;f3f tf@f   ufAg&fffffsf fsf f   gf&gf&   f~fsfBgf&f uff~fsf fsf猸N匋 f
   "猸N匋f   fY  fsf f   uf  g&t猸N匋f>Y  fsf 猸N匋fgY  fsf 猸N匋fY  fsf 猸N匋fY  fsf fY  fsf 猸N匋fY  fsf A	o猸N匋fZ  fsf o	F猸	N匋f@Z  fsf 	猸N匋fiZ  fsf U猸N匋fZ  fsf 猸N匋fZ  fsf *猸N匋fZ  fsf y猸N匋f
[  fsf P猸N匋f3f9[  fsf $猸N匋fb[  fsf f|[  fsf C
f: f	"f   f[  fsf f   uf  g&tfffsf fsf f   f   f \  fsf f~fsf\  fsf 
A猸N匋f4Lf  gf&f Lgf&fff,  g.fLg&g&'g&f\  fsf (1猸N匋f\  fsf 
猸N匋f\  fsf 	猸 N匋f\  fsf _i猸!N匋f]  fsf 猸"N匋f?]  fsf 猸#N匋fa]  fsf 猸$N匋f]  fsf u猸%N匋f]  fsf !猸&N匋f]  fsf "猸'N匋f]  fsf G猸(N匋f^  fsf  猸)N匋f-^  fsf &猸0N匋f   ufX^  fsf "猸1N匋fz^  fsf !猸2N匋f^  fsf &猸3N匋Ћ猸4N匋f^  fsf &猸5N匋f^  fsf 猸6N匋f_  fsf &猸7N匋f3_  fsf "'猸N匋 f%"f   t
fC1'1焋儺N匋f  f_  fsf tv$f  f_  fsf f  f_  fsf f  f_  fsf tf  f    ff   ff  fIuf  f(`  fsf 4f fsff   f  ff   fb`  fsf tff   f`  fsf Gf   tff̀   f Ag&u\f`  fsf %r8u=f`  fsf %u$f3f   u
ffuf  tf fsffLg&   f  tfOg& t'f   tfOg& tfOg& f  f{a  fsf $f  fa  fsf f  fa  fsf f  fa  fsf f  f    ff   ff  fIu fLg&  f fsff   fuff/b  fsf $t,fMb  fsf g$8uf   uffuf fsfff   ftfb  fsf $$tf@ff  uf fsfff   ftIfb  fsf #$<t,<t2fc  fsf #uf	ff	ff  uf fsfff   ft+
fVc  fsf ^#<t<tf
ff
ff  uf fsf8f   ftfc  fsf 
#t"ff  uf  tuf fsffffsf fsf ff @  f   fd  fsf h$t5<w&t<u ff @  ff    ff f:  f~fsfffsf fsf ff   f fd  fsf "2ff fff+ff4  g.fd  fsf !<  ff `  ffg.:w%g.Ffe  fsf !<  g.:Gv;fffcff `  f    f;thff `  ffff  "ffftfu	f   	f    fe  fsf 'f~fsf fsff3f@  ff `  f
fg.ff   2ff   f   ft6ff  fsf  < tff8fsftff  uffff fsff3f@  ff `  f
fg.ff   2ff   ft,ff  fsf  < t8sfwff  uff ff fsff3f@  ff `  f
fg.ff   2ff   ft,f3g  fsf < t8sfwff  uffff fsff   f    ft*fg  fsf $t<s
f   <tff  ufff fsff   ftfg  fsf uff  uf fsffffsf fsf f3f@  ff `  f
fg.ff   2ff   ft,$fwh  fsf =< t8sfw$ff  uf~fsffff fsffffsf fsf f3f@  ff `  f
fg.ff3f3f3f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t3f   t@ tfҌ  g.;sf3tff  T2fffff  f~fsff fsf3f   fu5f	ftfftf
fC  2ffg.<u f  t2kf  uff  uflj  fsf ,uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsffffsf fsf f   f    f   f%k  fsf f    f    3f   ftfYk  fsf fftfvk  fsf fftfk  fsf fftfk  fsf 8uf Bgf&'gf&f   4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   f~fsf fsffffsf fsf fLf   f3f3ftx2fsl  fsf At	ffffl  fsf <	rLаfl  fsf <
r1$,
	
2g&	ff  rf~fsff fsff   fm  fsf d稀uxf   f   f   tf    f   f    f   f   f  uf3f   uf   f   uf3 f   u|f   tf   f   f   tf   uVf   f   Hf   f   f  uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsffffsf fsf fLf3g&f   fu	ffffˌ  fg.f	ftf	f~fsf fsffffsf fsf fffsf fsf f3fLg&'sf   f   fo  fsf f%   f	ff Lgf&ffft
ft f Lgf&ff%ff  ff% `  f
ffff; ffgf&f L fffsf fsf f  fo  fsf $f  fo  fsf nf~fsfgf&fff   gf&f   gf&'jf~fsf~fsf fsffffsf fsf f Lgf&fff Lgf&fpfff  ftf  fthfp  fsf {f Lgf&fff{  tff  t+f Lgf&fpfffq  fsf f~fsf fsff|Cg&'g&fCg&'g&f`Cg&'g&flCg&' fCg&' fq  fsf fq  fsf fq  fsf 4f fsffBgf&f   fq  fsf < u	f   u}fr  fsf Zf@Cg&fCg&fBg&$g&_
ó{fAg&G$fAg&_
ócx 5f@Cg& 3fCg& 1fB$g&'g&g&gg&_ fA$g&gg&GfAg&gg&_f$Agf&@fAgf&@f$Agf&'fAgf&'fKgf&f fsffBg&'g& ff% `  f
fc  ffgf.gf.Vf Cf   gf&gf&Ggf&   gf&   ff fsff(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsff30t
0t}f  ffg.fDg&1f
  ffffg.fDg&g.FfDg&f3f{  0t	fffffffsf fsf ffDf   g.g&ff0   fDf   g.g&ff0   f  f~fsff Ef   gf.f@   ffffsf fsf f  ffffsf fsf f   gf.f~fsf~fsf0   ff@tf Efǀ   f{  f   gf.f Dgf&f%f
  gf&f Dgf&   f fsffff8Af   gf.ffAf   gf.f fsffffBf   gf.f fsff   fAg&' fAg&' ft#fffftf  ug&Pg&ff   tfAf  uf fsff@@gf&f0Bgf&f fsffffsf fsf f Agf&gf&'fAgf&gf&'f   tf Agf&   fhw  fsf 
f{w  fsf fw  fsf ff%   ffftfftfffff~fsfffsf fsf ff%   fffffff ffffffAgf&'gf&	fAgf&'gf&	f   ff% `  f= @  ufCfffAgf&'gf&	fAgf&'gf&	fAgf&'gf&  t fAgf&'gf&  t f3f Lg&$<ufff% `  f= @  ufff%   ffg.ڌ  fAgf&'g&	fAgf&'g&	f~fsfffsf fsf f3fff fff8ffff   fff  f
fff   fff `  f @  rf   fAgf&' gf&	fAgf&' gf&	ff% `  2f=    r\tfffsf fsf fLg&%f   ؃ ttKu
fuff~fsffAgf&'?gf&	fAgf&'?gf&	fAgf&'fAgf&'fAgf&f%   f
ff `  f
f  f tfw  ftf,  ff3 f+ff3ff%  ff `  ff  fgf.ffAgf&'   gf&	fAgf&'   gf&	f~fsf fsff$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsffffsf fsf fdAgf&   fAgf&   fLf3g&f   fp~  f~  fffsf fsf f fffˌ  fg.f   uf   t	f   ugf.zg&'gf.:g&'ff	ftf	gf.:g&'ff~fsfffsf fsf ffffό  fg.f	fu$f	gf.>g&ff~fsfffsf fsf if    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsffffsf fsf fff  f~fsfAff%  f   g&t3fAg&f   tf   f~  fsf LՋf   f+~  fsf V֨t	 v  v f   fZ~  fsf f~fsf fsf AAAAAAAAA	AAAfBgf&f%?f
 
  gf&fBgf&gf&gf&Pgf&fBf  ugf&   	gf&   f   ugf&   @	gf&   f  tf$Agf&   f   tfAgf&   f fsffBgf&@@  gf&   ff%f=  tfhAg&gfAg&gfK  ff%   fffhAgf.gf&'  gf&	fAgf&'  gf&	fgf.flAgf&'gf&	fAgf&'gf&	f fsffAg&' gf&0fAg&' g&0f$Agf&   fAgf&   fD@gf& f fsffBgf&'?gf&  fBg&@f Bgf&'gf&  ! f$Bgf&'gf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsff3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f    fŀ   uf   f   tf   fgf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f uf=   u fffsf fsf ff   ffAff~fs@f   tfffsf fsf f   t
 
 fgf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfgf&f~fsf Bgf&'gf&   f   f   tf 8  ffgf&f Bgf&'gf&   fgf&f}ifAf  fffgf.~gf.6g&? tg&g&&fAuf   t2f   uf8tf   tfff fsf AAAAAAAAf Bf   tgf&'gf&   fӄ  fsf 1f@@gf&'f0Bgf&'f8Bgf&'gf& f fsffAf   tg&f   tg&fAf   tg&f   tg&f fsff   uf   f   f Agf&'gf&	fAgf&'gf&	f fsff Bgf&   f fsff Dgf&'f fsffBgf&   fDgf&f Dgf&   f   f(  fsf Y<twf Bg&$uf Dgf&`f fsff  fn  fsf $f  f  fsf f fsf fŀ   u<f fsffffsf fsf  fff.0ffH $ttf~fsf fsf䐕 	
P`=P0E       I   &&&&&&&&""""""""333333333333333333333333DDDDDDDDDDDDDDDDDDDD        """""                                  DD D DDDDD D D DDDDD D DDD D DDDDD D D DDDDD D DDDDDDD D  DDDDDD D  D DDDDDDDD D  DDDDDD D  D DD3333 3333 3333 3333 3333DDDD DDDD DDDD DDDD DDDD    " " " " "                                                                		


 "$&(*-049		



!#&)-159?


!#%')(*,.02 !"#$%&'()+-/13579;=  	

	

 	
	



"%(+/258;>>>>>>		


"%(+/258;>>>>>>		


 "$&(*-049		



!#&)-159?                                                                                                    @                               "3D  , 0  @  P   P Q  P U  P      P    P       P    P       Pfffsf fsf f Lgf&ffff% `  f
f;|ff% `  ff% `  fff~fsf fsffffsf fsf 
f  f  fsf w3f   f   fsf $< t<tM<t! <sfNgf&f   t&f   fN  fsf 3$p2<u f   ft  fsf 
Ɗ< ufLg&'fNgf&f   uc   ff% `  f= @   f=    tf Lgf&f#f Lgf&ffufLg&'fu_f   f  fsf f
   fffsf fsf ff   fR  fsf Qf~fsf  ft  fsf %f  f  fsf Yó fNgf&f   t@&f   fď  fsf $p2<uf  f  fsf $
f  f  fsf Uf  f   fsf aĳ

f  f=  fsf Àf  fY  fsf Àf  fu  fsf f~fsf fsfnnfLg&nIF
. hῺ! jǐ {Ԑ f3n          D  @    L      @       H   H       `       T  
$   	L  R  	L  	L         	
    %   	  
   
   
   ā     Ё          (               $     (     	                    	       
H@,@      ā    Ё    (            $    (    4    8           @      
B  
B 
B0 T     T    T0 !   L     L    L0    D    P   X     `  D     X      P    D    X      P    h     `               	 J             
  @      I         	  	4@	04
    	' 
 
> 
H> 
> 
N> 4    	1 	 4	$	  	  	  	  	 
D1T 
B1e 
# 	P 	          @  4 $       	4		 		0   4      @ 	
. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L  	          0      4p                                                       d  ` h   X  '      @@       A   \   Z 	  X 	     ? \   Z 	  X 	     ? \   Z 	  X 	     ?                                        '     >       8       ,Bl      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  <f9Hf%f  $f$
tppqtwffupppppqffupppppqf  f  gffLggf^gfngnff   ffupppppq ؎gf
  fMf/Rfupppppqg-  fX)ffhff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = ufvf f af %  f<EfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰fӜf䎊ffff掺<ufff%>  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ怺N ^@'f3
f  i t
^
ppq<&uf  $f$
tpqq$q
p&q+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  $f$
а f  $f$
и f  $f$
аf  $f$
аf  $f$
и<f  ff| ff  @$f@$
= uQf  ff ff4g&`g&&g&f  H$fH$
и f  L$fL$
а08fffUN&N䄰`O'N䄰ON8tf  ff9 ff  ffL f N U
BJ<Zt. U
BJ<Z B0JBJU0
BJ<Z0BTJ1BJ2BJ3BJ4BJ5BJ7BJ B$JB$J&B J'B JB$JBJ(B J$BJLN33LN3N BJ<uj"BJ&BJ)BJBJ`BJaB8J0BJ)BJt8B B tf  ff    f8ffff  8ۙf  8對 f    < tgfSf  g&  u
gf&>uf[   68YVD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    焋猰怺N匋 s/1 f    QsY 焋猰怺N匋f  ff  f   tf ff  rfBY 焋猰怺N匋Yf3gCf3f   焋猰怺N匋[fHrHf f焋猰怺N匋儰f焋猰怺N匋rfFf   f   r% 焋猰怺N匋(s 撰焋猰怺N匋3.&f  f   f焋猰怺N匋fSj(f[f   f   3f   f  焋猰怺N匋g&7(fFfCg焋猰怺N匋o&fPfSfQf   fQf3یff  fYsfYf[fXSgu  ;u[fPfSfQfRfWf   f3یff  	 pfBf   f3g}    fg  r%fG;wg}  f_fZfYf[fX                                   	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  )C vZ[XPSR -Z[XPSR  )C v
 -Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
ɈD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft+vugf&>tgf&6f٢ɰ &f+~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR   *  *Z[XSR  :'C vZ[PSRRZZ[XÃ<t  *  g*  q*PRt)t<ZXfPfSQfRV%&  &f3۹ f   gfdT gfdTgfdTgfdTf   &"UC v )  8 c&qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f[fc f	cfgfff]X t fffc f	cfgf  ff[f_f^fZY[fXRfŋӃf3ӃZfPSQ  %fA vY[fXf` f;.t
f. b%  >%$C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  fK  g&"  @v@ g&  s fK  > u&g&.  ug&.  ug&/  uD
f^Z[XÃ t                          /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         焋猰怺N匋儽396焋猰怺N匋儽Sİf_"fifufðffk8ff f%"ffXBİffff İf
tfİf#^f f
   `"	f   f3f30f  0fW*fBxf   f f    0f  f f   0fffP  0f  f   f    0f  f f   0	 f%"ffMf.f.  f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.fx  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
              p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v0 f  G f  ɸfaPSQV`݋L	;t	 p ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6ɻjs>t fafWf   g&D= g&D= f_`r r8 a`f`  gF
$&
gF
&ɻsw>taf`f  gF
$&
gF
&ɻs@f  g&|5  t>tVfarfWr<f_    f`fߴf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>߹ gf&D5 gf&fff>fXYsufa`fp  &ɹ gF
$
gF
fp  sF>tma        PȎf   @w> ttus>     >rfg   ( r  Z>Qff@>7fffrfff> wf   >ff%fAfff> trf> wf   >F>,'q>hff   fJ>A0>'>
ff  > ff'f6r$fff> trf> wѰf     F >uug>u`R D>u=/>u(f 
-  >	r  H
s 撰t X/>X'Nh1FTifSgef[gefPfR>u
.fZfXfSfR$$8u4@fZf[P$4XfPfSfRf@
 > u= 4tfsfZf[fXË.uIsfZf[fXPR tċZXfSfRf@
 > uA :H@ts*؃,-@us.fZf[R쨜u	u
sZ           `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva3k f
   `"	f3f3f   0 f%"	@ ttu!  
 s3ig&+g&ô b uR Zts+R Z<u+R Z<u<uR  ZfSf. g;xxf[ú          Tf  ?   f  +   f     f)    f   fHt	f쨎tf<w' H$tt
ffPf fЀfXfPRf%  0fZfXfPg& g&gf&{gf&CXg&Cg&CXg&Cg&Cg&#sPR$ZXPR$ZXPRs$ZXPReZXgfgfgfgf&G^f]  f  gf{Tg&s g&C   PHR                       "                               @  
     @  
 Uf`ircgf&=  f  gf&f  fffFffFff^fF   f  f|  f^fF   faUf`f  / gf&Fp  gf&F    gf&F`  fgf&~f  gf.>f  fffFffFff~fF   f   fp  f~fF   fVf   f  fVf  0 f    gf&f^f   fǖ  f    <ff  0 f   gf&f^f   fǈ  f~fF"   fF   3f~gf ulfVfOLPHsf  . ff  ! f  ! f   fǖ  ff4 0  gf&f^f   fǈ  f~fF"   fF    f  g&]
  t
ucgf&  f% f   uLf   fǪ  f~fF   fF   g f   fǶ  f~fF   fF   A faú`U` B<u(``B`apB`0B`f` f"(  ؎Њf      f%" 3؎faUf`f   f"  ؎ff3Ҍffh f  fPg6D* gf6|*fg6l* f%" 3؎ffa          f`ffWgfǃ  #Eggfǃ  gfǃ  ܺgfǃ  vT2gfǃ  gf  gƃ   g  u	f@w4  f@f@f_gf   gffgffaf`fQgf;gdg&fGfXf7   f;wf+f@   f+f7g  f3ggf  fffgffgf&faf@   g  tf@gf3g  gf   f` gffgf@ ffgffgf3fgf3fgf3fgf@rfaf`gf  gf  f   gf3fSgf  gf  gf  wff#ff#ffyZ?'wf3f3fn,;wfPf#f#ffXf#ffܼf3f3fbf[gf  fgf   gf  fffPgf  gf  gf  gf  gf  fgf  gf  gf  fXgf  AP
gf  gf   gfgf&ffa  fPfSfQfR3f  @f  $f$
f  ܺ$f$
ЋfZfYf[fXfPfRfS3,f @9f  $f$
؃f  ܺ$f$
Ћf[fZfXfSfW3f3f  Bg&cg&C
uf_f[*P.>u.  t. .6XðR ǺZR úZR źZR ZR ĺZP\R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X               .V.^ð@ ð  fSfQfWf3f>t	f  se>tf  rf  sJg&C g&Cf  @<@tf  G .f   f  G 	f  W g&s g&C f_fYf[fSfQf3>t	f  sK>tf  rf  s0g&C g&Cf  @f  g@<tg&s g&C fYf[fSfQf3^>t	f  sk>tf  rf  sPff?g&Lg&D<?u9g&C g&Cg&Kf  @fg@?fg&s g&C fYf[ f  / f@  fPQgf0f  f    n YfXf    fPSfRff  ! gf&V2gf&;Ftg&~ u
u
gf&vfgf&NfZ[fXgf~gfNgfVgfåfPfSfQfW<w#f.U
tfsf_fYf[fX焋猰怺N匋fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fXfQfWfVf @  f   f  gff^f_fYfQfWfVf   f    f  gff^f_fY                           0 ] PS㋇􋇺[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $   g  \  Q[XR # 1 ZSQW   _Y[SQW   _Y[SQW   _Y[   PUN
NNOపNzXfPR3t3$UNN<Uu#NNO<u N҉ZfXfPQRU0
BJ<ZuW0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$w u-@u&UNN<Uu$NNO<u Nu3҉t;B B t	 ZYfXPRt ZX               焋猰怺N匋3ظ  м{X $ffjf]f}fff)                                           Q  YPSR+;wZ[Xf> tftf`f  
tf  f    f3f3f3f @ gfffCgftftfaf   {fuQYfVfSfQf  f   frffYf[f^          fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     2ø       @     %08/01/06YDV  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        