#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68YGU)  - Linux-Based"
BIOS_VERSION="F.07"
FILENAME="sp33591.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o44  )t4   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68YGU   BIN  \D44  VU4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  6   d             F  /    I  
     &  o  A  )    %  z
  T
  
      U    y          ?  .          q  i  G    5          s"  m"  !           &       &  %  $  c$  N$  $  5#  /#  !#   }
 }
 }
Z*  A*  !*  *  )  )  )   }
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}
C  rC  AC  ;C  B  I  I  H  F  F  1F  +F  F  V}
&}
}
}
}
}
}
x}
N}
0}
}
}
}
}
}
}
p}
R}
4}
 S  S  S  S  S   ya  &a  a  
a  `  d  d  e    	}
2}
,}
}
    u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3Ðjː
  F  F~ F F^9 uvfv)}fvfvu)~h	h jMRP%Vtj
fvvPB
h	h jN~RPVtj
fvvP
 Ð3f>^  tf6^ 覌f>  tf6 蓌j b	  V  h jh jh j鐃h  h 苒j>bh 蚐~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ?F^v&v&8 uNV  *=p t -d jHH|f6B jRPvkjzRP
jjRPjZRPꈃjJRPڈj:RPʈj	*RP躈j
RP誈j
RP蚈jRP芈j
RPzjqbT-r - @- (FF9F}-^v&&?-t^F&&?/uF ]=sjxtRPja]tjyURP凃ja>V   h	h hn  gvxvuj fh  ! hy
h@f6vfh   hy
h@f| f6vefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRPja]]fh  j Ԉ^ ` ^ ujzMRP݆j`s>R  tG  =]t( !  9  =  A  E  I jJj1fjZ   ujzRPcjZ`
t(b       ؎f&fjxRPj`>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uH>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRP3jT HHtH
>T  t7>N  t0f|A  h|h|j苁
> tjJRPڄ>J  t
j ^Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uwG4(~ tfj fj G0F   =HtkI-
 -!- - - 
tFfA> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Cd   F >J  t@Kt B= M- K- '-M- 0- )fjA>J  tzj \^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j襄}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPyfvFPfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;FvfvWFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPtWFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP豄
k3ÐSfv
 ÐT  Vfh  P FP߄f|K  Fhh|h|j䁃> t3^ÐFP^{BFVh	h FPJRPhzh	h fv.RPhd zfvhd Rz ^Ð  F@Fy
|"~FFhh|h|j:}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Uu*u%f6vfh  f6^ ^= uv&G
 tf6v\놐f6v\?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP	
fh   vfh`  j f6^ ~@v>  WV	~ľ" f~ th	h FPZx~qFPu3^_h	h hd [vxvtj ff-   fPf6vz
f6vjFPy
f6v|j ff-    fPf6vy
f6vjFP]y
f6vb|~ uo~|ij ff-  fPf6vy
uLf6vjFPy
f6v|F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vzYFPhf6v]Y ^_Ð~ fh  h	h hd Zvxvcfp    	prff9psTf6vfh  f6^ Y= Yv&G
 Lfh   f6pfh  `f6^ %*t"f6vXfh  `^^_Ðfh   vfh`  j f6^ }
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP~
<F> tjJj1j f6 ~jh	h(      RP6~
6 hy
h@     RP~
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|jt
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   h!NNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jz> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|jy> tjk\RPv  fh  ! hy
h@O|j3RPYF  @ +FHuF F^
&@VxR&*RhRj*YF 9F}j >~Ĉf<t<uh	h2 XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRP vjJ`RPu3ø VxR&RhRjYh4XtwupÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RP9LFVfFf  fP!L;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  f|

 hh|h|jv> u0>} u)6~fv5K6fFf   fPK^_ÐfF    fFffFȸ	~4 fffFfFfFfFf-   f;FvfvJFVِf~qhXku2f+fFfFf~svBPƋVFVRPfJِ^_   jF "hRj
GVj[RPGUFF*;s6Pj:RP&UF*P4uVxR&
R뫐VxR&
RhRj
Uj|RPurju,jCRPYrjDRPIr>J  tVhhd jRPTÐ  F=fh  Qhh?t"jMQRPqjNARPqj{/RPqfh  ujEF 
jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPSj F*P{u>X Xt	>X YvjKyRPh	h> _SjLcRPh	hD IS>J  /t~ h	h2  SF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPRj F*PlujzRPh	hH hhd j_RPKRj[ORPjZERPh	hN +RÐ  :l1fh hht"jMRPojNRP{oj{RPiofh  ujEF  jRPh	hH QF~  FF*;s>  u+ҊN*+= utԊF*PjURPAQjF*P%u>X Xt	>X YvjK#RPh	h> 	QjL
RPh	hD P>J  t~ F 8VxR&
RhRj
QF~sF F FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RRP>PjF*P"uj0RPh	hH  hhd j RPPj[RPjZRPh	hN OÐ  F >\ ut~ th	hV h	hb FP*ih	h FPLFVu3vPfh  f6^ xL= s^&G
 tF  fvLKO>\ u~ t	h	hn h	hz FPhh	h FPLFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPUCȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP0C  F /u3tF f6^ FPu1F~rh	h h	hV JFVtvPfh  f6^ ML= s^&G
 tF  fvI~ ujRPMh	hV j!RPMF*  F u3A.tt~ th	hV FPfj"h	hb FPfj#JRPFPfh	h FP JFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$RPL0F~  F ohRj
MF  hRj MFj$;F~VxR& R܊F*PjsRP_Lf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%RPL~ u~ tjjRPKF  F f6^ FP%/~uPh	h h	hV HFVu3vPfh  f6^ I= s^&G
 tF  fv`GFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP&Kf6^ FP{=uh	h2 Kh	h h	hn GFVtvPfh   f6^ >I= s^&G
 tF  fvFVxR&
R
hRj
KF hRj sKFj N*;~VxR& RՐVxR&
RhRj
'K~ uj5RP!Jh	hn j!RP	JF*  F u3At~ th	hn FPMcj"h	hz FP8cj#RPFP#ch	h FPzFFVtvPfh   f6^ uF= s^&G
 tF  fvIE~  j$YRPEI:EF phRj
JF  hRj JFj$T;F~VxR& R܊F*PjRPHf6^ FP
;FF~s#~ t~ uVwR&
Rt~ tFPFPj%RP}H~ u~ tjjqRP]HF  F f6^ FP:u3À~uLh	h h	hn EFVtvPfh   f6^ nF= s^&G
 tF  fvCFÐUf6^ FP:ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S[c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPlbFPNQVRh	h fvbvvvh	h FP3bFPFPm]ÐUvދRP]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfv\FN^v&8 t&@ ^fj <fh  vfh   !j݃RPf6B \*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0%݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0ۃFVRPZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjكFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
X
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7؃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w׃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0уRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &pуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0΃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFPY"ÐFP>\ u*!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhDAht<thDAhِ != t= ut uу>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShBhR*F*PʃuFL| j hBhR jvʃ]FUtKjXʃhy
hd j hjlfj hG=thBhREtÐhy
hhy
h~&Ð&ÐU~ u hy
hjhHhy
hjh7F  F~ ujFÐF Df>   F{ j hChfh  >˃uF  F+uF~  ~1 F  F*@N*1 j hChFff   ffffN*+;|;s9 u(jSffYffffN*+ = utj F*Pyʃr>X Xt	>X Y6fj hF~.F 1 j hChF HFff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ 'ڃF*@N*1 j hChE>  u+ff   ffffN*+ = uFj F*P[Ƀ2~ fj hF
  fh  Ƀhy
hd fh  ȃt"hy
hhy
h幃t"fj hEfj hn
=uhhCht!hChtTfj hU~ u hy
hjhhy
hjhF  F~ ujFÐF Df>   F{ j hFhfh ȃuF  FuF~  ~s1 F  Fff   ffffN*+;|;sF*@N*1 ShFh0>  u)ff   ffffN*+ = utjF*PHǃq>X Xt	>X Y5fj hfF~.F 1 F 5Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ ׃F*@N*1 j hFh)jF*Pqƃh~ fj hF#  fh -ƃhy
hd fh ƃt"hy
hhy
ht"fj hEfj hn#=uhFht!hFhtjfj hÃ>J  tj htt t   1 ~ ujރFÐF Dj ԃud j hIh$tF F~s3c F*1 j hIh$FPuFA j hIh$he>\ utTtMztFj t:hFhIfj hn=thIh$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j hJhBFPuF<A j hJhBh또>\ ut>t7j hj }fj h=thJhBtÐ  Z1 ~ uj܃FÐj҃uÐF DTd j hKh`tF F~s3Tj F*1 Zj hKh`FPuFZA j hKh`hc>\ utTtMtFjt:hFh	gfj hn=thKh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPtFPhy
hՃ~ th	hDh	hPFP3h	h FPUFVu3vPfh0  FPLfv4FPhy
hqո U<ՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H4hLӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhT  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAhуfh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhJуm$PÐUj
0ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
~ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h=σÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hW̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̃fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth 
Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPTtFPhy
hgȃ~ th	h\h	hhFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhy
hǸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..qcf^gef[UfS..qcf^gef[UfS..qcf^gfeff[UPfS..qcf^Fgef[XUPfS..qcf^Fgef[XUfPfS..qcf^fFgfef[fX                           UfPS^tf3ffqc  f.c.c "  u  $" u [fX 0!<s3P˿y
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666QP.eظ eP.eۚj  y>	uXP 
 Py
 5! %d!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.|Vuxyyy{|w{{{{yx
x{{ru{x{{w{{zuRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }}}}~"~K~}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.2}V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33By
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3y
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![#%!uslkʻ 

FV]U- .8tK
I	]PPR.e؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUy
ء
F
F]XSQRy
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.eۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uTtT^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              y
              4.69  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This is an older version of BIOS which is not compatible with your system configuration BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) E  + , B  . / H  \ ] I a b VJ e f 8K h i 8L '  y
 `  y
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d					$		^														

	&
	F
	Z
	n
	~
	
	
	
	
	
	(		>	Z	|	.			n			6	T	n							(
	V
	
	
	
	
		$	4	                                  E    F    B l by
      C    D    B l y
      G    H    B l y
      K    L    B l y
      M    N    B l y
      Q    R l y
      P    O n y
      I    J    R l (y
      -     1    + o Fy
      V     S n dy
      *    1    ( o |y
      T    U     W   
X   
S m y
      Z    [    Y l y
      0     1    . o y
      _    ^ m  y
      c     1    a o y
      g     1    e o 6y
      j     1    h o Ty
      q    r    s    t     u     p l ry
               e                           _C_FILE_INFO=                                                         y
               
	
\ \                                  [y
  [y
                                                                                                                                                                                                                                                                                                                                                                                                                                             *y
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          fffffff               (((((                  H                                                                                                                                        "                                                     ddd                  rny
y
y
y
y
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                               p   `      POST  f   f.V .X <  
 f.d ` j  I     '       "    POST ^  f  : h\ < u	 U
 S ] 
 ] L_  v 0: 0 u    & m ] v \ u U FX 4W  ! " # b$ % /& \' /( ) V* 	c+ (, - . }c/ 0 u1 2 23 K:4 5 b6 p7 nn8 9  : :; V< = > ? a@ A +B ƤC 1D E :F :G H \I uJ pK CL M 9N ^O ZP XQ R aS T U 
V ObW *X Y Z >[ u\ 	]@^ &_ ` MVa :b 9uc Id ue Ӣf 9g f3" f" @ ؠ   ؎  f{  3  3    ] QVW.D? PRNZX+ hX@ .X=X@u
_^rYPSظ ht [X <t
B	PW |f&E1_X  UfVfWfQh'rOS  rDL h0f @f  f   gf  P^  5LfYf_f^]UQWfV6  
fvh.~uF F 73h3f^_YH	h r rD(gf 
  #w3fRS B&< t2z?fvԹ tNh:sHtDs ʆ h/ 3hkBFv ~&#3ώ
Pf~f  ff   @
>tq  tgfNg A	~tfF  ΁ 3
[fZ3yhH|F t~y2hX#Ff3~Zh1+FfVFf;_Fu-043  
 VWRQS:5=P-Ƈ0[YZ_< d0fPfS ?fGenu fntel ineIuf0  p%=  rifa2f5uYA7؀Uuf@0/0P O  t
 p0[f<- PI   0! <" #@ W AW @ W g  g !g g 0w  w w Aw @    A 0ߗ      E  Pg gggDw ww N  B 3P  
g  =S@ c W &0+@, '0!'<"'#'x !u  y PQRa&e-$`Ȱി hMVZYXSQWa$a$a  h¨X 7h!Y>5_Y[2揺 TCA6  @A Q C@@ @;uYð!$|p h)Ff`  Xfa.8
h!ph< ö@2W`/`@g&?gf&_^X`ofX61P(q?0hf2$h*S](X/t%1h#f6=~hVcgh,\\  &  -uLغf5  @tÀt=f֜Mh+
}
thdmfTDSDhz; G" wd}uu {a3%d0vS$
  % Y}dWeq@9
$ a,#h<*Huɀ0 0k@@hi$su hbE,Ⱥ: @p 3ȰS3 @uSE`hj 7Súvÿ0@Pphs}  4  p*' t* +
&,@ҹ--;a"m.  RE2 f4%  0r.b  
h4¯`M	6aP.˖X`Q`7 @ PQ= `t
3P @fYX _PJðd+`@d  RPLku  
   &wlEt&؁M uM9NwN%uӃ~ uЋF= wt%   +ȳ`PXh"3K`.8
  	 `J a `hs 't*`'u XLu NtPRf0pRP~f.Dp DE ~0Tf` f !P>Q0ф?2!@XG@Fa`  nUSQR _Z}Khb\f`Tr003hffrs ?Um
@<9Zfa't5<t1^f裝"B<[ \ ]_^W   C<` a b c def.RVWc3@$[!D!
` yFft]RƠTRM^c_^ZYRL"Rp Zt  ZRu  ZZ/   > A A Ð T k M e M@@ @9 Y . @  n SdA  A }t (
Bq  +L/{! M0Ptq62 P fP6f_6L1  3p0 6@>x  .hncPS $<t4r 䳎 ! Ѝߋh3 R f`7 V  %3PhxP"hu8ãþ0~e &D 3 PB?hrgR׿d?&DeX"pr]FC?2"?z O>r>? @>r% $@>&5&D&ENϔ?A	VW `ha#
 pB@EyS@
fgrj@rVw@~_^ ؐ8!3~3@?Z@A`o ~A@&@ U$=u&@f= =u 
&@&@&@6
, fgh  0 pqr  <ABCDE I@xyz{|}   PeV SC
f$i r&A&Av r
& {  x"
> @A5gCff5fvv&0V3
Ê^ ..0t+.FuN.Pp'?GX& WfVUSW! 3fv߿ hC  Q$~22ك!IN3T
^
u
t_NA&>>_[]f^_"GEMU
) "5!E ` PNvEP S\PV&=;u&&0u&פ^SH&<#I+&~&p>E&D
lSV h]^[þ   WfPݜ hqsȁ  <fX_vqF9=Boot Device Menu  Loading A/r.P.Pt=  `  S? Np_ 3u.P$<ܠt) \y?p Z!0r𭰮P{ qQf1N &P	4Zò G菧t
.> ?t.F10=ROM Based Setup EnterPpQpQCV2kusM 
a@a2rtu*164sW  Q%ءRpqMp? _qPt
(*;t hDPXhF12=Networkr2((Wake On LANAttoempt'to(%  Qh!Rt8 *r	 A'u1+ 1+KA	~_ t,sMsU. T.W.- !.ix31`2-1- 7_"ss8.	BIؾ<^)~P#s͊b8CS֠VRySЎNF 3؁?	uCFG?~N0{tGh=rav1hZ^òP*:Notebook Hard Drive O`#cal Disk Dock1Mb= Multibay (top)bottom)leftf	Floppy)USBCD-!G 1
B Superu6ControllerNI'C 123                        ~ P  	
,P J h 
@m0prlec9tゔ  ͹U8 and _mo@=the highl@ tp`your cho .  Press3x1bose.Seconds until au;a A defa> start: ($ $, 'S ;S a;Zip d}D`&ZryV , h2 wv.U 
00.S eRz   k  3؊' tA<v<st1& 2ؒ2ƾQ#YAr
  y` hB.
* @+jjj(PjC  W p`X }  \ z>V  u k w~ M 2.  t032Ɋ <F8tFn $ bPdáq~0 URVQ.,.L.T^Y^Z]S,.*[ݡQSVW7 s.t$Qu .<.-00?@.@хY_^[YDQtX u h = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu z`;2҂ XʱP0
XXr
;w2 =`JQ1gFYô.*<%20~fˀhڑ h΁h!7 h#иd hⲦ<u	f  ` f0h@B J  Wo rf.>m$46fgf&G, @ f   PG0f{@G,0Ru
hG,f",f_ffP fQpt#QWK2_Yf= TKStfXbco    ? o N     @  y] r "R@  ~ h/45wg&Fg&Fg&F"tug&F0va 1 2P޾1%׎~A@rL.4%p Sq a oQ}1ޡ% @	C_' 
}VW3pL _^QRV4%DT	  r&e^ZY=%ffL ]LLPp r
YSQ%݈|\DLQH Yr)&}at&E%T+ r
W3`$v%c 󤿍%UPfSVU_fQW ( K&C' @C$BC$華 rx  q#ȑ# r]" tsrg r7݀ K: k;WQT rQ G1"C""Y_r
E@t:]^f[XQ$C"uV6e73u!#,ʌABM pf.p(PS [XAu.6t(fP'p(IDNU.t(SfV0P`/^31Ýf^[
3u
u ru!q!} "6W3 hqO; Q70h#T3-5cf_p`u= v[ OA[ aP߰ hH|r$@<@X JPFSQRWh]"r__ZMP TC r99 r/ u t t.@XR1$tut0ZSWQR fu
ʀgZY_
_*uu}  Ygу< @3ɹ2 uhT{#b)¼ P% = @uX%"4g&@0RIaX;Wi	t<f_;H1_0q { "R  	Pli`b    o
 A
 ortf &A&A@ p p 3f$BXst$ uf*BBp sC>A tuc ~rh^
&A f3C<thagM}A  Gp2?}4 Q < t&AGVBf?&!B/B
@4IB3f30 2ɴ*f&A uf
ffKЉvB&nB&~BfC0BB+eBpkBflfpRf tfP3ffCf[fKfSfF0rЁ0а K I+r@_f^fZЍrVWϾ ߀u@3_^ Վ	!BKV 
R3
t<^f~
w/v0.f@kd`Pfft@`[0VQWfv h.G-F&7CF&9p &; &=P&?&A0&C&{E&G_&IC ^Uaf   rGt >`*:wu
P0Vh[X`aƱ؀òadf]PPRZGQ  ahҝjjj%jG Pߴ	cPv [hd
w߸  h8hEú  g hHshp_4 hbj h (` t 	2se f1 ffff>{1fhV	 Tg&; 	 f)f)fqg&t` b   tHtx3srnfǂB 0E	ްc~/uP~/t a	pW;1tM¡ 6]                                                              7Tff.v1z1Wu u[rWJrR-rMz1tf0fqP| @Wb t#r"t p ; }PJR  ZwR pf]LCqfUr*6@^  RNZ0rG	0KuҰo!!Vg&fFfFf^@бe rC\Aݹ@3ۿYyP8E tްEG SBWA~i3m r`3>1pA@ҍm8lql0h` 0c ݰW rt r
 GC_RZt$ؤÚb$]W 躿 _W spO  a #`P
߰@S P  	ð D v Sذ8 e R	$#
R'
ߊ//(QWjuptPX_Yù
 d hWCsxusz
ՏP <.<u.uĀ ~!RR]1R22< uZ#ȴ$ t	5J k 
	:bVf v@0+Ј1^h1eàhӫhw>$4/h =쓣WKhuպv û r jPQW 0> 3_YX;hr=I s@%hSs	A~ G   ! $!f``ST`Vf@u'Ftf@ h@a60vP!;F XH[`ؾL &>&DEJP&D >u d]Ζ j@ t}
 +Ȁ}	 > ?33S [tS[a> 2[sd3 thFhW s
JhOwaàh RD
ϰ<QDuL
p
E$<u D
@11sd
rSi&pS]@` uL
 6 6 u  (X6є &
uh
	\

u   	D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"& xu	o\	PS   ? @4P'>_3& ?! W>	_[XB
t+# P xt  t  w\DPV!$!"桾t+߇h*rs
hF
1Ƿ &.@ &  ~`"hLC#r!L	vTt
v߲C	`WU&@t! $<vJ_`
SQ3  v
p''
u$< t"<u P>ȷXlPRtlЊ bЃ\аTй:~В7thݧT^' *#ă.@XBPІ=q4]ZXPz` 22I&Gt5=tOu:0: u	Et!sE=`: u5 2bs
t=!^& q es  a
׃/{ a3eLDs{&=  V߹ ?u ? ^]  3f8G0@f_  }0 U!    -&egWʃO&MuO OqfGtM!t$Ot, t"OGr Ǿ`NM0oOg&Dį/` 8(5'
!<t2>Er54_k,_P*`THtX@LDhJ =_7_D D	 d
z=1>bctSvrG&}	r??23ɰ6t`h*a&EY$f	&Mo&]aN`.'`a%# rZ [cϠRn0၍ZW&= uqF=
NY
hNMNw8h. RhX+7mZQ̰k_Wfat}
q t˾VP
 t   U!w#w !#`0|wv
h͒3 C.-.MZN0CtI! //(rC.58vSe+`T[uA gr@ О\B   ڋh¨Kh!saW$߀
D h3
hYТ@[X_Ë
`PS@&[X Sϲ
A HWU<vLR
Z,<u(Rff+f ,ZJvG! !
u
Ȼ 0wSÞH
sA  Uу[¡n$pu 0G@a  f3Ґfw< p@`֎Ph.F3۹ F
ۿt8:u4}u%BDqD	& h!rm &	 ϰhS3GaB3  Jѹ   aSYu0  Y [\ rY3ȃN rKf?Lq `4<t0s]5&' t&1- ع'
'+Q@JrMPRÉǆZЉtpt! g Orhh0		 & YQ7PI?C`ߟ[r%u߀ % = 0Y!j\W[s`U3+6 
HH؋E&AE 1, @r g gh$хxf@txWV @@'$P<PtRZR1pSƁ K wOC;_3ZX ?Z^1iWV 0 ߳ Ph/X@ 0X2+
*2]ƀƐ,?!C@?r?@Dtϊ5Q0 1u,u1 
@a

+&C323&@t  %
t&
0  W5  " Z  ( ~;
uz: >d!	"	? A%o ^Q|PRWD&A &]&U ˀA] _ZX"3һ -wf2C."/#N7 3#U_ '߸^ [^    9dp>u  'SX \ P`cLZfCa~[f3fSu 3 Q>a\:uBE&8Uu8p]
R +B&U
ZK!ؾcLZa6fYBP)7%qr h֓  {G;!	't/u=
 춳4Ãhr"ݡ@-
<t`ZAێûPV#
E^f  XaED
BB H1   hP=RLRUf`3؎ FwN.p ڎfafSfQf.Nf fff#fYf[2VftGf߾   NIgf;t&fU 	F`$f^`2ۢۈfaf}`c@FfaPP3_X.>N> , . ~P	TACO F  
!	& .N0s<F	N fFf.N  NF.Nf.>N;E.N  tNttYpNtNp  D@SIVfB. f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p N%f@c .ffHpfXfadf33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RRENo4^q4'r44$.x71p6ɐp08333Ҹ  QW>^% |F
3}@u'JE.ȩ t0 t  110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^( u{Q`  &t Y&  
 < tr&\]p &\U&{T 
U `&G|Nd 
S &	F& $F^[_µF Fx@Zp 0UW(rPVW ϋذP6' S! _^Y[XWfQS vQ[ fbt
  [fY_` t =$P nPu2MرtaPfh}	#fZ6أ#s } t@( ` j &&E`?SRUPQj@6^]Z`V` kTPǌD^Xp~ 
*F
O  t#cR0`nF ^F[s d3wd0hKu`<Uuùd {`fh4d & Xtû HE«& hb PhmE'`X!$!"   °sA 
eh   t7t 4  hտs` tKu& &  S
 0` h,s@<t<u[uв 
0_u?1*`P	hDn XhԄ % Pk 'PjD[%ys)aPRNZX'÷*%#!1*1p)t_QX`$}  .`G  C`3 jDqp8\ À   ; Z x     0N@`^~$bhTl1fF3.X& r 
_0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KہY.~r@V» ␅û< f ff @fUPxf!N 
 ffFf?3fvZfFsfBf〹fЬ1 r?9pf3ɰǿOzfAP  faþfPVa3v޸rF3 X

S,0<	v	,$Z.[W D`
o
Lb f s  f 
TO
T p s 	 
Sf_f@s Ўfvﭿ.ZP,} P袹:F s
uf^fNfV_f^pPRp*fV|A6OF@20hC@ Ҿ
 ff  fffffXܽq p  `90W\ P9󤾪]" v / aV+P*hP, P)9u&ն^t$ hjh>fPRh=bn2R ĺMP  _(Q * 4ff:aD0  %=f3X2St 2MMShc   hɀh#_b\wZ?pq$ q!H̰Āu!A t0NCðvstut
t<1w(<vP|Eoh3_0;P&
0
3q 33Ҋ|tW/g.&;u;@.ont)@)hPbtν	؀߾a`2G@t03@ @u  c,[
u93Q2,;8.Np

P.j6rX߀? 7Qr 3X@Y8SQ@2P5 && &0h~C hL÷uɰ h}
t[ Ȱ t
ŀv#t̰,5-PX~v8v&>궸 㟸`t`_RP3Ju $h<H  
#V( G  .>a  2_2h|ur߸um&ua 
wUa2 Q  hcôu= Ct= DQ tY0)艵RY.a^Ga1޶P$WSQR4 @3@&}u -:$ [#u_WE`ZY[_
U ° Pf/^ ]rr	 
) OLPH      6-cPfmr;V(6 
u^V- ^"(P*^  2{SP( 22< `2X[úB  $P?R  Zp?              sfp0Zt /c& X   fgff+f@fABfLrkr.r^gf+Ff ^0r8er 8cf\ rKC c7hHCab
fa< c PR 30 ZR" `&FpKJuhPp*Xh r.>c.cpu 	AѧQRfW.c0h f3f%  ff_ѫXURQSWF^
gF=Fg^ W^0F ^fPgfv
f;v F;F
 g< uYa  < g22 IF t Ռu뽸% 8t
` ppPj Ѓ;}
+V 
N JZ=u<N00?_[YZ]`P "&X&`PQp^ kPYPUkPk`W?]]]/D              'Dff6f.gu;v` Qx0 >chh *Ych"SwNQ f&߃ 'CCwKg  r)`Ÿ  ch{=Y>SLP3rz?[M26$&%<GPPp	 @u꾱R  β <BMtf3袰P2`@c  !XRUrxUVWfU؎fO  f]f_~efpgfft&fVf( 7 f^3tHtHtuf@@`XvÀgF
fp f+3fGenuuufineIulfnteluc32= w7= wf+tHB,x<w<
r	gf0fP.8mt%t0w<wė"mf^f^3R_=u  @P	sfˀrڋ@<v rsKsrUt f 'u f%A'u븑'Y=uUfQ g*t`ftp  ffGg:tErIgfY]Y]`b`lf!;gtxg Q4 I 7f8"gYs g롑fH0\I!"ffú f@tfHptsuf( 0    rmkMkk` ! kklQ l)l~llÀ:ְ::Y1&u (yP=<}t	<@tMt# ufff uf́@p tU $3f=@  rf,2us
ws ] ff17 յp}PW_еr RWO  3OC`xx`n  .BB <t BB2J &ݾhn   8u!@塯`23Ұ
Shgt0`́ y aut0i at]U U[aSR  4hH߻
 hbcZ[#` 1p  hsCS	 hVQ
 "BീPaԀa$8uXRP<uTZQrtwv Yu6ѹ }RPwZthU˟2<U   f@uvt hnrך u
3Ҹ EF)v ud^st 3 =X$f.p URbUfVf!/#: rswNeW3f. fdd[]aef.>pff@Qfgfw0uUYKU q\ u, P3	fwpptCptIftfgf.#f9uppfY7du0  O  / ;W-hD [r/ F]t p5PQ ߰hX+ ٸ 7h)" {.  NV3%1@10t3;} hΓ ;{
V^BB"/fTi &g 9  f% '"Os #VFfFA^faQ^V p @Y  ?
^_ܺ3Z<    DTDw R Pro 0 ȳhz  17   b l ( Pb @0 W HL P`A T W Xb, `
`! p@pPrx o A0
|\D`QWhM3 3_`͡ 0 PQ= `tqѺ @YX pSPo
& p  ff&Ϝ X[l`a"&    ir  uez  J5}O fQQnE S.2[@.r4/0  <t.@l~٠ tq.辠ri."D.|u.:DtSI  wD:r5+zs&v
uAm
cC1%PQC=3^So
f -XÑ2
O`2	  "	f\Г@0fư%  3f3fPaXJ Ah  l0ʫv 
 fb #&7f fa xdD 	hlW"ϻ (;sQSfrf.
 
2@̃i	40qм
 Q[ffY+vf[Wf+_f t%ȡH+f@``h0Qڱ- f@rf`0z q_L2_&#y uZ=PrUf%@ uCf* wf=`  t0  t( f{ްf
1"0"fph7>%/$8_!"
 \\Ecf׉FQ &Ffg&{ txs  @z{f;~t	uɰ&~q|N|V&tzzVfPXfXT`r<wؠ.z3T5f&ˀtg&fVlA8&fТ &fnu=жtsaNu(g{&@f#"Ȁ@)^f^u'2u  w & pP0XRhX+ZXt5vmBt
wt@Y % r1 h}R>uq7hµsT-3&>por&qrRzsRPuthuu	r` 	߹ CZjjw b6uЂS`` FF phR ru
@ lf& ﺁ ؀>t !$!f$< urC u 
N<2<ăƁ	"3uAG`[u TYP=t 
u2Ɋ،3`t<u
E< tE$<u&w $tRVL  N L Nh*ǻ`PC3u û t W PH [u
j ?j"GaE(!!2(<!a$ hs7u$0ctu$߇~Q.#K-.t4&^  Jr&w 3.\  ".\B.d b    W	x .|h¨_DuQ&~% t PkRXӹ
 ~.:t
 ._
vXP%8Xr6%ȸf!CL3;5N    PJNL p      QKOMp @Kt  Jt P(.DG H hõ2h  hR h  hA~E AE^  ` f  Dpw R^mZ oG 
v %&1O t&<
͛&=r&0dp$qRݎ t1vVKKuB!
O@!Ec(q } " sR$	UfнP&` 	3a C n	H =r{r`2ilhxvIqv ]QaVRQSh~^4ThL!5J.qbD6越8u,2
t&6붊<r@t2 sl ޝ[YZ^Sÿ Ph WX<?tFhagTwjjjj PC &h[\ h[$vbwt = ;t= Dt
h~r[ɗWVS%a%
][@ p= u"*׿OطhǾsOtd--B,J&=Ot1vAf rh ^P#֧  0dЅL P5W ?  :J2?=q%A 	
   }0XF`jeǋVW 2_2µ}t~2 
u
2e o
 `r22&&&EA &e?
td&߈E?&&E E &E<r&}	r@w VW^2`^2*à
&}vxhr~SPRQ3&o 
}%*t,-YZR0 Zh?tuS	Wr0r Ї> UsQ  6dtXYl-7: t$
*h"&&  t8ot' u ,Fo006$ `$ B[& && U<@[@ `dde`P`  XCĪU @p?
ڹ P .p0B B把䇿8uG` A ; 5䋀/)@#BS 냱76vȜPR怺NZX _@A@ B ]C    Ü
& 䕰t&𻰂&Ȱ'<;weċ X؊<wM3ɆQ#"XR<  YыƊȊ3ЇѹE [8 EJ
6u@uŲ<uz`0FnV	W2
8FhtgP׀k )X@. ."/  ҉&k !< uf& bÊ$
2 7Cu%ϊ1uhj$߻3Pf  f#f#f#f#f#f#f#QLfPfSfQfRVWrh^Lf^Leff
fnhE0nf3f3ɹ f nf0n f+fn ! K^u*^آ^x3ہxsV4C\`;! a^ _^fZfYf[}fX3hI# 5U{`2L> 揀Ms< |&	3ytwpu4QU5s @֗-t
"ARbKBC Kernel: xx.xx
 ` $ pK    t?  .]3۸ 2ҹ5*@HaaÍ6hVWaS@{_^ֈe` hjK>(%3=h7 uP$<X3(sf @  t<   4  r	.$<u
6 f3hh. 
d]p j`JheF=  tdbw_?s.>Npfo ;t@h/JDC	
q!U2 u@? l > ]c p3Fd@ e f Fc~ce`@4~e uQ@@9 hD^U
P	?hBFe:Ffu1r,
 hW
 Fd;   	:  <g ht[uPhcaf`THghWҏu;E#f% PCAXt#_ Nu	N r hf;   F^۰P XS  y ,  o   h[t(t@t,i i,>" ' À othYtZdúߋw."**ED/.\E$q+ËؼF/VU2NfQa dYF :uE]Àg33tVtst
}t
t
u
2րt#u
tN 3t"FFQ0u3! :5tFFdz /ulm":``F: uYeb +Πu<6F1 ep0Fff`Gup  j(j	R	5aU?Rgh)sA2  ˺ w`1 h87Z]ÃpRfB?Q3r@"  to3hRQ Q;YsY2$
 !u$`e|Zf` / ðXXfI.&_f  9`Dh.
 PC ƀu0u.> 12fa
[FRtUqVHhyk:Zn @Zp to(tq 	.S u|#[oi"g Tsq@u4VfRfA`h,Ls3< ^f[^8"o \c[YhYr vs p١6r!UR 2R s rZQ'VqpX  `.uNҝ$<u7ߺ p裮r& .S t t@v t`t a%u 9ި`
`
`
`P` ¨YSwQ u,S[r&
	!.Y[C<ff<`00xx00`19{||	>>.@ r
 ~ (mr]'p &G =`!<!7=' &$ ʽspsC  E rB uzuN D 蓮/u00\f}A ;q5F -7p@V aUfV3vCDPDQD 7@~tf^]|&໰PkP%OЂ zwPduXdGd8`@ ___ /./././.$.a/ "  @f%pԘ 4ō$r I FAC)S 
DBGP4BHP=  30A2 A|!  8  APIChOL	i G			

 		
  }` MCFG<	?TCPA2
PO A	 = U   @( e '
 2'A* N    % E E ("A)EI*RSDT(  +(I(X,f`Ȏ؎h(}TV h0ԟ1f V fԛf.f\.gf^$f  "gfǆ`f3..vԛN~$f.> `fW$F@F f7h3Vd/#
3ffgf&ߥf.>@ıP~@$f.&F  FPTRU R
wg&FfI!NcBpQf@[1(.
,.t~2Pm6	~(_Nb	́Qǆِ&  P 2fffcff+f+. umf62qi	(2	fYq@ԁG>E@o4`P0Xff- ñqV3g&fFg核Y[sff=TDSDt; St3Pt+SBSt#f=CIPAtf=PGBDtf=GFCMtf?=APCTt0t~Qr$< u2{zRfQf̓2 tdpump޹rUr*_v!';0 }E<Qtg&P
rX*fYf8ʰȥfWfV5?f& f~ >v@/t~p(@86f6fP)婊Ȁ$ 4 
Ȱ F
ff	hӊp@;fhirthpR;u3ɚ tQ fPW %fXS_ lDZfPU-@p*vue*Xg$$n e :l@g& h N3hE3X71f0._]V   04 Q*Ӿ 	BOS ]fmtD` b# Py  (ebfK`eD*%0RW D hrʀ hR_Z1tPSS PwSux0PfP3l f&L f{S[,L fX`h:o" 03f`&?    6u    WOG@fm3{ pZݶ   U!   D>-&geE E pu{MPM^GfEtXAt$Ot3 t)O$fM
rρþQpmMe&DappU  r.p]h4r.Zch {   cÀ) cڄW |±f
^PhzD0fx&ttӿ( t (뭿 Ƶ)Pu+io_VΎƚ`L ^&Sf`FF  oh(D uP hU@  $g(U,0w4'8  !389FtFfN:F> h;ɀuh(fa`DؿE13ɊMh:t?

hE9U;r%uacUWF _^Df`GNPhNBf.9u tc rfQPH_Drf;^uf;Nt;f[t)   
tF~߂U_ 4WVf`4
`Ɍ ˿@T%*$#WCZyRt }Q`!	Y8g&{HPH `g&@uhfP u	+fX: ht@P@b
.ZXyu .ip 3 @ & .>tE fa^_~.f   Q3g&@hNX
YH`g&Hh`XhuɋPd ՠ+t9Wu   u?00뢧tp`&PtYưݙRWV^_*x 7q_`qtA"0 u
3   t'>gf 1G򒀶G$L<LTp~COMPAQ PC Card Smart Reader\GEMPLUS GPR400\PSCR CaLB REFLEX 20a241 PCMCIAfReflex v.2$cr$HP
  a@U! -O@Gd hG`   rLfK s_edr>G	 .]D"G
A#O@.d.D4f`_ PQW 00*
G.P:uG Y.5 _YX8t<t@Fg 
a'fW
"
@
@B䀧g"

%Qf_ - VydP`?P`aSMheFiu=} h7K^ Zu <t rUr  ЎvVrr^~W  2_s
 D<tJCrE.&=t&؋.ouV< ^Lx 
y z { RH  h8D˸hEc| ,ỻ (ZohcMPt =u@pW  f  6
hН.?f>q tQб.#ﶻ2M<t <^gaA+p _*X$SQWȎ / <p_ c{rd~YrS&tM tB&=r6.৥r(r%t&t2_Y[`
׎Ǎ~؃^^֋tU.6No09a 	9u;.> t N!&2 j `k0@雁lݬ!o󬁀o݂o@pU05Ek6.6y rr 

rf	B6Y`	rNb&at ?(4
<	r "	!wPb'П@ ; P 6rj&
 v p rTv&rB@r7&}u%&E=u f&E{DDpP r0
r 
t BB
rM
 SP r'24=@	rl.&:r_ vp6W Q
rP@ tI	<~ l
=@E
tQ&?>¥?GYۜ5h2>QSVW	'	6	r`(= u< s_2.
q	%I@PP  r.2x0 w	P_^[YSQRpCѢ8ؾM t_W؎Г>'>'b?_
˃S3(QY2Dj5 3 3-W,.@|O_4,x60 ;^__^Z<^ 
TT ۸,P_`v.  p ,DPfLFs-<t(<#Ȁ0&Z h ZL`E^ĠEPRU32t
t
u
ku
 r t!;rՀw/tM>ƻ ʇ"SQ X$Y[>"Q;>0I`u 2a=0`*SQY(E;?!eހ	ww]ZE]f``3 2&th13,֎fvp\@qgrgf9tЦa D2 *0 th1J0R1 m@ Vff3u?"gfA F f !3pf t
@ /0޾'3: 8tC{q'P qtrXwfPňf uPюPRV
td쵀P 	 & &$ЛTОRu	& 8tk.PP^ P   0 ? 0    0   0
 { З  Tд CR01    }'  ' s 
 /  pRp   ]	bFck@г$@G k"$Q  OM3	ir0PS.ST2n޾Zӎr\v uTWrL0^q  Q1w˶` 	y5rx36rdܶxE@&=u
uq * w:QEP1[fderWЅ$t^x!ғBq , @UBB
B "JrZ-puؑk=\]dn(uIQC!n
$O0ӆΎރ"lrWa Zž^DTr eþ55xD
Tb
4I^5Rߺr# t itct  t$1^0hffL7V	] 	W0!	RS
ÿڻ@	@+0P3sr8u_QY?_ 0Lr&U_L`
Æ߼02UO
ދA
s
t0<iu,u#/+]RS݈|\DL	(`at ˶Ÿ03APmLN[cB&G,
\DLC

@CPyX.	@ ` $2L1nB0<th3H8t8u6
uBp & DBlTt
륑zaP 03 r/) r%BB!J@ 
; 05 aùܿ<t

B J 2@u8ý` BŅI2۬2Pxu+BTl&2]Q8uC\u rq@m ri~ ra   tAc rF n r:i r5&D@u-&a${vQ> Yr	2QQ'YB@Aq Brm蹐~{  	  @@ `  !f@v  ff   !f`  t?~ hèo tRX1YZ hb%  '˃% 臵hfa`    ut@u):< ugup	@ ߈ `e3Hrd rπ DƆ  P rZ  s-Z@   p$Wp_߀ uu' 3g rh1 tg	 u%  .f߾  ׿fVǠ!&""Y[sf0u.#̒s3hC ̻ ̻> ̻hރM F  ~f`k J% t\+sf=R	H N  ? m̻E~ .@t0*݃@eMF t w  p/CrN QF ~ t˳	4Rpf^0薠TUW  hTV<XXtFE:rq 
00õ D	{  A;[t	q= ;t"S׻e[Puuֱ;T8UVfa @"fRfȋ¿<fZ`SDDagPf` WPf3Q fY~`0@ N?  ' z4buLPC:!&= t<R 腿Z߅1 r01oVQ&U fٳ
&Y^G@^
|6f" 	
p٤
@7:!@7 KH7 ؋ IhL#S=s 
0U}}p` H< Pw -q]Wsn0uPpVu[		1tQZWt$1DJLP2@ [߁ fSR{WE
|D&  t
 tP _%b#\=	(bffU0:T2Vt `
1e;'''|':R? Zt}  E'
QV^ f^DUYfPµ'&{.t'H"lt{t ȠfX`L &zNP{QSjjjj PCyVY\ {hF
Zdvj&F]^J#^egFF= <t
Ţ脛OPxRȝa ޓVh'  p4> 蘿	r
	 0NcfG F@ff#j @_f p Bn'}Ptof m wfa/  0 f7  З@ 3gfhm0s-Ha# $~ EQ0Sf3CESf}Y  f
ffK`Pgf@&@ Cp   q3B`C[fSfWa  
f_>bq? %:_f^KEҦY so@u}e%.[..\ʀ`P t3Qu	  c t .>t*Q YQ|P5Y  g ]$@Q  hfYfXr`!t[u . f u-
upu0s&S5xf?f PХQp  
PmM
OF弋كt
t " !  t phf ] fOj wf=  p5 [jh tc SRKZKdcuWLMqARPLLP$FLu uLPX߮MYt@ D' D& LE2D? 
2v2 *2y
 UU              i Ȏ؎6r'6`3f<tB>f&f;t	u3ϋʸEPW
 
t_   @ك
_X SQW  hShC̀?	Z	[Y
W@`\fX}  Xfcg&3 rfTbu!g&p[g& [1]``Pua^ UR```k   @v
 bV$bA[ g.k;Pϑ
:8! Pf% g_.m`fhkg@0Rߤ O DTOD    qgD ODB } g ) 
 8[t d dRrrf
QRfq	  ru
O@	br	_g&Ƈ0}IP's ŀR
a-PhUo6{XPR Z S .>  t. Q .$eҐ`Vt.Aaɔ70Q!O H oC UǃzTf. .ҷ h$f.ףP @G}ufpp	h cT<`Lv=пfDʀ u4 
  <uq
Ħ.t	f
;
utiuҪ. =Iqpn W`.Buf@@PQfZfQW 3	< 	0_fYBҭWCUr.
fQr~}~1fvfgff{f  hF%f_ v^Q` 3fffۃ?YP
wSfQf"9sf-҈\0fD Cr"
uf.`` @.) t2_@[RX BE@fQVff3 3f^fY3 ~
  (    SETU ˸ @؎  Y r IW@ P& u_SV  GG0G ht ߇   Gu Fu t3  hC) 
h|Bt & ^[SO
&hX '[UVW F F@    v; F`D2ED2E{
 2E 2E  2    D(2E($
f&nEPwXuafa!tE/e.a ƅ @<qt	dR>t <tjjjj3qPC .w译j5Rr$<t.<@t$t = ;t= DP h5   7"FF~ t#^FLr
F? FQ  ~ t: w] *f
 hF2%PFAc~ t
FK_^Q
hs^Tudu   h+$?ط h`bR"hu 
}2.f_01Fhz2$..]  @Y'` 2WVe1E0PE.WV .^_U (UQSi50'i5(e1E0eEE.U s@ m2a hH#5$?eU49$:8a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   sc3@ @   p^ B  ([xsqUmf* %  < ! 1C  3	_
QVWb>u% p u P3  | = <tk ;A( _^YqRW0P  Ê %TCrr3ߺ ڑXAB rN _Z1SUEH H)H
VNujvzJ`LJ5; DE<}@ ;<<!<3Qu KKLt
Lm[VfPfSfQl~ mf3f3lPllXfffDDG(	Dh fYf[fX^r#ڗ0HgO Gx1mQRpA3ۻ9 @q CҋuB`sxfDf3ۋfË\` 	
C  T U S V 		-	`h0uh  h h h	 h	 h-	 a1uv.L.< t)F.63.PF.htZ[+V..^̋] yDF. P .hsE҃Xh ؃04R  16W  0"Xa Y Z #[  
\a a _BA]a f gn'^a b ` `hcij!k qp10G pppQWĀ>t?		 u	?	.G	_7   O 4a9Rһ ߃-w C.5/2Pm?n8o7@W3۸ e _f^ϊ߸^6_>QRrPS[XhY(`fЍ؋h;a
3     x     KBC  [z( V{   Q LGB=  	 0{+&!!$03/04/05 Copyright 2003 by Hewlett-Packard mpany D@ !`t` T`  'p~}P >""!'DTTut0vp0wtttP!	" 	# d~ J0DwD
=t @t	0!`#hTDS>0t"rD@@(tbbD	{T@'T?nPD  	 %
"tqt{t0DuqүE4""#$%%#$"P&d>&&Ô
@%%p$"2` н`ЂЃ u u 3 2q Txu. B/q >$4 `Op" A{ J߀ d{J(
"?  "tz|}~ }𣮂ڹ
 ` -"Cp`t   +,-.@/..--p,,++  䵿@t" ~}|}rp"{ z}!tu t,}{ |tl$Y%P '%($('&_8"!&3&`8@&%ӔP&`ӔP%/3d@$d	p?1%u( %p&u* )**)p)N`._(('''PYTP?%&$ Q
0
Q
PB!D @E((sow2 7 A@0 Qa" qt~ 33B']pMIA=#,". #"!Rq "aTT)"uPu4"%$b4,tʎ"0"
pXp"0"_d   [5t~UtUp\5"++/ÞP.%@] Sp`AZE͹m{ +u.!-..3-N`I0
,3 
	,BSe,`C"d`"7tui8"r          	) ;pqu   06/16z@05/2 6? kLite{{%-1|5?|6|.SS"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0 Y9"""peX""wx wxc}  Ruu u	`	\\@)!T$3TD ȃ@VF @~`T?0	T@a`T%`@0błŃ 瀾xD¯01ui1c`01"xt}
~P"x]vvuu_x!Du(u)u*) + 5YF`Guu!xүx0PPp"}Dxe``
$`$p

Ox f
x1x txDESxxxxgD@@.}}@ v o ;}d`xH	BFK&]x}Dࡍ<00xtxtyuu *J}mqaS}ts p,{b,+b(xkD0P1 pxY xZTx^Dx_T_xcDxfT`e p# * - aVb,&0/ #<`aI	Tx"3
xB5T0/ w/t}!T` ` `&``#0	 0 T`# : 2+r04 i	A_P	<G$!
¯+u+$w4?j1~T+}'+fp (++Ô@^,p,

0%x?
3
v09b",`^0/} k.J@ /3 )`" "+8x'x+œx_`t 8"7}

P}} }	!Y	  @A
xxt"xd}A}D"+ 1}=
`[e#pqR00x )xi`xjw  pP0S+;p0TB+x+¯0*L0b KP4.y+`30Bb+`xOF	+ xT_x !
+:DTrK6PF` y+P>

D0]Tdp+$!$HP+-` 8Q~ܐP2@htx0  ¯xx7x8r x00:`7%Q07 QCTPJ`	p!6Ur;@,HZ[00b*+5OB~ZїZ# pO1[x,0X&xtx0x,A@SF0xT?TӾL*[-tx+r\Zt@T#`O]N^^NbO"?݀`Nk02co`Ao Auxpd_DND0= >	  [ [>Rgxdpc	r>;[!hoQ@*ARx-	+_SRNx*SMx+` !OĀ >`R0 
teQ`
 RSUPP1o 0YM PUi H2XJWi@YAXNSXf @ Px	W}GX$0Ynp^qZ1Zf  YZ[ r c!\	\TUI\tb[q	\S2A}@ A}= #- A~l B~n  6A~m uuҌВ"ǌT#7x'D
\ `7d`!7k33TT?O@C037`'`2`=`HpQx] 6uu?uupb uu0 uu5ˏO$ƨpN`0T`
020ԓCCD"| }(x] "+,,E+p
0 +F,,+ +,+x,+0pR}!,,,++x_,,"-.`T0ޠO72t
!Pt&x&Tpd `+1gw11ÿ@2@tx#Ҍ(響/0mp/l`
/0d@T	PE21D^<.-/0|4" ,xc$-xt`o3x7x8Q7t0 n"`_^S^c2d"xer_ abx," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >C g d  FApqIkli/ur}z'tw l k i h Ju s r p ; t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ |x @ s   ww ~~ r  :xW4D@ T` D )dZф2tx1tI-']0'A'xqvv 'xq]C`Wxs$% & & #2x1 	ү  ¿0 0_%#@Kpؿ3$b0#	Mx3C
r RgJ"xrF`X@ p$" '	x30%0&<T`P$"xsPdfp
0#%""tX.4} 
xs$3z 
`Hp`p$W$ yspPxov"x0	wD0߀$$6@Txy~D"04hxmx~@ oDT 0
 `eB"pxu1xvx}"xux~xvxx}	"xxm#xwPyywxxf`Ӏp>xxı Qw҇~B@
"00"000u0 u0 
04e I!P$(0W<;HsR^TB`  x
0"HD =16/(!a0"0
	00"d0p$!01¯P)x1"}u iT!""3453/:PNP"3554!_Q0"0"xoo`xaT`~~[xnov +r!3}TOp0@0 0 
A]P:0 /\P'2BL;P``Ӏ_"89 "0a T?2u$409S0"{z}yH237:
u: 9+
`:80:808@2$h'Ô@^ p4O=

zP$Y	0
	H@À{0-$`
$`$p!a"V4#<K0" E:0!@À-0
 .  s	!#290"
2xofKp0*2d|p09SH{zy  xpvJ%_`gK9P2 ( 	4 ޢ "H	5345q3`~	t%5544}r	@ :0	h0"09`	2A[09< Lr@1 
 !
 +90 B 9, 
j6	" "!`BQ
p0( 9g!^ @
-NU
]D7U 9.
j'	/20"G+6H,,f-e2pO7)0	L[P85p
b3^&05	c	0
S ":"088;pfpO:2`"/c)P3
~Cxn`qe`?0}Dp h,{_g,"a,a b}iO"4xMNOpxD Te4`^}V Vp0
T4d`#"4#
p~}i4xd@3 0
3 #͐`3`3$`j$`6$p$$`>$`$`.2%$`p q?T%!0𖶓 DQpAh0TxߕvSۀKv`@9w06%6 f`@`Dx9@[30p	3^Pp c	`r搬?&3¯3`y @
 pTU`xk  OF*J .xv
xD}S&10{P^`
}mT?Dt䀑PtYTȤ{S#@-`T`Q	0787$``$pa1e8`tg8r))6*)б'0*a a
Td`x0dp#  xF PTÔP
~@*JxFt txBVBxNN{}wWxJqJp:;<t/?=)x ү!:%$wt=t=;2)0 )=$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xv6xV86}'p p 7  %76(ۏ7  ""88Ô@ fp/pP(m @ /..d`
&~9r7(TP5OG( 4 Đ4040bz`P453``/`@$pN54:$I&du*);WP [x 
33oppGҽ+L2&>gp1  ';]P"T~ ,}?T#>үd`pxH m8@22P65b3e1@dx>
1/ M
m
@d,xA%30 B1
@
 r`00
TDT@5q0	 3:@a AP}Rt
} u2P2b퟿tl@
Ȑ.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2+h(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM"ps" d-u*x0,u`2:,]4 2U.U.X5-׭,* 2732pha,
$,O!% *R5 
Q'x`S+0	+aC ?-R	++`@@`p7v@^}	 `@~oA0y!T`w`Y_` VWy
7pDxp.LDy?N%@k53]Eop;OCD~-qXTQQu:93: !p	S31B3dUyA`hy%%Ovt0QON@pH R/ N9
d.0
`07X6Fp0X-64F0570`,5#O0]c6e#`	S8@1
}3!b-1ÀI%P/;u1
p< u11ްQ6+BC{p4pz5z5
3zO+,yuv {| A, 90 & nPÑkwT0 ,	al:1Ɓpd01|0 upo6o,/-.rpC}}0
P/.-<rdct%,f Wu tq70YS 8S;":W4쑔p1}Bߐ}BT_0W=_<I?`$:<p:T0Oső78e`pYלBxgTAx`%daz0  87>P$3!q"W¥AT3	``Euqq
r	1Q`{0V
}
9ȷDrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLx;pG3p?u]I1U^#5_:`@TU`#v@|T kx{⿐}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmoxup&xtPxsxrxxqxxp"pxkv00,pTxgLү4" .4Yk0.TxgQg/`p0;P .^ ##----*i C?",u{/212B0T-21Կ^ L.. 'q,Đ/{$H7,T{AO-.`۷pG䔸QN.E.OFJvP70pc0Y)N)y0Mh
P5
Ps|?`d7]א}SPn,rtŶar4N0 `a2Е
p1
P

Q "u- 09r"l  },n1vg8ԭ,  A3.02].pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`ou.Ta?1C
.%TOл@QN]03p	 `` 9b  :$ :%Nϔ@6S ? x0!  x50Qq7prrqxvWU
	Xu

		0
s  `
7P"q{ C
G1opTrAL`>M)60.T`@}w}S?AP33TBDWD  Axk6"@t C9xVxFdҸX`T`HT
PM>@C!3"x*"U\]@0CQqڢ97F> 03twv`
pUr *J(( (BP_P` qw0P `	qPa"NO.eB"TOENX Є1n`==A=aYpo0:BPx e0!JI$:1PJ1,F;HKF	#D0c
^"CO`@"HSIOv30aA!Idp`w}@0tt A2bIBbJ``JIxovHI< "xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G=4W"xB!C!A!iB/)B*(T #NA
OA
MA
N/I
N+)D
JaKaIaJT/iJK
I
cJKwLMd`NPT&` v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"..Cg Ô@""8xo-"xf;· 8" x``xo-"TxDЬT0TAip @$0+ZH;b`E}@1UTsKF}R0+UAWAQAEA/A#A
@@@@@@@@@@~@j  AcBQo@KKi"ebrat"#xbr o "C0D)6,	PR#q! b* 	^_;1wV R[V$`RqB-b G$B\UӔ@UOȯUp0	0!ZÀӒ!}!BU`#`5`2$pCx`E@D4SS [CxaUUT[xns&NYq 
xjx GÔ@π<PTxjCuӔ@/`B{r
T" PtjxfPav+xnv29vt4}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAD@9k*F?0$0ᶽDP9}Emb $|F a0U`Ud`*uUrCDDDDDDEE E3E?ERE]ElE{EoE@CE"o;D IttRB'
pE<B.}1F
m0T Ag@$$MPN7 1&;T FK7Ñr`Vx['GAS
hRa?`YÔP؀B`9AO0D=Dd
`#p`(`0<`PdP`d`U]ݎUw0;PR/`npttd	SxtxxWtxXtx\x]txat"xbtxJxFxBxtx(tbx%tp&x)xxxxxxxtxtxtxxP#x;x:Q>0x=tx@_tI  	aP	0x6t<xTВU}.xtxu"Ttx!TTTDހ?D@xwTp
Tp=T	p T Tx= Tx0D'D
?=@D@aT@TCxkv0_}Gt U0jQpjVjTjP}S;"x0xJ"xh3MsF"B S?/ #?@>"Q$tU>$-"T`eÔ
P~0~7%UUpjTT7%TT{ z yT0ﰈH H+H3H4I6I
7I8I9I(:I3;I8<  I=@TIY1	 Q
 I`A 91~5HeWT& 8 `;cuTuTK0T"$`($`*`-0}/wp4@
TB VpGQb U T"VPT$```$$`(`7`F$cpH\p	A^@
:3
2  *}0`: `#'Ӣ/A``,`003`G`[$ap]Tp^"T  dpF^0$s  `!D񑝧Ttwa/!$ T  U "$pR`PMEQd``IQxhQ PQH?THq@P
qJPoxhv@@K^K^K^K^KkKKKKǨKKKLL
LL+LmLrLwL|LLLLLLLLLLM MM>  ME0
`2v"xMNO`uR RRsл }iO  /x6  "%6"0R^
R:p;Pܵp}"} HGH	}01"uS0SSST
TS?0CS`~u 0P/ 0@4xathvajQP0@kxTxkD0Fx̏Hxbx"x@$xx"x`}_K}IF	
Q@PM0""3HxT| } ~ 'Jtǐ4Q`*OE QRR &OEMh((sMMNNNNNNMMMMNeNkNxNOOOO4.?AÔ`P/QIF"T? } 00xg"QfSQma Jw0pV	~ 50ߤT:uQ-0`P 00)	0PS":C$p
;)!/0Qp,"xdP P0A3*"~7}i 0?IR3AP>2Qgg8MC}Eq@JWC`X .Y`NZ 7Q mT0""ϑO 0#0xD TAxАi!1?xxivAin0T6 AA=B 11u32}'  $31T3322@"P0  "(W "  k p}"/*JP;0/Ô /pC0S00P]20000"
AxpP" x0ΐR3456&4@"(t?4t 3+x436R5U6B eaxQxQD~QxD Q  097x@T5`nT5 }CT/QCQRR#R4 S?SSSTT7x
01!x
tP0P
10Px
  x
Q{Px
! %70$t $T &Qxt	}XBxs0xsP2P0 p%@$X$ÞPxxs=<`1 <	`2`,-܅/u.p0=T_Iү0$`&ppAPi}!  `p0u/Bx.-,/O7
&xxtӔO@v%)xsvysßxtP  @'߀0 	b7
`0Hxߕv 7tx.Q`r
 aP!0	-xx
xB"x	07T6)o`rP$# :p 07 e2`T_ TfTpTzTTTU9	Uj
  U{`xgD1 D@2A"xDcV$P``30TOX`Y  ,D"{:1TS`i?`/AE@E +@@CEtU7m O@` { 33TOB T? @ 2^00b"`=!`p}T``8 -5,,F5	S,  5S,`xevS, ?S,,"+,/0-WRVx	` }"yNJVu0 u123xf`-30(?Ӕ
P!@P23	D3E2NYLSS0S3u2 u42U03U1Np1%1030444P-5xp7x	410k	^`_
55-?@xA1 YF70c
`/p00_Ӕ@: 0-	`	PWWWWWX4XOXjXzXXXXXX$Y%Y&Y+Y&,Y3-  Y8-`:S	Y8xu/@xEP[-._P
.- ^	
x38t?e.pt e-0` q	#qQ2q"	`pEx@}}t*`
.J!  2#@t`-QevP  q} pQ t u vAO}	}c50R)1 Q!q6`^"20 ,+ߨ"`@ZP@YYYYYYYY	YYYYZZ
ZZ!Z>ZZ3Z  Z0_ZvUs  S1
tt)u}#	ʓ
pu&| uD pTӮQ WT0BQ
":ĴP^`pÀ'`Q6$T]P  rgmZ`!L0d-GNt(Di4rOBksQ
xbn)S@`DAT,T
`qMC#_ "gD `E - gt .`T/Ӕ@"p--d`"` 
`-\>.t %-Ee.`.7@aG\=[[7\=%^"Xto.`:``œ/U.`"U/`"",pO/`c/@ OeA
"x
xt "Ӕ@
u/$ -$UݯP"xՃЊ0"5}67 d`77p676@55FP57C B242'   `"? ]b2]F]V]7]0']d/]rI]{J]K]N]Z][   fps"xl0/h"o0/T1H: \$Ԕ %E 0k33%$Ga e2pL2H640"0-4d	%4
4ura
ov"Ô
@"44$`$`2$`B$`J`[$Wpk1׉P 30//V_QRP"D	zqv34AqaN4p-7bVP!
PD"_""Q!0! _$_2_8_>_W_{____  `0"u2#`u22zb ! 0"Вtpu2F,!wu2=ra&
Ck^Qbp&6_r2UDUE.pu8
Z/0")5HQ R 0 3A2"0"x%0T~t@"Ô@P@n@	T<" O x~ <9 0"ސ}t 0	Y~`X#x0x!TT`Deƨp@T!D`!T7r1 `<nxDxR   p"@'x  	x Ӏ "  :	;
/'
123B=>C	D
WX`~x`!`WP ^`_g"
%*7xF`7`l0x+ +d?x n{qc!+s+@U`C0/+xT 7D } 20㐘sp DT`6o PzpTT`P;0	71 b S 
0cx	+$```9 Dbxv z q DxT"ҎxStTTHaw+xS+<x,{p7, J`$p#+pxSwx+	x070/Xy
~
0a ց"p.!y@-Ӕ@	}-D-$``"`(`C`G$epY /dC.` _}.  Pr` dD}!lT er.z-p}} .d@aPVM+@@COFg$ C.-
.{qQ~eg @fdRuŃ%Ńse @? ? ? ? ? ? ?  ? ? ? ? ? ? ? ? ? eeeee.T.
1fj.!"dfjb0I/@0'  xl..T'xxf.r-.D&u{@&{@&\-&M8-&om#7ӛP	ӝP@_ }|d`@vÝ@ӛ@*ÝP:;<u it/dر:7t"0pLpF< h"xHڐd"A 	/01234u5@2u<$t}5}p/0hh1h~hhhƈh݉hi i iIiciciiiii̙j\j\jjjjkWkWkzkzkkkkkklllKlKlllllйlкllmmm'm'mJmJmlmlmlmlmm  mĐ~V0F pC3/}u: u; u<3{fq4mۡT73Vp6bq~ 6` `R3`u3pwuu:u;}u<{xu{{X$::;<{&5jhgR0p  ߶'h)g

-X>*05G]E` } P0C3+1!~ .`| }` @^_N0R"`"!"H
$*
R#5'((INp:Id @(-
cC :001{ 7'+'(.))X0,/,28.17.4h03g0҇o.]|U1PrP
AA$__TW&A1 u2dG'XA=9='XEFxBwBH˨DD̪(KFFSUo UHH#MPU6P!}UBfP>/"UÔ@πu3//ZC_4"$y !SPvkqp" ? "@A~R`j0n$o1`T}{&A`##xt@}}X} Y  ZxqBBxtPBHQ!0%70$"Ap
  &Z@AOr+ 	 	Y		Z 
 
[
Bxt		  ":bx>T=Q
39T_]>?`dPP?_> I IPw0=_p"09n
 } P࿴' 9@
| $ >Dh0
0oSd 
Ep6B}`~T }u/DQ {p#@!t1f}Ԡ0STTs- t
"Dv+Ѐ_ђ0  QP$Fw+~@x++/"0yu1u2}u3ƀ0ТqEɫ123 С`qPT?T?`@ %%Opt0`	"13$521~pV0}sTD kt @A?31"~T_"2k p}qVP|
@&nEp0z2Rv`@ 
41sqq"14P3r{w,1xeT`q707
 0qmC70'|}pp
"T`4"4"0u2<}0{0`~`~^ׇ0ۨTODԿ#1p3222j*0 $$Q0п0{ 	3;P#yP80+`
8aP @n2PB=2&B32p08[P`
R@P
^3"0xOO"̀0<# 0Hu. 0338e0`01K>_$Seau.0o? 1/T`J@.N`\QPa2=E	DsbCD 0~! S ``Og-c#rƩD
Kx墉OP+@bT7`6McMp/"5676E5`  @" p7Nv` "Ke7`}R56c6p5n`0npo`(}$	4 ӣސ@ [xS\2	Pu8:
88$"9:9p:b"9:`x!D"p TV454W6u7}u8W4WvEɫ_678QmvӰHRTNpV``pmP4RU Wu5u556@
ڡX7BU5Z5#`Ud"W=6F@F6Tñ__GC(u1	02u0AA?*:/qrb=e=ÔZ	Eu1xiu0D "	BSp}u2A@M}}]O~ x`@ӝ@2u2MÙ@;pY Ӝ@20 S0@[!?$Ýt#
JE쁍@':L`3MRwߋ3`	y`60҄1 X@L<?0?;`@B@	R2}cO"	aڢb$U'NV\tАU$	??
(F$	6
?? LxB$x7EyU2}{z?y~al~(0{j$~/){jw04<t@wGu/'P~ @| }` @_^_NǇ/$ƥ|tq{~@_aqzpTN`K42tpl	ÔPtPݐ!}qo`wk`45Cޑ@/Gk4383  |c((s|}}8}S}x}~eu=5Vw	{ z y4o	x5P4F w
I4"0v5<%LPJ3D,t~5{u4`u5 	]4T`p[d`pxQ?
p0
PF	R4	uzLT}P} pma$3[kPKpß
>Np&>40/餫њ	r&
b67d6N@7"PnR Ĝad.+ye547l`&kI!Ũ2^8)8CPP| !5`z {pD` @\]L}
`89998O89!Q!ֵd8Ф9!
@&2nB0gC' 3
ڤ[#98&d]픜P60/f
8 F FP2GPzadLp;|t#
I(I#<~I_8mpl ??a\,@7U1dNptOLVKOKeK8UuNp7>	r^HQȕo`Jp?pNӐVSYSSni;b/9'P#vZ/i T2&(`?iikRkm<Jѝo=	q)>s?TMn iǕ}lIDT-K098n0,98v3 8|Pv%3{?"2u3u~}t2Tp|p4 Ô|@u44$`Eb c $ ۇ8~ 28u4x #ux߅23@dE`T@P @t8uC@pj90!
PtPo	9TT Np;7 ! Q*:42u4
tu q"[e4`43"u0p`04$QC¤ x0~hmVĀ pP	ÅϏ0!"0p@xl0!Ð}Z}ྐÐ~' ~& Pu114
tϕ11sP`x03{}:%ROCج"Lp0N U12>+`} /g20ˊ z w~0Y@ :2pPu2op`00
``֫ӕ1q0100 ߈xeT`}$1ßP`$g2"}`q 
"""4}{tt x 0 ИQ
xP
3U
02	~STD"LION`Y'mp`-wPYQ)x33$2>d`/"`~ }H@X!0]г2tjP2߀22  ~d2~X;a;Z <Y>PS@~Wtu4<W42~34p꯫`u3Jp[pA_P~3\	@b
3'~cp~ @3Php" 0~^"/0734u5$*``0$pB/}u:u;~u<]{fq4E`e^{c/Y{00o//u: u; u<3/r4"/
`:  "p	` R^["pPS` "0B c!QW]tVbtCu- P`pUZ E-ӟ@
-  e-`P KAptYX`
Pp-2"b`[A3p0-W0xQY, `"q ,КGȀsP&p i &i`\A`[0/.P[c%,'`-lP,vt@p,06	b"?!$(p  h{a@1hP%g1122"$&`
p:~k`oj["oT<fP_O0h%a	O"!i*h-esk8jtg`bST^ .T ~Bio`P<h0 M
0`2Shqeo`'j`#jp.pA
 dpR~0/x D
 6
p4Ɩ{OI5w32p,` 55px<Wx;D"05?5 du<>40/105.`* }} n x; _/0524Tp <  9pP
 DeT:p
~"
qh~ d9ApxÀӲ ޴ 0d"0Ӏ"z "7n8` 	@
D	xorb~,PT e8jyP@sp 2s0s"`"aP	0C
pp3
a@td@r@"0z {`  opn`dx"7@8uVX?)`,7bPqPPr Pn{p	84gk8$"9:I<6p-=u>:9~nAe:p9lpe<ʓ:E9~ `v@~+vP" $Ȁ
0%S;;Ӕ@;@x#q,	; P,A?x@-;P 9>p <p
9:0?e=p>`p>6>@Au_B6P,F оAAp@A@@;B66B@	x&T 1"%T~ O`=&4@"`PѤ"x!To`	TT79W3o`k3A 7HCҟCpx!8@5B ~Y0P*Dp0 Dϐ~msX44`1K Ad'0t"u;2CF<9:Ku;} `O I I::9:9@p56x>HMx  X@b665ð5P	` 
G~3IVD"¯ DkKCQ*+u,U
,, /+, + o`X Ta QG%Gה`xt!0^
T0xT?T1U4TDx!CD@Pp
0g1dpa 3%33+p3+q@
40YW4cQp(%`q
O5[c0*OTjV		[eЂl` #A""	F	 >߃	@2VxpOdX LҀԀiq3ꀚڀʀ3䓣Ń ?
`	"3/$ $ P ##EN``#sB"P""):`"P%0 "b``"Τ.` "  )"u/33@p " 3@P""0	Ý0 arPb0"(p p8@
!	P	t	1ua
b߃*q2	1	"wt 
""BBE"""ЃЂOP  tswf6 s)Ńu& "%@$5bpp
s@h`߱5p5 5@~5v5@n$5 b5V5UJ5e01515 p5p5{v5pv5v5q5#s                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
     MESSB\5m6]}!O:d>_vI,	]								

$
>
G
L
~







I.)
i




&>Tilps{l1L	)Gh
@Uj+@Pn,t#OV 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
h
R	Rorhi7n: (ABO= 'Ctrl +P=t` Del'p08-1"j: @changed2: r)mB* ne@A P+@*3/: Video	Hֿ-4: rrupfPZ5D_i)8]6_an`!expansb D  TurnB!!"ej0fs}!)b<F?1>: Abr
bARrmal820UPZ mu@P#gi!Dqwaa6#+Bk-(Strg+Untbr,QI n%T@Mf owᳫ$oOp6utom0czb4uqhed: os ToW miuX: Kbyt0Vcksumtj,fauP/Jpku`l cpWNext? EfqttibExPfa Ks/ssaPeAcceP'= p F1~0 0 F2 C S I zB Apinue mpuP}s?  MaianceDb
 uyta6.<wirS us Tmodu+mme$+requires'.  $oc.,d. LBPU7MpibOOay1__2_]re`excee !QԱ@5b1`vCirccuue Undpw lndsy..P؂(. 4dobWee.GS ١nI5c5`^ XInrLShut
downi 0 	-a:Pe Y;PINW: [
] \Nb<1%left+ 0H1HB@6 u`Uρo
v^oax00S,ZbpCer@uSлUe@dLPcuҢchipQ+be TEp퍓JovldNew_ Pԁ*upu'< *Warn0/)fTPMoVc{O2	i8xrevpo aaks,STpa Tmr aI5->rmin[r` c&n>
U0_ >: XX hours a ` @sAAf($EpѪm	hk-.t*G uhSq
IfүkGnow#E%,FsAmj0"jcthXìultI `is.2K.!bAe$=4r"Q du`Rt!>TA n ADrZ
5 aff`Hb^a@)0{ak5xPunusKVPzItmsg'com a2
f@a%greplac2mâ aSF2 _dU`qo!B's TrPlatдm!(A)!:be.Bi2(HXe[C 5A?9aA f P;o takйos]k[ 	Pgt	g/ /S OEM Spec`Wc OmEƟb,dx
NOTE: `BBcBrwitch WARNINGirs#@갇2bYRlo c01@0b
O!;pAencrypqbh!yDoso]ghBhV~applĉ^Hy
 from funr п@4RR 
ERROR -BfБr gonePyjtlUaMaPIHx (MSGIDX)        	 OSBC_BM  p ( d }0    C %   O L Ʀ ҭ V s&  ` B ! B Genuine Intel 
 '"B#@ 'B1 \ w  ^  Π @^` Z    @      >"m2#3/V"aJ<!2!-"B#}2#3/
#32#
3z>"3#* `*@  gwb.A2".@ Ϫ ̀#@` # #	
/bf `((  +*# a@ 
!ϠiAmin"2/a!3d! b2oBcON /""aoAE`#Ufgw'vf	dA !D@@ wfUVfvh!$a"! %#`IWeW
U	v  I+",J	A!/d/L* Cu`
fwUn)@&-?>*eU@TfN7`
E0Ud 
_k:$aLJVeE> v y$w@F 
BDio.FF !W.LAU F@.NtED@y_TQWv`EhT@Y@!	hW@VO[/^          @ > !*gEgTbgy !K<bfW(uO
fW.@$W2ϖO* f T
 Uf!_kq ey!!X"V,NgI%X`GysDBO&na"WM,AGi
"cy o0 _6_84 .Y`1Rb4yn1@Z   OPMk!6URl7}mQ@! x@" UOA}aO B; )oug_ ?tK`+>i@i@`.9 Cx 0DoAb`&cakh-	!vo!uXN^O!#] KdA
#	$A	Ȗg("
f._"%		7@ 5n$oo Dh
1oo7=%SB!(o'!ih@3A4 >%
a@/H@Ip&
> D
;O !8 .E .A'b7B_b/aO&A7iɕ'
]aGB8
$7a8d';# ^@`t2`ƥG%c.%
agFN@Cb!"YbR j!˃R!tUEQED	O@: |`
<_Lfj
`$	_agb^"Zg΄pObN Yྂ20dO] WXf{Pn.E$:hind``s[

'!!wat)!"d>aD2b2d!, _ ~TU e A!N\  @ !U
!Bf .  i @6f@  a BF HaV" ,@ s $ {gJy`uأG`Tbpa!@b`g	J` HaςB
 Ta="B @$a\~ Q( # c`m," " 2̀ }!8 "
d@"  8  L	   @	 OSBI_BM8  p ( d }0    C % N . @" ^C ̤ O ۿ ҿ ʳ   `    Genuine Intel 
 \ ̟  `@  ^@ " 2!Z; #3   ,$1T!4Ft  $xCo8 A
+/`OCo  Aw?q`B A@_ O ?b `4D	)A"
TB	aO@!

\b-_OD$
 Uq. @`	'@
]74`A._3#@ / `C:MB
 /Gv"BD  "  A
WD2 4 132%`3.hB": #"
n_`-%eOl & 
`'@*@BARD 
*с!B+4*i - 
-Q?%#aqAT
 ),AX )Ia/ od`& 5/ot/@B :>Co 2  Aq \/ 9"`i@Bc 1gu= ,J%A
!5"=34('d*8WMTPAS o1       aF3HGw\`[`7!*9߇ K2$hA;"gC bDI*\kCh
20 B$6!(1h
`@ 5:b8LC#	UgF@
!EO[aFWB(E'2K$VEBjD[*m I?F0oc""H[a
U[G s#k`T *`;wdEO] M
a a,[4OKaK   2"(0""ak,Ve
 "$aX o2`C@$"ZT  (\[8a [9]K< 	_q>@I U!PgbKRmQd]g  !.OEG d S@$o f
Pc dO&i
 
K O#EІ!Q 2[`  qoU
	aTWv!" @.B_"O)]	 
#	{ !,f;
%		7 (B1n.oo&DAK!3OPL@B! =oC; oWw{ :A/.@qa1 $0 A;9k $B bQ	a` 6K@@.!E$2A@J	h6 Id6!Q?J @aC:E-$!Фa@[HBDJef QwA
` a\Th¶d@ݯo WJBb^OaWx	
aA ӆ H!(CO ص"" 0/0M"[pYaNUDk0d:$avR!$
 qd^
	z Ayo"Ab9r y{$Cbo`!~ae(t'	 J]>O  
	t`&  s
aFؔ pc!3DAH(@e`+BKK@vT u[@wo# w[b2UT` B3ob#+bVA vNT$@ !D`A6b!@@ZA t`$A! A@ˣ
 "(7@ $c
 G   9(!,.@#0F`Q@ $6 H7`%    
   `	 OSBI_BM  p ( d }0  $ C % e | ˯ Ծ ɥ  Ը    s% `    Celeron(R)  \@   ^`  !\ `3Z"!1	4DZ32 Vf?TXDC _UTR*
 NJ@LjUDg;T ew  WwvwtDEkTDodvW    F m 
DO`t?e_`]eG
e
UI@_R`D@ D gwoTU
O 
_	
UU@G!
Ac
@TDFR O@
`xJUIN_aG Uo guk"f B E!DR!o!T@o@
@	F oTDy]Hw#X 8D()U6#MT4D ,h 'eU )!U@.@- xb
F) ') ) o ) V%X 'o b*d '$` D24@!%V b%o%AJ 2.Y0%a. .
 5"d!:8+ >_`>EF#	
DO_` &
GOI
`?ooPabW@Ua   $/CE8a  C6D "A	A@!"$g:WX>,&&';	 DAQ! "u@1  P'"Q!#-VRB)tQ 2fD*	$.F `/$A2A2HWuNVz ave>RZ       | p&UE2F]Hfnyof*h ]hy2xe"lg"4vy2V*z'&awX0z#zX6Jeq|Q:tvv?a2ߪ
` &
:OA&?egNRY
@*"{A(IVa1(A`^!Zo ._O  \Z	"G2Aw j8	
Y!T@\
b@fh@{os
@N$\"(r~"Km,!S:
" `
 ?2	h   # O8i~<r>jb
P`Rb"@""
"/*+'  eK	!z`
/!`x !'A &a
.!a\@ CP-O `
a  3@ u
B@;BA)b!	 5+ lo
	F- #!%oi
6* L-OO C/,0olC{7B/A8Μ@O!9.${`;AG(k >	= 
(6!9/f$Kd$A 78@[%
@?b)!@"<:A2!6A/HIDJ	 6A7b] 	!4DB(& X^1 `hF%
'd Ei\R *8"Q!
` +*"#!hoXdB_[ B^/Wy4
AQx"BwDO" PZe00M@]B U+ee6d:fC;c7D qd'
 z /c#BD	"`y$ |Aua+?O~($b1`}b_y  ̴ "b&]CL! A4d
t.$, a-#CwF*/(Bx U	 y` "~##7 xA!!D` " H`8bF@	<C$CwA	 #)!
 "+!Y!@  W $" `!B``@!(w@BŪ' #,+`	 $0 H$B`%6n@I &  
  g   	 OSBI_BM
  |p (  b0  	  C %  Ǩ ӯ ٹ  Φt F x. ` j ÒU ɜe    O O O  . "#@B@(gb0:$a&6"Ex&u2 .rO.2T,8(`z#O@2x&
	
 V 	$@:"x'w@ga
K2}8 څ <axJ>c%( ˇBrD!D`
!h *O 
 `a  O}A"!B`  	 [
W@)o C@ W`#	@
@@ ,"A!A'`H/&"x'Q`!"@'V"Yooh`9!"@$&!#C#DOM8(4$ ,!A	!$b
"($ 4-DAO>L/,.!0 7854?4 A`6O_R1!/d=$%:_on$$ 8A>da9M T
 7%%FER ='$:* >.GF	. KK A
U?!.:!6:K/>/ 90T@VOJodt`I ZC-`] KK !/*!3!i`f4@UBB WeB7 ]a`eC@g@"Q `H)
jodABa!tVfo/gDN? r8'fcF"KUO$@a&QQ_@z$4XA]"B_%_Aha6&{ hB0`]jn/$U kq mEaly4paGR0 i`uOH*',{>R tA|`}ҢuOT7yr*Zw;@{u` }B}pdz~ $`_rqkyx KWKap:AxB@ubx k4eF`*0O O O       U     VIDEU0 ! @ 
00IBM VGA Compatible BIOS. [ k y PCIR'    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`g aP b  c dP e  f gP h  io jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT CALISTO d 0  03 _DATA_BLOCK   o`1305Intel(r)Calistoga P Accelerated SA 
Contact Azita.Sadri@hp.com
Build Number:  Dev
03/20/0D    Copyright (C) 2p-P 3 2`rp. All RAs ReserveydPp      $		


	  ! 	TVD "LFPy{8 
    0| 02468:<@BDFHJLPRTVXZ\ i{
  4 (  8 H 00 @     @ 2 D Y

 m w  @m `   @@D HLR 0b ! 1ע  }  =     ܂0܁ @0
!		0>! ?   H `  bѰ_ Su  = YPP R\͢ $ (
  4            !0 R`SI-1362-Xpϱ^5I K .=H I <x <
 2	POZ a-  	    	Q Ia(] S V?4̖  `	    < P 00C)xQ? 0P!<? (, ,H d @A &0tx0* Q 0@0pu
/xQ&@XH?@0b2@@( 6Cg6 @Qq@*( ;    e# Y# , (q!s4) S	(		
	(		
	(
'

1
(_
q

{
(



(

(=O
Y(
(
(-
7(ew
(
(

(C
U
_
(


(

*Y @ Y } ' 0h \	 `"$"<` X  1X (sK	 <į# xx Q7@bܯ(,)t @/-{/c B _
00 *f  @
%,@`@	b7
)(?<p#~Aqe
%
 P)
D. $<O^O27@ pQ_X 82

,+a N  Xc JXL`"o o o o , w * \ X0+ņGB)aUfPfVfWfVtkVfPu.t@uf.fF- D  !.DFp 
F {FPFF0FfX^=fǓF  
FFFFZFFf@`w
F'  NnVQRffZYf;F  rufVWRf`ff@
ff1ff^pZffq_f^f߃ !;F}Nn߈^ f~f~`.sf~ t$:V^:nQ:ND~tPfFtFV?u )  
f~v ø t2:~sPv0v^*ߊfދfV2fX]"R_f3
 fXfZfXþ   
@c|Ȱ  M`[5ة  up3 &#0&.!	 
 
f.aPVWo tR 2u/N"t!@>rVf" v ,.L^ 0ff^3_^Ï8@q} t- 2td3 	\ tf1PSRV<v
W_2_&fW`<<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\
		;ufRP1u5 0/f`fZdfVPfa3% `= `Xf^2dfP@@ r pmf D!pf ;r;r.T#6f"2p#`HSfQ4tfY-ffXzI=-fqQ fYf.; rZ&)[fVe$<-uf 0,^% @`H"-VWf`ak2Q菥/tN5/r Oufwf%5D0d%sT #2fqfXu
R;Zsfr3b4~f464F15 Za1/t4P812f8"tRJ;Zr._
 @) $@ B*#"^tu
 ?`. &|@
f?w0	u q3f$3 $v82x2ydyyyyy%z~^)ͅ߆v;"' ӵ{!0!!`"&`(:):U"a,d"e&"fgT$h"!mUP 0=t.<	0ffX.6Xnހs.< p=Ou
uNa=_ j W,6I=OuFt=Ot=_t
=OtP!IXOuN
 pt ,f]WZ+s .<t.:u.T1_F`2a   1av5031  0|;*RUFC ^*p q  P;Q-2 f. u/u
/F t f# 11fн/fP*7s&G#5 1tJ"ee@79 gp
.f
' 6.6u 48
0S@6[ u	uN 'Vp 
#-#8#c####	($
4$ "`( u*u. x0Lr{	Eˀ@tc}`.uZ
^p;;2tq Й'51Rfr/w*,	 A	`	/+{s!r"	rq?s
 "t+S
[tۃ^@z Af!O/r%x		Is
m(f"1S,fS,P$8X$@
؉	/f`2(qـ	dQ	ؾ~$.8upPh?$u]㊤VsUO/oF 1*= p\4/0]    ufhB, / ff'4.,PPQ,H-X,T]ѷ.^.. #E.@u,@n@{B{Ay.faPSQmQD@B2;YtlQ
 srYTZCQDtbt
@t@uY*Y d"ut2r$tt	Æf^ZY[~S w3ɲ t@#w83u} &
 ut
 291jRf@   0@ApΊw &ӫ.tN Z uf.VPQ\	1rp &.8tYX^r
gf&a ⢊f_C	f`VGsT0
wt#р tSRط=4Z[6O7uOBT)'0bv,iA$Q)B^Xzщ)+o)&tԲWq|1]МS.L2큚.Pi
QPQffY
8Xt+YI+.t
P<0SQ;[tje u(r^u'uB
2tPS#[;Xu)a+tuP
PStIbY$tSQY[r[bd*3QRv`Xu@ك p
T.^tSD[r1r %p(5#22`] 0(@; !N
Ns 
? `YJO(B&fS  Q} 9*=(PQ]](L<vYX
(r2(P  W'x'"%hvX'	%X%0)&G.&7
 2Aa`df
a t@IQ : 4@3Y뼰M`òg~)EXrPu(s#MS RX Wf_V.4.tf^^ ر 33K00 Gss''D/&f%  8ue#ut/rP/sZ}9@ CtĴ(Z{-3f
f^	
%g&mdQ`D/r{tSC|c"dD<(YJ&?/"tns    "IuP$hlQXw
r
SX$w
؊ˣ$3Ҩ@&9
!1  ,1-R---.*.>.M.	.`,p$ us|$D\өug$u@&'%{%t!xa#?%fSf[~R#0%XQ3tX$ ۂ
$$u۶  Q.ߠ2P;YrW!ta˾  #fP&f0ff-  ff3g&fG_&f^Eo>1>&%s߲4&f$8`%Y
@q2 _#0` nr`Dw ۊU	P \.:\s0f\0Z*.$tBuIP R" ^Xu,.80$.t2s!P 4J4XS%[Ϡjt
 Sz1#@J@
<@?f% K2M a%%"$ꐈðs )r;
f^&E$!!$ 4#.8=
f+442!t2 A1fPWvM
& b$Y%2kJ:ZT4.ɲ"	2rVPS$ S#$7!Tz<!$tP:u@uEtAA49Q*sfQ(f~wu!00`;fYvt |@000==+ r
`Q2Srs[Y+8<FHKUrM
rF\s)\.t0 tF0u33L rQ"YbcPPB<vrs	 PfWrZ@1㿏 .!u.Mm2ft!"oSQл2Y8[r2QAsYf_XSW_L_[`rFsr}?Ċ
H
t+8t$P`Պ"X` 8uAHЀ`ʰ84
a `b	e+!`QB#&f ¢IyV(u
 o(ǿs"e,@K!fv> 롊 t .ut
ъ!-PD0$X5&32
>J
U^ FVvnB]FPW 3&!Gt8u"XuD>L t=s4dй @E\n tF^nr3vGZn3UX&26VS2.Zn3V8r *[Y22aFX]W.>bnt>Àt&}&t,(-)*.)` RXnÿ<v<t
<vÜȫP03bNb<w<?t0fx4es%2&J&P &L&ģ`&-pK L`  aÀ5 
65555
555
6
6
686`,sI!uM@B? 
<w
2¬t0EtH)5}7Ya3۱R u t?F@rtƿu!WV ^_諹 
?GW _uGG d a `Zj	 QIגХ@ڃ. (.[Q=Xuπð/؁Y`%?@t	p`TFF!oGpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊XFY^Y s0&G
Pp&W&w@
p?{w tHH,2۰>trvsr&9p,uh 30p?v 

r0~_s'
 4G_/.>`;`;9ëp 0/&$F@f
r	u 	Ǻt@+E  4t<v<tP&X@F2h @&n` uPe5tJf &&_	7
aTug_Qc$<0tqZto2- u "WEpaE1^X qѾ9.8u*fĐs @t}Uq`xA(  `
s6fGft42q	} t4 [ $b許`Q$1t0s=01
VWS t#`IF[_^ rffV 2~Ê r:<w4&	r*ufy21=Sf[f0ΠVА	s0`t*Q<.LYt  u
d"8ӻu^ZqSQ"*s	.S.o[d  Yrߊ̀vXG1Sf #brnŀtʀ tZ<`<rNQvYrJT rEPf;Xr8u $ f.;v"u ft	 xrs_&fYfл@NRVS6 X t|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ^e.DYXu "
~[` "RRf
P3f&ffȐX&e0&} ]r`/evu  / tRsZt	    >t HKP&Q䰟E Mwr f+V`b0mP 	X_7^[0
 {^94=S
B˿^HQKENP&EK@F K ,``HKqqA&> >  I m  @   	 -` QPQд 1-l#	`@PSPS+׀*   `s >4sPȉt'>&E#ߩ u 7K>S>.97J>r[._}E#[t &fV{GP@|5 >.}Fr YS@;[^u;t;Gr;w3O0-?>tFt` u&t/>  - u,߃l6&=	r[s	;v2SSWp| u
Dt2ۉt
 u.\.ߋG#Ptp[[_[MfE#%Kt&  0&Dt&4BfЋ D&F߃t5;¯v+!QБ\&^Cr AYF⽹ q= t/0Ufawø R``Zv
uQrg   cYPVPV<v`	 rL^sWwR #fPX2AL_?$_pàos 
J
fARf^d<w 8PFXft	3f0 
@
f;w! SSPP@vi.8Az.<uSpZ  Q2<v+<t'<v!ptptR[SwPl@h/f
Q@0X{. 
.&!j Q] PRf|!  wДz YrVIv0r@fXufn0A
$@VW_#sB d @@=&|&\CrwPx
Xu	 Zr0g
0G^f
f D0   	

#`
Fr=.t5WC@Nu
CC_2.@S6&[X<`r<qwRZP$<P sS# (S[2ۀvESp%RffZEfP= [PmP h".6fB p0Vfqi	sx@2^ae U#e\sSuNUXrz5u P2ɸ,"y:/]F+?sau\Uص÷ zMߊ3
x`@!2 > "
Xrk;~r 
;=<uUӊǋz% 2MFVP3Q_^;< N3
N uWP1PS ^0[HF0Y.26~VWR\pԊr;~s8 ~JuZ_^N t0S[_i
Đ27702GVz 
 ? 8r@  /9Pi` &OX6"2P	X PuA0`2RZ A拄PO0 ؆! PX PC׻[	ހur䀿
1`a}@߇@}@    VHp^PfQsr
^  rFf@ P@
K	Pf3f~Aw$'t`ffXf%p	_
fLg4!^Ep_p[	t@ۥY^X~IQ1	fP@ǾIf.Vfmf@1u^
 quy'ut?^ȱAlPQ  tn$sR !
`ʰ
-u@PQ% 3= u&=  Q݀YXp_u
_Sl`<XQVW_^YS 	sK;Ú@`@\*@ й   ̰wP, -2 Q	faVfW^W߹ &  &E _^VS3۬
t
<a|<zw$WC ^3V   2ܾ s @"APP2 jFѐ:u.T3lV .^f.<Inteu   	  
 	 pPRaPa C` PB BםA B;rXatSR3Z[n.L@u"Sbx$ؠt  [.LE6r+f0rZ *  427f;q12mPwPf}03x!f.80
+؀fy04u	fSff"@s  0}p.>M ?M^1D.M0Rf߻6 10.df 
00?.D +PR.>ff.!` pM .FFMF 
tJHa s FACFAa '䀀Xð
r؀.E_.VV`.
  4sbSA#~ѐ$<1=P<uX.>JNt  p9.JN< RH@pR1BRATsZ4kbdRޑMtt
r	 r212R؀t⪀`. v(.uc.<s.t0FjYf u.t-.5ut?."\1
ǀfQ̀vY   LY,R,QPSP`X?@K~0ct	bf'`/R M6 ?@4LTlC#t4QJ uUw< UlU[ Fn X+	s3-Yqs
K
rRR
RZR@  $ bPBBCZQ
Q QQcfƊ$f`@fffX#t
p tfZYQ Q `  	QϱqtϷ f
 tPP첺WS <Q<"4
P`aU$$``  GS S2 ijhQ"$V$< Q IYɜu~(u P`2  %ؾY;}YqqSQRm 3mtZS
S` w
  Rf  
 n P P0@#ftsrg^ AUZ_&"9?R?(`1(LaPS9""
o[Xb*Ch$)(~(ff>}Q`IQ`  `Iq-
'fS-y-`Pŀ7P(tu0yۑ-2e/ffȋ1#ff#f`	XjsfA0@5@50/RA/u kfP0/fXPӋ#ك#[uX6 &`E               [Qr|PrwKH7V &;v7ċZ++mdrd&Zf+0nݸf 0OUĿ`F R{u F . QFQ	.8\uO.T;u
.u#u	Ff(	 ff"u
Ff!
uC✾E.?  Dr
t !ĸ fV.4.tf^ ݾf9cBa@~Of^a]=W s(PИ
P }2f^@=wp_ SRVꀞ	<\r5t(tP.\.DQ" YXsÀtڀn^fPWUю fs"  f_&;u Eu&M]p _fZ`rA@;r1;r-fQ&
 =p;fYua0Q 	&	s(	'	3Z[R.6T.8u.| u
0.;6TrӡAVWrEDtfr
*tfk 
f^&M)
 _V3t u2
^PuWVIr&&f^u1@uu P^_X@0`ZQ QY .w8u΋t2Yf$ADDfu
fIN30 (>
Et߃_qxu~{r&ha4/f^6r P$/<t<Irf&?E   ar$<<<f RVr
.| ^О`Ȏ؎&P " ta.{\f^tA@
sCV! ^P;Xu%&}0!R&E  D BGr.TQGT
aA (
  RӊP` qX Zu4totjkts^_-sRSps+7P-u#w` cЌWf_лO^uG71 ۣPm@8Ud0`.
 DBt0A\/fXu:.t5.
,u-P.D Xu!!NNr.
,.tU5]N<q@ˁ'WDAR9   S]P%w;ϋ%;7PV="a)ur͈?TWf<f<`rUwP2R#u߆< z@yxHC D4ZXv!"d_p_.|PpXt	1t8ʳo q d %!4op%pM  A= p`0jmyr+QBt"s	cu
< u	f3ЈuP[pt4)8ߑ@fZpQS2HD[#? rQ-Ys
 W1sf`DR.P^Z1{r$qC >0Rr.g u'*"X/t"`ZzaefuvVW[UjBQ Y s
 rЊ6.&;
QYs" tm_ \t_t	}pf tF$3f`0s%_sHf# 3v0Q@2MsuKHKPZRZ;sv 3`tN P```` t-wǾ`߯ rpÀ  !vsTsVwf~s
(s<@ t@ffRZXQ;v
t
 C
 7
( pu1@_ Z àQJu0CA#wWR ZsNpn .:@u0.> u("J?  YZ=}{rbQNs6-# $NbBYì pa @Ž;"Z0".q	fvf Z@Z1
  VQR3ɀ mYsKw01Ў +fP aêNuPluO!
Pf_@1SA/H r	3Z3
 ǾQ ,Qt*vzq1!Yp~ <Wf'vfQZq-rsGEBY3fW '%+'fR+fZqCt fNu&tGNu#3"_q`l`a pZuCt Q2YQ͐ Y_ 	 tus#c dbJ ul!(5G16ȡ  	

pV@orwf1@ud .^PPPPPPPP P!P$P%P(P)P,P-PS wf3_d0 ft3 B*&Z.qYb *PQRR?/ t& % ֊u#2Z0(S\[Z"Q`t;i2x2ۨ(%p7  1 4E@VpN 7
t-1P.ttPUtA^` O PQ?W$<uvqzZf^jRfZНtuU  u sEjtz s3 @	<wPXs ufV ^ !u*B9*
t5$0 oPSQ2c m %   Pw!rPSn2q F# !Pz S#;tt7`Ruu O˽ҖR`	7 t#Ju-* &Ϳt
&? df0)A4%f"0~*h=hZhqhzhhhAsþ h<ðFF3F 0).݊ iYAsC2k1*<P+KrR? 5@>B à032^@a hisiiiij7j
h2D<vP4S[t5fށE 6@6f^@-t,
<}a;ǁ  ,2s2u xI; s   þ/.p ȉN!lC]V(fS$o c Tf ;~f~ t7f<m)!\ff4AJf% ; F  aw<s	4ޣC Dt(K2Zb$K.蜱Z!Z蚱BYQ-00
Ű jjk0kjњ@ Wf_fVBE/fFP﫰pA@C3r0f« f ff+À fG
f  	4x!f#$01p8u2uAL4 kkr} 6SEн5
Z<_u
pr7`( !/ - ଶuRSP?:g[Zfk2qf \Y3ɶ];u>;F p(ؾ 5m𰵀삸@o ^V@te@Tl. jXRV.tuB	}r^Z`19 t4W_s)v!f&= u }  u &G
S`a`S[sc UKZ[sMrHDt
 u_6! 1&!l Zs	r03ҋ@ r`1ÁmmmFP6
paBw S.Qm[ 7TAt@r$? r jH8
r#) ^Xl$XV8t\0yvMz	0ztwAfP;brQ< t桶  >>3aAePMID x    2Intel(r) 82945GM Chipset Family Graphics Accelerated VGA BIOS 2 Corpoion#__Control0 Hardware VersP 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq 	ppYrrrrrlsqt	taxWmjhmko.<t.:u.TtOFûE2&+]pUuUWUES}AU !dnf&ofPwr0@Qv4v0?t/AW@w,ot2o s8 t>oDofYfY_uV f&E-  ߃A^mðC[Q 4\@Ύ޾oJ  dn rmuVO$K`шe  uڵ迍 ,Ad@ @@dp dwPЫ p puЊwfXـrf
t wrl@@ uf
  f2tmQRf0n<3ZY 

ϊYu9Ơrf
s,rRvFPSWĿ_[XF$:Iu6r	 @ 0޲vt
"u%uj^}# ͰLr
VÀ>IvmwdtYw@t$ ;wR?$;v@f1yٺ t@Øsssst$tFtR _p p ^s.$fbt*R@	ZP	8Xf _|p


@F wf f` /ta fI Btѝ a*/ $a+Sb6̀tE#y>tw1g& ~wft  )vGwAºBffP S BBL쐫T 
RVI3΋׺ P!0 v-8 t3ҿ
P%sZX2Qf;BQP藮fqU fYRDIwRI]:T@:TuZP=ۊ̃X&ETE
ff'
 f@.; fʶ Aڰ t &H_HKVk^0^eBHW
ea^Kz/^f
Y&E@(@R` c`-
~HK	02Й.XnȊ	ـ8u$?
3ÿ2IHڨu	0Ir
v.
 @$
c٨AVH.|^!77uf^PۊP%iXv.ħt"{'{.D@t  }V^r
 
2^û< <#t2 <"t
+ <!t  ЫUP=.<	كfp{X0u7
u.ʊ
ufP{q;psnS׋иO O }Of]Yˀ uo3faw*pMf3fr-uGE0/T0`uu t kudu^sY8s
tQG8s8s8t3 t-v&8swˊ
r*ˋc
ߊ㉗P8bu J NذrPÆ2ۅ!iR
tBi1P`!2$b&LNذH<v<v	r	e狕P鐡 쿉F ^cvr{otw%pvk&J`֋&OtʋsBuՃ%r' wP酓;u$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YupD0W ~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$&z  %2C3, B"pCR S w؎@
0]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r <G!M`sw r
XtӭàQqQ0QPc2GpB2E tO FS ƯPЎ،Ȏ 0u.2&>| t
Ò$ǿcK-0@ȱ\,ppRC&PD+(2֋6t
0su@a#sPb0} 2&<u'2ۭypWËU0t
Ju]+
]Q0 wL㋟Paz x`֋Y$Wr!v$$Āu?600Ql$$s$guzѫ[3*8*0*G^OFH,G`/$EѰ ˋ?*a)p2
y$6| 62u>
xĪm?í&0  &0%Ê)"ﻲr>!Mu0+,Y3,{+K'B2NĀu9@ZZVWѤ ts
̃_^GMu۸ ]3@ø&ҋ$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
ɽ,p&1  >ctGB
9r3>f߀  
?T @fR@
 F$
 Sr7u̊ PW.bnu>&}JpbQǪ_XwL4/r#Yts-" (&"%o
Ī&#Z
rɀ\s
uw7!~y@s
x`ALu1x  w
p$!! esX {@
ff

,	0	2ɸ,"yN6@	@	 (Pbr$$t<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [D0rp^ʊ3?ɸa~0
uVЊdЊPSQRaPaD=XaZWY[X|*v脼
܀ՈF0F02A?	HbgՇ܇<s<trt`t߆i0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 P&0y LOuËÀ8 0
1>ǀh  fnNË[Ɋ嫊Nuúq 2F π{?} Q ް.` KNu"f&K͉DSRP$?.&RP   [[c   XʊZ[PȊXHP?XP) ~~~~l|8 8| <<w<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DoD8p
~~~  Q  	 0`{`0A$BB$@p
V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @  <<f00}'0  || 8x~ |p <| <l }|ƀ |  ~H  a0!2  
x | ff|ff    bhoxhb `~ @~< p flxlf bf  ΀|`|Z|~Z<ql){  88l#<2 xp``x ; x -/0 U x|?v `` ġp~ 60x00x3v|x`lv 8 %1̀b P7P-| p| v | q$4-4 ll3
6|@[0d (܁1B 00 # v܄?&qp|8
̅
|!bf!&88 `x`:|~~ ~A΀)".a0%||`l``p9B~ ?pE

6ff+ 8<448ll8 60` BU6F \E1S6ll6W` l  "# U# wۑA 4T d  6 P [ a5 NOqP_U1UQ2d770-?d?0aa66R9 ja	D
 R>     tv Q@bC8~llHO3O rгg8 s 8||`qTXl( <"CBfa||=DPh"  l
~`l~ Y%r[&w p0joG<8p(5lty}Xl<p&Pl~0QEP<  cSld$DtUtZgZNTvT uW3>2xQ2)
xpbn|lƷl|}20 a4C֕BP{ |`Sl8>70k B sV &
񉅇Rg#Z8|||8鋊;ff""AR̓	+p+q`?llҒMv܃od  $5)/ԑ#|1DVsr  Pb
1u pb 2ES67
  ц%25R$F9B@S9byA1 	Q$(f  PC= '# 7%7@P@a"D"%
tÝ
0ld`6$6~~ $E47㠃#
l|8@s3OWƆpb#<,00PcRr-aLu;T 3'$D bZЦ`e  1d23]%`aB=`_ ְr;b9`5Qp$R"ëBfӬ`3*Pw~jRy Apotme,ۯk5̓O7h0xӰܠ`0H#H0i ! Ѕah  tC[D 0AxxAcl>j%Uڨ	%S Q#xF@W1hPr`xC0q C'7!1^@H(F/`1L!F<0[<\Qj0FespfS_dx0`ܶ{> lܬ>Қdw1D) ew) ) ut  (Yǳ x7ȥWU> ɈT 4 ^S̅d s͢Ͳ5Uc 	&
 JTӄK$%҇Kӧiso̓@"bR``0`0&"bc t"1آ1vetn v ||@<`p`v3  9tt !Kpܶܵ*$1R3Co0`
7| / % 4FU} '27Whu  -7tu #8 ]/䳔TJ}8	00 %7]i4 &4Eb 6‸ <Be aְ "8Fdv D0%Eu\fRU 閝\
@5c ե`&C` et %EWu % Em  'D~+NW B^]Ë
  1 
Met 4G= &tDftt0
"$ d#$%e2 34012hK"r5BVgv	! "f,`G'a wD 	8Fif. GeEt8Bm`lx -Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| oaή 	' 6!P"#$0v?蕜5þ&) ð 	!S P   轢1 0 a.2&6| &>~ o
*r
t	2.Mò`Ϲ     }! w<
u&| ϲ 2.^FFF3 `Pwq` e _Y X  * : aQYSظ s2t  [ø 
>ctÐ/    ^^ >Isu
^ t 36J2 Lc&̀>Iu	B$P
	JX̀v`
wp uHǲtQ @ rw
2F.hÊ.N$F $FF.q(  /ID^Ysn<w$u 4$
ձp À0&&_ÊQ	_@Z<w?m1A tSO[
!&Rq<w{#@tÂ u5Bcb? ȫFt#W!)#
 `08 u{ 3Ҵugtb(u]̊.-ŴQYR  
 8 t$8u
(
=
28u2Z aR23Z%t<vÊ>bSu
㋗PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=ƇP [
kZV k^^Yu{ZO[
<t<t<
t<
tx@(` t
t$0<0tur ߆͉N`u6s%&2Ft0 u*ш)~s&:s2&_ #   a     ? t"<(õ* II `ga!īI<v=	..tI<tE2<t?<r<v7<	r
<v/<v)W  WuCt	t`2ۊêSP胚@X[$t   ^$`Ip
P4
Ī3󫪀RQ$2.bnuZ&G&GtW  
 &_t%
ȯ&;G 
 2     @    fPQVJ fVf.Da 4藜f^^YfX< !!14f3nFF{fPfSL臙fa#fxff f gf%^ ;u@[`PSQRQmଊ輛YZY[Q Y@Yb7f^fp/Pf..7CCRR_t!Q̀膛YZ謙7t&pt&wG  x w  ] b螡2
3f n.VQ3&&Ϭ&I1󥿄󤿨_f P tQ | fYÀVFF30^XtJQF	 DYPRfW:0f "! д P ˼ f3A  s P `g[  O&u/ 8ys!pCF鼹* w 7A	 W 
  $ =ݽ	E
 G0}!3
1

f[X f_Z@* @QVVv^B*&5誘&&薘&^ &T@0RV0&$rF@&F~  PX@F2門۰ q5`^ZRDPNZ !u$ĀuhY7VĊ嫊Nu^8[pP8Rf<ZÐ5QfVQ7{f^Yjb6`6 5ñi Ñ35?}45745_\ %d5߉ce5o6d5QRrd3333333p3RV@3B3۾@3o^Z2#2YØ    8 4 0 < !! !!!!pQ!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @`               pƔ!!!!ߔ!! !!     #awqyyj>V>>8 Ҵ>, > >"A> >> >;>ǲ>>g0y>>B>0>$@> >>t>
v>jcf>M>O>C>8?/?SmQ쪁쪂"2Št$J7.~0$`{Pd  : *Ī!B2WcPCP@P @ PV1E"̑wX# M^ 
;A?jp3  -i	P	X^G׻}B.u0sǾ賋ñu6DxPt' opYy t	`mPx N ð  t%u7݈0f^f^ _ Sx[ p[ 	 $ADDIN30&.Of(M{AIM3bpmA  @ X@ Intel Corp. LVDS04Tp`Qf`5fPi..p.W rS..
 fft[
0jfw.>! v `P;b 0jfX 2ZY`2 p>bu .;pw.;rv
RWfVvTtOBf.G~0I u"u0R 5s}ZR5Zr
`
f^_fZ fV$< v9f͸fb #*}t ;s1 Io fq_S@i{#3LfVᡥ72k[S o@t 3ɐRWlt
_ZP.o${ Wc4J0_ `8$<u<.\.!r   PPjXfTAf`1 fa`@.&=
U8s....@  "TO  5E]O P6yf.d..\fS.f.f0 f[ttr= rw rL<&]ff	\..FG@0	3@  .GAu.h a {fVf.t2.f1uP@"d H0ZǏf^p\[a"4fu`ˀqP
	 ͫ!Gҳ5͑fZ0
FKSyˍ-`̢̧̘̿F	V  Ǒ ~F
FSDTY@ " HD|   I 	  
@  $ 6 d_   IL  LB 	 @ ,* "	UJz ,,UW[ 00?


s` Y,,6Md@X[l 
 
PА` q@Q@kQ] v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2`3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07>?7`
߰`;`*  ; `0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *8 1 )  @? 7@1`?*)   {2 )6{@2*)  `2@( 5  3``)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3 ?70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0?=H`)`' >H )@?XS(`$@#ta6@-@6-6 -,5,7@-,@ 7-@,4-8 .+@ 8 .+ @9@.@+3:`. +@3: *  @;.!2 '<. *@20 )  @= /@o)1! /10>@/{(@ @? /`61 1)/)1  `p< < + + 0* `"ê0*  1X (& @A _&06DPp  运t~ f%Ѥf= u/?XСPR@UWfu= w
}wv6fqWPЗA3tf
@@@$	eX*rQYRx_fYW<t< t
!cqRC"_T2. t.wf`7?01f&萇P/൤סrWRZ_1Sr3!f%?2S4t]@f
!afq /"`2f@2 t&2!@t fXf^襆q 
f蕆Ҏ[dtWeuVfvPVfD .8ttFfߥ ^Xq=v= vʺRpe fP`
ޠ')Fs-uBǒ*2"ɀ <  `0+ S[ ra
j  ! R b r "2B !Rz rU[  R g 
Bq  6%*
vV
 &
 #b 6~%*
  # @  #  !"&  $ Wظ z  e Vf z  dtWW`ƿ t@~!u-f.|  Wē_,PI4о`λι0" t t	uλ`S8pB u	[XدP0Q @fpQG @轃]^ u4163詃^_ع 0`T_ ^V PuUfRP|3r 考XQI/ UlfZ]ρ8t.L	n.O(C;{ Sal^>];f aafJ`H}taɂ"DZҳҋӑ~  ձ  f  g OOGoration Generic Device 12 A is0}BT@0f^t$( 'rX
@Slÿp
tlQW&]zrfS4~+f[r$
jY0}`  @  8WPX6
ߋ PSf NffYf t2QtY[Zϗ Pwavdy@aw{wuLff0^
Z[ZQV߾ҹ.t.9Tr.9\r	^Y 8	t&;Ew-&;]w'PP
Yr;r!p pQ s&}u,p Au% uZ !$F&}&Mw[X		t
e v$ &E
t&E&E&]QW  _Y Gf΄fZrV詊t

u:
;
T	Pg$XӉ7q~쟃_^`"
 uȰfuu ,	ơ$1<ppX Qi	rH&
`E@*R	
t.\τ*|~}fX~~pE0B  ()bc./1 204 7 8 :; !  ot	Bչ [ Nչ bչ  Tf2QRӹ0 r8r2 rqZY [pOR18uDto @fS? rt`Pу .6TWu.| u
!.;6Tr.D;u#ru)a ߻ 1fS[pr
2	]Ug -IPSQWCt#07rmt	t5SF#[ [{_ QVfS4}ft 'PSsE= s
? "2BRbr#3CcsdtWWUzV  #u	 
 fftF.afSVй-)F3lFffsf@  ff^P.u	4ryqff `-./^草sPfP*fXϊꊝsfx-OQK߃tyrs0 <̊("uXy|`f31%*r`f\ 7 _r   vr\`NN &] ]tR@   @ E  p f&	UaaPfof3ɕT42<	t#<tU<tQ<"tq<P g<<ۄ<<@t  7  Bf 1!7pP
t
lG
@@t^@@"fr     9 P f@ t3yTs1 D&U&]#QxXa4Vx	EW`r? pr1 r&蹓 Z_ڹ!opr2JX!#@.&Uos
H..&EVW03tNTOp"`EOu4W^VW6QH פ_^|&==@ P'Ja_.E.]&fR8Пf.U .r.&.$?.|^pA| .$ s-~ 2Ɋ
.;v.
f?r@D}|Bp$   fڹ/6rYѽP6  rCGt~ r3.8	w
	8 r.G.!.
4 ^3cc tEDM Q!bY&#E_r00!ff)rKtQqSgS1
S  Q P eGP uqkj Xlp X&]_X R6{.|t   &E @`lbQ.SӋ[rP@XfYޔfP' R~t` uuZYЍpPX< tPm z [pl 3RS[rYirO1rFd	r;Q1TmYu)΀t"tt
rfPfϋfXSQ t&` u7пr  tt@kr
a`POzr|.:uX  Jn~3t<`.D sfK0pՍf@sXp u0G  ( t;(88tLer=6'a Qc|Rt#b
  lȿcf1S esP}]Z1rRrJ23!r45tt蹗dsAZq0iYPY]YMY \ >!Rl ]>r@nE],SfR	~㖞f0~1
rwfPq 
RrBtu fw@d%@dp,@bmr!tPet<u #3ZfYt
!0# ڹҸ! 
 sr<RSڃ.[ZxcsPR$U4
ZXpb1u1٪u1u40َ$qϸqπ]p=P q8 ys^wYf(ofu rER.>f!P]rf;u,s
2Er w s!3rfF ô6ޠ`y  Qu>I@/UX]@ِG*j6TϡT`~ U}$3? GH z  R UT @    (<PVd
t?! .x8ty2
t[t	
N.
t5ffWSTGqӆ@5qX@Jp\@Total time for VGA POST:   Seconds 0.000 
 initialization < 10 Milli 
 `fUDmff.<@q.>Eoi.08|Du `Y_)T 11
3fI i0JDf]aPSVMC% t9ȋt,.@
.8tFF.L2t黀Vs^	
>
2.o䢊 :
es4Jew4<
|es t$f{#o53
Qes>P. u
 tX2pDtbBo2퐐A߀"
2ɳ?Dr`3fe.>,uye2 ߹6pt$.pc
fM:0Mef.If.+Ef% pHgegeve`R
&t ^QW¨	fπff.>6_s
h
hh 5  0@f`R4kpAgf.8A`teea
`+Uffp@f MmvI8ŁP<eQf+Xf-lfwffI sQ% fKYP.
]Xú#c&π `	 2!ĊRZ$`
s$.LA 26	tA
t*. 	23.  . úUeUuk&
έ8.2 e* ˿@    Y  | Pëm                                                                                                                                                                                                                                                                                                                                                                                          <     t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@byA   k   %  
C  q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGdESETARGЦo0U{MEwWRWRQ
/n]RQ	A^/WR 2Ds/1]WR	 	T T}  !!EOP
                                                                < lVW@Vσ ے   -$  rtˌ؎  v$.UfP.>A uWP.G f3._U.H@ I UO M N@EBC .]@    AXfX`fSRoP.Bϰug u_tT.Tﰊ$ t?$. 0r'pEpD ?4#r	
XZf[`M0Np PS tatCu?L7hY!tt-u$ظP hh zLPr 	uI_[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r׀?x   hP_ Γ	ruX0rPhBfP f"wCp'
 f.|!VQ6'禹6  Y^PSQfRVW0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0U   # q	t ja*u' 4,4 u.>. u{.8 t.9  g JPqG }} yrsng#c\X}QMF3B;	70,}%C
!S
 f`B* >(6.>0A6f.R6D.VffX QZ f / 
uf.R>r>^w)1  p Z P3r# v  z Ѐ~!f%#6 .,.>>_66
0 6.ffaJ f=)!f%@UPJR1f-pTf  K 0UP
.QX`0fZt
՞0T <f%'f
  TPV!	.Q~

.
..GPWS O^ 0 MSZ.&ZQ< .G_u
@_!YQJu)``KXQ!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr3$StA^`.u	DkQ
6˥d dTt	6ݥU  } 4~
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6>_^HPx zpfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ?  W68) <R 5se>uf_f RfY~p_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXgP E   F>@
>_  u
lr3- ߸w|HroQO
8rK<?^rDuqr)W.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G2e-YE.p"PG>q޶BHr
x6ta >|.s<u=0> <u  <u0Pvr).a>PN{ÀssDQ w?QB>@
 Q0s?^P2>BoNYѓJހJg&IҧM 9}rqWGJ@6TMr,	fNfOfAg&@ ?S2fffXPtw aBA@i f.;iw- AZ r%&Q0PPY tfG
>A_ r,f B2mWT)bd@ r@f؀ffFgfd# 
 .႐S3?a `t
.ffVzxv"  u 搈$P.$q_QnfU.E.9..Fn .:0G;5A1>5ŋf  t265 uu_uf0=/R@f]anQny90P:P;651.=Q[ fDJR迉 RQ T
T

 Z Z\$
fX Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0jAD?O2撰o6Ҙ2ҘӯPu@> Q1Q ؿf?tuPRP ү ntJfp˂a 6T WFOﰢPtƻO@X >TYYfPQUGPF >JMu
,2 [6  POX]0qUf ;]Qσ0ƾŞ@Gbؾff&f&  G>͞ f?G`GaQ6VfWf>Ҧ!f!Q С f!fD4$fOЬV 6ҦfTP ȡ  h0$Ph׳ X[õ 3@$<sAl r.ˠU_rO!϶` 觧A (tD_rq XPנ"Q!f_0ѣ!ES  gf /u
> up[PȰ&{  cB`&Xq!g= BxxwB 86{y͠͹@   #                                                                                                                                S .ľ2[S[W>  t> _`W} v	0EAC r3/_`?2St]AM][Q_Ϡ &
`T9P
PRw<w. [S-rġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫbar1TaP<u< <ups. .:.p .c>`2p .>b:P	d.ۢe> e,@p ˀu 8r fg[ø0
.a.&b΋p1p.mΎX@E2@g.*f v&.f&˸ Laap7*c.C3=`Α0b  ϊŴ* # PQW`
 _YXR.i
 Z k@@ZÆBBy PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.qu#rp t
ArZwG ZYS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
Qh=Yus33`8u" f`PhW @F F@ &} tC t;k0Tta30h &?&E| pظ@ P ^ X Wu-  apPfatQ@  YeQRW?.. w#&.!
tff..A_0Yu..nf.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.>Թ &_^Yy3	0		Q @~Y!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
*  >"Orf0f3ftY "++x fa

^E    1C< tN< XÀ ސTtu7A!Vٿu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
kNt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuuu0_U UUUJ V?cU!0W4#W)U%Xs'@Y#)Y+PT P G WIN @ڿBDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.)ܑۻ0IQjY f.>)R[ 8svp $hK 'Qv t7H485 26r SHzM ueaJ2  Uu~QK7e	$ <C EuۊAm"' ;}l  Xc3PQfR1[3 Bf>@Q AB CPµDހQ@mRSABC DpPOP R S c?[[ QSWP).X.܀O uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@߀
s b$ b ,o0 Pqܸ
 Y.l<?uf. &[u
f.&)R<[ ]Op^?pu18x f;tuG2p _1Sfa u<] Pɰ݃f   `4gB0^0t  t t˿ !Ѵrer ZfAA Ut?a	$`<`ut
*Bn5
u0
t		 uݮ
l. + ( @
ݐr.ݰ

잰ZE"R@rg r}0Md?ZrЂB BU
a" r"<07P w  "
 B$< w wuS0p@ "8t2TuNuF;J t_> @ u.Sutյ "1ֶ
 " hi.'u<η ˟                            H  |x KJII`BC8uĀuBJu*@u
Dgw0/JQL @tgB/AJsJ] 7
HĴJ!R:$ u#@G@6J B3tB  DECB1@CЭZNBDo r0`1	$ D[/m rPf j qbA$<+`mb+
cJ$<u	f  rPpc\~ B읱[ h:I:    P O O 	   hr@῀ h3rA6BȎ؎zЍ؋h3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` bi j b c a f    q6  p00h
`a;@;Wff . i?p
蕠 EߋϊfQff
fр aVWB,S@*(Ws;?_t[s)`)F[_^䁈aWf` f wsuۀp7fffGfYܖho S1Xfߊ$
)ff  A	S2o2+?Qr'!% uf 8s֊ҊʠXQ<RP
t0_r#YPY  uf 覾auTf|UPfPfXZ治+ ]f0*ff]rff^m`f#n {= srscB
Cb_ 1f^ ɉw @tr;x *f@Jkw  C)ѓuW6ѪȢ=+f;q%Nf fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL {^[YrfqXftA3PXQM} N{ O蛂PRA蹊` XPiWGU豐_PԀͻʡ A1е լ ]eX-pϋ_ݥP^Z`Wᐋ f} mp_p 0                                                                            fWjtj_ u
rP@u
df%  t 5u6ju f1fyZ~菅rܱ uSfc[*u;.>  u
	

 PnY@  
f`  %^ Pr. 
uK遠uw m@Ac	Y
XO .E;
u&fhFf ` f&| uP	0~tV &=UtKf MPThz; @Epl h `0m&ufރf&   \f^SUh &]S^ ]T&۷uD0D pV{& fȡ \AL
^ͲPrfWߋ&TVЎp&ǑxAft@ 2fʃP2^ P P&t_ 'f=4'+a¡f;mM0EP A}
P# Wf/.0	zg&G_q30r'Ru
Rff.odto]S?tQYzf*1fps,  !v@1f# ,3ң؍!%U
UEW &E"Q*r aD`hsÑ"'rnOGR0w|R0>q1P_@p@4~` $ '؎`1%@ 5!Ã<t/fQ`Y?< uM 
f߀u f ` Ct3xA05Ds;H5 )0<T
AE6Ef.gQ"q9R88$%;"#APh

f
n
	14R@;r('/uQ ">..;p - Df`KVQ$$@
 qB^{3J
ry9
lY^Hg5 ~U5-X5"6HeQKv fd h(QP0Dx-a>PVߣVWTVp
 KJLxJ HT
fS{tQؾdQWaS 4@ 4f0? S^ hVTTD?{,ffWfQ`WTZBS
`m ["Rcx!R`G2RWY G^Wԡ^]^^Lp]IL@_j,(]l]\.(V=&e	3o
T`TmDTp%uTgg1w:!0U	 h+`#XX+HXWw	g)!Z%l&#l`._W3n pDq[u_QthQnчnU
hnnxsR`vppyps|z= b-Yo,A
1$fpf[`oRR
RReAqJPSRbUriIbxbR r<.ftf|К* Z\~ `Ua  BuwZYggpA |ua`~O{݀    ' f `fHPD1 q] [#rf[4sf # R= tJ=`Y C灂f3fffX=tfX葲YfftN]fTCPAt7fS3 f[ p! #  &EtyrwPfVE$P 8@n6bg@^Xpz(ߝf^XfSPAB7XFa N V!~nw$f_  fXSf. "   Aff3Ҍfff f $EYPeS^ 		Wf0w f_<Af`


n2]
 u ]
!
fa`rfᷰ farO"f3f &  s`xR
Q[Zarf1fH!z?r0Mf	}f`34cru3.| tFV.D.ty< < t&CF^ t&_ CI
Z!3tpf0r|qIrp\   @ 藇TPQovPARP+zXZP <u
`ESQRs귄3ɺzv4ZY[@G.ߠ!
`0.!1a`:
u 	rF
r" s   =P 	Haf^K`@*ђ2$ԉNT@׎Ǎ~WF$
&FG &U_P
	 ѲbW  Q 2_R Z؀ˀ$0Z`p 녀tЀ ]Vع 6"f  T 쨀t D^_ 2r$<8R 
 I#d 虅p0f#f' \gtqRf.4 htffϴ                                                K _ 0P #ۿ>#&ܾ  B6#a ֍6»RRUFfaST"fV$
Ѐ
tfK`TTT"vTTT׺D% PffZ|V0k `<qRQ`Vf<0f p{pP	`_fЭ
,  P _
 P Q 0 ,Q   	
,p   _
T 
ڡ   # 
@p 
;# 	V	g&* t
F)
aJ
nE
   @
b	 	t@	4	  @Pe@ T     nP	
/	TU h @{q pZt	<

P
s

	
$AB^o @zT

B!o@ 	 ""  x  #O C?  D `;&*a3u &>*tXRs"R  Zt@ ZRu  Z ZɉY:}PP$p XP$ K ! ! X!{`0`}f1s}p-[f < fD   tRg&  
 g& g&GPg&GP a#  G[GQ40	@`   $B=f f ? C%'1PR-O$ tKO#Q

QfZSQ`VO@t } hnA -'-----
-.øJjUfQ ufVKjrMfXfu gf@ Nm V Fu(gfFffffMufY2Yf]Ë< 3R+fQSfVffLfTfDfL-jf^[fYrX`	A3PXføMjøNp OifSfR
WfP jNt3  fRfZj_f]fZ[PfWi$NtQ uUPXY ]Piк``YXt
 t$oNt tip `z`p  	hi`_gRfV_$pkZ fW l2VtԀw#t ^dr@#r	`o f^; QWV"/wy^_YwV3۬
Ê^S Fϑ e =  4 o01fffa.6@fff;w	rf;w% S./ "  POPOf%P[3c/aBRK@u$Lx pذ1K :0K= <r|`W`<3 Ӏ
ffʝ ff Cf-   sfQWЙ>893&G;r_SQ <%<^   AS	 Pt	t`QaÊfKO  f@Huʷ f@Sf4Z4f4f؁ P,fWP>tq r 	r
  u f_rñT^f$fS> tt,$
g&"Fg&
F J*$
g&#Fg&F	:`0Z#F	ZPv
0YVR	t#1
t.
t9t;tt&w
F&U @S_a~	t
t11tFt`
t~j`
k@
pqew
df
Tg i Ri3Rf]&^q\QUUt0] rD.q3]É33R44 45b555r3f% @ UCESlrs=!fpq 3 u1fqu%f#f  )	sLr`t s`_ u`a
ff#Ƌд f  rf SfRQ<t2f3Cr6
+f Єs*tTr( Zb_ uYhh ZEG70s43t?t
r2ȳ#i?R8-t(r!f1utA
JG?t:[R!4=?Z0Ccl8t , tu
@u$2(H	P)@t'@u *t{p(t
p!-  t>vs fASu0BArϲr3`
t@ g t}xuri/p/B/RZ/rGU/Z3tf@D$
Pd D,D$c D? ZVQ! 0fF3YPPS0DDD  ;n {D$DD2\DcDrD@= 

DDS	  w SfP4fXpG	 s[UߋaV~W   _ W
t<5t^u$br M߀f[rNp5QRV3P'à FKt
@ J8u^ZY}fVW< z-@uCE`Ў?D@t0	P0{  = s0ًw SQ R2<oY[$
oFf 
!$N8tSF %f% f`{ f t0  t"0 )  _xpRVps Z!
J
8
in0
$Qd4`SNff`4eA f04fafFDeP2 FP ^DP s fu}
@vfϐ3#"fǻF$F(F,10 fl$rrBr fv,v0hfN,-(X(@$иPN$ 0uf2N `*fFDl'f3}!51N xfր  /#f#fCJN0 fHfVPf#f@f+f;FLv FLfFPf)FqL%	}fzvAfI )#= ˸Bwf_*̀f`аfN
Xf%	G-\fA d!`
;Vt
kfA_Q
ĳ6"p+   f%0"ˉ6% ܟ p "D'F0KFҀ) p-q3 ; Pk`fff@ɳژ'PQRWSӶd?t" j
Lk[_0Si QW j߀@kO jkjb @
y 6u
 @ @Ü S8pZ J <PQ GT<`I0( ߧW%!GU! P11Nt)br(SF F8F??@P?D ? $@ *@0 Z@P  @a A& 7@ ]A zA	 A' A AQ BQ ]B nB @ B
 ߥBG @ 3C OC   P 	Y  a Hewlett-Packard 68YGU Ver. F.07 07/28/2006P@I }  Z  l~103C_5336AN  ~1a	rKBCsion XX.XX@
 /
  _ /	`AQ# `I{  A` U10 In?tel(R) { ufrnal L1 Cachea bi2e	
 `6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7Co
 KaS 
3`c
  DIMM #1o(28tVs,
0~V-!"RQa.Fs Pz0"+1V /No baty'$"p
(_: | C8BBaaDa$a@0FfFɷ͋N
~fE F N03 'ȷn ]
 cRQP~ jXܹ/FFYNZ1A`QȴY`Њ  aÇً:hD"ԃ uD & GD j.&UC'@'dQR Z
  c Z>@ 
G XYZð
< 
7 qR`yS r  `؋  t 9p茹  u!y
0w 	`ٴa@ ؀ `
UЋ؎ ]_a	p]3< t
AF `P C0[mq$9SRZ[` $<u 3 0ؾ   fa3S M} a > VQ3AAY^` 
aËPRQ3ɋfШ1QDRRAыf;v+R'TYX0GY|pfWgfǃ^G#Eg `H IܺAIvT2Jҿgf`KgƃKg u	f@w1 `f@f@f_gf1 gffgf0	fQ@;gg&fG౹7;0+f+Ƞ7g뀋gggfb	 #fgf&ǉ`
tU@P	3
gy
ff|0
gf3  P
@rΐ@
A
@ _ gfS̓ `awff#b ffyZ?'wf3f30n,;w6#4ܼbf[gf p2
ffP	c	

fAȁAXA?P
 #W!fكs À +SfVQp g46fFCYQ  Y`f^\ g&GCffT@[fVfWfS R
2WfZp[^b@R
uZcf;tf`Ȁ us*1p t-r(@tG<u uŰ faUQ	UdF @ E] S
<t `Y]p4wbfv2q ^~R ɓz<1jyr2 	{ tt -  t	~  iR9`K߳r=s +T"#@Dp! @80,Nff3u
0L t"P!" aXg ?fF ""AXt$m@Tfof@U^3c&Q5fPQ2XYр)Ya'уЎp]u8	f<tY< u#f!"faÀu0EuPPu!uZMPPE EPP runtime BIOS -1.1  MMMMhNNNNN(OMOvOOOOOOOOwU .tM]RM.nx!.n {!r !R.n
ZpQRB!P0<rt2[5$ !<
 o -" ZY5	$ p[		uR xuσR \ SUUƮ] .V	`&^CwO CWQf	al _Z T
 J: U PSR<r
 j ?G 
tP ).>O  .sO 
   Q3쨀uAB$ԡ 3PHP]SIMPLOMOTOROLAԢVP҈VwSp~;HB߸ Ps˻0]5G >BP>BG B﷡> B5B,@B#SR &3-&Z[>BB߷B߷ &
@<P+؋ÒcB B賰B﷧@BB`B㏍@&3&M<S:Mt6TP 6f 
6B^VOCRE*>쪐  ڪ@ȥjC- CCa@	CX	CO`

CF
Cڰ=C4fCCA+ 
r)>B&~
X 1    x P  X@ Y h i j@klm n@o  @ @	 
@
 @ϛ Р              /S M 0HffU.%Uf.#UXø 8 -\+t b<f0[}Sf1pTfRVWST OuTTy @2fu_^XQ߁uzN&l@YQf.S?Y 
WSf.WSF	fAf tf:2fu006BW8 S0Aø@i &gЪ  ?pa 0
fN@  ]ϰ2q oPpS\8&{0&G &G&ƷGP    [ _!@   栊ա@@\&\p F0 ]
q..NV3 ( иp  2P
C@@ XWP<w3t*p O $ ! & X _$@P $X^2$$31    w R۳4!ffu!fQ详fYg	[.<Ȏ3]Ou r 2?fPS=Au@u;Áp u39 u+ f?wufP@u  /Xu
_ff< t%r{A_X{Nq|S{[_ V@Q  iW{{ ZV{6V !q: {P q{q{Q   A*{ZA3ɍ6.L.:Ls&3ۿW.DO.LP^` 2`r2 { 2~P u KC^t
 3t t
t
u!  "U3ұ u | t>-.} .D u} P JS1uLC1   u3puv`bW_tURmQRUPK2YZ6	u>^
 .D t+ t#VL^~.L ]ÅQ3p1 |pYs1 u&	 t 	&UuxĚ" Ǎ>^ |  Êö {..| 
.|!߿^\Zh	!ךtjZлW 3ۍ"_@P3Xú0 _SQRW%,  .s 8 0f_#ffg&'f   gL gL_ZYqifPRb fZPk`$<t}'#<tN c  t T M_ Hް<u 5  %~l  
 aS  K#L[SQVW3oxu@   	u1@ jK K_^Y[+WV j1 Sa KX#kK^O_Y[X 	S$	ppquJ:à{`wuZRW H $tu`$jr@ s	t   \J>$
0	$PnP!`^ ^ ^ s fPff  @ fXtfUfp `PVfg]?rdxf_fBfXà]ge333rVd4Ad^;sguw` 
n js M tAt<VmrdDg}
^` VWd_^gEdTg}

}gE `tr	 	t}d8tW<yt@D+`PfUf]3
tO Pau Ó' x.;Gt -._
u  	fg6$+' +kavaama  A " * Gxx  x y 1? " *
x"x 0 %  s w_X _y\[8y y `b ~1:
MËEtذE
U ŀ
 r0 t
r Àxf`QSi2W &  '&E3ҀtB&U
&]@ &E p ûau[ E@ !fa*578F'()+3457V
t À" v5ppw
&  `
x_t^t`t\w7utF5R3< v
<ar5<{s1$PɎOb Xu2#ôr2հѾ
=rVsu\} "9H2.' uqq ް0$!u@t<az<zt, ottt
w
aE2@q|<6]-q(	G\2A)Pā Vbpt"гr r	<zw2vPQs	} 3	[EÆPȼ[fZ@|}~ z 2~h; hd W1qVqs[wsz/ 5esM
Ut<AВ .D4.D
u  `` e&&~paø0߼ UfZ` j &&E }3Լ{}OQPTP !XYu`.\.T .L` `'a`%aQPƌМPR怺NZXX.6w/ZaQk$!ldN?blP@mfdH~fm?dF~mpnmdMd5k_J V>dN?d<d;]t td|d]?^  R 3
' '迿 FǠ  F/uf3 .;v+GuBG
`F/ˋ {@`V%	pXvNuQ
 	0 NY%u'
r012PO6789ABCDEFS qۻQg׆S3.:Qgt	Àr2ۊ[2U uP``Xd9]<t r
-Qd8D^u`M2xxs T^u$0`|0&
yt,ـt&M1&G&a`yՇLAAA[a+Íu 2@t
 ۊQ ܈$FKuðWQ`
u	ۍY;Y_]uS؀uptRu)G4  Ρ3зPS0
BJ<Zu$ u !N vt `aqt$t$UNN<Uu$ {OyN#ط$0<:r uꝀĜ߆P PЄM  A ڜfr A) "QfVw: (fPgfFf^YpPRt 	t	tv
 vt	Ȏ؎ Ѝ؋hvj3 WfVSQf  VF! %s^(2۹  ptF  +^D!8u3̴^P!WVQCuKvE3 `!0 w $I^:u:\!u rm`[_0< tG  )M
ñ F@rP
ˇ
K b
"d
d
9$
r	S@-k.CذÀ,@u[û@ 2p n_ l C  Ơ@#  Ȱ2Ҩtð
 =,pp$zt3ø
 а	2s s	2  | wp i	 bM{2R2 	KÀ5 tN :41*#
$>
$0 B$2
ll.lblllmXmshhhhп 0@P "U-RG      *[%~a	  ` `  Gd d ",1  qa aO 
p  Gwr rrs sq\]
s"  
 6r`		T 
2
  ` u #PC[ $t$?ath@ & r 3u.n3s' $ ] xLpI<u	.n u<?   2$\   tu0vu	V $
4 }hS~0@ u7d<wu `[S`fVPfWOeN-O@$msc#j+qppp  M} G2p" **a&00qs|!@AbcUޒ] U0"}2j]ãJRQ%ߊ̺ Y U  !Z yq! u(<sW .q_.趹 P'XsQːu..&߶+.	p`@ t^P_.&궠u @ u42..
t wjPUU* *Ġ&u XY0iP A3.G
XP6 *.#rPWЃ
_ s%sMsssssssssssssVS3.:ru.r_K`"@[^* UFPs2SF۹ S.rF[C3N[QF ?trsF?2~`"ð7k$ `  _ ø8L$ j|d{c|`d wgKAG|`0@| 3`Պ$  $ätttttttu`d$!o<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233ptf>"  tA" P ap( Ҋp ) ǊȊ&)  * 븊[* >+#1 d>,;0.- &) r..PR ut;6X6 6 I~3
t,=

"=
 
0I5w<ot<qFp? t<a0 0s
Ê& 
<uaw\wWQIu& I` u҈I`!AI &
.詑Y6 FF;ސt2vvv7vSa\"c` \0ba3ac]aR];D]EPG m]@`[\!\i\\\+t\ I|\lZ[ ZZ g}
3gE
t"6DS`  [g@0EsU I2?ѽ 
$&&Ec&E
WE   F˽	>]>
_  4_ _   ]gpgQ    U	 Y
 g g`gABC  eP fQ gR  6fS gT  :fU >fV BfWXYAZ[\1]^	4w` ?wa pwb wc wd!eqf ]nnnmmn(nmls`Mvf |E{ `$
&afaRМওtp$typ{ ȋZ@ã1)u M-C# #3$fQfPfRPWfv ff+fQ 0f׸@Yrf2Ѳf_f^fZfXfYf>u^f sUˡ
f6 eu6̡ ; u0ˡtfr> t YQSWfSrf[QSWfp/ r)v!ufPs -fXtā_[Sf<t;f3f t	f -p
utǳf> |f`
 3裴 PӘ fXu  kVx 拔 tcPtt>@ KXSB$x$PcXr$6Qu!$
BB JJq4HX^ZY[# |@" i  p$ q }Г 3ҴP./@32ƀnuo n Xp'Êۄp恰uﴀô í S3ێۻr?4@ϰPt W }fV1_QuXzuTf`0D +fft;  Qf3+Y,65 !++ ӓ+`D ÐɆt w ZYJGBl<t&<t"$@AJ,_BQBSWQ  *0toуY_0^   _SM_ Pc_DMI_ P?  $G#HP  _$ 
 r
R3҄  tZP3Ҏ¿x ȫXR?Z                    <=# O>s  0/%  =p))bhy{?jAC  ꄃD
 uj@ t%v v t ArMvGsN-f-&A F'N- č6a Yۋ!P 8r 	
F (| r
f	u^'Ât %Ͻ0	1*5036r0/5jr,r[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>.u.
I.
MA.}tj@&u |t
  ^!N%V#~FPS2 r2<{ss6< s
	OtE""Lt*$Ot"#O`%>" 2!)A
 ؀	.EF2	
r]s@ٱsߴ1I9  <$u2 *<}#"< u<@v<%p!2 ÆUu
F!UF% ^F~&=r&}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [ZsSQtP^Ë^6m轹Aؠri	DE&Q~R~(LuWM߃smfPf}ǀfXr4>-E. .GTώ^ U./F3V#:Ttt<~'t9r0EE&D<DD@ % 5wP$~@6- 6u0S&Mf.@f&]f&}20
[Q
`'QK  @ N1F { "Krxtn/+rTO u&~ (u	RťmZ<VƎދR败oZ^'pqtfR mZsKruLr YKP8r$gKrJrW =Krx5KP_p
u  r@!w
u 0!мRWBt:ـ?f.Epff׷fAUffs /GMF F
tSuNff3f fV-f.WP*f8f'w*f'F'*2*f
VvfVv5_pFsQU n E]YRPXtUW:>YM_]s=r  "qPRM2蔣茣BŻ`  ğzZX`Pً `jR蹣!`~Bx[@( S^=IVQPk|% HՔ)N0 Z^N}:IrttR:Z&Ir`a r[sz_">iK0j}c, V5<s--O8L<P" >G< T#<T$@  hP
P藢p_ kf   x}P GqE,yHrzH vNgHrh!uP<ph&RZZعNA -Hr.Ǵt%ttt t	?tM% sunGrG	 27PSRp^ZrF sH<t<)t<(u;ё>A u/WU>{ J]_3Gr0tGC~`,P^a| -(PSR 2ZPfFtN+@."Xq;G	oF
+#N֠M렡M
%J JF
t
RǠ1'WX~ t=y~^f~^^~;^~FF
!CFFFpIQ
tW 8vNH؈^~nNfnNfNnfNn"~*Ċ^
^IfYSQ0PfPv j 8rC"sfZRfXfFf@HFᦈVv~P 耱fXr+t@U}T3Kp' tf~f   `Wf+ MY`Lu$FΎr2Dt
.].?^K fF! PX`K t<"u<"trV3޾x 4|Q&?s@2  s& p  &G` ` G 㴀` &O &O{R ef&G ee j A@Wf ag V Wf- _X 9PVQVW!:W јtNAu!u .Q6 u/ˠ ࿀?	
 t,6@QoAOGA&&d&D&t&Dc`_^YXV=} " uRPD
 G ^ 7n% ݛ ʏ@7rURfQvV ufɻu0/xQ=fA<  1 0Q !ϱ n  "Ƀ.V sfYZ],Tf;|P,sf;fZð-Wf!rf۩rf+ʠf`|r
A0& r#|s
wua

<AEGM	rrBP9XPr P8p$SOs[OBMIRE{/q
JxOLpߢf[fufXE)t fat/+f %#fSfQf3<vJf!ʢ2"QuʨUat?j$7 3#tcQ!P^0
ð- PUwľ\WVPt@ fSP~WB Q ߪY_W^9lU!t6]V! <5uTG	F^B^}=WE.
<5 ] 
uԥ>ַr Xf[2P觿X^Y#WfVf`yt
P EOr&< u P B f^b$Yô PjXs7 ## 1$"$艠$P)
u ${l C'ð) h1U
 @O 3O$
5OEO O _O$ O$Oks)B%kA3+0\tq	= 
S1'YðoQ3)@+3 ð&tF!{  * EPQS&"
ǆ[ <t<!t
<}P	<*R

	`3Z Gs`-۵P kjt 
 ) 7VPvS<û	 n[r!pX2PF^a ð!@W萠 R)VfWA< u؃ tu*r
D@F- Kk^3|
u|	 _t0 p$ <q<
z^ÀY" Ve ؊p% L"؋ LL*ZðR0Pp031XaQXPw2b+ ߉ R[|qѫʁCl0\
P'2<0pø1:ċðWb4Kщ	Riq@ RB*pZQr"S6b+B:UT,ҀY:" V/Z"<.WU=*1> 141o6k4_U6U"P	}s
 7AB67c-R3 c!' t8tD
S̔[2P}B;ÜfUfPPfXZ+ f]1ɋfŝf]rPmn跐 $PMM Naw   A f3{߿$f
0f @RWS22fr Pcu 8s܊[_@W@
t)Sr f  u 8ufXZ_1[ r0Q3r: 胿t+ax4 v gP|8t	
uYò_SYSID_  q _UU+ ě rcs^f&D
V W&DdH  
B r!Pr7uF. P|vze$grQVsL^ːM frYr
rh {nZ
 
FFt} NoF"pB@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F) XЎ r4F$
F ^+ F} P   ![V:V@"@aWPR0u	ZX_A(t0 м  G".>ʡ t@ ؋r d@t4t p掊29,P  XPUv F t	F !Ff ]X"X
PS0~4~[CSQ2NFw PFY`uWt=u2
fߊe߃f߰e߀20v qFa VRtxSR ڊZ[  Z[K  {u? EȠt%ؿJ s0
 dZ^`/u=u8qB 
ً@DEp =E24 -E0URu<脃u7wG@)DDotڱ

q}PGb]U 
 s ]`K:\KxSQ3ɰYM M>rQ4Ys]\ P 3Z[x0"ݻ`"χP3
ݸ UCٸG CS QL QK S
 pN qM C
ÏCd'Caa.x~%mf3gf&ff=SCAFtV1G}"ffff Wuf(#30fPffXs_32_    |Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 V|s_}|789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+Pj
 GHIKMOPQRSfl f@f= 3p fl %	*P' @TO xOy er$DIsL 4J34 '   җSQuP @$@Xu=@@@@@Xnz@$@Qtu
vR=
ERVW 1.1Vp cQ<V V<WU? !оT `,aofP > f 6s >up_f2>škf @Jf 0šdOfŒ .ɡ>ɡ u /R+quY>̡t`a?ر ~?a@[W_^Z N aY[QWVV_ ؾ ^_YÌȎ>ۿ?S r@"@u 
?ސ3r@&[UR  r.@@Y]&&ya /  &a!t&3ߟ&	!J@BФK J(|ۓ+P7A`Kߔ\	&GeQY[UFfoB	&.&D	&S7ɖ;E&#UwfWP5sA<ft~,u#肘x~胘p ^\2fPU< u
 	<! F ]SQW  9=<w&< t'V3ɊȈCF`#=  ^0  \_$SQRVV<v^. " e <B<^Z (U2"4""]<EUQP Xs.V Ouj,]A p|! g g ArƓ_jjơ` ͡ލQ3k"{ڿ!%AkQXr2t"S">*PQ ; ;;;["2"Yz .633@f <` ~< u< l<c<%Z<	0 ;Q<
~ QH<P!i?<!6<
p"-P= uX<~#<P$<p$XL]WfPCI M?u_f[St$f"r[ f;ttN紃 f[_^qCff r} ;u
N`>o>uL`> s߃J 2fSȝf[yff\X׊F9W5	fP"sm s t; QVW&= & s &EfX O _^Y2?WPw`;t
X2 *W 
`<_ ϰ#t/OX 0jiNp sRQ[uf0qff0K@Мff P8s2fYZ
(<Pd5bKPށ&` XW<_r# .{_pwt 
' t 0$r
@@w[e bvu0^r!<u	rr&u_ Bxs" r2.t2& rA~Ys  r@^ 9q	8 r 	&& rr	ô #Ss+&' @>'  sa$ #sQ
u>[ W r%p$S r rq	9_ f" $ pQ@	Pm CXA#t sQ@t,Radto` bpt t
@uYÜP`
 LCXr`QPPPtQXdYwQPQ0 t	3`0Xd$!<!tQQ/Q  q&@tPGy S ػ@@f.DحO<.Df`puhf; g]1\j2aúB  $Ü.Dύ+ݯ *qݰ "Ns@PmFF
]X `j . j v
B:-Mf.N. 	tI F ~r p3؊^)@Qw t&Du .⭋^^ta.@t&.^2ڀ36t6^2.p @ PSFg
t'.:t	tX._[Jg }i &  @
̰d@#a PSR,غ:3%  Zr-s(N@rtH rr
FpsvFr:s5&DC H P>rZxJNFÉF(t S^$:u [r
F&F$+%&=vHH&
D0&d̠u rc诽u
	A	Ϡt&DѿB êĪǪ AkHAi@
`P rpU`^b`osu fD
E$E F &G q
V yN~tr>u rG D}ykA3F) _ar\RDQwZr=H r8 Sss#T
P
r
S~請@Ho $ $AR $VF(`r#!#rr2p!< '!r #!F( '&d&Kp#V&Ơf)&t N.`RD WfX E QRfl f@f=  uf3p fl >@  t@&?   ZYRظt"
p  ௨u$! !߀t&k Xws'` piу!  W%ao 1	aI X @F$$<r$:u s
q#t'ew 
   @(Hw  $tV̳rF.^ࠍ 4uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F u(@$3'E&f$`
ĢF f%U$PG >B(IJq4cv@fF" PXۋN8NwN 7RvoZ2NIIIrQ vIß:vmZIr ru`չuAFuuDI洀Ib2./5/ ^ &u ftg# r Fuw VQB AB %uBY^rK `&s
3
'u3` 菜H
%uètàt  A: ;V&T tup 
* &u^ô 0ߎQPXuN%&:Lr , r&"T[t r@u0<utGS.@ BD ? R 14pGt$<@t/414sN !$!ss$$á]jp``spBss5GxsùFaisG<Pn  h                                                                  i S A  k  AO IYOO rXvPF X ꤷ	˸ f&q Ļ&ʻ&̻ f"꾼  и绋P ff .pf.np >` 6a  !րһ.P λf.U""""U" ! a
#
 
 f3ۻgf+ʻС  2 t`<u @& M!@tA AuqP臾p  ,y & Xe߁ ?`Odr
 P<Fu uo4s	 	߀uA
 t
u	 X RtGTu`6FtEud1r_RtZxVr & ?Rl ZKu3Cu
h; $Duoh h 
XuhbX& U au@ Ϫrt01
2rE1r
4rr4r4 d P dXPЍ$& 8t `  QX uSQ^ `2?`ݰ`*C: E8>1Y @@XQ>dY WVS@.GF< u^_PSQR׺srD.\ZY[XSRA׊Z[p o̱װQRR źZR  okq|R8AS؀u
RRp	[@ P:XE%
cE%	X< $'ZT
 
"
t` VWt_wZwU
uQ6rEt> r2
tC rͲ  r
!  _^aA#2
u[rVei1sCr"tS ';Wr6"Qr
Erߪ? ;r)/Te  
 ` 넸    tK\	\*P')0\;#$ ?rIW(  kT0_!ƻ@(B O55B< t:0@@r}4;3r!-q ,-BF3ɰDz@DBGȳʠDGcADw*VR rރ| 拴  t.Z^8ħP .;BBBX$JJ2J¿BpLPܰ t
豷tJ 詷Xu)` Gr V tA&q JZ  C@A u*uP= ]Xruŀ̀2	PT
 % (8SQ2<

2ۆ.
$=2rۆqd@Z<w0
u@ð  ` 0      j0RW*׿Oз\r 2 H8(3_acRWQ,ԴA(sF + SY =o3x73IiRQWSP b	$d.d pX Qdt7Yw| ac sX SQ2cY	uB7X/2 V_ RcmZ #
l 	P
PcX~C[_YZ!UDc2jc<Uuj,\c6TY*JcBc00cB	 cBob b_rQ!ua!`P@
g6b؎"
 !
"X"S@
u	趋   *ê?{`@XVWQP Dt!WQ:t
Tu8v
Y_`OY_XY_^fRf@,XfZ. T| p;`34$=Uu &?t+aÍ>.}
tp 	
t>a .:Uǀ	 V tMR"Z|p  u$$<t} t	^^ Q | Ys3䆊 u*Vh -| ^t
o O)WPcs)t!虴RRu3ێێZ
ta, u
u
 {u搉@s+XPt Hj1[zz覱@9"Ĩ@t  p 
 `Ҡ XPJXwSP290+. s#. sXPc&  &X[ç]' 7S uJ̤# ݋Y	r(D
@ vAr@HvA.sNfj@&t FN  R3VZr#0)Mu 6ar pt `reĠ	 u v tr&@&E0nr"r20Rs Æ 7
FUFFÖ
 9-qp
 /B
 ޲g@e{(
 ߘpk^F&?s s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPE]EabgVfQSWf[fyfY^f& u#f&GP Wf⺁   4?WfZfXP'F#~r 0Su7 u/sr?`.08.> t0o  2KrVޠHtpFsm`, V 䜀~t$` t u/~ǉ~ %"NV 1	s^6- Uu^]+RfZL..`	ZZaaCWQS-ن? t0]u.:Mw#.;]	w.:uwPw.;w	@w[Y_o @ o>ـ? 
 r.uH|
_!Ѐ ʋ.E:v mfV{fv0%dD @؊̿f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfU쿉v]f^`PZBw{` u wo icZZXR`PZXuUW:>_]sFr  b[Z$<`1 r#PGZ@Xu>{k T&Z$@<@PY Z>sXXty>C+ TY, b
{
 V  PRY
!X> PYYs'`߻ +׃Ѡ! <%arop p` %`0arSHmIrcr^t:DvL*D ݱ p u	RX@
RXfmZ@?
б rRXlZ ɜ2tp1
 VW
 _^ q _u
&:Ev&M
&*E
b
CXo
8
o
urQ
"XnZrAW@uq``rJ r
tHr(tu"]WZQr r2*-iWXt4B u0@uu`  u2#3fPS *~ ͰQ/[fИSpsq0D
>P`MD<^Ƌ.a`t;* a?jVs߿P!$!"A?bV3@PQȻbJr#@cMwq_'t sq2:Tt
 YXÀuOua9=GU   <s& ? 0_pG3 >}uǀ   Ǆ  VWi<ua<
uuP H<u>逿u0x2<t.$S!k4[|u|
v|`Azt\_^F3] u< .A̟q܀}u}	a`gg@uDa-gP%'0QV 3P+^YD&vރfAff?ffJf mt
rj@%f F PXifP~ġ=r0&w)Ef0{u f u+Cu~A 6SVtPSsttnPt23^[PfQ
 ǚ <  !@ f	t` vaif`ff` {B fHff#f+ f;w߀fgP3g&Sg&c
uff+f뷾faf@7SRӅhRr=??$j0Ef!pkffXRRpEZ)RssrmuZr
w0V2=PXZ[aJ *`Se[PS3e[
uddX eaSQRsɄ3ɺ誾r7!ZY3XpfPAMS  BQY_  O   u
  
1 	˻ʆ rrɍvF0 & O 
 30&OˁIFUWn赌_]v
 ` ݴ_^w 1
?p 0 MB RWe
$? D >&= @
x?&FGvu?v ?p cu#' @ Ŀ@&` 
;uAa@Af3ɐ t1uBB&w 3߆_ZGF< u  u2D@ nsN~ t
SE#[ôfQW@Sph ff8h6` f   H  v$p`f@pf
p߀fārMf[0#t5 > 0`f% ;tf ff  ffX2f~ _fYQ.躠t} 蝹}@ !.!QSW!  ht _[f  DLfmY̪ ɤ f V s M r9*E4fff1 Of ?fYRfxp`Júf 5Z`8MXf `d d@u!
f<"~OfA%Q#ef%p
  &|Dp BC'_B3E @10*9,} f`f!mftpT" QBY ffhfaQfRWf{fw 3ffXtf wOu_fZYWryaOtp@O@g Oc+O& KL G B = 8 3 . ) $     p? !z_ð
& GY'諶!B dðd  賶13ofy    ɿyɐ1 f64Of.؎.p .$v/ P% {P1 ? fñxfX!yA{O0FȀɿ  ffaSfWfVfu=szӷft3f^f_fxLyI
a+ :}5}A(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.a@ AMB C 0&"g]\^ t^g}
3^\gE
詇 u\^ 3    SQ>^u5Mô0% r!<蔶o3ɸ¸ ? 3_RVC\&^D\Xg蝶gztt#袓 >=r^<t<tkƝ {!3^Z"JV"`Ru P	r
-oøZеQQ =rc
ut[^^^2i[shhhh  A	  " y y y kyuaa XXZXp! /obPRNZX  Ü= sr_s
0{ _ SQwt,.2}A ! !$諐  Qj~Qb;APQN ̸ K  sh' G y  P" Eu t
$跃rl`tW   d_a@    ]Q@QJp	B  lFpoypOIEMAG  IZ P   	 
 `# HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Intnl  PCI-Kq B C  % eO  ֨ H	~P 	/` <M ` c!F	  ?CD001EL TORITO SPECIFICATION b`Lg &/(vu (脉$
bô$X GnN@hRVМWt
J$t v^Zf` u'Q._u $M$wfa"=}@02ߵI%I   6     G  "JJP3@;b ZPk貰X4@ajлP``   R pfˎۍI:ufW	qrf+|Az.uOGfp}g&$f߿D  0? 02ۨu<@tĀut.ႯG˰Qf_[p^<
t1  fV@ ބut u3N@f6 Vu^ u쌞P@N`R\p Sh%tE  匀u藌t!όv
pj @w
]]f^hh  	`h |!  pVrG$ $  GN N P5 Gh Gt1$  @G   
G w  $ U   0    %r 41PN긿  Mv&Qa {W.}
u.:tL u% t>JrS-.[t D.[u t	t_M_8EfUv"v t Ar Mw ű.V PXF
Xf]h@ &A ϴ2j@݊!
t0 ruoqk
	RV.6/" .t.I.
Lj@s&  |0u 
^SV#؁D.d.$д^[	ã3j0rcOt` 	OtOtLtDt
tt徜

1u	Q.<Q.}h $ B(ÁUu	/U qkR#prp
fL\Zf ɹfP<r|wofDu
 u SQVWUP؎&Br& ȎX,>Ϝ齨 ..?>齮@qu Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^&?swa s@rQ`b 
 of`GE !EA߿ff@Q SRWP0޲ rvşE<u<  8LuU@<sfQAM}3 fYr2>-2E.ًEGώ^ iO./8<[ÜWO_Z[QWV.>u5tG Fr=(}O.EP .&D>a@A%50uNPAٍَ6- D^_YSRt5ێËyS.&Gf.@f&_f&_P. Y2P)ZqfUf%DTRSߍf]PsfPS^^w&t` $ueG&uFtt@]û( UT`b u!pXuO  <2{f]
 N] d `d^PQ3 _7y4@rdr
` r`f<0ϊ$W _T*u	E 
yjt)߀ut&  .5& A)u&u#
u! Àe8W@p13 AU RtY pvMuG	0bum< u3uOQ qu1 tWa0> RtS:u@Fr8*6Rw:EFu RE0 } XQQtTt̀t߀wEtL71F -t)> t":& t߀SuпEP$<X/3`C t	 E>I@q u	PXu᷆ tVqX랓t#%yREQ utQC0c)	'r!q =p
3p +x3;r.Dv+W+Xu43۰2c*u!.ð-# *q!	 2y<Gr<Svƀ Ê,G.#$]r%J u3%
<.r "Lu?2C4 %.p2K#0ʠrP)<.t<+u
0 uθN<- " uJ,0r& 
5;6 e11B   EA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xception 4 - Overflow!5Bounds Check6@Invalid Opcode7 Device Not AvailakblJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12AtOack V
3General otecb	Errorq  1 =  System Ha!Pst
XÜPRrt< yyZ@fR]6_Fup/vP	ύ6{艐fÍ6x 6nfX[b ō6X`6O0Ǎ6`ȋ1XY_WQP6߳2Q)Q p66_F
0-tҠI]&g_v`}lp	ie_ UIBI ?`Ғ60,X[Sm6 p@ ء 鐄* UX.:f t_JYu_ .f] $PIR M A&` Yi j b c5 a    hq6p00h
`3. W Op
_ϊͻ 
p aVWS;t@t[ 
[_^RW3`  Ql t`GYh </$_Z!  37.߈ X`P
Xu!P<Xu @Pta`
  Po@sa~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp	~	 0``0++$ff$,
-0xx00 0 wlllb.ll  l 0|x0f 8l8vv `` 20```0 @    f<<f0 0  || 0p0  x8`̃ <l 8`p  x@ O|pH `a@
 
|x  ff|ff ll bhxhb `f> @py x p
pflxlf bf  ΀ 8l/l8` xxp$ x0  Px ƌ2 xp``x  xa"x -7M0Mx|k`` p 8l`0
Pv!o`lvf0 ox  `9b  P8  ! vf' ?0|004-!8)*`2
6 	p&0d 000001B  0 v
\˱u9f SvN.gm2[]Q
! YQ 8  ` PRS%` +ð ;w[ZXfcAAa TkAAE eMA9Y.nSS<  At( 3
`3Ҵqu N <tD~QYR"~r8r~r
2:6 v~Z aP 2XPCI01 ISA t%-G YU03COMPAQꊙ 07/28/06  \ ԍ    F10_  Bi؎ ^ Ћ<V ^+3f  h L!$F10fPfSfQfRfVfWUfUCES>Y  fB  fZY   tY  t MstpU@p o@t-P u@d@`tڰ 	f  f   tf`   t
^Q @@  AfZf\( 3uq 6l[< tf3
@Z>l[0 Z j]>Z;\ `\f3A3"P1t
 }   2 1@&b@`a@f >r tf` f  tQEpYV ^ GP
]f_f^fZfYf[fX[fVP#3!>\ t
"y	BC$su%&\fXf^PVW 3W 
V_t
r
>Z_^X \ɰ۾ݷرκʮϵܧ12D_D(|1 8     y:0  ``<~ "!AC=>=  r> @'Yar?  @@@?A@ &cD$	-E	I!!
0T!-A>q

( )))**LLHSJ$$J~B ~B>
y$$$@ $
 ? >""ZFY7dd  #<r R` h3x"'yP7V<DW!2

	" Y	

tI  a~5] 
   At"#1 ((DD!@&ba$$Dc$%#A X)&)`' &Rs[^̃ZbgAvijoWt@CVXeւ\fHݒHoߕύXIۑAOԃBĂeLphd|IeuN͍}JTp\FffnL`FڃMߑIOsځwE\KxuvQƁBȉgjڃymxtԍrmÁFGsʌx݂한쐬ȑ}ł񂠂֎~HS\zԕzmQ{ǑV͈vǎҕKvd`Yi@lǉ십ċNԊO_ӌUiTivI"ىe^qlC~txEؑ{pWoYڏMȍ[hxb]Kj{# - |@  т  0 ` R 	i D  Q @' 'dD ?W" 
 P '1!!#"?& p<
~|u  0
FA~% p? o  !  % )  f"	! ( 02 Ri    0

0ec M.e     UP W F  >"6>%
!` &dEG<"F {) BFLXp0Ԃ H(,`"081+d$Ad|9  1@  ?~!BC ""!B'  /!B#b&2 33`   $*6$1aLX +>=p1@@@a%!> + ,ـ @+Bft,0Ì< @` .0`  Ct6pC R ,B
ۢC@"BD!<| D~D D<P B f<,$$0$l= 2 I@ 3`<k%b<@ѠA |a  %rm  2 Q ? " !aA<a  1$Q$${a?yH ! {HHK` ?x d $PV` @@` 0!cc $2&f# `J0;@Zxxa 
c
{AHxp!
g
 `` !`E  ((@@`)X0$x|pTT T8QC7O-  
	`E0 P $&# ` g8 o & OfT05 B`$c  L $484(d(lD &1< ?! ?&!<? !!# f4cm[\^0  *L@[* R4fBoFJ@qdp1xi?|Cad0a ѱ"i 0`E!cE,1B ,2$9`0po?"#!!;  `07#	4vg 8s  [ @ |enZIi&0xCGP(Z/cc"d{
  zzM@^@40  #2Bb"6T$-`0|p.x3 G(i@@` 0pހ ߆ ?` 0l@MY@0M0s``8xbv' ?HbK)' 
H%0#$ !"*229Hi)""?"!  f '  <p$P$%)*$ $ '` ,!## 4ED`@/$ !   BxM)A$ U\7 ga|"  ""
"4"dQ0O!  0|`bsD% 6s &@Ea! 3?! @F !dF!3#:~?;>}>; r?`8 p9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p n%8 >!n??$C @ 1bp΀8 (~l =Od<<$$$8< "***" /"$'$&*"$" ? Db2b2U?1`		
	f?21"`nд `U%2%?' X p $'!E@ox pǌwc 1$&? l@ 2?$?$?bVVppTD`$ ~  <@ D=!<$"  a\5' '$'0p6( g!}@  q6C  H2`
8h(LRN2$2q2DRD" T@""z" ""sN0 
CJ`zz| ʂM@*t<Dtd,%}IHT! ϡ[@AjDfp P
 .:23V!&    D81< @F<qb O=$! @~ 	^`/ P"Tj|>? @1l?jk  3C1(ff2/ =\  | %~j  li 	b`q0@ >)2"b>" "~"B"B>B"33aH  0DP;6[e`}  ) 4 `22"R`2   @UF|Ctd pUD H G1$?$q81 FD @@1#f~(3H2~RHH~HH `~"""6_I 6q"c  2"&	$  c2A*b$?AS%aDh|0  1    wQ_RuL!3p    7  "r0 aVU 01? c0ɟ苠?0S""C 8o`ÈA a d W>sP 1π B %z&6J J)6  #҆ژހ   0H@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>z		E@e%f|Do2D"DvDTDD6 # a ('}/`z" o7 )fb(? 8ctp"}  PpP? ȁ#}
( H k =K0{4РSO  @aBđ=  u4a8	  6 a	`1pp	  6 P>TЅ  pVL D@@Bf$,892k&	aT%@@ BgB(@Pa]1 pxPX	O 4 c!!r! 3"&,0@ġ?0blP<x @ ^ v?$&҂X 8|	(9H ;)*;*$*_%+8"e aRa
BF0L 0y@ D2"##(#`F~TT5VdV!ocp @a>b F a9$i?$	$	`  vx%` 'R	0`
JIC```WHJ  	|!W~@w_*H  K6cccN8x d?~!BC  G#" e jj0P0o!  8&CW0WcCf0` ?~$BdB  a B
BB~1I8"&D$(-( (B ,!1	8Hk
 

=I H<H$H$I$=] @ @ŀ 4R$ze US R !P@555 `6y0 ;6@bPgAwawDp! 3 ?$$$5d$Dd0R< ~   l ݀t  $D$= JGG^Avq! 2T<oDg/$y,(8p(lq$B0' % @ d  H4b2C"cy%5@ߡ0lx<D?  /"?(/(/(hOX wa@`\A %+\ 	ppsD`  0  ""bp $ & "  `c@`?6@M
3iF>D@e Zq@#opa(00of?$P?			?R" N$m|%o38"5U QHU'@S8 0@,yy {	z! p¥>""	& 0">f` |sgAA@ D=  =  2 < % 28= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$TdT?DT n%%">?R $ '$!$34, g A#A B8`nU w$&#f!|ࡖ0i#!`  b6@2~Z*\*joI0A
 PpR 3 `00 B " xBB	 0#B~5G ͈x RRpF H0	   & 	  &a K$# 'kooogp 2`zsb0AB@  F>lxPXHL0F`C0 `<0ʐQ0b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`a8 ?@@DDD! 0!cN 2"$"b)) ?()()~?H!!!aG`_c#40G zRs"r7 rC " `ȄV(  fWWkp" ">a>>b 2  "&"cb@	"00P G  x   <10K3?S"aK@ (! ~I	))iIx	1!c @>~"}`"b>2л
  >A  ;z ?A5A  ? `H ? ?$DX0b)+*{I#F(en} },lbf?"#
 1pxbj|  8 70 S#Q8#C!'8<
`NS`'  > "~&%,?(l)$ -S耝Q@ 2!;VR!q #  x p  "**~*B  h b~B_$fw D0@ @A`#p`$ 
Ei[  ~  O2R2RR 4Bb.	A4[d02 /w" u"p  bB o?~b
(LA68ɽg[]CppC}8@Tl@ l$5?b5d>qc 	()	) ( )H	ߖp `c 5_ 1 aA#?~"! "2&460ba#b @#D/ ZS?!#3"y$G! !?! #! ! ?y@wp7$   @
0y!K! `֜s `7xPe `T@$Bp8p'|"@Acp>'$ , ( $BV@b.F D !ss	\3
D(z

@ 
~~@<$4 7 a  p }#@D"4&0PPP``? ) )?)  ?2"/y1cK{PApP	١ ~"6qw@7  "r"@  ( gd&Ik	? ~!<$d$$$%=6 c`M}R  Pp @ǀC# ~
D@     ހ uUp cu`U  `U	 `}@ ..<3S.:3Hhp 83  [<u.<3 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.23` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VP < t	| tL^fat PwDXMCÀt	F- u 2 4.>A3u . 2 13 `.23&1 u2CQ2P Y*2Ȱ&P aB RDr
.B3.C3PSR  && Z[X ` Op@Cp
oo._6l3FF!.W_tOT_G-p
QR.683ƳP ZwY[X  4"2S2OsP2 sP
XÃ <r<0 <rp1@D3  F3.&@Qpu'r!	F33o!a0n3.>l3P20X2$CFAPQRW ((_ZYX. 2.9 t.D3BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>>3 t3ػ@ .<3G.>3r3OO#0.<3.w>3p<`X@Y 0..n?3.p30;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV> M> tj6hjFV^Z&  _hE>rRIWT2G1f"\fff*	]
 .qh XR
3@F F_,x7\j?X?#X% = W$>_	  JsXvӢNAPZRZq%f>Z#}j_t$Q"`WXXl	SPZ	&BaV.$!
Dt E	.C"S/EHx)1B}SDJ _"$_UPZیF ڂ7Q87.rg
i#<P,<=~Tp-6y "\$\ bzl 0x=EN	h";	?,"'
B
BGV-DAgMF!Xt;j99	Maj; fRAYjQZ$+dAfh  nRUU1	 tTtPZt	fh "Z$Z:tjnA$7sPtfhL\  >
t][t= tO3>[ tjh[VfhI /P>?*
$j hZfjuCCfjPt<a&\ ta&'\fhQQQ_ ] t1+; ]C	f3f
ۍ~f PFPha]hD]" doQhV_3F``YHSP2=#2hR[nh- R[Ձod V05&	hH\<ƀBFo]]D	xAZZCBhXFP.@ awjh!PV
	 #Z_\h\&YIsRhZ
4
SZP
OY0%5%h01!`r VD3F~!!*hBih
E{hO	PYs*#YAdq	^_ 2FF\^ F&<
u3L) u&*V&8\tFFP9 1FOuÀٹ F FIuF!1 F*+҉FV]+;u;uà]% ;Fu	;V@á]% *2]@9A9nB.A  
	
 WQ`` fj h`S:C-{ f f0]0X&XjLfPatv~]jP^1j /FP`F7"AbcP#qV=ut_ wVa @)#
0GF|W 02|i[a h &z F GP	Y	FN_uFG0?67 

zyO4 WV3 #  !^&@FG|忀 3t46 "1 ! & FWRo`Ó rJ	16HF/ Yd)&!!!% AFq
2^Z% 1p 2 >I޾b?ࡲa2PX#r2q5$bd1	
2&_Z%  &`Z&WB]G=	p
"\%@ +1 1B]j]R!3RYb
 `ZIc@r&@ќ"U
5ញ2]g	u9J
FuD3F2P1XB
p `	#`R	"X%X1Xj_3X%zQ Xj٨PZPZ-1Pja te`h~`{3))ZjD"F#3!"$ER"&#
Q#(C"!#
 
$

H"#u% s%$EN"%3ug'i)t1jUS+ZEU-:2 Zj~B0!
g#ZZ3;Rb1p qx,&t*!5
ñu7H5q5Ftq86B]t"Qy21qG;c;t#z25WBH`>]<Za҃7/A	) 
@&
QZ&Z'V&@^Z @m F >@FZQQh_ T"SW 2{S
} fZ 2Z t}!JrAARHP3SHT3S5sA_5XD` ^P F̌]^F dF&F~
r&``#0BEZ@ZWM͎1B#T(SZ`c%  %V& &g[?&[ &` &J[N^֯]@   \Z[@   v &\C rW%QFQ10S`E  p  V6^aF@t
,tJ[ e-t_-uY&[[ _[ @/ [/9%> t0 t 1m0߃ `
a dUr	6U0*@U@8
q
q
a !tzO
u#Y>Qu̡)2 V&0  l[!j]Z+!r΀&ZYklQinuP*5EA$.q'BZ$0` ZJ  &Zw~j.j j	 j 27vB 7#r㍍F赜 d
9%vB&D]*&d] &D]|5&E +&F^C!&GC^&ƇD]d rP@[hJk-1|M2JTZ|K0J[&[FVTU Q9"}$qH\&R[	s$(Y*q
<,0=.rv=R[hHð+:uP4[ [FVH\@tj}]ah$	BjVgZ#Z	  r۸`  c !`XFI20A222ZM(vVgZ\"h01 1K
St%r F^Nr'~#tp  u^    % F ڥ)^  ~u +ËFV VF4Ƃ4~ r~t` t uKFv
.u.~ uWt
ƆƆ psyVsrӧ
qW ^ ^ApM~  f{# F FB F~P|v^ KF쾀^NFFV~ F@NHtDHtqH P 7|j
$]P^F&? ujvAYnH1,([s!9& u..Zaj:RXV!<A0YvhYBi@NNF@/\v 'FQ5]FFPs]_S^/GFPv4F]FBiP'1<kZXwPdkZ9Z@g4V&@2U36c@B@~2|FtFʲ*QW^
6~6	/4 _/pFFQVAFQC94p&~ t;׍F4F2
z u WV~vN^PA@S
!1@
^_C
"jY(c
l`

P)@pr ,md(|WVvԋNsODPTHD D~(|W~(I0Lt_~@u"rHݐ#}H0IB^F&WS} 
 
.pBW!yu@## fXDia2Ҷ
%%		 	_F*Pg	}`	A
g<d-UWVv<Ё~P F
&GFq&'k*V~ʋv!^P޿FGIub: ^&^&8t #^^}j!#ù
 0GF N% }p,-Ar  ~ s԰ NFN+;u0g03FrAFC&PfrfF ~hЋߥsG^AaQFr ~
vЂzA~ r
CVV,GV~^&F]Ia&a8FQ2^Z% 1p Q2U>dT2IGUbf?*XXq	= q0q3$bb
2&_Z%  92rA	G"\%@"\1$\j]h r QT&@4	U2a
S
RU	#_"3X%Q
X1Xj`R
2X%"Xj""PZ$PZ1RZkja"ڪ (Y:31"3"ZjDDs3R	E$v
UQC			HPNT+

SWU Q&	 g"Uei$E	~&(3R	s1 jyQ9	**z*,,x,R.,,Wh 
T0h#0'#G3p) 6&&ZQZf@f   R[fa	 H\ " ]  ZBio؃2K  
BZZFrCB5Ｘ^ Vi@zFRJCj#P)S5zB
3~SQ_  pCWVvqދ~ &F<t<
bCrവF*;?X}7Ary~tF&8tFu|t<r[2$VPx^wu	A(|Ðᦿ ~qPfh#  @lPqF;rF f?* F 0 F*N*ȁ vFߊP0k¿  vv"u+\^F  FOu]f\~ &\qt&\ q0  r]% = = *pERAu]$<  2]% Fu! = {* Au*&]3Sqt]1]A	u6B	= +ɉN3]3[3 Љ ^p	u&
? = uP`HBaR
20
u/&	u##			}] 'FOҾ \\\\\	\\\
\\\\\\\b@>Z ێ4L[>XA?X6 6 &=  t_ @3Ft  aZ"\#-//

	
88qu	 M76Ĵ &&T:AV~S~ t'j0F@:I R/ u#'j |mqZt=3A@ >
u
[&["[2[갚1p   t?&[^1`u\ À&\ \Z\Ʒ[!^"[0#\\[]Q[XPX XWZUQ[>u/[h hBh R3zp2r@buB^rh[WNA4R 	'"			

 d		 	$	r	B		RX6VF&? t5`d(u%&|R{up )uDPV@RPuFFY efjfh 
 fh `  	     jEq~@\A u p]&PZ oFP>`)tj 93= H/=
td-
t]-! - ; - p  r= M - -  -  Q   8>ۋ  &9w&EU 6`  VV` 6ϱEˠ   9~޷ H  ;p!0k吪
f
>n~ Kv&@u?PM^; @vĴ 3fjtЗh  <$ p >Vi@] j vV> vV0*^&P^ ɀCP% 
P ^ h
} h  RaNF
+F@F !vvo 	F>VNFF@ hfbj a^rCFPNQ=`*P``WVVW  3 3_^e #>V` S!F~
F>V@ia.
|#
;F|!% F@P!]aVvm`Nu@paDt&E@A#Fb@QF~u< tt (r.@7 0@5{ {fr􇋱X`(F
@tub~sv*VA 
Ɓ⸄Ɗ*} ufU  ߋVn']ᮃ> t=`ur3NFّ\ |]/NZ&8tG[JvN! ؉^GF
@Ft^ G`!ѐ+tp
뎐V^% = @ʃ@Ao3t`߰ߋ@!A;wWV> u#3
1&A *;tsr1A */
 0b?F
tҕ t" `fh 
#O: P.B@H?Vu	.SEHDa!E`.(EqrVu`5 3l|	#5d7RP3>>Q XZ@E~38tC8 up0~^
gAQG0bBJN3~({~ u j X F;|Ԁ;YƐbƦfUVNVv<%tF` u DD^ù
 +0NÈ u0+	Dm
T^FD3dˋ向R@VF!S@bVctQоO;v~@K^F&uFIf
b~VV~}   m+΋э8s,vf3a[ppN&8 uN`= tΰ&@D/P覽0fh З}yZfh  6 0 s?6 ۴k+IQ^XyYNd_!vaqj oaY^A8V&щF3v~Bv0Q&ğ`0Za
;~ANuǋv piF˺0  Љ
~[P^ VҰ ?\PQ @F`~ ~
~h3ҋ W2`t4]PsvQ \ 	yGWubu ^Pa9Fu
!w1_P0 vvٰO9𐕉FoV`ą0Sv"F9F}+F- P@!!uCq_(`^FF`ѕ/b*" T\QEP~DPAaAP:|Q!0fh a39>_ ~jy/Z`*9>u	QoA@0A/\&76m);
G;|2*& P `8A	kFqPPoj  ʑHjrw@V1NV?RPADA/Qd>a2? $A%@Ry8!i`EA +FFQ%Pa#
д0A S ]L;aDPZWQE"#ڠ<>&5 O`,+F+`M*2cQ$R@P9D=aD=F3@*ǐ*A;?}Rvs'V O1@Ƕ%g*@F;vwP$4_
R14Aa

uQ#aQC4
eduA84	P
V輜 iBB&-24hXtYY;}`=zy#DȰdf&D&Tp3p ~
{ @@&Fި@u[]@ЦFtdF;@Ʈ]q<ЁN bPO;v}Avѣa<GF;F+F-	@pFF&Ev;v~ Qm~ $	;FF̣	_F	}w t~0Vg~tOC tG\'F?
t/* F T9F_}\LF ;F~AZM
~~2G+F5p~%&L
q DFF 0 @вf@`	Pf@PF^PVEAgGTX2s|xb<Fqx[0H&/v qSFv.!Fڍ\Β #R@?~U 3'ts~qF+FJFHfh imaR( tTXT4+_v`.9~ 4aFePl`6,+F!}pu.@.Z Pd &OC@ +ϿQ.v+ǀ
0|wctj[(Qu
ĔpZ`yB.=0a"j]1nhm0 'BPaQ !!a2#$QBC}|PCf\pL@>\\j Ww 
Ht8-t-9t- 	t "f 	 !QF~ tfFf\F@?F
Pj ̿ v
u} f0pAj >PHPVpoa
wϹ&wucsǥtBPؠQиN	VV2F
ta@D% QDbَQh
VQ6 B tDu33!郤
a_؋!bG C `DPk*. H!Mb~9>u	 uZP:!vGg	R4õ1xiDu(+Huwu @uqt j	jfhpam	"	P^	S^P7qf~
 t
N
a}EPzUE@ ]2FY m DVVjvv{xX ω6G ]3?虠PS3r900ހPr~#F1R0c@UPq*E~
G jdR[807+$ }p  9]te #S#/E=/豿FFP释FGdpg
~p ; ;NNNQPL @C7 r򠽋= K = ;  ߄-Pp---xАMFj  Uk 7>@]`{ P;v1!;vFPVW>FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@_6- ;sFc?atU tP` `0a~9Fu
VVIVFp9vu@PNPN  PNNF ~9~};V 9vu< u}N0빋v T|` 3P Ppo & !VN;
u_逐xA^F;~maiXS `
$~Du6@]| b;|qT/QN;v}O;6 VǁQ9~ u[FApL倰 9v|GI0Đ0%9F| ~-A{^&+^& 'FK'302Fcm731vy߁V0.tCq u^ GCauK  K o.f#{9PՐ {!ohb"rVt ;tt D@m~3tf4Whr
 rး5d@6LWV  Mc [ t\U@ @ d l[
ttALDTau0!O;F~ Ppف
rջN@uOp0
<|Ɓ<7p>R[ u)>H\ td>] tl >Z tt{Z   Whȇb  ]hpu"jhXh@V}
j(h\hRVmZ |d [hVMhZhV= V-
 VY?hV
#[@VaC%R \3%	| Z\#% [% Z%	 Z`k"
 
Zz Y l+(i``+(^_Eps= Ht.- t'`tF-4tc@[Ht- t4AZ/Q#Hjh5pt1xtߤD/ODpU}*䊇D]uA*HЯWvGPVL>t0<w@v&SyO 55446524֤5rޤ659hۦ^@j h	Q U (.	7ܤY P	{$aJj hu"Ћ^3&~/tC&  v&8 u@*C_;^|ӣAÎFP9Qkϡ@9]э1d^Ц? tvN~ _"vVY߃~ upv@]FG&9 uԉ~ii0N0~FR =  -
-ꃑ!אRZ0 <5<<V<s߄<}<R<O<`<Q<P<L<M<G<H<I<7<S<N<J<5{0PәI-
=\Ð8z:(!;`3C,"}u+~ 
0 @
( `
 
} 
1%  0PIpՁŁ@$0PIpҰNtJtytsP tm;u< t>]j*^@0r~D@_F	 p!0    t":uNj G@@. Bҋ u
ޡ)jcN3~* ^
؋^&8u	F;| b܄ܾj	蟐 P 	/F7ы00p=c4
Z$  *8fuZ׹j]8~u@qE	tP3ۄPF |n FP\`
t)f3f_ ^fh 륐j h$WI0v*^u @~g3`^PGWF0	!	*QHt  L= t	Z@ &Z} qZQu}	7 b	r	z	 &x	&	hrh	h =aA4B x	@	@cDtp	@5q
&p	`Q&Z&Zd`\sp\aW"  !VF?P*^ >`	@W#'"J%$$CB^FV^ W^E4$ D~&C~uA~,A~3FB~
A~4^	@,0z||#e쐤hZj2|pj |	P	PЀfsVxг0zbzW$Vf W $ ` t&	}   |	M' +%hG@	<	) C hl[j pP2	CV%  P_RB/ 

$/*Pz$j40/05pRHTRr&RVUd&t pP%3W


.
bDP*=	@_-|骰}9t7-
= Mt%
- Kt0Mtb`Yn= d.DPp{l,2@0`  8&V0`'zuR!"Ր,W20`  PPWu/qU h̕h S T 9XXX w	(Y&pY^d q=W	ZZ	@4 {|	!@ VZVZax@Vfhh ۀRY@t&
 
@ ACCC	л	! !	@ZVZV	$
r4 + (# +-+{tp*tcm`Kt
- tu] &3& tGu quhhB?
h !wu
j8%A&AB
h#'$''zÐj{[u@
@Ao&@
)3bPf 2p6
Ap>3+>8>G~>E'>&!>/>'>%>#>&2̜);; >VtThh
	&Vb
 j` &Vr
>DWuDWpqzaV
&b
&rb  t~j
A!@@G>
> 5@Gz
8(ACD0V?&"@EPWeDǙ#
h @вR#u+C 5 轉1;uEҕ3cB髛"M"M@%M@#tN,,",1pCDW`:_H`૏	6\t|3ɻ
Bi &ARr ?hR/%u!j
R pvE&C&@	{X$Qpa!tD)V3%,aWT
wqG 9lWDWRy}D.!
q{}o$ர0%@MD2w.$$-Dp}*4W"$pҰ6948ǢJJJ[
DWZIԾQI`
fhahN"h iyBpHgbHUx
fjjGbX
=˱=e=Yt,0f*q@t>t1b>@>@oC;or
@Dp0k;0C iHH IGIF FZ
@MXFW%{&
ᱚ "[`   2:0d*B$ C% R0"5@0bТ@
E
@r$RP
G62& W	rv$R' 
TD

~!@zE
)H4"W 	l*8bp~? N:1p  a1!`d`@HXnGW  "c뤁^ab@(FW 2߁ 1 Lfbz }
@( ] fFWf^ZEWfhI  HбBf_^ZfA
_7v
va_KZa:0!`Z0ڀ&DTC<!>Ua?U @DC@AԄԃܪaa
o
@PPd
rh|r.EcvɋFFPVhe~lv
WV 
TLWeHtHtHt$Ht-LJfA+ A@!!f>=
G<4Ö^4p@* <%P$y'`8*@EDWG`R`apd5gT:%TB
E
!أ
Ѐ,  WVf+fF@ ؀  FW^FЀ F FFFPFp`FD== @  -  -tR>  - -*t:-@ ߐ=`+-   bC  - vt}Qx$Ht/Ht:HAC 16  (` `!`"!13} " (A
Fy
t)j pPPfsV`t2;hXڱY !fFgp h*HFM~ f fFX^vfvvFPvD5FPu63F`.ʃ~%vX :uFG;F :`d~ t
&@~@&pQ j  Q q t&qɯÃa@ߌ?"Ht)3Ã?? b~|b{܀&P	q2Q>LW uÎuHj 
3v0 R0"[wJWf2f PWf W Up Є 9FhfDbo R
JW[1+3P҂8-9t- 	t #`d
  *@fjj a
i 5	0?u.#JN̐
uh оƐ>W tu}qfh  PW	&Y-NRk]>p `6
Mh5.hB63WX& p  F |b r0~ScA >p#u>>p\t&el?6LW_ hv`te3_ X13^
>P*u	> µ0!jj23t;:3Be'kYJP t':{80w:2R%4;44 ֱ `@ 3qA!Fa"Z@[$
$4*tS?=<=5
5
#IE@a	P@Ba	  f{h+rD+-qppp$%#;$ %P/0 X[XXZ X[PPr ) Z%  = $4&\ ]1 U502 Rb
b
 Ԓ
V }g
P	
	B
 G<w0p֢ Dt,-
t%-.t,-	 tE-
tYt1- t}/C DpʿLW:B~AI <_p}}  oUDcV[t[{u&PñP [tu
PHt H[U@@e@&8U8  ѭ00-Ǿ0@ut%Đ;>}k`  PXr%2hLs`pjtXя6 ]?HtHt `tw' Qw h/mu
^_ WV3ɀ>
 N3һ
 B:rZ@HP@Fxr~[ ѰBrPNpD_t Ѻ׃&@QHP׿FV^tFj&Oud,j,0,,,,, +,,.螷>uh hBih[ h L jhN@c/"j@t) <3҉d65P@;@)}Pr݋F 
7h	΢	
B軽
Rc 5#W<B6f
в~Ĳf\ v3ɉNv~FV
tut9v~O|~*~Pӈf"X^3
GF&/F 	 u^*ۍF؊F%@-Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uMG

41t%I6%|bnpf.Xfff`
`.Xt߀&4
S4
 TPV@.2X8,bqĲB2Xt&$\$
X!u
5 H@	
A	4EX%@^3D
ǐ%D
tF^&F!Su	 D%0$F0&*^EPR	nG2`
rcNQ33=40=;-tX-- 9߄/-Ɍ= M-  - t!M-Q PN P{= .PƵ߶Ե` / /  22+1 16X<",i2  1(CB !" ܠ.XG,2).0X --@ 3ߐjiP jhw]% ރ8rz߶/ /  p6@ qjwq43D
k]#'Gu@ 'ߐ]B؎TPfX; "a!##"X{].XX$ t&,
u	&<{
,
]4Q <
@d[T{@ffhh ?@*
fhZ TW-"2(B@e	b
(UH"IHB"
Xu
!
$
@B  fhfh
`  	
h 
rZ t>
4Zi ހF\u
6  O hE輛ˈF<tFv
hUͣYsF V$!FC|ߊFà8U۽Lp
8X:Xt]PdЄ`yk ]pSQX fF/ca XaeX7D
X@
aHehP[
`h7	!]6g
(
J QnC*@aT؀_Taf}d& gP4		RzTf'Qb_:Xx
0z嫪z&|Z5գ$"!*$
"#%- 3 &@+18\:UX"D

'n!j,BnDnLBnNBn@n
(- n
- Kt $mPqmPq`rm _m(LftƼּ "0F\r``7j7!l lPj`9j aj ; AB@ 뺠:- k<7QZd&9Xw\ 2 % 냐^r b@yR;wĀ(]C	i!uc")# {q (w
*t By wm`ʽ!! /$ P {A0ߣbMPZգsf_PZf80^Pq@qkta abW@!b0C!&D&Tb..e꠮FFCt &Vh)ێ&? t
&^`V@^SfC	fTnD	n aUv
v@~~C	᷆
@PZaq@t&6fhCA}DYW4B6]>>@|+Ld|tlT
<fh`z^_h]p
qR3tfh~hն$$"#h!,@'1&}zDhtà@Mvwx@xBx`d`QLl ')fxӤ &ީD*@
ӨL@"H)~U
ڀ +] $] )] cՐ ] (] *]ɠʫʘʑ  ! $"0>LZ  @AƢ@BX @[ ab[@\z!"  묱 2 L w#Ԓ	"\fH "\f@XB]$t	SNOB]p> .^   @dKLLCB<MbK$O"ORdP"GȤQCj"GRIAh|b5mÐJ[t
#&CYAYJ[@T&Z`$4\]Ӏ&d\@0@ute ;>/}`  rh|hƑ-0FFX:V& *FXPeA u$ 4 j h"nh Q6  t~@ N>` VFZ:  0P j 6FXzpu.&>} Fj`&NV"~qXu Fڹ#"' Dt,-
t%-.t,-	 tE-
tY- Ht=- t/>C D0:> ~/t}p  QX	@Z"~Vfv
 莎 ^u  8h vF@w:tF&<:uFF
*0N&$  0
u2F ~ uF	 F
 =
 
 <  C
v`
`hjq(^PYE@
ag 0
~ ~ tmh^7J~ tDI==u5' lp

 3 FPPP!eFF9Fr' ,% -
 ؋1v v s0d ƨu= w\*6BNZfȋ~FP.Ԟ4`y ~ t 5F- Ta  RR F  :PUE "  
tN~dt߃t' 2{d"+FI Nr^~u@P W    I P @;FVF^ =uF6,N'@,,'%ÐWV6jvEhhrܵ?t*:6 faS ;ƣueBh@B4UAB-AB4ABSAB_?gBB712=BFB[9  C"C,CDBћa
 ,Cp&#=P6f+fF@ @Xf e X8V^aEFP6 Zऻ( Mv3+Q OYe& t$F   fFf~ sA(Guhhf׵נdPfQVȡXڙRPSQfXfYf3fPfv`fF fh  "OV`fFp;Fvjf'TAJZdK PPW@N\
M%ssАbhE  p p4  V6`qrGrk		% 6|XD6\\ 6\|<r"qߡk芡V0o353P.z4srhh_q 7HX r	HtHt[`sYO Y  > tOtt?Tk\ j@or@d?wt0Tgh&jprB?
_Ɓk?.'.?L?)1$6āHX+
?āO x)Ӏ V6RPfhWXfhUV薤aߊ&JXhRhމ^)KKt&ޱ-+`
t/`-Kt
- ta,JX2JX% 1p ;!@@tqYUP 0*IV 0*:0l Pї{o(ư  >txV0tiju,6h/lQqQsu/Bn@fo:QhB	p"t \#:m11^8`YQ<шY4< s u ^a8   MHz` KB1.36` drivelock   B Computer Setup  <F1=About>  File  System Information  Display   Restore Defaults.eConfigurDIgnqChanges And Exit |Q 	 With	 Saving  o Se?curity
PassworaU	e4Power-OnP?ort Op gVarious rtsP ThH`
TDJiDLFsHm=aCard@t<HSuppP) TPM Embedde.wvicPtat@$Availabil P'Hi &O&et ?To Fac'(ettp!sAuthenticr+&Cre0tial po.csDia*s@s HDDp3lf-T0/Activ`  Me]m
Che8 r > stallA35c72L@2uag9elect lDT5  o?f grayQ4field Bo)o*;bo*;'dBuilt--t 5#in5Press any key to conue F10=, ESC=Cancel`JD|RAccep/=YesSNo tF,PGy o@#
r=MpL+Q For addiPal iQ `&
T,  please ref  V(>DMsBUH:wa TaPSoft Gu?ide. UA?followAP`stK a:ܠ`^->  SPACE = Next@2^-B'ACK vJFccTABE#d?SHIFT+&*dgF2@M+= c c^J'Manuf@[r  Not}e ,k ModA"Proc%Tyyp@mSpeeteppCacYSize (?L1/L2);Q? ROM DM BIOS VersrSer E SNuP	V`oRRKeyboDYQ,rxD{*nba$sndqVBat|y I1|23b45fAsWra	
fOwn~hip Ta+$(<d
BO3O@
GBA7CV&UVX:%$ \DZ.   q%F[^ed!J_ErrorjFm^% Wal"00&1&High AddOlinqe!4 Al0nQePBp,RFloppWarn@: is }p0 willZ* boUhp?VrsabqJdiskvue  vcremae/!GNin *t@wR| fR ] A: 
eBd~` was n0j'detn!N@' Uu PeInvali𐐍fromP
)oA`you want@l  PmBHd%[2?FOi
B`e Qs ib+-A(QuickL22 (re`s 3 (S.M.A.R.T.) Eex Qmin): 30 #@}&g|30%|m q!%Suy0@Pp=p@by h $
0#!up6:1`'t4	Q?Unknow "0đqWR!mZvoReadS)do1)4G ଡ.Xrib:`w01d0aP'bG H  Old pNew gify nYBEnc8Ooff OBi  `¥A E66vAKroE  eб ;mu@equd(V
r`imodtQImPcaus胙ĩ1bJdch as 00п'ӝNpB!a. `@!Ƶ>T|@loss cY@  Pʯonly1KcAo7f agoP{030~ev  2\?ZاcGis9hR_ed? `f\tж JIU"P`"TTool VPPr. $F8TH BP fѴsuspenR0)mp`tWSF(!aqvps .Tcb 8SY?%3%,% `g4% 0#Bfa ppnd8 ep/cunu=*R5#n)t `iR=PInfrāPara%xQs ya#MediarOIWA΁mak`n LAN_ Ambi6LQPn  USB 1394cCb0Slo[xp@@a3CD-2 e [B`rqQΠ
7bԐ!0!PhѶr auRf_Q b0޲USERMAST `~6pepnTp@caXrYQkeep iuaPe GJ phyus0&lEsep mr# =c. `1EKcD
,XnW, Y]unk  0 lmOxOAutoAQcE@d @8<H<6"A	T[t  HO
JGJdurEti !Rb1th`U:1tw  /k e:dPerhfqdaffP+ba,xssibqmaQpicgiGt V Is]pl r 4mmR  ru@Ylm,repla``t t(@~4]BϠԔ, cH?;2@v`me,@@K֒0pWpyibPty. I
fdo"w6[BESCQx. R T Rtyp'<'sqa a2F10" qBBrm `$`/}*  qE$ M`iBgg OrҐw:S ay	 V ACdIHSDPAB~ (left /h!tet`qu3vSu`I ZipdmFirD @o࣐F`th ifp Si9xa h E!|NhASwap Fn/Ctrl Keys P 8җAcU.S Pдd0c~Legacy
(p6y,<Pr ~pry Vo a NTSmC@AL -J #-M+r`t
BidEPP ECPd2Asize 32 _MB 64a FV_AlwaynOYi00AC veWWAN D Radi hBluet h@/rS;chx1A Sav"?SATA N KD1CotCPU'F }CPge Agqs#S`3X EPL012-d/)#1}@1NetM *KEqn`m123TokR1H	r m3~õl  SpPSt@ TechnologyrtAfUAdap'L0PXE RPL&MPopDe7( I0 10  2@ 3 4 5 6@7΀F9,bYF1=25 15@ I3 (Pe@-s U6GTopaWS NonBIOS DMA r(Transfewrs VSan z!AvQtk sFa]2/ mu˂CPbomo s p!  Pl9e@e s1(1inb  CF dRs e0P賱 V҃k $ 0o0.0%le!pbi4#Erriwdv fy[Ʊe R ı cycl\ <F1=o>Bei Si ԇ`|OazeipgYeinN{llueP B-kguAig%n@epd *nicnsehspep pV/%#S"heitsfunkq-Ke#nn p 2|chalt(OmAQluss1Vp4dpne
 sH`'9s-ID`  -
H
O
S@~i"v Usttz!  Շ0tifiz #  beim 'st\TPMteg"*tu<7nHsvorr1$"f?gbarkGerts mP!bnNufR3n zurckz !6OB 3p1,@6@Yf_g{mք*prDia09s@HDD-Selbs00X) A1v3;E$:wpr4g <  pD =+Dra> swhG3A 4"K2gran FeldsLrt- e; eK c>F'%Q(i`<be0bQ
Tq, um 3fahC`=A
,q=AbbXWIkzetTJ qN\e, yJY	=Mehdmbe@9Icz0 fiq\0?AbPQt KW   AAware-cYoft hmb Pwafolp40Kn KyXrron:x-> pr@D = Nch Zdndk<-R!;ch`}3t-`VoAma'GTabulators2* [Holl+ge:_bmJF2@
28 = ywEsc}lEC@E-!ll@oz  uypRr Ntsgesw#igY`a"1dC@-E-Gre (L1/L2@EGkapazi/tt P-@Ф -u`אnnumm G_rafikR@`Tx;`gr-g!wDesk -E+2ps0Ck	x?8	Akku "O2OO4EU8_ɠesihq3(F!k  

o1
oQ
oq

/WIHd :u$hQi .   %'"bDr!FeerKH`alZero-T<One vEb0dހbAl6PPaxrnOBe z8 Irq:es7 sstpYbisLTn@*  ZiEU,-/aW:Bbߢleq_b@_or ATeib>p0in Lauf:&nf6
lWge aKv/+Pt gl `OL_  ̯MDwirkl@0  qQ?C$Sp |ҋQdaь8
aie!qQ oca
۟.41 (`bn`I82 (UmfaVndJGQe&fhXdau(Min.):G 30a݅d!`%C%he%O=wu=oHGpmp%u#br@BrG: kan5H	P2aUnbePKx#7d4'rvo-LB6.
4C`3ShafAttribuHID0a3UC1PS.M.A.R.T.%[0\BQs Neups@N Dcead§ usaJaS3F/t Fal(9g0?bAfPr9U"4YbIdaDurq<as pesSV  mg?qidX"!
fQF,L +(  srPva. s Zh?C6Âenlust.hb sENAnu 丂@,iceQa@s ,s`&p! Ц B ha  crgaD	 :	 
Wۓ? U=m FunP}zu , meFYӐjHPQztectTooSec@[ty _Manag3v	GenoЪ?.F*c1|'QuickLock6Sund01I &PrqMPS.!P#,$biePS0Übkchutz  .AOdminyo0310h=im$&0 "+q A)2~+ H* WX"d9;P#, lsგv :Qm 0%I J@@cpґZ1 ot-Par/e v:- ]$p 1!7Wake-O0AN L t  USB-PF139G4-A% : C<Bus-S@+kp Exp:mECD-ُ@Fee#M-rvV: n %3:md"riv	eb/Fy@ ABD߁Ɓ]E-#F\s m \@GXunb{raobar.ˢ3I#T
h,7bewFLs ^a*",itnc )uX L.eQ, r1h\-E,  ҭqɠPcɐDn<Az 2³V3^B?egriff \drautom Tx~ X76>BohlvEmbedde*V'{}08E>Zw@knUa@8@n 1f& `}%2 [~,B bme n Oquf OJ#`СPN}a!sf!sf
emSvt"D<sEvXcA"-%fnDBX*fgOgE`yagubT'qS,ūs thaʁa$B  һRŕ 3#B*H@w  mZu?rsprnӝzHD . Esdrq@empf`.ч	 d=qzuA1O5`$`. _ S Е 2s,.0 9@򵦠Q 2 ⶇ 7 @a-9BtDenԧCraIt!cantVf4܀dibsc-!&Kk&p?lQ kW!'o'Z@[a F1A0eHrh:v m`8ˆ& sD l` Mu.Bayl Qנ)IUk-E! (links)QAtn"-2abSuBZip 12 3@456* 7@89QFn/Strg!xtPo%dE|aC W (USA:Щf-ZePr B@iebssunabhng`  Dr Grafik?-Contr!PrimSek¡ VideoA- 1gmn4ǿBidirea?l Gr|Us Lf`ipCntzbr WW/AN-GfcBlue_tooth9URnBв/a EgpaN|ݰ SATAeDualcore-p AlaA!s!BAkkAgss u6!%hs0ha}C-06(o)u`! ֥E@ V7U 1O	203>To\R CF)2{}1Al Qedpp  `hnology	xL=0
adapQ`p0m2,zCA-!ppup ( @.) da9u ԑF9,qfWF12eZ IpC IOS-oDMA-2.borayPRnn0kr T-@c2gP7ch emPG5dc l`A$.DٗePЕ` Compr wdVoarRaomFRloЎ AThQв"Acib1Yb.Ctr`.y00,0 % abdFcLFe rQYmQT
jA^	so ZufpsdM-Zyk opstn <F1=Om> FihSloplysV эne Gt`a°r$1nUkonf@ 3gnހ\r nr o fslut Ar 1F
 u]akg mO@nkkd Ad#ko)dr#K!s\OVp?hPstilЕ!9h``p9p `  cT0-idSq	`/
SmL-k0sfGoddel af 7pdO_  TPM IndbyggO""'Re
cpFg0aT  Skj	_w Nu il A fabr 0 UAst`Sgs	7fq]hF%@#+HDD-selvtؠðHuko1	 ;ѩ!ainҮh Sprog VǰB mo@/nedtЖt !p3q{(#ErE2B!oA=0>fTryk p
$ t0?F0R =
, ESC=AnnuCFs!1={JaNej "ΒO, AQ=M0Om  Y$P&a@r M7Z nс?Setup pw!|du i1U _i`jled\n H \RsofYt aru`  0XU]
u: -> r MELLEMRUM = NqX<-TILOBAGEPr1* TAB&R%w?SKIFT++zF2@	Z+ ?= Accegp!!jduc yǾe0c2-typ h`@JHpltVce (L1/L29qKo   psbx~ipArevi12a-cDa@z-bAa WcBAOri 1Ze2o3o 4z@et-taejи15(=at)	O3O 4XITS :u$ T  .   %Y] Sly`!f0=mis` 0'st`D1I$jPQ tGnjeaqd!vard: DeP h!r s9l!%alt`tP<2L_holdUAXo Q`/>0Jskab-  `NxZ\ʱ k1kyP,Q 
v A:ܒ  blprfxfASUgyldig/
ffraWAltm y ngivrb`Ú n,!pavi H]un?FO ic?@ K"'1 7(Hug)#(wOmfde) sl + & (min): 30 "8% frudf	`"7nsrCqv 	afbrudF t: K0Т&Bd!!U9CS")C'$ervo(Lsributo: IDt01(odq?QyY .M.A.RG.T.5@Ay1FpF9X Ny  Bekrߑft nDeyaCŦ Fra aAk1:!5 Ъ		=P@spG 		Lry  k0me, K	Z`es, f.eks. `p@bܑ apntific 	@ǲSHǅ< bTata. Du b!un  J fqlUlemZPv@	h DYC	X?eD0pTb "A($:ЫHP  tectToolskK~ Quick pauLsܦNmus*SkǑrpPamg ,r0Gvt hTAdLintori8sa1,$/`H!0'#qnoSwۨr, odive ubilpK2"Qll p plrd Parivlash- 7POQJm@@sΡ04 USB-e 1394  CoBus-sloEx怄ssQ$Cd-rom-и cYt0BG HoPJ2:Be	u䵇Ahy1EW@eǆ.  b+BRUGER-w OVEDADGANGS?KODEN,:8`\U alx@NYus nBi ,opbe /P0S 04&#
{	U
E# ln TL_AJp\|+hjlpPAutom0DdEPJlCejQA`TfSfu6 perma`anvB>ig. 9}Iyp,N'fys!!1cArbAuc7ompir.&EDDLQ, tNv
s   l+EoplK)ni@ @ukW#hE`Tm0, D#-Oda_   <ӟD~t. Urd|Sm pviQ("x0l/c rkoaӹ B`π/cY   |xbefal`<kraf͓Ps,  'Bqˀp plKadЌׁuaـ}
$q  &cP.a#v"Kp CRr1Pd i`$HauA
ybQ .ю:OtrESC. 4액`eC or` 'FG'B@e@F10FZ1Ns@g
j/c`D+csie  Dk `Br4ЯwgnOprR-#|pIetkLDS@-baz MultiBay (Lѱ)/%hS)}floppyE!c#| wSsuSbTz;iprFrЏA1TredjFj 0e SjSy2W Os Ni ̃ Ski@mqm Fn/CtrlգEZ lw(aci@sk)pegeen`UQst0!
udPnPŐ"rm-cr Prim Se d Vo Ou얠¢ Tj`StrL@>1ohuko nэ BBp<s t6nr` kO@trmcgt _WWAN-"spioLBlueth/A (trdllo.netpP2	@dASATA-n ~vDu`1Cor_e-CPUArS 0POi Э UCmst9y orh@[V".00top !Q2b&2wEthqt 1K҆23KToRRH $L	e+	 	c  ="X*ёid%Jv.>popup00k"{(0.89,!UAF12[=!Q-:B@[begrP;pzaʐ BIOS % DMA-r:b2 $W ( pa@tt"F )l <{qtCc<qKlu "= P(#zproces(Aapr l.
e00,0%
DСodfejl2sfic Rlkrcyklu  fig9uK;masiil`qinasjonVP HQ´ `퀛o4CkEk1"A IvH l  UR$,3la X LEsgr tp(t Q)@)h"&A|Pg KZqmBB#tPb(	5-ۗfunk Sm  JH` vgodkja£5p+TPMpneby HaWtusitЗTilgig
obake?fabPtO Ɉ [7a|?iagnoVkk A$"pvt  AսY'& MbTЬPbBˁ_= oSpr Hel[ Tm5BE >fpndt &0eln1h743Eury$T ɱV2Q13ᒳ@=!,=Avbry@a BA pJaCNei j p&=M`Du fa*`v¶ lysacbmkS 9Eʁipl i a-QadoGkum`^"bQw {b```  \`Xv@-> r MELLOMROM = NQ'18<-T?ILBAKEqrAn* TAB&&ySHIFT+0+|F2@	-<= GoiЍ`#o  oduutatb@k-mlls;esgtyp  AhN#exdѸcbuff(L1/L2`MQde ; -a-y(uHp%TP@Yr0}ԴuS,QkoEbsABW,aoKTA@ `4@paVs
b=brPCC E  >nB-%(r@p`bk JoaoAo
IXRX :$tZ.   %\ ok! Fep3R\,_i  "Wal1 0sS"-h1jH ww Adss пue7"Ve Pn0 Ad:  !0@Azhol1dp HGaڑ "/he-,pŀJ@$3 sPA/kl٢ḣnnSpҰAa:e1% b ҪregaWm Ugyld"Dfra 6q	`)ftènEt hxDpZteaen? kcaF iate?M  H|.0 1 (R ) sl l}(p): 30!C`gr % full ,ppmvQEa}Qf7: Ka#utƖUA7$c%%:0Vo(Les(@020!+d0trib`: IDv01s=PS.M.A.R.T.-f`Î8E F  GӀ#fNy0Be0oft njAvo	 g P3q JɱmP m v likt ``0 Ý2Q0aeaoka@qA3ogs$wՠgliudaempe!l`Fhΐ .
QZ/"rQ
a=p. br ku, Y  $mP Eベ!&`vice.`uB_?ed(ФW 0QI  
~H i HP tectTools3curityo Manpar.'-N$l8@ lanq6paPpus GLsRѵm9Sb&!giew besk02AuR+/- +ຢW%lXA  . v3gl`p]nosh,"x@2=$p8Q U. K$RmEaAs0orwd- ParllkwFlashiPPia LAN Lysf  USB2!Cpbus-k(p@qxp(S wCD-г)c[: H)oW2:eG 8ilgtP1E h'o9 b`BRUKERHOVECD-: GN umu@7V EBi+I12be Ⲅ@ \tryP
P   %$6 #
W,X`A` 	'P7Y 0; 4,OMOEBvhjelpautomED!Lock 1!byQWdVg PhE``!0oigPd.S  Øjf b rad=`PB$ՠC-or 0C?	H|@u/n(P.&cJA1s h0@ddap~. UR82nommPT 2Q@V0YfX`G 
:iPneaј:# urWP. Vmnbefa{2 ө G	Q/׃XB} A0k1 Frד`<aoo!1ra كI7$0%0s}0A!Xטd!ans O@E⫑v
, QPEGSC-Qx1 @Bx'Dy'- F10h[bòe:iĶ o  .1NoriFǋOrwe MultiBay'^s Qdnn(vee) Юko.ngsb9a0hhyOB}w Zip-U
Aq A0 !ba@Fn/Ctrle E le(USA)e pekeen`!el` !jermtroaVideo0@p
Tis!rrbp0FViA7ti` Ԑ01 m`Y=gradi`/~trdl |t 
WWAN) OOHOHBluetooth /-ft mи"1|	SATA-CDual Cor?e-pros$
baroi Ag`nss Nsty>iH1Z k.1+Ġ-e02* (vp,c4b/!@1 Eth́u?	n3	3 `'qR1P@N&s0 oo`o/
BD #&KCi2;G1 
P`lx9XC ($uEr`B9-,\]F12-[DS*epute P@FpR?BIOS 'DMARrpĀGQP!ԡ^ 9R TilQagsl قEqs QZA!FC Ȳ :@KɃ׀F.RAj00.0%pll@A
CfFe `{2vQE5Xk f`[sykl`r Configuraci0Gm`adora <F1=Acerca>~rchivowormel SCma^qШsR@a2PNMfdo`c	bfa9 Ign
 ambios y@ Spa A
p gu7  GFnlepidadA@se|K`ciobF1posis_SI>дtific e  "}!ĆKskSm:KC  So݂c0#<) Secty `P9M inc.da EOr9b WponibilteegofaOcЦ c3ِ8:1fbrp)6cnci@]	cDioagn@co*nprueba HDDc0+OGV'M?emoriar	a)+mPPkAap/+,`.i ; 	JDD`L#= rDamp'coK grI
o:.o?mW#i>H<8&g,rim "P7quiqfec0]VGinO =],A=CaP5lALap=SSNJ1"X, Coa3	=MsBv"fy0obɻd2ei</10rav&Pe,ds6m sancn~SetupδoGuXwadoft . )U@s:iRkP0Y y: E \ o -> = Prxbv+dReces<-y/ AB S	3*# Mays+#1C+/F2!0910`tGs $b#$vuFaI@#el[)\À35ΠA@locVUGuWXTamaAlh (L1/L20 OF chu$Hsǐ0 Aร7meraribhvil2vqMrܑ9aB\coplamQ'`)/ !e .1
I2
3
4
2s
qlQeb{oodEtiq r@pieԉ
I+K (MabrBasoo2oooo4oj? pn:$  ?Probanup.   %w(rssfuErrpQa ;ll2ReoC 00PX1'	lne®di]l+
(#Co00co oFlexAd`:W EѢouir  !eǖQ3.Chhcx /6, 0Dsc e cuA:D fTUu00P| N2qޢנ!련
S^`vpus"(I$<ԠJ0>o(a) PC!@@%w?,oe il@ 5
:1 (Rp`).;2 (l QF3 (S.M.A.R.T.) CslòtieDej@R(@s): 300 Vg`o BT0%0#Db f!ȄEЦ%B ipx0Grrumq
دbH: s,pu @qIS`>nh7S_ervof 4>0Dapoyatatrib`: ID00abRexws  G
X0Yi0"nuev ZDPӆ Apa5gE&S`gODB".		@e@GvocB	b6!ala 
0c Lt!ad ;Ѐ>nsa ے"][֥L7 A*# \ aŋֶm (025o,G1aipUs OF Et(?LL`hقrp}S"f_ Glཱ9al ol XnjAPievjv. qoq  '{v?dvWapaAu9ڱGHPPctTool )%6!EQuickLockQNSuspen! Blo^ratS  6""`nMmeja< :0 +-y	(BI	( !)(P`0r+lg Rt0,"D,0X𶠌uPizQ,. ̔xHOre PunC  rojo%lpWCMLme@7hdem Ino Wake-on-Lanns3luz | :g	s USBE
1394 RanCnbusJEx0:s{rd$qC#D-(
EeQuPc.ChUPr:avPUsio:a@uW5d` 'diDriveA0!@"( tUSUARIO2R PRINCIPAL ѕsoe lp&| ^aSman] p 0. A; y gu ,@~`lugp3b  phj1<@mpgQ.p6.Q @d e`lGS1
!A=bDvab\ppF. U0"hoau bEmch`o@;]HmbeddSityBI ކWcinb   BlO1`PnQX wDRnAd@w( R0עhuhc}y#tGngBn ,@l,Ρsm%m}u@tebooqj<N, !{osBtQ#bŽ!K !=b`yJ!u׀[D0aA!Kcub`\t! @ qШbda`?%k	,b bAgr gِ7Se 9oenf 9Ed 2lic`큠܂ re3az. ?k cu`q Ͳ>Ainҟ#˨2CtTB"fi @[`
@|ܩixpons2u9`, 0iِӲ ESC. `"Ԩ08b'&e's  ,F10 c:L&2sqfМ ŧ7CT/qEspaol OҺ`uMult'iBaBNPb|pxOCDfMbbco+(iz:(jech-  byI0AEʡSu@x
9kdZipcme0ᯀe Te]rIo C 5t#jp x SjOv No&D Cјus Fn/ TIngls (EE.UU.)!aWӱqmpplSo!~ele$ b
b_ a"Ac@ PGְeo MoPu0z~!  BidiΞ Tam`&CmO!i#	si0fuБ BSICAHRP1 WwWAN cor1L BluetoothA
1{Pyqho#ergR( ()yn SATAPUnclepogNp&zbaPsu`	po0osrj nc B7^B(s!3ior)Ethet, aNT 1/,2/L3/Tok0R lO(Or1	23C{qD2ԃbl21- Arranȑ.^p@B?`c<U_D!:PpNgŢPZ P8aH@F9,m GF12OJFJdpJAmbTouchPP o UN`u@T0s#r DQ DMA~dBIOS L~iL5_@6d}op4Cclez½o R4 lPYPersKaHp|2b`<t0Ps8`9.  Aأ`ѐaLa aPO%Ẃ;CP0qc0Ⅎui	N	  GrPs|
$ 00,0%rOletaC  $AE MgavBftFCic1cPdGՇQO֥  <F1=Sobre>`UruI-nԇs@S ePE`$G?4padr0(ˇndr3	sIgn0crp ``pairsp+'seml'Bv;UQna n	hDa0dgOpzar v0~qsW/t  w(@_
@j
&Q$SKt sd⑅O&p
"ƿ  TPM I b`'V`KRn`*6_aS7`cvA
	R@ -U54fbr瀫fautq  8Ij ף1lj[a lagnsĠ%TNGoHDD 1A۟ VGrD?e Mem pPA8= q@ -ciBu?Sele+isx8 8ampoinzq]`G44o?>	VUw
!x;A+C% sss kalt+in ='oSC=CelAceimNAKR, Q%oup=Mais^ o!b\it]t
Wa@vӁ10,sL  seeePSetup!KGuSHBwade Soft UizPsqgw cr u$@0 ->
PAO ?= PrxL\{<-QBACKCEp#{TABP&SHIFT+ !(* F2 	O-: = k  9n`ULgTiP1adsRbVcPPas\nhr@he1/L2Ԧf>a\ ROMAs s N1BWriXVReviAn' m!Aۚ
OBp 4
#cEti`p mFj'B(E epsono o.o	&al fd :Bu$@B}g.   %o0#foWi a v!'Wal ޾oWalkq 0J g1i	apӶtenekl ƮcҫnqGPP !ed0t: @  4edOsac0*VDò/,|i um Lvpu: ŊA': n@Ad N S3`p@ jO"肣Ca	]
 v!@և2ztaI= kTctߐejCa $,C? iӓ͠N >ߟc1 (a2 (Abgf3 (S.M.A.R.T.r>xecuqz0(min.): 30p<%andA%?q=beucedeA@xp!hostDCRr01#: I0~ss-P $Eg
CheЧ(*armesc e l %Q3sbPtrib@ɁLJD`0^!Oa xa`Ls waQUUi!g:Trg$`rƂl Ls  ѫLBaiPArr1rDig@АsQgp6 S%`GQS o%@8modCs5>  faz rArACV QaQRs, rigorosa (S"9pcurity)`4ҾrІAfJrPusafer0؆. Woq~S]1l La o2mrvios.S I1{o`&qZ p+QV6?eeWPrpk
8nS.e#QuickLock1Suspenso tD¬$au ttaR  1W%1n+ mabpdP}0b%I GAd 0XA,$"""@.2PL sa giUiS, o u3seu s0ema@ExigUJr	e)PbO0SP <0perme@$BQl0r5F5h0dP&re`Jam"rNs0Xuz ambi|Qn$s USB139SlotCbu&E
xHssY!@GCD-1ԯGkP!#Fm1e:dZ@usuAM: Vocc0qI" rҔuRxo0DOrive-W WtaqIWUSURIOJbMESTREi0<P ,@1?0񆼓D``apazB Í. An6X4@de-pA$V`is`I3ıEp. N9v@ev/w_ ,!` LAiS : bB*vfa Ldef[fa5B.H'7{ \ &H. />JЍEm?beddedjhoB
e 0(1Usuvz%"pn0tEuo,$I EBpa%g,mߡ#́k E]RB:a1)X5n   2xqu2=Sip`R`'"!d^ G0tgP岋] afA]P@,@`<aF  4oPPRea-
f ࢊSRcatp{F sub tudC?h&3+p-l BKy2XLs"AZ  Lembre %,HvQ1Na+ÔbӦ
@2quiq`mpe< ESCv`^%`  Р pA$Ӽlavυ'g'QrF10.rb
A:Mr*TaAcV]S1a AAugus OЏѺ˖: Mul_tibayNd4ƉD2wp2܈pbBaa baPcopld(`RPdiAtCRbh
zipriomeir"rc QutO„v ߂cim`InaтAs Fn/CtrlCIngls (E.U.) iVQPip)si!1Ay SQqhpౢ0troa8CRߡde`cund a @h LPadrBiQTahOmem0OBys;empy fubw F>@{ecF0CAR 0lm sWWAN)` @ooLokBloothkAAnPڀ(a/ EomCEnergp= _CPU DC reg.rp.AWa GereA1ag$2JceG21v9b32o57suЩ`070Et0+netg	O`p
/*3/CToken RingOO oSflexR@dapҼ9Aa>`hS@PopupW`D`y  3F9,i0F12*9L duplos Vsar7Na NSumV@{s#!7ws DDMABIOS@~@es o{Pop䚃lez"sbl Id0  PGersqM!Eopag1t RT@xq s<.  A2eьqO # mC PQzA
	
	'R"P
$ 00,0%lO	<a Erag+`| oif Cic0eatbA0vTi Wk 9/tukP  <F1 = ja>b!wJrj!lmtQt Nytto v tu`kP PP0 o
%jnsMkon @lh` mup	 @l0!ta Lr 
 tallmat7!WT^Tpou] aurplisuu/Pan m1Kyn1yM k La@tt8%M2@
ila.f
pusnume'- 
t lykin  "'
$ nnu`kiG
' TPM Su#etC0&T`Q0vy iss? Piil's1e-tehdf3fG$" 3t$&j
8ߍa -in`s'cKi`05v`
; 9O]t$0k @ Ea5np<h:m*@G;Kieli(@ePpk Nc  ha:1@1/ (2H..2'J"2'C#a!SistgNJatkm	jot  nppV =$
,=jD@ơ=Hyvksy=KyllEi M, JokuJ=LPx@XY KatPA#2-[JDte@o-Sohj[ oppaa`ko+``L.b2&aL`3se`avmi ->Yi VLINPPINdSd[ <-bASKELPALAUTEdeN!/ÂrSARKA+$#tV?AIHTO+',F2n+_q= 7eQs"11ajw'io ]ASyyppRIn cPgaskhV<"=1/L2#>~qu  ROM-P-vQi%  -@s sarjaa Vi`N.dst%abko3jpp)0` `)@~Ak&01:b2o3I3o44m.hq|  p|y0q.(jatkoa) 



\	Z:e$\\`^a .   %_c l鄐Np!iviryhaʈepo3i Walkq0 -[1Yloso@QgVaihtoe@ <`Zuvio^'mkkeB@̀us: T-0lG@T!patvnhp s. J` uNluoxpzus-  n,KuirjQonc -pA: L"  +eipvu {C1  1#70A^Vv-ǺHko{E@A:n?kS r`  H?b/i ((N :2PQaW3.M.A.R.T.Ar'ѬPi(min): 30\
%s x%Lxd3 Is`^Q pysљi30Lke ]V8t-#voiHc
b%u( ;K*jServ?omoott0g
cLu7?ma*tuќ@aka-ribti2`P01@a 6` KsetQJJ=x:hUusi Vahx`ba DwdB!2A"+p2u"a	-Êk>p t/B v y4Nk@{smys``TPU,,kn v	R$ۡ! ˀ}e T 	a
@p2 @WUOOTjWnF un!nu<!kyselvelpahtum`^
ZGzabEJ /vii R⮀7HP P@ectTo7olscuqger -ap	u3a\.#6iB!lQuickq
Pa hiirlPV A1(F ]raU '
((Pek`
U$iT)@xddAy!apypzyh  p ƣ8&#5Q en Rm.ad:uuA0|	ASAporK InfrPnRP"akkaisq |"km4emE5s2lhr` tB1а@USB-<"`1394 nCardb tqi 
Lxpr.lCD-Ѿ-l ((ąc3wQ@ʎ%P:`߂TyjMWAiot'\Bsn DeC-(u4,)0$:.P@O"`' KYTTJN|C10 PSp?SANAN,0f"Xs"8m.ra A- Ԁ(`ltur0Qm  `]kaR0bՀ/sir
.Vn-`P P,$~p㖴u1wLLAPgU0nuOW(5y  op}s %V su`mG2?E9E,#tuHx	>@rr$ Y
 U 7kUr
 \'~UrsM?. Nykyl RJ`+RKw00b,n8|
tp`Y. TxtU@iІ$ãihqeip=Pupe1r_D<eh?  IPa*?-v@f!e1tHta_0h=c OAojAaiem  wֆ3tz. єV qym "3 tbTV@ G.2!`ZX{AF_fуPĵ e@1vw@ o#\@Xc#3,aT>ESC-nsR;n,\'%'A>!F10Y4aQa:	o .VQ llіxtЁ Ȥys uBbn MultiBaOp`c&6 el ĲmiuU (ena/$oi) q䎂b)aZipEnsimmr 0BbKyoelj@}Vi }KRieZ!mKakps Y KymaiP Fn//Ctrl"m(Eng`(7USA`UsP 	s  a!ҡ-@RsѬ&nAjBs CڐPs Volhpq kio$s2sNc0Jg`uu`ґHA Dl Ѥko WWAWN-roHLOwBluWothE @/F@hA`KLի-s>ATA- @s Dual Core -saFEaAgpU VP@Ws `?P}0 AGeb 斳31iE\62V3- 2 (ylosP2OGCO=Etherp(vn9E Yoeo3o@To	k_gOoH workQ-G {8E !CPBDP0Br7 avu']>AP `i@ (?eoI Q@F9:`k:<p0F12:i ZPatap{piqkoskжP)mK`i mjn BIOS DMA`iedo\`>o9tf uhd閡 !p"Dpoo Nope  ParaMuQ Tț28!w kki1 `Var`b6ހ kyt ty@SqNQba uho{c9&0㐤Qle$ ?00,0 %Qi8uprhe tatark S1n1Ut  asyklipConfiguratiordЕteur  <F1= propde>  Fichier? Infor # @. ,m/Aff age R1urer"
`}sЗr df*a c	w duGIgnc#modi t	qu1S7pe l'inP:auvegardvns{regom	\ Scu k8+`e
:8p so$@s`a6rt		frent @NBl'&$IDy'A 3
Fq SmartCp"Ur)r * rph 6  `b#a +3yseTPM F	ʂgre ,priphFP qubDnibi:??? Masqu %)#pH
f+98am+>'u lX;?&,?rB"c Mta ?Pc)PsMi0KAct$FoVV ?mmoir`|c DN`2D! !ILangP ChHP`1Indu'@mps g 6dp,r PUX
Z\a[V#ೌ4G>+ AoppuypCsuCn goucPipo P[ u@b=Slepo r, ECHAP=AlgAccep \0=OKuiuN&#Q_, N'imQe@WepvD
=Hn PQpЏ00ijlP Sp,w rez-vAU0smprZ jMa lk@ri QxPplogic s. AUPWq3ai`-$`  - :-> ou BARRE ES?PACE = +`}u%IEprecep@։eTAB`C*'jMAJ+iXF21= !u-#!8&abry0ModeuU a=b Typbu
 KsVv@XwDbi\TaiQ'ca1(L1/L2)lu DvtFD ROM erf"Numro3^P#
Rv Evidco&qp8rlavq/0yo
c'auF"	Tqbpe	1/,2/L3/l4*1iC2ritaQ[y/(Qŝ(`6te)q?v .OOOoO8Oe MiVi :E$aqqjl.   %mrussi ! Errq#up ^c;Walk0}1lig$ d`!uQfq*C	od al,лifSgl@ Ati7J0t Ca;9epPrtru}CanpWpni1r&PU`csnQ /PRS, z{ 0 P c`	!da0r1;A!]4av
 !tro`c
 @s	a@_[Raފ'J.@On tm: XfinᕤobEzcP"a)i2{lP |OO?&@-M?ep~>1 (rap`)?2 (clet)uнex0b0im@C(omin)C30́`s CR0% 1mvD;<!l'hA+BFerrqF: Gw	bmHinnucd'+,voS7.Lu( 0IAttrib!QQ: = 0oSpk"s S.M.A.R.TAba1nGXY AIZ N!=aPY.@7/@;saς$CЀA`rP v KS n' ;A,(frgco cc 	oQ;mm/e, vz"I*re4`ʲƀT	@^Μ
L`aS?pe@a@"cX!s@uBs1u@?i_DB ǏV*.,r0bPdpGLla# ps.Ԅ8z!%pa [av0nou T`Q$irb.gy	  	֑ `UL'ҮfonnQ  ^q>l1egaQPA!hHP PqTool<ey0r =%:/_& ckLocksuspendb~Ű`!ri;$ E3?S^&ol'Ѝc bqCc8jM)ad@fnur,  x k3//  / LA'(Aa
S$
ud!rv
 NP
dra+systinppqpQ`ZExixp)Q@Yred%Pb  4ra Q8ll0F[>flash|rveil"appel rsP_%a#pi=`ambi0C	s USB	1394(n$C@b0<Ie ExPss d GCD-'EpbpalM^@Sү:>?&DɎE Drive2. SII"J%Kq!dez "deux+(UTILISATEURXPRIN?CIPAL)*#N	Ф$aloari*% N`DzRa`` O!!P,*tsr= biffe9celu/0ՓDordi 0@s3. AubY ZV@ 	(`{W_2؀oz Ifetc}|E@"$0t"~"a"ɣfa"!GoaopVD [D""eR 0ݑ^N)eFFSanr< `m5#'kH
U#!2//r,B=ϻ!u!  3`aH!! !! {e`VW
g%uPRn'R1d3^ :HHp" "" #opa8uEb#O'}oW'aRi+hw#1oroiginIlR!v`O2CaIa B	u(
vqS"apAQy9ɗt0M
5Odjav!s[oPbce*-$WqaPprsp ע ~on: to 򺑿Qa1ө440pPZabЂt3k
Q7j,a|uyPK `  ECHAP.@ hTzzR'o', p"CraDF10Tap0SX 1xCxY^u}	Uڢ/  FranaOgrAC@tЈiMu?ltiBayul UR.d2DpX,/%socqv'a(ga!)OOFy)m	q7Q&W
jZipÛ : D hi @s QuaQCinpSwixi SeΑ  Hupd NeuvCD`Perm r$(s F?n/Ctrl˓= gAngl0SA) PphH@ o1ms A@3stanpàhnNd'L00adml!trlS'Ti#ch@&m`
d 9ilidÂoBidݒ/1 mmoVl0@j2EKalX $Ӳ R o<prйWWAN (r @0il)1Ogr
LBloot!h7Sk/?1Po`$c0Wif @A&obPldoyChar rapДmbaSSuG ga^ub r0WPfexФs7?1bloc-noCB2ooyu{ @	=ccuod4ogB E1t* 1a,23To=kRingo to/EA׵Y:>b\AmorC=5 RetpZTeиecy)0J F9,pn.qF12.\`apos0fJixRLD aP?tDCNA
cunXP;0BIOSmQHDMAOaQ4@T䀡j  0 jr R6 rZs@Hs #va6AsJ$ P!Ԁ\fѓ!l6ѥVnpk QJlpA3cႠְÏ	нtruБV	»ֱuc0@ơ% 00.0%aE / I Errv@~cfCy0mżalat$Qc Ipmzl!Nlt <F1=OInfoi> )qemagisuezzaxyRipr0 faudg@ř0` aIgnocP*! {ed ci EP l'i
`	sgalv SQ	etupa@ep 7sswҿOC	[ens_Op6ֲZ IDp'` ID  
h	# x%Sаt CO SCupcTPMHqgp(S@oRvo)TniϐIPtohe Nasc04
K	)0w7p4i fabbrp9	!I3Q2nzib#[?caa4`$RaiJ
 qdi Z(V0R(a me qiAW  `=O(%IDL`}ue 0$Dim@L6 r6asso  eA g@vv!G7oJ " qDI x9*apkalsiata$qak"uր   =, ESC=Annu@aADuteo=SiSN1!T,al7tro#	=A bba PӰP|`u! SQS,  v]XpYt=h  h!"OGuida dwq\uoft . UsQeseguGeA׷un'e:-> o SPAZoIO =suW@vm<-pBACKCE@cx18G~ TAB@C'oMAIUSC+)XH F2	.=  Xm"A"I}e|dutto|AAllo NP7boo@_Ti
1VePSHSt'epp!MkpԐ/(L1/L2dBD@CROME#a  NuCme(aAڧ	Rp=cVp'4raoqI2"erMbasGaggancA	~Ba  D4bG`M0 PY  P/Mpcѝq&Ʃ(G) 8	2
3
4M:d:$ Ttjzg .   %$OIupZ!·0 Eom|lTSprbbit 0 itQTdira	 UT`e ['vFloppy pnso:fD=ŀgge'r "`uTNch`cA_punS/rR,   -qmfavq f	Pړ q_'u 3A:, U{A:@.n  t0o ciuAaNJ I

qQa Nl / YPIbOy×SeRvoMgu td?oiepbRb iwure?oҠp: A?051 (Rap )62w (Clet"vuti o (): 30>A%B56a0"3'hD5 @(CA:3sB@-l'峆P P¤(DB-%Aervp̓")L,!0BQ0'	n rib  i0gol:01NR7anŠdeg`Yi S.M.A.R.T	.uT0UHvecchfnuo2F0` q(`#U#L  LX?pbi$)dʲA {@v! \Ⴊ?v)6i6%  iAmP+AV$fASaWa2>K<ng0M"	At砶`eq^DЏm3Cee1,<#e ~'.!R^@휧Fovobe+rdAdKd@ xEff+!Kizs-oin`ari9 qu^!0`vgaO. Qm 륺  %psnJ͔r@~u,Qocq|eV1p|ϡe HP tectTools&/R2y `
ick0s_uspen3Bp#0Z mousп8 M] (X( fO#A#Ъnu p'!oހ&F@0`e$)B
) )`@C4t!`Psm]H0vaa 	,'DU#Sari "lQNR<(@| RVa0  aQ)ǰ$eL1`h pWashmgnA\SQLANn؂_u0Na!	e USB Slo}t@rdbus@S6 ExssbBo CD- S&,dHf^pEp:_C!S`3rqcuWsanD e.. D>NCX  r]V[l'UTENTEPRINCIPALE  r 2 !a manq;fuŀo.o\VNBfk pPzYp_@A)e1JD@PjBP4. l`lPaupUSTjs,fh	pu0`ao@ sab2C:re$^r.!TD  6TAgo`= ! qQk rGH!tyA,@",d@(e0As!jAs!<πg!rV!luog
Bw 4"B@!!GN a|t~ vN8A# un" G``By#2дsm f`0u4yjC  $"6|o!ӍPZ4a p!)" (E'Az% `DgPd Bip 	p1Чp`^l u+{A+u%af$PQQ;.,Զ+CB4w0quR`9"
!.BZ) `z!BFG@ nqPq0d  L!RCh,m0"qo GESCfCN'){N)dov1rk 'fo'poRymnF10.  Jk+z st`\wT AIi 3  O 1:sApb\ $eUM MiBay baNgga0s$") ogCh iB 7JQ$SukcZipPP7oPP;Terz P*OvN@ec AЦ" Fn/Ctrl T fIngl I (USA)$A@Yi`uO mpl B Legacy07pl 5a Ր[ BidpHACapacѪmemq 0Y5CqsbFa/lلR2C10wO0s (WWAN){oBluetoothCommiu	/ (J)Csm enGerg`anva SATA ۼPPrapi bѿ0aq*8$`icu8tց.1 N2/%2HB2PLa62(P o)ol4sp Ethe)tW V123e Token Ring'pOE3 AV  KC`f TU7b|QiRQq (@#.)SМe`F9,A_PF12PD ْ%Z27CAC`\Nu@Tras cSDMA BIOStE<As2pu`Qab V  RPpxc"~oc0ctuq\`RsuO.  AG r <q comp08 cQgI!C<Qd𮢿cM CiѮtru1	Ӣ$
`fsuo0$ 00.0%!P "aO Errrs<BCiclBupAmup Arkiv Sysinfotc]s~ }stllhfpn<ardk5Łenu>ka nd``o ochsl [`5  
 an0l) S_ Sker8ps -l`ȢQKAStPv#olik@yrCo;rn-IDJa/
t @ld-s5Std fp8, !Yav 7 TPM In?byggd  IZ s!usi=TillgPigOeaPl(fabrikP#H,Jsbeh"%bsktsagnpi@SjlvtV HDD Akr_V Mi̀4b)a#t;  oVljПrD C8nedt00-X*'ck=r2"@$!sX0Tryp valfringT nuX ps =,q=Avbry ;aFD!bp XF, -V=M`YQ(2P om"y3S Ef s`` Kt Cc m i Maskin-XMuhQbo. MeQ(ljReUP5Sdu  DD: -> r MELЭSLAGSTANGENTEN = NuOyg<-BACKSTEG FregeyK TABfa$O  SKIFT+Hr'qF2`),?="geOwAh"I@tk `O, mo7Pr, ty hAhpugCa-rlek (L1/L2)=d ROM-0`umGenumm Q6@0#<43b i0VyrsRBqW9BN 1.z234cgA0RU1
o {in/ (@`;
ITS. :U$  TaZr:.   %EZ!\@k!ðClmisslPades WalBg 0s - `P f1jHr Add s litp7Ae P"!n#`W k0E@ar! DhpWqsttidQneh' NBJC[sWkap` җ/!-4Q^i skbN$рA:`ϓ
feaouDIhеtfqISpeskyddadawg

*r@ifW Onp5o  ?ϴ iд?gRӵ`F0 1Pnabbf`n" Upp<  d kR&d (0): 30Ppgr= % kl060`2Tpp3ьOvrd(a~Ӕt8:@.t q2$	AO#kB'S!*1( ervo-L lî, |r*V&`|ttribut: IDz091Bnskҷ.M.A.R.T.-5 G` gNyVa߁
nAv. ? LD4Q Ra6d 0Ҫ mМ0"m聩 krOvs  tGLOmCBrLز?k`  pap321És t ex!I #S! .	_ŠTa F;s&AGlo. GOPm  Thpglm3Adtj`eh`:else.!1P `uqucZ`=ǔ3fsunЮkr  ưAji HP tectToolsF$I	l>Quicksv7elge #Lwmau Hgk
gbhB)`7sadzi p&n !!!+P'go"Js14bliWanz`d`pt. KL7!omGip 2`f `"P`l o Flash-9 sSenBom`=Bljus USB-qbus-kplats ExphCD-s{ T(Sx HugvudL An: D`1 q{/hrda F. sC4qB abr ANVHUVUDHdPmavt W.3aP`H `%PQU`0Oild an-A
 MNuUhxp@ L l%upp<-l!DT.A] PAo1 _TX3 5bBbVg@8glng\a1!b  h
. !na LAcni nD Sk0hsk@p7c
P@Edim	 
sRG '-Kx_@ktupa*pt,sojnnsa PWuqmмsutQatg 0rs+b0\`QZyP3yurpungd0APO. Vi  reko@HQmRF	ؒc	D&rn qs`b. AJT ф2l3g@eB1gWA!7-be0zfPrse>`vm ih@ռqfljjns. Tr = HESC-tuA 1ܶ>"fwà23r_'B'.9sedtF10Ui2Fa:c䧑shh~ Svoka r: D?, M@iBay?pNp[0Bg6h Ba  (`}r  (haҠvaw|G@x Zip-c<1FFj!p1Աstto NRT VxPFn-/CtrQlǕ EE{lsp(USApkdAA b mrmsPtro2w,xffbbel:!SS`plek6Peo 2nekYl ZPa~Inbygg`1siotr1t1K (WWAN)LBluetoooth p/() -v@A=NƔmbeן SATAJxCPU:pSlad)eMkr0rRAgrssBh1aAB #hi [~4 (DEP)C .-1,Ĉ2vy[,pp  &-Ned Eth3& 0	3n ToaRaPN T&"4(rGjtbrp4P 9d/sadapl< `Ddrj%&R (%.>F9-,YF12-| F(Sek)e*ABd StyIrAJPB g BIOS DMAaBsC1۾Qg[ Ȓ1 ZmAnpap ҄ 07 זK$d) GH< Wproc@8F RӒea.
i00,0 % klEB FelAB=g`afiSlumpm CqcykBen@`e@P~a@-  f>]`@ QѪA@& bemconfigu`Wijzig#ne`«q?grammaaq  znr wop sl7aanopBȂs`veiZgqwach'twos. 
`6. A1OaatbhOgl>$ ID's 	WG!\ASmb!GC7 OAJ@ufv@c(c#mȧ`jQK"O
TPM Ge	`N@oe 'Ptusp%sv΀zie2!/ch7ikb0,he3 !  	qFabrieks2ugz@CsVref39opnieuw5OEecpB bzela -jf5eai AcOvGeheuP@1C "h ACgDf-)Dal!a Tel3ec-emK rijsg'ema @Rl 9Ao /97LsD9Qbouw )S&Drup `U0ذ{eYgAL=S
,=Annu@DG0=AccceAJacNee fi,t^=M(00 A`u[P6aoam ݡZ) 
v0t  #dCompur VR]  #Hpel90B0q8P< dw1YofPTre@olp>a`ruaiPqb  X:  -> of SPATIE?BALK =7m <f BACKCEVorqij TABb	c&}SHIFT+%S(
 F2-K1= sa@V cIk@þf-mode5yspebnelRU ppx Om@`jPre (L1/L2 @apac&i@RO+M--sa enumm@d nqrevi!Q F$dpOb`c7m0u 1$23140isЋgIwts atjRe'n+$Ԥ(nW2zijde
  `DKXt`_ :u$&d w0t>g .   %%rhgen1gd!ou  djps7$>0de-0-*1TQpho BasrlQafwisQknd pao!pOа!}Lop: ^t4Ǵqsks 1ege@'t P
"fb!ofWQ A:|gSg-  /t	1TmapӢ3e6ะroffaGGoFa\\f isFd "AB@%a

o@g Van#afWtpwO`h͚'Weu kuP 8Jwil"6Ӂ?С"8"au{?`
ZH.1} a).?2 (Uitw) Pe vmostG (p?.): 300ߠAe$d&%~too 6>P]`ho=c8broa+:o@XqE@geqd'onbfDp42#@kvo-IЬsC&K2G2dezL 7pk:Њ0hMU S.M.A.R.T.-a~afPaSSv`ud(  N"/xS݉aBlok.b   aK-W =V~4qkcm!A00mPVX8
 Vr!5@B@FS "WPA-ke(kunn³9&d,  zopikIv S  ᑶ@A gqG f_W, gF zerlo@G.p8 5((t 1u!b"y0Hf/houd 'H : 0aP`JS̀Q %r2rfɺVHP Pr@c?tToolsH) 'o蠰 $S `g3q# TשmumSt_@H$M"gC zQb 6  erW+$+,Qh8PiP(?(ag( o( S(62b"f k@nP@,@HsMyP+emXAbs  K[>A:@\Q"Չ QpP$t >fr5apd  P  Flash-medialPY Ir` m8!$Aia Pnetw`W`doli BbUSBy-"	1394 ?  Cd-r  'HNQơGHoofHGdI?}f!)! Awutoc DqL>& C`grr#KR ]0HA  
-goedL!`j=Yq6bew1 T sP2PVucomp@' 6[
aAM  n@ P'{50OA"3U1@p1 DA(  zowPbCO O!2JzFF!4A) !6,pMawA B!!t J!. Mo`/oĬP,P    c; $? = p? 5 @hui ѐ,̾dБw~was to/!k @OgeaBj. 0Կ`nvlp<Bׇ kra snjkd;cUE0rkra>8	!6CtoH/) ;ge#t. o
 s vN.dun
`h!LefE&aQgolq O ubܱA,ͪB$~bh Q #ײep3ruk3ESC-  (A9 Ul 2T<Bu'm'typAwv0knRF10 0@T*pZ:KxS4ѳd '3i3X4 - Nel 'g MultiBayk@tiឍV9&Fd]Ѵbase (ks)re"a)#5cÎعKp-B E`we AѪV V Zes?Z @A@:N Fn/Ctryl!wiss1ʶ'0ñSta"MXNijs'appaOu@e Pa@dl "-ij` Vo-aG0A+ Kd`dition S G!vg=uyVilat  ֨䵳ppXdr&pRadio2	l WWAN%-aofLoo_Bluet@h/oP-eniepʠ SATA-us cesP>dubbO @Dl2]secu8PDcu PhѕaVQ r1 `jAefF7(b)̏dkEtـ 1H 2
3aqToRq/- OMow0	23fE⳹a7adap`Pfa> B(pp!.)po/p-upsq#֜I"F9,`FO12 (% OD'gcur ݠtu2+EasyPod-qG DMA-0drB BIOS #ge!z"g\e Saniti6 (n)scA 1 qa` AQp akWjq0gePVtZB tijps ced1u8@sl!I.G|*;`lo`\`B n!.bQt0/0,0% lpIGx] Foua"ld_V<n`leke!Ecycli  Rs[^̃ZbgA` viSETUPj <F1=o W> t@C VXσe ɿւ\܂ fHgɐݒ  Hꏟo׎ <aɖ%ύXɏI } ۑaAȌԂ܃}`eBa L(a
=eLC +p00h̲d8o |g Icv,e#lID B%hu!NSA͍폩T  #}
Ja  		 )0*T3OHTPM S, 0)o,X"p Q \  -/-(x"B6kFظ
= ؖ 9ώ
fM@n1% 6B 9*ZP6t9X!>LɆ; `Fq  ׋? PqFt2Mp1yF)@Hp4BCP#߂AI(D8`Kp
 OPL"`
sHu2-0u"$=V#&$	8L[Cݢ]10=
A/Esc= CXsA5?0=͂@㢂)aRA ^)^;K []` ďڐ\́A w$E0!Aу\ag# K0bhx u[CySetup]vQzI̈ȉ
n gpYA'jaj ?e->F`iy`mk = ER  <-3I[BackSpace] b%+ [Tab!A'&[Shift]+gF2!///x`
pmF/[p"%  z  ɰޯ   ۾  xïݸ  iL1/L2"OM̓t 7&رٔԍUrI  ް ۰ްޮ ޯ` ްwi ޯ 1#2.3N4	
mЁun"p[As ^OŰ? (4Â)	Gc	-3N4hZB[F :$\aw .   %'^"cj`R0!̿G[MsE Walkq0s?1|nC Ш'h1U;p^Ot"so  x:Т2bƁAW ⥳ B`?ĎDHa/p쐬=TA:@o݁ȧ
|
}RO
  FłиW	qX`֎~bXopsOoCǶ  āB`kzɢH  OŇ׌ȯН1iNй2i׮S3.M.A.R.T0 \zsԁi?j: 30נxB% 9 OK z4C7`E~ 	D: @	)gm኱QE3kT{ǂݨd@"A"4MFIDt01 .1Qa  U`UEpDI&ܐV!' /}2B m@!LJr>?(ᕌ檓#ͤDLhv"SDbA?߼ݤtN  Ǘ߽܀|KvQB9AɜRWdPwȂ⬀J& 粨u֌`Ȃ
!WVNBۅ	b^œA"g`
Y@cSԓir	׾Ƃa7dh!f
ݯ?b\@feviHP ProtectToosls!A}lŒǉT s#j.0@oMu %"Tph؃{-EPO'OHpDJ8-.))Tی삪D<D%蕴  gz4 Q(!ϋNb8vӋq" Q ԊOD Gu!~=3V 0QlJpነ_B}Vӌ`6T  USB^D1394&Jpo!Xg ExpressCardFCD-Ia 4
Ud&-}^ Y:'yUKѢ*i KeeC'5D|g `qa>`2*	 ;+@bE`]AT@BaleU#1Bqi	@6	i"!qM	͎-Y  y PSkȠUǂvY )M)N/5/@`fƓRh^C`gC@΢Ɏ
 >BS綂d_pۏ؊ԓ`łb͗Lŏ|Ck@qł`k)/)%)@G &B:J`wvqpbv+̒*6J OJNՁ	(lOQP%a֯)I*A /*!j%p
F*    p_2* b*))g ̬Fpo 衊d=4ɑ8`&ƈ)gO3 fR?ɉweЅ^
fL/)T3"j@3  GD'ȑO"EOCRB@hr4%6f̯ B&L:ȗߨqlӔ5C`!W2h?BG[Egsc]Q@ȍ~%n`oaVn@DriveLock ߤt['F10>t @U   A{a=7$:  ;`A:FSxuJULJڂb O xuioiEcaB$	bXP{p{H Zip&1Ԗ U2b 3 4"5U67B8910r Fn/Ctrl'̐ؑ {_p (USA)ѡ| B#f0CXbKV1(v@Cn_g0 `ƮR}dJ_z r0Io W~ઑo%ACY@OAǐڑPiͧrlbNi!WANj%ML Bluetoot$g/#j?ւpȓdpSATAJC+uURACPUi b튂̍[d @n?sh~0.1620k2o2odhEthernetX& 123 g Pq
AOKO3O0'O3 Intel  SpeedStepR tech?nology⨭N(H0 p_PSdް Ӱ q%9x(b) F9AdF12̱i!bB +_ERE ^`bIB1  BIOS 2 DMAO]t^Ni/aVYpgf 3 œKCcTmɀ @bتc}IڀK	KƏ#xq<Kׯjw00.0%չ̴@LtGoHuf`u I]N                                                                                                                                                                                                                                                            ` a b c d e f gt M  (         	 
   
 8            ܭ    :          bc  * + Ұ  . /  0 1 *  2 3       % &   ' ( J    Bi > 
$ @0) ~ BijBi2Bi!Bi'Bi-BiZ3Bi"9Bi>BiDBizJBiBPBUiC <BB<> ب`0`8l v x|v||p/0pc   c 20   =
=$$$<   DD_D  A  O aƄe  i  o䔕 u  y !$n$A   EP%  I%O   U &Y'N' ~ `' ^    E)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>0( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)Y;+(:*[{s\_}\|      RgtBiA   VgBi@ &@  ZBiQ@ ED  f@Ԁ&WBiD@
x@ I o ]PTq R\Tr?r@TsUAsBTtCtDTuԁPvFTvGv; 4 Bi9 ([Bi.ZBiRXBiYBi\Bi]Bik@@* D@@U J{Kt|L|Mt}N}Ot~q&  PtQR[H 9 !
	$
 
T 
	^Bib
 H`
`
STU*ĄVWąX` Z(6{&@V @ |  * @̀
 aZ( }
( 
bW^ _ @ a 7 *  }| | 8 `	Gt$ 	)D@@*TcP "b  @Qw Tu`T`ƪ4#y9  4PҢ !T@7 S2
#t t!Cq  "JT G02EȔ2ʔU@

Ud  d!U!d""d##d$$ W6  f$&U''((j	 dIT#&*>%@ 佣!"!C$" 
 5 @3Dr5EdFF 5 * D " 
      *	d	NSx ˔0C\SGz  J{"    UEC  ;8U789:U;	<	=
>
U?@A.OU@&^aDb\bDccdBDe2e%Dfaf(Dg)g3Dh.*h/Di0i1 Z_
BiFh*kU+dl,l-dmT 2^Bi++%*ԠT$a@<T6&qSO6` @  : ( Scd 2jjtkltmg &e[fd\d@G GXhPBe$fb`?el:  'mF4 u:g" h ij_ʆvpj M<@ H N b ~@ @M"@ , < V h@ j@܀ @  > \ r@ ʲ@M @ @ \ h ~@ @욀
@ : R h @ @@ 0 N Z `@ @
M*@ N l  @A  T@ " 2 F UZ@fp U@ }@M(@ U@ X x @U @	M@ : R f x@ Қ@
 @ N n  @ KM8@ L j Ux@ @ MU@ $ < P Ut@ }@ 
M@ U. D X z@U @5!@ U   @U&@X @՘ WM4@ D v ը @T@ @ ` r  U@ M@"@ `   @pZMU@  ( 6 UJ@Zf| U@ U@Ȁ M@ $@ P Ux  @S 0@ h  ը @$MT@ | j@Ѐ@1@ j   @ @ ^   @(9@   ƚ @ @ 2 < H Z@n @ʪ @ ?@    "@(08 >@DV` h@n @Ԫ @ހ PM
@     2@8>TAD^@zU @܀M  @ P Ud x @ @T>@ D ^ v @A* 2@ $@ U 0 2 6@U:>B F@UJNDjlUptx @U @̀ T 8@   D d U@ @K@ @ AV\T@^dx j@!@@ Z   @ƀ " 
@ N h | @ #2@ f   @Ѐ.$)@    @% $@ $ 6 > V@fj  &a@ : Z l @ @'`@ Z j  @.( mR@  A @5)G@ UD V ` r@U @S* j@ 4 H U\ x@ @+TA. P f@U @M,M@ L Un  @S-@q@ D b U @ЀS.Q@ X z U    /o@ B \V ~@ 0 V@ P f | @1`@ 4 D ^ j@tx| @* @A&S
2U@ h  M 3{@ | դ  @4^@ F \p@ @.5@    6v@ @ T n ~@ @Āܚ 7@n@ 2 D V @j 8@ d   @9@@ r   : d@ j   ;@ n   <@y@ l  Ҧ =@@    >{@ n   @4\ ? @ U2 F t @U @YM@  U  @U  $@>UHP `@vU @Ѐ\\\A\& \F@d @j BT@ \X @5 C@@ Uf   @#
D@ A*R  %z@\@\\D\\ME\E@@ . U> f t@U @S*F@    Gò& 8 @ F@Xr @ȀH @ @ Z  @К I@ :J b v tռ @&JT@@ : Z ~ U@Ȁ K@@ X \|R @ @L 8 Z r @ @M@@ V ~  @ঀ N@ D lT A@U @SO@ 2 H U\ x@U @SP@ 6 J ^ r@AU@ S
Q@@ : N p@Ț @R@@ D f  @j S@Ҫ@ . P b@ @4@ T@ U4 T r @ ؚ.U @ V f ~ @J \զ @VT@ V   հ@ʀ2WT@@    Z X8 J j@|ܦ Y @ b   @R ؀M Z @ ( U4 B \@hUz @؀M[@ ` U  @S\@ d  5 @,] @ Ֆ    ^T@ X   M@_@@ p 5  `@@ UH r  @Ma@@ J RT hzU @΀M b@  U& , 4@<UBJ R@Zbj \ @րZ  c\
@\ (F@p @ڀd@ 0* > d z@ @\  e @ 2 L* f |@A\A*@L f\
,D\N`f@pv R@ƀ\ @Sg@@ @ d U @ȀK"h< \T UX@j 5@i @ Ud n ~ @U @Sj@2@ J v U @ k@ \X z @l@@ 6 b l @ @ހm@C@ @ d @ @\nT@ f   5@o@!@ `   AΪ @IpX@ : \H UZ@r վ@ԀqT@'@ 4 V p U@ @A rT@*@ > T f U|@ 5@s @ Uf   @j\ t 9@ < R v @ Fuf@ \2 UN@t U@΀ Sv @ 0 L U| @*\ \ @,wT.@ n   M@x @ ~ դ  @yTF@ H ^  U@ M@z@y@ t U  @{@K@ \.J > H@\TUf x@\@ "|-@ z j  @"}@"@ p   ܦ@
~@e@ f j  @ @%@ T |  Ԛ@,S@ j   &^@ l   ަ@@ L h  @ @  @ X d r@\\@[@\@* @Ѐ\Y
 $@> f @@f@ 4 H f ~@֚ @{@ V t  @`@ \d@\\\D\\\ ( \2D@\L z\@k@ T pR  ˢU @@k@ f ~  j@@@ P p  j@ȀR@ N Ar @A~@ & H p @j @(@ B z  @ @@@ N r @ @  @@ 8 \  @ @ V x*  @ހAS @ " 6 UP j@մ @T3@ V x  ո@؀&T@ r   M@
A: UX r@5 @ a@ U\ v  @5 @ UX   @M
@@ N Ur  @5 @
S@ U, @ V @ղ T@@ Z t @բ  T@y@ & B N 5V@^  Ul@x M@@ \ Պ  @T@    @@ Uj @M  @  U  @S@ 6 D UP h@tU @M  @ 0 Ub  @S@   M @ H Uj  @S:@   M *@ z դ  @T@@ j   S@[@ Z | բ @@ h t @ 
@ V b ~   @ʪ @ڀ  @  $ H ^@~R 
@IҀ@S@@ ^  մ @ @ J n  @@ ^  j @A* * D@jD\~@\DT\ @M @ ( U< f r@~U @S2&@    @E T@@ . 6 R Uv@ M@@ F U\ z @ն @ @ N f @ *U]6 T | դ@ʀT@ N f  ] @@ F ^J ~@] e@] @ B l  @؀ @ H* j  @Aj] @ݪ@ 2 L ` l@ ئ@  @ : X v @@@ P v  A   @ < V l @К 
@ > Z z @
 @ NR r @ռ @  2 J \@r @@ f   @Κ@@ T b n @ @ @, @ t j  @>ÀϪ@    
QA B R ]z @̚"@    @& @ 0 ]U> V@bnU @ @T ;@ h   M@& F@  5    @ UL j  @S @ H x 5 @@@ Uf   @S@@   M @@ t ՞  @D E@ f ] @U @K(]6 ]H )\@]fp ]Ux @]@j @ЀR@ 2 BZ Ib@]p5 @рQ@ `  ]@4 6\"Ҁ`@ UN z  @Mހ @@ F Uj  @ʀhA*]ԀD@ D ]vD]]]@Ȁ U], 8 L Ur@ S@ f   j @׀٪@ P j  j@ @ 4 P b r@ V@ك( L Ud @5 @@@ MP \ @ղ T;@   B UV@r U a@ 6 Z f n@ @@@ X *  @AS$ @ B V Uj @U @܀S߀@ N d Uz @5 @H@ E> V AvU @ԀMဝ@ > Ud z @5  d@ U8 \ x @ @ @ 2 L `@x @z@ : V x @Қ @@ R b p @ @ª @ @ Z x  @Ѐ @ p  j @T@ H `@5   @ U\   @Ѐ T @ < X d Up@ U@ S@ \  ժ @"T@ v   M@@ X Մ  @T@@ ^ ~  M@@ j Ֆ  @8Ԁ@   
T @ t   @,\6 L b t@ @f?  @   ( 0 8@@JT ^@h @ Z@\@%.4DX@ @ʀ  @ @ X z @Ҁ@@ j   @@ Z  A*Z  D\BD\p@U @ƀ *T@@ B R j U@ S$@@ Z v T²@ 5@@@ r   T@@ 8 d  ո@ȀT @ 6 ^ r@ ՚   T@ b j Պ@T@@ H f  }@  \@ U" ^4 R@Uh ̄ }\6@ UT p  @ W\F@ v   @ \(@ R  A@ @\*@ < F X t@ @
\,@ N p  @Ȁ\4@ X A~@ @\&@ L j  @؀@ V h j @܀	 @ \   @  
@@ UF r @S<m @_\@ 8 Ud | @5 @
@ UD X n @U @U @S

@ r  M @  5  0@ ~  @"@ V l@j 8
j@     @  , B P@`x @ ~@\o 0 P t@@ r   \H@ x  Ҿ  \2@ d   @( %@   ܦ @ d *  A @ 5  @)@ Uh   @@ > T v@ھ \$@ :T J Z@bUlv @U @U @}\>@ ^ h t 
J@ @A$T@=@ v   @
\U.@ R x  M@
 >@ : UV r @5  ! A* & <@ZDh@\DT\ @ڀ "4G@ P tE  Un@ S#@5@ r   @n
$@&  : Z p@ %@'@ < X | @j @& N@ J ` x @ &' ,@ < \  @΀ (@R@ T   @ )'@ @ V t@ @"*@ > h  @܀+@Y@ ^  j @ , E@  . B V@l| @ -^@ F b ~ @. c@ H h  A @/`@ H f  @ր0@@ X   @܀)1f@ P f U@ @2 E@  F* f |@\U @S3@u@ J f U @M *4@ R Ub ~ @M@@ղ @.5T x@ p   S6 F@ Z  5 @7@p@ `[^ p \ @8o@   9T a@ > P ` Un@ M@b 5@:@ U& < N |@դ 4;T P@    S< p@ f  5 @.= @ ՜   $>T e@    S$?@   M $@V@  5  &AS@ U   @+"B\0 H] UR@p UV \Ѐ C@  pT  ^@&U. 4@<RU\ f@tM ~A  \
D\" T@ @E  D b ~@̚ @F j@ B `  @ \A*)G@@ . R d\D\5 @@5 @H @ UB N \ p@UI @    4@8G@@MJ @ H Uj  @ҀMK@ . U> Z j@U @@Ly@ T v  @j M@ N Z v Z@%@l@ NT@@ @ T n@՜ L@؀m OT @ R v  5@P@@ t   AQY@ & 6 L `@v O@H jD ހR@ > b ~ *@ AA S@ @ R f @ @T @ V v  @֚ U@ F Z v @  IV@ : P Ur@ M@W@ $ U4 @ ^@zS|v @ĀU KU1 (@SX@ ^ t Ր @YT@@ V ~  @Z\>R R |ն @ [T@@ t   U@ Y \T  * @ UN@\pv U@ S ]@ J l U @ʀM &^@ | ժ  @_T@@ d   M@`@@ ^ ň  ,aT@    Sb@ j   @ c@ ( < Z v@ ? @F,b U @̀ @ d @ j ( 2 @@^@ M
N jA\x\T \ e @ X l  @ f@@ D l ~ @ g@@ V t A* @  \Sh\
*@8U>J R@XUr @U @Si 
@ l   @n,2n  qj@ U. P z @5Ҁ"k@ U@ ^ p @U @Sl/@ B d U~ @m#@ ^ j @Ԁ$  (n @ p   @ƀԚ o@ 8 P r@ @ p &M. V  @܀q@ ^ |J  @AM r@@ 8 R h \| @܀fs @@ Bs2 r @t@P@ @ \ A~j @
u1@ F f  @ v3@ F j  @ڀw@D@ F \  Ą IxF@ 4 H Un@ M@y:@ : UL \ @5 z@3@ U4 > H L@P\T \@z @{ $@ z  ʚ @0|m@ J   S}C@ 6 F Ub @S~ @ p  U @S^@ . N d p@ZMU@ | @0 @AT!@ j   M@@@ z 5  @ n   T@O@ b   M@4@ t 5  @(@ Z   TV@ j   Sa@ >@ d  @j @@@ D P 䀻b@px @ J@b] @ڀ T C@ L T Z *
h@I@S@\@ ^ v U @ P@ L@ B  դ@Āy@ H f A*UR ] @b \ \
&@EMT V@\~U @؀M  @ R z  @X@ N j @ ܚ@o@ r   @ꦀ@ : L j v@ @A$T <@ ^ ~  U@ S @@ 0 6 U^ @5 @ y@ Uf x  @մ  @ T @ 4 J b Ur@ M@"@@ ^ Հ  @T @ \ f n U|@ U@ M@
e@ 8 UJ \ n@U @M
@ . TAD@\vA @ƀ@@ V p j @@ D l  @@ D b ~A@T@ < L b Uz@ M@
 @ 4 UH ^ @U @S
@   U" *@06UZ ~@  @ j  @, @ b   ƚ@܀@ 2 P x @U@ h   @J S@@  , U@ N@`tUz @.@   @k@   @]@ t  ֦ @ L xj  @@@ b   @@ AZ j@@ x    @ h   @& @ X Uf x  @U @U @UҀ @S @ ( B ` l@x
J @\ @T@@ T ~  U@ M@@ X U~  @̀M@ T t  @A*j @ \>D\U\@~ U@ M@y@  UL z @ր@ b x| BVPnPBi/  /     ,   P DSDTDSDT^  HP  nx7400   MSFTC000
 [B
\._PR_CPU0  1
 HCSTH %p
p
 \/_SB_02p34p\/L506``3INI_ g,{78
sISMI
=
 ! PPC_ `
97[6
12
NaA
 t a;pa[#o
a
?BA!C

D`0`
 ͕Qar0rtc3}c
c
T cEc
['b
0\F2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 710ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD1phg	gi
 '12kg 3 phpi 0%f%`'fg`f b 3f 7cufbc'@%~45E
Microsoft Windows ?ME: Millennium Editions NT 019
 jA1+8D5p\_OS_`p
g*.ag)`5
braQ914oua
 !/D	"
6p B[IW` 
%2p?P> SP2PB6JDqp@8@>14A_B !+8'BHC
$fpig
fHiPE g0Ih Frgfata
apaa9aah@*ha `a u
 bbi+ibub`\1M0E1DIGI[K
0E_HIDAJ	_CRS-F)
g&	 V 
   W@W U  y 
 C022  3J24 5C@6py7
P26@D"6\F S28X 9 AY S2B pI2A@%D#O_ `
EB9~A7[PF   o
,[	FQn30311	9p[
 32׀ 3B
o[1 0A`
34Q 5 6 7zA8 j39 AH3BA[  @CD@3E@
bFE@[E140P41+42l8 3*44m45Q 6U7 8A9eAB14D!
07P1DAEZF0u50Q 1 2 85345Q67Q590A- !5BCQ[5EF 6D[B(v62|63H665H6@U(7b 8 9"UABCBDEFa70b 1r 2"74@a n76H(77b q79Ar7CMB7D
c!pp4Da}aiapa ib{{ab[G027
_C~ _ADR!:&:  _STAp `{	
Fp
q,V808 .82
T
7C[P:82 qq 81 D30PM8383ED 84?& @? < A285 [#ڰ	6KP87\`p` p`bS83ewe` ap` dpy@cCdc87
{a
 Wb di8U87bbtWd
q9ruR2dcrdl84` dza_
axf Pfuff aPhdu`['A
\a
AL

   Gk;
UsV` H2y {'&89 3[!6 BQCpibpkdrd
edA
d hb @brb

bhb%D  EFV8jqDS9 mE8EcrBbNC090!warp8Aab@obBomo
o
buoatb
-bP cPpa%
o`bac `9$91SKRn`k8A
8D  8Fc)EP}92P=aaÉ`l92@24_S3D{
p 4D
`vv93U< W

vh94h @4[ ~`95 [=6%@ 
"@`Ŀ97
 >a@{^.Qh2BA8D9F@[gI=H 
A
`
[N9AP9A%9ZAk9c9E2n9cAcAcAcmA3AGAPq 5  wA6 jAjAjAjAA pABpACAD H
 ~`$04 Hp~eB0

 r0B0B1bzB?2 
|`  @ B34QGQ4 x5	B	BtB829 K  B	@{B	BC 0TBD}E`0 	F	 AC0P
aWCV C	D0C3~C C|C5"C6o
<[pZC6ЂC7  @Ci8 q9rCA@?
[! UB2CхCQ~CQ~CFG0D0_GL_bp
`{ R[!
dv`J`aCD!CE{h Tjp
p
HrEP>"anCFb1a_p	rya
c}cbaa`D1 (8` AD2x0 D3Ehit`y`j0O D?4
hp1ǏAA: p6 9+7àa+ADY*GpzD5qaip@"pA6`RMbA
i5^9M147-+r48p
Ρ4E}jKG@6D7
@
[+ PD8D9Q A D#D`.3DD CDE
A`9`C
	@  z{` P|a 0 
bw
t
	wraboC
 1@BA(U{c bx"OL$F
pI6'BE0
y
rw i@H,DB}`"Da{@ ` 
p{z1 wi`1{a` tbQvDFb {C11	_9`pBw
h pcN }t  Q  A12
ccF~E2
l
3E3 @BE4 `E%v@)e {ky
\p;E3g} e? j
z4a{`V -xq5p #@b}e
e/\` !@	e @e$}` @dAyA4{k
\ 	P`:}qA
 DA yp!-A_p?d1r68d `D8"9 9eM@}E6q E6 c`dyce@
QTE8hif"f
j
pwPEbdB	!ba'c|0|!Dby
PTAS6CTH@BIzBb(p`Abۡ	s@bB/c`yacaABw'C`CDe  dBP@R`TAAp
T19L0R{EBU 7 !AEC

mECPED EE5_PSW12١a[ED r%DE[MEFf0FTЃ 1#	FP1Ѐ				8					ĥB	Є		9A@			4 		AYPP			N5='[M1c!7C3 b#BA#0
[@pFCU 0FD
P
[5   FE K F100P O: 2  @34105 .
  `6OT 9P72Q
 0D=:
c8
  :p
APB! 10j$/10'P //.E 'E//f!e!(.G!G!@@($3( N "10'10//M 11@ #F  //@A eA !A N  A GA "A \C U1X/#3(a3//.`3' /n0a0%1a0%1a0n0a0G1a0G1Pa0@1$J/C A6H //L 7@CG 7//@@@h@@@13T/ c09(9//.A Sg0A//@ @@@@@	6 
7
HC	PD	
#  'y  Q61@ h` ؏``
``Wapa!P'20		wP`	1V`P'p'2	 3q n	A`vO_HIDA_U?ID
`$^^.C009B!_DIS@x)_SRS h_CR
S1Cw	aCr)@$ +b!Dr)4;cE r)C I2PK hF r)2[(iA0r )$	j1r)@4+k!2r)z7pB8>oBA[! 
12[E9 bpN2Pbq a<@GC [#"G`c8Uu[AK9DIv1(W 7J\._SB__ISMIEk[#\_GL_phC05wBpi` Cpj q^/`023	k['2	Ep5BJ80RF`3@,A  31 2
L23 _S3D
p 4p 34{({5
 h
``55 W` 4A%@7c6CK8
57`
{i
 }`h`{`h `p`w{i` @ o4$ qy
9t2._DOS3
` a|![^{Abb ha[$3# `qDC^b_34
 G 7 SShp@Հbh@v3D
d
3

%P3
:
A
H
O
V
]
d_BCLaDE0O@MC\n8
}b@"phoa`arm0Q0O3Euqc v
vup84C 

 a41E35	8hpdp
` {\/b/C8
x"`F41D   "Q   PpChiAF`
hD'(b\G\/	H hC |D|D"c142
 ip=C0D4hj	 5hij 5.43
Y?@kl4Faa[G`Wj	_GPE
	
@[U
Gb bPGf mfy R45R46R47RR4}89

r4AB  C`
 D/_RE/G(`pKp* P)	iP48Q4}E1[G  @@P4Fo   50p #  1!2)5U456175895A 5B5Cz'555E 5 6 61a62134T`5A67U819AB!CqDR3s 6EF070 p 1s 2@p7V!7456k77 2779 A BA7A7E1F80Q 16@8283 a85 `67_INI %88 Q1Q8~Q8A[  IB @\8C&D-t45t@ 77I78!s4518EvhP"F|`\!`c090	wh
@axa
db`t
@` _@	
a
@}a`1
y`g}`a8B81!h azw`
d`xr`
  
o@bau5"@2~	86w	p9[3	
86BA9t`dD~n6} }Pw `S95
q 6s 7
Q f139BSCSD
EӐ9FaA0
Unknown 
NiMH 
LiIon mG#A129F3O @  %99@@h, !9`a 7a# q[98a99@*A]98 1A29D@4(7st u2(P9A'QA@p1L}Pt97a{a
^97}Q M95!3 
Q!6p!@A3	  :B%A4	`nUp
R{`'IA5
[)h`p 10`
csc
  dzir`a[)absdb1/2*(`cocC0"6	hg3
A4g
B|!095":9F{`g`@&7&&8hBC ?X AXa9Ћ 9 62 wa$Daxra
c 
dcbpbbe9EEr73*74*`ap@$0/5g5$@Ip4A
I+Ep
 W 	ip
q=SEU@-64!665Ecq7c9 cX7
{P``{	{``PF@9C$>  9S2ccdp eeez
cpecpci6%4?1 ep
{9 9E!'E`p
`db9DA~5DC-NCg@+nN)59Q-  T(
>
>KE(P2;pzт
 5 cP%*!F(B+BB6F`*Pe(!1h/E8C	82ata
Ƒp
b@zcRh!
C	9
=
66a6F
@ ra 9PQ@tuJpaHf:b#%2h<fCiU>3c3U@AAUBBBUECCo [
pADrA
H{P   a`75
Sp
SIMPLO`SMp
MOTOROLAr`wxE!AE
p
0 
񂴏00B00D00CAB0>(_Q03W<D`>b4aY0"\B1jlPR_CPU0
 -1E5`]țTZB2Pt 3
 ['W1 oTZ3_PJ
6q
J }pB4
G1ׄ1y	N
1_2V N8vǠ#
D5^6#
9qO01169֯_5316

,^Q
{ (ui285iA4D8$7.11B8r49B1p
7AN@E
F0AF0a+$ Z2B C[KA
!BB
N 	qkBDFBC p`BEFV C/r 1 2 FC3 4!5q6C7s 8 9CCBqCC
[  CCEF D0Dm1D2"<D3 <b D9px
Ua+ 5A
D1M DaD4a`| A'C4`
5ºP D5@OvuD7ED8 &~A !ѕc7ba6cϡ3g9b@|aA
8BBc10D& ya
 rd
b
 bdpdS c
 c
c
5D8BD9D4`kaa
v}aу alba}b`b
vb1bC3C7pb9q !9#!d5zj
!%A804D5=pA#'2v1b_b	a ^0bbDR
4B@01 נ`6&C
̘BE6"C06" p0
qD
{C043
`{  ia` `D6hp!
`!`K1E	C6hA71t0$b c  d}yd`xcc43abcA`(KDF p^^C1E0cIE1L
pE2

G?y 1^SE4 ED0(A	 pEEP~CE2 [ۂBE6G_C  _DDN
COM<E7xE86
30U"  u  8y PwS `,E8vpTAa`!9@E7QD
W+_DIS t042SE7@
F_SRSah
aA7,EArA9+E7@
_C~`1F

 ` c

pz$NBA[SEB   
CB
__ON_OC&_OFF EqPR0B[C:)CaiݠEDpi`  02*E
."Ȑ4Aq@)`sE Eq-%H
1 Gxx. x" *
 x& x(  *o @r^r_ _ u\//.F.ppM%..0!a.b.!NYm.PF0`/./ F1 l/3pF01/n(FG/
= *00	bPNFD1
3F6F7#S`4444F0s 64S1X5_5S Txp
 FPF7pAVr ѓ @9R:{S:F8]:Y:_:a ]:Y:F8)F9 p\/,`P00@BPadl(ex`I{UPq Y v/YZ K{0C7
BFԫ$d1!FB` +
F  vAFF200W!
G``Gpp 	    Pp )L_eP1b50{b1c ҇FE
q ҔP& 	$F*F
2
=6N$S	3
1.
p
4 
5T`7uFGV]$_DSMph`{ @@6hijknJ ǰA Oj
j;
 B
 3A dk`M`Yנ
`
7| 39~p^5c
 Cvz@H}@·207h
 C   `5D
` 
 
Y`E7J<83Kp{z2 
TA	sB8Ipk7ϐ1
 
E e 
N ncE/9	` Qp`}`
`>Q:%055"  "  y sBw@ @ " _[5qf: 
G9 G    _ *"=Ce>ҭa aW !-?DT@
? p Gr rր " E` `0Gd[ d"IFE
" yC10
[C11p A @pw[X212" Q
&sO.
    }[+3"     `w@C093214_ADR   p215
D
[ 
6 INI^6[p7u8/z9 wWpq<
P@B;Ф`O 1BPB9bB  Ay нhuk0E192 QT6AA['`G	
B
>
[!  C? I	 
 hBG2!EF   
0[ C220  @  1Ap22sCl`VM
FFFj	a["

@ dNh1Dưpa}ap'|s d20a -#(211$)4 .b`ce*%
	
@p	q
r03!}@`( %C@
 -'<PP


@[J)	_RMV pfEJ_D 
\.6P F5 EF @225H` #+*
@*p/ cDPMCPH
_FACEL;`2D E 
3PC
 $@Iѽ<  |D0
;
 
 a{aW pD}2DARI0
: !
H!"s
D4
fA5
Фa	>
 
?
</=
#C230H 30@AP006`I\/#Z31_L9I7ĠO
#@q0
8
?:O"
<F4h?	H
CLRID
bKpa#1Be6bo@р1AABI5M  a{`a`
{`
bb"ALRD	/!4h~3!ALWR
?3hiQDALED	.h}7sC7-7A`%	|&ypM@S3D
 S4p  WT
k [@jmAPF5o
@VVrV3dPtV)WtVZ@ `Z`ђbCX3_08xS	
# A9O0AO0BO24O25O26Lp\_/PICh>A E%T EM
)*   aUT$j́ HHHR# !#
*
 


GC%
 A	a@	ᆀ RQ 	 A"
		$2N	!	A	aq7E%%c%Ɛ&"cG-	93)B):)$ *a&+G
!AaнA9@	F

PR  bd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	8Q4 @ 7-9؀q L$A6qfnh`/`%
 ?6 
" @
m9h35`=pA	35aAW5{p oaAha`S8hAuF
_UP sO@0BIFA{ ST 60CL"]_4pc;?;:6<D`ܰk 
ACPI3{ _PSR oԜR2aE`|H"PR_CWPU0P1pb ` bpb~04#`#Uaq 96 p7]P%pa%!3<[:a
*!S_Co8  ڤ`$9
	/15?@SX&w|S&C

01 N}Dj2&E  3F p40 1`k1k` u`ph`piaFa?{qp
 a``ls }a
aap`k pap  41ސ !03 3 Q`2/p| |`P~`2z`hp}
kyj`  0>3b1`h)h``v42` ibqpbasabcpcau`a44
 5 A46A`
3=6a7  ! Q"M5F8LB0o9iA4A &4B C04D	3@ `= p
 b P  `pr
` a"E FDew0p@ e[0wre
 
50N50\.#32pFAIΐ84EpepO/ 4ASECUp~AKABAC^@1bwr2}3R4]5-3SiP
c;6cp
U
7
	8U
9bAmUBBCFc@AC
   i&t09סO$Dy5DYF60"C61i2SE263$6e44$ (?139u!21_SIMWE6"T____F,O0FPbR1JT7  YѕF "b W` ψar`6ZPGASSa:)QI88oaOS65WC05DP`p!ap}	A a`!!CT [SU; %2YC'>atbab z`ab ubP=Ng75x&sm6`ph<piK7#M8M9,Fx
fcqq  WDGD
4_c,E=DAAyB{M4C~ C+KGYР@!f )AB L\Fǿ˛K^B IK--0AJ<	Q3BC' h5L>j<BD FΘ@pEMEBE ( /2IQv-BF =2=f'C⓭BG  6dBB$BH  5MI
WMAA{dijKpW51i,trqn20k`pP55
E}| !sD R5E{h
`?{`53},`(4В056bGPF6P080
*5c2    F 360C	4/x`;{B5O8i 0 #cdk?$?p65A61KL
2P6!h1׿Ch	R07P=Q
1/  a0@7hL92Џ&WY3hHB
FbNa 
p
1##== p
%*J6"J4pz	p

p
-a9n
hBb4nKO5A@22U b`m	 
 ;!:9G1ƘjyPi]@p	
u1a>C
 g{zr` #&ПBFD j\TAD[¼bWn[b^b^b߸r[bC  
@[ 0dDaEQaFa70 @U 1 2!3q4A6D?
p
D pq3
3
aT	 1B203Ѐ0qp	?Q
`p񰲃ղabC?>;`rp?Q5N&
BIOS Configuration Change 
 ~!
GSecurity 
An attempt has been made to Access features unsufully

+
Unknown Event  e  typedC	_WEDBϠ`נY175`z E? Hs`ÃA8ҊчQr 96Rs7!'a$7U!$8 9%ABP1'CC074Q(D_
  )E0*FV80 1!U2p炱3 I68B58A !"$1A1x1r1DE
serial po{rt8F
P (llel PD90
My asseag21
Enable2
sDi 3
  w, *h4
* 5
 *PXE, RPL6k
 *7
 68
U9
Q	A
*Avail~HiddenB
 *C
xD
E
*F10Boot, Allow u|1rejec`No pro3s.BF
 I*__A0[OA*\1Y
Gb2
c3
,$`0, 5, 1p 1 2 2 3p35	       27O    F8O       ;9'@	
S874 
\Sys@[_\: Opr`sQa|d
`1 6
f:;? B	Infrared?	?	?	5	sn?	?	=	J?	?	?	ex?	?	i~qCD-ROM#9 			Q?}			Floppy			$		z$
$ternfNetwork Adap0?
?
?
B.?
?
	.?
:
 ModBg		d8	SELECT * FA"HP_qEnumeDWHERE Name='_' AND Cur=rValut'arB
4OFwap Fn/Ctrl Ke`4Devic9ekG,??	GA`#USB Legacy SupB/
/
/
.
@/
/
o	
RN-Fa}np{ways `while ACwer



h

?


?Multib?7	-eoeGrJash Media Re	]7f		JF9,0 and`2 Delay() *
_4z
0q;0 U
1p 1p2 23pqyDlpI *St0ard , BidirPal, wEPPPECP?
(,=J(EF Y
PP@CP t_E0WExp|Popup׏XXX@2OWKWiMPmaCqRB-OM/T\$B?3P0wdfSetSI
s`=134|)~LAN/WP  Switching
=uilt-In )C>_
_
? e'mbed Btth%Radio//// A[//? ѸLp&



 




W

0

 "


+8 Sav**F
?
S~S
|

_	\PϕBA7uthHicCKC&Cy\mCoCoC oCoC`CV.	(AvailabilMW='2??? ҇
ompc DrivelockWX
/ (Џ\
Ptra 
Glio(Ul +++?oo
? W}=JRequ = P}Rest{


vn	I`Data EyxPrev&Con	oNoNߡroN
	 ߡ+ DMA 2Transfers



^

	bSATAtpC




_	ޑ ҿ	Շ		<O	1394					O:1bus Sl?	?	Š?	?	㽏			9ϪЏ		MMDusalMCPUO	O	...	/		Wake @n 	8	O W	/	FBAmbiޑnLighnnsor


 _
	\Lecoqy Batte Fas hargM??

/
N??z0*&, Hin?____Sv 
%	oActivate 0Next B?
1Ԇ /@${|$y rolic~*F1 toR, Allow us@rejec`No pro#mpwONOO OOOOOOOOPFq 
c) C2AACO}
!- OrdeRqOcPh .k =ar~(C:), ?Floppy  serCD-`sNet0kttroller, . NYB
;QN??Multib<  
p?!V  6Z_BG?d*^Γ`yXu` 
kb
 C
OIbOa$CB

/!
 

	iA
.DJ
	[~1\#2	43#`	D43!T5Cd6St76ECP%6`d	234567r>FNOLqssetcking Nu0ntag P;laHol@G9IDb!GOwnhiUp  tpha&PManufactuyr

FilenformB0,ProductZqIcor Typ(*JSpeep: 
2=Mtepp!<'Cache size(L1/L2)TpFF"emoSP!C2aDOOO!Z:'KDi V2Q$\,H=SeriO=-^z2NPCVideqRяu8_
KeyboAph9`>B0 
W0 
 S1p 1S2 2 T3p35B1ooB2?%
Sta1 sBidirp alPP@CP 	WMBH
 [ A0i
pj`p`ap
 bp`b dubub e0fpccC27EP c ucC281844F377c *8 9FA\._SB_C076 8 799AAϒed
f Neufa /f81"J]3
q 4/*
 `_K`p. >u``
 p
u62 u`p`c
 c0u`p
cucr`?
cFiaa 44
  a
0a
9t ap Aara

ak
pp aDWc d@dOdAd@ d@d
Adrd

d@d@0d}ya
 dd{d
d{pdb e u`  p
 g *d< *'e9A9d P(5?\C019!+ q(5 dv bugudvgF)
	p
bO'
p
2sLt1 z 04v bsx ; s8z.B1B3eFy/9`)F0 00000B(|)
p
?( ?(?(?(?(?(A?(7(4?(?( ?(?(?(?(;9:(LybWe7VFVVVAVBN"81oC291091 Y\QEHKk2a2fBID820Кl Port Modeՠ%'
*lg

	 
!`GggF9, F10  2 lay() /
0`m5
У

	  
P"D0ZJExpr@ NbzPopx ?BInter Netbk Adap01"y,P3XEr,;1O0dded )urity*viAvailabil>@ 
%&6l`86#W9HiDp6=A͹v">lic#y>F1 t@@ 

>1h
l?low us@ wrej 
]?No promgpts?C S#Rrh
'gFHJracki#ngs#QAQap1aa$~Aeveuduev@`^pjFTUpdZk4833fms5p `CH8%wOwnhip\
	kPtap066a uap smugA2@e&!d~cbvbF-tTYeQeBB"a@a@>,d p
auauÁv5EhB
Optic03Disk DrivJ@2 RFbD OH@3(C:JxJ	USB Flopp7
8
	@|i1Superqn		CD-ROM	t		K9PControޕx1u E
*@%OB"
 QDV4T՟r
'
gG`
u7u1fìa@`@6AD99qAbvA!E
=5f#
%avoaH$139{
gf
 G&72a76P}	236
{ep	F(i
5
! 6 7
 	
 pj`p`Jb`b dubuAM[cKcB=B5cc  QB6A(4@b;f eufa Rdhe@4a;B5 >uaQbRapa\͡PͅaVaY͂S1b*Pbbbɐ bPb
Abrb

bPb0s___T3BQ6`.p|7:X(|
A (&((~(oFyWQBCs1`phbK3 3{6Q b8jG2@}BB
4Fq 
!i9h P ߒ5
/ASEf/cy7E{dfS5d eV 
,0* *|xp0|fI>ELAN/WP  Switch!Lc{f
z
:
.z 493
W %a4n2ka!r	5	"z"OBluethRadio 
2M&f J0	LP
NfFbKJ	  fbWml  ! !f!b`~ OOH@998*7':IAӟ۪ۛ2$BBC#1A-D*L U4
E454%4B)C8BKǻParalҐr2àpsf
Msi2fJ4Qá#tA6
KF9, F10 and =2lay(л'hf
zf1bw0@ExpresssPopup3/1//NE$rBW'rTE*A* VFj 	0\
8&
 vqdc
*ej`g-+Pgkfggf3f8Nd dEqN;pyDyxyrhs
'yq"hyΡB[sxaBA#069pBB7OCW8ODuEh@6ABF7
BNC0pwCчRRDR	EU1"
WFO2b70O3*G1O4
r
50QF7(AЕ  A"Ap7 r1/B a1B0P%a[)!`pQ0`
asa
 MHz4C 	FC6A7nC6ar 7b3a
desd
/ fsfegsg
 KBiMcGw88a 9 @&b`bsb
	

@
]B
ġ=<F; H`E;3<5g";Y74`;   .9BApa NG
P  eGJݠ0TC`~  g1dgI8?UZOELeQ`PH`1e4?dnA` VKp	bb$d ߱ S8aa, ab 	d\\8g8w	A
VC3ragHG.ATW@qGCKCr*BpPCA
{
 ba bbC4OOOOOO@KKpFgBCWXS 
$
Q"sBs`Cp Hs I WQABFOMB     DS }T% BGFb IA ԟ@~ t(@ "W6`Qv GGnhQ ]R.7w' `T iD!D
qFt~Hp*~:ٜ`r<H  ,4"kcN
a$8%$@hl'E,yJIQD6'(%BX&v/ sq1Ĉ,^ʓBHhQ*L0\F)V -@THA<\=rgpIO85f|Ljh8DI=R`w2
^~&=ӊ1!o !#x(|8ӊg  Qav38G +}(|)O5Nw8|dqD99O"'@ày .?@~xH#Dk<B,SE!c|}t z7=.>F~ L>:v?K!#Ɵ|
 Otԁ2A6[@E0"ENZcDy2@{2F\,_p?p
zBS9S5Lg(-| ߙDp)3
x|@ C
`A'*u\aFYƧJc^I}1T7P7g
5LJ5j? j GG8GF \Rp4 G!0_h|ePBBS/?^}
!G!c(_|bPA"Hg@?

@7G!YN|B(tg*#;K&,}	YP?! v pG/ 	Ag!3:$_/=Ӈg!u>1MCp0?^WN	,0ȸFmۧg!A.#!Lć)	E15
,dx
x䟅a{2cY}<%^

53|V{Ѳq#: 
s)|rlV3O B!4DAm
P{9vt6p
:%jg3S	|1^d @Ql"!D3:b¨ cM=_t؈1!&ԗ"XCc7e0Ή]|:yt~2|zha=C8Y߄0; N5} cE]鲁Rs /)F0
ЏemxCmo(m@<3n\7 0*)'h
Pn~^	ࢀo oX~ |1
碀o `7(m=!x|98yvLp<hbr48?aG8 VmPa :>8t78T塀q2i(S)IC
<1lduK2Do8Dy߈bgP]B(/F#	AXOőF:x>x!9s{T8N_%L
׀3X>l	,!L`':c/|2|M0"}\oع:hN>(*`U`!C=.s>\gppqippM `
,I&#0() )ؓ0hzL*?0c93$Q';W
qw)+cFr/ul`9 
Xg<i1VaAu?+iGܢ
<ӂcKXl\X!!`IF >8G#}3{:"{ў-|x4B8vHN09y@ۗ6*߈b e., T7__^pq=t 
<0Q1ܷ9Jx;rhBOO>)
&P
>(>x-Nj8c85$=-#8<2!yq|ge|.hhd|A0쉳 wP B yV5Jg_pSd
SLuGQMTvZ`g!v]Iʳ/Yp ܳ8فup/D2 Q'YI0q WC )8pdxP F{ޓ>-9!SŃ1*ivK~sxUi"/{1
}#J=-c wz 8zz y qGP8~lG qCy 
%Rp;.k(!03O1{38Gvx#Cܑ6vp!@dCǎǎ;P10	&LG-c&<!"@> c	W<x~Z]Г9Ǉ,OqYܠ]k)C'_=YؽOuL9Wv!wI6
!g$~0<
3xG8ˆ|`uQ2;Ã7K>vy3`|4AM{D8_`EC	8P$8/>4y>p{P@=!3=FN٩wf?<~.=
S_>3pׇ
Mχ
pa
Q j/S`hg1TPg1z \> 3#*u>	~6Cf@ph܆
04zq9; ៣`]1۷g+6@ĂNFaPc#<~lph̑ƙh؀Rȱ)>8*W>1]7t_.|1/->!KR!ЀOk>0UW!I
|Ox`ãg%c;xp018PqC`YO_Y<(@ 8*8ۄGL3(a`Pg2pE 9g8C=h=kߢ)\*N ^
|yhh;Q熁;P n!>xTg;ᔎ?N5Gv.`"O	[!{sloaG9=xo>=0pL1-Ptx"G0a c,JWGV8i=l'PU .u} KP P#36cbbO6||}6;敄~ g@?`*n\( ,HGNrd{!뇇zOcy8±Ntp.Nގ؆#'Z*ŏ!,H{<Gt;KFgW9#Dahv#:.X%D׉gG:&Ct`?`4Н]uHwvz.g0Pae zjP \|8ZQ	#X-=}
_C|'% s1FTF;-x8ܳyx8|:^?!p6> G5`+Q9
#
uT]|}"p!^"Q`oQ
0o7V@Ol/j!<tQ
j<a Ql'??<  Ίá# p9*3^ȩ=rJ,TE
WOO18CI _^|1B
?]t1.wV8zgXOX%`X/0#G-c @1`	
XOPɣ P G݅1
.a *EkC^8U_	A?4X(~h>{ohzA|6v)P
/<X^x)Kw&ssf4 U<	&y
=MI08Jb?|p! B<H$NI_&<PFy43ЋdWI
~O,u,O1g ya #x
c<*$ÂT<Nz,a| }B
u	 p뭢dB9i#X:	x #$FpqTρS?qyni};\5 aNO%
67Z{p<8eZ]>,$lp,[=]ft6Rq 8!iGC:[/{ه|p4|!:m0'd_XUz	|;{/a	jTE00$sŷ|
фf7o:zH"y>8xRW#lPSa.v,\'쓍O`ǜ}Gih֗kg	@0 Ӵ.)Wx}l|13?HT'"FbhtHp0=s  H7}A]kǍ}gSx?8!^}e7}E	"hC<
ex(>34x /c 5> C20wG
wZMɠG=qQAtlP7qt|18.sGaF`ϼ`f'10Ż>.cEw9M0q0.9Op8G =޻|vbi
!U'0(I:5=h6=2 %\w_BOK=`XÆ^0Pzx#@q3&#&nv*M:L:#!>`3?k FyED`w:('G~I
 t/@>8Γ\Xk|t`\[{gy3	k+8j0-0"{+?d0>Qn`*f<+uhsw);wlO',j///oȾ)=x7)dcM(0l4FX@^. 86'|'}hM'
p<I|ĝ<wey}c$F닏 cX!} .!	4s YGّcEW`9G>~V@cQG$~Ns"88-3%v'%сrсx&P|wC9R;"w q
w07Gp?RhӧFV
(ӠVJ
(b18,%?boLa%pn#P:@XLH 1½bi	X$a@|5 L@z8&
B=0H@W@Mi51
"9C@`
Eby] rHr/ D@(hk& !j0=B
P1,"0pT	h*T 4% S
Bt TP@ޗ D@NB|2 T'#(P s6 Z1 4qsѬ 4;  y	AfBM 'h $AfoY=M"0gq<[ 4#}<0DG"Aj4LAP_+HB@@h^An~5A@&0j d@AL@4'
B|q4L"P}!iAhX x[=8BhmwߠP T3M  2&tR5`R`&Mp$*DkѨ 4> B 4 "D 4i	PD&)fAh ,

8LP"PKʢAhl*	,*69PD`DDa@h *
 )@,
C
y.G
B 4W-sx T/%&Xh
sd 4SADã ur S 
;| dR([C12E JC139[# l[#\_GL_yh
C05Bpi` Cpj Dpk Ep
 F\08hp `o	l['['`[C2CD

[ EFL
[ _C2D0P 1Q 2 3 
2D4 r 5 6
 #D
gpha CE @FK3>6'{h
 b{zh
  3CEC2E1h	C2B9 E0 DE 0a
5Q
	5Fp1	L\_TZ_ F2M

 #   
 b|a 
 13W

N1	4
d
A
7
#
qF5s 6
17
8
U93ABCDQE F3000# *B2p1B3
	0511B7
&`1
py
i a{qh a p
` *``B
2pi dpdaQj *h
}d`d{d`dKad@.e.bebCe buqc1)b
 {b
 qc `q
pzabrc
c\/_SB_C002@ 3 5C18Eo`K3
qpha3Fi c?c@/
hr@Qx! !4i `bb5
~0- th ph`i
{r`Qbt b
{b %p
bE	6p\.3[C` DbEaEa`+!ba dwd

drd
́

 P,1/at`sc/,uaJ307	4`'ppa+`q!{``# @$
51%F'8;p'q'p
|q+(`
O&aD`& E ` u` -aaQB2E.9t\/A>TZ0__AC0paxa

`bpA$brb
b\/#D0

b?2__CRTpr 

9	
 _!

G7
9aP://D`>A>8A=B	Eh
59ސ<b+'1D(4E'4FccbpcbM4A=p?0o

<..s:VGb@p5bq52bwb

araqpLapsOC14p`17182atpab"A)aPRGDh 0q2)hH aL0Rcpb a$/ RhE{RWb}[c1\#{\b pyHhQ:a"j`(  v`bB5`sOhpxFAq -`D H3
"bC/`h3rba(QPdC
Sp[h `t`pG`x`@f{Rf
8f
f qt;cbb8rTb8VPX=CQY'>:?
f1$CQBOCG2Qd	gpBhD*T07    `PR_CPU0 1[:`E@_STA z_ON_ZpZFQFF101xMI[=2_INI S*Aj 8_HIDA_UI P`0]["p3MUHFC4105H1[Fg_AL2 1CPAsL2AL35!j3 *"1&7$2FBa3f@!j
'_TMPO39Pxa# [H/PSV9p! L2&D_TSwP,TC1TC2I$
<B[9tx$[MP	3_`.V	"#?	s&1"|	[G	TZ4}Hp
`fffC179p	`ް
d`wQ`r2RP݂EDD316-(-#7 8 9ʁA Bp31C 0&D rʆ0 G31E 1D
[} F@(AJw20121 @[21+22z 3`oUyA
	Y` hF 4q1F0aJac
`rd
  b}y Ы baya
a'0asc  eraye
	 evepe8c ucdcM 2524cpcQbpbgC	bdp apbe)ecr17e f{fg
fape`pfafgvdueAP8` 5gTb17`${g0agg7agubdM`s2086`p`!p`cB@"`  AByC027 Z8 7  9 " 8h H?
bhhaېr 9cp"da
e9%-adft`f	:ru'Ruc2f;td g@r&:`4b` 77,7&-51526`Q&B0/
ܲbBCpibhb8p28пD9
j19AJ"AA"PF02B w6
arгFPbȁ0+!ab`babuaBaxP `bua 3/@JSQC`03v2-B\aQ`t
 ``9XD!

	        y q3C1HG	e3y2VkHD
 2EB
^GG  @  [  s3	7	P/ 	 	@2|K-330=R}1E0N
zG	 G$ $ GN N AP P Gc c Ge e g gt t     s @  A-`1FAq


W@Fp{
`q ^^.@DF\_S0O_ 3 )   4  5   M\_PTSphf1HAKP_jA wàpA23  5I6\_WAK DcGu-fBBj139I
_
qyBA0`y||
C150 F||A
AiĀ=*
 ۓ\@8
$ISMI
=wFu;2367"0Qe1DG)ɑq8
9ώP006 я149

O2Aacbcc:c1BE4`	ID@14
 +$98&M0EЯ+F`,`L4.з=;EhACELC22F@{11F
@rW
Kp\o_GPE`W32BC_L00 P3i
c?
`0{` A%{`
 }a
a  {cc` Z0a6~1B2} 3a !2FB{`d}dc76&{Pg)4Ba5H@1 F`Z9`95`N&*0C20PҠIsrIR103}
E.bF["
dGr2QxBDp?58`M
'>=`
*`%e3
 C26A
,81G`
_
C``aD`I<DP	 7'80.0]C
p39:z4/;I9 H9 H}M 101*_P lo4^$ \$R$S/$od(hC3B<93ICNSDNEPJ_L17 00AF_?`}E@FE-1E9aa?T5TUj7&5000r
 ["+__\_sB'J1}  C ߿CaMn bC7   p;bb!\o?Ƞ6aE	}`Fl30ׁ1XFNhfK5xQkWL Ӎ. ~["hSSDT:$HP  HPQPAT  MSFTE1~D6_ADR_  q3" 4% E_GTM? p
0 S`R5 6 7`DE!0E17[{
0#6
36vpOMhO	i p
w9pra:` Q@` bwb
bwVcib ac  par5c u0Ep !Б#
2az7Dbc34zp@pz +A[$@8d0F E4ې49A@<0$GC144
 
K TdA P3\j33S3C9[EB3C4p0SDD"!h+!ѪC

  ID Ec FC34Y0 41s`U2#3A_h
 4Qq `p8Dp3Ep
p
A 3CC CCCP
4`f[O _D,N,,,D07_E_E_E-7, e]xp
}370E 46q7446 )474J
KK2S
hT
LJ
6  55555N0NN5M
     a    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй 6s# hfP u	fXt  h ӦZY[Xg&ǅF C9   Ã tfPfS
u	{p  }f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tԎR>tK#tETfu
)0]t`t	dpX  f]ZYPSR uyvtryv&)2qStN tCu+?7:ǅ%. *'<t<  
7Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ(GF  :(t ffKfG+)a3  `49f 'D%g$ЊFb	蕐" F9蝐r4Vu'v !x 1l^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Ff(f.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV! *fKFt!hu\gvu U>tU6f뿢!@)_a[af^f!aFV  ^SQ  B0Qa@9taT% "G蔆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV,u2|r QERF ߳ u  ;&(pIS(]0`@h1	_S( Q  `f3۹ Wfs_Ձ@T@{" 2: 1Bj0 f=EFfC`?	5	tt$<GvHxs ?!"Ⱦ
Ќ (o
d
zu+
1?M藡iqp1]zuZ/7FF#zu #*V#$^fȢO_o0V mX^ҎD	%ÉD	f~?r2fpɁ v Ss<v PfUf f{ fa$f6f> f	>fBfff]Xo t @PyԁfPQ6[f_~RӃf3 ZՐyP5bރ?> t5z`50@@!|p5 ೀʀ
P}@ئ@x6Ӏw=f;tff* F#cG/$% ëӫqq  gfEـ>  fù& fσ;t)gf+ C k NH2|`Ekv tߢv\vPV;  ^fh3 ;u>; 0ҷ;b7P7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
o xy _TP b6_PSS N SPQ O _   _ _  _ _ _ @__  _ _  _ _ _  ?P@Ц?1?D?1ª?4?_>_>Wr;\/D<1Hl7HC0H9HF8HI_CST pP H`;Ga H	#
 


BK `
 
A
Dof`qI |T
9
dOGESS@PO3Z `C
OeA&KG&e@I&C_C1@__Q
&"1nD6nPmo:n\ pC}
nIST  3A1OU0(L*\q 1d`xL
 C"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)GpXq9SAbDAk
 |1 CAP0WIID  1 2	3U9S
S E  1c`236q I1223p
!
  ki
p

G}B !{L%A9D3	 
	{Β } q[` 0   [ I> N)J2`M5OkH!7Y!1!Pq !!!1!1!!!1! !!1T!1!1!1!1!!!S!C!1!1aF!!1!!!1!%"!1!!1J! 4' !
!!1kf`Hr faf`  ufc3pֻ0v 5 f!6j,gfwnP׋F GPUrR(W-nU<AvPUff>n, uf% j f?fZ	fhy{, a ufzufr],鸀, 
e j,z` 2<v1ʐ,nfWfA_fr1f
==rGX0-r2ȣ襆f`_ rRfGf>|,f r<
r7 	"g&V0fqf+Ug&D
|3G/a'faY
![ 4	 g&?u@Ku 	t`;vJ;u&9OpCqQfRfVfWf-sIg&Of! ff[9
f  +pffff+g&f70^fS$@f[} @    	`@  R|5';;O S !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXh˚S( Q  @Zf_ >;u<*aPS- pu;;` ;;;/~;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; "P" j0fdQu!;!  uddfodd l >P6Sd d\dtP (;;"P:Ug&t=` T=f]t,>@u%ttt t	tfN tF Cwr@u}AalaCs
 1Qh 6uF . u$
TV+eS trtـ?XD@?f `fp`T fffXsr "qy#uptLe; ` ; uY^f3ffe;-fWYдe*&;8fw*fF*2t*܊e&;fX^fY[w($'!(; k" b  uBTv;|  tB2|k}SQVWU&# t# 鿨r]_^Y[LS-120ZIP 250PSQRV:1:2:ِ2ب2PKp
x
~
5	<;2EFk>
s!hfP u	fXt  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(+`*X*Xu s͠HAZY[0^`#u ;Q%;;;;;0] RW1h=

} tE(a/_Z[M-SysPDiskOnKeyP#jB& ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ &_ԯ1p<p< t0h|4t u u2$3=@Af?MpI`N 
fXuײ?0 00'0J000FF 	  FPRdoK@3W~2>#>;2>
]_YhSG; 4  h_S| |ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>u g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;t t `;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@=@t=t=`	t=Ѝ 忨q6`oWfa0V
<8dtd߶}٠rـoپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJA-A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pRqx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  P6ot 	2fp uf:qtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>.`_rfC
.@S&7 ! P`0Uu

C	ݾ3ݎ׵fmqC &" PB3
q a1a!@%[pxtfJf Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%
!02 }Vf>/U`˝8?_&YB?f P?W!?]Dpu%f<E t
t]
t&W[ sPf
Z͉6/- gwFq	g7WgF]q gFyps _fbYB,3u +Y[0+_  a < t?[  ;v?ȉcq tv  f@- ff.gf
GGٵgG-  	R
 Q
Gfyǁ0ffHfbf@@I1&a[} t@q qg cfy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^۵!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7KJ"xfݹf59щ"hRa{TJboHfuKZ<0i f&J$usZ@U t`)% efc	W\DVu=FJ t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXt  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2#hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f  ,$<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruϯKuuuuYQ	`PgK`
3؀`u&svutv3 upVS!@t	V[^0QV"ug&"uvpJ3fu1uq:4ߧS1쨿éu跩#[^PSVfU>"(S>zv>(ϳ&wv#t(
u"g&uuN[艳f]^Vt>uu r1߻vuw%0r~@!"60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zu(zv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_x#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;t t t;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrpu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rg=@t=t=`	t= .峏h=_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#Mufku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  fJ
Wf f;Nf_AS0>Bfz薶r@F!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*NhH|4<t
_t %|SS/( Q  Q|$0@f"nE$!4r",t-PLS1#|&3M38t< t 4 v-#tt {0&#V>"gV8p < @DHPMYr:t"`B-nu-.GGa?;-rfTDaff DI	fAKfg8uY#HD۵qQrf1s
f@ (`+1HSHPS'} O&@`f`h\E|(!G@<<t<=t<>t<Ft<Gt
@55qGN1Z]    %`M3f0V> tf<:  $ fcP   t#@rfuB aqftQS0^fC`BUc[ U44`f& f>/q% }! eIfy!ig~uPi

qCDq; ^r
ɩrC
Ro-?  _&Yf ]6Wwf  sZqf9.u gF9Wu 9]u
gF9ٵtz2/g-tvVf>.  rxsFf!` gFqWg^] gx`A  _/FYq 3:`kF  t	f;QoG;;f@23
 "4 ?!Ix		0			D+@iɃ	@	nO	@	r&W+Y[] _ a 0a?[ }BM ;vωcq tv  f@ 
f`3f.gG p ٵg?G-PA	qGfǸxi@U@,՛f&Y8"!1gGA&a[@t@α acfŜBr SfRqf73_!^5{	@ Sf6tt.*.uu7  V  	  i@  Copyright (c) 2005 Intel Corpor_ationN1OOS@eP%p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxujuTfPF<o:f!a<ISGu%fц	f`C s
?gJН~RVfUfz f6bt*pGt
B  ` nouhC%˕t.At#Oǣ4ǣ%>ӥR#` v@ İ--% ` $f]]aUP.)`t411wgf񸱏#f  fR1txT	e!,	a1'""ԕR4qbSЏ$J
>Pe]uxt]*I$T$$*	g&<vж1	a?5Qc	07t$N<t/)
`FO0hE	@HK0Rfr+5$A 2pT6g%q6jq?f$ ;g[Sy1l?lSQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)ffWRdh˭݋Zf_rJPSƊflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*PÈ`
 fd!7P! ȃ ud|d~fddf@l66`>>á0\ dtf]fd!U! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVtـ?鰽&׶Dѱ'ofATff/fXs2B	x3p&t&L5P 6P ouYË±iވ5P->W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	#&#  	&} R&v_ZS/-e`&[`9t4hy|4t1
&u &uP̀͠px
W  g&?t?fW(g&QffÁ (rcfvg& upxrI`@PeA
f߹  qf  pݐaG,(
 !
"sGkO8b <fT ?tf$BM" Qpf_f
oof' f  fttÓ f&ֲ
pj ZV  @ s	<W% <t+f R
s %u  \	 =,R
/"?r>f	%r
 PBg %O +fVp_U엃ErEF?<p)  O
 Ѓ@ `#ujRa$3''pf 4"b',f2"u~#f`{؎` @Y܀g@Wapq23`g&s go&C#gP'тSf3Bycp>C
uÍćIP>uޠ>t  Xh0LWf  R0ff%f1 J; Fl1>#ZBQT0e rcCbE 	
FD.( P2Xöf fЀf%  0f
P$Z  fP<{@2CX>CWC }q#sâ` H"   " @`;tg諀B`" 'bCtuft asނjЪC4"Bt'BO(Buba9j $ Qg"*0"Iѯ!l#"lr-iXSV {](sd^#g&wKZ
4CZ
ܓ@̃ KZ   ýsZ ] [ \   z @ b  L ` oa e^ @  A Pc 7g 2e @ uf @ @  k ij U @(T @    h à@ P1a  06"gVf.P !f! N@ i  |Q "c$ U0  f 
ٸqfۣ2P	6	:	>@ fU.  *@ B&ff L ܡe 
ff;sgf9t@LwfQ_BfFf-
 pPSf3 hU+us!fr	tfQg袐R 4@ Pg t؃ ?u˸0 0"ҡٵd$ҸffdSSfdOSd}DA" uzhe<W!蠐Mw!ȐՏeef7~ a#@PTcfp Q 4u 	rI !]   }% " &q:&; poQRVWqԡ    Gx> ^P  ׾&q p1(@f` !	u*FAFB>B  6Bp 1	
1	w"r@
 w>!uP?$p33zn!	% uQ,_VS&S?3'1u#*lG# Gu`,$< u y߳PΗwtF	t
 k 0.(d:u> u4d> u	1 t#uEuf1AdFu<Wu2!u	I9 _^ZRsg&8!`u	g& B%DtFsPVS ܨu h6^@vRVԨ?Wu^__»  1Tu TUfߣ蝀(osuoxf]v<f`r;f.;t3Uufۘ=#]fW@`?R`0Ë= v	 +v93f́ƻ   ffP  6~^Ã tL;g  г;@tƿ c.۬ÂҠ"fr9 `w0`b hTU-ÑU|Wa?ffw2f2fffROMIfMAGEP;u;W{t0g!3\3KPQJ 2ұfGXZYXu} waGSG` |"2h$ct"t ɿ t	V M\ cu'f߃ t!AUw@ȹr{~
G94G\WGfd fCft`=O0E0r RQD;gf  ç 21"aE+- pHP.Z Pa
>1\aPrbn w#b#  *b A7v P=
-%5SV.etv(q^Q Pu>EDSR $u<v
7F:,G [Dʀ 7wGmrr )0PƯppJD  uxS	G}p4pEvE`_:Dw/gp
QQ	 tgTdبV
cw&F9org&уt辿o}r!odr%#)oKrQ	so2s
 Jkh_a	=o?=7	t 1 o 2h?f#n
u" $ࢿ"MXp Z$,q[p& p&u aγڳ ? e?t<СGfVf搩f f kr~ПcfǱs\GRБ #!f  af%f
 &'f0p0b	߱s|a  f&ߊu`&   
46 OD 0U ab bG v`g!	O SQFZ  NZhFZqR  >db !  '| da X%,CR0 @${`q0s|uO47f="Bt 'Bt(Bu0$pY ,Xb *RfDvfۺk xfgEP^۵wٵZ&*bl			fӵ5 ~Wf>ӵ)?  yEq_Qp@f% kP׵ffE/2f592P`xݬt)` ;sff+co f6>yat
3T1I!APk
 !
f`=ff1 A6 fffp	f9Or
f)p @VVf4Vf^  $fӃ_\Q}fq+f%=x h1
[_>Hʢ\/)ϊ]/If@t> u Q \&*:&  PSK!
Xh fJ Ӡ 8r
Q

h%>~@t t   f*p+SQ	@0*0=tu}f_P9%B0<s<0v{0u@ N_R  ? fLSdx	 kr_6%U0of0u @
Q f@ Y#h<`w$h(t`C! `! ]>ftg:G}vg_fgoV !тIf0nf
~H( XVW
t%h\E@	g&Gw 6X|(Jp.p tapbaܐf
"ct
p $C7s2Zh0)@ fff}Ȑ6\*z * GfGW`dȣc@tU/ax3w6N=t=tO"tCUO4r#
uU0 fd&2
. fQ:б ; nu5fuHpwz@UͶ}xF~f# s<5	u ut S01Vt)@fufKn g耀	`s4te[}0uuYWrZtL#[P1AfPBFQ~bf%
&Y
_ =۹ps ou0_J  u*f&JbB ޥ s~wf{*=?RSDTu}`w_$!f=FACPt?f;vVfۋo!Ow uCѧ(Rkb D!+4T u 3$psSuPpf P~fG u	CP`g3۶ W23f_
 G	ZƔ pu#f0₄ 0铠gfFff>u2ff@  6q{Rp61p>gp0e&0PՋ>BGg0AR ZjR k l mP&ab=pZ&&FmdXPR< u@SREgtXr),uRG`SQr9wR'˴$8t\Y[	tr$V簄O㰆HAr(QSFr(!sqtkrp@p{pqz[`irDrTށ~fȇiY0Yd>:t	[ fa !  rTvyLa@;f`yt>A _{ G>{faa~h؂'`q|e`>w5kO/P#.  ;@ð Wj@Ȱg&Cp&Cf  @ހ@t G ޠH!	ޑW w{sf_ҞVfWbqo@:g@g<VP+^fZf3gfACDff@rg@?CP@Љ Qg&;t4g&Ct,g&Cf4@d$<12Yf٠
t
g&:#tfCfYFa;tft S e޴r7fg&F ty+_`mr! g`Gag&O@` Nb O cz_ QfVuu+rB fr(al~
"Ȁ/$
Q3p{tWQ@a U\kEr q@Q<aĿ8r p312Kˠߋ Py0U `<<r<9Pŀ&
Yqtuq{ "t؀><:sº7gG   /d3 97) H2 R# d 22 /U$ 9( C@M U##OPS	ubUvPvȇF X PSø &cȌp a؎[XPSءcȎa@sؠXDA ` @@} TfP&V̰ơ"gP,`fX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              K    `    ( Q(     ښ  Ւ  ς  g _   h X V  ;p    / -hD [r/F ]tS          P          %X%H_&                                                                                   3f3ۻ  f@yfg!)A  f" 0 gf+ >n `h=fPpu	fXt  h  fUf&af&>` 6a m !րߣһX[ λ&лSP`͐@ /'a&U}һ&лWP `XP&EX% &E_Y'Ǩ ooooǸoc fPfSfRfW@   ft t4 p  P7hUy eQ  flgf&'  fh   hl^'}hH|$!@d&,hf3f 
&G4 tGGrBFB
6
f_Ю !hfQ  gh*   d$d(h=< d>il thlnd%Rh6d&<Cd'b f_fZf[fXâ'Qff@ f"% fdSlQ#f%ffdWlff$ddl fpIt fdclh0Cf ;0[l _lfdW2@J* Ou{fYWf f_#B*J"eRd轾 ҁZPQ:u 7y܈qCYYWA(x;=;  t2&>Q10;i3 hmoB4_"Rgb hcZJr\ڈZ &}	 t@}	p>'E r>cr>ZR%t;7T v0 b0  y{   	a-}`}}
	
	
 fPSQWfV3  )t-df   fTfxf |f^_YaA.xp|.6|f]f]** End SetActiveDisplays: \  R$Kt5< u )d_}R;t  _um <ZY[X5RӸ}g tuXSQ2tN
كY[P  D@t @ < t  !QO
 p
; 1_3t0	p $~ - p_PSS 
~[@$ \R Cw\90
SRJ9P0\9P$
[9L9ċ K9XC9X)9ZRj"!8Z	R8Pa8a tQ8P 8X8̠ QRPSa[X3ta B!cu
ϫK f`wkOu$&8r
u.2*qLr~ 7$p&` E&]ீ@" _ ffa q t
*}  ??? 9- P:qU]!xW_/ð _PR Z0 .9t rH rtXtd|W?%0|tu $A_rf`f>fݨ8 t`Bfw0~f faQawYp`T_<_}fgf߫2g\ uuFtQ SP访cuA%X055t pB
f0 d6l&n_   Q+?h]$s3Q`1^t,>&t$D =u a u<wN$<w	B}N1t<TQS0> tUKuR uI-B<t>̿t92_?r-r!\g/tg&G!P _  S*WE/tZgqtK[?r3Ȼ Is0 <u$
} Om 2x gf.G"rps.ttp~p r$ SQVȾ@ 8t"8t?r^^Aet,&
 lr>ut
$sE 3t> u.2}"t$	&
s@ 2P
tk!B	>!2
A=t@pn,8 oKw@C@tCQƠ # qc1r,'$ v -->ߴ yԽa>qm؀
	n 23t w1 c0刱q{yu zg *t%or0.> uBu
AiS701 (t#4r1PDJbtVFnr-p<GA,tBvH0/-Fra //e5+t_h5tP PrB33! s H E%
zQT "275 ;5BpVtzu`:طctbw;0UsW;TsQn:u	 ~1u0r u׿"\
uE"
23:? c àc(tn f ) ]{!)PkUkSfW/t
*tC_8؊f_[
}U6fbsg] tb
n]
)50
b/u$$t$
 $ dO(X` غ   nBnnntnJFn aMS0pÀ 3ێ7!C&?!Cuq3ۏvR .Z hEjf!:n"XF+P5I&&::.>&?Pu	ЋQWV;ۿE
 uEۿ;t+t@QWPзPR怺NZXhX@.X=X@uX_Yj۽Pгup$ q!`9.?$[:rP*O6Xt@K`uð6C @B T AQgffwgH g:ff3`֭ffbffffgfffc<(.&sBfsDP
ghIj"t
|W4	fRc6U? t 

(
uXO0 Юf  fAp `p Mp 0Xhy eQ  Rt%tg0&g!g?gf`fZRft9tg>E @ {_9g5C}ggfRVf),g>E %g> !P(^d`g
ز
.  
 f Ѿ"Q2{` @`1YZJRP0 `8P%,Ⱥ:#%h  t
ف     t(  (ZXt
 %@  Pé P+$ @+23 %tVfGf3ȿ f_ff3uf߿>fff#f  fα?*%   HQ0X
1".#؃ ӑll3p%pQ#cY3# C` a)5  `J%?
 g&pwh<3hԤ\4H
 @n(* o# `~Po
 @0q a0
 01Rdv=u
ff%fQ%7Y/w 衠h>tEf0 tFf6$f~@$f#! $S% 5 qq PfymPRQwa#
 i6[Rf  `&P'3P)u许u
ٴ1(q`+NS/4lS/T T/h7'_Z5\",1h/f~_ fPR MR-7/@tP5  @X4v-s8/OYR3  u5m@. @`R}.tt
w10S.@
 Auf%1_r o3tCyR("4,!4f R5 @@tf@ f fy / { {ܣ z Ұ,.028gM!K :) Y((xwS]Qsw%31",&Hnݎ(?!_uwv2y!0S)Rfv1I})@)H#{cT( $)`Ⱥ= Pw  q&a+u1 0  
蟋 h<rB.1  4`_!RC 袶1PfffX f~6fpP;6ذPK   ` 
a!0'5%J%<% 33 #_ZЃ 	   2Zf\%of PZ f/GfaE4Df%\h ft to @PV    Ep`D6
p
f\%	  -(	!	#	a VQ$% = u
$= uL=  `& "8WZ%1ef1f3s!`:@ 0- (pZP<P 0 qPD aQ a ,A0>481c񙬀e#?Bnbr? A%"rq    i! h\ES( Q   G   ؿ
W%_pV%m) ڠG G  t > `" ^A   f?   
fO`hV`u`A!%=t=:PP?,hUdR0o?fF AAf.:.ru"f  f P&
  Q\+UfE jf^RPf2`M \@ fu `&ffY> k >3(tD
Ah35s	7:fa05w pCEf$gP81 ؀gff
3Ұnఀ0p`qpr=!h      e8оh)UfùR'
0
yQhVS3st*2	覐#M2 u!,0   tf   "`0.0p02B"@/t	!03D>f 0 3p?sf3 sCXH4!VW سTSrpf
0u_qà                     K `s%0 	-ɀ$ t		T -	w% u B-KSRP@B u$Z[ WP C	QXAg_f`|Q
`	foga fW3f3-f0π<  &P.f; XanDt좤-[@ fPثfX,fVN`JVJ7E gfw^! f^	V					:		-	^			W			_~g&'Љf@#c!y!  tO/{a#"#hdT(Q ysYlؐ}>uDJ=`tpa3SiN[C vS3ۀ> tt:Nt::NtOC @[0t<w>8t~P 
ܔñ ¸S r @t,}  ZNdN衔_N蚔

t ro}5fP	RAsNrA a	 fXti"p41.P	4ζ@t1-w&㋇N.trwRaWt0
p˓4< t
4:@   }Ǹ>@utNa  H

pIPJ@`؃@PNG2J
s3y@si  Y ݃&
1F0ߢ}4~44m:}4u;pu;thPpP4 4`! o 
55&5?5tdww
2104r]  	&]
dÀ
vh >2d0)22޸@~h|??tDhAhh{r fk P2 robŕ <pC?T=rhгf`1X
baf3۰//8|fX@!7"" Ϭh1֪!P`/)
4/O
% z"	 	b"	/	(	&!_!!!p!hThdv!G@	>˭fpBsu 2f fSRt F<t$rfˋPyZtQVWIrQq 0 _^Y}Tf㰰Efرyft
{t%Syy隐gfQ?䡭p1 Pp^WSQRWVh?6rGt(
 tuu uett0uʋ^_ZY 
WV	;Eb/4;EG Cd6W p 2:> u6 FHt\o ϊhXT3ҬϋhoeB?^_Fj
K̈́
>
2
H
T->T2@OHBp
N(u.
~Pgr2>U=;U/ U/?CSo/ / /  OUZ@<RwS2.>[{0ø`  аtmfQhE0_ufY_\lQ Pɸ`0rXQ&G     &Wf&t ffBf;Pg&Gwgw~rtwRtpff@hVTASp3QgfY~gho\%ƴA ГY[Ua>taPS=phU8WhJ42f[W  cA   `    }f6Nhf=HIBMN@ u_jFf.9u
g.RkFflǿF "Sf= @t1u  ø gP>Q f a	 v| aqsNuFgf~ftVf  t
fP#fʷf
vfwg̃SfY#F$yV f;s	7f
	  fVj2 |~(Ff )g"f+s
г	@Nf;sfmȢF@	rf@f qg&g&fFfGg`^N &Vf !fA=uTA$<ufIg:!
g
@tT	fƹ@f  6C   &6C6C_
<!Et:r 
8s# 5"tr 
tV$<
v
ط  @ tǀ>.C t +$
ؐ ?hoj$ u
d t㋷Iؿ i^hs~

 d		
s	 ͗u ._C&/C| .C/C>/C u
8wà[`fWt# t!_PR怺NZX@t.f_ `uD &Wx-G@f] D7ft HfPLflPfQL 8 fU@@U@@PPh >t~fwt	S@ P~	f% BS @P*G<t<t<ј%%PS$<wP .Er D ߹ Ŀ 6h_r	fO1e  mF` a  !ځG@	` [	N%f"WG"W"WVTfqFfNTf$T ^T0Ψ0EFt  {qT`Kff3fP\  fPA۸fn<Qf!<w  <@0T 1 fXff
P8E
ðG	  ٜEɊPĳ=8P 4
?XuBm D7bS! u} ` [U2P \X	7@72q}P2ۀKˀa	$

Àu<X[X!tP-an؀a
{2t P@<KrK=t7>tLtH $>p u0 o =HV~b\_r`0u< 8t3r-<t)u
$&$.*aA<Vt%Yt2^tmlG Q !pu9u>Q &̿ǰVPIIIIJJJ)J4J?JJJUJ@DHLPXg{SX`diw<qT\pNRW]advPW[_cgvDIMQUZfzJKPUY]am~TX\`dl|U]ailxFKOSW[g~9;>CEKZm _aJà@ PP w`ɫðR,غ:%  3` Z2QC  R2YS !7333 PR?JZ .JcÁBZ s  ""
ZP{Of+K+K Jq vJúQ R (J
PBX
	SRذ4QfQSW `_f_[N    
@|f  ffKqcUfFFRQըNT!èt"ffv`bfDݨn 1fpfufj0f M "  0I @ Y@ +f1k !TX >c[l
 
f!Z ZP:'_t M:XQW 
`%`%y %;{ZO_P)+z %%|-"1~d]~{ҌЌðhb\xvי	u |d# h>L$ԊU1!  1kCHC$aN% #    3^% Q=Q' t ӪTPUO0CT O7C2a2! U% NNNNNTaOkCn OH 7N% Ҁ0.&,yOau`P!@ (+hNf`F_0t5fQ3륣NNf2@- facCTNI N1Q8Pf(f\3 若Oɀ>܀0OO2/s 2 cUV<22 P $̀} og[.@@>`J ^]/+2 	X?s֢ @tiu%thY!u<?cvr7~,a`
(P0!@W`A@uC`
 5
 P@ޱ Ʋq
pu` oA6f.?fà;f.q  ?: ? r芉Pvb ՉAk?|??'uhoR.] !<;RS rc.%R>pqrǀ4.t G*mr%q(u_h$6a@Ouh42 
03!47)?+t
3NO+t3GNOUNRRR(NR_쪺P aTRSRR``/H|

P1XhX<uhj&sMPzvPSF X PSr&S&S&S[XPS2SSSQT|5S50~/N7 IP s4@puuu&gq  p  [NTNO&TT
+pM>tM/dM&"&f txS01St?U'@Zi)۸pU)1Q) \]Dʱ `k`G&hqXm                                                                                                                                                                                                                                                                                                                                                                                                                                  p( f fo龗h>fP u	fXt  h @   foMgeuge&p #
t)fSW kQ r  f[ 1u $  g
ulfeJ   hy ˚eQ 0uIe	:f f  gf&eV /-ggø0&&o  P            <  D ` d h            b ]@  b U "u@H X \E HT(k 
 1 
0 `                       <      14   @  8 @`(  0 0	 ,T%C*l         Z PXYhijklmno 	

                     - ,89:ANNO Oh^ffPfSfWRgpj  h'/ih(kf߿  `^ܳ@g&OZ	(f_f[fX0Z &g7&rrr&0 
dvd[f`vXzf[X
QfRVW f Q  !Q  A!!ȑf%tuf3f3f.2fffu_^fZfYf"Q ء f' ut
f0PR5 % ZXPSVWfQ  ي t
ut upf  fp w h*tr ǀu* pv @uf  fY_^[X%QfWfVpff
  ffs  "%t!
    脥?f^f_Y1"| Y>u= e    f^p/U/@+&G<ug&G%Gf]f!- `{!,XÊU! wfPR0&S0
%|h @1 Ⱥ4Af# uOt~0%\f @t`1,#%9tf͹!!Qt1 f=0 t0@Sf.rzfucf  6YZ06|! z
{{{|{{ǀ {0|f|tzC~|fW 9 u8  *;t Pt	<ff_   _àffSV<r<whf `@I"<Zu>%Lr\x<Z P1T #^f[ 5d
 臭`fp5`	3pDú:tptgҤfPgv4%pMƇ\ʑ ĠD@-@úd7 u"A$
   t 	f 0 ? TPÆ.ЊPUg&f4R%PS &%yT0bR&(P\`<%ifPSQR`d0|f#f|%gP.|C"8|!'' 8d 
 ߣ|fі3 Q'
f~7|PfZYdfR	fՠCP'' |p
f|1fϋ|
s|?qgfb3 %3CbrS؁mlfWV~#t6$Lp% qȿ fft33u0Vk R3һX3t@s9r M
'` ( h%Z vi o
 * !4*j	VTQ/zf%``T@br&$pYp PAW؃22PDXRf\Zh콬f`oms $ 5fgfaS8rdd8r2[S<dr
d2`!$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`0.tfdP l_rFrAPM}I  h㱣<aEQW33۹ G.%/Nޱ߰_Y 
n
r' Q
( scr)S0@r[f
a`Z0[ htvWbGhj!:PSy	+	_Êˀ t? MTOQh.Yt7|
pFuS"o@ }[} hu7P^Z !	ò!
$}4)uhH|~GhXdٕ)#_
1^ 
 DD	GD	ODw1_4/_e7:S#=@7 7S77eGE>O,RUX[l ^U!ao"d#g\$ќ32f%f UCESt) 0t`E@a2"áa\t+ @uY-`@ u@ެ\stF
8  0a蛲:2
}e~!ddf0Pt[Q %J  B2ܕ* qfdt@@4kM tD B&G& r跲@U=F|a' f  { fifqu"'XBP#I t8 t%PR怺NZX!qvp4	fPV脪\'h+r1>huwfq ^μʁ & t! E  ! '-c2ө=    wp&p1x%fþ(!CãwZ  hǜhɝzfzE`fP g!{:fFfGR5PG:g< t	 <f_øo? XGfF< ucAG~' @*F
 ( w@z
@@A  @Af3ɋRD $f3L MB 
ǠBEj343
  ?`SC 3
w TQ+T!ZB"QPaF2  @FfY$fǪf>r	f_ՑN	Rf׾S@e#dg&GLUPV0 >'vB+`++Q +Ǖ(U	((123ff20.$gNgVq	f0J@*/qfWA_PX4fV2	A
-0352f^
9f_rBi _^XPV"'PfSfQfRfVr ?RSSSS 9SSgf&ǇB6Ǉ bR2 ZR
!P&B(B~G@bRH B@tS@g`aT@y0'"~Y3 ~ r t	 @@t Pf&ۋ _ t}=f	w u&d,fV7 Sf^5 ф3}? -锲20 f) 
gf;tzg{f=f3Jbffϱt
   50 2 1@`@a@:fBfߨ t1f^fZfYf[f`Zu PwKFa辢ff#ffдgL rfpa,`-RQ<t2*f3h8,O߱fuDPd9g>? t'h7Ԯt  rmI2qR uY [pCMc7LWС \nf1D"_1$&~_؎vEojl(t_

A
r:fuO%_X0r2/F< G0r/8u/ fZYs"&~A     F47 m       _PS  ,p [X
w ﲽ$ƽ0l$Ͻ  M D=pʳ;)A4)))\))kJ>))oΞNtt/)Vs߈P ? t r=gG05+?+<+:8+#r+$q0rQZǂY1LPtD65+lO5
 22fZRLR  ZFfPSD7`Tl1&C! r
p@2@a	[fQ[
u(Ϟh,Lo9f;tA34`dVf`uas۝1t-r(8) <u0;u00 `
РG`ћ 0gepA]P	/gf>tq  u7gf0Ѵù/g/fa~QfVWo~}/`f$؃<t<}QoaN/YqpS%P
fu nf/!C߀06	 Y PQ>1fWhtU  </(
rh1MoR"ZY0̩Vs	!<@!킸g@ F U7M.Y]W,pj,e
mq+fPfS0t0q͂	Z.%tV
fff&^q
s- 7SQ"» hy
p<wNOfWaCfG?:	Ղf_1p3pN - Y[R֡<vmA
tR}s?O0ۊ؋h	}Bh%f_Zp Pt`iXs SRrb9wc߀w Z[P0fXf^P1aM3@@t8B`d?+D@Otd5XQ !!!q$1EZzEf`~tfdP lSIMWuUffCp  ~pܾf ;w(h0oX@_fapxp !f31??SECUtIfuffdqT  R PhH|'XcV 
ubf%QX!uOB-dۨ@ @Y@Uh,/D.S;%!sGt<S
 
TTV&V[tP#V˳XTt}>h7'
wRLAG= "%=| n =
=uwfu>>@ ƀ %]j#ffw	bï#
%On& @{f_r@'af$g&$ ff%g&	 t0ǁ  #9W$IfGtt2t~tyf{% Kp& f`8a ,,`0? f 1^u`4
f rF`jr>0:@t, pur%prQY
	 c&  Y%L 
Дt`jA
A!:0.A2 r&&"

r蛗r(@lRVÐ
\ _rP#j   t
ff;wt;2
 + t_ D@@D+^@[нP<gaq$FG@V_ ߌ،w	]0R uB	
ff!` 


fffLp pB

grC
`fPfXA3aq&_3 vR;%h1/G~fQV]P61`7:u"Z-*.$f+, 1fY7@g w.	A_S 
fUfp>	 /--

f+0fy
"'f]^ p-##贂 /I?Xv O?An@u%f  '  
$$$$$Y3\[Yxry=tMf \&{q\A5:
R




gŧVl2l9l^lfrheRwwP& 9s)/y t@R]fVOf^Ac^gs@A)91pl``   A;a ѐ    i "`x\}6f!!	"q&

ru

s 
pf>ݓ_ r @  f 
̐ls̸Ћfff_߳7AIff޼dh9o1)^ö@s@KaOkLG NKF!%QqW0tCu*!+1΂_} f 6ͳ,2@2r1 *
 Ή`f6v#s
sN`a >GE؀ARGa%ÑQO  3!4f;Gu YбǬ.D&Dh鿼UQrq>?S@໾g&	PfZÆ!8RQvP `ff@  R}!$^>   3Ж(FܟffZo5f 
Ƅ
萤
__?_7Y@6@VQSv>f"
 O9B1\#"hHQ   ___[1)Z`V/#W	
`R  ueB   MWVQh -=
j Y^_S  2ۊ F`&+ؾ8u `&
0Y[fPWQtPfX"pY_fXkذ/KfV}f`f&\6ta d G&P&Y` X v
``.f&tr&&faõr6r5] P$s  XY
 At   Pfh'Ք X(10u쨧t݁	<u <u õr+r&h#r D8&&t+
2QOrr,6rw%}车_pPqu`0"" QYaBP &߃` Ob v~%'/D&* r!%%F%&&a ]cRqpMZQRr빸#*H)t2в`bٵŀt?q@ultE@>ZYh*#s,   hOPa
/r#
35E4 #C$Pٸ Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGS`1o[&Mw.2` t^
$`#S[?5 󤾈?WW >4gfRo2ɿg}bfZr pvw5 &E
, C!	}A	2;ahH|
%00`P ?0S!^׿%Pg  Da`6(    j aV魆ī^`W  3 _r-"2 fDE/DCՀ B. DB O D D4rru{X 3W2&*G_YS	  ?&*P.u&}Zu&E]_[KH TZNF  20<Otb	B<{tmP:R:!:I_rPF"Tѯ: r1 r, OhOdd:SQt
pujt)u$<Pt+o'KuҴ~qayB@]Y[[Qw @s"~su5Da~Y+V o^W mQfR 3hO2etD/>(I>>rN|UtGV@u 5^t1Vh,L_ 6f1^Df@hU/ U+!޻ 2K p\2#$ǖU
Udc]qʨ89=p	8fkЖU~	 !UMUUHU``ǼCU4=|u})U5PU1IAkf.\ŀ>Ą!u<~w2.о@zf&@9R] N1[\`Iu
ff}
|uf 7
bS&aذsra[fSf|P;xV4t ? uސ_[f\f[!ø wỌ}sq?u!Mb"fB.s	7>.hr0@ŉ1Gfpŉ 16ifa,rǢvqs^o>jd@cGүvhhV hɀ	޺@ h~_XfVfQfWR$"QtZf_fP`eR@dd\_%Za q胹T7\@U	]΁hàP=p-f`t0 d ?
r/YQ?fc
]
f_
ftj`fPU`u<Fee6  ffd 
~tJ]
/t"(L	_
f c
 7,1uc](4r21]>lPHuOx	rJaqAL
uuـ Y t&
&&ƅ]
	r!YXX0UfV4MO@pqT3I^TSRcTS+@r[PSం0[X"PQ>U uιWc r\d`UYfX CtCU>r-t`w 0 r uҊ1 r
-`u`d YpP rdItf s7`QR@*SRNr&r!ww3҆r r	Z hPeRcP_@/t Alro/s^Z{ PQq	s9
d r	r\!V>RPF   dtgfY{uwR Z}hkCZi. P迗 " Y0 `2老p",u   P 7R

Z@u
Sذ* o rQ(`([ `(PS  I 1' oRWR  rXDC	$ 4P>tS t33=pJ* Z`5R
t#4 c tt1Ǉ1\  PQRWVù+3"~a^_Z$"#31$G<u
t$V 4^W _ 	"  !(P	
rR
q0P#<H	
g&/ܱ1q;`-r@QW暪PR(Xó 蕐J2u@ eRVа$rN ;rCr<,	r32;tPrr;w Ҁ tsڋ^ZW
m  а t0u
˾  |uu B߂ fo uf_& J3322t@@ 0	rn
$	"
uƋ߱d;sRZo3QFqF2t
2t	u˸
S_ø
_..W\.q.q.Q.qr.p.BpRE|ȈVPC n  DR ; Z x     0Nm $
PRdu	q t2̿|X"'ÿ	 k H迋ȃ`|I譋PJ2
 w	ёR_P1OO h/Y$Y$t
Vp]r尨0hc/t`hdrEϰd/(#/JQfYRߞj*隆?fPGp>fZrߤ/!AQPH_u(2r#b;  a  d[4 -@5r(0f&QA 5oz7ryq>#tr"?@RWP[rt  tf<Pü f f  fРf!02g&g
fKffRg&& gre h=r6 ?ׂVh̟4h9cP^fZ摫 r  sfbqfRj07W6uLt;w}E0fPf8 r/f&bP Bfg&rff0  ZfW րu
 fp 酀> Àf_f`? t]_ǀ t@  f?
 :N  !(! _ {f` ; 6f<rv`gGwf3ې fPfPr:0> ff{0;w!fVg& ufFtfa΁!Q0Ҋ$pftߥQg&$Xúff%
`f,Lc #g&Ɵ h\/+)CP:fXHXЇ$WU ø0zո" wl@\s	­w   a;
oDP {V *#tSIyC Uك	
ڄD
C
O 31-f f+fM?	h0?Hf-Ef1ϟffqE  RfPAMSuff>dr^gtq"wS0qPa8`p/X>θ  f|	! "M\f#c~yWVf1xrY  EfP < u Zov/vrbfs fw^B
h|t.o}e}rBBpؾ@
E<u@
/Pk
`7cf,t0!0*e"aO`c<tD"ЎzQdr&=t&}vV" &GF^rYՃ"G
\AؾJ|V ?	 h^ϳ
!9
"~} 2Ȼ ZHó
_X
_IP%  ٬  h]< bћPL~̀RQRRغ0 t@рP>:twhLXÐ; < vj <02<a
 1O                                                              - UPRPRVFZX}0RR30ZO                              ޥ ȎP Ѝ؋7h3 D  f`;ѫT
t$.
p$ŪA
r쪀p .<t
.._/ NA Nfaa0f﬿pr1u؀tU./tA
 NUNyhb&|Z{fPj4߰hu/_TÀ> t?_,?s:PfQW _ a:)态-?àPR%?B&a%B&q淒3 $ `%>&;%	 
  3  t!   fQ;RWs_t My۲ PRfP&T f*fXڰ䰐a$>$
` fh/&` ]p]  ] \0\1\ \ \afWп>|f  0?tg&Gbg&Gbu7  uf!wκ( 
uf_`a$$
a C PB B;ra`vqGE,hw\S7Qa* : , 
 012R,ȡ%(Ю Ë34 b0g&D44*
 <B04`hs" 9f`1ff3f% 

 0p!P!q ˠ
 @0XXw!Jf`1"f g?ff%!ffP `B fPfS,(CP0
K   gf&Cw`v CIhԍ Xg?&CfXvCffV ufguugf>u
ӻPf^X,-./01289ie      `a῎ 3NKvYvRRF06;a!.PG3@j""
PA2[2t`6P6a`>@ l> l!GA lBla6$?C ! G @ A  pCB  $0sF̅ р@n  "  BnnnJF$a %?JFP < tq P ̠̡ޠ:ޢ    llB  ؿ lBB@_ l@  Ղ  @ lпNz&'߿߿ /$ 
@  
F_Fn  	n	n	n	n	n	n	nnn 
  ta  @CdQ̀`  3nnC q
p		 nA
` n]a44ޠwlw4`41`Kr!G'1  nN8<a2P  @                                                                                                                                                             aPQ ?tu
YXP `u 
Xf`;w҃`Rfu Zl¿fan?  @(00kf&Ef pDp   &Et"D  $D( s `ۊف&tȀ 4>2@"·Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
`  m  m 
 m pZ's 0 ar *? $߃OQa	 & aSQf  $$<@t"hfP u	fXt  h KuKfZY[<uK&Ku`.>Dst&3r	#rZbJHIF=贋aô`prr XP5 1tr×<0vqw#8:9$[Ͻa){fRQS輻[YfZt'2 t tu
| tʼau0rW&C
ADjG>t  &f    hL^ruf>wrfffd { p&fKffr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f
] 0?  f$fӃ[QXffPfXܞfX*fXaoP                                                              UO AU ќd               p                                                                                     x     _    
 S2X3                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй 6s# hfP u	fXt  h ӦZY[Xg&ǅF C9   Ã tfPfS
u	{p  }f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tԎR>tK#tETfu
)0]t`t	dpX  f]ZYPSR uyvtryv&)2qStN tCu+?7:ǅ%. *'<t<  
7Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ(GF  :(t ffKfG+)a3  `49f 'D%g$ЊFb	蕐" F9蝐r4Vu'v !x 1l^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Ff(f.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV! *fKFt!hu\gvu U>tU6f뿢!@)_a[af^f!aFV  ^SQ  B0Qa@9taT% "G蔆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV,u2|r QERF ߳ u  ;&(pIS(]0`@h1	_S( Q  `f3۹ Wfs_Ձ@T@{" 2: 1Bj0 f=EFfC`?	5	tt$<GvHxs ?!"Ⱦ
Ќ (o
d
zu+
1?M藡iqp1]zuZ/7FF#zu #*V#$^fȢO_o0V mX^ҎD	%ÉD	f~?r2fpɁ v Ss<v PfUf f{ fa$f6f> f	>fBfff]Xo t @PyԁfPQ6[f_~RӃf3 ZՐyP5bރ?> t5z`50@@!|p5 ೀʀ
P}@ئ@x6Ӏw=f;tff* F#cG/$% ëӫqq  gfEـ>  fù& fσ;t)gf+ C k NH2|`Ekv tߢv\vPV;  ^fh3 ;u>; 0ҷ;b7P7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
o xy _TP b6_PSS N SPQ O _   _ _  _ _ _ @__  _ _  _ _ _  ?P@Ц?1?D?1ª?4?_>_>Wr;\/D<1Hl7HC0H9HF8HI_CST pP H`;Ga H	#
 


BK `
 
A
Dof`qI |T
9
dOGESS@PO3Z `C
OeA&KG&e@I&C_C1@__Q
&"1nD6nPmo:n\ pC}
nIST  3A1OU0(L*\q 1d`xL
 C"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)GpXq9SAbDAk
 |1 CAP0WIID  1 2	3U9S
S E  1c`236q I1223p
!
  ki
p

G}B !{L%A9D3	 
	{Β } q[` 0   [ I> N)J2`M5OkH!7Y!1!Pq !!!1!1!!!1! !!1T!1!1!1!1!!!S!C!1!1aF!!1!!!1!%"!1!!1J! 4' !
!!1kf`Hr faf`  ufc3pֻ0v 5 f!6j,gfwnP׋F GPUrR(W-nU<AvPUff>n, uf% j f?fZ	fhy{, a ufzufr],鸀, 
e j,z` 2<v1ʐ,nfWfA_fr1f
==rGX0-r2ȣ襆f`_ rRfGf>|,f r<
r7 	"g&V0fqf+Ug&D
|3G/a'faY
![ 4	 g&?u@Ku 	t`;vJ;u&9OpCqQfRfVfWf-sIg&Of! ff[9
f  +pffff+g&f70^fS$@f[} @    	`@  R|5';;O S !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXh˚S( Q  @Zf_ >;u<*aPS- pu;;` ;;;/~;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; "P" j0fdQu!;!  uddfod԰  >P6Sd dПdP (;;"P:Ug&t=` T=f]t,>@u%ttt t	tfN tF Cwr@u}AalaCs
 1Qh 6uF . u$
TV+eS trtـ?XD@?f `fp`T fffXsr "qy#uptLe; ` ; uY^f3ffe;-fWYдe*&;8fw*fF*2t*܊e&;fX^fY[w($'!(; k" b  uBTv;|  tB2|k}SQVWU&# t# 鿨r]_^Y[LS-120ZIP 250PSQRV:1:2:ِ2ب2PKp
x
~
5	<;2EFk>
s!hfP u	fXt  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(+`*X*Xu s͠HAZY[0^`#u ;Q%;;;;;0] RW1h=

} tE(a/_Z[M-SysPDiskOnKeyP#jB& ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ &_ԯ1p<p< t0h|4t u u2$3=@Af?MpI`N 
fXuײ?0 00'0J000FF 	  FPRdoK@3W~2>#>;2>
]_YhSG; 4  h_S| |ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>u g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;t t `;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@=@t=t=`	t=Ѝ 忨q6`oWfa0V
<8dtd߶}٠rـoپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJA-A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pRqx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  P6ot 	2fp uf:qtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>.`_rfC
.@S&7 ! P`0Uu

C	ݾ3ݎ׵fmqC &" PB3
q a1a!@%[pxtfJf Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%
!02 }Vf>/U`˝8?_&YB?f P?W!?]Dpu%f<E t
t]
t&W[ sPf
Z͉6/- gwFq	g7WgF]q gFyps _fbYB,3u +Y[0+_  a < t?[  ;v?ȉcq tv  f@- ff.gf
GGٵgG-  	R
 Q
Gfyǁ0ffHfbf@@I1&a[} t@q qg cfy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^۵!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7KJ"xfݹf59щ"hRa{TJboHfuKZ<0i f&J$usZ@U t`)% efc	W\DVu=FJ t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXt  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2#hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f  ,$<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruϯKuuuuYQ	`PgK`
3؀`u&svutv3 upVS!@t	V[^0QV"ug&"uvpJ3fu1uq:4ߧS1쨿éu跩#[^PSVfU>"(S>zv>(ϳ&wv#t(
u"g&uuN[艳f]^Vt>uu r1߻vuw%0r~@!"60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zu(zv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_x#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;t t t;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrpu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rg=@t=t=`	t= .峏h=_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#Mufku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  fJ
Wf f;Nf_AS0>Bfz薶r@F!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*NhH|4<t
_t %|SS/( Q  Q|$0@f"nE$!4r",t-PLS1#|&3M38t< t 4 v-#tt {0&#V>"gV8p < @DHPMYr:t"`B-nu-.GGa?;-rfTDaff DI	fAKfg8uY#HD۵qQrf1s
f@ (`+1HSHPS'} O&@`f`h\E|(!G@<<t<=t<>t<Ft<Gt
@55qGN1Z]    %`M3f0V> tf<:  $ fcP   t#@rfuB aqftQS0^fC`BUc[ U44`f& f>/q% }! eIfy!ig~uPi

qCDq; ^r
ɩrC
Ro-?  _&Yf ]6Wwf  sZqf9.u gF9Wu 9]u
gF9ٵtz2/g-tvVf>.  rxsFf!` gFqWg^] gx`A  _/FYq 3:`kF  t	f;QoG;;f@23
 "4 ?!Ix		0			D+@iɃ	@	nO	@	r&W+Y[] _ a 0a?[ }BM ;vωcq tv  f@ 
f`3f.gG p ٵg?G-PA	qGfǸxi@U@,՛f&Y8"!1gGA&a[@t@α acfŜBr SfRqf73_!^5{	@ Sf6tt.*.uu7  V  	  i@  Copyright (c) 2005 Intel Corpor_ationN1OOS@eP%p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxujuTfPF<o:f!a<ISGu%fц	f`C s
?gJН~RVfUfz f6bt*pGt
B  ` nouhC%˕t.At#Oǣ4ǣ%>ӥR#` v@ İ--% ` $f]]aUP.)`t411wgf񸱏#f  fR1txT	e!,	a1'""ԕR4qbSЏ$J
>Pe]uxt]*I$T$$*	g&<vж1	a?5Qc	07t$N<t/)
`FO0hE	@HK0Rfr+5$A 2pT6g%q6jq?f$ ;g[Sy1l?lSQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)ffWRdh˭݋Zf_rJPSƊflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*PÈ`
 fd!7P! ȃ ud|d~fdf@66`>>á0 df]fd!U! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVtـ?鰽&׶Dѱ'ofATff/fXs2B	x3p&t&L5P 6P ouYË±iވ5P->W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	#&#  	&} R&v_ZS/-e`&[`9t4hy|4t1
&u &uP̀͠px
W  g&?t?fW(g&QffÁ (rcfvg& upxrI`@PeA
f߹  qf  pݐaG,(
 !
"sGkO8b <fT ?tf$BM" Qpf_f
oof' f  fttÓ f&ֲ
pj ZV  @ s	<W% <t+f R
s %u  \	 =,R
/"?r>f	%r
 PBg %O +fVp_U엃ErEF?<p)  O
 Ѓ@ `#ujRa$3''pf 4"b',f2"u~#f`{؎` @Y܀g@Wapq23`g&s go&C#gP'тSf3Bycp>C
uÍćIP>uޠ>t  Xh0LWf  R0ff%f1 J; Fl1>#ZBQT0e rcCbE 	
FD.( P2Xöf fЀf%  0f
P$Z  fP<{@2CX>CWC }q#sâ` H"   " @`;tg諀B`" 'bCtuft asނjЪC4"Bt'BO(Buba9j $ Qg"*0"Iѯ!l#"lr-iXSV {](sd^#g&wKZ
4CZ
ܓ@̃ KZ   ýsZ ] [ \   z @ b  L ` oa e^ @  A Pc 7g 2e @ uf @ @  k ij U @(T @    h à@ P1a  06"gVf.P !f! N@ i  |Q "c$ U0  f 
ٸqfۣ2P	6	:	>@ fU.  *@ B&ff L ܡe 
ff;sgf9t@LwfQ_BfFf-
 pPSf3 hU+us!fr	tfQg袐R 4@ Pg t؃ ?u˸0 0"ҡٵd$ҸffdSSfdOSd}DA" uzhe<W!蠐Mw!ȐՏeef7~ a#@PTcfp Q 4u 	rI !]   }% " &q:&; poQRVWqԡ    Gx> ^P  ׾&q p1(@f` !	u*FAFB>B  6Bp 1	
1	w"r@
 w>!uP?$p33zn!	% uQ,_VS&S?3'1u#*lG# Gu`,$< u y߳PΗwtF	t
 k 0.(d:u> u4d> u	1 t#uEuf1AdFu<Wu2!u	I9 _^ZRsg&8!`u	g& B%DtFsPVS ܨu h6^@vRVԨ?Wu^__»  1Tu TUfߣ蝀(osuoxf]v<f`r;f.;t3Uufۘ=#]fW@`?R`0Ë= v	 +v93f́ƻ   ffP  6~^Ã tL;g  г;@tƿ c.۬ÂҠ"fr9 `w0`b hTU-ÑU|Wa?ffw2f2fffROMIfMAGEP;u;W{t0g!33KPQJ 2ұfGXZYXu} waGSG` |"2h$ct"t ɿ t	V M cu'f߃ t!AUw@ȹr{~
G94GWGfԣ fCf`=O0E0r RQD;gf  ç 21"aE+- pHP.Z Pa
>1aPrbn w#b#  *b A7v P=
-%5SV.etv(q^Q Pu>EDSR $u<v
7F:,G [Dʀ 7wGmrr )0PƯppJD  uxS	G}p4pEvE`_:Dw/gp
QQ	 tgTdبV
cw&F9org&уt辿o}r!odr%#)oKrQ	so2s
 Jkh_a	=o?=7	t 1 o 2h?f#n
u" $ࢿ"MXp Z$,q[p& p&u aγڳ ? e?t<СGfVf搩f f kr~ПcfǱs\GRБ #!f  af%f
 &'f0p0b	߱s|a  f&ߊu`&   
46 OD 0U ab bG v`g!	O SQFZ  NZhFZqR  >db !  '| da X%,CR0 @${`q0s|uO47f="Bt 'Bt(Bu0$pY ,Xb *RfDvfۺk xfgEP^۵wٵZ&*bl			fӵ5 ~Wf>ӵ)?  yEq_Qp@f% kP׵ffE/2f592P`xݬt)` ;sff+co f6>yat
3T1I!APk
 !
f`=ff1 A6 fffp	f9Or
f)p @VVf4Vf^  $fӃ_\Q}fq+f%=x h1
[_>Hʢ\/)ϊ]/If@t> u Q \&*:&  PSK!
Xh fJ Ӡ 8r
Q

h%>~@t t   f*p+SQ	@0*0=tu}f_P9%B0<s<0v{0u@ N_R  ? fLSdx	 kr_6%U0of0u @
Q f@ Y#h<`w$h(t`C! `! ]>ftg:G}vg_fgoV !тIf0nf
~H( XVW
t%h\E@	g&Gw 6X|(Jp.p tapbaܐf
"ct
p $C7s2Zh0)@ fff}Ȑ6\*z * GfGW`dȣc@tU/ax3w6N=t=tO"tCUO4r#
uU0 fd&2
. fQ:б ; nu5fuHpwz@UͶ}xF~f# s<5	u ut S01Vt)@fufKn g耀	`s4te[}0uuYWrZtL#[P1AfPBFQ~bf%
&Y
_ =۹ps ou0_J  u*f&JbB ޥ s~wf{*=?RSDTu}`w_$!f=FACPt?f;vVfۋo!Ow uCѧ(Rkb D!+4T u 3$psSuPpf P~fG u	CP`g3۶ W23f_
 G	ZƔ pu#f0₄ 0铠gfFff>u2ff@  6q{Rp61p>gp0e&0PՋ>BGg0AR ZjR k l mP&ab=pZ&&FmdXPR< u@SREgtXr),uRG`SQr9wR'˴$8t\Y[	tr$V簄O㰆HAr(QSFr(!sqtkrp@p{pqz[`irDrTށ~fȇiY0Yd>:t	[ fa !  rTvyLa@;f`yt>A _{ G>{faa~h؂'`q|e`>w5kO/P#.  ;@ð Wj@Ȱg&Cp&Cf  @ހ@t G ޠH!	ޑW w{sf_ҞVfWbqo@:g@g<VP+^fZf3gfACDff@rg@?CP@Љ Qg&;t4g&Ct,g&Cf4@d$<12Yf٠
t
g&:#tfCfYFa;tft S e޴r7fg&F ty+_`mr! g`Gag&O@` Nb O cz_ QfVuu+rB fr(al~
"Ȁ/$
Q3p{tWQ@a U\kEr q@Q<aĿ8r p312Kˠߋ Py0U `<<r<9Pŀ&
Yqtuq{ "t؀><:sº7gG   /d3 97) H2 R# d 22 /U$ 9( C@M U##OPS	ubUvPvȇF X PSø &cȌp a؎[XPSءcȎa@sؠXDA ` @@} TfP&V̰ơ"gP,`fX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              K    `    ( Q(     ښ  Ւ  ς  g _   h X V  ;p    / -hD [r/F ]tS          P          %X%H_&                                                                                   3f3ۻ  f@yfg!)A  f" 0 gf+ >n `h=fPpu	fXt  h  fUf&af&>` 6a m !րߣһX[ λ&лSP`͐@ /'a&U}һ&лWP `XP&EX% &E_Y'Ǩ ooooǸoc fPfSfRfW@   f t4 p  P7hUy eQ  flgf&'  fh   hl^'}hH|$!@d&,hf3f 
&G4 tGGrBFB
6
f_Ю !hfQ  gh*   d$d(h=< d>il thlnd%Rh6d&<Cd'b f_fZf[fXâ'Qff@ f"% fdSlQ#f%ffdWlff$ddl fpIt fdclh0Cf ;0[l _lfdW2@J* Ou{fYWf f_#B*J"eRd轾 ҁZPQ:u 7y܈qCYYWA(x;=;  t2&>Q10;i3 hmoB4_"Rgb hcZJr\ڈZ &}	 t@}	p>'E r>cr>ZR%t;7T v0 b0  y{   	a-}`}}
	
	
 fPSQWfV3  )t-df   fTfxf |f^_YaA.xp|.6|f]f]** End SetActiveDisplays: \  R$Kt5< u )d_}R;t  _um <ZY[X5RӸ}g tuXSQ2tN
كY[P  D@t @ < t  !QO
 p
; 1_3t0	p $~ - p_PSS 
~[@$ \R Cw\90
SRJ9P0\9P$
[9L9ċ K9XC9X)9ZRj"!8Z	R8Pa8a tQ8P 8X8̠ QRPSa[X3ta B!cu
ϫK f`wkOu$&8r
u.2*qLr~ 7$p&` E&]ீ@" _ ffa q t
*}  ??? 9- P:qU]!xW_/ð _PR Z0 .9t rH rtXtd|W?%0|tu $A_rf`f>fݨ8 t`Bfw0~f faQawYp`T_<_}fgf߫2g uuFtQ SP访cuA%X055t pB
f0 6&n_   Q+?h]$s3Q`1^t,>&t$D =u a u<wN$<w	B}N1<TQS0> tUKuR uI-B<t>̿t92_?r-r!\g/tg&G!P _  S*WE/tZgqtK[?r3Ȼ Is0 <u$
} Om 2x gf.G"rps.ttp~p r$ SQVȾ@ 8t"8t?r^^Aet,&
 lr>ut
$sE 3t> u.2}"t$	&
s@ 2P
tk!B	>!2
A=t@pn,8 oKw@C@tCQƠ # qc1r,'$ v -->ߴ yԽa>qm؀
	n 23t w1 c0刱q{yu zg *t%or0.> uBu
AiS701 (t#4r1PDJbtVFnr-p<GA,tBvH0/-Fra //e5+t_h5tP PrB33! s H E%
zQT "275 ;5BpVtzu`:طctbw;0UsW;TsQn:u	 ~1u0r u׿"\
uE"
23:? c àc(tn f ) ]{!)PkUkSfW/t
*tC_8؊f_[
}U6fbsg] tb
n
)50
b/u$$t$
 $ O(X` غ   nBnnntnJFn aMS0pÀ 3ێ7!C&?!Cuq3ۏvR .Z hEjf!:n"XF+P5I&&::.>&?Pu	ЋQWV;ۿE
 uEۿ;t+t@QWPзPR怺NZXhX@.X=X@uX_Yj۽Pгup$ q!`9.?$[:rP*O6Xt@K`uð6C @B T AQgffwgH g:ff3`֭ffbffffgfffc<(.&sBfsDP
ghIj"t
|W4	fRc6U? t 

(
uXO0 Юf  fAp `p Mp 0Xhy eQ  Rt%tg0&g!g?gf`fZRft9tg>E @ {_9g5C}ggfRVf),g>E %g> !P(^d`g
ز
.  
 f Ѿ"Q2{` @`1YZJRP0 `8P%,Ⱥ:#%h  t
ف     t(  (ZXt
 %@  Pé P+$ @+23 %tVfGf3ȿ f_ff3uf߿>fff#f  fα?*%   HQ0X
1".#؃ ӑll3p%pQ#cY3# C` a)5  `J%?
 g&pwh<3hԤ\4H
 @n(* o# `~Po
 @0q a0
 01Rdv=u
ff%fQ%7Y/w 衠h>tEf0 tFf6$f~@$f#! $S% 5 qq PfymPRQwa#
 i6[Rf  `&P'3P)u许u
ٴ1(q`+NS/4lS/T T/h7'_Z5\",1h/f~_ fPR MR-7/@tP5  @X4v-s8/OYR3  u5m@. @`R}.tt
w10S.@
 Auf%1_r o3tCyR("4,!4f R5 @@tf@ f fy / { {ܣ z Ұ,.028gM!K :) Y((xwS]Qsw%31",&Hnݎ(?!_uwv2y!0S)Rfv1I})@)H#{cT( $)`Ⱥ= Pw  q&a+u1 0  
 h<rB. 1  4`!RC 袶1PfffX f6ߣfpP;ذ̓PK   ` 
a!0'5%J%<% 33 #__ZЃ 	   2Zf\%f PZ f/Gf~aE4Df%\h fw o @PV  *  Ep`D6
p
f\%~	  -5(	!	#	at VQ$% = u
$= uL=  `& "8sWZ%1ef1f3!`:@ 0-E (pZP<P 0 ~qPD5 aQ a ,A0481c񙀊e#Bnbr A%"nrq    i! h\ES( Q   G   ؿ
%_pV%ƿm) G G  t > `" ^A   f   
f`hV`u`A!%=t=:PP,hUdR0ofF AAf.:.ru"f  f P&e
  sQ\+UfE jfRPWf2` \S@ fu `&ffY>  ڒ>3(tD
Ah5s	7:fa05 pCEf$gP81 gff
3Ұnఀ-0p`qpr=!h      e8Єh)Uf0R'
0
yQhVS3st*2	#M2¯ u!,0   tf   "`0.0p02B"@/t	!03Df 0 3psf3 s+CXH4!VW سTSrpf
0u_qà                     K `s%0 	-ɀ$ t		T -	w% u B-KSRP@B u$Z[ WP C	QXAg=_f`Q
`	fga fW3f3ɿ-f0<  &P.f; XaDۋt-[ù@ fPثfX,fV`JVJ7E gf^]! f^	V					:		-	^d			W			_~g&'.Љf@#c!y!  tO/ъa#"ᗟ#hdT(Q y=sYl}̶>uDJ=`tpa3SiN[C vS3ۀ> tt:Nt:߇:NtC @[0t<w>8tP_ 
ܔñ ¸S r @t,  ZNdN衔_Nߚ

t r[5fP	RAsNrA a	 fXti"p41.P	4ζ{@t1-w&ؿ㋇N.trwRaWt0
p4< t
4:@   }Ǹ>@utNaÉ  H

pIߺPJ@`@PNG2ؾJ
s3y@si  wY &w
1F0ߢ}4~44m:}4u;npu;thPpP4 4`! o 
55&5?5ww
2104r`  	&
À
vh >20)22=@~h|??tDhAhhrž f P2 rbŕ <pCTrhг/f`1X
baf3//8f'X@!7"" h1֪!P`/)
4/O
% "	 	Wb"	/	(	&!_!!|!p!hNTh&v!G@	˭fpBsu 2f fSRt F<t$rfPZtQVWIrQq 0 _^Y{}Tf㰰^Efرfɷt
t%SǗy~gfJQ?p.1 Pp^WSQ?RWVh?6rGыt(
 tuu uett0uʋ^_ZY 
WV;Eb/4;EG Cd6W p 2:> u6 FHt\o hXT3Ҭ؋hoeB^_Fj
Kބ
>
2
H
T>T2"@OHp
N(u.
~P|r2>U=U/ Uc/?CSo/ / /  OUZ@<RwS2.>[0ø`  tmfQhE0_ufYQ Pɋ`0rXQ&G     &Wf&t ffBf;Pg&G}ww~rtwRtpff@OhVTASp3QgfYgho%ƴeA ГY[Ua>aPSphU8WhJ|42f[W  cA   `    f6Nhf=HIBMN@ u_jFfͱ.9u
g.RkFflF "Sf=M @t1u  ø gPQ f a v| aqsNuFgf~ftVf  t
fP#ff
vfwgSfY#F$yV f;s	f
	  fV2 |~(Ff )g"f+s
г	@Nf;sfȢF@	rf@>f qg&g&fFfGg`^N &Vf !fA~=uTA$<ufIgw:!
g
@tT	럨f@f  6C   &6C6C
<!Et:r 
8s# 5"tr 
tV$<
v
ط  @ tǀ>.C t +$
؞ ?hoj$ u
d t㋷I؊ i;^h~

 d]		
s	 ͗u .C&/C| .C/C>/C u
8w}à[`fWt# t!_PR怺NZX@t.f_} `uD &ޱWx-G@yf] Dfܣ HfPLf>PfQL^ 8 f@U@@@PPh >t~ft	S@ P	f7% BS @P*G<t<t<ј%%PS$<wP .Er D  Ŀ 16h_r	fO1e  F` a  !ځG@	` [	N%/f"WG"W"WVTfqFfNTf$T ^T00EFt  {qT`~Kff3fP\  fPA۸f<Qf!<w  <@0T 1 fXff
P8E
ðG	  EɊPĳ=8P 4
XuӪB D7bSz! u}} ` [U2P \X	7@72q}P2ۀKˀa	$

Àu<X[X!P-an؀a
{2t P@<KrK=t7>LtH o$>p u0  =HV~b_r`0u< 8t3r-<t)u
$&$?.*aA<Vt%Yot2^tΖlG Q !pu9u>Q &ǰVPIIIIJJJ)J4J?JJJUJ@DHLPXg{SX`diwߙ<qT\pNRW]advPW[_cgvDIMQUZ_fzJKPUY]am~TX\`dl|U]ailxFKOSW[g~9;>CEKZm aJu@ PP `ðR,غ:%_  3` Z2QC - RYS3 !7333 PRJZ .JzcÁBZ s  ""
ZPOf+K+wK Jq ~vJúQ R (
PBX
	SRذ4QfQSW `_?f_[N    
@|f  ffKqcUfwFFRQըNT!Ϩt"ffv`bfۻDΨn 1fpfufj0f M "  0 @ Y@ +f1k !TX c[l
 
f!Z ZP:'_t? M:XQW 
`%`%y %{ZO_P)+z %%|-"1߰~d~{ҌЌhb\xvי	u |d?# h>L$ԊU1!  1kCHC$aN% #    3% Q=Q' t ӪTPUO0CT O7C2a2! U% NNNNNTaOkC¢ OHf 7N% Ҁ0.&,oyOaqu`P!@ (+hNf`F_0t5fQ3NN_f2@- facCTNI _N1Q8Pf(f͡3 若Oΐɀ>0OO2/s 2 cUV<22 Pظ $} og[.@@>`=J ^]/+2 	X?s֢ @tiu%?thY!u<cvr7,a`
?(P0!@W`A@uC`_
 
 P@ -q
pu` oA6f.fà;f.q  ?: ? rmPb ՉAk???'uhR.] !<;RS rc.%RӀpqrǀ4.t G*mr%q(u_hI$6a@Ouh42 
03!47)?+t
3NO+t3GNOUNRRR(NR쪺P aTRzSRR``/H|

P1XαhXuhj&sMPzvPSF X PSrЌ&S&S&S[XPS2SSOSQT|5S50~/N7 IP s4@puuu&gq 矀 p  [NTNO&TT
+pM>tM/dMðð&"&f tS01StU'@Zi)۸pUw)1Q)છ \Dʱ ߃`k`G&hqXm                                                                                                                                                                                                                                                                                                                                                                                                                                   p( f fo龗h>fP u	fXt  h @   foMgeuge&p #
t)fSWW kQ r  f[ 1u $  g
ulfeJ   hy eQ |0uIe	:f f  gf&eV /-gg0&&o  P         }   <  D ` d h            b @ U b  "U@H X \E HTk 
 1 }
0 `                       <      14   @  8 @`(  0_ 0	 ,	T%C*l        Z PXYhijklmno 	

                      - ,89:ANNO Oh^ffPfSfWRgpj  h'/ih(kf  `^ܳ@g&OZ	(f_f[gfX0Z &g&srrr&0 
dvd[f`vXf[X
QfRVW _f Q  K!Q  A!!ȑf%tuf3f3f.2fffu_^fZfYf"Q ء f' ut
f0PR5 % ZXPSVWfQ  ي t
؀ut upf  fwp  gh*tr u* pv @uf  fY_^[X%QfWfVpff
  ffs  "%t!
    脥f^f_Y1" Yu= e    f^p/U/@+&G<ug&G}%Gf];f!- `{!,XÊU! wf{PR0&S0
%|h @1 Ⱥ4Af# uOt0%\f @t`1,#%9tf!!Qt1 f0 t0@Sf.rzf?uf  6YZ06|! z
{{{|{{ǀ {0|f|tzC~|fW 9 u8  *;t Pt	<ff_   _ffSV<r<w/hf `@I"<Zu>%Lr\ʼx<ZI P1T #^f[ 5d
 `9fp5`	pDú:tptҤfPfg4%pMƇ\ ĠD@-@úd u"A$
   t 	f 0 ? OTPÆ.ЊPUg&f4R%PSؿ &%iyT0bR(P\`<%ifPSQR`d0|f#f|%P.|C"8۱|!'' 8d 
 |fі3 Q'
f~|PfcZYdfR	ՠCP'α' |p
f|1f|
s|?qg.f3 v%3CbrS؁mlfWV#t76$Lp% qȿ fft33u?0Vk R3X3t@s9r M
'` ( h%Z vi 
 * 4*j	VTQ/zf%G``Tn@br&/$pYp PAW2沬2PDðXRfZh읽f`oms $ ?5fgfaS8rdd8r2[S<dr
㳿d2`!$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`0.fP _rFrAPM}I ? h<aEQW33۹ G.%/N߰_Y 
n
r' Q
( scr)S0@r[f
ap`Z0[ hotWbGh!:6Pye	+	_Ê t MTQh.Ytw|
pFu{S"o@ }[} hꡕu7P^ eY!	.!
$4)uhH|GGhXٕ)#&_
1^ ƕ
 DD	GD	Ddw1_4Y/_76:#e=@7 7SQ77GE&>ORU,X[ ^U!ao,"d#g$ќ32f%f UCES{t) 0t`E@a2_"áa\t+ @uY-`@ރ u@ެstF
8  0a蛮2㷀
}e!dgdf0Pt[Q %J  B2* qf@@_4kM tqD B&G& r貄^@螫=F|a' f   fifqu"'XBP#I t8 t%PRNZX]!qvp4	fPV脪\'h|+r1>hufq ^ʁ & t! E}  ! '-c2ݩ= {   p׀&p19x%f(!|CꔡãwZ  hǜhKɝzfzE`fP g!{:fFfGR5PG:g< t~	 <f_ø? XGfF< ucAG' W@*F
p ( @片z
@@{A  @A_f3ɋRD $f3L MB 
^Bj343
  m?`SC 3
w TQT!bZB"QPaF2  @FfY$fǪf>r	f_Ny	RfS@e#dg&GLUPV0 'vB+++Q V+Ǖ(	((123ff20.$gNgV܀q	f0J@*qfWA_P4fEV2	A
0352f^
9f_rBi _^XoPV"'PfSfQfRfVr RcSSSS 9SSgf&ǇB6Ǉ bR2 R
E!P&B((B~G@bRH= B@t@g`aT@y'"~Y3 ~ r t	 @_@t Pf& _ t=wf	 u&d,'fV7 Sf^5׿ фq3} -锲20 f) 
gf;tzgf=f3Jbfɻfϱt
  _ 0 2 1@`@a@fBf߿ t1f^fZfYf[f`u PwKFa辢ff#ffдgL rfpa,`-RQ<t2*f3h8,Of}uDPd9g> t'h7Ԯt  rmI2qR u/Y [pCMc7LW \nf1Dˇ"_1$&~؎vEjl(t_

A
r:fu%_X0r2F G0r/8u/ gfZYs"~A     F47 ߰       _PS  ,p {[Xѽ
 $>ƽ0l$Ͻ  M Dpʳ;)A4)))\))kJ)󃋀)ΞNtt/)VsP ? t r=G05+?+<+:A8+#r+q0rQZǂY1LPtD65+O5
 22fZRLR_  ZFOfPS7`TTl1&zC! r
p@,@a	[fQ[
u(h,Lo9f;tA34`dVof`Ȱuas۝1t-r(8) <u0;u00觎 `
РG`ۊћ _0gpA]P	/gf߃>tq  u7gf0Ѵù/g/faQfVWo}/`f$؃<t<}QoaN/YqpS%P
fu nf/!C߀06	 Y PQ1fWhtU  </(
rhMoR"ZY0Vs	!<@!g@ F~ UM.Y]W,pj,e
xmq+fPfS0t0q͂Z.%tV
fff&^>q
- 7SQ"» h
p<wwNOfWaCfG?:	[Ղf_1p3pN  Y[R֡<vmA
tR}s?O0ۊ؋h	}Bΰh%f_Zp Pt`iXs SRrb9wcw Z[zP0fXf^P1>aM@@t8B`d?+D@td5XQ!!!q$1EZzEf`fP SIMWuUf>fCp  pܾf ;w(h0oX@fapp !f31?SECUtIfuffxqT  R PhH|'X;ذV 
u?bf%QX9!uOB-d@ @Y@ΓUh,/D.S%!sGt<S
 
_TTV&V[tP#V˳XTt}h7'
wRL>AG= "%= n =
=ufu>>@ ƀ %]j#ffw	b#
%On& @{f_r@'af$g&$ ff%g&	 t0ǁ  #9W$IfGtt2t~tyf% Kp&鏘 f`8a ,,0?v f 1^u`4
f~ rF`_jr>0:@t, pur%prQY	 c&  Y% 
Дt`A
A!:0.A2 r&&"

rr(@lRV
\ _rP#j   t
ff;t;2
 + t UD@@D]+^@[,нP<gaq;$FG@V Eߌ،w߾	0R uB	
ff!` 


fffLp pB
grC
`fPfXA3aq&3 vR%h1/G~fQVՃP61=`7:u"Z-*.$f+, 1fY7~@ w.	A_S 
fUfp>	 --

f+0f
"'f]^ -##炃 /I?Xv O?An@u[%f  '  
$$$$$Y3\[Yxry=tf \&{q\A5:
R




gVXl2l9l^l?frAheRwwP& 9s/ґy t@R]fVOf^Acgs@A91pl``   ;a ѐ   i "`x}6fu!!	"q&[

r

gs 
pf>_ r @  f 
|lsЋfff_7AIff޼dho1)^1ö@s@KaOLG NKF!^%QqW0{tCu*!+1΂_ 7f 6ͳ,)@2r1 *ҹ
 Ή`f6v#s
sN`a GE؀#AGa%UÑQO  3!4f;_Gu Y~б.D&Dh鿼UQr>?S@綂g&k	PnfZ!8RQvӸP `ff@  хR!$^>  M 3ҀЖ(FffZo5f 
Ƅ
萤
__?_7Y@6@VQSv>f"
 O)9B1\#hHQ   ___[1)Z`V|/#	
`UR  eB   MWVQh -=
j Y^_S  2ۊ F`&+ؾ8u `&
0Y[fPWQtPfX"pY_fXkذ/KfV}f`fo&a  G&P&Y` X v
``.f&r&&faõr6r5] P$s  XY
 At   Pfh'Ք X(10u쨀t݁	<u <u õr+r&h#r D8&&+
2QOrr,6r%}车pPq萾u`0"" QYa_BP &` Ob v~%'/D&* r!%%F%&&a cRqpMZQRr#*H)t2в`bٵtq@ultE@>ZYh*#s,   h¨OPa^
/r#
35mE4 #C$Pٸ Uq< =_  & &EZP 2 ;&rr8tW2@f`.&EO.tGS`1o[&M.2` t
$`#S[?5 󤾈?WW >4}fRo2ɿgbfZr pv~w5 &E
, |C!	A	2ahH|
%00`P 0Ss!^%Pg  Da`6(    j aV魿ī^`W  3 _r-"2˸ fDEDrCՀ B DB O D D4rruX 3W2&*G_YS	 } ?&*P.u&}Zu&E_[uKH TZNF  20<Otb	B<tmP:R:!:IrPF"Tѯ: r1 r, hOdd:SQt
pujt)u?$<Pt+o'KuҴqwayB@]Y[Qw @s"su_Da~Y+V_ o^W mQfR? hO2etD/>(I>>rN|UtGV@u 5^t1Vh,L_ܔ 6f1^kDf@hU/ UǏo+!ޅ 2K p寓\2#$ǖU
߿Udc]qʨ89=p	8fkU~	 !UMUUHU``ǼCĖU4=|u})U5PU1IAkf.ŀ>!u<~w2.@zf{&@9R }N1[ Iu
ff
|ugf 7
bS&as蘊ra[fSfP;xV4t ? u_[ff[!ø wLỌ}sq3u!M?b"Jf򿋠B.s	7>.7hr0@Y1Gfpŉ 16fa,vr,qs^@o>j@cGүvhhV h	޺@ h~_XfVfQfWR$"QtZf_fP`eR@__%Za qT7k\@U	]h<àP=p-f`0  
r/YQ?fc
]
f_
f`fPU`uFSee6  ffd 
~tJ]
/t"(yL?	_
f c
 ,13u](4r21]>PHuOx	rJaqAL
uuـ" t&
&&ƅ]
	r!YXX0UfVL4MO@pqT3I^TSRcTS+@r[PSం0[X"PQ>U uιWc r\d`UYfX CtCU>r-t`w 0 r uҊ1 r
-`u`d YpP rdItf s`sQR@*SRNr&r!ww3҆r r	ZZ hPRcP_@/ A'ro/s^Z7 PQq	s
d r	r!V>RPF   dtgfY{uwR Zߠ}hkCZi. P " Y0 `2p",u   P 7R밍

Z@u
Sذ* o rQ(`( `(PS  I 1' RvR U rXLDC	 4P>tS t33pJ* Z`5Rމ
t#4 c tt1È1\  PQRWVù+3"a^_Z$"#31$G<u
t${V 4^W _ "  !({P)	
R
q0P#H	
g3&/ܱ1q;`-ra@QWPR~(Xó 蕐J2u'@ eRVа$rN ;rCr<,	r32;tPrr;w Ҁ tsڋ^ZW
m  а t0u
߾  锠|uu B f uf_& J332[2t@@ 0	rn
$	"
ſuƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_...q.q.Q.qr.p.BpRE{|ȈVPC n  DR ; Z x     0Nm $
PRdu	q t2|X"'	 k H迋ȃ`|I譋PJ見2ȉ
Ƞ w	ёRPŵ1OPO h/Y$Y$t
	V]r尨w0hc/t`hdrEd/(#/JQfRߞj*5隆?fPGp>fZrߤ/!AQPH_u(2r#b  Ӓa  J[ -@5sr(0f&Q<A 5o~zryq#tr"?@RWPrt  tf<Pü f f  ?fР࿃f!02g&g
fKffRg&& gre h=hr ?ׂVh̟4hcP^fZ摫 r  sfbqfR_j07W6uLt;ߤwE0wfPf8 r/f&bP Bfg&rf/f0  ZfW րu
 fp 酀> Àff`? t]ǀ t@  f?
 :  (! _ f` ; 6fSrv`gGwf3ې fPfPr:0> ff0;w!fVg& ufFtfa!Q0Ҋ$pftߥQg&$Xúff%
`f,Lc #g& hI\/+)CP_:fXHXЇ$WU ø0ո"w @Рs	­w  a;
oDP {V *h#tSIyZC كE	
ڄ
C
O 31-f f+fM	hs0?Hf-Ef1ffqE  RfPAMSuff>rm^gq"wS0qPa8`p/X>θ  f|	! "f#cyWVf1xrY  EfP < u Z\ov/vrbfs fw^B
h|t.o}e}rBBpؾ@
E<u@
P
`7cf,t0!0*e"aO`c<tD"ЎzQdr&=t&}vV" &GF^rYՃ"G
\A؟J|V 	 h^
!
"sN~} 2 ZOHó
_X
_\IP  ٬  h] óbћPL~oRQRRغ0 t@рP>:thLXÐ; < vj <02<a
 1 O                                                              - UPRPRVFZX0RR30Z O                              ȎP Ѝ؋h3 D  f`;T
t$.
p$ŪA
r쪀p .<t
../ժ NA Nfqaa0fpr1u؀tU./tA
 NUNyhb&|Z{fPj忨4߰hu/_TÀ> t?,?s:PfQW _ a:)态-?àPR%B&a%B&q3 $ `%>&;%	 
  3  t!   fQRWs_t My P}RfP&T f*fXڰ䰐a$$
` ?fh/&` ]p]  ] \0\1\ \ \afWп>f  0?tg&Gbg&Gbu  uf{!κ( 
uf_`a$$
a C PB| B;ra`vqGE,hwS7uQa* -: , 
 ~012R,Ȏ%(Ю Ë34 b0g&D44*
 <8B04`h" 9wf`1ff3f% 

 0p!Pw!q ˻
 @0XX!Jf`1"f gff%!ffP 
`B fPfS,(CP0
K   gf&wC`v wCIhԍ Xg&CcfXCffV ufguugf>u
ӻPf^X,-./?01289ie      `a 3NKvYvRRF06;a!.P~G3@j""
PA2[2t`6P6aÜ`>@ l> l!GA lBla6~$?C o! G @ A  pCB  $0sϊF р@n  "  BnnnJF$a %JFúP < t~q ̢P _̠}:ޢ    llB  ؿ lBB@ẇ lU@    @ lТN&' /$а 
@  
FFn  	n	n	n	n	n	n	nnn 
  tqa  @Cd̀E`  |3nnC q
^p		 nA
` na44ޠww4`41`Kr!G'1  nN8<ao2P @                                                                                                                                                              aPQ ?tu
YXP `u 
Xf`;`Rf쨀u Zlfa+n?  @(00kf&Ef pDp   &Et"D  $D( s `ف&tȀ ׃4>2@"Q
g&Ŀt
_ 0HL &}u?p ?u8&= r1	&
IW$Br P
` 肐 m  m 
 m p's 0 ar * $mOQa	 & aSQf  $$<@t"hfP u	fXt  h KuKfZY[<u?K&Ku`.>Dst&3r	#rZbJHIF=贋aô`prr XP5 1tr<0vq;w#8:9$[a){fRQS[YfZt'2 t tu
| toʼau0r&C
ADjG>  &f    hL^ruf>wrfffԽ  p&fKffr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀
 0?  f$fӃ[QXffPfXfX-*fXaoP                                                              9UO AU 
ќd               p                                                                                      x   x  \S    
 MBA U<M,     .$PnPP@ U  Broadcom CorporationWBasede PXE-2.1 v1.0.4 
Copyright (C) 2000-P 5 on19970 Intel3 $BC$  L @:\` 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9v_PPr ѧFPa &fP}ffP΃ fj:6DHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES_-:-DIS SP- #ÜPh)tX
Waiting... 92 4
  t\`A%4
hoU p w `SfQfRfVv&  &\f?UNDIt?hĿ o
2EC4:  ROM ID structure was not found. Gs<hh '5is invaliPPj Sj < uf. fGf;sfA fR   `Df
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' W{.;	s.
{`6&PԋfP WfUj j f2 R0	RVQ콺	&v &D6EU    U 
 
 Ff~ 0ЉVuH6U9Whw
˃f6UfV  
Z cA
' tl tcS tZ|~  tQ  tHhZRjh'%09 !nexpected!l0Wer error.  Status ==  Pt)20: BIOS extend me?mory c\]3,6'drivimag{'.8: ! b_.S.*cesegmenqtp
@fNV+.>  u=h"!a! ݕ%93C44f):4>f04^f.@ sLhP  roo  AyH" >'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufqAA	f]r.>@u	 . 	P`Pn.( #.P<Xt/`Press <Esc> to abort&?in`szaB~RfW ߀>  $u> PuMu	>p Gu[fpZ? 	AxS@xf>f . . .P 2`<t8hnE^WOpKrequi
 DDIM supSf0'  ˂)B	._,0gfh fRjfj0~f~ЃhLfQplrzfu0hl|%{
I# PMM fun}c2
numbec` u)hgE al'locufP~pΐfprgfgffߋf_-.:ah   .tf.>: r{$tҩ      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j ( | LIENT MAC ADDR:AP"x     GUID{: DHCPPXECli@{:Arch:00:A 0# I5P PSKePROXY3@
GATEWA MD  BD` 
Auto-sel:
  BOOT ?SERVER)    -->  MTFTPTT l! A1Hedroxyser?vice d 51replyJ?est  @> 4011.  ul25e acer Miss0 T addqQ BIS bad  checksum "get signnform<failfreeboobj authortW flagA	shutdow
[>/cred0] /
integritPcNetworkc
cancp%d by key0ok0@ARP timeo{utcopen+EQ - F@ NAcchViolrg SrecedPom ##unknopc$re*	<	connp!pRB NoS7p6)offers we	'  ]f#nam %e.RAPI}e 5u{ICPr multicastdwh~0thr /)PHY+figur3lDataL+@)aW8EEPM7i
sett<a,rrup(too many /packsdF ; MediGa tAE7,D8cable NBYPabi o=basE> BCQ4FdiscopDsFlim6H-u a7nd/)mpHC CPFO&%s`DQ,nE6jbn-m.Pp  /-\r]
SM/DMQIŏe Hd+_Us_u	 Db
 
`~ uː  u^& 鐃>.3 u3^.3h]t0F-  r- vHHt
- r 뾐w:: MP3   fv?FF)~! o'Ґ f  -u
hx9~P\FmCt\놂[mo{cA벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t¿ Mff99f2 hR99@t{Jtq ^h
LShSF` S^TF9*9Fr䡸9N KpL?2#ZQ"1KNJHJ t0 tEVPhSp"
FPH*9Fu9R 9뮐3>'u> (t
KjJ!
; 
ta@0`9^0   V@/[0.+Ҋ*A FVF	$FVu3^Ã>гt3y(3*3(wh2v Es05	(3;7f(3 fpsEy O뜐WT3Q44h96:6@ 636H3 |38tְE<2u}% 0ҀĀ FVfF^}IFf+	`v6 FoV7u>P>f6(bK
:	@" 9IW:XF@V^fGPVr$=NVu^F^G(P	eYD^  G-- v%0&iGN ^& u*&GO=p u6`&&G G#7&r&`O0 	[!W8"`7u7'G P99HG9@Gf9  fP2 VH@&#P6VS*&	&R&(G G0FF`FF9G6@NfNfQhA UVU U^*&O;~S*Q
u3s  S3#G$PpTqQ(G	\1'G!EI<<hW;?.3%lB  t&} }??XgFdְSV RPV`T 
 C3& _2,Ph!o&Gk3?F3:Yw			7pf(21sK,  8-tHHu9N5COBv-*}OO$+SEA20 GP)a b   Q  u  P  Hx3cV";{G& 4@ q1`_

6D/*WE T3WAe1kDiuQX\(PB@	=3 =2{ }NcwE-6 t`KiuhBC 8f#30QG.o'Dp'P3Bm"ol~N~ tI01DR{fQ [:×3URF)v; 			[
";S`
 HǍG0**c&W7p![ 0XFP V1Y+`ppp q`q$JfjFH$*F $ t
{! HËFFt|y#fÐBaf'dUmB`G?F$ 5dg2
I2
 2
8
1
I~zf0fFB
%a "2
P 7,G9bF&$U'b
81_H~fPo'F萟{FPtM +;Vr
w;FvF@F3!h3F^>M@Q"dP򻐘p (Fb +ﾭaޠ+)6H)ࠩ?FN)z) t)hE)`WuC` WV2! \t2^_2&spO( IP⸀22ߎfЏftrHuVHu0Hu ݣ"RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Mf2fx{3RN|r!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"DH			th&Dժ	#Eh.dDf>	 t.ڳa Fp&J>1u(as$])I)K &^lQ_@	+&`aL h6npVIǺ
  /daF^q ur}t ,1R#F&3GF>t'h*FFb5-0wf% JZ3M.3:F!^333&PF63_9F|׃>> B.3Bf FgQfG9m9!Kбh: C$-h:LiHPV3 Qa BFgjƒCG<Dp w o@*DNHL刁i	TX\.
`Nh#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^- t@9vO0j>`c  Pjqn@mv0*-< -`d.F;Ƌ}	r58X	 1"o@*F69Fr3pqQ#z{#=4PhK{0Htz0ӽNh - j F<B&&B$6'GIr(p7l)q&W#qNxCpA&tiG]		$ 5$"qG$Bs!FQc"  =! @$[W
vSQ2Uc~j,hPWb	,5,ԚD+,&_*&G|&_~-5ps0-+@)t- t:' t $ u&  u
&0B2)?tₑ&9Guf& u   t؍G){
p*tP\WJDvvv87Vj
 &fXfYffff99A : ;SFqTjФP+hB`ix qS2CRPT
ix &nF}Ljp3#b F=zӂP0z07u~ t	Ơ`82[DlDpaAg3kp-`'C<  ǆr Dӯe8}8 u9c9*`Ӳȍt0 t^u_f~}R9Glu]"pu $%#Aqm Qn4!"&`afP
bq;2ge2dp&O#a77# q8#8u)̋- Dt-guB%t) upuh)5'@D04Ȍ#XP}Piܠ,)oP-)I
#p&&b``y
FP11&Æo%ca;iv1t u-iF f"3u30RӖ
Rv35erѲ,u1}.iv; 
t۶0=>P-"RhQ,"-

uۡ	? )&j&hy4B{sX5tۢdtxuHC$N"lT=1AiFUPA9=% pXD` 2?	 9t>2Pc
4 c_*\6p^p0)HtHti k4H
5&6
2{-Ęo4F@Ch92 < c+|<, 4t	"]
5lW
!!
~
3iF 2pah36!1$30 #םqpqQ&$ ;' cb;
D?'0
	!5
0
ndu>2; tpy)j{pn:9&Y` RP3@"{4dtq  u
ѨC D ~ rq rરlFP ^ V Cu~3?++v^F1*"  SRPW^Qu0@|1a}1̿P M"8k@1au`ug\p1:O790qiv<"ĘT1 F9GwxO#N; ~w taRVEPV9
4P`XG&W%?:FVЭAi39Fsq93u93ut[~o tHS`׋Fa-2ovi~`؎FQ@>PSS;\u>St
FR`_s	.!P`V\7hbn21f>&fp9f9thx轌 p~hq9 t@3ޠf 1ƹ +uh?1 .9Ps!1rh1^`2
b2 f|
fPȡp`:޳1h:U777ubQ^dF@R1Ċ 9F~A !@ux  k^ ^}
 ̽L  ?   }/^ۋ  FPС0eޠgQ&>pSp8Qe @
uTRRS pېF~!uU @u1rBK+o t'Muft1eРxy҃yy \t1{Ðfv0pߌ 5b# qO4 t&Gt,!@ &!t&lŀ (| ubl t | ~GlpS u0pUxTxTp _ {t--Ű%`Ez G+3Bf&)f1F?FtbQ~ t^ݰuK{ 률ؙ99̴ t
w^MQ5ף:pθ #^85:FFu_	63PaX`ɀ	* 5*6 FuH^4H3 u9,3ܒ	4<  4  t^Q`u
43	VVCg `= = > w$1,̋V; -^Gqك#tOaf6 K10*da@&ğɤV*@L"A!i2P8PR&7P3 
pI3T f+@wF^h
&F}pS^qecNF#	9FwsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 0(q@y;EP tutp@6~ tz>_T9PI0h*Z*#$(pK@|%0z&F`](R0>`c 
s	
hfp /(			/	&		M	cu^ABsI>0)FyV)vf&0a`_f`~^NvVFn
fa
@P~  hRP&$ RNh^V6  u*	gA$d t^!U$tfX u	  9 $uy$T u
vay%2     v Owr#@4
XpnXs$htfuwt&hv=!	GXpZF΋	ХP6	pcXv&ߊ@* F"\;Fw~Md\ `n`ut`1 t\r0eR
RNx!
\^%
R
"

)
 Gq(e
R
d'^3`&8g &3Ľ;v
w&`Frb@s
hu8p@?Ht',ha&)&Q[N?ExE#i3+Ǎ&ր&K!%%"%+`Is)t=r %H!up% ǆ )fǆl @ Ɔhj%2&  %hJ% 0O&= Btw3-O-,u 1!?0h{I! t#*Bb- [t- 
tQ אĞ&8t&׊ `	
uAp@_*h$ȁ
 v/$Ƞ ɋ$
̃ P#&
h [4j*q"gb X69A	
@R$ơR
9FrF
>0r%*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv})vzp+- PY3 $=.t = t -t ) [ tNfhs
V
Iq

pcx
g
U鿀=KF{0v=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- ttυrV>Pu$ {>T 9  r'9>
 tFu'^ !{^ fq q24RPV}90
 ^)@Z)°N J~63L3FV5x'p#) rt	tp	M ht3h9 29
 8 .!L3ߠ (RӃ 6 jPP ff92uvf u:9u1Sʰ~(v(;w l!d  f9S&:Qt?F3u*Ju?9gL3 =2 g2 
w>J3`kE~F vN3'@'toHHt	HZ !"(~ u"hdhlp 貴 EP ظ; \&u< Ou	= > 6 t4ft3DpuxPp
 `_7N3 >r-&+'Ht
&pVtge߶9ԑ&- P9pQ~L~~? ?D#)>2 u~@9 Pp:?h2 $7"0-2Cur_ā? ScjRY~O d< #@@=t߰9느p
Ff=E`_ v`W  QM [(3*3'$v	v	1lb
 g}c    	-C$а=Jǟv9s!vp29a|Y&]v9P31%PQv9X#> l
GڰSM>4J4Mp9$ G*GLQ?M?tfG[GNGID:Dk/p
L
3LL9 3to\Ni2u@:ADE5 s9莠(뻁> K9Y#9]-U"Us>":Pe 3dvfÐnP3t 1*䊇N tFqu; wb ѐk:Аv+{2@Вfj
߶ fXfYffffF~"FwF`^)FX@/9Fwv	FF >;Fs"O=?~#vPp F~s}@~f+f:P63
H3r~tyR}P? tH9}b  3OF
zs:Aj` mPO
  E03v9f"0fPfWF  FQ32 23-6@|p[~6{!HFP@2R}Y9"
C<	vaRs
9" *7vOb__P @X)W)į ffаHj&ڙډN^+wFV;r
w;v:k@+؋F @H$d W3
`6@3^s pq(:~6FN:7`6t 843[`Ff(3f@ 9F-/	
 SPdF\

t)2|3a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^9T j  "7 lVf*NW-00߀8 t` 0r 9v҃ F   WVA?P0bNq؋wB  WRV3^_7V @'=@S~u!tF0T QNV
V FXơDC@
P"{
 ވv3 vaufpocteF tu  q9[WEuEc>f4av3dҕ%! c~ t?B(r4@q0B3^
0PA 	 r"h V3 V3X3LY)Z3@03\3`3pa3br`qpȣl38n3qp`aͣ9Хݾ99p39ƭ99!ʰ9Zv~r:qd3vh3 f `cZP	@M^ X3
 Ub!ggu	W3 &?r"` wwh83t\Ao 1  1>kuёaa_	`{V` FV
22##b&w#2#62;u5;Wu1`=1wSa7`N
 Z3;aǨS$Sp{"p-`fT`m  3A3F
a%RV x
b- PZFp? ^ $u s!tF f+F;FwGsp"8z@O+V S " 	2  @3QFFf>6 tK;8rBw;6v:j> '
?+v6 68P 
p@Р@;"	P~t;Vwr;FvQda㒀uǁ> uBuХ۞12122;Fu$<ut
f>  po M% Ht pZM"69@2w$ t*f`^&G&tp&9&9WZF N%_  F9FИu t6"u
oFe P$ 0V;⃰ `Mr0Mo9AM@MQ@M 99~ u-B1N =t1QO
p{
  t6F^r'vt"&
9F29FXa2EcK	
$`$a8	 _
B@Au.n thXASF9F{P<@F= ^\l3n;FDVFRq@  9F9ni	+QmlpmKv	`-t<1Ze_q0S!v`$Y)P(J_4 b8r6\dk^9u9ukFP!d0ABs
 uhh? 3!Ƈ¢h9 9P9P
9Ȼh}9
 fPSS3&Ro39p9p9S 34G2p9 эG
{PafF :
"ukFC	qB*sQC
5

w
t9

	
`ЮAf@o= uΰE 6"~ 
C 0\
u[
 ufs9u6fa 苀6X_۔PPR/@`霁@^#br`@Q_o a	 Sf f h:F3Sp099oh.:  ԖtPá'`b q3[gwt38FPj9&_0`ɫÐGKC!ՍFu:~aua J~Ku.~Tu(~Bu~Pu
  t`" ĥz   ǆ~ x ~bB kF  !MSQ @@ם  ;؋sY[S `F@0Fwآ֣Rԣ`ң9n"\FH`b	 AW`ލFFV6!ZPFF~oFH  FFF^0ċFFFF u0F&uF5@B 0FFF'?A`VF *k%ōFP#
L@.OXf* PWQRU>@ > j>*]/ us>@ ul>L |is b w[>* L &D F +ȋѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tFǻ."
0 .!
<!
0t9 r   fa.>O.O! 9r & ӄt"QfpO u8Pwh3ɎظfP&.O&G.O[i Y0HYKSQ3ێËȋ^$tFhf_t~bY[Pf.OI f.p	PpPQRv`q
˃ӈ`
  .O
X tZYXÿ./"O
jЄV3߭p^]
 PY@ pσt2W  _^]Q  2sY >[
 u[
`lZ
X^!PX
R5T
V
a~aaX
c  p}b> uV+T
VfT
sf~f  2p+9Vowr@wA)
i>
 tZF  в` hl * %^$9N P m@NQhgUAn`PV7$
F 8Ft)F ~ t/$$* ^ u`+OJ F ⟡Rq$Toh`y?	-t-,tzwPWVVN ^4~&&Q#2#222##;u;u3Fs7f9 usD9O9r;u;uoO^_`VA;Ftip9^Qaf	L24	9a9Pt4ŷVuPPR"`fSfQfR?f`<`Pf;sf;wf;r v s@fZfYf[]SQr QY[ PS [2BppFt%&?	u
h*t_F
Qm!:P'  0Őw0: .9'1j:aqa*y'I+@0>ɱMQ 
pq&Gf \DR 
4C9*d !۔	$
d
ڤD1u`2Ru	s22ZPRZXPRZXlpaIP
  F`N⠋0C L2aGÀ0v0í^  F+2@ @tHH  \^
 t\
!f`
fq d
-	k d
 @h td
37d
+
@2f
9pucf>`0i4ߣ@h
0f`
fj
+j
l
f6?j
2+[TQUp΋d
W)R%0PÃ> j
^x0]uݡmV+NFu3P\^_f&@gp ?ws0WI &O
NPU `FF&9wv1hV a9GtS~
uжVdoY@vthn
V	`an
< `܊q ݂ rr ơOVfWOˋf V0 +N uf3lf3@fƉFfFfF /lVVv ^`^~320Uf_f^]н2Z
OfCORPfEDOMf`ǰW'fufuf=23AIt
f_=46AI`([`^_`p< ht#FqKV1Ym`ЋV
l_FtSY~nF&U #@P*C#~ ~N.`xDNw׋Vw~"WV~yÇWVRf{t x.F&%G<ar<zw, arzw :wr `6SpwਉGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ϒw^FV m*&'*@?û@ &l &n f%$Pf P%#f#f#f#f#f#f#fXS & [Ì=WVS3й}G@9;Vp z
V/N3Q||8 pVفKu~f
r;Vwr;FvN3ҖOu؃ [^_oN
Ȑu	!Sf
Ӣ$0@<9voFMSW SR3.:uJGuZRƀt%@uP{߀09t
 t`Cr< u	ZXCu33_[ö΀__SM__v_DMI_0 _a$PnPB@_M_SYSID_>BP ʡ1^ tc'dD@3NtaA t䞊аȑ +tۂ6 0S                                   !E   
 UNDIUH1    @ ` .UNDI    H?OPCIR3        H 	  $oPnP _R P!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.9 Copyright (C) 2000-P 5 Corporati{on19970 IntelAll s reserved.
 6
, P?XE-2.16	&MBAi   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧF_Pa &fPff9P fj:6DHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVVgv ^`^~]0Uf^]2 t{@.2H?0Y3	 0QS0 [Y .>~ th  Ph3Tp  M  FP?SQfRWV	h@$Af.>? t.1@  ځ>  U  r r h@ ۹H l 8tY[i
,EC1: Base-code ROM ID structure was n8found. ;T0: ASF is enabl21 canl`=.   YJ@C 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6zP |Q x v tj Ph/&u
˃Z t9hbR@MC_L`Mer() ==  @<r
?hC%DM0F: ExitingWLG6^_fZY[, q . fТ 0 GuEI _f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.t6E.v .x.|.zr
"@?ЉV%H96UYWoPf6UfKV  q p q t tƐ Ȑ:08P`d62 3BIOS extended memory c m error56:f driver image6invalih88: !a7::">segm0u<9:AmNV+I u JE u5hmd+%F3 FCE)
mf#?,C +f^f.E sDhP:Jx5  AH90C4Czr?vf&DR?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
);huB  ءL ` N b f3҃Whf[߃ fR}XfZN&  Yju P$8v uj@DH _F F R7vXwt!
u0Sf"G HF +F )F[fSVWFJ  6/##FfTp`   f`_^f[^^f]f_f[fX!8RtQf    pQQJt u. RVVfp  OffP= t.. ﾭ.
s	N]&}t	q t+{f&} us.Pn9wf&+f&;Esp RfXRw *=  
 s@8r&f.+QAP.uf`1AA	f]3` {3 fP2  X$Bt s^+G3. G3@0 'G1C3 C_%=7Cs
  0  u	ŷ 'DBH7AHuH9tH\s   	 u&<Xt.;60 r} %RA߃XrإA< uwG&DA ~0G  &LmpG&G G"*QGH(H*!H0PJ8UJ2J:.+0A6K>EpLX:Jh1J`t ^K,rN*q^rGp*. TZ
 &
$:Pc1P@K ? ߸ f[]ˣ'<fZm@ȸh
`4t
4fX p+MW Qhf!Rf8f N` f  u H  ւ5B;/fp0<fPuff#H`2duo fadð;?(f0@uqB6	ItffPIpZH
	t'\  cљҠ	f08fZL f fQ
Ɛ  
f
跀AD f]9PrȐRf w _p tfZ A N R5%0
"  @tf<1fSp A f@ a fY&O* @82SKaRxPf
߀úfffZePfXQ)Qf
I =f;tfI{uZru$13.p.P #.V.m@P 	P@@Շ.( SXf%$8 v֋]5~2 mf?_SM_ts OvQj S/A   ЀwrgrafG".tWO}0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3Ot7+SW ߀p$u> PuMu	>p Gufq|  `f> otf? ӀpfWf@   t;hY`u07:  PCIcallsupport t 	uQ.;DK8Dtttnh4W댥1pnRDevice!Pgpq/Y	4͟ read!
configuration space3ff`j  wP Xu
С |U.gt/P{>z_fR. .P 2/<tRhuOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `!軸0pjfj1;`f hfQ `u0h
 Tb%x
I PMM func>numbe` u&h61EҰ@"ocqpC Gfxfrgfgfff{_ \.3ڟ>? i ?.H@0tt	 t5` Vیfdߣd \f M&u Mzel h`M Mi |%Et`>3aFr.  q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                         
 2c (  vR  A  UB  K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"Mѧ&hE!Wm@[W &{ v  	U0 
& P  ` 
U!p
 "#  
	&G		1 #&#$$'b))0*8****)*,0/<0$$/1)5DIX+802.3  tttttWS ˌt&  .6 !PXEXoQ1֢1rF33H?    sN?V+,a/E@ @fUfSfQfRfWfVfPFwO. ~
2&"2ێӼ$6h@ WP
u` fXf^f_fZfYf[f].>  uy
  `  fv
Phm.6 j `fUf	R	g]g}wer`C
f&2؎P
fUs
Sp
Dq
f]֑
f0& tP u	@fbڃ>2 tj Sf. ff2  2. - 2f3. 3h f&  f&2 []^j 9h uf. fh `  V@ g&50"+g& w^R t,8@
? S_\[`1	eP4fX&
=PVu NVf. -f ]ϝ% % Z2. *2X	S[	[P!13یfff[F @]1 QN"..YRfSQVNfPp/.[qff@p  Of vff+p(..+pY^`4VWv^~F
N~)Ifȃtߤ_^	PQWf8 =N jQY_YfX]dFPC~ u0Nː  u^&?鐋FA=5FEB{ C̃#1c]3{뚣C{{A	q =	gC9	]5	S1	I#k	?	5c
+! 0O== w.,0DNXblv>F~@ˡ>8 tQ h062J8^&G8p 8&Gq  Q
806A'8C"u!M3 c Ȑ{Ga.z>6u3		7fj@ VB3ukP=5$#G/F6^G#FG%F 6FZF~sE>6 u>^*Fr)^V  Y tɿ0zc!G[K TRt@->q	 U8 (. N`  Dj7
T2C֋^^V0B9E.s!Q"t%/8p;`$Gt+b=' uG t>G E
$e
P7
$W
F- VF^"q
+tm*u! o	
A	

&?@ 9 PL P l5F>A09Gw.I!GL0
w!"9wP"V1xb-&  VF  F.06:F**~pT^P0ڋ^Vڠ* usF~w'}!D(t 
 2u?!!",>. uF?> ^aCB0yO0eN%(F^F pD {  t2D^ߋv&F& ~o|T./v@j@L*KHt
H|p
H~HPd FF^ftvQa3\Fb :bF"v:f&p &@
3p@
 w,<s@2<:1;FGG &{G(*G,fG GfG.q(" G` ڋ^_#[#*_%2K$~W3bFFlEK.BIV^F9
991V ZF99 O9A9C R9eaViPԂ,bF>v)6F`s(ksO3t`dd9iE;O<OMOm?O_zO_%O[ ` pO*>aOhOcO"6cU/%]ur{Z,0taG@6*AGS1`$s
  (2Phn@ճ4q`* 0 &適P4t4ts^Ԋ$&GU	 
S`gVxa$GUvRtxcGqG
G 	b
󲓉G2y{C
z}SQF 6.蟖.f0G 3>`#cbFTU O- #p vJ  F$u xu!F t_". `! m"at
	r'nk>t,j.Gً^
F?^V䳞1j!m.
O2(^rPL.-"6)R`z  @^~[v`
*&oy0Q @ ju+ju$ kucz $.FPF2eTJ'?Aq&'tR)h -  0sLAT7> p 8? > }z =F|!F+- Yu2wÐPSV °N9u2d~v@4 nGbPPhÐ@9OZ@ȐrPj P3۸7 WF GOV@ RSt `pؠ..pG= T0S Ê2 t}sF  ¢ @ .#
 BF+yK  	22pu#pPp4 ;FtN @VQȋsY^<v  ^]NWfP2ff
úff~QOfX@_a]R_YSf$ @	ᐜ2C@@AQRN;ssZYX]1ffsRP8F2^*/N@F=Dw=Ds-t01-Gr	- vHHt
P P 跊` &ۉVjW t	3 cVFP1Ƈ  ~33$("L_$ 	P24	ub% ܠK@
!ntBBZuV
E
v00d! PS   5 ]V `<KpW% _F 6 ((Pr #ؐRPV^`.}I+A!9 u9P{u   摨9@uƟ9PugMP
MﾺܢMP%if+f9Fu@*~u%  O#!uKഋN}E !t ??,` M3 ~}+vu9P
uދϰ^+cUL@3$ÿ%pN DF+v&F9F|ԣ`L^SI^ceD^$@a&n6tж؀gүaa~Yh6k.snp@PZ[G
"
"Ph v<@m1腯 뷐R`gǇ& mtGb(#*,c.	{0	2C
4'qqS!G O3Ш"A`HGCrSRӸ t  uL0Ad{|L{ S w ?
l`R18
] }*$s6"$5sQo~ +	KZ@_EfFF%RqqNA#;G3  G"V>Rl	F9FuN @+FH~~ tQ  V_v P2V0w@"?@Pi
S*@u#(KQH#؋vt `cpFwj1 !"F0G+0#(I#+)ؑ#D1_0e` yǓG z CbCR;FBS <DF+FBFF AP89F;FR`CBޠ:\>}V^VUr$"F5cHsr)Kb$ߴ fs; J+t"(  BSPw @u&1*Qp E<0@]ɲQ!CZ0kE %BEA9AuJ2pBPO*6R,1p 9VD9v s"    ~ ~8,)Fyz(3,`C@@3"z@N뉡Yr?[ǩ@1+0V;FsE+@X02FbGWGG\
Qb1RQS1]FZ+*.6, BK@^/*B?qL_fwGvhJ@@B{ f++J`,V
pkvH%HHb SHzAP9M2aFcE!VPp{F G0?x.%MuP
`^9@t @0`I5#@]
u bq41NP y.p++;u
;ӑu"aaQ9p|v[a(x t
E'_x t,9+c,Bo`1t3"/$3e4|a3^9u@o=uGtDtDtu#"yjef`jp|u5^~1AFډG1ДaGGW,R`_G'v؃'$@ @V8q ΐE`ikPPfh  fh  j=PFPvڐ
7rc uv j3 Pp O
G3
G4
G5
G6
G7
G8tjG-PG3&W>2_?G GStGF
GВùS9
΃P`KjǷGa%T"8^
0
*
$

 
$
(
,
0 
48<@DHLPTX\|vpjd^XRLRPpG S3&?,=`PV9Gt`sP؀`m w0
r@ n
~u'p, p/dD t` G( [#	}}	duB$   oQ` s j  a" X O	t0C
C? C  E
Āt$P
3
*G肰fSG
!WF
`+ 
fhFyBa`j2O!q
A*+nqfv(f
ffff 
ױ; t 
 $
Zp@V`v0f  t	_Ր /@ 9 `9 w	 	{8@;4誱Z-bM
tK" t t
!Ǉ  PH^G H pZ"޳p/,	a1'	^_`RSfpH L-=+0J4cJ 	 B.430Q^hBV2fg
q"U@Amq'gv'4a,PXW4T^fGf!Ff @@x16`Ӡ~	G
	W
WGW199@:âQ;gF7$ 056ef ! @%)RPP(3` $ %cH
r bO
q u*ȋЊOԊ~P9OъO: +*>`<$XаVAmihdf
\*p|DnAq%'o0)V+Qp#- /q3103qB5@7ar9P;s#=`dsZ3ApCqtCEG!uSIV	KucM
OvsQS1wuUWjwd	Y
[xS
]_AyBZacy1e gz 
iVkQ{m o|qV0s|@ѧ0u #Pj~3`~CpqZS!cрsFa1e	T
jCA2 !Z
 "m#Q"$ $V0%#@&a3P'UC`( hҋEG֋I K QSa@cDe g0BA   )+O2TWѰUӴpt0	U4			
U
pt
pUp!#%p	U'p	-	/p	p!0)4btu	a`abIPN
`2{SM4ot *H hk0!MF_сPabtPS$0	Fx1␁ri+c!lLbsPS=$h 6{Uo2ӽ!hgj@c hHdTІH	pf
ఀN`   !
@|	HtHtOHt0af2spdw 1p` @yf`'	F2Ezh P㔙kls FO tCQ#3lC@@ G#FG%F^ F^VFVFapF t0豰Ff%  f.^_#GR3_%FtE] G_rt%_>. tB_QFVp y

.S @3Gf Gh =h =5ࣙF<ؠ9Gb GWu 04uTFFV FF+9Wdrw9GbvV	0@b#rrvk t@`P
WN@9F
0 
~3ã33E$2 P>BDVf0!"p"t!F!CÐ# pDF CCWS.+PF.!YF  7u	2J0t 7Qx \/PF~FB0}B0 ҁ@>A2r~?? @"=~st0PGGF~
uFB,@2 ++CP	+b+F/t .u|0Vc.f" Qǅ ` B f`
s	L5
` @P?butѩPhxB чp Ft!qd at;뻁
 <
  )U~	b1%(e+,J>S. (` ePEPRpG R1y#1A`oJO    T }r1W/ƇbcE/,
p' s'G
>U'.G%)/]PP5_aUT$(QФ-
c.RոB<9p'r'%e ifqQBS1B<жKv"T ak/02
  =` Ӡ0vPS$GpG{PSfNJ9u2av@AGjV 9GyapDO Eg@ЮةPc!ب 0A0L  T@gnZn<`AFGz6Ղ%ې ]GGvtx,I${ w}- K>f+fCa
  |		W+0v#1h tPfj ܃
xÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.p%@)a~b`   VS
2u\NfP+L?pj 3pG% uHR%1TL@AM RL@|@0@ @@4P?R?ۀ}T v?g?\?Ӡ8ݞnFUѰlt $a%Cѳ\@1Y3c3.DD
D epODODODOD  `UV
fqt | t^F&^F&
uꔖ} WV~<NQV?^_~FN
ȋNu	 ]Sᡫf
 [                                                                                                                               -     P16X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                               .6                                                                                                                                                                                                                                                              eUPQRVW3fu@F(.;3s0k@.$~ ˁ ;u
t.$t@~ f^rf(_^ZYXWQ3.>32 .ǅ$?.ƅ$ ` P@ht .3 Y_$
fPSfQW	3.3^h( ^ hRNwFk@"~ h 
N~f.$=&@.$2.>m <$Mu3.B$f<t	f!h@c$< F.4 
_OfY[fVF~r$F F;F FBu~w
fF~@ M~U?fNf!t
fN!$pu
ffsfFw^P2$pj4Q$
fqDF$<u&f36$F # ~$wp` $.
u0 <?u8 P^`)V.k63@..w3.`/^V0&0
09t@{-2x@Z2
E/^S 65^5#5$u+:Nt@ֻ_^13<$::
t3-S9)Q9$um8Nu_^7fPf3Vuh  fhA] ^fYfP%
S?  $(t uq5u0j !0 `*-fVW}fpF(3Fq(('F~Պ^^h<֊FՈF 0ff
J,F f^Vfw^qu?o @  QV3 fz ufZ^Yft23fߋN Nf~ tFt"f 09FvAFH;F`0Z 	QI Af9Fv9fHf;F!:F׊F8Fw uE3!:fI"<`<Af+ ;NsGf.\ :^3(tf+fD;<
I;f0Q~uK~ tE2daP_F?.3NP3I3@_fd'ag	i~"
S#0K"# Lt#^`#F  F_F$
$F$Vf` ^$"] $$ "`UquVڀ"ư NҀ" tFt'fڪ""tm"+d"b1"a2"fw>1"7 %/ %'%S %#% %ъF8F 4  Nh!Sl"  $&(U,VP2@Dc? ffbh]$Ntt2(sPeS~Qd9FvI" 3f%h   f. (?Ϳ  By׋N0z30b
t
F%  .`, q> hă~ t!~/ h); VWUh(B t  f yy@N fAh 5 P{hQe 6 h/<rg&>Ut2g&FP3EXYPьX\P0(vX0}f	][Xf`Sffff hE93   f;r[hU WX
_k WH_S0"J rPg{NAg	rH. u \fawWfgf&Qfؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_zwU!yg^&NH;=g =f> U?  q6-A])QRWV^NV v0Wt6Q4pdCY$DE^_Z QкК tYfWV3ff1%^f_cfSVRÉF~on1xZ^f[ffABRffL߀`2fTf;w
2ZǖfPRft#f3~zfdpZfffNN 8ss4
t}}7u+%
u	~afFؿf u`^^ZĭW0ZF8^~wI^B"8uAffFm@b_QWVfwvA[F׼_ϋ~f3`RiAМ$ч45SV ޾3; t	 r^[à,Vk˾pP#A[S^@䊅$*&t@;v7ϋ!tk~@t 1;FtFk^% Bk^Pߊap 3҃  V3k`Ջ
C*䊁;oFuR3t7*t-k		# a
@S
+FHu
4uGrvFvVBs0;؀4VW@B΂tSދ[NuVp o3ҋ`@_^@ʠ**z^S(IR}l2XHȠ-HP$뷋A3g7Z  fGVRfQFu   kv@okF.b$$I$@frDfw;=< u r,.$<u r s0	 @v_FfYZu@0.3FNf1~d
t".tt؍׍f vXv둀~ }ZxPR00;F~f-!20a㐥""0P2N~ tKv њ0`X9]lq.A\$`
fPQ3I FfP"f
	M SQh3	 \ZPBfq23QR.3Ѯtf.&3.`.83tY~flPRWfQ
(5.'{ "  u߿8ufY_ZXNW!` 1V#3
;6_@+f`  Pfj}7@
xVfWf.
^2ۊ~$=`&	?ftufP f.3| 1Ӡcf.@( h
uF,8Fuf_@EbgR.>3s$	Q.k63.3VЁ #eq 8
 v@a
#3t#ًË :u!d;  v t'f#pffpp=prc#n;~VF"y:` u{p/Bqrۀ[tހ~u (i/
 t>x"0`{(`Z J I<`:<F  .3;2;sN0 t4v;2&;zf~FN@I.3e:2fV4Pb0)6SJJe{([tҋ\fۂf`K8faS/ $ !V V03  1@ ^YX@Qu~  uz0V833?Litk
tw
u7Y y	?_^Hva? ;chpxpL" "  ta#2JP ؎Xu	Axu/ u5 ï  (ru.LÀA. $0G WoC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   A     TPM U(    G  N K 3 U fWfVfSˎێf3  _f=G<t<t
<t<ti  f[f^g.$`f_tIFXTPMDRV-MP-SEG16 v0.95 Copyright 2005, Infineon Technologies	QfSfR
gf. 
g.a3g.1Ƈ3 4 Ǉ,J gf   u u  fP< fXf1ZYcQ讱Ot[RS  gq	o <  3[Z0 
  
2%uP 	xcst	 0	f{
A
2

 WDF<		
g1$u	
E|C3f
f%Q`&3ɽ
$f6Kfff˰ gCA 7u3gF b`RfgD`"gC"f(g3fGf߹ \"agf4$ +Iffg` fG(  (	Z	_fGg'3gf`Ufr)tfJrr`i,Z4.;gM1"2.3N4g1  f_fY`>Zf^f}PA9!F3RQT/ʃ`ʊP a  3YZRfQSڃ <u1 u%t<u u3
߹ w 0 <	IR	컊T		 0 tϸ 93 s d _ psOJu0t  $&&A	ML'a
pn qv2fR&St2p  f  `OQ f"FB? 49 f t|gf> tup ~ tmށ  te t]ffֶ-N0.^.6A\RZf;sEA\u
 ',[5 1 
@JB$
gb +\^Ðdr
3ҷqBH ` u
5J
0bu"K ЃuBw1dUogG"GH!G[I#JHf<k>gu0hph~@ Y	uBjd<u/
uG u\  OƀtHDt$2ED$@ff+f+#Z舢qu  q^rQQBNL$K		v
u YpC0b%3 wz}ǀ 7ujPbT[4\ tL2`Qxff3ff%f  gf!a	QRdgAbetff<f;s gb
fgucgB`ZSoVo oA!o'oBmpEqfgPR%S%"R%Q%
iEgxr	S t9
 [_Ҩ% Ƈz1yn 吞RБ tk [@eP{m `rCfRS2 !@^R nook n```` s
@l  @nr
 蓦 PagdTf_3g3-3-t
1#H GCCQw	000
000 0j=ݱP>~p%a"Q,k+A-$#qrqrtP Dtt%53Q . ) t  tA@tt
 22: T,.bFg%65f fQ! !Nql݊q5qt21?  0w6a`qtnf+fH  gV ]M6kLPaG.O_!t4DY+*+s0,rF`"atfSuN3 (`H0  W. usIu3PiY mX7PS[`4 !6&  SIuއY[Xp$
pqS oq[ჿA tKC>X p3P   = pr" fR
4A1f}f+8f#b%  t	fˁf{jf%j
tpe/$z Fidk&   x < BufН         2 8   ^      SEC3(     SUW3_3 G܍M  S.{0.r ۏ R f= uf&TCPA W HPD1\_][U˳ "P		  @ z
  @  A   < t.` t<w!3ۊ.;@ !W 
 t_  @  4  `) nzp
`<wX1R[1a b > 3@ upawP.Q< `0~ u~tPfAi /@
t%f=uaebS
RuCfUf   0k "q  
 FC1ލ
u
 
s4"#@A0f] Íݷ&]0'7F!'4s  iR !}j]@

% 
@
fǗ  %?34QR
_u" 8?	%:U	0?H
2%8L8  6WX
hrsqˉX
WFR#_  "-H  u7fEfp2<#5#6
M)F <0<Q6=U6fPvFWfX(> ?U@?΀?? @U @7@@X@p@E A@AA BWBTH2QBHH@83 ]. 6us9]Յ@κ軃%"c᪥tK%
%
\\"
I%v5	u;2# 	t	1
T
Rfu aZRwn u
1PYUjc1@1VmP@aPaul=qG`fQot<tvq `,^,YPu_ƋA'ar	u_̴ٍq6QlC
{u/FfvuQo}uxA k e0Mw@\
q~
~P:
@a `mbcPhpuf]ZVSvbrl蝻vZR8_`q9hgA;gBrQR`p|ZYqUCŻaDtxw3&uwԄB{ux$ pP|N9`tA|ba f;tCC` 7C@C
o0bC3ffFfCfr#=qLsuM4@pNF CO`,OP
tpTP,OTtWK{@Yff_fC@XPS
rYUY D~!֋sKRp5ӜqaoOfUV1(a Zё#a ѫoXCr'C m)%!	*ѢDVPV^t@up H
CXPq8VWx_^ tKS[t^8srN)P^rNfǷ u  fF3sSV+1-$ 끻qD;w4ƀ1W_r#^?[Vs1	Vfu1+^&F QVW/$q}Y3^ѻ TA FKZtVW7{ P^?                                                                                                                                         0    o ]FprT@F"` qqSb@ eCompressed BIOS codeOther     Calling INT 19hReturnP
 via#8hBootBCV Device 6E6    IPLCPU _patch                                                                                                                  #EgvT2b`4  WWsհǃPǃqǃ9ᐉǃ01wЊƃ1r u
@ow*`Q  	@g@_p
ȫ_a`Q;d&GX7 ;w+В +ȃ73󪋒@&ast@3CÍV_3P Q 3ff@r	#3Sɰa pw#@ yZ1'w33n!;wP##X~ܼ	2b[
fۄſPAbc"aW	RX APۂA𓍳&a    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  EByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT CALISTOGA      d 0   0                   BIOS_DATA_BLOCK   o  d1305Intel(r)Calistoga PCI Accelerated SVGA BIOS 
Contact Azita.Sadri@hp.com
Build Number: 1305 PC Dev    03/20/06                                            Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ i              
  4 (  8 H 0         2 D Y
 c
 m
 w
 
 
 
 
 m `   `   `    @`   D`   `   H`   L`   `                                !                                         0                      @   H `   H  b                                               =                       $    (     
 
                                                                                                                                                                   !0 R`SI-1362-A   p          @                                P                                `                                                                                                  I   <     <
 2	 Z a-  	
                                                                                          	                                                                                                                                                                                           < P 00C      <)xQ 0P            <                        <                        <                        <                                 0H d @A &06      0* Q 0@0p      /xQ&@X      H?@0b2@@      ( 6     6     6    6     (              @ @ @ @ ,@ @ @ @ ,   (  s     ) S	(		
	(		
	(
'

1
(_
q

{
(



(

(=O
Y(
(
(-
7(ew
(
(

(C
U
_
(


(

*   @ Y  ' 0 h  	 `"      6      X   @ Y  ' 0 h    1X (      6      X   @ Y  ' 0 h  d @A &06      6        < @ Y  ' 0 h  0* Q 0@0p      6     x < @ Y  ' 0 h  0*x Q@p      6    x < @ Y  ' 0 h  /xQ&@X      6    @ < @ Y  ' 0 h  H?@0b2@@      6          @ Y  ' 0 h   P 
00 *      6     @ < @ Y  ' 0 h  ,@`@0 *      6 	     < @ Y  ' 0 h  (<p#@0 *      6 
         @ Y  ' 0 h  d @A &06      6          @ Y  ' 0 h  d @A &06      6          @ Y  ' 0 h  d @A &06      6 
         @ Y  ' 0 h   P 00C      6      X   @ Y  ' 0 h   pQX 8      6          @ Y  ' 0 h  d @A &06      6     +a N  XN  XJXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                      U)CompuTrace V80.829 \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      Ow qOqP WWsUPX!	 nlAmNa &f`2a UVW~
3vNWXZ_^]
 !~3АH9E}!/f`!
u`"!W>WVIVhF۪U rr	rH0n`w	fmq29%fUْ!om̑3ɊF0r	wk
"e <ar<zw$ߓ&G+tdwCu*䉵D]f͏ ^m^ǓGGް;v2Ft	
n[9ؗW75Fb,1hCV~<=t }[2F uƕ@]GscQm^|
HۙG}~wWCfEnGff;sB_V 2mtl9
3ڸ W+vOΚ))_J?JѰ[.	<	6V8d]l,\l]Pj{[ lOPhC
DC>C5ul1?C4u uxytG
	t
ƾn2jn^6]~5?t$xNF[
jPw^97w3 s)PP-՗ }6uUۀ |F#juu6>b{,.)'?8Dj
4
2
wMv21
@uf
Ϛi4$hЊF#bPk

h&Y
Jv
,1oCjel*OWenhh
0=}kT{Nw?^>|::VJ
UUK\rP h0t\V4Qdx?$dF3PJ

ݭLAL-hRPӀ'j9sT!A{ r!HG;tg
[4J |;luh\":2fRf9Kt8a'WF뜳\&서Δ\ެף"<Wz摅V_>u]XZWoQ hLDn\'އ2k$6&>O`/"F)#K<Den%ᄳ6$vP %,`uVP' vjX6n;vt_kj|ԾwF
5x sD_G@ui5FfdE+
w;Z bu.hVkD #Wlvu6r83
o^ rn ~ޝu&j o{F uWkÃpLF3{Ulk%o[T#
N&"c?٠(`58^	V1
)@@>>)BxeJ",h"Dd,
@^~y
 JD(PypZPH,E%d|(@WuJ,|PNB?XfpE'7	=r
$oyR#f1 2Pu]VnK=kv=,l|."]	 (PhֽоT"brR" !mVB3xV
Ђ:
0&
~Dk>)Vb.WIG<@|] Ze%' ]$D0ݶ(4
 5dEhVDMuc5 W
'90|{"`FJv-t- tt
tuCnu7u9/u/yUu%}7wXeoԀ}% KRPS4ǨW,;2j-RN,u
۱<<S|-TbfInr JYp!/xxNF>'27Yv 
<z%':6JC$I3gk-$Kn
W	6<-b~9uCQ*jK,2?$ X#t
YKjVmZ:ZXm8:X:mmO2u-62<9;_"K0hH!FT2nP#w`L7[[PP,dw$l\ kaJ5o9t<I{r_uG7M6Jv>g:Avf#aA]Wq	sc ,7E	P"A۟|R`\#< XeXZ'^cN,"}wV( w#VV!uU33
O y-[!bύW~ePhJe'BVWBr$KukEKLLfMfXfꭆ[5Nf+,9tk'7KwKY-\po=w!u:5o*tA<3_Pҕ,*$CƙMtZнt
.-
4	s#DeYS?\t iFt+ted7ORNޭ+GH#FDuu <fH+#$7#H3l;N3Y|(U*ۢx EG"7I,5P( W?4~r͋JK:MRP ٭[j1I>
#26U$<uT$_f@t=%? 	W{%N;xf8$ۂ\^FOwmto㲆e*c:ğ
a^8mč۞d&ًM$NX&(zl NfPfd "ƅ0CYJ%6h JiI\	j-[Ife[~ƥ3tE^<R;lu-þV.GV$hs@	fGF!"+= r9puB[0~k 0y	t Jxt]K0Nʷ`H;;u	Xd0+}-^? ?CCG%[!L:
cȁmWs]i5Ѷc)xR+:ʋwO
9UuNw, 
~HOo %l4(@Z
6JGDsuDJҎfǓFN#}`  
HgClD(?F6,H/Dhf#'`J-`{ #~T`^,/'Ui=hC|$-Blxn޶.ئt}w" M6N	q".C"Plwƾl۹ZߠD= w({.2@usyj95Gt/@nd+@u2{|@tR~
׽vuaJ?C:?7@
?+1+s>{u$N0BKϹ6. ؙ
;~rc
i./a8CRU+z"TkBNO	rm{d
\q&	2
 r	Xvt9rw9~6
?P
|+RH6Nr45x4H	^$#l?tDD>$S
=yNQ-H:+$زE<>:4!SH / :}3G61B'R
2$!<ezi~O#<>e[(@tetK?H! mΰl#EG|js%W?	N7N*q(>gϦҪf࠾?wE ۴,ۍQ)b˴o;WPP!{;P tIV%Hnk4h;$Kaz#VNAJ|BdFpn*UFń }歷.DR
j4'ZIzJx ~SHPIә(s
`|G V=IKu'w"dr!:c'I?F*R<Zf#Q,pnBT>'OV@[%tZ
t=.DA;pwE8`ȇ,^l0Qfɪ3bEMPUG mtٳ!Չǆbt#MfU<Y	]äFedt6ƛ
;c5뻄D j;xa<2`p@¼-c@Bnr
M9vMu	P3DVP<ZvLuMѡ7"+ҋE0g;tcF[fF8rf`˚ R$;F3u/-agf'/OB;a;Z!c떼:\a&NQ\fN{v3FWyRȦγ`2Z,)sZ}7j Za3Z|R u2ϊs0j0'/^ 9uH9Fo[+C2&D6L_P=)?nq֥&MvV;lNQ7Vl]G3kvB` 	
|,*rXGrLv!L.fSҗaCGL%'=A #"A'l#at$!!U"ۀ	
	/0'vL&DY.LrHC6c;l6,۵2ތR##*eT\2ʎ;6ƣ~ǖt6\-3߱_5+~u&# _̌.ƷH(j|v^[@%Y`PC[Ё
4-4m3dn9W#t\Z#@9jt [BSԽn#lxF"XFe]Eܶ	
@K%^3H+-P ո~&pV
B	LmG=Nzfh`;65b;'!f%T0eJmLtştdkꃀmdPVYGV-U"t*{¢ST{L鶆R),Q
@
XPjҏ47`Sr@Ĵ F/Of@v%
{l;Qpx>R/2)35T@ SVjd]Wj
+h^YQ#
N Q#_7;l*=#DD wr͢FWD 'hu!*rŠ%,k{BpWI|}0:.	!wFnm&(.,
ptXEj$$;+*^%4%#5gy {OMP״5t~
!`C)%Bev`?}"0;vp1+J	B7+h2~Lp`՚Ko%GtU꥕ϲdkw@D[MQ
09pv*ι>l
MN
o
7
:*m9sV-nTO;v})
e۽9,0FP;cKSWЋU'9`*R-xɽ'q{zU+x1lR1u4W	<{P%; X:,
t3,;K;Tt%3vi9	;uVRR1#}sS4 u;|0k"aox^;+D
-7k	WN8^E@t
zxRe.b{etw :^	wߛn!°
D\3"&C34v<-[
LQFmG/haٚM@Mj@r.G$9bd2/HH\ -EZ(?'lhOl8'_ms(9yq{YGYwQY2r<pS[AE/9[rK"r SuS.h1_m7xjP.JD
+~jz8/epֽ?W)`^l
A1^E*}~ /9|W7[3? l+/,;rw;r-	6"	pf:0(#6{\{!N
*A}t( C1 BaiR3 REٶW"$W۾ge:|Jowzrgcss+;T*6nG^Gwj=& Gso{uV܃i~5JбG݁26T|Pl͊
BWh A@fbG!a]oՕ4;u)^LQWc`N;P<@;;(
y<Nkw{p5і9
kG[uՎ?`s@? =GKpcG]+=\
tE_@Iv~@nPyt¶uZ9seD܋ʃ{+[; @kaqR1t	D	&,q%<H)F`*R,(!7L.66E@bG]ŗt K|	SԾ}ݮHu|CCQ+!"ZusHǜɄ^+674$GAB
v"dO&7gcD0m;4tfKάʴwJ(`_\Zc#!V(65'L8,d`#hJ8
uDkLs,5\VVbѦ "aAH![bхQ;<*bL
(${k$Hx
]Рktq,|=0yUzDNoR
fQ6pf]wP
ߞ6+T
TK|wt1f+4A&`Tyi+ȁqxΈSd/NPG&&>*0xhnl
?"oVWVvB=[%.85;)n?6oL6@m&TS*蹳#66**OdD̽ LluVzJ
!
Hoq|-+!VcXs)I%ቦ%di1GNIs2xpvN X\L1dlHBPF/a[d]Qm,#&z#rr6Xrv]ANY^Tte<@'c5a5fj8#'2R$<Mؠ4XwHmTq2 ;f)gRN Q{u$A/V3.ј5G-f1Ujh QP,cO9WBtH/{C:Ame*PJPќ_Wf<OT+NB F;sfB;v,)N-PO
4lӆp04(!dYKBOSº%칗ɲe_0!{ lcτu{E 0aclt"9
ֶ	
lV[7)l7SdrA#^\K=^IP+`7|`SZ޸Mp -wr(rwk5"RL6,3#@|bVBD~=<Nm4aL0wm&&ҥr<xذ*\BVA6	"U7d(NΠ,T$lL-TRsab[	MVO½
r r&wvd He;+BBkM;˂7b49
5aFUG)K0G@8{	P'+5OFpEovP
QueuKtj/kg.3YЙ*mFo GG:k9|f.'|pp+VR'&_$>DOuҿA#2V]DEnl~ͳ#uM+n	>6w@ 0t1@;wGJщBbG
m5HIc,o.HHLWJ${DDt:ln
Fe4@Bb[
L8
%<Kw%6Pg+$LN%\rV.J W"Cô,ۋyDFV۷HTJo< ,>ޭu)D^m(AhgTD#6fȻQjqÛl@xYHF+JCFdDRzAXT֗mnVX]5@(N*ʋHG18v
6^8:3kUr9(JBsBs;V^~R9r
eЩxcx.FF}tj
5){^ƎEa~
D)W[2$0Fo22Ȉ
`e
0-81sRk2Y:\htfƴǄ|0<H_8G2*w96 w]9~ v$+ǹvCmTҞuk2(S odZvyr9Rg)>k6ΥAv;9u@;?S~v/8f5]!raeA-q+'multi(0)di`skrpartion(1)\WINDOWS \Sto| Menurog{ramsupIAUTOCHK.EXE)ystemo	BOOT.INIvMSES.SYS7inBootDirė7BAK8-rpcnoetp.exe&ϗ&&MZU{m-@1I(ǻOǶ$Ǵ/RichSPELiD1\%uk% } O 4XW(
e [d<.tta_#n`.daή2K
.c(E0'mAsAR'reloc'VB  4G4
*4MDRb4pz4Mbi
Kֺ/D7i	Rk\??\C:Rp"k\ee%,{Regi-ry\Machi+&Ԡ}
ntColSEU!ervicesO Local OhbjechImagePeh TypmEGorF#0  : \^Ib	hl@ d:$7ۉl+SVEeտE9EEdރ,VB-O~=hom9N3Vmo"jh;7V#PhPPu	@}` C|+E59640kkud	m@(-P˲7݃@-)Vbe} M}H ;̽
vk2MIv#3"H߶
ܭAR8H}
t'hn!)s>8?mf]_^[: ۗN/8F> Dt3(;p`P+L4afR@JbAu#8ƅ*H~݌K#@|L(<2j[B xC&0Lp!Nj	&e[Pxf2'j)_RYY3۳`4g-;u2j0(
j.7tr;j+̅ tWfCZ)A:p9fqiI:li Fvk{3}C؊(un\f342#	gtUW$6EfY
fY˳3WWiZ;)We}}c}cf9=ޭq
V

xt}S N<ƹI	W	gPSDn{pWI݉M@86\	9>uu[Ac%,Y8$S*:UW?  	mO0vz(MLavӀV.L6S9DWPZ>uS;5[̭̔ Q} 0f[R 1MaR%zBB7X
VjhAJ oӎL*[Xy_禷M}6ZZ`
Ë1l7 U949O`a'@o N7hȍeFilrwcscatRtlQu
yEnoףnme,Viab(_U c9Fs4wCDeleRRd0g
F9lKKeyW
E,|orchr nInmUcoden%
$ng%١s[=PTmk(6osٵupys]EAmwdQtdBll.@JK[
j9z>9ǚ3b9o<~<9?99{#sc ,6
NR5PHaCݰwF>dMpJNP563L=:S<|`Gr<&p'@HEYpiZL8$D,HMum7zAi*@LZfizi+aa;4,<MR`t44MMiC 0<NiZpi~Цi
".H^A@4Ҿ4MMӀp\4J>
R(sEI0Uzsvo&EyEږ ImOp**L,t5Ht2H4fois,kxklrc.ed+SRd^RequeZsk,lclI5kD:AvaXcvs Moz/4.0 (.mp*i$ۿ; MSIE 6;f)Eַ5W%}HatpMi_BjOSTGAd극HBsMX</'Softwav\MAr^]
\WKowsV8\App m&ip&ڟ{SgTagI'D-Lmg;: %d
%sts;}0
,V%%++*/ *!K.!@"rp(t(77./--K/ܒ//?3n#@.r#fF}MVWf=A3t	|$Kgw{dDuP&l&^ʋUa7jHkEBXYtVQ-m4-N]n'V 
&	V>4ڳ6f.ZsZ}}50Q!"E43>wr
C~^חBRtuKKF]jD}dH!G ssb# 燯KAXN<
HDm(+P	JQS39tuSSjPQ<0u 5&c7/;[z}8
	/4Dt '(!
	ɈH܍鴧+6Vu<VOX6u%A;*?AAYtlruE;>YP@4@C6k1pky~Eh/
hy75c64wf(iJ<
Epc
Z<< w8bƝ&HɋT/z
/01^uJFPQ _`cAC_Ph`l!=>sW`:u۽YLRmciAwoudBWw\(a!hZD4d#dxe FS+cY^>-W;\s6M%D0G	@3ҹMNvV`gVC~_^[j$hHr\eZi;Hww34D\@S2~rA.WnaHlB.jT6HCԑU(Dv%ލLPbg ^(uS^B*{xfZcR
[$9ߺ'v4+Q3 :"shYnxl"ܳO9]v/k u޶VQLЍQPfͧLI@mg0?P(upkNOZlj
,qKZ] -`̄vnR,ׁ`\̛`r/_tm׊2_DUW$lU{͒Ķ{=H
t"ǾTh
q7'dD1ӋeVU'ԝn_][%@\ppVub	lV0Ę.a6eVhM
N"^k >;-hɱ=URu
g{ؽ`6}PbniDCۮ-jC1 ~ H?a({(9VD]-u$0~PHB%NiP	(0mwmuQWj\d"Y2RFU.ܺxkGxׁRR@W݁
|3 hYW7v0;s<Uum?G:\hQ2Шr7:r]S][/Hy; }	^xfi;|AB
X9${whJG h@YSGA_@1?A
,rh8isl ،g,EVlSad9.$WnVOhlם8Sdkl mFZf~X<[>0)vCFxV#`} JSP^h~TV\DSb(hF9XDE&3s	09Cu}^u$HhdčV6@z6LQjn('^:F*͍劫&s.Zm=Bp6Wmml`叚kt5;t19PjTRDvWhK,k#gFࡡd`6𪋟^n|c|DhdCp'5C`<y4B}j<(/fv
P٥=3p2z`xL#z8RhXn5( haM6
Gp$eӫA؟'OB޽хu	=x!<]qh,`U8T
fǀRoCah`(ǅd૯h٬7p1XÚstN;u	;(8@'EVIw=bW$l9zsFS]]s9t	RoLC(jHv8Dr[H^.8
j(zkZ^^}W݃5`MgB+}9k
xt9t0+}J
06ٞed]\\]>x@u`tm-<M4^x-%2B!4,B:Yҩ |CQp$ ;!OJN^g$<@ 	^&3ھ
CQ"63Y 4XF@ ;|ܭI7Y䱾h5<VFxWQʑV88І@KN\77A謆&,7mb*eR9P/QvHR4IIs`ET-ԍ/n؁8!rcYf,SHH[3l-w{-6atqFW/dujd'8+APD3Iz%quSh'5$04,Eepdnw>d@-йP(%NÐNl0P2STg}̌<}V58Q$|($Da4
4SnoXO4 ٟ%JlFk(ܺH }nhb{u2!^qHQY.Wyz&5\s<tudYO;tiFltNpNl}T˝S^<;5.h+8+=,^+0tjh.\ր$lСY^t 6NT~Zwb!|{:u,ZW n,i. 
h[\DI4L%c<2l,,40=@@?*Du8B!ρ-jw9.u9'|Ohj`U֊4fՆԢ'Ǿ*njЩez+R;`3Zj5fKtdA{&FxPQsQ4ᓊ#lqbWK^&Hk!nX*
=ƸRVIVJ=hwUAK:o[SێQ 㬇 ;< xV`xXlHp3"Ԇ98o9SJ忢K-,CDVuύ-rj[ = iGob[m~$	1`v5<h0پF$\(
0L,$#,gwFtVR39w:Ib\ x^{hɭ75m4tFP,FmPZtL5J=:azhq~\8SFg!:`W0k}C"F3U<ȋX+Ѓ9Ul\A>
%wVRW+8h8Iͯ(p ϽnS ns
4PS wĕșV$Rnh<RP&% W4Wػp2x`r@$
X0{t
?ى=2N7juf(0sh8$ʸa N멸-4ԃCAZV4,+hX&8 t&Ĳ(rn3PVwKGu|Fc^vrU
-jfQqlw7@YWhЧ3$`t+l8QZj\
>hoHi98$X\HӬ>j(h*>}Kh F+atPX(|coWUZ;u|l|mtċF<6@?UYY`-1DGKe"A-r
'ez	p	0ń\|j3AC^GEr:H=1>R
H`x@~ Í3+K
X603<@GyVi
ion|;Jkl(mlYUk"K̆Qjz\\
3';mt;^
%;%>XtǺ#*u
E^,(fmGrIþFc:D_٢p}'f:՜!A,mܯ!l2(	Tf7CttlR:QOSqk3XSi|l5:{ӣ=ECe7 l|,> +L2'0@(vtza6E0!}
t M p4$wa?u:0ɯ?ldTXЛ[oPs?y"95\P8h8*LaX,qpP
y%@f^:
8zoWtt	øV5%+!CS[lp(8vIVA)O  H"0V
lj%谋L- et|Dvhy-DHVJ-q->t`5/9X(5Uuo* >W@(d8F;[tDA_%<x=)Cr"
n'gtb=hf+l@>P,kŅl3*DExAnt]v֓S#c9\W*\JW][Sŋa]-PbGt0Zh(Qb=XCVθ8|ڣh0T}[wQUV3ퟵEh0+p
«"	* R- Qu
V%][$==)]k J&V1_[$=93C>j{ӡ]ӝ^Pg**7`Uy\^`]Y(VTG.ThCT{Kt>=x [
rp Q PG/F׻X!kXУ!2uݡM Sx@@b*Y54AGS}h?ץG'"B_Ɖh`ɨˣ
%	9=&hä:﫱P}NzC"I؄1)cЊ0&pOL0 <& L
(
 9c-}WrيEdɖ!j4h`~OȨre{8;GzF\b^>Gu{vB9 jnUeb?DJ
J\j@ZPhX(UR[9N>~׀%y<kT7b?jHPXh6@Pڀ	cQrHP]
d
QqBfxJ%VQo
@A)!x]=Bt(JaR0ַƹ f
e/Rl?OGodtI+σNmL#pуwo$:
}p/\}9->w-SpK9
۱
-V
{3L"O 3}
Co^Bw;˓uGq:	IQ`)4$/M9DR3`c2ڮbӀ؁3X2ۋkapV2sf+!u!FBh3%^\Q~dl%5ow9d;u;},<t8;4/k	/;5q(]@h	sj}f[  xG9nn|~@<֡nw]6 xS]&z<C&gc(vCzEջFH	E
ӍY\/}tIuʻASB/m27u /*e2IUڢ+;_}
kA5oD~o3 ]5Kz62[ Jlx%À
w8~ۈo
}}}qwrhwb6Q}W)	V(L
V_	+<#8}[%G8۫̆<b#;2^\0^T Ph,<~mUkS{\1VO;bP}O;|Ԋ.b?dtSrv6R[PWtt
%+f|,aj.bS~[BXK~@$2\9a!Ȓӽك2. nD? A 4{8>r2ˢEP-OCK32)PuThdMkUK~TimerD(>vEx
is vch1G,:GeezfCN ECla;?Qui0 Translv-aPeekڗwݠZtf첑efK`USER K
K͛Ar)۪ayA}ForS leG 	Ev(@ hAlv1R
FFPO7eØ책ddrgStd[⏬f(m0mmzy sqkeG!
ZikAS=GI|&  ,itg޾+dAR`9#S4Codw{um#홌ObrppedltLZwCna!iL t
NZVP1|:B3Te2iL6;$(a%. X; Lib;(
QVt+pS=py|8lx*t@HB`iB[@l>[M ]GvT3 "O-P7lٶi6l.;́aMFpswH8aYp<atG4lP0f f"lizxStԜғKNELDz(Jڱ=d6Cn'r?N79[\'5	_=$sUs*{~KeTokju]5h5\6Qo
⾀Y٩QUXқqADVAPI EfyE5AEB!Q|%@(wʔDM5(MhGeSP=@
m893c(&
d@`! A1iQN
] F(GHdĢ̛
'i<9~a |6M=-3+(8G#  W 11333333333333333 444 4,404<4@4L4P4X4\4d4~4445R5t5y55555555556	666 6&636>6H6`6t6}6666666666677777!7P7T7778388889
:(:::
;%;M;;;;;;m<<<<<<<=(=R===+>|>?-?7?^?y??umPw0/0P000K1m1u11H2j2{22223Z4c45:6K6\6d6k6q666666657 7߱777888ߐ8888'9.959i999999:B:K:R:X:m::::]::DS;Y;c;i;n;v;;;w<<<1<?<^<u<<<<<=$=*=/=5=L_=m=w===>>8>R>m>>>>>>	??!?(?:|?V??Y<0H00I0U00000001>1L1U1f7%11272e7)22$3 ;3\3x373344#?4++G4V4a4g4r44444/44555!5)5L5W5d5v5}5555555?566+99|6?S6[6b߀66=

ރ%767C7W7k7|75777777tAz88
9q:::::::::w;(0(0,0 80<0@0D0H0L)TX0% ibP111142@2KU2^2?3H444ė5p5~5;6x&677(7DTGAа˂(     : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   n   07/28/06YUGlU(   2 G  N            N   U      WVS3    _3   G<t#<t
<t
<ti        	:  [^.$   _tIFXTPMDRV-MP-SEG32 v0.95 Copyright 2005, Infineon Technologies   QSR  .   .   3f.   f%  Ƈ  Ƈ  fǇ  J '     u#  f u   f u3P9   X   Z[YfQfSR3.     f t	   3   Zf[fYfQfRfS      f%    f             f3f[fZfYfQfRS          f%      .     .   u .    3     R   Q  .   t	  >   5     
  0  f t   u
  f JK   f u?   j
     `
    $u
   <
    $u
   (
  f3[fZfYÜVRSQW3f ?  f   5  ލ,  f 3f fǇ0    z  f W  f3ۊ  f@  ff ,      (  Gf \   57  4$f f+ffI߇Gf( \   5U  4$f( f+ffI߇Gf	 \   5~  4$f	 f+ffI߇Gf5  4$fG5  4$GffJrZ5  4$f5  4$5  4$G5  4$G5  4$G5  4$3
f f _Y[Z^<t.!   f3fRfQf%  ff`fʊfʰafʊff3fYfZfRQfSf%  ff+  ff<u9ff<u+ff<t<uff< uf3f 
f	 f  Cff[YfZfRfQf%  ff!`ffʰaffʰ f tf f3fYfZfRfQf3  fs*f fd f   f3   fs
fJuf f3fYfZfRfQf%  ff0ff3tf f ff3fYfZfRfQf%  ff&ff3f%  fʰ'ff%  ff3fYfZfRfQf%  ffpfʀfʰqfʊff3fYfZR.   ff3t2f2ff3ZR.   fZ VSRQf       	       fǇ0    tw> tr~ tl~ tf~ t`   ֋N^63f  f;s  uf
 4    f u  f u	2   f 
f f fǇ0    fظ   o  3fYZ[^QVSRf3ҷ  f      f      fu  f 8     fu  f   fuB&  f   f             $3   fu   f   f    @ pf	u    f   f um@   Jfu
o  :f
uJ)  f uf S  d  f uTƀtMt$8  2D$t$++ȋt$  '  f uƀt  f u      f  Z[^YVQt$L$	  f u	t$f3 Y^SRQf3F      f u7t      f u"3Ɋ    tff t  YZ[SQfR    3f  t tf;sf          fZY[fSQV3f 5    f uv  ^Yf[fSQ  Ƈ          Yf[fSQV3f 5  (  ^Yf[fSQVR    fS      f3ۈ    3f 5     f[  Z^Yf[fSQVR<    fS       f3ۈ  Ƈ  3f 5     .      f[  Z^Yf[fRfS     ff     f t     f f[fZfRfS     ff t   f t   g  f f[fZRfSf2 f  K   f u.   f nf3
f f f[Zf3f sf f f3f fRfQfrf
   fr
fJuf f3fYfZ RQ3Ҋ    t   f uOf        ;w(     f u  f t  f f YZS  s   f u+    frfrtDtt*<f :f 4f .؀f t#f t؀@f t
f	 tf
 [fSQV3f 5  ;   ^Yf[fSQV3f 5     f u5  f% tf ^Yf[RfSQf2 f {f u.   flf3
f f Yf[ZRf2 f A2f u.   fff3f Z QVR3f 5  ,  3f+HHdf u  c   f t	   f3Z^YQRS3f  .   7   f tZf tf f3[ZYf3Yf f sf3f3Bff rf3 Q."   tf  uf3   f      fr   fsfIuf3fP   m   fX."   tfYfPfSfQ."   tfC   fB   0   f '   fsfIu   ."   tffYf[fXp$
pqfSfp$
pfqf[.    tUf tJ   Y   fs
   3      9   fr
      3'     S'     [S'  #   [Ë%  t     %  t  '  $IFXTPMz       $IFXTPMFidk                                                                                                $IFXTPMBuf                                                                                                                                              f   ff   2fff   ff3.7tZf.;|u.Dtf   f   f30fy   f  f\0fnf30f   f3f30f   f   2"2B     9                               &`"L1^9M|ȵ-M0%V\FWFVՄI/N#~j0
\3GVcz7PAF
͹"MWa
&i,#,γŔ(4İٖD'9m	yι7sM'pUgrDkA[JN

΂5hqYTV?z2oKqYs!Ј]vFwl|g<۲^пIS!A w`J_
s
	_KPP{V+{+~6ooXi(?>ֻ>aPU|G)XbHc!d[bcSy,\ޜ~N
_Y
(V,HgRQк'XS#@K^alf\г EW"YFh&}=tU@	5syz[s~q]To,M[
$+X)f7ꛮm$TȪ~%<?ԐBR4Fvc߬znuNax$iZDxoI:'0"֖߫S-ӭa;ya
"|4'",wK(`sRO8YZD۩|;ȱ84h$]DVJ^:F]^H.jc@> >޿K8f^ u.I(֜SM8rն{~Z/,ATOk@**El_}#	;l}(QS[!8}TeiԔv2ʄ"y,^묆-+oXÄcXAJ<H_|+f"́&DsKƵ+8l~cr+$@m#%LCh.E"s&7}8emg-ϧKv1T}QR5BaiN*W?[3F	߆1,Hb'EBޒ_s6v>i Iċ"#k/SԋOm#,\䎧ܿT0Hͩc,#rд~!Q^GhMm_[` npkm4R{`Y;/ 2NS\
Ub2y,PP"d1-y(Q
ЯJg q=`*q̼F4-|^ŵ_~ExcJ3'tfW8;("x (,Đ<rC֓Ftu0ls,LS5mWg$EكGf%f9l ڀzFM[9p06LMVP4SX>~?%Jcg~qc6XFO4U*a`ɣe /t-zc`|QMe鎝jz#̗~k\&hFq0l%F#l`;TsC lk+O[>T##G 'j/q>8[6ie>::D#.2" K6ɥ馺t6`6IQO"ɆLb]LE}}cPgҝ靼` U"ܖ6Cg#OJ
j\CidyfuB+^zp~&$`!}_+@P0oBCO3'Oh@ONpU5ه y
T)ئqmո.a8DߗF#7!m
0`/[uٓj8ehxy8j
L>GgoO.8g6Ɇ~7GG#2g^	D/W/J	OlKت(x՞s?0I+֧xa}*b>$V{=[u[_6mRn>*YZBn&Z*Oy$$d1rW|/c ,&\>W]~:xjM=я&
/Ը]U"=!9a!Cʄ1Fp.\^7\lUI#ȆN
%â)-)Cdg*cFQ׾F'E7lU\=|8|5embBA$!}!4o|4řb??R
)g`t,t.VثbkHdT`pQ_PT<q%툐H.
7SVsh:nIs?$jL- D^t6.W?d$xHGʏ\պH|lEk#[{68C~U#+7X
]v&e*%[GDmg*	QIf*W>jLNJXSbZi~`5={
.$	tRbN0z_hTw(# T<NXQ[16;6Ƒ{-tr1Bw8.rXX3HK(͉r.J
%ah5$3~Ԅo,-D#zI7[z;3sD^>$έ^si
Ad9dttQQz@0cZ|f-]>И'?|@ٓN=;Dt~y8`mSѬ7}'CޞK0po/8_ߑ]66Sbu:	Z?xqLGO&jM@cNbBjfo[Z*cs$ʻ߆g70N]Ɯ~h	.HyWٞ21<AbZĜqZC(}dq[eTsٹYqލ@nP.BU"z(Qb[ pE0GH	ѿ2Ƭ񃄗Sf	wS:}$AL.M4Ys%ȯH0[׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   T      fp                        c~l݁|TL3cOE1@HJCI'>zηן+H?.
Wynl,,>"D:2)y-zf܉t	=]]%>|QlR(ݖR!kV>
Ky!gx|8<ޱd'C5%LK&t3`(.lHwKCG@Y*\.Ɯ)Efed%*B<fw\lu	`#_i2l Z0)3%>{u?2aC×)R'Y:ʞ!Wˊ?ZȺ0*Нm$Wꯒ@j;S
 pƯ=eUix~;dڋ7 ؟vkndX̠\\Y_8g7tuȦYd(1Iք|+<Z-J+\e25[,57-閔 7xRC1i\L %
8/lLjۇ+sԄjP5,HdsKJs$֑{k(!-w?n=1 Vc	S/TORu.M7ԛ'
ܩm <k@9 G<9N퍥5)4i<u3(A\8 	nW !;aS>~<JVüC#3㛟0נn?Ê*:ES'G3ޚ`Wؾ#Qx9v=QMH][.3t;aN 脓7l,(a4Bb2 VuFW82
֞4?&,Sr A0-pjۼ;AOsN"m[to_ց=h%CKQW6ή+.
cV?H&+u>G(^*"mxuwĠoo)&@R+<{ug	Ҹ3NcRf^Hōփ~Hޤ" ts<MkfXc퇪ws9P'ܛoj3k8XN5w}4{01*߼Q\Y@^	A2/4^AO._c̡;ͨ:ߒZ.[W4C
`N XiK_denЄ9#CL8%|Us6 7[(AV
,0gDx&8<Q&_'W)9ȴ\Gc4>Ȩۀam!KN!M_X=2th(dn9O'|^J»l!"=1܅h=/D	C'^Q<@P|>@@V?;Y-b1ɾ
 \FhAX%46)unҮ/1h87C6ʅ|޾LEgŵk]LV64gz/!=)M?+sqZJSJ],)qȱ!>øYx%ok,-29td] 0
nxnZE+zb5mҫf7Q$-"S,(Y(W@Ϯm[L'TY9>JqUna7UgKeJo83T\cp, Wij(X
<euB2I(N-d,0ժ	_>^3졗pLs-ZBǻBѣljs5KJhxF9"ۚcJ!9[w+KXzݷ=6bΫz{܁׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEc
1FCvx=T-~߯ilΘsމ5:nK%aťxC=E$'=?oxlߒ.*?4z7	Iw8WDC{EpfX`*dU8&b/)<TA<E[zd)G5TKQ._Jq2PH SEcx=N,E|n:C'>@1y4VҸ/\b*IIm ʸh+);vKj=~do{>s,[7<[o!	q3$?ūkW$F޲7x]K2ώ|R]j>%ϖJйVXrxEC<ʆM:#CTUŉ9bw 4f>#){~qŖ62B6	%]7LRކ
@d|
}
Xi>'MJ	1ȫw)0,a@oaޒy	ǉ }eûH}_FrJ?)1^,0)oWEt+n#b#
Mf>t_OGzp3	T8fs2dNGdiP &ҍ82ɢjbˇ7ScnkA'vaOΏMi!"r/|׏#&2̴"ت/Powz0!3{[n8}I	b$BJh!fH"PNŗ${	ÊHG?--kqxå^bS,1e!H5fjdjāk1Gu'Jh>*:M<ۿga|hb-
K`8 D%Iɘ,ɯ[5>   6    #  ZU                        @-w`VM|RJ O9/byOWه#2KجPꆜU˝_2:HB["0#huM4˝'<Ÿ[_Ŷ[IA1|[dKF.Ɠ<jp>`3iFݟ
a+mQ fF;"	 Sҝ iu*A [`Z\]4 \]8
M̒_]+ۊod
U	g|J#	jMè|(B楌ͼ]CMz˂u3Z&daQs;[F,D~s;DZ6ݩl#Fw]@I=.ُ7	(9RżҷĜ qg(	P*1"8Yr-mfjt։:ZjͲ6xͨS!kJ`~
P+;|N 6_qRnq	>!ctydBggٖ\U6)
ۙ!	s9|ct{ 8_nm]vJgfBdᇙMÕ,ԯչ)Z!&"<iJ4B"dUfBSjDl'	ܚ= ;AJU"# P5J&W}zQB4JһN1'ĉ$\O4Ru<y
2Cƕ.}k82NBG?kTHJR#ϗi+2EEչba^!(ySns
lIЇ2̟&4؊EEwzg@DȻ3{xR2e$$Gxbp.IW=)0L5uatWx@ϻQ
@Rx@Pl&ݩd|];λ;i(cs?Z2놫mJ;})Ӹ_캸LC'~e0}ހ._'dߧ4s*C`O6҈T
UP;`j0Z)=#Xr2
OWH
ty"!RE%T#4m?̗57`|6	
zO`_P|mi!h9hZv᯸; &Dtwt,:%9>-VG%.Ro7[>[''<Bw<zi_>.$xD7{וs 8-慪 {U*\.hCc6+32ѹ	qL>ρ.ů,CpTÃ7iG׮q7Ժ_
φ6׭(>Ӌ:itӨÓwPz
(qMaHiEb拉]+E_f34=do:Fckb\A
?&XO,}'9lŹI؉Cpf﹈LSJ6l0N]+9k+d=>!S<o786Texa
C^wiږAvcov~Bq兦(RR*""J(b}ڬ4+>":Cf=,fݬ:NRK~";+50%`W~Q \(z=يE+
o	XuM驤Taфяjcw+wW)K&HD2>e7RՀ0yAf9w@,[2
V>-3p^3e
e\ˉR.Ռ-\n2iK"C;&|8hI$ZTK6Ҝĕe`=29H 30j;/:LoF8,.>~iue$Cft<~wԀR3$rN]a1oXҵD_ɤojяOu	d;S2`/|Swa	Fi6_4$Mp'B}3Tɉ5UL,0VJyvMΖ@GXT7UzF؋hKAWl.'!kkdt
m2\1h\)
<^V6D";m*]}ъpqz~n}*~[.	iwJ`<%O;m[m]SH<pצH/%ӐEL НHD"CPn o)4҆A#SWRK*H^0
x寑|i.4EDE޲0r-'_Q1c&h&Zw rDQL}xuv/KN@i(a6#ǢR/
-)ƵpnwcC{w҉ZOm_FQ?Ɇ
嚠93HmRf \'sAϊ;ХӋYzǞb0Bk+-!@^o7Mڞ۹O0`/~Y%ie7{wNM`Rgd'<ާ%pbR9qg+
	!L
j@ՋZ%raAR}rL,37Ydkj\"%"hX#-FQj =m
+v&Lq pْks]j}'l;	>q֚Mѹeޔ7"s',LI_{+N٣ÚIGӓ	Tvt+FHv(js ΆkV^`7?1GǻϗEIc5]	ǲ5oDM拆}
uҋQ7*cz`n?Ĝs{ou*!Pݕc~XT3a֒53n 1q#Dd7\](".m>PFn&UԜlJP/aCZc׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   H      }                        #=Byf[WsgqF oy|.'E6=3zToh@ǿyc'խBKSCT<ң]坆峮|	n+UnujrY$>ii[bcamuP35&Rʟt;)+E*%}0!`2Qn_RK~RoE@ɟuXV@|ɞRMߑkFƺ9uK@ay5q]{D 
+W;1Ucʹ8Hza4	L*♀6qTy}9ASƶƒO*BJH
݊c)<LƙCmR5lsErrmYڠW3ϑ/FH{yj&'4ɴl1ܿ3ڼg8BjNƒbȏVK
2M73@q=BC
ނsc2H7\>'So7ۢtv
uCapQ {qżs^jJ8ꧾ3#o1rf&ɱ2ȧ/QEʼq!
K,s<ɂ@eʱ۔Qd.}U
i( 
ٜ9frFˑTFm"򦉝z17ԇ%IJ}Тd'5JP˭$;?.Vσn/<%$Y-@.DUCRIMDwG	UR eE;Q(M^;|aRΘ8.^H4 tJc48w<$jk2M.g|5z߂JaAbS.˶G]ZzȜxH4q;!xND35p@Hnj;g4Ȭ0ϺYOeYɚ\i@d4
NV'H4W77s^:R	KaWyƀ]MC@E~b}>j?cԓTa5ovJ/G{?̡0&{er:_1ove3˃wh8 fˡO@Ζn6B&]Uy]hUV*ML缟JP<<DD蕋Z
=*)!Nh8&6FD# ml2p?OP=.66'Mp~*3k+:R%zF5\	f6=?x1VYvv~a}a,HQmRݜzNo.^A4Wd22:>qUK+PK?~$4WSTtD|"2D!/2n>p\5)mpTgrK<D}-i'"g/,wpr9{HW9М :t K*Tv$2lOwy{]% n"C9M(c *3CI6@c?/f*bK@
?[kM8t˓:w<%{"pA#J91FLMv')\xm;{aPPVnMA2ARl;4!ZɽX-K6%FV/;&͌yӃ%12u?hK͇Dn*"I0BeM7f	ߣ4Sm"o o=ేFȲ1w0{+*K;Wk6ƣ(IۀAl2Upa{E6,.\JiզBu%y
g38Ya5&R&md.y"gnM |x@w /J˦F0lҥo&z5iQ0&#N4^A6a;Qu%/RuWeG+WgVR+F`Z]s8x V[-T>H_
O};w]kwȒobm 2M\:p
x{xdCG:L_ ;KmojŘ:fd<.*e %@b1یyq骾Ǔ@W(C!ΪZDkb3LQ2 grG&^Z"E((XW*s5:MC[˪[G|5lױ/?`2V25V!F3*,$~M#r\,C3`W!.|VC2^J
><Xpnm܌x4#jftXzn6;A:cóݺcU 'tZnK#wp<3ȗINN؁syoSuQQS\GKxAClcb!?#{%WB:F-HlܐPGt} 8{)7F79y|c{I^You8WKނ97og, buJ&vza;p

t良/^e5N2f<ߤa'F=$բWp
]&uUސ99
\0I9<ѳNГn):}z

k<to]'A})L*~_x7BiVsQTW|z};3!lR[1[NKIKʐɰ]Sm2l[Hqp-jGɺ`d5IZjYUŸf#o ݸR`&6pжF-@K)	 "/`FTd	1a-9MǅZoxGQʍG!#P+|RJG1dUӋr֭EmE
TQlL	J0ۿdB۞PZsv]JF)׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H       fffsf fsf f
   fffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsffffsf fsf f
   ffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf f  tf3f)U  fsf 9r!f   tf   fLU  fsf f~fsf fsfff%   ff  g.02fU  fsf vrgfU  fsf  rRfU  fsf 8r=fU  fsf gr(fU  fsf rfU  fsf f fsff@Cg&;f(V  fsf f;V  fsf f   u
tsf fsffoV  fsf Rf@Cg&;fV  fsf zf   tt"ssŀ2ɀ@v8sfV  fsf  f@Cg&;f fsfs退@s,fW  fsf  f@Cg&;f fsfrBfQW  fsf pfdW  fsf  f   uf   t
f fsfr'@s+fW  fsf f@Cg&;f fsf$fAg&$;g&$;fBf u
g&'g&'g&f fsffffsf fsf f$Agf&;@gf&$;f3f tf@f   ufAg&fffffsf fsf f   gf&gf&   f~fsfBgf&f uff~fsf fsf猸N匋 f
   "猸N匋f   fY  fsf f   uf  g&t猸N匋f>Y  fsf 猸N匋fgY  fsf 猸N匋fY  fsf 猸N匋fY  fsf fY  fsf 猸N匋fY  fsf A	o猸N匋fZ  fsf o	F猸	N匋f@Z  fsf 	猸N匋fiZ  fsf U猸N匋fZ  fsf 猸N匋fZ  fsf *猸N匋fZ  fsf y猸N匋f
[  fsf P猸N匋f3f9[  fsf $猸N匋fb[  fsf f|[  fsf C
f: f	"f   f[  fsf f   uf  g&tfffsf fsf f   f   f \  fsf f~fsf\  fsf 
A猸N匋f4Lf  gf&f Lgf&fff,  g.fLg&g&'g&f\  fsf (1猸N匋f\  fsf 
猸N匋f\  fsf 	猸 N匋f\  fsf _i猸!N匋f]  fsf 猸"N匋f?]  fsf 猸#N匋fa]  fsf 猸$N匋f]  fsf u猸%N匋f]  fsf !猸&N匋f]  fsf "猸'N匋f]  fsf G猸(N匋f^  fsf  猸)N匋f-^  fsf &猸0N匋f   ufX^  fsf "猸1N匋fz^  fsf !猸2N匋f^  fsf &猸3N匋Ћ猸4N匋f^  fsf &猸5N匋f^  fsf 猸6N匋f_  fsf &猸7N匋f3_  fsf "'猸N匋 f%"f   t
fC1'1焋儺N匋f  f_  fsf tv$f  f_  fsf f  f_  fsf f  f_  fsf tf  f    ff   ff  fIuf  f(`  fsf 4f fsff   f  ff   fb`  fsf tff   f`  fsf Gf   tff̀   f Ag&u\f`  fsf %r8u=f`  fsf %u$f3f   u
ffuf  tf fsffLg&   f  tfOg& t'f   tfOg& tfOg& f  f{a  fsf $f  fa  fsf f  fa  fsf f  fa  fsf f  f    ff   ff  fIu fLg&  f fsff   fuff/b  fsf $t,fMb  fsf g$8uf   uffuf fsfff   ftfb  fsf $$tf@ff  uf fsfff   ftIfb  fsf #$<t,<t2fc  fsf #uf	ff	ff  uf fsfff   ft+
fVc  fsf ^#<t<tf
ff
ff  uf fsf8f   ftfc  fsf 
#t"ff  uf  tuf fsffffsf fsf ff @  f   fd  fsf h$t5<w&t<u ff @  ff    ff f:  f~fsfffsf fsf ff   f fd  fsf "2ff fff+ff4  g.fd  fsf !<  ff `  ffg.:w%g.Ffe  fsf !<  g.:Gv;fffcff `  f    f;thff `  ffff  "ffftfu	f   	f    fe  fsf 'f~fsf fsff3f@  ff `  f
fg.ff   2ff   f   ft6ff  fsf  < tff8fsftff  uffff fsff3f@  ff `  f
fg.ff   2ff   ft,ff  fsf  < t8sfwff  uff ff fsff3f@  ff `  f
fg.ff   2ff   ft,f3g  fsf < t8sfwff  uffff fsff   f    ft*fg  fsf $t<s
f   <tff  ufff fsff   ftfg  fsf uff  uf fsffffsf fsf f3f@  ff `  f
fg.ff   2ff   ft,$fwh  fsf =< t8sfw$ff  uf~fsffff fsffffsf fsf f3f@  ff `  f
fg.ff3f3f3f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t3f   t@ tfҌ  g.;sf3tff  T2fffff  f~fsff fsf3f   fu5f	ftfftf
fC  2ffg.<u f  t2kf  uff  uflj  fsf ,uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsffffsf fsf f   f    f   f%k  fsf f    f    3f   ftfYk  fsf fftfvk  fsf fftfk  fsf fftfk  fsf 8uf Bgf&'gf&f   4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   f~fsf fsffffsf fsf fLf   f3f3ftx2fsl  fsf At	ffffl  fsf <	rLаfl  fsf <
r1$,
	
2g&	ff  rf~fsff fsff   fm  fsf d稀uxf   f   f   tf    f   f    f   f   f  uf3f   uf   f   uf3 f   u|f   tf   f   f   tf   uVf   f   Hf   f   f  uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsffffsf fsf fLf3g&f   fu	ffffˌ  fg.f	ftf	f~fsf fsffffsf fsf fffsf fsf f3fLg&'sf   f   fo  fsf f%   f	ff Lgf&ffft
ft f Lgf&ff%ff  ff% `  f
ffff; ffgf&f L fffsf fsf f  fo  fsf $f  fo  fsf nf~fsfgf&fff   gf&f   gf&'jf~fsf~fsf fsffffsf fsf f Lgf&fff Lgf&fpfff  ftf  fthfp  fsf {f Lgf&fff{  tff  t+f Lgf&fpfffq  fsf f~fsf fsff|Cg&'g&fCg&'g&f`Cg&'g&flCg&' fCg&' fq  fsf fq  fsf fq  fsf 4f fsffBgf&f   fq  fsf < u	f   u}fr  fsf Zf@Cg&fCg&fBg&$g&_
ó{fAg&G$fAg&_
ócx 5f@Cg& 3fCg& 1fB$g&'g&g&gg&_ fA$g&gg&GfAg&gg&_f$Agf&@fAgf&@f$Agf&'fAgf&'fKgf&f fsffBg&'g& ff% `  f
fc  ffgf.gf.Vf Cf   gf&gf&Ggf&   gf&   ff fsff(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsff30t
0t}f  ffg.fDg&1f
  ffffg.fDg&g.FfDg&f3f{  0t	fffffffsf fsf ffDf   g.g&ff0   fDf   g.g&ff0   f  f~fsff Ef   gf.f@   ffffsf fsf f  ffffsf fsf f   gf.f~fsf~fsf0   ff@tf Efǀ   f{  f   gf.f Dgf&f%f
  gf&f Dgf&   f fsffff8Af   gf.ffAf   gf.f fsffffBf   gf.f fsff   fAg&' fAg&' ft#fffftf  ug&Pg&ff   tfAf  uf fsff@@gf&f0Bgf&f fsffffsf fsf f Agf&gf&'fAgf&gf&'f   tf Agf&   fhw  fsf 
f{w  fsf fw  fsf ff%   ffftfftfffff~fsfffsf fsf ff%   fffffff ffffffAgf&'gf&	fAgf&'gf&	f   ff% `  f= @  ufCfffAgf&'gf&	fAgf&'gf&	fAgf&'gf&  t fAgf&'gf&  t f3f Lg&$<ufff% `  f= @  ufff%   ffg.ڌ  fAgf&'g&	fAgf&'g&	f~fsfffsf fsf f3fff fff8ffff   fff  f
fff   fff `  f @  rf   fAgf&' gf&	fAgf&' gf&	ff% `  2f=    r\tfffsf fsf fLg&%f   ؃ ttKu
fuff~fsffAgf&'?gf&	fAgf&'?gf&	fAgf&'fAgf&'fAgf&f%   f
ff `  f
f  f tfw  ftf,  ff3 f+ff3ff%  ff `  ff  fgf.ffAgf&'   gf&	fAgf&'   gf&	f~fsf fsff$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsffffsf fsf fdAgf&   fAgf&   fLf3g&f   fp~  f~  fffsf fsf f fffˌ  fg.f   uf   t	f   ugf.zg&'gf.:g&'ff	ftf	gf.:g&'ff~fsfffsf fsf ffffό  fg.f	fu$f	gf.>g&ff~fsfffsf fsf if    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsffffsf fsf fff  f~fsfAff%  f   g&t3fAg&f   tf   f~  fsf LՋf   f+~  fsf V֨t	 v  v f   fZ~  fsf f~fsf fsf AAAAAAAAA	AAAfBgf&f%?f
 
  gf&fBgf&gf&gf&Pgf&fBf  ugf&   	gf&   f   ugf&   @	gf&   f  tf$Agf&   f   tfAgf&   f fsffBgf&@@  gf&   ff%f=  tfhAg&gfAg&gfK  ff%   fffhAgf.gf&'  gf&	fAgf&'  gf&	fgf.flAgf&'gf&	fAgf&'gf&	f fsffAg&' gf&0fAg&' g&0f$Agf&   fAgf&   fD@gf& f fsffBgf&'?gf&  fBg&@f Bgf&'gf&  ! f$Bgf&'gf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsff3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f    fŀ   uf   f   tf   fgf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f uf=   u fffsf fsf ff   ffAff~fs@f   tfffsf fsf f   t
 
 fgf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfgf&f~fsf Bgf&'gf&   f   f   tf 8  ffgf&f Bgf&'gf&   fgf&f}ifAf  fffgf.~gf.6g&? tg&g&&fAuf   t2f   uf8tf   tfff fsf AAAAAAAAf Bf   tgf&'gf&   fӄ  fsf 1f@@gf&'f0Bgf&'f8Bgf&'gf& f fsffAf   tg&f   tg&fAf   tg&f   tg&f fsff   uf   f   f Agf&'gf&	fAgf&'gf&	f fsff Bgf&   f fsff Dgf&'f fsffBgf&   fDgf&f Dgf&   f   f(  fsf Y<twf Bg&$uf Dgf&`f fsff  fn  fsf $f  f  fsf f fsf fŀ   u<f fsffffsf fsf  fff.0ffH $ttf~fsf fsf䐕 	
P`=P0E       I   &&&&&&&&""""""""333333333333333333333333DDDDDDDDDDDDDDDDDDDD        """""                                  DD D DDDDD D D DDDDD D DDD D DDDDD D D DDDDD D DDDDDDD D  DDDDDD D  D DDDDDDDD D  DDDDDD D  D DD3333 3333 3333 3333 3333DDDD DDDD DDDD DDDD DDDD    " " " " "                                                                		


 "$&(*-049		



!#&)-159?


!#%')(*,.02 !"#$%&'()+-/13579;=  	

	

 	
	



"%(+/258;>>>>>>		


"%(+/258;>>>>>>		


 "$&(*-049		



!#&)-159?                                                                                                    @                               "3D  , 0  @  P   P Q  P U  P      P    P       P    P       Pfffsf fsf f Lgf&ffff% `  f
f;|ff% `  ff% `  fff~fsf fsffffsf fsf 
f  f  fsf w3f   f   fsf $< t<tM<t! <sfNgf&f   t&f   fN  fsf 3$p2<u f   ft  fsf 
Ɗ< ufLg&'fNgf&f   uc   ff% `  f= @   f=    tf Lgf&f#f Lgf&ffufLg&'fu_f   f  fsf f
   fffsf fsf ff   fR  fsf Qf~fsf  ft  fsf %f  f  fsf Yó fNgf&f   t@&f   fď  fsf $p2<uf  f  fsf $
f  f  fsf Uf  f   fsf aĳ

f  f=  fsf Àf  fY  fsf Àf  fu  fsf f~fsf fsfnnfLg&nHM	. hῺ! jǐ {Ԑ f3n          D  @    L      @       H   H       `       T  
$   	L 	L!	> @
$  	>  	L  	L         		       
H@,@      ā    Ё    (            $    (    4    8           @      
B  
B 
B0 T     T    T0 !   L     L    L0    D    P   X     `  D    X      P    h     `               	 J             
  @      I         	  	4@	04
    	' 
 
> 
H> 
> 
N> 4    	1 	 4	$	  	  	  	  	 
D1 
B1e 
# 	P 	          @  4 $       	4		 		0   4      @ 	
. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L  	          0      4p                                             d  ` h   X  '      @@       A   \   Z 	  X 	     ? \   Z 	  X 	     ? \   Z 	  X 	     ?                                        '     >       8       ,Bl      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N    T           0           N U N 0 O Q  N 7 O  N  <f@Hf%f  $f$
tppqtwffupppppqffupppppqf  f  gffLggf^gfngnff   f fupppppq ؎gf
  fMf6Rfupppppqg-  f_)ffoff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = ufvf f'af %  fCEfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰fڛf䎊ffff掺<uf"ff,<>  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ怺Nf gf&   ufT  g&'g& ^@'f3
fם  i t
^
ppq<&uf  $f$
tpqq$q
p&q+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  $f$
а f  $f$
и f  $f$
аf  $f$
аf  $f$
и<f  ff| ff  @$f@$
= uQf  ff ff4g&`g&&g&f  H$fH$
и f  L$fL$
а08fffUN&N䄰`O'N䄰ON8tf  ff9 ff  ffL f N U
BJ<Zt. U
BJ<Z B0JBJU0
BJ<Z0BTJ1BJ2BJ3BJ4BJ5BJ7BJ B$JB$J&B J'B JB$JBJ(B J$BJLN33LN3N BJ<uj"BJ&BJ)BJBJ`BJaB8J0BJ)BJt8B B tf  ff    f8ffff  
9f gf&   uۘfء  8對 f    < tgfSf  g&  u
gf&>uf[          68YGU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    焋猰怺N匋 s/1 f    QsY 焋猰怺N匋f=  ff0  f   tf ff=  rfBY 焋猰怺N匋Yf3gC;f3f   焋猰怺N匋[fHrHf f焋猰怺N匋儰f焋猰怺N匋rfFf   f   r% 焋猰怺N匋(s 撰焋猰怺N匋3.&f  f   f焋猰怺N匋fSj(f[f   f   3f   f  焋猰怺N匋g&7(fFfCg焋猰怺N匋o&fPfSfQf   fQf3یff=  fYsfYf[fXSgu=  ;u[fPfSfQfRfWf   f3یff=  	 pfBf   ;f3g}=    fg=  r%fG;wg}=  f_fZfYf[fX                                   	            !      0p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  )C vZ[XPSR -Z[XPSR  )C v
 -Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
ɈD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4
 f`  fg&Ft+vugf&>tgf&6f٢
ɰ &f+~f^Y[fXPSRfV tA % g&ƅ    f[  \g&  	uf^Z[XPSRfV tA % g&ƅ    f[  g&  	uf^Z[XPSR   *  *Z[XSR  :'C vZ[PSRRZZ[XÃ<t  *  g*  q*PRt)t<ZXfPfSQfRV%&  &f3۹ f   gfdT gfdTgfdTgfdTf   &"UC v )  8 c&qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  %fA vY[fXf` f;.t
f. b%  >%$C vf3 
 f    fgf&E   > uF f;  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f[   <  f  g&"  @v@ g&  s f  >
 u&g&.  ug&.  ug&/  uD
f^Z[XÃ t                          /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     L    焋猰怺N匋儽sy焋猰怺N匋儽İffffQðff+9ffH f%"ff
	İfif)f5Sf ASİfM;fWðfc%f f
   `"	f   f3f30f  0ffyf   f f    0f  f f   0fffP  0f  f   f    0f  f f   0	 f%"flfMf.Lf.@ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.Rf.Ff  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
              p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v9p f;  )G f  !ɸfaPSQV܋L	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 
f69ɻ1js>
t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&
gF
&ɻ1sw>
taf`f0  gF
$&
gF
&ɻ1s@f  g&|5  t>
tVfarfWr<f_    f`f	ߴf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>	߹ gf&D5 gf&fff>	fXYsufa`f  &ɹ gF
$
gF
f  1sF>
tma        PȎf   @w> ttus>     >rfg   ( r  Z>Qff@>7fffrfff> wf   >ff%fAfff> trf> wf   >F>,'q>hff   fJ>A0>'>
ff  > ff'f6r$fff> trf> wѰf     F >uug>u`R D>u=/>u(f 
-  >	r  H
s 撰t Xo~.HgHV\qfSgef[gefPfR>u
.fZfXfSfR$$8u4@fZf[P$4XfPfSfRf@
 > u= 4tfsfZf[fXË.uIsfZf[fXPR tċZXfSfRf@
 > uA :H@ts*؃,-@us.fZf[R쨜u	u
sZ           `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva3k f
   `"	f3f3f   0 f%"	@ ttu!  
 s3ig&+g&ô b uR Zts+R Z<u+R Z<u<uR  ZfSf/ g;xxf[ú          Tf-  ?   fA  +   fU     fi    f   fHt	f쨎tf<w' H$tt
ffPf fЀfXfPRf%  0fZfXfPg& g&gf&{gf&CXg&Cg&CXg&Cg&Cg&#sPR$ZXPR$ZXPRs$ZXPReZXgfgfgfgf&G^f  f  gf{Tg&s g&C   PHR                       "                               @  
     @  
 Uf`ircgf&=  f  gf&f  fffFffFff^fF   f  fü  f^fF   faUf`f  / gf&Fp  gf&F    gf&F`  fgf&~f  gf.>f  fffFffFff~fF   f   fǰ  f~fF   fVf   f  fVf  0 f    gf&f^f   f  f    <ff  0 f   gf&f^f   f  f~fF"   fF   3f~gf ulfVfOLPHsf  . ff  ! f  ! f   f  ff4 0  gf&f^f   f  f~fF"   fF    f  g&]
  t
ucgf&  f% f   uLf   f  f~fF   fF   g f   f  f~fF   fF   A faú`U` B<u(``B`apB`0B`f` f"(  ؎Њf      f%" 3؎faUf`f   f"  ؎ff3Ҍffh fS  fPg6D* gf6|*fg6l* f%" 3؎ffa          f`ffWgfǃ  #Eggfǃ  gfǃ  ܺgfǃ  vT2gfǃ  gf  gƃ   g  u	f@w4  f@f@f_gf   gffgffaf`fQgf;gdg&fGfXf7   f;wf+f@   f+f7g  f3ggf  fffgffgf&faf@   g  tf@gf3g  gf   f` gffgf@ ffgffgf3fgf3fgf3fgf@rfaf`gf  gf  f   gf3fSgf  gf  gf  wff#ff#ffyZ?'wf3f3fn,;wfPf#f#ffXf#ffܼf3f3fbf[gf  fgf   gf  fffPgf  gf  gf  gf  gf  fgf  gf  gf  fXgf  AP
gf  gf   gfgf&ffa  fPfSfQfR3f  @f  $f$
f  ܺ$f$
ЋfZfYf[fXfPfRfS3,f @9f  $f$
؃f  ܺ$f$
Ћf[fZfXfSfW3f3f  Bg&cg&C
uf_f[ZTjP.>u.  t. .6XðR ǺZR úZR źZR ZR ĺZP\R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X               .+V.-^ð@ ð  fSfQfWf3f>t	f  se>tf  rf  sJg&C g&Cf  @<@tf  G .f   f  G 	f  W g&s g&C f_fYf[fSfQf3>t	f  sK>tf  rf  s0g&C g&Cf  @f  g@<tg&s g&C fYf[fSfQf3^>t	f  sk>tf  rf  sPff?g&Lg&D<?u9g&C g&Cg&Kf  @fg@?fg&s g&C fYf[ f  / f  fPQgf0f  f    n YfXf    fPSfRff  ! gf&V2gf&;Ftg&~ u
u
gf&vfgf&NfZ[fXgf~gfNgfVgffPfSfQfW<w#f.
tfsf_fYf[fX焋猰怺N匋fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fXfQfWfVf @  f   f  gff^f_fYfQfWfVf   f    f  gff^f_fY                           0 ] PS㋇[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $   g  \  Q[XR # 1 ZSQW   _Y[SQW   _Y[SQW   _Y[   PUN
NNOపNzXfPR3t3$UNN<Uu#NNO<u N҉ZfXfPQRU0
BJ<ZuW0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$w u-@u&UNN<Uu$NNO<u Nu3҉t;B B t	 ZYfXPRt ZX               焋猰怺N匋3ظ  м{ $ffަf]f˦ff鸦f)                                           Q  YPSR+;wZ[Xf> tftf`f  
tf  f    f3f3f3f @ gfffCgftftfaf   {fuQYfVfSfQf=  f   frffYf[f^          fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     2ø       @     e07/28/06YUGj  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        